/*
 * SPDX-FileCopyrightText: 2023-2025 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#pragma once

// *INDENT-OFF*

#include "drivers/esp_panel_drivers_conf_internal.h"

#ifndef ESP_PANEL_DRIVERS_INCLUDE_INSIDE
    /*
    * Define the driver configuration
    */
    #ifndef ESP_PANEL_DRIVERS_BACKLIGHT_USE_ALL
        #ifdef CONFIG_ESP_PANEL_DRIVERS_BACKLIGHT_USE_ALL
            #define ESP_PANEL_DRIVERS_BACKLIGHT_USE_ALL CONFIG_ESP_PANEL_DRIVERS_BACKLIGHT_USE_ALL
        #else
            #define ESP_PANEL_DRIVERS_BACKLIGHT_USE_ALL (0)
        #endif
    #endif

    #if ESP_PANEL_DRIVERS_BACKLIGHT_USE_ALL
        #define ESP_PANEL_DRIVERS_BACKLIGHT_USE_SWITCH_GPIO     (1)
        #define ESP_PANEL_DRIVERS_BACKLIGHT_USE_SWITCH_EXPANDER (1)
        #define ESP_PANEL_DRIVERS_BACKLIGHT_USE_PWM_LEDC        (1)
        #define ESP_PANEL_DRIVERS_BACKLIGHT_USE_CUSTOM          (1)
    #else
        #ifndef ESP_PANEL_DRIVERS_BACKLIGHT_USE_SWITCH_GPIO
            #ifdef CONFIG_ESP_PANEL_DRIVERS_BACKLIGHT_USE_SWITCH_GPIO
                #define ESP_PANEL_DRIVERS_BACKLIGHT_USE_SWITCH_GPIO CONFIG_ESP_PANEL_DRIVERS_BACKLIGHT_USE_SWITCH_GPIO
            #else
                #define ESP_PANEL_DRIVERS_BACKLIGHT_USE_SWITCH_GPIO (0)
            #endif
        #endif

        #ifndef ESP_PANEL_DRIVERS_BACKLIGHT_USE_SWITCH_EXPANDER
            #ifdef CONFIG_ESP_PANEL_DRIVERS_BACKLIGHT_USE_SWITCH_EXPANDER
                #define ESP_PANEL_DRIVERS_BACKLIGHT_USE_SWITCH_EXPANDER CONFIG_ESP_PANEL_DRIVERS_BACKLIGHT_USE_SWITCH_EXPANDER
            #else
                #define ESP_PANEL_DRIVERS_BACKLIGHT_USE_SWITCH_EXPANDER (0)
            #endif
        #endif

        #ifndef ESP_PANEL_DRIVERS_BACKLIGHT_USE_PWM_LEDC
            #ifdef CONFIG_ESP_PANEL_DRIVERS_BACKLIGHT_USE_PWM_LEDC
                #define ESP_PANEL_DRIVERS_BACKLIGHT_USE_PWM_LEDC CONFIG_ESP_PANEL_DRIVERS_BACKLIGHT_USE_PWM_LEDC
            #else
                #define ESP_PANEL_DRIVERS_BACKLIGHT_USE_PWM_LEDC (0)
            #endif
        #endif

        #ifndef ESP_PANEL_DRIVERS_BACKLIGHT_USE_CUSTOM
            #ifdef CONFIG_ESP_PANEL_DRIVERS_BACKLIGHT_USE_CUSTOM
                #define ESP_PANEL_DRIVERS_BACKLIGHT_USE_CUSTOM CONFIG_ESP_PANEL_DRIVERS_BACKLIGHT_USE_CUSTOM
            #else
                #define ESP_PANEL_DRIVERS_BACKLIGHT_USE_CUSTOM (0)
            #endif
        #endif
    #endif // ESP_PANEL_DRIVERS_BACKLIGHT_USE_ALL

    #ifndef ESP_PANEL_DRIVERS_BACKLIGHT_COMPILE_UNUSED_DRIVERS
        #ifdef CONFIG_ESP_PANEL_DRIVERS_BACKLIGHT_COMPILE_UNUSED_DRIVERS
            #define ESP_PANEL_DRIVERS_BACKLIGHT_COMPILE_UNUSED_DRIVERS CONFIG_ESP_PANEL_DRIVERS_BACKLIGHT_COMPILE_UNUSED_DRIVERS
        #else
            #define ESP_PANEL_DRIVERS_BACKLIGHT_COMPILE_UNUSED_DRIVERS (0)
        #endif
    #endif
#endif // ESP_PANEL_DRIVERS_INCLUDE_INSIDE

/*
* Enable the driver if it is used or if the compile unused drivers is enabled
*/
#ifndef ESP_PANEL_DRIVERS_BACKLIGHT_ENABLE_SWITCH_GPIO
    #if ESP_PANEL_DRIVERS_BACKLIGHT_COMPILE_UNUSED_DRIVERS || ESP_PANEL_DRIVERS_BACKLIGHT_USE_SWITCH_GPIO
        #define ESP_PANEL_DRIVERS_BACKLIGHT_ENABLE_SWITCH_GPIO  (1)
    #else
        #define ESP_PANEL_DRIVERS_BACKLIGHT_ENABLE_SWITCH_GPIO  (0)
    #endif
#endif

#ifndef ESP_PANEL_DRIVERS_BACKLIGHT_ENABLE_SWITCH_EXPANDER
    #if ESP_PANEL_DRIVERS_BACKLIGHT_COMPILE_UNUSED_DRIVERS || ESP_PANEL_DRIVERS_BACKLIGHT_USE_SWITCH_EXPANDER
        #define ESP_PANEL_DRIVERS_BACKLIGHT_ENABLE_SWITCH_EXPANDER  (1)
    #else
        #define ESP_PANEL_DRIVERS_BACKLIGHT_ENABLE_SWITCH_EXPANDER  (0)
    #endif
#endif

#ifndef ESP_PANEL_DRIVERS_BACKLIGHT_ENABLE_PWM_LEDC
    #if ESP_PANEL_DRIVERS_BACKLIGHT_COMPILE_UNUSED_DRIVERS || ESP_PANEL_DRIVERS_BACKLIGHT_USE_PWM_LEDC
        #define ESP_PANEL_DRIVERS_BACKLIGHT_ENABLE_PWM_LEDC  (1)
    #else
        #define ESP_PANEL_DRIVERS_BACKLIGHT_ENABLE_PWM_LEDC  (0)
    #endif
#endif

#ifndef ESP_PANEL_DRIVERS_BACKLIGHT_ENABLE_CUSTOM
    #if ESP_PANEL_DRIVERS_BACKLIGHT_COMPILE_UNUSED_DRIVERS || ESP_PANEL_DRIVERS_BACKLIGHT_USE_CUSTOM
        #define ESP_PANEL_DRIVERS_BACKLIGHT_ENABLE_CUSTOM  (1)
    #else
        #define ESP_PANEL_DRIVERS_BACKLIGHT_ENABLE_CUSTOM  (0)
    #endif
#endif

// *INDENT-ON*
