/*******************************************************************************
 * Size: 16 px
 * Bpp: 4
 * Opts: --bpp 4 --size 16 --font /home/lvhaiyu/SquareLine/assets/AlimamaShuHeiTi-Bold.ttf -o /home/lvhaiyu/SquareLine/assets/ui_font_AliShuHeTi16sbpp4.c --format lvgl -r 0x20-0x7f --symbols 确认 --no-compress --no-prefilter
 ******************************************************************************/

#include "../ui.h"

#ifndef UI_FONT_ALISHUHETI16SBPP4
#define UI_FONT_ALISHUHETI16SBPP4 1
#endif

#if UI_FONT_ALISHUHETI16SBPP4

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */

    /* U+0021 "!" */
    0x4f, 0xf3, 0x4f, 0xf2, 0x3f, 0xf2, 0x2f, 0xf1,
    0x2f, 0xf0, 0x1f, 0xf0, 0xf, 0xf0, 0x9, 0x80,
    0x3a, 0xa3, 0x5f, 0xf4, 0x5f, 0xf4,

    /* U+0022 "\"" */
    0x3d, 0xc3, 0xdc, 0x2f, 0xd3, 0xfd, 0x1f, 0xc1,
    0xfb, 0xf, 0xa0, 0xfa, 0xe, 0x90, 0xe9,

    /* U+0023 "#" */
    0x0, 0x6f, 0x70, 0x4f, 0x90, 0x0, 0xaf, 0x40,
    0x8f, 0x60, 0xcf, 0xff, 0xff, 0xff, 0xf5, 0x8b,
    0xff, 0xbb, 0xff, 0xb3, 0x2, 0xfc, 0x0, 0xfe,
    0x0, 0x4, 0xfa, 0x2, 0xfc, 0x0, 0x8c, 0xfd,
    0xab, 0xfe, 0xa3, 0xcf, 0xff, 0xff, 0xff, 0xf5,
    0xb, 0xf2, 0x9, 0xf4, 0x0, 0xe, 0xf0, 0xc,
    0xf2, 0x0, 0xf, 0xd0, 0xe, 0xf0, 0x0,

    /* U+0024 "$" */
    0x0, 0x0, 0xe4, 0x0, 0x0, 0x0, 0xe, 0x40,
    0x0, 0x2, 0xbe, 0xff, 0xeb, 0x0, 0xdf, 0xff,
    0xff, 0xe0, 0x1f, 0xf2, 0xe4, 0x2, 0x1, 0xff,
    0x1e, 0x40, 0x0, 0xe, 0xfe, 0xf9, 0x20, 0x0,
    0x3c, 0xff, 0xff, 0xa0, 0x0, 0x1, 0xec, 0xff,
    0x60, 0x0, 0xe, 0x49, 0xf9, 0x14, 0x10, 0xe5,
    0xbf, 0x83, 0xff, 0xff, 0xff, 0xf3, 0x2d, 0xff,
    0xff, 0xd6, 0x0, 0x0, 0xe, 0x40, 0x0, 0x0,
    0x0, 0xe4, 0x0, 0x0, 0x0, 0x3, 0x10, 0x0,

    /* U+0025 "%" */
    0x4, 0xdf, 0xb1, 0x0, 0x7f, 0x60, 0x0, 0xdd,
    0x9f, 0x80, 0x1e, 0xd0, 0x0, 0xf, 0x70, 0xda,
    0x9, 0xf4, 0x0, 0x0, 0xe9, 0xe, 0xa2, 0xfb,
    0x0, 0x0, 0xa, 0xff, 0xf5, 0xbf, 0x20, 0x0,
    0x0, 0x5, 0x73, 0x4f, 0x98, 0xee, 0x70, 0x0,
    0x0, 0xd, 0xe4, 0xfb, 0xbf, 0x10, 0x0, 0x6,
    0xf7, 0x5f, 0x23, 0xf4, 0x0, 0x0, 0xed, 0x6,
    0xf1, 0x2f, 0x40, 0x0, 0x8f, 0x50, 0x3f, 0x9a,
    0xf2, 0x0, 0x1f, 0xb0, 0x0, 0x8e, 0xe7, 0x0,

    /* U+0026 "&" */
    0x0, 0x2b, 0xff, 0xb2, 0x0, 0x0, 0xe, 0xfe,
    0xef, 0xb0, 0x0, 0x1, 0xff, 0x24, 0xfd, 0x0,
    0x0, 0xe, 0xf8, 0xcf, 0x80, 0x0, 0x0, 0x8f,
    0xff, 0x80, 0x43, 0x0, 0x7f, 0xff, 0xf2, 0x3f,
    0xe0, 0x4f, 0xf6, 0xcf, 0xd7, 0xfb, 0x9, 0xfd,
    0x1, 0xef, 0xff, 0x70, 0x8f, 0xe0, 0x5, 0xff,
    0xe0, 0x2, 0xff, 0xeb, 0xff, 0xff, 0x20, 0x3,
    0xcf, 0xfd, 0x89, 0xfd, 0x10,

    /* U+0027 "'" */
    0x3d, 0xc2, 0xfd, 0x1f, 0xc0, 0xfa, 0xe, 0x90,

    /* U+0028 "(" */
    0x0, 0x6a, 0x70, 0x1f, 0xf5, 0x7, 0xfd, 0x0,
    0xef, 0x70, 0x4f, 0xf2, 0x8, 0xfe, 0x0, 0xbf,
    0xb0, 0xc, 0xfa, 0x0, 0xdf, 0xa0, 0xc, 0xfb,
    0x0, 0xaf, 0xd0, 0x6, 0xff, 0x10, 0x1f, 0xf5,
    0x0, 0xbf, 0xb0, 0x4, 0xff, 0x20, 0xb, 0xfa,

    /* U+0029 ")" */
    0x3a, 0x90, 0x0, 0xe, 0xf6, 0x0, 0x7, 0xfe,
    0x0, 0x1, 0xff, 0x40, 0x0, 0xcf, 0xa0, 0x0,
    0x8f, 0xe0, 0x0, 0x5f, 0xf1, 0x0, 0x4f, 0xf3,
    0x0, 0x3f, 0xf3, 0x0, 0x4f, 0xf2, 0x0, 0x7f,
    0xf0, 0x0, 0xaf, 0xd0, 0x0, 0xef, 0x80, 0x5,
    0xff, 0x20, 0xb, 0xfa, 0x0, 0x3f, 0xf2, 0x0,

    /* U+002A "*" */
    0x0, 0x3f, 0x90, 0x0, 0x92, 0xf7, 0x65, 0x5f,
    0xff, 0xff, 0xb1, 0x4c, 0xff, 0x62, 0x5, 0xfb,
    0xfb, 0x0, 0x5e, 0x1a, 0xa0, 0x0, 0x0, 0x0,
    0x0,

    /* U+002B "+" */
    0x0, 0x2, 0x74, 0x0, 0x0, 0x0, 0x6f, 0xa0,
    0x0, 0x0, 0x6, 0xfa, 0x0, 0x0, 0x11, 0x7f,
    0xa1, 0x10, 0x8f, 0xff, 0xff, 0xff, 0xc8, 0xff,
    0xff, 0xff, 0xfc, 0x0, 0x6, 0xfa, 0x0, 0x0,
    0x0, 0x6f, 0xa0, 0x0, 0x0, 0x6, 0xfa, 0x0,
    0x0,

    /* U+002C "," */
    0x3, 0xdc, 0x0, 0x8f, 0xa0, 0xd, 0xf4, 0x1,
    0xfe, 0x0, 0x6f, 0x80, 0x0,

    /* U+002D "-" */
    0xde, 0xee, 0xdf, 0xff, 0xff,

    /* U+002E "." */
    0x7a, 0xab, 0xff, 0xbf, 0xf0,

    /* U+002F "/" */
    0x0, 0x0, 0x7, 0x70, 0x0, 0x0, 0x3f, 0xa0,
    0x0, 0x0, 0x9f, 0x50, 0x0, 0x0, 0xef, 0x0,
    0x0, 0x3, 0xfb, 0x0, 0x0, 0x8, 0xf5, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0x3f, 0xb0, 0x0,
    0x0, 0x8f, 0x60, 0x0, 0x0, 0xdf, 0x10, 0x0,
    0x3, 0xfb, 0x0, 0x0, 0x8, 0xf6, 0x0, 0x0,
    0xd, 0xf1, 0x0, 0x0,

    /* U+0030 "0" */
    0x0, 0x5d, 0xfe, 0x91, 0x0, 0x5f, 0xff, 0xff,
    0xc0, 0xd, 0xfb, 0x5, 0xff, 0x41, 0xff, 0x40,
    0xd, 0xf8, 0x3f, 0xf2, 0x0, 0xaf, 0xa4, 0xff,
    0x10, 0xa, 0xfb, 0x3f, 0xf2, 0x0, 0xaf, 0xa1,
    0xff, 0x40, 0xd, 0xf8, 0xd, 0xfb, 0x5, 0xff,
    0x40, 0x5f, 0xff, 0xff, 0xc0, 0x0, 0x5d, 0xfe,
    0x91, 0x0,

    /* U+0031 "1" */
    0x1, 0x9f, 0xf3, 0x2f, 0xff, 0xf3, 0x4f, 0xbf,
    0xf3, 0x12, 0x3f, 0xf3, 0x0, 0x3f, 0xf3, 0x0,
    0x3f, 0xf3, 0x0, 0x3f, 0xf3, 0x0, 0x3f, 0xf3,
    0x0, 0x3f, 0xf3, 0x0, 0x3f, 0xf3, 0x0, 0x3f,
    0xf3,

    /* U+0032 "2" */
    0x1, 0x9e, 0xfd, 0x91, 0x0, 0xef, 0xff, 0xff,
    0xd0, 0xc, 0x62, 0x29, 0xff, 0x50, 0x0, 0x0,
    0xf, 0xf5, 0x0, 0x0, 0x4, 0xff, 0x20, 0x0,
    0x1, 0xdf, 0x90, 0x0, 0x1, 0xdf, 0xc0, 0x0,
    0x1, 0xdf, 0xc0, 0x0, 0x3, 0xef, 0xa0, 0x0,
    0x1, 0xff, 0xff, 0xff, 0xf7, 0x2f, 0xff, 0xff,
    0xff, 0x70,

    /* U+0033 "3" */
    0x3b, 0xef, 0xd9, 0x10, 0x9f, 0xff, 0xff, 0xb0,
    0x43, 0x0, 0x8f, 0xf0, 0x0, 0x1, 0x9f, 0xd0,
    0xb, 0xff, 0xfd, 0x30, 0x9, 0xde, 0xfe, 0x50,
    0x0, 0x0, 0x5f, 0xf2, 0x0, 0x0, 0xf, 0xf6,
    0x94, 0x10, 0x7f, 0xf5, 0xef, 0xff, 0xff, 0xc0,
    0x6b, 0xef, 0xd8, 0x0,

    /* U+0034 "4" */
    0x0, 0x0, 0x7f, 0xfb, 0x0, 0x0, 0x1f, 0xff,
    0xb0, 0x0, 0x9, 0xff, 0xfb, 0x0, 0x3, 0xfd,
    0xaf, 0xb0, 0x0, 0xcf, 0x49, 0xfb, 0x0, 0x5f,
    0xb0, 0x9f, 0xb0, 0xe, 0xf2, 0x9, 0xfb, 0x6,
    0xff, 0xff, 0xff, 0xfd, 0x6f, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x0, 0xaf, 0xb0, 0x0, 0x0, 0xa,
    0xfb, 0x0,

    /* U+0035 "5" */
    0x6f, 0xff, 0xff, 0xf0, 0x7f, 0xff, 0xff, 0xe0,
    0x7f, 0xe0, 0x0, 0x0, 0x8f, 0xe3, 0x20, 0x0,
    0x8f, 0xff, 0xfe, 0x50, 0x68, 0x55, 0xcf, 0xf2,
    0x0, 0x0, 0xe, 0xf8, 0x0, 0x0, 0xd, 0xf9,
    0x83, 0x0, 0x7f, 0xf6, 0xff, 0xff, 0xff, 0xc0,
    0x8c, 0xef, 0xe8, 0x0,

    /* U+0036 "6" */
    0x0, 0x18, 0xdf, 0xeb, 0x0, 0x1d, 0xff, 0xff,
    0xf0, 0x9, 0xfc, 0x30, 0x2, 0x0, 0xff, 0xbe,
    0xfd, 0x50, 0x2f, 0xff, 0xde, 0xff, 0x23, 0xff,
    0x90, 0xe, 0xf8, 0x3f, 0xf4, 0x0, 0xaf, 0xa1,
    0xff, 0x40, 0xb, 0xfa, 0xc, 0xfb, 0x2, 0xff,
    0x60, 0x5f, 0xff, 0xff, 0xd0, 0x0, 0x6d, 0xfe,
    0xa1, 0x0,

    /* U+0037 "7" */
    0x2f, 0xff, 0xff, 0xff, 0x92, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x6, 0xfe, 0x10, 0x0, 0x1,
    0xff, 0x50, 0x0, 0x0, 0xaf, 0xc0, 0x0, 0x0,
    0x2f, 0xf4, 0x0, 0x0, 0x8, 0xfd, 0x0, 0x0,
    0x0, 0xdf, 0x80, 0x0, 0x0, 0x2f, 0xf3, 0x0,
    0x0, 0x5, 0xff, 0x0, 0x0, 0x0, 0x8f, 0xd0,
    0x0, 0x0,

    /* U+0038 "8" */
    0x0, 0x8d, 0xfe, 0xb3, 0x0, 0xaf, 0xff, 0xff,
    0xf2, 0xe, 0xf7, 0x1, 0xff, 0x60, 0xbf, 0xb5,
    0x7f, 0xf2, 0x1, 0xbf, 0xff, 0xe4, 0x0, 0x6f,
    0xff, 0xff, 0xb0, 0x1f, 0xf8, 0x3, 0xef, 0x84,
    0xff, 0x10, 0xa, 0xfb, 0x3f, 0xf7, 0x2, 0xef,
    0xa0, 0xcf, 0xff, 0xff, 0xf3, 0x1, 0x8d, 0xfe,
    0xb3, 0x0,

    /* U+0039 "9" */
    0x0, 0x7d, 0xfe, 0x91, 0x0, 0xaf, 0xff, 0xff,
    0xc0, 0x1f, 0xf7, 0x4, 0xff, 0x33, 0xff, 0x10,
    0xd, 0xf8, 0x2f, 0xf4, 0x1, 0xff, 0x90, 0xdf,
    0xfd, 0xff, 0xfa, 0x2, 0xbe, 0xfb, 0xef, 0x90,
    0x0, 0x0, 0x1f, 0xf5, 0x3, 0x10, 0x2c, 0xff,
    0x10, 0x8f, 0xff, 0xff, 0x50, 0x6, 0xef, 0xeb,
    0x30, 0x0,

    /* U+003A ":" */
    0x1f, 0xf8, 0x1f, 0xf8, 0xa, 0xa5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xa5, 0x1f, 0xf8,
    0x1f, 0xf8,

    /* U+003B ";" */
    0x1, 0xff, 0x90, 0x1f, 0xf9, 0x0, 0xaa, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcd, 0x40, 0x3f, 0xf0, 0x7, 0xfa, 0x0, 0xcf,
    0x30, 0x1f, 0xd0, 0x0,

    /* U+003C "<" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0x8b, 0x0, 0x0, 0x4b, 0xff, 0xc0, 0x17, 0xdf,
    0xfe, 0x82, 0x6f, 0xff, 0xb5, 0x0, 0x8, 0xfc,
    0x20, 0x0, 0x0, 0x8f, 0xfd, 0x71, 0x0, 0x0,
    0x4b, 0xff, 0xfa, 0x40, 0x0, 0x2, 0x8e, 0xff,
    0xb0, 0x0, 0x0, 0x6, 0xcc, 0x0, 0x0, 0x0,
    0x0, 0x20,

    /* U+003D "=" */
    0x8f, 0xff, 0xff, 0xff, 0xc8, 0xff, 0xff, 0xff,
    0xfc, 0x13, 0x33, 0x33, 0x33, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xc8, 0xff,
    0xff, 0xff, 0xfc, 0x12, 0x22, 0x22, 0x22, 0x20,

    /* U+003E ">" */
    0x0, 0x0, 0x0, 0x0, 0x8, 0xa3, 0x0, 0x0,
    0x0, 0x8f, 0xfd, 0x60, 0x0, 0x1, 0x6d, 0xff,
    0xf9, 0x20, 0x0, 0x3, 0x9f, 0xff, 0xa0, 0x0,
    0x0, 0x9, 0xfc, 0x0, 0x0, 0x5c, 0xff, 0xc0,
    0x29, 0xef, 0xfd, 0x60, 0x7f, 0xff, 0xa3, 0x0,
    0x8, 0xe7, 0x10, 0x0, 0x0, 0x10, 0x0, 0x0,
    0x0, 0x0,

    /* U+003F "?" */
    0x4e, 0xff, 0xe9, 0x6, 0xff, 0xff, 0xf8, 0x12,
    0x12, 0xef, 0xb0, 0x0, 0xd, 0xfa, 0x0, 0x7,
    0xff, 0x40, 0x7, 0xff, 0x50, 0x0, 0xcf, 0x50,
    0x0, 0x4, 0x50, 0x0, 0x1, 0xaa, 0x40, 0x0,
    0x2f, 0xf7, 0x0, 0x2, 0xff, 0x70, 0x0,

    /* U+0040 "@" */
    0x0, 0x0, 0x5b, 0xef, 0xeb, 0x50, 0x0, 0x0,
    0x1b, 0xff, 0xfe, 0xff, 0xfa, 0x0, 0x0, 0xdf,
    0xc3, 0x0, 0x4, 0xdf, 0x70, 0x8, 0xfb, 0x3,
    0xaa, 0x6c, 0x3f, 0xe0, 0xe, 0xf1, 0x4f, 0xff,
    0xff, 0xb, 0xf1, 0x4f, 0xb0, 0xdf, 0x53, 0xfd,
    0x9, 0xf2, 0x5f, 0x91, 0xfd, 0x2, 0xfa, 0xa,
    0xf1, 0x6f, 0x82, 0xfb, 0x6, 0xf9, 0xe, 0xd0,
    0x4f, 0xb0, 0xff, 0x9f, 0xfe, 0xbf, 0x60, 0xf,
    0xf2, 0x5e, 0xe9, 0x5e, 0xe8, 0x0, 0x8, 0xfe,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xff,
    0xd3, 0x0, 0x0, 0x0, 0x0, 0x4, 0xad, 0xf3,
    0x0, 0x0, 0x0,

    /* U+0041 "A" */
    0x0, 0x8, 0xff, 0xff, 0x20, 0x0, 0x0, 0xd,
    0xfe, 0xff, 0x70, 0x0, 0x0, 0x2f, 0xf7, 0xef,
    0xb0, 0x0, 0x0, 0x7f, 0xf3, 0x9f, 0xf0, 0x0,
    0x0, 0xbf, 0xe0, 0x5f, 0xf5, 0x0, 0x0, 0xff,
    0xa0, 0x1f, 0xf9, 0x0, 0x5, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0x9, 0xff, 0xff, 0xff, 0xff, 0x30,
    0xe, 0xfd, 0x0, 0x4, 0xff, 0x80, 0x3f, 0xf9,
    0x0, 0x0, 0xff, 0xc0, 0x7f, 0xf4, 0x0, 0x0,
    0xbf, 0xf1,

    /* U+0042 "B" */
    0xf, 0xff, 0xff, 0xfc, 0x40, 0x0, 0xff, 0xdb,
    0xbf, 0xff, 0x20, 0xf, 0xf9, 0x0, 0x6f, 0xf6,
    0x0, 0xff, 0x90, 0x5, 0xff, 0x40, 0xf, 0xfd,
    0x99, 0xef, 0x80, 0x0, 0xff, 0xff, 0xff, 0xfc,
    0x10, 0xf, 0xf9, 0x0, 0x3e, 0xfc, 0x0, 0xff,
    0x90, 0x0, 0x9f, 0xf1, 0xf, 0xf9, 0x0, 0x2e,
    0xff, 0x0, 0xff, 0xff, 0xff, 0xff, 0x90, 0xf,
    0xff, 0xff, 0xfd, 0x70, 0x0,

    /* U+0043 "C" */
    0x0, 0x3, 0x9d, 0xfe, 0xd9, 0x0, 0x9, 0xff,
    0xff, 0xff, 0xf2, 0x7, 0xff, 0xe5, 0x21, 0x26,
    0x10, 0xef, 0xe1, 0x0, 0x0, 0x0, 0x3f, 0xf8,
    0x0, 0x0, 0x0, 0x5, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x4f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xe2, 0x0, 0x0, 0x0, 0x8, 0xff, 0xe6, 0x21,
    0x38, 0x10, 0x9, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x3, 0x9d, 0xff, 0xe9, 0x0,

    /* U+0044 "D" */
    0xf, 0xff, 0xff, 0xe9, 0x20, 0x0, 0xff, 0xff,
    0xff, 0xff, 0x40, 0xf, 0xf9, 0x1, 0x7f, 0xfe,
    0x0, 0xff, 0x90, 0x0, 0x9f, 0xf5, 0xf, 0xf9,
    0x0, 0x3, 0xff, 0x80, 0xff, 0x90, 0x0, 0x2f,
    0xf9, 0xf, 0xf9, 0x0, 0x3, 0xff, 0x80, 0xff,
    0x90, 0x0, 0x9f, 0xf5, 0xf, 0xf9, 0x0, 0x7f,
    0xfe, 0x0, 0xff, 0xff, 0xff, 0xff, 0x40, 0xf,
    0xff, 0xff, 0xea, 0x20, 0x0,

    /* U+0045 "E" */
    0xf, 0xff, 0xff, 0xff, 0xd0, 0xff, 0xff, 0xff,
    0xfd, 0xf, 0xfa, 0x33, 0x33, 0x20, 0xff, 0x90,
    0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0x20, 0xff,
    0xff, 0xff, 0xf2, 0xf, 0xf9, 0x11, 0x11, 0x0,
    0xff, 0x90, 0x0, 0x0, 0xf, 0xfa, 0x33, 0x33,
    0x20, 0xff, 0xff, 0xff, 0xfd, 0xf, 0xff, 0xff,
    0xff, 0xd0,

    /* U+0046 "F" */
    0xf, 0xff, 0xff, 0xff, 0x60, 0xff, 0xff, 0xff,
    0xf6, 0xf, 0xfa, 0x33, 0x33, 0x10, 0xff, 0x90,
    0x0, 0x0, 0xf, 0xff, 0xff, 0xfb, 0x0, 0xff,
    0xff, 0xff, 0xb0, 0xf, 0xf9, 0x0, 0x0, 0x0,
    0xff, 0x90, 0x0, 0x0, 0xf, 0xf9, 0x0, 0x0,
    0x0, 0xff, 0x90, 0x0, 0x0, 0xf, 0xf9, 0x0,
    0x0, 0x0,

    /* U+0047 "G" */
    0x0, 0x2, 0x9d, 0xfe, 0xd9, 0x0, 0x7, 0xff,
    0xff, 0xff, 0xf2, 0x5, 0xff, 0xd5, 0x10, 0x14,
    0x0, 0xef, 0xd0, 0x0, 0x0, 0x0, 0x3f, 0xf6,
    0x0, 0xf, 0xff, 0x75, 0xff, 0x40, 0x0, 0xff,
    0xf7, 0x4f, 0xf6, 0x0, 0x0, 0xcf, 0x70, 0xff,
    0xd0, 0x0, 0xc, 0xf7, 0x7, 0xff, 0xd6, 0x32,
    0xcf, 0x70, 0x9, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x3, 0x9d, 0xff, 0xe9, 0x20,

    /* U+0048 "H" */
    0xf, 0xf9, 0x0, 0x1, 0xff, 0x80, 0xff, 0x90,
    0x0, 0x1f, 0xf8, 0xf, 0xf9, 0x0, 0x1, 0xff,
    0x80, 0xff, 0x90, 0x0, 0x1f, 0xf8, 0xf, 0xff,
    0xff, 0xff, 0xff, 0x80, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xf, 0xfa, 0x33, 0x34, 0xff, 0x80, 0xff,
    0x90, 0x0, 0x1f, 0xf8, 0xf, 0xf9, 0x0, 0x1,
    0xff, 0x80, 0xff, 0x90, 0x0, 0x1f, 0xf8, 0xf,
    0xf9, 0x0, 0x1, 0xff, 0x80,

    /* U+0049 "I" */
    0xff, 0xaf, 0xfa, 0xff, 0xaf, 0xfa, 0xff, 0xaf,
    0xfa, 0xff, 0xaf, 0xfa, 0xff, 0xaf, 0xfa, 0xff,
    0xa0,

    /* U+004A "J" */
    0x0, 0x5f, 0xf5, 0x0, 0x5f, 0xf5, 0x0, 0x5f,
    0xf5, 0x0, 0x5f, 0xf5, 0x0, 0x5f, 0xf5, 0x0,
    0x5f, 0xf5, 0x0, 0x5f, 0xf5, 0x0, 0x5f, 0xf5,
    0x0, 0x5f, 0xf5, 0x0, 0x5f, 0xf4, 0x0, 0x7f,
    0xf3, 0x17, 0xef, 0xf0, 0x5f, 0xff, 0x70, 0x4f,
    0xc5, 0x0,

    /* U+004B "K" */
    0xf, 0xf9, 0x0, 0x2e, 0xfc, 0x0, 0xff, 0x90,
    0xd, 0xfe, 0x10, 0xf, 0xf9, 0xa, 0xff, 0x40,
    0x0, 0xff, 0x96, 0xff, 0x70, 0x0, 0xf, 0xff,
    0xff, 0xb0, 0x0, 0x0, 0xff, 0xff, 0xfc, 0x0,
    0x0, 0xf, 0xfa, 0x4f, 0xfb, 0x0, 0x0, 0xff,
    0x90, 0x4f, 0xf8, 0x0, 0xf, 0xf9, 0x0, 0x8f,
    0xf3, 0x0, 0xff, 0x90, 0x0, 0xdf, 0xd0, 0xf,
    0xf9, 0x0, 0x4, 0xff, 0x70,

    /* U+004C "L" */
    0xf, 0xf9, 0x0, 0x0, 0x0, 0xff, 0x90, 0x0,
    0x0, 0xf, 0xf9, 0x0, 0x0, 0x0, 0xff, 0x90,
    0x0, 0x0, 0xf, 0xf9, 0x0, 0x0, 0x0, 0xff,
    0x90, 0x0, 0x0, 0xf, 0xf9, 0x0, 0x0, 0x0,
    0xff, 0x90, 0x0, 0x0, 0xf, 0xfa, 0x33, 0x33,
    0x0, 0xff, 0xff, 0xff, 0xf2, 0xf, 0xff, 0xff,
    0xff, 0x20,

    /* U+004D "M" */
    0xf, 0xff, 0xfa, 0x0, 0x7f, 0xff, 0xf4, 0xf,
    0xff, 0xfd, 0x0, 0xaf, 0xff, 0xf4, 0xf, 0xfc,
    0xff, 0x0, 0xdf, 0xcf, 0xf4, 0xf, 0xf8, 0xff,
    0x30, 0xff, 0x8f, 0xf4, 0xf, 0xf8, 0xdf, 0x63,
    0xff, 0x5f, 0xf4, 0xf, 0xf8, 0x9f, 0x96, 0xfd,
    0x4f, 0xf4, 0xf, 0xf8, 0x6f, 0xc9, 0xf9, 0x4f,
    0xf4, 0xf, 0xf8, 0x3f, 0xfc, 0xf6, 0x4f, 0xf4,
    0xf, 0xf8, 0xf, 0xff, 0xf3, 0x4f, 0xf4, 0xf,
    0xf8, 0xc, 0xff, 0xf0, 0x4f, 0xf4, 0xf, 0xf8,
    0x8, 0xff, 0xc0, 0x4f, 0xf4,

    /* U+004E "N" */
    0xf, 0xff, 0xf5, 0x0, 0xff, 0xa0, 0xff, 0xff,
    0xa0, 0xf, 0xfa, 0xf, 0xfe, 0xfe, 0x0, 0xff,
    0xa0, 0xff, 0x9f, 0xf4, 0xf, 0xfa, 0xf, 0xf8,
    0xbf, 0x90, 0xff, 0xa0, 0xff, 0x86, 0xfd, 0xf,
    0xfa, 0xf, 0xf8, 0x1f, 0xf3, 0xff, 0xa0, 0xff,
    0x80, 0xcf, 0x7f, 0xfa, 0xf, 0xf8, 0x7, 0xfd,
    0xff, 0xa0, 0xff, 0x80, 0x2f, 0xff, 0xfa, 0xf,
    0xf8, 0x0, 0xdf, 0xff, 0xa0,

    /* U+004F "O" */
    0x0, 0x6, 0xbe, 0xfe, 0xa3, 0x0, 0x0, 0xb,
    0xff, 0xff, 0xff, 0xf7, 0x0, 0x8, 0xff, 0xb2,
    0x4, 0xef, 0xf3, 0x0, 0xff, 0xe0, 0x0, 0x4,
    0xff, 0xa0, 0x3f, 0xf9, 0x0, 0x0, 0xe, 0xfe,
    0x5, 0xff, 0x70, 0x0, 0x0, 0xcf, 0xf0, 0x4f,
    0xf8, 0x0, 0x0, 0xd, 0xff, 0x1, 0xff, 0xd0,
    0x0, 0x3, 0xff, 0xb0, 0xa, 0xff, 0xb2, 0x4,
    0xdf, 0xf5, 0x0, 0xc, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x6, 0xce, 0xfe, 0xa4, 0x0, 0x0,

    /* U+0050 "P" */
    0xf, 0xff, 0xff, 0xfd, 0x60, 0x0, 0xff, 0xff,
    0xff, 0xff, 0x80, 0xf, 0xfa, 0x22, 0x3b, 0xff,
    0x0, 0xff, 0x90, 0x0, 0x4f, 0xf1, 0xf, 0xfa,
    0x22, 0x3b, 0xff, 0x0, 0xff, 0xff, 0xff, 0xff,
    0x80, 0xf, 0xff, 0xff, 0xfd, 0x60, 0x0, 0xff,
    0x90, 0x0, 0x0, 0x0, 0xf, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0xff, 0x90, 0x0, 0x0, 0x0, 0xf,
    0xf9, 0x0, 0x0, 0x0, 0x0,

    /* U+0051 "Q" */
    0x0, 0x5, 0xbe, 0xfe, 0xa3, 0x0, 0x0, 0xa,
    0xff, 0xff, 0xff, 0xf7, 0x0, 0x7, 0xff, 0xa2,
    0x3, 0xcf, 0xf4, 0x0, 0xff, 0xc0, 0x0, 0x1,
    0xef, 0xc0, 0x3f, 0xf5, 0x0, 0x0, 0x8, 0xff,
    0x5, 0xff, 0x30, 0x0, 0x0, 0x6f, 0xf2, 0x4f,
    0xf4, 0x0, 0x0, 0x8, 0xff, 0x1, 0xff, 0xb0,
    0x0, 0x0, 0xdf, 0xd0, 0x9, 0xff, 0xa2, 0x3,
    0xcf, 0xf5, 0x0, 0xb, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x5, 0xbe, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xb0, 0x0,

    /* U+0052 "R" */
    0xf, 0xff, 0xff, 0xfc, 0x50, 0x0, 0xff, 0xfd,
    0xde, 0xff, 0x50, 0xf, 0xf9, 0x0, 0x9, 0xfb,
    0x0, 0xff, 0x90, 0x0, 0x9f, 0xb0, 0xf, 0xff,
    0xee, 0xff, 0xf5, 0x0, 0xff, 0xff, 0xff, 0xd6,
    0x0, 0xf, 0xf9, 0x3f, 0xfa, 0x0, 0x0, 0xff,
    0x90, 0x6f, 0xf5, 0x0, 0xf, 0xf9, 0x0, 0xcf,
    0xe1, 0x0, 0xff, 0x90, 0x3, 0xff, 0x80, 0xf,
    0xf9, 0x0, 0xc, 0xff, 0x0,

    /* U+0053 "S" */
    0x1, 0xae, 0xfe, 0xc7, 0x0, 0xdf, 0xff, 0xff,
    0xd0, 0x3f, 0xf8, 0x1, 0x36, 0x3, 0xff, 0x60,
    0x0, 0x0, 0xc, 0xff, 0xb6, 0x0, 0x0, 0x7,
    0xdf, 0xff, 0x60, 0x0, 0x0, 0x3c, 0xff, 0x30,
    0x0, 0x0, 0xf, 0xf8, 0x6d, 0x73, 0x16, 0xff,
    0x76, 0xff, 0xff, 0xff, 0xf2, 0x6, 0xce, 0xff,
    0xb3, 0x0,

    /* U+0054 "T" */
    0xbf, 0xff, 0xff, 0xff, 0xbb, 0xff, 0xff, 0xff,
    0xfb, 0x23, 0x3d, 0xfd, 0x33, 0x20, 0x0, 0xdf,
    0xd0, 0x0, 0x0, 0xd, 0xfd, 0x0, 0x0, 0x0,
    0xdf, 0xd0, 0x0, 0x0, 0xd, 0xfd, 0x0, 0x0,
    0x0, 0xdf, 0xd0, 0x0, 0x0, 0xd, 0xfd, 0x0,
    0x0, 0x0, 0xdf, 0xd0, 0x0, 0x0, 0xd, 0xfd,
    0x0, 0x0,

    /* U+0055 "U" */
    0xf, 0xf9, 0x0, 0x0, 0xdf, 0xc0, 0xff, 0x90,
    0x0, 0xd, 0xfc, 0xf, 0xf9, 0x0, 0x0, 0xdf,
    0xc0, 0xff, 0x90, 0x0, 0xd, 0xfc, 0xf, 0xf9,
    0x0, 0x0, 0xdf, 0xc0, 0xff, 0x90, 0x0, 0xd,
    0xfc, 0xf, 0xf9, 0x0, 0x0, 0xdf, 0xc0, 0xff,
    0xd0, 0x0, 0x2f, 0xfb, 0xa, 0xff, 0xc5, 0x6e,
    0xff, 0x60, 0x1e, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x18, 0xdf, 0xfc, 0x60, 0x0,

    /* U+0056 "V" */
    0xbf, 0xf2, 0x0, 0x0, 0xaf, 0xf2, 0x6f, 0xf7,
    0x0, 0x0, 0xff, 0xd0, 0x1f, 0xfc, 0x0, 0x4,
    0xff, 0x80, 0xb, 0xff, 0x10, 0x8, 0xff, 0x30,
    0x6, 0xff, 0x50, 0xd, 0xfe, 0x0, 0x1, 0xff,
    0xa0, 0x2f, 0xf9, 0x0, 0x0, 0xcf, 0xe0, 0x6f,
    0xf4, 0x0, 0x0, 0x7f, 0xf3, 0xbf, 0xf0, 0x0,
    0x0, 0x2f, 0xf8, 0xff, 0xa0, 0x0, 0x0, 0xd,
    0xff, 0xff, 0x50, 0x0, 0x0, 0x8, 0xff, 0xff,
    0x0, 0x0,

    /* U+0057 "W" */
    0xaf, 0xf1, 0x0, 0xdf, 0xc0, 0x2, 0xff, 0x96,
    0xff, 0x40, 0xf, 0xff, 0x0, 0x5f, 0xf5, 0x2f,
    0xf7, 0x3, 0xff, 0xf2, 0x8, 0xff, 0x10, 0xef,
    0xa0, 0x6f, 0xff, 0x50, 0xbf, 0xd0, 0xa, 0xfd,
    0x9, 0xfa, 0xf8, 0xe, 0xf9, 0x0, 0x6f, 0xf0,
    0xcf, 0x4f, 0xb1, 0xff, 0x50, 0x2, 0xff, 0x4f,
    0xf0, 0xfe, 0x5f, 0xf1, 0x0, 0xe, 0xfa, 0xfc,
    0xd, 0xf9, 0xfd, 0x0, 0x0, 0xaf, 0xff, 0x90,
    0xaf, 0xff, 0x90, 0x0, 0x6, 0xff, 0xf6, 0x8,
    0xff, 0xf5, 0x0, 0x0, 0x2f, 0xff, 0x40, 0x5f,
    0xff, 0x10, 0x0,

    /* U+0058 "X" */
    0x6f, 0xf9, 0x0, 0x0, 0xdf, 0xf2, 0xb, 0xff,
    0x50, 0xa, 0xff, 0x50, 0x1, 0xef, 0xe1, 0x5f,
    0xfa, 0x0, 0x0, 0x4f, 0xfc, 0xff, 0xd0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0x30, 0x0, 0x0, 0x0,
    0xef, 0xfa, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff,
    0x20, 0x0, 0x0, 0x3f, 0xfc, 0xef, 0xd0, 0x0,
    0x0, 0xdf, 0xf1, 0x6f, 0xf9, 0x0, 0x9, 0xff,
    0x60, 0xb, 0xff, 0x40, 0x5f, 0xfb, 0x0, 0x1,
    0xef, 0xe1,

    /* U+0059 "Y" */
    0x8f, 0xf5, 0x0, 0xe, 0xfe, 0x1, 0xef, 0xd0,
    0x7, 0xff, 0x50, 0x6, 0xff, 0x50, 0xef, 0xc0,
    0x0, 0xd, 0xfd, 0x7f, 0xf3, 0x0, 0x0, 0x4f,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0xbf, 0xff, 0x20,
    0x0, 0x0, 0x3, 0xff, 0x90, 0x0, 0x0, 0x0,
    0x2f, 0xf8, 0x0, 0x0, 0x0, 0x2, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x2f, 0xf8, 0x0, 0x0, 0x0,
    0x2, 0xff, 0x80, 0x0, 0x0,

    /* U+005A "Z" */
    0x3f, 0xff, 0xff, 0xff, 0xfd, 0x3f, 0xff, 0xff,
    0xff, 0xfd, 0x2, 0x22, 0x23, 0xdf, 0xf8, 0x0,
    0x0, 0x9, 0xff, 0xa0, 0x0, 0x0, 0x8f, 0xfb,
    0x0, 0x0, 0x7, 0xff, 0xc0, 0x0, 0x0, 0x5f,
    0xfd, 0x10, 0x0, 0x4, 0xff, 0xe2, 0x0, 0x0,
    0x3f, 0xff, 0x63, 0x33, 0x33, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff,

    /* U+005B "[" */
    0x56, 0x65, 0xef, 0xff, 0xef, 0xff, 0xef, 0x70,
    0xef, 0x70, 0xef, 0x70, 0xef, 0x70, 0xef, 0x70,
    0xef, 0x70, 0xef, 0x70, 0xef, 0x70, 0xef, 0x70,
    0xef, 0x70, 0xef, 0xa5, 0xef, 0xff, 0xef, 0xff,

    /* U+005C "\\" */
    0x9f, 0x70, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0,
    0xc, 0xf4, 0x0, 0x0, 0x6, 0xfa, 0x0, 0x0,
    0x0, 0xff, 0x10, 0x0, 0x0, 0x9f, 0x70, 0x0,
    0x0, 0x2f, 0xd0, 0x0, 0x0, 0xc, 0xf4, 0x0,
    0x0, 0x6, 0xfa, 0x0, 0x0, 0x0, 0xff, 0x10,
    0x0, 0x0, 0x9f, 0x70, 0x0, 0x0, 0x3f, 0xd0,
    0x0, 0x0, 0xc, 0xf4, 0x0, 0x0, 0x6, 0xfa,

    /* U+005D "]" */
    0x46, 0x66, 0x1a, 0xff, 0xf2, 0xaf, 0xff, 0x20,
    0x2f, 0xf2, 0x2, 0xff, 0x20, 0x2f, 0xf2, 0x2,
    0xff, 0x20, 0x2f, 0xf2, 0x2, 0xff, 0x20, 0x2f,
    0xf2, 0x2, 0xff, 0x20, 0x2f, 0xf2, 0x2, 0xff,
    0x23, 0x7f, 0xf2, 0xaf, 0xff, 0x2a, 0xff, 0xf2,

    /* U+005E "^" */
    0x0, 0xd, 0xff, 0x10, 0x0, 0x3, 0xff, 0xf7,
    0x0, 0x0, 0xaf, 0x6f, 0xe0, 0x0, 0x1f, 0xe0,
    0xaf, 0x50, 0x7, 0xf9, 0x4, 0xfb, 0x0, 0xdf,
    0x30, 0xe, 0xf2,

    /* U+005F "_" */
    0xaa, 0xaa, 0xaa, 0xaa, 0xff, 0xff, 0xff, 0xff,

    /* U+0060 "`" */
    0x4, 0x42, 0x0, 0x3f, 0xe1, 0x0, 0x3f, 0xa0,

    /* U+0061 "a" */
    0x0, 0x7d, 0xfc, 0xaf, 0xf1, 0x9, 0xff, 0xff,
    0xff, 0xf1, 0x2f, 0xfb, 0x0, 0x8f, 0xf1, 0x6f,
    0xf2, 0x0, 0x4f, 0xf1, 0x7f, 0xf0, 0x0, 0x4f,
    0xf1, 0x6f, 0xf1, 0x0, 0x4f, 0xf1, 0x2f, 0xf9,
    0x0, 0x6f, 0xf1, 0x9, 0xff, 0xcb, 0xff, 0xf2,
    0x0, 0x7d, 0xfe, 0x9f, 0xf4,

    /* U+0062 "b" */
    0x3f, 0xf5, 0x0, 0x0, 0x0, 0x3f, 0xf5, 0x0,
    0x0, 0x0, 0x3f, 0xf5, 0x0, 0x0, 0x0, 0x3f,
    0xf5, 0x0, 0x0, 0x0, 0x3f, 0xf9, 0xcf, 0xd6,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0x70, 0x3f, 0xf7,
    0x1, 0xcf, 0xf1, 0x3f, 0xf1, 0x0, 0x3f, 0xf5,
    0x3f, 0xf1, 0x0, 0xf, 0xf6, 0x3f, 0xf1, 0x0,
    0x2f, 0xf5, 0x3f, 0xf4, 0x0, 0xbf, 0xf1, 0x3f,
    0xff, 0xbd, 0xff, 0x80, 0x6f, 0xf9, 0xef, 0xd6,
    0x0,

    /* U+0063 "c" */
    0x0, 0x3a, 0xef, 0xe9, 0x5, 0xff, 0xff, 0xfe,
    0x1f, 0xfd, 0x41, 0x14, 0x6f, 0xf3, 0x0, 0x0,
    0x7f, 0xf0, 0x0, 0x0, 0x6f, 0xf3, 0x0, 0x0,
    0x1f, 0xff, 0x61, 0x27, 0x5, 0xff, 0xff, 0xff,
    0x0, 0x2a, 0xef, 0xea,

    /* U+0064 "d" */
    0x0, 0x0, 0x0, 0x7f, 0xf1, 0x0, 0x0, 0x0,
    0x7f, 0xf1, 0x0, 0x0, 0x0, 0x7f, 0xf1, 0x0,
    0x0, 0x0, 0x7f, 0xf1, 0x0, 0x7d, 0xfc, 0xaf,
    0xf1, 0x9, 0xff, 0xff, 0xff, 0xf1, 0x2f, 0xfb,
    0x0, 0x8f, 0xf1, 0x6f, 0xf2, 0x0, 0x2f, 0xf1,
    0x7f, 0xf0, 0x0, 0x2f, 0xf1, 0x6f, 0xf1, 0x0,
    0x2f, 0xf1, 0x2f, 0xf9, 0x0, 0x5f, 0xf1, 0x9,
    0xff, 0xcb, 0xff, 0xf2, 0x0, 0x7d, 0xfd, 0x9f,
    0xf4,

    /* U+0065 "e" */
    0x0, 0x7d, 0xff, 0xb4, 0x0, 0x9, 0xff, 0xef,
    0xff, 0x50, 0x2f, 0xf7, 0x0, 0x9f, 0xe0, 0x6f,
    0xfd, 0xdd, 0xdf, 0xf2, 0x7f, 0xff, 0xff, 0xff,
    0xf3, 0x6f, 0xf2, 0x0, 0x0, 0x0, 0x1f, 0xfc,
    0x10, 0x4, 0x70, 0x7, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0x4b, 0xef, 0xeb, 0x40,

    /* U+0066 "f" */
    0x0, 0x8e, 0xff, 0x0, 0x3f, 0xff, 0xf1, 0x5,
    0xff, 0x50, 0x0, 0x6f, 0xf3, 0x0, 0xef, 0xff,
    0xff, 0x4e, 0xff, 0xff, 0xf4, 0x6, 0xff, 0x30,
    0x0, 0x6f, 0xf3, 0x0, 0x6, 0xff, 0x30, 0x0,
    0x6f, 0xf3, 0x0, 0x6, 0xff, 0x30, 0x0, 0x6f,
    0xf3, 0x0, 0x6, 0xff, 0x30, 0x0,

    /* U+0067 "g" */
    0x0, 0x7d, 0xfc, 0xaf, 0xf0, 0x9, 0xff, 0xff,
    0xff, 0xf0, 0x2f, 0xfb, 0x0, 0x8f, 0xf0, 0x6f,
    0xf1, 0x0, 0x2f, 0xf0, 0x7f, 0xf0, 0x0, 0x2f,
    0xf0, 0x6f, 0xf1, 0x0, 0x2f, 0xf0, 0x2f, 0xfb,
    0x0, 0x8f, 0xf0, 0x9, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x7d, 0xfd, 0xcf, 0xf0, 0x0, 0x0, 0x0,
    0xbf, 0xf0, 0x1a, 0x65, 0x49, 0xff, 0xd0, 0x2f,
    0xff, 0xff, 0xff, 0x50, 0x1a, 0xde, 0xff, 0xb4,
    0x0,

    /* U+0068 "h" */
    0x3f, 0xf5, 0x0, 0x0, 0x3, 0xff, 0x50, 0x0,
    0x0, 0x3f, 0xf5, 0x0, 0x0, 0x3, 0xff, 0x50,
    0x0, 0x0, 0x3f, 0xf7, 0xae, 0xe9, 0x3, 0xff,
    0xff, 0xff, 0xf7, 0x3f, 0xfa, 0x13, 0xff, 0xb3,
    0xff, 0x50, 0xd, 0xfc, 0x3f, 0xf5, 0x0, 0xdf,
    0xc3, 0xff, 0x50, 0xd, 0xfc, 0x3f, 0xf5, 0x0,
    0xdf, 0xc3, 0xff, 0x50, 0xd, 0xfc, 0x3f, 0xf5,
    0x0, 0xdf, 0xc0,

    /* U+0069 "i" */
    0xff, 0x9f, 0xf9, 0x99, 0x50, 0x0, 0xff, 0x9f,
    0xf9, 0xff, 0x9f, 0xf9, 0xff, 0x9f, 0xf9, 0xff,
    0x9f, 0xf9, 0xff, 0x90,

    /* U+006A "j" */
    0x0, 0x4f, 0xf4, 0x0, 0x4f, 0xf4, 0x0, 0x29,
    0x92, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xf4, 0x0,
    0x4f, 0xf4, 0x0, 0x4f, 0xf4, 0x0, 0x4f, 0xf4,
    0x0, 0x4f, 0xf4, 0x0, 0x4f, 0xf4, 0x0, 0x4f,
    0xf4, 0x0, 0x4f, 0xf4, 0x0, 0x4f, 0xf4, 0x0,
    0x6f, 0xf3, 0x4, 0xdf, 0xf0, 0x5f, 0xff, 0x80,
    0x4f, 0xc6, 0x0,

    /* U+006B "k" */
    0x3f, 0xf5, 0x0, 0x0, 0x3, 0xff, 0x50, 0x0,
    0x0, 0x3f, 0xf5, 0x0, 0x0, 0x3, 0xff, 0x50,
    0x0, 0x0, 0x3f, 0xf5, 0x9, 0xfe, 0x13, 0xff,
    0x54, 0xff, 0x50, 0x3f, 0xf6, 0xdf, 0xa0, 0x3,
    0xff, 0xff, 0xe1, 0x0, 0x3f, 0xff, 0xfe, 0x20,
    0x3, 0xff, 0x6b, 0xfd, 0x0, 0x3f, 0xf5, 0x1f,
    0xf7, 0x3, 0xff, 0x50, 0x7f, 0xe0, 0x3f, 0xf5,
    0x1, 0xff, 0x60,

    /* U+006C "l" */
    0x3f, 0xf5, 0x3, 0xff, 0x50, 0x3f, 0xf5, 0x3,
    0xff, 0x50, 0x3f, 0xf5, 0x3, 0xff, 0x50, 0x3f,
    0xf5, 0x3, 0xff, 0x50, 0x3f, 0xf5, 0x3, 0xff,
    0x60, 0x1f, 0xfb, 0x20, 0xcf, 0xfe, 0x2, 0xbf,
    0xe0,

    /* U+006D "m" */
    0x3f, 0xf7, 0xae, 0xf8, 0x3b, 0xfe, 0x60, 0x3f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x3f, 0xfa,
    0x13, 0xff, 0xb0, 0x6f, 0xf5, 0x3f, 0xf5, 0x0,
    0xff, 0x90, 0x2f, 0xf6, 0x3f, 0xf5, 0x0, 0xff,
    0x90, 0x2f, 0xf6, 0x3f, 0xf5, 0x0, 0xff, 0x90,
    0x2f, 0xf6, 0x3f, 0xf5, 0x0, 0xff, 0x90, 0x2f,
    0xf6, 0x3f, 0xf5, 0x0, 0xff, 0x90, 0x2f, 0xf6,
    0x3f, 0xf5, 0x0, 0xff, 0x90, 0x2f, 0xf6,

    /* U+006E "n" */
    0x3f, 0xf6, 0x9e, 0xfa, 0x13, 0xff, 0xff, 0xff,
    0xf9, 0x3f, 0xfb, 0x21, 0xdf, 0xd3, 0xff, 0x50,
    0xa, 0xfe, 0x3f, 0xf5, 0x0, 0xaf, 0xe3, 0xff,
    0x50, 0xa, 0xfe, 0x3f, 0xf5, 0x0, 0xaf, 0xe3,
    0xff, 0x50, 0xa, 0xfe, 0x3f, 0xf5, 0x0, 0xaf,
    0xe0,

    /* U+006F "o" */
    0x0, 0x6c, 0xff, 0xc6, 0x0, 0x9, 0xff, 0xff,
    0xff, 0x90, 0x2f, 0xfa, 0x0, 0xaf, 0xf3, 0x6f,
    0xf2, 0x0, 0x1f, 0xf7, 0x7f, 0xf0, 0x0, 0xf,
    0xf8, 0x6f, 0xf3, 0x0, 0x2f, 0xf6, 0x1f, 0xfb,
    0x0, 0xbf, 0xf1, 0x7, 0xff, 0xff, 0xff, 0x70,
    0x0, 0x5c, 0xff, 0xc5, 0x0,

    /* U+0070 "p" */
    0x3f, 0xf9, 0xbf, 0xe9, 0x0, 0x3f, 0xff, 0xdc,
    0xff, 0xc0, 0x3f, 0xf9, 0x0, 0x6f, 0xf5, 0x3f,
    0xf5, 0x0, 0xd, 0xf9, 0x3f, 0xf5, 0x0, 0xb,
    0xfb, 0x3f, 0xf5, 0x0, 0xe, 0xfa, 0x3f, 0xfb,
    0x0, 0x9f, 0xf5, 0x3f, 0xff, 0xff, 0xff, 0xc0,
    0x3f, 0xf9, 0xbf, 0xe9, 0x0, 0x3f, 0xf5, 0x0,
    0x0, 0x0, 0x3f, 0xf4, 0x0, 0x0, 0x0, 0x4f,
    0xf3, 0x0, 0x0, 0x0, 0x6f, 0xf2, 0x0, 0x0,
    0x0,

    /* U+0071 "q" */
    0x0, 0x7d, 0xfc, 0x5f, 0xf6, 0x9, 0xff, 0xff,
    0xff, 0xf6, 0x2f, 0xfb, 0x0, 0x8f, 0xf6, 0x6f,
    0xf1, 0x0, 0x2f, 0xf6, 0x7f, 0xf0, 0x0, 0x2f,
    0xf6, 0x6f, 0xf1, 0x0, 0x2f, 0xf6, 0x2f, 0xfb,
    0x0, 0x8f, 0xf6, 0x9, 0xff, 0xff, 0xff, 0xf6,
    0x0, 0x7d, 0xfd, 0x7f, 0xf6, 0x0, 0x0, 0x0,
    0x2f, 0xf6, 0x0, 0x0, 0x0, 0x1f, 0xf7, 0x0,
    0x0, 0x0, 0xf, 0xf7, 0x0, 0x0, 0x0, 0xe,
    0xf9,

    /* U+0072 "r" */
    0x3f, 0xf8, 0xbf, 0x33, 0xff, 0xff, 0xf4, 0x3f,
    0xfb, 0x20, 0x3, 0xff, 0x50, 0x0, 0x3f, 0xf5,
    0x0, 0x3, 0xff, 0x50, 0x0, 0x3f, 0xf5, 0x0,
    0x3, 0xff, 0x50, 0x0, 0x3f, 0xf5, 0x0, 0x0,

    /* U+0073 "s" */
    0x4, 0xcf, 0xfd, 0x60, 0x2f, 0xff, 0xff, 0xa0,
    0x6f, 0xf3, 0x2, 0x40, 0x3f, 0xfd, 0x60, 0x0,
    0x5, 0xef, 0xff, 0x60, 0x0, 0x3, 0xbf, 0xf2,
    0x69, 0x31, 0x6f, 0xf3, 0x7f, 0xff, 0xff, 0xe0,
    0x29, 0xde, 0xfc, 0x30,

    /* U+0074 "t" */
    0x8, 0xfe, 0x0, 0x8, 0xfe, 0x0, 0xcf, 0xff,
    0xf8, 0xcf, 0xff, 0xf8, 0x8, 0xfe, 0x0, 0x8,
    0xfe, 0x0, 0x8, 0xfe, 0x0, 0x8, 0xfe, 0x0,
    0x8, 0xff, 0x10, 0x6, 0xff, 0xf7, 0x0, 0xbf,
    0xf7,

    /* U+0075 "u" */
    0x3f, 0xf5, 0x0, 0xaf, 0xe0, 0x3f, 0xf5, 0x0,
    0xaf, 0xe0, 0x3f, 0xf5, 0x0, 0xaf, 0xe0, 0x3f,
    0xf5, 0x0, 0xaf, 0xe0, 0x3f, 0xf5, 0x0, 0xaf,
    0xe0, 0x3f, 0xf5, 0x0, 0xaf, 0xe0, 0x2f, 0xf9,
    0x5, 0xef, 0xe0, 0xe, 0xff, 0xff, 0xff, 0xe0,
    0x3, 0xcf, 0xd6, 0x4f, 0xf1,

    /* U+0076 "v" */
    0xcf, 0xc0, 0x0, 0x4f, 0xf5, 0x7f, 0xf1, 0x0,
    0x8f, 0xf0, 0x2f, 0xf5, 0x0, 0xdf, 0xb0, 0xd,
    0xfa, 0x1, 0xff, 0x60, 0x8, 0xfe, 0x6, 0xff,
    0x10, 0x4, 0xff, 0x3a, 0xfc, 0x0, 0x0, 0xef,
    0x8e, 0xf7, 0x0, 0x0, 0xaf, 0xef, 0xf3, 0x0,
    0x0, 0x5f, 0xff, 0xe0, 0x0,

    /* U+0077 "w" */
    0xaf, 0xe0, 0x3, 0xff, 0x40, 0xc, 0xfb, 0x5f,
    0xf1, 0x6, 0xff, 0x80, 0xf, 0xf6, 0x1f, 0xf5,
    0xa, 0xff, 0xb0, 0x4f, 0xf2, 0xc, 0xf9, 0xd,
    0xee, 0xf0, 0x7f, 0xd0, 0x7, 0xfd, 0x1f, 0xba,
    0xf2, 0xbf, 0x80, 0x3, 0xff, 0x5f, 0x87, 0xf6,
    0xff, 0x40, 0x0, 0xef, 0xdf, 0x54, 0xfd, 0xff,
    0x0, 0x0, 0xaf, 0xff, 0x20, 0xff, 0xfb, 0x0,
    0x0, 0x5f, 0xfe, 0x0, 0xdf, 0xf6, 0x0,

    /* U+0078 "x" */
    0x5f, 0xf3, 0x0, 0x8f, 0xe1, 0xa, 0xfd, 0x3,
    0xff, 0x50, 0x1, 0xef, 0x8d, 0xfa, 0x0, 0x0,
    0x4f, 0xff, 0xe1, 0x0, 0x0, 0xc, 0xff, 0x70,
    0x0, 0x0, 0x4f, 0xff, 0xe0, 0x0, 0x0, 0xdf,
    0xae, 0xf9, 0x0, 0x9, 0xfe, 0x14, 0xff, 0x40,
    0x4f, 0xf5, 0x0, 0xaf, 0xe1,

    /* U+0079 "y" */
    0xcf, 0xc0, 0x0, 0x7f, 0xf2, 0x6f, 0xf2, 0x0,
    0xcf, 0xd0, 0x1f, 0xf8, 0x0, 0xff, 0x90, 0xa,
    0xfd, 0x4, 0xff, 0x40, 0x4, 0xff, 0x38, 0xff,
    0x0, 0x0, 0xdf, 0x9c, 0xfb, 0x0, 0x0, 0x7f,
    0xff, 0xf6, 0x0, 0x0, 0x1f, 0xff, 0xf1, 0x0,
    0x0, 0x1, 0xaf, 0xd0, 0x0, 0x0, 0x0, 0xef,
    0x80, 0x0, 0x1, 0x4c, 0xff, 0x10, 0x0, 0x2f,
    0xff, 0xf5, 0x0, 0x0, 0x2f, 0xda, 0x30, 0x0,
    0x0,

    /* U+007A "z" */
    0x3f, 0xff, 0xff, 0xfc, 0x2f, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0x8f, 0xf4, 0x0, 0x6, 0xff, 0x60,
    0x0, 0x4f, 0xf8, 0x0, 0x3, 0xff, 0x90, 0x0,
    0x2e, 0xfb, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xfd,
    0x8f, 0xff, 0xff, 0xfd,

    /* U+007B "{" */
    0x0, 0x2b, 0xe3, 0x0, 0xef, 0xf4, 0x3, 0xff,
    0x40, 0x5, 0xff, 0x0, 0x5, 0xff, 0x0, 0x5,
    0xff, 0x0, 0x6, 0xff, 0x0, 0x5f, 0xf8, 0x0,
    0x7f, 0xe4, 0x0, 0x8, 0xfe, 0x0, 0x5, 0xff,
    0x0, 0x5, 0xff, 0x0, 0x5, 0xff, 0x0, 0x4,
    0xff, 0x40, 0x0, 0xef, 0xf4, 0x0, 0x3b, 0xe3,

    /* U+007C "|" */
    0x2a, 0x73, 0xfc, 0x3f, 0xc3, 0xfc, 0x3f, 0xc3,
    0xfc, 0x3f, 0xc3, 0xfc, 0x3f, 0xc3, 0xfc, 0x3f,
    0xc3, 0xfc, 0x3f, 0xc3, 0xfc, 0x3f, 0xc3, 0xfc,

    /* U+007D "}" */
    0x9d, 0x80, 0x0, 0xaf, 0xf8, 0x0, 0x1a, 0xfd,
    0x0, 0x6, 0xfe, 0x0, 0x6, 0xff, 0x0, 0x6,
    0xff, 0x0, 0x5, 0xff, 0x0, 0x1, 0xdf, 0xd0,
    0x0, 0x9f, 0xf1, 0x5, 0xff, 0x20, 0x6, 0xff,
    0x0, 0x6, 0xff, 0x0, 0x6, 0xfe, 0x0, 0x1a,
    0xfd, 0x0, 0xaf, 0xf8, 0x0, 0x9d, 0x80, 0x0,

    /* U+007E "~" */
    0x0, 0x10, 0x0, 0x0, 0x5, 0xef, 0xfc, 0x52,
    0x47, 0x8f, 0xff, 0xff, 0xff, 0xc4, 0x30, 0x28,
    0xdf, 0xd7,

    /* U+786E "确" */
    0x3f, 0xff, 0xff, 0x11, 0xff, 0xff, 0xff, 0x20,
    0x3f, 0xff, 0xff, 0x2c, 0xfe, 0xde, 0xfc, 0x0,
    0x2, 0xff, 0x11, 0xcf, 0xe1, 0xd, 0xf4, 0x0,
    0x4, 0xfd, 0x0, 0xef, 0xdb, 0xcf, 0xfb, 0xb0,
    0x7, 0xfa, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xf0,
    0xc, 0xfd, 0xaa, 0x3f, 0xc2, 0xfd, 0x2e, 0xf0,
    0x2f, 0xff, 0xff, 0x3f, 0xb0, 0xfc, 0xe, 0xf0,
    0x2c, 0xf9, 0xef, 0x3f, 0xff, 0xff, 0xff, 0xf0,
    0xa, 0xf2, 0xdf, 0x3f, 0xfd, 0xff, 0xdf, 0xf0,
    0xa, 0xf2, 0xdf, 0x3f, 0xa0, 0xfc, 0xe, 0xf0,
    0xa, 0xf2, 0xdf, 0x4f, 0xd8, 0xfe, 0x8f, 0xf0,
    0xa, 0xf2, 0xdf, 0x6f, 0xff, 0xff, 0xff, 0xf0,
    0xa, 0xff, 0xff, 0x9f, 0xa7, 0xfe, 0x7f, 0xf0,
    0x9, 0xff, 0xfe, 0xcf, 0x30, 0xfc, 0xe, 0xf0,
    0x0, 0x0, 0x1, 0xff, 0x0, 0xfc, 0xe, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8BA4 "认" */
    0x2, 0xfe, 0x0, 0x0, 0x3, 0xfd, 0x0, 0x0,
    0x0, 0xef, 0x40, 0x0, 0x3, 0xfd, 0x0, 0x0,
    0x0, 0x9f, 0x90, 0x0, 0x3, 0xfd, 0x0, 0x0,
    0x0, 0x28, 0x70, 0x0, 0x3, 0xfd, 0x0, 0x0,
    0x12, 0x22, 0x0, 0x0, 0x4, 0xfe, 0x0, 0x0,
    0x7f, 0xff, 0x30, 0x0, 0x6, 0xff, 0x0, 0x0,
    0x6f, 0xff, 0x30, 0x0, 0x8, 0xff, 0x10, 0x0,
    0x0, 0xef, 0x30, 0x0, 0xc, 0xff, 0x60, 0x0,
    0x0, 0xef, 0x30, 0x0, 0x1f, 0xff, 0xa0, 0x0,
    0x0, 0xef, 0x30, 0x0, 0x8f, 0xcf, 0xf2, 0x0,
    0x0, 0xef, 0x31, 0x3, 0xff, 0x39, 0xfb, 0x0,
    0x0, 0xef, 0xe9, 0x2e, 0xfa, 0x1, 0xef, 0xa0,
    0x0, 0xef, 0xf9, 0xff, 0xd0, 0x0, 0x4f, 0xf9,
    0x0, 0xef, 0x93, 0xfc, 0x10, 0x0, 0x5, 0xfa,
    0x0, 0x61, 0x1, 0x80, 0x0, 0x0, 0x0, 0x26
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 67, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 95, .box_w = 4, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 22, .adv_w = 106, .box_w = 6, .box_h = 5, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 37, .adv_w = 154, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 92, .adv_w = 151, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 164, .adv_w = 213, .box_w = 13, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 236, .adv_w = 169, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 297, .adv_w = 59, .box_w = 3, .box_h = 5, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 305, .adv_w = 101, .box_w = 5, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 345, .adv_w = 101, .box_w = 6, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 393, .adv_w = 118, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 418, .adv_w = 148, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 459, .adv_w = 84, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 472, .adv_w = 113, .box_w = 5, .box_h = 2, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 477, .adv_w = 84, .box_w = 3, .box_h = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 482, .adv_w = 128, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 534, .adv_w = 151, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 584, .adv_w = 108, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 617, .adv_w = 151, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 667, .adv_w = 151, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 711, .adv_w = 151, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 761, .adv_w = 151, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 805, .adv_w = 151, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 855, .adv_w = 141, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 905, .adv_w = 151, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 955, .adv_w = 151, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1005, .adv_w = 103, .box_w = 4, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1023, .adv_w = 103, .box_w = 5, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1051, .adv_w = 148, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1101, .adv_w = 148, .box_w = 9, .box_h = 7, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 1133, .adv_w = 148, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1183, .adv_w = 115, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1222, .adv_w = 219, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1313, .adv_w = 186, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1379, .adv_w = 173, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1440, .adv_w = 175, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1501, .adv_w = 180, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1562, .adv_w = 149, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1612, .adv_w = 142, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1662, .adv_w = 180, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1723, .adv_w = 184, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1784, .adv_w = 74, .box_w = 3, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1801, .adv_w = 84, .box_w = 6, .box_h = 14, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 1843, .adv_w = 172, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1904, .adv_w = 134, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1954, .adv_w = 227, .box_w = 14, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2031, .adv_w = 186, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2092, .adv_w = 203, .box_w = 13, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2164, .adv_w = 169, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2225, .adv_w = 205, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 2303, .adv_w = 169, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2364, .adv_w = 145, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2414, .adv_w = 143, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2464, .adv_w = 188, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2525, .adv_w = 184, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2591, .adv_w = 239, .box_w = 15, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2674, .adv_w = 187, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2740, .adv_w = 166, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2801, .adv_w = 167, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2856, .adv_w = 85, .box_w = 4, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 2888, .adv_w = 129, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 2944, .adv_w = 85, .box_w = 5, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2984, .adv_w = 148, .box_w = 9, .box_h = 6, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 3011, .adv_w = 128, .box_w = 8, .box_h = 2, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3019, .adv_w = 111, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 11},
    {.bitmap_index = 3027, .adv_w = 158, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3072, .adv_w = 158, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3137, .adv_w = 136, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3173, .adv_w = 158, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3238, .adv_w = 155, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3283, .adv_w = 102, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3329, .adv_w = 157, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3394, .adv_w = 153, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3453, .adv_w = 73, .box_w = 3, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3473, .adv_w = 81, .box_w = 6, .box_h = 17, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 3524, .adv_w = 141, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3583, .adv_w = 81, .box_w = 5, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3616, .adv_w = 227, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3679, .adv_w = 155, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3720, .adv_w = 161, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3765, .adv_w = 162, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3830, .adv_w = 163, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3895, .adv_w = 104, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3927, .adv_w = 123, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3963, .adv_w = 94, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3996, .adv_w = 155, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4041, .adv_w = 153, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4086, .adv_w = 225, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4149, .adv_w = 155, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4194, .adv_w = 149, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 4259, .adv_w = 132, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4295, .adv_w = 89, .box_w = 6, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4343, .adv_w = 57, .box_w = 3, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4367, .adv_w = 89, .box_w = 6, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4415, .adv_w = 148, .box_w = 9, .box_h = 4, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 4433, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4561, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_1[] = {
    0x0, 0x1336
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 30830, .range_length = 4919, .glyph_id_start = 96,
        .unicode_list = unicode_list_1, .glyph_id_ofs_list = NULL, .list_length = 2, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Pair left and right glyphs for kerning*/
static const uint8_t kern_pair_glyph_ids[] =
{
    7, 43,
    9, 75,
    19, 21,
    19, 23,
    19, 26,
    21, 26,
    34, 43,
    34, 53,
    34, 55,
    34, 56,
    34, 58,
    34, 66,
    34, 68,
    34, 70,
    34, 72,
    34, 80,
    34, 82,
    36, 43,
    37, 43,
    37, 53,
    37, 55,
    37, 56,
    37, 57,
    37, 58,
    37, 59,
    38, 43,
    39, 15,
    39, 34,
    39, 66,
    39, 68,
    39, 70,
    39, 72,
    39, 80,
    39, 82,
    40, 43,
    41, 43,
    42, 43,
    44, 43,
    44, 48,
    44, 66,
    44, 68,
    44, 70,
    44, 72,
    44, 80,
    44, 82,
    45, 34,
    45, 43,
    45, 48,
    45, 53,
    45, 55,
    45, 56,
    45, 58,
    46, 43,
    47, 43,
    48, 43,
    48, 53,
    48, 55,
    48, 56,
    48, 57,
    48, 58,
    48, 59,
    49, 15,
    49, 34,
    49, 57,
    50, 43,
    50, 53,
    50, 55,
    50, 56,
    50, 57,
    50, 58,
    50, 59,
    51, 43,
    51, 58,
    51, 66,
    51, 68,
    51, 70,
    51, 72,
    51, 80,
    51, 82,
    53, 15,
    53, 34,
    53, 40,
    53, 48,
    53, 50,
    53, 66,
    53, 68,
    53, 70,
    53, 72,
    53, 75,
    53, 78,
    53, 79,
    53, 80,
    53, 81,
    53, 82,
    53, 83,
    53, 84,
    53, 86,
    55, 15,
    55, 34,
    55, 40,
    55, 48,
    55, 50,
    55, 66,
    55, 68,
    55, 70,
    55, 72,
    55, 75,
    55, 78,
    55, 79,
    55, 80,
    55, 81,
    55, 82,
    55, 83,
    55, 84,
    55, 86,
    56, 15,
    56, 34,
    56, 40,
    56, 48,
    56, 50,
    56, 66,
    56, 68,
    56, 70,
    56, 72,
    56, 75,
    56, 78,
    56, 79,
    56, 80,
    56, 81,
    56, 82,
    56, 83,
    56, 84,
    56, 86,
    57, 15,
    57, 40,
    57, 43,
    57, 48,
    57, 50,
    57, 66,
    57, 68,
    57, 70,
    57, 72,
    57, 80,
    57, 82,
    57, 84,
    58, 15,
    58, 34,
    58, 40,
    58, 48,
    58, 50,
    58, 66,
    58, 68,
    58, 69,
    58, 70,
    58, 72,
    58, 75,
    58, 78,
    58, 79,
    58, 80,
    58, 81,
    58, 82,
    58, 83,
    58, 84,
    58, 85,
    58, 86,
    59, 40,
    59, 43,
    59, 48,
    59, 50,
    60, 43,
    60, 75,
    61, 43,
    61, 75,
    66, 43,
    67, 53,
    67, 55,
    67, 56,
    67, 57,
    67, 58,
    67, 87,
    67, 88,
    67, 89,
    67, 90,
    68, 43,
    69, 43,
    70, 53,
    70, 55,
    70, 56,
    70, 57,
    70, 58,
    70, 87,
    70, 88,
    70, 89,
    70, 90,
    72, 43,
    76, 43,
    76, 66,
    76, 68,
    76, 70,
    76, 72,
    76, 80,
    76, 82,
    77, 43,
    79, 43,
    80, 43,
    80, 53,
    80, 55,
    80, 56,
    80, 57,
    80, 58,
    80, 87,
    80, 88,
    80, 89,
    80, 90,
    81, 53,
    81, 55,
    81, 56,
    81, 57,
    81, 58,
    81, 87,
    81, 88,
    81, 89,
    81, 90,
    82, 43,
    82, 75,
    83, 66,
    83, 68,
    83, 70,
    83, 72,
    83, 80,
    83, 82,
    84, 53,
    84, 55,
    84, 56,
    84, 57,
    84, 58,
    85, 43,
    86, 43,
    88, 66,
    88, 68,
    88, 70,
    88, 72,
    88, 80,
    88, 82,
    89, 43,
    89, 66,
    89, 68,
    89, 70,
    89, 72,
    89, 80,
    89, 82,
    90, 66,
    90, 68,
    90, 70,
    90, 72,
    90, 80,
    90, 82,
    91, 43,
    92, 43,
    92, 75
};

/* Kerning between the respective left and right glyphs
 * 4.4 format which needs to scaled with `kern_scale`*/
static const int8_t kern_pair_values[] =
{
    13, 10, -5, -5, -5, -3, 5, -15,
    -18, -13, -15, -5, -5, -5, -5, -5,
    -5, 5, -5, -5, -3, -3, -8, -8,
    -3, 5, -26, -10, -5, -5, -5, -5,
    -5, -5, 5, 5, 5, 8, -10, -10,
    -10, -10, -10, -10, -10, 3, 8, -5,
    -26, -18, -13, -26, 5, 5, -5, -5,
    -3, -3, -8, -8, -3, -28, -8, -5,
    -5, -5, -3, -3, -8, -8, -3, 8,
    -3, -3, -3, -3, -3, -3, -3, -31,
    -15, -5, -5, -5, -15, -15, -15, -15,
    -10, -10, -10, -15, -10, -15, -10, -13,
    -10, -20, -18, -3, -3, -3, -10, -10,
    -10, -8, -8, -5, -5, -10, -5, -10,
    -5, -5, -5, -15, -13, -3, -3, -3,
    -8, -8, -8, -8, -8, -5, -5, -8,
    -5, -8, -5, -5, -5, -5, -8, 8,
    -8, -8, -10, -10, -10, -10, -10, -10,
    -8, -26, -15, -8, -8, -8, -23, -23,
    -23, -23, -23, -10, -10, -10, -23, -10,
    -23, -10, -18, -10, -10, -3, 8, -3,
    -3, 13, 10, 13, 10, 5, -15, -8,
    -8, -10, -23, -5, -3, -5, -5, 5,
    5, -15, -8, -8, -10, -23, -5, -3,
    -5, -5, 5, 5, -5, -5, -5, -5,
    -5, -5, 8, 3, -5, -15, -10, -8,
    -10, -23, -5, -3, -5, -5, -15, -8,
    -8, -10, -23, -5, -3, -5, -5, 5,
    10, -5, -5, -5, -5, -5, -5, -13,
    -5, -5, -8, -18, 5, 3, -3, -3,
    -3, -3, -3, -3, 5, -3, -3, -3,
    -3, -3, -3, -3, -3, -3, -3, -3,
    -3, 5, 13, 10
};

/*Collect the kern pair's data in one place*/
static const lv_font_fmt_txt_kern_pair_t kern_pairs =
{
    .glyph_ids = kern_pair_glyph_ids,
    .values = kern_pair_values,
    .pair_cnt = 260,
    .glyph_ids_size = 0
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

#if LV_VERSION_CHECK(8, 0, 0)
/*Store all the custom data of the font*/
static  lv_font_fmt_txt_glyph_cache_t cache;
static const lv_font_fmt_txt_dsc_t font_dsc = {
#else
static lv_font_fmt_txt_dsc_t font_dsc = {
#endif
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_pairs,
    .kern_scale = 16,
    .cmap_num = 2,
    .bpp = 4,
    .kern_classes = 0,
    .bitmap_format = 0,
#if LV_VERSION_CHECK(8, 0, 0)
    .cache = &cache
#endif
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
#if LV_VERSION_CHECK(8, 0, 0)
const lv_font_t ui_font_AliShuHeTi16sbpp4 = {
#else
lv_font_t ui_font_AliShuHeTi16sbpp4 = {
#endif
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 18,          /*The maximum line height required by the font*/
    .base_line = 4,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0) || LVGL_VERSION_MAJOR >= 8
    .underline_position = -2,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};



#endif /*#if UI_FONT_ALISHUHETI16SBPP4*/

