#ifndef INC_DEFINE_CLUSTER_ZIGBEE_HPP_
#define INC_DEFINE_CLUSTER_ZIGBEE_HPP_

namespace ZigbeeNamespace {

    enum ProfileIDT {
        ZCL_PROFILE_ZB_STANDARD_MIN = 0x0000,
        /* Note: Legacy profile range does not include HA (0x0104) */
        ZCL_PROFILE_LEGACY_MIN = 0x0101,
        ZCL_PROFILE_HOME_AUTOMATION = 0x0104,
        ZCL_PROFILE_COMMERCIAL_BUILDING_AUTOMATION = 0x0105,
        ZCL_PROFILE_TELECOM_APPLICATION = 0x0107,
        ZCL_PROFILE_LEGACY_MAX = 0x0108,
        ZCL_PROFILE_SMART_ENERGY = 0x0109,
        ZCL_PROFILE_RETAIL_SERVICES = 0x010A,
        ZCL_PROFILE_GREEN_POWER = 0xA1E0,
        ZCL_PROFILE_TP2 = 0x7f01, /* ZigBee Test Profile #2 Profile Id */
        ZCL_PROFILE_ZB_STANDARD_MAX = 0x7fff,

        ZCL_PROFILE_MFR_SPECIFIC_MIN = 0xc000,
        ZCL_PROFILE_ZLL = 0xc05e,
        ZCL_PROFILE_C4 = 0xc25d,
        ZCL_PROFILE_WILDCARD = 0xffff /* Wildcard Profile ID */
    };

    enum DeviceIDT {
        ZCL_DEVICE_ONOFF_SWITCH = 0x0000,
        ZCL_DEVICE_LEVEL_SWITCH = 0x0001,
        ZCL_DEVICE_ONOFF_OUTPUT = 0x0002,
        ZCL_DEVICE_LEVEL_OUTPUT = 0x0003,
        ZCL_DEVICE_SCENE_SELECTOR = 0x0004,
        ZCL_DEVICE_CONFIG_TOOL = 0x0005,
        ZCL_DEVICE_REMOTE_CONTROL = 0x0006,
        ZCL_DEVICE_COMBINED_INTERFACE = 0x0007,
        ZCL_DEVICE_RANGE_EXTENDER = 0x0008,
        ZCL_DEVICE_MAINS_POWER_OUTLET = 0x0009,
        ZCL_DEVICE_DOOR_LOCK = 0x000a,
        ZCL_DEVICE_DOOR_LOCK_CONTROLLER = 0x000b,
        ZCL_DEVICE_SIMPLE_SENSOR = 0x000c,
        ZCL_DEVICE_DATA_COLLECTION_UNIT = 0x0010,
        ZCL_DEVICE_ZIGBEE_SIM_CARD = 0x0020,
        ZCL_DEVICE_ZIGBEE_MOBILE_TERMINAL = 0x0021,
        ZCL_DEVICE_ZIGBEE_GLOBAL_PLATFORM_CARD = 0x0026, /* same as  */
        ZCL_DEVICE_CUSTOMER_HANDHELD_DEVICE = 0x0030,
        ZCL_DEVICE_RETAIL_ASSOCIATE_HANDHELD_DEVICE = 0x0031,
        ZCL_DEVICE_INTELLIGENT_SHOPPING_CART = 0x0032,
        ZCL_DEVICE_ELECTRONIC_SHELF_LABEL = 0x0033,
        ZCL_DEVICE_CUSTOMER_INFORMATION_POINT = 0x0034,
        ZCL_DEVICE_CUSTOMER_CARD = 0x0035,
        ZCL_DEVICE_CONSTRUCTED_BACNET_DEVICE = 0x004a,
        ZCL_DEVICE_BACNET_TUNNELED_DEVICE = 0x004b,
        ZCL_DEVICE_HOME_GATEWAY = 0x0050,
        ZCL_DEVICE_SMART_PLUG = 0x0051,
        ZCL_DEVICE_WHITE_GOODS = 0x0052,
        ZCL_DEVICE_METER_INTERFACE = 0x0053,
        ZCL_DEVICE_ZGP_PROXY = 0x0060,
        ZCL_DEVICE_ZGP_PROXY_BASIC = 0x0061,
        ZCL_DEVICE_ZGP_TARGET_PLUS = 0x0062,
        ZCL_DEVICE_ZGP_TARGET = 0x0063,
        ZCL_DEVICE_ZGP_COMMISSIONING_TOOL = 0x0064,
        ZCL_DEVICE_ZGP_COMBO = 0x0065,
        ZCL_DEVICE_ZGP_COMBO_BASIC = 0x0066,
        ZCL_DEVICE_ENVIRONMENTAL_SENSOR = 0x0067,

        /* Lighting and Occupancy (0x0100) */
        ZCL_DEVICE_ONOFF_LIGHT = 0x0100,
        ZCL_DEVICE_DIMMABLE_LIGHT = 0x0101,
        ZCL_DEVICE_COLOR_DIMMABLE_LIGHT = 0x0102,
        ZCL_DEVICE_ONOFF_LIGHT_SWITCH = 0x0103,
        ZCL_DEVICE_ONOFF_DIMMER_SWITCH = 0x0104,
        ZCL_DEVICE_ONOFF_COLOR_DIMMER_SWITCH = 0x0105,
        ZCL_DEVICE_ONOFF_LIGHT_SENSOR = 0x0106,
        ZCL_DEVICE_ONOFF_OCCUPANCY_SENSOR = 0x0107,
        /* EXEGIN - add more from Lighting and Occupancy Device Spec */

        /* IAS (0x0400) */
        ZCL_DEVICE_IAS_CONTROL_AND_INDICATING_EQUIPMENT = 0x0400,
        ZCL_DEVICE_IAS_ANCILLARY_CONTROL_EQUIPMENT = 0x0401,
        ZCL_DEVICE_IAS_ZONE = 0x0402,
        ZCL_DEVICE_IAS_WARNING_DEVICE = 0x0403,

        /* Smart Energy device identifiers. (0x0500) */
        ZCL_DEVICE_ESP = 0x0500,
        ZCL_DEVICE_METER = 0x0501,
        ZCL_DEVICE_IN_HOME_DISPLAY = 0x0502,
        ZCL_DEVICE_PCT = 0x0503,
        ZCL_DEVICE_LOAD_CONTROL = 0x0504,
        ZCL_DEVICE_SMART_APPLIANCE = 0x0505,
        ZCL_DEVICE_PREPAYMENT_TERMINAL = 0x0506,
        ZCL_DEVICE_PHYSICAL_DEVICE = 0x0507,
        ZCL_DEVICE_REMOTE_COMMUNICATIONS_DEVICE = 0x0508,
        ZCL_DEVICE_ERL_INTERFACE = 0x0509,

        /* Lighting and Occupancy Continued (0x0800) */
        ZCL_DEVICE_COLOR_CONTROLLER = 0x0800,
        ZCL_DEVICE_COLOR_SCENE_CONTROLLER = 0x0810,
        ZCL_DEVICE_NON_COLOR_CONTROLLER = 0x0820,
        ZCL_DEVICE_NON_COLOR_SCENE_CONTROLLER = 0x0830,
        ZCL_DEVICE_CONTROL_BRIDGE = 0x0840,
        ZCL_DEVICE_ONOFF_SENSOR = 0x0850 /* aka Door Sensor? */
    };

    enum ClusterIDT {
        /* General cluster identifiers. */
        ZCL_CLUSTER_BASIC = 0x0000,
        ZCL_CLUSTER_POWER_CONFIG = 0x0001,
        ZCL_CLUSTER_DEVICE_TEMPERATURE = 0x0002,
        ZCL_CLUSTER_IDENTIFY = 0x0003,
        ZCL_CLUSTER_GROUPS = 0x0004,
        ZCL_CLUSTER_SCENES = 0x0005,
        ZCL_CLUSTER_ONOFF = 0x0006,
        ZCL_CLUSTER_ONOFF_CONFIG = 0x0007,
        ZCL_CLUSTER_LEVEL_CONTROL = 0x0008,
        ZCL_CLUSTER_ALARMS = 0x0009,
        ZCL_CLUSTER_TIME = 0x000a,
        ZCL_CLUSTER_RSSI_LOCATION = 0x000b,
        ZCL_CLUSTER_ANALOG_INPUT_BASIC = 0x000c,
        ZCL_CLUSTER_ANALOG_OUTPUT_BASIC = 0x000d,
        ZCL_CLUSTER_ANALOG_VALUE_BASIC = 0x000e,
        ZCL_CLUSTER_BINARY_INPUT_BASIC = 0x000f,
        ZCL_CLUSTER_BINARY_OUTPUT_BASIC = 0x0010,
        ZCL_CLUSTER_BINARY_VALUE_BASIC = 0x0011,
        ZCL_CLUSTER_MULTISTATE_INPUT_BASIC = 0x0012,
        ZCL_CLUSTER_MULTISTATE_OUTPUT_BASIC = 0x0013,
        ZCL_CLUSTER_MULTISTATE_VALUE_BASIC = 0x0014,
        ZCL_CLUSTER_COMMISSIONING = 0x0015,
        ZCL_CLUSTER_PARTITION = 0x0016,
        ZCL_CLUSTER_OTA_UPGRADE = 0x0019,
        ZCL_CLUSTER_POWER_PROFILE = 0x001a,
        ZCL_CLUSTER_APPLIANCE_CONTROL = 0x001b,
        ZCL_CLUSTER_POLL_CONTROL = 0x0020,
        ZCL_CLUSTER_GREEN_POWER = 0x0021,

        /* Retail clusters. */
        ZCL_CLUSTER_MOBILE_DEVICE_CONFIGURATION = 0x0022,
        ZCL_CLUSTER_NEIGHBOR_CLEANING = 0x0023,
        ZCL_CLUSTER_NEAREST_GATEWAY = 0x0024,
        ZCL_CLUSTER_KEEP_ALIVE = 0x0025,
        ZCL_CLUSTER_METER_ID = 0x0b01,
        ZCL_CLUSTER_DIAGNOSTICS = 0x0b05,

        /* Closures Cluster IDs */
        ZCL_CLUSTER_CLOSURE_SHADE_CONFIG = 0x0100,
        ZCL_CLUSTER_DOOR_LOCK = 0x0101,
        ZCL_CLUSTER_WINDOW_COVERING = 0x0102,
        ZCL_CLUSTER_BARRIER_CONTROL = 0x0103,

        /* HVAC Cluster IDs */
        ZCL_CLUSTER_HVAC_PUMP = 0x0200,
        ZCL_CLUSTER_HVAC_THERMOSTAT = 0x0201,
        ZCL_CLUSTER_HVAC_FAN = 0x0202,
        ZCL_CLUSTER_HVAC_DEHUMIDIFIER = 0x0203,
        ZCL_CLUSTER_HVAC_THERMOSTAT_UI = 0x0204,

        /* Lighting Cluster IDs */
        ZCL_CLUSTER_COLOR_CONTROL = 0x0300,
        ZCL_CLUSTER_BALLAST_CONTROL = 0x0301,

        /* Measurement Cluster IDs */
        ZCL_CLUSTER_MEAS_ILLUMINANCE = 0x0400,
        ZCL_CLUSTER_MEAS_ILLUMINANCE_LEVEL = 0x0401,
        ZCL_CLUSTER_MEAS_TEMPERATURE = 0x0402,
        ZCL_CLUSTER_MEAS_PRESSURE = 0x0403,
        ZCL_CLUSTER_MEAS_FLOW = 0x0404,
        ZCL_CLUSTER_MEAS_HUMIDITY = 0x0405,
        ZCL_CLUSTER_MEAS_OCCUPANCY = 0x0406,
        ZCL_CLUSTER_MEAS_ELECTRICAL = 0x0b04,

        /* Security Cluster IDs */
        ZCL_CLUSTER_SECURITY_IAS_ZONE = 0x0500,
        ZCL_CLUSTER_SECURITY_IAS_ANCILLARY = 0x0501,
        ZCL_CLUSTER_SECURITY_IAS_WARNING = 0x0502,

        /* Smart Energy */
        ZCL_CLUSTER_PRICE = 0x0700,
        ZCL_CLUSTER_DRLC = 0x0701,
        ZCL_CLUSTER_SIMPLE_METERING = 0x0702,
        ZCL_CLUSTER_MESSAGING = 0x0703,
        ZCL_CLUSTER_TUNNELING = 0x0704,
        ZCL_CLUSTER_PREPAYMENT = 0x0705,
        ZCL_CLUSTER_ENERGY_MANAGEMENT = 0x0706, /* SE 1.2 */
        ZCL_CLUSTER_CALENDAR = 0x0707,
        ZCL_CLUSTER_DEVICE_MANAGEMENT = 0x0708, /* SE 1.2 */
        ZCL_CLUSTER_EVENTS = 0x0709, /* SE 1.2 */
        ZCL_CLUSTER_MDU_PAIRING = 0x070A, /* SE 1.2 */
        ZCL_CLUSTER_SUB_GHZ = 0x070B, /* SE 1.2 */

        /* TOUCHLINK */
        ZCL_CLUSTER_TOUCHLINK = 0x1000,

        /* Custom, internal use only, for handling cluster persistence.
        * Used with ZCL_MANUF_CODE_INTERNAL. */
        ZCL_CLUSTER_PERSIST = 0xfffe,

        /* Custom, internal use only, for local loop-back commands we want to
        * send to all clusters. Used with ZCL_MANUF_CODE_INTERNAL. */
        ZCL_CLUSTER_WILDCARD = 0xffff,

        NO_CLUSTER_ID = 0x2706
    };

} /* namespace ZigbeeNamespace */

#endif /* INC_DEFINE_CLUSTER_ZIGBEE_HPP_ */
