#ifndef INC_ERA_SIMPLE_ESP8266_WIFI_HPP_
#define INC_ERA_SIMPLE_ESP8266_WIFI_HPP_

#define ERA_NO_RTOS

#include <ESP8266WiFi.h>
#include <WiFiClient.h>
#include <ERa/ERaApiArduinoDef.hpp>
#include <Adapters/ERaArduinoWiFiClient.hpp>
#include <ERa/ERaApiArduino.hpp>
#include <Modbus/ERaModbusArduino.hpp>
#include <Storage/ERaFlashEsp8266.hpp>
#include <Task/ERaTaskEsp8266.hpp>

#if !defined(NO_GLOBAL_INSTANCES) && !defined(NO_GLOBAL_ERA)
    static ERaFlash flash;
    static WiFiClient ERaWiFiClient;
    static ERaMqtt<Client, MQTTClient> mqtt(ERaWiFiClient);
    ERaWiFi< ERaMqtt<Client, MQTTClient> > ERa(mqtt, flash);
#else
    extern ERaWiFi< ERaMqtt<Client, MQTTClient> > ERa;
#endif

#include <ERa/ERaStatic.hpp>

#endif /* INC_ERA_SIMPLE_ESP8266_WIFI_HPP_ */
