#ifndef INC_DEFINE_ZDO_ZIGBEE_HPP_
#define INC_DEFINE_ZDO_ZIGBEE_HPP_

namespace ZigbeeNamespace {

    enum DeviceStateListT {
        INITIALIZED_NOT_STARTED = 0x00,
        INITIALIZED_NOT_CONNECTED,
        DISCOVERING_PAN,
        JOINING_PAN,
        REJOINING_PAN,
        JOINED_NOT_AUTH,
        STARTED_AFTER_AUTH,
        DEVICE_JOINED_AUTH_ROUTER,
        STARTING_COORDINATOR,
        STARTED_COORDINATOR,
        DEVICE_LOST_INFO
    };

    enum NwkStatesT {
        NWK_INIT_STATE,
        NWK_JOINING_ORPHAN_STATE,
        NWK_DISC_STATE,
        NWK_JOINING_STATE,
        NWK_ENDDEVICE_STATE,
        PAN_CHNL_SELECTION_STATE,
        PAN_CHNL_VERIFY_STATE,
        PAN_STARTING_STATE,
        NWK_ROUTER_STATE,
        NWK_REJOINING_STATE
    };

    enum ResetTypeT {
        RST_HARD = 0x00,
        RST_SOFT = 0x01
    };

    enum ReasonResetZigbeeT {
        ZB_RST_POWER_UP = 0x00,
        ZB_RST_EXTERNAL,
        ZB_RST_WATCH_DOG
    };

    enum FlagsZigbeeT {
        FLAG_ZIGBEE_HAS_CONFIGURED = 0x55
    };

    enum ZDOCommandsT {
        ZDO_NWK_ADDR_REQ = 0x00,
        ZDO_IEEE_ADDR_REQ,
        ZDO_NODE_DESC_REQ,
        ZDO_POWER_DESC_REQ,
        ZDO_SIMPLE_DESC_REQ,
        ZDO_ACTIVE_EP_REQ,
        ZDO_MATCH_DESC_REQ,
        ZDO_COMPLEX_DESC_REQ,
        ZDO_USER_DESC_REQ,

        ZDO_END_DEVICE_ANNCE = 0x0A,
        ZDO_USER_DESC_SET,
        ZDO_SERVER_DISC_REQ,

        ZDO_END_DEVICE_BIND_REQ = 0x20,
        ZDO_BIND_REQ,
        ZDO_UNBIND_REQ,
        ZDO_SET_LINK_KEY,
        ZDO_REMOVE_LINK_KEY,
        ZDO_GET_LINK_KEY,
        ZDO_NWK_DISCOVERY_REQ,
        ZDO_JOIN_REQ,
        ZDO_SET_REJOIN_PARAMETERS = 0x26, //0x28
        ZDO_NWK_ADDR_OF_INTEREST_REQ = 0x29,

        ZDO_MGMT_NWK_DISC_REQ = 0x30,
        ZDO_MGMT_LQI_REQ,
        ZDO_MGMT_RTG_REQ,
        ZDO_MGMT_BIND_REQ,
        ZDO_MGMT_LEAVE_REQ,
        ZDO_MGMT_DIRECT_JOIN_REQ,
        ZDO_MGMT_PERMIT_JOIN_REQ,
        ZDO_MGMT_NWK_UPDATE_REQ,

        ZDO_MSG_CB_REGISTER = 0x3E,
        ZDO_MSG_CB_REMOVE,
        ZDO_STARTUP_FROM_APP,

        ZDO_SEC_ADD_LINK_KEY = 0x42,
        ZDO_SEC_ENTRY_LOOKUP_EXT,
        ZDO_SEC_DEVICE_REMOVE,
        ZDO_EXT_ROUTE_DISC,
        ZDO_EXT_ROUTE_CHECK,
        ZDO_EXT_REMOVE_GROUP,
        ZDO_EXT_REMOVE_ALL_GROUP,
        ZDO_EXT_FIND_ALL_GROUPS_ENDPOINT,
        ZDO_EXT_FIND_GROUP,
        ZDO_EXT_ADD_GROUP,
        ZDO_EXT_COUNT_ALL_GROUPS,
        ZDO_EXT_RX_IDLE,
        ZDO_EXT_UPDATE_NWK_KEY,
        ZDO_EXT_SWITCH_NWK_KEY,
        ZDO_EXT_NWK_INFO,
        ZDO_EXT_SEC_APS_REMOVE_REQ,
        ZDO_FORCE_CONCENTRATOR_CHANGE,
        ZDO_EXT_SET_PARAMS,

        ZDO_STARTUP_FROM_APP_EX = 0x54,

        ZDO_NWK_ADDR_RSP = 0x80,
        ZDO_IEEE_ADDR_RSP,
        ZDO_NODE_DESC_RSP,
        ZDO_POWER_DESC_RSP,
        ZDO_SIMPLE_DESC_RSP,
        ZDO_ACTIVE_EP_RSP,
        ZDO_MATCH_DESC_RSP,
        ZDO_COMPLEX_DESC_RSP,
        ZDO_USER_DESC_RSP,
        ZDO_USER_DESC_CONF,
        ZDO_SERVER_DISC_RSP,

        ZDO_END_DEVICE_BIND_RSP = 0xA0,
        ZDO_BIND_RSP,
        ZDO_UNBIND_RSP,

        ZDO_MGMT_NWK_DISC_RSP = 0xB0,
        ZDO_MGMT_LQI_RSP,
        ZDO_MGMT_RTG_RSP,
        ZDO_MGMT_BIND_RSP,
        ZDO_MGMT_LEAVE_RSP,
        ZDO_MGMT_DIRECT_JOIN_RSP,
        ZDO_MGMT_PERMIT_JOIN_RSP,

        ZDO_STATE_CHANGE_IND = 0xC0,
        ZDO_END_DEVICE_ANNCE_IND,
        ZDO_MATCH_DESC_RSP_SENT,
        ZDO_STATUS_ERROR_RSP,
        ZDO_SRC_RTG_IND,
        ZDO_BEACON_NOTIFY_IND,
        ZDO_JOIN_CNF,
        ZDO_NWK_DISCOVERY_CNF,

        ZDO_LEAVE_IND = 0xC9,
        ZDO_TC_DEV_IND,
        ZDO_PERMIT_JOIN_IND,
        ZDO_MSG_CB_INCOMING = 0xFF
    };

} /* namespace ZigbeeNamespace */

#endif /* INC_DEFINE_ZDO_ZIGBEE_HPP_ */
