#ifndef INC_DEFINE_APP_ZIGBEE_HPP_
#define INC_DEFINE_APP_ZIGBEE_HPP_

namespace ZigbeeNamespace {

    enum APPCFCommandsT {
        APP_CNF_SET_DEFAULT_REMOTE_ENDDEVICE_TIMEOUT = 0x01,
        APP_CNF_SET_ENDDEVICETIMEOUT,
        APP_CNF_SET_ALLOWREJOIN_TC_POLICY,
        APP_CNF_BDB_ADD_INSTALLCODE,
        APP_CNF_BDB_START_COMMISSIONING,
        APP_CNF_BDB_SET_JOINUSESINSTALLCODEKEY,
        APP_CNF_BDB_SET_ACTIVE_DEFAULT_CENTRALIZED_KEY,
        APP_CNF_BDB_SET_CHANNEL,
        APP_CNF_BDB_SET_TC_REQUIRE_KEY_EXCHANGE,
        APP_CNF_BDB_ZED_ATTEMPT_RECOVER_NWK,

        APP_CNF_BDB_COMMISSIONING_NOTIFICATION = 0x80,

        APP_CNF_SET_NWK_FRAME_COUNTER = 0xFF
    };

    enum APPCFCommModeT {
        COMM_MODE_INITIALIZATION = 0x00,
        COMM_MODE_TOUCHLINK = 0x01,
        COMM_MODE_NETWORK_STEERING = 0x02,
        COMM_MODE_NETWORK_FORMATION = 0x04,
        COMM_MODE_FINDING_AND_BINDING = 0x08
    };

    enum APPCFCommStatusT {
        BDB_COMMISSIONING_SUCCESS = 0x00,
        BDB_COMMISSIONING_IN_PROGRESS = 0x01,
        BDB_COMMISSIONING_NO_NETWORK = 0x02,
        BDB_COMMISSIONING_TL_TARGET_FAILURE = 0x03,
        BDB_COMMISSIONING_TL_NOT_AA_CAPABLE = 0x04,
        BDB_COMMISSIONING_TL_NO_SCAN_RESPONSE = 0x05,
        BDB_COMMISSIONING_TL_NOT_PERMITTED = 0x06,
        BDB_COMMISSIONING_TCLK_EX_FAILURE = 0x07,
        BDB_COMMISSIONING_FORMATION_FAILURE = 0x08,
        BDB_COMMISSIONING_FB_TARGET_IN_PROGRESS = 0x09,
        BDB_COMMISSIONING_FB_INITIATOR_IN_PROGRESS = 0x0A,
        BDB_COMMISSIONING_FB_NO_IDENTIFY_QUERY_RESPONSE = 0x0B,
        BDB_COMMISSIONING_FB_BINDING_TABLE_FULL = 0x0C,
        BDB_COMMISSIONING_NETWORK_RESTORED = 0x0D,
        BDB_COMMISSIONING_FAILURE = 0x0E
    };

    enum GPCommandsT {
        GP_DATA_REQ = 0x01,
        GP_SEC_RSP,
        GP_SEC_REQ,
        GP_DATA_IND,
        GP_DATA_CNF,
    };

} /* namespace ZigbeeNamespace */

#endif /* INC_DEFINE_APP_ZIGBEE_HPP_ */
