#include <stdio.h>
#include <stdint.h>
#include <ERa/ERaHandlers.hpp>
#include <ERa/ERaDebug.hpp>

void ERaNoHandler() {
}

void ERaNoOptConnected(void ERA_UNUSED *arg) {
}

void ERaNoModbusBaudrate(uint32_t ERA_UNUSED &baudrate) {
}

void ERaNoInfo(cJSON ERA_UNUSED *root) {
}

void ERaNoWriteConfig(uint8_t ERA_UNUSED type) {
}

void ERaWidgetWrite(uint16_t ERA_UNUSED &pin, const ERaParam ERA_UNUSED &param) {
    ERA_LOG(ERA_PSTR("ERa"), ERA_PSTR("No handler for writing to V%u"), pin);
}

void ERaWidgetPinRead(uint16_t ERA_UNUSED &pin, const ERaParam ERA_UNUSED &param, const ERaParam ERA_UNUSED &raw) {
}

bool ERaWidgetPinWrite(uint16_t ERA_UNUSED &pin, const ERaParam ERA_UNUSED &param, const ERaParam ERA_UNUSED &raw) {
    return false;
}

bool ERaNoWidgetWriteSMS(const char* to, const char* message) {
    ERA_LOG(ERA_PSTR("ERa"), ERA_PSTR("No handler for writing SMS to %s: %s"), to, message);
    return false;
}

#define ERA_ON_WRITE(Pin) void ERaWidgetWrite ## Pin (uint16_t ERA_UNUSED &pin, const ERaParam ERA_UNUSED &param) \
        __attribute__((weak, alias("ERaWidgetWrite")))

#define ERA_ON_PIN_READ(Pin) void ERaWidgetPinRead ## Pin (uint16_t ERA_UNUSED &pin, const ERaParam ERA_UNUSED &param, const ERaParam ERA_UNUSED &raw) \
        __attribute__((weak, alias("ERaWidgetPinRead")))

#define ERA_ON_PIN_WRITE(Pin) bool ERaWidgetPinWrite ## Pin (uint16_t ERA_UNUSED &pin, const ERaParam ERA_UNUSED &param, const ERaParam ERA_UNUSED &raw) \
        __attribute__((weak, alias("ERaWidgetPinWrite")))

ERA_CONNECTED()             __attribute__((weak, alias("ERaNoHandler")));
ERA_DISCONNECTED()          __attribute__((weak, alias("ERaNoHandler")));
ERA_WAITING()               __attribute__((weak, alias("ERaNoHandler")));
ERA_APP_LOOP()              __attribute__((weak, alias("ERaNoHandler")));
ERA_OPTION_CONNECTED()      __attribute__((weak, alias("ERaNoOptConnected")));
ERA_MODBUS_BAUDRATE()       __attribute__((weak, alias("ERaNoModbusBaudrate")));
ERA_MODBUS_INFO()           __attribute__((weak, alias("ERaNoInfo")));
ERA_SELF_INFO()             __attribute__((weak, alias("ERaNoInfo")));
ERA_INFO()                  __attribute__((weak, alias("ERaNoInfo")));
ERA_WRITE_CONFIG()          __attribute__((weak, alias("ERaNoWriteConfig")));
ERA_WRITE_SMS()             __attribute__((weak, alias("ERaNoWidgetWriteSMS")));

ERA_ON_WRITE(Default);
ERA_ON_PIN_READ(Default);
ERA_ON_PIN_WRITE(Default);

ERA_ON_WRITE( 0);
ERA_ON_WRITE( 1);
ERA_ON_WRITE( 2);
ERA_ON_WRITE( 3);
ERA_ON_WRITE( 4);
ERA_ON_WRITE( 5);
ERA_ON_WRITE( 6);
ERA_ON_WRITE( 7);
ERA_ON_WRITE( 8);
ERA_ON_WRITE( 9);
ERA_ON_WRITE(10);
ERA_ON_WRITE(11);
ERA_ON_WRITE(12);
ERA_ON_WRITE(13);
ERA_ON_WRITE(14);
ERA_ON_WRITE(15);
ERA_ON_WRITE(16);
ERA_ON_WRITE(17);
ERA_ON_WRITE(18);
ERA_ON_WRITE(19);
ERA_ON_WRITE(20);
ERA_ON_WRITE(21);
ERA_ON_WRITE(22);
ERA_ON_WRITE(23);
ERA_ON_WRITE(24);
ERA_ON_WRITE(25);
ERA_ON_WRITE(26);
ERA_ON_WRITE(27);
ERA_ON_WRITE(28);
ERA_ON_WRITE(29);
ERA_ON_WRITE(30);
ERA_ON_WRITE(31);
ERA_ON_WRITE(32);
ERA_ON_WRITE(33);
ERA_ON_WRITE(34);
ERA_ON_WRITE(35);
ERA_ON_WRITE(36);
ERA_ON_WRITE(37);
ERA_ON_WRITE(38);
ERA_ON_WRITE(39);
ERA_ON_WRITE(40);
ERA_ON_WRITE(41);
ERA_ON_WRITE(42);
ERA_ON_WRITE(43);
ERA_ON_WRITE(44);
ERA_ON_WRITE(45);
ERA_ON_WRITE(46);
ERA_ON_WRITE(47);
ERA_ON_WRITE(48);
ERA_ON_WRITE(49);
#if defined(ERA_100_PINS)
    ERA_ON_WRITE(50);
    ERA_ON_WRITE(51);
    ERA_ON_WRITE(52);
    ERA_ON_WRITE(53);
    ERA_ON_WRITE(54);
    ERA_ON_WRITE(55);
    ERA_ON_WRITE(56);
    ERA_ON_WRITE(57);
    ERA_ON_WRITE(58);
    ERA_ON_WRITE(59);
    ERA_ON_WRITE(60);
    ERA_ON_WRITE(61);
    ERA_ON_WRITE(62);
    ERA_ON_WRITE(63);
    ERA_ON_WRITE(64);
    ERA_ON_WRITE(65);
    ERA_ON_WRITE(66);
    ERA_ON_WRITE(67);
    ERA_ON_WRITE(68);
    ERA_ON_WRITE(69);
    ERA_ON_WRITE(70);
    ERA_ON_WRITE(71);
    ERA_ON_WRITE(72);
    ERA_ON_WRITE(73);
    ERA_ON_WRITE(74);
    ERA_ON_WRITE(75);
    ERA_ON_WRITE(76);
    ERA_ON_WRITE(77);
    ERA_ON_WRITE(78);
    ERA_ON_WRITE(79);
    ERA_ON_WRITE(80);
    ERA_ON_WRITE(81);
    ERA_ON_WRITE(82);
    ERA_ON_WRITE(83);
    ERA_ON_WRITE(84);
    ERA_ON_WRITE(85);
    ERA_ON_WRITE(86);
    ERA_ON_WRITE(87);
    ERA_ON_WRITE(88);
    ERA_ON_WRITE(89);
    ERA_ON_WRITE(90);
    ERA_ON_WRITE(91);
    ERA_ON_WRITE(92);
    ERA_ON_WRITE(93);
    ERA_ON_WRITE(94);
    ERA_ON_WRITE(95);
    ERA_ON_WRITE(96);
    ERA_ON_WRITE(97);
    ERA_ON_WRITE(98);
    ERA_ON_WRITE(99);
#endif
#if defined(ERA_255_PINS)
    ERA_ON_WRITE(100);
    ERA_ON_WRITE(101);
    ERA_ON_WRITE(102);
    ERA_ON_WRITE(103);
    ERA_ON_WRITE(104);
    ERA_ON_WRITE(105);
    ERA_ON_WRITE(106);
    ERA_ON_WRITE(107);
    ERA_ON_WRITE(108);
    ERA_ON_WRITE(109);
    ERA_ON_WRITE(110);
    ERA_ON_WRITE(111);
    ERA_ON_WRITE(112);
    ERA_ON_WRITE(113);
    ERA_ON_WRITE(114);
    ERA_ON_WRITE(115);
    ERA_ON_WRITE(116);
    ERA_ON_WRITE(117);
    ERA_ON_WRITE(118);
    ERA_ON_WRITE(119);
    ERA_ON_WRITE(120);
    ERA_ON_WRITE(121);
    ERA_ON_WRITE(122);
    ERA_ON_WRITE(123);
    ERA_ON_WRITE(124);
    ERA_ON_WRITE(125);
    ERA_ON_WRITE(126);
    ERA_ON_WRITE(127);
    ERA_ON_WRITE(128);
    ERA_ON_WRITE(129);
    ERA_ON_WRITE(130);
    ERA_ON_WRITE(131);
    ERA_ON_WRITE(132);
    ERA_ON_WRITE(133);
    ERA_ON_WRITE(134);
    ERA_ON_WRITE(135);
    ERA_ON_WRITE(136);
    ERA_ON_WRITE(137);
    ERA_ON_WRITE(138);
    ERA_ON_WRITE(139);
    ERA_ON_WRITE(140);
    ERA_ON_WRITE(141);
    ERA_ON_WRITE(142);
    ERA_ON_WRITE(143);
    ERA_ON_WRITE(144);
    ERA_ON_WRITE(145);
    ERA_ON_WRITE(146);
    ERA_ON_WRITE(147);
    ERA_ON_WRITE(148);
    ERA_ON_WRITE(149);
    ERA_ON_WRITE(150);
    ERA_ON_WRITE(151);
    ERA_ON_WRITE(152);
    ERA_ON_WRITE(153);
    ERA_ON_WRITE(154);
    ERA_ON_WRITE(155);
    ERA_ON_WRITE(156);
    ERA_ON_WRITE(157);
    ERA_ON_WRITE(158);
    ERA_ON_WRITE(159);
    ERA_ON_WRITE(160);
    ERA_ON_WRITE(161);
    ERA_ON_WRITE(162);
    ERA_ON_WRITE(163);
    ERA_ON_WRITE(164);
    ERA_ON_WRITE(165);
    ERA_ON_WRITE(166);
    ERA_ON_WRITE(167);
    ERA_ON_WRITE(168);
    ERA_ON_WRITE(169);
    ERA_ON_WRITE(170);
    ERA_ON_WRITE(171);
    ERA_ON_WRITE(172);
    ERA_ON_WRITE(173);
    ERA_ON_WRITE(174);
    ERA_ON_WRITE(175);
    ERA_ON_WRITE(176);
    ERA_ON_WRITE(177);
    ERA_ON_WRITE(178);
    ERA_ON_WRITE(179);
    ERA_ON_WRITE(180);
    ERA_ON_WRITE(181);
    ERA_ON_WRITE(182);
    ERA_ON_WRITE(183);
    ERA_ON_WRITE(184);
    ERA_ON_WRITE(185);
    ERA_ON_WRITE(186);
    ERA_ON_WRITE(187);
    ERA_ON_WRITE(188);
    ERA_ON_WRITE(189);
    ERA_ON_WRITE(190);
    ERA_ON_WRITE(191);
    ERA_ON_WRITE(192);
    ERA_ON_WRITE(193);
    ERA_ON_WRITE(194);
    ERA_ON_WRITE(195);
    ERA_ON_WRITE(196);
    ERA_ON_WRITE(197);
    ERA_ON_WRITE(198);
    ERA_ON_WRITE(199);
    ERA_ON_WRITE(200);
    ERA_ON_WRITE(201);
    ERA_ON_WRITE(202);
    ERA_ON_WRITE(203);
    ERA_ON_WRITE(204);
    ERA_ON_WRITE(205);
    ERA_ON_WRITE(206);
    ERA_ON_WRITE(207);
    ERA_ON_WRITE(208);
    ERA_ON_WRITE(209);
    ERA_ON_WRITE(210);
    ERA_ON_WRITE(211);
    ERA_ON_WRITE(212);
    ERA_ON_WRITE(213);
    ERA_ON_WRITE(214);
    ERA_ON_WRITE(215);
    ERA_ON_WRITE(216);
    ERA_ON_WRITE(217);
    ERA_ON_WRITE(218);
    ERA_ON_WRITE(219);
    ERA_ON_WRITE(220);
    ERA_ON_WRITE(221);
    ERA_ON_WRITE(222);
    ERA_ON_WRITE(223);
    ERA_ON_WRITE(224);
    ERA_ON_WRITE(225);
    ERA_ON_WRITE(226);
    ERA_ON_WRITE(227);
    ERA_ON_WRITE(228);
    ERA_ON_WRITE(229);
    ERA_ON_WRITE(230);
    ERA_ON_WRITE(231);
    ERA_ON_WRITE(232);
    ERA_ON_WRITE(233);
    ERA_ON_WRITE(234);
    ERA_ON_WRITE(235);
    ERA_ON_WRITE(236);
    ERA_ON_WRITE(237);
    ERA_ON_WRITE(238);
    ERA_ON_WRITE(239);
    ERA_ON_WRITE(240);
    ERA_ON_WRITE(241);
    ERA_ON_WRITE(242);
    ERA_ON_WRITE(243);
    ERA_ON_WRITE(244);
    ERA_ON_WRITE(245);
    ERA_ON_WRITE(246);
    ERA_ON_WRITE(247);
    ERA_ON_WRITE(248);
    ERA_ON_WRITE(249);
    ERA_ON_WRITE(250);
    ERA_ON_WRITE(251);
    ERA_ON_WRITE(252);
    ERA_ON_WRITE(253);
    ERA_ON_WRITE(254);
    ERA_ON_WRITE(255);
#endif
#if defined(ERA_500_PINS)
    ERA_ON_WRITE(256);
    ERA_ON_WRITE(257);
    ERA_ON_WRITE(258);
    ERA_ON_WRITE(259);
    ERA_ON_WRITE(260);
    ERA_ON_WRITE(261);
    ERA_ON_WRITE(262);
    ERA_ON_WRITE(263);
    ERA_ON_WRITE(264);
    ERA_ON_WRITE(265);
    ERA_ON_WRITE(266);
    ERA_ON_WRITE(267);
    ERA_ON_WRITE(268);
    ERA_ON_WRITE(269);
    ERA_ON_WRITE(270);
    ERA_ON_WRITE(271);
    ERA_ON_WRITE(272);
    ERA_ON_WRITE(273);
    ERA_ON_WRITE(274);
    ERA_ON_WRITE(275);
    ERA_ON_WRITE(276);
    ERA_ON_WRITE(277);
    ERA_ON_WRITE(278);
    ERA_ON_WRITE(279);
    ERA_ON_WRITE(280);
    ERA_ON_WRITE(281);
    ERA_ON_WRITE(282);
    ERA_ON_WRITE(283);
    ERA_ON_WRITE(284);
    ERA_ON_WRITE(285);
    ERA_ON_WRITE(286);
    ERA_ON_WRITE(287);
    ERA_ON_WRITE(288);
    ERA_ON_WRITE(289);
    ERA_ON_WRITE(290);
    ERA_ON_WRITE(291);
    ERA_ON_WRITE(292);
    ERA_ON_WRITE(293);
    ERA_ON_WRITE(294);
    ERA_ON_WRITE(295);
    ERA_ON_WRITE(296);
    ERA_ON_WRITE(297);
    ERA_ON_WRITE(298);
    ERA_ON_WRITE(299);
    ERA_ON_WRITE(300);
    ERA_ON_WRITE(301);
    ERA_ON_WRITE(302);
    ERA_ON_WRITE(303);
    ERA_ON_WRITE(304);
    ERA_ON_WRITE(305);
    ERA_ON_WRITE(306);
    ERA_ON_WRITE(307);
    ERA_ON_WRITE(308);
    ERA_ON_WRITE(309);
    ERA_ON_WRITE(310);
    ERA_ON_WRITE(311);
    ERA_ON_WRITE(312);
    ERA_ON_WRITE(313);
    ERA_ON_WRITE(314);
    ERA_ON_WRITE(315);
    ERA_ON_WRITE(316);
    ERA_ON_WRITE(317);
    ERA_ON_WRITE(318);
    ERA_ON_WRITE(319);
    ERA_ON_WRITE(320);
    ERA_ON_WRITE(321);
    ERA_ON_WRITE(322);
    ERA_ON_WRITE(323);
    ERA_ON_WRITE(324);
    ERA_ON_WRITE(325);
    ERA_ON_WRITE(326);
    ERA_ON_WRITE(327);
    ERA_ON_WRITE(328);
    ERA_ON_WRITE(329);
    ERA_ON_WRITE(330);
    ERA_ON_WRITE(331);
    ERA_ON_WRITE(332);
    ERA_ON_WRITE(333);
    ERA_ON_WRITE(334);
    ERA_ON_WRITE(335);
    ERA_ON_WRITE(336);
    ERA_ON_WRITE(337);
    ERA_ON_WRITE(338);
    ERA_ON_WRITE(339);
    ERA_ON_WRITE(340);
    ERA_ON_WRITE(341);
    ERA_ON_WRITE(342);
    ERA_ON_WRITE(343);
    ERA_ON_WRITE(344);
    ERA_ON_WRITE(345);
    ERA_ON_WRITE(346);
    ERA_ON_WRITE(347);
    ERA_ON_WRITE(348);
    ERA_ON_WRITE(349);
    ERA_ON_WRITE(350);
    ERA_ON_WRITE(351);
    ERA_ON_WRITE(352);
    ERA_ON_WRITE(353);
    ERA_ON_WRITE(354);
    ERA_ON_WRITE(355);
    ERA_ON_WRITE(356);
    ERA_ON_WRITE(357);
    ERA_ON_WRITE(358);
    ERA_ON_WRITE(359);
    ERA_ON_WRITE(360);
    ERA_ON_WRITE(361);
    ERA_ON_WRITE(362);
    ERA_ON_WRITE(363);
    ERA_ON_WRITE(364);
    ERA_ON_WRITE(365);
    ERA_ON_WRITE(366);
    ERA_ON_WRITE(367);
    ERA_ON_WRITE(368);
    ERA_ON_WRITE(369);
    ERA_ON_WRITE(370);
    ERA_ON_WRITE(371);
    ERA_ON_WRITE(372);
    ERA_ON_WRITE(373);
    ERA_ON_WRITE(374);
    ERA_ON_WRITE(375);
    ERA_ON_WRITE(376);
    ERA_ON_WRITE(377);
    ERA_ON_WRITE(378);
    ERA_ON_WRITE(379);
    ERA_ON_WRITE(380);
    ERA_ON_WRITE(381);
    ERA_ON_WRITE(382);
    ERA_ON_WRITE(383);
    ERA_ON_WRITE(384);
    ERA_ON_WRITE(385);
    ERA_ON_WRITE(386);
    ERA_ON_WRITE(387);
    ERA_ON_WRITE(388);
    ERA_ON_WRITE(389);
    ERA_ON_WRITE(390);
    ERA_ON_WRITE(391);
    ERA_ON_WRITE(392);
    ERA_ON_WRITE(393);
    ERA_ON_WRITE(394);
    ERA_ON_WRITE(395);
    ERA_ON_WRITE(396);
    ERA_ON_WRITE(397);
    ERA_ON_WRITE(398);
    ERA_ON_WRITE(399);
    ERA_ON_WRITE(400);
    ERA_ON_WRITE(401);
    ERA_ON_WRITE(402);
    ERA_ON_WRITE(403);
    ERA_ON_WRITE(404);
    ERA_ON_WRITE(405);
    ERA_ON_WRITE(406);
    ERA_ON_WRITE(407);
    ERA_ON_WRITE(408);
    ERA_ON_WRITE(409);
    ERA_ON_WRITE(410);
    ERA_ON_WRITE(411);
    ERA_ON_WRITE(412);
    ERA_ON_WRITE(413);
    ERA_ON_WRITE(414);
    ERA_ON_WRITE(415);
    ERA_ON_WRITE(416);
    ERA_ON_WRITE(417);
    ERA_ON_WRITE(418);
    ERA_ON_WRITE(419);
    ERA_ON_WRITE(420);
    ERA_ON_WRITE(421);
    ERA_ON_WRITE(422);
    ERA_ON_WRITE(423);
    ERA_ON_WRITE(424);
    ERA_ON_WRITE(425);
    ERA_ON_WRITE(426);
    ERA_ON_WRITE(427);
    ERA_ON_WRITE(428);
    ERA_ON_WRITE(429);
    ERA_ON_WRITE(430);
    ERA_ON_WRITE(431);
    ERA_ON_WRITE(432);
    ERA_ON_WRITE(433);
    ERA_ON_WRITE(434);
    ERA_ON_WRITE(435);
    ERA_ON_WRITE(436);
    ERA_ON_WRITE(437);
    ERA_ON_WRITE(438);
    ERA_ON_WRITE(439);
    ERA_ON_WRITE(440);
    ERA_ON_WRITE(441);
    ERA_ON_WRITE(442);
    ERA_ON_WRITE(443);
    ERA_ON_WRITE(444);
    ERA_ON_WRITE(445);
    ERA_ON_WRITE(446);
    ERA_ON_WRITE(447);
    ERA_ON_WRITE(448);
    ERA_ON_WRITE(449);
    ERA_ON_WRITE(450);
    ERA_ON_WRITE(451);
    ERA_ON_WRITE(452);
    ERA_ON_WRITE(453);
    ERA_ON_WRITE(454);
    ERA_ON_WRITE(455);
    ERA_ON_WRITE(456);
    ERA_ON_WRITE(457);
    ERA_ON_WRITE(458);
    ERA_ON_WRITE(459);
    ERA_ON_WRITE(460);
    ERA_ON_WRITE(461);
    ERA_ON_WRITE(462);
    ERA_ON_WRITE(463);
    ERA_ON_WRITE(464);
    ERA_ON_WRITE(465);
    ERA_ON_WRITE(466);
    ERA_ON_WRITE(467);
    ERA_ON_WRITE(468);
    ERA_ON_WRITE(469);
    ERA_ON_WRITE(470);
    ERA_ON_WRITE(471);
    ERA_ON_WRITE(472);
    ERA_ON_WRITE(473);
    ERA_ON_WRITE(474);
    ERA_ON_WRITE(475);
    ERA_ON_WRITE(476);
    ERA_ON_WRITE(477);
    ERA_ON_WRITE(478);
    ERA_ON_WRITE(479);
    ERA_ON_WRITE(480);
    ERA_ON_WRITE(481);
    ERA_ON_WRITE(482);
    ERA_ON_WRITE(483);
    ERA_ON_WRITE(484);
    ERA_ON_WRITE(485);
    ERA_ON_WRITE(486);
    ERA_ON_WRITE(487);
    ERA_ON_WRITE(488);
    ERA_ON_WRITE(489);
    ERA_ON_WRITE(490);
    ERA_ON_WRITE(491);
    ERA_ON_WRITE(492);
    ERA_ON_WRITE(493);
    ERA_ON_WRITE(494);
    ERA_ON_WRITE(495);
    ERA_ON_WRITE(496);
    ERA_ON_WRITE(497);
    ERA_ON_WRITE(498);
    ERA_ON_WRITE(499);
#endif

ERA_ON_PIN_READ( 0);
ERA_ON_PIN_READ( 1);
ERA_ON_PIN_READ( 2);
ERA_ON_PIN_READ( 3);
ERA_ON_PIN_READ( 4);
ERA_ON_PIN_READ( 5);
ERA_ON_PIN_READ( 6);
ERA_ON_PIN_READ( 7);
ERA_ON_PIN_READ( 8);
ERA_ON_PIN_READ( 9);
ERA_ON_PIN_READ(10);
ERA_ON_PIN_READ(11);
ERA_ON_PIN_READ(12);
ERA_ON_PIN_READ(13);
ERA_ON_PIN_READ(14);
ERA_ON_PIN_READ(15);
ERA_ON_PIN_READ(16);
ERA_ON_PIN_READ(17);
ERA_ON_PIN_READ(18);
ERA_ON_PIN_READ(19);
ERA_ON_PIN_READ(20);
ERA_ON_PIN_READ(21);
ERA_ON_PIN_READ(22);
ERA_ON_PIN_READ(23);
ERA_ON_PIN_READ(24);
ERA_ON_PIN_READ(25);
ERA_ON_PIN_READ(26);
ERA_ON_PIN_READ(27);
ERA_ON_PIN_READ(28);
ERA_ON_PIN_READ(29);
ERA_ON_PIN_READ(30);
ERA_ON_PIN_READ(31);
ERA_ON_PIN_READ(32);
ERA_ON_PIN_READ(33);
ERA_ON_PIN_READ(34);
ERA_ON_PIN_READ(35);
ERA_ON_PIN_READ(36);
ERA_ON_PIN_READ(37);
ERA_ON_PIN_READ(38);
ERA_ON_PIN_READ(39);
ERA_ON_PIN_READ(40);
ERA_ON_PIN_READ(41);
ERA_ON_PIN_READ(42);
ERA_ON_PIN_READ(43);
ERA_ON_PIN_READ(44);
ERA_ON_PIN_READ(45);
ERA_ON_PIN_READ(46);
ERA_ON_PIN_READ(47);
ERA_ON_PIN_READ(48);
ERA_ON_PIN_READ(49);
#if defined(ERA_100_PINS)
    ERA_ON_PIN_READ(50);
    ERA_ON_PIN_READ(51);
    ERA_ON_PIN_READ(52);
    ERA_ON_PIN_READ(53);
    ERA_ON_PIN_READ(54);
    ERA_ON_PIN_READ(55);
    ERA_ON_PIN_READ(56);
    ERA_ON_PIN_READ(57);
    ERA_ON_PIN_READ(58);
    ERA_ON_PIN_READ(59);
    ERA_ON_PIN_READ(60);
    ERA_ON_PIN_READ(61);
    ERA_ON_PIN_READ(62);
    ERA_ON_PIN_READ(63);
    ERA_ON_PIN_READ(64);
    ERA_ON_PIN_READ(65);
    ERA_ON_PIN_READ(66);
    ERA_ON_PIN_READ(67);
    ERA_ON_PIN_READ(68);
    ERA_ON_PIN_READ(69);
    ERA_ON_PIN_READ(70);
    ERA_ON_PIN_READ(71);
    ERA_ON_PIN_READ(72);
    ERA_ON_PIN_READ(73);
    ERA_ON_PIN_READ(74);
    ERA_ON_PIN_READ(75);
    ERA_ON_PIN_READ(76);
    ERA_ON_PIN_READ(77);
    ERA_ON_PIN_READ(78);
    ERA_ON_PIN_READ(79);
    ERA_ON_PIN_READ(80);
    ERA_ON_PIN_READ(81);
    ERA_ON_PIN_READ(82);
    ERA_ON_PIN_READ(83);
    ERA_ON_PIN_READ(84);
    ERA_ON_PIN_READ(85);
    ERA_ON_PIN_READ(86);
    ERA_ON_PIN_READ(87);
    ERA_ON_PIN_READ(88);
    ERA_ON_PIN_READ(89);
    ERA_ON_PIN_READ(90);
    ERA_ON_PIN_READ(91);
    ERA_ON_PIN_READ(92);
    ERA_ON_PIN_READ(93);
    ERA_ON_PIN_READ(94);
    ERA_ON_PIN_READ(95);
    ERA_ON_PIN_READ(96);
    ERA_ON_PIN_READ(97);
    ERA_ON_PIN_READ(98);
    ERA_ON_PIN_READ(99);
#endif
#if defined(ERA_255_PINS)
    ERA_ON_PIN_READ(100);
    ERA_ON_PIN_READ(101);
    ERA_ON_PIN_READ(102);
    ERA_ON_PIN_READ(103);
    ERA_ON_PIN_READ(104);
    ERA_ON_PIN_READ(105);
    ERA_ON_PIN_READ(106);
    ERA_ON_PIN_READ(107);
    ERA_ON_PIN_READ(108);
    ERA_ON_PIN_READ(109);
    ERA_ON_PIN_READ(110);
    ERA_ON_PIN_READ(111);
    ERA_ON_PIN_READ(112);
    ERA_ON_PIN_READ(113);
    ERA_ON_PIN_READ(114);
    ERA_ON_PIN_READ(115);
    ERA_ON_PIN_READ(116);
    ERA_ON_PIN_READ(117);
    ERA_ON_PIN_READ(118);
    ERA_ON_PIN_READ(119);
    ERA_ON_PIN_READ(120);
    ERA_ON_PIN_READ(121);
    ERA_ON_PIN_READ(122);
    ERA_ON_PIN_READ(123);
    ERA_ON_PIN_READ(124);
    ERA_ON_PIN_READ(125);
    ERA_ON_PIN_READ(126);
    ERA_ON_PIN_READ(127);
    ERA_ON_PIN_READ(128);
    ERA_ON_PIN_READ(129);
    ERA_ON_PIN_READ(130);
    ERA_ON_PIN_READ(131);
    ERA_ON_PIN_READ(132);
    ERA_ON_PIN_READ(133);
    ERA_ON_PIN_READ(134);
    ERA_ON_PIN_READ(135);
    ERA_ON_PIN_READ(136);
    ERA_ON_PIN_READ(137);
    ERA_ON_PIN_READ(138);
    ERA_ON_PIN_READ(139);
    ERA_ON_PIN_READ(140);
    ERA_ON_PIN_READ(141);
    ERA_ON_PIN_READ(142);
    ERA_ON_PIN_READ(143);
    ERA_ON_PIN_READ(144);
    ERA_ON_PIN_READ(145);
    ERA_ON_PIN_READ(146);
    ERA_ON_PIN_READ(147);
    ERA_ON_PIN_READ(148);
    ERA_ON_PIN_READ(149);
    ERA_ON_PIN_READ(150);
    ERA_ON_PIN_READ(151);
    ERA_ON_PIN_READ(152);
    ERA_ON_PIN_READ(153);
    ERA_ON_PIN_READ(154);
    ERA_ON_PIN_READ(155);
    ERA_ON_PIN_READ(156);
    ERA_ON_PIN_READ(157);
    ERA_ON_PIN_READ(158);
    ERA_ON_PIN_READ(159);
    ERA_ON_PIN_READ(160);
    ERA_ON_PIN_READ(161);
    ERA_ON_PIN_READ(162);
    ERA_ON_PIN_READ(163);
    ERA_ON_PIN_READ(164);
    ERA_ON_PIN_READ(165);
    ERA_ON_PIN_READ(166);
    ERA_ON_PIN_READ(167);
    ERA_ON_PIN_READ(168);
    ERA_ON_PIN_READ(169);
    ERA_ON_PIN_READ(170);
    ERA_ON_PIN_READ(171);
    ERA_ON_PIN_READ(172);
    ERA_ON_PIN_READ(173);
    ERA_ON_PIN_READ(174);
    ERA_ON_PIN_READ(175);
    ERA_ON_PIN_READ(176);
    ERA_ON_PIN_READ(177);
    ERA_ON_PIN_READ(178);
    ERA_ON_PIN_READ(179);
    ERA_ON_PIN_READ(180);
    ERA_ON_PIN_READ(181);
    ERA_ON_PIN_READ(182);
    ERA_ON_PIN_READ(183);
    ERA_ON_PIN_READ(184);
    ERA_ON_PIN_READ(185);
    ERA_ON_PIN_READ(186);
    ERA_ON_PIN_READ(187);
    ERA_ON_PIN_READ(188);
    ERA_ON_PIN_READ(189);
    ERA_ON_PIN_READ(190);
    ERA_ON_PIN_READ(191);
    ERA_ON_PIN_READ(192);
    ERA_ON_PIN_READ(193);
    ERA_ON_PIN_READ(194);
    ERA_ON_PIN_READ(195);
    ERA_ON_PIN_READ(196);
    ERA_ON_PIN_READ(197);
    ERA_ON_PIN_READ(198);
    ERA_ON_PIN_READ(199);
    ERA_ON_PIN_READ(200);
    ERA_ON_PIN_READ(201);
    ERA_ON_PIN_READ(202);
    ERA_ON_PIN_READ(203);
    ERA_ON_PIN_READ(204);
    ERA_ON_PIN_READ(205);
    ERA_ON_PIN_READ(206);
    ERA_ON_PIN_READ(207);
    ERA_ON_PIN_READ(208);
    ERA_ON_PIN_READ(209);
    ERA_ON_PIN_READ(210);
    ERA_ON_PIN_READ(211);
    ERA_ON_PIN_READ(212);
    ERA_ON_PIN_READ(213);
    ERA_ON_PIN_READ(214);
    ERA_ON_PIN_READ(215);
    ERA_ON_PIN_READ(216);
    ERA_ON_PIN_READ(217);
    ERA_ON_PIN_READ(218);
    ERA_ON_PIN_READ(219);
    ERA_ON_PIN_READ(220);
    ERA_ON_PIN_READ(221);
    ERA_ON_PIN_READ(222);
    ERA_ON_PIN_READ(223);
    ERA_ON_PIN_READ(224);
    ERA_ON_PIN_READ(225);
    ERA_ON_PIN_READ(226);
    ERA_ON_PIN_READ(227);
    ERA_ON_PIN_READ(228);
    ERA_ON_PIN_READ(229);
    ERA_ON_PIN_READ(230);
    ERA_ON_PIN_READ(231);
    ERA_ON_PIN_READ(232);
    ERA_ON_PIN_READ(233);
    ERA_ON_PIN_READ(234);
    ERA_ON_PIN_READ(235);
    ERA_ON_PIN_READ(236);
    ERA_ON_PIN_READ(237);
    ERA_ON_PIN_READ(238);
    ERA_ON_PIN_READ(239);
    ERA_ON_PIN_READ(240);
    ERA_ON_PIN_READ(241);
    ERA_ON_PIN_READ(242);
    ERA_ON_PIN_READ(243);
    ERA_ON_PIN_READ(244);
    ERA_ON_PIN_READ(245);
    ERA_ON_PIN_READ(246);
    ERA_ON_PIN_READ(247);
    ERA_ON_PIN_READ(248);
    ERA_ON_PIN_READ(249);
    ERA_ON_PIN_READ(250);
    ERA_ON_PIN_READ(251);
    ERA_ON_PIN_READ(252);
    ERA_ON_PIN_READ(253);
    ERA_ON_PIN_READ(254);
    ERA_ON_PIN_READ(255);
#endif
#if defined(ERA_500_PINS)
    ERA_ON_PIN_READ(256);
    ERA_ON_PIN_READ(257);
    ERA_ON_PIN_READ(258);
    ERA_ON_PIN_READ(259);
    ERA_ON_PIN_READ(260);
    ERA_ON_PIN_READ(261);
    ERA_ON_PIN_READ(262);
    ERA_ON_PIN_READ(263);
    ERA_ON_PIN_READ(264);
    ERA_ON_PIN_READ(265);
    ERA_ON_PIN_READ(266);
    ERA_ON_PIN_READ(267);
    ERA_ON_PIN_READ(268);
    ERA_ON_PIN_READ(269);
    ERA_ON_PIN_READ(270);
    ERA_ON_PIN_READ(271);
    ERA_ON_PIN_READ(272);
    ERA_ON_PIN_READ(273);
    ERA_ON_PIN_READ(274);
    ERA_ON_PIN_READ(275);
    ERA_ON_PIN_READ(276);
    ERA_ON_PIN_READ(277);
    ERA_ON_PIN_READ(278);
    ERA_ON_PIN_READ(279);
    ERA_ON_PIN_READ(280);
    ERA_ON_PIN_READ(281);
    ERA_ON_PIN_READ(282);
    ERA_ON_PIN_READ(283);
    ERA_ON_PIN_READ(284);
    ERA_ON_PIN_READ(285);
    ERA_ON_PIN_READ(286);
    ERA_ON_PIN_READ(287);
    ERA_ON_PIN_READ(288);
    ERA_ON_PIN_READ(289);
    ERA_ON_PIN_READ(290);
    ERA_ON_PIN_READ(291);
    ERA_ON_PIN_READ(292);
    ERA_ON_PIN_READ(293);
    ERA_ON_PIN_READ(294);
    ERA_ON_PIN_READ(295);
    ERA_ON_PIN_READ(296);
    ERA_ON_PIN_READ(297);
    ERA_ON_PIN_READ(298);
    ERA_ON_PIN_READ(299);
    ERA_ON_PIN_READ(300);
    ERA_ON_PIN_READ(301);
    ERA_ON_PIN_READ(302);
    ERA_ON_PIN_READ(303);
    ERA_ON_PIN_READ(304);
    ERA_ON_PIN_READ(305);
    ERA_ON_PIN_READ(306);
    ERA_ON_PIN_READ(307);
    ERA_ON_PIN_READ(308);
    ERA_ON_PIN_READ(309);
    ERA_ON_PIN_READ(310);
    ERA_ON_PIN_READ(311);
    ERA_ON_PIN_READ(312);
    ERA_ON_PIN_READ(313);
    ERA_ON_PIN_READ(314);
    ERA_ON_PIN_READ(315);
    ERA_ON_PIN_READ(316);
    ERA_ON_PIN_READ(317);
    ERA_ON_PIN_READ(318);
    ERA_ON_PIN_READ(319);
    ERA_ON_PIN_READ(320);
    ERA_ON_PIN_READ(321);
    ERA_ON_PIN_READ(322);
    ERA_ON_PIN_READ(323);
    ERA_ON_PIN_READ(324);
    ERA_ON_PIN_READ(325);
    ERA_ON_PIN_READ(326);
    ERA_ON_PIN_READ(327);
    ERA_ON_PIN_READ(328);
    ERA_ON_PIN_READ(329);
    ERA_ON_PIN_READ(330);
    ERA_ON_PIN_READ(331);
    ERA_ON_PIN_READ(332);
    ERA_ON_PIN_READ(333);
    ERA_ON_PIN_READ(334);
    ERA_ON_PIN_READ(335);
    ERA_ON_PIN_READ(336);
    ERA_ON_PIN_READ(337);
    ERA_ON_PIN_READ(338);
    ERA_ON_PIN_READ(339);
    ERA_ON_PIN_READ(340);
    ERA_ON_PIN_READ(341);
    ERA_ON_PIN_READ(342);
    ERA_ON_PIN_READ(343);
    ERA_ON_PIN_READ(344);
    ERA_ON_PIN_READ(345);
    ERA_ON_PIN_READ(346);
    ERA_ON_PIN_READ(347);
    ERA_ON_PIN_READ(348);
    ERA_ON_PIN_READ(349);
    ERA_ON_PIN_READ(350);
    ERA_ON_PIN_READ(351);
    ERA_ON_PIN_READ(352);
    ERA_ON_PIN_READ(353);
    ERA_ON_PIN_READ(354);
    ERA_ON_PIN_READ(355);
    ERA_ON_PIN_READ(356);
    ERA_ON_PIN_READ(357);
    ERA_ON_PIN_READ(358);
    ERA_ON_PIN_READ(359);
    ERA_ON_PIN_READ(360);
    ERA_ON_PIN_READ(361);
    ERA_ON_PIN_READ(362);
    ERA_ON_PIN_READ(363);
    ERA_ON_PIN_READ(364);
    ERA_ON_PIN_READ(365);
    ERA_ON_PIN_READ(366);
    ERA_ON_PIN_READ(367);
    ERA_ON_PIN_READ(368);
    ERA_ON_PIN_READ(369);
    ERA_ON_PIN_READ(370);
    ERA_ON_PIN_READ(371);
    ERA_ON_PIN_READ(372);
    ERA_ON_PIN_READ(373);
    ERA_ON_PIN_READ(374);
    ERA_ON_PIN_READ(375);
    ERA_ON_PIN_READ(376);
    ERA_ON_PIN_READ(377);
    ERA_ON_PIN_READ(378);
    ERA_ON_PIN_READ(379);
    ERA_ON_PIN_READ(380);
    ERA_ON_PIN_READ(381);
    ERA_ON_PIN_READ(382);
    ERA_ON_PIN_READ(383);
    ERA_ON_PIN_READ(384);
    ERA_ON_PIN_READ(385);
    ERA_ON_PIN_READ(386);
    ERA_ON_PIN_READ(387);
    ERA_ON_PIN_READ(388);
    ERA_ON_PIN_READ(389);
    ERA_ON_PIN_READ(390);
    ERA_ON_PIN_READ(391);
    ERA_ON_PIN_READ(392);
    ERA_ON_PIN_READ(393);
    ERA_ON_PIN_READ(394);
    ERA_ON_PIN_READ(395);
    ERA_ON_PIN_READ(396);
    ERA_ON_PIN_READ(397);
    ERA_ON_PIN_READ(398);
    ERA_ON_PIN_READ(399);
    ERA_ON_PIN_READ(400);
    ERA_ON_PIN_READ(401);
    ERA_ON_PIN_READ(402);
    ERA_ON_PIN_READ(403);
    ERA_ON_PIN_READ(404);
    ERA_ON_PIN_READ(405);
    ERA_ON_PIN_READ(406);
    ERA_ON_PIN_READ(407);
    ERA_ON_PIN_READ(408);
    ERA_ON_PIN_READ(409);
    ERA_ON_PIN_READ(410);
    ERA_ON_PIN_READ(411);
    ERA_ON_PIN_READ(412);
    ERA_ON_PIN_READ(413);
    ERA_ON_PIN_READ(414);
    ERA_ON_PIN_READ(415);
    ERA_ON_PIN_READ(416);
    ERA_ON_PIN_READ(417);
    ERA_ON_PIN_READ(418);
    ERA_ON_PIN_READ(419);
    ERA_ON_PIN_READ(420);
    ERA_ON_PIN_READ(421);
    ERA_ON_PIN_READ(422);
    ERA_ON_PIN_READ(423);
    ERA_ON_PIN_READ(424);
    ERA_ON_PIN_READ(425);
    ERA_ON_PIN_READ(426);
    ERA_ON_PIN_READ(427);
    ERA_ON_PIN_READ(428);
    ERA_ON_PIN_READ(429);
    ERA_ON_PIN_READ(430);
    ERA_ON_PIN_READ(431);
    ERA_ON_PIN_READ(432);
    ERA_ON_PIN_READ(433);
    ERA_ON_PIN_READ(434);
    ERA_ON_PIN_READ(435);
    ERA_ON_PIN_READ(436);
    ERA_ON_PIN_READ(437);
    ERA_ON_PIN_READ(438);
    ERA_ON_PIN_READ(439);
    ERA_ON_PIN_READ(440);
    ERA_ON_PIN_READ(441);
    ERA_ON_PIN_READ(442);
    ERA_ON_PIN_READ(443);
    ERA_ON_PIN_READ(444);
    ERA_ON_PIN_READ(445);
    ERA_ON_PIN_READ(446);
    ERA_ON_PIN_READ(447);
    ERA_ON_PIN_READ(448);
    ERA_ON_PIN_READ(449);
    ERA_ON_PIN_READ(450);
    ERA_ON_PIN_READ(451);
    ERA_ON_PIN_READ(452);
    ERA_ON_PIN_READ(453);
    ERA_ON_PIN_READ(454);
    ERA_ON_PIN_READ(455);
    ERA_ON_PIN_READ(456);
    ERA_ON_PIN_READ(457);
    ERA_ON_PIN_READ(458);
    ERA_ON_PIN_READ(459);
    ERA_ON_PIN_READ(460);
    ERA_ON_PIN_READ(461);
    ERA_ON_PIN_READ(462);
    ERA_ON_PIN_READ(463);
    ERA_ON_PIN_READ(464);
    ERA_ON_PIN_READ(465);
    ERA_ON_PIN_READ(466);
    ERA_ON_PIN_READ(467);
    ERA_ON_PIN_READ(468);
    ERA_ON_PIN_READ(469);
    ERA_ON_PIN_READ(470);
    ERA_ON_PIN_READ(471);
    ERA_ON_PIN_READ(472);
    ERA_ON_PIN_READ(473);
    ERA_ON_PIN_READ(474);
    ERA_ON_PIN_READ(475);
    ERA_ON_PIN_READ(476);
    ERA_ON_PIN_READ(477);
    ERA_ON_PIN_READ(478);
    ERA_ON_PIN_READ(479);
    ERA_ON_PIN_READ(480);
    ERA_ON_PIN_READ(481);
    ERA_ON_PIN_READ(482);
    ERA_ON_PIN_READ(483);
    ERA_ON_PIN_READ(484);
    ERA_ON_PIN_READ(485);
    ERA_ON_PIN_READ(486);
    ERA_ON_PIN_READ(487);
    ERA_ON_PIN_READ(488);
    ERA_ON_PIN_READ(489);
    ERA_ON_PIN_READ(490);
    ERA_ON_PIN_READ(491);
    ERA_ON_PIN_READ(492);
    ERA_ON_PIN_READ(493);
    ERA_ON_PIN_READ(494);
    ERA_ON_PIN_READ(495);
    ERA_ON_PIN_READ(496);
    ERA_ON_PIN_READ(497);
    ERA_ON_PIN_READ(498);
    ERA_ON_PIN_READ(499);
#endif

ERA_ON_PIN_WRITE( 0);
ERA_ON_PIN_WRITE( 1);
ERA_ON_PIN_WRITE( 2);
ERA_ON_PIN_WRITE( 3);
ERA_ON_PIN_WRITE( 4);
ERA_ON_PIN_WRITE( 5);
ERA_ON_PIN_WRITE( 6);
ERA_ON_PIN_WRITE( 7);
ERA_ON_PIN_WRITE( 8);
ERA_ON_PIN_WRITE( 9);
ERA_ON_PIN_WRITE(10);
ERA_ON_PIN_WRITE(11);
ERA_ON_PIN_WRITE(12);
ERA_ON_PIN_WRITE(13);
ERA_ON_PIN_WRITE(14);
ERA_ON_PIN_WRITE(15);
ERA_ON_PIN_WRITE(16);
ERA_ON_PIN_WRITE(17);
ERA_ON_PIN_WRITE(18);
ERA_ON_PIN_WRITE(19);
ERA_ON_PIN_WRITE(20);
ERA_ON_PIN_WRITE(21);
ERA_ON_PIN_WRITE(22);
ERA_ON_PIN_WRITE(23);
ERA_ON_PIN_WRITE(24);
ERA_ON_PIN_WRITE(25);
ERA_ON_PIN_WRITE(26);
ERA_ON_PIN_WRITE(27);
ERA_ON_PIN_WRITE(28);
ERA_ON_PIN_WRITE(29);
ERA_ON_PIN_WRITE(30);
ERA_ON_PIN_WRITE(31);
ERA_ON_PIN_WRITE(32);
ERA_ON_PIN_WRITE(33);
ERA_ON_PIN_WRITE(34);
ERA_ON_PIN_WRITE(35);
ERA_ON_PIN_WRITE(36);
ERA_ON_PIN_WRITE(37);
ERA_ON_PIN_WRITE(38);
ERA_ON_PIN_WRITE(39);
ERA_ON_PIN_WRITE(40);
ERA_ON_PIN_WRITE(41);
ERA_ON_PIN_WRITE(42);
ERA_ON_PIN_WRITE(43);
ERA_ON_PIN_WRITE(44);
ERA_ON_PIN_WRITE(45);
ERA_ON_PIN_WRITE(46);
ERA_ON_PIN_WRITE(47);
ERA_ON_PIN_WRITE(48);
ERA_ON_PIN_WRITE(49);
#if defined(ERA_100_PINS)
    ERA_ON_PIN_WRITE(50);
    ERA_ON_PIN_WRITE(51);
    ERA_ON_PIN_WRITE(52);
    ERA_ON_PIN_WRITE(53);
    ERA_ON_PIN_WRITE(54);
    ERA_ON_PIN_WRITE(55);
    ERA_ON_PIN_WRITE(56);
    ERA_ON_PIN_WRITE(57);
    ERA_ON_PIN_WRITE(58);
    ERA_ON_PIN_WRITE(59);
    ERA_ON_PIN_WRITE(60);
    ERA_ON_PIN_WRITE(61);
    ERA_ON_PIN_WRITE(62);
    ERA_ON_PIN_WRITE(63);
    ERA_ON_PIN_WRITE(64);
    ERA_ON_PIN_WRITE(65);
    ERA_ON_PIN_WRITE(66);
    ERA_ON_PIN_WRITE(67);
    ERA_ON_PIN_WRITE(68);
    ERA_ON_PIN_WRITE(69);
    ERA_ON_PIN_WRITE(70);
    ERA_ON_PIN_WRITE(71);
    ERA_ON_PIN_WRITE(72);
    ERA_ON_PIN_WRITE(73);
    ERA_ON_PIN_WRITE(74);
    ERA_ON_PIN_WRITE(75);
    ERA_ON_PIN_WRITE(76);
    ERA_ON_PIN_WRITE(77);
    ERA_ON_PIN_WRITE(78);
    ERA_ON_PIN_WRITE(79);
    ERA_ON_PIN_WRITE(80);
    ERA_ON_PIN_WRITE(81);
    ERA_ON_PIN_WRITE(82);
    ERA_ON_PIN_WRITE(83);
    ERA_ON_PIN_WRITE(84);
    ERA_ON_PIN_WRITE(85);
    ERA_ON_PIN_WRITE(86);
    ERA_ON_PIN_WRITE(87);
    ERA_ON_PIN_WRITE(88);
    ERA_ON_PIN_WRITE(89);
    ERA_ON_PIN_WRITE(90);
    ERA_ON_PIN_WRITE(91);
    ERA_ON_PIN_WRITE(92);
    ERA_ON_PIN_WRITE(93);
    ERA_ON_PIN_WRITE(94);
    ERA_ON_PIN_WRITE(95);
    ERA_ON_PIN_WRITE(96);
    ERA_ON_PIN_WRITE(97);
    ERA_ON_PIN_WRITE(98);
    ERA_ON_PIN_WRITE(99);
#endif
#if defined(ERA_255_PINS)
    ERA_ON_PIN_WRITE(100);
    ERA_ON_PIN_WRITE(101);
    ERA_ON_PIN_WRITE(102);
    ERA_ON_PIN_WRITE(103);
    ERA_ON_PIN_WRITE(104);
    ERA_ON_PIN_WRITE(105);
    ERA_ON_PIN_WRITE(106);
    ERA_ON_PIN_WRITE(107);
    ERA_ON_PIN_WRITE(108);
    ERA_ON_PIN_WRITE(109);
    ERA_ON_PIN_WRITE(110);
    ERA_ON_PIN_WRITE(111);
    ERA_ON_PIN_WRITE(112);
    ERA_ON_PIN_WRITE(113);
    ERA_ON_PIN_WRITE(114);
    ERA_ON_PIN_WRITE(115);
    ERA_ON_PIN_WRITE(116);
    ERA_ON_PIN_WRITE(117);
    ERA_ON_PIN_WRITE(118);
    ERA_ON_PIN_WRITE(119);
    ERA_ON_PIN_WRITE(120);
    ERA_ON_PIN_WRITE(121);
    ERA_ON_PIN_WRITE(122);
    ERA_ON_PIN_WRITE(123);
    ERA_ON_PIN_WRITE(124);
    ERA_ON_PIN_WRITE(125);
    ERA_ON_PIN_WRITE(126);
    ERA_ON_PIN_WRITE(127);
    ERA_ON_PIN_WRITE(128);
    ERA_ON_PIN_WRITE(129);
    ERA_ON_PIN_WRITE(130);
    ERA_ON_PIN_WRITE(131);
    ERA_ON_PIN_WRITE(132);
    ERA_ON_PIN_WRITE(133);
    ERA_ON_PIN_WRITE(134);
    ERA_ON_PIN_WRITE(135);
    ERA_ON_PIN_WRITE(136);
    ERA_ON_PIN_WRITE(137);
    ERA_ON_PIN_WRITE(138);
    ERA_ON_PIN_WRITE(139);
    ERA_ON_PIN_WRITE(140);
    ERA_ON_PIN_WRITE(141);
    ERA_ON_PIN_WRITE(142);
    ERA_ON_PIN_WRITE(143);
    ERA_ON_PIN_WRITE(144);
    ERA_ON_PIN_WRITE(145);
    ERA_ON_PIN_WRITE(146);
    ERA_ON_PIN_WRITE(147);
    ERA_ON_PIN_WRITE(148);
    ERA_ON_PIN_WRITE(149);
    ERA_ON_PIN_WRITE(150);
    ERA_ON_PIN_WRITE(151);
    ERA_ON_PIN_WRITE(152);
    ERA_ON_PIN_WRITE(153);
    ERA_ON_PIN_WRITE(154);
    ERA_ON_PIN_WRITE(155);
    ERA_ON_PIN_WRITE(156);
    ERA_ON_PIN_WRITE(157);
    ERA_ON_PIN_WRITE(158);
    ERA_ON_PIN_WRITE(159);
    ERA_ON_PIN_WRITE(160);
    ERA_ON_PIN_WRITE(161);
    ERA_ON_PIN_WRITE(162);
    ERA_ON_PIN_WRITE(163);
    ERA_ON_PIN_WRITE(164);
    ERA_ON_PIN_WRITE(165);
    ERA_ON_PIN_WRITE(166);
    ERA_ON_PIN_WRITE(167);
    ERA_ON_PIN_WRITE(168);
    ERA_ON_PIN_WRITE(169);
    ERA_ON_PIN_WRITE(170);
    ERA_ON_PIN_WRITE(171);
    ERA_ON_PIN_WRITE(172);
    ERA_ON_PIN_WRITE(173);
    ERA_ON_PIN_WRITE(174);
    ERA_ON_PIN_WRITE(175);
    ERA_ON_PIN_WRITE(176);
    ERA_ON_PIN_WRITE(177);
    ERA_ON_PIN_WRITE(178);
    ERA_ON_PIN_WRITE(179);
    ERA_ON_PIN_WRITE(180);
    ERA_ON_PIN_WRITE(181);
    ERA_ON_PIN_WRITE(182);
    ERA_ON_PIN_WRITE(183);
    ERA_ON_PIN_WRITE(184);
    ERA_ON_PIN_WRITE(185);
    ERA_ON_PIN_WRITE(186);
    ERA_ON_PIN_WRITE(187);
    ERA_ON_PIN_WRITE(188);
    ERA_ON_PIN_WRITE(189);
    ERA_ON_PIN_WRITE(190);
    ERA_ON_PIN_WRITE(191);
    ERA_ON_PIN_WRITE(192);
    ERA_ON_PIN_WRITE(193);
    ERA_ON_PIN_WRITE(194);
    ERA_ON_PIN_WRITE(195);
    ERA_ON_PIN_WRITE(196);
    ERA_ON_PIN_WRITE(197);
    ERA_ON_PIN_WRITE(198);
    ERA_ON_PIN_WRITE(199);
    ERA_ON_PIN_WRITE(200);
    ERA_ON_PIN_WRITE(201);
    ERA_ON_PIN_WRITE(202);
    ERA_ON_PIN_WRITE(203);
    ERA_ON_PIN_WRITE(204);
    ERA_ON_PIN_WRITE(205);
    ERA_ON_PIN_WRITE(206);
    ERA_ON_PIN_WRITE(207);
    ERA_ON_PIN_WRITE(208);
    ERA_ON_PIN_WRITE(209);
    ERA_ON_PIN_WRITE(210);
    ERA_ON_PIN_WRITE(211);
    ERA_ON_PIN_WRITE(212);
    ERA_ON_PIN_WRITE(213);
    ERA_ON_PIN_WRITE(214);
    ERA_ON_PIN_WRITE(215);
    ERA_ON_PIN_WRITE(216);
    ERA_ON_PIN_WRITE(217);
    ERA_ON_PIN_WRITE(218);
    ERA_ON_PIN_WRITE(219);
    ERA_ON_PIN_WRITE(220);
    ERA_ON_PIN_WRITE(221);
    ERA_ON_PIN_WRITE(222);
    ERA_ON_PIN_WRITE(223);
    ERA_ON_PIN_WRITE(224);
    ERA_ON_PIN_WRITE(225);
    ERA_ON_PIN_WRITE(226);
    ERA_ON_PIN_WRITE(227);
    ERA_ON_PIN_WRITE(228);
    ERA_ON_PIN_WRITE(229);
    ERA_ON_PIN_WRITE(230);
    ERA_ON_PIN_WRITE(231);
    ERA_ON_PIN_WRITE(232);
    ERA_ON_PIN_WRITE(233);
    ERA_ON_PIN_WRITE(234);
    ERA_ON_PIN_WRITE(235);
    ERA_ON_PIN_WRITE(236);
    ERA_ON_PIN_WRITE(237);
    ERA_ON_PIN_WRITE(238);
    ERA_ON_PIN_WRITE(239);
    ERA_ON_PIN_WRITE(240);
    ERA_ON_PIN_WRITE(241);
    ERA_ON_PIN_WRITE(242);
    ERA_ON_PIN_WRITE(243);
    ERA_ON_PIN_WRITE(244);
    ERA_ON_PIN_WRITE(245);
    ERA_ON_PIN_WRITE(246);
    ERA_ON_PIN_WRITE(247);
    ERA_ON_PIN_WRITE(248);
    ERA_ON_PIN_WRITE(249);
    ERA_ON_PIN_WRITE(250);
    ERA_ON_PIN_WRITE(251);
    ERA_ON_PIN_WRITE(252);
    ERA_ON_PIN_WRITE(253);
    ERA_ON_PIN_WRITE(254);
    ERA_ON_PIN_WRITE(255);
#endif
#if defined(ERA_500_PINS)
    ERA_ON_PIN_WRITE(256);
    ERA_ON_PIN_WRITE(257);
    ERA_ON_PIN_WRITE(258);
    ERA_ON_PIN_WRITE(259);
    ERA_ON_PIN_WRITE(260);
    ERA_ON_PIN_WRITE(261);
    ERA_ON_PIN_WRITE(262);
    ERA_ON_PIN_WRITE(263);
    ERA_ON_PIN_WRITE(264);
    ERA_ON_PIN_WRITE(265);
    ERA_ON_PIN_WRITE(266);
    ERA_ON_PIN_WRITE(267);
    ERA_ON_PIN_WRITE(268);
    ERA_ON_PIN_WRITE(269);
    ERA_ON_PIN_WRITE(270);
    ERA_ON_PIN_WRITE(271);
    ERA_ON_PIN_WRITE(272);
    ERA_ON_PIN_WRITE(273);
    ERA_ON_PIN_WRITE(274);
    ERA_ON_PIN_WRITE(275);
    ERA_ON_PIN_WRITE(276);
    ERA_ON_PIN_WRITE(277);
    ERA_ON_PIN_WRITE(278);
    ERA_ON_PIN_WRITE(279);
    ERA_ON_PIN_WRITE(280);
    ERA_ON_PIN_WRITE(281);
    ERA_ON_PIN_WRITE(282);
    ERA_ON_PIN_WRITE(283);
    ERA_ON_PIN_WRITE(284);
    ERA_ON_PIN_WRITE(285);
    ERA_ON_PIN_WRITE(286);
    ERA_ON_PIN_WRITE(287);
    ERA_ON_PIN_WRITE(288);
    ERA_ON_PIN_WRITE(289);
    ERA_ON_PIN_WRITE(290);
    ERA_ON_PIN_WRITE(291);
    ERA_ON_PIN_WRITE(292);
    ERA_ON_PIN_WRITE(293);
    ERA_ON_PIN_WRITE(294);
    ERA_ON_PIN_WRITE(295);
    ERA_ON_PIN_WRITE(296);
    ERA_ON_PIN_WRITE(297);
    ERA_ON_PIN_WRITE(298);
    ERA_ON_PIN_WRITE(299);
    ERA_ON_PIN_WRITE(300);
    ERA_ON_PIN_WRITE(301);
    ERA_ON_PIN_WRITE(302);
    ERA_ON_PIN_WRITE(303);
    ERA_ON_PIN_WRITE(304);
    ERA_ON_PIN_WRITE(305);
    ERA_ON_PIN_WRITE(306);
    ERA_ON_PIN_WRITE(307);
    ERA_ON_PIN_WRITE(308);
    ERA_ON_PIN_WRITE(309);
    ERA_ON_PIN_WRITE(310);
    ERA_ON_PIN_WRITE(311);
    ERA_ON_PIN_WRITE(312);
    ERA_ON_PIN_WRITE(313);
    ERA_ON_PIN_WRITE(314);
    ERA_ON_PIN_WRITE(315);
    ERA_ON_PIN_WRITE(316);
    ERA_ON_PIN_WRITE(317);
    ERA_ON_PIN_WRITE(318);
    ERA_ON_PIN_WRITE(319);
    ERA_ON_PIN_WRITE(320);
    ERA_ON_PIN_WRITE(321);
    ERA_ON_PIN_WRITE(322);
    ERA_ON_PIN_WRITE(323);
    ERA_ON_PIN_WRITE(324);
    ERA_ON_PIN_WRITE(325);
    ERA_ON_PIN_WRITE(326);
    ERA_ON_PIN_WRITE(327);
    ERA_ON_PIN_WRITE(328);
    ERA_ON_PIN_WRITE(329);
    ERA_ON_PIN_WRITE(330);
    ERA_ON_PIN_WRITE(331);
    ERA_ON_PIN_WRITE(332);
    ERA_ON_PIN_WRITE(333);
    ERA_ON_PIN_WRITE(334);
    ERA_ON_PIN_WRITE(335);
    ERA_ON_PIN_WRITE(336);
    ERA_ON_PIN_WRITE(337);
    ERA_ON_PIN_WRITE(338);
    ERA_ON_PIN_WRITE(339);
    ERA_ON_PIN_WRITE(340);
    ERA_ON_PIN_WRITE(341);
    ERA_ON_PIN_WRITE(342);
    ERA_ON_PIN_WRITE(343);
    ERA_ON_PIN_WRITE(344);
    ERA_ON_PIN_WRITE(345);
    ERA_ON_PIN_WRITE(346);
    ERA_ON_PIN_WRITE(347);
    ERA_ON_PIN_WRITE(348);
    ERA_ON_PIN_WRITE(349);
    ERA_ON_PIN_WRITE(350);
    ERA_ON_PIN_WRITE(351);
    ERA_ON_PIN_WRITE(352);
    ERA_ON_PIN_WRITE(353);
    ERA_ON_PIN_WRITE(354);
    ERA_ON_PIN_WRITE(355);
    ERA_ON_PIN_WRITE(356);
    ERA_ON_PIN_WRITE(357);
    ERA_ON_PIN_WRITE(358);
    ERA_ON_PIN_WRITE(359);
    ERA_ON_PIN_WRITE(360);
    ERA_ON_PIN_WRITE(361);
    ERA_ON_PIN_WRITE(362);
    ERA_ON_PIN_WRITE(363);
    ERA_ON_PIN_WRITE(364);
    ERA_ON_PIN_WRITE(365);
    ERA_ON_PIN_WRITE(366);
    ERA_ON_PIN_WRITE(367);
    ERA_ON_PIN_WRITE(368);
    ERA_ON_PIN_WRITE(369);
    ERA_ON_PIN_WRITE(370);
    ERA_ON_PIN_WRITE(371);
    ERA_ON_PIN_WRITE(372);
    ERA_ON_PIN_WRITE(373);
    ERA_ON_PIN_WRITE(374);
    ERA_ON_PIN_WRITE(375);
    ERA_ON_PIN_WRITE(376);
    ERA_ON_PIN_WRITE(377);
    ERA_ON_PIN_WRITE(378);
    ERA_ON_PIN_WRITE(379);
    ERA_ON_PIN_WRITE(380);
    ERA_ON_PIN_WRITE(381);
    ERA_ON_PIN_WRITE(382);
    ERA_ON_PIN_WRITE(383);
    ERA_ON_PIN_WRITE(384);
    ERA_ON_PIN_WRITE(385);
    ERA_ON_PIN_WRITE(386);
    ERA_ON_PIN_WRITE(387);
    ERA_ON_PIN_WRITE(388);
    ERA_ON_PIN_WRITE(389);
    ERA_ON_PIN_WRITE(390);
    ERA_ON_PIN_WRITE(391);
    ERA_ON_PIN_WRITE(392);
    ERA_ON_PIN_WRITE(393);
    ERA_ON_PIN_WRITE(394);
    ERA_ON_PIN_WRITE(395);
    ERA_ON_PIN_WRITE(396);
    ERA_ON_PIN_WRITE(397);
    ERA_ON_PIN_WRITE(398);
    ERA_ON_PIN_WRITE(399);
    ERA_ON_PIN_WRITE(400);
    ERA_ON_PIN_WRITE(401);
    ERA_ON_PIN_WRITE(402);
    ERA_ON_PIN_WRITE(403);
    ERA_ON_PIN_WRITE(404);
    ERA_ON_PIN_WRITE(405);
    ERA_ON_PIN_WRITE(406);
    ERA_ON_PIN_WRITE(407);
    ERA_ON_PIN_WRITE(408);
    ERA_ON_PIN_WRITE(409);
    ERA_ON_PIN_WRITE(410);
    ERA_ON_PIN_WRITE(411);
    ERA_ON_PIN_WRITE(412);
    ERA_ON_PIN_WRITE(413);
    ERA_ON_PIN_WRITE(414);
    ERA_ON_PIN_WRITE(415);
    ERA_ON_PIN_WRITE(416);
    ERA_ON_PIN_WRITE(417);
    ERA_ON_PIN_WRITE(418);
    ERA_ON_PIN_WRITE(419);
    ERA_ON_PIN_WRITE(420);
    ERA_ON_PIN_WRITE(421);
    ERA_ON_PIN_WRITE(422);
    ERA_ON_PIN_WRITE(423);
    ERA_ON_PIN_WRITE(424);
    ERA_ON_PIN_WRITE(425);
    ERA_ON_PIN_WRITE(426);
    ERA_ON_PIN_WRITE(427);
    ERA_ON_PIN_WRITE(428);
    ERA_ON_PIN_WRITE(429);
    ERA_ON_PIN_WRITE(430);
    ERA_ON_PIN_WRITE(431);
    ERA_ON_PIN_WRITE(432);
    ERA_ON_PIN_WRITE(433);
    ERA_ON_PIN_WRITE(434);
    ERA_ON_PIN_WRITE(435);
    ERA_ON_PIN_WRITE(436);
    ERA_ON_PIN_WRITE(437);
    ERA_ON_PIN_WRITE(438);
    ERA_ON_PIN_WRITE(439);
    ERA_ON_PIN_WRITE(440);
    ERA_ON_PIN_WRITE(441);
    ERA_ON_PIN_WRITE(442);
    ERA_ON_PIN_WRITE(443);
    ERA_ON_PIN_WRITE(444);
    ERA_ON_PIN_WRITE(445);
    ERA_ON_PIN_WRITE(446);
    ERA_ON_PIN_WRITE(447);
    ERA_ON_PIN_WRITE(448);
    ERA_ON_PIN_WRITE(449);
    ERA_ON_PIN_WRITE(450);
    ERA_ON_PIN_WRITE(451);
    ERA_ON_PIN_WRITE(452);
    ERA_ON_PIN_WRITE(453);
    ERA_ON_PIN_WRITE(454);
    ERA_ON_PIN_WRITE(455);
    ERA_ON_PIN_WRITE(456);
    ERA_ON_PIN_WRITE(457);
    ERA_ON_PIN_WRITE(458);
    ERA_ON_PIN_WRITE(459);
    ERA_ON_PIN_WRITE(460);
    ERA_ON_PIN_WRITE(461);
    ERA_ON_PIN_WRITE(462);
    ERA_ON_PIN_WRITE(463);
    ERA_ON_PIN_WRITE(464);
    ERA_ON_PIN_WRITE(465);
    ERA_ON_PIN_WRITE(466);
    ERA_ON_PIN_WRITE(467);
    ERA_ON_PIN_WRITE(468);
    ERA_ON_PIN_WRITE(469);
    ERA_ON_PIN_WRITE(470);
    ERA_ON_PIN_WRITE(471);
    ERA_ON_PIN_WRITE(472);
    ERA_ON_PIN_WRITE(473);
    ERA_ON_PIN_WRITE(474);
    ERA_ON_PIN_WRITE(475);
    ERA_ON_PIN_WRITE(476);
    ERA_ON_PIN_WRITE(477);
    ERA_ON_PIN_WRITE(478);
    ERA_ON_PIN_WRITE(479);
    ERA_ON_PIN_WRITE(480);
    ERA_ON_PIN_WRITE(481);
    ERA_ON_PIN_WRITE(482);
    ERA_ON_PIN_WRITE(483);
    ERA_ON_PIN_WRITE(484);
    ERA_ON_PIN_WRITE(485);
    ERA_ON_PIN_WRITE(486);
    ERA_ON_PIN_WRITE(487);
    ERA_ON_PIN_WRITE(488);
    ERA_ON_PIN_WRITE(489);
    ERA_ON_PIN_WRITE(490);
    ERA_ON_PIN_WRITE(491);
    ERA_ON_PIN_WRITE(492);
    ERA_ON_PIN_WRITE(493);
    ERA_ON_PIN_WRITE(494);
    ERA_ON_PIN_WRITE(495);
    ERA_ON_PIN_WRITE(496);
    ERA_ON_PIN_WRITE(497);
    ERA_ON_PIN_WRITE(498);
    ERA_ON_PIN_WRITE(499);
#endif

static const ERaWriteHandler_t ERaWriteHandlerVector[] ERA_PROGMEM = {
    ERaWidgetWrite0, ERaWidgetWrite1, ERaWidgetWrite2, ERaWidgetWrite3, ERaWidgetWrite4,
    ERaWidgetWrite5, ERaWidgetWrite6, ERaWidgetWrite7, ERaWidgetWrite8, ERaWidgetWrite9,
    ERaWidgetWrite10, ERaWidgetWrite11, ERaWidgetWrite12, ERaWidgetWrite13, ERaWidgetWrite14,
    ERaWidgetWrite15, ERaWidgetWrite16, ERaWidgetWrite17, ERaWidgetWrite18, ERaWidgetWrite19,
    ERaWidgetWrite20, ERaWidgetWrite21, ERaWidgetWrite22, ERaWidgetWrite23, ERaWidgetWrite24,
    ERaWidgetWrite25, ERaWidgetWrite26, ERaWidgetWrite27, ERaWidgetWrite28, ERaWidgetWrite29,
    ERaWidgetWrite30, ERaWidgetWrite31, ERaWidgetWrite32, ERaWidgetWrite33, ERaWidgetWrite34,
    ERaWidgetWrite35, ERaWidgetWrite36, ERaWidgetWrite37, ERaWidgetWrite38, ERaWidgetWrite39,
    ERaWidgetWrite40, ERaWidgetWrite41, ERaWidgetWrite42, ERaWidgetWrite43, ERaWidgetWrite44,
    ERaWidgetWrite45, ERaWidgetWrite46, ERaWidgetWrite47, ERaWidgetWrite48, ERaWidgetWrite49,
#if defined(ERA_100_PINS)
    ERaWidgetWrite50, ERaWidgetWrite51, ERaWidgetWrite52, ERaWidgetWrite53, ERaWidgetWrite54,
    ERaWidgetWrite55, ERaWidgetWrite56, ERaWidgetWrite57, ERaWidgetWrite58, ERaWidgetWrite59,
    ERaWidgetWrite60, ERaWidgetWrite61, ERaWidgetWrite62, ERaWidgetWrite63, ERaWidgetWrite64,
    ERaWidgetWrite65, ERaWidgetWrite66, ERaWidgetWrite67, ERaWidgetWrite68, ERaWidgetWrite69,
    ERaWidgetWrite70, ERaWidgetWrite71, ERaWidgetWrite72, ERaWidgetWrite73, ERaWidgetWrite74,
    ERaWidgetWrite75, ERaWidgetWrite76, ERaWidgetWrite77, ERaWidgetWrite78, ERaWidgetWrite79,
    ERaWidgetWrite80, ERaWidgetWrite81, ERaWidgetWrite82, ERaWidgetWrite83, ERaWidgetWrite84,
    ERaWidgetWrite85, ERaWidgetWrite86, ERaWidgetWrite87, ERaWidgetWrite88, ERaWidgetWrite89,
    ERaWidgetWrite90, ERaWidgetWrite91, ERaWidgetWrite92, ERaWidgetWrite93, ERaWidgetWrite94,
    ERaWidgetWrite95, ERaWidgetWrite96, ERaWidgetWrite97, ERaWidgetWrite98, ERaWidgetWrite99,
#endif
#if defined(ERA_255_PINS)
    ERaWidgetWrite100, ERaWidgetWrite101, ERaWidgetWrite102, ERaWidgetWrite103, ERaWidgetWrite104,
    ERaWidgetWrite105, ERaWidgetWrite106, ERaWidgetWrite107, ERaWidgetWrite108, ERaWidgetWrite109,
    ERaWidgetWrite110, ERaWidgetWrite111, ERaWidgetWrite112, ERaWidgetWrite113, ERaWidgetWrite114,
    ERaWidgetWrite115, ERaWidgetWrite116, ERaWidgetWrite117, ERaWidgetWrite118, ERaWidgetWrite119,
    ERaWidgetWrite120, ERaWidgetWrite121, ERaWidgetWrite122, ERaWidgetWrite123, ERaWidgetWrite124,
    ERaWidgetWrite125, ERaWidgetWrite126, ERaWidgetWrite127, ERaWidgetWrite128, ERaWidgetWrite129,
    ERaWidgetWrite130, ERaWidgetWrite131, ERaWidgetWrite132, ERaWidgetWrite133, ERaWidgetWrite134,
    ERaWidgetWrite135, ERaWidgetWrite136, ERaWidgetWrite137, ERaWidgetWrite138, ERaWidgetWrite139,
    ERaWidgetWrite140, ERaWidgetWrite141, ERaWidgetWrite142, ERaWidgetWrite143, ERaWidgetWrite144,
    ERaWidgetWrite145, ERaWidgetWrite146, ERaWidgetWrite147, ERaWidgetWrite148, ERaWidgetWrite149,
    ERaWidgetWrite150, ERaWidgetWrite151, ERaWidgetWrite152, ERaWidgetWrite153, ERaWidgetWrite154,
    ERaWidgetWrite155, ERaWidgetWrite156, ERaWidgetWrite157, ERaWidgetWrite158, ERaWidgetWrite159,
    ERaWidgetWrite160, ERaWidgetWrite161, ERaWidgetWrite162, ERaWidgetWrite163, ERaWidgetWrite164,
    ERaWidgetWrite165, ERaWidgetWrite166, ERaWidgetWrite167, ERaWidgetWrite168, ERaWidgetWrite169,
    ERaWidgetWrite170, ERaWidgetWrite171, ERaWidgetWrite172, ERaWidgetWrite173, ERaWidgetWrite174,
    ERaWidgetWrite175, ERaWidgetWrite176, ERaWidgetWrite177, ERaWidgetWrite178, ERaWidgetWrite179,
    ERaWidgetWrite180, ERaWidgetWrite181, ERaWidgetWrite182, ERaWidgetWrite183, ERaWidgetWrite184,
    ERaWidgetWrite185, ERaWidgetWrite186, ERaWidgetWrite187, ERaWidgetWrite188, ERaWidgetWrite189,
    ERaWidgetWrite190, ERaWidgetWrite191, ERaWidgetWrite192, ERaWidgetWrite193, ERaWidgetWrite194,
    ERaWidgetWrite195, ERaWidgetWrite196, ERaWidgetWrite197, ERaWidgetWrite198, ERaWidgetWrite199,
    ERaWidgetWrite200, ERaWidgetWrite201, ERaWidgetWrite202, ERaWidgetWrite203, ERaWidgetWrite204,
    ERaWidgetWrite205, ERaWidgetWrite206, ERaWidgetWrite207, ERaWidgetWrite208, ERaWidgetWrite209,
    ERaWidgetWrite210, ERaWidgetWrite211, ERaWidgetWrite212, ERaWidgetWrite213, ERaWidgetWrite214,
    ERaWidgetWrite215, ERaWidgetWrite216, ERaWidgetWrite217, ERaWidgetWrite218, ERaWidgetWrite219,
    ERaWidgetWrite220, ERaWidgetWrite221, ERaWidgetWrite222, ERaWidgetWrite223, ERaWidgetWrite224,
    ERaWidgetWrite225, ERaWidgetWrite226, ERaWidgetWrite227, ERaWidgetWrite228, ERaWidgetWrite229,
    ERaWidgetWrite230, ERaWidgetWrite231, ERaWidgetWrite232, ERaWidgetWrite233, ERaWidgetWrite234,
    ERaWidgetWrite235, ERaWidgetWrite236, ERaWidgetWrite237, ERaWidgetWrite238, ERaWidgetWrite239,
    ERaWidgetWrite240, ERaWidgetWrite241, ERaWidgetWrite242, ERaWidgetWrite243, ERaWidgetWrite244,
    ERaWidgetWrite245, ERaWidgetWrite246, ERaWidgetWrite247, ERaWidgetWrite248, ERaWidgetWrite249,
    ERaWidgetWrite250, ERaWidgetWrite251, ERaWidgetWrite252, ERaWidgetWrite253, ERaWidgetWrite254,
    ERaWidgetWrite255,
#endif
#if defined(ERA_500_PINS)
    ERaWidgetWrite256, ERaWidgetWrite257, ERaWidgetWrite258, ERaWidgetWrite259, ERaWidgetWrite260,
    ERaWidgetWrite261, ERaWidgetWrite262, ERaWidgetWrite263, ERaWidgetWrite264, ERaWidgetWrite265,
    ERaWidgetWrite266, ERaWidgetWrite267, ERaWidgetWrite268, ERaWidgetWrite269, ERaWidgetWrite270,
    ERaWidgetWrite271, ERaWidgetWrite272, ERaWidgetWrite273, ERaWidgetWrite274, ERaWidgetWrite275,
    ERaWidgetWrite276, ERaWidgetWrite277, ERaWidgetWrite278, ERaWidgetWrite279, ERaWidgetWrite280,
    ERaWidgetWrite281, ERaWidgetWrite282, ERaWidgetWrite283, ERaWidgetWrite284, ERaWidgetWrite285,
    ERaWidgetWrite286, ERaWidgetWrite287, ERaWidgetWrite288, ERaWidgetWrite289, ERaWidgetWrite290,
    ERaWidgetWrite291, ERaWidgetWrite292, ERaWidgetWrite293, ERaWidgetWrite294, ERaWidgetWrite295,
    ERaWidgetWrite296, ERaWidgetWrite297, ERaWidgetWrite298, ERaWidgetWrite299, ERaWidgetWrite300,
    ERaWidgetWrite301, ERaWidgetWrite302, ERaWidgetWrite303, ERaWidgetWrite304, ERaWidgetWrite305,
    ERaWidgetWrite306, ERaWidgetWrite307, ERaWidgetWrite308, ERaWidgetWrite309, ERaWidgetWrite310,
    ERaWidgetWrite311, ERaWidgetWrite312, ERaWidgetWrite313, ERaWidgetWrite314, ERaWidgetWrite315,
    ERaWidgetWrite316, ERaWidgetWrite317, ERaWidgetWrite318, ERaWidgetWrite319, ERaWidgetWrite320,
    ERaWidgetWrite321, ERaWidgetWrite322, ERaWidgetWrite323, ERaWidgetWrite324, ERaWidgetWrite325,
    ERaWidgetWrite326, ERaWidgetWrite327, ERaWidgetWrite328, ERaWidgetWrite329, ERaWidgetWrite330,
    ERaWidgetWrite331, ERaWidgetWrite332, ERaWidgetWrite333, ERaWidgetWrite334, ERaWidgetWrite335,
    ERaWidgetWrite336, ERaWidgetWrite337, ERaWidgetWrite338, ERaWidgetWrite339, ERaWidgetWrite340,
    ERaWidgetWrite341, ERaWidgetWrite342, ERaWidgetWrite343, ERaWidgetWrite344, ERaWidgetWrite345,
    ERaWidgetWrite346, ERaWidgetWrite347, ERaWidgetWrite348, ERaWidgetWrite349, ERaWidgetWrite350,
    ERaWidgetWrite351, ERaWidgetWrite352, ERaWidgetWrite353, ERaWidgetWrite354, ERaWidgetWrite355,
    ERaWidgetWrite356, ERaWidgetWrite357, ERaWidgetWrite358, ERaWidgetWrite359, ERaWidgetWrite360,
    ERaWidgetWrite361, ERaWidgetWrite362, ERaWidgetWrite363, ERaWidgetWrite364, ERaWidgetWrite365,
    ERaWidgetWrite366, ERaWidgetWrite367, ERaWidgetWrite368, ERaWidgetWrite369, ERaWidgetWrite370,
    ERaWidgetWrite371, ERaWidgetWrite372, ERaWidgetWrite373, ERaWidgetWrite374, ERaWidgetWrite375,
    ERaWidgetWrite376, ERaWidgetWrite377, ERaWidgetWrite378, ERaWidgetWrite379, ERaWidgetWrite380,
    ERaWidgetWrite381, ERaWidgetWrite382, ERaWidgetWrite383, ERaWidgetWrite384, ERaWidgetWrite385,
    ERaWidgetWrite386, ERaWidgetWrite387, ERaWidgetWrite388, ERaWidgetWrite389, ERaWidgetWrite390,
    ERaWidgetWrite391, ERaWidgetWrite392, ERaWidgetWrite393, ERaWidgetWrite394, ERaWidgetWrite395,
    ERaWidgetWrite396, ERaWidgetWrite397, ERaWidgetWrite398, ERaWidgetWrite399, ERaWidgetWrite400,
    ERaWidgetWrite401, ERaWidgetWrite402, ERaWidgetWrite403, ERaWidgetWrite404, ERaWidgetWrite405,
    ERaWidgetWrite406, ERaWidgetWrite407, ERaWidgetWrite408, ERaWidgetWrite409, ERaWidgetWrite410,
    ERaWidgetWrite411, ERaWidgetWrite412, ERaWidgetWrite413, ERaWidgetWrite414, ERaWidgetWrite415,
    ERaWidgetWrite416, ERaWidgetWrite417, ERaWidgetWrite418, ERaWidgetWrite419, ERaWidgetWrite420,
    ERaWidgetWrite421, ERaWidgetWrite422, ERaWidgetWrite423, ERaWidgetWrite424, ERaWidgetWrite425,
    ERaWidgetWrite426, ERaWidgetWrite427, ERaWidgetWrite428, ERaWidgetWrite429, ERaWidgetWrite430,
    ERaWidgetWrite431, ERaWidgetWrite432, ERaWidgetWrite433, ERaWidgetWrite434, ERaWidgetWrite435,
    ERaWidgetWrite436, ERaWidgetWrite437, ERaWidgetWrite438, ERaWidgetWrite439, ERaWidgetWrite440,
    ERaWidgetWrite441, ERaWidgetWrite442, ERaWidgetWrite443, ERaWidgetWrite444, ERaWidgetWrite445,
    ERaWidgetWrite446, ERaWidgetWrite447, ERaWidgetWrite448, ERaWidgetWrite449, ERaWidgetWrite450,
    ERaWidgetWrite451, ERaWidgetWrite452, ERaWidgetWrite453, ERaWidgetWrite454, ERaWidgetWrite455,
    ERaWidgetWrite456, ERaWidgetWrite457, ERaWidgetWrite458, ERaWidgetWrite459, ERaWidgetWrite460,
    ERaWidgetWrite461, ERaWidgetWrite462, ERaWidgetWrite463, ERaWidgetWrite464, ERaWidgetWrite465,
    ERaWidgetWrite466, ERaWidgetWrite467, ERaWidgetWrite468, ERaWidgetWrite469, ERaWidgetWrite470,
    ERaWidgetWrite471, ERaWidgetWrite472, ERaWidgetWrite473, ERaWidgetWrite474, ERaWidgetWrite475,
    ERaWidgetWrite476, ERaWidgetWrite477, ERaWidgetWrite478, ERaWidgetWrite479, ERaWidgetWrite480,
    ERaWidgetWrite481, ERaWidgetWrite482, ERaWidgetWrite483, ERaWidgetWrite484, ERaWidgetWrite485,
    ERaWidgetWrite486, ERaWidgetWrite487, ERaWidgetWrite488, ERaWidgetWrite489, ERaWidgetWrite490,
    ERaWidgetWrite491, ERaWidgetWrite492, ERaWidgetWrite493, ERaWidgetWrite494, ERaWidgetWrite495,
    ERaWidgetWrite496, ERaWidgetWrite497, ERaWidgetWrite498, ERaWidgetWrite499,
#endif
};

static const ERaPinReadHandler_t ERaPinReadHandlerVector[] ERA_PROGMEM = {
    ERaWidgetPinRead0, ERaWidgetPinRead1, ERaWidgetPinRead2, ERaWidgetPinRead3, ERaWidgetPinRead4,
    ERaWidgetPinRead5, ERaWidgetPinRead6, ERaWidgetPinRead7, ERaWidgetPinRead8, ERaWidgetPinRead9,
    ERaWidgetPinRead10, ERaWidgetPinRead11, ERaWidgetPinRead12, ERaWidgetPinRead13, ERaWidgetPinRead14,
    ERaWidgetPinRead15, ERaWidgetPinRead16, ERaWidgetPinRead17, ERaWidgetPinRead18, ERaWidgetPinRead19,
    ERaWidgetPinRead20, ERaWidgetPinRead21, ERaWidgetPinRead22, ERaWidgetPinRead23, ERaWidgetPinRead24,
    ERaWidgetPinRead25, ERaWidgetPinRead26, ERaWidgetPinRead27, ERaWidgetPinRead28, ERaWidgetPinRead29,
    ERaWidgetPinRead30, ERaWidgetPinRead31, ERaWidgetPinRead32, ERaWidgetPinRead33, ERaWidgetPinRead34,
    ERaWidgetPinRead35, ERaWidgetPinRead36, ERaWidgetPinRead37, ERaWidgetPinRead38, ERaWidgetPinRead39,
    ERaWidgetPinRead40, ERaWidgetPinRead41, ERaWidgetPinRead42, ERaWidgetPinRead43, ERaWidgetPinRead44,
    ERaWidgetPinRead45, ERaWidgetPinRead46, ERaWidgetPinRead47, ERaWidgetPinRead48, ERaWidgetPinRead49,
#if defined(ERA_100_PINS)
    ERaWidgetPinRead50, ERaWidgetPinRead51, ERaWidgetPinRead52, ERaWidgetPinRead53, ERaWidgetPinRead54,
    ERaWidgetPinRead55, ERaWidgetPinRead56, ERaWidgetPinRead57, ERaWidgetPinRead58, ERaWidgetPinRead59,
    ERaWidgetPinRead60, ERaWidgetPinRead61, ERaWidgetPinRead62, ERaWidgetPinRead63, ERaWidgetPinRead64,
    ERaWidgetPinRead65, ERaWidgetPinRead66, ERaWidgetPinRead67, ERaWidgetPinRead68, ERaWidgetPinRead69,
    ERaWidgetPinRead70, ERaWidgetPinRead71, ERaWidgetPinRead72, ERaWidgetPinRead73, ERaWidgetPinRead74,
    ERaWidgetPinRead75, ERaWidgetPinRead76, ERaWidgetPinRead77, ERaWidgetPinRead78, ERaWidgetPinRead79,
    ERaWidgetPinRead80, ERaWidgetPinRead81, ERaWidgetPinRead82, ERaWidgetPinRead83, ERaWidgetPinRead84,
    ERaWidgetPinRead85, ERaWidgetPinRead86, ERaWidgetPinRead87, ERaWidgetPinRead88, ERaWidgetPinRead89,
    ERaWidgetPinRead90, ERaWidgetPinRead91, ERaWidgetPinRead92, ERaWidgetPinRead93, ERaWidgetPinRead94,
    ERaWidgetPinRead95, ERaWidgetPinRead96, ERaWidgetPinRead97, ERaWidgetPinRead98, ERaWidgetPinRead99,
#endif
#if defined(ERA_255_PINS)
    ERaWidgetPinRead100, ERaWidgetPinRead101, ERaWidgetPinRead102, ERaWidgetPinRead103, ERaWidgetPinRead104,
    ERaWidgetPinRead105, ERaWidgetPinRead106, ERaWidgetPinRead107, ERaWidgetPinRead108, ERaWidgetPinRead109,
    ERaWidgetPinRead110, ERaWidgetPinRead111, ERaWidgetPinRead112, ERaWidgetPinRead113, ERaWidgetPinRead114,
    ERaWidgetPinRead115, ERaWidgetPinRead116, ERaWidgetPinRead117, ERaWidgetPinRead118, ERaWidgetPinRead119,
    ERaWidgetPinRead120, ERaWidgetPinRead121, ERaWidgetPinRead122, ERaWidgetPinRead123, ERaWidgetPinRead124,
    ERaWidgetPinRead125, ERaWidgetPinRead126, ERaWidgetPinRead127, ERaWidgetPinRead128, ERaWidgetPinRead129,
    ERaWidgetPinRead130, ERaWidgetPinRead131, ERaWidgetPinRead132, ERaWidgetPinRead133, ERaWidgetPinRead134,
    ERaWidgetPinRead135, ERaWidgetPinRead136, ERaWidgetPinRead137, ERaWidgetPinRead138, ERaWidgetPinRead139,
    ERaWidgetPinRead140, ERaWidgetPinRead141, ERaWidgetPinRead142, ERaWidgetPinRead143, ERaWidgetPinRead144,
    ERaWidgetPinRead145, ERaWidgetPinRead146, ERaWidgetPinRead147, ERaWidgetPinRead148, ERaWidgetPinRead149,
    ERaWidgetPinRead150, ERaWidgetPinRead151, ERaWidgetPinRead152, ERaWidgetPinRead153, ERaWidgetPinRead154,
    ERaWidgetPinRead155, ERaWidgetPinRead156, ERaWidgetPinRead157, ERaWidgetPinRead158, ERaWidgetPinRead159,
    ERaWidgetPinRead160, ERaWidgetPinRead161, ERaWidgetPinRead162, ERaWidgetPinRead163, ERaWidgetPinRead164,
    ERaWidgetPinRead165, ERaWidgetPinRead166, ERaWidgetPinRead167, ERaWidgetPinRead168, ERaWidgetPinRead169,
    ERaWidgetPinRead170, ERaWidgetPinRead171, ERaWidgetPinRead172, ERaWidgetPinRead173, ERaWidgetPinRead174,
    ERaWidgetPinRead175, ERaWidgetPinRead176, ERaWidgetPinRead177, ERaWidgetPinRead178, ERaWidgetPinRead179,
    ERaWidgetPinRead180, ERaWidgetPinRead181, ERaWidgetPinRead182, ERaWidgetPinRead183, ERaWidgetPinRead184,
    ERaWidgetPinRead185, ERaWidgetPinRead186, ERaWidgetPinRead187, ERaWidgetPinRead188, ERaWidgetPinRead189,
    ERaWidgetPinRead190, ERaWidgetPinRead191, ERaWidgetPinRead192, ERaWidgetPinRead193, ERaWidgetPinRead194,
    ERaWidgetPinRead195, ERaWidgetPinRead196, ERaWidgetPinRead197, ERaWidgetPinRead198, ERaWidgetPinRead199,
    ERaWidgetPinRead200, ERaWidgetPinRead201, ERaWidgetPinRead202, ERaWidgetPinRead203, ERaWidgetPinRead204,
    ERaWidgetPinRead205, ERaWidgetPinRead206, ERaWidgetPinRead207, ERaWidgetPinRead208, ERaWidgetPinRead209,
    ERaWidgetPinRead210, ERaWidgetPinRead211, ERaWidgetPinRead212, ERaWidgetPinRead213, ERaWidgetPinRead214,
    ERaWidgetPinRead215, ERaWidgetPinRead216, ERaWidgetPinRead217, ERaWidgetPinRead218, ERaWidgetPinRead219,
    ERaWidgetPinRead220, ERaWidgetPinRead221, ERaWidgetPinRead222, ERaWidgetPinRead223, ERaWidgetPinRead224,
    ERaWidgetPinRead225, ERaWidgetPinRead226, ERaWidgetPinRead227, ERaWidgetPinRead228, ERaWidgetPinRead229,
    ERaWidgetPinRead230, ERaWidgetPinRead231, ERaWidgetPinRead232, ERaWidgetPinRead233, ERaWidgetPinRead234,
    ERaWidgetPinRead235, ERaWidgetPinRead236, ERaWidgetPinRead237, ERaWidgetPinRead238, ERaWidgetPinRead239,
    ERaWidgetPinRead240, ERaWidgetPinRead241, ERaWidgetPinRead242, ERaWidgetPinRead243, ERaWidgetPinRead244,
    ERaWidgetPinRead245, ERaWidgetPinRead246, ERaWidgetPinRead247, ERaWidgetPinRead248, ERaWidgetPinRead249,
    ERaWidgetPinRead250, ERaWidgetPinRead251, ERaWidgetPinRead252, ERaWidgetPinRead253, ERaWidgetPinRead254,
    ERaWidgetPinRead255,
#endif
#if defined(ERA_500_PINS)
    ERaWidgetPinRead256, ERaWidgetPinRead257, ERaWidgetPinRead258, ERaWidgetPinRead259, ERaWidgetPinRead260,
    ERaWidgetPinRead261, ERaWidgetPinRead262, ERaWidgetPinRead263, ERaWidgetPinRead264, ERaWidgetPinRead265,
    ERaWidgetPinRead266, ERaWidgetPinRead267, ERaWidgetPinRead268, ERaWidgetPinRead269, ERaWidgetPinRead270,
    ERaWidgetPinRead271, ERaWidgetPinRead272, ERaWidgetPinRead273, ERaWidgetPinRead274, ERaWidgetPinRead275,
    ERaWidgetPinRead276, ERaWidgetPinRead277, ERaWidgetPinRead278, ERaWidgetPinRead279, ERaWidgetPinRead280,
    ERaWidgetPinRead281, ERaWidgetPinRead282, ERaWidgetPinRead283, ERaWidgetPinRead284, ERaWidgetPinRead285,
    ERaWidgetPinRead286, ERaWidgetPinRead287, ERaWidgetPinRead288, ERaWidgetPinRead289, ERaWidgetPinRead290,
    ERaWidgetPinRead291, ERaWidgetPinRead292, ERaWidgetPinRead293, ERaWidgetPinRead294, ERaWidgetPinRead295,
    ERaWidgetPinRead296, ERaWidgetPinRead297, ERaWidgetPinRead298, ERaWidgetPinRead299, ERaWidgetPinRead300,
    ERaWidgetPinRead301, ERaWidgetPinRead302, ERaWidgetPinRead303, ERaWidgetPinRead304, ERaWidgetPinRead305,
    ERaWidgetPinRead306, ERaWidgetPinRead307, ERaWidgetPinRead308, ERaWidgetPinRead309, ERaWidgetPinRead310,
    ERaWidgetPinRead311, ERaWidgetPinRead312, ERaWidgetPinRead313, ERaWidgetPinRead314, ERaWidgetPinRead315,
    ERaWidgetPinRead316, ERaWidgetPinRead317, ERaWidgetPinRead318, ERaWidgetPinRead319, ERaWidgetPinRead320,
    ERaWidgetPinRead321, ERaWidgetPinRead322, ERaWidgetPinRead323, ERaWidgetPinRead324, ERaWidgetPinRead325,
    ERaWidgetPinRead326, ERaWidgetPinRead327, ERaWidgetPinRead328, ERaWidgetPinRead329, ERaWidgetPinRead330,
    ERaWidgetPinRead331, ERaWidgetPinRead332, ERaWidgetPinRead333, ERaWidgetPinRead334, ERaWidgetPinRead335,
    ERaWidgetPinRead336, ERaWidgetPinRead337, ERaWidgetPinRead338, ERaWidgetPinRead339, ERaWidgetPinRead340,
    ERaWidgetPinRead341, ERaWidgetPinRead342, ERaWidgetPinRead343, ERaWidgetPinRead344, ERaWidgetPinRead345,
    ERaWidgetPinRead346, ERaWidgetPinRead347, ERaWidgetPinRead348, ERaWidgetPinRead349, ERaWidgetPinRead350,
    ERaWidgetPinRead351, ERaWidgetPinRead352, ERaWidgetPinRead353, ERaWidgetPinRead354, ERaWidgetPinRead355,
    ERaWidgetPinRead356, ERaWidgetPinRead357, ERaWidgetPinRead358, ERaWidgetPinRead359, ERaWidgetPinRead360,
    ERaWidgetPinRead361, ERaWidgetPinRead362, ERaWidgetPinRead363, ERaWidgetPinRead364, ERaWidgetPinRead365,
    ERaWidgetPinRead366, ERaWidgetPinRead367, ERaWidgetPinRead368, ERaWidgetPinRead369, ERaWidgetPinRead370,
    ERaWidgetPinRead371, ERaWidgetPinRead372, ERaWidgetPinRead373, ERaWidgetPinRead374, ERaWidgetPinRead375,
    ERaWidgetPinRead376, ERaWidgetPinRead377, ERaWidgetPinRead378, ERaWidgetPinRead379, ERaWidgetPinRead380,
    ERaWidgetPinRead381, ERaWidgetPinRead382, ERaWidgetPinRead383, ERaWidgetPinRead384, ERaWidgetPinRead385,
    ERaWidgetPinRead386, ERaWidgetPinRead387, ERaWidgetPinRead388, ERaWidgetPinRead389, ERaWidgetPinRead390,
    ERaWidgetPinRead391, ERaWidgetPinRead392, ERaWidgetPinRead393, ERaWidgetPinRead394, ERaWidgetPinRead395,
    ERaWidgetPinRead396, ERaWidgetPinRead397, ERaWidgetPinRead398, ERaWidgetPinRead399, ERaWidgetPinRead400,
    ERaWidgetPinRead401, ERaWidgetPinRead402, ERaWidgetPinRead403, ERaWidgetPinRead404, ERaWidgetPinRead405,
    ERaWidgetPinRead406, ERaWidgetPinRead407, ERaWidgetPinRead408, ERaWidgetPinRead409, ERaWidgetPinRead410,
    ERaWidgetPinRead411, ERaWidgetPinRead412, ERaWidgetPinRead413, ERaWidgetPinRead414, ERaWidgetPinRead415,
    ERaWidgetPinRead416, ERaWidgetPinRead417, ERaWidgetPinRead418, ERaWidgetPinRead419, ERaWidgetPinRead420,
    ERaWidgetPinRead421, ERaWidgetPinRead422, ERaWidgetPinRead423, ERaWidgetPinRead424, ERaWidgetPinRead425,
    ERaWidgetPinRead426, ERaWidgetPinRead427, ERaWidgetPinRead428, ERaWidgetPinRead429, ERaWidgetPinRead430,
    ERaWidgetPinRead431, ERaWidgetPinRead432, ERaWidgetPinRead433, ERaWidgetPinRead434, ERaWidgetPinRead435,
    ERaWidgetPinRead436, ERaWidgetPinRead437, ERaWidgetPinRead438, ERaWidgetPinRead439, ERaWidgetPinRead440,
    ERaWidgetPinRead441, ERaWidgetPinRead442, ERaWidgetPinRead443, ERaWidgetPinRead444, ERaWidgetPinRead445,
    ERaWidgetPinRead446, ERaWidgetPinRead447, ERaWidgetPinRead448, ERaWidgetPinRead449, ERaWidgetPinRead450,
    ERaWidgetPinRead451, ERaWidgetPinRead452, ERaWidgetPinRead453, ERaWidgetPinRead454, ERaWidgetPinRead455,
    ERaWidgetPinRead456, ERaWidgetPinRead457, ERaWidgetPinRead458, ERaWidgetPinRead459, ERaWidgetPinRead460,
    ERaWidgetPinRead461, ERaWidgetPinRead462, ERaWidgetPinRead463, ERaWidgetPinRead464, ERaWidgetPinRead465,
    ERaWidgetPinRead466, ERaWidgetPinRead467, ERaWidgetPinRead468, ERaWidgetPinRead469, ERaWidgetPinRead470,
    ERaWidgetPinRead471, ERaWidgetPinRead472, ERaWidgetPinRead473, ERaWidgetPinRead474, ERaWidgetPinRead475,
    ERaWidgetPinRead476, ERaWidgetPinRead477, ERaWidgetPinRead478, ERaWidgetPinRead479, ERaWidgetPinRead480,
    ERaWidgetPinRead481, ERaWidgetPinRead482, ERaWidgetPinRead483, ERaWidgetPinRead484, ERaWidgetPinRead485,
    ERaWidgetPinRead486, ERaWidgetPinRead487, ERaWidgetPinRead488, ERaWidgetPinRead489, ERaWidgetPinRead490,
    ERaWidgetPinRead491, ERaWidgetPinRead492, ERaWidgetPinRead493, ERaWidgetPinRead494, ERaWidgetPinRead495,
    ERaWidgetPinRead496, ERaWidgetPinRead497, ERaWidgetPinRead498, ERaWidgetPinRead499,
#endif
};

static const ERaPinWriteHandler_t ERaPinWriteHandlerVector[] ERA_PROGMEM = {
    ERaWidgetPinWrite0, ERaWidgetPinWrite1, ERaWidgetPinWrite2, ERaWidgetPinWrite3, ERaWidgetPinWrite4,
    ERaWidgetPinWrite5, ERaWidgetPinWrite6, ERaWidgetPinWrite7, ERaWidgetPinWrite8, ERaWidgetPinWrite9,
    ERaWidgetPinWrite10, ERaWidgetPinWrite11, ERaWidgetPinWrite12, ERaWidgetPinWrite13, ERaWidgetPinWrite14,
    ERaWidgetPinWrite15, ERaWidgetPinWrite16, ERaWidgetPinWrite17, ERaWidgetPinWrite18, ERaWidgetPinWrite19,
    ERaWidgetPinWrite20, ERaWidgetPinWrite21, ERaWidgetPinWrite22, ERaWidgetPinWrite23, ERaWidgetPinWrite24,
    ERaWidgetPinWrite25, ERaWidgetPinWrite26, ERaWidgetPinWrite27, ERaWidgetPinWrite28, ERaWidgetPinWrite29,
    ERaWidgetPinWrite30, ERaWidgetPinWrite31, ERaWidgetPinWrite32, ERaWidgetPinWrite33, ERaWidgetPinWrite34,
    ERaWidgetPinWrite35, ERaWidgetPinWrite36, ERaWidgetPinWrite37, ERaWidgetPinWrite38, ERaWidgetPinWrite39,
    ERaWidgetPinWrite40, ERaWidgetPinWrite41, ERaWidgetPinWrite42, ERaWidgetPinWrite43, ERaWidgetPinWrite44,
    ERaWidgetPinWrite45, ERaWidgetPinWrite46, ERaWidgetPinWrite47, ERaWidgetPinWrite48, ERaWidgetPinWrite49,
#if defined(ERA_100_PINS)
    ERaWidgetPinWrite50, ERaWidgetPinWrite51, ERaWidgetPinWrite52, ERaWidgetPinWrite53, ERaWidgetPinWrite54,
    ERaWidgetPinWrite55, ERaWidgetPinWrite56, ERaWidgetPinWrite57, ERaWidgetPinWrite58, ERaWidgetPinWrite59,
    ERaWidgetPinWrite60, ERaWidgetPinWrite61, ERaWidgetPinWrite62, ERaWidgetPinWrite63, ERaWidgetPinWrite64,
    ERaWidgetPinWrite65, ERaWidgetPinWrite66, ERaWidgetPinWrite67, ERaWidgetPinWrite68, ERaWidgetPinWrite69,
    ERaWidgetPinWrite70, ERaWidgetPinWrite71, ERaWidgetPinWrite72, ERaWidgetPinWrite73, ERaWidgetPinWrite74,
    ERaWidgetPinWrite75, ERaWidgetPinWrite76, ERaWidgetPinWrite77, ERaWidgetPinWrite78, ERaWidgetPinWrite79,
    ERaWidgetPinWrite80, ERaWidgetPinWrite81, ERaWidgetPinWrite82, ERaWidgetPinWrite83, ERaWidgetPinWrite84,
    ERaWidgetPinWrite85, ERaWidgetPinWrite86, ERaWidgetPinWrite87, ERaWidgetPinWrite88, ERaWidgetPinWrite89,
    ERaWidgetPinWrite90, ERaWidgetPinWrite91, ERaWidgetPinWrite92, ERaWidgetPinWrite93, ERaWidgetPinWrite94,
    ERaWidgetPinWrite95, ERaWidgetPinWrite96, ERaWidgetPinWrite97, ERaWidgetPinWrite98, ERaWidgetPinWrite99,
#endif
#if defined(ERA_255_PINS)
    ERaWidgetPinWrite100, ERaWidgetPinWrite101, ERaWidgetPinWrite102, ERaWidgetPinWrite103, ERaWidgetPinWrite104,
    ERaWidgetPinWrite105, ERaWidgetPinWrite106, ERaWidgetPinWrite107, ERaWidgetPinWrite108, ERaWidgetPinWrite109,
    ERaWidgetPinWrite110, ERaWidgetPinWrite111, ERaWidgetPinWrite112, ERaWidgetPinWrite113, ERaWidgetPinWrite114,
    ERaWidgetPinWrite115, ERaWidgetPinWrite116, ERaWidgetPinWrite117, ERaWidgetPinWrite118, ERaWidgetPinWrite119,
    ERaWidgetPinWrite120, ERaWidgetPinWrite121, ERaWidgetPinWrite122, ERaWidgetPinWrite123, ERaWidgetPinWrite124,
    ERaWidgetPinWrite125, ERaWidgetPinWrite126, ERaWidgetPinWrite127, ERaWidgetPinWrite128, ERaWidgetPinWrite129,
    ERaWidgetPinWrite130, ERaWidgetPinWrite131, ERaWidgetPinWrite132, ERaWidgetPinWrite133, ERaWidgetPinWrite134,
    ERaWidgetPinWrite135, ERaWidgetPinWrite136, ERaWidgetPinWrite137, ERaWidgetPinWrite138, ERaWidgetPinWrite139,
    ERaWidgetPinWrite140, ERaWidgetPinWrite141, ERaWidgetPinWrite142, ERaWidgetPinWrite143, ERaWidgetPinWrite144,
    ERaWidgetPinWrite145, ERaWidgetPinWrite146, ERaWidgetPinWrite147, ERaWidgetPinWrite148, ERaWidgetPinWrite149,
    ERaWidgetPinWrite150, ERaWidgetPinWrite151, ERaWidgetPinWrite152, ERaWidgetPinWrite153, ERaWidgetPinWrite154,
    ERaWidgetPinWrite155, ERaWidgetPinWrite156, ERaWidgetPinWrite157, ERaWidgetPinWrite158, ERaWidgetPinWrite159,
    ERaWidgetPinWrite160, ERaWidgetPinWrite161, ERaWidgetPinWrite162, ERaWidgetPinWrite163, ERaWidgetPinWrite164,
    ERaWidgetPinWrite165, ERaWidgetPinWrite166, ERaWidgetPinWrite167, ERaWidgetPinWrite168, ERaWidgetPinWrite169,
    ERaWidgetPinWrite170, ERaWidgetPinWrite171, ERaWidgetPinWrite172, ERaWidgetPinWrite173, ERaWidgetPinWrite174,
    ERaWidgetPinWrite175, ERaWidgetPinWrite176, ERaWidgetPinWrite177, ERaWidgetPinWrite178, ERaWidgetPinWrite179,
    ERaWidgetPinWrite180, ERaWidgetPinWrite181, ERaWidgetPinWrite182, ERaWidgetPinWrite183, ERaWidgetPinWrite184,
    ERaWidgetPinWrite185, ERaWidgetPinWrite186, ERaWidgetPinWrite187, ERaWidgetPinWrite188, ERaWidgetPinWrite189,
    ERaWidgetPinWrite190, ERaWidgetPinWrite191, ERaWidgetPinWrite192, ERaWidgetPinWrite193, ERaWidgetPinWrite194,
    ERaWidgetPinWrite195, ERaWidgetPinWrite196, ERaWidgetPinWrite197, ERaWidgetPinWrite198, ERaWidgetPinWrite199,
    ERaWidgetPinWrite200, ERaWidgetPinWrite201, ERaWidgetPinWrite202, ERaWidgetPinWrite203, ERaWidgetPinWrite204,
    ERaWidgetPinWrite205, ERaWidgetPinWrite206, ERaWidgetPinWrite207, ERaWidgetPinWrite208, ERaWidgetPinWrite209,
    ERaWidgetPinWrite210, ERaWidgetPinWrite211, ERaWidgetPinWrite212, ERaWidgetPinWrite213, ERaWidgetPinWrite214,
    ERaWidgetPinWrite215, ERaWidgetPinWrite216, ERaWidgetPinWrite217, ERaWidgetPinWrite218, ERaWidgetPinWrite219,
    ERaWidgetPinWrite220, ERaWidgetPinWrite221, ERaWidgetPinWrite222, ERaWidgetPinWrite223, ERaWidgetPinWrite224,
    ERaWidgetPinWrite225, ERaWidgetPinWrite226, ERaWidgetPinWrite227, ERaWidgetPinWrite228, ERaWidgetPinWrite229,
    ERaWidgetPinWrite230, ERaWidgetPinWrite231, ERaWidgetPinWrite232, ERaWidgetPinWrite233, ERaWidgetPinWrite234,
    ERaWidgetPinWrite235, ERaWidgetPinWrite236, ERaWidgetPinWrite237, ERaWidgetPinWrite238, ERaWidgetPinWrite239,
    ERaWidgetPinWrite240, ERaWidgetPinWrite241, ERaWidgetPinWrite242, ERaWidgetPinWrite243, ERaWidgetPinWrite244,
    ERaWidgetPinWrite245, ERaWidgetPinWrite246, ERaWidgetPinWrite247, ERaWidgetPinWrite248, ERaWidgetPinWrite249,
    ERaWidgetPinWrite250, ERaWidgetPinWrite251, ERaWidgetPinWrite252, ERaWidgetPinWrite253, ERaWidgetPinWrite254,
    ERaWidgetPinWrite255,
#endif
#if defined(ERA_500_PINS)
    ERaWidgetPinWrite256, ERaWidgetPinWrite257, ERaWidgetPinWrite258, ERaWidgetPinWrite259, ERaWidgetPinWrite260,
    ERaWidgetPinWrite261, ERaWidgetPinWrite262, ERaWidgetPinWrite263, ERaWidgetPinWrite264, ERaWidgetPinWrite265,
    ERaWidgetPinWrite266, ERaWidgetPinWrite267, ERaWidgetPinWrite268, ERaWidgetPinWrite269, ERaWidgetPinWrite270,
    ERaWidgetPinWrite271, ERaWidgetPinWrite272, ERaWidgetPinWrite273, ERaWidgetPinWrite274, ERaWidgetPinWrite275,
    ERaWidgetPinWrite276, ERaWidgetPinWrite277, ERaWidgetPinWrite278, ERaWidgetPinWrite279, ERaWidgetPinWrite280,
    ERaWidgetPinWrite281, ERaWidgetPinWrite282, ERaWidgetPinWrite283, ERaWidgetPinWrite284, ERaWidgetPinWrite285,
    ERaWidgetPinWrite286, ERaWidgetPinWrite287, ERaWidgetPinWrite288, ERaWidgetPinWrite289, ERaWidgetPinWrite290,
    ERaWidgetPinWrite291, ERaWidgetPinWrite292, ERaWidgetPinWrite293, ERaWidgetPinWrite294, ERaWidgetPinWrite295,
    ERaWidgetPinWrite296, ERaWidgetPinWrite297, ERaWidgetPinWrite298, ERaWidgetPinWrite299, ERaWidgetPinWrite300,
    ERaWidgetPinWrite301, ERaWidgetPinWrite302, ERaWidgetPinWrite303, ERaWidgetPinWrite304, ERaWidgetPinWrite305,
    ERaWidgetPinWrite306, ERaWidgetPinWrite307, ERaWidgetPinWrite308, ERaWidgetPinWrite309, ERaWidgetPinWrite310,
    ERaWidgetPinWrite311, ERaWidgetPinWrite312, ERaWidgetPinWrite313, ERaWidgetPinWrite314, ERaWidgetPinWrite315,
    ERaWidgetPinWrite316, ERaWidgetPinWrite317, ERaWidgetPinWrite318, ERaWidgetPinWrite319, ERaWidgetPinWrite320,
    ERaWidgetPinWrite321, ERaWidgetPinWrite322, ERaWidgetPinWrite323, ERaWidgetPinWrite324, ERaWidgetPinWrite325,
    ERaWidgetPinWrite326, ERaWidgetPinWrite327, ERaWidgetPinWrite328, ERaWidgetPinWrite329, ERaWidgetPinWrite330,
    ERaWidgetPinWrite331, ERaWidgetPinWrite332, ERaWidgetPinWrite333, ERaWidgetPinWrite334, ERaWidgetPinWrite335,
    ERaWidgetPinWrite336, ERaWidgetPinWrite337, ERaWidgetPinWrite338, ERaWidgetPinWrite339, ERaWidgetPinWrite340,
    ERaWidgetPinWrite341, ERaWidgetPinWrite342, ERaWidgetPinWrite343, ERaWidgetPinWrite344, ERaWidgetPinWrite345,
    ERaWidgetPinWrite346, ERaWidgetPinWrite347, ERaWidgetPinWrite348, ERaWidgetPinWrite349, ERaWidgetPinWrite350,
    ERaWidgetPinWrite351, ERaWidgetPinWrite352, ERaWidgetPinWrite353, ERaWidgetPinWrite354, ERaWidgetPinWrite355,
    ERaWidgetPinWrite356, ERaWidgetPinWrite357, ERaWidgetPinWrite358, ERaWidgetPinWrite359, ERaWidgetPinWrite360,
    ERaWidgetPinWrite361, ERaWidgetPinWrite362, ERaWidgetPinWrite363, ERaWidgetPinWrite364, ERaWidgetPinWrite365,
    ERaWidgetPinWrite366, ERaWidgetPinWrite367, ERaWidgetPinWrite368, ERaWidgetPinWrite369, ERaWidgetPinWrite370,
    ERaWidgetPinWrite371, ERaWidgetPinWrite372, ERaWidgetPinWrite373, ERaWidgetPinWrite374, ERaWidgetPinWrite375,
    ERaWidgetPinWrite376, ERaWidgetPinWrite377, ERaWidgetPinWrite378, ERaWidgetPinWrite379, ERaWidgetPinWrite380,
    ERaWidgetPinWrite381, ERaWidgetPinWrite382, ERaWidgetPinWrite383, ERaWidgetPinWrite384, ERaWidgetPinWrite385,
    ERaWidgetPinWrite386, ERaWidgetPinWrite387, ERaWidgetPinWrite388, ERaWidgetPinWrite389, ERaWidgetPinWrite390,
    ERaWidgetPinWrite391, ERaWidgetPinWrite392, ERaWidgetPinWrite393, ERaWidgetPinWrite394, ERaWidgetPinWrite395,
    ERaWidgetPinWrite396, ERaWidgetPinWrite397, ERaWidgetPinWrite398, ERaWidgetPinWrite399, ERaWidgetPinWrite400,
    ERaWidgetPinWrite401, ERaWidgetPinWrite402, ERaWidgetPinWrite403, ERaWidgetPinWrite404, ERaWidgetPinWrite405,
    ERaWidgetPinWrite406, ERaWidgetPinWrite407, ERaWidgetPinWrite408, ERaWidgetPinWrite409, ERaWidgetPinWrite410,
    ERaWidgetPinWrite411, ERaWidgetPinWrite412, ERaWidgetPinWrite413, ERaWidgetPinWrite414, ERaWidgetPinWrite415,
    ERaWidgetPinWrite416, ERaWidgetPinWrite417, ERaWidgetPinWrite418, ERaWidgetPinWrite419, ERaWidgetPinWrite420,
    ERaWidgetPinWrite421, ERaWidgetPinWrite422, ERaWidgetPinWrite423, ERaWidgetPinWrite424, ERaWidgetPinWrite425,
    ERaWidgetPinWrite426, ERaWidgetPinWrite427, ERaWidgetPinWrite428, ERaWidgetPinWrite429, ERaWidgetPinWrite430,
    ERaWidgetPinWrite431, ERaWidgetPinWrite432, ERaWidgetPinWrite433, ERaWidgetPinWrite434, ERaWidgetPinWrite435,
    ERaWidgetPinWrite436, ERaWidgetPinWrite437, ERaWidgetPinWrite438, ERaWidgetPinWrite439, ERaWidgetPinWrite440,
    ERaWidgetPinWrite441, ERaWidgetPinWrite442, ERaWidgetPinWrite443, ERaWidgetPinWrite444, ERaWidgetPinWrite445,
    ERaWidgetPinWrite446, ERaWidgetPinWrite447, ERaWidgetPinWrite448, ERaWidgetPinWrite449, ERaWidgetPinWrite450,
    ERaWidgetPinWrite451, ERaWidgetPinWrite452, ERaWidgetPinWrite453, ERaWidgetPinWrite454, ERaWidgetPinWrite455,
    ERaWidgetPinWrite456, ERaWidgetPinWrite457, ERaWidgetPinWrite458, ERaWidgetPinWrite459, ERaWidgetPinWrite460,
    ERaWidgetPinWrite461, ERaWidgetPinWrite462, ERaWidgetPinWrite463, ERaWidgetPinWrite464, ERaWidgetPinWrite465,
    ERaWidgetPinWrite466, ERaWidgetPinWrite467, ERaWidgetPinWrite468, ERaWidgetPinWrite469, ERaWidgetPinWrite470,
    ERaWidgetPinWrite471, ERaWidgetPinWrite472, ERaWidgetPinWrite473, ERaWidgetPinWrite474, ERaWidgetPinWrite475,
    ERaWidgetPinWrite476, ERaWidgetPinWrite477, ERaWidgetPinWrite478, ERaWidgetPinWrite479, ERaWidgetPinWrite480,
    ERaWidgetPinWrite481, ERaWidgetPinWrite482, ERaWidgetPinWrite483, ERaWidgetPinWrite484, ERaWidgetPinWrite485,
    ERaWidgetPinWrite486, ERaWidgetPinWrite487, ERaWidgetPinWrite488, ERaWidgetPinWrite489, ERaWidgetPinWrite490,
    ERaWidgetPinWrite491, ERaWidgetPinWrite492, ERaWidgetPinWrite493, ERaWidgetPinWrite494, ERaWidgetPinWrite495,
    ERaWidgetPinWrite496, ERaWidgetPinWrite497, ERaWidgetPinWrite498, ERaWidgetPinWrite499,
#endif
};

ERaWriteHandler_t getERaWriteHandler(uint16_t pin) {
    if (pin >= ERA_COUNT_OF(ERaWriteHandlerVector)) {
        return nullptr;
    }
#if defined(ERA_HAS_PROGMEM)
    return (ERaWriteHandler_t)pgm_read_ptr(&ERaWriteHandlerVector[pin]);
#else
    return ERaWriteHandlerVector[pin];
#endif
}

ERaPinReadHandler_t getERaPinReadHandler(uint16_t pin) {
    if (pin >= ERA_COUNT_OF(ERaPinReadHandlerVector)) {
        return nullptr;
    }
#if defined(ERA_HAS_PROGMEM)
    return (ERaPinReadHandler_t)pgm_read_ptr(&ERaPinReadHandlerVector[pin]);
#else
    return ERaPinReadHandlerVector[pin];
#endif
}

ERaPinWriteHandler_t getERaPinWriteHandler(uint16_t pin) {
    if (pin >= ERA_COUNT_OF(ERaPinWriteHandlerVector)) {
        return nullptr;
    }
#if defined(ERA_HAS_PROGMEM)
    return (ERaPinWriteHandler_t)pgm_read_ptr(&ERaPinWriteHandlerVector[pin]);
#else
    return ERaPinWriteHandlerVector[pin];
#endif
}
