# ERa Library

[![GitHub version](https://img.shields.io/github/release/eoh-jsc/era-lib.svg)](https://github.com/eoh-jsc/era-lib/releases/latest)
[![GitHub download](https://img.shields.io/github/downloads/eoh-jsc/era-lib/total.svg)](https://github.com/eoh-jsc/era-lib/releases/latest)
[![GitHub stars](https://img.shields.io/github/stars/eoh-jsc/era-lib.svg)](https://github.com/eoh-jsc/era-lib/stargazers)
[![GitHub issues](https://img.shields.io/github/issues/eoh-jsc/era-lib.svg)](https://github.com/eoh-jsc/era-lib/issues)
[![Compile status](https://img.shields.io/github/actions/workflow/status/eoh-jsc/era-lib/compile-examples.yml?branch=main)](https://github.com/eoh-jsc/era-lib/actions)
[![Compile linux status](https://img.shields.io/github/actions/workflow/status/eoh-jsc/era-lib/compile-linux-examples.yml?branch=main)](https://github.com/eoh-jsc/era-lib/actions)
[![License](https://img.shields.io/badge/license-MIT-blue.svg)](https://github.com/eoh-jsc/era-lib/blob/master/LICENSE)

An IoT Market Enabler! It supports WiFi, Ethernet, Zigbee, Modbus, Serial. Works with boards like Arduino, ESP8266, ESP32, STM32, Raspberry Pi...

Website: https://e-ra.io

## Downloads

**ERa [Library](https://github.com/eoh-jsc/era-lib/releases/latest) | 
[Arduino](https://www.arduino.cc/reference/en/libraries/era) | 
[PlatformIO](https://registry.platformio.org/libraries/eoh-ltd/ERa/installation)**

**ERa Mobile App: 
[<img src="https://cdn.rawgit.com/simple-icons/simple-icons/develop/icons/googleplay.svg" width="18" height="18" /> Google Play](https://play.google.com/store/apps/details?id=com.eohjsc.eohmobile) | 
[<img src="https://cdn.rawgit.com/simple-icons/simple-icons/develop/icons/apple.svg" width="18" height="18" /> App Store](https://apps.apple.com/vn/app/eoh-iot/id1561293538)**

## Quickstart: ESP32 with Arduino IDE

* Download the ERa app.
* Get the ERa Auth Token.
* Install this library to Arduino IDE. Guide [here](http://arduino.cc/en/guide/libraries)
* In Arduino IDE, select File -> Examples -> ERa -> ESP32 -> ESP32_WiFi_Basic.
* Update ERa Auth Token, ssid and pass wifi in the sketch and upload it to ESP32.

## Quickstart: ESP32 with PlatformIO

* Download the ERa app.
* Get the ERa Auth Token.
* Install this library to PlatformIO. (Select PIO Home -> Libraries -> Search "ERa EoH" -> Install latest version)
* In PlatformIO, select PIO Home -> Libraries -> Search "ERa EoH" -> Examples -> ERa -> ESP32 -> ESP32_WiFi_Basic.
* Update ERa Auth Token, ssid and pass wifi in the main.cpp and upload it to ESP32.

**Social Media:**

[Blog](https://iotasia.org) | 
[Forum](https://forum.eoh.io) | 
[Facebook](https://www.fb.com/EoHPlatform)

### License
This project is released under The MIT License (MIT)
