---
layout: spec
latex: true
---

# Engineering 100-980 “Rocket Science” Fall 2023

## Course Overview

In this section of ENGR100, we will focus on Rocket Science - learning about orbital mechanics, different types of rocket engines, and the basics of interplanetary travel. We will learn how to solve Newton's Laws on a computer and how large simulation software works. Labs will build on each other to provide a foundation for the team project, which will focus on asteroid mitigation.

### Course Objectives

Engineering 100 is a team-based, project-based course. It is intended to provide you with an introduction to the disciplines of engineering and technical communication, and an opportunity to develop your engineering “tool kit” within the context of an authentic project with a team and managers who are looking for reviews and updates.

[The learning objectives for Engineering 100 are described in this document.](docs/engr100.md)

### Course Structure

You enrolled in a course with lectures, a discussion, and a lab. Your discussion and lab together make up a three-hour block on Monday, Tuesday, or Wednesday, and attendance during this time is critical to course success. Your teams will be assigned from within the \~20 students of your discussion/lab section. Teams will complete some of their work during these slots, though you will likely also need to arrange some time on your own.

| Class | Time | Location |
| ----- | ---- | -------- |
| **Lecture (980)** | TuTh 3:00-4:30 | 1017 DOW |
| Lab (981) | W 3:30-5:30 | 1225 CSRB |
| Discussion (982) | W 2:30-3:30 | 1008 EECS |
| Lab (983) | Th 12:30-2:30 | 1225 CSRB |
| Discussion (984) | W 12:30-1:30 | 1018 DOW |
| Lab (985) | W 12:30-2:30 | 1225 CSRB |
| Discussion (986) | W 11:30-12:30 | 1018 DOW |

### Instructor Information

Here is contact information for all the course staff. If you have a question that might be relevant to others, **please use the course Slack workspace first**. Otherwise, please do email us with any questions or concerns that you have about class. We’re very happy to set up one-on-one meetings.

| Instructor | Contact  | Office Hours |
| ---------- | -------- | ------------ |
| Prof. Aaron Ridley<br>Technical lead  | <ridley@umich.edu><br>1416 CSRB | During All Labs |
| Dr. Alan Hogg <br> Communication Instructor - lead | <alanhogg@umich.edu> <br> 307 GFL (or zoom) |Tue/Thu 1:30 - 2:30 PM |
| Dr. Evan Radeen <br> Communication Instructor - lead | eradeen@umich.edu <br> zoom! | Mon 10-11 AM <br> Fri 11 AM - 12 noon|
| Eric Andrechek <br> IA| ericandr@umich.edu <br>1210 CSRB | Mon 12:30 - 2:30 PM|
| Hannah Barnard <br> IA| hbarnard@umich.edu <br> 1210 CSRB | Tue 4 - 6 PM|
| Yichen Wang <br> IA| yicmwang@umich.edu <br>1210 CSRB | Tue 10 AM - 12 noon |
| Jack Woods <br> IA| jfwoods@umich.edu <br> 1210 CSRB | Tue 2 - 3 PM <br> Thu 4:30 - 5:30 PM |
| Ben Miller <br> IA| benjamen@umich.edu <br> 1210 CSRB | Mon 2:30 - 4:30 PM |

### Office Hours

Office hours are a chance to get to know the course staff, to get clarification on concepts presented in class, and get encouragement on homework and labs. Extensive office hours will be held throughout the semester. In person office hours are posted above.

**For an up-to-date listing of office hours, always refer to the week’s agenda on Canvas.**
[There is a google calendar available here.](https://calendar.google.com/calendar/u/0?cid=dW1pY2guZWR1X3FranB0bnZjNGs5MXA0dDQ4dXExOGFoNWNzQGdyb3VwLmNhbGVuZGFyLmdvb2dsZS5jb20)

## Canvas & Course Resources

We will use Canvas as our main online portal for this course. Canvas is the Learning Management System (LMS) of choice for U-M. Canvas should be your starting point – all other resources are linked from there, and Canvas will remind you about assignments and due dates. Make sure you are set up to receive course announcements on Canvas, since we will post critical information there. Also, monitor your “to do” list on Canvas for reminders about all assignments except some minor in-class activities. Many of your homework assignments will be on Canvas also. Yeah, Canvas. Pay attention there!

## Working with Teams

This course integrates instruction in both communication and teamwork into an engineering project. It is important to realize that “being an engineer” doesn’t just mean solving technical problems; engineers do a lot of collaborating with others and communicating ideas. We’ll practice both of those in the context of a design project.

In this course, we’ll be checking in on your group each week with surveys. We ask that you complete these surveys so we can help your group be successful.

### Teamwork

- Each student must do their share of teamwork. Each student must take part in all aspects of a team project: research; data gathering; data analysis; design; and organizing and delivering oral presentations and drafting and revising written text.
- Throughout the term, we will assess the health of your team via surveys. Please answer these questions so that we may intervene if necessary.
- The results of the surveys will be used to adjust individual team members’ grades on the group projects if one or more teammates performed unsatisfactorily.

### Teamwork Conflict

A good portion of this class is about learning to succeed on a team. We devote class time to helping you build the empathy and interpersonal skills needed to successfully navigate a team and complete a project, and we expect you to use these skills to handle the inevitable challenges of working on a team. However, sometimes there are circumstances that are beyond your control, such as a severe personality clash between two teammates or an unexpected tragedy outside of class that affects a teammate’s ability to properly contribute to the team. If this happens, please tell your instructors as soon as you start to see indicators of a major issue. There are many things we can do to help, but *only if we know about it early on!*

## Assignments

We have organized all the assignments in this course into several different types so that we (and you) can see how the course shapes up.

### Types of Assignments

There are several types of assignments that you will complete as part of this course:

- **Individual assignments** - done on your own with no collaboration
- **Peer Reviews** - done on your own with no collaboration
- **In-Class, In-discussion, and In-lab activities** - done with significant collaboration. Turn in your own work, though.
- **Group assignments** -- done with your project group with significant collaboration required. One assignment turned in for the entire group.

These assignment types are described in more detail in the next sections.  

### Exams

**There will not be any exams.**

### Assignment Submission

Please note the following guidelines about submitting your assignments:

- Please turn all assignments in on time.

- All homework assignments must be submitted via Canvas.

- Each assignment will be listed individually in Canvas > Assignments.

- **Pay attention to the format of the required submission (PDF, video, screenshot, etc.)** Canvas won’t let you submit anything else!

- Your assignment submissions must be named in a clear and professional manner.

  - Example: Ridley\_Aaron\_IndividualDesignProposal.pdf or Team04\_TeamAwesome\_PDRPresentation.pdf
  - This helps us a great deal when grading. **Points will be deducted for not naming things properly, since it is extremely inconvenient to have 20 documents called “lab2.pdf”.**

- It is YOUR responsibility to make sure that you upload the correct assignment and version to the proper place in Canvas > Assignments. We will grade whatever is (or is NOT) there when the assignment closes.

- Graded assignments will be returned to you via Canvas > Assignments.

- We provide feedback on your returned assignments. Make sure you read it!

### Late Submission Policy

Late assignments will be docked 10% per day for up to 10 days. There are exceptions.  No late assignments are allowed for:

- PDR, Go/No-Go, Final Poster, Final Report
- Team Surveys
Late assignment exceptions will be made for:
- Students register for classes late for assignments due in the month of September. 

### Grading

A breakdown of the grading for this class is shown in the table below:

|                                    |                 |
| ---------------------------------- | :-------------: |
| **Item**                           | **# of points** |
| Individual engineering/technical   |             |
| Individual technical communication |              |
| Team engineering/technical         |              |
| Team technical communication       |             |
| **Total**                          |     **000**    |

In general, the grading is close to 50/50 technical and tech comm and 50/50 individual and group. Certain assignments may be technical only, and some assignments may be tech comm only. Final letter grades will be assigned at the end of term and will be based on the points you have earned vs. the total points available in the class. We will grade on a “straight scale”:

|                       |                  |
| :-------------------: | :--------------: |
|  **Percent (x)**  | **Letter Grade** |
|         x ≥ 97.0      |        A+        |
|     97.0 > x ≥ 93.0     |        A       |
|     93.0 > x ≥ 90.0     |        A-       |
|     90.0 > x ≥ 88.0     |        B+        |
|     87.0 > x ≥ 83.0     |        B       |
|     83.0 > x ≥ 80.0     |        B-       |
|     80.0 > x ≥ 78.0     |        C+        |
|     77.0 > x ≥ 73.0     |        C       |
|     73.0 > x ≥ 70.0     |        C-       |
|     70.0 > x ≥ 68.0     |        D+        |
|     68.0 > x ≥ 63.0     |        D       |
|     63.0 > x ≥ 60.0     |        D-       |
|     60.0 > x            |        E       |

### Professionalism and Missed Meetings or Deadlines

This class is an opportunity to practice being a professional engineer, and in that role, there are expectations that you act in certain ways. In particular, if you know you will miss a course or a deadline, you should contact a supervisor \***before**\* you have missed anything (and ideally, as early as you could have known). You would normally explain the situation and briefly apologize, as well as propose a reasonable remedy (e.g., you might suggest that you’ll get notes from a friend as well as ask whether there is anything else that can be made up.) Only rarely would it be acceptable to contact the supervisor \*after\* the class period or deadline has been missed-- for example, if you had a medical emergency that you were actively addressing. There are some situations (we may request documentation) that will result in waived penalties, such as a medical emergency or a death in the family. There are other (common!) situations that we are sympathetic to, but that won’t likely result in waived course policies (examples include multiple assignments in multiple courses being due at the same time, oversleeping, uploading the wrong file).

### Contested Grade Policy

We are willing to re-evaluate the grade on any assignment provided you do the following:

- Any request for re-evaluation must be made in writing to an instructor via email.
- The written request must describe what you believe to be mis-graded, why you believe it to be mis-graded as well as what you believe to be an appropriate correction.
- Any request for re-grades must be submitted within 1 week of the return of the original graded assignment. Please note that there are three possible outcomes to a regrade request: (1) the grade is not changed; (2) the grade is raised; or (3) the grade is lowered. Also, please note that upon request, each assignment will be re-evaluated only once and all grades are final after re-evaluation.

## Commitment to the Success of All Students

The University of Michigan is committed to providing equal opportunity for participation in all programs, services, and activities. Requests for accommodations by persons with disabilities may be made by contacting the [Services for Students with Disabilities (SSD) Office](https://ssd.umich.edu) located at G664 Haven Hall. The SSD phone number is 734-763-3000. Once your eligibility for an accommodation has been determined, you will be issued a verified individual services accommodation (VISA) form. Present this form to the instructors at the beginning of the term (if you have it then), or at least two weeks prior to the need for the accommodation (exam, project, etc.). Any information you provide is private and confidential and will be treated as such. We are very happy to make any reasonable arrangements that will help ensure your success!

If you do not have a diagnosed disability but believe that we could make pedagogical accommodations that would increase your ability to learn in this course, please come talk to us. We are very happy to make any reasonable arrangements that will help ensure your success!

### Diversity, Equity, and Inclusion

The University of Michigan is committed to student learning and the development of the whole student in a diverse and multicultural campus community. We seek to engender a diverse community that is accessible, safe, and inclusive. We value a community that appreciates and learns from our similarities and differences. We pledge our commitment to support the success of all community members. If you experience anything, directly or indirectly, that goes against this commitment, please talk to any instructor, GSI, or IA -  anyone that you feel comfortable talking to. We want to know! We try hard not to knowingly do or say something that will cause harm or stress to you. Many of us are constantly going to workshops and reading papers about how to have the most inclusive classroom that we can have. But we are human and sometimes we mess up! If we do, we sincerely hope you will come talk to one of us so that we can see things from your point of view, and we can learn how to improve our class for the next semester.

### For Physical and Mental Health

Please see our [separate document on health](docs/health.md).

TL;DR: Reach out if you need help.

## General Observations and Advice

We have taught Engr 100 for a *long time* now. Here are some tips that will help you be less frustrated:

- The weekly prep work will cover the lab concepts before lab. However, the lab documents will be available alongside the weekly prep work to allow you to read the material before the lecture.
- Make sure you are clear on which assignments are to be done individually and which are to be done in a group. If you have any questions concerning the nature of an assignment, ask your instructors.
- Test presentations and reports with both Windows and MacOSX; formatting does not always transfer, even in .pdf format.
- Back up your work! If you have your own computer, make use of your U-M disk space, Google Drive, DropBox, etc. for backups. We highly recommend using an automated backup system for these cloud services.
- Taking a professional approach to your studies is extremely important. Treat your studies like a job. When you are given a major assignment, generate a first draft as soon as possible. Share this draft with your instructors and IA for maximum benefit.
- Make use of your prep work! If you get your prep work done before discussion and lab, you will be in an excellent position to interact in class. This practice will also save time in taking notes because you will know what is covered in other documents.

### The Myth of Multitasking with Technology

Please see the [multitasking document](docs/multitasking.md).

TL;DR: Come to lecture, lab, and discussion to learn, not to use social media and watch videos.

## Rules and Policies

This course is inherently more involved than other courses that do not have a laboratory aspect. The following sections outline the basic rules and policies of the course.

### Engineering 100 Honor Code and Plagiarism Policies

This class will adhere to the University of Michigan College of Engineering Honor Code, which is a statement of ethical standards by which the faculty and students of the College of Engineering conduct themselves. You are bound by the provisions of the Honor Code: ignorance of the Honor Code is no excuse to violate it. Each Engineering 100 student is expected to read the Honor Code. For details regarding the University of Michigan’s College of Engineering Honor Code, please consult the Honor Code booklet you were given at Orientation. For additional information, you may consult the [College of Engineering Honor Council](https://elc.engin.umich.edu/honor-council/).

- Verbal discussion of the individual assignments is allowed; however, sharing of completed problems, copying, or plagiarism is not allowed.

- Professional behavior is expected, including in reports, presentations, email, and informal communication (e.g. texting in your group chat).

### Communications

We will be using Slack to host the majority of the communication and asynchronous Q\&A for the course. You will receive an email invitation to join our course’s Slack workspace. You are encouraged to be active on Slack and post/answer questions as it will be a significant source of help and community in our course.

**We do not answer questions that are relevant to the whole class via email.** In order to save everyone time, we want all students to have the benefit of seeing each question and its answer, so please use Slack to ask questions.

### Recordings

Lectures will be audio/video recorded and made available on canvas. If you do not wish to be recorded, please contact a course instructor the first week of class to discuss alternative arrangements.

### Generative AI Policy

ChatGPT and similar Generative AI (“GenAI”) technologies are rapidly becoming part of our professional lives. Learning how to use GenAI tools is important for all of us. But, in the case of writing and communication, you must first learn how to perform these tasks yourself and develop your own writing practice, voice, and expertise.
As a first-year writing course, ENGR-100 helps you build the foundational writing and communication skillset you need to advance your engineering career, including clearly explaining technical content, effectively persuading readers, communicating with stakeholders, and more. Using Gen AI at this stage in your academic writing development is not conducive to learning, and can in fact inhibit your ability to develop this important foundational skillset. Honing this skillset is essential before incorporating ChatGPT and similar GenAI technologies in your academic and professional careers.

Thus, the use of GenAI tools to produce written content in ENGR-100 is not allowed. This includes composing drafts, constructing sentences, creating paragraphs, revising for style, etc. Using GenAI for these tasks in ENGR-100 violates the Engineering Honor Code, and can be reported to the Honor Council for investigation as academic misconduct.

GenAI is an advanced writing tool, and will be incorporated into your writing curriculum in upper-level courses.”

***

[\[1\]](https://docs.google.com/document/u/1/d/e/2PACX-1vQa6Gp4kuvSjpsSFilGEghIfq5EmZpL8GRDead6Zxbv7l8D0Jl_EthJM0wGnNm40A2ZYkP4utesM8c5/pub#ftnt_ref1) Slightly adapted from Webster’s New Universal Unabridged Dictionary, Deluxe 2nd Ed., Cleveland: New World Dictionaries/Simon & Schuster, 1983.



