---
layout: spec
latex: true
---

# Resources

A collection of useful cheat-sheets and diagrams you may find yourself referring back to over the course of the semester.

## Contents

- [Resources](#resources)
  - [Contents](#contents)
  - [Arduino Nano Every Pinout](#arduino-nano-every-pinout)
  - [Arduino Nano Every Tech-Specs](#arduino-nano-every-tech-specs)
  - [Voltage Divider](#voltage-divider)
  - [LED Anode vs Cathode](#led-anode-vs-cathode)
  - [Basic Circuitry Formulas](#basic-circuitry-formulas)
  - [Resistor Color Codes](#resistor-color-codes)
  - [TMP36 Wiring](#tmp36-wiring)

## Arduino Nano Every Pinout

![Arduino Nano Every pinout](https://content.arduino.cc/assets/Pinout-NANOevery_latest.png)

## Arduino Nano Every Tech-Specs

- Built-in LED Pin #: 13
- Digital Pins: 14
- Analog Pins: 8
- PWM Pins: 5
- Voltage: 5V
- Input-Voltage: 7-21V
- Current per Pin: 20mA

For more detailed specs, see [the Arduino Nano Every website](https://docs.arduino.cc/hardware/nano-every)

*[PWM]: Pulse Width Modulation

## Voltage Divider

![Voltage divider schematic](media/voltage-divider.png)

## LED Anode vs Cathode

![LED pinout diagram](media/LED-pinout-anode-cathode.png)

## Basic Circuitry Formulas

Voltage (V in Volts) = Current (I in Amps) * Resistance (R in Ohms)

Power (Watts) = Voltage (Volts) * Current (Amps)

Similarly, Watt-hours = Volts * Amp-hours

## Resistor Color Codes

![Resistor color code chart](https://eepower.com/uploads/education/resistor_color_codes_chart.png)

## TMP36 Wiring

[![TMP36 Pinout](https://cdn-learn.adafruit.com/assets/assets/000/000/471/large1024/temperature_tmp36pinout.gif?1447975787)](https://learn.adafruit.com/tmp36-temperature-sensor/overview)


