---
layout: spec
latex: true
---

# Engineering 100-980 Homepage

Welcome to Engineering 100-980! Over the course of the next semester, you will be learning how to solder, program Arduino micro-controllers, design circuit boards, create 3D CAD files, and launch rockets!

This webpage serves as the homepage for this class. From here, you can access any resources you may need, including the [syllabus](#syllabus), [labs](#labs), and more.

## Syllabus

View the syllabus [here](/syllabus)

## Labs

The labs will be made publicly visible as they are released in the week leading up to lab. You can find them linked here:

[Lab Manuals](/labs/index)

## Solder Challenge

Soldering tutorial and challenge to gain/improve soldering abilities.

[Soldering Challenge](/soldering/solder-challenge.md)

## Course Calendar

There is a google calendar available [here,](https://calendar.google.com/calendar/u/0?cid=Y19hMWVjNDA3MTJmZGZkNDhlYzA3NmNiYmE2MTliYWM5MDI0MWZkYWI1NmY2NmUxYTRhNGUwZDFiYjkwZDY3OTU3QGdyb3VwLmNhbGVuZGFyLmdvb2dsZS5jb20) and shown below. This calendar shows labs, lectures, discussions, and office hours. For a detailed schedule of assignments, make sure to check the course Canvas page.

<iframe src="https://calendar.google.com/calendar/embed?src=c_a1ec40712fdfd48ec076cbba619bac90241fdab56f66e1a4a4e0d1bb90d67957%40group.calendar.google.com&ctz=America%2FNew_York" style="border: 0" width="800" height="600" frameborder="0" scrolling="no"></iframe>

## Project

The full project specification, including PDR, Go/No-Go tests, poster, and final report is here:

[Project Specification](/project/project.md)
[PCB Documentation](/project/sensor-board.md)

## Supplemental Resources

Reference pages that may be useful, like C++/Arduino cheat-sheet, Arduino pinout diagrams, and more.
Check them out [here](/resources).

## Tutorials

View all walk-through tutorials on how to install, use, and debug resources we are using [here](/tutorials).


