---
layout: spec
latex: true
---

# Drop Test Memo Guidelines

## Contents

- [Drop Test Memo Guidelines](#drop-test-memo-guidelines)
  - [Contents](#contents)
  - [Deliverables](#deliverables)
    - [Page 1 (Memo Overview)](#page-1-memo-overview)
    - [Page 2 (Memo Format)](#page-2-memo-format)
  - [Topics Addressed in the Memo](#topics-addressed-in-the-memo)

## Deliverables

### Page 1 (Memo Overview)

- First page of a memo (heading/foreword/summary) advising management about which size parachute your team thinks will work best for a total payload of about 6 oz. This is an individual assignment, even though the lab works as teams.

  - You are writing to Dr. Ruf & Dr. Hogg or Dr. Greenspan.

  - Your foreword should set up what you are doing and why it is important for the project work to come.

  - Your summary should give the results of your experiment, interpret them, and then come to a conclusion/recommendation. Include any relevant results from your experimental and simulated results.

  - You can create your own team letterhead or use the standard one on Canvas.

  - Figures (your plots) should be in the body of the memo, and can be referred to in your summary, should you like. Same with answers to the written questions.
  
  - Figures should follow Tech Comm best practices from lecture.

  - [Link to TC lecture slides, "Figures and Tables"](https://drive.google.com/file/d/1wF_2sew3AUR0CahXwRlC7FNN-Dnxxz6n/view?usp=sharing)

### Page 2+ (Memo Format)

- Introduction, Body/Discussion, and Conclusion

- Introduction that sets the scenario and explains necessary background, as well as a forecast of the structure of the report.

- Reporting data collected, in much more detail than the Summary

- A discussion/interpretation of what a good target for a terminal velocity could be given different considerations for the descent (think about winds and hitting the ground).

- A conclusion on the size and type of parachute that you would recommend for your team.

- Include data plots that convince us that you understand the problem. Bare minimum needed is a plot of terminal velocity vs mass for different parachutes following Tech Comm guidelines from class.

## Topics Addressed in the Memo

1. Do drag force and terminal velocity change with mass? How?

2. Do the drag force and terminal velocity change with parachute size? How?

3. Plot your experimentally determined terminal velocities along with the theoretical terminal velocity calculated in the spreadsheet and the analytically calculated terminal velocities from your terminal velocity equation for your varying mass. (Hint: create a small table of these projected values as you vary your mass. You will have different lines on the plot!)

4. Why do we have you time from the third or second story instead of from the moment it drops? (Think about the kinematic equations about velocity). Compare your calculation of the time-dependent position and velocity to the assumption we made. Does this make sense?

5. At what altitude does the falling object reach terminal velocity? Does this depend on the parameter you chose to vary? How?

