---
layout: spec
latex: true
---

# Rocket Selection

## Contents

- [Rocket Selection](#rocket-selection)
  - [Contents](#contents)
  - [Links](#links)
  - [Background Information](#background-information)
  - [Selection Requirements](#selection-requirements)
  - [Submission](#submission)

## Links

- [ ] [Spreadsheet of Options](https://docs.google.com/spreadsheets/d/1A-GMChHX-hpjuka7aTT0UVTqab8TR_f_tv-glBqusAI/edit?usp=sharing)
- [ ] [Rocket Selection Form](https://umich.instructure.com/courses/709939/quizzes/410817)
- [ ] [Estes Catalog](https://cdn.shopify.com/s/files/1/0686/0220/0369/files/2023_Estes_Rockets_Catalog_Final.pdf?v=1695155410) for spare parts
- [ ] [Estes Body Tube Sizes](http://www.ninfinger.org/rockets/body_tubes.html)

<div class="primer-spec-callout danger" markdown="1">
The provided spreadsheet lists out some standard Estes rockets. Not all of them will work well for our project, so we've highlighted three recommendations. If you have a team of 5, you can choose from the Hi-Flier XL and the Vapor. The teams of 4 can choose from any of the three highlighted options.
</div>

## Background Information

For your final project, you will be constructing a model rocket to house your sensor payload. Now is the time to choose which rocket you will build! There are a few requirements that you must meet when selecting your rocket. To help with this, we have provided a [spreadsheet](https://docs.google.com/spreadsheets/d/1A-GMChHX-hpjuka7aTT0UVTqab8TR_f_tv-glBqusAI/edit?usp=sharing) of potential options to choose from.

- The PCB has a width of 0.961" and length of around 3.5".

- With all sensors mounted on headers for easy removal, the predicted depth is around 1.34".

- This creates a maximum diagonal width of around 1.64" which is ironically also a standard diameter of Estes-brand body tubes. Although this creates a tight fit, if you choose a rocket with a 1.64" diameter we will make it work.

## Selection Requirements

- The easiest location for the PCB is the nose cone. This means the diameter must allow for the width of the PCB, and the length of the nose cone before it tapers must allow for the length of the PCB. If you choose a rocket where this is not possible you will have to modify it to put the PCB inside the top of the body tube, essentially lengthening the nose cone.

<div class="primer-spec-callout danger" markdown="1">
If you are a team of 5 people, you are not allowed to select the Estes Green Eggs model.
</div>

- The rocket must have an advertised altitude of at least 700 feet.

- Your rocket should be able to support the added weight of electronic components. If your rocket weighs only 1 oz, for example, then we would be more than doubling its weight by adding a PCB, highly affecting its flight. Keep this in mind!

## Submission

Have **ONE** team member fill out the [Canvas Form](https://umich.instructure.com/courses/709939/quizzes/410817) attached to this page.

