---
layout: spec
latex: true
---


# Engineering 100-950 “Atmospheric and Space Sensors” Winter 2026

## Course Overview

Constantly, far above us, the atmosphere is a flurry of activity, as shifting temperature and pressure gradients create streams and eddies of air. We have a vast array of surface measurements of winds, pressures, and temperatures, but it is quite difficult to get measurements of the atmosphere above the surface. One way to accomplish this is with high-altitude balloons.

The National Weather Service launches approximately 200 high-altitude balloons twice every day to take measurements through the atmosphere. These mobile laboratories collect data on wind speed and direction, temperature, pressure, humidity, and can even measure parameters on the ground from high by taking and interpreting pictures from tens of thousands of feet up.

Over the course of the semester, we will design, build, test, and launch such a system by attaching a gamut of sensors to a printed circuit board (PCB). The sensors will output their data to the brain of our system, an Arduino Nano microprocessor, which we will program to accept, process and store incoming data.

We will develop testing protocols for the system, to ensure that it will function nominally during the launch. We will document these tests and explain our reasoning for conducting them. Finally, we will launch our balloons, and recover our payload for analysis. We will create graphs of our results and describe what they mean.

### Course Objectives

Engineering 100 is a team-based, project-based course. It is intended to provide you with an introduction to the disciplines of engineering and technical communication, and an opportunity to develop your engineering “tool kit” within the context of an authentic project with a team and managers who are looking for reviews and updates.

[The learning objectives for Engineering 100 are described in this document.](docs/engr100.md)

### Course Structure

You enrolled in a course with lectures, a discussion, and a lab. Your discussion and lab together make up a three-hour block on Monday, Tuesday, or Wednesday, and attendance during this time is critical to course success. Your teams will be assigned from within the \~25 students of your discussion/lab section. Teams will complete some of their work during these slots, though you will likely also need to arrange some time on your own.

| Class | Time | Location |
| ----- | ---- | -------- |
| **Lecture (950)** | TuTh 3:00-4:30 | 1200 EECS |
| Lab (951) | W 3:30-5:30 | 1210/1225 CSRB |
| Discussion (952) | W 2:30-3:30 | 104 EWRE |
| Lab (953) | Th 12:30-2:30 | 1210/1225 CSRB |
| Discussion (954) | W 12:30-1:30 | 1012 EECS |
| Lab (955) | W 12:30-2:30 | 1210/1225 CSRB |
| Discussion (956) | W 11:30-12:30 | 1012 EECS |

### Instructor Information

Here is contact information for all the course staff. If you have a question that might be relevant to others, **please use the course Slack workspace first**. Otherwise, please do email us with any questions or concerns that you have about class. We’re very happy to set up one-on-one meetings.

| Instructor | Contact  |
| ---------- | -------- |
| Dr. Aaron Ridley<br>Technical Lead  | <ridley@umich.edu><br>1416 CSRB |
| Dr. Alan Hogg <br> Technical Communication Instructor | <alanhogg@umich.edu> <br> GFL |
| Dr. David Greenspan <br> Technical Communication Instructor |  <davidgrs@umich.edu> <br> 305 GFL |
| Benjamen Miller <br> Instructional Aide | <benjamen@umich.edu> <br> 1210 CSRB |
| Zian (Sam) Ren <br> Instructional Aide | <zianren@umich.edu> <br>1210 CSRB |
| Ismael Enriquez <br> Instructional Aide | <ismaenri@umich.edu> <br> 1210 CSRB |
| Felix Foreman-Braunschweig <br> Instructional Aide, Electrical Engineer | <felixfb@umich.edu> <br> 1210 CSRB |

### Office Hours

Office hours are a chance to get to know the course staff, to get clarification on concepts presented in class, and get encouragement on homework and labs. Extensive office hours will be held throughout the semester. In person office hours are posted on the google calendar.

<!--
**For an up-to-date listing of office hours, always refer to the google calendar!**
[There is a google calendar available here.](https://calendar.google.com/calendar/u/0?cid=dW1pY2guZWR1X3FranB0bnZjNGs5MXA0dDQ4dXExOGFoNWNzQGdyb3VwLmNhbGVuZGFyLmdvb2dsZS5jb20)

<iframe src="https://calendar.google.com/calendar/embed?src=umich.edu_qkjptnvc4k91p4t48uq18ah5cs%40group.calendar.google.com&ctz=America%2FNew_York" style="border: 0" width="100%" height="600" frameborder="0" scrolling="no"></iframe>
-->

### Course Calendar

Use the course calendar to track lectures, labs, office hours, and major deadlines. Updates will appear here as the semester progresses.

<iframe src="https://calendar.google.com/calendar/embed?src=c_04c98b0d94f41460574970b8cef77cd82f99cbd86e0ccdc0a3a9172c645a60e6%40group.calendar.google.com&ctz=America%2FNew_York" style="border: 0" width="100%" height="600" frameborder="0" scrolling="no"></iframe>

## Canvas & Course Resources

We will use Canvas as our main online portal for this course. Canvas is the Learning Management System (LMS) of choice for U-M. Canvas should be your starting point – all other resources are linked from there, and Canvas will remind you about assignments and due dates. Also, monitor your “to do” list on Canvas for reminders about all assignments except some minor in-class activities. Many of your homework assignments will be on Canvas also. Yeah, Canvas. Pay attention there!

## Working with Teams

This course integrates instruction in both communication and teamwork into an engineering project. It is important to realize that “being an engineer” doesn’t just mean solving technical problems; engineers do a lot of collaborating with others and communicating ideas. We’ll practice both of those in the context of a design project.

In this course, we’ll be checking in on your group each week with surveys during the last 3/4 of the semester. We ask that you complete these surveys so we can help your group be successful. Participation points will be distributed within your team based on feedback received by all of the team members.

### Teamwork

- Each student must do their share of teamwork. Each student must take part in all aspects of a team project: research; data gathering; data analysis; design; and organizing and delivering oral presentations and drafting and revising written text.
- Throughout the term, we will assess the health of your team via surveys. Please answer these questions so that we may intervene if necessary.
- The results of the surveys will be used to adjust individual team members’ grades on the group projects if one or more teammates performed unsatisfactorily.

### Teamwork Conflict

A good portion of this class is about learning to succeed on a team. We devote class time to helping you build the empathy and interpersonal skills needed to successfully navigate a team and complete a project, and we expect you to use these skills to handle the inevitable challenges of working on a team. However, sometimes there are circumstances that are beyond your control, such as a severe personality clash between two teammates or an unexpected tragedy outside of class that affects a teammate’s ability to properly contribute to the team. If this happens, please tell your instructors as soon as you start to see indicators of a major issue. There are many things we can do to help, but *only if we know about it early on!*

## Assignments

We have organized all the assignments in this course into several different types so that we (and you) can see how the course shapes up.

### Types of Assignments

There are several types of assignments that you will complete as part of this course:

- **Individual assignments** - done on your own with no collaboration
- **Peer Reviews** - done on your own with no collaboration
- **In-Class, In-discussion, and In-lab activities** - done with significant collaboration. Turn in your own work, though.
- **Group assignments** -- done with your project group with significant collaboration required. One assignment turned in for the entire group. Grades will mostly be based on the quality of the assignment turned in, but individuals may receive a higher or lower grad depending on the results of the team surveys.

These assignment types are described in more detail in the next sections.  

### Exams

**There are no exams.**

### Assignment Submission

Please note the following guidelines about submitting your assignments:

- Please turn all assignments in on time.

- All homework assignments must be submitted via Canvas.

- Each assignment will be listed individually in Canvas > Assignments.

- **Pay attention to the format of the required submission (PDF, video, screenshot, etc.)** Canvas won’t let you submit anything else!

- Your assignment submissions must be named in a clear and professional manner.

  - Example: Ridley\_Aaron\_IndividualDesignProposal.pdf or Team04\_TeamAwesome\_PDRPresentation.pdf
  - This helps us a great deal when grading. **Points will be deducted for not naming things properly, since it is extremely inconvenient to have 20 documents called “lab2.pdf”.**

- It is YOUR responsibility to make sure that you upload the correct assignment and version to the proper place in Canvas > Assignments. We will grade whatever is (or is NOT) there when the assignment closes.

- Graded assignments will be returned to you via Canvas > Assignments.

- We provide feedback on your returned assignments. Make sure you read it!

### Late Submission Policy

Late assignments will be docked 10% per day for up to 10 days. There are exceptions.  No late assignments are allowed for:

- PDR, Go/No-Go, Final Poster, Final Report
- Team Surveys and Peer Evaluations

Late assignment exceptions will be made for:
- Students registering for classes late
- Assignments due in the month of January

### Grading

In general, the grading is close to 50/50 technical and tech comm and 50/50 individual and group. Certain assignments may be technical only, and some assignments may be tech comm only. Grades will be posted on Canvas and you can keep track of your running grade there.  Keep in mind that Canvas only reports your grade for the assignments that have been graded, so if you have not turned in an assignment, Canvas may not reflect this accurately.  If you have questions about your grade, please contact one of the teaching staff.

Final letter grades will be assigned at the end of term and will be based on the points you have earned vs. the total points available in the class. We will grade on a “straight scale”:

|                       |                  |
| :-------------------: | :--------------: |
|  **Percent (x)**  | **Letter Grade** |
|         x ≥ 97.0      |        A+        |
|     97.0 > x ≥ 93.0     |        A       |
|     93.0 > x ≥ 90.0     |        A-       |
|     90.0 > x ≥ 88.0     |        B+        |
|     87.0 > x ≥ 83.0     |        B       |
|     83.0 > x ≥ 80.0     |        B-       |
|     80.0 > x ≥ 78.0     |        C+        |
|     77.0 > x ≥ 73.0     |        C       |
|     73.0 > x ≥ 70.0     |        C-       |
|     70.0 > x ≥ 68.0     |        D+        |
|     68.0 > x ≥ 63.0     |        D       |
|     63.0 > x ≥ 60.0     |        D-       |
|     60.0 > x            |        E       |

### Professionalism and Missed Meetings or Deadlines

This class is an opportunity to practice being a professional engineer, and in that role, there are expectations that you act in certain ways. In particular, if you know you will miss a course or a deadline, you should contact a teaching staff member \***before**\* you have missed anything (and ideally, as early as you could have known). You would normally explain the situation and briefly apologize, as well as propose a reasonable remedy (e.g., you might suggest that you’ll get notes from a friend as well as ask whether there is anything else that can be made up.) Only rarely would it be acceptable to contact teaching staff \*after\* the class period or deadline has been missed-- for example, if you had a medical emergency that you were actively addressing. There are some situations (we may request documentation) that will result in waived penalties, such as a medical emergency or a death in the family. There are other (common!) situations that we are sympathetic to, but that won’t likely result in waived course policies (examples include multiple assignments in multiple courses being due at the same time, oversleeping, uploading the wrong file).

### Contested Grade Policy

We are willing to re-evaluate the grade on any assignment provided you do the following:

- Any request for re-evaluation must be made in writing to an instructor via email or slack.
- The written request must describe what you believe to be mis-graded, why you believe it to be mis-graded as well as what you believe to be an appropriate correction.
- Any request for re-grades must be submitted within 1 week of the return of the original graded assignment. Please note that there are three possible outcomes to a regrade request: (1) the grade is not changed; (2) the grade is raised; or (3) the grade is lowered. Also, please note that upon request, each assignment will be re-evaluated only once and all grades are final after re-evaluation.

## Commitment to the Success of All Students

The University of Michigan is committed to providing equal opportunity for participation in all programs, services, and activities. Requests for accommodations by persons with disabilities may be made by contacting the [Services for Students with Disabilities (SSD) Office](https://ssd.umich.edu) located at G664 Haven Hall. The SSD phone number is 734-763-3000. Once your eligibility for an accommodation has been determined, you will be issued a verified individual services accommodation (VISA) form. Present this form to the instructors at the beginning of the term (if you have it then), or at least two weeks prior to the need for the accommodation (exam, project, etc.). Any information you provide is private and confidential and will be treated as such. We are very happy to make any reasonable arrangements that will help ensure your success!

If you do not have a diagnosed disability but believe that we could make pedagogical accommodations that would increase your ability to learn in this course, please come talk to us. We are very happy to make any reasonable arrangements that will help ensure your success!

### Diversity, Equity, and Inclusion

The University of Michigan is committed to student learning and the development of the whole student in a diverse and multicultural campus community. We seek to engender a diverse community that is accessible, safe, and inclusive. We value a community that appreciates and learns from our similarities and differences. We pledge our commitment to support the success of all community members. If you experience anything, directly or indirectly, that goes against this commitment, please talk to any instructor, GSI, or IA, anyone that you feel comfortable talking to. We want to know! We try hard not to knowingly do or say something that will cause harm or stress to you. Many of us are constantly going to workshops and reading papers about how to have the most inclusive classroom that we can have. But we are human and sometimes we mess up! If we do, we sincerely hope you will come talk to one of us so that we can see things from your point of view, and we can learn how to improve our class for the next semester.

### For Physical and Mental Health

Please see our [separate document on health](docs/health.md).

TL;DR: Reach out if you need help.

## General Observations and Advice

We have taught Engr 100 for a bit now. Here are some tips that will help you be less frustrated:

- Most of the labs have "Hands On Engineering" videos on youtube that walk through the basics of how to do them.  We highly recommend that you watch these videos.
- The weekly prep work will cover the lab concepts before lab. However, the lab documents will be available alongside the weekly prep work to allow you to read the material before the lecture.
- Make sure you are clear on which assignments are to be done individually and which are to be done in a group. If you have any questions concerning the nature of an assignment, ask your instructors.
- Test presentations and reports with both Windows and MacOSX; formatting does not always transfer, even in .pdf format.
- Back up your work! If you have your own computer, make use of your U-M disk space, Google Drive, DropBox, etc. for backups. We highly recommend using an automated backup system for these cloud services.
- Taking a professional approach to your studies is extremely important. Treat your studies like a job. When you are given a major assignment, generate a first draft as soon as possible. Share this draft with your instructors and IA for maximum benefit.
- Make use of your prep work! If you get your prep work done before discussion and lab, you will be in an excellent position to interact in class. This practice will also save time in taking notes because you will know what is covered in other documents.

### The Myth of Multitasking with Technology

Please see the [multitasking document](docs/multitasking.md).

TL;DR: Come to lecture, lab, and discussion to learn, not to use social media and watch videos.

## Rules and Policies

This course is inherently more involved than other courses that do not have a laboratory aspect. The following sections outline the basic rules and policies of the course.

### Engineering 100 Honor Code and Plagiarism Policies

This class will adhere to the University of Michigan College of Engineering Honor Code, which is a statement of ethical standards by which the faculty and students of the College of Engineering conduct themselves. You are bound by the provisions of the Honor Code: ignorance of the Honor Code is no excuse to violate it. Each Engineering 100 student is expected to read the Honor Code. For details regarding the University of Michigan’s College of Engineering Honor Code, please consult the Honor Code booklet you were given at Orientation. For additional information, you may consult the [College of Engineering Honor Council](https://elc.engin.umich.edu/honor-council/).

- Verbal discussion of the individual assignments is allowed; however, sharing of completed problems, copying, or plagiarism is not allowed.

- Professional behavior is expected, including in reports, presentations, email, and informal communication (e.g. texting in your group chat).

### Communications

We will be using Slack to host the majority of the communication and asynchronous Q\&A for the course. You will receive an email invitation to join our course’s Slack workspace. You are encouraged to be active on Slack and post/answer questions as it will be a significant source of help and community in our course.

**We do not answer questions that are relevant to the whole class via email.** In order to save everyone time, we want all students to have the benefit of seeing each question and its answer, so please use Slack to ask questions.

### Generative AI Policy

ChatGPT and similar Generative AI (“GenAI”) technologies are rapidly becoming part of our professional lives. Learning how to use GenAI tools is important for all of us. But, in the case of writing and communication, you must first learn how to perform these tasks yourself and develop your own writing practice, voice, and expertise.
As a first-year writing course, ENGR-100 helps you build the foundational writing and communication skillset you need to advance your engineering career, including clearly explaining technical content, effectively persuading readers, communicating with stakeholders, and more. Using Gen AI at this stage in your academic writing development is not conducive to learning, and can in fact inhibit your ability to develop this important foundational skillset. Honing this skillset is essential before incorporating ChatGPT and similar GenAI technologies in your academic and professional careers.

Thus, the use of GenAI tools to produce written content in ENGR-100 is not allowed. This includes composing drafts, constructing sentences, creating paragraphs, revising for style, etc. Using GenAI for these tasks in ENGR-100 violates the Engineering Honor Code, and can be reported to the Honor Council for investigation as academic misconduct.

GenAI is an advanced writing tool, and will be incorporated into your writing curriculum in upper-level courses.”

***

[\[1\]](https://docs.google.com/document/u/1/d/e/2PACX-1vQa6Gp4kuvSjpsSFilGEghIfq5EmZpL8GRDead6Zxbv7l8D0Jl_EthJM0wGnNm40A2ZYkP4utesM8c5/pub#ftnt_ref1) Slightly adapted from Webster’s New Universal Unabridged Dictionary, Deluxe 2nd Ed., Cleveland: New World Dictionaries/Simon & Schuster, 1983.
