---
layout: spec
latex: true
---

# Powerboard Assembly Guide

## Required Components
All **power specific** components, including the PCBs, can be found in the two small teal cases in the soldering room. Each case is identical, so you can take all of your components out of either one. 

The only components not found in those two containers are the LEDs and resistors. There's a container of small LEDs on that same table, and resistors from the soldering challenge can be used. 

<div class="primer-spec-callout danger" markdown="1">
While you could grab all components at once then get to soldering, it may be best to grab the components one at a time, so that things don't get lost or mixed up. 
</div>

## Procedure
1. Grab a PCB and some resistors. Solder them in. 
![Step 1](/media/powerboard-guide-figures/IMG_4046.JPG)

2. Next up, solder in the capacitors. **It is critical that the capacitors go in the correct location. Check your orientation with the photo below before soldering.**
![Step 2](/media/powerboard-guide-figures/IMG_4048.JPG)

3. Diode time! Solder in your LEDs and protection diodes. **Check the orientations!!!** When you're done, you'll have something like this: 
![Step 3](/media/powerboard-guide-figures/IMG_4049.JPG)

4. The penultimate step: connectors. **Make sure the battery connector is oriented such that when plugged in, the red wire is on the same side as the J1 label. 
![Step 4](/media/powerboard-guide-figures/IMG_4050.JPG)

5. Last but most important: the LDOs! Make sure they're in the correct spots **(U1 = 5V, U2 = 3.3V)** and that the heatsinks face each other. 
![Step 5](/media/powerboard-guide-figures/IMG_4051.JPG)


And you're done! 