---
layout: spec
latex: true
---

## The Myth of Multitasking with Technology

Research suggests that you should not use your electronic devices to check Facebook, respond to email, shop online, or do anything other than participate in class and/or take notes. This type of multitasking severely affects learning. According to one study[<sup>\[2\]</sup>](https://docs.google.com/document/u/1/d/e/2PACX-1vQa6Gp4kuvSjpsSFilGEghIfq5EmZpL8GRDead6Zxbv7l8D0Jl_EthJM0wGnNm40A2ZYkP4utesM8c5/pub#ftnt2) in a large lecture course:

*Results showed that students who used laptops in class spent considerable time multitasking and that the laptop use posed a significant distraction to both users and fellow students. Most importantly, the level of laptop use was negatively related to several measures of student learning, including self-reported understanding of material and overall course performance (Fried, 2008).*

In short, technology can be wonderful, but you need to be cognizant of your (mis)use of it. Your job in this information age is not to capture all of the brilliant things we say in class; that information is out there somewhere already. Your job is instead to curate information. You need to be able to determine what information is relevant to what situations, and to find relevant information when you need it. Technology can be a fantastic tool for this (keywords, tags, etc), but we need to be mindful of the hazards of being constantly plugged in. Resist the urge to do anything but class-directed work (i.e., note-taking, in-class activities) for your own sake, and for the sake of your classmates who will be distracted by what you do.

[\[2\]](https://docs.google.com/document/u/1/d/e/2PACX-1vQa6Gp4kuvSjpsSFilGEghIfq5EmZpL8GRDead6Zxbv7l8D0Jl_EthJM0wGnNm40A2ZYkP4utesM8c5/pub#ftnt_ref2)Fried, C. B. (2008). In-class laptop use and its effects on student learning. *Computers in Education, 50*, 906-914.
