---
layout: spec
latex: true
---

# Engineering 100 Learning Objectives

The learning objectives for all sections of E100 are provided in the following:

*In Engineering 100, you will practice thinking, communicating, and acting like an engineer. In this course, you will build your professional skills and develop your own engineering “toolkit” as you work to solve engineering problems. By the end of this class, you will be able to:*
- **Employ the Engineering Design Process:** develop innovative solutions to an open-ended design project, by:
  - defining a complex problem and breaking it down into manageable pieces;
  - evaluating stakeholder impact;
  - identifying and utilizing appropriate tools and resources;
  - learning and applying relevant technical content;
  - ideating, iterating, and refining solution paths; and
  - testing and evaluating solutions.
- **Communicate Effectively as an Engineer:**
  - identify and articulate your message, your purpose for writing/speaking, and your audience’s needs;
  - create deliverables that balance your purpose and message with your audience’s needs; and
  - organize deliverables using best practices for informative and persuasive communication
- **Collaborate in Diverse Teams:**
  - collaboratively identify, analyze, and address complex problems;
  - create an inclusive team environment where all team members feel heard and valued;
  - apply best practices for effective teamwork (e.g. mutual accountability; task distribution for learning;
  - working, writing, and listening effectively in a diverse team environment).
- **Understand and Practice Professional Engineering Values:**
  - describe how you and others bring unique experiences to an engineering problem; explain how your experiences can contribute to and impact a diverse and inclusive community;
  - consider environmental, local, global, economic, and societal impact of engineering solutions in your design process;
  - apply ethical decision making;
  - identify and execute standard engineering practices/competencies; and
  - act professionally.

