
Project Preliminary Design Reviews Overview

Projects have several different design reviews.  A preliminary design review (PDR) is the review where you convince people that you have a very good understanding of the problem and have a good idea of how you are going to solve it. As we have discussed several times in class, when you have a very large project, you can break it into pieces. These pieces can then be broken further into more pieces, and this can be repeated until the problems are small enough that they can be dealt with.  

Understanding of the problem does not mean that you understand what has been asked of you, but that you understand what is needed to actually implement a solution. 

In order to have a good PDR, you need to specify the requirements.  These requirements flow down from the top-level science question or objective. This is typically the question or objective that dictates the design of the entire system.  The process in the class is clearly different than that, given that we have requirements on what sensors you will fly.  You are free to ask any science question that uses the data that you will be collecting.

Once these are completed, the preliminary design can be started.  

Your PDR should contain:
- Your team name / number with team members identified
- A clear statement/summary of your team's science objective / question
- Requirements that are levied because of science and class
(Mass, data, power, connections, etc.)
- Your extra sensor (if applicable) and its characteristics
- System-level block diagram (Very much like your schematic, but simplified and with connections (5V, 3.3V, analog, digital))
- PCB design. This should have some sort of indication of the size of the PCB. (Pull from Altium; photo of actual PCB.)
- Preliminary structure design with some list of materials that you will need.
- How your design was shaped by the requirements.
- A data budget - spreadsheet!
- A power budget - spreadsheet!
- A mass budget - spreadsheet!
- Testing strategies that you have come up with.
- Who will be responsible for what parts of the project (For example, coding, soldering, building structure, testing)


Limitations on the PDR:

Because we have a lot of teams, we have a limited amount of time to dedicate to the PDRs in class.  We will most likely spread the PDRs across class and discussions. We will put out a schedule of the PDRs on the Monday of PDR week.

All PDRs presentations are due on the Tuesday of PDR week before class (see Canvas for the exact date and time!)

Each PDR presentation will be 20 minutes including questions. Expect 10 minutes for questions, so each PDR should be aimed at 10 minutes.

Please follow the presentation style described in class. Your PDR will be graded on the presentation style (4x) as well as the technical content (1x).

Please treat the PDR as a semi-professional presentation.  You don't have to wear a suit, but don't wear sweat pants.


Some Additional Important Notes:

Please make sure all of your decisions have a thorough justification associated with them. 

Cite your sources! You will be (and should be) doing some research to justify your decision making, and this means showing where you got your information from. This is not only required for academic integrity, but also an important step to showing where your justification actually came from (and will help a lot with getting sufficient detail for this project). Good sources include NASA documentation, company spec sheets, and research, but many other reliable sources are also useful.

Feedback during PDR is going to be extremely valuable for your final product. The better prepared you are for PDR, the more useful feedback you’re going to get and your final product will be far more thorough, feasible, and polished.

There is a requirement for providing peer feedback on at least three other teams' PDRs.  See the Canvas assignment for PDR Peer Review for the survey link to complete this.
