#ifndef _ESENSOR_H_INCLUDED
#define _ESENSOR_H_INCLUDED
#include <Arduino.h>
#include <ArduinoModbus/ArduinoModbus.h>
class ESensor{
public:
	//Modbus registers of sensors
	enum REG_HOLDING_INDEX{
		DEVICE_SN1,				//40001
		DEVICE_SN2,
		DEVICE_ID,
		DEVICE_PIN,				//40004
		//sensor -> value
		SENSOR_RESOLUTION,		//40005
		SENSOR_VALUE_HI,		//40006
		SENSOR_VALUE_LO,
		SENSOR_TEMP,			//40008
		SENSOR_ADC_HI,			//40009
		SENSOR_ADC_LO,
		SENSOR_ZERO_HI,			//40011
		SENSOR_ZERO_LO,
		//sensor -> calib
		SENSOR_CAL01X_HI,		//40013
		SENSOR_CAL01X_LO,
		SENSOR_CAL01Y_HI,
		SENSOR_CAL01Y_LO,
		SENSOR_CAL02X_HI,
		SENSOR_CAL02X_LO,
		SENSOR_CAL02Y_HI,
		SENSOR_CAL02Y_LO,
		SENSOR_CAL03X_HI,
		SENSOR_CAL03X_LO,
		SENSOR_CAL03Y_HI,
		SENSOR_CAL03Y_LO,
		//sensor control
		SENSOR_CTRL,			//40025
		SENSOR_GPIO_HI,			//40026
		SENSOR_GPIO_LO,					//40027
		NC02,					//40028
		NC03,					//40029
		//sensor -> buffer
		DATA_SAMPLE_TIME,		//40030
		DATA_SAMPLE_COUNT,		//40031
		DATA_BUFFER				//40032
		
	};

  ESensor(short address,unsigned long serialNumber);
  virtual ~ESensor();
  int begin ();
  int begin (short address,unsigned long serialNumber);
  int connect();
  int request();
  float read();
  float readValue();
  float readTemp();
private:
  int m_isConnect=0;
  short m_address = 127;
  unsigned long m_serialNumber = 0;
  float m_value=0;
  float m_temp=0;
};

#endif