#include "ESensor.h"
#define HOLDING_REG_OFFSET	40001
ESensor::ESensor(short address,unsigned long serialNumber){
	m_address = address;
	m_serialNumber = serialNumber;
}

ESensor::~ESensor(){
  ModbusRTUClient.end();
}

int ESensor::connect(){
	return m_isConnect;
}

float ESensor::read(){
	float _val = m_value;
	m_value = 0;
	return _val;
}

float ESensor::readValue(){
	return read();
}
float ESensor::readTemp(){
	float _val = m_temp;
	m_temp = 0;
	return _val;
}

int ESensor::begin (){
	ModbusRTUClient.setTimeout(50);
	if(!m_isConnect)m_isConnect = ModbusRTUClient.begin(115200);
	if(!m_isConnect)return 0;
	ModbusRTUClient.holdingRegisterWrite(127,40001,(short)((m_serialNumber>>16)&0xFFFF));delay(100);
	ModbusRTUClient.holdingRegisterWrite(127,40002,(short)(m_serialNumber&0xFFFF));delay(100);
	ModbusRTUClient.holdingRegisterWrite(127,40003,m_address);delay(100);
	return m_isConnect;
}

int ESensor::begin (short address,unsigned long serialNumber){
	m_address = address;
	m_serialNumber = serialNumber;
	return begin();
}

int ESensor::request(){
//Kiểm tra xem cảm biến đã kết nối chưa, nếu kết nối mới truy vấn dữ liệu
  if(!m_isConnect){
	//thử kết nối lại
    if(begin()==0)return 0;
  }
  m_isConnect = (bool)ModbusRTUClient.requestFrom(m_address, HOLDING_REGISTERS,HOLDING_REG_OFFSET+SENSOR_RESOLUTION,4);
  if (m_isConnect) {
    short _val_resolution = ModbusRTUClient.read();
    short _val_hi = ModbusRTUClient.read();
    short _val_low = ModbusRTUClient.read();
	short _val_temp = ModbusRTUClient.read();
    float _val = ((float)_val_hi*256)+(float)_val_low;
    _val = _val/(float)_val_resolution;
    m_value = _val;
	m_temp = (float)_val_temp/100;
  }
  return m_isConnect;
}