#include <ESteme.h>
#include <SoftwareSerial.h>                   //Khai báo thư viện cổng UART phụ để hiển thị dữ liệu đọc từ cảm biến,
                                              //Cổng UART chính đã sử dụng để giao tiếp Modbus với cảm biến

//Khai báo cảm biến (địa chỉ, mã định danh)
ESensor m_humidity(1,0x51020000);               //Khai báo sử dụng một cảm biến độ ẩm, địa chỉ cảm biến = 1, và mã nhận dạng thiết bị SerialNumber = 0x51020000

SoftwareSerial serialDebug(2, 3);               //Khai báo cổng UART phụ,các chân RX = D2, TX = D3

///////////////////////////////////////////////////////////////////////////////////////////////////////////
void setup() {
  // initialize serial:
  serialDebug.begin(115200);
  serialDebug.println("Set address and connect to sensors...");

  //Bắt đầu cài đặt địa chỉ giao tiếp và kết nối tới cảm biến...
  //true: đã kết nối, false: không kết nối
  if(m_humidity.begin()==true)serialDebug.println("Humidity(1,0x51020000) is connected.");

}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
//Hàm đọc dữ liệu từ cảm biến từ Modbus
int humidity_read(){       
  //Đọc dữ liệu (modbus request) từ cảm biến, trả về false: không có dữ liệu, true: có dữ liệu
  if(m_humidity.request()==true){

    serialDebug.print("Humidity (%RH) = ");                          //Hiển thị độ ẩm
    serialDebug.print(m_humidity.readValue());

    serialDebug.print("  |   Temp (*C) = ");                         //Hiển thị nhiệt độ
    serialDebug.print(m_humidity.readTemp());
    
    serialDebug.println("");//Xuống dòng
  }
  else {
    serialDebug.println("Error request!!");                         //Không kết nối 
  }
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////
void test(){
  static unsigned long _tickLast=0;
  if((millis()-_tickLast)>1000){    //(1000ms = 1 giây) đọc dữ liệu 1 lần
    _tickLast = millis();
    //đọc dữ liệu
    humidity_read();
    }

}
///////////////////////////////////////////////////////////////////////////////////////////////////////////
void loop() {
  // code here
   test();
}