/*  The contents of this file was automatically generated by dump_modes.c
    with arguments: 48000 960
    It contains static definitions for some pre-defined modes. */
#include "modes.h"
#include "rate.h"

#ifdef HAVE_ARM_NE10
#define OVERRIDE_FFT 1
#include "static_modes_float_arm_ne10.h"
#endif

#ifndef DEF_WINDOW120
#define DEF_WINDOW120
static const opus_val16 window120[120] = {
    6.7286966e-05f, 0.00060551348f, 0.0016815970f, 0.0032947962f, 0.0054439943f,
    0.0081276923f, 0.011344001f, 0.015090633f, 0.019364886f, 0.024163635f,
    0.029483315f, 0.035319905f, 0.041668911f, 0.048525347f, 0.055883718f,
    0.063737999f, 0.072081616f, 0.080907428f, 0.090207705f, 0.099974111f,
    0.11019769f, 0.12086883f, 0.13197729f, 0.14351214f, 0.15546177f,
    0.16781389f, 0.18055550f, 0.19367290f, 0.20715171f, 0.22097682f,
    0.23513243f, 0.24960208f, 0.26436860f, 0.27941419f, 0.29472040f,
    0.31026818f, 0.32603788f, 0.34200931f, 0.35816177f, 0.37447407f,
    0.39092462f, 0.40749142f, 0.42415215f, 0.44088423f, 0.45766484f,
    0.47447104f, 0.49127978f, 0.50806798f, 0.52481261f, 0.54149077f,
    0.55807973f, 0.57455701f, 0.59090049f, 0.60708841f, 0.62309951f,
    0.63891306f, 0.65450896f, 0.66986776f, 0.68497077f, 0.69980010f,
    0.71433873f, 0.72857055f, 0.74248043f, 0.75605424f, 0.76927895f,
    0.78214257f, 0.79463430f, 0.80674445f, 0.81846456f, 0.82978733f,
    0.84070669f, 0.85121779f, 0.86131698f, 0.87100183f, 0.88027111f,
    0.88912479f, 0.89756398f, 0.90559094f, 0.91320904f, 0.92042270f,
    0.92723738f, 0.93365955f, 0.93969656f, 0.94535671f, 0.95064907f,
    0.95558353f, 0.96017067f, 0.96442171f, 0.96834849f, 0.97196334f,
    0.97527906f, 0.97830883f, 0.98106616f, 0.98356480f, 0.98581869f,
    0.98784191f, 0.98964856f, 0.99125274f, 0.99266849f, 0.99390969f,
    0.99499004f, 0.99592297f, 0.99672162f, 0.99739874f, 0.99796667f,
    0.99843728f, 0.99882195f, 0.99913147f, 0.99937606f, 0.99956527f,
    0.99970802f, 0.99981248f, 0.99988613f, 0.99993565f, 0.99996697f,
    0.99998518f, 0.99999457f, 0.99999859f, 0.99999982f, 1.0000000f,
};
#endif

#ifndef DEF_LOGN400
#define DEF_LOGN400
static const opus_int16 logN400[21] = {
    0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 16, 16, 16, 21, 21, 24, 29, 34, 36,
};
#endif

#ifndef DEF_PULSE_CACHE50
#define DEF_PULSE_CACHE50
static const opus_int16 cache_index50[105] = {
    -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 41, 41, 41,
        82, 82, 123, 164, 200, 222, 0, 0, 0, 0, 0, 0, 0, 0, 41,
        41, 41, 41, 123, 123, 123, 164, 164, 240, 266, 283, 295, 41, 41, 41,
        41, 41, 41, 41, 41, 123, 123, 123, 123, 240, 240, 240, 266, 266, 305,
        318, 328, 336, 123, 123, 123, 123, 123, 123, 123, 123, 240, 240, 240, 240,
        305, 305, 305, 318, 318, 343, 351, 358, 364, 240, 240, 240, 240, 240, 240,
        240, 240, 305, 305, 305, 305, 343, 343, 343, 351, 351, 370, 376, 382, 387,
    };
static const unsigned char cache_bits50[392] = {
    40, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
    7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 40, 15, 23, 28,
    31, 34, 36, 38, 39, 41, 42, 43, 44, 45, 46, 47, 47, 49, 50,
    51, 52, 53, 54, 55, 55, 57, 58, 59, 60, 61, 62, 63, 63, 65,
    66, 67, 68, 69, 70, 71, 71, 40, 20, 33, 41, 48, 53, 57, 61,
    64, 66, 69, 71, 73, 75, 76, 78, 80, 82, 85, 87, 89, 91, 92,
    94, 96, 98, 101, 103, 105, 107, 108, 110, 112, 114, 117, 119, 121, 123,
    124, 126, 128, 40, 23, 39, 51, 60, 67, 73, 79, 83, 87, 91, 94,
    97, 100, 102, 105, 107, 111, 115, 118, 121, 124, 126, 129, 131, 135, 139,
    142, 145, 148, 150, 153, 155, 159, 163, 166, 169, 172, 174, 177, 179, 35,
    28, 49, 65, 78, 89, 99, 107, 114, 120, 126, 132, 136, 141, 145, 149,
    153, 159, 165, 171, 176, 180, 185, 189, 192, 199, 205, 211, 216, 220, 225,
    229, 232, 239, 245, 251, 21, 33, 58, 79, 97, 112, 125, 137, 148, 157,
    166, 174, 182, 189, 195, 201, 207, 217, 227, 235, 243, 251, 17, 35, 63,
    86, 106, 123, 139, 152, 165, 177, 187, 197, 206, 214, 222, 230, 237, 250,
    25, 31, 55, 75, 91, 105, 117, 128, 138, 146, 154, 161, 168, 174, 180,
    185, 190, 200, 208, 215, 222, 229, 235, 240, 245, 255, 16, 36, 65, 89,
    110, 128, 144, 159, 173, 185, 196, 207, 217, 226, 234, 242, 250, 11, 41,
    74, 103, 128, 151, 172, 191, 209, 225, 241, 255, 9, 43, 79, 110, 138,
    163, 186, 207, 227, 246, 12, 39, 71, 99, 123, 144, 164, 182, 198, 214,
    228, 241, 253, 9, 44, 81, 113, 142, 168, 192, 214, 235, 255, 7, 49,
    90, 127, 160, 191, 220, 247, 6, 51, 95, 134, 170, 203, 234, 7, 47,
    87, 123, 155, 184, 212, 237, 6, 52, 97, 137, 174, 208, 240, 5, 57,
    106, 151, 192, 231, 5, 59, 111, 158, 202, 243, 5, 55, 103, 147, 187,
    224, 5, 60, 113, 161, 206, 248, 4, 65, 122, 175, 224, 4, 67, 127,
    182, 234,
};
static const unsigned char cache_caps50[168] = {
    224, 224, 224, 224, 224, 224, 224, 224, 160, 160, 160, 160, 185, 185, 185,
    178, 178, 168, 134, 61, 37, 224, 224, 224, 224, 224, 224, 224, 224, 240,
    240, 240, 240, 207, 207, 207, 198, 198, 183, 144, 66, 40, 160, 160, 160,
    160, 160, 160, 160, 160, 185, 185, 185, 185, 193, 193, 193, 183, 183, 172,
    138, 64, 38, 240, 240, 240, 240, 240, 240, 240, 240, 207, 207, 207, 207,
    204, 204, 204, 193, 193, 180, 143, 66, 40, 185, 185, 185, 185, 185, 185,
    185, 185, 193, 193, 193, 193, 193, 193, 193, 183, 183, 172, 138, 65, 39,
    207, 207, 207, 207, 207, 207, 207, 207, 204, 204, 204, 204, 201, 201, 201,
    188, 188, 176, 141, 66, 40, 193, 193, 193, 193, 193, 193, 193, 193, 193,
    193, 193, 193, 194, 194, 194, 184, 184, 173, 139, 65, 39, 204, 204, 204,
    204, 204, 204, 204, 204, 201, 201, 201, 201, 198, 198, 198, 187, 187, 175,
    140, 66, 40,
};
#endif

#ifndef FFT_TWIDDLES48000_960
#define FFT_TWIDDLES48000_960
static const kiss_twiddle_cpx fft_twiddles48000_960[480] = {
    {1.0000000f, -0.0000000f}, {0.99991433f, -0.013089596f},
    {0.99965732f, -0.026176948f}, {0.99922904f, -0.039259816f},
    {0.99862953f, -0.052335956f}, {0.99785892f, -0.065403129f},
    {0.99691733f, -0.078459096f}, {0.99580493f, -0.091501619f},
    {0.99452190f, -0.10452846f}, {0.99306846f, -0.11753740f},
    {0.99144486f, -0.13052619f}, {0.98965139f, -0.14349262f},
    {0.98768834f, -0.15643447f}, {0.98555606f, -0.16934950f},
    {0.98325491f, -0.18223553f}, {0.98078528f, -0.19509032f},
    {0.97814760f, -0.20791169f}, {0.97534232f, -0.22069744f},
    {0.97236992f, -0.23344536f}, {0.96923091f, -0.24615329f},
    {0.96592583f, -0.25881905f}, {0.96245524f, -0.27144045f},
    {0.95881973f, -0.28401534f}, {0.95501994f, -0.29654157f},
    {0.95105652f, -0.30901699f}, {0.94693013f, -0.32143947f},
    {0.94264149f, -0.33380686f}, {0.93819134f, -0.34611706f},
    {0.93358043f, -0.35836795f}, {0.92880955f, -0.37055744f},
    {0.92387953f, -0.38268343f}, {0.91879121f, -0.39474386f},
    {0.91354546f, -0.40673664f}, {0.90814317f, -0.41865974f},
    {0.90258528f, -0.43051110f}, {0.89687274f, -0.44228869f},
    {0.89100652f, -0.45399050f}, {0.88498764f, -0.46561452f},
    {0.87881711f, -0.47715876f}, {0.87249601f, -0.48862124f},
    {0.86602540f, -0.50000000f}, {0.85940641f, -0.51129309f},
    {0.85264016f, -0.52249856f}, {0.84572782f, -0.53361452f},
    {0.83867057f, -0.54463904f}, {0.83146961f, -0.55557023f},
    {0.82412619f, -0.56640624f}, {0.81664156f, -0.57714519f},
    {0.80901699f, -0.58778525f}, {0.80125381f, -0.59832460f},
    {0.79335334f, -0.60876143f}, {0.78531693f, -0.61909395f},
    {0.77714596f, -0.62932039f}, {0.76884183f, -0.63943900f},
    {0.76040597f, -0.64944805f}, {0.75183981f, -0.65934582f},
    {0.74314483f, -0.66913061f}, {0.73432251f, -0.67880075f},
    {0.72537437f, -0.68835458f}, {0.71630194f, -0.69779046f},
    {0.70710678f, -0.70710678f}, {0.69779046f, -0.71630194f},
    {0.68835458f, -0.72537437f}, {0.67880075f, -0.73432251f},
    {0.66913061f, -0.74314483f}, {0.65934582f, -0.75183981f},
    {0.64944805f, -0.76040597f}, {0.63943900f, -0.76884183f},
    {0.62932039f, -0.77714596f}, {0.61909395f, -0.78531693f},
    {0.60876143f, -0.79335334f}, {0.59832460f, -0.80125381f},
    {0.58778525f, -0.80901699f}, {0.57714519f, -0.81664156f},
    {0.56640624f, -0.82412619f}, {0.55557023f, -0.83146961f},
    {0.54463904f, -0.83867057f}, {0.53361452f, -0.84572782f},
    {0.52249856f, -0.85264016f}, {0.51129309f, -0.85940641f},
    {0.50000000f, -0.86602540f}, {0.48862124f, -0.87249601f},
    {0.47715876f, -0.87881711f}, {0.46561452f, -0.88498764f},
    {0.45399050f, -0.89100652f}, {0.44228869f, -0.89687274f},
    {0.43051110f, -0.90258528f}, {0.41865974f, -0.90814317f},
    {0.40673664f, -0.91354546f}, {0.39474386f, -0.91879121f},
    {0.38268343f, -0.92387953f}, {0.37055744f, -0.92880955f},
    {0.35836795f, -0.93358043f}, {0.34611706f, -0.93819134f},
    {0.33380686f, -0.94264149f}, {0.32143947f, -0.94693013f},
    {0.30901699f, -0.95105652f}, {0.29654157f, -0.95501994f},
    {0.28401534f, -0.95881973f}, {0.27144045f, -0.96245524f},
    {0.25881905f, -0.96592583f}, {0.24615329f, -0.96923091f},
    {0.23344536f, -0.97236992f}, {0.22069744f, -0.97534232f},
    {0.20791169f, -0.97814760f}, {0.19509032f, -0.98078528f},
    {0.18223553f, -0.98325491f}, {0.16934950f, -0.98555606f},
    {0.15643447f, -0.98768834f}, {0.14349262f, -0.98965139f},
    {0.13052619f, -0.99144486f}, {0.11753740f, -0.99306846f},
    {0.10452846f, -0.99452190f}, {0.091501619f, -0.99580493f},
    {0.078459096f, -0.99691733f}, {0.065403129f, -0.99785892f},
    {0.052335956f, -0.99862953f}, {0.039259816f, -0.99922904f},
    {0.026176948f, -0.99965732f}, {0.013089596f, -0.99991433f},
    {6.1230318e-17f, -1.0000000f}, {-0.013089596f, -0.99991433f},
    {-0.026176948f, -0.99965732f}, {-0.039259816f, -0.99922904f},
    {-0.052335956f, -0.99862953f}, {-0.065403129f, -0.99785892f},
    {-0.078459096f, -0.99691733f}, {-0.091501619f, -0.99580493f},
    {-0.10452846f, -0.99452190f}, {-0.11753740f, -0.99306846f},
    {-0.13052619f, -0.99144486f}, {-0.14349262f, -0.98965139f},
    {-0.15643447f, -0.98768834f}, {-0.16934950f, -0.98555606f},
    {-0.18223553f, -0.98325491f}, {-0.19509032f, -0.98078528f},
    {-0.20791169f, -0.97814760f}, {-0.22069744f, -0.97534232f},
    {-0.23344536f, -0.97236992f}, {-0.24615329f, -0.96923091f},
    {-0.25881905f, -0.96592583f}, {-0.27144045f, -0.96245524f},
    {-0.28401534f, -0.95881973f}, {-0.29654157f, -0.95501994f},
    {-0.30901699f, -0.95105652f}, {-0.32143947f, -0.94693013f},
    {-0.33380686f, -0.94264149f}, {-0.34611706f, -0.93819134f},
    {-0.35836795f, -0.93358043f}, {-0.37055744f, -0.92880955f},
    {-0.38268343f, -0.92387953f}, {-0.39474386f, -0.91879121f},
    {-0.40673664f, -0.91354546f}, {-0.41865974f, -0.90814317f},
    {-0.43051110f, -0.90258528f}, {-0.44228869f, -0.89687274f},
    {-0.45399050f, -0.89100652f}, {-0.46561452f, -0.88498764f},
    {-0.47715876f, -0.87881711f}, {-0.48862124f, -0.87249601f},
    {-0.50000000f, -0.86602540f}, {-0.51129309f, -0.85940641f},
    {-0.52249856f, -0.85264016f}, {-0.53361452f, -0.84572782f},
    {-0.54463904f, -0.83867057f}, {-0.55557023f, -0.83146961f},
    {-0.56640624f, -0.82412619f}, {-0.57714519f, -0.81664156f},
    {-0.58778525f, -0.80901699f}, {-0.59832460f, -0.80125381f},
    {-0.60876143f, -0.79335334f}, {-0.61909395f, -0.78531693f},
    {-0.62932039f, -0.77714596f}, {-0.63943900f, -0.76884183f},
    {-0.64944805f, -0.76040597f}, {-0.65934582f, -0.75183981f},
    {-0.66913061f, -0.74314483f}, {-0.67880075f, -0.73432251f},
    {-0.68835458f, -0.72537437f}, {-0.69779046f, -0.71630194f},
    {-0.70710678f, -0.70710678f}, {-0.71630194f, -0.69779046f},
    {-0.72537437f, -0.68835458f}, {-0.73432251f, -0.67880075f},
    {-0.74314483f, -0.66913061f}, {-0.75183981f, -0.65934582f},
    {-0.76040597f, -0.64944805f}, {-0.76884183f, -0.63943900f},
    {-0.77714596f, -0.62932039f}, {-0.78531693f, -0.61909395f},
    {-0.79335334f, -0.60876143f}, {-0.80125381f, -0.59832460f},
    {-0.80901699f, -0.58778525f}, {-0.81664156f, -0.57714519f},
    {-0.82412619f, -0.56640624f}, {-0.83146961f, -0.55557023f},
    {-0.83867057f, -0.54463904f}, {-0.84572782f, -0.53361452f},
    {-0.85264016f, -0.52249856f}, {-0.85940641f, -0.51129309f},
    {-0.86602540f, -0.50000000f}, {-0.87249601f, -0.48862124f},
    {-0.87881711f, -0.47715876f}, {-0.88498764f, -0.46561452f},
    {-0.89100652f, -0.45399050f}, {-0.89687274f, -0.44228869f},
    {-0.90258528f, -0.43051110f}, {-0.90814317f, -0.41865974f},
    {-0.91354546f, -0.40673664f}, {-0.91879121f, -0.39474386f},
    {-0.92387953f, -0.38268343f}, {-0.92880955f, -0.37055744f},
    {-0.93358043f, -0.35836795f}, {-0.93819134f, -0.34611706f},
    {-0.94264149f, -0.33380686f}, {-0.94693013f, -0.32143947f},
    {-0.95105652f, -0.30901699f}, {-0.95501994f, -0.29654157f},
    {-0.95881973f, -0.28401534f}, {-0.96245524f, -0.27144045f},
    {-0.96592583f, -0.25881905f}, {-0.96923091f, -0.24615329f},
    {-0.97236992f, -0.23344536f}, {-0.97534232f, -0.22069744f},
    {-0.97814760f, -0.20791169f}, {-0.98078528f, -0.19509032f},
    {-0.98325491f, -0.18223553f}, {-0.98555606f, -0.16934950f},
    {-0.98768834f, -0.15643447f}, {-0.98965139f, -0.14349262f},
    {-0.99144486f, -0.13052619f}, {-0.99306846f, -0.11753740f},
    {-0.99452190f, -0.10452846f}, {-0.99580493f, -0.091501619f},
    {-0.99691733f, -0.078459096f}, {-0.99785892f, -0.065403129f},
    {-0.99862953f, -0.052335956f}, {-0.99922904f, -0.039259816f},
    {-0.99965732f, -0.026176948f}, {-0.99991433f, -0.013089596f},
    {-1.0000000f, -1.2246064e-16f}, {-0.99991433f, 0.013089596f},
    {-0.99965732f, 0.026176948f}, {-0.99922904f, 0.039259816f},
    {-0.99862953f, 0.052335956f}, {-0.99785892f, 0.065403129f},
    {-0.99691733f, 0.078459096f}, {-0.99580493f, 0.091501619f},
    {-0.99452190f, 0.10452846f}, {-0.99306846f, 0.11753740f},
    {-0.99144486f, 0.13052619f}, {-0.98965139f, 0.14349262f},
    {-0.98768834f, 0.15643447f}, {-0.98555606f, 0.16934950f},
    {-0.98325491f, 0.18223553f}, {-0.98078528f, 0.19509032f},
    {-0.97814760f, 0.20791169f}, {-0.97534232f, 0.22069744f},
    {-0.97236992f, 0.23344536f}, {-0.96923091f, 0.24615329f},
    {-0.96592583f, 0.25881905f}, {-0.96245524f, 0.27144045f},
    {-0.95881973f, 0.28401534f}, {-0.95501994f, 0.29654157f},
    {-0.95105652f, 0.30901699f}, {-0.94693013f, 0.32143947f},
    {-0.94264149f, 0.33380686f}, {-0.93819134f, 0.34611706f},
    {-0.93358043f, 0.35836795f}, {-0.92880955f, 0.37055744f},
    {-0.92387953f, 0.38268343f}, {-0.91879121f, 0.39474386f},
    {-0.91354546f, 0.40673664f}, {-0.90814317f, 0.41865974f},
    {-0.90258528f, 0.43051110f}, {-0.89687274f, 0.44228869f},
    {-0.89100652f, 0.45399050f}, {-0.88498764f, 0.46561452f},
    {-0.87881711f, 0.47715876f}, {-0.87249601f, 0.48862124f},
    {-0.86602540f, 0.50000000f}, {-0.85940641f, 0.51129309f},
    {-0.85264016f, 0.52249856f}, {-0.84572782f, 0.53361452f},
    {-0.83867057f, 0.54463904f}, {-0.83146961f, 0.55557023f},
    {-0.82412619f, 0.56640624f}, {-0.81664156f, 0.57714519f},
    {-0.80901699f, 0.58778525f}, {-0.80125381f, 0.59832460f},
    {-0.79335334f, 0.60876143f}, {-0.78531693f, 0.61909395f},
    {-0.77714596f, 0.62932039f}, {-0.76884183f, 0.63943900f},
    {-0.76040597f, 0.64944805f}, {-0.75183981f, 0.65934582f},
    {-0.74314483f, 0.66913061f}, {-0.73432251f, 0.67880075f},
    {-0.72537437f, 0.68835458f}, {-0.71630194f, 0.69779046f},
    {-0.70710678f, 0.70710678f}, {-0.69779046f, 0.71630194f},
    {-0.68835458f, 0.72537437f}, {-0.67880075f, 0.73432251f},
    {-0.66913061f, 0.74314483f}, {-0.65934582f, 0.75183981f},
    {-0.64944805f, 0.76040597f}, {-0.63943900f, 0.76884183f},
    {-0.62932039f, 0.77714596f}, {-0.61909395f, 0.78531693f},
    {-0.60876143f, 0.79335334f}, {-0.59832460f, 0.80125381f},
    {-0.58778525f, 0.80901699f}, {-0.57714519f, 0.81664156f},
    {-0.56640624f, 0.82412619f}, {-0.55557023f, 0.83146961f},
    {-0.54463904f, 0.83867057f}, {-0.53361452f, 0.84572782f},
    {-0.52249856f, 0.85264016f}, {-0.51129309f, 0.85940641f},
    {-0.50000000f, 0.86602540f}, {-0.48862124f, 0.87249601f},
    {-0.47715876f, 0.87881711f}, {-0.46561452f, 0.88498764f},
    {-0.45399050f, 0.89100652f}, {-0.44228869f, 0.89687274f},
    {-0.43051110f, 0.90258528f}, {-0.41865974f, 0.90814317f},
    {-0.40673664f, 0.91354546f}, {-0.39474386f, 0.91879121f},
    {-0.38268343f, 0.92387953f}, {-0.37055744f, 0.92880955f},
    {-0.35836795f, 0.93358043f}, {-0.34611706f, 0.93819134f},
    {-0.33380686f, 0.94264149f}, {-0.32143947f, 0.94693013f},
    {-0.30901699f, 0.95105652f}, {-0.29654157f, 0.95501994f},
    {-0.28401534f, 0.95881973f}, {-0.27144045f, 0.96245524f},
    {-0.25881905f, 0.96592583f}, {-0.24615329f, 0.96923091f},
    {-0.23344536f, 0.97236992f}, {-0.22069744f, 0.97534232f},
    {-0.20791169f, 0.97814760f}, {-0.19509032f, 0.98078528f},
    {-0.18223553f, 0.98325491f}, {-0.16934950f, 0.98555606f},
    {-0.15643447f, 0.98768834f}, {-0.14349262f, 0.98965139f},
    {-0.13052619f, 0.99144486f}, {-0.11753740f, 0.99306846f},
    {-0.10452846f, 0.99452190f}, {-0.091501619f, 0.99580493f},
    {-0.078459096f, 0.99691733f}, {-0.065403129f, 0.99785892f},
    {-0.052335956f, 0.99862953f}, {-0.039259816f, 0.99922904f},
    {-0.026176948f, 0.99965732f}, {-0.013089596f, 0.99991433f},
    {-1.8369095e-16f, 1.0000000f}, {0.013089596f, 0.99991433f},
    {0.026176948f, 0.99965732f}, {0.039259816f, 0.99922904f},
    {0.052335956f, 0.99862953f}, {0.065403129f, 0.99785892f},
    {0.078459096f, 0.99691733f}, {0.091501619f, 0.99580493f},
    {0.10452846f, 0.99452190f}, {0.11753740f, 0.99306846f},
    {0.13052619f, 0.99144486f}, {0.14349262f, 0.98965139f},
    {0.15643447f, 0.98768834f}, {0.16934950f, 0.98555606f},
    {0.18223553f, 0.98325491f}, {0.19509032f, 0.98078528f},
    {0.20791169f, 0.97814760f}, {0.22069744f, 0.97534232f},
    {0.23344536f, 0.97236992f}, {0.24615329f, 0.96923091f},
    {0.25881905f, 0.96592583f}, {0.27144045f, 0.96245524f},
    {0.28401534f, 0.95881973f}, {0.29654157f, 0.95501994f},
    {0.30901699f, 0.95105652f}, {0.32143947f, 0.94693013f},
    {0.33380686f, 0.94264149f}, {0.34611706f, 0.93819134f},
    {0.35836795f, 0.93358043f}, {0.37055744f, 0.92880955f},
    {0.38268343f, 0.92387953f}, {0.39474386f, 0.91879121f},
    {0.40673664f, 0.91354546f}, {0.41865974f, 0.90814317f},
    {0.43051110f, 0.90258528f}, {0.44228869f, 0.89687274f},
    {0.45399050f, 0.89100652f}, {0.46561452f, 0.88498764f},
    {0.47715876f, 0.87881711f}, {0.48862124f, 0.87249601f},
    {0.50000000f, 0.86602540f}, {0.51129309f, 0.85940641f},
    {0.52249856f, 0.85264016f}, {0.53361452f, 0.84572782f},
    {0.54463904f, 0.83867057f}, {0.55557023f, 0.83146961f},
    {0.56640624f, 0.82412619f}, {0.57714519f, 0.81664156f},
    {0.58778525f, 0.80901699f}, {0.59832460f, 0.80125381f},
    {0.60876143f, 0.79335334f}, {0.61909395f, 0.78531693f},
    {0.62932039f, 0.77714596f}, {0.63943900f, 0.76884183f},
    {0.64944805f, 0.76040597f}, {0.65934582f, 0.75183981f},
    {0.66913061f, 0.74314483f}, {0.67880075f, 0.73432251f},
    {0.68835458f, 0.72537437f}, {0.69779046f, 0.71630194f},
    {0.70710678f, 0.70710678f}, {0.71630194f, 0.69779046f},
    {0.72537437f, 0.68835458f}, {0.73432251f, 0.67880075f},
    {0.74314483f, 0.66913061f}, {0.75183981f, 0.65934582f},
    {0.76040597f, 0.64944805f}, {0.76884183f, 0.63943900f},
    {0.77714596f, 0.62932039f}, {0.78531693f, 0.61909395f},
    {0.79335334f, 0.60876143f}, {0.80125381f, 0.59832460f},
    {0.80901699f, 0.58778525f}, {0.81664156f, 0.57714519f},
    {0.82412619f, 0.56640624f}, {0.83146961f, 0.55557023f},
    {0.83867057f, 0.54463904f}, {0.84572782f, 0.53361452f},
    {0.85264016f, 0.52249856f}, {0.85940641f, 0.51129309f},
    {0.86602540f, 0.50000000f}, {0.87249601f, 0.48862124f},
    {0.87881711f, 0.47715876f}, {0.88498764f, 0.46561452f},
    {0.89100652f, 0.45399050f}, {0.89687274f, 0.44228869f},
    {0.90258528f, 0.43051110f}, {0.90814317f, 0.41865974f},
    {0.91354546f, 0.40673664f}, {0.91879121f, 0.39474386f},
    {0.92387953f, 0.38268343f}, {0.92880955f, 0.37055744f},
    {0.93358043f, 0.35836795f}, {0.93819134f, 0.34611706f},
    {0.94264149f, 0.33380686f}, {0.94693013f, 0.32143947f},
    {0.95105652f, 0.30901699f}, {0.95501994f, 0.29654157f},
    {0.95881973f, 0.28401534f}, {0.96245524f, 0.27144045f},
    {0.96592583f, 0.25881905f}, {0.96923091f, 0.24615329f},
    {0.97236992f, 0.23344536f}, {0.97534232f, 0.22069744f},
    {0.97814760f, 0.20791169f}, {0.98078528f, 0.19509032f},
    {0.98325491f, 0.18223553f}, {0.98555606f, 0.16934950f},
    {0.98768834f, 0.15643447f}, {0.98965139f, 0.14349262f},
    {0.99144486f, 0.13052619f}, {0.99306846f, 0.11753740f},
    {0.99452190f, 0.10452846f}, {0.99580493f, 0.091501619f},
    {0.99691733f, 0.078459096f}, {0.99785892f, 0.065403129f},
    {0.99862953f, 0.052335956f}, {0.99922904f, 0.039259816f},
    {0.99965732f, 0.026176948f}, {0.99991433f, 0.013089596f},
};
#ifndef FFT_BITREV480
#define FFT_BITREV480
static const opus_int16 fft_bitrev480[480] = {
    0, 96, 192, 288, 384, 32, 128, 224, 320, 416, 64, 160, 256, 352, 448,
    8, 104, 200, 296, 392, 40, 136, 232, 328, 424, 72, 168, 264, 360, 456,
    16, 112, 208, 304, 400, 48, 144, 240, 336, 432, 80, 176, 272, 368, 464,
    24, 120, 216, 312, 408, 56, 152, 248, 344, 440, 88, 184, 280, 376, 472,
    4, 100, 196, 292, 388, 36, 132, 228, 324, 420, 68, 164, 260, 356, 452,
    12, 108, 204, 300, 396, 44, 140, 236, 332, 428, 76, 172, 268, 364, 460,
    20, 116, 212, 308, 404, 52, 148, 244, 340, 436, 84, 180, 276, 372, 468,
    28, 124, 220, 316, 412, 60, 156, 252, 348, 444, 92, 188, 284, 380, 476,
    1, 97, 193, 289, 385, 33, 129, 225, 321, 417, 65, 161, 257, 353, 449,
    9, 105, 201, 297, 393, 41, 137, 233, 329, 425, 73, 169, 265, 361, 457,
    17, 113, 209, 305, 401, 49, 145, 241, 337, 433, 81, 177, 273, 369, 465,
    25, 121, 217, 313, 409, 57, 153, 249, 345, 441, 89, 185, 281, 377, 473,
    5, 101, 197, 293, 389, 37, 133, 229, 325, 421, 69, 165, 261, 357, 453,
    13, 109, 205, 301, 397, 45, 141, 237, 333, 429, 77, 173, 269, 365, 461,
    21, 117, 213, 309, 405, 53, 149, 245, 341, 437, 85, 181, 277, 373, 469,
    29, 125, 221, 317, 413, 61, 157, 253, 349, 445, 93, 189, 285, 381, 477,
    2, 98, 194, 290, 386, 34, 130, 226, 322, 418, 66, 162, 258, 354, 450,
    10, 106, 202, 298, 394, 42, 138, 234, 330, 426, 74, 170, 266, 362, 458,
    18, 114, 210, 306, 402, 50, 146, 242, 338, 434, 82, 178, 274, 370, 466,
    26, 122, 218, 314, 410, 58, 154, 250, 346, 442, 90, 186, 282, 378, 474,
    6, 102, 198, 294, 390, 38, 134, 230, 326, 422, 70, 166, 262, 358, 454,
    14, 110, 206, 302, 398, 46, 142, 238, 334, 430, 78, 174, 270, 366, 462,
    22, 118, 214, 310, 406, 54, 150, 246, 342, 438, 86, 182, 278, 374, 470,
    30, 126, 222, 318, 414, 62, 158, 254, 350, 446, 94, 190, 286, 382, 478,
    3, 99, 195, 291, 387, 35, 131, 227, 323, 419, 67, 163, 259, 355, 451,
    11, 107, 203, 299, 395, 43, 139, 235, 331, 427, 75, 171, 267, 363, 459,
    19, 115, 211, 307, 403, 51, 147, 243, 339, 435, 83, 179, 275, 371, 467,
    27, 123, 219, 315, 411, 59, 155, 251, 347, 443, 91, 187, 283, 379, 475,
    7, 103, 199, 295, 391, 39, 135, 231, 327, 423, 71, 167, 263, 359, 455,
    15, 111, 207, 303, 399, 47, 143, 239, 335, 431, 79, 175, 271, 367, 463,
    23, 119, 215, 311, 407, 55, 151, 247, 343, 439, 87, 183, 279, 375, 471,
    31, 127, 223, 319, 415, 63, 159, 255, 351, 447, 95, 191, 287, 383, 479,
};
#endif

#ifndef FFT_BITREV240
#define FFT_BITREV240
static const opus_int16 fft_bitrev240[240] = {
    0, 48, 96, 144, 192, 16, 64, 112, 160, 208, 32, 80, 128, 176, 224,
    4, 52, 100, 148, 196, 20, 68, 116, 164, 212, 36, 84, 132, 180, 228,
    8, 56, 104, 152, 200, 24, 72, 120, 168, 216, 40, 88, 136, 184, 232,
    12, 60, 108, 156, 204, 28, 76, 124, 172, 220, 44, 92, 140, 188, 236,
    1, 49, 97, 145, 193, 17, 65, 113, 161, 209, 33, 81, 129, 177, 225,
    5, 53, 101, 149, 197, 21, 69, 117, 165, 213, 37, 85, 133, 181, 229,
    9, 57, 105, 153, 201, 25, 73, 121, 169, 217, 41, 89, 137, 185, 233,
    13, 61, 109, 157, 205, 29, 77, 125, 173, 221, 45, 93, 141, 189, 237,
    2, 50, 98, 146, 194, 18, 66, 114, 162, 210, 34, 82, 130, 178, 226,
    6, 54, 102, 150, 198, 22, 70, 118, 166, 214, 38, 86, 134, 182, 230,
    10, 58, 106, 154, 202, 26, 74, 122, 170, 218, 42, 90, 138, 186, 234,
    14, 62, 110, 158, 206, 30, 78, 126, 174, 222, 46, 94, 142, 190, 238,
    3, 51, 99, 147, 195, 19, 67, 115, 163, 211, 35, 83, 131, 179, 227,
    7, 55, 103, 151, 199, 23, 71, 119, 167, 215, 39, 87, 135, 183, 231,
    11, 59, 107, 155, 203, 27, 75, 123, 171, 219, 43, 91, 139, 187, 235,
    15, 63, 111, 159, 207, 31, 79, 127, 175, 223, 47, 95, 143, 191, 239,
};
#endif

#ifndef FFT_BITREV120
#define FFT_BITREV120
static const opus_int16 fft_bitrev120[120] = {
    0, 24, 48, 72, 96, 8, 32, 56, 80, 104, 16, 40, 64, 88, 112,
    4, 28, 52, 76, 100, 12, 36, 60, 84, 108, 20, 44, 68, 92, 116,
    1, 25, 49, 73, 97, 9, 33, 57, 81, 105, 17, 41, 65, 89, 113,
    5, 29, 53, 77, 101, 13, 37, 61, 85, 109, 21, 45, 69, 93, 117,
    2, 26, 50, 74, 98, 10, 34, 58, 82, 106, 18, 42, 66, 90, 114,
    6, 30, 54, 78, 102, 14, 38, 62, 86, 110, 22, 46, 70, 94, 118,
    3, 27, 51, 75, 99, 11, 35, 59, 83, 107, 19, 43, 67, 91, 115,
    7, 31, 55, 79, 103, 15, 39, 63, 87, 111, 23, 47, 71, 95, 119,
};
#endif

#ifndef FFT_BITREV60
#define FFT_BITREV60
static const opus_int16 fft_bitrev60[60] = {
    0, 12, 24, 36, 48, 4, 16, 28, 40, 52, 8, 20, 32, 44, 56,
    1, 13, 25, 37, 49, 5, 17, 29, 41, 53, 9, 21, 33, 45, 57,
    2, 14, 26, 38, 50, 6, 18, 30, 42, 54, 10, 22, 34, 46, 58,
    3, 15, 27, 39, 51, 7, 19, 31, 43, 55, 11, 23, 35, 47, 59,
};
#endif

#ifndef FFT_STATE48000_960_0
#define FFT_STATE48000_960_0
static const kiss_fft_state fft_state48000_960_0 = {
    480,    /* nfft */
    0.002083333f,   /* scale */
    -1,     /* shift */
    {5, 96, 3, 32, 4, 8, 2, 4, 4, 1, 0, 0, 0, 0, 0, 0, },   /* factors */
    fft_bitrev480,  /* bitrev */
    fft_twiddles48000_960,  /* bitrev */
#ifdef OVERRIDE_FFT
    (arch_fft_state *)&cfg_arch_480,
#else
    NULL,
#endif
};
#endif

#ifndef FFT_STATE48000_960_1
#define FFT_STATE48000_960_1
static const kiss_fft_state fft_state48000_960_1 = {
    240,    /* nfft */
    0.004166667f,   /* scale */
    1,      /* shift */
    {5, 48, 3, 16, 4, 4, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, },    /* factors */
    fft_bitrev240,  /* bitrev */
    fft_twiddles48000_960,  /* bitrev */
#ifdef OVERRIDE_FFT
    (arch_fft_state *)&cfg_arch_240,
#else
    NULL,
#endif
};
#endif

#ifndef FFT_STATE48000_960_2
#define FFT_STATE48000_960_2
static const kiss_fft_state fft_state48000_960_2 = {
    120,    /* nfft */
    0.008333333f,   /* scale */
    2,      /* shift */
    {5, 24, 3, 8, 2, 4, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, },    /* factors */
    fft_bitrev120,  /* bitrev */
    fft_twiddles48000_960,  /* bitrev */
#ifdef OVERRIDE_FFT
    (arch_fft_state *)&cfg_arch_120,
#else
    NULL,
#endif
};
#endif

#ifndef FFT_STATE48000_960_3
#define FFT_STATE48000_960_3
static const kiss_fft_state fft_state48000_960_3 = {
    60,     /* nfft */
    0.016666667f,   /* scale */
    3,      /* shift */
    {5, 12, 3, 4, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },    /* factors */
    fft_bitrev60,   /* bitrev */
    fft_twiddles48000_960,  /* bitrev */
#ifdef OVERRIDE_FFT
    (arch_fft_state *)&cfg_arch_60,
#else
    NULL,
#endif
};
#endif

#endif

#ifndef MDCT_TWIDDLES960
#define MDCT_TWIDDLES960
static const opus_val16 mdct_twiddles960[1800] = {
    0.99999994f, 0.99999321f, 0.99997580f, 0.99994773f, 0.99990886f,
    0.99985933f, 0.99979913f, 0.99972820f, 0.99964654f, 0.99955416f,
    0.99945110f, 0.99933738f, 0.99921292f, 0.99907774f, 0.99893188f,
    0.99877530f, 0.99860805f, 0.99843007f, 0.99824142f, 0.99804211f,
    0.99783206f, 0.99761140f, 0.99737996f, 0.99713790f, 0.99688518f,
    0.99662173f, 0.99634761f, 0.99606287f, 0.99576741f, 0.99546129f,
    0.99514455f, 0.99481714f, 0.99447906f, 0.99413031f, 0.99377096f,
    0.99340093f, 0.99302030f, 0.99262899f, 0.99222708f, 0.99181455f,
    0.99139136f, 0.99095762f, 0.99051321f, 0.99005818f, 0.98959261f,
    0.98911643f, 0.98862964f, 0.98813224f, 0.98762429f, 0.98710573f,
    0.98657662f, 0.98603696f, 0.98548669f, 0.98492593f, 0.98435456f,
    0.98377270f, 0.98318028f, 0.98257732f, 0.98196387f, 0.98133987f,
    0.98070538f, 0.98006040f, 0.97940493f, 0.97873890f, 0.97806245f,
    0.97737551f, 0.97667813f, 0.97597027f, 0.97525197f, 0.97452319f,
    0.97378403f, 0.97303438f, 0.97227436f, 0.97150391f, 0.97072303f,
    0.96993178f, 0.96913016f, 0.96831810f, 0.96749574f, 0.96666300f,
    0.96581990f, 0.96496642f, 0.96410263f, 0.96322852f, 0.96234411f,
    0.96144938f, 0.96054435f, 0.95962906f, 0.95870346f, 0.95776761f,
    0.95682150f, 0.95586514f, 0.95489854f, 0.95392174f, 0.95293468f,
    0.95193744f, 0.95093000f, 0.94991243f, 0.94888461f, 0.94784665f,
    0.94679856f, 0.94574034f, 0.94467193f, 0.94359344f, 0.94250488f,
    0.94140619f, 0.94029742f, 0.93917859f, 0.93804967f, 0.93691075f,
    0.93576175f, 0.93460274f, 0.93343377f, 0.93225473f, 0.93106574f,
    0.92986679f, 0.92865789f, 0.92743903f, 0.92621022f, 0.92497152f,
    0.92372292f, 0.92246443f, 0.92119598f, 0.91991776f, 0.91862965f,
    0.91733170f, 0.91602397f, 0.91470635f, 0.91337901f, 0.91204184f,
    0.91069490f, 0.90933824f, 0.90797186f, 0.90659571f, 0.90520984f,
    0.90381432f, 0.90240908f, 0.90099424f, 0.89956969f, 0.89813554f,
    0.89669174f, 0.89523834f, 0.89377540f, 0.89230281f, 0.89082074f,
    0.88932908f, 0.88782793f, 0.88631725f, 0.88479710f, 0.88326746f,
    0.88172835f, 0.88017982f, 0.87862182f, 0.87705445f, 0.87547767f,
    0.87389153f, 0.87229604f, 0.87069118f, 0.86907703f, 0.86745358f,
    0.86582077f, 0.86417878f, 0.86252749f, 0.86086690f, 0.85919720f,
    0.85751826f, 0.85583007f, 0.85413277f, 0.85242635f, 0.85071075f,
    0.84898609f, 0.84725231f, 0.84550947f, 0.84375757f, 0.84199661f,
    0.84022665f, 0.83844769f, 0.83665979f, 0.83486289f, 0.83305705f,
    0.83124226f, 0.82941860f, 0.82758605f, 0.82574469f, 0.82389444f,
    0.82203537f, 0.82016748f, 0.81829083f, 0.81640542f, 0.81451124f,
    0.81260836f, 0.81069672f, 0.80877650f, 0.80684757f, 0.80490994f,
    0.80296379f, 0.80100900f, 0.79904562f, 0.79707366f, 0.79509324f,
    0.79310423f, 0.79110676f, 0.78910083f, 0.78708643f, 0.78506362f,
    0.78303236f, 0.78099275f, 0.77894479f, 0.77688843f, 0.77482378f,
    0.77275085f, 0.77066964f, 0.76858020f, 0.76648247f, 0.76437658f,
    0.76226246f, 0.76014024f, 0.75800985f, 0.75587130f, 0.75372469f,
    0.75157005f, 0.74940729f, 0.74723655f, 0.74505776f, 0.74287105f,
    0.74067634f, 0.73847371f, 0.73626316f, 0.73404479f, 0.73181850f,
    0.72958434f, 0.72734243f, 0.72509271f, 0.72283524f, 0.72057003f,
    0.71829706f, 0.71601641f, 0.71372813f, 0.71143216f, 0.70912862f,
    0.70681745f, 0.70449871f, 0.70217246f, 0.69983864f, 0.69749737f,
    0.69514859f, 0.69279242f, 0.69042879f, 0.68805778f, 0.68567938f,
    0.68329364f, 0.68090063f, 0.67850029f, 0.67609268f, 0.67367786f,
    0.67125577f, 0.66882652f, 0.66639012f, 0.66394657f, 0.66149592f,
    0.65903819f, 0.65657341f, 0.65410155f, 0.65162271f, 0.64913690f,
    0.64664418f, 0.64414448f, 0.64163786f, 0.63912445f, 0.63660413f,
    0.63407701f, 0.63154310f, 0.62900239f, 0.62645501f, 0.62390089f,
    0.62134010f, 0.61877263f, 0.61619854f, 0.61361790f, 0.61103064f,
    0.60843682f, 0.60583651f, 0.60322970f, 0.60061646f, 0.59799677f,
    0.59537065f, 0.59273821f, 0.59009939f, 0.58745426f, 0.58480281f,
    0.58214509f, 0.57948118f, 0.57681108f, 0.57413477f, 0.57145232f,
    0.56876373f, 0.56606907f, 0.56336832f, 0.56066155f, 0.55794877f,
    0.55523002f, 0.55250537f, 0.54977477f, 0.54703826f, 0.54429591f,
    0.54154772f, 0.53879374f, 0.53603399f, 0.53326851f, 0.53049731f,
    0.52772039f, 0.52493787f, 0.52214974f, 0.51935595f, 0.51655668f,
    0.51375180f, 0.51094145f, 0.50812566f, 0.50530440f, 0.50247771f,
    0.49964568f, 0.49680826f, 0.49396557f, 0.49111754f, 0.48826426f,
    0.48540577f, 0.48254207f, 0.47967321f, 0.47679919f, 0.47392011f,
    0.47103590f, 0.46814668f, 0.46525243f, 0.46235323f, 0.45944905f,
    0.45653993f, 0.45362595f, 0.45070711f, 0.44778344f, 0.44485497f,
    0.44192174f, 0.43898380f, 0.43604112f, 0.43309379f, 0.43014181f,
    0.42718524f, 0.42422408f, 0.42125839f, 0.41828820f, 0.41531351f,
    0.41233435f, 0.40935081f, 0.40636289f, 0.40337059f, 0.40037400f,
    0.39737311f, 0.39436796f, 0.39135858f, 0.38834500f, 0.38532731f,
    0.38230544f, 0.37927949f, 0.37624949f, 0.37321547f, 0.37017745f,
    0.36713544f, 0.36408952f, 0.36103970f, 0.35798600f, 0.35492846f,
    0.35186714f, 0.34880206f, 0.34573323f, 0.34266070f, 0.33958447f,
    0.33650464f, 0.33342120f, 0.33033419f, 0.32724363f, 0.32414958f,
    0.32105204f, 0.31795108f, 0.31484672f, 0.31173897f, 0.30862790f,
    0.30551350f, 0.30239585f, 0.29927495f, 0.29615086f, 0.29302359f,
    0.28989318f, 0.28675964f, 0.28362307f, 0.28048345f, 0.27734083f,
    0.27419522f, 0.27104670f, 0.26789525f, 0.26474094f, 0.26158381f,
    0.25842386f, 0.25526115f, 0.25209570f, 0.24892756f, 0.24575676f,
    0.24258332f, 0.23940729f, 0.23622867f, 0.23304754f, 0.22986393f,
    0.22667783f, 0.22348931f, 0.22029841f, 0.21710514f, 0.21390954f,
    0.21071166f, 0.20751151f, 0.20430915f, 0.20110460f, 0.19789790f,
    0.19468907f, 0.19147816f, 0.18826519f, 0.18505022f, 0.18183327f,
    0.17861435f, 0.17539354f, 0.17217083f, 0.16894630f, 0.16571994f,
    0.16249183f, 0.15926196f, 0.15603039f, 0.15279715f, 0.14956227f,
    0.14632578f, 0.14308774f, 0.13984816f, 0.13660708f, 0.13336454f,
    0.13012058f, 0.12687522f, 0.12362850f, 0.12038045f, 0.11713112f,
    0.11388054f, 0.11062872f, 0.10737573f, 0.10412160f, 0.10086634f,
    0.097609997f, 0.094352618f, 0.091094226f, 0.087834857f, 0.084574550f,
    0.081313334f, 0.078051247f, 0.074788325f, 0.071524605f, 0.068260118f,
    0.064994894f, 0.061728980f, 0.058462404f, 0.055195201f, 0.051927410f,
    0.048659060f, 0.045390189f, 0.042120833f, 0.038851023f, 0.035580799f,
    0.032310195f, 0.029039243f, 0.025767982f, 0.022496443f, 0.019224664f,
    0.015952680f, 0.012680525f, 0.0094082337f, 0.0061358409f, 0.0028633832f,
    -0.00040910527f, -0.0036815894f, -0.0069540343f, -0.010226404f, -0.013498665f,
    -0.016770782f, -0.020042717f, -0.023314439f, -0.026585912f, -0.029857099f,
    -0.033127967f, -0.036398482f, -0.039668605f, -0.042938303f, -0.046207540f,
    -0.049476285f, -0.052744497f, -0.056012146f, -0.059279196f, -0.062545612f,
    -0.065811358f, -0.069076397f, -0.072340697f, -0.075604223f, -0.078866936f,
    -0.082128808f, -0.085389800f, -0.088649876f, -0.091909006f, -0.095167145f,
    -0.098424271f, -0.10168034f, -0.10493532f, -0.10818918f, -0.11144188f,
    -0.11469338f, -0.11794366f, -0.12119267f, -0.12444039f, -0.12768677f,
    -0.13093179f, -0.13417540f, -0.13741758f, -0.14065829f, -0.14389749f,
    -0.14713514f, -0.15037122f, -0.15360570f, -0.15683852f, -0.16006967f,
    -0.16329910f, -0.16652679f, -0.16975269f, -0.17297678f, -0.17619900f,
    -0.17941935f, -0.18263777f, -0.18585424f, -0.18906870f, -0.19228116f,
    -0.19549155f, -0.19869985f, -0.20190603f, -0.20511003f, -0.20831184f,
    -0.21151142f, -0.21470875f, -0.21790376f, -0.22109644f, -0.22428675f,
    -0.22747467f, -0.23066014f, -0.23384315f, -0.23702365f, -0.24020162f,
    -0.24337701f, -0.24654980f, -0.24971995f, -0.25288740f, -0.25605217f,
    -0.25921419f, -0.26237345f, -0.26552987f, -0.26868346f, -0.27183419f,
    -0.27498198f, -0.27812684f, -0.28126872f, -0.28440759f, -0.28754342f,
    -0.29067615f, -0.29380578f, -0.29693225f, -0.30005556f, -0.30317566f,
    -0.30629250f, -0.30940607f, -0.31251630f, -0.31562322f, -0.31872672f,
    -0.32182685f, -0.32492352f, -0.32801670f, -0.33110636f, -0.33419248f,
    -0.33727503f, -0.34035397f, -0.34342924f, -0.34650084f, -0.34956875f,
    -0.35263291f, -0.35569328f, -0.35874987f, -0.36180258f, -0.36485144f,
    -0.36789638f, -0.37093741f, -0.37397444f, -0.37700745f, -0.38003644f,
    -0.38306138f, -0.38608220f, -0.38909888f, -0.39211139f, -0.39511973f,
    -0.39812380f, -0.40112361f, -0.40411916f, -0.40711036f, -0.41009718f,
    -0.41307965f, -0.41605768f, -0.41903123f, -0.42200032f, -0.42496487f,
    -0.42792490f, -0.43088034f, -0.43383113f, -0.43677729f, -0.43971881f,
    -0.44265559f, -0.44558764f, -0.44851488f, -0.45143735f, -0.45435500f,
    -0.45726776f, -0.46017563f, -0.46307856f, -0.46597654f, -0.46886954f,
    -0.47175750f, -0.47464043f, -0.47751826f, -0.48039100f, -0.48325855f,
    -0.48612097f, -0.48897815f, -0.49183011f, -0.49467680f, -0.49751821f,
    -0.50035429f, -0.50318497f, -0.50601029f, -0.50883019f, -0.51164466f,
    -0.51445359f, -0.51725709f, -0.52005500f, -0.52284735f, -0.52563411f,
    -0.52841520f, -0.53119069f, -0.53396046f, -0.53672451f, -0.53948283f,
    -0.54223537f, -0.54498214f, -0.54772300f, -0.55045801f, -0.55318713f,
    -0.55591035f, -0.55862761f, -0.56133890f, -0.56404412f, -0.56674337f,
    -0.56943649f, -0.57212353f, -0.57480448f, -0.57747924f, -0.58014780f,
    -0.58281022f, -0.58546633f, -0.58811617f, -0.59075975f, -0.59339696f,
    -0.59602785f, -0.59865236f, -0.60127044f, -0.60388207f, -0.60648727f,
    -0.60908598f, -0.61167812f, -0.61426371f, -0.61684275f, -0.61941516f,
    -0.62198097f, -0.62454009f, -0.62709254f, -0.62963831f, -0.63217729f,
    -0.63470948f, -0.63723493f, -0.63975352f, -0.64226526f, -0.64477009f,
    -0.64726806f, -0.64975911f, -0.65224314f, -0.65472025f, -0.65719032f,
    -0.65965337f, -0.66210932f, -0.66455823f, -0.66700000f, -0.66943461f,
    -0.67186207f, -0.67428231f, -0.67669535f, -0.67910111f, -0.68149966f,
    -0.68389088f, -0.68627477f, -0.68865126f, -0.69102043f, -0.69338220f,
    -0.69573659f, -0.69808346f, -0.70042288f, -0.70275480f, -0.70507920f,
    -0.70739603f, -0.70970529f, -0.71200693f, -0.71430099f, -0.71658736f,
    -0.71886611f, -0.72113711f, -0.72340041f, -0.72565591f, -0.72790372f,
    -0.73014367f, -0.73237586f, -0.73460019f, -0.73681659f, -0.73902518f,
    -0.74122584f, -0.74341851f, -0.74560326f, -0.74778003f, -0.74994880f,
    -0.75210953f, -0.75426215f, -0.75640678f, -0.75854325f, -0.76067162f,
    -0.76279181f, -0.76490390f, -0.76700771f, -0.76910341f, -0.77119076f,
    -0.77326995f, -0.77534080f, -0.77740335f, -0.77945763f, -0.78150350f,
    -0.78354102f, -0.78557014f, -0.78759086f, -0.78960317f, -0.79160696f,
    -0.79360235f, -0.79558921f, -0.79756755f, -0.79953730f, -0.80149853f,
    -0.80345118f, -0.80539525f, -0.80733067f, -0.80925739f, -0.81117553f,
    -0.81308490f, -0.81498563f, -0.81687760f, -0.81876087f, -0.82063532f,
    -0.82250100f, -0.82435787f, -0.82620591f, -0.82804507f, -0.82987541f,
    -0.83169687f, -0.83350939f, -0.83531296f, -0.83710766f, -0.83889335f,
    -0.84067005f, -0.84243774f, -0.84419644f, -0.84594607f, -0.84768665f,
    -0.84941816f, -0.85114056f, -0.85285389f, -0.85455805f, -0.85625303f,
    -0.85793889f, -0.85961550f, -0.86128294f, -0.86294121f, -0.86459017f,
    -0.86622989f, -0.86786032f, -0.86948150f, -0.87109333f, -0.87269586f,
    -0.87428904f, -0.87587279f, -0.87744725f, -0.87901229f, -0.88056785f,
    -0.88211405f, -0.88365078f, -0.88517809f, -0.88669586f, -0.88820416f,
    -0.88970292f, -0.89119220f, -0.89267188f, -0.89414203f, -0.89560264f,
    -0.89705360f, -0.89849502f, -0.89992678f, -0.90134889f, -0.90276134f,
    -0.90416414f, -0.90555727f, -0.90694070f, -0.90831441f, -0.90967834f,
    -0.91103262f, -0.91237706f, -0.91371179f, -0.91503674f, -0.91635185f,
    -0.91765714f, -0.91895264f, -0.92023826f, -0.92151409f, -0.92277998f,
    -0.92403603f, -0.92528218f, -0.92651838f, -0.92774469f, -0.92896110f,
    -0.93016750f, -0.93136400f, -0.93255049f, -0.93372697f, -0.93489349f,
    -0.93604994f, -0.93719643f, -0.93833286f, -0.93945926f, -0.94057560f,
    -0.94168180f, -0.94277799f, -0.94386405f, -0.94494003f, -0.94600588f,
    -0.94706154f, -0.94810712f, -0.94914252f, -0.95016778f, -0.95118284f,
    -0.95218778f, -0.95318246f, -0.95416695f, -0.95514119f, -0.95610523f,
    -0.95705903f, -0.95800257f, -0.95893586f, -0.95985889f, -0.96077162f,
    -0.96167403f, -0.96256620f, -0.96344805f, -0.96431959f, -0.96518075f,
    -0.96603161f, -0.96687216f, -0.96770233f, -0.96852213f, -0.96933156f,
    -0.97013056f, -0.97091925f, -0.97169751f, -0.97246534f, -0.97322279f,
    -0.97396982f, -0.97470641f, -0.97543252f, -0.97614825f, -0.97685349f,
    -0.97754824f, -0.97823256f, -0.97890645f, -0.97956979f, -0.98022264f,
    -0.98086500f, -0.98149687f, -0.98211825f, -0.98272908f, -0.98332942f,
    -0.98391914f, -0.98449844f, -0.98506713f, -0.98562527f, -0.98617285f,
    -0.98670989f, -0.98723638f, -0.98775226f, -0.98825759f, -0.98875231f,
    -0.98923647f, -0.98971003f, -0.99017298f, -0.99062532f, -0.99106705f,
    -0.99149817f, -0.99191868f, -0.99232858f, -0.99272782f, -0.99311644f,
    -0.99349445f, -0.99386179f, -0.99421853f, -0.99456459f, -0.99489999f,
    -0.99522477f, -0.99553883f, -0.99584228f, -0.99613506f, -0.99641716f,
    -0.99668860f, -0.99694937f, -0.99719942f, -0.99743885f, -0.99766755f,
    -0.99788558f, -0.99809295f, -0.99828959f, -0.99847561f, -0.99865085f,
    -0.99881548f, -0.99896932f, -0.99911255f, -0.99924499f, -0.99936682f,
    -0.99947786f, -0.99957830f, -0.99966794f, -0.99974692f, -0.99981517f,
    -0.99987274f, -0.99991959f, -0.99995571f, -0.99998116f, -0.99999589f,
    0.99999964f, 0.99997288f, 0.99990326f, 0.99979085f, 0.99963558f,
    0.99943751f, 0.99919659f, 0.99891287f, 0.99858636f, 0.99821711f,
    0.99780506f, 0.99735034f, 0.99685282f, 0.99631262f, 0.99572974f,
    0.99510419f, 0.99443603f, 0.99372530f, 0.99297196f, 0.99217612f,
    0.99133772f, 0.99045694f, 0.98953366f, 0.98856801f, 0.98756003f,
    0.98650974f, 0.98541719f, 0.98428243f, 0.98310548f, 0.98188645f,
    0.98062533f, 0.97932225f, 0.97797716f, 0.97659022f, 0.97516143f,
    0.97369087f, 0.97217858f, 0.97062469f, 0.96902919f, 0.96739221f,
    0.96571374f, 0.96399397f, 0.96223283f, 0.96043050f, 0.95858705f,
    0.95670253f, 0.95477700f, 0.95281059f, 0.95080340f, 0.94875544f,
    0.94666684f, 0.94453770f, 0.94236809f, 0.94015813f, 0.93790787f,
    0.93561745f, 0.93328691f, 0.93091643f, 0.92850608f, 0.92605597f,
    0.92356616f, 0.92103678f, 0.91846794f, 0.91585976f, 0.91321236f,
    0.91052586f, 0.90780038f, 0.90503591f, 0.90223277f, 0.89939094f,
    0.89651060f, 0.89359182f, 0.89063478f, 0.88763964f, 0.88460642f,
    0.88153529f, 0.87842643f, 0.87527996f, 0.87209594f, 0.86887461f,
    0.86561602f, 0.86232042f, 0.85898781f, 0.85561842f, 0.85221243f,
    0.84876984f, 0.84529096f, 0.84177583f, 0.83822471f, 0.83463764f,
    0.83101481f, 0.82735640f, 0.82366252f, 0.81993335f, 0.81616908f,
    0.81236988f, 0.80853581f, 0.80466717f, 0.80076402f, 0.79682660f,
    0.79285502f, 0.78884947f, 0.78481019f, 0.78073722f, 0.77663082f,
    0.77249116f, 0.76831841f, 0.76411277f, 0.75987434f, 0.75560343f,
    0.75130010f, 0.74696463f, 0.74259710f, 0.73819780f, 0.73376691f,
    0.72930455f, 0.72481096f, 0.72028631f, 0.71573079f, 0.71114463f,
    0.70652801f, 0.70188117f, 0.69720417f, 0.69249737f, 0.68776089f,
    0.68299496f, 0.67819971f, 0.67337549f, 0.66852236f, 0.66364062f,
    0.65873051f, 0.65379208f, 0.64882571f, 0.64383155f, 0.63880974f,
    0.63376063f, 0.62868434f, 0.62358117f, 0.61845124f, 0.61329484f,
    0.60811216f, 0.60290343f, 0.59766883f, 0.59240872f, 0.58712316f,
    0.58181250f, 0.57647687f, 0.57111657f, 0.56573176f, 0.56032276f,
    0.55488980f, 0.54943299f, 0.54395270f, 0.53844911f, 0.53292239f,
    0.52737290f, 0.52180082f, 0.51620632f, 0.51058978f, 0.50495136f,
    0.49929130f, 0.49360985f, 0.48790723f, 0.48218375f, 0.47643960f,
    0.47067502f, 0.46489030f, 0.45908567f, 0.45326138f, 0.44741765f,
    0.44155475f, 0.43567297f, 0.42977250f, 0.42385364f, 0.41791660f,
    0.41196167f, 0.40598908f, 0.39999911f, 0.39399201f, 0.38796803f,
    0.38192743f, 0.37587047f, 0.36979741f, 0.36370850f, 0.35760403f,
    0.35148421f, 0.34534934f, 0.33919969f, 0.33303553f, 0.32685706f,
    0.32066461f, 0.31445843f, 0.30823877f, 0.30200592f, 0.29576012f,
    0.28950164f, 0.28323078f, 0.27694780f, 0.27065292f, 0.26434645f,
    0.25802869f, 0.25169984f, 0.24536023f, 0.23901010f, 0.23264973f,
    0.22627939f, 0.21989937f, 0.21350993f, 0.20711134f, 0.20070387f,
    0.19428782f, 0.18786344f, 0.18143101f, 0.17499080f, 0.16854310f,
    0.16208819f, 0.15562633f, 0.14915779f, 0.14268288f, 0.13620184f,
    0.12971498f, 0.12322257f, 0.11672486f, 0.11022217f, 0.10371475f,
    0.097202882f, 0.090686858f, 0.084166944f, 0.077643424f, 0.071116582f,
    0.064586692f, 0.058054037f, 0.051518895f, 0.044981543f, 0.038442269f,
    0.031901345f, 0.025359053f, 0.018815678f, 0.012271495f, 0.0057267868f,
    -0.00081816671f, -0.0073630852f, -0.013907688f, -0.020451695f, -0.026994826f,
    -0.033536803f, -0.040077340f, -0.046616159f, -0.053152986f, -0.059687532f,
    -0.066219524f, -0.072748676f, -0.079274714f, -0.085797355f, -0.092316322f,
    -0.098831341f, -0.10534211f, -0.11184838f, -0.11834986f, -0.12484626f,
    -0.13133731f, -0.13782275f, -0.14430228f, -0.15077563f, -0.15724251f,
    -0.16370267f, -0.17015581f, -0.17660165f, -0.18303993f, -0.18947038f,
    -0.19589271f, -0.20230664f, -0.20871192f, -0.21510825f, -0.22149536f,
    -0.22787298f, -0.23424086f, -0.24059868f, -0.24694622f, -0.25328314f,
    -0.25960925f, -0.26592422f, -0.27222782f, -0.27851975f, -0.28479972f,
    -0.29106751f, -0.29732284f, -0.30356544f, -0.30979502f, -0.31601134f,
    -0.32221413f, -0.32840309f, -0.33457801f, -0.34073856f, -0.34688455f,
    -0.35301566f, -0.35913166f, -0.36523229f, -0.37131724f, -0.37738630f,
    -0.38343921f, -0.38947567f, -0.39549544f, -0.40149832f, -0.40748394f,
    -0.41345215f, -0.41940263f, -0.42533514f, -0.43124944f, -0.43714526f,
    -0.44302234f, -0.44888046f, -0.45471936f, -0.46053877f, -0.46633846f,
    -0.47211814f, -0.47787762f, -0.48361665f, -0.48933494f, -0.49503228f,
    -0.50070840f, -0.50636309f, -0.51199609f, -0.51760709f, -0.52319598f,
    -0.52876246f, -0.53430629f, -0.53982723f, -0.54532504f, -0.55079949f,
    -0.55625033f, -0.56167740f, -0.56708032f, -0.57245898f, -0.57781315f,
    -0.58314258f, -0.58844697f, -0.59372622f, -0.59897995f, -0.60420811f,
    -0.60941035f, -0.61458647f, -0.61973625f, -0.62485951f, -0.62995601f,
    -0.63502556f, -0.64006782f, -0.64508271f, -0.65007001f, -0.65502942f,
    -0.65996075f, -0.66486382f, -0.66973841f, -0.67458433f, -0.67940134f,
    -0.68418926f, -0.68894786f, -0.69367695f, -0.69837630f, -0.70304573f,
    -0.70768511f, -0.71229410f, -0.71687263f, -0.72142041f, -0.72593731f,
    -0.73042315f, -0.73487765f, -0.73930067f, -0.74369204f, -0.74805158f,
    -0.75237900f, -0.75667429f, -0.76093709f, -0.76516730f, -0.76936477f,
    -0.77352923f, -0.77766061f, -0.78175867f, -0.78582323f, -0.78985411f,
    -0.79385114f, -0.79781419f, -0.80174309f, -0.80563760f, -0.80949765f,
    -0.81332302f, -0.81711352f, -0.82086903f, -0.82458937f, -0.82827437f,
    -0.83192390f, -0.83553779f, -0.83911592f, -0.84265804f, -0.84616417f,
    -0.84963393f, -0.85306740f, -0.85646427f, -0.85982448f, -0.86314780f,
    -0.86643422f, -0.86968350f, -0.87289548f, -0.87607014f, -0.87920725f,
    -0.88230664f, -0.88536829f, -0.88839203f, -0.89137769f, -0.89432514f,
    -0.89723432f, -0.90010506f, -0.90293723f, -0.90573072f, -0.90848541f,
    -0.91120118f, -0.91387796f, -0.91651553f, -0.91911387f, -0.92167282f,
    -0.92419231f, -0.92667222f, -0.92911243f, -0.93151283f, -0.93387336f,
    -0.93619382f, -0.93847424f, -0.94071442f, -0.94291431f, -0.94507378f,
    -0.94719279f, -0.94927126f, -0.95130903f, -0.95330608f, -0.95526224f,
    -0.95717752f, -0.95905179f, -0.96088499f, -0.96267700f, -0.96442777f,
    -0.96613729f, -0.96780539f, -0.96943200f, -0.97101706f, -0.97256058f,
    -0.97406244f, -0.97552258f, -0.97694093f, -0.97831738f, -0.97965199f,
    -0.98094457f, -0.98219514f, -0.98340368f, -0.98457009f, -0.98569429f,
    -0.98677629f, -0.98781598f, -0.98881340f, -0.98976845f, -0.99068111f,
    -0.99155134f, -0.99237907f, -0.99316430f, -0.99390697f, -0.99460709f,
    -0.99526459f, -0.99587947f, -0.99645168f, -0.99698120f, -0.99746799f,
    -0.99791211f, -0.99831343f, -0.99867201f, -0.99898779f, -0.99926084f,
    -0.99949104f, -0.99967843f, -0.99982297f, -0.99992472f, -0.99998361f,
    0.99999869f, 0.99989158f, 0.99961317f, 0.99916345f, 0.99854255f,
    0.99775058f, 0.99678761f, 0.99565387f, 0.99434954f, 0.99287480f,
    0.99122995f, 0.98941529f, 0.98743105f, 0.98527765f, 0.98295540f,
    0.98046476f, 0.97780609f, 0.97497988f, 0.97198665f, 0.96882683f,
    0.96550101f, 0.96200979f, 0.95835376f, 0.95453346f, 0.95054960f,
    0.94640291f, 0.94209403f, 0.93762374f, 0.93299282f, 0.92820197f,
    0.92325211f, 0.91814411f, 0.91287869f, 0.90745693f, 0.90187967f,
    0.89614785f, 0.89026248f, 0.88422459f, 0.87803519f, 0.87169534f,
    0.86520612f, 0.85856867f, 0.85178405f, 0.84485358f, 0.83777827f,
    0.83055943f, 0.82319832f, 0.81569612f, 0.80805415f, 0.80027372f,
    0.79235619f, 0.78430289f, 0.77611518f, 0.76779449f, 0.75934225f,
    0.75075996f, 0.74204898f, 0.73321080f, 0.72424710f, 0.71515924f,
    0.70594883f, 0.69661748f, 0.68716675f, 0.67759830f, 0.66791373f,
    0.65811473f, 0.64820296f, 0.63818014f, 0.62804794f, 0.61780810f,
    0.60746247f, 0.59701276f, 0.58646071f, 0.57580817f, 0.56505698f,
    0.55420899f, 0.54326600f, 0.53222996f, 0.52110273f, 0.50988621f,
    0.49858227f, 0.48719296f, 0.47572014f, 0.46416581f, 0.45253196f,
    0.44082057f, 0.42903364f, 0.41717321f, 0.40524128f, 0.39323992f,
    0.38117120f, 0.36903715f, 0.35683987f, 0.34458145f, 0.33226398f,
    0.31988961f, 0.30746040f, 0.29497850f, 0.28244606f, 0.26986524f,
    0.25723818f, 0.24456702f, 0.23185398f, 0.21910121f, 0.20631088f,
    0.19348522f, 0.18062639f, 0.16773662f, 0.15481812f, 0.14187308f,
    0.12890373f, 0.11591230f, 0.10290100f, 0.089872077f, 0.076827750f,
    0.063770257f, 0.050701842f, 0.037624735f, 0.024541186f, 0.011453429f,
    -0.0016362892f, -0.014725727f, -0.027812643f, -0.040894791f, -0.053969935f,
    -0.067035832f, -0.080090240f, -0.093130924f, -0.10615565f, -0.11916219f,
    -0.13214831f, -0.14511178f, -0.15805040f, -0.17096193f, -0.18384418f,
    -0.19669491f, -0.20951195f, -0.22229309f, -0.23503613f, -0.24773891f,
    -0.26039925f, -0.27301496f, -0.28558388f, -0.29810387f, -0.31057280f,
    -0.32298848f, -0.33534884f, -0.34765175f, -0.35989508f, -0.37207675f,
    -0.38419467f, -0.39624676f, -0.40823093f, -0.42014518f, -0.43198743f,
    -0.44375566f, -0.45544785f, -0.46706200f, -0.47859612f, -0.49004826f,
    -0.50141639f, -0.51269865f, -0.52389306f, -0.53499764f, -0.54601061f,
    -0.55693001f, -0.56775403f, -0.57848072f, -0.58910829f, -0.59963489f,
    -0.61005878f, -0.62037814f, -0.63059121f, -0.64069623f, -0.65069145f,
    -0.66057515f, -0.67034572f, -0.68000144f, -0.68954057f, -0.69896162f,
    -0.70826286f, -0.71744281f, -0.72649974f, -0.73543227f, -0.74423873f,
    -0.75291771f, -0.76146764f, -0.76988715f, -0.77817470f, -0.78632891f,
    -0.79434842f, -0.80223179f, -0.80997771f, -0.81758487f, -0.82505190f,
    -0.83237761f, -0.83956063f, -0.84659988f, -0.85349399f, -0.86024189f,
    -0.86684239f, -0.87329435f, -0.87959671f, -0.88574833f, -0.89174819f,
    -0.89759529f, -0.90328854f, -0.90882701f, -0.91420978f, -0.91943592f,
    -0.92450452f, -0.92941469f, -0.93416560f, -0.93875647f, -0.94318646f,
    -0.94745487f, -0.95156091f, -0.95550388f, -0.95928317f, -0.96289814f,
    -0.96634805f, -0.96963239f, -0.97275060f, -0.97570217f, -0.97848648f,
    -0.98110318f, -0.98355180f, -0.98583186f, -0.98794299f, -0.98988485f,
    -0.99165714f, -0.99325943f, -0.99469161f, -0.99595332f, -0.99704438f,
    -0.99796462f, -0.99871385f, -0.99929196f, -0.99969882f, -0.99993443f,
    0.99999464f, 0.99956632f, 0.99845290f, 0.99665523f, 0.99417448f,
    0.99101239f, 0.98717111f, 0.98265326f, 0.97746199f, 0.97160077f,
    0.96507365f, 0.95788515f, 0.95004016f, 0.94154406f, 0.93240267f,
    0.92262226f, 0.91220951f, 0.90117162f, 0.88951606f, 0.87725091f,
    0.86438453f, 0.85092574f, 0.83688372f, 0.82226819f, 0.80708915f,
    0.79135692f, 0.77508235f, 0.75827658f, 0.74095112f, 0.72311783f,
    0.70478898f, 0.68597710f, 0.66669506f, 0.64695615f, 0.62677377f,
    0.60616189f, 0.58513457f, 0.56370622f, 0.54189157f, 0.51970547f,
    0.49716324f, 0.47428027f, 0.45107225f, 0.42755505f, 0.40374488f,
    0.37965798f, 0.35531086f, 0.33072025f, 0.30590299f, 0.28087607f,
    0.25565663f, 0.23026201f, 0.20470956f, 0.17901683f, 0.15320139f,
    0.12728097f, 0.10127331f, 0.075196236f, 0.049067631f, 0.022905400f,
    -0.0032725304f, -0.029448219f, -0.055603724f, -0.081721120f, -0.10778251f,
    -0.13377003f, -0.15966587f, -0.18545228f, -0.21111161f, -0.23662624f,
    -0.26197869f, -0.28715160f, -0.31212771f, -0.33688989f, -0.36142120f,
    -0.38570482f, -0.40972409f, -0.43346253f, -0.45690393f, -0.48003218f,
    -0.50283146f, -0.52528608f, -0.54738069f, -0.56910020f, -0.59042966f,
    -0.61135447f, -0.63186026f, -0.65193301f, -0.67155898f, -0.69072473f,
    -0.70941705f, -0.72762316f, -0.74533063f, -0.76252723f, -0.77920127f,
    -0.79534131f, -0.81093621f, -0.82597536f, -0.84044844f, -0.85434550f,
    -0.86765707f, -0.88037395f, -0.89248747f, -0.90398932f, -0.91487163f,
    -0.92512697f, -0.93474823f, -0.94372886f, -0.95206273f, -0.95974404f,
    -0.96676767f, -0.97312868f, -0.97882277f, -0.98384601f, -0.98819500f,
    -0.99186671f, -0.99485862f, -0.99716878f, -0.99879545f, -0.99973762f,
};
#endif

static const CELTMode mode48000_960_120 = {
    48000,  /* Fs */
    120,    /* overlap */
    21,     /* nbEBands */
    21,     /* effEBands */
    {0.85000610f, 0.0000000f, 1.0000000f, 1.0000000f, },    /* preemph */
    eband5ms,       /* eBands */
    3,      /* maxLM */
    8,      /* nbShortMdcts */
    120,    /* shortMdctSize */
    11,     /* nbAllocVectors */
    band_allocation,        /* allocVectors */
    logN400,        /* logN */
    window120,      /* window */
    {1920, 3, {&fft_state48000_960_0, &fft_state48000_960_1, &fft_state48000_960_2, &fft_state48000_960_3, }, mdct_twiddles960},    /* mdct */
    {392, cache_index50, cache_bits50, cache_caps50},       /* cache */
};

/* List of all the available modes */
#define TOTAL_MODES 1
static const CELTMode * const static_mode_list[TOTAL_MODES] = {
    &mode48000_960_120,
};
