@echo off
setlocal enabledelayedexpansion

:: Batch script to gzip compress files individually using 7-Zip
:: Copy pfodWeb_src to data, gzip files there, delete non-gz files

:: Get the directory where this script is located
set "SCRIPT_DIR=%~dp0"
cd /d "%SCRIPT_DIR%"

:: Define paths relative to script directory
set "DATA_DIR=..\data"

echo Starting individual file compression with 7-Zip...
echo Script directory: %SCRIPT_DIR%
echo Data directory: %DATA_DIR%
echo.

:: Create ../data directory if it doesn't exist
if not exist "%DATA_DIR%" (
    echo Creating %DATA_DIR% directory...
    mkdir "%DATA_DIR%"
    echo.
)

:: Check if 7z.exe is available in PATH
where 7z.exe >nul 2>&1
if %errorlevel% neq 0 (
    echo ERROR: 7z.exe not found in PATH
    echo Please install 7-Zip and ensure it's in your system PATH
    echo Or modify this script to point to the full path of 7z.exe
    pause
    exit /b 1
)

:: Copy source files to data directory
echo Copying source files to %DATA_DIR%...
xcopy . "%DATA_DIR%" /E /I /Y /EXCLUDE:exclude.txt >nul 2>&1

if %errorlevel% neq 0 (
    echo Copying with full options...
    xcopy . "%DATA_DIR%" /E /I /Y >nul 2>&1
)

:: Delete unnecessary files from data directory
echo Removing unnecessary files...
if exist "%DATA_DIR%\build-bundle.js" del "%DATA_DIR%\build-bundle.js"
if exist "%DATA_DIR%\build_data.sh" del "%DATA_DIR%\build_data.sh"
if exist "%DATA_DIR%\build_data.bat" del "%DATA_DIR%\build_data.bat"
if exist "%DATA_DIR%\.git" rmdir /s /q "%DATA_DIR%\.git" >nul 2>&1

echo Copy complete!
echo.

:: Navigate to data directory and compress all files
cd /d "%DATA_DIR%"

echo Compressing files in %DATA_DIR%...
set /a count=0

:: Compress all .js and .html files recursively
for /r . %%f in (*.js *.html *.ico) do (
    :: Skip build and script files
    if /i not "%%~nf"=="build-bundle.js" (
        if /i not "%%~nf"=="build_data.sh" (
            if /i not "%%~nf"=="build_data.bat" (
                echo   Compressing: %%f

                :: Use 7-Zip to create gzip compressed file
                :: -tgzip specifies gzip format
                :: -mx9 sets maximum compression level
                7z.exe a -tgzip -mx9 "%%f.gz" "%%f" >nul 2>&1

                if !errorlevel! equ 0 (
                    echo   Success: %%f.gz created
                    set /a count+=1
                ) else (
                    echo   ERROR: Failed to compress %%f
                )
            )
        )
    )
)

echo.
echo Compression complete!
echo Total files processed: !count!
echo.

echo Cleaning up non-compressed files...
set /a cleanup_count=0

:: Delete all non-.gz files
for /r . %%f in (*) do (
    if /i not "%%~xf"==".gz" (
        if /i not "%%~nf"=="data_index.html" (
            :: Skip directories
            if not exist "%%f\" (
                echo   Removing: %%f
                del "%%f" >nul 2>&1
                set /a cleanup_count+=1
            )
        )
    )
)

echo Removed !cleanup_count! non-compressed files
echo.

:: Rename data_index.html.gz to index.html.gz if it exists
if exist "data_index.html.gz" (
    echo Renaming data_index.html.gz to index.html.gz...
    ren "data_index.html.gz" "index.html.gz"
)

echo.
echo Final .gz file structure:
dir /s /b *.gz | find /c ".gz"
echo.

echo Deployment structure ready:
echo   %DATA_DIR%\               - All compressed .js and .html files
echo   %DATA_DIR%\jsfreechart\   - JSFreeChart library files (compressed)
echo.
echo Files are ready for web server deployment with Content-Encoding: gzip header
echo.
pause
