/*
 * Arduino-Http-Requests Library
 * File: HttpWiFiNINA.h
 * 
 * Copyright (c) 2025 Dominik Werner
 * https://github.com/dowerner/Arduino-Http-Requests
 *
 * This file is part of the Arduino-Http-Requests library and is licensed
 * under the MIT License. See LICENSE file for details.
 */

#pragma once

#include <WiFiNINA.h>
#include "Http.h"

/**
 * Used to perform HTTP requests with the following boards:
 *   - Arduino MKR WiFi 1010
 *   - Arduino Uno WiFi Rev2
 *   - Arduino Nano 33 IoT
 *   - Arduino Nano RP2040 Connect
 *   - Any board compatible with the WiFiNINA library
 *
 * This class implements the HTTP client interface using the WiFiNINA driver and WiFiClient.
 */
class HttpWiFiNINA : public Http<WiFiClient>{
public:
    String getLocalIP() override {
        IPAddress ip = WiFi.localIP();
        return String(ip[0]) + String(".") + String(ip[1]) + String(".") + String(ip[2]) + String(".") + String(ip[3]);
    }
};
