#ifndef ARMR_NMV_H
#define ARMR_NMV_H

#include <Arduino.h>   // For delay(), constrain()
#include <Servo.h>
#include <math.h>
#include <string.h>    // For strcmp
#include <stdlib.h>    // For abs

// -------------------
// Global Structs
// -------------------
struct PoseArm {
    float x;
    float y;
    float z;
};

struct GoalArm {
    PoseArm pos;         
    bool goalReached; 
    int goalIndex; 
};

struct Gripper {
    int openAngle;
    int closeAngle;
    Servo servo;
};

struct Joints {
    int j1;          
    int j2;          
    int j3;          
    bool reachable;  
};

/////////////

struct GoalEnc {
    int j1;
    int j2;
    int j3;
    int j4;
    bool goalReached;
    int goalIndex;
};


// -------------------
// Arm Class
// -------------------
class armR_NMV {
public:
    // Constructor
    //armR_NMV(float link1, float link2);
     enum DOF_TYPE {
        DOF_3,
        DOF_4
    };

    // Constructors
    armR_NMV(float link1, float link2);                       // default 3DOF
    armR_NMV(const char* dofType, float link1, float link2); // "3DOF" / "4DOF"

    // Methods
    GoalArm interpolateGoal(PoseArm goals[], int goalCount, unsigned long dwellMs);
    Joints calcIK(float x, float y, float z);
    void moveGripper(Gripper &g, const char* target, unsigned long timeConstMs);
    
    bool isTeachingDone() {
        return teachingDone;
    }
    
    
    ////////////////
    
    
    
     void attach_encoders(int j1, int j2, int j3, int j4) {
        encPin[0] = j1;
        encPin[1] = j2;
        encPin[2] = j3;
        encPin[3] = j4;
    }

    void convert_encoder(int joint, int minVal, int maxVal) {
        if (joint < 1 || joint > 4) return;
        encMin[joint - 1] = minVal;
        encMax[joint - 1] = maxVal;
    }
    
     int readEncoder(int joint) {
        if (joint < 0 || joint > 3) return 0;
        return analogRead(encPin[joint]);
    }
    
    void goalGenerator();
    GoalEnc interpolateGoalEnc(unsigned long dwellMs) ;




private:
    float L1;
    float L2;
    float phase;
    float stepSize;
    DOF_TYPE dof; 
    
    
    // ---------- New variables for teaching/playback ----------
static const int MAX_GOALS = 20;

    int encPin[4];         // encoder pins
    int encMin[4];         // encoder min values
    int encMax[4];         // encoder max values


    GoalEnc goals[MAX_GOALS];
    int goalCount;
    int currentGoal;       // for interpolation
    bool teachingDone;     // true when "ok" received
  
    int encoderToAngle(int enc, int encMin, int encMax, int angleMin, int angleMax);
  
  
  
};

#endif
