#include "armR_NMV.h"

// -------------------
// Constructor
// -------------------
armR_NMV::armR_NMV(float link1, float link2) {
    L1 = link1;
    L2 = link2;
    phase = 0.0;
    stepSize = 0.01;
    
    dof = DOF_3; 
    
    /////////
    
    phase = 0.0;
stepSize = 0.017;
goalCount = 0;
currentGoal = 0;
teachingDone = false;

   
}

armR_NMV::armR_NMV(const char* dofType, float link1, float link2) {
    L1 = link1;
    L2 = link2;
    phase = 0.0;
    stepSize = 0.01;

    if (dofType && strcmp(dofType, "4DOF") == 0) {
        dof = DOF_4;
    } else {
        dof = DOF_3;   // fallback
    }
    
    ////////////////
    
    phase = 0.0;
stepSize = 0.017;
goalCount = 0;
currentGoal = 0;
teachingDone = false;

   
}

// -------------------
// Interpolation function
// -------------------
GoalArm armR_NMV::interpolateGoal(PoseArm goals[], int goalCount, unsigned long dwellMs) {
    static int currentGoal = 0; // remembers across calls
    GoalArm outData;
    outData.goalReached = false;
    outData.pos.x = 0;
    outData.pos.y = 0;
    outData.pos.z = 0;
    outData.goalIndex = currentGoal;

    // Stay at last goal
    if (currentGoal >= goalCount - 1) {
        outData.pos = goals[goalCount - 1];
        return outData;
    }

    int nextGoal = currentGoal + 1;

    // Clamp phase
    float frac = constrain(phase, 0.0, 1.0);

    // Linear interpolation
    outData.pos.x = goals[currentGoal].x + frac * (goals[nextGoal].x - goals[currentGoal].x);
    outData.pos.y = goals[currentGoal].y + frac * (goals[nextGoal].y - goals[currentGoal].y);
    outData.pos.z = goals[currentGoal].z + frac * (goals[nextGoal].z - goals[currentGoal].z);

    phase += stepSize;

    // Reached next goal
    if (phase >= 1.0) {
        phase = 1.0;
        delay(dwellMs);
        phase = 0.0;
        currentGoal++;
        outData.goalReached = true;
        outData.goalIndex = currentGoal;
    }

    return outData;
}

// -------------------
// Inverse Kinematics
// -------------------
Joints armR_NMV::calcIK(float x, float y, float z) {
    Joints joints;

    // Base rotation
    float t1 = atan2(y, x) * 180.0 / PI;

    // Planar distance
    float r = sqrt(x * x + y * y);
    float D = sqrt(r * r + z * z);

    // Reach check
    if (D > (L1 + L2) || D < fabs(L1 - L2)) {
        joints.reachable = false;
        joints.j1 = joints.j2 = joints.j3 = -1;
        return joints;
    }

    // Elbow (elbow-down)
    float t3 = -acos((D * D - L1 * L1 - L2 * L2) / (2 * L1 * L2)) * 180.0 / PI;

    // Shoulder
    float alpha = atan2(z, r) * 180.0 / PI;
    float beta  = acos((L1 * L1 + D * D - L2 * L2) / (2 * L1 * D)) * 180.0 / PI;
    float t2 = alpha + beta;

    // Map to servo angles
    //joints.j1 = 105 + t1;
    //joints.j2 = 180 - t2 + 40;
    //joints.j3 = 180 + t3 - 20;
    
    if (dof == DOF_4) {
        joints.j1 = 105 + t1 - 20;
        joints.j2 = 180 - t2 + 40 - 30;
        joints.j3 = 180 + t3 - 20 + 50;
    } else { // 3DOF
        joints.j1 = 105 + t1;
        joints.j2 = 180 - t2 + 40;
        joints.j3 = 180 + t3 - 20;
    }
    
    
    joints.reachable = true;

    return joints;
}

// -------------------
// Move Gripper
// -------------------
void armR_NMV::moveGripper(Gripper &g, const char* target, unsigned long timeConstMs) {
    int startAngle = g.servo.read();
    int endAngle;

    if (strcmp(target, "open") == 0) {
        endAngle = g.openAngle;
    } else if (strcmp(target, "close") == 0) {
        endAngle = g.closeAngle;
    } else {
        return;
    }

    int stepCount = abs(endAngle - startAngle);
    if (stepCount == 0) return;

    unsigned long delayPerStep = timeConstMs / stepCount;

    if (startAngle < endAngle) {
        for (int a = startAngle; a <= endAngle; a++) {
            g.servo.write(a);
            delay(delayPerStep);
        }
    } else {
        for (int a = startAngle; a >= endAngle; a--) {
            g.servo.write(a);
            delay(delayPerStep);
        }
    }
}

/////////////////////////////


void armR_NMV::goalGenerator() {
        if (!Serial.available()) return;

        String cmd = Serial.readStringUntil('\n');
        cmd.trim();

        if (cmd.equalsIgnoreCase("ok")) {
            teachingDone = true;
            Serial.println("Teaching finished");
            Serial.print("Total goals: ");
            Serial.println(goalCount);
            return;
        }

        if (goalCount >= MAX_GOALS) {
            Serial.println("Max goals reached");
            return;
        }

        bool isNumber = true;
        for (int i = 0; i < cmd.length(); i++)
            if (!isDigit(cmd[i])) isNumber = false;

        if (!isNumber) {
            Serial.println("Invalid command");
            return;
        }

        // store current encoder positions
        goals[goalCount].j1 = readEncoder(0);
        goals[goalCount].j2 = readEncoder(1);
        goals[goalCount].j3 = readEncoder(2);
        goals[goalCount].j4 = readEncoder(3);

        Serial.print("Stored goal ");
        Serial.println(goalCount);
        Serial.print("  -> ");
  Serial.print(goals[goalCount].j1); Serial.print(", ");
  Serial.print(goals[goalCount].j2); Serial.print(", ");
  Serial.print(goals[goalCount].j3); Serial.print(", ");
  Serial.println(goals[goalCount].j4);

        goalCount++;
        while (Serial.available()) Serial.read(); // flush
    }
    
    
    
    
    GoalEnc armR_NMV::interpolateGoalEnc(unsigned long dwellMs) {
    GoalEnc out;
    out.goalReached = false;
    
    // Clamp currentGoal to last valid index
    if (currentGoal >= goalCount) currentGoal = goalCount - 1;
    out.goalIndex = currentGoal;

    if (goalCount < 1) return out;

    // Last goal: map encoder values to servo angles
    if (currentGoal >= goalCount - 1) {
        out.j1 = encoderToAngle(goals[goalCount - 1].j1, encMin[0], encMax[0], 90, 150);
        out.j2 = encoderToAngle(goals[goalCount - 1].j2, encMin[1], encMax[1], 90, 150);
        out.j3 = encoderToAngle(goals[goalCount - 1].j3, encMin[2], encMax[2], 90, 150);
        out.j4 = encoderToAngle(goals[goalCount - 1].j4, encMin[3], encMax[3], 90, 150);
        return out; // never increment currentGoal past last index
    }

    // Interpolate between currentGoal and nextGoal
    int nextGoal = currentGoal + 1;
    float frac = constrain(phase, 0.0, 1.0);

    int enc[4];
    enc[0] = goals[currentGoal].j1 + frac * (goals[nextGoal].j1 - goals[currentGoal].j1);
    enc[1] = goals[currentGoal].j2 + frac * (goals[nextGoal].j2 - goals[currentGoal].j2);
    enc[2] = goals[currentGoal].j3 + frac * (goals[nextGoal].j3 - goals[currentGoal].j3);
    enc[3] = goals[currentGoal].j4 + frac * (goals[nextGoal].j4 - goals[currentGoal].j4);

    out.j1 = encoderToAngle(enc[0], encMin[0], encMax[0], 90, 150);
    out.j2 = encoderToAngle(enc[1], encMin[1], encMax[1], 90, 150);
    out.j3 = encoderToAngle(enc[2], encMin[2], encMax[2], 90, 150);
    out.j4 = encoderToAngle(enc[3], encMin[3], encMax[3], 90, 150);

    phase += stepSize;

    if (phase >= 1.0) {
        phase = 0.0;
        delay(dwellMs);
        currentGoal++;       // safe because next call will clamp to goalCount - 1
        out.goalReached = true;
        out.goalIndex = currentGoal;
    }

    return out;
}

    
    
 int armR_NMV::encoderToAngle(int enc, int encMinVal, int encMaxVal, int angleMin, int angleMax) {
        float m = float(angleMax - angleMin) / float(encMaxVal - encMinVal);
        float b = angleMin - m * encMinVal;
        return constrain(int(m * enc + b), 0, 180);
    }   
    
    
    
    

