#ifndef SPIDERBOT_NMV_H
#define SPIDERBOT_NMV_H

#include <Arduino.h>
#include <Servo.h>

#define MAX_LEGS 4
#define MAX_POINTS 10   // increased to support more points

struct LegXYZ {
  int leg;
  float X;
  float Y;
  float Z;
};

struct LegIK {
  float J1;
  float J2;
};

enum LegName {
    LEG_FL = 0, // Front Left
    LEG_FR = 1, // Front Right
    LEG_BL = 2, // Back Left
    LEG_BR = 3  // Back Right
};


class SpiderBot_NMV {
  public:
    SpiderBot_NMV();  // Constructor

    // --- Setup ---
   void attachLeg(LegName leg, int servo1Pin, int servo2Pin);

    // --- Gait settings (per leg) ---
    void setGaitPoints(int legIndex, float X[], float Y[], float Z[], int pointsCount);

    // --- Apply gait to ALL legs ---
    //void setGaitPoints(float X[], float Y[], float Z[], int pointsCount = 4);
    void setGaitPoints(LegName leg, float X[], float Y[], float Z[], int pointsCount);


    void setLegSequence(int sequence[], int len);
    //void setSpeed(float speed);
    // Add this in SpiderBot_NMV.h
    void setCycleTime(float cycleTimeMs);


    // --- Phase control ---
    void setPhaseOffset(LegName leg, float offset);

    // --- Run ---
    //LegXYZ run();
    // New: run fills an array of LegXYZ for all legs
    void run(LegXYZ outLegs[MAX_LEGS]);
    LegXYZ runLeg(LegName leg); 


    // --- IK calculation ---
    LegIK calcIK(float X, float Y, float Z);

    // --- Update servo for a leg ---
    void updateLeg(const LegIK &ik, int leg);

  private:
    Servo legServo1[MAX_LEGS];
    Servo legServo2[MAX_LEGS];
    Servo legServo3[MAX_LEGS];

    float gaitX[MAX_LEGS][MAX_POINTS];
    float gaitY[MAX_LEGS][MAX_POINTS];
    float gaitZ[MAX_LEGS][MAX_POINTS];
    int gaitPointsCount[MAX_LEGS];

    int legSequence[MAX_LEGS];
    int sequenceLen;
    float moveSpeed;

    unsigned long lastUpdate;
    float phase[MAX_LEGS];
    float phaseOffset[MAX_LEGS];

    LegXYZ lastOutput;  // store last run() output
};

#endif

