#ifndef QUADCOPTER_NMV_H
#define QUADCOPTER_NMV_H

#include <Arduino.h>
#include <ServoTimer2.h>
#include "I2Cdev.h"
#include "MPU6050_6Axis_MotionApps20.h"
#include <Wire.h>

enum MotorID { FL = 0, FR = 1, BR = 2, BL = 3 };

struct IMUData {
    float yaw;
    float pitch;
    float roll;
};

struct CommandData {
    float speed;
   float target_pitch;
    float target_roll;
};


class Quadcopter_NMV {
private:
    // Motor objects
    //ServoTimer2Class motors[4];
    ServoTimer2 motors[4];

    // Motor pins
    int motorPins[4];

    // Motor min/max
    int minSpeed[4];
    int maxSpeed[4];

    // Motor mixing (pitch, roll, yaw, trim)
    float motorMix[4][4];

    // Default trims
    float motorTrim[4] = {10, 12, -6, 15};

    // PID parameters [kp, kd]
    float pidPitch[2], pidRoll[2], pidYaw[2];

    // PID state
    //float prevErrorPitch = 0, prevErrorRoll = 0, prevErrorYaw = 0;
    unsigned long lastTime = 0;
    
    float prevErrorPitch = 0, prevErrorRoll = 0, prevErrorYaw = 0;
    unsigned long lastTimePitch = 0, lastTimeRoll = 0, lastTimeYaw = 0;
    
//////////    
    // Movement flags & timers
///*
    // Movement flags & timers
    bool moveX = false;
    bool moveY = false;
    bool moveZ = false;

    unsigned long startX = 0, startY = 0, startZ = 0;
    unsigned long durX = 0, durY = 0, durZ = 0;

    // Throttle
    float hover_throttle = 1290;          // base hover
    float hover_lift = 20;                // throttle added for Z movement
    float target_throttle_manual = 0;     // manual offset for PID
    int throttle_ramp_target = 0;         // ramp target for manual throttle

    // Landing
    bool landingActive = false;
    unsigned long landingStart = 0;
    const unsigned long landingDuration = 5000; // 5 sec landing
    int landingStartValue = 0;

    // Tilts
    float startTilt = 12;                  // for X/Y motion
////////////
//*/
    // IMU
    MPU6050 mpu;
    bool dmpReady = false;
    uint8_t fifoBuffer[64];
    Quaternion q;
    VectorFloat gravity;
    float ypr[3];
    
    int lastMotorOutput[4] = {0,0,0,0}; // FL, FR, BR, BL

public:
    Quadcopter_NMV(int pinFL, int pinFR, int pinBR, int pinBL);

    // Motor attach methods
    void attach_motor(MotorID mID, int minS, int maxS);                // default mixing + trim
    void attach_motor(MotorID mID, float mix[4], int minS, int maxS); // custom mix + trim

    // Trim functions
    void setTrim(MotorID mID, float trimValue);
    void setTrims(float trimFL, float trimFR, float trimBR, float trimBL);

    // IMU
    void imu_init();
    IMUData imu_read();

    // PID
    void setPID_pitch(float params[2]);
    void setPID_roll(float params[2]);
    void setPID_yaw(float params[2]);

    void calPID_pitch(float data, float target);
    void calPID_roll(float data, float target);
    void calPID_yaw(float data, float target);

    // Motor control
    void run_motor(MotorID mID, int baseSpeed);
    void run_motors(int baseSpeed);
    void printMotorOutputs();
    void armMotors();
    
    CommandData updateCommands();

    // Serial command
    //void serial_command(float* speed, float* targetPitch, float* targetRoll);
    //CommandData serial_command();

    // Motor mixing outputs
    float pidOutPitch = 0, pidOutRoll = 0, pidOutYaw = 0;
};

#endif

