# DimuthuRobotLib

DimuthuRobotLib is a modular robotics control library for Arduino-based systems.  
It is inspired by **ROS (Robot Operating System)** concepts, but designed specifically for **microcontroller-level robotics**, where full ROS is not practical.

This library is developed to support **hands-on robotics education and research**, with a strong focus on practical learning at **Nagaragiri M.V.** and similar technical institutions.

---

## Why DimuthuRobotLib?

ROS is a powerful framework used in advanced robotics, but it requires:
- Linux-based computers
- High memory and processing power
- Complex setup and dependencies

**DimuthuRobotLib provides a ROS-like structure for Arduino**, allowing students and researchers to apply similar robotics concepts on low-cost hardware.

---

## ROS vs DimuthuRobotLib (Simple Comparison)

| Feature | ROS | DimuthuRobotLib |
|------|-----|-----------------|
| Target Platform | PC / SBC (Linux) | Arduino / Microcontrollers |
| Complexity | High | Low |
| Memory Usage | Large | Very small |
| Nodes & Modules | Yes | Class-based modules |
| Hardware Access | Indirect | Direct (GPIO, PWM, Serial) |
| Learning Curve | Steep | Beginner-friendly |
| Educational Use | University / Research | School & University level |

---

## Supported Robot Types

DimuthuRobotLib currently includes reusable control classes for:

- 🚗 Mobile Robots (Differential Drive)
- 🦾 Robotic Arms
- 🕷 Spider / Legged Robots
- 🚁 Quadcopters (basic control models)

Each robot type is implemented as a **separate class**, similar to ROS nodes, but optimized for Arduino.

---

## Design Philosophy (ROS-Inspired)

DimuthuRobotLib follows key ROS ideas:

- **Modular design** → each robot is a separate module
- **Reusable components** → same logic across robots
- **Clear abstraction** → hardware details hidden inside classes
- **Scalable learning** → Arduino → ROS transition becomes easier

This makes it ideal for students who plan to move from **Arduino-based robotics to full ROS systems** in the future.

---

## Installation

### Using Arduino Library Manager
1. Open Arduino IDE
2. Go to **Tools → Manage Libraries**
3. Search for **DimuthuRobotLib**
4. Click **Install**

### Manual Installation
1. Download the library from GitHub
2. Extract into:

