/*******************************************************************************
 * Size: 23 px
 * Bpp: 1
 * Opts:
 ******************************************************************************/

#ifdef LV_LVGL_H_INCLUDE_SIMPLE
#include "lvgl.h"
#else
#include "lvgl.h"
#endif

#ifndef FONT_SANDBOX
#define FONT_SANDBOX 1
#endif

#if FONT_SANDBOX

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */
    0x0,

    /* U+0021 "!" */
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x7, 0xfc,

    /* U+0022 "\"" */
    0xff, 0xf6, 0xd2, 0x90,

    /* U+0023 "#" */
    0xe, 0x70, 0x39, 0xc0, 0xe7, 0x3, 0x1c, 0xc,
    0x71, 0xff, 0xf7, 0xff, 0xdf, 0xfe, 0x1c, 0xe0,
    0x73, 0x81, 0xce, 0x3f, 0xfe, 0xff, 0xfb, 0xff,
    0xe3, 0x9c, 0xe, 0x70, 0x39, 0xc0, 0xe7, 0x0,

    /* U+0024 "$" */
    0x1c, 0x1f, 0x1f, 0xdc, 0x7e, 0x3f, 0x1f, 0xc1,
    0xe0, 0x78, 0x1e, 0x7, 0x81, 0xe0, 0x78, 0x1f,
    0x8f, 0xc7, 0xe3, 0xbf, 0x9f, 0x83, 0x80,

    /* U+0025 "%" */
    0x0, 0xe7, 0xe, 0xf8, 0xef, 0x9c, 0xf9, 0xc7,
    0x38, 0x3, 0x80, 0x70, 0x7, 0x0, 0xe0, 0xe,
    0x1, 0xc0, 0x1c, 0xe3, 0x9f, 0x39, 0xf7, 0x1f,
    0x70, 0xe7, 0x0,

    /* U+0026 "&" */
    0x3f, 0x1f, 0xcf, 0xf3, 0x80, 0xe0, 0x39, 0xce,
    0x71, 0xff, 0x3f, 0xdf, 0xfe, 0x73, 0x9c, 0xe7,
    0x39, 0xce, 0x73, 0xfc, 0xff, 0x1d, 0xc0,

    /* U+0027 "'" */
    0xff, 0xa8,

    /* U+0028 "(" */
    0x1d, 0xff, 0xf8, 0xe3, 0x8e, 0x38, 0xe3, 0x8e,
    0x38, 0xe3, 0x8e, 0x3f, 0x7c, 0x70,

    /* U+0029 ")" */
    0xe3, 0xef, 0xc7, 0x1c, 0x71, 0xc7, 0x1c, 0x71,
    0xc7, 0x1c, 0x71, 0xff, 0xfb, 0x80,

    /* U+002A "*" */
    0x30, 0xbb, 0xf7, 0xe5, 0xc6, 0x0,

    /* U+002B "+" */
    0x18, 0xc, 0x6, 0x1f, 0xff, 0xf8, 0xc0, 0x60,
    0x30, 0x18, 0x0,

    /* U+002C "," */
    0xff, 0xa8,

    /* U+002D "-" */
    0xff, 0xfc,

    /* U+002E "." */
    0xff, 0x80,

    /* U+002F "/" */
    0x1, 0xc0, 0xe0, 0x38, 0xc, 0x7, 0x1, 0xc0,
    0xe0, 0x38, 0xc, 0x7, 0x1, 0xc0, 0xe0, 0x38,
    0xe, 0x7, 0x1, 0xc0, 0x60, 0x38, 0x0,

    /* U+0030 "0" */
    0x3e, 0x3f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1f, 0x8f,
    0xc7, 0xe3, 0xf1, 0xf8, 0xfc, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0x7f, 0x1f, 0x0,

    /* U+0031 "1" */
    0xff, 0xff, 0xc7, 0x1c, 0x71, 0xc7, 0x1c, 0x71,
    0xc7, 0x1c, 0x71, 0xc7, 0x1c, 0x70,

    /* U+0032 "2" */
    0x3e, 0x3f, 0xbf, 0xfc, 0x7e, 0x38, 0x1c, 0xe,
    0xe, 0xe, 0xf, 0xf, 0x7, 0x7, 0x7, 0x3,
    0x81, 0xff, 0xff, 0xff, 0xc0,

    /* U+0033 "3" */
    0x3e, 0x3f, 0xbf, 0xfc, 0x7e, 0x38, 0x1c, 0xe,
    0x3e, 0x1f, 0xf, 0xc0, 0xe0, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0x7f, 0x1f, 0x0,

    /* U+0034 "4" */
    0x7, 0x80, 0xf0, 0x3e, 0x7, 0xc1, 0xf8, 0x3f,
    0xe, 0xe1, 0xdc, 0x3b, 0x8e, 0x71, 0xce, 0x71,
    0xcf, 0xff, 0xff, 0xff, 0xf8, 0x1c, 0x3, 0x80,
    0x70,

    /* U+0035 "5" */
    0x7f, 0x3f, 0x9f, 0xce, 0xe, 0x7, 0x3, 0xf9,
    0xfe, 0xff, 0x81, 0xc0, 0xe0, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0x7f, 0x1f, 0x0,

    /* U+0036 "6" */
    0x3e, 0x3f, 0xbf, 0xfc, 0x7e, 0x3f, 0x3, 0xf9,
    0xfe, 0xff, 0xf1, 0xf8, 0xfc, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0x7f, 0x1f, 0x0,

    /* U+0037 "7" */
    0xff, 0xff, 0xff, 0xe0, 0x70, 0x78, 0x38, 0x1c,
    0x1e, 0xe, 0x7, 0x3, 0x83, 0xc1, 0xc0, 0xe0,
    0xf0, 0x70, 0x38, 0x1c, 0x0,

    /* U+0038 "8" */
    0x3e, 0x3f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1f, 0x8f,
    0xfe, 0x7f, 0x3f, 0xb8, 0xfc, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0x7f, 0x1f, 0x0,

    /* U+0039 "9" */
    0x3e, 0x3f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1f, 0x8f,
    0xc7, 0xff, 0xbf, 0xcf, 0xe0, 0x70, 0x3f, 0x1f,
    0x8f, 0xff, 0x7f, 0x1f, 0x0,

    /* U+003A ":" */
    0xff, 0x80, 0x0, 0x3, 0xfe,

    /* U+003B ";" */
    0xff, 0x80, 0x0, 0x3, 0xfe, 0xa0,

    /* U+003C "<" */
    0x6, 0x3c, 0xff, 0xcf, 0x1c, 0x3e, 0x1e, 0x1e,
    0xc, 0x8,

    /* U+003D "=" */
    0xff, 0xff, 0x0, 0xff, 0xff,

    /* U+003E ">" */
    0x81, 0xc3, 0xe3, 0xe1, 0xe3, 0xcf, 0xfc, 0xe1,
    0x80, 0x0,

    /* U+003F "?" */
    0x3e, 0x3f, 0xbf, 0xfc, 0x7e, 0x38, 0x1c, 0xe,
    0xe, 0xe, 0xe, 0xf, 0x7, 0x3, 0x80, 0x0,
    0x0, 0x70, 0x38, 0x1c, 0x0,

    /* U+0040 "@" */
    0x3f, 0xf8, 0xff, 0xfb, 0xff, 0xff, 0x0, 0x7e,
    0x0, 0xfc, 0x71, 0xf9, 0xf3, 0xf7, 0xf7, 0xee,
    0xef, 0xdd, 0xdf, 0xbf, 0xbf, 0x3f, 0xfe, 0x3f,
    0xdc, 0x2, 0x38, 0x0, 0x7f, 0xfe, 0x7f, 0xfc,
    0x7f, 0xf0,

    /* U+0041 "A" */
    0xe, 0x3, 0xe0, 0x7c, 0xf, 0x81, 0xb0, 0x36,
    0xe, 0xe1, 0xdc, 0x3b, 0x87, 0x30, 0xc6, 0x38,
    0xe7, 0xfc, 0xff, 0x9f, 0xf3, 0x7, 0xe0, 0xfc,
    0x1c,

    /* U+0042 "B" */
    0xfe, 0x7f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1f, 0x8f,
    0xfe, 0xff, 0x7f, 0xf8, 0xfc, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0xff, 0x7f, 0x0,

    /* U+0043 "C" */
    0x3e, 0x3f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1f, 0x81,
    0xc0, 0xe0, 0x70, 0x38, 0x1c, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0x7f, 0x1f, 0x0,

    /* U+0044 "D" */
    0xfe, 0x7f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1f, 0x8f,
    0xc7, 0xe3, 0xf1, 0xf8, 0xfc, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0xff, 0x7f, 0x0,

    /* U+0045 "E" */
    0xff, 0xff, 0xff, 0xe0, 0xe0, 0xe0, 0xe0, 0xfe,
    0xfe, 0xfe, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xff,
    0xff, 0xff,

    /* U+0046 "F" */
    0xff, 0xff, 0xff, 0xe0, 0xe0, 0xe0, 0xe0, 0xfe,
    0xfe, 0xfe, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
    0xe0, 0xe0,

    /* U+0047 "G" */
    0x3e, 0x3f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1f, 0x81,
    0xcf, 0xe7, 0xf3, 0xf8, 0xfc, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0x7f, 0x1f, 0x0,

    /* U+0048 "H" */
    0xe3, 0xf1, 0xf8, 0xfc, 0x7e, 0x3f, 0x1f, 0x8f,
    0xc7, 0xff, 0xff, 0xff, 0xfc, 0x7e, 0x3f, 0x1f,
    0x8f, 0xc7, 0xe3, 0xf1, 0xc0,

    /* U+0049 "I" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,

    /* U+004A "J" */
    0x3, 0x81, 0xc0, 0xe0, 0x70, 0x38, 0x1c, 0xe,
    0x7, 0x3, 0x81, 0xc0, 0xe0, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0x7f, 0x1f, 0x0,

    /* U+004B "K" */
    0xe1, 0xdc, 0x73, 0x8e, 0x73, 0x8e, 0x71, 0xdc,
    0x3f, 0x87, 0xe0, 0xfc, 0x1f, 0xc3, 0xf8, 0x7f,
    0x8e, 0x71, 0xc7, 0x38, 0xe7, 0xe, 0xe1, 0xdc,
    0x1c,

    /* U+004C "L" */
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xff,
    0xff, 0xff,

    /* U+004D "M" */
    0xf0, 0x7f, 0x83, 0xfc, 0x1f, 0xf1, 0xff, 0x8f,
    0xfc, 0x7f, 0xe3, 0xff, 0xbf, 0xed, 0xbf, 0x6d,
    0xfb, 0xef, 0xce, 0x7e, 0x73, 0xf3, 0x9f, 0x8c,
    0xfc, 0x7, 0xe0, 0x3f, 0x1, 0xc0,

    /* U+004E "N" */
    0xe1, 0xfc, 0x7f, 0x1f, 0xc7, 0xf9, 0xfe, 0x7f,
    0x9f, 0xf7, 0xed, 0xfb, 0x7e, 0xff, 0x9f, 0xe7,
    0xf9, 0xfe, 0x3f, 0x8f, 0xe3, 0xf8, 0x70,

    /* U+004F "O" */
    0x3e, 0x3f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1f, 0x8f,
    0xc7, 0xe3, 0xf1, 0xf8, 0xfc, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0x7f, 0x1f, 0x0,

    /* U+0050 "P" */
    0xfe, 0x7f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1f, 0x8f,
    0xc7, 0xff, 0xff, 0xbf, 0x9c, 0xe, 0x7, 0x3,
    0x81, 0xc0, 0xe0, 0x70, 0x0,

    /* U+0051 "Q" */
    0x3e, 0x3f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1f, 0x8f,
    0xc7, 0xe3, 0xf1, 0xf8, 0xfc, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0x7f, 0x1f, 0x1, 0xe0, 0xf0, 0x38,

    /* U+0052 "R" */
    0xfe, 0x7f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1f, 0x8f,
    0xc7, 0xff, 0xff, 0xbf, 0x9d, 0xce, 0xe7, 0x3b,
    0x9d, 0xce, 0xe7, 0xf1, 0xc0,

    /* U+0053 "S" */
    0x3e, 0x3f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1, 0xc0,
    0xf0, 0x3c, 0xf, 0x1, 0xc0, 0xfe, 0x3f, 0x1f,
    0x8f, 0xff, 0x7f, 0x1f, 0x0,

    /* U+0054 "T" */
    0xff, 0xff, 0xff, 0xfc, 0x70, 0x1c, 0x7, 0x1,
    0xc0, 0x70, 0x1c, 0x7, 0x1, 0xc0, 0x70, 0x1c,
    0x7, 0x1, 0xc0, 0x70, 0x1c, 0x7, 0x0,

    /* U+0055 "U" */
    0xe3, 0xf1, 0xf8, 0xfc, 0x7e, 0x3f, 0x1f, 0x8f,
    0xc7, 0xe3, 0xf1, 0xf8, 0xfc, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0x7f, 0x1f, 0x0,

    /* U+0056 "V" */
    0xe0, 0xfc, 0x1d, 0x83, 0xb0, 0x67, 0x1c, 0xe3,
    0x9c, 0x71, 0x8c, 0x31, 0x87, 0x70, 0xee, 0x1d,
    0xc1, 0xb0, 0x36, 0x7, 0xc0, 0xf8, 0x1f, 0x1,
    0xc0,

    /* U+0057 "W" */
    0xe0, 0xf, 0x80, 0x3e, 0x1, 0xf8, 0xc7, 0xe3,
    0x9d, 0x8e, 0x76, 0x79, 0xd9, 0xe7, 0x77, 0xdd,
    0xdf, 0x77, 0xed, 0x9f, 0xb6, 0x7c, 0xf9, 0xf3,
    0xe7, 0xcf, 0x9f, 0x1e, 0x3c, 0x78, 0xe1, 0xe0,

    /* U+0058 "X" */
    0xe1, 0xee, 0x39, 0xc7, 0x3d, 0xc3, 0xb8, 0x7e,
    0x7, 0xc0, 0xf8, 0xe, 0x1, 0xc0, 0x7c, 0xf,
    0x83, 0xf0, 0x77, 0x1e, 0xe3, 0x8e, 0x71, 0xdc,
    0x1c,

    /* U+0059 "Y" */
    0xe0, 0xee, 0x39, 0xc7, 0x3d, 0xc3, 0xb8, 0x7f,
    0x7, 0xc0, 0xf8, 0xe, 0x1, 0xc0, 0x38, 0x7,
    0x0, 0xe0, 0x1c, 0x3, 0x80, 0x70, 0xe, 0x1,
    0xc0,

    /* U+005A "Z" */
    0xff, 0xff, 0xff, 0xe0, 0x70, 0x70, 0x38, 0x38,
    0x1c, 0x1c, 0xe, 0xe, 0x7, 0x7, 0x3, 0x83,
    0x81, 0xff, 0xff, 0xff, 0xc0,

    /* U+005B "[" */
    0xff, 0xff, 0xce, 0x73, 0x9c, 0xe7, 0x39, 0xce,
    0x73, 0x9c, 0xff, 0xfe,

    /* U+005C "\\" */
    0xe0, 0x18, 0x7, 0x1, 0xc0, 0x38, 0xe, 0x1,
    0xc0, 0x70, 0xc, 0x3, 0x80, 0xe0, 0x1c, 0x7,
    0x0, 0xc0, 0x38, 0x6, 0x1, 0xc0, 0x70,

    /* U+005D "]" */
    0xff, 0xfe, 0x73, 0x9c, 0xe7, 0x39, 0xce, 0x73,
    0x9c, 0xe7, 0xff, 0xfe,

    /* U+005E "^" */
    0x1c, 0xe, 0xf, 0x87, 0xc7, 0x73, 0x9b, 0x8e,

    /* U+005F "_" */
    0xff, 0xff, 0xff, 0xe0,

    /* U+0060 "`" */
    0x63, 0x8c,

    /* U+0061 "a" */
    0xe, 0x3, 0xe0, 0x7c, 0xf, 0x81, 0xb0, 0x36,
    0xe, 0xe1, 0xdc, 0x3b, 0x87, 0x30, 0xc6, 0x38,
    0xe7, 0xfc, 0xff, 0x9f, 0xf3, 0x7, 0xe0, 0xfc,
    0x1c,

    /* U+0062 "b" */
    0xfe, 0x7f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1f, 0x8f,
    0xfe, 0xff, 0x7f, 0xf8, 0xfc, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0xff, 0x7f, 0x0,

    /* U+0063 "c" */
    0x3e, 0x3f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1f, 0x81,
    0xc0, 0xe0, 0x70, 0x38, 0x1c, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0x7f, 0x1f, 0x0,

    /* U+0064 "d" */
    0xfe, 0x7f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1f, 0x8f,
    0xc7, 0xe3, 0xf1, 0xf8, 0xfc, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0xff, 0x7f, 0x0,

    /* U+0065 "e" */
    0xff, 0xff, 0xff, 0xe0, 0xe0, 0xe0, 0xe0, 0xfe,
    0xfe, 0xfe, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xff,
    0xff, 0xff,

    /* U+0066 "f" */
    0xff, 0xff, 0xff, 0xe0, 0xe0, 0xe0, 0xe0, 0xfe,
    0xfe, 0xfe, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
    0xe0, 0xe0,

    /* U+0067 "g" */
    0x3e, 0x3f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1f, 0x81,
    0xcf, 0xe7, 0xf3, 0xf8, 0xfc, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0x7f, 0x1f, 0x0,

    /* U+0068 "h" */
    0xe3, 0xf1, 0xf8, 0xfc, 0x7e, 0x3f, 0x1f, 0x8f,
    0xc7, 0xff, 0xff, 0xff, 0xfc, 0x7e, 0x3f, 0x1f,
    0x8f, 0xc7, 0xe3, 0xf1, 0xc0,

    /* U+0069 "i" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,

    /* U+006A "j" */
    0x3, 0x81, 0xc0, 0xe0, 0x70, 0x38, 0x1c, 0xe,
    0x7, 0x3, 0x81, 0xc0, 0xe0, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0x7f, 0x1f, 0x0,

    /* U+006B "k" */
    0xe1, 0xdc, 0x73, 0x8e, 0x73, 0x8e, 0x71, 0xdc,
    0x3f, 0x87, 0xe0, 0xfc, 0x1f, 0xc3, 0xf8, 0x7f,
    0x8e, 0x71, 0xc7, 0x38, 0xe7, 0xe, 0xe1, 0xdc,
    0x1c,

    /* U+006C "l" */
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xff,
    0xff, 0xff,

    /* U+006D "m" */
    0xf0, 0x7f, 0x83, 0xfc, 0x1f, 0xf1, 0xff, 0x8f,
    0xfc, 0x7f, 0xe3, 0xff, 0xbf, 0xed, 0xbf, 0x6d,
    0xfb, 0xef, 0xce, 0x7e, 0x73, 0xf3, 0x9f, 0x8c,
    0xfc, 0x7, 0xe0, 0x3f, 0x1, 0xc0,

    /* U+006E "n" */
    0xe1, 0xfc, 0x7f, 0x1f, 0xc7, 0xf9, 0xfe, 0x7f,
    0x9f, 0xf7, 0xed, 0xfb, 0x7e, 0xff, 0x9f, 0xe7,
    0xf9, 0xfe, 0x3f, 0x8f, 0xe3, 0xf8, 0x70,

    /* U+006F "o" */
    0x3e, 0x3f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1f, 0x8f,
    0xc7, 0xe3, 0xf1, 0xf8, 0xfc, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0x7f, 0x1f, 0x0,

    /* U+0070 "p" */
    0xfe, 0x7f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1f, 0x8f,
    0xc7, 0xff, 0xff, 0xbf, 0x9c, 0xe, 0x7, 0x3,
    0x81, 0xc0, 0xe0, 0x70, 0x0,

    /* U+0071 "q" */
    0x3e, 0x3f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1f, 0x8f,
    0xc7, 0xe3, 0xf1, 0xf8, 0xfc, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0x7f, 0x1f, 0x1, 0xe0, 0xf0, 0x38,

    /* U+0072 "r" */
    0xfe, 0x7f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1f, 0x8f,
    0xc7, 0xff, 0xff, 0xbf, 0x9d, 0xce, 0xe7, 0x3b,
    0x9d, 0xce, 0xe7, 0xf1, 0xc0,

    /* U+0073 "s" */
    0x3e, 0x3f, 0xbf, 0xfc, 0x7e, 0x3f, 0x1, 0xc0,
    0xf0, 0x3c, 0xf, 0x1, 0xc0, 0xfe, 0x3f, 0x1f,
    0x8f, 0xff, 0x7f, 0x1f, 0x0,

    /* U+0074 "t" */
    0xff, 0xff, 0xff, 0xfc, 0x70, 0x1c, 0x7, 0x1,
    0xc0, 0x70, 0x1c, 0x7, 0x1, 0xc0, 0x70, 0x1c,
    0x7, 0x1, 0xc0, 0x70, 0x1c, 0x7, 0x0,

    /* U+0075 "u" */
    0xe3, 0xf1, 0xf8, 0xfc, 0x7e, 0x3f, 0x1f, 0x8f,
    0xc7, 0xe3, 0xf1, 0xf8, 0xfc, 0x7e, 0x3f, 0x1f,
    0x8f, 0xff, 0x7f, 0x1f, 0x0,

    /* U+0076 "v" */
    0xe0, 0xfc, 0x1d, 0x83, 0xb0, 0x67, 0x1c, 0xe3,
    0x9c, 0x71, 0x8c, 0x31, 0x87, 0x70, 0xee, 0x1d,
    0xc1, 0xb0, 0x36, 0x7, 0xc0, 0xf8, 0x1f, 0x1,
    0xc0,

    /* U+0077 "w" */
    0xe0, 0xf, 0x80, 0x3e, 0x1, 0xf8, 0xc7, 0xe3,
    0x9d, 0x8e, 0x76, 0x79, 0xd9, 0xe7, 0x77, 0xdd,
    0xdf, 0x77, 0xed, 0x9f, 0xb6, 0x7c, 0xf9, 0xf3,
    0xe7, 0xcf, 0x9f, 0x1e, 0x3c, 0x78, 0xe1, 0xe0,

    /* U+0078 "x" */
    0xe1, 0xee, 0x39, 0xc7, 0x3d, 0xc3, 0xb8, 0x7e,
    0x7, 0xc0, 0xf8, 0xe, 0x1, 0xc0, 0x7c, 0xf,
    0x83, 0xf0, 0x77, 0x1e, 0xe3, 0x8e, 0x71, 0xdc,
    0x1c,

    /* U+0079 "y" */
    0xe0, 0xee, 0x39, 0xc7, 0x3d, 0xc3, 0xb8, 0x7f,
    0x7, 0xc0, 0xf8, 0xe, 0x1, 0xc0, 0x38, 0x7,
    0x0, 0xe0, 0x1c, 0x3, 0x80, 0x70, 0xe, 0x1,
    0xc0,

    /* U+007A "z" */
    0xff, 0xff, 0xff, 0xe0, 0x70, 0x70, 0x38, 0x38,
    0x1c, 0x1c, 0xe, 0xe, 0x7, 0x7, 0x3, 0x83,
    0x81, 0xff, 0xff, 0xff, 0xc0,

    /* U+007B "{" */
    0x1c, 0xf3, 0xce, 0x38, 0xe3, 0xbe, 0xe3, 0xe3,
    0x8e, 0x38, 0xe3, 0x8f, 0x3c, 0x70,

    /* U+007C "|" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,

    /* U+007D "}" */
    0xf3, 0xef, 0x8e, 0x38, 0xe3, 0x8f, 0xc, 0xf3,
    0x8e, 0x38, 0xe3, 0xbe, 0xfb, 0xc0,

    /* U+007E "~" */
    0x38, 0x6f, 0xcf, 0xff, 0xe7, 0xec, 0x38};

/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 86, .box_w = 1, .box_h = 1, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1, .adv_w = 74, .box_w = 3, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8, .adv_w = 119, .box_w = 6, .box_h = 5, .ofs_x = 0, .ofs_y = 14},
    {.bitmap_index = 12, .adv_w = 250, .box_w = 14, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 44, .adv_w = 169, .box_w = 9, .box_h = 20, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 67, .adv_w = 226, .box_w = 12, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 94, .adv_w = 178, .box_w = 10, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 117, .adv_w = 64, .box_w = 3, .box_h = 5, .ofs_x = 0, .ofs_y = 14},
    {.bitmap_index = 119, .adv_w = 108, .box_w = 6, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 133, .adv_w = 106, .box_w = 6, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 147, .adv_w = 130, .box_w = 7, .box_h = 6, .ofs_x = 0, .ofs_y = 12},
    {.bitmap_index = 153, .adv_w = 176, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 164, .adv_w = 70, .box_w = 3, .box_h = 5, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 166, .adv_w = 143, .box_w = 7, .box_h = 2, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 168, .adv_w = 72, .box_w = 3, .box_h = 3, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 170, .adv_w = 167, .box_w = 10, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 193, .adv_w = 167, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 214, .adv_w = 114, .box_w = 6, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 228, .adv_w = 162, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 249, .adv_w = 164, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 270, .adv_w = 194, .box_w = 11, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 295, .adv_w = 164, .box_w = 9, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 316, .adv_w = 170, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 337, .adv_w = 171, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 358, .adv_w = 162, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 379, .adv_w = 166, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 400, .adv_w = 74, .box_w = 3, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 405, .adv_w = 81, .box_w = 3, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 411, .adv_w = 129, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 421, .adv_w = 156, .box_w = 8, .box_h = 5, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 426, .adv_w = 126, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 436, .adv_w = 160, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 457, .adv_w = 273, .box_w = 15, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 491, .adv_w = 197, .box_w = 11, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 516, .adv_w = 164, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 537, .adv_w = 170, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 558, .adv_w = 170, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 579, .adv_w = 151, .box_w = 8, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 597, .adv_w = 151, .box_w = 8, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 615, .adv_w = 176, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 636, .adv_w = 174, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 657, .adv_w = 69, .box_w = 3, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 664, .adv_w = 173, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 685, .adv_w = 195, .box_w = 11, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 710, .adv_w = 156, .box_w = 8, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 728, .adv_w = 241, .box_w = 13, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 758, .adv_w = 194, .box_w = 10, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 781, .adv_w = 169, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 802, .adv_w = 163, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 823, .adv_w = 174, .box_w = 9, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 847, .adv_w = 170, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 868, .adv_w = 169, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 889, .adv_w = 194, .box_w = 10, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 912, .adv_w = 173, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 933, .adv_w = 208, .box_w = 11, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 958, .adv_w = 259, .box_w = 14, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 990, .adv_w = 199, .box_w = 11, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1015, .adv_w = 199, .box_w = 11, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1040, .adv_w = 180, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1061, .adv_w = 106, .box_w = 5, .box_h = 19, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1073, .adv_w = 192, .box_w = 10, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1096, .adv_w = 107, .box_w = 5, .box_h = 19, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1108, .adv_w = 176, .box_w = 9, .box_h = 7, .ofs_x = 0, .ofs_y = 12},
    {.bitmap_index = 1116, .adv_w = 176, .box_w = 9, .box_h = 3, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1120, .adv_w = 92, .box_w = 5, .box_h = 3, .ofs_x = -9, .ofs_y = 12},
    {.bitmap_index = 1122, .adv_w = 197, .box_w = 11, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1147, .adv_w = 164, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1168, .adv_w = 170, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1189, .adv_w = 170, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1210, .adv_w = 151, .box_w = 8, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1228, .adv_w = 151, .box_w = 8, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1246, .adv_w = 176, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1267, .adv_w = 174, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1288, .adv_w = 69, .box_w = 3, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1295, .adv_w = 173, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1316, .adv_w = 195, .box_w = 11, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1341, .adv_w = 156, .box_w = 8, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1359, .adv_w = 241, .box_w = 13, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1389, .adv_w = 194, .box_w = 10, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1412, .adv_w = 169, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1433, .adv_w = 163, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1454, .adv_w = 174, .box_w = 9, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1478, .adv_w = 170, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1499, .adv_w = 169, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1520, .adv_w = 194, .box_w = 10, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1543, .adv_w = 173, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1564, .adv_w = 208, .box_w = 11, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1589, .adv_w = 259, .box_w = 14, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1621, .adv_w = 199, .box_w = 11, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1646, .adv_w = 199, .box_w = 11, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1671, .adv_w = 180, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1692, .adv_w = 116, .box_w = 6, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1706, .adv_w = 73, .box_w = 3, .box_h = 19, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1714, .adv_w = 116, .box_w = 6, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1728, .adv_w = 203, .box_w = 11, .box_h = 5, .ofs_x = 0, .ofs_y = 7}};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
    {
        {.range_start = 32, .range_length = 95, .glyph_id_start = 1, .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY}};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

#if LV_VERSION_CHECK(8, 0, 0)
/*Store all the custom data of the font*/
static lv_font_fmt_txt_glyph_cache_t cache;
static const lv_font_fmt_txt_dsc_t font_dsc = {
#else
static lv_font_fmt_txt_dsc_t font_dsc = {
#endif
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = NULL,
    .kern_scale = 0,
    .cmap_num = 1,
    .bpp = 1,
    .kern_classes = 0,
    .bitmap_format = 0,
#if LV_VERSION_CHECK(8, 0, 0)
    .cache = &cache
#endif
};

/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
#if LV_VERSION_CHECK(8, 0, 0)
const lv_font_t font_sandbox = {
#else
lv_font_t font_sandbox = {
#endif
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt, /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt, /*Function pointer to get glyph's bitmap*/
    .line_height = 22,                              /*The maximum line height required by the font*/
    .base_line = 3,                                 /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0) || LVGL_VERSION_MAJOR >= 8
    .underline_position = -2,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if FONT_SANDBOX*/
