#include <ExponentialFit.h>

const size_t TRAIN_SIZE = 42;

double xTrain[TRAIN_SIZE] = {
    0.,         0.10204082, 0.20408163, 0.30612245, 0.40816327, 0.51020408,
    0.6122449,  0.71428571, 0.81632653, 0.91836735, 1.02040816, 1.12244898,
    1.2244898,  1.32653061, 1.42857143, 1.53061224, 1.63265306, 1.73469388,
    1.83673469, 1.93877551, 2.04081633, 2.14285714, 2.24489796, 2.34693878,
    2.44897959, 2.55102041, 2.65306122, 2.75510204, 2.85714286, 2.95918367,
    3.06122449, 3.16326531, 3.26530612, 3.36734694, 3.46938776, 3.57142857,
    3.67346939, 3.7755102,  3.87755102, 3.97959184, 4.08163265, 4.18367347};

double yTrain[TRAIN_SIZE] = {
    3.78862847e+00, 2.72554912e+00, 2.62340914e+00, 1.91079191e-01,
    2.69730953e+00, 2.88176618e+00, 3.75660671e+00, 3.00933973e+00,
    4.79618536e+00, 4.17647905e+00, 2.10507781e+00, 9.89995531e+00,
    1.10616855e+01, 1.59308842e+01, 9.84833426e+00, 8.57306563e+00,
    8.74437992e+00, 3.04970853e+00, 2.24339791e+01, 7.56411327e+00,
    7.67095899e+00, 1.88933892e+01, 4.10614608e+01, 2.94703484e+01,
    1.43881723e+01, 2.12190971e+01, 4.84174301e+01, 3.79502272e+01,
    2.84131490e+01, 4.56935768e+01, 7.92732239e+01, 1.28445705e+02,
    2.73147919e+01, 5.55248932e+01, 5.40922126e+01, 2.11984792e+01,
    6.08956865e+01, 6.17847456e+01, 2.21192282e+02, 1.47960116e+02,
    3.33769073e+01, 2.62313248e+02};

const size_t TEST_SIZE = 8;

double xTest[TEST_SIZE] = {4.28571429, 4.3877551,  4.48979592, 4.59183673,
                           4.69387755, 4.79591837, 4.89795918, 5.};

double yTest[TEST_SIZE] = {182.23662273, 31.85561138,  194.68978785,
                           219.03562021, 195.49359458, 394.15713882,
                           53.92911297,  420.93386684};

void setup() {
  Serial.begin(9600);

  //  Fitting y = a * b ^ x

  // Model
  ExponentialFit<double, double> ef;
  ef.fit(xTrain, yTrain, TRAIN_SIZE);

  // Coefficients
  Serial.print("a: ");
  Serial.print(ef.a());
  Serial.print("\nb: ");
  Serial.print(ef.b());

  // Predict
  Serial.print("\nPrediction of 4.28571429: ");
  Serial.print(ef.predict(4.28571429));

  // Predict many
  double yPred[TEST_SIZE];
  ef.predictMany(xTest, yPred, TEST_SIZE);

  // Evaluate
  Serial.print("\nMAE(Mean Absolute Error): ");
  Serial.print(ef.MAE(yTest, yPred, TEST_SIZE));
}

void loop() {}
