#include <Arduino.h>
#include <unity.h>
#include "PT7C4339-RTC.h"

#define SDA_PIN 47 //Change this to the correct pin number for your board or disregard it if you are using the default SDA pin
#define SCL_PIN 48 //Change this to the correct pin number for your board or disregard it if you are using the default SCL pin

PT7C4339 rtc( &Wire, SDA_PIN, SCL_PIN );

void test_times_all()
{

    int32_t success = 0;
    int32_t fail = 0;
    int32_t totalTimes = 24 * 60 * 60;

    for( uint8_t hour = 0; hour < 24; hour++ )
    {
    
        for( uint8_t minute = 0; minute < 60; minute++ )
        {

            for( uint8_t second = 0; second < 60; second++ )
            {
            
                PT7C4339_Time setTime = { hour, minute, second };
                bool setSuccess = rtc.setTime( setTime );
                PT7C4339_Time getTime = rtc.getTime();

                bool timeOk = setSuccess && getTime.hour == setTime.hour && getTime.minute == setTime.minute && getTime.second == setTime.second;
                if( timeOk ) success++;
                else fail++;

            }

        }

    }

    TEST_ASSERT_EQUAL_INT32_MESSAGE( 0, fail, "Some time tests failed" );
    TEST_ASSERT_EQUAL_INT32( totalTimes, success + fail );

}

void test_times_random()
{
    
    int32_t success = 0;
    int32_t fail = 0;
    int32_t totalTimes = 5000;

    for( uint16_t i = 1; i <= totalTimes; i++ )
    {
    
        uint8_t hour = random( 1, 24 );
        uint8_t minute = random( 1, 60 );
        uint8_t second = random( 1, 60 );
        
        PT7C4339_Time wantTime = { hour, minute, second };
        bool setSuccess = rtc.setTime( wantTime );
        PT7C4339_Time gotTime = rtc.getTime();
        
        bool dateOk = setSuccess && gotTime.hour == wantTime.hour && gotTime.minute == wantTime.minute && gotTime.second == wantTime.second;
        if( dateOk ) success++;
        else fail++;

    }

    TEST_ASSERT_EQUAL_INT32_MESSAGE( 0, fail, "Incorrect number of random time tests failed" );
    TEST_ASSERT_EQUAL_INT32( totalTimes, success + fail );

}

void setUp( void )
{
    
    rtc.reset();
    rtc.begin();

}

void tearDown(void)
{

    rtc.reset();

}

void setup() 
{

    delay( 2000 );
    
    UNITY_BEGIN();
    
    RUN_TEST( test_times_all );
    RUN_TEST( test_times_random );
    
    UNITY_END();

}

void loop()
{



}