#pragma once

#include "roo_backport/string_view.h"
#include "roo_display/color/color.h"
#include "roo_display/font/font.h"
#include "roo_windows/core/basic_widget.h"
#include "roo_windows/core/gravity.h"
#include "roo_windows/core/panel.h"

namespace roo_windows {

class TextLabel : public BasicWidget {
 public:
  TextLabel(const Environment& env, std::string value,
            const roo_display::Font& font);

  TextLabel(const Environment& env, std::string value,
            const roo_display::Font& font, Gravity gravity);

  TextLabel(const Environment& env, std::string value,
            const roo_display::Font& font, roo_display::Color color,
            Gravity gravity);

  void paint(const Canvas& canvas) const override;

  Dimensions getSuggestedMinimumDimensions() const override;

  const std::string& content() const { return value_; }

  const std::string& text() const { return value_; }

  void setText(std::string value);

  void setText(const char* value);

  void setText(roo::string_view value);

  void setTextf(const char* format, ...);

  void setTextvf(const char* format, va_list arg);

  void clearText();

  const roo_display::Font& font() const { return font_; }

 private:
  std::string value_;
  const roo_display::Font& font_;
  roo_display::Color color_;
  Gravity gravity_;
};

class StringViewLabel : public BasicWidget {
 public:
  StringViewLabel(const Environment& env, roo::string_view value,
                  const roo_display::Font& font);

  StringViewLabel(const Environment& env, roo::string_view value,
                  const roo_display::Font& font, Gravity gravity);

  StringViewLabel(const Environment& env, roo::string_view value,
                  const roo_display::Font& font, roo_display::Color color,
                  Gravity gravity);

  void paint(const Canvas& canvas) const override;

  Dimensions getSuggestedMinimumDimensions() const override;

  roo::string_view content() const { return value_; }

  roo::string_view text() const { return value_; }

  void setText(roo::string_view value);

  void clearText();

  const roo_display::Font& font() const { return font_; }

 private:
  roo::string_view value_;
  const roo_display::Font& font_;
  roo_display::Color color_;
  Gravity gravity_;
};

}  // namespace roo_windows
