#include "24.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-Regular (Noto Sans Regular)
// Generated on Thu Mar 30 23:43:10 CEST 2023
static const uint8_t font_NotoSans_Regular_24_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x07, 0x9D,
  0xFB, 0xFB, 0x1B, 0x18, 0x12, 0xFA, 0x06, 0x03, 0x1C, 0x07, 0x06, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x01, 0x01, 0x04, 0x11, 0x06, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x01, 0x0C, 0x08, 0x11, 0x0A, 0x00, 0x21, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x0E, 0x11, 0x10, 0x00, 0x3D, // "#" (U+0023)
  0x00, 0x24, 0x01, 0xFF, 0x0C, 0x12, 0x0E, 0x00, 0x9C, // "$" (U+0024)
  0x00, 0x25, 0x01, 0x01, 0x12, 0x11, 0x14, 0x00, 0xF7, // "%" (U+0025)
  0x00, 0x26, 0x01, 0x01, 0x11, 0x11, 0x12, 0x01, 0x86, // "&" (U+0026)
  0x00, 0x27, 0x01, 0x0C, 0x03, 0x11, 0x05, 0x01, 0xFD, // "'" (U+0027)
  0x00, 0x28, 0x01, 0xFD, 0x06, 0x11, 0x07, 0x02, 0x08, // "(" (U+0028)
  0x00, 0x29, 0x00, 0xFD, 0x06, 0x11, 0x07, 0x02, 0x45, // ")" (U+0029)
  0x00, 0x2A, 0x01, 0x08, 0x0C, 0x12, 0x0D, 0x02, 0x81, // "*" (U+002A)
  0x00, 0x2B, 0x01, 0x04, 0x0C, 0x0F, 0x0E, 0x02, 0xB9, // "+" (U+002B)
  0x00, 0x2C, 0x01, 0xFE, 0x04, 0x03, 0x06, 0x02, 0xDC, // "," (U+002C)
  0x00, 0x2D, 0x01, 0x06, 0x06, 0x07, 0x08, 0x02, 0xEA, // "-" (U+002D)
  0x00, 0x2E, 0x01, 0x01, 0x04, 0x03, 0x06, 0x02, 0xEF, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x08, 0x11, 0x09, 0x02, 0xF7, // "/" (U+002F)
  0x00, 0x30, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x03, 0x2B, // "0" (U+0030)
  0x00, 0x31, 0x02, 0x01, 0x08, 0x11, 0x0E, 0x03, 0x7F, // "1" (U+0031)
  0x00, 0x32, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x03, 0xB6, // "2" (U+0032)
  0x00, 0x33, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x03, 0xFD, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x0D, 0x11, 0x0E, 0x04, 0x4C, // "4" (U+0034)
  0x00, 0x35, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x04, 0x9F, // "5" (U+0035)
  0x00, 0x36, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x04, 0xE8, // "6" (U+0036)
  0x00, 0x37, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x05, 0x3F, // "7" (U+0037)
  0x00, 0x38, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x05, 0x7E, // "8" (U+0038)
  0x00, 0x39, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x05, 0xDE, // "9" (U+0039)
  0x00, 0x3A, 0x01, 0x01, 0x04, 0x0D, 0x06, 0x06, 0x34, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0xFE, 0x04, 0x0D, 0x06, 0x06, 0x45, // ";" (U+003B)
  0x00, 0x3C, 0x01, 0x04, 0x0C, 0x0F, 0x0E, 0x06, 0x61, // "<" (U+003C)
  0x00, 0x3D, 0x01, 0x06, 0x0C, 0x0C, 0x0E, 0x06, 0x98, // "=" (U+003D)
  0x00, 0x3E, 0x01, 0x04, 0x0C, 0x0F, 0x0E, 0x06, 0xA9, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x09, 0x11, 0x0A, 0x06, 0xDA, // "?" (U+003F)
  0x00, 0x40, 0x01, 0xFF, 0x14, 0x11, 0x16, 0x07, 0x15, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x0F, 0x11, 0x0F, 0x07, 0xBA, // "A" (U+0041)
  0x00, 0x42, 0x02, 0x01, 0x0E, 0x11, 0x10, 0x08, 0x14, // "B" (U+0042)
  0x00, 0x43, 0x01, 0x01, 0x0E, 0x11, 0x0F, 0x08, 0x73, // "C" (U+0043)
  0x00, 0x44, 0x02, 0x01, 0x0F, 0x11, 0x12, 0x08, 0xC1, // "D" (U+0044)
  0x00, 0x45, 0x02, 0x01, 0x0B, 0x11, 0x0D, 0x09, 0x1F, // "E" (U+0045)
  0x00, 0x46, 0x02, 0x01, 0x0B, 0x11, 0x0C, 0x09, 0x58, // "F" (U+0046)
  0x00, 0x47, 0x01, 0x01, 0x0F, 0x11, 0x11, 0x09, 0x8E, // "G" (U+0047)
  0x00, 0x48, 0x02, 0x01, 0x0F, 0x11, 0x12, 0x09, 0xED, // "H" (U+0048)
  0x00, 0x49, 0x01, 0x01, 0x07, 0x11, 0x08, 0x0A, 0x42, // "I" (U+0049)
  0x00, 0x4A, 0xFE, 0xFC, 0x04, 0x11, 0x07, 0x0A, 0x69, // "J" (U+004A)
  0x00, 0x4B, 0x02, 0x01, 0x0E, 0x11, 0x0F, 0x0A, 0xAD, // "K" (U+004B)
  0x00, 0x4C, 0x02, 0x01, 0x0B, 0x11, 0x0D, 0x0B, 0x0E, // "L" (U+004C)
  0x00, 0x4D, 0x02, 0x01, 0x13, 0x11, 0x16, 0x0B, 0x42, // "M" (U+004D)
  0x00, 0x4E, 0x02, 0x01, 0x0F, 0x11, 0x12, 0x0B, 0xCE, // "N" (U+004E)
  0x00, 0x4F, 0x01, 0x01, 0x11, 0x11, 0x13, 0x0C, 0x36, // "O" (U+004F)
  0x00, 0x50, 0x02, 0x01, 0x0D, 0x11, 0x0F, 0x0C, 0x9E, // "P" (U+0050)
  0x00, 0x51, 0x01, 0xFD, 0x11, 0x11, 0x13, 0x0C, 0xEB, // "Q" (U+0051)
  0x00, 0x52, 0x02, 0x01, 0x0E, 0x11, 0x0F, 0x0D, 0x63, // "R" (U+0052)
  0x00, 0x53, 0x01, 0x01, 0x0B, 0x11, 0x0D, 0x0D, 0xC3, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x0D, 0x11, 0x0D, 0x0E, 0x0F, // "T" (U+0054)
  0x00, 0x55, 0x02, 0x01, 0x0F, 0x11, 0x12, 0x0E, 0x4D, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x0E, 0x11, 0x0E, 0x0E, 0xA8, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x15, 0x11, 0x16, 0x0F, 0x05, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x0D, 0x11, 0x0E, 0x0F, 0xA0, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x0D, 0x11, 0x0E, 0x0F, 0xFE, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x0C, 0x11, 0x0E, 0x10, 0x4D, // "Z" (U+005A)
  0x00, 0x5B, 0x01, 0xFD, 0x07, 0x11, 0x08, 0x10, 0x90, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x08, 0x11, 0x09, 0x10, 0xBF, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0xFD, 0x05, 0x11, 0x08, 0x10, 0xF2, // "]" (U+005D)
  0x00, 0x5E, 0x01, 0x07, 0x0C, 0x11, 0x0E, 0x11, 0x1E, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFD, 0x0A, 0xFE, 0x0B, 0x11, 0x53, // "_" (U+005F)
  0x00, 0x60, 0x01, 0x0F, 0x05, 0x12, 0x07, 0x11, 0x58, // "`" (U+0060)
  0x00, 0x61, 0x01, 0x01, 0x0B, 0x0D, 0x0D, 0x11, 0x64, // "a" (U+0061)
  0x00, 0x62, 0x02, 0x01, 0x0D, 0x12, 0x0F, 0x11, 0xA7, // "b" (U+0062)
  0x00, 0x63, 0x01, 0x01, 0x0A, 0x0D, 0x0C, 0x11, 0xFE, // "c" (U+0063)
  0x00, 0x64, 0x01, 0x01, 0x0C, 0x12, 0x0F, 0x12, 0x33, // "d" (U+0064)
  0x00, 0x65, 0x01, 0x01, 0x0C, 0x0D, 0x0E, 0x12, 0x8D, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x09, 0x12, 0x08, 0x12, 0xCC, // "f" (U+0066)
  0x00, 0x67, 0x01, 0xFB, 0x0C, 0x0D, 0x0F, 0x13, 0x08, // "g" (U+0067)
  0x00, 0x68, 0x02, 0x01, 0x0C, 0x12, 0x0F, 0x13, 0x6E, // "h" (U+0068)
  0x00, 0x69, 0x01, 0x01, 0x04, 0x12, 0x06, 0x13, 0xBF, // "i" (U+0069)
  0x00, 0x6A, 0xFE, 0xFB, 0x04, 0x12, 0x06, 0x13, 0xE2, // "j" (U+006A)
  0x00, 0x6B, 0x02, 0x01, 0x0C, 0x12, 0x0D, 0x14, 0x25, // "k" (U+006B)
  0x00, 0x6C, 0x02, 0x01, 0x04, 0x12, 0x06, 0x14, 0x7E, // "l" (U+006C)
  0x00, 0x6D, 0x02, 0x01, 0x14, 0x0D, 0x16, 0x14, 0x9B, // "m" (U+006D)
  0x00, 0x6E, 0x02, 0x01, 0x0C, 0x0D, 0x0F, 0x15, 0x05, // "n" (U+006E)
  0x00, 0x6F, 0x01, 0x01, 0x0D, 0x0D, 0x0F, 0x15, 0x45, // "o" (U+006F)
  0x00, 0x70, 0x02, 0xFB, 0x0D, 0x0D, 0x0F, 0x15, 0x8D, // "p" (U+0070)
  0x00, 0x71, 0x01, 0xFB, 0x0C, 0x0D, 0x0F, 0x15, 0xE7, // "q" (U+0071)
  0x00, 0x72, 0x02, 0x01, 0x09, 0x0D, 0x0A, 0x16, 0x44, // "r" (U+0072)
  0x00, 0x73, 0x01, 0x01, 0x0A, 0x0D, 0x0C, 0x16, 0x6F, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x08, 0x10, 0x09, 0x16, 0xA7, // "t" (U+0074)
  0x00, 0x75, 0x01, 0x01, 0x0C, 0x0D, 0x0F, 0x16, 0xDD, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x0B, 0x0D, 0x0C, 0x17, 0x1B, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x12, 0x0D, 0x13, 0x17, 0x5B, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x0B, 0x0D, 0x0D, 0x17, 0xCC, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFB, 0x0C, 0x0D, 0x0C, 0x18, 0x0D, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x18, 0x68, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFD, 0x08, 0x11, 0x09, 0x18, 0x97, // "{" (U+007B)
  0x00, 0x7C, 0x05, 0xFB, 0x07, 0x12, 0x0D, 0x18, 0xDD, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0xFD, 0x08, 0x11, 0x09, 0x19, 0x03, // "}" (U+007D)
  0x00, 0x7E, 0x01, 0x08, 0x0C, 0x0A, 0x0E, 0x19, 0x49, // "~" (U+007E)
  0x00, 0xA1, 0x01, 0xFD, 0x04, 0x0D, 0x06, 0x19, 0x5C, // "¡" (U+00A1)
  0x00, 0xA2, 0x02, 0x01, 0x0B, 0x11, 0x0E, 0x19, 0x7F, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x0C, 0x11, 0x0E, 0x19, 0xBD, // "£" (U+00A3)
  0x00, 0xA4, 0x01, 0x03, 0x0C, 0x0E, 0x0E, 0x1A, 0x05, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x0D, 0x11, 0x0E, 0x1A, 0x47, // "¥" (U+00A5)
  0x00, 0xA6, 0x05, 0xFB, 0x07, 0x12, 0x0D, 0x1A, 0x9B, // "¦" (U+00A6)
  0x00, 0xA7, 0x01, 0x01, 0x0A, 0x12, 0x0C, 0x1A, 0xBB, // "§" (U+00A7)
  0x00, 0xA8, 0x03, 0x10, 0x0A, 0x11, 0x0E, 0x1B, 0x10, // "¨" (U+00A8)
  0x00, 0xA9, 0x01, 0x01, 0x12, 0x12, 0x14, 0x1B, 0x1A, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x0B, 0x07, 0x11, 0x09, 0x1B, 0xAA, // "ª" (U+00AA)
  0x00, 0xAB, 0x01, 0x02, 0x0B, 0x0C, 0x0C, 0x1B, 0xC9, // "«" (U+00AB)
  0x00, 0xAC, 0x01, 0x04, 0x0C, 0x0A, 0x0E, 0x1C, 0x06, // "¬" (U+00AC)
  0x00, 0xAE, 0x01, 0x01, 0x12, 0x12, 0x14, 0x1C, 0x1F, // "®" (U+00AE)
  0x00, 0xAF, 0xFF, 0x13, 0x0C, 0x14, 0x0C, 0x1C, 0xB7, // "¯" (U+00AF)
  0x00, 0xB0, 0x01, 0x0B, 0x08, 0x12, 0x0A, 0x1C, 0xBE, // "°" (U+00B0)
  0x00, 0xB1, 0x01, 0x01, 0x0C, 0x0E, 0x0E, 0x1C, 0xDF, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x0A, 0x07, 0x15, 0x08, 0x1D, 0x09, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x0A, 0x07, 0x15, 0x08, 0x1D, 0x33, // "³" (U+00B3)
  0x00, 0xB4, 0x01, 0x0F, 0x05, 0x12, 0x07, 0x1D, 0x5F, // "´" (U+00B4)
  0x00, 0xB5, 0x02, 0xFB, 0x0C, 0x0D, 0x0F, 0x1D, 0x6A, // "µ" (U+00B5)
  0x00, 0xB6, 0x01, 0xFD, 0x0D, 0x12, 0x10, 0x1D, 0xBD, // "¶" (U+00B6)
  0x00, 0xB7, 0x01, 0x08, 0x04, 0x0A, 0x06, 0x1E, 0x2A, // "·" (U+00B7)
  0x00, 0xB8, 0x00, 0xFB, 0x04, 0x01, 0x05, 0x1E, 0x32, // "¸" (U+00B8)
  0x00, 0xB9, 0x01, 0x0B, 0x05, 0x14, 0x08, 0x1E, 0x46, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x09, 0x08, 0x11, 0x09, 0x1E, 0x61, // "º" (U+00BA)
  0x00, 0xBB, 0x01, 0x02, 0x0B, 0x0C, 0x0C, 0x1E, 0x86, // "»" (U+00BB)
  0x00, 0xBC, 0x01, 0x01, 0x11, 0x11, 0x12, 0x1E, 0xC1, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x11, 0x11, 0x13, 0x1F, 0x38, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x12, 0x12, 0x13, 0x1F, 0xAF, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFD, 0x09, 0x0D, 0x0A, 0x20, 0x3A, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x0F, 0x16, 0x0F, 0x20, 0x75, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x0F, 0x16, 0x0F, 0x20, 0xDE, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x0F, 0x16, 0x0F, 0x21, 0x48, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x0F, 0x15, 0x0F, 0x21, 0xB8, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x0F, 0x15, 0x0F, 0x22, 0x25, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x0F, 0x15, 0x0F, 0x22, 0x8D, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x13, 0x11, 0x15, 0x22, 0xF9, // "Æ" (U+00C6)
  0x00, 0xC7, 0x01, 0xFB, 0x0E, 0x11, 0x0F, 0x23, 0x63, // "Ç" (U+00C7)
  0x00, 0xC8, 0x02, 0x01, 0x0B, 0x16, 0x0D, 0x23, 0xC7, // "È" (U+00C8)
  0x00, 0xC9, 0x02, 0x01, 0x0B, 0x16, 0x0D, 0x24, 0x0E, // "É" (U+00C9)
  0x00, 0xCA, 0x02, 0x01, 0x0B, 0x16, 0x0D, 0x24, 0x55, // "Ê" (U+00CA)
  0x00, 0xCB, 0x02, 0x01, 0x0B, 0x15, 0x0D, 0x24, 0xA2, // "Ë" (U+00CB)
  0x00, 0xCC, 0x01, 0x01, 0x07, 0x16, 0x08, 0x24, 0xE8, // "Ì" (U+00CC)
  0x00, 0xCD, 0x01, 0x01, 0x07, 0x16, 0x08, 0x25, 0x1C, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x07, 0x16, 0x08, 0x25, 0x51, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x07, 0x15, 0x08, 0x25, 0x8B, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x0F, 0x11, 0x12, 0x25, 0xBE, // "Ð" (U+00D0)
  0x00, 0xD1, 0x02, 0x01, 0x0F, 0x15, 0x12, 0x26, 0x2A, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x01, 0x01, 0x11, 0x16, 0x13, 0x26, 0xA5, // "Ò" (U+00D2)
  0x00, 0xD3, 0x01, 0x01, 0x11, 0x16, 0x13, 0x27, 0x1D, // "Ó" (U+00D3)
  0x00, 0xD4, 0x01, 0x01, 0x11, 0x16, 0x13, 0x27, 0x95, // "Ô" (U+00D4)
  0x00, 0xD5, 0x01, 0x01, 0x11, 0x15, 0x13, 0x28, 0x13, // "Õ" (U+00D5)
  0x00, 0xD6, 0x01, 0x01, 0x11, 0x15, 0x13, 0x28, 0x8F, // "Ö" (U+00D6)
  0x00, 0xD7, 0x01, 0x04, 0x0B, 0x0E, 0x0E, 0x29, 0x05, // "×" (U+00D7)
  0x00, 0xD8, 0x01, 0x00, 0x11, 0x12, 0x13, 0x29, 0x3C, // "Ø" (U+00D8)
  0x00, 0xD9, 0x02, 0x01, 0x0F, 0x16, 0x12, 0x29, 0xC0, // "Ù" (U+00D9)
  0x00, 0xDA, 0x02, 0x01, 0x0F, 0x16, 0x12, 0x2A, 0x2A, // "Ú" (U+00DA)
  0x00, 0xDB, 0x02, 0x01, 0x0F, 0x16, 0x12, 0x2A, 0x95, // "Û" (U+00DB)
  0x00, 0xDC, 0x02, 0x01, 0x0F, 0x15, 0x12, 0x2B, 0x05, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x0D, 0x16, 0x0E, 0x2B, 0x6E, // "Ý" (U+00DD)
  0x00, 0xDE, 0x02, 0x01, 0x0D, 0x11, 0x0F, 0x2B, 0xCD, // "Þ" (U+00DE)
  0x00, 0xDF, 0x02, 0x01, 0x0D, 0x12, 0x0F, 0x2C, 0x1A, // "ß" (U+00DF)
  0x00, 0xE0, 0x01, 0x01, 0x0B, 0x12, 0x0D, 0x2C, 0x84, // "à" (U+00E0)
  0x00, 0xE1, 0x01, 0x01, 0x0B, 0x12, 0x0D, 0x2C, 0xD6, // "á" (U+00E1)
  0x00, 0xE2, 0x01, 0x01, 0x0B, 0x12, 0x0D, 0x2D, 0x27, // "â" (U+00E2)
  0x00, 0xE3, 0x01, 0x01, 0x0B, 0x11, 0x0D, 0x2D, 0x7D, // "ã" (U+00E3)
  0x00, 0xE4, 0x01, 0x01, 0x0B, 0x11, 0x0D, 0x2D, 0xD2, // "ä" (U+00E4)
  0x00, 0xE5, 0x01, 0x01, 0x0B, 0x14, 0x0D, 0x2E, 0x22, // "å" (U+00E5)
  0x00, 0xE6, 0x01, 0x01, 0x13, 0x0D, 0x15, 0x2E, 0x7B, // "æ" (U+00E6)
  0x00, 0xE7, 0x01, 0xFB, 0x0A, 0x0D, 0x0C, 0x2E, 0xE4, // "ç" (U+00E7)
  0x00, 0xE8, 0x01, 0x01, 0x0C, 0x12, 0x0E, 0x2F, 0x2E, // "è" (U+00E8)
  0x00, 0xE9, 0x01, 0x01, 0x0C, 0x12, 0x0E, 0x2F, 0x7C, // "é" (U+00E9)
  0x00, 0xEA, 0x01, 0x01, 0x0C, 0x12, 0x0E, 0x2F, 0xCA, // "ê" (U+00EA)
  0x00, 0xEB, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x30, 0x1D, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x04, 0x12, 0x06, 0x30, 0x6A, // "ì" (U+00EC)
  0x00, 0xED, 0x02, 0x01, 0x06, 0x12, 0x06, 0x30, 0x9D, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x06, 0x12, 0x06, 0x30, 0xCF, // "î" (U+00EE)
  0x00, 0xEF, 0xFF, 0x01, 0x06, 0x11, 0x06, 0x31, 0x08, // "ï" (U+00EF)
  0x00, 0xF0, 0x01, 0x01, 0x0D, 0x13, 0x0F, 0x31, 0x3B, // "ð" (U+00F0)
  0x00, 0xF1, 0x02, 0x01, 0x0C, 0x11, 0x0F, 0x31, 0x9F, // "ñ" (U+00F1)
  0x00, 0xF2, 0x01, 0x01, 0x0D, 0x12, 0x0F, 0x31, 0xF1, // "ò" (U+00F2)
  0x00, 0xF3, 0x01, 0x01, 0x0D, 0x12, 0x0F, 0x32, 0x48, // "ó" (U+00F3)
  0x00, 0xF4, 0x01, 0x01, 0x0D, 0x12, 0x0F, 0x32, 0xA0, // "ô" (U+00F4)
  0x00, 0xF5, 0x01, 0x01, 0x0D, 0x11, 0x0F, 0x32, 0xFD, // "õ" (U+00F5)
  0x00, 0xF6, 0x01, 0x01, 0x0D, 0x11, 0x0F, 0x33, 0x58, // "ö" (U+00F6)
  0x00, 0xF7, 0x01, 0x04, 0x0C, 0x0E, 0x0E, 0x33, 0xAE, // "÷" (U+00F7)
  0x00, 0xF8, 0x01, 0x00, 0x0D, 0x0E, 0x0F, 0x33, 0xCD, // "ø" (U+00F8)
  0x00, 0xF9, 0x01, 0x01, 0x0C, 0x12, 0x0F, 0x34, 0x2A, // "ù" (U+00F9)
  0x00, 0xFA, 0x01, 0x01, 0x0C, 0x12, 0x0F, 0x34, 0x78, // "ú" (U+00FA)
  0x00, 0xFB, 0x01, 0x01, 0x0C, 0x12, 0x0F, 0x34, 0xC6, // "û" (U+00FB)
  0x00, 0xFC, 0x01, 0x01, 0x0C, 0x11, 0x0F, 0x35, 0x18, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFB, 0x0C, 0x12, 0x0C, 0x35, 0x64, // "ý" (U+00FD)
  0x00, 0xFE, 0x02, 0xFB, 0x0D, 0x12, 0x0F, 0x35, 0xCF, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFB, 0x0C, 0x11, 0x0C, 0x36, 0x3B, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x0F, 0x14, 0x0F, 0x36, 0xA4, // "Ā" (U+0100)
  0x01, 0x01, 0x01, 0x01, 0x0B, 0x10, 0x0D, 0x37, 0x05, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x0F, 0x15, 0x0F, 0x37, 0x4E, // "Ă" (U+0102)
  0x01, 0x03, 0x01, 0x01, 0x0B, 0x11, 0x0D, 0x37, 0xB9, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFC, 0x0F, 0x11, 0x0F, 0x38, 0x0C, // "Ą" (U+0104)
  0x01, 0x05, 0x01, 0xFC, 0x0B, 0x0D, 0x0D, 0x38, 0x77, // "ą" (U+0105)
  0x01, 0x06, 0x01, 0x01, 0x0E, 0x16, 0x0F, 0x38, 0xC9, // "Ć" (U+0106)
  0x01, 0x07, 0x01, 0x01, 0x0A, 0x12, 0x0C, 0x39, 0x27, // "ć" (U+0107)
  0x01, 0x08, 0x01, 0x01, 0x0E, 0x16, 0x0F, 0x39, 0x6A, // "Ĉ" (U+0108)
  0x01, 0x09, 0x01, 0x01, 0x0A, 0x12, 0x0C, 0x39, 0xCC, // "ĉ" (U+0109)
  0x01, 0x0A, 0x01, 0x01, 0x0E, 0x16, 0x0F, 0x3A, 0x14, // "Ċ" (U+010A)
  0x01, 0x0B, 0x01, 0x01, 0x0A, 0x12, 0x0C, 0x3A, 0x6D, // "ċ" (U+010B)
  0x01, 0x0C, 0x01, 0x01, 0x0E, 0x16, 0x0F, 0x3A, 0xAB, // "Č" (U+010C)
  0x01, 0x0D, 0x01, 0x01, 0x0A, 0x12, 0x0C, 0x3B, 0x0E, // "č" (U+010D)
  0x01, 0x0E, 0x02, 0x01, 0x0F, 0x16, 0x12, 0x3B, 0x57, // "Ď" (U+010E)
  0x01, 0x0F, 0x01, 0x01, 0x10, 0x12, 0x0F, 0x3B, 0xCA, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x0F, 0x11, 0x12, 0x3C, 0x37, // "Đ" (U+0110)
  0x01, 0x11, 0x01, 0x01, 0x0E, 0x12, 0x0F, 0x3C, 0xA3, // "đ" (U+0111)
  0x01, 0x12, 0x02, 0x01, 0x0B, 0x14, 0x0D, 0x3D, 0x0D, // "Ē" (U+0112)
  0x01, 0x13, 0x01, 0x01, 0x0C, 0x10, 0x0E, 0x3D, 0x4C, // "ē" (U+0113)
  0x01, 0x14, 0x02, 0x01, 0x0B, 0x15, 0x0D, 0x3D, 0x91, // "Ĕ" (U+0114)
  0x01, 0x15, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x3D, 0xDA, // "ĕ" (U+0115)
  0x01, 0x16, 0x02, 0x01, 0x0B, 0x16, 0x0D, 0x3E, 0x29, // "Ė" (U+0116)
  0x01, 0x17, 0x01, 0x01, 0x0C, 0x12, 0x0E, 0x3E, 0x6C, // "ė" (U+0117)
  0x01, 0x18, 0x02, 0xFC, 0x0B, 0x11, 0x0D, 0x3E, 0xB6, // "Ę" (U+0118)
  0x01, 0x19, 0x01, 0xFB, 0x0C, 0x0D, 0x0E, 0x3E, 0xFD, // "ę" (U+0119)
  0x01, 0x1A, 0x02, 0x01, 0x0B, 0x16, 0x0D, 0x3F, 0x53, // "Ě" (U+011A)
  0x01, 0x1B, 0x01, 0x01, 0x0C, 0x12, 0x0E, 0x3F, 0xA0, // "ě" (U+011B)
  0x01, 0x1C, 0x01, 0x01, 0x0F, 0x16, 0x11, 0x3F, 0xF3, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x01, 0xFB, 0x0C, 0x12, 0x0F, 0x40, 0x67, // "ĝ" (U+011D)
  0x01, 0x1E, 0x01, 0x01, 0x0F, 0x15, 0x11, 0x40, 0xE1, // "Ğ" (U+011E)
  0x01, 0x1F, 0x01, 0xFB, 0x0C, 0x11, 0x0F, 0x41, 0x51, // "ğ" (U+011F)
  0x01, 0x20, 0x01, 0x01, 0x0F, 0x16, 0x11, 0x41, 0xC7, // "Ġ" (U+0120)
  0x01, 0x21, 0x01, 0xFB, 0x0C, 0x12, 0x0F, 0x42, 0x31, // "ġ" (U+0121)
  0x01, 0x22, 0x01, 0xFB, 0x0F, 0x11, 0x11, 0x42, 0xA2, // "Ģ" (U+0122)
  0x01, 0x23, 0x01, 0xFB, 0x0C, 0x12, 0x0F, 0x43, 0x0E, // "ģ" (U+0123)
  0x01, 0x24, 0x02, 0x01, 0x0F, 0x16, 0x12, 0x43, 0x81, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x0C, 0x17, 0x0F, 0x43, 0xEB, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x11, 0x11, 0x12, 0x44, 0x63, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x0C, 0x12, 0x0F, 0x44, 0xCF, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x01, 0x08, 0x15, 0x08, 0x45, 0x35, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0x01, 0x07, 0x11, 0x06, 0x45, 0x6E, // "ĩ" (U+0129)
  0x01, 0x2A, 0x01, 0x01, 0x08, 0x14, 0x08, 0x45, 0xA5, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x07, 0x10, 0x06, 0x45, 0xD3, // "ī" (U+012B)
  0x01, 0x2C, 0x01, 0x01, 0x08, 0x15, 0x08, 0x46, 0x00, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x07, 0x11, 0x06, 0x46, 0x37, // "ĭ" (U+012D)
  0x01, 0x2E, 0x01, 0xFC, 0x07, 0x11, 0x08, 0x46, 0x6D, // "Į" (U+012E)
  0x01, 0x2F, 0x01, 0xFC, 0x04, 0x12, 0x06, 0x46, 0xA3, // "į" (U+012F)
  0x01, 0x30, 0x01, 0x01, 0x07, 0x16, 0x08, 0x46, 0xD1, // "İ" (U+0130)
  0x01, 0x31, 0x02, 0x01, 0x04, 0x0D, 0x06, 0x47, 0x02, // "ı" (U+0131)
  0x01, 0x32, 0x01, 0xFC, 0x0C, 0x11, 0x0F, 0x47, 0x17, // "Ĳ" (U+0132)
  0x01, 0x33, 0x01, 0xFB, 0x0A, 0x12, 0x0C, 0x47, 0x83, // "ĳ" (U+0133)
  0x01, 0x34, 0xFE, 0xFC, 0x06, 0x16, 0x07, 0x47, 0xEA, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFE, 0xFB, 0x06, 0x12, 0x06, 0x48, 0x43, // "ĵ" (U+0135)
  0x01, 0x36, 0x02, 0xFB, 0x0E, 0x11, 0x0F, 0x48, 0x91, // "Ķ" (U+0136)
  0x01, 0x37, 0x02, 0xFB, 0x0C, 0x12, 0x0D, 0x49, 0x01, // "ķ" (U+0137)
  0x01, 0x38, 0x02, 0x01, 0x0C, 0x0D, 0x0D, 0x49, 0x68, // "ĸ" (U+0138)
  0x01, 0x39, 0x02, 0x01, 0x0B, 0x16, 0x0D, 0x49, 0xAF, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x02, 0x01, 0x06, 0x17, 0x06, 0x49, 0xF1, // "ĺ" (U+013A)
  0x01, 0x3B, 0x02, 0xFB, 0x0B, 0x11, 0x0D, 0x4A, 0x32, // "Ļ" (U+013B)
  0x01, 0x3C, 0x01, 0xFB, 0x04, 0x12, 0x06, 0x4A, 0x73, // "ļ" (U+013C)
  0x01, 0x3D, 0x02, 0x01, 0x0B, 0x11, 0x0D, 0x4A, 0xA3, // "Ľ" (U+013D)
  0x01, 0x3E, 0x02, 0x01, 0x07, 0x12, 0x06, 0x4A, 0xDD, // "ľ" (U+013E)
  0x01, 0x3F, 0x02, 0x01, 0x0B, 0x11, 0x0D, 0x4B, 0x14, // "Ŀ" (U+013F)
  0x01, 0x40, 0x02, 0x01, 0x07, 0x12, 0x06, 0x4B, 0x4D, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x0B, 0x11, 0x0D, 0x4B, 0x84, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x06, 0x12, 0x06, 0x4B, 0xC5, // "ł" (U+0142)
  0x01, 0x43, 0x02, 0x01, 0x0F, 0x16, 0x12, 0x4B, 0xF0, // "Ń" (U+0143)
  0x01, 0x44, 0x02, 0x01, 0x0C, 0x12, 0x0F, 0x4C, 0x68, // "ń" (U+0144)
  0x01, 0x45, 0x02, 0xFB, 0x0F, 0x11, 0x12, 0x4C, 0xB6, // "Ņ" (U+0145)
  0x01, 0x46, 0x02, 0xFB, 0x0C, 0x0D, 0x0F, 0x4D, 0x2E, // "ņ" (U+0146)
  0x01, 0x47, 0x02, 0x01, 0x0F, 0x16, 0x12, 0x4D, 0x7C, // "Ň" (U+0147)
  0x01, 0x48, 0x02, 0x01, 0x0C, 0x12, 0x0F, 0x4D, 0xF9, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x0E, 0x11, 0x11, 0x4E, 0x4D, // "ŉ" (U+0149)
  0x01, 0x4A, 0x02, 0xFC, 0x0F, 0x11, 0x12, 0x4E, 0xAF, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x02, 0xFB, 0x0C, 0x0D, 0x0F, 0x4F, 0x2B, // "ŋ" (U+014B)
  0x01, 0x4C, 0x01, 0x01, 0x11, 0x14, 0x13, 0x4F, 0x82, // "Ō" (U+014C)
  0x01, 0x4D, 0x01, 0x01, 0x0D, 0x10, 0x0F, 0x4F, 0xF1, // "ō" (U+014D)
  0x01, 0x4E, 0x01, 0x01, 0x11, 0x15, 0x13, 0x50, 0x40, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x01, 0x01, 0x0D, 0x11, 0x0F, 0x50, 0xB9, // "ŏ" (U+014F)
  0x01, 0x50, 0x01, 0x01, 0x11, 0x16, 0x13, 0x51, 0x11, // "Ő" (U+0150)
  0x01, 0x51, 0x01, 0x01, 0x0D, 0x12, 0x0F, 0x51, 0x91, // "ő" (U+0151)
  0x01, 0x52, 0x01, 0x01, 0x14, 0x11, 0x16, 0x51, 0xEF, // "Œ" (U+0152)
  0x01, 0x53, 0x01, 0x01, 0x15, 0x0D, 0x17, 0x52, 0x5E, // "œ" (U+0153)
  0x01, 0x54, 0x02, 0x01, 0x0E, 0x16, 0x0F, 0x52, 0xCE, // "Ŕ" (U+0154)
  0x01, 0x55, 0x02, 0x01, 0x09, 0x12, 0x0A, 0x53, 0x3E, // "ŕ" (U+0155)
  0x01, 0x56, 0x02, 0xFB, 0x0E, 0x11, 0x0F, 0x53, 0x77, // "Ŗ" (U+0156)
  0x01, 0x57, 0x01, 0xFB, 0x09, 0x0D, 0x0A, 0x53, 0xE6, // "ŗ" (U+0157)
  0x01, 0x58, 0x02, 0x01, 0x0E, 0x16, 0x0F, 0x54, 0x20, // "Ř" (U+0158)
  0x01, 0x59, 0x02, 0x01, 0x09, 0x12, 0x0A, 0x54, 0x95, // "ř" (U+0159)
  0x01, 0x5A, 0x01, 0x01, 0x0B, 0x16, 0x0D, 0x54, 0xD1, // "Ś" (U+015A)
  0x01, 0x5B, 0x01, 0x01, 0x0A, 0x12, 0x0C, 0x55, 0x2B, // "ś" (U+015B)
  0x01, 0x5C, 0x01, 0x01, 0x0B, 0x16, 0x0D, 0x55, 0x71, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x01, 0x01, 0x0A, 0x12, 0x0C, 0x55, 0xD1, // "ŝ" (U+015D)
  0x01, 0x5E, 0x01, 0xFB, 0x0B, 0x11, 0x0D, 0x56, 0x1D, // "Ş" (U+015E)
  0x01, 0x5F, 0x01, 0xFB, 0x0A, 0x0D, 0x0C, 0x56, 0x7E, // "ş" (U+015F)
  0x01, 0x60, 0x01, 0x01, 0x0B, 0x16, 0x0D, 0x56, 0xCA, // "Š" (U+0160)
  0x01, 0x61, 0x01, 0x01, 0x0A, 0x12, 0x0C, 0x57, 0x2A, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFB, 0x0D, 0x11, 0x0D, 0x57, 0x76, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFB, 0x08, 0x10, 0x09, 0x57, 0xCC, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x0D, 0x16, 0x0D, 0x58, 0x17, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x0B, 0x12, 0x09, 0x58, 0x6A, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x0D, 0x11, 0x0D, 0x58, 0xB1, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x08, 0x10, 0x09, 0x58, 0xF1, // "ŧ" (U+0167)
  0x01, 0x68, 0x02, 0x01, 0x0F, 0x15, 0x12, 0x59, 0x2A, // "Ũ" (U+0168)
  0x01, 0x69, 0x01, 0x01, 0x0C, 0x11, 0x0F, 0x59, 0x98, // "ũ" (U+0169)
  0x01, 0x6A, 0x02, 0x01, 0x0F, 0x14, 0x12, 0x59, 0xE9, // "Ū" (U+016A)
  0x01, 0x6B, 0x01, 0x01, 0x0C, 0x10, 0x0F, 0x5A, 0x4B, // "ū" (U+016B)
  0x01, 0x6C, 0x02, 0x01, 0x0F, 0x15, 0x12, 0x5A, 0x90, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x01, 0x01, 0x0C, 0x11, 0x0F, 0x5A, 0xFC, // "ŭ" (U+016D)
  0x01, 0x6E, 0x02, 0x01, 0x0F, 0x18, 0x12, 0x5B, 0x4A, // "Ů" (U+016E)
  0x01, 0x6F, 0x01, 0x01, 0x0C, 0x14, 0x0F, 0x5B, 0xBE, // "ů" (U+016F)
  0x01, 0x70, 0x02, 0x01, 0x0F, 0x16, 0x12, 0x5C, 0x13, // "Ű" (U+0170)
  0x01, 0x71, 0x01, 0x01, 0x0C, 0x12, 0x0F, 0x5C, 0x84, // "ű" (U+0171)
  0x01, 0x72, 0x02, 0xFB, 0x0F, 0x11, 0x12, 0x5C, 0xD8, // "Ų" (U+0172)
  0x01, 0x73, 0x01, 0xFC, 0x0C, 0x0D, 0x0F, 0x5D, 0x4B, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x15, 0x16, 0x16, 0x5D, 0x9A, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x12, 0x12, 0x13, 0x5E, 0x4D, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x0D, 0x16, 0x0E, 0x5E, 0xD5, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFB, 0x0C, 0x12, 0x0C, 0x5F, 0x39, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x0D, 0x15, 0x0E, 0x5F, 0xA9, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x0C, 0x16, 0x0E, 0x60, 0x06, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x0A, 0x12, 0x0B, 0x60, 0x58, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x0C, 0x16, 0x0E, 0x60, 0x95, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x0A, 0x12, 0x0B, 0x60, 0xE3, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x0C, 0x16, 0x0E, 0x61, 0x1D, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x0A, 0x12, 0x0B, 0x61, 0x74, // "ž" (U+017E)
  0x01, 0x7F, 0x02, 0x01, 0x08, 0x12, 0x08, 0x61, 0xB7, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x11, 0x11, 0x13, 0x61, 0xEF, // "Ω" (U+03A9)
  0x03, 0xBC, 0x02, 0xFB, 0x0C, 0x0D, 0x0F, 0x62, 0x5C, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x0E, 0x0D, 0x10, 0x62, 0xAF, // "π" (U+03C0)
  0x20, 0x13, 0x01, 0x06, 0x0A, 0x07, 0x0C, 0x62, 0xF3, // "–" (U+2013)
  0x20, 0x14, 0x01, 0x06, 0x16, 0x07, 0x18, 0x62, 0xF6, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x0D, 0x11, 0x0E, 0x62, 0xFB, // "€" (U+20AC)
  0x20, 0xBF, 0x02, 0xFE, 0x0C, 0x14, 0x0E, 0x63, 0x4E, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x0C, 0x03, 0x11, 0x04, 0x63, 0xBE, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x0C, 0x03, 0x11, 0x04, 0x63, 0xCB, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0xFE, 0x03, 0x03, 0x06, 0x63, 0xD9, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x0C, 0x03, 0x11, 0x04, 0x63, 0xE7, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x0C, 0x08, 0x11, 0x09, 0x63, 0xF5, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x0C, 0x08, 0x11, 0x09, 0x64, 0x13, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0xFE, 0x08, 0x03, 0x0A, 0x64, 0x32, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x0C, 0x08, 0x11, 0x09, 0x64, 0x51, // "‟" (U+201F)
  0x20, 0x20, 0x01, 0x01, 0x0A, 0x12, 0x0C, 0x64, 0x70, // "†" (U+2020)
  0x20, 0x21, 0x01, 0x01, 0x0A, 0x12, 0x0C, 0x64, 0xA9, // "‡" (U+2021)
  0x20, 0x22, 0x01, 0x07, 0x07, 0x0C, 0x09, 0x64, 0xEA, // "•" (U+2022)
  0x20, 0x26, 0x01, 0x01, 0x11, 0x03, 0x13, 0x64, 0xFE, // "…" (U+2026)
  0x20, 0x30, 0x01, 0x01, 0x1B, 0x11, 0x1C, 0x65, 0x18, // "‰" (U+2030)
  0x20, 0x39, 0x01, 0x02, 0x06, 0x0C, 0x07, 0x65, 0xD9, // "‹" (U+2039)
  0x20, 0x3A, 0x01, 0x02, 0x06, 0x0C, 0x07, 0x65, 0xF9, // "›" (U+203A)
  0x20, 0x44, 0xFB, 0x01, 0x07, 0x11, 0x03, 0x66, 0x19, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x09, 0x10, 0x11, 0x13, 0x66, 0x54, // "™" (U+2122)
  0x21, 0x52, 0x01, 0x00, 0x18, 0x11, 0x19, 0x66, 0xA9, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x0C, 0x12, 0x0E, 0x67, 0x4F, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x0C, 0x12, 0x0E, 0x67, 0xB7, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x02, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x61, 0x01, // "a (U+0022 U+0061)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x67, 0x01, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0x6D, 0x01, // "m (U+0022 U+006D)
  0x00, 0x22, 0x00, 0x6E, 0x01, // "n (U+0022 U+006E)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x70, 0x01, // "p (U+0022 U+0070)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0x72, 0x01, // "r (U+0022 U+0072)
  0x00, 0x22, 0x00, 0x73, 0x01, // "s (U+0022 U+0073)
  0x00, 0x22, 0x00, 0x75, 0x01, // "u (U+0022 U+0075)
  0x00, 0x22, 0x00, 0xC0, 0x02, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x02, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x02, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x02, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x02, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x02, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x02, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE1, 0x01, // "á (U+0022 U+00E1)
  0x00, 0x22, 0x00, 0xE2, 0x01, // "â (U+0022 U+00E2)
  0x00, 0x22, 0x00, 0xE3, 0x01, // "ã (U+0022 U+00E3)
  0x00, 0x22, 0x00, 0xE4, 0x01, // "ä (U+0022 U+00E4)
  0x00, 0x22, 0x00, 0xE5, 0x01, // "å (U+0022 U+00E5)
  0x00, 0x22, 0x00, 0xE6, 0x01, // "æ (U+0022 U+00E6)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x00, 0xF9, 0x01, // "ù (U+0022 U+00F9)
  0x00, 0x22, 0x00, 0xFA, 0x01, // "ú (U+0022 U+00FA)
  0x00, 0x22, 0x00, 0xFB, 0x01, // "û (U+0022 U+00FB)
  0x00, 0x22, 0x00, 0xFC, 0x01, // "ü (U+0022 U+00FC)
  0x00, 0x22, 0x01, 0x00, 0x02, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x01, 0x01, // "ā (U+0022 U+0101)
  0x00, 0x22, 0x01, 0x02, 0x02, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x03, 0x01, // "ă (U+0022 U+0103)
  0x00, 0x22, 0x01, 0x04, 0x02, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x05, 0x01, // "ą (U+0022 U+0105)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x1D, 0x01, // "ĝ (U+0022 U+011D)
  0x00, 0x22, 0x01, 0x1F, 0x01, // "ğ (U+0022 U+011F)
  0x00, 0x22, 0x01, 0x21, 0x01, // "ġ (U+0022 U+0121)
  0x00, 0x22, 0x01, 0x23, 0x01, // "ģ (U+0022 U+0123)
  0x00, 0x22, 0x01, 0x38, 0x01, // "ĸ (U+0022 U+0138)
  0x00, 0x22, 0x01, 0x44, 0x01, // "ń (U+0022 U+0144)
  0x00, 0x22, 0x01, 0x46, 0x01, // "ņ (U+0022 U+0146)
  0x00, 0x22, 0x01, 0x4B, 0x01, // "ŋ (U+0022 U+014B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x22, 0x01, 0x55, 0x01, // "ŕ (U+0022 U+0155)
  0x00, 0x22, 0x01, 0x57, 0x01, // "ŗ (U+0022 U+0157)
  0x00, 0x22, 0x01, 0x5B, 0x01, // "ś (U+0022 U+015B)
  0x00, 0x22, 0x01, 0x5F, 0x01, // "ş (U+0022 U+015F)
  0x00, 0x22, 0x01, 0x69, 0x01, // "ũ (U+0022 U+0169)
  0x00, 0x22, 0x01, 0x6B, 0x01, // "ū (U+0022 U+016B)
  0x00, 0x22, 0x01, 0x6D, 0x01, // "ŭ (U+0022 U+016D)
  0x00, 0x22, 0x01, 0x6F, 0x01, // "ů (U+0022 U+016F)
  0x00, 0x22, 0x01, 0x71, 0x01, // "ű (U+0022 U+0171)
  0x00, 0x22, 0x01, 0x73, 0x01, // "ų (U+0022 U+0173)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x59, 0x01, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x01, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x62, 0x01, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x01, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x01, // &Ŧ (U+0026 U+0166)
  0x00, 0x26, 0x01, 0x76, 0x01, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x01, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x02, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x61, 0x01, // 'a (U+0027 U+0061)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x67, 0x01, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0x6D, 0x01, // 'm (U+0027 U+006D)
  0x00, 0x27, 0x00, 0x6E, 0x01, // 'n (U+0027 U+006E)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x70, 0x01, // 'p (U+0027 U+0070)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0x72, 0x01, // 'r (U+0027 U+0072)
  0x00, 0x27, 0x00, 0x73, 0x01, // 's (U+0027 U+0073)
  0x00, 0x27, 0x00, 0x75, 0x01, // 'u (U+0027 U+0075)
  0x00, 0x27, 0x00, 0xC0, 0x02, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x02, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x02, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x02, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x02, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x02, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x02, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE1, 0x01, // 'á (U+0027 U+00E1)
  0x00, 0x27, 0x00, 0xE2, 0x01, // 'â (U+0027 U+00E2)
  0x00, 0x27, 0x00, 0xE3, 0x01, // 'ã (U+0027 U+00E3)
  0x00, 0x27, 0x00, 0xE4, 0x01, // 'ä (U+0027 U+00E4)
  0x00, 0x27, 0x00, 0xE5, 0x01, // 'å (U+0027 U+00E5)
  0x00, 0x27, 0x00, 0xE6, 0x01, // 'æ (U+0027 U+00E6)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x00, 0xF9, 0x01, // 'ù (U+0027 U+00F9)
  0x00, 0x27, 0x00, 0xFA, 0x01, // 'ú (U+0027 U+00FA)
  0x00, 0x27, 0x00, 0xFB, 0x01, // 'û (U+0027 U+00FB)
  0x00, 0x27, 0x00, 0xFC, 0x01, // 'ü (U+0027 U+00FC)
  0x00, 0x27, 0x01, 0x00, 0x02, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x01, 0x01, // 'ā (U+0027 U+0101)
  0x00, 0x27, 0x01, 0x02, 0x02, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x03, 0x01, // 'ă (U+0027 U+0103)
  0x00, 0x27, 0x01, 0x04, 0x02, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x05, 0x01, // 'ą (U+0027 U+0105)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x1D, 0x01, // 'ĝ (U+0027 U+011D)
  0x00, 0x27, 0x01, 0x1F, 0x01, // 'ğ (U+0027 U+011F)
  0x00, 0x27, 0x01, 0x21, 0x01, // 'ġ (U+0027 U+0121)
  0x00, 0x27, 0x01, 0x23, 0x01, // 'ģ (U+0027 U+0123)
  0x00, 0x27, 0x01, 0x38, 0x01, // 'ĸ (U+0027 U+0138)
  0x00, 0x27, 0x01, 0x44, 0x01, // 'ń (U+0027 U+0144)
  0x00, 0x27, 0x01, 0x46, 0x01, // 'ņ (U+0027 U+0146)
  0x00, 0x27, 0x01, 0x4B, 0x01, // 'ŋ (U+0027 U+014B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x27, 0x01, 0x55, 0x01, // 'ŕ (U+0027 U+0155)
  0x00, 0x27, 0x01, 0x57, 0x01, // 'ŗ (U+0027 U+0157)
  0x00, 0x27, 0x01, 0x5B, 0x01, // 'ś (U+0027 U+015B)
  0x00, 0x27, 0x01, 0x5F, 0x01, // 'ş (U+0027 U+015F)
  0x00, 0x27, 0x01, 0x69, 0x01, // 'ũ (U+0027 U+0169)
  0x00, 0x27, 0x01, 0x6B, 0x01, // 'ū (U+0027 U+016B)
  0x00, 0x27, 0x01, 0x6D, 0x01, // 'ŭ (U+0027 U+016D)
  0x00, 0x27, 0x01, 0x6F, 0x01, // 'ů (U+0027 U+016F)
  0x00, 0x27, 0x01, 0x71, 0x01, // 'ű (U+0027 U+0171)
  0x00, 0x27, 0x01, 0x73, 0x01, // 'ų (U+0027 U+0173)
  0x00, 0x2C, 0x00, 0x43, 0x01, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x01, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x01, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x01, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x02, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x01, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x01, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x01, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x01, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x01, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x01, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x01, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x01, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x01, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x01, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x01, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x01, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x01, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x01, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x01, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x01, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x01, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x01, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x01, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x02, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x02, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x02, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2D, 0x00, 0x54, 0x01, // -T (U+002D U+0054)
  0x00, 0x2D, 0x01, 0x62, 0x01, // -Ţ (U+002D U+0162)
  0x00, 0x2D, 0x01, 0x64, 0x01, // -Ť (U+002D U+0164)
  0x00, 0x2D, 0x01, 0x66, 0x01, // -Ŧ (U+002D U+0166)
  0x00, 0x2E, 0x00, 0x43, 0x01, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x01, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x01, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x01, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x02, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x01, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x01, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x01, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x01, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x01, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x01, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x01, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x01, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x01, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x01, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x01, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x01, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x01, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x01, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x01, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x01, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x01, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x01, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x01, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x02, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x02, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x02, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x06, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x06, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x06, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x06, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x06, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x06, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x06, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x06, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x06, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x06, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x02, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x02, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x54, 0x02, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x62, 0x02, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x02, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x02, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x19, 0x02, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x02, // A” (U+0041 U+201D)
  0x00, 0x44, 0x00, 0x2C, 0x01, // D, (U+0044 U+002C)
  0x00, 0x44, 0x00, 0x2E, 0x01, // D. (U+0044 U+002E)
  0x00, 0x44, 0x00, 0x54, 0x01, // DT (U+0044 U+0054)
  0x00, 0x44, 0x01, 0x62, 0x01, // DŢ (U+0044 U+0162)
  0x00, 0x44, 0x01, 0x64, 0x01, // DŤ (U+0044 U+0164)
  0x00, 0x44, 0x01, 0x66, 0x01, // DŦ (U+0044 U+0166)
  0x00, 0x44, 0x20, 0x1A, 0x01, // D‚ (U+0044 U+201A)
  0x00, 0x44, 0x20, 0x1E, 0x01, // D„ (U+0044 U+201E)
  0x00, 0x44, 0x20, 0x26, 0x01, // D… (U+0044 U+2026)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x02, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x02, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x19, 0x02, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x02, // L” (U+004C U+201D)
  0x00, 0x4F, 0x00, 0x2C, 0x01, // O, (U+004F U+002C)
  0x00, 0x4F, 0x00, 0x2E, 0x01, // O. (U+004F U+002E)
  0x00, 0x4F, 0x00, 0x54, 0x01, // OT (U+004F U+0054)
  0x00, 0x4F, 0x01, 0x62, 0x01, // OŢ (U+004F U+0162)
  0x00, 0x4F, 0x01, 0x64, 0x01, // OŤ (U+004F U+0164)
  0x00, 0x4F, 0x01, 0x66, 0x01, // OŦ (U+004F U+0166)
  0x00, 0x4F, 0x20, 0x1A, 0x01, // O‚ (U+004F U+201A)
  0x00, 0x4F, 0x20, 0x1E, 0x01, // O„ (U+004F U+201E)
  0x00, 0x4F, 0x20, 0x26, 0x01, // O… (U+004F U+2026)
  0x00, 0x50, 0x00, 0x2C, 0x03, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x03, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x03, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x03, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x03, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x2C, 0x01, // Q, (U+0051 U+002C)
  0x00, 0x51, 0x00, 0x2E, 0x01, // Q. (U+0051 U+002E)
  0x00, 0x51, 0x00, 0x54, 0x01, // QT (U+0051 U+0054)
  0x00, 0x51, 0x01, 0x62, 0x01, // QŢ (U+0051 U+0162)
  0x00, 0x51, 0x01, 0x64, 0x01, // QŤ (U+0051 U+0164)
  0x00, 0x51, 0x01, 0x66, 0x01, // QŦ (U+0051 U+0166)
  0x00, 0x51, 0x20, 0x1A, 0x01, // Q‚ (U+0051 U+201A)
  0x00, 0x51, 0x20, 0x1E, 0x01, // Q„ (U+0051 U+201E)
  0x00, 0x51, 0x20, 0x26, 0x01, // Q… (U+0051 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2D, 0x01, // T- (U+0054 U+002D)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x02, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x02, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x02, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x02, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x02, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x02, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x01, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x01, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x02, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x01, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x02, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x01, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x01, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x01, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0x7A, 0x01, // Tz (U+0054 U+007A)
  0x00, 0x54, 0x00, 0xAB, 0x01, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xBB, 0x01, // T» (U+0054 U+00BB)
  0x00, 0x54, 0x00, 0xC0, 0x02, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x02, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x02, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x02, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x02, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x02, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xE0, 0x02, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x02, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x02, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x02, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x02, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x02, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x02, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x02, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x02, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x02, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x02, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x02, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x02, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x02, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x02, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x02, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x02, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x02, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x01, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x01, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x01, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x01, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x01, 0x00, 0x02, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x02, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x02, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x02, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x02, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x02, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x02, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x02, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x02, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x02, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x02, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x02, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x02, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x02, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x02, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x02, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x02, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x02, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x02, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x02, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x02, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x01, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x01, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x01, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x4B, 0x01, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4D, 0x02, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x02, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x02, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x02, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x01, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x01, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x01, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5F, 0x01, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x69, 0x01, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x01, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x01, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x01, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x01, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x01, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x01, 0x7A, 0x01, // Tź (U+0054 U+017A)
  0x00, 0x54, 0x01, 0x7C, 0x01, // Tż (U+0054 U+017C)
  0x00, 0x54, 0x01, 0x7E, 0x01, // Tž (U+0054 U+017E)
  0x00, 0x54, 0x20, 0x13, 0x01, // T– (U+0054 U+2013)
  0x00, 0x54, 0x20, 0x14, 0x01, // T— (U+0054 U+2014)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x01, // T‹ (U+0054 U+2039)
  0x00, 0x54, 0x20, 0x3A, 0x01, // T› (U+0054 U+203A)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0xAB, 0x01, // V« (U+0056 U+00AB)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x56, 0x20, 0x39, 0x01, // V‹ (U+0056 U+2039)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x41, 0x01, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0xAB, 0x01, // W« (U+0057 U+00AB)
  0x00, 0x57, 0x00, 0xC0, 0x01, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x01, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x01, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x01, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x01, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x01, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x01, 0x00, 0x01, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x02, 0x01, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x04, 0x01, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x57, 0x20, 0x39, 0x01, // W‹ (U+0057 U+2039)
  0x00, 0x59, 0x00, 0x26, 0x01, // Y& (U+0059 U+0026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6D, 0x01, // Ym (U+0059 U+006D)
  0x00, 0x59, 0x00, 0x6E, 0x01, // Yn (U+0059 U+006E)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x70, 0x01, // Yp (U+0059 U+0070)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x72, 0x01, // Yr (U+0059 U+0072)
  0x00, 0x59, 0x00, 0x73, 0x01, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0x75, 0x01, // Yu (U+0059 U+0075)
  0x00, 0x59, 0x00, 0xAB, 0x02, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xBB, 0x01, // Y» (U+0059 U+00BB)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x00, 0xF9, 0x01, // Yù (U+0059 U+00F9)
  0x00, 0x59, 0x00, 0xFA, 0x01, // Yú (U+0059 U+00FA)
  0x00, 0x59, 0x00, 0xFB, 0x01, // Yû (U+0059 U+00FB)
  0x00, 0x59, 0x00, 0xFC, 0x01, // Yü (U+0059 U+00FC)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x38, 0x01, // Yĸ (U+0059 U+0138)
  0x00, 0x59, 0x01, 0x44, 0x01, // Yń (U+0059 U+0144)
  0x00, 0x59, 0x01, 0x46, 0x01, // Yņ (U+0059 U+0146)
  0x00, 0x59, 0x01, 0x4B, 0x01, // Yŋ (U+0059 U+014B)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x55, 0x01, // Yŕ (U+0059 U+0155)
  0x00, 0x59, 0x01, 0x57, 0x01, // Yŗ (U+0059 U+0157)
  0x00, 0x59, 0x01, 0x5B, 0x01, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5F, 0x01, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x69, 0x01, // Yũ (U+0059 U+0169)
  0x00, 0x59, 0x01, 0x6B, 0x01, // Yū (U+0059 U+016B)
  0x00, 0x59, 0x01, 0x6D, 0x01, // Yŭ (U+0059 U+016D)
  0x00, 0x59, 0x01, 0x6F, 0x01, // Yů (U+0059 U+016F)
  0x00, 0x59, 0x01, 0x71, 0x01, // Yű (U+0059 U+0171)
  0x00, 0x59, 0x01, 0x73, 0x01, // Yų (U+0059 U+0173)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x02, // Y‹ (U+0059 U+2039)
  0x00, 0x59, 0x20, 0x3A, 0x01, // Y› (U+0059 U+203A)
  0x00, 0x72, 0x00, 0x2C, 0x04, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x04, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x04, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x04, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x04, // r… (U+0072 U+2026)
  0x00, 0x76, 0x00, 0x2C, 0x01, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xA1, 0x00, 0x59, 0x01, // ¡Y (U+00A1 U+0059)
  0x00, 0xA1, 0x00, 0xDD, 0x01, // ¡Ý (U+00A1 U+00DD)
  0x00, 0xA1, 0x01, 0x76, 0x01, // ¡Ŷ (U+00A1 U+0176)
  0x00, 0xA1, 0x01, 0x78, 0x01, // ¡Ÿ (U+00A1 U+0178)
  0x00, 0xAB, 0x00, 0x54, 0x01, // «T (U+00AB U+0054)
  0x00, 0xAB, 0x00, 0x59, 0x01, // «Y (U+00AB U+0059)
  0x00, 0xAB, 0x00, 0xDD, 0x01, // «Ý (U+00AB U+00DD)
  0x00, 0xAB, 0x01, 0x62, 0x01, // «Ţ (U+00AB U+0162)
  0x00, 0xAB, 0x01, 0x64, 0x01, // «Ť (U+00AB U+0164)
  0x00, 0xAB, 0x01, 0x66, 0x01, // «Ŧ (U+00AB U+0166)
  0x00, 0xAB, 0x01, 0x76, 0x01, // «Ŷ (U+00AB U+0176)
  0x00, 0xAB, 0x01, 0x78, 0x01, // «Ÿ (U+00AB U+0178)
  0x00, 0xBB, 0x00, 0x54, 0x01, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x56, 0x01, // »V (U+00BB U+0056)
  0x00, 0xBB, 0x00, 0x57, 0x01, // »W (U+00BB U+0057)
  0x00, 0xBB, 0x00, 0x59, 0x02, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x02, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x01, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x01, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x01, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x74, 0x01, // »Ŵ (U+00BB U+0174)
  0x00, 0xBB, 0x01, 0x76, 0x02, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x02, // »Ÿ (U+00BB U+0178)
  0x00, 0xBF, 0x00, 0x54, 0x01, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x00, 0x56, 0x01, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x01, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x01, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x01, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x62, 0x01, // ¿Ţ (U+00BF U+0162)
  0x00, 0xBF, 0x01, 0x64, 0x01, // ¿Ť (U+00BF U+0164)
  0x00, 0xBF, 0x01, 0x66, 0x01, // ¿Ŧ (U+00BF U+0166)
  0x00, 0xBF, 0x01, 0x74, 0x01, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x01, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x01, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x02, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x02, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x54, 0x02, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x62, 0x02, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x02, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x02, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x19, 0x02, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x02, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x02, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x02, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x54, 0x02, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x62, 0x02, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x02, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x02, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x19, 0x02, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x02, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x02, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x02, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x54, 0x02, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x62, 0x02, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x02, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x02, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x19, 0x02, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x02, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x02, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x02, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x54, 0x02, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x62, 0x02, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x02, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x02, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x19, 0x02, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x02, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x02, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x02, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x54, 0x02, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x62, 0x02, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x02, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x02, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x19, 0x02, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x02, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x02, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x02, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x54, 0x02, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x62, 0x02, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x02, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x02, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x19, 0x02, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x02, // Å” (U+00C5 U+201D)
  0x00, 0xD0, 0x00, 0x2C, 0x01, // Ð, (U+00D0 U+002C)
  0x00, 0xD0, 0x00, 0x2E, 0x01, // Ð. (U+00D0 U+002E)
  0x00, 0xD0, 0x00, 0x54, 0x01, // ÐT (U+00D0 U+0054)
  0x00, 0xD0, 0x01, 0x62, 0x01, // ÐŢ (U+00D0 U+0162)
  0x00, 0xD0, 0x01, 0x64, 0x01, // ÐŤ (U+00D0 U+0164)
  0x00, 0xD0, 0x01, 0x66, 0x01, // ÐŦ (U+00D0 U+0166)
  0x00, 0xD0, 0x20, 0x1A, 0x01, // Ð‚ (U+00D0 U+201A)
  0x00, 0xD0, 0x20, 0x1E, 0x01, // Ð„ (U+00D0 U+201E)
  0x00, 0xD0, 0x20, 0x26, 0x01, // Ð… (U+00D0 U+2026)
  0x00, 0xD2, 0x00, 0x2C, 0x01, // Ò, (U+00D2 U+002C)
  0x00, 0xD2, 0x00, 0x2E, 0x01, // Ò. (U+00D2 U+002E)
  0x00, 0xD2, 0x00, 0x54, 0x01, // ÒT (U+00D2 U+0054)
  0x00, 0xD2, 0x01, 0x62, 0x01, // ÒŢ (U+00D2 U+0162)
  0x00, 0xD2, 0x01, 0x64, 0x01, // ÒŤ (U+00D2 U+0164)
  0x00, 0xD2, 0x01, 0x66, 0x01, // ÒŦ (U+00D2 U+0166)
  0x00, 0xD2, 0x20, 0x1A, 0x01, // Ò‚ (U+00D2 U+201A)
  0x00, 0xD2, 0x20, 0x1E, 0x01, // Ò„ (U+00D2 U+201E)
  0x00, 0xD2, 0x20, 0x26, 0x01, // Ò… (U+00D2 U+2026)
  0x00, 0xD3, 0x00, 0x2C, 0x01, // Ó, (U+00D3 U+002C)
  0x00, 0xD3, 0x00, 0x2E, 0x01, // Ó. (U+00D3 U+002E)
  0x00, 0xD3, 0x00, 0x54, 0x01, // ÓT (U+00D3 U+0054)
  0x00, 0xD3, 0x01, 0x62, 0x01, // ÓŢ (U+00D3 U+0162)
  0x00, 0xD3, 0x01, 0x64, 0x01, // ÓŤ (U+00D3 U+0164)
  0x00, 0xD3, 0x01, 0x66, 0x01, // ÓŦ (U+00D3 U+0166)
  0x00, 0xD3, 0x20, 0x1A, 0x01, // Ó‚ (U+00D3 U+201A)
  0x00, 0xD3, 0x20, 0x1E, 0x01, // Ó„ (U+00D3 U+201E)
  0x00, 0xD3, 0x20, 0x26, 0x01, // Ó… (U+00D3 U+2026)
  0x00, 0xD4, 0x00, 0x2C, 0x01, // Ô, (U+00D4 U+002C)
  0x00, 0xD4, 0x00, 0x2E, 0x01, // Ô. (U+00D4 U+002E)
  0x00, 0xD4, 0x00, 0x54, 0x01, // ÔT (U+00D4 U+0054)
  0x00, 0xD4, 0x01, 0x62, 0x01, // ÔŢ (U+00D4 U+0162)
  0x00, 0xD4, 0x01, 0x64, 0x01, // ÔŤ (U+00D4 U+0164)
  0x00, 0xD4, 0x01, 0x66, 0x01, // ÔŦ (U+00D4 U+0166)
  0x00, 0xD4, 0x20, 0x1A, 0x01, // Ô‚ (U+00D4 U+201A)
  0x00, 0xD4, 0x20, 0x1E, 0x01, // Ô„ (U+00D4 U+201E)
  0x00, 0xD4, 0x20, 0x26, 0x01, // Ô… (U+00D4 U+2026)
  0x00, 0xD5, 0x00, 0x2C, 0x01, // Õ, (U+00D5 U+002C)
  0x00, 0xD5, 0x00, 0x2E, 0x01, // Õ. (U+00D5 U+002E)
  0x00, 0xD5, 0x00, 0x54, 0x01, // ÕT (U+00D5 U+0054)
  0x00, 0xD5, 0x01, 0x62, 0x01, // ÕŢ (U+00D5 U+0162)
  0x00, 0xD5, 0x01, 0x64, 0x01, // ÕŤ (U+00D5 U+0164)
  0x00, 0xD5, 0x01, 0x66, 0x01, // ÕŦ (U+00D5 U+0166)
  0x00, 0xD5, 0x20, 0x1A, 0x01, // Õ‚ (U+00D5 U+201A)
  0x00, 0xD5, 0x20, 0x1E, 0x01, // Õ„ (U+00D5 U+201E)
  0x00, 0xD5, 0x20, 0x26, 0x01, // Õ… (U+00D5 U+2026)
  0x00, 0xD6, 0x00, 0x2C, 0x01, // Ö, (U+00D6 U+002C)
  0x00, 0xD6, 0x00, 0x2E, 0x01, // Ö. (U+00D6 U+002E)
  0x00, 0xD6, 0x00, 0x54, 0x01, // ÖT (U+00D6 U+0054)
  0x00, 0xD6, 0x01, 0x62, 0x01, // ÖŢ (U+00D6 U+0162)
  0x00, 0xD6, 0x01, 0x64, 0x01, // ÖŤ (U+00D6 U+0164)
  0x00, 0xD6, 0x01, 0x66, 0x01, // ÖŦ (U+00D6 U+0166)
  0x00, 0xD6, 0x20, 0x1A, 0x01, // Ö‚ (U+00D6 U+201A)
  0x00, 0xD6, 0x20, 0x1E, 0x01, // Ö„ (U+00D6 U+201E)
  0x00, 0xD6, 0x20, 0x26, 0x01, // Ö… (U+00D6 U+2026)
  0x00, 0xD8, 0x00, 0x2C, 0x01, // Ø, (U+00D8 U+002C)
  0x00, 0xD8, 0x00, 0x2E, 0x01, // Ø. (U+00D8 U+002E)
  0x00, 0xD8, 0x00, 0x54, 0x01, // ØT (U+00D8 U+0054)
  0x00, 0xD8, 0x01, 0x62, 0x01, // ØŢ (U+00D8 U+0162)
  0x00, 0xD8, 0x01, 0x64, 0x01, // ØŤ (U+00D8 U+0164)
  0x00, 0xD8, 0x01, 0x66, 0x01, // ØŦ (U+00D8 U+0166)
  0x00, 0xD8, 0x20, 0x1A, 0x01, // Ø‚ (U+00D8 U+201A)
  0x00, 0xD8, 0x20, 0x1E, 0x01, // Ø„ (U+00D8 U+201E)
  0x00, 0xD8, 0x20, 0x26, 0x01, // Ø… (U+00D8 U+2026)
  0x00, 0xDD, 0x00, 0x26, 0x01, // Ý& (U+00DD U+0026)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6D, 0x01, // Ým (U+00DD U+006D)
  0x00, 0xDD, 0x00, 0x6E, 0x01, // Ýn (U+00DD U+006E)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x70, 0x01, // Ýp (U+00DD U+0070)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x72, 0x01, // Ýr (U+00DD U+0072)
  0x00, 0xDD, 0x00, 0x73, 0x01, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0x75, 0x01, // Ýu (U+00DD U+0075)
  0x00, 0xDD, 0x00, 0xAB, 0x02, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xBB, 0x01, // Ý» (U+00DD U+00BB)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x00, 0xF9, 0x01, // Ýù (U+00DD U+00F9)
  0x00, 0xDD, 0x00, 0xFA, 0x01, // Ýú (U+00DD U+00FA)
  0x00, 0xDD, 0x00, 0xFB, 0x01, // Ýû (U+00DD U+00FB)
  0x00, 0xDD, 0x00, 0xFC, 0x01, // Ýü (U+00DD U+00FC)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x38, 0x01, // Ýĸ (U+00DD U+0138)
  0x00, 0xDD, 0x01, 0x44, 0x01, // Ýń (U+00DD U+0144)
  0x00, 0xDD, 0x01, 0x46, 0x01, // Ýņ (U+00DD U+0146)
  0x00, 0xDD, 0x01, 0x4B, 0x01, // Ýŋ (U+00DD U+014B)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x55, 0x01, // Ýŕ (U+00DD U+0155)
  0x00, 0xDD, 0x01, 0x57, 0x01, // Ýŗ (U+00DD U+0157)
  0x00, 0xDD, 0x01, 0x5B, 0x01, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5F, 0x01, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x69, 0x01, // Ýũ (U+00DD U+0169)
  0x00, 0xDD, 0x01, 0x6B, 0x01, // Ýū (U+00DD U+016B)
  0x00, 0xDD, 0x01, 0x6D, 0x01, // Ýŭ (U+00DD U+016D)
  0x00, 0xDD, 0x01, 0x6F, 0x01, // Ýů (U+00DD U+016F)
  0x00, 0xDD, 0x01, 0x71, 0x01, // Ýű (U+00DD U+0171)
  0x00, 0xDD, 0x01, 0x73, 0x01, // Ýų (U+00DD U+0173)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x02, // Ý‹ (U+00DD U+2039)
  0x00, 0xDD, 0x20, 0x3A, 0x01, // Ý› (U+00DD U+203A)
  0x00, 0xDE, 0x00, 0x2C, 0x03, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x03, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x00, 0x41, 0x01, // ÞA (U+00DE U+0041)
  0x00, 0xDE, 0x00, 0xC0, 0x01, // ÞÀ (U+00DE U+00C0)
  0x00, 0xDE, 0x00, 0xC1, 0x01, // ÞÁ (U+00DE U+00C1)
  0x00, 0xDE, 0x00, 0xC2, 0x01, // ÞÂ (U+00DE U+00C2)
  0x00, 0xDE, 0x00, 0xC3, 0x01, // ÞÃ (U+00DE U+00C3)
  0x00, 0xDE, 0x00, 0xC4, 0x01, // ÞÄ (U+00DE U+00C4)
  0x00, 0xDE, 0x00, 0xC5, 0x01, // ÞÅ (U+00DE U+00C5)
  0x00, 0xDE, 0x00, 0xC6, 0x01, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDE, 0x01, 0x00, 0x01, // ÞĀ (U+00DE U+0100)
  0x00, 0xDE, 0x01, 0x02, 0x01, // ÞĂ (U+00DE U+0102)
  0x00, 0xDE, 0x01, 0x04, 0x01, // ÞĄ (U+00DE U+0104)
  0x00, 0xDE, 0x20, 0x1A, 0x03, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x03, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x03, // Þ… (U+00DE U+2026)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x02, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x02, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x54, 0x02, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x62, 0x02, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x02, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x02, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x19, 0x02, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x02, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x02, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x02, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x54, 0x02, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x62, 0x02, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x02, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x02, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x19, 0x02, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x02, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x02, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x02, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x54, 0x02, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x62, 0x02, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x02, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x02, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x19, 0x02, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x02, // Ą” (U+0104 U+201D)
  0x01, 0x0E, 0x00, 0x2C, 0x01, // Ď, (U+010E U+002C)
  0x01, 0x0E, 0x00, 0x2E, 0x01, // Ď. (U+010E U+002E)
  0x01, 0x0E, 0x00, 0x54, 0x01, // ĎT (U+010E U+0054)
  0x01, 0x0E, 0x01, 0x62, 0x01, // ĎŢ (U+010E U+0162)
  0x01, 0x0E, 0x01, 0x64, 0x01, // ĎŤ (U+010E U+0164)
  0x01, 0x0E, 0x01, 0x66, 0x01, // ĎŦ (U+010E U+0166)
  0x01, 0x0E, 0x20, 0x1A, 0x01, // Ď‚ (U+010E U+201A)
  0x01, 0x0E, 0x20, 0x1E, 0x01, // Ď„ (U+010E U+201E)
  0x01, 0x0E, 0x20, 0x26, 0x01, // Ď… (U+010E U+2026)
  0x01, 0x10, 0x00, 0x2C, 0x01, // Đ, (U+0110 U+002C)
  0x01, 0x10, 0x00, 0x2E, 0x01, // Đ. (U+0110 U+002E)
  0x01, 0x10, 0x00, 0x54, 0x01, // ĐT (U+0110 U+0054)
  0x01, 0x10, 0x01, 0x62, 0x01, // ĐŢ (U+0110 U+0162)
  0x01, 0x10, 0x01, 0x64, 0x01, // ĐŤ (U+0110 U+0164)
  0x01, 0x10, 0x01, 0x66, 0x01, // ĐŦ (U+0110 U+0166)
  0x01, 0x10, 0x20, 0x1A, 0x01, // Đ‚ (U+0110 U+201A)
  0x01, 0x10, 0x20, 0x1E, 0x01, // Đ„ (U+0110 U+201E)
  0x01, 0x10, 0x20, 0x26, 0x01, // Đ… (U+0110 U+2026)
  0x01, 0x39, 0x00, 0x22, 0x02, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x02, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x19, 0x02, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x02, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x02, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x02, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x19, 0x02, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x02, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x02, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x02, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x00, 0x59, 0x01, // ĽY (U+013D U+0059)
  0x01, 0x3D, 0x00, 0xDD, 0x01, // ĽÝ (U+013D U+00DD)
  0x01, 0x3D, 0x01, 0x76, 0x01, // ĽŶ (U+013D U+0176)
  0x01, 0x3D, 0x01, 0x78, 0x01, // ĽŸ (U+013D U+0178)
  0x01, 0x3D, 0x20, 0x19, 0x02, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x02, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x02, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x02, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x00, 0x59, 0x01, // ĿY (U+013F U+0059)
  0x01, 0x3F, 0x00, 0xDD, 0x01, // ĿÝ (U+013F U+00DD)
  0x01, 0x3F, 0x01, 0x76, 0x01, // ĿŶ (U+013F U+0176)
  0x01, 0x3F, 0x01, 0x78, 0x01, // ĿŸ (U+013F U+0178)
  0x01, 0x3F, 0x20, 0x19, 0x02, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x02, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x02, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x02, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x19, 0x02, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x02, // Ł” (U+0141 U+201D)
  0x01, 0x4C, 0x00, 0x2C, 0x01, // Ō, (U+014C U+002C)
  0x01, 0x4C, 0x00, 0x2E, 0x01, // Ō. (U+014C U+002E)
  0x01, 0x4C, 0x00, 0x54, 0x01, // ŌT (U+014C U+0054)
  0x01, 0x4C, 0x01, 0x62, 0x01, // ŌŢ (U+014C U+0162)
  0x01, 0x4C, 0x01, 0x64, 0x01, // ŌŤ (U+014C U+0164)
  0x01, 0x4C, 0x01, 0x66, 0x01, // ŌŦ (U+014C U+0166)
  0x01, 0x4C, 0x20, 0x1A, 0x01, // Ō‚ (U+014C U+201A)
  0x01, 0x4C, 0x20, 0x1E, 0x01, // Ō„ (U+014C U+201E)
  0x01, 0x4C, 0x20, 0x26, 0x01, // Ō… (U+014C U+2026)
  0x01, 0x4E, 0x00, 0x2C, 0x01, // Ŏ, (U+014E U+002C)
  0x01, 0x4E, 0x00, 0x2E, 0x01, // Ŏ. (U+014E U+002E)
  0x01, 0x4E, 0x00, 0x54, 0x01, // ŎT (U+014E U+0054)
  0x01, 0x4E, 0x01, 0x62, 0x01, // ŎŢ (U+014E U+0162)
  0x01, 0x4E, 0x01, 0x64, 0x01, // ŎŤ (U+014E U+0164)
  0x01, 0x4E, 0x01, 0x66, 0x01, // ŎŦ (U+014E U+0166)
  0x01, 0x4E, 0x20, 0x1A, 0x01, // Ŏ‚ (U+014E U+201A)
  0x01, 0x4E, 0x20, 0x1E, 0x01, // Ŏ„ (U+014E U+201E)
  0x01, 0x4E, 0x20, 0x26, 0x01, // Ŏ… (U+014E U+2026)
  0x01, 0x50, 0x00, 0x2C, 0x01, // Ő, (U+0150 U+002C)
  0x01, 0x50, 0x00, 0x2E, 0x01, // Ő. (U+0150 U+002E)
  0x01, 0x50, 0x00, 0x54, 0x01, // ŐT (U+0150 U+0054)
  0x01, 0x50, 0x01, 0x62, 0x01, // ŐŢ (U+0150 U+0162)
  0x01, 0x50, 0x01, 0x64, 0x01, // ŐŤ (U+0150 U+0164)
  0x01, 0x50, 0x01, 0x66, 0x01, // ŐŦ (U+0150 U+0166)
  0x01, 0x50, 0x20, 0x1A, 0x01, // Ő‚ (U+0150 U+201A)
  0x01, 0x50, 0x20, 0x1E, 0x01, // Ő„ (U+0150 U+201E)
  0x01, 0x50, 0x20, 0x26, 0x01, // Ő… (U+0150 U+2026)
  0x01, 0x55, 0x00, 0x2C, 0x04, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x04, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x04, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x04, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x04, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x04, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x04, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x04, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x04, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x04, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x04, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x04, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x04, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x04, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x04, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2D, 0x01, // Ţ- (U+0162 U+002D)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x02, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x02, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x02, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x02, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x02, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x02, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x01, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x01, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x02, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x01, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x02, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x01, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x01, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x01, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0x7A, 0x01, // Ţz (U+0162 U+007A)
  0x01, 0x62, 0x00, 0xAB, 0x01, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xBB, 0x01, // Ţ» (U+0162 U+00BB)
  0x01, 0x62, 0x00, 0xC0, 0x02, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x02, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x02, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x02, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x02, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x02, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xE0, 0x02, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x02, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x02, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x02, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x02, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x02, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x02, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x02, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x02, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x02, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x02, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x02, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x02, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x02, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x02, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x02, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x02, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x02, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x01, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x01, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x01, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x01, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x01, 0x00, 0x02, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x02, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x02, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x02, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x02, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x02, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x02, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x02, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x02, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x02, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x02, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x02, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x02, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x02, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x02, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x02, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x02, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x02, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x02, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x02, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x02, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x01, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x01, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x01, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x4B, 0x01, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4D, 0x02, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x02, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x02, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x02, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x01, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x01, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x01, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5F, 0x01, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x69, 0x01, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x01, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x01, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x01, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x01, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x01, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x01, 0x7A, 0x01, // Ţź (U+0162 U+017A)
  0x01, 0x62, 0x01, 0x7C, 0x01, // Ţż (U+0162 U+017C)
  0x01, 0x62, 0x01, 0x7E, 0x01, // Ţž (U+0162 U+017E)
  0x01, 0x62, 0x20, 0x13, 0x01, // Ţ– (U+0162 U+2013)
  0x01, 0x62, 0x20, 0x14, 0x01, // Ţ— (U+0162 U+2014)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x01, // Ţ‹ (U+0162 U+2039)
  0x01, 0x62, 0x20, 0x3A, 0x01, // Ţ› (U+0162 U+203A)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2D, 0x01, // Ť- (U+0164 U+002D)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x02, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x02, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x02, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x02, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x02, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x02, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x01, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x01, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x02, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x01, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x02, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x01, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x01, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x01, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0x7A, 0x01, // Ťz (U+0164 U+007A)
  0x01, 0x64, 0x00, 0xAB, 0x01, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xBB, 0x01, // Ť» (U+0164 U+00BB)
  0x01, 0x64, 0x00, 0xC0, 0x02, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x02, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x02, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x02, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x02, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x02, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xE0, 0x02, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x02, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x02, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x02, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x02, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x02, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x02, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x02, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x02, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x02, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x02, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x02, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x02, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x02, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x02, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x02, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x02, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x02, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x01, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x01, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x01, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x01, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x01, 0x00, 0x02, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x02, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x02, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x02, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x02, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x02, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x02, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x02, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x02, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x02, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x02, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x02, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x02, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x02, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x02, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x02, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x02, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x02, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x02, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x02, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x02, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x01, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x01, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x01, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x4B, 0x01, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4D, 0x02, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x02, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x02, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x02, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x01, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x01, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x01, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5F, 0x01, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x69, 0x01, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x01, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x01, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x01, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x01, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x01, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x01, 0x7A, 0x01, // Ťź (U+0164 U+017A)
  0x01, 0x64, 0x01, 0x7C, 0x01, // Ťż (U+0164 U+017C)
  0x01, 0x64, 0x01, 0x7E, 0x01, // Ťž (U+0164 U+017E)
  0x01, 0x64, 0x20, 0x13, 0x01, // Ť– (U+0164 U+2013)
  0x01, 0x64, 0x20, 0x14, 0x01, // Ť— (U+0164 U+2014)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x01, // Ť‹ (U+0164 U+2039)
  0x01, 0x64, 0x20, 0x3A, 0x01, // Ť› (U+0164 U+203A)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2D, 0x01, // Ŧ- (U+0166 U+002D)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x02, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x02, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x02, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x02, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x02, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x02, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x01, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x01, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x02, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x01, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x02, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x01, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x01, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x01, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0x7A, 0x01, // Ŧz (U+0166 U+007A)
  0x01, 0x66, 0x00, 0xAB, 0x01, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xBB, 0x01, // Ŧ» (U+0166 U+00BB)
  0x01, 0x66, 0x00, 0xC0, 0x02, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x02, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x02, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x02, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x02, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x02, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xE0, 0x02, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x02, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x02, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x02, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x02, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x02, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x02, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x02, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x02, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x02, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x02, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x02, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x02, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x02, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x02, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x02, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x02, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x02, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x01, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x01, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x01, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x01, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x01, 0x00, 0x02, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x02, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x02, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x02, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x02, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x02, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x02, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x02, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x02, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x02, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x02, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x02, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x02, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x02, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x02, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x02, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x02, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x02, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x02, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x02, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x02, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x01, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x01, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x01, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x4B, 0x01, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4D, 0x02, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x02, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x02, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x02, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x01, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x01, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x01, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5F, 0x01, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x69, 0x01, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x01, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x01, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x01, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x01, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x01, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x01, 0x7A, 0x01, // Ŧź (U+0166 U+017A)
  0x01, 0x66, 0x01, 0x7C, 0x01, // Ŧż (U+0166 U+017C)
  0x01, 0x66, 0x01, 0x7E, 0x01, // Ŧž (U+0166 U+017E)
  0x01, 0x66, 0x20, 0x13, 0x01, // Ŧ– (U+0166 U+2013)
  0x01, 0x66, 0x20, 0x14, 0x01, // Ŧ— (U+0166 U+2014)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x01, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x66, 0x20, 0x3A, 0x01, // Ŧ› (U+0166 U+203A)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x41, 0x01, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0xAB, 0x01, // Ŵ« (U+0174 U+00AB)
  0x01, 0x74, 0x00, 0xC0, 0x01, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x01, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x01, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x01, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x01, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x01, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x01, 0x00, 0x01, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x02, 0x01, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x04, 0x01, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x74, 0x20, 0x39, 0x01, // Ŵ‹ (U+0174 U+2039)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x26, 0x01, // Ŷ& (U+0176 U+0026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6D, 0x01, // Ŷm (U+0176 U+006D)
  0x01, 0x76, 0x00, 0x6E, 0x01, // Ŷn (U+0176 U+006E)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x70, 0x01, // Ŷp (U+0176 U+0070)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x72, 0x01, // Ŷr (U+0176 U+0072)
  0x01, 0x76, 0x00, 0x73, 0x01, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0x75, 0x01, // Ŷu (U+0176 U+0075)
  0x01, 0x76, 0x00, 0xAB, 0x02, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xBB, 0x01, // Ŷ» (U+0176 U+00BB)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x00, 0xF9, 0x01, // Ŷù (U+0176 U+00F9)
  0x01, 0x76, 0x00, 0xFA, 0x01, // Ŷú (U+0176 U+00FA)
  0x01, 0x76, 0x00, 0xFB, 0x01, // Ŷû (U+0176 U+00FB)
  0x01, 0x76, 0x00, 0xFC, 0x01, // Ŷü (U+0176 U+00FC)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x38, 0x01, // Ŷĸ (U+0176 U+0138)
  0x01, 0x76, 0x01, 0x44, 0x01, // Ŷń (U+0176 U+0144)
  0x01, 0x76, 0x01, 0x46, 0x01, // Ŷņ (U+0176 U+0146)
  0x01, 0x76, 0x01, 0x4B, 0x01, // Ŷŋ (U+0176 U+014B)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x55, 0x01, // Ŷŕ (U+0176 U+0155)
  0x01, 0x76, 0x01, 0x57, 0x01, // Ŷŗ (U+0176 U+0157)
  0x01, 0x76, 0x01, 0x5B, 0x01, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5F, 0x01, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x69, 0x01, // Ŷũ (U+0176 U+0169)
  0x01, 0x76, 0x01, 0x6B, 0x01, // Ŷū (U+0176 U+016B)
  0x01, 0x76, 0x01, 0x6D, 0x01, // Ŷŭ (U+0176 U+016D)
  0x01, 0x76, 0x01, 0x6F, 0x01, // Ŷů (U+0176 U+016F)
  0x01, 0x76, 0x01, 0x71, 0x01, // Ŷű (U+0176 U+0171)
  0x01, 0x76, 0x01, 0x73, 0x01, // Ŷų (U+0176 U+0173)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x02, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x76, 0x20, 0x3A, 0x01, // Ŷ› (U+0176 U+203A)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x26, 0x01, // Ÿ& (U+0178 U+0026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6D, 0x01, // Ÿm (U+0178 U+006D)
  0x01, 0x78, 0x00, 0x6E, 0x01, // Ÿn (U+0178 U+006E)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x70, 0x01, // Ÿp (U+0178 U+0070)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x72, 0x01, // Ÿr (U+0178 U+0072)
  0x01, 0x78, 0x00, 0x73, 0x01, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0x75, 0x01, // Ÿu (U+0178 U+0075)
  0x01, 0x78, 0x00, 0xAB, 0x02, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xBB, 0x01, // Ÿ» (U+0178 U+00BB)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x00, 0xF9, 0x01, // Ÿù (U+0178 U+00F9)
  0x01, 0x78, 0x00, 0xFA, 0x01, // Ÿú (U+0178 U+00FA)
  0x01, 0x78, 0x00, 0xFB, 0x01, // Ÿû (U+0178 U+00FB)
  0x01, 0x78, 0x00, 0xFC, 0x01, // Ÿü (U+0178 U+00FC)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x38, 0x01, // Ÿĸ (U+0178 U+0138)
  0x01, 0x78, 0x01, 0x44, 0x01, // Ÿń (U+0178 U+0144)
  0x01, 0x78, 0x01, 0x46, 0x01, // Ÿņ (U+0178 U+0146)
  0x01, 0x78, 0x01, 0x4B, 0x01, // Ÿŋ (U+0178 U+014B)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x55, 0x01, // Ÿŕ (U+0178 U+0155)
  0x01, 0x78, 0x01, 0x57, 0x01, // Ÿŗ (U+0178 U+0157)
  0x01, 0x78, 0x01, 0x5B, 0x01, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5F, 0x01, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x69, 0x01, // Ÿũ (U+0178 U+0169)
  0x01, 0x78, 0x01, 0x6B, 0x01, // Ÿū (U+0178 U+016B)
  0x01, 0x78, 0x01, 0x6D, 0x01, // Ÿŭ (U+0178 U+016D)
  0x01, 0x78, 0x01, 0x6F, 0x01, // Ÿů (U+0178 U+016F)
  0x01, 0x78, 0x01, 0x71, 0x01, // Ÿű (U+0178 U+0171)
  0x01, 0x78, 0x01, 0x73, 0x01, // Ÿų (U+0178 U+0173)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x02, // Ÿ‹ (U+0178 U+2039)
  0x01, 0x78, 0x20, 0x3A, 0x01, // Ÿ› (U+0178 U+203A)
  0x20, 0x13, 0x00, 0x54, 0x01, // –T (U+2013 U+0054)
  0x20, 0x13, 0x01, 0x62, 0x01, // –Ţ (U+2013 U+0162)
  0x20, 0x13, 0x01, 0x64, 0x01, // –Ť (U+2013 U+0164)
  0x20, 0x13, 0x01, 0x66, 0x01, // –Ŧ (U+2013 U+0166)
  0x20, 0x14, 0x00, 0x54, 0x01, // —T (U+2014 U+0054)
  0x20, 0x14, 0x01, 0x62, 0x01, // —Ţ (U+2014 U+0162)
  0x20, 0x14, 0x01, 0x64, 0x01, // —Ť (U+2014 U+0164)
  0x20, 0x14, 0x01, 0x66, 0x01, // —Ŧ (U+2014 U+0166)
  0x20, 0x18, 0x00, 0x41, 0x02, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x61, 0x01, // ‘a (U+2018 U+0061)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x67, 0x01, // ‘g (U+2018 U+0067)
  0x20, 0x18, 0x00, 0x6D, 0x01, // ‘m (U+2018 U+006D)
  0x20, 0x18, 0x00, 0x6E, 0x01, // ‘n (U+2018 U+006E)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x70, 0x01, // ‘p (U+2018 U+0070)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0x72, 0x01, // ‘r (U+2018 U+0072)
  0x20, 0x18, 0x00, 0x73, 0x01, // ‘s (U+2018 U+0073)
  0x20, 0x18, 0x00, 0x75, 0x01, // ‘u (U+2018 U+0075)
  0x20, 0x18, 0x00, 0xC0, 0x02, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x02, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x02, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x02, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x02, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x02, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x02, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE1, 0x01, // ‘á (U+2018 U+00E1)
  0x20, 0x18, 0x00, 0xE2, 0x01, // ‘â (U+2018 U+00E2)
  0x20, 0x18, 0x00, 0xE3, 0x01, // ‘ã (U+2018 U+00E3)
  0x20, 0x18, 0x00, 0xE4, 0x01, // ‘ä (U+2018 U+00E4)
  0x20, 0x18, 0x00, 0xE5, 0x01, // ‘å (U+2018 U+00E5)
  0x20, 0x18, 0x00, 0xE6, 0x01, // ‘æ (U+2018 U+00E6)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x00, 0xF9, 0x01, // ‘ù (U+2018 U+00F9)
  0x20, 0x18, 0x00, 0xFA, 0x01, // ‘ú (U+2018 U+00FA)
  0x20, 0x18, 0x00, 0xFB, 0x01, // ‘û (U+2018 U+00FB)
  0x20, 0x18, 0x00, 0xFC, 0x01, // ‘ü (U+2018 U+00FC)
  0x20, 0x18, 0x01, 0x00, 0x02, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x01, 0x01, // ‘ā (U+2018 U+0101)
  0x20, 0x18, 0x01, 0x02, 0x02, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x03, 0x01, // ‘ă (U+2018 U+0103)
  0x20, 0x18, 0x01, 0x04, 0x02, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x05, 0x01, // ‘ą (U+2018 U+0105)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x1D, 0x01, // ‘ĝ (U+2018 U+011D)
  0x20, 0x18, 0x01, 0x1F, 0x01, // ‘ğ (U+2018 U+011F)
  0x20, 0x18, 0x01, 0x21, 0x01, // ‘ġ (U+2018 U+0121)
  0x20, 0x18, 0x01, 0x23, 0x01, // ‘ģ (U+2018 U+0123)
  0x20, 0x18, 0x01, 0x38, 0x01, // ‘ĸ (U+2018 U+0138)
  0x20, 0x18, 0x01, 0x44, 0x01, // ‘ń (U+2018 U+0144)
  0x20, 0x18, 0x01, 0x46, 0x01, // ‘ņ (U+2018 U+0146)
  0x20, 0x18, 0x01, 0x4B, 0x01, // ‘ŋ (U+2018 U+014B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x18, 0x01, 0x55, 0x01, // ‘ŕ (U+2018 U+0155)
  0x20, 0x18, 0x01, 0x57, 0x01, // ‘ŗ (U+2018 U+0157)
  0x20, 0x18, 0x01, 0x5B, 0x01, // ‘ś (U+2018 U+015B)
  0x20, 0x18, 0x01, 0x5F, 0x01, // ‘ş (U+2018 U+015F)
  0x20, 0x18, 0x01, 0x69, 0x01, // ‘ũ (U+2018 U+0169)
  0x20, 0x18, 0x01, 0x6B, 0x01, // ‘ū (U+2018 U+016B)
  0x20, 0x18, 0x01, 0x6D, 0x01, // ‘ŭ (U+2018 U+016D)
  0x20, 0x18, 0x01, 0x6F, 0x01, // ‘ů (U+2018 U+016F)
  0x20, 0x18, 0x01, 0x71, 0x01, // ‘ű (U+2018 U+0171)
  0x20, 0x18, 0x01, 0x73, 0x01, // ‘ų (U+2018 U+0173)
  0x20, 0x19, 0x00, 0x41, 0x02, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x61, 0x01, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x67, 0x01, // ’g (U+2019 U+0067)
  0x20, 0x19, 0x00, 0x6D, 0x01, // ’m (U+2019 U+006D)
  0x20, 0x19, 0x00, 0x6E, 0x01, // ’n (U+2019 U+006E)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x70, 0x01, // ’p (U+2019 U+0070)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0x72, 0x01, // ’r (U+2019 U+0072)
  0x20, 0x19, 0x00, 0x73, 0x01, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0x75, 0x01, // ’u (U+2019 U+0075)
  0x20, 0x19, 0x00, 0xC0, 0x02, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x02, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x02, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x02, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x02, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x02, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x02, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x01, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x01, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x01, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x01, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x01, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x01, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x00, 0xF9, 0x01, // ’ù (U+2019 U+00F9)
  0x20, 0x19, 0x00, 0xFA, 0x01, // ’ú (U+2019 U+00FA)
  0x20, 0x19, 0x00, 0xFB, 0x01, // ’û (U+2019 U+00FB)
  0x20, 0x19, 0x00, 0xFC, 0x01, // ’ü (U+2019 U+00FC)
  0x20, 0x19, 0x01, 0x00, 0x02, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x01, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x02, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x01, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x02, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x01, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x1D, 0x01, // ’ĝ (U+2019 U+011D)
  0x20, 0x19, 0x01, 0x1F, 0x01, // ’ğ (U+2019 U+011F)
  0x20, 0x19, 0x01, 0x21, 0x01, // ’ġ (U+2019 U+0121)
  0x20, 0x19, 0x01, 0x23, 0x01, // ’ģ (U+2019 U+0123)
  0x20, 0x19, 0x01, 0x38, 0x01, // ’ĸ (U+2019 U+0138)
  0x20, 0x19, 0x01, 0x44, 0x01, // ’ń (U+2019 U+0144)
  0x20, 0x19, 0x01, 0x46, 0x01, // ’ņ (U+2019 U+0146)
  0x20, 0x19, 0x01, 0x4B, 0x01, // ’ŋ (U+2019 U+014B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x19, 0x01, 0x55, 0x01, // ’ŕ (U+2019 U+0155)
  0x20, 0x19, 0x01, 0x57, 0x01, // ’ŗ (U+2019 U+0157)
  0x20, 0x19, 0x01, 0x5B, 0x01, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5F, 0x01, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x69, 0x01, // ’ũ (U+2019 U+0169)
  0x20, 0x19, 0x01, 0x6B, 0x01, // ’ū (U+2019 U+016B)
  0x20, 0x19, 0x01, 0x6D, 0x01, // ’ŭ (U+2019 U+016D)
  0x20, 0x19, 0x01, 0x6F, 0x01, // ’ů (U+2019 U+016F)
  0x20, 0x19, 0x01, 0x71, 0x01, // ’ű (U+2019 U+0171)
  0x20, 0x19, 0x01, 0x73, 0x01, // ’ų (U+2019 U+0173)
  0x20, 0x1A, 0x00, 0x43, 0x01, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x01, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x01, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x01, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x02, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x01, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x01, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x01, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x01, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x01, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x01, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x01, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x01, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x01, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x01, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x01, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x01, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x01, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x01, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x01, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x01, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x01, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x01, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x01, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x02, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x02, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x02, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x02, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x61, 0x01, // “a (U+201C U+0061)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x67, 0x01, // “g (U+201C U+0067)
  0x20, 0x1C, 0x00, 0x6D, 0x01, // “m (U+201C U+006D)
  0x20, 0x1C, 0x00, 0x6E, 0x01, // “n (U+201C U+006E)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x70, 0x01, // “p (U+201C U+0070)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0x72, 0x01, // “r (U+201C U+0072)
  0x20, 0x1C, 0x00, 0x73, 0x01, // “s (U+201C U+0073)
  0x20, 0x1C, 0x00, 0x75, 0x01, // “u (U+201C U+0075)
  0x20, 0x1C, 0x00, 0xC0, 0x02, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x02, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x02, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x02, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x02, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x02, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x02, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE1, 0x01, // “á (U+201C U+00E1)
  0x20, 0x1C, 0x00, 0xE2, 0x01, // “â (U+201C U+00E2)
  0x20, 0x1C, 0x00, 0xE3, 0x01, // “ã (U+201C U+00E3)
  0x20, 0x1C, 0x00, 0xE4, 0x01, // “ä (U+201C U+00E4)
  0x20, 0x1C, 0x00, 0xE5, 0x01, // “å (U+201C U+00E5)
  0x20, 0x1C, 0x00, 0xE6, 0x01, // “æ (U+201C U+00E6)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x00, 0xF9, 0x01, // “ù (U+201C U+00F9)
  0x20, 0x1C, 0x00, 0xFA, 0x01, // “ú (U+201C U+00FA)
  0x20, 0x1C, 0x00, 0xFB, 0x01, // “û (U+201C U+00FB)
  0x20, 0x1C, 0x00, 0xFC, 0x01, // “ü (U+201C U+00FC)
  0x20, 0x1C, 0x01, 0x00, 0x02, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x01, 0x01, // “ā (U+201C U+0101)
  0x20, 0x1C, 0x01, 0x02, 0x02, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x03, 0x01, // “ă (U+201C U+0103)
  0x20, 0x1C, 0x01, 0x04, 0x02, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x05, 0x01, // “ą (U+201C U+0105)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x1D, 0x01, // “ĝ (U+201C U+011D)
  0x20, 0x1C, 0x01, 0x1F, 0x01, // “ğ (U+201C U+011F)
  0x20, 0x1C, 0x01, 0x21, 0x01, // “ġ (U+201C U+0121)
  0x20, 0x1C, 0x01, 0x23, 0x01, // “ģ (U+201C U+0123)
  0x20, 0x1C, 0x01, 0x38, 0x01, // “ĸ (U+201C U+0138)
  0x20, 0x1C, 0x01, 0x44, 0x01, // “ń (U+201C U+0144)
  0x20, 0x1C, 0x01, 0x46, 0x01, // “ņ (U+201C U+0146)
  0x20, 0x1C, 0x01, 0x4B, 0x01, // “ŋ (U+201C U+014B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1C, 0x01, 0x55, 0x01, // “ŕ (U+201C U+0155)
  0x20, 0x1C, 0x01, 0x57, 0x01, // “ŗ (U+201C U+0157)
  0x20, 0x1C, 0x01, 0x5B, 0x01, // “ś (U+201C U+015B)
  0x20, 0x1C, 0x01, 0x5F, 0x01, // “ş (U+201C U+015F)
  0x20, 0x1C, 0x01, 0x69, 0x01, // “ũ (U+201C U+0169)
  0x20, 0x1C, 0x01, 0x6B, 0x01, // “ū (U+201C U+016B)
  0x20, 0x1C, 0x01, 0x6D, 0x01, // “ŭ (U+201C U+016D)
  0x20, 0x1C, 0x01, 0x6F, 0x01, // “ů (U+201C U+016F)
  0x20, 0x1C, 0x01, 0x71, 0x01, // “ű (U+201C U+0171)
  0x20, 0x1C, 0x01, 0x73, 0x01, // “ų (U+201C U+0173)
  0x20, 0x1D, 0x00, 0x41, 0x02, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x61, 0x01, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x67, 0x01, // ”g (U+201D U+0067)
  0x20, 0x1D, 0x00, 0x6D, 0x01, // ”m (U+201D U+006D)
  0x20, 0x1D, 0x00, 0x6E, 0x01, // ”n (U+201D U+006E)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x70, 0x01, // ”p (U+201D U+0070)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0x72, 0x01, // ”r (U+201D U+0072)
  0x20, 0x1D, 0x00, 0x73, 0x01, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0x75, 0x01, // ”u (U+201D U+0075)
  0x20, 0x1D, 0x00, 0xC0, 0x02, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x02, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x02, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x02, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x02, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x02, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x02, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x01, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x01, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x01, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x01, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x01, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x01, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x00, 0xF9, 0x01, // ”ù (U+201D U+00F9)
  0x20, 0x1D, 0x00, 0xFA, 0x01, // ”ú (U+201D U+00FA)
  0x20, 0x1D, 0x00, 0xFB, 0x01, // ”û (U+201D U+00FB)
  0x20, 0x1D, 0x00, 0xFC, 0x01, // ”ü (U+201D U+00FC)
  0x20, 0x1D, 0x01, 0x00, 0x02, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x01, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x02, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x01, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x02, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x01, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x1D, 0x01, // ”ĝ (U+201D U+011D)
  0x20, 0x1D, 0x01, 0x1F, 0x01, // ”ğ (U+201D U+011F)
  0x20, 0x1D, 0x01, 0x21, 0x01, // ”ġ (U+201D U+0121)
  0x20, 0x1D, 0x01, 0x23, 0x01, // ”ģ (U+201D U+0123)
  0x20, 0x1D, 0x01, 0x38, 0x01, // ”ĸ (U+201D U+0138)
  0x20, 0x1D, 0x01, 0x44, 0x01, // ”ń (U+201D U+0144)
  0x20, 0x1D, 0x01, 0x46, 0x01, // ”ņ (U+201D U+0146)
  0x20, 0x1D, 0x01, 0x4B, 0x01, // ”ŋ (U+201D U+014B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1D, 0x01, 0x55, 0x01, // ”ŕ (U+201D U+0155)
  0x20, 0x1D, 0x01, 0x57, 0x01, // ”ŗ (U+201D U+0157)
  0x20, 0x1D, 0x01, 0x5B, 0x01, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5F, 0x01, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x69, 0x01, // ”ũ (U+201D U+0169)
  0x20, 0x1D, 0x01, 0x6B, 0x01, // ”ū (U+201D U+016B)
  0x20, 0x1D, 0x01, 0x6D, 0x01, // ”ŭ (U+201D U+016D)
  0x20, 0x1D, 0x01, 0x6F, 0x01, // ”ů (U+201D U+016F)
  0x20, 0x1D, 0x01, 0x71, 0x01, // ”ű (U+201D U+0171)
  0x20, 0x1D, 0x01, 0x73, 0x01, // ”ų (U+201D U+0173)
  0x20, 0x1E, 0x00, 0x43, 0x01, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x01, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x01, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x01, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x02, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x01, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x01, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x01, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x01, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x01, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x01, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x01, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x01, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x01, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x01, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x01, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x01, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x01, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x01, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x01, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x01, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x01, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x01, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x01, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x02, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x02, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x02, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x39, 0x00, 0x54, 0x01, // ‹T (U+2039 U+0054)
  0x20, 0x39, 0x00, 0x59, 0x01, // ‹Y (U+2039 U+0059)
  0x20, 0x39, 0x00, 0xDD, 0x01, // ‹Ý (U+2039 U+00DD)
  0x20, 0x39, 0x01, 0x62, 0x01, // ‹Ţ (U+2039 U+0162)
  0x20, 0x39, 0x01, 0x64, 0x01, // ‹Ť (U+2039 U+0164)
  0x20, 0x39, 0x01, 0x66, 0x01, // ‹Ŧ (U+2039 U+0166)
  0x20, 0x39, 0x01, 0x76, 0x01, // ‹Ŷ (U+2039 U+0176)
  0x20, 0x39, 0x01, 0x78, 0x01, // ‹Ÿ (U+2039 U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x01, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x56, 0x01, // ›V (U+203A U+0056)
  0x20, 0x3A, 0x00, 0x57, 0x01, // ›W (U+203A U+0057)
  0x20, 0x3A, 0x00, 0x59, 0x02, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x02, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x01, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x01, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x01, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x74, 0x01, // ›Ŵ (U+203A U+0174)
  0x20, 0x3A, 0x01, 0x76, 0x02, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x02, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x06, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x06, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x06, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x06, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x06, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x06, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x06, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x06, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x06, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x06, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x1A, 0x07, 0x1A, 0x8B, 0x56, 0x0E, 0xF5, 0x0D, 0xF5, 0x0D, 0xF4, 0x0C, 0xF3, 0x0B, 0xF2, 0x0A,
  0xF2, 0x09, 0xF1, 0x09, 0x92, 0x08, 0x92, 0x07, 0x0E, 0x73, 0x82, 0xCE, 0x53, 0xA8, 0x3A, 0x0C,
  0xE4,
  // """ (U+0022)
  0x81, 0x6F, 0xC2, 0xA8, 0x23, 0x4F, 0xB2, 0x84, 0xEF, 0x13, 0xF9, 0x28, 0x4D, 0xF0, 0x2F, 0x82,
  0x84, 0xBE, 0x01, 0xF7, 0x20, 0xA0, 0xD2, 0x90, 0x62, 0x09, 0x0C, 0x10,
  // "#" (U+0023)
  0x58, 0x12, 0xF9, 0x30, 0xE0, 0xA7, 0x81, 0x5F, 0x62, 0x81, 0x2F, 0x77, 0x81, 0x8F, 0x32, 0x81,
  0x5F, 0x47, 0x0B, 0x93, 0x81, 0x8F, 0x17, 0x0E, 0x0C, 0x30, 0xB0, 0xE4, 0x08, 0xFD, 0x89, 0x6D,
  0x06, 0xBB, 0xCF, 0xDB, 0xBC, 0xFD, 0xBB, 0xA4, 0x81, 0x7F, 0x32, 0x81, 0x5F, 0x57, 0x0A, 0x93,
  0x81, 0x8F, 0x27, 0x0D, 0x0C, 0x30, 0xB0, 0xE4, 0x89, 0x64, 0xBB, 0xBF, 0xEB, 0xBB, 0xFE, 0xBB,
  0xB0, 0x6F, 0xE0, 0x13, 0x81, 0x7F, 0x32, 0x81, 0x5F, 0x57, 0x0A, 0x93, 0x81, 0x8F, 0x27, 0x0C,
  0x0D, 0x30, 0xB0, 0xE7, 0x19, 0x0A, 0x30, 0xE0, 0xC7, 0x81, 0x3F, 0x72, 0x81, 0x1F, 0x95,
  // "$" (U+0024)
  0x50, 0xE0, 0x97, 0x30, 0xE0, 0x97, 0x87, 0x4A, 0xCF, 0xEC, 0xA6, 0x12, 0x09, 0xF9, 0x81, 0xA0,
  0x3A, 0x89, 0x27, 0x2E, 0x91, 0x49, 0x40, 0x7F, 0x92, 0x0E, 0x09, 0x58, 0x17, 0xFA, 0x20, 0xE0,
  0x95, 0x03, 0xA8, 0x26, 0x0E, 0x96, 0x07, 0xC0, 0xA7, 0x03, 0x0B, 0xC0, 0xA0, 0x26, 0x81, 0x1E,
  0xEB, 0x06, 0x68, 0x2E, 0x90, 0x7A, 0x02, 0x50, 0xE0, 0x92, 0x81, 0xCF, 0x55, 0x0E, 0x09, 0x28,
  0x96, 0xDF, 0x46, 0x94, 0x10, 0xEA, 0x4A, 0xFE, 0x08, 0xF9, 0x89, 0x2D, 0x30, 0x16, 0x9B, 0xCF,
  0xD9, 0x57, 0x10, 0xE0, 0x97, 0x30, 0xE0, 0x97, 0x30, 0x60, 0x45,
  // "%" (U+0025)
  0x18, 0x33, 0xCF, 0xD6, 0x68, 0x17, 0xF5, 0x38, 0x51, 0xEF, 0xCE, 0xF5, 0x48, 0x11, 0xEC, 0x48,
  0x56, 0xF7, 0x02, 0xED, 0x48, 0x19, 0xF3, 0x48, 0x1A, 0xF1, 0x28, 0x1A, 0xF1, 0x28, 0x12, 0xFA,
  0x50, 0xC9, 0x38, 0x18, 0xF3, 0x28, 0x1B, 0xF2, 0x50, 0xC0, 0xE3, 0x85, 0x7F, 0x40, 0x4F, 0x86,
  0x0B, 0x93, 0x89, 0x18, 0xF3, 0x0C, 0xE1, 0x4A, 0xB7, 0x28, 0x19, 0xF2, 0x28, 0x5B, 0xF1, 0x6F,
  0x65, 0xC8, 0xA4, 0xA0, 0x5F, 0xA1, 0x5F, 0xC0, 0xED, 0x0D, 0xE4, 0x1B, 0xF3, 0x0B, 0xC8, 0x54,
  0x7F, 0x52, 0xFA, 0x28, 0x14, 0xF8, 0x28, 0x91, 0x7B, 0x93, 0x1E, 0xB0, 0x4F, 0x72, 0x81, 0x1F,
  0xA6, 0x85, 0x9F, 0x30, 0x5F, 0x63, 0x90, 0xB5, 0x81, 0x3F, 0xA2, 0x81, 0x4F, 0x73, 0x90, 0xB5,
  0x81, 0xBF, 0x12, 0x81, 0x2F, 0x92, 0x81, 0x3F, 0x94, 0x81, 0x4F, 0x84, 0x85, 0xEE, 0x10, 0x9F,
  0x54, 0x0D, 0x0E, 0x58, 0x47, 0xFE, 0xDF, 0xD4, 0x81, 0x6F, 0x66, 0x83, 0x7E, 0xEB, 0x21,
  // "&" (U+0026)
  0x38, 0x54, 0xBD, 0xED, 0x81, 0x72, 0x07, 0xA0, 0xD0, 0xCA, 0x0C, 0x72, 0x81, 0xEF, 0x52, 0x82,
  0x2E, 0xF5, 0x70, 0x1A, 0x48, 0x1A, 0xF6, 0x71, 0x81, 0xEF, 0x23, 0x81, 0xDF, 0x37, 0x18, 0x66,
  0xFC, 0x12, 0xCF, 0x97, 0x38, 0x19, 0xFD, 0xA0, 0x77, 0x40, 0x8B, 0x05, 0x73, 0x86, 0x1C, 0xFE,
  0xDF, 0xE2, 0x48, 0x1C, 0xF4, 0x28, 0x7C, 0xFD, 0x21, 0xCF, 0xE2, 0x28, 0x11, 0xFE, 0x28, 0x26,
  0xFE, 0x13, 0x86, 0xBF, 0xE2, 0x07, 0xFA, 0x28, 0x19, 0xF9, 0x58, 0x5B, 0xFE, 0x4E, 0xF3, 0x28,
  0x1B, 0xF8, 0x60, 0xBB, 0x0A, 0x38, 0x19, 0xFC, 0x60, 0x10, 0xEA, 0x03, 0x30, 0x3A, 0x08, 0x40,
  0x50, 0xDB, 0x0E, 0x02, 0x30, 0x7A, 0x82, 0xEC, 0xCE, 0xA8, 0x49, 0x1B, 0xFE, 0x23, 0x86, 0x4A,
  0xEF, 0xEC, 0x82, 0x38, 0x2C, 0xFD, 0x20,
  // "'" (U+0027)
  0x8A, 0x06, 0xFC, 0x4F, 0xB3, 0xF9, 0x2F, 0x81, 0xF7, 0x0F, 0x60,
  // "(" (U+0028)
  0x38, 0x1C, 0xF2, 0x28, 0x18, 0xF8, 0x28, 0x12, 0xFE, 0x38, 0x19, 0xF8, 0x28, 0x21, 0xEF, 0x22,
  0x81, 0x5F, 0xC3, 0x81, 0x8F, 0x93, 0x81, 0xCF, 0x53, 0x81, 0xDF, 0x33, 0xA0, 0x23, 0xA0, 0x13,
  0xA0, 0x23, 0x81, 0xEF, 0x33, 0x81, 0xCF, 0x53, 0x81, 0x9F, 0x83, 0x81, 0x5F, 0xC3, 0x01, 0xA0,
  0x23, 0x81, 0x9F, 0x83, 0x81, 0x3F, 0xE4, 0x81, 0x8F, 0x84, 0x81, 0xCF, 0x20,
  // ")" (U+0029)
  0x82, 0x1E, 0xE1, 0x48, 0x15, 0xFB, 0x58, 0x1B, 0xF5, 0x48, 0x15, 0xFC, 0x58, 0x1E, 0xF3, 0x48,
  0x19, 0xF7, 0x48, 0x16, 0xFB, 0x48, 0x12, 0xFE, 0x5A, 0x01, 0x4A, 0x02, 0x48, 0x1E, 0xF3, 0x48,
  0x1E, 0xF2, 0x4A, 0x01, 0x30, 0x2A, 0x48, 0x15, 0xFB, 0x48, 0x19, 0xF8, 0x48, 0x1E, 0xF3, 0x38,
  0x15, 0xFC, 0x48, 0x1B, 0xF5, 0x38, 0x15, 0xFB, 0x48, 0x1D, 0xE1, 0x30,
  // "*" (U+002A)
  0x48, 0x18, 0xFA, 0x72, 0x81, 0x7F, 0x87, 0x28, 0x15, 0xF7, 0x58, 0x93, 0x75, 0x10, 0x3F, 0x50,
  0x15, 0x80, 0xDA, 0x83, 0xC9, 0xFA, 0xCB, 0x18, 0x37, 0x9A, 0xBE, 0xA8, 0x3B, 0xA9, 0x81, 0x38,
  0x32, 0xEE, 0xF4, 0x78, 0x4D, 0xF2, 0xEE, 0x15, 0x85, 0x9F, 0xA0, 0x8F, 0xC4, 0x03, 0xA8, 0x43,
  0x01, 0xEF, 0x54, 0x01, 0x07, 0x30, 0x60, 0x33,
  // "+" (U+002B)
  0x59, 0x0A, 0x73, 0x90, 0xA7, 0x39, 0x0A, 0x73, 0x90, 0xA7, 0x39, 0x0A, 0x58, 0x93, 0x9B, 0xBB,
  0xBF, 0xEB, 0xBB, 0xB5, 0xCF, 0xB0, 0x75, 0x90, 0xA7, 0x39, 0x0A, 0x73, 0x90, 0xA7, 0x39, 0x0A,
  0x73, 0x90, 0xA5,
  // "," (U+002C)
  0x18, 0x1D, 0xF7, 0x1A, 0x89, 0x53, 0x3F, 0xE0, 0x7F, 0x80, 0xAF, 0x20, 0xDB, 0x20,
  // "-" (U+002D)
  0x80, 0x1B, 0x08, 0xD0, 0xB0,
  // "." (U+002E)
  0x18, 0x2C, 0xE5, 0x3A, 0x83, 0xA0, 0xCE, 0x40,
  // "/" (U+002F)
  0x68, 0x18, 0xF7, 0x68, 0x1E, 0xF1, 0x58, 0x14, 0xFB, 0x68, 0x1A, 0xF5, 0x58, 0x11, 0xFE, 0x68,
  0x16, 0xF9, 0x68, 0x1C, 0xF3, 0x58, 0x13, 0xFD, 0x68, 0x18, 0xF7, 0x68, 0x1E, 0xF1, 0x58, 0x15,
  0xFB, 0x68, 0x1A, 0xF5, 0x58, 0x11, 0xFE, 0x68, 0x17, 0xF9, 0x68, 0x1C, 0xF3, 0x58, 0x13, 0xFD,
  0x68, 0x19, 0xF7, 0x60,
  // "0" (U+0030)
  0x38, 0x48, 0xDF, 0xEB, 0x45, 0x0C, 0xA0, 0xC0, 0xDA, 0x07, 0x38, 0x29, 0xFB, 0x12, 0x84, 0x3E,
  0xF3, 0x01, 0xA0, 0x14, 0x85, 0x6F, 0xB0, 0x5F, 0xB6, 0xA8, 0x21, 0x9F, 0x76, 0x84, 0xCF, 0x4B,
  0xF5, 0x68, 0x4A, 0xF6, 0xCF, 0x46, 0x84, 0x9F, 0x7C, 0xF4, 0x68, 0x49, 0xF8, 0xCF, 0x46, 0x84,
  0x9F, 0x7B, 0xF5, 0x68, 0x4A, 0xF6, 0x8F, 0x76, 0x84, 0xCF, 0x45, 0xFB, 0x6A, 0x00, 0x1A, 0x01,
  0x48, 0x16, 0xFC, 0x28, 0x28, 0xFB, 0x12, 0x82, 0x3E, 0xF5, 0x30, 0xCA, 0x00, 0xCA, 0x08, 0x58,
  0x47, 0xCE, 0xEC, 0x63,
  // "1" (U+0031)
  0x38, 0x21, 0xBF, 0x82, 0x03, 0x0D, 0xA8, 0xA4, 0x80, 0x5E, 0xFC, 0xF8, 0x7F, 0xE5, 0x8F, 0x84,
  0xD2, 0x08, 0xF8, 0x48, 0x18, 0xF8, 0x48, 0x18, 0xF8, 0x48, 0x18, 0xF8, 0x48, 0x18, 0xF8, 0x48,
  0x18, 0xF8, 0x48, 0x18, 0xF8, 0x48, 0x18, 0xF8, 0x48, 0x18, 0xF8, 0x48, 0x18, 0xF8, 0x48, 0x18,
  0xF8, 0x48, 0x18, 0xF8, 0x48, 0x18, 0xF8,
  // "2" (U+0032)
  0x28, 0x55, 0xAD, 0xFE, 0xB5, 0x30, 0x20, 0xCA, 0x81, 0xDC, 0xDA, 0x09, 0x28, 0x23, 0xFA, 0x23,
  0x05, 0xA0, 0x52, 0x02, 0x68, 0x19, 0xFA, 0x72, 0x81, 0x6F, 0xB7, 0x28, 0x17, 0xFA, 0x72, 0x81,
  0xBF, 0x67, 0x18, 0x14, 0xFE, 0x71, 0x82, 0x1E, 0xF5, 0x78, 0x21, 0xDF, 0x87, 0x82, 0x1C, 0xF9,
  0x78, 0x21, 0xCF, 0x97, 0x82, 0x1C, 0xF9, 0x78, 0x21, 0xCF, 0x97, 0x82, 0x1C, 0xF8, 0x71, 0x0B,
  0xA8, 0x04, 0xB0, 0x50, 0xDF, 0xB0, 0x70,
  // "3" (U+0033)
  0x18, 0x61, 0x7B, 0xEF, 0xEC, 0x73, 0x06, 0x0E, 0xA8, 0x1D, 0xCD, 0xA0, 0xC2, 0x82, 0x3E, 0x71,
  0x38, 0x23, 0xEF, 0x87, 0x28, 0x17, 0xFC, 0x72, 0x81, 0x5F, 0xB7, 0x28, 0x1B, 0xF7, 0x68, 0x31,
  0x4B, 0xFA, 0x40, 0x4C, 0x0C, 0x04, 0x58, 0x63, 0xBB, 0xDE, 0xFE, 0x77, 0x28, 0x25, 0xDF, 0x97,
  0x20, 0x2A, 0x02, 0x72, 0x81, 0xDF, 0x57, 0x28, 0x1E, 0xF4, 0x71, 0x03, 0xA8, 0x11, 0xA5, 0x58,
  0x44, 0xDF, 0x90, 0xEA, 0x82, 0xDB, 0xCE, 0xA0, 0xB2, 0x87, 0x39, 0xCD, 0xFE, 0xDA, 0x53,
  // "4" (U+0034)
  0x71, 0x81, 0xCF, 0xB7, 0x30, 0x8A, 0x0B, 0x72, 0x83, 0x3F, 0xCF, 0xB7, 0x18, 0x41, 0xDE, 0x5F,
  0xB7, 0x18, 0x4A, 0xF6, 0x4F, 0xB7, 0x85, 0x6F, 0xA0, 0x4F, 0xB6, 0x81, 0x2E, 0xD2, 0x81, 0x4F,
  0xB6, 0x81, 0xCF, 0x32, 0x81, 0x4F, 0xB5, 0x81, 0x8F, 0x73, 0x81, 0x4F, 0xB4, 0x81, 0x4F, 0xB4,
  0x81, 0x4F, 0xB3, 0x82, 0x1D, 0xE1, 0x48, 0x14, 0xFB, 0x38, 0x17, 0xFE, 0x80, 0x1D, 0x0E, 0xA8,
  0x2D, 0xD3, 0x7F, 0xD0, 0x37, 0x18, 0x14, 0xFB, 0x74, 0x81, 0x4F, 0xB7, 0x48, 0x14, 0xFB, 0x74,
  0x81, 0x4F, 0xB3,
  // "5" (U+0035)
  0x10, 0x7F, 0x90, 0x22, 0x81, 0x8F, 0xD8, 0x02, 0xB0, 0x12, 0x81, 0xAF, 0x47, 0x28, 0x1B, 0xF3,
  0x72, 0x81, 0xCF, 0x27, 0x20, 0xD9, 0x73, 0xA8, 0x48, 0xAB, 0xA8, 0x24, 0x0E, 0xF0, 0x93, 0x81,
  0x14, 0x12, 0x02, 0x07, 0xA0, 0x87, 0x20, 0x5A, 0x01, 0x72, 0x81, 0xEF, 0x47, 0x28, 0x1C, 0xF5,
  0x72, 0x81, 0xEF, 0x37, 0x18, 0x54, 0xFE, 0x05, 0x61, 0x48, 0x45, 0xEF, 0x70, 0x7A, 0x82, 0xDC,
  0xCE, 0xA0, 0x82, 0x87, 0x17, 0xBD, 0xEF, 0xD9, 0x33,
  // "6" (U+0036)
  0x48, 0x53, 0x9D, 0xEF, 0xD3, 0x40, 0xAA, 0x83, 0xEC, 0xCD, 0x43, 0x82, 0xBF, 0xC4, 0x78, 0x16,
  0xFC, 0x72, 0x81, 0xDF, 0x37, 0x18, 0x12, 0xFD, 0x72, 0x89, 0x06, 0xFA, 0x08, 0xDF, 0xEA, 0x32,
  0x86, 0x8F, 0x9D, 0xFC, 0xCE, 0xA8, 0x15, 0x09, 0xA0, 0xB0, 0x23, 0x85, 0x9F, 0xE1, 0xAF, 0xD6,
  0x84, 0xDF, 0x59, 0xF8, 0x68, 0x49, 0xF8, 0x8F, 0x76, 0x84, 0x7F, 0x85, 0xFB, 0x68, 0x59, 0xF7,
  0x0E, 0xF2, 0x58, 0x6D, 0xF3, 0x07, 0xFD, 0x22, 0x82, 0x1A, 0xFC, 0x30, 0x9A, 0x0D, 0x0C, 0xA0,
  0xD0, 0x24, 0x85, 0x5B, 0xEF, 0xD8, 0x12,
  // "7" (U+0037)
  0x0E, 0xFB, 0x08, 0x0A, 0x80, 0x4B, 0x81, 0xEF, 0x77, 0x18, 0x21, 0xEF, 0x17, 0x18, 0x17, 0xFA,
  0x72, 0x81, 0xEF, 0x37, 0x18, 0x16, 0xFB, 0x72, 0x81, 0xDF, 0x47, 0x18, 0x15, 0xFD, 0x72, 0x81,
  0xCF, 0x67, 0x18, 0x14, 0xFE, 0x72, 0x81, 0xBF, 0x77, 0x10, 0x3A, 0x01, 0x71, 0x81, 0xAF, 0x97,
  0x10, 0x2A, 0x02, 0x71, 0x81, 0x9F, 0xB7, 0x18, 0x21, 0xEF, 0x47, 0x18, 0x17, 0xFC, 0x70,
  // "8" (U+0038)
  0x28, 0x62, 0x9D, 0xFE, 0xC7, 0x13, 0x04, 0xA8, 0x1E, 0xCC, 0xA0, 0xD0, 0x22, 0x81, 0xEF, 0x83,
  0x86, 0x1C, 0xFA, 0x03, 0xFE, 0x58, 0x53, 0xFE, 0x02, 0xFD, 0x58, 0x13, 0xFE, 0x28, 0x1D, 0xF3,
  0x48, 0x18, 0xF9, 0x28, 0x90, 0x4F, 0xE6, 0x01, 0x9F, 0xC1, 0x38, 0x54, 0xEF, 0xEE, 0xF8, 0x50,
  0x20, 0xBC, 0x08, 0x48, 0x95, 0x6F, 0xE6, 0x15, 0xCF, 0xD2, 0x03, 0xFE, 0x24, 0x85, 0x8F, 0xD0,
  0xAF, 0x66, 0x84, 0xCF, 0x5C, 0xF4, 0x68, 0x49, 0xF7, 0xBF, 0x76, 0x82, 0xCF, 0x66, 0xA0, 0x53,
  0x85, 0x19, 0xFE, 0x10, 0xAA, 0x82, 0xEC, 0xCE, 0xA0, 0x43, 0x81, 0x4A, 0xDA, 0x81, 0xD9, 0x22,
  // "9" (U+0039)
  0x28, 0x52, 0x9D, 0xFD, 0xA3, 0x48, 0x44, 0xEF, 0xEC, 0xDA, 0x06, 0x28, 0x21, 0xEF, 0x83, 0x86,
  0x4E, 0xF3, 0x06, 0xFB, 0x58, 0x55, 0xFC, 0x0A, 0xF6, 0x68, 0x4E, 0xF1, 0xBF, 0x46, 0x84, 0xAF,
  0x5B, 0xF6, 0x68, 0x4B, 0xF6, 0x8F, 0xB5, 0x03, 0xA0, 0x70, 0x2A, 0x89, 0x19, 0x20, 0x17, 0xEE,
  0xF6, 0x05, 0xE8, 0x27, 0xBF, 0x52, 0x89, 0x02, 0x8A, 0xB8, 0x30, 0xEF, 0x37, 0x18, 0x11, 0xFE,
  0x72, 0x81, 0x7F, 0xA7, 0x18, 0x22, 0xEF, 0x27, 0x82, 0x6E, 0xF7, 0x38, 0x28, 0xCB, 0xCB, 0x07,
  0x48, 0x57, 0xEF, 0xEC, 0x82, 0x40,
  // ":" (U+003A)
  0x18, 0x2C, 0xE5, 0x3A, 0x83, 0xA0, 0xCE, 0x57, 0x77, 0x71, 0x82, 0xCE, 0x53, 0xA8, 0x3A, 0x0C,
  0xE4,
  // ";" (U+003B)
  0x18, 0x41, 0xCE, 0x40, 0x4A, 0x84, 0x90, 0x1C, 0xE4, 0x80, 0xC0, 0x00, 0x1A, 0x81, 0x40, 0x4A,
  0x28, 0x17, 0xFA, 0x28, 0x1A, 0xF5, 0x20, 0x0E, 0x28, 0x12, 0xF8, 0x20,
  // "<" (U+003C)
  0x73, 0x01, 0x03, 0x71, 0x82, 0x19, 0xF7, 0x60, 0x10, 0x9A, 0x0B, 0x03, 0x40, 0x10, 0x9A, 0x0A,
  0x03, 0x40, 0x10, 0x9A, 0x09, 0x02, 0x40, 0x10, 0x9A, 0x09, 0x01, 0x68, 0x2C, 0xFD, 0x27, 0x18,
  0x45, 0xCF, 0xE9, 0x27, 0x10, 0x40, 0xAA, 0x0B, 0x05, 0x71, 0x85, 0x29, 0xEF, 0xD7, 0x17, 0x81,
  0x17, 0xDA, 0x05, 0x72, 0x81, 0x5C, 0x70,
  // "=" (U+003D)
  0x07, 0x80, 0x6B, 0x04, 0x0A, 0xFB, 0x05, 0x80, 0xC0, 0x00, 0x78, 0x06, 0xB0, 0x40, 0xAF, 0xB0,
  0x50,
  // ">" (U+003E)
  0x04, 0x74, 0x81, 0xCE, 0x67, 0x28, 0x35, 0xDF, 0xE6, 0x72, 0x83, 0x5D, 0xFE, 0x77, 0x28, 0x35,
  0xCF, 0xE7, 0x72, 0x83, 0x4B, 0xFE, 0x77, 0x20, 0x5A, 0x07, 0x60, 0x40, 0xAA, 0x0A, 0x02, 0x38,
  0x51, 0x6D, 0xFE, 0x82, 0x38, 0x43, 0x9E, 0xFD, 0x75, 0x0A, 0xA0, 0xB0, 0x57, 0x81, 0xCA, 0x37,
  0x20,
  // "?" (U+003F)
  0x18, 0x15, 0xAD, 0xA0, 0xD0, 0x82, 0x08, 0xA8, 0x1D, 0xCC, 0xA8, 0x3D, 0x01, 0x92, 0x38, 0x21,
  0xCF, 0x77, 0x81, 0x5F, 0xB7, 0x81, 0x4F, 0xB7, 0x81, 0x9F, 0x86, 0x82, 0x6F, 0xE1, 0x58, 0x28,
  0xFD, 0x25, 0x82, 0x9F, 0xC1, 0x58, 0x23, 0xFC, 0x16, 0x81, 0x8F, 0x37, 0x81, 0x9F, 0x17, 0x00,
  0x17, 0x74, 0x81, 0xBE, 0x66, 0x02, 0xA0, 0xB7, 0x81, 0xBE, 0x54,
  // "@" (U+0040)
  0x68, 0x74, 0x8C, 0xEF, 0xDC, 0x82, 0x72, 0x04, 0x0C, 0xA8, 0x3E, 0xCB, 0xDE, 0xA0, 0xA0, 0x16,
  0x06, 0xA0, 0x80, 0x25, 0x83, 0x4B, 0xFD, 0x14, 0x82, 0x5F, 0xD3, 0x72, 0x81, 0x7F, 0xB3, 0x82,
  0x2F, 0xE1, 0x28, 0x53, 0xAE, 0xFD, 0xB7, 0x28, 0x18, 0xF6, 0x28, 0x19, 0xF4, 0x20, 0x5A, 0x83,
  0xDC, 0xDF, 0xE2, 0x81, 0x1F, 0xC2, 0x90, 0xC2, 0x82, 0x1E, 0xE4, 0x30, 0xE0, 0xD3, 0x84, 0xAF,
  0x04, 0xF7, 0x28, 0x17, 0xF7, 0x49, 0x0C, 0x38, 0x49, 0xF2, 0x7F, 0x42, 0x81, 0xBF, 0x24, 0x90,
  0xB3, 0x84, 0x8F, 0x28, 0xF2, 0x28, 0x1C, 0xF1, 0x38, 0x12, 0xFB, 0x38, 0x49, 0xF0, 0x9F, 0x22,
  0x81, 0xAF, 0x33, 0x81, 0x6F, 0xB3, 0x84, 0xDD, 0x08, 0xF3, 0x28, 0x16, 0xFA, 0x28, 0x21, 0xDE,
  0xE2, 0x85, 0x7F, 0x70, 0x5F, 0x73, 0x89, 0x2D, 0xFE, 0xCF, 0xD3, 0xFE, 0xCF, 0xD2, 0x81, 0x1F,
  0xC3, 0x89, 0x22, 0xAE, 0xEA, 0x10, 0x6E, 0xEA, 0x13, 0x81, 0xAF, 0x67, 0x73, 0x82, 0x1D, 0xF6,
  0x77, 0x38, 0x43, 0xEF, 0xC6, 0x23, 0x82, 0x25, 0x97, 0x71, 0x01, 0x0A, 0xFA, 0x06, 0x73, 0x86,
  0x16, 0x9B, 0xBA, 0x85, 0x70,
  // "A" (U+0041)
  0x68, 0x17, 0xFC, 0x76, 0x0D, 0xA0, 0x37, 0x48, 0x34, 0xFD, 0xF9, 0x74, 0x83, 0xAF, 0x5E, 0xE7,
  0x38, 0x51, 0xFE, 0x0A, 0xF6, 0x72, 0x85, 0x7F, 0x90, 0x4F, 0xC7, 0x28, 0x1D, 0xF4, 0x28, 0x1E,
  0xF2, 0x78, 0x13, 0xFD, 0x38, 0x18, 0xF9, 0x78, 0x1A, 0xF7, 0x38, 0x12, 0xFE, 0x60, 0x1A, 0x02,
  0x48, 0x1C, 0xF5, 0x50, 0x6F, 0xA0, 0xB5, 0x0C, 0x98, 0x03, 0xEA, 0x02, 0x38, 0x13, 0xFE, 0x78,
  0x1B, 0xF8, 0x38, 0x19, 0xF9, 0x78, 0x15, 0xFE, 0x38, 0x1E, 0xF2, 0x71, 0x85, 0xEF, 0x50, 0x6F,
  0xC7, 0x28, 0x58, 0xFB, 0x0C, 0xF6, 0x72, 0x02, 0xA0, 0x10,
  // "B" (U+0042)
  0x0A, 0xD8, 0x2E, 0xC9, 0x43, 0x86, 0xAF, 0xDB, 0xBB, 0xCE, 0xA0, 0xA2, 0x81, 0xAF, 0x75, 0x07,
  0xA8, 0x36, 0x0A, 0xF7, 0x68, 0x5A, 0xFA, 0x0A, 0xF7, 0x68, 0x58, 0xFA, 0x0A, 0xF7, 0x68, 0x5B,
  0xF7, 0x0A, 0xF7, 0x58, 0x96, 0x6F, 0xE1, 0x0A, 0xFD, 0xBB, 0xBC, 0xEE, 0xA1, 0x20, 0xAF, 0x81,
  0xD9, 0x32, 0x81, 0xAF, 0x74, 0x02, 0x07, 0xA8, 0x35, 0x0A, 0xF7, 0x68, 0x57, 0xFE, 0x0A, 0xF7,
  0x60, 0x1A, 0x82, 0x3A, 0xF7, 0x60, 0x1A, 0x82, 0x4A, 0xF7, 0x60, 0x5A, 0x82, 0x1A, 0xF7, 0x58,
  0x93, 0x3E, 0xFB, 0x0A, 0xFD, 0xBB, 0xBC, 0xDA, 0x82, 0xC1, 0x0A, 0xE8, 0x1E, 0xB6, 0x30,
  // "C" (U+0043)
  0x48, 0x71, 0x7B, 0xEF, 0xEC, 0xA5, 0x40, 0x50, 0xEA, 0x81, 0xDC, 0xCB, 0x02, 0x20, 0x7A, 0x09,
  0x01, 0x40, 0x60, 0x82, 0x03, 0xA0, 0x67, 0x38, 0x1B, 0xFA, 0x73, 0x01, 0xA0, 0x37, 0x38, 0x15,
  0xFE, 0x74, 0x81, 0x6F, 0xC7, 0x48, 0x17, 0xFB, 0x74, 0x81, 0x6F, 0xC7, 0x48, 0x15, 0xFE, 0x74,
  0x02, 0xA0, 0x37, 0x48, 0x1C, 0xF9, 0x74, 0x05, 0xA0, 0x57, 0x40, 0xAA, 0x08, 0x01, 0x40, 0x10,
  0x34, 0x09, 0xB8, 0x4D, 0xBC, 0xDF, 0xB5, 0x82, 0x39, 0xDE, 0xA8, 0x1D, 0xA5, 0x10,
  // "D" (U+0044)
  0x0A, 0xD8, 0x2E, 0xC9, 0x34, 0x85, 0xAF, 0xDB, 0xBB, 0xDB, 0x0B, 0x01, 0x28, 0x1A, 0xF7, 0x58,
  0x75, 0xDF, 0xE1, 0x0A, 0xF7, 0x78, 0x5C, 0xFC, 0x0A, 0xF7, 0x70, 0x1A, 0x82, 0x5A, 0xF7, 0x71,
  0x84, 0xAF, 0xAA, 0xF7, 0x71, 0x84, 0x6F, 0xEA, 0xF7, 0x71, 0x04, 0xA8, 0x1A, 0xF7, 0x71, 0x03,
  0xA8, 0x1A, 0xF7, 0x71, 0x04, 0xA8, 0x1A, 0xF7, 0x71, 0x84, 0x6F, 0xDA, 0xF7, 0x71, 0x84, 0xBF,
  0x9A, 0xF7, 0x70, 0x3A, 0x82, 0x4A, 0xF7, 0x68, 0x61, 0xDF, 0xB0, 0xAF, 0x74, 0x89, 0x41, 0x7E,
  0xFD, 0x10, 0xAF, 0xDB, 0xBC, 0xDB, 0x0A, 0x01, 0x20, 0xAD, 0x82, 0xEC, 0x82, 0x40,
  // "E" (U+0045)
  0x0A, 0xF9, 0x82, 0xEA, 0xFD, 0x80, 0x2B, 0x82, 0xAA, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7,
  0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xFD, 0x80, 0x2B, 0x05, 0x0A, 0xF9, 0x82, 0x7A,
  0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7,
  0x78, 0x1A, 0xFD, 0x80, 0x2B, 0x00, 0xAF, 0x90, 0xE0,
  // "F" (U+0046)
  0x0A, 0xF9, 0x82, 0xEA, 0xFD, 0x80, 0x2B, 0x82, 0xAA, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7,
  0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x70, 0xAF, 0x98, 0x27, 0xAF, 0xD8, 0x02,
  0xB8, 0x25, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77,
  0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77,
  // "G" (U+0047)
  0x58, 0x75, 0xAD, 0xEF, 0xDC, 0x95, 0x40, 0x30, 0xDA, 0x82, 0xEC, 0xBD, 0xB0, 0x32, 0x04, 0xA0,
  0xB0, 0x35, 0x05, 0x08, 0x28, 0x22, 0xEF, 0x87, 0x48, 0x1B, 0xFB, 0x74, 0x01, 0xA0, 0x37, 0x48,
  0x15, 0xFE, 0x75, 0x81, 0x7F, 0xC7, 0x58, 0x17, 0xFB, 0x50, 0x3D, 0x82, 0xA6, 0xFC, 0x58, 0x90,
  0x2B, 0xBB, 0xDF, 0xA5, 0xFE, 0x72, 0x82, 0x7F, 0xA1, 0xA0, 0x37, 0x18, 0x57, 0xFA, 0x0C, 0xFA,
  0x71, 0x83, 0x7F, 0xA0, 0x4A, 0x06, 0x78, 0x17, 0xFA, 0x20, 0x8A, 0x09, 0x02, 0x58, 0x18, 0xFA,
  0x30, 0x6B, 0x83, 0xEC, 0xBC, 0xEA, 0x0A, 0x48, 0x22, 0x8C, 0xEA, 0x83, 0xED, 0xA7, 0x20,
  // "H" (U+0048)
  0x81, 0xAF, 0x77, 0x18, 0x4B, 0xF6, 0xAF, 0x77, 0x18, 0x4B, 0xF6, 0xAF, 0x77, 0x18, 0x4B, 0xF6,
  0xAF, 0x77, 0x18, 0x4B, 0xF6, 0xAF, 0x77, 0x18, 0x4B, 0xF6, 0xAF, 0x77, 0x18, 0x4B, 0xF6, 0xAF,
  0x77, 0x18, 0x4B, 0xF6, 0xAF, 0xD8, 0x04, 0xB8, 0x2E, 0xF6, 0xAF, 0xD8, 0x26, 0xAF, 0x77, 0x18,
  0x4B, 0xF6, 0xAF, 0x77, 0x18, 0x4B, 0xF6, 0xAF, 0x77, 0x18, 0x4B, 0xF6, 0xAF, 0x77, 0x18, 0x4B,
  0xF6, 0xAF, 0x77, 0x18, 0x4B, 0xF6, 0xAF, 0x77, 0x18, 0x4B, 0xF6, 0xAF, 0x77, 0x18, 0x4B, 0xF6,
  0xAF, 0x77, 0x18, 0x1B, 0xF6,
  // "I" (U+0049)
  0xE8, 0x12, 0x9C, 0xA8, 0x1D, 0x91, 0x2A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02,
  0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02,
  0x20, 0x50, 0x9A, 0x09, 0x05, 0x1E, 0x02,
  // "J" (U+004A)
  0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48,
  0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C,
  0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5,
  0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x91, 0xEF, 0x31, 0x02, 0xAF, 0xD0, 0xDB, 0x86, 0xE3,
  0x08, 0xBA, 0x71, 0x20,
  // "K" (U+004B)
  0x81, 0xAF, 0x76, 0x85, 0x5F, 0xE3, 0xAF, 0x75, 0x04, 0xA8, 0x34, 0x0A, 0xF7, 0x48, 0x23, 0xEF,
  0x52, 0x81, 0xAF, 0x73, 0x82, 0x1E, 0xF6, 0x38, 0x1A, 0xF7, 0x28, 0x21, 0xDF, 0x84, 0x81, 0xAF,
  0x72, 0x81, 0xCF, 0x95, 0x85, 0xAF, 0x70, 0xAF, 0xB6, 0x84, 0xAF, 0x79, 0xFE, 0x78, 0x1A, 0xFD,
  0xB0, 0x76, 0x0A, 0xA0, 0x90, 0x6A, 0x04, 0x58, 0x1A, 0xF9, 0x28, 0x29, 0xFE, 0x14, 0x81, 0xAF,
  0x73, 0x81, 0xCF, 0xB4, 0x81, 0xAF, 0x73, 0x82, 0x2E, 0xF7, 0x38, 0x1A, 0xF7, 0x40, 0x5A, 0x03,
  0x28, 0x1A, 0xF7, 0x58, 0x69, 0xFD, 0x10, 0xAF, 0x76, 0x85, 0xCF, 0xB0, 0xAF, 0x76, 0x82, 0x2E,
  0xF7,
  // "L" (U+004C)
  0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81,
  0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF,
  0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x0A, 0x98, 0x03,
  0xE0, 0xD0, 0xAF, 0xA0,
  // "M" (U+004D)
  0x0A, 0xA0, 0xA7, 0x30, 0xEA, 0x06, 0x0A, 0xB0, 0x17, 0x10, 0x4B, 0x84, 0x6A, 0xFD, 0xF7, 0x71,
  0x89, 0x0A, 0xFD, 0xF6, 0xAF, 0x8F, 0xD7, 0x89, 0x21, 0xFD, 0x9F, 0x6A, 0xF4, 0xDF, 0x36, 0x89,
  0x27, 0xF8, 0xAF, 0x6A, 0xF4, 0x8F, 0x96, 0x89, 0x2D, 0xF2, 0xAF, 0x6A, 0xF4, 0x2F, 0xE5, 0x89,
  0x43, 0xFB, 0x0A, 0xF6, 0xAF, 0x40, 0xBF, 0x54, 0x89, 0x49, 0xF5, 0x0A, 0xF6, 0xAF, 0x40, 0x5F,
  0xB4, 0x00, 0xE2, 0x84, 0xAF, 0x6A, 0xF4, 0x28, 0x1E, 0xF1, 0x28, 0x16, 0xF9, 0x28, 0x4A, 0xF6,
  0xAF, 0x42, 0x81, 0x9F, 0x72, 0x81, 0xCF, 0x22, 0x84, 0xAF, 0x6A, 0xF4, 0x28, 0x53, 0xFD, 0x02,
  0xFC, 0x38, 0x4A, 0xF6, 0xAF, 0x43, 0x84, 0xCF, 0x38, 0xF6, 0x38, 0x4A, 0xF6, 0xAF, 0x43, 0x83,
  0x7F, 0x9E, 0xE4, 0x84, 0xAF, 0x6A, 0xF4, 0x30, 0x1B, 0x09, 0x48, 0x4A, 0xF6, 0xAF, 0x44, 0x0A,
  0xA0, 0x34, 0x84, 0xAF, 0x6A, 0xF4, 0x48, 0x14, 0xFD, 0x58, 0x1A, 0xF6,
  // "N" (U+004E)
  0x0A, 0xA0, 0x27, 0x82, 0x1F, 0xEA, 0xA0, 0xC7, 0x82, 0x1F, 0xEA, 0xB0, 0x66, 0x87, 0x1F, 0xEA,
  0xFA, 0xFE, 0x15, 0x87, 0x1F, 0xEA, 0xF3, 0xCF, 0xB5, 0x85, 0x1F, 0xEA, 0xF3, 0x3A, 0x05, 0x48,
  0x91, 0x1F, 0xEA, 0xF4, 0x08, 0xFE, 0x13, 0x84, 0x1F, 0xEA, 0xF4, 0x28, 0x1D, 0xFA, 0x38, 0x41,
  0xFE, 0xAF, 0x42, 0x03, 0xA0, 0x42, 0x84, 0x1F, 0xEA, 0xF4, 0x38, 0x18, 0xFD, 0x28, 0x41, 0xFE,
  0xAF, 0x44, 0x89, 0x0D, 0xF9, 0x01, 0xFE, 0xAF, 0x44, 0x03, 0xA8, 0x53, 0x1F, 0xEA, 0xF4, 0x58,
  0x78, 0xFD, 0x0F, 0xEA, 0xF4, 0x68, 0x6D, 0xF8, 0xFE, 0xAF, 0x46, 0x04, 0xB8, 0x2E, 0xAF, 0x47,
  0x09, 0xA8, 0x2E, 0xAF, 0x47, 0x18, 0x1D, 0xFE,
  // "O" (U+004F)
  0x48, 0x73, 0x9C, 0xEF, 0xEC, 0x71, 0x70, 0x8B, 0x81, 0xCB, 0xDA, 0x0E, 0x04, 0x58, 0x2A, 0xFE,
  0x64, 0x01, 0x08, 0xA0, 0x53, 0x05, 0xA0, 0x37, 0x82, 0x6F, 0xE1, 0x28, 0x1C, 0xF8, 0x72, 0x83,
  0xCF, 0x80, 0x2A, 0x02, 0x72, 0x85, 0x6F, 0xD0, 0x5F, 0xE7, 0x30, 0x2A, 0x82, 0x16, 0xFC, 0x74,
  0xA8, 0x22, 0x7F, 0xB7, 0x4A, 0x82, 0x36, 0xFC, 0x74, 0xA8, 0x22, 0x5F, 0xE7, 0x30, 0x2A, 0x00,
  0x1A, 0x02, 0x72, 0x81, 0x6F, 0xD2, 0x81, 0xCF, 0x87, 0x28, 0x1C, 0xF8, 0x20, 0x5A, 0x03, 0x78,
  0x26, 0xFE, 0x13, 0x82, 0xAF, 0xE6, 0x40, 0x10, 0x8A, 0x05, 0x50, 0x8B, 0x81, 0xCB, 0xDA, 0x0E,
  0x04, 0x78, 0x73, 0x9C, 0xEF, 0xEC, 0x71, 0x40,
  // "P" (U+0050)
  0x0A, 0xD8, 0x1D, 0xB6, 0x38, 0x5A, 0xFD, 0xBB, 0xCE, 0xA8, 0x4D, 0x10, 0xAF, 0x74, 0x86, 0x4D,
  0xFB, 0x0A, 0xF7, 0x50, 0x3A, 0x82, 0x1A, 0xF7, 0x6A, 0x82, 0x4A, 0xF7, 0x6A, 0x82, 0x3A, 0xF7,
  0x58, 0x54, 0xFE, 0x0A, 0xF7, 0x48, 0x92, 0x5E, 0xF8, 0x0A, 0xFD, 0xBB, 0xCE, 0xA0, 0x92, 0x0A,
  0xC8, 0x2E, 0xD9, 0x33, 0x81, 0xAF, 0x77, 0x28, 0x1A, 0xF7, 0x72, 0x81, 0xAF, 0x77, 0x28, 0x1A,
  0xF7, 0x72, 0x81, 0xAF, 0x77, 0x28, 0x1A, 0xF7, 0x72, 0x81, 0xAF, 0x77, 0x20,
  // "Q" (U+0051)
  0x48, 0x73, 0x9C, 0xEF, 0xEC, 0x71, 0x70, 0x8B, 0x81, 0xCB, 0xDA, 0x0E, 0x04, 0x58, 0x2A, 0xFE,
  0x64, 0x01, 0x08, 0xA0, 0x53, 0x05, 0xA0, 0x37, 0x82, 0x6F, 0xE1, 0x28, 0x1C, 0xF8, 0x72, 0x83,
  0xCF, 0x80, 0x2A, 0x02, 0x72, 0x85, 0x6F, 0xD0, 0x5F, 0xE7, 0x30, 0x2A, 0x82, 0x16, 0xFC, 0x74,
  0xA8, 0x22, 0x7F, 0xB7, 0x4A, 0x82, 0x46, 0xFC, 0x74, 0xA8, 0x23, 0x5F, 0xE7, 0x30, 0x2A, 0x00,
  0x1A, 0x02, 0x72, 0x81, 0x6F, 0xD2, 0x81, 0xCF, 0x87, 0x28, 0x1C, 0xF8, 0x20, 0x5A, 0x03, 0x70,
  0x6A, 0x01, 0x38, 0x2A, 0xFE, 0x64, 0x01, 0x08, 0xA0, 0x65, 0x08, 0xB8, 0x1C, 0xBD, 0xA0, 0xE0,
  0x67, 0x82, 0x39, 0xCE, 0xB0, 0xA0, 0x17, 0x68, 0x29, 0xFE, 0x27, 0x78, 0x2B, 0xFE, 0x27, 0x68,
  0x31, 0xDF, 0xD1, 0x76, 0x83, 0x2E, 0xFC, 0x11,
  // "R" (U+0052)
  0x0A, 0xD8, 0x1E, 0xB7, 0x48, 0x5A, 0xFD, 0xBB, 0xCD, 0xA0, 0xD0, 0x22, 0x81, 0xAF, 0x74, 0x82,
  0x3D, 0xFB, 0x28, 0x1A, 0xF7, 0x50, 0x3A, 0x83, 0x10, 0xAF, 0x76, 0xA8, 0x34, 0x0A, 0xF7, 0x6A,
  0x83, 0x30, 0xAF, 0x75, 0x81, 0x4F, 0xE2, 0x81, 0xAF, 0x74, 0x82, 0x3D, 0xF8, 0x28, 0x5A, 0xFD,
  0xBB, 0xBD, 0xA0, 0x83, 0x0A, 0xF0, 0x24, 0x81, 0xAF, 0x73, 0x81, 0xCF, 0x84, 0x81, 0xAF, 0x73,
  0x03, 0xA0, 0x23, 0x81, 0xAF, 0x74, 0x81, 0x9F, 0xB3, 0x81, 0xAF, 0x74, 0x82, 0x1E, 0xF6, 0x28,
  0x1A, 0xF7, 0x58, 0x66, 0xFE, 0x10, 0xAF, 0x76, 0x85, 0xCF, 0x90, 0xAF, 0x76, 0x03, 0xA0, 0x30,
  // "S" (U+0053)
  0x28, 0x91, 0x29, 0xDE, 0xED, 0xB7, 0x20, 0x6A, 0x82, 0xEC, 0xCE, 0xA0, 0x60, 0x2A, 0x07, 0x48,
  0x43, 0x91, 0x7F, 0xC7, 0x18, 0x18, 0xFA, 0x71, 0x82, 0x6F, 0xE1, 0x78, 0x31, 0xEF, 0xD4, 0x70,
  0x30, 0xEA, 0x0C, 0x06, 0x68, 0x11, 0x9E, 0xA0, 0xE0, 0x87, 0x06, 0x0C, 0xA0, 0xD0, 0x17, 0x82,
  0x4E, 0xF9, 0x71, 0x81, 0x5F, 0xE7, 0x10, 0x2A, 0x71, 0x83, 0x5F, 0xD7, 0x45, 0x83, 0x4E, 0xF7,
  0xCA, 0x82, 0xDC, 0xCE, 0xA8, 0x49, 0x04, 0xAC, 0xEA, 0x81, 0xDA, 0x42,
  // "T" (U+0054)
  0x0B, 0xFD, 0x87, 0x18, 0xBB, 0xBB, 0xDF, 0xE8, 0x01, 0xB6, 0x81, 0x6F, 0xB7, 0x48, 0x16, 0xFB,
  0x74, 0x81, 0x6F, 0xB7, 0x48, 0x16, 0xFB, 0x74, 0x81, 0x6F, 0xB7, 0x48, 0x16, 0xFB, 0x74, 0x81,
  0x6F, 0xB7, 0x48, 0x16, 0xFB, 0x74, 0x81, 0x6F, 0xB7, 0x48, 0x16, 0xFB, 0x74, 0x81, 0x6F, 0xB7,
  0x48, 0x16, 0xFB, 0x74, 0x81, 0x6F, 0xB7, 0x48, 0x16, 0xFB, 0x74, 0x81, 0x6F, 0xB6,
  // "U" (U+0055)
  0x81, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5,
  0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF,
  0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47,
  0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xCF, 0x57, 0x18, 0x4C, 0xF4, 0x9F, 0x87, 0x1A,
  0x83, 0x25, 0xFE, 0x16, 0x81, 0x7F, 0xC2, 0x82, 0xCF, 0xC2, 0x40, 0x6A, 0x04, 0x20, 0x10, 0xCA,
  0x85, 0xDB, 0xCE, 0xFE, 0x55, 0x86, 0x6B, 0xEF, 0xEC, 0x82, 0x30,
  // "V" (U+0056)
  0x81, 0xCF, 0x67, 0x10, 0x1A, 0x82, 0x37, 0xFC, 0x71, 0x83, 0x6F, 0xD0, 0x1A, 0x02, 0x78, 0x1B,
  0xF7, 0x28, 0x1B, 0xF7, 0x60, 0x1A, 0x02, 0x28, 0x15, 0xFD, 0x68, 0x17, 0xFC, 0x48, 0x1E, 0xF3,
  0x58, 0x1C, 0xF6, 0x48, 0x1A, 0xF8, 0x40, 0x2A, 0x01, 0x48, 0x14, 0xFD, 0x48, 0x18, 0xFA, 0x68,
  0x1E, 0xF4, 0x38, 0x1D, 0xF5, 0x68, 0x19, 0xF9, 0x28, 0x13, 0xFE, 0x78, 0x13, 0xFE, 0x28, 0x19,
  0xF9, 0x71, 0x85, 0xDF, 0x40, 0xEF, 0x47, 0x18, 0x47, 0xF9, 0x3F, 0xD7, 0x28, 0x42, 0xFE, 0x8F,
  0x87, 0x38, 0x3C, 0xFD, 0xF2, 0x73, 0x06, 0xA0, 0xC7, 0x40, 0x1A, 0x07, 0x60,
  // "W" (U+0057)
  0x81, 0x9F, 0xA6, 0x03, 0xA0, 0x56, 0x84, 0x5F, 0xD5, 0xFE, 0x60, 0x7A, 0x09, 0x68, 0x29, 0xF9,
  0x1A, 0x02, 0x50, 0xCA, 0x0E, 0x68, 0x5D, 0xF5, 0x0C, 0xF6, 0x48, 0x41, 0xFE, 0xBF, 0x34, 0x02,
  0xA8, 0x31, 0x08, 0xFA, 0x48, 0x45, 0xFA, 0x7F, 0x84, 0x81, 0x6F, 0xC2, 0x81, 0x3F, 0xE4, 0x84,
  0xAF, 0x63, 0xFD, 0x48, 0x1A, 0xF8, 0x38, 0x1E, 0xF3, 0x38, 0x5E, 0xF2, 0x0E, 0xF2, 0x38, 0x1D,
  0xF4, 0x38, 0x1B, 0xF7, 0x28, 0x13, 0xFC, 0x28, 0x19, 0xF7, 0x20, 0x2A, 0x48, 0x16, 0xFB, 0x28,
  0x18, 0xF8, 0x28, 0x15, 0xFC, 0x28, 0x16, 0xFB, 0x48, 0x12, 0xFE, 0x28, 0x1C, 0xF3, 0x3A, 0x83,
  0x10, 0xAF, 0x75, 0x84, 0xEF, 0x31, 0xFE, 0x48, 0x5B, 0xF5, 0x0E, 0xF3, 0x58, 0x4A, 0xF7, 0x5F,
  0xA4, 0x84, 0x6F, 0x92, 0xFE, 0x68, 0x45, 0xFA, 0x9F, 0x54, 0x84, 0x1F, 0xD5, 0xFA, 0x68, 0x41,
  0xFD, 0xCF, 0x15, 0x83, 0xCF, 0xAF, 0x67, 0x0D, 0xA0, 0xB6, 0x83, 0x7F, 0xEF, 0x17, 0x08, 0xA0,
  0x76, 0x03, 0xA0, 0xD7, 0x10, 0x4A, 0x02, 0x78, 0x1D, 0xF9, 0x40,
  // "X" (U+0058)
  0x03, 0xA0, 0x26, 0x86, 0x1E, 0xF3, 0x09, 0xFC, 0x68, 0x1A, 0xF9, 0x38, 0x1D, 0xF6, 0x48, 0x14,
  0xFD, 0x48, 0x24, 0xFE, 0x13, 0x81, 0xDF, 0x45, 0x81, 0xAF, 0x92, 0x81, 0x7F, 0xA6, 0x86, 0x1E,
  0xF4, 0x2F, 0xE1, 0x78, 0x45, 0xFD, 0xBF, 0x57, 0x20, 0xBA, 0x0B, 0x73, 0x06, 0xA0, 0x77, 0x20,
  0x10, 0xEA, 0x0E, 0x01, 0x71, 0x84, 0xAF, 0x78, 0xFB, 0x78, 0x14, 0xFC, 0x28, 0x1D, 0xF5, 0x58,
  0x21, 0xEF, 0x32, 0x82, 0x4F, 0xE1, 0x48, 0x19, 0xF9, 0x48, 0x1A, 0xFA, 0x38, 0x14, 0xFD, 0x58,
  0x21, 0xEF, 0x52, 0x81, 0xDF, 0x56, 0x85, 0x6F, 0xE1, 0x9F, 0xA7, 0x18, 0x1C, 0xF9,
  // "Y" (U+0059)
  0x81, 0xBF, 0x97, 0x83, 0x1E, 0xF4, 0x3A, 0x02, 0x68, 0x18, 0xFB, 0x28, 0x1A, 0xFA, 0x50, 0x1A,
  0x03, 0x20, 0x2A, 0x03, 0x48, 0x19, 0xFA, 0x48, 0x18, 0xFB, 0x30, 0x2A, 0x02, 0x48, 0x21, 0xEF,
  0x32, 0x81, 0xAF, 0x96, 0x86, 0x7F, 0xC0, 0x3F, 0xE1, 0x78, 0x4E, 0xF4, 0xBF, 0x77, 0x18, 0x36,
  0xFE, 0xFE, 0x73, 0x0D, 0xA0, 0x67, 0x38, 0x15, 0xFE, 0x74, 0x81, 0x4F, 0xD7, 0x48, 0x14, 0xFD,
  0x74, 0x81, 0x4F, 0xD7, 0x48, 0x14, 0xFD, 0x74, 0x81, 0x4F, 0xD7, 0x48, 0x14, 0xFD, 0x60,
  // "Z" (U+005A)
  0x10, 0xCF, 0xB8, 0x18, 0x09, 0x80, 0x3B, 0x0C, 0xA0, 0x77, 0x28, 0x18, 0xFD, 0x72, 0x03, 0xA0,
  0x37, 0x28, 0x1D, 0xF9, 0x72, 0x81, 0x8F, 0xD7, 0x20, 0x3A, 0x04, 0x72, 0x81, 0xCF, 0x97, 0x28,
  0x27, 0xFD, 0x17, 0x10, 0x2A, 0x04, 0x72, 0x81, 0xCF, 0xA7, 0x28, 0x27, 0xFE, 0x17, 0x18, 0x22,
  0xEF, 0x57, 0x28, 0x1B, 0xFA, 0x72, 0x82, 0x6F, 0xE1, 0x72, 0x81, 0xEF, 0xE8, 0x04, 0xB0, 0x90,
  0x1F, 0xC0, 0xC0,
  // "[" (U+005B)
  0x01, 0xD0, 0x40, 0x1A, 0x0F, 0xB0, 0x30, 0x1A, 0x40, 0x1A, 0x40, 0x1A, 0x40, 0x1A, 0x40, 0x1A,
  0x40, 0x1A, 0x40, 0x1A, 0x40, 0x1A, 0x40, 0x1A, 0x40, 0x1A, 0x40, 0x1A, 0x40, 0x1A, 0x40, 0x1A,
  0x40, 0x1A, 0x40, 0x1A, 0x40, 0x1A, 0x40, 0x1A, 0x40, 0x1D, 0x04, 0x18, 0x01, 0xB0, 0x30,
  // "\" (U+005C)
  0x81, 0x9F, 0x76, 0x81, 0x3F, 0xD7, 0x81, 0xCF, 0x36, 0x81, 0x7F, 0x96, 0x81, 0x1F, 0xE7, 0x81,
  0xAF, 0x56, 0x81, 0x5F, 0xB7, 0x81, 0xEF, 0x26, 0x81, 0x8F, 0x76, 0x81, 0x3F, 0xD7, 0x81, 0xCF,
  0x46, 0x81, 0x6F, 0x96, 0x81, 0x1F, 0xE7, 0x81, 0xAF, 0x66, 0x81, 0x4F, 0xB7, 0x81, 0xEF, 0x26,
  0x81, 0x8F, 0x80,
  // "]" (U+005D)
  0x06, 0xD8, 0x24, 0xBB, 0xCA, 0x30, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30,
  0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30,
  0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x30, 0x1A, 0x06, 0xD0, 0x48, 0x01, 0xB0,
  // "^" (U+005E)
  0x48, 0x13, 0xF7, 0x72, 0x81, 0xAF, 0xE7, 0x18, 0x32, 0xFB, 0xF7, 0x78, 0x39, 0xF1, 0xCE, 0x68,
  0x51, 0xFA, 0x04, 0xF7, 0x58, 0x18, 0xF3, 0x28, 0x1C, 0xE1, 0x38, 0x11, 0xEB, 0x38, 0x14, 0xF8,
  0x38, 0x17, 0xF5, 0x48, 0x1C, 0xE1, 0x20, 0xE0, 0xD5, 0x85, 0x4F, 0x80, 0x6F, 0x66, 0x83, 0xCE,
  0x1D, 0xE7, 0x81, 0x4F, 0x80,
  // "_" (U+005F)
  0x80, 0x6B, 0x08, 0xFB, 0x0A,
  // "`" (U+0060)
  0x81, 0xDF, 0xB2, 0x82, 0x2E, 0xF4, 0x28, 0x13, 0xED, 0x38, 0x13, 0xE9,
  // "a" (U+0061)
  0x28, 0x54, 0x9D, 0xFE, 0xC7, 0x30, 0x4A, 0x81, 0xDC, 0xDA, 0x0B, 0x30, 0x80, 0x23, 0x03, 0xA0,
  0x37, 0x18, 0x1A, 0xF7, 0x71, 0x81, 0x8F, 0x72, 0x89, 0x12, 0x79, 0xBB, 0xBD, 0xF8, 0x09, 0xF9,
  0x08, 0x07, 0xA0, 0x70, 0x23, 0x84, 0x8F, 0x8C, 0xF8, 0x58, 0x49, 0xF8, 0xDF, 0x55, 0x84, 0xDF,
  0x8B, 0xFA, 0x30, 0x20, 0xAA, 0x08, 0x04, 0xA8, 0xA1, 0xEC, 0xDF, 0xD6, 0xF8, 0x03, 0xBE, 0xFD,
  0x81, 0x1F, 0x80,
  // "b" (U+0062)
  0x81, 0xEF, 0x27, 0x28, 0x1E, 0xF2, 0x72, 0x81, 0xEF, 0x27, 0x28, 0x1E, 0xF2, 0x72, 0x81, 0xEF,
  0x27, 0x28, 0x7E, 0xF1, 0x4B, 0xEF, 0xC7, 0x38, 0x5E, 0xF7, 0xFE, 0xCC, 0xA0, 0xC2, 0x0E, 0xA0,
  0x63, 0x86, 0x2D, 0xF8, 0x0E, 0xF9, 0x58, 0x54, 0xFE, 0x0E, 0xF5, 0x68, 0x4E, 0xF3, 0xEF, 0x36,
  0x84, 0xCF, 0x5E, 0xF2, 0x68, 0x4B, 0xF6, 0xEF, 0x36, 0x84, 0xCF, 0x5E, 0xF5, 0x68, 0x4E, 0xF3,
  0xEF, 0xA5, 0x83, 0x5F, 0xE0, 0xEA, 0x06, 0x38, 0x92, 0x3E, 0xF8, 0x0E, 0xD8, 0xFE, 0xCC, 0xA0,
  0xB2, 0x87, 0xEA, 0x05, 0xBE, 0xFC, 0x73,
  // "c" (U+0063)
  0x38, 0x56, 0xBE, 0xFD, 0xB5, 0x20, 0xBA, 0x89, 0x0D, 0xCE, 0xF6, 0x0A, 0xFC, 0x23, 0x81, 0x30,
  0x2A, 0x02, 0x68, 0x17, 0xFB, 0x78, 0x19, 0xF8, 0x78, 0x1A, 0xF7, 0x78, 0x19, 0xF8, 0x78, 0x17,
  0xFB, 0x70, 0x2A, 0x01, 0x78, 0x2B, 0xFC, 0x23, 0x83, 0x13, 0x01, 0xCA, 0x83, 0xCB, 0xDF, 0x83,
  0x85, 0x6C, 0xEF, 0xEA, 0x30,
  // "d" (U+0064)
  0x72, 0x81, 0x6F, 0xB7, 0x28, 0x16, 0xFB, 0x72, 0x81, 0x6F, 0xB7, 0x28, 0x16, 0xFB, 0x72, 0x81,
  0x6F, 0xB2, 0x89, 0x31, 0x8D, 0xFE, 0xA2, 0x5F, 0xB0, 0x2D, 0xA8, 0x92, 0xCC, 0xFE, 0x8F, 0xB0,
  0xCF, 0xC1, 0x30, 0x9A, 0x0B, 0x03, 0xA0, 0x25, 0x84, 0xDF, 0xB7, 0xFB, 0x68, 0x49, 0xFB, 0x9F,
  0x96, 0x84, 0x6F, 0xBA, 0xF8, 0x68, 0x45, 0xFB, 0x9F, 0x96, 0x84, 0x6F, 0xB7, 0xFB, 0x68, 0x28,
  0xFB, 0x3A, 0x01, 0x58, 0x6C, 0xFB, 0x0C, 0xFB, 0x13, 0x08, 0xA8, 0x2B, 0x02, 0xEA, 0x85, 0xCC,
  0xEE, 0x7F, 0xB2, 0x89, 0x01, 0x9D, 0xFE, 0xA2, 0x1F, 0xB0,
  // "e" (U+0065)
  0x38, 0x46, 0xCE, 0xEC, 0x65, 0x0B, 0xA0, 0xC0, 0xDA, 0x0B, 0x38, 0x29, 0xFB, 0x12, 0x87, 0x1C,
  0xF8, 0x02, 0xFE, 0x14, 0x85, 0x3F, 0xE0, 0x6F, 0xA6, 0x82, 0xEF, 0x39, 0xFB, 0x82, 0x4A, 0xFD,
  0x80, 0x4B, 0x82, 0x39, 0xF8, 0x72, 0x81, 0x7F, 0xB7, 0x20, 0x2A, 0x03, 0x72, 0x82, 0x9F, 0xD3,
  0x40, 0x30, 0x53, 0x0B, 0xA8, 0x4D, 0xBC, 0xEF, 0xB4, 0x86, 0x5B, 0xDF, 0xED, 0x93, 0x10,
  // "f" (U+0066)
  0x48, 0x46, 0xCE, 0xEB, 0x13, 0x0A, 0xA8, 0x1C, 0xCD, 0x30, 0x2A, 0x03, 0x68, 0x15, 0xFC, 0x78,
  0x16, 0xFB, 0x50, 0x40, 0xAE, 0x28, 0x37, 0xBD, 0xFE, 0x0F, 0xB4, 0x81, 0x6F, 0xB7, 0x81, 0x6F,
  0xB7, 0x81, 0x6F, 0xB7, 0x81, 0x6F, 0xB7, 0x81, 0x6F, 0xB7, 0x81, 0x6F, 0xB7, 0x81, 0x6F, 0xB7,
  0x81, 0x6F, 0xB7, 0x81, 0x6F, 0xB7, 0x81, 0x6F, 0xB7, 0x81, 0x6F, 0xB5,
  // "g" (U+0067)
  0x28, 0x93, 0x18, 0xDF, 0xE9, 0x20, 0xFB, 0x01, 0xDA, 0x89, 0x2C, 0xCF, 0xE6, 0xFB, 0x0B, 0xFC,
  0x12, 0x01, 0x0A, 0xA0, 0xB0, 0x3A, 0x02, 0x58, 0x4D, 0xFB, 0x7F, 0xB6, 0x84, 0x8F, 0xB9, 0xF8,
  0x68, 0x46, 0xFB, 0xAF, 0x76, 0x84, 0x5F, 0xB9, 0xF8, 0x68, 0x45, 0xFB, 0x7F, 0xB6, 0x82, 0x7F,
  0xB3, 0xA0, 0x15, 0x86, 0xCF, 0xB0, 0xCF, 0xB1, 0x30, 0x8A, 0x82, 0xB0, 0x2E, 0xA8, 0x5C, 0xCE,
  0xF8, 0xFB, 0x28, 0x90, 0x19, 0xDF, 0xEA, 0x25, 0xFB, 0x72, 0x81, 0x6F, 0xA7, 0x28, 0x18, 0xF9,
  0x72, 0x84, 0xDF, 0x60, 0x75, 0x58, 0x4A, 0xFE, 0x10, 0xAA, 0x82, 0xDC, 0xCE, 0xA0, 0x52, 0x82,
  0x39, 0xCE, 0xA8, 0x1D, 0x92, 0x20,
  // "h" (U+0068)
  0x81, 0xEF, 0x27, 0x18, 0x1E, 0xF2, 0x71, 0x81, 0xEF, 0x27, 0x18, 0x1E, 0xF2, 0x71, 0x81, 0xEF,
  0x27, 0x18, 0xA0, 0xEF, 0x24, 0xBE, 0xFD, 0x91, 0x0E, 0xF7, 0xFE, 0xCD, 0xA8, 0x1E, 0x1E, 0xA0,
  0x63, 0x85, 0x2D, 0xF8, 0xEF, 0xA5, 0x84, 0x6F, 0xCE, 0xF5, 0x58, 0x43, 0xFD, 0xEF, 0x35, 0x84,
  0x3F, 0xDE, 0xF2, 0x58, 0x43, 0xFD, 0xEF, 0x25, 0x84, 0x3F, 0xDE, 0xF2, 0x58, 0x43, 0xFD, 0xEF,
  0x25, 0x84, 0x3F, 0xDE, 0xF2, 0x58, 0x43, 0xFD, 0xEF, 0x25, 0x84, 0x3F, 0xDE, 0xF2, 0x58, 0x13,
  0xFD,
  // "i" (U+0069)
  0x18, 0x2B, 0xD1, 0x1A, 0x82, 0x40, 0x9B, 0x73, 0x8E, 0x1E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E,
  0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E,
  0xF2, 0x0E, 0xF2,
  // "j" (U+006A)
  0x48, 0x1B, 0xD1, 0x30, 0x1A, 0x04, 0x40, 0x90, 0xB7, 0x75, 0x81, 0xEF, 0x24, 0x81, 0xEF, 0x24,
  0x81, 0xEF, 0x24, 0x81, 0xEF, 0x24, 0x81, 0xEF, 0x24, 0x81, 0xEF, 0x24, 0x81, 0xEF, 0x24, 0x81,
  0xEF, 0x24, 0x81, 0xEF, 0x24, 0x81, 0xEF, 0x24, 0x81, 0xEF, 0x24, 0x81, 0xEF, 0x24, 0x81, 0xEF,
  0x24, 0x81, 0xEF, 0x24, 0x81, 0xEF, 0x24, 0xA0, 0x13, 0x85, 0x4F, 0xE0, 0x4C, 0xCA, 0x85, 0x80,
  0x3E, 0xFD, 0x82,
  // "k" (U+006B)
  0x81, 0xEF, 0x17, 0x18, 0x1E, 0xF1, 0x71, 0x81, 0xEF, 0x17, 0x18, 0x1E, 0xF1, 0x71, 0x81, 0xEF,
  0x17, 0x18, 0x1E, 0xF1, 0x48, 0x5A, 0xFB, 0x0E, 0xF1, 0x38, 0x19, 0xFC, 0x28, 0x1E, 0xF1, 0x28,
  0x28, 0xFC, 0x12, 0x86, 0xEF, 0x10, 0x7F, 0xD1, 0x38, 0x5E, 0xF1, 0x6F, 0xD2, 0x48, 0x1E, 0xF5,
  0xA0, 0x35, 0x81, 0xEF, 0xEA, 0x0B, 0x58, 0x5E, 0xFC, 0x3E, 0xF7, 0x48, 0x3E, 0xF2, 0x04, 0xA0,
  0x33, 0x81, 0xEF, 0x12, 0x82, 0x8F, 0xD1, 0x28, 0x1E, 0xF1, 0x38, 0x1B, 0xFB, 0x28, 0x1E, 0xF1,
  0x38, 0x61, 0xEF, 0x70, 0xEF, 0x14, 0x04, 0xA0, 0x30,
  // "l" (U+006C)
  0x8E, 0x4E, 0xF2, 0xEF, 0x2E, 0xF2, 0xEF, 0x2E, 0xF2, 0xEF, 0x2E, 0xF2, 0xEF, 0x2E, 0xF2, 0xEF,
  0x2E, 0xF2, 0xEF, 0x2E, 0xF2, 0xEF, 0x2E, 0xF2, 0xEF, 0x2E, 0xF2, 0xEF, 0x20,
  // "m" (U+006D)
  0x87, 0xEC, 0x04, 0xBE, 0xEC, 0x62, 0x84, 0x4B, 0xEF, 0xD7, 0x28, 0x5E, 0xF7, 0xFD, 0xCE, 0xA8,
  0x47, 0x7F, 0xEC, 0xDA, 0x81, 0xA0, 0xEA, 0x05, 0x30, 0x8B, 0x07, 0x30, 0x5A, 0x82, 0x2E, 0xF9,
  0x58, 0x1E, 0xFC, 0x58, 0x4C, 0xF6, 0xEF, 0x55, 0x81, 0xCF, 0x75, 0x84, 0x9F, 0x7E, 0xF3, 0x58,
  0x1C, 0xF5, 0x58, 0x49, 0xF7, 0xEF, 0x25, 0x81, 0xCF, 0x45, 0x84, 0x9F, 0x7E, 0xF2, 0x58, 0x1C,
  0xF4, 0x58, 0x49, 0xF7, 0xEF, 0x25, 0x81, 0xCF, 0x45, 0x84, 0x9F, 0x7E, 0xF2, 0x58, 0x1C, 0xF4,
  0x58, 0x49, 0xF7, 0xEF, 0x25, 0x81, 0xCF, 0x45, 0x84, 0x9F, 0x7E, 0xF2, 0x58, 0x1C, 0xF4, 0x58,
  0x49, 0xF7, 0xEF, 0x25, 0x81, 0xCF, 0x45, 0x81, 0x9F, 0x70,
  // "n" (U+006E)
  0x8A, 0x0E, 0xC0, 0x4A, 0xEF, 0xD9, 0x10, 0xEF, 0x6F, 0xEC, 0xDA, 0x81, 0xE1, 0xEA, 0x07, 0x38,
  0x52, 0xDF, 0x8E, 0xFA, 0x58, 0x46, 0xFC, 0xEF, 0x55, 0x84, 0x3F, 0xDE, 0xF3, 0x58, 0x43, 0xFD,
  0xEF, 0x25, 0x84, 0x3F, 0xDE, 0xF2, 0x58, 0x43, 0xFD, 0xEF, 0x25, 0x84, 0x3F, 0xDE, 0xF2, 0x58,
  0x43, 0xFD, 0xEF, 0x25, 0x84, 0x3F, 0xDE, 0xF2, 0x58, 0x43, 0xFD, 0xEF, 0x25, 0x81, 0x3F, 0xD0,
  // "o" (U+006F)
  0x38, 0x56, 0xBE, 0xFD, 0x92, 0x40, 0x10, 0xBA, 0x84, 0xCC, 0xEF, 0xE5, 0x38, 0x2A, 0xFC, 0x23,
  0x06, 0xA8, 0x12, 0x02, 0xA0, 0x25, 0x85, 0xAF, 0xA0, 0x7F, 0xB6, 0x85, 0x3F, 0xE0, 0x9F, 0x96,
  0x01, 0xA8, 0x21, 0xAF, 0x87, 0xA8, 0x23, 0x9F, 0x96, 0x01, 0xA8, 0x22, 0x6F, 0xC6, 0x83, 0x3F,
  0xE0, 0x1A, 0x02, 0x58, 0x1A, 0xFA, 0x28, 0x29, 0xFC, 0x23, 0x06, 0xA0, 0x33, 0x0A, 0xA8, 0x1C,
  0xCE, 0xA0, 0x55, 0x85, 0x5B, 0xEF, 0xD9, 0x23,
  // "p" (U+0070)
  0x87, 0xED, 0x04, 0xBE, 0xFC, 0x73, 0x85, 0xEF, 0x6F, 0xEC, 0xDA, 0x0C, 0x20, 0xEA, 0x06, 0x38,
  0x63, 0xEF, 0x80, 0xEF, 0xA5, 0x85, 0x6F, 0xE0, 0xEF, 0x56, 0xA8, 0x23, 0xEF, 0x36, 0x84, 0xDF,
  0x5E, 0xF2, 0x68, 0x4B, 0xF6, 0xEF, 0x36, 0x84, 0xCF, 0x5E, 0xF5, 0x6A, 0x82, 0x3E, 0xFA, 0x58,
  0x36, 0xFE, 0x0E, 0xA0, 0x63, 0x89, 0x23, 0xEF, 0x80, 0xEF, 0x8F, 0xEC, 0xDA, 0x0B, 0x28, 0x7E,
  0xF1, 0x4B, 0xEF, 0xC7, 0x38, 0x1E, 0xF2, 0x72, 0x81, 0xEF, 0x27, 0x28, 0x1E, 0xF2, 0x72, 0x81,
  0xEF, 0x27, 0x28, 0x1E, 0xF2, 0x72, 0x81, 0xEF, 0x27, 0x20,
  // "q" (U+0071)
  0x28, 0x93, 0x18, 0xDF, 0xEA, 0x20, 0xFB, 0x02, 0xDA, 0x89, 0x2C, 0xCF, 0xE6, 0xFB, 0x0C, 0xFC,
  0x13, 0x09, 0xA0, 0xB0, 0x3A, 0x02, 0x58, 0x4D, 0xFB, 0x7F, 0xB6, 0x84, 0x9F, 0xB9, 0xF9, 0x68,
  0x46, 0xFB, 0xAF, 0x86, 0x84, 0x5F, 0xB9, 0xF9, 0x68, 0x46, 0xFB, 0x7F, 0xB6, 0x82, 0x8F, 0xB3,
  0xA0, 0x25, 0x86, 0xCF, 0xB0, 0xCF, 0xB1, 0x30, 0x8A, 0x82, 0xB0, 0x2E, 0xA8, 0x5C, 0xCE, 0xE8,
  0xFB, 0x28, 0x90, 0x19, 0xDF, 0xE9, 0x25, 0xFB, 0x72, 0x81, 0x6F, 0xB7, 0x28, 0x16, 0xFB, 0x72,
  0x81, 0x6F, 0xB7, 0x28, 0x16, 0xFB, 0x72, 0x81, 0x6F, 0xB7, 0x28, 0x16, 0xFB,
  // "r" (U+0072)
  0x8A, 0x3E, 0xC0, 0x19, 0xEF, 0x6E, 0xE2, 0xDF, 0xCD, 0x5E, 0xFC, 0xB1, 0x38, 0x1E, 0xFD, 0x58,
  0x1E, 0xF6, 0x58, 0x1E, 0xF3, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E,
  0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x50,
  // "s" (U+0073)
  0x18, 0xA4, 0x18, 0xCE, 0xED, 0xA5, 0x02, 0xEF, 0xEC, 0xCE, 0xFD, 0x0A, 0xF9, 0x48, 0x44, 0x50,
  0xBF, 0x47, 0x82, 0x8F, 0xD3, 0x70, 0xAA, 0x0C, 0x06, 0x60, 0x40, 0xBA, 0x0E, 0x07, 0x68, 0x31,
  0x8E, 0xFB, 0x78, 0x22, 0xEF, 0x47, 0x83, 0xAF, 0x66, 0x34, 0x89, 0x03, 0xEF, 0x3B, 0xFE, 0xCB,
  0xDA, 0x83, 0x90, 0x39, 0xDA, 0x81, 0xDA, 0x42,
  // "t" (U+0074)
  0x28, 0x11, 0xF4, 0x68, 0x15, 0xF4, 0x68, 0x1A, 0xF4, 0x40, 0x40, 0xCE, 0x18, 0x37, 0xBE, 0xFC,
  0x0F, 0xB3, 0x81, 0xCF, 0x46, 0x81, 0xCF, 0x46, 0x81, 0xCF, 0x46, 0x81, 0xCF, 0x46, 0x81, 0xCF,
  0x46, 0x81, 0xCF, 0x46, 0x81, 0xCF, 0x46, 0x81, 0xBF, 0x56, 0x81, 0x9F, 0xB6, 0x03, 0xA8, 0x2E,
  0xCD, 0x23, 0x84, 0x4B, 0xEE, 0xC1,
  // "u" (U+0075)
  0x01, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F,
  0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x5F,
  0xC1, 0xA0, 0x15, 0x81, 0x7F, 0xC1, 0xA0, 0x35, 0x86, 0xDF, 0xC0, 0xBF, 0xC1, 0x30, 0x9A, 0x81,
  0xC0, 0x3A, 0x86, 0xEC, 0xCE, 0xF7, 0xFC, 0x28, 0x90, 0x3A, 0xEF, 0xEA, 0x30, 0xFC,
  // "v" (U+0076)
  0x81, 0xCF, 0x66, 0x84, 0x3F, 0xE6, 0xFC, 0x68, 0x29, 0xF9, 0x1A, 0x02, 0x58, 0x5E, 0xF3, 0x0A,
  0xF7, 0x48, 0x14, 0xFD, 0x28, 0x14, 0xFD, 0x48, 0x1A, 0xF7, 0x38, 0x1E, 0xF3, 0x3A, 0x01, 0x38,
  0x18, 0xF8, 0x28, 0x16, 0xFB, 0x48, 0x12, 0xFE, 0x28, 0x1B, 0xF5, 0x58, 0x4C, 0xF4, 0x1F, 0xE6,
  0x84, 0x6F, 0x96, 0xF9, 0x68, 0x41, 0xFD, 0xBF, 0x37, 0x0A, 0xA0, 0xD7, 0x10, 0x4A, 0x07, 0x40,
  // "w" (U+0077)
  0x81, 0x9F, 0x95, 0x81, 0xDF, 0xB5, 0x84, 0xAF, 0x75, 0xFC, 0x40, 0x2B, 0x01, 0x48, 0x2E, 0xF2,
  0x1A, 0x01, 0x38, 0x37, 0xFC, 0xF5, 0x38, 0x13, 0xFE, 0x28, 0x1C, 0xF5, 0x38, 0x3C, 0xF5, 0xFA,
  0x38, 0x17, 0xF9, 0x28, 0x17, 0xF9, 0x28, 0x41, 0xFC, 0x0E, 0xE3, 0x81, 0xBF, 0x52, 0x81, 0x3F,
  0xD2, 0x85, 0x6F, 0x80, 0xAF, 0x42, 0x81, 0xEF, 0x13, 0x89, 0x5E, 0xF1, 0x0B, 0xF3, 0x06, 0xF8,
  0x03, 0xFC, 0x48, 0x4A, 0xF5, 0x0F, 0xE2, 0x85, 0x1F, 0xD0, 0x7F, 0x84, 0x84, 0x6F, 0x94, 0xF9,
  0x38, 0x4C, 0xF2, 0xBF, 0x44, 0x84, 0x2F, 0xC8, 0xF4, 0x38, 0x37, 0xF6, 0xFE, 0x68, 0x2D, 0xFC,
  0xE4, 0x83, 0x3F, 0xCF, 0xB6, 0x09, 0xA0, 0xA5, 0x0D, 0xA0, 0x66, 0x05, 0xA0, 0x55, 0x09, 0xA0,
  0x23,
  // "x" (U+0078)
  0x82, 0x1E, 0xF5, 0x58, 0x6A, 0xFA, 0x04, 0xFE, 0x13, 0x82, 0x5F, 0xD1, 0x28, 0x19, 0xFB, 0x28,
  0x21, 0xEF, 0x44, 0x85, 0xDF, 0x60, 0xAF, 0x85, 0x84, 0x3F, 0xE7, 0xFD, 0x70, 0x7B, 0x03, 0x70,
  0x1A, 0x0B, 0x71, 0x0A, 0xB0, 0x66, 0x85, 0x6F, 0xD3, 0xFE, 0x24, 0x86, 0x2E, 0xF3, 0x07, 0xFC,
  0x48, 0x1C, 0xF8, 0x38, 0x1C, 0xF7, 0x28, 0x17, 0xFC, 0x40, 0x2A, 0x00, 0x3A, 0x02, 0x58, 0x17,
  0xFD,
  // "y" (U+0079)
  0x81, 0xCF, 0x76, 0x03, 0xA8, 0x21, 0x5F, 0xC6, 0x81, 0x8F, 0xA2, 0x81, 0xEF, 0x35, 0x81, 0xEF,
  0x42, 0x81, 0x9F, 0x84, 0x81, 0x4F, 0xE3, 0x81, 0x3F, 0xE4, 0x81, 0x9F, 0x84, 0x81, 0xCF, 0x43,
  0x81, 0xEF, 0x34, 0x81, 0x6F, 0xA2, 0x81, 0x4F, 0xC5, 0x01, 0xA8, 0x31, 0x0A, 0xF7, 0x68, 0x5A,
  0xF6, 0x0E, 0xF1, 0x68, 0x44, 0xFB, 0x4F, 0xB7, 0x18, 0x3D, 0xE9, 0xF5, 0x71, 0x07, 0xA0, 0xE7,
  0x20, 0x1A, 0x09, 0x73, 0x81, 0xEF, 0x37, 0x28, 0x14, 0xFD, 0x73, 0x81, 0xBF, 0x67, 0x28, 0x17,
  0xFE, 0x78, 0x19, 0xBD, 0xA0, 0x47, 0x83, 0x9F, 0xEB, 0x47, 0x10,
  // "z" (U+007A)
  0x10, 0xAF, 0x98, 0x12, 0x07, 0x80, 0x1B, 0x0C, 0xA0, 0x27, 0x81, 0xAF, 0x97, 0x81, 0x6F, 0xD7,
  0x82, 0x2E, 0xF3, 0x78, 0x1C, 0xF7, 0x78, 0x18, 0xFB, 0x78, 0x23, 0xFE, 0x17, 0x81, 0xDF, 0x57,
  0x81, 0x9F, 0x97, 0x81, 0x5F, 0xD7, 0x18, 0x1E, 0xFD, 0x80, 0x2B, 0x04, 0x01, 0xFA, 0x05,
  // "{" (U+007B)
  0x58, 0x25, 0xBD, 0x54, 0x0A, 0xA0, 0xD0, 0x43, 0x03, 0xA0, 0x45, 0x81, 0x5F, 0xB6, 0x81, 0x6F,
  0xA6, 0x81, 0x6F, 0xA6, 0x81, 0x6F, 0xA6, 0x81, 0x7F, 0x95, 0x82, 0x1D, 0xF6, 0x38, 0x33, 0xCF,
  0xE7, 0x40, 0x5A, 0x0A, 0x03, 0x50, 0x10, 0x6A, 0x03, 0x68, 0x18, 0xF9, 0x68, 0x16, 0xFA, 0x68,
  0x16, 0xFA, 0x68, 0x16, 0xFA, 0x68, 0x16, 0xFA, 0x68, 0x15, 0xFC, 0x60, 0x1A, 0x08, 0x01, 0x50,
  0x6B, 0x05, 0x58, 0x21, 0x7A, 0x40,
  // "|" (U+007C)
  0x89, 0x86, 0x4F, 0x74, 0xF7, 0x4F, 0x74, 0xF7, 0x4F, 0x74, 0xF7, 0x4F, 0x74, 0xF7, 0x4F, 0x74,
  0xF7, 0x4F, 0x74, 0xF7, 0x4F, 0x74, 0xF7, 0x4F, 0x74, 0xF7, 0x4F, 0x74, 0xF7, 0x4F, 0x74, 0xF7,
  0x4F, 0x74, 0xF7, 0x4F, 0x74, 0xF7,
  // "}" (U+007D)
  0x82, 0x3E, 0xC6, 0x50, 0x20, 0xCA, 0x0C, 0x68, 0x22, 0xEF, 0x56, 0x81, 0x9F, 0x76, 0x81, 0x8F,
  0x86, 0x81, 0x8F, 0x86, 0x81, 0x8F, 0x86, 0x81, 0x8F, 0x96, 0x82, 0x4F, 0xE2, 0x68, 0x36, 0xEF,
  0xD5, 0x40, 0x20, 0x9A, 0x07, 0x38, 0x31, 0xEF, 0x61, 0x48, 0x17, 0xFA, 0x68, 0x18, 0xF8, 0x68,
  0x18, 0xF8, 0x68, 0x18, 0xF8, 0x68, 0x18, 0xF7, 0x68, 0x1B, 0xF7, 0x40, 0x10, 0x6A, 0x02, 0x30,
  0x3B, 0x07, 0x48, 0x22, 0xA7, 0x25,
  // "~" (U+007E)
  0x85, 0x2A, 0xEE, 0xD9, 0x33, 0x84, 0x56, 0xCF, 0xCC, 0xB8, 0x5E, 0xCD, 0xF7, 0x92, 0x38, 0x45,
  0xAD, 0xFD, 0x81,
  // "¡" (U+00A1)
  0x18, 0x2C, 0xE5, 0x3A, 0x83, 0xA0, 0xCE, 0x57, 0x20, 0x80, 0xE2, 0x09, 0x0E, 0x20, 0x99, 0x20,
  0xA9, 0x28, 0xA1, 0xBF, 0x10, 0xCF, 0x20, 0xCF, 0x30, 0xDF, 0x40, 0xEF, 0x41, 0xA0, 0x51, 0xA0,
  0x60, 0x1A, 0x07,
  // "¢" (U+00A2)
  0x48, 0x12, 0xF7, 0x68, 0x54, 0x9F, 0xD9, 0x72, 0x20, 0xBE, 0x84, 0x60, 0xAF, 0xD5, 0x28, 0x23,
  0x81, 0x3A, 0x02, 0x68, 0x17, 0xFA, 0x78, 0x1A, 0xF7, 0x78, 0x1B, 0xF5, 0x78, 0x1C, 0xF5, 0x78,
  0x1B, 0xF6, 0x78, 0x18, 0xFA, 0x78, 0x23, 0xFE, 0x17, 0x82, 0xBF, 0xD4, 0x28, 0x42, 0x64, 0x01,
  0xCE, 0x06, 0x38, 0x55, 0xAF, 0xD9, 0x61, 0x48, 0x12, 0xF7, 0x78, 0x12, 0xF7, 0x30,
  // "£" (U+00A3)
  0x58, 0x57, 0xCE, 0xFD, 0xA4, 0x50, 0xBA, 0x84, 0xCC, 0xEF, 0xE1, 0x38, 0x27, 0xFD, 0x23, 0x04,
  0x06, 0x48, 0x1B, 0xF6, 0x73, 0x81, 0xDF, 0x47, 0x38, 0x1D, 0xF3, 0x73, 0x81, 0xDF, 0x37, 0x38,
  0x1D, 0xF3, 0x70, 0x2F, 0xA0, 0x22, 0x81, 0x1B, 0xBA, 0x84, 0xCB, 0xBB, 0xB1, 0x58, 0x1D, 0xF3,
  0x73, 0x81, 0xDF, 0x37, 0x38, 0x1E, 0xF3, 0x72, 0x01, 0xA0, 0x17, 0x28, 0x1A, 0xF7, 0x71, 0x82,
  0x2D, 0xFE, 0x80, 0x4B, 0x09, 0x03, 0xFC, 0x0D,
  // "¤" (U+00A4)
  0x10, 0x67, 0x89, 0x72, 0x40, 0x5F, 0xB4, 0xBE, 0xD9, 0x4E, 0xE1, 0x0A, 0xB0, 0xC0, 0xDB, 0x06,
  0x28, 0x22, 0xFC, 0x12, 0x81, 0x3E, 0xD3, 0x81, 0x8F, 0x14, 0x81, 0x5F, 0x42, 0x00, 0xC5, 0x81,
  0x1F, 0x72, 0x0B, 0x0D, 0x58, 0x11, 0xF7, 0x28, 0x18, 0xF3, 0x48, 0x17, 0xF3, 0x28, 0x72, 0xFE,
  0x50, 0x17, 0xFD, 0x30, 0xCF, 0x98, 0x93, 0x80, 0x4F, 0x81, 0x7A, 0xA5, 0x1C, 0xD2, 0x03, 0x70,
  0x10, 0x21,
  // "¥" (U+00A5)
  0x81, 0x6F, 0xC7, 0x02, 0xA8, 0x31, 0x0D, 0xF5, 0x68, 0x19, 0xF8, 0x28, 0x15, 0xFC, 0x58, 0x22,
  0xFE, 0x13, 0x81, 0xCF, 0x54, 0x81, 0xAF, 0x74, 0x81, 0x4F, 0xD3, 0x81, 0x2F, 0xD6, 0x81, 0xBF,
  0x52, 0x81, 0xAF, 0x66, 0x85, 0x3F, 0xD0, 0x3F, 0xD7, 0x18, 0x4A, 0xF6, 0xBF, 0x47, 0x18, 0x32,
  0xFE, 0xFC, 0x70, 0xCF, 0x90, 0x74, 0x82, 0x9B, 0xBC, 0xA0, 0xFB, 0x05, 0x78, 0x12, 0xFD, 0x71,
  0x82, 0x9B, 0xBC, 0xA0, 0xFB, 0x05, 0x40, 0xCF, 0x90, 0x77, 0x81, 0x2F, 0xD7, 0x48, 0x12, 0xFD,
  0x74, 0x81, 0x2F, 0xD6,
  // "¦" (U+00A6)
  0x8B, 0x14, 0xF7, 0x4F, 0x74, 0xF7, 0x4F, 0x74, 0xF7, 0x4F, 0x74, 0xF7, 0x4F, 0x74, 0xF7, 0x77,
  0x48, 0xB1, 0x4F, 0x74, 0xF7, 0x4F, 0x74, 0xF7, 0x4F, 0x74, 0xF7, 0x4F, 0x74, 0xF7, 0x4F, 0x70,
  // "§" (U+00A7)
  0x28, 0x90, 0x7C, 0xEF, 0xEC, 0x71, 0x0B, 0xA8, 0x1C, 0xBD, 0xA8, 0x34, 0x3F, 0xD1, 0x38, 0x41,
  0x60, 0x3F, 0xC7, 0x18, 0x2D, 0xFB, 0x36, 0x02, 0x0D, 0xA8, 0x1D, 0x61, 0x38, 0x92, 0x6F, 0xC9,
  0xEF, 0xE5, 0x02, 0xFB, 0x38, 0x56, 0xEF, 0x55, 0xF7, 0x48, 0x44, 0xFA, 0x4F, 0xC4, 0x86, 0x2F,
  0xA0, 0xBF, 0xD5, 0x28, 0x19, 0xF5, 0x28, 0x57, 0xEF, 0xEC, 0xF8, 0x50, 0x50, 0xBA, 0x09, 0x78,
  0x23, 0xDF, 0x77, 0x83, 0x6F, 0xA5, 0x45, 0x82, 0xBF, 0x89, 0xA8, 0x96, 0xCB, 0xCE, 0xFD, 0x12,
  0x8C, 0xEF, 0xEC, 0x71, 0x10,
  // "¨" (U+00A8)
  0x81, 0x2A, 0x62, 0x84, 0x7A, 0x13, 0xE9, 0x28, 0x1A, 0xE2,
  // "©" (U+00A9)
  0x58, 0x61, 0x69, 0xAA, 0x95, 0x17, 0x10, 0x10, 0x9F, 0x0E, 0x07, 0x68, 0x42, 0xDF, 0xC6, 0x22,
  0x84, 0x26, 0xCF, 0xC1, 0x38, 0x21, 0xDE, 0x57, 0x18, 0x16, 0xFC, 0x38, 0x19, 0xF3, 0x28, 0x95,
  0x29, 0xDF, 0xD8, 0x10, 0x5F, 0x80, 0x2F, 0x72, 0x86, 0x2E, 0xFE, 0xCE, 0xF1, 0x28, 0x49, 0xE1,
  0x7E, 0x12, 0x81, 0xBF, 0x83, 0x03, 0x38, 0x31, 0xF6, 0xAB, 0x28, 0x12, 0xFD, 0x72, 0x82, 0xC9,
  0xC9, 0x28, 0x14, 0xF9, 0x72, 0x82, 0x9B, 0xC8, 0x28, 0x15, 0xF7, 0x72, 0x82, 0x9B, 0xBA, 0x28,
  0x14, 0xF9, 0x72, 0x82, 0xBA, 0x8E, 0x28, 0x11, 0xFD, 0x72, 0x83, 0xE7, 0x3F, 0x62, 0x85, 0xAF,
  0xA2, 0x02, 0x53, 0x89, 0x07, 0xF2, 0x0B, 0xE2, 0x01, 0xDC, 0x0E, 0x28, 0x12, 0xEB, 0x28, 0x22,
  0xED, 0x22, 0x89, 0x06, 0xAB, 0x94, 0x03, 0xDE, 0x23, 0x83, 0x5F, 0xE8, 0x24, 0x83, 0x29, 0xFE,
  0x45, 0x03, 0x0C, 0xA8, 0x2D, 0xCC, 0xEA, 0x0C, 0x03, 0x71, 0x86, 0x5A, 0xDE, 0xED, 0x95, 0x50,
  // "ª" (U+00AA)
  0x18, 0x45, 0xBE, 0xFD, 0x62, 0x8B, 0x02, 0x32, 0x16, 0xF3, 0x02, 0x9D, 0xEE, 0xF5, 0x0E, 0xC4,
  0x23, 0xF6, 0x2F, 0x52, 0x8A, 0x13, 0xF6, 0x1F, 0x91, 0x3C, 0xF6, 0x05, 0xDF, 0xC4, 0xD6,
  // "«" (U+00AB)
  0x40, 0x13, 0x01, 0x58, 0x1A, 0xE3, 0x28, 0x1C, 0xD1, 0x28, 0x18, 0xFB, 0x28, 0x1B, 0xF7, 0x28,
  0x65, 0xFD, 0x10, 0x8F, 0xA2, 0x86, 0x3F, 0xE2, 0x06, 0xFC, 0x38, 0x3D, 0xF5, 0x02, 0xA0, 0x23,
  0x81, 0x7F, 0xC2, 0x81, 0xAF, 0x94, 0x81, 0xAF, 0x92, 0x81, 0xCF, 0x64, 0x86, 0xCF, 0x70, 0x1E,
  0xF4, 0x38, 0x71, 0xDF, 0x30, 0x3F, 0xE1, 0x30, 0x20, 0x53, 0x04, 0x03, 0x10,
  // "¬" (U+00AC)
  0x09, 0x80, 0x6B, 0x05, 0x0C, 0xFB, 0x07, 0x72, 0x81, 0x3F, 0x77, 0x28, 0x13, 0xF7, 0x72, 0x81,
  0x3F, 0x77, 0x28, 0x13, 0xF7, 0x72, 0x81, 0x17, 0x30,
  // "®" (U+00AE)
  0x58, 0x61, 0x69, 0xAA, 0x95, 0x17, 0x10, 0x10, 0x9F, 0x0E, 0x07, 0x68, 0x42, 0xDF, 0xC6, 0x22,
  0x84, 0x26, 0xCF, 0xC1, 0x38, 0x21, 0xDE, 0x57, 0x18, 0x16, 0xFC, 0x38, 0x39, 0xF3, 0x04, 0xB8,
  0x1E, 0xB4, 0x28, 0x55, 0xF8, 0x02, 0xF7, 0x28, 0x64, 0xFD, 0xBD, 0xFE, 0x22, 0x84, 0x9E, 0x17,
  0xE1, 0x28, 0x14, 0xF8, 0x28, 0x18, 0xF6, 0x28, 0x31, 0xF6, 0xAB, 0x38, 0x14, 0xF8, 0x28, 0x15,
  0xF8, 0x38, 0x2C, 0x9C, 0x93, 0x86, 0x4F, 0x80, 0x2C, 0xF4, 0x38, 0x29, 0xBC, 0x83, 0x04, 0xD0,
  0x94, 0x82, 0x9B, 0xBA, 0x38, 0x44, 0xFD, 0xBF, 0xD5, 0x82, 0xBA, 0x8E, 0x38, 0x54, 0xF8, 0x07,
  0xF9, 0x48, 0x3E, 0x73, 0xF6, 0x28, 0x14, 0xF8, 0x28, 0x1C, 0xF4, 0x28, 0x91, 0x7F, 0x20, 0xBE,
  0x20, 0x4F, 0x82, 0x85, 0x2F, 0xD0, 0x2E, 0xB2, 0x85, 0x2E, 0xD2, 0x14, 0x23, 0x84, 0x34, 0x5D,
  0xE2, 0x38, 0x35, 0xFE, 0x82, 0x48, 0x32, 0x9F, 0xE4, 0x50, 0x30, 0xCA, 0x82, 0xDC, 0xCE, 0xA0,
  0xC0, 0x37, 0x18, 0x65, 0xAD, 0xEE, 0xD9, 0x55,
  // "¯" (U+00AF)
  0x18, 0x09, 0x0B, 0x10, 0x1F, 0xD0, 0x10,
  // "°" (U+00B0)
  0x28, 0x36, 0xAB, 0x71, 0x20, 0xBC, 0x89, 0x1D, 0x15, 0xF9, 0x10, 0x6F, 0x99, 0x94, 0x82, 0xBD,
  0xAE, 0x48, 0x3A, 0xE7, 0xF5, 0x28, 0x62, 0xEB, 0x1D, 0xFD, 0xCA, 0x86, 0x30, 0x2A, 0xEF, 0xB3,
  0x10,
  // "±" (U+00B1)
  0x59, 0x0A, 0x73, 0x90, 0xA7, 0x39, 0x0A, 0x73, 0x90, 0xA7, 0x39, 0x0A, 0x50, 0xCF, 0xB8, 0x93,
  0x79, 0xBB, 0xBB, 0xFE, 0xBB, 0xBB, 0x55, 0x90, 0xA7, 0x39, 0x0A, 0x73, 0x90, 0xA7, 0x39, 0x0A,
  0x73, 0x90, 0xA5, 0x09, 0x80, 0x6B, 0x05, 0x0C, 0xFB, 0x07,
  // "²" (U+00B2)
  0x30, 0x01, 0x40, 0x50, 0xDA, 0x89, 0x3D, 0x40, 0x1E, 0xB6, 0x6D, 0xF1, 0x02, 0x38, 0x16, 0xF5,
  0x58, 0x17, 0xF3, 0x50, 0xD0, 0xC5, 0x81, 0xBE, 0x24, 0x81, 0xBE, 0x24, 0x81, 0xBE, 0x23, 0x87,
  0x1C, 0xE4, 0x22, 0x20, 0x6E, 0x05, 0x02, 0x80, 0x25, 0x01,
  // "³" (U+00B3)
  0x30, 0x01, 0x40, 0x70, 0xEA, 0x89, 0x1E, 0x60, 0x3E, 0x96, 0x6D, 0xF3, 0x58, 0x16, 0xF5, 0x28,
  0x42, 0x24, 0xDD, 0x12, 0xB0, 0xE0, 0x33, 0x84, 0x55, 0x7D, 0xE3, 0x58, 0x12, 0xF9, 0x58, 0x93,
  0x2F, 0xA7, 0x84, 0x24, 0xCF, 0x56, 0xEC, 0x08, 0x38, 0x23, 0x44, 0x12,
  // "´" (U+00B4)
  0x18, 0x97, 0x1E, 0xF9, 0x09, 0xFC, 0x03, 0xFD, 0x10, 0xDC, 0x12,
  // "µ" (U+00B5)
  0x81, 0xEF, 0x25, 0x84, 0x3F, 0xEE, 0xF2, 0x58, 0x43, 0xFE, 0xEF, 0x25, 0x84, 0x3F, 0xEE, 0xF2,
  0x58, 0x43, 0xFE, 0xEF, 0x25, 0x84, 0x3F, 0xEE, 0xF2, 0x58, 0x43, 0xFE, 0xEF, 0x25, 0x84, 0x3F,
  0xEE, 0xF2, 0x58, 0x43, 0xFE, 0xEF, 0x35, 0x84, 0x6F, 0xEE, 0xF5, 0x58, 0x5B, 0xFE, 0xEF, 0xD2,
  0x30, 0x7A, 0x00, 0xEB, 0x8A, 0x3C, 0xCE, 0xF6, 0xFE, 0xEF, 0x5C, 0xFE, 0xB4, 0x0D, 0xEE, 0xF1,
  0x71, 0x81, 0xEF, 0x27, 0x18, 0x1E, 0xF2, 0x71, 0x81, 0xEF, 0x27, 0x18, 0x1E, 0xF2, 0x71, 0x81,
  0xEF, 0x27, 0x10,
  // "¶" (U+00B6)
  0x28, 0x13, 0x9D, 0xF8, 0x12, 0x04, 0xE8, 0x5D, 0xBC, 0xF2, 0x1E, 0xE8, 0x45, 0x03, 0xF2, 0x5F,
  0x84, 0x50, 0x3F, 0x28, 0xF8, 0x45, 0x03, 0xF2, 0xAF, 0x84, 0x50, 0x3F, 0x2A, 0xF8, 0x45, 0x03,
  0xF2, 0x9F, 0x84, 0x50, 0x3F, 0x27, 0xF8, 0x45, 0x03, 0xF2, 0x2F, 0x85, 0x50, 0x3F, 0x20, 0xAE,
  0x83, 0x50, 0x3F, 0x22, 0x09, 0xD8, 0x35, 0x03, 0xF2, 0x38, 0x90, 0x13, 0x44, 0xF5, 0x03, 0xF2,
  0x68, 0x51, 0xF5, 0x03, 0xF2, 0x68, 0x51, 0xF5, 0x03, 0xF2, 0x68, 0x51, 0xF5, 0x03, 0xF2, 0x68,
  0x51, 0xF5, 0x03, 0xF2, 0x68, 0x51, 0xF5, 0x03, 0xF2, 0x68, 0x51, 0xF5, 0x03, 0xF2, 0x68, 0x51,
  0xF5, 0x03, 0xF2, 0x68, 0x51, 0xF5, 0x03, 0xF2, 0x78, 0x4B, 0x30, 0x2B, 0x10,
  // "·" (U+00B7)
  0x18, 0x2C, 0xE5, 0x3A, 0x83, 0xA0, 0xCE, 0x40,
  // "¸" (U+00B8)
  0x20, 0x30, 0x22, 0x81, 0x2F, 0x32, 0x82, 0x7F, 0xD4, 0x28, 0x71, 0xCE, 0x11, 0x2C, 0xEA, 0xA8,
  0x3E, 0x51, 0x32, 0x20,
  // "¹" (U+00B9)
  0x28, 0x94, 0x9F, 0xB3, 0xDE, 0xEB, 0xCC, 0x2E, 0xB1, 0x20, 0xE0, 0xB3, 0x0E, 0x0B, 0x30, 0xE0,
  0xB3, 0x0E, 0x0B, 0x30, 0xE0, 0xB3, 0x0E, 0x0B, 0x30, 0xE0, 0xB0,
  // "º" (U+00BA)
  0x28, 0x37, 0xDF, 0xD7, 0x38, 0x57, 0xE5, 0x15, 0xE9, 0x29, 0x08, 0x38, 0x47, 0xF1, 0x2F, 0x53,
  0x84, 0x4F, 0x33, 0xF5, 0x38, 0x44, 0xF3, 0x0F, 0x73, 0x89, 0x17, 0xF1, 0x09, 0xE3, 0x03, 0xD9,
  0x30, 0x9B, 0x09, 0x60, 0x14,
  // "»" (U+00BB)
  0x10, 0x14, 0x01, 0x48, 0x5B, 0xE2, 0x01, 0xDC, 0x48, 0x64, 0xFD, 0x10, 0x8F, 0xA4, 0x81, 0x7F,
  0xB2, 0x81, 0xBF, 0x84, 0x86, 0xAF, 0x90, 0x1D, 0xF5, 0x48, 0x3D, 0xF5, 0x02, 0xA0, 0x22, 0x86,
  0x5F, 0xD1, 0x09, 0xFA, 0x28, 0x63, 0xFE, 0x20, 0x7F, 0xC2, 0x87, 0x1E, 0xF3, 0x04, 0xFD, 0x12,
  0x86, 0xCF, 0x60, 0x1E, 0xE3, 0x30, 0x20, 0x63, 0x03, 0x04, 0x40,
  // "¼" (U+00BC)
  0x18, 0x21, 0xAF, 0xA7, 0x81, 0xCE, 0x12, 0x83, 0x3D, 0xEF, 0xA6, 0x81, 0x6F, 0x53, 0x83, 0xED,
  0x2F, 0xA5, 0x81, 0x1E, 0xB4, 0x03, 0x29, 0x0A, 0x58, 0x1A, 0xF2, 0x79, 0x0A, 0x48, 0x14, 0xF7,
  0x71, 0x90, 0xA4, 0x00, 0xD7, 0x29, 0x0A, 0x38, 0x17, 0xF4, 0x72, 0x90, 0xA2, 0x81, 0x2F, 0xA2,
  0x82, 0x1D, 0xF3, 0x49, 0x0A, 0x28, 0x1B, 0xE1, 0x20, 0xBA, 0x03, 0x49, 0x83, 0xA0, 0x5F, 0x62,
  0x83, 0x7D, 0x9F, 0x36, 0x81, 0x1E, 0xC2, 0x84, 0x4F, 0x39, 0xF3, 0x68, 0x91, 0x9F, 0x30, 0x2E,
  0x60, 0x9F, 0x35, 0x81, 0x3F, 0x92, 0x86, 0xCB, 0x22, 0xAF, 0x41, 0x48, 0x3C, 0xE1, 0x04, 0xF0,
  0xA3, 0x81, 0x6F, 0x52, 0x87, 0x14, 0x44, 0x4B, 0xF7, 0x32, 0x81, 0x1E, 0xB7, 0x18, 0x19, 0xF3,
  0x38, 0x1A, 0xF2, 0x71, 0x81, 0x9F, 0x31,
  // "½" (U+00BD)
  0x28, 0x22, 0xDF, 0x66, 0x81, 0x8F, 0x34, 0x83, 0x5E, 0xEF, 0x65, 0x81, 0x2F, 0x94, 0x84, 0x3F,
  0xB5, 0xF6, 0x58, 0x1B, 0xE1, 0x58, 0x34, 0x04, 0xF6, 0x48, 0x16, 0xF6, 0x71, 0x81, 0x4F, 0x63,
  0x81, 0x1E, 0xC7, 0x28, 0x14, 0xF6, 0x38, 0x19, 0xF3, 0x72, 0x81, 0x4F, 0x62, 0x81, 0x3F, 0x83,
  0x01, 0x68, 0x14, 0xF6, 0x28, 0x3C, 0xD0, 0x3C, 0xA0, 0xE0, 0x64, 0x89, 0x54, 0xF6, 0x07, 0xF5,
  0x0C, 0xA6, 0x5C, 0xF3, 0x38, 0x44, 0xF6, 0x1E, 0xB6, 0x81, 0x4F, 0x66, 0x81, 0xAF, 0x26, 0x81,
  0x6F, 0x45, 0x81, 0x4F, 0x76, 0x81, 0x1E, 0xB6, 0x00, 0xD6, 0x81, 0x2D, 0xB6, 0x81, 0x8F, 0x45,
  0x81, 0x3E, 0xA6, 0x81, 0x2F, 0xA5, 0x81, 0x4E, 0x97, 0x81, 0xBE, 0x14, 0x03, 0xA8, 0x00, 0xB0,
  0x52, 0x81, 0x6F, 0x65, 0x04, 0xE0, 0x70,
  // "¾" (U+00BE)
  0x18, 0x31, 0x8B, 0xA7, 0x71, 0x81, 0x7B, 0x12, 0x04, 0x0E, 0xC0, 0xB6, 0x81, 0x3F, 0x93, 0x86,
  0x1B, 0x41, 0x1B, 0xF3, 0x58, 0x1C, 0xE1, 0x71, 0x81, 0x6F, 0x44, 0x81, 0x5F, 0x67, 0x18, 0x13,
  0xDE, 0x50, 0xE0, 0xC6, 0x01, 0xB0, 0xD0, 0x34, 0x81, 0x8F, 0x37, 0x84, 0xBB, 0xDF, 0xB1, 0x28,
  0x12, 0xFA, 0x74, 0x81, 0x6F, 0x72, 0x81, 0xBE, 0x17, 0x48, 0x52, 0xF9, 0x05, 0xF7, 0x28, 0x96,
  0x2E, 0xF1, 0x05, 0x51, 0x01, 0xAF, 0x70, 0xDD, 0x30, 0xCA, 0x81, 0x10, 0x9D, 0x83, 0xC0, 0x7F,
  0x42, 0x83, 0x9C, 0xBF, 0x12, 0x87, 0x69, 0xBA, 0x60, 0x1E, 0xB2, 0x84, 0x6E, 0x2B, 0xF1, 0x71,
  0x89, 0x1A, 0xF2, 0x03, 0xF4, 0x0B, 0xF1, 0x78, 0x93, 0x4F, 0x80, 0x1D, 0xA2, 0x2B, 0xF3, 0x16,
  0x00, 0xD2, 0x06, 0xF0, 0x85, 0x81, 0x7F, 0x52, 0x87, 0x24, 0x44, 0x4C, 0xF5, 0x24, 0x81, 0x1E,
  0xB7, 0x18, 0x1B, 0xF1, 0x58, 0x19, 0xF2, 0x71, 0x81, 0xBF, 0x11,
  // "¿" (U+00BF)
  0x48, 0x15, 0xEB, 0x70, 0xBA, 0x02, 0x68, 0x16, 0xEB, 0x77, 0x40, 0x01, 0x78, 0x11, 0xF9, 0x78,
  0x13, 0xF8, 0x68, 0x21, 0xCF, 0x35, 0x82, 0x1C, 0xF9, 0x58, 0x22, 0xDF, 0x85, 0x82, 0x1E, 0xF6,
  0x68, 0x18, 0xF9, 0x78, 0x1B, 0xF4, 0x78, 0x1B, 0xF5, 0x78, 0x27, 0xFC, 0x13, 0x83, 0x29, 0x11,
  0xDA, 0x81, 0xCC, 0xDA, 0x83, 0x80, 0x18, 0xDA, 0x81, 0xDA, 0x51,
  // "À" (U+00C0)
  0x58, 0x1D, 0xFB, 0x76, 0x82, 0x2E, 0xF4, 0x76, 0x81, 0x3E, 0xD7, 0x78, 0x13, 0xE9, 0x77, 0x77,
  0x81, 0x7F, 0xC7, 0x60, 0xDA, 0x03, 0x74, 0x83, 0x4F, 0xDF, 0x97, 0x48, 0x3A, 0xF5, 0xEE, 0x73,
  0x85, 0x1F, 0xE0, 0xAF, 0x67, 0x28, 0x57, 0xF9, 0x04, 0xFC, 0x72, 0x81, 0xDF, 0x42, 0x81, 0xEF,
  0x27, 0x81, 0x3F, 0xD3, 0x81, 0x8F, 0x97, 0x81, 0xAF, 0x73, 0x81, 0x2F, 0xE6, 0x01, 0xA0, 0x24,
  0x81, 0xCF, 0x55, 0x06, 0xFA, 0x0B, 0x50, 0xC9, 0x80, 0x3E, 0xA0, 0x23, 0x81, 0x3F, 0xE7, 0x81,
  0xBF, 0x83, 0x81, 0x9F, 0x97, 0x81, 0x5F, 0xE3, 0x81, 0xEF, 0x27, 0x18, 0x5E, 0xF5, 0x06, 0xFC,
  0x72, 0x85, 0x8F, 0xB0, 0xCF, 0x67, 0x20, 0x2A, 0x01,
  // "Á" (U+00C1)
  0x78, 0x21, 0xEF, 0x97, 0x58, 0x19, 0xFC, 0x75, 0x82, 0x3F, 0xD1, 0x75, 0x81, 0xDC, 0x17, 0x77,
  0x71, 0x81, 0x7F, 0xC7, 0x60, 0xDA, 0x03, 0x74, 0x83, 0x4F, 0xDF, 0x97, 0x48, 0x3A, 0xF5, 0xEE,
  0x73, 0x85, 0x1F, 0xE0, 0xAF, 0x67, 0x28, 0x57, 0xF9, 0x04, 0xFC, 0x72, 0x81, 0xDF, 0x42, 0x81,
  0xEF, 0x27, 0x81, 0x3F, 0xD3, 0x81, 0x8F, 0x97, 0x81, 0xAF, 0x73, 0x81, 0x2F, 0xE6, 0x01, 0xA0,
  0x24, 0x81, 0xCF, 0x55, 0x06, 0xFA, 0x0B, 0x50, 0xC9, 0x80, 0x3E, 0xA0, 0x23, 0x81, 0x3F, 0xE7,
  0x81, 0xBF, 0x83, 0x81, 0x9F, 0x97, 0x81, 0x5F, 0xE3, 0x81, 0xEF, 0x27, 0x18, 0x5E, 0xF5, 0x06,
  0xFC, 0x72, 0x85, 0x8F, 0xB0, 0xCF, 0x67, 0x20, 0x2A, 0x01,
  // "Â" (U+00C2)
  0x60, 0x6A, 0x06, 0x74, 0x84, 0x2E, 0xEF, 0xE2, 0x72, 0x86, 0x1D, 0xE3, 0x4F, 0xD1, 0x71, 0x81,
  0xCD, 0x22, 0x81, 0x3D, 0xC7, 0x77, 0x58, 0x17, 0xFC, 0x76, 0x0D, 0xA0, 0x37, 0x48, 0x34, 0xFD,
  0xF9, 0x74, 0x83, 0xAF, 0x5E, 0xE7, 0x38, 0x51, 0xFE, 0x0A, 0xF6, 0x72, 0x85, 0x7F, 0x90, 0x4F,
  0xC7, 0x28, 0x1D, 0xF4, 0x28, 0x1E, 0xF2, 0x78, 0x13, 0xFD, 0x38, 0x18, 0xF9, 0x78, 0x1A, 0xF7,
  0x38, 0x12, 0xFE, 0x60, 0x1A, 0x02, 0x48, 0x1C, 0xF5, 0x50, 0x6F, 0xA0, 0xB5, 0x0C, 0x98, 0x03,
  0xEA, 0x02, 0x38, 0x13, 0xFE, 0x78, 0x1B, 0xF8, 0x38, 0x19, 0xF9, 0x78, 0x15, 0xFE, 0x38, 0x1E,
  0xF2, 0x71, 0x85, 0xEF, 0x50, 0x6F, 0xC7, 0x28, 0x58, 0xFB, 0x0C, 0xF6, 0x72, 0x02, 0xA0, 0x10,
  // "Ã" (U+00C3)
  0x38, 0x31, 0xAE, 0xC6, 0x20, 0x0A, 0x78, 0x79, 0xFC, 0xEF, 0xEC, 0xF5, 0x78, 0x6E, 0x60, 0x18,
  0xDE, 0x87, 0x77, 0x68, 0x17, 0xFC, 0x76, 0x0D, 0xA0, 0x37, 0x48, 0x34, 0xFD, 0xF9, 0x74, 0x83,
  0xAF, 0x5E, 0xE7, 0x38, 0x51, 0xFE, 0x0A, 0xF6, 0x72, 0x85, 0x7F, 0x90, 0x4F, 0xC7, 0x28, 0x1D,
  0xF4, 0x28, 0x1E, 0xF2, 0x78, 0x13, 0xFD, 0x38, 0x18, 0xF9, 0x78, 0x1A, 0xF7, 0x38, 0x12, 0xFE,
  0x60, 0x1A, 0x02, 0x48, 0x1C, 0xF5, 0x50, 0x6F, 0xA0, 0xB5, 0x0C, 0x98, 0x03, 0xEA, 0x02, 0x38,
  0x13, 0xFE, 0x78, 0x1B, 0xF8, 0x38, 0x19, 0xF9, 0x78, 0x15, 0xFE, 0x38, 0x1E, 0xF2, 0x71, 0x85,
  0xEF, 0x50, 0x6F, 0xC7, 0x28, 0x58, 0xFB, 0x0C, 0xF6, 0x72, 0x02, 0xA0, 0x10,
  // "Ä" (U+00C4)
  0x48, 0x12, 0xA6, 0x28, 0x17, 0xA1, 0x71, 0x81, 0x3E, 0x92, 0x81, 0xAE, 0x28, 0x0C, 0x60, 0x81,
  0x7F, 0xC7, 0x60, 0xDA, 0x03, 0x74, 0x83, 0x4F, 0xDF, 0x97, 0x48, 0x3A, 0xF5, 0xEE, 0x73, 0x85,
  0x1F, 0xE0, 0xAF, 0x67, 0x28, 0x57, 0xF9, 0x04, 0xFC, 0x72, 0x81, 0xDF, 0x42, 0x81, 0xEF, 0x27,
  0x81, 0x3F, 0xD3, 0x81, 0x8F, 0x97, 0x81, 0xAF, 0x73, 0x81, 0x2F, 0xE6, 0x01, 0xA0, 0x24, 0x81,
  0xCF, 0x55, 0x06, 0xFA, 0x0B, 0x50, 0xC9, 0x80, 0x3E, 0xA0, 0x23, 0x81, 0x3F, 0xE7, 0x81, 0xBF,
  0x83, 0x81, 0x9F, 0x97, 0x81, 0x5F, 0xE3, 0x81, 0xEF, 0x27, 0x18, 0x5E, 0xF5, 0x06, 0xFC, 0x72,
  0x85, 0x8F, 0xB0, 0xCF, 0x67, 0x20, 0x2A, 0x01,
  // "Å" (U+00C5)
  0x58, 0x32, 0xCE, 0xC4, 0x74, 0x83, 0xC9, 0x07, 0xE7, 0x49, 0x83, 0x40, 0x1F, 0x27, 0x38, 0x3C,
  0x90, 0x7E, 0x74, 0x02, 0xB0, 0x47, 0x50, 0xDA, 0x03, 0x74, 0x83, 0x4F, 0xDF, 0x97, 0x48, 0x3A,
  0xF5, 0xEE, 0x73, 0x85, 0x1F, 0xE0, 0xAF, 0x67, 0x28, 0x57, 0xF9, 0x04, 0xFC, 0x72, 0x81, 0xDF,
  0x42, 0x81, 0xEF, 0x27, 0x81, 0x3F, 0xD3, 0x81, 0x8F, 0x97, 0x81, 0xAF, 0x73, 0x81, 0x2F, 0xE6,
  0x01, 0xA0, 0x24, 0x81, 0xCF, 0x55, 0x06, 0xFA, 0x0B, 0x50, 0xC9, 0x80, 0x3E, 0xA0, 0x23, 0x81,
  0x3F, 0xE7, 0x81, 0xBF, 0x83, 0x81, 0x9F, 0x97, 0x81, 0x5F, 0xE3, 0x81, 0xEF, 0x27, 0x18, 0x5E,
  0xF5, 0x06, 0xFC, 0x72, 0x85, 0x8F, 0xB0, 0xCF, 0x67, 0x20, 0x2A, 0x01,
  // "Æ" (U+00C6)
  0x70, 0x2F, 0xC0, 0xA7, 0x82, 0x9F, 0xCC, 0xA8, 0x02, 0xB0, 0x86, 0x85, 0x1F, 0xE1, 0x3F, 0xE7,
  0x68, 0x58, 0xF9, 0x03, 0xFE, 0x75, 0x86, 0x1E, 0xF2, 0x03, 0xFE, 0x75, 0x81, 0x8F, 0xA2, 0x81,
  0x3F, 0xE7, 0x58, 0x1E, 0xF3, 0x28, 0x13, 0xFE, 0x74, 0x81, 0x7F, 0xB3, 0x03, 0xA8, 0x02, 0xB0,
  0x24, 0x81, 0xEF, 0x43, 0x03, 0xF9, 0x03, 0x38, 0x16, 0xFC, 0x48, 0x13, 0xFE, 0x73, 0x0D, 0xF9,
  0x0E, 0x72, 0x81, 0x6F, 0xE8, 0x01, 0xB8, 0x1C, 0xFE, 0x72, 0x81, 0xDF, 0x65, 0x81, 0x3F, 0xE7,
  0x18, 0x15, 0xFD, 0x68, 0x13, 0xFE, 0x71, 0x81, 0xCF, 0x66, 0x81, 0x3F, 0xE7, 0x81, 0x4F, 0xE7,
  0x03, 0xA8, 0x02, 0xB8, 0x28, 0xCF, 0x67, 0x03, 0xF9, 0x0A,
  // "Ç" (U+00C7)
  0x48, 0x71, 0x7B, 0xEF, 0xEC, 0xA5, 0x40, 0x50, 0xEA, 0x81, 0xDC, 0xCB, 0x02, 0x20, 0x7A, 0x09,
  0x01, 0x40, 0x60, 0x82, 0x03, 0xA0, 0x67, 0x38, 0x1B, 0xFA, 0x73, 0x01, 0xA0, 0x37, 0x38, 0x15,
  0xFE, 0x74, 0x81, 0x6F, 0xC7, 0x48, 0x17, 0xFB, 0x74, 0x81, 0x6F, 0xC7, 0x48, 0x15, 0xFE, 0x74,
  0x02, 0xA0, 0x37, 0x48, 0x1C, 0xF9, 0x74, 0x05, 0xA0, 0x57, 0x40, 0xAA, 0x08, 0x01, 0x40, 0x10,
  0x34, 0x09, 0xB8, 0x4D, 0xBC, 0xDF, 0xB5, 0x81, 0x39, 0xDB, 0x81, 0xDA, 0x57, 0x81, 0x2F, 0x37,
  0x48, 0x27, 0xFD, 0x47, 0x48, 0x11, 0xCE, 0x72, 0x83, 0x11, 0x2C, 0xE7, 0x20, 0xAA, 0x0E, 0x05,
  0x72, 0x81, 0x13, 0x26,
  // "È" (U+00C8)
  0x28, 0x1D, 0xFB, 0x78, 0x22, 0xEF, 0x47, 0x81, 0x3E, 0xD7, 0x18, 0x13, 0xE9, 0x76, 0x0A, 0xF9,
  0x82, 0xEA, 0xFD, 0x80, 0x2B, 0x82, 0xAA, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A,
  0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xFD, 0x80, 0x2B, 0x05, 0x0A, 0xF9, 0x82, 0x7A, 0xF7, 0x78,
  0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A,
  0xFD, 0x80, 0x2B, 0x00, 0xAF, 0x90, 0xE0,
  // "É" (U+00C9)
  0x58, 0x21, 0xEF, 0x96, 0x81, 0x9F, 0xC6, 0x82, 0x3F, 0xD1, 0x68, 0x1D, 0xC1, 0x76, 0x0A, 0xF9,
  0x82, 0xEA, 0xFD, 0x80, 0x2B, 0x82, 0xAA, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A,
  0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xFD, 0x80, 0x2B, 0x05, 0x0A, 0xF9, 0x82, 0x7A, 0xF7, 0x78,
  0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A,
  0xFD, 0x80, 0x2B, 0x00, 0xAF, 0x90, 0xE0,
  // "Ê" (U+00CA)
  0x30, 0x6A, 0x06, 0x58, 0x42, 0xEE, 0xFE, 0x23, 0x86, 0x1D, 0xE3, 0x4F, 0xD1, 0x28, 0x1C, 0xD2,
  0x28, 0x13, 0xDC, 0x74, 0x0A, 0xF9, 0x82, 0xEA, 0xFD, 0x80, 0x2B, 0x82, 0xAA, 0xF7, 0x78, 0x1A,
  0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xFD, 0x80, 0x2B, 0x05,
  0x0A, 0xF9, 0x82, 0x7A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A,
  0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xFD, 0x80, 0x2B, 0x00, 0xAF, 0x90, 0xE0,
  // "Ë" (U+00CB)
  0x18, 0x12, 0xA6, 0x28, 0x17, 0xA1, 0x28, 0x13, 0xE9, 0x28, 0x1A, 0xE2, 0x77, 0x70, 0xAF, 0x98,
  0x2E, 0xAF, 0xD8, 0x02, 0xB8, 0x2A, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF,
  0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0xD8, 0x02, 0xB0, 0x50, 0xAF, 0x98, 0x27, 0xAF, 0x77, 0x81,
  0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF,
  0xD8, 0x02, 0xB0, 0x0A, 0xF9, 0x0E,
  // "Ì" (U+00CC)
  0x81, 0xDF, 0xB4, 0x82, 0x2E, 0xF4, 0x48, 0x13, 0xED, 0x58, 0x13, 0xE9, 0x72, 0xE8, 0x12, 0x9C,
  0xA8, 0x1D, 0x91, 0x2A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A,
  0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x20, 0x50, 0x9A,
  0x09, 0x05, 0x1E, 0x02,
  // "Í" (U+00CD)
  0x38, 0x21, 0xEF, 0x93, 0x81, 0x9F, 0xC3, 0x82, 0x3F, 0xD1, 0x38, 0x1D, 0xC1, 0x72, 0xE8, 0x12,
  0x9C, 0xA8, 0x1D, 0x91, 0x2A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02,
  0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x20, 0x50,
  0x9A, 0x09, 0x05, 0x1E, 0x02,
  // "Î" (U+00CE)
  0x20, 0x6A, 0x06, 0x38, 0xA0, 0x2E, 0xEF, 0xE2, 0x01, 0xDE, 0x34, 0xFD, 0x1C, 0xD2, 0x28, 0x13,
  0xDC, 0x72, 0xE8, 0x22, 0x09, 0xCA, 0x81, 0xD9, 0x13, 0xA0, 0x25, 0xA0, 0x25, 0xA0, 0x25, 0xA0,
  0x25, 0xA0, 0x25, 0xA0, 0x25, 0xA0, 0x25, 0xA0, 0x25, 0xA0, 0x25, 0xA0, 0x25, 0xA0, 0x25, 0xA0,
  0x25, 0xA0, 0x23, 0x05, 0x09, 0xA0, 0x90, 0x52, 0xE0, 0x20,
  // "Ï" (U+00CF)
  0x81, 0x2A, 0x62, 0x84, 0x7A, 0x13, 0xE9, 0x28, 0x1A, 0xE2, 0x77, 0x3E, 0x82, 0x20, 0x9C, 0xA8,
  0x1D, 0x91, 0x3A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02,
  0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x30, 0x50, 0x9A, 0x09,
  0x05, 0x2E, 0x02,
  // "Ð" (U+00D0)
  0x20, 0x7D, 0x82, 0xEC, 0x93, 0x68, 0x57, 0xFE, 0xBB, 0xBD, 0xB0, 0xB0, 0x14, 0x81, 0x7F, 0xA5,
  0x83, 0x5D, 0xFE, 0x13, 0x81, 0x7F, 0xA7, 0x81, 0xCF, 0xC3, 0x81, 0x7F, 0xA7, 0x01, 0xA0, 0x52,
  0x81, 0x7F, 0xA7, 0x18, 0x1A, 0xFA, 0x28, 0x17, 0xFA, 0x71, 0x81, 0x6F, 0xE2, 0x81, 0x7F, 0xA7,
  0x10, 0x4A, 0x04, 0xF0, 0xE4, 0x03, 0xA8, 0x73, 0xBD, 0xFE, 0xBB, 0xBA, 0x40, 0x4A, 0x28, 0x17,
  0xFA, 0x71, 0x81, 0x6F, 0xD2, 0x81, 0x7F, 0xA7, 0x18, 0x1B, 0xF9, 0x28, 0x17, 0xFA, 0x70, 0x3A,
  0x04, 0x28, 0x17, 0xFA, 0x68, 0x21, 0xDF, 0xB3, 0x81, 0x7F, 0xA4, 0x84, 0x17, 0xEF, 0xD1, 0x38,
  0x57, 0xFE, 0xBB, 0xCD, 0xB0, 0xA0, 0x14, 0x07, 0xD8, 0x2E, 0xB8, 0x24,
  // "Ñ" (U+00D1)
  0x38, 0x31, 0xAE, 0xC6, 0x20, 0x0A, 0x58, 0x79, 0xFC, 0xEF, 0xEC, 0xF5, 0x58, 0x6E, 0x60, 0x18,
  0xDE, 0x87, 0x73, 0x0A, 0xA0, 0x27, 0x82, 0x1F, 0xEA, 0xA0, 0xC7, 0x82, 0x1F, 0xEA, 0xB0, 0x66,
  0x87, 0x1F, 0xEA, 0xFA, 0xFE, 0x15, 0x87, 0x1F, 0xEA, 0xF3, 0xCF, 0xB5, 0x85, 0x1F, 0xEA, 0xF3,
  0x3A, 0x05, 0x48, 0x91, 0x1F, 0xEA, 0xF4, 0x08, 0xFE, 0x13, 0x84, 0x1F, 0xEA, 0xF4, 0x28, 0x1D,
  0xFA, 0x38, 0x41, 0xFE, 0xAF, 0x42, 0x03, 0xA0, 0x42, 0x84, 0x1F, 0xEA, 0xF4, 0x38, 0x18, 0xFD,
  0x28, 0x41, 0xFE, 0xAF, 0x44, 0x89, 0x0D, 0xF9, 0x01, 0xFE, 0xAF, 0x44, 0x03, 0xA8, 0x53, 0x1F,
  0xEA, 0xF4, 0x58, 0x78, 0xFD, 0x0F, 0xEA, 0xF4, 0x68, 0x6D, 0xF8, 0xFE, 0xAF, 0x46, 0x04, 0xB8,
  0x2E, 0xAF, 0x47, 0x09, 0xA8, 0x2E, 0xAF, 0x47, 0x18, 0x1D, 0xFE,
  // "Ò" (U+00D2)
  0x58, 0x1D, 0xFB, 0x77, 0x82, 0x2E, 0xF4, 0x77, 0x81, 0x3E, 0xD7, 0x71, 0x81, 0x3E, 0x97, 0x77,
  0x78, 0x73, 0x9C, 0xEF, 0xEC, 0x71, 0x70, 0x8B, 0x81, 0xCB, 0xDA, 0x0E, 0x04, 0x58, 0x2A, 0xFE,
  0x64, 0x01, 0x08, 0xA0, 0x53, 0x05, 0xA0, 0x37, 0x82, 0x6F, 0xE1, 0x28, 0x1C, 0xF8, 0x72, 0x83,
  0xCF, 0x80, 0x2A, 0x02, 0x72, 0x85, 0x6F, 0xD0, 0x5F, 0xE7, 0x30, 0x2A, 0x82, 0x16, 0xFC, 0x74,
  0xA8, 0x22, 0x7F, 0xB7, 0x4A, 0x82, 0x36, 0xFC, 0x74, 0xA8, 0x22, 0x5F, 0xE7, 0x30, 0x2A, 0x00,
  0x1A, 0x02, 0x72, 0x81, 0x6F, 0xD2, 0x81, 0xCF, 0x87, 0x28, 0x1C, 0xF8, 0x20, 0x5A, 0x03, 0x78,
  0x26, 0xFE, 0x13, 0x82, 0xAF, 0xE6, 0x40, 0x10, 0x8A, 0x05, 0x50, 0x8B, 0x81, 0xCB, 0xDA, 0x0E,
  0x04, 0x78, 0x73, 0x9C, 0xEF, 0xEC, 0x71, 0x40,
  // "Ó" (U+00D3)
  0x71, 0x82, 0x1E, 0xF9, 0x76, 0x81, 0x9F, 0xC7, 0x68, 0x23, 0xFD, 0x17, 0x68, 0x1D, 0xC1, 0x77,
  0x77, 0x87, 0x39, 0xCE, 0xFE, 0xC7, 0x17, 0x08, 0xB8, 0x1C, 0xBD, 0xA0, 0xE0, 0x45, 0x82, 0xAF,
  0xE6, 0x40, 0x10, 0x8A, 0x05, 0x30, 0x5A, 0x03, 0x78, 0x26, 0xFE, 0x12, 0x81, 0xCF, 0x87, 0x28,
  0x3C, 0xF8, 0x02, 0xA0, 0x27, 0x28, 0x56, 0xFD, 0x05, 0xFE, 0x73, 0x02, 0xA8, 0x21, 0x6F, 0xC7,
  0x4A, 0x82, 0x27, 0xFB, 0x74, 0xA8, 0x23, 0x6F, 0xC7, 0x4A, 0x82, 0x25, 0xFE, 0x73, 0x02, 0xA0,
  0x01, 0xA0, 0x27, 0x28, 0x16, 0xFD, 0x28, 0x1C, 0xF8, 0x72, 0x81, 0xCF, 0x82, 0x05, 0xA0, 0x37,
  0x82, 0x6F, 0xE1, 0x38, 0x2A, 0xFE, 0x64, 0x01, 0x08, 0xA0, 0x55, 0x08, 0xB8, 0x1C, 0xBD, 0xA0,
  0xE0, 0x47, 0x87, 0x39, 0xCE, 0xFE, 0xC7, 0x14,
  // "Ô" (U+00D4)
  0x60, 0x6A, 0x06, 0x75, 0x84, 0x2E, 0xEF, 0xE2, 0x73, 0x86, 0x1D, 0xE3, 0x4F, 0xD1, 0x72, 0x81,
  0xCD, 0x22, 0x81, 0x3D, 0xC7, 0x77, 0x58, 0x73, 0x9C, 0xEF, 0xEC, 0x71, 0x70, 0x8B, 0x81, 0xCB,
  0xDA, 0x0E, 0x04, 0x58, 0x2A, 0xFE, 0x64, 0x01, 0x08, 0xA0, 0x53, 0x05, 0xA0, 0x37, 0x82, 0x6F,
  0xE1, 0x28, 0x1C, 0xF8, 0x72, 0x83, 0xCF, 0x80, 0x2A, 0x02, 0x72, 0x85, 0x6F, 0xD0, 0x5F, 0xE7,
  0x30, 0x2A, 0x82, 0x16, 0xFC, 0x74, 0xA8, 0x22, 0x7F, 0xB7, 0x4A, 0x82, 0x36, 0xFC, 0x74, 0xA8,
  0x22, 0x5F, 0xE7, 0x30, 0x2A, 0x00, 0x1A, 0x02, 0x72, 0x81, 0x6F, 0xD2, 0x81, 0xCF, 0x87, 0x28,
  0x1C, 0xF8, 0x20, 0x5A, 0x03, 0x78, 0x26, 0xFE, 0x13, 0x82, 0xAF, 0xE6, 0x40, 0x10, 0x8A, 0x05,
  0x50, 0x8B, 0x81, 0xCB, 0xDA, 0x0E, 0x04, 0x78, 0x73, 0x9C, 0xEF, 0xEC, 0x71, 0x40,
  // "Õ" (U+00D5)
  0x48, 0x31, 0xAE, 0xC6, 0x20, 0x0A, 0x71, 0x87, 0x9F, 0xCE, 0xFE, 0xCF, 0x57, 0x18, 0x6E, 0x60,
  0x18, 0xDE, 0x87, 0x77, 0x58, 0x73, 0x9C, 0xEF, 0xEC, 0x71, 0x70, 0x8B, 0x81, 0xCB, 0xDA, 0x0E,
  0x04, 0x58, 0x2A, 0xFE, 0x64, 0x01, 0x08, 0xA0, 0x53, 0x05, 0xA0, 0x37, 0x82, 0x6F, 0xE1, 0x28,
  0x1C, 0xF8, 0x72, 0x83, 0xCF, 0x80, 0x2A, 0x02, 0x72, 0x85, 0x6F, 0xD0, 0x5F, 0xE7, 0x30, 0x2A,
  0x82, 0x16, 0xFC, 0x74, 0xA8, 0x22, 0x7F, 0xB7, 0x4A, 0x82, 0x36, 0xFC, 0x74, 0xA8, 0x22, 0x5F,
  0xE7, 0x30, 0x2A, 0x00, 0x1A, 0x02, 0x72, 0x81, 0x6F, 0xD2, 0x81, 0xCF, 0x87, 0x28, 0x1C, 0xF8,
  0x20, 0x5A, 0x03, 0x78, 0x26, 0xFE, 0x13, 0x82, 0xAF, 0xE6, 0x40, 0x10, 0x8A, 0x05, 0x50, 0x8B,
  0x81, 0xCB, 0xDA, 0x0E, 0x04, 0x78, 0x73, 0x9C, 0xEF, 0xEC, 0x71, 0x40,
  // "Ö" (U+00D6)
  0x48, 0x12, 0xA6, 0x28, 0x17, 0xA1, 0x72, 0x81, 0x3E, 0x92, 0x81, 0xAE, 0x28, 0x0C, 0x70, 0x87,
  0x39, 0xCE, 0xFE, 0xC7, 0x17, 0x08, 0xB8, 0x1C, 0xBD, 0xA0, 0xE0, 0x45, 0x82, 0xAF, 0xE6, 0x40,
  0x10, 0x8A, 0x05, 0x30, 0x5A, 0x03, 0x78, 0x26, 0xFE, 0x12, 0x81, 0xCF, 0x87, 0x28, 0x3C, 0xF8,
  0x02, 0xA0, 0x27, 0x28, 0x56, 0xFD, 0x05, 0xFE, 0x73, 0x02, 0xA8, 0x21, 0x6F, 0xC7, 0x4A, 0x82,
  0x27, 0xFB, 0x74, 0xA8, 0x23, 0x6F, 0xC7, 0x4A, 0x82, 0x25, 0xFE, 0x73, 0x02, 0xA0, 0x01, 0xA0,
  0x27, 0x28, 0x16, 0xFD, 0x28, 0x1C, 0xF8, 0x72, 0x81, 0xCF, 0x82, 0x05, 0xA0, 0x37, 0x82, 0x6F,
  0xE1, 0x38, 0x2A, 0xFE, 0x64, 0x01, 0x08, 0xA0, 0x55, 0x08, 0xB8, 0x1C, 0xBD, 0xA0, 0xE0, 0x47,
  0x87, 0x39, 0xCE, 0xFE, 0xC7, 0x14,
  // "×" (U+00D7)
  0x10, 0x70, 0x26, 0x84, 0x53, 0x3F, 0xD2, 0x48, 0x65, 0xFD, 0x06, 0xFD, 0x22, 0x82, 0x5F, 0xE2,
  0x28, 0x66, 0xFD, 0x25, 0xFE, 0x24, 0x84, 0x6F, 0xEF, 0xE2, 0x60, 0x9A, 0x04, 0x68, 0x45, 0xFE,
  0xFD, 0x24, 0x86, 0x5F, 0xE2, 0x6F, 0xD2, 0x28, 0x25, 0xFE, 0x22, 0x86, 0x6F, 0xD2, 0x2F, 0xE2,
  0x48, 0x46, 0xFD, 0x07, 0x36, 0x06, 0x04,
  // "Ø" (U+00D8)
  0x76, 0x02, 0x01, 0x68, 0x92, 0x39, 0xCE, 0xFE, 0xB6, 0x2D, 0xE1, 0x40, 0x8B, 0x81, 0xCC, 0xEC,
  0x07, 0x48, 0x2A, 0xFE, 0x64, 0x03, 0x0C, 0xA0, 0x43, 0x05, 0xA0, 0x35, 0x01, 0x0E, 0xA0, 0xE0,
  0x12, 0x81, 0xCF, 0x86, 0x86, 0xBF, 0x5D, 0xF8, 0x01, 0xA0, 0x25, 0x89, 0x18, 0xF9, 0x06, 0xFD,
  0x05, 0xFE, 0x58, 0x14, 0xFC, 0x20, 0x3A, 0x82, 0x16, 0xFC, 0x48, 0x21, 0xEE, 0x23, 0xA8, 0x23,
  0x7F, 0xB4, 0x81, 0xBF, 0x64, 0xA8, 0x24, 0x7F, 0xC3, 0x81, 0x7F, 0xA5, 0xA8, 0x22, 0x5F, 0xE2,
  0x81, 0x3F, 0xD5, 0x02, 0xA0, 0x10, 0x2A, 0x83, 0x21, 0xDF, 0x35, 0x81, 0x6F, 0xD2, 0x84, 0xDF,
  0x8A, 0xF7, 0x68, 0x1C, 0xF8, 0x20, 0x6B, 0x0B, 0x68, 0x26, 0xFE, 0x13, 0x0B, 0xA0, 0x84, 0x01,
  0x08, 0xA0, 0x54, 0x0C, 0xC8, 0x1D, 0xBD, 0xA0, 0xE0, 0x44, 0x89, 0x26, 0xF8, 0x39, 0xDE, 0xFE,
  0xC7, 0x16, 0x04, 0x77,
  // "Ù" (U+00D9)
  0x48, 0x1D, 0xFB, 0x74, 0x82, 0x2E, 0xF4, 0x74, 0x81, 0x3E, 0xD7, 0x58, 0x13, 0xE9, 0x77, 0x58,
  0x1D, 0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5D,
  0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4,
  0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71,
  0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5C, 0xF5, 0x71, 0x84, 0xCF, 0x49, 0xF8, 0x71, 0xA8,
  0x32, 0x5F, 0xE1, 0x68, 0x17, 0xFC, 0x28, 0x2C, 0xFC, 0x24, 0x06, 0xA0, 0x42, 0x01, 0x0C, 0xA8,
  0x5D, 0xBC, 0xEF, 0xE5, 0x58, 0x66, 0xBE, 0xFE, 0xC8, 0x23,
  // "Ú" (U+00DA)
  0x68, 0x21, 0xEF, 0x97, 0x38, 0x19, 0xFC, 0x73, 0x82, 0x3F, 0xD1, 0x73, 0x81, 0xDC, 0x17, 0x76,
  0x81, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5,
  0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF,
  0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47,
  0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xCF, 0x57, 0x18, 0x4C, 0xF4, 0x9F, 0x87, 0x1A,
  0x83, 0x25, 0xFE, 0x16, 0x81, 0x7F, 0xC2, 0x82, 0xCF, 0xC2, 0x40, 0x6A, 0x04, 0x20, 0x10, 0xCA,
  0x85, 0xDB, 0xCE, 0xFE, 0x55, 0x86, 0x6B, 0xEF, 0xEC, 0x82, 0x30,
  // "Û" (U+00DB)
  0x50, 0x6A, 0x06, 0x72, 0x84, 0x2E, 0xEF, 0xE2, 0x78, 0x61, 0xDE, 0x34, 0xFD, 0x16, 0x81, 0xCD,
  0x22, 0x81, 0x3D, 0xC7, 0x73, 0x81, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5,
  0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF,
  0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47,
  0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xCF, 0x57, 0x18,
  0x4C, 0xF4, 0x9F, 0x87, 0x1A, 0x83, 0x25, 0xFE, 0x16, 0x81, 0x7F, 0xC2, 0x82, 0xCF, 0xC2, 0x40,
  0x6A, 0x04, 0x20, 0x10, 0xCA, 0x85, 0xDB, 0xCE, 0xFE, 0x55, 0x86, 0x6B, 0xEF, 0xEC, 0x82, 0x30,
  // "Ü" (U+00DC)
  0x38, 0x12, 0xA6, 0x28, 0x17, 0xA1, 0x68, 0x13, 0xE9, 0x28, 0x1A, 0xE2, 0x77, 0x77, 0x38, 0x1D,
  0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4,
  0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71,
  0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84,
  0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5C, 0xF5, 0x71, 0x84, 0xCF, 0x49, 0xF8, 0x71, 0xA8, 0x32,
  0x5F, 0xE1, 0x68, 0x17, 0xFC, 0x28, 0x2C, 0xFC, 0x24, 0x06, 0xA0, 0x42, 0x01, 0x0C, 0xA8, 0x5D,
  0xBC, 0xEF, 0xE5, 0x58, 0x66, 0xBE, 0xFE, 0xC8, 0x23,
  // "Ý" (U+00DD)
  0x68, 0x21, 0xEF, 0x97, 0x38, 0x19, 0xFC, 0x73, 0x82, 0x3F, 0xD1, 0x73, 0x81, 0xDC, 0x17, 0x76,
  0x81, 0xBF, 0x97, 0x83, 0x1E, 0xF4, 0x3A, 0x02, 0x68, 0x18, 0xFB, 0x28, 0x1A, 0xFA, 0x50, 0x1A,
  0x03, 0x20, 0x2A, 0x03, 0x48, 0x19, 0xFA, 0x48, 0x18, 0xFB, 0x30, 0x2A, 0x02, 0x48, 0x21, 0xEF,
  0x32, 0x81, 0xAF, 0x96, 0x86, 0x7F, 0xC0, 0x3F, 0xE1, 0x78, 0x4E, 0xF4, 0xBF, 0x77, 0x18, 0x36,
  0xFE, 0xFE, 0x73, 0x0D, 0xA0, 0x67, 0x38, 0x15, 0xFE, 0x74, 0x81, 0x4F, 0xD7, 0x48, 0x14, 0xFD,
  0x74, 0x81, 0x4F, 0xD7, 0x48, 0x14, 0xFD, 0x74, 0x81, 0x4F, 0xD7, 0x48, 0x14, 0xFD, 0x60,
  // "Þ" (U+00DE)
  0x81, 0xAF, 0x77, 0x28, 0x1A, 0xF7, 0x72, 0x81, 0xAF, 0x77, 0x20, 0xAC, 0x82, 0xED, 0xB6, 0x38,
  0x5A, 0xFD, 0xBB, 0xCE, 0xA8, 0x4D, 0x10, 0xAF, 0x74, 0x86, 0x4D, 0xFB, 0x0A, 0xF7, 0x50, 0x3A,
  0x82, 0x1A, 0xF7, 0x6A, 0x82, 0x4A, 0xF7, 0x6A, 0x82, 0x3A, 0xF7, 0x58, 0x54, 0xFE, 0x0A, 0xF7,
  0x48, 0x92, 0x5E, 0xF8, 0x0A, 0xFD, 0xBB, 0xCE, 0xA0, 0x92, 0x0A, 0xC8, 0x2E, 0xD9, 0x43, 0x81,
  0xAF, 0x77, 0x28, 0x1A, 0xF7, 0x72, 0x81, 0xAF, 0x77, 0x28, 0x1A, 0xF7, 0x72,
  // "ß" (U+00DF)
  0x18, 0x61, 0x7C, 0xEF, 0xDB, 0x53, 0x01, 0x0D, 0xA8, 0x1D, 0xCD, 0xA0, 0xC2, 0x82, 0x9F, 0xC1,
  0x38, 0x63, 0xEF, 0x50, 0xDF, 0x45, 0x85, 0xAF, 0x70, 0xEF, 0x25, 0x85, 0xDF, 0x40, 0xEF, 0x23,
  0x82, 0x1B, 0xF9, 0x28, 0x1E, 0xF2, 0x28, 0x21, 0xDF, 0x83, 0x81, 0xEF, 0x22, 0x81, 0xAF, 0x74,
  0x81, 0xEF, 0x22, 0x81, 0xCF, 0x44, 0x81, 0xEF, 0x22, 0x82, 0x8F, 0xD4, 0x38, 0x1E, 0xF2, 0x30,
  0x9A, 0x08, 0x28, 0x1E, 0xF2, 0x48, 0x65, 0xEF, 0xB0, 0xEF, 0x25, 0x85, 0x1C, 0xF9, 0xEF, 0x26,
  0x84, 0x2F, 0xEE, 0xF2, 0x7A, 0x84, 0xEF, 0x20, 0x61, 0x38, 0x92, 0x7F, 0xDE, 0xF2, 0x0D, 0xFD,
  0xBD, 0xA8, 0x92, 0x5E, 0xF2, 0x04, 0xBE, 0xFD, 0xA3, 0x10,
  // "à" (U+00E0)
  0x38, 0x1D, 0xFB, 0x71, 0x82, 0x2E, 0xF4, 0x71, 0x81, 0x3E, 0xD7, 0x28, 0x13, 0xE9, 0x77, 0x28,
  0x54, 0x9D, 0xFE, 0xC7, 0x30, 0x4A, 0x81, 0xDC, 0xDA, 0x0B, 0x30, 0x80, 0x23, 0x03, 0xA0, 0x37,
  0x18, 0x1A, 0xF7, 0x71, 0x81, 0x8F, 0x72, 0x89, 0x12, 0x79, 0xBB, 0xBD, 0xF8, 0x09, 0xF9, 0x08,
  0x07, 0xA0, 0x70, 0x23, 0x84, 0x8F, 0x8C, 0xF8, 0x58, 0x49, 0xF8, 0xDF, 0x55, 0x84, 0xDF, 0x8B,
  0xFA, 0x30, 0x20, 0xAA, 0x08, 0x04, 0xA8, 0xA1, 0xEC, 0xDF, 0xD6, 0xF8, 0x03, 0xBE, 0xFD, 0x81,
  0x1F, 0x80,
  // "á" (U+00E1)
  0x58, 0x21, 0xEF, 0x97, 0x81, 0x9F, 0xC7, 0x82, 0x3F, 0xD1, 0x78, 0x1D, 0xC1, 0x77, 0x38, 0x54,
  0x9D, 0xFE, 0xC7, 0x30, 0x4A, 0x81, 0xDC, 0xDA, 0x0B, 0x30, 0x80, 0x23, 0x03, 0xA0, 0x37, 0x18,
  0x1A, 0xF7, 0x71, 0x81, 0x8F, 0x72, 0x89, 0x12, 0x79, 0xBB, 0xBD, 0xF8, 0x09, 0xF9, 0x08, 0x07,
  0xA0, 0x70, 0x23, 0x84, 0x8F, 0x8C, 0xF8, 0x58, 0x49, 0xF8, 0xDF, 0x55, 0x84, 0xDF, 0x8B, 0xFA,
  0x30, 0x20, 0xAA, 0x08, 0x04, 0xA8, 0xA1, 0xEC, 0xDF, 0xD6, 0xF8, 0x03, 0xBE, 0xFD, 0x81, 0x1F,
  0x80,
  // "â" (U+00E2)
  0x40, 0x6A, 0x06, 0x68, 0x42, 0xEE, 0xFE, 0x24, 0x86, 0x1D, 0xE3, 0x4F, 0xD1, 0x38, 0x1C, 0xD2,
  0x28, 0x13, 0xDC, 0x77, 0x85, 0x49, 0xDF, 0xEC, 0x73, 0x04, 0xA8, 0x1D, 0xCD, 0xA0, 0xB3, 0x08,
  0x02, 0x30, 0x3A, 0x03, 0x71, 0x81, 0xAF, 0x77, 0x18, 0x18, 0xF7, 0x28, 0x91, 0x27, 0x9B, 0xBB,
  0xDF, 0x80, 0x9F, 0x90, 0x80, 0x7A, 0x07, 0x02, 0x38, 0x48, 0xF8, 0xCF, 0x85, 0x84, 0x9F, 0x8D,
  0xF5, 0x58, 0x4D, 0xF8, 0xBF, 0xA3, 0x02, 0x0A, 0xA0, 0x80, 0x4A, 0x8A, 0x1E, 0xCD, 0xFD, 0x6F,
  0x80, 0x3B, 0xEF, 0xD8, 0x11, 0xF8,
  // "ã" (U+00E3)
  0x18, 0x31, 0xAE, 0xC6, 0x20, 0x0A, 0x28, 0x79, 0xFC, 0xEF, 0xEC, 0xF5, 0x28, 0x6E, 0x60, 0x18,
  0xDE, 0x87, 0x71, 0x85, 0x49, 0xDF, 0xEC, 0x73, 0x04, 0xA8, 0x1D, 0xCD, 0xA0, 0xB3, 0x08, 0x02,
  0x30, 0x3A, 0x03, 0x71, 0x81, 0xAF, 0x77, 0x18, 0x18, 0xF7, 0x28, 0x91, 0x27, 0x9B, 0xBB, 0xDF,
  0x80, 0x9F, 0x90, 0x80, 0x7A, 0x07, 0x02, 0x38, 0x48, 0xF8, 0xCF, 0x85, 0x84, 0x9F, 0x8D, 0xF5,
  0x58, 0x4D, 0xF8, 0xBF, 0xA3, 0x02, 0x0A, 0xA0, 0x80, 0x4A, 0x8A, 0x1E, 0xCD, 0xFD, 0x6F, 0x80,
  0x3B, 0xEF, 0xD8, 0x11, 0xF8,
  // "ä" (U+00E4)
  0x28, 0x12, 0xA6, 0x28, 0x17, 0xA1, 0x38, 0x13, 0xE9, 0x28, 0x1A, 0xE2, 0x77, 0x74, 0x85, 0x49,
  0xDF, 0xEC, 0x73, 0x04, 0xA8, 0x1D, 0xCD, 0xA0, 0xB3, 0x08, 0x02, 0x30, 0x3A, 0x03, 0x71, 0x81,
  0xAF, 0x77, 0x18, 0x18, 0xF7, 0x28, 0x91, 0x27, 0x9B, 0xBB, 0xDF, 0x80, 0x9F, 0x90, 0x80, 0x7A,
  0x07, 0x02, 0x38, 0x48, 0xF8, 0xCF, 0x85, 0x84, 0x9F, 0x8D, 0xF5, 0x58, 0x4D, 0xF8, 0xBF, 0xA3,
  0x02, 0x0A, 0xA0, 0x80, 0x4A, 0x8A, 0x1E, 0xCD, 0xFD, 0x6F, 0x80, 0x3B, 0xEF, 0xD8, 0x11, 0xF8,
  // "å" (U+00E5)
  0x38, 0x32, 0xCE, 0xC4, 0x68, 0x3C, 0x90, 0x7E, 0x69, 0x83, 0x40, 0x1F, 0x25, 0x83, 0xC9, 0x07,
  0xE6, 0x83, 0x2C, 0xEC, 0x47, 0x77, 0x68, 0x54, 0x9D, 0xFE, 0xC7, 0x30, 0x4A, 0x81, 0xDC, 0xDA,
  0x0B, 0x30, 0x80, 0x23, 0x03, 0xA0, 0x37, 0x18, 0x1A, 0xF7, 0x71, 0x81, 0x8F, 0x72, 0x89, 0x12,
  0x79, 0xBB, 0xBD, 0xF8, 0x09, 0xF9, 0x08, 0x07, 0xA0, 0x70, 0x23, 0x84, 0x8F, 0x8C, 0xF8, 0x58,
  0x49, 0xF8, 0xDF, 0x55, 0x84, 0xDF, 0x8B, 0xFA, 0x30, 0x20, 0xAA, 0x08, 0x04, 0xA8, 0xA1, 0xEC,
  0xDF, 0xD6, 0xF8, 0x03, 0xBE, 0xFD, 0x81, 0x1F, 0x80,
  // "æ" (U+00E6)
  0x28, 0x95, 0x6B, 0xEF, 0xEA, 0x30, 0x18, 0xDF, 0xD9, 0x13, 0x09, 0xA8, 0x1C, 0xCE, 0xA8, 0x74,
  0xDF, 0xEC, 0xEF, 0xE2, 0x28, 0x12, 0x61, 0x30, 0x8B, 0x07, 0x38, 0x19, 0xFC, 0x72, 0xA0, 0xB5,
  0x81, 0xEF, 0x37, 0x18, 0x1D, 0xF6, 0x58, 0x1C, 0xF6, 0x28, 0x16, 0xBE, 0xFE, 0x81, 0x71, 0xCA,
  0x82, 0xEC, 0xBB, 0xA0, 0xC8, 0x03, 0xB8, 0x36, 0x8F, 0xE3, 0x48, 0x1E, 0xF5, 0x71, 0x81, 0xCF,
  0x65, 0xA0, 0x77, 0x18, 0x1D, 0xF5, 0x40, 0x4A, 0x0D, 0x71, 0x81, 0xAF, 0xA3, 0x84, 0x4D, 0xDC,
  0xF9, 0x48, 0x21, 0x60, 0x3A, 0x86, 0xEC, 0xDF, 0xD2, 0x2D, 0xA8, 0x3C, 0xCD, 0xFE, 0x28, 0x53,
  0xAD, 0xED, 0x81, 0x28, 0x61, 0x8D, 0xEF, 0xDA, 0x51,
  // "ç" (U+00E7)
  0x38, 0x56, 0xBE, 0xFD, 0xB5, 0x20, 0xBA, 0x89, 0x0D, 0xCE, 0xF6, 0x0A, 0xFC, 0x23, 0x81, 0x30,
  0x2A, 0x02, 0x68, 0x17, 0xFB, 0x78, 0x19, 0xF8, 0x78, 0x1A, 0xF7, 0x78, 0x19, 0xF8, 0x78, 0x17,
  0xFB, 0x70, 0x2A, 0x01, 0x78, 0x2B, 0xFC, 0x23, 0x83, 0x13, 0x01, 0xCA, 0x83, 0xCB, 0xDF, 0x83,
  0x06, 0x0C, 0xA8, 0x1E, 0xA3, 0x48, 0x12, 0xF3, 0x78, 0x27, 0xFD, 0x47, 0x81, 0x1C, 0xE5, 0x83,
  0x11, 0x2C, 0xE5, 0x0A, 0xA0, 0xE0, 0x55, 0x81, 0x13, 0x24,
  // "è" (U+00E8)
  0x38, 0x1D, 0xFB, 0x72, 0x82, 0x2E, 0xF4, 0x72, 0x81, 0x3E, 0xD7, 0x38, 0x13, 0xE9, 0x77, 0x58,
  0x46, 0xCE, 0xEC, 0x65, 0x0B, 0xA0, 0xC0, 0xDA, 0x0B, 0x38, 0x29, 0xFB, 0x12, 0x87, 0x1C, 0xF8,
  0x02, 0xFE, 0x14, 0x85, 0x3F, 0xE0, 0x6F, 0xA6, 0x82, 0xEF, 0x39, 0xFB, 0x82, 0x4A, 0xFD, 0x80,
  0x4B, 0x82, 0x39, 0xF8, 0x72, 0x81, 0x7F, 0xB7, 0x20, 0x2A, 0x03, 0x72, 0x82, 0x9F, 0xD3, 0x40,
  0x30, 0x53, 0x0B, 0xA8, 0x4D, 0xBC, 0xEF, 0xB4, 0x86, 0x5B, 0xDF, 0xED, 0x93, 0x10,
  // "é" (U+00E9)
  0x58, 0x21, 0xEF, 0x97, 0x18, 0x19, 0xFC, 0x71, 0x82, 0x3F, 0xD1, 0x71, 0x81, 0xDC, 0x17, 0x76,
  0x84, 0x6C, 0xEE, 0xC6, 0x50, 0xBA, 0x0C, 0x0D, 0xA0, 0xB3, 0x82, 0x9F, 0xB1, 0x28, 0x71, 0xCF,
  0x80, 0x2F, 0xE1, 0x48, 0x53, 0xFE, 0x06, 0xFA, 0x68, 0x2E, 0xF3, 0x9F, 0xB8, 0x24, 0xAF, 0xD8,
  0x04, 0xB8, 0x23, 0x9F, 0x87, 0x28, 0x17, 0xFB, 0x72, 0x02, 0xA0, 0x37, 0x28, 0x29, 0xFD, 0x34,
  0x03, 0x05, 0x30, 0xBA, 0x84, 0xDB, 0xCE, 0xFB, 0x48, 0x65, 0xBD, 0xFE, 0xD9, 0x31,
  // "ê" (U+00EA)
  0x40, 0x6A, 0x06, 0x78, 0x42, 0xEE, 0xFE, 0x25, 0x86, 0x1D, 0xE3, 0x4F, 0xD1, 0x48, 0x1C, 0xD2,
  0x28, 0x13, 0xDC, 0x77, 0x38, 0x46, 0xCE, 0xEC, 0x65, 0x0B, 0xA0, 0xC0, 0xDA, 0x0B, 0x38, 0x29,
  0xFB, 0x12, 0x87, 0x1C, 0xF8, 0x02, 0xFE, 0x14, 0x85, 0x3F, 0xE0, 0x6F, 0xA6, 0x82, 0xEF, 0x39,
  0xFB, 0x82, 0x4A, 0xFD, 0x80, 0x4B, 0x82, 0x39, 0xF8, 0x72, 0x81, 0x7F, 0xB7, 0x20, 0x2A, 0x03,
  0x72, 0x82, 0x9F, 0xD3, 0x40, 0x30, 0x53, 0x0B, 0xA8, 0x4D, 0xBC, 0xEF, 0xB4, 0x86, 0x5B, 0xDF,
  0xED, 0x93, 0x10,
  // "ë" (U+00EB)
  0x28, 0x12, 0xA6, 0x28, 0x17, 0xA1, 0x48, 0x13, 0xE9, 0x28, 0x1A, 0xE2, 0x77, 0x77, 0x18, 0x46,
  0xCE, 0xEC, 0x65, 0x0B, 0xA0, 0xC0, 0xDA, 0x0B, 0x38, 0x29, 0xFB, 0x12, 0x87, 0x1C, 0xF8, 0x02,
  0xFE, 0x14, 0x85, 0x3F, 0xE0, 0x6F, 0xA6, 0x82, 0xEF, 0x39, 0xFB, 0x82, 0x4A, 0xFD, 0x80, 0x4B,
  0x82, 0x39, 0xF8, 0x72, 0x81, 0x7F, 0xB7, 0x20, 0x2A, 0x03, 0x72, 0x82, 0x9F, 0xD3, 0x40, 0x30,
  0x53, 0x0B, 0xA8, 0x4D, 0xBC, 0xEF, 0xB4, 0x86, 0x5B, 0xDF, 0xED, 0x93, 0x10,
  // "ì" (U+00EC)
  0x81, 0xDF, 0xB2, 0x82, 0x2E, 0xF4, 0x28, 0x13, 0xED, 0x38, 0x13, 0xE9, 0x78, 0x1E, 0xF2, 0x28,
  0x1E, 0xF2, 0x28, 0x1E, 0xF2, 0x28, 0x1E, 0xF2, 0x28, 0x1E, 0xF2, 0x28, 0x1E, 0xF2, 0x28, 0x1E,
  0xF2, 0x28, 0x1E, 0xF2, 0x28, 0x1E, 0xF2, 0x28, 0x1E, 0xF2, 0x28, 0x1E, 0xF2, 0x28, 0x1E, 0xF2,
  0x28, 0x1E, 0xF2,
  // "í" (U+00ED)
  0x18, 0x97, 0x1E, 0xF9, 0x09, 0xFC, 0x03, 0xFD, 0x10, 0xDC, 0x17, 0x81, 0xEF, 0x22, 0x81, 0xEF,
  0x22, 0x81, 0xEF, 0x22, 0x81, 0xEF, 0x22, 0x81, 0xEF, 0x22, 0x81, 0xEF, 0x22, 0x81, 0xEF, 0x22,
  0x81, 0xEF, 0x22, 0x81, 0xEF, 0x22, 0x81, 0xEF, 0x22, 0x81, 0xEF, 0x22, 0x81, 0xEF, 0x22, 0x81,
  0xEF, 0x22,
  // "î" (U+00EE)
  0x20, 0x6A, 0x06, 0x38, 0xA0, 0x2E, 0xEF, 0xE2, 0x01, 0xDE, 0x34, 0xFD, 0x1C, 0xD2, 0x28, 0x13,
  0xDC, 0x74, 0x81, 0xEF, 0x25, 0x81, 0xEF, 0x25, 0x81, 0xEF, 0x25, 0x81, 0xEF, 0x25, 0x81, 0xEF,
  0x25, 0x81, 0xEF, 0x25, 0x81, 0xEF, 0x25, 0x81, 0xEF, 0x25, 0x81, 0xEF, 0x25, 0x81, 0xEF, 0x25,
  0x81, 0xEF, 0x25, 0x81, 0xEF, 0x25, 0x81, 0xEF, 0x22,
  // "ï" (U+00EF)
  0x81, 0x2A, 0x62, 0x84, 0x7A, 0x13, 0xE9, 0x28, 0x1A, 0xE2, 0x77, 0x58, 0x1E, 0xF2, 0x58, 0x1E,
  0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2,
  0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58,
  0x1E, 0xF2, 0x20,
  // "ð" (U+00F0)
  0x40, 0x80, 0x13, 0x04, 0x01, 0x58, 0x67, 0xFE, 0x62, 0xBF, 0x96, 0x06, 0x0E, 0xA0, 0xE0, 0x77,
  0x06, 0x0E, 0xA0, 0xC7, 0x85, 0xDF, 0xC3, 0xBF, 0xB6, 0x06, 0x05, 0x28, 0x21, 0xDF, 0x57, 0x38,
  0x12, 0xFD, 0x58, 0x74, 0x9B, 0xB8, 0x39, 0xF6, 0x30, 0xBE, 0x81, 0xBF, 0xB2, 0x86, 0xAF, 0xD4,
  0x10, 0x28, 0xB1, 0x03, 0xA0, 0x25, 0x09, 0xA8, 0x21, 0x7F, 0xA6, 0x01, 0xA8, 0x22, 0xAF, 0x87,
  0x84, 0xEF, 0x39, 0xF7, 0x78, 0x4E, 0xF1, 0x8F, 0xA6, 0x86, 0x1F, 0xE0, 0x3F, 0xE1, 0x58, 0x17,
  0xFA, 0x28, 0x2B, 0xFB, 0x13, 0x05, 0xA0, 0x22, 0x01, 0x0C, 0xA8, 0x1C, 0xBE, 0xA0, 0x55, 0x85,
  0x6B, 0xEF, 0xD9, 0x23,
  // "ñ" (U+00F1)
  0x18, 0x31, 0xAE, 0xC6, 0x20, 0x0A, 0x28, 0x79, 0xFC, 0xEF, 0xEC, 0xF5, 0x28, 0x6E, 0x60, 0x18,
  0xDE, 0x87, 0x68, 0xA0, 0xEC, 0x04, 0xAE, 0xFD, 0x91, 0x0E, 0xF6, 0xFE, 0xCD, 0xA8, 0x1E, 0x1E,
  0xA0, 0x73, 0x85, 0x2D, 0xF8, 0xEF, 0xA5, 0x84, 0x6F, 0xCE, 0xF5, 0x58, 0x43, 0xFD, 0xEF, 0x35,
  0x84, 0x3F, 0xDE, 0xF2, 0x58, 0x43, 0xFD, 0xEF, 0x25, 0x84, 0x3F, 0xDE, 0xF2, 0x58, 0x43, 0xFD,
  0xEF, 0x25, 0x84, 0x3F, 0xDE, 0xF2, 0x58, 0x43, 0xFD, 0xEF, 0x25, 0x84, 0x3F, 0xDE, 0xF2, 0x58,
  0x13, 0xFD,
  // "ò" (U+00F2)
  0x38, 0x1D, 0xFB, 0x73, 0x82, 0x2E, 0xF4, 0x73, 0x81, 0x3E, 0xD7, 0x48, 0x13, 0xE9, 0x77, 0x78,
  0x56, 0xBE, 0xFD, 0x92, 0x40, 0x10, 0xBA, 0x84, 0xCC, 0xEF, 0xE5, 0x38, 0x2A, 0xFC, 0x23, 0x06,
  0xA8, 0x12, 0x02, 0xA0, 0x25, 0x85, 0xAF, 0xA0, 0x7F, 0xB6, 0x85, 0x3F, 0xE0, 0x9F, 0x96, 0x01,
  0xA8, 0x21, 0xAF, 0x87, 0xA8, 0x23, 0x9F, 0x96, 0x01, 0xA8, 0x22, 0x6F, 0xC6, 0x83, 0x3F, 0xE0,
  0x1A, 0x02, 0x58, 0x1A, 0xFA, 0x28, 0x29, 0xFC, 0x23, 0x06, 0xA0, 0x33, 0x0A, 0xA8, 0x1C, 0xCE,
  0xA0, 0x55, 0x85, 0x5B, 0xEF, 0xD9, 0x23,
  // "ó" (U+00F3)
  0x68, 0x21, 0xEF, 0x97, 0x28, 0x19, 0xFC, 0x72, 0x82, 0x3F, 0xD1, 0x72, 0x81, 0xDC, 0x17, 0x77,
  0x85, 0x6B, 0xEF, 0xD9, 0x24, 0x01, 0x0B, 0xA8, 0x4C, 0xCE, 0xFE, 0x53, 0x82, 0xAF, 0xC2, 0x30,
  0x6A, 0x81, 0x20, 0x2A, 0x02, 0x58, 0x5A, 0xFA, 0x07, 0xFB, 0x68, 0x53, 0xFE, 0x09, 0xF9, 0x60,
  0x1A, 0x82, 0x1A, 0xF8, 0x7A, 0x82, 0x39, 0xF9, 0x60, 0x1A, 0x82, 0x26, 0xFC, 0x68, 0x33, 0xFE,
  0x01, 0xA0, 0x25, 0x81, 0xAF, 0xA2, 0x82, 0x9F, 0xC2, 0x30, 0x6A, 0x03, 0x30, 0xAA, 0x81, 0xCC,
  0xEA, 0x05, 0x58, 0x55, 0xBE, 0xFD, 0x92, 0x30,
  // "ô" (U+00F4)
  0x40, 0x6A, 0x06, 0x71, 0x84, 0x2E, 0xEF, 0xE2, 0x68, 0x61, 0xDE, 0x34, 0xFD, 0x15, 0x81, 0xCD,
  0x22, 0x81, 0x3D, 0xC7, 0x75, 0x85, 0x6B, 0xEF, 0xD9, 0x24, 0x01, 0x0B, 0xA8, 0x4C, 0xCE, 0xFE,
  0x53, 0x82, 0xAF, 0xC2, 0x30, 0x6A, 0x81, 0x20, 0x2A, 0x02, 0x58, 0x5A, 0xFA, 0x07, 0xFB, 0x68,
  0x53, 0xFE, 0x09, 0xF9, 0x60, 0x1A, 0x82, 0x1A, 0xF8, 0x7A, 0x82, 0x39, 0xF9, 0x60, 0x1A, 0x82,
  0x26, 0xFC, 0x68, 0x33, 0xFE, 0x01, 0xA0, 0x25, 0x81, 0xAF, 0xA2, 0x82, 0x9F, 0xC2, 0x30, 0x6A,
  0x03, 0x30, 0xAA, 0x81, 0xCC, 0xEA, 0x05, 0x58, 0x55, 0xBE, 0xFD, 0x92, 0x30,
  // "õ" (U+00F5)
  0x28, 0x31, 0xAE, 0xC6, 0x20, 0x0A, 0x48, 0x79, 0xFC, 0xEF, 0xEC, 0xF5, 0x48, 0x6E, 0x60, 0x18,
  0xDE, 0x87, 0x75, 0x85, 0x6B, 0xEF, 0xD9, 0x24, 0x01, 0x0B, 0xA8, 0x4C, 0xCE, 0xFE, 0x53, 0x82,
  0xAF, 0xC2, 0x30, 0x6A, 0x81, 0x20, 0x2A, 0x02, 0x58, 0x5A, 0xFA, 0x07, 0xFB, 0x68, 0x53, 0xFE,
  0x09, 0xF9, 0x60, 0x1A, 0x82, 0x1A, 0xF8, 0x7A, 0x82, 0x39, 0xF9, 0x60, 0x1A, 0x82, 0x26, 0xFC,
  0x68, 0x33, 0xFE, 0x01, 0xA0, 0x25, 0x81, 0xAF, 0xA2, 0x82, 0x9F, 0xC2, 0x30, 0x6A, 0x03, 0x30,
  0xAA, 0x81, 0xCC, 0xEA, 0x05, 0x58, 0x55, 0xBE, 0xFD, 0x92, 0x30,
  // "ö" (U+00F6)
  0x28, 0x12, 0xA6, 0x28, 0x17, 0xA1, 0x58, 0x13, 0xE9, 0x28, 0x1A, 0xE2, 0x77, 0x77, 0x48, 0x56,
  0xBE, 0xFD, 0x92, 0x40, 0x10, 0xBA, 0x84, 0xCC, 0xEF, 0xE5, 0x38, 0x2A, 0xFC, 0x23, 0x06, 0xA8,
  0x12, 0x02, 0xA0, 0x25, 0x85, 0xAF, 0xA0, 0x7F, 0xB6, 0x85, 0x3F, 0xE0, 0x9F, 0x96, 0x01, 0xA8,
  0x21, 0xAF, 0x87, 0xA8, 0x23, 0x9F, 0x96, 0x01, 0xA8, 0x22, 0x6F, 0xC6, 0x83, 0x3F, 0xE0, 0x1A,
  0x02, 0x58, 0x1A, 0xFA, 0x28, 0x29, 0xFC, 0x23, 0x06, 0xA0, 0x33, 0x0A, 0xA8, 0x1C, 0xCE, 0xA0,
  0x55, 0x85, 0x5B, 0xEF, 0xD9, 0x23,
  // "÷" (U+00F7)
  0x48, 0x13, 0xEC, 0x72, 0x07, 0xA0, 0x17, 0x18, 0x12, 0xCA, 0x77, 0x30, 0x98, 0x06, 0xB0, 0x50,
  0xCF, 0xB0, 0x77, 0x77, 0x78, 0x12, 0xCA, 0x72, 0x07, 0xA0, 0x17, 0x18, 0x13, 0xEB, 0x50,
  // "ø" (U+00F8)
  0x73, 0x03, 0x58, 0x76, 0xBE, 0xED, 0x86, 0xF8, 0x20, 0x10, 0xBA, 0x81, 0xCC, 0xEA, 0x0E, 0x01,
  0x28, 0x2A, 0xFC, 0x23, 0x84, 0xDF, 0xE1, 0x02, 0xA0, 0x23, 0x87, 0x7F, 0xEF, 0x90, 0x7F, 0xB3,
  0x89, 0x03, 0xFC, 0x4F, 0xE0, 0x9F, 0x92, 0x82, 0x1D, 0xE2, 0x1A, 0x82, 0x2A, 0xF8, 0x28, 0x1B,
  0xF5, 0x2A, 0x86, 0x39, 0xF8, 0x07, 0xF9, 0x20, 0x1A, 0x85, 0x26, 0xFB, 0x3F, 0xC3, 0x03, 0xA1,
  0x02, 0xA8, 0x1D, 0xE2, 0x38, 0x1A, 0xFA, 0x20, 0x9A, 0x07, 0x30, 0x6A, 0x03, 0x20, 0x6B, 0x81,
  0xDC, 0xEA, 0x05, 0x38, 0x7E, 0xD6, 0xBE, 0xFD, 0x92, 0x40, 0x20, 0x37, 0x30,
  // "ù" (U+00F9)
  0x38, 0x1D, 0xFB, 0x72, 0x82, 0x2E, 0xF4, 0x72, 0x81, 0x3E, 0xD7, 0x38, 0x13, 0xE9, 0x77, 0x20,
  0x1A, 0x68, 0x24, 0xFC, 0x1A, 0x68, 0x24, 0xFC, 0x1A, 0x68, 0x24, 0xFC, 0x1A, 0x68, 0x24, 0xFC,
  0x1A, 0x68, 0x24, 0xFC, 0x1A, 0x68, 0x24, 0xFC, 0x1A, 0x68, 0x24, 0xFC, 0x1A, 0x68, 0x25, 0xFC,
  0x1A, 0x01, 0x58, 0x17, 0xFC, 0x1A, 0x03, 0x58, 0x6D, 0xFC, 0x0B, 0xFC, 0x13, 0x09, 0xA8, 0x1C,
  0x03, 0xA8, 0x6E, 0xCC, 0xEF, 0x7F, 0xC2, 0x89, 0x03, 0xAE, 0xFE, 0xA3, 0x0F, 0xC0,
  // "ú" (U+00FA)
  0x68, 0x21, 0xEF, 0x97, 0x18, 0x19, 0xFC, 0x71, 0x82, 0x3F, 0xD1, 0x71, 0x81, 0xDC, 0x17, 0x72,
  0x01, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F,
  0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x5F,
  0xC1, 0xA0, 0x15, 0x81, 0x7F, 0xC1, 0xA0, 0x35, 0x86, 0xDF, 0xC0, 0xBF, 0xC1, 0x30, 0x9A, 0x81,
  0xC0, 0x3A, 0x86, 0xEC, 0xCE, 0xF7, 0xFC, 0x28, 0x90, 0x3A, 0xEF, 0xEA, 0x30, 0xFC,
  // "û" (U+00FB)
  0x40, 0x6A, 0x06, 0x78, 0x42, 0xEE, 0xFE, 0x25, 0x86, 0x1D, 0xE3, 0x4F, 0xD1, 0x48, 0x1C, 0xD2,
  0x28, 0x13, 0xDC, 0x77, 0x01, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F,
  0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F,
  0xC1, 0xA6, 0x82, 0x5F, 0xC1, 0xA0, 0x15, 0x81, 0x7F, 0xC1, 0xA0, 0x35, 0x86, 0xDF, 0xC0, 0xBF,
  0xC1, 0x30, 0x9A, 0x81, 0xC0, 0x3A, 0x86, 0xEC, 0xCE, 0xF7, 0xFC, 0x28, 0x90, 0x3A, 0xEF, 0xEA,
  0x30, 0xFC,
  // "ü" (U+00FC)
  0x28, 0x12, 0xA6, 0x28, 0x17, 0xA1, 0x48, 0x13, 0xE9, 0x28, 0x1A, 0xE2, 0x77, 0x75, 0x01, 0xA6,
  0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6,
  0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x5F, 0xC1, 0xA0,
  0x15, 0x81, 0x7F, 0xC1, 0xA0, 0x35, 0x86, 0xDF, 0xC0, 0xBF, 0xC1, 0x30, 0x9A, 0x81, 0xC0, 0x3A,
  0x86, 0xEC, 0xCE, 0xF7, 0xFC, 0x28, 0x90, 0x3A, 0xEF, 0xEA, 0x30, 0xFC,
  // "ý" (U+00FD)
  0x68, 0x21, 0xEF, 0x97, 0x28, 0x19, 0xFC, 0x72, 0x82, 0x3F, 0xD1, 0x72, 0x81, 0xDC, 0x17, 0x74,
  0x81, 0xCF, 0x76, 0x03, 0xA8, 0x21, 0x5F, 0xC6, 0x81, 0x8F, 0xA2, 0x81, 0xEF, 0x35, 0x81, 0xEF,
  0x42, 0x81, 0x9F, 0x84, 0x81, 0x4F, 0xE3, 0x81, 0x3F, 0xE4, 0x81, 0x9F, 0x84, 0x81, 0xCF, 0x43,
  0x81, 0xEF, 0x34, 0x81, 0x6F, 0xA2, 0x81, 0x4F, 0xC5, 0x01, 0xA8, 0x31, 0x0A, 0xF7, 0x68, 0x5A,
  0xF6, 0x0E, 0xF1, 0x68, 0x44, 0xFB, 0x4F, 0xB7, 0x18, 0x3D, 0xE9, 0xF5, 0x71, 0x07, 0xA0, 0xE7,
  0x20, 0x1A, 0x09, 0x73, 0x81, 0xEF, 0x37, 0x28, 0x14, 0xFD, 0x73, 0x81, 0xBF, 0x67, 0x28, 0x17,
  0xFE, 0x78, 0x19, 0xBD, 0xA0, 0x47, 0x83, 0x9F, 0xEB, 0x47, 0x10,
  // "þ" (U+00FE)
  0x81, 0xEF, 0x27, 0x28, 0x1E, 0xF2, 0x72, 0x81, 0xEF, 0x27, 0x28, 0x1E, 0xF2, 0x72, 0x81, 0xEF,
  0x27, 0x28, 0x7E, 0xF2, 0x3B, 0xEE, 0xC7, 0x38, 0x5E, 0xF7, 0xFE, 0xCC, 0xA0, 0xB2, 0x0E, 0xA0,
  0x63, 0x86, 0x2D, 0xF8, 0x0E, 0xFA, 0x58, 0x54, 0xFE, 0x0E, 0xF5, 0x68, 0x4E, 0xF3, 0xEF, 0x36,
  0x84, 0xCF, 0x5E, 0xF2, 0x68, 0x4B, 0xF6, 0xEF, 0x36, 0x84, 0xCF, 0x5E, 0xF5, 0x68, 0x4E, 0xF3,
  0xEF, 0xA5, 0x83, 0x5F, 0xE0, 0xEA, 0x06, 0x38, 0x92, 0x2D, 0xF8, 0x0E, 0xF8, 0xFE, 0xCC, 0xA0,
  0xB2, 0x87, 0xEF, 0x14, 0xBE, 0xFC, 0x73, 0x81, 0xEF, 0x27, 0x28, 0x1E, 0xF2, 0x72, 0x81, 0xEF,
  0x27, 0x28, 0x1E, 0xF2, 0x72, 0x81, 0xEF, 0x27, 0x28, 0x1E, 0xF2, 0x72,
  // "ÿ" (U+00FF)
  0x28, 0x12, 0xA6, 0x28, 0x17, 0xA1, 0x58, 0x13, 0xE9, 0x28, 0x1A, 0xE2, 0x77, 0x77, 0x18, 0x1C,
  0xF7, 0x60, 0x3A, 0x82, 0x15, 0xFC, 0x68, 0x18, 0xFA, 0x28, 0x1E, 0xF3, 0x58, 0x1E, 0xF4, 0x28,
  0x19, 0xF8, 0x48, 0x14, 0xFE, 0x38, 0x13, 0xFE, 0x48, 0x19, 0xF8, 0x48, 0x1C, 0xF4, 0x38, 0x1E,
  0xF3, 0x48, 0x16, 0xFA, 0x28, 0x14, 0xFC, 0x50, 0x1A, 0x83, 0x10, 0xAF, 0x76, 0x85, 0xAF, 0x60,
  0xEF, 0x16, 0x84, 0x4F, 0xB4, 0xFB, 0x71, 0x83, 0xDE, 0x9F, 0x57, 0x10, 0x7A, 0x0E, 0x72, 0x01,
  0xA0, 0x97, 0x38, 0x1E, 0xF3, 0x72, 0x81, 0x4F, 0xD7, 0x38, 0x1B, 0xF6, 0x72, 0x81, 0x7F, 0xE7,
  0x81, 0x9B, 0xDA, 0x04, 0x78, 0x39, 0xFE, 0xB4, 0x71,
  // "Ā" (U+0100)
  0x48, 0x03, 0xB0, 0x17, 0x1F, 0x01, 0x77, 0x75, 0x81, 0x7F, 0xC7, 0x60, 0xDA, 0x03, 0x74, 0x83,
  0x4F, 0xDF, 0x97, 0x48, 0x3A, 0xF5, 0xEE, 0x73, 0x85, 0x1F, 0xE0, 0xAF, 0x67, 0x28, 0x57, 0xF9,
  0x04, 0xFC, 0x72, 0x81, 0xDF, 0x42, 0x81, 0xEF, 0x27, 0x81, 0x3F, 0xD3, 0x81, 0x8F, 0x97, 0x81,
  0xAF, 0x73, 0x81, 0x2F, 0xE6, 0x01, 0xA0, 0x24, 0x81, 0xCF, 0x55, 0x06, 0xFA, 0x0B, 0x50, 0xC9,
  0x80, 0x3E, 0xA0, 0x23, 0x81, 0x3F, 0xE7, 0x81, 0xBF, 0x83, 0x81, 0x9F, 0x97, 0x81, 0x5F, 0xE3,
  0x81, 0xEF, 0x27, 0x18, 0x5E, 0xF5, 0x06, 0xFC, 0x72, 0x85, 0x8F, 0xB0, 0xCF, 0x67, 0x20, 0x2A,
  0x01,
  // "ā" (U+0101)
  0x28, 0x03, 0xB0, 0x13, 0xF0, 0x17, 0x78, 0x54, 0x9D, 0xFE, 0xC7, 0x30, 0x4A, 0x81, 0xDC, 0xDA,
  0x0B, 0x30, 0x80, 0x23, 0x03, 0xA0, 0x37, 0x18, 0x1A, 0xF7, 0x71, 0x81, 0x8F, 0x72, 0x89, 0x12,
  0x79, 0xBB, 0xBD, 0xF8, 0x09, 0xF9, 0x08, 0x07, 0xA0, 0x70, 0x23, 0x84, 0x8F, 0x8C, 0xF8, 0x58,
  0x49, 0xF8, 0xDF, 0x55, 0x84, 0xDF, 0x8B, 0xFA, 0x30, 0x20, 0xAA, 0x08, 0x04, 0xA8, 0xA1, 0xEC,
  0xDF, 0xD6, 0xF8, 0x03, 0xBE, 0xFD, 0x81, 0x1F, 0x80,
  // "Ă" (U+0102)
  0x40, 0xE0, 0x73, 0x81, 0x2F, 0x47, 0x18, 0x58, 0xFD, 0xBD, 0xFC, 0x73, 0x84, 0x7D, 0xFD, 0x91,
  0x77, 0x76, 0x81, 0x7F, 0xC7, 0x60, 0xDA, 0x03, 0x74, 0x83, 0x4F, 0xDF, 0x97, 0x48, 0x3A, 0xF5,
  0xEE, 0x73, 0x85, 0x1F, 0xE0, 0xAF, 0x67, 0x28, 0x57, 0xF9, 0x04, 0xFC, 0x72, 0x81, 0xDF, 0x42,
  0x81, 0xEF, 0x27, 0x81, 0x3F, 0xD3, 0x81, 0x8F, 0x97, 0x81, 0xAF, 0x73, 0x81, 0x2F, 0xE6, 0x01,
  0xA0, 0x24, 0x81, 0xCF, 0x55, 0x06, 0xFA, 0x0B, 0x50, 0xC9, 0x80, 0x3E, 0xA0, 0x23, 0x81, 0x3F,
  0xE7, 0x81, 0xBF, 0x83, 0x81, 0x9F, 0x97, 0x81, 0x5F, 0xE3, 0x81, 0xEF, 0x27, 0x18, 0x5E, 0xF5,
  0x06, 0xFC, 0x72, 0x85, 0x8F, 0xB0, 0xCF, 0x67, 0x20, 0x2A, 0x01,
  // "ă" (U+0103)
  0x20, 0xE0, 0x73, 0x81, 0x2F, 0x43, 0x85, 0x8F, 0xDB, 0xDF, 0xC5, 0x84, 0x7D, 0xFD, 0x91, 0x77,
  0x18, 0x54, 0x9D, 0xFE, 0xC7, 0x30, 0x4A, 0x81, 0xDC, 0xDA, 0x0B, 0x30, 0x80, 0x23, 0x03, 0xA0,
  0x37, 0x18, 0x1A, 0xF7, 0x71, 0x81, 0x8F, 0x72, 0x89, 0x12, 0x79, 0xBB, 0xBD, 0xF8, 0x09, 0xF9,
  0x08, 0x07, 0xA0, 0x70, 0x23, 0x84, 0x8F, 0x8C, 0xF8, 0x58, 0x49, 0xF8, 0xDF, 0x55, 0x84, 0xDF,
  0x8B, 0xFA, 0x30, 0x20, 0xAA, 0x08, 0x04, 0xA8, 0xA1, 0xEC, 0xDF, 0xD6, 0xF8, 0x03, 0xBE, 0xFD,
  0x81, 0x1F, 0x80,
  // "Ą" (U+0104)
  0x68, 0x17, 0xFC, 0x76, 0x0D, 0xA0, 0x37, 0x48, 0x34, 0xFD, 0xF9, 0x74, 0x83, 0xAF, 0x5E, 0xE7,
  0x38, 0x51, 0xFE, 0x0A, 0xF6, 0x72, 0x85, 0x7F, 0x90, 0x4F, 0xC7, 0x28, 0x1D, 0xF4, 0x28, 0x1E,
  0xF2, 0x78, 0x13, 0xFD, 0x38, 0x18, 0xF9, 0x78, 0x1A, 0xF7, 0x38, 0x12, 0xFE, 0x60, 0x1A, 0x02,
  0x48, 0x1C, 0xF5, 0x50, 0x6F, 0xA0, 0xB5, 0x0C, 0x98, 0x03, 0xEA, 0x02, 0x38, 0x13, 0xFE, 0x78,
  0x1B, 0xF8, 0x38, 0x19, 0xF9, 0x78, 0x15, 0xFE, 0x38, 0x1E, 0xF2, 0x71, 0x85, 0xEF, 0x50, 0x6F,
  0xC7, 0x28, 0x58, 0xFB, 0x0C, 0xF6, 0x72, 0x07, 0xA0, 0x17, 0x48, 0x13, 0xF5, 0x76, 0x00, 0xC7,
  0x79, 0x0B, 0x77, 0x82, 0xDF, 0xCB, 0x75, 0x82, 0x4D, 0xFC, 0x10,
  // "ą" (U+0105)
  0x28, 0x54, 0x9D, 0xFE, 0xC7, 0x30, 0x4A, 0x81, 0xDC, 0xDA, 0x0B, 0x30, 0x80, 0x23, 0x03, 0xA0,
  0x37, 0x18, 0x1A, 0xF7, 0x71, 0x81, 0x8F, 0x72, 0x89, 0x12, 0x79, 0xBB, 0xBD, 0xF8, 0x09, 0xF9,
  0x08, 0x07, 0xA0, 0x70, 0x23, 0x84, 0x8F, 0x8C, 0xF8, 0x58, 0x49, 0xF8, 0xDF, 0x55, 0x84, 0xDF,
  0x8B, 0xFA, 0x30, 0x20, 0xAA, 0x08, 0x04, 0xA8, 0xA1, 0xEC, 0xDF, 0xD6, 0xF8, 0x03, 0xBE, 0xFD,
  0x81, 0x6F, 0x97, 0x81, 0x3F, 0x57, 0x10, 0x0C, 0x72, 0x90, 0xB7, 0x28, 0x2D, 0xFC, 0xB7, 0x82,
  0x4D, 0xFC,
  // "Ć" (U+0106)
  0x71, 0x82, 0x1E, 0xF9, 0x73, 0x81, 0x9F, 0xC7, 0x38, 0x23, 0xFD, 0x17, 0x38, 0x1D, 0xC1, 0x77,
  0x71, 0x87, 0x17, 0xBE, 0xFE, 0xCA, 0x54, 0x05, 0x0E, 0xA8, 0x1D, 0xCC, 0xB0, 0x22, 0x07, 0xA0,
  0x90, 0x14, 0x06, 0x08, 0x20, 0x3A, 0x06, 0x73, 0x81, 0xBF, 0xA7, 0x30, 0x1A, 0x03, 0x73, 0x81,
  0x5F, 0xE7, 0x48, 0x16, 0xFC, 0x74, 0x81, 0x7F, 0xB7, 0x48, 0x16, 0xFC, 0x74, 0x81, 0x5F, 0xE7,
  0x40, 0x2A, 0x03, 0x74, 0x81, 0xCF, 0x97, 0x40, 0x5A, 0x05, 0x74, 0x0A, 0xA0, 0x80, 0x14, 0x01,
  0x03, 0x40, 0x9B, 0x84, 0xDB, 0xCD, 0xFB, 0x58, 0x23, 0x9D, 0xEA, 0x81, 0xDA, 0x51,
  // "ć" (U+0107)
  0x58, 0x21, 0xEF, 0x96, 0x81, 0x9F, 0xC6, 0x82, 0x3F, 0xD1, 0x68, 0x1D, 0xC1, 0x77, 0x28, 0x56,
  0xBE, 0xFD, 0xB5, 0x20, 0xBA, 0x89, 0x0D, 0xCE, 0xF6, 0x0A, 0xFC, 0x23, 0x81, 0x30, 0x2A, 0x02,
  0x68, 0x17, 0xFB, 0x78, 0x19, 0xF8, 0x78, 0x1A, 0xF7, 0x78, 0x19, 0xF8, 0x78, 0x17, 0xFB, 0x70,
  0x2A, 0x01, 0x78, 0x2B, 0xFC, 0x23, 0x83, 0x13, 0x01, 0xCA, 0x83, 0xCB, 0xDF, 0x83, 0x85, 0x6C,
  0xEF, 0xEA, 0x30,
  // "Ĉ" (U+0108)
  0x60, 0x6A, 0x06, 0x72, 0x84, 0x2E, 0xEF, 0xE2, 0x78, 0x61, 0xDE, 0x34, 0xFD, 0x16, 0x81, 0xCD,
  0x22, 0x81, 0x3D, 0xC7, 0x76, 0x87, 0x17, 0xBE, 0xFE, 0xCA, 0x54, 0x05, 0x0E, 0xA8, 0x1D, 0xCC,
  0xB0, 0x22, 0x07, 0xA0, 0x90, 0x14, 0x06, 0x08, 0x20, 0x3A, 0x06, 0x73, 0x81, 0xBF, 0xA7, 0x30,
  0x1A, 0x03, 0x73, 0x81, 0x5F, 0xE7, 0x48, 0x16, 0xFC, 0x74, 0x81, 0x7F, 0xB7, 0x48, 0x16, 0xFC,
  0x74, 0x81, 0x5F, 0xE7, 0x40, 0x2A, 0x03, 0x74, 0x81, 0xCF, 0x97, 0x40, 0x5A, 0x05, 0x74, 0x0A,
  0xA0, 0x80, 0x14, 0x01, 0x03, 0x40, 0x9B, 0x84, 0xDB, 0xCD, 0xFB, 0x58, 0x23, 0x9D, 0xEA, 0x81,
  0xDA, 0x51,
  // "ĉ" (U+0109)
  0x40, 0x6A, 0x06, 0x58, 0x42, 0xEE, 0xFE, 0x23, 0x86, 0x1D, 0xE3, 0x4F, 0xD1, 0x28, 0x1C, 0xD2,
  0x28, 0x13, 0xDC, 0x76, 0x85, 0x6B, 0xEF, 0xDB, 0x52, 0x0B, 0xA8, 0x90, 0xDC, 0xEF, 0x60, 0xAF,
  0xC2, 0x38, 0x13, 0x02, 0xA0, 0x26, 0x81, 0x7F, 0xB7, 0x81, 0x9F, 0x87, 0x81, 0xAF, 0x77, 0x81,
  0x9F, 0x87, 0x81, 0x7F, 0xB7, 0x02, 0xA0, 0x17, 0x82, 0xBF, 0xC2, 0x38, 0x31, 0x30, 0x1C, 0xA8,
  0x3C, 0xBD, 0xF8, 0x38, 0x56, 0xCE, 0xFE, 0xA3,
  // "Ċ" (U+010A)
  0x78, 0x18, 0xB1, 0x74, 0xA0, 0x67, 0x48, 0x1A, 0xE2, 0x80, 0xC0, 0x08, 0x71, 0x7B, 0xEF, 0xEC,
  0xA5, 0x40, 0x50, 0xEA, 0x81, 0xDC, 0xCB, 0x02, 0x20, 0x7A, 0x09, 0x01, 0x40, 0x60, 0x82, 0x03,
  0xA0, 0x67, 0x38, 0x1B, 0xFA, 0x73, 0x01, 0xA0, 0x37, 0x38, 0x15, 0xFE, 0x74, 0x81, 0x6F, 0xC7,
  0x48, 0x17, 0xFB, 0x74, 0x81, 0x6F, 0xC7, 0x48, 0x15, 0xFE, 0x74, 0x02, 0xA0, 0x37, 0x48, 0x1C,
  0xF9, 0x74, 0x05, 0xA0, 0x57, 0x40, 0xAA, 0x08, 0x01, 0x40, 0x10, 0x34, 0x09, 0xB8, 0x4D, 0xBC,
  0xDF, 0xB5, 0x82, 0x39, 0xDE, 0xA8, 0x1D, 0xA5, 0x10,
  // "ċ" (U+010B)
  0x58, 0x18, 0xB1, 0x7A, 0x06, 0x78, 0x1A, 0xE2, 0x77, 0x74, 0x85, 0x6B, 0xEF, 0xDB, 0x52, 0x0B,
  0xA8, 0x90, 0xDC, 0xEF, 0x60, 0xAF, 0xC2, 0x38, 0x13, 0x02, 0xA0, 0x26, 0x81, 0x7F, 0xB7, 0x81,
  0x9F, 0x87, 0x81, 0xAF, 0x77, 0x81, 0x9F, 0x87, 0x81, 0x7F, 0xB7, 0x02, 0xA0, 0x17, 0x82, 0xBF,
  0xC2, 0x38, 0x31, 0x30, 0x1C, 0xA8, 0x3C, 0xBD, 0xF8, 0x38, 0x56, 0xCE, 0xFE, 0xA3,
  // "Č" (U+010C)
  0x48, 0x1C, 0xD2, 0x28, 0x12, 0xDD, 0x68, 0x61, 0xDE, 0x33, 0xED, 0x17, 0x84, 0x3E, 0xEE, 0xE2,
  0x72, 0x06, 0xA0, 0x67, 0x77, 0x18, 0x71, 0x7B, 0xEF, 0xEC, 0xA5, 0x40, 0x50, 0xEA, 0x81, 0xDC,
  0xCB, 0x02, 0x20, 0x7A, 0x09, 0x01, 0x40, 0x60, 0x82, 0x03, 0xA0, 0x67, 0x38, 0x1B, 0xFA, 0x73,
  0x01, 0xA0, 0x37, 0x38, 0x15, 0xFE, 0x74, 0x81, 0x6F, 0xC7, 0x48, 0x17, 0xFB, 0x74, 0x81, 0x6F,
  0xC7, 0x48, 0x15, 0xFE, 0x74, 0x02, 0xA0, 0x37, 0x48, 0x1C, 0xF9, 0x74, 0x05, 0xA0, 0x57, 0x40,
  0xAA, 0x08, 0x01, 0x40, 0x10, 0x34, 0x09, 0xB8, 0x4D, 0xBC, 0xDF, 0xB5, 0x82, 0x39, 0xDE, 0xA8,
  0x1D, 0xA5, 0x10,
  // "č" (U+010D)
  0x28, 0x1C, 0xD2, 0x28, 0x12, 0xDD, 0x28, 0x61, 0xDE, 0x33, 0xED, 0x13, 0x84, 0x3E, 0xEE, 0xE2,
  0x50, 0x6A, 0x06, 0x77, 0x18, 0x56, 0xBE, 0xFD, 0xB5, 0x20, 0xBA, 0x89, 0x0D, 0xCE, 0xF6, 0x0A,
  0xFC, 0x23, 0x81, 0x30, 0x2A, 0x02, 0x68, 0x17, 0xFB, 0x78, 0x19, 0xF8, 0x78, 0x1A, 0xF7, 0x78,
  0x19, 0xF8, 0x78, 0x17, 0xFB, 0x70, 0x2A, 0x01, 0x78, 0x2B, 0xFC, 0x23, 0x83, 0x13, 0x01, 0xCA,
  0x83, 0xCB, 0xDF, 0x83, 0x85, 0x6C, 0xEF, 0xEA, 0x30,
  // "Ď" (U+010E)
  0x38, 0x1C, 0xD2, 0x28, 0x12, 0xDD, 0x68, 0x61, 0xDE, 0x33, 0xED, 0x17, 0x84, 0x3E, 0xEE, 0xE2,
  0x72, 0x06, 0xA0, 0x67, 0x75, 0x0A, 0xD8, 0x2E, 0xC9, 0x34, 0x85, 0xAF, 0xDB, 0xBB, 0xDB, 0x0B,
  0x01, 0x28, 0x1A, 0xF7, 0x58, 0x75, 0xDF, 0xE1, 0x0A, 0xF7, 0x78, 0x5C, 0xFC, 0x0A, 0xF7, 0x70,
  0x1A, 0x82, 0x5A, 0xF7, 0x71, 0x84, 0xAF, 0xAA, 0xF7, 0x71, 0x84, 0x6F, 0xEA, 0xF7, 0x71, 0x04,
  0xA8, 0x1A, 0xF7, 0x71, 0x03, 0xA8, 0x1A, 0xF7, 0x71, 0x04, 0xA8, 0x1A, 0xF7, 0x71, 0x84, 0x6F,
  0xDA, 0xF7, 0x71, 0x84, 0xBF, 0x9A, 0xF7, 0x70, 0x3A, 0x82, 0x4A, 0xF7, 0x68, 0x61, 0xDF, 0xB0,
  0xAF, 0x74, 0x89, 0x41, 0x7E, 0xFD, 0x10, 0xAF, 0xDB, 0xBC, 0xDB, 0x0A, 0x01, 0x20, 0xAD, 0x82,
  0xEC, 0x82, 0x40,
  // "ď" (U+010F)
  0x72, 0x85, 0x6F, 0xB0, 0xAF, 0x67, 0x28, 0x56, 0xFB, 0x0C, 0xF1, 0x72, 0x84, 0x6F, 0xB0, 0xF9,
  0x73, 0x84, 0x6F, 0xB4, 0xE1, 0x73, 0x81, 0x6F, 0xB6, 0x89, 0x01, 0x8D, 0xFE, 0xA2, 0x5F, 0xB5,
  0x02, 0x0D, 0xA8, 0x5C, 0xCF, 0xE8, 0xFB, 0x58, 0x2C, 0xFC, 0x13, 0x09, 0xA0, 0xB4, 0x03, 0xA0,
  0x25, 0x81, 0xDF, 0xB4, 0x81, 0x7F, 0xB6, 0x81, 0x9F, 0xB4, 0x81, 0x9F, 0x96, 0x81, 0x6F, 0xB4,
  0x81, 0xAF, 0x86, 0x81, 0x5F, 0xB4, 0x81, 0x9F, 0x96, 0x81, 0x6F, 0xB4, 0x81, 0x7F, 0xB6, 0x81,
  0x8F, 0xB4, 0x03, 0xA0, 0x15, 0x81, 0xCF, 0xB5, 0x82, 0xCF, 0xB1, 0x30, 0x8A, 0x0B, 0x50, 0x20,
  0xEA, 0x85, 0xCC, 0xEE, 0x7F, 0xB6, 0x89, 0x01, 0x9D, 0xFE, 0xA2, 0x1F, 0xB4,
  // "Đ" (U+0110)
  0x20, 0x7D, 0x82, 0xEC, 0x93, 0x68, 0x57, 0xFE, 0xBB, 0xBD, 0xB0, 0xB0, 0x14, 0x81, 0x7F, 0xA5,
  0x83, 0x5D, 0xFE, 0x13, 0x81, 0x7F, 0xA7, 0x81, 0xCF, 0xC3, 0x81, 0x7F, 0xA7, 0x01, 0xA0, 0x52,
  0x81, 0x7F, 0xA7, 0x18, 0x1A, 0xFA, 0x28, 0x17, 0xFA, 0x71, 0x81, 0x6F, 0xE2, 0x81, 0x7F, 0xA7,
  0x10, 0x4A, 0x04, 0xF0, 0xE4, 0x03, 0xA8, 0x73, 0xBD, 0xFE, 0xBB, 0xBA, 0x40, 0x4A, 0x28, 0x17,
  0xFA, 0x71, 0x81, 0x6F, 0xD2, 0x81, 0x7F, 0xA7, 0x18, 0x1B, 0xF9, 0x28, 0x17, 0xFA, 0x70, 0x3A,
  0x04, 0x28, 0x17, 0xFA, 0x68, 0x21, 0xDF, 0xB3, 0x81, 0x7F, 0xA4, 0x84, 0x17, 0xEF, 0xD1, 0x38,
  0x57, 0xFE, 0xBB, 0xCD, 0xB0, 0xA0, 0x14, 0x07, 0xD8, 0x2E, 0xB8, 0x24,
  // "đ" (U+0111)
  0x72, 0x81, 0x6F, 0xB7, 0x48, 0x16, 0xFB, 0x60, 0x7F, 0x90, 0x84, 0x89, 0x05, 0xBB, 0xBB, 0xDF,
  0xEB, 0x67, 0x28, 0x16, 0xFB, 0x48, 0x90, 0x19, 0xDF, 0xD9, 0x25, 0xFB, 0x30, 0x20, 0xEA, 0x85,
  0xCC, 0xEE, 0x7F, 0xB3, 0x82, 0xCF, 0xC1, 0x30, 0x9A, 0x0B, 0x20, 0x3A, 0x02, 0x58, 0x1D, 0xFB,
  0x28, 0x17, 0xFC, 0x68, 0x19, 0xFB, 0x28, 0x19, 0xF9, 0x68, 0x16, 0xFB, 0x28, 0x1A, 0xF8, 0x68,
  0x15, 0xFB, 0x28, 0x19, 0xF9, 0x68, 0x16, 0xFB, 0x28, 0x17, 0xFB, 0x68, 0x18, 0xFB, 0x20, 0x3A,
  0x02, 0x58, 0x1C, 0xFB, 0x38, 0x2C, 0xFB, 0x13, 0x08, 0xA0, 0xB3, 0x02, 0x0E, 0xA8, 0x5C, 0xCE,
  0xE7, 0xFB, 0x48, 0x90, 0x19, 0xDF, 0xE9, 0x21, 0xFB, 0x20,
  // "Ē" (U+0112)
  0x28, 0x03, 0xB0, 0x12, 0xF0, 0x17, 0x30, 0xAF, 0x98, 0x2E, 0xAF, 0xD8, 0x02, 0xB8, 0x2A, 0xAF,
  0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0xD8,
  0x02, 0xB0, 0x50, 0xAF, 0x98, 0x27, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF,
  0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0xD8, 0x02, 0xB0, 0x0A, 0xF9, 0x0E,
  // "ē" (U+0113)
  0x28, 0x03, 0xB0, 0x14, 0xF0, 0x17, 0x73, 0x84, 0x6C, 0xEE, 0xC6, 0x50, 0xBA, 0x0C, 0x0D, 0xA0,
  0xB3, 0x82, 0x9F, 0xB1, 0x28, 0x71, 0xCF, 0x80, 0x2F, 0xE1, 0x48, 0x53, 0xFE, 0x06, 0xFA, 0x68,
  0x2E, 0xF3, 0x9F, 0xB8, 0x24, 0xAF, 0xD8, 0x04, 0xB8, 0x23, 0x9F, 0x87, 0x28, 0x17, 0xFB, 0x72,
  0x02, 0xA0, 0x37, 0x28, 0x29, 0xFD, 0x34, 0x03, 0x05, 0x30, 0xBA, 0x84, 0xDB, 0xCE, 0xFB, 0x48,
  0x65, 0xBD, 0xFE, 0xD9, 0x31,
  // "Ĕ" (U+0114)
  0x20, 0xE0, 0x73, 0x81, 0x2F, 0x42, 0x85, 0x8F, 0xDB, 0xDF, 0xC4, 0x84, 0x7D, 0xFD, 0x91, 0x74,
  0x0A, 0xF9, 0x82, 0xEA, 0xFD, 0x80, 0x2B, 0x82, 0xAA, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7,
  0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xFD, 0x80, 0x2B, 0x05, 0x0A, 0xF9, 0x82, 0x7A,
  0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7,
  0x78, 0x1A, 0xFD, 0x80, 0x2B, 0x00, 0xAF, 0x90, 0xE0,
  // "ĕ" (U+0115)
  0x20, 0xE0, 0x73, 0x81, 0x2F, 0x44, 0x85, 0x8F, 0xDB, 0xDF, 0xC6, 0x84, 0x7D, 0xFD, 0x91, 0x77,
  0x48, 0x46, 0xCE, 0xEC, 0x65, 0x0B, 0xA0, 0xC0, 0xDA, 0x0B, 0x38, 0x29, 0xFB, 0x12, 0x87, 0x1C,
  0xF8, 0x02, 0xFE, 0x14, 0x85, 0x3F, 0xE0, 0x6F, 0xA6, 0x82, 0xEF, 0x39, 0xFB, 0x82, 0x4A, 0xFD,
  0x80, 0x4B, 0x82, 0x39, 0xF8, 0x72, 0x81, 0x7F, 0xB7, 0x20, 0x2A, 0x03, 0x72, 0x82, 0x9F, 0xD3,
  0x40, 0x30, 0x53, 0x0B, 0xA8, 0x4D, 0xBC, 0xEF, 0xB4, 0x86, 0x5B, 0xDF, 0xED, 0x93, 0x10,
  // "Ė" (U+0116)
  0x48, 0x18, 0xB1, 0x7A, 0x06, 0x78, 0x1A, 0xE2, 0x77, 0x72, 0x0A, 0xF9, 0x82, 0xEA, 0xFD, 0x80,
  0x2B, 0x82, 0xAA, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7,
  0x78, 0x1A, 0xFD, 0x80, 0x2B, 0x05, 0x0A, 0xF9, 0x82, 0x7A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A,
  0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xFD, 0x80, 0x2B, 0x00,
  0xAF, 0x90, 0xE0,
  // "ė" (U+0117)
  0x58, 0x18, 0xB1, 0x72, 0xA0, 0x67, 0x28, 0x1A, 0xE2, 0x77, 0x77, 0x38, 0x46, 0xCE, 0xEC, 0x65,
  0x0B, 0xA0, 0xC0, 0xDA, 0x0B, 0x38, 0x29, 0xFB, 0x12, 0x87, 0x1C, 0xF8, 0x02, 0xFE, 0x14, 0x85,
  0x3F, 0xE0, 0x6F, 0xA6, 0x82, 0xEF, 0x39, 0xFB, 0x82, 0x4A, 0xFD, 0x80, 0x4B, 0x82, 0x39, 0xF8,
  0x72, 0x81, 0x7F, 0xB7, 0x20, 0x2A, 0x03, 0x72, 0x82, 0x9F, 0xD3, 0x40, 0x30, 0x53, 0x0B, 0xA8,
  0x4D, 0xBC, 0xEF, 0xB4, 0x86, 0x5B, 0xDF, 0xED, 0x93, 0x10,
  // "Ę" (U+0118)
  0x0A, 0xF9, 0x82, 0xEA, 0xFD, 0x80, 0x2B, 0x82, 0xAA, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7,
  0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xFD, 0x80, 0x2B, 0x05, 0x0A, 0xF9, 0x82, 0x7A,
  0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7,
  0x78, 0x1A, 0xFD, 0x80, 0x2B, 0x00, 0xAF, 0xA6, 0x81, 0x3F, 0x57, 0x00, 0xC7, 0x19, 0x0B, 0x71,
  0x82, 0xDF, 0xCB, 0x68, 0x24, 0xDF, 0xC0,
  // "ę" (U+0119)
  0x38, 0x46, 0xCE, 0xEB, 0x55, 0x0B, 0xA0, 0x0C, 0xA0, 0x93, 0x82, 0x9F, 0xD2, 0x28, 0x42, 0xEF,
  0x50, 0x2A, 0x04, 0x48, 0x56, 0xFC, 0x06, 0xFD, 0x50, 0x1A, 0x82, 0x19, 0xF9, 0x68, 0x2E, 0xF3,
  0xAF, 0xB8, 0x24, 0x9F, 0xD8, 0x04, 0xB8, 0x23, 0x7F, 0x97, 0x28, 0x12, 0xFD, 0x73, 0x82, 0x9F,
  0xB2, 0x40, 0x10, 0x33, 0x0B, 0xA8, 0x4D, 0xCC, 0xDF, 0xB4, 0x83, 0x5B, 0xDF, 0xEA, 0x06, 0x71,
  0x81, 0x3F, 0x77, 0x20, 0xD0, 0xB7, 0x28, 0x14, 0xF6, 0x72, 0x81, 0x5F, 0x67, 0x20, 0x2A, 0x0C,
  0x07, 0x71, 0x82, 0x7E, 0xF7, 0x10,
  // "Ě" (U+011A)
  0x18, 0x1C, 0xD2, 0x28, 0x12, 0xDD, 0x28, 0x61, 0xDE, 0x33, 0xED, 0x13, 0x84, 0x3E, 0xEE, 0xE2,
  0x50, 0x6A, 0x06, 0x76, 0x0A, 0xF9, 0x82, 0xEA, 0xFD, 0x80, 0x2B, 0x82, 0xAA, 0xF7, 0x78, 0x1A,
  0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xFD, 0x80, 0x2B, 0x05,
  0x0A, 0xF9, 0x82, 0x7A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A,
  0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xFD, 0x80, 0x2B, 0x00, 0xAF, 0x90, 0xE0,
  // "ě" (U+011B)
  0x28, 0x1C, 0xD2, 0x28, 0x12, 0xDD, 0x48, 0x61, 0xDE, 0x33, 0xED, 0x15, 0x84, 0x3E, 0xEE, 0xE2,
  0x70, 0x6A, 0x06, 0x77, 0x58, 0x46, 0xCE, 0xEC, 0x65, 0x0B, 0xA0, 0xC0, 0xDA, 0x0B, 0x38, 0x29,
  0xFB, 0x12, 0x87, 0x1C, 0xF8, 0x02, 0xFE, 0x14, 0x85, 0x3F, 0xE0, 0x6F, 0xA6, 0x82, 0xEF, 0x39,
  0xFB, 0x82, 0x4A, 0xFD, 0x80, 0x4B, 0x82, 0x39, 0xF8, 0x72, 0x81, 0x7F, 0xB7, 0x20, 0x2A, 0x03,
  0x72, 0x82, 0x9F, 0xD3, 0x40, 0x30, 0x53, 0x0B, 0xA8, 0x4D, 0xBC, 0xEF, 0xB4, 0x86, 0x5B, 0xDF,
  0xED, 0x93, 0x10,
  // "Ĝ" (U+011C)
  0x70, 0x6A, 0x06, 0x73, 0x84, 0x2E, 0xEF, 0xE2, 0x71, 0x86, 0x1D, 0xE3, 0x4F, 0xD1, 0x78, 0x1C,
  0xD2, 0x28, 0x13, 0xDC, 0x77, 0x71, 0x87, 0x5A, 0xDE, 0xFD, 0xC9, 0x54, 0x03, 0x0D, 0xA8, 0x2E,
  0xCB, 0xDB, 0x03, 0x20, 0x4A, 0x0B, 0x03, 0x50, 0x50, 0x82, 0x82, 0x2E, 0xF8, 0x74, 0x81, 0xBF,
  0xB7, 0x40, 0x1A, 0x03, 0x74, 0x81, 0x5F, 0xE7, 0x58, 0x17, 0xFC, 0x75, 0x81, 0x7F, 0xB5, 0x03,
  0xD8, 0x2A, 0x6F, 0xC5, 0x89, 0x02, 0xBB, 0xBD, 0xFA, 0x5F, 0xE7, 0x28, 0x27, 0xFA, 0x1A, 0x03,
  0x71, 0x85, 0x7F, 0xA0, 0xCF, 0xA7, 0x18, 0x37, 0xFA, 0x04, 0xA0, 0x67, 0x81, 0x7F, 0xA2, 0x08,
  0xA0, 0x90, 0x25, 0x81, 0x8F, 0xA3, 0x06, 0xB8, 0x3E, 0xCB, 0xCE, 0xA0, 0xA4, 0x82, 0x28, 0xCE,
  0xA8, 0x3E, 0xDA, 0x72,
  // "ĝ" (U+011D)
  0x40, 0x6A, 0x06, 0x78, 0x42, 0xEE, 0xFE, 0x25, 0x86, 0x1D, 0xE3, 0x4F, 0xD1, 0x48, 0x1C, 0xD2,
  0x28, 0x13, 0xDC, 0x77, 0x28, 0x93, 0x18, 0xDF, 0xE9, 0x20, 0xFB, 0x01, 0xDA, 0x89, 0x2C, 0xCF,
  0xE6, 0xFB, 0x0B, 0xFC, 0x12, 0x01, 0x0A, 0xA0, 0xB0, 0x3A, 0x02, 0x58, 0x4D, 0xFB, 0x7F, 0xB6,
  0x84, 0x8F, 0xB9, 0xF8, 0x68, 0x46, 0xFB, 0xAF, 0x76, 0x84, 0x5F, 0xB9, 0xF8, 0x68, 0x45, 0xFB,
  0x7F, 0xB6, 0x82, 0x7F, 0xB3, 0xA0, 0x15, 0x86, 0xCF, 0xB0, 0xCF, 0xB1, 0x30, 0x8A, 0x82, 0xB0,
  0x2E, 0xA8, 0x5C, 0xCE, 0xF8, 0xFB, 0x28, 0x90, 0x19, 0xDF, 0xEA, 0x25, 0xFB, 0x72, 0x81, 0x6F,
  0xA7, 0x28, 0x18, 0xF9, 0x72, 0x84, 0xDF, 0x60, 0x75, 0x58, 0x4A, 0xFE, 0x10, 0xAA, 0x82, 0xDC,
  0xCE, 0xA0, 0x52, 0x82, 0x39, 0xCE, 0xA8, 0x1D, 0x92, 0x20,
  // "Ğ" (U+011E)
  0x50, 0xE0, 0x73, 0x81, 0x2F, 0x47, 0x85, 0x8F, 0xDB, 0xDF, 0xC7, 0x28, 0x47, 0xDF, 0xD9, 0x17,
  0x77, 0x28, 0x75, 0xAD, 0xEF, 0xDC, 0x95, 0x40, 0x30, 0xDA, 0x82, 0xEC, 0xBD, 0xB0, 0x32, 0x04,
  0xA0, 0xB0, 0x35, 0x05, 0x08, 0x28, 0x22, 0xEF, 0x87, 0x48, 0x1B, 0xFB, 0x74, 0x01, 0xA0, 0x37,
  0x48, 0x15, 0xFE, 0x75, 0x81, 0x7F, 0xC7, 0x58, 0x17, 0xFB, 0x50, 0x3D, 0x82, 0xA6, 0xFC, 0x58,
  0x90, 0x2B, 0xBB, 0xDF, 0xA5, 0xFE, 0x72, 0x82, 0x7F, 0xA1, 0xA0, 0x37, 0x18, 0x57, 0xFA, 0x0C,
  0xFA, 0x71, 0x83, 0x7F, 0xA0, 0x4A, 0x06, 0x78, 0x17, 0xFA, 0x20, 0x8A, 0x09, 0x02, 0x58, 0x18,
  0xFA, 0x30, 0x6B, 0x83, 0xEC, 0xBC, 0xEA, 0x0A, 0x48, 0x22, 0x8C, 0xEA, 0x83, 0xED, 0xA7, 0x20,
  // "ğ" (U+011F)
  0x30, 0xE0, 0x73, 0x81, 0x2F, 0x44, 0x85, 0x8F, 0xDB, 0xDF, 0xC6, 0x84, 0x7D, 0xFD, 0x91, 0x77,
  0x28, 0x93, 0x18, 0xDF, 0xE9, 0x20, 0xFB, 0x01, 0xDA, 0x89, 0x2C, 0xCF, 0xE6, 0xFB, 0x0B, 0xFC,
  0x12, 0x01, 0x0A, 0xA0, 0xB0, 0x3A, 0x02, 0x58, 0x4D, 0xFB, 0x7F, 0xB6, 0x84, 0x8F, 0xB9, 0xF8,
  0x68, 0x46, 0xFB, 0xAF, 0x76, 0x84, 0x5F, 0xB9, 0xF8, 0x68, 0x45, 0xFB, 0x7F, 0xB6, 0x82, 0x7F,
  0xB3, 0xA0, 0x15, 0x86, 0xCF, 0xB0, 0xCF, 0xB1, 0x30, 0x8A, 0x82, 0xB0, 0x2E, 0xA8, 0x5C, 0xCE,
  0xF8, 0xFB, 0x28, 0x90, 0x19, 0xDF, 0xEA, 0x25, 0xFB, 0x72, 0x81, 0x6F, 0xA7, 0x28, 0x18, 0xF9,
  0x72, 0x84, 0xDF, 0x60, 0x75, 0x58, 0x4A, 0xFE, 0x10, 0xAA, 0x82, 0xDC, 0xCE, 0xA0, 0x52, 0x82,
  0x39, 0xCE, 0xA8, 0x1D, 0x92, 0x20,
  // "Ġ" (U+0120)
  0x71, 0x81, 0x8B, 0x17, 0x5A, 0x06, 0x75, 0x81, 0xAE, 0x28, 0x0C, 0x30, 0x87, 0x5A, 0xDE, 0xFD,
  0xC9, 0x54, 0x03, 0x0D, 0xA8, 0x2E, 0xCB, 0xDB, 0x03, 0x20, 0x4A, 0x0B, 0x03, 0x50, 0x50, 0x82,
  0x82, 0x2E, 0xF8, 0x74, 0x81, 0xBF, 0xB7, 0x40, 0x1A, 0x03, 0x74, 0x81, 0x5F, 0xE7, 0x58, 0x17,
  0xFC, 0x75, 0x81, 0x7F, 0xB5, 0x03, 0xD8, 0x2A, 0x6F, 0xC5, 0x89, 0x02, 0xBB, 0xBD, 0xFA, 0x5F,
  0xE7, 0x28, 0x27, 0xFA, 0x1A, 0x03, 0x71, 0x85, 0x7F, 0xA0, 0xCF, 0xA7, 0x18, 0x37, 0xFA, 0x04,
  0xA0, 0x67, 0x81, 0x7F, 0xA2, 0x08, 0xA0, 0x90, 0x25, 0x81, 0x8F, 0xA3, 0x06, 0xB8, 0x3E, 0xCB,
  0xCE, 0xA0, 0xA4, 0x82, 0x28, 0xCE, 0xA8, 0x3E, 0xDA, 0x72,
  // "ġ" (U+0121)
  0x58, 0x18, 0xB1, 0x72, 0xA0, 0x67, 0x28, 0x1A, 0xE2, 0x77, 0x77, 0x28, 0x93, 0x18, 0xDF, 0xE9,
  0x20, 0xFB, 0x01, 0xDA, 0x89, 0x2C, 0xCF, 0xE6, 0xFB, 0x0B, 0xFC, 0x12, 0x01, 0x0A, 0xA0, 0xB0,
  0x3A, 0x02, 0x58, 0x4D, 0xFB, 0x7F, 0xB6, 0x84, 0x8F, 0xB9, 0xF8, 0x68, 0x46, 0xFB, 0xAF, 0x76,
  0x84, 0x5F, 0xB9, 0xF8, 0x68, 0x45, 0xFB, 0x7F, 0xB6, 0x82, 0x7F, 0xB3, 0xA0, 0x15, 0x86, 0xCF,
  0xB0, 0xCF, 0xB1, 0x30, 0x8A, 0x82, 0xB0, 0x2E, 0xA8, 0x5C, 0xCE, 0xF8, 0xFB, 0x28, 0x90, 0x19,
  0xDF, 0xEA, 0x25, 0xFB, 0x72, 0x81, 0x6F, 0xA7, 0x28, 0x18, 0xF9, 0x72, 0x84, 0xDF, 0x60, 0x75,
  0x58, 0x4A, 0xFE, 0x10, 0xAA, 0x82, 0xDC, 0xCE, 0xA0, 0x52, 0x82, 0x39, 0xCE, 0xA8, 0x1D, 0x92,
  0x20,
  // "Ģ" (U+0122)
  0x58, 0x75, 0xAD, 0xEF, 0xDC, 0x95, 0x40, 0x30, 0xDA, 0x82, 0xEC, 0xCD, 0xB0, 0x32, 0x04, 0xA0,
  0xB0, 0x34, 0x81, 0x17, 0xA2, 0x82, 0x2E, 0xF8, 0x74, 0x81, 0xBF, 0xB7, 0x40, 0x1A, 0x03, 0x74,
  0x81, 0x5F, 0xE7, 0x58, 0x17, 0xFC, 0x75, 0x81, 0x7F, 0xB7, 0x58, 0x16, 0xFC, 0x50, 0x3D, 0x82,
  0xA5, 0xFE, 0x58, 0x62, 0xBB, 0xBD, 0xFA, 0x1A, 0x03, 0x71, 0x85, 0x7F, 0xA0, 0xCF, 0xA7, 0x18,
  0x37, 0xFA, 0x04, 0xA0, 0x67, 0x81, 0x7F, 0xA2, 0x08, 0xA0, 0x90, 0x25, 0x81, 0x7F, 0xA3, 0x06,
  0xB8, 0x3E, 0xCB, 0xCE, 0xA0, 0xA4, 0x82, 0x28, 0xCE, 0xA8, 0x3E, 0xDA, 0x72, 0x80, 0xC2, 0x0A,
  0x01, 0x74, 0x81, 0x3F, 0xB7, 0x58, 0x17, 0xF3, 0x75, 0x0C, 0x09, 0x60,
  // "ģ" (U+0123)
  0x60, 0xC0, 0x97, 0x28, 0x16, 0xF4, 0x72, 0x0D, 0x97, 0x28, 0x14, 0xFC, 0x77, 0x58, 0x93, 0x18,
  0xDF, 0xE9, 0x20, 0xFB, 0x01, 0xDA, 0x89, 0x2C, 0xCF, 0xE6, 0xFB, 0x0B, 0xFC, 0x12, 0x01, 0x0A,
  0xA0, 0xB0, 0x3A, 0x02, 0x58, 0x4D, 0xFB, 0x7F, 0xB6, 0x84, 0x8F, 0xB9, 0xF8, 0x68, 0x46, 0xFB,
  0xAF, 0x76, 0x84, 0x5F, 0xB9, 0xF8, 0x68, 0x45, 0xFB, 0x7F, 0xB6, 0x82, 0x7F, 0xB3, 0xA0, 0x15,
  0x86, 0xCF, 0xB0, 0xCF, 0xB1, 0x30, 0x8A, 0x82, 0xB0, 0x2E, 0xA8, 0x5C, 0xCE, 0xF8, 0xFB, 0x28,
  0x90, 0x19, 0xDF, 0xEA, 0x25, 0xFB, 0x72, 0x81, 0x6F, 0xA7, 0x28, 0x18, 0xF9, 0x72, 0x84, 0xDF,
  0x60, 0x75, 0x58, 0x4A, 0xFE, 0x10, 0xAA, 0x82, 0xDC, 0xCE, 0xA0, 0x52, 0x82, 0x39, 0xCE, 0xA8,
  0x1D, 0x92, 0x20,
  // "Ĥ" (U+0124)
  0x50, 0x6A, 0x06, 0x72, 0x84, 0x2E, 0xEF, 0xE2, 0x78, 0x61, 0xDE, 0x34, 0xFD, 0x16, 0x81, 0xCD,
  0x22, 0x81, 0x3D, 0xC7, 0x73, 0x81, 0xAF, 0x77, 0x18, 0x4B, 0xF6, 0xAF, 0x77, 0x18, 0x4B, 0xF6,
  0xAF, 0x77, 0x18, 0x4B, 0xF6, 0xAF, 0x77, 0x18, 0x4B, 0xF6, 0xAF, 0x77, 0x18, 0x4B, 0xF6, 0xAF,
  0x77, 0x18, 0x4B, 0xF6, 0xAF, 0x77, 0x18, 0x4B, 0xF6, 0xAF, 0xD8, 0x04, 0xB8, 0x2E, 0xF6, 0xAF,
  0xD8, 0x26, 0xAF, 0x77, 0x18, 0x4B, 0xF6, 0xAF, 0x77, 0x18, 0x4B, 0xF6, 0xAF, 0x77, 0x18, 0x4B,
  0xF6, 0xAF, 0x77, 0x18, 0x4B, 0xF6, 0xAF, 0x77, 0x18, 0x4B, 0xF6, 0xAF, 0x77, 0x18, 0x4B, 0xF6,
  0xAF, 0x77, 0x18, 0x4B, 0xF6, 0xAF, 0x77, 0x18, 0x1B, 0xF6,
  // "ĥ" (U+0125)
  0x20, 0x6A, 0x06, 0x72, 0x84, 0x2E, 0xEF, 0xE2, 0x78, 0x61, 0xDE, 0x34, 0xFD, 0x16, 0x81, 0xCD,
  0x22, 0x81, 0x3D, 0xC7, 0x77, 0x28, 0x1E, 0xF2, 0x74, 0x81, 0xEF, 0x27, 0x48, 0x1E, 0xF2, 0x74,
  0x81, 0xEF, 0x27, 0x48, 0x1E, 0xF2, 0x74, 0x89, 0x0E, 0xF2, 0x4B, 0xEF, 0xD9, 0x14, 0x85, 0xEF,
  0x7F, 0xEC, 0xDA, 0x0E, 0x01, 0x30, 0xEA, 0x06, 0x38, 0x22, 0xDF, 0x83, 0x81, 0xEF, 0xA5, 0x81,
  0x6F, 0xC3, 0x81, 0xEF, 0x55, 0x81, 0x3F, 0xD3, 0x81, 0xEF, 0x35, 0x81, 0x3F, 0xD3, 0x81, 0xEF,
  0x25, 0x81, 0x3F, 0xD3, 0x81, 0xEF, 0x25, 0x81, 0x3F, 0xD3, 0x81, 0xEF, 0x25, 0x81, 0x3F, 0xD3,
  0x81, 0xEF, 0x25, 0x81, 0x3F, 0xD3, 0x81, 0xEF, 0x25, 0x81, 0x3F, 0xD3, 0x81, 0xEF, 0x25, 0x81,
  0x3F, 0xD3, 0x81, 0xEF, 0x25, 0x81, 0x3F, 0xD0,
  // "Ħ" (U+0126)
  0x28, 0x1A, 0xF7, 0x71, 0x81, 0xBF, 0x64, 0x81, 0xAF, 0x77, 0x18, 0x1B, 0xF6, 0x48, 0x1A, 0xF7,
  0x71, 0x81, 0xBF, 0x62, 0xFF, 0xB0, 0xFB, 0x81, 0xEF, 0xD8, 0x04, 0xB8, 0x3E, 0xFD, 0xB8, 0x28,
  0x1A, 0xF7, 0x71, 0x81, 0xBF, 0x64, 0x81, 0xAF, 0x77, 0x18, 0x1B, 0xF6, 0x48, 0x1A, 0xFD, 0x80,
  0x4B, 0x81, 0xEF, 0x64, 0x0A, 0xFD, 0x06, 0x48, 0x1A, 0xF7, 0x71, 0x81, 0xBF, 0x64, 0x81, 0xAF,
  0x77, 0x18, 0x1B, 0xF6, 0x48, 0x1A, 0xF7, 0x71, 0x81, 0xBF, 0x64, 0x81, 0xAF, 0x77, 0x18, 0x1B,
  0xF6, 0x48, 0x1A, 0xF7, 0x71, 0x81, 0xBF, 0x64, 0x81, 0xAF, 0x77, 0x18, 0x1B, 0xF6, 0x48, 0x1A,
  0xF7, 0x71, 0x81, 0xBF, 0x64, 0x81, 0xAF, 0x77, 0x18, 0x1B, 0xF6, 0x20,
  // "ħ" (U+0127)
  0x28, 0x1E, 0xF2, 0x73, 0x81, 0xEF, 0x27, 0x10, 0xCF, 0x90, 0x33, 0x09, 0x0B, 0xA8, 0x4C, 0xBB,
  0xBB, 0x25, 0x81, 0xEF, 0x27, 0x38, 0x90, 0xEF, 0x23, 0xAE, 0xFD, 0x91, 0x38, 0x5E, 0xF6, 0xFE,
  0xCD, 0xA0, 0xD0, 0x12, 0x0E, 0xA0, 0x73, 0x82, 0x2E, 0xF7, 0x28, 0x1E, 0xFA, 0x58, 0x17, 0xFB,
  0x28, 0x1E, 0xF5, 0x58, 0x14, 0xFD, 0x28, 0x1E, 0xF3, 0x58, 0x13, 0xFD, 0x28, 0x1E, 0xF2, 0x58,
  0x13, 0xFD, 0x28, 0x1E, 0xF2, 0x58, 0x13, 0xFD, 0x28, 0x1E, 0xF2, 0x58, 0x13, 0xFD, 0x28, 0x1E,
  0xF2, 0x58, 0x13, 0xFD, 0x28, 0x1E, 0xF2, 0x58, 0x13, 0xFD, 0x28, 0x1E, 0xF2, 0x58, 0x13, 0xFD,
  0x28, 0x1E, 0xF2, 0x58, 0x13, 0xFD,
  // "Ĩ" (U+0128)
  0x83, 0x1A, 0xEC, 0x62, 0x8A, 0x1A, 0xA9, 0xFC, 0xEF, 0xEC, 0xF5, 0xE6, 0x01, 0x8D, 0xE8, 0x74,
  0xE0, 0x22, 0x09, 0x0C, 0xA8, 0x1D, 0x91, 0x4A, 0x02, 0x6A, 0x02, 0x6A, 0x02, 0x6A, 0x02, 0x6A,
  0x02, 0x6A, 0x02, 0x6A, 0x02, 0x6A, 0x02, 0x6A, 0x02, 0x6A, 0x02, 0x6A, 0x02, 0x6A, 0x02, 0x6A,
  0x02, 0x40, 0x50, 0x9A, 0x09, 0x05, 0x3E, 0x02, 0x10,
  // "ĩ" (U+0129)
  0x83, 0x1A, 0xEC, 0x62, 0x8A, 0x1A, 0xA9, 0xFC, 0xEF, 0xEC, 0xF5, 0xE6, 0x01, 0x8D, 0xE8, 0x76,
  0x81, 0xEF, 0x26, 0x81, 0xEF, 0x26, 0x81, 0xEF, 0x26, 0x81, 0xEF, 0x26, 0x81, 0xEF, 0x26, 0x81,
  0xEF, 0x26, 0x81, 0xEF, 0x26, 0x81, 0xEF, 0x26, 0x81, 0xEF, 0x26, 0x81, 0xEF, 0x26, 0x81, 0xEF,
  0x26, 0x81, 0xEF, 0x26, 0x81, 0xEF, 0x23,
  // "Ī" (U+012A)
  0x80, 0x3B, 0x01, 0xF0, 0x17, 0x1E, 0x82, 0x20, 0x9C, 0xA8, 0x1D, 0x91, 0x3A, 0x02, 0x5A, 0x02,
  0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02,
  0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x30, 0x50, 0x9A, 0x09, 0x05, 0x2E, 0x02, 0x10,
  // "ī" (U+012B)
  0x80, 0x3B, 0x01, 0xF0, 0x17, 0x38, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E,
  0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2,
  0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x30,
  // "Ĭ" (U+012C)
  0x0E, 0x07, 0x38, 0x90, 0x2F, 0x48, 0xFD, 0xBD, 0xFC, 0x28, 0x47, 0xDF, 0xD9, 0x17, 0x2E, 0x82,
  0x20, 0x9C, 0xA8, 0x1D, 0x91, 0x3A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A,
  0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x5A, 0x02, 0x30,
  0x50, 0x9A, 0x09, 0x05, 0x2E, 0x02, 0x10,
  // "ĭ" (U+012D)
  0x0E, 0x07, 0x38, 0x90, 0x2F, 0x48, 0xFD, 0xBD, 0xFC, 0x28, 0x47, 0xDF, 0xD9, 0x17, 0x48, 0x1E,
  0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2,
  0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58,
  0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x30,
  // "Į" (U+012E)
  0xE8, 0x12, 0x9C, 0xA8, 0x1D, 0x91, 0x2A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02,
  0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02,
  0x20, 0x50, 0x9A, 0x09, 0x05, 0x1E, 0x02, 0x28, 0x13, 0xF5, 0x40, 0x0C, 0x59, 0x0B, 0x58, 0x2D,
  0xFC, 0xB3, 0x82, 0x4D, 0xFC, 0x10,
  // "į" (U+012F)
  0x18, 0x2B, 0xD1, 0x1A, 0x82, 0x40, 0x9B, 0x73, 0x8D, 0x5E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E,
  0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E,
  0xF2, 0x1A, 0x85, 0x33, 0xF5, 0x0C, 0xC2, 0x90, 0xB2, 0x86, 0xDF, 0xCB, 0x4D, 0xFC,
  // "İ" (U+0130)
  0x28, 0x18, 0xB1, 0x4A, 0x06, 0x48, 0x1A, 0xE2, 0x77, 0x2E, 0x81, 0x29, 0xCA, 0x81, 0xD9, 0x12,
  0xA0, 0x24, 0xA0, 0x24, 0xA0, 0x24, 0xA0, 0x24, 0xA0, 0x24, 0xA0, 0x24, 0xA0, 0x24, 0xA0, 0x24,
  0xA0, 0x24, 0xA0, 0x24, 0xA0, 0x24, 0xA0, 0x24, 0xA0, 0x22, 0x05, 0x09, 0xA0, 0x90, 0x51, 0xE0,
  0x20,
  // "ı" (U+0131)
  0x8C, 0x5E, 0xF2, 0xEF, 0x2E, 0xF2, 0xEF, 0x2E, 0xF2, 0xEF, 0x2E, 0xF2, 0xEF, 0x2E, 0xF2, 0xEF,
  0x2E, 0xF2, 0xEF, 0x2E, 0xF2,
  // "Ĳ" (U+0132)
  0xE0, 0x22, 0x83, 0xCF, 0x59, 0xCA, 0x81, 0xD9, 0x12, 0x81, 0xCF, 0x52, 0xA0, 0x24, 0x81, 0xCF,
  0x52, 0xA0, 0x24, 0x81, 0xCF, 0x52, 0xA0, 0x24, 0x81, 0xCF, 0x52, 0xA0, 0x24, 0x81, 0xCF, 0x52,
  0xA0, 0x24, 0x81, 0xCF, 0x52, 0xA0, 0x24, 0x81, 0xCF, 0x52, 0xA0, 0x24, 0x81, 0xCF, 0x52, 0xA0,
  0x24, 0x81, 0xCF, 0x52, 0xA0, 0x24, 0x81, 0xCF, 0x52, 0xA0, 0x24, 0x81, 0xCF, 0x52, 0xA0, 0x24,
  0x81, 0xCF, 0x52, 0xA0, 0x24, 0x81, 0xCF, 0x52, 0xA0, 0x24, 0x83, 0xCF, 0x55, 0x9A, 0x09, 0x05,
  0x38, 0x1C, 0xF5, 0xE0, 0x22, 0x81, 0xCF, 0x57, 0x28, 0x1C, 0xF5, 0x72, 0x81, 0xEF, 0x35, 0x84,
  0x10, 0x2A, 0xFD, 0x60, 0xDB, 0x0E, 0x03, 0x68, 0x38, 0xBA, 0x71, 0x20,
  // "ĳ" (U+0133)
  0x18, 0x1B, 0xD1, 0x38, 0x2B, 0xD1, 0x1A, 0x04, 0x20, 0x1A, 0x82, 0x40, 0x9B, 0x40, 0x90, 0xB7,
  0x77, 0x18, 0x1E, 0xF2, 0x38, 0x5E, 0xF2, 0x0E, 0xF2, 0x38, 0x5E, 0xF2, 0x0E, 0xF2, 0x38, 0x5E,
  0xF2, 0x0E, 0xF2, 0x38, 0x5E, 0xF2, 0x0E, 0xF2, 0x38, 0x5E, 0xF2, 0x0E, 0xF2, 0x38, 0x5E, 0xF2,
  0x0E, 0xF2, 0x38, 0x5E, 0xF2, 0x0E, 0xF2, 0x38, 0x5E, 0xF2, 0x0E, 0xF2, 0x38, 0x5E, 0xF2, 0x0E,
  0xF2, 0x38, 0x5E, 0xF2, 0x0E, 0xF2, 0x38, 0x5E, 0xF2, 0x0E, 0xF2, 0x38, 0x5E, 0xF2, 0x0E, 0xF2,
  0x38, 0x1E, 0xF2, 0x78, 0x1E, 0xF2, 0x78, 0x1E, 0xF2, 0x7A, 0x01, 0x68, 0x14, 0xFE, 0x48, 0x14,
  0xCC, 0xA0, 0x84, 0x83, 0x3E, 0xFD, 0x82,
  // "Ĵ" (U+0134)
  0x30, 0x6A, 0x06, 0x48, 0x42, 0xEE, 0xFE, 0x22, 0x89, 0x21, 0xDE, 0x34, 0xFD, 0x10, 0xCD, 0x22,
  0x81, 0x3D, 0xC7, 0x68, 0x1C, 0xF5, 0x68, 0x1C, 0xF5, 0x68, 0x1C, 0xF5, 0x68, 0x1C, 0xF5, 0x68,
  0x1C, 0xF5, 0x68, 0x1C, 0xF5, 0x68, 0x1C, 0xF5, 0x68, 0x1C, 0xF5, 0x68, 0x1C, 0xF5, 0x68, 0x1C,
  0xF5, 0x68, 0x1C, 0xF5, 0x68, 0x1C, 0xF5, 0x68, 0x1C, 0xF5, 0x68, 0x1C, 0xF5, 0x68, 0x1C, 0xF5,
  0x68, 0x1C, 0xF5, 0x68, 0x1C, 0xF5, 0x68, 0x1C, 0xF5, 0x68, 0x1E, 0xF3, 0x28, 0x41, 0x02, 0xAF,
  0xD3, 0x0D, 0xB0, 0xE0, 0x33, 0x83, 0x8B, 0xA7, 0x14,
  // "ĵ" (U+0135)
  0x30, 0x6A, 0x06, 0x48, 0x42, 0xEE, 0xFE, 0x22, 0x89, 0x21, 0xDE, 0x34, 0xFD, 0x10, 0xCD, 0x22,
  0x81, 0x3D, 0xC7, 0x68, 0x1E, 0xF2, 0x68, 0x1E, 0xF2, 0x68, 0x1E, 0xF2, 0x68, 0x1E, 0xF2, 0x68,
  0x1E, 0xF2, 0x68, 0x1E, 0xF2, 0x68, 0x1E, 0xF2, 0x68, 0x1E, 0xF2, 0x68, 0x1E, 0xF2, 0x68, 0x1E,
  0xF2, 0x68, 0x1E, 0xF2, 0x68, 0x1E, 0xF2, 0x68, 0x1E, 0xF2, 0x68, 0x1E, 0xF2, 0x68, 0x1E, 0xF2,
  0x6A, 0x01, 0x58, 0x14, 0xFE, 0x38, 0x14, 0xCC, 0xA0, 0x83, 0x83, 0x3E, 0xFD, 0x84,
  // "Ķ" (U+0136)
  0x81, 0xAF, 0x76, 0x85, 0x5F, 0xE3, 0xAF, 0x75, 0x04, 0xA8, 0x34, 0x0A, 0xF7, 0x48, 0x23, 0xEF,
  0x52, 0x81, 0xAF, 0x73, 0x82, 0x1E, 0xF6, 0x38, 0x1A, 0xF7, 0x28, 0x21, 0xDF, 0x84, 0x81, 0xAF,
  0x72, 0x81, 0xCF, 0x95, 0x85, 0xAF, 0x70, 0xAF, 0xB6, 0x84, 0xAF, 0x79, 0xFE, 0x78, 0x1A, 0xFD,
  0xB0, 0x76, 0x0A, 0xA0, 0x90, 0x6A, 0x04, 0x58, 0x1A, 0xF9, 0x28, 0x29, 0xFE, 0x14, 0x81, 0xAF,
  0x73, 0x81, 0xCF, 0xB4, 0x81, 0xAF, 0x73, 0x82, 0x2E, 0xF7, 0x38, 0x1A, 0xF7, 0x40, 0x5A, 0x03,
  0x28, 0x1A, 0xF7, 0x58, 0x69, 0xFD, 0x10, 0xAF, 0x76, 0x85, 0xCF, 0xB0, 0xAF, 0x76, 0x82, 0x2E,
  0xF7, 0x77, 0x77, 0x38, 0x1B, 0xF5, 0x73, 0x00, 0xE7, 0x38, 0x13, 0xF7, 0x73, 0x08, 0x0D, 0x70,
  // "ķ" (U+0137)
  0x81, 0xEF, 0x17, 0x18, 0x1E, 0xF1, 0x71, 0x81, 0xEF, 0x17, 0x18, 0x1E, 0xF1, 0x71, 0x81, 0xEF,
  0x17, 0x18, 0x1E, 0xF1, 0x48, 0x5A, 0xFB, 0x0E, 0xF1, 0x38, 0x19, 0xFC, 0x28, 0x1E, 0xF1, 0x28,
  0x28, 0xFC, 0x12, 0x86, 0xEF, 0x10, 0x7F, 0xD1, 0x38, 0x5E, 0xF1, 0x6F, 0xD2, 0x48, 0x1E, 0xF5,
  0xA0, 0x35, 0x81, 0xEF, 0xEA, 0x0B, 0x58, 0x5E, 0xFC, 0x3E, 0xF7, 0x48, 0x3E, 0xF2, 0x04, 0xA0,
  0x33, 0x81, 0xEF, 0x12, 0x82, 0x8F, 0xD1, 0x28, 0x1E, 0xF1, 0x38, 0x1B, 0xFB, 0x28, 0x1E, 0xF1,
  0x38, 0x61, 0xEF, 0x70, 0xEF, 0x14, 0x04, 0xA0, 0x37, 0x77, 0x48, 0x13, 0xFD, 0x71, 0x81, 0x6F,
  0x77, 0x10, 0xB0, 0xE7, 0x29, 0x05, 0x60,
  // "ĸ" (U+0138)
  0x81, 0xEF, 0x44, 0x85, 0xBF, 0xB0, 0xEF, 0x43, 0x86, 0x9F, 0xD1, 0x0E, 0xF4, 0x28, 0x26, 0xFE,
  0x22, 0x83, 0xEF, 0x40, 0x4A, 0x04, 0x38, 0x5E, 0xF3, 0x2E, 0xF6, 0x48, 0x4E, 0xF4, 0xDF, 0x95,
  0x81, 0xEF, 0xCA, 0x0D, 0x50, 0xEA, 0x82, 0x6D, 0xF9, 0x48, 0x3E, 0xF6, 0x02, 0xA0, 0x53, 0x81,
  0xEF, 0x42, 0x82, 0x6F, 0xE1, 0x28, 0x1E, 0xF4, 0x38, 0x1B, 0xFB, 0x28, 0x1E, 0xF4, 0x38, 0x61,
  0xEF, 0x70, 0xEF, 0x44, 0x04, 0xA0, 0x30,
  // "Ĺ" (U+0139)
  0x18, 0x21, 0xEF, 0x96, 0x81, 0x9F, 0xC6, 0x82, 0x3F, 0xD1, 0x68, 0x1D, 0xC1, 0x77, 0x38, 0x1A,
  0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7,
  0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78,
  0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x70, 0xA9, 0x80, 0x3E, 0x0D,
  0x0A, 0xFA,
  // "ĺ" (U+013A)
  0x18, 0x97, 0x1E, 0xF9, 0x09, 0xFC, 0x03, 0xFD, 0x10, 0xDC, 0x17, 0x81, 0xEF, 0x22, 0x81, 0xEF,
  0x22, 0x81, 0xEF, 0x22, 0x81, 0xEF, 0x22, 0x81, 0xEF, 0x22, 0x81, 0xEF, 0x22, 0x81, 0xEF, 0x22,
  0x81, 0xEF, 0x22, 0x81, 0xEF, 0x22, 0x81, 0xEF, 0x22, 0x81, 0xEF, 0x22, 0x81, 0xEF, 0x22, 0x81,
  0xEF, 0x22, 0x81, 0xEF, 0x22, 0x81, 0xEF, 0x22, 0x81, 0xEF, 0x22, 0x81, 0xEF, 0x22, 0x81, 0xEF,
  0x22,
  // "Ļ" (U+013B)
  0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81,
  0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF,
  0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x0A, 0x98, 0x03,
  0xE0, 0xD0, 0xAF, 0xA7, 0x77, 0x38, 0x17, 0xF9, 0x78, 0x1A, 0xF4, 0x70, 0xE0, 0xB7, 0x81, 0x3F,
  0x24,
  // "ļ" (U+013C)
  0x18, 0x98, 0x5E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2,
  0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2,
  0x0E, 0xF2, 0x0E, 0xF2, 0x0E, 0xF2, 0x72, 0x89, 0x48, 0xF8, 0x0B, 0xF2, 0x0F, 0xA0, 0x5E, 0x11,
  // "Ľ" (U+013D)
  0x81, 0xAF, 0x74, 0x84, 0x2F, 0xDA, 0xF7, 0x48, 0x45, 0xF8, 0xAF, 0x74, 0x84, 0x8F, 0x1A, 0xF7,
  0x48, 0x4C, 0x80, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF,
  0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77,
  0x81, 0xAF, 0x77, 0x0A, 0x98, 0x03, 0xE0, 0xD0, 0xAF, 0xA0,
  // "ľ" (U+013E)
  0x8B, 0x1E, 0xF2, 0x1F, 0xEE, 0xF2, 0x3F, 0x9E, 0xF2, 0x7F, 0x2E, 0xF2, 0xBA, 0x0E, 0xF2, 0x38,
  0x1E, 0xF2, 0x38, 0x1E, 0xF2, 0x38, 0x1E, 0xF2, 0x38, 0x1E, 0xF2, 0x38, 0x1E, 0xF2, 0x38, 0x1E,
  0xF2, 0x38, 0x1E, 0xF2, 0x38, 0x1E, 0xF2, 0x38, 0x1E, 0xF2, 0x38, 0x1E, 0xF2, 0x38, 0x1E, 0xF2,
  0x38, 0x1E, 0xF2, 0x38, 0x1E, 0xF2, 0x30,
  // "Ŀ" (U+013F)
  0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81,
  0xAF, 0x77, 0x81, 0xAF, 0x77, 0x81, 0xAF, 0x73, 0x85, 0x8B, 0x10, 0xAF, 0x73, 0xA8, 0x36, 0x0A,
  0xF7, 0x38, 0x5A, 0xE2, 0x0A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78, 0x1A, 0xF7, 0x78,
  0x1A, 0xF7, 0x70, 0xA9, 0x80, 0x3E, 0x0D, 0x0A, 0xFA,
  // "ŀ" (U+0140)
  0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81,
  0xEF, 0x23, 0x81, 0xEF, 0x23, 0x87, 0xEF, 0x28, 0xB1, 0xEF, 0x2A, 0x89, 0x06, 0xEF, 0x2A, 0xE2,
  0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23, 0x81, 0xEF,
  0x23, 0x81, 0xEF, 0x23, 0x81, 0xEF, 0x23,
  // "Ł" (U+0141)
  0x28, 0x1A, 0xF7, 0x72, 0x81, 0xAF, 0x77, 0x28, 0x1A, 0xF7, 0x72, 0x81, 0xAF, 0x77, 0x28, 0x1A,
  0xF7, 0x72, 0x81, 0xAF, 0x77, 0x28, 0x5A, 0xF7, 0x02, 0xA1, 0x58, 0x2A, 0xF8, 0x9A, 0x06, 0x50,
  0xAB, 0x0C, 0x03, 0x58, 0x34, 0xDF, 0xD5, 0x60, 0x6B, 0x07, 0x78, 0x31, 0x9B, 0xF7, 0x72, 0x81,
  0xAF, 0x77, 0x28, 0x1A, 0xF7, 0x72, 0x81, 0xAF, 0x77, 0x20, 0xA9, 0x80, 0x3E, 0x0D, 0x20, 0xAF,
  0xA0,
  // "ł" (U+0142)
  0x10, 0x1A, 0x40, 0x1A, 0x40, 0x1A, 0x40, 0x1A, 0x40, 0x1A, 0x40, 0x1A, 0x40, 0x1A, 0x40, 0x1A,
  0x05, 0x0B, 0x20, 0x1B, 0x82, 0xE2, 0x06, 0xA8, 0x29, 0x10, 0xBB, 0x30, 0xA0, 0x9A, 0x40, 0x1A,
  0x40, 0x1A, 0x40, 0x1A, 0x40, 0x1A, 0x40, 0x1A, 0x40, 0x1A, 0x30,
  // "Ń" (U+0143)
  0x78, 0x21, 0xEF, 0x97, 0x38, 0x19, 0xFC, 0x73, 0x82, 0x3F, 0xD1, 0x73, 0x81, 0xDC, 0x17, 0x75,
  0x0A, 0xA0, 0x27, 0x82, 0x1F, 0xEA, 0xA0, 0xC7, 0x82, 0x1F, 0xEA, 0xB0, 0x66, 0x87, 0x1F, 0xEA,
  0xFA, 0xFE, 0x15, 0x87, 0x1F, 0xEA, 0xF3, 0xCF, 0xB5, 0x85, 0x1F, 0xEA, 0xF3, 0x3A, 0x05, 0x48,
  0x91, 0x1F, 0xEA, 0xF4, 0x08, 0xFE, 0x13, 0x84, 0x1F, 0xEA, 0xF4, 0x28, 0x1D, 0xFA, 0x38, 0x41,
  0xFE, 0xAF, 0x42, 0x03, 0xA0, 0x42, 0x84, 0x1F, 0xEA, 0xF4, 0x38, 0x18, 0xFD, 0x28, 0x41, 0xFE,
  0xAF, 0x44, 0x89, 0x0D, 0xF9, 0x01, 0xFE, 0xAF, 0x44, 0x03, 0xA8, 0x53, 0x1F, 0xEA, 0xF4, 0x58,
  0x78, 0xFD, 0x0F, 0xEA, 0xF4, 0x68, 0x6D, 0xF8, 0xFE, 0xAF, 0x46, 0x04, 0xB8, 0x2E, 0xAF, 0x47,
  0x09, 0xA8, 0x2E, 0xAF, 0x47, 0x18, 0x1D, 0xFE,
  // "ń" (U+0144)
  0x58, 0x21, 0xEF, 0x97, 0x81, 0x9F, 0xC7, 0x82, 0x3F, 0xD1, 0x78, 0x1D, 0xC1, 0x77, 0x18, 0xA0,
  0xEC, 0x04, 0xAE, 0xFD, 0x91, 0x0E, 0xF6, 0xFE, 0xCD, 0xA8, 0x1E, 0x1E, 0xA0, 0x73, 0x85, 0x2D,
  0xF8, 0xEF, 0xA5, 0x84, 0x6F, 0xCE, 0xF5, 0x58, 0x43, 0xFD, 0xEF, 0x35, 0x84, 0x3F, 0xDE, 0xF2,
  0x58, 0x43, 0xFD, 0xEF, 0x25, 0x84, 0x3F, 0xDE, 0xF2, 0x58, 0x43, 0xFD, 0xEF, 0x25, 0x84, 0x3F,
  0xDE, 0xF2, 0x58, 0x43, 0xFD, 0xEF, 0x25, 0x84, 0x3F, 0xDE, 0xF2, 0x58, 0x13, 0xFD,
  // "Ņ" (U+0145)
  0x0A, 0xA0, 0x27, 0x82, 0x1F, 0xEA, 0xA0, 0xC7, 0x82, 0x1F, 0xEA, 0xB0, 0x66, 0x87, 0x1F, 0xEA,
  0xFA, 0xFE, 0x15, 0x87, 0x1F, 0xEA, 0xF3, 0xCF, 0xB5, 0x85, 0x1F, 0xEA, 0xF3, 0x3A, 0x05, 0x48,
  0x91, 0x1F, 0xEA, 0xF4, 0x08, 0xFE, 0x13, 0x84, 0x1F, 0xEA, 0xF4, 0x28, 0x1D, 0xFA, 0x38, 0x41,
  0xFE, 0xAF, 0x42, 0x03, 0xA0, 0x42, 0x84, 0x1F, 0xEA, 0xF4, 0x38, 0x18, 0xFD, 0x28, 0x41, 0xFE,
  0xAF, 0x44, 0x89, 0x0D, 0xF9, 0x01, 0xFE, 0xAF, 0x44, 0x03, 0xA8, 0x53, 0x1F, 0xEA, 0xF4, 0x58,
  0x78, 0xFD, 0x0F, 0xEA, 0xF4, 0x68, 0x6D, 0xF8, 0xFE, 0xAF, 0x46, 0x04, 0xB8, 0x2E, 0xAF, 0x47,
  0x09, 0xA8, 0x2E, 0xAF, 0x47, 0x18, 0x1D, 0xFE, 0x77, 0x77, 0x68, 0x18, 0xF8, 0x74, 0x81, 0xBF,
  0x27, 0x40, 0xE0, 0xA7, 0x48, 0x15, 0xE1, 0x60,
  // "ņ" (U+0146)
  0x8A, 0x0E, 0xC0, 0x4A, 0xEF, 0xD9, 0x10, 0xEF, 0x6F, 0xEC, 0xDA, 0x81, 0xE1, 0xEA, 0x07, 0x38,
  0x52, 0xDF, 0x8E, 0xFA, 0x58, 0x46, 0xFC, 0xEF, 0x55, 0x84, 0x3F, 0xDE, 0xF3, 0x58, 0x43, 0xFD,
  0xEF, 0x25, 0x84, 0x3F, 0xDE, 0xF2, 0x58, 0x43, 0xFD, 0xEF, 0x25, 0x84, 0x3F, 0xDE, 0xF2, 0x58,
  0x43, 0xFD, 0xEF, 0x25, 0x84, 0x3F, 0xDE, 0xF2, 0x58, 0x43, 0xFD, 0xEF, 0x25, 0x81, 0x3F, 0xD7,
  0x77, 0x58, 0x13, 0xFD, 0x71, 0x81, 0x6F, 0x77, 0x10, 0xA0, 0xE7, 0x29, 0x05, 0x50,
  // "Ň" (U+0147)
  0x38, 0x1C, 0xD2, 0x28, 0x12, 0xDD, 0x68, 0x61, 0xDE, 0x33, 0xED, 0x17, 0x84, 0x3E, 0xEE, 0xE2,
  0x72, 0x06, 0xA0, 0x67, 0x75, 0x0A, 0xA0, 0x27, 0x82, 0x1F, 0xEA, 0xA0, 0xC7, 0x82, 0x1F, 0xEA,
  0xB0, 0x66, 0x87, 0x1F, 0xEA, 0xFA, 0xFE, 0x15, 0x87, 0x1F, 0xEA, 0xF3, 0xCF, 0xB5, 0x85, 0x1F,
  0xEA, 0xF3, 0x3A, 0x05, 0x48, 0x91, 0x1F, 0xEA, 0xF4, 0x08, 0xFE, 0x13, 0x84, 0x1F, 0xEA, 0xF4,
  0x28, 0x1D, 0xFA, 0x38, 0x41, 0xFE, 0xAF, 0x42, 0x03, 0xA0, 0x42, 0x84, 0x1F, 0xEA, 0xF4, 0x38,
  0x18, 0xFD, 0x28, 0x41, 0xFE, 0xAF, 0x44, 0x89, 0x0D, 0xF9, 0x01, 0xFE, 0xAF, 0x44, 0x03, 0xA8,
  0x53, 0x1F, 0xEA, 0xF4, 0x58, 0x78, 0xFD, 0x0F, 0xEA, 0xF4, 0x68, 0x6D, 0xF8, 0xFE, 0xAF, 0x46,
  0x04, 0xB8, 0x2E, 0xAF, 0x47, 0x09, 0xA8, 0x2E, 0xAF, 0x47, 0x18, 0x1D, 0xFE,
  // "ň" (U+0148)
  0x18, 0x1C, 0xD2, 0x28, 0x12, 0xDD, 0x38, 0x61, 0xDE, 0x33, 0xED, 0x14, 0x84, 0x3E, 0xEE, 0xE2,
  0x60, 0x6A, 0x06, 0x77, 0x18, 0xA0, 0xEC, 0x04, 0xAE, 0xFD, 0x91, 0x0E, 0xF6, 0xFE, 0xCD, 0xA8,
  0x1E, 0x1E, 0xA0, 0x73, 0x85, 0x2D, 0xF8, 0xEF, 0xA5, 0x84, 0x6F, 0xCE, 0xF5, 0x58, 0x43, 0xFD,
  0xEF, 0x35, 0x84, 0x3F, 0xDE, 0xF2, 0x58, 0x43, 0xFD, 0xEF, 0x25, 0x84, 0x3F, 0xDE, 0xF2, 0x58,
  0x43, 0xFD, 0xEF, 0x25, 0x84, 0x3F, 0xDE, 0xF2, 0x58, 0x43, 0xFD, 0xEF, 0x25, 0x84, 0x3F, 0xDE,
  0xF2, 0x58, 0x13, 0xFD,
  // "ŉ" (U+0149)
  0x18, 0x19, 0xFC, 0x75, 0x81, 0xBF, 0x87, 0x58, 0x1E, 0xF3, 0x74, 0x81, 0x2F, 0xD7, 0x58, 0xB0,
  0x5F, 0x70, 0xEC, 0x04, 0xAE, 0xFD, 0x91, 0x09, 0xF1, 0x0E, 0xF6, 0xFE, 0xCD, 0xA0, 0xE0, 0x14,
  0x0E, 0xA0, 0x73, 0x82, 0x2D, 0xF8, 0x48, 0x1E, 0xFA, 0x58, 0x16, 0xFC, 0x48, 0x1E, 0xF5, 0x58,
  0x13, 0xFD, 0x48, 0x1E, 0xF3, 0x58, 0x13, 0xFD, 0x48, 0x1E, 0xF2, 0x58, 0x13, 0xFD, 0x48, 0x1E,
  0xF2, 0x58, 0x13, 0xFD, 0x48, 0x1E, 0xF2, 0x58, 0x13, 0xFD, 0x48, 0x1E, 0xF2, 0x58, 0x13, 0xFD,
  0x48, 0x1E, 0xF2, 0x58, 0x13, 0xFD, 0x48, 0x1E, 0xF2, 0x58, 0x13, 0xFD, 0x48, 0x1E, 0xF2, 0x58,
  0x13, 0xFD,
  // "Ŋ" (U+014A)
  0x0A, 0xA0, 0x27, 0x82, 0x1F, 0xEA, 0xA0, 0xC7, 0x86, 0x1F, 0xEA, 0xFE, 0xF7, 0x68, 0x41, 0xFE,
  0xAF, 0x7A, 0x02, 0x58, 0x71, 0xFE, 0xAF, 0x39, 0xFC, 0x58, 0x90, 0x1F, 0xEA, 0xF4, 0x0D, 0xF7,
  0x48, 0x61, 0xFE, 0xAF, 0x40, 0x3A, 0x03, 0x38, 0x41, 0xFE, 0xAF, 0x42, 0x81, 0x8F, 0xC3, 0x84,
  0x1F, 0xEA, 0xF4, 0x38, 0x1D, 0xF8, 0x28, 0x41, 0xFE, 0xAF, 0x43, 0x03, 0xA8, 0x63, 0x01, 0xFE,
  0xAF, 0x44, 0x89, 0x08, 0xFC, 0x01, 0xFE, 0xAF, 0x45, 0x87, 0xCF, 0x80, 0xFE, 0xAF, 0x45, 0x02,
  0xA8, 0x43, 0xFE, 0xAF, 0x46, 0x86, 0x7F, 0xCF, 0xEA, 0xF4, 0x70, 0xCA, 0x82, 0xEA, 0xF4, 0x70,
  0x2A, 0x82, 0xEA, 0xF4, 0x71, 0x81, 0x7F, 0xE7, 0x48, 0x12, 0xFD, 0x74, 0x81, 0x5F, 0xB7, 0x85,
  0x11, 0x04, 0xDF, 0x67, 0x06, 0xC0, 0xA7, 0x18, 0x33, 0xAB, 0x95, 0x20,
  // "ŋ" (U+014B)
  0x8A, 0x0E, 0xC0, 0x4B, 0xEF, 0xD9, 0x10, 0xEF, 0x6F, 0xEC, 0xDA, 0x81, 0xE1, 0xEA, 0x07, 0x38,
  0x52, 0xDF, 0x8E, 0xFA, 0x58, 0x46, 0xFC, 0xEF, 0x55, 0x84, 0x3F, 0xDE, 0xF3, 0x58, 0x43, 0xFE,
  0xEF, 0x25, 0x84, 0x3F, 0xEE, 0xF2, 0x58, 0x43, 0xFE, 0xEF, 0x25, 0x84, 0x3F, 0xEE, 0xF2, 0x58,
  0x43, 0xFE, 0xEF, 0x25, 0x84, 0x3F, 0xEE, 0xF2, 0x58, 0x43, 0xFE, 0xEF, 0x25, 0x81, 0x3F, 0xE7,
  0x18, 0x13, 0xFE, 0x71, 0x81, 0x3F, 0xE7, 0x18, 0x13, 0xFD, 0x71, 0x81, 0x7F, 0xB5, 0x81, 0x3C,
  0xCA, 0x04, 0x58, 0x32, 0xEF, 0xD6, 0x10,
  // "Ō" (U+014C)
  0x58, 0x03, 0xB0, 0x17, 0x2F, 0x01, 0x77, 0x74, 0x87, 0x39, 0xCE, 0xFE, 0xC7, 0x17, 0x08, 0xB8,
  0x1C, 0xBD, 0xA0, 0xE0, 0x45, 0x82, 0xAF, 0xE6, 0x40, 0x10, 0x8A, 0x05, 0x30, 0x5A, 0x03, 0x78,
  0x26, 0xFE, 0x12, 0x81, 0xCF, 0x87, 0x28, 0x3C, 0xF8, 0x02, 0xA0, 0x27, 0x28, 0x56, 0xFD, 0x05,
  0xFE, 0x73, 0x02, 0xA8, 0x21, 0x6F, 0xC7, 0x4A, 0x82, 0x27, 0xFB, 0x74, 0xA8, 0x23, 0x6F, 0xC7,
  0x4A, 0x82, 0x25, 0xFE, 0x73, 0x02, 0xA0, 0x01, 0xA0, 0x27, 0x28, 0x16, 0xFD, 0x28, 0x1C, 0xF8,
  0x72, 0x81, 0xCF, 0x82, 0x05, 0xA0, 0x37, 0x82, 0x6F, 0xE1, 0x38, 0x2A, 0xFE, 0x64, 0x01, 0x08,
  0xA0, 0x55, 0x08, 0xB8, 0x1C, 0xBD, 0xA0, 0xE0, 0x47, 0x87, 0x39, 0xCE, 0xFE, 0xC7, 0x14,
  // "ō" (U+014D)
  0x38, 0x03, 0xB0, 0x15, 0xF0, 0x17, 0x74, 0x85, 0x6B, 0xEF, 0xD9, 0x24, 0x01, 0x0B, 0xA8, 0x4C,
  0xCE, 0xFE, 0x53, 0x82, 0xAF, 0xC2, 0x30, 0x6A, 0x81, 0x20, 0x2A, 0x02, 0x58, 0x5A, 0xFA, 0x07,
  0xFB, 0x68, 0x53, 0xFE, 0x09, 0xF9, 0x60, 0x1A, 0x82, 0x1A, 0xF8, 0x7A, 0x82, 0x39, 0xF9, 0x60,
  0x1A, 0x82, 0x26, 0xFC, 0x68, 0x33, 0xFE, 0x01, 0xA0, 0x25, 0x81, 0xAF, 0xA2, 0x82, 0x9F, 0xC2,
  0x30, 0x6A, 0x03, 0x30, 0xAA, 0x81, 0xCC, 0xEA, 0x05, 0x58, 0x55, 0xBE, 0xFD, 0x92, 0x30,
  // "Ŏ" (U+014E)
  0x50, 0xE0, 0x73, 0x81, 0x2F, 0x47, 0x28, 0x58, 0xFD, 0xBD, 0xFC, 0x74, 0x84, 0x7D, 0xFD, 0x91,
  0x77, 0x75, 0x87, 0x39, 0xCE, 0xFE, 0xC7, 0x17, 0x08, 0xB8, 0x1C, 0xBD, 0xA0, 0xE0, 0x45, 0x82,
  0xAF, 0xE6, 0x40, 0x10, 0x8A, 0x05, 0x30, 0x5A, 0x03, 0x78, 0x26, 0xFE, 0x12, 0x81, 0xCF, 0x87,
  0x28, 0x3C, 0xF8, 0x02, 0xA0, 0x27, 0x28, 0x56, 0xFD, 0x05, 0xFE, 0x73, 0x02, 0xA8, 0x21, 0x6F,
  0xC7, 0x4A, 0x82, 0x27, 0xFB, 0x74, 0xA8, 0x23, 0x6F, 0xC7, 0x4A, 0x82, 0x25, 0xFE, 0x73, 0x02,
  0xA0, 0x01, 0xA0, 0x27, 0x28, 0x16, 0xFD, 0x28, 0x1C, 0xF8, 0x72, 0x81, 0xCF, 0x82, 0x05, 0xA0,
  0x37, 0x82, 0x6F, 0xE1, 0x38, 0x2A, 0xFE, 0x64, 0x01, 0x08, 0xA0, 0x55, 0x08, 0xB8, 0x1C, 0xBD,
  0xA0, 0xE0, 0x47, 0x87, 0x39, 0xCE, 0xFE, 0xC7, 0x14,
  // "ŏ" (U+014F)
  0x30, 0xE0, 0x73, 0x81, 0x2F, 0x45, 0x85, 0x8F, 0xDB, 0xDF, 0xC7, 0x84, 0x7D, 0xFD, 0x91, 0x77,
  0x58, 0x56, 0xBE, 0xFD, 0x92, 0x40, 0x10, 0xBA, 0x84, 0xCC, 0xEF, 0xE5, 0x38, 0x2A, 0xFC, 0x23,
  0x06, 0xA8, 0x12, 0x02, 0xA0, 0x25, 0x85, 0xAF, 0xA0, 0x7F, 0xB6, 0x85, 0x3F, 0xE0, 0x9F, 0x96,
  0x01, 0xA8, 0x21, 0xAF, 0x87, 0xA8, 0x23, 0x9F, 0x96, 0x01, 0xA8, 0x22, 0x6F, 0xC6, 0x83, 0x3F,
  0xE0, 0x1A, 0x02, 0x58, 0x1A, 0xFA, 0x28, 0x29, 0xFC, 0x23, 0x06, 0xA0, 0x33, 0x0A, 0xA8, 0x1C,
  0xCE, 0xA0, 0x55, 0x85, 0x5B, 0xEF, 0xD9, 0x23,
  // "Ő" (U+0150)
  0x60, 0x3A, 0x83, 0x30, 0xEF, 0x67, 0x28, 0x5B, 0xF7, 0x07, 0xFA, 0x72, 0x85, 0x4F, 0x90, 0x1E,
  0xC7, 0x30, 0xD0, 0xA2, 0x81, 0xAC, 0x17, 0x77, 0x58, 0x73, 0x9C, 0xEF, 0xEC, 0x71, 0x70, 0x8B,
  0x81, 0xCB, 0xDA, 0x0E, 0x04, 0x58, 0x2A, 0xFE, 0x64, 0x01, 0x08, 0xA0, 0x53, 0x05, 0xA0, 0x37,
  0x82, 0x6F, 0xE1, 0x28, 0x1C, 0xF8, 0x72, 0x83, 0xCF, 0x80, 0x2A, 0x02, 0x72, 0x85, 0x6F, 0xD0,
  0x5F, 0xE7, 0x30, 0x2A, 0x82, 0x16, 0xFC, 0x74, 0xA8, 0x22, 0x7F, 0xB7, 0x4A, 0x82, 0x36, 0xFC,
  0x74, 0xA8, 0x22, 0x5F, 0xE7, 0x30, 0x2A, 0x00, 0x1A, 0x02, 0x72, 0x81, 0x6F, 0xD2, 0x81, 0xCF,
  0x87, 0x28, 0x1C, 0xF8, 0x20, 0x5A, 0x03, 0x78, 0x26, 0xFE, 0x13, 0x82, 0xAF, 0xE6, 0x40, 0x10,
  0x8A, 0x05, 0x50, 0x8B, 0x81, 0xCB, 0xDA, 0x0E, 0x04, 0x78, 0x73, 0x9C, 0xEF, 0xEC, 0x71, 0x40,
  // "ő" (U+0151)
  0x40, 0x3A, 0x83, 0x30, 0xEF, 0x65, 0x85, 0xBF, 0x70, 0x7F, 0xA5, 0x85, 0x4F, 0x90, 0x1E, 0xC6,
  0x0D, 0x0A, 0x28, 0x1A, 0xC1, 0x77, 0x58, 0x56, 0xBE, 0xFD, 0x92, 0x40, 0x10, 0xBA, 0x84, 0xCC,
  0xEF, 0xE5, 0x38, 0x2A, 0xFC, 0x23, 0x06, 0xA8, 0x12, 0x02, 0xA0, 0x25, 0x85, 0xAF, 0xA0, 0x7F,
  0xB6, 0x85, 0x3F, 0xE0, 0x9F, 0x96, 0x01, 0xA8, 0x21, 0xAF, 0x87, 0xA8, 0x23, 0x9F, 0x96, 0x01,
  0xA8, 0x22, 0x6F, 0xC6, 0x83, 0x3F, 0xE0, 0x1A, 0x02, 0x58, 0x1A, 0xFA, 0x28, 0x29, 0xFC, 0x23,
  0x06, 0xA0, 0x33, 0x0A, 0xA8, 0x1C, 0xCE, 0xA0, 0x55, 0x85, 0x5B, 0xEF, 0xD9, 0x23,
  // "Œ" (U+0152)
  0x48, 0x23, 0x9D, 0xEF, 0xC0, 0xC3, 0x09, 0xB8, 0x2C, 0xBC, 0xDA, 0x80, 0x2B, 0x09, 0x28, 0x2A,
  0xFE, 0x64, 0x81, 0x2F, 0xE7, 0x10, 0x5A, 0x03, 0x58, 0x12, 0xFE, 0x71, 0x81, 0xDF, 0x86, 0x81,
  0x2F, 0xE7, 0x02, 0xA0, 0x26, 0x81, 0x2F, 0xE7, 0x81, 0x5F, 0xD7, 0x81, 0x2F, 0xE7, 0x81, 0x7F,
  0xC7, 0x02, 0xA8, 0x02, 0xB8, 0x24, 0x7F, 0xB7, 0x02, 0xF9, 0x82, 0x56, 0xFC, 0x78, 0x12, 0xFE,
  0x78, 0x15, 0xFE, 0x78, 0x12, 0xFE, 0x70, 0x1A, 0x02, 0x68, 0x12, 0xFE, 0x71, 0x81, 0xCF, 0x86,
  0x81, 0x2F, 0xE7, 0x10, 0x5A, 0x03, 0x58, 0x12, 0xFE, 0x72, 0x82, 0xAF, 0xE6, 0x48, 0x12, 0xFE,
  0x73, 0x08, 0xB8, 0x2C, 0xBC, 0xDA, 0x80, 0x2B, 0x09, 0x48, 0x23, 0x9C, 0xEF, 0xC0, 0xC0,
  // "œ" (U+0153)
  0x38, 0x46, 0xCE, 0xEC, 0x73, 0x85, 0x3A, 0xEF, 0xD8, 0x13, 0x01, 0x0C, 0xA8, 0x5C, 0xCE, 0xFD,
  0x15, 0xA8, 0x4D, 0xCE, 0xFD, 0x12, 0x82, 0xBF, 0xB1, 0x38, 0x49, 0xFC, 0xEE, 0x33, 0x86, 0xAF,
  0xB0, 0x3F, 0xE1, 0x50, 0xDA, 0x05, 0x40, 0x1A, 0x82, 0x27, 0xFB, 0x60, 0x7A, 0x01, 0x58, 0x4D,
  0xF5, 0x9F, 0x86, 0x05, 0xFB, 0x82, 0x6A, 0xF7, 0x60, 0x4A, 0x80, 0x4B, 0x82, 0x59, 0xF8, 0x68,
  0x15, 0xFE, 0x72, 0x81, 0x7F, 0xB6, 0x07, 0xA0, 0x27, 0x10, 0x2A, 0x01, 0x50, 0xCA, 0x08, 0x72,
  0x82, 0x9F, 0xB1, 0x38, 0x49, 0xFC, 0xEF, 0x64, 0x02, 0x06, 0x30, 0xBA, 0x89, 0x5C, 0xCE, 0xFD,
  0x14, 0xEF, 0xEC, 0xCD, 0xFD, 0x48, 0x46, 0xCE, 0xEC, 0x73, 0x81, 0x18, 0xDA, 0x81, 0xDA, 0x41,
  // "Ŕ" (U+0154)
  0x58, 0x21, 0xEF, 0x97, 0x28, 0x19, 0xFC, 0x72, 0x82, 0x3F, 0xD1, 0x72, 0x81, 0xDC, 0x17, 0x75,
  0x0A, 0xD8, 0x1E, 0xB7, 0x48, 0x5A, 0xFD, 0xBB, 0xCD, 0xA0, 0xD0, 0x22, 0x81, 0xAF, 0x74, 0x82,
  0x3D, 0xFB, 0x28, 0x1A, 0xF7, 0x50, 0x3A, 0x83, 0x10, 0xAF, 0x76, 0xA8, 0x34, 0x0A, 0xF7, 0x6A,
  0x83, 0x30, 0xAF, 0x75, 0x81, 0x4F, 0xE2, 0x81, 0xAF, 0x74, 0x82, 0x3D, 0xF8, 0x28, 0x5A, 0xFD,
  0xBB, 0xBD, 0xA0, 0x83, 0x0A, 0xF0, 0x24, 0x81, 0xAF, 0x73, 0x81, 0xCF, 0x84, 0x81, 0xAF, 0x73,
  0x03, 0xA0, 0x23, 0x81, 0xAF, 0x74, 0x81, 0x9F, 0xB3, 0x81, 0xAF, 0x74, 0x82, 0x1E, 0xF6, 0x28,
  0x1A, 0xF7, 0x58, 0x66, 0xFE, 0x10, 0xAF, 0x76, 0x85, 0xCF, 0x90, 0xAF, 0x76, 0x03, 0xA0, 0x30,
  // "ŕ" (U+0155)
  0x38, 0x21, 0xEF, 0x94, 0x81, 0x9F, 0xC4, 0x82, 0x3F, 0xD1, 0x48, 0x1D, 0xC1, 0x74, 0x8A, 0x3E,
  0xC0, 0x19, 0xEF, 0x6E, 0xE2, 0xDF, 0xCD, 0x5E, 0xFC, 0xB1, 0x38, 0x1E, 0xFD, 0x58, 0x1E, 0xF6,
  0x58, 0x1E, 0xF3, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58,
  0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x58, 0x1E, 0xF2, 0x50,
  // "Ŗ" (U+0156)
  0x0A, 0xD8, 0x1E, 0xB6, 0x48, 0x5A, 0xFD, 0xBB, 0xCE, 0xA0, 0xC0, 0x12, 0x81, 0xAF, 0x74, 0x82,
  0x3D, 0xFA, 0x28, 0x1A, 0xF7, 0x50, 0x4A, 0x83, 0x10, 0xAF, 0x76, 0xA8, 0x33, 0x0A, 0xF7, 0x6A,
  0x83, 0x40, 0xAF, 0x75, 0x01, 0xA8, 0x32, 0x0A, 0xF7, 0x58, 0x18, 0xFD, 0x28, 0x1A, 0xF7, 0x30,
  0x20, 0x8A, 0x03, 0x20, 0xAF, 0x0C, 0x03, 0x38, 0x1A, 0xFD, 0x0F, 0xBA, 0x02, 0x48, 0x1A, 0xF7,
  0x38, 0x19, 0xFB, 0x48, 0x1A, 0xF7, 0x48, 0x1D, 0xF7, 0x38, 0x1A, 0xF7, 0x40, 0x4A, 0x02, 0x28,
  0x1A, 0xF7, 0x58, 0x19, 0xFC, 0x28, 0x1A, 0xF7, 0x68, 0x5D, 0xF8, 0x0A, 0xF7, 0x60, 0x4A, 0x03,
  0x77, 0x77, 0x38, 0x1C, 0xF4, 0x73, 0x00, 0xE7, 0x38, 0x13, 0xF6, 0x73, 0x08, 0x0C, 0x70,
  // "ŗ" (U+0157)
  0x18, 0xA5, 0xEC, 0x01, 0x9E, 0xF6, 0x0E, 0xE2, 0xDF, 0xCD, 0x50, 0xEF, 0xCB, 0x14, 0x81, 0xEF,
  0xD6, 0x81, 0xEF, 0x66, 0x81, 0xEF, 0x36, 0x81, 0xEF, 0x26, 0x81, 0xEF, 0x26, 0x81, 0xEF, 0x26,
  0x81, 0xEF, 0x26, 0x81, 0xEF, 0x26, 0x81, 0xEF, 0x26, 0x81, 0xEF, 0x27, 0x77, 0x38, 0x19, 0xF7,
  0x68, 0x1C, 0xF1, 0x58, 0x11, 0xF9, 0x68, 0x16, 0xE1, 0x60,
  // "Ř" (U+0158)
  0x18, 0x1C, 0xD2, 0x28, 0x12, 0xDD, 0x58, 0x61, 0xDE, 0x33, 0xED, 0x16, 0x84, 0x3E, 0xEE, 0xE2,
  0x71, 0x06, 0xA0, 0x67, 0x75, 0x0A, 0xD8, 0x1E, 0xB7, 0x48, 0x5A, 0xFD, 0xBB, 0xCD, 0xA0, 0xD0,
  0x22, 0x81, 0xAF, 0x74, 0x82, 0x3D, 0xFB, 0x28, 0x1A, 0xF7, 0x50, 0x3A, 0x83, 0x10, 0xAF, 0x76,
  0xA8, 0x34, 0x0A, 0xF7, 0x6A, 0x83, 0x30, 0xAF, 0x75, 0x81, 0x4F, 0xE2, 0x81, 0xAF, 0x74, 0x82,
  0x3D, 0xF8, 0x28, 0x5A, 0xFD, 0xBB, 0xBD, 0xA0, 0x83, 0x0A, 0xF0, 0x24, 0x81, 0xAF, 0x73, 0x81,
  0xCF, 0x84, 0x81, 0xAF, 0x73, 0x03, 0xA0, 0x23, 0x81, 0xAF, 0x74, 0x81, 0x9F, 0xB3, 0x81, 0xAF,
  0x74, 0x82, 0x1E, 0xF6, 0x28, 0x1A, 0xF7, 0x58, 0x66, 0xFE, 0x10, 0xAF, 0x76, 0x85, 0xCF, 0x90,
  0xAF, 0x76, 0x03, 0xA0, 0x30,
  // "ř" (U+0159)
  0x81, 0xCD, 0x22, 0x8A, 0x02, 0xDD, 0x1D, 0xE3, 0x3E, 0xD1, 0x03, 0xEE, 0xEE, 0x23, 0x06, 0xA0,
  0x67, 0x38, 0xA3, 0xEC, 0x01, 0x9E, 0xF6, 0xEE, 0x2D, 0xFC, 0xD5, 0xEF, 0xCB, 0x13, 0x81, 0xEF,
  0xD5, 0x81, 0xEF, 0x65, 0x81, 0xEF, 0x35, 0x81, 0xEF, 0x25, 0x81, 0xEF, 0x25, 0x81, 0xEF, 0x25,
  0x81, 0xEF, 0x25, 0x81, 0xEF, 0x25, 0x81, 0xEF, 0x25, 0x81, 0xEF, 0x25,
  // "Ś" (U+015A)
  0x58, 0x21, 0xEF, 0x97, 0x81, 0x9F, 0xC7, 0x82, 0x3F, 0xD1, 0x78, 0x1D, 0xC1, 0x77, 0x38, 0x91,
  0x29, 0xDE, 0xED, 0xB7, 0x20, 0x6A, 0x82, 0xEC, 0xCE, 0xA0, 0x60, 0x2A, 0x07, 0x48, 0x43, 0x91,
  0x7F, 0xC7, 0x18, 0x18, 0xFA, 0x71, 0x82, 0x6F, 0xE1, 0x78, 0x31, 0xEF, 0xD4, 0x70, 0x30, 0xEA,
  0x0C, 0x06, 0x68, 0x11, 0x9E, 0xA0, 0xE0, 0x87, 0x06, 0x0C, 0xA0, 0xD0, 0x17, 0x82, 0x4E, 0xF9,
  0x71, 0x81, 0x5F, 0xE7, 0x10, 0x2A, 0x71, 0x83, 0x5F, 0xD7, 0x45, 0x83, 0x4E, 0xF7, 0xCA, 0x82,
  0xDC, 0xCE, 0xA8, 0x49, 0x04, 0xAC, 0xEA, 0x81, 0xDA, 0x42,
  // "ś" (U+015B)
  0x48, 0x21, 0xEF, 0x96, 0x81, 0x9F, 0xC6, 0x82, 0x3F, 0xD1, 0x68, 0x1D, 0xC1, 0x77, 0x18, 0xA4,
  0x18, 0xCE, 0xED, 0xA5, 0x02, 0xEF, 0xEC, 0xCE, 0xFD, 0x0A, 0xF9, 0x48, 0x44, 0x50, 0xBF, 0x47,
  0x82, 0x8F, 0xD3, 0x70, 0xAA, 0x0C, 0x06, 0x60, 0x40, 0xBA, 0x0E, 0x07, 0x68, 0x31, 0x8E, 0xFB,
  0x78, 0x22, 0xEF, 0x47, 0x83, 0xAF, 0x66, 0x34, 0x89, 0x03, 0xEF, 0x3B, 0xFE, 0xCB, 0xDA, 0x83,
  0x90, 0x39, 0xDA, 0x81, 0xDA, 0x42,
  // "Ŝ" (U+015C)
  0x40, 0x6A, 0x06, 0x68, 0x42, 0xEE, 0xFE, 0x24, 0x86, 0x1D, 0xE3, 0x4F, 0xD1, 0x38, 0x1C, 0xD2,
  0x28, 0x13, 0xDC, 0x77, 0x89, 0x12, 0x9D, 0xEE, 0xDB, 0x72, 0x06, 0xA8, 0x2E, 0xCC, 0xEA, 0x06,
  0x02, 0xA0, 0x74, 0x84, 0x39, 0x17, 0xFC, 0x71, 0x81, 0x8F, 0xA7, 0x18, 0x26, 0xFE, 0x17, 0x83,
  0x1E, 0xFD, 0x47, 0x03, 0x0E, 0xA0, 0xC0, 0x66, 0x81, 0x19, 0xEA, 0x0E, 0x08, 0x70, 0x60, 0xCA,
  0x0D, 0x01, 0x78, 0x24, 0xEF, 0x97, 0x18, 0x15, 0xFE, 0x71, 0x02, 0xA7, 0x18, 0x35, 0xFD, 0x74,
  0x58, 0x34, 0xEF, 0x7C, 0xA8, 0x2D, 0xCC, 0xEA, 0x84, 0x90, 0x4A, 0xCE, 0xA8, 0x1D, 0xA4, 0x20,
  // "ŝ" (U+015D)
  0x30, 0x6A, 0x06, 0x58, 0x42, 0xEE, 0xFE, 0x23, 0x86, 0x1D, 0xE3, 0x4F, 0xD1, 0x28, 0x1C, 0xD2,
  0x28, 0x13, 0xDC, 0x75, 0x8A, 0x41, 0x8C, 0xEE, 0xDA, 0x50, 0x2E, 0xFE, 0xCC, 0xEF, 0xD0, 0xAF,
  0x94, 0x84, 0x45, 0x0B, 0xF4, 0x78, 0x28, 0xFD, 0x37, 0x0A, 0xA0, 0xC0, 0x66, 0x04, 0x0B, 0xA0,
  0xE0, 0x76, 0x83, 0x18, 0xEF, 0xB7, 0x82, 0x2E, 0xF4, 0x78, 0x3A, 0xF6, 0x63, 0x48, 0x90, 0x3E,
  0xF3, 0xBF, 0xEC, 0xBD, 0xA8, 0x39, 0x03, 0x9D, 0xA8, 0x1D, 0xA4, 0x20,
  // "Ş" (U+015E)
  0x28, 0x91, 0x29, 0xDE, 0xED, 0xB7, 0x20, 0x6A, 0x82, 0xEC, 0xCE, 0xA0, 0x60, 0x2A, 0x07, 0x48,
  0x43, 0x91, 0x7F, 0xC7, 0x18, 0x18, 0xFA, 0x71, 0x82, 0x6F, 0xE1, 0x78, 0x31, 0xEF, 0xD4, 0x70,
  0x30, 0xEA, 0x0C, 0x06, 0x68, 0x11, 0x9E, 0xA0, 0xE0, 0x87, 0x06, 0x0C, 0xA0, 0xD0, 0x17, 0x82,
  0x4E, 0xF9, 0x71, 0x81, 0x5F, 0xE7, 0x10, 0x2A, 0x71, 0x83, 0x5F, 0xD7, 0x45, 0x83, 0x4E, 0xF7,
  0xCA, 0x82, 0xDC, 0xCE, 0xA8, 0x49, 0x04, 0xAC, 0xEB, 0x0A, 0x04, 0x68, 0x12, 0xF3, 0x71, 0x82,
  0x7F, 0xD4, 0x71, 0x81, 0x1C, 0xE6, 0x83, 0x11, 0x2C, 0xE6, 0x0A, 0xA0, 0xE0, 0x56, 0x81, 0x13,
  0x25,
  // "ş" (U+015F)
  0x18, 0xA4, 0x18, 0xCE, 0xED, 0xA5, 0x02, 0xEF, 0xEC, 0xCE, 0xFD, 0x0A, 0xF9, 0x48, 0x44, 0x50,
  0xBF, 0x47, 0x82, 0x8F, 0xD3, 0x70, 0xAA, 0x0C, 0x06, 0x60, 0x40, 0xBA, 0x0E, 0x07, 0x68, 0x31,
  0x8E, 0xFB, 0x78, 0x22, 0xEF, 0x47, 0x83, 0xAF, 0x66, 0x34, 0x89, 0x03, 0xEF, 0x3B, 0xFE, 0xCB,
  0xDA, 0x83, 0x90, 0x39, 0xDB, 0x0A, 0x04, 0x58, 0x12, 0xF3, 0x78, 0x27, 0xFD, 0x47, 0x81, 0x1C,
  0xE5, 0x83, 0x11, 0x2C, 0xE5, 0x0A, 0xA0, 0xE0, 0x55, 0x81, 0x13, 0x25,
  // "Š" (U+0160)
  0x28, 0x1C, 0xD2, 0x28, 0x12, 0xDD, 0x38, 0x61, 0xDE, 0x33, 0xED, 0x14, 0x84, 0x3E, 0xEE, 0xE2,
  0x60, 0x6A, 0x06, 0x77, 0x28, 0x91, 0x29, 0xDE, 0xED, 0xB7, 0x20, 0x6A, 0x82, 0xEC, 0xCE, 0xA0,
  0x60, 0x2A, 0x07, 0x48, 0x43, 0x91, 0x7F, 0xC7, 0x18, 0x18, 0xFA, 0x71, 0x82, 0x6F, 0xE1, 0x78,
  0x31, 0xEF, 0xD4, 0x70, 0x30, 0xEA, 0x0C, 0x06, 0x68, 0x11, 0x9E, 0xA0, 0xE0, 0x87, 0x06, 0x0C,
  0xA0, 0xD0, 0x17, 0x82, 0x4E, 0xF9, 0x71, 0x81, 0x5F, 0xE7, 0x10, 0x2A, 0x71, 0x83, 0x5F, 0xD7,
  0x45, 0x83, 0x4E, 0xF7, 0xCA, 0x82, 0xDC, 0xCE, 0xA8, 0x49, 0x04, 0xAC, 0xEA, 0x81, 0xDA, 0x42,
  // "š" (U+0161)
  0x18, 0x1C, 0xD2, 0x28, 0x12, 0xDD, 0x28, 0x61, 0xDE, 0x33, 0xED, 0x13, 0x84, 0x3E, 0xEE, 0xE2,
  0x50, 0x6A, 0x06, 0x77, 0x8A, 0x41, 0x8C, 0xEE, 0xDA, 0x50, 0x2E, 0xFE, 0xCC, 0xEF, 0xD0, 0xAF,
  0x94, 0x84, 0x45, 0x0B, 0xF4, 0x78, 0x28, 0xFD, 0x37, 0x0A, 0xA0, 0xC0, 0x66, 0x04, 0x0B, 0xA0,
  0xE0, 0x76, 0x83, 0x18, 0xEF, 0xB7, 0x82, 0x2E, 0xF4, 0x78, 0x3A, 0xF6, 0x63, 0x48, 0x90, 0x3E,
  0xF3, 0xBF, 0xEC, 0xBD, 0xA8, 0x39, 0x03, 0x9D, 0xA8, 0x1D, 0xA4, 0x20,
  // "Ţ" (U+0162)
  0x0B, 0xFD, 0x87, 0x18, 0xBB, 0xBB, 0xDF, 0xE8, 0x01, 0xB6, 0x81, 0x6F, 0xB7, 0x48, 0x16, 0xFB,
  0x74, 0x81, 0x6F, 0xB7, 0x48, 0x16, 0xFB, 0x74, 0x81, 0x6F, 0xB7, 0x48, 0x16, 0xFB, 0x74, 0x81,
  0x6F, 0xB7, 0x48, 0x16, 0xFB, 0x74, 0x81, 0x6F, 0xB7, 0x48, 0x16, 0xFB, 0x74, 0x81, 0x6F, 0xB7,
  0x48, 0x16, 0xFB, 0x74, 0x81, 0x6F, 0xB7, 0x48, 0x16, 0xFB, 0x74, 0x81, 0x6F, 0xD7, 0x48, 0x12,
  0xF3, 0x74, 0x82, 0x7F, 0xD4, 0x74, 0x81, 0x1C, 0xE7, 0x28, 0x31, 0x12, 0xCE, 0x72, 0x0A, 0xA0,
  0xE0, 0x57, 0x28, 0x11, 0x32, 0x70,
  // "ţ" (U+0163)
  0x28, 0x11, 0xF4, 0x68, 0x15, 0xF4, 0x68, 0x1A, 0xF4, 0x40, 0x40, 0xCE, 0x18, 0x37, 0xBE, 0xFC,
  0x0F, 0xB3, 0x81, 0xCF, 0x46, 0x81, 0xCF, 0x46, 0x81, 0xCF, 0x46, 0x81, 0xCF, 0x46, 0x81, 0xCF,
  0x46, 0x81, 0xCF, 0x46, 0x81, 0xCF, 0x46, 0x81, 0xBF, 0x56, 0x81, 0x9F, 0xB6, 0x03, 0xA8, 0x2E,
  0xCD, 0x23, 0x04, 0xA8, 0x1E, 0xC1, 0x38, 0x12, 0xF3, 0x68, 0x27, 0xFD, 0x46, 0x81, 0x1C, 0xE4,
  0x83, 0x11, 0x2C, 0xE4, 0x0A, 0xA0, 0xE0, 0x54, 0x81, 0x13, 0x24,
  // "Ť" (U+0164)
  0x38, 0x1C, 0xD2, 0x28, 0x12, 0xDD, 0x68, 0x61, 0xDE, 0x33, 0xED, 0x17, 0x84, 0x3E, 0xEE, 0xE2,
  0x72, 0x06, 0xA0, 0x67, 0x75, 0x0B, 0xFD, 0x87, 0x18, 0xBB, 0xBB, 0xDF, 0xE8, 0x01, 0xB6, 0x81,
  0x6F, 0xB7, 0x48, 0x16, 0xFB, 0x74, 0x81, 0x6F, 0xB7, 0x48, 0x16, 0xFB, 0x74, 0x81, 0x6F, 0xB7,
  0x48, 0x16, 0xFB, 0x74, 0x81, 0x6F, 0xB7, 0x48, 0x16, 0xFB, 0x74, 0x81, 0x6F, 0xB7, 0x48, 0x16,
  0xFB, 0x74, 0x81, 0x6F, 0xB7, 0x48, 0x16, 0xFB, 0x74, 0x81, 0x6F, 0xB7, 0x48, 0x16, 0xFB, 0x74,
  0x81, 0x6F, 0xB6,
  // "ť" (U+0165)
  0x72, 0x81, 0xDF, 0x27, 0x18, 0x11, 0xFC, 0x40, 0x60, 0x23, 0x81, 0x4F, 0x53, 0x81, 0x4F, 0x43,
  0x08, 0x0C, 0x48, 0x19, 0xF4, 0x70, 0x40, 0xBE, 0x48, 0x37, 0xBE, 0xFC, 0x0F, 0xB6, 0x81, 0xCF,
  0x47, 0x28, 0x1C, 0xF4, 0x72, 0x81, 0xCF, 0x47, 0x28, 0x1C, 0xF4, 0x72, 0x81, 0xCF, 0x47, 0x28,
  0x1C, 0xF4, 0x72, 0x81, 0xCF, 0x47, 0x28, 0x1B, 0xF5, 0x72, 0x81, 0x9F, 0xB7, 0x20, 0x3A, 0x82,
  0xEC, 0xD2, 0x68, 0x44, 0xBE, 0xEC, 0x13,
  // "Ŧ" (U+0166)
  0x0B, 0xFD, 0x87, 0x18, 0xBB, 0xBB, 0xDF, 0xE8, 0x01, 0xB6, 0x81, 0x6F, 0xB7, 0x48, 0x16, 0xFB,
  0x74, 0x81, 0x6F, 0xB7, 0x48, 0x16, 0xFB, 0x74, 0x81, 0x6F, 0xB7, 0x10, 0xFB, 0x85, 0xDF, 0xEB,
  0xBB, 0x34, 0xFA, 0x04, 0x78, 0x16, 0xFB, 0x74, 0x81, 0x6F, 0xB7, 0x48, 0x16, 0xFB, 0x74, 0x81,
  0x6F, 0xB7, 0x48, 0x16, 0xFB, 0x74, 0x81, 0x6F, 0xB7, 0x48, 0x16, 0xFB, 0x74, 0x81, 0x6F, 0xB6,
  // "ŧ" (U+0167)
  0x28, 0x11, 0xF4, 0x68, 0x15, 0xF4, 0x68, 0x1A, 0xF4, 0x40, 0x40, 0xCE, 0x18, 0x37, 0xBE, 0xFC,
  0x0F, 0xB3, 0x81, 0xCF, 0x46, 0x81, 0xCF, 0x44, 0x89, 0x04, 0xBE, 0xFC, 0xBB, 0x90, 0x6E, 0x0C,
  0x38, 0x1C, 0xF4, 0x68, 0x1C, 0xF4, 0x68, 0x1C, 0xF4, 0x68, 0x1B, 0xF6, 0x68, 0x19, 0xFB, 0x60,
  0x3A, 0x82, 0xEC, 0xD2, 0x38, 0x44, 0xBE, 0xEC, 0x10,
  // "Ũ" (U+0168)
  0x28, 0x31, 0xAE, 0xC6, 0x20, 0x0A, 0x58, 0x79, 0xFC, 0xEF, 0xEC, 0xF5, 0x58, 0x6E, 0x60, 0x18,
  0xDE, 0x87, 0x74, 0x81, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47,
  0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18,
  0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C,
  0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xCF, 0x57, 0x18, 0x4C, 0xF4,
  0x9F, 0x87, 0x1A, 0x83, 0x25, 0xFE, 0x16, 0x81, 0x7F, 0xC2, 0x82, 0xCF, 0xC2, 0x40, 0x6A, 0x04,
  0x20, 0x10, 0xCA, 0x85, 0xDB, 0xCE, 0xFE, 0x55, 0x86, 0x6B, 0xEF, 0xEC, 0x82, 0x30,
  // "ũ" (U+0169)
  0x28, 0x31, 0xAE, 0xC6, 0x20, 0x0A, 0x38, 0x79, 0xFC, 0xEF, 0xEC, 0xF5, 0x38, 0x6E, 0x60, 0x18,
  0xDE, 0x87, 0x70, 0x1A, 0x68, 0x24, 0xFC, 0x1A, 0x68, 0x24, 0xFC, 0x1A, 0x68, 0x24, 0xFC, 0x1A,
  0x68, 0x24, 0xFC, 0x1A, 0x68, 0x24, 0xFC, 0x1A, 0x68, 0x24, 0xFC, 0x1A, 0x68, 0x24, 0xFC, 0x1A,
  0x68, 0x25, 0xFC, 0x1A, 0x01, 0x58, 0x17, 0xFC, 0x1A, 0x03, 0x58, 0x6D, 0xFC, 0x0B, 0xFC, 0x13,
  0x09, 0xA8, 0x1C, 0x03, 0xA8, 0x6E, 0xCC, 0xEF, 0x7F, 0xC2, 0x89, 0x03, 0xAE, 0xFE, 0xA3, 0x0F,
  0xC0,
  // "Ū" (U+016A)
  0x38, 0x03, 0xB0, 0x16, 0xF0, 0x17, 0x73, 0x81, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18,
  0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C,
  0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5,
  0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xCF,
  0x57, 0x18, 0x4C, 0xF4, 0x9F, 0x87, 0x1A, 0x83, 0x25, 0xFE, 0x16, 0x81, 0x7F, 0xC2, 0x82, 0xCF,
  0xC2, 0x40, 0x6A, 0x04, 0x20, 0x10, 0xCA, 0x85, 0xDB, 0xCE, 0xFE, 0x55, 0x86, 0x6B, 0xEF, 0xEC,
  0x82, 0x30,
  // "ū" (U+016B)
  0x38, 0x03, 0xB0, 0x14, 0xF0, 0x17, 0x60, 0x1A, 0x68, 0x24, 0xFC, 0x1A, 0x68, 0x24, 0xFC, 0x1A,
  0x68, 0x24, 0xFC, 0x1A, 0x68, 0x24, 0xFC, 0x1A, 0x68, 0x24, 0xFC, 0x1A, 0x68, 0x24, 0xFC, 0x1A,
  0x68, 0x24, 0xFC, 0x1A, 0x68, 0x25, 0xFC, 0x1A, 0x01, 0x58, 0x17, 0xFC, 0x1A, 0x03, 0x58, 0x6D,
  0xFC, 0x0B, 0xFC, 0x13, 0x09, 0xA8, 0x1C, 0x03, 0xA8, 0x6E, 0xCC, 0xEF, 0x7F, 0xC2, 0x89, 0x03,
  0xAE, 0xFE, 0xA3, 0x0F, 0xC0,
  // "Ŭ" (U+016C)
  0x30, 0xE0, 0x73, 0x81, 0x2F, 0x46, 0x85, 0x8F, 0xDB, 0xDF, 0xC7, 0x18, 0x47, 0xDF, 0xD9, 0x17,
  0x74, 0x81, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C,
  0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5,
  0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF,
  0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xCF, 0x57, 0x18, 0x4C, 0xF4, 0x9F, 0x87,
  0x1A, 0x83, 0x25, 0xFE, 0x16, 0x81, 0x7F, 0xC2, 0x82, 0xCF, 0xC2, 0x40, 0x6A, 0x04, 0x20, 0x10,
  0xCA, 0x85, 0xDB, 0xCE, 0xFE, 0x55, 0x86, 0x6B, 0xEF, 0xEC, 0x82, 0x30,
  // "ŭ" (U+016D)
  0x30, 0xE0, 0x73, 0x81, 0x2F, 0x44, 0x85, 0x8F, 0xDB, 0xDF, 0xC6, 0x84, 0x7D, 0xFD, 0x91, 0x77,
  0x01, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F,
  0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x5F,
  0xC1, 0xA0, 0x15, 0x81, 0x7F, 0xC1, 0xA0, 0x35, 0x86, 0xDF, 0xC0, 0xBF, 0xC1, 0x30, 0x9A, 0x81,
  0xC0, 0x3A, 0x86, 0xEC, 0xCE, 0xF7, 0xFC, 0x28, 0x90, 0x3A, 0xEF, 0xEA, 0x30, 0xFC,
  // "Ů" (U+016E)
  0x48, 0x32, 0xCE, 0xC4, 0x72, 0x83, 0xC9, 0x07, 0xE7, 0x29, 0x83, 0x40, 0x1F, 0x27, 0x18, 0x3C,
  0x90, 0x7E, 0x72, 0x83, 0x2C, 0xEC, 0x47, 0x77, 0x75, 0x81, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF,
  0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47,
  0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18,
  0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C,
  0xF5, 0xCF, 0x57, 0x18, 0x4C, 0xF4, 0x9F, 0x87, 0x1A, 0x83, 0x25, 0xFE, 0x16, 0x81, 0x7F, 0xC2,
  0x82, 0xCF, 0xC2, 0x40, 0x6A, 0x04, 0x20, 0x10, 0xCA, 0x85, 0xDB, 0xCE, 0xFE, 0x55, 0x86, 0x6B,
  0xEF, 0xEC, 0x82, 0x30,
  // "ů" (U+016F)
  0x48, 0x32, 0xCE, 0xC4, 0x78, 0x3C, 0x90, 0x7E, 0x79, 0x83, 0x40, 0x1F, 0x26, 0x83, 0xC9, 0x07,
  0xE7, 0x83, 0x2C, 0xEC, 0x47, 0x77, 0x60, 0x1A, 0x68, 0x24, 0xFC, 0x1A, 0x68, 0x24, 0xFC, 0x1A,
  0x68, 0x24, 0xFC, 0x1A, 0x68, 0x24, 0xFC, 0x1A, 0x68, 0x24, 0xFC, 0x1A, 0x68, 0x24, 0xFC, 0x1A,
  0x68, 0x24, 0xFC, 0x1A, 0x68, 0x25, 0xFC, 0x1A, 0x01, 0x58, 0x17, 0xFC, 0x1A, 0x03, 0x58, 0x6D,
  0xFC, 0x0B, 0xFC, 0x13, 0x09, 0xA8, 0x1C, 0x03, 0xA8, 0x6E, 0xCC, 0xEF, 0x7F, 0xC2, 0x89, 0x03,
  0xAE, 0xFE, 0xA3, 0x0F, 0xC0,
  // "Ű" (U+0170)
  0x50, 0x3A, 0x83, 0x30, 0xEF, 0x66, 0x85, 0xBF, 0x70, 0x7F, 0xA6, 0x85, 0x4F, 0x90, 0x1E, 0xC7,
  0x0D, 0x0A, 0x28, 0x1A, 0xC1, 0x77, 0x38, 0x1D, 0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84,
  0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF,
  0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5D,
  0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5D, 0xF4, 0x71, 0x84, 0xCF, 0x5C, 0xF5,
  0x71, 0x84, 0xCF, 0x49, 0xF8, 0x71, 0xA8, 0x32, 0x5F, 0xE1, 0x68, 0x17, 0xFC, 0x28, 0x2C, 0xFC,
  0x24, 0x06, 0xA0, 0x42, 0x01, 0x0C, 0xA8, 0x5D, 0xBC, 0xEF, 0xE5, 0x58, 0x66, 0xBE, 0xFE, 0xC8,
  0x23,
  // "ű" (U+0171)
  0x40, 0x3A, 0x83, 0x30, 0xEF, 0x64, 0x85, 0xBF, 0x70, 0x7F, 0xA4, 0x85, 0x4F, 0x90, 0x1E, 0xC5,
  0x0D, 0x0A, 0x28, 0x1A, 0xC1, 0x77, 0x01, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6,
  0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6,
  0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x5F, 0xC1, 0xA0, 0x15, 0x81, 0x7F, 0xC1, 0xA0, 0x35, 0x86, 0xDF,
  0xC0, 0xBF, 0xC1, 0x30, 0x9A, 0x81, 0xC0, 0x3A, 0x86, 0xEC, 0xCE, 0xF7, 0xFC, 0x28, 0x90, 0x3A,
  0xEF, 0xEA, 0x30, 0xFC,
  // "Ų" (U+0172)
  0x81, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5,
  0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF,
  0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xDF, 0x47,
  0x18, 0x4C, 0xF5, 0xDF, 0x47, 0x18, 0x4C, 0xF5, 0xCF, 0x57, 0x18, 0x4C, 0xF5, 0x9F, 0x87, 0x1A,
  0x83, 0x35, 0xFE, 0x16, 0x81, 0x7F, 0xE2, 0x82, 0xCF, 0xC2, 0x40, 0x6A, 0x08, 0x20, 0x10, 0xCA,
  0x82, 0xDB, 0xCE, 0xA0, 0xC0, 0x14, 0x87, 0x6B, 0xEF, 0xEE, 0xFD, 0x17, 0x38, 0x1A, 0xF3, 0x73,
  0x81, 0x3F, 0x97, 0x48, 0x17, 0xF3, 0x74, 0x81, 0x7F, 0x47, 0x48, 0x34, 0xFE, 0xC5, 0x73, 0x82,
  0x9E, 0xE5, 0x20,
  // "ų" (U+0173)
  0x01, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F,
  0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x4F, 0xC1, 0xA6, 0x82, 0x5F,
  0xC1, 0xA0, 0x15, 0x81, 0x7F, 0xC1, 0xA0, 0x35, 0x86, 0xDF, 0xC0, 0xBF, 0xC1, 0x30, 0x9A, 0x81,
  0xC0, 0x3A, 0x86, 0xEC, 0xCE, 0xF7, 0xFC, 0x28, 0x90, 0x3A, 0xEF, 0xEA, 0x35, 0xFD, 0x71, 0x81,
  0x3F, 0x57, 0x20, 0x0C, 0x73, 0x90, 0xB7, 0x38, 0x2D, 0xFC, 0xB7, 0x18, 0x24, 0xDF, 0xC0,
  // "Ŵ" (U+0174)
  0x72, 0x06, 0xA0, 0x67, 0x73, 0x84, 0x2E, 0xEF, 0xE2, 0x77, 0x18, 0x61, 0xDE, 0x34, 0xFD, 0x17,
  0x78, 0x1C, 0xD2, 0x28, 0x13, 0xDC, 0x77, 0x77, 0x18, 0x19, 0xFA, 0x60, 0x3A, 0x05, 0x68, 0x45,
  0xFD, 0x5F, 0xE6, 0x07, 0xA0, 0x96, 0x82, 0x9F, 0x91, 0xA0, 0x25, 0x0C, 0xA0, 0xE6, 0x85, 0xDF,
  0x50, 0xCF, 0x64, 0x84, 0x1F, 0xEB, 0xF3, 0x40, 0x2A, 0x83, 0x10, 0x8F, 0xA4, 0x84, 0x5F, 0xA7,
  0xF8, 0x48, 0x16, 0xFC, 0x28, 0x13, 0xFE, 0x48, 0x4A, 0xF6, 0x3F, 0xD4, 0x81, 0xAF, 0x83, 0x81,
  0xEF, 0x33, 0x85, 0xEF, 0x20, 0xEF, 0x23, 0x81, 0xDF, 0x43, 0x81, 0xBF, 0x72, 0x81, 0x3F, 0xC2,
  0x81, 0x9F, 0x72, 0x02, 0xA4, 0x81, 0x6F, 0xB2, 0x81, 0x8F, 0x82, 0x81, 0x5F, 0xC2, 0x81, 0x6F,
  0xB4, 0x81, 0x2F, 0xE2, 0x81, 0xCF, 0x33, 0xA8, 0x31, 0x0A, 0xF7, 0x58, 0x4E, 0xF3, 0x1F, 0xE4,
  0x85, 0xBF, 0x50, 0xEF, 0x35, 0x84, 0xAF, 0x75, 0xFA, 0x48, 0x46, 0xF9, 0x2F, 0xE6, 0x84, 0x5F,
  0xA9, 0xF5, 0x48, 0x41, 0xFD, 0x5F, 0xA6, 0x84, 0x1F, 0xDC, 0xF1, 0x58, 0x3C, 0xFA, 0xF6, 0x70,
  0xDA, 0x0B, 0x68, 0x37, 0xFE, 0xF1, 0x70, 0x8A, 0x07, 0x60, 0x3A, 0x0D, 0x71, 0x04, 0xA0, 0x27,
  0x81, 0xDF, 0x94,
  // "ŵ" (U+0175)
  0x70, 0x6A, 0x06, 0x77, 0x84, 0x2E, 0xEF, 0xE2, 0x75, 0x86, 0x1D, 0xE3, 0x4F, 0xD1, 0x74, 0x81,
  0xCD, 0x22, 0x81, 0x3D, 0xC7, 0x77, 0x48, 0x19, 0xF9, 0x58, 0x1D, 0xFB, 0x58, 0x4A, 0xF7, 0x5F,
  0xC4, 0x02, 0xB0, 0x14, 0x82, 0xEF, 0x21, 0xA0, 0x13, 0x83, 0x7F, 0xCF, 0x53, 0x81, 0x3F, 0xE2,
  0x81, 0xCF, 0x53, 0x83, 0xCF, 0x5F, 0xA3, 0x81, 0x7F, 0x92, 0x81, 0x7F, 0x92, 0x84, 0x1F, 0xC0,
  0xEE, 0x38, 0x1B, 0xF5, 0x28, 0x13, 0xFD, 0x28, 0x56, 0xF8, 0x0A, 0xF4, 0x28, 0x1E, 0xF1, 0x38,
  0x95, 0xEF, 0x10, 0xBF, 0x30, 0x6F, 0x80, 0x3F, 0xC4, 0x84, 0xAF, 0x50, 0xFE, 0x28, 0x51, 0xFD,
  0x07, 0xF8, 0x48, 0x46, 0xF9, 0x4F, 0x93, 0x84, 0xCF, 0x2B, 0xF4, 0x48, 0x42, 0xFC, 0x8F, 0x43,
  0x83, 0x7F, 0x6F, 0xE6, 0x82, 0xDF, 0xCE, 0x48, 0x33, 0xFC, 0xFB, 0x60, 0x9A, 0x0A, 0x50, 0xDA,
  0x06, 0x60, 0x5A, 0x05, 0x50, 0x9A, 0x02, 0x30,
  // "Ŷ" (U+0176)
  0x50, 0x6A, 0x06, 0x72, 0x84, 0x2E, 0xEF, 0xE2, 0x78, 0x61, 0xDE, 0x34, 0xFD, 0x16, 0x81, 0xCD,
  0x22, 0x81, 0x3D, 0xC7, 0x73, 0x81, 0xBF, 0x97, 0x83, 0x1E, 0xF4, 0x3A, 0x02, 0x68, 0x18, 0xFB,
  0x28, 0x1A, 0xFA, 0x50, 0x1A, 0x03, 0x20, 0x2A, 0x03, 0x48, 0x19, 0xFA, 0x48, 0x18, 0xFB, 0x30,
  0x2A, 0x02, 0x48, 0x21, 0xEF, 0x32, 0x81, 0xAF, 0x96, 0x86, 0x7F, 0xC0, 0x3F, 0xE1, 0x78, 0x4E,
  0xF4, 0xBF, 0x77, 0x18, 0x36, 0xFE, 0xFE, 0x73, 0x0D, 0xA0, 0x67, 0x38, 0x15, 0xFE, 0x74, 0x81,
  0x4F, 0xD7, 0x48, 0x14, 0xFD, 0x74, 0x81, 0x4F, 0xD7, 0x48, 0x14, 0xFD, 0x74, 0x81, 0x4F, 0xD7,
  0x48, 0x14, 0xFD, 0x60,
  // "ŷ" (U+0177)
  0x40, 0x6A, 0x06, 0x71, 0x84, 0x2E, 0xEF, 0xE2, 0x68, 0x61, 0xDE, 0x34, 0xFD, 0x15, 0x81, 0xCD,
  0x22, 0x81, 0x3D, 0xC7, 0x72, 0x81, 0xCF, 0x76, 0x03, 0xA8, 0x21, 0x5F, 0xC6, 0x81, 0x8F, 0xA2,
  0x81, 0xEF, 0x35, 0x81, 0xEF, 0x42, 0x81, 0x9F, 0x84, 0x81, 0x4F, 0xE3, 0x81, 0x3F, 0xE4, 0x81,
  0x9F, 0x84, 0x81, 0xCF, 0x43, 0x81, 0xEF, 0x34, 0x81, 0x6F, 0xA2, 0x81, 0x4F, 0xC5, 0x01, 0xA8,
  0x31, 0x0A, 0xF7, 0x68, 0x5A, 0xF6, 0x0E, 0xF1, 0x68, 0x44, 0xFB, 0x4F, 0xB7, 0x18, 0x3D, 0xE9,
  0xF5, 0x71, 0x07, 0xA0, 0xE7, 0x20, 0x1A, 0x09, 0x73, 0x81, 0xEF, 0x37, 0x28, 0x14, 0xFD, 0x73,
  0x81, 0xBF, 0x67, 0x28, 0x17, 0xFE, 0x78, 0x19, 0xBD, 0xA0, 0x47, 0x83, 0x9F, 0xEB, 0x47, 0x10,
  // "Ÿ" (U+0178)
  0x38, 0x12, 0xA6, 0x28, 0x17, 0xA1, 0x68, 0x13, 0xE9, 0x28, 0x1A, 0xE2, 0x77, 0x77, 0x38, 0x1B,
  0xF9, 0x78, 0x31, 0xEF, 0x43, 0xA0, 0x26, 0x81, 0x8F, 0xB2, 0x81, 0xAF, 0xA5, 0x01, 0xA0, 0x32,
  0x02, 0xA0, 0x34, 0x81, 0x9F, 0xA4, 0x81, 0x8F, 0xB3, 0x02, 0xA0, 0x24, 0x82, 0x1E, 0xF3, 0x28,
  0x1A, 0xF9, 0x68, 0x67, 0xFC, 0x03, 0xFE, 0x17, 0x84, 0xEF, 0x4B, 0xF7, 0x71, 0x83, 0x6F, 0xEF,
  0xE7, 0x30, 0xDA, 0x06, 0x73, 0x81, 0x5F, 0xE7, 0x48, 0x14, 0xFD, 0x74, 0x81, 0x4F, 0xD7, 0x48,
  0x14, 0xFD, 0x74, 0x81, 0x4F, 0xD7, 0x48, 0x14, 0xFD, 0x74, 0x81, 0x4F, 0xD6,
  // "Ź" (U+0179)
  0x78, 0x21, 0xEF, 0x97, 0x28, 0x19, 0xFC, 0x72, 0x82, 0x3F, 0xD1, 0x72, 0x81, 0xDC, 0x17, 0x74,
  0x0C, 0xFB, 0x81, 0x80, 0x98, 0x03, 0xB0, 0xCA, 0x07, 0x72, 0x81, 0x8F, 0xD7, 0x20, 0x3A, 0x03,
  0x72, 0x81, 0xDF, 0x97, 0x28, 0x18, 0xFD, 0x72, 0x03, 0xA0, 0x47, 0x28, 0x1C, 0xF9, 0x72, 0x82,
  0x7F, 0xD1, 0x71, 0x02, 0xA0, 0x47, 0x28, 0x1C, 0xFA, 0x72, 0x82, 0x7F, 0xE1, 0x71, 0x82, 0x2E,
  0xF5, 0x72, 0x81, 0xBF, 0xA7, 0x28, 0x26, 0xFE, 0x17, 0x28, 0x1E, 0xFE, 0x80, 0x4B, 0x09, 0x01,
  0xFC, 0x0C,
  // "ź" (U+017A)
  0x58, 0x21, 0xEF, 0x97, 0x81, 0x9F, 0xC7, 0x82, 0x3F, 0xD1, 0x78, 0x1D, 0xC1, 0x77, 0x20, 0xAF,
  0x98, 0x12, 0x07, 0x80, 0x1B, 0x0C, 0xA0, 0x27, 0x81, 0xAF, 0x97, 0x81, 0x6F, 0xD7, 0x82, 0x2E,
  0xF3, 0x78, 0x1C, 0xF7, 0x78, 0x18, 0xFB, 0x78, 0x23, 0xFE, 0x17, 0x81, 0xDF, 0x57, 0x81, 0x9F,
  0x97, 0x81, 0x5F, 0xD7, 0x18, 0x1E, 0xFD, 0x80, 0x2B, 0x04, 0x01, 0xFA, 0x05,
  // "Ż" (U+017B)
  0x68, 0x18, 0xB1, 0x73, 0xA0, 0x67, 0x38, 0x1A, 0xE2, 0x77, 0x77, 0x30, 0xCF, 0xB8, 0x18, 0x09,
  0x80, 0x3B, 0x0C, 0xA0, 0x77, 0x28, 0x18, 0xFD, 0x72, 0x03, 0xA0, 0x37, 0x28, 0x1D, 0xF9, 0x72,
  0x81, 0x8F, 0xD7, 0x20, 0x3A, 0x04, 0x72, 0x81, 0xCF, 0x97, 0x28, 0x27, 0xFD, 0x17, 0x10, 0x2A,
  0x04, 0x72, 0x81, 0xCF, 0xA7, 0x28, 0x27, 0xFE, 0x17, 0x18, 0x22, 0xEF, 0x57, 0x28, 0x1B, 0xFA,
  0x72, 0x82, 0x6F, 0xE1, 0x72, 0x81, 0xEF, 0xE8, 0x04, 0xB0, 0x90, 0x1F, 0xC0, 0xC0,
  // "ż" (U+017C)
  0x58, 0x18, 0xB1, 0x71, 0xA0, 0x67, 0x18, 0x1A, 0xE2, 0x77, 0x75, 0x0A, 0xF9, 0x81, 0x20, 0x78,
  0x01, 0xB0, 0xCA, 0x02, 0x78, 0x1A, 0xF9, 0x78, 0x16, 0xFD, 0x78, 0x22, 0xEF, 0x37, 0x81, 0xCF,
  0x77, 0x81, 0x8F, 0xB7, 0x82, 0x3F, 0xE1, 0x78, 0x1D, 0xF5, 0x78, 0x19, 0xF9, 0x78, 0x15, 0xFD,
  0x71, 0x81, 0xEF, 0xD8, 0x02, 0xB0, 0x40, 0x1F, 0xA0, 0x50,
  // "Ž" (U+017D)
  0x38, 0x1C, 0xD2, 0x28, 0x12, 0xDD, 0x58, 0x61, 0xDE, 0x33, 0xED, 0x16, 0x84, 0x3E, 0xEE, 0xE2,
  0x71, 0x06, 0xA0, 0x67, 0x74, 0x0C, 0xFB, 0x81, 0x80, 0x98, 0x03, 0xB0, 0xCA, 0x07, 0x72, 0x81,
  0x8F, 0xD7, 0x20, 0x3A, 0x03, 0x72, 0x81, 0xDF, 0x97, 0x28, 0x18, 0xFD, 0x72, 0x03, 0xA0, 0x47,
  0x28, 0x1C, 0xF9, 0x72, 0x82, 0x7F, 0xD1, 0x71, 0x02, 0xA0, 0x47, 0x28, 0x1C, 0xFA, 0x72, 0x82,
  0x7F, 0xE1, 0x71, 0x82, 0x2E, 0xF5, 0x72, 0x81, 0xBF, 0xA7, 0x28, 0x26, 0xFE, 0x17, 0x28, 0x1E,
  0xFE, 0x80, 0x4B, 0x09, 0x01, 0xFC, 0x0C,
  // "ž" (U+017E)
  0x28, 0x1C, 0xD2, 0x28, 0x12, 0xDD, 0x38, 0x61, 0xDE, 0x33, 0xED, 0x14, 0x84, 0x3E, 0xEE, 0xE2,
  0x60, 0x6A, 0x06, 0x77, 0x10, 0xAF, 0x98, 0x12, 0x07, 0x80, 0x1B, 0x0C, 0xA0, 0x27, 0x81, 0xAF,
  0x97, 0x81, 0x6F, 0xD7, 0x82, 0x2E, 0xF3, 0x78, 0x1C, 0xF7, 0x78, 0x18, 0xFB, 0x78, 0x23, 0xFE,
  0x17, 0x81, 0xDF, 0x57, 0x81, 0x9F, 0x97, 0x81, 0x5F, 0xD7, 0x18, 0x1E, 0xFD, 0x80, 0x2B, 0x04,
  0x01, 0xFA, 0x05,
  // "ſ" (U+017F)
  0x18, 0x52, 0xAD, 0xFD, 0x63, 0xA8, 0x5D, 0xCE, 0x5A, 0xFA, 0x48, 0x1D, 0xF4, 0x48, 0x1E, 0xF2,
  0x48, 0x1E, 0xF2, 0x48, 0x1E, 0xF2, 0x48, 0x1E, 0xF2, 0x48, 0x1E, 0xF2, 0x48, 0x1E, 0xF2, 0x48,
  0x1E, 0xF2, 0x48, 0x1E, 0xF2, 0x48, 0x1E, 0xF2, 0x48, 0x1E, 0xF2, 0x48, 0x1E, 0xF2, 0x48, 0x1E,
  0xF2, 0x48, 0x1E, 0xF2, 0x48, 0x1E, 0xF2, 0x40,
  // "Ω" (U+03A9)
  0x58, 0x73, 0x8C, 0xEF, 0xDC, 0x72, 0x71, 0x09, 0xA8, 0x2E, 0xCB, 0xDB, 0x07, 0x68, 0x2B, 0xFD,
  0x55, 0x82, 0x7E, 0xF8, 0x48, 0x27, 0xFE, 0x17, 0x04, 0xA0, 0x43, 0x81, 0xDF, 0x67, 0x28, 0x19,
  0xFA, 0x20, 0x3A, 0x01, 0x72, 0x04, 0xA2, 0x81, 0x5F, 0xD7, 0x30, 0x1A, 0x83, 0x20, 0x6F, 0xC7,
  0x4A, 0x83, 0x30, 0x6F, 0xD7, 0x30, 0x1A, 0x81, 0x30, 0x4A, 0x73, 0x03, 0xA8, 0x11, 0x01, 0xA0,
  0x37, 0x28, 0x16, 0xFD, 0x38, 0x1B, 0xF8, 0x72, 0x81, 0xCF, 0x73, 0x82, 0x3F, 0xE1, 0x78, 0x23,
  0xFE, 0x14, 0x81, 0x7F, 0xB6, 0x82, 0x1D, 0xF4, 0x68, 0x19, 0xFA, 0x48, 0x21, 0xCF, 0x63, 0x01,
  0x80, 0x0B, 0xA0, 0xB3, 0x86, 0xEF, 0xEB, 0xBB, 0xA1, 0xE0, 0xC3, 0xE0, 0xD0,
  // "μ" (U+03BC)
  0x81, 0xEF, 0x25, 0x84, 0x3F, 0xEE, 0xF2, 0x58, 0x43, 0xFE, 0xEF, 0x25, 0x84, 0x3F, 0xEE, 0xF2,
  0x58, 0x43, 0xFE, 0xEF, 0x25, 0x84, 0x3F, 0xEE, 0xF2, 0x58, 0x43, 0xFE, 0xEF, 0x25, 0x84, 0x3F,
  0xEE, 0xF2, 0x58, 0x43, 0xFE, 0xEF, 0x35, 0x84, 0x6F, 0xEE, 0xF5, 0x58, 0x5B, 0xFE, 0xEF, 0xD2,
  0x30, 0x7A, 0x00, 0xEB, 0x8A, 0x3C, 0xCE, 0xF6, 0xFE, 0xEF, 0x5C, 0xFE, 0xB4, 0x0D, 0xEE, 0xF1,
  0x71, 0x81, 0xEF, 0x27, 0x18, 0x1E, 0xF2, 0x71, 0x81, 0xEF, 0x27, 0x18, 0x1E, 0xF2, 0x71, 0x81,
  0xEF, 0x27, 0x10,
  // "π" (U+03C0)
  0x03, 0x0B, 0xFE, 0x81, 0x8B, 0xCA, 0x80, 0x1B, 0x83, 0xDF, 0xDB, 0xB2, 0x01, 0xA5, 0x81, 0x8F,
  0x84, 0x01, 0xA5, 0x81, 0x8F, 0x84, 0x01, 0xA5, 0x81, 0x8F, 0x84, 0x01, 0xA5, 0x81, 0x8F, 0x84,
  0x01, 0xA5, 0x81, 0x8F, 0x84, 0x01, 0xA5, 0x81, 0x8F, 0x84, 0x01, 0xA5, 0x81, 0x8F, 0x84, 0x01,
  0xA5, 0x81, 0x8F, 0x84, 0x01, 0xA5, 0x81, 0x7F, 0xA4, 0x01, 0xA5, 0x04, 0xA0, 0xC0, 0x92, 0x01,
  0xA6, 0x82, 0x7E, 0xE8,
  // "–" (U+2013)
  0x80, 0x6B, 0xFB,
  // "—" (U+2014)
  0x80, 0xA2, 0xBF, 0xFF, 0x90,
  // "€" (U+20AC)
  0x58, 0x61, 0x8C, 0xEE, 0xDA, 0x55, 0x04, 0x0E, 0xA8, 0x1C, 0xCE, 0xA0, 0x23, 0x82, 0x2E, 0xF8,
  0x40, 0x40, 0x64, 0x81, 0xBF, 0x97, 0x30, 0x2A, 0x01, 0x73, 0x81, 0x6F, 0xB7, 0x20, 0x7F, 0xA0,
  0x63, 0x83, 0x38, 0xDF, 0xB8, 0x01, 0x80, 0x35, 0x81, 0xBF, 0x67, 0x28, 0x90, 0x38, 0xDF, 0xB8,
  0x88, 0x86, 0x40, 0x7F, 0x90, 0xB6, 0x81, 0x6F, 0xB7, 0x40, 0x1A, 0x01, 0x74, 0x81, 0xAF, 0xA7,
  0x48, 0x32, 0xEF, 0x91, 0x30, 0x10, 0x55, 0x03, 0x0E, 0xA8, 0x3C, 0xCD, 0xFD, 0x68, 0x61, 0x8C,
  0xEF, 0xEB, 0x51,
  // "₿" (U+20BF)
  0x28, 0x43, 0x70, 0x17, 0x25, 0x84, 0x7F, 0x13, 0xF4, 0x58, 0x47, 0xF1, 0x3F, 0x43, 0x0A, 0xC8,
  0x2E, 0xFA, 0x32, 0x84, 0xAF, 0xDB, 0xBC, 0xB8, 0x35, 0x0A, 0xF7, 0x38, 0x61, 0xAF, 0xE1, 0xAF,
  0x74, 0x01, 0xA8, 0x24, 0xAF, 0x75, 0x84, 0xEF, 0x4A, 0xF7, 0x40, 0x1A, 0x82, 0x2A, 0xF7, 0x48,
  0x93, 0x9F, 0xB0, 0xAF, 0xDB, 0xBC, 0xEE, 0x92, 0x0A, 0xE8, 0x5E, 0x91, 0x0A, 0xF7, 0x38, 0x63,
  0xAF, 0xE1, 0xAF, 0x75, 0x84, 0xCF, 0x8A, 0xF7, 0x58, 0x48, 0xFC, 0xAF, 0x75, 0x84, 0x7F, 0xCA,
  0xF7, 0x58, 0x4B, 0xFA, 0xAF, 0x74, 0x07, 0xA8, 0x64, 0xAF, 0xDB, 0xBC, 0xEA, 0x81, 0x80, 0xAE,
  0x0B, 0x04, 0x48, 0x47, 0xF1, 0x3F, 0x45, 0x84, 0x7F, 0x13, 0xF4, 0x58, 0x43, 0x70, 0x17, 0x23,
  // "‘" (U+2018)
  0x28, 0xA3, 0xDC, 0x04, 0xF8, 0x0A, 0xF5, 0x0E, 0xF2, 0x5F, 0xE0, 0x9F, 0xC1,
  // "’" (U+2019)
  0x18, 0xA4, 0x9F, 0xC0, 0xBF, 0x80, 0xEF, 0x32, 0xFD, 0x05, 0xF7, 0x09, 0xF1, 0x10,
  // "‚" (U+201A)
  0x18, 0xA4, 0x9F, 0xC0, 0xBF, 0x80, 0xEF, 0x32, 0xFD, 0x05, 0xF7, 0x09, 0xF1, 0x10,
  // "‛" (U+201B)
  0x83, 0x9F, 0xC0, 0x5A, 0x28, 0x91, 0xEF, 0x20, 0xAF, 0x50, 0x4F, 0x92, 0x0D, 0x0C,
  // "“" (U+201C)
  0x20, 0xD0, 0xC2, 0x85, 0x6F, 0x30, 0x3F, 0x82, 0x0D, 0x92, 0x85, 0xAF, 0x50, 0x3F, 0xB2, 0x89,
  0x1E, 0xF1, 0x09, 0xF8, 0x05, 0xFE, 0x28, 0x7E, 0xF5, 0x09, 0xFB, 0x03, 0xA0, 0x31,
  // "”" (U+201D)
  0x18, 0x39, 0xFC, 0x02, 0xA8, 0x73, 0x0C, 0xF8, 0x05, 0xFE, 0x28, 0x91, 0xEF, 0x30, 0x8F, 0x90,
  0x2F, 0xD2, 0x85, 0xBF, 0x40, 0x5F, 0x72, 0x0E, 0x0D, 0x28, 0x59, 0xF1, 0x03, 0xF7, 0x20,
  // "„" (U+201E)
  0x18, 0x39, 0xFC, 0x02, 0xA8, 0x73, 0x0C, 0xF8, 0x05, 0xFE, 0x28, 0x91, 0xEF, 0x30, 0x8F, 0x90,
  0x2F, 0xD2, 0x85, 0xBF, 0x40, 0x5F, 0x72, 0x0E, 0x0D, 0x28, 0x59, 0xF1, 0x03, 0xF7, 0x20,
  // "‟" (U+201F)
  0x83, 0x9F, 0xB0, 0x3A, 0x83, 0x30, 0x5F, 0xE2, 0x81, 0xEF, 0x52, 0xA8, 0x31, 0x09, 0xF8, 0x28,
  0x5A, 0xF5, 0x03, 0xFB, 0x28, 0x13, 0xF8, 0x20, 0xD9, 0x30, 0xD0, 0xC2, 0x81, 0x6F, 0x30,
  // "†" (U+2020)
  0x30, 0x1A, 0x02, 0x7A, 0x01, 0x70, 0xD0, 0xE7, 0x10, 0xB0, 0xC4, 0x89, 0x12, 0x43, 0x1A, 0xB1,
  0x34, 0x46, 0xF9, 0x89, 0x1B, 0x48, 0x75, 0xBB, 0x57, 0x87, 0x40, 0x90, 0xA7, 0x10, 0xA0, 0xB7,
  0x10, 0xB0, 0xC7, 0x10, 0xC0, 0xD7, 0x10, 0xD0, 0xE7, 0x10, 0xD0, 0xE7, 0x10, 0xE9, 0x71, 0xA0,
  0x17, 0xA0, 0x16, 0x01, 0xA0, 0x26, 0x02, 0xA0, 0x33,
  // "‡" (U+2021)
  0x4A, 0x03, 0x78, 0x1E, 0xF1, 0x70, 0xC9, 0x71, 0x0A, 0x0D, 0x48, 0x91, 0x7B, 0x98, 0xCD, 0x89,
  0xBA, 0x8A, 0x82, 0xDE, 0xED, 0xA8, 0x1D, 0x11, 0x20, 0x90, 0xD3, 0x01, 0x40, 0xC9, 0x71, 0x81,
  0xEF, 0x27, 0x81, 0xEF, 0x27, 0x0C, 0x97, 0x10, 0xA0, 0xD4, 0x8A, 0x28, 0xEC, 0xBD, 0xEB, 0xCD,
  0xC8, 0xDC, 0xBD, 0xEB, 0xCD, 0xC4, 0x0A, 0x0D, 0x71, 0x0C, 0x97, 0x18, 0x1E, 0xF1, 0x7A, 0x03,
  0x30,
  // "•" (U+2022)
  0x18, 0x33, 0xCE, 0xC3, 0x20, 0xDB, 0x81, 0xD0, 0x1D, 0x00, 0x1D, 0x81, 0x10, 0xDB, 0x0D, 0x28,
  0x32, 0xCE, 0xC3, 0x10,
  // "…" (U+2026)
  0x18, 0x1C, 0xE5, 0x38, 0x1C, 0xE5, 0x48, 0x2C, 0xE5, 0x3A, 0x0A, 0x20, 0x3A, 0x0A, 0x30, 0x3A,
  0x83, 0xA0, 0xCE, 0x43, 0x81, 0xCE, 0x44, 0x81, 0xCE, 0x40,
  // "‰" (U+2030)
  0x18, 0x33, 0xCF, 0xD6, 0x68, 0x17, 0xF5, 0x75, 0x85, 0x1E, 0xFC, 0xEF, 0x54, 0x81, 0x1E, 0xC7,
  0x68, 0x56, 0xF7, 0x02, 0xED, 0x48, 0x19, 0xF3, 0x76, 0x81, 0xAF, 0x12, 0x81, 0xAF, 0x12, 0x81,
  0x2F, 0xA7, 0x70, 0xC9, 0x38, 0x18, 0xF3, 0x28, 0x1B, 0xF2, 0x77, 0x0C, 0x0E, 0x38, 0x57, 0xF4,
  0x04, 0xF8, 0x77, 0x10, 0xB9, 0x38, 0x91, 0x8F, 0x30, 0xCE, 0x14, 0xAB, 0x74, 0x83, 0x29, 0xB8,
  0x12, 0x81, 0x9F, 0x22, 0x85, 0xBF, 0x16, 0xF6, 0x5C, 0x0A, 0x20, 0x10, 0xEB, 0x8B, 0x3D, 0x10,
  0x5F, 0xA1, 0x5F, 0xC0, 0xED, 0x0D, 0xE4, 0x1B, 0xF3, 0x08, 0xF7, 0x18, 0xF8, 0x20, 0xBC, 0x85,
  0x47, 0xF5, 0x2F, 0xA2, 0x84, 0x4F, 0x80, 0xDE, 0x30, 0xE0, 0xD3, 0x89, 0x17, 0xB9, 0x31, 0xEB,
  0x04, 0xF7, 0x28, 0x41, 0xFA, 0x0F, 0xC3, 0x0B, 0x97, 0x85, 0x9F, 0x30, 0x5F, 0x63, 0x98, 0x2B,
  0x0F, 0xB3, 0x81, 0xBF, 0x15, 0x81, 0x3F, 0xA2, 0x81, 0x4F, 0x73, 0x98, 0x2B, 0x0F, 0xC3, 0x0B,
  0x96, 0x81, 0xBF, 0x12, 0x81, 0x2F, 0x92, 0x84, 0x3F, 0x90, 0xDE, 0x30, 0xD0, 0xE5, 0x81, 0x4F,
  0x84, 0x89, 0x5E, 0xE1, 0x09, 0xF5, 0x09, 0xF4, 0x04, 0xFA, 0x50, 0xD0, 0xE5, 0x84, 0x7F, 0xED,
  0xFD, 0x20, 0x2A, 0x0C, 0xA0, 0x34, 0x81, 0x6F, 0x66, 0x83, 0x7E, 0xEB, 0x23, 0x83, 0x4D, 0xFD,
  0x52,
  // "‹" (U+2039)
  0x40, 0x14, 0x81, 0xAE, 0x32, 0x81, 0x8F, 0xB2, 0x87, 0x5F, 0xD1, 0x03, 0xFE, 0x22, 0x81, 0xDF,
  0x53, 0x81, 0x7F, 0xC4, 0x81, 0xAF, 0x94, 0x81, 0xCF, 0x73, 0x82, 0x1D, 0xF3, 0x30, 0x20, 0x51,
  // "›" (U+203A)
  0x10, 0x14, 0x81, 0xBE, 0x23, 0x82, 0x4F, 0xD1, 0x38, 0x17, 0xFB, 0x48, 0x1A, 0xF9, 0x48, 0x1D,
  0xF5, 0x28, 0x94, 0x5F, 0xD1, 0x03, 0xFE, 0x20, 0x1E, 0xF3, 0x28, 0x1C, 0xF6, 0x30, 0x20, 0x64,
  // "⁄" (U+2044)
  0x73, 0x81, 0x6F, 0x57, 0x28, 0x11, 0xEB, 0x73, 0x81, 0xAF, 0x27, 0x28, 0x14, 0xF8, 0x73, 0x00,
  0xD7, 0x38, 0x17, 0xF4, 0x72, 0x81, 0x2F, 0xA7, 0x38, 0x1B, 0xE1, 0x72, 0x81, 0x5F, 0x77, 0x30,
  0xE0, 0xC7, 0x38, 0x19, 0xF3, 0x72, 0x81, 0x3F, 0x97, 0x38, 0x1C, 0xE1, 0x72, 0x81, 0x6F, 0x57,
  0x28, 0x11, 0xEB, 0x73, 0x81, 0xAF, 0x27, 0x28, 0x14, 0xF8, 0x73,
  // "™" (U+2122)
  0x09, 0xD0, 0xC0, 0x3A, 0x03, 0x38, 0x91, 0x8F, 0xC1, 0x24, 0xF7, 0x22, 0x3A, 0x09, 0x38, 0x1D,
  0xFC, 0x28, 0x12, 0xF5, 0x28, 0x23, 0xFA, 0xE2, 0x82, 0x4E, 0xBC, 0x28, 0x12, 0xF5, 0x28, 0x90,
  0x3F, 0x5F, 0x40, 0xA9, 0xBC, 0x28, 0x12, 0xF5, 0x28, 0x90, 0x3F, 0x3C, 0xA0, 0xF3, 0xBC, 0x28,
  0x12, 0xF5, 0x28, 0x90, 0x3F, 0x36, 0xF7, 0xD0, 0xBC, 0x28, 0x12, 0xF5, 0x28, 0x23, 0xF3, 0x1A,
  0x82, 0x70, 0xBC, 0x28, 0x12, 0xF5, 0x28, 0x90, 0x3F, 0x30, 0xAF, 0x10, 0xBC, 0x30, 0x24, 0x02,
  0x20, 0x10, 0x22, 0x01, 0x02,
  // "⅒" (U+2152)
  0x28, 0x19, 0xFB, 0x68, 0x16, 0xF5, 0x73, 0x83, 0x3D, 0xEE, 0xB5, 0x81, 0x1E, 0xB7, 0x48, 0x3C,
  0xC2, 0xEB, 0x58, 0x1A, 0xF2, 0x74, 0x01, 0x20, 0xE0, 0xB4, 0x81, 0x4F, 0x87, 0x71, 0x0E, 0x0B,
  0x40, 0x0D, 0x77, 0x20, 0xE0, 0xB3, 0x81, 0x7F, 0x47, 0x72, 0x0E, 0x0B, 0x28, 0x12, 0xFA, 0x72,
  0x00, 0x16, 0x0E, 0x0B, 0x28, 0x1B, 0xE1, 0x28, 0x19, 0xFB, 0x20, 0x20, 0xCA, 0x0D, 0x04, 0x48,
  0x92, 0xEB, 0x05, 0xF7, 0x03, 0xDE, 0xEB, 0x28, 0x5C, 0xF8, 0x6D, 0xF2, 0x38, 0x3E, 0xB0, 0xEC,
  0x28, 0x7C, 0xC2, 0xEB, 0x03, 0xF9, 0x28, 0x14, 0xF8, 0x58, 0x19, 0xF3, 0x20, 0x12, 0x84, 0xEB,
  0x06, 0xF5, 0x30, 0xE0, 0xC4, 0x81, 0x3F, 0x96, 0x84, 0xEB, 0x08, 0xF3, 0x30, 0x0D, 0x48, 0x1C,
  0xE1, 0x68, 0x4E, 0xB0, 0x8F, 0x33, 0x00, 0xD3, 0x81, 0x6F, 0x57, 0x84, 0xEB, 0x06, 0xF4, 0x30,
  0xE0, 0xC2, 0x81, 0x1E, 0xB7, 0x18, 0x4E, 0xB0, 0x3F, 0x82, 0x81, 0x3F, 0x92, 0x81, 0xAF, 0x27,
  0x10, 0xE0, 0xB2, 0x89, 0x1D, 0xE5, 0x3C, 0xF4, 0x04, 0xF8, 0x72, 0x0E, 0x0B, 0x20, 0x30, 0xDB,
  0x08, 0x77, 0x68, 0x13, 0x41, 0x20,
  // "ﬁ" (U+FB01)
  0x48, 0x76, 0xCE, 0xEB, 0x1B, 0xD1, 0x30, 0xAA, 0x82, 0xCC, 0xD1, 0xA0, 0x42, 0x02, 0xA0, 0x34,
  0x09, 0x0B, 0x38, 0x15, 0xFC, 0x73, 0x81, 0x6F, 0xB7, 0x10, 0x40, 0xAE, 0x28, 0x6E, 0xF2, 0x7B,
  0xDF, 0xE0, 0xFB, 0x28, 0x1E, 0xF2, 0x28, 0x16, 0xFB, 0x58, 0x1E, 0xF2, 0x28, 0x16, 0xFB, 0x58,
  0x1E, 0xF2, 0x28, 0x16, 0xFB, 0x58, 0x1E, 0xF2, 0x28, 0x16, 0xFB, 0x58, 0x1E, 0xF2, 0x28, 0x16,
  0xFB, 0x58, 0x1E, 0xF2, 0x28, 0x16, 0xFB, 0x58, 0x1E, 0xF2, 0x28, 0x16, 0xFB, 0x58, 0x1E, 0xF2,
  0x28, 0x16, 0xFB, 0x58, 0x1E, 0xF2, 0x28, 0x16, 0xFB, 0x58, 0x1E, 0xF2, 0x28, 0x16, 0xFB, 0x58,
  0x1E, 0xF2, 0x28, 0x16, 0xFB, 0x58, 0x1E, 0xF2,
  // "ﬂ" (U+FB02)
  0x48, 0x76, 0xCE, 0xEB, 0x1E, 0xF2, 0x30, 0xAA, 0x85, 0xCC, 0xD0, 0xEF, 0x22, 0x02, 0xA0, 0x34,
  0x81, 0xEF, 0x22, 0x81, 0x5F, 0xC5, 0x81, 0xEF, 0x22, 0x81, 0x6F, 0xB5, 0x83, 0xEF, 0x24, 0xAE,
  0x28, 0x6E, 0xF2, 0x7B, 0xDF, 0xE0, 0xFB, 0x28, 0x1E, 0xF2, 0x28, 0x16, 0xFB, 0x58, 0x1E, 0xF2,
  0x28, 0x16, 0xFB, 0x58, 0x1E, 0xF2, 0x28, 0x16, 0xFB, 0x58, 0x1E, 0xF2, 0x28, 0x16, 0xFB, 0x58,
  0x1E, 0xF2, 0x28, 0x16, 0xFB, 0x58, 0x1E, 0xF2, 0x28, 0x16, 0xFB, 0x58, 0x1E, 0xF2, 0x28, 0x16,
  0xFB, 0x58, 0x1E, 0xF2, 0x28, 0x16, 0xFB, 0x58, 0x1E, 0xF2, 0x28, 0x16, 0xFB, 0x58, 0x1E, 0xF2,
  0x28, 0x16, 0xFB, 0x58, 0x1E, 0xF2, 0x28, 0x16, 0xFB, 0x58, 0x1E, 0xF2,
};

const Font& font_NotoSans_Regular_24() {
  static SmoothFont font(font_NotoSans_Regular_24_data);
  return font;
}

}  // namespace roo_display
