#include "120.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-Light (Noto Sans Light)
// Generated on Thu Mar 30 23:43:00 CEST 2023
static const uint8_t font_NotoSans_Light_120_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x02, 0x03, 0x01, 0x01, 0x57, 0x12, 0x07,
  0xFF, 0xEC, 0xFF, 0xE3, 0x00, 0x83, 0x00, 0x78, 0x00, 0x5C, 0xFF, 0xE3, 0x00, 0x1D, 0x00, 0x0F, 0x00, 0x8A, 0x00, 0x1F, 0x00, 0x1C, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x09, 0xFF, 0xFF, 0x00, 0x13, 0x00, 0x56, 0x00, 0x1E, 0x00, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x00, 0x08, 0x00, 0x37, 0x00, 0x23, 0x00, 0x56, 0x00, 0x2C, 0x00, 0x00, 0xE5, // """ (U+0022)
  0x00, 0x23, 0x00, 0x03, 0x00, 0x01, 0x00, 0x4A, 0x00, 0x56, 0x00, 0x4E, 0x00, 0x01, 0xAC, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x07, 0xFF, 0xFA, 0x00, 0x3A, 0x00, 0x5C, 0x00, 0x45, 0x00, 0x04, 0x92, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x5A, 0x00, 0x57, 0x00, 0x61, 0x00, 0x07, 0xC4, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x53, 0x00, 0x57, 0x00, 0x56, 0x00, 0x0C, 0x89, // "&" (U+0026)
  0x00, 0x27, 0x00, 0x08, 0x00, 0x37, 0x00, 0x0F, 0x00, 0x56, 0x00, 0x18, 0x00, 0x10, 0x65, // "'" (U+0027)
  0x00, 0x28, 0x00, 0x04, 0xFF, 0xEE, 0x00, 0x1D, 0x00, 0x56, 0x00, 0x21, 0x00, 0x10, 0xBD, // "(" (U+0028)
  0x00, 0x29, 0x00, 0x04, 0xFF, 0xEE, 0x00, 0x1C, 0x00, 0x56, 0x00, 0x21, 0x00, 0x12, 0x5E, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x06, 0x00, 0x29, 0x00, 0x3B, 0x00, 0x5C, 0x00, 0x42, 0x00, 0x14, 0x0C, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x06, 0x00, 0x0F, 0x00, 0x3E, 0x00, 0x47, 0x00, 0x45, 0x00, 0x15, 0xB6, // "+" (U+002B)
  0x00, 0x2C, 0x00, 0x04, 0xFF, 0xF1, 0x00, 0x12, 0x00, 0x0E, 0x00, 0x1B, 0x00, 0x16, 0xDC, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x04, 0x00, 0x1E, 0x00, 0x21, 0x00, 0x24, 0x00, 0x27, 0x00, 0x17, 0x3C, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x09, 0xFF, 0xFF, 0x00, 0x13, 0x00, 0x0B, 0x00, 0x1D, 0x00, 0x17, 0x59, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x00, 0x01, 0x00, 0x28, 0x00, 0x56, 0x00, 0x2A, 0x00, 0x17, 0x85, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3D, 0x00, 0x57, 0x00, 0x45, 0x00, 0x19, 0x37, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x0B, 0x00, 0x01, 0x00, 0x28, 0x00, 0x56, 0x00, 0x45, 0x00, 0x1C, 0x11, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x06, 0x00, 0x01, 0x00, 0x3C, 0x00, 0x57, 0x00, 0x45, 0x00, 0x1D, 0xC4, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x3C, 0x00, 0x57, 0x00, 0x45, 0x00, 0x1F, 0xD9, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x02, 0x00, 0x01, 0x00, 0x42, 0x00, 0x57, 0x00, 0x45, 0x00, 0x22, 0x4C, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x08, 0xFF, 0xFF, 0x00, 0x3D, 0x00, 0x56, 0x00, 0x45, 0x00, 0x24, 0xD3, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x3E, 0x00, 0x57, 0x00, 0x45, 0x00, 0x26, 0xF8, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x06, 0x00, 0x01, 0x00, 0x3D, 0x00, 0x56, 0x00, 0x45, 0x00, 0x29, 0xCF, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3D, 0x00, 0x57, 0x00, 0x45, 0x00, 0x2B, 0x8B, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3D, 0x00, 0x57, 0x00, 0x45, 0x00, 0x2E, 0xC1, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x09, 0xFF, 0xFF, 0x00, 0x13, 0x00, 0x41, 0x00, 0x1D, 0x00, 0x31, 0x99, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0x04, 0xFF, 0xF1, 0x00, 0x13, 0x00, 0x41, 0x00, 0x1D, 0x00, 0x31, 0xF2, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x06, 0x00, 0x10, 0x00, 0x3E, 0x00, 0x48, 0x00, 0x45, 0x00, 0x32, 0x88, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x06, 0x00, 0x1C, 0x00, 0x3D, 0x00, 0x3A, 0x00, 0x45, 0x00, 0x34, 0x26, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x06, 0x00, 0x10, 0x00, 0x3E, 0x00, 0x48, 0x00, 0x45, 0x00, 0x34, 0x67, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x03, 0xFF, 0xFF, 0x00, 0x2E, 0x00, 0x57, 0x00, 0x33, 0x00, 0x36, 0x03, // "?" (U+003F)
  0x00, 0x40, 0x00, 0x06, 0xFF, 0xF5, 0x00, 0x64, 0x00, 0x56, 0x00, 0x6B, 0x00, 0x37, 0xCF, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x00, 0x00, 0x01, 0x00, 0x48, 0x00, 0x56, 0x00, 0x49, 0x00, 0x3C, 0xC8, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x45, 0x00, 0x56, 0x00, 0x4C, 0x00, 0x3F, 0x8E, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x46, 0x00, 0x57, 0x00, 0x4B, 0x00, 0x42, 0x15, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x4D, 0x00, 0x56, 0x00, 0x55, 0x00, 0x44, 0x60, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x3A, 0x00, 0x56, 0x00, 0x42, 0x00, 0x46, 0xEB, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x3A, 0x00, 0x56, 0x00, 0x3D, 0x00, 0x48, 0x1B, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x4D, 0x00, 0x57, 0x00, 0x57, 0x00, 0x49, 0x60, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x4A, 0x00, 0x56, 0x00, 0x57, 0x00, 0x4C, 0x3E, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x06, 0x00, 0x01, 0x00, 0x1F, 0x00, 0x56, 0x00, 0x25, 0x00, 0x4E, 0x5D, // "I" (U+0049)
  0x00, 0x4A, 0xFF, 0xF5, 0xFF, 0xEB, 0x00, 0x12, 0x00, 0x56, 0x00, 0x1E, 0x00, 0x4F, 0xBD, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x46, 0x00, 0x56, 0x00, 0x47, 0x00, 0x51, 0xB8, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x3A, 0x00, 0x56, 0x00, 0x3E, 0x00, 0x54, 0x77, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x5C, 0x00, 0x56, 0x00, 0x69, 0x00, 0x55, 0xBB, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x4B, 0x00, 0x56, 0x00, 0x57, 0x00, 0x59, 0xE0, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x54, 0x00, 0x57, 0x00, 0x5C, 0x00, 0x5C, 0xF7, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x40, 0x00, 0x56, 0x00, 0x47, 0x00, 0x60, 0x27, // "P" (U+0050)
  0x00, 0x51, 0x00, 0x07, 0xFF, 0xEC, 0x00, 0x54, 0x00, 0x57, 0x00, 0x5C, 0x00, 0x62, 0x27, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x45, 0x00, 0x56, 0x00, 0x48, 0x00, 0x65, 0xCF, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3B, 0x00, 0x57, 0x00, 0x42, 0x00, 0x68, 0x51, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x00, 0x00, 0x01, 0x00, 0x3E, 0x00, 0x56, 0x00, 0x40, 0x00, 0x6A, 0xB8, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x0B, 0xFF, 0xFF, 0x00, 0x4B, 0x00, 0x56, 0x00, 0x57, 0x00, 0x6C, 0x69, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x00, 0x00, 0x01, 0x00, 0x45, 0x00, 0x56, 0x00, 0x46, 0x00, 0x6E, 0xF7, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x02, 0x00, 0x01, 0x00, 0x69, 0x00, 0x56, 0x00, 0x6C, 0x00, 0x71, 0xBE, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x00, 0x00, 0x01, 0x00, 0x41, 0x00, 0x56, 0x00, 0x42, 0x00, 0x76, 0xB0, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x00, 0x00, 0x01, 0x00, 0x40, 0x00, 0x56, 0x00, 0x40, 0x00, 0x79, 0xA0, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x04, 0x00, 0x01, 0x00, 0x40, 0x00, 0x56, 0x00, 0x45, 0x00, 0x7C, 0x06, // "Z" (U+005A)
  0x00, 0x5B, 0x00, 0x0A, 0xFF, 0xEE, 0x00, 0x23, 0x00, 0x56, 0x00, 0x27, 0x00, 0x7D, 0xCC, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x00, 0x01, 0x00, 0x28, 0x00, 0x56, 0x00, 0x2A, 0x00, 0x7F, 0x74, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0x03, 0xFF, 0xEE, 0x00, 0x1C, 0x00, 0x56, 0x00, 0x27, 0x00, 0x81, 0x21, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x05, 0x00, 0x21, 0x00, 0x3F, 0x00, 0x57, 0x00, 0x45, 0x00, 0x82, 0xBD, // "^" (U+005E)
  0x00, 0x5F, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x32, 0xFF, 0xF6, 0x00, 0x32, 0x00, 0x84, 0x85, // "_" (U+005F)
  0x00, 0x60, 0x00, 0x04, 0x00, 0x49, 0x00, 0x1A, 0x00, 0x5C, 0x00, 0x20, 0x00, 0x84, 0xA4, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x36, 0x00, 0x41, 0x00, 0x40, 0x00, 0x84, 0xFE, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x0A, 0xFF, 0xFF, 0x00, 0x40, 0x00, 0x5C, 0x00, 0x48, 0x00, 0x87, 0x29, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x35, 0x00, 0x41, 0x00, 0x39, 0x00, 0x8A, 0x17, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3D, 0x00, 0x5C, 0x00, 0x48, 0x00, 0x8B, 0xB7, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3B, 0x00, 0x41, 0x00, 0x42, 0x00, 0x8E, 0xAC, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x00, 0x01, 0x00, 0x2B, 0x00, 0x5C, 0x00, 0x25, 0x00, 0x90, 0x97, // "f" (U+0066)
  0x00, 0x67, 0x00, 0x06, 0xFF, 0xE4, 0x00, 0x3D, 0x00, 0x41, 0x00, 0x48, 0x00, 0x92, 0x8D, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x3D, 0x00, 0x5C, 0x00, 0x48, 0x00, 0x95, 0xBE, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x09, 0x00, 0x01, 0x00, 0x12, 0x00, 0x58, 0x00, 0x1C, 0x00, 0x98, 0x61, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xF9, 0xFF, 0xE4, 0x00, 0x12, 0x00, 0x58, 0x00, 0x1C, 0x00, 0x99, 0x4B, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x3A, 0x00, 0x5C, 0x00, 0x3B, 0x00, 0x9B, 0x0C, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x11, 0x00, 0x5C, 0x00, 0x1C, 0x00, 0x9D, 0xAA, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x61, 0x00, 0x41, 0x00, 0x6B, 0x00, 0x9E, 0x65, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x3D, 0x00, 0x41, 0x00, 0x48, 0x00, 0xA1, 0xD3, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3F, 0x00, 0x41, 0x00, 0x47, 0x00, 0xA3, 0xEE, // "o" (U+006F)
  0x00, 0x70, 0x00, 0x0A, 0xFF, 0xE4, 0x00, 0x41, 0x00, 0x41, 0x00, 0x48, 0x00, 0xA6, 0x31, // "p" (U+0070)
  0x00, 0x71, 0x00, 0x06, 0xFF, 0xE4, 0x00, 0x3D, 0x00, 0x41, 0x00, 0x48, 0x00, 0xA9, 0x2F, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x41, 0x00, 0x2F, 0x00, 0xAC, 0x2F, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x32, 0x00, 0x41, 0x00, 0x38, 0x00, 0xAD, 0x8F, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x25, 0x00, 0x50, 0x00, 0x29, 0x00, 0xAF, 0x5A, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x09, 0xFF, 0xFF, 0x00, 0x3C, 0x00, 0x40, 0x00, 0x48, 0x00, 0xB1, 0x07, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x00, 0x00, 0x01, 0x00, 0x38, 0x00, 0x40, 0x00, 0x38, 0x00, 0xB3, 0x04, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x00, 0x01, 0x00, 0x56, 0x00, 0x40, 0x00, 0x58, 0x00, 0xB5, 0x03, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x02, 0x00, 0x01, 0x00, 0x39, 0x00, 0x40, 0x00, 0x3C, 0x00, 0xB8, 0x7C, // "x" (U+0078)
  0x00, 0x79, 0x00, 0x00, 0xFF, 0xE4, 0x00, 0x38, 0x00, 0x40, 0x00, 0x38, 0x00, 0xBA, 0x9A, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x04, 0x00, 0x01, 0x00, 0x32, 0x00, 0x40, 0x00, 0x38, 0x00, 0xBD, 0x3E, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0x03, 0xFF, 0xEE, 0x00, 0x26, 0x00, 0x56, 0x00, 0x2B, 0x00, 0xBE, 0x94, // "{" (U+007B)
  0x00, 0x7C, 0x00, 0x1D, 0xFF, 0xE3, 0x00, 0x23, 0x00, 0x5C, 0x00, 0x41, 0x00, 0xC0, 0x90, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0x04, 0xFF, 0xEE, 0x00, 0x27, 0x00, 0x56, 0x00, 0x2B, 0x00, 0xC1, 0xC4, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x06, 0x00, 0x24, 0x00, 0x3E, 0x00, 0x31, 0x00, 0x45, 0x00, 0xC3, 0xC4, // "~" (U+007E)
  0x00, 0xA1, 0x00, 0x09, 0xFF, 0xEA, 0x00, 0x13, 0x00, 0x41, 0x00, 0x1E, 0x00, 0xC4, 0x65, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x0A, 0xFF, 0xFF, 0x00, 0x38, 0x00, 0x57, 0x00, 0x45, 0x00, 0xC5, 0x47, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x04, 0x00, 0x01, 0x00, 0x3F, 0x00, 0x57, 0x00, 0x45, 0x00, 0xC7, 0x5A, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x07, 0x00, 0x10, 0x00, 0x3D, 0x00, 0x46, 0x00, 0x45, 0x00, 0xC9, 0x57, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x02, 0x00, 0x01, 0x00, 0x41, 0x00, 0x56, 0x00, 0x45, 0x00, 0xCB, 0x7D, // "¥" (U+00A5)
  0x00, 0xA6, 0x00, 0x1D, 0xFF, 0xE3, 0x00, 0x23, 0x00, 0x5C, 0x00, 0x41, 0x00, 0xCD, 0xDF, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x07, 0x00, 0x00, 0x00, 0x34, 0x00, 0x5C, 0x00, 0x3E, 0x00, 0xCE, 0xCE, // "§" (U+00A7)
  0x00, 0xA8, 0x00, 0x13, 0x00, 0x4D, 0x00, 0x31, 0x00, 0x57, 0x00, 0x45, 0x00, 0xD1, 0x8B, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x5D, 0x00, 0x57, 0x00, 0x64, 0x00, 0xD1, 0xDA, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x04, 0x00, 0x2F, 0x00, 0x22, 0x00, 0x57, 0x00, 0x29, 0x00, 0xD6, 0x48, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x04, 0x00, 0x09, 0x00, 0x31, 0x00, 0x39, 0x00, 0x36, 0x00, 0xD7, 0x65, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x06, 0x00, 0x10, 0x00, 0x3D, 0x00, 0x2E, 0x00, 0x45, 0x00, 0xD9, 0x01, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x5D, 0x00, 0x57, 0x00, 0x64, 0x00, 0xD9, 0x9A, // "®" (U+00AE)
  0x00, 0xAF, 0xFF, 0xFF, 0x00, 0x5C, 0x00, 0x3C, 0x00, 0x61, 0x00, 0x3C, 0x00, 0xDE, 0x76, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x07, 0x00, 0x34, 0x00, 0x2B, 0x00, 0x57, 0x00, 0x33, 0x00, 0xDE, 0x90, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x06, 0x00, 0x01, 0x00, 0x3E, 0x00, 0x47, 0x00, 0x45, 0x00, 0xDF, 0x9E, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x03, 0x00, 0x32, 0x00, 0x24, 0x00, 0x67, 0x00, 0x29, 0x00, 0xE0, 0xE0, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x02, 0x00, 0x32, 0x00, 0x25, 0x00, 0x67, 0x00, 0x29, 0x00, 0xE2, 0x1F, // "³" (U+00B3)
  0x00, 0xB4, 0x00, 0x04, 0x00, 0x49, 0x00, 0x1A, 0x00, 0x5C, 0x00, 0x20, 0x00, 0xE3, 0x76, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0x0A, 0xFF, 0xE4, 0x00, 0x3D, 0x00, 0x40, 0x00, 0x48, 0x00, 0xE3, 0xCC, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0x09, 0xFF, 0xF1, 0x00, 0x3F, 0x00, 0x5C, 0x00, 0x4F, 0x00, 0xE6, 0x85, // "¶" (U+00B6)
  0x00, 0xB7, 0x00, 0x09, 0x00, 0x23, 0x00, 0x13, 0x00, 0x2E, 0x00, 0x1D, 0x00, 0xEA, 0x12, // "·" (U+00B7)
  0x00, 0xB8, 0x00, 0x01, 0xFF, 0xE4, 0x00, 0x17, 0x00, 0x00, 0x00, 0x19, 0x00, 0xEA, 0x3D, // "¸" (U+00B8)
  0x00, 0xB9, 0x00, 0x04, 0x00, 0x32, 0x00, 0x19, 0x00, 0x66, 0x00, 0x29, 0x00, 0xEA, 0xCB, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x04, 0x00, 0x2F, 0x00, 0x27, 0x00, 0x57, 0x00, 0x2C, 0x00, 0xEB, 0xBC, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x04, 0x00, 0x09, 0x00, 0x31, 0x00, 0x39, 0x00, 0x36, 0x00, 0xEC, 0xEE, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x03, 0x00, 0x01, 0x00, 0x55, 0x00, 0x56, 0x00, 0x57, 0x00, 0xEE, 0x8A, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x02, 0x00, 0x01, 0x00, 0x56, 0x00, 0x56, 0x00, 0x5B, 0x00, 0xF2, 0x95, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x02, 0x00, 0x01, 0x00, 0x5B, 0x00, 0x57, 0x00, 0x5C, 0x00, 0xF6, 0x6C, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0x04, 0xFF, 0xEA, 0x00, 0x2F, 0x00, 0x42, 0x00, 0x33, 0x00, 0xFA, 0xC3, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x48, 0x00, 0x72, 0x00, 0x49, 0x00, 0xFC, 0x86, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x00, 0x00, 0x01, 0x00, 0x48, 0x00, 0x72, 0x00, 0x49, 0x00, 0xFF, 0xBA, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x00, 0x00, 0x01, 0x00, 0x48, 0x00, 0x72, 0x00, 0x49, 0x01, 0x02, 0xF3, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x00, 0x00, 0x01, 0x00, 0x48, 0x00, 0x6D, 0x00, 0x49, 0x01, 0x06, 0x65, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x00, 0x00, 0x01, 0x00, 0x48, 0x00, 0x6D, 0x00, 0x49, 0x01, 0x09, 0xD0, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x00, 0x00, 0x01, 0x00, 0x48, 0x00, 0x6B, 0x00, 0x49, 0x01, 0x0C, 0xFD, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x00, 0x00, 0x01, 0x00, 0x5E, 0x00, 0x56, 0x00, 0x63, 0x01, 0x10, 0x7F, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0x07, 0xFF, 0xE4, 0x00, 0x46, 0x00, 0x57, 0x00, 0x4B, 0x01, 0x13, 0x9F, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x3A, 0x00, 0x72, 0x00, 0x42, 0x01, 0x16, 0x8F, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x3A, 0x00, 0x72, 0x00, 0x42, 0x01, 0x18, 0x33, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x3A, 0x00, 0x72, 0x00, 0x42, 0x01, 0x19, 0xDA, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x3A, 0x00, 0x6D, 0x00, 0x42, 0x01, 0x1B, 0xAA, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x03, 0x00, 0x01, 0x00, 0x1F, 0x00, 0x72, 0x00, 0x25, 0x01, 0x1D, 0x37, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x06, 0x00, 0x01, 0x00, 0x23, 0x00, 0x72, 0x00, 0x25, 0x01, 0x1E, 0xFD, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x00, 0x01, 0x00, 0x24, 0x00, 0x72, 0x00, 0x25, 0x01, 0x20, 0xE5, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x03, 0x00, 0x01, 0x00, 0x21, 0x00, 0x6D, 0x00, 0x25, 0x01, 0x23, 0x0E, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x02, 0x00, 0x01, 0x00, 0x4D, 0x00, 0x56, 0x00, 0x55, 0x01, 0x24, 0xEB, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x4B, 0x00, 0x6D, 0x00, 0x57, 0x01, 0x28, 0x15, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x54, 0x00, 0x72, 0x00, 0x5C, 0x01, 0x2B, 0xCF, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x54, 0x00, 0x72, 0x00, 0x5C, 0x01, 0x2F, 0x79, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x54, 0x00, 0x72, 0x00, 0x5C, 0x01, 0x33, 0x24, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x54, 0x00, 0x6D, 0x00, 0x5C, 0x01, 0x37, 0x00, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x54, 0x00, 0x6D, 0x00, 0x5C, 0x01, 0x3A, 0xD8, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x08, 0x00, 0x11, 0x00, 0x3B, 0x00, 0x45, 0x00, 0x45, 0x01, 0x3E, 0x6C, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x07, 0xFF, 0xFD, 0x00, 0x54, 0x00, 0x59, 0x00, 0x5C, 0x01, 0x40, 0x46, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x0B, 0xFF, 0xFF, 0x00, 0x4B, 0x00, 0x72, 0x00, 0x57, 0x01, 0x44, 0x99, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x0B, 0xFF, 0xFF, 0x00, 0x4B, 0x00, 0x72, 0x00, 0x57, 0x01, 0x47, 0x9E, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x0B, 0xFF, 0xFF, 0x00, 0x4B, 0x00, 0x72, 0x00, 0x57, 0x01, 0x4A, 0x9F, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x0B, 0xFF, 0xFF, 0x00, 0x4B, 0x00, 0x6D, 0x00, 0x57, 0x01, 0x4D, 0xDD, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x00, 0x00, 0x01, 0x00, 0x40, 0x00, 0x72, 0x00, 0x40, 0x01, 0x50, 0xD3, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x40, 0x00, 0x56, 0x00, 0x47, 0x01, 0x53, 0xAD, // "Þ" (U+00DE)
  0x00, 0xDF, 0x00, 0x0A, 0xFF, 0xFF, 0x00, 0x41, 0x00, 0x5C, 0x00, 0x47, 0x01, 0x55, 0xB2, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x36, 0x00, 0x5C, 0x00, 0x40, 0x01, 0x59, 0x0B, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x36, 0x00, 0x5C, 0x00, 0x40, 0x01, 0x5B, 0xA8, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x36, 0x00, 0x5C, 0x00, 0x40, 0x01, 0x5E, 0x47, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x36, 0x00, 0x58, 0x00, 0x40, 0x01, 0x61, 0x17, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x36, 0x00, 0x57, 0x00, 0x40, 0x01, 0x63, 0xD4, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x36, 0x00, 0x62, 0x00, 0x40, 0x01, 0x66, 0x5B, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x60, 0x00, 0x41, 0x00, 0x67, 0x01, 0x69, 0x56, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0x06, 0xFF, 0xE4, 0x00, 0x35, 0x00, 0x41, 0x00, 0x39, 0x01, 0x6C, 0xCD, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3B, 0x00, 0x5C, 0x00, 0x42, 0x01, 0x6F, 0x13, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3B, 0x00, 0x5C, 0x00, 0x42, 0x01, 0x71, 0x6F, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3B, 0x00, 0x5C, 0x00, 0x42, 0x01, 0x73, 0xCC, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3B, 0x00, 0x57, 0x00, 0x42, 0x01, 0x76, 0x62, // "ë" (U+00EB)
  0x00, 0xEC, 0xFF, 0xFE, 0x00, 0x01, 0x00, 0x14, 0x00, 0x5C, 0x00, 0x1C, 0x01, 0x78, 0xAE, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x08, 0x00, 0x01, 0x00, 0x1E, 0x00, 0x5C, 0x00, 0x1C, 0x01, 0x7A, 0x0C, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0xFC, 0x00, 0x01, 0x00, 0x1F, 0x00, 0x5C, 0x00, 0x1C, 0x01, 0x7B, 0x67, // "î" (U+00EE)
  0x00, 0xEF, 0xFF, 0xFE, 0x00, 0x01, 0x00, 0x1D, 0x00, 0x57, 0x00, 0x1C, 0x01, 0x7D, 0x1E, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3E, 0x00, 0x5C, 0x00, 0x46, 0x01, 0x7E, 0x8F, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x3D, 0x00, 0x58, 0x00, 0x48, 0x01, 0x81, 0xC2, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3F, 0x00, 0x5C, 0x00, 0x47, 0x01, 0x84, 0x74, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3F, 0x00, 0x5C, 0x00, 0x47, 0x01, 0x87, 0x25, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3F, 0x00, 0x5C, 0x00, 0x47, 0x01, 0x89, 0xDB, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3F, 0x00, 0x58, 0x00, 0x47, 0x01, 0x8C, 0xC4, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3F, 0x00, 0x57, 0x00, 0x47, 0x01, 0x8F, 0xA7, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x06, 0x00, 0x10, 0x00, 0x3E, 0x00, 0x45, 0x00, 0x45, 0x01, 0x92, 0x4B, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x06, 0xFF, 0xFD, 0x00, 0x3F, 0x00, 0x43, 0x00, 0x47, 0x01, 0x92, 0xF5, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x09, 0xFF, 0xFF, 0x00, 0x3C, 0x00, 0x5C, 0x00, 0x48, 0x01, 0x95, 0xDF, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x09, 0xFF, 0xFF, 0x00, 0x3C, 0x00, 0x5C, 0x00, 0x48, 0x01, 0x98, 0x4E, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x09, 0xFF, 0xFF, 0x00, 0x3C, 0x00, 0x5C, 0x00, 0x48, 0x01, 0x9A, 0xBB, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x09, 0xFF, 0xFF, 0x00, 0x3C, 0x00, 0x57, 0x00, 0x48, 0x01, 0x9D, 0x5E, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0x00, 0xFF, 0xE4, 0x00, 0x38, 0x00, 0x5C, 0x00, 0x38, 0x01, 0x9F, 0xBB, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0x0A, 0xFF, 0xE4, 0x00, 0x41, 0x00, 0x5C, 0x00, 0x48, 0x01, 0xA2, 0xD6, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0xE4, 0x00, 0x38, 0x00, 0x57, 0x00, 0x38, 0x01, 0xA6, 0x59, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x48, 0x00, 0x65, 0x00, 0x49, 0x01, 0xA9, 0x5E, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x36, 0x00, 0x4F, 0x00, 0x40, 0x01, 0xAC, 0x4E, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x48, 0x00, 0x6E, 0x00, 0x49, 0x01, 0xAE, 0x9E, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x36, 0x00, 0x58, 0x00, 0x40, 0x01, 0xB1, 0xFB, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0x00, 0xFF, 0xE6, 0x00, 0x48, 0x00, 0x56, 0x00, 0x49, 0x01, 0xB4, 0xAC, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0x05, 0xFF, 0xE6, 0x00, 0x39, 0x00, 0x41, 0x00, 0x40, 0x01, 0xB8, 0x10, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x46, 0x00, 0x72, 0x00, 0x4B, 0x01, 0xBA, 0xDA, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x35, 0x00, 0x5C, 0x00, 0x39, 0x01, 0xBD, 0x95, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x46, 0x00, 0x72, 0x00, 0x4B, 0x01, 0xBF, 0xA9, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x35, 0x00, 0x5C, 0x00, 0x39, 0x01, 0xC2, 0x9B, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x46, 0x00, 0x6E, 0x00, 0x4B, 0x01, 0xC4, 0xDF, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x35, 0x00, 0x58, 0x00, 0x39, 0x01, 0xC7, 0x6D, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x46, 0x00, 0x72, 0x00, 0x4B, 0x01, 0xC9, 0x4B, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x35, 0x00, 0x5C, 0x00, 0x39, 0x01, 0xCC, 0x3D, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x4D, 0x00, 0x72, 0x00, 0x55, 0x01, 0xCE, 0x7A, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x4D, 0x00, 0x5C, 0x00, 0x48, 0x01, 0xD1, 0xB7, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x02, 0x00, 0x01, 0x00, 0x4D, 0x00, 0x56, 0x00, 0x55, 0x01, 0xD5, 0x34, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x46, 0x00, 0x5C, 0x00, 0x48, 0x01, 0xD8, 0x5E, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x3A, 0x00, 0x65, 0x00, 0x42, 0x01, 0xDB, 0x89, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3B, 0x00, 0x4F, 0x00, 0x42, 0x01, 0xDC, 0xDD, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x3A, 0x00, 0x6E, 0x00, 0x42, 0x01, 0xDE, 0xED, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3B, 0x00, 0x58, 0x00, 0x42, 0x01, 0xE0, 0xA5, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x3A, 0x00, 0x6E, 0x00, 0x42, 0x01, 0xE3, 0x1B, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3B, 0x00, 0x58, 0x00, 0x42, 0x01, 0xE4, 0x8C, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0x0C, 0xFF, 0xE6, 0x00, 0x3A, 0x00, 0x56, 0x00, 0x42, 0x01, 0xE6, 0xB3, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0x06, 0xFF, 0xE6, 0x00, 0x3B, 0x00, 0x41, 0x00, 0x42, 0x01, 0xE8, 0x7B, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x3A, 0x00, 0x72, 0x00, 0x42, 0x01, 0xEA, 0xFC, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3B, 0x00, 0x5C, 0x00, 0x42, 0x01, 0xEC, 0xCB, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x4D, 0x00, 0x72, 0x00, 0x57, 0x01, 0xEF, 0x5C, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0x06, 0xFF, 0xE4, 0x00, 0x3D, 0x00, 0x5C, 0x00, 0x48, 0x01, 0xF2, 0xE3, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x4D, 0x00, 0x6E, 0x00, 0x57, 0x01, 0xF6, 0xBC, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0x06, 0xFF, 0xE4, 0x00, 0x3D, 0x00, 0x58, 0x00, 0x48, 0x01, 0xFA, 0x2D, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x4D, 0x00, 0x6E, 0x00, 0x57, 0x01, 0xFD, 0xED, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0x06, 0xFF, 0xE4, 0x00, 0x3D, 0x00, 0x58, 0x00, 0x48, 0x02, 0x01, 0x0E, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0x07, 0xFF, 0xE6, 0x00, 0x4D, 0x00, 0x57, 0x00, 0x57, 0x02, 0x04, 0x7C, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0x06, 0xFF, 0xE4, 0x00, 0x3D, 0x00, 0x5C, 0x00, 0x48, 0x02, 0x07, 0xBF, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x4A, 0x00, 0x72, 0x00, 0x57, 0x02, 0x0B, 0x59, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0xFC, 0x00, 0x01, 0x00, 0x3D, 0x00, 0x77, 0x00, 0x48, 0x02, 0x0E, 0x25, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x00, 0x00, 0x01, 0x00, 0x56, 0x00, 0x56, 0x00, 0x57, 0x02, 0x11, 0xAF, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x00, 0x01, 0x00, 0x3D, 0x00, 0x5C, 0x00, 0x48, 0x02, 0x14, 0x69, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0xFC, 0x00, 0x01, 0x00, 0x25, 0x00, 0x6D, 0x00, 0x25, 0x02, 0x17, 0x50, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0xF7, 0x00, 0x01, 0x00, 0x20, 0x00, 0x58, 0x00, 0x1C, 0x02, 0x19, 0x97, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x02, 0x00, 0x01, 0x00, 0x23, 0x00, 0x65, 0x00, 0x25, 0x02, 0x1B, 0x65, // "Ī" (U+012A)
  0x01, 0x2B, 0xFF, 0xFD, 0x00, 0x01, 0x00, 0x1E, 0x00, 0x4F, 0x00, 0x1C, 0x02, 0x1D, 0x0D, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x02, 0x00, 0x01, 0x00, 0x23, 0x00, 0x6E, 0x00, 0x25, 0x02, 0x1E, 0x4B, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFF, 0xFD, 0x00, 0x01, 0x00, 0x1E, 0x00, 0x58, 0x00, 0x1C, 0x02, 0x20, 0x56, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0x06, 0xFF, 0xE6, 0x00, 0x1F, 0x00, 0x56, 0x00, 0x25, 0x02, 0x21, 0xED, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0x01, 0xFF, 0xE6, 0x00, 0x13, 0x00, 0x58, 0x00, 0x1C, 0x02, 0x23, 0xC8, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x06, 0x00, 0x01, 0x00, 0x1F, 0x00, 0x6E, 0x00, 0x25, 0x02, 0x25, 0x46, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x11, 0x00, 0x40, 0x00, 0x1C, 0x02, 0x26, 0xDF, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0x06, 0xFF, 0xEB, 0x00, 0x38, 0x00, 0x56, 0x00, 0x44, 0x02, 0x27, 0x81, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0x09, 0xFF, 0xE4, 0x00, 0x2E, 0x00, 0x58, 0x00, 0x38, 0x02, 0x2A, 0xC5, // "ĳ" (U+0133)
  0x01, 0x34, 0xFF, 0xF5, 0xFF, 0xEB, 0x00, 0x20, 0x00, 0x72, 0x00, 0x1E, 0x02, 0x2D, 0x88, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xF9, 0xFF, 0xE4, 0x00, 0x1F, 0x00, 0x5C, 0x00, 0x1C, 0x02, 0x30, 0x5B, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0x0C, 0xFF, 0xE6, 0x00, 0x46, 0x00, 0x56, 0x00, 0x47, 0x02, 0x32, 0xE0, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0x0A, 0xFF, 0xE6, 0x00, 0x3A, 0x00, 0x5C, 0x00, 0x3B, 0x02, 0x36, 0x08, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x3A, 0x00, 0x40, 0x00, 0x3B, 0x02, 0x39, 0x0D, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x3A, 0x00, 0x72, 0x00, 0x3E, 0x02, 0x3B, 0x26, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x08, 0x00, 0x01, 0x00, 0x1E, 0x00, 0x78, 0x00, 0x1C, 0x02, 0x3C, 0xEC, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0x0C, 0xFF, 0xE6, 0x00, 0x3A, 0x00, 0x56, 0x00, 0x3E, 0x02, 0x3E, 0xB4, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0x07, 0xFF, 0xE6, 0x00, 0x13, 0x00, 0x5C, 0x00, 0x1C, 0x02, 0x40, 0x61, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x3A, 0x00, 0x56, 0x00, 0x3E, 0x02, 0x41, 0xB7, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x21, 0x00, 0x5C, 0x00, 0x1C, 0x02, 0x43, 0x37, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x3A, 0x00, 0x56, 0x00, 0x3E, 0x02, 0x44, 0xD2, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x20, 0x00, 0x5C, 0x00, 0x1D, 0x02, 0x46, 0x37, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x00, 0x01, 0x00, 0x3A, 0x00, 0x56, 0x00, 0x3E, 0x02, 0x47, 0xC3, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x00, 0x00, 0x01, 0x00, 0x1C, 0x00, 0x5C, 0x00, 0x1C, 0x02, 0x49, 0x78, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x4B, 0x00, 0x72, 0x00, 0x57, 0x02, 0x4B, 0x1A, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x3D, 0x00, 0x5C, 0x00, 0x48, 0x02, 0x4E, 0xA9, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0x0C, 0xFF, 0xE6, 0x00, 0x4B, 0x00, 0x56, 0x00, 0x57, 0x02, 0x51, 0x35, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0x0A, 0xFF, 0xE6, 0x00, 0x3D, 0x00, 0x41, 0x00, 0x48, 0x02, 0x54, 0xB6, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x4B, 0x00, 0x72, 0x00, 0x57, 0x02, 0x57, 0x3A, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x3D, 0x00, 0x5C, 0x00, 0x48, 0x02, 0x5B, 0x01, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x00, 0x00, 0x01, 0x00, 0x42, 0x00, 0x56, 0x00, 0x4C, 0x02, 0x5D, 0xBF, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0x0C, 0xFF, 0xEB, 0x00, 0x4B, 0x00, 0x56, 0x00, 0x57, 0x02, 0x60, 0xAE, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0x0A, 0xFF, 0xE4, 0x00, 0x3D, 0x00, 0x41, 0x00, 0x48, 0x02, 0x64, 0x4C, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x54, 0x00, 0x65, 0x00, 0x5C, 0x02, 0x67, 0x10, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3F, 0x00, 0x4F, 0x00, 0x47, 0x02, 0x6A, 0x6A, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x54, 0x00, 0x6E, 0x00, 0x5C, 0x02, 0x6C, 0xD4, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3F, 0x00, 0x58, 0x00, 0x47, 0x02, 0x70, 0x94, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x07, 0xFF, 0xFF, 0x00, 0x54, 0x00, 0x72, 0x00, 0x5C, 0x02, 0x73, 0x65, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3F, 0x00, 0x5C, 0x00, 0x47, 0x02, 0x77, 0x50, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x07, 0x00, 0x00, 0x00, 0x66, 0x00, 0x57, 0x00, 0x6E, 0x02, 0x7A, 0x4E, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x6B, 0x00, 0x41, 0x00, 0x73, 0x02, 0x7D, 0xDF, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x45, 0x00, 0x72, 0x00, 0x48, 0x02, 0x81, 0x92, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x5C, 0x00, 0x2F, 0x02, 0x84, 0x88, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0x0C, 0xFF, 0xE6, 0x00, 0x45, 0x00, 0x56, 0x00, 0x48, 0x02, 0x86, 0x50, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0x07, 0xFF, 0xE6, 0x00, 0x2D, 0x00, 0x41, 0x00, 0x2F, 0x02, 0x89, 0x3C, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x0C, 0x00, 0x01, 0x00, 0x45, 0x00, 0x72, 0x00, 0x48, 0x02, 0x8B, 0x1B, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x09, 0x00, 0x01, 0x00, 0x2D, 0x00, 0x5C, 0x00, 0x2F, 0x02, 0x8E, 0x40, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3B, 0x00, 0x72, 0x00, 0x42, 0x02, 0x90, 0x4B, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x32, 0x00, 0x5C, 0x00, 0x38, 0x02, 0x93, 0x24, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3B, 0x00, 0x72, 0x00, 0x42, 0x02, 0x95, 0x64, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x32, 0x00, 0x5C, 0x00, 0x38, 0x02, 0x98, 0x6F, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0x06, 0xFF, 0xE4, 0x00, 0x3B, 0x00, 0x57, 0x00, 0x42, 0x02, 0x9A, 0xDC, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0x05, 0xFF, 0xE4, 0x00, 0x32, 0x00, 0x41, 0x00, 0x38, 0x02, 0x9D, 0xE7, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x3B, 0x00, 0x72, 0x00, 0x42, 0x02, 0xA0, 0x55, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x05, 0xFF, 0xFF, 0x00, 0x32, 0x00, 0x5C, 0x00, 0x38, 0x02, 0xA3, 0x5E, // "š" (U+0161)
  0x01, 0x62, 0x00, 0x00, 0xFF, 0xE4, 0x00, 0x3E, 0x00, 0x56, 0x00, 0x40, 0x02, 0xA5, 0xC6, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0x01, 0xFF, 0xE4, 0x00, 0x25, 0x00, 0x50, 0x00, 0x29, 0x02, 0xA8, 0x26, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x00, 0x00, 0x01, 0x00, 0x3E, 0x00, 0x72, 0x00, 0x40, 0x02, 0xAA, 0x71, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x32, 0x00, 0x5C, 0x00, 0x29, 0x02, 0xAC, 0xD0, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x00, 0x00, 0x01, 0x00, 0x3E, 0x00, 0x56, 0x00, 0x40, 0x02, 0xAE, 0xE3, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x25, 0x00, 0x50, 0x00, 0x29, 0x02, 0xB0, 0xA2, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x0B, 0xFF, 0xFF, 0x00, 0x4B, 0x00, 0x6D, 0x00, 0x57, 0x02, 0xB2, 0x55, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x09, 0xFF, 0xFF, 0x00, 0x3C, 0x00, 0x58, 0x00, 0x48, 0x02, 0xB5, 0x85, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x0B, 0xFF, 0xFF, 0x00, 0x4B, 0x00, 0x65, 0x00, 0x57, 0x02, 0xB8, 0x19, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x09, 0xFF, 0xFF, 0x00, 0x3C, 0x00, 0x4F, 0x00, 0x48, 0x02, 0xBA, 0xD4, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x0B, 0xFF, 0xFF, 0x00, 0x4B, 0x00, 0x6E, 0x00, 0x57, 0x02, 0xBC, 0xF7, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x09, 0xFF, 0xFF, 0x00, 0x3C, 0x00, 0x58, 0x00, 0x48, 0x02, 0xC0, 0x1F, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x0B, 0xFF, 0xFF, 0x00, 0x4B, 0x00, 0x78, 0x00, 0x57, 0x02, 0xC2, 0xA7, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x09, 0xFF, 0xFF, 0x00, 0x3C, 0x00, 0x62, 0x00, 0x48, 0x02, 0xC6, 0x14, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x0B, 0xFF, 0xFF, 0x00, 0x4B, 0x00, 0x72, 0x00, 0x57, 0x02, 0xC8, 0xE9, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x09, 0xFF, 0xFF, 0x00, 0x3D, 0x00, 0x5C, 0x00, 0x48, 0x02, 0xCC, 0x3A, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0x0B, 0xFF, 0xE6, 0x00, 0x4B, 0x00, 0x56, 0x00, 0x57, 0x02, 0xCF, 0x09, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0x09, 0xFF, 0xE6, 0x00, 0x3E, 0x00, 0x40, 0x00, 0x48, 0x02, 0xD2, 0x24, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x02, 0x00, 0x01, 0x00, 0x69, 0x00, 0x72, 0x00, 0x6C, 0x02, 0xD4, 0xCE, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x00, 0x01, 0x00, 0x56, 0x00, 0x5C, 0x00, 0x58, 0x02, 0xDA, 0x76, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x00, 0x00, 0x01, 0x00, 0x40, 0x00, 0x72, 0x00, 0x40, 0x02, 0xDE, 0xA1, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0x00, 0xFF, 0xE4, 0x00, 0x38, 0x00, 0x5C, 0x00, 0x38, 0x02, 0xE1, 0xB4, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x00, 0x00, 0x01, 0x00, 0x40, 0x00, 0x6D, 0x00, 0x40, 0x02, 0xE5, 0x05, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x04, 0x00, 0x01, 0x00, 0x40, 0x00, 0x72, 0x00, 0x45, 0x02, 0xE7, 0xD1, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x04, 0x00, 0x01, 0x00, 0x32, 0x00, 0x5C, 0x00, 0x38, 0x02, 0xEA, 0x0F, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x04, 0x00, 0x01, 0x00, 0x40, 0x00, 0x6E, 0x00, 0x45, 0x02, 0xEB, 0xD5, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x04, 0x00, 0x01, 0x00, 0x32, 0x00, 0x58, 0x00, 0x38, 0x02, 0xED, 0xDE, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x04, 0x00, 0x01, 0x00, 0x40, 0x00, 0x72, 0x00, 0x45, 0x02, 0xEF, 0x71, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x04, 0x00, 0x01, 0x00, 0x32, 0x00, 0x5C, 0x00, 0x38, 0x02, 0xF1, 0xE4, // "ž" (U+017E)
  0x01, 0x7F, 0x00, 0x0A, 0x00, 0x01, 0x00, 0x28, 0x00, 0x5C, 0x00, 0x25, 0x02, 0xF3, 0xD9, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x04, 0x00, 0x01, 0x00, 0x58, 0x00, 0x57, 0x00, 0x5D, 0x02, 0xF5, 0x8C, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0x0A, 0xFF, 0xE4, 0x00, 0x3D, 0x00, 0x40, 0x00, 0x48, 0x02, 0xF8, 0xD1, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0xFF, 0xFF, 0x00, 0x46, 0x00, 0x40, 0x00, 0x4B, 0x02, 0xFB, 0x8A, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x04, 0x00, 0x1E, 0x00, 0x37, 0x00, 0x24, 0x00, 0x3C, 0x02, 0xFD, 0xEB, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x04, 0x00, 0x1E, 0x00, 0x73, 0x00, 0x24, 0x00, 0x78, 0x02, 0xFE, 0x09, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x04, 0xFF, 0xFF, 0x00, 0x41, 0x00, 0x57, 0x00, 0x45, 0x02, 0xFE, 0x2A, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0x0C, 0xFF, 0xF5, 0x00, 0x3E, 0x00, 0x62, 0x00, 0x45, 0x03, 0x00, 0x72, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x02, 0x00, 0x39, 0x00, 0x10, 0x00, 0x56, 0x00, 0x12, 0x03, 0x03, 0xBA, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x01, 0x00, 0x39, 0x00, 0x0F, 0x00, 0x56, 0x00, 0x12, 0x03, 0x04, 0x1A, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0x04, 0xFF, 0xF1, 0x00, 0x12, 0x00, 0x0E, 0x00, 0x1B, 0x03, 0x04, 0x7B, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x02, 0x00, 0x39, 0x00, 0x10, 0x00, 0x56, 0x00, 0x12, 0x03, 0x04, 0xDC, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x02, 0x00, 0x39, 0x00, 0x23, 0x00, 0x56, 0x00, 0x25, 0x03, 0x05, 0x3F, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x01, 0x00, 0x39, 0x00, 0x23, 0x00, 0x56, 0x00, 0x25, 0x03, 0x06, 0x08, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0x04, 0xFF, 0xF1, 0x00, 0x25, 0x00, 0x0E, 0x00, 0x2E, 0x03, 0x06, 0xD6, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x01, 0x00, 0x39, 0x00, 0x23, 0x00, 0x56, 0x00, 0x25, 0x03, 0x07, 0x9E, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x07, 0x00, 0x01, 0x00, 0x33, 0x00, 0x5C, 0x00, 0x3B, 0x03, 0x08, 0x6E, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x06, 0x00, 0x01, 0x00, 0x34, 0x00, 0x5C, 0x00, 0x3B, 0x03, 0x0A, 0x53, // "‡" (U+2021)
  0x20, 0x22, 0x00, 0x0C, 0x00, 0x21, 0x00, 0x20, 0x00, 0x38, 0x00, 0x2D, 0x03, 0x0C, 0x67, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x09, 0xFF, 0xFF, 0x00, 0x4E, 0x00, 0x0B, 0x00, 0x58, 0x03, 0x0C, 0xCA, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x06, 0xFF, 0xFF, 0x00, 0x83, 0x00, 0x57, 0x00, 0x8A, 0x03, 0x0D, 0x73, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x04, 0x00, 0x09, 0x00, 0x1B, 0x00, 0x39, 0x00, 0x20, 0x03, 0x13, 0xDD, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x04, 0x00, 0x09, 0x00, 0x1B, 0x00, 0x39, 0x00, 0x20, 0x03, 0x14, 0xB4, // "›" (U+203A)
  0x20, 0x44, 0xFF, 0xEC, 0x00, 0x01, 0x00, 0x22, 0x00, 0x56, 0x00, 0x0F, 0x03, 0x15, 0x8B, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x4D, 0x00, 0x56, 0x00, 0x58, 0x03, 0x17, 0x50, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x04, 0x00, 0x00, 0x00, 0x75, 0x00, 0x56, 0x00, 0x79, 0x03, 0x19, 0xBB, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x37, 0x00, 0x5C, 0x00, 0x41, 0x03, 0x1E, 0xEA, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00, 0x36, 0x00, 0x5C, 0x00, 0x41, 0x03, 0x21, 0xCD, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x08, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x61, 0x05, // "a (U+0022 U+0061)
  0x00, 0x22, 0x00, 0x63, 0x07, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x07, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x07, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x67, 0x04, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0x6D, 0x04, // "m (U+0022 U+006D)
  0x00, 0x22, 0x00, 0x6E, 0x04, // "n (U+0022 U+006E)
  0x00, 0x22, 0x00, 0x6F, 0x07, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x70, 0x04, // "p (U+0022 U+0070)
  0x00, 0x22, 0x00, 0x71, 0x07, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0x72, 0x04, // "r (U+0022 U+0072)
  0x00, 0x22, 0x00, 0x73, 0x04, // "s (U+0022 U+0073)
  0x00, 0x22, 0x00, 0x75, 0x04, // "u (U+0022 U+0075)
  0x00, 0x22, 0x00, 0xC0, 0x08, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x08, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x08, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x08, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x08, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x08, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x0A, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x00, 0xE0, 0x07, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE1, 0x05, // "á (U+0022 U+00E1)
  0x00, 0x22, 0x00, 0xE2, 0x05, // "â (U+0022 U+00E2)
  0x00, 0x22, 0x00, 0xE3, 0x05, // "ã (U+0022 U+00E3)
  0x00, 0x22, 0x00, 0xE4, 0x05, // "ä (U+0022 U+00E4)
  0x00, 0x22, 0x00, 0xE5, 0x05, // "å (U+0022 U+00E5)
  0x00, 0x22, 0x00, 0xE6, 0x05, // "æ (U+0022 U+00E6)
  0x00, 0x22, 0x00, 0xE7, 0x07, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x07, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x07, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x07, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x07, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x07, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x07, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x07, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x07, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x07, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x07, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x00, 0xF9, 0x04, // "ù (U+0022 U+00F9)
  0x00, 0x22, 0x00, 0xFA, 0x04, // "ú (U+0022 U+00FA)
  0x00, 0x22, 0x00, 0xFB, 0x04, // "û (U+0022 U+00FB)
  0x00, 0x22, 0x00, 0xFC, 0x04, // "ü (U+0022 U+00FC)
  0x00, 0x22, 0x01, 0x00, 0x08, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x01, 0x05, // "ā (U+0022 U+0101)
  0x00, 0x22, 0x01, 0x02, 0x08, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x03, 0x05, // "ă (U+0022 U+0103)
  0x00, 0x22, 0x01, 0x04, 0x08, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x05, 0x05, // "ą (U+0022 U+0105)
  0x00, 0x22, 0x01, 0x07, 0x07, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x07, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x07, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x07, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x07, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x07, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x07, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x07, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x07, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x07, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x07, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x1D, 0x04, // "ĝ (U+0022 U+011D)
  0x00, 0x22, 0x01, 0x1F, 0x04, // "ğ (U+0022 U+011F)
  0x00, 0x22, 0x01, 0x21, 0x04, // "ġ (U+0022 U+0121)
  0x00, 0x22, 0x01, 0x23, 0x04, // "ģ (U+0022 U+0123)
  0x00, 0x22, 0x01, 0x38, 0x04, // "ĸ (U+0022 U+0138)
  0x00, 0x22, 0x01, 0x44, 0x04, // "ń (U+0022 U+0144)
  0x00, 0x22, 0x01, 0x46, 0x04, // "ņ (U+0022 U+0146)
  0x00, 0x22, 0x01, 0x4B, 0x04, // "ŋ (U+0022 U+014B)
  0x00, 0x22, 0x01, 0x4D, 0x07, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x07, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x07, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x07, // "œ (U+0022 U+0153)
  0x00, 0x22, 0x01, 0x55, 0x04, // "ŕ (U+0022 U+0155)
  0x00, 0x22, 0x01, 0x57, 0x04, // "ŗ (U+0022 U+0157)
  0x00, 0x22, 0x01, 0x5B, 0x04, // "ś (U+0022 U+015B)
  0x00, 0x22, 0x01, 0x5F, 0x04, // "ş (U+0022 U+015F)
  0x00, 0x22, 0x01, 0x69, 0x04, // "ũ (U+0022 U+0169)
  0x00, 0x22, 0x01, 0x6B, 0x04, // "ū (U+0022 U+016B)
  0x00, 0x22, 0x01, 0x6D, 0x04, // "ŭ (U+0022 U+016D)
  0x00, 0x22, 0x01, 0x6F, 0x04, // "ů (U+0022 U+016F)
  0x00, 0x22, 0x01, 0x71, 0x04, // "ű (U+0022 U+0171)
  0x00, 0x22, 0x01, 0x73, 0x04, // "ų (U+0022 U+0173)
  0x00, 0x22, 0x03, 0xBC, 0x02, // "μ (U+0022 U+03BC)
  0x00, 0x26, 0x00, 0x54, 0x07, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x56, 0x02, // &V (U+0026 U+0056)
  0x00, 0x26, 0x00, 0x57, 0x02, // &W (U+0026 U+0057)
  0x00, 0x26, 0x00, 0x59, 0x04, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x04, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x62, 0x07, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x07, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x07, // &Ŧ (U+0026 U+0166)
  0x00, 0x26, 0x01, 0x74, 0x02, // &Ŵ (U+0026 U+0174)
  0x00, 0x26, 0x01, 0x76, 0x04, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x04, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x08, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x61, 0x05, // 'a (U+0027 U+0061)
  0x00, 0x27, 0x00, 0x63, 0x07, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x07, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x07, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x67, 0x04, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0x6D, 0x04, // 'm (U+0027 U+006D)
  0x00, 0x27, 0x00, 0x6E, 0x04, // 'n (U+0027 U+006E)
  0x00, 0x27, 0x00, 0x6F, 0x07, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x70, 0x04, // 'p (U+0027 U+0070)
  0x00, 0x27, 0x00, 0x71, 0x07, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0x72, 0x04, // 'r (U+0027 U+0072)
  0x00, 0x27, 0x00, 0x73, 0x04, // 's (U+0027 U+0073)
  0x00, 0x27, 0x00, 0x75, 0x04, // 'u (U+0027 U+0075)
  0x00, 0x27, 0x00, 0xC0, 0x08, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x08, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x08, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x08, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x08, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x08, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x0A, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x00, 0xE0, 0x07, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE1, 0x05, // 'á (U+0027 U+00E1)
  0x00, 0x27, 0x00, 0xE2, 0x05, // 'â (U+0027 U+00E2)
  0x00, 0x27, 0x00, 0xE3, 0x05, // 'ã (U+0027 U+00E3)
  0x00, 0x27, 0x00, 0xE4, 0x05, // 'ä (U+0027 U+00E4)
  0x00, 0x27, 0x00, 0xE5, 0x05, // 'å (U+0027 U+00E5)
  0x00, 0x27, 0x00, 0xE6, 0x05, // 'æ (U+0027 U+00E6)
  0x00, 0x27, 0x00, 0xE7, 0x07, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x07, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x07, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x07, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x07, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x07, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x07, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x07, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x07, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x07, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x07, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x00, 0xF9, 0x04, // 'ù (U+0027 U+00F9)
  0x00, 0x27, 0x00, 0xFA, 0x04, // 'ú (U+0027 U+00FA)
  0x00, 0x27, 0x00, 0xFB, 0x04, // 'û (U+0027 U+00FB)
  0x00, 0x27, 0x00, 0xFC, 0x04, // 'ü (U+0027 U+00FC)
  0x00, 0x27, 0x01, 0x00, 0x08, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x01, 0x05, // 'ā (U+0027 U+0101)
  0x00, 0x27, 0x01, 0x02, 0x08, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x03, 0x05, // 'ă (U+0027 U+0103)
  0x00, 0x27, 0x01, 0x04, 0x08, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x05, 0x05, // 'ą (U+0027 U+0105)
  0x00, 0x27, 0x01, 0x07, 0x07, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x07, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x07, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x07, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x07, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x07, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x07, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x07, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x07, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x07, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x07, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x1D, 0x04, // 'ĝ (U+0027 U+011D)
  0x00, 0x27, 0x01, 0x1F, 0x04, // 'ğ (U+0027 U+011F)
  0x00, 0x27, 0x01, 0x21, 0x04, // 'ġ (U+0027 U+0121)
  0x00, 0x27, 0x01, 0x23, 0x04, // 'ģ (U+0027 U+0123)
  0x00, 0x27, 0x01, 0x38, 0x04, // 'ĸ (U+0027 U+0138)
  0x00, 0x27, 0x01, 0x44, 0x04, // 'ń (U+0027 U+0144)
  0x00, 0x27, 0x01, 0x46, 0x04, // 'ņ (U+0027 U+0146)
  0x00, 0x27, 0x01, 0x4B, 0x04, // 'ŋ (U+0027 U+014B)
  0x00, 0x27, 0x01, 0x4D, 0x07, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x07, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x07, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x07, // 'œ (U+0027 U+0153)
  0x00, 0x27, 0x01, 0x55, 0x04, // 'ŕ (U+0027 U+0155)
  0x00, 0x27, 0x01, 0x57, 0x04, // 'ŗ (U+0027 U+0157)
  0x00, 0x27, 0x01, 0x5B, 0x04, // 'ś (U+0027 U+015B)
  0x00, 0x27, 0x01, 0x5F, 0x04, // 'ş (U+0027 U+015F)
  0x00, 0x27, 0x01, 0x69, 0x04, // 'ũ (U+0027 U+0169)
  0x00, 0x27, 0x01, 0x6B, 0x04, // 'ū (U+0027 U+016B)
  0x00, 0x27, 0x01, 0x6D, 0x04, // 'ŭ (U+0027 U+016D)
  0x00, 0x27, 0x01, 0x6F, 0x04, // 'ů (U+0027 U+016F)
  0x00, 0x27, 0x01, 0x71, 0x04, // 'ű (U+0027 U+0171)
  0x00, 0x27, 0x01, 0x73, 0x04, // 'ų (U+0027 U+0173)
  0x00, 0x27, 0x03, 0xBC, 0x02, // 'μ (U+0027 U+03BC)
  0x00, 0x2C, 0x00, 0x43, 0x06, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x06, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x06, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x06, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x08, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x55, 0x02, // ,U (U+002C U+0055)
  0x00, 0x2C, 0x00, 0x56, 0x07, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x07, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x07, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x06, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x06, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x06, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x06, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x06, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x06, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x06, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xD9, 0x02, // ,Ù (U+002C U+00D9)
  0x00, 0x2C, 0x00, 0xDA, 0x02, // ,Ú (U+002C U+00DA)
  0x00, 0x2C, 0x00, 0xDB, 0x02, // ,Û (U+002C U+00DB)
  0x00, 0x2C, 0x00, 0xDC, 0x02, // ,Ü (U+002C U+00DC)
  0x00, 0x2C, 0x00, 0xDD, 0x07, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x06, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x06, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x06, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x06, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x06, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x06, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x06, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x06, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x06, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x06, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x06, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x06, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x08, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x08, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x08, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x68, 0x02, // ,Ũ (U+002C U+0168)
  0x00, 0x2C, 0x01, 0x6A, 0x02, // ,Ū (U+002C U+016A)
  0x00, 0x2C, 0x01, 0x6C, 0x02, // ,Ŭ (U+002C U+016C)
  0x00, 0x2C, 0x01, 0x6E, 0x02, // ,Ů (U+002C U+016E)
  0x00, 0x2C, 0x01, 0x70, 0x02, // ,Ű (U+002C U+0170)
  0x00, 0x2C, 0x01, 0x72, 0x02, // ,Ų (U+002C U+0172)
  0x00, 0x2C, 0x01, 0x74, 0x07, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x07, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x07, // ,Ÿ (U+002C U+0178)
  0x00, 0x2D, 0x00, 0x54, 0x05, // -T (U+002D U+0054)
  0x00, 0x2D, 0x01, 0x62, 0x05, // -Ţ (U+002D U+0162)
  0x00, 0x2D, 0x01, 0x64, 0x05, // -Ť (U+002D U+0164)
  0x00, 0x2D, 0x01, 0x66, 0x05, // -Ŧ (U+002D U+0166)
  0x00, 0x2E, 0x00, 0x43, 0x06, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x06, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x06, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x06, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x08, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x55, 0x02, // .U (U+002E U+0055)
  0x00, 0x2E, 0x00, 0x56, 0x07, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x07, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x07, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x06, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x06, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x06, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x06, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x06, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x06, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x06, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xD9, 0x02, // .Ù (U+002E U+00D9)
  0x00, 0x2E, 0x00, 0xDA, 0x02, // .Ú (U+002E U+00DA)
  0x00, 0x2E, 0x00, 0xDB, 0x02, // .Û (U+002E U+00DB)
  0x00, 0x2E, 0x00, 0xDC, 0x02, // .Ü (U+002E U+00DC)
  0x00, 0x2E, 0x00, 0xDD, 0x07, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x06, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x06, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x06, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x06, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x06, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x06, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x06, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x06, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x06, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x06, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x06, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x06, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x08, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x08, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x08, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x68, 0x02, // .Ũ (U+002E U+0168)
  0x00, 0x2E, 0x01, 0x6A, 0x02, // .Ū (U+002E U+016A)
  0x00, 0x2E, 0x01, 0x6C, 0x02, // .Ŭ (U+002E U+016C)
  0x00, 0x2E, 0x01, 0x6E, 0x02, // .Ů (U+002E U+016E)
  0x00, 0x2E, 0x01, 0x70, 0x02, // .Ű (U+002E U+0170)
  0x00, 0x2E, 0x01, 0x72, 0x02, // .Ų (U+002E U+0172)
  0x00, 0x2E, 0x01, 0x74, 0x07, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x07, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x07, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x1C, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x1C, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x1C, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x1C, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x1C, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x1C, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x1C, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x1C, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x1C, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x1C, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x08, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x08, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x43, 0x02, // AC (U+0041 U+0043)
  0x00, 0x41, 0x00, 0x47, 0x02, // AG (U+0041 U+0047)
  0x00, 0x41, 0x00, 0x4F, 0x02, // AO (U+0041 U+004F)
  0x00, 0x41, 0x00, 0x51, 0x02, // AQ (U+0041 U+0051)
  0x00, 0x41, 0x00, 0x54, 0x08, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x56, 0x05, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x05, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x07, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xC7, 0x02, // AÇ (U+0041 U+00C7)
  0x00, 0x41, 0x00, 0xD2, 0x02, // AÒ (U+0041 U+00D2)
  0x00, 0x41, 0x00, 0xD3, 0x02, // AÓ (U+0041 U+00D3)
  0x00, 0x41, 0x00, 0xD4, 0x02, // AÔ (U+0041 U+00D4)
  0x00, 0x41, 0x00, 0xD5, 0x02, // AÕ (U+0041 U+00D5)
  0x00, 0x41, 0x00, 0xD6, 0x02, // AÖ (U+0041 U+00D6)
  0x00, 0x41, 0x00, 0xD8, 0x02, // AØ (U+0041 U+00D8)
  0x00, 0x41, 0x00, 0xDD, 0x07, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x06, 0x02, // AĆ (U+0041 U+0106)
  0x00, 0x41, 0x01, 0x08, 0x02, // AĈ (U+0041 U+0108)
  0x00, 0x41, 0x01, 0x0A, 0x02, // AĊ (U+0041 U+010A)
  0x00, 0x41, 0x01, 0x0C, 0x02, // AČ (U+0041 U+010C)
  0x00, 0x41, 0x01, 0x1C, 0x02, // AĜ (U+0041 U+011C)
  0x00, 0x41, 0x01, 0x1E, 0x02, // AĞ (U+0041 U+011E)
  0x00, 0x41, 0x01, 0x20, 0x02, // AĠ (U+0041 U+0120)
  0x00, 0x41, 0x01, 0x22, 0x02, // AĢ (U+0041 U+0122)
  0x00, 0x41, 0x01, 0x4C, 0x02, // AŌ (U+0041 U+014C)
  0x00, 0x41, 0x01, 0x4E, 0x02, // AŎ (U+0041 U+014E)
  0x00, 0x41, 0x01, 0x50, 0x02, // AŐ (U+0041 U+0150)
  0x00, 0x41, 0x01, 0x52, 0x02, // AŒ (U+0041 U+0152)
  0x00, 0x41, 0x01, 0x62, 0x08, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x08, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x08, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x74, 0x05, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x76, 0x07, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x07, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x19, 0x08, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x08, // A” (U+0041 U+201D)
  0x00, 0x42, 0x00, 0x2C, 0x01, // B, (U+0042 U+002C)
  0x00, 0x42, 0x00, 0x2E, 0x01, // B. (U+0042 U+002E)
  0x00, 0x42, 0x20, 0x1A, 0x01, // B‚ (U+0042 U+201A)
  0x00, 0x42, 0x20, 0x1E, 0x01, // B„ (U+0042 U+201E)
  0x00, 0x42, 0x20, 0x26, 0x01, // B… (U+0042 U+2026)
  0x00, 0x43, 0x00, 0x43, 0x02, // CC (U+0043 U+0043)
  0x00, 0x43, 0x00, 0x47, 0x02, // CG (U+0043 U+0047)
  0x00, 0x43, 0x00, 0x4F, 0x02, // CO (U+0043 U+004F)
  0x00, 0x43, 0x00, 0x51, 0x02, // CQ (U+0043 U+0051)
  0x00, 0x43, 0x00, 0xAB, 0x02, // C« (U+0043 U+00AB)
  0x00, 0x43, 0x00, 0xC7, 0x02, // CÇ (U+0043 U+00C7)
  0x00, 0x43, 0x00, 0xD2, 0x02, // CÒ (U+0043 U+00D2)
  0x00, 0x43, 0x00, 0xD3, 0x02, // CÓ (U+0043 U+00D3)
  0x00, 0x43, 0x00, 0xD4, 0x02, // CÔ (U+0043 U+00D4)
  0x00, 0x43, 0x00, 0xD5, 0x02, // CÕ (U+0043 U+00D5)
  0x00, 0x43, 0x00, 0xD6, 0x02, // CÖ (U+0043 U+00D6)
  0x00, 0x43, 0x00, 0xD8, 0x02, // CØ (U+0043 U+00D8)
  0x00, 0x43, 0x01, 0x06, 0x02, // CĆ (U+0043 U+0106)
  0x00, 0x43, 0x01, 0x08, 0x02, // CĈ (U+0043 U+0108)
  0x00, 0x43, 0x01, 0x0A, 0x02, // CĊ (U+0043 U+010A)
  0x00, 0x43, 0x01, 0x0C, 0x02, // CČ (U+0043 U+010C)
  0x00, 0x43, 0x01, 0x1C, 0x02, // CĜ (U+0043 U+011C)
  0x00, 0x43, 0x01, 0x1E, 0x02, // CĞ (U+0043 U+011E)
  0x00, 0x43, 0x01, 0x20, 0x02, // CĠ (U+0043 U+0120)
  0x00, 0x43, 0x01, 0x22, 0x02, // CĢ (U+0043 U+0122)
  0x00, 0x43, 0x01, 0x4C, 0x02, // CŌ (U+0043 U+014C)
  0x00, 0x43, 0x01, 0x4E, 0x02, // CŎ (U+0043 U+014E)
  0x00, 0x43, 0x01, 0x50, 0x02, // CŐ (U+0043 U+0150)
  0x00, 0x43, 0x01, 0x52, 0x02, // CŒ (U+0043 U+0152)
  0x00, 0x43, 0x20, 0x39, 0x02, // C‹ (U+0043 U+2039)
  0x00, 0x44, 0x00, 0x2C, 0x05, // D, (U+0044 U+002C)
  0x00, 0x44, 0x00, 0x2E, 0x05, // D. (U+0044 U+002E)
  0x00, 0x44, 0x00, 0x41, 0x02, // DA (U+0044 U+0041)
  0x00, 0x44, 0x00, 0x54, 0x04, // DT (U+0044 U+0054)
  0x00, 0x44, 0x00, 0x56, 0x01, // DV (U+0044 U+0056)
  0x00, 0x44, 0x00, 0x57, 0x01, // DW (U+0044 U+0057)
  0x00, 0x44, 0x00, 0x58, 0x02, // DX (U+0044 U+0058)
  0x00, 0x44, 0x00, 0x59, 0x01, // DY (U+0044 U+0059)
  0x00, 0x44, 0x00, 0x5A, 0x01, // DZ (U+0044 U+005A)
  0x00, 0x44, 0x00, 0xC0, 0x02, // DÀ (U+0044 U+00C0)
  0x00, 0x44, 0x00, 0xC1, 0x02, // DÁ (U+0044 U+00C1)
  0x00, 0x44, 0x00, 0xC2, 0x02, // DÂ (U+0044 U+00C2)
  0x00, 0x44, 0x00, 0xC3, 0x02, // DÃ (U+0044 U+00C3)
  0x00, 0x44, 0x00, 0xC4, 0x02, // DÄ (U+0044 U+00C4)
  0x00, 0x44, 0x00, 0xC5, 0x02, // DÅ (U+0044 U+00C5)
  0x00, 0x44, 0x00, 0xDD, 0x01, // DÝ (U+0044 U+00DD)
  0x00, 0x44, 0x01, 0x00, 0x02, // DĀ (U+0044 U+0100)
  0x00, 0x44, 0x01, 0x02, 0x02, // DĂ (U+0044 U+0102)
  0x00, 0x44, 0x01, 0x04, 0x02, // DĄ (U+0044 U+0104)
  0x00, 0x44, 0x01, 0x62, 0x04, // DŢ (U+0044 U+0162)
  0x00, 0x44, 0x01, 0x64, 0x04, // DŤ (U+0044 U+0164)
  0x00, 0x44, 0x01, 0x66, 0x04, // DŦ (U+0044 U+0166)
  0x00, 0x44, 0x01, 0x74, 0x01, // DŴ (U+0044 U+0174)
  0x00, 0x44, 0x01, 0x76, 0x01, // DŶ (U+0044 U+0176)
  0x00, 0x44, 0x01, 0x78, 0x01, // DŸ (U+0044 U+0178)
  0x00, 0x44, 0x01, 0x79, 0x01, // DŹ (U+0044 U+0179)
  0x00, 0x44, 0x01, 0x7B, 0x01, // DŻ (U+0044 U+017B)
  0x00, 0x44, 0x01, 0x7D, 0x01, // DŽ (U+0044 U+017D)
  0x00, 0x44, 0x20, 0x1A, 0x05, // D‚ (U+0044 U+201A)
  0x00, 0x44, 0x20, 0x1E, 0x05, // D„ (U+0044 U+201E)
  0x00, 0x44, 0x20, 0x26, 0x05, // D… (U+0044 U+2026)
  0x00, 0x46, 0x00, 0x2C, 0x07, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x07, // F. (U+0046 U+002E)
  0x00, 0x46, 0x00, 0x41, 0x02, // FA (U+0046 U+0041)
  0x00, 0x46, 0x00, 0xC0, 0x02, // FÀ (U+0046 U+00C0)
  0x00, 0x46, 0x00, 0xC1, 0x02, // FÁ (U+0046 U+00C1)
  0x00, 0x46, 0x00, 0xC2, 0x02, // FÂ (U+0046 U+00C2)
  0x00, 0x46, 0x00, 0xC3, 0x02, // FÃ (U+0046 U+00C3)
  0x00, 0x46, 0x00, 0xC4, 0x02, // FÄ (U+0046 U+00C4)
  0x00, 0x46, 0x00, 0xC5, 0x02, // FÅ (U+0046 U+00C5)
  0x00, 0x46, 0x01, 0x00, 0x02, // FĀ (U+0046 U+0100)
  0x00, 0x46, 0x01, 0x02, 0x02, // FĂ (U+0046 U+0102)
  0x00, 0x46, 0x01, 0x04, 0x02, // FĄ (U+0046 U+0104)
  0x00, 0x46, 0x20, 0x1A, 0x07, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x07, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x07, // F… (U+0046 U+2026)
  0x00, 0x4B, 0x00, 0x43, 0x02, // KC (U+004B U+0043)
  0x00, 0x4B, 0x00, 0x47, 0x02, // KG (U+004B U+0047)
  0x00, 0x4B, 0x00, 0x4F, 0x02, // KO (U+004B U+004F)
  0x00, 0x4B, 0x00, 0x51, 0x02, // KQ (U+004B U+0051)
  0x00, 0x4B, 0x00, 0xAB, 0x02, // K« (U+004B U+00AB)
  0x00, 0x4B, 0x00, 0xC7, 0x02, // KÇ (U+004B U+00C7)
  0x00, 0x4B, 0x00, 0xD2, 0x02, // KÒ (U+004B U+00D2)
  0x00, 0x4B, 0x00, 0xD3, 0x02, // KÓ (U+004B U+00D3)
  0x00, 0x4B, 0x00, 0xD4, 0x02, // KÔ (U+004B U+00D4)
  0x00, 0x4B, 0x00, 0xD5, 0x02, // KÕ (U+004B U+00D5)
  0x00, 0x4B, 0x00, 0xD6, 0x02, // KÖ (U+004B U+00D6)
  0x00, 0x4B, 0x00, 0xD8, 0x02, // KØ (U+004B U+00D8)
  0x00, 0x4B, 0x01, 0x06, 0x02, // KĆ (U+004B U+0106)
  0x00, 0x4B, 0x01, 0x08, 0x02, // KĈ (U+004B U+0108)
  0x00, 0x4B, 0x01, 0x0A, 0x02, // KĊ (U+004B U+010A)
  0x00, 0x4B, 0x01, 0x0C, 0x02, // KČ (U+004B U+010C)
  0x00, 0x4B, 0x01, 0x1C, 0x02, // KĜ (U+004B U+011C)
  0x00, 0x4B, 0x01, 0x1E, 0x02, // KĞ (U+004B U+011E)
  0x00, 0x4B, 0x01, 0x20, 0x02, // KĠ (U+004B U+0120)
  0x00, 0x4B, 0x01, 0x22, 0x02, // KĢ (U+004B U+0122)
  0x00, 0x4B, 0x01, 0x4C, 0x02, // KŌ (U+004B U+014C)
  0x00, 0x4B, 0x01, 0x4E, 0x02, // KŎ (U+004B U+014E)
  0x00, 0x4B, 0x01, 0x50, 0x02, // KŐ (U+004B U+0150)
  0x00, 0x4B, 0x01, 0x52, 0x02, // KŒ (U+004B U+0152)
  0x00, 0x4B, 0x20, 0x39, 0x02, // K‹ (U+004B U+2039)
  0x00, 0x4C, 0x00, 0x22, 0x0A, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x0A, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x43, 0x02, // LC (U+004C U+0043)
  0x00, 0x4C, 0x00, 0x47, 0x02, // LG (U+004C U+0047)
  0x00, 0x4C, 0x00, 0x4F, 0x02, // LO (U+004C U+004F)
  0x00, 0x4C, 0x00, 0x51, 0x02, // LQ (U+004C U+0051)
  0x00, 0x4C, 0x00, 0x54, 0x02, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x55, 0x01, // LU (U+004C U+0055)
  0x00, 0x4C, 0x00, 0x56, 0x02, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x02, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x04, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xC7, 0x02, // LÇ (U+004C U+00C7)
  0x00, 0x4C, 0x00, 0xD2, 0x02, // LÒ (U+004C U+00D2)
  0x00, 0x4C, 0x00, 0xD3, 0x02, // LÓ (U+004C U+00D3)
  0x00, 0x4C, 0x00, 0xD4, 0x02, // LÔ (U+004C U+00D4)
  0x00, 0x4C, 0x00, 0xD5, 0x02, // LÕ (U+004C U+00D5)
  0x00, 0x4C, 0x00, 0xD6, 0x02, // LÖ (U+004C U+00D6)
  0x00, 0x4C, 0x00, 0xD8, 0x02, // LØ (U+004C U+00D8)
  0x00, 0x4C, 0x00, 0xD9, 0x01, // LÙ (U+004C U+00D9)
  0x00, 0x4C, 0x00, 0xDA, 0x01, // LÚ (U+004C U+00DA)
  0x00, 0x4C, 0x00, 0xDB, 0x01, // LÛ (U+004C U+00DB)
  0x00, 0x4C, 0x00, 0xDC, 0x01, // LÜ (U+004C U+00DC)
  0x00, 0x4C, 0x00, 0xDD, 0x04, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x06, 0x02, // LĆ (U+004C U+0106)
  0x00, 0x4C, 0x01, 0x08, 0x02, // LĈ (U+004C U+0108)
  0x00, 0x4C, 0x01, 0x0A, 0x02, // LĊ (U+004C U+010A)
  0x00, 0x4C, 0x01, 0x0C, 0x02, // LČ (U+004C U+010C)
  0x00, 0x4C, 0x01, 0x1C, 0x02, // LĜ (U+004C U+011C)
  0x00, 0x4C, 0x01, 0x1E, 0x02, // LĞ (U+004C U+011E)
  0x00, 0x4C, 0x01, 0x20, 0x02, // LĠ (U+004C U+0120)
  0x00, 0x4C, 0x01, 0x22, 0x02, // LĢ (U+004C U+0122)
  0x00, 0x4C, 0x01, 0x4C, 0x02, // LŌ (U+004C U+014C)
  0x00, 0x4C, 0x01, 0x4E, 0x02, // LŎ (U+004C U+014E)
  0x00, 0x4C, 0x01, 0x50, 0x02, // LŐ (U+004C U+0150)
  0x00, 0x4C, 0x01, 0x52, 0x02, // LŒ (U+004C U+0152)
  0x00, 0x4C, 0x01, 0x62, 0x02, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x02, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x02, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x01, 0x68, 0x01, // LŨ (U+004C U+0168)
  0x00, 0x4C, 0x01, 0x6A, 0x01, // LŪ (U+004C U+016A)
  0x00, 0x4C, 0x01, 0x6C, 0x01, // LŬ (U+004C U+016C)
  0x00, 0x4C, 0x01, 0x6E, 0x01, // LŮ (U+004C U+016E)
  0x00, 0x4C, 0x01, 0x70, 0x01, // LŰ (U+004C U+0170)
  0x00, 0x4C, 0x01, 0x72, 0x01, // LŲ (U+004C U+0172)
  0x00, 0x4C, 0x01, 0x74, 0x02, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x04, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x04, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x19, 0x0A, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x0A, // L” (U+004C U+201D)
  0x00, 0x4F, 0x00, 0x2C, 0x05, // O, (U+004F U+002C)
  0x00, 0x4F, 0x00, 0x2E, 0x05, // O. (U+004F U+002E)
  0x00, 0x4F, 0x00, 0x41, 0x02, // OA (U+004F U+0041)
  0x00, 0x4F, 0x00, 0x54, 0x04, // OT (U+004F U+0054)
  0x00, 0x4F, 0x00, 0x56, 0x01, // OV (U+004F U+0056)
  0x00, 0x4F, 0x00, 0x57, 0x01, // OW (U+004F U+0057)
  0x00, 0x4F, 0x00, 0x58, 0x02, // OX (U+004F U+0058)
  0x00, 0x4F, 0x00, 0x59, 0x01, // OY (U+004F U+0059)
  0x00, 0x4F, 0x00, 0x5A, 0x01, // OZ (U+004F U+005A)
  0x00, 0x4F, 0x00, 0xC0, 0x02, // OÀ (U+004F U+00C0)
  0x00, 0x4F, 0x00, 0xC1, 0x02, // OÁ (U+004F U+00C1)
  0x00, 0x4F, 0x00, 0xC2, 0x02, // OÂ (U+004F U+00C2)
  0x00, 0x4F, 0x00, 0xC3, 0x02, // OÃ (U+004F U+00C3)
  0x00, 0x4F, 0x00, 0xC4, 0x02, // OÄ (U+004F U+00C4)
  0x00, 0x4F, 0x00, 0xC5, 0x02, // OÅ (U+004F U+00C5)
  0x00, 0x4F, 0x00, 0xDD, 0x01, // OÝ (U+004F U+00DD)
  0x00, 0x4F, 0x01, 0x00, 0x02, // OĀ (U+004F U+0100)
  0x00, 0x4F, 0x01, 0x02, 0x02, // OĂ (U+004F U+0102)
  0x00, 0x4F, 0x01, 0x04, 0x02, // OĄ (U+004F U+0104)
  0x00, 0x4F, 0x01, 0x62, 0x04, // OŢ (U+004F U+0162)
  0x00, 0x4F, 0x01, 0x64, 0x04, // OŤ (U+004F U+0164)
  0x00, 0x4F, 0x01, 0x66, 0x04, // OŦ (U+004F U+0166)
  0x00, 0x4F, 0x01, 0x74, 0x01, // OŴ (U+004F U+0174)
  0x00, 0x4F, 0x01, 0x76, 0x01, // OŶ (U+004F U+0176)
  0x00, 0x4F, 0x01, 0x78, 0x01, // OŸ (U+004F U+0178)
  0x00, 0x4F, 0x01, 0x79, 0x01, // OŹ (U+004F U+0179)
  0x00, 0x4F, 0x01, 0x7B, 0x01, // OŻ (U+004F U+017B)
  0x00, 0x4F, 0x01, 0x7D, 0x01, // OŽ (U+004F U+017D)
  0x00, 0x4F, 0x20, 0x1A, 0x05, // O‚ (U+004F U+201A)
  0x00, 0x4F, 0x20, 0x1E, 0x05, // O„ (U+004F U+201E)
  0x00, 0x4F, 0x20, 0x26, 0x05, // O… (U+004F U+2026)
  0x00, 0x50, 0x00, 0x26, 0x01, // P& (U+0050 U+0026)
  0x00, 0x50, 0x00, 0x2C, 0x10, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x10, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x06, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0x58, 0x02, // PX (U+0050 U+0058)
  0x00, 0x50, 0x00, 0x5A, 0x01, // PZ (U+0050 U+005A)
  0x00, 0x50, 0x00, 0xAB, 0x02, // P« (U+0050 U+00AB)
  0x00, 0x50, 0x00, 0xC0, 0x06, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x06, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x06, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x06, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x06, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x06, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x04, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x06, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x06, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x06, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x01, 0x79, 0x01, // PŹ (U+0050 U+0179)
  0x00, 0x50, 0x01, 0x7B, 0x01, // PŻ (U+0050 U+017B)
  0x00, 0x50, 0x01, 0x7D, 0x01, // PŽ (U+0050 U+017D)
  0x00, 0x50, 0x20, 0x1A, 0x10, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x10, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x10, // P… (U+0050 U+2026)
  0x00, 0x50, 0x20, 0x39, 0x02, // P‹ (U+0050 U+2039)
  0x00, 0x51, 0x00, 0x2C, 0x05, // Q, (U+0051 U+002C)
  0x00, 0x51, 0x00, 0x2E, 0x05, // Q. (U+0051 U+002E)
  0x00, 0x51, 0x00, 0x41, 0x02, // QA (U+0051 U+0041)
  0x00, 0x51, 0x00, 0x54, 0x04, // QT (U+0051 U+0054)
  0x00, 0x51, 0x00, 0x56, 0x01, // QV (U+0051 U+0056)
  0x00, 0x51, 0x00, 0x57, 0x01, // QW (U+0051 U+0057)
  0x00, 0x51, 0x00, 0x58, 0x02, // QX (U+0051 U+0058)
  0x00, 0x51, 0x00, 0x59, 0x01, // QY (U+0051 U+0059)
  0x00, 0x51, 0x00, 0x5A, 0x01, // QZ (U+0051 U+005A)
  0x00, 0x51, 0x00, 0xC0, 0x02, // QÀ (U+0051 U+00C0)
  0x00, 0x51, 0x00, 0xC1, 0x02, // QÁ (U+0051 U+00C1)
  0x00, 0x51, 0x00, 0xC2, 0x02, // QÂ (U+0051 U+00C2)
  0x00, 0x51, 0x00, 0xC3, 0x02, // QÃ (U+0051 U+00C3)
  0x00, 0x51, 0x00, 0xC4, 0x02, // QÄ (U+0051 U+00C4)
  0x00, 0x51, 0x00, 0xC5, 0x02, // QÅ (U+0051 U+00C5)
  0x00, 0x51, 0x00, 0xDD, 0x01, // QÝ (U+0051 U+00DD)
  0x00, 0x51, 0x01, 0x00, 0x02, // QĀ (U+0051 U+0100)
  0x00, 0x51, 0x01, 0x02, 0x02, // QĂ (U+0051 U+0102)
  0x00, 0x51, 0x01, 0x04, 0x02, // QĄ (U+0051 U+0104)
  0x00, 0x51, 0x01, 0x62, 0x04, // QŢ (U+0051 U+0162)
  0x00, 0x51, 0x01, 0x64, 0x04, // QŤ (U+0051 U+0164)
  0x00, 0x51, 0x01, 0x66, 0x04, // QŦ (U+0051 U+0166)
  0x00, 0x51, 0x01, 0x74, 0x01, // QŴ (U+0051 U+0174)
  0x00, 0x51, 0x01, 0x76, 0x01, // QŶ (U+0051 U+0176)
  0x00, 0x51, 0x01, 0x78, 0x01, // QŸ (U+0051 U+0178)
  0x00, 0x51, 0x01, 0x79, 0x01, // QŹ (U+0051 U+0179)
  0x00, 0x51, 0x01, 0x7B, 0x01, // QŻ (U+0051 U+017B)
  0x00, 0x51, 0x01, 0x7D, 0x01, // QŽ (U+0051 U+017D)
  0x00, 0x51, 0x20, 0x1A, 0x05, // Q‚ (U+0051 U+201A)
  0x00, 0x51, 0x20, 0x1E, 0x05, // Q„ (U+0051 U+201E)
  0x00, 0x51, 0x20, 0x26, 0x05, // Q… (U+0051 U+2026)
  0x00, 0x52, 0x00, 0xAB, 0x01, // R« (U+0052 U+00AB)
  0x00, 0x52, 0x20, 0x39, 0x01, // R‹ (U+0052 U+2039)
  0x00, 0x54, 0x00, 0x26, 0x02, // T& (U+0054 U+0026)
  0x00, 0x54, 0x00, 0x2C, 0x07, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2D, 0x05, // T- (U+0054 U+002D)
  0x00, 0x54, 0x00, 0x2E, 0x07, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x08, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x43, 0x02, // TC (U+0054 U+0043)
  0x00, 0x54, 0x00, 0x47, 0x02, // TG (U+0054 U+0047)
  0x00, 0x54, 0x00, 0x4F, 0x02, // TO (U+0054 U+004F)
  0x00, 0x54, 0x00, 0x51, 0x02, // TQ (U+0054 U+0051)
  0x00, 0x54, 0x00, 0x61, 0x0A, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x08, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x08, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x08, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x08, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x06, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x06, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x08, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x06, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x08, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x06, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x07, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x06, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0x76, 0x02, // Tv (U+0054 U+0076)
  0x00, 0x54, 0x00, 0x77, 0x02, // Tw (U+0054 U+0077)
  0x00, 0x54, 0x00, 0x78, 0x02, // Tx (U+0054 U+0078)
  0x00, 0x54, 0x00, 0x79, 0x02, // Ty (U+0054 U+0079)
  0x00, 0x54, 0x00, 0x7A, 0x05, // Tz (U+0054 U+007A)
  0x00, 0x54, 0x00, 0xAB, 0x07, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xBB, 0x04, // T» (U+0054 U+00BB)
  0x00, 0x54, 0x00, 0xC0, 0x08, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x08, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x08, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x08, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x08, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x08, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xC7, 0x02, // TÇ (U+0054 U+00C7)
  0x00, 0x54, 0x00, 0xD2, 0x02, // TÒ (U+0054 U+00D2)
  0x00, 0x54, 0x00, 0xD3, 0x02, // TÓ (U+0054 U+00D3)
  0x00, 0x54, 0x00, 0xD4, 0x02, // TÔ (U+0054 U+00D4)
  0x00, 0x54, 0x00, 0xD5, 0x02, // TÕ (U+0054 U+00D5)
  0x00, 0x54, 0x00, 0xD6, 0x02, // TÖ (U+0054 U+00D6)
  0x00, 0x54, 0x00, 0xD8, 0x02, // TØ (U+0054 U+00D8)
  0x00, 0x54, 0x00, 0xE0, 0x08, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x0A, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x0A, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x0A, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x0A, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x0A, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x0A, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x08, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x08, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x08, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x08, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x08, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x08, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x08, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x08, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x08, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x08, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x08, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x06, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x06, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x06, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x06, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x00, 0xFD, 0x02, // Tý (U+0054 U+00FD)
  0x00, 0x54, 0x00, 0xFF, 0x02, // Tÿ (U+0054 U+00FF)
  0x00, 0x54, 0x01, 0x00, 0x08, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x0A, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x08, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x0A, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x08, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x0A, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x06, 0x02, // TĆ (U+0054 U+0106)
  0x00, 0x54, 0x01, 0x07, 0x08, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x08, 0x02, // TĈ (U+0054 U+0108)
  0x00, 0x54, 0x01, 0x09, 0x08, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0A, 0x02, // TĊ (U+0054 U+010A)
  0x00, 0x54, 0x01, 0x0B, 0x08, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0C, 0x02, // TČ (U+0054 U+010C)
  0x00, 0x54, 0x01, 0x0D, 0x08, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x08, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x08, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x08, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x08, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x08, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x08, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x08, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1C, 0x02, // TĜ (U+0054 U+011C)
  0x00, 0x54, 0x01, 0x1D, 0x08, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1E, 0x02, // TĞ (U+0054 U+011E)
  0x00, 0x54, 0x01, 0x1F, 0x08, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x20, 0x02, // TĠ (U+0054 U+0120)
  0x00, 0x54, 0x01, 0x21, 0x08, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x22, 0x02, // TĢ (U+0054 U+0122)
  0x00, 0x54, 0x01, 0x23, 0x08, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x06, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x06, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x06, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x4B, 0x06, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4C, 0x02, // TŌ (U+0054 U+014C)
  0x00, 0x54, 0x01, 0x4D, 0x08, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4E, 0x02, // TŎ (U+0054 U+014E)
  0x00, 0x54, 0x01, 0x4F, 0x08, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x50, 0x02, // TŐ (U+0054 U+0150)
  0x00, 0x54, 0x01, 0x51, 0x08, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x52, 0x02, // TŒ (U+0054 U+0152)
  0x00, 0x54, 0x01, 0x53, 0x08, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x06, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x06, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x07, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5F, 0x07, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x69, 0x06, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x06, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x06, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x06, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x06, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x06, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x01, 0x75, 0x02, // Tŵ (U+0054 U+0175)
  0x00, 0x54, 0x01, 0x77, 0x02, // Tŷ (U+0054 U+0177)
  0x00, 0x54, 0x01, 0x7A, 0x05, // Tź (U+0054 U+017A)
  0x00, 0x54, 0x01, 0x7C, 0x05, // Tż (U+0054 U+017C)
  0x00, 0x54, 0x01, 0x7E, 0x05, // Tž (U+0054 U+017E)
  0x00, 0x54, 0x20, 0x13, 0x05, // T– (U+0054 U+2013)
  0x00, 0x54, 0x20, 0x14, 0x05, // T— (U+0054 U+2014)
  0x00, 0x54, 0x20, 0x1A, 0x07, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x07, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x07, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x07, // T‹ (U+0054 U+2039)
  0x00, 0x54, 0x20, 0x3A, 0x04, // T› (U+0054 U+203A)
  0x00, 0x55, 0x00, 0x2C, 0x02, // U, (U+0055 U+002C)
  0x00, 0x55, 0x00, 0x2E, 0x02, // U. (U+0055 U+002E)
  0x00, 0x55, 0x00, 0x41, 0x01, // UA (U+0055 U+0041)
  0x00, 0x55, 0x00, 0xC0, 0x01, // UÀ (U+0055 U+00C0)
  0x00, 0x55, 0x00, 0xC1, 0x01, // UÁ (U+0055 U+00C1)
  0x00, 0x55, 0x00, 0xC2, 0x01, // UÂ (U+0055 U+00C2)
  0x00, 0x55, 0x00, 0xC3, 0x01, // UÃ (U+0055 U+00C3)
  0x00, 0x55, 0x00, 0xC4, 0x01, // UÄ (U+0055 U+00C4)
  0x00, 0x55, 0x00, 0xC5, 0x01, // UÅ (U+0055 U+00C5)
  0x00, 0x55, 0x01, 0x00, 0x01, // UĀ (U+0055 U+0100)
  0x00, 0x55, 0x01, 0x02, 0x01, // UĂ (U+0055 U+0102)
  0x00, 0x55, 0x01, 0x04, 0x01, // UĄ (U+0055 U+0104)
  0x00, 0x55, 0x20, 0x1A, 0x02, // U‚ (U+0055 U+201A)
  0x00, 0x55, 0x20, 0x1E, 0x02, // U„ (U+0055 U+201E)
  0x00, 0x55, 0x20, 0x26, 0x02, // U… (U+0055 U+2026)
  0x00, 0x56, 0x00, 0x2C, 0x06, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x06, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x41, 0x05, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0x43, 0x01, // VC (U+0056 U+0043)
  0x00, 0x56, 0x00, 0x47, 0x01, // VG (U+0056 U+0047)
  0x00, 0x56, 0x00, 0x4F, 0x01, // VO (U+0056 U+004F)
  0x00, 0x56, 0x00, 0x51, 0x01, // VQ (U+0056 U+0051)
  0x00, 0x56, 0x00, 0x61, 0x02, // Va (U+0056 U+0061)
  0x00, 0x56, 0x00, 0x63, 0x02, // Vc (U+0056 U+0063)
  0x00, 0x56, 0x00, 0x64, 0x02, // Vd (U+0056 U+0064)
  0x00, 0x56, 0x00, 0x65, 0x02, // Ve (U+0056 U+0065)
  0x00, 0x56, 0x00, 0x67, 0x01, // Vg (U+0056 U+0067)
  0x00, 0x56, 0x00, 0x6D, 0x01, // Vm (U+0056 U+006D)
  0x00, 0x56, 0x00, 0x6E, 0x01, // Vn (U+0056 U+006E)
  0x00, 0x56, 0x00, 0x6F, 0x02, // Vo (U+0056 U+006F)
  0x00, 0x56, 0x00, 0x70, 0x01, // Vp (U+0056 U+0070)
  0x00, 0x56, 0x00, 0x71, 0x02, // Vq (U+0056 U+0071)
  0x00, 0x56, 0x00, 0x72, 0x01, // Vr (U+0056 U+0072)
  0x00, 0x56, 0x00, 0x73, 0x01, // Vs (U+0056 U+0073)
  0x00, 0x56, 0x00, 0x75, 0x01, // Vu (U+0056 U+0075)
  0x00, 0x56, 0x00, 0xAB, 0x04, // V« (U+0056 U+00AB)
  0x00, 0x56, 0x00, 0xBB, 0x01, // V» (U+0056 U+00BB)
  0x00, 0x56, 0x00, 0xC0, 0x05, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x05, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x05, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x05, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x05, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x05, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x00, 0xC7, 0x01, // VÇ (U+0056 U+00C7)
  0x00, 0x56, 0x00, 0xD2, 0x01, // VÒ (U+0056 U+00D2)
  0x00, 0x56, 0x00, 0xD3, 0x01, // VÓ (U+0056 U+00D3)
  0x00, 0x56, 0x00, 0xD4, 0x01, // VÔ (U+0056 U+00D4)
  0x00, 0x56, 0x00, 0xD5, 0x01, // VÕ (U+0056 U+00D5)
  0x00, 0x56, 0x00, 0xD6, 0x01, // VÖ (U+0056 U+00D6)
  0x00, 0x56, 0x00, 0xD8, 0x01, // VØ (U+0056 U+00D8)
  0x00, 0x56, 0x00, 0xE0, 0x02, // Và (U+0056 U+00E0)
  0x00, 0x56, 0x00, 0xE1, 0x02, // Vá (U+0056 U+00E1)
  0x00, 0x56, 0x00, 0xE2, 0x02, // Vâ (U+0056 U+00E2)
  0x00, 0x56, 0x00, 0xE3, 0x02, // Vã (U+0056 U+00E3)
  0x00, 0x56, 0x00, 0xE4, 0x02, // Vä (U+0056 U+00E4)
  0x00, 0x56, 0x00, 0xE5, 0x02, // Vå (U+0056 U+00E5)
  0x00, 0x56, 0x00, 0xE6, 0x02, // Væ (U+0056 U+00E6)
  0x00, 0x56, 0x00, 0xE7, 0x02, // Vç (U+0056 U+00E7)
  0x00, 0x56, 0x00, 0xE8, 0x02, // Vè (U+0056 U+00E8)
  0x00, 0x56, 0x00, 0xE9, 0x02, // Vé (U+0056 U+00E9)
  0x00, 0x56, 0x00, 0xEA, 0x02, // Vê (U+0056 U+00EA)
  0x00, 0x56, 0x00, 0xEB, 0x02, // Vë (U+0056 U+00EB)
  0x00, 0x56, 0x00, 0xF2, 0x02, // Vò (U+0056 U+00F2)
  0x00, 0x56, 0x00, 0xF3, 0x02, // Vó (U+0056 U+00F3)
  0x00, 0x56, 0x00, 0xF4, 0x02, // Vô (U+0056 U+00F4)
  0x00, 0x56, 0x00, 0xF5, 0x02, // Võ (U+0056 U+00F5)
  0x00, 0x56, 0x00, 0xF6, 0x02, // Vö (U+0056 U+00F6)
  0x00, 0x56, 0x00, 0xF8, 0x02, // Vø (U+0056 U+00F8)
  0x00, 0x56, 0x00, 0xF9, 0x01, // Vù (U+0056 U+00F9)
  0x00, 0x56, 0x00, 0xFA, 0x01, // Vú (U+0056 U+00FA)
  0x00, 0x56, 0x00, 0xFB, 0x01, // Vû (U+0056 U+00FB)
  0x00, 0x56, 0x00, 0xFC, 0x01, // Vü (U+0056 U+00FC)
  0x00, 0x56, 0x01, 0x00, 0x05, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x01, 0x02, // Vā (U+0056 U+0101)
  0x00, 0x56, 0x01, 0x02, 0x05, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x03, 0x02, // Vă (U+0056 U+0103)
  0x00, 0x56, 0x01, 0x04, 0x05, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x01, 0x05, 0x02, // Vą (U+0056 U+0105)
  0x00, 0x56, 0x01, 0x06, 0x01, // VĆ (U+0056 U+0106)
  0x00, 0x56, 0x01, 0x07, 0x02, // Vć (U+0056 U+0107)
  0x00, 0x56, 0x01, 0x08, 0x01, // VĈ (U+0056 U+0108)
  0x00, 0x56, 0x01, 0x09, 0x02, // Vĉ (U+0056 U+0109)
  0x00, 0x56, 0x01, 0x0A, 0x01, // VĊ (U+0056 U+010A)
  0x00, 0x56, 0x01, 0x0B, 0x02, // Vċ (U+0056 U+010B)
  0x00, 0x56, 0x01, 0x0C, 0x01, // VČ (U+0056 U+010C)
  0x00, 0x56, 0x01, 0x0D, 0x02, // Vč (U+0056 U+010D)
  0x00, 0x56, 0x01, 0x0F, 0x02, // Vď (U+0056 U+010F)
  0x00, 0x56, 0x01, 0x11, 0x02, // Vđ (U+0056 U+0111)
  0x00, 0x56, 0x01, 0x13, 0x02, // Vē (U+0056 U+0113)
  0x00, 0x56, 0x01, 0x15, 0x02, // Vĕ (U+0056 U+0115)
  0x00, 0x56, 0x01, 0x17, 0x02, // Vė (U+0056 U+0117)
  0x00, 0x56, 0x01, 0x19, 0x02, // Vę (U+0056 U+0119)
  0x00, 0x56, 0x01, 0x1B, 0x02, // Vě (U+0056 U+011B)
  0x00, 0x56, 0x01, 0x1C, 0x01, // VĜ (U+0056 U+011C)
  0x00, 0x56, 0x01, 0x1D, 0x01, // Vĝ (U+0056 U+011D)
  0x00, 0x56, 0x01, 0x1E, 0x01, // VĞ (U+0056 U+011E)
  0x00, 0x56, 0x01, 0x1F, 0x01, // Vğ (U+0056 U+011F)
  0x00, 0x56, 0x01, 0x20, 0x01, // VĠ (U+0056 U+0120)
  0x00, 0x56, 0x01, 0x21, 0x01, // Vġ (U+0056 U+0121)
  0x00, 0x56, 0x01, 0x22, 0x01, // VĢ (U+0056 U+0122)
  0x00, 0x56, 0x01, 0x23, 0x01, // Vģ (U+0056 U+0123)
  0x00, 0x56, 0x01, 0x38, 0x01, // Vĸ (U+0056 U+0138)
  0x00, 0x56, 0x01, 0x44, 0x01, // Vń (U+0056 U+0144)
  0x00, 0x56, 0x01, 0x46, 0x01, // Vņ (U+0056 U+0146)
  0x00, 0x56, 0x01, 0x4B, 0x01, // Vŋ (U+0056 U+014B)
  0x00, 0x56, 0x01, 0x4C, 0x01, // VŌ (U+0056 U+014C)
  0x00, 0x56, 0x01, 0x4D, 0x02, // Vō (U+0056 U+014D)
  0x00, 0x56, 0x01, 0x4E, 0x01, // VŎ (U+0056 U+014E)
  0x00, 0x56, 0x01, 0x4F, 0x02, // Vŏ (U+0056 U+014F)
  0x00, 0x56, 0x01, 0x50, 0x01, // VŐ (U+0056 U+0150)
  0x00, 0x56, 0x01, 0x51, 0x02, // Vő (U+0056 U+0151)
  0x00, 0x56, 0x01, 0x52, 0x01, // VŒ (U+0056 U+0152)
  0x00, 0x56, 0x01, 0x53, 0x02, // Vœ (U+0056 U+0153)
  0x00, 0x56, 0x01, 0x55, 0x01, // Vŕ (U+0056 U+0155)
  0x00, 0x56, 0x01, 0x57, 0x01, // Vŗ (U+0056 U+0157)
  0x00, 0x56, 0x01, 0x5B, 0x01, // Vś (U+0056 U+015B)
  0x00, 0x56, 0x01, 0x5F, 0x01, // Vş (U+0056 U+015F)
  0x00, 0x56, 0x01, 0x69, 0x01, // Vũ (U+0056 U+0169)
  0x00, 0x56, 0x01, 0x6B, 0x01, // Vū (U+0056 U+016B)
  0x00, 0x56, 0x01, 0x6D, 0x01, // Vŭ (U+0056 U+016D)
  0x00, 0x56, 0x01, 0x6F, 0x01, // Vů (U+0056 U+016F)
  0x00, 0x56, 0x01, 0x71, 0x01, // Vű (U+0056 U+0171)
  0x00, 0x56, 0x01, 0x73, 0x01, // Vų (U+0056 U+0173)
  0x00, 0x56, 0x20, 0x1A, 0x06, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x06, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x06, // V… (U+0056 U+2026)
  0x00, 0x56, 0x20, 0x39, 0x04, // V‹ (U+0056 U+2039)
  0x00, 0x56, 0x20, 0x3A, 0x01, // V› (U+0056 U+203A)
  0x00, 0x57, 0x00, 0x2C, 0x06, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x06, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x41, 0x05, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0x43, 0x01, // WC (U+0057 U+0043)
  0x00, 0x57, 0x00, 0x47, 0x01, // WG (U+0057 U+0047)
  0x00, 0x57, 0x00, 0x4F, 0x01, // WO (U+0057 U+004F)
  0x00, 0x57, 0x00, 0x51, 0x01, // WQ (U+0057 U+0051)
  0x00, 0x57, 0x00, 0x61, 0x02, // Wa (U+0057 U+0061)
  0x00, 0x57, 0x00, 0x63, 0x02, // Wc (U+0057 U+0063)
  0x00, 0x57, 0x00, 0x64, 0x02, // Wd (U+0057 U+0064)
  0x00, 0x57, 0x00, 0x65, 0x02, // We (U+0057 U+0065)
  0x00, 0x57, 0x00, 0x67, 0x01, // Wg (U+0057 U+0067)
  0x00, 0x57, 0x00, 0x6D, 0x01, // Wm (U+0057 U+006D)
  0x00, 0x57, 0x00, 0x6E, 0x01, // Wn (U+0057 U+006E)
  0x00, 0x57, 0x00, 0x6F, 0x02, // Wo (U+0057 U+006F)
  0x00, 0x57, 0x00, 0x70, 0x01, // Wp (U+0057 U+0070)
  0x00, 0x57, 0x00, 0x71, 0x02, // Wq (U+0057 U+0071)
  0x00, 0x57, 0x00, 0x72, 0x01, // Wr (U+0057 U+0072)
  0x00, 0x57, 0x00, 0x73, 0x01, // Ws (U+0057 U+0073)
  0x00, 0x57, 0x00, 0x75, 0x01, // Wu (U+0057 U+0075)
  0x00, 0x57, 0x00, 0xAB, 0x04, // W« (U+0057 U+00AB)
  0x00, 0x57, 0x00, 0xBB, 0x01, // W» (U+0057 U+00BB)
  0x00, 0x57, 0x00, 0xC0, 0x05, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x05, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x05, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x05, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x05, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x05, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x00, 0xC7, 0x01, // WÇ (U+0057 U+00C7)
  0x00, 0x57, 0x00, 0xD2, 0x01, // WÒ (U+0057 U+00D2)
  0x00, 0x57, 0x00, 0xD3, 0x01, // WÓ (U+0057 U+00D3)
  0x00, 0x57, 0x00, 0xD4, 0x01, // WÔ (U+0057 U+00D4)
  0x00, 0x57, 0x00, 0xD5, 0x01, // WÕ (U+0057 U+00D5)
  0x00, 0x57, 0x00, 0xD6, 0x01, // WÖ (U+0057 U+00D6)
  0x00, 0x57, 0x00, 0xD8, 0x01, // WØ (U+0057 U+00D8)
  0x00, 0x57, 0x00, 0xE0, 0x02, // Wà (U+0057 U+00E0)
  0x00, 0x57, 0x00, 0xE1, 0x02, // Wá (U+0057 U+00E1)
  0x00, 0x57, 0x00, 0xE2, 0x02, // Wâ (U+0057 U+00E2)
  0x00, 0x57, 0x00, 0xE3, 0x02, // Wã (U+0057 U+00E3)
  0x00, 0x57, 0x00, 0xE4, 0x02, // Wä (U+0057 U+00E4)
  0x00, 0x57, 0x00, 0xE5, 0x02, // Wå (U+0057 U+00E5)
  0x00, 0x57, 0x00, 0xE6, 0x02, // Wæ (U+0057 U+00E6)
  0x00, 0x57, 0x00, 0xE7, 0x02, // Wç (U+0057 U+00E7)
  0x00, 0x57, 0x00, 0xE8, 0x02, // Wè (U+0057 U+00E8)
  0x00, 0x57, 0x00, 0xE9, 0x02, // Wé (U+0057 U+00E9)
  0x00, 0x57, 0x00, 0xEA, 0x02, // Wê (U+0057 U+00EA)
  0x00, 0x57, 0x00, 0xEB, 0x02, // Wë (U+0057 U+00EB)
  0x00, 0x57, 0x00, 0xF2, 0x02, // Wò (U+0057 U+00F2)
  0x00, 0x57, 0x00, 0xF3, 0x02, // Wó (U+0057 U+00F3)
  0x00, 0x57, 0x00, 0xF4, 0x02, // Wô (U+0057 U+00F4)
  0x00, 0x57, 0x00, 0xF5, 0x02, // Wõ (U+0057 U+00F5)
  0x00, 0x57, 0x00, 0xF6, 0x02, // Wö (U+0057 U+00F6)
  0x00, 0x57, 0x00, 0xF8, 0x02, // Wø (U+0057 U+00F8)
  0x00, 0x57, 0x00, 0xF9, 0x01, // Wù (U+0057 U+00F9)
  0x00, 0x57, 0x00, 0xFA, 0x01, // Wú (U+0057 U+00FA)
  0x00, 0x57, 0x00, 0xFB, 0x01, // Wû (U+0057 U+00FB)
  0x00, 0x57, 0x00, 0xFC, 0x01, // Wü (U+0057 U+00FC)
  0x00, 0x57, 0x01, 0x00, 0x05, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x01, 0x02, // Wā (U+0057 U+0101)
  0x00, 0x57, 0x01, 0x02, 0x05, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x03, 0x02, // Wă (U+0057 U+0103)
  0x00, 0x57, 0x01, 0x04, 0x05, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x01, 0x05, 0x02, // Wą (U+0057 U+0105)
  0x00, 0x57, 0x01, 0x06, 0x01, // WĆ (U+0057 U+0106)
  0x00, 0x57, 0x01, 0x07, 0x02, // Wć (U+0057 U+0107)
  0x00, 0x57, 0x01, 0x08, 0x01, // WĈ (U+0057 U+0108)
  0x00, 0x57, 0x01, 0x09, 0x02, // Wĉ (U+0057 U+0109)
  0x00, 0x57, 0x01, 0x0A, 0x01, // WĊ (U+0057 U+010A)
  0x00, 0x57, 0x01, 0x0B, 0x02, // Wċ (U+0057 U+010B)
  0x00, 0x57, 0x01, 0x0C, 0x01, // WČ (U+0057 U+010C)
  0x00, 0x57, 0x01, 0x0D, 0x02, // Wč (U+0057 U+010D)
  0x00, 0x57, 0x01, 0x0F, 0x02, // Wď (U+0057 U+010F)
  0x00, 0x57, 0x01, 0x11, 0x02, // Wđ (U+0057 U+0111)
  0x00, 0x57, 0x01, 0x13, 0x02, // Wē (U+0057 U+0113)
  0x00, 0x57, 0x01, 0x15, 0x02, // Wĕ (U+0057 U+0115)
  0x00, 0x57, 0x01, 0x17, 0x02, // Wė (U+0057 U+0117)
  0x00, 0x57, 0x01, 0x19, 0x02, // Wę (U+0057 U+0119)
  0x00, 0x57, 0x01, 0x1B, 0x02, // Wě (U+0057 U+011B)
  0x00, 0x57, 0x01, 0x1C, 0x01, // WĜ (U+0057 U+011C)
  0x00, 0x57, 0x01, 0x1D, 0x01, // Wĝ (U+0057 U+011D)
  0x00, 0x57, 0x01, 0x1E, 0x01, // WĞ (U+0057 U+011E)
  0x00, 0x57, 0x01, 0x1F, 0x01, // Wğ (U+0057 U+011F)
  0x00, 0x57, 0x01, 0x20, 0x01, // WĠ (U+0057 U+0120)
  0x00, 0x57, 0x01, 0x21, 0x01, // Wġ (U+0057 U+0121)
  0x00, 0x57, 0x01, 0x22, 0x01, // WĢ (U+0057 U+0122)
  0x00, 0x57, 0x01, 0x23, 0x01, // Wģ (U+0057 U+0123)
  0x00, 0x57, 0x01, 0x38, 0x01, // Wĸ (U+0057 U+0138)
  0x00, 0x57, 0x01, 0x44, 0x01, // Wń (U+0057 U+0144)
  0x00, 0x57, 0x01, 0x46, 0x01, // Wņ (U+0057 U+0146)
  0x00, 0x57, 0x01, 0x4B, 0x01, // Wŋ (U+0057 U+014B)
  0x00, 0x57, 0x01, 0x4C, 0x01, // WŌ (U+0057 U+014C)
  0x00, 0x57, 0x01, 0x4D, 0x02, // Wō (U+0057 U+014D)
  0x00, 0x57, 0x01, 0x4E, 0x01, // WŎ (U+0057 U+014E)
  0x00, 0x57, 0x01, 0x4F, 0x02, // Wŏ (U+0057 U+014F)
  0x00, 0x57, 0x01, 0x50, 0x01, // WŐ (U+0057 U+0150)
  0x00, 0x57, 0x01, 0x51, 0x02, // Wő (U+0057 U+0151)
  0x00, 0x57, 0x01, 0x52, 0x01, // WŒ (U+0057 U+0152)
  0x00, 0x57, 0x01, 0x53, 0x02, // Wœ (U+0057 U+0153)
  0x00, 0x57, 0x01, 0x55, 0x01, // Wŕ (U+0057 U+0155)
  0x00, 0x57, 0x01, 0x57, 0x01, // Wŗ (U+0057 U+0157)
  0x00, 0x57, 0x01, 0x5B, 0x01, // Wś (U+0057 U+015B)
  0x00, 0x57, 0x01, 0x5F, 0x01, // Wş (U+0057 U+015F)
  0x00, 0x57, 0x01, 0x69, 0x01, // Wũ (U+0057 U+0169)
  0x00, 0x57, 0x01, 0x6B, 0x01, // Wū (U+0057 U+016B)
  0x00, 0x57, 0x01, 0x6D, 0x01, // Wŭ (U+0057 U+016D)
  0x00, 0x57, 0x01, 0x6F, 0x01, // Wů (U+0057 U+016F)
  0x00, 0x57, 0x01, 0x71, 0x01, // Wű (U+0057 U+0171)
  0x00, 0x57, 0x01, 0x73, 0x01, // Wų (U+0057 U+0173)
  0x00, 0x57, 0x20, 0x1A, 0x06, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x06, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x06, // W… (U+0057 U+2026)
  0x00, 0x57, 0x20, 0x39, 0x04, // W‹ (U+0057 U+2039)
  0x00, 0x57, 0x20, 0x3A, 0x01, // W› (U+0057 U+203A)
  0x00, 0x58, 0x00, 0x43, 0x02, // XC (U+0058 U+0043)
  0x00, 0x58, 0x00, 0x47, 0x02, // XG (U+0058 U+0047)
  0x00, 0x58, 0x00, 0x4F, 0x02, // XO (U+0058 U+004F)
  0x00, 0x58, 0x00, 0x51, 0x02, // XQ (U+0058 U+0051)
  0x00, 0x58, 0x00, 0xAB, 0x02, // X« (U+0058 U+00AB)
  0x00, 0x58, 0x00, 0xC7, 0x02, // XÇ (U+0058 U+00C7)
  0x00, 0x58, 0x00, 0xD2, 0x02, // XÒ (U+0058 U+00D2)
  0x00, 0x58, 0x00, 0xD3, 0x02, // XÓ (U+0058 U+00D3)
  0x00, 0x58, 0x00, 0xD4, 0x02, // XÔ (U+0058 U+00D4)
  0x00, 0x58, 0x00, 0xD5, 0x02, // XÕ (U+0058 U+00D5)
  0x00, 0x58, 0x00, 0xD6, 0x02, // XÖ (U+0058 U+00D6)
  0x00, 0x58, 0x00, 0xD8, 0x02, // XØ (U+0058 U+00D8)
  0x00, 0x58, 0x01, 0x06, 0x02, // XĆ (U+0058 U+0106)
  0x00, 0x58, 0x01, 0x08, 0x02, // XĈ (U+0058 U+0108)
  0x00, 0x58, 0x01, 0x0A, 0x02, // XĊ (U+0058 U+010A)
  0x00, 0x58, 0x01, 0x0C, 0x02, // XČ (U+0058 U+010C)
  0x00, 0x58, 0x01, 0x1C, 0x02, // XĜ (U+0058 U+011C)
  0x00, 0x58, 0x01, 0x1E, 0x02, // XĞ (U+0058 U+011E)
  0x00, 0x58, 0x01, 0x20, 0x02, // XĠ (U+0058 U+0120)
  0x00, 0x58, 0x01, 0x22, 0x02, // XĢ (U+0058 U+0122)
  0x00, 0x58, 0x01, 0x4C, 0x02, // XŌ (U+0058 U+014C)
  0x00, 0x58, 0x01, 0x4E, 0x02, // XŎ (U+0058 U+014E)
  0x00, 0x58, 0x01, 0x50, 0x02, // XŐ (U+0058 U+0150)
  0x00, 0x58, 0x01, 0x52, 0x02, // XŒ (U+0058 U+0152)
  0x00, 0x58, 0x20, 0x39, 0x02, // X‹ (U+0058 U+2039)
  0x00, 0x59, 0x00, 0x26, 0x04, // Y& (U+0059 U+0026)
  0x00, 0x59, 0x00, 0x2C, 0x07, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x07, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x07, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x43, 0x02, // YC (U+0059 U+0043)
  0x00, 0x59, 0x00, 0x47, 0x02, // YG (U+0059 U+0047)
  0x00, 0x59, 0x00, 0x4F, 0x02, // YO (U+0059 U+004F)
  0x00, 0x59, 0x00, 0x51, 0x02, // YQ (U+0059 U+0051)
  0x00, 0x59, 0x00, 0x61, 0x06, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x06, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x06, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x06, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x06, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6D, 0x04, // Ym (U+0059 U+006D)
  0x00, 0x59, 0x00, 0x6E, 0x04, // Yn (U+0059 U+006E)
  0x00, 0x59, 0x00, 0x6F, 0x06, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x70, 0x04, // Yp (U+0059 U+0070)
  0x00, 0x59, 0x00, 0x71, 0x06, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x72, 0x04, // Yr (U+0059 U+0072)
  0x00, 0x59, 0x00, 0x73, 0x05, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0x75, 0x04, // Yu (U+0059 U+0075)
  0x00, 0x59, 0x00, 0x7A, 0x02, // Yz (U+0059 U+007A)
  0x00, 0x59, 0x00, 0xAB, 0x0A, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xBB, 0x04, // Y» (U+0059 U+00BB)
  0x00, 0x59, 0x00, 0xC0, 0x07, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x07, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x07, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x07, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x07, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x07, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xC7, 0x02, // YÇ (U+0059 U+00C7)
  0x00, 0x59, 0x00, 0xD2, 0x02, // YÒ (U+0059 U+00D2)
  0x00, 0x59, 0x00, 0xD3, 0x02, // YÓ (U+0059 U+00D3)
  0x00, 0x59, 0x00, 0xD4, 0x02, // YÔ (U+0059 U+00D4)
  0x00, 0x59, 0x00, 0xD5, 0x02, // YÕ (U+0059 U+00D5)
  0x00, 0x59, 0x00, 0xD6, 0x02, // YÖ (U+0059 U+00D6)
  0x00, 0x59, 0x00, 0xD8, 0x02, // YØ (U+0059 U+00D8)
  0x00, 0x59, 0x00, 0xE0, 0x06, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x06, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x06, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x06, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x06, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x06, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x06, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x06, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x06, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x06, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x06, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x06, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF2, 0x06, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x06, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x06, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x06, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x06, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x06, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x00, 0xF9, 0x04, // Yù (U+0059 U+00F9)
  0x00, 0x59, 0x00, 0xFA, 0x04, // Yú (U+0059 U+00FA)
  0x00, 0x59, 0x00, 0xFB, 0x04, // Yû (U+0059 U+00FB)
  0x00, 0x59, 0x00, 0xFC, 0x04, // Yü (U+0059 U+00FC)
  0x00, 0x59, 0x01, 0x00, 0x07, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x06, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x07, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x06, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x07, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x06, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x06, 0x02, // YĆ (U+0059 U+0106)
  0x00, 0x59, 0x01, 0x07, 0x06, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x08, 0x02, // YĈ (U+0059 U+0108)
  0x00, 0x59, 0x01, 0x09, 0x06, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0A, 0x02, // YĊ (U+0059 U+010A)
  0x00, 0x59, 0x01, 0x0B, 0x06, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0C, 0x02, // YČ (U+0059 U+010C)
  0x00, 0x59, 0x01, 0x0D, 0x06, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x06, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x06, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x06, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x06, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x06, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x06, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x06, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1C, 0x02, // YĜ (U+0059 U+011C)
  0x00, 0x59, 0x01, 0x1D, 0x06, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1E, 0x02, // YĞ (U+0059 U+011E)
  0x00, 0x59, 0x01, 0x1F, 0x06, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x20, 0x02, // YĠ (U+0059 U+0120)
  0x00, 0x59, 0x01, 0x21, 0x06, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x22, 0x02, // YĢ (U+0059 U+0122)
  0x00, 0x59, 0x01, 0x23, 0x06, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x38, 0x04, // Yĸ (U+0059 U+0138)
  0x00, 0x59, 0x01, 0x44, 0x04, // Yń (U+0059 U+0144)
  0x00, 0x59, 0x01, 0x46, 0x04, // Yņ (U+0059 U+0146)
  0x00, 0x59, 0x01, 0x4B, 0x04, // Yŋ (U+0059 U+014B)
  0x00, 0x59, 0x01, 0x4C, 0x02, // YŌ (U+0059 U+014C)
  0x00, 0x59, 0x01, 0x4D, 0x06, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4E, 0x02, // YŎ (U+0059 U+014E)
  0x00, 0x59, 0x01, 0x4F, 0x06, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x50, 0x02, // YŐ (U+0059 U+0150)
  0x00, 0x59, 0x01, 0x51, 0x06, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x52, 0x02, // YŒ (U+0059 U+0152)
  0x00, 0x59, 0x01, 0x53, 0x06, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x55, 0x04, // Yŕ (U+0059 U+0155)
  0x00, 0x59, 0x01, 0x57, 0x04, // Yŗ (U+0059 U+0157)
  0x00, 0x59, 0x01, 0x5B, 0x05, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5F, 0x05, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x69, 0x04, // Yũ (U+0059 U+0169)
  0x00, 0x59, 0x01, 0x6B, 0x04, // Yū (U+0059 U+016B)
  0x00, 0x59, 0x01, 0x6D, 0x04, // Yŭ (U+0059 U+016D)
  0x00, 0x59, 0x01, 0x6F, 0x04, // Yů (U+0059 U+016F)
  0x00, 0x59, 0x01, 0x71, 0x04, // Yű (U+0059 U+0171)
  0x00, 0x59, 0x01, 0x73, 0x04, // Yų (U+0059 U+0173)
  0x00, 0x59, 0x01, 0x7A, 0x02, // Yź (U+0059 U+017A)
  0x00, 0x59, 0x01, 0x7C, 0x02, // Yż (U+0059 U+017C)
  0x00, 0x59, 0x01, 0x7E, 0x02, // Yž (U+0059 U+017E)
  0x00, 0x59, 0x20, 0x1A, 0x07, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x07, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x07, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x0A, // Y‹ (U+0059 U+2039)
  0x00, 0x59, 0x20, 0x3A, 0x04, // Y› (U+0059 U+203A)
  0x00, 0x5A, 0x00, 0x43, 0x01, // ZC (U+005A U+0043)
  0x00, 0x5A, 0x00, 0x47, 0x01, // ZG (U+005A U+0047)
  0x00, 0x5A, 0x00, 0x4F, 0x01, // ZO (U+005A U+004F)
  0x00, 0x5A, 0x00, 0x51, 0x01, // ZQ (U+005A U+0051)
  0x00, 0x5A, 0x00, 0xAB, 0x02, // Z« (U+005A U+00AB)
  0x00, 0x5A, 0x00, 0xC7, 0x01, // ZÇ (U+005A U+00C7)
  0x00, 0x5A, 0x00, 0xD2, 0x01, // ZÒ (U+005A U+00D2)
  0x00, 0x5A, 0x00, 0xD3, 0x01, // ZÓ (U+005A U+00D3)
  0x00, 0x5A, 0x00, 0xD4, 0x01, // ZÔ (U+005A U+00D4)
  0x00, 0x5A, 0x00, 0xD5, 0x01, // ZÕ (U+005A U+00D5)
  0x00, 0x5A, 0x00, 0xD6, 0x01, // ZÖ (U+005A U+00D6)
  0x00, 0x5A, 0x00, 0xD8, 0x01, // ZØ (U+005A U+00D8)
  0x00, 0x5A, 0x01, 0x06, 0x01, // ZĆ (U+005A U+0106)
  0x00, 0x5A, 0x01, 0x08, 0x01, // ZĈ (U+005A U+0108)
  0x00, 0x5A, 0x01, 0x0A, 0x01, // ZĊ (U+005A U+010A)
  0x00, 0x5A, 0x01, 0x0C, 0x01, // ZČ (U+005A U+010C)
  0x00, 0x5A, 0x01, 0x1C, 0x01, // ZĜ (U+005A U+011C)
  0x00, 0x5A, 0x01, 0x1E, 0x01, // ZĞ (U+005A U+011E)
  0x00, 0x5A, 0x01, 0x20, 0x01, // ZĠ (U+005A U+0120)
  0x00, 0x5A, 0x01, 0x22, 0x01, // ZĢ (U+005A U+0122)
  0x00, 0x5A, 0x01, 0x4C, 0x01, // ZŌ (U+005A U+014C)
  0x00, 0x5A, 0x01, 0x4E, 0x01, // ZŎ (U+005A U+014E)
  0x00, 0x5A, 0x01, 0x50, 0x01, // ZŐ (U+005A U+0150)
  0x00, 0x5A, 0x01, 0x52, 0x01, // ZŒ (U+005A U+0152)
  0x00, 0x5A, 0x20, 0x39, 0x02, // Z‹ (U+005A U+2039)
  0x00, 0x61, 0x00, 0x22, 0x01, // a" (U+0061 U+0022)
  0x00, 0x61, 0x00, 0x27, 0x01, // a' (U+0061 U+0027)
  0x00, 0x61, 0x20, 0x19, 0x01, // a’ (U+0061 U+2019)
  0x00, 0x61, 0x20, 0x1D, 0x01, // a” (U+0061 U+201D)
  0x00, 0x62, 0x00, 0x22, 0x01, // b" (U+0062 U+0022)
  0x00, 0x62, 0x00, 0x27, 0x01, // b' (U+0062 U+0027)
  0x00, 0x62, 0x00, 0x76, 0x02, // bv (U+0062 U+0076)
  0x00, 0x62, 0x00, 0x77, 0x02, // bw (U+0062 U+0077)
  0x00, 0x62, 0x00, 0x78, 0x02, // bx (U+0062 U+0078)
  0x00, 0x62, 0x00, 0x79, 0x02, // by (U+0062 U+0079)
  0x00, 0x62, 0x00, 0x7A, 0x01, // bz (U+0062 U+007A)
  0x00, 0x62, 0x00, 0xFD, 0x02, // bý (U+0062 U+00FD)
  0x00, 0x62, 0x00, 0xFF, 0x02, // bÿ (U+0062 U+00FF)
  0x00, 0x62, 0x01, 0x75, 0x02, // bŵ (U+0062 U+0175)
  0x00, 0x62, 0x01, 0x77, 0x02, // bŷ (U+0062 U+0177)
  0x00, 0x62, 0x01, 0x7A, 0x01, // bź (U+0062 U+017A)
  0x00, 0x62, 0x01, 0x7C, 0x01, // bż (U+0062 U+017C)
  0x00, 0x62, 0x01, 0x7E, 0x01, // bž (U+0062 U+017E)
  0x00, 0x62, 0x20, 0x19, 0x01, // b’ (U+0062 U+2019)
  0x00, 0x62, 0x20, 0x1D, 0x01, // b” (U+0062 U+201D)
  0x00, 0x65, 0x00, 0x22, 0x01, // e" (U+0065 U+0022)
  0x00, 0x65, 0x00, 0x27, 0x01, // e' (U+0065 U+0027)
  0x00, 0x65, 0x00, 0x76, 0x02, // ev (U+0065 U+0076)
  0x00, 0x65, 0x00, 0x77, 0x02, // ew (U+0065 U+0077)
  0x00, 0x65, 0x00, 0x78, 0x02, // ex (U+0065 U+0078)
  0x00, 0x65, 0x00, 0x79, 0x02, // ey (U+0065 U+0079)
  0x00, 0x65, 0x00, 0x7A, 0x01, // ez (U+0065 U+007A)
  0x00, 0x65, 0x00, 0xFD, 0x02, // eý (U+0065 U+00FD)
  0x00, 0x65, 0x00, 0xFF, 0x02, // eÿ (U+0065 U+00FF)
  0x00, 0x65, 0x01, 0x75, 0x02, // eŵ (U+0065 U+0175)
  0x00, 0x65, 0x01, 0x77, 0x02, // eŷ (U+0065 U+0177)
  0x00, 0x65, 0x01, 0x7A, 0x01, // eź (U+0065 U+017A)
  0x00, 0x65, 0x01, 0x7C, 0x01, // eż (U+0065 U+017C)
  0x00, 0x65, 0x01, 0x7E, 0x01, // ež (U+0065 U+017E)
  0x00, 0x65, 0x20, 0x19, 0x01, // e’ (U+0065 U+2019)
  0x00, 0x65, 0x20, 0x1D, 0x01, // e” (U+0065 U+201D)
  0x00, 0x66, 0x00, 0x2C, 0x02, // f, (U+0066 U+002C)
  0x00, 0x66, 0x00, 0x2E, 0x02, // f. (U+0066 U+002E)
  0x00, 0x66, 0x20, 0x1A, 0x02, // f‚ (U+0066 U+201A)
  0x00, 0x66, 0x20, 0x1E, 0x02, // f„ (U+0066 U+201E)
  0x00, 0x66, 0x20, 0x26, 0x02, // f… (U+0066 U+2026)
  0x00, 0x68, 0x00, 0x22, 0x01, // h" (U+0068 U+0022)
  0x00, 0x68, 0x00, 0x27, 0x01, // h' (U+0068 U+0027)
  0x00, 0x68, 0x20, 0x19, 0x01, // h’ (U+0068 U+2019)
  0x00, 0x68, 0x20, 0x1D, 0x01, // h” (U+0068 U+201D)
  0x00, 0x6D, 0x00, 0x22, 0x01, // m" (U+006D U+0022)
  0x00, 0x6D, 0x00, 0x27, 0x01, // m' (U+006D U+0027)
  0x00, 0x6D, 0x20, 0x19, 0x01, // m’ (U+006D U+2019)
  0x00, 0x6D, 0x20, 0x1D, 0x01, // m” (U+006D U+201D)
  0x00, 0x6E, 0x00, 0x22, 0x01, // n" (U+006E U+0022)
  0x00, 0x6E, 0x00, 0x27, 0x01, // n' (U+006E U+0027)
  0x00, 0x6E, 0x20, 0x19, 0x01, // n’ (U+006E U+2019)
  0x00, 0x6E, 0x20, 0x1D, 0x01, // n” (U+006E U+201D)
  0x00, 0x6F, 0x00, 0x22, 0x01, // o" (U+006F U+0022)
  0x00, 0x6F, 0x00, 0x27, 0x01, // o' (U+006F U+0027)
  0x00, 0x6F, 0x00, 0x76, 0x02, // ov (U+006F U+0076)
  0x00, 0x6F, 0x00, 0x77, 0x02, // ow (U+006F U+0077)
  0x00, 0x6F, 0x00, 0x78, 0x02, // ox (U+006F U+0078)
  0x00, 0x6F, 0x00, 0x79, 0x02, // oy (U+006F U+0079)
  0x00, 0x6F, 0x00, 0x7A, 0x01, // oz (U+006F U+007A)
  0x00, 0x6F, 0x00, 0xFD, 0x02, // oý (U+006F U+00FD)
  0x00, 0x6F, 0x00, 0xFF, 0x02, // oÿ (U+006F U+00FF)
  0x00, 0x6F, 0x01, 0x75, 0x02, // oŵ (U+006F U+0175)
  0x00, 0x6F, 0x01, 0x77, 0x02, // oŷ (U+006F U+0177)
  0x00, 0x6F, 0x01, 0x7A, 0x01, // oź (U+006F U+017A)
  0x00, 0x6F, 0x01, 0x7C, 0x01, // oż (U+006F U+017C)
  0x00, 0x6F, 0x01, 0x7E, 0x01, // ož (U+006F U+017E)
  0x00, 0x6F, 0x20, 0x19, 0x01, // o’ (U+006F U+2019)
  0x00, 0x6F, 0x20, 0x1D, 0x01, // o” (U+006F U+201D)
  0x00, 0x70, 0x00, 0x22, 0x01, // p" (U+0070 U+0022)
  0x00, 0x70, 0x00, 0x27, 0x01, // p' (U+0070 U+0027)
  0x00, 0x70, 0x00, 0x76, 0x02, // pv (U+0070 U+0076)
  0x00, 0x70, 0x00, 0x77, 0x02, // pw (U+0070 U+0077)
  0x00, 0x70, 0x00, 0x78, 0x02, // px (U+0070 U+0078)
  0x00, 0x70, 0x00, 0x79, 0x02, // py (U+0070 U+0079)
  0x00, 0x70, 0x00, 0x7A, 0x01, // pz (U+0070 U+007A)
  0x00, 0x70, 0x00, 0xFD, 0x02, // pý (U+0070 U+00FD)
  0x00, 0x70, 0x00, 0xFF, 0x02, // pÿ (U+0070 U+00FF)
  0x00, 0x70, 0x01, 0x75, 0x02, // pŵ (U+0070 U+0175)
  0x00, 0x70, 0x01, 0x77, 0x02, // pŷ (U+0070 U+0177)
  0x00, 0x70, 0x01, 0x7A, 0x01, // pź (U+0070 U+017A)
  0x00, 0x70, 0x01, 0x7C, 0x01, // pż (U+0070 U+017C)
  0x00, 0x70, 0x01, 0x7E, 0x01, // pž (U+0070 U+017E)
  0x00, 0x70, 0x20, 0x19, 0x01, // p’ (U+0070 U+2019)
  0x00, 0x70, 0x20, 0x1D, 0x01, // p” (U+0070 U+201D)
  0x00, 0x72, 0x00, 0x2C, 0x07, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x07, // r. (U+0072 U+002E)
  0x00, 0x72, 0x00, 0x61, 0x02, // ra (U+0072 U+0061)
  0x00, 0x72, 0x00, 0x63, 0x02, // rc (U+0072 U+0063)
  0x00, 0x72, 0x00, 0x64, 0x02, // rd (U+0072 U+0064)
  0x00, 0x72, 0x00, 0x65, 0x02, // re (U+0072 U+0065)
  0x00, 0x72, 0x00, 0x67, 0x01, // rg (U+0072 U+0067)
  0x00, 0x72, 0x00, 0x6F, 0x02, // ro (U+0072 U+006F)
  0x00, 0x72, 0x00, 0x71, 0x02, // rq (U+0072 U+0071)
  0x00, 0x72, 0x00, 0xE0, 0x02, // rà (U+0072 U+00E0)
  0x00, 0x72, 0x00, 0xE1, 0x02, // rá (U+0072 U+00E1)
  0x00, 0x72, 0x00, 0xE2, 0x02, // râ (U+0072 U+00E2)
  0x00, 0x72, 0x00, 0xE3, 0x02, // rã (U+0072 U+00E3)
  0x00, 0x72, 0x00, 0xE4, 0x02, // rä (U+0072 U+00E4)
  0x00, 0x72, 0x00, 0xE5, 0x02, // rå (U+0072 U+00E5)
  0x00, 0x72, 0x00, 0xE6, 0x02, // ræ (U+0072 U+00E6)
  0x00, 0x72, 0x00, 0xE7, 0x02, // rç (U+0072 U+00E7)
  0x00, 0x72, 0x00, 0xE8, 0x02, // rè (U+0072 U+00E8)
  0x00, 0x72, 0x00, 0xE9, 0x02, // ré (U+0072 U+00E9)
  0x00, 0x72, 0x00, 0xEA, 0x02, // rê (U+0072 U+00EA)
  0x00, 0x72, 0x00, 0xEB, 0x02, // rë (U+0072 U+00EB)
  0x00, 0x72, 0x00, 0xF2, 0x02, // rò (U+0072 U+00F2)
  0x00, 0x72, 0x00, 0xF3, 0x02, // ró (U+0072 U+00F3)
  0x00, 0x72, 0x00, 0xF4, 0x02, // rô (U+0072 U+00F4)
  0x00, 0x72, 0x00, 0xF5, 0x02, // rõ (U+0072 U+00F5)
  0x00, 0x72, 0x00, 0xF6, 0x02, // rö (U+0072 U+00F6)
  0x00, 0x72, 0x00, 0xF8, 0x02, // rø (U+0072 U+00F8)
  0x00, 0x72, 0x01, 0x01, 0x02, // rā (U+0072 U+0101)
  0x00, 0x72, 0x01, 0x03, 0x02, // ră (U+0072 U+0103)
  0x00, 0x72, 0x01, 0x05, 0x02, // rą (U+0072 U+0105)
  0x00, 0x72, 0x01, 0x07, 0x02, // rć (U+0072 U+0107)
  0x00, 0x72, 0x01, 0x09, 0x02, // rĉ (U+0072 U+0109)
  0x00, 0x72, 0x01, 0x0B, 0x02, // rċ (U+0072 U+010B)
  0x00, 0x72, 0x01, 0x0D, 0x02, // rč (U+0072 U+010D)
  0x00, 0x72, 0x01, 0x0F, 0x02, // rď (U+0072 U+010F)
  0x00, 0x72, 0x01, 0x11, 0x02, // rđ (U+0072 U+0111)
  0x00, 0x72, 0x01, 0x13, 0x02, // rē (U+0072 U+0113)
  0x00, 0x72, 0x01, 0x15, 0x02, // rĕ (U+0072 U+0115)
  0x00, 0x72, 0x01, 0x17, 0x02, // rė (U+0072 U+0117)
  0x00, 0x72, 0x01, 0x19, 0x02, // rę (U+0072 U+0119)
  0x00, 0x72, 0x01, 0x1B, 0x02, // rě (U+0072 U+011B)
  0x00, 0x72, 0x01, 0x1D, 0x01, // rĝ (U+0072 U+011D)
  0x00, 0x72, 0x01, 0x1F, 0x01, // rğ (U+0072 U+011F)
  0x00, 0x72, 0x01, 0x21, 0x01, // rġ (U+0072 U+0121)
  0x00, 0x72, 0x01, 0x23, 0x01, // rģ (U+0072 U+0123)
  0x00, 0x72, 0x01, 0x4D, 0x02, // rō (U+0072 U+014D)
  0x00, 0x72, 0x01, 0x4F, 0x02, // rŏ (U+0072 U+014F)
  0x00, 0x72, 0x01, 0x51, 0x02, // rő (U+0072 U+0151)
  0x00, 0x72, 0x01, 0x53, 0x02, // rœ (U+0072 U+0153)
  0x00, 0x72, 0x20, 0x1A, 0x07, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x07, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x07, // r… (U+0072 U+2026)
  0x00, 0x76, 0x00, 0x2C, 0x05, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x05, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x05, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x05, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x05, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x05, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x05, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x05, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x05, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x05, // w… (U+0077 U+2026)
  0x00, 0x78, 0x00, 0x63, 0x02, // xc (U+0078 U+0063)
  0x00, 0x78, 0x00, 0x64, 0x02, // xd (U+0078 U+0064)
  0x00, 0x78, 0x00, 0x65, 0x02, // xe (U+0078 U+0065)
  0x00, 0x78, 0x00, 0x6F, 0x02, // xo (U+0078 U+006F)
  0x00, 0x78, 0x00, 0x71, 0x02, // xq (U+0078 U+0071)
  0x00, 0x78, 0x00, 0xE0, 0x02, // xà (U+0078 U+00E0)
  0x00, 0x78, 0x00, 0xE7, 0x02, // xç (U+0078 U+00E7)
  0x00, 0x78, 0x00, 0xE8, 0x02, // xè (U+0078 U+00E8)
  0x00, 0x78, 0x00, 0xE9, 0x02, // xé (U+0078 U+00E9)
  0x00, 0x78, 0x00, 0xEA, 0x02, // xê (U+0078 U+00EA)
  0x00, 0x78, 0x00, 0xEB, 0x02, // xë (U+0078 U+00EB)
  0x00, 0x78, 0x00, 0xF2, 0x02, // xò (U+0078 U+00F2)
  0x00, 0x78, 0x00, 0xF3, 0x02, // xó (U+0078 U+00F3)
  0x00, 0x78, 0x00, 0xF4, 0x02, // xô (U+0078 U+00F4)
  0x00, 0x78, 0x00, 0xF5, 0x02, // xõ (U+0078 U+00F5)
  0x00, 0x78, 0x00, 0xF6, 0x02, // xö (U+0078 U+00F6)
  0x00, 0x78, 0x00, 0xF8, 0x02, // xø (U+0078 U+00F8)
  0x00, 0x78, 0x01, 0x07, 0x02, // xć (U+0078 U+0107)
  0x00, 0x78, 0x01, 0x09, 0x02, // xĉ (U+0078 U+0109)
  0x00, 0x78, 0x01, 0x0B, 0x02, // xċ (U+0078 U+010B)
  0x00, 0x78, 0x01, 0x0D, 0x02, // xč (U+0078 U+010D)
  0x00, 0x78, 0x01, 0x0F, 0x02, // xď (U+0078 U+010F)
  0x00, 0x78, 0x01, 0x11, 0x02, // xđ (U+0078 U+0111)
  0x00, 0x78, 0x01, 0x13, 0x02, // xē (U+0078 U+0113)
  0x00, 0x78, 0x01, 0x15, 0x02, // xĕ (U+0078 U+0115)
  0x00, 0x78, 0x01, 0x17, 0x02, // xė (U+0078 U+0117)
  0x00, 0x78, 0x01, 0x19, 0x02, // xę (U+0078 U+0119)
  0x00, 0x78, 0x01, 0x1B, 0x02, // xě (U+0078 U+011B)
  0x00, 0x78, 0x01, 0x4D, 0x02, // xō (U+0078 U+014D)
  0x00, 0x78, 0x01, 0x4F, 0x02, // xŏ (U+0078 U+014F)
  0x00, 0x78, 0x01, 0x51, 0x02, // xő (U+0078 U+0151)
  0x00, 0x78, 0x01, 0x53, 0x02, // xœ (U+0078 U+0153)
  0x00, 0x79, 0x00, 0x2C, 0x05, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x05, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x05, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x05, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x05, // y… (U+0079 U+2026)
  0x00, 0xA1, 0x00, 0x54, 0x02, // ¡T (U+00A1 U+0054)
  0x00, 0xA1, 0x00, 0x56, 0x01, // ¡V (U+00A1 U+0056)
  0x00, 0xA1, 0x00, 0x57, 0x01, // ¡W (U+00A1 U+0057)
  0x00, 0xA1, 0x00, 0x59, 0x04, // ¡Y (U+00A1 U+0059)
  0x00, 0xA1, 0x00, 0xDD, 0x04, // ¡Ý (U+00A1 U+00DD)
  0x00, 0xA1, 0x01, 0x62, 0x02, // ¡Ţ (U+00A1 U+0162)
  0x00, 0xA1, 0x01, 0x64, 0x02, // ¡Ť (U+00A1 U+0164)
  0x00, 0xA1, 0x01, 0x66, 0x02, // ¡Ŧ (U+00A1 U+0166)
  0x00, 0xA1, 0x01, 0x74, 0x01, // ¡Ŵ (U+00A1 U+0174)
  0x00, 0xA1, 0x01, 0x76, 0x04, // ¡Ŷ (U+00A1 U+0176)
  0x00, 0xA1, 0x01, 0x78, 0x04, // ¡Ÿ (U+00A1 U+0178)
  0x00, 0xAB, 0x00, 0x54, 0x04, // «T (U+00AB U+0054)
  0x00, 0xAB, 0x00, 0x56, 0x01, // «V (U+00AB U+0056)
  0x00, 0xAB, 0x00, 0x57, 0x01, // «W (U+00AB U+0057)
  0x00, 0xAB, 0x00, 0x59, 0x04, // «Y (U+00AB U+0059)
  0x00, 0xAB, 0x00, 0xDD, 0x04, // «Ý (U+00AB U+00DD)
  0x00, 0xAB, 0x01, 0x62, 0x04, // «Ţ (U+00AB U+0162)
  0x00, 0xAB, 0x01, 0x64, 0x04, // «Ť (U+00AB U+0164)
  0x00, 0xAB, 0x01, 0x66, 0x04, // «Ŧ (U+00AB U+0166)
  0x00, 0xAB, 0x01, 0x74, 0x01, // «Ŵ (U+00AB U+0174)
  0x00, 0xAB, 0x01, 0x76, 0x04, // «Ŷ (U+00AB U+0176)
  0x00, 0xAB, 0x01, 0x78, 0x04, // «Ÿ (U+00AB U+0178)
  0x00, 0xBB, 0x00, 0x54, 0x07, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x56, 0x04, // »V (U+00BB U+0056)
  0x00, 0xBB, 0x00, 0x57, 0x04, // »W (U+00BB U+0057)
  0x00, 0xBB, 0x00, 0x58, 0x02, // »X (U+00BB U+0058)
  0x00, 0xBB, 0x00, 0x59, 0x0A, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x0A, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x07, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x07, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x07, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x74, 0x04, // »Ŵ (U+00BB U+0174)
  0x00, 0xBB, 0x01, 0x76, 0x0A, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x0A, // »Ÿ (U+00BB U+0178)
  0x00, 0xBF, 0x00, 0x54, 0x05, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x00, 0x56, 0x04, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x04, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x05, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x05, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x62, 0x05, // ¿Ţ (U+00BF U+0162)
  0x00, 0xBF, 0x01, 0x64, 0x05, // ¿Ť (U+00BF U+0164)
  0x00, 0xBF, 0x01, 0x66, 0x05, // ¿Ŧ (U+00BF U+0166)
  0x00, 0xBF, 0x01, 0x74, 0x04, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x05, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x05, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x08, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x08, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x43, 0x02, // ÀC (U+00C0 U+0043)
  0x00, 0xC0, 0x00, 0x47, 0x02, // ÀG (U+00C0 U+0047)
  0x00, 0xC0, 0x00, 0x4F, 0x02, // ÀO (U+00C0 U+004F)
  0x00, 0xC0, 0x00, 0x51, 0x02, // ÀQ (U+00C0 U+0051)
  0x00, 0xC0, 0x00, 0x54, 0x08, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x56, 0x05, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x05, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x07, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0xC7, 0x02, // ÀÇ (U+00C0 U+00C7)
  0x00, 0xC0, 0x00, 0xD2, 0x02, // ÀÒ (U+00C0 U+00D2)
  0x00, 0xC0, 0x00, 0xD3, 0x02, // ÀÓ (U+00C0 U+00D3)
  0x00, 0xC0, 0x00, 0xD4, 0x02, // ÀÔ (U+00C0 U+00D4)
  0x00, 0xC0, 0x00, 0xD5, 0x02, // ÀÕ (U+00C0 U+00D5)
  0x00, 0xC0, 0x00, 0xD6, 0x02, // ÀÖ (U+00C0 U+00D6)
  0x00, 0xC0, 0x00, 0xD8, 0x02, // ÀØ (U+00C0 U+00D8)
  0x00, 0xC0, 0x00, 0xDD, 0x07, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x06, 0x02, // ÀĆ (U+00C0 U+0106)
  0x00, 0xC0, 0x01, 0x08, 0x02, // ÀĈ (U+00C0 U+0108)
  0x00, 0xC0, 0x01, 0x0A, 0x02, // ÀĊ (U+00C0 U+010A)
  0x00, 0xC0, 0x01, 0x0C, 0x02, // ÀČ (U+00C0 U+010C)
  0x00, 0xC0, 0x01, 0x1C, 0x02, // ÀĜ (U+00C0 U+011C)
  0x00, 0xC0, 0x01, 0x1E, 0x02, // ÀĞ (U+00C0 U+011E)
  0x00, 0xC0, 0x01, 0x20, 0x02, // ÀĠ (U+00C0 U+0120)
  0x00, 0xC0, 0x01, 0x22, 0x02, // ÀĢ (U+00C0 U+0122)
  0x00, 0xC0, 0x01, 0x4C, 0x02, // ÀŌ (U+00C0 U+014C)
  0x00, 0xC0, 0x01, 0x4E, 0x02, // ÀŎ (U+00C0 U+014E)
  0x00, 0xC0, 0x01, 0x50, 0x02, // ÀŐ (U+00C0 U+0150)
  0x00, 0xC0, 0x01, 0x52, 0x02, // ÀŒ (U+00C0 U+0152)
  0x00, 0xC0, 0x01, 0x62, 0x08, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x08, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x08, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x74, 0x05, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x76, 0x07, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x07, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x19, 0x08, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x08, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x08, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x08, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x43, 0x02, // ÁC (U+00C1 U+0043)
  0x00, 0xC1, 0x00, 0x47, 0x02, // ÁG (U+00C1 U+0047)
  0x00, 0xC1, 0x00, 0x4F, 0x02, // ÁO (U+00C1 U+004F)
  0x00, 0xC1, 0x00, 0x51, 0x02, // ÁQ (U+00C1 U+0051)
  0x00, 0xC1, 0x00, 0x54, 0x08, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x56, 0x05, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x05, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x07, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0xC7, 0x02, // ÁÇ (U+00C1 U+00C7)
  0x00, 0xC1, 0x00, 0xD2, 0x02, // ÁÒ (U+00C1 U+00D2)
  0x00, 0xC1, 0x00, 0xD3, 0x02, // ÁÓ (U+00C1 U+00D3)
  0x00, 0xC1, 0x00, 0xD4, 0x02, // ÁÔ (U+00C1 U+00D4)
  0x00, 0xC1, 0x00, 0xD5, 0x02, // ÁÕ (U+00C1 U+00D5)
  0x00, 0xC1, 0x00, 0xD6, 0x02, // ÁÖ (U+00C1 U+00D6)
  0x00, 0xC1, 0x00, 0xD8, 0x02, // ÁØ (U+00C1 U+00D8)
  0x00, 0xC1, 0x00, 0xDD, 0x07, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x06, 0x02, // ÁĆ (U+00C1 U+0106)
  0x00, 0xC1, 0x01, 0x08, 0x02, // ÁĈ (U+00C1 U+0108)
  0x00, 0xC1, 0x01, 0x0A, 0x02, // ÁĊ (U+00C1 U+010A)
  0x00, 0xC1, 0x01, 0x0C, 0x02, // ÁČ (U+00C1 U+010C)
  0x00, 0xC1, 0x01, 0x1C, 0x02, // ÁĜ (U+00C1 U+011C)
  0x00, 0xC1, 0x01, 0x1E, 0x02, // ÁĞ (U+00C1 U+011E)
  0x00, 0xC1, 0x01, 0x20, 0x02, // ÁĠ (U+00C1 U+0120)
  0x00, 0xC1, 0x01, 0x22, 0x02, // ÁĢ (U+00C1 U+0122)
  0x00, 0xC1, 0x01, 0x4C, 0x02, // ÁŌ (U+00C1 U+014C)
  0x00, 0xC1, 0x01, 0x4E, 0x02, // ÁŎ (U+00C1 U+014E)
  0x00, 0xC1, 0x01, 0x50, 0x02, // ÁŐ (U+00C1 U+0150)
  0x00, 0xC1, 0x01, 0x52, 0x02, // ÁŒ (U+00C1 U+0152)
  0x00, 0xC1, 0x01, 0x62, 0x08, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x08, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x08, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x74, 0x05, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x76, 0x07, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x07, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x19, 0x08, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x08, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x08, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x08, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x43, 0x02, // ÂC (U+00C2 U+0043)
  0x00, 0xC2, 0x00, 0x47, 0x02, // ÂG (U+00C2 U+0047)
  0x00, 0xC2, 0x00, 0x4F, 0x02, // ÂO (U+00C2 U+004F)
  0x00, 0xC2, 0x00, 0x51, 0x02, // ÂQ (U+00C2 U+0051)
  0x00, 0xC2, 0x00, 0x54, 0x08, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x56, 0x05, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x05, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x07, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0xC7, 0x02, // ÂÇ (U+00C2 U+00C7)
  0x00, 0xC2, 0x00, 0xD2, 0x02, // ÂÒ (U+00C2 U+00D2)
  0x00, 0xC2, 0x00, 0xD3, 0x02, // ÂÓ (U+00C2 U+00D3)
  0x00, 0xC2, 0x00, 0xD4, 0x02, // ÂÔ (U+00C2 U+00D4)
  0x00, 0xC2, 0x00, 0xD5, 0x02, // ÂÕ (U+00C2 U+00D5)
  0x00, 0xC2, 0x00, 0xD6, 0x02, // ÂÖ (U+00C2 U+00D6)
  0x00, 0xC2, 0x00, 0xD8, 0x02, // ÂØ (U+00C2 U+00D8)
  0x00, 0xC2, 0x00, 0xDD, 0x07, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x06, 0x02, // ÂĆ (U+00C2 U+0106)
  0x00, 0xC2, 0x01, 0x08, 0x02, // ÂĈ (U+00C2 U+0108)
  0x00, 0xC2, 0x01, 0x0A, 0x02, // ÂĊ (U+00C2 U+010A)
  0x00, 0xC2, 0x01, 0x0C, 0x02, // ÂČ (U+00C2 U+010C)
  0x00, 0xC2, 0x01, 0x1C, 0x02, // ÂĜ (U+00C2 U+011C)
  0x00, 0xC2, 0x01, 0x1E, 0x02, // ÂĞ (U+00C2 U+011E)
  0x00, 0xC2, 0x01, 0x20, 0x02, // ÂĠ (U+00C2 U+0120)
  0x00, 0xC2, 0x01, 0x22, 0x02, // ÂĢ (U+00C2 U+0122)
  0x00, 0xC2, 0x01, 0x4C, 0x02, // ÂŌ (U+00C2 U+014C)
  0x00, 0xC2, 0x01, 0x4E, 0x02, // ÂŎ (U+00C2 U+014E)
  0x00, 0xC2, 0x01, 0x50, 0x02, // ÂŐ (U+00C2 U+0150)
  0x00, 0xC2, 0x01, 0x52, 0x02, // ÂŒ (U+00C2 U+0152)
  0x00, 0xC2, 0x01, 0x62, 0x08, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x08, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x08, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x74, 0x05, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x76, 0x07, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x07, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x19, 0x08, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x08, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x08, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x08, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x43, 0x02, // ÃC (U+00C3 U+0043)
  0x00, 0xC3, 0x00, 0x47, 0x02, // ÃG (U+00C3 U+0047)
  0x00, 0xC3, 0x00, 0x4F, 0x02, // ÃO (U+00C3 U+004F)
  0x00, 0xC3, 0x00, 0x51, 0x02, // ÃQ (U+00C3 U+0051)
  0x00, 0xC3, 0x00, 0x54, 0x08, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x56, 0x05, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x05, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x07, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0xC7, 0x02, // ÃÇ (U+00C3 U+00C7)
  0x00, 0xC3, 0x00, 0xD2, 0x02, // ÃÒ (U+00C3 U+00D2)
  0x00, 0xC3, 0x00, 0xD3, 0x02, // ÃÓ (U+00C3 U+00D3)
  0x00, 0xC3, 0x00, 0xD4, 0x02, // ÃÔ (U+00C3 U+00D4)
  0x00, 0xC3, 0x00, 0xD5, 0x02, // ÃÕ (U+00C3 U+00D5)
  0x00, 0xC3, 0x00, 0xD6, 0x02, // ÃÖ (U+00C3 U+00D6)
  0x00, 0xC3, 0x00, 0xD8, 0x02, // ÃØ (U+00C3 U+00D8)
  0x00, 0xC3, 0x00, 0xDD, 0x07, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x06, 0x02, // ÃĆ (U+00C3 U+0106)
  0x00, 0xC3, 0x01, 0x08, 0x02, // ÃĈ (U+00C3 U+0108)
  0x00, 0xC3, 0x01, 0x0A, 0x02, // ÃĊ (U+00C3 U+010A)
  0x00, 0xC3, 0x01, 0x0C, 0x02, // ÃČ (U+00C3 U+010C)
  0x00, 0xC3, 0x01, 0x1C, 0x02, // ÃĜ (U+00C3 U+011C)
  0x00, 0xC3, 0x01, 0x1E, 0x02, // ÃĞ (U+00C3 U+011E)
  0x00, 0xC3, 0x01, 0x20, 0x02, // ÃĠ (U+00C3 U+0120)
  0x00, 0xC3, 0x01, 0x22, 0x02, // ÃĢ (U+00C3 U+0122)
  0x00, 0xC3, 0x01, 0x4C, 0x02, // ÃŌ (U+00C3 U+014C)
  0x00, 0xC3, 0x01, 0x4E, 0x02, // ÃŎ (U+00C3 U+014E)
  0x00, 0xC3, 0x01, 0x50, 0x02, // ÃŐ (U+00C3 U+0150)
  0x00, 0xC3, 0x01, 0x52, 0x02, // ÃŒ (U+00C3 U+0152)
  0x00, 0xC3, 0x01, 0x62, 0x08, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x08, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x08, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x74, 0x05, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x76, 0x07, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x07, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x19, 0x08, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x08, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x08, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x08, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x43, 0x02, // ÄC (U+00C4 U+0043)
  0x00, 0xC4, 0x00, 0x47, 0x02, // ÄG (U+00C4 U+0047)
  0x00, 0xC4, 0x00, 0x4F, 0x02, // ÄO (U+00C4 U+004F)
  0x00, 0xC4, 0x00, 0x51, 0x02, // ÄQ (U+00C4 U+0051)
  0x00, 0xC4, 0x00, 0x54, 0x08, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x56, 0x05, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x05, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x07, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0xC7, 0x02, // ÄÇ (U+00C4 U+00C7)
  0x00, 0xC4, 0x00, 0xD2, 0x02, // ÄÒ (U+00C4 U+00D2)
  0x00, 0xC4, 0x00, 0xD3, 0x02, // ÄÓ (U+00C4 U+00D3)
  0x00, 0xC4, 0x00, 0xD4, 0x02, // ÄÔ (U+00C4 U+00D4)
  0x00, 0xC4, 0x00, 0xD5, 0x02, // ÄÕ (U+00C4 U+00D5)
  0x00, 0xC4, 0x00, 0xD6, 0x02, // ÄÖ (U+00C4 U+00D6)
  0x00, 0xC4, 0x00, 0xD8, 0x02, // ÄØ (U+00C4 U+00D8)
  0x00, 0xC4, 0x00, 0xDD, 0x07, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x06, 0x02, // ÄĆ (U+00C4 U+0106)
  0x00, 0xC4, 0x01, 0x08, 0x02, // ÄĈ (U+00C4 U+0108)
  0x00, 0xC4, 0x01, 0x0A, 0x02, // ÄĊ (U+00C4 U+010A)
  0x00, 0xC4, 0x01, 0x0C, 0x02, // ÄČ (U+00C4 U+010C)
  0x00, 0xC4, 0x01, 0x1C, 0x02, // ÄĜ (U+00C4 U+011C)
  0x00, 0xC4, 0x01, 0x1E, 0x02, // ÄĞ (U+00C4 U+011E)
  0x00, 0xC4, 0x01, 0x20, 0x02, // ÄĠ (U+00C4 U+0120)
  0x00, 0xC4, 0x01, 0x22, 0x02, // ÄĢ (U+00C4 U+0122)
  0x00, 0xC4, 0x01, 0x4C, 0x02, // ÄŌ (U+00C4 U+014C)
  0x00, 0xC4, 0x01, 0x4E, 0x02, // ÄŎ (U+00C4 U+014E)
  0x00, 0xC4, 0x01, 0x50, 0x02, // ÄŐ (U+00C4 U+0150)
  0x00, 0xC4, 0x01, 0x52, 0x02, // ÄŒ (U+00C4 U+0152)
  0x00, 0xC4, 0x01, 0x62, 0x08, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x08, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x08, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x74, 0x05, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x76, 0x07, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x07, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x19, 0x08, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x08, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x08, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x08, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x43, 0x02, // ÅC (U+00C5 U+0043)
  0x00, 0xC5, 0x00, 0x47, 0x02, // ÅG (U+00C5 U+0047)
  0x00, 0xC5, 0x00, 0x4F, 0x02, // ÅO (U+00C5 U+004F)
  0x00, 0xC5, 0x00, 0x51, 0x02, // ÅQ (U+00C5 U+0051)
  0x00, 0xC5, 0x00, 0x54, 0x08, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x56, 0x05, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x05, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x07, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0xC7, 0x02, // ÅÇ (U+00C5 U+00C7)
  0x00, 0xC5, 0x00, 0xD2, 0x02, // ÅÒ (U+00C5 U+00D2)
  0x00, 0xC5, 0x00, 0xD3, 0x02, // ÅÓ (U+00C5 U+00D3)
  0x00, 0xC5, 0x00, 0xD4, 0x02, // ÅÔ (U+00C5 U+00D4)
  0x00, 0xC5, 0x00, 0xD5, 0x02, // ÅÕ (U+00C5 U+00D5)
  0x00, 0xC5, 0x00, 0xD6, 0x02, // ÅÖ (U+00C5 U+00D6)
  0x00, 0xC5, 0x00, 0xD8, 0x02, // ÅØ (U+00C5 U+00D8)
  0x00, 0xC5, 0x00, 0xDD, 0x07, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x06, 0x02, // ÅĆ (U+00C5 U+0106)
  0x00, 0xC5, 0x01, 0x08, 0x02, // ÅĈ (U+00C5 U+0108)
  0x00, 0xC5, 0x01, 0x0A, 0x02, // ÅĊ (U+00C5 U+010A)
  0x00, 0xC5, 0x01, 0x0C, 0x02, // ÅČ (U+00C5 U+010C)
  0x00, 0xC5, 0x01, 0x1C, 0x02, // ÅĜ (U+00C5 U+011C)
  0x00, 0xC5, 0x01, 0x1E, 0x02, // ÅĞ (U+00C5 U+011E)
  0x00, 0xC5, 0x01, 0x20, 0x02, // ÅĠ (U+00C5 U+0120)
  0x00, 0xC5, 0x01, 0x22, 0x02, // ÅĢ (U+00C5 U+0122)
  0x00, 0xC5, 0x01, 0x4C, 0x02, // ÅŌ (U+00C5 U+014C)
  0x00, 0xC5, 0x01, 0x4E, 0x02, // ÅŎ (U+00C5 U+014E)
  0x00, 0xC5, 0x01, 0x50, 0x02, // ÅŐ (U+00C5 U+0150)
  0x00, 0xC5, 0x01, 0x52, 0x02, // ÅŒ (U+00C5 U+0152)
  0x00, 0xC5, 0x01, 0x62, 0x08, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x08, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x08, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x74, 0x05, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x76, 0x07, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x07, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x19, 0x08, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x08, // Å” (U+00C5 U+201D)
  0x00, 0xC7, 0x00, 0x43, 0x02, // ÇC (U+00C7 U+0043)
  0x00, 0xC7, 0x00, 0x47, 0x02, // ÇG (U+00C7 U+0047)
  0x00, 0xC7, 0x00, 0x4F, 0x02, // ÇO (U+00C7 U+004F)
  0x00, 0xC7, 0x00, 0x51, 0x02, // ÇQ (U+00C7 U+0051)
  0x00, 0xC7, 0x00, 0xAB, 0x02, // Ç« (U+00C7 U+00AB)
  0x00, 0xC7, 0x00, 0xC7, 0x02, // ÇÇ (U+00C7 U+00C7)
  0x00, 0xC7, 0x00, 0xD2, 0x02, // ÇÒ (U+00C7 U+00D2)
  0x00, 0xC7, 0x00, 0xD3, 0x02, // ÇÓ (U+00C7 U+00D3)
  0x00, 0xC7, 0x00, 0xD4, 0x02, // ÇÔ (U+00C7 U+00D4)
  0x00, 0xC7, 0x00, 0xD5, 0x02, // ÇÕ (U+00C7 U+00D5)
  0x00, 0xC7, 0x00, 0xD6, 0x02, // ÇÖ (U+00C7 U+00D6)
  0x00, 0xC7, 0x00, 0xD8, 0x02, // ÇØ (U+00C7 U+00D8)
  0x00, 0xC7, 0x01, 0x06, 0x02, // ÇĆ (U+00C7 U+0106)
  0x00, 0xC7, 0x01, 0x08, 0x02, // ÇĈ (U+00C7 U+0108)
  0x00, 0xC7, 0x01, 0x0A, 0x02, // ÇĊ (U+00C7 U+010A)
  0x00, 0xC7, 0x01, 0x0C, 0x02, // ÇČ (U+00C7 U+010C)
  0x00, 0xC7, 0x01, 0x1C, 0x02, // ÇĜ (U+00C7 U+011C)
  0x00, 0xC7, 0x01, 0x1E, 0x02, // ÇĞ (U+00C7 U+011E)
  0x00, 0xC7, 0x01, 0x20, 0x02, // ÇĠ (U+00C7 U+0120)
  0x00, 0xC7, 0x01, 0x22, 0x02, // ÇĢ (U+00C7 U+0122)
  0x00, 0xC7, 0x01, 0x4C, 0x02, // ÇŌ (U+00C7 U+014C)
  0x00, 0xC7, 0x01, 0x4E, 0x02, // ÇŎ (U+00C7 U+014E)
  0x00, 0xC7, 0x01, 0x50, 0x02, // ÇŐ (U+00C7 U+0150)
  0x00, 0xC7, 0x01, 0x52, 0x02, // ÇŒ (U+00C7 U+0152)
  0x00, 0xC7, 0x20, 0x39, 0x02, // Ç‹ (U+00C7 U+2039)
  0x00, 0xD0, 0x00, 0x2C, 0x05, // Ð, (U+00D0 U+002C)
  0x00, 0xD0, 0x00, 0x2E, 0x05, // Ð. (U+00D0 U+002E)
  0x00, 0xD0, 0x00, 0x41, 0x02, // ÐA (U+00D0 U+0041)
  0x00, 0xD0, 0x00, 0x54, 0x04, // ÐT (U+00D0 U+0054)
  0x00, 0xD0, 0x00, 0x56, 0x01, // ÐV (U+00D0 U+0056)
  0x00, 0xD0, 0x00, 0x57, 0x01, // ÐW (U+00D0 U+0057)
  0x00, 0xD0, 0x00, 0x58, 0x02, // ÐX (U+00D0 U+0058)
  0x00, 0xD0, 0x00, 0x59, 0x01, // ÐY (U+00D0 U+0059)
  0x00, 0xD0, 0x00, 0x5A, 0x01, // ÐZ (U+00D0 U+005A)
  0x00, 0xD0, 0x00, 0xC0, 0x02, // ÐÀ (U+00D0 U+00C0)
  0x00, 0xD0, 0x00, 0xC1, 0x02, // ÐÁ (U+00D0 U+00C1)
  0x00, 0xD0, 0x00, 0xC2, 0x02, // ÐÂ (U+00D0 U+00C2)
  0x00, 0xD0, 0x00, 0xC3, 0x02, // ÐÃ (U+00D0 U+00C3)
  0x00, 0xD0, 0x00, 0xC4, 0x02, // ÐÄ (U+00D0 U+00C4)
  0x00, 0xD0, 0x00, 0xC5, 0x02, // ÐÅ (U+00D0 U+00C5)
  0x00, 0xD0, 0x00, 0xDD, 0x01, // ÐÝ (U+00D0 U+00DD)
  0x00, 0xD0, 0x01, 0x00, 0x02, // ÐĀ (U+00D0 U+0100)
  0x00, 0xD0, 0x01, 0x02, 0x02, // ÐĂ (U+00D0 U+0102)
  0x00, 0xD0, 0x01, 0x04, 0x02, // ÐĄ (U+00D0 U+0104)
  0x00, 0xD0, 0x01, 0x62, 0x04, // ÐŢ (U+00D0 U+0162)
  0x00, 0xD0, 0x01, 0x64, 0x04, // ÐŤ (U+00D0 U+0164)
  0x00, 0xD0, 0x01, 0x66, 0x04, // ÐŦ (U+00D0 U+0166)
  0x00, 0xD0, 0x01, 0x74, 0x01, // ÐŴ (U+00D0 U+0174)
  0x00, 0xD0, 0x01, 0x76, 0x01, // ÐŶ (U+00D0 U+0176)
  0x00, 0xD0, 0x01, 0x78, 0x01, // ÐŸ (U+00D0 U+0178)
  0x00, 0xD0, 0x01, 0x79, 0x01, // ÐŹ (U+00D0 U+0179)
  0x00, 0xD0, 0x01, 0x7B, 0x01, // ÐŻ (U+00D0 U+017B)
  0x00, 0xD0, 0x01, 0x7D, 0x01, // ÐŽ (U+00D0 U+017D)
  0x00, 0xD0, 0x20, 0x1A, 0x05, // Ð‚ (U+00D0 U+201A)
  0x00, 0xD0, 0x20, 0x1E, 0x05, // Ð„ (U+00D0 U+201E)
  0x00, 0xD0, 0x20, 0x26, 0x05, // Ð… (U+00D0 U+2026)
  0x00, 0xD2, 0x00, 0x2C, 0x05, // Ò, (U+00D2 U+002C)
  0x00, 0xD2, 0x00, 0x2E, 0x05, // Ò. (U+00D2 U+002E)
  0x00, 0xD2, 0x00, 0x41, 0x02, // ÒA (U+00D2 U+0041)
  0x00, 0xD2, 0x00, 0x54, 0x04, // ÒT (U+00D2 U+0054)
  0x00, 0xD2, 0x00, 0x56, 0x01, // ÒV (U+00D2 U+0056)
  0x00, 0xD2, 0x00, 0x57, 0x01, // ÒW (U+00D2 U+0057)
  0x00, 0xD2, 0x00, 0x58, 0x02, // ÒX (U+00D2 U+0058)
  0x00, 0xD2, 0x00, 0x59, 0x01, // ÒY (U+00D2 U+0059)
  0x00, 0xD2, 0x00, 0x5A, 0x01, // ÒZ (U+00D2 U+005A)
  0x00, 0xD2, 0x00, 0xC0, 0x02, // ÒÀ (U+00D2 U+00C0)
  0x00, 0xD2, 0x00, 0xC1, 0x02, // ÒÁ (U+00D2 U+00C1)
  0x00, 0xD2, 0x00, 0xC2, 0x02, // ÒÂ (U+00D2 U+00C2)
  0x00, 0xD2, 0x00, 0xC3, 0x02, // ÒÃ (U+00D2 U+00C3)
  0x00, 0xD2, 0x00, 0xC4, 0x02, // ÒÄ (U+00D2 U+00C4)
  0x00, 0xD2, 0x00, 0xC5, 0x02, // ÒÅ (U+00D2 U+00C5)
  0x00, 0xD2, 0x00, 0xDD, 0x01, // ÒÝ (U+00D2 U+00DD)
  0x00, 0xD2, 0x01, 0x00, 0x02, // ÒĀ (U+00D2 U+0100)
  0x00, 0xD2, 0x01, 0x02, 0x02, // ÒĂ (U+00D2 U+0102)
  0x00, 0xD2, 0x01, 0x04, 0x02, // ÒĄ (U+00D2 U+0104)
  0x00, 0xD2, 0x01, 0x62, 0x04, // ÒŢ (U+00D2 U+0162)
  0x00, 0xD2, 0x01, 0x64, 0x04, // ÒŤ (U+00D2 U+0164)
  0x00, 0xD2, 0x01, 0x66, 0x04, // ÒŦ (U+00D2 U+0166)
  0x00, 0xD2, 0x01, 0x74, 0x01, // ÒŴ (U+00D2 U+0174)
  0x00, 0xD2, 0x01, 0x76, 0x01, // ÒŶ (U+00D2 U+0176)
  0x00, 0xD2, 0x01, 0x78, 0x01, // ÒŸ (U+00D2 U+0178)
  0x00, 0xD2, 0x01, 0x79, 0x01, // ÒŹ (U+00D2 U+0179)
  0x00, 0xD2, 0x01, 0x7B, 0x01, // ÒŻ (U+00D2 U+017B)
  0x00, 0xD2, 0x01, 0x7D, 0x01, // ÒŽ (U+00D2 U+017D)
  0x00, 0xD2, 0x20, 0x1A, 0x05, // Ò‚ (U+00D2 U+201A)
  0x00, 0xD2, 0x20, 0x1E, 0x05, // Ò„ (U+00D2 U+201E)
  0x00, 0xD2, 0x20, 0x26, 0x05, // Ò… (U+00D2 U+2026)
  0x00, 0xD3, 0x00, 0x2C, 0x05, // Ó, (U+00D3 U+002C)
  0x00, 0xD3, 0x00, 0x2E, 0x05, // Ó. (U+00D3 U+002E)
  0x00, 0xD3, 0x00, 0x41, 0x02, // ÓA (U+00D3 U+0041)
  0x00, 0xD3, 0x00, 0x54, 0x04, // ÓT (U+00D3 U+0054)
  0x00, 0xD3, 0x00, 0x56, 0x01, // ÓV (U+00D3 U+0056)
  0x00, 0xD3, 0x00, 0x57, 0x01, // ÓW (U+00D3 U+0057)
  0x00, 0xD3, 0x00, 0x58, 0x02, // ÓX (U+00D3 U+0058)
  0x00, 0xD3, 0x00, 0x59, 0x01, // ÓY (U+00D3 U+0059)
  0x00, 0xD3, 0x00, 0x5A, 0x01, // ÓZ (U+00D3 U+005A)
  0x00, 0xD3, 0x00, 0xC0, 0x02, // ÓÀ (U+00D3 U+00C0)
  0x00, 0xD3, 0x00, 0xC1, 0x02, // ÓÁ (U+00D3 U+00C1)
  0x00, 0xD3, 0x00, 0xC2, 0x02, // ÓÂ (U+00D3 U+00C2)
  0x00, 0xD3, 0x00, 0xC3, 0x02, // ÓÃ (U+00D3 U+00C3)
  0x00, 0xD3, 0x00, 0xC4, 0x02, // ÓÄ (U+00D3 U+00C4)
  0x00, 0xD3, 0x00, 0xC5, 0x02, // ÓÅ (U+00D3 U+00C5)
  0x00, 0xD3, 0x00, 0xDD, 0x01, // ÓÝ (U+00D3 U+00DD)
  0x00, 0xD3, 0x01, 0x00, 0x02, // ÓĀ (U+00D3 U+0100)
  0x00, 0xD3, 0x01, 0x02, 0x02, // ÓĂ (U+00D3 U+0102)
  0x00, 0xD3, 0x01, 0x04, 0x02, // ÓĄ (U+00D3 U+0104)
  0x00, 0xD3, 0x01, 0x62, 0x04, // ÓŢ (U+00D3 U+0162)
  0x00, 0xD3, 0x01, 0x64, 0x04, // ÓŤ (U+00D3 U+0164)
  0x00, 0xD3, 0x01, 0x66, 0x04, // ÓŦ (U+00D3 U+0166)
  0x00, 0xD3, 0x01, 0x74, 0x01, // ÓŴ (U+00D3 U+0174)
  0x00, 0xD3, 0x01, 0x76, 0x01, // ÓŶ (U+00D3 U+0176)
  0x00, 0xD3, 0x01, 0x78, 0x01, // ÓŸ (U+00D3 U+0178)
  0x00, 0xD3, 0x01, 0x79, 0x01, // ÓŹ (U+00D3 U+0179)
  0x00, 0xD3, 0x01, 0x7B, 0x01, // ÓŻ (U+00D3 U+017B)
  0x00, 0xD3, 0x01, 0x7D, 0x01, // ÓŽ (U+00D3 U+017D)
  0x00, 0xD3, 0x20, 0x1A, 0x05, // Ó‚ (U+00D3 U+201A)
  0x00, 0xD3, 0x20, 0x1E, 0x05, // Ó„ (U+00D3 U+201E)
  0x00, 0xD3, 0x20, 0x26, 0x05, // Ó… (U+00D3 U+2026)
  0x00, 0xD4, 0x00, 0x2C, 0x05, // Ô, (U+00D4 U+002C)
  0x00, 0xD4, 0x00, 0x2E, 0x05, // Ô. (U+00D4 U+002E)
  0x00, 0xD4, 0x00, 0x41, 0x02, // ÔA (U+00D4 U+0041)
  0x00, 0xD4, 0x00, 0x54, 0x04, // ÔT (U+00D4 U+0054)
  0x00, 0xD4, 0x00, 0x56, 0x01, // ÔV (U+00D4 U+0056)
  0x00, 0xD4, 0x00, 0x57, 0x01, // ÔW (U+00D4 U+0057)
  0x00, 0xD4, 0x00, 0x58, 0x02, // ÔX (U+00D4 U+0058)
  0x00, 0xD4, 0x00, 0x59, 0x01, // ÔY (U+00D4 U+0059)
  0x00, 0xD4, 0x00, 0x5A, 0x01, // ÔZ (U+00D4 U+005A)
  0x00, 0xD4, 0x00, 0xC0, 0x02, // ÔÀ (U+00D4 U+00C0)
  0x00, 0xD4, 0x00, 0xC1, 0x02, // ÔÁ (U+00D4 U+00C1)
  0x00, 0xD4, 0x00, 0xC2, 0x02, // ÔÂ (U+00D4 U+00C2)
  0x00, 0xD4, 0x00, 0xC3, 0x02, // ÔÃ (U+00D4 U+00C3)
  0x00, 0xD4, 0x00, 0xC4, 0x02, // ÔÄ (U+00D4 U+00C4)
  0x00, 0xD4, 0x00, 0xC5, 0x02, // ÔÅ (U+00D4 U+00C5)
  0x00, 0xD4, 0x00, 0xDD, 0x01, // ÔÝ (U+00D4 U+00DD)
  0x00, 0xD4, 0x01, 0x00, 0x02, // ÔĀ (U+00D4 U+0100)
  0x00, 0xD4, 0x01, 0x02, 0x02, // ÔĂ (U+00D4 U+0102)
  0x00, 0xD4, 0x01, 0x04, 0x02, // ÔĄ (U+00D4 U+0104)
  0x00, 0xD4, 0x01, 0x62, 0x04, // ÔŢ (U+00D4 U+0162)
  0x00, 0xD4, 0x01, 0x64, 0x04, // ÔŤ (U+00D4 U+0164)
  0x00, 0xD4, 0x01, 0x66, 0x04, // ÔŦ (U+00D4 U+0166)
  0x00, 0xD4, 0x01, 0x74, 0x01, // ÔŴ (U+00D4 U+0174)
  0x00, 0xD4, 0x01, 0x76, 0x01, // ÔŶ (U+00D4 U+0176)
  0x00, 0xD4, 0x01, 0x78, 0x01, // ÔŸ (U+00D4 U+0178)
  0x00, 0xD4, 0x01, 0x79, 0x01, // ÔŹ (U+00D4 U+0179)
  0x00, 0xD4, 0x01, 0x7B, 0x01, // ÔŻ (U+00D4 U+017B)
  0x00, 0xD4, 0x01, 0x7D, 0x01, // ÔŽ (U+00D4 U+017D)
  0x00, 0xD4, 0x20, 0x1A, 0x05, // Ô‚ (U+00D4 U+201A)
  0x00, 0xD4, 0x20, 0x1E, 0x05, // Ô„ (U+00D4 U+201E)
  0x00, 0xD4, 0x20, 0x26, 0x05, // Ô… (U+00D4 U+2026)
  0x00, 0xD5, 0x00, 0x2C, 0x05, // Õ, (U+00D5 U+002C)
  0x00, 0xD5, 0x00, 0x2E, 0x05, // Õ. (U+00D5 U+002E)
  0x00, 0xD5, 0x00, 0x41, 0x02, // ÕA (U+00D5 U+0041)
  0x00, 0xD5, 0x00, 0x54, 0x04, // ÕT (U+00D5 U+0054)
  0x00, 0xD5, 0x00, 0x56, 0x01, // ÕV (U+00D5 U+0056)
  0x00, 0xD5, 0x00, 0x57, 0x01, // ÕW (U+00D5 U+0057)
  0x00, 0xD5, 0x00, 0x58, 0x02, // ÕX (U+00D5 U+0058)
  0x00, 0xD5, 0x00, 0x59, 0x01, // ÕY (U+00D5 U+0059)
  0x00, 0xD5, 0x00, 0x5A, 0x01, // ÕZ (U+00D5 U+005A)
  0x00, 0xD5, 0x00, 0xC0, 0x02, // ÕÀ (U+00D5 U+00C0)
  0x00, 0xD5, 0x00, 0xC1, 0x02, // ÕÁ (U+00D5 U+00C1)
  0x00, 0xD5, 0x00, 0xC2, 0x02, // ÕÂ (U+00D5 U+00C2)
  0x00, 0xD5, 0x00, 0xC3, 0x02, // ÕÃ (U+00D5 U+00C3)
  0x00, 0xD5, 0x00, 0xC4, 0x02, // ÕÄ (U+00D5 U+00C4)
  0x00, 0xD5, 0x00, 0xC5, 0x02, // ÕÅ (U+00D5 U+00C5)
  0x00, 0xD5, 0x00, 0xDD, 0x01, // ÕÝ (U+00D5 U+00DD)
  0x00, 0xD5, 0x01, 0x00, 0x02, // ÕĀ (U+00D5 U+0100)
  0x00, 0xD5, 0x01, 0x02, 0x02, // ÕĂ (U+00D5 U+0102)
  0x00, 0xD5, 0x01, 0x04, 0x02, // ÕĄ (U+00D5 U+0104)
  0x00, 0xD5, 0x01, 0x62, 0x04, // ÕŢ (U+00D5 U+0162)
  0x00, 0xD5, 0x01, 0x64, 0x04, // ÕŤ (U+00D5 U+0164)
  0x00, 0xD5, 0x01, 0x66, 0x04, // ÕŦ (U+00D5 U+0166)
  0x00, 0xD5, 0x01, 0x74, 0x01, // ÕŴ (U+00D5 U+0174)
  0x00, 0xD5, 0x01, 0x76, 0x01, // ÕŶ (U+00D5 U+0176)
  0x00, 0xD5, 0x01, 0x78, 0x01, // ÕŸ (U+00D5 U+0178)
  0x00, 0xD5, 0x01, 0x79, 0x01, // ÕŹ (U+00D5 U+0179)
  0x00, 0xD5, 0x01, 0x7B, 0x01, // ÕŻ (U+00D5 U+017B)
  0x00, 0xD5, 0x01, 0x7D, 0x01, // ÕŽ (U+00D5 U+017D)
  0x00, 0xD5, 0x20, 0x1A, 0x05, // Õ‚ (U+00D5 U+201A)
  0x00, 0xD5, 0x20, 0x1E, 0x05, // Õ„ (U+00D5 U+201E)
  0x00, 0xD5, 0x20, 0x26, 0x05, // Õ… (U+00D5 U+2026)
  0x00, 0xD6, 0x00, 0x2C, 0x05, // Ö, (U+00D6 U+002C)
  0x00, 0xD6, 0x00, 0x2E, 0x05, // Ö. (U+00D6 U+002E)
  0x00, 0xD6, 0x00, 0x41, 0x02, // ÖA (U+00D6 U+0041)
  0x00, 0xD6, 0x00, 0x54, 0x04, // ÖT (U+00D6 U+0054)
  0x00, 0xD6, 0x00, 0x56, 0x01, // ÖV (U+00D6 U+0056)
  0x00, 0xD6, 0x00, 0x57, 0x01, // ÖW (U+00D6 U+0057)
  0x00, 0xD6, 0x00, 0x58, 0x02, // ÖX (U+00D6 U+0058)
  0x00, 0xD6, 0x00, 0x59, 0x01, // ÖY (U+00D6 U+0059)
  0x00, 0xD6, 0x00, 0x5A, 0x01, // ÖZ (U+00D6 U+005A)
  0x00, 0xD6, 0x00, 0xC0, 0x02, // ÖÀ (U+00D6 U+00C0)
  0x00, 0xD6, 0x00, 0xC1, 0x02, // ÖÁ (U+00D6 U+00C1)
  0x00, 0xD6, 0x00, 0xC2, 0x02, // ÖÂ (U+00D6 U+00C2)
  0x00, 0xD6, 0x00, 0xC3, 0x02, // ÖÃ (U+00D6 U+00C3)
  0x00, 0xD6, 0x00, 0xC4, 0x02, // ÖÄ (U+00D6 U+00C4)
  0x00, 0xD6, 0x00, 0xC5, 0x02, // ÖÅ (U+00D6 U+00C5)
  0x00, 0xD6, 0x00, 0xDD, 0x01, // ÖÝ (U+00D6 U+00DD)
  0x00, 0xD6, 0x01, 0x00, 0x02, // ÖĀ (U+00D6 U+0100)
  0x00, 0xD6, 0x01, 0x02, 0x02, // ÖĂ (U+00D6 U+0102)
  0x00, 0xD6, 0x01, 0x04, 0x02, // ÖĄ (U+00D6 U+0104)
  0x00, 0xD6, 0x01, 0x62, 0x04, // ÖŢ (U+00D6 U+0162)
  0x00, 0xD6, 0x01, 0x64, 0x04, // ÖŤ (U+00D6 U+0164)
  0x00, 0xD6, 0x01, 0x66, 0x04, // ÖŦ (U+00D6 U+0166)
  0x00, 0xD6, 0x01, 0x74, 0x01, // ÖŴ (U+00D6 U+0174)
  0x00, 0xD6, 0x01, 0x76, 0x01, // ÖŶ (U+00D6 U+0176)
  0x00, 0xD6, 0x01, 0x78, 0x01, // ÖŸ (U+00D6 U+0178)
  0x00, 0xD6, 0x01, 0x79, 0x01, // ÖŹ (U+00D6 U+0179)
  0x00, 0xD6, 0x01, 0x7B, 0x01, // ÖŻ (U+00D6 U+017B)
  0x00, 0xD6, 0x01, 0x7D, 0x01, // ÖŽ (U+00D6 U+017D)
  0x00, 0xD6, 0x20, 0x1A, 0x05, // Ö‚ (U+00D6 U+201A)
  0x00, 0xD6, 0x20, 0x1E, 0x05, // Ö„ (U+00D6 U+201E)
  0x00, 0xD6, 0x20, 0x26, 0x05, // Ö… (U+00D6 U+2026)
  0x00, 0xD8, 0x00, 0x2C, 0x05, // Ø, (U+00D8 U+002C)
  0x00, 0xD8, 0x00, 0x2E, 0x05, // Ø. (U+00D8 U+002E)
  0x00, 0xD8, 0x00, 0x41, 0x02, // ØA (U+00D8 U+0041)
  0x00, 0xD8, 0x00, 0x54, 0x04, // ØT (U+00D8 U+0054)
  0x00, 0xD8, 0x00, 0x56, 0x01, // ØV (U+00D8 U+0056)
  0x00, 0xD8, 0x00, 0x57, 0x01, // ØW (U+00D8 U+0057)
  0x00, 0xD8, 0x00, 0x58, 0x02, // ØX (U+00D8 U+0058)
  0x00, 0xD8, 0x00, 0x59, 0x01, // ØY (U+00D8 U+0059)
  0x00, 0xD8, 0x00, 0x5A, 0x01, // ØZ (U+00D8 U+005A)
  0x00, 0xD8, 0x00, 0xC0, 0x02, // ØÀ (U+00D8 U+00C0)
  0x00, 0xD8, 0x00, 0xC1, 0x02, // ØÁ (U+00D8 U+00C1)
  0x00, 0xD8, 0x00, 0xC2, 0x02, // ØÂ (U+00D8 U+00C2)
  0x00, 0xD8, 0x00, 0xC3, 0x02, // ØÃ (U+00D8 U+00C3)
  0x00, 0xD8, 0x00, 0xC4, 0x02, // ØÄ (U+00D8 U+00C4)
  0x00, 0xD8, 0x00, 0xC5, 0x02, // ØÅ (U+00D8 U+00C5)
  0x00, 0xD8, 0x00, 0xDD, 0x01, // ØÝ (U+00D8 U+00DD)
  0x00, 0xD8, 0x01, 0x00, 0x02, // ØĀ (U+00D8 U+0100)
  0x00, 0xD8, 0x01, 0x02, 0x02, // ØĂ (U+00D8 U+0102)
  0x00, 0xD8, 0x01, 0x04, 0x02, // ØĄ (U+00D8 U+0104)
  0x00, 0xD8, 0x01, 0x62, 0x04, // ØŢ (U+00D8 U+0162)
  0x00, 0xD8, 0x01, 0x64, 0x04, // ØŤ (U+00D8 U+0164)
  0x00, 0xD8, 0x01, 0x66, 0x04, // ØŦ (U+00D8 U+0166)
  0x00, 0xD8, 0x01, 0x74, 0x01, // ØŴ (U+00D8 U+0174)
  0x00, 0xD8, 0x01, 0x76, 0x01, // ØŶ (U+00D8 U+0176)
  0x00, 0xD8, 0x01, 0x78, 0x01, // ØŸ (U+00D8 U+0178)
  0x00, 0xD8, 0x01, 0x79, 0x01, // ØŹ (U+00D8 U+0179)
  0x00, 0xD8, 0x01, 0x7B, 0x01, // ØŻ (U+00D8 U+017B)
  0x00, 0xD8, 0x01, 0x7D, 0x01, // ØŽ (U+00D8 U+017D)
  0x00, 0xD8, 0x20, 0x1A, 0x05, // Ø‚ (U+00D8 U+201A)
  0x00, 0xD8, 0x20, 0x1E, 0x05, // Ø„ (U+00D8 U+201E)
  0x00, 0xD8, 0x20, 0x26, 0x05, // Ø… (U+00D8 U+2026)
  0x00, 0xD9, 0x00, 0x2C, 0x02, // Ù, (U+00D9 U+002C)
  0x00, 0xD9, 0x00, 0x2E, 0x02, // Ù. (U+00D9 U+002E)
  0x00, 0xD9, 0x00, 0x41, 0x01, // ÙA (U+00D9 U+0041)
  0x00, 0xD9, 0x00, 0xC0, 0x01, // ÙÀ (U+00D9 U+00C0)
  0x00, 0xD9, 0x00, 0xC1, 0x01, // ÙÁ (U+00D9 U+00C1)
  0x00, 0xD9, 0x00, 0xC2, 0x01, // ÙÂ (U+00D9 U+00C2)
  0x00, 0xD9, 0x00, 0xC3, 0x01, // ÙÃ (U+00D9 U+00C3)
  0x00, 0xD9, 0x00, 0xC4, 0x01, // ÙÄ (U+00D9 U+00C4)
  0x00, 0xD9, 0x00, 0xC5, 0x01, // ÙÅ (U+00D9 U+00C5)
  0x00, 0xD9, 0x01, 0x00, 0x01, // ÙĀ (U+00D9 U+0100)
  0x00, 0xD9, 0x01, 0x02, 0x01, // ÙĂ (U+00D9 U+0102)
  0x00, 0xD9, 0x01, 0x04, 0x01, // ÙĄ (U+00D9 U+0104)
  0x00, 0xD9, 0x20, 0x1A, 0x02, // Ù‚ (U+00D9 U+201A)
  0x00, 0xD9, 0x20, 0x1E, 0x02, // Ù„ (U+00D9 U+201E)
  0x00, 0xD9, 0x20, 0x26, 0x02, // Ù… (U+00D9 U+2026)
  0x00, 0xDA, 0x00, 0x2C, 0x02, // Ú, (U+00DA U+002C)
  0x00, 0xDA, 0x00, 0x2E, 0x02, // Ú. (U+00DA U+002E)
  0x00, 0xDA, 0x00, 0x41, 0x01, // ÚA (U+00DA U+0041)
  0x00, 0xDA, 0x00, 0xC0, 0x01, // ÚÀ (U+00DA U+00C0)
  0x00, 0xDA, 0x00, 0xC1, 0x01, // ÚÁ (U+00DA U+00C1)
  0x00, 0xDA, 0x00, 0xC2, 0x01, // ÚÂ (U+00DA U+00C2)
  0x00, 0xDA, 0x00, 0xC3, 0x01, // ÚÃ (U+00DA U+00C3)
  0x00, 0xDA, 0x00, 0xC4, 0x01, // ÚÄ (U+00DA U+00C4)
  0x00, 0xDA, 0x00, 0xC5, 0x01, // ÚÅ (U+00DA U+00C5)
  0x00, 0xDA, 0x01, 0x00, 0x01, // ÚĀ (U+00DA U+0100)
  0x00, 0xDA, 0x01, 0x02, 0x01, // ÚĂ (U+00DA U+0102)
  0x00, 0xDA, 0x01, 0x04, 0x01, // ÚĄ (U+00DA U+0104)
  0x00, 0xDA, 0x20, 0x1A, 0x02, // Ú‚ (U+00DA U+201A)
  0x00, 0xDA, 0x20, 0x1E, 0x02, // Ú„ (U+00DA U+201E)
  0x00, 0xDA, 0x20, 0x26, 0x02, // Ú… (U+00DA U+2026)
  0x00, 0xDB, 0x00, 0x2C, 0x02, // Û, (U+00DB U+002C)
  0x00, 0xDB, 0x00, 0x2E, 0x02, // Û. (U+00DB U+002E)
  0x00, 0xDB, 0x00, 0x41, 0x01, // ÛA (U+00DB U+0041)
  0x00, 0xDB, 0x00, 0xC0, 0x01, // ÛÀ (U+00DB U+00C0)
  0x00, 0xDB, 0x00, 0xC1, 0x01, // ÛÁ (U+00DB U+00C1)
  0x00, 0xDB, 0x00, 0xC2, 0x01, // ÛÂ (U+00DB U+00C2)
  0x00, 0xDB, 0x00, 0xC3, 0x01, // ÛÃ (U+00DB U+00C3)
  0x00, 0xDB, 0x00, 0xC4, 0x01, // ÛÄ (U+00DB U+00C4)
  0x00, 0xDB, 0x00, 0xC5, 0x01, // ÛÅ (U+00DB U+00C5)
  0x00, 0xDB, 0x01, 0x00, 0x01, // ÛĀ (U+00DB U+0100)
  0x00, 0xDB, 0x01, 0x02, 0x01, // ÛĂ (U+00DB U+0102)
  0x00, 0xDB, 0x01, 0x04, 0x01, // ÛĄ (U+00DB U+0104)
  0x00, 0xDB, 0x20, 0x1A, 0x02, // Û‚ (U+00DB U+201A)
  0x00, 0xDB, 0x20, 0x1E, 0x02, // Û„ (U+00DB U+201E)
  0x00, 0xDB, 0x20, 0x26, 0x02, // Û… (U+00DB U+2026)
  0x00, 0xDC, 0x00, 0x2C, 0x02, // Ü, (U+00DC U+002C)
  0x00, 0xDC, 0x00, 0x2E, 0x02, // Ü. (U+00DC U+002E)
  0x00, 0xDC, 0x00, 0x41, 0x01, // ÜA (U+00DC U+0041)
  0x00, 0xDC, 0x00, 0xC0, 0x01, // ÜÀ (U+00DC U+00C0)
  0x00, 0xDC, 0x00, 0xC1, 0x01, // ÜÁ (U+00DC U+00C1)
  0x00, 0xDC, 0x00, 0xC2, 0x01, // ÜÂ (U+00DC U+00C2)
  0x00, 0xDC, 0x00, 0xC3, 0x01, // ÜÃ (U+00DC U+00C3)
  0x00, 0xDC, 0x00, 0xC4, 0x01, // ÜÄ (U+00DC U+00C4)
  0x00, 0xDC, 0x00, 0xC5, 0x01, // ÜÅ (U+00DC U+00C5)
  0x00, 0xDC, 0x01, 0x00, 0x01, // ÜĀ (U+00DC U+0100)
  0x00, 0xDC, 0x01, 0x02, 0x01, // ÜĂ (U+00DC U+0102)
  0x00, 0xDC, 0x01, 0x04, 0x01, // ÜĄ (U+00DC U+0104)
  0x00, 0xDC, 0x20, 0x1A, 0x02, // Ü‚ (U+00DC U+201A)
  0x00, 0xDC, 0x20, 0x1E, 0x02, // Ü„ (U+00DC U+201E)
  0x00, 0xDC, 0x20, 0x26, 0x02, // Ü… (U+00DC U+2026)
  0x00, 0xDD, 0x00, 0x26, 0x04, // Ý& (U+00DD U+0026)
  0x00, 0xDD, 0x00, 0x2C, 0x07, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x07, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x07, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x43, 0x02, // ÝC (U+00DD U+0043)
  0x00, 0xDD, 0x00, 0x47, 0x02, // ÝG (U+00DD U+0047)
  0x00, 0xDD, 0x00, 0x4F, 0x02, // ÝO (U+00DD U+004F)
  0x00, 0xDD, 0x00, 0x51, 0x02, // ÝQ (U+00DD U+0051)
  0x00, 0xDD, 0x00, 0x61, 0x06, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x06, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x06, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x06, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x06, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6D, 0x04, // Ým (U+00DD U+006D)
  0x00, 0xDD, 0x00, 0x6E, 0x04, // Ýn (U+00DD U+006E)
  0x00, 0xDD, 0x00, 0x6F, 0x06, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x70, 0x04, // Ýp (U+00DD U+0070)
  0x00, 0xDD, 0x00, 0x71, 0x06, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x72, 0x04, // Ýr (U+00DD U+0072)
  0x00, 0xDD, 0x00, 0x73, 0x05, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0x75, 0x04, // Ýu (U+00DD U+0075)
  0x00, 0xDD, 0x00, 0x7A, 0x02, // Ýz (U+00DD U+007A)
  0x00, 0xDD, 0x00, 0xAB, 0x0A, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xBB, 0x04, // Ý» (U+00DD U+00BB)
  0x00, 0xDD, 0x00, 0xC0, 0x07, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x07, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x07, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x07, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x07, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x07, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xC7, 0x02, // ÝÇ (U+00DD U+00C7)
  0x00, 0xDD, 0x00, 0xD2, 0x02, // ÝÒ (U+00DD U+00D2)
  0x00, 0xDD, 0x00, 0xD3, 0x02, // ÝÓ (U+00DD U+00D3)
  0x00, 0xDD, 0x00, 0xD4, 0x02, // ÝÔ (U+00DD U+00D4)
  0x00, 0xDD, 0x00, 0xD5, 0x02, // ÝÕ (U+00DD U+00D5)
  0x00, 0xDD, 0x00, 0xD6, 0x02, // ÝÖ (U+00DD U+00D6)
  0x00, 0xDD, 0x00, 0xD8, 0x02, // ÝØ (U+00DD U+00D8)
  0x00, 0xDD, 0x00, 0xE0, 0x06, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x06, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x06, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x06, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x06, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x06, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x06, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x06, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x06, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x06, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x06, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x06, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF2, 0x06, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x06, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x06, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x06, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x06, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x06, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x00, 0xF9, 0x04, // Ýù (U+00DD U+00F9)
  0x00, 0xDD, 0x00, 0xFA, 0x04, // Ýú (U+00DD U+00FA)
  0x00, 0xDD, 0x00, 0xFB, 0x04, // Ýû (U+00DD U+00FB)
  0x00, 0xDD, 0x00, 0xFC, 0x04, // Ýü (U+00DD U+00FC)
  0x00, 0xDD, 0x01, 0x00, 0x07, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x06, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x07, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x06, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x07, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x06, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x06, 0x02, // ÝĆ (U+00DD U+0106)
  0x00, 0xDD, 0x01, 0x07, 0x06, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x08, 0x02, // ÝĈ (U+00DD U+0108)
  0x00, 0xDD, 0x01, 0x09, 0x06, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0A, 0x02, // ÝĊ (U+00DD U+010A)
  0x00, 0xDD, 0x01, 0x0B, 0x06, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0C, 0x02, // ÝČ (U+00DD U+010C)
  0x00, 0xDD, 0x01, 0x0D, 0x06, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x06, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x06, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x06, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x06, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x06, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x06, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x06, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1C, 0x02, // ÝĜ (U+00DD U+011C)
  0x00, 0xDD, 0x01, 0x1D, 0x06, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1E, 0x02, // ÝĞ (U+00DD U+011E)
  0x00, 0xDD, 0x01, 0x1F, 0x06, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x20, 0x02, // ÝĠ (U+00DD U+0120)
  0x00, 0xDD, 0x01, 0x21, 0x06, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x22, 0x02, // ÝĢ (U+00DD U+0122)
  0x00, 0xDD, 0x01, 0x23, 0x06, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x38, 0x04, // Ýĸ (U+00DD U+0138)
  0x00, 0xDD, 0x01, 0x44, 0x04, // Ýń (U+00DD U+0144)
  0x00, 0xDD, 0x01, 0x46, 0x04, // Ýņ (U+00DD U+0146)
  0x00, 0xDD, 0x01, 0x4B, 0x04, // Ýŋ (U+00DD U+014B)
  0x00, 0xDD, 0x01, 0x4C, 0x02, // ÝŌ (U+00DD U+014C)
  0x00, 0xDD, 0x01, 0x4D, 0x06, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4E, 0x02, // ÝŎ (U+00DD U+014E)
  0x00, 0xDD, 0x01, 0x4F, 0x06, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x50, 0x02, // ÝŐ (U+00DD U+0150)
  0x00, 0xDD, 0x01, 0x51, 0x06, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x52, 0x02, // ÝŒ (U+00DD U+0152)
  0x00, 0xDD, 0x01, 0x53, 0x06, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x55, 0x04, // Ýŕ (U+00DD U+0155)
  0x00, 0xDD, 0x01, 0x57, 0x04, // Ýŗ (U+00DD U+0157)
  0x00, 0xDD, 0x01, 0x5B, 0x05, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5F, 0x05, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x69, 0x04, // Ýũ (U+00DD U+0169)
  0x00, 0xDD, 0x01, 0x6B, 0x04, // Ýū (U+00DD U+016B)
  0x00, 0xDD, 0x01, 0x6D, 0x04, // Ýŭ (U+00DD U+016D)
  0x00, 0xDD, 0x01, 0x6F, 0x04, // Ýů (U+00DD U+016F)
  0x00, 0xDD, 0x01, 0x71, 0x04, // Ýű (U+00DD U+0171)
  0x00, 0xDD, 0x01, 0x73, 0x04, // Ýų (U+00DD U+0173)
  0x00, 0xDD, 0x01, 0x7A, 0x02, // Ýź (U+00DD U+017A)
  0x00, 0xDD, 0x01, 0x7C, 0x02, // Ýż (U+00DD U+017C)
  0x00, 0xDD, 0x01, 0x7E, 0x02, // Ýž (U+00DD U+017E)
  0x00, 0xDD, 0x20, 0x1A, 0x07, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x07, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x07, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x0A, // Ý‹ (U+00DD U+2039)
  0x00, 0xDD, 0x20, 0x3A, 0x04, // Ý› (U+00DD U+203A)
  0x00, 0xDE, 0x00, 0x26, 0x01, // Þ& (U+00DE U+0026)
  0x00, 0xDE, 0x00, 0x2C, 0x10, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x10, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x00, 0x41, 0x06, // ÞA (U+00DE U+0041)
  0x00, 0xDE, 0x00, 0x58, 0x02, // ÞX (U+00DE U+0058)
  0x00, 0xDE, 0x00, 0x5A, 0x01, // ÞZ (U+00DE U+005A)
  0x00, 0xDE, 0x00, 0xAB, 0x02, // Þ« (U+00DE U+00AB)
  0x00, 0xDE, 0x00, 0xC0, 0x06, // ÞÀ (U+00DE U+00C0)
  0x00, 0xDE, 0x00, 0xC1, 0x06, // ÞÁ (U+00DE U+00C1)
  0x00, 0xDE, 0x00, 0xC2, 0x06, // ÞÂ (U+00DE U+00C2)
  0x00, 0xDE, 0x00, 0xC3, 0x06, // ÞÃ (U+00DE U+00C3)
  0x00, 0xDE, 0x00, 0xC4, 0x06, // ÞÄ (U+00DE U+00C4)
  0x00, 0xDE, 0x00, 0xC5, 0x06, // ÞÅ (U+00DE U+00C5)
  0x00, 0xDE, 0x00, 0xC6, 0x04, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDE, 0x01, 0x00, 0x06, // ÞĀ (U+00DE U+0100)
  0x00, 0xDE, 0x01, 0x02, 0x06, // ÞĂ (U+00DE U+0102)
  0x00, 0xDE, 0x01, 0x04, 0x06, // ÞĄ (U+00DE U+0104)
  0x00, 0xDE, 0x01, 0x79, 0x01, // ÞŹ (U+00DE U+0179)
  0x00, 0xDE, 0x01, 0x7B, 0x01, // ÞŻ (U+00DE U+017B)
  0x00, 0xDE, 0x01, 0x7D, 0x01, // ÞŽ (U+00DE U+017D)
  0x00, 0xDE, 0x20, 0x1A, 0x10, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x10, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x10, // Þ… (U+00DE U+2026)
  0x00, 0xDE, 0x20, 0x39, 0x02, // Þ‹ (U+00DE U+2039)
  0x00, 0xE0, 0x00, 0x22, 0x01, // à" (U+00E0 U+0022)
  0x00, 0xE0, 0x00, 0x27, 0x01, // à' (U+00E0 U+0027)
  0x00, 0xE0, 0x20, 0x19, 0x01, // à’ (U+00E0 U+2019)
  0x00, 0xE0, 0x20, 0x1D, 0x01, // à” (U+00E0 U+201D)
  0x00, 0xE1, 0x00, 0x22, 0x01, // á" (U+00E1 U+0022)
  0x00, 0xE1, 0x00, 0x27, 0x01, // á' (U+00E1 U+0027)
  0x00, 0xE1, 0x20, 0x19, 0x01, // á’ (U+00E1 U+2019)
  0x00, 0xE1, 0x20, 0x1D, 0x01, // á” (U+00E1 U+201D)
  0x00, 0xE2, 0x00, 0x22, 0x01, // â" (U+00E2 U+0022)
  0x00, 0xE2, 0x00, 0x27, 0x01, // â' (U+00E2 U+0027)
  0x00, 0xE2, 0x20, 0x19, 0x01, // â’ (U+00E2 U+2019)
  0x00, 0xE2, 0x20, 0x1D, 0x01, // â” (U+00E2 U+201D)
  0x00, 0xE3, 0x00, 0x22, 0x01, // ã" (U+00E3 U+0022)
  0x00, 0xE3, 0x00, 0x27, 0x01, // ã' (U+00E3 U+0027)
  0x00, 0xE3, 0x20, 0x19, 0x01, // ã’ (U+00E3 U+2019)
  0x00, 0xE3, 0x20, 0x1D, 0x01, // ã” (U+00E3 U+201D)
  0x00, 0xE4, 0x00, 0x22, 0x01, // ä" (U+00E4 U+0022)
  0x00, 0xE4, 0x00, 0x27, 0x01, // ä' (U+00E4 U+0027)
  0x00, 0xE4, 0x20, 0x19, 0x01, // ä’ (U+00E4 U+2019)
  0x00, 0xE4, 0x20, 0x1D, 0x01, // ä” (U+00E4 U+201D)
  0x00, 0xE5, 0x00, 0x22, 0x01, // å" (U+00E5 U+0022)
  0x00, 0xE5, 0x00, 0x27, 0x01, // å' (U+00E5 U+0027)
  0x00, 0xE5, 0x20, 0x19, 0x01, // å’ (U+00E5 U+2019)
  0x00, 0xE5, 0x20, 0x1D, 0x01, // å” (U+00E5 U+201D)
  0x00, 0xE6, 0x00, 0x22, 0x01, // æ" (U+00E6 U+0022)
  0x00, 0xE6, 0x00, 0x27, 0x01, // æ' (U+00E6 U+0027)
  0x00, 0xE6, 0x00, 0x76, 0x02, // æv (U+00E6 U+0076)
  0x00, 0xE6, 0x00, 0x77, 0x02, // æw (U+00E6 U+0077)
  0x00, 0xE6, 0x00, 0x78, 0x02, // æx (U+00E6 U+0078)
  0x00, 0xE6, 0x00, 0x79, 0x02, // æy (U+00E6 U+0079)
  0x00, 0xE6, 0x00, 0x7A, 0x01, // æz (U+00E6 U+007A)
  0x00, 0xE6, 0x00, 0xFD, 0x02, // æý (U+00E6 U+00FD)
  0x00, 0xE6, 0x00, 0xFF, 0x02, // æÿ (U+00E6 U+00FF)
  0x00, 0xE6, 0x01, 0x75, 0x02, // æŵ (U+00E6 U+0175)
  0x00, 0xE6, 0x01, 0x77, 0x02, // æŷ (U+00E6 U+0177)
  0x00, 0xE6, 0x01, 0x7A, 0x01, // æź (U+00E6 U+017A)
  0x00, 0xE6, 0x01, 0x7C, 0x01, // æż (U+00E6 U+017C)
  0x00, 0xE6, 0x01, 0x7E, 0x01, // æž (U+00E6 U+017E)
  0x00, 0xE6, 0x20, 0x19, 0x01, // æ’ (U+00E6 U+2019)
  0x00, 0xE6, 0x20, 0x1D, 0x01, // æ” (U+00E6 U+201D)
  0x00, 0xE8, 0x00, 0x22, 0x01, // è" (U+00E8 U+0022)
  0x00, 0xE8, 0x00, 0x27, 0x01, // è' (U+00E8 U+0027)
  0x00, 0xE8, 0x00, 0x76, 0x02, // èv (U+00E8 U+0076)
  0x00, 0xE8, 0x00, 0x77, 0x02, // èw (U+00E8 U+0077)
  0x00, 0xE8, 0x00, 0x78, 0x02, // èx (U+00E8 U+0078)
  0x00, 0xE8, 0x00, 0x79, 0x02, // èy (U+00E8 U+0079)
  0x00, 0xE8, 0x00, 0x7A, 0x01, // èz (U+00E8 U+007A)
  0x00, 0xE8, 0x00, 0xFD, 0x02, // èý (U+00E8 U+00FD)
  0x00, 0xE8, 0x00, 0xFF, 0x02, // èÿ (U+00E8 U+00FF)
  0x00, 0xE8, 0x01, 0x75, 0x02, // èŵ (U+00E8 U+0175)
  0x00, 0xE8, 0x01, 0x77, 0x02, // èŷ (U+00E8 U+0177)
  0x00, 0xE8, 0x01, 0x7A, 0x01, // èź (U+00E8 U+017A)
  0x00, 0xE8, 0x01, 0x7C, 0x01, // èż (U+00E8 U+017C)
  0x00, 0xE8, 0x01, 0x7E, 0x01, // èž (U+00E8 U+017E)
  0x00, 0xE8, 0x20, 0x19, 0x01, // è’ (U+00E8 U+2019)
  0x00, 0xE8, 0x20, 0x1D, 0x01, // è” (U+00E8 U+201D)
  0x00, 0xE9, 0x00, 0x22, 0x01, // é" (U+00E9 U+0022)
  0x00, 0xE9, 0x00, 0x27, 0x01, // é' (U+00E9 U+0027)
  0x00, 0xE9, 0x00, 0x76, 0x02, // év (U+00E9 U+0076)
  0x00, 0xE9, 0x00, 0x77, 0x02, // éw (U+00E9 U+0077)
  0x00, 0xE9, 0x00, 0x78, 0x02, // éx (U+00E9 U+0078)
  0x00, 0xE9, 0x00, 0x79, 0x02, // éy (U+00E9 U+0079)
  0x00, 0xE9, 0x00, 0x7A, 0x01, // éz (U+00E9 U+007A)
  0x00, 0xE9, 0x00, 0xFD, 0x02, // éý (U+00E9 U+00FD)
  0x00, 0xE9, 0x00, 0xFF, 0x02, // éÿ (U+00E9 U+00FF)
  0x00, 0xE9, 0x01, 0x75, 0x02, // éŵ (U+00E9 U+0175)
  0x00, 0xE9, 0x01, 0x77, 0x02, // éŷ (U+00E9 U+0177)
  0x00, 0xE9, 0x01, 0x7A, 0x01, // éź (U+00E9 U+017A)
  0x00, 0xE9, 0x01, 0x7C, 0x01, // éż (U+00E9 U+017C)
  0x00, 0xE9, 0x01, 0x7E, 0x01, // éž (U+00E9 U+017E)
  0x00, 0xE9, 0x20, 0x19, 0x01, // é’ (U+00E9 U+2019)
  0x00, 0xE9, 0x20, 0x1D, 0x01, // é” (U+00E9 U+201D)
  0x00, 0xEA, 0x00, 0x22, 0x01, // ê" (U+00EA U+0022)
  0x00, 0xEA, 0x00, 0x27, 0x01, // ê' (U+00EA U+0027)
  0x00, 0xEA, 0x00, 0x76, 0x02, // êv (U+00EA U+0076)
  0x00, 0xEA, 0x00, 0x77, 0x02, // êw (U+00EA U+0077)
  0x00, 0xEA, 0x00, 0x78, 0x02, // êx (U+00EA U+0078)
  0x00, 0xEA, 0x00, 0x79, 0x02, // êy (U+00EA U+0079)
  0x00, 0xEA, 0x00, 0x7A, 0x01, // êz (U+00EA U+007A)
  0x00, 0xEA, 0x00, 0xFD, 0x02, // êý (U+00EA U+00FD)
  0x00, 0xEA, 0x00, 0xFF, 0x02, // êÿ (U+00EA U+00FF)
  0x00, 0xEA, 0x01, 0x75, 0x02, // êŵ (U+00EA U+0175)
  0x00, 0xEA, 0x01, 0x77, 0x02, // êŷ (U+00EA U+0177)
  0x00, 0xEA, 0x01, 0x7A, 0x01, // êź (U+00EA U+017A)
  0x00, 0xEA, 0x01, 0x7C, 0x01, // êż (U+00EA U+017C)
  0x00, 0xEA, 0x01, 0x7E, 0x01, // êž (U+00EA U+017E)
  0x00, 0xEA, 0x20, 0x19, 0x01, // ê’ (U+00EA U+2019)
  0x00, 0xEA, 0x20, 0x1D, 0x01, // ê” (U+00EA U+201D)
  0x00, 0xEB, 0x00, 0x22, 0x01, // ë" (U+00EB U+0022)
  0x00, 0xEB, 0x00, 0x27, 0x01, // ë' (U+00EB U+0027)
  0x00, 0xEB, 0x00, 0x76, 0x02, // ëv (U+00EB U+0076)
  0x00, 0xEB, 0x00, 0x77, 0x02, // ëw (U+00EB U+0077)
  0x00, 0xEB, 0x00, 0x78, 0x02, // ëx (U+00EB U+0078)
  0x00, 0xEB, 0x00, 0x79, 0x02, // ëy (U+00EB U+0079)
  0x00, 0xEB, 0x00, 0x7A, 0x01, // ëz (U+00EB U+007A)
  0x00, 0xEB, 0x00, 0xFD, 0x02, // ëý (U+00EB U+00FD)
  0x00, 0xEB, 0x00, 0xFF, 0x02, // ëÿ (U+00EB U+00FF)
  0x00, 0xEB, 0x01, 0x75, 0x02, // ëŵ (U+00EB U+0175)
  0x00, 0xEB, 0x01, 0x77, 0x02, // ëŷ (U+00EB U+0177)
  0x00, 0xEB, 0x01, 0x7A, 0x01, // ëź (U+00EB U+017A)
  0x00, 0xEB, 0x01, 0x7C, 0x01, // ëż (U+00EB U+017C)
  0x00, 0xEB, 0x01, 0x7E, 0x01, // ëž (U+00EB U+017E)
  0x00, 0xEB, 0x20, 0x19, 0x01, // ë’ (U+00EB U+2019)
  0x00, 0xEB, 0x20, 0x1D, 0x01, // ë” (U+00EB U+201D)
  0x00, 0xF0, 0x00, 0x22, 0x01, // ð" (U+00F0 U+0022)
  0x00, 0xF0, 0x00, 0x27, 0x01, // ð' (U+00F0 U+0027)
  0x00, 0xF0, 0x00, 0x76, 0x02, // ðv (U+00F0 U+0076)
  0x00, 0xF0, 0x00, 0x77, 0x02, // ðw (U+00F0 U+0077)
  0x00, 0xF0, 0x00, 0x78, 0x02, // ðx (U+00F0 U+0078)
  0x00, 0xF0, 0x00, 0x79, 0x02, // ðy (U+00F0 U+0079)
  0x00, 0xF0, 0x00, 0x7A, 0x01, // ðz (U+00F0 U+007A)
  0x00, 0xF0, 0x00, 0xFD, 0x02, // ðý (U+00F0 U+00FD)
  0x00, 0xF0, 0x00, 0xFF, 0x02, // ðÿ (U+00F0 U+00FF)
  0x00, 0xF0, 0x01, 0x75, 0x02, // ðŵ (U+00F0 U+0175)
  0x00, 0xF0, 0x01, 0x77, 0x02, // ðŷ (U+00F0 U+0177)
  0x00, 0xF0, 0x01, 0x7A, 0x01, // ðź (U+00F0 U+017A)
  0x00, 0xF0, 0x01, 0x7C, 0x01, // ðż (U+00F0 U+017C)
  0x00, 0xF0, 0x01, 0x7E, 0x01, // ðž (U+00F0 U+017E)
  0x00, 0xF0, 0x20, 0x19, 0x01, // ð’ (U+00F0 U+2019)
  0x00, 0xF0, 0x20, 0x1D, 0x01, // ð” (U+00F0 U+201D)
  0x00, 0xF2, 0x00, 0x22, 0x01, // ò" (U+00F2 U+0022)
  0x00, 0xF2, 0x00, 0x27, 0x01, // ò' (U+00F2 U+0027)
  0x00, 0xF2, 0x00, 0x76, 0x02, // òv (U+00F2 U+0076)
  0x00, 0xF2, 0x00, 0x77, 0x02, // òw (U+00F2 U+0077)
  0x00, 0xF2, 0x00, 0x78, 0x02, // òx (U+00F2 U+0078)
  0x00, 0xF2, 0x00, 0x79, 0x02, // òy (U+00F2 U+0079)
  0x00, 0xF2, 0x00, 0x7A, 0x01, // òz (U+00F2 U+007A)
  0x00, 0xF2, 0x00, 0xFD, 0x02, // òý (U+00F2 U+00FD)
  0x00, 0xF2, 0x00, 0xFF, 0x02, // òÿ (U+00F2 U+00FF)
  0x00, 0xF2, 0x01, 0x75, 0x02, // òŵ (U+00F2 U+0175)
  0x00, 0xF2, 0x01, 0x77, 0x02, // òŷ (U+00F2 U+0177)
  0x00, 0xF2, 0x01, 0x7A, 0x01, // òź (U+00F2 U+017A)
  0x00, 0xF2, 0x01, 0x7C, 0x01, // òż (U+00F2 U+017C)
  0x00, 0xF2, 0x01, 0x7E, 0x01, // òž (U+00F2 U+017E)
  0x00, 0xF2, 0x20, 0x19, 0x01, // ò’ (U+00F2 U+2019)
  0x00, 0xF2, 0x20, 0x1D, 0x01, // ò” (U+00F2 U+201D)
  0x00, 0xF3, 0x00, 0x22, 0x01, // ó" (U+00F3 U+0022)
  0x00, 0xF3, 0x00, 0x27, 0x01, // ó' (U+00F3 U+0027)
  0x00, 0xF3, 0x00, 0x76, 0x02, // óv (U+00F3 U+0076)
  0x00, 0xF3, 0x00, 0x77, 0x02, // ów (U+00F3 U+0077)
  0x00, 0xF3, 0x00, 0x78, 0x02, // óx (U+00F3 U+0078)
  0x00, 0xF3, 0x00, 0x79, 0x02, // óy (U+00F3 U+0079)
  0x00, 0xF3, 0x00, 0x7A, 0x01, // óz (U+00F3 U+007A)
  0x00, 0xF3, 0x00, 0xFD, 0x02, // óý (U+00F3 U+00FD)
  0x00, 0xF3, 0x00, 0xFF, 0x02, // óÿ (U+00F3 U+00FF)
  0x00, 0xF3, 0x01, 0x75, 0x02, // óŵ (U+00F3 U+0175)
  0x00, 0xF3, 0x01, 0x77, 0x02, // óŷ (U+00F3 U+0177)
  0x00, 0xF3, 0x01, 0x7A, 0x01, // óź (U+00F3 U+017A)
  0x00, 0xF3, 0x01, 0x7C, 0x01, // óż (U+00F3 U+017C)
  0x00, 0xF3, 0x01, 0x7E, 0x01, // óž (U+00F3 U+017E)
  0x00, 0xF3, 0x20, 0x19, 0x01, // ó’ (U+00F3 U+2019)
  0x00, 0xF3, 0x20, 0x1D, 0x01, // ó” (U+00F3 U+201D)
  0x00, 0xF4, 0x00, 0x22, 0x01, // ô" (U+00F4 U+0022)
  0x00, 0xF4, 0x00, 0x27, 0x01, // ô' (U+00F4 U+0027)
  0x00, 0xF4, 0x00, 0x76, 0x02, // ôv (U+00F4 U+0076)
  0x00, 0xF4, 0x00, 0x77, 0x02, // ôw (U+00F4 U+0077)
  0x00, 0xF4, 0x00, 0x78, 0x02, // ôx (U+00F4 U+0078)
  0x00, 0xF4, 0x00, 0x79, 0x02, // ôy (U+00F4 U+0079)
  0x00, 0xF4, 0x00, 0x7A, 0x01, // ôz (U+00F4 U+007A)
  0x00, 0xF4, 0x00, 0xFD, 0x02, // ôý (U+00F4 U+00FD)
  0x00, 0xF4, 0x00, 0xFF, 0x02, // ôÿ (U+00F4 U+00FF)
  0x00, 0xF4, 0x01, 0x75, 0x02, // ôŵ (U+00F4 U+0175)
  0x00, 0xF4, 0x01, 0x77, 0x02, // ôŷ (U+00F4 U+0177)
  0x00, 0xF4, 0x01, 0x7A, 0x01, // ôź (U+00F4 U+017A)
  0x00, 0xF4, 0x01, 0x7C, 0x01, // ôż (U+00F4 U+017C)
  0x00, 0xF4, 0x01, 0x7E, 0x01, // ôž (U+00F4 U+017E)
  0x00, 0xF4, 0x20, 0x19, 0x01, // ô’ (U+00F4 U+2019)
  0x00, 0xF4, 0x20, 0x1D, 0x01, // ô” (U+00F4 U+201D)
  0x00, 0xF5, 0x00, 0x22, 0x01, // õ" (U+00F5 U+0022)
  0x00, 0xF5, 0x00, 0x27, 0x01, // õ' (U+00F5 U+0027)
  0x00, 0xF5, 0x00, 0x76, 0x02, // õv (U+00F5 U+0076)
  0x00, 0xF5, 0x00, 0x77, 0x02, // õw (U+00F5 U+0077)
  0x00, 0xF5, 0x00, 0x78, 0x02, // õx (U+00F5 U+0078)
  0x00, 0xF5, 0x00, 0x79, 0x02, // õy (U+00F5 U+0079)
  0x00, 0xF5, 0x00, 0x7A, 0x01, // õz (U+00F5 U+007A)
  0x00, 0xF5, 0x00, 0xFD, 0x02, // õý (U+00F5 U+00FD)
  0x00, 0xF5, 0x00, 0xFF, 0x02, // õÿ (U+00F5 U+00FF)
  0x00, 0xF5, 0x01, 0x75, 0x02, // õŵ (U+00F5 U+0175)
  0x00, 0xF5, 0x01, 0x77, 0x02, // õŷ (U+00F5 U+0177)
  0x00, 0xF5, 0x01, 0x7A, 0x01, // õź (U+00F5 U+017A)
  0x00, 0xF5, 0x01, 0x7C, 0x01, // õż (U+00F5 U+017C)
  0x00, 0xF5, 0x01, 0x7E, 0x01, // õž (U+00F5 U+017E)
  0x00, 0xF5, 0x20, 0x19, 0x01, // õ’ (U+00F5 U+2019)
  0x00, 0xF5, 0x20, 0x1D, 0x01, // õ” (U+00F5 U+201D)
  0x00, 0xF6, 0x00, 0x22, 0x01, // ö" (U+00F6 U+0022)
  0x00, 0xF6, 0x00, 0x27, 0x01, // ö' (U+00F6 U+0027)
  0x00, 0xF6, 0x00, 0x76, 0x02, // öv (U+00F6 U+0076)
  0x00, 0xF6, 0x00, 0x77, 0x02, // öw (U+00F6 U+0077)
  0x00, 0xF6, 0x00, 0x78, 0x02, // öx (U+00F6 U+0078)
  0x00, 0xF6, 0x00, 0x79, 0x02, // öy (U+00F6 U+0079)
  0x00, 0xF6, 0x00, 0x7A, 0x01, // öz (U+00F6 U+007A)
  0x00, 0xF6, 0x00, 0xFD, 0x02, // öý (U+00F6 U+00FD)
  0x00, 0xF6, 0x00, 0xFF, 0x02, // öÿ (U+00F6 U+00FF)
  0x00, 0xF6, 0x01, 0x75, 0x02, // öŵ (U+00F6 U+0175)
  0x00, 0xF6, 0x01, 0x77, 0x02, // öŷ (U+00F6 U+0177)
  0x00, 0xF6, 0x01, 0x7A, 0x01, // öź (U+00F6 U+017A)
  0x00, 0xF6, 0x01, 0x7C, 0x01, // öż (U+00F6 U+017C)
  0x00, 0xF6, 0x01, 0x7E, 0x01, // öž (U+00F6 U+017E)
  0x00, 0xF6, 0x20, 0x19, 0x01, // ö’ (U+00F6 U+2019)
  0x00, 0xF6, 0x20, 0x1D, 0x01, // ö” (U+00F6 U+201D)
  0x00, 0xF8, 0x00, 0x22, 0x01, // ø" (U+00F8 U+0022)
  0x00, 0xF8, 0x00, 0x27, 0x01, // ø' (U+00F8 U+0027)
  0x00, 0xF8, 0x00, 0x76, 0x02, // øv (U+00F8 U+0076)
  0x00, 0xF8, 0x00, 0x77, 0x02, // øw (U+00F8 U+0077)
  0x00, 0xF8, 0x00, 0x78, 0x02, // øx (U+00F8 U+0078)
  0x00, 0xF8, 0x00, 0x79, 0x02, // øy (U+00F8 U+0079)
  0x00, 0xF8, 0x00, 0x7A, 0x01, // øz (U+00F8 U+007A)
  0x00, 0xF8, 0x00, 0xFD, 0x02, // øý (U+00F8 U+00FD)
  0x00, 0xF8, 0x00, 0xFF, 0x02, // øÿ (U+00F8 U+00FF)
  0x00, 0xF8, 0x01, 0x75, 0x02, // øŵ (U+00F8 U+0175)
  0x00, 0xF8, 0x01, 0x77, 0x02, // øŷ (U+00F8 U+0177)
  0x00, 0xF8, 0x01, 0x7A, 0x01, // øź (U+00F8 U+017A)
  0x00, 0xF8, 0x01, 0x7C, 0x01, // øż (U+00F8 U+017C)
  0x00, 0xF8, 0x01, 0x7E, 0x01, // øž (U+00F8 U+017E)
  0x00, 0xF8, 0x20, 0x19, 0x01, // ø’ (U+00F8 U+2019)
  0x00, 0xF8, 0x20, 0x1D, 0x01, // ø” (U+00F8 U+201D)
  0x00, 0xFD, 0x00, 0x2C, 0x05, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x05, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x05, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x05, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x05, // ý… (U+00FD U+2026)
  0x00, 0xFE, 0x00, 0x22, 0x01, // þ" (U+00FE U+0022)
  0x00, 0xFE, 0x00, 0x27, 0x01, // þ' (U+00FE U+0027)
  0x00, 0xFE, 0x00, 0x76, 0x02, // þv (U+00FE U+0076)
  0x00, 0xFE, 0x00, 0x77, 0x02, // þw (U+00FE U+0077)
  0x00, 0xFE, 0x00, 0x78, 0x02, // þx (U+00FE U+0078)
  0x00, 0xFE, 0x00, 0x79, 0x02, // þy (U+00FE U+0079)
  0x00, 0xFE, 0x00, 0x7A, 0x01, // þz (U+00FE U+007A)
  0x00, 0xFE, 0x00, 0xFD, 0x02, // þý (U+00FE U+00FD)
  0x00, 0xFE, 0x00, 0xFF, 0x02, // þÿ (U+00FE U+00FF)
  0x00, 0xFE, 0x01, 0x75, 0x02, // þŵ (U+00FE U+0175)
  0x00, 0xFE, 0x01, 0x77, 0x02, // þŷ (U+00FE U+0177)
  0x00, 0xFE, 0x01, 0x7A, 0x01, // þź (U+00FE U+017A)
  0x00, 0xFE, 0x01, 0x7C, 0x01, // þż (U+00FE U+017C)
  0x00, 0xFE, 0x01, 0x7E, 0x01, // þž (U+00FE U+017E)
  0x00, 0xFE, 0x20, 0x19, 0x01, // þ’ (U+00FE U+2019)
  0x00, 0xFE, 0x20, 0x1D, 0x01, // þ” (U+00FE U+201D)
  0x00, 0xFF, 0x00, 0x2C, 0x05, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x05, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x05, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x05, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x05, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x08, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x08, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x43, 0x02, // ĀC (U+0100 U+0043)
  0x01, 0x00, 0x00, 0x47, 0x02, // ĀG (U+0100 U+0047)
  0x01, 0x00, 0x00, 0x4F, 0x02, // ĀO (U+0100 U+004F)
  0x01, 0x00, 0x00, 0x51, 0x02, // ĀQ (U+0100 U+0051)
  0x01, 0x00, 0x00, 0x54, 0x08, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x56, 0x05, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x05, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x07, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xC7, 0x02, // ĀÇ (U+0100 U+00C7)
  0x01, 0x00, 0x00, 0xD2, 0x02, // ĀÒ (U+0100 U+00D2)
  0x01, 0x00, 0x00, 0xD3, 0x02, // ĀÓ (U+0100 U+00D3)
  0x01, 0x00, 0x00, 0xD4, 0x02, // ĀÔ (U+0100 U+00D4)
  0x01, 0x00, 0x00, 0xD5, 0x02, // ĀÕ (U+0100 U+00D5)
  0x01, 0x00, 0x00, 0xD6, 0x02, // ĀÖ (U+0100 U+00D6)
  0x01, 0x00, 0x00, 0xD8, 0x02, // ĀØ (U+0100 U+00D8)
  0x01, 0x00, 0x00, 0xDD, 0x07, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x06, 0x02, // ĀĆ (U+0100 U+0106)
  0x01, 0x00, 0x01, 0x08, 0x02, // ĀĈ (U+0100 U+0108)
  0x01, 0x00, 0x01, 0x0A, 0x02, // ĀĊ (U+0100 U+010A)
  0x01, 0x00, 0x01, 0x0C, 0x02, // ĀČ (U+0100 U+010C)
  0x01, 0x00, 0x01, 0x1C, 0x02, // ĀĜ (U+0100 U+011C)
  0x01, 0x00, 0x01, 0x1E, 0x02, // ĀĞ (U+0100 U+011E)
  0x01, 0x00, 0x01, 0x20, 0x02, // ĀĠ (U+0100 U+0120)
  0x01, 0x00, 0x01, 0x22, 0x02, // ĀĢ (U+0100 U+0122)
  0x01, 0x00, 0x01, 0x4C, 0x02, // ĀŌ (U+0100 U+014C)
  0x01, 0x00, 0x01, 0x4E, 0x02, // ĀŎ (U+0100 U+014E)
  0x01, 0x00, 0x01, 0x50, 0x02, // ĀŐ (U+0100 U+0150)
  0x01, 0x00, 0x01, 0x52, 0x02, // ĀŒ (U+0100 U+0152)
  0x01, 0x00, 0x01, 0x62, 0x08, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x08, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x08, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x74, 0x05, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x76, 0x07, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x07, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x19, 0x08, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x08, // Ā” (U+0100 U+201D)
  0x01, 0x01, 0x00, 0x22, 0x01, // ā" (U+0101 U+0022)
  0x01, 0x01, 0x00, 0x27, 0x01, // ā' (U+0101 U+0027)
  0x01, 0x01, 0x20, 0x19, 0x01, // ā’ (U+0101 U+2019)
  0x01, 0x01, 0x20, 0x1D, 0x01, // ā” (U+0101 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x08, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x08, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x43, 0x02, // ĂC (U+0102 U+0043)
  0x01, 0x02, 0x00, 0x47, 0x02, // ĂG (U+0102 U+0047)
  0x01, 0x02, 0x00, 0x4F, 0x02, // ĂO (U+0102 U+004F)
  0x01, 0x02, 0x00, 0x51, 0x02, // ĂQ (U+0102 U+0051)
  0x01, 0x02, 0x00, 0x54, 0x08, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x56, 0x05, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x05, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x07, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0xC7, 0x02, // ĂÇ (U+0102 U+00C7)
  0x01, 0x02, 0x00, 0xD2, 0x02, // ĂÒ (U+0102 U+00D2)
  0x01, 0x02, 0x00, 0xD3, 0x02, // ĂÓ (U+0102 U+00D3)
  0x01, 0x02, 0x00, 0xD4, 0x02, // ĂÔ (U+0102 U+00D4)
  0x01, 0x02, 0x00, 0xD5, 0x02, // ĂÕ (U+0102 U+00D5)
  0x01, 0x02, 0x00, 0xD6, 0x02, // ĂÖ (U+0102 U+00D6)
  0x01, 0x02, 0x00, 0xD8, 0x02, // ĂØ (U+0102 U+00D8)
  0x01, 0x02, 0x00, 0xDD, 0x07, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x06, 0x02, // ĂĆ (U+0102 U+0106)
  0x01, 0x02, 0x01, 0x08, 0x02, // ĂĈ (U+0102 U+0108)
  0x01, 0x02, 0x01, 0x0A, 0x02, // ĂĊ (U+0102 U+010A)
  0x01, 0x02, 0x01, 0x0C, 0x02, // ĂČ (U+0102 U+010C)
  0x01, 0x02, 0x01, 0x1C, 0x02, // ĂĜ (U+0102 U+011C)
  0x01, 0x02, 0x01, 0x1E, 0x02, // ĂĞ (U+0102 U+011E)
  0x01, 0x02, 0x01, 0x20, 0x02, // ĂĠ (U+0102 U+0120)
  0x01, 0x02, 0x01, 0x22, 0x02, // ĂĢ (U+0102 U+0122)
  0x01, 0x02, 0x01, 0x4C, 0x02, // ĂŌ (U+0102 U+014C)
  0x01, 0x02, 0x01, 0x4E, 0x02, // ĂŎ (U+0102 U+014E)
  0x01, 0x02, 0x01, 0x50, 0x02, // ĂŐ (U+0102 U+0150)
  0x01, 0x02, 0x01, 0x52, 0x02, // ĂŒ (U+0102 U+0152)
  0x01, 0x02, 0x01, 0x62, 0x08, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x08, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x08, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x74, 0x05, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x76, 0x07, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x07, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x19, 0x08, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x08, // Ă” (U+0102 U+201D)
  0x01, 0x03, 0x00, 0x22, 0x01, // ă" (U+0103 U+0022)
  0x01, 0x03, 0x00, 0x27, 0x01, // ă' (U+0103 U+0027)
  0x01, 0x03, 0x20, 0x19, 0x01, // ă’ (U+0103 U+2019)
  0x01, 0x03, 0x20, 0x1D, 0x01, // ă” (U+0103 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x08, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x08, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x43, 0x02, // ĄC (U+0104 U+0043)
  0x01, 0x04, 0x00, 0x47, 0x02, // ĄG (U+0104 U+0047)
  0x01, 0x04, 0x00, 0x4F, 0x02, // ĄO (U+0104 U+004F)
  0x01, 0x04, 0x00, 0x51, 0x02, // ĄQ (U+0104 U+0051)
  0x01, 0x04, 0x00, 0x54, 0x08, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x56, 0x05, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x05, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x07, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0xC7, 0x02, // ĄÇ (U+0104 U+00C7)
  0x01, 0x04, 0x00, 0xD2, 0x02, // ĄÒ (U+0104 U+00D2)
  0x01, 0x04, 0x00, 0xD3, 0x02, // ĄÓ (U+0104 U+00D3)
  0x01, 0x04, 0x00, 0xD4, 0x02, // ĄÔ (U+0104 U+00D4)
  0x01, 0x04, 0x00, 0xD5, 0x02, // ĄÕ (U+0104 U+00D5)
  0x01, 0x04, 0x00, 0xD6, 0x02, // ĄÖ (U+0104 U+00D6)
  0x01, 0x04, 0x00, 0xD8, 0x02, // ĄØ (U+0104 U+00D8)
  0x01, 0x04, 0x00, 0xDD, 0x07, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x06, 0x02, // ĄĆ (U+0104 U+0106)
  0x01, 0x04, 0x01, 0x08, 0x02, // ĄĈ (U+0104 U+0108)
  0x01, 0x04, 0x01, 0x0A, 0x02, // ĄĊ (U+0104 U+010A)
  0x01, 0x04, 0x01, 0x0C, 0x02, // ĄČ (U+0104 U+010C)
  0x01, 0x04, 0x01, 0x1C, 0x02, // ĄĜ (U+0104 U+011C)
  0x01, 0x04, 0x01, 0x1E, 0x02, // ĄĞ (U+0104 U+011E)
  0x01, 0x04, 0x01, 0x20, 0x02, // ĄĠ (U+0104 U+0120)
  0x01, 0x04, 0x01, 0x22, 0x02, // ĄĢ (U+0104 U+0122)
  0x01, 0x04, 0x01, 0x4C, 0x02, // ĄŌ (U+0104 U+014C)
  0x01, 0x04, 0x01, 0x4E, 0x02, // ĄŎ (U+0104 U+014E)
  0x01, 0x04, 0x01, 0x50, 0x02, // ĄŐ (U+0104 U+0150)
  0x01, 0x04, 0x01, 0x52, 0x02, // ĄŒ (U+0104 U+0152)
  0x01, 0x04, 0x01, 0x62, 0x08, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x08, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x08, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x74, 0x05, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x76, 0x07, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x07, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x19, 0x08, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x08, // Ą” (U+0104 U+201D)
  0x01, 0x05, 0x00, 0x22, 0x01, // ą" (U+0105 U+0022)
  0x01, 0x05, 0x00, 0x27, 0x01, // ą' (U+0105 U+0027)
  0x01, 0x05, 0x20, 0x19, 0x01, // ą’ (U+0105 U+2019)
  0x01, 0x05, 0x20, 0x1D, 0x01, // ą” (U+0105 U+201D)
  0x01, 0x06, 0x00, 0x43, 0x02, // ĆC (U+0106 U+0043)
  0x01, 0x06, 0x00, 0x47, 0x02, // ĆG (U+0106 U+0047)
  0x01, 0x06, 0x00, 0x4F, 0x02, // ĆO (U+0106 U+004F)
  0x01, 0x06, 0x00, 0x51, 0x02, // ĆQ (U+0106 U+0051)
  0x01, 0x06, 0x00, 0xAB, 0x02, // Ć« (U+0106 U+00AB)
  0x01, 0x06, 0x00, 0xC7, 0x02, // ĆÇ (U+0106 U+00C7)
  0x01, 0x06, 0x00, 0xD2, 0x02, // ĆÒ (U+0106 U+00D2)
  0x01, 0x06, 0x00, 0xD3, 0x02, // ĆÓ (U+0106 U+00D3)
  0x01, 0x06, 0x00, 0xD4, 0x02, // ĆÔ (U+0106 U+00D4)
  0x01, 0x06, 0x00, 0xD5, 0x02, // ĆÕ (U+0106 U+00D5)
  0x01, 0x06, 0x00, 0xD6, 0x02, // ĆÖ (U+0106 U+00D6)
  0x01, 0x06, 0x00, 0xD8, 0x02, // ĆØ (U+0106 U+00D8)
  0x01, 0x06, 0x01, 0x06, 0x02, // ĆĆ (U+0106 U+0106)
  0x01, 0x06, 0x01, 0x08, 0x02, // ĆĈ (U+0106 U+0108)
  0x01, 0x06, 0x01, 0x0A, 0x02, // ĆĊ (U+0106 U+010A)
  0x01, 0x06, 0x01, 0x0C, 0x02, // ĆČ (U+0106 U+010C)
  0x01, 0x06, 0x01, 0x1C, 0x02, // ĆĜ (U+0106 U+011C)
  0x01, 0x06, 0x01, 0x1E, 0x02, // ĆĞ (U+0106 U+011E)
  0x01, 0x06, 0x01, 0x20, 0x02, // ĆĠ (U+0106 U+0120)
  0x01, 0x06, 0x01, 0x22, 0x02, // ĆĢ (U+0106 U+0122)
  0x01, 0x06, 0x01, 0x4C, 0x02, // ĆŌ (U+0106 U+014C)
  0x01, 0x06, 0x01, 0x4E, 0x02, // ĆŎ (U+0106 U+014E)
  0x01, 0x06, 0x01, 0x50, 0x02, // ĆŐ (U+0106 U+0150)
  0x01, 0x06, 0x01, 0x52, 0x02, // ĆŒ (U+0106 U+0152)
  0x01, 0x06, 0x20, 0x39, 0x02, // Ć‹ (U+0106 U+2039)
  0x01, 0x08, 0x00, 0x43, 0x02, // ĈC (U+0108 U+0043)
  0x01, 0x08, 0x00, 0x47, 0x02, // ĈG (U+0108 U+0047)
  0x01, 0x08, 0x00, 0x4F, 0x02, // ĈO (U+0108 U+004F)
  0x01, 0x08, 0x00, 0x51, 0x02, // ĈQ (U+0108 U+0051)
  0x01, 0x08, 0x00, 0xAB, 0x02, // Ĉ« (U+0108 U+00AB)
  0x01, 0x08, 0x00, 0xC7, 0x02, // ĈÇ (U+0108 U+00C7)
  0x01, 0x08, 0x00, 0xD2, 0x02, // ĈÒ (U+0108 U+00D2)
  0x01, 0x08, 0x00, 0xD3, 0x02, // ĈÓ (U+0108 U+00D3)
  0x01, 0x08, 0x00, 0xD4, 0x02, // ĈÔ (U+0108 U+00D4)
  0x01, 0x08, 0x00, 0xD5, 0x02, // ĈÕ (U+0108 U+00D5)
  0x01, 0x08, 0x00, 0xD6, 0x02, // ĈÖ (U+0108 U+00D6)
  0x01, 0x08, 0x00, 0xD8, 0x02, // ĈØ (U+0108 U+00D8)
  0x01, 0x08, 0x01, 0x06, 0x02, // ĈĆ (U+0108 U+0106)
  0x01, 0x08, 0x01, 0x08, 0x02, // ĈĈ (U+0108 U+0108)
  0x01, 0x08, 0x01, 0x0A, 0x02, // ĈĊ (U+0108 U+010A)
  0x01, 0x08, 0x01, 0x0C, 0x02, // ĈČ (U+0108 U+010C)
  0x01, 0x08, 0x01, 0x1C, 0x02, // ĈĜ (U+0108 U+011C)
  0x01, 0x08, 0x01, 0x1E, 0x02, // ĈĞ (U+0108 U+011E)
  0x01, 0x08, 0x01, 0x20, 0x02, // ĈĠ (U+0108 U+0120)
  0x01, 0x08, 0x01, 0x22, 0x02, // ĈĢ (U+0108 U+0122)
  0x01, 0x08, 0x01, 0x4C, 0x02, // ĈŌ (U+0108 U+014C)
  0x01, 0x08, 0x01, 0x4E, 0x02, // ĈŎ (U+0108 U+014E)
  0x01, 0x08, 0x01, 0x50, 0x02, // ĈŐ (U+0108 U+0150)
  0x01, 0x08, 0x01, 0x52, 0x02, // ĈŒ (U+0108 U+0152)
  0x01, 0x08, 0x20, 0x39, 0x02, // Ĉ‹ (U+0108 U+2039)
  0x01, 0x0A, 0x00, 0x43, 0x02, // ĊC (U+010A U+0043)
  0x01, 0x0A, 0x00, 0x47, 0x02, // ĊG (U+010A U+0047)
  0x01, 0x0A, 0x00, 0x4F, 0x02, // ĊO (U+010A U+004F)
  0x01, 0x0A, 0x00, 0x51, 0x02, // ĊQ (U+010A U+0051)
  0x01, 0x0A, 0x00, 0xAB, 0x02, // Ċ« (U+010A U+00AB)
  0x01, 0x0A, 0x00, 0xC7, 0x02, // ĊÇ (U+010A U+00C7)
  0x01, 0x0A, 0x00, 0xD2, 0x02, // ĊÒ (U+010A U+00D2)
  0x01, 0x0A, 0x00, 0xD3, 0x02, // ĊÓ (U+010A U+00D3)
  0x01, 0x0A, 0x00, 0xD4, 0x02, // ĊÔ (U+010A U+00D4)
  0x01, 0x0A, 0x00, 0xD5, 0x02, // ĊÕ (U+010A U+00D5)
  0x01, 0x0A, 0x00, 0xD6, 0x02, // ĊÖ (U+010A U+00D6)
  0x01, 0x0A, 0x00, 0xD8, 0x02, // ĊØ (U+010A U+00D8)
  0x01, 0x0A, 0x01, 0x06, 0x02, // ĊĆ (U+010A U+0106)
  0x01, 0x0A, 0x01, 0x08, 0x02, // ĊĈ (U+010A U+0108)
  0x01, 0x0A, 0x01, 0x0A, 0x02, // ĊĊ (U+010A U+010A)
  0x01, 0x0A, 0x01, 0x0C, 0x02, // ĊČ (U+010A U+010C)
  0x01, 0x0A, 0x01, 0x1C, 0x02, // ĊĜ (U+010A U+011C)
  0x01, 0x0A, 0x01, 0x1E, 0x02, // ĊĞ (U+010A U+011E)
  0x01, 0x0A, 0x01, 0x20, 0x02, // ĊĠ (U+010A U+0120)
  0x01, 0x0A, 0x01, 0x22, 0x02, // ĊĢ (U+010A U+0122)
  0x01, 0x0A, 0x01, 0x4C, 0x02, // ĊŌ (U+010A U+014C)
  0x01, 0x0A, 0x01, 0x4E, 0x02, // ĊŎ (U+010A U+014E)
  0x01, 0x0A, 0x01, 0x50, 0x02, // ĊŐ (U+010A U+0150)
  0x01, 0x0A, 0x01, 0x52, 0x02, // ĊŒ (U+010A U+0152)
  0x01, 0x0A, 0x20, 0x39, 0x02, // Ċ‹ (U+010A U+2039)
  0x01, 0x0C, 0x00, 0x43, 0x02, // ČC (U+010C U+0043)
  0x01, 0x0C, 0x00, 0x47, 0x02, // ČG (U+010C U+0047)
  0x01, 0x0C, 0x00, 0x4F, 0x02, // ČO (U+010C U+004F)
  0x01, 0x0C, 0x00, 0x51, 0x02, // ČQ (U+010C U+0051)
  0x01, 0x0C, 0x00, 0xAB, 0x02, // Č« (U+010C U+00AB)
  0x01, 0x0C, 0x00, 0xC7, 0x02, // ČÇ (U+010C U+00C7)
  0x01, 0x0C, 0x00, 0xD2, 0x02, // ČÒ (U+010C U+00D2)
  0x01, 0x0C, 0x00, 0xD3, 0x02, // ČÓ (U+010C U+00D3)
  0x01, 0x0C, 0x00, 0xD4, 0x02, // ČÔ (U+010C U+00D4)
  0x01, 0x0C, 0x00, 0xD5, 0x02, // ČÕ (U+010C U+00D5)
  0x01, 0x0C, 0x00, 0xD6, 0x02, // ČÖ (U+010C U+00D6)
  0x01, 0x0C, 0x00, 0xD8, 0x02, // ČØ (U+010C U+00D8)
  0x01, 0x0C, 0x01, 0x06, 0x02, // ČĆ (U+010C U+0106)
  0x01, 0x0C, 0x01, 0x08, 0x02, // ČĈ (U+010C U+0108)
  0x01, 0x0C, 0x01, 0x0A, 0x02, // ČĊ (U+010C U+010A)
  0x01, 0x0C, 0x01, 0x0C, 0x02, // ČČ (U+010C U+010C)
  0x01, 0x0C, 0x01, 0x1C, 0x02, // ČĜ (U+010C U+011C)
  0x01, 0x0C, 0x01, 0x1E, 0x02, // ČĞ (U+010C U+011E)
  0x01, 0x0C, 0x01, 0x20, 0x02, // ČĠ (U+010C U+0120)
  0x01, 0x0C, 0x01, 0x22, 0x02, // ČĢ (U+010C U+0122)
  0x01, 0x0C, 0x01, 0x4C, 0x02, // ČŌ (U+010C U+014C)
  0x01, 0x0C, 0x01, 0x4E, 0x02, // ČŎ (U+010C U+014E)
  0x01, 0x0C, 0x01, 0x50, 0x02, // ČŐ (U+010C U+0150)
  0x01, 0x0C, 0x01, 0x52, 0x02, // ČŒ (U+010C U+0152)
  0x01, 0x0C, 0x20, 0x39, 0x02, // Č‹ (U+010C U+2039)
  0x01, 0x0E, 0x00, 0x2C, 0x05, // Ď, (U+010E U+002C)
  0x01, 0x0E, 0x00, 0x2E, 0x05, // Ď. (U+010E U+002E)
  0x01, 0x0E, 0x00, 0x41, 0x02, // ĎA (U+010E U+0041)
  0x01, 0x0E, 0x00, 0x54, 0x04, // ĎT (U+010E U+0054)
  0x01, 0x0E, 0x00, 0x56, 0x01, // ĎV (U+010E U+0056)
  0x01, 0x0E, 0x00, 0x57, 0x01, // ĎW (U+010E U+0057)
  0x01, 0x0E, 0x00, 0x58, 0x02, // ĎX (U+010E U+0058)
  0x01, 0x0E, 0x00, 0x59, 0x01, // ĎY (U+010E U+0059)
  0x01, 0x0E, 0x00, 0x5A, 0x01, // ĎZ (U+010E U+005A)
  0x01, 0x0E, 0x00, 0xC0, 0x02, // ĎÀ (U+010E U+00C0)
  0x01, 0x0E, 0x00, 0xC1, 0x02, // ĎÁ (U+010E U+00C1)
  0x01, 0x0E, 0x00, 0xC2, 0x02, // ĎÂ (U+010E U+00C2)
  0x01, 0x0E, 0x00, 0xC3, 0x02, // ĎÃ (U+010E U+00C3)
  0x01, 0x0E, 0x00, 0xC4, 0x02, // ĎÄ (U+010E U+00C4)
  0x01, 0x0E, 0x00, 0xC5, 0x02, // ĎÅ (U+010E U+00C5)
  0x01, 0x0E, 0x00, 0xDD, 0x01, // ĎÝ (U+010E U+00DD)
  0x01, 0x0E, 0x01, 0x00, 0x02, // ĎĀ (U+010E U+0100)
  0x01, 0x0E, 0x01, 0x02, 0x02, // ĎĂ (U+010E U+0102)
  0x01, 0x0E, 0x01, 0x04, 0x02, // ĎĄ (U+010E U+0104)
  0x01, 0x0E, 0x01, 0x62, 0x04, // ĎŢ (U+010E U+0162)
  0x01, 0x0E, 0x01, 0x64, 0x04, // ĎŤ (U+010E U+0164)
  0x01, 0x0E, 0x01, 0x66, 0x04, // ĎŦ (U+010E U+0166)
  0x01, 0x0E, 0x01, 0x74, 0x01, // ĎŴ (U+010E U+0174)
  0x01, 0x0E, 0x01, 0x76, 0x01, // ĎŶ (U+010E U+0176)
  0x01, 0x0E, 0x01, 0x78, 0x01, // ĎŸ (U+010E U+0178)
  0x01, 0x0E, 0x01, 0x79, 0x01, // ĎŹ (U+010E U+0179)
  0x01, 0x0E, 0x01, 0x7B, 0x01, // ĎŻ (U+010E U+017B)
  0x01, 0x0E, 0x01, 0x7D, 0x01, // ĎŽ (U+010E U+017D)
  0x01, 0x0E, 0x20, 0x1A, 0x05, // Ď‚ (U+010E U+201A)
  0x01, 0x0E, 0x20, 0x1E, 0x05, // Ď„ (U+010E U+201E)
  0x01, 0x0E, 0x20, 0x26, 0x05, // Ď… (U+010E U+2026)
  0x01, 0x10, 0x00, 0x2C, 0x05, // Đ, (U+0110 U+002C)
  0x01, 0x10, 0x00, 0x2E, 0x05, // Đ. (U+0110 U+002E)
  0x01, 0x10, 0x00, 0x41, 0x02, // ĐA (U+0110 U+0041)
  0x01, 0x10, 0x00, 0x54, 0x04, // ĐT (U+0110 U+0054)
  0x01, 0x10, 0x00, 0x56, 0x01, // ĐV (U+0110 U+0056)
  0x01, 0x10, 0x00, 0x57, 0x01, // ĐW (U+0110 U+0057)
  0x01, 0x10, 0x00, 0x58, 0x02, // ĐX (U+0110 U+0058)
  0x01, 0x10, 0x00, 0x59, 0x01, // ĐY (U+0110 U+0059)
  0x01, 0x10, 0x00, 0x5A, 0x01, // ĐZ (U+0110 U+005A)
  0x01, 0x10, 0x00, 0xC0, 0x02, // ĐÀ (U+0110 U+00C0)
  0x01, 0x10, 0x00, 0xC1, 0x02, // ĐÁ (U+0110 U+00C1)
  0x01, 0x10, 0x00, 0xC2, 0x02, // ĐÂ (U+0110 U+00C2)
  0x01, 0x10, 0x00, 0xC3, 0x02, // ĐÃ (U+0110 U+00C3)
  0x01, 0x10, 0x00, 0xC4, 0x02, // ĐÄ (U+0110 U+00C4)
  0x01, 0x10, 0x00, 0xC5, 0x02, // ĐÅ (U+0110 U+00C5)
  0x01, 0x10, 0x00, 0xDD, 0x01, // ĐÝ (U+0110 U+00DD)
  0x01, 0x10, 0x01, 0x00, 0x02, // ĐĀ (U+0110 U+0100)
  0x01, 0x10, 0x01, 0x02, 0x02, // ĐĂ (U+0110 U+0102)
  0x01, 0x10, 0x01, 0x04, 0x02, // ĐĄ (U+0110 U+0104)
  0x01, 0x10, 0x01, 0x62, 0x04, // ĐŢ (U+0110 U+0162)
  0x01, 0x10, 0x01, 0x64, 0x04, // ĐŤ (U+0110 U+0164)
  0x01, 0x10, 0x01, 0x66, 0x04, // ĐŦ (U+0110 U+0166)
  0x01, 0x10, 0x01, 0x74, 0x01, // ĐŴ (U+0110 U+0174)
  0x01, 0x10, 0x01, 0x76, 0x01, // ĐŶ (U+0110 U+0176)
  0x01, 0x10, 0x01, 0x78, 0x01, // ĐŸ (U+0110 U+0178)
  0x01, 0x10, 0x01, 0x79, 0x01, // ĐŹ (U+0110 U+0179)
  0x01, 0x10, 0x01, 0x7B, 0x01, // ĐŻ (U+0110 U+017B)
  0x01, 0x10, 0x01, 0x7D, 0x01, // ĐŽ (U+0110 U+017D)
  0x01, 0x10, 0x20, 0x1A, 0x05, // Đ‚ (U+0110 U+201A)
  0x01, 0x10, 0x20, 0x1E, 0x05, // Đ„ (U+0110 U+201E)
  0x01, 0x10, 0x20, 0x26, 0x05, // Đ… (U+0110 U+2026)
  0x01, 0x13, 0x00, 0x22, 0x01, // ē" (U+0113 U+0022)
  0x01, 0x13, 0x00, 0x27, 0x01, // ē' (U+0113 U+0027)
  0x01, 0x13, 0x00, 0x76, 0x02, // ēv (U+0113 U+0076)
  0x01, 0x13, 0x00, 0x77, 0x02, // ēw (U+0113 U+0077)
  0x01, 0x13, 0x00, 0x78, 0x02, // ēx (U+0113 U+0078)
  0x01, 0x13, 0x00, 0x79, 0x02, // ēy (U+0113 U+0079)
  0x01, 0x13, 0x00, 0x7A, 0x01, // ēz (U+0113 U+007A)
  0x01, 0x13, 0x00, 0xFD, 0x02, // ēý (U+0113 U+00FD)
  0x01, 0x13, 0x00, 0xFF, 0x02, // ēÿ (U+0113 U+00FF)
  0x01, 0x13, 0x01, 0x75, 0x02, // ēŵ (U+0113 U+0175)
  0x01, 0x13, 0x01, 0x77, 0x02, // ēŷ (U+0113 U+0177)
  0x01, 0x13, 0x01, 0x7A, 0x01, // ēź (U+0113 U+017A)
  0x01, 0x13, 0x01, 0x7C, 0x01, // ēż (U+0113 U+017C)
  0x01, 0x13, 0x01, 0x7E, 0x01, // ēž (U+0113 U+017E)
  0x01, 0x13, 0x20, 0x19, 0x01, // ē’ (U+0113 U+2019)
  0x01, 0x13, 0x20, 0x1D, 0x01, // ē” (U+0113 U+201D)
  0x01, 0x15, 0x00, 0x22, 0x01, // ĕ" (U+0115 U+0022)
  0x01, 0x15, 0x00, 0x27, 0x01, // ĕ' (U+0115 U+0027)
  0x01, 0x15, 0x00, 0x76, 0x02, // ĕv (U+0115 U+0076)
  0x01, 0x15, 0x00, 0x77, 0x02, // ĕw (U+0115 U+0077)
  0x01, 0x15, 0x00, 0x78, 0x02, // ĕx (U+0115 U+0078)
  0x01, 0x15, 0x00, 0x79, 0x02, // ĕy (U+0115 U+0079)
  0x01, 0x15, 0x00, 0x7A, 0x01, // ĕz (U+0115 U+007A)
  0x01, 0x15, 0x00, 0xFD, 0x02, // ĕý (U+0115 U+00FD)
  0x01, 0x15, 0x00, 0xFF, 0x02, // ĕÿ (U+0115 U+00FF)
  0x01, 0x15, 0x01, 0x75, 0x02, // ĕŵ (U+0115 U+0175)
  0x01, 0x15, 0x01, 0x77, 0x02, // ĕŷ (U+0115 U+0177)
  0x01, 0x15, 0x01, 0x7A, 0x01, // ĕź (U+0115 U+017A)
  0x01, 0x15, 0x01, 0x7C, 0x01, // ĕż (U+0115 U+017C)
  0x01, 0x15, 0x01, 0x7E, 0x01, // ĕž (U+0115 U+017E)
  0x01, 0x15, 0x20, 0x19, 0x01, // ĕ’ (U+0115 U+2019)
  0x01, 0x15, 0x20, 0x1D, 0x01, // ĕ” (U+0115 U+201D)
  0x01, 0x17, 0x00, 0x22, 0x01, // ė" (U+0117 U+0022)
  0x01, 0x17, 0x00, 0x27, 0x01, // ė' (U+0117 U+0027)
  0x01, 0x17, 0x00, 0x76, 0x02, // ėv (U+0117 U+0076)
  0x01, 0x17, 0x00, 0x77, 0x02, // ėw (U+0117 U+0077)
  0x01, 0x17, 0x00, 0x78, 0x02, // ėx (U+0117 U+0078)
  0x01, 0x17, 0x00, 0x79, 0x02, // ėy (U+0117 U+0079)
  0x01, 0x17, 0x00, 0x7A, 0x01, // ėz (U+0117 U+007A)
  0x01, 0x17, 0x00, 0xFD, 0x02, // ėý (U+0117 U+00FD)
  0x01, 0x17, 0x00, 0xFF, 0x02, // ėÿ (U+0117 U+00FF)
  0x01, 0x17, 0x01, 0x75, 0x02, // ėŵ (U+0117 U+0175)
  0x01, 0x17, 0x01, 0x77, 0x02, // ėŷ (U+0117 U+0177)
  0x01, 0x17, 0x01, 0x7A, 0x01, // ėź (U+0117 U+017A)
  0x01, 0x17, 0x01, 0x7C, 0x01, // ėż (U+0117 U+017C)
  0x01, 0x17, 0x01, 0x7E, 0x01, // ėž (U+0117 U+017E)
  0x01, 0x17, 0x20, 0x19, 0x01, // ė’ (U+0117 U+2019)
  0x01, 0x17, 0x20, 0x1D, 0x01, // ė” (U+0117 U+201D)
  0x01, 0x19, 0x00, 0x22, 0x01, // ę" (U+0119 U+0022)
  0x01, 0x19, 0x00, 0x27, 0x01, // ę' (U+0119 U+0027)
  0x01, 0x19, 0x00, 0x76, 0x02, // ęv (U+0119 U+0076)
  0x01, 0x19, 0x00, 0x77, 0x02, // ęw (U+0119 U+0077)
  0x01, 0x19, 0x00, 0x78, 0x02, // ęx (U+0119 U+0078)
  0x01, 0x19, 0x00, 0x79, 0x02, // ęy (U+0119 U+0079)
  0x01, 0x19, 0x00, 0x7A, 0x01, // ęz (U+0119 U+007A)
  0x01, 0x19, 0x00, 0xFD, 0x02, // ęý (U+0119 U+00FD)
  0x01, 0x19, 0x00, 0xFF, 0x02, // ęÿ (U+0119 U+00FF)
  0x01, 0x19, 0x01, 0x75, 0x02, // ęŵ (U+0119 U+0175)
  0x01, 0x19, 0x01, 0x77, 0x02, // ęŷ (U+0119 U+0177)
  0x01, 0x19, 0x01, 0x7A, 0x01, // ęź (U+0119 U+017A)
  0x01, 0x19, 0x01, 0x7C, 0x01, // ęż (U+0119 U+017C)
  0x01, 0x19, 0x01, 0x7E, 0x01, // ęž (U+0119 U+017E)
  0x01, 0x19, 0x20, 0x19, 0x01, // ę’ (U+0119 U+2019)
  0x01, 0x19, 0x20, 0x1D, 0x01, // ę” (U+0119 U+201D)
  0x01, 0x1B, 0x00, 0x22, 0x01, // ě" (U+011B U+0022)
  0x01, 0x1B, 0x00, 0x27, 0x01, // ě' (U+011B U+0027)
  0x01, 0x1B, 0x00, 0x76, 0x02, // ěv (U+011B U+0076)
  0x01, 0x1B, 0x00, 0x77, 0x02, // ěw (U+011B U+0077)
  0x01, 0x1B, 0x00, 0x78, 0x02, // ěx (U+011B U+0078)
  0x01, 0x1B, 0x00, 0x79, 0x02, // ěy (U+011B U+0079)
  0x01, 0x1B, 0x00, 0x7A, 0x01, // ěz (U+011B U+007A)
  0x01, 0x1B, 0x00, 0xFD, 0x02, // ěý (U+011B U+00FD)
  0x01, 0x1B, 0x00, 0xFF, 0x02, // ěÿ (U+011B U+00FF)
  0x01, 0x1B, 0x01, 0x75, 0x02, // ěŵ (U+011B U+0175)
  0x01, 0x1B, 0x01, 0x77, 0x02, // ěŷ (U+011B U+0177)
  0x01, 0x1B, 0x01, 0x7A, 0x01, // ěź (U+011B U+017A)
  0x01, 0x1B, 0x01, 0x7C, 0x01, // ěż (U+011B U+017C)
  0x01, 0x1B, 0x01, 0x7E, 0x01, // ěž (U+011B U+017E)
  0x01, 0x1B, 0x20, 0x19, 0x01, // ě’ (U+011B U+2019)
  0x01, 0x1B, 0x20, 0x1D, 0x01, // ě” (U+011B U+201D)
  0x01, 0x25, 0x00, 0x22, 0x01, // ĥ" (U+0125 U+0022)
  0x01, 0x25, 0x00, 0x27, 0x01, // ĥ' (U+0125 U+0027)
  0x01, 0x25, 0x20, 0x19, 0x01, // ĥ’ (U+0125 U+2019)
  0x01, 0x25, 0x20, 0x1D, 0x01, // ĥ” (U+0125 U+201D)
  0x01, 0x36, 0x00, 0x43, 0x02, // ĶC (U+0136 U+0043)
  0x01, 0x36, 0x00, 0x47, 0x02, // ĶG (U+0136 U+0047)
  0x01, 0x36, 0x00, 0x4F, 0x02, // ĶO (U+0136 U+004F)
  0x01, 0x36, 0x00, 0x51, 0x02, // ĶQ (U+0136 U+0051)
  0x01, 0x36, 0x00, 0xAB, 0x02, // Ķ« (U+0136 U+00AB)
  0x01, 0x36, 0x00, 0xC7, 0x02, // ĶÇ (U+0136 U+00C7)
  0x01, 0x36, 0x00, 0xD2, 0x02, // ĶÒ (U+0136 U+00D2)
  0x01, 0x36, 0x00, 0xD3, 0x02, // ĶÓ (U+0136 U+00D3)
  0x01, 0x36, 0x00, 0xD4, 0x02, // ĶÔ (U+0136 U+00D4)
  0x01, 0x36, 0x00, 0xD5, 0x02, // ĶÕ (U+0136 U+00D5)
  0x01, 0x36, 0x00, 0xD6, 0x02, // ĶÖ (U+0136 U+00D6)
  0x01, 0x36, 0x00, 0xD8, 0x02, // ĶØ (U+0136 U+00D8)
  0x01, 0x36, 0x01, 0x06, 0x02, // ĶĆ (U+0136 U+0106)
  0x01, 0x36, 0x01, 0x08, 0x02, // ĶĈ (U+0136 U+0108)
  0x01, 0x36, 0x01, 0x0A, 0x02, // ĶĊ (U+0136 U+010A)
  0x01, 0x36, 0x01, 0x0C, 0x02, // ĶČ (U+0136 U+010C)
  0x01, 0x36, 0x01, 0x1C, 0x02, // ĶĜ (U+0136 U+011C)
  0x01, 0x36, 0x01, 0x1E, 0x02, // ĶĞ (U+0136 U+011E)
  0x01, 0x36, 0x01, 0x20, 0x02, // ĶĠ (U+0136 U+0120)
  0x01, 0x36, 0x01, 0x22, 0x02, // ĶĢ (U+0136 U+0122)
  0x01, 0x36, 0x01, 0x4C, 0x02, // ĶŌ (U+0136 U+014C)
  0x01, 0x36, 0x01, 0x4E, 0x02, // ĶŎ (U+0136 U+014E)
  0x01, 0x36, 0x01, 0x50, 0x02, // ĶŐ (U+0136 U+0150)
  0x01, 0x36, 0x01, 0x52, 0x02, // ĶŒ (U+0136 U+0152)
  0x01, 0x36, 0x20, 0x39, 0x02, // Ķ‹ (U+0136 U+2039)
  0x01, 0x38, 0x00, 0x63, 0x02, // ĸc (U+0138 U+0063)
  0x01, 0x38, 0x00, 0x64, 0x02, // ĸd (U+0138 U+0064)
  0x01, 0x38, 0x00, 0x65, 0x02, // ĸe (U+0138 U+0065)
  0x01, 0x38, 0x00, 0x6F, 0x02, // ĸo (U+0138 U+006F)
  0x01, 0x38, 0x00, 0x71, 0x02, // ĸq (U+0138 U+0071)
  0x01, 0x38, 0x00, 0xE0, 0x02, // ĸà (U+0138 U+00E0)
  0x01, 0x38, 0x00, 0xE7, 0x02, // ĸç (U+0138 U+00E7)
  0x01, 0x38, 0x00, 0xE8, 0x02, // ĸè (U+0138 U+00E8)
  0x01, 0x38, 0x00, 0xE9, 0x02, // ĸé (U+0138 U+00E9)
  0x01, 0x38, 0x00, 0xEA, 0x02, // ĸê (U+0138 U+00EA)
  0x01, 0x38, 0x00, 0xEB, 0x02, // ĸë (U+0138 U+00EB)
  0x01, 0x38, 0x00, 0xF2, 0x02, // ĸò (U+0138 U+00F2)
  0x01, 0x38, 0x00, 0xF3, 0x02, // ĸó (U+0138 U+00F3)
  0x01, 0x38, 0x00, 0xF4, 0x02, // ĸô (U+0138 U+00F4)
  0x01, 0x38, 0x00, 0xF5, 0x02, // ĸõ (U+0138 U+00F5)
  0x01, 0x38, 0x00, 0xF6, 0x02, // ĸö (U+0138 U+00F6)
  0x01, 0x38, 0x00, 0xF8, 0x02, // ĸø (U+0138 U+00F8)
  0x01, 0x38, 0x01, 0x07, 0x02, // ĸć (U+0138 U+0107)
  0x01, 0x38, 0x01, 0x09, 0x02, // ĸĉ (U+0138 U+0109)
  0x01, 0x38, 0x01, 0x0B, 0x02, // ĸċ (U+0138 U+010B)
  0x01, 0x38, 0x01, 0x0D, 0x02, // ĸč (U+0138 U+010D)
  0x01, 0x38, 0x01, 0x0F, 0x02, // ĸď (U+0138 U+010F)
  0x01, 0x38, 0x01, 0x11, 0x02, // ĸđ (U+0138 U+0111)
  0x01, 0x38, 0x01, 0x13, 0x02, // ĸē (U+0138 U+0113)
  0x01, 0x38, 0x01, 0x15, 0x02, // ĸĕ (U+0138 U+0115)
  0x01, 0x38, 0x01, 0x17, 0x02, // ĸė (U+0138 U+0117)
  0x01, 0x38, 0x01, 0x19, 0x02, // ĸę (U+0138 U+0119)
  0x01, 0x38, 0x01, 0x1B, 0x02, // ĸě (U+0138 U+011B)
  0x01, 0x38, 0x01, 0x4D, 0x02, // ĸō (U+0138 U+014D)
  0x01, 0x38, 0x01, 0x4F, 0x02, // ĸŏ (U+0138 U+014F)
  0x01, 0x38, 0x01, 0x51, 0x02, // ĸő (U+0138 U+0151)
  0x01, 0x38, 0x01, 0x53, 0x02, // ĸœ (U+0138 U+0153)
  0x01, 0x39, 0x00, 0x22, 0x0A, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x0A, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x43, 0x02, // ĹC (U+0139 U+0043)
  0x01, 0x39, 0x00, 0x47, 0x02, // ĹG (U+0139 U+0047)
  0x01, 0x39, 0x00, 0x4F, 0x02, // ĹO (U+0139 U+004F)
  0x01, 0x39, 0x00, 0x51, 0x02, // ĹQ (U+0139 U+0051)
  0x01, 0x39, 0x00, 0x54, 0x02, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x55, 0x01, // ĹU (U+0139 U+0055)
  0x01, 0x39, 0x00, 0x56, 0x02, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x02, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x04, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xC7, 0x02, // ĹÇ (U+0139 U+00C7)
  0x01, 0x39, 0x00, 0xD2, 0x02, // ĹÒ (U+0139 U+00D2)
  0x01, 0x39, 0x00, 0xD3, 0x02, // ĹÓ (U+0139 U+00D3)
  0x01, 0x39, 0x00, 0xD4, 0x02, // ĹÔ (U+0139 U+00D4)
  0x01, 0x39, 0x00, 0xD5, 0x02, // ĹÕ (U+0139 U+00D5)
  0x01, 0x39, 0x00, 0xD6, 0x02, // ĹÖ (U+0139 U+00D6)
  0x01, 0x39, 0x00, 0xD8, 0x02, // ĹØ (U+0139 U+00D8)
  0x01, 0x39, 0x00, 0xD9, 0x01, // ĹÙ (U+0139 U+00D9)
  0x01, 0x39, 0x00, 0xDA, 0x01, // ĹÚ (U+0139 U+00DA)
  0x01, 0x39, 0x00, 0xDB, 0x01, // ĹÛ (U+0139 U+00DB)
  0x01, 0x39, 0x00, 0xDC, 0x01, // ĹÜ (U+0139 U+00DC)
  0x01, 0x39, 0x00, 0xDD, 0x04, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x06, 0x02, // ĹĆ (U+0139 U+0106)
  0x01, 0x39, 0x01, 0x08, 0x02, // ĹĈ (U+0139 U+0108)
  0x01, 0x39, 0x01, 0x0A, 0x02, // ĹĊ (U+0139 U+010A)
  0x01, 0x39, 0x01, 0x0C, 0x02, // ĹČ (U+0139 U+010C)
  0x01, 0x39, 0x01, 0x1C, 0x02, // ĹĜ (U+0139 U+011C)
  0x01, 0x39, 0x01, 0x1E, 0x02, // ĹĞ (U+0139 U+011E)
  0x01, 0x39, 0x01, 0x20, 0x02, // ĹĠ (U+0139 U+0120)
  0x01, 0x39, 0x01, 0x22, 0x02, // ĹĢ (U+0139 U+0122)
  0x01, 0x39, 0x01, 0x4C, 0x02, // ĹŌ (U+0139 U+014C)
  0x01, 0x39, 0x01, 0x4E, 0x02, // ĹŎ (U+0139 U+014E)
  0x01, 0x39, 0x01, 0x50, 0x02, // ĹŐ (U+0139 U+0150)
  0x01, 0x39, 0x01, 0x52, 0x02, // ĹŒ (U+0139 U+0152)
  0x01, 0x39, 0x01, 0x62, 0x02, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x02, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x02, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x01, 0x68, 0x01, // ĹŨ (U+0139 U+0168)
  0x01, 0x39, 0x01, 0x6A, 0x01, // ĹŪ (U+0139 U+016A)
  0x01, 0x39, 0x01, 0x6C, 0x01, // ĹŬ (U+0139 U+016C)
  0x01, 0x39, 0x01, 0x6E, 0x01, // ĹŮ (U+0139 U+016E)
  0x01, 0x39, 0x01, 0x70, 0x01, // ĹŰ (U+0139 U+0170)
  0x01, 0x39, 0x01, 0x72, 0x01, // ĹŲ (U+0139 U+0172)
  0x01, 0x39, 0x01, 0x74, 0x02, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x04, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x04, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x19, 0x0A, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x0A, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x0A, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x0A, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x43, 0x02, // ĻC (U+013B U+0043)
  0x01, 0x3B, 0x00, 0x47, 0x02, // ĻG (U+013B U+0047)
  0x01, 0x3B, 0x00, 0x4F, 0x02, // ĻO (U+013B U+004F)
  0x01, 0x3B, 0x00, 0x51, 0x02, // ĻQ (U+013B U+0051)
  0x01, 0x3B, 0x00, 0x54, 0x02, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x55, 0x01, // ĻU (U+013B U+0055)
  0x01, 0x3B, 0x00, 0x56, 0x02, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x02, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x04, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xC7, 0x02, // ĻÇ (U+013B U+00C7)
  0x01, 0x3B, 0x00, 0xD2, 0x02, // ĻÒ (U+013B U+00D2)
  0x01, 0x3B, 0x00, 0xD3, 0x02, // ĻÓ (U+013B U+00D3)
  0x01, 0x3B, 0x00, 0xD4, 0x02, // ĻÔ (U+013B U+00D4)
  0x01, 0x3B, 0x00, 0xD5, 0x02, // ĻÕ (U+013B U+00D5)
  0x01, 0x3B, 0x00, 0xD6, 0x02, // ĻÖ (U+013B U+00D6)
  0x01, 0x3B, 0x00, 0xD8, 0x02, // ĻØ (U+013B U+00D8)
  0x01, 0x3B, 0x00, 0xD9, 0x01, // ĻÙ (U+013B U+00D9)
  0x01, 0x3B, 0x00, 0xDA, 0x01, // ĻÚ (U+013B U+00DA)
  0x01, 0x3B, 0x00, 0xDB, 0x01, // ĻÛ (U+013B U+00DB)
  0x01, 0x3B, 0x00, 0xDC, 0x01, // ĻÜ (U+013B U+00DC)
  0x01, 0x3B, 0x00, 0xDD, 0x04, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x06, 0x02, // ĻĆ (U+013B U+0106)
  0x01, 0x3B, 0x01, 0x08, 0x02, // ĻĈ (U+013B U+0108)
  0x01, 0x3B, 0x01, 0x0A, 0x02, // ĻĊ (U+013B U+010A)
  0x01, 0x3B, 0x01, 0x0C, 0x02, // ĻČ (U+013B U+010C)
  0x01, 0x3B, 0x01, 0x1C, 0x02, // ĻĜ (U+013B U+011C)
  0x01, 0x3B, 0x01, 0x1E, 0x02, // ĻĞ (U+013B U+011E)
  0x01, 0x3B, 0x01, 0x20, 0x02, // ĻĠ (U+013B U+0120)
  0x01, 0x3B, 0x01, 0x22, 0x02, // ĻĢ (U+013B U+0122)
  0x01, 0x3B, 0x01, 0x4C, 0x02, // ĻŌ (U+013B U+014C)
  0x01, 0x3B, 0x01, 0x4E, 0x02, // ĻŎ (U+013B U+014E)
  0x01, 0x3B, 0x01, 0x50, 0x02, // ĻŐ (U+013B U+0150)
  0x01, 0x3B, 0x01, 0x52, 0x02, // ĻŒ (U+013B U+0152)
  0x01, 0x3B, 0x01, 0x62, 0x02, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x02, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x02, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x01, 0x68, 0x01, // ĻŨ (U+013B U+0168)
  0x01, 0x3B, 0x01, 0x6A, 0x01, // ĻŪ (U+013B U+016A)
  0x01, 0x3B, 0x01, 0x6C, 0x01, // ĻŬ (U+013B U+016C)
  0x01, 0x3B, 0x01, 0x6E, 0x01, // ĻŮ (U+013B U+016E)
  0x01, 0x3B, 0x01, 0x70, 0x01, // ĻŰ (U+013B U+0170)
  0x01, 0x3B, 0x01, 0x72, 0x01, // ĻŲ (U+013B U+0172)
  0x01, 0x3B, 0x01, 0x74, 0x02, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x04, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x04, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x19, 0x0A, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x0A, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x0A, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x0A, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x00, 0x43, 0x02, // ĽC (U+013D U+0043)
  0x01, 0x3D, 0x00, 0x47, 0x02, // ĽG (U+013D U+0047)
  0x01, 0x3D, 0x00, 0x4F, 0x02, // ĽO (U+013D U+004F)
  0x01, 0x3D, 0x00, 0x51, 0x02, // ĽQ (U+013D U+0051)
  0x01, 0x3D, 0x00, 0x54, 0x02, // ĽT (U+013D U+0054)
  0x01, 0x3D, 0x00, 0x55, 0x01, // ĽU (U+013D U+0055)
  0x01, 0x3D, 0x00, 0x56, 0x02, // ĽV (U+013D U+0056)
  0x01, 0x3D, 0x00, 0x57, 0x02, // ĽW (U+013D U+0057)
  0x01, 0x3D, 0x00, 0x59, 0x04, // ĽY (U+013D U+0059)
  0x01, 0x3D, 0x00, 0xC7, 0x02, // ĽÇ (U+013D U+00C7)
  0x01, 0x3D, 0x00, 0xD2, 0x02, // ĽÒ (U+013D U+00D2)
  0x01, 0x3D, 0x00, 0xD3, 0x02, // ĽÓ (U+013D U+00D3)
  0x01, 0x3D, 0x00, 0xD4, 0x02, // ĽÔ (U+013D U+00D4)
  0x01, 0x3D, 0x00, 0xD5, 0x02, // ĽÕ (U+013D U+00D5)
  0x01, 0x3D, 0x00, 0xD6, 0x02, // ĽÖ (U+013D U+00D6)
  0x01, 0x3D, 0x00, 0xD8, 0x02, // ĽØ (U+013D U+00D8)
  0x01, 0x3D, 0x00, 0xD9, 0x01, // ĽÙ (U+013D U+00D9)
  0x01, 0x3D, 0x00, 0xDA, 0x01, // ĽÚ (U+013D U+00DA)
  0x01, 0x3D, 0x00, 0xDB, 0x01, // ĽÛ (U+013D U+00DB)
  0x01, 0x3D, 0x00, 0xDC, 0x01, // ĽÜ (U+013D U+00DC)
  0x01, 0x3D, 0x00, 0xDD, 0x04, // ĽÝ (U+013D U+00DD)
  0x01, 0x3D, 0x01, 0x06, 0x02, // ĽĆ (U+013D U+0106)
  0x01, 0x3D, 0x01, 0x08, 0x02, // ĽĈ (U+013D U+0108)
  0x01, 0x3D, 0x01, 0x0A, 0x02, // ĽĊ (U+013D U+010A)
  0x01, 0x3D, 0x01, 0x0C, 0x02, // ĽČ (U+013D U+010C)
  0x01, 0x3D, 0x01, 0x1C, 0x02, // ĽĜ (U+013D U+011C)
  0x01, 0x3D, 0x01, 0x1E, 0x02, // ĽĞ (U+013D U+011E)
  0x01, 0x3D, 0x01, 0x20, 0x02, // ĽĠ (U+013D U+0120)
  0x01, 0x3D, 0x01, 0x22, 0x02, // ĽĢ (U+013D U+0122)
  0x01, 0x3D, 0x01, 0x4C, 0x02, // ĽŌ (U+013D U+014C)
  0x01, 0x3D, 0x01, 0x4E, 0x02, // ĽŎ (U+013D U+014E)
  0x01, 0x3D, 0x01, 0x50, 0x02, // ĽŐ (U+013D U+0150)
  0x01, 0x3D, 0x01, 0x52, 0x02, // ĽŒ (U+013D U+0152)
  0x01, 0x3D, 0x01, 0x62, 0x02, // ĽŢ (U+013D U+0162)
  0x01, 0x3D, 0x01, 0x64, 0x02, // ĽŤ (U+013D U+0164)
  0x01, 0x3D, 0x01, 0x66, 0x02, // ĽŦ (U+013D U+0166)
  0x01, 0x3D, 0x01, 0x68, 0x01, // ĽŨ (U+013D U+0168)
  0x01, 0x3D, 0x01, 0x6A, 0x01, // ĽŪ (U+013D U+016A)
  0x01, 0x3D, 0x01, 0x6C, 0x01, // ĽŬ (U+013D U+016C)
  0x01, 0x3D, 0x01, 0x6E, 0x01, // ĽŮ (U+013D U+016E)
  0x01, 0x3D, 0x01, 0x70, 0x01, // ĽŰ (U+013D U+0170)
  0x01, 0x3D, 0x01, 0x72, 0x01, // ĽŲ (U+013D U+0172)
  0x01, 0x3D, 0x01, 0x74, 0x02, // ĽŴ (U+013D U+0174)
  0x01, 0x3D, 0x01, 0x76, 0x04, // ĽŶ (U+013D U+0176)
  0x01, 0x3D, 0x01, 0x78, 0x04, // ĽŸ (U+013D U+0178)
  0x01, 0x3D, 0x20, 0x19, 0x0A, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x0A, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x0A, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x0A, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x00, 0x43, 0x02, // ĿC (U+013F U+0043)
  0x01, 0x3F, 0x00, 0x47, 0x02, // ĿG (U+013F U+0047)
  0x01, 0x3F, 0x00, 0x4F, 0x02, // ĿO (U+013F U+004F)
  0x01, 0x3F, 0x00, 0x51, 0x02, // ĿQ (U+013F U+0051)
  0x01, 0x3F, 0x00, 0x54, 0x02, // ĿT (U+013F U+0054)
  0x01, 0x3F, 0x00, 0x55, 0x01, // ĿU (U+013F U+0055)
  0x01, 0x3F, 0x00, 0x56, 0x02, // ĿV (U+013F U+0056)
  0x01, 0x3F, 0x00, 0x57, 0x02, // ĿW (U+013F U+0057)
  0x01, 0x3F, 0x00, 0x59, 0x04, // ĿY (U+013F U+0059)
  0x01, 0x3F, 0x00, 0xC7, 0x02, // ĿÇ (U+013F U+00C7)
  0x01, 0x3F, 0x00, 0xD2, 0x02, // ĿÒ (U+013F U+00D2)
  0x01, 0x3F, 0x00, 0xD3, 0x02, // ĿÓ (U+013F U+00D3)
  0x01, 0x3F, 0x00, 0xD4, 0x02, // ĿÔ (U+013F U+00D4)
  0x01, 0x3F, 0x00, 0xD5, 0x02, // ĿÕ (U+013F U+00D5)
  0x01, 0x3F, 0x00, 0xD6, 0x02, // ĿÖ (U+013F U+00D6)
  0x01, 0x3F, 0x00, 0xD8, 0x02, // ĿØ (U+013F U+00D8)
  0x01, 0x3F, 0x00, 0xD9, 0x01, // ĿÙ (U+013F U+00D9)
  0x01, 0x3F, 0x00, 0xDA, 0x01, // ĿÚ (U+013F U+00DA)
  0x01, 0x3F, 0x00, 0xDB, 0x01, // ĿÛ (U+013F U+00DB)
  0x01, 0x3F, 0x00, 0xDC, 0x01, // ĿÜ (U+013F U+00DC)
  0x01, 0x3F, 0x00, 0xDD, 0x04, // ĿÝ (U+013F U+00DD)
  0x01, 0x3F, 0x01, 0x06, 0x02, // ĿĆ (U+013F U+0106)
  0x01, 0x3F, 0x01, 0x08, 0x02, // ĿĈ (U+013F U+0108)
  0x01, 0x3F, 0x01, 0x0A, 0x02, // ĿĊ (U+013F U+010A)
  0x01, 0x3F, 0x01, 0x0C, 0x02, // ĿČ (U+013F U+010C)
  0x01, 0x3F, 0x01, 0x1C, 0x02, // ĿĜ (U+013F U+011C)
  0x01, 0x3F, 0x01, 0x1E, 0x02, // ĿĞ (U+013F U+011E)
  0x01, 0x3F, 0x01, 0x20, 0x02, // ĿĠ (U+013F U+0120)
  0x01, 0x3F, 0x01, 0x22, 0x02, // ĿĢ (U+013F U+0122)
  0x01, 0x3F, 0x01, 0x4C, 0x02, // ĿŌ (U+013F U+014C)
  0x01, 0x3F, 0x01, 0x4E, 0x02, // ĿŎ (U+013F U+014E)
  0x01, 0x3F, 0x01, 0x50, 0x02, // ĿŐ (U+013F U+0150)
  0x01, 0x3F, 0x01, 0x52, 0x02, // ĿŒ (U+013F U+0152)
  0x01, 0x3F, 0x01, 0x62, 0x02, // ĿŢ (U+013F U+0162)
  0x01, 0x3F, 0x01, 0x64, 0x02, // ĿŤ (U+013F U+0164)
  0x01, 0x3F, 0x01, 0x66, 0x02, // ĿŦ (U+013F U+0166)
  0x01, 0x3F, 0x01, 0x68, 0x01, // ĿŨ (U+013F U+0168)
  0x01, 0x3F, 0x01, 0x6A, 0x01, // ĿŪ (U+013F U+016A)
  0x01, 0x3F, 0x01, 0x6C, 0x01, // ĿŬ (U+013F U+016C)
  0x01, 0x3F, 0x01, 0x6E, 0x01, // ĿŮ (U+013F U+016E)
  0x01, 0x3F, 0x01, 0x70, 0x01, // ĿŰ (U+013F U+0170)
  0x01, 0x3F, 0x01, 0x72, 0x01, // ĿŲ (U+013F U+0172)
  0x01, 0x3F, 0x01, 0x74, 0x02, // ĿŴ (U+013F U+0174)
  0x01, 0x3F, 0x01, 0x76, 0x04, // ĿŶ (U+013F U+0176)
  0x01, 0x3F, 0x01, 0x78, 0x04, // ĿŸ (U+013F U+0178)
  0x01, 0x3F, 0x20, 0x19, 0x0A, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x0A, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x0A, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x0A, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x43, 0x02, // ŁC (U+0141 U+0043)
  0x01, 0x41, 0x00, 0x47, 0x02, // ŁG (U+0141 U+0047)
  0x01, 0x41, 0x00, 0x4F, 0x02, // ŁO (U+0141 U+004F)
  0x01, 0x41, 0x00, 0x51, 0x02, // ŁQ (U+0141 U+0051)
  0x01, 0x41, 0x00, 0x54, 0x02, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x55, 0x01, // ŁU (U+0141 U+0055)
  0x01, 0x41, 0x00, 0x56, 0x02, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x02, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x04, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xC7, 0x02, // ŁÇ (U+0141 U+00C7)
  0x01, 0x41, 0x00, 0xD2, 0x02, // ŁÒ (U+0141 U+00D2)
  0x01, 0x41, 0x00, 0xD3, 0x02, // ŁÓ (U+0141 U+00D3)
  0x01, 0x41, 0x00, 0xD4, 0x02, // ŁÔ (U+0141 U+00D4)
  0x01, 0x41, 0x00, 0xD5, 0x02, // ŁÕ (U+0141 U+00D5)
  0x01, 0x41, 0x00, 0xD6, 0x02, // ŁÖ (U+0141 U+00D6)
  0x01, 0x41, 0x00, 0xD8, 0x02, // ŁØ (U+0141 U+00D8)
  0x01, 0x41, 0x00, 0xD9, 0x01, // ŁÙ (U+0141 U+00D9)
  0x01, 0x41, 0x00, 0xDA, 0x01, // ŁÚ (U+0141 U+00DA)
  0x01, 0x41, 0x00, 0xDB, 0x01, // ŁÛ (U+0141 U+00DB)
  0x01, 0x41, 0x00, 0xDC, 0x01, // ŁÜ (U+0141 U+00DC)
  0x01, 0x41, 0x00, 0xDD, 0x04, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x06, 0x02, // ŁĆ (U+0141 U+0106)
  0x01, 0x41, 0x01, 0x08, 0x02, // ŁĈ (U+0141 U+0108)
  0x01, 0x41, 0x01, 0x0A, 0x02, // ŁĊ (U+0141 U+010A)
  0x01, 0x41, 0x01, 0x0C, 0x02, // ŁČ (U+0141 U+010C)
  0x01, 0x41, 0x01, 0x1C, 0x02, // ŁĜ (U+0141 U+011C)
  0x01, 0x41, 0x01, 0x1E, 0x02, // ŁĞ (U+0141 U+011E)
  0x01, 0x41, 0x01, 0x20, 0x02, // ŁĠ (U+0141 U+0120)
  0x01, 0x41, 0x01, 0x22, 0x02, // ŁĢ (U+0141 U+0122)
  0x01, 0x41, 0x01, 0x4C, 0x02, // ŁŌ (U+0141 U+014C)
  0x01, 0x41, 0x01, 0x4E, 0x02, // ŁŎ (U+0141 U+014E)
  0x01, 0x41, 0x01, 0x50, 0x02, // ŁŐ (U+0141 U+0150)
  0x01, 0x41, 0x01, 0x52, 0x02, // ŁŒ (U+0141 U+0152)
  0x01, 0x41, 0x01, 0x62, 0x02, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x02, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x02, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x01, 0x68, 0x01, // ŁŨ (U+0141 U+0168)
  0x01, 0x41, 0x01, 0x6A, 0x01, // ŁŪ (U+0141 U+016A)
  0x01, 0x41, 0x01, 0x6C, 0x01, // ŁŬ (U+0141 U+016C)
  0x01, 0x41, 0x01, 0x6E, 0x01, // ŁŮ (U+0141 U+016E)
  0x01, 0x41, 0x01, 0x70, 0x01, // ŁŰ (U+0141 U+0170)
  0x01, 0x41, 0x01, 0x72, 0x01, // ŁŲ (U+0141 U+0172)
  0x01, 0x41, 0x01, 0x74, 0x02, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x04, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x04, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x19, 0x0A, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x0A, // Ł” (U+0141 U+201D)
  0x01, 0x44, 0x00, 0x22, 0x01, // ń" (U+0144 U+0022)
  0x01, 0x44, 0x00, 0x27, 0x01, // ń' (U+0144 U+0027)
  0x01, 0x44, 0x20, 0x19, 0x01, // ń’ (U+0144 U+2019)
  0x01, 0x44, 0x20, 0x1D, 0x01, // ń” (U+0144 U+201D)
  0x01, 0x46, 0x00, 0x22, 0x01, // ņ" (U+0146 U+0022)
  0x01, 0x46, 0x00, 0x27, 0x01, // ņ' (U+0146 U+0027)
  0x01, 0x46, 0x20, 0x19, 0x01, // ņ’ (U+0146 U+2019)
  0x01, 0x46, 0x20, 0x1D, 0x01, // ņ” (U+0146 U+201D)
  0x01, 0x49, 0x00, 0x22, 0x01, // ŉ" (U+0149 U+0022)
  0x01, 0x49, 0x00, 0x27, 0x01, // ŉ' (U+0149 U+0027)
  0x01, 0x49, 0x20, 0x19, 0x01, // ŉ’ (U+0149 U+2019)
  0x01, 0x49, 0x20, 0x1D, 0x01, // ŉ” (U+0149 U+201D)
  0x01, 0x4B, 0x00, 0x22, 0x01, // ŋ" (U+014B U+0022)
  0x01, 0x4B, 0x00, 0x27, 0x01, // ŋ' (U+014B U+0027)
  0x01, 0x4B, 0x20, 0x19, 0x01, // ŋ’ (U+014B U+2019)
  0x01, 0x4B, 0x20, 0x1D, 0x01, // ŋ” (U+014B U+201D)
  0x01, 0x4C, 0x00, 0x2C, 0x05, // Ō, (U+014C U+002C)
  0x01, 0x4C, 0x00, 0x2E, 0x05, // Ō. (U+014C U+002E)
  0x01, 0x4C, 0x00, 0x41, 0x02, // ŌA (U+014C U+0041)
  0x01, 0x4C, 0x00, 0x54, 0x04, // ŌT (U+014C U+0054)
  0x01, 0x4C, 0x00, 0x56, 0x01, // ŌV (U+014C U+0056)
  0x01, 0x4C, 0x00, 0x57, 0x01, // ŌW (U+014C U+0057)
  0x01, 0x4C, 0x00, 0x58, 0x02, // ŌX (U+014C U+0058)
  0x01, 0x4C, 0x00, 0x59, 0x01, // ŌY (U+014C U+0059)
  0x01, 0x4C, 0x00, 0x5A, 0x01, // ŌZ (U+014C U+005A)
  0x01, 0x4C, 0x00, 0xC0, 0x02, // ŌÀ (U+014C U+00C0)
  0x01, 0x4C, 0x00, 0xC1, 0x02, // ŌÁ (U+014C U+00C1)
  0x01, 0x4C, 0x00, 0xC2, 0x02, // ŌÂ (U+014C U+00C2)
  0x01, 0x4C, 0x00, 0xC3, 0x02, // ŌÃ (U+014C U+00C3)
  0x01, 0x4C, 0x00, 0xC4, 0x02, // ŌÄ (U+014C U+00C4)
  0x01, 0x4C, 0x00, 0xC5, 0x02, // ŌÅ (U+014C U+00C5)
  0x01, 0x4C, 0x00, 0xDD, 0x01, // ŌÝ (U+014C U+00DD)
  0x01, 0x4C, 0x01, 0x00, 0x02, // ŌĀ (U+014C U+0100)
  0x01, 0x4C, 0x01, 0x02, 0x02, // ŌĂ (U+014C U+0102)
  0x01, 0x4C, 0x01, 0x04, 0x02, // ŌĄ (U+014C U+0104)
  0x01, 0x4C, 0x01, 0x62, 0x04, // ŌŢ (U+014C U+0162)
  0x01, 0x4C, 0x01, 0x64, 0x04, // ŌŤ (U+014C U+0164)
  0x01, 0x4C, 0x01, 0x66, 0x04, // ŌŦ (U+014C U+0166)
  0x01, 0x4C, 0x01, 0x74, 0x01, // ŌŴ (U+014C U+0174)
  0x01, 0x4C, 0x01, 0x76, 0x01, // ŌŶ (U+014C U+0176)
  0x01, 0x4C, 0x01, 0x78, 0x01, // ŌŸ (U+014C U+0178)
  0x01, 0x4C, 0x01, 0x79, 0x01, // ŌŹ (U+014C U+0179)
  0x01, 0x4C, 0x01, 0x7B, 0x01, // ŌŻ (U+014C U+017B)
  0x01, 0x4C, 0x01, 0x7D, 0x01, // ŌŽ (U+014C U+017D)
  0x01, 0x4C, 0x20, 0x1A, 0x05, // Ō‚ (U+014C U+201A)
  0x01, 0x4C, 0x20, 0x1E, 0x05, // Ō„ (U+014C U+201E)
  0x01, 0x4C, 0x20, 0x26, 0x05, // Ō… (U+014C U+2026)
  0x01, 0x4D, 0x00, 0x22, 0x01, // ō" (U+014D U+0022)
  0x01, 0x4D, 0x00, 0x27, 0x01, // ō' (U+014D U+0027)
  0x01, 0x4D, 0x00, 0x76, 0x02, // ōv (U+014D U+0076)
  0x01, 0x4D, 0x00, 0x77, 0x02, // ōw (U+014D U+0077)
  0x01, 0x4D, 0x00, 0x78, 0x02, // ōx (U+014D U+0078)
  0x01, 0x4D, 0x00, 0x79, 0x02, // ōy (U+014D U+0079)
  0x01, 0x4D, 0x00, 0x7A, 0x01, // ōz (U+014D U+007A)
  0x01, 0x4D, 0x00, 0xFD, 0x02, // ōý (U+014D U+00FD)
  0x01, 0x4D, 0x00, 0xFF, 0x02, // ōÿ (U+014D U+00FF)
  0x01, 0x4D, 0x01, 0x75, 0x02, // ōŵ (U+014D U+0175)
  0x01, 0x4D, 0x01, 0x77, 0x02, // ōŷ (U+014D U+0177)
  0x01, 0x4D, 0x01, 0x7A, 0x01, // ōź (U+014D U+017A)
  0x01, 0x4D, 0x01, 0x7C, 0x01, // ōż (U+014D U+017C)
  0x01, 0x4D, 0x01, 0x7E, 0x01, // ōž (U+014D U+017E)
  0x01, 0x4D, 0x20, 0x19, 0x01, // ō’ (U+014D U+2019)
  0x01, 0x4D, 0x20, 0x1D, 0x01, // ō” (U+014D U+201D)
  0x01, 0x4E, 0x00, 0x2C, 0x05, // Ŏ, (U+014E U+002C)
  0x01, 0x4E, 0x00, 0x2E, 0x05, // Ŏ. (U+014E U+002E)
  0x01, 0x4E, 0x00, 0x41, 0x02, // ŎA (U+014E U+0041)
  0x01, 0x4E, 0x00, 0x54, 0x04, // ŎT (U+014E U+0054)
  0x01, 0x4E, 0x00, 0x56, 0x01, // ŎV (U+014E U+0056)
  0x01, 0x4E, 0x00, 0x57, 0x01, // ŎW (U+014E U+0057)
  0x01, 0x4E, 0x00, 0x58, 0x02, // ŎX (U+014E U+0058)
  0x01, 0x4E, 0x00, 0x59, 0x01, // ŎY (U+014E U+0059)
  0x01, 0x4E, 0x00, 0x5A, 0x01, // ŎZ (U+014E U+005A)
  0x01, 0x4E, 0x00, 0xC0, 0x02, // ŎÀ (U+014E U+00C0)
  0x01, 0x4E, 0x00, 0xC1, 0x02, // ŎÁ (U+014E U+00C1)
  0x01, 0x4E, 0x00, 0xC2, 0x02, // ŎÂ (U+014E U+00C2)
  0x01, 0x4E, 0x00, 0xC3, 0x02, // ŎÃ (U+014E U+00C3)
  0x01, 0x4E, 0x00, 0xC4, 0x02, // ŎÄ (U+014E U+00C4)
  0x01, 0x4E, 0x00, 0xC5, 0x02, // ŎÅ (U+014E U+00C5)
  0x01, 0x4E, 0x00, 0xDD, 0x01, // ŎÝ (U+014E U+00DD)
  0x01, 0x4E, 0x01, 0x00, 0x02, // ŎĀ (U+014E U+0100)
  0x01, 0x4E, 0x01, 0x02, 0x02, // ŎĂ (U+014E U+0102)
  0x01, 0x4E, 0x01, 0x04, 0x02, // ŎĄ (U+014E U+0104)
  0x01, 0x4E, 0x01, 0x62, 0x04, // ŎŢ (U+014E U+0162)
  0x01, 0x4E, 0x01, 0x64, 0x04, // ŎŤ (U+014E U+0164)
  0x01, 0x4E, 0x01, 0x66, 0x04, // ŎŦ (U+014E U+0166)
  0x01, 0x4E, 0x01, 0x74, 0x01, // ŎŴ (U+014E U+0174)
  0x01, 0x4E, 0x01, 0x76, 0x01, // ŎŶ (U+014E U+0176)
  0x01, 0x4E, 0x01, 0x78, 0x01, // ŎŸ (U+014E U+0178)
  0x01, 0x4E, 0x01, 0x79, 0x01, // ŎŹ (U+014E U+0179)
  0x01, 0x4E, 0x01, 0x7B, 0x01, // ŎŻ (U+014E U+017B)
  0x01, 0x4E, 0x01, 0x7D, 0x01, // ŎŽ (U+014E U+017D)
  0x01, 0x4E, 0x20, 0x1A, 0x05, // Ŏ‚ (U+014E U+201A)
  0x01, 0x4E, 0x20, 0x1E, 0x05, // Ŏ„ (U+014E U+201E)
  0x01, 0x4E, 0x20, 0x26, 0x05, // Ŏ… (U+014E U+2026)
  0x01, 0x4F, 0x00, 0x22, 0x01, // ŏ" (U+014F U+0022)
  0x01, 0x4F, 0x00, 0x27, 0x01, // ŏ' (U+014F U+0027)
  0x01, 0x4F, 0x00, 0x76, 0x02, // ŏv (U+014F U+0076)
  0x01, 0x4F, 0x00, 0x77, 0x02, // ŏw (U+014F U+0077)
  0x01, 0x4F, 0x00, 0x78, 0x02, // ŏx (U+014F U+0078)
  0x01, 0x4F, 0x00, 0x79, 0x02, // ŏy (U+014F U+0079)
  0x01, 0x4F, 0x00, 0x7A, 0x01, // ŏz (U+014F U+007A)
  0x01, 0x4F, 0x00, 0xFD, 0x02, // ŏý (U+014F U+00FD)
  0x01, 0x4F, 0x00, 0xFF, 0x02, // ŏÿ (U+014F U+00FF)
  0x01, 0x4F, 0x01, 0x75, 0x02, // ŏŵ (U+014F U+0175)
  0x01, 0x4F, 0x01, 0x77, 0x02, // ŏŷ (U+014F U+0177)
  0x01, 0x4F, 0x01, 0x7A, 0x01, // ŏź (U+014F U+017A)
  0x01, 0x4F, 0x01, 0x7C, 0x01, // ŏż (U+014F U+017C)
  0x01, 0x4F, 0x01, 0x7E, 0x01, // ŏž (U+014F U+017E)
  0x01, 0x4F, 0x20, 0x19, 0x01, // ŏ’ (U+014F U+2019)
  0x01, 0x4F, 0x20, 0x1D, 0x01, // ŏ” (U+014F U+201D)
  0x01, 0x50, 0x00, 0x2C, 0x05, // Ő, (U+0150 U+002C)
  0x01, 0x50, 0x00, 0x2E, 0x05, // Ő. (U+0150 U+002E)
  0x01, 0x50, 0x00, 0x41, 0x02, // ŐA (U+0150 U+0041)
  0x01, 0x50, 0x00, 0x54, 0x04, // ŐT (U+0150 U+0054)
  0x01, 0x50, 0x00, 0x56, 0x01, // ŐV (U+0150 U+0056)
  0x01, 0x50, 0x00, 0x57, 0x01, // ŐW (U+0150 U+0057)
  0x01, 0x50, 0x00, 0x58, 0x02, // ŐX (U+0150 U+0058)
  0x01, 0x50, 0x00, 0x59, 0x01, // ŐY (U+0150 U+0059)
  0x01, 0x50, 0x00, 0x5A, 0x01, // ŐZ (U+0150 U+005A)
  0x01, 0x50, 0x00, 0xC0, 0x02, // ŐÀ (U+0150 U+00C0)
  0x01, 0x50, 0x00, 0xC1, 0x02, // ŐÁ (U+0150 U+00C1)
  0x01, 0x50, 0x00, 0xC2, 0x02, // ŐÂ (U+0150 U+00C2)
  0x01, 0x50, 0x00, 0xC3, 0x02, // ŐÃ (U+0150 U+00C3)
  0x01, 0x50, 0x00, 0xC4, 0x02, // ŐÄ (U+0150 U+00C4)
  0x01, 0x50, 0x00, 0xC5, 0x02, // ŐÅ (U+0150 U+00C5)
  0x01, 0x50, 0x00, 0xDD, 0x01, // ŐÝ (U+0150 U+00DD)
  0x01, 0x50, 0x01, 0x00, 0x02, // ŐĀ (U+0150 U+0100)
  0x01, 0x50, 0x01, 0x02, 0x02, // ŐĂ (U+0150 U+0102)
  0x01, 0x50, 0x01, 0x04, 0x02, // ŐĄ (U+0150 U+0104)
  0x01, 0x50, 0x01, 0x62, 0x04, // ŐŢ (U+0150 U+0162)
  0x01, 0x50, 0x01, 0x64, 0x04, // ŐŤ (U+0150 U+0164)
  0x01, 0x50, 0x01, 0x66, 0x04, // ŐŦ (U+0150 U+0166)
  0x01, 0x50, 0x01, 0x74, 0x01, // ŐŴ (U+0150 U+0174)
  0x01, 0x50, 0x01, 0x76, 0x01, // ŐŶ (U+0150 U+0176)
  0x01, 0x50, 0x01, 0x78, 0x01, // ŐŸ (U+0150 U+0178)
  0x01, 0x50, 0x01, 0x79, 0x01, // ŐŹ (U+0150 U+0179)
  0x01, 0x50, 0x01, 0x7B, 0x01, // ŐŻ (U+0150 U+017B)
  0x01, 0x50, 0x01, 0x7D, 0x01, // ŐŽ (U+0150 U+017D)
  0x01, 0x50, 0x20, 0x1A, 0x05, // Ő‚ (U+0150 U+201A)
  0x01, 0x50, 0x20, 0x1E, 0x05, // Ő„ (U+0150 U+201E)
  0x01, 0x50, 0x20, 0x26, 0x05, // Ő… (U+0150 U+2026)
  0x01, 0x51, 0x00, 0x22, 0x01, // ő" (U+0151 U+0022)
  0x01, 0x51, 0x00, 0x27, 0x01, // ő' (U+0151 U+0027)
  0x01, 0x51, 0x00, 0x76, 0x02, // őv (U+0151 U+0076)
  0x01, 0x51, 0x00, 0x77, 0x02, // őw (U+0151 U+0077)
  0x01, 0x51, 0x00, 0x78, 0x02, // őx (U+0151 U+0078)
  0x01, 0x51, 0x00, 0x79, 0x02, // őy (U+0151 U+0079)
  0x01, 0x51, 0x00, 0x7A, 0x01, // őz (U+0151 U+007A)
  0x01, 0x51, 0x00, 0xFD, 0x02, // őý (U+0151 U+00FD)
  0x01, 0x51, 0x00, 0xFF, 0x02, // őÿ (U+0151 U+00FF)
  0x01, 0x51, 0x01, 0x75, 0x02, // őŵ (U+0151 U+0175)
  0x01, 0x51, 0x01, 0x77, 0x02, // őŷ (U+0151 U+0177)
  0x01, 0x51, 0x01, 0x7A, 0x01, // őź (U+0151 U+017A)
  0x01, 0x51, 0x01, 0x7C, 0x01, // őż (U+0151 U+017C)
  0x01, 0x51, 0x01, 0x7E, 0x01, // őž (U+0151 U+017E)
  0x01, 0x51, 0x20, 0x19, 0x01, // ő’ (U+0151 U+2019)
  0x01, 0x51, 0x20, 0x1D, 0x01, // ő” (U+0151 U+201D)
  0x01, 0x53, 0x00, 0x22, 0x01, // œ" (U+0153 U+0022)
  0x01, 0x53, 0x00, 0x27, 0x01, // œ' (U+0153 U+0027)
  0x01, 0x53, 0x00, 0x76, 0x02, // œv (U+0153 U+0076)
  0x01, 0x53, 0x00, 0x77, 0x02, // œw (U+0153 U+0077)
  0x01, 0x53, 0x00, 0x78, 0x02, // œx (U+0153 U+0078)
  0x01, 0x53, 0x00, 0x79, 0x02, // œy (U+0153 U+0079)
  0x01, 0x53, 0x00, 0x7A, 0x01, // œz (U+0153 U+007A)
  0x01, 0x53, 0x00, 0xFD, 0x02, // œý (U+0153 U+00FD)
  0x01, 0x53, 0x00, 0xFF, 0x02, // œÿ (U+0153 U+00FF)
  0x01, 0x53, 0x01, 0x75, 0x02, // œŵ (U+0153 U+0175)
  0x01, 0x53, 0x01, 0x77, 0x02, // œŷ (U+0153 U+0177)
  0x01, 0x53, 0x01, 0x7A, 0x01, // œź (U+0153 U+017A)
  0x01, 0x53, 0x01, 0x7C, 0x01, // œż (U+0153 U+017C)
  0x01, 0x53, 0x01, 0x7E, 0x01, // œž (U+0153 U+017E)
  0x01, 0x53, 0x20, 0x19, 0x01, // œ’ (U+0153 U+2019)
  0x01, 0x53, 0x20, 0x1D, 0x01, // œ” (U+0153 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x07, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x07, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x00, 0x61, 0x02, // ŕa (U+0155 U+0061)
  0x01, 0x55, 0x00, 0x63, 0x02, // ŕc (U+0155 U+0063)
  0x01, 0x55, 0x00, 0x64, 0x02, // ŕd (U+0155 U+0064)
  0x01, 0x55, 0x00, 0x65, 0x02, // ŕe (U+0155 U+0065)
  0x01, 0x55, 0x00, 0x67, 0x01, // ŕg (U+0155 U+0067)
  0x01, 0x55, 0x00, 0x6F, 0x02, // ŕo (U+0155 U+006F)
  0x01, 0x55, 0x00, 0x71, 0x02, // ŕq (U+0155 U+0071)
  0x01, 0x55, 0x00, 0xE0, 0x02, // ŕà (U+0155 U+00E0)
  0x01, 0x55, 0x00, 0xE1, 0x02, // ŕá (U+0155 U+00E1)
  0x01, 0x55, 0x00, 0xE2, 0x02, // ŕâ (U+0155 U+00E2)
  0x01, 0x55, 0x00, 0xE3, 0x02, // ŕã (U+0155 U+00E3)
  0x01, 0x55, 0x00, 0xE4, 0x02, // ŕä (U+0155 U+00E4)
  0x01, 0x55, 0x00, 0xE5, 0x02, // ŕå (U+0155 U+00E5)
  0x01, 0x55, 0x00, 0xE6, 0x02, // ŕæ (U+0155 U+00E6)
  0x01, 0x55, 0x00, 0xE7, 0x02, // ŕç (U+0155 U+00E7)
  0x01, 0x55, 0x00, 0xE8, 0x02, // ŕè (U+0155 U+00E8)
  0x01, 0x55, 0x00, 0xE9, 0x02, // ŕé (U+0155 U+00E9)
  0x01, 0x55, 0x00, 0xEA, 0x02, // ŕê (U+0155 U+00EA)
  0x01, 0x55, 0x00, 0xEB, 0x02, // ŕë (U+0155 U+00EB)
  0x01, 0x55, 0x00, 0xF2, 0x02, // ŕò (U+0155 U+00F2)
  0x01, 0x55, 0x00, 0xF3, 0x02, // ŕó (U+0155 U+00F3)
  0x01, 0x55, 0x00, 0xF4, 0x02, // ŕô (U+0155 U+00F4)
  0x01, 0x55, 0x00, 0xF5, 0x02, // ŕõ (U+0155 U+00F5)
  0x01, 0x55, 0x00, 0xF6, 0x02, // ŕö (U+0155 U+00F6)
  0x01, 0x55, 0x00, 0xF8, 0x02, // ŕø (U+0155 U+00F8)
  0x01, 0x55, 0x01, 0x01, 0x02, // ŕā (U+0155 U+0101)
  0x01, 0x55, 0x01, 0x03, 0x02, // ŕă (U+0155 U+0103)
  0x01, 0x55, 0x01, 0x05, 0x02, // ŕą (U+0155 U+0105)
  0x01, 0x55, 0x01, 0x07, 0x02, // ŕć (U+0155 U+0107)
  0x01, 0x55, 0x01, 0x09, 0x02, // ŕĉ (U+0155 U+0109)
  0x01, 0x55, 0x01, 0x0B, 0x02, // ŕċ (U+0155 U+010B)
  0x01, 0x55, 0x01, 0x0D, 0x02, // ŕč (U+0155 U+010D)
  0x01, 0x55, 0x01, 0x0F, 0x02, // ŕď (U+0155 U+010F)
  0x01, 0x55, 0x01, 0x11, 0x02, // ŕđ (U+0155 U+0111)
  0x01, 0x55, 0x01, 0x13, 0x02, // ŕē (U+0155 U+0113)
  0x01, 0x55, 0x01, 0x15, 0x02, // ŕĕ (U+0155 U+0115)
  0x01, 0x55, 0x01, 0x17, 0x02, // ŕė (U+0155 U+0117)
  0x01, 0x55, 0x01, 0x19, 0x02, // ŕę (U+0155 U+0119)
  0x01, 0x55, 0x01, 0x1B, 0x02, // ŕě (U+0155 U+011B)
  0x01, 0x55, 0x01, 0x1D, 0x01, // ŕĝ (U+0155 U+011D)
  0x01, 0x55, 0x01, 0x1F, 0x01, // ŕğ (U+0155 U+011F)
  0x01, 0x55, 0x01, 0x21, 0x01, // ŕġ (U+0155 U+0121)
  0x01, 0x55, 0x01, 0x23, 0x01, // ŕģ (U+0155 U+0123)
  0x01, 0x55, 0x01, 0x4D, 0x02, // ŕō (U+0155 U+014D)
  0x01, 0x55, 0x01, 0x4F, 0x02, // ŕŏ (U+0155 U+014F)
  0x01, 0x55, 0x01, 0x51, 0x02, // ŕő (U+0155 U+0151)
  0x01, 0x55, 0x01, 0x53, 0x02, // ŕœ (U+0155 U+0153)
  0x01, 0x55, 0x20, 0x1A, 0x07, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x07, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x07, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x07, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x07, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x00, 0x61, 0x02, // ŗa (U+0157 U+0061)
  0x01, 0x57, 0x00, 0x63, 0x02, // ŗc (U+0157 U+0063)
  0x01, 0x57, 0x00, 0x64, 0x02, // ŗd (U+0157 U+0064)
  0x01, 0x57, 0x00, 0x65, 0x02, // ŗe (U+0157 U+0065)
  0x01, 0x57, 0x00, 0x67, 0x01, // ŗg (U+0157 U+0067)
  0x01, 0x57, 0x00, 0x6F, 0x02, // ŗo (U+0157 U+006F)
  0x01, 0x57, 0x00, 0x71, 0x02, // ŗq (U+0157 U+0071)
  0x01, 0x57, 0x00, 0xE0, 0x02, // ŗà (U+0157 U+00E0)
  0x01, 0x57, 0x00, 0xE1, 0x02, // ŗá (U+0157 U+00E1)
  0x01, 0x57, 0x00, 0xE2, 0x02, // ŗâ (U+0157 U+00E2)
  0x01, 0x57, 0x00, 0xE3, 0x02, // ŗã (U+0157 U+00E3)
  0x01, 0x57, 0x00, 0xE4, 0x02, // ŗä (U+0157 U+00E4)
  0x01, 0x57, 0x00, 0xE5, 0x02, // ŗå (U+0157 U+00E5)
  0x01, 0x57, 0x00, 0xE6, 0x02, // ŗæ (U+0157 U+00E6)
  0x01, 0x57, 0x00, 0xE7, 0x02, // ŗç (U+0157 U+00E7)
  0x01, 0x57, 0x00, 0xE8, 0x02, // ŗè (U+0157 U+00E8)
  0x01, 0x57, 0x00, 0xE9, 0x02, // ŗé (U+0157 U+00E9)
  0x01, 0x57, 0x00, 0xEA, 0x02, // ŗê (U+0157 U+00EA)
  0x01, 0x57, 0x00, 0xEB, 0x02, // ŗë (U+0157 U+00EB)
  0x01, 0x57, 0x00, 0xF2, 0x02, // ŗò (U+0157 U+00F2)
  0x01, 0x57, 0x00, 0xF3, 0x02, // ŗó (U+0157 U+00F3)
  0x01, 0x57, 0x00, 0xF4, 0x02, // ŗô (U+0157 U+00F4)
  0x01, 0x57, 0x00, 0xF5, 0x02, // ŗõ (U+0157 U+00F5)
  0x01, 0x57, 0x00, 0xF6, 0x02, // ŗö (U+0157 U+00F6)
  0x01, 0x57, 0x00, 0xF8, 0x02, // ŗø (U+0157 U+00F8)
  0x01, 0x57, 0x01, 0x01, 0x02, // ŗā (U+0157 U+0101)
  0x01, 0x57, 0x01, 0x03, 0x02, // ŗă (U+0157 U+0103)
  0x01, 0x57, 0x01, 0x05, 0x02, // ŗą (U+0157 U+0105)
  0x01, 0x57, 0x01, 0x07, 0x02, // ŗć (U+0157 U+0107)
  0x01, 0x57, 0x01, 0x09, 0x02, // ŗĉ (U+0157 U+0109)
  0x01, 0x57, 0x01, 0x0B, 0x02, // ŗċ (U+0157 U+010B)
  0x01, 0x57, 0x01, 0x0D, 0x02, // ŗč (U+0157 U+010D)
  0x01, 0x57, 0x01, 0x0F, 0x02, // ŗď (U+0157 U+010F)
  0x01, 0x57, 0x01, 0x11, 0x02, // ŗđ (U+0157 U+0111)
  0x01, 0x57, 0x01, 0x13, 0x02, // ŗē (U+0157 U+0113)
  0x01, 0x57, 0x01, 0x15, 0x02, // ŗĕ (U+0157 U+0115)
  0x01, 0x57, 0x01, 0x17, 0x02, // ŗė (U+0157 U+0117)
  0x01, 0x57, 0x01, 0x19, 0x02, // ŗę (U+0157 U+0119)
  0x01, 0x57, 0x01, 0x1B, 0x02, // ŗě (U+0157 U+011B)
  0x01, 0x57, 0x01, 0x1D, 0x01, // ŗĝ (U+0157 U+011D)
  0x01, 0x57, 0x01, 0x1F, 0x01, // ŗğ (U+0157 U+011F)
  0x01, 0x57, 0x01, 0x21, 0x01, // ŗġ (U+0157 U+0121)
  0x01, 0x57, 0x01, 0x23, 0x01, // ŗģ (U+0157 U+0123)
  0x01, 0x57, 0x01, 0x4D, 0x02, // ŗō (U+0157 U+014D)
  0x01, 0x57, 0x01, 0x4F, 0x02, // ŗŏ (U+0157 U+014F)
  0x01, 0x57, 0x01, 0x51, 0x02, // ŗő (U+0157 U+0151)
  0x01, 0x57, 0x01, 0x53, 0x02, // ŗœ (U+0157 U+0153)
  0x01, 0x57, 0x20, 0x1A, 0x07, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x07, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x07, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x07, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x07, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x00, 0x61, 0x02, // řa (U+0159 U+0061)
  0x01, 0x59, 0x00, 0x63, 0x02, // řc (U+0159 U+0063)
  0x01, 0x59, 0x00, 0x64, 0x02, // řd (U+0159 U+0064)
  0x01, 0x59, 0x00, 0x65, 0x02, // ře (U+0159 U+0065)
  0x01, 0x59, 0x00, 0x67, 0x01, // řg (U+0159 U+0067)
  0x01, 0x59, 0x00, 0x6F, 0x02, // řo (U+0159 U+006F)
  0x01, 0x59, 0x00, 0x71, 0x02, // řq (U+0159 U+0071)
  0x01, 0x59, 0x00, 0xE0, 0x02, // řà (U+0159 U+00E0)
  0x01, 0x59, 0x00, 0xE1, 0x02, // řá (U+0159 U+00E1)
  0x01, 0x59, 0x00, 0xE2, 0x02, // řâ (U+0159 U+00E2)
  0x01, 0x59, 0x00, 0xE3, 0x02, // řã (U+0159 U+00E3)
  0x01, 0x59, 0x00, 0xE4, 0x02, // řä (U+0159 U+00E4)
  0x01, 0x59, 0x00, 0xE5, 0x02, // řå (U+0159 U+00E5)
  0x01, 0x59, 0x00, 0xE6, 0x02, // řæ (U+0159 U+00E6)
  0x01, 0x59, 0x00, 0xE7, 0x02, // řç (U+0159 U+00E7)
  0x01, 0x59, 0x00, 0xE8, 0x02, // řè (U+0159 U+00E8)
  0x01, 0x59, 0x00, 0xE9, 0x02, // řé (U+0159 U+00E9)
  0x01, 0x59, 0x00, 0xEA, 0x02, // řê (U+0159 U+00EA)
  0x01, 0x59, 0x00, 0xEB, 0x02, // řë (U+0159 U+00EB)
  0x01, 0x59, 0x00, 0xF2, 0x02, // řò (U+0159 U+00F2)
  0x01, 0x59, 0x00, 0xF3, 0x02, // řó (U+0159 U+00F3)
  0x01, 0x59, 0x00, 0xF4, 0x02, // řô (U+0159 U+00F4)
  0x01, 0x59, 0x00, 0xF5, 0x02, // řõ (U+0159 U+00F5)
  0x01, 0x59, 0x00, 0xF6, 0x02, // řö (U+0159 U+00F6)
  0x01, 0x59, 0x00, 0xF8, 0x02, // řø (U+0159 U+00F8)
  0x01, 0x59, 0x01, 0x01, 0x02, // řā (U+0159 U+0101)
  0x01, 0x59, 0x01, 0x03, 0x02, // řă (U+0159 U+0103)
  0x01, 0x59, 0x01, 0x05, 0x02, // řą (U+0159 U+0105)
  0x01, 0x59, 0x01, 0x07, 0x02, // řć (U+0159 U+0107)
  0x01, 0x59, 0x01, 0x09, 0x02, // řĉ (U+0159 U+0109)
  0x01, 0x59, 0x01, 0x0B, 0x02, // řċ (U+0159 U+010B)
  0x01, 0x59, 0x01, 0x0D, 0x02, // řč (U+0159 U+010D)
  0x01, 0x59, 0x01, 0x0F, 0x02, // řď (U+0159 U+010F)
  0x01, 0x59, 0x01, 0x11, 0x02, // řđ (U+0159 U+0111)
  0x01, 0x59, 0x01, 0x13, 0x02, // řē (U+0159 U+0113)
  0x01, 0x59, 0x01, 0x15, 0x02, // řĕ (U+0159 U+0115)
  0x01, 0x59, 0x01, 0x17, 0x02, // řė (U+0159 U+0117)
  0x01, 0x59, 0x01, 0x19, 0x02, // řę (U+0159 U+0119)
  0x01, 0x59, 0x01, 0x1B, 0x02, // řě (U+0159 U+011B)
  0x01, 0x59, 0x01, 0x1D, 0x01, // řĝ (U+0159 U+011D)
  0x01, 0x59, 0x01, 0x1F, 0x01, // řğ (U+0159 U+011F)
  0x01, 0x59, 0x01, 0x21, 0x01, // řġ (U+0159 U+0121)
  0x01, 0x59, 0x01, 0x23, 0x01, // řģ (U+0159 U+0123)
  0x01, 0x59, 0x01, 0x4D, 0x02, // řō (U+0159 U+014D)
  0x01, 0x59, 0x01, 0x4F, 0x02, // řŏ (U+0159 U+014F)
  0x01, 0x59, 0x01, 0x51, 0x02, // řő (U+0159 U+0151)
  0x01, 0x59, 0x01, 0x53, 0x02, // řœ (U+0159 U+0153)
  0x01, 0x59, 0x20, 0x1A, 0x07, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x07, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x07, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x26, 0x02, // Ţ& (U+0162 U+0026)
  0x01, 0x62, 0x00, 0x2C, 0x07, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2D, 0x05, // Ţ- (U+0162 U+002D)
  0x01, 0x62, 0x00, 0x2E, 0x07, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x08, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x43, 0x02, // ŢC (U+0162 U+0043)
  0x01, 0x62, 0x00, 0x47, 0x02, // ŢG (U+0162 U+0047)
  0x01, 0x62, 0x00, 0x4F, 0x02, // ŢO (U+0162 U+004F)
  0x01, 0x62, 0x00, 0x51, 0x02, // ŢQ (U+0162 U+0051)
  0x01, 0x62, 0x00, 0x61, 0x0A, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x08, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x08, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x08, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x08, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x06, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x06, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x08, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x06, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x08, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x06, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x07, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x06, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0x76, 0x02, // Ţv (U+0162 U+0076)
  0x01, 0x62, 0x00, 0x77, 0x02, // Ţw (U+0162 U+0077)
  0x01, 0x62, 0x00, 0x78, 0x02, // Ţx (U+0162 U+0078)
  0x01, 0x62, 0x00, 0x79, 0x02, // Ţy (U+0162 U+0079)
  0x01, 0x62, 0x00, 0x7A, 0x05, // Ţz (U+0162 U+007A)
  0x01, 0x62, 0x00, 0xAB, 0x07, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xBB, 0x04, // Ţ» (U+0162 U+00BB)
  0x01, 0x62, 0x00, 0xC0, 0x08, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x08, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x08, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x08, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x08, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x08, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xC7, 0x02, // ŢÇ (U+0162 U+00C7)
  0x01, 0x62, 0x00, 0xD2, 0x02, // ŢÒ (U+0162 U+00D2)
  0x01, 0x62, 0x00, 0xD3, 0x02, // ŢÓ (U+0162 U+00D3)
  0x01, 0x62, 0x00, 0xD4, 0x02, // ŢÔ (U+0162 U+00D4)
  0x01, 0x62, 0x00, 0xD5, 0x02, // ŢÕ (U+0162 U+00D5)
  0x01, 0x62, 0x00, 0xD6, 0x02, // ŢÖ (U+0162 U+00D6)
  0x01, 0x62, 0x00, 0xD8, 0x02, // ŢØ (U+0162 U+00D8)
  0x01, 0x62, 0x00, 0xE0, 0x08, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x0A, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x0A, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x0A, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x0A, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x0A, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x0A, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x08, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x08, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x08, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x08, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x08, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x08, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x08, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x08, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x08, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x08, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x08, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x06, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x06, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x06, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x06, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x00, 0xFD, 0x02, // Ţý (U+0162 U+00FD)
  0x01, 0x62, 0x00, 0xFF, 0x02, // Ţÿ (U+0162 U+00FF)
  0x01, 0x62, 0x01, 0x00, 0x08, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x0A, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x08, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x0A, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x08, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x0A, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x06, 0x02, // ŢĆ (U+0162 U+0106)
  0x01, 0x62, 0x01, 0x07, 0x08, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x08, 0x02, // ŢĈ (U+0162 U+0108)
  0x01, 0x62, 0x01, 0x09, 0x08, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0A, 0x02, // ŢĊ (U+0162 U+010A)
  0x01, 0x62, 0x01, 0x0B, 0x08, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0C, 0x02, // ŢČ (U+0162 U+010C)
  0x01, 0x62, 0x01, 0x0D, 0x08, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x08, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x08, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x08, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x08, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x08, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x08, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x08, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1C, 0x02, // ŢĜ (U+0162 U+011C)
  0x01, 0x62, 0x01, 0x1D, 0x08, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1E, 0x02, // ŢĞ (U+0162 U+011E)
  0x01, 0x62, 0x01, 0x1F, 0x08, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x20, 0x02, // ŢĠ (U+0162 U+0120)
  0x01, 0x62, 0x01, 0x21, 0x08, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x22, 0x02, // ŢĢ (U+0162 U+0122)
  0x01, 0x62, 0x01, 0x23, 0x08, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x06, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x06, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x06, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x4B, 0x06, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4C, 0x02, // ŢŌ (U+0162 U+014C)
  0x01, 0x62, 0x01, 0x4D, 0x08, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4E, 0x02, // ŢŎ (U+0162 U+014E)
  0x01, 0x62, 0x01, 0x4F, 0x08, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x50, 0x02, // ŢŐ (U+0162 U+0150)
  0x01, 0x62, 0x01, 0x51, 0x08, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x52, 0x02, // ŢŒ (U+0162 U+0152)
  0x01, 0x62, 0x01, 0x53, 0x08, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x06, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x06, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x07, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5F, 0x07, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x69, 0x06, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x06, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x06, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x06, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x06, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x06, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x01, 0x75, 0x02, // Ţŵ (U+0162 U+0175)
  0x01, 0x62, 0x01, 0x77, 0x02, // Ţŷ (U+0162 U+0177)
  0x01, 0x62, 0x01, 0x7A, 0x05, // Ţź (U+0162 U+017A)
  0x01, 0x62, 0x01, 0x7C, 0x05, // Ţż (U+0162 U+017C)
  0x01, 0x62, 0x01, 0x7E, 0x05, // Ţž (U+0162 U+017E)
  0x01, 0x62, 0x20, 0x13, 0x05, // Ţ– (U+0162 U+2013)
  0x01, 0x62, 0x20, 0x14, 0x05, // Ţ— (U+0162 U+2014)
  0x01, 0x62, 0x20, 0x1A, 0x07, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x07, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x07, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x07, // Ţ‹ (U+0162 U+2039)
  0x01, 0x62, 0x20, 0x3A, 0x04, // Ţ› (U+0162 U+203A)
  0x01, 0x64, 0x00, 0x26, 0x02, // Ť& (U+0164 U+0026)
  0x01, 0x64, 0x00, 0x2C, 0x07, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2D, 0x05, // Ť- (U+0164 U+002D)
  0x01, 0x64, 0x00, 0x2E, 0x07, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x08, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x43, 0x02, // ŤC (U+0164 U+0043)
  0x01, 0x64, 0x00, 0x47, 0x02, // ŤG (U+0164 U+0047)
  0x01, 0x64, 0x00, 0x4F, 0x02, // ŤO (U+0164 U+004F)
  0x01, 0x64, 0x00, 0x51, 0x02, // ŤQ (U+0164 U+0051)
  0x01, 0x64, 0x00, 0x61, 0x0A, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x08, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x08, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x08, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x08, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x06, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x06, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x08, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x06, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x08, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x06, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x07, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x06, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0x76, 0x02, // Ťv (U+0164 U+0076)
  0x01, 0x64, 0x00, 0x77, 0x02, // Ťw (U+0164 U+0077)
  0x01, 0x64, 0x00, 0x78, 0x02, // Ťx (U+0164 U+0078)
  0x01, 0x64, 0x00, 0x79, 0x02, // Ťy (U+0164 U+0079)
  0x01, 0x64, 0x00, 0x7A, 0x05, // Ťz (U+0164 U+007A)
  0x01, 0x64, 0x00, 0xAB, 0x07, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xBB, 0x04, // Ť» (U+0164 U+00BB)
  0x01, 0x64, 0x00, 0xC0, 0x08, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x08, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x08, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x08, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x08, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x08, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xC7, 0x02, // ŤÇ (U+0164 U+00C7)
  0x01, 0x64, 0x00, 0xD2, 0x02, // ŤÒ (U+0164 U+00D2)
  0x01, 0x64, 0x00, 0xD3, 0x02, // ŤÓ (U+0164 U+00D3)
  0x01, 0x64, 0x00, 0xD4, 0x02, // ŤÔ (U+0164 U+00D4)
  0x01, 0x64, 0x00, 0xD5, 0x02, // ŤÕ (U+0164 U+00D5)
  0x01, 0x64, 0x00, 0xD6, 0x02, // ŤÖ (U+0164 U+00D6)
  0x01, 0x64, 0x00, 0xD8, 0x02, // ŤØ (U+0164 U+00D8)
  0x01, 0x64, 0x00, 0xE0, 0x08, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x0A, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x0A, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x0A, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x0A, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x0A, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x0A, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x08, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x08, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x08, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x08, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x08, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x08, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x08, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x08, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x08, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x08, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x08, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x06, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x06, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x06, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x06, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x00, 0xFD, 0x02, // Ťý (U+0164 U+00FD)
  0x01, 0x64, 0x00, 0xFF, 0x02, // Ťÿ (U+0164 U+00FF)
  0x01, 0x64, 0x01, 0x00, 0x08, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x0A, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x08, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x0A, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x08, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x0A, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x06, 0x02, // ŤĆ (U+0164 U+0106)
  0x01, 0x64, 0x01, 0x07, 0x08, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x08, 0x02, // ŤĈ (U+0164 U+0108)
  0x01, 0x64, 0x01, 0x09, 0x08, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0A, 0x02, // ŤĊ (U+0164 U+010A)
  0x01, 0x64, 0x01, 0x0B, 0x08, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0C, 0x02, // ŤČ (U+0164 U+010C)
  0x01, 0x64, 0x01, 0x0D, 0x08, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x08, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x08, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x08, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x08, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x08, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x08, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x08, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1C, 0x02, // ŤĜ (U+0164 U+011C)
  0x01, 0x64, 0x01, 0x1D, 0x08, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1E, 0x02, // ŤĞ (U+0164 U+011E)
  0x01, 0x64, 0x01, 0x1F, 0x08, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x20, 0x02, // ŤĠ (U+0164 U+0120)
  0x01, 0x64, 0x01, 0x21, 0x08, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x22, 0x02, // ŤĢ (U+0164 U+0122)
  0x01, 0x64, 0x01, 0x23, 0x08, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x06, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x06, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x06, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x4B, 0x06, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4C, 0x02, // ŤŌ (U+0164 U+014C)
  0x01, 0x64, 0x01, 0x4D, 0x08, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4E, 0x02, // ŤŎ (U+0164 U+014E)
  0x01, 0x64, 0x01, 0x4F, 0x08, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x50, 0x02, // ŤŐ (U+0164 U+0150)
  0x01, 0x64, 0x01, 0x51, 0x08, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x52, 0x02, // ŤŒ (U+0164 U+0152)
  0x01, 0x64, 0x01, 0x53, 0x08, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x06, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x06, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x07, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5F, 0x07, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x69, 0x06, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x06, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x06, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x06, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x06, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x06, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x01, 0x75, 0x02, // Ťŵ (U+0164 U+0175)
  0x01, 0x64, 0x01, 0x77, 0x02, // Ťŷ (U+0164 U+0177)
  0x01, 0x64, 0x01, 0x7A, 0x05, // Ťź (U+0164 U+017A)
  0x01, 0x64, 0x01, 0x7C, 0x05, // Ťż (U+0164 U+017C)
  0x01, 0x64, 0x01, 0x7E, 0x05, // Ťž (U+0164 U+017E)
  0x01, 0x64, 0x20, 0x13, 0x05, // Ť– (U+0164 U+2013)
  0x01, 0x64, 0x20, 0x14, 0x05, // Ť— (U+0164 U+2014)
  0x01, 0x64, 0x20, 0x1A, 0x07, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x07, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x07, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x07, // Ť‹ (U+0164 U+2039)
  0x01, 0x64, 0x20, 0x3A, 0x04, // Ť› (U+0164 U+203A)
  0x01, 0x66, 0x00, 0x26, 0x02, // Ŧ& (U+0166 U+0026)
  0x01, 0x66, 0x00, 0x2C, 0x07, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2D, 0x05, // Ŧ- (U+0166 U+002D)
  0x01, 0x66, 0x00, 0x2E, 0x07, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x08, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x43, 0x02, // ŦC (U+0166 U+0043)
  0x01, 0x66, 0x00, 0x47, 0x02, // ŦG (U+0166 U+0047)
  0x01, 0x66, 0x00, 0x4F, 0x02, // ŦO (U+0166 U+004F)
  0x01, 0x66, 0x00, 0x51, 0x02, // ŦQ (U+0166 U+0051)
  0x01, 0x66, 0x00, 0x61, 0x0A, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x08, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x08, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x08, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x08, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x06, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x06, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x08, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x06, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x08, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x06, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x07, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x06, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0x76, 0x02, // Ŧv (U+0166 U+0076)
  0x01, 0x66, 0x00, 0x77, 0x02, // Ŧw (U+0166 U+0077)
  0x01, 0x66, 0x00, 0x78, 0x02, // Ŧx (U+0166 U+0078)
  0x01, 0x66, 0x00, 0x79, 0x02, // Ŧy (U+0166 U+0079)
  0x01, 0x66, 0x00, 0x7A, 0x05, // Ŧz (U+0166 U+007A)
  0x01, 0x66, 0x00, 0xAB, 0x07, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xBB, 0x04, // Ŧ» (U+0166 U+00BB)
  0x01, 0x66, 0x00, 0xC0, 0x08, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x08, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x08, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x08, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x08, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x08, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xC7, 0x02, // ŦÇ (U+0166 U+00C7)
  0x01, 0x66, 0x00, 0xD2, 0x02, // ŦÒ (U+0166 U+00D2)
  0x01, 0x66, 0x00, 0xD3, 0x02, // ŦÓ (U+0166 U+00D3)
  0x01, 0x66, 0x00, 0xD4, 0x02, // ŦÔ (U+0166 U+00D4)
  0x01, 0x66, 0x00, 0xD5, 0x02, // ŦÕ (U+0166 U+00D5)
  0x01, 0x66, 0x00, 0xD6, 0x02, // ŦÖ (U+0166 U+00D6)
  0x01, 0x66, 0x00, 0xD8, 0x02, // ŦØ (U+0166 U+00D8)
  0x01, 0x66, 0x00, 0xE0, 0x08, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x0A, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x0A, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x0A, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x0A, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x0A, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x0A, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x08, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x08, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x08, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x08, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x08, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x08, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x08, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x08, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x08, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x08, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x08, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x06, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x06, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x06, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x06, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x00, 0xFD, 0x02, // Ŧý (U+0166 U+00FD)
  0x01, 0x66, 0x00, 0xFF, 0x02, // Ŧÿ (U+0166 U+00FF)
  0x01, 0x66, 0x01, 0x00, 0x08, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x0A, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x08, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x0A, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x08, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x0A, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x06, 0x02, // ŦĆ (U+0166 U+0106)
  0x01, 0x66, 0x01, 0x07, 0x08, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x08, 0x02, // ŦĈ (U+0166 U+0108)
  0x01, 0x66, 0x01, 0x09, 0x08, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0A, 0x02, // ŦĊ (U+0166 U+010A)
  0x01, 0x66, 0x01, 0x0B, 0x08, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0C, 0x02, // ŦČ (U+0166 U+010C)
  0x01, 0x66, 0x01, 0x0D, 0x08, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x08, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x08, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x08, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x08, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x08, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x08, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x08, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1C, 0x02, // ŦĜ (U+0166 U+011C)
  0x01, 0x66, 0x01, 0x1D, 0x08, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1E, 0x02, // ŦĞ (U+0166 U+011E)
  0x01, 0x66, 0x01, 0x1F, 0x08, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x20, 0x02, // ŦĠ (U+0166 U+0120)
  0x01, 0x66, 0x01, 0x21, 0x08, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x22, 0x02, // ŦĢ (U+0166 U+0122)
  0x01, 0x66, 0x01, 0x23, 0x08, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x06, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x06, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x06, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x4B, 0x06, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4C, 0x02, // ŦŌ (U+0166 U+014C)
  0x01, 0x66, 0x01, 0x4D, 0x08, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4E, 0x02, // ŦŎ (U+0166 U+014E)
  0x01, 0x66, 0x01, 0x4F, 0x08, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x50, 0x02, // ŦŐ (U+0166 U+0150)
  0x01, 0x66, 0x01, 0x51, 0x08, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x52, 0x02, // ŦŒ (U+0166 U+0152)
  0x01, 0x66, 0x01, 0x53, 0x08, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x06, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x06, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x07, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5F, 0x07, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x69, 0x06, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x06, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x06, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x06, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x06, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x06, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x01, 0x75, 0x02, // Ŧŵ (U+0166 U+0175)
  0x01, 0x66, 0x01, 0x77, 0x02, // Ŧŷ (U+0166 U+0177)
  0x01, 0x66, 0x01, 0x7A, 0x05, // Ŧź (U+0166 U+017A)
  0x01, 0x66, 0x01, 0x7C, 0x05, // Ŧż (U+0166 U+017C)
  0x01, 0x66, 0x01, 0x7E, 0x05, // Ŧž (U+0166 U+017E)
  0x01, 0x66, 0x20, 0x13, 0x05, // Ŧ– (U+0166 U+2013)
  0x01, 0x66, 0x20, 0x14, 0x05, // Ŧ— (U+0166 U+2014)
  0x01, 0x66, 0x20, 0x1A, 0x07, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x07, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x07, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x07, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x66, 0x20, 0x3A, 0x04, // Ŧ› (U+0166 U+203A)
  0x01, 0x68, 0x00, 0x2C, 0x02, // Ũ, (U+0168 U+002C)
  0x01, 0x68, 0x00, 0x2E, 0x02, // Ũ. (U+0168 U+002E)
  0x01, 0x68, 0x00, 0x41, 0x01, // ŨA (U+0168 U+0041)
  0x01, 0x68, 0x00, 0xC0, 0x01, // ŨÀ (U+0168 U+00C0)
  0x01, 0x68, 0x00, 0xC1, 0x01, // ŨÁ (U+0168 U+00C1)
  0x01, 0x68, 0x00, 0xC2, 0x01, // ŨÂ (U+0168 U+00C2)
  0x01, 0x68, 0x00, 0xC3, 0x01, // ŨÃ (U+0168 U+00C3)
  0x01, 0x68, 0x00, 0xC4, 0x01, // ŨÄ (U+0168 U+00C4)
  0x01, 0x68, 0x00, 0xC5, 0x01, // ŨÅ (U+0168 U+00C5)
  0x01, 0x68, 0x01, 0x00, 0x01, // ŨĀ (U+0168 U+0100)
  0x01, 0x68, 0x01, 0x02, 0x01, // ŨĂ (U+0168 U+0102)
  0x01, 0x68, 0x01, 0x04, 0x01, // ŨĄ (U+0168 U+0104)
  0x01, 0x68, 0x20, 0x1A, 0x02, // Ũ‚ (U+0168 U+201A)
  0x01, 0x68, 0x20, 0x1E, 0x02, // Ũ„ (U+0168 U+201E)
  0x01, 0x68, 0x20, 0x26, 0x02, // Ũ… (U+0168 U+2026)
  0x01, 0x6A, 0x00, 0x2C, 0x02, // Ū, (U+016A U+002C)
  0x01, 0x6A, 0x00, 0x2E, 0x02, // Ū. (U+016A U+002E)
  0x01, 0x6A, 0x00, 0x41, 0x01, // ŪA (U+016A U+0041)
  0x01, 0x6A, 0x00, 0xC0, 0x01, // ŪÀ (U+016A U+00C0)
  0x01, 0x6A, 0x00, 0xC1, 0x01, // ŪÁ (U+016A U+00C1)
  0x01, 0x6A, 0x00, 0xC2, 0x01, // ŪÂ (U+016A U+00C2)
  0x01, 0x6A, 0x00, 0xC3, 0x01, // ŪÃ (U+016A U+00C3)
  0x01, 0x6A, 0x00, 0xC4, 0x01, // ŪÄ (U+016A U+00C4)
  0x01, 0x6A, 0x00, 0xC5, 0x01, // ŪÅ (U+016A U+00C5)
  0x01, 0x6A, 0x01, 0x00, 0x01, // ŪĀ (U+016A U+0100)
  0x01, 0x6A, 0x01, 0x02, 0x01, // ŪĂ (U+016A U+0102)
  0x01, 0x6A, 0x01, 0x04, 0x01, // ŪĄ (U+016A U+0104)
  0x01, 0x6A, 0x20, 0x1A, 0x02, // Ū‚ (U+016A U+201A)
  0x01, 0x6A, 0x20, 0x1E, 0x02, // Ū„ (U+016A U+201E)
  0x01, 0x6A, 0x20, 0x26, 0x02, // Ū… (U+016A U+2026)
  0x01, 0x6C, 0x00, 0x2C, 0x02, // Ŭ, (U+016C U+002C)
  0x01, 0x6C, 0x00, 0x2E, 0x02, // Ŭ. (U+016C U+002E)
  0x01, 0x6C, 0x00, 0x41, 0x01, // ŬA (U+016C U+0041)
  0x01, 0x6C, 0x00, 0xC0, 0x01, // ŬÀ (U+016C U+00C0)
  0x01, 0x6C, 0x00, 0xC1, 0x01, // ŬÁ (U+016C U+00C1)
  0x01, 0x6C, 0x00, 0xC2, 0x01, // ŬÂ (U+016C U+00C2)
  0x01, 0x6C, 0x00, 0xC3, 0x01, // ŬÃ (U+016C U+00C3)
  0x01, 0x6C, 0x00, 0xC4, 0x01, // ŬÄ (U+016C U+00C4)
  0x01, 0x6C, 0x00, 0xC5, 0x01, // ŬÅ (U+016C U+00C5)
  0x01, 0x6C, 0x01, 0x00, 0x01, // ŬĀ (U+016C U+0100)
  0x01, 0x6C, 0x01, 0x02, 0x01, // ŬĂ (U+016C U+0102)
  0x01, 0x6C, 0x01, 0x04, 0x01, // ŬĄ (U+016C U+0104)
  0x01, 0x6C, 0x20, 0x1A, 0x02, // Ŭ‚ (U+016C U+201A)
  0x01, 0x6C, 0x20, 0x1E, 0x02, // Ŭ„ (U+016C U+201E)
  0x01, 0x6C, 0x20, 0x26, 0x02, // Ŭ… (U+016C U+2026)
  0x01, 0x6E, 0x00, 0x2C, 0x02, // Ů, (U+016E U+002C)
  0x01, 0x6E, 0x00, 0x2E, 0x02, // Ů. (U+016E U+002E)
  0x01, 0x6E, 0x00, 0x41, 0x01, // ŮA (U+016E U+0041)
  0x01, 0x6E, 0x00, 0xC0, 0x01, // ŮÀ (U+016E U+00C0)
  0x01, 0x6E, 0x00, 0xC1, 0x01, // ŮÁ (U+016E U+00C1)
  0x01, 0x6E, 0x00, 0xC2, 0x01, // ŮÂ (U+016E U+00C2)
  0x01, 0x6E, 0x00, 0xC3, 0x01, // ŮÃ (U+016E U+00C3)
  0x01, 0x6E, 0x00, 0xC4, 0x01, // ŮÄ (U+016E U+00C4)
  0x01, 0x6E, 0x00, 0xC5, 0x01, // ŮÅ (U+016E U+00C5)
  0x01, 0x6E, 0x01, 0x00, 0x01, // ŮĀ (U+016E U+0100)
  0x01, 0x6E, 0x01, 0x02, 0x01, // ŮĂ (U+016E U+0102)
  0x01, 0x6E, 0x01, 0x04, 0x01, // ŮĄ (U+016E U+0104)
  0x01, 0x6E, 0x20, 0x1A, 0x02, // Ů‚ (U+016E U+201A)
  0x01, 0x6E, 0x20, 0x1E, 0x02, // Ů„ (U+016E U+201E)
  0x01, 0x6E, 0x20, 0x26, 0x02, // Ů… (U+016E U+2026)
  0x01, 0x70, 0x00, 0x2C, 0x02, // Ű, (U+0170 U+002C)
  0x01, 0x70, 0x00, 0x2E, 0x02, // Ű. (U+0170 U+002E)
  0x01, 0x70, 0x00, 0x41, 0x01, // ŰA (U+0170 U+0041)
  0x01, 0x70, 0x00, 0xC0, 0x01, // ŰÀ (U+0170 U+00C0)
  0x01, 0x70, 0x00, 0xC1, 0x01, // ŰÁ (U+0170 U+00C1)
  0x01, 0x70, 0x00, 0xC2, 0x01, // ŰÂ (U+0170 U+00C2)
  0x01, 0x70, 0x00, 0xC3, 0x01, // ŰÃ (U+0170 U+00C3)
  0x01, 0x70, 0x00, 0xC4, 0x01, // ŰÄ (U+0170 U+00C4)
  0x01, 0x70, 0x00, 0xC5, 0x01, // ŰÅ (U+0170 U+00C5)
  0x01, 0x70, 0x01, 0x00, 0x01, // ŰĀ (U+0170 U+0100)
  0x01, 0x70, 0x01, 0x02, 0x01, // ŰĂ (U+0170 U+0102)
  0x01, 0x70, 0x01, 0x04, 0x01, // ŰĄ (U+0170 U+0104)
  0x01, 0x70, 0x20, 0x1A, 0x02, // Ű‚ (U+0170 U+201A)
  0x01, 0x70, 0x20, 0x1E, 0x02, // Ű„ (U+0170 U+201E)
  0x01, 0x70, 0x20, 0x26, 0x02, // Ű… (U+0170 U+2026)
  0x01, 0x72, 0x00, 0x2C, 0x02, // Ų, (U+0172 U+002C)
  0x01, 0x72, 0x00, 0x2E, 0x02, // Ų. (U+0172 U+002E)
  0x01, 0x72, 0x00, 0x41, 0x01, // ŲA (U+0172 U+0041)
  0x01, 0x72, 0x00, 0xC0, 0x01, // ŲÀ (U+0172 U+00C0)
  0x01, 0x72, 0x00, 0xC1, 0x01, // ŲÁ (U+0172 U+00C1)
  0x01, 0x72, 0x00, 0xC2, 0x01, // ŲÂ (U+0172 U+00C2)
  0x01, 0x72, 0x00, 0xC3, 0x01, // ŲÃ (U+0172 U+00C3)
  0x01, 0x72, 0x00, 0xC4, 0x01, // ŲÄ (U+0172 U+00C4)
  0x01, 0x72, 0x00, 0xC5, 0x01, // ŲÅ (U+0172 U+00C5)
  0x01, 0x72, 0x01, 0x00, 0x01, // ŲĀ (U+0172 U+0100)
  0x01, 0x72, 0x01, 0x02, 0x01, // ŲĂ (U+0172 U+0102)
  0x01, 0x72, 0x01, 0x04, 0x01, // ŲĄ (U+0172 U+0104)
  0x01, 0x72, 0x20, 0x1A, 0x02, // Ų‚ (U+0172 U+201A)
  0x01, 0x72, 0x20, 0x1E, 0x02, // Ų„ (U+0172 U+201E)
  0x01, 0x72, 0x20, 0x26, 0x02, // Ų… (U+0172 U+2026)
  0x01, 0x74, 0x00, 0x2C, 0x06, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x06, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x41, 0x05, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0x43, 0x01, // ŴC (U+0174 U+0043)
  0x01, 0x74, 0x00, 0x47, 0x01, // ŴG (U+0174 U+0047)
  0x01, 0x74, 0x00, 0x4F, 0x01, // ŴO (U+0174 U+004F)
  0x01, 0x74, 0x00, 0x51, 0x01, // ŴQ (U+0174 U+0051)
  0x01, 0x74, 0x00, 0x61, 0x02, // Ŵa (U+0174 U+0061)
  0x01, 0x74, 0x00, 0x63, 0x02, // Ŵc (U+0174 U+0063)
  0x01, 0x74, 0x00, 0x64, 0x02, // Ŵd (U+0174 U+0064)
  0x01, 0x74, 0x00, 0x65, 0x02, // Ŵe (U+0174 U+0065)
  0x01, 0x74, 0x00, 0x67, 0x01, // Ŵg (U+0174 U+0067)
  0x01, 0x74, 0x00, 0x6D, 0x01, // Ŵm (U+0174 U+006D)
  0x01, 0x74, 0x00, 0x6E, 0x01, // Ŵn (U+0174 U+006E)
  0x01, 0x74, 0x00, 0x6F, 0x02, // Ŵo (U+0174 U+006F)
  0x01, 0x74, 0x00, 0x70, 0x01, // Ŵp (U+0174 U+0070)
  0x01, 0x74, 0x00, 0x71, 0x02, // Ŵq (U+0174 U+0071)
  0x01, 0x74, 0x00, 0x72, 0x01, // Ŵr (U+0174 U+0072)
  0x01, 0x74, 0x00, 0x73, 0x01, // Ŵs (U+0174 U+0073)
  0x01, 0x74, 0x00, 0x75, 0x01, // Ŵu (U+0174 U+0075)
  0x01, 0x74, 0x00, 0xAB, 0x04, // Ŵ« (U+0174 U+00AB)
  0x01, 0x74, 0x00, 0xBB, 0x01, // Ŵ» (U+0174 U+00BB)
  0x01, 0x74, 0x00, 0xC0, 0x05, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x05, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x05, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x05, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x05, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x05, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x00, 0xC7, 0x01, // ŴÇ (U+0174 U+00C7)
  0x01, 0x74, 0x00, 0xD2, 0x01, // ŴÒ (U+0174 U+00D2)
  0x01, 0x74, 0x00, 0xD3, 0x01, // ŴÓ (U+0174 U+00D3)
  0x01, 0x74, 0x00, 0xD4, 0x01, // ŴÔ (U+0174 U+00D4)
  0x01, 0x74, 0x00, 0xD5, 0x01, // ŴÕ (U+0174 U+00D5)
  0x01, 0x74, 0x00, 0xD6, 0x01, // ŴÖ (U+0174 U+00D6)
  0x01, 0x74, 0x00, 0xD8, 0x01, // ŴØ (U+0174 U+00D8)
  0x01, 0x74, 0x00, 0xE0, 0x02, // Ŵà (U+0174 U+00E0)
  0x01, 0x74, 0x00, 0xE1, 0x02, // Ŵá (U+0174 U+00E1)
  0x01, 0x74, 0x00, 0xE2, 0x02, // Ŵâ (U+0174 U+00E2)
  0x01, 0x74, 0x00, 0xE3, 0x02, // Ŵã (U+0174 U+00E3)
  0x01, 0x74, 0x00, 0xE4, 0x02, // Ŵä (U+0174 U+00E4)
  0x01, 0x74, 0x00, 0xE5, 0x02, // Ŵå (U+0174 U+00E5)
  0x01, 0x74, 0x00, 0xE6, 0x02, // Ŵæ (U+0174 U+00E6)
  0x01, 0x74, 0x00, 0xE7, 0x02, // Ŵç (U+0174 U+00E7)
  0x01, 0x74, 0x00, 0xE8, 0x02, // Ŵè (U+0174 U+00E8)
  0x01, 0x74, 0x00, 0xE9, 0x02, // Ŵé (U+0174 U+00E9)
  0x01, 0x74, 0x00, 0xEA, 0x02, // Ŵê (U+0174 U+00EA)
  0x01, 0x74, 0x00, 0xEB, 0x02, // Ŵë (U+0174 U+00EB)
  0x01, 0x74, 0x00, 0xF2, 0x02, // Ŵò (U+0174 U+00F2)
  0x01, 0x74, 0x00, 0xF3, 0x02, // Ŵó (U+0174 U+00F3)
  0x01, 0x74, 0x00, 0xF4, 0x02, // Ŵô (U+0174 U+00F4)
  0x01, 0x74, 0x00, 0xF5, 0x02, // Ŵõ (U+0174 U+00F5)
  0x01, 0x74, 0x00, 0xF6, 0x02, // Ŵö (U+0174 U+00F6)
  0x01, 0x74, 0x00, 0xF8, 0x02, // Ŵø (U+0174 U+00F8)
  0x01, 0x74, 0x00, 0xF9, 0x01, // Ŵù (U+0174 U+00F9)
  0x01, 0x74, 0x00, 0xFA, 0x01, // Ŵú (U+0174 U+00FA)
  0x01, 0x74, 0x00, 0xFB, 0x01, // Ŵû (U+0174 U+00FB)
  0x01, 0x74, 0x00, 0xFC, 0x01, // Ŵü (U+0174 U+00FC)
  0x01, 0x74, 0x01, 0x00, 0x05, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x01, 0x02, // Ŵā (U+0174 U+0101)
  0x01, 0x74, 0x01, 0x02, 0x05, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x03, 0x02, // Ŵă (U+0174 U+0103)
  0x01, 0x74, 0x01, 0x04, 0x05, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x01, 0x05, 0x02, // Ŵą (U+0174 U+0105)
  0x01, 0x74, 0x01, 0x06, 0x01, // ŴĆ (U+0174 U+0106)
  0x01, 0x74, 0x01, 0x07, 0x02, // Ŵć (U+0174 U+0107)
  0x01, 0x74, 0x01, 0x08, 0x01, // ŴĈ (U+0174 U+0108)
  0x01, 0x74, 0x01, 0x09, 0x02, // Ŵĉ (U+0174 U+0109)
  0x01, 0x74, 0x01, 0x0A, 0x01, // ŴĊ (U+0174 U+010A)
  0x01, 0x74, 0x01, 0x0B, 0x02, // Ŵċ (U+0174 U+010B)
  0x01, 0x74, 0x01, 0x0C, 0x01, // ŴČ (U+0174 U+010C)
  0x01, 0x74, 0x01, 0x0D, 0x02, // Ŵč (U+0174 U+010D)
  0x01, 0x74, 0x01, 0x0F, 0x02, // Ŵď (U+0174 U+010F)
  0x01, 0x74, 0x01, 0x11, 0x02, // Ŵđ (U+0174 U+0111)
  0x01, 0x74, 0x01, 0x13, 0x02, // Ŵē (U+0174 U+0113)
  0x01, 0x74, 0x01, 0x15, 0x02, // Ŵĕ (U+0174 U+0115)
  0x01, 0x74, 0x01, 0x17, 0x02, // Ŵė (U+0174 U+0117)
  0x01, 0x74, 0x01, 0x19, 0x02, // Ŵę (U+0174 U+0119)
  0x01, 0x74, 0x01, 0x1B, 0x02, // Ŵě (U+0174 U+011B)
  0x01, 0x74, 0x01, 0x1C, 0x01, // ŴĜ (U+0174 U+011C)
  0x01, 0x74, 0x01, 0x1D, 0x01, // Ŵĝ (U+0174 U+011D)
  0x01, 0x74, 0x01, 0x1E, 0x01, // ŴĞ (U+0174 U+011E)
  0x01, 0x74, 0x01, 0x1F, 0x01, // Ŵğ (U+0174 U+011F)
  0x01, 0x74, 0x01, 0x20, 0x01, // ŴĠ (U+0174 U+0120)
  0x01, 0x74, 0x01, 0x21, 0x01, // Ŵġ (U+0174 U+0121)
  0x01, 0x74, 0x01, 0x22, 0x01, // ŴĢ (U+0174 U+0122)
  0x01, 0x74, 0x01, 0x23, 0x01, // Ŵģ (U+0174 U+0123)
  0x01, 0x74, 0x01, 0x38, 0x01, // Ŵĸ (U+0174 U+0138)
  0x01, 0x74, 0x01, 0x44, 0x01, // Ŵń (U+0174 U+0144)
  0x01, 0x74, 0x01, 0x46, 0x01, // Ŵņ (U+0174 U+0146)
  0x01, 0x74, 0x01, 0x4B, 0x01, // Ŵŋ (U+0174 U+014B)
  0x01, 0x74, 0x01, 0x4C, 0x01, // ŴŌ (U+0174 U+014C)
  0x01, 0x74, 0x01, 0x4D, 0x02, // Ŵō (U+0174 U+014D)
  0x01, 0x74, 0x01, 0x4E, 0x01, // ŴŎ (U+0174 U+014E)
  0x01, 0x74, 0x01, 0x4F, 0x02, // Ŵŏ (U+0174 U+014F)
  0x01, 0x74, 0x01, 0x50, 0x01, // ŴŐ (U+0174 U+0150)
  0x01, 0x74, 0x01, 0x51, 0x02, // Ŵő (U+0174 U+0151)
  0x01, 0x74, 0x01, 0x52, 0x01, // ŴŒ (U+0174 U+0152)
  0x01, 0x74, 0x01, 0x53, 0x02, // Ŵœ (U+0174 U+0153)
  0x01, 0x74, 0x01, 0x55, 0x01, // Ŵŕ (U+0174 U+0155)
  0x01, 0x74, 0x01, 0x57, 0x01, // Ŵŗ (U+0174 U+0157)
  0x01, 0x74, 0x01, 0x5B, 0x01, // Ŵś (U+0174 U+015B)
  0x01, 0x74, 0x01, 0x5F, 0x01, // Ŵş (U+0174 U+015F)
  0x01, 0x74, 0x01, 0x69, 0x01, // Ŵũ (U+0174 U+0169)
  0x01, 0x74, 0x01, 0x6B, 0x01, // Ŵū (U+0174 U+016B)
  0x01, 0x74, 0x01, 0x6D, 0x01, // Ŵŭ (U+0174 U+016D)
  0x01, 0x74, 0x01, 0x6F, 0x01, // Ŵů (U+0174 U+016F)
  0x01, 0x74, 0x01, 0x71, 0x01, // Ŵű (U+0174 U+0171)
  0x01, 0x74, 0x01, 0x73, 0x01, // Ŵų (U+0174 U+0173)
  0x01, 0x74, 0x20, 0x1A, 0x06, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x06, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x06, // Ŵ… (U+0174 U+2026)
  0x01, 0x74, 0x20, 0x39, 0x04, // Ŵ‹ (U+0174 U+2039)
  0x01, 0x74, 0x20, 0x3A, 0x01, // Ŵ› (U+0174 U+203A)
  0x01, 0x75, 0x00, 0x2C, 0x05, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x05, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x05, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x05, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x05, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x26, 0x04, // Ŷ& (U+0176 U+0026)
  0x01, 0x76, 0x00, 0x2C, 0x07, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x07, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x07, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x43, 0x02, // ŶC (U+0176 U+0043)
  0x01, 0x76, 0x00, 0x47, 0x02, // ŶG (U+0176 U+0047)
  0x01, 0x76, 0x00, 0x4F, 0x02, // ŶO (U+0176 U+004F)
  0x01, 0x76, 0x00, 0x51, 0x02, // ŶQ (U+0176 U+0051)
  0x01, 0x76, 0x00, 0x61, 0x06, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x06, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x06, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x06, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x06, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6D, 0x04, // Ŷm (U+0176 U+006D)
  0x01, 0x76, 0x00, 0x6E, 0x04, // Ŷn (U+0176 U+006E)
  0x01, 0x76, 0x00, 0x6F, 0x06, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x70, 0x04, // Ŷp (U+0176 U+0070)
  0x01, 0x76, 0x00, 0x71, 0x06, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x72, 0x04, // Ŷr (U+0176 U+0072)
  0x01, 0x76, 0x00, 0x73, 0x05, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0x75, 0x04, // Ŷu (U+0176 U+0075)
  0x01, 0x76, 0x00, 0x7A, 0x02, // Ŷz (U+0176 U+007A)
  0x01, 0x76, 0x00, 0xAB, 0x0A, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xBB, 0x04, // Ŷ» (U+0176 U+00BB)
  0x01, 0x76, 0x00, 0xC0, 0x07, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x07, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x07, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x07, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x07, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x07, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xC7, 0x02, // ŶÇ (U+0176 U+00C7)
  0x01, 0x76, 0x00, 0xD2, 0x02, // ŶÒ (U+0176 U+00D2)
  0x01, 0x76, 0x00, 0xD3, 0x02, // ŶÓ (U+0176 U+00D3)
  0x01, 0x76, 0x00, 0xD4, 0x02, // ŶÔ (U+0176 U+00D4)
  0x01, 0x76, 0x00, 0xD5, 0x02, // ŶÕ (U+0176 U+00D5)
  0x01, 0x76, 0x00, 0xD6, 0x02, // ŶÖ (U+0176 U+00D6)
  0x01, 0x76, 0x00, 0xD8, 0x02, // ŶØ (U+0176 U+00D8)
  0x01, 0x76, 0x00, 0xE0, 0x06, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x06, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x06, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x06, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x06, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x06, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x06, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x06, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x06, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x06, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x06, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x06, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF2, 0x06, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x06, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x06, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x06, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x06, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x06, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x00, 0xF9, 0x04, // Ŷù (U+0176 U+00F9)
  0x01, 0x76, 0x00, 0xFA, 0x04, // Ŷú (U+0176 U+00FA)
  0x01, 0x76, 0x00, 0xFB, 0x04, // Ŷû (U+0176 U+00FB)
  0x01, 0x76, 0x00, 0xFC, 0x04, // Ŷü (U+0176 U+00FC)
  0x01, 0x76, 0x01, 0x00, 0x07, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x06, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x07, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x06, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x07, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x06, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x06, 0x02, // ŶĆ (U+0176 U+0106)
  0x01, 0x76, 0x01, 0x07, 0x06, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x08, 0x02, // ŶĈ (U+0176 U+0108)
  0x01, 0x76, 0x01, 0x09, 0x06, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0A, 0x02, // ŶĊ (U+0176 U+010A)
  0x01, 0x76, 0x01, 0x0B, 0x06, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0C, 0x02, // ŶČ (U+0176 U+010C)
  0x01, 0x76, 0x01, 0x0D, 0x06, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x06, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x06, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x06, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x06, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x06, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x06, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x06, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1C, 0x02, // ŶĜ (U+0176 U+011C)
  0x01, 0x76, 0x01, 0x1D, 0x06, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1E, 0x02, // ŶĞ (U+0176 U+011E)
  0x01, 0x76, 0x01, 0x1F, 0x06, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x20, 0x02, // ŶĠ (U+0176 U+0120)
  0x01, 0x76, 0x01, 0x21, 0x06, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x22, 0x02, // ŶĢ (U+0176 U+0122)
  0x01, 0x76, 0x01, 0x23, 0x06, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x38, 0x04, // Ŷĸ (U+0176 U+0138)
  0x01, 0x76, 0x01, 0x44, 0x04, // Ŷń (U+0176 U+0144)
  0x01, 0x76, 0x01, 0x46, 0x04, // Ŷņ (U+0176 U+0146)
  0x01, 0x76, 0x01, 0x4B, 0x04, // Ŷŋ (U+0176 U+014B)
  0x01, 0x76, 0x01, 0x4C, 0x02, // ŶŌ (U+0176 U+014C)
  0x01, 0x76, 0x01, 0x4D, 0x06, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4E, 0x02, // ŶŎ (U+0176 U+014E)
  0x01, 0x76, 0x01, 0x4F, 0x06, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x50, 0x02, // ŶŐ (U+0176 U+0150)
  0x01, 0x76, 0x01, 0x51, 0x06, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x52, 0x02, // ŶŒ (U+0176 U+0152)
  0x01, 0x76, 0x01, 0x53, 0x06, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x55, 0x04, // Ŷŕ (U+0176 U+0155)
  0x01, 0x76, 0x01, 0x57, 0x04, // Ŷŗ (U+0176 U+0157)
  0x01, 0x76, 0x01, 0x5B, 0x05, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5F, 0x05, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x69, 0x04, // Ŷũ (U+0176 U+0169)
  0x01, 0x76, 0x01, 0x6B, 0x04, // Ŷū (U+0176 U+016B)
  0x01, 0x76, 0x01, 0x6D, 0x04, // Ŷŭ (U+0176 U+016D)
  0x01, 0x76, 0x01, 0x6F, 0x04, // Ŷů (U+0176 U+016F)
  0x01, 0x76, 0x01, 0x71, 0x04, // Ŷű (U+0176 U+0171)
  0x01, 0x76, 0x01, 0x73, 0x04, // Ŷų (U+0176 U+0173)
  0x01, 0x76, 0x01, 0x7A, 0x02, // Ŷź (U+0176 U+017A)
  0x01, 0x76, 0x01, 0x7C, 0x02, // Ŷż (U+0176 U+017C)
  0x01, 0x76, 0x01, 0x7E, 0x02, // Ŷž (U+0176 U+017E)
  0x01, 0x76, 0x20, 0x1A, 0x07, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x07, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x07, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x0A, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x76, 0x20, 0x3A, 0x04, // Ŷ› (U+0176 U+203A)
  0x01, 0x77, 0x00, 0x2C, 0x05, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x05, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x05, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x05, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x05, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x26, 0x04, // Ÿ& (U+0178 U+0026)
  0x01, 0x78, 0x00, 0x2C, 0x07, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x07, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x07, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x43, 0x02, // ŸC (U+0178 U+0043)
  0x01, 0x78, 0x00, 0x47, 0x02, // ŸG (U+0178 U+0047)
  0x01, 0x78, 0x00, 0x4F, 0x02, // ŸO (U+0178 U+004F)
  0x01, 0x78, 0x00, 0x51, 0x02, // ŸQ (U+0178 U+0051)
  0x01, 0x78, 0x00, 0x61, 0x06, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x06, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x06, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x06, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x06, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6D, 0x04, // Ÿm (U+0178 U+006D)
  0x01, 0x78, 0x00, 0x6E, 0x04, // Ÿn (U+0178 U+006E)
  0x01, 0x78, 0x00, 0x6F, 0x06, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x70, 0x04, // Ÿp (U+0178 U+0070)
  0x01, 0x78, 0x00, 0x71, 0x06, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x72, 0x04, // Ÿr (U+0178 U+0072)
  0x01, 0x78, 0x00, 0x73, 0x05, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0x75, 0x04, // Ÿu (U+0178 U+0075)
  0x01, 0x78, 0x00, 0x7A, 0x02, // Ÿz (U+0178 U+007A)
  0x01, 0x78, 0x00, 0xAB, 0x0A, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xBB, 0x04, // Ÿ» (U+0178 U+00BB)
  0x01, 0x78, 0x00, 0xC0, 0x07, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x07, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x07, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x07, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x07, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x07, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xC7, 0x02, // ŸÇ (U+0178 U+00C7)
  0x01, 0x78, 0x00, 0xD2, 0x02, // ŸÒ (U+0178 U+00D2)
  0x01, 0x78, 0x00, 0xD3, 0x02, // ŸÓ (U+0178 U+00D3)
  0x01, 0x78, 0x00, 0xD4, 0x02, // ŸÔ (U+0178 U+00D4)
  0x01, 0x78, 0x00, 0xD5, 0x02, // ŸÕ (U+0178 U+00D5)
  0x01, 0x78, 0x00, 0xD6, 0x02, // ŸÖ (U+0178 U+00D6)
  0x01, 0x78, 0x00, 0xD8, 0x02, // ŸØ (U+0178 U+00D8)
  0x01, 0x78, 0x00, 0xE0, 0x06, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x06, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x06, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x06, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x06, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x06, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x06, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x06, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x06, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x06, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x06, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x06, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF2, 0x06, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x06, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x06, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x06, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x06, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x06, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x00, 0xF9, 0x04, // Ÿù (U+0178 U+00F9)
  0x01, 0x78, 0x00, 0xFA, 0x04, // Ÿú (U+0178 U+00FA)
  0x01, 0x78, 0x00, 0xFB, 0x04, // Ÿû (U+0178 U+00FB)
  0x01, 0x78, 0x00, 0xFC, 0x04, // Ÿü (U+0178 U+00FC)
  0x01, 0x78, 0x01, 0x00, 0x07, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x06, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x07, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x06, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x07, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x06, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x06, 0x02, // ŸĆ (U+0178 U+0106)
  0x01, 0x78, 0x01, 0x07, 0x06, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x08, 0x02, // ŸĈ (U+0178 U+0108)
  0x01, 0x78, 0x01, 0x09, 0x06, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0A, 0x02, // ŸĊ (U+0178 U+010A)
  0x01, 0x78, 0x01, 0x0B, 0x06, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0C, 0x02, // ŸČ (U+0178 U+010C)
  0x01, 0x78, 0x01, 0x0D, 0x06, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x06, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x06, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x06, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x06, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x06, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x06, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x06, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1C, 0x02, // ŸĜ (U+0178 U+011C)
  0x01, 0x78, 0x01, 0x1D, 0x06, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1E, 0x02, // ŸĞ (U+0178 U+011E)
  0x01, 0x78, 0x01, 0x1F, 0x06, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x20, 0x02, // ŸĠ (U+0178 U+0120)
  0x01, 0x78, 0x01, 0x21, 0x06, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x22, 0x02, // ŸĢ (U+0178 U+0122)
  0x01, 0x78, 0x01, 0x23, 0x06, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x38, 0x04, // Ÿĸ (U+0178 U+0138)
  0x01, 0x78, 0x01, 0x44, 0x04, // Ÿń (U+0178 U+0144)
  0x01, 0x78, 0x01, 0x46, 0x04, // Ÿņ (U+0178 U+0146)
  0x01, 0x78, 0x01, 0x4B, 0x04, // Ÿŋ (U+0178 U+014B)
  0x01, 0x78, 0x01, 0x4C, 0x02, // ŸŌ (U+0178 U+014C)
  0x01, 0x78, 0x01, 0x4D, 0x06, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4E, 0x02, // ŸŎ (U+0178 U+014E)
  0x01, 0x78, 0x01, 0x4F, 0x06, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x50, 0x02, // ŸŐ (U+0178 U+0150)
  0x01, 0x78, 0x01, 0x51, 0x06, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x52, 0x02, // ŸŒ (U+0178 U+0152)
  0x01, 0x78, 0x01, 0x53, 0x06, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x55, 0x04, // Ÿŕ (U+0178 U+0155)
  0x01, 0x78, 0x01, 0x57, 0x04, // Ÿŗ (U+0178 U+0157)
  0x01, 0x78, 0x01, 0x5B, 0x05, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5F, 0x05, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x69, 0x04, // Ÿũ (U+0178 U+0169)
  0x01, 0x78, 0x01, 0x6B, 0x04, // Ÿū (U+0178 U+016B)
  0x01, 0x78, 0x01, 0x6D, 0x04, // Ÿŭ (U+0178 U+016D)
  0x01, 0x78, 0x01, 0x6F, 0x04, // Ÿů (U+0178 U+016F)
  0x01, 0x78, 0x01, 0x71, 0x04, // Ÿű (U+0178 U+0171)
  0x01, 0x78, 0x01, 0x73, 0x04, // Ÿų (U+0178 U+0173)
  0x01, 0x78, 0x01, 0x7A, 0x02, // Ÿź (U+0178 U+017A)
  0x01, 0x78, 0x01, 0x7C, 0x02, // Ÿż (U+0178 U+017C)
  0x01, 0x78, 0x01, 0x7E, 0x02, // Ÿž (U+0178 U+017E)
  0x01, 0x78, 0x20, 0x1A, 0x07, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x07, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x07, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x0A, // Ÿ‹ (U+0178 U+2039)
  0x01, 0x78, 0x20, 0x3A, 0x04, // Ÿ› (U+0178 U+203A)
  0x01, 0x79, 0x00, 0x43, 0x01, // ŹC (U+0179 U+0043)
  0x01, 0x79, 0x00, 0x47, 0x01, // ŹG (U+0179 U+0047)
  0x01, 0x79, 0x00, 0x4F, 0x01, // ŹO (U+0179 U+004F)
  0x01, 0x79, 0x00, 0x51, 0x01, // ŹQ (U+0179 U+0051)
  0x01, 0x79, 0x00, 0xAB, 0x02, // Ź« (U+0179 U+00AB)
  0x01, 0x79, 0x00, 0xC7, 0x01, // ŹÇ (U+0179 U+00C7)
  0x01, 0x79, 0x00, 0xD2, 0x01, // ŹÒ (U+0179 U+00D2)
  0x01, 0x79, 0x00, 0xD3, 0x01, // ŹÓ (U+0179 U+00D3)
  0x01, 0x79, 0x00, 0xD4, 0x01, // ŹÔ (U+0179 U+00D4)
  0x01, 0x79, 0x00, 0xD5, 0x01, // ŹÕ (U+0179 U+00D5)
  0x01, 0x79, 0x00, 0xD6, 0x01, // ŹÖ (U+0179 U+00D6)
  0x01, 0x79, 0x00, 0xD8, 0x01, // ŹØ (U+0179 U+00D8)
  0x01, 0x79, 0x01, 0x06, 0x01, // ŹĆ (U+0179 U+0106)
  0x01, 0x79, 0x01, 0x08, 0x01, // ŹĈ (U+0179 U+0108)
  0x01, 0x79, 0x01, 0x0A, 0x01, // ŹĊ (U+0179 U+010A)
  0x01, 0x79, 0x01, 0x0C, 0x01, // ŹČ (U+0179 U+010C)
  0x01, 0x79, 0x01, 0x1C, 0x01, // ŹĜ (U+0179 U+011C)
  0x01, 0x79, 0x01, 0x1E, 0x01, // ŹĞ (U+0179 U+011E)
  0x01, 0x79, 0x01, 0x20, 0x01, // ŹĠ (U+0179 U+0120)
  0x01, 0x79, 0x01, 0x22, 0x01, // ŹĢ (U+0179 U+0122)
  0x01, 0x79, 0x01, 0x4C, 0x01, // ŹŌ (U+0179 U+014C)
  0x01, 0x79, 0x01, 0x4E, 0x01, // ŹŎ (U+0179 U+014E)
  0x01, 0x79, 0x01, 0x50, 0x01, // ŹŐ (U+0179 U+0150)
  0x01, 0x79, 0x01, 0x52, 0x01, // ŹŒ (U+0179 U+0152)
  0x01, 0x79, 0x20, 0x39, 0x02, // Ź‹ (U+0179 U+2039)
  0x01, 0x7B, 0x00, 0x43, 0x01, // ŻC (U+017B U+0043)
  0x01, 0x7B, 0x00, 0x47, 0x01, // ŻG (U+017B U+0047)
  0x01, 0x7B, 0x00, 0x4F, 0x01, // ŻO (U+017B U+004F)
  0x01, 0x7B, 0x00, 0x51, 0x01, // ŻQ (U+017B U+0051)
  0x01, 0x7B, 0x00, 0xAB, 0x02, // Ż« (U+017B U+00AB)
  0x01, 0x7B, 0x00, 0xC7, 0x01, // ŻÇ (U+017B U+00C7)
  0x01, 0x7B, 0x00, 0xD2, 0x01, // ŻÒ (U+017B U+00D2)
  0x01, 0x7B, 0x00, 0xD3, 0x01, // ŻÓ (U+017B U+00D3)
  0x01, 0x7B, 0x00, 0xD4, 0x01, // ŻÔ (U+017B U+00D4)
  0x01, 0x7B, 0x00, 0xD5, 0x01, // ŻÕ (U+017B U+00D5)
  0x01, 0x7B, 0x00, 0xD6, 0x01, // ŻÖ (U+017B U+00D6)
  0x01, 0x7B, 0x00, 0xD8, 0x01, // ŻØ (U+017B U+00D8)
  0x01, 0x7B, 0x01, 0x06, 0x01, // ŻĆ (U+017B U+0106)
  0x01, 0x7B, 0x01, 0x08, 0x01, // ŻĈ (U+017B U+0108)
  0x01, 0x7B, 0x01, 0x0A, 0x01, // ŻĊ (U+017B U+010A)
  0x01, 0x7B, 0x01, 0x0C, 0x01, // ŻČ (U+017B U+010C)
  0x01, 0x7B, 0x01, 0x1C, 0x01, // ŻĜ (U+017B U+011C)
  0x01, 0x7B, 0x01, 0x1E, 0x01, // ŻĞ (U+017B U+011E)
  0x01, 0x7B, 0x01, 0x20, 0x01, // ŻĠ (U+017B U+0120)
  0x01, 0x7B, 0x01, 0x22, 0x01, // ŻĢ (U+017B U+0122)
  0x01, 0x7B, 0x01, 0x4C, 0x01, // ŻŌ (U+017B U+014C)
  0x01, 0x7B, 0x01, 0x4E, 0x01, // ŻŎ (U+017B U+014E)
  0x01, 0x7B, 0x01, 0x50, 0x01, // ŻŐ (U+017B U+0150)
  0x01, 0x7B, 0x01, 0x52, 0x01, // ŻŒ (U+017B U+0152)
  0x01, 0x7B, 0x20, 0x39, 0x02, // Ż‹ (U+017B U+2039)
  0x01, 0x7D, 0x00, 0x43, 0x01, // ŽC (U+017D U+0043)
  0x01, 0x7D, 0x00, 0x47, 0x01, // ŽG (U+017D U+0047)
  0x01, 0x7D, 0x00, 0x4F, 0x01, // ŽO (U+017D U+004F)
  0x01, 0x7D, 0x00, 0x51, 0x01, // ŽQ (U+017D U+0051)
  0x01, 0x7D, 0x00, 0xAB, 0x02, // Ž« (U+017D U+00AB)
  0x01, 0x7D, 0x00, 0xC7, 0x01, // ŽÇ (U+017D U+00C7)
  0x01, 0x7D, 0x00, 0xD2, 0x01, // ŽÒ (U+017D U+00D2)
  0x01, 0x7D, 0x00, 0xD3, 0x01, // ŽÓ (U+017D U+00D3)
  0x01, 0x7D, 0x00, 0xD4, 0x01, // ŽÔ (U+017D U+00D4)
  0x01, 0x7D, 0x00, 0xD5, 0x01, // ŽÕ (U+017D U+00D5)
  0x01, 0x7D, 0x00, 0xD6, 0x01, // ŽÖ (U+017D U+00D6)
  0x01, 0x7D, 0x00, 0xD8, 0x01, // ŽØ (U+017D U+00D8)
  0x01, 0x7D, 0x01, 0x06, 0x01, // ŽĆ (U+017D U+0106)
  0x01, 0x7D, 0x01, 0x08, 0x01, // ŽĈ (U+017D U+0108)
  0x01, 0x7D, 0x01, 0x0A, 0x01, // ŽĊ (U+017D U+010A)
  0x01, 0x7D, 0x01, 0x0C, 0x01, // ŽČ (U+017D U+010C)
  0x01, 0x7D, 0x01, 0x1C, 0x01, // ŽĜ (U+017D U+011C)
  0x01, 0x7D, 0x01, 0x1E, 0x01, // ŽĞ (U+017D U+011E)
  0x01, 0x7D, 0x01, 0x20, 0x01, // ŽĠ (U+017D U+0120)
  0x01, 0x7D, 0x01, 0x22, 0x01, // ŽĢ (U+017D U+0122)
  0x01, 0x7D, 0x01, 0x4C, 0x01, // ŽŌ (U+017D U+014C)
  0x01, 0x7D, 0x01, 0x4E, 0x01, // ŽŎ (U+017D U+014E)
  0x01, 0x7D, 0x01, 0x50, 0x01, // ŽŐ (U+017D U+0150)
  0x01, 0x7D, 0x01, 0x52, 0x01, // ŽŒ (U+017D U+0152)
  0x01, 0x7D, 0x20, 0x39, 0x02, // Ž‹ (U+017D U+2039)
  0x20, 0x13, 0x00, 0x54, 0x05, // –T (U+2013 U+0054)
  0x20, 0x13, 0x01, 0x62, 0x05, // –Ţ (U+2013 U+0162)
  0x20, 0x13, 0x01, 0x64, 0x05, // –Ť (U+2013 U+0164)
  0x20, 0x13, 0x01, 0x66, 0x05, // –Ŧ (U+2013 U+0166)
  0x20, 0x14, 0x00, 0x54, 0x05, // —T (U+2014 U+0054)
  0x20, 0x14, 0x01, 0x62, 0x05, // —Ţ (U+2014 U+0162)
  0x20, 0x14, 0x01, 0x64, 0x05, // —Ť (U+2014 U+0164)
  0x20, 0x14, 0x01, 0x66, 0x05, // —Ŧ (U+2014 U+0166)
  0x20, 0x18, 0x00, 0x41, 0x08, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x61, 0x05, // ‘a (U+2018 U+0061)
  0x20, 0x18, 0x00, 0x63, 0x07, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x07, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x07, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x67, 0x04, // ‘g (U+2018 U+0067)
  0x20, 0x18, 0x00, 0x6D, 0x04, // ‘m (U+2018 U+006D)
  0x20, 0x18, 0x00, 0x6E, 0x04, // ‘n (U+2018 U+006E)
  0x20, 0x18, 0x00, 0x6F, 0x07, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x70, 0x04, // ‘p (U+2018 U+0070)
  0x20, 0x18, 0x00, 0x71, 0x07, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0x72, 0x04, // ‘r (U+2018 U+0072)
  0x20, 0x18, 0x00, 0x73, 0x04, // ‘s (U+2018 U+0073)
  0x20, 0x18, 0x00, 0x75, 0x04, // ‘u (U+2018 U+0075)
  0x20, 0x18, 0x00, 0xC0, 0x08, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x08, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x08, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x08, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x08, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x08, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x0A, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x00, 0xE0, 0x07, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE1, 0x05, // ‘á (U+2018 U+00E1)
  0x20, 0x18, 0x00, 0xE2, 0x05, // ‘â (U+2018 U+00E2)
  0x20, 0x18, 0x00, 0xE3, 0x05, // ‘ã (U+2018 U+00E3)
  0x20, 0x18, 0x00, 0xE4, 0x05, // ‘ä (U+2018 U+00E4)
  0x20, 0x18, 0x00, 0xE5, 0x05, // ‘å (U+2018 U+00E5)
  0x20, 0x18, 0x00, 0xE6, 0x05, // ‘æ (U+2018 U+00E6)
  0x20, 0x18, 0x00, 0xE7, 0x07, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x07, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x07, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x07, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x07, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x07, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x07, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x07, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x07, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x07, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x07, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x00, 0xF9, 0x04, // ‘ù (U+2018 U+00F9)
  0x20, 0x18, 0x00, 0xFA, 0x04, // ‘ú (U+2018 U+00FA)
  0x20, 0x18, 0x00, 0xFB, 0x04, // ‘û (U+2018 U+00FB)
  0x20, 0x18, 0x00, 0xFC, 0x04, // ‘ü (U+2018 U+00FC)
  0x20, 0x18, 0x01, 0x00, 0x08, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x01, 0x05, // ‘ā (U+2018 U+0101)
  0x20, 0x18, 0x01, 0x02, 0x08, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x03, 0x05, // ‘ă (U+2018 U+0103)
  0x20, 0x18, 0x01, 0x04, 0x08, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x05, 0x05, // ‘ą (U+2018 U+0105)
  0x20, 0x18, 0x01, 0x07, 0x07, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x07, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x07, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x07, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x07, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x07, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x07, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x07, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x07, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x07, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x07, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x1D, 0x04, // ‘ĝ (U+2018 U+011D)
  0x20, 0x18, 0x01, 0x1F, 0x04, // ‘ğ (U+2018 U+011F)
  0x20, 0x18, 0x01, 0x21, 0x04, // ‘ġ (U+2018 U+0121)
  0x20, 0x18, 0x01, 0x23, 0x04, // ‘ģ (U+2018 U+0123)
  0x20, 0x18, 0x01, 0x38, 0x04, // ‘ĸ (U+2018 U+0138)
  0x20, 0x18, 0x01, 0x44, 0x04, // ‘ń (U+2018 U+0144)
  0x20, 0x18, 0x01, 0x46, 0x04, // ‘ņ (U+2018 U+0146)
  0x20, 0x18, 0x01, 0x4B, 0x04, // ‘ŋ (U+2018 U+014B)
  0x20, 0x18, 0x01, 0x4D, 0x07, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x07, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x07, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x07, // ‘œ (U+2018 U+0153)
  0x20, 0x18, 0x01, 0x55, 0x04, // ‘ŕ (U+2018 U+0155)
  0x20, 0x18, 0x01, 0x57, 0x04, // ‘ŗ (U+2018 U+0157)
  0x20, 0x18, 0x01, 0x5B, 0x04, // ‘ś (U+2018 U+015B)
  0x20, 0x18, 0x01, 0x5F, 0x04, // ‘ş (U+2018 U+015F)
  0x20, 0x18, 0x01, 0x69, 0x04, // ‘ũ (U+2018 U+0169)
  0x20, 0x18, 0x01, 0x6B, 0x04, // ‘ū (U+2018 U+016B)
  0x20, 0x18, 0x01, 0x6D, 0x04, // ‘ŭ (U+2018 U+016D)
  0x20, 0x18, 0x01, 0x6F, 0x04, // ‘ů (U+2018 U+016F)
  0x20, 0x18, 0x01, 0x71, 0x04, // ‘ű (U+2018 U+0171)
  0x20, 0x18, 0x01, 0x73, 0x04, // ‘ų (U+2018 U+0173)
  0x20, 0x18, 0x03, 0xBC, 0x02, // ‘μ (U+2018 U+03BC)
  0x20, 0x19, 0x00, 0x41, 0x08, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x61, 0x05, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x07, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x07, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x07, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x67, 0x04, // ’g (U+2019 U+0067)
  0x20, 0x19, 0x00, 0x6D, 0x04, // ’m (U+2019 U+006D)
  0x20, 0x19, 0x00, 0x6E, 0x04, // ’n (U+2019 U+006E)
  0x20, 0x19, 0x00, 0x6F, 0x07, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x70, 0x04, // ’p (U+2019 U+0070)
  0x20, 0x19, 0x00, 0x71, 0x07, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0x72, 0x04, // ’r (U+2019 U+0072)
  0x20, 0x19, 0x00, 0x73, 0x04, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0x75, 0x04, // ’u (U+2019 U+0075)
  0x20, 0x19, 0x00, 0xC0, 0x08, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x08, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x08, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x08, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x08, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x08, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x0A, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xE0, 0x07, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x05, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x05, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x05, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x05, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x05, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x05, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x07, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x07, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x07, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x07, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x07, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x07, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x07, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x07, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x07, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x07, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x07, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x00, 0xF9, 0x04, // ’ù (U+2019 U+00F9)
  0x20, 0x19, 0x00, 0xFA, 0x04, // ’ú (U+2019 U+00FA)
  0x20, 0x19, 0x00, 0xFB, 0x04, // ’û (U+2019 U+00FB)
  0x20, 0x19, 0x00, 0xFC, 0x04, // ’ü (U+2019 U+00FC)
  0x20, 0x19, 0x01, 0x00, 0x08, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x05, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x08, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x05, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x08, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x05, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x07, 0x07, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x07, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x07, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x07, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x07, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x07, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x07, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x07, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x07, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x07, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x07, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x1D, 0x04, // ’ĝ (U+2019 U+011D)
  0x20, 0x19, 0x01, 0x1F, 0x04, // ’ğ (U+2019 U+011F)
  0x20, 0x19, 0x01, 0x21, 0x04, // ’ġ (U+2019 U+0121)
  0x20, 0x19, 0x01, 0x23, 0x04, // ’ģ (U+2019 U+0123)
  0x20, 0x19, 0x01, 0x38, 0x04, // ’ĸ (U+2019 U+0138)
  0x20, 0x19, 0x01, 0x44, 0x04, // ’ń (U+2019 U+0144)
  0x20, 0x19, 0x01, 0x46, 0x04, // ’ņ (U+2019 U+0146)
  0x20, 0x19, 0x01, 0x4B, 0x04, // ’ŋ (U+2019 U+014B)
  0x20, 0x19, 0x01, 0x4D, 0x07, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x07, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x07, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x07, // ’œ (U+2019 U+0153)
  0x20, 0x19, 0x01, 0x55, 0x04, // ’ŕ (U+2019 U+0155)
  0x20, 0x19, 0x01, 0x57, 0x04, // ’ŗ (U+2019 U+0157)
  0x20, 0x19, 0x01, 0x5B, 0x04, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5F, 0x04, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x69, 0x04, // ’ũ (U+2019 U+0169)
  0x20, 0x19, 0x01, 0x6B, 0x04, // ’ū (U+2019 U+016B)
  0x20, 0x19, 0x01, 0x6D, 0x04, // ’ŭ (U+2019 U+016D)
  0x20, 0x19, 0x01, 0x6F, 0x04, // ’ů (U+2019 U+016F)
  0x20, 0x19, 0x01, 0x71, 0x04, // ’ű (U+2019 U+0171)
  0x20, 0x19, 0x01, 0x73, 0x04, // ’ų (U+2019 U+0173)
  0x20, 0x19, 0x03, 0xBC, 0x02, // ’μ (U+2019 U+03BC)
  0x20, 0x1A, 0x00, 0x43, 0x06, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x06, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x06, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x06, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x08, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x55, 0x02, // ‚U (U+201A U+0055)
  0x20, 0x1A, 0x00, 0x56, 0x07, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x07, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x07, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x06, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x06, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x06, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x06, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x06, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x06, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x06, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xD9, 0x02, // ‚Ù (U+201A U+00D9)
  0x20, 0x1A, 0x00, 0xDA, 0x02, // ‚Ú (U+201A U+00DA)
  0x20, 0x1A, 0x00, 0xDB, 0x02, // ‚Û (U+201A U+00DB)
  0x20, 0x1A, 0x00, 0xDC, 0x02, // ‚Ü (U+201A U+00DC)
  0x20, 0x1A, 0x00, 0xDD, 0x07, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x06, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x06, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x06, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x06, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x06, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x06, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x06, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x06, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x06, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x06, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x06, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x06, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x08, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x08, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x08, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x68, 0x02, // ‚Ũ (U+201A U+0168)
  0x20, 0x1A, 0x01, 0x6A, 0x02, // ‚Ū (U+201A U+016A)
  0x20, 0x1A, 0x01, 0x6C, 0x02, // ‚Ŭ (U+201A U+016C)
  0x20, 0x1A, 0x01, 0x6E, 0x02, // ‚Ů (U+201A U+016E)
  0x20, 0x1A, 0x01, 0x70, 0x02, // ‚Ű (U+201A U+0170)
  0x20, 0x1A, 0x01, 0x72, 0x02, // ‚Ų (U+201A U+0172)
  0x20, 0x1A, 0x01, 0x74, 0x07, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x07, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x07, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x08, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x61, 0x05, // “a (U+201C U+0061)
  0x20, 0x1C, 0x00, 0x63, 0x07, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x07, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x07, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x67, 0x04, // “g (U+201C U+0067)
  0x20, 0x1C, 0x00, 0x6D, 0x04, // “m (U+201C U+006D)
  0x20, 0x1C, 0x00, 0x6E, 0x04, // “n (U+201C U+006E)
  0x20, 0x1C, 0x00, 0x6F, 0x07, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x70, 0x04, // “p (U+201C U+0070)
  0x20, 0x1C, 0x00, 0x71, 0x07, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0x72, 0x04, // “r (U+201C U+0072)
  0x20, 0x1C, 0x00, 0x73, 0x04, // “s (U+201C U+0073)
  0x20, 0x1C, 0x00, 0x75, 0x04, // “u (U+201C U+0075)
  0x20, 0x1C, 0x00, 0xC0, 0x08, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x08, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x08, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x08, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x08, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x08, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x0A, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x00, 0xE0, 0x07, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE1, 0x05, // “á (U+201C U+00E1)
  0x20, 0x1C, 0x00, 0xE2, 0x05, // “â (U+201C U+00E2)
  0x20, 0x1C, 0x00, 0xE3, 0x05, // “ã (U+201C U+00E3)
  0x20, 0x1C, 0x00, 0xE4, 0x05, // “ä (U+201C U+00E4)
  0x20, 0x1C, 0x00, 0xE5, 0x05, // “å (U+201C U+00E5)
  0x20, 0x1C, 0x00, 0xE6, 0x05, // “æ (U+201C U+00E6)
  0x20, 0x1C, 0x00, 0xE7, 0x07, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x07, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x07, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x07, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x07, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x07, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x07, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x07, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x07, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x07, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x07, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x00, 0xF9, 0x04, // “ù (U+201C U+00F9)
  0x20, 0x1C, 0x00, 0xFA, 0x04, // “ú (U+201C U+00FA)
  0x20, 0x1C, 0x00, 0xFB, 0x04, // “û (U+201C U+00FB)
  0x20, 0x1C, 0x00, 0xFC, 0x04, // “ü (U+201C U+00FC)
  0x20, 0x1C, 0x01, 0x00, 0x08, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x01, 0x05, // “ā (U+201C U+0101)
  0x20, 0x1C, 0x01, 0x02, 0x08, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x03, 0x05, // “ă (U+201C U+0103)
  0x20, 0x1C, 0x01, 0x04, 0x08, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x05, 0x05, // “ą (U+201C U+0105)
  0x20, 0x1C, 0x01, 0x07, 0x07, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x07, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x07, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x07, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x07, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x07, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x07, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x07, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x07, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x07, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x07, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x1D, 0x04, // “ĝ (U+201C U+011D)
  0x20, 0x1C, 0x01, 0x1F, 0x04, // “ğ (U+201C U+011F)
  0x20, 0x1C, 0x01, 0x21, 0x04, // “ġ (U+201C U+0121)
  0x20, 0x1C, 0x01, 0x23, 0x04, // “ģ (U+201C U+0123)
  0x20, 0x1C, 0x01, 0x38, 0x04, // “ĸ (U+201C U+0138)
  0x20, 0x1C, 0x01, 0x44, 0x04, // “ń (U+201C U+0144)
  0x20, 0x1C, 0x01, 0x46, 0x04, // “ņ (U+201C U+0146)
  0x20, 0x1C, 0x01, 0x4B, 0x04, // “ŋ (U+201C U+014B)
  0x20, 0x1C, 0x01, 0x4D, 0x07, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x07, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x07, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x07, // “œ (U+201C U+0153)
  0x20, 0x1C, 0x01, 0x55, 0x04, // “ŕ (U+201C U+0155)
  0x20, 0x1C, 0x01, 0x57, 0x04, // “ŗ (U+201C U+0157)
  0x20, 0x1C, 0x01, 0x5B, 0x04, // “ś (U+201C U+015B)
  0x20, 0x1C, 0x01, 0x5F, 0x04, // “ş (U+201C U+015F)
  0x20, 0x1C, 0x01, 0x69, 0x04, // “ũ (U+201C U+0169)
  0x20, 0x1C, 0x01, 0x6B, 0x04, // “ū (U+201C U+016B)
  0x20, 0x1C, 0x01, 0x6D, 0x04, // “ŭ (U+201C U+016D)
  0x20, 0x1C, 0x01, 0x6F, 0x04, // “ů (U+201C U+016F)
  0x20, 0x1C, 0x01, 0x71, 0x04, // “ű (U+201C U+0171)
  0x20, 0x1C, 0x01, 0x73, 0x04, // “ų (U+201C U+0173)
  0x20, 0x1C, 0x03, 0xBC, 0x02, // “μ (U+201C U+03BC)
  0x20, 0x1D, 0x00, 0x41, 0x08, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x61, 0x05, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x07, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x07, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x07, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x67, 0x04, // ”g (U+201D U+0067)
  0x20, 0x1D, 0x00, 0x6D, 0x04, // ”m (U+201D U+006D)
  0x20, 0x1D, 0x00, 0x6E, 0x04, // ”n (U+201D U+006E)
  0x20, 0x1D, 0x00, 0x6F, 0x07, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x70, 0x04, // ”p (U+201D U+0070)
  0x20, 0x1D, 0x00, 0x71, 0x07, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0x72, 0x04, // ”r (U+201D U+0072)
  0x20, 0x1D, 0x00, 0x73, 0x04, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0x75, 0x04, // ”u (U+201D U+0075)
  0x20, 0x1D, 0x00, 0xC0, 0x08, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x08, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x08, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x08, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x08, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x08, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x0A, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xE0, 0x07, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x05, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x05, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x05, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x05, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x05, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x05, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x07, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x07, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x07, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x07, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x07, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x07, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x07, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x07, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x07, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x07, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x07, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x00, 0xF9, 0x04, // ”ù (U+201D U+00F9)
  0x20, 0x1D, 0x00, 0xFA, 0x04, // ”ú (U+201D U+00FA)
  0x20, 0x1D, 0x00, 0xFB, 0x04, // ”û (U+201D U+00FB)
  0x20, 0x1D, 0x00, 0xFC, 0x04, // ”ü (U+201D U+00FC)
  0x20, 0x1D, 0x01, 0x00, 0x08, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x05, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x08, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x05, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x08, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x05, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x07, 0x07, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x07, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x07, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x07, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x07, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x07, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x07, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x07, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x07, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x07, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x07, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x1D, 0x04, // ”ĝ (U+201D U+011D)
  0x20, 0x1D, 0x01, 0x1F, 0x04, // ”ğ (U+201D U+011F)
  0x20, 0x1D, 0x01, 0x21, 0x04, // ”ġ (U+201D U+0121)
  0x20, 0x1D, 0x01, 0x23, 0x04, // ”ģ (U+201D U+0123)
  0x20, 0x1D, 0x01, 0x38, 0x04, // ”ĸ (U+201D U+0138)
  0x20, 0x1D, 0x01, 0x44, 0x04, // ”ń (U+201D U+0144)
  0x20, 0x1D, 0x01, 0x46, 0x04, // ”ņ (U+201D U+0146)
  0x20, 0x1D, 0x01, 0x4B, 0x04, // ”ŋ (U+201D U+014B)
  0x20, 0x1D, 0x01, 0x4D, 0x07, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x07, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x07, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x07, // ”œ (U+201D U+0153)
  0x20, 0x1D, 0x01, 0x55, 0x04, // ”ŕ (U+201D U+0155)
  0x20, 0x1D, 0x01, 0x57, 0x04, // ”ŗ (U+201D U+0157)
  0x20, 0x1D, 0x01, 0x5B, 0x04, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5F, 0x04, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x69, 0x04, // ”ũ (U+201D U+0169)
  0x20, 0x1D, 0x01, 0x6B, 0x04, // ”ū (U+201D U+016B)
  0x20, 0x1D, 0x01, 0x6D, 0x04, // ”ŭ (U+201D U+016D)
  0x20, 0x1D, 0x01, 0x6F, 0x04, // ”ů (U+201D U+016F)
  0x20, 0x1D, 0x01, 0x71, 0x04, // ”ű (U+201D U+0171)
  0x20, 0x1D, 0x01, 0x73, 0x04, // ”ų (U+201D U+0173)
  0x20, 0x1D, 0x03, 0xBC, 0x02, // ”μ (U+201D U+03BC)
  0x20, 0x1E, 0x00, 0x43, 0x06, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x06, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x06, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x06, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x08, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x55, 0x02, // „U (U+201E U+0055)
  0x20, 0x1E, 0x00, 0x56, 0x07, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x07, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x07, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x06, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x06, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x06, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x06, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x06, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x06, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x06, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xD9, 0x02, // „Ù (U+201E U+00D9)
  0x20, 0x1E, 0x00, 0xDA, 0x02, // „Ú (U+201E U+00DA)
  0x20, 0x1E, 0x00, 0xDB, 0x02, // „Û (U+201E U+00DB)
  0x20, 0x1E, 0x00, 0xDC, 0x02, // „Ü (U+201E U+00DC)
  0x20, 0x1E, 0x00, 0xDD, 0x07, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x06, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x06, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x06, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x06, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x06, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x06, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x06, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x06, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x06, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x06, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x06, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x06, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x08, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x08, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x08, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x68, 0x02, // „Ũ (U+201E U+0168)
  0x20, 0x1E, 0x01, 0x6A, 0x02, // „Ū (U+201E U+016A)
  0x20, 0x1E, 0x01, 0x6C, 0x02, // „Ŭ (U+201E U+016C)
  0x20, 0x1E, 0x01, 0x6E, 0x02, // „Ů (U+201E U+016E)
  0x20, 0x1E, 0x01, 0x70, 0x02, // „Ű (U+201E U+0170)
  0x20, 0x1E, 0x01, 0x72, 0x02, // „Ų (U+201E U+0172)
  0x20, 0x1E, 0x01, 0x74, 0x07, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x07, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x07, // „Ÿ (U+201E U+0178)
  0x20, 0x39, 0x00, 0x54, 0x04, // ‹T (U+2039 U+0054)
  0x20, 0x39, 0x00, 0x56, 0x01, // ‹V (U+2039 U+0056)
  0x20, 0x39, 0x00, 0x57, 0x01, // ‹W (U+2039 U+0057)
  0x20, 0x39, 0x00, 0x59, 0x04, // ‹Y (U+2039 U+0059)
  0x20, 0x39, 0x00, 0xDD, 0x04, // ‹Ý (U+2039 U+00DD)
  0x20, 0x39, 0x01, 0x62, 0x04, // ‹Ţ (U+2039 U+0162)
  0x20, 0x39, 0x01, 0x64, 0x04, // ‹Ť (U+2039 U+0164)
  0x20, 0x39, 0x01, 0x66, 0x04, // ‹Ŧ (U+2039 U+0166)
  0x20, 0x39, 0x01, 0x74, 0x01, // ‹Ŵ (U+2039 U+0174)
  0x20, 0x39, 0x01, 0x76, 0x04, // ‹Ŷ (U+2039 U+0176)
  0x20, 0x39, 0x01, 0x78, 0x04, // ‹Ÿ (U+2039 U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x07, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x56, 0x04, // ›V (U+203A U+0056)
  0x20, 0x3A, 0x00, 0x57, 0x04, // ›W (U+203A U+0057)
  0x20, 0x3A, 0x00, 0x58, 0x02, // ›X (U+203A U+0058)
  0x20, 0x3A, 0x00, 0x59, 0x0A, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x0A, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x07, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x07, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x07, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x74, 0x04, // ›Ŵ (U+203A U+0174)
  0x20, 0x3A, 0x01, 0x76, 0x0A, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x0A, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x1C, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x1C, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x1C, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x1C, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x1C, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x1C, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x1C, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x1C, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x1C, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x1C, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x10, 0x28, 0x03, 0xB0, 0xA2, 0x02, 0xF0, 0xE2, 0x02, 0xF0, 0xD2, 0x01, 0xF0, 0xD2, 0x01, 0xF0,
  0xD2, 0x01, 0xF0, 0xC3, 0xF0, 0xC3, 0xF0, 0xB3, 0xF0, 0xB3, 0xF0, 0xB3, 0x0E, 0xE0, 0xA3, 0x0E,
  0xE0, 0xA3, 0x0D, 0xE0, 0x93, 0x0D, 0xE0, 0x93, 0x0D, 0xE0, 0x83, 0x0C, 0xE0, 0x83, 0x0C, 0xE0,
  0x83, 0x0C, 0xE0, 0x73, 0x0B, 0xE0, 0x73, 0x0B, 0xE0, 0x63, 0x0A, 0xE0, 0x63, 0x0A, 0xE0, 0x63,
  0x0A, 0xE0, 0x53, 0x09, 0xE0, 0x53, 0x09, 0xE0, 0x43, 0x09, 0xE0, 0x43, 0x08, 0xE0, 0x43, 0x08,
  0xE0, 0x33, 0x07, 0xE0, 0x33, 0x07, 0xE0, 0x23, 0x07, 0xE0, 0x23, 0x06, 0xE0, 0x13, 0x06, 0xE0,
  0x13, 0x05, 0xE0, 0x13, 0x05, 0xE4, 0x05, 0xE4, 0x04, 0xE4, 0x04, 0xE4, 0x03, 0xD0, 0xE4, 0x03,
  0xD0, 0xE4, 0x03, 0xD0, 0xD4, 0x02, 0xD0, 0xD4, 0x02, 0xD0, 0xC4, 0x02, 0xD0, 0xC4, 0x01, 0xD0,
  0xC4, 0x01, 0xD0, 0xB5, 0xD0, 0xB5, 0xD0, 0xA5, 0xD0, 0xA5, 0xD0, 0xA5, 0x0E, 0xC0, 0x95, 0x0E,
  0xC0, 0x95, 0x0E, 0xC0, 0x85, 0x0D, 0xC0, 0x85, 0x0D, 0xC0, 0x85, 0x0C, 0xC0, 0x75, 0x0C, 0xC0,
  0x75, 0x0C, 0xC0, 0x65, 0x0B, 0xC0, 0x65, 0x0B, 0xC0, 0x55, 0x0B, 0xC0, 0x55, 0x0A, 0xC0, 0x55,
  0x0A, 0xC0, 0x45, 0x84, 0x35, 0x55, 0x51, 0x80, 0x9F, 0x20, 0x83, 0x15, 0x55, 0x25, 0x09, 0xD0,
  0xC0, 0x22, 0x09, 0xF8, 0x1D, 0x02, 0xFA, 0x00, 0x6F, 0xA0, 0xB0, 0x9F, 0xA0, 0xD0, 0x9F, 0xA0,
  0xE0, 0x8F, 0xA0, 0xD0, 0x6F, 0xA0, 0xA0, 0x1F, 0xA8, 0x16, 0x08, 0xF0, 0xC3, 0x07, 0x0E, 0xC0,
  0xA0, 0x15, 0x0F, 0x30, 0x13,
  // """ (U+0022)
  0x08, 0x80, 0x2B, 0x06, 0x75, 0x0A, 0x80, 0x2B, 0x04, 0x0A, 0xE0, 0x87, 0x50, 0xDE, 0x05, 0x09,
  0xE0, 0x77, 0x50, 0xCE, 0x04, 0x08, 0xE0, 0x67, 0x50, 0xBE, 0x03, 0x08, 0xE0, 0x67, 0x50, 0xBE,
  0x03, 0x07, 0xE0, 0x57, 0x50, 0xAE, 0x02, 0x06, 0xE0, 0x47, 0x50, 0x9E, 0x01, 0x05, 0xE0, 0x47,
  0x50, 0x9E, 0x01, 0x05, 0xE0, 0x37, 0x50, 0x8E, 0x10, 0x4E, 0x02, 0x75, 0x07, 0xE1, 0x03, 0xE0,
  0x17, 0x50, 0x6D, 0x81, 0xE0, 0x3E, 0x01, 0x75, 0x06, 0xD8, 0x1D, 0x02, 0xE7, 0x60, 0x5D, 0x81,
  0xC0, 0x1E, 0x76, 0x04, 0xD0, 0xC2, 0xD0, 0xE7, 0x60, 0x4D, 0x0B, 0x2D, 0x0D, 0x76, 0x03, 0xD0,
  0xA2, 0x0E, 0xC0, 0xD7, 0x60, 0x2D, 0x0A, 0x20, 0xEC, 0x0C, 0x76, 0x01, 0xD0, 0x92, 0x0D, 0xC0,
  0xB7, 0x60, 0x1D, 0x08, 0x20, 0xCC, 0x0A, 0x77, 0xD0, 0x72, 0x0C, 0xC0, 0xA7, 0x7D, 0x07, 0x20,
  0xBC, 0x09, 0x77, 0x0E, 0xC0, 0x62, 0x0A, 0xC0, 0x87, 0x70, 0xDC, 0x05, 0x20, 0x9C, 0x08, 0x77,
  0x0D, 0xC0, 0x42, 0x09, 0xC0, 0x77, 0x70, 0xCC, 0x04, 0x20, 0x8C, 0x06, 0x77, 0x0B, 0xC0, 0x32,
  0x07, 0xC0, 0x57, 0x70, 0xAC, 0x02, 0x20, 0x7C, 0x05, 0x77, 0x0A, 0xC0, 0x22, 0x06, 0xC0, 0x47,
  0x70, 0x9C, 0x01, 0x20, 0x5C, 0x03, 0x77, 0x08, 0xC3, 0x04, 0xC0, 0x37, 0x70, 0x8C, 0x30, 0x18,
  0x00, 0x37, 0x71, 0x01, 0x80, 0x03, 0x20,
  // "#" (U+0023)
  0x77, 0x76, 0x02, 0x80, 0x1B, 0x07, 0x77, 0x68, 0x49, 0xBB, 0xBB, 0x98, 0x0C, 0x30, 0x05, 0xD0,
  0x77, 0x76, 0xD0, 0xA8, 0x0C, 0x30, 0x08, 0xD0, 0x47, 0x75, 0x02, 0xD0, 0x78, 0x0C, 0x30, 0x0B,
  0xD0, 0x17, 0x75, 0x05, 0xD0, 0x48, 0x0C, 0x30, 0x0E, 0xC0, 0xE7, 0x76, 0x08, 0xD0, 0x18, 0x0C,
  0x20, 0x02, 0xD0, 0xB7, 0x76, 0x0B, 0xC0, 0xD8, 0x0C, 0x30, 0x05, 0xD0, 0x87, 0x76, 0x0E, 0xC0,
  0xA8, 0x0C, 0x30, 0x08, 0xD0, 0x57, 0x75, 0x02, 0xD0, 0x78, 0x0C, 0x30, 0x0B, 0xD0, 0x27, 0x75,
  0x05, 0xD0, 0x48, 0x0C, 0x30, 0x0E, 0xC0, 0xE7, 0x76, 0x07, 0xD0, 0x18, 0x0C, 0x20, 0x01, 0xD0,
  0xC7, 0x76, 0x0A, 0xC0, 0xE8, 0x0C, 0x30, 0x04, 0xD0, 0x97, 0x76, 0x0D, 0xC0, 0xB8, 0x0C, 0x30,
  0x07, 0xD0, 0x67, 0x75, 0x01, 0xD0, 0x88, 0x0C, 0x30, 0x0A, 0xD0, 0x37, 0x75, 0x04, 0xD0, 0x58,
  0x0C, 0x30, 0x0D, 0xD7, 0x76, 0x07, 0xD0, 0x28, 0x0C, 0x30, 0xD0, 0xC7, 0x76, 0x0A, 0xC0, 0xE8,
  0x0C, 0x30, 0x03, 0xD0, 0x97, 0x76, 0x0D, 0xC0, 0xC8, 0x0C, 0x30, 0x06, 0xD0, 0x67, 0x76, 0xD0,
  0x98, 0x0C, 0x30, 0x09, 0xD0, 0x37, 0x75, 0x03, 0xD0, 0x68, 0x0C, 0x30, 0x0C, 0xD0, 0x17, 0x75,
  0x06, 0xD0, 0x38, 0x0C, 0x30, 0xD0, 0xD7, 0x76, 0x09, 0xD8, 0x0C, 0x30, 0x03, 0xD0, 0xA7, 0x76,
  0x0C, 0xC0, 0xD8, 0x0C, 0x30, 0x06, 0xD0, 0x77, 0x76, 0xD0, 0xA8, 0x0C, 0x30, 0x09, 0xD0, 0x47,
  0x75, 0x02, 0xD0, 0x78, 0x0C, 0x30, 0x0C, 0xD0, 0x17, 0x75, 0x05, 0xD0, 0x48, 0x0C, 0x30, 0x0E,
  0xC0, 0xE7, 0x76, 0x08, 0xD0, 0x17, 0x76, 0x01, 0x80, 0x95, 0x30, 0x5D, 0x0C, 0x80, 0xA0, 0x30,
  0xCC, 0x0E, 0x80, 0x94, 0x30, 0x14, 0x04, 0x80, 0xF6, 0xF0, 0x44, 0x04, 0x80, 0xF6, 0xF0, 0x44,
  0x04, 0x80, 0xF6, 0xF0, 0x44, 0x04, 0x80, 0xF6, 0xF0, 0x44, 0x04, 0x80, 0xF6, 0xF0, 0x45, 0x80,
  0x94, 0x10, 0x5D, 0x07, 0x80, 0x97, 0x10, 0x20, 0xEC, 0x0C, 0x80, 0x95, 0x17, 0x77, 0x10, 0x6D,
  0x03, 0x77, 0x50, 0x2D, 0x09, 0x80, 0xC3, 0x00, 0x9D, 0x77, 0x60, 0x5D, 0x06, 0x80, 0xC3, 0x00,
  0xCC, 0x0C, 0x77, 0x60, 0x8D, 0x03, 0x80, 0xC3, 0x0D, 0x09, 0x77, 0x60, 0xBD, 0x80, 0xC3, 0x00,
  0x3D, 0x06, 0x77, 0x60, 0xEC, 0x0C, 0x80, 0xC3, 0x00, 0x6D, 0x03, 0x77, 0x50, 0x1D, 0x09, 0x80,
  0xC3, 0x00, 0x9D, 0x77, 0x60, 0x4D, 0x06, 0x80, 0xC3, 0x00, 0xCC, 0x0D, 0x77, 0x60, 0x7D, 0x03,
  0x80, 0xC3, 0x0D, 0x0A, 0x77, 0x60, 0xAD, 0x80, 0xC3, 0x00, 0x3D, 0x07, 0x77, 0x60, 0xDC, 0x0D,
  0x80, 0xC3, 0x00, 0x6D, 0x04, 0x77, 0x50, 0x1D, 0x0A, 0x80, 0xC3, 0x00, 0x9D, 0x01, 0x77, 0x50,
  0x4D, 0x07, 0x80, 0xC3, 0x00, 0xCC, 0x0D, 0x77, 0x60, 0x7D, 0x04, 0x80, 0xC3, 0x0D, 0x0A, 0x77,
  0x60, 0xAD, 0x01, 0x80, 0xC2, 0x00, 0x3D, 0x07, 0x77, 0x60, 0xDC, 0x0D, 0x80, 0xC3, 0x00, 0x6D,
  0x04, 0x77, 0x50, 0x1D, 0x0A, 0x80, 0xC3, 0x00, 0x9D, 0x01, 0x77, 0x50, 0x4D, 0x07, 0x80, 0xC3,
  0x00, 0xCC, 0x0D, 0x77, 0x60, 0x7D, 0x04, 0x80, 0xC3, 0x0D, 0x0A, 0x77, 0x60, 0xAD, 0x01, 0x80,
  0xC2, 0x00, 0x3D, 0x07, 0x77, 0x60, 0xDC, 0x0E, 0x80, 0xC3, 0x00, 0x6D, 0x04, 0x77, 0x6D, 0x0B,
  0x77, 0x71, 0x0A, 0x80, 0x94, 0xB0, 0xDD, 0x0C, 0x80, 0x97, 0xB0, 0xCD, 0x0D, 0x80, 0x94, 0xB0,
  0x95, 0x0D, 0x80, 0xF5, 0xF0, 0xD5, 0x0D, 0x80, 0xF5, 0xF0, 0xD5, 0x0D, 0x80, 0xF5, 0xF0, 0xD5,
  0x0D, 0x80, 0xF5, 0xF0, 0xD5, 0x0B, 0x80, 0x93, 0xD0, 0xED, 0x80, 0xA0, 0xD0, 0xED, 0x0E, 0x80,
  0x95, 0xD0, 0xB7, 0x77, 0x0A, 0xD0, 0x17, 0x75, 0x06, 0xD0, 0x58, 0x0C, 0x30, 0x0D, 0xC0, 0xD7,
  0x76, 0x09, 0xD0, 0x28, 0x0C, 0x20, 0x01, 0xD0, 0xA7, 0x76, 0x0C, 0xC0, 0xE8, 0x0C, 0x30, 0x03,
  0xD0, 0x77, 0x76, 0xD0, 0xB8, 0x0C, 0x30, 0x06, 0xD0, 0x47, 0x75, 0x03, 0xD0, 0x88, 0x0C, 0x30,
  0x09, 0xD0, 0x17, 0x75, 0x06, 0xD0, 0x58, 0x0C, 0x30, 0x0C, 0xC0, 0xE7, 0x76, 0x09, 0xD0, 0x28,
  0x0C, 0x30, 0xD0, 0xB7, 0x76, 0x0C, 0xC0, 0xE8, 0x0C, 0x30, 0x03, 0xD0, 0x87, 0x76, 0xD0, 0xB8,
  0x0C, 0x30, 0x05, 0xD0, 0x57, 0x75, 0x02, 0xD0, 0x88, 0x0C, 0x30, 0x08, 0xD0, 0x27, 0x75, 0x05,
  0xD0, 0x58, 0x0C, 0x30, 0x0B, 0xC0, 0xE7, 0x76, 0x08, 0xD0, 0x28, 0x0C, 0x30, 0x0E, 0xC0, 0xB7,
  0x76, 0x0C, 0xC0, 0xE8, 0x0C, 0x30, 0x02, 0xD0, 0x87, 0x76, 0x0E, 0xC0, 0xC8, 0x0C, 0x30, 0x04,
  0xD0, 0x57, 0x75, 0x02, 0xD0, 0x98, 0x0C, 0x30, 0x07, 0xD0, 0x27, 0x75, 0x05, 0xD0, 0x68, 0x0C,
  0x30, 0x0A, 0xD7, 0x76, 0x08, 0xD0, 0x28, 0x0C, 0x30, 0x0D, 0xC0, 0xC7, 0x76, 0x0B, 0xD8, 0x0C,
  0x30, 0x01, 0xD0, 0x97, 0x76, 0x0E, 0xC0, 0xC8, 0x0C, 0x30, 0x04, 0xD0, 0x67, 0x75, 0x02, 0xD0,
  0x98, 0x0C, 0x30, 0x06, 0xD0, 0x37, 0x75, 0x05, 0xD0, 0x68, 0x0C, 0x30, 0x09, 0xD7, 0x76, 0x08,
  0xD0, 0x38, 0x0C, 0x30, 0x0C, 0xC0, 0xC7, 0x76, 0x0B, 0xD8, 0x0C, 0x40, 0xD0, 0x97, 0x76, 0x0E,
  0xC0, 0xC8, 0x0C, 0x30, 0x03, 0xD0, 0x67, 0x75, 0x02, 0xD0, 0x98, 0x0C, 0x30, 0x06, 0xD0, 0x37,
  0x75, 0x05, 0xD0, 0x67, 0x77, 0x70,
  // "$" (U+0024)
  0x77, 0x72, 0x80, 0x21, 0x80, 0xD2, 0x00, 0x9C, 0x09, 0x80, 0xD2, 0x00, 0x9C, 0x09, 0x80, 0xD2,
  0x00, 0x9C, 0x09, 0x80, 0xD2, 0x00, 0x9C, 0x09, 0x80, 0xD2, 0x00, 0x9C, 0x09, 0x80, 0xD2, 0x00,
  0x9C, 0x09, 0x80, 0xD2, 0x00, 0x9C, 0x09, 0x80, 0xD2, 0x00, 0x9C, 0x09, 0x80, 0xC6, 0x08, 0x32,
  0x45, 0x7C, 0xC8, 0x5C, 0x77, 0x54, 0x31, 0x77, 0x77, 0x48, 0x23, 0x8B, 0xEF, 0xFA, 0x83, 0xEC,
  0x96, 0x37, 0x77, 0x38, 0x13, 0x9E, 0xFF, 0xFC, 0x82, 0xEB, 0x72, 0x77, 0x40, 0x30, 0xBF, 0xFF,
  0xFC, 0x81, 0xD7, 0x27, 0x60, 0x10, 0xA8, 0x0C, 0x1F, 0x0B, 0x04, 0x73, 0x05, 0x0E, 0x80, 0xC3,
  0xF0, 0xA7, 0x20, 0x8F, 0xF8, 0x1D, 0xBE, 0xC8, 0x4C, 0x79, 0xAC, 0xEF, 0xF0, 0x47, 0x10, 0x9F,
  0xB8, 0x2D, 0x95, 0x23, 0x09, 0xC0, 0x95, 0x82, 0x24, 0x8B, 0xFA, 0x0D, 0x71, 0x07, 0xFA, 0x0A,
  0x04, 0x70, 0x9C, 0x09, 0x73, 0x81, 0x48, 0xDD, 0x08, 0x70, 0x4F, 0x90, 0xC0, 0x37, 0x20, 0x9C,
  0x09, 0x76, 0x81, 0x28, 0xDA, 0x02, 0x70, 0xDF, 0x08, 0x74, 0x09, 0xC0, 0x97, 0x72, 0x04, 0x08,
  0x70, 0x7F, 0x06, 0x75, 0x09, 0xC0, 0x97, 0x77, 0x40, 0xEE, 0x08, 0x76, 0x09, 0xC0, 0x97, 0x77,
  0x30, 0x5E, 0x0D, 0x77, 0x09, 0xC0, 0x97, 0x77, 0x30, 0xAE, 0x05, 0x77, 0x09, 0xC0, 0x97, 0x77,
  0x30, 0xDD, 0x0E, 0x77, 0x10, 0x9C, 0x09, 0x77, 0x72, 0x01, 0xE0, 0xA7, 0x71, 0x09, 0xC0, 0x97,
  0x77, 0x20, 0x3E, 0x07, 0x77, 0x10, 0x9C, 0x09, 0x77, 0x72, 0x05, 0xE0, 0x57, 0x71, 0x09, 0xC0,
  0x97, 0x77, 0x20, 0x6E, 0x04, 0x77, 0x10, 0x9C, 0x09, 0x77, 0x72, 0x06, 0xE0, 0x47, 0x71, 0x09,
  0xC0, 0x97, 0x77, 0x20, 0x6E, 0x05, 0x77, 0x10, 0x9C, 0x09, 0x77, 0x72, 0x05, 0xE0, 0x77, 0x71,
  0x09, 0xC0, 0x97, 0x77, 0x20, 0x3E, 0x0A, 0x77, 0x10, 0x9C, 0x09, 0x77, 0x72, 0x01, 0xE0, 0xE7,
  0x71, 0x09, 0xC0, 0x97, 0x77, 0x30, 0xDE, 0x05, 0x77, 0x09, 0xC0, 0x97, 0x77, 0x30, 0x8E, 0x0D,
  0x77, 0x09, 0xC0, 0x97, 0x77, 0x30, 0x3F, 0x07, 0x76, 0x09, 0xC0, 0x97, 0x77, 0x40, 0xCF, 0x05,
  0x75, 0x09, 0xC0, 0x97, 0x77, 0x40, 0x4F, 0x90, 0x77, 0x40, 0x9C, 0x09, 0x77, 0x75, 0x0A, 0xF9,
  0x0C, 0x02, 0x72, 0x09, 0xC0, 0x97, 0x77, 0x60, 0xDF, 0xA0, 0x80, 0x17, 0x09, 0xC0, 0x97, 0x77,
  0x60, 0x20, 0xEF, 0xA8, 0x1E, 0x71, 0x50, 0x9C, 0x09, 0x77, 0x77, 0x02, 0x0D, 0xFB, 0x81, 0xE9,
  0x23, 0x09, 0xC0, 0x97, 0x77, 0x71, 0x01, 0x0C, 0xFD, 0x82, 0xC6, 0x19, 0xC0, 0x97, 0x77, 0x73,
  0x08, 0xFF, 0x0E, 0xC0, 0x97, 0x77, 0x74, 0x03, 0x0C, 0xFF, 0xB0, 0x97, 0x77, 0x76, 0x05, 0x0D,
  0xFF, 0x98, 0x1E, 0x83, 0x77, 0x77, 0x60, 0x50, 0xCF, 0xFA, 0x81, 0xD7, 0x17, 0x77, 0x75, 0x04,
  0x0A, 0xFF, 0xB0, 0xB0, 0x57, 0x77, 0x75, 0x81, 0x17, 0xDF, 0xFA, 0x81, 0xE8, 0x17, 0x77, 0x75,
  0x81, 0x38, 0xDF, 0xFA, 0x09, 0x02, 0x77, 0x77, 0x60, 0xAF, 0xFB, 0x0A, 0x02, 0x77, 0x77, 0x40,
  0x9F, 0xFD, 0x08, 0x77, 0x77, 0x30, 0x9C, 0x82, 0xA4, 0x9E, 0xFD, 0x0C, 0x02, 0x77, 0x77, 0x10,
  0x9C, 0x09, 0x30, 0x50, 0xBF, 0xD0, 0x57, 0x77, 0x70, 0x9C, 0x09, 0x50, 0x20, 0x9F, 0xC0, 0x57,
  0x77, 0x60, 0x9C, 0x09, 0x70, 0x10, 0x8F, 0xB0, 0x47, 0x77, 0x50, 0x9C, 0x09, 0x72, 0x01, 0x0A,
  0xF9, 0x0E, 0x02, 0x77, 0x74, 0x09, 0xC0, 0x97, 0x40, 0x40, 0xEF, 0x0C, 0x77, 0x74, 0x09, 0xC0,
  0x97, 0x50, 0x20, 0xDF, 0x05, 0x77, 0x73, 0x09, 0xC0, 0x97, 0x60, 0x10, 0xEE, 0x0C, 0x77, 0x73,
  0x09, 0xC0, 0x97, 0x70, 0x5F, 0x02, 0x77, 0x72, 0x09, 0xC0, 0x97, 0x71, 0x0C, 0xE0, 0x67, 0x77,
  0x20, 0x9C, 0x09, 0x77, 0x10, 0x6E, 0x0A, 0x77, 0x72, 0x09, 0xC0, 0x97, 0x71, 0x01, 0xE0, 0xC7,
  0x77, 0x20, 0x9C, 0x09, 0x77, 0x20, 0xDD, 0x0E, 0x77, 0x72, 0x09, 0xC0, 0x97, 0x72, 0x0B, 0xE7,
  0x77, 0x20, 0x9C, 0x09, 0x77, 0x20, 0xBE, 0x77, 0x72, 0x09, 0xC0, 0x97, 0x72, 0x0B, 0xE7, 0x77,
  0x20, 0x9C, 0x09, 0x77, 0x20, 0xBD, 0x0E, 0x77, 0x72, 0x09, 0xC0, 0x97, 0x72, 0x0D, 0xD0, 0xD7,
  0x77, 0x20, 0x9C, 0x09, 0x77, 0x10, 0x1E, 0x0B, 0x77, 0x72, 0x09, 0xC0, 0x97, 0x71, 0x05, 0xE0,
  0x87, 0x77, 0x20, 0x9C, 0x09, 0x77, 0x10, 0xBE, 0x04, 0x77, 0x72, 0x09, 0xC0, 0x97, 0x70, 0x3E,
  0x0E, 0x77, 0x73, 0x09, 0xC0, 0x97, 0x70, 0xCE, 0x09, 0x77, 0x73, 0x09, 0xC0, 0x97, 0x60, 0x9F,
  0x02, 0x77, 0x73, 0x09, 0xC0, 0x97, 0x50, 0x9F, 0x09, 0x28, 0x14, 0xB5, 0x77, 0x60, 0x9C, 0x09,
  0x73, 0x01, 0x0B, 0xF0, 0xE0, 0x12, 0x04, 0xB8, 0x1A, 0x51, 0x77, 0x20, 0x9C, 0x09, 0x71, 0x81,
  0x17, 0xEF, 0x90, 0x43, 0x04, 0xE8, 0x2D, 0x95, 0x17, 0x50, 0x9C, 0x09, 0x68, 0x13, 0x9E, 0xFA,
  0x06, 0x40, 0x4F, 0xB8, 0x4E, 0xB8, 0x53, 0x16, 0x09, 0xC8, 0x59, 0x02, 0x47, 0xAE, 0xFC, 0x06,
  0x50, 0x4F, 0xFB, 0x84, 0xDC, 0xBA, 0x9D, 0xFF, 0xE0, 0xE0, 0x46, 0x04, 0x80, 0xC6, 0xF0, 0xB0,
  0x17, 0x04, 0x80, 0xC4, 0xF0, 0xD0, 0x57, 0x38, 0x11, 0x7B, 0xFF, 0xFF, 0xF0, 0xC0, 0x57, 0x71,
  0x82, 0x15, 0x9C, 0xFF, 0xFF, 0x81, 0xD8, 0x37, 0x77, 0x18, 0x43, 0x68, 0xAD, 0xEF, 0xFA, 0x83,
  0xEC, 0x96, 0x27, 0x77, 0x73, 0x87, 0x12, 0x34, 0x55, 0x77, 0xCC, 0x81, 0xB2, 0x18, 0x0D, 0x00,
  0x09, 0xC0, 0x98, 0x0D, 0x20, 0x09, 0xC0, 0x98, 0x0D, 0x20, 0x09, 0xC0, 0x98, 0x0D, 0x20, 0x09,
  0xC0, 0x98, 0x0D, 0x20, 0x09, 0xC0, 0x98, 0x0D, 0x20, 0x09, 0xC0, 0x98, 0x0D, 0x20, 0x09, 0xC0,
  0x98, 0x0D, 0x20, 0x09, 0xC0, 0x98, 0x0D, 0x20, 0x09, 0xC0, 0x98, 0x0D, 0x20, 0x09, 0xC0, 0x97,
  0x77, 0x20,
  // "%" (U+0025)
  0x75, 0x89, 0x11, 0x69, 0xBC, 0xDC, 0xB9, 0x62, 0x80, 0x98, 0x40, 0x05, 0x0C, 0xFC, 0x0C, 0x05,
  0x80, 0xC2, 0x00, 0x98, 0x01, 0xB0, 0x47, 0x77, 0x20, 0x20, 0xBF, 0xF9, 0x0C, 0x02, 0x77, 0x77,
  0x70, 0x4D, 0x0D, 0x77, 0x72, 0x04, 0x0E, 0xFF, 0xB0, 0xE0, 0x57, 0x77, 0x76, 0x0C, 0xD0, 0x57,
  0x77, 0x10, 0x4F, 0xFF, 0x05, 0x77, 0x77, 0x40, 0x6D, 0x0C, 0x77, 0x71, 0x02, 0x0E, 0xF8, 0x5D,
  0x97, 0x57, 0x9D, 0xF9, 0x03, 0x77, 0x77, 0x30, 0xED, 0x04, 0x77, 0x71, 0x0C, 0xE0, 0xD0, 0x47,
  0x03, 0x0B, 0xE0, 0xD7, 0x77, 0x72, 0x08, 0xD0, 0xB7, 0x77, 0x10, 0x7E, 0x0A, 0x74, 0x08, 0xE0,
  0x97, 0x77, 0x70, 0x10, 0xED, 0x02, 0x77, 0x70, 0x10, 0xED, 0x0B, 0x76, 0x08, 0xE0, 0x27, 0x77,
  0x60, 0x9D, 0x09, 0x77, 0x71, 0x08, 0xD0, 0xE0, 0x17, 0x70, 0xCD, 0x09, 0x77, 0x75, 0x02, 0xD0,
  0xE0, 0x17, 0x77, 0x10, 0xED, 0x06, 0x77, 0x10, 0x3E, 0x01, 0x77, 0x74, 0x0B, 0xD0, 0x77, 0x77,
  0x10, 0x5D, 0x0D, 0x77, 0x30, 0xBD, 0x06, 0x77, 0x73, 0x04, 0xD0, 0xD7, 0x77, 0x20, 0xAD, 0x07,
  0x77, 0x30, 0x4D, 0x0C, 0x77, 0x73, 0x0C, 0xD0, 0x67, 0x77, 0x20, 0xED, 0x02, 0x77, 0x40, 0xED,
  0x01, 0x77, 0x71, 0x06, 0xD0, 0xC7, 0x77, 0x20, 0x3D, 0x0D, 0x77, 0x50, 0xAD, 0x05, 0x77, 0x71,
  0x0E, 0xD0, 0x47, 0x77, 0x20, 0x7D, 0x09, 0x77, 0x50, 0x6D, 0x09, 0x77, 0x70, 0x7D, 0x0B, 0x77,
  0x73, 0x09, 0xD0, 0x57, 0x75, 0x03, 0xD0, 0xC7, 0x76, 0x01, 0x0E, 0xD0, 0x27, 0x77, 0x30, 0xCD,
  0x02, 0x77, 0x6D, 0x0E, 0x77, 0x60, 0x9D, 0x09, 0x77, 0x74, 0xE7, 0x77, 0x0D, 0xD0, 0x27, 0x74,
  0x02, 0xD0, 0xE0, 0x17, 0x77, 0x30, 0x1D, 0x0D, 0x77, 0x70, 0xBD, 0x03, 0x77, 0x40, 0xBD, 0x07,
  0x77, 0x74, 0x03, 0xD0, 0xC7, 0x77, 0x09, 0xD0, 0x57, 0x73, 0x04, 0xD0, 0xE7, 0x77, 0x50, 0x4D,
  0x0A, 0x77, 0x70, 0x8D, 0x07, 0x77, 0x30, 0xCD, 0x06, 0x77, 0x75, 0x05, 0xD0, 0x97, 0x77, 0x07,
  0xD0, 0x87, 0x72, 0x06, 0xD0, 0xC7, 0x77, 0x60, 0x6D, 0x08, 0x77, 0x70, 0x6D, 0x09, 0x77, 0x20,
  0xDD, 0x04, 0x77, 0x76, 0x07, 0xD0, 0x87, 0x77, 0x05, 0xD0, 0x97, 0x71, 0x07, 0xD0, 0xB7, 0x77,
  0x70, 0x7D, 0x07, 0x77, 0x70, 0x5D, 0x0A, 0x77, 0x01, 0x0E, 0xD0, 0x27, 0x77, 0x70, 0x7D, 0x07,
  0x77, 0x70, 0x4D, 0x0A, 0x77, 0x09, 0xD0, 0x97, 0x77, 0x71, 0x07, 0xD0, 0x77, 0x77, 0x05, 0xD0,
  0xA7, 0x60, 0x2D, 0x0E, 0x01, 0x77, 0x77, 0x10, 0x7D, 0x07, 0x77, 0x70, 0x5D, 0x0A, 0x76, 0x0B,
  0xD0, 0x87, 0x77, 0x72, 0x07, 0xD0, 0x87, 0x77, 0x05, 0xD0, 0x97, 0x50, 0x4D, 0x0E, 0x77, 0x77,
  0x30, 0x6D, 0x08, 0x77, 0x70, 0x6D, 0x09, 0x75, 0x0C, 0xD0, 0x67, 0x77, 0x73, 0x05, 0xD0, 0x97,
  0x77, 0x07, 0xD0, 0x87, 0x40, 0x5D, 0x0D, 0x77, 0x77, 0x40, 0x4D, 0x0A, 0x77, 0x70, 0x8D, 0x06,
  0x74, 0x0D, 0xD0, 0x47, 0x77, 0x74, 0x02, 0xD0, 0xC7, 0x77, 0x09, 0xD0, 0x57, 0x30, 0x7D, 0x0B,
  0x77, 0x77, 0x50, 0x1D, 0x0D, 0x77, 0x70, 0xBD, 0x03, 0x72, 0x01, 0x0E, 0xD0, 0x37, 0x58, 0x63,
  0x67, 0x77, 0x75, 0x27, 0x70, 0xED, 0x77, 0x70, 0xDD, 0x01, 0x72, 0x09, 0xD0, 0x97, 0x30, 0x50,
  0xBF, 0xA8, 0x1E, 0x92, 0x74, 0x0C, 0xD0, 0x37, 0x76, 0xD0, 0xE7, 0x20, 0x2D, 0x0E, 0x01, 0x71,
  0x04, 0x0D, 0xFF, 0x0A, 0x01, 0x72, 0x09, 0xD0, 0x67, 0x75, 0x03, 0xD0, 0xB7, 0x20, 0xAD, 0x08,
  0x71, 0x08, 0xFF, 0xB0, 0xE0, 0x47, 0x10, 0x6D, 0x09, 0x77, 0x50, 0x7D, 0x08, 0x71, 0x04, 0xD0,
  0xE7, 0x10, 0xAF, 0xFE, 0x05, 0x70, 0x2D, 0x0D, 0x77, 0x50, 0xBD, 0x04, 0x71, 0x0C, 0xD0, 0x67,
  0x09, 0xFA, 0x82, 0xCB, 0xBD, 0xFA, 0x03, 0x70, 0xDD, 0x02, 0x77, 0x30, 0x1E, 0x01, 0x70, 0x5D,
  0x0D, 0x70, 0x5F, 0x0B, 0x04, 0x58, 0x11, 0x6D, 0xE0, 0xE0, 0x16, 0x09, 0xD0, 0x77, 0x73, 0x06,
  0xD0, 0xB7, 0x10, 0xDD, 0x04, 0x60, 0x10, 0xEE, 0x06, 0x73, 0x09, 0xE0, 0xA6, 0x03, 0xD0, 0xD7,
  0x73, 0x0C, 0xD0, 0x67, 0x07, 0xD0, 0xB7, 0x09, 0xE0, 0x57, 0x50, 0x8E, 0x03, 0x60, 0xDD, 0x06,
  0x77, 0x10, 0x5D, 0x0E, 0x01, 0x60, 0x10, 0xED, 0x03, 0x60, 0x1E, 0x07, 0x77, 0x0B, 0xD0, 0xB6,
  0x06, 0xD0, 0xE0, 0x17, 0x60, 0x10, 0xDD, 0x09, 0x70, 0x9D, 0x09, 0x70, 0x8D, 0x0D, 0x77, 0x10,
  0x2E, 0x03, 0x60, 0xDD, 0x0B, 0x76, 0x0A, 0xE0, 0x16, 0x02, 0xE0, 0x17, 0x0E, 0xD0, 0x57, 0x72,
  0x09, 0xD0, 0x96, 0x05, 0xE0, 0xA7, 0x40, 0xAE, 0x08, 0x70, 0xAD, 0x08, 0x70, 0x4D, 0x0D, 0x77,
  0x30, 0x2D, 0x0E, 0x70, 0xBE, 0x0D, 0x04, 0x70, 0x40, 0xDE, 0x0D, 0x70, 0x3D, 0x0E, 0x71, 0x09,
  0xD0, 0x87, 0x74, 0x0C, 0xD0, 0x46, 0x01, 0x0D, 0xF8, 0x5D, 0x97, 0x57, 0x9D, 0xF0, 0xE0, 0x37,
  0x0C, 0xD0, 0x67, 0x10, 0xDD, 0x03, 0x77, 0x40, 0x7D, 0x08, 0x70, 0x20, 0xEF, 0xFE, 0x04, 0x70,
  0x5D, 0x0D, 0x71, 0x01, 0xD0, 0xE7, 0x75, 0x03, 0xD0, 0xC7, 0x10, 0x30, 0xDF, 0xFB, 0x0E, 0x04,
  0x71, 0x0D, 0xD0, 0x47, 0x10, 0x4D, 0x0B, 0x77, 0x6E, 0x72, 0x01, 0x0A, 0xFF, 0x90, 0xB0, 0x27,
  0x10, 0x7D, 0x0B, 0x72, 0x07, 0xD0, 0x87, 0x76, 0x0C, 0xD0, 0x27, 0x30, 0x40, 0xBF, 0xC0, 0xB0,
  0x47, 0x20, 0x10, 0xED, 0x03, 0x72, 0x0A, 0xD0, 0x57, 0x76, 0x09, 0xD0, 0x57, 0x58, 0x91, 0x16,
  0x9B, 0xDD, 0xCB, 0x96, 0x17, 0x40, 0x9D, 0x0A, 0x73, 0x0C, 0xD0, 0x37, 0x76, 0x07, 0xD0, 0x77,
  0x77, 0x75, 0x02, 0xE0, 0x17, 0x30, 0xDD, 0x01, 0x77, 0x60, 0x5D, 0x09, 0x77, 0x77, 0x50, 0xAD,
  0x08, 0x74, 0xE7, 0x77, 0x04, 0xD0, 0xA7, 0x77, 0x74, 0x03, 0xD0, 0xE0, 0x17, 0x30, 0x1D, 0x0E,
  0x77, 0x70, 0x3D, 0x0C, 0x77, 0x77, 0x40, 0xCD, 0x06, 0x74, 0x02, 0xD0, 0xD7, 0x77, 0x02, 0xD0,
  0xD7, 0x77, 0x73, 0x05, 0xD0, 0xD7, 0x50, 0x2D, 0x0C, 0x77, 0x70, 0x1D, 0x0D, 0x77, 0x77, 0x30,
  0xDD, 0x05, 0x75, 0x03, 0xD0, 0xC7, 0x77, 0x01, 0xD0, 0xE7, 0x77, 0x72, 0x07, 0xD0, 0xB7, 0x60,
  0x3D, 0x0C, 0x77, 0x71, 0xD0, 0xE7, 0x77, 0x71, 0x01, 0x0E, 0xD0, 0x37, 0x60, 0x3D, 0x0B, 0x77,
  0x71, 0xD0, 0xE7, 0x77, 0x71, 0x08, 0xD0, 0xA7, 0x70, 0x3D, 0x0C, 0x77, 0x70, 0x1D, 0x0E, 0x77,
  0x77, 0x02, 0xE0, 0x27, 0x70, 0x2D, 0x0C, 0x77, 0x70, 0x1D, 0x0D, 0x77, 0x77, 0x0A, 0xD0, 0x87,
  0x71, 0x02, 0xD0, 0xD7, 0x77, 0x01, 0xD0, 0xD7, 0x77, 0x60, 0x3D, 0x0E, 0x01, 0x77, 0x10, 0x1D,
  0x0D, 0x77, 0x70, 0x2D, 0x0C, 0x77, 0x76, 0x0C, 0xD0, 0x67, 0x73, 0xD0, 0xE7, 0x77, 0x03, 0xD0,
  0xB7, 0x77, 0x50, 0x5D, 0x0D, 0x77, 0x40, 0xED, 0x77, 0x70, 0x5D, 0x0A, 0x77, 0x75, 0x0D, 0xD0,
  0x57, 0x74, 0x0C, 0xD0, 0x27, 0x76, 0x06, 0xD0, 0x87, 0x77, 0x40, 0x7D, 0x0C, 0x77, 0x50, 0xAD,
  0x04, 0x77, 0x60, 0x8D, 0x06, 0x77, 0x73, 0x01, 0x0E, 0xD0, 0x37, 0x75, 0x08, 0xD0, 0x67, 0x76,
  0x0B, 0xD0, 0x47, 0x77, 0x30, 0x8D, 0x0A, 0x77, 0x60, 0x5D, 0x09, 0x77, 0x60, 0xED, 0x01, 0x77,
  0x72, 0x02, 0xE0, 0x27, 0x76, 0x03, 0xD0, 0xC7, 0x75, 0x01, 0xD0, 0xD7, 0x77, 0x30, 0xAD, 0x08,
  0x77, 0x71, 0x0E, 0xD0, 0x17, 0x74, 0x05, 0xD0, 0xA7, 0x77, 0x20, 0x3D, 0x0E, 0x01, 0x77, 0x71,
  0x0B, 0xD0, 0x57, 0x74, 0x0A, 0xD0, 0x67, 0x77, 0x20, 0xCD, 0x07, 0x77, 0x72, 0x06, 0xD0, 0xA7,
  0x74, 0x0E, 0xD0, 0x17, 0x77, 0x10, 0x5D, 0x0D, 0x77, 0x73, 0x01, 0xE0, 0x17, 0x72, 0x06, 0xD0,
  0xB7, 0x77, 0x20, 0xDD, 0x05, 0x77, 0x74, 0x0B, 0xD0, 0x77, 0x72, 0x0D, 0xD0, 0x67, 0x77, 0x10,
  0x6D, 0x0C, 0x77, 0x75, 0x05, 0xD0, 0xE0, 0x17, 0x70, 0x7D, 0x0E, 0x77, 0x71, 0x01, 0x0E, 0xD0,
  0x37, 0x77, 0x60, 0xDD, 0x0B, 0x76, 0x03, 0xE0, 0x77, 0x77, 0x10, 0x8D, 0x0A, 0x77, 0x77, 0x05,
  0xE0, 0x97, 0x40, 0x20, 0xED, 0x0D, 0x77, 0x71, 0x02, 0xE0, 0x27, 0x77, 0x71, 0x0B, 0xE0, 0xB0,
  0x27, 0x10, 0x60, 0xEE, 0x05, 0x77, 0x71, 0x0A, 0xD0, 0x87, 0x77, 0x72, 0x01, 0x0E, 0xF8, 0x6A,
  0x52, 0x11, 0x37, 0xDF, 0x09, 0x77, 0x71, 0x03, 0xD0, 0xE0, 0x17, 0x77, 0x73, 0x03, 0xFF, 0xF0,
  0xB7, 0x77, 0x20, 0xBD, 0x07, 0x77, 0x77, 0x50, 0x40, 0xEF, 0xFC, 0x0B, 0x77, 0x72, 0x05, 0xD0,
  0xD7, 0x77, 0x77, 0x03, 0x0D, 0xFF, 0xA0, 0x87, 0x77, 0x30, 0xDD, 0x05, 0x80, 0xC1, 0x00, 0x70,
  0xEF, 0xD0, 0xB0, 0x38, 0x09, 0x83, 0x08, 0x15, 0xAD, 0xD8, 0x2E, 0xC7, 0x28, 0x09, 0x90, 0x08,
  0x31, 0x13, 0x11, 0x77, 0x10,
  // "&" (U+0026)
  0x77, 0x71, 0x84, 0x36, 0x9B, 0xDE, 0xB8, 0x4E, 0xCB, 0x85, 0x18, 0x0E, 0x70, 0x81, 0x39, 0xEF,
  0xF9, 0x0C, 0x06, 0x80, 0xE3, 0x00, 0x40, 0xCF, 0xFE, 0x0E, 0x07, 0x80, 0xD7, 0x00, 0x10, 0xAF,
  0xFF, 0xB0, 0xD0, 0x38, 0x0D, 0x40, 0x03, 0x0E, 0xFF, 0xFE, 0x06, 0x80, 0xD2, 0x00, 0x4F, 0xE0,
  0xE0, 0xFD, 0xFE, 0x07, 0x80, 0xD0, 0x00, 0x4F, 0xB8, 0x1B, 0x73, 0x68, 0x22, 0x5A, 0xEF, 0xA0,
  0x68, 0x0C, 0x60, 0x02, 0x0E, 0xF9, 0x09, 0x02, 0x75, 0x81, 0x17, 0xEF, 0x90, 0x38, 0x0C, 0x50,
  0x0B, 0xF0, 0xD0, 0x37, 0x72, 0x02, 0x0C, 0xF0, 0xC8, 0x0C, 0x40, 0x05, 0xF0, 0xB0, 0x17, 0x75,
  0x0B, 0xF0, 0x58, 0x0C, 0x30, 0x0C, 0xE0, 0xC7, 0x77, 0x10, 0xDE, 0x0C, 0x80, 0xC2, 0x00, 0x3F,
  0x02, 0x77, 0x71, 0x03, 0xF0, 0x28, 0x0C, 0x10, 0x09, 0xE0, 0x87, 0x77, 0x30, 0xAE, 0x07, 0x80,
  0xC1, 0x00, 0xDE, 0x02, 0x77, 0x73, 0x04, 0xE0, 0xB8, 0x0C, 0x00, 0x01, 0xE0, 0xC7, 0x77, 0x50,
  0xED, 0x0D, 0x80, 0xC0, 0x00, 0x3E, 0x08, 0x77, 0x75, 0x0B, 0xE8, 0x0C, 0x00, 0x05, 0xE0, 0x67,
  0x77, 0x50, 0x9E, 0x01, 0x77, 0x77, 0x70, 0x5E, 0x05, 0x77, 0x75, 0x08, 0xE0, 0x27, 0x77, 0x77,
  0x06, 0xE0, 0x57, 0x77, 0x50, 0x9E, 0x02, 0x77, 0x77, 0x70, 0x5E, 0x06, 0x77, 0x75, 0x0A, 0xE0,
  0x17, 0x77, 0x77, 0x04, 0xE0, 0x77, 0x77, 0x50, 0xCE, 0x80, 0xC0, 0x00, 0x2E, 0x0A, 0x77, 0x75,
  0x0E, 0xD0, 0xD8, 0x0C, 0x10, 0xE0, 0xD7, 0x77, 0x40, 0x4E, 0x09, 0x80, 0xC1, 0x00, 0xCE, 0x03,
  0x77, 0x73, 0x09, 0xE0, 0x68, 0x0C, 0x10, 0x07, 0xE0, 0x97, 0x77, 0x20, 0x1F, 0x01, 0x80, 0xC1,
  0x00, 0x2E, 0x0E, 0x01, 0x77, 0x71, 0x09, 0xE0, 0xA8, 0x0C, 0x30, 0x0B, 0xE0, 0xA7, 0x77, 0x04,
  0xF0, 0x38, 0x0C, 0x30, 0x04, 0xF0, 0x47, 0x75, 0x02, 0x0E, 0xE0, 0xA8, 0x0C, 0x50, 0x0B, 0xE0,
  0xE0, 0x17, 0x73, 0x02, 0x0E, 0xE0, 0xE0, 0x18, 0x0C, 0x50, 0x02, 0x0E, 0xE0, 0xB7, 0x72, 0x03,
  0x0E, 0xF0, 0x48, 0x0C, 0x70, 0x06, 0xF0, 0x87, 0x70, 0x6F, 0x90, 0x68, 0x0D, 0x10, 0x0A, 0xF0,
  0x57, 0x50, 0xAF, 0x90, 0x68, 0x0D, 0x30, 0x0D, 0xF0, 0x37, 0x20, 0x40, 0xDF, 0x90, 0x58, 0x0D,
  0x40, 0x02, 0x0E, 0xE0, 0xE0, 0x26, 0x01, 0x09, 0xF9, 0x0E, 0x04, 0x80, 0xD6, 0x00, 0x5F, 0x0D,
  0x01, 0x40, 0x60, 0xEF, 0x90, 0xC0, 0x28, 0x0E, 0x00, 0x07, 0xF8, 0x3D, 0x10, 0x5D, 0xFA, 0x09,
  0x80, 0xE3, 0x00, 0x9F, 0x00, 0xCF, 0xA0, 0xE0, 0x58, 0x0E, 0x50, 0x0A, 0xFF, 0xA0, 0xA0, 0x18,
  0x0E, 0x70, 0x0B, 0xFE, 0x0D, 0x05, 0x80, 0xF1, 0x00, 0x3F, 0xC0, 0xE0, 0x78, 0x0F, 0x10, 0x01,
  0x09, 0xFC, 0x0C, 0x01, 0x80, 0xF1, 0x00, 0x70, 0xEF, 0xE0, 0x48, 0x0E, 0x70, 0x04, 0x0D, 0xFF,
  0xA0, 0x48, 0x0E, 0x40, 0x01, 0x0A, 0xFF, 0xD0, 0x48, 0x0E, 0x20, 0x05, 0x0E, 0xFA, 0x82, 0xE6,
  0x2D, 0xF9, 0x04, 0x80, 0xE0, 0x00, 0x9F, 0xB0, 0x83, 0x01, 0x0D, 0xF9, 0x04, 0x80, 0xD5, 0x00,
  0x20, 0xDF, 0xA0, 0xA0, 0x25, 0x01, 0x0D, 0xF9, 0x05, 0x77, 0x77, 0x10, 0xEE, 0x74, 0x04, 0x0E,
  0xF9, 0x0D, 0x04, 0x71, 0x01, 0x0D, 0xF9, 0x05, 0x77, 0x76, 0x03, 0xE0, 0xB7, 0x30, 0x4F, 0xA0,
  0x97, 0x40, 0x10, 0xDF, 0x90, 0x57, 0x77, 0x50, 0x7E, 0x07, 0x72, 0x04, 0xF9, 0x0E, 0x04, 0x76,
  0x01, 0x0D, 0xF9, 0x05, 0x77, 0x74, 0x0B, 0xE0, 0x37, 0x10, 0x20, 0xEF, 0x0C, 0x01, 0x77, 0x10,
  0x10, 0xDF, 0x90, 0x57, 0x77, 0x20, 0x1E, 0x0D, 0x72, 0x0D, 0xF0, 0xB7, 0x74, 0x01, 0x0D, 0xF9,
  0x05, 0x77, 0x71, 0x05, 0xE0, 0x97, 0x10, 0x9F, 0x0B, 0x77, 0x60, 0x10, 0xDF, 0x90, 0x57, 0x77,
  0x0A, 0xE0, 0x47, 0x03, 0xF0, 0xC7, 0x77, 0x10, 0x10, 0xDF, 0x90, 0x57, 0x75, 0x01, 0xE0, 0xE7,
  0x10, 0xCE, 0x0E, 0x02, 0x77, 0x72, 0x01, 0x0D, 0xF9, 0x06, 0x77, 0x40, 0x6E, 0x08, 0x70, 0x4F,
  0x06, 0x77, 0x74, 0x01, 0x0D, 0xF9, 0x06, 0x77, 0x30, 0xDE, 0x02, 0x70, 0xAE, 0x0D, 0x77, 0x76,
  0x01, 0x0C, 0xF9, 0x06, 0x77, 0x10, 0x4E, 0x0C, 0x71, 0x0E, 0xE0, 0x67, 0x77, 0x70, 0x10, 0xCF,
  0x90, 0x67, 0x70, 0xBE, 0x05, 0x70, 0x4F, 0x77, 0x77, 0x20, 0x10, 0xCF, 0x90, 0x67, 0x50, 0x3E,
  0x0D, 0x71, 0x07, 0xE0, 0xB7, 0x77, 0x73, 0x01, 0x0C, 0xF9, 0x06, 0x74, 0x0A, 0xE0, 0x67, 0x10,
  0xAE, 0x07, 0x77, 0x77, 0x40, 0x10, 0xCF, 0x90, 0x67, 0x20, 0x3E, 0x0D, 0x72, 0x0C, 0xE0, 0x47,
  0x77, 0x75, 0x01, 0x0C, 0xF9, 0x07, 0x71, 0x0C, 0xE0, 0x67, 0x20, 0xEE, 0x02, 0x77, 0x77, 0x60,
  0x10, 0xCF, 0x90, 0x76, 0x06, 0xE0, 0xD7, 0x3F, 0x01, 0x77, 0x77, 0x70, 0x10, 0xCF, 0x90, 0x74,
  0x02, 0x0E, 0xE0, 0x57, 0x3F, 0x01, 0x80, 0xC0, 0x00, 0x10, 0xCF, 0x90, 0x73, 0x0B, 0xE0, 0xB7,
  0x4F, 0x01, 0x80, 0xC1, 0x00, 0x10, 0xCF, 0x98, 0x17, 0x08, 0xF0, 0x27, 0x4F, 0x01, 0x80, 0xC2,
  0x00, 0x10, 0xCF, 0x90, 0xAF, 0x06, 0x75, 0x0E, 0xE0, 0x38, 0x0C, 0x30, 0x01, 0x0C, 0xFF, 0x0B,
  0x76, 0x0D, 0xE0, 0x58, 0x0C, 0x40, 0x01, 0x0C, 0xFD, 0x0E, 0x01, 0x76, 0x0B, 0xE0, 0x88, 0x0C,
  0x50, 0x01, 0x0C, 0xFC, 0x04, 0x77, 0x08, 0xE0, 0xC8, 0x0C, 0x60, 0x01, 0x0C, 0xFA, 0x06, 0x77,
  0x10, 0x5F, 0x02, 0x80, 0xC6, 0x00, 0x3F, 0xA0, 0x47, 0x71, 0x01, 0xF0, 0x98, 0x0C, 0x50, 0x03,
  0x0E, 0xFB, 0x04, 0x77, 0x10, 0xBF, 0x02, 0x80, 0xC3, 0x00, 0x40, 0xEF, 0xD0, 0x47, 0x70, 0x6F,
  0x0B, 0x80, 0xC2, 0x00, 0x7F, 0xF9, 0x04, 0x77, 0x0E, 0xF0, 0x77, 0x77, 0x77, 0x01, 0x0A, 0xF9,
  0x0E, 0xF9, 0x04, 0x76, 0x07, 0xF9, 0x05, 0x77, 0x77, 0x50, 0x40, 0xEF, 0x98, 0x17, 0x1C, 0xF9,
  0x04, 0x76, 0x0D, 0xF9, 0x07, 0x77, 0x77, 0x20, 0x10, 0xAF, 0xA0, 0x62, 0x01, 0x0C, 0xF9, 0x04,
  0x75, 0x03, 0xFA, 0x0A, 0x01, 0x77, 0x76, 0x08, 0x0E, 0xF9, 0x0E, 0x05, 0x40, 0x10, 0xCF, 0x90,
  0x47, 0x50, 0x7F, 0xA0, 0xE0, 0x67, 0x77, 0x28, 0x11, 0x7E, 0xFA, 0x0D, 0x02, 0x60, 0x10, 0xCF,
  0x90, 0x47, 0x50, 0x9F, 0xB8, 0x1E, 0x72, 0x77, 0x38, 0x11, 0x5A, 0xFC, 0x0A, 0x01, 0x71, 0x01,
  0x0C, 0xF9, 0x04, 0x75, 0x08, 0xFD, 0x83, 0xD9, 0x63, 0x16, 0x84, 0x12, 0x46, 0x9D, 0xFD, 0x0E,
  0x05, 0x74, 0x01, 0x0C, 0xF9, 0x04, 0x75, 0x06, 0xFF, 0xC0, 0x0E, 0xFF, 0xD0, 0xA0, 0x17, 0x60,
  0x10, 0xCF, 0x90, 0x47, 0x50, 0x30, 0xCF, 0xFF, 0xFF, 0x0C, 0x04, 0x77, 0x20, 0x10, 0xCF, 0x90,
  0x47, 0x60, 0x60, 0xEF, 0xFF, 0xFB, 0x0D, 0x05, 0x77, 0x50, 0x10, 0xCF, 0x90, 0x47, 0x70, 0x70,
  0xDF, 0xFF, 0xE0, 0xB0, 0x57, 0x77, 0x10, 0x10, 0xCF, 0x90, 0x47, 0x71, 0x81, 0x49, 0xEF, 0xFF,
  0x81, 0xB7, 0x17, 0x77, 0x40, 0x10, 0xCF, 0x90, 0x47, 0x73, 0x83, 0x26, 0x9B, 0xDF, 0xB8, 0x3D,
  0xB9, 0x63, 0x80, 0xF3, 0x00, 0xF1, 0x82, 0x32, 0x11, 0x80, 0xD3, 0x00,
  // "'" (U+0027)
  0x08, 0x80, 0x2B, 0x06, 0x0A, 0xE0, 0x80, 0x9E, 0x07, 0x08, 0xE0, 0x60, 0x8E, 0x06, 0x07, 0xE0,
  0x50, 0x6E, 0x04, 0x05, 0xE0, 0x40, 0x5E, 0x03, 0x04, 0xE0, 0x20, 0x3E, 0x01, 0x03, 0xE0, 0x10,
  0x2E, 0x10, 0x1E, 0x2D, 0x0E, 0x2D, 0x0D, 0x20, 0xEC, 0x0D, 0x20, 0xEC, 0x0C, 0x20, 0xDC, 0x0B,
  0x20, 0xCC, 0x0A, 0x20, 0xCC, 0x0A, 0x20, 0xBC, 0x09, 0x20, 0xAC, 0x08, 0x20, 0x9C, 0x08, 0x20,
  0x9C, 0x07, 0x20, 0x8C, 0x06, 0x20, 0x7C, 0x05, 0x20, 0x7C, 0x05, 0x20, 0x6C, 0x04, 0x20, 0x5C,
  0x03, 0x20, 0x4C, 0x03, 0x20, 0x18, 0x00, 0x32,
  // "(" (U+0028)
  0x77, 0x40, 0x98, 0x02, 0xB0, 0x27, 0x73, 0x07, 0xE0, 0x77, 0x73, 0x04, 0xE0, 0xB7, 0x73, 0x01,
  0x0E, 0xD0, 0xE0, 0x17, 0x73, 0x0B, 0xE0, 0x57, 0x73, 0x07, 0xE0, 0x97, 0x73, 0x02, 0xE0, 0xE0,
  0x17, 0x73, 0x0C, 0xE0, 0x57, 0x73, 0x06, 0xE0, 0xB7, 0x73, 0x01, 0x0E, 0xE0, 0x27, 0x73, 0x09,
  0xE0, 0x87, 0x73, 0x02, 0xE0, 0xE0, 0x17, 0x73, 0x0A, 0xE0, 0x77, 0x73, 0x03, 0xE0, 0xE7, 0x74,
  0x0B, 0xE0, 0x77, 0x73, 0x02, 0xE0, 0xE7, 0x74, 0x09, 0xE0, 0x77, 0x73, 0x01, 0xF0, 0x17, 0x73,
  0x07, 0xE0, 0x97, 0x74, 0x0D, 0xE0, 0x37, 0x73, 0x04, 0xE0, 0xC7, 0x74, 0x0A, 0xE0, 0x67, 0x73,
  0x01, 0xF0, 0x17, 0x73, 0x06, 0xE0, 0xB7, 0x74, 0x0B, 0xE0, 0x57, 0x74, 0xF0, 0x17, 0x73, 0x05,
  0xE0, 0xB7, 0x74, 0x09, 0xE0, 0x77, 0x74, 0x0E, 0xE0, 0x27, 0x73, 0x02, 0xE0, 0xD7, 0x74, 0x06,
  0xE0, 0x97, 0x74, 0x0A, 0xE0, 0x57, 0x74, 0x0D, 0xE0, 0x27, 0x73, 0x01, 0xE0, 0xE7, 0x74, 0x04,
  0xE0, 0xB7, 0x74, 0x07, 0xE0, 0x87, 0x74, 0x0A, 0xE0, 0x57, 0x74, 0x0D, 0xE0, 0x27, 0x74, 0xF7,
  0x74, 0x02, 0xE0, 0xD7, 0x74, 0x04, 0xE0, 0xB7, 0x74, 0x06, 0xE0, 0x97, 0x74, 0x07, 0xE0, 0x77,
  0x74, 0x09, 0xE0, 0x57, 0x74, 0x0A, 0xE0, 0x47, 0x74, 0x0C, 0xE0, 0x27, 0x74, 0x0D, 0xE0, 0x17,
  0x74, 0x0E, 0xE7, 0x75, 0x0E, 0xE7, 0x75, 0xE0, 0xE7, 0x75, 0xE0, 0xE7, 0x75, 0xE0, 0xD7, 0x74,
  0x01, 0xE0, 0xD7, 0x74, 0x01, 0xE0, 0xD7, 0x75, 0xE0, 0xD7, 0x75, 0xE0, 0xE7, 0x75, 0xE0, 0xE7,
  0x75, 0xF7, 0x75, 0x0E, 0xE7, 0x75, 0x0D, 0xE0, 0x17, 0x74, 0x0C, 0xE0, 0x27, 0x74, 0x0B, 0xE0,
  0x47, 0x74, 0x09, 0xE0, 0x57, 0x74, 0x08, 0xE0, 0x77, 0x74, 0x06, 0xE0, 0x97, 0x74, 0x04, 0xE0,
  0xB7, 0x74, 0x02, 0xE0, 0xD7, 0x75, 0xF7, 0x75, 0x0C, 0xE0, 0x37, 0x74, 0x0A, 0xE0, 0x57, 0x74,
  0x07, 0xE0, 0x87, 0x74, 0x04, 0xE0, 0xB7, 0x74, 0x01, 0xF7, 0x75, 0x0D, 0xE0, 0x37, 0x74, 0x09,
  0xE0, 0x77, 0x74, 0x05, 0xE0, 0xB7, 0x74, 0x01, 0xE0, 0xE7, 0x75, 0x0D, 0xE0, 0x47, 0x74, 0x08,
  0xE0, 0x87, 0x74, 0x03, 0xE0, 0xD7, 0x75, 0x0E, 0xE0, 0x27, 0x74, 0x09, 0xE0, 0x87, 0x74, 0x03,
  0xE0, 0xD7, 0x75, 0x0D, 0xE0, 0x37, 0x74, 0x08, 0xE0, 0x97, 0x74, 0x02, 0xE0, 0xE0, 0x17, 0x74,
  0x0B, 0xE0, 0x67, 0x74, 0x04, 0xE0, 0xD7, 0x75, 0x0D, 0xE0, 0x47, 0x74, 0x06, 0xE0, 0xB7, 0x75,
  0x0D, 0xE0, 0x37, 0x74, 0x06, 0xE0, 0xB7, 0x75, 0x0D, 0xE0, 0x37, 0x74, 0x05, 0xE0, 0xB7, 0x75,
  0x0C, 0xE0, 0x57, 0x74, 0x03, 0xE0, 0xD7, 0x75, 0x09, 0xE0, 0x77, 0x74, 0x01, 0x0E, 0xD0, 0xE0,
  0x27, 0x74, 0x05, 0xE0, 0xB7, 0x75, 0x0A, 0xE0, 0x57, 0x74, 0x01, 0x0D, 0xD0, 0xE0, 0x17, 0x74,
  0x04, 0xE0, 0xB7, 0x75, 0x08, 0xE0, 0x67, 0x75, 0x0B, 0xE0, 0x37, 0x74, 0x01, 0x0D, 0xD0, 0xD0,
  0x10,
  // ")" (U+0029)
  0x09, 0x80, 0x2B, 0x02, 0x77, 0x30, 0x20, 0xED, 0x0C, 0x77, 0x40, 0x5E, 0x09, 0x77, 0x40, 0xAE,
  0x06, 0x77, 0x30, 0x10, 0xDD, 0x0E, 0x02, 0x77, 0x30, 0x4E, 0x0C, 0x77, 0x40, 0x9E, 0x07, 0x77,
  0x30, 0x10, 0xEE, 0x02, 0x77, 0x30, 0x5E, 0x0B, 0x77, 0x40, 0xBE, 0x05, 0x77, 0x30, 0x3E, 0x0D,
  0x77, 0x40, 0x9E, 0x07, 0x77, 0x30, 0x1E, 0x0E, 0x01, 0x77, 0x30, 0x8E, 0x08, 0x77, 0x30, 0x10,
  0xEE, 0x01, 0x77, 0x30, 0x9E, 0x08, 0x77, 0x30, 0x2E, 0x0E, 0x77, 0x40, 0xAE, 0x07, 0x77, 0x30,
  0x3E, 0x0D, 0x77, 0x40, 0xCE, 0x04, 0x77, 0x30, 0x6E, 0x0A, 0x77, 0x30, 0x1F, 0x01, 0x77, 0x30,
  0xAE, 0x06, 0x77, 0x30, 0x5E, 0x0C, 0x77, 0x40, 0xEE, 0x01, 0x77, 0x30, 0xAE, 0x06, 0x77, 0x30,
  0x5E, 0x0B, 0x77, 0x30, 0x1F, 0x01, 0x77, 0x30, 0xBE, 0x04, 0x77, 0x30, 0x7E, 0x09, 0x77, 0x30,
  0x3E, 0x0D, 0x77, 0x40, 0xEE, 0x01, 0x77, 0x30, 0xBE, 0x04, 0x77, 0x30, 0x8E, 0x08, 0x77, 0x30,
  0x4E, 0x0B, 0x77, 0x30, 0x1E, 0x0E, 0x77, 0x40, 0xEE, 0x01, 0x77, 0x30, 0xBE, 0x04, 0x77, 0x30,
  0x9E, 0x06, 0x77, 0x30, 0x7E, 0x08, 0x77, 0x30, 0x4E, 0x0A, 0x77, 0x30, 0x2E, 0x0C, 0x77, 0x30,
  0x1E, 0x0E, 0x77, 0x4F, 0x77, 0x40, 0xDE, 0x01, 0x77, 0x30, 0xCE, 0x02, 0x77, 0x30, 0xBE, 0x03,
  0x77, 0x30, 0xAE, 0x04, 0x77, 0x30, 0x9E, 0x05, 0x77, 0x30, 0x8E, 0x05, 0x77, 0x30, 0x8E, 0x06,
  0x77, 0x30, 0x8E, 0x06, 0x77, 0x30, 0x8E, 0x06, 0x77, 0x30, 0x8E, 0x06, 0x77, 0x30, 0x8E, 0x06,
  0x77, 0x30, 0x8E, 0x05, 0x77, 0x30, 0x9E, 0x05, 0x77, 0x30, 0xAE, 0x04, 0x77, 0x30, 0xAE, 0x03,
  0x77, 0x30, 0xBE, 0x03, 0x77, 0x30, 0xDE, 0x01, 0x77, 0x30, 0xEE, 0x77, 0x4E, 0x0E, 0x77, 0x30,
  0x2E, 0x0D, 0x77, 0x30, 0x4E, 0x0B, 0x77, 0x30, 0x6E, 0x09, 0x77, 0x30, 0x8E, 0x07, 0x77, 0x30,
  0xAE, 0x04, 0x77, 0x30, 0xDE, 0x02, 0x77, 0x3E, 0x0E, 0x77, 0x30, 0x3E, 0x0C, 0x77, 0x30, 0x6E,
  0x09, 0x77, 0x30, 0xAE, 0x05, 0x77, 0x30, 0xDE, 0x02, 0x77, 0x20, 0x1E, 0x0E, 0x77, 0x30, 0x5E,
  0x0A, 0x77, 0x30, 0x9E, 0x06, 0x77, 0x30, 0xDE, 0x02, 0x77, 0x20, 0x3E, 0x0D, 0x77, 0x30, 0x7E,
  0x08, 0x77, 0x30, 0xCE, 0x04, 0x77, 0x20, 0x2E, 0x0E, 0x77, 0x30, 0x7E, 0x09, 0x77, 0x30, 0xDE,
  0x03, 0x77, 0x20, 0x3E, 0x0D, 0x77, 0x30, 0x9E, 0x07, 0x77, 0x20, 0x10, 0xEE, 0x01, 0x77, 0x20,
  0x6E, 0x0A, 0x77, 0x30, 0xDE, 0x03, 0x77, 0x20, 0x5E, 0x0C, 0x77, 0x30, 0xCE, 0x05, 0x77, 0x20,
  0x5E, 0x0C, 0x77, 0x30, 0xCE, 0x04, 0x77, 0x20, 0x5E, 0x0C, 0x77, 0x30, 0xDE, 0x03, 0x77, 0x20,
  0x7E, 0x09, 0x77, 0x20, 0x10, 0xED, 0x0E, 0x01, 0x77, 0x20, 0xAE, 0x06, 0x77, 0x20, 0x4E, 0x0B,
  0x77, 0x20, 0x10, 0xDD, 0x0E, 0x02, 0x77, 0x20, 0xAE, 0x06, 0x77, 0x20, 0x5E, 0x0A, 0x77, 0x20,
  0x10, 0xED, 0x0D, 0x77, 0x30, 0xCD, 0x0E, 0x02, 0x77, 0x20, 0x8E, 0x04, 0x77, 0x30,
  // "*" (U+002A)
  0x77, 0x72, 0x80, 0x31, 0x80, 0xD3, 0x00, 0xEE, 0x06, 0x80, 0xD2, 0x00, 0xDE, 0x06, 0x80, 0xD2,
  0x00, 0xCE, 0x05, 0x80, 0xD2, 0x00, 0xBE, 0x04, 0x80, 0xD2, 0x00, 0xAE, 0x03, 0x80, 0xD2, 0x00,
  0x9E, 0x02, 0x80, 0xD2, 0x00, 0x8E, 0x01, 0x80, 0xD2, 0x00, 0x7E, 0x80, 0xD3, 0x00, 0x6E, 0x80,
  0xD3, 0x00, 0x5D, 0x0E, 0x80, 0xD3, 0x00, 0x4D, 0x0D, 0x80, 0xD3, 0x00, 0x3D, 0x0C, 0x80, 0xD3,
  0x00, 0x2D, 0x0B, 0x80, 0xD3, 0x00, 0x1D, 0x0A, 0x80, 0xD4, 0x0D, 0x09, 0x80, 0xD4, 0x00, 0xEC,
  0x08, 0x77, 0x74, 0x04, 0x05, 0x77, 0x70, 0xDC, 0x07, 0x77, 0x68, 0x12, 0x71, 0x28, 0x4A, 0xFE,
  0xA5, 0x17, 0x73, 0x0C, 0xC0, 0x67, 0x73, 0x81, 0x27, 0xCA, 0x04, 0x20, 0xCD, 0x81, 0xB6, 0x17,
  0x70, 0xBC, 0x05, 0x77, 0x81, 0x37, 0xDD, 0x07, 0x2F, 0xA8, 0x1B, 0x61, 0x74, 0x0A, 0xC0, 0x47,
  0x48, 0x13, 0x8D, 0xF9, 0x81, 0xA0, 0x3F, 0xD8, 0x1C, 0x72, 0x71, 0x09, 0xC0, 0x37, 0x18, 0x13,
  0x9D, 0xFC, 0x81, 0xD0, 0x5F, 0xF9, 0x81, 0xC7, 0x25, 0x08, 0xC0, 0x25, 0x81, 0x49, 0xEF, 0xF9,
  0x01, 0x08, 0xFF, 0xC8, 0x1D, 0x83, 0x20, 0x7C, 0x01, 0x28, 0x14, 0x9E, 0xFF, 0xC8, 0x14, 0x7C,
  0xFF, 0xE8, 0x1D, 0x89, 0xC8, 0x16, 0xAE, 0xFF, 0xD8, 0x1E, 0xB4, 0x38, 0x32, 0x58, 0xBE, 0x80,
  0xC2, 0xF8, 0x3D, 0xA7, 0x42, 0x74, 0x83, 0x14, 0x7A, 0xDF, 0xFF, 0xF8, 0x3C, 0xA7, 0x41, 0x77,
  0x78, 0x31, 0x46, 0x9C, 0xFF, 0xB8, 0x3E, 0xC9, 0x63, 0x77, 0x77, 0x58, 0x23, 0x68, 0xCF, 0x98,
  0x2B, 0x85, 0x28, 0x0C, 0x50, 0x06, 0xF9, 0x03, 0x80, 0xC7, 0x00, 0x3F, 0xA0, 0xD0, 0x18, 0x0C,
  0x50, 0x01, 0x0D, 0xC0, 0xAD, 0x0B, 0x80, 0xC5, 0x00, 0xBC, 0x81, 0xE0, 0x9D, 0x07, 0x80, 0xC3,
  0x00, 0x7D, 0x82, 0x60, 0x1E, 0xD0, 0x38, 0x0C, 0x10, 0x03, 0xD0, 0xC3, 0x07, 0xD0, 0xE0, 0x17,
  0x77, 0x77, 0x01, 0x0E, 0xD0, 0x44, 0x0D, 0xD0, 0xB7, 0x77, 0x77, 0x0B, 0xD0, 0xB5, 0x04, 0xE0,
  0x87, 0x77, 0x75, 0x08, 0xE0, 0x26, 0x0A, 0xE0, 0x47, 0x77, 0x73, 0x04, 0xE0, 0x97, 0x02, 0xE0,
  0xE0, 0x17, 0x77, 0x71, 0x01, 0x0E, 0xD0, 0xE0, 0x17, 0x10, 0x8E, 0x0C, 0x77, 0x77, 0x10, 0xCE,
  0x07, 0x73, 0x0D, 0xE0, 0x97, 0x77, 0x60, 0x8E, 0x0D, 0x74, 0x05, 0xF0, 0x57, 0x77, 0x40, 0x5F,
  0x05, 0x75, 0x0B, 0xE0, 0xE0, 0x27, 0x77, 0x20, 0x20, 0xEE, 0x0C, 0x76, 0x03, 0xF0, 0xC7, 0x77,
  0x20, 0xCF, 0x04, 0x77, 0x09, 0xF0, 0x97, 0x77, 0x09, 0xF0, 0xA7, 0x71, 0x01, 0x0E, 0xF0, 0x67,
  0x75, 0x06, 0xF9, 0x02, 0x77, 0x20, 0x6F, 0x90, 0x27, 0x73, 0x02, 0x0E, 0xF0, 0x97, 0x74, 0x0C,
  0xF0, 0xD7, 0x73, 0x02, 0x0A, 0xE0, 0xE0, 0x17, 0x74, 0x03, 0xF0, 0x90, 0x17, 0x74, 0x04, 0x0C,
  0xC0, 0x77, 0x76, 0x0A, 0xC0, 0xB0, 0x27, 0x77, 0x18, 0x26, 0xEF, 0xD7, 0x77, 0x83, 0x1E, 0xFD,
  0x57, 0x77, 0x48, 0x11, 0x85, 0x77, 0x71, 0x06, 0x07, 0x77,
  // "+" (U+002B)
  0x77, 0x74, 0x07, 0x80, 0x1B, 0x80, 0xD7, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80,
  0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6,
  0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00,
  0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD,
  0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01,
  0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80,
  0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6,
  0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x77, 0x74, 0x80,
  0xA5, 0x10, 0xBD, 0x03, 0x80, 0xA4, 0x11, 0x0B, 0x80, 0xE3, 0xF0, 0x20, 0xB8, 0x0E, 0x3F, 0x02,
  0x0B, 0x80, 0xE3, 0xF0, 0x20, 0xB8, 0x0E, 0x3F, 0x02, 0x0B, 0x80, 0xE3, 0xF0, 0x20, 0x58, 0x0A,
  0x47, 0x0D, 0xD0, 0x88, 0x0A, 0x47, 0x01, 0x77, 0x74, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0,
  0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18,
  0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D,
  0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60,
  0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A,
  0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0,
  0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18,
  0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D,
  0x60, 0x0A, 0xD0, 0x17, 0x77, 0x40,
  // "," (U+002C)
  0x78, 0x03, 0xD0, 0x86, 0x02, 0xF0, 0xD6, 0x04, 0xF0, 0xB6, 0x07, 0xF0, 0x76, 0x09, 0xF0, 0x36,
  0x0C, 0xE0, 0xE7, 0x0E, 0xE0, 0xB6, 0x01, 0xF0, 0x76, 0x04, 0xF0, 0x36, 0x07, 0xE0, 0xE7, 0x0A,
  0xE0, 0x97, 0x0D, 0xE0, 0x56, 0x01, 0xF0, 0x16, 0x04, 0xE0, 0xB7, 0x07, 0xE0, 0x67, 0x0B, 0xE0,
  0x17, 0x0E, 0xD0, 0xC7, 0x02, 0xE0, 0x77, 0x06, 0xE0, 0x27, 0x09, 0xD0, 0xC7, 0x10, 0xDD, 0x07,
  0x70, 0x1E, 0x01, 0x70, 0x5D, 0x0B, 0x71, 0x09, 0xD0, 0x57, 0x10, 0xDC, 0x0E, 0x71, 0x01, 0xD0,
  0x97, 0x10, 0x6D, 0x03, 0x71, 0x0A, 0xC0, 0xC7, 0x20, 0xEC, 0x05, 0x71, 0x01, 0x80, 0x17, 0x72,
  // "-" (U+002D)
  0x01, 0x80, 0xB0, 0x70, 0x60, 0x3F, 0xFF, 0xF0, 0xD0, 0x3F, 0xFF, 0xF0, 0xD0, 0x3F, 0xFF, 0xF0,
  0xD0, 0x3F, 0xFF, 0xF0, 0xD0, 0x3F, 0xFF, 0xF0, 0xD0, 0x28, 0x0B, 0x0B, 0x09,
  // "." (U+002E)
  0x38, 0x31, 0x55, 0x52, 0x50, 0x9D, 0x0C, 0x02, 0x20, 0x9F, 0x81, 0xD0, 0x2F, 0xA0, 0x06, 0xFA,
  0x0B, 0x09, 0xFA, 0x0D, 0x09, 0xFA, 0x0E, 0x08, 0xFA, 0x0D, 0x06, 0xFA, 0x0A, 0x01, 0xFA, 0x81,
  0x60, 0x8F, 0x0C, 0x30, 0x70, 0xEC, 0x0A, 0x01, 0x50, 0xF3, 0x01, 0x30,
  // "/" (U+002F)
  0x77, 0x77, 0x40, 0x88, 0x02, 0xB0, 0x27, 0x77, 0x73, 0x01, 0xE0, 0xD7, 0x77, 0x74, 0x07, 0xE0,
  0x77, 0x77, 0x74, 0x0C, 0xE0, 0x17, 0x77, 0x73, 0x03, 0xE0, 0xB7, 0x77, 0x74, 0x08, 0xE0, 0x57,
  0x77, 0x74, 0x0E, 0xD0, 0xE7, 0x77, 0x74, 0x04, 0xE0, 0x97, 0x77, 0x74, 0x0A, 0xE0, 0x37, 0x77,
  0x73, 0x01, 0xE0, 0xD7, 0x77, 0x74, 0x06, 0xE0, 0x77, 0x77, 0x74, 0x0C, 0xE0, 0x17, 0x77, 0x73,
  0x02, 0xE0, 0xB7, 0x77, 0x74, 0x08, 0xE0, 0x57, 0x77, 0x74, 0x0E, 0xD0, 0xE7, 0x77, 0x74, 0x04,
  0xE0, 0x97, 0x77, 0x74, 0x0A, 0xE0, 0x37, 0x77, 0x73, 0x01, 0xE0, 0xD7, 0x77, 0x74, 0x06, 0xE0,
  0x77, 0x77, 0x74, 0x0C, 0xE0, 0x17, 0x77, 0x73, 0x02, 0xE0, 0xB7, 0x77, 0x74, 0x08, 0xE0, 0x57,
  0x77, 0x74, 0x0D, 0xD0, 0xE7, 0x77, 0x74, 0x04, 0xE0, 0x97, 0x77, 0x74, 0x0A, 0xE0, 0x37, 0x77,
  0x74, 0x0E, 0xD0, 0xD7, 0x77, 0x74, 0x06, 0xE0, 0x77, 0x77, 0x74, 0x0B, 0xE0, 0x17, 0x77, 0x73,
  0x02, 0xE0, 0xB7, 0x77, 0x74, 0x07, 0xE0, 0x57, 0x77, 0x74, 0x0D, 0xD0, 0xE7, 0x77, 0x74, 0x04,
  0xE0, 0x97, 0x77, 0x74, 0x09, 0xE0, 0x37, 0x77, 0x74, 0x0E, 0xD0, 0xD7, 0x77, 0x74, 0x05, 0xE0,
  0x77, 0x77, 0x74, 0x0B, 0xE0, 0x17, 0x77, 0x73, 0x01, 0xE0, 0xB7, 0x77, 0x74, 0x07, 0xE0, 0x57,
  0x77, 0x74, 0x0D, 0xD0, 0xE7, 0x77, 0x74, 0x03, 0xE0, 0x97, 0x77, 0x74, 0x09, 0xE0, 0x37, 0x77,
  0x74, 0x0E, 0xD0, 0xD7, 0x77, 0x74, 0x05, 0xE0, 0x77, 0x77, 0x74, 0x0B, 0xE0, 0x17, 0x77, 0x73,
  0x01, 0xE0, 0xB7, 0x77, 0x74, 0x07, 0xE0, 0x57, 0x77, 0x74, 0x0D, 0xD0, 0xE7, 0x77, 0x74, 0x03,
  0xE0, 0x97, 0x77, 0x74, 0x09, 0xE0, 0x37, 0x77, 0x74, 0x0E, 0xD0, 0xD7, 0x77, 0x74, 0x05, 0xE0,
  0x77, 0x77, 0x74, 0x0B, 0xE0, 0x17, 0x77, 0x73, 0x01, 0xE0, 0xB7, 0x77, 0x74, 0x07, 0xE0, 0x57,
  0x77, 0x74, 0x0C, 0xD0, 0xE7, 0x77, 0x74, 0x03, 0xE0, 0x97, 0x77, 0x74, 0x08, 0xE0, 0x37, 0x77,
  0x74, 0x0E, 0xD0, 0xD7, 0x77, 0x74, 0x04, 0xE0, 0x77, 0x77, 0x74, 0x0A, 0xE0, 0x17, 0x77, 0x73,
  0x01, 0xE0, 0xB7, 0x77, 0x74, 0x06, 0xE0, 0x57, 0x77, 0x74, 0x0C, 0xD0, 0xE7, 0x77, 0x74, 0x02,
  0xE0, 0x97, 0x77, 0x74, 0x08, 0xE0, 0x37, 0x77, 0x74, 0x0E, 0xD0, 0xD7, 0x77, 0x74, 0x04, 0xE0,
  0x77, 0x77, 0x74, 0x0A, 0xE0, 0x17, 0x77, 0x73, 0x01, 0xE0, 0xB7, 0x77, 0x74, 0x06, 0xE0, 0x57,
  0x77, 0x74, 0x0C, 0xD0, 0xE7, 0x77, 0x74, 0x02, 0xE0, 0x97, 0x77, 0x74, 0x08, 0xE0, 0x37, 0x77,
  0x74, 0x0D, 0xD0, 0xD7, 0x77, 0x74, 0x04, 0xE0, 0x77, 0x77, 0x74, 0x0A, 0xE0, 0x17, 0x77, 0x74,
  0x0E, 0xD0, 0xB7, 0x77, 0x74, 0x06, 0xE0, 0x57, 0x77, 0x74, 0x0B, 0xD0, 0xE7, 0x77, 0x74, 0x02,
  0xE0, 0x97, 0x77, 0x74, 0x07, 0xE0, 0x37, 0x77, 0x74, 0x0D, 0xD0, 0xD7, 0x77, 0x74, 0x03, 0xE0,
  0x77, 0x77, 0x74, 0x09, 0xE0, 0x17, 0x77, 0x74, 0x0E, 0xD0, 0xB7, 0x77, 0x74, 0x05, 0xE0, 0x57,
  0x77, 0x74,
  // "0" (U+0030)
  0x77, 0x78, 0x43, 0x69, 0xBD, 0xEB, 0x84, 0xDC, 0xB8, 0x52, 0x80, 0xC2, 0x08, 0x15, 0xAE, 0xFF,
  0x98, 0x1D, 0x82, 0x77, 0x77, 0x50, 0x60, 0xDF, 0xFF, 0x0A, 0x03, 0x77, 0x77, 0x10, 0x40, 0xDF,
  0xFF, 0xC0, 0x97, 0x77, 0x60, 0x8F, 0xFF, 0xF0, 0xD0, 0x37, 0x77, 0x30, 0xBF, 0xFF, 0xFA, 0x0E,
  0x05, 0x77, 0x71, 0x0B, 0xFB, 0x83, 0xB8, 0x42, 0x13, 0x83, 0x13, 0x59, 0xDF, 0xB0, 0x57, 0x76,
  0x0B, 0xF9, 0x81, 0xE7, 0x17, 0x60, 0x30, 0x9F, 0xA0, 0x47, 0x74, 0x08, 0xF9, 0x08, 0x77, 0x40,
  0x20, 0xBF, 0x0E, 0x02, 0x77, 0x20, 0x5F, 0x0E, 0x03, 0x77, 0x70, 0x7F, 0x0C, 0x77, 0x10, 0x10,
  0xEE, 0x0D, 0x02, 0x77, 0x72, 0x06, 0xF0, 0x87, 0x70, 0x9E, 0x0E, 0x02, 0x77, 0x74, 0x07, 0xF0,
  0x37, 0x50, 0x3F, 0x04, 0x77, 0x76, 0x0A, 0xE0, 0xB7, 0x50, 0xBE, 0x09, 0x77, 0x77, 0x01, 0x0E,
  0xE0, 0x47, 0x30, 0x3E, 0x0D, 0x77, 0x77, 0x20, 0x5E, 0x0B, 0x73, 0x0A, 0xE0, 0x67, 0x77, 0x73,
  0x0C, 0xE0, 0x37, 0x10, 0x1E, 0x0D, 0x77, 0x77, 0x40, 0x4E, 0x09, 0x71, 0x07, 0xE0, 0x67, 0x77,
  0x75, 0x0D, 0xD0, 0xE7, 0x10, 0xCE, 0x01, 0x77, 0x77, 0x50, 0x7E, 0x05, 0x60, 0x2E, 0x0A, 0x77,
  0x77, 0x60, 0x1E, 0x0A, 0x60, 0x6E, 0x05, 0x77, 0x77, 0x70, 0xCD, 0x0E, 0x60, 0xBE, 0x80, 0xC0,
  0x00, 0x8E, 0x03, 0x50, 0xED, 0x0B, 0x80, 0xC0, 0x00, 0x4E, 0x07, 0x40, 0x3E, 0x08, 0x80, 0xC1,
  0x0E, 0x0B, 0x40, 0x6E, 0x04, 0x80, 0xC1, 0x00, 0xCD, 0x0E, 0x40, 0x9E, 0x01, 0x80, 0xC1, 0x00,
  0x9E, 0x02, 0x30, 0xCD, 0x0E, 0x80, 0xC2, 0x00, 0x6E, 0x05, 0x3E, 0x0B, 0x80, 0xC2, 0x00, 0x4E,
  0x08, 0x20, 0x2E, 0x09, 0x80, 0xC2, 0x00, 0x2E, 0x0A, 0x20, 0x4E, 0x06, 0x80, 0xC3, 0x0E, 0x0D,
  0x20, 0x7E, 0x04, 0x80, 0xC3, 0x00, 0xDE, 0x20, 0x9E, 0x03, 0x80, 0xC3, 0x00, 0xBE, 0x81, 0x10,
  0xAE, 0x01, 0x80, 0xC3, 0x00, 0xAE, 0x81, 0x30, 0xCE, 0x80, 0xC4, 0x00, 0x8E, 0x81, 0x40, 0xDD,
  0x0E, 0x80, 0xC4, 0x00, 0x7E, 0x81, 0x60, 0xED, 0x0D, 0x80, 0xC4, 0x00, 0x6E, 0x07, 0x1E, 0x0C,
  0x80, 0xC4, 0x00, 0x5E, 0x08, 0x01, 0xE0, 0xB8, 0x0C, 0x40, 0x04, 0xE0, 0x90, 0x2E, 0x0A, 0x80,
  0xC4, 0x00, 0x4E, 0x0A, 0x02, 0xE0, 0x98, 0x0C, 0x40, 0x03, 0xE0, 0xA0, 0x3E, 0x09, 0x80, 0xC4,
  0x00, 0x3E, 0x0B, 0x03, 0xE0, 0x98, 0x0C, 0x40, 0x02, 0xE0, 0xB0, 0x4E, 0x08, 0x80, 0xC4, 0x00,
  0x2E, 0x0C, 0x04, 0xE0, 0x88, 0x0C, 0x40, 0x02, 0xE0, 0xC0, 0x4E, 0x08, 0x80, 0xC4, 0x00, 0x2E,
  0x0C, 0x04, 0xE0, 0x98, 0x0C, 0x40, 0x02, 0xE0, 0xC0, 0x3E, 0x09, 0x80, 0xC4, 0x00, 0x3E, 0x0B,
  0x03, 0xE0, 0x98, 0x0C, 0x40, 0x03, 0xE0, 0xB0, 0x3E, 0x09, 0x80, 0xC4, 0x00, 0x3E, 0x0B, 0x02,
  0xE0, 0xA8, 0x0C, 0x40, 0x04, 0xE0, 0xA0, 0x1E, 0x0B, 0x80, 0xC4, 0x00, 0x5E, 0x09, 0x1E, 0x0C,
  0x80, 0xC4, 0x00, 0x5E, 0x08, 0x1E, 0x0D, 0x80, 0xC4, 0x00, 0x6E, 0x81, 0x70, 0xDD, 0x0E, 0x80,
  0xC4, 0x00, 0x7E, 0x81, 0x60, 0xCE, 0x80, 0xC4, 0x00, 0x9E, 0x81, 0x50, 0xAE, 0x01, 0x80, 0xC3,
  0x00, 0xAE, 0x81, 0x30, 0x9E, 0x03, 0x80, 0xC3, 0x00, 0xCE, 0x81, 0x10, 0x7E, 0x05, 0x80, 0xC3,
  0x00, 0xEE, 0x20, 0x5E, 0x07, 0x80, 0xC3, 0x0E, 0x0D, 0x20, 0x2E, 0x09, 0x80, 0xC2, 0x00, 0x2E,
  0x0B, 0x3E, 0x0B, 0x80, 0xC2, 0x00, 0x5E, 0x08, 0x30, 0xDD, 0x0E, 0x80, 0xC2, 0x00, 0x7E, 0x06,
  0x30, 0x9E, 0x02, 0x80, 0xC1, 0x00, 0xBE, 0x03, 0x30, 0x6E, 0x05, 0x80, 0xC1, 0x00, 0xEE, 0x40,
  0x3E, 0x09, 0x80, 0xC0, 0x00, 0x2E, 0x0C, 0x50, 0xED, 0x0D, 0x80, 0xC0, 0x00, 0x6E, 0x08, 0x50,
  0xAE, 0x01, 0x77, 0x77, 0x70, 0xAE, 0x04, 0x50, 0x6E, 0x06, 0x77, 0x77, 0x70, 0xED, 0x0E, 0x60,
  0x1E, 0x0B, 0x77, 0x77, 0x60, 0x4E, 0x0A, 0x70, 0xBE, 0x01, 0x77, 0x77, 0x50, 0x9E, 0x05, 0x70,
  0x6E, 0x07, 0x77, 0x77, 0x40, 0x10, 0xEE, 0x01, 0x71, 0x0E, 0xD0, 0xE7, 0x77, 0x74, 0x07, 0xE0,
  0xA7, 0x20, 0x9E, 0x06, 0x77, 0x77, 0x30, 0xDE, 0x04, 0x72, 0x02, 0xE0, 0xE0, 0x17, 0x77, 0x71,
  0x07, 0xE0, 0xC7, 0x40, 0xAE, 0x09, 0x77, 0x77, 0x01, 0x0E, 0xE0, 0x57, 0x40, 0x2F, 0x04, 0x77,
  0x76, 0x0B, 0xE0, 0xD7, 0x60, 0x8E, 0x0E, 0x02, 0x77, 0x74, 0x08, 0xF0, 0x47, 0x70, 0xDE, 0x0D,
  0x02, 0x77, 0x72, 0x07, 0xF0, 0xB7, 0x71, 0x04, 0xF0, 0xE0, 0x37, 0x77, 0x08, 0xF0, 0xE0, 0x17,
  0x72, 0x08, 0xF9, 0x07, 0x77, 0x40, 0x20, 0xCF, 0x90, 0x57, 0x74, 0x0A, 0xF9, 0x0D, 0x05, 0x77,
  0x02, 0x09, 0xFA, 0x08, 0x77, 0x60, 0xBF, 0xA8, 0x2E, 0x95, 0x26, 0x82, 0x13, 0x7C, 0xFB, 0x09,
  0x77, 0x71, 0x0A, 0xFE, 0x83, 0xDD, 0xCD, 0xEF, 0xE0, 0x87, 0x77, 0x30, 0x8F, 0xFF, 0xF9, 0x06,
  0x77, 0x75, 0x04, 0x0D, 0xFF, 0xFC, 0x0C, 0x02, 0x77, 0x77, 0x10, 0x70, 0xEF, 0xFF, 0x0D, 0x05,
  0x77, 0x77, 0x50, 0x60, 0xCF, 0xFB, 0x0B, 0x05, 0x80, 0xC1, 0x08, 0x32, 0x69, 0xCE, 0xF8, 0x2E,
  0xB8, 0x58, 0x0D, 0x10, 0x84, 0x11, 0x23, 0x11, 0x77, 0x74,
  // "1" (U+0031)
  0x77, 0x72, 0x07, 0x80, 0x1B, 0x06, 0x77, 0x70, 0x10, 0xAE, 0x08, 0x77, 0x60, 0x30, 0xDF, 0x08,
  0x77, 0x50, 0x7F, 0xA0, 0x87, 0x73, 0x01, 0x0A, 0xFB, 0x08, 0x77, 0x20, 0x30, 0xDF, 0xC0, 0x87,
  0x71, 0x06, 0xFE, 0x08, 0x77, 0x0A, 0xF0, 0xEE, 0x08, 0x75, 0x03, 0x0D, 0xF0, 0xD0, 0x2E, 0x08,
  0x74, 0x06, 0xF9, 0x0D, 0x02, 0x1E, 0x08, 0x73, 0x0A, 0xF9, 0x82, 0xB1, 0x01, 0xE0, 0x87, 0x10,
  0x30, 0xDF, 0x90, 0x93, 0x01, 0xE0, 0x87, 0x06, 0xFA, 0x06, 0x40, 0x2E, 0x08, 0x60, 0xAF, 0x90,
  0xD0, 0x35, 0x02, 0xE0, 0x84, 0x02, 0x0D, 0xF9, 0x0B, 0x01, 0x60, 0x2E, 0x08, 0x30, 0x6F, 0xA0,
  0x77, 0x10, 0x2E, 0x08, 0x20, 0xAF, 0x90, 0xE0, 0x47, 0x20, 0x2E, 0x81, 0x82, 0xDF, 0x90, 0xB0,
  0x17, 0x30, 0x2E, 0x81, 0x81, 0xDF, 0x08, 0x75, 0x02, 0xE8, 0x18, 0x03, 0xD0, 0xE0, 0x47, 0x60,
  0x2E, 0x08, 0x20, 0x7B, 0x0C, 0x02, 0x77, 0x02, 0xE0, 0x83, 0x81, 0xBF, 0x97, 0x72, 0x02, 0xE0,
  0x83, 0x01, 0x05, 0x77, 0x30, 0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08,
  0x77, 0x71, 0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77, 0x10,
  0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0, 0x87,
  0x77, 0x10, 0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08, 0x77, 0x71, 0x02,
  0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08, 0x77,
  0x71, 0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E,
  0x08, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77,
  0x10, 0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0,
  0x87, 0x77, 0x10, 0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08, 0x77, 0x71,
  0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08,
  0x77, 0x71, 0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77, 0x10,
  0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0, 0x87,
  0x77, 0x10, 0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08, 0x77, 0x71, 0x02,
  0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08, 0x77,
  0x71, 0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E,
  0x08, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77,
  0x10, 0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0,
  0x87, 0x77, 0x10, 0x2E, 0x08, 0x77, 0x71, 0x02, 0xE0, 0x87, 0x77, 0x10, 0x2E, 0x08, 0x77, 0x71,
  0x02, 0xE0, 0x80,
  // "2" (U+0032)
  0x77, 0x58, 0x95, 0x25, 0x79, 0xBB, 0xDD, 0xDC, 0xB9, 0x85, 0x28, 0x0C, 0x00, 0x82, 0x16, 0xAE,
  0xFF, 0x98, 0x1E, 0xA5, 0x77, 0x77, 0x30, 0x60, 0xBF, 0xFF, 0x98, 0x1E, 0x81, 0x77, 0x74, 0x81,
  0x18, 0xEF, 0xFF, 0xD0, 0xE0, 0x87, 0x77, 0x10, 0x10, 0x8F, 0xFF, 0xFB, 0x0D, 0x03, 0x77, 0x50,
  0x70, 0xEF, 0xFF, 0xFE, 0x06, 0x77, 0x20, 0x30, 0xCF, 0xE8, 0x93, 0xB8, 0x64, 0x32, 0x11, 0x34,
  0x69, 0xDF, 0xC0, 0x87, 0x70, 0x8F, 0xC8, 0x1E, 0x93, 0x77, 0x81, 0x28, 0xEF, 0xA0, 0x77, 0x40,
  0x10, 0xBF, 0xB0, 0xB0, 0x47, 0x76, 0x07, 0xFA, 0x05, 0x73, 0x09, 0xFA, 0x0B, 0x03, 0x77, 0x72,
  0x02, 0x0C, 0xF0, 0xE0, 0x27, 0x30, 0xCE, 0x0D, 0x04, 0x77, 0x76, 0x0B, 0xF0, 0xB7, 0x30, 0x20,
  0xEC, 0x07, 0x77, 0x77, 0x20, 0xCF, 0x05, 0x73, 0x05, 0xA0, 0xC0, 0x27, 0x77, 0x73, 0x01, 0x0E,
  0xE0, 0xC7, 0x40, 0x80, 0x97, 0x77, 0x76, 0x05, 0xF0, 0x38, 0x0D, 0x30, 0x0C, 0xE0, 0x98, 0x0D,
  0x30, 0x05, 0xE0, 0xE8, 0x0D, 0x40, 0xF0, 0x28, 0x0D, 0x30, 0x0B, 0xE0, 0x68, 0x0D, 0x30, 0x07,
  0xE0, 0x88, 0x0D, 0x30, 0x05, 0xE0, 0xA8, 0x0D, 0x30, 0x03, 0xE0, 0xC8, 0x0D, 0x30, 0x02, 0xE0,
  0xC8, 0x0D, 0x30, 0x01, 0xE0, 0xD8, 0x0D, 0x30, 0x01, 0xE0, 0xC8, 0x0D, 0x30, 0x02, 0xE0, 0xC8,
  0x0D, 0x30, 0x03, 0xE0, 0xB8, 0x0D, 0x30, 0x04, 0xE0, 0xA8, 0x0D, 0x30, 0x06, 0xE0, 0x88, 0x0D,
  0x30, 0x08, 0xE0, 0x58, 0x0D, 0x30, 0x0C, 0xE0, 0x38, 0x0D, 0x30, 0xE0, 0xE8, 0x0D, 0x30, 0x04,
  0xE0, 0xB8, 0x0D, 0x30, 0x09, 0xE0, 0x78, 0x0D, 0x30, 0x0E, 0xE0, 0x18, 0x0D, 0x20, 0x06, 0xE0,
  0xB8, 0x0D, 0x30, 0x0D, 0xE0, 0x58, 0x0D, 0x20, 0x05, 0xE0, 0xD8, 0x0D, 0x30, 0x0D, 0xE0, 0x68,
  0x0D, 0x20, 0x07, 0xE0, 0xD8, 0x0D, 0x20, 0x02, 0x0E, 0xE0, 0x58, 0x0D, 0x20, 0x0B, 0xE0, 0xC8,
  0x0D, 0x20, 0x07, 0xF0, 0x38, 0x0D, 0x10, 0x03, 0xF0, 0x78, 0x0D, 0x10, 0x01, 0x0D, 0xE0, 0xC8,
  0x0D, 0x20, 0x0B, 0xE0, 0xE0, 0x28, 0x0D, 0x10, 0x09, 0xF0, 0x58, 0x0D, 0x10, 0x07, 0xF0, 0x98,
  0x0D, 0x10, 0x05, 0xF0, 0xB8, 0x0D, 0x10, 0x04, 0xF0, 0xD0, 0x18, 0x0D, 0x00, 0x03, 0x0E, 0xE0,
  0xE0, 0x28, 0x0D, 0x00, 0x02, 0x0E, 0xE0, 0xE0, 0x38, 0x0D, 0x00, 0x01, 0x0D, 0xF0, 0x48, 0x0D,
  0x00, 0x01, 0x0C, 0xF0, 0x68, 0x0D, 0x10, 0x0C, 0xF0, 0x78, 0x0D, 0x10, 0x0B, 0xF0, 0x88, 0x0D,
  0x10, 0x0B, 0xF0, 0x98, 0x0D, 0x10, 0x0A, 0xF0, 0x98, 0x0D, 0x10, 0x0A, 0xF0, 0x98, 0x0D, 0x10,
  0x09, 0xF0, 0xA8, 0x0D, 0x10, 0x09, 0xF0, 0xA8, 0x0D, 0x10, 0x08, 0xF0, 0xA8, 0x0D, 0x10, 0x08,
  0xF0, 0xA8, 0x0D, 0x10, 0x07, 0xF0, 0xB8, 0x0D, 0x10, 0x06, 0xF0, 0xB8, 0x0D, 0x10, 0x06, 0xF0,
  0xB8, 0x0D, 0x10, 0x05, 0xF0, 0xB8, 0x0D, 0x10, 0x05, 0xF0, 0xC8, 0x0D, 0x10, 0x04, 0xF0, 0xC8,
  0x0D, 0x10, 0x04, 0xF0, 0xC0, 0x18, 0x0D, 0x00, 0x03, 0x0E, 0xE0, 0xC0, 0x18, 0x0D, 0x00, 0x03,
  0x0E, 0xE0, 0xC0, 0x18, 0x0D, 0x00, 0x03, 0x0E, 0xE0, 0xD0, 0x18, 0x0D, 0x00, 0x02, 0x0E, 0xE0,
  0xD0, 0x18, 0x0D, 0x00, 0x02, 0x0E, 0xE0, 0xD0, 0x18, 0x0D, 0x00, 0x02, 0x0D, 0xE0, 0xD0, 0x18,
  0x0D, 0x00, 0x01, 0x0D, 0xE0, 0xD0, 0x28, 0x0D, 0x00, 0x01, 0x0D, 0xE0, 0xD0, 0x28, 0x0D, 0x00,
  0x01, 0x0C, 0xE0, 0xE0, 0x28, 0x0D, 0x00, 0x01, 0x0C, 0xE0, 0xE0, 0x28, 0x0D, 0x10, 0x0C, 0xE0,
  0xE0, 0x28, 0x0D, 0x10, 0x0B, 0xF0, 0x78, 0x0D, 0x03, 0x02, 0x07, 0x80, 0xE1, 0xF0, 0xB0, 0x78,
  0x0E, 0x1F, 0x0B, 0x07, 0x80, 0xE1, 0xF0, 0xB0, 0x78, 0x0E, 0x1F, 0x0B, 0x07, 0x80, 0xE1, 0xF0,
  0xB0, 0x78, 0x0E, 0x1F, 0x0B,
  // "3" (U+0033)
  0x77, 0x58, 0x97, 0x25, 0x79, 0xBB, 0xDD, 0xDD, 0xCB, 0xA9, 0x74, 0x27, 0x77, 0x77, 0x81, 0x48,
  0xCF, 0xFC, 0x81, 0xEA, 0x57, 0x77, 0x71, 0x81, 0x39, 0xEF, 0xFF, 0xB8, 0x1E, 0x92, 0x77, 0x73,
  0x06, 0x0C, 0xFF, 0xFF, 0xA0, 0xA0, 0x27, 0x76, 0x07, 0x0E, 0xFF, 0xFF, 0xE0, 0x77, 0x73, 0x07,
  0x0E, 0x80, 0xC1, 0xF0, 0xB0, 0x17, 0x60, 0x40, 0xDF, 0xF8, 0x95, 0xC9, 0x75, 0x33, 0x21, 0x12,
  0x35, 0x8A, 0xEF, 0xC0, 0xC0, 0x17, 0x40, 0x9F, 0xD8, 0x1D, 0x83, 0x77, 0x28, 0x13, 0x9E, 0xFA,
  0x0D, 0x01, 0x71, 0x03, 0x0D, 0xFB, 0x81, 0xE8, 0x27, 0x77, 0x81, 0x17, 0xEF, 0x90, 0xB7, 0x10,
  0x6F, 0xA0, 0xD0, 0x67, 0x77, 0x50, 0x10, 0xBF, 0x90, 0x77, 0x10, 0xAE, 0x0D, 0x05, 0x77, 0x77,
  0x20, 0x9F, 0x90, 0x27, 0x01, 0x0D, 0xB0, 0xE0, 0x77, 0x77, 0x75, 0x09, 0xF0, 0xA7, 0x10, 0x3A,
  0x0A, 0x01, 0x77, 0x77, 0x70, 0xCF, 0x02, 0x71, 0x06, 0x04, 0x80, 0xC1, 0x00, 0x2F, 0x08, 0x80,
  0xD4, 0x00, 0x9E, 0x0E, 0x80, 0xD4, 0x00, 0x3F, 0x02, 0x80, 0xD4, 0x00, 0xDE, 0x06, 0x80, 0xD4,
  0x00, 0x9E, 0x08, 0x80, 0xD4, 0x00, 0x7E, 0x0A, 0x80, 0xD4, 0x00, 0x5E, 0x0B, 0x80, 0xD4, 0x00,
  0x4E, 0x0C, 0x80, 0xD4, 0x00, 0x3E, 0x0C, 0x80, 0xD4, 0x00, 0x4E, 0x0C, 0x80, 0xD4, 0x00, 0x5E,
  0x0B, 0x80, 0xD4, 0x00, 0x7E, 0x09, 0x80, 0xD4, 0x00, 0x9E, 0x07, 0x80, 0xD4, 0x00, 0xDE, 0x03,
  0x80, 0xD3, 0x00, 0x2E, 0x0E, 0x80, 0xD4, 0x00, 0x8E, 0x0A, 0x80, 0xD4, 0x00, 0xEE, 0x04, 0x80,
  0xD3, 0x00, 0x8E, 0x0D, 0x80, 0xD3, 0x00, 0x3F, 0x05, 0x80, 0xD2, 0x00, 0x10, 0xDE, 0x0B, 0x80,
  0xD2, 0x00, 0x10, 0xDE, 0x0E, 0x02, 0x80, 0xD1, 0x00, 0x30, 0xDF, 0x04, 0x80, 0xD1, 0x00, 0x7F,
  0x90, 0x58, 0x0D, 0x00, 0x05, 0x0D, 0xF0, 0xE0, 0x58, 0x0C, 0x60, 0x81, 0x16, 0xDF, 0x90, 0xD0,
  0x38, 0x0C, 0x40, 0x81, 0x37, 0xBF, 0xB0, 0x97, 0x77, 0x40, 0x28, 0x05, 0x58, 0x46, 0x77, 0x9A,
  0xCF, 0xD0, 0xA0, 0x37, 0x77, 0x50, 0x6F, 0xFF, 0xB8, 0x1E, 0x82, 0x77, 0x77, 0x06, 0xFF, 0xF8,
  0x1B, 0x73, 0x77, 0x77, 0x30, 0x6F, 0xFE, 0x82, 0xE8, 0x63, 0x77, 0x77, 0x30, 0x6F, 0xFF, 0xC8,
  0x1C, 0x73, 0x77, 0x76, 0x06, 0xFF, 0xFF, 0x81, 0xD7, 0x17, 0x77, 0x30, 0x38, 0x09, 0x09, 0x81,
  0xBC, 0xDF, 0xF9, 0x0E, 0x08, 0x80, 0xC4, 0x08, 0x32, 0x47, 0xAE, 0xFC, 0x0E, 0x05, 0x80, 0xC7,
  0x08, 0x13, 0x7D, 0xFB, 0x09, 0x80, 0xD1, 0x00, 0x40, 0xAF, 0xA0, 0xB8, 0x0D, 0x20, 0x03, 0x0B,
  0xF9, 0x0B, 0x80, 0xD3, 0x00, 0x6F, 0x90, 0x88, 0x0D, 0x30, 0x03, 0x0E, 0xF0, 0x48, 0x0D, 0x30,
  0x03, 0xF0, 0xD8, 0x0D, 0x40, 0x06, 0xF0, 0x68, 0x0D, 0x40, 0x0B, 0xE0, 0xD8, 0x0D, 0x40, 0x03,
  0xF0, 0x48, 0x0D, 0x40, 0x0C, 0xE0, 0x98, 0x0D, 0x40, 0x07, 0xE0, 0xD8, 0x0D, 0x40, 0x03, 0xF0,
  0x18, 0x0D, 0x40, 0xF0, 0x38, 0x0D, 0x40, 0x0D, 0xE0, 0x58, 0x0D, 0x40, 0x0C, 0xE0, 0x68, 0x0D,
  0x40, 0x0B, 0xE0, 0x78, 0x0D, 0x40, 0x0B, 0xE0, 0x78, 0x0D, 0x40, 0x0C, 0xE0, 0x68, 0x0D, 0x40,
  0x0D, 0xE0, 0x58, 0x0D, 0x40, 0xF0, 0x48, 0x0D, 0x30, 0x02, 0xF0, 0x28, 0x0D, 0x30, 0x06, 0xE0,
  0xE8, 0x0D, 0x40, 0x0A, 0xE0, 0xB8, 0x0D, 0x40, 0xF0, 0x78, 0x0D, 0x30, 0x07, 0xF0, 0x28, 0x0D,
  0x30, 0x0E, 0xE0, 0xC8, 0x0D, 0x30, 0x08, 0xF0, 0x68, 0x0D, 0x20, 0x03, 0xF0, 0xD8, 0x0D, 0x20,
  0x01, 0x0E, 0xF0, 0x58, 0x0D, 0x10, 0x02, 0x0D, 0xF0, 0xB4, 0x81, 0x7B, 0x48, 0x0C, 0x20, 0x03,
  0x0D, 0xF0, 0xE0, 0x24, 0x07, 0xA8, 0x1D, 0x71, 0x77, 0x77, 0x60, 0x7F, 0xA0, 0x45, 0x07, 0xD8,
  0x1C, 0x72, 0x77, 0x77, 0x10, 0x50, 0xDF, 0xA0, 0x66, 0x07, 0xF9, 0x82, 0xD9, 0x41, 0x77, 0x71,
  0x81, 0x28, 0xDF, 0xB0, 0x67, 0x07, 0xFD, 0x83, 0xDA, 0x74, 0x27, 0x58, 0x31, 0x36, 0xAD, 0xFD,
  0x05, 0x71, 0x07, 0xFF, 0xC0, 0xE0, 0xD8, 0x02, 0xB0, 0xC0, 0xDF, 0xFA, 0x0D, 0x03, 0x72, 0x03,
  0x0D, 0x80, 0xC6, 0xF0, 0x87, 0x60, 0x40, 0xA8, 0x0C, 0x2F, 0x0A, 0x02, 0x77, 0x28, 0x11, 0x6B,
  0xFF, 0xFF, 0xC8, 0x1D, 0x82, 0x77, 0x71, 0x81, 0x58, 0xCF, 0xFF, 0xC8, 0x1C, 0x84, 0x77, 0x77,
  0x18, 0x43, 0x58, 0xAB, 0xDF, 0xD8, 0x4D, 0xB9, 0x64, 0x18, 0x0C, 0x40, 0x0F, 0x10, 0x20, 0x30,
  0xF1, 0x77, 0x77,
  // "4" (U+0034)
  0x80, 0xC7, 0x08, 0x03, 0x18, 0x0E, 0x50, 0x02, 0x0E, 0xE0, 0x68, 0x0E, 0x40, 0x0C, 0xF0, 0x68,
  0x0E, 0x30, 0x08, 0xF9, 0x06, 0x80, 0xE2, 0x00, 0x4F, 0xA0, 0x68, 0x0E, 0x10, 0x01, 0x0D, 0xFA,
  0x06, 0x80, 0xE1, 0x00, 0xAF, 0xB0, 0x68, 0x0E, 0x00, 0x06, 0xFC, 0x06, 0x80, 0xD7, 0x00, 0x2D,
  0x0C, 0x0E, 0xD0, 0x68, 0x0D, 0x70, 0x0C, 0xD0, 0x20, 0xED, 0x06, 0x80, 0xD6, 0x00, 0x9D, 0x08,
  0x1E, 0x06, 0x80, 0xD5, 0x00, 0x4D, 0x0D, 0x2E, 0x06, 0x80, 0xD4, 0x00, 0x10, 0xED, 0x05, 0x2E,
  0x06, 0x80, 0xD4, 0x00, 0xBD, 0x0B, 0x3E, 0x06, 0x80, 0xD3, 0x00, 0x7E, 0x02, 0x3E, 0x06, 0x80,
  0xD2, 0x00, 0x3E, 0x07, 0x30, 0x1E, 0x06, 0x80, 0xD2, 0x00, 0xDD, 0x0C, 0x40, 0x1E, 0x06, 0x80,
  0xD1, 0x00, 0x9E, 0x03, 0x40, 0x1E, 0x06, 0x80, 0xD0, 0x00, 0x5E, 0x07, 0x50, 0x1E, 0x06, 0x80,
  0xC7, 0x00, 0x10, 0xED, 0x0C, 0x60, 0x2E, 0x06, 0x80, 0xC7, 0x00, 0xBD, 0x0E, 0x02, 0x60, 0x2E,
  0x06, 0x80, 0xC6, 0x00, 0x7E, 0x05, 0x70, 0x2E, 0x06, 0x80, 0xC5, 0x00, 0x3E, 0x09, 0x71, 0x02,
  0xE0, 0x68, 0x0C, 0x50, 0x0D, 0xD0, 0xD7, 0x20, 0x2E, 0x06, 0x80, 0xC4, 0x00, 0x9E, 0x03, 0x72,
  0x02, 0xE0, 0x68, 0x0C, 0x30, 0x05, 0xE0, 0x77, 0x30, 0x2E, 0x06, 0x80, 0xC2, 0x00, 0x20, 0xED,
  0x0B, 0x74, 0x02, 0xE0, 0x68, 0x0C, 0x20, 0x0C, 0xD0, 0xE0, 0x17, 0x40, 0x2E, 0x06, 0x80, 0xC1,
  0x00, 0x7E, 0x04, 0x75, 0x02, 0xE0, 0x68, 0x0C, 0x00, 0x03, 0xE0, 0x87, 0x60, 0x2E, 0x06, 0x77,
  0x77, 0x70, 0x10, 0xDD, 0x0C, 0x77, 0x02, 0xE0, 0x67, 0x77, 0x77, 0x0A, 0xD0, 0xE0, 0x27, 0x70,
  0x2E, 0x06, 0x77, 0x77, 0x60, 0x5E, 0x06, 0x77, 0x10, 0x2E, 0x06, 0x77, 0x77, 0x50, 0x20, 0xED,
  0x0A, 0x77, 0x20, 0x2E, 0x06, 0x77, 0x77, 0x50, 0xCD, 0x0D, 0x01, 0x77, 0x20, 0x2E, 0x06, 0x77,
  0x77, 0x40, 0x8E, 0x03, 0x77, 0x30, 0x2E, 0x06, 0x77, 0x77, 0x30, 0x4E, 0x07, 0x77, 0x40, 0x2E,
  0x06, 0x77, 0x77, 0x20, 0x10, 0xDD, 0x0B, 0x77, 0x50, 0x2E, 0x06, 0x77, 0x77, 0x20, 0xAD, 0x0E,
  0x01, 0x77, 0x50, 0x2E, 0x06, 0x77, 0x77, 0x10, 0x6E, 0x05, 0x77, 0x60, 0x2E, 0x06, 0x77, 0x77,
  0x02, 0x0E, 0xD0, 0x97, 0x77, 0x02, 0xE0, 0x67, 0x77, 0x70, 0xCD, 0x0D, 0x77, 0x71, 0x02, 0xE0,
  0x67, 0x77, 0x60, 0x8E, 0x03, 0x77, 0x71, 0x02, 0xE0, 0x67, 0x77, 0x50, 0x4E, 0x06, 0x77, 0x72,
  0x02, 0xE0, 0x67, 0x77, 0x40, 0x10, 0xED, 0x0B, 0x77, 0x73, 0x02, 0xE0, 0x67, 0x77, 0x40, 0xBD,
  0x0E, 0x01, 0x77, 0x73, 0x02, 0xE0, 0x67, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x74, 0x02, 0xE0, 0x67,
  0x77, 0x20, 0x2E, 0x08, 0x77, 0x75, 0x02, 0xE0, 0x67, 0x77, 0x20, 0xDD, 0x0C, 0x77, 0x76, 0x02,
  0xE0, 0x67, 0x77, 0x10, 0x9D, 0x0E, 0x02, 0x77, 0x76, 0x02, 0xE0, 0x67, 0x77, 0x04, 0xE0, 0x67,
  0x77, 0x70, 0x2E, 0x06, 0x77, 0x60, 0x10, 0xED, 0x0A, 0x77, 0x77, 0x10, 0x2E, 0x06, 0x77, 0x60,
  0xBD, 0x0D, 0x01, 0x77, 0x77, 0x10, 0x2E, 0x06, 0x77, 0x50, 0x7E, 0x03, 0x77, 0x77, 0x20, 0x2E,
  0x06, 0x77, 0x40, 0x3E, 0x07, 0x77, 0x77, 0x30, 0x2E, 0x06, 0x77, 0x40, 0xDD, 0x0B, 0x77, 0x77,
  0x40, 0x2E, 0x06, 0x77, 0x30, 0x9D, 0x0E, 0x01, 0x77, 0x77, 0x40, 0x2E, 0x06, 0x77, 0x20, 0x5E,
  0x05, 0x77, 0x77, 0x50, 0x2E, 0x06, 0x77, 0x10, 0x10, 0xED, 0x09, 0x77, 0x77, 0x60, 0x2E, 0x06,
  0x77, 0x10, 0xBE, 0x0A, 0x80, 0xB6, 0x90, 0xAE, 0x0C, 0x80, 0x91, 0x90, 0x60, 0x38, 0x0F, 0x3F,
  0x0B, 0x03, 0x80, 0xF3, 0xF0, 0xB0, 0x38, 0x0F, 0x3F, 0x0B, 0x03, 0x80, 0xF3, 0xF0, 0xB0, 0x38,
  0x0F, 0x3F, 0x0B, 0x02, 0x80, 0xC6, 0x90, 0xAE, 0x0C, 0x80, 0x91, 0x90, 0x68, 0x0C, 0x70, 0x02,
  0xE0, 0x68, 0x0E, 0x50, 0x02, 0xE0, 0x68, 0x0E, 0x50, 0x02, 0xE0, 0x68, 0x0E, 0x50, 0x02, 0xE0,
  0x68, 0x0E, 0x50, 0x02, 0xE0, 0x68, 0x0E, 0x50, 0x02, 0xE0, 0x68, 0x0E, 0x50, 0x02, 0xE0, 0x68,
  0x0E, 0x50, 0x02, 0xE0, 0x68, 0x0E, 0x50, 0x02, 0xE0, 0x68, 0x0E, 0x50, 0x02, 0xE0, 0x68, 0x0E,
  0x50, 0x02, 0xE0, 0x68, 0x0E, 0x50, 0x02, 0xE0, 0x68, 0x0E, 0x50, 0x02, 0xE0, 0x68, 0x0E, 0x50,
  0x02, 0xE0, 0x68, 0x0E, 0x50, 0x02, 0xE0, 0x68, 0x0E, 0x50, 0x02, 0xE0, 0x68, 0x0E, 0x50, 0x02,
  0xE0, 0x68, 0x0E, 0x50, 0x02, 0xE0, 0x68, 0x0E, 0x50, 0x02, 0xE0, 0x68, 0x0E, 0x50, 0x02, 0xE0,
  0x68, 0x0E, 0x50, 0x02, 0xE0, 0x67, 0x70,
  // "5" (U+0035)
  0x60, 0xA8, 0x0C, 0x4B, 0x07, 0x75, 0x0E, 0x80, 0xC4, 0xF0, 0xA7, 0x58, 0x0C, 0x5F, 0x0A, 0x74,
  0x01, 0x80, 0xC5, 0xF0, 0xA7, 0x40, 0x38, 0x0C, 0x5F, 0x0A, 0x74, 0x04, 0x80, 0xC5, 0xF0, 0xA7,
  0x40, 0x5D, 0x0E, 0x80, 0xB7, 0x70, 0x57, 0x40, 0x7D, 0x0D, 0x80, 0xD3, 0x00, 0x8D, 0x0B, 0x80,
  0xD3, 0x00, 0xAD, 0x0A, 0x80, 0xD3, 0x00, 0xBD, 0x09, 0x80, 0xD3, 0x00, 0xCD, 0x08, 0x80, 0xD3,
  0x00, 0xED, 0x06, 0x80, 0xD3, 0x0E, 0x05, 0x80, 0xD2, 0x00, 0x1E, 0x04, 0x80, 0xD2, 0x00, 0x2E,
  0x03, 0x80, 0xD2, 0x00, 0x4E, 0x01, 0x80, 0xD2, 0x00, 0x5E, 0x80, 0xD3, 0x00, 0x6D, 0x0E, 0x80,
  0xD3, 0x00, 0x8D, 0x0D, 0x80, 0xD3, 0x00, 0x9D, 0x0C, 0x80, 0xD3, 0x00, 0xAD, 0x0A, 0x80, 0xD3,
  0x00, 0xCD, 0x09, 0x80, 0xD3, 0x00, 0xDD, 0x08, 0x80, 0xD3, 0x0E, 0x07, 0x80, 0xD3, 0x0E, 0x05,
  0x80, 0xD2, 0x00, 0x2E, 0x04, 0x80, 0xD2, 0x00, 0x3E, 0x03, 0x80, 0xD2, 0x00, 0x4E, 0x02, 0x80,
  0xD2, 0x00, 0x6E, 0x80, 0xD3, 0x00, 0x7E, 0x80, 0xD3, 0x00, 0x9D, 0x0D, 0x80, 0xD3, 0x00, 0xAD,
  0x0C, 0x80, 0xD3, 0x00, 0xBD, 0x0B, 0x80, 0xD3, 0x00, 0xDD, 0x09, 0x68, 0x97, 0x35, 0x79, 0xAB,
  0xBD, 0xDD, 0xBB, 0xA9, 0x75, 0x27, 0x77, 0x30, 0xED, 0x84, 0x81, 0x47, 0xAD, 0xFF, 0xD8, 0x1B,
  0x73, 0x77, 0x6F, 0xFF, 0xFE, 0x81, 0xD7, 0x17, 0x72, 0x01, 0x80, 0xC1, 0xF0, 0x80, 0x17, 0x70,
  0x38, 0x0C, 0x2F, 0x0E, 0x07, 0x76, 0x03, 0x80, 0xC4, 0xF0, 0xC0, 0x27, 0x50, 0x50, 0xEF, 0x98,
  0xA1, 0xDB, 0x98, 0x65, 0x33, 0x32, 0x13, 0x34, 0x57, 0x9C, 0xEF, 0xD0, 0xE0, 0x47, 0x50, 0x10,
  0xAA, 0x82, 0xC9, 0x63, 0x77, 0x68, 0x13, 0x7D, 0xFC, 0x05, 0x76, 0x03, 0x77, 0x77, 0x03, 0x0A,
  0xFB, 0x05, 0x80, 0xC7, 0x00, 0x30, 0xCF, 0xA0, 0x38, 0x0D, 0x00, 0x07, 0xF9, 0x0D, 0x01, 0x80,
  0xD0, 0x00, 0x5F, 0x90, 0x98, 0x0D, 0x10, 0x05, 0xF9, 0x03, 0x80, 0xD1, 0x00, 0x7F, 0x0B, 0x80,
  0xD2, 0x00, 0xBF, 0x03, 0x80, 0xD1, 0x00, 0x2F, 0x08, 0x80, 0xD2, 0x00, 0xAE, 0x0D, 0x80, 0xD2,
  0x00, 0x3F, 0x03, 0x80, 0xD2, 0x00, 0xDE, 0x06, 0x80, 0xD2, 0x00, 0x8E, 0x0A, 0x80, 0xD2, 0x00,
  0x5E, 0x0C, 0x80, 0xD2, 0x00, 0x1E, 0x0E, 0x80, 0xD3, 0x0F, 0x01, 0x80, 0xD2, 0x00, 0xDE, 0x01,
  0x80, 0xD2, 0x00, 0xCE, 0x02, 0x80, 0xD2, 0x00, 0xCE, 0x03, 0x80, 0xD2, 0x00, 0xCE, 0x02, 0x80,
  0xD2, 0x00, 0xCE, 0x01, 0x80, 0xD2, 0x00, 0xDE, 0x80, 0xD3, 0x0E, 0x0E, 0x80, 0xD2, 0x00, 0x2E,
  0x0C, 0x80, 0xD2, 0x00, 0x5E, 0x0A, 0x80, 0xD2, 0x00, 0x9E, 0x06, 0x80, 0xD2, 0x00, 0xDE, 0x03,
  0x80, 0xD1, 0x00, 0x3E, 0x0E, 0x80, 0xD2, 0x00, 0x9E, 0x09, 0x80, 0xD1, 0x00, 0x2F, 0x03, 0x80,
  0xD1, 0x00, 0xAE, 0x0C, 0x80, 0xD1, 0x00, 0x5F, 0x05, 0x80, 0xD0, 0x00, 0x20, 0xEE, 0x0C, 0x80,
  0xD0, 0x00, 0x20, 0xDF, 0x03, 0x40, 0x28, 0x0C, 0x20, 0x02, 0x0E, 0xF0, 0x95, 0x81, 0xDB, 0x27,
  0x77, 0x77, 0x06, 0x0E, 0xF0, 0xC6, 0x0D, 0xA0, 0xB0, 0x47, 0x77, 0x73, 0x02, 0x0B, 0xF9, 0x0E,
  0x01, 0x60, 0xDC, 0x81, 0xD8, 0x27, 0x77, 0x50, 0x20, 0x9F, 0xA0, 0xE0, 0x27, 0x0D, 0xF8, 0x1D,
  0x84, 0x77, 0x70, 0x50, 0xBF, 0xB0, 0xD0, 0x27, 0x10, 0xDF, 0xC8, 0x3C, 0x96, 0x42, 0x73, 0x82,
  0x25, 0x8B, 0xFD, 0x0B, 0x01, 0x72, 0x0D, 0xFF, 0xB8, 0x6E, 0xDD, 0xCC, 0xDD, 0xEF, 0xFA, 0x08,
  0x74, 0x07, 0x80, 0xC3, 0xF0, 0xC0, 0x37, 0x68, 0x11, 0x8E, 0xFF, 0xFF, 0xE0, 0xD0, 0x57, 0x74,
  0x81, 0x5A, 0xEF, 0xFF, 0xF9, 0x0B, 0x05, 0x77, 0x72, 0x81, 0x48, 0xCF, 0xFF, 0xA8, 0x1B, 0x71,
  0x77, 0x77, 0x18, 0x43, 0x69, 0xBD, 0xEF, 0xB8, 0x3D, 0xB9, 0x63, 0x80, 0xC4, 0x00, 0xF1, 0x03,
  0x02, 0x0F, 0x17, 0x77, 0x70,
  // "6" (U+0036)
  0x77, 0x77, 0x86, 0x14, 0x69, 0xAC, 0xDD, 0xC8, 0x6E, 0xDC, 0xB9, 0x64, 0x17, 0x77, 0x75, 0x81,
  0x49, 0xCF, 0xFE, 0x0D, 0x01, 0x77, 0x77, 0x81, 0x39, 0xEF, 0xFF, 0xB0, 0x27, 0x77, 0x50, 0x40,
  0xBF, 0xFF, 0xE0, 0x27, 0x77, 0x30, 0x20, 0xBF, 0xFF, 0xF9, 0x02, 0x77, 0x72, 0x07, 0xFF, 0xC8,
  0x00, 0xDF, 0xA0, 0x27, 0x77, 0x01, 0x0B, 0xFD, 0x83, 0xC9, 0x64, 0x27, 0x18, 0x61, 0x24, 0x6A,
  0xDF, 0x27, 0x76, 0x02, 0x0D, 0xFB, 0x81, 0xB6, 0x17, 0x75, 0x03, 0x77, 0x60, 0x30, 0xEF, 0x98,
  0x1E, 0x82, 0x80, 0xC6, 0x00, 0x30, 0xEF, 0x90, 0x90, 0x18, 0x0C, 0x70, 0x02, 0x0E, 0xF0, 0xD0,
  0x38, 0x0D, 0x00, 0x01, 0x0D, 0xF0, 0xA8, 0x0D, 0x20, 0x0B, 0xF0, 0x88, 0x0D, 0x20, 0x07, 0xF0,
  0x78, 0x0D, 0x20, 0x02, 0xF0, 0x98, 0x0D, 0x30, 0x0C, 0xE0, 0xB8, 0x0D, 0x30, 0x05, 0xE0, 0xE0,
  0x18, 0x0D, 0x30, 0x0D, 0xE0, 0x58, 0x0D, 0x30, 0x07, 0xE0, 0xB8, 0x0D, 0x40, 0x0D, 0xE0, 0x28,
  0x0D, 0x30, 0x05, 0xE0, 0x98, 0x0D, 0x40, 0x0C, 0xE0, 0x28, 0x0D, 0x30, 0x02, 0xE0, 0xA8, 0x0D,
  0x40, 0x08, 0xE0, 0x48, 0x0D, 0x40, 0x0D, 0xD0, 0xD8, 0x0D, 0x40, 0x03, 0xE0, 0x78, 0x0D, 0x40,
  0x07, 0xE0, 0x28, 0x0D, 0x40, 0x0C, 0xD0, 0xD8, 0x0D, 0x50, 0xE0, 0x88, 0x0D, 0x40, 0x04, 0xE0,
  0x48, 0x0D, 0x40, 0x08, 0xE8, 0x0D, 0x50, 0x0B, 0xD0, 0xC8, 0x0D, 0x50, 0x0E, 0xD0, 0x88, 0x0D,
  0x40, 0x02, 0xE0, 0x67, 0x75, 0x80, 0x11, 0x77, 0x73, 0x04, 0xE0, 0x37, 0x68, 0x24, 0x8A, 0xDF,
  0x98, 0x3D, 0xB8, 0x51, 0x77, 0x40, 0x7E, 0x01, 0x73, 0x06, 0x0B, 0xFF, 0xC8, 0x1C, 0x71, 0x77,
  0x10, 0x9D, 0x0D, 0x72, 0x07, 0x0E, 0xFF, 0xFA, 0x09, 0x01, 0x76, 0x0B, 0xD0, 0xC7, 0x04, 0x0D,
  0xFF, 0xFD, 0x0E, 0x07, 0x75, 0x0D, 0xD0, 0xA6, 0x08, 0xFF, 0xFF, 0xA0, 0xC0, 0x27, 0x3E, 0x08,
  0x40, 0x10, 0xCF, 0xB8, 0x91, 0xDB, 0x98, 0x77, 0x78, 0xAC, 0xEF, 0xC0, 0xE0, 0x37, 0x10, 0x1E,
  0x07, 0x30, 0x20, 0xDF, 0x81, 0xD9, 0x47, 0x58, 0x12, 0x7C, 0xFB, 0x04, 0x70, 0x2E, 0x05, 0x20,
  0x20, 0xDE, 0x0B, 0x04, 0x77, 0x40, 0x30, 0xAF, 0xA0, 0x36, 0x04, 0xE8, 0x25, 0x01, 0xDD, 0x0D,
  0x04, 0x77, 0x71, 0x04, 0x0D, 0xF0, 0xE0, 0x25, 0x05, 0xE8, 0x14, 0x0B, 0xD0, 0x87, 0x77, 0x40,
  0x10, 0xBF, 0x0C, 0x50, 0x6E, 0x03, 0x06, 0xC0, 0xE0, 0x47, 0x77, 0x70, 0xBF, 0x07, 0x40, 0x6E,
  0x04, 0x0E, 0xB0, 0xE0, 0x27, 0x77, 0x72, 0x0C, 0xE0, 0xE0, 0x13, 0x07, 0xFB, 0x0E, 0x02, 0x77,
  0x77, 0x30, 0x20, 0xEE, 0x08, 0x30, 0x7F, 0xB0, 0x47, 0x77, 0x75, 0x07, 0xE0, 0xE3, 0x08, 0xFA,
  0x07, 0x77, 0x77, 0x70, 0xDE, 0x06, 0x20, 0x8F, 0x90, 0xD8, 0x0C, 0x00, 0x06, 0xE0, 0xC2, 0x08,
  0xF9, 0x04, 0x80, 0xC0, 0x00, 0x1F, 0x81, 0x10, 0x8F, 0x0C, 0x80, 0xC2, 0x00, 0xAE, 0x81, 0x50,
  0x8F, 0x06, 0x80, 0xC2, 0x00, 0x6E, 0x81, 0x80, 0x7F, 0x01, 0x80, 0xC2, 0x00, 0x2E, 0x81, 0xB0,
  0x6E, 0x0D, 0x80, 0xC4, 0x0E, 0x81, 0xE0, 0x5E, 0x0B, 0x80, 0xC4, 0x00, 0xCE, 0x10, 0x4E, 0x0A,
  0x80, 0xC4, 0x00, 0xBE, 0x02, 0x03, 0xE0, 0xA8, 0x0C, 0x40, 0x09, 0xE0, 0x30, 0x1E, 0x0A, 0x80,
  0xC4, 0x00, 0x9E, 0x81, 0x30, 0xED, 0x0C, 0x80, 0xC4, 0x00, 0x8E, 0x81, 0x40, 0xCD, 0x0D, 0x80,
  0xC4, 0x00, 0x9E, 0x81, 0x30, 0x9E, 0x80, 0xC4, 0x00, 0x9E, 0x81, 0x30, 0x6E, 0x03, 0x80, 0xC3,
  0x00, 0xAE, 0x81, 0x20, 0x3E, 0x06, 0x80, 0xC3, 0x00, 0xBE, 0x01, 0x20, 0xED, 0x09, 0x80, 0xC3,
  0x00, 0xDE, 0x30, 0xBD, 0x0D, 0x80, 0xC3, 0x0E, 0x0D, 0x30, 0x6E, 0x03, 0x80, 0xC1, 0x00, 0x2E,
  0x0A, 0x30, 0x2E, 0x08, 0x80, 0xC1, 0x00, 0x6E, 0x07, 0x40, 0xCD, 0x0D, 0x80, 0xC1, 0x00, 0xAE,
  0x04, 0x40, 0x7E, 0x04, 0x80, 0xC0, 0x00, 0xEE, 0x50, 0x1E, 0x0C, 0x77, 0x77, 0x70, 0x4E, 0x0B,
  0x60, 0x9E, 0x04, 0x77, 0x77, 0x60, 0xAE, 0x06, 0x60, 0x2E, 0x0C, 0x77, 0x77, 0x50, 0x2F, 0x01,
  0x70, 0xAE, 0x07, 0x77, 0x77, 0x40, 0xAE, 0x0A, 0x71, 0x02, 0xF0, 0x27, 0x77, 0x72, 0x04, 0xF0,
  0x37, 0x20, 0x8E, 0x0D, 0x01, 0x77, 0x77, 0x01, 0x0E, 0xE0, 0xA7, 0x40, 0xDE, 0x0C, 0x77, 0x77,
  0x0C, 0xF0, 0x27, 0x40, 0x4F, 0x0C, 0x01, 0x77, 0x73, 0x01, 0x0C, 0xF0, 0x77, 0x60, 0x7F, 0x0D,
  0x02, 0x77, 0x71, 0x02, 0x0D, 0xF0, 0xB7, 0x71, 0x0A, 0xF9, 0x06, 0x77, 0x60, 0x70, 0xEF, 0x0D,
  0x01, 0x77, 0x20, 0xBF, 0x90, 0xC0, 0x47, 0x72, 0x06, 0x0D, 0xF9, 0x0E, 0x03, 0x77, 0x40, 0xBF,
  0xA8, 0x1D, 0x84, 0x72, 0x82, 0x25, 0xAE, 0xFA, 0x0E, 0x03, 0x77, 0x60, 0x9F, 0xD8, 0x5E, 0xCB,
  0xBB, 0xBD, 0xFE, 0x0D, 0x02, 0x77, 0x71, 0x06, 0xFF, 0xFF, 0xA0, 0xB0, 0x17, 0x77, 0x30, 0x20,
  0xCF, 0xFF, 0xD0, 0xE0, 0x57, 0x77, 0x70, 0x50, 0xDF, 0xFF, 0x98, 0x1E, 0x71, 0x77, 0x77, 0x30,
  0x40, 0xAF, 0xFC, 0x0B, 0x05, 0x80, 0xC1, 0x08, 0x24, 0x8B, 0xEF, 0x98, 0x2D, 0xB8, 0x48, 0x0D,
  0x10, 0x84, 0x11, 0x32, 0x11, 0x77, 0x73,
  // "7" (U+0037)
  0x0A, 0x80, 0xE2, 0xB0, 0xA0, 0xD8, 0x0E, 0x2F, 0x0E, 0x0D, 0x80, 0xE2, 0xF0, 0xE0, 0xD8, 0x0E,
  0x2F, 0x0E, 0x0D, 0x80, 0xE2, 0xF0, 0xE0, 0xD8, 0x0E, 0x2F, 0x0C, 0x06, 0x80, 0xD3, 0x70, 0xCE,
  0x06, 0x80, 0xD4, 0x00, 0xED, 0x0E, 0x80, 0xD4, 0x00, 0x5E, 0x08, 0x80, 0xD4, 0x00, 0xCE, 0x01,
  0x80, 0xD3, 0x00, 0x4E, 0x0A, 0x80, 0xD4, 0x00, 0xAE, 0x03, 0x80, 0xD3, 0x00, 0x2E, 0x0C, 0x80,
  0xD4, 0x00, 0x9E, 0x05, 0x80, 0xD3, 0x00, 0x10, 0xED, 0x0D, 0x80, 0xD4, 0x00, 0x7E, 0x07, 0x80,
  0xD4, 0x00, 0xDD, 0x0E, 0x01, 0x80, 0xD3, 0x00, 0x5E, 0x09, 0x80, 0xD4, 0x00, 0xCE, 0x02, 0x80,
  0xD3, 0x00, 0x4E, 0x0B, 0x80, 0xD4, 0x00, 0xAE, 0x04, 0x80, 0xD3, 0x00, 0x2E, 0x0D, 0x80, 0xD4,
  0x00, 0x9E, 0x06, 0x80, 0xD3, 0x00, 0x10, 0xED, 0x0E, 0x80, 0xD4, 0x00, 0x7E, 0x08, 0x80, 0xD4,
  0x00, 0xDE, 0x01, 0x80, 0xD3, 0x00, 0x5E, 0x0A, 0x80, 0xD4, 0x00, 0xCE, 0x03, 0x80, 0xD3, 0x00,
  0x4E, 0x0C, 0x80, 0xD4, 0x00, 0xAE, 0x05, 0x80, 0xD3, 0x00, 0x2E, 0x0D, 0x80, 0xD4, 0x00, 0x9E,
  0x07, 0x80, 0xD3, 0x00, 0x10, 0xED, 0x0E, 0x01, 0x80, 0xD3, 0x00, 0x7E, 0x09, 0x80, 0xD4, 0x00,
  0xDE, 0x02, 0x80, 0xD3, 0x00, 0x5E, 0x0B, 0x80, 0xD4, 0x00, 0xCE, 0x04, 0x80, 0xD3, 0x00, 0x3E,
  0x0D, 0x80, 0xD4, 0x00, 0xAE, 0x06, 0x80, 0xD3, 0x00, 0x2E, 0x0E, 0x80, 0xD4, 0x00, 0x9E, 0x08,
  0x80, 0xD3, 0x00, 0x10, 0xEE, 0x01, 0x80, 0xD3, 0x00, 0x7E, 0x0A, 0x80, 0xD4, 0x00, 0xDE, 0x03,
  0x80, 0xD3, 0x00, 0x5E, 0x0C, 0x80, 0xD4, 0x00, 0xCE, 0x05, 0x80, 0xD3, 0x00, 0x3E, 0x0D, 0x80,
  0xD4, 0x00, 0xAE, 0x07, 0x80, 0xD3, 0x00, 0x2E, 0x0E, 0x01, 0x80, 0xD3, 0x00, 0x9E, 0x09, 0x80,
  0xD3, 0x00, 0x10, 0xEE, 0x02, 0x80, 0xD3, 0x00, 0x7E, 0x0B, 0x80, 0xD4, 0x00, 0xDE, 0x04, 0x80,
  0xD3, 0x00, 0x5E, 0x0D, 0x80, 0xD4, 0x00, 0xCE, 0x06, 0x80, 0xD3, 0x00, 0x3E, 0x0E, 0x80, 0xD4,
  0x00, 0xAE, 0x08, 0x80, 0xD3, 0x00, 0x2F, 0x01, 0x80, 0xD3, 0x00, 0x9E, 0x0A, 0x80, 0xD3, 0x00,
  0x10, 0xEE, 0x03, 0x80, 0xD3, 0x00, 0x7E, 0x0C, 0x80, 0xD4, 0x00, 0xDE, 0x05, 0x80, 0xD3, 0x00,
  0x5E, 0x0D, 0x80, 0xD4, 0x00, 0xCE, 0x07, 0x80, 0xD3, 0x00, 0x3E, 0x0E, 0x01, 0x80, 0xD3, 0x00,
  0xAE, 0x09, 0x80, 0xD3, 0x00, 0x2F, 0x02, 0x80, 0xD3, 0x00, 0x9E, 0x0B, 0x80, 0xD3, 0x00, 0x10,
  0xEE, 0x04, 0x80, 0xD3, 0x00, 0x7E, 0x0D, 0x80, 0xD4, 0x00, 0xDE, 0x06, 0x80, 0xD3, 0x00, 0x5E,
  0x0E, 0x80, 0xD4, 0x00, 0xCE, 0x08, 0x80, 0xD3, 0x00, 0x3F, 0x01, 0x80, 0xD3, 0x00, 0xAE, 0x0A,
  0x80, 0xD3, 0x00, 0x2F, 0x03, 0x80, 0xD3, 0x00, 0x8E, 0x0C, 0x80, 0xD3, 0x00, 0x10, 0xEE, 0x05,
  0x80, 0xD3, 0x00, 0x7E, 0x0D, 0x80, 0xD4, 0x00, 0xDE, 0x07, 0x80, 0xD3, 0x00, 0x5E, 0x0E, 0x01,
  0x80, 0xD3, 0x00, 0xCE, 0x09, 0x80, 0xD3, 0x00, 0x3F, 0x02, 0x80, 0xD3, 0x00, 0xAE, 0x0B, 0x80,
  0xD3, 0x00, 0x2F, 0x04, 0x80, 0xD3, 0x00, 0x8E, 0x0D, 0x77, 0x77, 0x70,
  // "8" (U+0038)
  0x77, 0x78, 0x95, 0x46, 0x8A, 0xBC, 0xDD, 0xDB, 0xB9, 0x85, 0x28, 0x0C, 0x10, 0x81, 0x38, 0xCF,
  0xFA, 0x82, 0xEB, 0x61, 0x77, 0x77, 0x28, 0x11, 0x7D, 0xFF, 0xFA, 0x0B, 0x04, 0x77, 0x76, 0x07,
  0x0E, 0xFF, 0xFE, 0x0C, 0x03, 0x77, 0x72, 0x03, 0x0D, 0xFF, 0xFF, 0xB0, 0x97, 0x77, 0x07, 0xFF,
  0x98, 0x00, 0xDF, 0xF9, 0x0D, 0x02, 0x77, 0x40, 0x9F, 0xC8, 0x2B, 0x74, 0x16, 0x83, 0x13, 0x59,
  0xDF, 0xB0, 0xE0, 0x47, 0x72, 0x09, 0xFA, 0x0C, 0x06, 0x77, 0x28, 0x12, 0x8E, 0xF9, 0x0E, 0x03,
  0x77, 0x07, 0xF9, 0x0D, 0x05, 0x77, 0x60, 0x10, 0x8F, 0x90, 0xE0, 0x17, 0x50, 0x3F, 0x90, 0x97,
  0x77, 0x30, 0x30, 0xDF, 0x0B, 0x75, 0x0D, 0xF0, 0x77, 0x77, 0x50, 0x10, 0xDF, 0x05, 0x73, 0x06,
  0xF0, 0x77, 0x77, 0x70, 0x10, 0xDE, 0x0D, 0x73, 0x0D, 0xE0, 0xA7, 0x77, 0x72, 0x04, 0xF0, 0x47,
  0x10, 0x4E, 0x0E, 0x01, 0x77, 0x77, 0x30, 0xAE, 0x0A, 0x71, 0x09, 0xE0, 0x87, 0x77, 0x74, 0x03,
  0xE0, 0xE7, 0x10, 0xDE, 0x01, 0x77, 0x77, 0x50, 0xDE, 0x03, 0x60, 0x1E, 0x0C, 0x77, 0x77, 0x60,
  0x9E, 0x06, 0x60, 0x3E, 0x09, 0x77, 0x77, 0x60, 0x5E, 0x08, 0x60, 0x5E, 0x06, 0x77, 0x77, 0x60,
  0x3E, 0x09, 0x60, 0x5E, 0x05, 0x77, 0x77, 0x60, 0x2E, 0x0A, 0x60, 0x6E, 0x05, 0x77, 0x77, 0x60,
  0x2E, 0x0A, 0x60, 0x5E, 0x05, 0x77, 0x77, 0x60, 0x3E, 0x09, 0x60, 0x4E, 0x06, 0x77, 0x77, 0x60,
  0x4E, 0x08, 0x60, 0x2E, 0x08, 0x77, 0x77, 0x60, 0x7E, 0x06, 0x7E, 0x0C, 0x77, 0x77, 0x60, 0xAE,
  0x03, 0x70, 0xCE, 0x01, 0x77, 0x77, 0x50, 0xED, 0x0E, 0x71, 0x07, 0xE0, 0x77, 0x77, 0x74, 0x05,
  0xE0, 0xA7, 0x10, 0x2E, 0x0D, 0x77, 0x77, 0x40, 0xCE, 0x04, 0x72, 0x0A, 0xE0, 0x87, 0x77, 0x72,
  0x06, 0xE0, 0xC7, 0x30, 0x3F, 0x04, 0x77, 0x77, 0x03, 0x0E, 0xE0, 0x47, 0x40, 0x9E, 0x0E, 0x03,
  0x77, 0x75, 0x02, 0x0E, 0xE0, 0x97, 0x50, 0x10, 0xDE, 0x0E, 0x05, 0x77, 0x73, 0x03, 0x0E, 0xE0,
  0xC7, 0x70, 0x3F, 0x90, 0x97, 0x77, 0x10, 0x6F, 0x0D, 0x01, 0x77, 0x10, 0x5F, 0x90, 0xD0, 0x37,
  0x74, 0x01, 0x0A, 0xF0, 0xD0, 0x17, 0x73, 0x05, 0xFA, 0x09, 0x01, 0x77, 0x10, 0x50, 0xEF, 0x0B,
  0x01, 0x77, 0x50, 0x50, 0xEF, 0x98, 0x1E, 0x71, 0x74, 0x03, 0x0B, 0xF9, 0x09, 0x77, 0x71, 0x02,
  0x0D, 0xFA, 0x81, 0xE8, 0x17, 0x02, 0x0A, 0xF9, 0x0E, 0x05, 0x77, 0x74, 0x08, 0xFB, 0x81, 0xE9,
  0x33, 0x03, 0x0A, 0xFA, 0x0B, 0x01, 0x77, 0x76, 0x03, 0x0C, 0xFC, 0x81, 0xC7, 0xBF, 0xA0, 0xD0,
  0x57, 0x77, 0x73, 0x07, 0x0E, 0xFF, 0xD0, 0xE0, 0x77, 0x77, 0x76, 0x01, 0x08, 0xFF, 0xA8, 0x1E,
  0x71, 0x80, 0xC1, 0x00, 0x10, 0xAF, 0xE0, 0xE0, 0x38, 0x0C, 0x20, 0x03, 0x0A, 0xFF, 0xA0, 0xB0,
  0x47, 0x77, 0x76, 0x04, 0x0B, 0xFF, 0xE0, 0xC0, 0x57, 0x77, 0x72, 0x03, 0x0B, 0xFB, 0x0E, 0x0D,
  0xFD, 0x0C, 0x03, 0x77, 0x75, 0x01, 0x09, 0xFB, 0x0C, 0x06, 0x28, 0x14, 0x9E, 0xFC, 0x0A, 0x01,
  0x77, 0x72, 0x05, 0x0E, 0xFA, 0x0A, 0x03, 0x70, 0x50, 0xCF, 0xB0, 0xE0, 0x67, 0x76, 0x01, 0x0A,
  0xFA, 0x09, 0x02, 0x74, 0x03, 0x0A, 0xFB, 0x0B, 0x01, 0x77, 0x30, 0x30, 0xDF, 0x90, 0xB0, 0x27,
  0x71, 0x02, 0x09, 0xFA, 0x0E, 0x03, 0x77, 0x10, 0x40, 0xEF, 0x0E, 0x05, 0x77, 0x50, 0x20, 0xBF,
  0xA0, 0x67, 0x60, 0x4F, 0x90, 0xA0, 0x17, 0x77, 0x10, 0x50, 0xEF, 0x90, 0x77, 0x40, 0x30, 0xEF,
  0x06, 0x77, 0x74, 0x01, 0x0B, 0xF9, 0x07, 0x72, 0x01, 0x0D, 0xE0, 0xE0, 0x47, 0x77, 0x70, 0x7F,
  0x90, 0x57, 0x10, 0xAE, 0x0E, 0x03, 0x77, 0x77, 0x20, 0x5F, 0x0E, 0x02, 0x60, 0x5F, 0x03, 0x77,
  0x77, 0x40, 0x5F, 0x0B, 0x60, 0xEE, 0x07, 0x77, 0x77, 0x60, 0x7F, 0x05, 0x40, 0x7E, 0x0C, 0x80,
  0xC0, 0x00, 0xCE, 0x0C, 0x40, 0xDE, 0x04, 0x80, 0xC0, 0x00, 0x2F, 0x02, 0x20, 0x3E, 0x0D, 0x80,
  0xC2, 0x00, 0xAE, 0x08, 0x20, 0x8E, 0x07, 0x80, 0xC2, 0x00, 0x4E, 0x0C, 0x20, 0xBE, 0x03, 0x80,
  0xC3, 0x00, 0xEE, 0x20, 0xED, 0x0E, 0x80, 0xC4, 0x00, 0xAE, 0x02, 0x01, 0xE0, 0xC8, 0x0C, 0x40,
  0x07, 0xE0, 0x40, 0x2E, 0x0A, 0x80, 0xC4, 0x00, 0x5E, 0x05, 0x03, 0xE0, 0x98, 0x0C, 0x40, 0x04,
  0xE0, 0x60, 0x4E, 0x08, 0x80, 0xC4, 0x00, 0x4E, 0x06, 0x03, 0xE0, 0x98, 0x0C, 0x40, 0x05, 0xE0,
  0x60, 0x3E, 0x0A, 0x80, 0xC4, 0x00, 0x6E, 0x04, 0x01, 0xE0, 0xC8, 0x0C, 0x40, 0x08, 0xE8, 0x13,
  0x0E, 0xD0, 0xE8, 0x0C, 0x40, 0x0B, 0xE8, 0x11, 0x0C, 0xE0, 0x38, 0x0C, 0x30, 0xE0, 0xD2, 0x08,
  0xE0, 0x88, 0x0C, 0x20, 0x05, 0xE0, 0x92, 0x04, 0xE0, 0xD8, 0x0C, 0x20, 0x0B, 0xE0, 0x53, 0x0E,
  0xE0, 0x68, 0x0C, 0x00, 0x03, 0xE0, 0xE4, 0x09, 0xE0, 0xE0, 0x17, 0x77, 0x77, 0x0C, 0xE0, 0x84,
  0x02, 0xF0, 0xA7, 0x77, 0x76, 0x08, 0xF0, 0x15, 0x09, 0xF0, 0x77, 0x77, 0x74, 0x06, 0xF0, 0x86,
  0x01, 0x0E, 0xF0, 0x77, 0x77, 0x72, 0x06, 0xF0, 0xD7, 0x10, 0x4F, 0x90, 0x97, 0x77, 0x70, 0x9F,
  0x90, 0x37, 0x20, 0x7F, 0x90, 0xD0, 0x47, 0x77, 0x30, 0x50, 0xDF, 0x90, 0x57, 0x40, 0x9F, 0xA0,
  0xB0, 0x47, 0x76, 0x05, 0x0C, 0xFA, 0x06, 0x76, 0x08, 0xFB, 0x81, 0xD8, 0x47, 0x68, 0x21, 0x59,
  0xEF, 0xB0, 0x57, 0x71, 0x05, 0x0E, 0xFD, 0x81, 0xDB, 0x98, 0x01, 0x78, 0x28, 0x9B, 0xEF, 0xD0,
  0xD0, 0x37, 0x73, 0x02, 0x0C, 0xFF, 0xFF, 0xE0, 0xA0, 0x17, 0x76, 0x06, 0x0E, 0xFF, 0xFF, 0xA0,
  0xC0, 0x47, 0x77, 0x30, 0x60, 0xDF, 0xFF, 0xD0, 0xB0, 0x47, 0x77, 0x78, 0x13, 0x8D, 0xFF, 0xE8,
  0x1C, 0x71, 0x77, 0x77, 0x58, 0x41, 0x58, 0xAD, 0xEF, 0x98, 0x4E, 0xDA, 0x84, 0x18, 0x0C, 0x70,
  0x84, 0x11, 0x23, 0x11, 0x77, 0x74,
  // "9" (U+0039)
  0x77, 0x68, 0x94, 0x46, 0x9B, 0xCD, 0xDD, 0xDB, 0xA8, 0x52, 0x80, 0xC2, 0x08, 0x12, 0x7C, 0xFF,
  0x98, 0x1E, 0x94, 0x77, 0x77, 0x50, 0x40, 0xBF, 0xFF, 0x0D, 0x06, 0x77, 0x77, 0x10, 0x30, 0xCF,
  0xFF, 0xC0, 0xD0, 0x57, 0x77, 0x50, 0x9F, 0xFF, 0xF9, 0x0B, 0x01, 0x77, 0x71, 0x02, 0x0C, 0xFF,
  0xFF, 0xB0, 0xD0, 0x37, 0x76, 0x03, 0x0E, 0xFB, 0x89, 0x3E, 0xB8, 0x53, 0x21, 0x12, 0x36, 0x8C,
  0xFC, 0x04, 0x77, 0x40, 0x30, 0xEF, 0xA0, 0xA0, 0x47, 0x68, 0x11, 0x6D, 0xFA, 0x05, 0x77, 0x20,
  0x20, 0xEF, 0x90, 0xA0, 0x27, 0x74, 0x06, 0x0E, 0xF9, 0x04, 0x77, 0x10, 0xDF, 0x0E, 0x04, 0x77,
  0x70, 0x10, 0xBF, 0x0E, 0x02, 0x76, 0x0A, 0xF0, 0xC0, 0x17, 0x77, 0x30, 0x9F, 0x0C, 0x75, 0x04,
  0xF0, 0xB7, 0x77, 0x60, 0x8F, 0x08, 0x74, 0x0D, 0xE0, 0xD0, 0x17, 0x77, 0x70, 0x9F, 0x02, 0x72,
  0x07, 0xE0, 0xE0, 0x27, 0x77, 0x72, 0x0B, 0xE0, 0xB7, 0x20, 0xEE, 0x07, 0x77, 0x77, 0x30, 0x10,
  0xEE, 0x04, 0x70, 0x5E, 0x0D, 0x77, 0x77, 0x50, 0x6E, 0x0C, 0x70, 0xBE, 0x05, 0x77, 0x77, 0x60,
  0xCE, 0x03, 0x50, 0x1E, 0x0E, 0x77, 0x77, 0x70, 0x4E, 0x0A, 0x50, 0x6E, 0x08, 0x80, 0xC0, 0x00,
  0xCE, 0x01, 0x40, 0xAE, 0x03, 0x80, 0xC0, 0x00, 0x5E, 0x06, 0x40, 0xED, 0x0E, 0x80, 0xC2, 0x00,
  0xED, 0x0B, 0x30, 0x2E, 0x0B, 0x80, 0xC2, 0x00, 0xAE, 0x01, 0x20, 0x4E, 0x08, 0x80, 0xC2, 0x00,
  0x5E, 0x05, 0x20, 0x6E, 0x06, 0x80, 0xC2, 0x00, 0x1E, 0x09, 0x20, 0x8E, 0x04, 0x80, 0xC3, 0x00,
  0xDD, 0x0D, 0x20, 0x9E, 0x03, 0x80, 0xC3, 0x00, 0x9E, 0x20, 0xBE, 0x02, 0x80, 0xC3, 0x00, 0x7E,
  0x81, 0x30, 0xBE, 0x01, 0x80, 0xC3, 0x00, 0x4E, 0x81, 0x60, 0xBE, 0x01, 0x80, 0xC3, 0x00, 0x2E,
  0x81, 0x80, 0xBE, 0x01, 0x80, 0xC3, 0x00, 0x1E, 0x81, 0xA0, 0xAE, 0x02, 0x80, 0xC4, 0x0E, 0x81,
  0xC0, 0xAE, 0x03, 0x80, 0xC4, 0x0E, 0x81, 0xE0, 0x8E, 0x05, 0x80, 0xC3, 0x00, 0x1F, 0x10, 0x6E,
  0x07, 0x80, 0xC3, 0x00, 0x2F, 0x01, 0x04, 0xE0, 0xA8, 0x0C, 0x30, 0x06, 0xF0, 0x01, 0xE0, 0xD8,
  0x0C, 0x30, 0x0A, 0xF8, 0x12, 0x0E, 0xE0, 0x28, 0x0C, 0x10, 0x01, 0xF9, 0x81, 0x20, 0xAE, 0x07,
  0x80, 0xC1, 0x00, 0x7F, 0x98, 0x13, 0x05, 0xE0, 0xC8, 0x0C, 0x00, 0x01, 0x0E, 0xF9, 0x81, 0x20,
  0x1F, 0x04, 0x77, 0x77, 0x70, 0x9F, 0xA0, 0x22, 0x0A, 0xE0, 0xC7, 0x77, 0x76, 0x05, 0xFB, 0x02,
  0x20, 0x3F, 0x06, 0x77, 0x77, 0x40, 0x30, 0xEF, 0xB0, 0x23, 0x0B, 0xE0, 0xE0, 0x27, 0x77, 0x72,
  0x03, 0x0E, 0xB0, 0x0C, 0xE0, 0x13, 0x03, 0xF0, 0xD0, 0x17, 0x77, 0x70, 0x40, 0xEC, 0x03, 0x0A,
  0xE5, 0x08, 0xF0, 0xD0, 0x17, 0x77, 0x50, 0x7D, 0x81, 0x70, 0xBE, 0x60, 0xCF, 0x0E, 0x04, 0x77,
  0x72, 0x03, 0x0C, 0xD0, 0xB2, 0x0C, 0xD0, 0xE6, 0x02, 0x0E, 0xF9, 0x09, 0x01, 0x77, 0x50, 0x20,
  0xAE, 0x0C, 0x30, 0xDD, 0x0D, 0x70, 0x30, 0xEF, 0xA0, 0xA0, 0x47, 0x78, 0x11, 0x6B, 0xF0, 0xC0,
  0x13, 0x0E, 0xD0, 0xB7, 0x10, 0x30, 0xEF, 0xB8, 0x94, 0xEB, 0x86, 0x43, 0x21, 0x23, 0x57, 0x9C,
  0xFA, 0x0A, 0x5E, 0x0A, 0x72, 0x02, 0x0C, 0xFF, 0xFF, 0xB0, 0x75, 0x02, 0xE0, 0x87, 0x40, 0x8F,
  0xFF, 0xF0, 0xD0, 0x36, 0x04, 0xE0, 0x67, 0x50, 0x20, 0xBF, 0xFF, 0xB0, 0xE0, 0x77, 0x10, 0x5E,
  0x04, 0x77, 0x81, 0x3A, 0xEF, 0xFD, 0x0D, 0x07, 0x73, 0x08, 0xE0, 0x27, 0x73, 0x81, 0x59, 0xCF,
  0xD8, 0x2E, 0xA7, 0x27, 0x50, 0xBE, 0x77, 0x71, 0x89, 0x12, 0x45, 0x67, 0x77, 0x54, 0x31, 0x77,
  0x20, 0xDD, 0x0C, 0x80, 0xD5, 0x0E, 0x09, 0x80, 0xD4, 0x00, 0x4E, 0x06, 0x80, 0xD4, 0x00, 0x7E,
  0x03, 0x80, 0xD4, 0x00, 0xBE, 0x80, 0xD5, 0x00, 0xED, 0x0B, 0x80, 0xD4, 0x00, 0x4E, 0x07, 0x80,
  0xD4, 0x00, 0x9E, 0x03, 0x80, 0xD4, 0x00, 0xED, 0x0D, 0x80, 0xD4, 0x00, 0x4E, 0x09, 0x80, 0xD4,
  0x00, 0xAE, 0x04, 0x80, 0xD3, 0x00, 0x1E, 0x0D, 0x80, 0xD4, 0x00, 0x7E, 0x08, 0x80, 0xD3, 0x00,
  0x10, 0xEE, 0x02, 0x80, 0xD3, 0x00, 0x8E, 0x0A, 0x80, 0xD3, 0x00, 0x10, 0xEE, 0x03, 0x80, 0xD3,
  0x00, 0xAE, 0x0B, 0x80, 0xD3, 0x00, 0x5F, 0x02, 0x80, 0xD2, 0x00, 0x10, 0xEE, 0x09, 0x80, 0xD3,
  0x00, 0xBE, 0x0D, 0x01, 0x80, 0xD2, 0x00, 0xAF, 0x04, 0x80, 0xD2, 0x00, 0x9F, 0x09, 0x80, 0xD2,
  0x00, 0xAF, 0x0C, 0x80, 0xD1, 0x00, 0x20, 0xCF, 0x0D, 0x01, 0x80, 0xD0, 0x00, 0x7F, 0x90, 0xE0,
  0x28, 0x0C, 0x70, 0x05, 0x0D, 0xF9, 0x0D, 0x02, 0x80, 0xC5, 0x08, 0x11, 0x7D, 0xFA, 0x0D, 0x02,
  0x77, 0x58, 0x33, 0xEA, 0x63, 0x77, 0x18, 0x14, 0x7C, 0xFC, 0x0B, 0x77, 0x70, 0x3D, 0x81, 0xDB,
  0x98, 0x02, 0x78, 0x28, 0x9B, 0xDF, 0xF0, 0x77, 0x77, 0x10, 0x3F, 0xFF, 0xFA, 0x0B, 0x02, 0x77,
  0x72, 0x03, 0xFF, 0xFF, 0x0C, 0x04, 0x77, 0x74, 0x03, 0xFF, 0xFD, 0x0B, 0x04, 0x77, 0x76, 0x03,
  0xFF, 0xFA, 0x81, 0xB6, 0x17, 0x77, 0x72, 0x83, 0x15, 0x8B, 0xDF, 0xD8, 0x3E, 0xCA, 0x73, 0x80,
  0xC5, 0x00, 0x18, 0x03, 0x30, 0x27, 0x77, 0x76,
  // ":" (U+003A)
  0x28, 0x52, 0x9C, 0xDD, 0xA4, 0x30, 0x40, 0xEE, 0x07, 0x20, 0xDF, 0x90, 0x30, 0x4F, 0xA0, 0x90,
  0x8F, 0xA0, 0xC0, 0x9F, 0xA0, 0xD0, 0x9F, 0xA0, 0xD0, 0x8F, 0xA0, 0xC0, 0x4F, 0xA8, 0x19, 0x0D,
  0xF9, 0x82, 0x30, 0x4E, 0xE0, 0x73, 0x85, 0x29, 0xDE, 0xDA, 0x48, 0x0F, 0x97, 0x08, 0x31, 0x55,
  0x52, 0x50, 0x9D, 0x0C, 0x02, 0x20, 0x9F, 0x81, 0xD0, 0x2F, 0xA0, 0x06, 0xFA, 0x0B, 0x09, 0xFA,
  0x0D, 0x09, 0xFA, 0x0E, 0x08, 0xFA, 0x0D, 0x06, 0xFA, 0x0A, 0x01, 0xFA, 0x81, 0x60, 0x8F, 0x0C,
  0x30, 0x70, 0xEC, 0x0A, 0x01, 0x50, 0xF3, 0x01, 0x30,
  // ";" (U+003B)
  0x78, 0x52, 0x9D, 0xDD, 0x93, 0x71, 0x04, 0xF0, 0x67, 0x0E, 0xF9, 0x02, 0x50, 0x5F, 0xA0, 0x95,
  0x08, 0xFA, 0x0C, 0x50, 0x9F, 0xA0, 0xD5, 0x09, 0xFA, 0x0D, 0x50, 0x8F, 0xA0, 0xC5, 0x05, 0xFA,
  0x08, 0x60, 0xEF, 0x90, 0x26, 0x04, 0xF0, 0x67, 0x18, 0x53, 0xAD, 0xED, 0xA3, 0x80, 0x99, 0xE4,
  0x00, 0x68, 0x03, 0xD0, 0x17, 0x0A, 0xF0, 0x67, 0x0C, 0xF0, 0x37, 0x0E, 0xF7, 0x02, 0xF0, 0xB7,
  0x05, 0xF0, 0x77, 0x07, 0xF0, 0x37, 0x0A, 0xE0, 0xE7, 0x10, 0xDE, 0x0A, 0x70, 0x1F, 0x06, 0x70,
  0x4F, 0x01, 0x70, 0x7E, 0x0C, 0x71, 0x0B, 0xE0, 0x77, 0x10, 0xEE, 0x02, 0x70, 0x2E, 0x0D, 0x71,
  0x06, 0xE0, 0x87, 0x10, 0x9E, 0x03, 0x71, 0x0D, 0xD0, 0xD7, 0x10, 0x1E, 0x07, 0x71, 0x05, 0xE0,
  0x27, 0x10, 0x9D, 0x0C, 0x72, 0x0C, 0xD0, 0x67, 0x10, 0x1E, 0x01, 0x71, 0x05, 0xD0, 0xB7, 0x20,
  0x9D, 0x05, 0x72, 0x0D, 0xC0, 0xE7, 0x20, 0x2D, 0x08, 0x72, 0x06, 0xD0, 0x27, 0x20, 0xAC, 0x0B,
  0x73, 0x84, 0x67, 0x77, 0x73, 0x73,
  // "<" (U+003C)
  0x80, 0xE3, 0x00, 0x50, 0x18, 0x0E, 0x10, 0x82, 0x5C, 0xF2, 0x80, 0xD7, 0x00, 0x60, 0xDB, 0x02,
  0x80, 0xD5, 0x00, 0x60, 0xDD, 0x02, 0x80, 0xD3, 0x00, 0x70, 0xEF, 0x02, 0x80, 0xD1, 0x00, 0x70,
  0xEF, 0xA0, 0x28, 0x0C, 0x60, 0x81, 0x18, 0xEF, 0xB0, 0xD0, 0x18, 0x0C, 0x40, 0x81, 0x18, 0xEF,
  0xB0, 0xC0, 0x58, 0x0C, 0x40, 0x01, 0x08, 0xFC, 0x0C, 0x04, 0x80, 0xC4, 0x00, 0x20, 0x9F, 0xC0,
  0xB0, 0x38, 0x0C, 0x40, 0x02, 0x09, 0xFC, 0x0A, 0x02, 0x80, 0xC4, 0x00, 0x30, 0xAF, 0xC0, 0x90,
  0x28, 0x0C, 0x40, 0x03, 0x0A, 0xFB, 0x81, 0xE8, 0x18, 0x0C, 0x40, 0x03, 0x0B, 0xFB, 0x0E, 0x07,
  0x80, 0xC5, 0x00, 0x40, 0xBF, 0xB0, 0xD0, 0x68, 0x0C, 0x50, 0x04, 0x0C, 0xFB, 0x0C, 0x05, 0x80,
  0xC5, 0x00, 0x50, 0xCF, 0xB0, 0xB0, 0x48, 0x0C, 0x50, 0x05, 0x0D, 0xFB, 0x0A, 0x03, 0x80, 0xC5,
  0x00, 0x60, 0xDF, 0xB0, 0x90, 0x28, 0x0C, 0x50, 0x06, 0x0E, 0xFA, 0x81, 0xE8, 0x18, 0x0C, 0x50,
  0x07, 0x0E, 0xFA, 0x81, 0xE7, 0x18, 0x0C, 0x40, 0x81, 0x17, 0xEF, 0xA0, 0xD0, 0x68, 0x0C, 0x50,
  0x81, 0x18, 0xEF, 0xA0, 0xD0, 0x58, 0x0C, 0x50, 0x01, 0x08, 0xFB, 0x0C, 0x04, 0x80, 0xC5, 0x00,
  0x20, 0x9F, 0xB0, 0xB0, 0x38, 0x0C, 0x50, 0x02, 0x09, 0xFB, 0x0A, 0x02, 0x80, 0xC5, 0x00, 0x30,
  0xAF, 0xB0, 0x90, 0x28, 0x0C, 0x60, 0x07, 0xFA, 0x81, 0xE8, 0x18, 0x0D, 0x00, 0x09, 0xF0, 0xE0,
  0x78, 0x0D, 0x30, 0x09, 0xF0, 0xA0, 0x38, 0x0D, 0x30, 0x09, 0xFA, 0x0B, 0x04, 0x80, 0xD1, 0x00,
  0x50, 0xEF, 0xB0, 0xD0, 0x68, 0x0D, 0x10, 0x06, 0x0D, 0xFB, 0x81, 0xE8, 0x18, 0x0D, 0x00, 0x04,
  0x0B, 0xFC, 0x0A, 0x03, 0x80, 0xD0, 0x00, 0x30, 0xAF, 0xC0, 0xB0, 0x48, 0x0D, 0x00, 0x81, 0x29,
  0xEF, 0xB0, 0xD0, 0x68, 0x0D, 0x00, 0x81, 0x17, 0xEF, 0xB8, 0x1E, 0x81, 0x80, 0xD0, 0x00, 0x60,
  0xDF, 0xC0, 0xA0, 0x38, 0x0D, 0x00, 0x04, 0x0B, 0xFC, 0x0B, 0x04, 0x80, 0xD0, 0x00, 0x30, 0xAF,
  0xC0, 0xD0, 0x68, 0x0D, 0x00, 0x81, 0x28, 0xEF, 0xB8, 0x1E, 0x81, 0x80, 0xC7, 0x08, 0x11, 0x7E,
  0xFC, 0x0A, 0x03, 0x80, 0xD0, 0x00, 0x60, 0xDF, 0xC0, 0xB0, 0x58, 0x0D, 0x00, 0x04, 0x0B, 0xFC,
  0x0D, 0x06, 0x80, 0xD0, 0x00, 0x30, 0xAF, 0xC8, 0x1E, 0x81, 0x80, 0xC7, 0x08, 0x12, 0x8E, 0xFC,
  0x0A, 0x03, 0x80, 0xC7, 0x08, 0x11, 0x7E, 0xFC, 0x0B, 0x05, 0x80, 0xD0, 0x00, 0x60, 0xCF, 0xC0,
  0xD0, 0x68, 0x0D, 0x00, 0x04, 0x0B, 0xFC, 0x81, 0xE8, 0x18, 0x0C, 0x70, 0x03, 0x0A, 0xFD, 0x0A,
  0x03, 0x80, 0xC7, 0x08, 0x11, 0x8E, 0xFC, 0x0C, 0x01, 0x80, 0xC7, 0x08, 0x11, 0x7D, 0xFB, 0x02,
  0x80, 0xD2, 0x00, 0x50, 0xCF, 0x90, 0x28, 0x0D, 0x40, 0x04, 0x0B, 0xE0, 0x28, 0x0D, 0x60, 0x03,
  0x0A, 0xC0, 0x28, 0x0E, 0x00, 0x83, 0x18, 0xEF, 0x28, 0x0E, 0x20, 0x81, 0x17, 0x10,
  // "=" (U+003D)
  0x01, 0x80, 0xE2, 0x30, 0x20, 0x48, 0x0E, 0x2F, 0x0A, 0x04, 0x80, 0xE2, 0xF0, 0xA0, 0x48, 0x0E,
  0x2F, 0x0A, 0x04, 0x80, 0xE2, 0xF0, 0xA0, 0x48, 0x0E, 0x2F, 0x0A, 0x01, 0x80, 0xE2, 0x50, 0x38,
  0x09, 0xEE, 0x50, 0x80, 0xE3, 0x10, 0x48, 0x0E, 0x2F, 0x0A, 0x04, 0x80, 0xE2, 0xF0, 0xA0, 0x48,
  0x0E, 0x2F, 0x0A, 0x04, 0x80, 0xE2, 0xF0, 0xA0, 0x48, 0x0E, 0x2F, 0x0A, 0x02, 0x80, 0xE2, 0x90,
  0x60,
  // ">" (U+003E)
  0x04, 0x01, 0x80, 0xE3, 0x08, 0x29, 0xF9, 0x28, 0x0E, 0x10, 0x09, 0xB0, 0x90, 0x28, 0x0D, 0x70,
  0x09, 0xD0, 0xA0, 0x28, 0x0D, 0x50, 0x09, 0xF0, 0xA0, 0x38, 0x0D, 0x30, 0x09, 0xFA, 0x0B, 0x03,
  0x80, 0xD1, 0x00, 0x7F, 0xC0, 0xB0, 0x48, 0x0D, 0x00, 0x02, 0x09, 0xFC, 0x0C, 0x04, 0x80, 0xD0,
  0x08, 0x11, 0x8E, 0xFB, 0x0C, 0x05, 0x80, 0xD0, 0x08, 0x11, 0x7E, 0xFB, 0x0D, 0x05, 0x80, 0xD1,
  0x00, 0x60, 0xDF, 0xB0, 0xD0, 0x68, 0x0D, 0x10, 0x06, 0x0D, 0xFB, 0x0D, 0x06, 0x80, 0xD1, 0x00,
  0x50, 0xCF, 0xB0, 0xE0, 0x78, 0x0D, 0x10, 0x04, 0x0B, 0xFB, 0x81, 0xE7, 0x18, 0x0D, 0x00, 0x03,
  0x0A, 0xFB, 0x81, 0xE8, 0x18, 0x0D, 0x00, 0x02, 0x09, 0xFC, 0x08, 0x01, 0x80, 0xD0, 0x00, 0x20,
  0x9F, 0xC0, 0x90, 0x28, 0x0D, 0x00, 0x81, 0x18, 0xEF, 0xB0, 0x90, 0x28, 0x0D, 0x10, 0x07, 0x0E,
  0xFB, 0x0A, 0x02, 0x80, 0xD1, 0x00, 0x60, 0xDF, 0xB0, 0xA0, 0x38, 0x0D, 0x10, 0x05, 0x0C, 0xFB,
  0x0B, 0x03, 0x80, 0xD1, 0x00, 0x40, 0xCF, 0xB0, 0xB0, 0x48, 0x0D, 0x10, 0x04, 0x0B, 0xFB, 0x0C,
  0x04, 0x80, 0xD1, 0x00, 0x30, 0xAF, 0xB0, 0xC0, 0x58, 0x0D, 0x10, 0x02, 0x09, 0xFB, 0x0D, 0x05,
  0x80, 0xD1, 0x08, 0x11, 0x8E, 0xFA, 0x0D, 0x06, 0x80, 0xD1, 0x08, 0x11, 0x7E, 0xFA, 0x0D, 0x06,
  0x80, 0xD2, 0x00, 0x70, 0xDF, 0xA0, 0xE0, 0x18, 0x0D, 0x20, 0x06, 0x0D, 0xF9, 0x02, 0x80, 0xD3,
  0x00, 0x50, 0xEF, 0x02, 0x80, 0xD1, 0x00, 0x70, 0xDF, 0xA0, 0x28, 0x0C, 0x60, 0x81, 0x28, 0xEF,
  0xB0, 0xB0, 0x18, 0x0C, 0x40, 0x03, 0x0A, 0xFC, 0x09, 0x02, 0x80, 0xC4, 0x00, 0x50, 0xCF, 0xB8,
  0x1E, 0x81, 0x80, 0xC3, 0x08, 0x11, 0x7D, 0xFB, 0x0D, 0x07, 0x80, 0xC4, 0x08, 0x12, 0x9E, 0xFB,
  0x0C, 0x05, 0x80, 0xC4, 0x00, 0x40, 0xAF, 0xC0, 0xB0, 0x48, 0x0C, 0x40, 0x05, 0x0C, 0xFC, 0x09,
  0x02, 0x80, 0xC3, 0x08, 0x11, 0x7E, 0xFB, 0x81, 0xE8, 0x18, 0x0C, 0x30, 0x02, 0x09, 0xFC, 0x0D,
  0x06, 0x80, 0xC4, 0x00, 0x40, 0xBF, 0xC0, 0xC0, 0x58, 0x0C, 0x40, 0x06, 0x0C, 0xFC, 0x0B, 0x04,
  0x80, 0xC3, 0x08, 0x11, 0x7E, 0xFC, 0x09, 0x02, 0x80, 0xC3, 0x00, 0x20, 0x9F, 0xC8, 0x1E, 0x81,
  0x80, 0xC3, 0x00, 0x40, 0xBF, 0xC0, 0xD0, 0x68, 0x0C, 0x40, 0x06, 0x0D, 0xFC, 0x0C, 0x05, 0x80,
  0xC3, 0x08, 0x11, 0x8E, 0xFC, 0x0B, 0x04, 0x80, 0xC3, 0x00, 0x30, 0x9F, 0xD0, 0x90, 0x28, 0x0C,
  0x30, 0x04, 0x0B, 0xFC, 0x81, 0xE8, 0x18, 0x0C, 0x30, 0x06, 0x0D, 0xFC, 0x0D, 0x06, 0x80, 0xC4,
  0x00, 0x60, 0xEF, 0xC0, 0xC0, 0x58, 0x0C, 0x60, 0x09, 0xFB, 0x0A, 0x03, 0x80, 0xD0, 0x00, 0x9F,
  0x90, 0x90, 0x28, 0x0D, 0x20, 0x09, 0xD8, 0x1E, 0x81, 0x80, 0xD4, 0x00, 0x9B, 0x0D, 0x06, 0x80,
  0xD7, 0x08, 0x29, 0xFC, 0x58, 0x0E, 0x10, 0x06, 0x03, 0x80, 0xE3, 0x00,
  // "?" (U+003F)
  0x75, 0x89, 0x62, 0x47, 0x9A, 0xBC, 0xDD, 0xDD, 0xBA, 0x86, 0x37, 0x77, 0x38, 0x22, 0x6A, 0xEF,
  0xFB, 0x81, 0xB7, 0x17, 0x73, 0x81, 0x27, 0xDF, 0xFF, 0xB0, 0xB0, 0x37, 0x58, 0x11, 0x6C, 0xFF,
  0xFF, 0x90, 0xB0, 0x27, 0x18, 0x12, 0x9E, 0xFF, 0xFF, 0xD0, 0x67, 0x0C, 0x80, 0xC0, 0xF0, 0x96,
  0x05, 0xFD, 0x89, 0x4D, 0xA8, 0x75, 0x33, 0x33, 0x46, 0x8A, 0xEF, 0xC0, 0xA6, 0x0D, 0xF8, 0x2E,
  0x95, 0x17, 0x78, 0x13, 0x8E, 0xFA, 0x09, 0x50, 0x7C, 0x81, 0xE9, 0x47, 0x77, 0x06, 0x0E, 0xF9,
  0x06, 0x40, 0x1A, 0x81, 0xD6, 0x17, 0x77, 0x30, 0x10, 0xBF, 0x0E, 0x01, 0x40, 0x70, 0x57, 0x77,
  0x71, 0x09, 0xF0, 0x98, 0x0C, 0x00, 0x0A, 0xF0, 0x28, 0x0C, 0x00, 0x0D, 0xE0, 0x88, 0x0C, 0x00,
  0x04, 0xE0, 0xD8, 0x0C, 0x10, 0x0D, 0xE0, 0x28, 0x0C, 0x00, 0x07, 0xE0, 0x68, 0x0C, 0x00, 0x03,
  0xE0, 0x98, 0x0C, 0x10, 0xE0, 0xB8, 0x0C, 0x10, 0x0D, 0xD0, 0xC8, 0x0C, 0x10, 0x0B, 0xD0, 0xD8,
  0x0C, 0x10, 0x0A, 0xD0, 0xE8, 0x0C, 0x10, 0x0A, 0xD0, 0xD8, 0x0C, 0x10, 0x0B, 0xD0, 0xD8, 0x0C,
  0x10, 0x0C, 0xD0, 0xC8, 0x0C, 0x10, 0x0E, 0xD0, 0xA8, 0x0C, 0x00, 0x01, 0xE0, 0x88, 0x0C, 0x00,
  0x05, 0xE0, 0x58, 0x0C, 0x00, 0x0A, 0xE0, 0x17, 0x77, 0x77, 0x01, 0xE0, 0xC8, 0x0C, 0x00, 0x08,
  0xE0, 0x77, 0x77, 0x77, 0x02, 0xF0, 0x17, 0x77, 0x77, 0x0B, 0xE0, 0x87, 0x77, 0x77, 0x08, 0xE0,
  0xE0, 0x17, 0x77, 0x76, 0x05, 0xF0, 0x67, 0x77, 0x76, 0x05, 0xF0, 0xB7, 0x77, 0x76, 0x05, 0xF0,
  0xD0, 0x17, 0x77, 0x75, 0x07, 0xF0, 0xE0, 0x27, 0x77, 0x75, 0x09, 0xF0, 0xE0, 0x37, 0x77, 0x74,
  0x01, 0x0B, 0xF0, 0xE0, 0x37, 0x77, 0x74, 0x02, 0x0D, 0xF0, 0xD0, 0x27, 0x77, 0x74, 0x05, 0x0E,
  0xF0, 0xC0, 0x17, 0x77, 0x74, 0x08, 0xF9, 0x0A, 0x77, 0x77, 0x50, 0xBF, 0x90, 0x77, 0x77, 0x74,
  0x01, 0x0C, 0xF0, 0xE0, 0x47, 0x77, 0x74, 0x01, 0x0C, 0xF0, 0xC0, 0x27, 0x77, 0x75, 0x0C, 0xF0,
  0xA7, 0x77, 0x76, 0x0A, 0xF0, 0x77, 0x77, 0x76, 0x07, 0xF0, 0x67, 0x77, 0x76, 0x02, 0xF0, 0x67,
  0x77, 0x77, 0x0A, 0xE0, 0x87, 0x77, 0x77, 0x02, 0xE0, 0xB8, 0x0C, 0x00, 0x08, 0xE0, 0x28, 0x0C,
  0x00, 0x0D, 0xD0, 0x98, 0x0C, 0x00, 0x02, 0xE0, 0x28, 0x0C, 0x00, 0x05, 0xD0, 0xC8, 0x0C, 0x10,
  0x07, 0xD0, 0x88, 0x0C, 0x10, 0x09, 0xD0, 0x48, 0x0C, 0x10, 0x0B, 0xD0, 0x28, 0x0C, 0x10, 0x0C,
  0xD8, 0x0C, 0x20, 0x0D, 0xC0, 0xE8, 0x0C, 0x20, 0x0E, 0xC0, 0xD8, 0x0C, 0x20, 0x0E, 0xC0, 0xC8,
  0x0C, 0x20, 0x0E, 0xC0, 0xC8, 0x0C, 0x20, 0x0E, 0xC0, 0xC8, 0x0C, 0x20, 0x80, 0x15, 0x04, 0x80,
  0x98, 0x87, 0x08, 0x23, 0x55, 0x48, 0x0C, 0x20, 0x03, 0x0D, 0xC0, 0xE0, 0x77, 0x77, 0x77, 0x01,
  0x0E, 0xF0, 0x67, 0x77, 0x76, 0x08, 0xF9, 0x0E, 0x77, 0x77, 0x60, 0xCF, 0xA0, 0x37, 0x77, 0x75,
  0x0E, 0xFA, 0x05, 0x77, 0x77, 0x5F, 0xB0, 0x67, 0x77, 0x75, 0x0E, 0xFA, 0x05, 0x77, 0x77, 0x50,
  0xCF, 0xA0, 0x37, 0x77, 0x75, 0x07, 0xF9, 0x0D, 0x77, 0x77, 0x70, 0xDF, 0x05, 0x77, 0x77, 0x70,
  0x10, 0xBC, 0x0D, 0x05, 0x80, 0xC2, 0x08, 0x21, 0x33, 0x27, 0x77, 0x40,
  // "@" (U+0040)
  0x80, 0xD3, 0x00, 0xF1, 0x03, 0x02, 0x0F, 0x18, 0x09, 0x93, 0x08, 0x43, 0x58, 0xAC, 0xDF, 0xC8,
  0x4E, 0xCA, 0x86, 0x38, 0x09, 0x80, 0x08, 0x14, 0x8C, 0xFF, 0xFC, 0x81, 0xC8, 0x48, 0x0F, 0x00,
  0x81, 0x16, 0xBF, 0xFF, 0xFC, 0x81, 0xE9, 0x48, 0x0E, 0x30, 0x04, 0x0B, 0x80, 0xC2, 0xF8, 0x1D,
  0x71, 0x80, 0xD6, 0x00, 0x60, 0xD8, 0x0C, 0x6F, 0x81, 0xE8, 0x18, 0x0D, 0x20, 0x06, 0x0E, 0xFF,
  0x98, 0x3E, 0xB9, 0x87, 0x80, 0x35, 0x83, 0x67, 0x9B, 0xDF, 0xF0, 0xE0, 0x78, 0x0C, 0x70, 0x04,
  0x0D, 0xFD, 0x82, 0xD9, 0x63, 0x77, 0x58, 0x23, 0x6A, 0xEF, 0xC0, 0xD0, 0x48, 0x0C, 0x30, 0x02,
  0x0B, 0xFC, 0x81, 0xB6, 0x27, 0x77, 0x68, 0x13, 0x8D, 0xFB, 0x09, 0x80, 0xC1, 0x00, 0x50, 0xEF,
  0xA8, 0x1D, 0x61, 0x77, 0x77, 0x50, 0x40, 0xBF, 0xA0, 0xD0, 0x27, 0x77, 0x76, 0x0A, 0xFA, 0x0B,
  0x04, 0x80, 0xC2, 0x00, 0x30, 0xAF, 0x90, 0xE0, 0x47, 0x77, 0x73, 0x02, 0x0D, 0xF9, 0x0B, 0x03,
  0x80, 0xC6, 0x00, 0x40, 0xCF, 0x90, 0x67, 0x77, 0x71, 0x04, 0x0E, 0xF0, 0xD0, 0x58, 0x0D, 0x20,
  0x07, 0xF9, 0x06, 0x77, 0x76, 0x04, 0xF9, 0x09, 0x80, 0xD5, 0x00, 0x30, 0xDF, 0x06, 0x77, 0x74,
  0x05, 0xF0, 0xE0, 0x48, 0x0D, 0x70, 0x01, 0x0B, 0xF0, 0x47, 0x77, 0x20, 0x4F, 0x0C, 0x01, 0x80,
  0xE2, 0x00, 0xAE, 0x0E, 0x02, 0x77, 0x70, 0x30, 0xEE, 0x0A, 0x80, 0xE5, 0x00, 0xAE, 0x0D, 0x77,
  0x60, 0x20, 0xEE, 0x09, 0x80, 0xE7, 0x00, 0xAE, 0x09, 0x77, 0x50, 0xCE, 0x09, 0x80, 0xF1, 0x00,
  0xCE, 0x04, 0x77, 0x30, 0x9E, 0x0A, 0x80, 0xF2, 0x00, 0x20, 0xED, 0x0D, 0x77, 0x20, 0x5E, 0x0B,
  0x80, 0xF4, 0x00, 0x5E, 0x08, 0x77, 0x01, 0x0E, 0xD0, 0xD0, 0x18, 0x0F, 0x50, 0x0A, 0xD0, 0xE0,
  0x17, 0x60, 0xAE, 0x03, 0x80, 0xF6, 0x00, 0x10, 0xED, 0x09, 0x75, 0x04, 0xE0, 0x78, 0x09, 0x80,
  0x00, 0x7E, 0x01, 0x74, 0x0C, 0xD0, 0xC7, 0x77, 0x73, 0x81, 0x24, 0x68, 0x02, 0x78, 0x26, 0x53,
  0x27, 0x77, 0x50, 0xDD, 0x07, 0x73, 0x06, 0xE0, 0x27, 0x77, 0x68, 0x22, 0x7B, 0xEF, 0xF8, 0x2D,
  0xA7, 0x47, 0x77, 0x06, 0xD0, 0xE7, 0x30, 0xDD, 0x09, 0x77, 0x75, 0x05, 0x0C, 0xFF, 0xFA, 0x81,
  0xC7, 0x27, 0x74, 0x0E, 0xD0, 0x47, 0x10, 0x6D, 0x0E, 0x01, 0x77, 0x73, 0x05, 0x0D, 0xFF, 0xFF,
  0x02, 0x77, 0x30, 0x9D, 0x0A, 0x71, 0x0D, 0xD0, 0x77, 0x77, 0x20, 0x10, 0xBF, 0xFF, 0xFA, 0x02,
  0x77, 0x30, 0x3D, 0x0E, 0x70, 0x3D, 0x0E, 0x01, 0x77, 0x71, 0x04, 0x0E, 0xFC, 0x86, 0xDC, 0xBB,
  0xBB, 0xDE, 0xFD, 0x01, 0x77, 0x40, 0xDD, 0x04, 0x60, 0xAD, 0x08, 0x77, 0x71, 0x07, 0xFA, 0x81,
  0xC7, 0x37, 0x38, 0x23, 0x69, 0xDF, 0x77, 0x50, 0x8D, 0x08, 0x50, 0x1E, 0x02, 0x77, 0x70, 0x7F,
  0x90, 0xA0, 0x37, 0x73, 0x03, 0xE7, 0x75, 0x04, 0xD0, 0xC5, 0x05, 0xD0, 0xB7, 0x77, 0x06, 0xF0,
  0xD0, 0x37, 0x75, 0x01, 0xD0, 0xE7, 0x76, 0xE5, 0x0B, 0xD0, 0x67, 0x76, 0x04, 0xF0, 0xA7, 0x77,
  0x02, 0xD0, 0xD7, 0x76, 0x0C, 0xD0, 0x34, 0xE0, 0x17, 0x75, 0x01, 0x0E, 0xE0, 0x87, 0x77, 0x10,
  0x2D, 0x0D, 0x77, 0x60, 0x9D, 0x05, 0x30, 0x4D, 0x0B, 0x77, 0x60, 0xBE, 0x09, 0x77, 0x72, 0x03,
  0xD0, 0xC7, 0x76, 0x06, 0xD0, 0x73, 0x08, 0xD0, 0x77, 0x75, 0x05, 0xE0, 0xB7, 0x77, 0x30, 0x4D,
  0x0B, 0x77, 0x60, 0x4D, 0x0A, 0x30, 0xCD, 0x03, 0x77, 0x50, 0xDD, 0x0E, 0x01, 0x77, 0x73, 0x04,
  0xD0, 0xB7, 0x76, 0x02, 0xD0, 0xB3, 0xD0, 0xE7, 0x75, 0x05, 0xE0, 0x67, 0x77, 0x40, 0x5D, 0x0A,
  0x77, 0x7D, 0x0D, 0x20, 0x3D, 0x0B, 0x77, 0x50, 0xCD, 0x0D, 0x77, 0x75, 0x06, 0xD0, 0x97, 0x77,
  0x0E, 0xC0, 0xE2, 0x06, 0xD0, 0x87, 0x74, 0x03, 0xE0, 0x67, 0x77, 0x50, 0x6D, 0x09, 0x77, 0x70,
  0xDD, 0x20, 0x9D, 0x05, 0x77, 0x40, 0x8D, 0x0E, 0x77, 0x76, 0x07, 0xD0, 0x87, 0x77, 0x0D, 0xD2,
  0x0B, 0xD0, 0x27, 0x74, 0x0D, 0xD0, 0x97, 0x77, 0x60, 0x8D, 0x07, 0x77, 0x70, 0xCD, 0x20, 0xDD,
  0x77, 0x40, 0x2E, 0x04, 0x77, 0x76, 0x09, 0xD0, 0x67, 0x77, 0x0C, 0xD0, 0x11, 0xD0, 0xE7, 0x74,
  0x05, 0xE7, 0x77, 0x70, 0x9D, 0x06, 0x77, 0x70, 0xCD, 0x10, 0x1D, 0x0C, 0x77, 0x40, 0x8D, 0x0C,
  0x77, 0x77, 0x0A, 0xD0, 0x57, 0x77, 0x0D, 0xD1, 0x02, 0xD0, 0xB7, 0x74, 0x0B, 0xD0, 0x97, 0x77,
  0x70, 0xBD, 0x04, 0x77, 0x70, 0xDD, 0x10, 0x3D, 0x09, 0x77, 0x40, 0xDD, 0x07, 0x77, 0x77, 0x0B,
  0xD0, 0x37, 0x77, 0x0E, 0xC8, 0x1E, 0x04, 0xD0, 0x87, 0x74, 0x0E, 0xD0, 0x57, 0x77, 0x70, 0xCD,
  0x03, 0x77, 0x7D, 0x81, 0xC0, 0x5D, 0x08, 0x77, 0x4E, 0x04, 0x77, 0x77, 0x0D, 0xD0, 0x27, 0x76,
  0x01, 0xD8, 0x1B, 0x05, 0xD0, 0x87, 0x74, 0xE0, 0x37, 0x77, 0x7E, 0x02, 0x77, 0x60, 0x3D, 0x81,
  0x90, 0x6D, 0x07, 0x77, 0x4E, 0x03, 0x77, 0x76, 0x01, 0xE0, 0x17, 0x76, 0x06, 0xD8, 0x17, 0x06,
  0xD0, 0x77, 0x74, 0xE0, 0x37, 0x77, 0x60, 0x3E, 0x77, 0x70, 0x8D, 0x81, 0x40, 0x5D, 0x07, 0x77,
  0x4E, 0x04, 0x77, 0x76, 0x06, 0xE7, 0x77, 0x0B, 0xD8, 0x11, 0x05, 0xD0, 0x87, 0x74, 0x0D, 0xD0,
  0x57, 0x77, 0x60, 0x9E, 0x77, 0x70, 0xEC, 0x0D, 0x20, 0x5D, 0x09, 0x77, 0x40, 0xCD, 0x07, 0x77,
  0x76, 0x0D, 0xE7, 0x76, 0x03, 0xD0, 0x92, 0x03, 0xD0, 0x97, 0x74, 0x0A, 0xD0, 0x97, 0x77, 0x50,
  0x2F, 0x77, 0x60, 0x7D, 0x05, 0x20, 0x2D, 0x0B, 0x77, 0x40, 0x7D, 0x0C, 0x77, 0x75, 0x07, 0xF7,
  0x76, 0x0C, 0xD0, 0x12, 0x01, 0xD0, 0xC7, 0x74, 0x04, 0xE7, 0x77, 0x50, 0xDF, 0x01, 0x77, 0x40,
  0x2D, 0x0B, 0x4D, 0x0E, 0x77, 0x40, 0x1E, 0x05, 0x77, 0x73, 0x04, 0xF9, 0x03, 0x77, 0x40, 0x8D,
  0x06, 0x40, 0xDD, 0x01, 0x77, 0x40, 0xCD, 0x0B, 0x77, 0x73, 0x0C, 0xF9, 0x06, 0x77, 0x30, 0x10,
  0xEC, 0x0E, 0x50, 0xBD, 0x03, 0x77, 0x40, 0x6E, 0x03, 0x77, 0x71, 0x06, 0xC0, 0xCC, 0x09, 0x77,
  0x30, 0x8D, 0x08, 0x50, 0x9D, 0x05, 0x77, 0x40, 0x1E, 0x0B, 0x77, 0x70, 0x20, 0xEB, 0x0E, 0x03,
  0xC0, 0xD7, 0x72, 0x02, 0xE0, 0x15, 0x06, 0xD0, 0x97, 0x75, 0x09, 0xE0, 0x77, 0x75, 0x01, 0x0D,
  0xC0, 0x61, 0xD0, 0x47, 0x71, 0x0D, 0xD0, 0x86, 0x03, 0xD0, 0xC7, 0x75, 0x01, 0x0E, 0xE0, 0x67,
  0x73, 0x01, 0x0C, 0xC0, 0xC2, 0x0B, 0xC0, 0xD7, 0x70, 0xBD, 0x0D, 0x71, 0xE7, 0x76, 0x07, 0xF0,
  0x87, 0x71, 0x05, 0x0E, 0xD0, 0x32, 0x06, 0xD0, 0xA7, 0x40, 0x10, 0xBE, 0x04, 0x71, 0x0B, 0xD0,
  0x47, 0x76, 0x0B, 0xF0, 0xD0, 0x67, 0x40, 0x40, 0xBE, 0x06, 0x40, 0xED, 0x0B, 0x02, 0x71, 0x05,
  0x0D, 0xE0, 0x87, 0x20, 0x7D, 0x09, 0x77, 0x60, 0x10, 0xDF, 0x98, 0x91, 0xEA, 0x75, 0x33, 0x35,
  0x7A, 0xEF, 0x08, 0x50, 0x6F, 0x86, 0xB6, 0x43, 0x36, 0x9D, 0xF0, 0xA7, 0x30, 0x3D, 0x0D, 0x77,
  0x70, 0x20, 0xDF, 0xFF, 0xB0, 0x87, 0x0B, 0xFF, 0xE0, 0xA7, 0x50, 0xDD, 0x04, 0x77, 0x70, 0x10,
  0xBF, 0xFF, 0x0E, 0x05, 0x71, 0x01, 0x0C, 0xFF, 0xC0, 0x97, 0x60, 0x8D, 0x09, 0x77, 0x72, 0x06,
  0x0E, 0xFF, 0xC0, 0xA0, 0x27, 0x30, 0x10, 0xBF, 0xF9, 0x0E, 0x05, 0x77, 0x03, 0xE0, 0x17, 0x77,
  0x28, 0x11, 0x7D, 0xFF, 0x0A, 0x03, 0x77, 0x06, 0x0D, 0xFC, 0x0E, 0x07, 0x77, 0x30, 0xCD, 0x07,
  0x77, 0x75, 0x83, 0x37, 0xAC, 0xEC, 0x82, 0xDB, 0x85, 0x77, 0x58, 0x24, 0x9C, 0xEB, 0x82, 0xEB,
  0x84, 0x77, 0x50, 0x6D, 0x0E, 0x80, 0x9A, 0x50, 0x0E, 0xD0, 0x78, 0x09, 0xA4, 0x00, 0x7D, 0x0E,
  0x01, 0x80, 0x9A, 0x40, 0x0E, 0xD0, 0xA8, 0x09, 0xA4, 0x00, 0x6E, 0x05, 0x80, 0x9A, 0x40, 0x0C,
  0xD0, 0xE0, 0x28, 0x09, 0xA3, 0x00, 0x3E, 0x0C, 0x80, 0x9A, 0x40, 0x08, 0xE0, 0xA8, 0x09, 0xA4,
  0x00, 0xCE, 0x09, 0x80, 0x9A, 0x30, 0x01, 0x0E, 0xE0, 0x98, 0x09, 0xA3, 0x00, 0x3F, 0x0A, 0x80,
  0x9A, 0x30, 0x04, 0xF0, 0xC0, 0x28, 0x09, 0xA2, 0x00, 0x5F, 0x0E, 0x06, 0x80, 0x9A, 0x20, 0x05,
  0xF9, 0x0B, 0x02, 0x80, 0x9A, 0x10, 0x04, 0x0E, 0xF9, 0x09, 0x01, 0x80, 0xC5, 0x08, 0x13, 0x9C,
  0x80, 0xC4, 0x00, 0x20, 0xCF, 0xA0, 0x90, 0x28, 0x0C, 0x00, 0x81, 0x38, 0xDA, 0x0D, 0x80, 0xC6,
  0x00, 0x8F, 0xB8, 0x1C, 0x61, 0x77, 0x77, 0x18, 0x21, 0x59, 0xDD, 0x0D, 0x80, 0xC7, 0x00, 0x40,
  0xDF, 0xC8, 0x2C, 0x84, 0x17, 0x77, 0x82, 0x36, 0x9D, 0xFA, 0x0D, 0x80, 0xD1, 0x00, 0x70, 0xEF,
  0xE8, 0xA2, 0xEB, 0x97, 0x54, 0x32, 0x11, 0x11, 0x33, 0x45, 0x79, 0xBD, 0xFF, 0x0D, 0x80, 0xD2,
  0x08, 0x11, 0x8E, 0x80, 0xD1, 0xF0, 0x98, 0x0D, 0x40, 0x81, 0x17, 0xD8, 0x0C, 0x4F, 0x81, 0xC7,
  0x18, 0x0E, 0x00, 0x81, 0x49, 0xEF, 0xFF, 0xFE, 0x81, 0xB7, 0x28, 0x0E, 0x60, 0x81, 0x48, 0xCF,
  0xFF, 0xD8, 0x2E, 0xB8, 0x48, 0x0F, 0x60, 0x83, 0x36, 0x8B, 0xDF, 0xF8, 0x4D, 0xB9, 0x75, 0x28,
  0x09, 0x91, 0x00, 0x18, 0x04, 0x30, 0x18, 0x0D, 0x10,
  // "A" (U+0041)
  0x77, 0x77, 0x50, 0x88, 0x02, 0xD0, 0x38, 0x0F, 0x50, 0x0E, 0xE0, 0x98, 0x0F, 0x40, 0x05, 0xF0,
  0xE8, 0x0F, 0x40, 0x0B, 0xF9, 0x06, 0x80, 0xF2, 0x00, 0x2F, 0xA0, 0xB8, 0x0F, 0x20, 0x08, 0xFB,
  0x02, 0x80, 0xF1, 0x00, 0xDF, 0xB0, 0x88, 0x0F, 0x00, 0x04, 0xD0, 0xED, 0x0D, 0x80, 0xF0, 0x00,
  0xAD, 0x07, 0x0E, 0xD0, 0x48, 0x0E, 0x60, 0x01, 0xE0, 0x10, 0x9D, 0x0A, 0x80, 0xE6, 0x00, 0x7D,
  0x81, 0xC0, 0x4E, 0x01, 0x80, 0xE5, 0x00, 0xDD, 0x07, 0x20, 0xED, 0x06, 0x80, 0xE4, 0x00, 0x4E,
  0x02, 0x20, 0x9D, 0x0C, 0x80, 0xE4, 0x00, 0xAD, 0x0C, 0x30, 0x4E, 0x03, 0x80, 0xE2, 0x00, 0x1E,
  0x07, 0x40, 0xED, 0x09, 0x80, 0xE2, 0x00, 0x6E, 0x02, 0x40, 0x9D, 0x0E, 0x80, 0xE2, 0x00, 0xCD,
  0x0C, 0x50, 0x4E, 0x05, 0x80, 0xE0, 0x00, 0x3E, 0x07, 0x60, 0xED, 0x0B, 0x80, 0xE0, 0x00, 0x9E,
  0x02, 0x60, 0xAE, 0x02, 0x80, 0xD7, 0x00, 0xED, 0x0C, 0x70, 0x5E, 0x07, 0x80, 0xD6, 0x00, 0x6E,
  0x07, 0x71, 0x0E, 0xD0, 0xD8, 0x0D, 0x60, 0x0C, 0xE0, 0x17, 0x10, 0x9E, 0x04, 0x80, 0xD4, 0x00,
  0x2E, 0x0A, 0x72, 0x03, 0xE0, 0xA8, 0x0D, 0x40, 0x08, 0xE0, 0x47, 0x30, 0xDE, 0x01, 0x80, 0xD3,
  0x00, 0xED, 0x0D, 0x74, 0x07, 0xE0, 0x68, 0x0D, 0x20, 0x05, 0xE0, 0x87, 0x40, 0x2E, 0x0C, 0x80,
  0xD2, 0x00, 0xBE, 0x02, 0x75, 0x0B, 0xE0, 0x28, 0x0D, 0x00, 0x02, 0xE0, 0xB7, 0x60, 0x5E, 0x08,
  0x80, 0xD0, 0x00, 0x8E, 0x05, 0x77, 0x0E, 0xD0, 0xE8, 0x0D, 0x00, 0x0D, 0xD0, 0xE7, 0x71, 0x09,
  0xE0, 0x58, 0x0C, 0x60, 0x04, 0xE0, 0x97, 0x71, 0x04, 0xE0, 0xB8, 0x0C, 0x60, 0x0A, 0xE0, 0x37,
  0x72, 0x0D, 0xE0, 0x18, 0x0C, 0x40, 0x01, 0xE0, 0xC7, 0x73, 0x08, 0xE0, 0x78, 0x0C, 0x40, 0x07,
  0xE0, 0x67, 0x73, 0x02, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0x17, 0x74, 0x0C, 0xE0, 0x38, 0x0C,
  0x20, 0x03, 0xE0, 0xA7, 0x75, 0x06, 0xE0, 0x98, 0x0C, 0x20, 0x0A, 0xE0, 0x47, 0x75, 0x01, 0xE0,
  0xE8, 0x0C, 0x10, 0x01, 0xE0, 0xD7, 0x77, 0x0A, 0xE0, 0x68, 0x0C, 0x00, 0x06, 0xE0, 0x87, 0x77,
  0x04, 0xE0, 0xC8, 0x0C, 0x00, 0x0C, 0xE0, 0x27, 0x77, 0x10, 0xDE, 0x02, 0x77, 0x77, 0x60, 0x3E,
  0x0B, 0x77, 0x72, 0x08, 0xE0, 0x87, 0x77, 0x76, 0x09, 0xE0, 0x57, 0x77, 0x20, 0x2E, 0x0E, 0x77,
  0x77, 0x60, 0xED, 0x0E, 0x77, 0x74, 0x0C, 0xE0, 0x47, 0x77, 0x74, 0x05, 0xE0, 0x97, 0x77, 0x40,
  0x6E, 0x0A, 0x77, 0x77, 0x40, 0xBE, 0x03, 0x77, 0x74, 0x01, 0xF0, 0x17, 0x77, 0x72, 0x02, 0xE0,
  0xC7, 0x77, 0x60, 0xAE, 0x07, 0x77, 0x77, 0x20, 0x8E, 0x06, 0x77, 0x76, 0x04, 0xE0, 0xD7, 0x77,
  0x72, 0x0E, 0xE0, 0x17, 0x77, 0x70, 0xEE, 0x03, 0x77, 0x77, 0x05, 0xE0, 0xA7, 0x77, 0x71, 0x08,
  0xE0, 0x97, 0x77, 0x70, 0xBE, 0x04, 0x77, 0x77, 0x10, 0x3E, 0x0E, 0x77, 0x76, 0x01, 0xF8, 0x0B,
  0x3B, 0xF0, 0x57, 0x77, 0x50, 0x78, 0x0D, 0x1F, 0x0B, 0x77, 0x75, 0x0D, 0x80, 0xD2, 0xF0, 0x27,
  0x77, 0x30, 0x48, 0x0D, 0x3F, 0x08, 0x77, 0x73, 0x0A, 0x80, 0xD3, 0xF0, 0xD7, 0x77, 0x20, 0x18,
  0x0D, 0x5F, 0x04, 0x77, 0x71, 0x07, 0xE0, 0xC8, 0x0B, 0x77, 0x0C, 0xE0, 0xA7, 0x77, 0x10, 0xDE,
  0x04, 0x77, 0x77, 0x70, 0x5F, 0x01, 0x77, 0x60, 0x3E, 0x0E, 0x80, 0xC1, 0x00, 0xEE, 0x06, 0x77,
  0x60, 0x9E, 0x08, 0x80, 0xC1, 0x00, 0x9E, 0x0C, 0x77, 0x50, 0x10, 0xEE, 0x02, 0x80, 0xC1, 0x00,
  0x3F, 0x03, 0x77, 0x40, 0x6E, 0x0B, 0x80, 0xC3, 0x00, 0xCE, 0x08, 0x77, 0x40, 0xCE, 0x05, 0x80,
  0xC3, 0x00, 0x6E, 0x0E, 0x77, 0x30, 0x3E, 0x0E, 0x80, 0xC4, 0x00, 0x1F, 0x05, 0x77, 0x20, 0x9E,
  0x08, 0x80, 0xC5, 0x00, 0xAE, 0x0B, 0x77, 0x20, 0xEE, 0x02, 0x80, 0xC5, 0x00, 0x4F, 0x01, 0x77,
  0x05, 0xE0, 0xB8, 0x0C, 0x70, 0x0D, 0xE0, 0x77, 0x70, 0xBE, 0x05, 0x80, 0xC7, 0x00, 0x7E, 0x0D,
  0x76, 0x02, 0xE0, 0xE8, 0x0D, 0x00, 0x01, 0xF0, 0x37, 0x50, 0x8E, 0x09, 0x80, 0xD1, 0x00, 0xBE,
  0x09, 0x75, 0x0E, 0xE0, 0x28, 0x0D, 0x10, 0x05, 0xE0, 0xE7, 0x40, 0x5E, 0x0C, 0x80, 0xD3, 0x00,
  0xEE, 0x06, 0x73, 0x0B, 0xE0, 0x68, 0x0D, 0x30, 0x08, 0xE0, 0xC7, 0x20, 0x1E, 0x0E, 0x80, 0xD4,
  0x00, 0x2F, 0x02, 0x71, 0x07, 0xE0, 0x98, 0x0D, 0x50, 0x0C, 0xE0, 0x87, 0x10, 0xDE, 0x03, 0x80,
  0xD5, 0x00, 0x6E, 0x0E, 0x70, 0x4E, 0x0C, 0x80, 0xD6, 0x00, 0x10, 0xEE, 0x04, 0x60, 0xAE, 0x06,
  0x80, 0xD7, 0x00, 0x9E, 0x0A, 0x50, 0x1E, 0x0E, 0x01, 0x80, 0xD7, 0x00, 0x3F, 0x01, 0x40, 0x7E,
  0x09, 0x80, 0xE1, 0x00, 0xDE, 0x07, 0x40, 0xDE, 0x03, 0x80, 0xE1, 0x00, 0x7E, 0x0D, 0x30, 0x3E,
  0x0D, 0x80, 0xE2, 0x00, 0x1F, 0x03, 0x20, 0x9E, 0x07, 0x80, 0xE3, 0x00, 0xBE, 0x09, 0x20, 0xEE,
  0x01, 0x80, 0xE3, 0x00, 0x5E, 0x81, 0xE0, 0x6E, 0x0A, 0x80, 0xE5, 0x00, 0xEE, 0x05, 0x0C, 0xE0,
  0x48, 0x0E, 0x50, 0x08, 0xE0, 0xB0,
  // "B" (U+0042)
  0x80, 0xA4, 0xB8, 0x00, 0x98, 0x48, 0x76, 0x53, 0x17, 0x77, 0x3F, 0xFF, 0xFF, 0x82, 0xC9, 0x73,
  0x77, 0x58, 0x0C, 0x3F, 0x81, 0xEA, 0x57, 0x72, 0x80, 0xC7, 0xF0, 0x90, 0x37, 0x68, 0x0D, 0x1F,
  0x0B, 0x02, 0x74, 0x80, 0xD3, 0xF0, 0x77, 0x3F, 0x80, 0x94, 0x58, 0x76, 0x77, 0x77, 0x9A, 0xBD,
  0xFF, 0xA0, 0xB0, 0x17, 0x1E, 0x0E, 0x77, 0x75, 0x82, 0x25, 0x8C, 0xFD, 0x0C, 0x01, 0x7E, 0x0E,
  0x77, 0x77, 0x28, 0x11, 0x6C, 0xFB, 0x0B, 0x7E, 0x0E, 0x77, 0x77, 0x50, 0x40, 0xCF, 0xA0, 0x86,
  0xE0, 0xE7, 0x77, 0x77, 0x07, 0xFA, 0x02, 0x5E, 0x0E, 0x80, 0xC0, 0x00, 0x5F, 0x90, 0xB5, 0xE0,
  0xE8, 0x0C, 0x10, 0x05, 0xF9, 0x02, 0x4E, 0x0E, 0x80, 0xC2, 0x00, 0xAF, 0x08, 0x4E, 0x0E, 0x80,
  0xC2, 0x00, 0x10, 0xEE, 0x0D, 0x4E, 0x0E, 0x80, 0xC3, 0x00, 0x9F, 0x01, 0x3E, 0x0E, 0x80, 0xC3,
  0x00, 0x3F, 0x04, 0x3E, 0x0E, 0x80, 0xC4, 0x00, 0xEE, 0x07, 0x3E, 0x0E, 0x80, 0xC4, 0x00, 0xCE,
  0x09, 0x3E, 0x0E, 0x80, 0xC4, 0x00, 0x9E, 0x09, 0x3E, 0x0E, 0x80, 0xC4, 0x00, 0x8E, 0x0A, 0x3E,
  0x0E, 0x80, 0xC4, 0x00, 0x7E, 0x0A, 0x3E, 0x0E, 0x80, 0xC4, 0x00, 0x7E, 0x0A, 0x3E, 0x0E, 0x80,
  0xC4, 0x00, 0x8E, 0x09, 0x3E, 0x0E, 0x80, 0xC4, 0x00, 0xAE, 0x07, 0x3E, 0x0E, 0x80, 0xC4, 0x00,
  0xCE, 0x04, 0x3E, 0x0E, 0x80, 0xC4, 0x0F, 0x01, 0x3E, 0x0E, 0x80, 0xC3, 0x00, 0x4E, 0x0C, 0x4E,
  0x0E, 0x80, 0xC3, 0x00, 0x9E, 0x07, 0x4E, 0x0E, 0x80, 0xC2, 0x00, 0x10, 0xEE, 0x01, 0x4E, 0x0E,
  0x80, 0xC2, 0x00, 0x9E, 0x09, 0x5E, 0x0E, 0x80, 0xC1, 0x00, 0x4E, 0x0E, 0x01, 0x5E, 0x0E, 0x80,
  0xC0, 0x00, 0x20, 0xEE, 0x06, 0x6E, 0x0E, 0x77, 0x77, 0x70, 0x20, 0xDE, 0x0A, 0x7E, 0x0E, 0x77,
  0x77, 0x60, 0x60, 0xEE, 0x0C, 0x71, 0xE0, 0xE7, 0x77, 0x74, 0x04, 0x0C, 0xF0, 0xC0, 0x17, 0x1E,
  0x0E, 0x77, 0x77, 0x18, 0x13, 0x7D, 0xF9, 0x0A, 0x73, 0xE0, 0xE7, 0x77, 0x28, 0x41, 0x35, 0x7A,
  0xEF, 0xA0, 0xE0, 0x67, 0x4F, 0x80, 0xA1, 0xDF, 0xF9, 0x81, 0xE8, 0x17, 0x58, 0x0C, 0x5F, 0x81,
  0xB6, 0x17, 0x78, 0x0C, 0x2F, 0x81, 0x85, 0x17, 0x73, 0x80, 0xC2, 0xF8, 0x2C, 0x96, 0x27, 0x72,
  0x80, 0xC6, 0xF8, 0x1E, 0x94, 0x76, 0x80, 0xD1, 0xF0, 0xD0, 0x67, 0x4E, 0x0E, 0x80, 0xA1, 0x18,
  0x53, 0x35, 0x68, 0xAC, 0xFD, 0x0E, 0x05, 0x72, 0xE0, 0xE7, 0x77, 0x71, 0x81, 0x37, 0xBF, 0xB0,
  0xB0, 0x17, 0xE0, 0xE7, 0x77, 0x74, 0x81, 0x17, 0xEF, 0x90, 0xE0, 0x36, 0xE0, 0xE7, 0x77, 0x77,
  0x06, 0x0E, 0xF0, 0xE0, 0x35, 0xE0, 0xE8, 0x0C, 0x00, 0x01, 0x0B, 0xF0, 0xE0, 0x24, 0xE0, 0xE8,
  0x0C, 0x20, 0x09, 0xF0, 0xC4, 0xE0, 0xE8, 0x0C, 0x30, 0x0A, 0xF0, 0x73, 0xE0, 0xE8, 0x0C, 0x40,
  0x0D, 0xE0, 0xE0, 0x12, 0xE0, 0xE8, 0x0C, 0x40, 0x04, 0xF0, 0x72, 0xE0, 0xE8, 0x0C, 0x50, 0x0B,
  0xE0, 0xD2, 0xE0, 0xE8, 0x0C, 0x50, 0x05, 0xF0, 0x21, 0xE0, 0xE8, 0x0C, 0x60, 0x0E, 0xE0, 0x71,
  0xE0, 0xE8, 0x0C, 0x60, 0x0B, 0xE0, 0xA1, 0xE0, 0xE8, 0x0C, 0x60, 0x08, 0xE0, 0xC1, 0xE0, 0xE8,
  0x0C, 0x60, 0x05, 0xE0, 0xE1, 0xE0, 0xE8, 0x0C, 0x60, 0x04, 0xF1, 0xE0, 0xE8, 0x0C, 0x60, 0x03,
  0xF0, 0x1E, 0x0E, 0x80, 0xC6, 0x00, 0x3F, 0x01, 0xE0, 0xE8, 0x0C, 0x60, 0x03, 0xF0, 0x1E, 0x0E,
  0x80, 0xC6, 0x00, 0x4F, 0x01, 0xE0, 0xE8, 0x0C, 0x60, 0x06, 0xF1, 0xE0, 0xE8, 0x0C, 0x60, 0x08,
  0xE0, 0xD1, 0xE0, 0xE8, 0x0C, 0x60, 0x0B, 0xE0, 0xB1, 0xE0, 0xE8, 0x0C, 0x60, 0x0E, 0xE0, 0x81,
  0xE0, 0xE8, 0x0C, 0x50, 0x04, 0xF0, 0x51, 0xE0, 0xE8, 0x0C, 0x50, 0x0A, 0xF0, 0x11, 0xE0, 0xE8,
  0x0C, 0x40, 0x02, 0xF0, 0xB2, 0xE0, 0xE8, 0x0C, 0x40, 0x0A, 0xF0, 0x52, 0xE0, 0xE8, 0x0C, 0x30,
  0x05, 0xF0, 0xE3, 0xE0, 0xE8, 0x0C, 0x20, 0x03, 0x0E, 0xF0, 0x73, 0xE0, 0xE8, 0x0C, 0x10, 0x03,
  0x0E, 0xF0, 0xD4, 0xE0, 0xE8, 0x0C, 0x00, 0x05, 0x0E, 0xF9, 0x03, 0x4E, 0x0E, 0x77, 0x77, 0x60,
  0x10, 0xAF, 0xA0, 0x65, 0xE0, 0xE7, 0x77, 0x74, 0x81, 0x28, 0xEF, 0xA0, 0x86, 0xE0, 0xE7, 0x77,
  0x71, 0x81, 0x16, 0xBF, 0xC0, 0x97, 0xE0, 0xE7, 0x77, 0x18, 0x51, 0x23, 0x58, 0xAD, 0xFE, 0x07,
  0x71, 0x80, 0xD3, 0xF0, 0xD0, 0x47, 0x28, 0x0D, 0x2F, 0x08, 0x74, 0x80, 0xD0, 0xF0, 0x90, 0x27,
  0x58, 0x0C, 0x5F, 0x81, 0xC7, 0x17, 0x78, 0x0C, 0x1F, 0x82, 0xEA, 0x62, 0x77, 0x3F, 0xFF, 0xF9,
  0x86, 0xED, 0xCB, 0x97, 0x52, 0x77, 0x70,
  // "C" (U+0043)
  0x77, 0x77, 0x48, 0x51, 0x46, 0x89, 0xBB, 0x80, 0x1D, 0x85, 0xBB, 0x99, 0x75, 0x38, 0x0C, 0x50,
  0x82, 0x27, 0xAE, 0xFF, 0xE8, 0x2C, 0xA6, 0x27, 0x77, 0x75, 0x81, 0x38, 0xDF, 0xFF, 0xF8, 0x1D,
  0x94, 0x77, 0x77, 0x06, 0x0C, 0xFF, 0xFF, 0xE8, 0x1E, 0x93, 0x77, 0x72, 0x06, 0x0E, 0x80, 0xC3,
  0xF0, 0xB0, 0x47, 0x75, 0x05, 0x0D, 0x80, 0xC6, 0xF0, 0xC7, 0x73, 0x01, 0x0A, 0xFF, 0x98, 0x3E,
  0xCA, 0x87, 0x80, 0x15, 0x83, 0x78, 0x9B, 0xEF, 0xF0, 0x47, 0x72, 0x04, 0x0E, 0xFD, 0x82, 0xD9,
  0x52, 0x77, 0x18, 0x31, 0x47, 0xBE, 0xF9, 0x0D, 0x77, 0x20, 0x8F, 0xC8, 0x1E, 0x93, 0x77, 0x73,
  0x81, 0x49, 0xED, 0x06, 0x77, 0x10, 0xAF, 0xB0, 0xD0, 0x67, 0x77, 0x72, 0x04, 0x0A, 0xA0, 0xE7,
  0x71, 0x0B, 0xFA, 0x0E, 0x07, 0x77, 0x77, 0x68, 0x11, 0x86, 0x77, 0x0B, 0xFA, 0x0A, 0x01, 0x80,
  0xD7, 0x00, 0xBF, 0x90, 0xE0, 0x58, 0x0E, 0x00, 0x09, 0xF9, 0x0D, 0x03, 0x80, 0xE0, 0x00, 0x7F,
  0x90, 0xC0, 0x18, 0x0E, 0x00, 0x03, 0xF9, 0x0C, 0x01, 0x80, 0xE1, 0x00, 0xDF, 0x0D, 0x01, 0x80,
  0xE1, 0x00, 0x8F, 0x0E, 0x02, 0x80, 0xE1, 0x00, 0x2F, 0x90, 0x48, 0x0E, 0x20, 0x0B, 0xF0, 0x98,
  0x0E, 0x20, 0x04, 0xF0, 0xD8, 0x0E, 0x30, 0x0C, 0xF0, 0x48, 0x0E, 0x20, 0x03, 0xF0, 0xB8, 0x0E,
  0x30, 0x0A, 0xF0, 0x38, 0x0E, 0x20, 0x01, 0xF0, 0xA8, 0x0E, 0x30, 0x07, 0xF0, 0x48, 0x0E, 0x30,
  0x0D, 0xE0, 0xC8, 0x0E, 0x30, 0x02, 0xF0, 0x78, 0x0E, 0x30, 0x07, 0xF0, 0x18, 0x0E, 0x30, 0x0B,
  0xE0, 0xC8, 0x0E, 0x40, 0xF0, 0x78, 0x0E, 0x30, 0x03, 0xF0, 0x38, 0x0E, 0x30, 0x07, 0xF8, 0x0E,
  0x40, 0x09, 0xE0, 0xB8, 0x0E, 0x40, 0x0C, 0xE0, 0x98, 0x0E, 0x40, 0x0E, 0xE0, 0x68, 0x0E, 0x30,
  0x01, 0xF0, 0x48, 0x0E, 0x30, 0x03, 0xF0, 0x28, 0x0E, 0x30, 0x04, 0xF8, 0x0E, 0x40, 0x06, 0xE0,
  0xE8, 0x0E, 0x40, 0x07, 0xE0, 0xD8, 0x0E, 0x40, 0x07, 0xE0, 0xC8, 0x0E, 0x40, 0x08, 0xE0, 0xC8,
  0x0E, 0x40, 0x08, 0xE0, 0xC8, 0x0E, 0x40, 0x08, 0xE0, 0xB8, 0x0E, 0x40, 0x08, 0xE0, 0xC8, 0x0E,
  0x40, 0x07, 0xE0, 0xC8, 0x0E, 0x40, 0x07, 0xE0, 0xD8, 0x0E, 0x40, 0x06, 0xE0, 0xE8, 0x0E, 0x40,
  0x05, 0xF8, 0x0E, 0x40, 0x04, 0xF0, 0x18, 0x0E, 0x30, 0x02, 0xF0, 0x38, 0x0E, 0x40, 0xF0, 0x48,
  0x0E, 0x40, 0x0E, 0xE0, 0x78, 0x0E, 0x40, 0x0B, 0xE0, 0x98, 0x0E, 0x40, 0x09, 0xE0, 0xC8, 0x0E,
  0x40, 0x06, 0xF8, 0x0E, 0x40, 0x03, 0xF0, 0x38, 0x0E, 0x40, 0xF0, 0x88, 0x0E, 0x40, 0x0C, 0xE0,
  0xC8, 0x0E, 0x40, 0x07, 0xF0, 0x18, 0x0E, 0x30, 0x03, 0xF0, 0x68, 0x0E, 0x40, 0x0E, 0xE0, 0xC8,
  0x0E, 0x40, 0x09, 0xF0, 0x38, 0x0E, 0x30, 0x04, 0xF0, 0x98, 0x0E, 0x40, 0x0D, 0xF0, 0x18, 0x0E,
  0x30, 0x07, 0xF0, 0x98, 0x0E, 0x30, 0x01, 0x0E, 0xF0, 0x28, 0x0E, 0x30, 0x08, 0xF0, 0xB8, 0x0E,
  0x30, 0x01, 0xF9, 0x05, 0x80, 0xE3, 0x00, 0x8F, 0x0E, 0x02, 0x80, 0xE3, 0x00, 0xDF, 0x0C, 0x80,
  0xE3, 0x00, 0x5F, 0x90, 0xB8, 0x0E, 0x30, 0x0A, 0xF9, 0x0A, 0x80, 0xE2, 0x00, 0x10, 0xDF, 0x90,
  0xA8, 0x0E, 0x20, 0x02, 0x0E, 0xF9, 0x0C, 0x01, 0x80, 0xE1, 0x00, 0x5F, 0xA0, 0xD0, 0x48, 0x0E,
  0x10, 0x06, 0xFB, 0x09, 0x01, 0x80, 0xE0, 0x00, 0x6F, 0xB0, 0xE0, 0x77, 0x77, 0x77, 0x01, 0x03,
  0x77, 0x10, 0x5F, 0xC8, 0x1E, 0x82, 0x77, 0x77, 0x18, 0x33, 0x7C, 0xF9, 0x77, 0x20, 0x30, 0xDF,
  0xD8, 0x1C, 0x73, 0x77, 0x78, 0x22, 0x58, 0xCD, 0x09, 0x77, 0x30, 0x10, 0xBF, 0xF8, 0xA3, 0xEB,
  0x86, 0x43, 0x11, 0x10, 0x11, 0x12, 0x34, 0x67, 0xAC, 0xEF, 0xA0, 0x97, 0x75, 0x06, 0x0E, 0x80,
  0xC6, 0xF0, 0x97, 0x76, 0x01, 0x09, 0x80, 0xC5, 0xF0, 0x97, 0x77, 0x10, 0x20, 0x98, 0x0C, 0x2F,
  0x0E, 0x06, 0x77, 0x73, 0x81, 0x17, 0xDF, 0xFF, 0xFC, 0x81, 0xE9, 0x57, 0x77, 0x71, 0x81, 0x27,
  0xBF, 0xFF, 0xC8, 0x2E, 0xA7, 0x38, 0x0C, 0x00, 0x84, 0x36, 0x9B, 0xDE, 0xFC, 0x85, 0xEC, 0xB9,
  0x64, 0x18, 0x0D, 0x30, 0x0F, 0x10, 0x30, 0x20, 0xF1, 0x77, 0x60,
  // "D" (U+0044)
  0x80, 0xA4, 0xB8, 0x00, 0x98, 0x37, 0x75, 0x31, 0x77, 0x77, 0x5F, 0xFF, 0xFE, 0x82, 0xCA, 0x63,
  0x77, 0x77, 0x80, 0xC2, 0xF8, 0x2E, 0xA6, 0x17, 0x77, 0x38, 0x0C, 0x6F, 0x0B, 0x05, 0x77, 0x71,
  0x80, 0xD0, 0xF0, 0xD0, 0x77, 0x76, 0x80, 0xD2, 0xF0, 0xE0, 0x77, 0x74, 0xF8, 0x09, 0x35, 0x87,
  0x67, 0x77, 0x89, 0xBC, 0xEF, 0xFB, 0x0D, 0x04, 0x77, 0x2E, 0x0E, 0x77, 0x73, 0x83, 0x14, 0x6A,
  0xEF, 0xF0, 0x97, 0x71, 0xE0, 0xE7, 0x77, 0x71, 0x81, 0x27, 0xCF, 0xD0, 0xD0, 0x27, 0x6E, 0x0E,
  0x77, 0x77, 0x48, 0x12, 0x8E, 0xFB, 0x0E, 0x04, 0x75, 0xE0, 0xE7, 0x77, 0x77, 0x07, 0x0E, 0xFB,
  0x05, 0x74, 0xE0, 0xE8, 0x0C, 0x00, 0x01, 0x08, 0xFB, 0x05, 0x73, 0xE0, 0xE8, 0x0C, 0x20, 0x03,
  0x0D, 0xFA, 0x04, 0x72, 0xE0, 0xE8, 0x0C, 0x40, 0x0A, 0xF9, 0x0E, 0x03, 0x71, 0xE0, 0xE8, 0x0C,
  0x50, 0x07, 0xF9, 0x0D, 0x01, 0x7E, 0x0E, 0x80, 0xC6, 0x00, 0x7F, 0x90, 0xA7, 0xE0, 0xE8, 0x0C,
  0x70, 0x07, 0xF9, 0x05, 0x6E, 0x0E, 0x80, 0xD0, 0x00, 0xAF, 0x0D, 0x6E, 0x0E, 0x80, 0xD1, 0x00,
  0xDF, 0x08, 0x5E, 0x0E, 0x80, 0xD1, 0x00, 0x3F, 0x0E, 0x01, 0x4E, 0x0E, 0x80, 0xD2, 0x00, 0x8F,
  0x08, 0x4E, 0x0E, 0x80, 0xD2, 0x00, 0x10, 0xEE, 0x0E, 0x4E, 0x0E, 0x80, 0xD3, 0x00, 0x7F, 0x06,
  0x3E, 0x0E, 0x80, 0xD4, 0x00, 0xEE, 0x0C, 0x3E, 0x0E, 0x80, 0xD4, 0x00, 0x8F, 0x02, 0x2E, 0x0E,
  0x80, 0xD4, 0x00, 0x2F, 0x07, 0x2E, 0x0E, 0x80, 0xD5, 0x00, 0xCE, 0x0B, 0x2E, 0x0E, 0x80, 0xD5,
  0x00, 0x7F, 0x2E, 0x0E, 0x80, 0xD5, 0x00, 0x2F, 0x04, 0x1E, 0x0E, 0x80, 0xD6, 0x00, 0xEE, 0x07,
  0x1E, 0x0E, 0x80, 0xD6, 0x00, 0xAE, 0x0B, 0x1E, 0x0E, 0x80, 0xD6, 0x00, 0x7E, 0x0D, 0x1E, 0x0E,
  0x80, 0xD6, 0x00, 0x4F, 0x1E, 0x0E, 0x80, 0xD6, 0x00, 0x1F, 0x03, 0xE0, 0xE8, 0x0D, 0x70, 0x0E,
  0xE0, 0x5E, 0x0E, 0x80, 0xD7, 0x00, 0xCE, 0x06, 0xE0, 0xE8, 0x0D, 0x70, 0x0B, 0xE0, 0x8E, 0x0E,
  0x80, 0xD7, 0x00, 0x9E, 0x09, 0xE0, 0xE8, 0x0D, 0x70, 0x08, 0xE0, 0xAE, 0x0E, 0x80, 0xD7, 0x00,
  0x7E, 0x0A, 0xE0, 0xE8, 0x0D, 0x70, 0x07, 0xE0, 0xBE, 0x0E, 0x80, 0xD7, 0x00, 0x7E, 0x0B, 0xE0,
  0xE8, 0x0D, 0x70, 0x06, 0xE0, 0xBE, 0x0E, 0x80, 0xD7, 0x00, 0x7E, 0x0B, 0xE0, 0xE8, 0x0D, 0x70,
  0x07, 0xE0, 0xBE, 0x0E, 0x80, 0xD7, 0x00, 0x7E, 0x0A, 0xE0, 0xE8, 0x0D, 0x70, 0x08, 0xE0, 0x9E,
  0x0E, 0x80, 0xD7, 0x00, 0x9E, 0x09, 0xE0, 0xE8, 0x0D, 0x70, 0x0A, 0xE0, 0x7E, 0x0E, 0x80, 0xD7,
  0x00, 0xCE, 0x06, 0xE0, 0xE8, 0x0D, 0x70, 0x0E, 0xE0, 0x4E, 0x0E, 0x80, 0xD6, 0x00, 0x1F, 0x02,
  0xE0, 0xE8, 0x0D, 0x60, 0x03, 0xF1, 0xE0, 0xE8, 0x0D, 0x60, 0x06, 0xE0, 0xD1, 0xE0, 0xE8, 0x0D,
  0x60, 0x09, 0xE0, 0xA1, 0xE0, 0xE8, 0x0D, 0x60, 0x0D, 0xE0, 0x71, 0xE0, 0xE8, 0x0D, 0x50, 0x01,
  0xF0, 0x41, 0xE0, 0xE8, 0x0D, 0x50, 0x05, 0xF2, 0xE0, 0xE8, 0x0D, 0x50, 0x0A, 0xE0, 0xB2, 0xE0,
  0xE8, 0x0D, 0x40, 0x01, 0xF0, 0x72, 0xE0, 0xE8, 0x0D, 0x40, 0x06, 0xF0, 0x22, 0xE0, 0xE8, 0x0D,
  0x40, 0x0C, 0xE0, 0xC3, 0xE0, 0xE8, 0x0D, 0x30, 0x04, 0xF0, 0x73, 0xE0, 0xE8, 0x0D, 0x30, 0x0B,
  0xF0, 0x13, 0xE0, 0xE8, 0x0D, 0x20, 0x04, 0xF0, 0x94, 0xE0, 0xE8, 0x0D, 0x20, 0x0D, 0xF0, 0x24,
  0xE0, 0xE8, 0x0D, 0x10, 0x08, 0xF0, 0xA5, 0xE0, 0xE8, 0x0D, 0x00, 0x04, 0xF9, 0x02, 0x5E, 0x0E,
  0x80, 0xC7, 0x00, 0x20, 0xEF, 0x07, 0x6E, 0x0E, 0x80, 0xC6, 0x00, 0x10, 0xDF, 0x0D, 0x7E, 0x0E,
  0x80, 0xC5, 0x00, 0x10, 0xCF, 0x90, 0x37, 0xE0, 0xE8, 0x0C, 0x40, 0x01, 0x0D, 0xF9, 0x06, 0x71,
  0xE0, 0xE8, 0x0C, 0x30, 0x03, 0x0E, 0xF9, 0x09, 0x72, 0xE0, 0xE8, 0x0C, 0x20, 0x07, 0xFA, 0x0B,
  0x73, 0xE0, 0xE8, 0x0C, 0x00, 0x03, 0x0C, 0xFA, 0x0B, 0x74, 0xE0, 0xE7, 0x77, 0x76, 0x02, 0x0A,
  0xFB, 0x0B, 0x75, 0xE0, 0xE7, 0x77, 0x74, 0x04, 0x0B, 0xFC, 0x09, 0x76, 0xE0, 0xE7, 0x77, 0x71,
  0x81, 0x38, 0xDF, 0xD0, 0x67, 0x7E, 0x0E, 0x77, 0x74, 0x82, 0x36, 0xAE, 0xFE, 0x0C, 0x02, 0x77,
  0x1E, 0x0E, 0x80, 0x94, 0x18, 0x62, 0x34, 0x57, 0x9A, 0xDF, 0xFA, 0x0E, 0x07, 0x77, 0x38, 0x0D,
  0x2F, 0x09, 0x01, 0x77, 0x48, 0x0D, 0x0F, 0x09, 0x02, 0x77, 0x68, 0x0C, 0x5F, 0x81, 0xC7, 0x17,
  0x77, 0x18, 0x0C, 0x2F, 0x81, 0xC7, 0x27, 0x77, 0x4F, 0xFF, 0xFD, 0x83, 0xEB, 0x85, 0x17, 0x77,
  0x7F, 0xFF, 0xB8, 0x7D, 0xDC, 0xB9, 0x86, 0x42, 0x77, 0x77, 0x50,
  // "E" (U+0045)
  0x80, 0xD3, 0xB8, 0x0B, 0xD6, 0xF8, 0x0C, 0x47, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0x80, 0xD0, 0xF0, 0xB2, 0x80, 0xD0, 0xF0, 0xB2, 0x80, 0xD0, 0xF0, 0xB2,
  0x80, 0xD0, 0xF0, 0xB2, 0x80, 0xD0, 0xF0, 0xB2, 0x80, 0xD0, 0xF0, 0xB2, 0xE0, 0xE8, 0x0C, 0x21,
  0x2E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x38, 0x0C, 0xA6, 0xF0,
  // "F" (U+0046)
  0x80, 0xD3, 0xB8, 0x0B, 0xD6, 0xF8, 0x0C, 0x47, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x21, 0x28, 0x0D, 0x0F, 0x0D, 0x28, 0x0D, 0x0F, 0x0D, 0x28, 0x0D, 0x0F, 0x0D,
  0x28, 0x0D, 0x0F, 0x0D, 0x28, 0x0D, 0x0F, 0x0D, 0x28, 0x0D, 0x0F, 0x0D, 0x2E, 0x0E, 0x80, 0xC2,
  0x12, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C,
  0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C,
  0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C,
  0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C,
  0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C,
  0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C,
  0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C,
  0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C,
  0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C,
  0x40, 0xE0, 0xE8, 0x0C, 0x40,
  // "G" (U+0047)
  0x77, 0x77, 0x68, 0x62, 0x57, 0x9B, 0xCD, 0xDD, 0x87, 0xDD, 0xCB, 0x97, 0x53, 0x18, 0x0D, 0x10,
  0x81, 0x48, 0xCF, 0xFF, 0xA8, 0x2D, 0xA7, 0x38, 0x0C, 0x10, 0x81, 0x16, 0xBF, 0xFF, 0xFC, 0x81,
  0xB6, 0x27, 0x77, 0x73, 0x03, 0x0A, 0x80, 0xC2, 0xF8, 0x1C, 0x71, 0x77, 0x75, 0x04, 0x0C, 0x80,
  0xC7, 0xF0, 0xA0, 0x47, 0x77, 0x10, 0x30, 0xB8, 0x0D, 0x3F, 0x05, 0x77, 0x50, 0x10, 0x9F, 0xF9,
  0x8A, 0x0E, 0xCA, 0x86, 0x54, 0x33, 0x33, 0x45, 0x78, 0xAC, 0xEF, 0xF9, 0x0E, 0x77, 0x50, 0x40,
  0xEF, 0xD8, 0x2E, 0xA6, 0x37, 0x74, 0x82, 0x25, 0x8C, 0xFC, 0x07, 0x77, 0x40, 0x8F, 0xD0, 0xA0,
  0x47, 0x77, 0x68, 0x14, 0x9E, 0xE0, 0xE0, 0x17, 0x72, 0x01, 0x0B, 0xFB, 0x81, 0xE7, 0x17, 0x77,
  0x74, 0x81, 0x4A, 0xEB, 0x08, 0x77, 0x20, 0x20, 0xDF, 0xA0, 0xE0, 0x78, 0x0C, 0x20, 0x82, 0x6D,
  0xF1, 0x77, 0x10, 0x20, 0xDF, 0xA0, 0xA0, 0x18, 0x0C, 0x50, 0x03, 0x77, 0x10, 0x20, 0xEF, 0x90,
  0xE0, 0x58, 0x0E, 0x60, 0x01, 0x0D, 0xF9, 0x0C, 0x02, 0x80, 0xE7, 0x00, 0xCF, 0x90, 0xA8, 0x0F,
  0x00, 0x09, 0xF9, 0x09, 0x80, 0xF0, 0x00, 0x5F, 0x90, 0x98, 0x0F, 0x00, 0x01, 0x0E, 0xF0, 0xA8,
  0x0F, 0x10, 0x0B, 0xF0, 0xC8, 0x0F, 0x10, 0x05, 0xF0, 0xE0, 0x28, 0x0F, 0x10, 0x0D, 0xF0, 0x58,
  0x0F, 0x10, 0x06, 0xF0, 0xB8, 0x0F, 0x20, 0x0D, 0xE0, 0xE0, 0x18, 0x0F, 0x10, 0x06, 0xF0, 0x88,
  0x0F, 0x20, 0x0C, 0xE0, 0xE8, 0x0F, 0x20, 0x03, 0xF0, 0x78, 0x0F, 0x20, 0x09, 0xE0, 0xE0, 0x18,
  0x0F, 0x20, 0x0E, 0xE0, 0x98, 0x0F, 0x20, 0x04, 0xF0, 0x38, 0x0F, 0x20, 0x09, 0xE0, 0xD8, 0x0F,
  0x30, 0x0D, 0xE0, 0x98, 0x0F, 0x20, 0x01, 0xF0, 0x48, 0x0F, 0x20, 0x05, 0xF8, 0x0F, 0x30, 0x08,
  0xE0, 0xC8, 0x0F, 0x30, 0x0B, 0xE0, 0x88, 0x0F, 0x30, 0x0D, 0xE0, 0x68, 0x0F, 0x30, 0xF0, 0x38,
  0x0F, 0x20, 0x02, 0xF0, 0x18, 0x0F, 0x20, 0x04, 0xE0, 0xE8, 0x0F, 0x30, 0x05, 0xE0, 0xD8, 0x0F,
  0x30, 0x06, 0xE0, 0xC8, 0x0F, 0x30, 0x07, 0xE0, 0xB8, 0x0F, 0x30, 0x08, 0xE0, 0xA8, 0x0F, 0x30,
  0x08, 0xE0, 0xA7, 0x77, 0x73, 0x06, 0x80, 0xB2, 0xB0, 0x50, 0x8E, 0x09, 0x77, 0x77, 0x30, 0x8F,
  0xFF, 0xFA, 0x07, 0x08, 0xE0, 0xA7, 0x77, 0x73, 0x08, 0xFF, 0xFF, 0xA0, 0x70, 0x8E, 0x0A, 0x77,
  0x77, 0x30, 0x8F, 0xFF, 0xFA, 0x00, 0x7E, 0x0B, 0x77, 0x77, 0x30, 0x8F, 0xFF, 0xFA, 0x07, 0x06,
  0xE0, 0xB7, 0x77, 0x73, 0x08, 0xFF, 0xFF, 0xA0, 0x70, 0x5E, 0x0D, 0x77, 0x77, 0x30, 0x58, 0x0A,
  0x39, 0x0C, 0xE0, 0x70, 0x4E, 0x0E, 0x80, 0xE3, 0x00, 0x6E, 0x07, 0x03, 0xF8, 0x0E, 0x30, 0x06,
  0xE0, 0x70, 0x1F, 0x02, 0x80, 0xE2, 0x00, 0x6E, 0x81, 0x70, 0xEE, 0x04, 0x80, 0xE2, 0x00, 0x6E,
  0x81, 0x70, 0xCE, 0x07, 0x80, 0xE2, 0x00, 0x6E, 0x81, 0x70, 0xAE, 0x09, 0x80, 0xE2, 0x00, 0x6E,
  0x81, 0x70, 0x7E, 0x0D, 0x80, 0xE2, 0x00, 0x6E, 0x81, 0x70, 0x4F, 0x01, 0x80, 0xE1, 0x00, 0x6E,
  0x81, 0x70, 0x1F, 0x05, 0x80, 0xE1, 0x00, 0x6E, 0x07, 0x20, 0xCE, 0x09, 0x80, 0xE1, 0x00, 0x6E,
  0x07, 0x20, 0x8E, 0x0E, 0x80, 0xE1, 0x00, 0x6E, 0x07, 0x20, 0x3F, 0x04, 0x80, 0xE0, 0x00, 0x6E,
  0x07, 0x30, 0xEE, 0x09, 0x80, 0xE0, 0x00, 0x6E, 0x07, 0x30, 0x9F, 0x01, 0x80, 0xD7, 0x00, 0x6E,
  0x07, 0x30, 0x3F, 0x07, 0x80, 0xD7, 0x00, 0x6E, 0x07, 0x40, 0xCE, 0x0E, 0x80, 0xD7, 0x00, 0x6E,
  0x07, 0x40, 0x6F, 0x07, 0x80, 0xD6, 0x00, 0x6E, 0x07, 0x50, 0xEE, 0x0E, 0x01, 0x80, 0xD5, 0x00,
  0x6E, 0x07, 0x50, 0x7F, 0x0B, 0x80, 0xD5, 0x00, 0x6E, 0x07, 0x60, 0xDF, 0x06, 0x80, 0xD4, 0x00,
  0x6E, 0x07, 0x60, 0x5F, 0x0E, 0x03, 0x80, 0xD3, 0x00, 0x6E, 0x07, 0x70, 0xBF, 0x0D, 0x01, 0x80,
  0xD2, 0x00, 0x6E, 0x07, 0x70, 0x20, 0xEF, 0x0C, 0x01, 0x80, 0xD1, 0x00, 0x6E, 0x07, 0x71, 0x06,
  0xF9, 0x0C, 0x01, 0x80, 0xD0, 0x00, 0x6E, 0x07, 0x72, 0x09, 0xF9, 0x0D, 0x02, 0x80, 0xC7, 0x00,
  0x6E, 0x07, 0x73, 0x0C, 0xF9, 0x0E, 0x05, 0x80, 0xC6, 0x00, 0x6E, 0x07, 0x73, 0x01, 0x0D, 0xFA,
  0x0A, 0x01, 0x80, 0xC4, 0x00, 0x6E, 0x07, 0x74, 0x01, 0x0D, 0xFA, 0x0E, 0x06, 0x80, 0xC3, 0x00,
  0x6E, 0x07, 0x75, 0x01, 0x0C, 0xFB, 0x0D, 0x06, 0x80, 0xC1, 0x00, 0x6E, 0x07, 0x76, 0x01, 0x0B,
  0xFC, 0x81, 0xE8, 0x37, 0x77, 0x73, 0x81, 0x26, 0xBF, 0x07, 0x77, 0x10, 0x8F, 0xE8, 0x2D, 0x94,
  0x17, 0x77, 0x28, 0x22, 0x59, 0xDF, 0xB0, 0x77, 0x72, 0x04, 0x0D, 0xFF, 0x98, 0x5D, 0xA8, 0x53,
  0x21, 0x71, 0x86, 0x12, 0x35, 0x79, 0xCE, 0xFF, 0x07, 0x77, 0x40, 0x8F, 0xFF, 0xB0, 0xD0, 0xEF,
  0xFF, 0xC0, 0x77, 0x75, 0x02, 0x0A, 0x80, 0xD3, 0xF8, 0x1D, 0x82, 0x77, 0x78, 0x12, 0x9E, 0x80,
  0xC5, 0xF8, 0x1E, 0x94, 0x77, 0x76, 0x05, 0x0B, 0x80, 0xC0, 0xF8, 0x1C, 0x83, 0x77, 0x77, 0x48,
  0x21, 0x59, 0xDF, 0xFF, 0xE8, 0x2E, 0xA7, 0x48, 0x0C, 0x40, 0x85, 0x14, 0x69, 0xBD, 0xEF, 0xD8,
  0x6E, 0xDB, 0x98, 0x63, 0x18, 0x0E, 0x00, 0x0F, 0x10, 0x03, 0x80, 0x01, 0x77, 0x73,
  // "H" (U+0048)
  0x80, 0x3B, 0x80, 0xD4, 0x00, 0x28, 0x02, 0xB0, 0x8E, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0,
  0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40,
  0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE,
  0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4,
  0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B,
  0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D,
  0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0,
  0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80,
  0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E,
  0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8,
  0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03,
  0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E,
  0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00,
  0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0,
  0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40,
  0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0x80, 0xF2, 0xF0, 0xB8, 0x0F, 0x2F, 0x0B,
  0x80, 0xF2, 0xF0, 0xB8, 0x0F, 0x2F, 0x0B, 0x80, 0xF2, 0xF0, 0xB8, 0x0F, 0x2F, 0x0B, 0xE0, 0xE8,
  0x0D, 0x43, 0x06, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03,
  0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E,
  0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00,
  0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0,
  0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40,
  0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE,
  0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4,
  0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B,
  0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D,
  0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0,
  0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80,
  0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E,
  0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8,
  0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03,
  0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E,
  0x80, 0xD4, 0x00, 0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00,
  0x3E, 0x0B, 0xE0, 0xE8, 0x0D, 0x40, 0x03, 0xE0, 0xBE, 0x0E, 0x80, 0xD4, 0x00, 0x3E, 0x0B,
  // "I" (U+0049)
  0x80, 0xA5, 0xB0, 0x2F, 0xFF, 0xC0, 0x3F, 0xFF, 0xC0, 0x3F, 0xFF, 0xC8, 0x13, 0xBD, 0xFF, 0xF8,
  0x1E, 0xB1, 0x38, 0x32, 0x57, 0xAC, 0xFA, 0x84, 0xDA, 0x85, 0x31, 0x75, 0x0D, 0xE0, 0x17, 0x74,
  0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74,
  0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74,
  0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74,
  0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74,
  0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74,
  0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74,
  0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74,
  0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74,
  0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74,
  0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74,
  0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74,
  0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74,
  0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74,
  0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74,
  0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74,
  0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74,
  0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74,
  0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74, 0x0D, 0xE0, 0x17, 0x74,
  0x0D, 0xE0, 0x17, 0x78, 0x31, 0x46, 0x8E, 0xE8, 0x29, 0x64, 0x26, 0x83, 0x68, 0xAC, 0xEF, 0xFA,
  0x83, 0xDA, 0x86, 0x1F, 0xFF, 0xC0, 0x3F, 0xFF, 0xC0, 0x3F, 0xFF, 0xC0, 0x3F, 0xFF, 0xC0, 0x30,
  // "J" (U+004A)
  0x77, 0x71, 0x01, 0x80, 0x2B, 0x09, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77,
  0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E,
  0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77,
  0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0,
  0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71,
  0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D,
  0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10,
  0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7,
  0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01,
  0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77,
  0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E,
  0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77,
  0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0,
  0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71,
  0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D,
  0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10,
  0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7,
  0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01,
  0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77,
  0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E,
  0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77,
  0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0,
  0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71,
  0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D, 0x77, 0x71, 0x01, 0xE0, 0xD7, 0x77, 0x10, 0x1E, 0x0D,
  0x77, 0x71, 0x01, 0xE0, 0xC7, 0x77, 0x10, 0x2E, 0x0C, 0x77, 0x71, 0x02, 0xE0, 0xB7, 0x77, 0x10,
  0x4E, 0x0A, 0x77, 0x71, 0x05, 0xE0, 0x97, 0x77, 0x10, 0x8E, 0x07, 0x77, 0x71, 0x0B, 0xE0, 0x47,
  0x77, 0x10, 0xEE, 0x01, 0x77, 0x70, 0x4E, 0x0D, 0x77, 0x71, 0x0A, 0xE0, 0x97, 0x77, 0x02, 0xF0,
  0x47, 0x77, 0x0B, 0xE0, 0xD7, 0x77, 0x06, 0xF0, 0x77, 0x76, 0x06, 0xF0, 0xE7, 0x76, 0x09, 0xF9,
  0x06, 0x38, 0x26, 0x85, 0x17, 0x38, 0x12, 0x7E, 0xF9, 0x0B, 0x40, 0x8B, 0x89, 0x0E, 0xB9, 0x77,
  0x57, 0x8A, 0xDF, 0xB0, 0xD0, 0x14, 0x08, 0xFF, 0xF9, 0x0E, 0x02, 0x50, 0x8F, 0xFF, 0x0D, 0x02,
  0x60, 0x8F, 0xFE, 0x0A, 0x01, 0x70, 0x8F, 0xFC, 0x0C, 0x04, 0x72, 0x81, 0x4A, 0xEF, 0xE8, 0x1E,
  0x94, 0x77, 0x89, 0x32, 0x68, 0xAB, 0xDD, 0xCB, 0xA8, 0x63, 0x77,
  // "K" (U+004B)
  0x80, 0x3B, 0x80, 0xC5, 0x00, 0x38, 0x04, 0xB0, 0x31, 0xE0, 0xE8, 0x0C, 0x40, 0x03, 0x0E, 0xF0,
  0x72, 0xE0, 0xE8, 0x0C, 0x30, 0x03, 0x0E, 0xF0, 0x73, 0xE0, 0xE8, 0x0C, 0x20, 0x02, 0x0E, 0xF0,
  0x84, 0xE0, 0xE8, 0x0C, 0x10, 0x02, 0x0D, 0xF0, 0x95, 0xE0, 0xE8, 0x0C, 0x00, 0x01, 0x0D, 0xF0,
  0x96, 0xE0, 0xE7, 0x77, 0x77, 0x01, 0x0D, 0xF0, 0xA7, 0xE0, 0xE7, 0x77, 0x76, 0x01, 0x0C, 0xF0,
  0xB7, 0x1E, 0x0E, 0x77, 0x77, 0x60, 0xCF, 0x0B, 0x72, 0xE0, 0xE7, 0x77, 0x75, 0x0B, 0xF0, 0xC7,
  0x3E, 0x0E, 0x77, 0x77, 0x40, 0xBF, 0x0C, 0x01, 0x73, 0xE0, 0xE7, 0x77, 0x73, 0x0A, 0xF0, 0xD0,
  0x17, 0x4E, 0x0E, 0x77, 0x77, 0x20, 0xAF, 0x0D, 0x01, 0x75, 0xE0, 0xE7, 0x77, 0x71, 0x09, 0xF0,
  0xD0, 0x17, 0x6E, 0x0E, 0x77, 0x77, 0x08, 0xF0, 0xE0, 0x27, 0x7E, 0x0E, 0x77, 0x76, 0x07, 0xF0,
  0xE0, 0x27, 0x71, 0xE0, 0xE7, 0x77, 0x50, 0x7F, 0x0E, 0x03, 0x77, 0x2E, 0x0E, 0x77, 0x74, 0x06,
  0xF0, 0xE0, 0x37, 0x73, 0xE0, 0xE7, 0x77, 0x30, 0x5F, 0x90, 0x47, 0x74, 0xE0, 0xE7, 0x77, 0x20,
  0x5F, 0x90, 0x47, 0x75, 0xE0, 0xE7, 0x77, 0x10, 0x4F, 0x90, 0x57, 0x76, 0xE0, 0xE7, 0x77, 0x04,
  0xF9, 0x06, 0x77, 0x7E, 0x0E, 0x77, 0x60, 0x30, 0xEF, 0x06, 0x77, 0x71, 0xE0, 0xE7, 0x75, 0x03,
  0x0E, 0xF0, 0x77, 0x77, 0x2E, 0x0E, 0x77, 0x40, 0x20, 0xEF, 0x08, 0x77, 0x73, 0xE0, 0xE7, 0x73,
  0x02, 0x0D, 0xF0, 0x87, 0x77, 0x4E, 0x0E, 0x77, 0x20, 0x10, 0xDF, 0x09, 0x77, 0x75, 0xE0, 0xE7,
  0x71, 0x01, 0x0D, 0xF0, 0xA7, 0x77, 0x6E, 0x0E, 0x77, 0x01, 0x0C, 0xF0, 0xA7, 0x77, 0x7E, 0x0E,
  0x77, 0x0C, 0xF0, 0xB7, 0x77, 0x71, 0xE0, 0xE7, 0x60, 0xBF, 0x0B, 0x77, 0x77, 0x2E, 0x0E, 0x75,
  0x0B, 0xF0, 0xC7, 0x77, 0x73, 0xE0, 0xE7, 0x40, 0xAF, 0x0C, 0x01, 0x77, 0x77, 0x3E, 0x0E, 0x73,
  0x0A, 0xF0, 0xD0, 0x17, 0x77, 0x74, 0xE0, 0xE7, 0x20, 0x9F, 0x0D, 0x01, 0x77, 0x77, 0x5E, 0x0E,
  0x71, 0x07, 0xF0, 0xD0, 0x27, 0x77, 0x76, 0xE0, 0xE7, 0x06, 0xF0, 0xE0, 0x27, 0x77, 0x77, 0xE0,
  0xE6, 0x05, 0xFA, 0x04, 0x77, 0x77, 0x7E, 0x0E, 0x50, 0x4F, 0xB0, 0xE0, 0x17, 0x77, 0x76, 0xE0,
  0xE4, 0x03, 0x0E, 0xFC, 0x0B, 0x77, 0x77, 0x6E, 0x0E, 0x30, 0x30, 0xEF, 0xE0, 0x77, 0x77, 0x75,
  0xE0, 0xE2, 0x02, 0x0E, 0xE0, 0xDF, 0x90, 0x37, 0x77, 0x74, 0xE8, 0x2E, 0x01, 0xDE, 0x81, 0xA0,
  0xAF, 0x0D, 0x01, 0x77, 0x77, 0x3E, 0x81, 0xE0, 0xCE, 0x09, 0x20, 0x10, 0xDF, 0x0A, 0x77, 0x77,
  0x3E, 0x0E, 0x0B, 0xE0, 0x94, 0x03, 0xF9, 0x06, 0x77, 0x77, 0x2F, 0xE0, 0x86, 0x07, 0xF0, 0xE0,
  0x27, 0x77, 0x71, 0xFD, 0x07, 0x71, 0x0B, 0xF0, 0xC7, 0x77, 0x71, 0xFC, 0x07, 0x72, 0x01, 0x0E,
  0xF0, 0x87, 0x77, 0x7F, 0xB0, 0x67, 0x40, 0x4F, 0x90, 0x47, 0x77, 0x6F, 0xA0, 0x57, 0x60, 0x8F,
  0x0E, 0x01, 0x77, 0x75, 0xF9, 0x05, 0x77, 0x10, 0xCF, 0x0B, 0x77, 0x75, 0xF0, 0x47, 0x72, 0x02,
  0x0E, 0xF0, 0x77, 0x77, 0x4E, 0x0E, 0x77, 0x40, 0x5F, 0x90, 0x37, 0x77, 0x3E, 0x0E, 0x77, 0x50,
  0x9F, 0x0D, 0x01, 0x77, 0x72, 0xE0, 0xE7, 0x76, 0x0D, 0xF0, 0xA7, 0x77, 0x2E, 0x0E, 0x77, 0x60,
  0x3F, 0x90, 0x67, 0x77, 0x1E, 0x0E, 0x77, 0x70, 0x6F, 0x0E, 0x02, 0x77, 0x7E, 0x0E, 0x77, 0x71,
  0x0A, 0xF0, 0xC7, 0x77, 0xE0, 0xE7, 0x77, 0x10, 0x10, 0xDF, 0x08, 0x77, 0x6E, 0x0E, 0x77, 0x72,
  0x03, 0xF9, 0x04, 0x77, 0x5E, 0x0E, 0x77, 0x73, 0x07, 0xF0, 0xE0, 0x17, 0x74, 0xE0, 0xE7, 0x77,
  0x40, 0xBF, 0x0B, 0x77, 0x4E, 0x0E, 0x77, 0x74, 0x01, 0x0E, 0xF0, 0x77, 0x73, 0xE0, 0xE7, 0x77,
  0x50, 0x4F, 0x90, 0x37, 0x72, 0xE0, 0xE7, 0x77, 0x60, 0x9F, 0x0D, 0x77, 0x2E, 0x0E, 0x77, 0x77,
  0x0C, 0xF0, 0xA7, 0x71, 0xE0, 0xE7, 0x77, 0x70, 0x20, 0xEF, 0x06, 0x77, 0xE0, 0xE7, 0x77, 0x71,
  0x06, 0xF0, 0xE0, 0x27, 0x6E, 0x0E, 0x77, 0x77, 0x20, 0xAF, 0x0C, 0x76, 0xE0, 0xE7, 0x77, 0x73,
  0x0D, 0xF0, 0x87, 0x5E, 0x0E, 0x77, 0x77, 0x30, 0x3F, 0x90, 0x47, 0x4E, 0x0E, 0x77, 0x77, 0x40,
  0x7F, 0x0E, 0x01, 0x73, 0xE0, 0xE7, 0x77, 0x75, 0x0B, 0xF0, 0xB7, 0x3E, 0x0E, 0x77, 0x77, 0x50,
  0x10, 0xEF, 0x07, 0x72, 0xE0, 0xE7, 0x77, 0x76, 0x04, 0xF9, 0x03, 0x71, 0xE0, 0xE7, 0x77, 0x77,
  0x08, 0xF0, 0xD7, 0x1E, 0x0E, 0x80, 0xC0, 0x00, 0xCF, 0x0A, 0x7E, 0x0E, 0x80, 0xC0, 0x00, 0x10,
  0xEF, 0x05, 0x6E, 0x0E, 0x80, 0xC1, 0x00, 0x5F, 0x0E, 0x02, 0x5E, 0x0E, 0x80, 0xC2, 0x00, 0x9F,
  0x0C, 0x5E, 0x0E, 0x80, 0xC3, 0x00, 0xCF, 0x08, 0x4E, 0x0E, 0x80, 0xC3, 0x00, 0x20, 0xEF, 0x04,
  0x3E, 0x0E, 0x80, 0xC4, 0x00, 0x6F, 0x0E, 0x01, 0x2E, 0x0E, 0x80, 0xC5, 0x00, 0xAF, 0x0B, 0x2E,
  0x0E, 0x80, 0xC5, 0x00, 0x10, 0xDF, 0x07, 0x1E, 0x0E, 0x80, 0xC6, 0x00, 0x3F, 0x90, 0x30,
  // "L" (U+004C)
  0x80, 0x3B, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x38, 0x0C, 0xA6, 0xF0,
  // "M" (U+004D)
  0x80, 0x6B, 0x07, 0x80, 0xE7, 0x00, 0x98, 0x05, 0xB0, 0x7F, 0xB0, 0xE0, 0x18, 0x0E, 0x50, 0x02,
  0xFB, 0x09, 0xFC, 0x06, 0x80, 0xE5, 0x00, 0x8F, 0xB0, 0x9F, 0xC0, 0xC8, 0x0E, 0x50, 0x0E, 0xFB,
  0x09, 0xFD, 0x03, 0x80, 0xE3, 0x00, 0x5F, 0xC0, 0x9F, 0xD0, 0x98, 0x0E, 0x30, 0x0B, 0xFC, 0x09,
  0xFD, 0x0E, 0x80, 0xE2, 0x00, 0x2F, 0xD0, 0x9E, 0x0D, 0xE0, 0x58, 0x0E, 0x10, 0x08, 0xD0, 0x0E,
  0xD0, 0x9E, 0x04, 0xE0, 0xC8, 0x0E, 0x10, 0x0E, 0xD0, 0x70, 0xDD, 0x09, 0xE0, 0x10, 0xCE, 0x02,
  0x80, 0xD7, 0x00, 0x5E, 0x01, 0x0E, 0xD0, 0x9E, 0x02, 0x06, 0xE0, 0x88, 0x0D, 0x70, 0x0B, 0xD0,
  0xB1, 0xE0, 0x9E, 0x03, 0x01, 0xE0, 0xE8, 0x0D, 0x60, 0x02, 0xE0, 0x41, 0xE0, 0x9E, 0x81, 0x40,
  0xAE, 0x05, 0x80, 0xD5, 0x00, 0x8D, 0x81, 0xE0, 0x1E, 0x09, 0xE8, 0x14, 0x04, 0xE0, 0xB8, 0x0D,
  0x50, 0x0E, 0xD8, 0x18, 0x02, 0xE0, 0x9E, 0x05, 0x20, 0xDE, 0x02, 0x80, 0xD3, 0x00, 0x5E, 0x81,
  0x20, 0x2E, 0x09, 0xE0, 0x52, 0x07, 0xE0, 0x88, 0x0D, 0x30, 0x0B, 0xD0, 0xB2, 0x03, 0xE0, 0x9E,
  0x05, 0x20, 0x1E, 0x0D, 0x80, 0xD2, 0x00, 0x2E, 0x05, 0x20, 0x3E, 0x09, 0xE0, 0x63, 0x0A, 0xE0,
  0x48, 0x0D, 0x10, 0x08, 0xD0, 0xE3, 0x03, 0xE0, 0x9E, 0x06, 0x30, 0x4E, 0x0A, 0x80, 0xD1, 0x00,
  0xDD, 0x08, 0x30, 0x3E, 0x09, 0xE0, 0x64, 0x0D, 0xE0, 0x18, 0x0C, 0x70, 0x04, 0xE0, 0x23, 0x04,
  0xE0, 0x9E, 0x07, 0x40, 0x7E, 0x07, 0x80, 0xC7, 0x00, 0xBD, 0x0B, 0x40, 0x4E, 0x09, 0xE0, 0x74,
  0x02, 0xE0, 0xD8, 0x0C, 0x60, 0x01, 0xE0, 0x54, 0x04, 0xE0, 0x9E, 0x07, 0x50, 0xBE, 0x04, 0x80,
  0xC5, 0x00, 0x7D, 0x0E, 0x50, 0x4E, 0x09, 0xE0, 0x75, 0x05, 0xE0, 0xA8, 0x0C, 0x50, 0x0D, 0xD0,
  0x85, 0x04, 0xE0, 0x9E, 0x07, 0x60, 0xEE, 0x01, 0x80, 0xC3, 0x00, 0x4E, 0x02, 0x50, 0x4E, 0x09,
  0xE0, 0x76, 0x08, 0xE0, 0x78, 0x0C, 0x30, 0x0A, 0xD0, 0xC6, 0x04, 0xE0, 0x9E, 0x07, 0x60, 0x2E,
  0x0D, 0x80, 0xC2, 0x00, 0x1E, 0x05, 0x60, 0x4E, 0x09, 0xE0, 0x77, 0x0B, 0xE0, 0x38, 0x0C, 0x10,
  0x07, 0xD0, 0xE7, 0x04, 0xE0, 0x9E, 0x07, 0x70, 0x5E, 0x09, 0x80, 0xC1, 0x00, 0xDD, 0x09, 0x70,
  0x4E, 0x09, 0xE0, 0x77, 0x10, 0xED, 0x0E, 0x01, 0x77, 0x77, 0x70, 0x4E, 0x03, 0x70, 0x4E, 0x09,
  0xE0, 0x77, 0x10, 0x9E, 0x06, 0x77, 0x77, 0x70, 0xAD, 0x0C, 0x71, 0x04, 0xE0, 0x9E, 0x07, 0x71,
  0x03, 0xE0, 0xC7, 0x77, 0x76, 0x01, 0xE0, 0x67, 0x10, 0x4E, 0x09, 0xE0, 0x77, 0x20, 0xCE, 0x03,
  0x77, 0x77, 0x50, 0x7D, 0x0E, 0x72, 0x04, 0xE0, 0x9E, 0x07, 0x72, 0x06, 0xE0, 0x97, 0x77, 0x75,
  0x0D, 0xD0, 0x97, 0x20, 0x4E, 0x09, 0xE0, 0x77, 0x30, 0xED, 0x0E, 0x77, 0x77, 0x40, 0x4E, 0x03,
  0x72, 0x04, 0xE0, 0x9E, 0x07, 0x73, 0x09, 0xE0, 0x57, 0x77, 0x73, 0x0A, 0xD0, 0xC7, 0x30, 0x4E,
  0x09, 0xE0, 0x77, 0x30, 0x3E, 0x0C, 0x77, 0x77, 0x20, 0x1E, 0x06, 0x73, 0x04, 0xE0, 0x9E, 0x07,
  0x74, 0x0D, 0xE0, 0x27, 0x77, 0x71, 0x07, 0xD0, 0xE0, 0x17, 0x30, 0x4E, 0x09, 0xE0, 0x77, 0x40,
  0x6E, 0x08, 0x77, 0x77, 0x10, 0xDD, 0x09, 0x74, 0x04, 0xE0, 0x9E, 0x07, 0x74, 0x01, 0xE0, 0xE7,
  0x77, 0x70, 0x4E, 0x03, 0x74, 0x04, 0xE0, 0x9E, 0x07, 0x75, 0x0A, 0xE0, 0x57, 0x77, 0x60, 0xAD,
  0x0D, 0x75, 0x04, 0xE0, 0x9E, 0x07, 0x75, 0x04, 0xE0, 0xB7, 0x77, 0x50, 0x1E, 0x07, 0x75, 0x04,
  0xE0, 0x9E, 0x07, 0x76, 0x0D, 0xE0, 0x27, 0x77, 0x40, 0x7E, 0x01, 0x75, 0x04, 0xE0, 0x9E, 0x07,
  0x76, 0x07, 0xE0, 0x87, 0x77, 0x40, 0xDD, 0x0A, 0x76, 0x04, 0xE0, 0x9E, 0x07, 0x76, 0x01, 0xE0,
  0xE7, 0x77, 0x30, 0x4E, 0x04, 0x76, 0x04, 0xE0, 0x9E, 0x07, 0x77, 0x0A, 0xE0, 0x47, 0x77, 0x20,
  0xAD, 0x0D, 0x77, 0x04, 0xE0, 0x9E, 0x07, 0x77, 0x04, 0xE0, 0xA7, 0x77, 0x10, 0x1E, 0x07, 0x77,
  0x04, 0xE0, 0x9E, 0x07, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x70, 0x7E, 0x01, 0x77, 0x04, 0xE0, 0x9E,
  0x07, 0x77, 0x10, 0x8E, 0x07, 0x77, 0x70, 0xDD, 0x0A, 0x77, 0x10, 0x4E, 0x09, 0xE0, 0x77, 0x71,
  0x02, 0xE0, 0xD7, 0x76, 0x03, 0xE0, 0x47, 0x71, 0x04, 0xE0, 0x9E, 0x07, 0x77, 0x20, 0xBE, 0x04,
  0x77, 0x50, 0x9D, 0x0D, 0x77, 0x20, 0x4E, 0x09, 0xE0, 0x77, 0x72, 0x05, 0xE0, 0xA7, 0x74, 0x01,
  0xE0, 0x77, 0x72, 0x04, 0xE0, 0x9E, 0x07, 0x77, 0x30, 0xEE, 0x01, 0x77, 0x30, 0x6E, 0x01, 0x77,
  0x20, 0x4E, 0x09, 0xE0, 0x77, 0x73, 0x08, 0xE0, 0x77, 0x73, 0x0C, 0xD0, 0xA7, 0x73, 0x04, 0xE0,
  0x9E, 0x07, 0x77, 0x30, 0x2E, 0x0D, 0x77, 0x20, 0x3E, 0x04, 0x77, 0x30, 0x4E, 0x09, 0xE0, 0x77,
  0x74, 0x0B, 0xE0, 0x37, 0x71, 0x09, 0xD0, 0xD7, 0x74, 0x04, 0xE0, 0x9E, 0x07, 0x77, 0x40, 0x5E,
  0x09, 0x77, 0x01, 0x0E, 0xD0, 0x77, 0x74, 0x04, 0xE0, 0x9E, 0x07, 0x77, 0x50, 0xED, 0x0E, 0x01,
  0x76, 0x06, 0xE0, 0x17, 0x74, 0x04, 0xE0, 0x9E, 0x07, 0x77, 0x50, 0x9E, 0x06, 0x76, 0x0C, 0xD0,
  0xB7, 0x75, 0x04, 0xE0, 0x9E, 0x07, 0x77, 0x50, 0x3E, 0x0C, 0x75, 0x03, 0xE0, 0x57, 0x75, 0x04,
  0xE0, 0x9E, 0x07, 0x77, 0x60, 0xCE, 0x03, 0x74, 0x09, 0xD0, 0xE7, 0x76, 0x04, 0xE0, 0x9E, 0x07,
  0x77, 0x60, 0x6E, 0x09, 0x74, 0x0E, 0xD0, 0x87, 0x76, 0x04, 0xE0, 0x9E, 0x07, 0x77, 0x70, 0xED,
  0x0E, 0x73, 0x06, 0xE0, 0x27, 0x76, 0x04, 0xE0, 0x9E, 0x07, 0x77, 0x70, 0x9E, 0x06, 0x72, 0x0C,
  0xD0, 0xB7, 0x77, 0x04, 0xE0, 0x9E, 0x07, 0x77, 0x70, 0x3E, 0x0C, 0x71, 0x03, 0xE0, 0x57, 0x77,
  0x04, 0xE0, 0x9E, 0x07, 0x77, 0x71, 0x0D, 0xE0, 0x27, 0x09, 0xD0, 0xE7, 0x77, 0x10, 0x4E, 0x09,
  0xE0, 0x77, 0x77, 0x10, 0x7E, 0x08, 0x70, 0xED, 0x08, 0x77, 0x71, 0x04, 0xE0, 0x9E, 0x07, 0x77,
  0x71, 0x01, 0xE0, 0xE6, 0x06, 0xE0, 0x27, 0x77, 0x10, 0x4E, 0x09, 0xE0, 0x77, 0x77, 0x20, 0xAE,
  0x05, 0x50, 0xCD, 0x0B, 0x77, 0x72, 0x04, 0xE0, 0x9E, 0x07, 0x77, 0x72, 0x04, 0xE0, 0xB4, 0x03,
  0xE0, 0x57, 0x77, 0x20, 0x4E, 0x09, 0xE0, 0x77, 0x77, 0x30, 0xDE, 0x02, 0x30, 0x9D, 0x0E, 0x77,
  0x73, 0x04, 0xE0, 0x9E, 0x07, 0x77, 0x73, 0x07, 0xE0, 0x83, 0x0E, 0xD0, 0x97, 0x77, 0x30, 0x4E,
  0x09, 0xE0, 0x77, 0x77, 0x30, 0x1E, 0x0E, 0x20, 0x6E, 0x02, 0x77, 0x73, 0x04, 0xE0, 0x9E, 0x07,
  0x77, 0x74, 0x0A, 0xE8, 0x14, 0x0C, 0xD0, 0xC7, 0x77, 0x40, 0x4E, 0x09, 0xE0, 0x77, 0x77, 0x40,
  0x4E, 0x0B, 0x02, 0xE0, 0x67, 0x77, 0x40, 0x4E, 0x09, 0xE0, 0x77, 0x77, 0x50, 0xDE, 0x0C, 0xD0,
  0xE7, 0x77, 0x50, 0x4E, 0x09, 0xE0, 0x77, 0x77, 0x50, 0x8F, 0xD0, 0x97, 0x77, 0x50, 0x4E, 0x09,
  0xE0, 0x77, 0x77, 0x50, 0x2F, 0xD0, 0x37, 0x77, 0x50, 0x4E, 0x09, 0xE0, 0x77, 0x77, 0x60, 0xBF,
  0xB0, 0xC7, 0x77, 0x60, 0x4E, 0x09, 0xE0, 0x77, 0x77, 0x60, 0x5F, 0xB0, 0x67, 0x77, 0x60, 0x4E,
  0x09, 0xE0, 0x77, 0x77, 0x70, 0xEF, 0x90, 0xE7, 0x77, 0x70, 0x4E, 0x09, 0xE0, 0x77, 0x77, 0x70,
  0x8F, 0x90, 0x97, 0x77, 0x70, 0x4E, 0x09, 0xE0, 0x77, 0x77, 0x70, 0x2F, 0x90, 0x37, 0x77, 0x70,
  0x4E, 0x09, 0xE0, 0x77, 0x77, 0x71, 0x0C, 0xE0, 0xC7, 0x77, 0x71, 0x04, 0xE0, 0x9E, 0x07, 0x77,
  0x77, 0x10, 0x5E, 0x06, 0x77, 0x77, 0x10, 0x4E, 0x09, 0xE0, 0x77, 0x77, 0x72, 0x0E, 0xD0, 0x17,
  0x77, 0x71, 0x04, 0xE0, 0x90,
  // "N" (U+004E)
  0x80, 0x3B, 0x07, 0x80, 0xD4, 0x00, 0x18, 0x02, 0xB0, 0x4F, 0x90, 0x38, 0x0D, 0x30, 0x01, 0xE0,
  0x5F, 0x90, 0xD8, 0x0D, 0x30, 0x01, 0xE0, 0x5F, 0xA0, 0x88, 0x0D, 0x20, 0x01, 0xE0, 0x5F, 0xB0,
  0x38, 0x0D, 0x10, 0x01, 0xE0, 0x5F, 0xB0, 0xD8, 0x0D, 0x10, 0x01, 0xE0, 0x5F, 0xC0, 0x88, 0x0D,
  0x00, 0x01, 0xE0, 0x5F, 0xD0, 0x38, 0x0C, 0x70, 0x01, 0xE0, 0x5F, 0xD0, 0xC8, 0x0C, 0x70, 0x01,
  0xE0, 0x5F, 0xE0, 0x88, 0x0C, 0x60, 0x01, 0xE0, 0x5F, 0xF0, 0x38, 0x0C, 0x50, 0x01, 0xE0, 0x5E,
  0x06, 0xF0, 0xC8, 0x0C, 0x50, 0x01, 0xE0, 0x5E, 0x10, 0xBF, 0x07, 0x80, 0xC4, 0x00, 0x1E, 0x05,
  0xE8, 0x11, 0x1E, 0xF0, 0x28, 0x0C, 0x30, 0x01, 0xE0, 0x5E, 0x81, 0x20, 0x6F, 0x0C, 0x80, 0xC3,
  0x00, 0x1E, 0x05, 0xE0, 0x22, 0x0B, 0xF0, 0x78, 0x0C, 0x20, 0x01, 0xE0, 0x5E, 0x03, 0x20, 0x20,
  0xEF, 0x02, 0x80, 0xC1, 0x00, 0x1E, 0x05, 0xE0, 0x33, 0x06, 0xF0, 0xC8, 0x0C, 0x10, 0x01, 0xE0,
  0x5E, 0x04, 0x40, 0xBF, 0x07, 0x80, 0xC0, 0x00, 0x1E, 0x05, 0xE0, 0x44, 0x02, 0x0E, 0xF0, 0x27,
  0x77, 0x77, 0x01, 0xE0, 0x5E, 0x05, 0x50, 0x6F, 0x0C, 0x77, 0x77, 0x70, 0x1E, 0x05, 0xE0, 0x56,
  0x0B, 0xF0, 0x77, 0x77, 0x76, 0x01, 0xE0, 0x5E, 0x05, 0x60, 0x20, 0xEF, 0x02, 0x77, 0x77, 0x50,
  0x1E, 0x05, 0xE0, 0x67, 0x06, 0xF0, 0xC7, 0x77, 0x75, 0x01, 0xE0, 0x5E, 0x06, 0x71, 0x0C, 0xF0,
  0x77, 0x77, 0x74, 0x01, 0xE0, 0x5E, 0x06, 0x71, 0x02, 0xF9, 0x02, 0x77, 0x77, 0x30, 0x1E, 0x05,
  0xE0, 0x77, 0x20, 0x7F, 0x0B, 0x77, 0x77, 0x30, 0x1E, 0x05, 0xE0, 0x77, 0x30, 0xCF, 0x06, 0x77,
  0x77, 0x20, 0x1E, 0x05, 0xE0, 0x77, 0x30, 0x2F, 0x0E, 0x02, 0x77, 0x77, 0x10, 0x1E, 0x05, 0xE0,
  0x77, 0x40, 0x7F, 0x0B, 0x77, 0x77, 0x10, 0x1E, 0x05, 0xE0, 0x77, 0x50, 0xCF, 0x06, 0x77, 0x77,
  0x01, 0xE0, 0x5E, 0x07, 0x75, 0x02, 0xF0, 0xE0, 0x27, 0x77, 0x60, 0x1E, 0x05, 0xE0, 0x77, 0x60,
  0x7F, 0x0B, 0x77, 0x76, 0x01, 0xE0, 0x5E, 0x07, 0x77, 0x0C, 0xF0, 0x67, 0x77, 0x50, 0x1E, 0x05,
  0xE0, 0x77, 0x70, 0x2F, 0x0E, 0x01, 0x77, 0x74, 0x01, 0xE0, 0x5E, 0x07, 0x77, 0x10, 0x7F, 0x0B,
  0x77, 0x74, 0x01, 0xE0, 0x5E, 0x07, 0x77, 0x20, 0xCF, 0x06, 0x77, 0x73, 0x01, 0xE0, 0x5E, 0x07,
  0x77, 0x20, 0x3F, 0x0E, 0x01, 0x77, 0x72, 0x01, 0xE0, 0x5E, 0x07, 0x77, 0x30, 0x8F, 0x0B, 0x77,
  0x72, 0x01, 0xE0, 0x5E, 0x07, 0x77, 0x40, 0xCF, 0x06, 0x77, 0x71, 0x01, 0xE0, 0x5E, 0x07, 0x77,
  0x40, 0x3F, 0x0E, 0x01, 0x77, 0x70, 0x1E, 0x05, 0xE0, 0x77, 0x75, 0x08, 0xF0, 0xB7, 0x77, 0x01,
  0xE0, 0x5E, 0x07, 0x77, 0x60, 0xDF, 0x05, 0x77, 0x60, 0x1E, 0x05, 0xE0, 0x77, 0x76, 0x03, 0xF0,
  0xE0, 0x17, 0x75, 0x01, 0xE0, 0x5E, 0x07, 0x77, 0x70, 0x8F, 0x0A, 0x77, 0x50, 0x1E, 0x05, 0xE0,
  0x77, 0x77, 0x10, 0xDF, 0x05, 0x77, 0x40, 0x1E, 0x05, 0xE0, 0x77, 0x77, 0x10, 0x3F, 0x0E, 0x01,
  0x77, 0x30, 0x1E, 0x05, 0xE0, 0x77, 0x77, 0x20, 0x8F, 0x0A, 0x77, 0x30, 0x1E, 0x05, 0xE0, 0x77,
  0x77, 0x30, 0xDF, 0x05, 0x77, 0x20, 0x1E, 0x05, 0xE0, 0x77, 0x77, 0x30, 0x3F, 0x0E, 0x01, 0x77,
  0x10, 0x1E, 0x05, 0xE0, 0x77, 0x77, 0x40, 0x8F, 0x0A, 0x77, 0x10, 0x1E, 0x05, 0xE0, 0x77, 0x77,
  0x50, 0xDF, 0x05, 0x77, 0x01, 0xE0, 0x5E, 0x07, 0x77, 0x75, 0x03, 0xF0, 0xE0, 0x17, 0x60, 0x1E,
  0x05, 0xE0, 0x77, 0x77, 0x60, 0x9F, 0x0A, 0x76, 0x01, 0xE0, 0x5E, 0x07, 0x77, 0x77, 0x0D, 0xF0,
  0x57, 0x50, 0x1E, 0x05, 0xE0, 0x77, 0x77, 0x70, 0x4F, 0x0E, 0x01, 0x74, 0x01, 0xE0, 0x5E, 0x07,
  0x77, 0x77, 0x10, 0x9F, 0x0A, 0x74, 0x01, 0xE0, 0x5E, 0x07, 0x77, 0x77, 0x20, 0xDF, 0x04, 0x73,
  0x01, 0xE0, 0x5E, 0x07, 0x77, 0x77, 0x20, 0x4F, 0x0E, 0x01, 0x72, 0x01, 0xE0, 0x5E, 0x07, 0x77,
  0x77, 0x30, 0x9F, 0x09, 0x72, 0x01, 0xE0, 0x5E, 0x07, 0x77, 0x77, 0x40, 0xDF, 0x04, 0x71, 0x01,
  0xE0, 0x5E, 0x07, 0x77, 0x77, 0x40, 0x4F, 0x0D, 0x01, 0x70, 0x1E, 0x05, 0xE0, 0x77, 0x77, 0x75,
  0x09, 0xF0, 0x97, 0x1E, 0x05, 0xE0, 0x77, 0x77, 0x75, 0x01, 0x0D, 0xF0, 0x47, 0xE0, 0x5E, 0x07,
  0x77, 0x77, 0x60, 0x4F, 0x0D, 0x7E, 0x05, 0xE0, 0x77, 0x77, 0x77, 0x0A, 0xF0, 0x96, 0xE0, 0x5E,
  0x07, 0x77, 0x77, 0x70, 0x10, 0xEF, 0x04, 0x5E, 0x05, 0xE0, 0x78, 0x0C, 0x00, 0x05, 0xF0, 0xD5,
  0x0E, 0xD0, 0x5E, 0x07, 0x80, 0xC1, 0x00, 0xAF, 0x09, 0x40, 0xED, 0x05, 0xE0, 0x78, 0x0C, 0x10,
  0x01, 0x0E, 0xF0, 0x43, 0x0D, 0xD0, 0x5E, 0x07, 0x80, 0xC2, 0x00, 0x5F, 0x0D, 0x30, 0xDD, 0x05,
  0xE0, 0x78, 0x0C, 0x30, 0x0A, 0xF0, 0x92, 0x0C, 0xD0, 0x5E, 0x07, 0x80, 0xC3, 0x00, 0x10, 0xEF,
  0x81, 0x30, 0xBD, 0x05, 0xE0, 0x78, 0x0C, 0x40, 0x05, 0xF8, 0x1D, 0x0B, 0xD0, 0x5E, 0x07, 0x80,
  0xC5, 0x00, 0xAF, 0x08, 0x0A, 0xD0, 0x5E, 0x07, 0x80, 0xC5, 0x00, 0x10, 0xEF, 0xE0, 0x5E, 0x07,
  0x80, 0xC6, 0x00, 0x5F, 0xE0, 0x5E, 0x07, 0x80, 0xC7, 0x00, 0xAF, 0xD0, 0x5E, 0x07, 0x80, 0xC7,
  0x00, 0x10, 0xEF, 0xC0, 0x5E, 0x07, 0x80, 0xD0, 0x00, 0x5F, 0xC0, 0x5E, 0x07, 0x80, 0xD1, 0x00,
  0xBF, 0xB0, 0x5E, 0x07, 0x80, 0xD1, 0x00, 0x10, 0xEF, 0xA0, 0x5E, 0x07, 0x80, 0xD2, 0x00, 0x6F,
  0xA0, 0x5E, 0x07, 0x80, 0xD3, 0x00, 0xBF, 0x90, 0x5E, 0x07, 0x80, 0xD3, 0x00, 0x10, 0xEF, 0x05,
  0xE0, 0x78, 0x0D, 0x40, 0x06, 0xF0, 0x50,
  // "O" (U+004F)
  0x77, 0x77, 0x28, 0x53, 0x68, 0xAB, 0xDD, 0xC8, 0x6E, 0xDC, 0xB9, 0x75, 0x28, 0x0E, 0x30, 0x81,
  0x48, 0xCF, 0xFE, 0x82, 0xEB, 0x72, 0x80, 0xD4, 0x08, 0x13, 0x9E, 0xFF, 0xFE, 0x81, 0xD7, 0x18,
  0x0C, 0x70, 0x05, 0x0D, 0xFF, 0xFF, 0xD0, 0xA0, 0x28, 0x0C, 0x30, 0x05, 0x0D, 0x80, 0xC1, 0xF0,
  0xA0, 0x17, 0x77, 0x77, 0x02, 0x0B, 0x80, 0xC5, 0xF0, 0x77, 0x77, 0x75, 0x07, 0xFF, 0x98, 0x95,
  0xCA, 0x76, 0x53, 0x33, 0x34, 0x56, 0x8A, 0xCF, 0xF0, 0xC0, 0x27, 0x77, 0x71, 0x01, 0x0B, 0xFD,
  0x81, 0xB7, 0x37, 0x73, 0x81, 0x48, 0xDF, 0xC0, 0xE0, 0x47, 0x77, 0x60, 0x20, 0xDF, 0xB8, 0x1D,
  0x71, 0x77, 0x72, 0x81, 0x39, 0xEF, 0xB0, 0x67, 0x77, 0x40, 0x20, 0xEF, 0xA0, 0xD0, 0x57, 0x77,
  0x78, 0x11, 0x8E, 0xFA, 0x08, 0x77, 0x72, 0x03, 0x0E, 0xF9, 0x0E, 0x07, 0x77, 0x77, 0x40, 0x10,
  0xAF, 0xA0, 0x77, 0x77, 0x02, 0x0E, 0xF9, 0x0C, 0x02, 0x77, 0x77, 0x70, 0x50, 0xEF, 0x90, 0x67,
  0x75, 0x01, 0x0D, 0xF9, 0x09, 0x80, 0xC2, 0x00, 0x20, 0xDF, 0x90, 0x47, 0x74, 0x0B, 0xF9, 0x07,
  0x80, 0xC4, 0x00, 0x10, 0xDF, 0x0E, 0x01, 0x77, 0x20, 0x7F, 0x90, 0x68, 0x0C, 0x60, 0x01, 0x0D,
  0xF0, 0xB7, 0x71, 0x02, 0xF9, 0x07, 0x80, 0xD0, 0x00, 0x20, 0xEF, 0x06, 0x77, 0x0C, 0xF0, 0xA8,
  0x0D, 0x20, 0x04, 0xF0, 0xE0, 0x17, 0x50, 0x6F, 0x0D, 0x80, 0xD4, 0x00, 0x9F, 0x09, 0x75, 0x0E,
  0xF0, 0x38, 0x0D, 0x50, 0x0D, 0xF0, 0x27, 0x30, 0x7F, 0x08, 0x80, 0xD6, 0x00, 0x4F, 0x0A, 0x73,
  0x0E, 0xE0, 0xE8, 0x0E, 0x00, 0x0B, 0xF0, 0x27, 0x10, 0x6F, 0x06, 0x80, 0xE0, 0x00, 0x3F, 0x08,
  0x71, 0x0C, 0xE0, 0xE8, 0x0E, 0x20, 0x0B, 0xE0, 0xE7, 0x03, 0xF0, 0x78, 0x0E, 0x20, 0x05, 0xF0,
  0x56, 0x08, 0xF0, 0x18, 0x0E, 0x30, 0x0D, 0xE0, 0xA6, 0x0D, 0xE0, 0xB8, 0x0E, 0x40, 0x08, 0xF5,
  0x03, 0xF0, 0x58, 0x0E, 0x40, 0x03, 0xF0, 0x54, 0x07, 0xF0, 0x18, 0x0E, 0x50, 0x0D, 0xE0, 0x94,
  0x0B, 0xE0, 0xB8, 0x0E, 0x60, 0x09, 0xE0, 0xD4, 0xF0, 0x78, 0x0E, 0x60, 0x05, 0xF0, 0x12, 0x03,
  0xF0, 0x38, 0x0E, 0x60, 0x01, 0xF0, 0x42, 0x06, 0xF8, 0x0F, 0x00, 0x0D, 0xE0, 0x72, 0x09, 0xE0,
  0xC8, 0x0F, 0x00, 0x0A, 0xE0, 0xA2, 0x0B, 0xE0, 0x98, 0x0F, 0x00, 0x08, 0xE0, 0xC2, 0x0E, 0xE0,
  0x78, 0x0F, 0x00, 0x05, 0xF2, 0xF0, 0x48, 0x0F, 0x00, 0x03, 0xF0, 0x10, 0x2F, 0x02, 0x80, 0xF0,
  0x00, 0x1F, 0x03, 0x04, 0xF0, 0x18, 0x0F, 0x10, 0xF0, 0x40, 0x5F, 0x80, 0xF2, 0x00, 0xEE, 0x05,
  0x06, 0xE0, 0xE8, 0x0F, 0x20, 0x0D, 0xE0, 0x60, 0x7E, 0x0D, 0x80, 0xF2, 0x00, 0xCE, 0x00, 0x7E,
  0x0C, 0x80, 0xF2, 0x00, 0xCE, 0x00, 0x8E, 0x0C, 0x80, 0xF2, 0x00, 0xBE, 0x00, 0x8E, 0x0C, 0x80,
  0xF2, 0x00, 0xBE, 0x09, 0x08, 0xE0, 0xB8, 0x0F, 0x20, 0x0B, 0xE0, 0x90, 0x8E, 0x0C, 0x80, 0xF2,
  0x00, 0xBE, 0x08, 0x07, 0xE0, 0xC8, 0x0F, 0x20, 0x0B, 0xE0, 0x80, 0x7E, 0x0D, 0x80, 0xF2, 0x00,
  0xCE, 0x07, 0x06, 0xE0, 0xE8, 0x0F, 0x20, 0x0D, 0xE0, 0x60, 0x5F, 0x80, 0xF2, 0x00, 0xEE, 0x05,
  0x04, 0xF0, 0x18, 0x0F, 0x10, 0xF0, 0x40, 0x2F, 0x02, 0x80, 0xF0, 0x00, 0x1F, 0x03, 0x1F, 0x04,
  0x80, 0xF0, 0x00, 0x3F, 0x81, 0x10, 0xEE, 0x06, 0x80, 0xF0, 0x00, 0x5E, 0x0E, 0x20, 0xBE, 0x08,
  0x80, 0xF0, 0x00, 0x7E, 0x0C, 0x20, 0x9E, 0x0B, 0x80, 0xF0, 0x00, 0xAE, 0x0A, 0x20, 0x6E, 0x0E,
  0x80, 0xF0, 0x00, 0xDE, 0x07, 0x20, 0x3F, 0x02, 0x80, 0xE6, 0x00, 0x1F, 0x04, 0x3F, 0x06, 0x80,
  0xE6, 0x00, 0x4F, 0x40, 0xCE, 0x0A, 0x80, 0xE6, 0x00, 0x8E, 0x0C, 0x40, 0x8E, 0x0E, 0x80, 0xE6,
  0x00, 0xCE, 0x08, 0x40, 0x3F, 0x03, 0x80, 0xE4, 0x00, 0x1F, 0x04, 0x50, 0xEE, 0x09, 0x80, 0xE4,
  0x00, 0x7E, 0x0E, 0x60, 0x9E, 0x0E, 0x80, 0xE4, 0x00, 0xCE, 0x09, 0x60, 0x4F, 0x05, 0x80, 0xE2,
  0x00, 0x3F, 0x04, 0x70, 0xDE, 0x0B, 0x80, 0xE2, 0x00, 0x9E, 0x0D, 0x71, 0x08, 0xF0, 0x38, 0x0E,
  0x00, 0x01, 0xF0, 0x77, 0x10, 0x1F, 0x0B, 0x80, 0xE0, 0x00, 0x9F, 0x01, 0x72, 0x09, 0xF0, 0x48,
  0x0D, 0x60, 0x02, 0xF0, 0x97, 0x30, 0x2F, 0x0D, 0x80, 0xD6, 0x00, 0xBF, 0x02, 0x74, 0x09, 0xF0,
  0x88, 0x0D, 0x40, 0x06, 0xF0, 0x87, 0x50, 0x10, 0xEF, 0x04, 0x80, 0xD2, 0x00, 0x20, 0xEE, 0x0E,
  0x01, 0x76, 0x06, 0xF0, 0xE0, 0x28, 0x0D, 0x00, 0x01, 0x0D, 0xF0, 0x57, 0x71, 0x0B, 0xF0, 0xD0,
  0x18, 0x0C, 0x70, 0x0B, 0xF0, 0xB7, 0x72, 0x02, 0x0E, 0xF0, 0xD0, 0x18, 0x0C, 0x50, 0x0B, 0xF0,
  0xE0, 0x17, 0x73, 0x04, 0xF9, 0x0D, 0x02, 0x80, 0xC2, 0x00, 0x10, 0xCF, 0x90, 0x37, 0x75, 0x07,
  0xF9, 0x0E, 0x05, 0x80, 0xC0, 0x00, 0x30, 0xDF, 0x90, 0x67, 0x77, 0x08, 0xFA, 0x09, 0x01, 0x77,
  0x77, 0x50, 0x7F, 0xA0, 0x77, 0x77, 0x20, 0x9F, 0xA0, 0xE0, 0x67, 0x77, 0x72, 0x04, 0x0D, 0xFA,
  0x07, 0x77, 0x74, 0x08, 0xFB, 0x81, 0xD6, 0x17, 0x77, 0x40, 0x50, 0xCF, 0xB0, 0x77, 0x77, 0x60,
  0x5F, 0xD8, 0x1A, 0x51, 0x77, 0x58, 0x14, 0x9E, 0xFB, 0x0E, 0x04, 0x77, 0x77, 0x10, 0x30, 0xDF,
  0xE8, 0x4C, 0x96, 0x42, 0x16, 0x84, 0x12, 0x46, 0x8C, 0xFE, 0x0C, 0x02, 0x77, 0x77, 0x40, 0x9F,
  0xFE, 0x00, 0xEF, 0xFE, 0x08, 0x77, 0x77, 0x70, 0x30, 0xC8, 0x0C, 0x2F, 0x0B, 0x02, 0x80, 0xC2,
  0x00, 0x40, 0xCF, 0xFF, 0xFE, 0x0B, 0x03, 0x80, 0xC6, 0x08, 0x13, 0x9E, 0xFF, 0xFF, 0x81, 0xE9,
  0x38, 0x0D, 0x30, 0x81, 0x49, 0xDF, 0xFF, 0x98, 0x1D, 0x94, 0x80, 0xE1, 0x08, 0x41, 0x47, 0xAC,
  0xDF, 0xB8, 0x4D, 0xCA, 0x74, 0x18, 0x0F, 0x30, 0x0F, 0x10, 0x20, 0x30, 0xF1, 0x77, 0x77, 0x70,
  // "P" (U+0050)
  0x80, 0xA1, 0xB8, 0x7A, 0x99, 0x98, 0x75, 0x42, 0x77, 0x72, 0xFF, 0xFF, 0xB8, 0x2D, 0xA7, 0x37,
  0x74, 0xFF, 0xFF, 0xF8, 0x1E, 0xA5, 0x77, 0x18, 0x0C, 0x2F, 0x81, 0xE8, 0x17, 0x58, 0x0C, 0x5F,
  0x08, 0x01, 0x73, 0x80, 0xC6, 0xF0, 0xE0, 0x47, 0x2F, 0x80, 0x91, 0x58, 0x66, 0x77, 0x78, 0x9B,
  0xDF, 0xFA, 0x09, 0x71, 0xE0, 0xE7, 0x77, 0x18, 0x22, 0x58, 0xDF, 0xD0, 0xB7, 0xE0, 0xE7, 0x77,
  0x58, 0x11, 0x7D, 0xFB, 0x0B, 0x6E, 0x0E, 0x77, 0x77, 0x10, 0x50, 0xDF, 0xA0, 0x95, 0xE0, 0xE7,
  0x77, 0x73, 0x07, 0xFA, 0x05, 0x4E, 0x0E, 0x77, 0x77, 0x40, 0x40, 0xEF, 0x0E, 0x01, 0x3E, 0x0E,
  0x77, 0x77, 0x50, 0x30, 0xEF, 0x08, 0x3E, 0x0E, 0x77, 0x77, 0x60, 0x4F, 0x0E, 0x01, 0x2E, 0x0E,
  0x77, 0x77, 0x70, 0x9F, 0x07, 0x2E, 0x0E, 0x77, 0x77, 0x70, 0x10, 0xEE, 0x0C, 0x2E, 0x0E, 0x80,
  0xC0, 0x00, 0x8F, 0x02, 0x1E, 0x0E, 0x80, 0xC0, 0x00, 0x2F, 0x06, 0x1E, 0x0E, 0x80, 0xC1, 0x00,
  0xCE, 0x09, 0x1E, 0x0E, 0x80, 0xC1, 0x00, 0x9E, 0x0C, 0x1E, 0x0E, 0x80, 0xC1, 0x00, 0x5E, 0x0E,
  0x1E, 0x0E, 0x80, 0xC1, 0x00, 0x3F, 0x1E, 0x0E, 0x80, 0xC1, 0x00, 0x1F, 0x01, 0xE0, 0xE8, 0x0C,
  0x20, 0xF0, 0x2E, 0x0E, 0x80, 0xC2, 0x0F, 0x03, 0xE0, 0xE8, 0x0C, 0x20, 0xF0, 0x2E, 0x0E, 0x80,
  0xC1, 0x00, 0x1F, 0x01, 0xE0, 0xE8, 0x0C, 0x10, 0x01, 0xF0, 0x1E, 0x0E, 0x80, 0xC1, 0x00, 0x3E,
  0x0E, 0x1E, 0x0E, 0x80, 0xC1, 0x00, 0x5E, 0x0C, 0x1E, 0x0E, 0x80, 0xC1, 0x00, 0x8E, 0x0A, 0x1E,
  0x0E, 0x80, 0xC1, 0x00, 0xBE, 0x06, 0x1E, 0x0E, 0x80, 0xC1, 0x00, 0xEE, 0x03, 0x1E, 0x0E, 0x80,
  0xC0, 0x00, 0x5E, 0x0E, 0x2E, 0x0E, 0x80, 0xC0, 0x00, 0xBE, 0x09, 0x2E, 0x0E, 0x77, 0x77, 0x70,
  0x4F, 0x03, 0x2E, 0x0E, 0x77, 0x77, 0x70, 0xCE, 0x0B, 0x3E, 0x0E, 0x77, 0x77, 0x60, 0x8F, 0x04,
  0x3E, 0x0E, 0x77, 0x77, 0x50, 0x6F, 0x0B, 0x4E, 0x0E, 0x77, 0x77, 0x40, 0x7F, 0x0E, 0x02, 0x4E,
  0x0E, 0x77, 0x77, 0x20, 0x10, 0xBF, 0x90, 0x55, 0xE0, 0xE7, 0x77, 0x70, 0x10, 0x8F, 0xA0, 0x86,
  0xE0, 0xE7, 0x77, 0x50, 0x30, 0x9F, 0xB0, 0xA7, 0xE0, 0xE7, 0x77, 0x18, 0x21, 0x59, 0xDF, 0xC0,
  0xA7, 0x1E, 0x0E, 0x75, 0x0F, 0x18, 0x52, 0x34, 0x68, 0xAD, 0xFF, 0x07, 0x72, 0x80, 0xC5, 0xF0,
  0xD0, 0x47, 0x38, 0x0C, 0x4F, 0x07, 0x75, 0x80, 0xC1, 0xF8, 0x1E, 0x81, 0x76, 0xFF, 0xFF, 0xF0,
  0xB0, 0x57, 0x72, 0xFF, 0xFF, 0xB8, 0x2C, 0x85, 0x17, 0x74, 0xFF, 0xE8, 0x00, 0xD8, 0x4B, 0xA9,
  0x75, 0x27, 0x77, 0x2E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E,
  0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E,
  0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E,
  0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E,
  0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E,
  0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E,
  0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E,
  0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E,
  0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x00,
  // "Q" (U+0051)
  0x77, 0x77, 0x28, 0x53, 0x68, 0xAB, 0xDD, 0xC8, 0x6E, 0xDC, 0xB9, 0x75, 0x28, 0x0E, 0x30, 0x81,
  0x48, 0xCF, 0xFE, 0x82, 0xEB, 0x72, 0x80, 0xD4, 0x08, 0x13, 0x9E, 0xFF, 0xFE, 0x81, 0xD7, 0x18,
  0x0C, 0x70, 0x05, 0x0D, 0xFF, 0xFF, 0xD0, 0xA0, 0x28, 0x0C, 0x30, 0x05, 0x0D, 0x80, 0xC1, 0xF0,
  0xA0, 0x17, 0x77, 0x77, 0x02, 0x0B, 0x80, 0xC5, 0xF0, 0x77, 0x77, 0x75, 0x07, 0xFF, 0x98, 0x95,
  0xCA, 0x76, 0x53, 0x33, 0x34, 0x56, 0x8A, 0xCF, 0xF0, 0xC0, 0x27, 0x77, 0x71, 0x01, 0x0B, 0xFD,
  0x81, 0xB7, 0x37, 0x73, 0x81, 0x48, 0xDF, 0xC0, 0xE0, 0x47, 0x77, 0x60, 0x20, 0xDF, 0xB8, 0x1D,
  0x71, 0x77, 0x72, 0x81, 0x39, 0xEF, 0xB0, 0x67, 0x77, 0x40, 0x20, 0xEF, 0xA0, 0xD0, 0x57, 0x77,
  0x78, 0x11, 0x8E, 0xFA, 0x08, 0x77, 0x72, 0x03, 0x0E, 0xF9, 0x0E, 0x07, 0x77, 0x77, 0x40, 0x10,
  0xAF, 0xA0, 0x77, 0x77, 0x02, 0x0E, 0xF9, 0x0C, 0x02, 0x77, 0x77, 0x70, 0x50, 0xEF, 0x90, 0x67,
  0x75, 0x01, 0x0D, 0xF9, 0x09, 0x80, 0xC2, 0x00, 0x20, 0xDF, 0x90, 0x47, 0x74, 0x0B, 0xF9, 0x07,
  0x80, 0xC4, 0x00, 0x10, 0xDF, 0x0E, 0x01, 0x77, 0x20, 0x7F, 0x90, 0x68, 0x0C, 0x60, 0x01, 0x0D,
  0xF0, 0xB7, 0x71, 0x02, 0xF9, 0x07, 0x80, 0xD0, 0x00, 0x20, 0xEF, 0x06, 0x77, 0x0C, 0xF0, 0xA8,
  0x0D, 0x20, 0x04, 0xF0, 0xE0, 0x17, 0x50, 0x6F, 0x0D, 0x80, 0xD4, 0x00, 0x9F, 0x09, 0x75, 0x0E,
  0xF0, 0x38, 0x0D, 0x50, 0x0D, 0xF0, 0x27, 0x30, 0x7F, 0x08, 0x80, 0xD6, 0x00, 0x4F, 0x0A, 0x73,
  0x0E, 0xE0, 0xE8, 0x0E, 0x00, 0x0B, 0xF0, 0x27, 0x10, 0x6F, 0x06, 0x80, 0xE0, 0x00, 0x3F, 0x08,
  0x71, 0x0C, 0xE0, 0xE8, 0x0E, 0x20, 0x0B, 0xE0, 0xE7, 0x03, 0xF0, 0x78, 0x0E, 0x20, 0x05, 0xF0,
  0x56, 0x08, 0xF0, 0x18, 0x0E, 0x30, 0x0D, 0xE0, 0xA6, 0x0D, 0xE0, 0xB8, 0x0E, 0x40, 0x08, 0xF5,
  0x03, 0xF0, 0x58, 0x0E, 0x40, 0x03, 0xF0, 0x54, 0x07, 0xF0, 0x18, 0x0E, 0x50, 0x0D, 0xE0, 0x94,
  0x0B, 0xE0, 0xB8, 0x0E, 0x60, 0x09, 0xE0, 0xD4, 0xF0, 0x78, 0x0E, 0x60, 0x05, 0xF0, 0x12, 0x03,
  0xF0, 0x38, 0x0E, 0x60, 0x01, 0xF0, 0x42, 0x06, 0xF8, 0x0F, 0x00, 0x0D, 0xE0, 0x72, 0x09, 0xE0,
  0xC8, 0x0F, 0x00, 0x0A, 0xE0, 0xA2, 0x0B, 0xE0, 0x98, 0x0F, 0x00, 0x08, 0xE0, 0xC2, 0x0E, 0xE0,
  0x78, 0x0F, 0x00, 0x05, 0xF2, 0xF0, 0x48, 0x0F, 0x00, 0x03, 0xF0, 0x10, 0x2F, 0x02, 0x80, 0xF0,
  0x00, 0x1F, 0x03, 0x04, 0xF0, 0x18, 0x0F, 0x10, 0xF0, 0x40, 0x5F, 0x80, 0xF2, 0x00, 0xEE, 0x05,
  0x06, 0xE0, 0xE8, 0x0F, 0x20, 0x0D, 0xE0, 0x60, 0x7E, 0x0D, 0x80, 0xF2, 0x00, 0xCE, 0x00, 0x7E,
  0x0C, 0x80, 0xF2, 0x00, 0xCE, 0x00, 0x8E, 0x0C, 0x80, 0xF2, 0x00, 0xBE, 0x00, 0x8E, 0x0C, 0x80,
  0xF2, 0x00, 0xBE, 0x09, 0x08, 0xE0, 0xB8, 0x0F, 0x20, 0x0B, 0xE0, 0x90, 0x8E, 0x0C, 0x80, 0xF2,
  0x00, 0xBE, 0x08, 0x07, 0xE0, 0xC8, 0x0F, 0x20, 0x0B, 0xE0, 0x80, 0x7E, 0x0D, 0x80, 0xF2, 0x00,
  0xCE, 0x07, 0x06, 0xE0, 0xE8, 0x0F, 0x20, 0x0D, 0xE0, 0x70, 0x5F, 0x80, 0xF2, 0x00, 0xEE, 0x06,
  0x04, 0xF0, 0x18, 0x0F, 0x10, 0xF0, 0x40, 0x2F, 0x02, 0x80, 0xF0, 0x00, 0x1F, 0x03, 0x1F, 0x04,
  0x80, 0xF0, 0x00, 0x3F, 0x81, 0x10, 0xEE, 0x06, 0x80, 0xF0, 0x00, 0x5E, 0x0E, 0x20, 0xBE, 0x08,
  0x80, 0xF0, 0x00, 0x7E, 0x0C, 0x20, 0x9E, 0x0B, 0x80, 0xF0, 0x00, 0xAE, 0x09, 0x20, 0x6E, 0x0E,
  0x80, 0xF0, 0x00, 0xDE, 0x07, 0x20, 0x3F, 0x02, 0x80, 0xE6, 0x00, 0x1F, 0x04, 0x3F, 0x06, 0x80,
  0xE6, 0x00, 0x4F, 0x40, 0xCE, 0x0A, 0x80, 0xE6, 0x00, 0x8E, 0x0C, 0x40, 0x8E, 0x0E, 0x80, 0xE6,
  0x00, 0xCE, 0x08, 0x40, 0x3F, 0x03, 0x80, 0xE4, 0x00, 0x1F, 0x04, 0x50, 0xEE, 0x09, 0x80, 0xE4,
  0x00, 0x7E, 0x0E, 0x60, 0x9E, 0x0E, 0x80, 0xE4, 0x00, 0xCE, 0x09, 0x60, 0x4F, 0x05, 0x80, 0xE2,
  0x00, 0x3F, 0x04, 0x70, 0xDE, 0x0B, 0x80, 0xE2, 0x00, 0x9E, 0x0D, 0x71, 0x08, 0xF0, 0x38, 0x0E,
  0x00, 0x01, 0xF0, 0x77, 0x10, 0x1F, 0x0B, 0x80, 0xE0, 0x00, 0x9F, 0x01, 0x72, 0x09, 0xF0, 0x48,
  0x0D, 0x60, 0x02, 0xF0, 0x97, 0x30, 0x2F, 0x0D, 0x80, 0xD6, 0x00, 0xBF, 0x02, 0x74, 0x09, 0xF0,
  0x88, 0x0D, 0x40, 0x06, 0xF0, 0x97, 0x50, 0x10, 0xEF, 0x04, 0x80, 0xD2, 0x00, 0x20, 0xEE, 0x0E,
  0x01, 0x76, 0x06, 0xF0, 0xE0, 0x28, 0x0D, 0x00, 0x01, 0x0D, 0xF0, 0x67, 0x71, 0x0B, 0xF0, 0xD0,
  0x18, 0x0C, 0x70, 0x0B, 0xF0, 0xB7, 0x72, 0x02, 0x0E, 0xF0, 0xD0, 0x18, 0x0C, 0x50, 0x0B, 0xF0,
  0xE0, 0x17, 0x73, 0x04, 0xF9, 0x0D, 0x02, 0x80, 0xC2, 0x00, 0x10, 0xCF, 0x90, 0x47, 0x75, 0x07,
  0xF9, 0x0E, 0x05, 0x80, 0xC0, 0x00, 0x30, 0xDF, 0x90, 0x67, 0x77, 0x08, 0xFA, 0x09, 0x01, 0x77,
  0x77, 0x50, 0x7F, 0xA0, 0x87, 0x77, 0x20, 0x9F, 0xA0, 0xE0, 0x67, 0x77, 0x72, 0x04, 0x0D, 0xFA,
  0x08, 0x77, 0x74, 0x08, 0xFB, 0x81, 0xD6, 0x17, 0x77, 0x40, 0x50, 0xCF, 0xB0, 0x77, 0x77, 0x60,
  0x5F, 0xD8, 0x1A, 0x51, 0x77, 0x58, 0x14, 0x9E, 0xFB, 0x0E, 0x05, 0x77, 0x77, 0x10, 0x30, 0xDF,
  0xE8, 0x4C, 0x96, 0x42, 0x16, 0x84, 0x12, 0x46, 0x8C, 0xFE, 0x0D, 0x02, 0x77, 0x77, 0x40, 0x9F,
  0xFE, 0x00, 0xEF, 0xFE, 0x08, 0x77, 0x77, 0x70, 0x30, 0xC8, 0x0C, 0x2F, 0x0B, 0x02, 0x80, 0xC2,
  0x00, 0x40, 0xCF, 0xFF, 0xFE, 0x0A, 0x03, 0x80, 0xC6, 0x08, 0x13, 0x9E, 0xFF, 0xFF, 0x81, 0xD7,
  0x18, 0x0D, 0x30, 0x81, 0x49, 0xDF, 0xFF, 0x98, 0x1C, 0x72, 0x80, 0xE1, 0x08, 0x41, 0x47, 0xAC,
  0xDF, 0xFA, 0x0D, 0x01, 0x80, 0xF1, 0x00, 0xF1, 0x84, 0x22, 0x11, 0x0C, 0xF0, 0xD0, 0x18, 0x09,
  0x80, 0x00, 0x10, 0xDF, 0x0C, 0x80, 0x98, 0x10, 0x02, 0x0E, 0xF0, 0xB8, 0x09, 0x81, 0x00, 0x4F,
  0x90, 0xA8, 0x09, 0x81, 0x00, 0x6F, 0x90, 0x88, 0x09, 0x81, 0x00, 0x9F, 0x90, 0x78, 0x09, 0x81,
  0x00, 0xBF, 0x90, 0x58, 0x09, 0x81, 0x00, 0xCF, 0x90, 0x48, 0x09, 0x80, 0x00, 0x10, 0xEF, 0x0E,
  0x03, 0x80, 0x98, 0x00, 0x03, 0xF9, 0x0E, 0x02, 0x80, 0x98, 0x00, 0x05, 0xF9, 0x0D, 0x01, 0x80,
  0x98, 0x00, 0x07, 0xF9, 0x0C, 0x01, 0x80, 0x98, 0x00, 0x09, 0xF9, 0x0C, 0x80, 0x98, 0x10, 0x0B,
  0xF9, 0x0A, 0x80, 0x98, 0x00, 0x01, 0x0D, 0xF9, 0x09, 0x80, 0x98, 0x00, 0x02, 0x0E, 0xF9, 0x08,
  0x80, 0x98, 0x00, 0x03, 0xFA, 0x06, 0x80, 0x98, 0x00, 0x05, 0xFA, 0x05, 0x80, 0x98, 0x00, 0x08,
  0xFA, 0x04, 0x80, 0x98, 0x00, 0x80, 0x65, 0x72,
  // "R" (U+0052)
  0x80, 0xA1, 0xB8, 0x90, 0xA9, 0x99, 0x97, 0x65, 0x31, 0x77, 0x76, 0xFF, 0xFF, 0xB8, 0x3E, 0xC9,
  0x62, 0x77, 0x71, 0x80, 0xC0, 0xF8, 0x1D, 0x93, 0x77, 0x58, 0x0C, 0x3F, 0x0D, 0x07, 0x77, 0x38,
  0x0C, 0x5F, 0x0E, 0x07, 0x77, 0x18, 0x0C, 0x7F, 0x0D, 0x03, 0x76, 0xF8, 0x09, 0x17, 0x86, 0x89,
  0x99, 0xAB, 0xCE, 0xFF, 0xB0, 0x67, 0x5E, 0x0E, 0x77, 0x71, 0x82, 0x25, 0x8B, 0xFE, 0x08, 0x74,
  0xE0, 0xE7, 0x77, 0x60, 0x50, 0xAF, 0xC0, 0x77, 0x3E, 0x0E, 0x77, 0x77, 0x10, 0x10, 0x8F, 0xB0,
  0x47, 0x2E, 0x0E, 0x77, 0x77, 0x30, 0x10, 0xBF, 0x90, 0xD0, 0x17, 0x1E, 0x0E, 0x77, 0x77, 0x50,
  0x8F, 0x90, 0x87, 0x1E, 0x0E, 0x77, 0x77, 0x60, 0x8F, 0x0E, 0x01, 0x7E, 0x0E, 0x77, 0x77, 0x70,
  0xBF, 0x07, 0x7E, 0x0E, 0x77, 0x77, 0x70, 0x2F, 0x0C, 0x7E, 0x0E, 0x80, 0xC0, 0x00, 0x9F, 0x02,
  0x6E, 0x0E, 0x80, 0xC0, 0x00, 0x3F, 0x05, 0x6E, 0x0E, 0x80, 0xC1, 0x00, 0xDE, 0x09, 0x6E, 0x0E,
  0x80, 0xC1, 0x00, 0x9E, 0x0C, 0x6E, 0x0E, 0x80, 0xC1, 0x00, 0x6E, 0x0E, 0x6E, 0x0E, 0x80, 0xC1,
  0x00, 0x3F, 0x6E, 0x0E, 0x80, 0xC1, 0x00, 0x1F, 0x01, 0x5E, 0x0E, 0x80, 0xC2, 0x0F, 0x02, 0x5E,
  0x0E, 0x80, 0xC2, 0x0F, 0x02, 0x5E, 0x0E, 0x80, 0xC2, 0x0F, 0x02, 0x5E, 0x0E, 0x80, 0xC2, 0x0F,
  0x02, 0x5E, 0x0E, 0x80, 0xC1, 0x00, 0x1F, 0x01, 0x5E, 0x0E, 0x80, 0xC1, 0x00, 0x3F, 0x6E, 0x0E,
  0x80, 0xC1, 0x00, 0x6E, 0x0D, 0x6E, 0x0E, 0x80, 0xC1, 0x00, 0x9E, 0x0A, 0x6E, 0x0E, 0x80, 0xC1,
  0x00, 0xDE, 0x07, 0x6E, 0x0E, 0x80, 0xC0, 0x00, 0x3F, 0x03, 0x6E, 0x0E, 0x80, 0xC0, 0x00, 0x9E,
  0x0E, 0x7E, 0x0E, 0x77, 0x77, 0x70, 0x1F, 0x08, 0x7E, 0x0E, 0x77, 0x77, 0x70, 0x9F, 0x02, 0x7E,
  0x0E, 0x77, 0x77, 0x60, 0x4F, 0x09, 0x71, 0xE0, 0xE7, 0x77, 0x75, 0x02, 0x0E, 0xE0, 0xE0, 0x17,
  0x1E, 0x0E, 0x77, 0x77, 0x40, 0x20, 0xDF, 0x05, 0x72, 0xE0, 0xE7, 0x77, 0x73, 0x04, 0x0E, 0xF0,
  0x97, 0x3E, 0x0E, 0x77, 0x77, 0x20, 0x8F, 0x90, 0xA7, 0x4E, 0x0E, 0x77, 0x77, 0x06, 0x0D, 0xF9,
  0x09, 0x75, 0xE0, 0xE7, 0x77, 0x48, 0x13, 0x8E, 0xFA, 0x07, 0x76, 0xE0, 0xE7, 0x75, 0x84, 0x13,
  0x57, 0xAE, 0xFB, 0x0E, 0x04, 0x77, 0x80, 0xC5, 0xF0, 0xA0, 0x17, 0x71, 0x80, 0xC3, 0xF0, 0xC0,
  0x47, 0x73, 0x80, 0xC1, 0xF0, 0xC0, 0x57, 0x75, 0xFF, 0xFF, 0xE8, 0x1E, 0x93, 0x77, 0x7F, 0xFF,
  0xFE, 0x03, 0x77, 0x72, 0xFF, 0xFF, 0xE0, 0xC7, 0x77, 0x2E, 0x0E, 0x77, 0x60, 0x5F, 0x06, 0x77,
  0x71, 0xE0, 0xE7, 0x77, 0x0C, 0xE0, 0xE0, 0x17, 0x77, 0xE0, 0xE7, 0x77, 0x03, 0xF0, 0x97, 0x77,
  0xE0, 0xE7, 0x77, 0x10, 0x9F, 0x03, 0x77, 0x6E, 0x0E, 0x77, 0x71, 0x01, 0x0E, 0xE0, 0xC7, 0x76,
  0xE0, 0xE7, 0x77, 0x20, 0x6F, 0x06, 0x77, 0x5E, 0x0E, 0x77, 0x73, 0x0C, 0xE0, 0xE0, 0x17, 0x74,
  0xE0, 0xE7, 0x77, 0x30, 0x3F, 0x09, 0x77, 0x4E, 0x0E, 0x77, 0x74, 0x09, 0xF0, 0x37, 0x73, 0xE0,
  0xE7, 0x77, 0x40, 0x10, 0xEE, 0x0C, 0x77, 0x3E, 0x0E, 0x77, 0x75, 0x07, 0xF0, 0x67, 0x72, 0xE0,
  0xE7, 0x77, 0x60, 0xDE, 0x0E, 0x01, 0x77, 0x1E, 0x0E, 0x77, 0x76, 0x04, 0xF0, 0xA7, 0x71, 0xE0,
  0xE7, 0x77, 0x70, 0xAF, 0x04, 0x77, 0xE0, 0xE7, 0x77, 0x70, 0x20, 0xEE, 0x0D, 0x77, 0xE0, 0xE7,
  0x77, 0x71, 0x07, 0xF0, 0x77, 0x6E, 0x0E, 0x77, 0x77, 0x20, 0xDE, 0x0E, 0x01, 0x75, 0xE0, 0xE7,
  0x77, 0x72, 0x05, 0xF0, 0xA7, 0x5E, 0x0E, 0x77, 0x77, 0x30, 0xBF, 0x04, 0x74, 0xE0, 0xE7, 0x77,
  0x73, 0x02, 0xF0, 0xD7, 0x4E, 0x0E, 0x77, 0x77, 0x40, 0x8F, 0x07, 0x73, 0xE0, 0xE7, 0x77, 0x75,
  0x0D, 0xE0, 0xE0, 0x27, 0x2E, 0x0E, 0x77, 0x77, 0x50, 0x5F, 0x0A, 0x72, 0xE0, 0xE7, 0x77, 0x76,
  0x0B, 0xF0, 0x47, 0x1E, 0x0E, 0x77, 0x77, 0x60, 0x3F, 0x0D, 0x71, 0xE0, 0xE7, 0x77, 0x77, 0x09,
  0xF0, 0x87, 0xE0, 0xE7, 0x77, 0x77, 0x01, 0x0E, 0xF0, 0x26, 0xE0, 0xE8, 0x0C, 0x00, 0x06, 0xF0,
  0xB6, 0xE0, 0xE8, 0x0C, 0x10, 0x0C, 0xF0, 0x55, 0xE0, 0xE8, 0x0C, 0x10, 0x03, 0xF0, 0xD5, 0xE0,
  0xE8, 0x0C, 0x20, 0x09, 0xF0, 0x84, 0xE0, 0xE8, 0x0C, 0x20, 0x01, 0x0E, 0xF0, 0x23, 0xE0, 0xE8,
  0x0C, 0x30, 0x07, 0xF0, 0xB3, 0xE0, 0xE8, 0x0C, 0x40, 0x0D, 0xF0, 0x52, 0xE0, 0xE8, 0x0C, 0x40,
  0x04, 0xF0, 0xE2, 0xE0, 0xE8, 0x0C, 0x50, 0x0A, 0xF0, 0x81, 0xE0, 0xE8, 0x0C, 0x50, 0x01, 0x0E,
  0xF0, 0x30,
  // "S" (U+0053)
  0x77, 0x68, 0xA1, 0x14, 0x68, 0xAB, 0xCD, 0xDD, 0xDC, 0xBA, 0x97, 0x53, 0x17, 0x77, 0x74, 0x81,
  0x59, 0xDF, 0xFD, 0x82, 0xDA, 0x73, 0x77, 0x74, 0x04, 0x0A, 0xFF, 0xFE, 0x82, 0xEB, 0x61, 0x77,
  0x50, 0x50, 0xCF, 0xFF, 0xFD, 0x81, 0xC6, 0x17, 0x70, 0x30, 0xC8, 0x0C, 0x2F, 0x0A, 0x01, 0x74,
  0x07, 0x80, 0xC4, 0xF0, 0xE0, 0x17, 0x30, 0xBF, 0xE8, 0x94, 0xDB, 0x97, 0x65, 0x55, 0x57, 0x89,
  0xBD, 0xFF, 0x09, 0x72, 0x01, 0x0C, 0xFB, 0x82, 0xE9, 0x51, 0x77, 0x18, 0x23, 0x59, 0xDF, 0xA0,
  0x37, 0x20, 0xCF, 0xA0, 0xD0, 0x67, 0x77, 0x28, 0x21, 0x5A, 0xEC, 0x0C, 0x72, 0x0A, 0xF9, 0x0E,
  0x06, 0x77, 0x77, 0x10, 0x50, 0xAA, 0x06, 0x71, 0x05, 0xF9, 0x0B, 0x01, 0x77, 0x77, 0x48, 0x11,
  0x71, 0x70, 0x10, 0xEF, 0x09, 0x80, 0xD0, 0x00, 0x8F, 0x09, 0x80, 0xD1, 0x00, 0xEE, 0x0C, 0x80,
  0xD1, 0x00, 0x6F, 0x03, 0x80, 0xD1, 0x00, 0xBE, 0x0B, 0x80, 0xD2, 0x00, 0xEE, 0x05, 0x80, 0xD1,
  0x00, 0x2F, 0x80, 0xD2, 0x00, 0x5E, 0x0C, 0x80, 0xD2, 0x00, 0x6E, 0x0A, 0x80, 0xD2, 0x00, 0x8E,
  0x08, 0x80, 0xD2, 0x00, 0x8E, 0x08, 0x80, 0xD2, 0x00, 0x8E, 0x08, 0x80, 0xD2, 0x00, 0x7E, 0x09,
  0x80, 0xD2, 0x00, 0x6E, 0x0A, 0x80, 0xD2, 0x00, 0x5E, 0x0D, 0x80, 0xD2, 0x00, 0x3F, 0x01, 0x80,
  0xD2, 0x0F, 0x05, 0x80, 0xD2, 0x00, 0xBE, 0x0B, 0x80, 0xD2, 0x00, 0x7F, 0x03, 0x80, 0xD1, 0x00,
  0x1F, 0x0D, 0x80, 0xD2, 0x00, 0xAF, 0x0A, 0x80, 0xD1, 0x00, 0x3F, 0x90, 0x98, 0x0D, 0x10, 0x09,
  0xF9, 0x0B, 0x01, 0x80, 0xD0, 0x00, 0xDF, 0x90, 0xD0, 0x38, 0x0C, 0x70, 0x02, 0x0E, 0xFA, 0x09,
  0x01, 0x80, 0xC6, 0x00, 0x30, 0xEF, 0xB0, 0x80, 0x18, 0x0C, 0x50, 0x03, 0x0E, 0xFC, 0x0A, 0x03,
  0x80, 0xC4, 0x00, 0x20, 0xDF, 0xD0, 0xC0, 0x58, 0x0C, 0x40, 0x09, 0xFE, 0x81, 0xE9, 0x38, 0x0C,
  0x20, 0x03, 0x0C, 0xFF, 0x81, 0xD7, 0x28, 0x0C, 0x10, 0x05, 0x0D, 0xFF, 0x98, 0x1C, 0x61, 0x80,
  0xC0, 0x00, 0x50, 0xDF, 0xFA, 0x0A, 0x03, 0x80, 0xC0, 0x00, 0x40, 0xBF, 0xFA, 0x0C, 0x06, 0x80,
  0xC0, 0x08, 0x12, 0x9E, 0xFF, 0x98, 0x1E, 0x71, 0x80, 0xC0, 0x00, 0x50, 0xBF, 0xF9, 0x81, 0xE8,
  0x18, 0x0C, 0x00, 0x81, 0x16, 0xCF, 0xF0, 0xE0, 0x78, 0x0C, 0x20, 0x81, 0x17, 0xDF, 0xE0, 0xD0,
  0x38, 0x0C, 0x30, 0x03, 0x09, 0xFE, 0x07, 0x80, 0xC4, 0x08, 0x11, 0x7D, 0xFC, 0x0B, 0x01, 0x80,
  0xC5, 0x00, 0x60, 0xDF, 0xB0, 0xC0, 0x18, 0x0C, 0x60, 0x06, 0x0E, 0xFA, 0x0C, 0x80, 0xD0, 0x00,
  0x8F, 0xA0, 0xA8, 0x0D, 0x00, 0x04, 0x0E, 0xF9, 0x07, 0x80, 0xD0, 0x00, 0x20, 0xDF, 0x90, 0x28,
  0x0D, 0x00, 0x01, 0x0D, 0xF0, 0xA8, 0x0D, 0x10, 0x03, 0xF9, 0x01, 0x80, 0xD1, 0x00, 0x7F, 0x07,
  0x80, 0xD2, 0x00, 0xDE, 0x0B, 0x80, 0xD2, 0x00, 0x7F, 0x80, 0xD2, 0x00, 0x2F, 0x02, 0x80, 0xD2,
  0x00, 0xEE, 0x05, 0x80, 0xD2, 0x00, 0xBE, 0x06, 0x80, 0xD2, 0x00, 0x9E, 0x07, 0x80, 0xD2, 0x00,
  0x9E, 0x07, 0x80, 0xD2, 0x00, 0x8E, 0x07, 0x80, 0xD2, 0x00, 0x9E, 0x07, 0x80, 0xD2, 0x00, 0xAE,
  0x05, 0x80, 0xD2, 0x00, 0xDE, 0x03, 0x80, 0xD1, 0x00, 0x1F, 0x01, 0x80, 0xD1, 0x00, 0x5E, 0x0D,
  0x80, 0xD2, 0x00, 0xAE, 0x09, 0x80, 0xD1, 0x00, 0x2F, 0x04, 0x80, 0xD1, 0x00, 0xAE, 0x0E, 0x80,
  0xD1, 0x00, 0x5F, 0x07, 0x80, 0xD0, 0x00, 0x20, 0xEE, 0x0E, 0x80, 0xD0, 0x00, 0x30, 0xEF, 0x06,
  0x30, 0x30, 0x18, 0x0C, 0x20, 0x05, 0x0E, 0xF0, 0xB4, 0x83, 0x7F, 0xB6, 0x17, 0x77, 0x75, 0x02,
  0x0A, 0xF9, 0x0D, 0x01, 0x40, 0x7C, 0x81, 0xB7, 0x37, 0x77, 0x70, 0x20, 0x9F, 0xA0, 0xE0, 0x25,
  0x07, 0xF8, 0x2E, 0xA6, 0x37, 0x77, 0x81, 0x16, 0xBF, 0xB0, 0xD0, 0x26, 0x07, 0xFD, 0x85, 0xCA,
  0x86, 0x32, 0x17, 0x84, 0x12, 0x46, 0x9C, 0xFD, 0x0C, 0x01, 0x70, 0x7F, 0xFF, 0x90, 0xE0, 0xDF,
  0xFD, 0x09, 0x72, 0x07, 0x80, 0xC5, 0xF0, 0xD0, 0x47, 0x30, 0x30, 0xB8, 0x0C, 0x2F, 0x0D, 0x06,
  0x77, 0x81, 0x16, 0xBF, 0xFF, 0xFD, 0x0B, 0x05, 0x77, 0x68, 0x24, 0x8B, 0xEF, 0xFF, 0xB8, 0x2E,
  0xB6, 0x17, 0x77, 0x58, 0x52, 0x47, 0x9B, 0xCE, 0xFD, 0x83, 0xDB, 0x96, 0x38, 0x0C, 0x30, 0x0F,
  0x18, 0x12, 0x33, 0x0F, 0x17, 0x77, 0x50,
  // "T" (U+0054)
  0x03, 0x80, 0xF1, 0xB0, 0xA0, 0x48, 0x0F, 0x1F, 0x0D, 0x04, 0x80, 0xF1, 0xF0, 0xD0, 0x48, 0x0F,
  0x1F, 0x0D, 0x04, 0x80, 0xF1, 0xF0, 0xD0, 0x48, 0x0F, 0x1F, 0x0D, 0x02, 0x80, 0xA7, 0x70, 0xDE,
  0x09, 0x80, 0xA6, 0x70, 0x67, 0x77, 0x70, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3,
  0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00,
  0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE,
  0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04,
  0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80,
  0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3,
  0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00,
  0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE,
  0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04,
  0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80,
  0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3,
  0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00,
  0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE,
  0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04,
  0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80,
  0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3,
  0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00,
  0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE,
  0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04,
  0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80,
  0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3,
  0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00,
  0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE,
  0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04,
  0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x80, 0xE3, 0x00, 0xAE, 0x04, 0x77,
  0x76,
  // "U" (U+0055)
  0x80, 0x3B, 0x80, 0xD6, 0x00, 0x48, 0x02, 0xB0, 0x50, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E,
  0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60,
  0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70,
  0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6,
  0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07,
  0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D,
  0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0,
  0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80,
  0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E,
  0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8,
  0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05,
  0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE,
  0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00,
  0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E,
  0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60,
  0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70,
  0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6,
  0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07,
  0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D,
  0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0,
  0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80,
  0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E,
  0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8,
  0x0D, 0x60, 0x05, 0xE0, 0x70, 0xDE, 0x01, 0x80, 0xD5, 0x00, 0x6E, 0x06, 0x0D, 0xE0, 0x18, 0x0D,
  0x50, 0x06, 0xE0, 0x50, 0xCE, 0x03, 0x80, 0xD5, 0x00, 0x7E, 0x05, 0x0A, 0xE0, 0x48, 0x0D, 0x50,
  0x09, 0xE0, 0x30, 0x8E, 0x06, 0x80, 0xD5, 0x00, 0xBE, 0x01, 0x06, 0xE0, 0x98, 0x0D, 0x50, 0x0E,
  0xD8, 0x1E, 0x03, 0xE0, 0xC8, 0x0D, 0x40, 0x01, 0xE0, 0xC2, 0xF8, 0x0D, 0x40, 0x05, 0xE0, 0x82,
  0x0D, 0xE0, 0x58, 0x0D, 0x30, 0x09, 0xE0, 0x52, 0x08, 0xE0, 0x98, 0x0D, 0x30, 0x0E, 0xE0, 0x12,
  0x04, 0xE0, 0xE8, 0x0D, 0x20, 0x05, 0xE0, 0xB4, 0x0E, 0xE0, 0x68, 0x0D, 0x10, 0x0B, 0xE0, 0x74,
  0x09, 0xE0, 0xD8, 0x0D, 0x00, 0x03, 0xF0, 0x14, 0x02, 0xF0, 0x68, 0x0C, 0x70, 0x0C, 0xE0, 0x96,
  0x0B, 0xE0, 0xE0, 0x18, 0x0C, 0x50, 0x06, 0xF0, 0x36, 0x03, 0xF0, 0xB8, 0x0C, 0x40, 0x02, 0xF0,
  0xA7, 0x10, 0xAF, 0x08, 0x80, 0xC2, 0x00, 0x10, 0xDF, 0x01, 0x71, 0x02, 0x0E, 0xF0, 0x78, 0x0C,
  0x00, 0x01, 0x0C, 0xF0, 0x77, 0x30, 0x6F, 0x90, 0x87, 0x77, 0x76, 0x02, 0x0D, 0xF0, 0xB7, 0x50,
  0xAF, 0x90, 0xA0, 0x17, 0x77, 0x73, 0x04, 0x0E, 0xF0, 0xE0, 0x17, 0x60, 0xCF, 0x90, 0xE0, 0x57,
  0x77, 0x70, 0x10, 0x9F, 0x90, 0xE0, 0x37, 0x70, 0x10, 0xDF, 0xA0, 0xC0, 0x57, 0x77, 0x38, 0x11,
  0x8E, 0xFA, 0x04, 0x77, 0x20, 0x10, 0xCF, 0xB8, 0x1E, 0x83, 0x77, 0x48, 0x11, 0x5A, 0xFB, 0x0E,
  0x03, 0x77, 0x50, 0xBF, 0xD8, 0x4E, 0xB8, 0x53, 0x17, 0x83, 0x23, 0x69, 0xCF, 0xD0, 0xD0, 0x27,
  0x77, 0x07, 0xFF, 0xE0, 0xDF, 0xFD, 0x09, 0x77, 0x73, 0x03, 0x0C, 0x80, 0xC0, 0xF0, 0xD0, 0x47,
  0x77, 0x60, 0x50, 0xDF, 0xFF, 0xFC, 0x0E, 0x06, 0x77, 0x77, 0x30, 0x50, 0xBF, 0xFF, 0xF0, 0xC0,
  0x57, 0x77, 0x77, 0x81, 0x26, 0xBF, 0xFF, 0x98, 0x1B, 0x72, 0x80, 0xC5, 0x08, 0x33, 0x69, 0xBD,
  0xFB, 0x83, 0xDB, 0x96, 0x38, 0x0D, 0x70, 0x0F, 0x10, 0x02, 0x0F, 0x17, 0x77, 0x71,
  // "V" (U+0056)
  0x0A, 0x80, 0x2B, 0x04, 0x80, 0xE2, 0x00, 0x88, 0x02, 0xB0, 0x08, 0xE0, 0xB8, 0x0E, 0x20, 0xF0,
  0x60, 0x3F, 0x01, 0x80, 0xE0, 0x00, 0x6F, 0x81, 0x10, 0xCE, 0x07, 0x80, 0xE0, 0x00, 0xBE, 0x0A,
  0x20, 0x7E, 0x0D, 0x80, 0xD7, 0x00, 0x2F, 0x04, 0x20, 0x1F, 0x03, 0x80, 0xD6, 0x00, 0x7E, 0x0E,
  0x40, 0xBE, 0x09, 0x80, 0xD6, 0x00, 0xDE, 0x08, 0x40, 0x5E, 0x0E, 0x80, 0xD5, 0x00, 0x3F, 0x03,
  0x50, 0xEE, 0x04, 0x80, 0xD4, 0x00, 0x9E, 0x0D, 0x60, 0x9E, 0x0A, 0x80, 0xD4, 0x00, 0xEE, 0x07,
  0x60, 0x4F, 0x01, 0x80, 0xD2, 0x00, 0x4F, 0x01, 0x70, 0xDE, 0x06, 0x80, 0xD2, 0x00, 0xAE, 0x0B,
  0x71, 0x08, 0xE0, 0xC8, 0x0D, 0x10, 0x01, 0xF0, 0x57, 0x10, 0x2F, 0x02, 0x80, 0xD0, 0x00, 0x6E,
  0x0E, 0x73, 0x0C, 0xE0, 0x88, 0x0D, 0x00, 0x0C, 0xE0, 0x97, 0x30, 0x6E, 0x0D, 0x80, 0xC7, 0x00,
  0x2F, 0x04, 0x73, 0x01, 0xF0, 0x38, 0x0C, 0x60, 0x07, 0xE0, 0xD7, 0x50, 0xAE, 0x09, 0x80, 0xC6,
  0x00, 0xDE, 0x08, 0x75, 0x05, 0xE0, 0xE8, 0x0C, 0x50, 0x03, 0xF0, 0x27, 0x60, 0xEE, 0x05, 0x80,
  0xC4, 0x00, 0x9E, 0x0C, 0x77, 0x09, 0xE0, 0xB8, 0x0C, 0x40, 0x0E, 0xE0, 0x67, 0x70, 0x3F, 0x01,
  0x80, 0xC2, 0x00, 0x5F, 0x01, 0x77, 0x10, 0xDE, 0x07, 0x80, 0xC2, 0x00, 0xBE, 0x0A, 0x77, 0x20,
  0x7E, 0x0C, 0x80, 0xC1, 0x00, 0x1F, 0x05, 0x77, 0x20, 0x2F, 0x02, 0x80, 0xC0, 0x00, 0x6E, 0x0E,
  0x77, 0x40, 0xBE, 0x08, 0x80, 0xC0, 0x00, 0xCE, 0x09, 0x77, 0x40, 0x6E, 0x0E, 0x77, 0x77, 0x70,
  0x2F, 0x03, 0x77, 0x50, 0xEE, 0x04, 0x77, 0x77, 0x60, 0x8E, 0x0D, 0x77, 0x60, 0xAE, 0x0A, 0x77,
  0x77, 0x60, 0xDE, 0x07, 0x77, 0x60, 0x4E, 0x0E, 0x77, 0x77, 0x50, 0x4F, 0x02, 0x77, 0x70, 0xEE,
  0x06, 0x77, 0x77, 0x40, 0x9E, 0x0B, 0x77, 0x71, 0x08, 0xE0, 0xB7, 0x77, 0x74, 0x0E, 0xE0, 0x67,
  0x77, 0x10, 0x2F, 0x02, 0x77, 0x77, 0x20, 0x5F, 0x01, 0x77, 0x72, 0x0C, 0xE0, 0x77, 0x77, 0x72,
  0x0B, 0xE0, 0xA7, 0x77, 0x30, 0x7E, 0x0D, 0x77, 0x77, 0x10, 0x1F, 0x04, 0x77, 0x73, 0x01, 0xF0,
  0x37, 0x77, 0x70, 0x7E, 0x0E, 0x77, 0x75, 0x0B, 0xE0, 0x97, 0x77, 0x70, 0xCE, 0x08, 0x77, 0x75,
  0x05, 0xE0, 0xE7, 0x77, 0x60, 0x3F, 0x03, 0x77, 0x76, 0x0E, 0xE0, 0x57, 0x77, 0x50, 0x8E, 0x0C,
  0x77, 0x77, 0x09, 0xE0, 0xA7, 0x77, 0x50, 0xEE, 0x07, 0x77, 0x77, 0x03, 0xF0, 0x17, 0x77, 0x30,
  0x4F, 0x01, 0x77, 0x77, 0x10, 0xDE, 0x06, 0x77, 0x73, 0x0A, 0xE0, 0xB7, 0x77, 0x72, 0x08, 0xE0,
  0xC7, 0x77, 0x30, 0xEE, 0x05, 0x77, 0x77, 0x20, 0x2F, 0x02, 0x77, 0x71, 0x06, 0xE0, 0xE7, 0x77,
  0x74, 0x0C, 0xE0, 0x87, 0x77, 0x10, 0xBE, 0x09, 0x77, 0x77, 0x40, 0x6E, 0x0D, 0x77, 0x70, 0x1F,
  0x04, 0x77, 0x77, 0x40, 0x1F, 0x04, 0x77, 0x60, 0x7E, 0x0D, 0x77, 0x77, 0x60, 0xAE, 0x09, 0x77,
  0x60, 0xDE, 0x08, 0x77, 0x77, 0x60, 0x4E, 0x0E, 0x77, 0x50, 0x3F, 0x02, 0x77, 0x77, 0x70, 0xEE,
  0x05, 0x77, 0x40, 0x9E, 0x0C, 0x80, 0xC0, 0x00, 0x9E, 0x0B, 0x77, 0x40, 0xEE, 0x06, 0x80, 0xC0,
  0x00, 0x3F, 0x01, 0x77, 0x20, 0x4F, 0x01, 0x80, 0xC1, 0x00, 0xDE, 0x07, 0x77, 0x20, 0xAE, 0x0A,
  0x80, 0xC2, 0x00, 0x7E, 0x0C, 0x77, 0x10, 0x1F, 0x05, 0x80, 0xC2, 0x00, 0x1F, 0x03, 0x77, 0x06,
  0xE0, 0xE8, 0x0C, 0x40, 0x0B, 0xE0, 0x87, 0x70, 0xCE, 0x09, 0x80, 0xC4, 0x00, 0x5E, 0x0E, 0x76,
  0x02, 0xF0, 0x38, 0x0C, 0x50, 0x0E, 0xE0, 0x47, 0x50, 0x7E, 0x0D, 0x80, 0xC6, 0x00, 0xAE, 0x0A,
  0x75, 0x0D, 0xE0, 0x78, 0x0C, 0x60, 0x04, 0xF0, 0x17, 0x30, 0x3F, 0x02, 0x80, 0xC7, 0x00, 0xDE,
  0x06, 0x73, 0x09, 0xE0, 0xB8, 0x0D, 0x00, 0x08, 0xE0, 0xB7, 0x30, 0xEE, 0x06, 0x80, 0xD0, 0x00,
  0x2F, 0x02, 0x71, 0x05, 0xF8, 0x0D, 0x20, 0x0C, 0xE0, 0x77, 0x10, 0xAE, 0x0A, 0x80, 0xD2, 0x00,
  0x7E, 0x0C, 0x70, 0x1F, 0x04, 0x80, 0xD2, 0x00, 0x1F, 0x02, 0x60, 0x5E, 0x0E, 0x80, 0xD4, 0x00,
  0xBE, 0x08, 0x60, 0xBE, 0x08, 0x80, 0xD4, 0x00, 0x5E, 0x0D, 0x50, 0x1F, 0x03, 0x80, 0xD5, 0x00,
  0xEE, 0x02, 0x40, 0x6E, 0x0C, 0x80, 0xD6, 0x00, 0x9E, 0x07, 0x40, 0xBE, 0x07, 0x80, 0xD6, 0x00,
  0x3E, 0x0D, 0x4F, 0x01, 0x80, 0xD7, 0x00, 0xDE, 0x02, 0x20, 0x5E, 0x0B, 0x80, 0xE0, 0x00, 0x7E,
  0x06, 0x20, 0x9E, 0x05, 0x80, 0xE0, 0x00, 0x2E, 0x0B, 0x20, 0xED, 0x0E, 0x80, 0xE2, 0x00, 0xCE,
  0x10, 0x3E, 0x09, 0x80, 0xE2, 0x00, 0x6E, 0x04, 0x07, 0xE0, 0x48, 0x0E, 0x20, 0x01, 0xE0, 0x80,
  0xBD, 0x0D, 0x80, 0xE4, 0x00, 0xAD, 0x0D, 0x0E, 0xD0, 0x88, 0x0E, 0x40, 0x04, 0xFD, 0x02, 0x80,
  0xE5, 0x00, 0xEF, 0xB0, 0xC8, 0x0E, 0x60, 0x09, 0xFB, 0x06, 0x80, 0xE6, 0x00, 0x3F, 0xB0, 0x18,
  0x0E, 0x70, 0x0D, 0xF9, 0x0A, 0x80, 0xF0, 0x00, 0x7F, 0x90, 0x58, 0x0F, 0x00, 0x01, 0xF0, 0xE8,
  0x0F, 0x20, 0x0B, 0xE0, 0x97, 0x77, 0x73,
  // "W" (U+0057)
  0x01, 0x80, 0x3B, 0x80, 0xC4, 0x00, 0xA8, 0x02, 0xB0, 0x28, 0x0C, 0x40, 0x0A, 0x80, 0x2B, 0x81,
  0x30, 0xEE, 0x04, 0x80, 0xC2, 0x00, 0x2F, 0x07, 0x80, 0xC3, 0x00, 0x2F, 0x20, 0xAE, 0x08, 0x80,
  0xC2, 0x00, 0x7F, 0x0B, 0x80, 0xC3, 0x00, 0x6E, 0x0B, 0x20, 0x5E, 0x0C, 0x80, 0xC2, 0x00, 0xBF,
  0x90, 0x18, 0x0C, 0x20, 0x0A, 0xE0, 0x72, 0x01, 0xF0, 0x18, 0x0C, 0x10, 0xFA, 0x05, 0x80, 0xC2,
  0x00, 0xEE, 0x03, 0x30, 0xDE, 0x04, 0x80, 0xC0, 0x00, 0x4F, 0xA0, 0x98, 0x0C, 0x10, 0x03, 0xE0,
  0xE4, 0x08, 0xE0, 0x98, 0x0C, 0x00, 0x09, 0xFA, 0x0E, 0x80, 0xC1, 0x00, 0x7E, 0x0A, 0x40, 0x4E,
  0x0D, 0x80, 0xC0, 0x00, 0xDF, 0xB0, 0x38, 0x0C, 0x00, 0x0C, 0xE0, 0x65, 0xF0, 0x17, 0x77, 0x76,
  0x02, 0xFC, 0x07, 0x80, 0xC0, 0x0F, 0x02, 0x50, 0xCE, 0x05, 0x77, 0x77, 0x60, 0x6D, 0x0C, 0xD0,
  0xC7, 0x77, 0x77, 0x04, 0xE0, 0xD6, 0x07, 0xE0, 0x97, 0x77, 0x76, 0x0B, 0xD0, 0x5E, 0x01, 0x77,
  0x77, 0x60, 0x9E, 0x09, 0x60, 0x3E, 0x0D, 0x77, 0x77, 0x6E, 0x01, 0x0D, 0xD0, 0x57, 0x77, 0x76,
  0x0D, 0xE0, 0x47, 0x0E, 0xE0, 0x27, 0x77, 0x74, 0x04, 0xD8, 0x1D, 0x09, 0xD0, 0xA7, 0x77, 0x75,
  0x01, 0xF0, 0x17, 0x0A, 0xE0, 0x67, 0x77, 0x74, 0x09, 0xD8, 0x1A, 0x05, 0xD0, 0xE7, 0x77, 0x75,
  0x06, 0xE0, 0xC7, 0x10, 0x6E, 0x0A, 0x77, 0x77, 0x40, 0xDD, 0x81, 0x60, 0x1E, 0x03, 0x77, 0x77,
  0x40, 0xAE, 0x07, 0x71, 0x02, 0xE0, 0xE7, 0x77, 0x73, 0x02, 0xE0, 0x22, 0x0D, 0xD0, 0x87, 0x77,
  0x74, 0x0E, 0xE0, 0x37, 0x20, 0xDE, 0x03, 0x77, 0x77, 0x20, 0x6D, 0x0E, 0x30, 0x9D, 0x0C, 0x77,
  0x77, 0x30, 0x3E, 0x0E, 0x73, 0x09, 0xE0, 0x77, 0x77, 0x72, 0x0B, 0xD0, 0xA3, 0x05, 0xE0, 0x17,
  0x77, 0x72, 0x07, 0xE0, 0xA7, 0x30, 0x5E, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x06, 0x30, 0x1E, 0x06,
  0x77, 0x77, 0x20, 0xBE, 0x06, 0x73, 0x01, 0xF7, 0x77, 0x71, 0x04, 0xE0, 0x24, 0x0C, 0xD0, 0xA7,
  0x77, 0x72, 0xF0, 0x27, 0x40, 0xCE, 0x04, 0x77, 0x77, 0x08, 0xD0, 0xD5, 0x08, 0xD0, 0xE7, 0x77,
  0x71, 0x04, 0xE0, 0xD7, 0x50, 0x8E, 0x08, 0x77, 0x77, 0x0D, 0xD0, 0x95, 0x04, 0xE0, 0x47, 0x77,
  0x70, 0x8E, 0x09, 0x75, 0x04, 0xE0, 0xC7, 0x77, 0x60, 0x2E, 0x05, 0x6E, 0x08, 0x77, 0x77, 0x0C,
  0xE0, 0x57, 0x6F, 0x01, 0x77, 0x75, 0x06, 0xE0, 0x16, 0x0B, 0xD0, 0xD7, 0x77, 0x60, 0x1F, 0x01,
  0x76, 0x0B, 0xE0, 0x57, 0x77, 0x50, 0xAD, 0x0C, 0x70, 0x6E, 0x02, 0x77, 0x75, 0x05, 0xE0, 0xC7,
  0x70, 0x7E, 0x09, 0x77, 0x75, 0x0E, 0xD0, 0x87, 0x02, 0xE0, 0x67, 0x77, 0x50, 0x9E, 0x07, 0x77,
  0x03, 0xE0, 0xD7, 0x77, 0x40, 0x4E, 0x03, 0x71, 0x0D, 0xD0, 0xA7, 0x77, 0x50, 0xDE, 0x03, 0x77,
  0x10, 0xEE, 0x01, 0x77, 0x73, 0x08, 0xD0, 0xE7, 0x20, 0x9D, 0x0E, 0x77, 0x74, 0x02, 0xE0, 0xE7,
  0x72, 0x0A, 0xE0, 0x57, 0x77, 0x30, 0xCD, 0x0A, 0x72, 0x04, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x0A,
  0x77, 0x20, 0x6E, 0x09, 0x77, 0x72, 0x01, 0xE0, 0x67, 0x3E, 0x08, 0x77, 0x73, 0x0A, 0xE0, 0x67,
  0x72, 0x02, 0xE0, 0xD7, 0x77, 0x20, 0x6E, 0x01, 0x73, 0x0B, 0xD0, 0xD7, 0x77, 0x30, 0xEE, 0x02,
  0x77, 0x30, 0xDE, 0x02, 0x77, 0x71, 0x0A, 0xD0, 0xD7, 0x40, 0x6E, 0x02, 0x77, 0x71, 0x03, 0xE0,
  0xD7, 0x74, 0x09, 0xE0, 0x67, 0x77, 0x10, 0xED, 0x08, 0x74, 0x02, 0xE0, 0x67, 0x77, 0x10, 0x7E,
  0x09, 0x77, 0x40, 0x5E, 0x0A, 0x77, 0x70, 0x3E, 0x04, 0x75, 0x0D, 0xD0, 0xB7, 0x77, 0x10, 0xBE,
  0x05, 0x77, 0x40, 0x1E, 0x0E, 0x77, 0x70, 0x8E, 0x76, 0x09, 0xE7, 0x77, 0x1F, 0x01, 0x77, 0x50,
  0xCE, 0x03, 0x77, 0x60, 0xCD, 0x0B, 0x76, 0x04, 0xE0, 0x47, 0x76, 0x04, 0xE0, 0xC7, 0x76, 0x08,
  0xE0, 0x77, 0x75, 0x01, 0xE0, 0x67, 0x7E, 0x09, 0x77, 0x60, 0x8E, 0x08, 0x77, 0x60, 0x4E, 0x0B,
  0x77, 0x50, 0x5E, 0x02, 0x77, 0x0B, 0xD0, 0xD7, 0x76, 0x0D, 0xE0, 0x37, 0x77, 0xF7, 0x75, 0x0A,
  0xD0, 0xD7, 0x71, 0x06, 0xE0, 0x27, 0x74, 0x01, 0xE0, 0xE7, 0x77, 0x10, 0xBE, 0x04, 0x77, 0x40,
  0xED, 0x09, 0x77, 0x10, 0x2E, 0x07, 0x77, 0x40, 0x5E, 0x0B, 0x77, 0x71, 0x07, 0xE0, 0x87, 0x73,
  0x03, 0xE0, 0x57, 0x72, 0x0D, 0xD0, 0xB7, 0x74, 0x0A, 0xE0, 0x67, 0x77, 0x10, 0x3E, 0x0C, 0x77,
  0x30, 0x7E, 0x01, 0x77, 0x20, 0x9E, 0x01, 0x77, 0x30, 0xEE, 0x02, 0x77, 0x72, 0x0E, 0xE0, 0x17,
  0x72, 0x0C, 0xD0, 0xB7, 0x73, 0x04, 0xE0, 0x57, 0x72, 0x02, 0xE0, 0xD7, 0x77, 0x30, 0xAE, 0x05,
  0x77, 0x10, 0x1E, 0x07, 0x77, 0x4E, 0x09, 0x77, 0x20, 0x7E, 0x09, 0x77, 0x73, 0x06, 0xE0, 0x97,
  0x71, 0x05, 0xE0, 0x37, 0x74, 0x0B, 0xD0, 0xE7, 0x72, 0x0B, 0xE0, 0x57, 0x77, 0x30, 0x2E, 0x0D,
  0x77, 0x10, 0xAD, 0x0E, 0x77, 0x50, 0x6E, 0x03, 0x77, 0x10, 0xEE, 0x01, 0x77, 0x74, 0x0D, 0xE0,
  0x17, 0x70, 0xED, 0x0A, 0x77, 0x50, 0x2E, 0x07, 0x77, 0x04, 0xE0, 0xC7, 0x77, 0x50, 0x9E, 0x05,
  0x76, 0x03, 0xE0, 0x57, 0x76, 0x0D, 0xD0, 0xC7, 0x70, 0x8E, 0x08, 0x77, 0x75, 0x05, 0xE0, 0x97,
  0x60, 0x7E, 0x01, 0x77, 0x60, 0x9E, 0x01, 0x76, 0x0C, 0xE0, 0x47, 0x77, 0x50, 0x1E, 0x0D, 0x76,
  0x0C, 0xD0, 0xC7, 0x77, 0x04, 0xE0, 0x57, 0x50, 0x1E, 0x0E, 0x77, 0x77, 0x0C, 0xE0, 0x27, 0x40,
  0x1E, 0x08, 0x77, 0x71, 0xE0, 0xA7, 0x50, 0x5E, 0x0B, 0x77, 0x77, 0x08, 0xE0, 0x67, 0x40, 0x5E,
  0x04, 0x77, 0x71, 0x0B, 0xD0, 0xE7, 0x50, 0x9E, 0x07, 0x77, 0x77, 0x04, 0xE0, 0xA7, 0x40, 0x9D,
  0x0E, 0x77, 0x72, 0x06, 0xE0, 0x37, 0x40, 0xDE, 0x02, 0x77, 0x77, 0x1E, 0x0E, 0x74, 0x0E, 0xD0,
  0xA7, 0x77, 0x20, 0x2E, 0x08, 0x73, 0x02, 0xE0, 0xD7, 0x77, 0x72, 0x0B, 0xE0, 0x37, 0x20, 0x3E,
  0x06, 0x77, 0x73, 0x0D, 0xD0, 0xC7, 0x30, 0x6E, 0x09, 0x77, 0x77, 0x20, 0x7E, 0x07, 0x72, 0x07,
  0xE0, 0x27, 0x77, 0x30, 0x9E, 0x01, 0x72, 0x0A, 0xE0, 0x57, 0x77, 0x72, 0x03, 0xE0, 0xB7, 0x20,
  0xBD, 0x0D, 0x77, 0x74, 0x04, 0xE0, 0x67, 0x20, 0xEE, 0x01, 0x77, 0x77, 0x30, 0xEE, 0x71, 0x01,
  0xE0, 0x97, 0x77, 0x5E, 0x0A, 0x71, 0x03, 0xE0, 0xC7, 0x77, 0x74, 0x0A, 0xE0, 0x47, 0x05, 0xE0,
  0x47, 0x77, 0x50, 0xBD, 0x0E, 0x71, 0x07, 0xE0, 0x87, 0x77, 0x74, 0x06, 0xE0, 0x87, 0x09, 0xE7,
  0x77, 0x60, 0x6E, 0x04, 0x70, 0xBE, 0x04, 0x77, 0x77, 0x40, 0x2E, 0x0C, 0x70, 0xDD, 0x0B, 0x77,
  0x76, 0x02, 0xE0, 0x97, 0xF7, 0x77, 0x76, 0x0D, 0xE0, 0x15, 0x02, 0xE0, 0x77, 0x77, 0x70, 0xDD,
  0x0D, 0x60, 0x4E, 0x0B, 0x77, 0x77, 0x60, 0x9E, 0x04, 0x50, 0x6E, 0x03, 0x77, 0x77, 0x09, 0xE0,
  0x35, 0x08, 0xE0, 0x77, 0x77, 0x76, 0x05, 0xE0, 0x85, 0x0B, 0xD0, 0xE7, 0x77, 0x71, 0x04, 0xE0,
  0x75, 0x0C, 0xE0, 0x37, 0x77, 0x76, 0x01, 0xE0, 0xC5, 0x0E, 0xD0, 0x97, 0x77, 0x72, 0xE0, 0xC4,
  0x01, 0xE0, 0xE8, 0x0C, 0x00, 0x0C, 0xE0, 0x13, 0x03, 0xE0, 0x57, 0x77, 0x72, 0x0B, 0xE4, 0x05,
  0xE0, 0xA8, 0x0C, 0x00, 0x08, 0xE0, 0x53, 0x07, 0xE0, 0x17, 0x77, 0x72, 0x06, 0xE0, 0x43, 0x09,
  0xE0, 0x58, 0x0C, 0x00, 0x04, 0xE0, 0x93, 0x0A, 0xD0, 0xC7, 0x77, 0x73, 0x02, 0xE0, 0x83, 0x0D,
  0xE0, 0x18, 0x0C, 0x10, 0x0E, 0xD0, 0xC3, 0x0E, 0xD0, 0x87, 0x77, 0x74, 0x0D, 0xD0, 0xC2, 0x01,
  0xE0, 0xC8, 0x0C, 0x20, 0x0B, 0xE8, 0x11, 0x01, 0xE0, 0x37, 0x77, 0x74, 0x09, 0xE2, 0x04, 0xE0,
  0x88, 0x0C, 0x20, 0x07, 0xE8, 0x14, 0x05, 0xD0, 0xE7, 0x77, 0x75, 0x04, 0xE8, 0x13, 0x07, 0xE0,
  0x48, 0x0C, 0x20, 0x03, 0xE8, 0x18, 0x08, 0xD0, 0xA7, 0x77, 0x76, 0xE8, 0x16, 0x0A, 0xE8, 0x0C,
  0x40, 0x0E, 0xD8, 0x1B, 0x0B, 0xD0, 0x67, 0x77, 0x76, 0x0B, 0xD8, 0x1A, 0x0D, 0xD0, 0xB8, 0x0C,
  0x40, 0x0A, 0xD8, 0x1E, 0x0E, 0xD0, 0x17, 0x77, 0x76, 0x06, 0xD0, 0xD1, 0xE0, 0x78, 0x0C, 0x40,
  0x06, 0xE0, 0x4D, 0x0D, 0x77, 0x77, 0x70, 0x2E, 0x04, 0xE0, 0x38, 0x0C, 0x40, 0x01, 0xE0, 0xAD,
  0x08, 0x80, 0xC0, 0x00, 0xDD, 0x09, 0xD0, 0xE8, 0x0C, 0x60, 0x0D, 0xFC, 0x04, 0x80, 0xC0, 0x00,
  0x9D, 0x0E, 0xD0, 0xA8, 0x0C, 0x60, 0x09, 0xFC, 0x80, 0xC1, 0x00, 0x4F, 0xC0, 0x68, 0x0C, 0x60,
  0x04, 0xFB, 0x0B, 0x80, 0xC2, 0x0F, 0xC0, 0x18, 0x0C, 0x60, 0x01, 0xFB, 0x07, 0x80, 0xC2, 0x00,
  0xBF, 0xA0, 0xD8, 0x0D, 0x00, 0x0C, 0xFA, 0x02, 0x80, 0xC2, 0x00, 0x6F, 0xA0, 0x88, 0x0D, 0x00,
  0x07, 0xF9, 0x0D, 0x80, 0xC3, 0x00, 0x2F, 0xA0, 0x48, 0x0D, 0x00, 0x03, 0xF9, 0x09, 0x80, 0xC4,
  0x00, 0xDF, 0x98, 0x0D, 0x20, 0x0E, 0xF0, 0x58, 0x0C, 0x40, 0x09, 0xF0, 0xB8, 0x0D, 0x20, 0x0B,
  0xF0, 0x18, 0x0C, 0x40, 0x04, 0xF0, 0x78, 0x0D, 0x20, 0x06, 0xE0, 0xC8, 0x0C, 0x60, 0xF0, 0x37,
  0x77, 0x20,
  // "X" (U+0058)
  0x20, 0x48, 0x03, 0xB0, 0x58, 0x0D, 0x00, 0x03, 0x80, 0x3B, 0x04, 0x50, 0xCE, 0x0E, 0x01, 0x80,
  0xC7, 0x00, 0xCE, 0x0C, 0x60, 0x3F, 0x0A, 0x80, 0xC6, 0x00, 0x7F, 0x03, 0x70, 0x8F, 0x04, 0x80,
  0xC4, 0x00, 0x10, 0xEE, 0x08, 0x72, 0x0D, 0xE0, 0xD8, 0x0C, 0x40, 0x0B, 0xE0, 0xD7, 0x30, 0x4F,
  0x08, 0x80, 0xC2, 0x00, 0x5F, 0x03, 0x74, 0x09, 0xF0, 0x38, 0x0C, 0x00, 0x01, 0x0E, 0xE0, 0x97,
  0x50, 0x10, 0xEE, 0x0C, 0x80, 0xC0, 0x00, 0x9E, 0x0D, 0x77, 0x05, 0xF0, 0x77, 0x77, 0x76, 0x03,
  0xF0, 0x47, 0x71, 0x0A, 0xE0, 0xE0, 0x27, 0x77, 0x75, 0x0C, 0xE0, 0xA7, 0x72, 0x01, 0x0E, 0xE0,
  0xB7, 0x77, 0x74, 0x07, 0xE0, 0xE0, 0x17, 0x73, 0x06, 0xF0, 0x57, 0x77, 0x72, 0x02, 0xF0, 0x57,
  0x75, 0x0B, 0xE0, 0xE0, 0x17, 0x77, 0x71, 0x0B, 0xE0, 0xB7, 0x76, 0x02, 0xF0, 0x97, 0x77, 0x70,
  0x5E, 0x0E, 0x01, 0x77, 0x70, 0x7F, 0x03, 0x77, 0x75, 0x01, 0x0E, 0xE0, 0x67, 0x77, 0x20, 0xCE,
  0x0D, 0x77, 0x75, 0x09, 0xE0, 0xB7, 0x77, 0x30, 0x3F, 0x07, 0x77, 0x73, 0x04, 0xF0, 0x27, 0x77,
  0x40, 0x8F, 0x02, 0x77, 0x72, 0x0D, 0xE0, 0x77, 0x77, 0x60, 0xDE, 0x0B, 0x77, 0x71, 0x07, 0xE0,
  0xC7, 0x77, 0x70, 0x4F, 0x06, 0x77, 0x60, 0x2F, 0x03, 0x77, 0x77, 0x10, 0xAE, 0x0E, 0x01, 0x77,
  0x50, 0xBE, 0x08, 0x77, 0x77, 0x20, 0x10, 0xEE, 0x09, 0x77, 0x40, 0x6E, 0x0D, 0x77, 0x77, 0x40,
  0x5F, 0x04, 0x77, 0x20, 0x10, 0xEE, 0x04, 0x77, 0x77, 0x50, 0xBE, 0x0D, 0x77, 0x20, 0xAE, 0x09,
  0x77, 0x77, 0x60, 0x20, 0xEE, 0x08, 0x77, 0x04, 0xE0, 0xD0, 0x17, 0x77, 0x77, 0x06, 0xF0, 0x27,
  0x60, 0xDE, 0x05, 0x80, 0xC1, 0x00, 0xCE, 0x0C, 0x75, 0x08, 0xE0, 0xA8, 0x0C, 0x20, 0x02, 0xF0,
  0x67, 0x30, 0x2E, 0x0E, 0x01, 0x80, 0xC3, 0x00, 0x8E, 0x0E, 0x01, 0x72, 0x0C, 0xE0, 0x58, 0x0C,
  0x50, 0x0D, 0xE0, 0xA7, 0x10, 0x6E, 0x0B, 0x80, 0xC6, 0x00, 0x3F, 0x04, 0x60, 0x10, 0xED, 0x0E,
  0x02, 0x80, 0xC7, 0x00, 0x9E, 0x0D, 0x60, 0xAE, 0x06, 0x80, 0xD1, 0x00, 0xDE, 0x08, 0x40, 0x4E,
  0x0C, 0x80, 0xD2, 0x00, 0x4F, 0x03, 0x30, 0xDE, 0x02, 0x80, 0xD3, 0x00, 0xAE, 0x0C, 0x20, 0x8E,
  0x07, 0x80, 0xD4, 0x00, 0x10, 0xEE, 0x07, 0x03, 0xE0, 0xC8, 0x0D, 0x60, 0x06, 0xE0, 0xE0, 0xDE,
  0x03, 0x80, 0xD7, 0x00, 0xBF, 0xD0, 0x88, 0x0E, 0x00, 0x02, 0xFC, 0x0D, 0x80, 0xE2, 0x00, 0x7F,
  0xB0, 0x48, 0x0E, 0x30, 0x0C, 0xF9, 0x09, 0x80, 0xE4, 0x00, 0x5F, 0x90, 0x38, 0x0E, 0x40, 0x0C,
  0xF9, 0x0C, 0x80, 0xE3, 0x00, 0x7F, 0xB0, 0x68, 0x0E, 0x10, 0x02, 0xFC, 0x0E, 0x02, 0x80, 0xE0,
  0x00, 0xCF, 0xD0, 0xB8, 0x0D, 0x70, 0x06, 0xE0, 0xC0, 0xEE, 0x05, 0x80, 0xD5, 0x00, 0x20, 0xEE,
  0x03, 0x06, 0xE0, 0xE0, 0x18, 0x0D, 0x40, 0x0B, 0xE0, 0x82, 0x0C, 0xE0, 0xA8, 0x0D, 0x30, 0x06,
  0xE0, 0xD3, 0x03, 0xF0, 0x48, 0x0D, 0x10, 0x01, 0x0E, 0xE0, 0x44, 0x08, 0xE0, 0xD8, 0x0D, 0x10,
  0x0A, 0xE0, 0x96, 0x0D, 0xE0, 0x88, 0x0C, 0x70, 0x05, 0xE0, 0xE0, 0x16, 0x04, 0xF0, 0x38, 0x0C,
  0x50, 0x01, 0x0E, 0xE0, 0x57, 0x10, 0xAE, 0x0C, 0x80, 0xC5, 0x00, 0x9E, 0x0A, 0x72, 0x01, 0x0E,
  0xE0, 0x78, 0x0C, 0x30, 0x04, 0xE0, 0xE0, 0x17, 0x30, 0x6F, 0x02, 0x80, 0xC2, 0x00, 0xDE, 0x06,
  0x75, 0x0C, 0xE0, 0xB8, 0x0C, 0x10, 0x08, 0xE0, 0xB7, 0x60, 0x3F, 0x06, 0x77, 0x77, 0x70, 0x3F,
  0x02, 0x77, 0x08, 0xE0, 0xE0, 0x17, 0x77, 0x76, 0x0C, 0xE0, 0x77, 0x72, 0x0D, 0xE0, 0xA7, 0x77,
  0x75, 0x07, 0xE0, 0xD7, 0x73, 0x05, 0xF0, 0x57, 0x77, 0x73, 0x02, 0xF0, 0x37, 0x74, 0x0A, 0xE0,
  0xD0, 0x17, 0x77, 0x72, 0x0C, 0xE0, 0x97, 0x75, 0x01, 0x0E, 0xE0, 0x97, 0x77, 0x71, 0x06, 0xE0,
  0xD7, 0x77, 0x07, 0xF0, 0x37, 0x77, 0x60, 0x20, 0xEE, 0x04, 0x77, 0x71, 0x0C, 0xE0, 0xD7, 0x77,
  0x60, 0xBE, 0x0A, 0x77, 0x72, 0x03, 0xF0, 0x87, 0x77, 0x40, 0x5E, 0x0E, 0x01, 0x77, 0x73, 0x09,
  0xF0, 0x27, 0x77, 0x20, 0x10, 0xEE, 0x06, 0x77, 0x75, 0x0D, 0xE0, 0xC7, 0x77, 0x20, 0xAE, 0x0B,
  0x77, 0x76, 0x05, 0xF0, 0x67, 0x77, 0x05, 0xE0, 0xE0, 0x27, 0x77, 0x70, 0xAE, 0x0E, 0x01, 0x77,
  0x50, 0x10, 0xEE, 0x07, 0x77, 0x77, 0x10, 0x10, 0xEE, 0x0B, 0x77, 0x50, 0x9E, 0x0C, 0x77, 0x77,
  0x30, 0x7F, 0x05, 0x77, 0x30, 0x4F, 0x03, 0x77, 0x77, 0x40, 0xCE, 0x0E, 0x01, 0x77, 0x20, 0xDE,
  0x08, 0x77, 0x77, 0x50, 0x3F, 0x09, 0x77, 0x10, 0x8E, 0x0D, 0x77, 0x77, 0x70, 0x9F, 0x04, 0x76,
  0x03, 0xF0, 0x48, 0x0C, 0x00, 0x0D, 0xE0, 0xD7, 0x60, 0xCE, 0x09, 0x80, 0xC1, 0x00, 0x5F, 0x08,
  0x74, 0x07, 0xE0, 0xE0, 0x18, 0x0C, 0x20, 0x0B, 0xF0, 0x37, 0x20, 0x2F, 0x05, 0x80, 0xC3, 0x00,
  0x20, 0xEE, 0x0C, 0x72, 0x0C, 0xE0, 0xB8, 0x0C, 0x50, 0x07, 0xF0, 0x77, 0x06, 0xE0, 0xE0, 0x18,
  0x0C, 0x60, 0x0C, 0xF0, 0x25, 0x02, 0x0E, 0xE0, 0x68, 0x0C, 0x70, 0x03, 0xF0, 0xB5, 0x0B, 0xE0,
  0xC8, 0x0D, 0x10, 0x09, 0xF0, 0x63, 0x05, 0xF0, 0x28, 0x0D, 0x10, 0x01, 0x0E, 0xE8, 0x3E, 0x10,
  0x1E, 0xE0, 0x88, 0x0D, 0x30, 0x05, 0xF8, 0x1A, 0x0A, 0xE0, 0xD8, 0x0D, 0x50, 0x0B, 0xF0, 0x40,
  // "Y" (U+0059)
  0x09, 0x80, 0x2B, 0x09, 0x80, 0xD4, 0x00, 0x68, 0x03, 0xB0, 0x10, 0x5F, 0x05, 0x80, 0xD2, 0x00,
  0x10, 0xEE, 0x0A, 0x20, 0xCE, 0x0D, 0x80, 0xD2, 0x00, 0x8F, 0x02, 0x20, 0x4F, 0x06, 0x80, 0xD0,
  0x00, 0x10, 0xEE, 0x09, 0x40, 0xBE, 0x0D, 0x80, 0xD0, 0x00, 0x9E, 0x0E, 0x01, 0x40, 0x2F, 0x07,
  0x80, 0xC6, 0x00, 0x2F, 0x07, 0x60, 0x9E, 0x0E, 0x80, 0xC6, 0x00, 0xAE, 0x0E, 0x70, 0x1F, 0x08,
  0x80, 0xC4, 0x00, 0x3F, 0x06, 0x71, 0x08, 0xE0, 0xE0, 0x18, 0x0C, 0x30, 0x0B, 0xE0, 0xD7, 0x20,
  0x10, 0xEE, 0x09, 0x80, 0xC2, 0x00, 0x4F, 0x05, 0x73, 0x07, 0xF0, 0x28, 0x0C, 0x10, 0x0C, 0xE0,
  0xC7, 0x50, 0xDE, 0x0A, 0x80, 0xC0, 0x00, 0x5F, 0x03, 0x75, 0x05, 0xF0, 0x37, 0x77, 0x77, 0x0D,
  0xE0, 0xA7, 0x70, 0xCE, 0x0B, 0x77, 0x77, 0x60, 0x6F, 0x02, 0x77, 0x04, 0xF0, 0x47, 0x77, 0x75,
  0x0D, 0xE0, 0x97, 0x72, 0x0B, 0xE0, 0xC7, 0x77, 0x74, 0x07, 0xE0, 0xE0, 0x17, 0x72, 0x03, 0xF0,
  0x57, 0x77, 0x72, 0x01, 0x0E, 0xE0, 0x87, 0x74, 0x0A, 0xE0, 0xD7, 0x77, 0x72, 0x08, 0xE0, 0xE7,
  0x75, 0x02, 0xF0, 0x67, 0x77, 0x70, 0x10, 0xEE, 0x06, 0x77, 0x60, 0x9E, 0x0D, 0x77, 0x77, 0x09,
  0xE0, 0xD7, 0x77, 0x01, 0x0E, 0xE0, 0x77, 0x77, 0x50, 0x2F, 0x05, 0x77, 0x71, 0x07, 0xE0, 0xE0,
  0x17, 0x77, 0x40, 0xAE, 0x0C, 0x77, 0x73, 0x0E, 0xE0, 0x87, 0x77, 0x30, 0x3F, 0x04, 0x77, 0x73,
  0x06, 0xE0, 0xE0, 0x17, 0x77, 0x20, 0xBE, 0x0B, 0x77, 0x75, 0x0D, 0xE0, 0x97, 0x77, 0x10, 0x4F,
  0x02, 0x77, 0x75, 0x05, 0xF0, 0x27, 0x77, 0x0C, 0xE0, 0x97, 0x77, 0x70, 0xCE, 0x0A, 0x77, 0x60,
  0x5F, 0x01, 0x77, 0x77, 0x03, 0xF0, 0x37, 0x75, 0x0D, 0xE0, 0x87, 0x77, 0x72, 0x0A, 0xE0, 0xB7,
  0x74, 0x06, 0xE0, 0xE0, 0x17, 0x77, 0x72, 0x02, 0xF0, 0x47, 0x73, 0x0D, 0xE0, 0x77, 0x77, 0x74,
  0x09, 0xE0, 0xC7, 0x72, 0x07, 0xE0, 0xD7, 0x77, 0x75, 0x01, 0x0E, 0xE0, 0x57, 0x70, 0x10, 0xEE,
  0x05, 0x77, 0x77, 0x60, 0x8E, 0x0D, 0x77, 0x08, 0xE0, 0xC8, 0x0C, 0x00, 0x0E, 0xE0, 0x67, 0x50,
  0x1F, 0x04, 0x80, 0xC0, 0x00, 0x6E, 0x0D, 0x75, 0x09, 0xE0, 0xB8, 0x0C, 0x20, 0x0D, 0xE0, 0x77,
  0x30, 0x2F, 0x03, 0x80, 0xC2, 0x00, 0x5E, 0x0E, 0x01, 0x72, 0x0A, 0xE0, 0xA8, 0x0C, 0x40, 0x0C,
  0xE0, 0x87, 0x10, 0x3F, 0x02, 0x80, 0xC4, 0x00, 0x4E, 0x0E, 0x01, 0x70, 0xBE, 0x08, 0x80, 0xC6,
  0x00, 0xBE, 0x09, 0x60, 0x4E, 0x0E, 0x01, 0x80, 0xC6, 0x00, 0x2F, 0x02, 0x50, 0xCE, 0x07, 0x80,
  0xD0, 0x00, 0x9E, 0x0A, 0x40, 0x5E, 0x0D, 0x80, 0xD1, 0x00, 0x1F, 0x03, 0x30, 0xDE, 0x06, 0x80,
  0xD2, 0x00, 0x8E, 0x0B, 0x20, 0x6E, 0x0D, 0x80, 0xD3, 0x00, 0x10, 0xEE, 0x81, 0x40, 0xEE, 0x04,
  0x80, 0xD4, 0x00, 0x7E, 0x0C, 0x07, 0xE0, 0xB8, 0x0D, 0x60, 0x0D, 0xFE, 0x03, 0x80, 0xD6, 0x00,
  0x5F, 0xD0, 0xA8, 0x0E, 0x00, 0x0C, 0xFC, 0x02, 0x80, 0xE0, 0x00, 0x4F, 0xB0, 0x98, 0x0E, 0x20,
  0x0B, 0xF9, 0x0E, 0x01, 0x80, 0xE2, 0x00, 0x3F, 0x90, 0x78, 0x0E, 0x40, 0x0A, 0xE0, 0xE8, 0x0E,
  0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50,
  0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03,
  0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0,
  0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8,
  0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E,
  0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50,
  0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03,
  0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0,
  0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8,
  0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E,
  0x50, 0x03, 0xE0, 0xB7, 0x77, 0x71,
  // "Z" (U+005A)
  0x20, 0x18, 0x0E, 0x3B, 0x0A, 0x40, 0x28, 0x0E, 0x3F, 0x0D, 0x40, 0x28, 0x0E, 0x3F, 0x0D, 0x40,
  0x28, 0x0E, 0x3F, 0x0D, 0x40, 0x28, 0x0E, 0x3F, 0x0D, 0x40, 0x28, 0x0E, 0x3F, 0x0C, 0x40, 0x18,
  0x0D, 0x37, 0x0E, 0xF0, 0x38, 0x0D, 0x70, 0x06, 0xF0, 0x88, 0x0D, 0x70, 0x01, 0x0E, 0xE0, 0xC8,
  0x0E, 0x00, 0x0B, 0xF0, 0x38, 0x0D, 0x70, 0x06, 0xF0, 0x88, 0x0D, 0x70, 0x01, 0x0E, 0xE0, 0xC8,
  0x0E, 0x00, 0x0B, 0xF0, 0x38, 0x0D, 0x70, 0x06, 0xF0, 0x78, 0x0D, 0x70, 0x02, 0x0E, 0xE0, 0xC8,
  0x0E, 0x00, 0x0B, 0xF0, 0x38, 0x0D, 0x70, 0x06, 0xF0, 0x78, 0x0D, 0x70, 0x02, 0x0E, 0xE0, 0xC8,
  0x0E, 0x00, 0x0B, 0xF0, 0x38, 0x0D, 0x70, 0x06, 0xF0, 0x78, 0x0D, 0x70, 0x02, 0x0E, 0xE0, 0xC8,
  0x0E, 0x00, 0x0B, 0xF0, 0x28, 0x0D, 0x70, 0x06, 0xF0, 0x78, 0x0D, 0x70, 0x02, 0x0E, 0xE0, 0xC8,
  0x0E, 0x00, 0x0C, 0xF0, 0x28, 0x0D, 0x70, 0x07, 0xF0, 0x78, 0x0D, 0x70, 0x02, 0xF0, 0xC8, 0x0E,
  0x00, 0x0C, 0xF0, 0x28, 0x0D, 0x70, 0x07, 0xF0, 0x78, 0x0D, 0x70, 0x02, 0xF0, 0xC8, 0x0E, 0x00,
  0x0C, 0xF0, 0x28, 0x0D, 0x70, 0x07, 0xF0, 0x78, 0x0D, 0x70, 0x02, 0xF0, 0xC8, 0x0E, 0x00, 0x0C,
  0xF0, 0x28, 0x0D, 0x70, 0x07, 0xF0, 0x78, 0x0D, 0x70, 0x02, 0xF0, 0xC8, 0x0E, 0x00, 0x0C, 0xF0,
  0x28, 0x0D, 0x70, 0x07, 0xF0, 0x78, 0x0D, 0x70, 0x03, 0xF0, 0xC8, 0x0E, 0x00, 0x0C, 0xF0, 0x28,
  0x0D, 0x70, 0x07, 0xF0, 0x78, 0x0D, 0x70, 0x03, 0xF0, 0xC8, 0x0E, 0x00, 0x0C, 0xF0, 0x28, 0x0D,
  0x70, 0x08, 0xF0, 0x78, 0x0D, 0x70, 0x03, 0xF0, 0xC8, 0x0E, 0x00, 0x0D, 0xE0, 0xE0, 0x28, 0x0D,
  0x70, 0x08, 0xF0, 0x68, 0x0D, 0x70, 0x03, 0xF0, 0xB8, 0x0E, 0x00, 0x0D, 0xE0, 0xE0, 0x28, 0x0D,
  0x70, 0x08, 0xF0, 0x68, 0x0D, 0x70, 0x03, 0xF0, 0xB8, 0x0E, 0x00, 0x0D, 0xE0, 0xE0, 0x28, 0x0D,
  0x70, 0x08, 0xF0, 0x68, 0x0D, 0x70, 0x03, 0xF0, 0xB8, 0x0E, 0x00, 0x0D, 0xE0, 0xE0, 0x28, 0x0D,
  0x70, 0x08, 0xF0, 0x68, 0x0D, 0x70, 0x03, 0xF0, 0xB8, 0x0E, 0x00, 0x0D, 0xE0, 0xE0, 0x28, 0x0D,
  0x70, 0x09, 0xF0, 0x68, 0x0D, 0x70, 0x04, 0xF0, 0xB8, 0x0E, 0x00, 0x0D, 0xE0, 0xE0, 0x28, 0x0D,
  0x70, 0x09, 0xF0, 0x68, 0x0D, 0x70, 0x04, 0xF0, 0xB8, 0x0E, 0x00, 0x0D, 0xE0, 0xE0, 0x18, 0x0D,
  0x70, 0x09, 0xF0, 0x68, 0x0D, 0x70, 0x04, 0xF0, 0xB8, 0x0E, 0x00, 0x0D, 0xE0, 0xE0, 0x18, 0x0D,
  0x70, 0x09, 0xF0, 0x68, 0x0D, 0x70, 0x04, 0xF0, 0xB8, 0x0D, 0x70, 0x01, 0x0D, 0xE0, 0xE0, 0x18,
  0x0D, 0x70, 0x09, 0xF0, 0x68, 0x0D, 0x70, 0x04, 0xF0, 0xB8, 0x0D, 0x70, 0x01, 0x0D, 0xE0, 0xE0,
  0x18, 0x0D, 0x70, 0x09, 0xF0, 0x68, 0x0D, 0x70, 0x04, 0xF0, 0xB8, 0x0D, 0x70, 0x01, 0x0E, 0xE0,
  0xE0, 0x18, 0x0D, 0x70, 0x0A, 0xF0, 0x58, 0x0D, 0x70, 0x05, 0xF0, 0xB8, 0x0D, 0x70, 0x01, 0x0E,
  0xE0, 0xE0, 0x18, 0x0D, 0x70, 0x0A, 0xF0, 0x98, 0x0D, 0x63, 0x01, 0x05, 0x80, 0xE7, 0xF0, 0x40,
  0x88, 0x0E, 0x7F, 0x04, 0x08, 0x80, 0xE7, 0xF0, 0x40, 0x88, 0x0E, 0x7F, 0x04, 0x08, 0x80, 0xE7,
  0xF0, 0x40, 0x88, 0x0E, 0x7F, 0x04,
  // "[" (U+005B)
  0x0A, 0x80, 0xA4, 0xB0, 0x50, 0xEF, 0xFF, 0xB0, 0x70, 0xEF, 0xFF, 0xB0, 0x70, 0xEF, 0xFF, 0xB0,
  0x70, 0xEF, 0xFF, 0xB0, 0x70, 0xEF, 0xFF, 0xB0, 0x70, 0xED, 0x0C, 0x80, 0x97, 0x10, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C,
  0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0C, 0x77, 0x50, 0xED, 0x0E,
  0x80, 0x96, 0xB0, 0x50, 0xEF, 0xFF, 0xB0, 0x70, 0xEF, 0xFF, 0xB0, 0x70, 0xEF, 0xFF, 0xB0, 0x70,
  0xEF, 0xFF, 0xB0, 0x70, 0xEF, 0xFF, 0xB0, 0x70,
  // "\" (U+005C)
  0x05, 0x80, 0x2B, 0x03, 0x77, 0x77, 0x40, 0x1E, 0x09, 0x77, 0x77, 0x50, 0xBD, 0x0E, 0x77, 0x77,
  0x50, 0x5E, 0x05, 0x77, 0x77, 0x50, 0xED, 0x0B, 0x77, 0x77, 0x50, 0x9E, 0x01, 0x77, 0x77, 0x40,
  0x3E, 0x07, 0x77, 0x77, 0x50, 0xDD, 0x0D, 0x77, 0x77, 0x50, 0x7E, 0x03, 0x77, 0x77, 0x40, 0x2E,
  0x09, 0x77, 0x77, 0x50, 0xBD, 0x0E, 0x77, 0x77, 0x50, 0x6E, 0x05, 0x77, 0x77, 0x50, 0xED, 0x0B,
  0x77, 0x77, 0x50, 0xAE, 0x01, 0x77, 0x77, 0x40, 0x4E, 0x07, 0x77, 0x77, 0x50, 0xDD, 0x0D, 0x77,
  0x77, 0x50, 0x8E, 0x03, 0x77, 0x77, 0x40, 0x2E, 0x09, 0x77, 0x77, 0x50, 0xCD, 0x0E, 0x77, 0x77,
  0x50, 0x6E, 0x05, 0x77, 0x77, 0x40, 0x1E, 0x0B, 0x77, 0x77, 0x50, 0xAE, 0x01, 0x77, 0x77, 0x40,
  0x4E, 0x07, 0x77, 0x77, 0x50, 0xED, 0x0D, 0x77, 0x77, 0x50, 0x8E, 0x03, 0x77, 0x77, 0x40, 0x2E,
  0x09, 0x77, 0x77, 0x50, 0xCD, 0x0E, 0x77, 0x77, 0x50, 0x6E, 0x05, 0x77, 0x77, 0x40, 0x1E, 0x0B,
  0x77, 0x77, 0x50, 0xAE, 0x01, 0x77, 0x77, 0x40, 0x4E, 0x07, 0x77, 0x77, 0x50, 0xED, 0x0D, 0x77,
  0x77, 0x50, 0x8E, 0x03, 0x77, 0x77, 0x40, 0x3E, 0x09, 0x77, 0x77, 0x50, 0xCD, 0x0E, 0x77, 0x77,
  0x50, 0x7E, 0x05, 0x77, 0x77, 0x40, 0x1E, 0x0B, 0x77, 0x77, 0x50, 0xAE, 0x01, 0x77, 0x77, 0x40,
  0x5E, 0x07, 0x77, 0x77, 0x50, 0xED, 0x0D, 0x77, 0x77, 0x50, 0x9E, 0x03, 0x77, 0x77, 0x40, 0x3E,
  0x09, 0x77, 0x77, 0x50, 0xDD, 0x0E, 0x77, 0x77, 0x50, 0x7E, 0x05, 0x77, 0x77, 0x40, 0x1E, 0x0B,
  0x77, 0x77, 0x50, 0xBE, 0x01, 0x77, 0x77, 0x40, 0x5E, 0x07, 0x77, 0x77, 0x50, 0xED, 0x0D, 0x77,
  0x77, 0x50, 0x9E, 0x03, 0x77, 0x77, 0x40, 0x3E, 0x09, 0x77, 0x77, 0x50, 0xDD, 0x0E, 0x77, 0x77,
  0x50, 0x7E, 0x05, 0x77, 0x77, 0x40, 0x1E, 0x0B, 0x77, 0x77, 0x50, 0xBE, 0x01, 0x77, 0x77, 0x40,
  0x5E, 0x07, 0x77, 0x77, 0x50, 0xED, 0x0D, 0x77, 0x77, 0x50, 0x9E, 0x03, 0x77, 0x77, 0x40, 0x3E,
  0x09, 0x77, 0x77, 0x50, 0xDD, 0x0E, 0x77, 0x77, 0x50, 0x7E, 0x05, 0x77, 0x77, 0x40, 0x2E, 0x0B,
  0x77, 0x77, 0x50, 0xBE, 0x01, 0x77, 0x77, 0x40, 0x6E, 0x07, 0x77, 0x77, 0x50, 0xED, 0x0D, 0x77,
  0x77, 0x50, 0xAE, 0x03, 0x77, 0x77, 0x40, 0x4E, 0x09, 0x77, 0x77, 0x50, 0xDD, 0x0E, 0x77, 0x77,
  0x50, 0x8E, 0x05, 0x77, 0x77, 0x40, 0x2E, 0x0B, 0x77, 0x77, 0x50, 0xCE, 0x01, 0x77, 0x77, 0x40,
  0x6E, 0x07, 0x77, 0x77, 0x40, 0x1E, 0x0D, 0x77, 0x77, 0x50, 0xAE, 0x03, 0x77, 0x77, 0x40, 0x4E,
  0x09, 0x77, 0x77, 0x50, 0xED, 0x0E, 0x77, 0x77, 0x50, 0x8E, 0x05, 0x77, 0x77, 0x40, 0x2E, 0x0B,
  0x77, 0x77, 0x50, 0xCE, 0x01, 0x77, 0x77, 0x40, 0x6E, 0x07, 0x77, 0x77, 0x40, 0x1E, 0x0D, 0x77,
  0x77, 0x50, 0xAE, 0x03, 0x77, 0x77, 0x40, 0x4E, 0x09, 0x77, 0x77, 0x50, 0xED, 0x0E, 0x77, 0x77,
  0x50, 0x8E, 0x05, 0x77, 0x77, 0x40, 0x3E, 0x0B, 0x77, 0x77, 0x50, 0xCE, 0x02,
  // "]" (U+005D)
  0x80, 0xA5, 0xB0, 0x5F, 0xFF, 0xC0, 0x6F, 0xFF, 0xC0, 0x6F, 0xFF, 0xC0, 0x6F, 0xFF, 0xC0, 0x6F,
  0xFF, 0xC0, 0x68, 0x09, 0x61, 0x04, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x67,
  0x74, 0x02, 0xE0, 0x67, 0x74, 0x02, 0xE0, 0x68, 0x09, 0x6B, 0x0C, 0xE0, 0x6F, 0xFF, 0xC0, 0x6F,
  0xFF, 0xC0, 0x6F, 0xFF, 0xC0, 0x6F, 0xFF, 0xC0, 0x6F, 0xFF, 0xC0, 0x60,
  // "^" (U+005E)
  0x77, 0x76, 0x80, 0x03, 0x01, 0x80, 0xE1, 0x00, 0x7C, 0x09, 0x80, 0xE1, 0x00, 0xED, 0x02, 0x80,
  0xD7, 0x00, 0x7E, 0x0A, 0x80, 0xD7, 0x00, 0xEF, 0x02, 0x80, 0xD5, 0x00, 0x7F, 0x90, 0xA8, 0x0D,
  0x50, 0x0E, 0xFA, 0x02, 0x80, 0xD3, 0x00, 0x7F, 0xB0, 0xA8, 0x0D, 0x30, 0x0E, 0xC0, 0xE0, 0xCD,
  0x03, 0x80, 0xD1, 0x00, 0x7D, 0x07, 0x04, 0xD0, 0xA8, 0x0D, 0x10, 0x0E, 0xC0, 0xE2, 0x0C, 0xD0,
  0x38, 0x0C, 0x70, 0x07, 0xD0, 0x72, 0x04, 0xD0, 0xB8, 0x0C, 0x70, 0x0E, 0xC0, 0xE0, 0x13, 0x0C,
  0xD0, 0x38, 0x0C, 0x50, 0x07, 0xD0, 0x74, 0x04, 0xD0, 0xB8, 0x0C, 0x50, 0x0E, 0xC0, 0xE0, 0x15,
  0x0C, 0xD0, 0x38, 0x0C, 0x30, 0x07, 0xD0, 0x86, 0x04, 0xD0, 0xB8, 0x0C, 0x30, 0x0E, 0xC0, 0xE0,
  0x17, 0x0C, 0xD0, 0x38, 0x0C, 0x10, 0x07, 0xD0, 0x87, 0x10, 0x4D, 0x0B, 0x80, 0xC1, 0x00, 0xEC,
  0x0E, 0x01, 0x72, 0x0C, 0xD0, 0x47, 0x77, 0x77, 0x07, 0xD0, 0x87, 0x30, 0x4D, 0x0B, 0x77, 0x77,
  0x70, 0xEC, 0x0E, 0x01, 0x74, 0x0C, 0xD0, 0x47, 0x77, 0x75, 0x07, 0xD0, 0x87, 0x50, 0x4D, 0x0C,
  0x77, 0x77, 0x50, 0xED, 0x01, 0x76, 0x0C, 0xD0, 0x47, 0x77, 0x73, 0x07, 0xD0, 0x97, 0x70, 0x4D,
  0x0C, 0x77, 0x77, 0x30, 0xED, 0x01, 0x77, 0x10, 0xCD, 0x04, 0x77, 0x77, 0x10, 0x7D, 0x09, 0x77,
  0x20, 0x4D, 0x0C, 0x77, 0x77, 0x10, 0xED, 0x02, 0x77, 0x30, 0xCD, 0x05, 0x77, 0x76, 0x07, 0xD0,
  0x97, 0x74, 0x04, 0xD0, 0xC7, 0x77, 0x60, 0xED, 0x02, 0x77, 0x50, 0xCD, 0x05, 0x77, 0x74, 0x07,
  0xD0, 0x97, 0x76, 0x04, 0xD0, 0xD7, 0x77, 0x30, 0x10, 0xED, 0x02, 0x77, 0x70, 0xCD, 0x05, 0x77,
  0x72, 0x07, 0xD0, 0xA7, 0x77, 0x10, 0x4D, 0x0D, 0x77, 0x71, 0x01, 0x0E, 0xD0, 0x27, 0x77, 0x20,
  0xCD, 0x05, 0x77, 0x70, 0x7D, 0x0A, 0x77, 0x73, 0x04, 0xD0, 0xD7, 0x76, 0x01, 0x0E, 0xD0, 0x27,
  0x77, 0x40, 0xCD, 0x06, 0x77, 0x50, 0x7D, 0x0A, 0x77, 0x75, 0x04, 0xD0, 0xD7, 0x74, 0x01, 0x0E,
  0xD0, 0x37, 0x77, 0x60, 0xCD, 0x06, 0x77, 0x30, 0x7D, 0x0A, 0x77, 0x77, 0x04, 0xD0, 0xD7, 0x72,
  0x01, 0x0E, 0xD0, 0x37, 0x77, 0x71, 0x0C, 0xD0, 0x67, 0x71, 0x07, 0xD0, 0xB7, 0x77, 0x72, 0x04,
  0xD0, 0xD7, 0x70, 0x10, 0xED, 0x03, 0x77, 0x77, 0x30, 0xCD, 0x06, 0x76, 0x07, 0xD0, 0xB7, 0x77,
  0x74, 0x04, 0xD0, 0xE7, 0x50, 0x10, 0xED, 0x03, 0x77, 0x77, 0x50, 0xCD, 0x07, 0x74, 0x07, 0xD0,
  0xB7, 0x77, 0x76, 0x04, 0xD0, 0xE7, 0x30, 0x10, 0xED, 0x03, 0x77, 0x77, 0x70, 0xCD, 0x07, 0x72,
  0x07, 0xD0, 0xB8, 0x0C, 0x00, 0x04, 0xD0, 0xE7, 0x10, 0x10, 0xED, 0x04, 0x80, 0xC1, 0x00, 0xCD,
  0x07, 0x70, 0x7D, 0x0C, 0x80, 0xC2, 0x00, 0x4D, 0x0E, 0x01, 0x50, 0x10, 0xED, 0x04, 0x80, 0xC3,
  0x00, 0xCD, 0x07, 0x50, 0x8D, 0x0C, 0x80, 0xC4, 0x00, 0x4D, 0x0E, 0x01, 0x30, 0x10, 0xED, 0x04,
  0x80, 0xC5, 0x00, 0xCD, 0x08, 0x30, 0x8D, 0x0C, 0x80, 0xC6, 0x00, 0x4D, 0x83, 0xE1, 0x01, 0xED,
  0x05, 0x80, 0xC7, 0x00, 0xCD, 0x81, 0x80, 0x8D, 0x0C, 0x80, 0xD0, 0x00, 0x4D, 0x0E, 0x01, 0x80,
  0x25, 0x02, 0x80, 0xD1, 0x08, 0x02, 0x50, 0x20,
  // "_" (U+005F)
  0x18, 0x0D, 0x63, 0x01, 0x03, 0x80, 0xD6, 0xF0, 0x60, 0x38, 0x0D, 0x6F, 0x06, 0x03, 0x80, 0xD6,
  0xF0, 0x60, 0x38, 0x0D, 0x6F, 0x06, 0x03, 0x80, 0xD6, 0xF0, 0x61, 0x80, 0xD6, 0x30, 0x10,
  // "`" (U+0060)
  0x02, 0x80, 0x4D, 0x02, 0x77, 0x0D, 0xF0, 0xB7, 0x70, 0x3F, 0x90, 0x57, 0x70, 0x6F, 0x0E, 0x01,
  0x77, 0x09, 0xF0, 0xB7, 0x71, 0x0B, 0xF0, 0x67, 0x71, 0x0C, 0xF0, 0x37, 0x70, 0x10, 0xDE, 0x0D,
  0x01, 0x77, 0x02, 0x0E, 0xE0, 0xA7, 0x71, 0x03, 0x0E, 0xE0, 0x77, 0x71, 0x03, 0x0E, 0xE0, 0x47,
  0x71, 0x03, 0x0E, 0xD0, 0xE0, 0x27, 0x71, 0x03, 0x0E, 0xD0, 0xC7, 0x72, 0x04, 0x0E, 0xD0, 0xA7,
  0x72, 0x03, 0x0E, 0xD0, 0x87, 0x72, 0x03, 0x0E, 0xD0, 0x77, 0x72, 0x02, 0x0D, 0xD0, 0x57, 0x72,
  0x01, 0x0C, 0xD0, 0x57, 0x73, 0x0A, 0xD7, 0x74, 0x80, 0x13,
  // "a" (U+0061)
  0x77, 0x58, 0x41, 0x36, 0x8A, 0xB8, 0x02, 0xD8, 0x3B, 0xA8, 0x52, 0x77, 0x77, 0x18, 0x21, 0x59,
  0xDF, 0xFB, 0x81, 0xD9, 0x37, 0x77, 0x28, 0x11, 0x6B, 0xFF, 0xFB, 0x0C, 0x05, 0x77, 0x50, 0x40,
  0xBF, 0xFF, 0xF9, 0x0B, 0x01, 0x77, 0x10, 0x60, 0xDF, 0xFF, 0xFC, 0x0E, 0x04, 0x76, 0x0A, 0xFF,
  0xB0, 0xE8, 0x00, 0xDF, 0xF0, 0x57, 0x50, 0x5F, 0xC8, 0x3D, 0x96, 0x31, 0x78, 0x22, 0x49, 0xDF,
  0xB0, 0x37, 0x50, 0xEF, 0x81, 0xA5, 0x17, 0x72, 0x04, 0x0C, 0xF9, 0x0D, 0x75, 0x09, 0xC8, 0x1C,
  0x61, 0x77, 0x70, 0x7F, 0x90, 0x87, 0x40, 0x3A, 0x0A, 0x03, 0x77, 0x74, 0x04, 0xF9, 0x01, 0x74,
  0x08, 0x02, 0x77, 0x77, 0x06, 0xF0, 0x88, 0x0C, 0x60, 0x0A, 0xE0, 0xD8, 0x0C, 0x60, 0x02, 0xF0,
  0x38, 0x0C, 0x60, 0x0B, 0xE0, 0x78, 0x0C, 0x60, 0x05, 0xE0, 0xB8, 0x0C, 0x60, 0x01, 0xE0, 0xE8,
  0x0C, 0x70, 0x0C, 0xE0, 0x18, 0x0C, 0x60, 0x0A, 0xE0, 0x38, 0x0C, 0x60, 0x07, 0xE0, 0x58, 0x0C,
  0x60, 0x06, 0xE0, 0x68, 0x0C, 0x60, 0x05, 0xE0, 0x68, 0x0C, 0x60, 0x04, 0xE0, 0x78, 0x0C, 0x60,
  0x03, 0xE0, 0x78, 0x0C, 0x60, 0x03, 0xE0, 0x78, 0x0C, 0x60, 0x03, 0xE0, 0x78, 0x0C, 0x60, 0x03,
  0xE0, 0x78, 0x0C, 0x60, 0x03, 0xE0, 0x77, 0x77, 0x77, 0x86, 0x11, 0x23, 0x35, 0x58, 0xE0, 0x77,
  0x77, 0x28, 0x90, 0x24, 0x67, 0x9A, 0xBC, 0xDD, 0xFF, 0xA0, 0x77, 0x74, 0x82, 0x37, 0xAD, 0xFF,
  0xFE, 0x07, 0x77, 0x82, 0x16, 0xBE, 0xFF, 0xFF, 0xB0, 0x77, 0x50, 0x50, 0xBF, 0xFF, 0xFF, 0x07,
  0x73, 0x06, 0x0D, 0xFF, 0xFF, 0x81, 0xED, 0xDE, 0x07, 0x71, 0x03, 0x0C, 0xFF, 0x98, 0x5D, 0xB9,
  0x87, 0x55, 0x0F, 0x30, 0xF1, 0x40, 0x3E, 0x07, 0x70, 0x8F, 0xD8, 0x2C, 0x85, 0x27, 0x74, 0x03,
  0xE0, 0x76, 0x0B, 0xFB, 0x81, 0xA5, 0x17, 0x77, 0x10, 0x3E, 0x07, 0x40, 0x10, 0xCF, 0x98, 0x1E,
  0x81, 0x77, 0x74, 0x03, 0xE0, 0x74, 0x0B, 0xF9, 0x09, 0x01, 0x77, 0x76, 0x03, 0xE0, 0x73, 0x07,
  0xF0, 0xE0, 0x47, 0x77, 0x71, 0x03, 0xE0, 0x72, 0x02, 0xF0, 0xE0, 0x37, 0x77, 0x72, 0x04, 0xE0,
  0x72, 0x0A, 0xF0, 0x47, 0x77, 0x73, 0x05, 0xE8, 0x17, 0x02, 0xF0, 0x87, 0x77, 0x74, 0x06, 0xE8,
  0x17, 0x07, 0xE0, 0xE7, 0x77, 0x75, 0x08, 0xE8, 0x17, 0x0B, 0xE0, 0x87, 0x77, 0x75, 0x0A, 0xE0,
  0x71, 0xF0, 0x37, 0x77, 0x75, 0x0D, 0xE0, 0x70, 0x2F, 0x77, 0x77, 0x50, 0x1F, 0x07, 0x04, 0xE0,
  0xD7, 0x77, 0x75, 0x05, 0xF0, 0x70, 0x4E, 0x0B, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x05, 0xE0, 0xB7,
  0x77, 0x75, 0x0E, 0xF0, 0x70, 0x4E, 0x0B, 0x77, 0x77, 0x40, 0x6F, 0x90, 0x70, 0x4E, 0x0D, 0x77,
  0x77, 0x40, 0xDF, 0x90, 0x70, 0x2F, 0x77, 0x77, 0x30, 0x6F, 0xA0, 0x71, 0xF0, 0x47, 0x77, 0x71,
  0x02, 0x0E, 0xFA, 0x81, 0x70, 0xCE, 0x09, 0x77, 0x77, 0x10, 0xCF, 0xB8, 0x17, 0x08, 0xF0, 0x17,
  0x77, 0x60, 0xAC, 0x09, 0x0E, 0xD8, 0x17, 0x03, 0xF0, 0xA7, 0x77, 0x50, 0xAC, 0x81, 0xC0, 0xDD,
  0x07, 0x20, 0xCF, 0x08, 0x77, 0x72, 0x01, 0x0C, 0xD8, 0x12, 0x0B, 0xD0, 0x72, 0x05, 0xF9, 0x09,
  0x77, 0x70, 0x60, 0xED, 0x05, 0x20, 0x9D, 0x07, 0x30, 0xBF, 0x90, 0xD0, 0x47, 0x73, 0x06, 0x0D,
  0xE0, 0x73, 0x07, 0xD0, 0x73, 0x01, 0x0E, 0xFA, 0x81, 0xC7, 0x27, 0x38, 0x22, 0x5A, 0xEF, 0x08,
  0x40, 0x5D, 0x07, 0x40, 0x30, 0xEF, 0xC8, 0x90, 0xEC, 0xA9, 0x99, 0x9A, 0xCE, 0xFB, 0x06, 0x50,
  0x3D, 0x07, 0x50, 0x30, 0xEF, 0xFF, 0xF0, 0xE0, 0x56, 0x01, 0xD0, 0x76, 0x01, 0x0C, 0xFF, 0xFD,
  0x0C, 0x01, 0x71, 0xD0, 0x77, 0x10, 0x60, 0xEF, 0xFF, 0x90, 0xD0, 0x67, 0x30, 0xDC, 0x07, 0x73,
  0x06, 0x0C, 0xFF, 0xC0, 0xB0, 0x57, 0x50, 0xBC, 0x07, 0x75, 0x83, 0x16, 0x9C, 0xEF, 0x98, 0x3D,
  0xB8, 0x51, 0x80, 0xC2, 0x08, 0x41, 0x23, 0x21, 0x17, 0x77, 0x50,
  // "b" (U+0062)
  0x02, 0x80, 0x23, 0x01, 0x80, 0xD3, 0x00, 0x8E, 0x04, 0x80, 0xD3, 0x00, 0x8E, 0x04, 0x80, 0xD3,
  0x00, 0x8E, 0x04, 0x80, 0xD3, 0x00, 0x8E, 0x04, 0x80, 0xD3, 0x00, 0x8E, 0x04, 0x80, 0xD3, 0x00,
  0x8E, 0x04, 0x80, 0xD3, 0x00, 0x8E, 0x04, 0x80, 0xD3, 0x00, 0x8E, 0x04, 0x80, 0xD3, 0x00, 0x8E,
  0x04, 0x80, 0xD3, 0x00, 0x8E, 0x04, 0x80, 0xD3, 0x00, 0x8E, 0x04, 0x80, 0xD3, 0x00, 0x8E, 0x04,
  0x80, 0xD3, 0x00, 0x8E, 0x04, 0x80, 0xD3, 0x00, 0x8E, 0x04, 0x80, 0xD3, 0x00, 0x8E, 0x04, 0x80,
  0xD3, 0x00, 0x8E, 0x04, 0x80, 0xD3, 0x00, 0x8E, 0x04, 0x80, 0xD3, 0x00, 0x8E, 0x04, 0x80, 0xD3,
  0x00, 0x8E, 0x04, 0x80, 0xD3, 0x00, 0x8E, 0x04, 0x80, 0xD3, 0x00, 0x8E, 0x04, 0x80, 0xD3, 0x00,
  0x8E, 0x04, 0x80, 0xD3, 0x00, 0x8E, 0x04, 0x80, 0xD3, 0x00, 0x8E, 0x04, 0x80, 0xD3, 0x00, 0x8E,
  0x04, 0x80, 0xD3, 0x00, 0x8E, 0x04, 0x80, 0xD3, 0x00, 0x8E, 0x04, 0x76, 0x84, 0x26, 0x9B, 0xDE,
  0xC8, 0x4E, 0xDA, 0x85, 0x17, 0x74, 0x08, 0xE0, 0x47, 0x38, 0x12, 0x8D, 0xFF, 0xA8, 0x1D, 0x72,
  0x77, 0x10, 0x8E, 0x03, 0x71, 0x03, 0x0A, 0xFF, 0xF9, 0x0A, 0x03, 0x76, 0x08, 0xE0, 0x37, 0x09,
  0xFF, 0xFD, 0x09, 0x01, 0x74, 0x08, 0xE0, 0x35, 0x03, 0x0D, 0xFF, 0xFF, 0x0E, 0x04, 0x73, 0x08,
  0xE0, 0x24, 0x05, 0x0E, 0xFD, 0x80, 0x0D, 0x0E, 0xFF, 0x06, 0x72, 0x08, 0xE0, 0x23, 0x06, 0xF9,
  0x83, 0xD9, 0x63, 0x16, 0x83, 0x13, 0x6A, 0xEF, 0xB0, 0x87, 0x10, 0x8E, 0x01, 0x20, 0x5F, 0x09,
  0x03, 0x77, 0x20, 0x60, 0xDF, 0xA0, 0x77, 0x08, 0xE8, 0x11, 0x03, 0xE0, 0xA0, 0x27, 0x76, 0x06,
  0x0E, 0xF9, 0x05, 0x60, 0x8E, 0x20, 0xDC, 0x0E, 0x06, 0x77, 0x72, 0x02, 0x0C, 0xF0, 0xE0, 0x25,
  0x08, 0xE1, 0x08, 0xC0, 0xE0, 0x37, 0x77, 0x40, 0x10, 0xCF, 0x0C, 0x50, 0x8D, 0x0D, 0x02, 0xD0,
  0x37, 0x77, 0x60, 0x10, 0xDF, 0x05, 0x40, 0x8D, 0x0D, 0x0B, 0xC0, 0x67, 0x77, 0x71, 0x02, 0x0E,
  0xE0, 0xD4, 0x08, 0xFB, 0x0B, 0x77, 0x77, 0x30, 0x6F, 0x06, 0x30, 0x8F, 0xB0, 0x27, 0x77, 0x74,
  0x0C, 0xE0, 0xD3, 0x08, 0xFA, 0x09, 0x77, 0x77, 0x50, 0x4F, 0x04, 0x20, 0x8F, 0xA0, 0x17, 0x77,
  0x76, 0x0C, 0xE0, 0x92, 0x08, 0xF9, 0x0A, 0x77, 0x77, 0x70, 0x6E, 0x0E, 0x20, 0x8F, 0x90, 0x58,
  0x0C, 0x00, 0xF8, 0x14, 0x08, 0xF9, 0x80, 0xC1, 0x00, 0xBE, 0x81, 0x80, 0x8F, 0x0B, 0x80, 0xC1,
  0x00, 0x6E, 0x81, 0xB0, 0x8F, 0x07, 0x80, 0xC1, 0x00, 0x2F, 0x10, 0x8F, 0x03, 0x80, 0xC2, 0x00,
  0xEE, 0x02, 0x08, 0xF8, 0x0C, 0x30, 0x0C, 0xE0, 0x50, 0x8E, 0x0D, 0x80, 0xC3, 0x00, 0x9E, 0x07,
  0x08, 0xE0, 0xB8, 0x0C, 0x30, 0x07, 0xE0, 0x90, 0x8E, 0x09, 0x80, 0xC3, 0x00, 0x5E, 0x0B, 0x08,
  0xE0, 0x88, 0x0C, 0x30, 0x04, 0xE0, 0xC0, 0x8E, 0x07, 0x80, 0xC3, 0x00, 0x3E, 0x0D, 0x08, 0xE0,
  0x58, 0x0C, 0x30, 0x02, 0xE0, 0xE0, 0x8E, 0x05, 0x80, 0xC3, 0x00, 0x1F, 0x08, 0xE0, 0x48, 0x0C,
  0x30, 0x01, 0xF0, 0x8E, 0x04, 0x80, 0xC4, 0x0F, 0x08, 0xE0, 0x48, 0x0C, 0x30, 0x01, 0xF0, 0x8E,
  0x04, 0x80, 0xC3, 0x00, 0x1F, 0x08, 0xE0, 0x48, 0x0C, 0x30, 0x01, 0xF0, 0x8E, 0x05, 0x80, 0xC3,
  0x00, 0x2E, 0x0E, 0x08, 0xE0, 0x68, 0x0C, 0x30, 0x03, 0xE0, 0xD0, 0x8E, 0x07, 0x80, 0xC3, 0x00,
  0x5E, 0x0B, 0x08, 0xE0, 0x88, 0x0C, 0x30, 0x06, 0xE0, 0xA0, 0x8E, 0x0A, 0x80, 0xC3, 0x00, 0x9E,
  0x00, 0x8E, 0x0C, 0x80, 0xC3, 0x00, 0xBE, 0x06, 0x08, 0xE0, 0xE8, 0x0C, 0x30, 0x0E, 0xE0, 0x30,
  0x8F, 0x01, 0x80, 0xC1, 0x00, 0x1F, 0x10, 0x8F, 0x04, 0x80, 0xC1, 0x00, 0x5E, 0x81, 0xC0, 0x8F,
  0x07, 0x80, 0xC1, 0x00, 0x9E, 0x81, 0x80, 0x8F, 0x0C, 0x80, 0xC1, 0x00, 0xEE, 0x81, 0x50, 0x8F,
  0x90, 0x17, 0x77, 0x77, 0x04, 0xE0, 0xE2, 0x08, 0xF9, 0x06, 0x77, 0x77, 0x70, 0xAE, 0x0A, 0x20,
  0x8F, 0x90, 0xC7, 0x77, 0x76, 0x02, 0xF0, 0x52, 0x08, 0xFA, 0x03, 0x77, 0x77, 0x50, 0x9E, 0x0D,
  0x30, 0x8F, 0xA0, 0xA7, 0x77, 0x74, 0x02, 0xF0, 0x73, 0x08, 0xFB, 0x04, 0x77, 0x77, 0x30, 0xCE,
  0x0E, 0x01, 0x30, 0x8F, 0xB0, 0xD7, 0x77, 0x72, 0x08, 0xF0, 0x74, 0x08, 0xD0, 0xE0, 0xCC, 0x09,
  0x77, 0x77, 0x05, 0xF0, 0xD5, 0x08, 0xD0, 0xA0, 0x2D, 0x08, 0x77, 0x75, 0x05, 0xF9, 0x04, 0x50,
  0x8D, 0x81, 0x90, 0x8D, 0x09, 0x77, 0x73, 0x07, 0xF9, 0x09, 0x60, 0x8D, 0x07, 0x20, 0xCD, 0x0C,
  0x02, 0x77, 0x60, 0x20, 0xBF, 0x90, 0xC7, 0x08, 0xD0, 0x52, 0x02, 0x0E, 0xE0, 0xA0, 0x37, 0x72,
  0x02, 0x09, 0xFA, 0x0D, 0x01, 0x70, 0x8D, 0x03, 0x30, 0x30, 0xEF, 0x82, 0xD8, 0x41, 0x72, 0x81,
  0x37, 0xCF, 0xB0, 0xD0, 0x27, 0x10, 0x8D, 0x01, 0x40, 0x30, 0xEF, 0xB0, 0xE0, 0xC8, 0x01, 0xB0,
  0xEF, 0xE0, 0xD0, 0x17, 0x20, 0x8D, 0x60, 0x20, 0xCF, 0xFF, 0xF9, 0x0A, 0x01, 0x73, 0x08, 0xC0,
  0xD7, 0x10, 0x8F, 0xFF, 0xD0, 0xE0, 0x57, 0x50, 0x8C, 0x0B, 0x72, 0x03, 0x0B, 0xFF, 0xF9, 0x0E,
  0x07, 0x77, 0x08, 0xC0, 0xA7, 0x48, 0x13, 0xAE, 0xFF, 0xB0, 0xB0, 0x58, 0x0C, 0x00, 0x82, 0x48,
  0xBD, 0xF9, 0x83, 0xDB, 0x85, 0x18, 0x0C, 0x70, 0x84, 0x11, 0x32, 0x11, 0x77, 0x73,
  // "c" (U+0063)
  0x77, 0x72, 0x84, 0x36, 0x9B, 0xDE, 0xD8, 0x5E, 0xDB, 0x97, 0x41, 0x77, 0x76, 0x81, 0x5A, 0xEF,
  0xFC, 0x81, 0xD9, 0x57, 0x77, 0x03, 0x09, 0xFF, 0xFC, 0x81, 0xEA, 0x37, 0x72, 0x02, 0x0B, 0xFF,
  0xFF, 0xA0, 0x27, 0x70, 0x9F, 0xFF, 0xFB, 0x0C, 0x76, 0x03, 0x0D, 0xFF, 0xFF, 0xC0, 0x77, 0x50,
  0x6F, 0xD8, 0x95, 0xEA, 0x75, 0x31, 0x11, 0x12, 0x35, 0x7A, 0xCF, 0x02, 0x74, 0x08, 0xFB, 0x81,
  0xD8, 0x27, 0x71, 0x82, 0x15, 0x9E, 0xA0, 0xD7, 0x40, 0x8F, 0xA0, 0xD0, 0x57, 0x77, 0x18, 0x15,
  0xB8, 0x73, 0x07, 0xFA, 0x07, 0x80, 0xC0, 0x00, 0x4F, 0x90, 0xD0, 0x28, 0x0C, 0x00, 0x01, 0x0E,
  0xF0, 0xC0, 0x18, 0x0C, 0x10, 0x0A, 0xF0, 0xC0, 0x18, 0x0C, 0x10, 0x05, 0xF0, 0xD0, 0x18, 0x0C,
  0x20, 0x0D, 0xF0, 0x38, 0x0C, 0x20, 0x06, 0xF0, 0x78, 0x0C, 0x30, 0x0D, 0xE0, 0xD8, 0x0C, 0x30,
  0x05, 0xF0, 0x48, 0x0C, 0x30, 0x0B, 0xE0, 0xC8, 0x0C, 0x30, 0x01, 0xF0, 0x58, 0x0C, 0x30, 0x06,
  0xE0, 0xE8, 0x0C, 0x40, 0x0A, 0xE0, 0x98, 0x0C, 0x40, 0x0E, 0xE0, 0x58, 0x0C, 0x30, 0x02, 0xF0,
  0x18, 0x0C, 0x30, 0x05, 0xE0, 0xC8, 0x0C, 0x40, 0x08, 0xE0, 0x98, 0x0C, 0x40, 0x0A, 0xE0, 0x78,
  0x0C, 0x40, 0x0C, 0xE0, 0x48, 0x0C, 0x40, 0x0E, 0xE0, 0x28, 0x0C, 0x40, 0xF0, 0x18, 0x0C, 0x30,
  0x01, 0xF8, 0x0C, 0x40, 0x01, 0xF8, 0x0C, 0x40, 0x02, 0xE0, 0xE8, 0x0C, 0x40, 0x02, 0xE0, 0xE8,
  0x0C, 0x40, 0x01, 0xE0, 0xE8, 0x0C, 0x40, 0x01, 0xF8, 0x0C, 0x50, 0xF8, 0x0C, 0x50, 0xF0, 0x18,
  0x0C, 0x40, 0x0E, 0xE0, 0x38, 0x0C, 0x40, 0x0C, 0xE0, 0x58, 0x0C, 0x40, 0x0B, 0xE0, 0x78, 0x0C,
  0x40, 0x08, 0xE0, 0xA8, 0x0C, 0x40, 0x05, 0xE0, 0xD8, 0x0C, 0x40, 0x03, 0xF0, 0x18, 0x0C, 0x40,
  0x0E, 0xE0, 0x58, 0x0C, 0x40, 0x0B, 0xE0, 0xA8, 0x0C, 0x40, 0x07, 0xF8, 0x0C, 0x40, 0x02, 0xF0,
  0x68, 0x0C, 0x40, 0x0C, 0xE0, 0xD8, 0x0C, 0x40, 0x06, 0xF0, 0x58, 0x0C, 0x30, 0x01, 0x0E, 0xE0,
  0xD8, 0x0C, 0x40, 0x08, 0xF0, 0x78, 0x0C, 0x30, 0x01, 0xF9, 0x02, 0x80, 0xC3, 0x00, 0x7F, 0x0D,
  0x01, 0x80, 0xC3, 0x00, 0xDF, 0x0B, 0x80, 0xC3, 0x00, 0x3F, 0x90, 0xB8, 0x0C, 0x30, 0x06, 0xF9,
  0x0D, 0x03, 0x77, 0x77, 0x01, 0x72, 0x09, 0xFA, 0x08, 0x01, 0x77, 0x72, 0x82, 0x16, 0xC8, 0x73,
  0x0A, 0xFA, 0x81, 0xE8, 0x27, 0x74, 0x81, 0x26, 0xBB, 0x08, 0x74, 0x09, 0xFC, 0x82, 0xC8, 0x42,
  0x72, 0x83, 0x24, 0x7A, 0xDE, 0x08, 0x75, 0x07, 0xFF, 0x98, 0x5D, 0xDC, 0xCD, 0xDE, 0xFD, 0x08,
  0x76, 0x03, 0x0D, 0xFF, 0xFF, 0xC0, 0x87, 0x71, 0x07, 0x0E, 0xFF, 0xFF, 0xA0, 0x87, 0x72, 0x81,
  0x17, 0xEF, 0xFF, 0xD0, 0xB0, 0x57, 0x76, 0x81, 0x5A, 0xEF, 0xFE, 0x81, 0xB7, 0x17, 0x77, 0x48,
  0x33, 0x6A, 0xCE, 0xFA, 0x83, 0xEC, 0xA7, 0x47, 0x77, 0x77, 0x82, 0x11, 0x23, 0x0F, 0x17, 0x70,
  // "d" (U+0064)
  0x80, 0xD4, 0x00, 0x18, 0x02, 0x30, 0x18, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0,
  0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68,
  0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D,
  0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40,
  0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06,
  0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0,
  0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68,
  0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D,
  0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x67, 0x76, 0x84, 0x15, 0x8A, 0xDE, 0xC8, 0x4E,
  0xDB, 0x95, 0x27, 0x50, 0x6E, 0x06, 0x77, 0x38, 0x12, 0x8D, 0xFF, 0xA8, 0x1C, 0x71, 0x72, 0x05,
  0xE0, 0x67, 0x71, 0x04, 0x0B, 0xFF, 0xF9, 0x08, 0x01, 0x70, 0x5E, 0x06, 0x76, 0x02, 0x0B, 0xFF,
  0xFC, 0x0E, 0x04, 0x60, 0x5E, 0x06, 0x75, 0x07, 0xFF, 0xFF, 0x90, 0x85, 0x04, 0xE0, 0x67, 0x40,
  0xAF, 0xF0, 0xE8, 0x00, 0xDF, 0xD0, 0xA4, 0x03, 0xE0, 0x67, 0x20, 0x10, 0xCF, 0xB8, 0x3E, 0xA6,
  0x31, 0x68, 0x21, 0x47, 0xBF, 0x90, 0xB3, 0x03, 0xE0, 0x67, 0x10, 0x10, 0xCF, 0xA0, 0xC0, 0x57,
  0x71, 0x81, 0x16, 0xDE, 0x09, 0x20, 0x2E, 0x06, 0x71, 0x0B, 0xF9, 0x0D, 0x05, 0x77, 0x60, 0x7E,
  0x81, 0x60, 0x1E, 0x06, 0x70, 0x9F, 0x90, 0xA0, 0x17, 0x77, 0x10, 0x30, 0xDC, 0x0E, 0x02, 0x1E,
  0x06, 0x60, 0x5F, 0x90, 0x87, 0x77, 0x40, 0x10, 0xDC, 0x0B, 0x1E, 0x06, 0x60, 0xEF, 0x08, 0x77,
  0x76, 0x01, 0x0E, 0xC0, 0x30, 0xED, 0x06, 0x50, 0x8F, 0x0A, 0x77, 0x77, 0x10, 0x3C, 0x0D, 0xE0,
  0x64, 0x02, 0xF0, 0xD7, 0x77, 0x73, 0x09, 0xFB, 0x06, 0x40, 0x8F, 0x04, 0x77, 0x77, 0x30, 0x10,
  0xEF, 0xA0, 0x63, 0x01, 0x0E, 0xE0, 0xB7, 0x77, 0x75, 0x07, 0xFA, 0x06, 0x30, 0x6F, 0x03, 0x77,
  0x77, 0x50, 0x10, 0xEF, 0x90, 0x63, 0x0B, 0xE0, 0xB7, 0x77, 0x77, 0x0A, 0xF9, 0x06, 0x20, 0x1F,
  0x05, 0x77, 0x77, 0x70, 0x4F, 0x90, 0x62, 0x06, 0xE0, 0xE8, 0x0C, 0x10, 0x0E, 0xF0, 0x62, 0x0A,
  0xE0, 0xA8, 0x0C, 0x10, 0x0A, 0xF0, 0x62, 0x0D, 0xE0, 0x58, 0x0C, 0x10, 0x06, 0xF8, 0x16, 0x01,
  0xF0, 0x18, 0x0C, 0x10, 0x03, 0xF8, 0x16, 0x04, 0xE0, 0xD8, 0x0C, 0x30, 0xF8, 0x16, 0x07, 0xE0,
  0xA8, 0x0C, 0x30, 0x0D, 0xE8, 0x16, 0x09, 0xE0, 0x88, 0x0C, 0x30, 0x0B, 0xE8, 0x16, 0x0B, 0xE0,
  0x68, 0x0C, 0x30, 0x09, 0xE8, 0x16, 0x0C, 0xE0, 0x38, 0x0C, 0x30, 0x08, 0xE8, 0x16, 0x0E, 0xE0,
  0x28, 0x0C, 0x30, 0x07, 0xE0, 0x61, 0xF0, 0x18, 0x0C, 0x30, 0x05, 0xE0, 0x60, 0x1F, 0x80, 0xC4,
  0x00, 0x5E, 0x06, 0x01, 0xF8, 0x0C, 0x40, 0x04, 0xE0, 0x60, 0x1E, 0x0E, 0x80, 0xC4, 0x00, 0x4E,
  0x06, 0x02, 0xE0, 0xE8, 0x0C, 0x40, 0x04, 0xE0, 0x60, 0x2E, 0x0E, 0x80, 0xC4, 0x00, 0x4E, 0x06,
  0x01, 0xE0, 0xE8, 0x0C, 0x40, 0x04, 0xE0, 0x60, 0x1F, 0x80, 0xC4, 0x00, 0x5E, 0x06, 0x1F, 0x80,
  0xC4, 0x00, 0x5E, 0x06, 0x1F, 0x01, 0x80, 0xC3, 0x00, 0x6E, 0x81, 0x60, 0xDE, 0x03, 0x80, 0xC3,
  0x00, 0x8E, 0x81, 0x60, 0xCE, 0x04, 0x80, 0xC3, 0x00, 0x9E, 0x81, 0x60, 0xAE, 0x07, 0x80, 0xC3,
  0x00, 0xBE, 0x81, 0x60, 0x8E, 0x09, 0x80, 0xC3, 0x00, 0xDE, 0x81, 0x60, 0x5E, 0x0C, 0x80, 0xC2,
  0x00, 0x1F, 0x81, 0x60, 0x3F, 0x80, 0xC2, 0x00, 0x4F, 0x06, 0x20, 0xEE, 0x03, 0x80, 0xC1, 0x00,
  0x7F, 0x06, 0x20, 0xBE, 0x08, 0x80, 0xC1, 0x00, 0xBF, 0x06, 0x20, 0x7E, 0x0D, 0x80, 0xC0, 0x00,
  0x1F, 0x90, 0x62, 0x03, 0xF0, 0x37, 0x77, 0x77, 0x06, 0xF9, 0x06, 0x30, 0xDE, 0x09, 0x77, 0x77,
  0x70, 0xCF, 0x90, 0x63, 0x08, 0xF0, 0x17, 0x77, 0x75, 0x03, 0xFA, 0x06, 0x30, 0x2F, 0x09, 0x77,
  0x77, 0x50, 0xBF, 0xA0, 0x64, 0x0A, 0xF0, 0x37, 0x77, 0x73, 0x04, 0xFB, 0x06, 0x40, 0x3F, 0x0D,
  0x77, 0x77, 0x30, 0xDF, 0xB0, 0x65, 0x09, 0xF0, 0xB7, 0x77, 0x71, 0x0A, 0xC0, 0x4E, 0x06, 0x50,
  0x10, 0xEF, 0x0A, 0x77, 0x76, 0x09, 0xC8, 0x1A, 0x0E, 0xD0, 0x66, 0x05, 0xF9, 0x0B, 0x01, 0x77,
  0x73, 0x0A, 0xC8, 0x2E, 0x20, 0xCD, 0x06, 0x70, 0x9F, 0x90, 0xE0, 0x57, 0x77, 0x03, 0x0D, 0xD0,
  0x52, 0x0B, 0xD0, 0x67, 0x10, 0xBF, 0xA0, 0xC0, 0x47, 0x73, 0x04, 0x0B, 0xE0, 0x83, 0x0A, 0xD0,
  0x67, 0x20, 0xCF, 0xB8, 0x2E, 0x95, 0x17, 0x28, 0x22, 0x59, 0xDF, 0x09, 0x40, 0x8D, 0x06, 0x73,
  0x0A, 0xFF, 0x0C, 0x80, 0x1B, 0x0D, 0xFC, 0x09, 0x50, 0x7D, 0x06, 0x74, 0x07, 0xFF, 0xFF, 0xA0,
  0x66, 0x05, 0xD0, 0x67, 0x50, 0x30, 0xCF, 0xFF, 0xD0, 0xD0, 0x37, 0x04, 0xD0, 0x67, 0x70, 0x50,
  0xCF, 0xFF, 0xA0, 0x87, 0x20, 0x3D, 0x06, 0x77, 0x28, 0x14, 0x9E, 0xFF, 0xB8, 0x1D, 0x71, 0x73,
  0x01, 0xD0, 0x67, 0x75, 0x83, 0x37, 0xAC, 0xEF, 0x98, 0x2C, 0xA6, 0x28, 0x0D, 0x00, 0x0F, 0x18,
  0x23, 0x21, 0x17, 0x77, 0x40,
  // "e" (U+0065)
  0x77, 0x78, 0x32, 0x69, 0xBD, 0xD8, 0x3E, 0xCA, 0x74, 0x80, 0xC0, 0x08, 0x13, 0x9E, 0xFF, 0xA0,
  0xB0, 0x57, 0x77, 0x73, 0x05, 0x0C, 0xFF, 0xF0, 0xE0, 0x67, 0x77, 0x60, 0x30, 0xCF, 0xFF, 0xC0,
  0xD0, 0x37, 0x77, 0x30, 0x9F, 0xFF, 0xF9, 0x07, 0x77, 0x70, 0x10, 0xCF, 0xD8, 0x5E, 0xCB, 0xBB,
  0xBE, 0xFD, 0x0A, 0x77, 0x50, 0x20, 0xDF, 0xA8, 0x2E, 0x95, 0x17, 0x18, 0x13, 0x7D, 0xFA, 0x0B,
  0x77, 0x30, 0x20, 0xEF, 0x90, 0xC0, 0x47, 0x71, 0x04, 0x0C, 0xF9, 0x0A, 0x77, 0x10, 0x10, 0xEF,
  0x0D, 0x05, 0x77, 0x50, 0x60, 0xEF, 0x07, 0x77, 0x0C, 0xF0, 0xB0, 0x17, 0x77, 0x03, 0x0E, 0xF0,
  0x37, 0x50, 0x9F, 0x09, 0x77, 0x73, 0x02, 0x0E, 0xE0, 0xD7, 0x40, 0x4F, 0x08, 0x77, 0x75, 0x04,
  0xF0, 0x77, 0x30, 0xDE, 0x0A, 0x77, 0x77, 0x09, 0xE0, 0xE0, 0x17, 0x10, 0x7E, 0x0D, 0x77, 0x77,
  0x10, 0x10, 0xEE, 0x07, 0x70, 0x10, 0xEE, 0x03, 0x77, 0x77, 0x20, 0x7E, 0x0D, 0x70, 0x8E, 0x0A,
  0x77, 0x77, 0x30, 0x10, 0xEE, 0x04, 0x60, 0xEE, 0x02, 0x77, 0x77, 0x40, 0x9E, 0x09, 0x50, 0x5E,
  0x0A, 0x77, 0x77, 0x50, 0x4E, 0x0E, 0x50, 0xBE, 0x03, 0x77, 0x77, 0x60, 0xEE, 0x03, 0x30, 0x1E,
  0x0D, 0x77, 0x77, 0x70, 0xAE, 0x07, 0x30, 0x6E, 0x08, 0x77, 0x77, 0x70, 0x7E, 0x0A, 0x30, 0xAE,
  0x03, 0x77, 0x77, 0x70, 0x3E, 0x0D, 0x30, 0xED, 0x0E, 0x80, 0xC0, 0x00, 0x1F, 0x20, 0x2E, 0x0B,
  0x80, 0xC1, 0x00, 0xEE, 0x81, 0x20, 0x5E, 0x08, 0x80, 0xC1, 0x00, 0xDE, 0x81, 0x40, 0x8E, 0x06,
  0x80, 0xC1, 0x00, 0xCE, 0x81, 0x50, 0xAE, 0x03, 0x80, 0xC1, 0x00, 0xBE, 0x81, 0x60, 0xCE, 0x02,
  0x80, 0xC1, 0x00, 0xAE, 0x81, 0x70, 0xEE, 0x80, 0xC2, 0xB0, 0xEE, 0x07, 0x18, 0x0E, 0x0F, 0x07,
  0x18, 0x0E, 0x0F, 0x07, 0x01, 0x80, 0xE0, 0xF0, 0x70, 0x28, 0x0E, 0x0F, 0x07, 0x02, 0x80, 0xE0,
  0xF0, 0x70, 0x1E, 0x0E, 0x80, 0xD2, 0x00, 0x1E, 0x0E, 0x80, 0xD3, 0x0F, 0x80, 0xD3, 0x0F, 0x80,
  0xD3, 0x00, 0xEE, 0x02, 0x80, 0xD2, 0x00, 0xCE, 0x03, 0x80, 0xD2, 0x00, 0xAE, 0x05, 0x80, 0xD2,
  0x00, 0x8E, 0x08, 0x80, 0xD2, 0x00, 0x5E, 0x0B, 0x80, 0xD2, 0x00, 0x2E, 0x0E, 0x80, 0xD3, 0x00,
  0xEE, 0x03, 0x80, 0xD2, 0x00, 0xAE, 0x07, 0x80, 0xD2, 0x00, 0x6E, 0x0D, 0x80, 0xD2, 0x00, 0x1F,
  0x03, 0x80, 0xD2, 0x00, 0xBE, 0x0A, 0x80, 0xD2, 0x00, 0x5F, 0x02, 0x80, 0xD2, 0x00, 0xDE, 0x0B,
  0x80, 0xD2, 0x00, 0x6F, 0x05, 0x80, 0xD2, 0x00, 0xDE, 0x0E, 0x02, 0x80, 0xD1, 0x00, 0x5F, 0x0C,
  0x01, 0x80, 0xD1, 0x00, 0xAF, 0x0C, 0x80, 0xD1, 0x00, 0x10, 0xEF, 0x0C, 0x02, 0x80, 0xD0, 0x00,
  0x3F, 0x90, 0xE0, 0x57, 0x77, 0x72, 0x81, 0x18, 0xC7, 0x40, 0x6F, 0xA0, 0xB0, 0x27, 0x77, 0x50,
  0x50, 0xBA, 0x0D, 0x75, 0x07, 0xFB, 0x0B, 0x04, 0x77, 0x68, 0x21, 0x5A, 0xEC, 0x0D, 0x76, 0x06,
  0xFC, 0x83, 0xEA, 0x63, 0x17, 0x38, 0x32, 0x46, 0x9C, 0xF9, 0x0D, 0x77, 0x04, 0x0E, 0xFF, 0x98,
  0x2D, 0xDC, 0xC0, 0xFD, 0xFF, 0x90, 0xD7, 0x71, 0x02, 0x0B, 0x80, 0xC0, 0xF0, 0xD7, 0x73, 0x05,
  0x0D, 0xFF, 0xFF, 0xD0, 0xA0, 0x47, 0x75, 0x05, 0x0D, 0xFF, 0xFF, 0x81, 0xD7, 0x17, 0x77, 0x28,
  0x13, 0x8D, 0xFF, 0xF8, 0x2E, 0xB7, 0x27, 0x77, 0x71, 0x83, 0x25, 0x9B, 0xDF, 0xB8, 0x4E, 0xCB,
  0x86, 0x38, 0x0C, 0x30, 0x0F, 0x10, 0x30, 0x20, 0xF1, 0x77, 0x50,
  // "f" (U+0066)
  0x77, 0x74, 0x82, 0x26, 0x89, 0x80, 0x1B, 0x82, 0xA8, 0x63, 0x77, 0x76, 0x81, 0x49, 0xEF, 0xF8,
  0x1C, 0x94, 0x77, 0x70, 0x40, 0xCF, 0xFE, 0x06, 0x77, 0x40, 0x10, 0xAF, 0xFF, 0x90, 0x27, 0x73,
  0x02, 0x0D, 0xFF, 0xF9, 0x0D, 0x77, 0x30, 0x10, 0xDF, 0xFF, 0xA0, 0x97, 0x73, 0x0C, 0xFA, 0x89,
  0x2B, 0x74, 0x21, 0x11, 0x24, 0x69, 0xCB, 0x05, 0x77, 0x20, 0x7F, 0x90, 0xA0, 0x27, 0x68, 0x15,
  0x91, 0x77, 0x10, 0x10, 0xEE, 0x0E, 0x05, 0x77, 0x77, 0x50, 0x8F, 0x04, 0x77, 0x77, 0x60, 0xEE,
  0x08, 0x77, 0x77, 0x60, 0x4E, 0x0E, 0x77, 0x77, 0x70, 0x9E, 0x08, 0x77, 0x77, 0x70, 0xDE, 0x02,
  0x77, 0x77, 0x60, 0x1E, 0x0D, 0x77, 0x77, 0x70, 0x3E, 0x0A, 0x77, 0x77, 0x70, 0x5E, 0x07, 0x77,
  0x77, 0x70, 0x7E, 0x05, 0x77, 0x77, 0x70, 0x8E, 0x04, 0x77, 0x77, 0x70, 0x9E, 0x03, 0x77, 0x77,
  0x70, 0xAE, 0x02, 0x77, 0x77, 0x70, 0xAE, 0x02, 0x77, 0x77, 0x70, 0xAE, 0x02, 0x77, 0x77, 0x70,
  0xAE, 0x02, 0x77, 0x77, 0x70, 0xAE, 0x02, 0x77, 0x77, 0x70, 0xAE, 0x02, 0x77, 0x77, 0x70, 0xAE,
  0x02, 0x77, 0x77, 0x70, 0xAE, 0x02, 0x77, 0x77, 0x18, 0x41, 0x36, 0x9B, 0xEF, 0x80, 0x93, 0xD0,
  0x57, 0x28, 0x33, 0x58, 0xBE, 0xFF, 0xFF, 0x06, 0x71, 0x06, 0xFF, 0xFF, 0xD0, 0x67, 0x10, 0x6F,
  0xFF, 0xFD, 0x06, 0x71, 0x06, 0xFF, 0xFF, 0xD0, 0x67, 0x10, 0x48, 0x07, 0x90, 0xDE, 0x0A, 0x80,
  0x92, 0x90, 0x37, 0x76, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0,
  0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27,
  0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77,
  0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77,
  0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A,
  0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0,
  0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27,
  0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77,
  0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77,
  0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A,
  0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0,
  0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27,
  0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77,
  0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77,
  0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A,
  0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0,
  0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27,
  0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x27, 0x77,
  0x77, 0x0A, 0xE0, 0x27, 0x77, 0x20,
  // "g" (U+0067)
  0x77, 0x68, 0x43, 0x69, 0xBD, 0xEC, 0x84, 0xED, 0xB8, 0x51, 0x80, 0xC1, 0x08, 0x14, 0x9E, 0xFF,
  0xA8, 0x1D, 0x71, 0x73, 0x03, 0x80, 0x1D, 0x04, 0x77, 0x10, 0x60, 0xDF, 0xFF, 0x90, 0x90, 0x17,
  0x10, 0x5D, 0x04, 0x76, 0x04, 0x0D, 0xFF, 0xFC, 0x0E, 0x06, 0x70, 0x7D, 0x04, 0x75, 0x09, 0xFF,
  0xFF, 0x90, 0xB0, 0x15, 0x08, 0xD0, 0x47, 0x30, 0x10, 0xCF, 0xFF, 0xFB, 0x0D, 0x02, 0x40, 0xAD,
  0x04, 0x72, 0x02, 0x0D, 0xFB, 0x83, 0xEB, 0x74, 0x25, 0x83, 0x13, 0x58, 0xCF, 0x90, 0xE0, 0x23,
  0x0C, 0xD0, 0x47, 0x10, 0x10, 0xDF, 0xA0, 0xC0, 0x67, 0x71, 0x81, 0x16, 0xDE, 0x0D, 0x01, 0x20,
  0xED, 0x04, 0x71, 0x0C, 0xF9, 0x0D, 0x05, 0x77, 0x60, 0x50, 0xED, 0x0B, 0x2E, 0x04, 0x70, 0x9F,
  0x90, 0xA7, 0x77, 0x20, 0x10, 0xBD, 0x07, 0x02, 0xE0, 0x46, 0x04, 0xF9, 0x07, 0x77, 0x75, 0x0A,
  0xD0, 0x6E, 0x04, 0x60, 0xDF, 0x07, 0x77, 0x77, 0x0B, 0xFC, 0x04, 0x50, 0x7F, 0x0A, 0x77, 0x77,
  0x10, 0x10, 0xDF, 0xB0, 0x44, 0x01, 0x0E, 0xE0, 0xD7, 0x77, 0x73, 0x05, 0xFB, 0x04, 0x40, 0x7F,
  0x04, 0x77, 0x77, 0x40, 0xBF, 0xA0, 0x44, 0x0E, 0xE0, 0xA7, 0x77, 0x75, 0x04, 0xFA, 0x04, 0x30,
  0x5F, 0x02, 0x77, 0x77, 0x60, 0xCF, 0x90, 0x43, 0x0B, 0xE0, 0xB7, 0x77, 0x77, 0x07, 0xF9, 0x04,
  0x20, 0x1F, 0x05, 0x77, 0x77, 0x70, 0x1F, 0x90, 0x42, 0x05, 0xE0, 0xE8, 0x0C, 0x10, 0x0C, 0xF0,
  0x42, 0x09, 0xE0, 0x98, 0x0C, 0x10, 0x08, 0xF0, 0x42, 0x0D, 0xE0, 0x58, 0x0C, 0x10, 0x05, 0xF8,
  0x14, 0x01, 0xF0, 0x18, 0x0C, 0x10, 0x02, 0xF8, 0x14, 0x04, 0xE0, 0xD8, 0x0C, 0x30, 0xF8, 0x14,
  0x07, 0xE0, 0xA8, 0x0C, 0x30, 0x0D, 0xE8, 0x14, 0x09, 0xE0, 0x88, 0x0C, 0x30, 0x0B, 0xE8, 0x14,
  0x0B, 0xE0, 0x58, 0x0C, 0x30, 0x09, 0xE8, 0x14, 0x0D, 0xE0, 0x38, 0x0C, 0x30, 0x08, 0xE8, 0x14,
  0x0E, 0xE0, 0x28, 0x0C, 0x30, 0x07, 0xE0, 0x41, 0xF0, 0x18, 0x0C, 0x30, 0x07, 0xE0, 0x40, 0x1F,
  0x80, 0xC4, 0x00, 0x6E, 0x04, 0x01, 0xF8, 0x0C, 0x40, 0x06, 0xE0, 0x40, 0x1E, 0x0E, 0x80, 0xC4,
  0x00, 0x6E, 0x04, 0x02, 0xE0, 0xE8, 0x0C, 0x40, 0x06, 0xE0, 0x40, 0x2E, 0x0E, 0x80, 0xC4, 0x00,
  0x6E, 0x04, 0x01, 0xE0, 0xE8, 0x0C, 0x40, 0x06, 0xE0, 0x40, 0x1F, 0x80, 0xC4, 0x00, 0x6E, 0x04,
  0x1F, 0x80, 0xC4, 0x00, 0x7E, 0x81, 0x40, 0xEE, 0x02, 0x80, 0xC3, 0x00, 0x7E, 0x81, 0x40, 0xDE,
  0x03, 0x80, 0xC3, 0x00, 0x9E, 0x81, 0x40, 0xBE, 0x05, 0x80, 0xC3, 0x00, 0xAE, 0x81, 0x40, 0xAE,
  0x07, 0x80, 0xC3, 0x00, 0xCE, 0x81, 0x40, 0x7E, 0x09, 0x80, 0xC3, 0x00, 0xEE, 0x81, 0x40, 0x5E,
  0x0C, 0x80, 0xC2, 0x00, 0x1F, 0x81, 0x40, 0x2F, 0x80, 0xC2, 0x00, 0x4F, 0x04, 0x20, 0xEE, 0x04,
  0x80, 0xC1, 0x00, 0x8F, 0x04, 0x20, 0xAE, 0x09, 0x80, 0xC1, 0x00, 0xCF, 0x04, 0x20, 0x6E, 0x0D,
  0x80, 0xC0, 0x00, 0x1F, 0x90, 0x42, 0x01, 0xF0, 0x47, 0x77, 0x77, 0x06, 0xF9, 0x04, 0x30, 0xCE,
  0x0A, 0x77, 0x77, 0x70, 0xBF, 0x90, 0x43, 0x06, 0xF0, 0x27, 0x77, 0x75, 0x03, 0xFA, 0x04, 0x40,
  0xEE, 0x0A, 0x77, 0x77, 0x50, 0xBF, 0xA0, 0x44, 0x08, 0xF0, 0x47, 0x77, 0x73, 0x04, 0xFB, 0x04,
  0x40, 0x10, 0xEE, 0x0D, 0x01, 0x77, 0x77, 0x10, 0x10, 0xEB, 0x0D, 0xE0, 0x45, 0x07, 0xF0, 0xB7,
  0x77, 0x71, 0x0B, 0xC0, 0x5E, 0x04, 0x60, 0xDF, 0x0A, 0x77, 0x76, 0x0A, 0xC0, 0x90, 0x3E, 0x04,
  0x60, 0x3F, 0x90, 0xB7, 0x77, 0x30, 0x10, 0xBC, 0x81, 0xE1, 0x4E, 0x04, 0x70, 0x7F, 0x90, 0xD0,
  0x37, 0x77, 0x04, 0x0D, 0xD8, 0x16, 0x05, 0xE0, 0x47, 0x10, 0x9F, 0xA0, 0xA0, 0x27, 0x73, 0x04,
  0x0B, 0xE0, 0xA2, 0x06, 0xE0, 0x47, 0x20, 0xAF, 0xB8, 0x1C, 0x72, 0x74, 0x81, 0x48, 0xDF, 0x0B,
  0x30, 0x6E, 0x04, 0x73, 0x09, 0xFD, 0x89, 0x0E, 0xCA, 0x99, 0x99, 0xAB, 0xDF, 0xB0, 0xB4, 0x06,
  0xE0, 0x47, 0x40, 0x6F, 0xFF, 0xFA, 0x09, 0x50, 0x7E, 0x04, 0x75, 0x02, 0x0C, 0xFF, 0xFD, 0x0D,
  0x05, 0x60, 0x7E, 0x04, 0x77, 0x05, 0x0C, 0xFF, 0xF9, 0x0E, 0x07, 0x71, 0x07, 0xE0, 0x47, 0x72,
  0x81, 0x49, 0xEF, 0xFB, 0x0B, 0x06, 0x73, 0x07, 0xE0, 0x47, 0x75, 0x82, 0x37, 0xBD, 0xF9, 0x83,
  0xEB, 0x85, 0x17, 0x50, 0x7E, 0x04, 0x77, 0x73, 0x84, 0x11, 0x23, 0x11, 0x77, 0x40, 0x7E, 0x04,
  0x80, 0xD4, 0x00, 0x8E, 0x04, 0x80, 0xD4, 0x00, 0x8E, 0x04, 0x80, 0xD4, 0x00, 0x9E, 0x03, 0x80,
  0xD4, 0x00, 0xAE, 0x02, 0x80, 0xD4, 0x00, 0xCE, 0x01, 0x80, 0xD4, 0x00, 0xED, 0x0E, 0x80, 0xD4,
  0x00, 0x2E, 0x0C, 0x80, 0xD4, 0x00, 0x5E, 0x09, 0x80, 0xD4, 0x00, 0xAE, 0x06, 0x80, 0xD4, 0x00,
  0xEE, 0x03, 0x80, 0xD3, 0x00, 0x6E, 0x0E, 0x80, 0xD4, 0x00, 0xDE, 0x09, 0x80, 0xD3, 0x00, 0x6F,
  0x03, 0x80, 0xD2, 0x00, 0x10, 0xEE, 0x0D, 0x80, 0xD3, 0x00, 0xBF, 0x05, 0x80, 0xD2, 0x00, 0x9F,
  0x0D, 0x72, 0x0D, 0x07, 0x77, 0x77, 0x70, 0x9F, 0x90, 0x47, 0x28, 0x3E, 0xFE, 0x93, 0x77, 0x77,
  0x20, 0x20, 0xCF, 0x90, 0x97, 0x30, 0xEC, 0x81, 0xD8, 0x37, 0x77, 0x40, 0x10, 0x8F, 0xA0, 0xC7,
  0x40, 0xEF, 0x82, 0xEB, 0x73, 0x77, 0x58, 0x14, 0x9E, 0xFA, 0x0E, 0x02, 0x74, 0x0E, 0xFD, 0x85,
  0xDA, 0x86, 0x53, 0x28, 0x01, 0x18, 0x42, 0x35, 0x8B, 0xEF, 0xC0, 0xE0, 0x27, 0x50, 0xE8, 0x0C,
  0x4F, 0x0C, 0x02, 0x76, 0x09, 0x80, 0xC3, 0xF0, 0x87, 0x72, 0x81, 0x16, 0xBF, 0xFF, 0xFE, 0x0B,
  0x02, 0x77, 0x68, 0x21, 0x6A, 0xEF, 0xFF, 0xE8, 0x1E, 0x93, 0x77, 0x75, 0x82, 0x36, 0xAD, 0xFF,
  0xE8, 0x1C, 0x84, 0x77, 0x77, 0x68, 0x42, 0x46, 0x79, 0x98, 0x03, 0xB8, 0x3A, 0x87, 0x53, 0x77,
  0x60,
  // "h" (U+0068)
  0x01, 0x80, 0x23, 0x01, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0,
  0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00,
  0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E,
  0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04,
  0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80,
  0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0,
  0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00,
  0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E,
  0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x76, 0x84, 0x26, 0x9B, 0xDE,
  0xD8, 0x3D, 0xB9, 0x63, 0x77, 0x10, 0x6E, 0x04, 0x73, 0x81, 0x28, 0xDF, 0xFA, 0x81, 0xEA, 0x47,
  0x50, 0x6E, 0x04, 0x71, 0x03, 0x0B, 0xFF, 0xF9, 0x0D, 0x06, 0x73, 0x06, 0xE0, 0x46, 0x01, 0x0A,
  0xFF, 0xFD, 0x0D, 0x03, 0x71, 0x06, 0xE0, 0x35, 0x04, 0x0E, 0xFF, 0xFF, 0x90, 0x77, 0x06, 0xE0,
  0x34, 0x07, 0xFF, 0xFF, 0xC0, 0x96, 0x06, 0xE0, 0x33, 0x08, 0xFA, 0x83, 0xB8, 0x53, 0x15, 0x82,
  0x24, 0x7B, 0xFC, 0x08, 0x50, 0x6E, 0x03, 0x20, 0x8F, 0x0B, 0x05, 0x77, 0x18, 0x11, 0x7E, 0xFA,
  0x05, 0x40, 0x6E, 0x81, 0x20, 0x5E, 0x0C, 0x03, 0x77, 0x60, 0x8F, 0x90, 0xE0, 0x13, 0x06, 0xE8,
  0x11, 0x1E, 0xD0, 0x67, 0x77, 0x20, 0x40, 0xEF, 0x09, 0x30, 0x6E, 0x10, 0xAC, 0x0E, 0x03, 0x77,
  0x74, 0x04, 0xF9, 0x02, 0x20, 0x6D, 0x0E, 0x03, 0xC0, 0xE0, 0x27, 0x77, 0x60, 0x6F, 0x09, 0x20,
  0x6E, 0x0D, 0xC0, 0x37, 0x77, 0x71, 0x0B, 0xE0, 0xE2, 0x06, 0xFB, 0x06, 0x77, 0x77, 0x20, 0x3F,
  0x81, 0x40, 0x6F, 0xA0, 0xC7, 0x77, 0x74, 0x0C, 0xE8, 0x18, 0x06, 0xFA, 0x03, 0x77, 0x77, 0x40,
  0x6E, 0x81, 0xC0, 0x6F, 0x90, 0xB7, 0x77, 0x75, 0x02, 0xF1, 0x06, 0xF9, 0x05, 0x77, 0x77, 0x60,
  0xDE, 0x02, 0x06, 0xF0, 0xE7, 0x77, 0x77, 0x0A, 0xE0, 0x40, 0x6F, 0x09, 0x77, 0x77, 0x70, 0x8E,
  0x05, 0x06, 0xF0, 0x57, 0x77, 0x77, 0x06, 0xE0, 0x70, 0x6F, 0x02, 0x77, 0x77, 0x70, 0x5E, 0x07,
  0x06, 0xE0, 0xE8, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x0C, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06,
  0xE0, 0x98, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x08, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0,
  0x68, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x05, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x58,
  0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C,
  0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00,
  0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04,
  0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0,
  0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80,
  0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E,
  0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04,
  0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80,
  0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0,
  0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00,
  0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E,
  0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08,
  0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06,
  0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0,
  0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48,
  0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C,
  0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00,
  0x04, 0xE0, 0x80,
  // "i" (U+0069)
  0x38, 0x24, 0x76, 0x44, 0x03, 0x0D, 0xC0, 0xD0, 0x32, 0x0D, 0xE8, 0x1E, 0x15, 0xF9, 0x06, 0x08,
  0xF9, 0x00, 0x9F, 0x90, 0xA0, 0x9F, 0x90, 0xA0, 0x7F, 0x90, 0x80, 0x2F, 0x98, 0x13, 0x08, 0xE0,
  0x93, 0x84, 0x6B, 0xED, 0xB5, 0x80, 0xA8, 0x10, 0x05, 0x80, 0x2D, 0x03, 0x20, 0x6E, 0x04, 0x20,
  0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E,
  0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04,
  0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20,
  0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E,
  0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04,
  0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20,
  0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E,
  0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04,
  0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20,
  0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E,
  0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04,
  0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x20, 0x6E, 0x04, 0x10,
  // "j" (U+006A)
  0x77, 0x58, 0x24, 0x76, 0x47, 0x76, 0x03, 0x0D, 0xC0, 0xD0, 0x37, 0x74, 0x0D, 0xE0, 0xE0, 0x17,
  0x72, 0x05, 0xF9, 0x06, 0x77, 0x20, 0x8F, 0x90, 0x97, 0x72, 0x09, 0xF9, 0x0A, 0x77, 0x20, 0x9F,
  0x90, 0xA7, 0x72, 0x07, 0xF9, 0x08, 0x77, 0x20, 0x2F, 0x90, 0x37, 0x73, 0x08, 0xE0, 0x97, 0x75,
  0x84, 0x6B, 0xED, 0xB5, 0x80, 0xDC, 0x10, 0x05, 0x80, 0x2D, 0x03, 0x77, 0x40, 0x6E, 0x04, 0x77,
  0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77,
  0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77,
  0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77,
  0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77,
  0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77,
  0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77,
  0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77,
  0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77,
  0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77,
  0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77,
  0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77,
  0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77,
  0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77,
  0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77,
  0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77,
  0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77,
  0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77,
  0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77,
  0x40, 0x6E, 0x04, 0x77, 0x40, 0x6E, 0x04, 0x77, 0x40, 0x7E, 0x04, 0x77, 0x40, 0x7E, 0x03, 0x77,
  0x40, 0x9E, 0x02, 0x77, 0x40, 0xBE, 0x01, 0x77, 0x40, 0xED, 0x0E, 0x77, 0x40, 0x4E, 0x0B, 0x77,
  0x40, 0xAE, 0x07, 0x77, 0x30, 0x4F, 0x02, 0x77, 0x20, 0x30, 0xEE, 0x0B, 0x30, 0x10, 0x27, 0x40,
  0x60, 0xEF, 0x04, 0x38, 0x93, 0x3F, 0xD9, 0x64, 0x21, 0x12, 0x47, 0xDF, 0x90, 0xB4, 0x03, 0xFF,
  0xD0, 0xE0, 0x14, 0x03, 0xFF, 0xC0, 0xE0, 0x35, 0x03, 0xFF, 0xB0, 0xE0, 0x36, 0x03, 0xFF, 0xA0,
  0xA0, 0x17, 0x01, 0x0B, 0xFD, 0x81, 0xEA, 0x37, 0x48, 0x21, 0x47, 0x98, 0x01, 0xB8, 0x19, 0x74,
  0x75,
  // "k" (U+006B)
  0x01, 0x80, 0x23, 0x01, 0x80, 0xC5, 0x00, 0x6E, 0x04, 0x80, 0xC5, 0x00, 0x6E, 0x04, 0x80, 0xC5,
  0x00, 0x6E, 0x04, 0x80, 0xC5, 0x00, 0x6E, 0x04, 0x80, 0xC5, 0x00, 0x6E, 0x04, 0x80, 0xC5, 0x00,
  0x6E, 0x04, 0x80, 0xC5, 0x00, 0x6E, 0x04, 0x80, 0xC5, 0x00, 0x6E, 0x04, 0x80, 0xC5, 0x00, 0x6E,
  0x04, 0x80, 0xC5, 0x00, 0x6E, 0x04, 0x80, 0xC5, 0x00, 0x6E, 0x04, 0x80, 0xC5, 0x00, 0x6E, 0x04,
  0x80, 0xC5, 0x00, 0x6E, 0x04, 0x80, 0xC5, 0x00, 0x6E, 0x04, 0x80, 0xC5, 0x00, 0x6E, 0x04, 0x80,
  0xC5, 0x00, 0x6E, 0x04, 0x80, 0xC5, 0x00, 0x6E, 0x04, 0x80, 0xC5, 0x00, 0x6E, 0x04, 0x80, 0xC5,
  0x00, 0x6E, 0x04, 0x80, 0xC5, 0x00, 0x6E, 0x04, 0x80, 0xC5, 0x00, 0x6E, 0x04, 0x80, 0xC5, 0x00,
  0x6E, 0x04, 0x80, 0xC5, 0x00, 0x6E, 0x04, 0x80, 0xC5, 0x00, 0x6E, 0x04, 0x80, 0xC5, 0x00, 0x6E,
  0x04, 0x80, 0xC5, 0x00, 0x6E, 0x04, 0x80, 0xC5, 0x00, 0x6E, 0x04, 0x80, 0xC5, 0x00, 0x6E, 0x04,
  0x77, 0x77, 0x20, 0x88, 0x03, 0xD0, 0x62, 0x06, 0xE0, 0x47, 0x77, 0x71, 0x07, 0xF0, 0x93, 0x06,
  0xE0, 0x47, 0x77, 0x70, 0x6F, 0x0A, 0x40, 0x6E, 0x04, 0x77, 0x76, 0x05, 0xF0, 0xB5, 0x06, 0xE0,
  0x47, 0x77, 0x50, 0x4F, 0x0C, 0x60, 0x6E, 0x04, 0x77, 0x74, 0x03, 0x0E, 0xE0, 0xD0, 0x16, 0x06,
  0xE0, 0x47, 0x77, 0x30, 0x20, 0xEE, 0x0D, 0x02, 0x70, 0x6E, 0x04, 0x77, 0x72, 0x01, 0x0D, 0xE0,
  0xE0, 0x27, 0x10, 0x6E, 0x04, 0x77, 0x71, 0x01, 0x0D, 0xE0, 0xE0, 0x37, 0x20, 0x6E, 0x04, 0x77,
  0x71, 0x0C, 0xF0, 0x47, 0x30, 0x6E, 0x04, 0x77, 0x70, 0xBF, 0x05, 0x74, 0x06, 0xE0, 0x47, 0x76,
  0x0A, 0xF0, 0x67, 0x50, 0x6E, 0x04, 0x77, 0x50, 0x9F, 0x07, 0x76, 0x06, 0xE0, 0x47, 0x74, 0x08,
  0xF0, 0x97, 0x70, 0x6E, 0x04, 0x77, 0x30, 0x6F, 0x0A, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x20, 0x5F,
  0x0B, 0x77, 0x20, 0x6E, 0x04, 0x77, 0x10, 0x4F, 0x0C, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x03, 0x0E,
  0xE0, 0xC0, 0x17, 0x73, 0x06, 0xE0, 0x47, 0x60, 0x20, 0xEE, 0x0D, 0x01, 0x77, 0x40, 0x6E, 0x04,
  0x75, 0x02, 0x0D, 0xE0, 0xE0, 0x27, 0x75, 0x06, 0xE0, 0x47, 0x40, 0x10, 0xDE, 0x0E, 0x03, 0x77,
  0x60, 0x6E, 0x04, 0x74, 0x0C, 0xF0, 0x37, 0x77, 0x06, 0xE0, 0x37, 0x30, 0xBF, 0x04, 0x77, 0x71,
  0x06, 0xE0, 0x37, 0x20, 0xAF, 0x05, 0x77, 0x72, 0x06, 0xE0, 0x37, 0x10, 0x9F, 0x07, 0x77, 0x73,
  0x06, 0xE0, 0x37, 0x08, 0xF0, 0x87, 0x77, 0x40, 0x6E, 0x02, 0x60, 0x7F, 0x09, 0x77, 0x75, 0x06,
  0xE0, 0x25, 0x05, 0xF0, 0xD7, 0x77, 0x60, 0x6E, 0x02, 0x40, 0x4F, 0xA0, 0x67, 0x77, 0x50, 0x6E,
  0x01, 0x30, 0x20, 0xEF, 0xB0, 0x37, 0x77, 0x40, 0x6E, 0x01, 0x20, 0x10, 0xDF, 0xC0, 0xD7, 0x77,
  0x40, 0x6E, 0x01, 0x20, 0xBF, 0xE0, 0xA7, 0x77, 0x30, 0x6E, 0x81, 0x10, 0x8E, 0x07, 0x0C, 0xF0,
  0x67, 0x77, 0x20, 0x6E, 0x01, 0x05, 0xE8, 0x27, 0x01, 0xEF, 0x03, 0x77, 0x71, 0x06, 0xE0, 0x4E,
  0x07, 0x30, 0x4F, 0x0D, 0x77, 0x71, 0x06, 0xE0, 0xED, 0x08, 0x50, 0x8F, 0x0A, 0x77, 0x70, 0x6F,
  0xC0, 0x87, 0x0C, 0xF0, 0x67, 0x76, 0x06, 0xFB, 0x09, 0x71, 0x01, 0x0E, 0xF0, 0x37, 0x75, 0x06,
  0xFA, 0x09, 0x73, 0x04, 0xF0, 0xD7, 0x75, 0x06, 0xF9, 0x09, 0x75, 0x08, 0xF0, 0xA7, 0x74, 0x06,
  0xF0, 0xA7, 0x70, 0xBF, 0x06, 0x77, 0x30, 0x6E, 0x0A, 0x77, 0x10, 0x10, 0xEF, 0x03, 0x77, 0x20,
  0x6E, 0x04, 0x77, 0x20, 0x4F, 0x0D, 0x77, 0x20, 0x6E, 0x04, 0x77, 0x30, 0x8F, 0x0A, 0x77, 0x10,
  0x6E, 0x04, 0x77, 0x40, 0xBF, 0x06, 0x77, 0x06, 0xE0, 0x47, 0x74, 0x01, 0x0E, 0xF0, 0x37, 0x60,
  0x6E, 0x04, 0x77, 0x50, 0x4F, 0x0D, 0x76, 0x06, 0xE0, 0x47, 0x76, 0x08, 0xF0, 0xA7, 0x50, 0x6E,
  0x04, 0x77, 0x70, 0xBF, 0x06, 0x74, 0x06, 0xE0, 0x47, 0x77, 0x01, 0x0E, 0xF0, 0x37, 0x30, 0x6E,
  0x04, 0x77, 0x71, 0x04, 0xF0, 0xD7, 0x30, 0x6E, 0x04, 0x77, 0x72, 0x08, 0xF0, 0xA7, 0x20, 0x6E,
  0x04, 0x77, 0x73, 0x0B, 0xF0, 0x67, 0x10, 0x6E, 0x04, 0x77, 0x73, 0x01, 0x0E, 0xF0, 0x37, 0x06,
  0xE0, 0x47, 0x77, 0x40, 0x4F, 0x0D, 0x70, 0x6E, 0x04, 0x77, 0x75, 0x07, 0xF0, 0xA6, 0x06, 0xE0,
  0x47, 0x77, 0x60, 0xBF, 0x06, 0x50, 0x6E, 0x04, 0x77, 0x76, 0x01, 0x0E, 0xF0, 0x34, 0x06, 0xE0,
  0x47, 0x77, 0x70, 0x4F, 0x0D, 0x40, 0x6E, 0x04, 0x77, 0x77, 0x10, 0x7F, 0x0A, 0x30, 0x6E, 0x04,
  0x77, 0x77, 0x20, 0xBF, 0x06, 0x20, 0x6E, 0x04, 0x77, 0x77, 0x20, 0x10, 0xEF, 0x81, 0x30, 0x6E,
  0x04, 0x77, 0x77, 0x30, 0x4F, 0x81, 0xD0, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x7F, 0x0A,
  // "l" (U+006C)
  0x01, 0x80, 0x23, 0x01, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0,
  0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0,
  0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0,
  0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0,
  0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0,
  0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0,
  0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0,
  0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0,
  0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0,
  0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0,
  0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0,
  0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x06, 0xE0, 0x60,
  // "m" (U+006D)
  0x77, 0x68, 0x33, 0x7A, 0xCE, 0xC8, 0x3E, 0xDB, 0x84, 0x77, 0x75, 0x83, 0x47, 0xAC, 0xED, 0x83,
  0xDB, 0x85, 0x17, 0x60, 0x58, 0x01, 0xD0, 0x17, 0x38, 0x13, 0x9E, 0xFF, 0x90, 0xA0, 0x47, 0x76,
  0x06, 0x0B, 0xFF, 0xA0, 0xB0, 0x57, 0x40, 0x6D, 0x03, 0x71, 0x03, 0x0B, 0xFF, 0xE0, 0xD0, 0x47,
  0x71, 0x81, 0x18, 0xEF, 0xFE, 0x0D, 0x05, 0x72, 0x06, 0xD0, 0x47, 0x08, 0xFF, 0xFB, 0x0A, 0x01,
  0x75, 0x06, 0x0E, 0xFF, 0xFB, 0x0B, 0x01, 0x70, 0x6D, 0x06, 0x50, 0x10, 0xBF, 0xFF, 0xD0, 0xD0,
  0x27, 0x20, 0x10, 0xBF, 0xFF, 0xE0, 0xE0, 0x36, 0x06, 0xD0, 0x74, 0x02, 0x0D, 0xFF, 0xFF, 0x0D,
  0x01, 0x70, 0x20, 0xDF, 0xFF, 0xF9, 0x0E, 0x03, 0x50, 0x6D, 0x09, 0x30, 0x20, 0xDF, 0x83, 0xD9,
  0x63, 0x14, 0x82, 0x13, 0x6B, 0xFB, 0x0C, 0x60, 0x30, 0xEF, 0x98, 0x3D, 0x96, 0x31, 0x48, 0x21,
  0x36, 0xBF, 0xB0, 0xE0, 0x24, 0x06, 0xD0, 0xA2, 0x01, 0x0D, 0xE0, 0xA0, 0x37, 0x60, 0x10, 0x8F,
  0xA0, 0x94, 0x01, 0x0E, 0xF0, 0x90, 0x37, 0x68, 0x11, 0x8E, 0xF9, 0x0C, 0x40, 0x6D, 0x0C, 0x20,
  0xBD, 0x0B, 0x02, 0x77, 0x30, 0x20, 0xCF, 0x90, 0x33, 0x0C, 0xE0, 0xA0, 0x17, 0x73, 0x01, 0x0C,
  0xF9, 0x06, 0x30, 0x6D, 0x81, 0xD0, 0x6D, 0x06, 0x77, 0x70, 0xBF, 0x0A, 0x20, 0x7D, 0x0E, 0x05,
  0x77, 0x70, 0xAF, 0x0E, 0x30, 0x6E, 0x01, 0x0E, 0xB0, 0xE0, 0x47, 0x77, 0x20, 0xCF, 0x02, 0x01,
  0xD0, 0xE0, 0x27, 0x77, 0x20, 0xBF, 0x06, 0x20, 0x6E, 0x0D, 0xC0, 0x47, 0x77, 0x30, 0x10, 0xEE,
  0x08, 0x09, 0xC0, 0xE0, 0x27, 0x77, 0x30, 0x10, 0xEE, 0x0C, 0x20, 0x6F, 0xB0, 0x77, 0x77, 0x50,
  0x7F, 0xD0, 0x47, 0x77, 0x50, 0x6F, 0x81, 0x20, 0x6F, 0xA0, 0xB7, 0x77, 0x70, 0xEF, 0xB0, 0x97,
  0x77, 0x70, 0xDE, 0x81, 0x60, 0x6F, 0xA0, 0x27, 0x77, 0x70, 0x9F, 0xA0, 0xE0, 0x17, 0x77, 0x70,
  0x7E, 0x81, 0xA0, 0x6F, 0x90, 0xA7, 0x77, 0x71, 0x04, 0xFA, 0x08, 0x77, 0x77, 0x10, 0x2E, 0x81,
  0xD0, 0x6F, 0x90, 0x37, 0x77, 0x72, 0xFA, 0x02, 0x77, 0x77, 0x20, 0xEE, 0x10, 0x6F, 0x0D, 0x77,
  0x77, 0x30, 0xCF, 0x0C, 0x77, 0x77, 0x30, 0xBE, 0x02, 0x06, 0xF0, 0x87, 0x77, 0x73, 0x09, 0xF0,
  0x77, 0x77, 0x73, 0x08, 0xE0, 0x30, 0x6F, 0x04, 0x77, 0x77, 0x30, 0x8F, 0x03, 0x77, 0x77, 0x30,
  0x7E, 0x05, 0x06, 0xF0, 0x17, 0x77, 0x73, 0x06, 0xF7, 0x77, 0x74, 0x05, 0xE0, 0x50, 0x6E, 0x0D,
  0x77, 0x77, 0x40, 0x6E, 0x0D, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x0B, 0x77, 0x77, 0x40, 0x5E,
  0x0A, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x08, 0x77, 0x77, 0x40, 0x5E, 0x09, 0x77, 0x77, 0x40,
  0x4E, 0x00, 0x6E, 0x07, 0x77, 0x77, 0x40, 0x5E, 0x07, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x06,
  0x77, 0x77, 0x40, 0x5E, 0x06, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x05, 0x77, 0x77, 0x40, 0x5E,
  0x06, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40,
  0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04,
  0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E,
  0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40,
  0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04,
  0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E,
  0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40,
  0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04,
  0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E,
  0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40,
  0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04,
  0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E,
  0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40,
  0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04,
  0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E,
  0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40,
  0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04,
  0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E,
  0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40,
  0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04,
  0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E,
  0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40,
  0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04,
  0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E,
  0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40,
  0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04,
  0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E,
  0x05, 0x77, 0x77, 0x40, 0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40,
  0x4E, 0x00, 0x6E, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x05, 0x77, 0x77, 0x40, 0x4E, 0x06,
  // "n" (U+006E)
  0x77, 0x78, 0x42, 0x58, 0xBD, 0xED, 0x83, 0xDB, 0xA7, 0x47, 0x71, 0x05, 0x80, 0x1D, 0x01, 0x74,
  0x81, 0x17, 0xDF, 0xFA, 0x81, 0xEA, 0x57, 0x50, 0x6D, 0x03, 0x72, 0x02, 0x0A, 0xFF, 0xF9, 0x0E,
  0x07, 0x73, 0x06, 0xD0, 0x47, 0x10, 0x8F, 0xFF, 0xD0, 0xD0, 0x47, 0x10, 0x6D, 0x05, 0x60, 0x20,
  0xDF, 0xFF, 0xF9, 0x08, 0x70, 0x6D, 0x07, 0x50, 0x40, 0xEF, 0xFF, 0xFB, 0x0A, 0x60, 0x6D, 0x08,
  0x40, 0x5F, 0xA8, 0x3B, 0x85, 0x31, 0x58, 0x22, 0x47, 0xBF, 0xC0, 0x95, 0x06, 0xD0, 0x93, 0x05,
  0xF0, 0xB0, 0x57, 0x71, 0x81, 0x17, 0xEF, 0xA0, 0x64, 0x06, 0xD0, 0xB2, 0x03, 0x0E, 0xD0, 0xC0,
  0x37, 0x76, 0x08, 0xF9, 0x0E, 0x02, 0x30, 0x6D, 0x0C, 0x20, 0xDD, 0x06, 0x77, 0x72, 0x04, 0x0E,
  0xF0, 0xA3, 0x06, 0xD8, 0x1D, 0x08, 0xC0, 0xE0, 0x37, 0x77, 0x40, 0x4F, 0x90, 0x32, 0x06, 0xE0,
  0x2C, 0x0E, 0x02, 0x77, 0x76, 0x06, 0xF0, 0x92, 0x06, 0xE0, 0xDC, 0x03, 0x77, 0x77, 0x10, 0xBE,
  0x0E, 0x20, 0x6F, 0xB0, 0x67, 0x77, 0x72, 0x03, 0xF8, 0x14, 0x06, 0xFA, 0x0C, 0x77, 0x77, 0x40,
  0xCE, 0x81, 0x90, 0x6F, 0xA0, 0x37, 0x77, 0x74, 0x06, 0xE8, 0x1C, 0x06, 0xF9, 0x0B, 0x77, 0x77,
  0x50, 0x2F, 0x10, 0x6F, 0x90, 0x57, 0x77, 0x76, 0x0D, 0xE0, 0x20, 0x6F, 0x0E, 0x77, 0x77, 0x70,
  0xAE, 0x04, 0x06, 0xF0, 0x97, 0x77, 0x77, 0x08, 0xE0, 0x06, 0xF0, 0x57, 0x77, 0x77, 0x06, 0xE0,
  0x70, 0x6F, 0x02, 0x77, 0x77, 0x70, 0x5E, 0x07, 0x06, 0xE0, 0xE8, 0x0C, 0x00, 0x04, 0xE0, 0x80,
  0x6E, 0x0C, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x98, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E,
  0x08, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x68, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x05,
  0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x58, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80,
  0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0,
  0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00,
  0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E,
  0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08,
  0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06,
  0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0,
  0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48,
  0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C,
  0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00,
  0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04,
  0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0,
  0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80,
  0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E,
  0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04,
  0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80,
  0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0,
  0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80,
  // "o" (U+006F)
  0x77, 0x71, 0x83, 0x47, 0xAC, 0xDD, 0x84, 0xED, 0xB8, 0x62, 0x80, 0xC2, 0x08, 0x11, 0x7C, 0xFF,
  0xB8, 0x1D, 0x93, 0x77, 0x77, 0x50, 0x30, 0xBF, 0xFF, 0xA0, 0xD0, 0x67, 0x77, 0x71, 0x03, 0x0B,
  0xFF, 0xFE, 0x0D, 0x04, 0x77, 0x75, 0x08, 0xFF, 0xFF, 0xB0, 0xA0, 0x17, 0x77, 0x10, 0x20, 0xCF,
  0xFF, 0xFD, 0x0D, 0x03, 0x77, 0x60, 0x30, 0xEF, 0xB8, 0x3D, 0xA6, 0x42, 0x58, 0x31, 0x35, 0x9D,
  0xFB, 0x0E, 0x04, 0x77, 0x40, 0x40, 0xEF, 0x98, 0x1E, 0x93, 0x77, 0x18, 0x12, 0x8E, 0xFA, 0x04,
  0x77, 0x20, 0x30, 0xEF, 0x90, 0x90, 0x17, 0x75, 0x01, 0x08, 0xFA, 0x03, 0x77, 0x01, 0x0E, 0xF0,
  0xD0, 0x37, 0x77, 0x20, 0x30, 0xDF, 0x0E, 0x01, 0x76, 0x0C, 0xF0, 0xB7, 0x77, 0x50, 0x10, 0xBF,
  0x0C, 0x75, 0x08, 0xF0, 0xB7, 0x77, 0x71, 0x0B, 0xF0, 0x77, 0x30, 0x2F, 0x0C, 0x77, 0x77, 0x20,
  0x10, 0xDF, 0x01, 0x72, 0x0B, 0xE0, 0xE0, 0x27, 0x77, 0x73, 0x02, 0xF0, 0xA7, 0x10, 0x4F, 0x06,
  0x77, 0x77, 0x50, 0x7F, 0x02, 0x70, 0xBE, 0x0C, 0x77, 0x77, 0x70, 0xDE, 0x09, 0x60, 0x3F, 0x04,
  0x77, 0x77, 0x70, 0x5F, 0x01, 0x50, 0x9E, 0x0C, 0x80, 0xC1, 0x00, 0xDE, 0x06, 0x50, 0xEE, 0x05,
  0x80, 0xC1, 0x00, 0x7E, 0x0C, 0x40, 0x4E, 0x0E, 0x80, 0xC2, 0x00, 0x2F, 0x01, 0x30, 0x8E, 0x0A,
  0x80, 0xC3, 0x00, 0xDE, 0x05, 0x30, 0xDE, 0x05, 0x80, 0xC3, 0x00, 0x8E, 0x0A, 0x20, 0x1F, 0x01,
  0x80, 0xC3, 0x00, 0x4E, 0x0D, 0x20, 0x4E, 0x0D, 0x80, 0xC4, 0x00, 0x1F, 0x81, 0x10, 0x7E, 0x0A,
  0x80, 0xC5, 0x00, 0xDE, 0x81, 0x40, 0x9E, 0x07, 0x80, 0xC5, 0x00, 0xAE, 0x81, 0x60, 0xBE, 0x05,
  0x80, 0xC5, 0x00, 0x8E, 0x81, 0x80, 0xDE, 0x03, 0x80, 0xC5, 0x00, 0x7E, 0x81, 0xA0, 0xEE, 0x02,
  0x80, 0xC5, 0x00, 0x5E, 0x0B, 0x1F, 0x80, 0xC6, 0x00, 0x3E, 0x0C, 0x01, 0xF8, 0x0C, 0x60, 0x03,
  0xE0, 0xD0, 0x1E, 0x0E, 0x80, 0xC6, 0x00, 0x2E, 0x0E, 0x02, 0xE0, 0xE8, 0x0C, 0x60, 0x02, 0xE0,
  0xE0, 0x2E, 0x0E, 0x80, 0xC6, 0x00, 0x2E, 0x0E, 0x01, 0xE0, 0xE8, 0x0C, 0x60, 0x02, 0xE0, 0xE0,
  0x1F, 0x80, 0xC6, 0x00, 0x3E, 0x0D, 0x1F, 0x80, 0xC6, 0x00, 0x3E, 0x0D, 0x1F, 0x01, 0x80, 0xC5,
  0x00, 0x5E, 0x81, 0xB0, 0xDE, 0x03, 0x80, 0xC5, 0x00, 0x6E, 0x81, 0xA0, 0xBE, 0x05, 0x80, 0xC5,
  0x00, 0x8E, 0x81, 0x80, 0x9E, 0x07, 0x80, 0xC5, 0x00, 0xAE, 0x81, 0x60, 0x7E, 0x09, 0x80, 0xC5,
  0x00, 0xDE, 0x81, 0x40, 0x4E, 0x0D, 0x80, 0xC4, 0x00, 0x1F, 0x81, 0x10, 0x1F, 0x01, 0x80, 0xC3,
  0x00, 0x4E, 0x0D, 0x30, 0xDE, 0x05, 0x80, 0xC3, 0x00, 0x8E, 0x0A, 0x30, 0x8E, 0x09, 0x80, 0xC3,
  0x00, 0xDE, 0x06, 0x30, 0x4E, 0x0E, 0x80, 0xC2, 0x00, 0x2F, 0x01, 0x40, 0xEE, 0x05, 0x80, 0xC1,
  0x00, 0x8E, 0x0C, 0x50, 0x9E, 0x0B, 0x80, 0xC1, 0x00, 0xEE, 0x07, 0x50, 0x3F, 0x03, 0x77, 0x77,
  0x70, 0x6F, 0x01, 0x60, 0xBE, 0x0A, 0x77, 0x77, 0x70, 0xDE, 0x09, 0x70, 0x4F, 0x04, 0x77, 0x77,
  0x50, 0x8F, 0x02, 0x71, 0x0B, 0xE0, 0xD7, 0x77, 0x74, 0x02, 0xF0, 0xA7, 0x20, 0x3F, 0x09, 0x77,
  0x77, 0x30, 0xDF, 0x01, 0x73, 0x08, 0xF0, 0x67, 0x77, 0x71, 0x0A, 0xF0, 0x77, 0x50, 0xDF, 0x06,
  0x77, 0x76, 0x0A, 0xF0, 0xC7, 0x60, 0x20, 0xEF, 0x08, 0x77, 0x73, 0x01, 0x0B, 0xF0, 0xE0, 0x17,
  0x70, 0x4F, 0x90, 0xC0, 0x37, 0x77, 0x06, 0x0E, 0xF9, 0x03, 0x77, 0x20, 0x6F, 0xA0, 0xA0, 0x37,
  0x73, 0x06, 0x0D, 0xFA, 0x04, 0x77, 0x40, 0x5F, 0xB8, 0x2D, 0x84, 0x17, 0x28, 0x22, 0x6A, 0xEF,
  0xA0, 0xE0, 0x47, 0x76, 0x03, 0x0E, 0xFD, 0x0E, 0x0C, 0x80, 0x1B, 0x0D, 0xFE, 0x0D, 0x03, 0x77,
  0x71, 0x01, 0x0B, 0xFF, 0xFF, 0xB0, 0xA0, 0x17, 0x77, 0x40, 0x60, 0xEF, 0xFF, 0xE0, 0xD0, 0x47,
  0x77, 0x71, 0x07, 0x0E, 0xFF, 0xFA, 0x0D, 0x06, 0x77, 0x77, 0x50, 0x50, 0xBF, 0xFC, 0x81, 0xEA,
  0x48, 0x0C, 0x20, 0x82, 0x48, 0xAD, 0xFA, 0x82, 0xCA, 0x73, 0x80, 0xD2, 0x08, 0x41, 0x12, 0x31,
  0x17, 0x77, 0x50,
  // "p" (U+0070)
  0x77, 0x78, 0x42, 0x58, 0xBD, 0xEC, 0x84, 0xED, 0xB9, 0x62, 0x77, 0x50, 0x58, 0x01, 0xD0, 0x37,
  0x48, 0x11, 0x7D, 0xFF, 0xA8, 0x1D, 0x82, 0x77, 0x20, 0x6D, 0x04, 0x72, 0x01, 0x09, 0xFF, 0xF9,
  0x0B, 0x03, 0x77, 0x06, 0xD0, 0x57, 0x10, 0x60, 0xEF, 0xFF, 0xC0, 0xB0, 0x17, 0x50, 0x6D, 0x06,
  0x70, 0xAF, 0xFF, 0xF0, 0xE0, 0x57, 0x40, 0x6D, 0x07, 0x50, 0x10, 0xCF, 0xFF, 0xFB, 0x08, 0x73,
  0x06, 0xD0, 0x84, 0x01, 0x0D, 0xF9, 0x83, 0xC8, 0x53, 0x15, 0x82, 0x35, 0x8C, 0xFC, 0x0A, 0x72,
  0x06, 0xD0, 0xA4, 0x0C, 0xE8, 0x1D, 0x61, 0x77, 0x81, 0x28, 0xEF, 0xA0, 0x97, 0x10, 0x6D, 0x0B,
  0x30, 0xBD, 0x0D, 0x05, 0x77, 0x50, 0x10, 0x8F, 0xA0, 0x77, 0x06, 0xD0, 0xC2, 0x07, 0xD0, 0xA0,
  0x17, 0x77, 0x10, 0x40, 0xEF, 0x90, 0x36, 0x06, 0xD8, 0x1D, 0x02, 0xD0, 0x87, 0x77, 0x40, 0x20,
  0xDF, 0x0D, 0x60, 0x6D, 0x81, 0xE0, 0xBC, 0x07, 0x77, 0x76, 0x01, 0x0E, 0xF0, 0x85, 0x06, 0xE0,
  0x4C, 0x0A, 0x77, 0x77, 0x10, 0x3F, 0x90, 0x14, 0x06, 0xE0, 0xEB, 0x0D, 0x01, 0x77, 0x77, 0x20,
  0x7F, 0x09, 0x40, 0x6F, 0xB0, 0x47, 0x77, 0x74, 0x0C, 0xE0, 0xE0, 0x13, 0x06, 0xFA, 0x0B, 0x77,
  0x77, 0x50, 0x5F, 0x06, 0x30, 0x6F, 0xA0, 0x47, 0x77, 0x76, 0x0C, 0xE0, 0xC3, 0x06, 0xF9, 0x0D,
  0x77, 0x77, 0x70, 0x6F, 0x01, 0x20, 0x6F, 0x90, 0x78, 0x0C, 0x00, 0x0E, 0xE0, 0x62, 0x06, 0xF9,
  0x02, 0x80, 0xC0, 0x00, 0xAE, 0x0A, 0x20, 0x6F, 0x0C, 0x80, 0xC1, 0x00, 0x6E, 0x0E, 0x20, 0x6F,
  0x09, 0x80, 0xC1, 0x00, 0x1F, 0x81, 0x20, 0x6F, 0x05, 0x80, 0xC2, 0x00, 0xDE, 0x81, 0x50, 0x6F,
  0x02, 0x80, 0xC2, 0x00, 0xAE, 0x81, 0x70, 0x6F, 0x80, 0xC3, 0x00, 0x8E, 0x81, 0x90, 0x6E, 0x0C,
  0x80, 0xC3, 0x00, 0x5E, 0x81, 0xB0, 0x6E, 0x0B, 0x80, 0xC3, 0x00, 0x3E, 0x81, 0xD0, 0x6E, 0x09,
  0x80, 0xC3, 0x00, 0x2E, 0x81, 0xE0, 0x6E, 0x08, 0x80, 0xC3, 0x00, 0x1F, 0x10, 0x6E, 0x07, 0x80,
  0xC4, 0x0F, 0x01, 0x06, 0xE0, 0x78, 0x0C, 0x40, 0xF0, 0x10, 0x6E, 0x06, 0x80, 0xC4, 0x00, 0xEE,
  0x01, 0x06, 0xE0, 0x68, 0x0C, 0x40, 0x0E, 0xE0, 0x20, 0x6E, 0x06, 0x80, 0xC4, 0x00, 0xEE, 0x02,
  0x06, 0xE0, 0x68, 0x0C, 0x40, 0xF0, 0x10, 0x6E, 0x07, 0x80, 0xC4, 0x0F, 0x01, 0x06, 0xE0, 0x78,
  0x0C, 0x30, 0x01, 0xF1, 0x06, 0xE0, 0x88, 0x0C, 0x30, 0x02, 0xF1, 0x06, 0xE0, 0x98, 0x0C, 0x30,
  0x03, 0xE8, 0x1D, 0x06, 0xE0, 0xB8, 0x0C, 0x30, 0x05, 0xE8, 0x1C, 0x06, 0xE0, 0xD8, 0x0C, 0x30,
  0x07, 0xE8, 0x1A, 0x06, 0xF8, 0x0C, 0x30, 0x0A, 0xE8, 0x18, 0x06, 0xF0, 0x28, 0x0C, 0x20, 0x0D,
  0xE8, 0x15, 0x06, 0xF0, 0x58, 0x0C, 0x10, 0x01, 0xF8, 0x13, 0x06, 0xF0, 0x88, 0x0C, 0x10, 0x05,
  0xF2, 0x06, 0xF0, 0xC8, 0x0C, 0x10, 0x09, 0xE0, 0xB2, 0x06, 0xF9, 0x01, 0x80, 0xC0, 0x00, 0xEE,
  0x08, 0x20, 0x6F, 0x90, 0x57, 0x77, 0x77, 0x04, 0xF0, 0x32, 0x06, 0xF9, 0x0B, 0x77, 0x77, 0x70,
  0xAE, 0x0D, 0x30, 0x6F, 0xA0, 0x17, 0x77, 0x75, 0x02, 0xF0, 0x83, 0x06, 0xFA, 0x09, 0x77, 0x77,
  0x50, 0xAF, 0x02, 0x30, 0x6F, 0xB0, 0x17, 0x77, 0x73, 0x03, 0xF0, 0xB4, 0x06, 0xFB, 0x0A, 0x77,
  0x77, 0x30, 0xDF, 0x04, 0x40, 0x6F, 0xC0, 0x57, 0x77, 0x71, 0x09, 0xF0, 0xB5, 0x06, 0xD0, 0xE0,
  0x4C, 0x0E, 0x03, 0x77, 0x76, 0x06, 0xF9, 0x03, 0x50, 0x6E, 0x10, 0xBC, 0x0E, 0x03, 0x77, 0x74,
  0x06, 0xF9, 0x08, 0x60, 0x6E, 0x10, 0x2D, 0x0E, 0x04, 0x77, 0x72, 0x08, 0xF9, 0x0C, 0x70, 0x6E,
  0x81, 0x10, 0x6E, 0x09, 0x01, 0x77, 0x50, 0x20, 0xBF, 0x90, 0xE0, 0x27, 0x06, 0xE0, 0x12, 0x09,
  0xE8, 0x1E, 0x71, 0x77, 0x10, 0x20, 0x9F, 0xA0, 0xE0, 0x37, 0x10, 0x6E, 0x02, 0x30, 0xBF, 0x98,
  0x1B, 0x63, 0x72, 0x81, 0x37, 0xBF, 0xB0, 0xE0, 0x47, 0x20, 0x6E, 0x03, 0x40, 0xAF, 0xC0, 0xD8,
  0x01, 0xB0, 0xDF, 0xE0, 0xE0, 0x37, 0x30, 0x6E, 0x03, 0x50, 0x8F, 0xFF, 0xF9, 0x0C, 0x02, 0x74,
  0x06, 0xE0, 0x46, 0x04, 0x0E, 0xFF, 0xFD, 0x07, 0x76, 0x06, 0xE0, 0x57, 0x01, 0x09, 0xFF, 0xFA,
  0x09, 0x01, 0x77, 0x06, 0xE0, 0x57, 0x28, 0x11, 0x8D, 0xFF, 0xB8, 0x1C, 0x71, 0x77, 0x20, 0x6E,
  0x05, 0x75, 0x82, 0x36, 0xAC, 0xF9, 0x83, 0xEC, 0x95, 0x27, 0x75, 0x06, 0xE0, 0x67, 0x73, 0x82,
  0x11, 0x23, 0x0F, 0x17, 0x77, 0x30, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00,
  0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E,
  0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06,
  0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80,
  0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4,
  0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00,
  0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E,
  0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06,
  0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x18, 0x02, 0x30, 0x18, 0x0D, 0x40,
  // "q" (U+0071)
  0x77, 0x68, 0x33, 0x79, 0xCD, 0xD8, 0x3D, 0xCA, 0x74, 0x80, 0xC2, 0x08, 0x15, 0xBE, 0xFF, 0xA0,
  0xB0, 0x57, 0x40, 0x48, 0x01, 0xD0, 0x27, 0x71, 0x07, 0x0E, 0xFF, 0xF0, 0xD0, 0x57, 0x20, 0x6D,
  0x03, 0x76, 0x06, 0x0E, 0xFF, 0xFC, 0x0C, 0x02, 0x70, 0x8D, 0x03, 0x74, 0x01, 0x0A, 0xFF, 0xFF,
  0x0E, 0x05, 0x60, 0x9D, 0x03, 0x73, 0x02, 0x0D, 0xFF, 0x83, 0xED, 0xDD, 0xEF, 0xD0, 0x75, 0x0B,
  0xD0, 0x37, 0x20, 0x30, 0xEF, 0xB8, 0x2C, 0x84, 0x27, 0x82, 0x24, 0x8C, 0xF9, 0x08, 0x40, 0xCD,
  0x03, 0x71, 0x02, 0x0E, 0xFA, 0x09, 0x03, 0x77, 0x18, 0x12, 0x8E, 0xE0, 0x73, 0x0D, 0xD0, 0x37,
  0x01, 0x0D, 0xF9, 0x0A, 0x02, 0x77, 0x50, 0x10, 0x9E, 0x04, 0x2E, 0x03, 0x70, 0xBF, 0x0E, 0x06,
  0x77, 0x72, 0x04, 0x0E, 0xC8, 0x1E, 0x11, 0xE0, 0x36, 0x06, 0xF0, 0xE0, 0x37, 0x77, 0x40, 0x30,
  0xEC, 0x0A, 0x02, 0xE0, 0x35, 0x01, 0x0E, 0xF0, 0x37, 0x77, 0x60, 0x30, 0xEC, 0x08, 0xE0, 0x35,
  0x09, 0xF0, 0x57, 0x77, 0x71, 0x05, 0xFC, 0x03, 0x40, 0x2F, 0x09, 0x77, 0x77, 0x30, 0xBF, 0xB0,
  0x34, 0x09, 0xE0, 0xE0, 0x17, 0x77, 0x73, 0x02, 0xFB, 0x03, 0x30, 0x1F, 0x06, 0x77, 0x77, 0x50,
  0x9F, 0xA0, 0x33, 0x07, 0xE0, 0xD7, 0x77, 0x76, 0x02, 0xFA, 0x03, 0x30, 0xDE, 0x07, 0x77, 0x77,
  0x70, 0xCF, 0x90, 0x32, 0x02, 0xF0, 0x17, 0x77, 0x77, 0x06, 0xF9, 0x03, 0x20, 0x7E, 0x0A, 0x80,
  0xC0, 0x00, 0x1F, 0x90, 0x32, 0x0B, 0xE0, 0x58, 0x0C, 0x10, 0x0D, 0xF0, 0x32, 0xF0, 0x18, 0x0C,
  0x10, 0x09, 0xF8, 0x13, 0x03, 0xE0, 0xC8, 0x0C, 0x20, 0x06, 0xF8, 0x13, 0x06, 0xE0, 0x98, 0x0C,
  0x20, 0x03, 0xF8, 0x13, 0x09, 0xE0, 0x68, 0x0C, 0x20, 0x01, 0xF8, 0x13, 0x0B, 0xE0, 0x48, 0x0C,
  0x30, 0x0E, 0xE8, 0x13, 0x0D, 0xE0, 0x18, 0x0C, 0x30, 0x0C, 0xE0, 0x31, 0xF8, 0x0C, 0x40, 0x0B,
  0xE0, 0x30, 0x1E, 0x0E, 0x80, 0xC4, 0x00, 0xAE, 0x03, 0x02, 0xE0, 0xC8, 0x0C, 0x40, 0x09, 0xE0,
  0x03, 0xE0, 0xB8, 0x0C, 0x40, 0x08, 0xE0, 0x03, 0xE0, 0xB8, 0x0C, 0x40, 0x08, 0xE0, 0x03, 0xE0,
  0xA8, 0x0C, 0x40, 0x08, 0xE0, 0x30, 0x4E, 0x0A, 0x80, 0xC4, 0x00, 0x7E, 0x00, 0x3E, 0x0B, 0x80,
  0xC4, 0x00, 0x8E, 0x00, 0x3E, 0x0B, 0x80, 0xC4, 0x00, 0x8E, 0x00, 0x3E, 0x0B, 0x80, 0xC4, 0x00,
  0x9E, 0x03, 0x02, 0xE0, 0xD8, 0x0C, 0x40, 0x09, 0xE0, 0x30, 0x1E, 0x0E, 0x80, 0xC4, 0x00, 0xBE,
  0x03, 0x1F, 0x80, 0xC4, 0x00, 0xCE, 0x81, 0x30, 0xDE, 0x01, 0x80, 0xC3, 0x00, 0xEE, 0x81, 0x30,
  0xBE, 0x04, 0x80, 0xC2, 0x00, 0x1F, 0x81, 0x30, 0x9E, 0x06, 0x80, 0xC2, 0x00, 0x3F, 0x81, 0x30,
  0x7E, 0x09, 0x80, 0xC2, 0x00, 0x6F, 0x81, 0x30, 0x4E, 0x0C, 0x80, 0xC2, 0x00, 0x9F, 0x03, 0x2F,
  0x01, 0x80, 0xC1, 0x00, 0xDF, 0x03, 0x20, 0xCE, 0x05, 0x80, 0xC0, 0x00, 0x2F, 0x90, 0x32, 0x08,
  0xE0, 0xA8, 0x0C, 0x00, 0x06, 0xF9, 0x03, 0x20, 0x4E, 0x0E, 0x80, 0xC0, 0x00, 0xCF, 0x90, 0x33,
  0x0E, 0xE0, 0x67, 0x77, 0x76, 0x03, 0xFA, 0x03, 0x30, 0x9E, 0x0D, 0x77, 0x77, 0x60, 0xAF, 0xA0,
  0x33, 0x02, 0xF0, 0x57, 0x77, 0x74, 0x02, 0xFB, 0x03, 0x40, 0xBE, 0x0E, 0x01, 0x77, 0x77, 0x30,
  0xBF, 0xB0, 0x34, 0x03, 0xF0, 0x97, 0x77, 0x72, 0x06, 0xC0, 0x9E, 0x03, 0x50, 0xAF, 0x06, 0x77,
  0x77, 0x03, 0xC0, 0xC0, 0x3E, 0x03, 0x50, 0x2F, 0x90, 0x57, 0x77, 0x50, 0x20, 0xEC, 0x03, 0x04,
  0xE0, 0x36, 0x06, 0xF9, 0x06, 0x77, 0x73, 0x04, 0x0E, 0xC8, 0x19, 0x05, 0xE0, 0x37, 0x0A, 0xF9,
  0x0A, 0x01, 0x77, 0x70, 0x8D, 0x0D, 0x20, 0x6E, 0x03, 0x71, 0x0C, 0xF9, 0x81, 0xE7, 0x17, 0x72,
  0x81, 0x17, 0xED, 0x0E, 0x02, 0x20, 0x6E, 0x03, 0x71, 0x01, 0x0D, 0xFA, 0x82, 0xE9, 0x51, 0x73,
  0x81, 0x26, 0xAF, 0x0E, 0x03, 0x30, 0x7E, 0x03, 0x72, 0x01, 0x0B, 0xFD, 0x0E, 0x0B, 0x80, 0x19,
  0x81, 0xAC, 0xEF, 0xA0, 0xD0, 0x24, 0x07, 0xE0, 0x37, 0x40, 0x9F, 0xFF, 0xF9, 0x0B, 0x01, 0x50,
  0x7E, 0x03, 0x75, 0x04, 0x0E, 0xFF, 0xFD, 0x07, 0x70, 0x7E, 0x03, 0x77, 0x07, 0x0E, 0xFF, 0xF9,
  0x0A, 0x02, 0x71, 0x07, 0xE0, 0x37, 0x72, 0x06, 0x0C, 0xFF, 0xB8, 0x1D, 0x82, 0x73, 0x07, 0xE0,
  0x37, 0x74, 0x83, 0x15, 0x9C, 0xEF, 0x98, 0x2C, 0xA6, 0x37, 0x60, 0x7E, 0x03, 0x77, 0x72, 0x0F,
  0x18, 0x23, 0x21, 0x17, 0x74, 0x07, 0xE0, 0x38, 0x0D, 0x40, 0x07, 0xE0, 0x38, 0x0D, 0x40, 0x07,
  0xE0, 0x38, 0x0D, 0x40, 0x07, 0xE0, 0x38, 0x0D, 0x40, 0x07, 0xE0, 0x38, 0x0D, 0x40, 0x07, 0xE0,
  0x38, 0x0D, 0x40, 0x07, 0xE0, 0x38, 0x0D, 0x40, 0x07, 0xE0, 0x38, 0x0D, 0x40, 0x07, 0xE0, 0x38,
  0x0D, 0x40, 0x07, 0xE0, 0x38, 0x0D, 0x40, 0x07, 0xE0, 0x38, 0x0D, 0x40, 0x07, 0xE0, 0x38, 0x0D,
  0x40, 0x07, 0xE0, 0x38, 0x0D, 0x40, 0x07, 0xE0, 0x38, 0x0D, 0x40, 0x07, 0xE0, 0x38, 0x0D, 0x40,
  0x07, 0xE0, 0x38, 0x0D, 0x40, 0x07, 0xE0, 0x38, 0x0D, 0x40, 0x07, 0xE0, 0x38, 0x0D, 0x40, 0x07,
  0xE0, 0x38, 0x0D, 0x40, 0x07, 0xE0, 0x38, 0x0D, 0x40, 0x07, 0xE0, 0x38, 0x0D, 0x40, 0x07, 0xE0,
  0x38, 0x0D, 0x40, 0x07, 0xE0, 0x38, 0x0D, 0x40, 0x07, 0xE0, 0x38, 0x0D, 0x40, 0x07, 0xE0, 0x38,
  0x0D, 0x40, 0x07, 0xE0, 0x38, 0x0D, 0x40, 0x07, 0xE0, 0x38, 0x0D, 0x40, 0x02, 0x80, 0x23, 0x10,
  // "r" (U+0072)
  0x77, 0x68, 0x94, 0x15, 0x8B, 0xCD, 0xDD, 0xDC, 0xB9, 0x74, 0x20, 0x58, 0x01, 0xD0, 0x47, 0x40,
  0x50, 0xBF, 0xF9, 0x04, 0x06, 0xD0, 0x67, 0x20, 0x50, 0xDF, 0xFB, 0x02, 0x06, 0xD0, 0x77, 0x01,
  0x0A, 0xFF, 0xD1, 0x06, 0xD0, 0x76, 0x02, 0x0D, 0xFF, 0xD8, 0x1D, 0x06, 0xD0, 0x85, 0x03, 0x0E,
  0xFF, 0xE8, 0x1A, 0x06, 0xD0, 0x94, 0x03, 0x0E, 0xFA, 0x89, 0x0C, 0xA8, 0x77, 0x77, 0x9A, 0xCA,
  0x81, 0x80, 0x6D, 0x0A, 0x30, 0x10, 0xEF, 0x0A, 0x04, 0x75, 0x82, 0x32, 0x06, 0xD0, 0xB3, 0x0C,
  0xE0, 0x90, 0x17, 0x73, 0x06, 0xD0, 0xC2, 0x08, 0xD0, 0xD0, 0x37, 0x75, 0x06, 0xD8, 0x1D, 0x03,
  0xD0, 0xB7, 0x77, 0x06, 0xD8, 0x1E, 0x0B, 0xC0, 0xA7, 0x77, 0x10, 0x6E, 0x04, 0xC0, 0xC7, 0x77,
  0x20, 0x6E, 0x0E, 0xB0, 0xE0, 0x17, 0x77, 0x20, 0x6F, 0xB0, 0x57, 0x77, 0x30, 0x6F, 0xA0, 0xB7,
  0x77, 0x40, 0x6F, 0xA0, 0x37, 0x77, 0x40, 0x6F, 0x90, 0xB7, 0x77, 0x50, 0x6F, 0x90, 0x57, 0x77,
  0x50, 0x6F, 0x0E, 0x77, 0x76, 0x06, 0xF0, 0xA7, 0x77, 0x60, 0x6F, 0x05, 0x77, 0x76, 0x06, 0xF0,
  0x27, 0x77, 0x60, 0x6E, 0x0E, 0x77, 0x77, 0x06, 0xE0, 0xC7, 0x77, 0x70, 0x6E, 0x0A, 0x77, 0x77,
  0x06, 0xE0, 0x87, 0x77, 0x70, 0x6E, 0x07, 0x77, 0x77, 0x06, 0xE0, 0x77, 0x77, 0x70, 0x6E, 0x06,
  0x77, 0x77, 0x06, 0xE0, 0x67, 0x77, 0x70, 0x6E, 0x06, 0x77, 0x77, 0x06, 0xE0, 0x67, 0x77, 0x70,
  0x6E, 0x06, 0x77, 0x77, 0x06, 0xE0, 0x67, 0x77, 0x70, 0x6E, 0x06, 0x77, 0x77, 0x06, 0xE0, 0x67,
  0x77, 0x70, 0x6E, 0x06, 0x77, 0x77, 0x06, 0xE0, 0x67, 0x77, 0x70, 0x6E, 0x06, 0x77, 0x77, 0x06,
  0xE0, 0x67, 0x77, 0x70, 0x6E, 0x06, 0x77, 0x77, 0x06, 0xE0, 0x67, 0x77, 0x70, 0x6E, 0x06, 0x77,
  0x77, 0x06, 0xE0, 0x67, 0x77, 0x70, 0x6E, 0x06, 0x77, 0x77, 0x06, 0xE0, 0x67, 0x77, 0x70, 0x6E,
  0x06, 0x77, 0x77, 0x06, 0xE0, 0x67, 0x77, 0x70, 0x6E, 0x06, 0x77, 0x77, 0x06, 0xE0, 0x67, 0x77,
  0x70, 0x6E, 0x06, 0x77, 0x77, 0x06, 0xE0, 0x67, 0x77, 0x70, 0x6E, 0x06, 0x77, 0x77, 0x06, 0xE0,
  0x67, 0x77, 0x70, 0x6E, 0x06, 0x77, 0x77, 0x06, 0xE0, 0x67, 0x77, 0x70, 0x6E, 0x06, 0x77, 0x77,
  0x06, 0xE0, 0x67, 0x77, 0x70, 0x6E, 0x06, 0x77, 0x77, 0x06, 0xE0, 0x67, 0x77, 0x70, 0x6E, 0x06,
  0x77, 0x77, 0x06, 0xE0, 0x67, 0x77, 0x70, 0x6E, 0x06, 0x77, 0x77, 0x06, 0xE0, 0x67, 0x77, 0x70,
  // "s" (U+0073)
  0x77, 0x18, 0x51, 0x47, 0x9B, 0xDE, 0xD8, 0x5E, 0xDC, 0xA8, 0x63, 0x77, 0x73, 0x81, 0x27, 0xCF,
  0xFE, 0x81, 0xC8, 0x47, 0x74, 0x04, 0x0B, 0xFF, 0xFE, 0x81, 0xB6, 0x17, 0x50, 0x30, 0xCF, 0xFF,
  0xFC, 0x0B, 0x05, 0x72, 0x08, 0xFF, 0xFF, 0xF0, 0xE7, 0x10, 0xBF, 0xE8, 0x6D, 0xCB, 0xBB, 0xBC,
  0xDF, 0xF9, 0x08, 0x70, 0xCF, 0xA8, 0x2D, 0x95, 0x27, 0x38, 0x31, 0x36, 0x9C, 0xFA, 0x01, 0x60,
  0xAF, 0x90, 0xA0, 0x37, 0x75, 0x82, 0x15, 0x9E, 0xC0, 0xA6, 0x06, 0xF0, 0xD0, 0x37, 0x77, 0x48,
  0x34, 0x9E, 0xF3, 0x60, 0xEE, 0x0B, 0x77, 0x77, 0x20, 0x56, 0x06, 0xE0, 0xC8, 0x0C, 0x20, 0x0C,
  0xE0, 0x38, 0x0C, 0x10, 0x01, 0xE0, 0xB8, 0x0C, 0x20, 0x04, 0xE0, 0x68, 0x0C, 0x20, 0x06, 0xE0,
  0x38, 0x0C, 0x20, 0x07, 0xE0, 0x18, 0x0C, 0x20, 0x07, 0xE0, 0x18, 0x0C, 0x20, 0x07, 0xE0, 0x28,
  0x0C, 0x20, 0x06, 0xE0, 0x58, 0x0C, 0x20, 0x04, 0xE0, 0x98, 0x0C, 0x20, 0x01, 0xE0, 0xE0, 0x18,
  0x0C, 0x20, 0x0C, 0xE0, 0xA8, 0x0C, 0x20, 0x07, 0xF0, 0x88, 0x0C, 0x10, 0x01, 0x0E, 0xF0, 0xA8,
  0x0C, 0x10, 0x07, 0xF9, 0x0D, 0x04, 0x80, 0xC0, 0x00, 0xBF, 0xA0, 0xB0, 0x47, 0x77, 0x77, 0x0C,
  0xFB, 0x81, 0xD6, 0x17, 0x77, 0x75, 0x0B, 0xFD, 0x0A, 0x04, 0x77, 0x77, 0x40, 0x8F, 0xE8, 0x1D,
  0x82, 0x77, 0x77, 0x20, 0x30, 0xCF, 0xF8, 0x1C, 0x71, 0x77, 0x77, 0x10, 0x40, 0xCF, 0xF9, 0x0B,
  0x06, 0x77, 0x77, 0x10, 0x30, 0x9F, 0xF9, 0x81, 0xE9, 0x37, 0x77, 0x78, 0x11, 0x6D, 0xFF, 0x90,
  0xC0, 0x57, 0x77, 0x71, 0x81, 0x39, 0xEF, 0xF0, 0xE0, 0x77, 0x77, 0x72, 0x04, 0x0A, 0xFF, 0x0E,
  0x06, 0x77, 0x77, 0x30, 0x50, 0xBF, 0xE0, 0xC0, 0x27, 0x77, 0x73, 0x81, 0x28, 0xEF, 0xD0, 0x57,
  0x77, 0x75, 0x05, 0x0C, 0xFC, 0x07, 0x77, 0x77, 0x60, 0x40, 0xBF, 0xB0, 0x67, 0x77, 0x77, 0x04,
  0x0C, 0xFA, 0x03, 0x80, 0xC0, 0x00, 0x7F, 0x90, 0xD8, 0x0C, 0x10, 0x03, 0x0E, 0xF0, 0x68, 0x0C,
  0x10, 0x03, 0x0E, 0xE0, 0xC8, 0x0C, 0x20, 0x06, 0xF0, 0x18, 0x0C, 0x20, 0x0D, 0xE0, 0x48, 0x0C,
  0x20, 0x08, 0xE0, 0x78, 0x0C, 0x20, 0x04, 0xE0, 0x88, 0x0C, 0x20, 0x02, 0xE0, 0x98, 0x0C, 0x20,
  0x01, 0xE0, 0x98, 0x0C, 0x20, 0x01, 0xE0, 0x88, 0x0C, 0x20, 0x03, 0xE0, 0x78, 0x0C, 0x20, 0x06,
  0xE0, 0x58, 0x0C, 0x20, 0x0B, 0xE0, 0x28, 0x0C, 0x10, 0x02, 0xE0, 0xD8, 0x0C, 0x20, 0x0B, 0xE8,
  0x28, 0x02, 0x17, 0x77, 0x76, 0x06, 0xF8, 0x42, 0x07, 0xE8, 0x17, 0x77, 0x73, 0x06, 0xF0, 0xA2,
  0x07, 0xB0, 0xB0, 0x57, 0x77, 0x70, 0x9F, 0x0E, 0x01, 0x20, 0x7D, 0x82, 0xEA, 0x61, 0x77, 0x78,
  0x11, 0x7E, 0xF9, 0x05, 0x30, 0x7F, 0xA8, 0x3D, 0x96, 0x31, 0x76, 0x81, 0x36, 0xBF, 0xB0, 0x74,
  0x07, 0xFF, 0x81, 0xEC, 0xB8, 0x02, 0x98, 0x1A, 0xBD, 0xFE, 0x07, 0x50, 0x78, 0x0C, 0x1F, 0x0E,
  0x04, 0x68, 0x11, 0x8E, 0xFF, 0xFF, 0xE0, 0x90, 0x17, 0x30, 0x50, 0xAF, 0xFF, 0xFA, 0x09, 0x02,
  0x77, 0x18, 0x15, 0x9D, 0xFF, 0xFA, 0x81, 0xB6, 0x17, 0x76, 0x84, 0x14, 0x79, 0xBD, 0xFC, 0x83,
  0xDC, 0x96, 0x37, 0x77, 0x74, 0x0F, 0x10, 0x03, 0x0F, 0x17, 0x77,
  // "t" (U+0074)
  0x75, 0x80, 0x11, 0x77, 0x77, 0x40, 0xAB, 0x0B, 0x77, 0x77, 0x40, 0xCB, 0x0B, 0x77, 0x77, 0x4C,
  0x0B, 0x77, 0x77, 0x30, 0x2C, 0x0B, 0x77, 0x77, 0x30, 0x4C, 0x0B, 0x77, 0x77, 0x30, 0x7C, 0x0B,
  0x77, 0x77, 0x30, 0x9C, 0x0B, 0x77, 0x77, 0x30, 0xCC, 0x0B, 0x77, 0x77, 0x30, 0xEC, 0x0B, 0x77,
  0x77, 0x20, 0x1D, 0x0B, 0x77, 0x77, 0x20, 0x4D, 0x0B, 0x77, 0x77, 0x20, 0x6D, 0x0B, 0x77, 0x77,
  0x20, 0x9D, 0x0B, 0x77, 0x77, 0x20, 0xBD, 0x0B, 0x77, 0x77, 0x10, 0x20, 0xED, 0x0B, 0x77, 0x74,
  0x82, 0x47, 0xBE, 0xF9, 0x80, 0x97, 0xD8, 0x35, 0x15, 0x9C, 0xFF, 0xFF, 0xC0, 0x06, 0xFF, 0xFF,
  0xF0, 0x06, 0xFF, 0xFF, 0xF0, 0x06, 0xFF, 0xFF, 0xF0, 0x60, 0x48, 0x05, 0x9E, 0x0E, 0x80, 0x97,
  0x90, 0x47, 0x30, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77,
  0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77,
  0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20,
  0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED,
  0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B,
  0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77,
  0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77,
  0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20,
  0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED,
  0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B,
  0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77,
  0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77,
  0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0B, 0x77, 0x77, 0x20, 0xED, 0x0C, 0x77, 0x77, 0x20,
  0xED, 0x0C, 0x77, 0x77, 0x20, 0xDD, 0x0D, 0x77, 0x77, 0x20, 0xCE, 0x77, 0x77, 0x20, 0xBE, 0x02,
  0x77, 0x77, 0x10, 0x9E, 0x05, 0x77, 0x77, 0x10, 0x6E, 0x09, 0x77, 0x77, 0x10, 0x3E, 0x0E, 0x77,
  0x77, 0x20, 0xEE, 0x07, 0x77, 0x77, 0x10, 0x9E, 0x0E, 0x01, 0x77, 0x77, 0x04, 0xF0, 0xC7, 0x77,
  0x71, 0x0C, 0xF0, 0xC0, 0x27, 0x77, 0x60, 0x4F, 0xA0, 0x80, 0x27, 0x28, 0x22, 0x59, 0xA7, 0x60,
  0x9F, 0xB8, 0x7D, 0xB9, 0x99, 0x9B, 0xCE, 0xB0, 0xC7, 0x70, 0xBF, 0xFF, 0x0C, 0x77, 0x10, 0xBF,
  0xFE, 0x0C, 0x77, 0x20, 0x7F, 0xFD, 0x0C, 0x77, 0x30, 0x20, 0x9F, 0xFA, 0x0E, 0x07, 0x77, 0x58,
  0x21, 0x59, 0xCF, 0x98, 0x2D, 0xA6, 0x37, 0x77, 0x58, 0x41, 0x13, 0x21, 0x17,
  // "u" (U+0075)
  0x05, 0x80, 0x2D, 0x07, 0x80, 0xC1, 0x08, 0x02, 0xD0, 0xB0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D,
  0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88,
  0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0,
  0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08,
  0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E,
  0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0,
  0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10,
  0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E,
  0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1,
  0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06,
  0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C,
  0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0,
  0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80,
  0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D,
  0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88,
  0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC0, 0x00, 0x1E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x00,
  0x02, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC0, 0x00, 0x3E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x00, 0x04,
  0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC0, 0x00, 0x7E, 0x0D, 0x06, 0xE0, 0x98, 0x0C, 0x00, 0x09, 0xE0,
  0xD0, 0x5E, 0x09, 0x80, 0xC0, 0x00, 0xCE, 0x0D, 0x05, 0xE0, 0xA8, 0x0C, 0x00, 0xF0, 0xD0, 0x3E,
  0x0C, 0x77, 0x77, 0x70, 0x4F, 0x0D, 0x02, 0xE0, 0xE7, 0x77, 0x77, 0x09, 0xF0, 0xD1, 0xF0, 0x17,
  0x77, 0x76, 0x0E, 0xF8, 0x1D, 0x0D, 0xE0, 0x57, 0x77, 0x75, 0x05, 0xF9, 0x81, 0xD0, 0xAE, 0x09,
  0x77, 0x77, 0x50, 0xCF, 0x98, 0x1D, 0x06, 0xE0, 0xE7, 0x77, 0x74, 0x06, 0xFA, 0x81, 0xD0, 0x2F,
  0x06, 0x77, 0x77, 0x20, 0x10, 0xEF, 0xA0, 0xD2, 0x0D, 0xE0, 0xD7, 0x77, 0x72, 0x0B, 0xFB, 0x0D,
  0x20, 0x7F, 0x08, 0x77, 0x77, 0x08, 0xC0, 0xA0, 0xBD, 0x0D, 0x20, 0x10, 0xEF, 0x04, 0x77, 0x75,
  0x08, 0xC8, 0x1E, 0x19, 0xD0, 0xD3, 0x08, 0xF0, 0xE0, 0x47, 0x77, 0x30, 0xAD, 0x81, 0x60, 0x8D,
  0x0D, 0x30, 0x10, 0xDF, 0x90, 0x77, 0x77, 0x05, 0x0E, 0xD0, 0xA2, 0x07, 0xD0, 0xD4, 0x04, 0xFA,
  0x0C, 0x04, 0x77, 0x30, 0x50, 0xCE, 0x0B, 0x30, 0x5D, 0x0D, 0x50, 0x8F, 0xB8, 0x2D, 0x84, 0x17,
  0x28, 0x23, 0x6A, 0xEF, 0x0C, 0x40, 0x4D, 0x0D, 0x60, 0x9F, 0xE8, 0x6E, 0xCB, 0xBB, 0xBC, 0xEF,
  0xC0, 0xA5, 0x03, 0xD0, 0xD7, 0x08, 0xFF, 0xFF, 0xA0, 0x76, 0x01, 0xD0, 0xD7, 0x10, 0x40, 0xEF,
  0xFF, 0xD0, 0xD0, 0x37, 0x1D, 0x0D, 0x73, 0x08, 0x0E, 0xFF, 0xF9, 0x0E, 0x06, 0x73, 0x0E, 0xC0,
  0xD7, 0x48, 0x11, 0x6C, 0xFF, 0xC0, 0xB0, 0x57, 0x50, 0xDC, 0x0D, 0x77, 0x83, 0x15, 0x8B, 0xDF,
  0x98, 0x3E, 0xC8, 0x51, 0x80, 0xC4, 0x08, 0x41, 0x12, 0x31, 0x17, 0x77, 0x50,
  // "v" (U+0076)
  0x0B, 0x80, 0x2D, 0x04, 0x80, 0xC4, 0x00, 0x28, 0x03, 0xD0, 0x10, 0x7E, 0x0A, 0x80, 0xC4, 0x00,
  0x8E, 0x81, 0xB0, 0x1F, 0x01, 0x80, 0xC3, 0x00, 0xEE, 0x05, 0x20, 0xBE, 0x07, 0x80, 0xC2, 0x00,
  0x4E, 0x0E, 0x30, 0x5E, 0x0C, 0x80, 0xC2, 0x00, 0xAE, 0x09, 0x40, 0xEE, 0x03, 0x80, 0xC0, 0x00,
  0x1F, 0x03, 0x40, 0x8E, 0x08, 0x80, 0xC0, 0x00, 0x6E, 0x0D, 0x50, 0x2E, 0x0E, 0x80, 0xC0, 0x00,
  0xCE, 0x07, 0x60, 0xCE, 0x05, 0x77, 0x77, 0x60, 0x2F, 0x01, 0x60, 0x6E, 0x0A, 0x77, 0x77, 0x60,
  0x8E, 0x0A, 0x70, 0x1F, 0x01, 0x77, 0x77, 0x50, 0xDE, 0x04, 0x71, 0x0A, 0xE0, 0x67, 0x77, 0x74,
  0x04, 0xE0, 0xE7, 0x20, 0x4E, 0x0C, 0x77, 0x77, 0x40, 0xAE, 0x08, 0x73, 0x0D, 0xE0, 0x37, 0x77,
  0x72, 0x01, 0xF0, 0x27, 0x30, 0x7E, 0x08, 0x77, 0x77, 0x20, 0x6E, 0x0C, 0x74, 0x01, 0xE0, 0xE7,
  0x77, 0x72, 0x0C, 0xE0, 0x67, 0x50, 0xBE, 0x04, 0x77, 0x77, 0x02, 0xE0, 0xE7, 0x60, 0x5E, 0x0A,
  0x77, 0x77, 0x08, 0xE0, 0x97, 0x70, 0xEE, 0x01, 0x77, 0x76, 0x0D, 0xE0, 0x37, 0x70, 0x9E, 0x06,
  0x77, 0x75, 0x04, 0xE0, 0xD7, 0x71, 0x03, 0xE0, 0xC7, 0x77, 0x50, 0xAE, 0x07, 0x77, 0x20, 0xCE,
  0x02, 0x77, 0x74, 0x0E, 0xE0, 0x17, 0x72, 0x06, 0xE0, 0x87, 0x77, 0x30, 0x6E, 0x0B, 0x77, 0x30,
  0x1E, 0x0E, 0x77, 0x73, 0x0B, 0xE0, 0x57, 0x74, 0x0A, 0xE0, 0x47, 0x77, 0x10, 0x2E, 0x0E, 0x77,
  0x50, 0x4E, 0x0A, 0x77, 0x71, 0x07, 0xE0, 0x87, 0x76, 0x0D, 0xE0, 0x17, 0x77, 0x0D, 0xE0, 0x27,
  0x76, 0x07, 0xE0, 0x67, 0x76, 0x04, 0xE0, 0xC7, 0x77, 0x02, 0xE0, 0xC7, 0x76, 0x09, 0xE0, 0x67,
  0x77, 0x10, 0xBE, 0x02, 0x77, 0x50, 0xED, 0x0E, 0x01, 0x77, 0x71, 0x05, 0xE0, 0x87, 0x74, 0x05,
  0xE0, 0x97, 0x77, 0x30, 0xED, 0x0E, 0x77, 0x40, 0xBE, 0x04, 0x77, 0x73, 0x09, 0xE0, 0x47, 0x72,
  0x02, 0xE0, 0xD7, 0x77, 0x40, 0x3E, 0x0A, 0x77, 0x20, 0x7E, 0x07, 0x77, 0x75, 0x0C, 0xE0, 0x17,
  0x71, 0x0D, 0xE0, 0x17, 0x77, 0x50, 0x6E, 0x06, 0x77, 0x03, 0xE0, 0xB7, 0x77, 0x60, 0x1E, 0x0C,
  0x77, 0x09, 0xE0, 0x57, 0x77, 0x70, 0xAE, 0x02, 0x76, 0x0E, 0xD0, 0xE7, 0x77, 0x71, 0x04, 0xE0,
  0x87, 0x50, 0x5E, 0x08, 0x77, 0x77, 0x20, 0xDD, 0x0D, 0x75, 0x0B, 0xE0, 0x37, 0x77, 0x72, 0x08,
  0xE0, 0x47, 0x30, 0x1E, 0x0C, 0x77, 0x77, 0x30, 0x2E, 0x0A, 0x73, 0x07, 0xE0, 0x67, 0x77, 0x74,
  0x0B, 0xE0, 0x17, 0x20, 0xDE, 0x01, 0x77, 0x77, 0x40, 0x5E, 0x06, 0x71, 0x03, 0xE0, 0xA7, 0x77,
  0x76, 0x0E, 0xD0, 0xC7, 0x10, 0x8E, 0x04, 0x77, 0x77, 0x60, 0x9E, 0x02, 0x70, 0xDD, 0x0D, 0x77,
  0x77, 0x70, 0x3E, 0x08, 0x60, 0x4E, 0x07, 0x80, 0xC0, 0x00, 0xDD, 0x0D, 0x60, 0x9E, 0x02, 0x80,
  0xC0, 0x00, 0x7E, 0x03, 0x50, 0xED, 0x0B, 0x80, 0xC1, 0x00, 0x1E, 0x08, 0x40, 0x4E, 0x05, 0x80,
  0xC2, 0x00, 0xAD, 0x0E, 0x40, 0xAD, 0x0E, 0x80, 0xC3, 0x00, 0x4E, 0x03, 0x30, 0xED, 0x09, 0x80,
  0xC4, 0x00, 0xED, 0x08, 0x20, 0x4E, 0x03, 0x80, 0xC4, 0x00, 0x8D, 0x0D, 0x20, 0x9D, 0x0C, 0x80,
  0xC5, 0x00, 0x2E, 0x81, 0x20, 0xDD, 0x06, 0x80, 0xC6, 0x00, 0xBD, 0x06, 0x03, 0xE0, 0x18, 0x0C,
  0x60, 0x06, 0xD0, 0xA0, 0x7D, 0x0A, 0x80, 0xD0, 0x00, 0xED, 0x0E, 0xD0, 0x48, 0x0D, 0x00, 0x09,
  0xFB, 0x0D, 0x80, 0xD1, 0x00, 0x3F, 0xB0, 0x88, 0x0D, 0x20, 0x0D, 0xFA, 0x02, 0x80, 0xD2, 0x00,
  0x7F, 0x90, 0xB8, 0x0D, 0x30, 0x01, 0xF9, 0x05, 0x80, 0xD4, 0x00, 0xAE, 0x0E, 0x77, 0x74,
  // "w" (U+0077)
  0x02, 0x80, 0x2D, 0x0B, 0x77, 0x77, 0x40, 0xB8, 0x02, 0xD0, 0x47, 0x77, 0x72, 0x05, 0x80, 0x2D,
  0x81, 0x70, 0xEE, 0x02, 0x77, 0x77, 0x20, 0x2F, 0x0A, 0x77, 0x77, 0x20, 0xAE, 0x81, 0x40, 0xAE,
  0x06, 0x77, 0x77, 0x20, 0x7F, 0x0E, 0x77, 0x77, 0x20, 0xED, 0x0E, 0x20, 0x5E, 0x0A, 0x77, 0x77,
  0x20, 0xCF, 0x90, 0x47, 0x77, 0x70, 0x3E, 0x0B, 0x20, 0x1E, 0x0E, 0x77, 0x77, 0x10, 0x2F, 0xA0,
  0x97, 0x77, 0x70, 0x7E, 0x07, 0x30, 0xCE, 0x03, 0x77, 0x77, 0x07, 0xFA, 0x0E, 0x77, 0x77, 0x0B,
  0xE0, 0x23, 0x08, 0xE0, 0x77, 0x77, 0x70, 0xCF, 0xB0, 0x37, 0x77, 0x60, 0xED, 0x0E, 0x40, 0x3E,
  0x0B, 0x77, 0x76, 0x01, 0xFC, 0x08, 0x77, 0x75, 0x03, 0xE0, 0x95, 0x0E, 0xE7, 0x77, 0x60, 0x7D,
  0x0B, 0xD0, 0xD7, 0x77, 0x50, 0x8E, 0x05, 0x50, 0xAE, 0x04, 0x77, 0x75, 0x0C, 0xD0, 0x2E, 0x02,
  0x77, 0x74, 0x0C, 0xE0, 0x15, 0x06, 0xE0, 0x97, 0x77, 0x40, 0x1D, 0x81, 0xD0, 0xCD, 0x07, 0x77,
  0x73, 0x01, 0xE0, 0xC6, 0x01, 0xE0, 0xD7, 0x77, 0x40, 0x6D, 0x81, 0x90, 0x8D, 0x0C, 0x77, 0x73,
  0x04, 0xE0, 0x87, 0x0C, 0xE0, 0x27, 0x77, 0x30, 0xBD, 0x81, 0x50, 0x4E, 0x02, 0x77, 0x72, 0x09,
  0xE0, 0x47, 0x08, 0xE0, 0x67, 0x77, 0x20, 0x1E, 0x01, 0x20, 0xED, 0x06, 0x77, 0x72, 0x0D, 0xD0,
  0xE7, 0x10, 0x4E, 0x0A, 0x77, 0x72, 0x06, 0xD0, 0xD3, 0x0A, 0xD0, 0xB7, 0x77, 0x10, 0x1E, 0x0B,
  0x72, 0x0E, 0xD0, 0xE7, 0x77, 0x20, 0xBD, 0x09, 0x30, 0x6E, 0x01, 0x77, 0x70, 0x5E, 0x07, 0x72,
  0x0A, 0xE0, 0x37, 0x77, 0x01, 0xE0, 0x43, 0x01, 0xE0, 0x67, 0x77, 0x09, 0xE0, 0x27, 0x20, 0x6E,
  0x07, 0x77, 0x70, 0x6E, 0x50, 0xCD, 0x0A, 0x77, 0x70, 0xDD, 0x0E, 0x73, 0x02, 0xE0, 0xC7, 0x77,
  0x0B, 0xD0, 0xB5, 0x07, 0xE7, 0x76, 0x02, 0xE0, 0x97, 0x40, 0xDE, 0x01, 0x77, 0x50, 0x1E, 0x06,
  0x50, 0x2E, 0x05, 0x77, 0x50, 0x6E, 0x05, 0x74, 0x08, 0xE0, 0x57, 0x75, 0x05, 0xE0, 0x16, 0x0D,
  0xD0, 0xA7, 0x75, 0x0A, 0xE0, 0x17, 0x40, 0x4E, 0x09, 0x77, 0x50, 0xAD, 0x0C, 0x70, 0x9D, 0x0E,
  0x77, 0x50, 0xED, 0x0C, 0x76, 0xE0, 0xD7, 0x75, 0xE0, 0x77, 0x04, 0xE0, 0x47, 0x73, 0x03, 0xE0,
  0x87, 0x60, 0xBE, 0x02, 0x77, 0x30, 0x5E, 0x02, 0x71, 0x0E, 0xD0, 0x97, 0x73, 0x07, 0xE0, 0x47,
  0x60, 0x6E, 0x06, 0x77, 0x30, 0xAD, 0x0C, 0x72, 0x0A, 0xD0, 0xD7, 0x73, 0x0B, 0xE7, 0x70, 0x2E,
  0x0A, 0x77, 0x30, 0xED, 0x07, 0x72, 0x05, 0xE0, 0x37, 0x72, 0xE0, 0xB7, 0x71, 0x0D, 0xD0, 0xE7,
  0x72, 0x05, 0xE0, 0x27, 0x3E, 0x08, 0x77, 0x10, 0x4E, 0x07, 0x77, 0x10, 0x9E, 0x03, 0x77, 0x10,
  0xAD, 0x0C, 0x74, 0x0B, 0xD0, 0xD7, 0x71, 0x08, 0xE0, 0x27, 0x71, 0x05, 0xE0, 0x77, 0x71, 0x0E,
  0xD0, 0x77, 0x40, 0x6E, 0x02, 0x77, 0x0C, 0xD0, 0xE7, 0x73, 0xE0, 0xC7, 0x70, 0x5E, 0x02, 0x74,
  0x01, 0xE0, 0x77, 0x60, 0x1E, 0x09, 0x77, 0x30, 0xBE, 0x01, 0x76, 0x0A, 0xD0, 0xD7, 0x60, 0xCD,
  0x0C, 0x76, 0x05, 0xE0, 0x57, 0x73, 0x07, 0xE0, 0x57, 0x60, 0xED, 0x08, 0x76, 0x07, 0xE0, 0x17,
  0x50, 0x9E, 0x01, 0x77, 0x30, 0x3E, 0x09, 0x75, 0x04, 0xE0, 0x37, 0x60, 0x2E, 0x06, 0x75, 0x0D,
  0xD0, 0xC7, 0x75, 0x0E, 0xD0, 0xD7, 0x50, 0x9D, 0x0D, 0x77, 0x10, 0xDD, 0x0B, 0x74, 0x02, 0xE0,
  0x87, 0x75, 0x09, 0xE0, 0x27, 0x40, 0xED, 0x08, 0x77, 0x10, 0x8E, 0x01, 0x73, 0x06, 0xE0, 0x47,
  0x75, 0x05, 0xE0, 0x67, 0x30, 0x4E, 0x03, 0x77, 0x10, 0x3E, 0x05, 0x73, 0x0A, 0xE7, 0x76, 0x01,
  0xE0, 0xA7, 0x30, 0x9D, 0x0D, 0x77, 0x30, 0xDD, 0x0A, 0x73, 0x0E, 0xD0, 0xB7, 0x77, 0x0C, 0xD0,
  0xE7, 0x30, 0xED, 0x08, 0x77, 0x30, 0x9D, 0x0E, 0x72, 0x03, 0xE0, 0x77, 0x77, 0x07, 0xE0, 0x37,
  0x10, 0x4E, 0x03, 0x77, 0x30, 0x4E, 0x05, 0x71, 0x07, 0xE0, 0x27, 0x77, 0x03, 0xE0, 0x87, 0x10,
  0x9D, 0x0D, 0x77, 0x50, 0xED, 0x09, 0x71, 0x0B, 0xD0, 0xE7, 0x77, 0x20, 0xED, 0x0C, 0x71, 0x0E,
  0xD0, 0x87, 0x75, 0x0A, 0xD0, 0xE7, 0x10, 0xED, 0x09, 0x77, 0x72, 0x0A, 0xE0, 0x16, 0x04, 0xE0,
  0x37, 0x75, 0x05, 0xE0, 0x36, 0x03, 0xE0, 0x57, 0x77, 0x20, 0x5E, 0x05, 0x60, 0x9D, 0x0E, 0x77,
  0x7E, 0x08, 0x60, 0x7E, 0x01, 0x77, 0x72, 0x01, 0xE0, 0x96, 0x0E, 0xD0, 0x97, 0x77, 0x0B, 0xD0,
  0xC6, 0x0B, 0xD0, 0xC7, 0x77, 0x40, 0xCD, 0x0D, 0x50, 0x3E, 0x04, 0x77, 0x70, 0x6E, 0x01, 0x50,
  0xED, 0x08, 0x77, 0x74, 0x08, 0xE0, 0x14, 0x08, 0xD0, 0xE7, 0x77, 0x10, 0x1E, 0x06, 0x40, 0x3E,
  0x04, 0x77, 0x74, 0x03, 0xE0, 0x64, 0x0C, 0xD0, 0x97, 0x77, 0x20, 0xCD, 0x0A, 0x40, 0x7E, 0x77,
  0x76, 0x0E, 0xD0, 0xA3, 0x01, 0xE0, 0x47, 0x77, 0x20, 0x7D, 0x0E, 0x40, 0xBD, 0x0B, 0x77, 0x76,
  0x0A, 0xD0, 0xD3, 0x05, 0xD0, 0xE7, 0x77, 0x30, 0x2E, 0x03, 0x30, 0xED, 0x07, 0x77, 0x76, 0x06,
  0xE0, 0x22, 0x09, 0xD0, 0x97, 0x77, 0x40, 0xDD, 0x08, 0x20, 0x3E, 0x02, 0x77, 0x76, 0x01, 0xE0,
  0x62, 0x0D, 0xD0, 0x47, 0x77, 0x40, 0x8D, 0x0C, 0x20, 0x6D, 0x0E, 0x77, 0x77, 0x10, 0xCD, 0x81,
  0x90, 0x1D, 0x0E, 0x77, 0x75, 0x03, 0xE8, 0x11, 0x0A, 0xD0, 0x97, 0x77, 0x71, 0x08, 0xD8, 0x1D,
  0x05, 0xD0, 0x97, 0x77, 0x60, 0xDD, 0x81, 0x50, 0xDD, 0x05, 0x77, 0x77, 0x10, 0x4E, 0x10, 0x9D,
  0x04, 0x77, 0x76, 0x09, 0xD0, 0x80, 0x1E, 0x01, 0x77, 0x77, 0x20, 0xED, 0x03, 0x0D, 0xC0, 0xE7,
  0x77, 0x70, 0x4D, 0x0B, 0x03, 0xD0, 0xC7, 0x77, 0x73, 0x0B, 0xD0, 0x7D, 0x0A, 0x77, 0x77, 0x10,
  0xEC, 0x0E, 0x06, 0xD0, 0x87, 0x77, 0x73, 0x06, 0xFC, 0x05, 0x77, 0x77, 0x10, 0xAD, 0x0E, 0xD0,
  0x47, 0x77, 0x73, 0x02, 0xFB, 0x0E, 0x77, 0x77, 0x20, 0x5F, 0xC7, 0x77, 0x75, 0x0D, 0xFA, 0x0A,
  0x77, 0x77, 0x3F, 0xB0, 0xB7, 0x77, 0x75, 0x09, 0xFA, 0x05, 0x77, 0x77, 0x30, 0xBF, 0xA0, 0x77,
  0x77, 0x75, 0x04, 0xFA, 0x77, 0x77, 0x40, 0x6F, 0xA0, 0x27, 0x77, 0x76, 0xF9, 0x0A, 0x77, 0x77,
  0x40, 0x1F, 0x90, 0xE7, 0x77, 0x77, 0x0B, 0xF0, 0x57, 0x77, 0x75, 0x0C, 0xF0, 0x97, 0x77, 0x77,
  0x07, 0xF0, 0x17, 0x77, 0x75, 0x07, 0xF0, 0x57, 0x73,
  // "x" (U+0078)
  0x10, 0x18, 0x03, 0xD0, 0xB8, 0x0C, 0x00, 0x0A, 0x80, 0x2D, 0x0C, 0x01, 0x30, 0x6F, 0x08, 0x77,
  0x77, 0x60, 0x7F, 0x05, 0x50, 0xBF, 0x04, 0x77, 0x77, 0x40, 0x2F, 0x09, 0x60, 0x10, 0xEE, 0x0D,
  0x01, 0x77, 0x77, 0x30, 0xCE, 0x0D, 0x71, 0x04, 0xF0, 0xA7, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x20,
  0x8F, 0x05, 0x77, 0x77, 0x04, 0xF0, 0x77, 0x40, 0xCE, 0x0E, 0x01, 0x77, 0x75, 0x01, 0x0D, 0xE0,
  0xB7, 0x50, 0x20, 0xEE, 0x0B, 0x77, 0x75, 0x0A, 0xE0, 0xE0, 0x17, 0x60, 0x6F, 0x06, 0x77, 0x73,
  0x05, 0xF0, 0x57, 0x71, 0x0A, 0xF0, 0x27, 0x77, 0x10, 0x10, 0xEE, 0x09, 0x77, 0x20, 0x10, 0xDE,
  0x0C, 0x77, 0x71, 0x0B, 0xE0, 0xD7, 0x74, 0x04, 0xF0, 0x87, 0x76, 0x07, 0xF0, 0x37, 0x75, 0x08,
  0xF0, 0x37, 0x74, 0x02, 0xF0, 0x77, 0x77, 0x0C, 0xE0, 0xD7, 0x74, 0x0C, 0xE0, 0xC7, 0x77, 0x10,
  0x20, 0xEE, 0x09, 0x77, 0x20, 0x8E, 0x0E, 0x02, 0x77, 0x72, 0x05, 0xF0, 0x47, 0x70, 0x4F, 0x05,
  0x77, 0x74, 0x0A, 0xE0, 0xE0, 0x17, 0x50, 0x10, 0xDE, 0x0A, 0x77, 0x75, 0x01, 0x0D, 0xE0, 0xA7,
  0x50, 0xAE, 0x0D, 0x01, 0x77, 0x76, 0x03, 0xF0, 0x67, 0x30, 0x5F, 0x03, 0x77, 0x77, 0x10, 0x7E,
  0x0E, 0x02, 0x71, 0x01, 0x0E, 0xE0, 0x87, 0x77, 0x73, 0x0C, 0xE0, 0xB7, 0x10, 0xBE, 0x0C, 0x77,
  0x77, 0x40, 0x20, 0xEE, 0x07, 0x60, 0x7E, 0x0E, 0x02, 0x77, 0x77, 0x50, 0x5F, 0x03, 0x40, 0x2F,
  0x06, 0x77, 0x77, 0x70, 0x9E, 0x0C, 0x40, 0xCE, 0x0A, 0x80, 0xC1, 0x00, 0xDE, 0x08, 0x20, 0x8E,
  0x0D, 0x01, 0x80, 0xC1, 0x00, 0x3F, 0x00, 0x4F, 0x04, 0x80, 0xC3, 0x00, 0x7E, 0x00, 0xDE, 0x08,
  0x80, 0xC5, 0x00, 0xBF, 0xD0, 0xC8, 0x0C, 0x60, 0x01, 0x0E, 0xFC, 0x02, 0x80, 0xC7, 0x00, 0x5F,
  0xB0, 0x68, 0x0D, 0x10, 0x09, 0xF9, 0x0B, 0x80, 0xD2, 0x00, 0x4F, 0x90, 0x68, 0x0D, 0x10, 0x01,
  0x0D, 0xF9, 0x0E, 0x02, 0x80, 0xD0, 0x00, 0xAF, 0xB0, 0xC8, 0x0C, 0x70, 0x06, 0xFD, 0x08, 0x80,
  0xC5, 0x00, 0x20, 0xEF, 0xE0, 0x38, 0x0C, 0x40, 0x0C, 0xE0, 0x09, 0xE0, 0xD0, 0x18, 0x0C, 0x20,
  0x08, 0xE0, 0xD2, 0x0D, 0xE0, 0xA8, 0x0C, 0x10, 0x03, 0xF0, 0x32, 0x03, 0xF0, 0x67, 0x77, 0x77,
  0x01, 0x0D, 0xE0, 0x74, 0x07, 0xE0, 0xE0, 0x27, 0x77, 0x76, 0x0A, 0xE0, 0xC6, 0x0C, 0xE0, 0xC7,
  0x77, 0x75, 0x05, 0xE0, 0xE0, 0x26, 0x02, 0x0E, 0xE0, 0x87, 0x77, 0x73, 0x02, 0x0E, 0xE0, 0x67,
  0x10, 0x6F, 0x03, 0x77, 0x77, 0x20, 0xCE, 0x0B, 0x73, 0x0A, 0xE0, 0xD0, 0x17, 0x77, 0x70, 0x7E,
  0x0E, 0x01, 0x73, 0x01, 0x0E, 0xE0, 0xA7, 0x77, 0x60, 0x3F, 0x05, 0x75, 0x04, 0xF0, 0x57, 0x77,
  0x50, 0xDE, 0x09, 0x77, 0x09, 0xE0, 0xE0, 0x27, 0x77, 0x30, 0x9E, 0x0D, 0x77, 0x20, 0xDE, 0x0C,
  0x77, 0x72, 0x05, 0xF0, 0x37, 0x72, 0x03, 0xF0, 0x87, 0x77, 0x01, 0x0E, 0xE0, 0x87, 0x74, 0x07,
  0xF0, 0x37, 0x76, 0x0B, 0xE0, 0xC7, 0x76, 0x0B, 0xE0, 0xD0, 0x17, 0x74, 0x07, 0xF0, 0x27, 0x76,
  0x02, 0x0E, 0xE0, 0xA7, 0x73, 0x03, 0xF0, 0x67, 0x77, 0x10, 0x5F, 0x05, 0x77, 0x20, 0xDE, 0x0B,
  0x77, 0x73, 0x0A, 0xE0, 0xE0, 0x27, 0x70, 0x9E, 0x0E, 0x01, 0x77, 0x73, 0x01, 0x0D, 0xE0, 0xC7,
  0x60, 0x4F, 0x05, 0x77, 0x75, 0x04, 0xF0, 0x87, 0x40, 0x10, 0xEE, 0x0A, 0x77, 0x77, 0x08, 0xF0,
  0x37, 0x30, 0xBE, 0x0D, 0x01, 0x77, 0x77, 0x10, 0xCE, 0x0D, 0x01, 0x71, 0x07, 0xF0, 0x47, 0x77,
  0x72, 0x03, 0xF0, 0xA7, 0x02, 0xF0, 0x87, 0x77, 0x74, 0x07, 0xF0, 0x56, 0x0C, 0xE0, 0xD7, 0x77,
  0x76, 0x0B, 0xE0, 0xE0, 0x24, 0x09, 0xF0, 0x37, 0x77, 0x76, 0x01, 0x0E, 0xE0, 0xC3, 0x04, 0xF0,
  0x78, 0x0C, 0x00, 0x05, 0xF8, 0x28, 0x01, 0xEE, 0x0B, 0x80, 0xC2, 0x00, 0xAF, 0x03,
  // "y" (U+0079)
  0x0B, 0x80, 0x2D, 0x06, 0x80, 0xC4, 0x00, 0x18, 0x03, 0xD0, 0x30, 0x7E, 0x0C, 0x80, 0xC4, 0x00,
  0x6E, 0x81, 0xD0, 0x1F, 0x03, 0x80, 0xC3, 0x00, 0xCE, 0x07, 0x20, 0xAE, 0x09, 0x80, 0xC2, 0x00,
  0x2F, 0x02, 0x20, 0x4E, 0x0E, 0x80, 0xC2, 0x00, 0x8E, 0x0B, 0x40, 0xDE, 0x05, 0x80, 0xC1, 0x00,
  0xDE, 0x05, 0x40, 0x7E, 0x0B, 0x80, 0xC0, 0x00, 0x4E, 0x0E, 0x50, 0x1F, 0x02, 0x77, 0x77, 0x70,
  0xAE, 0x09, 0x60, 0xBE, 0x07, 0x77, 0x77, 0x60, 0x1F, 0x03, 0x60, 0x4E, 0x0D, 0x77, 0x77, 0x60,
  0x6E, 0x0C, 0x71, 0x0D, 0xE0, 0x47, 0x77, 0x75, 0x0C, 0xE0, 0x67, 0x10, 0x8E, 0x0A, 0x77, 0x77,
  0x40, 0x2F, 0x01, 0x71, 0x02, 0xF0, 0x17, 0x77, 0x73, 0x08, 0xE0, 0xA7, 0x30, 0xBE, 0x06, 0x77,
  0x77, 0x30, 0xDE, 0x04, 0x73, 0x05, 0xE0, 0xC7, 0x77, 0x72, 0x04, 0xE0, 0xD7, 0x50, 0xEE, 0x03,
  0x77, 0x77, 0x10, 0xAE, 0x08, 0x75, 0x08, 0xE0, 0x97, 0x77, 0x71, 0x0E, 0xE0, 0x27, 0x50, 0x2E,
  0x0E, 0x77, 0x77, 0x06, 0xE0, 0xB7, 0x70, 0xBE, 0x05, 0x77, 0x76, 0x0B, 0xE0, 0x57, 0x70, 0x5E,
  0x0B, 0x77, 0x75, 0x02, 0xE0, 0xE7, 0x72, 0x0E, 0xE0, 0x27, 0x77, 0x40, 0x7E, 0x09, 0x77, 0x20,
  0x9E, 0x07, 0x77, 0x74, 0x0D, 0xE0, 0x37, 0x72, 0x02, 0xE0, 0xD7, 0x77, 0x30, 0x4E, 0x0D, 0x77,
  0x40, 0xCE, 0x04, 0x77, 0x72, 0x09, 0xE0, 0x77, 0x74, 0x06, 0xE0, 0xA7, 0x77, 0x20, 0xEE, 0x01,
  0x77, 0x50, 0xEE, 0x01, 0x77, 0x70, 0x5E, 0x0A, 0x77, 0x60, 0x9E, 0x06, 0x77, 0x70, 0xBE, 0x04,
  0x77, 0x60, 0x3E, 0x0C, 0x77, 0x60, 0x2E, 0x0E, 0x77, 0x71, 0x0C, 0xE0, 0x37, 0x75, 0x07, 0xE0,
  0x87, 0x77, 0x10, 0x6E, 0x08, 0x77, 0x50, 0xDE, 0x02, 0x77, 0x71, 0x01, 0xE0, 0xE7, 0x74, 0x03,
  0xE0, 0xC7, 0x77, 0x30, 0x9E, 0x05, 0x77, 0x30, 0x9E, 0x06, 0x77, 0x73, 0x03, 0xE0, 0xB7, 0x73,
  0x0E, 0xD0, 0xE7, 0x77, 0x50, 0xDE, 0x01, 0x77, 0x10, 0x5E, 0x09, 0x77, 0x75, 0x07, 0xE0, 0x77,
  0x71, 0x0B, 0xE0, 0x37, 0x77, 0x50, 0x1E, 0x0D, 0x77, 0x01, 0xE0, 0xD7, 0x77, 0x70, 0xAE, 0x04,
  0x76, 0x07, 0xE0, 0x77, 0x77, 0x70, 0x4E, 0x0A, 0x76, 0x0D, 0xE0, 0x17, 0x77, 0x71, 0x0D, 0xE0,
  0x17, 0x40, 0x3E, 0x0B, 0x77, 0x77, 0x20, 0x7E, 0x06, 0x74, 0x09, 0xE0, 0x57, 0x77, 0x72, 0x01,
  0xE0, 0xC7, 0x40, 0xED, 0x0E, 0x77, 0x77, 0x40, 0xAE, 0x02, 0x72, 0x05, 0xE0, 0x87, 0x77, 0x74,
  0x04, 0xE0, 0x77, 0x20, 0xAE, 0x03, 0x77, 0x77, 0x50, 0xDD, 0x0D, 0x71, 0x01, 0xE0, 0xC7, 0x77,
  0x76, 0x08, 0xE0, 0x37, 0x06, 0xE0, 0x67, 0x77, 0x76, 0x02, 0xE0, 0x97, 0x0B, 0xE0, 0x17, 0x77,
  0x77, 0x0B, 0xD0, 0xE6, 0x01, 0xE0, 0xA8, 0x0C, 0x00, 0x05, 0xE0, 0x45, 0x06, 0xE0, 0x48, 0x0C,
  0x10, 0x0E, 0xD0, 0x95, 0x0C, 0xD0, 0xD8, 0x0C, 0x20, 0x08, 0xD0, 0xE4, 0x01, 0xE0, 0x78, 0x0C,
  0x20, 0x02, 0xE0, 0x53, 0x07, 0xE0, 0x28, 0x0C, 0x30, 0x0B, 0xD0, 0xA3, 0x0C, 0xD0, 0xB8, 0x0C,
  0x40, 0x05, 0xD0, 0xE2, 0x01, 0xE0, 0x58, 0x0C, 0x50, 0x0E, 0xD8, 0x14, 0x06, 0xD0, 0xE8, 0x0C,
  0x60, 0x08, 0xD8, 0x19, 0x0B, 0xD0, 0x98, 0x0C, 0x60, 0x02, 0xD0, 0xD0, 0x1E, 0x03, 0x80, 0xC7,
  0x00, 0xCD, 0x09, 0xD0, 0xC8, 0x0D, 0x00, 0x06, 0xFC, 0x07, 0x80, 0xD1, 0x00, 0xEF, 0xB0, 0x18,
  0x0D, 0x10, 0x09, 0xFA, 0x0A, 0x80, 0xD2, 0x00, 0x3F, 0xA0, 0x48, 0x0D, 0x30, 0x0C, 0xF0, 0xD8,
  0x0D, 0x40, 0x06, 0xF0, 0x88, 0x0D, 0x40, 0x01, 0xF0, 0x28, 0x0D, 0x40, 0x03, 0xE0, 0xB8, 0x0D,
  0x50, 0x09, 0xE0, 0x58, 0x0D, 0x50, 0x0E, 0xD0, 0xE8, 0x0D, 0x50, 0x05, 0xE0, 0x98, 0x0D, 0x50,
  0x0B, 0xE0, 0x38, 0x0D, 0x40, 0x02, 0xE0, 0xD8, 0x0D, 0x50, 0x08, 0xE0, 0x78, 0x0D, 0x50, 0x0E,
  0xE0, 0x18, 0x0D, 0x40, 0x05, 0xE0, 0xA8, 0x0D, 0x50, 0x0B, 0xE0, 0x58, 0x0D, 0x40, 0x01, 0xE0,
  0xE8, 0x0D, 0x50, 0x07, 0xE0, 0x88, 0x0D, 0x50, 0x0D, 0xE0, 0x28, 0x0D, 0x40, 0x05, 0xE0, 0xB8,
  0x0D, 0x50, 0x0C, 0xE0, 0x48, 0x0D, 0x40, 0x05, 0xE0, 0xC8, 0x0D, 0x50, 0x0D, 0xE0, 0x58, 0x0D,
  0x40, 0x09, 0xE0, 0xC8, 0x0D, 0x40, 0x05, 0xF0, 0x38, 0x0D, 0x30, 0x03, 0x0E, 0xE0, 0xA8, 0x0D,
  0x30, 0x04, 0x0E, 0xE0, 0xE0, 0x18, 0x0D, 0x20, 0x08, 0xF9, 0x05, 0x77, 0x77, 0x68, 0x29, 0x84,
  0x26, 0x81, 0x49, 0xEF, 0x90, 0x87, 0x77, 0x77, 0x0B, 0xC0, 0xFD, 0x0E, 0xFC, 0x0B, 0x80, 0xC0,
  0x00, 0xBF, 0xFC, 0x0B, 0x80, 0xC1, 0x00, 0xBF, 0xFB, 0x0A, 0x80, 0xC2, 0x00, 0xBF, 0xF9, 0x0E,
  0x06, 0x80, 0xC3, 0x00, 0xBF, 0xE8, 0x1E, 0x81, 0x80, 0xC5, 0x08, 0x32, 0x59, 0xCE, 0xC8, 0x2D,
  0xB8, 0x48, 0x0C, 0x70,
  // "z" (U+007A)
  0x30, 0x78, 0x0C, 0x6D, 0x05, 0x30, 0x88, 0x0C, 0x6F, 0x06, 0x30, 0x88, 0x0C, 0x6F, 0x06, 0x30,
  0x88, 0x0C, 0x6F, 0x06, 0x30, 0x88, 0x0C, 0x6F, 0x06, 0x30, 0x58, 0x0B, 0x69, 0x0E, 0xE0, 0xE0,
  0x18, 0x0C, 0x10, 0x05, 0xF0, 0x58, 0x0C, 0x10, 0x01, 0x0E, 0xE0, 0x98, 0x0C, 0x20, 0x0B, 0xE0,
  0xD8, 0x0C, 0x20, 0x06, 0xF0, 0x38, 0x0C, 0x10, 0x02, 0x0E, 0xE0, 0x88, 0x0C, 0x20, 0x0C, 0xE0,
  0xC8, 0x0C, 0x20, 0x07, 0xE0, 0xE0, 0x28, 0x0C, 0x10, 0x03, 0xF0, 0x68, 0x0C, 0x20, 0x0D, 0xE0,
  0xB8, 0x0C, 0x20, 0x09, 0xE0, 0xE0, 0x18, 0x0C, 0x10, 0x04, 0xF0, 0x58, 0x0C, 0x10, 0x01, 0x0D,
  0xE0, 0x98, 0x0C, 0x20, 0x0A, 0xE0, 0xD8, 0x0C, 0x20, 0x05, 0xF0, 0x38, 0x0C, 0x10, 0x01, 0x0E,
  0xE0, 0x88, 0x0C, 0x20, 0x0B, 0xE0, 0xC8, 0x0C, 0x20, 0x06, 0xE0, 0xE0, 0x28, 0x0C, 0x10, 0x02,
  0xF0, 0x68, 0x0C, 0x20, 0x0C, 0xE0, 0xB8, 0x0C, 0x20, 0x08, 0xE0, 0xE0, 0x18, 0x0C, 0x10, 0x03,
  0xF0, 0x58, 0x0C, 0x20, 0x0D, 0xE0, 0x98, 0x0C, 0x20, 0x09, 0xE0, 0xD8, 0x0C, 0x20, 0x04, 0xF0,
  0x38, 0x0C, 0x10, 0x01, 0x0E, 0xE0, 0x88, 0x0C, 0x20, 0x0A, 0xE0, 0xC8, 0x0C, 0x20, 0x06, 0xF0,
  0x28, 0x0C, 0x10, 0x02, 0x0E, 0xE0, 0x68, 0x0C, 0x20, 0x0B, 0xE0, 0xB8, 0x0C, 0x20, 0x07, 0xE0,
  0xE0, 0x18, 0x0C, 0x10, 0x03, 0xF0, 0x58, 0x0C, 0x20, 0x0D, 0xE0, 0x98, 0x0C, 0x20, 0x08, 0xE0,
  0xD8, 0x0C, 0x20, 0x04, 0xF0, 0x38, 0x0C, 0x10, 0x01, 0x0D, 0xE0, 0x88, 0x0C, 0x20, 0x0A, 0xE0,
  0xC8, 0x0C, 0x20, 0x05, 0xF0, 0x28, 0x0C, 0x10, 0x01, 0x0E, 0xE0, 0x68, 0x0C, 0x20, 0x0B, 0xE0,
  0xB8, 0x0C, 0x20, 0x06, 0xE0, 0xE0, 0x18, 0x0C, 0x10, 0x02, 0x0E, 0xE0, 0x58, 0x0C, 0x20, 0x0C,
  0xE0, 0x98, 0x0C, 0x20, 0x07, 0xE0, 0xD8, 0x0C, 0x20, 0x03, 0xF0, 0x38, 0x0C, 0x20, 0x0D, 0xE0,
  0x88, 0x0C, 0x20, 0x09, 0xE0, 0xC8, 0x0C, 0x20, 0x04, 0xF0, 0x28, 0x0C, 0x10, 0x01, 0x0E, 0xE0,
  0x68, 0x0C, 0x20, 0x0A, 0xE0, 0xB8, 0x0C, 0x20, 0x05, 0xE0, 0xE0, 0x18, 0x0C, 0x10, 0x01, 0x0E,
  0xE0, 0x58, 0x0C, 0x20, 0x0B, 0xE0, 0x98, 0x0C, 0x20, 0x07, 0xF0, 0x88, 0x0C, 0x07, 0x04, 0x01,
  0x80, 0xD1, 0xF0, 0x90, 0x38, 0x0D, 0x1F, 0x09, 0x03, 0x80, 0xD1, 0xF0, 0x90, 0x38, 0x0D, 0x1F,
  0x09, 0x03, 0x80, 0xD1, 0xF0, 0x90,
  // "{" (U+007B)
  0x77, 0x77, 0x18, 0x52, 0x47, 0x89, 0x98, 0x77, 0x74, 0x82, 0x27, 0xBE, 0xE0, 0xD7, 0x77, 0x20,
  0x50, 0xCF, 0xB0, 0xD7, 0x77, 0x04, 0x0D, 0xFD, 0x0D, 0x77, 0x60, 0x9F, 0xF0, 0xD7, 0x74, 0x01,
  0x0C, 0xFF, 0x90, 0xD7, 0x73, 0x01, 0x0D, 0xFB, 0x85, 0xEA, 0x85, 0x31, 0x17, 0x73, 0x0B, 0xFA,
  0x09, 0x03, 0x77, 0x72, 0x07, 0xF9, 0x0A, 0x01, 0x77, 0x73, 0x01, 0x0E, 0xF0, 0x67, 0x77, 0x50,
  0x7F, 0x06, 0x77, 0x76, 0x0D, 0xE0, 0xA7, 0x77, 0x60, 0x2F, 0x02, 0x77, 0x76, 0x06, 0xE0, 0xC7,
  0x77, 0x70, 0x9E, 0x07, 0x77, 0x77, 0x0B, 0xE0, 0x47, 0x77, 0x70, 0xCE, 0x02, 0x77, 0x77, 0x0C,
  0xE7, 0x77, 0x71, 0x0D, 0xE7, 0x77, 0x71, 0x0D, 0xE7, 0x77, 0x71, 0x0D, 0xE7, 0x77, 0x71, 0x0D,
  0xE7, 0x77, 0x71, 0x0D, 0xE7, 0x77, 0x71, 0x0D, 0xE7, 0x77, 0x71, 0x0D, 0xE7, 0x77, 0x71, 0x0D,
  0xE7, 0x77, 0x71, 0x0D, 0xE7, 0x77, 0x71, 0x0D, 0xE7, 0x77, 0x71, 0x0D, 0xE7, 0x77, 0x71, 0x0D,
  0xE7, 0x77, 0x71, 0x0D, 0xE7, 0x77, 0x71, 0x0D, 0xE7, 0x77, 0x71, 0x0D, 0xE7, 0x77, 0x71, 0x0D,
  0xE7, 0x77, 0x71, 0x0D, 0xE7, 0x77, 0x71, 0x0D, 0xE7, 0x77, 0x71, 0x0D, 0xE7, 0x77, 0x71, 0x0D,
  0xE7, 0x77, 0x71, 0x0D, 0xE7, 0x77, 0x71, 0xE0, 0xE7, 0x77, 0x70, 0x1E, 0x0C, 0x77, 0x77, 0x04,
  0xE0, 0xA7, 0x77, 0x70, 0x9E, 0x07, 0x77, 0x77, 0x0E, 0xE0, 0x37, 0x77, 0x60, 0x6E, 0x0D, 0x77,
  0x76, 0x02, 0x0E, 0xE0, 0x77, 0x77, 0x50, 0x20, 0xDE, 0x0E, 0x77, 0x75, 0x05, 0x0E, 0xF0, 0x57,
  0x77, 0x28, 0x11, 0x6C, 0xF9, 0x08, 0x77, 0x48, 0x43, 0x35, 0x79, 0xCF, 0xB0, 0x77, 0x75, 0x0B,
  0xFE, 0x0C, 0x03, 0x77, 0x60, 0xBF, 0xB8, 0x1E, 0xA4, 0x77, 0x71, 0x0B, 0xF9, 0x0D, 0x03, 0x77,
  0x74, 0x0B, 0xFA, 0x82, 0xEB, 0x61, 0x77, 0x71, 0x0B, 0xFD, 0x81, 0xE8, 0x17, 0x76, 0x83, 0x57,
  0x9A, 0xDF, 0xB0, 0xE0, 0x47, 0x77, 0x40, 0x40, 0x9F, 0xA0, 0x57, 0x77, 0x50, 0x10, 0x9F, 0x90,
  0x37, 0x77, 0x60, 0x40, 0xEE, 0x0C, 0x77, 0x77, 0x04, 0xF0, 0x57, 0x77, 0x70, 0x9E, 0x0C, 0x77,
  0x77, 0x01, 0xF0, 0x27, 0x77, 0x70, 0xAE, 0x06, 0x77, 0x77, 0x05, 0xE0, 0x97, 0x77, 0x70, 0x2E,
  0x0C, 0x77, 0x77, 0x1E, 0x0D, 0x77, 0x77, 0x10, 0xEE, 0x77, 0x77, 0x10, 0xDE, 0x77, 0x77, 0x10,
  0xDE, 0x77, 0x77, 0x10, 0xDE, 0x77, 0x77, 0x10, 0xDE, 0x77, 0x77, 0x10, 0xDE, 0x77, 0x77, 0x10,
  0xDE, 0x77, 0x77, 0x10, 0xDE, 0x77, 0x77, 0x10, 0xDE, 0x77, 0x77, 0x10, 0xDE, 0x77, 0x77, 0x10,
  0xDE, 0x77, 0x77, 0x10, 0xDE, 0x77, 0x77, 0x10, 0xDE, 0x77, 0x77, 0x10, 0xDE, 0x77, 0x77, 0x10,
  0xDE, 0x77, 0x77, 0x10, 0xDE, 0x77, 0x77, 0x10, 0xDE, 0x77, 0x77, 0x10, 0xDE, 0x77, 0x77, 0x10,
  0xDE, 0x77, 0x77, 0x10, 0xDE, 0x77, 0x77, 0x10, 0xDE, 0x77, 0x77, 0x10, 0xCE, 0x77, 0x77, 0x10,
  0xCE, 0x01, 0x77, 0x77, 0x0B, 0xE0, 0x37, 0x77, 0x70, 0x9E, 0x05, 0x77, 0x77, 0x07, 0xE0, 0xA7,
  0x77, 0x70, 0x3E, 0x0E, 0x77, 0x77, 0x10, 0xEE, 0x07, 0x77, 0x77, 0x09, 0xF0, 0x27, 0x77, 0x60,
  0x2F, 0x0D, 0x02, 0x77, 0x76, 0x0A, 0xF0, 0xE0, 0x47, 0x77, 0x50, 0x10, 0xEF, 0x90, 0xB0, 0x47,
  0x77, 0x40, 0x4F, 0xB8, 0x2D, 0x95, 0x27, 0x77, 0x10, 0x5F, 0xF8, 0x1E, 0xDB, 0x77, 0x50, 0x40,
  0xEF, 0xF0, 0xD7, 0x76, 0x01, 0x0A, 0xFE, 0x0D, 0x77, 0x71, 0x03, 0x0A, 0xFC, 0x0D, 0x77, 0x73,
  0x81, 0x27, 0xCF, 0x90, 0xD7, 0x77, 0x78, 0x64, 0x69, 0xBC, 0xDD, 0xC0,
  // "|" (U+007C)
  0x03, 0x80, 0x17, 0x03, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0,
  0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60,
  0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D,
  0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06,
  0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07,
  0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0,
  0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60,
  0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D,
  0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06,
  0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07,
  0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0,
  0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60,
  0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D,
  0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06,
  0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07,
  0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0,
  0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60,
  0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D,
  0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06,
  0x03, 0x80, 0x17, 0x03,
  // "}" (U+007D)
  0x85, 0x89, 0x98, 0x75, 0x27, 0x77, 0x71, 0x0E, 0xF8, 0x1B, 0x73, 0x77, 0x74, 0x0E, 0xFB, 0x0C,
  0x06, 0x77, 0x72, 0x0E, 0xFD, 0x0D, 0x05, 0x77, 0x70, 0xEF, 0xF0, 0xA0, 0x17, 0x75, 0x0E, 0xFF,
  0x90, 0xD0, 0x27, 0x74, 0x85, 0x11, 0x34, 0x7A, 0xDF, 0xB0, 0xD0, 0x17, 0x77, 0x38, 0x13, 0x8E,
  0xF9, 0x0B, 0x77, 0x75, 0x01, 0x09, 0xF9, 0x07, 0x77, 0x76, 0x06, 0xF0, 0xE7, 0x77, 0x70, 0x6F,
  0x07, 0x77, 0x77, 0x0B, 0xE0, 0xC7, 0x77, 0x70, 0x3F, 0x01, 0x77, 0x77, 0x0C, 0xE0, 0x57, 0x77,
  0x70, 0x8E, 0x08, 0x77, 0x77, 0x04, 0xE0, 0xA7, 0x77, 0x70, 0x2E, 0x0B, 0x77, 0x77, 0x01, 0xE0,
  0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0,
  0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0,
  0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0,
  0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0,
  0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0,
  0xC7, 0x77, 0x71, 0xE0, 0xD7, 0x77, 0x71, 0x0E, 0xD0, 0xE7, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77,
  0x70, 0xBE, 0x04, 0x77, 0x77, 0x07, 0xE0, 0x87, 0x77, 0x70, 0x3E, 0x0D, 0x77, 0x77, 0x10, 0xEE,
  0x05, 0x77, 0x77, 0x07, 0xE0, 0xE0, 0x17, 0x77, 0x60, 0x10, 0xEE, 0x0C, 0x01, 0x77, 0x76, 0x05,
  0xF0, 0xD0, 0x47, 0x77, 0x60, 0x8F, 0x90, 0xB0, 0x57, 0x77, 0x50, 0x8F, 0xA8, 0x5E, 0xB8, 0x65,
  0x32, 0x77, 0x60, 0x40, 0xCF, 0xE0, 0xB7, 0x77, 0x18, 0x14, 0xAE, 0xFB, 0x0B, 0x77, 0x74, 0x03,
  0x0D, 0xF9, 0x0B, 0x77, 0x71, 0x82, 0x16, 0xBE, 0xFA, 0x0B, 0x77, 0x60, 0x10, 0x8F, 0xE0, 0xB7,
  0x75, 0x04, 0x0E, 0xFB, 0x83, 0xCA, 0x97, 0x57, 0x74, 0x05, 0xF9, 0x81, 0xE9, 0x47, 0x77, 0x20,
  0x3F, 0x90, 0x80, 0x17, 0x77, 0x40, 0xCE, 0x0E, 0x04, 0x77, 0x75, 0x05, 0xF0, 0x37, 0x77, 0x60,
  0xCE, 0x08, 0x77, 0x76, 0x02, 0xE0, 0xE0, 0x17, 0x77, 0x60, 0x6E, 0x09, 0x77, 0x77, 0x0A, 0xE0,
  0x57, 0x77, 0x70, 0xCE, 0x01, 0x77, 0x77, 0x0E, 0xD0, 0xE7, 0x77, 0x71, 0xE0, 0xD7, 0x77, 0x71,
  0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71,
  0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71,
  0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71,
  0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71,
  0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x71, 0xE0, 0xC7, 0x77, 0x70,
  0x1E, 0x0C, 0x77, 0x77, 0x02, 0xE0, 0xB7, 0x77, 0x70, 0x3E, 0x0A, 0x77, 0x77, 0x06, 0xE0, 0x87,
  0x77, 0x70, 0xBE, 0x06, 0x77, 0x76, 0x01, 0xF0, 0x27, 0x77, 0x60, 0x8E, 0x0E, 0x77, 0x76, 0x03,
  0xF0, 0x87, 0x77, 0x50, 0x30, 0xEF, 0x02, 0x77, 0x74, 0x06, 0x0E, 0xF0, 0x97, 0x77, 0x30, 0x50,
  0xCF, 0x90, 0xD7, 0x76, 0x83, 0x13, 0x6A, 0xEF, 0xA0, 0xE0, 0x27, 0x73, 0x0B, 0x0D, 0xFF, 0x0E,
  0x03, 0x77, 0x40, 0xEF, 0xF0, 0xD0, 0x27, 0x75, 0x0E, 0xFE, 0x08, 0x77, 0x70, 0xEF, 0xC0, 0x90,
  0x27, 0x77, 0x10, 0xEF, 0x98, 0x1B, 0x61, 0x77, 0x73, 0x0F, 0xD8, 0x3C, 0xB8, 0x63, 0x77, 0x77,
  // "~" (U+007E)
  0x72, 0x89, 0x33, 0x7A, 0xCD, 0xED, 0xDC, 0xB8, 0x51, 0x80, 0xC5, 0x08, 0x12, 0x8E, 0xFE, 0x81,
  0xD8, 0x27, 0x77, 0x72, 0x09, 0x02, 0x40, 0x20, 0xAF, 0xFD, 0x0C, 0x06, 0x77, 0x76, 0x81, 0xAF,
  0x23, 0x07, 0xFF, 0xFA, 0x81, 0xE8, 0x27, 0x77, 0x10, 0x10, 0xCA, 0x82, 0x20, 0x1B, 0xFF, 0xFE,
  0x0A, 0x04, 0x77, 0x50, 0x60, 0xEB, 0x81, 0x21, 0xDF, 0xB8, 0x3D, 0xDC, 0xDE, 0xFF, 0x98, 0x1D,
  0x61, 0x77, 0x04, 0x0C, 0xD0, 0x20, 0x9F, 0x82, 0xD8, 0x41, 0x68, 0x13, 0x7B, 0xFF, 0x81, 0xB5,
  0x17, 0x18, 0x12, 0x7D, 0xF0, 0x20, 0x9D, 0x0D, 0x05, 0x76, 0x81, 0x16, 0xCF, 0xF8, 0x6D, 0xB9,
  0x77, 0x9A, 0xDF, 0xA8, 0x19, 0x09, 0xC0, 0x77, 0x74, 0x03, 0x0A, 0xFF, 0xFF, 0x09, 0x20, 0x9A,
  0x0C, 0x02, 0x77, 0x78, 0x12, 0x8E, 0xFF, 0xFA, 0x0E, 0x06, 0x38, 0x19, 0xFB, 0x77, 0x75, 0x05,
  0x0B, 0xFF, 0xE0, 0xB0, 0x24, 0x00, 0x97, 0x77, 0x71, 0x81, 0x17, 0xCF, 0xF9, 0x0B, 0x03, 0x60,
  0x47, 0x77, 0x75, 0x82, 0x26, 0xAD, 0xF8, 0x2E, 0xB7, 0x18, 0x0D, 0x30, 0x84, 0x12, 0x33, 0x11,
  0x75,
  // "¡" (U+00A1)
  0x28, 0x51, 0x8C, 0xDD, 0xA4, 0x30, 0x30, 0xEE, 0x08, 0x20, 0xDF, 0x90, 0x30, 0x4F, 0xA0, 0x90,
  0x8F, 0xA0, 0xC0, 0x9F, 0xA0, 0xD0, 0x9F, 0xA0, 0xD0, 0x8F, 0xA0, 0xC0, 0x4F, 0xA8, 0x19, 0x0D,
  0xF9, 0x82, 0x30, 0x3E, 0xE0, 0x83, 0x85, 0x29, 0xCE, 0xDB, 0x58, 0x0A, 0x85, 0x00, 0xDC, 0x60,
  0xEC, 0x01, 0x50, 0xEC, 0x01, 0x50, 0xEC, 0x02, 0x5D, 0x02, 0x5D, 0x03, 0x5D, 0x03, 0x40, 0x1D,
  0x03, 0x40, 0x1D, 0x04, 0x40, 0x1D, 0x04, 0x40, 0x2D, 0x05, 0x40, 0x2D, 0x05, 0x40, 0x2D, 0x05,
  0x40, 0x3D, 0x06, 0x40, 0x3D, 0x06, 0x40, 0x4D, 0x07, 0x40, 0x4D, 0x07, 0x40, 0x4D, 0x07, 0x40,
  0x5D, 0x08, 0x40, 0x5D, 0x08, 0x40, 0x5D, 0x09, 0x40, 0x6D, 0x09, 0x40, 0x6D, 0x09, 0x40, 0x7D,
  0x0A, 0x40, 0x7D, 0x0A, 0x40, 0x7D, 0x0B, 0x40, 0x8D, 0x0B, 0x40, 0x8D, 0x0C, 0x40, 0x9D, 0x0C,
  0x40, 0x9D, 0x0C, 0x40, 0x9D, 0x0D, 0x40, 0xAD, 0x0D, 0x40, 0xAD, 0x0E, 0x40, 0xAD, 0x0E, 0x40,
  0xBD, 0x0E, 0x40, 0xBE, 0x40, 0xCE, 0x40, 0xCE, 0x40, 0xCE, 0x01, 0x30, 0xDE, 0x01, 0x30, 0xDE,
  0x01, 0x30, 0xDE, 0x02, 0x30, 0xEE, 0x02, 0x30, 0xEE, 0x03, 0x3F, 0x03, 0x3F, 0x03, 0x3F, 0x04,
  0x3F, 0x04, 0x20, 0x1F, 0x05, 0x20, 0x1F, 0x05, 0x20, 0x1F, 0x05, 0x20, 0x2F, 0x06, 0x20, 0x2F,
  0x06, 0x20, 0x3F, 0x07, 0x20, 0x3F, 0x07, 0x20, 0x3F, 0x08, 0x20, 0x4F, 0x08, 0x20, 0x4F, 0x08,
  0x20, 0x5F, 0x09, 0x20, 0x5F, 0x09, 0x20, 0x5F, 0x0A, 0x20, 0x6F, 0x0A, 0x20, 0x6F, 0x0A, 0x38,
  0x04, 0x11,
  // "¢" (U+00A2)
  0x77, 0x74, 0x01, 0x80, 0x1D, 0x07, 0x80, 0xC4, 0x00, 0x1D, 0x07, 0x80, 0xC4, 0x00, 0x1D, 0x07,
  0x80, 0xC4, 0x00, 0x1D, 0x07, 0x80, 0xC4, 0x00, 0x1D, 0x07, 0x80, 0xC4, 0x00, 0x1D, 0x07, 0x80,
  0xC4, 0x00, 0x1D, 0x07, 0x80, 0xC4, 0x00, 0x1D, 0x07, 0x80, 0xC4, 0x00, 0x1D, 0x07, 0x80, 0xC4,
  0x00, 0x1D, 0x07, 0x80, 0xC2, 0x08, 0x12, 0x58, 0xD8, 0x6E, 0xDD, 0xB9, 0x86, 0x37, 0x77, 0x68,
  0x21, 0x6A, 0xEF, 0xFB, 0x81, 0xC9, 0x57, 0x77, 0x05, 0x0B, 0xFF, 0xFC, 0x0A, 0x05, 0x77, 0x20,
  0x60, 0xDF, 0xFF, 0xF9, 0x0D, 0x76, 0x03, 0x0C, 0xFF, 0xFF, 0xB0, 0xB7, 0x50, 0x8F, 0xFF, 0xFD,
  0x06, 0x73, 0x01, 0x0B, 0xFD, 0x89, 0x5E, 0xA8, 0x64, 0x33, 0x33, 0x55, 0x8A, 0xCE, 0xF0, 0x17,
  0x20, 0x10, 0xDF, 0xB8, 0x1D, 0x73, 0x77, 0x18, 0x13, 0x7B, 0xB0, 0xC7, 0x20, 0x10, 0xDF, 0xA0,
  0xC0, 0x47, 0x77, 0x82, 0x16, 0xC7, 0x71, 0x01, 0x0C, 0xF9, 0x0E, 0x05, 0x77, 0x77, 0x70, 0xBF,
  0x90, 0xB0, 0x17, 0x77, 0x77, 0x07, 0xF9, 0x08, 0x80, 0xC0, 0x00, 0x3F, 0x90, 0x88, 0x0C, 0x10,
  0x0C, 0xF0, 0x98, 0x0C, 0x10, 0x05, 0xF0, 0xC8, 0x0C, 0x20, 0x0D, 0xF0, 0x28, 0x0C, 0x10, 0x05,
  0xF0, 0x88, 0x0C, 0x20, 0x0B, 0xE0, 0xD8, 0x0C, 0x20, 0x01, 0xF0, 0x78, 0x0C, 0x20, 0x07, 0xE0,
  0xE8, 0x0C, 0x30, 0x0B, 0xE0, 0x98, 0x0C, 0x30, 0xF0, 0x48, 0x0C, 0x20, 0x04, 0xE0, 0xE8, 0x0C,
  0x30, 0x07, 0xE0, 0xA8, 0x0C, 0x30, 0x0A, 0xE0, 0x68, 0x0C, 0x30, 0x0D, 0xE0, 0x38, 0x0C, 0x30,
  0xF0, 0x18, 0x0C, 0x20, 0x01, 0xE0, 0xE8, 0x0C, 0x30, 0x03, 0xE0, 0xC8, 0x0C, 0x30, 0x04, 0xE0,
  0xA8, 0x0C, 0x30, 0x05, 0xE0, 0x98, 0x0C, 0x30, 0x05, 0xE0, 0x98, 0x0C, 0x30, 0x06, 0xE0, 0x88,
  0x0C, 0x30, 0x06, 0xE0, 0x88, 0x0C, 0x30, 0x06, 0xE0, 0x88, 0x0C, 0x30, 0x05, 0xE0, 0x88, 0x0C,
  0x30, 0x05, 0xE0, 0x98, 0x0C, 0x30, 0x04, 0xE0, 0xA8, 0x0C, 0x30, 0x03, 0xE0, 0xB8, 0x0C, 0x30,
  0x02, 0xE0, 0xD8, 0x0C, 0x40, 0xF8, 0x0C, 0x40, 0x0D, 0xE0, 0x28, 0x0C, 0x30, 0x0B, 0xE0, 0x58,
  0x0C, 0x30, 0x08, 0xE0, 0x98, 0x0C, 0x30, 0x05, 0xE0, 0xC8, 0x0C, 0x30, 0x01, 0xF0, 0x28, 0x0C,
  0x30, 0x0D, 0xE0, 0x78, 0x0C, 0x30, 0x09, 0xE0, 0xC8, 0x0C, 0x30, 0x04, 0xF0, 0x48, 0x0C, 0x30,
  0x0E, 0xE0, 0xB8, 0x0C, 0x30, 0x08, 0xF0, 0x48, 0x0C, 0x20, 0x01, 0xF0, 0xC8, 0x0C, 0x30, 0x09,
  0xF0, 0x88, 0x0C, 0x20, 0x01, 0x0E, 0xF0, 0x48, 0x0C, 0x20, 0x08, 0xF0, 0xE0, 0x38, 0x0C, 0x20,
  0x0C, 0xF0, 0xE0, 0x48, 0x0C, 0x10, 0x02, 0xFA, 0x07, 0x80, 0xC1, 0x00, 0x5F, 0xA0, 0xC0, 0x47,
  0x77, 0x38, 0x21, 0x6C, 0x67, 0x10, 0x7F, 0xB0, 0xB0, 0x57, 0x75, 0x81, 0x16, 0xBB, 0x06, 0x72,
  0x06, 0xFC, 0x83, 0xEA, 0x74, 0x17, 0x28, 0x32, 0x47, 0xAD, 0xE0, 0x67, 0x30, 0x50, 0xEF, 0xF9,
  0x85, 0xDD, 0xCC, 0xDD, 0xEF, 0xD0, 0x67, 0x40, 0x20, 0xCF, 0xFF, 0xFD, 0x06, 0x76, 0x07, 0x0E,
  0xFF, 0xFF, 0xB0, 0x67, 0x78, 0x11, 0x8E, 0xFF, 0xFE, 0x81, 0xC6, 0x17, 0x73, 0x05, 0x0B, 0xFF,
  0xF9, 0x81, 0xB7, 0x27, 0x77, 0x28, 0x24, 0x8B, 0xDF, 0xD8, 0x3E, 0xB8, 0x51, 0x77, 0x77, 0x30,
  0x3D, 0x83, 0x95, 0x42, 0x18, 0x0C, 0x00, 0x01, 0xD0, 0x68, 0x0C, 0x40, 0x01, 0xD0, 0x68, 0x0C,
  0x40, 0x01, 0xD0, 0x68, 0x0C, 0x40, 0x01, 0xD0, 0x68, 0x0C, 0x40, 0x01, 0xD0, 0x68, 0x0C, 0x40,
  0x01, 0xD0, 0x68, 0x0C, 0x40, 0x01, 0xD0, 0x68, 0x0C, 0x40, 0x01, 0xD0, 0x68, 0x0C, 0x40, 0x01,
  0xD0, 0x68, 0x0C, 0x40, 0x01, 0xD0, 0x68, 0x0C, 0x40, 0x01, 0xD0, 0x68, 0x0C, 0x50, 0x80, 0x13,
  0x01, 0x77, 0x10,
  // "£" (U+00A3)
  0x77, 0x77, 0x28, 0x32, 0x57, 0x9A, 0x80, 0x1B, 0x83, 0x98, 0x74, 0x28, 0x0C, 0x60, 0x81, 0x5A,
  0xEF, 0xFA, 0x81, 0xC8, 0x47, 0x77, 0x77, 0x81, 0x18, 0xEF, 0xFF, 0xA8, 0x1B, 0x51, 0x77, 0x77,
  0x20, 0x70, 0xEF, 0xFF, 0xF0, 0xA0, 0x47, 0x77, 0x50, 0x20, 0xCF, 0xFF, 0xFC, 0x0C, 0x77, 0x73,
  0x04, 0x0E, 0xFF, 0xFF, 0xD0, 0xA7, 0x77, 0x20, 0x4F, 0xB8, 0x95, 0xEB, 0x75, 0x32, 0x11, 0x23,
  0x56, 0x9B, 0xEF, 0xB0, 0x47, 0x77, 0x10, 0x30, 0xEF, 0x90, 0xB0, 0x57, 0x71, 0x81, 0x38, 0xDE,
  0x0D, 0x77, 0x71, 0x01, 0x0D, 0xF0, 0xD0, 0x47, 0x76, 0x81, 0x27, 0xDB, 0x06, 0x77, 0x71, 0x0A,
  0xF0, 0xB0, 0x17, 0x77, 0x38, 0x14, 0xAE, 0x77, 0x71, 0x03, 0xF0, 0xB8, 0x0D, 0x70, 0x0B, 0xE0,
  0xD0, 0x18, 0x0D, 0x60, 0x03, 0xF0, 0x48, 0x0D, 0x70, 0x09, 0xE0, 0xB8, 0x0E, 0x00, 0x0E, 0xE0,
  0x48, 0x0D, 0x70, 0x03, 0xE0, 0xD8, 0x0E, 0x00, 0x07, 0xE0, 0x98, 0x0E, 0x00, 0x0A, 0xE0, 0x58,
  0x0E, 0x00, 0x0C, 0xE0, 0x28, 0x0E, 0x00, 0x0E, 0xD0, 0xE8, 0x0E, 0x00, 0x01, 0xE0, 0xC8, 0x0E,
  0x00, 0x02, 0xE0, 0xB8, 0x0E, 0x00, 0x02, 0xE0, 0xA8, 0x0E, 0x00, 0x03, 0xE0, 0x98, 0x0E, 0x00,
  0x03, 0xE0, 0x98, 0x0E, 0x00, 0x03, 0xE0, 0x98, 0x0E, 0x00, 0x03, 0xE0, 0x98, 0x0E, 0x00, 0x03,
  0xE0, 0x98, 0x0E, 0x00, 0x03, 0xE0, 0x98, 0x0E, 0x00, 0x03, 0xE0, 0x98, 0x0E, 0x00, 0x03, 0xE0,
  0x98, 0x0E, 0x00, 0x03, 0xE0, 0x98, 0x0E, 0x00, 0x03, 0xE0, 0x98, 0x0E, 0x00, 0x03, 0xE0, 0x98,
  0x0E, 0x00, 0x03, 0xE0, 0x98, 0x0E, 0x00, 0x03, 0xE0, 0x98, 0x0E, 0x00, 0x03, 0xE0, 0x98, 0x0E,
  0x00, 0x03, 0xE0, 0x98, 0x0E, 0x00, 0x03, 0xE0, 0x98, 0x0E, 0x00, 0x03, 0xE0, 0x98, 0x0E, 0x00,
  0x03, 0xE0, 0x98, 0x0E, 0x00, 0x03, 0xE0, 0x98, 0x0C, 0x40, 0x04, 0x80, 0x7B, 0x0C, 0xE0, 0xD8,
  0x0A, 0x3B, 0x08, 0x77, 0x20, 0x58, 0x0C, 0x6F, 0x0B, 0x77, 0x20, 0x58, 0x0C, 0x6F, 0x0B, 0x77,
  0x20, 0x58, 0x0C, 0x6F, 0x0B, 0x77, 0x20, 0x58, 0x0C, 0x6F, 0x0B, 0x77, 0x20, 0x38, 0x07, 0x90,
  0xBE, 0x0D, 0x80, 0xA3, 0x90, 0x67, 0x77, 0x70, 0x3E, 0x09, 0x80, 0xE0, 0x00, 0x3E, 0x09, 0x80,
  0xE0, 0x00, 0x3E, 0x09, 0x80, 0xE0, 0x00, 0x3E, 0x09, 0x80, 0xE0, 0x00, 0x3E, 0x09, 0x80, 0xE0,
  0x00, 0x3E, 0x09, 0x80, 0xE0, 0x00, 0x3E, 0x09, 0x80, 0xE0, 0x00, 0x3E, 0x09, 0x80, 0xE0, 0x00,
  0x3E, 0x09, 0x80, 0xE0, 0x00, 0x3E, 0x09, 0x80, 0xE0, 0x00, 0x3E, 0x09, 0x80, 0xE0, 0x00, 0x3E,
  0x09, 0x80, 0xE0, 0x00, 0x3E, 0x09, 0x80, 0xE0, 0x00, 0x3E, 0x09, 0x80, 0xE0, 0x00, 0x3E, 0x09,
  0x80, 0xE0, 0x00, 0x3E, 0x08, 0x80, 0xE0, 0x00, 0x4E, 0x08, 0x80, 0xE0, 0x00, 0x5E, 0x07, 0x80,
  0xE0, 0x00, 0x6E, 0x06, 0x80, 0xE0, 0x00, 0x8E, 0x04, 0x80, 0xE0, 0x00, 0xBE, 0x02, 0x80, 0xE0,
  0x00, 0xED, 0x0E, 0x80, 0xE0, 0x00, 0x3E, 0x0B, 0x80, 0xE0, 0x00, 0x8E, 0x06, 0x80, 0xE0, 0x00,
  0xDE, 0x01, 0x80, 0xD7, 0x00, 0x5E, 0x0A, 0x80, 0xE0, 0x00, 0xDE, 0x02, 0x80, 0xD7, 0x00, 0xAE,
  0x07, 0x80, 0xD7, 0x00, 0x8E, 0x0B, 0x80, 0xD7, 0x00, 0x8E, 0x0C, 0x80, 0xD6, 0x00, 0x10, 0xBE,
  0x0C, 0x01, 0x80, 0xD5, 0x00, 0x70, 0xEE, 0x09, 0x80, 0xD4, 0x08, 0x14, 0x9E, 0xF0, 0x88, 0x0D,
  0x23, 0x10, 0x78, 0x0E, 0x6F, 0x01, 0x08, 0x80, 0xE6, 0xF0, 0x10, 0x88, 0x0E, 0x6F, 0x01, 0x08,
  0x80, 0xE6, 0xF0, 0x10, 0x88, 0x0E, 0x6F, 0x01, 0x08, 0x80, 0xE6, 0xF0, 0x10,
  // "¤" (U+00A4)
  0x30, 0x40, 0x18, 0x0D, 0x10, 0x05, 0x68, 0x24, 0xFC, 0x18, 0x0C, 0x70, 0x81, 0x7F, 0x94, 0x05,
  0xB0, 0xC0, 0x18, 0x0C, 0x50, 0x08, 0xB0, 0x92, 0x05, 0xD0, 0xD0, 0x17, 0x72, 0x84, 0x11, 0x33,
  0x21, 0x77, 0x30, 0x8D, 0x81, 0x90, 0xBE, 0x0D, 0x01, 0x74, 0x82, 0x48, 0xCE, 0xF8, 0x2C, 0x95,
  0x17, 0x40, 0x8E, 0x82, 0xD1, 0x0B, 0xE0, 0xD0, 0x17, 0x03, 0x0A, 0xFF, 0xA0, 0xB0, 0x57, 0x10,
  0x8E, 0x0E, 0x02, 0x30, 0xBE, 0x0D, 0x01, 0x40, 0x30, 0xBF, 0xFE, 0x0D, 0x05, 0x50, 0x9E, 0x0E,
  0x02, 0x50, 0xBE, 0x0D, 0x01, 0x20, 0x8F, 0xFF, 0xB0, 0xB0, 0x22, 0x09, 0xE0, 0xE0, 0x27, 0x0B,
  0xE8, 0x1D, 0x4C, 0xFF, 0xFD, 0x81, 0xE6, 0x9E, 0x0E, 0x02, 0x72, 0x0B, 0xFF, 0x98, 0x92, 0xEA,
  0x64, 0x11, 0x11, 0x25, 0x8C, 0xFF, 0x90, 0xE0, 0x37, 0x40, 0xBF, 0xD0, 0xB0, 0x47, 0x58, 0x12,
  0x8E, 0xFC, 0x0E, 0x03, 0x76, 0x0B, 0xFA, 0x0C, 0x03, 0x77, 0x20, 0x10, 0x8F, 0xA0, 0xE0, 0x37,
  0x71, 0x0B, 0xF0, 0x77, 0x76, 0x03, 0x0D, 0xE0, 0xE0, 0x37, 0x72, 0x0C, 0xD0, 0xE0, 0x47, 0x77,
  0x20, 0xBE, 0x04, 0x77, 0x10, 0x9D, 0x0E, 0x02, 0x77, 0x74, 0x0A, 0xD0, 0xE0, 0x17, 0x60, 0x3E,
  0x03, 0x77, 0x76, 0x0B, 0xD0, 0xA7, 0x60, 0xCD, 0x06, 0x77, 0x77, 0x01, 0x0D, 0xD0, 0x47, 0x40,
  0x4D, 0x0B, 0x77, 0x77, 0x20, 0x4D, 0x0C, 0x74, 0x0B, 0xD0, 0x27, 0x77, 0x73, 0x09, 0xD0, 0x37,
  0x20, 0x2D, 0x09, 0x77, 0x77, 0x40, 0x1D, 0x0A, 0x72, 0x07, 0xD0, 0x27, 0x77, 0x75, 0x09, 0xC0,
  0xE7, 0x20, 0xCC, 0x0C, 0x77, 0x77, 0x60, 0x3D, 0x04, 0x71, 0xD0, 0x77, 0x77, 0x77, 0x0D, 0xC0,
  0x87, 0x03, 0xD0, 0x47, 0x77, 0x77, 0x0A, 0xC0, 0xB7, 0x05, 0xD0, 0x17, 0x77, 0x77, 0x07, 0xC0,
  0xD7, 0x07, 0xC0, 0xE8, 0x0C, 0x00, 0x05, 0xD7, 0x08, 0xC0, 0xE8, 0x0C, 0x00, 0x04, 0xD7, 0x08,
  0xC0, 0xD8, 0x0C, 0x00, 0x03, 0xD0, 0x16, 0x08, 0xC0, 0xD8, 0x0C, 0x00, 0x04, 0xD7, 0x07, 0xC0,
  0xE8, 0x0C, 0x00, 0x05, 0xD7, 0x05, 0xD0, 0x17, 0x77, 0x77, 0x07, 0xC0, 0xD7, 0x03, 0xD0, 0x47,
  0x77, 0x77, 0x0A, 0xC0, 0xB7, 0x1D, 0x07, 0x77, 0x77, 0x70, 0xDC, 0x08, 0x71, 0x0C, 0xC0, 0xC7,
  0x77, 0x76, 0x03, 0xD0, 0x57, 0x10, 0x8D, 0x01, 0x77, 0x77, 0x50, 0x9D, 0x72, 0x03, 0xD0, 0x87,
  0x77, 0x74, 0x01, 0x0E, 0xC0, 0xA7, 0x30, 0xCC, 0x0E, 0x01, 0x77, 0x77, 0x30, 0x9D, 0x04, 0x73,
  0x05, 0xD0, 0x97, 0x77, 0x72, 0x03, 0xD0, 0xD7, 0x50, 0xDD, 0x04, 0x77, 0x77, 0x10, 0xDD, 0x05,
  0x75, 0x04, 0xD0, 0xE0, 0x27, 0x77, 0x60, 0xBD, 0x0C, 0x77, 0x0A, 0xD0, 0xD0, 0x17, 0x77, 0x40,
  0xAE, 0x02, 0x77, 0x01, 0x0D, 0xD0, 0xD0, 0x27, 0x77, 0x20, 0xBE, 0x07, 0x77, 0x20, 0xAE, 0x0E,
  0x05, 0x77, 0x60, 0x30, 0xDE, 0x0E, 0x01, 0x77, 0x10, 0x9F, 0xA0, 0xA0, 0x17, 0x72, 0x01, 0x08,
  0xFA, 0x0C, 0x01, 0x76, 0x09, 0xFD, 0x09, 0x02, 0x75, 0x81, 0x28, 0xEF, 0xC0, 0xC0, 0x17, 0x40,
  0x9F, 0xF9, 0x83, 0xD8, 0x52, 0x12, 0x83, 0x12, 0x58, 0xCF, 0xF9, 0x0C, 0x73, 0x09, 0xE8, 0x1E,
  0x6E, 0xFF, 0xFE, 0x08, 0x0B, 0xE0, 0xC7, 0x10, 0x9E, 0x83, 0xE3, 0x01, 0xAF, 0xFF, 0xB0, 0xD0,
  0x42, 0x0B, 0xE0, 0xB6, 0x09, 0xE0, 0xE0, 0x24, 0x04, 0x0C, 0xFF, 0xE0, 0xE0, 0x85, 0x0B, 0xE0,
  0xB4, 0x09, 0xE0, 0xE0, 0x27, 0x04, 0x0A, 0xFF, 0xA8, 0x1D, 0x71, 0x70, 0xBE, 0x0B, 0x20, 0x9E,
  0x0D, 0x02, 0x73, 0x82, 0x15, 0x9C, 0xF9, 0x82, 0xEB, 0x73, 0x74, 0x0A, 0xE8, 0x1B, 0x06, 0xD0,
  0xD0, 0x27, 0x72, 0x84, 0x13, 0x33, 0x32, 0x77, 0x30, 0xAD, 0x82, 0xC1, 0x06, 0xB0, 0xD0, 0x18,
  0x0C, 0x50, 0x0A, 0xB0, 0xC0, 0x13, 0x82, 0x6F, 0xD1, 0x80, 0xC7, 0x08, 0x2A, 0xFC, 0x15, 0x05,
  0x01, 0x80, 0xD1, 0x00, 0x70, 0x13,
  // "¥" (U+00A5)
  0x04, 0x80, 0x2B, 0x0A, 0x80, 0xD4, 0x00, 0x58, 0x02, 0xB8, 0x19, 0x0D, 0xE0, 0x58, 0x0D, 0x30,
  0x0E, 0xE8, 0x14, 0x05, 0xE0, 0xD8, 0x0D, 0x20, 0x08, 0xE0, 0xB3, 0x0C, 0xE0, 0x78, 0x0D, 0x00,
  0x01, 0xF0, 0x23, 0x03, 0xE0, 0xE0, 0x18, 0x0C, 0x70, 0x0A, 0xE0, 0x95, 0x09, 0xE0, 0x98, 0x0C,
  0x60, 0x03, 0xE0, 0xE0, 0x15, 0x01, 0x0E, 0xE0, 0x38, 0x0C, 0x50, 0x0B, 0xE0, 0x67, 0x07, 0xE0,
  0xB8, 0x0C, 0x40, 0x05, 0xE0, 0xD7, 0x20, 0xDE, 0x05, 0x80, 0xC3, 0x00, 0xDE, 0x04, 0x72, 0x05,
  0xE0, 0xD8, 0x0C, 0x20, 0x06, 0xE0, 0xB7, 0x40, 0xCE, 0x07, 0x80, 0xC0, 0x00, 0x10, 0xEE, 0x02,
  0x74, 0x03, 0xE0, 0xE0, 0x17, 0x77, 0x77, 0x08, 0xE0, 0x87, 0x60, 0xAE, 0x08, 0x77, 0x77, 0x60,
  0x2E, 0x0E, 0x01, 0x76, 0x01, 0x0E, 0xE0, 0x27, 0x77, 0x75, 0x0A, 0xE0, 0x67, 0x71, 0x08, 0xE0,
  0xA7, 0x77, 0x74, 0x03, 0xE0, 0xC7, 0x73, 0x0D, 0xE0, 0x47, 0x77, 0x73, 0x0C, 0xE0, 0x47, 0x73,
  0x05, 0xE0, 0xC7, 0x77, 0x72, 0x05, 0xE0, 0xA7, 0x75, 0x0C, 0xE0, 0x67, 0x77, 0x71, 0x0D, 0xE0,
  0x27, 0x75, 0x03, 0xE0, 0xE7, 0x77, 0x70, 0x7E, 0x08, 0x77, 0x70, 0xAE, 0x08, 0x77, 0x75, 0x01,
  0x0E, 0xD0, 0xE7, 0x77, 0x10, 0x2E, 0x0E, 0x01, 0x77, 0x74, 0x08, 0xE0, 0x67, 0x77, 0x20, 0x8E,
  0x09, 0x77, 0x73, 0x02, 0xE0, 0xC7, 0x77, 0x40, 0xEE, 0x03, 0x77, 0x72, 0x0A, 0xE0, 0x37, 0x77,
  0x40, 0x6E, 0x0B, 0x77, 0x71, 0x03, 0xE0, 0xA7, 0x77, 0x60, 0xCE, 0x05, 0x77, 0x70, 0xCE, 0x02,
  0x77, 0x76, 0x04, 0xE0, 0xD7, 0x76, 0x05, 0xE0, 0x87, 0x77, 0x71, 0x0A, 0xE0, 0x77, 0x75, 0x0D,
  0xD0, 0xE7, 0x77, 0x72, 0x02, 0xE0, 0xE0, 0x17, 0x73, 0x07, 0xE0, 0x57, 0x77, 0x73, 0x08, 0xE0,
  0x97, 0x72, 0x01, 0x0E, 0xD0, 0xC7, 0x77, 0x74, 0x01, 0x0E, 0xE0, 0x27, 0x71, 0x09, 0xE0, 0x37,
  0x77, 0x75, 0x06, 0xE0, 0xB7, 0x70, 0x2E, 0x0A, 0x77, 0x77, 0x70, 0xCE, 0x04, 0x76, 0x0B, 0xD0,
  0xE0, 0x17, 0x77, 0x77, 0x04, 0xE0, 0xC7, 0x50, 0x4E, 0x07, 0x80, 0xC1, 0x00, 0xBE, 0x06, 0x74,
  0x0C, 0xD0, 0xD8, 0x0C, 0x20, 0x02, 0xE0, 0xE7, 0x30, 0x5E, 0x05, 0x80, 0xC3, 0x00, 0x8E, 0x08,
  0x72, 0x0D, 0xD0, 0xC8, 0x0C, 0x40, 0x01, 0x0E, 0xE0, 0x17, 0x07, 0xE0, 0x38, 0x0C, 0x50, 0x06,
  0xE0, 0xA6, 0x01, 0x0E, 0xD0, 0x98, 0x0C, 0x70, 0x0D, 0xE0, 0x35, 0x09, 0xD0, 0xE0, 0x18, 0x0C,
  0x70, 0x04, 0xE0, 0xB4, 0x02, 0xE0, 0x78, 0x0D, 0x10, 0x0B, 0xE0, 0x53, 0x0B, 0xD0, 0xD8, 0x0D,
  0x20, 0x02, 0xE0, 0xD2, 0x04, 0xE0, 0x58, 0x0D, 0x30, 0x09, 0xE8, 0x17, 0x0C, 0xD0, 0xB8, 0x0D,
  0x40, 0x01, 0x0E, 0xD0, 0xE0, 0x7E, 0x03, 0x80, 0xD5, 0x00, 0x7F, 0xD0, 0x98, 0x0D, 0x70, 0x0D,
  0xFB, 0x0E, 0x01, 0x77, 0x77, 0x60, 0x88, 0x09, 0x4B, 0x0D, 0xFB, 0x0E, 0x80, 0x95, 0xB0, 0x17,
  0x73, 0x0B, 0x80, 0xD1, 0xF0, 0x17, 0x73, 0x0B, 0x80, 0xD1, 0xF0, 0x17, 0x73, 0x0B, 0x80, 0xD1,
  0xF0, 0x17, 0x73, 0x0B, 0x80, 0xD1, 0xF0, 0x17, 0x73, 0x06, 0x80, 0x97, 0x9E, 0x0D, 0x80, 0x97,
  0x90, 0x18, 0x0C, 0x10, 0xE0, 0xA8, 0x0E, 0x50, 0xE0, 0xA8, 0x0E, 0x50, 0xE0, 0xA8, 0x0E, 0x50,
  0xE0, 0xA8, 0x0E, 0x50, 0xE0, 0xA8, 0x0E, 0x50, 0xE0, 0xA8, 0x0E, 0x50, 0xE0, 0xA8, 0x0E, 0x50,
  0xE0, 0xA8, 0x0E, 0x50, 0xE0, 0xA8, 0x0E, 0x50, 0xE0, 0xA8, 0x0E, 0x50, 0xE0, 0xA8, 0x0C, 0x10,
  0x08, 0x80, 0x97, 0xBE, 0x0E, 0x80, 0x97, 0xB0, 0x17, 0x73, 0x0B, 0x80, 0xD1, 0xF0, 0x17, 0x73,
  0x0B, 0x80, 0xD1, 0xF0, 0x17, 0x73, 0x0B, 0x80, 0xD1, 0xF0, 0x17, 0x73, 0x0B, 0x80, 0xD1, 0xF0,
  0x17, 0x73, 0x05, 0x80, 0x96, 0x70, 0x8E, 0x0D, 0x80, 0x97, 0x70, 0x18, 0x0C, 0x10, 0xE0, 0xA8,
  0x0E, 0x50, 0xE0, 0xA8, 0x0E, 0x50, 0xE0, 0xA8, 0x0E, 0x50, 0xE0, 0xA8, 0x0E, 0x50, 0xE0, 0xA8,
  0x0E, 0x50, 0xE0, 0xA8, 0x0E, 0x50, 0xE0, 0xA8, 0x0E, 0x50, 0xE0, 0xA8, 0x0E, 0x50, 0xE0, 0xA8,
  0x0E, 0x50, 0xE0, 0xA8, 0x0E, 0x50, 0xE0, 0xA8, 0x0E, 0x50, 0xE0, 0xA8, 0x0E, 0x50, 0xE0, 0xA8,
  0x0E, 0x50, 0xE0, 0xA8, 0x0E, 0x50, 0xE0, 0xA8, 0x0E, 0x50, 0xE0, 0xA8, 0x0E, 0x50, 0xE0, 0xA7,
  0x77, 0x70,
  // "¦" (U+00A6)
  0x03, 0x80, 0x17, 0x03, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0,
  0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60,
  0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D,
  0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06,
  0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07,
  0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0,
  0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60,
  0x7D, 0x06, 0x03, 0x80, 0x17, 0x03, 0x80, 0xB9, 0x60, 0x03, 0x80, 0x17, 0x03, 0x07, 0xD0, 0x60,
  0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D,
  0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06,
  0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07,
  0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0,
  0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60,
  0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D,
  0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x07, 0xD0, 0x60, 0x7D, 0x06, 0x03, 0x80, 0x17, 0x03,
  // "§" (U+00A7)
  0x77, 0x58, 0x12, 0x34, 0x80, 0x25, 0x81, 0x43, 0x27, 0x77, 0x71, 0x82, 0x26, 0xAD, 0xFF, 0x83,
  0xEB, 0x85, 0x17, 0x76, 0x81, 0x17, 0xDF, 0xFF, 0xA8, 0x1D, 0x94, 0x77, 0x10, 0x10, 0x9F, 0xFF,
  0xF9, 0x81, 0xEA, 0x47, 0x40, 0x60, 0xEF, 0xFF, 0xFD, 0x0E, 0x02, 0x71, 0x0A, 0xFF, 0xFF, 0xF0,
  0xD7, 0x10, 0xBF, 0xA8, 0x4E, 0xB8, 0x54, 0x28, 0x01, 0x18, 0x42, 0x35, 0x7A, 0xCF, 0xB0, 0x67,
  0x0A, 0xF9, 0x09, 0x04, 0x77, 0x48, 0x14, 0x8D, 0xD0, 0xE7, 0x06, 0xF0, 0xA0, 0x27, 0x77, 0x28,
  0x12, 0x7C, 0xA0, 0x86, 0x01, 0x0E, 0xE0, 0x77, 0x77, 0x78, 0x13, 0x91, 0x60, 0x7E, 0x09, 0x80,
  0xC2, 0x00, 0xDD, 0x0D, 0x80, 0xC2, 0x00, 0x2E, 0x07, 0x80, 0xC2, 0x00, 0x4E, 0x03, 0x80, 0xC2,
  0x00, 0x6E, 0x80, 0xC3, 0x00, 0x7E, 0x80, 0xC3, 0x00, 0x7E, 0x80, 0xC3, 0x00, 0x6E, 0x02, 0x80,
  0xC2, 0x00, 0x4E, 0x06, 0x80, 0xC2, 0x00, 0x1E, 0x0C, 0x80, 0xC3, 0x00, 0xCE, 0x07, 0x80, 0xC2,
  0x00, 0x6F, 0x06, 0x80, 0xC2, 0x00, 0xDF, 0x0A, 0x01, 0x80, 0xC0, 0x00, 0x3F, 0xA0, 0x90, 0x17,
  0x77, 0x77, 0x05, 0xFB, 0x0A, 0x03, 0x77, 0x77, 0x60, 0x40, 0xEF, 0xB0, 0xC0, 0x67, 0x77, 0x75,
  0x02, 0x0C, 0xFC, 0x81, 0xE9, 0x47, 0x77, 0x74, 0x07, 0x0E, 0xFD, 0x81, 0xD8, 0x37, 0x77, 0x72,
  0x81, 0x18, 0xEF, 0xE8, 0x1C, 0x71, 0x77, 0x77, 0x10, 0x6F, 0xFA, 0x0A, 0x04, 0x77, 0x74, 0x04,
  0x0D, 0xFF, 0xD0, 0xD0, 0x67, 0x77, 0x01, 0x0A, 0xFA, 0x0E, 0xFE, 0x81, 0xE7, 0x17, 0x73, 0x03,
  0x0E, 0xF8, 0x5D, 0x72, 0x03, 0x7C, 0xFD, 0x0E, 0x07, 0x77, 0x10, 0x5F, 0x0D, 0x05, 0x78, 0x11,
  0x7C, 0xFC, 0x0E, 0x05, 0x75, 0x05, 0xF0, 0x77, 0x58, 0x12, 0x8E, 0xFB, 0x0A, 0x73, 0x03, 0xE0,
  0xE0, 0x37, 0x72, 0x05, 0x0C, 0xFA, 0x0C, 0x01, 0x71, 0x0D, 0xD0, 0xD0, 0x17, 0x75, 0x04, 0x0C,
  0xF9, 0x0D, 0x01, 0x60, 0x8D, 0x0E, 0x02, 0x77, 0x71, 0x05, 0x0E, 0xF0, 0xC6, 0x0E, 0xD0, 0x67,
  0x77, 0x30, 0x10, 0xBF, 0x08, 0x40, 0x5D, 0x0D, 0x77, 0x76, 0x09, 0xF0, 0x23, 0x0A, 0xD0, 0x87,
  0x77, 0x70, 0xBE, 0x09, 0x30, 0xDD, 0x04, 0x77, 0x77, 0x01, 0x0E, 0xD0, 0xE3, 0xE0, 0x17, 0x77,
  0x71, 0x07, 0xE8, 0x12, 0x01, 0xE7, 0x77, 0x72, 0x01, 0xE8, 0x15, 0x01, 0xE7, 0x77, 0x73, 0x0C,
  0xD8, 0x17, 0x01, 0xE0, 0x17, 0x77, 0x72, 0x0A, 0xD0, 0x82, 0xE0, 0x37, 0x77, 0x72, 0x09, 0xD0,
  0x82, 0x0E, 0xD0, 0x77, 0x77, 0x72, 0x09, 0xD0, 0x72, 0x0B, 0xD0, 0xD7, 0x77, 0x72, 0x0A, 0xD0,
  0x62, 0x07, 0xE0, 0x67, 0x77, 0x71, 0x0C, 0xD0, 0x42, 0x02, 0xE0, 0xE0, 0x27, 0x77, 0x60, 0x1E,
  0x01, 0x30, 0xBE, 0x0D, 0x02, 0x77, 0x75, 0x05, 0xD0, 0xD4, 0x02, 0xF0, 0xE0, 0x57, 0x77, 0x40,
  0xCD, 0x07, 0x50, 0x7F, 0x90, 0xB0, 0x37, 0x77, 0x10, 0x5E, 0x01, 0x60, 0x9F, 0xA0, 0xA0, 0x27,
  0x75, 0x02, 0x0E, 0xD0, 0x97, 0x10, 0x9F, 0xB0, 0xA0, 0x37, 0x72, 0x01, 0x0D, 0xD0, 0xE0, 0x17,
  0x20, 0x7F, 0xC0, 0xC0, 0x67, 0x60, 0x10, 0xDE, 0x04, 0x74, 0x03, 0x0D, 0xFC, 0x81, 0xE9, 0x37,
  0x20, 0x30, 0xDE, 0x06, 0x77, 0x06, 0x0E, 0xFD, 0x81, 0xC7, 0x25, 0x07, 0xF0, 0x77, 0x73, 0x06,
  0x0D, 0xFE, 0x83, 0xD8, 0x34, 0xCF, 0x07, 0x77, 0x60, 0x40, 0xBF, 0xFF, 0x0E, 0x04, 0x77, 0x72,
  0x81, 0x28, 0xEF, 0xFB, 0x0B, 0x01, 0x77, 0x76, 0x05, 0x0A, 0xFF, 0x0D, 0x01, 0x77, 0x77, 0x28,
  0x11, 0x6B, 0xFE, 0x08, 0x77, 0x77, 0x48, 0x11, 0x7D, 0xFC, 0x0D, 0x03, 0x77, 0x77, 0x50, 0x40,
  0xAF, 0xC0, 0x67, 0x77, 0x76, 0x81, 0x28, 0xEF, 0xA0, 0x77, 0x77, 0x77, 0x01, 0x08, 0xFA, 0x06,
  0x80, 0xC0, 0x00, 0x20, 0xAF, 0x90, 0x28, 0x0C, 0x10, 0x06, 0xF0, 0xB8, 0x0C, 0x20, 0x05, 0xF0,
  0x28, 0x0C, 0x20, 0x09, 0xE0, 0x88, 0x0C, 0x20, 0x01, 0xE0, 0xB8, 0x0C, 0x30, 0x0B, 0xD0, 0xE8,
  0x0C, 0x30, 0x08, 0xE8, 0x0C, 0x30, 0x06, 0xE0, 0x18, 0x0C, 0x20, 0x06, 0xE8, 0x0C, 0x30, 0x08,
  0xE8, 0x0C, 0x30, 0x0B, 0xD0, 0xC8, 0x0C, 0x20, 0x01, 0xE0, 0x98, 0x0C, 0x20, 0x08, 0xE0, 0x58,
  0x0C, 0x10, 0x02, 0xE0, 0xE2, 0x06, 0x05, 0x77, 0x77, 0x50, 0x10, 0xDE, 0x08, 0x28, 0x38, 0xFD,
  0x82, 0x77, 0x77, 0x10, 0x20, 0xDE, 0x0D, 0x30, 0x8C, 0x81, 0xB6, 0x17, 0x77, 0x40, 0x70, 0xEF,
  0x04, 0x30, 0x8F, 0x82, 0xD8, 0x41, 0x77, 0x48, 0x13, 0x8E, 0xF9, 0x06, 0x40, 0x8F, 0xC8, 0x6D,
  0xA8, 0x54, 0x21, 0x12, 0x86, 0x11, 0x24, 0x58, 0xAE, 0xFB, 0x06, 0x50, 0x88, 0x0C, 0x1F, 0x0E,
  0x04, 0x60, 0x40, 0xDF, 0xFF, 0xFF, 0x0A, 0x01, 0x72, 0x81, 0x49, 0xEF, 0xFF, 0xFA, 0x0B, 0x03,
  0x77, 0x81, 0x48, 0xCF, 0xFF, 0xB8, 0x1C, 0x72, 0x77, 0x58, 0x41, 0x47, 0xAC, 0xEF, 0xE8, 0x3D,
  0xB8, 0x51, 0x77, 0x77, 0x89, 0x21, 0x13, 0x34, 0x55, 0x54, 0x33, 0x17, 0x76,
  // "¨" (U+00A8)
  0x28, 0x21, 0x55, 0x47, 0x75, 0x82, 0x45, 0x51, 0x30, 0x6C, 0x0D, 0x03, 0x77, 0x10, 0x30, 0xDC,
  0x81, 0x70, 0x3E, 0x0E, 0x77, 0x10, 0xDE, 0x04, 0x08, 0xF0, 0x57, 0x60, 0x4F, 0x0A, 0x0B, 0xF0,
  0x87, 0x60, 0x6F, 0x0D, 0x0C, 0xF0, 0x97, 0x60, 0x7F, 0x0E, 0x0B, 0xF0, 0x77, 0x60, 0x6F, 0x0D,
  0x08, 0xF0, 0x47, 0x60, 0x3F, 0x09, 0x02, 0xE0, 0xD7, 0x71, 0x0C, 0xE8, 0x23, 0x05, 0xEB, 0x0C,
  0x02, 0x77, 0x10, 0x20, 0xCB, 0x0E, 0x05, 0x48, 0x13, 0x32, 0x77, 0x58, 0x12, 0x33, 0x30,
  // "©" (U+00A9)
  0x80, 0xC0, 0x08, 0x32, 0x57, 0x89, 0x80, 0x1B, 0x84, 0xA9, 0x86, 0x42, 0x80, 0xF7, 0x08, 0x21,
  0x59, 0xCF, 0xFC, 0x81, 0xC8, 0x48, 0x0F, 0x00, 0x81, 0x27, 0xCF, 0xFF, 0xD8, 0x1B, 0x61, 0x80,
  0xE2, 0x00, 0x50, 0xBF, 0xFF, 0xFC, 0x09, 0x03, 0x80, 0xD6, 0x00, 0x70, 0xDF, 0xFB, 0x0D, 0x0E,
  0xFF, 0xB0, 0xB0, 0x48, 0x0D, 0x20, 0x07, 0x0E, 0xFB, 0x84, 0xEB, 0x86, 0x32, 0x78, 0x41, 0x24,
  0x69, 0xCF, 0xC0, 0xC0, 0x38, 0x0C, 0x60, 0x04, 0x0D, 0xFA, 0x81, 0xB7, 0x27, 0x76, 0x81, 0x49,
  0xEF, 0xA0, 0xA0, 0x18, 0x0C, 0x20, 0x01, 0x0A, 0xF9, 0x81, 0xC6, 0x17, 0x77, 0x50, 0x40, 0xAF,
  0x90, 0xE0, 0x68, 0x0C, 0x00, 0x04, 0x0E, 0xF0, 0xA0, 0x37, 0x77, 0x73, 0x81, 0x18, 0xEF, 0x0B,
  0x01, 0x77, 0x77, 0x50, 0x8F, 0x0B, 0x02, 0x77, 0x77, 0x78, 0x11, 0x8E, 0xE0, 0xD0, 0x37, 0x77,
  0x72, 0x01, 0x0B, 0xE0, 0xD0, 0x48, 0x0C, 0x30, 0x01, 0x0A, 0xF0, 0x57, 0x77, 0x70, 0x10, 0xDE,
  0x08, 0x80, 0xC7, 0x00, 0x50, 0xEE, 0x07, 0x77, 0x75, 0x02, 0x0D, 0xD0, 0xD0, 0x38, 0x0D, 0x10,
  0x01, 0x0B, 0xE0, 0x87, 0x77, 0x30, 0x20, 0xDD, 0x0B, 0x01, 0x80, 0xD4, 0x00, 0x7E, 0x08, 0x77,
  0x71, 0x01, 0x0D, 0xD0, 0xA8, 0x0D, 0x70, 0x05, 0xE0, 0x77, 0x77, 0x0C, 0xD0, 0x98, 0x0E, 0x10,
  0x04, 0x0E, 0xD0, 0x67, 0x75, 0x0A, 0xD0, 0x98, 0x0E, 0x30, 0x03, 0x0E, 0xD0, 0x37, 0x73, 0x07,
  0xD0, 0xA7, 0x77, 0x71, 0x80, 0x11, 0x77, 0x72, 0x04, 0xD0, 0xD0, 0x17, 0x71, 0x03, 0xD0, 0xC7,
  0x77, 0x48, 0x24, 0x8B, 0xDF, 0x83, 0xEC, 0xA7, 0x47, 0x74, 0x05, 0xD0, 0xB7, 0x71, 0x0C, 0xC0,
  0xE0, 0x17, 0x77, 0x10, 0x50, 0xBF, 0xFC, 0x81, 0xB6, 0x17, 0x71, 0x08, 0xD0, 0x67, 0x60, 0x7D,
  0x04, 0x77, 0x70, 0x60, 0xDF, 0xFF, 0xA0, 0xA0, 0x37, 0x70, 0xBC, 0x0E, 0x01, 0x74, 0x01, 0x0E,
  0xC0, 0x87, 0x76, 0x04, 0x0D, 0xFF, 0xFE, 0x03, 0x76, 0x01, 0x0E, 0xC0, 0xA7, 0x40, 0xAC, 0x0D,
  0x77, 0x60, 0x8F, 0xFF, 0xF0, 0xC7, 0x71, 0x05, 0xD0, 0x37, 0x20, 0x2D, 0x04, 0x77, 0x40, 0x10,
  0xBF, 0xC8, 0x90, 0xC9, 0x77, 0x57, 0x78, 0xAD, 0xF9, 0x05, 0x77, 0x20, 0xBC, 0x0C, 0x72, 0x0A,
  0xC0, 0xB7, 0x74, 0x01, 0x0C, 0xF9, 0x81, 0xE9, 0x47, 0x58, 0x13, 0x8D, 0xB0, 0xD7, 0x73, 0x02,
  0xD0, 0x47, 0x02, 0xD0, 0x37, 0x74, 0x0C, 0xF9, 0x08, 0x01, 0x77, 0x38, 0x23, 0x9F, 0x67, 0x74,
  0x09, 0xC0, 0xC7, 0x08, 0xC0, 0xA7, 0x74, 0x0A, 0xF0, 0xC0, 0x27, 0x77, 0x01, 0x77, 0x50, 0x2D,
  0x03, 0x60, 0xEC, 0x03, 0x77, 0x30, 0x6F, 0x09, 0x80, 0xD0, 0x00, 0x9C, 0x0A, 0x50, 0x5C, 0x0C,
  0x77, 0x30, 0x10, 0xEE, 0x09, 0x80, 0xD1, 0x00, 0x3D, 0x01, 0x40, 0xAC, 0x06, 0x77, 0x30, 0xAE,
  0x0A, 0x80, 0xD3, 0x00, 0xCC, 0x06, 0x4D, 0x77, 0x30, 0x2E, 0x0D, 0x80, 0xD4, 0x00, 0x7C, 0x0B,
  0x30, 0x4C, 0x0A, 0x77, 0x30, 0xAE, 0x03, 0x80, 0xD4, 0x00, 0x1D, 0x01, 0x20, 0x9C, 0x06, 0x77,
  0x20, 0x1E, 0x0A, 0x80, 0xD6, 0x00, 0xBC, 0x05, 0x20, 0xCC, 0x01, 0x77, 0x20, 0x7E, 0x02, 0x80,
  0xD6, 0x00, 0x7C, 0x09, 0x2C, 0x0D, 0x77, 0x30, 0xCD, 0x0B, 0x80, 0xD7, 0x00, 0x3C, 0x81, 0xC0,
  0x3C, 0x0A, 0x77, 0x20, 0x1E, 0x05, 0x80, 0xE0, 0x0D, 0x10, 0x6C, 0x07, 0x77, 0x20, 0x4E, 0x01,
  0x80, 0xE0, 0x00, 0xCC, 0x03, 0x08, 0xC0, 0x47, 0x72, 0x08, 0xD0, 0xC8, 0x0E, 0x10, 0x09, 0xC0,
  0x50, 0xAC, 0x02, 0x77, 0x20, 0xAD, 0x09, 0x80, 0xE1, 0x00, 0x7C, 0x07, 0x0C, 0xC7, 0x73, 0x0D,
  0xD0, 0x68, 0x0E, 0x10, 0x05, 0xC0, 0x90, 0xDB, 0x0E, 0x77, 0x30, 0xED, 0x04, 0x80, 0xE1, 0x00,
  0x3C, 0x0A, 0x0E, 0xB0, 0xD7, 0x73, 0xE0, 0x38, 0x0E, 0x10, 0x03, 0xC0, 0xB0, 0xEB, 0x0C, 0x77,
  0x20, 0x1E, 0x02, 0x80, 0xE1, 0x00, 0x2C, 0x0C, 0xC0, 0xC7, 0x72, 0x02, 0xE0, 0x18, 0x0E, 0x10,
  0x01, 0xC0, 0xCC, 0x0C, 0x77, 0x20, 0x2E, 0x01, 0x80, 0xE1, 0x00, 0x1C, 0x0C, 0xC0, 0xD7, 0x72,
  0x01, 0xE0, 0x18, 0x0E, 0x10, 0x01, 0xC0, 0xC0, 0xEB, 0x0D, 0x77, 0x20, 0x1E, 0x02, 0x80, 0xE1,
  0x00, 0x2C, 0x0C, 0x0D, 0xB0, 0xE7, 0x73, 0xE0, 0x38, 0x0E, 0x10, 0x03, 0xC0, 0xB0, 0xCC, 0x77,
  0x30, 0xED, 0x05, 0x80, 0xE1, 0x00, 0x4C, 0x0A, 0x0B, 0xC0, 0x27, 0x72, 0x0C, 0xD0, 0x78, 0x0E,
  0x10, 0x06, 0xC0, 0x80, 0x9C, 0x04, 0x77, 0x20, 0xAD, 0x09, 0x80, 0xE1, 0x00, 0x8C, 0x06, 0x07,
  0xC0, 0x67, 0x72, 0x07, 0xD0, 0xC8, 0x0E, 0x10, 0x0B, 0xC0, 0x04, 0xC0, 0x97, 0x72, 0x05, 0xE0,
  0x18, 0x0E, 0x00, 0x0E, 0xC0, 0x01, 0xC0, 0xD7, 0x72, 0x01, 0xE0, 0x58, 0x0D, 0x70, 0x02, 0xC0,
  0xE2, 0x0E, 0xC0, 0x17, 0x72, 0x0C, 0xD0, 0xB8, 0x0D, 0x70, 0x06, 0xC0, 0xB2, 0x0A, 0xC0, 0x57,
  0x72, 0x07, 0xE0, 0x28, 0x0D, 0x60, 0x0A, 0xC0, 0x72, 0x06, 0xC0, 0xA7, 0x72, 0x02, 0xE0, 0x98,
  0x0D, 0x60, 0x0E, 0xC0, 0x32, 0x02, 0xC0, 0xE7, 0x73, 0x0B, 0xE0, 0x38, 0x0D, 0x40, 0x05, 0xC0,
  0xE4, 0x0C, 0xC0, 0x57, 0x72, 0x03, 0xE0, 0xC8, 0x0D, 0x40, 0x0A, 0xC0, 0x94, 0x07, 0xC0, 0xA7,
  0x73, 0x0B, 0xE0, 0xA8, 0x0D, 0x20, 0x01, 0xD0, 0x44, 0x02, 0xD0, 0x27, 0x72, 0x02, 0xF0, 0x98,
  0x0D, 0x10, 0x08, 0xC0, 0xD6, 0x0B, 0xC0, 0x97, 0x73, 0x07, 0xF0, 0xA0, 0x18, 0x0C, 0x60, 0x01,
  0x0E, 0xC0, 0x76, 0x05, 0xD0, 0x17, 0x73, 0x0A, 0xF0, 0xD0, 0x57, 0x77, 0x03, 0x02, 0x77, 0x40,
  0x7C, 0x0E, 0x01, 0x70, 0xDC, 0x09, 0x77, 0x40, 0xCF, 0x90, 0xC0, 0x57, 0x72, 0x83, 0x48, 0xDF,
  0x67, 0x73, 0x01, 0x0E, 0xC0, 0x97, 0x10, 0x6D, 0x02, 0x77, 0x30, 0x10, 0xCF, 0xA8, 0x3E, 0xA6,
  0x31, 0x48, 0x41, 0x13, 0x68, 0xBD, 0x06, 0x77, 0x30, 0x9D, 0x01, 0x72, 0x0D, 0xC0, 0xB7, 0x75,
  0x0A, 0xFF, 0xFF, 0x06, 0x77, 0x20, 0x3D, 0x08, 0x73, 0x05, 0xD0, 0x67, 0x75, 0x06, 0x0E, 0xFF,
  0xFD, 0x06, 0x77, 0x20, 0xDC, 0x0E, 0x01, 0x74, 0x0B, 0xC0, 0xE0, 0x27, 0x75, 0x01, 0x0A, 0xFF,
  0xFC, 0x05, 0x77, 0x10, 0x9D, 0x06, 0x75, 0x02, 0xD0, 0xC7, 0x77, 0x81, 0x29, 0xEF, 0xFD, 0x81,
  0xC7, 0x17, 0x71, 0x05, 0xD0, 0xB7, 0x70, 0x7D, 0x0A, 0x77, 0x72, 0x81, 0x48, 0xCF, 0xD8, 0x2D,
  0xA5, 0x17, 0x73, 0x02, 0x0E, 0xC0, 0xE0, 0x27, 0x71, 0x0C, 0xD0, 0x77, 0x77, 0x50, 0x10, 0x38,
  0x02, 0x50, 0x40, 0x27, 0x77, 0x01, 0x0D, 0xD0, 0x67, 0x72, 0x01, 0x0E, 0xD0, 0x68, 0x0E, 0x30,
  0x01, 0x0C, 0xD0, 0x97, 0x74, 0x04, 0xE0, 0x68, 0x0E, 0x10, 0x01, 0x0C, 0xD0, 0xC7, 0x76, 0x06,
  0xE0, 0x78, 0x0D, 0x70, 0x01, 0x0C, 0xD0, 0xD0, 0x17, 0x77, 0x07, 0xE0, 0x98, 0x0D, 0x50, 0x02,
  0x0D, 0xD0, 0xE0, 0x27, 0x77, 0x20, 0x8E, 0x0B, 0x01, 0x80, 0xD2, 0x00, 0x50, 0xED, 0x0E, 0x02,
  0x77, 0x74, 0x08, 0xE0, 0xE0, 0x48, 0x0D, 0x00, 0x09, 0xE0, 0xD0, 0x27, 0x77, 0x60, 0x6F, 0x09,
  0x01, 0x80, 0xC4, 0x00, 0x40, 0xDE, 0x0C, 0x01, 0x77, 0x77, 0x10, 0x40, 0xEE, 0x0E, 0x07, 0x80,
  0xC1, 0x00, 0x20, 0xAF, 0x0A, 0x77, 0x77, 0x40, 0x20, 0xCF, 0x0D, 0x06, 0x77, 0x77, 0x50, 0x20,
  0x9F, 0x90, 0x77, 0x77, 0x77, 0x08, 0xF9, 0x81, 0xE8, 0x17, 0x77, 0x70, 0x40, 0xAF, 0x90, 0xC0,
  0x38, 0x0C, 0x10, 0x02, 0x0C, 0xFA, 0x81, 0xB6, 0x17, 0x77, 0x18, 0x13, 0x8D, 0xFA, 0x07, 0x80,
  0xC5, 0x00, 0x50, 0xDF, 0xB8, 0x2D, 0x96, 0x37, 0x68, 0x31, 0x47, 0xAE, 0xFB, 0x0A, 0x01, 0x80,
  0xD0, 0x00, 0x60, 0xEF, 0xE8, 0x1E, 0xCB, 0x80, 0x19, 0x82, 0xAB, 0xDE, 0xFE, 0x0A, 0x02, 0x80,
  0xD4, 0x00, 0x50, 0xCF, 0xFF, 0xFD, 0x81, 0xE9, 0x28, 0x0E, 0x00, 0x81, 0x38, 0xDF, 0xFF, 0xF0,
  0xB0, 0x68, 0x0E, 0x60, 0x82, 0x37, 0xBE, 0xFF, 0xE8, 0x2D, 0xA5, 0x18, 0x0F, 0x40, 0x84, 0x35,
  0x8A, 0xCD, 0xF8, 0x5E, 0xDB, 0x97, 0x41, 0x80, 0x99, 0x10, 0x00, 0x18, 0x0C, 0x70,
  // "ª" (U+00AA)
  0x74, 0x89, 0x12, 0x46, 0x89, 0x99, 0x97, 0x52, 0x77, 0x28, 0x21, 0x6A, 0xEF, 0xC8, 0x1E, 0x92,
  0x74, 0x06, 0x0B, 0xFF, 0xC0, 0x90, 0x17, 0x08, 0x0E, 0xFF, 0xF0, 0xD0, 0x26, 0x0A, 0xFD, 0x0E,
  0xFB, 0x0D, 0x01, 0x50, 0x3E, 0x82, 0xB7, 0x42, 0x58, 0x14, 0x8E, 0xE0, 0xB6, 0x0C, 0xA8, 0x1C,
  0x61, 0x75, 0x09, 0xE0, 0x45, 0x81, 0x5B, 0x47, 0x72, 0x07, 0xD0, 0xA7, 0x77, 0x40, 0xBC, 0x0E,
  0x77, 0x74, 0x04, 0xD0, 0x37, 0x77, 0x4D, 0x06, 0x77, 0x74, 0x0C, 0xC0, 0x77, 0x77, 0x40, 0xBC,
  0x08, 0x77, 0x74, 0x0B, 0xC0, 0x87, 0x77, 0x40, 0xBC, 0x08, 0x77, 0x74, 0x0B, 0xC0, 0x87, 0x72,
  0x89, 0x01, 0x33, 0x55, 0x57, 0x77, 0xDC, 0x08, 0x73, 0x83, 0x36, 0x9C, 0xEF, 0xF9, 0x08, 0x78,
  0x13, 0x9E, 0xFF, 0xE0, 0x85, 0x04, 0x0C, 0xFF, 0xFA, 0x08, 0x40, 0x9F, 0xE8, 0x6E, 0xDD, 0xBB,
  0xB9, 0xDC, 0x08, 0x30, 0xCF, 0x84, 0xEB, 0x75, 0x31, 0x71, 0x0B, 0xC0, 0x82, 0x0A, 0xE0, 0xC0,
  0x57, 0x70, 0xBC, 0x81, 0x80, 0x5E, 0x06, 0x77, 0x20, 0xBC, 0x81, 0x80, 0xDD, 0x05, 0x77, 0x30,
  0xBC, 0x08, 0x03, 0xD0, 0x97, 0x74, 0x0C, 0xC0, 0x80, 0x7D, 0x03, 0x77, 0x40, 0xDC, 0x08, 0x09,
  0xC0, 0xE7, 0x74, 0x01, 0xD0, 0x80, 0xAC, 0x0D, 0x77, 0x40, 0x5D, 0x08, 0x0A, 0xC0, 0xD7, 0x74,
  0x0A, 0xD0, 0x80, 0x9D, 0x77, 0x30, 0x2E, 0x08, 0x07, 0xD0, 0x37, 0x72, 0x0B, 0xE0, 0x80, 0x4D,
  0x0A, 0x77, 0x10, 0x8F, 0x81, 0x80, 0xED, 0x06, 0x76, 0x09, 0xF9, 0x81, 0x80, 0x8E, 0x09, 0x01,
  0x72, 0x06, 0x0D, 0xB0, 0xE0, 0xBC, 0x82, 0x80, 0x1E, 0xF8, 0x6B, 0x86, 0x55, 0x78, 0xBD, 0x81,
  0xE4, 0x5C, 0x08, 0x20, 0x30, 0xEF, 0xFC, 0x82, 0xE3, 0x02, 0xC0, 0x83, 0x03, 0x0E, 0xFF, 0xA0,
  0xB0, 0x13, 0xC0, 0x84, 0x01, 0x09, 0xFE, 0x0C, 0x05, 0x50, 0xCB, 0x08, 0x68, 0x21, 0x7B, 0xEE,
  0x81, 0xC8, 0x37, 0x83, 0x57, 0x77, 0x47, 0x38, 0x31, 0x13, 0x11, 0x77, 0x20,
  // "«" (U+00AB)
  0x77, 0x40, 0x10, 0x67, 0x77, 0x06, 0x77, 0x71, 0x82, 0xBF, 0xC3, 0x77, 0x48, 0x29, 0xFD, 0x47,
  0x75, 0x09, 0xC0, 0x90, 0x17, 0x71, 0x06, 0xC0, 0xA0, 0x17, 0x72, 0x06, 0xE0, 0x87, 0x70, 0x4E,
  0x0A, 0x77, 0x10, 0x4E, 0x0C, 0x77, 0x02, 0x0E, 0xD0, 0xD0, 0x17, 0x70, 0x20, 0xED, 0x0E, 0x02,
  0x76, 0x01, 0x0D, 0xD0, 0xE0, 0x27, 0x70, 0x10, 0xDE, 0x04, 0x77, 0x0B, 0xE0, 0x57, 0x71, 0x0B,
  0xE0, 0x77, 0x70, 0x9E, 0x08, 0x77, 0x10, 0x8E, 0x0A, 0x77, 0x06, 0xE0, 0xB7, 0x71, 0x05, 0xE0,
  0xD0, 0x17, 0x60, 0x4E, 0x0E, 0x01, 0x77, 0x03, 0xE0, 0xE0, 0x27, 0x60, 0x20, 0xEE, 0x03, 0x77,
  0x01, 0x0E, 0xE0, 0x57, 0x60, 0x10, 0xDE, 0x06, 0x77, 0x10, 0xCE, 0x09, 0x77, 0x0B, 0xE0, 0xA7,
  0x71, 0x0A, 0xE0, 0xB7, 0x70, 0x9E, 0x0C, 0x77, 0x10, 0x7E, 0x0E, 0x01, 0x76, 0x06, 0xE0, 0xE0,
  0x27, 0x70, 0x5F, 0x03, 0x76, 0x04, 0xF0, 0x47, 0x70, 0x30, 0xEE, 0x06, 0x76, 0x02, 0x0E, 0xE0,
  0x87, 0x70, 0x10, 0xDE, 0x0A, 0x76, 0x01, 0x0D, 0xE0, 0xB7, 0x71, 0x0C, 0xE0, 0xC7, 0x70, 0xBE,
  0x0D, 0x01, 0x77, 0x09, 0xE0, 0xE0, 0x27, 0x60, 0x9F, 0x03, 0x77, 0x07, 0xF0, 0x47, 0x60, 0x7F,
  0x05, 0x77, 0x04, 0xF0, 0x87, 0x60, 0x4F, 0x09, 0x77, 0x02, 0x0E, 0xE0, 0xB7, 0x60, 0x20, 0xEE,
  0x0C, 0x77, 0x10, 0xDE, 0x0D, 0x01, 0x76, 0x0D, 0xE0, 0xE0, 0x17, 0x71, 0xF0, 0x77, 0x60, 0x1F,
  0x08, 0x77, 0x20, 0xCF, 0x03, 0x76, 0x0D, 0xF0, 0x47, 0x71, 0x02, 0x0E, 0xE0, 0xD0, 0x17, 0x50,
  0x20, 0xEE, 0x0E, 0x01, 0x77, 0x10, 0x3F, 0x0B, 0x76, 0x03, 0xF0, 0xC7, 0x72, 0x06, 0xF0, 0x87,
  0x60, 0x6F, 0x09, 0x77, 0x20, 0x8F, 0x04, 0x76, 0x08, 0xF0, 0x67, 0x72, 0x0B, 0xE0, 0xE0, 0x27,
  0x60, 0xAF, 0x03, 0x77, 0x20, 0xCE, 0x0C, 0x77, 0x0C, 0xE0, 0xD0, 0x17, 0x71, 0x02, 0x0E, 0xE0,
  0xA7, 0x60, 0x10, 0xDE, 0x0B, 0x77, 0x20, 0x3F, 0x06, 0x76, 0x03, 0x0E, 0xE0, 0x87, 0x72, 0x06,
  0xF0, 0x37, 0x60, 0x5F, 0x04, 0x77, 0x20, 0x8E, 0x0E, 0x01, 0x76, 0x07, 0xE0, 0xE0, 0x27, 0x72,
  0x0B, 0xE0, 0xC7, 0x70, 0x9E, 0x0C, 0x77, 0x30, 0xCE, 0x09, 0x77, 0x0B, 0xE0, 0xA7, 0x72, 0x02,
  0x0E, 0xE0, 0x57, 0x60, 0x10, 0xDE, 0x06, 0x77, 0x20, 0x3E, 0x0E, 0x02, 0x76, 0x02, 0x0E, 0xE0,
  0x37, 0x72, 0x06, 0xE0, 0xD0, 0x17, 0x60, 0x4E, 0x0E, 0x01, 0x77, 0x20, 0x8E, 0x0B, 0x77, 0x06,
  0xE0, 0xB7, 0x73, 0x0B, 0xE0, 0x77, 0x70, 0x9E, 0x09, 0x77, 0x30, 0xCE, 0x04, 0x77, 0x0B, 0xE0,
  0x57, 0x72, 0x02, 0x0E, 0xD0, 0xE0, 0x27, 0x70, 0xCD, 0x0E, 0x02, 0x77, 0x20, 0x3E, 0x08, 0x77,
  0x02, 0x0E, 0xD0, 0x97, 0x73, 0x06, 0xB0, 0xD0, 0x47, 0x72, 0x03, 0xB0, 0xE0, 0x57, 0x75, 0x81,
  0x8F, 0x87, 0x75, 0x82, 0x5F, 0x91, 0x77, 0x70, 0x27, 0x77, 0x02, 0x40,
  // "¬" (U+00AC)
  0x80, 0xE3, 0x11, 0x0B, 0x80, 0xE2, 0xF0, 0x10, 0xB8, 0x0E, 0x2F, 0x01, 0x0B, 0x80, 0xE2, 0xF0,
  0x10, 0xB8, 0x0E, 0x2F, 0x01, 0x0B, 0x80, 0xE2, 0xF0, 0x10, 0x58, 0x0D, 0x47, 0x0C, 0xD0, 0x18,
  0x0D, 0x50, 0x08, 0xD0, 0x18, 0x0D, 0x50, 0x08, 0xD0, 0x18, 0x0D, 0x50, 0x08, 0xD0, 0x18, 0x0D,
  0x50, 0x08, 0xD0, 0x18, 0x0D, 0x50, 0x08, 0xD0, 0x18, 0x0D, 0x50, 0x08, 0xD0, 0x18, 0x0D, 0x50,
  0x08, 0xD0, 0x18, 0x0D, 0x50, 0x08, 0xD0, 0x18, 0x0D, 0x50, 0x08, 0xD0, 0x18, 0x0D, 0x50, 0x08,
  0xD0, 0x18, 0x0D, 0x50, 0x08, 0xD0, 0x18, 0x0D, 0x50, 0x08, 0xD0, 0x18, 0x0D, 0x50, 0x08, 0xD0,
  0x18, 0x0D, 0x50, 0x08, 0xD0, 0x18, 0x0D, 0x50, 0x08, 0xD0, 0x18, 0x0D, 0x50, 0x08, 0xD0, 0x18,
  0x0D, 0x50, 0x08, 0xD0, 0x18, 0x0D, 0x50, 0x08, 0xD0, 0x18, 0x0D, 0x50, 0x08, 0xD0, 0x18, 0x0D,
  0x50, 0x08, 0xD0, 0x18, 0x0D, 0x50, 0x08, 0xD0, 0x18, 0x0D, 0x50, 0x08, 0xD0, 0x18, 0x0D, 0x50,
  0x08, 0xD0, 0x18, 0x0D, 0x50, 0x03, 0x80, 0x15, 0x10,
  // "®" (U+00AE)
  0x80, 0xC0, 0x08, 0x32, 0x57, 0x89, 0x80, 0x1B, 0x84, 0xA9, 0x86, 0x42, 0x80, 0xF7, 0x08, 0x21,
  0x59, 0xCF, 0xFC, 0x81, 0xC8, 0x48, 0x0F, 0x00, 0x81, 0x27, 0xCF, 0xFF, 0xD8, 0x1B, 0x61, 0x80,
  0xE2, 0x00, 0x50, 0xBF, 0xFF, 0xFC, 0x09, 0x03, 0x80, 0xD6, 0x00, 0x70, 0xDF, 0xFB, 0x0D, 0x0E,
  0xFF, 0xB0, 0xB0, 0x48, 0x0D, 0x20, 0x07, 0x0E, 0xFB, 0x84, 0xEB, 0x86, 0x32, 0x78, 0x41, 0x24,
  0x69, 0xCF, 0xC0, 0xC0, 0x38, 0x0C, 0x60, 0x04, 0x0D, 0xFA, 0x81, 0xB7, 0x27, 0x76, 0x81, 0x49,
  0xEF, 0xA0, 0xA0, 0x18, 0x0C, 0x20, 0x01, 0x0A, 0xF9, 0x81, 0xC6, 0x17, 0x77, 0x50, 0x40, 0xAF,
  0x90, 0xE0, 0x68, 0x0C, 0x00, 0x04, 0x0E, 0xF0, 0xA0, 0x37, 0x77, 0x73, 0x81, 0x18, 0xEF, 0x0B,
  0x01, 0x77, 0x77, 0x50, 0x8F, 0x0B, 0x02, 0x77, 0x77, 0x78, 0x11, 0x8E, 0xE0, 0xD0, 0x37, 0x77,
  0x72, 0x01, 0x0B, 0xE0, 0xD0, 0x48, 0x0C, 0x30, 0x01, 0x0A, 0xF0, 0x57, 0x77, 0x70, 0x10, 0xDE,
  0x08, 0x80, 0xC7, 0x00, 0x50, 0xEE, 0x07, 0x77, 0x75, 0x02, 0x0D, 0xD0, 0xD0, 0x38, 0x0D, 0x10,
  0x01, 0x0B, 0xE0, 0x87, 0x77, 0x30, 0x20, 0xDD, 0x0B, 0x01, 0x80, 0xD4, 0x00, 0x7E, 0x08, 0x77,
  0x71, 0x01, 0x0D, 0xD0, 0xA8, 0x0D, 0x70, 0x05, 0xE0, 0x77, 0x77, 0x0C, 0xD0, 0x98, 0x0E, 0x10,
  0x04, 0x0E, 0xD0, 0x67, 0x75, 0x0A, 0xD0, 0x98, 0x0E, 0x30, 0x03, 0x0E, 0xD0, 0x37, 0x73, 0x07,
  0xD0, 0xA8, 0x0E, 0x50, 0x04, 0xD0, 0xD0, 0x17, 0x71, 0x03, 0xD0, 0xC7, 0x70, 0x48, 0x09, 0x59,
  0x82, 0x76, 0x31, 0x77, 0x72, 0x05, 0xD0, 0xB7, 0x71, 0x0C, 0xC0, 0xE0, 0x17, 0x70, 0x6F, 0xFF,
  0x81, 0xC8, 0x37, 0x77, 0x08, 0xD0, 0x67, 0x60, 0x7D, 0x04, 0x77, 0x10, 0x6F, 0xFF, 0xB0, 0xC0,
  0x47, 0x76, 0x0B, 0xC0, 0xE0, 0x17, 0x40, 0x10, 0xEC, 0x08, 0x77, 0x20, 0x6F, 0xFF, 0xD0, 0xB0,
  0x17, 0x74, 0x01, 0x0E, 0xC0, 0xA7, 0x40, 0xAC, 0x0D, 0x77, 0x30, 0x6F, 0xFF, 0xE0, 0xE0, 0x37,
  0x74, 0x05, 0xD0, 0x37, 0x20, 0x2D, 0x04, 0x77, 0x30, 0x6D, 0x0C, 0x80, 0x59, 0x81, 0xAB, 0xDF,
  0xB0, 0xE0, 0x27, 0x74, 0x0B, 0xC0, 0xC7, 0x20, 0xAC, 0x0B, 0x77, 0x40, 0x6D, 0x08, 0x75, 0x81,
  0x15, 0xAF, 0x90, 0xC7, 0x74, 0x02, 0xD0, 0x47, 0x02, 0xD0, 0x37, 0x74, 0x06, 0xD0, 0x87, 0x71,
  0x01, 0x09, 0xF0, 0x77, 0x74, 0x09, 0xC0, 0xC7, 0x08, 0xC0, 0xA7, 0x75, 0x06, 0xD0, 0x87, 0x73,
  0x05, 0xE0, 0xE7, 0x74, 0x02, 0xD0, 0x36, 0x0E, 0xC0, 0x37, 0x75, 0x06, 0xD0, 0x87, 0x74, 0x07,
  0xE0, 0x57, 0x74, 0x09, 0xC0, 0xA5, 0x05, 0xC0, 0xC7, 0x76, 0x06, 0xD0, 0x87, 0x75, 0x0C, 0xD0,
  0x97, 0x74, 0x03, 0xD0, 0x14, 0x0A, 0xC0, 0x67, 0x76, 0x06, 0xD0, 0x87, 0x75, 0x06, 0xD0, 0xD7,
  0x75, 0x0C, 0xC0, 0x64, 0xD7, 0x77, 0x06, 0xD0, 0x87, 0x75, 0x01, 0xE7, 0x75, 0x07, 0xC0, 0xB3,
  0x04, 0xC0, 0xA7, 0x77, 0x06, 0xD0, 0x87, 0x76, 0x0E, 0xD0, 0x17, 0x74, 0x01, 0xD0, 0x12, 0x09,
  0xC0, 0x67, 0x77, 0x06, 0xD0, 0x87, 0x76, 0x0D, 0xD0, 0x27, 0x75, 0x0B, 0xC0, 0x52, 0x0C, 0xC0,
  0x17, 0x77, 0x06, 0xD0, 0x87, 0x76, 0x0C, 0xD0, 0x37, 0x75, 0x07, 0xC0, 0x92, 0xC0, 0xD7, 0x77,
  0x10, 0x6D, 0x08, 0x77, 0x60, 0xDD, 0x02, 0x77, 0x50, 0x3C, 0x81, 0xC0, 0x3C, 0x0A, 0x77, 0x71,
  0x06, 0xD0, 0x87, 0x76, 0x0E, 0xD0, 0x17, 0x76, 0xD1, 0x06, 0xC0, 0x77, 0x77, 0x10, 0x6D, 0x08,
  0x77, 0x50, 0x2D, 0x0E, 0x77, 0x70, 0xCC, 0x03, 0x08, 0xC0, 0x47, 0x77, 0x10, 0x6D, 0x08, 0x77,
  0x50, 0x7D, 0x0A, 0x77, 0x70, 0x9C, 0x05, 0x0A, 0xC0, 0x27, 0x77, 0x10, 0x6D, 0x08, 0x77, 0x50,
  0xED, 0x06, 0x77, 0x70, 0x7C, 0x07, 0x0C, 0xC7, 0x77, 0x20, 0x6D, 0x08, 0x77, 0x40, 0x9D, 0x0E,
  0x01, 0x77, 0x70, 0x5C, 0x09, 0x0D, 0xB0, 0xE7, 0x77, 0x20, 0x6D, 0x08, 0x77, 0x30, 0x7E, 0x08,
  0x77, 0x71, 0x03, 0xC0, 0xA0, 0xEB, 0x0D, 0x77, 0x72, 0x06, 0xD0, 0x87, 0x71, 0x01, 0x0A, 0xE0,
  0xD7, 0x77, 0x20, 0x3C, 0x0B, 0x0E, 0xB0, 0xC7, 0x77, 0x20, 0x6D, 0x08, 0x76, 0x81, 0x17, 0xEE,
  0x0E, 0x03, 0x77, 0x72, 0x02, 0xC0, 0xCC, 0x0C, 0x77, 0x72, 0x06, 0xD0, 0xA8, 0x06, 0x38, 0x15,
  0x8B, 0xF9, 0x0E, 0x03, 0x77, 0x73, 0x01, 0xC0, 0xCC, 0x0C, 0x77, 0x72, 0x06, 0xFF, 0xFD, 0x0D,
  0x03, 0x77, 0x74, 0x01, 0xC0, 0xCC, 0x0D, 0x77, 0x72, 0x06, 0xFF, 0xFC, 0x0A, 0x01, 0x77, 0x75,
  0x01, 0xC0, 0xC0, 0xEB, 0x0D, 0x77, 0x72, 0x06, 0xFF, 0xFA, 0x0C, 0x04, 0x77, 0x77, 0x02, 0xC0,
  0xC0, 0xDB, 0x0E, 0x77, 0x72, 0x06, 0xFF, 0xF9, 0x04, 0x77, 0x77, 0x20, 0x3C, 0x0B, 0x0C, 0xC7,
  0x77, 0x20, 0x6D, 0x0E, 0x80, 0x6D, 0xE0, 0xA7, 0x77, 0x72, 0x04, 0xC0, 0xA0, 0xBC, 0x02, 0x77,
  0x71, 0x06, 0xD0, 0xA7, 0x30, 0x7E, 0x04, 0x77, 0x77, 0x10, 0x6C, 0x08, 0x09, 0xC0, 0x47, 0x77,
  0x10, 0x6D, 0x0A, 0x74, 0x0D, 0xD0, 0xD7, 0x77, 0x71, 0x08, 0xC0, 0x60, 0x7C, 0x06, 0x77, 0x71,
  0x06, 0xD0, 0xA7, 0x40, 0x4E, 0x07, 0x77, 0x77, 0x0B, 0xC0, 0x04, 0xC0, 0x97, 0x77, 0x10, 0x6D,
  0x0A, 0x75, 0x0B, 0xD0, 0xE0, 0x17, 0x77, 0x60, 0xEC, 0x00, 0x1C, 0x0D, 0x77, 0x71, 0x06, 0xD0,
  0xA7, 0x50, 0x2E, 0x0A, 0x77, 0x75, 0x02, 0xC0, 0xE2, 0x0E, 0xC0, 0x17, 0x77, 0x06, 0xD0, 0xA7,
  0x60, 0x8E, 0x04, 0x77, 0x74, 0x06, 0xC0, 0xB2, 0x0A, 0xC0, 0x57, 0x77, 0x06, 0xD0, 0xA7, 0x70,
  0xDD, 0x0D, 0x77, 0x74, 0x0A, 0xC0, 0x72, 0x06, 0xC0, 0xA7, 0x77, 0x06, 0xD0, 0xA7, 0x70, 0x5E,
  0x07, 0x77, 0x73, 0x0E, 0xC0, 0x32, 0x02, 0xC0, 0xE7, 0x77, 0x06, 0xD0, 0xA7, 0x71, 0x0B, 0xE0,
  0x27, 0x77, 0x10, 0x5C, 0x0E, 0x40, 0xCC, 0x05, 0x77, 0x60, 0x6D, 0x0A, 0x77, 0x10, 0x3E, 0x0B,
  0x77, 0x71, 0x0A, 0xC0, 0x94, 0x07, 0xC0, 0xA7, 0x76, 0x06, 0xD0, 0xA7, 0x72, 0x09, 0xE0, 0x47,
  0x76, 0x01, 0xD0, 0x44, 0x02, 0xD0, 0x27, 0x75, 0x06, 0xD0, 0xA7, 0x72, 0x01, 0x0E, 0xD0, 0xD7,
  0x76, 0x08, 0xC0, 0xD6, 0x0B, 0xC0, 0x97, 0x75, 0x06, 0xD0, 0xA7, 0x73, 0x06, 0xE0, 0x87, 0x74,
  0x01, 0x0E, 0xC0, 0x76, 0x05, 0xD0, 0x17, 0x74, 0x06, 0xD0, 0xA7, 0x74, 0x0C, 0xE0, 0x27, 0x73,
  0x07, 0xC0, 0xE0, 0x17, 0x0D, 0xC0, 0x97, 0x74, 0x06, 0xD0, 0xA7, 0x74, 0x03, 0xE0, 0xB7, 0x72,
  0x01, 0x0E, 0xC0, 0x97, 0x10, 0x6D, 0x02, 0x77, 0x30, 0x6D, 0x0A, 0x77, 0x50, 0x9E, 0x05, 0x77,
  0x10, 0x9D, 0x01, 0x72, 0x0D, 0xC0, 0xB7, 0x73, 0x06, 0xD0, 0xA7, 0x75, 0x01, 0x0E, 0xD0, 0xD7,
  0x70, 0x3D, 0x08, 0x73, 0x05, 0xD0, 0x67, 0x72, 0x06, 0xD0, 0xA7, 0x76, 0x07, 0xE0, 0x87, 0x60,
  0xDC, 0x0E, 0x01, 0x74, 0x0B, 0xC0, 0xE0, 0x27, 0x71, 0x06, 0xD0, 0xA7, 0x77, 0x0D, 0xE0, 0x27,
  0x40, 0x9D, 0x06, 0x75, 0x02, 0xD0, 0xC7, 0x71, 0x06, 0xD0, 0xA7, 0x77, 0x04, 0xE0, 0xB7, 0x30,
  0x5D, 0x0B, 0x77, 0x07, 0xD0, 0xA7, 0x70, 0x6D, 0x0A, 0x77, 0x71, 0x0A, 0xE0, 0x57, 0x10, 0x20,
  0xEC, 0x0E, 0x02, 0x77, 0x10, 0xCD, 0x07, 0x76, 0x01, 0x80, 0x13, 0x02, 0x77, 0x71, 0x01, 0x80,
  0x23, 0x02, 0x70, 0x10, 0xDD, 0x06, 0x77, 0x20, 0x10, 0xED, 0x06, 0x80, 0xE3, 0x00, 0x10, 0xCD,
  0x09, 0x77, 0x40, 0x4E, 0x06, 0x80, 0xE1, 0x00, 0x10, 0xCD, 0x0C, 0x77, 0x60, 0x6E, 0x07, 0x80,
  0xD7, 0x00, 0x10, 0xCD, 0x0D, 0x01, 0x77, 0x70, 0x7E, 0x09, 0x80, 0xD5, 0x00, 0x20, 0xDD, 0x0E,
  0x02, 0x77, 0x72, 0x08, 0xE0, 0xB0, 0x18, 0x0D, 0x20, 0x05, 0x0E, 0xD0, 0xE0, 0x27, 0x77, 0x40,
  0x8E, 0x0E, 0x04, 0x80, 0xD0, 0x00, 0x9E, 0x0D, 0x02, 0x77, 0x76, 0x06, 0xF0, 0x90, 0x18, 0x0C,
  0x40, 0x04, 0x0D, 0xE0, 0xC0, 0x17, 0x77, 0x71, 0x04, 0x0E, 0xE0, 0xE0, 0x78, 0x0C, 0x10, 0x02,
  0x0A, 0xF0, 0xA7, 0x77, 0x74, 0x02, 0x0C, 0xF0, 0xD0, 0x67, 0x77, 0x75, 0x02, 0x09, 0xF9, 0x07,
  0x77, 0x77, 0x70, 0x8F, 0x98, 0x1E, 0x81, 0x77, 0x77, 0x04, 0x0A, 0xF9, 0x0C, 0x03, 0x80, 0xC1,
  0x00, 0x20, 0xCF, 0xA8, 0x1B, 0x61, 0x77, 0x71, 0x81, 0x38, 0xDF, 0xA0, 0x78, 0x0C, 0x50, 0x05,
  0x0D, 0xFB, 0x82, 0xD9, 0x63, 0x76, 0x83, 0x14, 0x7A, 0xEF, 0xB0, 0xA0, 0x18, 0x0D, 0x00, 0x06,
  0x0E, 0xFE, 0x81, 0xEC, 0xB8, 0x01, 0x98, 0x2A, 0xBD, 0xEF, 0xE0, 0xA0, 0x28, 0x0D, 0x40, 0x05,
  0x0C, 0xFF, 0xFF, 0xD8, 0x1E, 0x92, 0x80, 0xE0, 0x08, 0x13, 0x8D, 0xFF, 0xFF, 0x0B, 0x06, 0x80,
  0xE6, 0x08, 0x23, 0x7B, 0xEF, 0xFE, 0x82, 0xDA, 0x51, 0x80, 0xF4, 0x08, 0x43, 0x58, 0xAC, 0xDF,
  0x85, 0xED, 0xB9, 0x74, 0x18, 0x09, 0x91, 0x00, 0x01, 0x80, 0xC7, 0x00,
  // "¯" (U+00AF)
  0x04, 0x80, 0xF0, 0xB0, 0x40, 0x58, 0x0F, 0x0F, 0x00, 0x58, 0x0F, 0x0F, 0x00, 0x58, 0x0F, 0x0F,
  0x00, 0x58, 0x0F, 0x0F, 0x05, 0x04, 0x80, 0xF0, 0xB0, 0x40,
  // "°" (U+00B0)
  0x76, 0x89, 0x24, 0x7A, 0xBD, 0xDD, 0xCA, 0x85, 0x17, 0x77, 0x10, 0x40, 0xAF, 0xE0, 0xB0, 0x57,
  0x74, 0x04, 0x0C, 0xFF, 0xB0, 0xD0, 0x57, 0x71, 0x09, 0xFF, 0xF0, 0xB0, 0x17, 0x40, 0x10, 0xCF,
  0xFF, 0xA0, 0xD0, 0x27, 0x20, 0x10, 0xCF, 0x89, 0x1E, 0xA6, 0x43, 0x12, 0x46, 0x9D, 0xF0, 0xE0,
  0x27, 0x10, 0xBE, 0x0D, 0x05, 0x74, 0x04, 0x0C, 0xE0, 0xE0, 0x16, 0x07, 0xE0, 0x97, 0x71, 0x07,
  0xE0, 0xB5, 0x02, 0xE0, 0x77, 0x73, 0x05, 0xE0, 0x64, 0x0A, 0xD0, 0x97, 0x75, 0x06, 0xD0, 0xE3,
  0x01, 0xD0, 0xD7, 0x77, 0x0A, 0xD0, 0x62, 0x07, 0xD0, 0x67, 0x77, 0x01, 0xD0, 0xC2, 0x0B, 0xC0,
  0xE7, 0x77, 0x20, 0xAD, 0x01, 0x1D, 0x0A, 0x77, 0x72, 0x05, 0xD0, 0x50, 0x2D, 0x06, 0x77, 0x72,
  0x01, 0xD0, 0x80, 0x4D, 0x03, 0x77, 0x73, 0x0D, 0xC0, 0xA0, 0x5D, 0x02, 0x77, 0x73, 0x0C, 0xC0,
  0xB0, 0x6D, 0x01, 0x77, 0x73, 0x0B, 0xC0, 0xC0, 0x6D, 0x01, 0x77, 0x73, 0x0B, 0xC0, 0xB0, 0x5D,
  0x02, 0x77, 0x73, 0x0C, 0xC0, 0xB0, 0x4D, 0x04, 0x77, 0x73, 0x0E, 0xC0, 0x90, 0x2D, 0x07, 0x77,
  0x72, 0x02, 0xD8, 0x17, 0x0E, 0xC0, 0xB7, 0x77, 0x20, 0x6D, 0x81, 0x40, 0xAD, 0x02, 0x77, 0x71,
  0x0C, 0xD2, 0x05, 0xD0, 0x97, 0x77, 0x04, 0xD0, 0xA3, 0x0E, 0xD0, 0x37, 0x76, 0x0D, 0xD0, 0x43,
  0x07, 0xD0, 0xD0, 0x17, 0x74, 0x09, 0xD0, 0xC5, 0x0D, 0xD0, 0xC0, 0x17, 0x72, 0x09, 0xE0, 0x35,
  0x03, 0xE0, 0xD0, 0x47, 0x60, 0x20, 0xBE, 0x08, 0x70, 0x6F, 0x0B, 0x05, 0x72, 0x03, 0x09, 0xF0,
  0xB7, 0x20, 0x7F, 0xA8, 0x6C, 0xA8, 0x77, 0x9B, 0xEF, 0x90, 0xB7, 0x40, 0x5F, 0xFF, 0xA0, 0xA7,
  0x60, 0x20, 0xCF, 0xFD, 0x0E, 0x06, 0x77, 0x20, 0x60, 0xDF, 0xF9, 0x81, 0xE9, 0x17, 0x75, 0x81,
  0x49, 0xEF, 0xA8, 0x2E, 0xB6, 0x17, 0x77, 0x38, 0x71, 0x46, 0x77, 0x77, 0x53, 0x77,
  // "±" (U+00B1)
  0x77, 0x74, 0x09, 0x80, 0x1D, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01,
  0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80,
  0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6,
  0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00,
  0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD,
  0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01,
  0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80,
  0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x80, 0xD6, 0x00, 0xAD, 0x01, 0x77, 0x74,
  0x04, 0x80, 0xA4, 0x50, 0xCD, 0x06, 0x80, 0xA4, 0x51, 0x0B, 0x80, 0xE3, 0xF0, 0x20, 0xB8, 0x0E,
  0x3F, 0x02, 0x0B, 0x80, 0xE3, 0xF0, 0x20, 0xB8, 0x0E, 0x3F, 0x02, 0x0B, 0x80, 0xE3, 0xF0, 0x28,
  0x0A, 0x53, 0x0B, 0xD0, 0x48, 0x0A, 0x43, 0x77, 0x75, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0,
  0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18,
  0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D,
  0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60,
  0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A,
  0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0,
  0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18,
  0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D, 0x60, 0x0A, 0xD0, 0x18, 0x0D,
  0x60, 0x07, 0x80, 0x1B, 0x80, 0xFB, 0x60, 0x07, 0x80, 0xE3, 0x90, 0x10, 0xB8, 0x0E, 0x3F, 0x02,
  0x0B, 0x80, 0xE3, 0xF0, 0x20, 0xB8, 0x0E, 0x3F, 0x02, 0x0B, 0x80, 0xE3, 0xF0, 0x20, 0xB8, 0x0E,
  0x3F, 0x02,
  // "²" (U+00B2)
  0x76, 0x87, 0x24, 0x57, 0x77, 0x54, 0x27, 0x77, 0x82, 0x27, 0xBE, 0xFA, 0x81, 0xEA, 0x57, 0x72,
  0x04, 0x0B, 0xFF, 0xA0, 0xE0, 0x67, 0x50, 0x40, 0xCF, 0xFE, 0x0C, 0x01, 0x71, 0x01, 0x0B, 0xFF,
  0xFA, 0x0E, 0x02, 0x60, 0x50, 0xEF, 0xA8, 0x6E, 0xC9, 0x99, 0x9B, 0xEF, 0x90, 0xE0, 0x24, 0x06,
  0xF9, 0x81, 0xC7, 0x27, 0x10, 0x20, 0x9F, 0x0C, 0x40, 0x10, 0xED, 0x0C, 0x04, 0x76, 0x02, 0x0C,
  0xE0, 0x64, 0x04, 0xB0, 0xD0, 0x57, 0x72, 0x01, 0x0C, 0xD0, 0xE5, 0x82, 0x8F, 0x91, 0x77, 0x40,
  0x2E, 0x05, 0x50, 0x57, 0x77, 0x09, 0xD0, 0x97, 0x77, 0x60, 0x3D, 0x0D, 0x77, 0x77, 0x0E, 0xD7,
  0x77, 0x70, 0xCD, 0x01, 0x77, 0x76, 0x0C, 0xD0, 0x17, 0x77, 0x60, 0xCD, 0x01, 0x77, 0x76, 0x0D,
  0xD7, 0x77, 0x60, 0x1D, 0x0C, 0x77, 0x76, 0x05, 0xD0, 0x97, 0x77, 0x60, 0xAD, 0x05, 0x77, 0x75,
  0x01, 0xD0, 0xE7, 0x77, 0x60, 0x9D, 0x08, 0x77, 0x75, 0x03, 0xD0, 0xE0, 0x17, 0x77, 0x50, 0xCD,
  0x07, 0x77, 0x75, 0x09, 0xD0, 0xC7, 0x77, 0x50, 0x6E, 0x03, 0x77, 0x74, 0x03, 0xE0, 0x67, 0x77,
  0x40, 0x20, 0xED, 0x09, 0x77, 0x74, 0x02, 0x0E, 0xD0, 0xB7, 0x77, 0x40, 0x10, 0xDD, 0x0C, 0x77,
  0x74, 0x01, 0x0D, 0xD0, 0xC0, 0x17, 0x77, 0x30, 0x10, 0xCD, 0x0D, 0x01, 0x77, 0x73, 0x01, 0x0C,
  0xD0, 0xD0, 0x17, 0x77, 0x30, 0x10, 0xCD, 0x0D, 0x02, 0x77, 0x73, 0x01, 0x0C, 0xD0, 0xE0, 0x27,
  0x77, 0x30, 0x10, 0xCD, 0x0E, 0x02, 0x77, 0x73, 0x01, 0x0C, 0xD0, 0xE0, 0x27, 0x77, 0x30, 0x10,
  0xCD, 0x0E, 0x02, 0x77, 0x73, 0x01, 0x0C, 0xD0, 0xD0, 0x27, 0x77, 0x30, 0x10, 0xCD, 0x0D, 0x02,
  0x77, 0x73, 0x01, 0x0C, 0xD0, 0xD0, 0x17, 0x77, 0x30, 0x10, 0xCD, 0x0D, 0x01, 0x77, 0x73, 0x01,
  0x0C, 0xD0, 0xC0, 0x17, 0x77, 0x30, 0x10, 0xCD, 0x0C, 0x01, 0x77, 0x73, 0x01, 0x0C, 0xD0, 0xC0,
  0x17, 0x77, 0x30, 0x10, 0xCD, 0x0B, 0x77, 0x74, 0x01, 0x0C, 0xD0, 0xB7, 0x77, 0x40, 0x10, 0xCD,
  0x0D, 0x04, 0x80, 0xA4, 0x30, 0x20, 0xBF, 0xFF, 0xFC, 0x0B, 0x0D, 0xFF, 0xFF, 0xC0, 0xB0, 0xDF,
  0xFF, 0xFC, 0x0B, 0x0D, 0xFF, 0xFF, 0xC0, 0xB0, 0xDF, 0xFF, 0xFC, 0x0B, 0x80, 0xB6, 0x10,
  // "³" (U+00B3)
  0x77, 0x18, 0x41, 0x23, 0x33, 0x17, 0x77, 0x48, 0x24, 0x7B, 0xDF, 0x98, 0x2D, 0xA7, 0x27, 0x73,
  0x81, 0x39, 0xEF, 0xFA, 0x0C, 0x04, 0x76, 0x04, 0x0C, 0xFF, 0xF0, 0xB0, 0x17, 0x20, 0x30, 0xCF,
  0xFF, 0xB0, 0xE0, 0x36, 0x01, 0x0A, 0xFD, 0x84, 0xDB, 0xBB, 0xBD, 0xFA, 0x0E, 0x03, 0x50, 0x7F,
  0xA8, 0x1A, 0x62, 0x78, 0x11, 0x5B, 0xF0, 0xE0, 0x15, 0x0C, 0xD8, 0x1D, 0x71, 0x76, 0x03, 0x0D,
  0xE0, 0x95, 0x03, 0xB0, 0xD0, 0x57, 0x74, 0x0B, 0xE0, 0x25, 0x81, 0x7E, 0x67, 0x76, 0x01, 0x0E,
  0xD0, 0x77, 0x77, 0x71, 0x07, 0xD0, 0xC7, 0x77, 0x71, 0x01, 0xD0, 0xE7, 0x77, 0x72, 0x0D, 0xD0,
  0x17, 0x77, 0x71, 0x0C, 0xD0, 0x17, 0x77, 0x71, 0x0C, 0xD0, 0x17, 0x77, 0x71, 0x0D, 0xD7, 0x77,
  0x72, 0xD0, 0xD7, 0x77, 0x71, 0x04, 0xD0, 0x97, 0x77, 0x71, 0x0B, 0xD0, 0x57, 0x77, 0x70, 0x4D,
  0x0D, 0x77, 0x77, 0x02, 0x0E, 0xD0, 0x57, 0x77, 0x60, 0x40, 0xED, 0x0A, 0x77, 0x75, 0x02, 0x0A,
  0xE0, 0xB7, 0x68, 0x06, 0x18, 0x23, 0x58, 0xDF, 0x0A, 0x77, 0x0A, 0xFF, 0xC0, 0xE0, 0x67, 0x71,
  0x0A, 0xFF, 0xA0, 0xC0, 0x77, 0x73, 0x0A, 0xFF, 0xA8, 0x1B, 0x72, 0x77, 0x20, 0xAF, 0xFD, 0x0B,
  0x03, 0x77, 0x07, 0x80, 0x5B, 0x0D, 0x0E, 0xFB, 0x09, 0x77, 0x74, 0x82, 0x14, 0x7C, 0xF0, 0xC0,
  0x17, 0x77, 0x60, 0x30, 0xAE, 0x0C, 0x77, 0x77, 0x10, 0x5E, 0x09, 0x77, 0x77, 0x10, 0x4E, 0x02,
  0x77, 0x77, 0x10, 0x9D, 0x09, 0x77, 0x77, 0x10, 0x1D, 0x0E, 0x77, 0x77, 0x20, 0xBD, 0x02, 0x77,
  0x77, 0x10, 0x8D, 0x05, 0x77, 0x77, 0x10, 0x7D, 0x06, 0x77, 0x77, 0x10, 0x7D, 0x06, 0x77, 0x77,
  0x10, 0x7D, 0x05, 0x77, 0x77, 0x10, 0x9D, 0x04, 0x77, 0x77, 0x10, 0xDD, 0x02, 0x77, 0x77, 0x03,
  0xD0, 0xE7, 0x77, 0x71, 0x0A, 0xD0, 0x97, 0x77, 0x70, 0x5E, 0x83, 0x40, 0x47, 0x17, 0x77, 0x20,
  0x30, 0xED, 0x0C, 0x20, 0x5A, 0x0A, 0x03, 0x77, 0x60, 0x6F, 0x03, 0x20, 0x5C, 0x81, 0xE9, 0x57,
  0x71, 0x05, 0x0C, 0xF0, 0x73, 0x05, 0xF9, 0x89, 0x4D, 0xA7, 0x53, 0x31, 0x12, 0x35, 0x7B, 0xEF,
  0x90, 0xA4, 0x05, 0xFF, 0xFF, 0x90, 0x95, 0x04, 0xFF, 0xFE, 0x0E, 0x05, 0x78, 0x11, 0x7D, 0xFF,
  0xF9, 0x81, 0xE8, 0x17, 0x48, 0x22, 0x7B, 0xEF, 0xF9, 0x81, 0xEB, 0x57, 0x74, 0x83, 0x24, 0x78,
  0x98, 0x02, 0xB8, 0x29, 0x85, 0x37, 0x60,
  // "´" (U+00B4)
  0x77, 0x06, 0x80, 0x4D, 0x76, 0x01, 0x0E, 0xF0, 0xA7, 0x60, 0xAF, 0x0D, 0x76, 0x05, 0xF0, 0xE0,
  0x27, 0x50, 0x10, 0xEF, 0x04, 0x76, 0x0B, 0xF0, 0x77, 0x60, 0x7F, 0x09, 0x76, 0x04, 0xF0, 0xA7,
  0x60, 0x10, 0xEE, 0x0B, 0x77, 0x0B, 0xE0, 0xC0, 0x17, 0x60, 0x9E, 0x0D, 0x01, 0x76, 0x05, 0xE0,
  0xD0, 0x17, 0x60, 0x3E, 0x0D, 0x02, 0x76, 0x01, 0x0E, 0xD0, 0xD0, 0x27, 0x70, 0xCD, 0x0D, 0x01,
  0x77, 0x0B, 0xD0, 0xC0, 0x17, 0x70, 0x9D, 0x0B, 0x01, 0x77, 0x08, 0xD0, 0xA7, 0x71, 0x02, 0xD0,
  0x87, 0x73, 0x80, 0x13, 0x77, 0x30,
  // "µ" (U+00B5)
  0x05, 0x80, 0x2D, 0x03, 0x80, 0xC0, 0x00, 0x28, 0x02, 0xD0, 0x90, 0x6E, 0x04, 0x80, 0xC0, 0x00,
  0x2E, 0x0A, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x02, 0xE0, 0xA0, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x2E,
  0x0A, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x02, 0xE0, 0xA0, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x2E, 0x0A,
  0x06, 0xE0, 0x48, 0x0C, 0x00, 0x02, 0xE0, 0xA0, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x2E, 0x0A, 0x06,
  0xE0, 0x48, 0x0C, 0x00, 0x02, 0xE0, 0xA0, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x2E, 0x0A, 0x06, 0xE0,
  0x48, 0x0C, 0x00, 0x02, 0xE0, 0xA0, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x2E, 0x0A, 0x06, 0xE0, 0x48,
  0x0C, 0x00, 0x02, 0xE0, 0xA0, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x2E, 0x0A, 0x06, 0xE0, 0x48, 0x0C,
  0x00, 0x02, 0xE0, 0xA0, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x2E, 0x0A, 0x06, 0xE0, 0x48, 0x0C, 0x00,
  0x02, 0xE0, 0xA0, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x2E, 0x0A, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x02,
  0xE0, 0xA0, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x2E, 0x0A, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x02, 0xE0,
  0xA0, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x2E, 0x0A, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x02, 0xE0, 0xA0,
  0x6E, 0x04, 0x80, 0xC0, 0x00, 0x2E, 0x0A, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x02, 0xE0, 0xA0, 0x6E,
  0x04, 0x80, 0xC0, 0x00, 0x2E, 0x0A, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x02, 0xE0, 0xA0, 0x6E, 0x04,
  0x80, 0xC0, 0x00, 0x2E, 0x0A, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x02, 0xE0, 0xA0, 0x6E, 0x04, 0x80,
  0xC0, 0x00, 0x2E, 0x0A, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x02, 0xE0, 0xA0, 0x6E, 0x04, 0x80, 0xC0,
  0x00, 0x2E, 0x0A, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x02, 0xE0, 0xA0, 0x6E, 0x04, 0x80, 0xC0, 0x00,
  0x2E, 0x0A, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x02, 0xE0, 0xA0, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x2E,
  0x0A, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x03, 0xE0, 0xA0, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x3E, 0x0A,
  0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0xA0, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x5E, 0x0A, 0x06,
  0xE0, 0x48, 0x0C, 0x00, 0x06, 0xE0, 0xA0, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x8E, 0x0A, 0x06, 0xE0,
  0x48, 0x0C, 0x00, 0x0B, 0xE0, 0xA0, 0x6E, 0x05, 0x80, 0xC0, 0x00, 0xDE, 0x0A, 0x06, 0xE0, 0x67,
  0x77, 0x77, 0x01, 0xF0, 0xA0, 0x6E, 0x08, 0x77, 0x77, 0x70, 0x5F, 0x0A, 0x06, 0xE0, 0xA7, 0x77,
  0x77, 0x09, 0xF0, 0xA0, 0x6E, 0x0D, 0x77, 0x77, 0x70, 0xEF, 0x0A, 0x06, 0xF0, 0x27, 0x77, 0x75,
  0x04, 0xF9, 0x0A, 0x06, 0xF0, 0x77, 0x77, 0x75, 0x0A, 0xF9, 0x0A, 0x06, 0xF0, 0xC7, 0x77, 0x74,
  0x02, 0xFA, 0x0A, 0x06, 0xF9, 0x04, 0x77, 0x77, 0x30, 0xAF, 0xA0, 0xA0, 0x6F, 0x90, 0xC7, 0x77,
  0x72, 0x05, 0xFB, 0x0A, 0x06, 0xFA, 0x07, 0x77, 0x77, 0x02, 0x0E, 0xFB, 0x0A, 0x06, 0xFB, 0x04,
  0x77, 0x75, 0x01, 0x0D, 0xC0, 0x3E, 0x0A, 0x06, 0xFC, 0x05, 0x77, 0x73, 0x02, 0x0D, 0xC8, 0x19,
  0x0E, 0xD0, 0xA0, 0x6F, 0xD0, 0x87, 0x77, 0x10, 0x7D, 0x0D, 0x20, 0xCD, 0x0A, 0x06, 0xE0, 0xDE,
  0x0E, 0x06, 0x77, 0x38, 0x11, 0x6D, 0xD0, 0xE0, 0x22, 0x0B, 0xD0, 0xA0, 0x6E, 0x03, 0x0E, 0xF8,
  0x2E, 0xA5, 0x27, 0x38, 0x13, 0x6B, 0xF9, 0x05, 0x30, 0x9D, 0x0A, 0x06, 0xE8, 0x11, 0x3E, 0xFC,
  0x0D, 0x80, 0x1B, 0x0C, 0x0E, 0xFC, 0x05, 0x40, 0x7D, 0x0A, 0x06, 0xE8, 0x22, 0x03, 0xEF, 0xFF,
  0xE0, 0xE0, 0x45, 0x06, 0xD0, 0xA0, 0x6E, 0x02, 0x20, 0x10, 0xCF, 0xFF, 0xC0, 0xC0, 0x16, 0x05,
  0xD0, 0xA0, 0x6E, 0x03, 0x40, 0x60, 0xEF, 0xFF, 0x0E, 0x07, 0x71, 0x03, 0xD0, 0xA0, 0x6E, 0x03,
  0x58, 0x11, 0x7D, 0xFF, 0xB8, 0x1D, 0x71, 0x72, 0x01, 0xD0, 0xA0, 0x6E, 0x03, 0x71, 0x82, 0x37,
  0xAD, 0xF9, 0x83, 0xEC, 0x96, 0x27, 0x75, 0x06, 0xE0, 0x37, 0x68, 0x41, 0x13, 0x31, 0x17, 0x77,
  0x40, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00,
  0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E,
  0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04,
  0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80,
  0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0,
  0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00,
  0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E,
  0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04, 0x80, 0xD0, 0x00, 0x6E, 0x04,
  0x80, 0xD0, 0x00, 0x58, 0x02, 0xB0, 0x38, 0x0D, 0x00,
  // "¶" (U+00B6)
  0x77, 0x78, 0x11, 0x12, 0x80, 0xB3, 0x37, 0x71, 0x83, 0x15, 0x8B, 0xDF, 0xFF, 0xFE, 0x0E, 0x76,
  0x06, 0x0B, 0x80, 0xC3, 0xF0, 0xE7, 0x40, 0x80, 0xE8, 0x0C, 0x5F, 0x0E, 0x72, 0x05, 0x0E, 0x80,
  0xC7, 0xF0, 0xE7, 0x10, 0x9F, 0xFF, 0xD0, 0xE8, 0x09, 0x19, 0x0A, 0xC0, 0xE6, 0x01, 0x0C, 0xFF,
  0xFE, 0x0B, 0x76, 0x01, 0xC0, 0xE6, 0x0C, 0xFF, 0xFF, 0x0B, 0x76, 0x01, 0xC0, 0xE5, 0x0B, 0xFF,
  0xFF, 0x90, 0xB7, 0x60, 0x1C, 0x0E, 0x40, 0x7F, 0xFF, 0xFA, 0x0B, 0x76, 0x01, 0xC0, 0xE3, 0x02,
  0xFF, 0xFF, 0xB0, 0xB7, 0x60, 0x1C, 0x0E, 0x30, 0xAF, 0xFF, 0xFB, 0x0B, 0x76, 0x01, 0xC0, 0xE2,
  0x02, 0xFF, 0xFF, 0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x20, 0x9F, 0xFF, 0xFC, 0x0B, 0x76, 0x01, 0xC0,
  0xE2, 0x0E, 0xFF, 0xFF, 0xC0, 0xB7, 0x60, 0x1C, 0x81, 0xE0, 0x5F, 0xFF, 0xFD, 0x0B, 0x76, 0x01,
  0xC8, 0x1E, 0x09, 0xFF, 0xFF, 0xD0, 0xB7, 0x60, 0x1C, 0x81, 0xE0, 0xDF, 0xFF, 0xFD, 0x0B, 0x76,
  0x01, 0xC0, 0xE0, 0x1F, 0xFF, 0xFE, 0x0B, 0x76, 0x01, 0xC0, 0xE0, 0x4F, 0xFF, 0xFE, 0x0B, 0x76,
  0x01, 0xC0, 0xE0, 0x7F, 0xFF, 0xFE, 0x0B, 0x76, 0x01, 0xC0, 0xE0, 0x9F, 0xFF, 0xFE, 0x0B, 0x76,
  0x01, 0xC0, 0xE0, 0xBF, 0xFF, 0xFE, 0x0B, 0x76, 0x01, 0xC0, 0xE0, 0xCF, 0xFF, 0xFE, 0x0B, 0x76,
  0x01, 0xC0, 0xE0, 0xDF, 0xFF, 0xFE, 0x0B, 0x76, 0x01, 0xC0, 0x0E, 0xFF, 0xFF, 0xE0, 0xB7, 0x60,
  0x1C, 0x00, 0xEF, 0xFF, 0xFE, 0x0B, 0x76, 0x01, 0xC0, 0xEF, 0xFF, 0xFF, 0x0B, 0x76, 0x01, 0xC0,
  0xEF, 0xFF, 0xFF, 0x0B, 0x76, 0x01, 0xC0, 0x0E, 0xFF, 0xFF, 0xE0, 0xB7, 0x60, 0x1C, 0x00, 0xEF,
  0xFF, 0xFE, 0x0B, 0x76, 0x01, 0xC0, 0xE0, 0xDF, 0xFF, 0xFE, 0x0B, 0x76, 0x01, 0xC0, 0xE0, 0xCF,
  0xFF, 0xFE, 0x0B, 0x76, 0x01, 0xC0, 0xE0, 0xBF, 0xFF, 0xFE, 0x0B, 0x76, 0x01, 0xC0, 0xE0, 0x9F,
  0xFF, 0xFE, 0x0B, 0x76, 0x01, 0xC0, 0xE0, 0x7F, 0xFF, 0xFE, 0x0B, 0x76, 0x01, 0xC0, 0xE0, 0x4F,
  0xFF, 0xFE, 0x0B, 0x76, 0x01, 0xC0, 0xE0, 0x1F, 0xFF, 0xFE, 0x0B, 0x76, 0x01, 0xC8, 0x1E, 0x0D,
  0xFF, 0xFF, 0xD0, 0xB7, 0x60, 0x1C, 0x81, 0xE0, 0xAF, 0xFF, 0xFD, 0x0B, 0x76, 0x01, 0xC8, 0x1E,
  0x05, 0xFF, 0xFF, 0xD0, 0xB7, 0x60, 0x1C, 0x0E, 0x2F, 0xFF, 0xFD, 0x0B, 0x76, 0x01, 0xC0, 0xE2,
  0x0A, 0xFF, 0xFF, 0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x20, 0x3F, 0xFF, 0xFC, 0x0B, 0x76, 0x01, 0xC0,
  0xE3, 0x0C, 0xFF, 0xFF, 0xB0, 0xB7, 0x60, 0x1C, 0x0E, 0x30, 0x3F, 0xFF, 0xFB, 0x0B, 0x76, 0x01,
  0xC0, 0xE4, 0x09, 0xFF, 0xFF, 0xA0, 0xB7, 0x60, 0x1C, 0x0E, 0x50, 0xDF, 0xFF, 0xF9, 0x0B, 0x76,
  0x01, 0xC0, 0xE5, 0x03, 0x0E, 0xFF, 0xFF, 0x0B, 0x76, 0x01, 0xC0, 0xE6, 0x04, 0xFF, 0xFF, 0x0B,
  0x76, 0x01, 0xC0, 0xE7, 0x04, 0x0E, 0xFF, 0xFD, 0x0B, 0x76, 0x01, 0xC0, 0xE7, 0x10, 0x20, 0xCF,
  0xFF, 0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x73, 0x07, 0x0E, 0xFF, 0xFA, 0x0B, 0x76, 0x01, 0xC0, 0xE7,
  0x48, 0x11, 0x8E, 0xFF, 0xF0, 0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x81, 0x48, 0xCF, 0xC8, 0x1C, 0x98,
  0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x40, 0x20, 0x38, 0x01, 0x50, 0x30, 0x23, 0x04, 0xC0, 0xB7,
  0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C, 0x0B, 0x76, 0x01, 0xC0, 0xE7, 0x77, 0x72, 0x04, 0xC0,
  0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C, 0x0B, 0x76, 0x01, 0xC0, 0xE7, 0x77, 0x72, 0x04,
  0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C, 0x0B, 0x76, 0x01, 0xC0, 0xE7, 0x77, 0x72,
  0x04, 0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C, 0x0B, 0x76, 0x01, 0xC0, 0xE7, 0x77,
  0x72, 0x04, 0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C, 0x0B, 0x76, 0x01, 0xC0, 0xE7,
  0x77, 0x72, 0x04, 0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C, 0x0B, 0x76, 0x01, 0xC0,
  0xE7, 0x77, 0x72, 0x04, 0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C, 0x0B, 0x76, 0x01,
  0xC0, 0xE7, 0x77, 0x72, 0x04, 0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C, 0x0B, 0x76,
  0x01, 0xC0, 0xE7, 0x77, 0x72, 0x04, 0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C, 0x0B,
  0x76, 0x01, 0xC0, 0xE7, 0x77, 0x72, 0x04, 0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C,
  0x0B, 0x76, 0x01, 0xC0, 0xE7, 0x77, 0x72, 0x04, 0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20,
  0x4C, 0x0B, 0x76, 0x01, 0xC0, 0xE7, 0x77, 0x72, 0x04, 0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x77,
  0x20, 0x4C, 0x0B, 0x76, 0x01, 0xC0, 0xE7, 0x77, 0x72, 0x04, 0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x77,
  0x77, 0x20, 0x4C, 0x0B, 0x76, 0x01, 0xC0, 0xE7, 0x77, 0x72, 0x04, 0xC0, 0xB7, 0x60, 0x1C, 0x0E,
  0x77, 0x77, 0x20, 0x4C, 0x0B, 0x76, 0x01, 0xC0, 0xE7, 0x77, 0x72, 0x04, 0xC0, 0xB7, 0x60, 0x1C,
  0x0E, 0x77, 0x77, 0x20, 0x4C, 0x0B, 0x76, 0x01, 0xC0, 0xE7, 0x77, 0x72, 0x04, 0xC0, 0xB7, 0x60,
  0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C, 0x0B, 0x76, 0x01, 0xC0, 0xE7, 0x77, 0x72, 0x04, 0xC0, 0xB7,
  0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C, 0x0B, 0x76, 0x01, 0xC0, 0xE7, 0x77, 0x72, 0x04, 0xC0,
  0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C, 0x0B, 0x76, 0x01, 0xC0, 0xE7, 0x77, 0x72, 0x04,
  0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C, 0x0B, 0x76, 0x01, 0xC0, 0xE7, 0x77, 0x72,
  0x04, 0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C, 0x0B, 0x76, 0x01, 0xC0, 0xE7, 0x77,
  0x72, 0x04, 0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C, 0x0B, 0x76, 0x01, 0xC0, 0xE7,
  0x77, 0x72, 0x04, 0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C, 0x0B, 0x76, 0x01, 0xC0,
  0xE7, 0x77, 0x72, 0x04, 0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C, 0x0B, 0x76, 0x01,
  0xC0, 0xE7, 0x77, 0x72, 0x04, 0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C, 0x0B, 0x76,
  0x01, 0xC0, 0xE7, 0x77, 0x72, 0x04, 0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C, 0x0B,
  0x76, 0x01, 0xC0, 0xE7, 0x77, 0x72, 0x04, 0xC0, 0xB7, 0x60, 0x1C, 0x0E, 0x77, 0x77, 0x20, 0x4C,
  0x0B, 0x76, 0x01, 0xC0, 0xE7, 0x77, 0x72, 0x01, 0x80, 0x13, 0x77, 0x80, 0x13,
  // "·" (U+00B7)
  0x28, 0x51, 0x7B, 0xDB, 0x93, 0x30, 0x30, 0xEE, 0x06, 0x20, 0xDF, 0x90, 0x20, 0x4F, 0xA0, 0x80,
  0x7F, 0xA0, 0xC0, 0x9F, 0xA0, 0xD0, 0x9F, 0xA0, 0xD0, 0x8F, 0xA0, 0xC0, 0x4F, 0xA8, 0x19, 0x0D,
  0xF9, 0x82, 0x30, 0x3E, 0xE0, 0x73, 0x85, 0x28, 0xCD, 0xDA, 0x42,
  // "¸" (U+00B8)
  0x73, 0x0E, 0xB0, 0xE0, 0x17, 0x72, 0x07, 0xC0, 0x87, 0x73, 0x0E, 0xB0, 0xE0, 0x17, 0x72, 0x07,
  0xC0, 0x87, 0x73, 0x0E, 0xB0, 0xE0, 0x17, 0x72, 0x07, 0xC0, 0x87, 0x73, 0x0E, 0xB0, 0xE0, 0x17,
  0x72, 0x07, 0xC8, 0x2E, 0xC9, 0x57, 0x70, 0xEF, 0xA0, 0xA0, 0x37, 0x30, 0x7F, 0xD0, 0x97, 0x28,
  0x34, 0x67, 0xAC, 0xFA, 0x0D, 0x01, 0x76, 0x04, 0x0A, 0xF0, 0xC7, 0x71, 0x01, 0x0A, 0xE0, 0x77,
  0x72, 0x09, 0xD0, 0xE7, 0x73, 0x0D, 0xD0, 0x37, 0x72, 0x07, 0xD0, 0x67, 0x72, 0x04, 0xD0, 0x77,
  0x72, 0x03, 0xD0, 0x77, 0x72, 0x05, 0xD0, 0x67, 0x72, 0x09, 0xD0, 0x47, 0x71, 0x01, 0x0E, 0xD7,
  0x71, 0x01, 0x0C, 0xD0, 0xA7, 0x70, 0x50, 0xDE, 0x85, 0x20, 0x45, 0x31, 0x13, 0x83, 0x12, 0x58,
  0xDF, 0x08, 0x20, 0x8F, 0xFC, 0x0A, 0x30, 0x8F, 0xFB, 0x08, 0x40, 0x8F, 0xF9, 0x0C, 0x03, 0x50,
  0x8F, 0xD8, 0x1E, 0xA4, 0x78, 0x21, 0x57, 0x98, 0x01, 0xB8, 0x2A, 0x86, 0x37, 0x30,
  // "¹" (U+00B9)
  0x77, 0x28, 0x02, 0x37, 0x70, 0x20, 0xBD, 0x0E, 0x76, 0x07, 0xF0, 0xE7, 0x40, 0x30, 0xDF, 0x90,
  0xE7, 0x20, 0x10, 0x9F, 0xB0, 0xE7, 0x10, 0x60, 0xEF, 0xC0, 0xE6, 0x02, 0x0C, 0xF0, 0xD0, 0xBC,
  0x0E, 0x50, 0x8F, 0x98, 0x19, 0x09, 0xC0, 0xE3, 0x05, 0x0D, 0xF0, 0xE0, 0x52, 0x0A, 0xC8, 0x2E,
  0x02, 0xBF, 0x90, 0xB0, 0x13, 0x0B, 0xC8, 0x1E, 0x4E, 0xF0, 0xD0, 0x45, 0x0B, 0xC8, 0x1E, 0x0D,
  0xE0, 0x77, 0x0B, 0xC8, 0x1E, 0x04, 0xC0, 0xB0, 0x27, 0x10, 0xCC, 0x0E, 0x28, 0x2A, 0xFE, 0x67,
  0x30, 0xCC, 0x0E, 0x28, 0x11, 0x91, 0x74, 0x0C, 0xC0, 0xE7, 0x72, 0x0C, 0xC0, 0xE7, 0x72, 0x0C,
  0xC0, 0xE7, 0x72, 0x0C, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D,
  0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D,
  0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D,
  0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D,
  0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D,
  0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D,
  0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D,
  0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D,
  0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x0D, 0xC0, 0xE7, 0x72, 0x80,
  0x21,
  // "º" (U+00BA)
  0x75, 0x89, 0x22, 0x69, 0xBC, 0xDD, 0xCB, 0x96, 0x37, 0x77, 0x81, 0x17, 0xDF, 0xD8, 0x1E, 0x81,
  0x77, 0x30, 0x70, 0xEF, 0xFB, 0x08, 0x77, 0x01, 0x0C, 0xFF, 0xE0, 0xD0, 0x27, 0x40, 0x30, 0xEF,
  0xB0, 0x0E, 0xFB, 0x0E, 0x03, 0x72, 0x02, 0x0E, 0xE8, 0x2E, 0x94, 0x14, 0x82, 0x14, 0x8D, 0xE0,
  0xE0, 0x37, 0x01, 0x0D, 0xD0, 0xE0, 0x67, 0x50, 0x60, 0xED, 0x0D, 0x70, 0xAD, 0x0D, 0x02, 0x77,
  0x02, 0x0D, 0xD0, 0x95, 0x04, 0xD0, 0xD0, 0x17, 0x72, 0x01, 0x0E, 0xD0, 0x34, 0x0C, 0xD0, 0x37,
  0x74, 0x05, 0xD0, 0xA3, 0x03, 0xD0, 0x97, 0x76, 0x0B, 0xD0, 0x22, 0x09, 0xD0, 0x17, 0x76, 0x04,
  0xD0, 0x72, 0x0E, 0xC0, 0xB7, 0x77, 0x10, 0xDC, 0x81, 0xC0, 0x2D, 0x06, 0x77, 0x71, 0x08, 0xD0,
  0x10, 0x5D, 0x02, 0x77, 0x71, 0x04, 0xD0, 0x40, 0x8C, 0x0E, 0x77, 0x72, 0x01, 0xD0, 0x70, 0xAC,
  0x0C, 0x77, 0x73, 0x0E, 0xC0, 0x90, 0xCC, 0x0B, 0x77, 0x73, 0x0C, 0xC0, 0xB0, 0xDC, 0x09, 0x77,
  0x73, 0x0B, 0xC0, 0xC0, 0xDC, 0x09, 0x77, 0x73, 0x0A, 0xC0, 0xC0, 0xEC, 0x09, 0x77, 0x73, 0x0A,
  0xC0, 0xC0, 0xDC, 0x09, 0x77, 0x73, 0x0B, 0xC0, 0x0C, 0xC0, 0xA7, 0x77, 0x30, 0xCC, 0x00, 0xBC,
  0x0B, 0x77, 0x73, 0x0D, 0xC0, 0xA0, 0x9C, 0x0E, 0x77, 0x73, 0xD0, 0x80, 0x7D, 0x01, 0x77, 0x71,
  0x03, 0xD0, 0x50, 0x4D, 0x05, 0x77, 0x71, 0x06, 0xD8, 0x12, 0x0E, 0xC0, 0x97, 0x77, 0x10, 0xBC,
  0x0E, 0x20, 0xAC, 0x0E, 0x77, 0x70, 0x1D, 0x09, 0x20, 0x5D, 0x06, 0x77, 0x60, 0x8D, 0x03, 0x30,
  0xDC, 0x0D, 0x77, 0x50, 0x10, 0xEC, 0x0C, 0x40, 0x6D, 0x09, 0x77, 0x40, 0xBD, 0x05, 0x50, 0xCD,
  0x07, 0x77, 0x20, 0x9D, 0x0B, 0x60, 0x3E, 0x08, 0x76, 0x01, 0x0A, 0xD0, 0xE0, 0x27, 0x06, 0xE0,
  0xD0, 0x57, 0x28, 0x11, 0x7E, 0xE0, 0x57, 0x20, 0x7F, 0x87, 0xEB, 0x86, 0x55, 0x68, 0xCF, 0x90,
  0x67, 0x40, 0x6F, 0xFF, 0x90, 0x57, 0x60, 0x30, 0xDF, 0xFC, 0x0C, 0x03, 0x77, 0x20, 0x60, 0xEF,
  0xF0, 0xD0, 0x67, 0x76, 0x81, 0x49, 0xDF, 0x98, 0x1C, 0x83, 0x77, 0x75, 0x84, 0x23, 0x33, 0x32,
  0x77, 0x10,
  // "»" (U+00BB)
  0x30, 0x10, 0x67, 0x77, 0x06, 0x77, 0x78, 0x26, 0xEF, 0x77, 0x74, 0x82, 0x5E, 0xF8, 0x77, 0x40,
  0x20, 0xCC, 0x04, 0x77, 0x10, 0x20, 0xBC, 0x05, 0x77, 0x30, 0xDD, 0x0E, 0x02, 0x77, 0x0C, 0xE0,
  0x37, 0x72, 0x03, 0x0E, 0xD0, 0xD0, 0x17, 0x60, 0x20, 0xED, 0x0E, 0x01, 0x77, 0x20, 0x5E, 0x0B,
  0x77, 0x04, 0xE0, 0xC7, 0x73, 0x08, 0xE0, 0x97, 0x70, 0x8E, 0x0A, 0x77, 0x30, 0xBE, 0x06, 0x77,
  0x0B, 0xE0, 0x87, 0x72, 0x01, 0x0D, 0xE0, 0x47, 0x60, 0x10, 0xDE, 0x05, 0x77, 0x20, 0x3E, 0x0E,
  0x02, 0x76, 0x03, 0xF0, 0x37, 0x72, 0x06, 0xE0, 0xD0, 0x17, 0x60, 0x5E, 0x0D, 0x01, 0x77, 0x20,
  0x9E, 0x0B, 0x77, 0x09, 0xE0, 0xC7, 0x73, 0x0C, 0xE0, 0x97, 0x70, 0xCE, 0x0A, 0x77, 0x20, 0x10,
  0xEE, 0x06, 0x76, 0x01, 0x0E, 0xE0, 0x77, 0x72, 0x04, 0xF0, 0x47, 0x60, 0x3F, 0x05, 0x77, 0x20,
  0x7E, 0x0E, 0x02, 0x76, 0x07, 0xE0, 0xE0, 0x37, 0x72, 0x0A, 0xE0, 0xD0, 0x17, 0x60, 0xAE, 0x0D,
  0x01, 0x77, 0x20, 0xDE, 0x0B, 0x77, 0x0D, 0xE0, 0xC7, 0x72, 0x02, 0x0E, 0xE0, 0x87, 0x60, 0x20,
  0xEE, 0x0A, 0x77, 0x20, 0x5F, 0x06, 0x76, 0x05, 0xF0, 0x77, 0x72, 0x08, 0xF0, 0x37, 0x60, 0x8F,
  0x05, 0x77, 0x20, 0xBE, 0x0E, 0x02, 0x76, 0x0B, 0xE0, 0xE0, 0x27, 0x71, 0x01, 0x0D, 0xE0, 0xD7,
  0x60, 0x10, 0xDE, 0x0D, 0x01, 0x77, 0x10, 0x30, 0xEE, 0x0A, 0x76, 0x03, 0xF0, 0xB7, 0x72, 0x0A,
  0xE0, 0xD7, 0x70, 0xBE, 0x0E, 0x77, 0x10, 0x5F, 0x07, 0x76, 0x06, 0xF0, 0x87, 0x70, 0x3F, 0x0A,
  0x76, 0x03, 0xF0, 0xB7, 0x70, 0x10, 0xDE, 0x0C, 0x76, 0x01, 0x0D, 0xE0, 0xD0, 0x17, 0x70, 0xBE,
  0x0D, 0x01, 0x76, 0x0B, 0xE0, 0xE0, 0x27, 0x70, 0x8E, 0x0E, 0x03, 0x76, 0x08, 0xF0, 0x47, 0x70,
  0x5F, 0x05, 0x76, 0x05, 0xF0, 0x67, 0x70, 0x20, 0xEE, 0x07, 0x76, 0x02, 0x0E, 0xE0, 0x97, 0x71,
  0x0D, 0xE0, 0xA7, 0x70, 0xDE, 0x0B, 0x77, 0x10, 0xAE, 0x0C, 0x77, 0x0A, 0xE0, 0xD0, 0x17, 0x70,
  0x7E, 0x0E, 0x01, 0x76, 0x07, 0xE0, 0xE0, 0x27, 0x70, 0x4F, 0x03, 0x76, 0x04, 0xF0, 0x47, 0x70,
  0x20, 0xEE, 0x05, 0x76, 0x01, 0x0E, 0xE0, 0x67, 0x71, 0x0C, 0xE0, 0x87, 0x70, 0xCE, 0x09, 0x77,
  0x10, 0x9E, 0x0A, 0x77, 0x09, 0xE0, 0xB7, 0x71, 0x06, 0xE0, 0xC7, 0x70, 0x5E, 0x0D, 0x01, 0x77,
  0x03, 0xE0, 0xE0, 0x17, 0x60, 0x3E, 0x0E, 0x02, 0x77, 0x01, 0x0E, 0xE0, 0x37, 0x60, 0x10, 0xDE,
  0x04, 0x77, 0x10, 0xCE, 0x05, 0x77, 0x0B, 0xE0, 0x77, 0x71, 0x09, 0xE0, 0x87, 0x70, 0x8E, 0x09,
  0x77, 0x10, 0x5E, 0x0B, 0x77, 0x04, 0xE0, 0xB7, 0x72, 0x0C, 0xD0, 0xC7, 0x71, 0x0B, 0xD0, 0xD0,
  0x17, 0x73, 0x07, 0xB0, 0xE0, 0x27, 0x72, 0x07, 0x0E, 0xA0, 0xE0, 0x27, 0x75, 0x82, 0x2B, 0xF3,
  0x77, 0x48, 0x21, 0xAF, 0x47, 0x77, 0x10, 0x27, 0x77, 0x02, 0x77, 0x50,
  // "¼" (U+00BC)
  0x77, 0x10, 0x68, 0x01, 0xB0, 0x58, 0x0C, 0x30, 0x04, 0x80, 0x1B, 0x0A, 0x77, 0x77, 0x02, 0x0C,
  0xE0, 0x78, 0x0C, 0x30, 0x0D, 0xD0, 0x57, 0x77, 0x60, 0x8F, 0x90, 0x78, 0x0C, 0x20, 0x06, 0xD0,
  0xC7, 0x77, 0x50, 0x50, 0xDF, 0xA0, 0x78, 0x0C, 0x10, 0x01, 0x0E, 0xD0, 0x37, 0x77, 0x30, 0x10,
  0xAF, 0xC0, 0x78, 0x0C, 0x10, 0x08, 0xD0, 0xA7, 0x77, 0x30, 0x70, 0xEF, 0xD0, 0x78, 0x0C, 0x00,
  0x02, 0xE0, 0x27, 0x77, 0x10, 0x30, 0xCF, 0x0D, 0x04, 0xD0, 0x78, 0x0C, 0x00, 0x0A, 0xD0, 0x87,
  0x77, 0x01, 0x09, 0xF9, 0x81, 0x90, 0x1D, 0x07, 0x77, 0x77, 0x70, 0x4D, 0x0E, 0x77, 0x70, 0x50,
  0xEF, 0x0E, 0x05, 0x20, 0x2D, 0x07, 0x77, 0x77, 0x70, 0xCD, 0x06, 0x77, 0x50, 0x20, 0xBF, 0x90,
  0xA0, 0x13, 0x02, 0xD0, 0x77, 0x77, 0x76, 0x06, 0xD0, 0xC7, 0x76, 0x0B, 0xF0, 0xC0, 0x35, 0x02,
  0xD0, 0x77, 0x77, 0x76, 0x0E, 0xD0, 0x47, 0x76, 0x02, 0xD0, 0xE0, 0x77, 0x03, 0xD0, 0x77, 0x77,
  0x75, 0x08, 0xD0, 0xB7, 0x77, 0x10, 0x7B, 0x0B, 0x02, 0x71, 0x03, 0xD0, 0x77, 0x77, 0x74, 0x01,
  0xE0, 0x27, 0x77, 0x28, 0x1C, 0xE5, 0x73, 0x03, 0xD0, 0x77, 0x77, 0x74, 0x0A, 0xD0, 0x97, 0x77,
  0x30, 0x20, 0x17, 0x40, 0x3D, 0x07, 0x77, 0x77, 0x30, 0x3D, 0x0E, 0x01, 0x80, 0xC1, 0x00, 0x3D,
  0x07, 0x77, 0x77, 0x30, 0xCD, 0x07, 0x80, 0xC2, 0x00, 0x4D, 0x07, 0x77, 0x77, 0x20, 0x5D, 0x0D,
  0x80, 0xC3, 0x00, 0x4D, 0x07, 0x77, 0x77, 0x20, 0xDD, 0x05, 0x80, 0xC3, 0x00, 0x4D, 0x07, 0x77,
  0x77, 0x10, 0x7D, 0x0B, 0x80, 0xC4, 0x00, 0x4D, 0x07, 0x77, 0x77, 0x01, 0x0E, 0xD0, 0x38, 0x0C,
  0x40, 0x04, 0xD0, 0x77, 0x77, 0x70, 0x9D, 0x09, 0x80, 0xC5, 0x00, 0x4D, 0x07, 0x77, 0x76, 0x03,
  0xD0, 0xE0, 0x18, 0x0C, 0x50, 0x04, 0xD0, 0x77, 0x77, 0x60, 0xBD, 0x07, 0x80, 0xC6, 0x00, 0x4D,
  0x07, 0x77, 0x75, 0x05, 0xD0, 0xD8, 0x0C, 0x70, 0x04, 0xD0, 0x77, 0x77, 0x50, 0xDD, 0x05, 0x80,
  0xC7, 0x00, 0x4D, 0x07, 0x77, 0x74, 0x07, 0xD0, 0xC8, 0x0D, 0x00, 0x04, 0xD0, 0x77, 0x77, 0x30,
  0x10, 0xED, 0x03, 0x80, 0xD0, 0x00, 0x4D, 0x07, 0x77, 0x73, 0x09, 0xD0, 0xA8, 0x0D, 0x10, 0x04,
  0xD0, 0x77, 0x77, 0x20, 0x2E, 0x01, 0x80, 0xD1, 0x00, 0x4D, 0x07, 0x77, 0x72, 0x0B, 0xD0, 0x88,
  0x0D, 0x20, 0x04, 0xD0, 0x77, 0x77, 0x10, 0x4D, 0x0E, 0x80, 0xD3, 0x00, 0x4D, 0x07, 0x77, 0x71,
  0x0C, 0xD0, 0x68, 0x0D, 0x30, 0x04, 0xD0, 0x77, 0x77, 0x06, 0xD0, 0xC8, 0x0D, 0x40, 0x04, 0xD0,
  0x77, 0x77, 0x0E, 0xD0, 0x48, 0x0D, 0x40, 0x04, 0xD0, 0x77, 0x76, 0x08, 0xD0, 0xA7, 0x75, 0x0A,
  0x80, 0x1B, 0x04, 0x77, 0x72, 0x04, 0xD0, 0x77, 0x75, 0x02, 0xE0, 0x27, 0x74, 0x08, 0xE0, 0x67,
  0x77, 0x20, 0x4D, 0x07, 0x77, 0x50, 0xAD, 0x08, 0x77, 0x40, 0x4F, 0x06, 0x77, 0x72, 0x04, 0xD0,
  0x77, 0x74, 0x03, 0xD0, 0xE0, 0x17, 0x73, 0x01, 0x0D, 0xF0, 0x67, 0x77, 0x20, 0x4D, 0x07, 0x77,
  0x40, 0xCD, 0x06, 0x77, 0x40, 0xAF, 0x90, 0x67, 0x77, 0x20, 0x4D, 0x07, 0x77, 0x30, 0x5D, 0x0D,
  0x77, 0x40, 0x5F, 0xA0, 0x67, 0x77, 0x20, 0x4D, 0x07, 0x77, 0x30, 0xDD, 0x04, 0x77, 0x30, 0x10,
  0xEF, 0xA0, 0x67, 0x77, 0x20, 0x4D, 0x07, 0x77, 0x20, 0x7D, 0x0B, 0x77, 0x40, 0xBC, 0x0A, 0xD0,
  0x67, 0x77, 0x20, 0x4D, 0x07, 0x77, 0x10, 0x10, 0xED, 0x02, 0x77, 0x30, 0x7C, 0x0B, 0x06, 0xD0,
  0x67, 0x77, 0x20, 0x4D, 0x07, 0x77, 0x10, 0x9D, 0x09, 0x77, 0x30, 0x3D, 0x02, 0x07, 0xD0, 0x67,
  0x77, 0x20, 0x4D, 0x07, 0x77, 0x03, 0xD0, 0xE0, 0x17, 0x73, 0x0C, 0xC8, 0x17, 0x07, 0xD0, 0x67,
  0x77, 0x20, 0x4D, 0x07, 0x77, 0x0B, 0xD0, 0x77, 0x73, 0x08, 0xC0, 0xC2, 0x08, 0xD0, 0x67, 0x77,
  0x20, 0x4D, 0x07, 0x76, 0x05, 0xD0, 0xD7, 0x73, 0x04, 0xC0, 0xE0, 0x22, 0x08, 0xD0, 0x67, 0x77,
  0x20, 0x4D, 0x07, 0x76, 0x0D, 0xD0, 0x57, 0x72, 0x01, 0x0D, 0xC0, 0x63, 0x08, 0xD0, 0x67, 0x77,
  0x20, 0x4D, 0x07, 0x75, 0x07, 0xD0, 0xC7, 0x73, 0x0A, 0xC0, 0xB4, 0x08, 0xD0, 0x67, 0x77, 0x20,
  0x4D, 0x07, 0x74, 0x01, 0x0E, 0xD0, 0x37, 0x72, 0x05, 0xC0, 0xE0, 0x14, 0x09, 0xD0, 0x67, 0x77,
  0x20, 0x4D, 0x07, 0x74, 0x09, 0xD0, 0xA7, 0x72, 0x01, 0x0E, 0xC0, 0x55, 0x09, 0xD0, 0x67, 0x77,
  0x20, 0x28, 0x01, 0x90, 0x47, 0x30, 0x2D, 0x0E, 0x01, 0x77, 0x20, 0xBC, 0x0A, 0x60, 0x9D, 0x06,
  0x80, 0xC4, 0x00, 0xBD, 0x08, 0x77, 0x20, 0x7C, 0x0D, 0x70, 0x9D, 0x06, 0x80, 0xC3, 0x00, 0x4D,
  0x0D, 0x77, 0x20, 0x3D, 0x03, 0x70, 0x9D, 0x06, 0x80, 0xC3, 0x00, 0xDD, 0x05, 0x77, 0x20, 0xCC,
  0x08, 0x71, 0x09, 0xD0, 0x68, 0x0C, 0x20, 0x06, 0xD0, 0xC7, 0x72, 0x08, 0xC0, 0xC7, 0x20, 0x9D,
  0x06, 0x80, 0xC1, 0x00, 0x10, 0xED, 0x03, 0x77, 0x10, 0x4C, 0x0E, 0x02, 0x72, 0x09, 0xD0, 0x68,
  0x0C, 0x10, 0x08, 0xD0, 0xA7, 0x71, 0x01, 0x0D, 0xC0, 0x67, 0x30, 0x9D, 0x06, 0x80, 0xC0, 0x00,
  0x2E, 0x02, 0x77, 0x10, 0xAC, 0x0A, 0x74, 0x09, 0xD0, 0x68, 0x0C, 0x00, 0x0A, 0xD0, 0x87, 0x71,
  0x05, 0xC0, 0xE0, 0x17, 0x40, 0x9D, 0x06, 0x77, 0x77, 0x70, 0x4D, 0x0E, 0x01, 0x77, 0x01, 0x0E,
  0xC0, 0x47, 0x50, 0x9D, 0x06, 0x77, 0x77, 0x70, 0xCD, 0x06, 0x77, 0x10, 0xBC, 0x09, 0x76, 0x09,
  0xD0, 0x67, 0x77, 0x76, 0x06, 0xD0, 0xD7, 0x71, 0x07, 0xC0, 0xD7, 0x70, 0x9D, 0x06, 0x77, 0x77,
  0x60, 0xED, 0x04, 0x77, 0x03, 0xD0, 0x37, 0x70, 0x9D, 0x06, 0x77, 0x77, 0x50, 0x8D, 0x0B, 0x77,
  0x10, 0xCC, 0x07, 0x77, 0x10, 0x9D, 0x06, 0x77, 0x77, 0x40, 0x10, 0xED, 0x02, 0x77, 0x08, 0xC0,
  0xB7, 0x72, 0x09, 0xD0, 0x67, 0x77, 0x74, 0x0A, 0xD0, 0x97, 0x70, 0x4C, 0x0E, 0x01, 0x77, 0x20,
  0x9D, 0x06, 0x77, 0x77, 0x30, 0x3D, 0x0E, 0x01, 0x76, 0x01, 0x0D, 0xC0, 0xE8, 0x09, 0x5B, 0x0D,
  0xD0, 0xD8, 0x03, 0xB0, 0x57, 0x77, 0x20, 0xCD, 0x07, 0x77, 0x07, 0x80, 0xC1, 0xF0, 0x67, 0x77,
  0x10, 0x5D, 0x0D, 0x77, 0x10, 0x78, 0x0C, 0x1F, 0x06, 0x77, 0x71, 0x0D, 0xD0, 0x57, 0x71, 0x07,
  0x80, 0xC1, 0xF0, 0x67, 0x77, 0x07, 0xD0, 0xB7, 0x72, 0x07, 0x80, 0xC1, 0xF0, 0x67, 0x76, 0x01,
  0x0E, 0xD0, 0x37, 0x72, 0x01, 0x80, 0xA3, 0x30, 0xAD, 0x08, 0x80, 0x33, 0x01, 0x77, 0x60, 0x9D,
  0x09, 0x80, 0xC5, 0x00, 0x9D, 0x06, 0x77, 0x76, 0x02, 0xD0, 0xE0, 0x18, 0x0C, 0x50, 0x09, 0xD0,
  0x67, 0x77, 0x60, 0xBD, 0x07, 0x80, 0xC6, 0x00, 0x9D, 0x06, 0x77, 0x75, 0x04, 0xD0, 0xD8, 0x0C,
  0x70, 0x09, 0xD0, 0x67, 0x77, 0x50, 0xDD, 0x05, 0x80, 0xC7, 0x00, 0x9D, 0x06, 0x77, 0x74, 0x06,
  0xD0, 0xC8, 0x0D, 0x00, 0x09, 0xD0, 0x67, 0x77, 0x30, 0x10, 0xED, 0x03, 0x80, 0xD0, 0x00, 0x9D,
  0x06, 0x77, 0x73, 0x08, 0xD0, 0xA8, 0x0D, 0x10, 0x09, 0xD0, 0x67, 0x77, 0x20, 0x2E, 0x02, 0x80,
  0xD1, 0x00, 0x9D, 0x06, 0x77, 0x72, 0x0A, 0xD0, 0x88, 0x0D, 0x20, 0x09, 0xD0, 0x67, 0x77, 0x10,
  0x4D, 0x0E, 0x80, 0xD3, 0x00, 0x9D, 0x06, 0x77, 0x71, 0x0C, 0xD0, 0x68, 0x0D, 0x30, 0x09, 0xD0,
  0x67, 0x77, 0x06, 0xD0, 0xC8, 0x0D, 0x40, 0x09, 0xD0, 0x67, 0x10,
  // "½" (U+00BD)
  0x77, 0x10, 0x38, 0x01, 0xB0, 0x88, 0x0C, 0x30, 0x80, 0x2B, 0x01, 0x77, 0x77, 0x20, 0x10, 0x9E,
  0x0B, 0x80, 0xC2, 0x00, 0x8D, 0x08, 0x77, 0x77, 0x20, 0x50, 0xEF, 0x0B, 0x80, 0xC1, 0x00, 0x2D,
  0x0E, 0x01, 0x77, 0x77, 0x02, 0x0B, 0xFA, 0x0B, 0x80, 0xC1, 0x00, 0xAD, 0x06, 0x77, 0x77, 0x08,
  0xFC, 0x0B, 0x80, 0xC0, 0x00, 0x3D, 0x0D, 0x77, 0x76, 0x04, 0x0D, 0xFD, 0x0B, 0x80, 0xC0, 0x00,
  0xCD, 0x04, 0x77, 0x74, 0x01, 0x0A, 0xF8, 0x1E, 0x5C, 0xC0, 0xB7, 0x77, 0x77, 0x05, 0xD0, 0xB7,
  0x77, 0x40, 0x60, 0xEF, 0x82, 0xC2, 0x0C, 0xC0, 0xB7, 0x77, 0x77, 0x0D, 0xD0, 0x27, 0x77, 0x20,
  0x30, 0xCF, 0x90, 0x83, 0x0D, 0xC0, 0xB7, 0x77, 0x76, 0x07, 0xD0, 0x97, 0x77, 0x10, 0x10, 0x9F,
  0x90, 0xC0, 0x34, 0x0D, 0xC0, 0xB7, 0x77, 0x75, 0x01, 0x0E, 0xC0, 0xE0, 0x17, 0x77, 0x10, 0x7F,
  0x0E, 0x05, 0x60, 0xDC, 0x0B, 0x77, 0x77, 0x50, 0x9D, 0x07, 0x77, 0x73, 0x0C, 0xD0, 0x90, 0x17,
  0x0E, 0xC0, 0xB7, 0x77, 0x74, 0x03, 0xD0, 0xD7, 0x77, 0x40, 0x3B, 0x0D, 0x04, 0x72, 0x0E, 0xC0,
  0xB7, 0x77, 0x74, 0x0B, 0xD0, 0x57, 0x77, 0x58, 0x19, 0xF8, 0x74, 0x0E, 0xC0, 0xB7, 0x77, 0x73,
  0x05, 0xD0, 0xB7, 0x77, 0x70, 0x37, 0x50, 0xEC, 0x0B, 0x77, 0x77, 0x30, 0xDD, 0x03, 0x80, 0xC5,
  0x0D, 0x0B, 0x77, 0x77, 0x20, 0x7D, 0x09, 0x80, 0xC6, 0x0D, 0x0B, 0x77, 0x77, 0x10, 0x10, 0xEC,
  0x0E, 0x01, 0x80, 0xC6, 0x0D, 0x0B, 0x77, 0x77, 0x10, 0x9D, 0x07, 0x80, 0xC7, 0x0D, 0x0B, 0x77,
  0x77, 0x02, 0xD0, 0xD8, 0x0D, 0x00, 0xD0, 0xB7, 0x77, 0x70, 0xBD, 0x05, 0x80, 0xD0, 0x0D, 0x0B,
  0x77, 0x76, 0x04, 0xD0, 0xC8, 0x0D, 0x10, 0xD0, 0xB7, 0x77, 0x60, 0xDD, 0x03, 0x80, 0xD1, 0x0D,
  0x0B, 0x77, 0x75, 0x06, 0xD0, 0xA8, 0x0D, 0x20, 0xD0, 0xB7, 0x77, 0x40, 0x10, 0xED, 0x02, 0x80,
  0xD2, 0x0D, 0x0B, 0x77, 0x74, 0x08, 0xD0, 0x88, 0x0D, 0x30, 0xD0, 0xB7, 0x77, 0x30, 0x2D, 0x0E,
  0x01, 0x80, 0xD3, 0x0D, 0x0B, 0x77, 0x73, 0x0A, 0xD0, 0x68, 0x0D, 0x40, 0xD0, 0xB7, 0x77, 0x20,
  0x4D, 0x0D, 0x80, 0xD5, 0x0D, 0x0B, 0x77, 0x72, 0x0C, 0xD0, 0x48, 0x0D, 0x50, 0xD0, 0xB7, 0x77,
  0x10, 0x6D, 0x0B, 0x80, 0xD6, 0x0D, 0x0B, 0x77, 0x71, 0x0E, 0xD0, 0x28, 0x0D, 0x60, 0xD0, 0xB7,
  0x77, 0x08, 0xD0, 0x98, 0x0D, 0x70, 0xD0, 0xB7, 0x76, 0x01, 0x0E, 0xC0, 0xE0, 0x18, 0x0D, 0x70,
  0xD0, 0xB7, 0x76, 0x0A, 0xD0, 0x77, 0x71, 0x03, 0x05, 0x80, 0x17, 0x05, 0x03, 0x77, 0x77, 0xD0,
  0xB7, 0x75, 0x03, 0xD0, 0xD7, 0x58, 0x12, 0x7C, 0xFC, 0x81, 0xC7, 0x17, 0x77, 0x3D, 0x0B, 0x77,
  0x50, 0xCD, 0x05, 0x73, 0x05, 0x0C, 0xFF, 0xB0, 0x90, 0x17, 0x77, 0x1D, 0x0B, 0x77, 0x40, 0x5D,
  0x0B, 0x72, 0x04, 0x0C, 0xFF, 0xE0, 0xE0, 0x47, 0x77, 0xD0, 0xB7, 0x74, 0x0D, 0xD0, 0x37, 0x01,
  0x0A, 0xFF, 0xFB, 0x06, 0x77, 0x6D, 0x0B, 0x77, 0x30, 0x7D, 0x09, 0x70, 0x50, 0xEF, 0xA8, 0x6D,
  0xB9, 0x77, 0x79, 0xCF, 0xA0, 0x57, 0x75, 0xD0, 0xB7, 0x72, 0x01, 0x0E, 0xC0, 0xE0, 0x16, 0x04,
  0xF9, 0x81, 0xC7, 0x27, 0x18, 0x11, 0x6D, 0xE0, 0xE0, 0x27, 0x74, 0xD0, 0xB7, 0x72, 0x09, 0xD0,
  0x77, 0x10, 0xBD, 0x0C, 0x04, 0x77, 0x0A, 0xE0, 0xB7, 0x74, 0xD0, 0xB7, 0x71, 0x02, 0xD0, 0xD7,
  0x20, 0x10, 0xEA, 0x0E, 0x05, 0x77, 0x30, 0xAE, 0x03, 0x77, 0x3D, 0x0B, 0x77, 0x10, 0xBD, 0x05,
  0x73, 0x82, 0x5F, 0xA1, 0x77, 0x50, 0xDD, 0x09, 0x77, 0x3D, 0x0B, 0x77, 0x04, 0xD0, 0xC7, 0x50,
  0x47, 0x77, 0x06, 0xD0, 0xE7, 0x73, 0xD0, 0xB7, 0x70, 0xDD, 0x03, 0x77, 0x77, 0x7E, 0x02, 0x77,
  0x2D, 0x0B, 0x76, 0x06, 0xD0, 0xA8, 0x0C, 0x00, 0x0C, 0xD0, 0x47, 0x72, 0xD0, 0xB7, 0x50, 0x10,
  0xED, 0x02, 0x80, 0xC0, 0x00, 0xAD, 0x05, 0x77, 0x2D, 0x0B, 0x75, 0x08, 0xD0, 0x88, 0x0C, 0x10,
  0x09, 0xD0, 0x67, 0x72, 0xD0, 0xB7, 0x40, 0x2D, 0x0E, 0x80, 0xC2, 0x00, 0x9D, 0x05, 0x77, 0x2D,
  0x0B, 0x74, 0x0A, 0xD0, 0x68, 0x0C, 0x20, 0x0B, 0xD0, 0x47, 0x72, 0xD0, 0xB7, 0x30, 0x4D, 0x0C,
  0x80, 0xC3, 0x00, 0xDD, 0x01, 0x77, 0x28, 0x01, 0x90, 0x77, 0x30, 0xCD, 0x04, 0x80, 0xC2, 0x00,
  0x2D, 0x0D, 0x77, 0x77, 0x40, 0x6D, 0x0B, 0x80, 0xC3, 0x00, 0x7D, 0x09, 0x77, 0x77, 0x40, 0xED,
  0x02, 0x80, 0xC3, 0x00, 0xDD, 0x03, 0x77, 0x77, 0x30, 0x8D, 0x09, 0x80, 0xC3, 0x00, 0x6D, 0x0C,
  0x77, 0x77, 0x30, 0x2D, 0x0E, 0x01, 0x80, 0xC2, 0x00, 0x10, 0xED, 0x04, 0x77, 0x77, 0x30, 0xAD,
  0x07, 0x80, 0xC3, 0x00, 0x9D, 0x0B, 0x77, 0x77, 0x30, 0x3D, 0x0D, 0x80, 0xC3, 0x00, 0x5D, 0x0E,
  0x01, 0x77, 0x77, 0x30, 0xCD, 0x04, 0x80, 0xC2, 0x00, 0x20, 0xED, 0x05, 0x77, 0x77, 0x30, 0x5D,
  0x0B, 0x80, 0xC2, 0x00, 0x10, 0xDD, 0x09, 0x77, 0x77, 0x40, 0xDD, 0x03, 0x80, 0xC2, 0x00, 0xCD,
  0x0B, 0x77, 0x77, 0x40, 0x7D, 0x09, 0x80, 0xC2, 0x00, 0xBD, 0x0C, 0x01, 0x77, 0x77, 0x30, 0x10,
  0xEC, 0x0E, 0x01, 0x80, 0xC1, 0x00, 0xAD, 0x0D, 0x01, 0x77, 0x77, 0x40, 0x9D, 0x07, 0x80, 0xC1,
  0x00, 0xAD, 0x0D, 0x02, 0x77, 0x77, 0x40, 0x3D, 0x0D, 0x80, 0xC1, 0x00, 0x9D, 0x0E, 0x02, 0x77,
  0x77, 0x50, 0xBD, 0x05, 0x80, 0xC0, 0x00, 0x9D, 0x0E, 0x02, 0x77, 0x77, 0x50, 0x5D, 0x0C, 0x80,
  0xC0, 0x00, 0x9D, 0x0E, 0x03, 0x77, 0x77, 0x60, 0xDD, 0x03, 0x77, 0x77, 0x70, 0x9D, 0x0E, 0x03,
  0x77, 0x77, 0x60, 0x7D, 0x0A, 0x77, 0x77, 0x70, 0x9D, 0x0E, 0x03, 0x77, 0x77, 0x60, 0x10, 0xED,
  0x01, 0x77, 0x77, 0x60, 0x9D, 0x0E, 0x03, 0x77, 0x77, 0x70, 0x9D, 0x08, 0x77, 0x77, 0x60, 0x9D,
  0x0E, 0x03, 0x77, 0x77, 0x70, 0x2D, 0x0E, 0x77, 0x77, 0x60, 0x9D, 0x0E, 0x03, 0x80, 0xC0, 0x00,
  0xBD, 0x06, 0x77, 0x77, 0x50, 0x9D, 0x0E, 0x03, 0x80, 0xC0, 0x00, 0x4D, 0x0C, 0x77, 0x77, 0x50,
  0x9D, 0x0E, 0x03, 0x80, 0xC1, 0x00, 0xCD, 0x04, 0x77, 0x77, 0x40, 0x9D, 0x0E, 0x03, 0x80, 0xC1,
  0x00, 0x6D, 0x0A, 0x77, 0x77, 0x40, 0x9D, 0x0E, 0x03, 0x80, 0xC1, 0x00, 0x10, 0xED, 0x02, 0x77,
  0x77, 0x30, 0x9D, 0x0E, 0x02, 0x80, 0xC2, 0x00, 0x8D, 0x08, 0x77, 0x77, 0x30, 0x9D, 0x0E, 0x02,
  0x80, 0xC2, 0x00, 0x2D, 0x0E, 0x01, 0x77, 0x77, 0x20, 0x9D, 0x0E, 0x02, 0x80, 0xC3, 0x00, 0xAD,
  0x06, 0x77, 0x77, 0x20, 0x9D, 0x0E, 0x02, 0x80, 0xC3, 0x00, 0x3D, 0x0D, 0x77, 0x77, 0x20, 0x9D,
  0x0E, 0x04, 0x80, 0xA5, 0x17, 0x71, 0x0C, 0xD0, 0x47, 0x77, 0x71, 0x08, 0xFF, 0xFF, 0xD7, 0x70,
  0x5D, 0x0B, 0x77, 0x77, 0x20, 0xBF, 0xFF, 0xFD, 0x77, 0x0D, 0xD0, 0x27, 0x77, 0x72, 0x0B, 0xFF,
  0xFF, 0xD7, 0x60, 0x7D, 0x09, 0x77, 0x77, 0x30, 0xBF, 0xFF, 0xFD, 0x75, 0x01, 0x0E, 0xC0, 0xE0,
  0x17, 0x77, 0x73, 0x0B, 0xFF, 0xFF, 0xD0,
  // "¾" (U+00BE)
  0x75, 0x89, 0x22, 0x56, 0x89, 0x99, 0x97, 0x64, 0x18, 0x09, 0x86, 0x08, 0x21, 0x6B, 0xEF, 0xD8,
  0x1C, 0x72, 0x80, 0xC5, 0x00, 0x18, 0x02, 0xB0, 0x17, 0x76, 0x04, 0x0A, 0xFF, 0xD0, 0xA0, 0x18,
  0x0C, 0x30, 0x09, 0xD0, 0x97, 0x75, 0x04, 0x0C, 0xFF, 0xF9, 0x0E, 0x05, 0x80, 0xC1, 0x00, 0x3D,
  0x0E, 0x01, 0x77, 0x30, 0x20, 0xBF, 0xFF, 0xD0, 0x78, 0x0C, 0x00, 0x0B, 0xD0, 0x77, 0x73, 0x06,
  0xFB, 0x89, 0x1E, 0xB8, 0x65, 0x43, 0x57, 0xAE, 0xF9, 0x06, 0x77, 0x77, 0x60, 0x5D, 0x0D, 0x77,
  0x40, 0x5F, 0x81, 0xE9, 0x37, 0x40, 0x50, 0xDF, 0x02, 0x77, 0x77, 0x50, 0xDD, 0x05, 0x77, 0x50,
  0xAC, 0x81, 0xD6, 0x17, 0x71, 0x09, 0xE0, 0xB7, 0x77, 0x74, 0x07, 0xD0, 0xC7, 0x76, 0x83, 0x1E,
  0xFE, 0x67, 0x75, 0x0A, 0xE0, 0x27, 0x77, 0x72, 0x01, 0x0E, 0xD0, 0x37, 0x77, 0x05, 0x07, 0x77,
  0x71, 0x0E, 0xD0, 0x77, 0x77, 0x72, 0x09, 0xD0, 0xA8, 0x0D, 0x20, 0x08, 0xD0, 0xB7, 0x77, 0x71,
  0x02, 0xD0, 0xE0, 0x18, 0x0D, 0x20, 0x03, 0xD0, 0xD7, 0x77, 0x71, 0x0B, 0xD0, 0x78, 0x0D, 0x30,
  0x01, 0xE7, 0x77, 0x70, 0x4D, 0x0D, 0x80, 0xD5, 0x0E, 0x77, 0x77, 0x0C, 0xD0, 0x58, 0x0D, 0x50,
  0xD0, 0xE7, 0x77, 0x60, 0x6D, 0x0C, 0x80, 0xD5, 0x00, 0x2D, 0x0D, 0x77, 0x76, 0x0E, 0xD0, 0x38,
  0x0D, 0x50, 0x05, 0xD0, 0xA7, 0x77, 0x50, 0x8D, 0x0A, 0x80, 0xD6, 0x00, 0xAD, 0x06, 0x77, 0x74,
  0x02, 0xE0, 0x28, 0x0D, 0x50, 0x02, 0xE0, 0x17, 0x77, 0x40, 0xAD, 0x08, 0x80, 0xD6, 0x00, 0xCD,
  0x09, 0x77, 0x74, 0x03, 0xD0, 0xE0, 0x18, 0x0D, 0x50, 0x0A, 0xD0, 0xE0, 0x17, 0x77, 0x40, 0xCD,
  0x06, 0x80, 0xD4, 0x00, 0x30, 0xCE, 0x04, 0x77, 0x74, 0x05, 0xD0, 0xD8, 0x0D, 0x30, 0x04, 0x0A,
  0xF0, 0x57, 0x77, 0x50, 0xDD, 0x04, 0x77, 0x77, 0x68, 0x05, 0x78, 0x18, 0xAC, 0xF9, 0x0E, 0x04,
  0x77, 0x75, 0x07, 0xD0, 0xB7, 0x77, 0x77, 0x0E, 0xFF, 0xC0, 0x90, 0x17, 0x77, 0x50, 0x10, 0xED,
  0x02, 0x77, 0x77, 0x70, 0xEF, 0xFA, 0x08, 0x01, 0x77, 0x77, 0x09, 0xD0, 0x98, 0x0C, 0x00, 0x0E,
  0xFF, 0xB8, 0x1D, 0x82, 0x77, 0x74, 0x03, 0xD0, 0xE0, 0x18, 0x0C, 0x00, 0x0E, 0xFF, 0xE0, 0x90,
  0x17, 0x77, 0x20, 0xBD, 0x07, 0x80, 0xC1, 0x08, 0x03, 0x38, 0x54, 0x55, 0x68, 0xAD, 0xF9, 0x0E,
  0x04, 0x77, 0x70, 0x5D, 0x0D, 0x80, 0xE0, 0x08, 0x12, 0x7D, 0xF0, 0x47, 0x76, 0x0D, 0xD0, 0x58,
  0x0E, 0x30, 0x06, 0x0E, 0xD0, 0xE0, 0x27, 0x74, 0x07, 0xD0, 0xB8, 0x0E, 0x50, 0x02, 0x0D, 0xD0,
  0xC7, 0x73, 0x01, 0x0E, 0xD0, 0x38, 0x0E, 0x60, 0x02, 0xE0, 0x57, 0x72, 0x09, 0xD0, 0x98, 0x0F,
  0x00, 0x08, 0xD0, 0xB7, 0x71, 0x02, 0xD0, 0xE0, 0x18, 0x0F, 0x00, 0x01, 0xE7, 0x71, 0x0B, 0xD0,
  0x78, 0x0F, 0x20, 0x0C, 0xD0, 0x37, 0x60, 0x4D, 0x0D, 0x77, 0x40, 0x28, 0x02, 0xB0, 0x18, 0x0C,
  0x10, 0x09, 0xD0, 0x57, 0x60, 0xDD, 0x05, 0x77, 0x40, 0xCE, 0x02, 0x80, 0xC1, 0x00, 0x8D, 0x06,
  0x75, 0x06, 0xD0, 0xC7, 0x74, 0x07, 0xF0, 0x28, 0x0C, 0x10, 0x09, 0xD0, 0x67, 0x40, 0x10, 0xED,
  0x03, 0x77, 0x30, 0x3F, 0x90, 0x28, 0x0C, 0x10, 0x0A, 0xD0, 0x57, 0x40, 0x8D, 0x0A, 0x77, 0x40,
  0xDF, 0x90, 0x28, 0x0C, 0x10, 0x0D, 0xD0, 0x37, 0x30, 0x2E, 0x02, 0x77, 0x30, 0x9F, 0xA0, 0x28,
  0x0C, 0x00, 0x02, 0xE0, 0x17, 0x30, 0xAD, 0x08, 0x77, 0x30, 0x4F, 0xB0, 0x28, 0x0C, 0x00, 0x08,
  0xD0, 0xC7, 0x30, 0x3D, 0x0E, 0x77, 0x30, 0x10, 0xEB, 0x0E, 0x0B, 0xD0, 0x27, 0x77, 0x77, 0x01,
  0x0E, 0xD0, 0x77, 0x30, 0xCD, 0x06, 0x77, 0x30, 0xAC, 0x07, 0x0A, 0xD0, 0x27, 0x10, 0x17, 0x77,
  0x50, 0xCE, 0x01, 0x72, 0x06, 0xD0, 0xC7, 0x73, 0x06, 0xC8, 0x1D, 0x0A, 0xD0, 0x27, 0x18, 0x17,
  0xC6, 0x77, 0x71, 0x01, 0x0B, 0xE0, 0x87, 0x30, 0xED, 0x04, 0x77, 0x20, 0x20, 0xEC, 0x81, 0x30,
  0xBD, 0x02, 0x71, 0x07, 0xA8, 0x1E, 0x94, 0x77, 0x40, 0x50, 0xDE, 0x0D, 0x73, 0x08, 0xD0, 0xB7,
  0x73, 0x0C, 0xC0, 0x82, 0x0B, 0xD0, 0x27, 0x10, 0x7D, 0x82, 0xEA, 0x63, 0x74, 0x81, 0x27, 0xCF,
  0x0E, 0x02, 0x72, 0x01, 0x0E, 0xD0, 0x27, 0x72, 0x07, 0xC0, 0xD3, 0x0C, 0xD0, 0x27, 0x10, 0x7F,
  0xB8, 0x90, 0xDB, 0x99, 0x77, 0x89, 0xBE, 0xFA, 0x0E, 0x03, 0x73, 0x0A, 0xD0, 0x97, 0x72, 0x03,
  0xD0, 0x33, 0x0C, 0xD0, 0x27, 0x10, 0x7F, 0xFF, 0xF0, 0xD0, 0x27, 0x30, 0x3D, 0x0E, 0x01, 0x77,
  0x20, 0xDC, 0x08, 0x40, 0xCD, 0x02, 0x71, 0x02, 0x0A, 0xFF, 0xFD, 0x08, 0x75, 0x0C, 0xD0, 0x67,
  0x72, 0x09, 0xC0, 0xC5, 0x0C, 0xD0, 0x27, 0x38, 0x11, 0x7C, 0xFF, 0xE8, 0x1E, 0x82, 0x75, 0x05,
  0xD0, 0xD7, 0x72, 0x04, 0xC0, 0xE0, 0x25, 0x0C, 0xD0, 0x27, 0x68, 0x31, 0x58, 0xBE, 0xFC, 0x82,
  0xEC, 0x84, 0x77, 0x10, 0xDD, 0x04, 0x77, 0x10, 0x10, 0xEC, 0x06, 0x60, 0xDD, 0x02, 0x77, 0x48,
  0x11, 0x33, 0x80, 0x15, 0x81, 0x43, 0x17, 0x74, 0x07, 0xD0, 0xB7, 0x72, 0x0A, 0xC0, 0xA7, 0x0D,
  0xD0, 0x28, 0x0D, 0x20, 0x01, 0x0E, 0xD0, 0x37, 0x71, 0x06, 0xC0, 0xE0, 0x17, 0x0D, 0xD0, 0x28,
  0x0D, 0x20, 0x09, 0xD0, 0x97, 0x71, 0x02, 0x0E, 0xC0, 0x47, 0x10, 0xDD, 0x02, 0x80, 0xD1, 0x00,
  0x2D, 0x0E, 0x01, 0x77, 0x10, 0xCC, 0x09, 0x72, 0x0D, 0xD0, 0x28, 0x0D, 0x10, 0x0B, 0xD0, 0x77,
  0x71, 0x07, 0xC0, 0xD7, 0x30, 0xDD, 0x02, 0x80, 0xD0, 0x00, 0x4D, 0x0D, 0x77, 0x10, 0x3D, 0x03,
  0x73, 0x0D, 0xD0, 0x28, 0x0D, 0x00, 0x0D, 0xD0, 0x57, 0x71, 0x0D, 0xC0, 0x77, 0x40, 0xDD, 0x02,
  0x80, 0xC7, 0x00, 0x6D, 0x0C, 0x77, 0x10, 0x9C, 0x0B, 0x75, 0x0D, 0xD0, 0x28, 0x0C, 0x60, 0x01,
  0x0E, 0xD0, 0x37, 0x70, 0x4C, 0x0E, 0x01, 0x75, 0x0D, 0xD0, 0x28, 0x0C, 0x60, 0x08, 0xD0, 0xA7,
  0x70, 0x10, 0xEC, 0x05, 0x76, 0x0D, 0xD0, 0x28, 0x0C, 0x50, 0x02, 0xE0, 0x17, 0x70, 0xAC, 0x0A,
  0x77, 0x0D, 0xD0, 0x28, 0x0C, 0x50, 0x0A, 0xD0, 0x87, 0x70, 0x6C, 0x0D, 0x01, 0x77, 0x0D, 0xD0,
  0x28, 0x0C, 0x40, 0x04, 0xD0, 0xE7, 0x70, 0x20, 0xEC, 0x03, 0x77, 0x10, 0xDD, 0x02, 0x80, 0xC4,
  0x00, 0xCD, 0x06, 0x77, 0x0C, 0xC0, 0x87, 0x72, 0x0D, 0xD0, 0x28, 0x0C, 0x30, 0x06, 0xD0, 0xC7,
  0x70, 0x7C, 0x0C, 0x77, 0x30, 0xDD, 0x02, 0x80, 0xC3, 0x00, 0xED, 0x04, 0x76, 0x03, 0xD0, 0xD8,
  0x09, 0x5B, 0x0E, 0xD0, 0xC8, 0x03, 0xB0, 0x27, 0x77, 0x72, 0x08, 0xD0, 0xA7, 0x70, 0xA8, 0x0C,
  0x1F, 0x03, 0x77, 0x77, 0x10, 0x2E, 0x02, 0x77, 0x0B, 0x80, 0xC1, 0xF0, 0x37, 0x77, 0x71, 0x0A,
  0xD0, 0x87, 0x71, 0x0B, 0x80, 0xC1, 0xF0, 0x37, 0x77, 0x70, 0x3D, 0x0E, 0x01, 0x77, 0x10, 0xB8,
  0x0C, 0x1F, 0x03, 0x77, 0x77, 0x0C, 0xD0, 0x67, 0x72, 0x02, 0x80, 0xA3, 0x30, 0xDD, 0x05, 0x80,
  0x33, 0x77, 0x77, 0x05, 0xD0, 0xD8, 0x0C, 0x50, 0x0D, 0xD0, 0x27, 0x77, 0x77, 0x0D, 0xD0, 0x48,
  0x0C, 0x50, 0x0D, 0xD0, 0x27, 0x77, 0x76, 0x07, 0xD0, 0xB8, 0x0C, 0x60, 0x0D, 0xD0, 0x27, 0x77,
  0x75, 0x01, 0x0E, 0xD0, 0x28, 0x0C, 0x60, 0x0D, 0xD0, 0x27, 0x77, 0x75, 0x09, 0xD0, 0x98, 0x0C,
  0x70, 0x0D, 0xD0, 0x27, 0x77, 0x74, 0x03, 0xD0, 0xE0, 0x18, 0x0C, 0x70, 0x0D, 0xD0, 0x27, 0x77,
  0x74, 0x0B, 0xD0, 0x78, 0x0D, 0x00, 0x0D, 0xD0, 0x27, 0x77, 0x73, 0x05, 0xD0, 0xD8, 0x0D, 0x10,
  0x0D, 0xD0, 0x27, 0x77, 0x73, 0x0D, 0xD0, 0x58, 0x0D, 0x10, 0x0D, 0xD0, 0x27, 0x77, 0x72, 0x07,
  0xD0, 0xB8, 0x0D, 0x20, 0x0D, 0xD0, 0x27, 0x77, 0x71, 0x01, 0x0E, 0xD0, 0x38, 0x0D, 0x20, 0x0D,
  0xD0, 0x27, 0x77, 0x71, 0x09, 0xD0, 0x98, 0x0D, 0x30, 0x0D, 0xD0, 0x27, 0x77, 0x70, 0x2D, 0x0E,
  0x01, 0x80, 0xD3, 0x00, 0xDD, 0x02, 0x71,
  // "¿" (U+00BF)
  0x77, 0x74, 0x0F, 0x18, 0x0C, 0x30, 0x04, 0x0C, 0xB0, 0xE0, 0x78, 0x0C, 0x00, 0x05, 0xF0, 0xA7,
  0x77, 0x77, 0x0E, 0xF9, 0x04, 0x77, 0x77, 0x50, 0x4F, 0xA0, 0x97, 0x77, 0x75, 0x07, 0xFA, 0x0C,
  0x77, 0x77, 0x50, 0x8F, 0xA0, 0xD7, 0x77, 0x75, 0x07, 0xFA, 0x0C, 0x77, 0x77, 0x50, 0x6F, 0xA0,
  0xB7, 0x77, 0x75, 0x02, 0xFA, 0x07, 0x77, 0x77, 0x60, 0xAF, 0x0E, 0x01, 0x77, 0x77, 0x70, 0xBD,
  0x0E, 0x03, 0x80, 0xC1, 0x08, 0x33, 0x79, 0x75, 0x80, 0x98, 0x87, 0x08, 0x02, 0x38, 0x0C, 0x20,
  0x0E, 0xC0, 0xC8, 0x0C, 0x20, 0x0E, 0xC0, 0xC8, 0x0C, 0x20, 0x0E, 0xC0, 0xC8, 0x0C, 0x20, 0xD0,
  0xC8, 0x0C, 0x20, 0xD0, 0xB8, 0x0C, 0x10, 0x01, 0xD0, 0xA8, 0x0C, 0x10, 0x03, 0xD0, 0x98, 0x0C,
  0x10, 0x06, 0xD0, 0x88, 0x0C, 0x10, 0x09, 0xD0, 0x68, 0x0C, 0x10, 0x0D, 0xD0, 0x38, 0x0C, 0x00,
  0x03, 0xE8, 0x0C, 0x10, 0x0A, 0xD0, 0xB8, 0x0C, 0x00, 0x02, 0xE0, 0x78, 0x0C, 0x00, 0x0C, 0xE0,
  0x17, 0x77, 0x77, 0x08, 0xE0, 0x97, 0x77, 0x77, 0x06, 0xF0, 0x17, 0x77, 0x76, 0x06, 0xF0, 0x67,
  0x77, 0x76, 0x07, 0xF0, 0xA7, 0x77, 0x76, 0x09, 0xF0, 0xC7, 0x77, 0x75, 0x01, 0x0B, 0xF0, 0xD0,
  0x17, 0x77, 0x74, 0x03, 0x0E, 0xF0, 0xC0, 0x17, 0x77, 0x74, 0x06, 0xF9, 0x0B, 0x01, 0x77, 0x77,
  0x40, 0x9F, 0x90, 0x97, 0x77, 0x74, 0x01, 0x0B, 0xF9, 0x06, 0x77, 0x77, 0x40, 0x10, 0xCF, 0x0D,
  0x03, 0x77, 0x77, 0x40, 0x20, 0xDF, 0x0C, 0x01, 0x77, 0x77, 0x40, 0x20, 0xEF, 0x0A, 0x77, 0x77,
  0x50, 0x20, 0xEF, 0x08, 0x77, 0x77, 0x50, 0x10, 0xDF, 0x06, 0x77, 0x77, 0x60, 0xBF, 0x05, 0x77,
  0x77, 0x60, 0x6F, 0x06, 0x77, 0x77, 0x60, 0x10, 0xEE, 0x08, 0x77, 0x77, 0x70, 0x9E, 0x0B, 0x77,
  0x77, 0x70, 0x2E, 0x0E, 0x02, 0x77, 0x77, 0x70, 0x8E, 0x07, 0x80, 0xC0, 0x00, 0xDD, 0x0E, 0x80,
  0xC0, 0x00, 0x3E, 0x09, 0x80, 0xC0, 0x00, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x9E, 0x80, 0xC1, 0x00,
  0xCD, 0x0D, 0x80, 0xC1, 0x00, 0xED, 0x0B, 0x80, 0xC1, 0x00, 0xED, 0x09, 0x80, 0xC1, 0x0E, 0x09,
  0x80, 0xC1, 0x0E, 0x08, 0x80, 0xC1, 0x0E, 0x09, 0x80, 0xC1, 0x00, 0xED, 0x0A, 0x80, 0xC1, 0x00,
  0xDD, 0x0C, 0x80, 0xC1, 0x00, 0xBE, 0x80, 0xC1, 0x00, 0x8E, 0x04, 0x80, 0xC0, 0x00, 0x5E, 0x0A,
  0x80, 0xC0, 0x00, 0x1F, 0x01, 0x80, 0xC0, 0x00, 0xBE, 0x0A, 0x80, 0xC0, 0x00, 0x5F, 0x06, 0x80,
  0xC0, 0x00, 0xDF, 0x04, 0x77, 0x77, 0x10, 0x30, 0x44, 0x04, 0xF9, 0x07, 0x77, 0x75, 0x82, 0x5B,
  0xFD, 0x50, 0xAF, 0x90, 0xB0, 0x37, 0x77, 0x81, 0x28, 0xDC, 0x04, 0x50, 0xCF, 0xA0, 0xB0, 0x57,
  0x72, 0x81, 0x37, 0xCF, 0x0B, 0x50, 0x20, 0xDF, 0xB8, 0x3E, 0xB8, 0x53, 0x80, 0x11, 0x84, 0x34,
  0x68, 0xBE, 0xFC, 0x02, 0x50, 0x20, 0xD8, 0x0C, 0x0F, 0x09, 0x70, 0xAF, 0xFF, 0xFE, 0x0A, 0x03,
  0x71, 0x05, 0x0E, 0xFF, 0xFF, 0x98, 0x1D, 0x82, 0x75, 0x07, 0x0E, 0xFF, 0xFB, 0x81, 0xE9, 0x47,
  0x73, 0x81, 0x5A, 0xEF, 0xFC, 0x81, 0xC8, 0x37, 0x77, 0x28, 0x43, 0x69, 0xBD, 0xED, 0x84, 0xDC,
  0xB9, 0x64, 0x75,
  // "À" (U+00C0)
  0x77, 0x70, 0x58, 0x03, 0xB0, 0x88, 0x0F, 0x40, 0x04, 0xF9, 0x04, 0x80, 0xF4, 0x00, 0x9F, 0x0D,
  0x80, 0xF5, 0x00, 0xCF, 0x09, 0x80, 0xF4, 0x00, 0x10, 0xEF, 0x04, 0x80, 0xF4, 0x00, 0x3F, 0x0E,
  0x01, 0x80, 0xF4, 0x00, 0x5F, 0x0B, 0x80, 0xF5, 0x00, 0x6F, 0x07, 0x80, 0xF5, 0x00, 0x7F, 0x04,
  0x80, 0xF5, 0x00, 0x9E, 0x0E, 0x01, 0x80, 0xF5, 0x00, 0xAE, 0x0C, 0x80, 0xF6, 0x00, 0xAE, 0x09,
  0x80, 0xF6, 0x00, 0xAE, 0x06, 0x80, 0xF6, 0x00, 0xAE, 0x04, 0x80, 0xF6, 0x00, 0xAD, 0x0E, 0x02,
  0x80, 0xF6, 0x00, 0x9D, 0x0D, 0x01, 0x80, 0xF6, 0x00, 0x8D, 0x0C, 0x01, 0x80, 0xF6, 0x00, 0x6D,
  0x0C, 0x80, 0xF7, 0x00, 0x40, 0xEC, 0x09, 0x80, 0xF7, 0x08, 0x42, 0x55, 0x55, 0x38, 0x09, 0xA8,
  0x20, 0x08, 0x80, 0x2D, 0x03, 0x80, 0xF5, 0x00, 0xEE, 0x09, 0x80, 0xF4, 0x00, 0x5F, 0x0E, 0x80,
  0xF4, 0x00, 0xBF, 0x90, 0x68, 0x0F, 0x20, 0x02, 0xFA, 0x0B, 0x80, 0xF2, 0x00, 0x8F, 0xB0, 0x28,
  0x0F, 0x10, 0x0D, 0xFB, 0x08, 0x80, 0xF0, 0x00, 0x4D, 0x0E, 0xD0, 0xD8, 0x0F, 0x00, 0x0A, 0xD0,
  0x70, 0xED, 0x04, 0x80, 0xE6, 0x00, 0x1E, 0x01, 0x09, 0xD0, 0xA8, 0x0E, 0x60, 0x07, 0xD8, 0x1C,
  0x04, 0xE0, 0x18, 0x0E, 0x50, 0x0D, 0xD0, 0x72, 0x0E, 0xD0, 0x68, 0x0E, 0x40, 0x04, 0xE0, 0x22,
  0x09, 0xD0, 0xC8, 0x0E, 0x40, 0x0A, 0xD0, 0xC3, 0x04, 0xE0, 0x38, 0x0E, 0x20, 0x01, 0xE0, 0x74,
  0x0E, 0xD0, 0x98, 0x0E, 0x20, 0x06, 0xE0, 0x24, 0x09, 0xD0, 0xE8, 0x0E, 0x20, 0x0C, 0xD0, 0xC5,
  0x04, 0xE0, 0x58, 0x0E, 0x00, 0x03, 0xE0, 0x76, 0x0E, 0xD0, 0xB8, 0x0E, 0x00, 0x09, 0xE0, 0x26,
  0x0A, 0xE0, 0x28, 0x0D, 0x70, 0x0E, 0xD0, 0xC7, 0x05, 0xE0, 0x78, 0x0D, 0x60, 0x06, 0xE0, 0x77,
  0x10, 0xED, 0x0D, 0x80, 0xD6, 0x00, 0xCE, 0x01, 0x71, 0x09, 0xE0, 0x48, 0x0D, 0x40, 0x02, 0xE0,
  0xA7, 0x20, 0x3E, 0x0A, 0x80, 0xD4, 0x00, 0x8E, 0x04, 0x73, 0x0D, 0xE0, 0x18, 0x0D, 0x30, 0x0E,
  0xD0, 0xD7, 0x40, 0x7E, 0x06, 0x80, 0xD2, 0x00, 0x5E, 0x08, 0x74, 0x02, 0xE0, 0xC8, 0x0D, 0x20,
  0x0B, 0xE0, 0x27, 0x50, 0xBE, 0x02, 0x80, 0xD0, 0x00, 0x2E, 0x0B, 0x76, 0x05, 0xE0, 0x88, 0x0D,
  0x00, 0x08, 0xE0, 0x57, 0x70, 0xED, 0x0E, 0x80, 0xD0, 0x00, 0xDD, 0x0E, 0x77, 0x10, 0x9E, 0x05,
  0x80, 0xC6, 0x00, 0x4E, 0x09, 0x77, 0x10, 0x4E, 0x0B, 0x80, 0xC6, 0x00, 0xAE, 0x03, 0x77, 0x20,
  0xDE, 0x01, 0x80, 0xC4, 0x00, 0x1E, 0x0C, 0x77, 0x30, 0x8E, 0x07, 0x80, 0xC4, 0x00, 0x7E, 0x06,
  0x77, 0x30, 0x2E, 0x0D, 0x80, 0xC4, 0x00, 0xDE, 0x01, 0x77, 0x40, 0xCE, 0x03, 0x80, 0xC2, 0x00,
  0x3E, 0x0A, 0x77, 0x50, 0x6E, 0x09, 0x80, 0xC2, 0x00, 0xAE, 0x04, 0x77, 0x50, 0x1E, 0x0E, 0x80,
  0xC1, 0x00, 0x1E, 0x0D, 0x77, 0x70, 0xAE, 0x06, 0x80, 0xC0, 0x00, 0x6E, 0x08, 0x77, 0x70, 0x4E,
  0x0C, 0x80, 0xC0, 0x00, 0xCE, 0x02, 0x77, 0x71, 0x0D, 0xE0, 0x27, 0x77, 0x76, 0x03, 0xE0, 0xB7,
  0x77, 0x20, 0x8E, 0x08, 0x77, 0x77, 0x60, 0x9E, 0x05, 0x77, 0x72, 0x02, 0xE0, 0xE7, 0x77, 0x76,
  0x0E, 0xD0, 0xE7, 0x77, 0x40, 0xCE, 0x04, 0x77, 0x77, 0x40, 0x5E, 0x09, 0x77, 0x74, 0x06, 0xE0,
  0xA7, 0x77, 0x74, 0x0B, 0xE0, 0x37, 0x77, 0x40, 0x1F, 0x01, 0x77, 0x77, 0x20, 0x2E, 0x0C, 0x77,
  0x76, 0x0A, 0xE0, 0x77, 0x77, 0x72, 0x08, 0xE0, 0x67, 0x77, 0x60, 0x4E, 0x0D, 0x77, 0x77, 0x20,
  0xEE, 0x01, 0x77, 0x77, 0x0E, 0xE0, 0x37, 0x77, 0x70, 0x5E, 0x0A, 0x77, 0x77, 0x10, 0x8E, 0x09,
  0x77, 0x77, 0x0B, 0xE0, 0x47, 0x77, 0x71, 0x03, 0xE0, 0xE7, 0x77, 0x60, 0x1F, 0x80, 0xB3, 0xBF,
  0x05, 0x77, 0x75, 0x07, 0x80, 0xD1, 0xF0, 0xB7, 0x77, 0x50, 0xD8, 0x0D, 0x2F, 0x02, 0x77, 0x73,
  0x04, 0x80, 0xD3, 0xF0, 0x87, 0x77, 0x30, 0xA8, 0x0D, 0x3F, 0x0D, 0x77, 0x72, 0x01, 0x80, 0xD5,
  0xF0, 0x47, 0x77, 0x10, 0x7E, 0x0C, 0x80, 0xB7, 0x70, 0xCE, 0x0A, 0x77, 0x71, 0x0D, 0xE0, 0x47,
  0x77, 0x77, 0x05, 0xF0, 0x17, 0x76, 0x03, 0xE0, 0xE8, 0x0C, 0x10, 0x0E, 0xE0, 0x67, 0x76, 0x09,
  0xE0, 0x88, 0x0C, 0x10, 0x09, 0xE0, 0xC7, 0x75, 0x01, 0x0E, 0xE0, 0x28, 0x0C, 0x10, 0x03, 0xF0,
  0x37, 0x74, 0x06, 0xE0, 0xB8, 0x0C, 0x30, 0x0C, 0xE0, 0x87, 0x74, 0x0C, 0xE0, 0x58, 0x0C, 0x30,
  0x06, 0xE0, 0xE7, 0x73, 0x03, 0xE0, 0xE8, 0x0C, 0x40, 0x01, 0xF0, 0x57, 0x72, 0x09, 0xE0, 0x88,
  0x0C, 0x50, 0x0A, 0xE0, 0xB7, 0x72, 0x0E, 0xE0, 0x28, 0x0C, 0x50, 0x04, 0xF0, 0x17, 0x70, 0x5E,
  0x0B, 0x80, 0xC7, 0x00, 0xDE, 0x07, 0x77, 0x0B, 0xE0, 0x58, 0x0C, 0x70, 0x07, 0xE0, 0xD7, 0x60,
  0x2E, 0x0E, 0x80, 0xD0, 0x00, 0x1F, 0x03, 0x75, 0x08, 0xE0, 0x98, 0x0D, 0x10, 0x0B, 0xE0, 0x97,
  0x50, 0xEE, 0x02, 0x80, 0xD1, 0x00, 0x5E, 0x0E, 0x74, 0x05, 0xE0, 0xC8, 0x0D, 0x30, 0x0E, 0xE0,
  0x67, 0x30, 0xBE, 0x06, 0x80, 0xD3, 0x00, 0x8E, 0x0C, 0x72, 0x01, 0xE0, 0xE8, 0x0D, 0x40, 0x02,
  0xF0, 0x27, 0x10, 0x7E, 0x09, 0x80, 0xD5, 0x00, 0xCE, 0x08, 0x71, 0x0D, 0xE0, 0x38, 0x0D, 0x50,
  0x06, 0xE0, 0xE7, 0x04, 0xE0, 0xC8, 0x0D, 0x60, 0x01, 0x0E, 0xE0, 0x46, 0x0A, 0xE0, 0x68, 0x0D,
  0x70, 0x09, 0xE0, 0xA5, 0x01, 0xE0, 0xE0, 0x18, 0x0D, 0x70, 0x03, 0xF0, 0x14, 0x07, 0xE0, 0x98,
  0x0E, 0x10, 0x0D, 0xE0, 0x74, 0x0D, 0xE0, 0x38, 0x0E, 0x10, 0x07, 0xE0, 0xD3, 0x03, 0xE0, 0xD8,
  0x0E, 0x20, 0x01, 0xF0, 0x32, 0x09, 0xE0, 0x78, 0x0E, 0x30, 0x0B, 0xE0, 0x92, 0x0E, 0xE0, 0x18,
  0x0E, 0x30, 0x05, 0xE8, 0x1E, 0x06, 0xE0, 0xA8, 0x0E, 0x50, 0x0E, 0xE0, 0x50, 0xCE, 0x04, 0x80,
  0xE5, 0x00, 0x8E, 0x0B,
  // "Á" (U+00C1)
  0x80, 0xD1, 0x00, 0x78, 0x03, 0xB0, 0x88, 0x0F, 0x30, 0x02, 0xF9, 0x08, 0x80, 0xF3, 0x00, 0xCF,
  0x0C, 0x80, 0xF3, 0x00, 0x7F, 0x0E, 0x01, 0x80, 0xF2, 0x00, 0x3F, 0x90, 0x38, 0x0F, 0x30, 0x0D,
  0xF0, 0x58, 0x0F, 0x30, 0x09, 0xF0, 0x78, 0x0F, 0x30, 0x05, 0xF0, 0x98, 0x0F, 0x30, 0x02, 0x0E,
  0xE0, 0xA8, 0x0F, 0x40, 0x0D, 0xE0, 0xB8, 0x0F, 0x40, 0x0A, 0xE0, 0xC0, 0x18, 0x0F, 0x30, 0x07,
  0xE0, 0xC0, 0x18, 0x0F, 0x30, 0x04, 0xE0, 0xD0, 0x18, 0x0F, 0x30, 0x02, 0x0E, 0xD0, 0xD0, 0x18,
  0x0F, 0x30, 0x01, 0x0D, 0xD0, 0xC0, 0x18, 0x0F, 0x40, 0x0C, 0xD0, 0xC0, 0x18, 0x0F, 0x40, 0x0B,
  0xD0, 0xB8, 0x0F, 0x50, 0x09, 0xD0, 0x98, 0x0F, 0x50, 0x05, 0xD0, 0x78, 0x0F, 0x60, 0x84, 0x25,
  0x55, 0x53, 0x80, 0x9A, 0x91, 0x00, 0x88, 0x02, 0xD0, 0x38, 0x0F, 0x50, 0x0E, 0xE0, 0x98, 0x0F,
  0x40, 0x05, 0xF0, 0xE8, 0x0F, 0x40, 0x0B, 0xF9, 0x06, 0x80, 0xF2, 0x00, 0x2F, 0xA0, 0xB8, 0x0F,
  0x20, 0x08, 0xFB, 0x02, 0x80, 0xF1, 0x00, 0xDF, 0xB0, 0x88, 0x0F, 0x00, 0x04, 0xD0, 0xED, 0x0D,
  0x80, 0xF0, 0x00, 0xAD, 0x07, 0x0E, 0xD0, 0x48, 0x0E, 0x60, 0x01, 0xE0, 0x10, 0x9D, 0x0A, 0x80,
  0xE6, 0x00, 0x7D, 0x81, 0xC0, 0x4E, 0x01, 0x80, 0xE5, 0x00, 0xDD, 0x07, 0x20, 0xED, 0x06, 0x80,
  0xE4, 0x00, 0x4E, 0x02, 0x20, 0x9D, 0x0C, 0x80, 0xE4, 0x00, 0xAD, 0x0C, 0x30, 0x4E, 0x03, 0x80,
  0xE2, 0x00, 0x1E, 0x07, 0x40, 0xED, 0x09, 0x80, 0xE2, 0x00, 0x6E, 0x02, 0x40, 0x9D, 0x0E, 0x80,
  0xE2, 0x00, 0xCD, 0x0C, 0x50, 0x4E, 0x05, 0x80, 0xE0, 0x00, 0x3E, 0x07, 0x60, 0xED, 0x0B, 0x80,
  0xE0, 0x00, 0x9E, 0x02, 0x60, 0xAE, 0x02, 0x80, 0xD7, 0x00, 0xED, 0x0C, 0x70, 0x5E, 0x07, 0x80,
  0xD6, 0x00, 0x6E, 0x07, 0x71, 0x0E, 0xD0, 0xD8, 0x0D, 0x60, 0x0C, 0xE0, 0x17, 0x10, 0x9E, 0x04,
  0x80, 0xD4, 0x00, 0x2E, 0x0A, 0x72, 0x03, 0xE0, 0xA8, 0x0D, 0x40, 0x08, 0xE0, 0x47, 0x30, 0xDE,
  0x01, 0x80, 0xD3, 0x00, 0xED, 0x0D, 0x74, 0x07, 0xE0, 0x68, 0x0D, 0x20, 0x05, 0xE0, 0x87, 0x40,
  0x2E, 0x0C, 0x80, 0xD2, 0x00, 0xBE, 0x02, 0x75, 0x0B, 0xE0, 0x28, 0x0D, 0x00, 0x02, 0xE0, 0xB7,
  0x60, 0x5E, 0x08, 0x80, 0xD0, 0x00, 0x8E, 0x05, 0x77, 0x0E, 0xD0, 0xE8, 0x0D, 0x00, 0x0D, 0xD0,
  0xE7, 0x71, 0x09, 0xE0, 0x58, 0x0C, 0x60, 0x04, 0xE0, 0x97, 0x71, 0x04, 0xE0, 0xB8, 0x0C, 0x60,
  0x0A, 0xE0, 0x37, 0x72, 0x0D, 0xE0, 0x18, 0x0C, 0x40, 0x01, 0xE0, 0xC7, 0x73, 0x08, 0xE0, 0x78,
  0x0C, 0x40, 0x07, 0xE0, 0x67, 0x73, 0x02, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0x17, 0x74, 0x0C,
  0xE0, 0x38, 0x0C, 0x20, 0x03, 0xE0, 0xA7, 0x75, 0x06, 0xE0, 0x98, 0x0C, 0x20, 0x0A, 0xE0, 0x47,
  0x75, 0x01, 0xE0, 0xE8, 0x0C, 0x10, 0x01, 0xE0, 0xD7, 0x77, 0x0A, 0xE0, 0x68, 0x0C, 0x00, 0x06,
  0xE0, 0x87, 0x77, 0x04, 0xE0, 0xC8, 0x0C, 0x00, 0x0C, 0xE0, 0x27, 0x77, 0x10, 0xDE, 0x02, 0x77,
  0x77, 0x60, 0x3E, 0x0B, 0x77, 0x72, 0x08, 0xE0, 0x87, 0x77, 0x76, 0x09, 0xE0, 0x57, 0x77, 0x20,
  0x2E, 0x0E, 0x77, 0x77, 0x60, 0xED, 0x0E, 0x77, 0x74, 0x0C, 0xE0, 0x47, 0x77, 0x74, 0x05, 0xE0,
  0x97, 0x77, 0x40, 0x6E, 0x0A, 0x77, 0x77, 0x40, 0xBE, 0x03, 0x77, 0x74, 0x01, 0xF0, 0x17, 0x77,
  0x72, 0x02, 0xE0, 0xC7, 0x77, 0x60, 0xAE, 0x07, 0x77, 0x77, 0x20, 0x8E, 0x06, 0x77, 0x76, 0x04,
  0xE0, 0xD7, 0x77, 0x72, 0x0E, 0xE0, 0x17, 0x77, 0x70, 0xEE, 0x03, 0x77, 0x77, 0x05, 0xE0, 0xA7,
  0x77, 0x71, 0x08, 0xE0, 0x97, 0x77, 0x70, 0xBE, 0x04, 0x77, 0x77, 0x10, 0x3E, 0x0E, 0x77, 0x76,
  0x01, 0xF8, 0x0B, 0x3B, 0xF0, 0x57, 0x77, 0x50, 0x78, 0x0D, 0x1F, 0x0B, 0x77, 0x75, 0x0D, 0x80,
  0xD2, 0xF0, 0x27, 0x77, 0x30, 0x48, 0x0D, 0x3F, 0x08, 0x77, 0x73, 0x0A, 0x80, 0xD3, 0xF0, 0xD7,
  0x77, 0x20, 0x18, 0x0D, 0x5F, 0x04, 0x77, 0x71, 0x07, 0xE0, 0xC8, 0x0B, 0x77, 0x0C, 0xE0, 0xA7,
  0x77, 0x10, 0xDE, 0x04, 0x77, 0x77, 0x70, 0x5F, 0x01, 0x77, 0x60, 0x3E, 0x0E, 0x80, 0xC1, 0x00,
  0xEE, 0x06, 0x77, 0x60, 0x9E, 0x08, 0x80, 0xC1, 0x00, 0x9E, 0x0C, 0x77, 0x50, 0x10, 0xEE, 0x02,
  0x80, 0xC1, 0x00, 0x3F, 0x03, 0x77, 0x40, 0x6E, 0x0B, 0x80, 0xC3, 0x00, 0xCE, 0x08, 0x77, 0x40,
  0xCE, 0x05, 0x80, 0xC3, 0x00, 0x6E, 0x0E, 0x77, 0x30, 0x3E, 0x0E, 0x80, 0xC4, 0x00, 0x1F, 0x05,
  0x77, 0x20, 0x9E, 0x08, 0x80, 0xC5, 0x00, 0xAE, 0x0B, 0x77, 0x20, 0xEE, 0x02, 0x80, 0xC5, 0x00,
  0x4F, 0x01, 0x77, 0x05, 0xE0, 0xB8, 0x0C, 0x70, 0x0D, 0xE0, 0x77, 0x70, 0xBE, 0x05, 0x80, 0xC7,
  0x00, 0x7E, 0x0D, 0x76, 0x02, 0xE0, 0xE8, 0x0D, 0x00, 0x01, 0xF0, 0x37, 0x50, 0x8E, 0x09, 0x80,
  0xD1, 0x00, 0xBE, 0x09, 0x75, 0x0E, 0xE0, 0x28, 0x0D, 0x10, 0x05, 0xE0, 0xE7, 0x40, 0x5E, 0x0C,
  0x80, 0xD3, 0x00, 0xEE, 0x06, 0x73, 0x0B, 0xE0, 0x68, 0x0D, 0x30, 0x08, 0xE0, 0xC7, 0x20, 0x1E,
  0x0E, 0x80, 0xD4, 0x00, 0x2F, 0x02, 0x71, 0x07, 0xE0, 0x98, 0x0D, 0x50, 0x0C, 0xE0, 0x87, 0x10,
  0xDE, 0x03, 0x80, 0xD5, 0x00, 0x6E, 0x0E, 0x70, 0x4E, 0x0C, 0x80, 0xD6, 0x00, 0x10, 0xEE, 0x04,
  0x60, 0xAE, 0x06, 0x80, 0xD7, 0x00, 0x9E, 0x0A, 0x50, 0x1E, 0x0E, 0x01, 0x80, 0xD7, 0x00, 0x3F,
  0x01, 0x40, 0x7E, 0x09, 0x80, 0xE1, 0x00, 0xDE, 0x07, 0x40, 0xDE, 0x03, 0x80, 0xE1, 0x00, 0x7E,
  0x0D, 0x30, 0x3E, 0x0D, 0x80, 0xE2, 0x00, 0x1F, 0x03, 0x20, 0x9E, 0x07, 0x80, 0xE3, 0x00, 0xBE,
  0x09, 0x20, 0xEE, 0x01, 0x80, 0xE3, 0x00, 0x5E, 0x81, 0xE0, 0x6E, 0x0A, 0x80, 0xE5, 0x00, 0xEE,
  0x05, 0x0C, 0xE0, 0x48, 0x0E, 0x50, 0x08, 0xE0, 0xB0,
  // "Â" (U+00C2)
  0x77, 0x77, 0x50, 0x58, 0x02, 0x70, 0x18, 0x0F, 0x40, 0x03, 0xF0, 0xA8, 0x0F, 0x40, 0x0C, 0xF9,
  0x05, 0x80, 0xF2, 0x00, 0x8F, 0xA0, 0xE0, 0x18, 0x0F, 0x00, 0x04, 0xFC, 0x0B, 0x80, 0xE7, 0x00,
  0x10, 0xEF, 0xD0, 0x78, 0x0E, 0x60, 0x0B, 0xE0, 0xBF, 0x04, 0x80, 0xE4, 0x00, 0x8E, 0x81, 0xB0,
  0x5E, 0x0E, 0x02, 0x80, 0xE2, 0x00, 0x5E, 0x0D, 0x01, 0x20, 0x7E, 0x0C, 0x80, 0xE1, 0x00, 0x20,
  0xED, 0x0E, 0x02, 0x40, 0x9E, 0x0A, 0x80, 0xD7, 0x00, 0x10, 0xDD, 0x0E, 0x03, 0x60, 0xAE, 0x08,
  0x80, 0xD6, 0x00, 0xCD, 0x0E, 0x03, 0x71, 0x0B, 0xE0, 0x58, 0x0D, 0x40, 0x0A, 0xE0, 0x47, 0x30,
  0xCD, 0x0E, 0x03, 0x80, 0xD2, 0x00, 0x8E, 0x05, 0x74, 0x01, 0x0C, 0xD0, 0xD0, 0x18, 0x0D, 0x00,
  0x06, 0xE0, 0x47, 0x60, 0x10, 0xCD, 0x0C, 0x80, 0xC7, 0x00, 0x4E, 0x04, 0x77, 0x20, 0xBD, 0x0B,
  0x80, 0xC5, 0x00, 0x30, 0xEC, 0x0E, 0x04, 0x77, 0x40, 0xBD, 0x0A, 0x80, 0xC3, 0x00, 0x20, 0xEC,
  0x0D, 0x03, 0x77, 0x60, 0x9D, 0x08, 0x80, 0xC2, 0x00, 0xCC, 0x0C, 0x01, 0x77, 0x71, 0x07, 0xD0,
  0x58, 0x0C, 0x10, 0x80, 0x15, 0x77, 0x74, 0x84, 0x45, 0x55, 0x52, 0x80, 0x99, 0xE7, 0x00, 0x88,
  0x02, 0xD0, 0x38, 0x0F, 0x50, 0x0E, 0xE0, 0x98, 0x0F, 0x40, 0x05, 0xF0, 0xE8, 0x0F, 0x40, 0x0B,
  0xF9, 0x06, 0x80, 0xF2, 0x00, 0x2F, 0xA0, 0xB8, 0x0F, 0x20, 0x08, 0xFB, 0x02, 0x80, 0xF1, 0x00,
  0xDF, 0xB0, 0x88, 0x0F, 0x00, 0x04, 0xD0, 0xED, 0x0D, 0x80, 0xF0, 0x00, 0xAD, 0x07, 0x0E, 0xD0,
  0x48, 0x0E, 0x60, 0x01, 0xE0, 0x10, 0x9D, 0x0A, 0x80, 0xE6, 0x00, 0x7D, 0x81, 0xC0, 0x4E, 0x01,
  0x80, 0xE5, 0x00, 0xDD, 0x07, 0x20, 0xED, 0x06, 0x80, 0xE4, 0x00, 0x4E, 0x02, 0x20, 0x9D, 0x0C,
  0x80, 0xE4, 0x00, 0xAD, 0x0C, 0x30, 0x4E, 0x03, 0x80, 0xE2, 0x00, 0x1E, 0x07, 0x40, 0xED, 0x09,
  0x80, 0xE2, 0x00, 0x6E, 0x02, 0x40, 0x9D, 0x0E, 0x80, 0xE2, 0x00, 0xCD, 0x0C, 0x50, 0x4E, 0x05,
  0x80, 0xE0, 0x00, 0x3E, 0x07, 0x60, 0xED, 0x0B, 0x80, 0xE0, 0x00, 0x9E, 0x02, 0x60, 0xAE, 0x02,
  0x80, 0xD7, 0x00, 0xED, 0x0C, 0x70, 0x5E, 0x07, 0x80, 0xD6, 0x00, 0x6E, 0x07, 0x71, 0x0E, 0xD0,
  0xD8, 0x0D, 0x60, 0x0C, 0xE0, 0x17, 0x10, 0x9E, 0x04, 0x80, 0xD4, 0x00, 0x2E, 0x0A, 0x72, 0x03,
  0xE0, 0xA8, 0x0D, 0x40, 0x08, 0xE0, 0x47, 0x30, 0xDE, 0x01, 0x80, 0xD3, 0x00, 0xED, 0x0D, 0x74,
  0x07, 0xE0, 0x68, 0x0D, 0x20, 0x05, 0xE0, 0x87, 0x40, 0x2E, 0x0C, 0x80, 0xD2, 0x00, 0xBE, 0x02,
  0x75, 0x0B, 0xE0, 0x28, 0x0D, 0x00, 0x02, 0xE0, 0xB7, 0x60, 0x5E, 0x08, 0x80, 0xD0, 0x00, 0x8E,
  0x05, 0x77, 0x0E, 0xD0, 0xE8, 0x0D, 0x00, 0x0D, 0xD0, 0xE7, 0x71, 0x09, 0xE0, 0x58, 0x0C, 0x60,
  0x04, 0xE0, 0x97, 0x71, 0x04, 0xE0, 0xB8, 0x0C, 0x60, 0x0A, 0xE0, 0x37, 0x72, 0x0D, 0xE0, 0x18,
  0x0C, 0x40, 0x01, 0xE0, 0xC7, 0x73, 0x08, 0xE0, 0x78, 0x0C, 0x40, 0x07, 0xE0, 0x67, 0x73, 0x02,
  0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0x17, 0x74, 0x0C, 0xE0, 0x38, 0x0C, 0x20, 0x03, 0xE0, 0xA7,
  0x75, 0x06, 0xE0, 0x98, 0x0C, 0x20, 0x0A, 0xE0, 0x47, 0x75, 0x01, 0xE0, 0xE8, 0x0C, 0x10, 0x01,
  0xE0, 0xD7, 0x77, 0x0A, 0xE0, 0x68, 0x0C, 0x00, 0x06, 0xE0, 0x87, 0x77, 0x04, 0xE0, 0xC8, 0x0C,
  0x00, 0x0C, 0xE0, 0x27, 0x77, 0x10, 0xDE, 0x02, 0x77, 0x77, 0x60, 0x3E, 0x0B, 0x77, 0x72, 0x08,
  0xE0, 0x87, 0x77, 0x76, 0x09, 0xE0, 0x57, 0x77, 0x20, 0x2E, 0x0E, 0x77, 0x77, 0x60, 0xED, 0x0E,
  0x77, 0x74, 0x0C, 0xE0, 0x47, 0x77, 0x74, 0x05, 0xE0, 0x97, 0x77, 0x40, 0x6E, 0x0A, 0x77, 0x77,
  0x40, 0xBE, 0x03, 0x77, 0x74, 0x01, 0xF0, 0x17, 0x77, 0x72, 0x02, 0xE0, 0xC7, 0x77, 0x60, 0xAE,
  0x07, 0x77, 0x77, 0x20, 0x8E, 0x06, 0x77, 0x76, 0x04, 0xE0, 0xD7, 0x77, 0x72, 0x0E, 0xE0, 0x17,
  0x77, 0x70, 0xEE, 0x03, 0x77, 0x77, 0x05, 0xE0, 0xA7, 0x77, 0x71, 0x08, 0xE0, 0x97, 0x77, 0x70,
  0xBE, 0x04, 0x77, 0x77, 0x10, 0x3E, 0x0E, 0x77, 0x76, 0x01, 0xF8, 0x0B, 0x3B, 0xF0, 0x57, 0x77,
  0x50, 0x78, 0x0D, 0x1F, 0x0B, 0x77, 0x75, 0x0D, 0x80, 0xD2, 0xF0, 0x27, 0x77, 0x30, 0x48, 0x0D,
  0x3F, 0x08, 0x77, 0x73, 0x0A, 0x80, 0xD3, 0xF0, 0xD7, 0x77, 0x20, 0x18, 0x0D, 0x5F, 0x04, 0x77,
  0x71, 0x07, 0xE0, 0xC8, 0x0B, 0x77, 0x0C, 0xE0, 0xA7, 0x77, 0x10, 0xDE, 0x04, 0x77, 0x77, 0x70,
  0x5F, 0x01, 0x77, 0x60, 0x3E, 0x0E, 0x80, 0xC1, 0x00, 0xEE, 0x06, 0x77, 0x60, 0x9E, 0x08, 0x80,
  0xC1, 0x00, 0x9E, 0x0C, 0x77, 0x50, 0x10, 0xEE, 0x02, 0x80, 0xC1, 0x00, 0x3F, 0x03, 0x77, 0x40,
  0x6E, 0x0B, 0x80, 0xC3, 0x00, 0xCE, 0x08, 0x77, 0x40, 0xCE, 0x05, 0x80, 0xC3, 0x00, 0x6E, 0x0E,
  0x77, 0x30, 0x3E, 0x0E, 0x80, 0xC4, 0x00, 0x1F, 0x05, 0x77, 0x20, 0x9E, 0x08, 0x80, 0xC5, 0x00,
  0xAE, 0x0B, 0x77, 0x20, 0xEE, 0x02, 0x80, 0xC5, 0x00, 0x4F, 0x01, 0x77, 0x05, 0xE0, 0xB8, 0x0C,
  0x70, 0x0D, 0xE0, 0x77, 0x70, 0xBE, 0x05, 0x80, 0xC7, 0x00, 0x7E, 0x0D, 0x76, 0x02, 0xE0, 0xE8,
  0x0D, 0x00, 0x01, 0xF0, 0x37, 0x50, 0x8E, 0x09, 0x80, 0xD1, 0x00, 0xBE, 0x09, 0x75, 0x0E, 0xE0,
  0x28, 0x0D, 0x10, 0x05, 0xE0, 0xE7, 0x40, 0x5E, 0x0C, 0x80, 0xD3, 0x00, 0xEE, 0x06, 0x73, 0x0B,
  0xE0, 0x68, 0x0D, 0x30, 0x08, 0xE0, 0xC7, 0x20, 0x1E, 0x0E, 0x80, 0xD4, 0x00, 0x2F, 0x02, 0x71,
  0x07, 0xE0, 0x98, 0x0D, 0x50, 0x0C, 0xE0, 0x87, 0x10, 0xDE, 0x03, 0x80, 0xD5, 0x00, 0x6E, 0x0E,
  0x70, 0x4E, 0x0C, 0x80, 0xD6, 0x00, 0x10, 0xEE, 0x04, 0x60, 0xAE, 0x06, 0x80, 0xD7, 0x00, 0x9E,
  0x0A, 0x50, 0x1E, 0x0E, 0x01, 0x80, 0xD7, 0x00, 0x3F, 0x01, 0x40, 0x7E, 0x09, 0x80, 0xE1, 0x00,
  0xDE, 0x07, 0x40, 0xDE, 0x03, 0x80, 0xE1, 0x00, 0x7E, 0x0D, 0x30, 0x3E, 0x0D, 0x80, 0xE2, 0x00,
  0x1F, 0x03, 0x20, 0x9E, 0x07, 0x80, 0xE3, 0x00, 0xBE, 0x09, 0x20, 0xEE, 0x01, 0x80, 0xE3, 0x00,
  0x5E, 0x81, 0xE0, 0x6E, 0x0A, 0x80, 0xE5, 0x00, 0xEE, 0x05, 0x0C, 0xE0, 0x48, 0x0E, 0x50, 0x08,
  0xE0, 0xB0,
  // "Ã" (U+00C3)
  0x77, 0x71, 0x87, 0x48, 0xAC, 0xDB, 0x96, 0x17, 0x76, 0x0B, 0xB0, 0xD8, 0x0C, 0x10, 0x05, 0x0D,
  0xFA, 0x09, 0x01, 0x77, 0x40, 0xEB, 0x0B, 0x80, 0xC0, 0x00, 0xAF, 0xD0, 0xE0, 0x77, 0x72, 0x02,
  0xC0, 0x97, 0x77, 0x77, 0x0B, 0xFF, 0x90, 0xC0, 0x27, 0x70, 0x7C, 0x06, 0x77, 0x77, 0x60, 0x9F,
  0xFC, 0x07, 0x76, 0x0E, 0xC0, 0x27, 0x77, 0x75, 0x04, 0xF8, 0x2E, 0xDD, 0xEF, 0xA0, 0xB0, 0x27,
  0x30, 0x8C, 0x0C, 0x77, 0x77, 0x60, 0xCD, 0x0B, 0x03, 0x40, 0x30, 0x8F, 0x90, 0xE0, 0x77, 0x10,
  0x7D, 0x06, 0x77, 0x77, 0x50, 0x4D, 0x07, 0x71, 0x02, 0x0B, 0xF9, 0x81, 0xD6, 0x13, 0x05, 0x0C,
  0xD0, 0xE7, 0x77, 0x76, 0x09, 0xC0, 0xA7, 0x40, 0x50, 0xEF, 0xB0, 0xEF, 0x90, 0x67, 0x77, 0x76,
  0x0E, 0xC0, 0x27, 0x50, 0x20, 0xCF, 0xFB, 0x0A, 0x77, 0x77, 0x60, 0x2C, 0x0B, 0x77, 0x10, 0x7F,
  0xF9, 0x0B, 0x77, 0x77, 0x70, 0x5C, 0x06, 0x77, 0x20, 0x30, 0xBF, 0xD0, 0x98, 0x0C, 0x00, 0x07,
  0xC0, 0x37, 0x74, 0x05, 0x0C, 0xF9, 0x0C, 0x04, 0x80, 0xC1, 0x00, 0x68, 0x00, 0xB7, 0x77, 0x86,
  0x27, 0x9A, 0xA9, 0x62, 0x80, 0x9B, 0x87, 0x00, 0x88, 0x02, 0xD0, 0x38, 0x0F, 0x50, 0x0E, 0xE0,
  0x98, 0x0F, 0x40, 0x05, 0xF0, 0xE8, 0x0F, 0x40, 0x0B, 0xF9, 0x06, 0x80, 0xF2, 0x00, 0x2F, 0xA0,
  0xB8, 0x0F, 0x20, 0x08, 0xFB, 0x02, 0x80, 0xF1, 0x00, 0xDF, 0xB0, 0x88, 0x0F, 0x00, 0x04, 0xD0,
  0xED, 0x0D, 0x80, 0xF0, 0x00, 0xAD, 0x07, 0x0E, 0xD0, 0x48, 0x0E, 0x60, 0x01, 0xE0, 0x10, 0x9D,
  0x0A, 0x80, 0xE6, 0x00, 0x7D, 0x81, 0xC0, 0x4E, 0x01, 0x80, 0xE5, 0x00, 0xDD, 0x07, 0x20, 0xED,
  0x06, 0x80, 0xE4, 0x00, 0x4E, 0x02, 0x20, 0x9D, 0x0C, 0x80, 0xE4, 0x00, 0xAD, 0x0C, 0x30, 0x4E,
  0x03, 0x80, 0xE2, 0x00, 0x1E, 0x07, 0x40, 0xED, 0x09, 0x80, 0xE2, 0x00, 0x6E, 0x02, 0x40, 0x9D,
  0x0E, 0x80, 0xE2, 0x00, 0xCD, 0x0C, 0x50, 0x4E, 0x05, 0x80, 0xE0, 0x00, 0x3E, 0x07, 0x60, 0xED,
  0x0B, 0x80, 0xE0, 0x00, 0x9E, 0x02, 0x60, 0xAE, 0x02, 0x80, 0xD7, 0x00, 0xED, 0x0C, 0x70, 0x5E,
  0x07, 0x80, 0xD6, 0x00, 0x6E, 0x07, 0x71, 0x0E, 0xD0, 0xD8, 0x0D, 0x60, 0x0C, 0xE0, 0x17, 0x10,
  0x9E, 0x04, 0x80, 0xD4, 0x00, 0x2E, 0x0A, 0x72, 0x03, 0xE0, 0xA8, 0x0D, 0x40, 0x08, 0xE0, 0x47,
  0x30, 0xDE, 0x01, 0x80, 0xD3, 0x00, 0xED, 0x0D, 0x74, 0x07, 0xE0, 0x68, 0x0D, 0x20, 0x05, 0xE0,
  0x87, 0x40, 0x2E, 0x0C, 0x80, 0xD2, 0x00, 0xBE, 0x02, 0x75, 0x0B, 0xE0, 0x28, 0x0D, 0x00, 0x02,
  0xE0, 0xB7, 0x60, 0x5E, 0x08, 0x80, 0xD0, 0x00, 0x8E, 0x05, 0x77, 0x0E, 0xD0, 0xE8, 0x0D, 0x00,
  0x0D, 0xD0, 0xE7, 0x71, 0x09, 0xE0, 0x58, 0x0C, 0x60, 0x04, 0xE0, 0x97, 0x71, 0x04, 0xE0, 0xB8,
  0x0C, 0x60, 0x0A, 0xE0, 0x37, 0x72, 0x0D, 0xE0, 0x18, 0x0C, 0x40, 0x01, 0xE0, 0xC7, 0x73, 0x08,
  0xE0, 0x78, 0x0C, 0x40, 0x07, 0xE0, 0x67, 0x73, 0x02, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0x17,
  0x74, 0x0C, 0xE0, 0x38, 0x0C, 0x20, 0x03, 0xE0, 0xA7, 0x75, 0x06, 0xE0, 0x98, 0x0C, 0x20, 0x0A,
  0xE0, 0x47, 0x75, 0x01, 0xE0, 0xE8, 0x0C, 0x10, 0x01, 0xE0, 0xD7, 0x77, 0x0A, 0xE0, 0x68, 0x0C,
  0x00, 0x06, 0xE0, 0x87, 0x77, 0x04, 0xE0, 0xC8, 0x0C, 0x00, 0x0C, 0xE0, 0x27, 0x77, 0x10, 0xDE,
  0x02, 0x77, 0x77, 0x60, 0x3E, 0x0B, 0x77, 0x72, 0x08, 0xE0, 0x87, 0x77, 0x76, 0x09, 0xE0, 0x57,
  0x77, 0x20, 0x2E, 0x0E, 0x77, 0x77, 0x60, 0xED, 0x0E, 0x77, 0x74, 0x0C, 0xE0, 0x47, 0x77, 0x74,
  0x05, 0xE0, 0x97, 0x77, 0x40, 0x6E, 0x0A, 0x77, 0x77, 0x40, 0xBE, 0x03, 0x77, 0x74, 0x01, 0xF0,
  0x17, 0x77, 0x72, 0x02, 0xE0, 0xC7, 0x77, 0x60, 0xAE, 0x07, 0x77, 0x77, 0x20, 0x8E, 0x06, 0x77,
  0x76, 0x04, 0xE0, 0xD7, 0x77, 0x72, 0x0E, 0xE0, 0x17, 0x77, 0x70, 0xEE, 0x03, 0x77, 0x77, 0x05,
  0xE0, 0xA7, 0x77, 0x71, 0x08, 0xE0, 0x97, 0x77, 0x70, 0xBE, 0x04, 0x77, 0x77, 0x10, 0x3E, 0x0E,
  0x77, 0x76, 0x01, 0xF8, 0x0B, 0x3B, 0xF0, 0x57, 0x77, 0x50, 0x78, 0x0D, 0x1F, 0x0B, 0x77, 0x75,
  0x0D, 0x80, 0xD2, 0xF0, 0x27, 0x77, 0x30, 0x48, 0x0D, 0x3F, 0x08, 0x77, 0x73, 0x0A, 0x80, 0xD3,
  0xF0, 0xD7, 0x77, 0x20, 0x18, 0x0D, 0x5F, 0x04, 0x77, 0x71, 0x07, 0xE0, 0xC8, 0x0B, 0x77, 0x0C,
  0xE0, 0xA7, 0x77, 0x10, 0xDE, 0x04, 0x77, 0x77, 0x70, 0x5F, 0x01, 0x77, 0x60, 0x3E, 0x0E, 0x80,
  0xC1, 0x00, 0xEE, 0x06, 0x77, 0x60, 0x9E, 0x08, 0x80, 0xC1, 0x00, 0x9E, 0x0C, 0x77, 0x50, 0x10,
  0xEE, 0x02, 0x80, 0xC1, 0x00, 0x3F, 0x03, 0x77, 0x40, 0x6E, 0x0B, 0x80, 0xC3, 0x00, 0xCE, 0x08,
  0x77, 0x40, 0xCE, 0x05, 0x80, 0xC3, 0x00, 0x6E, 0x0E, 0x77, 0x30, 0x3E, 0x0E, 0x80, 0xC4, 0x00,
  0x1F, 0x05, 0x77, 0x20, 0x9E, 0x08, 0x80, 0xC5, 0x00, 0xAE, 0x0B, 0x77, 0x20, 0xEE, 0x02, 0x80,
  0xC5, 0x00, 0x4F, 0x01, 0x77, 0x05, 0xE0, 0xB8, 0x0C, 0x70, 0x0D, 0xE0, 0x77, 0x70, 0xBE, 0x05,
  0x80, 0xC7, 0x00, 0x7E, 0x0D, 0x76, 0x02, 0xE0, 0xE8, 0x0D, 0x00, 0x01, 0xF0, 0x37, 0x50, 0x8E,
  0x09, 0x80, 0xD1, 0x00, 0xBE, 0x09, 0x75, 0x0E, 0xE0, 0x28, 0x0D, 0x10, 0x05, 0xE0, 0xE7, 0x40,
  0x5E, 0x0C, 0x80, 0xD3, 0x00, 0xEE, 0x06, 0x73, 0x0B, 0xE0, 0x68, 0x0D, 0x30, 0x08, 0xE0, 0xC7,
  0x20, 0x1E, 0x0E, 0x80, 0xD4, 0x00, 0x2F, 0x02, 0x71, 0x07, 0xE0, 0x98, 0x0D, 0x50, 0x0C, 0xE0,
  0x87, 0x10, 0xDE, 0x03, 0x80, 0xD5, 0x00, 0x6E, 0x0E, 0x70, 0x4E, 0x0C, 0x80, 0xD6, 0x00, 0x10,
  0xEE, 0x04, 0x60, 0xAE, 0x06, 0x80, 0xD7, 0x00, 0x9E, 0x0A, 0x50, 0x1E, 0x0E, 0x01, 0x80, 0xD7,
  0x00, 0x3F, 0x01, 0x40, 0x7E, 0x09, 0x80, 0xE1, 0x00, 0xDE, 0x07, 0x40, 0xDE, 0x03, 0x80, 0xE1,
  0x00, 0x7E, 0x0D, 0x30, 0x3E, 0x0D, 0x80, 0xE2, 0x00, 0x1F, 0x03, 0x20, 0x9E, 0x07, 0x80, 0xE3,
  0x00, 0xBE, 0x09, 0x20, 0xEE, 0x01, 0x80, 0xE3, 0x00, 0x5E, 0x81, 0xE0, 0x6E, 0x0A, 0x80, 0xE5,
  0x00, 0xEE, 0x05, 0x0C, 0xE0, 0x48, 0x0E, 0x50, 0x08, 0xE0, 0xB0,
  // "Ä" (U+00C4)
  0x77, 0x73, 0x81, 0x23, 0x27, 0x75, 0x81, 0x13, 0x38, 0x0D, 0x20, 0x03, 0x0D, 0xB0, 0xD0, 0x37,
  0x72, 0x0A, 0xB0, 0xE0, 0x68, 0x0D, 0x00, 0x0E, 0xD0, 0xE0, 0x17, 0x70, 0xAE, 0x05, 0x80, 0xC6,
  0x00, 0x5F, 0x07, 0x76, 0x01, 0xF0, 0xC8, 0x0C, 0x60, 0x08, 0xF0, 0xA7, 0x60, 0x3F, 0x98, 0x0C,
  0x60, 0x09, 0xF0, 0xB7, 0x60, 0x4F, 0x90, 0x18, 0x0C, 0x50, 0x09, 0xF0, 0xA7, 0x60, 0x4F, 0x98,
  0x0C, 0x60, 0x06, 0xF0, 0x77, 0x60, 0x1F, 0x0D, 0x80, 0xC6, 0x00, 0x10, 0xEE, 0x02, 0x77, 0x0B,
  0xE0, 0x78, 0x0C, 0x70, 0x05, 0xD0, 0x57, 0x71, 0x02, 0x0D, 0xC0, 0xA8, 0x0D, 0x10, 0x83, 0x15,
  0x75, 0x17, 0x74, 0x82, 0x47, 0x62, 0x80, 0x9E, 0xC0, 0x00, 0x88, 0x02, 0xD0, 0x38, 0x0F, 0x50,
  0x0E, 0xE0, 0x98, 0x0F, 0x40, 0x05, 0xF0, 0xE8, 0x0F, 0x40, 0x0B, 0xF9, 0x06, 0x80, 0xF2, 0x00,
  0x2F, 0xA0, 0xB8, 0x0F, 0x20, 0x08, 0xFB, 0x02, 0x80, 0xF1, 0x00, 0xDF, 0xB0, 0x88, 0x0F, 0x00,
  0x04, 0xD0, 0xED, 0x0D, 0x80, 0xF0, 0x00, 0xAD, 0x07, 0x0E, 0xD0, 0x48, 0x0E, 0x60, 0x01, 0xE0,
  0x10, 0x9D, 0x0A, 0x80, 0xE6, 0x00, 0x7D, 0x81, 0xC0, 0x4E, 0x01, 0x80, 0xE5, 0x00, 0xDD, 0x07,
  0x20, 0xED, 0x06, 0x80, 0xE4, 0x00, 0x4E, 0x02, 0x20, 0x9D, 0x0C, 0x80, 0xE4, 0x00, 0xAD, 0x0C,
  0x30, 0x4E, 0x03, 0x80, 0xE2, 0x00, 0x1E, 0x07, 0x40, 0xED, 0x09, 0x80, 0xE2, 0x00, 0x6E, 0x02,
  0x40, 0x9D, 0x0E, 0x80, 0xE2, 0x00, 0xCD, 0x0C, 0x50, 0x4E, 0x05, 0x80, 0xE0, 0x00, 0x3E, 0x07,
  0x60, 0xED, 0x0B, 0x80, 0xE0, 0x00, 0x9E, 0x02, 0x60, 0xAE, 0x02, 0x80, 0xD7, 0x00, 0xED, 0x0C,
  0x70, 0x5E, 0x07, 0x80, 0xD6, 0x00, 0x6E, 0x07, 0x71, 0x0E, 0xD0, 0xD8, 0x0D, 0x60, 0x0C, 0xE0,
  0x17, 0x10, 0x9E, 0x04, 0x80, 0xD4, 0x00, 0x2E, 0x0A, 0x72, 0x03, 0xE0, 0xA8, 0x0D, 0x40, 0x08,
  0xE0, 0x47, 0x30, 0xDE, 0x01, 0x80, 0xD3, 0x00, 0xED, 0x0D, 0x74, 0x07, 0xE0, 0x68, 0x0D, 0x20,
  0x05, 0xE0, 0x87, 0x40, 0x2E, 0x0C, 0x80, 0xD2, 0x00, 0xBE, 0x02, 0x75, 0x0B, 0xE0, 0x28, 0x0D,
  0x00, 0x02, 0xE0, 0xB7, 0x60, 0x5E, 0x08, 0x80, 0xD0, 0x00, 0x8E, 0x05, 0x77, 0x0E, 0xD0, 0xE8,
  0x0D, 0x00, 0x0D, 0xD0, 0xE7, 0x71, 0x09, 0xE0, 0x58, 0x0C, 0x60, 0x04, 0xE0, 0x97, 0x71, 0x04,
  0xE0, 0xB8, 0x0C, 0x60, 0x0A, 0xE0, 0x37, 0x72, 0x0D, 0xE0, 0x18, 0x0C, 0x40, 0x01, 0xE0, 0xC7,
  0x73, 0x08, 0xE0, 0x78, 0x0C, 0x40, 0x07, 0xE0, 0x67, 0x73, 0x02, 0xE0, 0xD8, 0x0C, 0x40, 0x0D,
  0xE0, 0x17, 0x74, 0x0C, 0xE0, 0x38, 0x0C, 0x20, 0x03, 0xE0, 0xA7, 0x75, 0x06, 0xE0, 0x98, 0x0C,
  0x20, 0x0A, 0xE0, 0x47, 0x75, 0x01, 0xE0, 0xE8, 0x0C, 0x10, 0x01, 0xE0, 0xD7, 0x77, 0x0A, 0xE0,
  0x68, 0x0C, 0x00, 0x06, 0xE0, 0x87, 0x77, 0x04, 0xE0, 0xC8, 0x0C, 0x00, 0x0C, 0xE0, 0x27, 0x77,
  0x10, 0xDE, 0x02, 0x77, 0x77, 0x60, 0x3E, 0x0B, 0x77, 0x72, 0x08, 0xE0, 0x87, 0x77, 0x76, 0x09,
  0xE0, 0x57, 0x77, 0x20, 0x2E, 0x0E, 0x77, 0x77, 0x60, 0xED, 0x0E, 0x77, 0x74, 0x0C, 0xE0, 0x47,
  0x77, 0x74, 0x05, 0xE0, 0x97, 0x77, 0x40, 0x6E, 0x0A, 0x77, 0x77, 0x40, 0xBE, 0x03, 0x77, 0x74,
  0x01, 0xF0, 0x17, 0x77, 0x72, 0x02, 0xE0, 0xC7, 0x77, 0x60, 0xAE, 0x07, 0x77, 0x77, 0x20, 0x8E,
  0x06, 0x77, 0x76, 0x04, 0xE0, 0xD7, 0x77, 0x72, 0x0E, 0xE0, 0x17, 0x77, 0x70, 0xEE, 0x03, 0x77,
  0x77, 0x05, 0xE0, 0xA7, 0x77, 0x71, 0x08, 0xE0, 0x97, 0x77, 0x70, 0xBE, 0x04, 0x77, 0x77, 0x10,
  0x3E, 0x0E, 0x77, 0x76, 0x01, 0xF8, 0x0B, 0x3B, 0xF0, 0x57, 0x77, 0x50, 0x78, 0x0D, 0x1F, 0x0B,
  0x77, 0x75, 0x0D, 0x80, 0xD2, 0xF0, 0x27, 0x77, 0x30, 0x48, 0x0D, 0x3F, 0x08, 0x77, 0x73, 0x0A,
  0x80, 0xD3, 0xF0, 0xD7, 0x77, 0x20, 0x18, 0x0D, 0x5F, 0x04, 0x77, 0x71, 0x07, 0xE0, 0xC8, 0x0B,
  0x77, 0x0C, 0xE0, 0xA7, 0x77, 0x10, 0xDE, 0x04, 0x77, 0x77, 0x70, 0x5F, 0x01, 0x77, 0x60, 0x3E,
  0x0E, 0x80, 0xC1, 0x00, 0xEE, 0x06, 0x77, 0x60, 0x9E, 0x08, 0x80, 0xC1, 0x00, 0x9E, 0x0C, 0x77,
  0x50, 0x10, 0xEE, 0x02, 0x80, 0xC1, 0x00, 0x3F, 0x03, 0x77, 0x40, 0x6E, 0x0B, 0x80, 0xC3, 0x00,
  0xCE, 0x08, 0x77, 0x40, 0xCE, 0x05, 0x80, 0xC3, 0x00, 0x6E, 0x0E, 0x77, 0x30, 0x3E, 0x0E, 0x80,
  0xC4, 0x00, 0x1F, 0x05, 0x77, 0x20, 0x9E, 0x08, 0x80, 0xC5, 0x00, 0xAE, 0x0B, 0x77, 0x20, 0xEE,
  0x02, 0x80, 0xC5, 0x00, 0x4F, 0x01, 0x77, 0x05, 0xE0, 0xB8, 0x0C, 0x70, 0x0D, 0xE0, 0x77, 0x70,
  0xBE, 0x05, 0x80, 0xC7, 0x00, 0x7E, 0x0D, 0x76, 0x02, 0xE0, 0xE8, 0x0D, 0x00, 0x01, 0xF0, 0x37,
  0x50, 0x8E, 0x09, 0x80, 0xD1, 0x00, 0xBE, 0x09, 0x75, 0x0E, 0xE0, 0x28, 0x0D, 0x10, 0x05, 0xE0,
  0xE7, 0x40, 0x5E, 0x0C, 0x80, 0xD3, 0x00, 0xEE, 0x06, 0x73, 0x0B, 0xE0, 0x68, 0x0D, 0x30, 0x08,
  0xE0, 0xC7, 0x20, 0x1E, 0x0E, 0x80, 0xD4, 0x00, 0x2F, 0x02, 0x71, 0x07, 0xE0, 0x98, 0x0D, 0x50,
  0x0C, 0xE0, 0x87, 0x10, 0xDE, 0x03, 0x80, 0xD5, 0x00, 0x6E, 0x0E, 0x70, 0x4E, 0x0C, 0x80, 0xD6,
  0x00, 0x10, 0xEE, 0x04, 0x60, 0xAE, 0x06, 0x80, 0xD7, 0x00, 0x9E, 0x0A, 0x50, 0x1E, 0x0E, 0x01,
  0x80, 0xD7, 0x00, 0x3F, 0x01, 0x40, 0x7E, 0x09, 0x80, 0xE1, 0x00, 0xDE, 0x07, 0x40, 0xDE, 0x03,
  0x80, 0xE1, 0x00, 0x7E, 0x0D, 0x30, 0x3E, 0x0D, 0x80, 0xE2, 0x00, 0x1F, 0x03, 0x20, 0x9E, 0x07,
  0x80, 0xE3, 0x00, 0xBE, 0x09, 0x20, 0xEE, 0x01, 0x80, 0xE3, 0x00, 0x5E, 0x81, 0xE0, 0x6E, 0x0A,
  0x80, 0xE5, 0x00, 0xEE, 0x05, 0x0C, 0xE0, 0x48, 0x0E, 0x50, 0x08, 0xE0, 0xB0,
  // "Å" (U+00C5)
  0x77, 0x77, 0x58, 0x52, 0x45, 0x75, 0x52, 0x80, 0xF3, 0x08, 0x11, 0x8D, 0xF8, 0x1E, 0x82, 0x80,
  0xE7, 0x00, 0x8F, 0xE0, 0x98, 0x0E, 0x40, 0x01, 0x0C, 0xFF, 0x90, 0xD0, 0x28, 0x0E, 0x10, 0x01,
  0x0D, 0xF9, 0x0D, 0x0E, 0xF0, 0xE0, 0x28, 0x0E, 0x00, 0x0B, 0xD8, 0x1D, 0x62, 0x38, 0x11, 0x6D,
  0xD0, 0xD8, 0x0D, 0x70, 0x06, 0xD0, 0x97, 0x20, 0x8D, 0x08, 0x80, 0xD6, 0x00, 0xEC, 0x08, 0x74,
  0x07, 0xD0, 0x18, 0x0D, 0x40, 0x05, 0xC0, 0xC7, 0x60, 0xBC, 0x07, 0x80, 0xD4, 0x00, 0x9C, 0x03,
  0x76, 0x02, 0xC0, 0xC8, 0x0D, 0x40, 0x0C, 0xB0, 0xD7, 0x71, 0x0C, 0xC8, 0x0D, 0x40, 0x0E, 0xB0,
  0xA7, 0x71, 0x09, 0xC0, 0x28, 0x0D, 0x30, 0xC0, 0x97, 0x71, 0x07, 0xC0, 0x28, 0x0D, 0x30, 0xC0,
  0x97, 0x71, 0x08, 0xC0, 0x28, 0x0D, 0x30, 0x0D, 0xB0, 0xB7, 0x71, 0x0A, 0xC0, 0x18, 0x0D, 0x30,
  0x0B, 0xB0, 0xE7, 0x71, 0x0E, 0xB0, 0xE8, 0x0D, 0x40, 0x08, 0xC0, 0x57, 0x60, 0x4C, 0x0B, 0x80,
  0xD4, 0x00, 0x3C, 0x0D, 0x01, 0x75, 0x0D, 0xC0, 0x68, 0x0D, 0x50, 0x0C, 0xC0, 0xB7, 0x40, 0xBC,
  0x0E, 0x01, 0x80, 0xD5, 0x00, 0x4D, 0x0C, 0x03, 0x70, 0x30, 0xCD, 0x07, 0x80, 0xD7, 0x00, 0x9E,
  0x85, 0xC7, 0x54, 0x57, 0xBE, 0x0C, 0x80, 0xE1, 0x00, 0xBF, 0xFB, 0x0D, 0x01, 0x80, 0xE2, 0x00,
  0x9F, 0xF9, 0x0B, 0x01, 0x80, 0xE4, 0x00, 0x40, 0xDF, 0xC0, 0xE0, 0x68, 0x0F, 0x00, 0x05, 0x0E,
  0xF9, 0x0A, 0x80, 0xF2, 0x00, 0x2F, 0xA0, 0xB8, 0x0F, 0x20, 0x08, 0xFB, 0x02, 0x80, 0xF1, 0x00,
  0xDF, 0xB0, 0x88, 0x0F, 0x00, 0x04, 0xD0, 0xED, 0x0D, 0x80, 0xF0, 0x00, 0xAD, 0x07, 0x0E, 0xD0,
  0x48, 0x0E, 0x60, 0x01, 0xE0, 0x10, 0x9D, 0x0A, 0x80, 0xE6, 0x00, 0x7D, 0x81, 0xC0, 0x4E, 0x01,
  0x80, 0xE5, 0x00, 0xDD, 0x07, 0x20, 0xED, 0x06, 0x80, 0xE4, 0x00, 0x4E, 0x02, 0x20, 0x9D, 0x0C,
  0x80, 0xE4, 0x00, 0xAD, 0x0C, 0x30, 0x4E, 0x03, 0x80, 0xE2, 0x00, 0x1E, 0x07, 0x40, 0xED, 0x09,
  0x80, 0xE2, 0x00, 0x6E, 0x02, 0x40, 0x9D, 0x0E, 0x80, 0xE2, 0x00, 0xCD, 0x0C, 0x50, 0x4E, 0x05,
  0x80, 0xE0, 0x00, 0x3E, 0x07, 0x60, 0xED, 0x0B, 0x80, 0xE0, 0x00, 0x9E, 0x02, 0x60, 0xAE, 0x02,
  0x80, 0xD7, 0x00, 0xED, 0x0C, 0x70, 0x5E, 0x07, 0x80, 0xD6, 0x00, 0x6E, 0x07, 0x71, 0x0E, 0xD0,
  0xD8, 0x0D, 0x60, 0x0C, 0xE0, 0x17, 0x10, 0x9E, 0x04, 0x80, 0xD4, 0x00, 0x2E, 0x0A, 0x72, 0x03,
  0xE0, 0xA8, 0x0D, 0x40, 0x08, 0xE0, 0x47, 0x30, 0xDE, 0x01, 0x80, 0xD3, 0x00, 0xED, 0x0D, 0x74,
  0x07, 0xE0, 0x68, 0x0D, 0x20, 0x05, 0xE0, 0x87, 0x40, 0x2E, 0x0C, 0x80, 0xD2, 0x00, 0xBE, 0x02,
  0x75, 0x0B, 0xE0, 0x28, 0x0D, 0x00, 0x02, 0xE0, 0xB7, 0x60, 0x5E, 0x08, 0x80, 0xD0, 0x00, 0x8E,
  0x05, 0x77, 0x0E, 0xD0, 0xE8, 0x0D, 0x00, 0x0D, 0xD0, 0xE7, 0x71, 0x09, 0xE0, 0x58, 0x0C, 0x60,
  0x04, 0xE0, 0x97, 0x71, 0x04, 0xE0, 0xB8, 0x0C, 0x60, 0x0A, 0xE0, 0x37, 0x72, 0x0D, 0xE0, 0x18,
  0x0C, 0x40, 0x01, 0xE0, 0xC7, 0x73, 0x08, 0xE0, 0x78, 0x0C, 0x40, 0x07, 0xE0, 0x67, 0x73, 0x02,
  0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0x17, 0x74, 0x0C, 0xE0, 0x38, 0x0C, 0x20, 0x03, 0xE0, 0xA7,
  0x75, 0x06, 0xE0, 0x98, 0x0C, 0x20, 0x0A, 0xE0, 0x47, 0x75, 0x01, 0xE0, 0xE8, 0x0C, 0x10, 0x01,
  0xE0, 0xD7, 0x77, 0x0A, 0xE0, 0x68, 0x0C, 0x00, 0x06, 0xE0, 0x87, 0x77, 0x04, 0xE0, 0xC8, 0x0C,
  0x00, 0x0C, 0xE0, 0x27, 0x77, 0x10, 0xDE, 0x02, 0x77, 0x77, 0x60, 0x3E, 0x0B, 0x77, 0x72, 0x08,
  0xE0, 0x87, 0x77, 0x76, 0x09, 0xE0, 0x57, 0x77, 0x20, 0x2E, 0x0E, 0x77, 0x77, 0x60, 0xED, 0x0E,
  0x77, 0x74, 0x0C, 0xE0, 0x47, 0x77, 0x74, 0x05, 0xE0, 0x97, 0x77, 0x40, 0x6E, 0x0A, 0x77, 0x77,
  0x40, 0xBE, 0x03, 0x77, 0x74, 0x01, 0xF0, 0x17, 0x77, 0x72, 0x02, 0xE0, 0xC7, 0x77, 0x60, 0xAE,
  0x07, 0x77, 0x77, 0x20, 0x8E, 0x06, 0x77, 0x76, 0x04, 0xE0, 0xD7, 0x77, 0x72, 0x0E, 0xE0, 0x17,
  0x77, 0x70, 0xEE, 0x03, 0x77, 0x77, 0x05, 0xE0, 0xA7, 0x77, 0x71, 0x08, 0xE0, 0x97, 0x77, 0x70,
  0xBE, 0x04, 0x77, 0x77, 0x10, 0x3E, 0x0E, 0x77, 0x76, 0x01, 0xF8, 0x0B, 0x3B, 0xF0, 0x57, 0x77,
  0x50, 0x78, 0x0D, 0x1F, 0x0B, 0x77, 0x75, 0x0D, 0x80, 0xD2, 0xF0, 0x27, 0x77, 0x30, 0x48, 0x0D,
  0x3F, 0x08, 0x77, 0x73, 0x0A, 0x80, 0xD3, 0xF0, 0xD7, 0x77, 0x20, 0x18, 0x0D, 0x5F, 0x04, 0x77,
  0x71, 0x07, 0xE0, 0xC8, 0x0B, 0x77, 0x0C, 0xE0, 0xA7, 0x77, 0x10, 0xDE, 0x04, 0x77, 0x77, 0x70,
  0x5F, 0x01, 0x77, 0x60, 0x3E, 0x0E, 0x80, 0xC1, 0x00, 0xEE, 0x06, 0x77, 0x60, 0x9E, 0x08, 0x80,
  0xC1, 0x00, 0x9E, 0x0C, 0x77, 0x50, 0x10, 0xEE, 0x02, 0x80, 0xC1, 0x00, 0x3F, 0x03, 0x77, 0x40,
  0x6E, 0x0B, 0x80, 0xC3, 0x00, 0xCE, 0x08, 0x77, 0x40, 0xCE, 0x05, 0x80, 0xC3, 0x00, 0x6E, 0x0E,
  0x77, 0x30, 0x3E, 0x0E, 0x80, 0xC4, 0x00, 0x1F, 0x05, 0x77, 0x20, 0x9E, 0x08, 0x80, 0xC5, 0x00,
  0xAE, 0x0B, 0x77, 0x20, 0xEE, 0x02, 0x80, 0xC5, 0x00, 0x4F, 0x01, 0x77, 0x05, 0xE0, 0xB8, 0x0C,
  0x70, 0x0D, 0xE0, 0x77, 0x70, 0xBE, 0x05, 0x80, 0xC7, 0x00, 0x7E, 0x0D, 0x76, 0x02, 0xE0, 0xE8,
  0x0D, 0x00, 0x01, 0xF0, 0x37, 0x50, 0x8E, 0x09, 0x80, 0xD1, 0x00, 0xBE, 0x09, 0x75, 0x0E, 0xE0,
  0x28, 0x0D, 0x10, 0x05, 0xE0, 0xE7, 0x40, 0x5E, 0x0C, 0x80, 0xD3, 0x00, 0xEE, 0x06, 0x73, 0x0B,
  0xE0, 0x68, 0x0D, 0x30, 0x08, 0xE0, 0xC7, 0x20, 0x1E, 0x0E, 0x80, 0xD4, 0x00, 0x2F, 0x02, 0x71,
  0x07, 0xE0, 0x98, 0x0D, 0x50, 0x0C, 0xE0, 0x87, 0x10, 0xDE, 0x03, 0x80, 0xD5, 0x00, 0x6E, 0x0E,
  0x70, 0x4E, 0x0C, 0x80, 0xD6, 0x00, 0x10, 0xEE, 0x04, 0x60, 0xAE, 0x06, 0x80, 0xD7, 0x00, 0x9E,
  0x0A, 0x50, 0x1E, 0x0E, 0x01, 0x80, 0xD7, 0x00, 0x3F, 0x01, 0x40, 0x7E, 0x09, 0x80, 0xE1, 0x00,
  0xDE, 0x07, 0x40, 0xDE, 0x03, 0x80, 0xE1, 0x00, 0x7E, 0x0D, 0x30, 0x3E, 0x0D, 0x80, 0xE2, 0x00,
  0x1F, 0x03, 0x20, 0x9E, 0x07, 0x80, 0xE3, 0x00, 0xBE, 0x09, 0x20, 0xEE, 0x01, 0x80, 0xE3, 0x00,
  0x5E, 0x81, 0xE0, 0x6E, 0x0A, 0x80, 0xE5, 0x00, 0xEE, 0x05, 0x0C, 0xE0, 0x48, 0x0E, 0x50, 0x08,
  0xE0, 0xB0,
  // "Æ" (U+00C6)
  0x80, 0xC2, 0x00, 0x58, 0x0E, 0x3B, 0x03, 0x80, 0xC2, 0x00, 0xD8, 0x0E, 0x3F, 0x04, 0x80, 0xC1,
  0x00, 0x58, 0x0E, 0x4F, 0x04, 0x80, 0xC1, 0x00, 0xC8, 0x0E, 0x4F, 0x04, 0x80, 0xC0, 0x00, 0x38,
  0x0E, 0x5F, 0x04, 0x80, 0xC0, 0x00, 0xA8, 0x0E, 0x5F, 0x04, 0x77, 0x77, 0x70, 0x2E, 0x0D, 0x80,
  0x17, 0x08, 0xE0, 0xD8, 0x0C, 0x27, 0x02, 0x77, 0x77, 0x70, 0x9E, 0x06, 0x50, 0x2E, 0x0C, 0x80,
  0x98, 0x50, 0x01, 0xE0, 0xE6, 0x02, 0xE0, 0xC8, 0x09, 0x85, 0x00, 0x7E, 0x08, 0x60, 0x2E, 0x0C,
  0x80, 0x98, 0x50, 0x0E, 0xE0, 0x16, 0x02, 0xE0, 0xC8, 0x09, 0x84, 0x00, 0x6E, 0x0A, 0x70, 0x2E,
  0x0C, 0x80, 0x98, 0x40, 0x0D, 0xE0, 0x37, 0x02, 0xE0, 0xC8, 0x09, 0x83, 0x00, 0x5E, 0x0B, 0x71,
  0x02, 0xE0, 0xC8, 0x09, 0x83, 0x00, 0xCE, 0x04, 0x71, 0x02, 0xE0, 0xC8, 0x09, 0x82, 0x00, 0x3E,
  0x0D, 0x72, 0x02, 0xE0, 0xC8, 0x09, 0x82, 0x00, 0xAE, 0x06, 0x72, 0x02, 0xE0, 0xC8, 0x09, 0x81,
  0x00, 0x2E, 0x0E, 0x73, 0x02, 0xE0, 0xC8, 0x09, 0x81, 0x00, 0x9E, 0x08, 0x73, 0x02, 0xE0, 0xC8,
  0x09, 0x80, 0x00, 0x10, 0xEE, 0x01, 0x73, 0x02, 0xE0, 0xC8, 0x09, 0x80, 0x00, 0x7E, 0x09, 0x74,
  0x02, 0xE0, 0xC8, 0x09, 0x80, 0x00, 0xEE, 0x03, 0x74, 0x02, 0xE0, 0xC8, 0x0F, 0x70, 0x06, 0xE0,
  0xB7, 0x50, 0x2E, 0x0C, 0x80, 0xF7, 0x00, 0xDE, 0x04, 0x75, 0x02, 0xE0, 0xC8, 0x0F, 0x60, 0x04,
  0xE0, 0xD7, 0x60, 0x2E, 0x0C, 0x80, 0xF6, 0x00, 0xBE, 0x06, 0x76, 0x02, 0xE0, 0xC8, 0x0F, 0x50,
  0x03, 0xE0, 0xE7, 0x70, 0x2E, 0x0C, 0x80, 0xF5, 0x00, 0xAE, 0x08, 0x77, 0x02, 0xE0, 0xC8, 0x0F,
  0x40, 0x01, 0xF0, 0x17, 0x70, 0x2E, 0x0C, 0x80, 0xF4, 0x00, 0x8E, 0x09, 0x77, 0x10, 0x2E, 0x0C,
  0x80, 0xF3, 0x00, 0x10, 0xEE, 0x02, 0x77, 0x10, 0x2E, 0x0C, 0x80, 0xF3, 0x00, 0x7E, 0x0B, 0x77,
  0x20, 0x2E, 0x0C, 0x80, 0xF3, 0x00, 0xDE, 0x04, 0x77, 0x20, 0x2E, 0x0C, 0x80, 0xF2, 0x00, 0x5E,
  0x0D, 0x77, 0x30, 0x2E, 0x0C, 0x80, 0xF2, 0x00, 0xCE, 0x06, 0x77, 0x30, 0x2E, 0x0C, 0x80, 0xF1,
  0x00, 0x4E, 0x0E, 0x77, 0x40, 0x2E, 0x0C, 0x80, 0xF1, 0x00, 0xBE, 0x08, 0x77, 0x40, 0x2E, 0x0C,
  0x80, 0xF0, 0x00, 0x2F, 0x01, 0x77, 0x40, 0x2E, 0x0C, 0x80, 0xF0, 0x00, 0x9E, 0x09, 0x77, 0x50,
  0x28, 0x0C, 0x6F, 0x0E, 0x77, 0x72, 0x01, 0xF0, 0x27, 0x75, 0x02, 0x80, 0xC6, 0xF0, 0xE7, 0x77,
  0x20, 0x8E, 0x0B, 0x77, 0x60, 0x28, 0x0C, 0x6F, 0x0E, 0x77, 0x72, 0x0E, 0xE0, 0x47, 0x76, 0x02,
  0x80, 0xC6, 0xF0, 0xE7, 0x77, 0x10, 0x6E, 0x0D, 0x77, 0x70, 0x28, 0x0C, 0x6F, 0x0E, 0x77, 0x71,
  0x0D, 0xE0, 0x67, 0x77, 0x02, 0x80, 0xC6, 0xF0, 0xE7, 0x77, 0x05, 0xE0, 0xE7, 0x77, 0x10, 0x2E,
  0x0C, 0x80, 0xC0, 0x17, 0x77, 0x0C, 0xE0, 0x77, 0x77, 0x10, 0x2E, 0x0C, 0x80, 0xE4, 0x00, 0x3F,
  0x01, 0x77, 0x71, 0x02, 0xE0, 0xC8, 0x0E, 0x40, 0x0A, 0xE0, 0x97, 0x77, 0x20, 0x2E, 0x0C, 0x80,
  0xE3, 0x00, 0x2F, 0x02, 0x77, 0x72, 0x02, 0xE0, 0xC8, 0x0E, 0x30, 0x09, 0xE0, 0xB7, 0x77, 0x30,
  0x2E, 0x0C, 0x80, 0xE2, 0x00, 0x1F, 0x0D, 0x80, 0xA4, 0xB0, 0xCE, 0x0C, 0x80, 0xE2, 0x00, 0x88,
  0x0C, 0x3F, 0x0C, 0x80, 0xE2, 0x00, 0xE8, 0x0C, 0x3F, 0x0C, 0x80, 0xE1, 0x00, 0x68, 0x0C, 0x4F,
  0x0C, 0x80, 0xE1, 0x00, 0xD8, 0x0C, 0x4F, 0x0C, 0x80, 0xE0, 0x00, 0x58, 0x0C, 0x5F, 0x0C, 0x80,
  0xE0, 0x00, 0xCE, 0x0B, 0x80, 0xA7, 0x70, 0x8E, 0x0C, 0x80, 0xD7, 0x00, 0x3F, 0x02, 0x77, 0x76,
  0x02, 0xE0, 0xC8, 0x0D, 0x70, 0x0A, 0xE0, 0xB7, 0x77, 0x70, 0x2E, 0x0C, 0x80, 0xD6, 0x00, 0x2F,
  0x04, 0x77, 0x77, 0x02, 0xE0, 0xC8, 0x0D, 0x60, 0x09, 0xE0, 0xC7, 0x77, 0x71, 0x02, 0xE0, 0xC8,
  0x0D, 0x50, 0x01, 0x0E, 0xE0, 0x57, 0x77, 0x71, 0x02, 0xE0, 0xC8, 0x0D, 0x50, 0x07, 0xE0, 0xD7,
  0x77, 0x72, 0x02, 0xE0, 0xC8, 0x0D, 0x50, 0x0E, 0xE0, 0x77, 0x77, 0x72, 0x02, 0xE0, 0xC8, 0x0D,
  0x40, 0x06, 0xE0, 0xE0, 0x17, 0x77, 0x72, 0x02, 0xE0, 0xC8, 0x0D, 0x40, 0x0D, 0xE0, 0x87, 0x77,
  0x73, 0x02, 0xE0, 0xC8, 0x0D, 0x30, 0x04, 0xF0, 0x27, 0x77, 0x73, 0x02, 0xE0, 0xC8, 0x0D, 0x30,
  0x0B, 0xE0, 0xA7, 0x77, 0x74, 0x02, 0xE0, 0xC8, 0x0D, 0x20, 0x03, 0xF0, 0x37, 0x77, 0x74, 0x02,
  0xE0, 0xC8, 0x0D, 0x20, 0x0A, 0xE0, 0xB7, 0x77, 0x75, 0x02, 0xE0, 0xC8, 0x0D, 0x10, 0x01, 0xF0,
  0x47, 0x77, 0x75, 0x02, 0xE0, 0xC8, 0x0D, 0x10, 0x08, 0xE0, 0xD7, 0x77, 0x76, 0x02, 0xE0, 0xC8,
  0x0D, 0x00, 0x01, 0x0E, 0xE0, 0x67, 0x77, 0x76, 0x02, 0xE0, 0xC8, 0x0D, 0x00, 0x07, 0xE0, 0xE7,
  0x77, 0x77, 0x02, 0xE0, 0xC8, 0x0D, 0x00, 0x0D, 0xE0, 0x77, 0x77, 0x77, 0x02, 0xE0, 0xC8, 0x0C,
  0x70, 0x05, 0xE0, 0xE0, 0x17, 0x77, 0x77, 0x02, 0xE0, 0xC8, 0x0C, 0x70, 0x0C, 0xE0, 0x98, 0x0C,
  0x00, 0x02, 0xE0, 0xC8, 0x0C, 0x60, 0x04, 0xF0, 0x28, 0x0C, 0x00, 0x02, 0xE0, 0xC8, 0x0C, 0x60,
  0x0B, 0xE0, 0xA8, 0x0C, 0x10, 0x02, 0xE0, 0xC8, 0x0C, 0x50, 0x02, 0xF0, 0x38, 0x0C, 0x10, 0x02,
  0xE0, 0xD8, 0x0C, 0x23, 0x01, 0x20, 0x9E, 0x0C, 0x80, 0xC2, 0x00, 0x28, 0x0D, 0x1F, 0x81, 0x40,
  0x1F, 0x05, 0x80, 0xC2, 0x00, 0x28, 0x0D, 0x1F, 0x81, 0x40, 0x8E, 0x0D, 0x80, 0xC3, 0x00, 0x28,
  0x0D, 0x1F, 0x81, 0x40, 0xEE, 0x06, 0x80, 0xC3, 0x00, 0x28, 0x0D, 0x1F, 0x04, 0x06, 0xE0, 0xE8,
  0x0C, 0x40, 0x02, 0x80, 0xD1, 0xF0, 0x40, 0xDE, 0x08, 0x80, 0xC4, 0x00, 0x28, 0x0D, 0x1F, 0x04,
  // "Ç" (U+00C7)
  0x77, 0x77, 0x48, 0x51, 0x46, 0x89, 0xBB, 0x80, 0x1D, 0x85, 0xBB, 0x99, 0x75, 0x38, 0x0C, 0x50,
  0x82, 0x27, 0xAE, 0xFF, 0xE8, 0x2C, 0xA6, 0x27, 0x77, 0x75, 0x81, 0x38, 0xDF, 0xFF, 0xF8, 0x1D,
  0x94, 0x77, 0x77, 0x06, 0x0C, 0xFF, 0xFF, 0xE8, 0x1E, 0x93, 0x77, 0x72, 0x06, 0x0E, 0x80, 0xC3,
  0xF0, 0xB0, 0x47, 0x75, 0x05, 0x0D, 0x80, 0xC6, 0xF0, 0xC7, 0x73, 0x01, 0x0A, 0xFF, 0x98, 0x3E,
  0xCA, 0x87, 0x80, 0x15, 0x83, 0x78, 0x9B, 0xEF, 0xF0, 0x47, 0x72, 0x04, 0x0E, 0xFD, 0x82, 0xD9,
  0x52, 0x77, 0x18, 0x31, 0x47, 0xBE, 0xF9, 0x0D, 0x77, 0x20, 0x8F, 0xC8, 0x1E, 0x93, 0x77, 0x73,
  0x81, 0x49, 0xED, 0x06, 0x77, 0x10, 0xAF, 0xB0, 0xD0, 0x67, 0x77, 0x72, 0x04, 0x0A, 0xA0, 0xE7,
  0x71, 0x0B, 0xFA, 0x0E, 0x07, 0x77, 0x77, 0x68, 0x11, 0x86, 0x77, 0x0B, 0xFA, 0x0A, 0x01, 0x80,
  0xD7, 0x00, 0xBF, 0x90, 0xE0, 0x58, 0x0E, 0x00, 0x09, 0xF9, 0x0D, 0x03, 0x80, 0xE0, 0x00, 0x7F,
  0x90, 0xC0, 0x18, 0x0E, 0x00, 0x03, 0xF9, 0x0C, 0x01, 0x80, 0xE1, 0x00, 0xDF, 0x0D, 0x01, 0x80,
  0xE1, 0x00, 0x8F, 0x0E, 0x02, 0x80, 0xE1, 0x00, 0x2F, 0x90, 0x48, 0x0E, 0x20, 0x0B, 0xF0, 0x98,
  0x0E, 0x20, 0x04, 0xF0, 0xD8, 0x0E, 0x30, 0x0C, 0xF0, 0x48, 0x0E, 0x20, 0x03, 0xF0, 0xB8, 0x0E,
  0x30, 0x0A, 0xF0, 0x38, 0x0E, 0x20, 0x01, 0xF0, 0xA8, 0x0E, 0x30, 0x07, 0xF0, 0x48, 0x0E, 0x30,
  0x0D, 0xE0, 0xC8, 0x0E, 0x30, 0x02, 0xF0, 0x78, 0x0E, 0x30, 0x07, 0xF0, 0x18, 0x0E, 0x30, 0x0B,
  0xE0, 0xC8, 0x0E, 0x40, 0xF0, 0x78, 0x0E, 0x30, 0x03, 0xF0, 0x38, 0x0E, 0x30, 0x07, 0xF8, 0x0E,
  0x40, 0x09, 0xE0, 0xB8, 0x0E, 0x40, 0x0C, 0xE0, 0x98, 0x0E, 0x40, 0x0E, 0xE0, 0x68, 0x0E, 0x30,
  0x01, 0xF0, 0x48, 0x0E, 0x30, 0x03, 0xF0, 0x28, 0x0E, 0x30, 0x04, 0xF8, 0x0E, 0x40, 0x06, 0xE0,
  0xE8, 0x0E, 0x40, 0x07, 0xE0, 0xD8, 0x0E, 0x40, 0x07, 0xE0, 0xC8, 0x0E, 0x40, 0x08, 0xE0, 0xC8,
  0x0E, 0x40, 0x08, 0xE0, 0xC8, 0x0E, 0x40, 0x08, 0xE0, 0xB8, 0x0E, 0x40, 0x08, 0xE0, 0xC8, 0x0E,
  0x40, 0x07, 0xE0, 0xC8, 0x0E, 0x40, 0x07, 0xE0, 0xD8, 0x0E, 0x40, 0x06, 0xE0, 0xE8, 0x0E, 0x40,
  0x05, 0xF8, 0x0E, 0x40, 0x04, 0xF0, 0x18, 0x0E, 0x30, 0x02, 0xF0, 0x38, 0x0E, 0x40, 0xF0, 0x48,
  0x0E, 0x40, 0x0E, 0xE0, 0x78, 0x0E, 0x40, 0x0B, 0xE0, 0x98, 0x0E, 0x40, 0x09, 0xE0, 0xC8, 0x0E,
  0x40, 0x06, 0xF8, 0x0E, 0x40, 0x03, 0xF0, 0x38, 0x0E, 0x40, 0xF0, 0x88, 0x0E, 0x40, 0x0C, 0xE0,
  0xC8, 0x0E, 0x40, 0x07, 0xF0, 0x18, 0x0E, 0x30, 0x03, 0xF0, 0x68, 0x0E, 0x40, 0x0E, 0xE0, 0xC8,
  0x0E, 0x40, 0x09, 0xF0, 0x38, 0x0E, 0x30, 0x04, 0xF0, 0x98, 0x0E, 0x40, 0x0D, 0xF0, 0x18, 0x0E,
  0x30, 0x07, 0xF0, 0x98, 0x0E, 0x30, 0x01, 0x0E, 0xF0, 0x28, 0x0E, 0x30, 0x08, 0xF0, 0xB8, 0x0E,
  0x30, 0x01, 0xF9, 0x05, 0x80, 0xE3, 0x00, 0x8F, 0x0E, 0x02, 0x80, 0xE3, 0x00, 0xDF, 0x0C, 0x80,
  0xE3, 0x00, 0x5F, 0x90, 0xB8, 0x0E, 0x30, 0x0A, 0xF9, 0x0A, 0x80, 0xE2, 0x00, 0x10, 0xDF, 0x90,
  0xA8, 0x0E, 0x20, 0x02, 0x0E, 0xF9, 0x0C, 0x01, 0x80, 0xE1, 0x00, 0x5F, 0xA0, 0xD0, 0x48, 0x0E,
  0x10, 0x06, 0xFB, 0x09, 0x01, 0x80, 0xE0, 0x00, 0x6F, 0xB0, 0xE0, 0x77, 0x77, 0x77, 0x01, 0x03,
  0x77, 0x10, 0x5F, 0xC8, 0x1E, 0x82, 0x77, 0x77, 0x18, 0x33, 0x7C, 0xF9, 0x77, 0x20, 0x30, 0xDF,
  0xD8, 0x1C, 0x73, 0x77, 0x78, 0x22, 0x58, 0xCD, 0x09, 0x77, 0x30, 0x10, 0xBF, 0xF8, 0xA3, 0xEB,
  0x86, 0x43, 0x11, 0x10, 0x11, 0x12, 0x34, 0x67, 0xAC, 0xEF, 0xA0, 0x97, 0x75, 0x06, 0x0E, 0x80,
  0xC6, 0xF0, 0x97, 0x76, 0x01, 0x09, 0x80, 0xC5, 0xF0, 0x97, 0x77, 0x10, 0x20, 0x98, 0x0C, 0x2F,
  0x0E, 0x06, 0x77, 0x73, 0x81, 0x17, 0xDF, 0xFF, 0xFC, 0x81, 0xE9, 0x57, 0x77, 0x71, 0x81, 0x27,
  0xBF, 0xFF, 0xC8, 0x2E, 0xA7, 0x38, 0x0C, 0x00, 0x84, 0x36, 0x9B, 0xDE, 0xFC, 0x85, 0xEC, 0xB9,
  0x64, 0x18, 0x0D, 0x10, 0x04, 0xC0, 0xB0, 0x20, 0xF1, 0x80, 0xE2, 0x00, 0xBC, 0x03, 0x80, 0xE5,
  0x00, 0x4C, 0x0B, 0x80, 0xE6, 0x00, 0xBC, 0x03, 0x80, 0xE5, 0x00, 0x4C, 0x0B, 0x80, 0xE6, 0x00,
  0xBC, 0x03, 0x80, 0xE5, 0x00, 0x4D, 0x82, 0xC9, 0x61, 0x80, 0xE2, 0x00, 0xBF, 0xA0, 0xB0, 0x48,
  0x0D, 0x70, 0x04, 0xFD, 0x0B, 0x01, 0x80, 0xD5, 0x08, 0x43, 0x67, 0x9C, 0xEF, 0x90, 0xE0, 0x38,
  0x0E, 0x20, 0x81, 0x38, 0xEE, 0x0E, 0x02, 0x80, 0xE4, 0x00, 0x8E, 0x0A, 0x80, 0xE5, 0x00, 0x6E,
  0x02, 0x80, 0xE5, 0x00, 0xAD, 0x06, 0x80, 0xE5, 0x00, 0x4D, 0x09, 0x80, 0xE5, 0x00, 0x1D, 0x0A,
  0x80, 0xE6, 0x0D, 0x0A, 0x80, 0xE5, 0x00, 0x2D, 0x09, 0x80, 0xE5, 0x00, 0x6D, 0x07, 0x80, 0xE5,
  0x00, 0xDD, 0x03, 0x80, 0xE4, 0x00, 0xAD, 0x0D, 0x80, 0xE3, 0x00, 0x40, 0xCE, 0x05, 0x80, 0xC6,
  0x08, 0x33, 0x63, 0x11, 0x38, 0x31, 0x24, 0x7C, 0xF0, 0xB8, 0x0C, 0x70, 0x05, 0xFF, 0xC0, 0xC0,
  0x18, 0x0C, 0x70, 0x05, 0xFF, 0xB0, 0xB8, 0x0D, 0x10, 0x05, 0xFF, 0x90, 0xD0, 0x58, 0x0D, 0x20,
  0x05, 0xFE, 0x0B, 0x05, 0x80, 0xD5, 0x08, 0x92, 0x47, 0x9A, 0xBB, 0xBB, 0xA9, 0x74, 0x77, 0x75,
  // "È" (U+00C8)
  0x72, 0x04, 0x80, 0x3B, 0x0A, 0x80, 0xC2, 0x00, 0x3F, 0x90, 0x68, 0x0C, 0x20, 0x07, 0xF0, 0xE0,
  0x18, 0x0C, 0x20, 0x0B, 0xF0, 0xB8, 0x0C, 0x20, 0x01, 0x0D, 0xF0, 0x68, 0x0C, 0x20, 0x02, 0x0E,
  0xE0, 0xE0, 0x28, 0x0C, 0x20, 0x03, 0xF0, 0xC8, 0x0C, 0x30, 0x05, 0xF0, 0x98, 0x0C, 0x30, 0x06,
  0xF0, 0x58, 0x0C, 0x30, 0x07, 0xE0, 0xE0, 0x28, 0x0C, 0x30, 0x08, 0xE0, 0xD0, 0x18, 0x0C, 0x30,
  0x08, 0xE0, 0xB8, 0x0C, 0x40, 0x08, 0xE0, 0x88, 0x0C, 0x40, 0x09, 0xE0, 0x58, 0x0C, 0x40, 0x08,
  0xE0, 0x38, 0x0C, 0x40, 0x07, 0xD0, 0xE0, 0x28, 0x0C, 0x40, 0x06, 0xD0, 0xD0, 0x18, 0x0C, 0x40,
  0x05, 0x0E, 0xC0, 0xD0, 0x18, 0x0C, 0x40, 0x03, 0x0E, 0xC0, 0xB8, 0x0C, 0x50, 0x84, 0x15, 0x55,
  0x54, 0x80, 0xE8, 0x30, 0x80, 0xD3, 0xB8, 0x0B, 0xD6, 0xF8, 0x0C, 0x47, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0x80, 0xD0, 0xF0, 0xB2, 0x80, 0xD0, 0xF0, 0xB2,
  0x80, 0xD0, 0xF0, 0xB2, 0x80, 0xD0, 0xF0, 0xB2, 0x80, 0xD0, 0xF0, 0xB2, 0x80, 0xD0, 0xF0, 0xB2,
  0xE0, 0xE8, 0x0C, 0x21, 0x2E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x38, 0x0C, 0xA6, 0xF0,
  // "É" (U+00C9)
  0x77, 0x77, 0x50, 0x68, 0x03, 0xB0, 0xA8, 0x0C, 0x10, 0x01, 0x0E, 0xF0, 0x98, 0x0C, 0x10, 0x0A,
  0xF0, 0xD8, 0x0C, 0x10, 0x05, 0xF0, 0xE0, 0x28, 0x0C, 0x00, 0x01, 0x0E, 0xF0, 0x58, 0x0C, 0x10,
  0x0B, 0xF0, 0x78, 0x0C, 0x10, 0x07, 0xF0, 0x98, 0x0C, 0x10, 0x04, 0xF0, 0xB8, 0x0C, 0x10, 0x01,
  0x0E, 0xE0, 0xC8, 0x0C, 0x20, 0x0B, 0xE0, 0xD0, 0x18, 0x0C, 0x10, 0x09, 0xE0, 0xD0, 0x18, 0x0C,
  0x10, 0x05, 0xE0, 0xD0, 0x28, 0x0C, 0x10, 0x03, 0xE0, 0xD0, 0x28, 0x0C, 0x10, 0x01, 0x0E, 0xD0,
  0xD0, 0x28, 0x0C, 0x20, 0x0C, 0xD0, 0xD0, 0x28, 0x0C, 0x20, 0x0B, 0xD0, 0xD0, 0x18, 0x0C, 0x20,
  0x09, 0xD0, 0xC0, 0x18, 0x0C, 0x20, 0x08, 0xD0, 0xB8, 0x0C, 0x30, 0x04, 0xD0, 0x98, 0x0C, 0x40,
  0x84, 0x15, 0x55, 0x54, 0x80, 0xE9, 0x20, 0x80, 0xD3, 0xB8, 0x0B, 0xD6, 0xF8, 0x0C, 0x47, 0xE0,
  0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0,
  0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0,
  0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0,
  0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0,
  0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0,
  0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0,
  0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0,
  0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0x80, 0xD0, 0xF0, 0xB2, 0x80,
  0xD0, 0xF0, 0xB2, 0x80, 0xD0, 0xF0, 0xB2, 0x80, 0xD0, 0xF0, 0xB2, 0x80, 0xD0, 0xF0, 0xB2, 0x80,
  0xD0, 0xF0, 0xB2, 0xE0, 0xE8, 0x0C, 0x21, 0x2E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E,
  0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E,
  0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E,
  0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E,
  0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E,
  0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E,
  0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E,
  0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E,
  0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E,
  0x0E, 0x80, 0xC4, 0x38, 0x0C, 0xA6, 0xF0,
  // "Ê" (U+00CA)
  0x77, 0x70, 0x48, 0x02, 0x70, 0x28, 0x0C, 0x20, 0x01, 0x0E, 0xE0, 0xC8, 0x0C, 0x20, 0x0B, 0xF9,
  0x07, 0x80, 0xC0, 0x00, 0x6F, 0xB0, 0x27, 0x77, 0x76, 0x02, 0x0E, 0xFB, 0x0C, 0x77, 0x77, 0x60,
  0xDF, 0xD0, 0x97, 0x77, 0x74, 0x09, 0xE0, 0xC0, 0xEE, 0x05, 0x77, 0x77, 0x20, 0x6E, 0x81, 0xD1,
  0x4F, 0x03, 0x77, 0x77, 0x03, 0xE0, 0xE0, 0x22, 0x05, 0xE0, 0xE0, 0x17, 0x77, 0x50, 0x10, 0xED,
  0x0E, 0x03, 0x40, 0x7E, 0x0C, 0x77, 0x75, 0x0C, 0xE0, 0x46, 0x08, 0xE0, 0xA7, 0x77, 0x30, 0xAE,
  0x05, 0x71, 0x09, 0xE0, 0x77, 0x77, 0x10, 0x8E, 0x06, 0x73, 0x0A, 0xE0, 0x47, 0x76, 0x06, 0xE0,
  0x67, 0x50, 0xBD, 0x0E, 0x02, 0x77, 0x40, 0x4E, 0x06, 0x77, 0x0A, 0xD0, 0xD0, 0x17, 0x72, 0x03,
  0x0E, 0xD0, 0x67, 0x72, 0x0A, 0xD0, 0xC7, 0x71, 0x02, 0x0E, 0xD0, 0x57, 0x74, 0x0A, 0xD0, 0xB7,
  0x60, 0x10, 0xDC, 0x0E, 0x04, 0x77, 0x60, 0x8D, 0x0A, 0x75, 0x0A, 0xC0, 0xD0, 0x27, 0x77, 0x10,
  0x6D, 0x07, 0x74, 0x84, 0x45, 0x55, 0x51, 0x77, 0x73, 0x84, 0x35, 0x55, 0x53, 0x80, 0xDF, 0x00,
  0x80, 0xD3, 0xB8, 0x0B, 0xD6, 0xF8, 0x0C, 0x47, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40,
  0xE0, 0xE8, 0x0C, 0x40, 0x80, 0xD0, 0xF0, 0xB2, 0x80, 0xD0, 0xF0, 0xB2, 0x80, 0xD0, 0xF0, 0xB2,
  0x80, 0xD0, 0xF0, 0xB2, 0x80, 0xD0, 0xF0, 0xB2, 0x80, 0xD0, 0xF0, 0xB2, 0xE0, 0xE8, 0x0C, 0x21,
  0x2E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4,
  0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x38, 0x0C, 0xA6, 0xF0,
  // "Ë" (U+00CB)
  0x75, 0x81, 0x23, 0x27, 0x76, 0x00, 0x37, 0x76, 0x02, 0x0C, 0xB0, 0xD0, 0x47, 0x72, 0x09, 0xC0,
  0x87, 0x74, 0x0C, 0xE0, 0x27, 0x70, 0x8E, 0x07, 0x77, 0x20, 0x3F, 0x09, 0x77, 0x0E, 0xE0, 0xE7,
  0x72, 0x06, 0xF0, 0xC7, 0x60, 0x2F, 0x90, 0x17, 0x71, 0x07, 0xF0, 0xD7, 0x60, 0x2F, 0x90, 0x27,
  0x71, 0x07, 0xF0, 0xC7, 0x60, 0x2F, 0x90, 0x27, 0x71, 0x04, 0xF0, 0x97, 0x70, 0xEE, 0x0E, 0x77,
  0x30, 0xDE, 0x04, 0x77, 0x09, 0xE0, 0x97, 0x73, 0x03, 0x0E, 0xC0, 0x77, 0x71, 0x01, 0x0C, 0xC0,
  0xB7, 0x75, 0x83, 0x15, 0x75, 0x17, 0x74, 0x82, 0x46, 0x63, 0x80, 0x98, 0xF1, 0x08, 0x0D, 0x3B,
  0x80, 0xBD, 0x6F, 0x80, 0xC4, 0x7E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80,
  0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80,
  0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80,
  0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80,
  0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80,
  0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80,
  0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80,
  0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80, 0xC4, 0x0E, 0x0E, 0x80,
  0xC4, 0x08, 0x0D, 0x0F, 0x0B, 0x28, 0x0D, 0x0F, 0x0B, 0x28, 0x0D, 0x0F, 0x0B, 0x28, 0x0D, 0x0F,
  0x0B, 0x28, 0x0D, 0x0F, 0x0B, 0x28, 0x0D, 0x0F, 0x0B, 0x2E, 0x0E, 0x80, 0xC2, 0x12, 0xE0, 0xE8,
  0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8,
  0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8,
  0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8,
  0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8,
  0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8,
  0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8,
  0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8,
  0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8,
  0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x40, 0xE0, 0xE8, 0x0C, 0x43, 0x80, 0xCA, 0x6F,
  // "Ì" (U+00CC)
  0x05, 0x80, 0x3B, 0x08, 0x77, 0x60, 0x4F, 0x90, 0x47, 0x76, 0x09, 0xF0, 0xD7, 0x77, 0x0C, 0xF0,
  0x97, 0x76, 0x01, 0x0E, 0xF0, 0x47, 0x76, 0x03, 0xF0, 0xE0, 0x17, 0x76, 0x05, 0xF0, 0xB7, 0x77,
  0x06, 0xF0, 0x77, 0x77, 0x07, 0xF0, 0x47, 0x77, 0x09, 0xE0, 0xE0, 0x17, 0x77, 0x0A, 0xE0, 0xC7,
  0x77, 0x10, 0xAE, 0x09, 0x77, 0x71, 0x0A, 0xE0, 0x67, 0x77, 0x10, 0xAE, 0x04, 0x77, 0x71, 0x0A,
  0xD0, 0xE0, 0x27, 0x77, 0x10, 0x9D, 0x0D, 0x01, 0x77, 0x71, 0x08, 0xD0, 0xC0, 0x17, 0x77, 0x10,
  0x6D, 0x0C, 0x77, 0x72, 0x04, 0x0E, 0xC0, 0x97, 0x77, 0x28, 0x42, 0x55, 0x55, 0x38, 0x0B, 0xD5,
  0x08, 0x0A, 0x5B, 0x02, 0x3F, 0xFF, 0xC0, 0x33, 0xFF, 0xFC, 0x03, 0x3F, 0xFF, 0xC0, 0x33, 0x0B,
  0x0D, 0xFF, 0xF8, 0x1E, 0xB1, 0x68, 0x32, 0x57, 0xAC, 0xFA, 0x84, 0xDA, 0x85, 0x31, 0x77, 0x10,
  0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70,
  0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70,
  0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70,
  0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70,
  0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70,
  0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70,
  0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70,
  0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70,
  0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70,
  0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70,
  0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70,
  0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70,
  0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70,
  0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70,
  0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70,
  0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70,
  0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70,
  0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x70,
  0xDE, 0x01, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x38, 0x31, 0x46, 0x8E, 0xE8, 0x29, 0x64, 0x27, 0x28,
  0x36, 0x8A, 0xCE, 0xFF, 0xA8, 0x3D, 0xA8, 0x61, 0x3F, 0xFF, 0xC0, 0x33, 0xFF, 0xFC, 0x03, 0x3F,
  0xFF, 0xC0, 0x33, 0xFF, 0xFC, 0x03,
  // "Í" (U+00CD)
  0x77, 0x70, 0x88, 0x03, 0xB0, 0x77, 0x76, 0x04, 0xF9, 0x06, 0x77, 0x60, 0xDF, 0x0A, 0x77, 0x60,
  0x9F, 0x0D, 0x77, 0x60, 0x4F, 0x0E, 0x02, 0x77, 0x50, 0x10, 0xEF, 0x04, 0x77, 0x60, 0xBF, 0x06,
  0x77, 0x60, 0x7F, 0x07, 0x77, 0x60, 0x4F, 0x09, 0x77, 0x60, 0x10, 0xEE, 0x0A, 0x77, 0x70, 0xCE,
  0x0B, 0x77, 0x70, 0x9E, 0x0B, 0x77, 0x70, 0x6E, 0x0B, 0x77, 0x70, 0x4E, 0x0B, 0x77, 0x70, 0x20,
  0xED, 0x0B, 0x77, 0x70, 0x10, 0xDD, 0x0B, 0x77, 0x71, 0x0C, 0xD0, 0x97, 0x77, 0x10, 0xBD, 0x08,
  0x77, 0x71, 0x07, 0xD0, 0x67, 0x77, 0x28, 0x43, 0x55, 0x55, 0x38, 0x0B, 0xF5, 0x08, 0x0A, 0x5B,
  0x02, 0x4F, 0xFF, 0xC0, 0x34, 0xFF, 0xFC, 0x03, 0x4F, 0xFF, 0xC0, 0x34, 0x0B, 0x0D, 0xFF, 0xF8,
  0x1E, 0xB1, 0x78, 0x32, 0x57, 0xAC, 0xFA, 0x84, 0xDA, 0x85, 0x31, 0x77, 0x20, 0xDE, 0x01, 0x77,
  0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE,
  0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77,
  0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0,
  0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71,
  0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01,
  0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10,
  0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17,
  0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D,
  0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77,
  0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE,
  0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77,
  0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0,
  0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71,
  0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01,
  0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10,
  0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17,
  0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D,
  0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77,
  0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE,
  0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x77,
  0x10, 0xDE, 0x01, 0x77, 0x71, 0x0D, 0xE0, 0x17, 0x74, 0x83, 0x14, 0x68, 0xEE, 0x82, 0x96, 0x42,
  0x73, 0x83, 0x68, 0xAC, 0xEF, 0xFA, 0x83, 0xDA, 0x86, 0x14, 0xFF, 0xFC, 0x03, 0x4F, 0xFF, 0xC0,
  0x34, 0xFF, 0xFC, 0x03, 0x4F, 0xFF, 0xC0, 0x34,
  // "Î" (U+00CE)
  0x77, 0x06, 0x80, 0x27, 0x77, 0x77, 0x04, 0xF0, 0x87, 0x77, 0x50, 0x10, 0xDF, 0x90, 0x37, 0x77,
  0x40, 0xAF, 0xA0, 0xD7, 0x77, 0x30, 0x6F, 0xC0, 0x97, 0x77, 0x10, 0x20, 0xEF, 0xD0, 0x57, 0x77,
  0x0D, 0xE0, 0xBE, 0x0E, 0x02, 0x77, 0x50, 0xAE, 0x81, 0xA0, 0x7E, 0x0D, 0x01, 0x77, 0x30, 0x7E,
  0x0B, 0x30, 0x9E, 0x0B, 0x77, 0x20, 0x4E, 0x0D, 0x01, 0x40, 0xBE, 0x09, 0x77, 0x02, 0x0E, 0xD0,
  0xD0, 0x16, 0x0C, 0xE0, 0x67, 0x50, 0x10, 0xDD, 0x0E, 0x02, 0x70, 0x10, 0xCE, 0x03, 0x74, 0x0B,
  0xD0, 0xE0, 0x37, 0x20, 0x10, 0xDD, 0x0E, 0x01, 0x72, 0x0A, 0xD0, 0xE0, 0x37, 0x40, 0x10, 0xDD,
  0x0C, 0x71, 0x08, 0xD0, 0xE0, 0x37, 0x60, 0x10, 0xDD, 0x0B, 0x60, 0x6D, 0x0E, 0x03, 0x77, 0x10,
  0x10, 0xDD, 0x09, 0x40, 0x4D, 0x0E, 0x03, 0x77, 0x30, 0x10, 0xCD, 0x08, 0x20, 0x30, 0xEC, 0x0D,
  0x02, 0x77, 0x60, 0xBD, 0x81, 0x70, 0xEC, 0x0B, 0x01, 0x77, 0x71, 0x09, 0xD0, 0x48, 0x01, 0x57,
  0x77, 0x48, 0x44, 0x55, 0x55, 0x28, 0x0C, 0xC1, 0x08, 0x0A, 0x5B, 0x02, 0x73, 0xFF, 0xFC, 0x03,
  0x73, 0xFF, 0xFC, 0x03, 0x73, 0xFF, 0xFC, 0x03, 0x73, 0x0B, 0x0D, 0xFF, 0xF8, 0x1E, 0xB1, 0x76,
  0x83, 0x25, 0x7A, 0xCF, 0xA8, 0x4D, 0xA8, 0x53, 0x17, 0x77, 0x10, 0xDE, 0x01, 0x77, 0x77, 0x0D,
  0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77,
  0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE,
  0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77,
  0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0,
  0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77,
  0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01,
  0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70,
  0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17,
  0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D,
  0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77,
  0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE,
  0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77,
  0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0,
  0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77,
  0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01,
  0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70,
  0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17,
  0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D,
  0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77,
  0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE, 0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x70, 0xDE,
  0x01, 0x77, 0x77, 0x0D, 0xE0, 0x17, 0x77, 0x38, 0x31, 0x46, 0x8E, 0xE8, 0x29, 0x64, 0x27, 0x72,
  0x83, 0x68, 0xAC, 0xEF, 0xFA, 0x83, 0xDA, 0x86, 0x17, 0x3F, 0xFF, 0xC0, 0x37, 0x3F, 0xFF, 0xC0,
  0x37, 0x3F, 0xFF, 0xC0, 0x37, 0x3F, 0xFF, 0xC0, 0x35,
  // "Ï" (U+00CF)
  0x38, 0x12, 0x31, 0x77, 0x58, 0x11, 0x32, 0x40, 0x40, 0xDB, 0x0C, 0x02, 0x77, 0x10, 0x10, 0xBB,
  0x83, 0xE5, 0x01, 0xED, 0x0D, 0x77, 0x10, 0xBE, 0x03, 0x07, 0xF0, 0x57, 0x60, 0x2F, 0x00, 0xAF,
  0x08, 0x76, 0x05, 0xF0, 0xD0, 0xBF, 0x09, 0x76, 0x06, 0xF0, 0xE0, 0xAF, 0x09, 0x76, 0x05, 0xF0,
  0xE0, 0x8F, 0x06, 0x76, 0x03, 0xF0, 0xB0, 0x2E, 0x0E, 0x01, 0x77, 0x0D, 0xE8, 0x15, 0x06, 0xC0,
  0xE0, 0x47, 0x71, 0x03, 0x0E, 0xC0, 0x83, 0x83, 0x15, 0x75, 0x17, 0x74, 0x82, 0x57, 0x52, 0x80,
  0xDE, 0x50, 0x80, 0xA5, 0xB0, 0x25, 0xFF, 0xFC, 0x03, 0x5F, 0xFF, 0xC0, 0x35, 0xFF, 0xFC, 0x03,
  0x50, 0xB0, 0xDF, 0xFF, 0x81, 0xEB, 0x17, 0x18, 0x32, 0x57, 0xAC, 0xFA, 0x84, 0xDA, 0x85, 0x31,
  0x77, 0x30, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D,
  0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77,
  0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE,
  0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77,
  0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0,
  0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72,
  0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01,
  0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20,
  0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17,
  0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D,
  0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77,
  0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE,
  0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77,
  0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0,
  0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72,
  0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01,
  0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20,
  0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17,
  0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D,
  0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77,
  0x72, 0x0D, 0xE0, 0x17, 0x77, 0x20, 0xDE, 0x01, 0x77, 0x72, 0x0D, 0xE0, 0x17, 0x75, 0x83, 0x14,
  0x68, 0xEE, 0x82, 0x96, 0x42, 0x74, 0x83, 0x68, 0xAC, 0xEF, 0xFA, 0x83, 0xDA, 0x86, 0x15, 0xFF,
  0xFC, 0x03, 0x5F, 0xFF, 0xC0, 0x35, 0xFF, 0xFC, 0x03, 0x5F, 0xFF, 0xC0, 0x32,
  // "Ð" (U+00D0)
  0x73, 0x05, 0x80, 0xA3, 0xB8, 0x00, 0x98, 0x37, 0x75, 0x31, 0x80, 0xC7, 0x00, 0x7F, 0xFF, 0xFD,
  0x82, 0xCA, 0x63, 0x80, 0xC2, 0x00, 0x78, 0x0C, 0x1F, 0x82, 0xEA, 0x61, 0x77, 0x77, 0x60, 0x78,
  0x0C, 0x5F, 0x0B, 0x05, 0x77, 0x77, 0x40, 0x78, 0x0C, 0x7F, 0x0D, 0x07, 0x77, 0x77, 0x20, 0x78,
  0x0D, 0x1F, 0x0E, 0x07, 0x77, 0x77, 0x07, 0xE0, 0xA8, 0x09, 0x25, 0x87, 0x67, 0x77, 0x89, 0xBC,
  0xEF, 0xFB, 0x0D, 0x04, 0x77, 0x75, 0x07, 0xE0, 0x67, 0x77, 0x28, 0x31, 0x46, 0xAE, 0xFF, 0x09,
  0x77, 0x74, 0x07, 0xE0, 0x67, 0x77, 0x78, 0x12, 0x7C, 0xFD, 0x0D, 0x02, 0x77, 0x72, 0x07, 0xE0,
  0x67, 0x77, 0x73, 0x81, 0x28, 0xEF, 0xB0, 0xE0, 0x47, 0x77, 0x10, 0x7E, 0x06, 0x77, 0x77, 0x60,
  0x70, 0xEF, 0xB0, 0x57, 0x77, 0x07, 0xE0, 0x67, 0x77, 0x77, 0x01, 0x08, 0xFB, 0x05, 0x77, 0x60,
  0x7E, 0x06, 0x80, 0xC1, 0x00, 0x30, 0xDF, 0xA0, 0x47, 0x75, 0x07, 0xE0, 0x68, 0x0C, 0x30, 0x0A,
  0xF9, 0x0E, 0x03, 0x77, 0x40, 0x7E, 0x06, 0x80, 0xC4, 0x00, 0x7F, 0x90, 0xD0, 0x17, 0x73, 0x07,
  0xE0, 0x68, 0x0C, 0x50, 0x07, 0xF9, 0x0A, 0x77, 0x30, 0x7E, 0x06, 0x80, 0xC6, 0x00, 0x7F, 0x90,
  0x57, 0x72, 0x07, 0xE0, 0x68, 0x0C, 0x70, 0x0A, 0xF0, 0xD7, 0x72, 0x07, 0xE0, 0x68, 0x0D, 0x00,
  0x0D, 0xF0, 0x87, 0x71, 0x07, 0xE0, 0x68, 0x0D, 0x00, 0x03, 0xF0, 0xE0, 0x17, 0x70, 0x7E, 0x06,
  0x80, 0xD1, 0x00, 0x8F, 0x08, 0x77, 0x07, 0xE0, 0x68, 0x0D, 0x10, 0x01, 0x0E, 0xE0, 0xE7, 0x70,
  0x7E, 0x06, 0x80, 0xD2, 0x00, 0x7F, 0x06, 0x76, 0x07, 0xE0, 0x68, 0x0D, 0x30, 0x0E, 0xE0, 0xC7,
  0x60, 0x7E, 0x06, 0x80, 0xD3, 0x00, 0x8F, 0x02, 0x75, 0x07, 0xE0, 0x68, 0x0D, 0x30, 0x02, 0xF0,
  0x77, 0x50, 0x7E, 0x06, 0x80, 0xD4, 0x00, 0xCE, 0x0B, 0x75, 0x07, 0xE0, 0x68, 0x0D, 0x40, 0x07,
  0xF7, 0x50, 0x7E, 0x06, 0x80, 0xD4, 0x00, 0x2F, 0x04, 0x74, 0x07, 0xE0, 0x68, 0x0D, 0x50, 0x0E,
  0xE0, 0x77, 0x40, 0x7E, 0x06, 0x80, 0xD5, 0x00, 0xAE, 0x0B, 0x74, 0x07, 0xE0, 0x68, 0x0D, 0x50,
  0x07, 0xE0, 0xD7, 0x40, 0x7E, 0x06, 0x80, 0xD5, 0x00, 0x4F, 0x74, 0x07, 0xE0, 0x68, 0x0D, 0x50,
  0x01, 0xF0, 0x37, 0x30, 0x7E, 0x06, 0x80, 0xD6, 0x00, 0xEE, 0x05, 0x73, 0x07, 0xE0, 0x68, 0x0D,
  0x60, 0x0C, 0xE0, 0x67, 0x30, 0x7E, 0x06, 0x80, 0xD6, 0x00, 0xBE, 0x08, 0x73, 0x07, 0xE0, 0x68,
  0x0D, 0x60, 0x09, 0xE0, 0x97, 0x30, 0x7E, 0x06, 0x80, 0xD6, 0x00, 0x8E, 0x0A, 0x73, 0x07, 0xE0,
  0x68, 0x0D, 0x60, 0x07, 0xE0, 0xA0, 0x28, 0x05, 0x90, 0xCE, 0x0C, 0x80, 0xA2, 0x90, 0x47, 0x77,
  0x60, 0x7E, 0x0B, 0x03, 0x80, 0xC3, 0xF0, 0x77, 0x77, 0x60, 0x7E, 0x0B, 0x03, 0x80, 0xC3, 0xF0,
  0x77, 0x77, 0x60, 0x6E, 0x0B, 0x03, 0x80, 0xC3, 0xF0, 0x77, 0x77, 0x60, 0x7E, 0x0B, 0x03, 0x80,
  0xC3, 0xF0, 0x77, 0x77, 0x60, 0x7E, 0x0B, 0x03, 0x80, 0xC3, 0xF0, 0x77, 0x77, 0x60, 0x7E, 0x0A,
  0x02, 0x80, 0x59, 0x0C, 0xE0, 0xC8, 0x0A, 0x29, 0x04, 0x77, 0x76, 0x08, 0xE0, 0x97, 0x30, 0x7E,
  0x06, 0x80, 0xD6, 0x00, 0x9E, 0x09, 0x73, 0x07, 0xE0, 0x68, 0x0D, 0x60, 0x0A, 0xE0, 0x77, 0x30,
  0x7E, 0x06, 0x80, 0xD6, 0x00, 0xCE, 0x06, 0x73, 0x07, 0xE0, 0x68, 0x0D, 0x60, 0x0E, 0xE0, 0x47,
  0x30, 0x7E, 0x06, 0x80, 0xD5, 0x00, 0x1F, 0x02, 0x73, 0x07, 0xE0, 0x68, 0x0D, 0x50, 0x03, 0xF7,
  0x40, 0x7E, 0x06, 0x80, 0xD5, 0x00, 0x6E, 0x0D, 0x74, 0x07, 0xE0, 0x68, 0x0D, 0x50, 0x09, 0xE0,
  0xA7, 0x40, 0x7E, 0x06, 0x80, 0xD5, 0x00, 0xDE, 0x07, 0x74, 0x07, 0xE0, 0x68, 0x0D, 0x40, 0x01,
  0xF0, 0x47, 0x40, 0x7E, 0x06, 0x80, 0xD4, 0x00, 0x5F, 0x75, 0x07, 0xE0, 0x68, 0x0D, 0x40, 0x0A,
  0xE0, 0xB7, 0x50, 0x7E, 0x06, 0x80, 0xD3, 0x00, 0x1F, 0x07, 0x75, 0x07, 0xE0, 0x68, 0x0D, 0x30,
  0x06, 0xF0, 0x27, 0x50, 0x7E, 0x06, 0x80, 0xD3, 0x00, 0xCE, 0x0C, 0x76, 0x07, 0xE0, 0x68, 0x0D,
  0x20, 0x04, 0xF0, 0x77, 0x60, 0x7E, 0x06, 0x80, 0xD2, 0x00, 0xBF, 0x01, 0x76, 0x07, 0xE0, 0x68,
  0x0D, 0x10, 0x04, 0xF0, 0x97, 0x70, 0x7E, 0x06, 0x80, 0xD1, 0x00, 0xDF, 0x02, 0x77, 0x07, 0xE0,
  0x68, 0x0D, 0x00, 0x08, 0xF0, 0xA7, 0x71, 0x07, 0xE0, 0x68, 0x0C, 0x70, 0x04, 0xF9, 0x02, 0x77,
  0x10, 0x7E, 0x06, 0x80, 0xC6, 0x00, 0x20, 0xEF, 0x07, 0x77, 0x20, 0x7E, 0x06, 0x80, 0xC5, 0x00,
  0x10, 0xDF, 0x0D, 0x77, 0x30, 0x7E, 0x06, 0x80, 0xC4, 0x00, 0x10, 0xCF, 0x90, 0x37, 0x73, 0x07,
  0xE0, 0x68, 0x0C, 0x30, 0x01, 0x0D, 0xF9, 0x06, 0x77, 0x40, 0x7E, 0x06, 0x80, 0xC2, 0x00, 0x30,
  0xEF, 0x90, 0x97, 0x75, 0x07, 0xE0, 0x68, 0x0C, 0x10, 0x07, 0xFA, 0x0B, 0x77, 0x60, 0x7E, 0x06,
  0x77, 0x77, 0x70, 0x30, 0xCF, 0xA0, 0xB7, 0x77, 0x07, 0xE0, 0x67, 0x77, 0x75, 0x02, 0x0A, 0xFB,
  0x0B, 0x77, 0x71, 0x07, 0xE0, 0x67, 0x77, 0x73, 0x04, 0x0B, 0xFC, 0x09, 0x77, 0x72, 0x07, 0xE0,
  0x67, 0x77, 0x78, 0x13, 0x8D, 0xFD, 0x06, 0x77, 0x73, 0x07, 0xE0, 0x67, 0x77, 0x38, 0x23, 0x6A,
  0xEF, 0xE0, 0xC0, 0x27, 0x77, 0x40, 0x7E, 0x07, 0x80, 0x93, 0x18, 0x62, 0x34, 0x57, 0x9A, 0xDF,
  0xFA, 0x0E, 0x07, 0x77, 0x76, 0x07, 0x80, 0xD1, 0xF0, 0x90, 0x17, 0x77, 0x70, 0x78, 0x0C, 0x7F,
  0x09, 0x02, 0x77, 0x77, 0x20, 0x78, 0x0C, 0x4F, 0x81, 0xC7, 0x17, 0x77, 0x74, 0x07, 0x80, 0xC1,
  0xF8, 0x1C, 0x72, 0x77, 0x77, 0x70, 0x7F, 0xFF, 0xFC, 0x83, 0xEB, 0x85, 0x18, 0x0C, 0x20, 0x07,
  0xFF, 0xFA, 0x87, 0xDD, 0xCB, 0x98, 0x64, 0x27, 0x77, 0x75,
  // "Ñ" (U+00D1)
  0x77, 0x48, 0x72, 0x7A, 0xBD, 0xCA, 0x72, 0x77, 0x60, 0x6C, 0x02, 0x77, 0x76, 0x03, 0x0B, 0xFA,
  0x0B, 0x03, 0x77, 0x40, 0x9C, 0x77, 0x76, 0x07, 0xFE, 0x0A, 0x01, 0x77, 0x20, 0xDB, 0x0D, 0x77,
  0x75, 0x08, 0xFF, 0x90, 0xE0, 0x57, 0x70, 0x3C, 0x0A, 0x77, 0x74, 0x05, 0xFF, 0xC0, 0xA0, 0x17,
  0x50, 0xAC, 0x06, 0x77, 0x73, 0x01, 0x0E, 0xF8, 0x1D, 0xCE, 0xFA, 0x0D, 0x04, 0x73, 0x04, 0xD0,
  0x17, 0x77, 0x30, 0x8D, 0x0D, 0x05, 0x48, 0x11, 0x7D, 0xF9, 0x09, 0x01, 0x70, 0x40, 0xEC, 0x0B,
  0x77, 0x74, 0x0E, 0xC0, 0xB7, 0x20, 0x8F, 0x98, 0x1E, 0x83, 0x30, 0x30, 0xAE, 0x04, 0x77, 0x73,
  0x05, 0xC0, 0xD0, 0x17, 0x30, 0x30, 0xDF, 0xB0, 0xEF, 0x90, 0xA7, 0x77, 0x40, 0xAC, 0x06, 0x76,
  0x09, 0xFF, 0xB0, 0xD0, 0x17, 0x77, 0x40, 0xDC, 0x77, 0x10, 0x40, 0xEF, 0xF0, 0xE0, 0x27, 0x77,
  0x5C, 0x0A, 0x77, 0x20, 0x10, 0x9F, 0xD0, 0xC0, 0x27, 0x77, 0x50, 0x3C, 0x07, 0x77, 0x40, 0x20,
  0xAF, 0x90, 0xE0, 0x77, 0x77, 0x78, 0x43, 0xBB, 0xBB, 0x37, 0x76, 0x86, 0x16, 0x8A, 0xB9, 0x74,
  0x80, 0x99, 0xA0, 0x08, 0x03, 0xB0, 0x78, 0x0D, 0x40, 0x01, 0x80, 0x2B, 0x04, 0xF9, 0x03, 0x80,
  0xD3, 0x00, 0x1E, 0x05, 0xF9, 0x0D, 0x80, 0xD3, 0x00, 0x1E, 0x05, 0xFA, 0x08, 0x80, 0xD2, 0x00,
  0x1E, 0x05, 0xFB, 0x03, 0x80, 0xD1, 0x00, 0x1E, 0x05, 0xFB, 0x0D, 0x80, 0xD1, 0x00, 0x1E, 0x05,
  0xFC, 0x08, 0x80, 0xD0, 0x00, 0x1E, 0x05, 0xFD, 0x03, 0x80, 0xC7, 0x00, 0x1E, 0x05, 0xFD, 0x0C,
  0x80, 0xC7, 0x00, 0x1E, 0x05, 0xFE, 0x08, 0x80, 0xC6, 0x00, 0x1E, 0x05, 0xFF, 0x03, 0x80, 0xC5,
  0x00, 0x1E, 0x05, 0xE0, 0x6F, 0x0C, 0x80, 0xC5, 0x00, 0x1E, 0x05, 0xE1, 0x0B, 0xF0, 0x78, 0x0C,
  0x40, 0x01, 0xE0, 0x5E, 0x81, 0x11, 0xEF, 0x02, 0x80, 0xC3, 0x00, 0x1E, 0x05, 0xE8, 0x12, 0x06,
  0xF0, 0xC8, 0x0C, 0x30, 0x01, 0xE0, 0x5E, 0x02, 0x20, 0xBF, 0x07, 0x80, 0xC2, 0x00, 0x1E, 0x05,
  0xE0, 0x32, 0x02, 0x0E, 0xF0, 0x28, 0x0C, 0x10, 0x01, 0xE0, 0x5E, 0x03, 0x30, 0x6F, 0x0C, 0x80,
  0xC1, 0x00, 0x1E, 0x05, 0xE0, 0x44, 0x0B, 0xF0, 0x78, 0x0C, 0x00, 0x01, 0xE0, 0x5E, 0x04, 0x40,
  0x20, 0xEF, 0x02, 0x77, 0x77, 0x70, 0x1E, 0x05, 0xE0, 0x55, 0x06, 0xF0, 0xC7, 0x77, 0x77, 0x01,
  0xE0, 0x5E, 0x05, 0x60, 0xBF, 0x07, 0x77, 0x77, 0x60, 0x1E, 0x05, 0xE0, 0x56, 0x02, 0x0E, 0xF0,
  0x27, 0x77, 0x75, 0x01, 0xE0, 0x5E, 0x06, 0x70, 0x6F, 0x0C, 0x77, 0x77, 0x50, 0x1E, 0x05, 0xE0,
  0x67, 0x10, 0xCF, 0x07, 0x77, 0x77, 0x40, 0x1E, 0x05, 0xE0, 0x67, 0x10, 0x2F, 0x90, 0x27, 0x77,
  0x73, 0x01, 0xE0, 0x5E, 0x07, 0x72, 0x07, 0xF0, 0xB7, 0x77, 0x73, 0x01, 0xE0, 0x5E, 0x07, 0x73,
  0x0C, 0xF0, 0x67, 0x77, 0x72, 0x01, 0xE0, 0x5E, 0x07, 0x73, 0x02, 0xF0, 0xE0, 0x27, 0x77, 0x71,
  0x01, 0xE0, 0x5E, 0x07, 0x74, 0x07, 0xF0, 0xB7, 0x77, 0x71, 0x01, 0xE0, 0x5E, 0x07, 0x75, 0x0C,
  0xF0, 0x67, 0x77, 0x70, 0x1E, 0x05, 0xE0, 0x77, 0x50, 0x2F, 0x0E, 0x02, 0x77, 0x76, 0x01, 0xE0,
  0x5E, 0x07, 0x76, 0x07, 0xF0, 0xB7, 0x77, 0x60, 0x1E, 0x05, 0xE0, 0x77, 0x70, 0xCF, 0x06, 0x77,
  0x75, 0x01, 0xE0, 0x5E, 0x07, 0x77, 0x02, 0xF0, 0xE0, 0x17, 0x77, 0x40, 0x1E, 0x05, 0xE0, 0x77,
  0x71, 0x07, 0xF0, 0xB7, 0x77, 0x40, 0x1E, 0x05, 0xE0, 0x77, 0x72, 0x0C, 0xF0, 0x67, 0x77, 0x30,
  0x1E, 0x05, 0xE0, 0x77, 0x72, 0x03, 0xF0, 0xE0, 0x17, 0x77, 0x20, 0x1E, 0x05, 0xE0, 0x77, 0x73,
  0x08, 0xF0, 0xB7, 0x77, 0x20, 0x1E, 0x05, 0xE0, 0x77, 0x74, 0x0C, 0xF0, 0x67, 0x77, 0x10, 0x1E,
  0x05, 0xE0, 0x77, 0x74, 0x03, 0xF0, 0xE0, 0x17, 0x77, 0x01, 0xE0, 0x5E, 0x07, 0x77, 0x50, 0x8F,
  0x0B, 0x77, 0x70, 0x1E, 0x05, 0xE0, 0x77, 0x76, 0x0D, 0xF0, 0x57, 0x76, 0x01, 0xE0, 0x5E, 0x07,
  0x77, 0x60, 0x3F, 0x0E, 0x01, 0x77, 0x50, 0x1E, 0x05, 0xE0, 0x77, 0x77, 0x08, 0xF0, 0xA7, 0x75,
  0x01, 0xE0, 0x5E, 0x07, 0x77, 0x71, 0x0D, 0xF0, 0x57, 0x74, 0x01, 0xE0, 0x5E, 0x07, 0x77, 0x71,
  0x03, 0xF0, 0xE0, 0x17, 0x73, 0x01, 0xE0, 0x5E, 0x07, 0x77, 0x72, 0x08, 0xF0, 0xA7, 0x73, 0x01,
  0xE0, 0x5E, 0x07, 0x77, 0x73, 0x0D, 0xF0, 0x57, 0x72, 0x01, 0xE0, 0x5E, 0x07, 0x77, 0x73, 0x03,
  0xF0, 0xE0, 0x17, 0x71, 0x01, 0xE0, 0x5E, 0x07, 0x77, 0x74, 0x08, 0xF0, 0xA7, 0x71, 0x01, 0xE0,
  0x5E, 0x07, 0x77, 0x75, 0x0D, 0xF0, 0x57, 0x70, 0x1E, 0x05, 0xE0, 0x77, 0x77, 0x50, 0x3F, 0x0E,
  0x01, 0x76, 0x01, 0xE0, 0x5E, 0x07, 0x77, 0x76, 0x09, 0xF0, 0xA7, 0x60, 0x1E, 0x05, 0xE0, 0x77,
  0x77, 0x70, 0xDF, 0x05, 0x75, 0x01, 0xE0, 0x5E, 0x07, 0x77, 0x77, 0x04, 0xF0, 0xE0, 0x17, 0x40,
  0x1E, 0x05, 0xE0, 0x77, 0x77, 0x71, 0x09, 0xF0, 0xA7, 0x40, 0x1E, 0x05, 0xE0, 0x77, 0x77, 0x72,
  0x0D, 0xF0, 0x47, 0x30, 0x1E, 0x05, 0xE0, 0x77, 0x77, 0x72, 0x04, 0xF0, 0xE0, 0x17, 0x20, 0x1E,
  0x05, 0xE0, 0x77, 0x77, 0x73, 0x09, 0xF0, 0x97, 0x20, 0x1E, 0x05, 0xE0, 0x77, 0x77, 0x74, 0x0D,
  0xF0, 0x47, 0x10, 0x1E, 0x05, 0xE0, 0x77, 0x77, 0x74, 0x04, 0xF0, 0xD0, 0x17, 0x01, 0xE0, 0x5E,
  0x07, 0x77, 0x77, 0x50, 0x9F, 0x09, 0x71, 0xE0, 0x5E, 0x07, 0x77, 0x77, 0x50, 0x10, 0xDF, 0x04,
  0x7E, 0x05, 0xE0, 0x77, 0x77, 0x76, 0x04, 0xF0, 0xD7, 0xE0, 0x5E, 0x07, 0x77, 0x77, 0x70, 0xAF,
  0x09, 0x6E, 0x05, 0xE0, 0x77, 0x77, 0x77, 0x01, 0x0E, 0xF0, 0x45, 0xE0, 0x5E, 0x07, 0x80, 0xC0,
  0x00, 0x5F, 0x0D, 0x50, 0xED, 0x05, 0xE0, 0x78, 0x0C, 0x10, 0x0A, 0xF0, 0x94, 0x0E, 0xD0, 0x5E,
  0x07, 0x80, 0xC1, 0x00, 0x10, 0xEF, 0x04, 0x30, 0xDD, 0x05, 0xE0, 0x78, 0x0C, 0x20, 0x05, 0xF0,
  0xD3, 0x0D, 0xD0, 0x5E, 0x07, 0x80, 0xC3, 0x00, 0xAF, 0x09, 0x20, 0xCD, 0x05, 0xE0, 0x78, 0x0C,
  0x30, 0x01, 0x0E, 0xF8, 0x13, 0x0B, 0xD0, 0x5E, 0x07, 0x80, 0xC4, 0x00, 0x5F, 0x81, 0xD0, 0xBD,
  0x05, 0xE0, 0x78, 0x0C, 0x50, 0x0A, 0xF0, 0x80, 0xAD, 0x05, 0xE0, 0x78, 0x0C, 0x50, 0x01, 0x0E,
  0xFE, 0x05, 0xE0, 0x78, 0x0C, 0x60, 0x05, 0xFE, 0x05, 0xE0, 0x78, 0x0C, 0x70, 0x0A, 0xFD, 0x05,
  0xE0, 0x78, 0x0C, 0x70, 0x01, 0x0E, 0xFC, 0x05, 0xE0, 0x78, 0x0D, 0x00, 0x05, 0xFC, 0x05, 0xE0,
  0x78, 0x0D, 0x10, 0x0B, 0xFB, 0x05, 0xE0, 0x78, 0x0D, 0x10, 0x01, 0x0E, 0xFA, 0x05, 0xE0, 0x78,
  0x0D, 0x20, 0x06, 0xFA, 0x05, 0xE0, 0x78, 0x0D, 0x30, 0x0B, 0xF9, 0x05, 0xE0, 0x78, 0x0D, 0x30,
  0x01, 0x0E, 0xF0, 0x5E, 0x07, 0x80, 0xD4, 0x00, 0x6F, 0x05,
  // "Ò" (U+00D2)
  0x77, 0x72, 0x01, 0x80, 0x4B, 0x01, 0x80, 0x98, 0x10, 0x0D, 0xF0, 0xA8, 0x09, 0x81, 0x00, 0x3F,
  0x90, 0x48, 0x09, 0x81, 0x00, 0x7F, 0x0D, 0x01, 0x80, 0x98, 0x10, 0x0A, 0xF0, 0xA8, 0x09, 0x82,
  0x00, 0xCF, 0x05, 0x80, 0x98, 0x10, 0x01, 0x0D, 0xE0, 0xE0, 0x28, 0x09, 0x81, 0x00, 0x20, 0xEE,
  0x0C, 0x80, 0x98, 0x20, 0x03, 0x0E, 0xE0, 0x98, 0x09, 0x82, 0x00, 0x4F, 0x05, 0x80, 0x98, 0x20,
  0x04, 0xF0, 0x38, 0x09, 0x82, 0x00, 0x5E, 0x0D, 0x01, 0x80, 0x98, 0x20, 0x05, 0xE0, 0xB8, 0x09,
  0x83, 0x00, 0x5E, 0x09, 0x80, 0x98, 0x30, 0x05, 0xE0, 0x78, 0x09, 0x83, 0x00, 0x40, 0xED, 0x05,
  0x80, 0x98, 0x30, 0x03, 0x0E, 0xD0, 0x48, 0x09, 0x83, 0x00, 0x20, 0xDC, 0x0E, 0x03, 0x80, 0x98,
  0x30, 0x01, 0x0C, 0xC0, 0xE8, 0x09, 0x85, 0x08, 0x01, 0x58, 0x09, 0x9B, 0x40, 0x85, 0x36, 0x8A,
  0xBD, 0xDC, 0x86, 0xED, 0xCB, 0x97, 0x52, 0x80, 0xE3, 0x08, 0x14, 0x8C, 0xFF, 0xE8, 0x2E, 0xB7,
  0x28, 0x0D, 0x40, 0x81, 0x39, 0xEF, 0xFF, 0xE8, 0x1D, 0x71, 0x80, 0xC7, 0x00, 0x50, 0xDF, 0xFF,
  0xFD, 0x0A, 0x02, 0x80, 0xC3, 0x00, 0x50, 0xD8, 0x0C, 0x1F, 0x0A, 0x01, 0x77, 0x77, 0x70, 0x20,
  0xB8, 0x0C, 0x5F, 0x07, 0x77, 0x77, 0x50, 0x7F, 0xF9, 0x89, 0x5C, 0xA7, 0x65, 0x33, 0x33, 0x45,
  0x68, 0xAC, 0xFF, 0x0C, 0x02, 0x77, 0x77, 0x10, 0x10, 0xBF, 0xD8, 0x1B, 0x73, 0x77, 0x38, 0x14,
  0x8D, 0xFC, 0x0E, 0x04, 0x77, 0x76, 0x02, 0x0D, 0xFB, 0x81, 0xD7, 0x17, 0x77, 0x28, 0x13, 0x9E,
  0xFB, 0x06, 0x77, 0x74, 0x02, 0x0E, 0xFA, 0x0D, 0x05, 0x77, 0x77, 0x81, 0x18, 0xEF, 0xA0, 0x87,
  0x77, 0x20, 0x30, 0xEF, 0x90, 0xE0, 0x77, 0x77, 0x74, 0x01, 0x0A, 0xFA, 0x07, 0x77, 0x70, 0x20,
  0xEF, 0x90, 0xC0, 0x27, 0x77, 0x77, 0x05, 0x0E, 0xF9, 0x06, 0x77, 0x50, 0x10, 0xDF, 0x90, 0x98,
  0x0C, 0x20, 0x02, 0x0D, 0xF9, 0x04, 0x77, 0x40, 0xBF, 0x90, 0x78, 0x0C, 0x40, 0x01, 0x0D, 0xF0,
  0xE0, 0x17, 0x72, 0x07, 0xF9, 0x06, 0x80, 0xC6, 0x00, 0x10, 0xDF, 0x0B, 0x77, 0x10, 0x2F, 0x90,
  0x78, 0x0D, 0x00, 0x02, 0x0E, 0xF0, 0x67, 0x70, 0xCF, 0x0A, 0x80, 0xD2, 0x00, 0x4F, 0x0E, 0x01,
  0x75, 0x06, 0xF0, 0xD8, 0x0D, 0x40, 0x09, 0xF0, 0x97, 0x50, 0xEF, 0x03, 0x80, 0xD5, 0x00, 0xDF,
  0x02, 0x73, 0x07, 0xF0, 0x88, 0x0D, 0x60, 0x04, 0xF0, 0xA7, 0x30, 0xEE, 0x0E, 0x80, 0xE0, 0x00,
  0xBF, 0x02, 0x71, 0x06, 0xF0, 0x68, 0x0E, 0x00, 0x03, 0xF0, 0x87, 0x10, 0xCE, 0x0E, 0x80, 0xE2,
  0x00, 0xBE, 0x0E, 0x70, 0x3F, 0x07, 0x80, 0xE2, 0x00, 0x5F, 0x05, 0x60, 0x8F, 0x01, 0x80, 0xE3,
  0x00, 0xDE, 0x0A, 0x60, 0xDE, 0x0B, 0x80, 0xE4, 0x00, 0x8F, 0x50, 0x3F, 0x05, 0x80, 0xE4, 0x00,
  0x3F, 0x05, 0x40, 0x7F, 0x01, 0x80, 0xE5, 0x00, 0xDE, 0x09, 0x40, 0xBE, 0x0B, 0x80, 0xE6, 0x00,
  0x9E, 0x0D, 0x4F, 0x07, 0x80, 0xE6, 0x00, 0x5F, 0x01, 0x20, 0x3F, 0x03, 0x80, 0xE6, 0x00, 0x1F,
  0x04, 0x20, 0x6F, 0x80, 0xF0, 0x00, 0xDE, 0x07, 0x20, 0x9E, 0x0C, 0x80, 0xF0, 0x00, 0xAE, 0x0A,
  0x20, 0xBE, 0x09, 0x80, 0xF0, 0x00, 0x8E, 0x0C, 0x20, 0xEE, 0x07, 0x80, 0xF0, 0x00, 0x5F, 0x2F,
  0x04, 0x80, 0xF0, 0x00, 0x3F, 0x01, 0x02, 0xF0, 0x28, 0x0F, 0x00, 0x01, 0xF0, 0x30, 0x4F, 0x01,
  0x80, 0xF1, 0x0F, 0x04, 0x05, 0xF8, 0x0F, 0x20, 0x0E, 0xE0, 0x50, 0x6E, 0x0E, 0x80, 0xF2, 0x00,
  0xDE, 0x06, 0x07, 0xE0, 0xD8, 0x0F, 0x20, 0x0C, 0xE0, 0x07, 0xE0, 0xC8, 0x0F, 0x20, 0x0C, 0xE0,
  0x08, 0xE0, 0xC8, 0x0F, 0x20, 0x0B, 0xE0, 0x08, 0xE0, 0xC8, 0x0F, 0x20, 0x0B, 0xE0, 0x90, 0x8E,
  0x0B, 0x80, 0xF2, 0x00, 0xBE, 0x09, 0x08, 0xE0, 0xC8, 0x0F, 0x20, 0x0B, 0xE0, 0x80, 0x7E, 0x0C,
  0x80, 0xF2, 0x00, 0xBE, 0x08, 0x07, 0xE0, 0xD8, 0x0F, 0x20, 0x0C, 0xE0, 0x70, 0x6E, 0x0E, 0x80,
  0xF2, 0x00, 0xDE, 0x06, 0x05, 0xF8, 0x0F, 0x20, 0x0E, 0xE0, 0x50, 0x4F, 0x01, 0x80, 0xF1, 0x0F,
  0x04, 0x02, 0xF0, 0x28, 0x0F, 0x00, 0x01, 0xF0, 0x31, 0xF0, 0x48, 0x0F, 0x00, 0x03, 0xF8, 0x11,
  0x0E, 0xE0, 0x68, 0x0F, 0x00, 0x05, 0xE0, 0xE2, 0x0B, 0xE0, 0x88, 0x0F, 0x00, 0x07, 0xE0, 0xC2,
  0x09, 0xE0, 0xB8, 0x0F, 0x00, 0x0A, 0xE0, 0xA2, 0x06, 0xE0, 0xE8, 0x0F, 0x00, 0x0D, 0xE0, 0x72,
  0x03, 0xF0, 0x28, 0x0E, 0x60, 0x01, 0xF0, 0x43, 0xF0, 0x68, 0x0E, 0x60, 0x04, 0xF4, 0x0C, 0xE0,
  0xA8, 0x0E, 0x60, 0x08, 0xE0, 0xC4, 0x08, 0xE0, 0xE8, 0x0E, 0x60, 0x0C, 0xE0, 0x84, 0x03, 0xF0,
  0x38, 0x0E, 0x40, 0x01, 0xF0, 0x45, 0x0E, 0xE0, 0x98, 0x0E, 0x40, 0x07, 0xE0, 0xE6, 0x09, 0xE0,
  0xE8, 0x0E, 0x40, 0x0C, 0xE0, 0x96, 0x04, 0xF0, 0x58, 0x0E, 0x20, 0x03, 0xF0, 0x47, 0x0D, 0xE0,
  0xB8, 0x0E, 0x20, 0x09, 0xE0, 0xD7, 0x10, 0x8F, 0x03, 0x80, 0xE0, 0x00, 0x1F, 0x07, 0x71, 0x01,
  0xF0, 0xB8, 0x0E, 0x00, 0x09, 0xF0, 0x17, 0x20, 0x9F, 0x04, 0x80, 0xD6, 0x00, 0x2F, 0x09, 0x73,
  0x02, 0xF0, 0xD8, 0x0D, 0x60, 0x0B, 0xF0, 0x27, 0x40, 0x9F, 0x08, 0x80, 0xD4, 0x00, 0x6F, 0x08,
  0x75, 0x01, 0x0E, 0xF0, 0x48, 0x0D, 0x20, 0x02, 0x0E, 0xE0, 0xE0, 0x17, 0x60, 0x6F, 0x0E, 0x02,
  0x80, 0xD0, 0x00, 0x10, 0xDF, 0x05, 0x77, 0x10, 0xBF, 0x0D, 0x01, 0x80, 0xC7, 0x00, 0xBF, 0x0B,
  0x77, 0x20, 0x20, 0xEF, 0x0D, 0x01, 0x80, 0xC5, 0x00, 0xBF, 0x0E, 0x01, 0x77, 0x30, 0x4F, 0x90,
  0xD0, 0x28, 0x0C, 0x20, 0x01, 0x0C, 0xF9, 0x03, 0x77, 0x50, 0x7F, 0x90, 0xE0, 0x58, 0x0C, 0x00,
  0x03, 0x0D, 0xF9, 0x06, 0x77, 0x70, 0x8F, 0xA0, 0x90, 0x17, 0x77, 0x75, 0x07, 0xFA, 0x07, 0x77,
  0x72, 0x09, 0xFA, 0x0E, 0x06, 0x77, 0x77, 0x20, 0x40, 0xDF, 0xA0, 0x77, 0x77, 0x40, 0x8F, 0xB8,
  0x1D, 0x61, 0x77, 0x74, 0x05, 0x0C, 0xFB, 0x07, 0x77, 0x76, 0x05, 0xFD, 0x81, 0xA5, 0x17, 0x75,
  0x81, 0x49, 0xEF, 0xB0, 0xE0, 0x47, 0x77, 0x71, 0x03, 0x0D, 0xFE, 0x84, 0xC9, 0x64, 0x21, 0x68,
  0x41, 0x24, 0x68, 0xCF, 0xE0, 0xC0, 0x27, 0x77, 0x74, 0x09, 0xFF, 0xE0, 0x0E, 0xFF, 0xE0, 0x87,
  0x77, 0x77, 0x03, 0x0C, 0x80, 0xC2, 0xF0, 0xB0, 0x28, 0x0C, 0x20, 0x04, 0x0C, 0xFF, 0xFF, 0xE0,
  0xB0, 0x38, 0x0C, 0x60, 0x81, 0x39, 0xEF, 0xFF, 0xF8, 0x1E, 0x93, 0x80, 0xD3, 0x08, 0x14, 0x9D,
  0xFF, 0xF9, 0x81, 0xD9, 0x48, 0x0E, 0x10, 0x84, 0x14, 0x7A, 0xCD, 0xFB, 0x84, 0xDC, 0xA7, 0x41,
  0x80, 0xF3, 0x00, 0xF1, 0x02, 0x03, 0x0F, 0x17, 0x77, 0x77,
  // "Ó" (U+00D3)
  0x80, 0xD3, 0x00, 0x38, 0x04, 0xB0, 0x18, 0x09, 0x80, 0x00, 0xCF, 0x0D, 0x80, 0x98, 0x00, 0x07,
  0xF0, 0xE0, 0x38, 0x0F, 0x70, 0x02, 0x0E, 0xF0, 0x58, 0x09, 0x80, 0x00, 0xCF, 0x08, 0x80, 0x98,
  0x00, 0x08, 0xF0, 0xB8, 0x09, 0x80, 0x00, 0x4F, 0x0C, 0x80, 0x98, 0x00, 0x01, 0x0E, 0xE0, 0xD0,
  0x18, 0x09, 0x80, 0x00, 0xBE, 0x0E, 0x02, 0x80, 0x98, 0x00, 0x08, 0xE0, 0xE0, 0x38, 0x09, 0x80,
  0x00, 0x5F, 0x04, 0x80, 0x98, 0x00, 0x02, 0x0E, 0xE0, 0x48, 0x09, 0x80, 0x00, 0x10, 0xDE, 0x04,
  0x80, 0x98, 0x10, 0x0B, 0xE0, 0x58, 0x09, 0x81, 0x00, 0x9E, 0x04, 0x80, 0x98, 0x10, 0x07, 0xD0,
  0xE0, 0x48, 0x09, 0x81, 0x00, 0x5D, 0x0E, 0x03, 0x80, 0x98, 0x10, 0x04, 0xD0, 0xD0, 0x28, 0x09,
  0x82, 0x00, 0xEC, 0x0B, 0x01, 0x80, 0x98, 0x30, 0x80, 0x15, 0x80, 0x99, 0xC3, 0x08, 0x53, 0x68,
  0xAB, 0xDD, 0xC8, 0x6E, 0xDC, 0xB9, 0x75, 0x28, 0x0E, 0x30, 0x81, 0x48, 0xCF, 0xFE, 0x82, 0xEB,
  0x72, 0x80, 0xD4, 0x08, 0x13, 0x9E, 0xFF, 0xFE, 0x81, 0xD7, 0x18, 0x0C, 0x70, 0x05, 0x0D, 0xFF,
  0xFF, 0xD0, 0xA0, 0x28, 0x0C, 0x30, 0x05, 0x0D, 0x80, 0xC1, 0xF0, 0xA0, 0x17, 0x77, 0x77, 0x02,
  0x0B, 0x80, 0xC5, 0xF0, 0x77, 0x77, 0x75, 0x07, 0xFF, 0x98, 0x95, 0xCA, 0x76, 0x53, 0x33, 0x34,
  0x56, 0x8A, 0xCF, 0xF0, 0xC0, 0x27, 0x77, 0x71, 0x01, 0x0B, 0xFD, 0x81, 0xB7, 0x37, 0x73, 0x81,
  0x48, 0xDF, 0xC0, 0xE0, 0x47, 0x77, 0x60, 0x20, 0xDF, 0xB8, 0x1D, 0x71, 0x77, 0x72, 0x81, 0x39,
  0xEF, 0xB0, 0x67, 0x77, 0x40, 0x20, 0xEF, 0xA0, 0xD0, 0x57, 0x77, 0x78, 0x11, 0x8E, 0xFA, 0x08,
  0x77, 0x72, 0x03, 0x0E, 0xF9, 0x0E, 0x07, 0x77, 0x77, 0x40, 0x10, 0xAF, 0xA0, 0x77, 0x77, 0x02,
  0x0E, 0xF9, 0x0C, 0x02, 0x77, 0x77, 0x70, 0x50, 0xEF, 0x90, 0x67, 0x75, 0x01, 0x0D, 0xF9, 0x09,
  0x80, 0xC2, 0x00, 0x20, 0xDF, 0x90, 0x47, 0x74, 0x0B, 0xF9, 0x07, 0x80, 0xC4, 0x00, 0x10, 0xDF,
  0x0E, 0x01, 0x77, 0x20, 0x7F, 0x90, 0x68, 0x0C, 0x60, 0x01, 0x0D, 0xF0, 0xB7, 0x71, 0x02, 0xF9,
  0x07, 0x80, 0xD0, 0x00, 0x20, 0xEF, 0x06, 0x77, 0x0C, 0xF0, 0xA8, 0x0D, 0x20, 0x04, 0xF0, 0xE0,
  0x17, 0x50, 0x6F, 0x0D, 0x80, 0xD4, 0x00, 0x9F, 0x09, 0x75, 0x0E, 0xF0, 0x38, 0x0D, 0x50, 0x0D,
  0xF0, 0x27, 0x30, 0x7F, 0x08, 0x80, 0xD6, 0x00, 0x4F, 0x0A, 0x73, 0x0E, 0xE0, 0xE8, 0x0E, 0x00,
  0x0B, 0xF0, 0x27, 0x10, 0x6F, 0x06, 0x80, 0xE0, 0x00, 0x3F, 0x08, 0x71, 0x0C, 0xE0, 0xE8, 0x0E,
  0x20, 0x0B, 0xE0, 0xE7, 0x03, 0xF0, 0x78, 0x0E, 0x20, 0x05, 0xF0, 0x56, 0x08, 0xF0, 0x18, 0x0E,
  0x30, 0x0D, 0xE0, 0xA6, 0x0D, 0xE0, 0xB8, 0x0E, 0x40, 0x08, 0xF5, 0x03, 0xF0, 0x58, 0x0E, 0x40,
  0x03, 0xF0, 0x54, 0x07, 0xF0, 0x18, 0x0E, 0x50, 0x0D, 0xE0, 0x94, 0x0B, 0xE0, 0xB8, 0x0E, 0x60,
  0x09, 0xE0, 0xD4, 0xF0, 0x78, 0x0E, 0x60, 0x05, 0xF0, 0x12, 0x03, 0xF0, 0x38, 0x0E, 0x60, 0x01,
  0xF0, 0x42, 0x06, 0xF8, 0x0F, 0x00, 0x0D, 0xE0, 0x72, 0x09, 0xE0, 0xC8, 0x0F, 0x00, 0x0A, 0xE0,
  0xA2, 0x0B, 0xE0, 0x98, 0x0F, 0x00, 0x08, 0xE0, 0xC2, 0x0E, 0xE0, 0x78, 0x0F, 0x00, 0x05, 0xF2,
  0xF0, 0x48, 0x0F, 0x00, 0x03, 0xF0, 0x10, 0x2F, 0x02, 0x80, 0xF0, 0x00, 0x1F, 0x03, 0x04, 0xF0,
  0x18, 0x0F, 0x10, 0xF0, 0x40, 0x5F, 0x80, 0xF2, 0x00, 0xEE, 0x05, 0x06, 0xE0, 0xE8, 0x0F, 0x20,
  0x0D, 0xE0, 0x60, 0x7E, 0x0D, 0x80, 0xF2, 0x00, 0xCE, 0x00, 0x7E, 0x0C, 0x80, 0xF2, 0x00, 0xCE,
  0x00, 0x8E, 0x0C, 0x80, 0xF2, 0x00, 0xBE, 0x00, 0x8E, 0x0C, 0x80, 0xF2, 0x00, 0xBE, 0x09, 0x08,
  0xE0, 0xB8, 0x0F, 0x20, 0x0B, 0xE0, 0x90, 0x8E, 0x0C, 0x80, 0xF2, 0x00, 0xBE, 0x08, 0x07, 0xE0,
  0xC8, 0x0F, 0x20, 0x0B, 0xE0, 0x80, 0x7E, 0x0D, 0x80, 0xF2, 0x00, 0xCE, 0x07, 0x06, 0xE0, 0xE8,
  0x0F, 0x20, 0x0D, 0xE0, 0x60, 0x5F, 0x80, 0xF2, 0x00, 0xEE, 0x05, 0x04, 0xF0, 0x18, 0x0F, 0x10,
  0xF0, 0x40, 0x2F, 0x02, 0x80, 0xF0, 0x00, 0x1F, 0x03, 0x1F, 0x04, 0x80, 0xF0, 0x00, 0x3F, 0x81,
  0x10, 0xEE, 0x06, 0x80, 0xF0, 0x00, 0x5E, 0x0E, 0x20, 0xBE, 0x08, 0x80, 0xF0, 0x00, 0x7E, 0x0C,
  0x20, 0x9E, 0x0B, 0x80, 0xF0, 0x00, 0xAE, 0x0A, 0x20, 0x6E, 0x0E, 0x80, 0xF0, 0x00, 0xDE, 0x07,
  0x20, 0x3F, 0x02, 0x80, 0xE6, 0x00, 0x1F, 0x04, 0x3F, 0x06, 0x80, 0xE6, 0x00, 0x4F, 0x40, 0xCE,
  0x0A, 0x80, 0xE6, 0x00, 0x8E, 0x0C, 0x40, 0x8E, 0x0E, 0x80, 0xE6, 0x00, 0xCE, 0x08, 0x40, 0x3F,
  0x03, 0x80, 0xE4, 0x00, 0x1F, 0x04, 0x50, 0xEE, 0x09, 0x80, 0xE4, 0x00, 0x7E, 0x0E, 0x60, 0x9E,
  0x0E, 0x80, 0xE4, 0x00, 0xCE, 0x09, 0x60, 0x4F, 0x05, 0x80, 0xE2, 0x00, 0x3F, 0x04, 0x70, 0xDE,
  0x0B, 0x80, 0xE2, 0x00, 0x9E, 0x0D, 0x71, 0x08, 0xF0, 0x38, 0x0E, 0x00, 0x01, 0xF0, 0x77, 0x10,
  0x1F, 0x0B, 0x80, 0xE0, 0x00, 0x9F, 0x01, 0x72, 0x09, 0xF0, 0x48, 0x0D, 0x60, 0x02, 0xF0, 0x97,
  0x30, 0x2F, 0x0D, 0x80, 0xD6, 0x00, 0xBF, 0x02, 0x74, 0x09, 0xF0, 0x88, 0x0D, 0x40, 0x06, 0xF0,
  0x87, 0x50, 0x10, 0xEF, 0x04, 0x80, 0xD2, 0x00, 0x20, 0xEE, 0x0E, 0x01, 0x76, 0x06, 0xF0, 0xE0,
  0x28, 0x0D, 0x00, 0x01, 0x0D, 0xF0, 0x57, 0x71, 0x0B, 0xF0, 0xD0, 0x18, 0x0C, 0x70, 0x0B, 0xF0,
  0xB7, 0x72, 0x02, 0x0E, 0xF0, 0xD0, 0x18, 0x0C, 0x50, 0x0B, 0xF0, 0xE0, 0x17, 0x73, 0x04, 0xF9,
  0x0D, 0x02, 0x80, 0xC2, 0x00, 0x10, 0xCF, 0x90, 0x37, 0x75, 0x07, 0xF9, 0x0E, 0x05, 0x80, 0xC0,
  0x00, 0x30, 0xDF, 0x90, 0x67, 0x77, 0x08, 0xFA, 0x09, 0x01, 0x77, 0x77, 0x50, 0x7F, 0xA0, 0x77,
  0x77, 0x20, 0x9F, 0xA0, 0xE0, 0x67, 0x77, 0x72, 0x04, 0x0D, 0xFA, 0x07, 0x77, 0x74, 0x08, 0xFB,
  0x81, 0xD6, 0x17, 0x77, 0x40, 0x50, 0xCF, 0xB0, 0x77, 0x77, 0x60, 0x5F, 0xD8, 0x1A, 0x51, 0x77,
  0x58, 0x14, 0x9E, 0xFB, 0x0E, 0x04, 0x77, 0x77, 0x10, 0x30, 0xDF, 0xE8, 0x4C, 0x96, 0x42, 0x16,
  0x84, 0x12, 0x46, 0x8C, 0xFE, 0x0C, 0x02, 0x77, 0x77, 0x40, 0x9F, 0xFE, 0x00, 0xEF, 0xFE, 0x08,
  0x77, 0x77, 0x70, 0x30, 0xC8, 0x0C, 0x2F, 0x0B, 0x02, 0x80, 0xC2, 0x00, 0x40, 0xCF, 0xFF, 0xFE,
  0x0B, 0x03, 0x80, 0xC6, 0x08, 0x13, 0x9E, 0xFF, 0xFF, 0x81, 0xE9, 0x38, 0x0D, 0x30, 0x81, 0x49,
  0xDF, 0xFF, 0x98, 0x1D, 0x94, 0x80, 0xE1, 0x08, 0x41, 0x47, 0xAC, 0xDF, 0xB8, 0x4D, 0xCA, 0x74,
  0x18, 0x0F, 0x30, 0x0F, 0x10, 0x20, 0x30, 0xF1, 0x77, 0x77, 0x70,
  // "Ô" (U+00D4)
  0x77, 0x77, 0x70, 0x38, 0x02, 0x70, 0x38, 0x09, 0x82, 0x00, 0xDE, 0x0D, 0x80, 0x98, 0x10, 0x09,
  0xF9, 0x08, 0x80, 0xF7, 0x00, 0x4F, 0xB0, 0x48, 0x0F, 0x50, 0x01, 0x0E, 0xFB, 0x0D, 0x01, 0x80,
  0xF4, 0x00, 0xBF, 0xD0, 0xB8, 0x0F, 0x30, 0x08, 0xE0, 0x0D, 0xE0, 0x78, 0x0F, 0x10, 0x05, 0xE8,
  0x2E, 0x22, 0xEE, 0x04, 0x80, 0xE7, 0x00, 0x20, 0xED, 0x0E, 0x03, 0x20, 0x4E, 0x0E, 0x02, 0x80,
  0xE6, 0x00, 0xDE, 0x04, 0x40, 0x5E, 0x0D, 0x01, 0x80, 0xE4, 0x00, 0xBE, 0x05, 0x60, 0x7E, 0x0B,
  0x80, 0xE3, 0x00, 0x9E, 0x06, 0x71, 0x08, 0xE0, 0x88, 0x0E, 0x10, 0x06, 0xE0, 0x77, 0x30, 0x9E,
  0x06, 0x80, 0xD7, 0x00, 0x4E, 0x08, 0x75, 0x09, 0xE0, 0x48, 0x0D, 0x50, 0x03, 0x0E, 0xD0, 0x87,
  0x70, 0x9D, 0x0E, 0x02, 0x80, 0xD3, 0x00, 0x20, 0xED, 0x07, 0x77, 0x20, 0x9D, 0x0D, 0x01, 0x80,
  0xD1, 0x00, 0x10, 0xDD, 0x07, 0x77, 0x40, 0x8D, 0x0C, 0x01, 0x80, 0xD0, 0x00, 0xCD, 0x05, 0x77,
  0x60, 0x6D, 0x0B, 0x80, 0xC7, 0x00, 0x9C, 0x0E, 0x03, 0x77, 0x71, 0x04, 0x0E, 0xC0, 0x98, 0x0C,
  0x60, 0x84, 0x35, 0x55, 0x52, 0x77, 0x73, 0x84, 0x25, 0x55, 0x54, 0x80, 0x99, 0xA1, 0x08, 0x53,
  0x68, 0xAB, 0xDD, 0xC8, 0x6E, 0xDC, 0xB9, 0x75, 0x28, 0x0E, 0x30, 0x81, 0x48, 0xCF, 0xFE, 0x82,
  0xEB, 0x72, 0x80, 0xD4, 0x08, 0x13, 0x9E, 0xFF, 0xFE, 0x81, 0xD7, 0x18, 0x0C, 0x70, 0x05, 0x0D,
  0xFF, 0xFF, 0xD0, 0xA0, 0x28, 0x0C, 0x30, 0x05, 0x0D, 0x80, 0xC1, 0xF0, 0xA0, 0x17, 0x77, 0x77,
  0x02, 0x0B, 0x80, 0xC5, 0xF0, 0x77, 0x77, 0x75, 0x07, 0xFF, 0x98, 0x95, 0xCA, 0x76, 0x53, 0x33,
  0x34, 0x56, 0x8A, 0xCF, 0xF0, 0xC0, 0x27, 0x77, 0x71, 0x01, 0x0B, 0xFD, 0x81, 0xB7, 0x37, 0x73,
  0x81, 0x48, 0xDF, 0xC0, 0xE0, 0x47, 0x77, 0x60, 0x20, 0xDF, 0xB8, 0x1D, 0x71, 0x77, 0x72, 0x81,
  0x39, 0xEF, 0xB0, 0x67, 0x77, 0x40, 0x20, 0xEF, 0xA0, 0xD0, 0x57, 0x77, 0x78, 0x11, 0x8E, 0xFA,
  0x08, 0x77, 0x72, 0x03, 0x0E, 0xF9, 0x0E, 0x07, 0x77, 0x77, 0x40, 0x10, 0xAF, 0xA0, 0x77, 0x77,
  0x02, 0x0E, 0xF9, 0x0C, 0x02, 0x77, 0x77, 0x70, 0x50, 0xEF, 0x90, 0x67, 0x75, 0x01, 0x0D, 0xF9,
  0x09, 0x80, 0xC2, 0x00, 0x20, 0xDF, 0x90, 0x47, 0x74, 0x0B, 0xF9, 0x07, 0x80, 0xC4, 0x00, 0x10,
  0xDF, 0x0E, 0x01, 0x77, 0x20, 0x7F, 0x90, 0x68, 0x0C, 0x60, 0x01, 0x0D, 0xF0, 0xB7, 0x71, 0x02,
  0xF9, 0x07, 0x80, 0xD0, 0x00, 0x20, 0xEF, 0x06, 0x77, 0x0C, 0xF0, 0xA8, 0x0D, 0x20, 0x04, 0xF0,
  0xE0, 0x17, 0x50, 0x6F, 0x0D, 0x80, 0xD4, 0x00, 0x9F, 0x09, 0x75, 0x0E, 0xF0, 0x38, 0x0D, 0x50,
  0x0D, 0xF0, 0x27, 0x30, 0x7F, 0x08, 0x80, 0xD6, 0x00, 0x4F, 0x0A, 0x73, 0x0E, 0xE0, 0xE8, 0x0E,
  0x00, 0x0B, 0xF0, 0x27, 0x10, 0x6F, 0x06, 0x80, 0xE0, 0x00, 0x3F, 0x08, 0x71, 0x0C, 0xE0, 0xE8,
  0x0E, 0x20, 0x0B, 0xE0, 0xE7, 0x03, 0xF0, 0x78, 0x0E, 0x20, 0x05, 0xF0, 0x56, 0x08, 0xF0, 0x18,
  0x0E, 0x30, 0x0D, 0xE0, 0xA6, 0x0D, 0xE0, 0xB8, 0x0E, 0x40, 0x08, 0xF5, 0x03, 0xF0, 0x58, 0x0E,
  0x40, 0x03, 0xF0, 0x54, 0x07, 0xF0, 0x18, 0x0E, 0x50, 0x0D, 0xE0, 0x94, 0x0B, 0xE0, 0xB8, 0x0E,
  0x60, 0x09, 0xE0, 0xD4, 0xF0, 0x78, 0x0E, 0x60, 0x05, 0xF0, 0x12, 0x03, 0xF0, 0x38, 0x0E, 0x60,
  0x01, 0xF0, 0x42, 0x06, 0xF8, 0x0F, 0x00, 0x0D, 0xE0, 0x72, 0x09, 0xE0, 0xC8, 0x0F, 0x00, 0x0A,
  0xE0, 0xA2, 0x0B, 0xE0, 0x98, 0x0F, 0x00, 0x08, 0xE0, 0xC2, 0x0E, 0xE0, 0x78, 0x0F, 0x00, 0x05,
  0xF2, 0xF0, 0x48, 0x0F, 0x00, 0x03, 0xF0, 0x10, 0x2F, 0x02, 0x80, 0xF0, 0x00, 0x1F, 0x03, 0x04,
  0xF0, 0x18, 0x0F, 0x10, 0xF0, 0x40, 0x5F, 0x80, 0xF2, 0x00, 0xEE, 0x05, 0x06, 0xE0, 0xE8, 0x0F,
  0x20, 0x0D, 0xE0, 0x60, 0x7E, 0x0D, 0x80, 0xF2, 0x00, 0xCE, 0x00, 0x7E, 0x0C, 0x80, 0xF2, 0x00,
  0xCE, 0x00, 0x8E, 0x0C, 0x80, 0xF2, 0x00, 0xBE, 0x00, 0x8E, 0x0C, 0x80, 0xF2, 0x00, 0xBE, 0x09,
  0x08, 0xE0, 0xB8, 0x0F, 0x20, 0x0B, 0xE0, 0x90, 0x8E, 0x0C, 0x80, 0xF2, 0x00, 0xBE, 0x08, 0x07,
  0xE0, 0xC8, 0x0F, 0x20, 0x0B, 0xE0, 0x80, 0x7E, 0x0D, 0x80, 0xF2, 0x00, 0xCE, 0x07, 0x06, 0xE0,
  0xE8, 0x0F, 0x20, 0x0D, 0xE0, 0x60, 0x5F, 0x80, 0xF2, 0x00, 0xEE, 0x05, 0x04, 0xF0, 0x18, 0x0F,
  0x10, 0xF0, 0x40, 0x2F, 0x02, 0x80, 0xF0, 0x00, 0x1F, 0x03, 0x1F, 0x04, 0x80, 0xF0, 0x00, 0x3F,
  0x81, 0x10, 0xEE, 0x06, 0x80, 0xF0, 0x00, 0x5E, 0x0E, 0x20, 0xBE, 0x08, 0x80, 0xF0, 0x00, 0x7E,
  0x0C, 0x20, 0x9E, 0x0B, 0x80, 0xF0, 0x00, 0xAE, 0x0A, 0x20, 0x6E, 0x0E, 0x80, 0xF0, 0x00, 0xDE,
  0x07, 0x20, 0x3F, 0x02, 0x80, 0xE6, 0x00, 0x1F, 0x04, 0x3F, 0x06, 0x80, 0xE6, 0x00, 0x4F, 0x40,
  0xCE, 0x0A, 0x80, 0xE6, 0x00, 0x8E, 0x0C, 0x40, 0x8E, 0x0E, 0x80, 0xE6, 0x00, 0xCE, 0x08, 0x40,
  0x3F, 0x03, 0x80, 0xE4, 0x00, 0x1F, 0x04, 0x50, 0xEE, 0x09, 0x80, 0xE4, 0x00, 0x7E, 0x0E, 0x60,
  0x9E, 0x0E, 0x80, 0xE4, 0x00, 0xCE, 0x09, 0x60, 0x4F, 0x05, 0x80, 0xE2, 0x00, 0x3F, 0x04, 0x70,
  0xDE, 0x0B, 0x80, 0xE2, 0x00, 0x9E, 0x0D, 0x71, 0x08, 0xF0, 0x38, 0x0E, 0x00, 0x01, 0xF0, 0x77,
  0x10, 0x1F, 0x0B, 0x80, 0xE0, 0x00, 0x9F, 0x01, 0x72, 0x09, 0xF0, 0x48, 0x0D, 0x60, 0x02, 0xF0,
  0x97, 0x30, 0x2F, 0x0D, 0x80, 0xD6, 0x00, 0xBF, 0x02, 0x74, 0x09, 0xF0, 0x88, 0x0D, 0x40, 0x06,
  0xF0, 0x87, 0x50, 0x10, 0xEF, 0x04, 0x80, 0xD2, 0x00, 0x20, 0xEE, 0x0E, 0x01, 0x76, 0x06, 0xF0,
  0xE0, 0x28, 0x0D, 0x00, 0x01, 0x0D, 0xF0, 0x57, 0x71, 0x0B, 0xF0, 0xD0, 0x18, 0x0C, 0x70, 0x0B,
  0xF0, 0xB7, 0x72, 0x02, 0x0E, 0xF0, 0xD0, 0x18, 0x0C, 0x50, 0x0B, 0xF0, 0xE0, 0x17, 0x73, 0x04,
  0xF9, 0x0D, 0x02, 0x80, 0xC2, 0x00, 0x10, 0xCF, 0x90, 0x37, 0x75, 0x07, 0xF9, 0x0E, 0x05, 0x80,
  0xC0, 0x00, 0x30, 0xDF, 0x90, 0x67, 0x77, 0x08, 0xFA, 0x09, 0x01, 0x77, 0x77, 0x50, 0x7F, 0xA0,
  0x77, 0x77, 0x20, 0x9F, 0xA0, 0xE0, 0x67, 0x77, 0x72, 0x04, 0x0D, 0xFA, 0x07, 0x77, 0x74, 0x08,
  0xFB, 0x81, 0xD6, 0x17, 0x77, 0x40, 0x50, 0xCF, 0xB0, 0x77, 0x77, 0x60, 0x5F, 0xD8, 0x1A, 0x51,
  0x77, 0x58, 0x14, 0x9E, 0xFB, 0x0E, 0x04, 0x77, 0x77, 0x10, 0x30, 0xDF, 0xE8, 0x4C, 0x96, 0x42,
  0x16, 0x84, 0x12, 0x46, 0x8C, 0xFE, 0x0C, 0x02, 0x77, 0x77, 0x40, 0x9F, 0xFE, 0x00, 0xEF, 0xFE,
  0x08, 0x77, 0x77, 0x70, 0x30, 0xC8, 0x0C, 0x2F, 0x0B, 0x02, 0x80, 0xC2, 0x00, 0x40, 0xCF, 0xFF,
  0xFE, 0x0B, 0x03, 0x80, 0xC6, 0x08, 0x13, 0x9E, 0xFF, 0xFF, 0x81, 0xE9, 0x38, 0x0D, 0x30, 0x81,
  0x49, 0xDF, 0xFF, 0x98, 0x1D, 0x94, 0x80, 0xE1, 0x08, 0x41, 0x47, 0xAC, 0xDF, 0xB8, 0x4D, 0xCA,
  0x74, 0x18, 0x0F, 0x30, 0x0F, 0x10, 0x20, 0x30, 0xF1, 0x77, 0x77, 0x70,
  // "Õ" (U+00D5)
  0x77, 0x73, 0x87, 0x26, 0xAB, 0xDC, 0xA7, 0x37, 0x76, 0x05, 0xC0, 0x38, 0x0C, 0x50, 0x02, 0x0A,
  0xFA, 0x0C, 0x04, 0x77, 0x40, 0x8C, 0x01, 0x80, 0xC4, 0x00, 0x6F, 0xE0, 0xA0, 0x27, 0x72, 0x0C,
  0xB0, 0xE8, 0x0C, 0x40, 0x06, 0xFF, 0x90, 0xE0, 0x67, 0x70, 0x2C, 0x0B, 0x80, 0xC3, 0x00, 0x4F,
  0xFC, 0x0B, 0x01, 0x75, 0x09, 0xC0, 0x78, 0x0C, 0x30, 0x0D, 0xF8, 0x1D, 0xCD, 0xFA, 0x0E, 0x05,
  0x73, 0x03, 0xD0, 0x38, 0x0C, 0x20, 0x07, 0xD0, 0xD0, 0x64, 0x81, 0x16, 0xDF, 0x90, 0xA0, 0x17,
  0x03, 0x0E, 0xC0, 0xC8, 0x0C, 0x30, 0x0D, 0xC0, 0xC0, 0x17, 0x10, 0x7F, 0x98, 0x1E, 0x83, 0x30,
  0x30, 0x9E, 0x05, 0x80, 0xC2, 0x00, 0x4C, 0x0E, 0x01, 0x73, 0x02, 0x0C, 0xFB, 0x0E, 0xF9, 0x0B,
  0x80, 0xC3, 0x00, 0x8C, 0x07, 0x76, 0x08, 0xFF, 0xB0, 0xE0, 0x18, 0x0C, 0x30, 0x0C, 0xC0, 0x17,
  0x70, 0x40, 0xDF, 0xF0, 0xE0, 0x38, 0x0C, 0x40, 0xC0, 0xC7, 0x73, 0x08, 0xFD, 0x0D, 0x02, 0x80,
  0xC4, 0x00, 0x1C, 0x08, 0x77, 0x40, 0x20, 0xAF, 0x90, 0xE0, 0x78, 0x0C, 0x60, 0x84, 0x2B, 0xBB,
  0xB4, 0x77, 0x68, 0x61, 0x58, 0xAB, 0x97, 0x48, 0x09, 0xAC, 0x60, 0x85, 0x36, 0x8A, 0xBD, 0xDC,
  0x86, 0xED, 0xCB, 0x97, 0x52, 0x80, 0xE3, 0x08, 0x14, 0x8C, 0xFF, 0xE8, 0x2E, 0xB7, 0x28, 0x0D,
  0x40, 0x81, 0x39, 0xEF, 0xFF, 0xE8, 0x1D, 0x71, 0x80, 0xC7, 0x00, 0x50, 0xDF, 0xFF, 0xFD, 0x0A,
  0x02, 0x80, 0xC3, 0x00, 0x50, 0xD8, 0x0C, 0x1F, 0x0A, 0x01, 0x77, 0x77, 0x70, 0x20, 0xB8, 0x0C,
  0x5F, 0x07, 0x77, 0x77, 0x50, 0x7F, 0xF9, 0x89, 0x5C, 0xA7, 0x65, 0x33, 0x33, 0x45, 0x68, 0xAC,
  0xFF, 0x0C, 0x02, 0x77, 0x77, 0x10, 0x10, 0xBF, 0xD8, 0x1B, 0x73, 0x77, 0x38, 0x14, 0x8D, 0xFC,
  0x0E, 0x04, 0x77, 0x76, 0x02, 0x0D, 0xFB, 0x81, 0xD7, 0x17, 0x77, 0x28, 0x13, 0x9E, 0xFB, 0x06,
  0x77, 0x74, 0x02, 0x0E, 0xFA, 0x0D, 0x05, 0x77, 0x77, 0x81, 0x18, 0xEF, 0xA0, 0x87, 0x77, 0x20,
  0x30, 0xEF, 0x90, 0xE0, 0x77, 0x77, 0x74, 0x01, 0x0A, 0xFA, 0x07, 0x77, 0x70, 0x20, 0xEF, 0x90,
  0xC0, 0x27, 0x77, 0x77, 0x05, 0x0E, 0xF9, 0x06, 0x77, 0x50, 0x10, 0xDF, 0x90, 0x98, 0x0C, 0x20,
  0x02, 0x0D, 0xF9, 0x04, 0x77, 0x40, 0xBF, 0x90, 0x78, 0x0C, 0x40, 0x01, 0x0D, 0xF0, 0xE0, 0x17,
  0x72, 0x07, 0xF9, 0x06, 0x80, 0xC6, 0x00, 0x10, 0xDF, 0x0B, 0x77, 0x10, 0x2F, 0x90, 0x78, 0x0D,
  0x00, 0x02, 0x0E, 0xF0, 0x67, 0x70, 0xCF, 0x0A, 0x80, 0xD2, 0x00, 0x4F, 0x0E, 0x01, 0x75, 0x06,
  0xF0, 0xD8, 0x0D, 0x40, 0x09, 0xF0, 0x97, 0x50, 0xEF, 0x03, 0x80, 0xD5, 0x00, 0xDF, 0x02, 0x73,
  0x07, 0xF0, 0x88, 0x0D, 0x60, 0x04, 0xF0, 0xA7, 0x30, 0xEE, 0x0E, 0x80, 0xE0, 0x00, 0xBF, 0x02,
  0x71, 0x06, 0xF0, 0x68, 0x0E, 0x00, 0x03, 0xF0, 0x87, 0x10, 0xCE, 0x0E, 0x80, 0xE2, 0x00, 0xBE,
  0x0E, 0x70, 0x3F, 0x07, 0x80, 0xE2, 0x00, 0x5F, 0x05, 0x60, 0x8F, 0x01, 0x80, 0xE3, 0x00, 0xDE,
  0x0A, 0x60, 0xDE, 0x0B, 0x80, 0xE4, 0x00, 0x8F, 0x50, 0x3F, 0x05, 0x80, 0xE4, 0x00, 0x3F, 0x05,
  0x40, 0x7F, 0x01, 0x80, 0xE5, 0x00, 0xDE, 0x09, 0x40, 0xBE, 0x0B, 0x80, 0xE6, 0x00, 0x9E, 0x0D,
  0x4F, 0x07, 0x80, 0xE6, 0x00, 0x5F, 0x01, 0x20, 0x3F, 0x03, 0x80, 0xE6, 0x00, 0x1F, 0x04, 0x20,
  0x6F, 0x80, 0xF0, 0x00, 0xDE, 0x07, 0x20, 0x9E, 0x0C, 0x80, 0xF0, 0x00, 0xAE, 0x0A, 0x20, 0xBE,
  0x09, 0x80, 0xF0, 0x00, 0x8E, 0x0C, 0x20, 0xEE, 0x07, 0x80, 0xF0, 0x00, 0x5F, 0x2F, 0x04, 0x80,
  0xF0, 0x00, 0x3F, 0x01, 0x02, 0xF0, 0x28, 0x0F, 0x00, 0x01, 0xF0, 0x30, 0x4F, 0x01, 0x80, 0xF1,
  0x0F, 0x04, 0x05, 0xF8, 0x0F, 0x20, 0x0E, 0xE0, 0x50, 0x6E, 0x0E, 0x80, 0xF2, 0x00, 0xDE, 0x06,
  0x07, 0xE0, 0xD8, 0x0F, 0x20, 0x0C, 0xE0, 0x07, 0xE0, 0xC8, 0x0F, 0x20, 0x0C, 0xE0, 0x08, 0xE0,
  0xC8, 0x0F, 0x20, 0x0B, 0xE0, 0x08, 0xE0, 0xC8, 0x0F, 0x20, 0x0B, 0xE0, 0x90, 0x8E, 0x0B, 0x80,
  0xF2, 0x00, 0xBE, 0x09, 0x08, 0xE0, 0xC8, 0x0F, 0x20, 0x0B, 0xE0, 0x80, 0x7E, 0x0C, 0x80, 0xF2,
  0x00, 0xBE, 0x08, 0x07, 0xE0, 0xD8, 0x0F, 0x20, 0x0C, 0xE0, 0x70, 0x6E, 0x0E, 0x80, 0xF2, 0x00,
  0xDE, 0x06, 0x05, 0xF8, 0x0F, 0x20, 0x0E, 0xE0, 0x50, 0x4F, 0x01, 0x80, 0xF1, 0x0F, 0x04, 0x02,
  0xF0, 0x28, 0x0F, 0x00, 0x01, 0xF0, 0x31, 0xF0, 0x48, 0x0F, 0x00, 0x03, 0xF8, 0x11, 0x0E, 0xE0,
  0x68, 0x0F, 0x00, 0x05, 0xE0, 0xE2, 0x0B, 0xE0, 0x88, 0x0F, 0x00, 0x07, 0xE0, 0xC2, 0x09, 0xE0,
  0xB8, 0x0F, 0x00, 0x0A, 0xE0, 0xA2, 0x06, 0xE0, 0xE8, 0x0F, 0x00, 0x0D, 0xE0, 0x72, 0x03, 0xF0,
  0x28, 0x0E, 0x60, 0x01, 0xF0, 0x43, 0xF0, 0x68, 0x0E, 0x60, 0x04, 0xF4, 0x0C, 0xE0, 0xA8, 0x0E,
  0x60, 0x08, 0xE0, 0xC4, 0x08, 0xE0, 0xE8, 0x0E, 0x60, 0x0C, 0xE0, 0x84, 0x03, 0xF0, 0x38, 0x0E,
  0x40, 0x01, 0xF0, 0x45, 0x0E, 0xE0, 0x98, 0x0E, 0x40, 0x07, 0xE0, 0xE6, 0x09, 0xE0, 0xE8, 0x0E,
  0x40, 0x0C, 0xE0, 0x96, 0x04, 0xF0, 0x58, 0x0E, 0x20, 0x03, 0xF0, 0x47, 0x0D, 0xE0, 0xB8, 0x0E,
  0x20, 0x09, 0xE0, 0xD7, 0x10, 0x8F, 0x03, 0x80, 0xE0, 0x00, 0x1F, 0x07, 0x71, 0x01, 0xF0, 0xB8,
  0x0E, 0x00, 0x09, 0xF0, 0x17, 0x20, 0x9F, 0x04, 0x80, 0xD6, 0x00, 0x2F, 0x09, 0x73, 0x02, 0xF0,
  0xD8, 0x0D, 0x60, 0x0B, 0xF0, 0x27, 0x40, 0x9F, 0x08, 0x80, 0xD4, 0x00, 0x6F, 0x08, 0x75, 0x01,
  0x0E, 0xF0, 0x48, 0x0D, 0x20, 0x02, 0x0E, 0xE0, 0xE0, 0x17, 0x60, 0x6F, 0x0E, 0x02, 0x80, 0xD0,
  0x00, 0x10, 0xDF, 0x05, 0x77, 0x10, 0xBF, 0x0D, 0x01, 0x80, 0xC7, 0x00, 0xBF, 0x0B, 0x77, 0x20,
  0x20, 0xEF, 0x0D, 0x01, 0x80, 0xC5, 0x00, 0xBF, 0x0E, 0x01, 0x77, 0x30, 0x4F, 0x90, 0xD0, 0x28,
  0x0C, 0x20, 0x01, 0x0C, 0xF9, 0x03, 0x77, 0x50, 0x7F, 0x90, 0xE0, 0x58, 0x0C, 0x00, 0x03, 0x0D,
  0xF9, 0x06, 0x77, 0x70, 0x8F, 0xA0, 0x90, 0x17, 0x77, 0x75, 0x07, 0xFA, 0x07, 0x77, 0x72, 0x09,
  0xFA, 0x0E, 0x06, 0x77, 0x77, 0x20, 0x40, 0xDF, 0xA0, 0x77, 0x77, 0x40, 0x8F, 0xB8, 0x1D, 0x61,
  0x77, 0x74, 0x05, 0x0C, 0xFB, 0x07, 0x77, 0x76, 0x05, 0xFD, 0x81, 0xA5, 0x17, 0x75, 0x81, 0x49,
  0xEF, 0xB0, 0xE0, 0x47, 0x77, 0x71, 0x03, 0x0D, 0xFE, 0x84, 0xC9, 0x64, 0x21, 0x68, 0x41, 0x24,
  0x68, 0xCF, 0xE0, 0xC0, 0x27, 0x77, 0x74, 0x09, 0xFF, 0xE0, 0x0E, 0xFF, 0xE0, 0x87, 0x77, 0x77,
  0x03, 0x0C, 0x80, 0xC2, 0xF0, 0xB0, 0x28, 0x0C, 0x20, 0x04, 0x0C, 0xFF, 0xFF, 0xE0, 0xB0, 0x38,
  0x0C, 0x60, 0x81, 0x39, 0xEF, 0xFF, 0xF8, 0x1E, 0x93, 0x80, 0xD3, 0x08, 0x14, 0x9D, 0xFF, 0xF9,
  0x81, 0xD9, 0x48, 0x0E, 0x10, 0x84, 0x14, 0x7A, 0xCD, 0xFB, 0x84, 0xDC, 0xA7, 0x41, 0x80, 0xF3,
  0x00, 0xF1, 0x02, 0x03, 0x0F, 0x17, 0x77, 0x77,
  // "Ö" (U+00D6)
  0x77, 0x75, 0x81, 0x13, 0x37, 0x76, 0x81, 0x33, 0x18, 0x0D, 0x70, 0x0A, 0xB0, 0xE0, 0x77, 0x72,
  0x06, 0x0E, 0xB0, 0xA0, 0x18, 0x0D, 0x40, 0x09, 0xE0, 0x67, 0x70, 0x4E, 0x0B, 0x80, 0xD4, 0x0F,
  0x0C, 0x77, 0x0A, 0xF0, 0x28, 0x0D, 0x20, 0x03, 0xF9, 0x77, 0x0D, 0xF0, 0x58, 0x0D, 0x20, 0x04,
  0xF9, 0x01, 0x76, 0x0E, 0xF0, 0x68, 0x0D, 0x20, 0x03, 0xF9, 0x77, 0x0E, 0xF0, 0x58, 0x0D, 0x20,
  0x01, 0xF0, 0xD7, 0x70, 0xBF, 0x03, 0x80, 0xD3, 0x00, 0xAE, 0x07, 0x77, 0x06, 0xE0, 0xC8, 0x0D,
  0x40, 0x01, 0x0D, 0xC0, 0xA7, 0x72, 0x09, 0xC0, 0xD0, 0x28, 0x0D, 0x60, 0x82, 0x46, 0x63, 0x77,
  0x48, 0x23, 0x66, 0x48, 0x09, 0xE9, 0x60, 0x85, 0x36, 0x8A, 0xBD, 0xDC, 0x86, 0xED, 0xCB, 0x97,
  0x52, 0x80, 0xE3, 0x08, 0x14, 0x8C, 0xFF, 0xE8, 0x2E, 0xB7, 0x28, 0x0D, 0x40, 0x81, 0x39, 0xEF,
  0xFF, 0xE8, 0x1D, 0x71, 0x80, 0xC7, 0x00, 0x50, 0xDF, 0xFF, 0xFD, 0x0A, 0x02, 0x80, 0xC3, 0x00,
  0x50, 0xD8, 0x0C, 0x1F, 0x0A, 0x01, 0x77, 0x77, 0x70, 0x20, 0xB8, 0x0C, 0x5F, 0x07, 0x77, 0x77,
  0x50, 0x7F, 0xF9, 0x89, 0x5C, 0xA7, 0x65, 0x33, 0x33, 0x45, 0x68, 0xAC, 0xFF, 0x0C, 0x02, 0x77,
  0x77, 0x10, 0x10, 0xBF, 0xD8, 0x1B, 0x73, 0x77, 0x38, 0x14, 0x8D, 0xFC, 0x0E, 0x04, 0x77, 0x76,
  0x02, 0x0D, 0xFB, 0x81, 0xD7, 0x17, 0x77, 0x28, 0x13, 0x9E, 0xFB, 0x06, 0x77, 0x74, 0x02, 0x0E,
  0xFA, 0x0D, 0x05, 0x77, 0x77, 0x81, 0x18, 0xEF, 0xA0, 0x87, 0x77, 0x20, 0x30, 0xEF, 0x90, 0xE0,
  0x77, 0x77, 0x74, 0x01, 0x0A, 0xFA, 0x07, 0x77, 0x70, 0x20, 0xEF, 0x90, 0xC0, 0x27, 0x77, 0x77,
  0x05, 0x0E, 0xF9, 0x06, 0x77, 0x50, 0x10, 0xDF, 0x90, 0x98, 0x0C, 0x20, 0x02, 0x0D, 0xF9, 0x04,
  0x77, 0x40, 0xBF, 0x90, 0x78, 0x0C, 0x40, 0x01, 0x0D, 0xF0, 0xE0, 0x17, 0x72, 0x07, 0xF9, 0x06,
  0x80, 0xC6, 0x00, 0x10, 0xDF, 0x0B, 0x77, 0x10, 0x2F, 0x90, 0x78, 0x0D, 0x00, 0x02, 0x0E, 0xF0,
  0x67, 0x70, 0xCF, 0x0A, 0x80, 0xD2, 0x00, 0x4F, 0x0E, 0x01, 0x75, 0x06, 0xF0, 0xD8, 0x0D, 0x40,
  0x09, 0xF0, 0x97, 0x50, 0xEF, 0x03, 0x80, 0xD5, 0x00, 0xDF, 0x02, 0x73, 0x07, 0xF0, 0x88, 0x0D,
  0x60, 0x04, 0xF0, 0xA7, 0x30, 0xEE, 0x0E, 0x80, 0xE0, 0x00, 0xBF, 0x02, 0x71, 0x06, 0xF0, 0x68,
  0x0E, 0x00, 0x03, 0xF0, 0x87, 0x10, 0xCE, 0x0E, 0x80, 0xE2, 0x00, 0xBE, 0x0E, 0x70, 0x3F, 0x07,
  0x80, 0xE2, 0x00, 0x5F, 0x05, 0x60, 0x8F, 0x01, 0x80, 0xE3, 0x00, 0xDE, 0x0A, 0x60, 0xDE, 0x0B,
  0x80, 0xE4, 0x00, 0x8F, 0x50, 0x3F, 0x05, 0x80, 0xE4, 0x00, 0x3F, 0x05, 0x40, 0x7F, 0x01, 0x80,
  0xE5, 0x00, 0xDE, 0x09, 0x40, 0xBE, 0x0B, 0x80, 0xE6, 0x00, 0x9E, 0x0D, 0x4F, 0x07, 0x80, 0xE6,
  0x00, 0x5F, 0x01, 0x20, 0x3F, 0x03, 0x80, 0xE6, 0x00, 0x1F, 0x04, 0x20, 0x6F, 0x80, 0xF0, 0x00,
  0xDE, 0x07, 0x20, 0x9E, 0x0C, 0x80, 0xF0, 0x00, 0xAE, 0x0A, 0x20, 0xBE, 0x09, 0x80, 0xF0, 0x00,
  0x8E, 0x0C, 0x20, 0xEE, 0x07, 0x80, 0xF0, 0x00, 0x5F, 0x2F, 0x04, 0x80, 0xF0, 0x00, 0x3F, 0x01,
  0x02, 0xF0, 0x28, 0x0F, 0x00, 0x01, 0xF0, 0x30, 0x4F, 0x01, 0x80, 0xF1, 0x0F, 0x04, 0x05, 0xF8,
  0x0F, 0x20, 0x0E, 0xE0, 0x50, 0x6E, 0x0E, 0x80, 0xF2, 0x00, 0xDE, 0x06, 0x07, 0xE0, 0xD8, 0x0F,
  0x20, 0x0C, 0xE0, 0x07, 0xE0, 0xC8, 0x0F, 0x20, 0x0C, 0xE0, 0x08, 0xE0, 0xC8, 0x0F, 0x20, 0x0B,
  0xE0, 0x08, 0xE0, 0xC8, 0x0F, 0x20, 0x0B, 0xE0, 0x90, 0x8E, 0x0B, 0x80, 0xF2, 0x00, 0xBE, 0x09,
  0x08, 0xE0, 0xC8, 0x0F, 0x20, 0x0B, 0xE0, 0x80, 0x7E, 0x0C, 0x80, 0xF2, 0x00, 0xBE, 0x08, 0x07,
  0xE0, 0xD8, 0x0F, 0x20, 0x0C, 0xE0, 0x70, 0x6E, 0x0E, 0x80, 0xF2, 0x00, 0xDE, 0x06, 0x05, 0xF8,
  0x0F, 0x20, 0x0E, 0xE0, 0x50, 0x4F, 0x01, 0x80, 0xF1, 0x0F, 0x04, 0x02, 0xF0, 0x28, 0x0F, 0x00,
  0x01, 0xF0, 0x31, 0xF0, 0x48, 0x0F, 0x00, 0x03, 0xF8, 0x11, 0x0E, 0xE0, 0x68, 0x0F, 0x00, 0x05,
  0xE0, 0xE2, 0x0B, 0xE0, 0x88, 0x0F, 0x00, 0x07, 0xE0, 0xC2, 0x09, 0xE0, 0xB8, 0x0F, 0x00, 0x0A,
  0xE0, 0xA2, 0x06, 0xE0, 0xE8, 0x0F, 0x00, 0x0D, 0xE0, 0x72, 0x03, 0xF0, 0x28, 0x0E, 0x60, 0x01,
  0xF0, 0x43, 0xF0, 0x68, 0x0E, 0x60, 0x04, 0xF4, 0x0C, 0xE0, 0xA8, 0x0E, 0x60, 0x08, 0xE0, 0xC4,
  0x08, 0xE0, 0xE8, 0x0E, 0x60, 0x0C, 0xE0, 0x84, 0x03, 0xF0, 0x38, 0x0E, 0x40, 0x01, 0xF0, 0x45,
  0x0E, 0xE0, 0x98, 0x0E, 0x40, 0x07, 0xE0, 0xE6, 0x09, 0xE0, 0xE8, 0x0E, 0x40, 0x0C, 0xE0, 0x96,
  0x04, 0xF0, 0x58, 0x0E, 0x20, 0x03, 0xF0, 0x47, 0x0D, 0xE0, 0xB8, 0x0E, 0x20, 0x09, 0xE0, 0xD7,
  0x10, 0x8F, 0x03, 0x80, 0xE0, 0x00, 0x1F, 0x07, 0x71, 0x01, 0xF0, 0xB8, 0x0E, 0x00, 0x09, 0xF0,
  0x17, 0x20, 0x9F, 0x04, 0x80, 0xD6, 0x00, 0x2F, 0x09, 0x73, 0x02, 0xF0, 0xD8, 0x0D, 0x60, 0x0B,
  0xF0, 0x27, 0x40, 0x9F, 0x08, 0x80, 0xD4, 0x00, 0x6F, 0x08, 0x75, 0x01, 0x0E, 0xF0, 0x48, 0x0D,
  0x20, 0x02, 0x0E, 0xE0, 0xE0, 0x17, 0x60, 0x6F, 0x0E, 0x02, 0x80, 0xD0, 0x00, 0x10, 0xDF, 0x05,
  0x77, 0x10, 0xBF, 0x0D, 0x01, 0x80, 0xC7, 0x00, 0xBF, 0x0B, 0x77, 0x20, 0x20, 0xEF, 0x0D, 0x01,
  0x80, 0xC5, 0x00, 0xBF, 0x0E, 0x01, 0x77, 0x30, 0x4F, 0x90, 0xD0, 0x28, 0x0C, 0x20, 0x01, 0x0C,
  0xF9, 0x03, 0x77, 0x50, 0x7F, 0x90, 0xE0, 0x58, 0x0C, 0x00, 0x03, 0x0D, 0xF9, 0x06, 0x77, 0x70,
  0x8F, 0xA0, 0x90, 0x17, 0x77, 0x75, 0x07, 0xFA, 0x07, 0x77, 0x72, 0x09, 0xFA, 0x0E, 0x06, 0x77,
  0x77, 0x20, 0x40, 0xDF, 0xA0, 0x77, 0x77, 0x40, 0x8F, 0xB8, 0x1D, 0x61, 0x77, 0x74, 0x05, 0x0C,
  0xFB, 0x07, 0x77, 0x76, 0x05, 0xFD, 0x81, 0xA5, 0x17, 0x75, 0x81, 0x49, 0xEF, 0xB0, 0xE0, 0x47,
  0x77, 0x71, 0x03, 0x0D, 0xFE, 0x84, 0xC9, 0x64, 0x21, 0x68, 0x41, 0x24, 0x68, 0xCF, 0xE0, 0xC0,
  0x27, 0x77, 0x74, 0x09, 0xFF, 0xE0, 0x0E, 0xFF, 0xE0, 0x87, 0x77, 0x77, 0x03, 0x0C, 0x80, 0xC2,
  0xF0, 0xB0, 0x28, 0x0C, 0x20, 0x04, 0x0C, 0xFF, 0xFF, 0xE0, 0xB0, 0x38, 0x0C, 0x60, 0x81, 0x39,
  0xEF, 0xFF, 0xF8, 0x1E, 0x93, 0x80, 0xD3, 0x08, 0x14, 0x9D, 0xFF, 0xF9, 0x81, 0xD9, 0x48, 0x0E,
  0x10, 0x84, 0x14, 0x7A, 0xCD, 0xFB, 0x84, 0xDC, 0xA7, 0x41, 0x80, 0xF3, 0x00, 0xF1, 0x02, 0x03,
  0x0F, 0x17, 0x77, 0x77,
  // "×" (U+00D7)
  0x40, 0x28, 0x0C, 0x70, 0x02, 0x68, 0x1A, 0xE3, 0x80, 0xC5, 0x08, 0x19, 0xE3, 0x40, 0xAA, 0x0E,
  0x03, 0x80, 0xC3, 0x00, 0x9A, 0x0E, 0x02, 0x20, 0xAC, 0x0E, 0x03, 0x80, 0xC1, 0x00, 0x9C, 0x81,
  0xE2, 0x8E, 0x0E, 0x02, 0x77, 0x77, 0x70, 0x9E, 0x81, 0xD2, 0xDE, 0x0E, 0x02, 0x77, 0x77, 0x50,
  0x9F, 0x82, 0x60, 0x2D, 0xE0, 0xE0, 0x27, 0x77, 0x73, 0x09, 0xF0, 0x63, 0x02, 0x0D, 0xE0, 0xE0,
  0x27, 0x77, 0x71, 0x09, 0xF0, 0x65, 0x02, 0x0D, 0xE0, 0xE0, 0x27, 0x77, 0x60, 0x9F, 0x06, 0x70,
  0x20, 0xDE, 0x0E, 0x02, 0x77, 0x74, 0x09, 0xF0, 0x67, 0x20, 0x20, 0xDE, 0x0E, 0x02, 0x77, 0x72,
  0x09, 0xF0, 0x67, 0x40, 0x20, 0xDE, 0x0E, 0x02, 0x77, 0x70, 0x9F, 0x06, 0x76, 0x02, 0x0D, 0xE0,
  0xE0, 0x27, 0x75, 0x09, 0xF0, 0x67, 0x71, 0x02, 0x0D, 0xE0, 0xE0, 0x27, 0x73, 0x09, 0xF0, 0x67,
  0x73, 0x02, 0x0D, 0xE0, 0xE0, 0x27, 0x71, 0x09, 0xF0, 0x67, 0x75, 0x02, 0x0D, 0xE0, 0xD0, 0x27,
  0x60, 0x9F, 0x06, 0x77, 0x70, 0x20, 0xDE, 0x0D, 0x02, 0x74, 0x09, 0xF0, 0x67, 0x77, 0x20, 0x20,
  0xDE, 0x0D, 0x02, 0x72, 0x09, 0xF0, 0x67, 0x77, 0x40, 0x20, 0xDE, 0x0D, 0x02, 0x70, 0x9F, 0x06,
  0x77, 0x76, 0x02, 0x0D, 0xE0, 0xD0, 0x25, 0x09, 0xF0, 0x67, 0x77, 0x71, 0x02, 0x0D, 0xE0, 0xD0,
  0x23, 0x09, 0xF0, 0x67, 0x77, 0x73, 0x02, 0x0D, 0xE8, 0x2D, 0x20, 0x9F, 0x06, 0x77, 0x77, 0x50,
  0x20, 0xDE, 0x0D, 0x0A, 0xF0, 0x67, 0x77, 0x77, 0x02, 0x0D, 0xFE, 0x06, 0x80, 0xC1, 0x00, 0x20,
  0xDF, 0xC0, 0x68, 0x0C, 0x30, 0x02, 0x0D, 0xFA, 0x06, 0x80, 0xC5, 0x00, 0x2F, 0x90, 0x88, 0x0C,
  0x60, 0x0A, 0xF9, 0x0E, 0x03, 0x80, 0xC4, 0x00, 0xAF, 0xB0, 0xE0, 0x38, 0x0C, 0x20, 0x0A, 0xFD,
  0x0E, 0x03, 0x80, 0xC0, 0x00, 0xBF, 0xF0, 0xE0, 0x37, 0x77, 0x76, 0x0B, 0xF0, 0x60, 0x4F, 0x0E,
  0x03, 0x77, 0x77, 0x40, 0xBF, 0x06, 0x20, 0x40, 0xEE, 0x0E, 0x03, 0x77, 0x77, 0x20, 0xBF, 0x06,
  0x40, 0x40, 0xEE, 0x0E, 0x03, 0x77, 0x77, 0x0B, 0xF0, 0x66, 0x04, 0x0E, 0xE0, 0xE0, 0x37, 0x77,
  0x50, 0xBF, 0x06, 0x71, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x77, 0x30, 0xBF, 0x06, 0x73, 0x03, 0x0E,
  0xE0, 0xE0, 0x37, 0x77, 0x10, 0xBF, 0x06, 0x75, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x76, 0x0B, 0xF0,
  0x67, 0x70, 0x30, 0xEE, 0x0E, 0x03, 0x77, 0x40, 0xBF, 0x06, 0x77, 0x20, 0x30, 0xEE, 0x0E, 0x03,
  0x77, 0x20, 0xBF, 0x06, 0x77, 0x40, 0x30, 0xEE, 0x0E, 0x03, 0x77, 0x0B, 0xF0, 0x67, 0x76, 0x03,
  0x0E, 0xE0, 0xE0, 0x37, 0x50, 0xBF, 0x06, 0x77, 0x71, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x30, 0xBF,
  0x06, 0x77, 0x73, 0x03, 0x0E, 0xE0, 0xE0, 0x37, 0x10, 0xBF, 0x06, 0x77, 0x75, 0x03, 0x0E, 0xE0,
  0xE0, 0x36, 0x0B, 0xF0, 0x67, 0x77, 0x70, 0x20, 0xEE, 0x0E, 0x03, 0x40, 0xBF, 0x06, 0x77, 0x77,
  0x20, 0x20, 0xEE, 0x0E, 0x03, 0x20, 0xBF, 0x06, 0x77, 0x77, 0x40, 0x20, 0xEE, 0x81, 0xE3, 0x9F,
  0x06, 0x77, 0x77, 0x60, 0x20, 0xEE, 0x81, 0xE1, 0xDD, 0x06, 0x80, 0xC0, 0x00, 0x20, 0xED, 0x82,
  0x50, 0x1D, 0xB0, 0x68, 0x0C, 0x20, 0x02, 0x0D, 0xB0, 0x53, 0x82, 0x1D, 0xF6, 0x80, 0xC4, 0x08,
  0x22, 0xDF, 0x55, 0x01, 0x05, 0x80, 0xC6, 0x00, 0x20, 0x53,
  // "Ø" (U+00D8)
  0x80, 0xF7, 0x08, 0x12, 0xD5, 0x80, 0x98, 0x70, 0x0C, 0xA0, 0xA0, 0x18, 0x0C, 0x00, 0x85, 0x36,
  0x8A, 0xBD, 0xDC, 0x86, 0xED, 0xCB, 0x96, 0x41, 0x77, 0x30, 0x9C, 0x0D, 0x04, 0x77, 0x77, 0x38,
  0x14, 0x8C, 0xFF, 0xE8, 0x1D, 0x95, 0x76, 0x05, 0xE0, 0xD7, 0x77, 0x78, 0x13, 0x9E, 0xFF, 0xFD,
  0x81, 0xEA, 0x47, 0x20, 0x20, 0xEE, 0x03, 0x77, 0x75, 0x05, 0x0D, 0xFF, 0xFF, 0xC0, 0xD0, 0x67,
  0x0C, 0xE0, 0x77, 0x77, 0x40, 0x50, 0xD8, 0x0C, 0x0F, 0x0E, 0x07, 0x40, 0x8E, 0x0B, 0x77, 0x73,
  0x02, 0x0B, 0x80, 0xC4, 0xF8, 0x2D, 0x40, 0x4E, 0x0E, 0x01, 0x77, 0x72, 0x07, 0xFF, 0x98, 0x95,
  0xCA, 0x76, 0x53, 0x33, 0x34, 0x57, 0x8A, 0xDF, 0xF0, 0xA0, 0xEE, 0x04, 0x77, 0x71, 0x01, 0x0B,
  0xFD, 0x81, 0xB7, 0x37, 0x72, 0x82, 0x15, 0x9E, 0xFF, 0xB0, 0x87, 0x77, 0x10, 0x20, 0xDF, 0xB8,
  0x1D, 0x71, 0x77, 0x72, 0x04, 0x0B, 0xFF, 0x0C, 0x77, 0x71, 0x02, 0x0E, 0xFA, 0x0D, 0x05, 0x77,
  0x77, 0x03, 0x0A, 0xFC, 0x0E, 0x02, 0x77, 0x70, 0x30, 0xEF, 0x90, 0xE0, 0x77, 0x77, 0x74, 0x04,
  0x0D, 0xFA, 0x09, 0x77, 0x70, 0x20, 0xEF, 0x90, 0xC0, 0x27, 0x77, 0x77, 0x0A, 0xFA, 0x05, 0x77,
  0x50, 0x10, 0xDF, 0x90, 0x98, 0x0C, 0x10, 0x02, 0xFB, 0x03, 0x77, 0x40, 0xBF, 0x90, 0x78, 0x0C,
  0x20, 0x0C, 0xFB, 0x0D, 0x01, 0x77, 0x20, 0x7F, 0x90, 0x68, 0x0C, 0x20, 0x08, 0xFD, 0x0A, 0x77,
  0x10, 0x2F, 0x90, 0x78, 0x0C, 0x20, 0x04, 0xFF, 0x05, 0x77, 0x0C, 0xF0, 0xA8, 0x0C, 0x20, 0x01,
  0x0E, 0xE0, 0x8F, 0x0E, 0x01, 0x75, 0x06, 0xF0, 0xD8, 0x0C, 0x30, 0x0B, 0xE8, 0x16, 0x0A, 0xF0,
  0x87, 0x50, 0xEF, 0x03, 0x80, 0xC2, 0x00, 0x7E, 0x0A, 0x20, 0x10, 0xDF, 0x01, 0x73, 0x07, 0xF0,
  0x88, 0x0C, 0x20, 0x03, 0xE0, 0xD0, 0x13, 0x05, 0xF0, 0x97, 0x30, 0xEE, 0x0E, 0x80, 0xC3, 0x00,
  0xDE, 0x04, 0x50, 0xBE, 0x0E, 0x01, 0x71, 0x06, 0xF0, 0x68, 0x0C, 0x20, 0x09, 0xE0, 0x86, 0x03,
  0xF0, 0x77, 0x10, 0xCE, 0x0E, 0x80, 0xC2, 0x00, 0x5E, 0x0C, 0x71, 0x0B, 0xE0, 0xD7, 0x03, 0xF0,
  0x78, 0x0C, 0x10, 0x02, 0x0E, 0xD0, 0xE0, 0x27, 0x10, 0x4F, 0x04, 0x60, 0x8F, 0x01, 0x80, 0xC1,
  0x00, 0xCE, 0x05, 0x73, 0x0D, 0xE0, 0x96, 0x0D, 0xE0, 0xB8, 0x0C, 0x10, 0x08, 0xE0, 0x97, 0x40,
  0x8E, 0x0E, 0x50, 0x3F, 0x05, 0x80, 0xC0, 0x00, 0x4E, 0x0D, 0x75, 0x02, 0xF0, 0x44, 0x07, 0xF0,
  0x17, 0x77, 0x77, 0x01, 0x0D, 0xE0, 0x37, 0x60, 0xDE, 0x08, 0x40, 0xBE, 0x0B, 0x80, 0xC0, 0x00,
  0xAE, 0x07, 0x77, 0x08, 0xE0, 0xC4, 0xF0, 0x77, 0x77, 0x77, 0x06, 0xE0, 0xB7, 0x71, 0x04, 0xF0,
  0x12, 0x03, 0xF0, 0x37, 0x77, 0x76, 0x02, 0xE0, 0xE0, 0x17, 0x71, 0x01, 0xF0, 0x42, 0x06, 0xF7,
  0x77, 0x77, 0x0C, 0xE0, 0x47, 0x73, 0x0D, 0xE0, 0x72, 0x09, 0xE0, 0xC7, 0x77, 0x76, 0x09, 0xE0,
  0x87, 0x74, 0x0A, 0xE0, 0xA2, 0x0B, 0xE0, 0x97, 0x77, 0x75, 0x05, 0xE0, 0xC7, 0x75, 0x07, 0xE0,
  0xC2, 0x0E, 0xE0, 0x77, 0x77, 0x74, 0x01, 0x0E, 0xD0, 0xE0, 0x27, 0x75, 0x05, 0xE0, 0xE2, 0xF0,
  0x47, 0x77, 0x74, 0x0B, 0xE0, 0x67, 0x76, 0x03, 0xF0, 0x10, 0x2F, 0x02, 0x77, 0x77, 0x30, 0x7E,
  0x0A, 0x77, 0x70, 0x1F, 0x03, 0x04, 0xF0, 0x17, 0x77, 0x72, 0x03, 0xE0, 0xD0, 0x17, 0x77, 0x1F,
  0x04, 0x05, 0xF7, 0x77, 0x72, 0x01, 0x0D, 0xE0, 0x37, 0x77, 0x20, 0xEE, 0x00, 0x6E, 0x0E, 0x77,
  0x77, 0x20, 0xAE, 0x07, 0x77, 0x73, 0x0D, 0xE0, 0x07, 0xE0, 0xD7, 0x77, 0x71, 0x06, 0xE0, 0xB7,
  0x77, 0x40, 0xCE, 0x00, 0x7E, 0x0C, 0x77, 0x77, 0x02, 0x0E, 0xD0, 0xE0, 0x17, 0x77, 0x40, 0xBE,
  0x00, 0x8E, 0x0C, 0x77, 0x77, 0x0C, 0xE0, 0x57, 0x77, 0x50, 0xBE, 0x00, 0x8E, 0x0C, 0x77, 0x76,
  0x08, 0xE0, 0x97, 0x77, 0x60, 0xBE, 0x09, 0x08, 0xE0, 0xC7, 0x77, 0x50, 0x4E, 0x0D, 0x77, 0x77,
  0x0B, 0xE0, 0x90, 0x8E, 0x0C, 0x77, 0x74, 0x01, 0x0E, 0xE0, 0x37, 0x77, 0x70, 0xBE, 0x08, 0x07,
  0xE0, 0xC7, 0x77, 0x40, 0xBE, 0x06, 0x77, 0x77, 0x10, 0xBE, 0x08, 0x07, 0xE0, 0xD7, 0x77, 0x30,
  0x7E, 0x0B, 0x77, 0x77, 0x20, 0xCE, 0x07, 0x06, 0xE0, 0xE7, 0x77, 0x20, 0x3E, 0x0E, 0x01, 0x77,
  0x77, 0x20, 0xDE, 0x06, 0x05, 0xF7, 0x77, 0x20, 0xDE, 0x04, 0x77, 0x77, 0x30, 0xEE, 0x05, 0x04,
  0xF0, 0x17, 0x77, 0x09, 0xE0, 0x87, 0x77, 0x74, 0xF0, 0x40, 0x2F, 0x02, 0x77, 0x60, 0x5E, 0x0C,
  0x77, 0x77, 0x40, 0x1F, 0x03, 0x1F, 0x04, 0x77, 0x50, 0x20, 0xED, 0x0E, 0x02, 0x77, 0x77, 0x40,
  0x3F, 0x81, 0x10, 0xEE, 0x07, 0x77, 0x50, 0xCE, 0x05, 0x77, 0x77, 0x50, 0x5E, 0x0E, 0x20, 0xBE,
  0x09, 0x77, 0x40, 0x8E, 0x0A, 0x77, 0x77, 0x60, 0x7E, 0x0C, 0x20, 0x9E, 0x0B, 0x77, 0x30, 0x4E,
  0x0D, 0x77, 0x77, 0x70, 0xAE, 0x0A, 0x20, 0x6E, 0x0E, 0x77, 0x20, 0x10, 0xDE, 0x03, 0x77, 0x77,
  0x70, 0xDE, 0x07, 0x20, 0x3F, 0x02, 0x77, 0x10, 0xAE, 0x07, 0x77, 0x77, 0x70, 0x1F, 0x04, 0x3F,
  0x06, 0x77, 0x06, 0xE0, 0xB8, 0x0C, 0x00, 0x04, 0xF4, 0x0B, 0xE0, 0xA7, 0x60, 0x2E, 0x0E, 0x01,
  0x80, 0xC0, 0x00, 0x8E, 0x0C, 0x40, 0x7E, 0x0E, 0x76, 0x0D, 0xE0, 0x58, 0x0C, 0x10, 0x0C, 0xE0,
  0x84, 0x03, 0xF0, 0x37, 0x40, 0x9E, 0x09, 0x80, 0xC1, 0x00, 0x1F, 0x04, 0x50, 0xEE, 0x09, 0x73,
  0x05, 0xE0, 0xC8, 0x0C, 0x20, 0x07, 0xE0, 0xE6, 0x09, 0xE0, 0xE7, 0x20, 0x10, 0xEE, 0x02, 0x80,
  0xC2, 0x00, 0xCE, 0x09, 0x60, 0x3F, 0x05, 0x71, 0x0B, 0xE0, 0x68, 0x0C, 0x20, 0x03, 0xF0, 0x47,
  0x0D, 0xE0, 0xC7, 0x07, 0xE0, 0xA8, 0x0C, 0x30, 0x09, 0xE0, 0xD7, 0x10, 0x7F, 0x04, 0x50, 0x3E,
  0x0D, 0x01, 0x80, 0xC2, 0x00, 0x1F, 0x07, 0x71, 0x01, 0x0E, 0xE0, 0xC4, 0x01, 0x0D, 0xE0, 0x48,
  0x0C, 0x30, 0x09, 0xF0, 0x17, 0x20, 0x8F, 0x06, 0x30, 0xAE, 0x08, 0x80, 0xC3, 0x00, 0x2F, 0x09,
  0x73, 0x01, 0x0E, 0xE8, 0x2E, 0x10, 0x6E, 0x0C, 0x80, 0xC4, 0x00, 0xBF, 0x02, 0x74, 0x08, 0xF8,
  0x1B, 0x2E, 0xD0, 0xE0, 0x28, 0x0C, 0x30, 0x06, 0xF0, 0x87, 0x60, 0xDF, 0x0E, 0xE0, 0x58, 0x0C,
  0x30, 0x02, 0x0E, 0xE0, 0xE0, 0x17, 0x60, 0x5F, 0xE0, 0x98, 0x0C, 0x30, 0x01, 0x0D, 0xF0, 0x57,
  0x71, 0x0A, 0xFC, 0x0D, 0x80, 0xC4, 0x00, 0xBF, 0x0B, 0x77, 0x20, 0x10, 0xDF, 0xB0, 0x38, 0x0C,
  0x30, 0x0B, 0xF0, 0xE0, 0x17, 0x73, 0x03, 0xFA, 0x09, 0x80, 0xC2, 0x00, 0x10, 0xCF, 0x90, 0x37,
  0x75, 0x06, 0xFA, 0x09, 0x80, 0xC0, 0x00, 0x30, 0xDF, 0x90, 0x67, 0x76, 0x02, 0xFB, 0x0C, 0x03,
  0x77, 0x77, 0x50, 0x7F, 0xA0, 0x77, 0x77, 0x0C, 0xFD, 0x09, 0x02, 0x77, 0x77, 0x10, 0x40, 0xDF,
  0xA0, 0x77, 0x77, 0x08, 0xFF, 0x90, 0xA0, 0x37, 0x77, 0x40, 0x50, 0xCF, 0xB0, 0x77, 0x77, 0x04,
  0xFF, 0xC8, 0x1D, 0x73, 0x77, 0x58, 0x14, 0x9E, 0xFB, 0x0E, 0x04, 0x77, 0x70, 0x10, 0xEE, 0x04,
  0x0A, 0xFE, 0x84, 0xEA, 0x75, 0x31, 0x68, 0x41, 0x24, 0x68, 0xCF, 0xE0, 0xC0, 0x27, 0x77, 0x10,
  0xBE, 0x07, 0x20, 0x50, 0xEF, 0xFD, 0x00, 0xEF, 0xFE, 0x08, 0x77, 0x72, 0x07, 0xE0, 0xB5, 0x08,
  0x80, 0xC2, 0xF0, 0xB0, 0x27, 0x77, 0x20, 0x3E, 0x0E, 0x01, 0x68, 0x11, 0x8E, 0xFF, 0xFF, 0xD0,
  0xB0, 0x37, 0x77, 0x40, 0xDE, 0x05, 0x72, 0x81, 0x17, 0xCF, 0xFF, 0xF8, 0x1E, 0x93, 0x77, 0x75,
  0x09, 0xE0, 0x97, 0x68, 0x12, 0x7B, 0xFF, 0xF9, 0x81, 0xD9, 0x47, 0x77, 0x71, 0x07, 0xD0, 0xD7,
  0x74, 0x83, 0x46, 0x9B, 0xDF, 0xB8, 0x4D, 0xCA, 0x74, 0x17, 0x77, 0x75, 0x02, 0x0C, 0xB0, 0x37,
  0x77, 0x30, 0xF1, 0x02, 0x03, 0x0F, 0x18, 0x0C, 0x60, 0x81, 0x7F, 0x78, 0x09, 0x90, 0x00, 0x28,
  0x09, 0x81, 0x00,
  // "Ù" (U+00D9)
  0x77, 0x30, 0xA8, 0x03, 0xB0, 0x48, 0x0E, 0x40, 0x0A, 0xF0, 0xD8, 0x0E, 0x40, 0x01, 0x0E, 0xF0,
  0x88, 0x0E, 0x40, 0x03, 0xF9, 0x03, 0x80, 0xE4, 0x00, 0x6F, 0x0D, 0x80, 0xE5, 0x00, 0x9F, 0x09,
  0x80, 0xE5, 0x00, 0xBF, 0x05, 0x80, 0xE5, 0x00, 0xCE, 0x0E, 0x02, 0x80, 0xE4, 0x00, 0x10, 0xDE,
  0x0C, 0x80, 0xE5, 0x00, 0x10, 0xDE, 0x09, 0x80, 0xE5, 0x00, 0x20, 0xEE, 0x06, 0x80, 0xE5, 0x00,
  0x20, 0xEE, 0x03, 0x80, 0xE5, 0x00, 0x20, 0xED, 0x0E, 0x01, 0x80, 0xE5, 0x00, 0x20, 0xED, 0x0C,
  0x80, 0xE6, 0x00, 0x20, 0xED, 0x0A, 0x80, 0xE6, 0x00, 0x20, 0xDD, 0x09, 0x80, 0xE6, 0x00, 0x10,
  0xCD, 0x07, 0x80, 0xE6, 0x00, 0x10, 0xBD, 0x06, 0x80, 0xE7, 0x00, 0x9D, 0x03, 0x80, 0xE7, 0x08,
  0x44, 0x55, 0x55, 0x18, 0x09, 0x8B, 0x50, 0x80, 0x3B, 0x80, 0xD6, 0x00, 0x48, 0x02, 0xB0, 0x50,
  0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6,
  0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07,
  0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D,
  0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0,
  0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80,
  0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E,
  0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8,
  0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05,
  0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE,
  0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00,
  0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E,
  0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60,
  0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70,
  0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6,
  0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07,
  0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D,
  0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0,
  0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80,
  0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E,
  0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8,
  0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05,
  0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE,
  0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xDE, 0x01, 0x80, 0xD5,
  0x00, 0x6E, 0x06, 0x0D, 0xE0, 0x18, 0x0D, 0x50, 0x06, 0xE0, 0x50, 0xCE, 0x03, 0x80, 0xD5, 0x00,
  0x7E, 0x05, 0x0A, 0xE0, 0x48, 0x0D, 0x50, 0x09, 0xE0, 0x30, 0x8E, 0x06, 0x80, 0xD5, 0x00, 0xBE,
  0x01, 0x06, 0xE0, 0x98, 0x0D, 0x50, 0x0E, 0xD8, 0x1E, 0x03, 0xE0, 0xC8, 0x0D, 0x40, 0x01, 0xE0,
  0xC2, 0xF8, 0x0D, 0x40, 0x05, 0xE0, 0x82, 0x0D, 0xE0, 0x58, 0x0D, 0x30, 0x09, 0xE0, 0x52, 0x08,
  0xE0, 0x98, 0x0D, 0x30, 0x0E, 0xE0, 0x12, 0x04, 0xE0, 0xE8, 0x0D, 0x20, 0x05, 0xE0, 0xB4, 0x0E,
  0xE0, 0x68, 0x0D, 0x10, 0x0B, 0xE0, 0x74, 0x09, 0xE0, 0xD8, 0x0D, 0x00, 0x03, 0xF0, 0x14, 0x02,
  0xF0, 0x68, 0x0C, 0x70, 0x0C, 0xE0, 0x96, 0x0B, 0xE0, 0xE0, 0x18, 0x0C, 0x50, 0x06, 0xF0, 0x36,
  0x03, 0xF0, 0xB8, 0x0C, 0x40, 0x02, 0xF0, 0xA7, 0x10, 0xAF, 0x08, 0x80, 0xC2, 0x00, 0x10, 0xDF,
  0x01, 0x71, 0x02, 0x0E, 0xF0, 0x78, 0x0C, 0x00, 0x01, 0x0C, 0xF0, 0x77, 0x30, 0x6F, 0x90, 0x87,
  0x77, 0x76, 0x02, 0x0D, 0xF0, 0xB7, 0x50, 0xAF, 0x90, 0xA0, 0x17, 0x77, 0x73, 0x04, 0x0E, 0xF0,
  0xE0, 0x17, 0x60, 0xCF, 0x90, 0xE0, 0x57, 0x77, 0x70, 0x10, 0x9F, 0x90, 0xE0, 0x37, 0x70, 0x10,
  0xDF, 0xA0, 0xC0, 0x57, 0x77, 0x38, 0x11, 0x8E, 0xFA, 0x04, 0x77, 0x20, 0x10, 0xCF, 0xB8, 0x1E,
  0x83, 0x77, 0x48, 0x11, 0x5A, 0xFB, 0x0E, 0x03, 0x77, 0x50, 0xBF, 0xD8, 0x4E, 0xB8, 0x53, 0x17,
  0x83, 0x23, 0x69, 0xCF, 0xD0, 0xD0, 0x27, 0x77, 0x07, 0xFF, 0xE0, 0xDF, 0xFD, 0x09, 0x77, 0x73,
  0x03, 0x0C, 0x80, 0xC0, 0xF0, 0xD0, 0x47, 0x77, 0x60, 0x50, 0xDF, 0xFF, 0xFC, 0x0E, 0x06, 0x77,
  0x77, 0x30, 0x50, 0xBF, 0xFF, 0xF0, 0xC0, 0x57, 0x77, 0x77, 0x81, 0x26, 0xBF, 0xFF, 0x98, 0x1B,
  0x72, 0x80, 0xC5, 0x08, 0x33, 0x69, 0xBD, 0xFB, 0x83, 0xDB, 0x96, 0x38, 0x0D, 0x70, 0x0F, 0x10,
  0x02, 0x0F, 0x17, 0x77, 0x71,
  // "Ú" (U+00DA)
  0x80, 0xC5, 0x08, 0x04, 0xB0, 0x48, 0x0E, 0x30, 0x08, 0xF0, 0xE0, 0x28, 0x0E, 0x20, 0x03, 0xF9,
  0x06, 0x80, 0xE3, 0x00, 0xDF, 0x09, 0x80, 0xE3, 0x00, 0x9F, 0x0B, 0x80, 0xE3, 0x00, 0x4F, 0x0D,
  0x01, 0x80, 0xE2, 0x00, 0x10, 0xEE, 0x0E, 0x02, 0x80, 0xE3, 0x00, 0xBF, 0x03, 0x80, 0xE3, 0x00,
  0x8F, 0x05, 0x80, 0xE3, 0x00, 0x4F, 0x06, 0x80, 0xE3, 0x00, 0x20, 0xEE, 0x07, 0x80, 0xE4, 0x00,
  0xDE, 0x07, 0x80, 0xE4, 0x00, 0xAE, 0x08, 0x80, 0xE4, 0x00, 0x8E, 0x08, 0x80, 0xE4, 0x00, 0x6E,
  0x07, 0x80, 0xE4, 0x00, 0x4E, 0x07, 0x80, 0xE4, 0x00, 0x30, 0xED, 0x06, 0x80, 0xE4, 0x00, 0x20,
  0xEC, 0x0E, 0x04, 0x80, 0xE5, 0x00, 0xCC, 0x0D, 0x03, 0x80, 0xE6, 0x08, 0x44, 0x55, 0x55, 0x18,
  0x09, 0x8C, 0x40, 0x80, 0x3B, 0x80, 0xD6, 0x00, 0x48, 0x02, 0xB0, 0x50, 0xEE, 0x80, 0xD6, 0x00,
  0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E,
  0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60,
  0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70,
  0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6,
  0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07,
  0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D,
  0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0,
  0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80,
  0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E,
  0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8,
  0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05,
  0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE,
  0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00,
  0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E,
  0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60,
  0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70,
  0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6,
  0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07,
  0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D,
  0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0,
  0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80,
  0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E,
  0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xDE, 0x01, 0x80, 0xD5, 0x00, 0x6E, 0x06, 0x0D,
  0xE0, 0x18, 0x0D, 0x50, 0x06, 0xE0, 0x50, 0xCE, 0x03, 0x80, 0xD5, 0x00, 0x7E, 0x05, 0x0A, 0xE0,
  0x48, 0x0D, 0x50, 0x09, 0xE0, 0x30, 0x8E, 0x06, 0x80, 0xD5, 0x00, 0xBE, 0x01, 0x06, 0xE0, 0x98,
  0x0D, 0x50, 0x0E, 0xD8, 0x1E, 0x03, 0xE0, 0xC8, 0x0D, 0x40, 0x01, 0xE0, 0xC2, 0xF8, 0x0D, 0x40,
  0x05, 0xE0, 0x82, 0x0D, 0xE0, 0x58, 0x0D, 0x30, 0x09, 0xE0, 0x52, 0x08, 0xE0, 0x98, 0x0D, 0x30,
  0x0E, 0xE0, 0x12, 0x04, 0xE0, 0xE8, 0x0D, 0x20, 0x05, 0xE0, 0xB4, 0x0E, 0xE0, 0x68, 0x0D, 0x10,
  0x0B, 0xE0, 0x74, 0x09, 0xE0, 0xD8, 0x0D, 0x00, 0x03, 0xF0, 0x14, 0x02, 0xF0, 0x68, 0x0C, 0x70,
  0x0C, 0xE0, 0x96, 0x0B, 0xE0, 0xE0, 0x18, 0x0C, 0x50, 0x06, 0xF0, 0x36, 0x03, 0xF0, 0xB8, 0x0C,
  0x40, 0x02, 0xF0, 0xA7, 0x10, 0xAF, 0x08, 0x80, 0xC2, 0x00, 0x10, 0xDF, 0x01, 0x71, 0x02, 0x0E,
  0xF0, 0x78, 0x0C, 0x00, 0x01, 0x0C, 0xF0, 0x77, 0x30, 0x6F, 0x90, 0x87, 0x77, 0x76, 0x02, 0x0D,
  0xF0, 0xB7, 0x50, 0xAF, 0x90, 0xA0, 0x17, 0x77, 0x73, 0x04, 0x0E, 0xF0, 0xE0, 0x17, 0x60, 0xCF,
  0x90, 0xE0, 0x57, 0x77, 0x70, 0x10, 0x9F, 0x90, 0xE0, 0x37, 0x70, 0x10, 0xDF, 0xA0, 0xC0, 0x57,
  0x77, 0x38, 0x11, 0x8E, 0xFA, 0x04, 0x77, 0x20, 0x10, 0xCF, 0xB8, 0x1E, 0x83, 0x77, 0x48, 0x11,
  0x5A, 0xFB, 0x0E, 0x03, 0x77, 0x50, 0xBF, 0xD8, 0x4E, 0xB8, 0x53, 0x17, 0x83, 0x23, 0x69, 0xCF,
  0xD0, 0xD0, 0x27, 0x77, 0x07, 0xFF, 0xE0, 0xDF, 0xFD, 0x09, 0x77, 0x73, 0x03, 0x0C, 0x80, 0xC0,
  0xF0, 0xD0, 0x47, 0x77, 0x60, 0x50, 0xDF, 0xFF, 0xFC, 0x0E, 0x06, 0x77, 0x77, 0x30, 0x50, 0xBF,
  0xFF, 0xF0, 0xC0, 0x57, 0x77, 0x77, 0x81, 0x26, 0xBF, 0xFF, 0x98, 0x1B, 0x72, 0x80, 0xC5, 0x08,
  0x33, 0x69, 0xBD, 0xFB, 0x83, 0xDB, 0x96, 0x38, 0x0D, 0x70, 0x0F, 0x10, 0x02, 0x0F, 0x17, 0x77,
  0x71,
  // "Û" (U+00DB)
  0x77, 0x77, 0x18, 0x02, 0x70, 0x68, 0x0E, 0x50, 0x09, 0xF0, 0x48, 0x0E, 0x30, 0x04, 0xF9, 0x0D,
  0x80, 0xE2, 0x00, 0x10, 0xDF, 0xA0, 0x98, 0x0E, 0x10, 0x0A, 0xFC, 0x05, 0x80, 0xD7, 0x00, 0x6F,
  0xD0, 0xE0, 0x28, 0x0D, 0x50, 0x03, 0xF0, 0xBE, 0x0C, 0x80, 0xD4, 0x00, 0x10, 0xDE, 0x81, 0x60,
  0xBE, 0x0A, 0x80, 0xD3, 0x00, 0xBE, 0x08, 0x20, 0x10, 0xCE, 0x07, 0x80, 0xD1, 0x00, 0x8E, 0x09,
  0x40, 0x10, 0xDE, 0x04, 0x80, 0xC7, 0x00, 0x5E, 0x0A, 0x60, 0x20, 0xED, 0x0E, 0x02, 0x80, 0xC5,
  0x00, 0x3E, 0x0B, 0x71, 0x03, 0x0E, 0xD0, 0xD0, 0x18, 0x0C, 0x30, 0x02, 0x0E, 0xD0, 0xC7, 0x30,
  0x4E, 0x0B, 0x80, 0xC2, 0x00, 0x10, 0xDD, 0x0C, 0x01, 0x74, 0x04, 0xE0, 0x98, 0x0C, 0x10, 0x0B,
  0xD0, 0xC0, 0x17, 0x60, 0x40, 0xED, 0x07, 0x77, 0x77, 0x70, 0xAD, 0x0C, 0x01, 0x77, 0x10, 0x40,
  0xED, 0x05, 0x77, 0x77, 0x50, 0x8D, 0x0B, 0x77, 0x40, 0x30, 0xED, 0x04, 0x77, 0x77, 0x30, 0x7D,
  0x0A, 0x77, 0x60, 0x20, 0xDC, 0x0E, 0x03, 0x77, 0x77, 0x10, 0x3D, 0x08, 0x77, 0x71, 0x01, 0x0C,
  0xC0, 0xE7, 0x77, 0x71, 0x84, 0x15, 0x55, 0x54, 0x77, 0x74, 0x80, 0x15, 0x80, 0x98, 0xA3, 0x08,
  0x03, 0xB8, 0x0D, 0x60, 0x04, 0x80, 0x2B, 0x05, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE,
  0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00,
  0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E,
  0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60,
  0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70,
  0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6,
  0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07,
  0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D,
  0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0,
  0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80,
  0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E,
  0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8,
  0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05,
  0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE,
  0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00,
  0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E,
  0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60,
  0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70,
  0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6,
  0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07,
  0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D,
  0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0,
  0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80,
  0xD6, 0x00, 0x5E, 0x07, 0x0D, 0xE0, 0x18, 0x0D, 0x50, 0x06, 0xE0, 0x60, 0xDE, 0x01, 0x80, 0xD5,
  0x00, 0x6E, 0x05, 0x0C, 0xE0, 0x38, 0x0D, 0x50, 0x07, 0xE0, 0x50, 0xAE, 0x04, 0x80, 0xD5, 0x00,
  0x9E, 0x03, 0x08, 0xE0, 0x68, 0x0D, 0x50, 0x0B, 0xE0, 0x10, 0x6E, 0x09, 0x80, 0xD5, 0x00, 0xED,
  0x81, 0xE0, 0x3E, 0x0C, 0x80, 0xD4, 0x00, 0x1E, 0x0C, 0x2F, 0x80, 0xD4, 0x00, 0x5E, 0x08, 0x20,
  0xDE, 0x05, 0x80, 0xD3, 0x00, 0x9E, 0x05, 0x20, 0x8E, 0x09, 0x80, 0xD3, 0x00, 0xEE, 0x01, 0x20,
  0x4E, 0x0E, 0x80, 0xD2, 0x00, 0x5E, 0x0B, 0x40, 0xEE, 0x06, 0x80, 0xD1, 0x00, 0xBE, 0x07, 0x40,
  0x9E, 0x0D, 0x80, 0xD0, 0x00, 0x3F, 0x01, 0x40, 0x2F, 0x06, 0x80, 0xC7, 0x00, 0xCE, 0x09, 0x60,
  0xBE, 0x0E, 0x01, 0x80, 0xC5, 0x00, 0x6F, 0x03, 0x60, 0x3F, 0x0B, 0x80, 0xC4, 0x00, 0x2F, 0x0A,
  0x71, 0x0A, 0xF0, 0x88, 0x0C, 0x20, 0x01, 0x0D, 0xF0, 0x17, 0x10, 0x20, 0xEF, 0x07, 0x80, 0xC0,
  0x00, 0x10, 0xCF, 0x07, 0x73, 0x06, 0xF9, 0x08, 0x77, 0x77, 0x60, 0x20, 0xDF, 0x0B, 0x75, 0x0A,
  0xF9, 0x0A, 0x01, 0x77, 0x77, 0x30, 0x40, 0xEF, 0x0E, 0x01, 0x76, 0x0C, 0xF9, 0x0E, 0x05, 0x77,
  0x77, 0x01, 0x09, 0xF9, 0x0E, 0x03, 0x77, 0x01, 0x0D, 0xFA, 0x0C, 0x05, 0x77, 0x73, 0x81, 0x18,
  0xEF, 0xA0, 0x47, 0x72, 0x01, 0x0C, 0xFB, 0x81, 0xE8, 0x37, 0x74, 0x81, 0x15, 0xAF, 0xB0, 0xE0,
  0x37, 0x75, 0x0B, 0xFD, 0x84, 0xEB, 0x85, 0x31, 0x78, 0x32, 0x36, 0x9C, 0xFD, 0x0D, 0x02, 0x77,
  0x70, 0x7F, 0xFE, 0x0D, 0xFF, 0xD0, 0x97, 0x77, 0x30, 0x30, 0xC8, 0x0C, 0x0F, 0x0D, 0x04, 0x77,
  0x76, 0x05, 0x0D, 0xFF, 0xFF, 0xC0, 0xE0, 0x67, 0x77, 0x73, 0x05, 0x0B, 0xFF, 0xFF, 0x0C, 0x05,
  0x77, 0x77, 0x78, 0x12, 0x6B, 0xFF, 0xF9, 0x81, 0xB7, 0x28, 0x0C, 0x50, 0x83, 0x36, 0x9B, 0xDF,
  0xB8, 0x3D, 0xB9, 0x63, 0x80, 0xD7, 0x00, 0xF1, 0x00, 0x20, 0xF1, 0x77, 0x77, 0x10,
  // "Ü" (U+00DC)
  0x77, 0x60, 0x03, 0x77, 0x68, 0x12, 0x31, 0x80, 0xC2, 0x00, 0x7C, 0x09, 0x77, 0x20, 0x30, 0xDB,
  0x0C, 0x02, 0x77, 0x77, 0x70, 0x5E, 0x09, 0x77, 0x01, 0x0E, 0xD0, 0xE7, 0x77, 0x77, 0x0B, 0xF0,
  0x17, 0x60, 0x7F, 0x06, 0x77, 0x77, 0x60, 0xEF, 0x04, 0x76, 0x09, 0xF0, 0x97, 0x77, 0x76, 0xF9,
  0x05, 0x76, 0x0A, 0xF0, 0xA7, 0x77, 0x76, 0xF9, 0x04, 0x76, 0x0A, 0xF0, 0x97, 0x77, 0x76, 0x0C,
  0xF0, 0x17, 0x60, 0x7F, 0x07, 0x77, 0x77, 0x60, 0x7E, 0x0B, 0x77, 0x02, 0xE0, 0xE0, 0x17, 0x77,
  0x77, 0x0A, 0xC0, 0xC0, 0x17, 0x71, 0x06, 0xC0, 0xE0, 0x58, 0x0C, 0x10, 0x82, 0x36, 0x64, 0x77,
  0x48, 0x31, 0x57, 0x51, 0x80, 0x9C, 0xB3, 0x08, 0x03, 0xB8, 0x0D, 0x60, 0x04, 0x80, 0x2B, 0x05,
  0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D,
  0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0,
  0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80,
  0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E,
  0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8,
  0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05,
  0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE,
  0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00,
  0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E,
  0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60,
  0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70,
  0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6,
  0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07,
  0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D,
  0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0,
  0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80,
  0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E,
  0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8,
  0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05,
  0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE,
  0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00,
  0x5E, 0x07, 0x0E, 0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0E,
  0xE8, 0x0D, 0x60, 0x05, 0xE0, 0x70, 0xEE, 0x80, 0xD6, 0x00, 0x5E, 0x07, 0x0D, 0xE0, 0x18, 0x0D,
  0x50, 0x06, 0xE0, 0x60, 0xDE, 0x01, 0x80, 0xD5, 0x00, 0x6E, 0x05, 0x0C, 0xE0, 0x38, 0x0D, 0x50,
  0x07, 0xE0, 0x50, 0xAE, 0x04, 0x80, 0xD5, 0x00, 0x9E, 0x03, 0x08, 0xE0, 0x68, 0x0D, 0x50, 0x0B,
  0xE0, 0x10, 0x6E, 0x09, 0x80, 0xD5, 0x00, 0xED, 0x81, 0xE0, 0x3E, 0x0C, 0x80, 0xD4, 0x00, 0x1E,
  0x0C, 0x2F, 0x80, 0xD4, 0x00, 0x5E, 0x08, 0x20, 0xDE, 0x05, 0x80, 0xD3, 0x00, 0x9E, 0x05, 0x20,
  0x8E, 0x09, 0x80, 0xD3, 0x00, 0xEE, 0x01, 0x20, 0x4E, 0x0E, 0x80, 0xD2, 0x00, 0x5E, 0x0B, 0x40,
  0xEE, 0x06, 0x80, 0xD1, 0x00, 0xBE, 0x07, 0x40, 0x9E, 0x0D, 0x80, 0xD0, 0x00, 0x3F, 0x01, 0x40,
  0x2F, 0x06, 0x80, 0xC7, 0x00, 0xCE, 0x09, 0x60, 0xBE, 0x0E, 0x01, 0x80, 0xC5, 0x00, 0x6F, 0x03,
  0x60, 0x3F, 0x0B, 0x80, 0xC4, 0x00, 0x2F, 0x0A, 0x71, 0x0A, 0xF0, 0x88, 0x0C, 0x20, 0x01, 0x0D,
  0xF0, 0x17, 0x10, 0x20, 0xEF, 0x07, 0x80, 0xC0, 0x00, 0x10, 0xCF, 0x07, 0x73, 0x06, 0xF9, 0x08,
  0x77, 0x77, 0x60, 0x20, 0xDF, 0x0B, 0x75, 0x0A, 0xF9, 0x0A, 0x01, 0x77, 0x77, 0x30, 0x40, 0xEF,
  0x0E, 0x01, 0x76, 0x0C, 0xF9, 0x0E, 0x05, 0x77, 0x77, 0x01, 0x09, 0xF9, 0x0E, 0x03, 0x77, 0x01,
  0x0D, 0xFA, 0x0C, 0x05, 0x77, 0x73, 0x81, 0x18, 0xEF, 0xA0, 0x47, 0x72, 0x01, 0x0C, 0xFB, 0x81,
  0xE8, 0x37, 0x74, 0x81, 0x15, 0xAF, 0xB0, 0xE0, 0x37, 0x75, 0x0B, 0xFD, 0x84, 0xEB, 0x85, 0x31,
  0x78, 0x32, 0x36, 0x9C, 0xFD, 0x0D, 0x02, 0x77, 0x70, 0x7F, 0xFE, 0x0D, 0xFF, 0xD0, 0x97, 0x77,
  0x30, 0x30, 0xC8, 0x0C, 0x0F, 0x0D, 0x04, 0x77, 0x76, 0x05, 0x0D, 0xFF, 0xFF, 0xC0, 0xE0, 0x67,
  0x77, 0x73, 0x05, 0x0B, 0xFF, 0xFF, 0x0C, 0x05, 0x77, 0x77, 0x78, 0x12, 0x6B, 0xFF, 0xF9, 0x81,
  0xB7, 0x28, 0x0C, 0x50, 0x83, 0x36, 0x9B, 0xDF, 0xB8, 0x3D, 0xB9, 0x63, 0x80, 0xD7, 0x00, 0xF1,
  0x00, 0x20, 0xF1, 0x77, 0x77, 0x10,
  // "Ý" (U+00DD)
  0x80, 0xC4, 0x00, 0x28, 0x04, 0xB0, 0x28, 0x0E, 0x30, 0x0B, 0xF0, 0xD0, 0x18, 0x0E, 0x20, 0x05,
  0xF9, 0x03, 0x80, 0xE2, 0x00, 0x10, 0xEF, 0x07, 0x80, 0xE3, 0x00, 0xBF, 0x09, 0x80, 0xE3, 0x00,
  0x7F, 0x0C, 0x80, 0xE3, 0x00, 0x3F, 0x0D, 0x01, 0x80, 0xE2, 0x00, 0x10, 0xDE, 0x0E, 0x02, 0x80,
  0xE3, 0x00, 0xAE, 0x0E, 0x03, 0x80, 0xE3, 0x00, 0x7F, 0x04, 0x80, 0xE3, 0x00, 0x4F, 0x05, 0x80,
  0xE3, 0x00, 0x20, 0xEE, 0x05, 0x80, 0xE4, 0x00, 0xCE, 0x05, 0x80, 0xE4, 0x00, 0xAE, 0x06, 0x80,
  0xE4, 0x00, 0x8E, 0x05, 0x80, 0xE4, 0x00, 0x6E, 0x05, 0x80, 0xE4, 0x00, 0x4D, 0x0E, 0x04, 0x80,
  0xE4, 0x00, 0x30, 0xEC, 0x0D, 0x03, 0x80, 0xE5, 0x00, 0xEC, 0x0C, 0x01, 0x80, 0xE6, 0x08, 0x01,
  0x58, 0x09, 0x8C, 0x50, 0x09, 0x80, 0x2B, 0x09, 0x80, 0xD4, 0x00, 0x68, 0x03, 0xB0, 0x10, 0x5F,
  0x05, 0x80, 0xD2, 0x00, 0x10, 0xEE, 0x0A, 0x20, 0xCE, 0x0D, 0x80, 0xD2, 0x00, 0x8F, 0x02, 0x20,
  0x4F, 0x06, 0x80, 0xD0, 0x00, 0x10, 0xEE, 0x09, 0x40, 0xBE, 0x0D, 0x80, 0xD0, 0x00, 0x9E, 0x0E,
  0x01, 0x40, 0x2F, 0x07, 0x80, 0xC6, 0x00, 0x2F, 0x07, 0x60, 0x9E, 0x0E, 0x80, 0xC6, 0x00, 0xAE,
  0x0E, 0x70, 0x1F, 0x08, 0x80, 0xC4, 0x00, 0x3F, 0x06, 0x71, 0x08, 0xE0, 0xE0, 0x18, 0x0C, 0x30,
  0x0B, 0xE0, 0xD7, 0x20, 0x10, 0xEE, 0x09, 0x80, 0xC2, 0x00, 0x4F, 0x05, 0x73, 0x07, 0xF0, 0x28,
  0x0C, 0x10, 0x0C, 0xE0, 0xC7, 0x50, 0xDE, 0x0A, 0x80, 0xC0, 0x00, 0x5F, 0x03, 0x75, 0x05, 0xF0,
  0x37, 0x77, 0x77, 0x0D, 0xE0, 0xA7, 0x70, 0xCE, 0x0B, 0x77, 0x77, 0x60, 0x6F, 0x02, 0x77, 0x04,
  0xF0, 0x47, 0x77, 0x75, 0x0D, 0xE0, 0x97, 0x72, 0x0B, 0xE0, 0xC7, 0x77, 0x74, 0x07, 0xE0, 0xE0,
  0x17, 0x72, 0x03, 0xF0, 0x57, 0x77, 0x72, 0x01, 0x0E, 0xE0, 0x87, 0x74, 0x0A, 0xE0, 0xD7, 0x77,
  0x72, 0x08, 0xE0, 0xE7, 0x75, 0x02, 0xF0, 0x67, 0x77, 0x70, 0x10, 0xEE, 0x06, 0x77, 0x60, 0x9E,
  0x0D, 0x77, 0x77, 0x09, 0xE0, 0xD7, 0x77, 0x01, 0x0E, 0xE0, 0x77, 0x77, 0x50, 0x2F, 0x05, 0x77,
  0x71, 0x07, 0xE0, 0xE0, 0x17, 0x77, 0x40, 0xAE, 0x0C, 0x77, 0x73, 0x0E, 0xE0, 0x87, 0x77, 0x30,
  0x3F, 0x04, 0x77, 0x73, 0x06, 0xE0, 0xE0, 0x17, 0x77, 0x20, 0xBE, 0x0B, 0x77, 0x75, 0x0D, 0xE0,
  0x97, 0x77, 0x10, 0x4F, 0x02, 0x77, 0x75, 0x05, 0xF0, 0x27, 0x77, 0x0C, 0xE0, 0x97, 0x77, 0x70,
  0xCE, 0x0A, 0x77, 0x60, 0x5F, 0x01, 0x77, 0x77, 0x03, 0xF0, 0x37, 0x75, 0x0D, 0xE0, 0x87, 0x77,
  0x72, 0x0A, 0xE0, 0xB7, 0x74, 0x06, 0xE0, 0xE0, 0x17, 0x77, 0x72, 0x02, 0xF0, 0x47, 0x73, 0x0D,
  0xE0, 0x77, 0x77, 0x74, 0x09, 0xE0, 0xC7, 0x72, 0x07, 0xE0, 0xD7, 0x77, 0x75, 0x01, 0x0E, 0xE0,
  0x57, 0x70, 0x10, 0xEE, 0x05, 0x77, 0x77, 0x60, 0x8E, 0x0D, 0x77, 0x08, 0xE0, 0xC8, 0x0C, 0x00,
  0x0E, 0xE0, 0x67, 0x50, 0x1F, 0x04, 0x80, 0xC0, 0x00, 0x6E, 0x0D, 0x75, 0x09, 0xE0, 0xB8, 0x0C,
  0x20, 0x0D, 0xE0, 0x77, 0x30, 0x2F, 0x03, 0x80, 0xC2, 0x00, 0x5E, 0x0E, 0x01, 0x72, 0x0A, 0xE0,
  0xA8, 0x0C, 0x40, 0x0C, 0xE0, 0x87, 0x10, 0x3F, 0x02, 0x80, 0xC4, 0x00, 0x4E, 0x0E, 0x01, 0x70,
  0xBE, 0x08, 0x80, 0xC6, 0x00, 0xBE, 0x09, 0x60, 0x4E, 0x0E, 0x01, 0x80, 0xC6, 0x00, 0x2F, 0x02,
  0x50, 0xCE, 0x07, 0x80, 0xD0, 0x00, 0x9E, 0x0A, 0x40, 0x5E, 0x0D, 0x80, 0xD1, 0x00, 0x1F, 0x03,
  0x30, 0xDE, 0x06, 0x80, 0xD2, 0x00, 0x8E, 0x0B, 0x20, 0x6E, 0x0D, 0x80, 0xD3, 0x00, 0x10, 0xEE,
  0x81, 0x40, 0xEE, 0x04, 0x80, 0xD4, 0x00, 0x7E, 0x0C, 0x07, 0xE0, 0xB8, 0x0D, 0x60, 0x0D, 0xFE,
  0x03, 0x80, 0xD6, 0x00, 0x5F, 0xD0, 0xA8, 0x0E, 0x00, 0x0C, 0xFC, 0x02, 0x80, 0xE0, 0x00, 0x4F,
  0xB0, 0x98, 0x0E, 0x20, 0x0B, 0xF9, 0x0E, 0x01, 0x80, 0xE2, 0x00, 0x3F, 0x90, 0x78, 0x0E, 0x40,
  0x0A, 0xE0, 0xE8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03,
  0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0,
  0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8,
  0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E,
  0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50,
  0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03,
  0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0,
  0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8,
  0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E,
  0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB8, 0x0E, 0x50,
  0x03, 0xE0, 0xB8, 0x0E, 0x50, 0x03, 0xE0, 0xB7, 0x77, 0x71,
  // "Þ" (U+00DE)
  0x80, 0x3B, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2,
  0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2,
  0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2,
  0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0E, 0x0E, 0x80, 0xD2, 0x0F, 0x80, 0x93, 0x58,
  0x00, 0x30, 0x01, 0x77, 0x74, 0xFF, 0xFF, 0x98, 0x3D, 0xB9, 0x63, 0x77, 0x5F, 0xFF, 0xFF, 0x81,
  0xB7, 0x27, 0x71, 0x80, 0xC2, 0xF0, 0xC0, 0x57, 0x68, 0x0C, 0x4F, 0x0E, 0x06, 0x74, 0x80, 0xC6,
  0xF0, 0xD0, 0x37, 0x2F, 0x80, 0x92, 0xB0, 0xC0, 0xFD, 0xFF, 0xD0, 0x77, 0x1E, 0x0E, 0x77, 0x68,
  0x32, 0x46, 0x9C, 0xFE, 0x0A, 0x7E, 0x0E, 0x77, 0x74, 0x81, 0x15, 0xAF, 0xC0, 0xA6, 0xE0, 0xE7,
  0x77, 0x78, 0x11, 0x8E, 0xFA, 0x08, 0x5E, 0x0E, 0x77, 0x77, 0x20, 0x10, 0xAF, 0xA0, 0x44, 0xE0,
  0xE7, 0x77, 0x74, 0x05, 0xF9, 0x0D, 0x4E, 0x0E, 0x77, 0x77, 0x50, 0x4F, 0x90, 0x83, 0xE0, 0xE7,
  0x77, 0x76, 0x05, 0xF0, 0xE0, 0x12, 0xE0, 0xE7, 0x77, 0x77, 0x0A, 0xF0, 0x72, 0xE0, 0xE7, 0x77,
  0x77, 0x01, 0x0E, 0xE0, 0xC2, 0xE0, 0xE8, 0x0C, 0x00, 0x08, 0xF0, 0x21, 0xE0, 0xE8, 0x0C, 0x00,
  0x02, 0xF0, 0x61, 0xE0, 0xE8, 0x0C, 0x10, 0x0C, 0xE0, 0x91, 0xE0, 0xE8, 0x0C, 0x10, 0x08, 0xE0,
  0xD1, 0xE0, 0xE8, 0x0C, 0x10, 0x04, 0xF1, 0xE0, 0xE8, 0x0C, 0x10, 0x02, 0xF0, 0x1E, 0x0E, 0x80,
  0xC2, 0x0F, 0x03, 0xE0, 0xE8, 0x0C, 0x20, 0x0E, 0xE0, 0x3E, 0x0E, 0x80, 0xC2, 0x00, 0xEE, 0x04,
  0xE0, 0xE8, 0x0C, 0x20, 0x0D, 0xE0, 0x4E, 0x0E, 0x80, 0xC2, 0x00, 0xEE, 0x03, 0xE0, 0xE8, 0x0C,
  0x20, 0x0E, 0xE0, 0x3E, 0x0E, 0x80, 0xC2, 0x0F, 0x02, 0xE0, 0xE8, 0x0C, 0x10, 0x02, 0xF1, 0xE0,
  0xE8, 0x0C, 0x10, 0x04, 0xE0, 0xD1, 0xE0, 0xE8, 0x0C, 0x10, 0x08, 0xE0, 0xA1, 0xE0, 0xE8, 0x0C,
  0x10, 0x0C, 0xE0, 0x61, 0xE0, 0xE8, 0x0C, 0x00, 0x01, 0xF0, 0x21, 0xE0, 0xE8, 0x0C, 0x00, 0x07,
  0xE0, 0xC2, 0xE0, 0xE8, 0x0C, 0x00, 0x0E, 0xE0, 0x72, 0xE0, 0xE7, 0x77, 0x77, 0x07, 0xE0, 0xE0,
  0x12, 0xE0, 0xE7, 0x77, 0x76, 0x03, 0xF0, 0x83, 0xE0, 0xE7, 0x77, 0x75, 0x01, 0x0D, 0xE0, 0xE0,
  0x13, 0xE0, 0xE7, 0x77, 0x74, 0x01, 0x0D, 0xF0, 0x64, 0xE0, 0xE7, 0x77, 0x73, 0x04, 0x0E, 0xF0,
  0xB5, 0xE0, 0xE7, 0x77, 0x71, 0x02, 0x0A, 0xF9, 0x0D, 0x01, 0x5E, 0x0E, 0x77, 0x76, 0x03, 0x09,
  0xFA, 0x0E, 0x02, 0x6E, 0x0E, 0x77, 0x73, 0x81, 0x37, 0xCF, 0xB0, 0xE0, 0x37, 0xE0, 0xE7, 0x74,
  0x84, 0x13, 0x48, 0xAE, 0xFD, 0x0D, 0x02, 0x71, 0xF8, 0x09, 0x3B, 0x81, 0xCD, 0xEF, 0xFB, 0x0B,
  0x01, 0x72, 0x80, 0xC4, 0xF0, 0xE0, 0x57, 0x48, 0x0C, 0x2F, 0x0E, 0x07, 0x76, 0x80, 0xC0, 0xF0,
  0xC0, 0x67, 0x71, 0xFF, 0xFF, 0xC8, 0x2E, 0xB7, 0x27, 0x73, 0xFF, 0xFD, 0x84, 0xED, 0xB8, 0x63,
  0x77, 0x7E, 0x0E, 0x80, 0x95, 0x30, 0x01, 0x77, 0x76, 0xE0, 0xE8, 0x0D, 0x20, 0xE0, 0xE8, 0x0D,
  0x20, 0xE0, 0xE8, 0x0D, 0x20, 0xE0, 0xE8, 0x0D, 0x20, 0xE0, 0xE8, 0x0D, 0x20, 0xE0, 0xE8, 0x0D,
  0x20, 0xE0, 0xE8, 0x0D, 0x20, 0xE0, 0xE8, 0x0D, 0x20, 0xE0, 0xE8, 0x0D, 0x20, 0xE0, 0xE8, 0x0D,
  0x20, 0xE0, 0xE8, 0x0D, 0x20, 0xE0, 0xE8, 0x0D, 0x20, 0xE0, 0xE8, 0x0D, 0x20, 0xE0, 0xE8, 0x0D,
  0x20, 0xE0, 0xE8, 0x0D, 0x20, 0xE0, 0xE8, 0x0D, 0x20, 0xE0, 0xE8, 0x0D, 0x20, 0xE0, 0xE8, 0x0D,
  0x20, 0xE0, 0xE8, 0x0D, 0x20,
  // "ß" (U+00DF)
  0x77, 0x48, 0x23, 0x57, 0x98, 0x02, 0xB8, 0x3A, 0x97, 0x52, 0x80, 0xC1, 0x08, 0x12, 0x7B, 0xFF,
  0xA8, 0x2E, 0xB6, 0x17, 0x77, 0x73, 0x06, 0x0C, 0xFF, 0xFA, 0x0A, 0x04, 0x77, 0x76, 0x06, 0x0E,
  0xFF, 0xFE, 0x0B, 0x03, 0x77, 0x72, 0x03, 0x0C, 0xFF, 0xFF, 0xB0, 0x77, 0x77, 0x06, 0xFF, 0xFF,
  0xE0, 0xB7, 0x75, 0x08, 0xFC, 0x89, 0x4E, 0xA7, 0x43, 0x11, 0x11, 0x23, 0x58, 0xBF, 0xC0, 0xB7,
  0x73, 0x08, 0xFA, 0x81, 0xE9, 0x37, 0x71, 0x05, 0x0B, 0xFA, 0x09, 0x77, 0x10, 0x5F, 0xA0, 0x80,
  0x17, 0x75, 0x04, 0x0D, 0xF9, 0x05, 0x76, 0x01, 0x0E, 0xF0, 0xD0, 0x27, 0x77, 0x20, 0xAF, 0x0D,
  0x76, 0x0A, 0xF0, 0xB7, 0x77, 0x50, 0xAF, 0x05, 0x74, 0x03, 0xF0, 0xC7, 0x77, 0x70, 0xDE, 0x0B,
  0x74, 0x0A, 0xE0, 0xE0, 0x17, 0x77, 0x70, 0x5F, 0x01, 0x72, 0x01, 0xF0, 0x67, 0x77, 0x72, 0x0E,
  0xE0, 0x47, 0x20, 0x6E, 0x0D, 0x77, 0x77, 0x30, 0xAE, 0x06, 0x72, 0x0A, 0xE0, 0x77, 0x77, 0x73,
  0x07, 0xE0, 0x87, 0x20, 0xDE, 0x02, 0x77, 0x77, 0x30, 0x6E, 0x08, 0x71, 0x01, 0xE0, 0xD7, 0x77,
  0x74, 0x05, 0xE0, 0x87, 0x10, 0x3E, 0x0A, 0x77, 0x77, 0x40, 0x6E, 0x07, 0x71, 0x05, 0xE0, 0x87,
  0x77, 0x74, 0x09, 0xE0, 0x67, 0x10, 0x7E, 0x06, 0x77, 0x77, 0x40, 0xCE, 0x03, 0x71, 0x07, 0xE0,
  0x57, 0x77, 0x73, 0x02, 0xE0, 0xE7, 0x20, 0x8E, 0x04, 0x77, 0x77, 0x30, 0x9E, 0x09, 0x72, 0x08,
  0xE0, 0x47, 0x77, 0x72, 0x04, 0xF0, 0x27, 0x20, 0x8E, 0x04, 0x77, 0x77, 0x10, 0x10, 0xEE, 0x09,
  0x73, 0x08, 0xE0, 0x47, 0x77, 0x70, 0x10, 0xDE, 0x0D, 0x01, 0x73, 0x08, 0xE0, 0x47, 0x77, 0x60,
  0x20, 0xDF, 0x03, 0x74, 0x08, 0xE0, 0x47, 0x77, 0x50, 0x40, 0xEF, 0x05, 0x75, 0x08, 0xE0, 0x47,
  0x77, 0x40, 0x8F, 0x90, 0x57, 0x60, 0x8E, 0x04, 0x77, 0x72, 0x01, 0x0B, 0xF0, 0xE0, 0x47, 0x70,
  0x8E, 0x04, 0x77, 0x71, 0x03, 0x0D, 0xF0, 0xC0, 0x27, 0x71, 0x08, 0xE0, 0x47, 0x77, 0x06, 0xF9,
  0x0A, 0x77, 0x30, 0x8E, 0x04, 0x77, 0x60, 0x7F, 0x90, 0x77, 0x74, 0x08, 0xE0, 0x47, 0x75, 0x06,
  0xF0, 0xE0, 0x47, 0x75, 0x08, 0xE0, 0x47, 0x74, 0x04, 0xF0, 0xD0, 0x27, 0x76, 0x08, 0xE0, 0x47,
  0x74, 0x0D, 0xE0, 0xD0, 0x27, 0x77, 0x08, 0xE0, 0x47, 0x73, 0x07, 0xE0, 0xE0, 0x27, 0x77, 0x10,
  0x8E, 0x04, 0x77, 0x30, 0xEE, 0x05, 0x77, 0x72, 0x08, 0xE0, 0x47, 0x72, 0x03, 0xE0, 0xC7, 0x77,
  0x30, 0x8E, 0x04, 0x77, 0x20, 0x6E, 0x06, 0x77, 0x73, 0x08, 0xE0, 0x47, 0x72, 0x09, 0xE0, 0x37,
  0x77, 0x30, 0x8E, 0x04, 0x77, 0x20, 0x9E, 0x01, 0x77, 0x73, 0x08, 0xE0, 0x47, 0x72, 0x0A, 0xE0,
  0x17, 0x77, 0x30, 0x8E, 0x04, 0x77, 0x20, 0x9E, 0x02, 0x77, 0x73, 0x08, 0xE0, 0x47, 0x72, 0x08,
  0xE0, 0x67, 0x77, 0x30, 0x8E, 0x04, 0x77, 0x20, 0x5E, 0x0B, 0x77, 0x73, 0x08, 0xE0, 0x47, 0x72,
  0x01, 0xF0, 0x47, 0x77, 0x20, 0x8E, 0x04, 0x77, 0x30, 0xCE, 0x0D, 0x01, 0x77, 0x71, 0x08, 0xE0,
  0x47, 0x73, 0x05, 0xF0, 0xD0, 0x17, 0x77, 0x08, 0xE0, 0x47, 0x74, 0x0C, 0xF0, 0xD0, 0x27, 0x76,
  0x08, 0xE0, 0x47, 0x74, 0x02, 0x0E, 0xF0, 0xE0, 0x57, 0x75, 0x08, 0xE0, 0x47, 0x75, 0x03, 0x0E,
  0xF9, 0x09, 0x77, 0x40, 0x8E, 0x04, 0x77, 0x60, 0x30, 0xEF, 0x90, 0xC0, 0x27, 0x72, 0x08, 0xE0,
  0x47, 0x77, 0x03, 0x0D, 0xF9, 0x0E, 0x06, 0x77, 0x10, 0x8E, 0x04, 0x77, 0x71, 0x01, 0x0C, 0xFA,
  0x0B, 0x01, 0x76, 0x08, 0xE0, 0x47, 0x77, 0x30, 0x9F, 0xA0, 0xE0, 0x57, 0x50, 0x8E, 0x04, 0x77,
  0x74, 0x06, 0xFB, 0x09, 0x74, 0x08, 0xE0, 0x47, 0x77, 0x50, 0x20, 0xCF, 0xA0, 0xD0, 0x27, 0x20,
  0x8E, 0x04, 0x77, 0x77, 0x08, 0xFA, 0x0E, 0x04, 0x71, 0x08, 0xE0, 0x47, 0x77, 0x71, 0x04, 0x0E,
  0xFA, 0x07, 0x70, 0x8E, 0x04, 0x77, 0x77, 0x20, 0x10, 0xAF, 0xA0, 0x96, 0x08, 0xE0, 0x47, 0x77,
  0x74, 0x07, 0xFA, 0x08, 0x50, 0x8E, 0x04, 0x77, 0x77, 0x50, 0x40, 0xEF, 0x90, 0x64, 0x08, 0xE0,
  0x47, 0x77, 0x76, 0x02, 0x0D, 0xF0, 0xE0, 0x23, 0x08, 0xE0, 0x47, 0x77, 0x77, 0x01, 0x0D, 0xF0,
  0xB3, 0x08, 0xE0, 0x48, 0x0C, 0x00, 0x01, 0x0D, 0xF0, 0x42, 0x08, 0xE0, 0x48, 0x0C, 0x10, 0x02,
  0x0E, 0xE0, 0xC2, 0x08, 0xE0, 0x48, 0x0C, 0x20, 0x06, 0xF8, 0x12, 0x08, 0xE0, 0x48, 0x0C, 0x30,
  0x0C, 0xE8, 0x17, 0x08, 0xE0, 0x48, 0x0C, 0x30, 0x06, 0xE8, 0x1B, 0x08, 0xE0, 0x48, 0x0C, 0x30,
  0x01, 0xE8, 0x1E, 0x08, 0xE0, 0x48, 0x0C, 0x40, 0x0C, 0xE0, 0x10, 0x8E, 0x04, 0x80, 0xC4, 0x00,
  0x9E, 0x02, 0x08, 0xE0, 0x48, 0x0C, 0x40, 0x08, 0xE0, 0x30, 0x8E, 0x04, 0x80, 0xC4, 0x00, 0x7E,
  0x04, 0x08, 0xE0, 0x48, 0x0C, 0x40, 0x07, 0xE0, 0x30, 0x8E, 0x04, 0x80, 0xC4, 0x00, 0x7E, 0x03,
  0x08, 0xE0, 0x48, 0x0C, 0x40, 0x09, 0xE0, 0x10, 0x8E, 0x04, 0x80, 0xC4, 0x00, 0xCE, 0x10, 0x8E,
  0x04, 0x80, 0xC3, 0x00, 0x1E, 0x81, 0xB0, 0x8E, 0x04, 0x80, 0xC3, 0x00, 0x7E, 0x81, 0x80, 0x8E,
  0x04, 0x80, 0xC2, 0x00, 0x10, 0xEE, 0x81, 0x30, 0x8E, 0x04, 0x80, 0xC2, 0x00, 0xAE, 0x0D, 0x20,
  0x8E, 0x04, 0x72, 0x00, 0x57, 0x77, 0x50, 0x7F, 0x06, 0x20, 0x8E, 0x04, 0x72, 0x82, 0x7F, 0xD6,
  0x77, 0x72, 0x08, 0xF0, 0xC3, 0x08, 0xE0, 0x47, 0x20, 0x7B, 0x81, 0xE9, 0x47, 0x74, 0x03, 0x0C,
  0xF9, 0x03, 0x30, 0x8E, 0x04, 0x72, 0x07, 0xE8, 0x2E, 0xA6, 0x37, 0x48, 0x12, 0x6C, 0xFA, 0x06,
  0x40, 0x8E, 0x04, 0x72, 0x07, 0xFC, 0x89, 0x0D, 0xBA, 0x99, 0x99, 0xAC, 0xEF, 0xC0, 0x85, 0x08,
  0xE0, 0x47, 0x20, 0x7F, 0xFF, 0xFB, 0x07, 0x60, 0x8E, 0x04, 0x72, 0x05, 0xFF, 0xFF, 0x90, 0xD0,
  0x47, 0x08, 0xE0, 0x47, 0x38, 0x11, 0x8E, 0xFF, 0xFB, 0x0E, 0x08, 0x72, 0x08, 0xE0, 0x47, 0x68,
  0x15, 0xAE, 0xFF, 0xD8, 0x1C, 0x71, 0x77, 0x77, 0x68, 0x33, 0x69, 0xBD, 0xFA, 0x83, 0xEC, 0x96,
  0x28, 0x0C, 0x70, 0x0F, 0x18, 0x23, 0x31, 0x17, 0x75,
  // "à" (U+00E0)
  0x74, 0x04, 0x80, 0x3D, 0x0C, 0x01, 0x80, 0xC4, 0x00, 0x10, 0xEF, 0x09, 0x80, 0xC5, 0x00, 0x4F,
  0x90, 0x38, 0x0C, 0x50, 0x08, 0xF0, 0xD8, 0x0C, 0x60, 0x0A, 0xF0, 0x98, 0x0C, 0x60, 0x0C, 0xF0,
  0x48, 0x0C, 0x50, 0x01, 0x0D, 0xE0, 0xE0, 0x18, 0x0C, 0x50, 0x02, 0x0E, 0xE0, 0xC8, 0x0C, 0x60,
  0x03, 0x0E, 0xE0, 0x88, 0x0C, 0x60, 0x04, 0xF0, 0x58, 0x0C, 0x60, 0x05, 0xE0, 0xE0, 0x28, 0x0C,
  0x60, 0x05, 0xE0, 0xD0, 0x18, 0x0C, 0x60, 0x05, 0xE0, 0xB8, 0x0C, 0x70, 0x05, 0xE0, 0x98, 0x0C,
  0x70, 0x05, 0xE0, 0x68, 0x0C, 0x70, 0x04, 0x0E, 0xD0, 0x58, 0x0C, 0x70, 0x03, 0x0E, 0xD0, 0x48,
  0x0C, 0x70, 0x02, 0x0D, 0xC0, 0xE0, 0x38, 0x0C, 0x70, 0x01, 0x0B, 0xC0, 0xD8, 0x0D, 0x10, 0x80,
  0x13, 0x80, 0xDF, 0x50, 0x84, 0x13, 0x68, 0xAB, 0x80, 0x2D, 0x83, 0xBA, 0x85, 0x27, 0x77, 0x71,
  0x82, 0x15, 0x9D, 0xFF, 0xB8, 0x1D, 0x93, 0x77, 0x72, 0x81, 0x16, 0xBF, 0xFF, 0xB0, 0xC0, 0x57,
  0x75, 0x04, 0x0B, 0xFF, 0xFF, 0x90, 0xB0, 0x17, 0x71, 0x06, 0x0D, 0xFF, 0xFF, 0xC0, 0xE0, 0x47,
  0x60, 0xAF, 0xFB, 0x0E, 0x80, 0x0D, 0xFF, 0x05, 0x75, 0x05, 0xFC, 0x83, 0xD9, 0x63, 0x17, 0x82,
  0x24, 0x9D, 0xFB, 0x03, 0x75, 0x0E, 0xF8, 0x1A, 0x51, 0x77, 0x20, 0x40, 0xCF, 0x90, 0xD7, 0x50,
  0x9C, 0x81, 0xC6, 0x17, 0x77, 0x07, 0xF9, 0x08, 0x74, 0x03, 0xA0, 0xA0, 0x37, 0x77, 0x40, 0x4F,
  0x90, 0x17, 0x40, 0x80, 0x27, 0x77, 0x70, 0x6F, 0x08, 0x80, 0xC6, 0x00, 0xAE, 0x0D, 0x80, 0xC6,
  0x00, 0x2F, 0x03, 0x80, 0xC6, 0x00, 0xBE, 0x07, 0x80, 0xC6, 0x00, 0x5E, 0x0B, 0x80, 0xC6, 0x00,
  0x1E, 0x0E, 0x80, 0xC7, 0x00, 0xCE, 0x01, 0x80, 0xC6, 0x00, 0xAE, 0x03, 0x80, 0xC6, 0x00, 0x7E,
  0x05, 0x80, 0xC6, 0x00, 0x6E, 0x06, 0x80, 0xC6, 0x00, 0x5E, 0x06, 0x80, 0xC6, 0x00, 0x4E, 0x07,
  0x80, 0xC6, 0x00, 0x3E, 0x07, 0x80, 0xC6, 0x00, 0x3E, 0x07, 0x80, 0xC6, 0x00, 0x3E, 0x07, 0x80,
  0xC6, 0x00, 0x3E, 0x07, 0x80, 0xC6, 0x00, 0x3E, 0x07, 0x77, 0x77, 0x78, 0x61, 0x12, 0x33, 0x55,
  0x8E, 0x07, 0x77, 0x72, 0x89, 0x02, 0x46, 0x79, 0xAB, 0xCD, 0xDF, 0xFA, 0x07, 0x77, 0x48, 0x23,
  0x7A, 0xDF, 0xFF, 0xE0, 0x77, 0x78, 0x21, 0x6B, 0xEF, 0xFF, 0xFB, 0x07, 0x75, 0x05, 0x0B, 0xFF,
  0xFF, 0xF0, 0x77, 0x30, 0x60, 0xDF, 0xFF, 0xF8, 0x1E, 0xDD, 0xE0, 0x77, 0x10, 0x30, 0xCF, 0xF9,
  0x85, 0xDB, 0x98, 0x75, 0x50, 0xF3, 0x0F, 0x14, 0x03, 0xE0, 0x77, 0x08, 0xFD, 0x82, 0xC8, 0x52,
  0x77, 0x40, 0x3E, 0x07, 0x60, 0xBF, 0xB8, 0x1A, 0x51, 0x77, 0x71, 0x03, 0xE0, 0x74, 0x01, 0x0C,
  0xF9, 0x81, 0xE8, 0x17, 0x77, 0x40, 0x3E, 0x07, 0x40, 0xBF, 0x90, 0x90, 0x17, 0x77, 0x60, 0x3E,
  0x07, 0x30, 0x7F, 0x0E, 0x04, 0x77, 0x77, 0x10, 0x3E, 0x07, 0x20, 0x2F, 0x0E, 0x03, 0x77, 0x77,
  0x20, 0x4E, 0x07, 0x20, 0xAF, 0x04, 0x77, 0x77, 0x30, 0x5E, 0x81, 0x70, 0x2F, 0x08, 0x77, 0x77,
  0x40, 0x6E, 0x81, 0x70, 0x7E, 0x0E, 0x77, 0x77, 0x50, 0x8E, 0x81, 0x70, 0xBE, 0x08, 0x77, 0x77,
  0x50, 0xAE, 0x07, 0x1F, 0x03, 0x77, 0x77, 0x50, 0xDE, 0x07, 0x02, 0xF7, 0x77, 0x75, 0x01, 0xF0,
  0x70, 0x4E, 0x0D, 0x77, 0x77, 0x50, 0x5F, 0x07, 0x04, 0xE0, 0xB7, 0x77, 0x75, 0x09, 0xF0, 0x70,
  0x5E, 0x0B, 0x77, 0x77, 0x50, 0xEF, 0x07, 0x04, 0xE0, 0xB7, 0x77, 0x74, 0x06, 0xF9, 0x07, 0x04,
  0xE0, 0xD7, 0x77, 0x74, 0x0D, 0xF9, 0x07, 0x02, 0xF7, 0x77, 0x73, 0x06, 0xFA, 0x07, 0x1F, 0x04,
  0x77, 0x77, 0x10, 0x20, 0xEF, 0xA8, 0x17, 0x0C, 0xE0, 0x97, 0x77, 0x71, 0x0C, 0xFB, 0x81, 0x70,
  0x8F, 0x01, 0x77, 0x76, 0x0A, 0xC0, 0x90, 0xED, 0x81, 0x70, 0x3F, 0x0A, 0x77, 0x75, 0x0A, 0xC8,
  0x1C, 0x0D, 0xD0, 0x72, 0x0C, 0xF0, 0x87, 0x77, 0x20, 0x10, 0xCD, 0x81, 0x20, 0xBD, 0x07, 0x20,
  0x5F, 0x90, 0x97, 0x77, 0x06, 0x0E, 0xD0, 0x52, 0x09, 0xD0, 0x73, 0x0B, 0xF9, 0x0D, 0x04, 0x77,
  0x30, 0x60, 0xDE, 0x07, 0x30, 0x7D, 0x07, 0x30, 0x10, 0xEF, 0xA8, 0x1C, 0x72, 0x73, 0x82, 0x25,
  0xAE, 0xF0, 0x84, 0x05, 0xD0, 0x74, 0x03, 0x0E, 0xFC, 0x89, 0x0E, 0xCA, 0x99, 0x99, 0xAC, 0xEF,
  0xB0, 0x65, 0x03, 0xD0, 0x75, 0x03, 0x0E, 0xFF, 0xFF, 0x0E, 0x05, 0x60, 0x1D, 0x07, 0x60, 0x10,
  0xCF, 0xFF, 0xD0, 0xC0, 0x17, 0x1D, 0x07, 0x71, 0x06, 0x0E, 0xFF, 0xF9, 0x0D, 0x06, 0x73, 0x0D,
  0xC0, 0x77, 0x30, 0x60, 0xCF, 0xFC, 0x0B, 0x05, 0x75, 0x0B, 0xC0, 0x77, 0x58, 0x31, 0x69, 0xCE,
  0xF9, 0x83, 0xDB, 0x85, 0x18, 0x0C, 0x20, 0x84, 0x12, 0x32, 0x11, 0x77, 0x75,
  // "á" (U+00E1)
  0x77, 0x77, 0x70, 0x68, 0x03, 0xD0, 0xC8, 0x0C, 0x40, 0x01, 0x0E, 0xF0, 0x98, 0x0C, 0x40, 0x0B,
  0xF0, 0xC8, 0x0C, 0x40, 0x06, 0xF0, 0xE0, 0x28, 0x0C, 0x30, 0x02, 0x0E, 0xF0, 0x48, 0x0C, 0x40,
  0x0C, 0xF0, 0x68, 0x0C, 0x40, 0x08, 0xF0, 0x88, 0x0C, 0x40, 0x04, 0xF0, 0xA8, 0x0C, 0x40, 0x01,
  0x0E, 0xE0, 0xB8, 0x0C, 0x50, 0x0C, 0xE0, 0xC8, 0x0C, 0x50, 0x09, 0xE0, 0xD0, 0x18, 0x0C, 0x40,
  0x06, 0xE0, 0xD0, 0x18, 0x0C, 0x40, 0x03, 0xE0, 0xD0, 0x18, 0x0C, 0x40, 0x02, 0x0E, 0xD0, 0xD0,
  0x18, 0x0C, 0x40, 0x01, 0x0D, 0xD0, 0xD0, 0x18, 0x0C, 0x50, 0x0B, 0xD0, 0xC0, 0x18, 0x0C, 0x50,
  0x0A, 0xD0, 0xB8, 0x0C, 0x60, 0x09, 0xD0, 0x98, 0x0C, 0x60, 0x03, 0xD0, 0x78, 0x0C, 0x70, 0x84,
  0x13, 0x33, 0x32, 0x80, 0xE8, 0x40, 0x84, 0x13, 0x68, 0xAB, 0x80, 0x2D, 0x83, 0xBA, 0x85, 0x27,
  0x77, 0x71, 0x82, 0x15, 0x9D, 0xFF, 0xB8, 0x1D, 0x93, 0x77, 0x72, 0x81, 0x16, 0xBF, 0xFF, 0xB0,
  0xC0, 0x57, 0x75, 0x04, 0x0B, 0xFF, 0xFF, 0x90, 0xB0, 0x17, 0x71, 0x06, 0x0D, 0xFF, 0xFF, 0xC0,
  0xE0, 0x47, 0x60, 0xAF, 0xFB, 0x0E, 0x80, 0x0D, 0xFF, 0x05, 0x75, 0x05, 0xFC, 0x83, 0xD9, 0x63,
  0x17, 0x82, 0x24, 0x9D, 0xFB, 0x03, 0x75, 0x0E, 0xF8, 0x1A, 0x51, 0x77, 0x20, 0x40, 0xCF, 0x90,
  0xD7, 0x50, 0x9C, 0x81, 0xC6, 0x17, 0x77, 0x07, 0xF9, 0x08, 0x74, 0x03, 0xA0, 0xA0, 0x37, 0x77,
  0x40, 0x4F, 0x90, 0x17, 0x40, 0x80, 0x27, 0x77, 0x70, 0x6F, 0x08, 0x80, 0xC6, 0x00, 0xAE, 0x0D,
  0x80, 0xC6, 0x00, 0x2F, 0x03, 0x80, 0xC6, 0x00, 0xBE, 0x07, 0x80, 0xC6, 0x00, 0x5E, 0x0B, 0x80,
  0xC6, 0x00, 0x1E, 0x0E, 0x80, 0xC7, 0x00, 0xCE, 0x01, 0x80, 0xC6, 0x00, 0xAE, 0x03, 0x80, 0xC6,
  0x00, 0x7E, 0x05, 0x80, 0xC6, 0x00, 0x6E, 0x06, 0x80, 0xC6, 0x00, 0x5E, 0x06, 0x80, 0xC6, 0x00,
  0x4E, 0x07, 0x80, 0xC6, 0x00, 0x3E, 0x07, 0x80, 0xC6, 0x00, 0x3E, 0x07, 0x80, 0xC6, 0x00, 0x3E,
  0x07, 0x80, 0xC6, 0x00, 0x3E, 0x07, 0x80, 0xC6, 0x00, 0x3E, 0x07, 0x77, 0x77, 0x78, 0x61, 0x12,
  0x33, 0x55, 0x8E, 0x07, 0x77, 0x72, 0x89, 0x02, 0x46, 0x79, 0xAB, 0xCD, 0xDF, 0xFA, 0x07, 0x77,
  0x48, 0x23, 0x7A, 0xDF, 0xFF, 0xE0, 0x77, 0x78, 0x21, 0x6B, 0xEF, 0xFF, 0xFB, 0x07, 0x75, 0x05,
  0x0B, 0xFF, 0xFF, 0xF0, 0x77, 0x30, 0x60, 0xDF, 0xFF, 0xF8, 0x1E, 0xDD, 0xE0, 0x77, 0x10, 0x30,
  0xCF, 0xF9, 0x85, 0xDB, 0x98, 0x75, 0x50, 0xF3, 0x0F, 0x14, 0x03, 0xE0, 0x77, 0x08, 0xFD, 0x82,
  0xC8, 0x52, 0x77, 0x40, 0x3E, 0x07, 0x60, 0xBF, 0xB8, 0x1A, 0x51, 0x77, 0x71, 0x03, 0xE0, 0x74,
  0x01, 0x0C, 0xF9, 0x81, 0xE8, 0x17, 0x77, 0x40, 0x3E, 0x07, 0x40, 0xBF, 0x90, 0x90, 0x17, 0x77,
  0x60, 0x3E, 0x07, 0x30, 0x7F, 0x0E, 0x04, 0x77, 0x77, 0x10, 0x3E, 0x07, 0x20, 0x2F, 0x0E, 0x03,
  0x77, 0x77, 0x20, 0x4E, 0x07, 0x20, 0xAF, 0x04, 0x77, 0x77, 0x30, 0x5E, 0x81, 0x70, 0x2F, 0x08,
  0x77, 0x77, 0x40, 0x6E, 0x81, 0x70, 0x7E, 0x0E, 0x77, 0x77, 0x50, 0x8E, 0x81, 0x70, 0xBE, 0x08,
  0x77, 0x77, 0x50, 0xAE, 0x07, 0x1F, 0x03, 0x77, 0x77, 0x50, 0xDE, 0x07, 0x02, 0xF7, 0x77, 0x75,
  0x01, 0xF0, 0x70, 0x4E, 0x0D, 0x77, 0x77, 0x50, 0x5F, 0x07, 0x04, 0xE0, 0xB7, 0x77, 0x75, 0x09,
  0xF0, 0x70, 0x5E, 0x0B, 0x77, 0x77, 0x50, 0xEF, 0x07, 0x04, 0xE0, 0xB7, 0x77, 0x74, 0x06, 0xF9,
  0x07, 0x04, 0xE0, 0xD7, 0x77, 0x74, 0x0D, 0xF9, 0x07, 0x02, 0xF7, 0x77, 0x73, 0x06, 0xFA, 0x07,
  0x1F, 0x04, 0x77, 0x77, 0x10, 0x20, 0xEF, 0xA8, 0x17, 0x0C, 0xE0, 0x97, 0x77, 0x71, 0x0C, 0xFB,
  0x81, 0x70, 0x8F, 0x01, 0x77, 0x76, 0x0A, 0xC0, 0x90, 0xED, 0x81, 0x70, 0x3F, 0x0A, 0x77, 0x75,
  0x0A, 0xC8, 0x1C, 0x0D, 0xD0, 0x72, 0x0C, 0xF0, 0x87, 0x77, 0x20, 0x10, 0xCD, 0x81, 0x20, 0xBD,
  0x07, 0x20, 0x5F, 0x90, 0x97, 0x77, 0x06, 0x0E, 0xD0, 0x52, 0x09, 0xD0, 0x73, 0x0B, 0xF9, 0x0D,
  0x04, 0x77, 0x30, 0x60, 0xDE, 0x07, 0x30, 0x7D, 0x07, 0x30, 0x10, 0xEF, 0xA8, 0x1C, 0x72, 0x73,
  0x82, 0x25, 0xAE, 0xF0, 0x84, 0x05, 0xD0, 0x74, 0x03, 0x0E, 0xFC, 0x89, 0x0E, 0xCA, 0x99, 0x99,
  0xAC, 0xEF, 0xB0, 0x65, 0x03, 0xD0, 0x75, 0x03, 0x0E, 0xFF, 0xFF, 0x0E, 0x05, 0x60, 0x1D, 0x07,
  0x60, 0x10, 0xCF, 0xFF, 0xD0, 0xC0, 0x17, 0x1D, 0x07, 0x71, 0x06, 0x0E, 0xFF, 0xF9, 0x0D, 0x06,
  0x73, 0x0D, 0xC0, 0x77, 0x30, 0x60, 0xCF, 0xFC, 0x0B, 0x05, 0x75, 0x0B, 0xC0, 0x77, 0x58, 0x31,
  0x69, 0xCE, 0xF9, 0x83, 0xDB, 0x85, 0x18, 0x0C, 0x20, 0x84, 0x12, 0x32, 0x11, 0x77, 0x75,
  // "â" (U+00E2)
  0x77, 0x72, 0x07, 0x80, 0x2B, 0x03, 0x80, 0xC5, 0x00, 0x3F, 0x0D, 0x80, 0xC5, 0x00, 0xDF, 0x90,
  0x88, 0x0C, 0x30, 0x08, 0xFB, 0x03, 0x80, 0xC1, 0x00, 0x4F, 0xC0, 0xD8, 0x0C, 0x00, 0x01, 0x0E,
  0xFD, 0x0A, 0x77, 0x77, 0x70, 0xCE, 0x0A, 0x0E, 0xE0, 0x77, 0x77, 0x75, 0x09, 0xE8, 0x2B, 0x03,
  0xEE, 0x04, 0x77, 0x77, 0x30, 0x6E, 0x0C, 0x30, 0x4E, 0x0E, 0x02, 0x77, 0x77, 0x10, 0x3E, 0x0D,
  0x01, 0x40, 0x6E, 0x0D, 0x01, 0x77, 0x76, 0x01, 0x0E, 0xD0, 0xE0, 0x26, 0x07, 0xE0, 0xB7, 0x77,
  0x60, 0xCD, 0x0E, 0x02, 0x71, 0x08, 0xE0, 0x87, 0x77, 0x40, 0xAD, 0x0E, 0x03, 0x73, 0x09, 0xE0,
  0x57, 0x77, 0x20, 0x9D, 0x0E, 0x04, 0x75, 0x09, 0xE0, 0x37, 0x77, 0x07, 0xD0, 0xE0, 0x37, 0x70,
  0x9D, 0x0E, 0x02, 0x77, 0x50, 0x5D, 0x0E, 0x03, 0x77, 0x20, 0x9D, 0x0D, 0x01, 0x77, 0x30, 0x3D,
  0x0E, 0x03, 0x77, 0x40, 0x8D, 0x0C, 0x77, 0x20, 0x20, 0xEC, 0x0D, 0x02, 0x77, 0x60, 0x6D, 0x0B,
  0x77, 0x10, 0xCC, 0x0B, 0x01, 0x77, 0x71, 0x04, 0x0E, 0xC0, 0x87, 0x78, 0x01, 0x37, 0x77, 0x48,
  0x42, 0x33, 0x33, 0x28, 0x0D, 0xE2, 0x08, 0x41, 0x36, 0x8A, 0xB8, 0x02, 0xD8, 0x3B, 0xA8, 0x52,
  0x77, 0x77, 0x18, 0x21, 0x59, 0xDF, 0xFB, 0x81, 0xD9, 0x37, 0x77, 0x28, 0x11, 0x6B, 0xFF, 0xFB,
  0x0C, 0x05, 0x77, 0x50, 0x40, 0xBF, 0xFF, 0xF9, 0x0B, 0x01, 0x77, 0x10, 0x60, 0xDF, 0xFF, 0xFC,
  0x0E, 0x04, 0x76, 0x0A, 0xFF, 0xB0, 0xE8, 0x00, 0xDF, 0xF0, 0x57, 0x50, 0x5F, 0xC8, 0x3D, 0x96,
  0x31, 0x78, 0x22, 0x49, 0xDF, 0xB0, 0x37, 0x50, 0xEF, 0x81, 0xA5, 0x17, 0x72, 0x04, 0x0C, 0xF9,
  0x0D, 0x75, 0x09, 0xC8, 0x1C, 0x61, 0x77, 0x70, 0x7F, 0x90, 0x87, 0x40, 0x3A, 0x0A, 0x03, 0x77,
  0x74, 0x04, 0xF9, 0x01, 0x74, 0x08, 0x02, 0x77, 0x77, 0x06, 0xF0, 0x88, 0x0C, 0x60, 0x0A, 0xE0,
  0xD8, 0x0C, 0x60, 0x02, 0xF0, 0x38, 0x0C, 0x60, 0x0B, 0xE0, 0x78, 0x0C, 0x60, 0x05, 0xE0, 0xB8,
  0x0C, 0x60, 0x01, 0xE0, 0xE8, 0x0C, 0x70, 0x0C, 0xE0, 0x18, 0x0C, 0x60, 0x0A, 0xE0, 0x38, 0x0C,
  0x60, 0x07, 0xE0, 0x58, 0x0C, 0x60, 0x06, 0xE0, 0x68, 0x0C, 0x60, 0x05, 0xE0, 0x68, 0x0C, 0x60,
  0x04, 0xE0, 0x78, 0x0C, 0x60, 0x03, 0xE0, 0x78, 0x0C, 0x60, 0x03, 0xE0, 0x78, 0x0C, 0x60, 0x03,
  0xE0, 0x78, 0x0C, 0x60, 0x03, 0xE0, 0x78, 0x0C, 0x60, 0x03, 0xE0, 0x77, 0x77, 0x77, 0x86, 0x11,
  0x23, 0x35, 0x58, 0xE0, 0x77, 0x77, 0x28, 0x90, 0x24, 0x67, 0x9A, 0xBC, 0xDD, 0xFF, 0xA0, 0x77,
  0x74, 0x82, 0x37, 0xAD, 0xFF, 0xFE, 0x07, 0x77, 0x82, 0x16, 0xBE, 0xFF, 0xFF, 0xB0, 0x77, 0x50,
  0x50, 0xBF, 0xFF, 0xFF, 0x07, 0x73, 0x06, 0x0D, 0xFF, 0xFF, 0x81, 0xED, 0xDE, 0x07, 0x71, 0x03,
  0x0C, 0xFF, 0x98, 0x5D, 0xB9, 0x87, 0x55, 0x0F, 0x30, 0xF1, 0x40, 0x3E, 0x07, 0x70, 0x8F, 0xD8,
  0x2C, 0x85, 0x27, 0x74, 0x03, 0xE0, 0x76, 0x0B, 0xFB, 0x81, 0xA5, 0x17, 0x77, 0x10, 0x3E, 0x07,
  0x40, 0x10, 0xCF, 0x98, 0x1E, 0x81, 0x77, 0x74, 0x03, 0xE0, 0x74, 0x0B, 0xF9, 0x09, 0x01, 0x77,
  0x76, 0x03, 0xE0, 0x73, 0x07, 0xF0, 0xE0, 0x47, 0x77, 0x71, 0x03, 0xE0, 0x72, 0x02, 0xF0, 0xE0,
  0x37, 0x77, 0x72, 0x04, 0xE0, 0x72, 0x0A, 0xF0, 0x47, 0x77, 0x73, 0x05, 0xE8, 0x17, 0x02, 0xF0,
  0x87, 0x77, 0x74, 0x06, 0xE8, 0x17, 0x07, 0xE0, 0xE7, 0x77, 0x75, 0x08, 0xE8, 0x17, 0x0B, 0xE0,
  0x87, 0x77, 0x75, 0x0A, 0xE0, 0x71, 0xF0, 0x37, 0x77, 0x75, 0x0D, 0xE0, 0x70, 0x2F, 0x77, 0x77,
  0x50, 0x1F, 0x07, 0x04, 0xE0, 0xD7, 0x77, 0x75, 0x05, 0xF0, 0x70, 0x4E, 0x0B, 0x77, 0x77, 0x50,
  0x9F, 0x07, 0x05, 0xE0, 0xB7, 0x77, 0x75, 0x0E, 0xF0, 0x70, 0x4E, 0x0B, 0x77, 0x77, 0x40, 0x6F,
  0x90, 0x70, 0x4E, 0x0D, 0x77, 0x77, 0x40, 0xDF, 0x90, 0x70, 0x2F, 0x77, 0x77, 0x30, 0x6F, 0xA0,
  0x71, 0xF0, 0x47, 0x77, 0x71, 0x02, 0x0E, 0xFA, 0x81, 0x70, 0xCE, 0x09, 0x77, 0x77, 0x10, 0xCF,
  0xB8, 0x17, 0x08, 0xF0, 0x17, 0x77, 0x60, 0xAC, 0x09, 0x0E, 0xD8, 0x17, 0x03, 0xF0, 0xA7, 0x77,
  0x50, 0xAC, 0x81, 0xC0, 0xDD, 0x07, 0x20, 0xCF, 0x08, 0x77, 0x72, 0x01, 0x0C, 0xD8, 0x12, 0x0B,
  0xD0, 0x72, 0x05, 0xF9, 0x09, 0x77, 0x70, 0x60, 0xED, 0x05, 0x20, 0x9D, 0x07, 0x30, 0xBF, 0x90,
  0xD0, 0x47, 0x73, 0x06, 0x0D, 0xE0, 0x73, 0x07, 0xD0, 0x73, 0x01, 0x0E, 0xFA, 0x81, 0xC7, 0x27,
  0x38, 0x22, 0x5A, 0xEF, 0x08, 0x40, 0x5D, 0x07, 0x40, 0x30, 0xEF, 0xC8, 0x90, 0xEC, 0xA9, 0x99,
  0x9A, 0xCE, 0xFB, 0x06, 0x50, 0x3D, 0x07, 0x50, 0x30, 0xEF, 0xFF, 0xF0, 0xE0, 0x56, 0x01, 0xD0,
  0x76, 0x01, 0x0C, 0xFF, 0xFD, 0x0C, 0x01, 0x71, 0xD0, 0x77, 0x10, 0x60, 0xEF, 0xFF, 0x90, 0xD0,
  0x67, 0x30, 0xDC, 0x07, 0x73, 0x06, 0x0C, 0xFF, 0xC0, 0xB0, 0x57, 0x50, 0xBC, 0x07, 0x75, 0x83,
  0x16, 0x9C, 0xEF, 0x98, 0x3D, 0xB8, 0x51, 0x80, 0xC2, 0x08, 0x41, 0x23, 0x21, 0x17, 0x77, 0x50,
  // "ã" (U+00E3)
  0x80, 0xC6, 0x08, 0x00, 0x17, 0x72, 0x81, 0x59, 0xCA, 0x82, 0xEC, 0x94, 0x77, 0x60, 0x8C, 0x77,
  0x06, 0x0E, 0xFA, 0x0D, 0x05, 0x77, 0x40, 0xBB, 0x0E, 0x76, 0x0A, 0xFE, 0x0B, 0x02, 0x77, 0x2C,
  0x0B, 0x75, 0x0B, 0xFF, 0xA0, 0x77, 0x70, 0x5C, 0x08, 0x74, 0x08, 0xFF, 0xC0, 0xB0, 0x17, 0x50,
  0xCC, 0x04, 0x73, 0x03, 0xF8, 0x3D, 0xA9, 0xCE, 0xF9, 0x0E, 0x05, 0x73, 0x07, 0xC0, 0xE7, 0x40,
  0xBD, 0x0A, 0x02, 0x50, 0x50, 0xCF, 0x90, 0xB0, 0x27, 0x07, 0xD0, 0x97, 0x30, 0x2D, 0x08, 0x72,
  0x06, 0x0E, 0xF9, 0x85, 0xA5, 0x21, 0x26, 0xDE, 0x01, 0x73, 0x07, 0xC0, 0xB7, 0x40, 0x20, 0xCF,
  0xFD, 0x07, 0x74, 0x0B, 0xC0, 0x47, 0x60, 0x8F, 0xFB, 0x0B, 0x75, 0xC0, 0xD7, 0x71, 0x03, 0x0D,
  0xFF, 0x0C, 0x01, 0x74, 0x02, 0xC0, 0x97, 0x73, 0x07, 0x0E, 0xFC, 0x09, 0x76, 0x04, 0xC0, 0x57,
  0x74, 0x81, 0x18, 0xEF, 0x0B, 0x04, 0x77, 0x84, 0x27, 0x77, 0x71, 0x77, 0x78, 0x53, 0x67, 0x77,
  0x51, 0x80, 0xED, 0x30, 0x84, 0x13, 0x68, 0xAB, 0x80, 0x2D, 0x83, 0xBA, 0x85, 0x27, 0x77, 0x71,
  0x82, 0x15, 0x9D, 0xFF, 0xB8, 0x1D, 0x93, 0x77, 0x72, 0x81, 0x16, 0xBF, 0xFF, 0xB0, 0xC0, 0x57,
  0x75, 0x04, 0x0B, 0xFF, 0xFF, 0x90, 0xB0, 0x17, 0x71, 0x06, 0x0D, 0xFF, 0xFF, 0xC0, 0xE0, 0x47,
  0x60, 0xAF, 0xFB, 0x0E, 0x80, 0x0D, 0xFF, 0x05, 0x75, 0x05, 0xFC, 0x83, 0xD9, 0x63, 0x17, 0x82,
  0x24, 0x9D, 0xFB, 0x03, 0x75, 0x0E, 0xF8, 0x1A, 0x51, 0x77, 0x20, 0x40, 0xCF, 0x90, 0xD7, 0x50,
  0x9C, 0x81, 0xC6, 0x17, 0x77, 0x07, 0xF9, 0x08, 0x74, 0x03, 0xA0, 0xA0, 0x37, 0x77, 0x40, 0x4F,
  0x90, 0x17, 0x40, 0x80, 0x27, 0x77, 0x70, 0x6F, 0x08, 0x80, 0xC6, 0x00, 0xAE, 0x0D, 0x80, 0xC6,
  0x00, 0x2F, 0x03, 0x80, 0xC6, 0x00, 0xBE, 0x07, 0x80, 0xC6, 0x00, 0x5E, 0x0B, 0x80, 0xC6, 0x00,
  0x1E, 0x0E, 0x80, 0xC7, 0x00, 0xCE, 0x01, 0x80, 0xC6, 0x00, 0xAE, 0x03, 0x80, 0xC6, 0x00, 0x7E,
  0x05, 0x80, 0xC6, 0x00, 0x6E, 0x06, 0x80, 0xC6, 0x00, 0x5E, 0x06, 0x80, 0xC6, 0x00, 0x4E, 0x07,
  0x80, 0xC6, 0x00, 0x3E, 0x07, 0x80, 0xC6, 0x00, 0x3E, 0x07, 0x80, 0xC6, 0x00, 0x3E, 0x07, 0x80,
  0xC6, 0x00, 0x3E, 0x07, 0x80, 0xC6, 0x00, 0x3E, 0x07, 0x77, 0x77, 0x78, 0x61, 0x12, 0x33, 0x55,
  0x8E, 0x07, 0x77, 0x72, 0x89, 0x02, 0x46, 0x79, 0xAB, 0xCD, 0xDF, 0xFA, 0x07, 0x77, 0x48, 0x23,
  0x7A, 0xDF, 0xFF, 0xE0, 0x77, 0x78, 0x21, 0x6B, 0xEF, 0xFF, 0xFB, 0x07, 0x75, 0x05, 0x0B, 0xFF,
  0xFF, 0xF0, 0x77, 0x30, 0x60, 0xDF, 0xFF, 0xF8, 0x1E, 0xDD, 0xE0, 0x77, 0x10, 0x30, 0xCF, 0xF9,
  0x85, 0xDB, 0x98, 0x75, 0x50, 0xF3, 0x0F, 0x14, 0x03, 0xE0, 0x77, 0x08, 0xFD, 0x82, 0xC8, 0x52,
  0x77, 0x40, 0x3E, 0x07, 0x60, 0xBF, 0xB8, 0x1A, 0x51, 0x77, 0x71, 0x03, 0xE0, 0x74, 0x01, 0x0C,
  0xF9, 0x81, 0xE8, 0x17, 0x77, 0x40, 0x3E, 0x07, 0x40, 0xBF, 0x90, 0x90, 0x17, 0x77, 0x60, 0x3E,
  0x07, 0x30, 0x7F, 0x0E, 0x04, 0x77, 0x77, 0x10, 0x3E, 0x07, 0x20, 0x2F, 0x0E, 0x03, 0x77, 0x77,
  0x20, 0x4E, 0x07, 0x20, 0xAF, 0x04, 0x77, 0x77, 0x30, 0x5E, 0x81, 0x70, 0x2F, 0x08, 0x77, 0x77,
  0x40, 0x6E, 0x81, 0x70, 0x7E, 0x0E, 0x77, 0x77, 0x50, 0x8E, 0x81, 0x70, 0xBE, 0x08, 0x77, 0x77,
  0x50, 0xAE, 0x07, 0x1F, 0x03, 0x77, 0x77, 0x50, 0xDE, 0x07, 0x02, 0xF7, 0x77, 0x75, 0x01, 0xF0,
  0x70, 0x4E, 0x0D, 0x77, 0x77, 0x50, 0x5F, 0x07, 0x04, 0xE0, 0xB7, 0x77, 0x75, 0x09, 0xF0, 0x70,
  0x5E, 0x0B, 0x77, 0x77, 0x50, 0xEF, 0x07, 0x04, 0xE0, 0xB7, 0x77, 0x74, 0x06, 0xF9, 0x07, 0x04,
  0xE0, 0xD7, 0x77, 0x74, 0x0D, 0xF9, 0x07, 0x02, 0xF7, 0x77, 0x73, 0x06, 0xFA, 0x07, 0x1F, 0x04,
  0x77, 0x77, 0x10, 0x20, 0xEF, 0xA8, 0x17, 0x0C, 0xE0, 0x97, 0x77, 0x71, 0x0C, 0xFB, 0x81, 0x70,
  0x8F, 0x01, 0x77, 0x76, 0x0A, 0xC0, 0x90, 0xED, 0x81, 0x70, 0x3F, 0x0A, 0x77, 0x75, 0x0A, 0xC8,
  0x1C, 0x0D, 0xD0, 0x72, 0x0C, 0xF0, 0x87, 0x77, 0x20, 0x10, 0xCD, 0x81, 0x20, 0xBD, 0x07, 0x20,
  0x5F, 0x90, 0x97, 0x77, 0x06, 0x0E, 0xD0, 0x52, 0x09, 0xD0, 0x73, 0x0B, 0xF9, 0x0D, 0x04, 0x77,
  0x30, 0x60, 0xDE, 0x07, 0x30, 0x7D, 0x07, 0x30, 0x10, 0xEF, 0xA8, 0x1C, 0x72, 0x73, 0x82, 0x25,
  0xAE, 0xF0, 0x84, 0x05, 0xD0, 0x74, 0x03, 0x0E, 0xFC, 0x89, 0x0E, 0xCA, 0x99, 0x99, 0xAC, 0xEF,
  0xB0, 0x65, 0x03, 0xD0, 0x75, 0x03, 0x0E, 0xFF, 0xFF, 0x0E, 0x05, 0x60, 0x1D, 0x07, 0x60, 0x10,
  0xCF, 0xFF, 0xD0, 0xC0, 0x17, 0x1D, 0x07, 0x71, 0x06, 0x0E, 0xFF, 0xF9, 0x0D, 0x06, 0x73, 0x0D,
  0xC0, 0x77, 0x30, 0x60, 0xCF, 0xFC, 0x0B, 0x05, 0x75, 0x0B, 0xC0, 0x77, 0x58, 0x31, 0x69, 0xCE,
  0xF9, 0x83, 0xDB, 0x85, 0x18, 0x0C, 0x20, 0x84, 0x12, 0x32, 0x11, 0x77, 0x75,
  // "ä" (U+00E4)
  0x77, 0x82, 0x45, 0x51, 0x77, 0x48, 0x22, 0x55, 0x27, 0x77, 0x10, 0x20, 0xDC, 0x07, 0x77, 0x20,
  0xAC, 0x0B, 0x01, 0x77, 0x60, 0xDE, 0x05, 0x77, 0x08, 0xE0, 0xA7, 0x75, 0x03, 0xF0, 0xB7, 0x70,
  0xDF, 0x77, 0x50, 0x5F, 0x0D, 0x76, 0x01, 0xF9, 0x03, 0x77, 0x40, 0x6F, 0x0E, 0x76, 0x01, 0xF9,
  0x04, 0x77, 0x40, 0x5F, 0x0D, 0x77, 0xF9, 0x03, 0x77, 0x40, 0x2F, 0x0A, 0x77, 0x0D, 0xE0, 0xE7,
  0x76, 0x0B, 0xE0, 0x37, 0x70, 0x7E, 0x08, 0x77, 0x60, 0x10, 0xCB, 0x0E, 0x06, 0x77, 0x20, 0x9C,
  0x09, 0x77, 0x72, 0x81, 0x23, 0x37, 0x75, 0x82, 0x13, 0x31, 0x80, 0x98, 0xF7, 0x08, 0x41, 0x36,
  0x8A, 0xB8, 0x02, 0xD8, 0x3B, 0xA8, 0x52, 0x77, 0x77, 0x18, 0x21, 0x59, 0xDF, 0xFB, 0x81, 0xD9,
  0x37, 0x77, 0x28, 0x11, 0x6B, 0xFF, 0xFB, 0x0C, 0x05, 0x77, 0x50, 0x40, 0xBF, 0xFF, 0xF9, 0x0B,
  0x01, 0x77, 0x10, 0x60, 0xDF, 0xFF, 0xFC, 0x0E, 0x04, 0x76, 0x0A, 0xFF, 0xB0, 0xE8, 0x00, 0xDF,
  0xF0, 0x57, 0x50, 0x5F, 0xC8, 0x3D, 0x96, 0x31, 0x78, 0x22, 0x49, 0xDF, 0xB0, 0x37, 0x50, 0xEF,
  0x81, 0xA5, 0x17, 0x72, 0x04, 0x0C, 0xF9, 0x0D, 0x75, 0x09, 0xC8, 0x1C, 0x61, 0x77, 0x70, 0x7F,
  0x90, 0x87, 0x40, 0x3A, 0x0A, 0x03, 0x77, 0x74, 0x04, 0xF9, 0x01, 0x74, 0x08, 0x02, 0x77, 0x77,
  0x06, 0xF0, 0x88, 0x0C, 0x60, 0x0A, 0xE0, 0xD8, 0x0C, 0x60, 0x02, 0xF0, 0x38, 0x0C, 0x60, 0x0B,
  0xE0, 0x78, 0x0C, 0x60, 0x05, 0xE0, 0xB8, 0x0C, 0x60, 0x01, 0xE0, 0xE8, 0x0C, 0x70, 0x0C, 0xE0,
  0x18, 0x0C, 0x60, 0x0A, 0xE0, 0x38, 0x0C, 0x60, 0x07, 0xE0, 0x58, 0x0C, 0x60, 0x06, 0xE0, 0x68,
  0x0C, 0x60, 0x05, 0xE0, 0x68, 0x0C, 0x60, 0x04, 0xE0, 0x78, 0x0C, 0x60, 0x03, 0xE0, 0x78, 0x0C,
  0x60, 0x03, 0xE0, 0x78, 0x0C, 0x60, 0x03, 0xE0, 0x78, 0x0C, 0x60, 0x03, 0xE0, 0x78, 0x0C, 0x60,
  0x03, 0xE0, 0x77, 0x77, 0x77, 0x86, 0x11, 0x23, 0x35, 0x58, 0xE0, 0x77, 0x77, 0x28, 0x90, 0x24,
  0x67, 0x9A, 0xBC, 0xDD, 0xFF, 0xA0, 0x77, 0x74, 0x82, 0x37, 0xAD, 0xFF, 0xFE, 0x07, 0x77, 0x82,
  0x16, 0xBE, 0xFF, 0xFF, 0xB0, 0x77, 0x50, 0x50, 0xBF, 0xFF, 0xFF, 0x07, 0x73, 0x06, 0x0D, 0xFF,
  0xFF, 0x81, 0xED, 0xDE, 0x07, 0x71, 0x03, 0x0C, 0xFF, 0x98, 0x5D, 0xB9, 0x87, 0x55, 0x0F, 0x30,
  0xF1, 0x40, 0x3E, 0x07, 0x70, 0x8F, 0xD8, 0x2C, 0x85, 0x27, 0x74, 0x03, 0xE0, 0x76, 0x0B, 0xFB,
  0x81, 0xA5, 0x17, 0x77, 0x10, 0x3E, 0x07, 0x40, 0x10, 0xCF, 0x98, 0x1E, 0x81, 0x77, 0x74, 0x03,
  0xE0, 0x74, 0x0B, 0xF9, 0x09, 0x01, 0x77, 0x76, 0x03, 0xE0, 0x73, 0x07, 0xF0, 0xE0, 0x47, 0x77,
  0x71, 0x03, 0xE0, 0x72, 0x02, 0xF0, 0xE0, 0x37, 0x77, 0x72, 0x04, 0xE0, 0x72, 0x0A, 0xF0, 0x47,
  0x77, 0x73, 0x05, 0xE8, 0x17, 0x02, 0xF0, 0x87, 0x77, 0x74, 0x06, 0xE8, 0x17, 0x07, 0xE0, 0xE7,
  0x77, 0x75, 0x08, 0xE8, 0x17, 0x0B, 0xE0, 0x87, 0x77, 0x75, 0x0A, 0xE0, 0x71, 0xF0, 0x37, 0x77,
  0x75, 0x0D, 0xE0, 0x70, 0x2F, 0x77, 0x77, 0x50, 0x1F, 0x07, 0x04, 0xE0, 0xD7, 0x77, 0x75, 0x05,
  0xF0, 0x70, 0x4E, 0x0B, 0x77, 0x77, 0x50, 0x9F, 0x07, 0x05, 0xE0, 0xB7, 0x77, 0x75, 0x0E, 0xF0,
  0x70, 0x4E, 0x0B, 0x77, 0x77, 0x40, 0x6F, 0x90, 0x70, 0x4E, 0x0D, 0x77, 0x77, 0x40, 0xDF, 0x90,
  0x70, 0x2F, 0x77, 0x77, 0x30, 0x6F, 0xA0, 0x71, 0xF0, 0x47, 0x77, 0x71, 0x02, 0x0E, 0xFA, 0x81,
  0x70, 0xCE, 0x09, 0x77, 0x77, 0x10, 0xCF, 0xB8, 0x17, 0x08, 0xF0, 0x17, 0x77, 0x60, 0xAC, 0x09,
  0x0E, 0xD8, 0x17, 0x03, 0xF0, 0xA7, 0x77, 0x50, 0xAC, 0x81, 0xC0, 0xDD, 0x07, 0x20, 0xCF, 0x08,
  0x77, 0x72, 0x01, 0x0C, 0xD8, 0x12, 0x0B, 0xD0, 0x72, 0x05, 0xF9, 0x09, 0x77, 0x70, 0x60, 0xED,
  0x05, 0x20, 0x9D, 0x07, 0x30, 0xBF, 0x90, 0xD0, 0x47, 0x73, 0x06, 0x0D, 0xE0, 0x73, 0x07, 0xD0,
  0x73, 0x01, 0x0E, 0xFA, 0x81, 0xC7, 0x27, 0x38, 0x22, 0x5A, 0xEF, 0x08, 0x40, 0x5D, 0x07, 0x40,
  0x30, 0xEF, 0xC8, 0x90, 0xEC, 0xA9, 0x99, 0x9A, 0xCE, 0xFB, 0x06, 0x50, 0x3D, 0x07, 0x50, 0x30,
  0xEF, 0xFF, 0xF0, 0xE0, 0x56, 0x01, 0xD0, 0x76, 0x01, 0x0C, 0xFF, 0xFD, 0x0C, 0x01, 0x71, 0xD0,
  0x77, 0x10, 0x60, 0xEF, 0xFF, 0x90, 0xD0, 0x67, 0x30, 0xDC, 0x07, 0x73, 0x06, 0x0C, 0xFF, 0xC0,
  0xB0, 0x57, 0x50, 0xBC, 0x07, 0x75, 0x83, 0x16, 0x9C, 0xEF, 0x98, 0x3D, 0xB8, 0x51, 0x80, 0xC2,
  0x08, 0x41, 0x23, 0x21, 0x17, 0x77, 0x50,
  // "å" (U+00E5)
  0x77, 0x71, 0x87, 0x14, 0x79, 0x99, 0x96, 0x38, 0x0C, 0x30, 0x03, 0x0A, 0xFA, 0x0D, 0x07, 0x80,
  0xC0, 0x00, 0x9F, 0xE0, 0xD0, 0x47, 0x77, 0x74, 0x01, 0x0D, 0xFF, 0xA0, 0x77, 0x77, 0x72, 0x01,
  0x0D, 0xE8, 0x3E, 0xBA, 0xAC, 0xF0, 0x77, 0x77, 0x71, 0x0B, 0xD0, 0xC0, 0x45, 0x81, 0x18, 0xED,
  0x04, 0x77, 0x76, 0x05, 0xD0, 0x87, 0x20, 0x20, 0xDC, 0x0D, 0x77, 0x76, 0x0D, 0xC0, 0x87, 0x40,
  0x20, 0xEC, 0x06, 0x77, 0x74, 0x03, 0xC0, 0xD7, 0x60, 0x5C, 0x0C, 0x77, 0x74, 0x07, 0xC0, 0x57,
  0x70, 0xDC, 0x01, 0x77, 0x73, 0x0A, 0xC7, 0x71, 0x08, 0xC0, 0x37, 0x77, 0x30, 0xBB, 0x0D, 0x77,
  0x10, 0x5C, 0x05, 0x77, 0x73, 0x0C, 0xB0, 0xC7, 0x71, 0x04, 0xC0, 0x67, 0x77, 0x30, 0xBB, 0x0D,
  0x77, 0x10, 0x5C, 0x05, 0x77, 0x73, 0x0A, 0xB0, 0xE7, 0x71, 0x07, 0xC0, 0x47, 0x77, 0x30, 0x7C,
  0x03, 0x77, 0x0C, 0xC0, 0x17, 0x77, 0x30, 0x4C, 0x0A, 0x76, 0x03, 0xC0, 0xD7, 0x77, 0x50, 0xEC,
  0x04, 0x75, 0x0C, 0xC0, 0x87, 0x77, 0x50, 0x7C, 0x0E, 0x04, 0x72, 0x01, 0x0B, 0xD0, 0x27, 0x77,
  0x60, 0xDD, 0x08, 0x01, 0x60, 0x50, 0xDD, 0x08, 0x77, 0x77, 0x03, 0xF8, 0x4C, 0x98, 0x8A, 0xEE,
  0x0C, 0x77, 0x77, 0x20, 0x5F, 0xFB, 0x0C, 0x01, 0x77, 0x77, 0x30, 0x30, 0xDF, 0xF0, 0xA7, 0x77,
  0x77, 0x08, 0x0E, 0xFB, 0x0D, 0x05, 0x80, 0xC1, 0x08, 0x21, 0x5A, 0xDB, 0x82, 0xEC, 0x84, 0x80,
  0xEE, 0x10, 0x84, 0x13, 0x68, 0xAB, 0x80, 0x2D, 0x83, 0xBA, 0x85, 0x27, 0x77, 0x71, 0x82, 0x15,
  0x9D, 0xFF, 0xB8, 0x1D, 0x93, 0x77, 0x72, 0x81, 0x16, 0xBF, 0xFF, 0xB0, 0xC0, 0x57, 0x75, 0x04,
  0x0B, 0xFF, 0xFF, 0x90, 0xB0, 0x17, 0x71, 0x06, 0x0D, 0xFF, 0xFF, 0xC0, 0xE0, 0x47, 0x60, 0xAF,
  0xFB, 0x0E, 0x80, 0x0D, 0xFF, 0x05, 0x75, 0x05, 0xFC, 0x83, 0xD9, 0x63, 0x17, 0x82, 0x24, 0x9D,
  0xFB, 0x03, 0x75, 0x0E, 0xF8, 0x1A, 0x51, 0x77, 0x20, 0x40, 0xCF, 0x90, 0xD7, 0x50, 0x9C, 0x81,
  0xC6, 0x17, 0x77, 0x07, 0xF9, 0x08, 0x74, 0x03, 0xA0, 0xA0, 0x37, 0x77, 0x40, 0x4F, 0x90, 0x17,
  0x40, 0x80, 0x27, 0x77, 0x70, 0x6F, 0x08, 0x80, 0xC6, 0x00, 0xAE, 0x0D, 0x80, 0xC6, 0x00, 0x2F,
  0x03, 0x80, 0xC6, 0x00, 0xBE, 0x07, 0x80, 0xC6, 0x00, 0x5E, 0x0B, 0x80, 0xC6, 0x00, 0x1E, 0x0E,
  0x80, 0xC7, 0x00, 0xCE, 0x01, 0x80, 0xC6, 0x00, 0xAE, 0x03, 0x80, 0xC6, 0x00, 0x7E, 0x05, 0x80,
  0xC6, 0x00, 0x6E, 0x06, 0x80, 0xC6, 0x00, 0x5E, 0x06, 0x80, 0xC6, 0x00, 0x4E, 0x07, 0x80, 0xC6,
  0x00, 0x3E, 0x07, 0x80, 0xC6, 0x00, 0x3E, 0x07, 0x80, 0xC6, 0x00, 0x3E, 0x07, 0x80, 0xC6, 0x00,
  0x3E, 0x07, 0x80, 0xC6, 0x00, 0x3E, 0x07, 0x77, 0x77, 0x78, 0x61, 0x12, 0x33, 0x55, 0x8E, 0x07,
  0x77, 0x72, 0x89, 0x02, 0x46, 0x79, 0xAB, 0xCD, 0xDF, 0xFA, 0x07, 0x77, 0x48, 0x23, 0x7A, 0xDF,
  0xFF, 0xE0, 0x77, 0x78, 0x21, 0x6B, 0xEF, 0xFF, 0xFB, 0x07, 0x75, 0x05, 0x0B, 0xFF, 0xFF, 0xF0,
  0x77, 0x30, 0x60, 0xDF, 0xFF, 0xF8, 0x1E, 0xDD, 0xE0, 0x77, 0x10, 0x30, 0xCF, 0xF9, 0x85, 0xDB,
  0x98, 0x75, 0x50, 0xF3, 0x0F, 0x14, 0x03, 0xE0, 0x77, 0x08, 0xFD, 0x82, 0xC8, 0x52, 0x77, 0x40,
  0x3E, 0x07, 0x60, 0xBF, 0xB8, 0x1A, 0x51, 0x77, 0x71, 0x03, 0xE0, 0x74, 0x01, 0x0C, 0xF9, 0x81,
  0xE8, 0x17, 0x77, 0x40, 0x3E, 0x07, 0x40, 0xBF, 0x90, 0x90, 0x17, 0x77, 0x60, 0x3E, 0x07, 0x30,
  0x7F, 0x0E, 0x04, 0x77, 0x77, 0x10, 0x3E, 0x07, 0x20, 0x2F, 0x0E, 0x03, 0x77, 0x77, 0x20, 0x4E,
  0x07, 0x20, 0xAF, 0x04, 0x77, 0x77, 0x30, 0x5E, 0x81, 0x70, 0x2F, 0x08, 0x77, 0x77, 0x40, 0x6E,
  0x81, 0x70, 0x7E, 0x0E, 0x77, 0x77, 0x50, 0x8E, 0x81, 0x70, 0xBE, 0x08, 0x77, 0x77, 0x50, 0xAE,
  0x07, 0x1F, 0x03, 0x77, 0x77, 0x50, 0xDE, 0x07, 0x02, 0xF7, 0x77, 0x75, 0x01, 0xF0, 0x70, 0x4E,
  0x0D, 0x77, 0x77, 0x50, 0x5F, 0x07, 0x04, 0xE0, 0xB7, 0x77, 0x75, 0x09, 0xF0, 0x70, 0x5E, 0x0B,
  0x77, 0x77, 0x50, 0xEF, 0x07, 0x04, 0xE0, 0xB7, 0x77, 0x74, 0x06, 0xF9, 0x07, 0x04, 0xE0, 0xD7,
  0x77, 0x74, 0x0D, 0xF9, 0x07, 0x02, 0xF7, 0x77, 0x73, 0x06, 0xFA, 0x07, 0x1F, 0x04, 0x77, 0x77,
  0x10, 0x20, 0xEF, 0xA8, 0x17, 0x0C, 0xE0, 0x97, 0x77, 0x71, 0x0C, 0xFB, 0x81, 0x70, 0x8F, 0x01,
  0x77, 0x76, 0x0A, 0xC0, 0x90, 0xED, 0x81, 0x70, 0x3F, 0x0A, 0x77, 0x75, 0x0A, 0xC8, 0x1C, 0x0D,
  0xD0, 0x72, 0x0C, 0xF0, 0x87, 0x77, 0x20, 0x10, 0xCD, 0x81, 0x20, 0xBD, 0x07, 0x20, 0x5F, 0x90,
  0x97, 0x77, 0x06, 0x0E, 0xD0, 0x52, 0x09, 0xD0, 0x73, 0x0B, 0xF9, 0x0D, 0x04, 0x77, 0x30, 0x60,
  0xDE, 0x07, 0x30, 0x7D, 0x07, 0x30, 0x10, 0xEF, 0xA8, 0x1C, 0x72, 0x73, 0x82, 0x25, 0xAE, 0xF0,
  0x84, 0x05, 0xD0, 0x74, 0x03, 0x0E, 0xFC, 0x89, 0x0E, 0xCA, 0x99, 0x99, 0xAC, 0xEF, 0xB0, 0x65,
  0x03, 0xD0, 0x75, 0x03, 0x0E, 0xFF, 0xFF, 0x0E, 0x05, 0x60, 0x1D, 0x07, 0x60, 0x10, 0xCF, 0xFF,
  0xD0, 0xC0, 0x17, 0x1D, 0x07, 0x71, 0x06, 0x0E, 0xFF, 0xF9, 0x0D, 0x06, 0x73, 0x0D, 0xC0, 0x77,
  0x30, 0x60, 0xCF, 0xFC, 0x0B, 0x05, 0x75, 0x0B, 0xC0, 0x77, 0x58, 0x31, 0x69, 0xCE, 0xF9, 0x83,
  0xDB, 0x85, 0x18, 0x0C, 0x20, 0x84, 0x12, 0x32, 0x11, 0x77, 0x75,
  // "æ" (U+00E6)
  0x77, 0x58, 0x33, 0x68, 0x9B, 0x80, 0x2D, 0x82, 0xB9, 0x73, 0x77, 0x75, 0x83, 0x15, 0x8B, 0xDD,
  0x83, 0xDB, 0x85, 0x17, 0x77, 0x74, 0x81, 0x59, 0xCF, 0xFA, 0x81, 0xEA, 0x47, 0x77, 0x05, 0x0B,
  0xFF, 0x90, 0xC0, 0x67, 0x77, 0x58, 0x11, 0x6B, 0xFF, 0xFA, 0x0C, 0x04, 0x77, 0x30, 0x60, 0xEF,
  0xFD, 0x0E, 0x07, 0x77, 0x71, 0x04, 0x0A, 0xFF, 0xFF, 0x0A, 0x77, 0x02, 0x0C, 0xFF, 0xFA, 0x0D,
  0x04, 0x77, 0x40, 0x50, 0xCF, 0xFF, 0xFB, 0x0C, 0x01, 0x74, 0x05, 0x0E, 0xFF, 0xFD, 0x07, 0x77,
  0x20, 0x8F, 0xFB, 0x83, 0xED, 0xDD, 0xEF, 0xD0, 0xD0, 0x17, 0x20, 0x8F, 0xC8, 0x4E, 0xCB, 0xBB,
  0xCF, 0xD0, 0x97, 0x71, 0x03, 0xFC, 0x83, 0xD9, 0x64, 0x17, 0x81, 0x36, 0xBF, 0xA0, 0xB7, 0x10,
  0x8F, 0xA8, 0x1A, 0x51, 0x78, 0x12, 0x6C, 0xFA, 0x0A, 0x77, 0x10, 0xCF, 0x81, 0xB6, 0x27, 0x71,
  0x01, 0x08, 0xF9, 0x06, 0x60, 0x7F, 0x81, 0xE8, 0x17, 0x60, 0x30, 0xBF, 0x90, 0x87, 0x70, 0x6C,
  0x81, 0xD7, 0x17, 0x76, 0x02, 0x0C, 0xE0, 0xE5, 0x05, 0xF0, 0xB0, 0x17, 0x73, 0x06, 0xF9, 0x05,
  0x76, 0x01, 0xA0, 0xB0, 0x47, 0x77, 0x40, 0xBE, 0x07, 0x30, 0x20, 0xEE, 0x08, 0x77, 0x60, 0x30,
  0xEE, 0x0E, 0x02, 0x76, 0x07, 0x03, 0x77, 0x77, 0x0C, 0xD0, 0xD3, 0x0B, 0xE0, 0x67, 0x77, 0x10,
  0x3F, 0x0B, 0x80, 0xC7, 0x00, 0x3E, 0x81, 0x40, 0x6E, 0x07, 0x77, 0x73, 0x06, 0xF0, 0x48, 0x0C,
  0x70, 0x09, 0xD8, 0x19, 0x0E, 0xD0, 0xA7, 0x77, 0x50, 0xBE, 0x0C, 0x80, 0xC7, 0x00, 0x2D, 0x0D,
  0x07, 0xD0, 0xD7, 0x77, 0x60, 0x3F, 0x03, 0x80, 0xC7, 0x00, 0xCD, 0x0E, 0xD0, 0x47, 0x77, 0x70,
  0xAE, 0x0A, 0x80, 0xC7, 0x00, 0x8F, 0xB0, 0xB7, 0x77, 0x71, 0x03, 0xF0, 0x18, 0x0C, 0x60, 0x04,
  0xFB, 0x04, 0x77, 0x77, 0x20, 0xDE, 0x05, 0x80, 0xC6, 0x00, 0x1F, 0xA0, 0xD7, 0x77, 0x73, 0x07,
  0xE0, 0xA8, 0x0C, 0x70, 0x0E, 0xF9, 0x07, 0x77, 0x77, 0x30, 0x3E, 0x0E, 0x80, 0xC7, 0x00, 0xDF,
  0x90, 0x27, 0x77, 0x74, 0x0E, 0xE0, 0x38, 0x0C, 0x60, 0x0B, 0xF0, 0xC7, 0x77, 0x75, 0x0B, 0xE0,
  0x68, 0x0C, 0x60, 0x0B, 0xF0, 0x87, 0x77, 0x75, 0x08, 0xE0, 0x88, 0x0C, 0x60, 0x0A, 0xF0, 0x57,
  0x77, 0x75, 0x06, 0xE0, 0xB8, 0x0C, 0x60, 0x0A, 0xF0, 0x27, 0x77, 0x75, 0x04, 0xE0, 0xD8, 0x0C,
  0x60, 0x0A, 0xE0, 0xE7, 0x77, 0x76, 0x03, 0xE0, 0xE8, 0x0C, 0x60, 0x0A, 0xE0, 0xC7, 0x77, 0x76,
  0x02, 0xF8, 0x0C, 0x60, 0x0A, 0xE0, 0xA7, 0x77, 0x76, 0x01, 0xF0, 0x17, 0x77, 0x76, 0x86, 0x11,
  0x23, 0x35, 0x5C, 0xE0, 0x97, 0x77, 0x76, 0x01, 0xF0, 0x17, 0x77, 0x18, 0x90, 0x14, 0x57, 0x9A,
  0xBC, 0xDD, 0xFF, 0xA0, 0xD8, 0x0B, 0x7B, 0xF0, 0x17, 0x73, 0x83, 0x15, 0x8C, 0xE8, 0x09, 0x81,
  0xF0, 0x17, 0x78, 0x13, 0x8C, 0x80, 0x98, 0x6F, 0x01, 0x75, 0x06, 0x0C, 0x80, 0x99, 0x1F, 0x01,
  0x73, 0x07, 0x0E, 0xFF, 0xFE, 0x00, 0xD8, 0x0D, 0x6F, 0x01, 0x71, 0x05, 0x0D, 0xFF, 0x89, 0x2E,
  0xCA, 0x87, 0x55, 0x33, 0x31, 0x15, 0x0C, 0xE0, 0xE8, 0x0C, 0x6D, 0x01, 0x70, 0x9F, 0xC8, 0x3E,
  0xA7, 0x41, 0x77, 0x30, 0xCE, 0x04, 0x80, 0xD4, 0x00, 0x10, 0xCF, 0xA8, 0x1E, 0x94, 0x77, 0x71,
  0x0C, 0xE0, 0x58, 0x0D, 0x30, 0x01, 0x0D, 0xF9, 0x0E, 0x06, 0x77, 0x74, 0x0C, 0xE0, 0x58, 0x0D,
  0x30, 0x0C, 0xF9, 0x08, 0x77, 0x76, 0x0C, 0xE0, 0x68, 0x0D, 0x20, 0x08, 0xF0, 0xE0, 0x37, 0x77,
  0x70, 0xCE, 0x07, 0x80, 0xD1, 0x00, 0x3F, 0x0E, 0x02, 0x77, 0x77, 0x10, 0xCE, 0x08, 0x80, 0xD1,
  0x00, 0xAF, 0x03, 0x77, 0x77, 0x20, 0xDE, 0x0A, 0x80, 0xD0, 0x00, 0x2F, 0x08, 0x77, 0x77, 0x30,
  0xEE, 0x0D, 0x80, 0xD0, 0x00, 0x7E, 0x0E, 0x77, 0x77, 0x4F, 0x98, 0x0D, 0x00, 0x0C, 0xE0, 0x87,
  0x77, 0x73, 0x02, 0xF9, 0x03, 0x80, 0xC7, 0x0F, 0x03, 0x77, 0x77, 0x30, 0x4F, 0x90, 0x78, 0x0C,
  0x60, 0x02, 0xF7, 0x77, 0x74, 0x07, 0xF9, 0x0A, 0x80, 0xC6, 0x00, 0x4E, 0x0D, 0x77, 0x77, 0x40,
  0xBF, 0xA8, 0x0C, 0x60, 0x04, 0xE0, 0xB7, 0x77, 0x74, 0xFB, 0x05, 0x80, 0xC5, 0x00, 0x5E, 0x0B,
  0x77, 0x77, 0x30, 0x5F, 0xB0, 0xB8, 0x0C, 0x50, 0x04, 0xE0, 0xB7, 0x77, 0x73, 0x0B, 0xFC, 0x03,
  0x80, 0xC4, 0x00, 0x4E, 0x0D, 0x77, 0x77, 0x20, 0x3D, 0x0A, 0xE0, 0xB8, 0x0C, 0x40, 0x02, 0xF7,
  0x77, 0x72, 0x0B, 0xC8, 0x1E, 0x1B, 0xE0, 0x48, 0x0C, 0x40, 0xF0, 0x37, 0x77, 0x70, 0x5D, 0x81,
  0x70, 0x3E, 0x0D, 0x01, 0x80, 0xC3, 0x00, 0xCE, 0x09, 0x77, 0x76, 0x01, 0x0E, 0xC0, 0xE3, 0x0B,
  0xE0, 0xB8, 0x0C, 0x30, 0x08, 0xE0, 0xE0, 0x17, 0x77, 0x50, 0xCD, 0x05, 0x30, 0x2F, 0x09, 0x80,
  0xC2, 0x00, 0x3F, 0x09, 0x77, 0x74, 0x0B, 0xD0, 0xA5, 0x07, 0xF0, 0x98, 0x0C, 0x20, 0x0C, 0xF0,
  0x67, 0x77, 0x10, 0x10, 0xCD, 0x0D, 0x01, 0x60, 0xCF, 0x0B, 0x01, 0x77, 0x77, 0x81, 0x3A, 0x75,
  0x05, 0xF9, 0x07, 0x77, 0x60, 0x50, 0xEE, 0x03, 0x70, 0x10, 0xDF, 0x0E, 0x06, 0x77, 0x73, 0x81,
  0x16, 0xCA, 0x07, 0x60, 0xBF, 0x90, 0xB0, 0x37, 0x72, 0x05, 0x0C, 0xF0, 0x57, 0x20, 0x20, 0xEF,
  0x98, 0x1D, 0x61, 0x77, 0x48, 0x12, 0x6B, 0xD0, 0x76, 0x01, 0x0E, 0xFA, 0x81, 0xB5, 0x17, 0x28,
  0x21, 0x48, 0xDF, 0x90, 0x67, 0x40, 0x30, 0xEF, 0xB8, 0x2B, 0x73, 0x17, 0x28, 0x32, 0x47, 0xAD,
  0xF9, 0x07, 0x70, 0x30, 0xEF, 0xC0, 0xE0, 0xB8, 0x01, 0x90, 0xB0, 0xDF, 0xC0, 0x57, 0x60, 0x20,
  0xDF, 0xE8, 0x2E, 0xDD, 0xB0, 0xFD, 0xFF, 0x90, 0x77, 0x10, 0x30, 0xEF, 0xFF, 0xF0, 0xE0, 0x47,
  0x72, 0x0A, 0xFF, 0xFF, 0xE0, 0x77, 0x20, 0x10, 0xCF, 0xFF, 0xD0, 0xB0, 0x17, 0x74, 0x05, 0x0D,
  0xFF, 0xFF, 0xA8, 0x1E, 0x81, 0x74, 0x06, 0x0D, 0xFF, 0xF9, 0x0C, 0x04, 0x77, 0x71, 0x07, 0x0E,
  0xFF, 0xFD, 0x0B, 0x05, 0x77, 0x20, 0x60, 0xBF, 0xFB, 0x81, 0xEA, 0x47, 0x77, 0x50, 0x50, 0xBF,
  0xFE, 0x82, 0xEA, 0x51, 0x77, 0x68, 0x31, 0x59, 0xCE, 0xF9, 0x82, 0xDA, 0x74, 0x77, 0x77, 0x48,
  0x24, 0x8B, 0xDF, 0xA8, 0x4E, 0xCA, 0x85, 0x27, 0x77, 0x72, 0x84, 0x11, 0x32, 0x11, 0x80, 0xC6,
  0x08, 0x21, 0x12, 0x30, 0xF1, 0x77, 0x50,
  // "ç" (U+00E7)
  0x77, 0x72, 0x84, 0x36, 0x9B, 0xDE, 0xD8, 0x5E, 0xDB, 0x97, 0x41, 0x77, 0x76, 0x81, 0x5A, 0xEF,
  0xFC, 0x81, 0xD9, 0x57, 0x77, 0x03, 0x09, 0xFF, 0xFC, 0x81, 0xEA, 0x37, 0x72, 0x02, 0x0B, 0xFF,
  0xFF, 0xA0, 0x27, 0x70, 0x9F, 0xFF, 0xFB, 0x0C, 0x76, 0x03, 0x0D, 0xFF, 0xFF, 0xC0, 0x77, 0x50,
  0x6F, 0xD8, 0x95, 0xEA, 0x75, 0x31, 0x11, 0x12, 0x35, 0x7A, 0xCF, 0x02, 0x74, 0x08, 0xFB, 0x81,
  0xD8, 0x27, 0x71, 0x82, 0x15, 0x9E, 0xA0, 0xD7, 0x40, 0x8F, 0xA0, 0xD0, 0x57, 0x77, 0x18, 0x15,
  0xB8, 0x73, 0x07, 0xFA, 0x07, 0x80, 0xC0, 0x00, 0x4F, 0x90, 0xD0, 0x28, 0x0C, 0x00, 0x01, 0x0E,
  0xF0, 0xC0, 0x18, 0x0C, 0x10, 0x0A, 0xF0, 0xC0, 0x18, 0x0C, 0x10, 0x05, 0xF0, 0xD0, 0x18, 0x0C,
  0x20, 0x0D, 0xF0, 0x38, 0x0C, 0x20, 0x06, 0xF0, 0x78, 0x0C, 0x30, 0x0D, 0xE0, 0xD8, 0x0C, 0x30,
  0x05, 0xF0, 0x48, 0x0C, 0x30, 0x0B, 0xE0, 0xC8, 0x0C, 0x30, 0x01, 0xF0, 0x58, 0x0C, 0x30, 0x06,
  0xE0, 0xE8, 0x0C, 0x40, 0x0A, 0xE0, 0x98, 0x0C, 0x40, 0x0E, 0xE0, 0x58, 0x0C, 0x30, 0x02, 0xF0,
  0x18, 0x0C, 0x30, 0x05, 0xE0, 0xC8, 0x0C, 0x40, 0x08, 0xE0, 0x98, 0x0C, 0x40, 0x0A, 0xE0, 0x78,
  0x0C, 0x40, 0x0C, 0xE0, 0x48, 0x0C, 0x40, 0x0E, 0xE0, 0x28, 0x0C, 0x40, 0xF0, 0x18, 0x0C, 0x30,
  0x01, 0xF8, 0x0C, 0x40, 0x01, 0xF8, 0x0C, 0x40, 0x02, 0xE0, 0xE8, 0x0C, 0x40, 0x02, 0xE0, 0xE8,
  0x0C, 0x40, 0x01, 0xE0, 0xE8, 0x0C, 0x40, 0x01, 0xF8, 0x0C, 0x50, 0xF8, 0x0C, 0x50, 0xF0, 0x18,
  0x0C, 0x40, 0x0E, 0xE0, 0x38, 0x0C, 0x40, 0x0C, 0xE0, 0x58, 0x0C, 0x40, 0x0B, 0xE0, 0x78, 0x0C,
  0x40, 0x08, 0xE0, 0xA8, 0x0C, 0x40, 0x05, 0xE0, 0xD8, 0x0C, 0x40, 0x03, 0xF0, 0x18, 0x0C, 0x40,
  0x0E, 0xE0, 0x58, 0x0C, 0x40, 0x0B, 0xE0, 0xA8, 0x0C, 0x40, 0x07, 0xF8, 0x0C, 0x40, 0x02, 0xF0,
  0x68, 0x0C, 0x40, 0x0C, 0xE0, 0xD8, 0x0C, 0x40, 0x06, 0xF0, 0x58, 0x0C, 0x30, 0x01, 0x0E, 0xE0,
  0xD8, 0x0C, 0x40, 0x08, 0xF0, 0x78, 0x0C, 0x30, 0x01, 0xF9, 0x02, 0x80, 0xC3, 0x00, 0x7F, 0x0D,
  0x01, 0x80, 0xC3, 0x00, 0xDF, 0x0B, 0x80, 0xC3, 0x00, 0x3F, 0x90, 0xB8, 0x0C, 0x30, 0x06, 0xF9,
  0x0D, 0x03, 0x77, 0x77, 0x01, 0x72, 0x09, 0xFA, 0x08, 0x01, 0x77, 0x72, 0x82, 0x16, 0xC8, 0x73,
  0x0A, 0xFA, 0x81, 0xE8, 0x27, 0x74, 0x81, 0x26, 0xBB, 0x08, 0x74, 0x09, 0xFC, 0x82, 0xC8, 0x42,
  0x72, 0x83, 0x24, 0x7A, 0xDE, 0x08, 0x75, 0x07, 0xFF, 0x98, 0x5D, 0xDC, 0xCD, 0xDE, 0xFD, 0x08,
  0x76, 0x03, 0x0D, 0xFF, 0xFF, 0xC0, 0x87, 0x71, 0x07, 0x0E, 0xFF, 0xFF, 0xA0, 0x87, 0x72, 0x81,
  0x17, 0xEF, 0xFF, 0xD0, 0xB0, 0x57, 0x76, 0x81, 0x5A, 0xEF, 0xFE, 0x81, 0xB7, 0x17, 0x77, 0x48,
  0x33, 0x6A, 0xCE, 0xFA, 0x83, 0xEC, 0xA7, 0x47, 0x77, 0x75, 0x09, 0xC0, 0x70, 0xF1, 0x80, 0xC2,
  0x00, 0x1C, 0x0D, 0x80, 0xC6, 0x00, 0x9C, 0x06, 0x80, 0xC5, 0x00, 0x1C, 0x0D, 0x80, 0xC6, 0x00,
  0x9C, 0x06, 0x80, 0xC5, 0x00, 0x1C, 0x0D, 0x80, 0xC6, 0x00, 0x9C, 0x82, 0xEB, 0x84, 0x80, 0xC2,
  0x00, 0x1F, 0xA8, 0x1E, 0x92, 0x77, 0x77, 0x70, 0x9F, 0xD0, 0x87, 0x77, 0x76, 0x83, 0x56, 0x8A,
  0xCF, 0xA0, 0xC0, 0x18, 0x0C, 0x10, 0x81, 0x15, 0xAF, 0x0B, 0x80, 0xC4, 0x00, 0x20, 0xBE, 0x05,
  0x80, 0xC5, 0x00, 0xAD, 0x0C, 0x80, 0xC5, 0x00, 0x10, 0xED, 0x01, 0x80, 0xC5, 0x00, 0x9D, 0x04,
  0x80, 0xC5, 0x00, 0x6D, 0x05, 0x80, 0xC5, 0x00, 0x5D, 0x05, 0x80, 0xC5, 0x00, 0x7D, 0x04, 0x80,
  0xC5, 0x00, 0xBD, 0x02, 0x80, 0xC4, 0x00, 0x3D, 0x0D, 0x80, 0xC4, 0x00, 0x20, 0xDD, 0x08, 0x80,
  0xC3, 0x00, 0x60, 0xED, 0x0E, 0x01, 0x77, 0x75, 0x82, 0x55, 0x31, 0x48, 0x31, 0x25, 0x9E, 0xF0,
  0x67, 0x77, 0x60, 0xAF, 0xFC, 0x08, 0x77, 0x77, 0x0A, 0xFF, 0xB0, 0x77, 0x77, 0x71, 0x0A, 0xFF,
  0x90, 0xB0, 0x37, 0x77, 0x72, 0x0A, 0xFD, 0x81, 0xE9, 0x37, 0x77, 0x74, 0x82, 0x15, 0x89, 0x80,
  0x1B, 0x82, 0xA8, 0x63, 0x77, 0x50,
  // "è" (U+00E8)
  0x75, 0x03, 0x80, 0x4D, 0x01, 0x80, 0xD0, 0x00, 0x10, 0xDF, 0x09, 0x80, 0xD1, 0x00, 0x3F, 0x90,
  0x48, 0x0D, 0x10, 0x07, 0xF0, 0xD0, 0x18, 0x0D, 0x10, 0x0A, 0xF0, 0xA8, 0x0D, 0x20, 0x0C, 0xF0,
  0x58, 0x0D, 0x10, 0x01, 0x0D, 0xE0, 0xE0, 0x28, 0x0D, 0x10, 0x02, 0x0E, 0xE0, 0xC8, 0x0D, 0x20,
  0x03, 0x0E, 0xE0, 0x98, 0x0D, 0x20, 0x03, 0x0E, 0xE0, 0x58, 0x0D, 0x20, 0x04, 0xF0, 0x38, 0x0D,
  0x20, 0x04, 0xE0, 0xD0, 0x18, 0x0D, 0x20, 0x04, 0xE0, 0xB8, 0x0D, 0x30, 0x05, 0xE0, 0x98, 0x0D,
  0x30, 0x04, 0xE0, 0x78, 0x0D, 0x30, 0x04, 0x0E, 0xD0, 0x58, 0x0D, 0x30, 0x03, 0x0E, 0xD0, 0x48,
  0x0D, 0x30, 0x02, 0x0D, 0xD0, 0x48, 0x0D, 0x30, 0x01, 0x0B, 0xC0, 0xD8, 0x0D, 0x50, 0x80, 0x13,
  0x80, 0xEB, 0x60, 0x83, 0x26, 0x9B, 0xDD, 0x83, 0xEC, 0xA7, 0x48, 0x0C, 0x00, 0x81, 0x39, 0xEF,
  0xFA, 0x0B, 0x05, 0x77, 0x77, 0x30, 0x50, 0xCF, 0xFF, 0x0E, 0x06, 0x77, 0x76, 0x03, 0x0C, 0xFF,
  0xFC, 0x0D, 0x03, 0x77, 0x73, 0x09, 0xFF, 0xFF, 0x90, 0x77, 0x77, 0x01, 0x0C, 0xFD, 0x85, 0xEC,
  0xBB, 0xBB, 0xEF, 0xD0, 0xA7, 0x75, 0x02, 0x0D, 0xFA, 0x82, 0xE9, 0x51, 0x71, 0x81, 0x37, 0xDF,
  0xA0, 0xB7, 0x73, 0x02, 0x0E, 0xF9, 0x0C, 0x04, 0x77, 0x10, 0x40, 0xCF, 0x90, 0xA7, 0x71, 0x01,
  0x0E, 0xF0, 0xD0, 0x57, 0x75, 0x06, 0x0E, 0xF0, 0x77, 0x70, 0xCF, 0x0B, 0x01, 0x77, 0x70, 0x30,
  0xEF, 0x03, 0x75, 0x09, 0xF0, 0x97, 0x77, 0x30, 0x20, 0xEE, 0x0D, 0x74, 0x04, 0xF0, 0x87, 0x77,
  0x50, 0x4F, 0x07, 0x73, 0x0D, 0xE0, 0xA7, 0x77, 0x70, 0x9E, 0x0E, 0x01, 0x71, 0x07, 0xE0, 0xD7,
  0x77, 0x71, 0x01, 0x0E, 0xE0, 0x77, 0x01, 0x0E, 0xE0, 0x37, 0x77, 0x72, 0x07, 0xE0, 0xD7, 0x08,
  0xE0, 0xA7, 0x77, 0x73, 0x01, 0x0E, 0xE0, 0x46, 0x0E, 0xE0, 0x27, 0x77, 0x74, 0x09, 0xE0, 0x95,
  0x05, 0xE0, 0xA7, 0x77, 0x75, 0x04, 0xE0, 0xE5, 0x0B, 0xE0, 0x37, 0x77, 0x76, 0x0E, 0xE0, 0x33,
  0x01, 0xE0, 0xD7, 0x77, 0x77, 0x0A, 0xE0, 0x73, 0x06, 0xE0, 0x87, 0x77, 0x77, 0x07, 0xE0, 0xA3,
  0x0A, 0xE0, 0x37, 0x77, 0x77, 0x03, 0xE0, 0xD3, 0x0E, 0xD0, 0xE8, 0x0C, 0x00, 0x01, 0xF2, 0x02,
  0xE0, 0xB8, 0x0C, 0x10, 0x0E, 0xE8, 0x12, 0x05, 0xE0, 0x88, 0x0C, 0x10, 0x0D, 0xE8, 0x14, 0x08,
  0xE0, 0x68, 0x0C, 0x10, 0x0C, 0xE8, 0x15, 0x0A, 0xE0, 0x38, 0x0C, 0x10, 0x0B, 0xE8, 0x16, 0x0C,
  0xE0, 0x28, 0x0C, 0x10, 0x0A, 0xE8, 0x17, 0x0E, 0xE8, 0x0C, 0x2B, 0x0E, 0xE0, 0x71, 0x80, 0xE0,
  0xF0, 0x71, 0x80, 0xE0, 0xF0, 0x70, 0x18, 0x0E, 0x0F, 0x07, 0x02, 0x80, 0xE0, 0xF0, 0x70, 0x28,
  0x0E, 0x0F, 0x07, 0x01, 0xE0, 0xE8, 0x0D, 0x20, 0x01, 0xE0, 0xE8, 0x0D, 0x30, 0xF8, 0x0D, 0x30,
  0xF8, 0x0D, 0x30, 0x0E, 0xE0, 0x28, 0x0D, 0x20, 0x0C, 0xE0, 0x38, 0x0D, 0x20, 0x0A, 0xE0, 0x58,
  0x0D, 0x20, 0x08, 0xE0, 0x88, 0x0D, 0x20, 0x05, 0xE0, 0xB8, 0x0D, 0x20, 0x02, 0xE0, 0xE8, 0x0D,
  0x30, 0x0E, 0xE0, 0x38, 0x0D, 0x20, 0x0A, 0xE0, 0x78, 0x0D, 0x20, 0x06, 0xE0, 0xD8, 0x0D, 0x20,
  0x01, 0xF0, 0x38, 0x0D, 0x20, 0x0B, 0xE0, 0xA8, 0x0D, 0x20, 0x05, 0xF0, 0x28, 0x0D, 0x20, 0x0D,
  0xE0, 0xB8, 0x0D, 0x20, 0x06, 0xF0, 0x58, 0x0D, 0x20, 0x0D, 0xE0, 0xE0, 0x28, 0x0D, 0x10, 0x05,
  0xF0, 0xC0, 0x18, 0x0D, 0x10, 0x0A, 0xF0, 0xC8, 0x0D, 0x10, 0x01, 0x0E, 0xF0, 0xC0, 0x28, 0x0D,
  0x00, 0x03, 0xF9, 0x0E, 0x05, 0x77, 0x77, 0x28, 0x11, 0x8C, 0x74, 0x06, 0xFA, 0x0B, 0x02, 0x77,
  0x75, 0x05, 0x0B, 0xA0, 0xD7, 0x50, 0x7F, 0xB0, 0xB0, 0x47, 0x76, 0x82, 0x15, 0xAE, 0xC0, 0xD7,
  0x60, 0x6F, 0xC8, 0x3E, 0xA6, 0x31, 0x73, 0x83, 0x24, 0x69, 0xCF, 0x90, 0xD7, 0x70, 0x40, 0xEF,
  0xF9, 0x82, 0xDD, 0xCC, 0x0F, 0xDF, 0xF9, 0x0D, 0x77, 0x10, 0x20, 0xB8, 0x0C, 0x0F, 0x0D, 0x77,
  0x30, 0x50, 0xDF, 0xFF, 0xFD, 0x0A, 0x04, 0x77, 0x50, 0x50, 0xDF, 0xFF, 0xF8, 0x1D, 0x71, 0x77,
  0x72, 0x81, 0x38, 0xDF, 0xFF, 0x82, 0xEB, 0x72, 0x77, 0x77, 0x18, 0x32, 0x59, 0xBD, 0xFB, 0x84,
  0xEC, 0xB8, 0x63, 0x80, 0xC3, 0x00, 0xF1, 0x03, 0x02, 0x0F, 0x17, 0x75,
  // "é" (U+00E9)
  0x80, 0xC0, 0x00, 0x68, 0x04, 0xD8, 0x0D, 0x00, 0x01, 0x0E, 0xF0, 0xA8, 0x0D, 0x00, 0x0A, 0xF0,
  0xD8, 0x0D, 0x00, 0x05, 0xF0, 0xE0, 0x28, 0x0C, 0x70, 0x01, 0x0E, 0xF0, 0x48, 0x0D, 0x00, 0x0B,
  0xF0, 0x78, 0x0D, 0x00, 0x07, 0xF0, 0x98, 0x0D, 0x00, 0x04, 0xF0, 0xA8, 0x0D, 0x00, 0x01, 0x0E,
  0xE0, 0xB8, 0x0D, 0x10, 0x0B, 0xE0, 0xC0, 0x18, 0x0D, 0x00, 0x09, 0xE0, 0xD0, 0x18, 0x0D, 0x00,
  0x05, 0xE0, 0xD0, 0x18, 0x0D, 0x00, 0x03, 0xE0, 0xD0, 0x28, 0x0D, 0x00, 0x01, 0x0E, 0xD0, 0xD0,
  0x28, 0x0D, 0x10, 0x0C, 0xD0, 0xD0, 0x18, 0x0D, 0x10, 0x0B, 0xD0, 0xC0, 0x18, 0x0D, 0x10, 0x09,
  0xD0, 0xB0, 0x18, 0x0D, 0x10, 0x08, 0xD0, 0xA8, 0x0D, 0x20, 0x02, 0xD0, 0x88, 0x0D, 0x40, 0x80,
  0x13, 0x80, 0xEC, 0x50, 0x83, 0x26, 0x9B, 0xDD, 0x83, 0xEC, 0xA7, 0x48, 0x0C, 0x00, 0x81, 0x39,
  0xEF, 0xFA, 0x0B, 0x05, 0x77, 0x77, 0x30, 0x50, 0xCF, 0xFF, 0x0E, 0x06, 0x77, 0x76, 0x03, 0x0C,
  0xFF, 0xFC, 0x0D, 0x03, 0x77, 0x73, 0x09, 0xFF, 0xFF, 0x90, 0x77, 0x77, 0x01, 0x0C, 0xFD, 0x85,
  0xEC, 0xBB, 0xBB, 0xEF, 0xD0, 0xA7, 0x75, 0x02, 0x0D, 0xFA, 0x82, 0xE9, 0x51, 0x71, 0x81, 0x37,
  0xDF, 0xA0, 0xB7, 0x73, 0x02, 0x0E, 0xF9, 0x0C, 0x04, 0x77, 0x10, 0x40, 0xCF, 0x90, 0xA7, 0x71,
  0x01, 0x0E, 0xF0, 0xD0, 0x57, 0x75, 0x06, 0x0E, 0xF0, 0x77, 0x70, 0xCF, 0x0B, 0x01, 0x77, 0x70,
  0x30, 0xEF, 0x03, 0x75, 0x09, 0xF0, 0x97, 0x77, 0x30, 0x20, 0xEE, 0x0D, 0x74, 0x04, 0xF0, 0x87,
  0x77, 0x50, 0x4F, 0x07, 0x73, 0x0D, 0xE0, 0xA7, 0x77, 0x70, 0x9E, 0x0E, 0x01, 0x71, 0x07, 0xE0,
  0xD7, 0x77, 0x71, 0x01, 0x0E, 0xE0, 0x77, 0x01, 0x0E, 0xE0, 0x37, 0x77, 0x72, 0x07, 0xE0, 0xD7,
  0x08, 0xE0, 0xA7, 0x77, 0x73, 0x01, 0x0E, 0xE0, 0x46, 0x0E, 0xE0, 0x27, 0x77, 0x74, 0x09, 0xE0,
  0x95, 0x05, 0xE0, 0xA7, 0x77, 0x75, 0x04, 0xE0, 0xE5, 0x0B, 0xE0, 0x37, 0x77, 0x76, 0x0E, 0xE0,
  0x33, 0x01, 0xE0, 0xD7, 0x77, 0x77, 0x0A, 0xE0, 0x73, 0x06, 0xE0, 0x87, 0x77, 0x77, 0x07, 0xE0,
  0xA3, 0x0A, 0xE0, 0x37, 0x77, 0x77, 0x03, 0xE0, 0xD3, 0x0E, 0xD0, 0xE8, 0x0C, 0x00, 0x01, 0xF2,
  0x02, 0xE0, 0xB8, 0x0C, 0x10, 0x0E, 0xE8, 0x12, 0x05, 0xE0, 0x88, 0x0C, 0x10, 0x0D, 0xE8, 0x14,
  0x08, 0xE0, 0x68, 0x0C, 0x10, 0x0C, 0xE8, 0x15, 0x0A, 0xE0, 0x38, 0x0C, 0x10, 0x0B, 0xE8, 0x16,
  0x0C, 0xE0, 0x28, 0x0C, 0x10, 0x0A, 0xE8, 0x17, 0x0E, 0xE8, 0x0C, 0x2B, 0x0E, 0xE0, 0x71, 0x80,
  0xE0, 0xF0, 0x71, 0x80, 0xE0, 0xF0, 0x70, 0x18, 0x0E, 0x0F, 0x07, 0x02, 0x80, 0xE0, 0xF0, 0x70,
  0x28, 0x0E, 0x0F, 0x07, 0x01, 0xE0, 0xE8, 0x0D, 0x20, 0x01, 0xE0, 0xE8, 0x0D, 0x30, 0xF8, 0x0D,
  0x30, 0xF8, 0x0D, 0x30, 0x0E, 0xE0, 0x28, 0x0D, 0x20, 0x0C, 0xE0, 0x38, 0x0D, 0x20, 0x0A, 0xE0,
  0x58, 0x0D, 0x20, 0x08, 0xE0, 0x88, 0x0D, 0x20, 0x05, 0xE0, 0xB8, 0x0D, 0x20, 0x02, 0xE0, 0xE8,
  0x0D, 0x30, 0x0E, 0xE0, 0x38, 0x0D, 0x20, 0x0A, 0xE0, 0x78, 0x0D, 0x20, 0x06, 0xE0, 0xD8, 0x0D,
  0x20, 0x01, 0xF0, 0x38, 0x0D, 0x20, 0x0B, 0xE0, 0xA8, 0x0D, 0x20, 0x05, 0xF0, 0x28, 0x0D, 0x20,
  0x0D, 0xE0, 0xB8, 0x0D, 0x20, 0x06, 0xF0, 0x58, 0x0D, 0x20, 0x0D, 0xE0, 0xE0, 0x28, 0x0D, 0x10,
  0x05, 0xF0, 0xC0, 0x18, 0x0D, 0x10, 0x0A, 0xF0, 0xC8, 0x0D, 0x10, 0x01, 0x0E, 0xF0, 0xC0, 0x28,
  0x0D, 0x00, 0x03, 0xF9, 0x0E, 0x05, 0x77, 0x77, 0x28, 0x11, 0x8C, 0x74, 0x06, 0xFA, 0x0B, 0x02,
  0x77, 0x75, 0x05, 0x0B, 0xA0, 0xD7, 0x50, 0x7F, 0xB0, 0xB0, 0x47, 0x76, 0x82, 0x15, 0xAE, 0xC0,
  0xD7, 0x60, 0x6F, 0xC8, 0x3E, 0xA6, 0x31, 0x73, 0x83, 0x24, 0x69, 0xCF, 0x90, 0xD7, 0x70, 0x40,
  0xEF, 0xF9, 0x82, 0xDD, 0xCC, 0x0F, 0xDF, 0xF9, 0x0D, 0x77, 0x10, 0x20, 0xB8, 0x0C, 0x0F, 0x0D,
  0x77, 0x30, 0x50, 0xDF, 0xFF, 0xFD, 0x0A, 0x04, 0x77, 0x50, 0x50, 0xDF, 0xFF, 0xF8, 0x1D, 0x71,
  0x77, 0x72, 0x81, 0x38, 0xDF, 0xFF, 0x82, 0xEB, 0x72, 0x77, 0x77, 0x18, 0x32, 0x59, 0xBD, 0xFB,
  0x84, 0xEC, 0xB8, 0x63, 0x80, 0xC3, 0x00, 0xF1, 0x03, 0x02, 0x0F, 0x17, 0x75,
  // "ê" (U+00EA)
  0x77, 0x73, 0x05, 0x80, 0x2B, 0x05, 0x80, 0xD1, 0x00, 0x10, 0xEE, 0x0E, 0x01, 0x80, 0xD0, 0x00,
  0xBF, 0x90, 0xA8, 0x0C, 0x70, 0x06, 0xFB, 0x05, 0x80, 0xC5, 0x00, 0x20, 0xEF, 0xB0, 0xE0, 0x28,
  0x0C, 0x40, 0x0D, 0xFD, 0x0C, 0x80, 0xC3, 0x00, 0xAE, 0x0B, 0x0C, 0xE0, 0x98, 0x0C, 0x10, 0x06,
  0xE8, 0x2D, 0x11, 0xDE, 0x06, 0x77, 0x77, 0x70, 0x3E, 0x0D, 0x01, 0x20, 0x20, 0xEE, 0x04, 0x77,
  0x77, 0x50, 0x10, 0xED, 0x0E, 0x03, 0x40, 0x4E, 0x0E, 0x02, 0x77, 0x77, 0x40, 0xCE, 0x03, 0x60,
  0x5E, 0x0C, 0x77, 0x77, 0x30, 0xAE, 0x04, 0x71, 0x05, 0xE0, 0xA7, 0x77, 0x71, 0x08, 0xE0, 0x57,
  0x30, 0x6E, 0x08, 0x77, 0x76, 0x06, 0xE0, 0x67, 0x50, 0x7E, 0x05, 0x77, 0x74, 0x04, 0xE0, 0x57,
  0x70, 0x7E, 0x04, 0x77, 0x72, 0x03, 0x0E, 0xD0, 0x57, 0x72, 0x06, 0xD0, 0xE0, 0x27, 0x77, 0x02,
  0x0E, 0xD0, 0x57, 0x74, 0x06, 0xD0, 0xD0, 0x27, 0x75, 0x01, 0x0D, 0xC0, 0xE0, 0x37, 0x76, 0x04,
  0x0E, 0xC0, 0xD0, 0x17, 0x74, 0x09, 0xC0, 0xD0, 0x27, 0x77, 0x10, 0x30, 0xDC, 0x0A, 0x77, 0x48,
  0x42, 0x33, 0x33, 0x17, 0x77, 0x38, 0x41, 0x33, 0x33, 0x28, 0x0E, 0xA3, 0x08, 0x32, 0x69, 0xBD,
  0xD8, 0x3E, 0xCA, 0x74, 0x80, 0xC0, 0x08, 0x13, 0x9E, 0xFF, 0xA0, 0xB0, 0x57, 0x77, 0x73, 0x05,
  0x0C, 0xFF, 0xF0, 0xE0, 0x67, 0x77, 0x60, 0x30, 0xCF, 0xFF, 0xC0, 0xD0, 0x37, 0x77, 0x30, 0x9F,
  0xFF, 0xF9, 0x07, 0x77, 0x70, 0x10, 0xCF, 0xD8, 0x5E, 0xCB, 0xBB, 0xBE, 0xFD, 0x0A, 0x77, 0x50,
  0x20, 0xDF, 0xA8, 0x2E, 0x95, 0x17, 0x18, 0x13, 0x7D, 0xFA, 0x0B, 0x77, 0x30, 0x20, 0xEF, 0x90,
  0xC0, 0x47, 0x71, 0x04, 0x0C, 0xF9, 0x0A, 0x77, 0x10, 0x10, 0xEF, 0x0D, 0x05, 0x77, 0x50, 0x60,
  0xEF, 0x07, 0x77, 0x0C, 0xF0, 0xB0, 0x17, 0x77, 0x03, 0x0E, 0xF0, 0x37, 0x50, 0x9F, 0x09, 0x77,
  0x73, 0x02, 0x0E, 0xE0, 0xD7, 0x40, 0x4F, 0x08, 0x77, 0x75, 0x04, 0xF0, 0x77, 0x30, 0xDE, 0x0A,
  0x77, 0x77, 0x09, 0xE0, 0xE0, 0x17, 0x10, 0x7E, 0x0D, 0x77, 0x77, 0x10, 0x10, 0xEE, 0x07, 0x70,
  0x10, 0xEE, 0x03, 0x77, 0x77, 0x20, 0x7E, 0x0D, 0x70, 0x8E, 0x0A, 0x77, 0x77, 0x30, 0x10, 0xEE,
  0x04, 0x60, 0xEE, 0x02, 0x77, 0x77, 0x40, 0x9E, 0x09, 0x50, 0x5E, 0x0A, 0x77, 0x77, 0x50, 0x4E,
  0x0E, 0x50, 0xBE, 0x03, 0x77, 0x77, 0x60, 0xEE, 0x03, 0x30, 0x1E, 0x0D, 0x77, 0x77, 0x70, 0xAE,
  0x07, 0x30, 0x6E, 0x08, 0x77, 0x77, 0x70, 0x7E, 0x0A, 0x30, 0xAE, 0x03, 0x77, 0x77, 0x70, 0x3E,
  0x0D, 0x30, 0xED, 0x0E, 0x80, 0xC0, 0x00, 0x1F, 0x20, 0x2E, 0x0B, 0x80, 0xC1, 0x00, 0xEE, 0x81,
  0x20, 0x5E, 0x08, 0x80, 0xC1, 0x00, 0xDE, 0x81, 0x40, 0x8E, 0x06, 0x80, 0xC1, 0x00, 0xCE, 0x81,
  0x50, 0xAE, 0x03, 0x80, 0xC1, 0x00, 0xBE, 0x81, 0x60, 0xCE, 0x02, 0x80, 0xC1, 0x00, 0xAE, 0x81,
  0x70, 0xEE, 0x80, 0xC2, 0xB0, 0xEE, 0x07, 0x18, 0x0E, 0x0F, 0x07, 0x18, 0x0E, 0x0F, 0x07, 0x01,
  0x80, 0xE0, 0xF0, 0x70, 0x28, 0x0E, 0x0F, 0x07, 0x02, 0x80, 0xE0, 0xF0, 0x70, 0x1E, 0x0E, 0x80,
  0xD2, 0x00, 0x1E, 0x0E, 0x80, 0xD3, 0x0F, 0x80, 0xD3, 0x0F, 0x80, 0xD3, 0x00, 0xEE, 0x02, 0x80,
  0xD2, 0x00, 0xCE, 0x03, 0x80, 0xD2, 0x00, 0xAE, 0x05, 0x80, 0xD2, 0x00, 0x8E, 0x08, 0x80, 0xD2,
  0x00, 0x5E, 0x0B, 0x80, 0xD2, 0x00, 0x2E, 0x0E, 0x80, 0xD3, 0x00, 0xEE, 0x03, 0x80, 0xD2, 0x00,
  0xAE, 0x07, 0x80, 0xD2, 0x00, 0x6E, 0x0D, 0x80, 0xD2, 0x00, 0x1F, 0x03, 0x80, 0xD2, 0x00, 0xBE,
  0x0A, 0x80, 0xD2, 0x00, 0x5F, 0x02, 0x80, 0xD2, 0x00, 0xDE, 0x0B, 0x80, 0xD2, 0x00, 0x6F, 0x05,
  0x80, 0xD2, 0x00, 0xDE, 0x0E, 0x02, 0x80, 0xD1, 0x00, 0x5F, 0x0C, 0x01, 0x80, 0xD1, 0x00, 0xAF,
  0x0C, 0x80, 0xD1, 0x00, 0x10, 0xEF, 0x0C, 0x02, 0x80, 0xD0, 0x00, 0x3F, 0x90, 0xE0, 0x57, 0x77,
  0x72, 0x81, 0x18, 0xC7, 0x40, 0x6F, 0xA0, 0xB0, 0x27, 0x77, 0x50, 0x50, 0xBA, 0x0D, 0x75, 0x07,
  0xFB, 0x0B, 0x04, 0x77, 0x68, 0x21, 0x5A, 0xEC, 0x0D, 0x76, 0x06, 0xFC, 0x83, 0xEA, 0x63, 0x17,
  0x38, 0x32, 0x46, 0x9C, 0xF9, 0x0D, 0x77, 0x04, 0x0E, 0xFF, 0x98, 0x2D, 0xDC, 0xC0, 0xFD, 0xFF,
  0x90, 0xD7, 0x71, 0x02, 0x0B, 0x80, 0xC0, 0xF0, 0xD7, 0x73, 0x05, 0x0D, 0xFF, 0xFF, 0xD0, 0xA0,
  0x47, 0x75, 0x05, 0x0D, 0xFF, 0xFF, 0x81, 0xD7, 0x17, 0x77, 0x28, 0x13, 0x8D, 0xFF, 0xF8, 0x2E,
  0xB7, 0x27, 0x77, 0x71, 0x83, 0x25, 0x9B, 0xDF, 0xB8, 0x4E, 0xCB, 0x86, 0x38, 0x0C, 0x30, 0x0F,
  0x10, 0x30, 0x20, 0xF1, 0x77, 0x50,
  // "ë" (U+00EB)
  0x77, 0x18, 0x24, 0x55, 0x17, 0x74, 0x82, 0x35, 0x52, 0x77, 0x75, 0x03, 0x0E, 0xC0, 0x67, 0x71,
  0x01, 0x0B, 0xC0, 0xA7, 0x77, 0x40, 0xDE, 0x03, 0x77, 0x09, 0xE0, 0x87, 0x77, 0x20, 0x4F, 0x09,
  0x77, 0x0E, 0xE0, 0xE7, 0x77, 0x20, 0x7F, 0x0C, 0x76, 0x02, 0xF9, 0x02, 0x77, 0x71, 0x07, 0xF0,
  0xD7, 0x60, 0x2F, 0x90, 0x27, 0x77, 0x10, 0x6F, 0x0C, 0x76, 0x02, 0xF9, 0x01, 0x77, 0x71, 0x03,
  0xF0, 0x97, 0x70, 0xEE, 0x0E, 0x77, 0x73, 0x0D, 0xE0, 0x27, 0x70, 0x8E, 0x07, 0x77, 0x73, 0x02,
  0x0D, 0xB0, 0xE0, 0x57, 0x72, 0x0A, 0xC0, 0x97, 0x77, 0x60, 0xF3, 0x77, 0x58, 0x21, 0x33, 0x18,
  0x09, 0x9E, 0x00, 0x83, 0x26, 0x9B, 0xDD, 0x83, 0xEC, 0xA7, 0x48, 0x0C, 0x00, 0x81, 0x39, 0xEF,
  0xFA, 0x0B, 0x05, 0x77, 0x77, 0x30, 0x50, 0xCF, 0xFF, 0x0E, 0x06, 0x77, 0x76, 0x03, 0x0C, 0xFF,
  0xFC, 0x0D, 0x03, 0x77, 0x73, 0x09, 0xFF, 0xFF, 0x90, 0x77, 0x77, 0x01, 0x0C, 0xFD, 0x85, 0xEC,
  0xBB, 0xBB, 0xEF, 0xD0, 0xA7, 0x75, 0x02, 0x0D, 0xFA, 0x82, 0xE9, 0x51, 0x71, 0x81, 0x37, 0xDF,
  0xA0, 0xB7, 0x73, 0x02, 0x0E, 0xF9, 0x0C, 0x04, 0x77, 0x10, 0x40, 0xCF, 0x90, 0xA7, 0x71, 0x01,
  0x0E, 0xF0, 0xD0, 0x57, 0x75, 0x06, 0x0E, 0xF0, 0x77, 0x70, 0xCF, 0x0B, 0x01, 0x77, 0x70, 0x30,
  0xEF, 0x03, 0x75, 0x09, 0xF0, 0x97, 0x77, 0x30, 0x20, 0xEE, 0x0D, 0x74, 0x04, 0xF0, 0x87, 0x77,
  0x50, 0x4F, 0x07, 0x73, 0x0D, 0xE0, 0xA7, 0x77, 0x70, 0x9E, 0x0E, 0x01, 0x71, 0x07, 0xE0, 0xD7,
  0x77, 0x71, 0x01, 0x0E, 0xE0, 0x77, 0x01, 0x0E, 0xE0, 0x37, 0x77, 0x72, 0x07, 0xE0, 0xD7, 0x08,
  0xE0, 0xA7, 0x77, 0x73, 0x01, 0x0E, 0xE0, 0x46, 0x0E, 0xE0, 0x27, 0x77, 0x74, 0x09, 0xE0, 0x95,
  0x05, 0xE0, 0xA7, 0x77, 0x75, 0x04, 0xE0, 0xE5, 0x0B, 0xE0, 0x37, 0x77, 0x76, 0x0E, 0xE0, 0x33,
  0x01, 0xE0, 0xD7, 0x77, 0x77, 0x0A, 0xE0, 0x73, 0x06, 0xE0, 0x87, 0x77, 0x77, 0x07, 0xE0, 0xA3,
  0x0A, 0xE0, 0x37, 0x77, 0x77, 0x03, 0xE0, 0xD3, 0x0E, 0xD0, 0xE8, 0x0C, 0x00, 0x01, 0xF2, 0x02,
  0xE0, 0xB8, 0x0C, 0x10, 0x0E, 0xE8, 0x12, 0x05, 0xE0, 0x88, 0x0C, 0x10, 0x0D, 0xE8, 0x14, 0x08,
  0xE0, 0x68, 0x0C, 0x10, 0x0C, 0xE8, 0x15, 0x0A, 0xE0, 0x38, 0x0C, 0x10, 0x0B, 0xE8, 0x16, 0x0C,
  0xE0, 0x28, 0x0C, 0x10, 0x0A, 0xE8, 0x17, 0x0E, 0xE8, 0x0C, 0x2B, 0x0E, 0xE0, 0x71, 0x80, 0xE0,
  0xF0, 0x71, 0x80, 0xE0, 0xF0, 0x70, 0x18, 0x0E, 0x0F, 0x07, 0x02, 0x80, 0xE0, 0xF0, 0x70, 0x28,
  0x0E, 0x0F, 0x07, 0x01, 0xE0, 0xE8, 0x0D, 0x20, 0x01, 0xE0, 0xE8, 0x0D, 0x30, 0xF8, 0x0D, 0x30,
  0xF8, 0x0D, 0x30, 0x0E, 0xE0, 0x28, 0x0D, 0x20, 0x0C, 0xE0, 0x38, 0x0D, 0x20, 0x0A, 0xE0, 0x58,
  0x0D, 0x20, 0x08, 0xE0, 0x88, 0x0D, 0x20, 0x05, 0xE0, 0xB8, 0x0D, 0x20, 0x02, 0xE0, 0xE8, 0x0D,
  0x30, 0x0E, 0xE0, 0x38, 0x0D, 0x20, 0x0A, 0xE0, 0x78, 0x0D, 0x20, 0x06, 0xE0, 0xD8, 0x0D, 0x20,
  0x01, 0xF0, 0x38, 0x0D, 0x20, 0x0B, 0xE0, 0xA8, 0x0D, 0x20, 0x05, 0xF0, 0x28, 0x0D, 0x20, 0x0D,
  0xE0, 0xB8, 0x0D, 0x20, 0x06, 0xF0, 0x58, 0x0D, 0x20, 0x0D, 0xE0, 0xE0, 0x28, 0x0D, 0x10, 0x05,
  0xF0, 0xC0, 0x18, 0x0D, 0x10, 0x0A, 0xF0, 0xC8, 0x0D, 0x10, 0x01, 0x0E, 0xF0, 0xC0, 0x28, 0x0D,
  0x00, 0x03, 0xF9, 0x0E, 0x05, 0x77, 0x77, 0x28, 0x11, 0x8C, 0x74, 0x06, 0xFA, 0x0B, 0x02, 0x77,
  0x75, 0x05, 0x0B, 0xA0, 0xD7, 0x50, 0x7F, 0xB0, 0xB0, 0x47, 0x76, 0x82, 0x15, 0xAE, 0xC0, 0xD7,
  0x60, 0x6F, 0xC8, 0x3E, 0xA6, 0x31, 0x73, 0x83, 0x24, 0x69, 0xCF, 0x90, 0xD7, 0x70, 0x40, 0xEF,
  0xF9, 0x82, 0xDD, 0xCC, 0x0F, 0xDF, 0xF9, 0x0D, 0x77, 0x10, 0x20, 0xB8, 0x0C, 0x0F, 0x0D, 0x77,
  0x30, 0x50, 0xDF, 0xFF, 0xFD, 0x0A, 0x04, 0x77, 0x50, 0x50, 0xDF, 0xFF, 0xF8, 0x1D, 0x71, 0x77,
  0x72, 0x81, 0x38, 0xDF, 0xFF, 0x82, 0xEB, 0x72, 0x77, 0x77, 0x18, 0x32, 0x59, 0xBD, 0xFB, 0x84,
  0xEC, 0xB8, 0x63, 0x80, 0xC3, 0x00, 0xF1, 0x03, 0x02, 0x0F, 0x17, 0x75,
  // "ì" (U+00EC)
  0x02, 0x80, 0x4D, 0x02, 0x77, 0x0D, 0xF0, 0xB7, 0x70, 0x3F, 0x90, 0x57, 0x70, 0x6F, 0x0E, 0x01,
  0x77, 0x09, 0xF0, 0xB7, 0x71, 0x0B, 0xF0, 0x67, 0x71, 0x0C, 0xF0, 0x37, 0x70, 0x10, 0xDE, 0x0D,
  0x01, 0x77, 0x02, 0x0E, 0xE0, 0xA7, 0x71, 0x03, 0x0E, 0xE0, 0x77, 0x71, 0x03, 0x0E, 0xE0, 0x47,
  0x71, 0x03, 0x0E, 0xD0, 0xE0, 0x27, 0x71, 0x03, 0x0E, 0xD0, 0xC7, 0x72, 0x04, 0x0E, 0xD0, 0xA7,
  0x72, 0x03, 0x0E, 0xD0, 0x87, 0x72, 0x03, 0x0E, 0xD0, 0x77, 0x72, 0x02, 0x0D, 0xD0, 0x57, 0x72,
  0x01, 0x0C, 0xD0, 0x57, 0x73, 0x0A, 0xD7, 0x74, 0x80, 0x13, 0x80, 0xB8, 0x00, 0x05, 0x80, 0x2D,
  0x03, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E,
  0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E,
  0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E,
  0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E,
  0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E,
  0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E,
  0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E,
  0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E,
  0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E,
  0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E,
  0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E,
  0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E,
  0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E,
  0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E,
  0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E,
  0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x77, 0x10, 0x6E, 0x04, 0x30,
  // "í" (U+00ED)
  0x77, 0x06, 0x80, 0x3D, 0x0C, 0x76, 0x01, 0x0E, 0xF0, 0x97, 0x60, 0xBF, 0x0C, 0x76, 0x06, 0xF0,
  0xE0, 0x27, 0x50, 0x20, 0xEF, 0x04, 0x76, 0x0C, 0xF0, 0x67, 0x60, 0x8F, 0x08, 0x76, 0x04, 0xF0,
  0xA7, 0x60, 0x10, 0xEE, 0x0B, 0x77, 0x0C, 0xE0, 0xC7, 0x70, 0x9E, 0x0D, 0x01, 0x76, 0x06, 0xE0,
  0xD0, 0x17, 0x60, 0x3E, 0x0D, 0x01, 0x76, 0x02, 0x0E, 0xD0, 0xD0, 0x17, 0x60, 0x10, 0xDD, 0x0D,
  0x01, 0x77, 0x0B, 0xD0, 0xC0, 0x17, 0x70, 0xAD, 0x0B, 0x77, 0x10, 0x9D, 0x09, 0x77, 0x10, 0x3D,
  0x07, 0x77, 0x28, 0x41, 0x33, 0x33, 0x28, 0x0B, 0x87, 0x00, 0x58, 0x02, 0xD0, 0x37, 0x71, 0x06,
  0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06,
  0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06,
  0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06,
  0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06,
  0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06,
  0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06,
  0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06,
  0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06,
  0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06,
  0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06,
  0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06,
  0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06,
  0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06,
  0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06,
  0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06,
  0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x71, 0x06, 0xE0, 0x47, 0x60,
  // "î" (U+00EE)
  0x77, 0x05, 0x80, 0x2B, 0x05, 0x77, 0x76, 0x01, 0x0E, 0xE0, 0xE0, 0x17, 0x77, 0x50, 0xBF, 0x90,
  0xA7, 0x77, 0x40, 0x7F, 0xB0, 0x57, 0x77, 0x20, 0x3F, 0xC0, 0xE0, 0x17, 0x77, 0x10, 0xDF, 0xD0,
  0xC7, 0x77, 0x0A, 0xE0, 0xB0, 0xDE, 0x09, 0x77, 0x50, 0x7E, 0x82, 0xC0, 0x1E, 0xE0, 0x67, 0x73,
  0x04, 0xE0, 0xD0, 0x12, 0x03, 0x0E, 0xE0, 0x37, 0x71, 0x02, 0x0E, 0xD0, 0xE0, 0x24, 0x04, 0xE0,
  0xE0, 0x17, 0x60, 0x10, 0xDD, 0x0E, 0x03, 0x60, 0x5E, 0x0C, 0x76, 0x0B, 0xE0, 0x47, 0x10, 0x6E,
  0x0A, 0x74, 0x09, 0xE0, 0x57, 0x30, 0x7E, 0x07, 0x72, 0x07, 0xE0, 0x57, 0x50, 0x7E, 0x05, 0x70,
  0x5E, 0x05, 0x77, 0x07, 0xE0, 0x35, 0x03, 0xE0, 0x57, 0x72, 0x07, 0xD0, 0xE0, 0x23, 0x02, 0x0E,
  0xC0, 0xE0, 0x47, 0x74, 0x06, 0xD8, 0x3D, 0x10, 0x1D, 0xC0, 0xE0, 0x37, 0x76, 0x04, 0x0E, 0xC8,
  0x1D, 0x1A, 0xC0, 0xD0, 0x27, 0x77, 0x10, 0x30, 0xEC, 0x85, 0x92, 0x33, 0x33, 0x17, 0x77, 0x38,
  0x41, 0x33, 0x33, 0x28, 0x0C, 0xD2, 0x00, 0x58, 0x02, 0xD0, 0x37, 0x77, 0x70, 0x6E, 0x04, 0x77,
  0x77, 0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E,
  0x04, 0x77, 0x77, 0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0, 0x47, 0x77,
  0x70, 0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0,
  0x47, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x77,
  0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04,
  0x77, 0x77, 0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0, 0x47, 0x77, 0x70,
  0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0, 0x47,
  0x77, 0x70, 0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x77, 0x06,
  0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04, 0x77,
  0x77, 0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E,
  0x04, 0x77, 0x77, 0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0, 0x47, 0x77,
  0x70, 0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0,
  0x47, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x77,
  0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04,
  0x77, 0x77, 0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0, 0x47, 0x77, 0x70,
  0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0, 0x47,
  0x77, 0x70, 0x6E, 0x04, 0x77, 0x77, 0x06, 0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04, 0x77, 0x77, 0x06,
  0xE0, 0x47, 0x77, 0x70, 0x6E, 0x04, 0x77,
  // "ï" (U+00EF)
  0x38, 0x24, 0x55, 0x17, 0x74, 0x82, 0x25, 0x52, 0x40, 0x20, 0xDC, 0x07, 0x77, 0x20, 0xAC, 0x0B,
  0x01, 0x20, 0xDE, 0x05, 0x77, 0x08, 0xE8, 0x1A, 0x03, 0xF0, 0xB7, 0x70, 0xDF, 0x10, 0x5F, 0x0D,
  0x76, 0x01, 0xF9, 0x03, 0x06, 0xF0, 0xE7, 0x60, 0x1F, 0x90, 0x40, 0x5F, 0x0D, 0x77, 0xF9, 0x03,
  0x02, 0xF0, 0xA7, 0x70, 0xDE, 0x0E, 0x20, 0xBE, 0x03, 0x77, 0x07, 0xE0, 0x82, 0x01, 0x0C, 0xB0,
  0xE0, 0x67, 0x72, 0x09, 0xC0, 0x95, 0x81, 0x23, 0x37, 0x75, 0x82, 0x13, 0x31, 0x80, 0xE9, 0x30,
  0x05, 0x80, 0x2D, 0x03, 0x77, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73, 0x06,
  0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04, 0x77,
  0x73, 0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E,
  0x04, 0x77, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0, 0x47, 0x77,
  0x30, 0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0,
  0x47, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73,
  0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04,
  0x77, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x30,
  0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0, 0x47,
  0x77, 0x30, 0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73, 0x06,
  0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04, 0x77,
  0x73, 0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E,
  0x04, 0x77, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0, 0x47, 0x77,
  0x30, 0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0,
  0x47, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73,
  0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04,
  0x77, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x30,
  0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0, 0x47, 0x77, 0x30, 0x6E, 0x04, 0x77, 0x73, 0x06, 0xE0, 0x47,
  0x50,
  // "ð" (U+00F0)
  0x77, 0x50, 0x18, 0x0E, 0x30, 0x82, 0x4F, 0xA3, 0x77, 0x73, 0x03, 0x05, 0x77, 0x76, 0x0D, 0xB0,
  0xA0, 0x37, 0x76, 0x83, 0x1A, 0xFE, 0x27, 0x77, 0x40, 0x7E, 0x0A, 0x02, 0x77, 0x30, 0x70, 0xEB,
  0x0B, 0x77, 0x73, 0x01, 0x0E, 0xF9, 0x08, 0x77, 0x04, 0x0D, 0xE0, 0x67, 0x77, 0x20, 0x6F, 0xB0,
  0xD0, 0x57, 0x30, 0x10, 0xAF, 0x90, 0xE0, 0x17, 0x77, 0x20, 0x20, 0xAF, 0xB0, 0xA0, 0x17, 0x07,
  0x0E, 0xF9, 0x0D, 0x04, 0x77, 0x75, 0x02, 0x0B, 0xFA, 0x0E, 0x05, 0x40, 0x40, 0xDF, 0x90, 0xE0,
  0x77, 0x77, 0x72, 0x04, 0x0C, 0xFA, 0x82, 0xA0, 0x1A, 0xFA, 0x09, 0x01, 0x77, 0x77, 0x50, 0x70,
  0xEF, 0x90, 0xD0, 0xEF, 0x90, 0xC0, 0x38, 0x0C, 0x00, 0x02, 0x0B, 0xFF, 0x90, 0xE0, 0x58, 0x0C,
  0x40, 0x06, 0xFE, 0x08, 0x80, 0xC7, 0x00, 0x4F, 0xB0, 0xB0, 0x28, 0x0C, 0x70, 0x07, 0xFC, 0x0A,
  0x80, 0xC6, 0x00, 0x50, 0xDF, 0xE0, 0xA8, 0x0C, 0x30, 0x02, 0x0B, 0xFF, 0xA0, 0xA8, 0x0C, 0x00,
  0x01, 0x09, 0xFA, 0x81, 0xC5, 0xDF, 0x08, 0x77, 0x77, 0x60, 0x60, 0xEF, 0x90, 0xE0, 0x62, 0x02,
  0x0D, 0xF0, 0x67, 0x77, 0x73, 0x03, 0x0C, 0xFA, 0x09, 0x01, 0x40, 0x20, 0xDF, 0x03, 0x77, 0x77,
  0x01, 0x0A, 0xFA, 0x0B, 0x02, 0x70, 0x20, 0xEE, 0x0E, 0x01, 0x77, 0x75, 0x07, 0x0E, 0xF9, 0x0D,
  0x05, 0x73, 0x04, 0xF0, 0xB7, 0x77, 0x50, 0x9F, 0x0E, 0x07, 0x76, 0x06, 0xF0, 0x77, 0x77, 0x50,
  0xDD, 0x0A, 0x01, 0x77, 0x10, 0x9F, 0x03, 0x77, 0x74, 0x03, 0xB0, 0xC0, 0x47, 0x74, 0x0D, 0xE0,
  0xC7, 0x77, 0x58, 0x17, 0xE6, 0x77, 0x60, 0x3F, 0x07, 0x77, 0x75, 0x01, 0x77, 0x71, 0x07, 0xE0,
  0xE0, 0x18, 0x0D, 0x50, 0x0C, 0xE0, 0x98, 0x0D, 0x50, 0x03, 0xF0, 0x28, 0x0D, 0x50, 0x09, 0xE0,
  0xA8, 0x0D, 0x50, 0x01, 0x0E, 0xE0, 0x28, 0x0D, 0x50, 0x07, 0xE0, 0xA8, 0x0D, 0x60, 0x0E, 0xE0,
  0x18, 0x0D, 0x50, 0x06, 0xE0, 0x88, 0x0D, 0x60, 0x0E, 0xD0, 0xE8, 0x0D, 0x60, 0x08, 0xE0, 0x57,
  0x77, 0x70, 0x10, 0x28, 0x01, 0x30, 0x01, 0x75, 0x01, 0xE0, 0xB7, 0x77, 0x28, 0x22, 0x69, 0xCF,
  0xB8, 0x3E, 0xC9, 0x62, 0x71, 0x0B, 0xE0, 0x17, 0x75, 0x81, 0x17, 0xDF, 0xFD, 0x81, 0xD7, 0x15,
  0x05, 0xE0, 0x67, 0x73, 0x02, 0x0A, 0xFF, 0xFC, 0x08, 0x01, 0x40, 0xED, 0x0B, 0x77, 0x10, 0x10,
  0x9F, 0xFF, 0xF0, 0xE0, 0x63, 0x09, 0xE7, 0x70, 0x40, 0xEF, 0xFF, 0xFB, 0x82, 0xB1, 0x05, 0xE0,
  0x47, 0x50, 0x8F, 0xE8, 0x91, 0xCA, 0x97, 0x77, 0x79, 0xAC, 0xEF, 0xB8, 0x1D, 0x21, 0xE0, 0x87,
  0x40, 0xAF, 0xB8, 0x1D, 0x83, 0x75, 0x82, 0x15, 0x9E, 0xF8, 0x1D, 0x1C, 0xD0, 0xC7, 0x30, 0xAF,
  0xA0, 0xB0, 0x47, 0x75, 0x06, 0x0D, 0xE0, 0xC0, 0xBE, 0x72, 0x09, 0xF9, 0x0D, 0x04, 0x77, 0x72,
  0x07, 0x0E, 0xFD, 0x03, 0x70, 0x6F, 0x90, 0x97, 0x77, 0x50, 0x20, 0xDF, 0xC0, 0x66, 0x02, 0x0E,
  0xF0, 0x77, 0x77, 0x70, 0x10, 0xBF, 0xB0, 0x96, 0x0B, 0xF0, 0x67, 0x77, 0x73, 0x0C, 0xFA, 0x0B,
  0x50, 0x5F, 0x09, 0x77, 0x77, 0x40, 0x10, 0xDF, 0x90, 0xE5, 0x0D, 0xE0, 0xC7, 0x77, 0x76, 0x04,
  0xFA, 0x40, 0x6F, 0x02, 0x77, 0x77, 0x70, 0xAF, 0x90, 0x23, 0x0D, 0xE0, 0x98, 0x0C, 0x00, 0x03,
  0xF9, 0x04, 0x20, 0x4F, 0x01, 0x80, 0xC1, 0x00, 0xCF, 0x05, 0x20, 0x9E, 0x0A, 0x80, 0xC2, 0x00,
  0x6F, 0x06, 0x20, 0xEE, 0x04, 0x80, 0xC2, 0x00, 0x1F, 0x81, 0x70, 0x2E, 0x0E, 0x80, 0xC4, 0x00,
  0xCE, 0x81, 0x80, 0x6E, 0x0A, 0x80, 0xC4, 0x00, 0x9E, 0x81, 0x90, 0x9E, 0x06, 0x80, 0xC4, 0x00,
  0x7E, 0x81, 0x90, 0xCE, 0x03, 0x80, 0xC4, 0x00, 0x6E, 0x81, 0x90, 0xEE, 0x01, 0x80, 0xC4, 0x00,
  0x5E, 0x09, 0x01, 0xE0, 0xE8, 0x0C, 0x50, 0x05, 0xE0, 0x90, 0x2E, 0x0D, 0x80, 0xC5, 0x00, 0x5E,
  0x08, 0x03, 0xE0, 0xB8, 0x0C, 0x50, 0x05, 0xE0, 0x80, 0x3E, 0x0B, 0x80, 0xC5, 0x00, 0x6E, 0x07,
  0x04, 0xE0, 0xA8, 0x0C, 0x50, 0x07, 0xE0, 0x50, 0x4E, 0x0B, 0x80, 0xC5, 0x00, 0x9E, 0x04, 0x03,
  0xE0, 0xB8, 0x0C, 0x50, 0x0A, 0xE0, 0x02, 0xE0, 0xC8, 0x0C, 0x50, 0x0D, 0xE1, 0x01, 0xE0, 0xD8,
  0x0C, 0x50, 0xE0, 0xD2, 0xF8, 0x0C, 0x40, 0x02, 0xE0, 0xA2, 0x0D, 0xE0, 0x28, 0x0C, 0x30, 0x06,
  0xE0, 0x72, 0x0A, 0xE0, 0x58, 0x0C, 0x30, 0x09, 0xE0, 0x32, 0x07, 0xE0, 0x88, 0x0C, 0x30, 0x0D,
  0xD0, 0xE3, 0x03, 0xE0, 0xC8, 0x0C, 0x20, 0x03, 0xE0, 0xB4, 0x0E, 0xE0, 0x28, 0x0C, 0x10, 0x08,
  0xE0, 0x54, 0x09, 0xE0, 0x88, 0x0C, 0x10, 0x0E, 0xE0, 0x14, 0x04, 0xE0, 0xD8, 0x0C, 0x00, 0x05,
  0xE0, 0xA6, 0x0D, 0xE0, 0x67, 0x77, 0x77, 0x0D, 0xE0, 0x36, 0x06, 0xE0, 0xE0, 0x17, 0x77, 0x75,
  0x06, 0xE0, 0xC7, 0x10, 0xEE, 0x09, 0x77, 0x77, 0x40, 0x20, 0xEE, 0x04, 0x71, 0x06, 0xF0, 0x57,
  0x77, 0x73, 0x0B, 0xE0, 0xB7, 0x30, 0xCF, 0x03, 0x77, 0x77, 0x10, 0x9F, 0x02, 0x73, 0x02, 0x0E,
  0xE0, 0xE0, 0x37, 0x77, 0x60, 0x9F, 0x07, 0x75, 0x05, 0xF9, 0x06, 0x77, 0x74, 0x0A, 0xF0, 0xB7,
  0x70, 0x8F, 0x90, 0xB0, 0x27, 0x77, 0x04, 0x0D, 0xF0, 0xD0, 0x17, 0x71, 0x09, 0xFA, 0x09, 0x02,
  0x77, 0x30, 0x30, 0xBF, 0x90, 0xE0, 0x27, 0x73, 0x08, 0xFB, 0x81, 0xC7, 0x37, 0x48, 0x14, 0x7D,
  0xFA, 0x0E, 0x03, 0x77, 0x50, 0x6F, 0xE0, 0xD0, 0xB8, 0x01, 0x90, 0xB0, 0xDF, 0xD0, 0xD0, 0x27,
  0x77, 0x03, 0x0D, 0xFF, 0xFF, 0xB0, 0xA0, 0x17, 0x77, 0x30, 0x70, 0xEF, 0xFF, 0xE0, 0xD0, 0x57,
  0x77, 0x68, 0x11, 0x8E, 0xFF, 0xFA, 0x0E, 0x06, 0x77, 0x77, 0x40, 0x50, 0xBF, 0xFD, 0x0A, 0x04,
  0x80, 0xC1, 0x08, 0x24, 0x7A, 0xDF, 0xA8, 0x2C, 0xA7, 0x38, 0x0D, 0x10, 0x82, 0x11, 0x23, 0x0F,
  0x17, 0x77, 0x40,
  // "ñ" (U+00F1)
  0x80, 0xC5, 0x08, 0x01, 0x17, 0x74, 0x81, 0x5A, 0xDA, 0x82, 0xEC, 0x94, 0x77, 0x60, 0x9B, 0x0E,
  0x77, 0x20, 0x60, 0xEF, 0xA0, 0xC0, 0x47, 0x74, 0x0C, 0xB0, 0xD7, 0x70, 0x10, 0xBF, 0xE0, 0xB0,
  0x27, 0x71, 0x01, 0xC0, 0xA7, 0x70, 0xCF, 0xF9, 0x0E, 0x06, 0x77, 0x07, 0xC0, 0x77, 0x60, 0x9F,
  0xFC, 0x0B, 0x01, 0x75, 0x0D, 0xC0, 0x37, 0x50, 0x4F, 0x83, 0xCA, 0xAC, 0xEF, 0x90, 0xE0, 0x57,
  0x30, 0x8C, 0x0D, 0x76, 0x0C, 0xD0, 0xA0, 0x25, 0x05, 0x0D, 0xF9, 0x0A, 0x01, 0x70, 0x8D, 0x07,
  0x75, 0x03, 0xD0, 0x77, 0x20, 0x7F, 0xA8, 0x59, 0x42, 0x12, 0x7D, 0xD0, 0xE0, 0x17, 0x50, 0x8C,
  0x0A, 0x74, 0x02, 0x0C, 0xFF, 0xD0, 0x67, 0x60, 0xDC, 0x02, 0x76, 0x08, 0xFF, 0xB0, 0xA7, 0x60,
  0x1C, 0x0C, 0x77, 0x10, 0x40, 0xDF, 0xF0, 0xB7, 0x70, 0x3C, 0x07, 0x77, 0x30, 0x8F, 0xD0, 0x97,
  0x71, 0x05, 0xC0, 0x47, 0x74, 0x81, 0x29, 0xEF, 0x0A, 0x03, 0x77, 0x28, 0x43, 0x77, 0x77, 0x17,
  0x77, 0x85, 0x47, 0x77, 0x74, 0x18, 0x0E, 0xF7, 0x08, 0x42, 0x58, 0xBD, 0xED, 0x83, 0xDB, 0xA7,
  0x47, 0x71, 0x05, 0x80, 0x1D, 0x01, 0x74, 0x81, 0x17, 0xDF, 0xFA, 0x81, 0xEA, 0x57, 0x50, 0x6D,
  0x03, 0x72, 0x02, 0x0A, 0xFF, 0xF9, 0x0E, 0x07, 0x73, 0x06, 0xD0, 0x47, 0x10, 0x8F, 0xFF, 0xD0,
  0xD0, 0x47, 0x10, 0x6D, 0x05, 0x60, 0x20, 0xDF, 0xFF, 0xF9, 0x08, 0x70, 0x6D, 0x07, 0x50, 0x40,
  0xEF, 0xFF, 0xFB, 0x0A, 0x60, 0x6D, 0x08, 0x40, 0x5F, 0xA8, 0x3B, 0x85, 0x31, 0x58, 0x22, 0x47,
  0xBF, 0xC0, 0x95, 0x06, 0xD0, 0x93, 0x05, 0xF0, 0xB0, 0x57, 0x71, 0x81, 0x17, 0xEF, 0xA0, 0x64,
  0x06, 0xD0, 0xB2, 0x03, 0x0E, 0xD0, 0xC0, 0x37, 0x76, 0x08, 0xF9, 0x0E, 0x02, 0x30, 0x6D, 0x0C,
  0x20, 0xDD, 0x06, 0x77, 0x72, 0x04, 0x0E, 0xF0, 0xA3, 0x06, 0xD8, 0x1D, 0x08, 0xC0, 0xE0, 0x37,
  0x77, 0x40, 0x4F, 0x90, 0x32, 0x06, 0xE0, 0x2C, 0x0E, 0x02, 0x77, 0x76, 0x06, 0xF0, 0x92, 0x06,
  0xE0, 0xDC, 0x03, 0x77, 0x77, 0x10, 0xBE, 0x0E, 0x20, 0x6F, 0xB0, 0x67, 0x77, 0x72, 0x03, 0xF8,
  0x14, 0x06, 0xFA, 0x0C, 0x77, 0x77, 0x40, 0xCE, 0x81, 0x90, 0x6F, 0xA0, 0x37, 0x77, 0x74, 0x06,
  0xE8, 0x1C, 0x06, 0xF9, 0x0B, 0x77, 0x77, 0x50, 0x2F, 0x10, 0x6F, 0x90, 0x57, 0x77, 0x76, 0x0D,
  0xE0, 0x20, 0x6F, 0x0E, 0x77, 0x77, 0x70, 0xAE, 0x04, 0x06, 0xF0, 0x97, 0x77, 0x77, 0x08, 0xE0,
  0x06, 0xF0, 0x57, 0x77, 0x77, 0x06, 0xE0, 0x70, 0x6F, 0x02, 0x77, 0x77, 0x70, 0x5E, 0x07, 0x06,
  0xE0, 0xE8, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x0C, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0,
  0x98, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x08, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x68,
  0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x05, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x58, 0x0C,
  0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00,
  0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04,
  0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0,
  0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80,
  0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E,
  0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04,
  0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80,
  0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0,
  0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00,
  0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E,
  0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08,
  0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06,
  0xE0, 0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0,
  0x48, 0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48,
  0x0C, 0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C,
  0x00, 0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00,
  0x04, 0xE0, 0x80, 0x6E, 0x04, 0x80, 0xC0, 0x00, 0x4E, 0x08, 0x06, 0xE0, 0x48, 0x0C, 0x00, 0x04,
  0xE0, 0x80,
  // "ò" (U+00F2)
  0x77, 0x0B, 0x80, 0x3D, 0x06, 0x80, 0xD5, 0x00, 0x8F, 0x0E, 0x01, 0x80, 0xD5, 0x00, 0xCF, 0x0B,
  0x80, 0xD5, 0x00, 0x10, 0xEF, 0x06, 0x80, 0xD5, 0x00, 0x3F, 0x0E, 0x02, 0x80, 0xD5, 0x00, 0x6F,
  0x0C, 0x80, 0xD6, 0x00, 0x8F, 0x08, 0x80, 0xD6, 0x00, 0x9F, 0x04, 0x80, 0xD6, 0x00, 0xAE, 0x0E,
  0x01, 0x80, 0xD6, 0x00, 0xBE, 0x0C, 0x80, 0xD7, 0x00, 0xCE, 0x09, 0x80, 0xD7, 0x00, 0xCE, 0x06,
  0x80, 0xD6, 0x00, 0x10, 0xCE, 0x03, 0x80, 0xD6, 0x00, 0x10, 0xCD, 0x0E, 0x02, 0x80, 0xD7, 0x00,
  0xCD, 0x0D, 0x01, 0x80, 0xD7, 0x00, 0xBD, 0x0B, 0x80, 0xE0, 0x00, 0xAD, 0x0B, 0x80, 0xE0, 0x00,
  0x8D, 0x0A, 0x80, 0xE0, 0x00, 0x6D, 0x05, 0x80, 0xE0, 0x08, 0x42, 0x33, 0x33, 0x18, 0x0E, 0xF5,
  0x08, 0x34, 0x7A, 0xCD, 0xD8, 0x4E, 0xDB, 0x86, 0x28, 0x0C, 0x20, 0x81, 0x17, 0xCF, 0xFB, 0x81,
  0xD9, 0x37, 0x77, 0x75, 0x03, 0x0B, 0xFF, 0xFA, 0x0D, 0x06, 0x77, 0x77, 0x10, 0x30, 0xBF, 0xFF,
  0xE0, 0xD0, 0x47, 0x77, 0x50, 0x8F, 0xFF, 0xFB, 0x0A, 0x01, 0x77, 0x71, 0x02, 0x0C, 0xFF, 0xFF,
  0xD0, 0xD0, 0x37, 0x76, 0x03, 0x0E, 0xFB, 0x83, 0xDA, 0x64, 0x25, 0x83, 0x13, 0x59, 0xDF, 0xB0,
  0xE0, 0x47, 0x74, 0x04, 0x0E, 0xF9, 0x81, 0xE9, 0x37, 0x71, 0x81, 0x28, 0xEF, 0xA0, 0x47, 0x72,
  0x03, 0x0E, 0xF9, 0x09, 0x01, 0x77, 0x50, 0x10, 0x8F, 0xA0, 0x37, 0x70, 0x10, 0xEF, 0x0D, 0x03,
  0x77, 0x72, 0x03, 0x0D, 0xF0, 0xE0, 0x17, 0x60, 0xCF, 0x0B, 0x77, 0x75, 0x01, 0x0B, 0xF0, 0xC7,
  0x50, 0x8F, 0x0B, 0x77, 0x77, 0x10, 0xBF, 0x07, 0x73, 0x02, 0xF0, 0xC7, 0x77, 0x72, 0x01, 0x0D,
  0xF0, 0x17, 0x20, 0xBE, 0x0E, 0x02, 0x77, 0x77, 0x30, 0x2F, 0x0A, 0x71, 0x04, 0xF0, 0x67, 0x77,
  0x75, 0x07, 0xF0, 0x27, 0x0B, 0xE0, 0xC7, 0x77, 0x77, 0x0D, 0xE0, 0x96, 0x03, 0xF0, 0x47, 0x77,
  0x77, 0x05, 0xF0, 0x15, 0x09, 0xE0, 0xC8, 0x0C, 0x10, 0x0D, 0xE0, 0x65, 0x0E, 0xE0, 0x58, 0x0C,
  0x10, 0x07, 0xE0, 0xC4, 0x04, 0xE0, 0xE8, 0x0C, 0x20, 0x02, 0xF0, 0x13, 0x08, 0xE0, 0xA8, 0x0C,
  0x30, 0x0D, 0xE0, 0x53, 0x0D, 0xE0, 0x58, 0x0C, 0x30, 0x08, 0xE0, 0xA2, 0x01, 0xF0, 0x18, 0x0C,
  0x30, 0x04, 0xE0, 0xD2, 0x04, 0xE0, 0xD8, 0x0C, 0x40, 0x01, 0xF8, 0x11, 0x07, 0xE0, 0xA8, 0x0C,
  0x50, 0x0D, 0xE8, 0x14, 0x09, 0xE0, 0x78, 0x0C, 0x50, 0x0A, 0xE8, 0x16, 0x0B, 0xE0, 0x58, 0x0C,
  0x50, 0x08, 0xE8, 0x18, 0x0D, 0xE0, 0x38, 0x0C, 0x50, 0x07, 0xE8, 0x1A, 0x0E, 0xE0, 0x28, 0x0C,
  0x50, 0x05, 0xE0, 0xB1, 0xF8, 0x0C, 0x60, 0x03, 0xE0, 0xC0, 0x1F, 0x80, 0xC6, 0x00, 0x3E, 0x0D,
  0x01, 0xE0, 0xE8, 0x0C, 0x60, 0x02, 0xE0, 0xE0, 0x2E, 0x0E, 0x80, 0xC6, 0x00, 0x2E, 0x0E, 0x02,
  0xE0, 0xE8, 0x0C, 0x60, 0x02, 0xE0, 0xE0, 0x1E, 0x0E, 0x80, 0xC6, 0x00, 0x2E, 0x0E, 0x01, 0xF8,
  0x0C, 0x60, 0x03, 0xE0, 0xD1, 0xF8, 0x0C, 0x60, 0x03, 0xE0, 0xD1, 0xF0, 0x18, 0x0C, 0x50, 0x05,
  0xE8, 0x1B, 0x0D, 0xE0, 0x38, 0x0C, 0x50, 0x06, 0xE8, 0x1A, 0x0B, 0xE0, 0x58, 0x0C, 0x50, 0x08,
  0xE8, 0x18, 0x09, 0xE0, 0x78, 0x0C, 0x50, 0x0A, 0xE8, 0x16, 0x07, 0xE0, 0x98, 0x0C, 0x50, 0x0D,
  0xE8, 0x14, 0x04, 0xE0, 0xD8, 0x0C, 0x40, 0x01, 0xF8, 0x11, 0x01, 0xF0, 0x18, 0x0C, 0x30, 0x04,
  0xE0, 0xD3, 0x0D, 0xE0, 0x58, 0x0C, 0x30, 0x08, 0xE0, 0xA3, 0x08, 0xE0, 0x98, 0x0C, 0x30, 0x0D,
  0xE0, 0x63, 0x04, 0xE0, 0xE8, 0x0C, 0x20, 0x02, 0xF0, 0x14, 0x0E, 0xE0, 0x58, 0x0C, 0x10, 0x08,
  0xE0, 0xC5, 0x09, 0xE0, 0xB8, 0x0C, 0x10, 0x0E, 0xE0, 0x75, 0x03, 0xF0, 0x37, 0x77, 0x77, 0x06,
  0xF0, 0x16, 0x0B, 0xE0, 0xA7, 0x77, 0x77, 0x0D, 0xE0, 0x97, 0x04, 0xF0, 0x47, 0x77, 0x75, 0x08,
  0xF0, 0x27, 0x10, 0xBE, 0x0D, 0x77, 0x77, 0x40, 0x2F, 0x0A, 0x72, 0x03, 0xF0, 0x97, 0x77, 0x73,
  0x0D, 0xF0, 0x17, 0x30, 0x8F, 0x06, 0x77, 0x77, 0x10, 0xAF, 0x07, 0x75, 0x0D, 0xF0, 0x67, 0x77,
  0x60, 0xAF, 0x0C, 0x76, 0x02, 0x0E, 0xF0, 0x87, 0x77, 0x30, 0x10, 0xBF, 0x0E, 0x01, 0x77, 0x04,
  0xF9, 0x0C, 0x03, 0x77, 0x70, 0x60, 0xEF, 0x90, 0x37, 0x72, 0x06, 0xFA, 0x0A, 0x03, 0x77, 0x30,
  0x60, 0xDF, 0xA0, 0x47, 0x74, 0x05, 0xFB, 0x82, 0xD8, 0x41, 0x72, 0x82, 0x26, 0xAE, 0xFA, 0x0E,
  0x04, 0x77, 0x60, 0x30, 0xEF, 0xD0, 0xE0, 0xC8, 0x01, 0xB0, 0xDF, 0xE0, 0xD0, 0x37, 0x77, 0x10,
  0x10, 0xBF, 0xFF, 0xFB, 0x0A, 0x01, 0x77, 0x74, 0x06, 0x0E, 0xFF, 0xFE, 0x0D, 0x04, 0x77, 0x77,
  0x10, 0x70, 0xEF, 0xFF, 0xA0, 0xD0, 0x67, 0x77, 0x75, 0x05, 0x0B, 0xFF, 0xC8, 0x1E, 0xA4, 0x80,
  0xC2, 0x08, 0x24, 0x8A, 0xDF, 0xA8, 0x2C, 0xA7, 0x38, 0x0D, 0x20, 0x84, 0x11, 0x23, 0x11, 0x77,
  0x75,
  // "ó" (U+00F3)
  0x80, 0xC1, 0x00, 0x10, 0xC8, 0x03, 0xD0, 0x58, 0x0D, 0x40, 0x09, 0xF0, 0xE0, 0x28, 0x0D, 0x30,
  0x03, 0xF9, 0x05, 0x80, 0xD4, 0x00, 0xDF, 0x08, 0x80, 0xD4, 0x00, 0x9F, 0x0B, 0x80, 0xD4, 0x00,
  0x5F, 0x0D, 0x01, 0x80, 0xD3, 0x00, 0x20, 0xEE, 0x0E, 0x02, 0x80, 0xD4, 0x00, 0xCE, 0x0E, 0x03,
  0x80, 0xD4, 0x00, 0x8F, 0x04, 0x80, 0xD4, 0x00, 0x5F, 0x05, 0x80, 0xD4, 0x00, 0x20, 0xEE, 0x06,
  0x80, 0xD4, 0x00, 0x10, 0xDE, 0x06, 0x80, 0xD5, 0x00, 0xBE, 0x06, 0x80, 0xD5, 0x00, 0x9E, 0x07,
  0x80, 0xD5, 0x00, 0x6E, 0x06, 0x80, 0xD5, 0x00, 0x5E, 0x05, 0x80, 0xD5, 0x00, 0x30, 0xEC, 0x0E,
  0x04, 0x80, 0xD5, 0x00, 0x20, 0xEC, 0x0E, 0x03, 0x80, 0xD6, 0x00, 0xBC, 0x0C, 0x02, 0x80, 0xD7,
  0x08, 0x01, 0x38, 0x0F, 0x85, 0x08, 0x34, 0x7A, 0xCD, 0xD8, 0x4E, 0xDB, 0x86, 0x28, 0x0C, 0x20,
  0x81, 0x17, 0xCF, 0xFB, 0x81, 0xD9, 0x37, 0x77, 0x75, 0x03, 0x0B, 0xFF, 0xFA, 0x0D, 0x06, 0x77,
  0x77, 0x10, 0x30, 0xBF, 0xFF, 0xE0, 0xD0, 0x47, 0x77, 0x50, 0x8F, 0xFF, 0xFB, 0x0A, 0x01, 0x77,
  0x71, 0x02, 0x0C, 0xFF, 0xFF, 0xD0, 0xD0, 0x37, 0x76, 0x03, 0x0E, 0xFB, 0x83, 0xDA, 0x64, 0x25,
  0x83, 0x13, 0x59, 0xDF, 0xB0, 0xE0, 0x47, 0x74, 0x04, 0x0E, 0xF9, 0x81, 0xE9, 0x37, 0x71, 0x81,
  0x28, 0xEF, 0xA0, 0x47, 0x72, 0x03, 0x0E, 0xF9, 0x09, 0x01, 0x77, 0x50, 0x10, 0x8F, 0xA0, 0x37,
  0x70, 0x10, 0xEF, 0x0D, 0x03, 0x77, 0x72, 0x03, 0x0D, 0xF0, 0xE0, 0x17, 0x60, 0xCF, 0x0B, 0x77,
  0x75, 0x01, 0x0B, 0xF0, 0xC7, 0x50, 0x8F, 0x0B, 0x77, 0x77, 0x10, 0xBF, 0x07, 0x73, 0x02, 0xF0,
  0xC7, 0x77, 0x72, 0x01, 0x0D, 0xF0, 0x17, 0x20, 0xBE, 0x0E, 0x02, 0x77, 0x77, 0x30, 0x2F, 0x0A,
  0x71, 0x04, 0xF0, 0x67, 0x77, 0x75, 0x07, 0xF0, 0x27, 0x0B, 0xE0, 0xC7, 0x77, 0x77, 0x0D, 0xE0,
  0x96, 0x03, 0xF0, 0x47, 0x77, 0x77, 0x05, 0xF0, 0x15, 0x09, 0xE0, 0xC8, 0x0C, 0x10, 0x0D, 0xE0,
  0x65, 0x0E, 0xE0, 0x58, 0x0C, 0x10, 0x07, 0xE0, 0xC4, 0x04, 0xE0, 0xE8, 0x0C, 0x20, 0x02, 0xF0,
  0x13, 0x08, 0xE0, 0xA8, 0x0C, 0x30, 0x0D, 0xE0, 0x53, 0x0D, 0xE0, 0x58, 0x0C, 0x30, 0x08, 0xE0,
  0xA2, 0x01, 0xF0, 0x18, 0x0C, 0x30, 0x04, 0xE0, 0xD2, 0x04, 0xE0, 0xD8, 0x0C, 0x40, 0x01, 0xF8,
  0x11, 0x07, 0xE0, 0xA8, 0x0C, 0x50, 0x0D, 0xE8, 0x14, 0x09, 0xE0, 0x78, 0x0C, 0x50, 0x0A, 0xE8,
  0x16, 0x0B, 0xE0, 0x58, 0x0C, 0x50, 0x08, 0xE8, 0x18, 0x0D, 0xE0, 0x38, 0x0C, 0x50, 0x07, 0xE8,
  0x1A, 0x0E, 0xE0, 0x28, 0x0C, 0x50, 0x05, 0xE0, 0xB1, 0xF8, 0x0C, 0x60, 0x03, 0xE0, 0xC0, 0x1F,
  0x80, 0xC6, 0x00, 0x3E, 0x0D, 0x01, 0xE0, 0xE8, 0x0C, 0x60, 0x02, 0xE0, 0xE0, 0x2E, 0x0E, 0x80,
  0xC6, 0x00, 0x2E, 0x0E, 0x02, 0xE0, 0xE8, 0x0C, 0x60, 0x02, 0xE0, 0xE0, 0x1E, 0x0E, 0x80, 0xC6,
  0x00, 0x2E, 0x0E, 0x01, 0xF8, 0x0C, 0x60, 0x03, 0xE0, 0xD1, 0xF8, 0x0C, 0x60, 0x03, 0xE0, 0xD1,
  0xF0, 0x18, 0x0C, 0x50, 0x05, 0xE8, 0x1B, 0x0D, 0xE0, 0x38, 0x0C, 0x50, 0x06, 0xE8, 0x1A, 0x0B,
  0xE0, 0x58, 0x0C, 0x50, 0x08, 0xE8, 0x18, 0x09, 0xE0, 0x78, 0x0C, 0x50, 0x0A, 0xE8, 0x16, 0x07,
  0xE0, 0x98, 0x0C, 0x50, 0x0D, 0xE8, 0x14, 0x04, 0xE0, 0xD8, 0x0C, 0x40, 0x01, 0xF8, 0x11, 0x01,
  0xF0, 0x18, 0x0C, 0x30, 0x04, 0xE0, 0xD3, 0x0D, 0xE0, 0x58, 0x0C, 0x30, 0x08, 0xE0, 0xA3, 0x08,
  0xE0, 0x98, 0x0C, 0x30, 0x0D, 0xE0, 0x63, 0x04, 0xE0, 0xE8, 0x0C, 0x20, 0x02, 0xF0, 0x14, 0x0E,
  0xE0, 0x58, 0x0C, 0x10, 0x08, 0xE0, 0xC5, 0x09, 0xE0, 0xB8, 0x0C, 0x10, 0x0E, 0xE0, 0x75, 0x03,
  0xF0, 0x37, 0x77, 0x77, 0x06, 0xF0, 0x16, 0x0B, 0xE0, 0xA7, 0x77, 0x77, 0x0D, 0xE0, 0x97, 0x04,
  0xF0, 0x47, 0x77, 0x75, 0x08, 0xF0, 0x27, 0x10, 0xBE, 0x0D, 0x77, 0x77, 0x40, 0x2F, 0x0A, 0x72,
  0x03, 0xF0, 0x97, 0x77, 0x73, 0x0D, 0xF0, 0x17, 0x30, 0x8F, 0x06, 0x77, 0x77, 0x10, 0xAF, 0x07,
  0x75, 0x0D, 0xF0, 0x67, 0x77, 0x60, 0xAF, 0x0C, 0x76, 0x02, 0x0E, 0xF0, 0x87, 0x77, 0x30, 0x10,
  0xBF, 0x0E, 0x01, 0x77, 0x04, 0xF9, 0x0C, 0x03, 0x77, 0x70, 0x60, 0xEF, 0x90, 0x37, 0x72, 0x06,
  0xFA, 0x0A, 0x03, 0x77, 0x30, 0x60, 0xDF, 0xA0, 0x47, 0x74, 0x05, 0xFB, 0x82, 0xD8, 0x41, 0x72,
  0x82, 0x26, 0xAE, 0xFA, 0x0E, 0x04, 0x77, 0x60, 0x30, 0xEF, 0xD0, 0xE0, 0xC8, 0x01, 0xB0, 0xDF,
  0xE0, 0xD0, 0x37, 0x77, 0x10, 0x10, 0xBF, 0xFF, 0xFB, 0x0A, 0x01, 0x77, 0x74, 0x06, 0x0E, 0xFF,
  0xFE, 0x0D, 0x04, 0x77, 0x77, 0x10, 0x70, 0xEF, 0xFF, 0xA0, 0xD0, 0x67, 0x77, 0x75, 0x05, 0x0B,
  0xFF, 0xC8, 0x1E, 0xA4, 0x80, 0xC2, 0x08, 0x24, 0x8A, 0xDF, 0xA8, 0x2C, 0xA7, 0x38, 0x0D, 0x20,
  0x84, 0x11, 0x23, 0x11, 0x77, 0x75,
  // "ô" (U+00F4)
  0x77, 0x74, 0x01, 0x80, 0x2B, 0x0A, 0x80, 0xD6, 0x00, 0x9F, 0x07, 0x80, 0xD4, 0x00, 0x4F, 0x90,
  0xE0, 0x28, 0x0D, 0x20, 0x01, 0x0D, 0xFA, 0x0C, 0x80, 0xD2, 0x00, 0xAF, 0xC0, 0x88, 0x0D, 0x00,
  0x07, 0xFE, 0x04, 0x80, 0xC6, 0x00, 0x3F, 0x09, 0xE0, 0xE0, 0x28, 0x0C, 0x40, 0x01, 0x0E, 0xE8,
  0x15, 0x08, 0xE0, 0xC8, 0x0C, 0x40, 0x0C, 0xE0, 0x73, 0x0A, 0xE0, 0xA8, 0x0C, 0x20, 0x09, 0xE0,
  0x95, 0x0B, 0xE0, 0x78, 0x0C, 0x00, 0x06, 0xE0, 0xA6, 0x01, 0x0C, 0xE0, 0x57, 0x77, 0x76, 0x04,
  0xE0, 0xA7, 0x10, 0x10, 0xDD, 0x0E, 0x02, 0x77, 0x77, 0x40, 0x20, 0xED, 0x0B, 0x73, 0x01, 0x0D,
  0xD0, 0xD0, 0x17, 0x77, 0x72, 0x01, 0x0D, 0xD0, 0xB7, 0x50, 0x20, 0xDD, 0x0C, 0x77, 0x77, 0x20,
  0xCD, 0x0B, 0x77, 0x02, 0x0D, 0xD0, 0xA7, 0x77, 0x70, 0xBD, 0x0B, 0x77, 0x20, 0x10, 0xDD, 0x08,
  0x77, 0x75, 0x09, 0xD0, 0xA7, 0x74, 0x01, 0x0C, 0xD0, 0x77, 0x77, 0x30, 0x8D, 0x09, 0x77, 0x60,
  0x10, 0xBD, 0x06, 0x77, 0x71, 0x03, 0xD0, 0x77, 0x77, 0x20, 0x9D, 0x01, 0x77, 0x78, 0x41, 0x33,
  0x33, 0x27, 0x77, 0x48, 0x01, 0x38, 0x0E, 0xE3, 0x08, 0x34, 0x7A, 0xCD, 0xD8, 0x4E, 0xDB, 0x86,
  0x28, 0x0C, 0x20, 0x81, 0x17, 0xCF, 0xFB, 0x81, 0xD9, 0x37, 0x77, 0x75, 0x03, 0x0B, 0xFF, 0xFA,
  0x0D, 0x06, 0x77, 0x77, 0x10, 0x30, 0xBF, 0xFF, 0xE0, 0xD0, 0x47, 0x77, 0x50, 0x8F, 0xFF, 0xFB,
  0x0A, 0x01, 0x77, 0x71, 0x02, 0x0C, 0xFF, 0xFF, 0xD0, 0xD0, 0x37, 0x76, 0x03, 0x0E, 0xFB, 0x83,
  0xDA, 0x64, 0x25, 0x83, 0x13, 0x59, 0xDF, 0xB0, 0xE0, 0x47, 0x74, 0x04, 0x0E, 0xF9, 0x81, 0xE9,
  0x37, 0x71, 0x81, 0x28, 0xEF, 0xA0, 0x47, 0x72, 0x03, 0x0E, 0xF9, 0x09, 0x01, 0x77, 0x50, 0x10,
  0x8F, 0xA0, 0x37, 0x70, 0x10, 0xEF, 0x0D, 0x03, 0x77, 0x72, 0x03, 0x0D, 0xF0, 0xE0, 0x17, 0x60,
  0xCF, 0x0B, 0x77, 0x75, 0x01, 0x0B, 0xF0, 0xC7, 0x50, 0x8F, 0x0B, 0x77, 0x77, 0x10, 0xBF, 0x07,
  0x73, 0x02, 0xF0, 0xC7, 0x77, 0x72, 0x01, 0x0D, 0xF0, 0x17, 0x20, 0xBE, 0x0E, 0x02, 0x77, 0x77,
  0x30, 0x2F, 0x0A, 0x71, 0x04, 0xF0, 0x67, 0x77, 0x75, 0x07, 0xF0, 0x27, 0x0B, 0xE0, 0xC7, 0x77,
  0x77, 0x0D, 0xE0, 0x96, 0x03, 0xF0, 0x47, 0x77, 0x77, 0x05, 0xF0, 0x15, 0x09, 0xE0, 0xC8, 0x0C,
  0x10, 0x0D, 0xE0, 0x65, 0x0E, 0xE0, 0x58, 0x0C, 0x10, 0x07, 0xE0, 0xC4, 0x04, 0xE0, 0xE8, 0x0C,
  0x20, 0x02, 0xF0, 0x13, 0x08, 0xE0, 0xA8, 0x0C, 0x30, 0x0D, 0xE0, 0x53, 0x0D, 0xE0, 0x58, 0x0C,
  0x30, 0x08, 0xE0, 0xA2, 0x01, 0xF0, 0x18, 0x0C, 0x30, 0x04, 0xE0, 0xD2, 0x04, 0xE0, 0xD8, 0x0C,
  0x40, 0x01, 0xF8, 0x11, 0x07, 0xE0, 0xA8, 0x0C, 0x50, 0x0D, 0xE8, 0x14, 0x09, 0xE0, 0x78, 0x0C,
  0x50, 0x0A, 0xE8, 0x16, 0x0B, 0xE0, 0x58, 0x0C, 0x50, 0x08, 0xE8, 0x18, 0x0D, 0xE0, 0x38, 0x0C,
  0x50, 0x07, 0xE8, 0x1A, 0x0E, 0xE0, 0x28, 0x0C, 0x50, 0x05, 0xE0, 0xB1, 0xF8, 0x0C, 0x60, 0x03,
  0xE0, 0xC0, 0x1F, 0x80, 0xC6, 0x00, 0x3E, 0x0D, 0x01, 0xE0, 0xE8, 0x0C, 0x60, 0x02, 0xE0, 0xE0,
  0x2E, 0x0E, 0x80, 0xC6, 0x00, 0x2E, 0x0E, 0x02, 0xE0, 0xE8, 0x0C, 0x60, 0x02, 0xE0, 0xE0, 0x1E,
  0x0E, 0x80, 0xC6, 0x00, 0x2E, 0x0E, 0x01, 0xF8, 0x0C, 0x60, 0x03, 0xE0, 0xD1, 0xF8, 0x0C, 0x60,
  0x03, 0xE0, 0xD1, 0xF0, 0x18, 0x0C, 0x50, 0x05, 0xE8, 0x1B, 0x0D, 0xE0, 0x38, 0x0C, 0x50, 0x06,
  0xE8, 0x1A, 0x0B, 0xE0, 0x58, 0x0C, 0x50, 0x08, 0xE8, 0x18, 0x09, 0xE0, 0x78, 0x0C, 0x50, 0x0A,
  0xE8, 0x16, 0x07, 0xE0, 0x98, 0x0C, 0x50, 0x0D, 0xE8, 0x14, 0x04, 0xE0, 0xD8, 0x0C, 0x40, 0x01,
  0xF8, 0x11, 0x01, 0xF0, 0x18, 0x0C, 0x30, 0x04, 0xE0, 0xD3, 0x0D, 0xE0, 0x58, 0x0C, 0x30, 0x08,
  0xE0, 0xA3, 0x08, 0xE0, 0x98, 0x0C, 0x30, 0x0D, 0xE0, 0x63, 0x04, 0xE0, 0xE8, 0x0C, 0x20, 0x02,
  0xF0, 0x14, 0x0E, 0xE0, 0x58, 0x0C, 0x10, 0x08, 0xE0, 0xC5, 0x09, 0xE0, 0xB8, 0x0C, 0x10, 0x0E,
  0xE0, 0x75, 0x03, 0xF0, 0x37, 0x77, 0x77, 0x06, 0xF0, 0x16, 0x0B, 0xE0, 0xA7, 0x77, 0x77, 0x0D,
  0xE0, 0x97, 0x04, 0xF0, 0x47, 0x77, 0x75, 0x08, 0xF0, 0x27, 0x10, 0xBE, 0x0D, 0x77, 0x77, 0x40,
  0x2F, 0x0A, 0x72, 0x03, 0xF0, 0x97, 0x77, 0x73, 0x0D, 0xF0, 0x17, 0x30, 0x8F, 0x06, 0x77, 0x77,
  0x10, 0xAF, 0x07, 0x75, 0x0D, 0xF0, 0x67, 0x77, 0x60, 0xAF, 0x0C, 0x76, 0x02, 0x0E, 0xF0, 0x87,
  0x77, 0x30, 0x10, 0xBF, 0x0E, 0x01, 0x77, 0x04, 0xF9, 0x0C, 0x03, 0x77, 0x70, 0x60, 0xEF, 0x90,
  0x37, 0x72, 0x06, 0xFA, 0x0A, 0x03, 0x77, 0x30, 0x60, 0xDF, 0xA0, 0x47, 0x74, 0x05, 0xFB, 0x82,
  0xD8, 0x41, 0x72, 0x82, 0x26, 0xAE, 0xFA, 0x0E, 0x04, 0x77, 0x60, 0x30, 0xEF, 0xD0, 0xE0, 0xC8,
  0x01, 0xB0, 0xDF, 0xE0, 0xD0, 0x37, 0x77, 0x10, 0x10, 0xBF, 0xFF, 0xFB, 0x0A, 0x01, 0x77, 0x74,
  0x06, 0x0E, 0xFF, 0xFE, 0x0D, 0x04, 0x77, 0x77, 0x10, 0x70, 0xEF, 0xFF, 0xA0, 0xD0, 0x67, 0x77,
  0x75, 0x05, 0x0B, 0xFF, 0xC8, 0x1E, 0xA4, 0x80, 0xC2, 0x08, 0x24, 0x8A, 0xDF, 0xA8, 0x2C, 0xA7,
  0x38, 0x0D, 0x20, 0x84, 0x11, 0x23, 0x11, 0x77, 0x75,
  // "õ" (U+00F5)
  0x80, 0xD0, 0x08, 0x01, 0x17, 0x77, 0x28, 0x21, 0x7B, 0xDA, 0x82, 0xEB, 0x72, 0x77, 0x60, 0xEB,
  0x0A, 0x77, 0x70, 0x10, 0x9F, 0xB0, 0xA0, 0x27, 0x73, 0x02, 0xC0, 0x87, 0x76, 0x03, 0x0D, 0xFE,
  0x08, 0x77, 0x20, 0x6C, 0x05, 0x77, 0x50, 0x30, 0xEF, 0xF9, 0x0D, 0x03, 0x77, 0x0B, 0xC0, 0x27,
  0x75, 0x0D, 0xFF, 0xC0, 0x77, 0x50, 0x3C, 0x0E, 0x77, 0x50, 0x9F, 0x82, 0xC9, 0xAC, 0xFA, 0x0C,
  0x02, 0x73, 0x0C, 0xC0, 0x97, 0x74, 0x01, 0xD0, 0xE0, 0x75, 0x81, 0x17, 0xEF, 0x90, 0x77, 0x01,
  0x0C, 0xD0, 0x37, 0x74, 0x08, 0xC0, 0xE0, 0x37, 0x10, 0x10, 0xAF, 0x98, 0x6D, 0x73, 0x11, 0x38,
  0xED, 0x0A, 0x77, 0x50, 0xDC, 0x06, 0x74, 0x05, 0x0E, 0xFF, 0xC0, 0xE0, 0x27, 0x74, 0x02, 0xC0,
  0xD7, 0x60, 0x20, 0xCF, 0xFB, 0x05, 0x77, 0x50, 0x5C, 0x07, 0x77, 0x10, 0x7F, 0xF9, 0x07, 0x77,
  0x60, 0x8C, 0x03, 0x77, 0x20, 0x20, 0xBF, 0xC0, 0xE0, 0x57, 0x77, 0x0A, 0xB0, 0xE7, 0x75, 0x04,
  0x0B, 0xF8, 0x1E, 0x81, 0x77, 0x71, 0x83, 0x57, 0x77, 0x67, 0x77, 0x85, 0x15, 0x77, 0x76, 0x38,
  0x0F, 0xE4, 0x08, 0x34, 0x7A, 0xCD, 0xD8, 0x4E, 0xDB, 0x86, 0x28, 0x0C, 0x20, 0x81, 0x17, 0xCF,
  0xFB, 0x81, 0xD9, 0x37, 0x77, 0x75, 0x03, 0x0B, 0xFF, 0xFA, 0x0D, 0x06, 0x77, 0x77, 0x10, 0x30,
  0xBF, 0xFF, 0xE0, 0xD0, 0x47, 0x77, 0x50, 0x8F, 0xFF, 0xFB, 0x0A, 0x01, 0x77, 0x71, 0x02, 0x0C,
  0xFF, 0xFF, 0xD0, 0xD0, 0x37, 0x76, 0x03, 0x0E, 0xFB, 0x83, 0xDA, 0x64, 0x25, 0x83, 0x13, 0x59,
  0xDF, 0xB0, 0xE0, 0x47, 0x74, 0x04, 0x0E, 0xF9, 0x81, 0xE9, 0x37, 0x71, 0x81, 0x28, 0xEF, 0xA0,
  0x47, 0x72, 0x03, 0x0E, 0xF9, 0x09, 0x01, 0x77, 0x50, 0x10, 0x8F, 0xA0, 0x37, 0x70, 0x10, 0xEF,
  0x0D, 0x03, 0x77, 0x72, 0x03, 0x0D, 0xF0, 0xE0, 0x17, 0x60, 0xCF, 0x0B, 0x77, 0x75, 0x01, 0x0B,
  0xF0, 0xC7, 0x50, 0x8F, 0x0B, 0x77, 0x77, 0x10, 0xBF, 0x07, 0x73, 0x02, 0xF0, 0xC7, 0x77, 0x72,
  0x01, 0x0D, 0xF0, 0x17, 0x20, 0xBE, 0x0E, 0x02, 0x77, 0x77, 0x30, 0x2F, 0x0A, 0x71, 0x04, 0xF0,
  0x67, 0x77, 0x75, 0x07, 0xF0, 0x27, 0x0B, 0xE0, 0xC7, 0x77, 0x77, 0x0D, 0xE0, 0x96, 0x03, 0xF0,
  0x47, 0x77, 0x77, 0x05, 0xF0, 0x15, 0x09, 0xE0, 0xC8, 0x0C, 0x10, 0x0D, 0xE0, 0x65, 0x0E, 0xE0,
  0x58, 0x0C, 0x10, 0x07, 0xE0, 0xC4, 0x04, 0xE0, 0xE8, 0x0C, 0x20, 0x02, 0xF0, 0x13, 0x08, 0xE0,
  0xA8, 0x0C, 0x30, 0x0D, 0xE0, 0x53, 0x0D, 0xE0, 0x58, 0x0C, 0x30, 0x08, 0xE0, 0xA2, 0x01, 0xF0,
  0x18, 0x0C, 0x30, 0x04, 0xE0, 0xD2, 0x04, 0xE0, 0xD8, 0x0C, 0x40, 0x01, 0xF8, 0x11, 0x07, 0xE0,
  0xA8, 0x0C, 0x50, 0x0D, 0xE8, 0x14, 0x09, 0xE0, 0x78, 0x0C, 0x50, 0x0A, 0xE8, 0x16, 0x0B, 0xE0,
  0x58, 0x0C, 0x50, 0x08, 0xE8, 0x18, 0x0D, 0xE0, 0x38, 0x0C, 0x50, 0x07, 0xE8, 0x1A, 0x0E, 0xE0,
  0x28, 0x0C, 0x50, 0x05, 0xE0, 0xB1, 0xF8, 0x0C, 0x60, 0x03, 0xE0, 0xC0, 0x1F, 0x80, 0xC6, 0x00,
  0x3E, 0x0D, 0x01, 0xE0, 0xE8, 0x0C, 0x60, 0x02, 0xE0, 0xE0, 0x2E, 0x0E, 0x80, 0xC6, 0x00, 0x2E,
  0x0E, 0x02, 0xE0, 0xE8, 0x0C, 0x60, 0x02, 0xE0, 0xE0, 0x1E, 0x0E, 0x80, 0xC6, 0x00, 0x2E, 0x0E,
  0x01, 0xF8, 0x0C, 0x60, 0x03, 0xE0, 0xD1, 0xF8, 0x0C, 0x60, 0x03, 0xE0, 0xD1, 0xF0, 0x18, 0x0C,
  0x50, 0x05, 0xE8, 0x1B, 0x0D, 0xE0, 0x38, 0x0C, 0x50, 0x06, 0xE8, 0x1A, 0x0B, 0xE0, 0x58, 0x0C,
  0x50, 0x08, 0xE8, 0x18, 0x09, 0xE0, 0x78, 0x0C, 0x50, 0x0A, 0xE8, 0x16, 0x07, 0xE0, 0x98, 0x0C,
  0x50, 0x0D, 0xE8, 0x14, 0x04, 0xE0, 0xD8, 0x0C, 0x40, 0x01, 0xF8, 0x11, 0x01, 0xF0, 0x18, 0x0C,
  0x30, 0x04, 0xE0, 0xD3, 0x0D, 0xE0, 0x58, 0x0C, 0x30, 0x08, 0xE0, 0xA3, 0x08, 0xE0, 0x98, 0x0C,
  0x30, 0x0D, 0xE0, 0x63, 0x04, 0xE0, 0xE8, 0x0C, 0x20, 0x02, 0xF0, 0x14, 0x0E, 0xE0, 0x58, 0x0C,
  0x10, 0x08, 0xE0, 0xC5, 0x09, 0xE0, 0xB8, 0x0C, 0x10, 0x0E, 0xE0, 0x75, 0x03, 0xF0, 0x37, 0x77,
  0x77, 0x06, 0xF0, 0x16, 0x0B, 0xE0, 0xA7, 0x77, 0x77, 0x0D, 0xE0, 0x97, 0x04, 0xF0, 0x47, 0x77,
  0x75, 0x08, 0xF0, 0x27, 0x10, 0xBE, 0x0D, 0x77, 0x77, 0x40, 0x2F, 0x0A, 0x72, 0x03, 0xF0, 0x97,
  0x77, 0x73, 0x0D, 0xF0, 0x17, 0x30, 0x8F, 0x06, 0x77, 0x77, 0x10, 0xAF, 0x07, 0x75, 0x0D, 0xF0,
  0x67, 0x77, 0x60, 0xAF, 0x0C, 0x76, 0x02, 0x0E, 0xF0, 0x87, 0x77, 0x30, 0x10, 0xBF, 0x0E, 0x01,
  0x77, 0x04, 0xF9, 0x0C, 0x03, 0x77, 0x70, 0x60, 0xEF, 0x90, 0x37, 0x72, 0x06, 0xFA, 0x0A, 0x03,
  0x77, 0x30, 0x60, 0xDF, 0xA0, 0x47, 0x74, 0x05, 0xFB, 0x82, 0xD8, 0x41, 0x72, 0x82, 0x26, 0xAE,
  0xFA, 0x0E, 0x04, 0x77, 0x60, 0x30, 0xEF, 0xD0, 0xE0, 0xC8, 0x01, 0xB0, 0xDF, 0xE0, 0xD0, 0x37,
  0x77, 0x10, 0x10, 0xBF, 0xFF, 0xFB, 0x0A, 0x01, 0x77, 0x74, 0x06, 0x0E, 0xFF, 0xFE, 0x0D, 0x04,
  0x77, 0x77, 0x10, 0x70, 0xEF, 0xFF, 0xA0, 0xD0, 0x67, 0x77, 0x75, 0x05, 0x0B, 0xFF, 0xC8, 0x1E,
  0xA4, 0x80, 0xC2, 0x08, 0x24, 0x8A, 0xDF, 0xA8, 0x2C, 0xA7, 0x38, 0x0D, 0x20, 0x84, 0x11, 0x23,
  0x11, 0x77, 0x75,
  // "ö" (U+00F6)
  0x77, 0x28, 0x22, 0x55, 0x37, 0x74, 0x82, 0x15, 0x54, 0x77, 0x77, 0x30, 0xAC, 0x0B, 0x01, 0x77,
  0x10, 0x6C, 0x0E, 0x04, 0x77, 0x77, 0x07, 0xE0, 0xA7, 0x70, 0x2E, 0x0E, 0x01, 0x77, 0x76, 0x0D,
  0xF0, 0x17, 0x60, 0x8F, 0x06, 0x77, 0x76, 0xF9, 0x03, 0x76, 0x0B, 0xF0, 0x97, 0x77, 0x50, 0x1F,
  0x90, 0x47, 0x60, 0xBF, 0x09, 0x77, 0x76, 0xF9, 0x03, 0x76, 0x0A, 0xF0, 0x87, 0x77, 0x60, 0xCF,
  0x77, 0x07, 0xF0, 0x57, 0x77, 0x60, 0x6E, 0x09, 0x77, 0x02, 0xE0, 0xD7, 0x77, 0x71, 0x08, 0xC0,
  0xA7, 0x72, 0x05, 0x0E, 0xB0, 0xD0, 0x27, 0x77, 0x72, 0x82, 0x13, 0x31, 0x77, 0x58, 0x13, 0x32,
  0x80, 0x9A, 0xC0, 0x08, 0x34, 0x7A, 0xCD, 0xD8, 0x4E, 0xDB, 0x86, 0x28, 0x0C, 0x20, 0x81, 0x17,
  0xCF, 0xFB, 0x81, 0xD9, 0x37, 0x77, 0x75, 0x03, 0x0B, 0xFF, 0xFA, 0x0D, 0x06, 0x77, 0x77, 0x10,
  0x30, 0xBF, 0xFF, 0xE0, 0xD0, 0x47, 0x77, 0x50, 0x8F, 0xFF, 0xFB, 0x0A, 0x01, 0x77, 0x71, 0x02,
  0x0C, 0xFF, 0xFF, 0xD0, 0xD0, 0x37, 0x76, 0x03, 0x0E, 0xFB, 0x83, 0xDA, 0x64, 0x25, 0x83, 0x13,
  0x59, 0xDF, 0xB0, 0xE0, 0x47, 0x74, 0x04, 0x0E, 0xF9, 0x81, 0xE9, 0x37, 0x71, 0x81, 0x28, 0xEF,
  0xA0, 0x47, 0x72, 0x03, 0x0E, 0xF9, 0x09, 0x01, 0x77, 0x50, 0x10, 0x8F, 0xA0, 0x37, 0x70, 0x10,
  0xEF, 0x0D, 0x03, 0x77, 0x72, 0x03, 0x0D, 0xF0, 0xE0, 0x17, 0x60, 0xCF, 0x0B, 0x77, 0x75, 0x01,
  0x0B, 0xF0, 0xC7, 0x50, 0x8F, 0x0B, 0x77, 0x77, 0x10, 0xBF, 0x07, 0x73, 0x02, 0xF0, 0xC7, 0x77,
  0x72, 0x01, 0x0D, 0xF0, 0x17, 0x20, 0xBE, 0x0E, 0x02, 0x77, 0x77, 0x30, 0x2F, 0x0A, 0x71, 0x04,
  0xF0, 0x67, 0x77, 0x75, 0x07, 0xF0, 0x27, 0x0B, 0xE0, 0xC7, 0x77, 0x77, 0x0D, 0xE0, 0x96, 0x03,
  0xF0, 0x47, 0x77, 0x77, 0x05, 0xF0, 0x15, 0x09, 0xE0, 0xC8, 0x0C, 0x10, 0x0D, 0xE0, 0x65, 0x0E,
  0xE0, 0x58, 0x0C, 0x10, 0x07, 0xE0, 0xC4, 0x04, 0xE0, 0xE8, 0x0C, 0x20, 0x02, 0xF0, 0x13, 0x08,
  0xE0, 0xA8, 0x0C, 0x30, 0x0D, 0xE0, 0x53, 0x0D, 0xE0, 0x58, 0x0C, 0x30, 0x08, 0xE0, 0xA2, 0x01,
  0xF0, 0x18, 0x0C, 0x30, 0x04, 0xE0, 0xD2, 0x04, 0xE0, 0xD8, 0x0C, 0x40, 0x01, 0xF8, 0x11, 0x07,
  0xE0, 0xA8, 0x0C, 0x50, 0x0D, 0xE8, 0x14, 0x09, 0xE0, 0x78, 0x0C, 0x50, 0x0A, 0xE8, 0x16, 0x0B,
  0xE0, 0x58, 0x0C, 0x50, 0x08, 0xE8, 0x18, 0x0D, 0xE0, 0x38, 0x0C, 0x50, 0x07, 0xE8, 0x1A, 0x0E,
  0xE0, 0x28, 0x0C, 0x50, 0x05, 0xE0, 0xB1, 0xF8, 0x0C, 0x60, 0x03, 0xE0, 0xC0, 0x1F, 0x80, 0xC6,
  0x00, 0x3E, 0x0D, 0x01, 0xE0, 0xE8, 0x0C, 0x60, 0x02, 0xE0, 0xE0, 0x2E, 0x0E, 0x80, 0xC6, 0x00,
  0x2E, 0x0E, 0x02, 0xE0, 0xE8, 0x0C, 0x60, 0x02, 0xE0, 0xE0, 0x1E, 0x0E, 0x80, 0xC6, 0x00, 0x2E,
  0x0E, 0x01, 0xF8, 0x0C, 0x60, 0x03, 0xE0, 0xD1, 0xF8, 0x0C, 0x60, 0x03, 0xE0, 0xD1, 0xF0, 0x18,
  0x0C, 0x50, 0x05, 0xE8, 0x1B, 0x0D, 0xE0, 0x38, 0x0C, 0x50, 0x06, 0xE8, 0x1A, 0x0B, 0xE0, 0x58,
  0x0C, 0x50, 0x08, 0xE8, 0x18, 0x09, 0xE0, 0x78, 0x0C, 0x50, 0x0A, 0xE8, 0x16, 0x07, 0xE0, 0x98,
  0x0C, 0x50, 0x0D, 0xE8, 0x14, 0x04, 0xE0, 0xD8, 0x0C, 0x40, 0x01, 0xF8, 0x11, 0x01, 0xF0, 0x18,
  0x0C, 0x30, 0x04, 0xE0, 0xD3, 0x0D, 0xE0, 0x58, 0x0C, 0x30, 0x08, 0xE0, 0xA3, 0x08, 0xE0, 0x98,
  0x0C, 0x30, 0x0D, 0xE0, 0x63, 0x04, 0xE0, 0xE8, 0x0C, 0x20, 0x02, 0xF0, 0x14, 0x0E, 0xE0, 0x58,
  0x0C, 0x10, 0x08, 0xE0, 0xC5, 0x09, 0xE0, 0xB8, 0x0C, 0x10, 0x0E, 0xE0, 0x75, 0x03, 0xF0, 0x37,
  0x77, 0x77, 0x06, 0xF0, 0x16, 0x0B, 0xE0, 0xA7, 0x77, 0x77, 0x0D, 0xE0, 0x97, 0x04, 0xF0, 0x47,
  0x77, 0x75, 0x08, 0xF0, 0x27, 0x10, 0xBE, 0x0D, 0x77, 0x77, 0x40, 0x2F, 0x0A, 0x72, 0x03, 0xF0,
  0x97, 0x77, 0x73, 0x0D, 0xF0, 0x17, 0x30, 0x8F, 0x06, 0x77, 0x77, 0x10, 0xAF, 0x07, 0x75, 0x0D,
  0xF0, 0x67, 0x77, 0x60, 0xAF, 0x0C, 0x76, 0x02, 0x0E, 0xF0, 0x87, 0x77, 0x30, 0x10, 0xBF, 0x0E,
  0x01, 0x77, 0x04, 0xF9, 0x0C, 0x03, 0x77, 0x70, 0x60, 0xEF, 0x90, 0x37, 0x72, 0x06, 0xFA, 0x0A,
  0x03, 0x77, 0x30, 0x60, 0xDF, 0xA0, 0x47, 0x74, 0x05, 0xFB, 0x82, 0xD8, 0x41, 0x72, 0x82, 0x26,
  0xAE, 0xFA, 0x0E, 0x04, 0x77, 0x60, 0x30, 0xEF, 0xD0, 0xE0, 0xC8, 0x01, 0xB0, 0xDF, 0xE0, 0xD0,
  0x37, 0x77, 0x10, 0x10, 0xBF, 0xFF, 0xFB, 0x0A, 0x01, 0x77, 0x74, 0x06, 0x0E, 0xFF, 0xFE, 0x0D,
  0x04, 0x77, 0x77, 0x10, 0x70, 0xEF, 0xFF, 0xA0, 0xD0, 0x67, 0x77, 0x75, 0x05, 0x0B, 0xFF, 0xC8,
  0x1E, 0xA4, 0x80, 0xC2, 0x08, 0x24, 0x8A, 0xDF, 0xA8, 0x2C, 0xA7, 0x38, 0x0D, 0x20, 0x84, 0x11,
  0x23, 0x11, 0x77, 0x75,
  // "÷" (U+00F7)
  0x77, 0x74, 0x84, 0x16, 0x99, 0x73, 0x80, 0xD6, 0x00, 0x40, 0xED, 0x09, 0x80, 0xD4, 0x00, 0x10,
  0xEF, 0x06, 0x80, 0xD3, 0x00, 0x6F, 0x90, 0xC8, 0x0D, 0x30, 0x09, 0xFA, 0x80, 0xD3, 0x00, 0xAF,
  0xA0, 0x18, 0x0D, 0x20, 0x0A, 0xFA, 0x01, 0x80, 0xD2, 0x00, 0x8F, 0x90, 0xE8, 0x0D, 0x30, 0x04,
  0xF9, 0x0A, 0x80, 0xD4, 0x00, 0xCF, 0x02, 0x80, 0xD4, 0x00, 0x10, 0xAC, 0x0C, 0x03, 0x80, 0xD7,
  0x08, 0x21, 0x33, 0x28, 0x09, 0xA9, 0x20, 0x80, 0xE4, 0x11, 0x0B, 0x80, 0xE3, 0xF0, 0x20, 0xB8,
  0x0E, 0x3F, 0x02, 0x0B, 0x80, 0xE3, 0xF0, 0x20, 0xB8, 0x0E, 0x3F, 0x02, 0x0B, 0x80, 0xE3, 0xF0,
  0x20, 0x58, 0x0E, 0x37, 0x01, 0x80, 0x9B, 0x81, 0x08, 0x44, 0xAD, 0xDA, 0x68, 0x0D, 0x60, 0x07,
  0xE0, 0xB8, 0x0D, 0x40, 0x02, 0xF9, 0x07, 0x80, 0xD3, 0x00, 0x7F, 0x90, 0xD8, 0x0D, 0x30, 0x09,
  0xFA, 0x80, 0xD3, 0x00, 0xAF, 0xA0, 0x18, 0x0D, 0x20, 0x0A, 0xFA, 0x01, 0x80, 0xD2, 0x00, 0x8F,
  0x90, 0xE8, 0x0D, 0x30, 0x03, 0xF9, 0x09, 0x80, 0xD4, 0x00, 0xAE, 0x0E, 0x01, 0x80, 0xD5, 0x00,
  0x80, 0xEB, 0x0A, 0x02, 0x80, 0xE0, 0x00, 0x01, 0x77, 0x77,
  // "ø" (U+00F8)
  0x80, 0xD7, 0x08, 0x13, 0xE6, 0x80, 0xE2, 0x00, 0x10, 0xDA, 0x0B, 0x02, 0x77, 0x73, 0x83, 0x47,
  0xAC, 0xDD, 0x84, 0xEC, 0xB8, 0x51, 0x75, 0x0A, 0xD0, 0x77, 0x75, 0x81, 0x17, 0xCF, 0xFB, 0x81,
  0xC7, 0x17, 0x10, 0x7E, 0x0A, 0x77, 0x30, 0x30, 0xBF, 0xFF, 0xA0, 0xA0, 0x35, 0x03, 0xE0, 0xD7,
  0x72, 0x03, 0x0B, 0xFF, 0xFE, 0x0A, 0x01, 0x20, 0x10, 0xDD, 0x0E, 0x02, 0x77, 0x10, 0x8F, 0xFF,
  0xFA, 0x82, 0xE5, 0x0A, 0xE0, 0x57, 0x70, 0x20, 0xCF, 0xFF, 0xFD, 0x0B, 0xE0, 0x97, 0x70, 0x30,
  0xEF, 0xB8, 0x3D, 0xA6, 0x42, 0x58, 0x31, 0x36, 0xAE, 0xFF, 0x90, 0xC7, 0x70, 0x40, 0xEF, 0x98,
  0x1E, 0x93, 0x77, 0x10, 0x40, 0xBF, 0xD0, 0xE0, 0x27, 0x60, 0x30, 0xEF, 0x90, 0x90, 0x17, 0x75,
  0x03, 0x0B, 0xFB, 0x04, 0x76, 0x01, 0x0E, 0xF0, 0xD0, 0x37, 0x77, 0x20, 0x60, 0xEF, 0x0E, 0x01,
  0x76, 0x0C, 0xF0, 0xB7, 0x77, 0x50, 0x6F, 0x90, 0xA7, 0x50, 0x8F, 0x0B, 0x77, 0x75, 0x01, 0x0D,
  0xFA, 0x06, 0x73, 0x02, 0xF0, 0xC7, 0x77, 0x60, 0xBF, 0xB0, 0xE0, 0x17, 0x20, 0xBE, 0x0E, 0x02,
  0x77, 0x75, 0x08, 0xFD, 0x09, 0x71, 0x04, 0xF0, 0x67, 0x77, 0x50, 0x4F, 0xF0, 0x17, 0x0B, 0xE0,
  0xC7, 0x77, 0x50, 0x10, 0xEE, 0x03, 0x0D, 0xE0, 0x86, 0x03, 0xF0, 0x47, 0x77, 0x50, 0xCE, 0x81,
  0x60, 0x6E, 0x0E, 0x01, 0x50, 0x9E, 0x0C, 0x77, 0x75, 0x09, 0xE0, 0xA3, 0x0E, 0xE0, 0x65, 0x0E,
  0xE0, 0x57, 0x77, 0x40, 0x5E, 0x0D, 0x40, 0x7E, 0x0B, 0x40, 0x4E, 0x0E, 0x77, 0x74, 0x02, 0x0E,
  0xD0, 0xE0, 0x24, 0x02, 0xF0, 0x13, 0x08, 0xE0, 0xA7, 0x77, 0x40, 0xDE, 0x05, 0x60, 0xCE, 0x05,
  0x30, 0xDE, 0x05, 0x77, 0x73, 0x0A, 0xE0, 0x97, 0x08, 0xE0, 0x92, 0x01, 0xF0, 0x17, 0x77, 0x20,
  0x6E, 0x0C, 0x71, 0x04, 0xE0, 0xD2, 0x04, 0xE0, 0xD7, 0x77, 0x20, 0x3E, 0x0E, 0x01, 0x72, 0xF8,
  0x11, 0x07, 0xE0, 0xA7, 0x77, 0x10, 0x10, 0xDE, 0x04, 0x73, 0x0D, 0xE8, 0x13, 0x09, 0xE0, 0x77,
  0x77, 0x10, 0xAE, 0x08, 0x74, 0x0A, 0xE8, 0x16, 0x0B, 0xE0, 0x57, 0x77, 0x07, 0xE0, 0xB7, 0x50,
  0x8E, 0x81, 0x80, 0xDE, 0x03, 0x77, 0x60, 0x4E, 0x0D, 0x01, 0x75, 0x06, 0xE8, 0x1A, 0x0E, 0xE0,
  0x27, 0x75, 0x01, 0x0E, 0xE0, 0x37, 0x60, 0x5E, 0x0B, 0x1F, 0x77, 0x60, 0xBE, 0x07, 0x77, 0x03,
  0xE0, 0xC0, 0x1F, 0x77, 0x50, 0x8E, 0x0A, 0x77, 0x10, 0x2E, 0x0D, 0x01, 0xE0, 0xE7, 0x74, 0x04,
  0xE0, 0xD7, 0x72, 0x02, 0xE0, 0xD0, 0x2E, 0x0E, 0x77, 0x30, 0x20, 0xED, 0x0E, 0x02, 0x77, 0x20,
  0x2E, 0x0E, 0x02, 0xE0, 0xE7, 0x73, 0x0C, 0xE0, 0x57, 0x73, 0x02, 0xE0, 0xE0, 0x1E, 0x0E, 0x77,
  0x20, 0x9E, 0x09, 0x77, 0x40, 0x2E, 0x0E, 0x01, 0xF7, 0x71, 0x05, 0xE0, 0xC7, 0x75, 0x03, 0xE0,
  0xD1, 0xF7, 0x70, 0x20, 0xED, 0x0E, 0x02, 0x77, 0x50, 0x3E, 0x81, 0xD0, 0xEE, 0x01, 0x76, 0x0D,
  0xE0, 0x57, 0x76, 0x05, 0xE8, 0x1B, 0x0D, 0xE0, 0x37, 0x50, 0xAE, 0x08, 0x77, 0x70, 0x6E, 0x81,
  0xA0, 0xBE, 0x05, 0x74, 0x06, 0xE0, 0xB7, 0x77, 0x10, 0x8E, 0x81, 0x80, 0x9E, 0x06, 0x73, 0x03,
  0xE0, 0xE0, 0x17, 0x77, 0x10, 0xAE, 0x81, 0x60, 0x6E, 0x09, 0x72, 0x01, 0x0D, 0xE0, 0x47, 0x77,
  0x20, 0xDE, 0x81, 0x40, 0x3E, 0x0C, 0x72, 0x0B, 0xE0, 0x77, 0x77, 0x20, 0x1F, 0x01, 0x2F, 0x71,
  0x07, 0xE0, 0xB7, 0x77, 0x30, 0x4E, 0x0D, 0x30, 0xBE, 0x04, 0x60, 0x4E, 0x0D, 0x01, 0x77, 0x73,
  0x08, 0xE0, 0xA3, 0x07, 0xE0, 0x85, 0x01, 0x0E, 0xE0, 0x37, 0x77, 0x40, 0xDE, 0x06, 0x30, 0x2E,
  0x0D, 0x50, 0xCE, 0x06, 0x77, 0x74, 0x02, 0xF0, 0x14, 0x0C, 0xE0, 0x33, 0x08, 0xE0, 0xA7, 0x77,
  0x50, 0x8E, 0x0C, 0x50, 0x7E, 0x0A, 0x20, 0x5E, 0x0D, 0x77, 0x76, 0x0E, 0xE0, 0x75, 0x01, 0x0E,
  0xE8, 0x12, 0x2E, 0xD0, 0xE0, 0x27, 0x77, 0x50, 0x6F, 0x01, 0x60, 0x9E, 0x0B, 0x0C, 0xE0, 0x57,
  0x77, 0x60, 0xDE, 0x09, 0x70, 0x2F, 0xE0, 0x97, 0x77, 0x60, 0x8F, 0x02, 0x71, 0x09, 0xFC, 0x0C,
  0x77, 0x76, 0x02, 0xF0, 0xA7, 0x20, 0x10, 0xEF, 0xA0, 0xE0, 0x17, 0x77, 0x60, 0xDF, 0x01, 0x73,
  0x06, 0xFA, 0x04, 0x77, 0x76, 0x0A, 0xF0, 0x77, 0x50, 0xBF, 0x0C, 0x77, 0x76, 0x0A, 0xF0, 0xC7,
  0x60, 0x4F, 0x90, 0xC0, 0x17, 0x77, 0x20, 0x10, 0xBF, 0x0E, 0x01, 0x76, 0x0C, 0xFA, 0x0E, 0x06,
  0x77, 0x70, 0x60, 0xEF, 0x90, 0x37, 0x60, 0xAF, 0xD0, 0xD0, 0x57, 0x73, 0x06, 0x0D, 0xFA, 0x04,
  0x76, 0x07, 0xFF, 0x98, 0x2E, 0x95, 0x27, 0x28, 0x22, 0x6A, 0xEF, 0xA0, 0xE0, 0x47, 0x60, 0x4E,
  0x0C, 0x0A, 0xFD, 0x0E, 0x0D, 0x80, 0x1B, 0x0D, 0xFE, 0x0D, 0x03, 0x76, 0x02, 0x0E, 0xD8, 0x3E,
  0x20, 0x6E, 0xFF, 0xFF, 0xA0, 0xA0, 0x17, 0x70, 0xCE, 0x05, 0x30, 0x20, 0xBF, 0xFF, 0xE0, 0xD0,
  0x47, 0x71, 0x0A, 0xE0, 0x86, 0x03, 0x0B, 0xFF, 0xFA, 0x0D, 0x06, 0x77, 0x20, 0x7E, 0x0B, 0x72,
  0x81, 0x29, 0xEF, 0xFB, 0x81, 0xEA, 0x47, 0x74, 0x09, 0xD0, 0xE0, 0x17, 0x58, 0x23, 0x7A, 0xDF,
  0xA8, 0x2C, 0xA7, 0x37, 0x77, 0x10, 0x50, 0xEB, 0x04, 0x77, 0x48, 0x41, 0x12, 0x31, 0x17, 0x77,
  0x71, 0x82, 0x1B, 0xF7, 0x80, 0xE4, 0x00, 0x58, 0x0E, 0x00,
  // "ù" (U+00F9)
  0x74, 0x06, 0x80, 0x3D, 0x0B, 0x80, 0xC7, 0x00, 0x2F, 0x90, 0x68, 0x0C, 0x70, 0x06, 0xF0, 0xE0,
  0x28, 0x0C, 0x70, 0x0A, 0xF0, 0xB8, 0x0D, 0x00, 0x0C, 0xF0, 0x78, 0x0C, 0x70, 0x01, 0x0E, 0xF0,
  0x28, 0x0C, 0x70, 0x03, 0x0E, 0xE0, 0xD8, 0x0D, 0x00, 0x04, 0xF0, 0xA8, 0x0D, 0x00, 0x05, 0xF0,
  0x68, 0x0D, 0x00, 0x06, 0xF0, 0x38, 0x0D, 0x00, 0x07, 0xE0, 0xD0, 0x18, 0x0D, 0x00, 0x07, 0xE0,
  0xB8, 0x0D, 0x10, 0x07, 0xE0, 0x98, 0x0D, 0x10, 0x07, 0xE0, 0x68, 0x0D, 0x10, 0x07, 0xE0, 0x48,
  0x0D, 0x10, 0x06, 0xD0, 0xE0, 0x38, 0x0D, 0x10, 0x05, 0xD0, 0xE0, 0x28, 0x0D, 0x10, 0x03, 0x0E,
  0xC0, 0xD0, 0x28, 0x0D, 0x10, 0x02, 0x0D, 0xC0, 0xA8, 0x0D, 0x20, 0x84, 0x13, 0x33, 0x32, 0x80,
  0xED, 0x60, 0x05, 0x80, 0x2D, 0x07, 0x80, 0xC1, 0x08, 0x02, 0xD0, 0xB0, 0x6E, 0x08, 0x80, 0xC1,
  0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06,
  0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C,
  0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0,
  0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80,
  0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D,
  0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88,
  0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0,
  0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08,
  0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E,
  0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0,
  0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10,
  0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E,
  0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1,
  0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06,
  0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC0, 0x00, 0x1E, 0x0D, 0x06, 0xE0, 0x88,
  0x0C, 0x00, 0x02, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC0, 0x00, 0x3E, 0x0D, 0x06, 0xE0, 0x88, 0x0C,
  0x00, 0x04, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC0, 0x00, 0x7E, 0x0D, 0x06, 0xE0, 0x98, 0x0C, 0x00,
  0x09, 0xE0, 0xD0, 0x5E, 0x09, 0x80, 0xC0, 0x00, 0xCE, 0x0D, 0x05, 0xE0, 0xA8, 0x0C, 0x00, 0xF0,
  0xD0, 0x3E, 0x0C, 0x77, 0x77, 0x70, 0x4F, 0x0D, 0x02, 0xE0, 0xE7, 0x77, 0x77, 0x09, 0xF0, 0xD1,
  0xF0, 0x17, 0x77, 0x76, 0x0E, 0xF8, 0x1D, 0x0D, 0xE0, 0x57, 0x77, 0x75, 0x05, 0xF9, 0x81, 0xD0,
  0xAE, 0x09, 0x77, 0x77, 0x50, 0xCF, 0x98, 0x1D, 0x06, 0xE0, 0xE7, 0x77, 0x74, 0x06, 0xFA, 0x81,
  0xD0, 0x2F, 0x06, 0x77, 0x77, 0x20, 0x10, 0xEF, 0xA0, 0xD2, 0x0D, 0xE0, 0xD7, 0x77, 0x72, 0x0B,
  0xFB, 0x0D, 0x20, 0x7F, 0x08, 0x77, 0x77, 0x08, 0xC0, 0xA0, 0xBD, 0x0D, 0x20, 0x10, 0xEF, 0x04,
  0x77, 0x75, 0x08, 0xC8, 0x1E, 0x19, 0xD0, 0xD3, 0x08, 0xF0, 0xE0, 0x47, 0x77, 0x30, 0xAD, 0x81,
  0x60, 0x8D, 0x0D, 0x30, 0x10, 0xDF, 0x90, 0x77, 0x77, 0x05, 0x0E, 0xD0, 0xA2, 0x07, 0xD0, 0xD4,
  0x04, 0xFA, 0x0C, 0x04, 0x77, 0x30, 0x50, 0xCE, 0x0B, 0x30, 0x5D, 0x0D, 0x50, 0x8F, 0xB8, 0x2D,
  0x84, 0x17, 0x28, 0x23, 0x6A, 0xEF, 0x0C, 0x40, 0x4D, 0x0D, 0x60, 0x9F, 0xE8, 0x6E, 0xCB, 0xBB,
  0xBC, 0xEF, 0xC0, 0xA5, 0x03, 0xD0, 0xD7, 0x08, 0xFF, 0xFF, 0xA0, 0x76, 0x01, 0xD0, 0xD7, 0x10,
  0x40, 0xEF, 0xFF, 0xD0, 0xD0, 0x37, 0x1D, 0x0D, 0x73, 0x08, 0x0E, 0xFF, 0xF9, 0x0E, 0x06, 0x73,
  0x0E, 0xC0, 0xD7, 0x48, 0x11, 0x6C, 0xFF, 0xC0, 0xB0, 0x57, 0x50, 0xDC, 0x0D, 0x77, 0x83, 0x15,
  0x8B, 0xDF, 0x98, 0x3E, 0xC8, 0x51, 0x80, 0xC4, 0x08, 0x41, 0x12, 0x31, 0x17, 0x77, 0x50,
  // "ú" (U+00FA)
  0x77, 0x77, 0x70, 0x88, 0x03, 0xD0, 0xA8, 0x0C, 0x60, 0x03, 0xF9, 0x07, 0x80, 0xC6, 0x00, 0xDF,
  0x0A, 0x80, 0xC6, 0x00, 0x8F, 0x0D, 0x01, 0x80, 0xC5, 0x00, 0x4F, 0x0E, 0x02, 0x80, 0xC5, 0x00,
  0x10, 0xDF, 0x04, 0x80, 0xC6, 0x00, 0xAF, 0x06, 0x80, 0xC6, 0x00, 0x7F, 0x08, 0x80, 0xC6, 0x00,
  0x3F, 0x09, 0x80, 0xC6, 0x00, 0x10, 0xDE, 0x0A, 0x80, 0xC7, 0x00, 0xBE, 0x0B, 0x80, 0xC7, 0x00,
  0x9E, 0x0B, 0x80, 0xC7, 0x00, 0x6E, 0x0B, 0x80, 0xC7, 0x00, 0x3E, 0x0B, 0x80, 0xC7, 0x00, 0x20,
  0xED, 0x0B, 0x80, 0xC7, 0x00, 0x10, 0xDD, 0x0A, 0x80, 0xD0, 0x00, 0xCD, 0x09, 0x80, 0xD0, 0x00,
  0xBD, 0x07, 0x80, 0xD0, 0x00, 0x6D, 0x05, 0x80, 0xD1, 0x08, 0x41, 0x33, 0x33, 0x28, 0x0E, 0xE5,
  0x00, 0x58, 0x02, 0xD0, 0x78, 0x0C, 0x10, 0x80, 0x2D, 0x0B, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0,
  0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08,
  0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E,
  0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0,
  0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10,
  0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E,
  0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1,
  0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06,
  0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C,
  0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0,
  0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80,
  0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D,
  0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88,
  0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0,
  0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08,
  0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x00, 0x01, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC0,
  0x00, 0x2E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x00, 0x03, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC0, 0x00,
  0x4E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x00, 0x07, 0xE0, 0xD0, 0x6E, 0x09, 0x80, 0xC0, 0x00, 0x9E,
  0x0D, 0x05, 0xE0, 0x98, 0x0C, 0x00, 0x0C, 0xE0, 0xD0, 0x5E, 0x0A, 0x80, 0xC0, 0x0F, 0x0D, 0x03,
  0xE0, 0xC7, 0x77, 0x77, 0x04, 0xF0, 0xD0, 0x2E, 0x0E, 0x77, 0x77, 0x70, 0x9F, 0x0D, 0x1F, 0x01,
  0x77, 0x77, 0x60, 0xEF, 0x81, 0xD0, 0xDE, 0x05, 0x77, 0x77, 0x50, 0x5F, 0x98, 0x1D, 0x0A, 0xE0,
  0x97, 0x77, 0x75, 0x0C, 0xF9, 0x81, 0xD0, 0x6E, 0x0E, 0x77, 0x77, 0x40, 0x6F, 0xA8, 0x1D, 0x02,
  0xF0, 0x67, 0x77, 0x72, 0x01, 0x0E, 0xFA, 0x0D, 0x20, 0xDE, 0x0D, 0x77, 0x77, 0x20, 0xBF, 0xB0,
  0xD2, 0x07, 0xF0, 0x87, 0x77, 0x70, 0x8C, 0x0A, 0x0B, 0xD0, 0xD2, 0x01, 0x0E, 0xF0, 0x47, 0x77,
  0x50, 0x8C, 0x81, 0xE1, 0x9D, 0x0D, 0x30, 0x8F, 0x0E, 0x04, 0x77, 0x73, 0x0A, 0xD8, 0x16, 0x08,
  0xD0, 0xD3, 0x01, 0x0D, 0xF9, 0x07, 0x77, 0x70, 0x50, 0xED, 0x0A, 0x20, 0x7D, 0x0D, 0x40, 0x4F,
  0xA0, 0xC0, 0x47, 0x73, 0x05, 0x0C, 0xE0, 0xB3, 0x05, 0xD0, 0xD5, 0x08, 0xFB, 0x82, 0xD8, 0x41,
  0x72, 0x82, 0x36, 0xAE, 0xF0, 0xC4, 0x04, 0xD0, 0xD6, 0x09, 0xFE, 0x86, 0xEC, 0xBB, 0xBB, 0xCE,
  0xFC, 0x0A, 0x50, 0x3D, 0x0D, 0x70, 0x8F, 0xFF, 0xFA, 0x07, 0x60, 0x1D, 0x0D, 0x71, 0x04, 0x0E,
  0xFF, 0xFD, 0x0D, 0x03, 0x71, 0xD0, 0xD7, 0x30, 0x80, 0xEF, 0xFF, 0x90, 0xE0, 0x67, 0x30, 0xEC,
  0x0D, 0x74, 0x81, 0x16, 0xCF, 0xFC, 0x0B, 0x05, 0x75, 0x0D, 0xC0, 0xD7, 0x78, 0x31, 0x58, 0xBD,
  0xF9, 0x83, 0xEC, 0x85, 0x18, 0x0C, 0x40, 0x84, 0x11, 0x23, 0x11, 0x77, 0x75,
  // "û" (U+00FB)
  0x77, 0x72, 0x09, 0x80, 0x2B, 0x02, 0x80, 0xC7, 0x00, 0x5F, 0x0B, 0x80, 0xC6, 0x00, 0x10, 0xEF,
  0x90, 0x58, 0x0C, 0x50, 0x0B, 0xFA, 0x0E, 0x01, 0x80, 0xC3, 0x00, 0x7F, 0xC0, 0xB8, 0x0C, 0x20,
  0x03, 0xFE, 0x08, 0x80, 0xC0, 0x00, 0x10, 0xDE, 0x09, 0x0E, 0xE0, 0x47, 0x77, 0x77, 0x0B, 0xE8,
  0x19, 0x05, 0xE0, 0xE0, 0x27, 0x77, 0x75, 0x08, 0xE0, 0xA3, 0x06, 0xE0, 0xD0, 0x17, 0x77, 0x73,
  0x05, 0xE0, 0xC5, 0x08, 0xE0, 0xB7, 0x77, 0x72, 0x03, 0x0E, 0xD0, 0xC0, 0x16, 0x09, 0xE0, 0x87,
  0x77, 0x70, 0x10, 0xED, 0x0D, 0x01, 0x71, 0x0A, 0xE0, 0x67, 0x77, 0x60, 0xCD, 0x0D, 0x02, 0x73,
  0x0B, 0xE0, 0x37, 0x77, 0x40, 0xBD, 0x0E, 0x02, 0x75, 0x0B, 0xD0, 0xE0, 0x27, 0x77, 0x20, 0x9D,
  0x0D, 0x02, 0x77, 0x0B, 0xD0, 0xD0, 0x17, 0x77, 0x07, 0xD0, 0xD0, 0x27, 0x72, 0x0B, 0xD0, 0xC7,
  0x76, 0x05, 0xD0, 0xD0, 0x27, 0x74, 0x0A, 0xD0, 0xA7, 0x74, 0x04, 0xD0, 0xB0, 0x17, 0x76, 0x08,
  0xD0, 0x97, 0x73, 0x0E, 0xC0, 0xA7, 0x77, 0x20, 0x6D, 0x05, 0x77, 0x28, 0x01, 0x37, 0x77, 0x48,
  0x42, 0x33, 0x33, 0x18, 0x0E, 0xC3, 0x00, 0x58, 0x02, 0xD0, 0x78, 0x0C, 0x10, 0x80, 0x2D, 0x0B,
  0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88,
  0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0,
  0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08,
  0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E,
  0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0,
  0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10,
  0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E,
  0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1,
  0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06,
  0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C,
  0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0,
  0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80,
  0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D,
  0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88,
  0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x00, 0x01,
  0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC0, 0x00, 0x2E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x00, 0x03, 0xE0,
  0xD0, 0x6E, 0x08, 0x80, 0xC0, 0x00, 0x4E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x00, 0x07, 0xE0, 0xD0,
  0x6E, 0x09, 0x80, 0xC0, 0x00, 0x9E, 0x0D, 0x05, 0xE0, 0x98, 0x0C, 0x00, 0x0C, 0xE0, 0xD0, 0x5E,
  0x0A, 0x80, 0xC0, 0x0F, 0x0D, 0x03, 0xE0, 0xC7, 0x77, 0x77, 0x04, 0xF0, 0xD0, 0x2E, 0x0E, 0x77,
  0x77, 0x70, 0x9F, 0x0D, 0x1F, 0x01, 0x77, 0x77, 0x60, 0xEF, 0x81, 0xD0, 0xDE, 0x05, 0x77, 0x77,
  0x50, 0x5F, 0x98, 0x1D, 0x0A, 0xE0, 0x97, 0x77, 0x75, 0x0C, 0xF9, 0x81, 0xD0, 0x6E, 0x0E, 0x77,
  0x77, 0x40, 0x6F, 0xA8, 0x1D, 0x02, 0xF0, 0x67, 0x77, 0x72, 0x01, 0x0E, 0xFA, 0x0D, 0x20, 0xDE,
  0x0D, 0x77, 0x77, 0x20, 0xBF, 0xB0, 0xD2, 0x07, 0xF0, 0x87, 0x77, 0x70, 0x8C, 0x0A, 0x0B, 0xD0,
  0xD2, 0x01, 0x0E, 0xF0, 0x47, 0x77, 0x50, 0x8C, 0x81, 0xE1, 0x9D, 0x0D, 0x30, 0x8F, 0x0E, 0x04,
  0x77, 0x73, 0x0A, 0xD8, 0x16, 0x08, 0xD0, 0xD3, 0x01, 0x0D, 0xF9, 0x07, 0x77, 0x70, 0x50, 0xED,
  0x0A, 0x20, 0x7D, 0x0D, 0x40, 0x4F, 0xA0, 0xC0, 0x47, 0x73, 0x05, 0x0C, 0xE0, 0xB3, 0x05, 0xD0,
  0xD5, 0x08, 0xFB, 0x82, 0xD8, 0x41, 0x72, 0x82, 0x36, 0xAE, 0xF0, 0xC4, 0x04, 0xD0, 0xD6, 0x09,
  0xFE, 0x86, 0xEC, 0xBB, 0xBB, 0xCE, 0xFC, 0x0A, 0x50, 0x3D, 0x0D, 0x70, 0x8F, 0xFF, 0xFA, 0x07,
  0x60, 0x1D, 0x0D, 0x71, 0x04, 0x0E, 0xFF, 0xFD, 0x0D, 0x03, 0x71, 0xD0, 0xD7, 0x30, 0x80, 0xEF,
  0xFF, 0x90, 0xE0, 0x67, 0x30, 0xEC, 0x0D, 0x74, 0x81, 0x16, 0xCF, 0xFC, 0x0B, 0x05, 0x75, 0x0D,
  0xC0, 0xD7, 0x78, 0x31, 0x58, 0xBD, 0xF9, 0x83, 0xEC, 0x85, 0x18, 0x0C, 0x40, 0x84, 0x11, 0x23,
  0x11, 0x77, 0x75,
  // "ü" (U+00FC)
  0x77, 0x82, 0x45, 0x51, 0x77, 0x48, 0x23, 0x55, 0x27, 0x77, 0x30, 0x40, 0xEB, 0x0E, 0x05, 0x77,
  0x10, 0x10, 0xCC, 0x09, 0x77, 0x71, 0x01, 0x0E, 0xE0, 0x27, 0x70, 0xAE, 0x07, 0x77, 0x70, 0x5F,
  0x08, 0x76, 0x01, 0xF0, 0xD7, 0x77, 0x08, 0xF0, 0xB7, 0x60, 0x3F, 0x90, 0x17, 0x76, 0x09, 0xF0,
  0xC7, 0x60, 0x4F, 0x90, 0x17, 0x76, 0x08, 0xF0, 0xB7, 0x60, 0x3F, 0x97, 0x77, 0x05, 0xF0, 0x87,
  0x7F, 0x0D, 0x77, 0x71, 0x0D, 0xD0, 0xE0, 0x27, 0x70, 0x9E, 0x06, 0x77, 0x71, 0x03, 0x0D, 0xB0,
  0xD0, 0x47, 0x72, 0x0A, 0xC0, 0x87, 0x77, 0x40, 0xF3, 0x77, 0x58, 0x12, 0x33, 0x80, 0x99, 0xF1,
  0x00, 0x58, 0x02, 0xD0, 0x78, 0x0C, 0x10, 0x80, 0x2D, 0x0B, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0,
  0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08,
  0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E,
  0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0,
  0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10,
  0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E,
  0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1,
  0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06,
  0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C,
  0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0,
  0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80,
  0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D,
  0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88,
  0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0,
  0xD0, 0x6E, 0x08, 0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x10, 0xE0, 0xD0, 0x6E, 0x08,
  0x80, 0xC1, 0x0E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x00, 0x01, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC0,
  0x00, 0x2E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x00, 0x03, 0xE0, 0xD0, 0x6E, 0x08, 0x80, 0xC0, 0x00,
  0x4E, 0x0D, 0x06, 0xE0, 0x88, 0x0C, 0x00, 0x07, 0xE0, 0xD0, 0x6E, 0x09, 0x80, 0xC0, 0x00, 0x9E,
  0x0D, 0x05, 0xE0, 0x98, 0x0C, 0x00, 0x0C, 0xE0, 0xD0, 0x5E, 0x0A, 0x80, 0xC0, 0x0F, 0x0D, 0x03,
  0xE0, 0xC7, 0x77, 0x77, 0x04, 0xF0, 0xD0, 0x2E, 0x0E, 0x77, 0x77, 0x70, 0x9F, 0x0D, 0x1F, 0x01,
  0x77, 0x77, 0x60, 0xEF, 0x81, 0xD0, 0xDE, 0x05, 0x77, 0x77, 0x50, 0x5F, 0x98, 0x1D, 0x0A, 0xE0,
  0x97, 0x77, 0x75, 0x0C, 0xF9, 0x81, 0xD0, 0x6E, 0x0E, 0x77, 0x77, 0x40, 0x6F, 0xA8, 0x1D, 0x02,
  0xF0, 0x67, 0x77, 0x72, 0x01, 0x0E, 0xFA, 0x0D, 0x20, 0xDE, 0x0D, 0x77, 0x77, 0x20, 0xBF, 0xB0,
  0xD2, 0x07, 0xF0, 0x87, 0x77, 0x70, 0x8C, 0x0A, 0x0B, 0xD0, 0xD2, 0x01, 0x0E, 0xF0, 0x47, 0x77,
  0x50, 0x8C, 0x81, 0xE1, 0x9D, 0x0D, 0x30, 0x8F, 0x0E, 0x04, 0x77, 0x73, 0x0A, 0xD8, 0x16, 0x08,
  0xD0, 0xD3, 0x01, 0x0D, 0xF9, 0x07, 0x77, 0x70, 0x50, 0xED, 0x0A, 0x20, 0x7D, 0x0D, 0x40, 0x4F,
  0xA0, 0xC0, 0x47, 0x73, 0x05, 0x0C, 0xE0, 0xB3, 0x05, 0xD0, 0xD5, 0x08, 0xFB, 0x82, 0xD8, 0x41,
  0x72, 0x82, 0x36, 0xAE, 0xF0, 0xC4, 0x04, 0xD0, 0xD6, 0x09, 0xFE, 0x86, 0xEC, 0xBB, 0xBB, 0xCE,
  0xFC, 0x0A, 0x50, 0x3D, 0x0D, 0x70, 0x8F, 0xFF, 0xFA, 0x07, 0x60, 0x1D, 0x0D, 0x71, 0x04, 0x0E,
  0xFF, 0xFD, 0x0D, 0x03, 0x71, 0xD0, 0xD7, 0x30, 0x80, 0xEF, 0xFF, 0x90, 0xE0, 0x67, 0x30, 0xEC,
  0x0D, 0x74, 0x81, 0x16, 0xCF, 0xFC, 0x0B, 0x05, 0x75, 0x0D, 0xC0, 0xD7, 0x78, 0x31, 0x58, 0xBD,
  0xF9, 0x83, 0xEC, 0x85, 0x18, 0x0C, 0x40, 0x84, 0x11, 0x23, 0x11, 0x77, 0x75,
  // "ý" (U+00FD)
  0x80, 0xC0, 0x00, 0x48, 0x04, 0xD0, 0x18, 0x0D, 0x30, 0x0D, 0xF0, 0xB8, 0x0D, 0x30, 0x08, 0xF0,
  0xE0, 0x18, 0x0D, 0x20, 0x03, 0xF9, 0x04, 0x80, 0xD3, 0x00, 0xDF, 0x06, 0x80, 0xD3, 0x00, 0xAF,
  0x09, 0x80, 0xD3, 0x00, 0x5F, 0x0B, 0x80, 0xD3, 0x00, 0x20, 0xEE, 0x0C, 0x80, 0xD4, 0x00, 0xDE,
  0x0D, 0x01, 0x80, 0xD3, 0x00, 0xAE, 0x0D, 0x01, 0x80, 0xD3, 0x00, 0x7E, 0x0E, 0x02, 0x80, 0xD3,
  0x00, 0x4E, 0x0E, 0x02, 0x80, 0xD3, 0x00, 0x20, 0xED, 0x0E, 0x03, 0x80, 0xD3, 0x00, 0x10, 0xDD,
  0x0E, 0x03, 0x80, 0xD4, 0x00, 0xBD, 0x0E, 0x03, 0x80, 0xD4, 0x00, 0x9D, 0x0D, 0x02, 0x80, 0xD4,
  0x00, 0x7D, 0x0D, 0x01, 0x80, 0xD4, 0x00, 0x6D, 0x0B, 0x01, 0x80, 0xD4, 0x00, 0x1D, 0x09, 0x80,
  0xD7, 0x08, 0x01, 0x38, 0x0F, 0xC1, 0x00, 0xB8, 0x02, 0xD0, 0x68, 0x0C, 0x40, 0x01, 0x80, 0x3D,
  0x03, 0x07, 0xE0, 0xC8, 0x0C, 0x40, 0x06, 0xE8, 0x1D, 0x01, 0xF0, 0x38, 0x0C, 0x30, 0x0C, 0xE0,
  0x72, 0x0A, 0xE0, 0x98, 0x0C, 0x20, 0x02, 0xF0, 0x22, 0x04, 0xE0, 0xE8, 0x0C, 0x20, 0x08, 0xE0,
  0xB4, 0x0D, 0xE0, 0x58, 0x0C, 0x10, 0x0D, 0xE0, 0x54, 0x07, 0xE0, 0xB8, 0x0C, 0x00, 0x04, 0xE0,
  0xE5, 0x01, 0xF0, 0x27, 0x77, 0x77, 0x0A, 0xE0, 0x96, 0x0B, 0xE0, 0x77, 0x77, 0x76, 0x01, 0xF0,
  0x36, 0x04, 0xE0, 0xD7, 0x77, 0x76, 0x06, 0xE0, 0xC7, 0x10, 0xDE, 0x04, 0x77, 0x77, 0x50, 0xCE,
  0x06, 0x71, 0x08, 0xE0, 0xA7, 0x77, 0x74, 0x02, 0xF0, 0x17, 0x10, 0x2F, 0x01, 0x77, 0x77, 0x30,
  0x8E, 0x0A, 0x73, 0x0B, 0xE0, 0x67, 0x77, 0x73, 0x0D, 0xE0, 0x47, 0x30, 0x5E, 0x0C, 0x77, 0x77,
  0x20, 0x4E, 0x0D, 0x75, 0x0E, 0xE0, 0x37, 0x77, 0x71, 0x0A, 0xE0, 0x87, 0x50, 0x8E, 0x09, 0x77,
  0x77, 0x10, 0xEE, 0x02, 0x75, 0x02, 0xE0, 0xE7, 0x77, 0x70, 0x6E, 0x0B, 0x77, 0x0B, 0xE0, 0x57,
  0x77, 0x60, 0xBE, 0x05, 0x77, 0x05, 0xE0, 0xB7, 0x77, 0x50, 0x2E, 0x0E, 0x77, 0x20, 0xEE, 0x02,
  0x77, 0x74, 0x07, 0xE0, 0x97, 0x72, 0x09, 0xE0, 0x77, 0x77, 0x40, 0xDE, 0x03, 0x77, 0x20, 0x2E,
  0x0D, 0x77, 0x73, 0x04, 0xE0, 0xD7, 0x74, 0x0C, 0xE0, 0x47, 0x77, 0x20, 0x9E, 0x07, 0x77, 0x40,
  0x6E, 0x0A, 0x77, 0x72, 0x0E, 0xE0, 0x17, 0x75, 0x0E, 0xE0, 0x17, 0x77, 0x05, 0xE0, 0xA7, 0x76,
  0x09, 0xE0, 0x67, 0x77, 0x0B, 0xE0, 0x47, 0x76, 0x03, 0xE0, 0xC7, 0x76, 0x02, 0xE0, 0xE7, 0x77,
  0x10, 0xCE, 0x03, 0x77, 0x50, 0x7E, 0x08, 0x77, 0x71, 0x06, 0xE0, 0x87, 0x75, 0x0D, 0xE0, 0x27,
  0x77, 0x10, 0x1E, 0x0E, 0x77, 0x40, 0x3E, 0x0C, 0x77, 0x73, 0x09, 0xE0, 0x57, 0x73, 0x09, 0xE0,
  0x67, 0x77, 0x30, 0x3E, 0x0B, 0x77, 0x30, 0xED, 0x0E, 0x77, 0x75, 0x0D, 0xE0, 0x17, 0x71, 0x05,
  0xE0, 0x97, 0x77, 0x50, 0x7E, 0x07, 0x77, 0x10, 0xBE, 0x03, 0x77, 0x75, 0x01, 0xE0, 0xD7, 0x70,
  0x1E, 0x0D, 0x77, 0x77, 0x0A, 0xE0, 0x47, 0x60, 0x7E, 0x07, 0x77, 0x77, 0x04, 0xE0, 0xA7, 0x60,
  0xDE, 0x01, 0x77, 0x77, 0x10, 0xDE, 0x01, 0x74, 0x03, 0xE0, 0xB7, 0x77, 0x72, 0x07, 0xE0, 0x67,
  0x40, 0x9E, 0x05, 0x77, 0x77, 0x20, 0x1E, 0x0C, 0x74, 0x0E, 0xD0, 0xE7, 0x77, 0x74, 0x0A, 0xE0,
  0x27, 0x20, 0x5E, 0x08, 0x77, 0x77, 0x40, 0x4E, 0x07, 0x72, 0x0A, 0xE0, 0x37, 0x77, 0x75, 0x0D,
  0xD0, 0xD7, 0x10, 0x1E, 0x0C, 0x77, 0x77, 0x60, 0x8E, 0x03, 0x70, 0x6E, 0x06, 0x77, 0x77, 0x60,
  0x2E, 0x09, 0x70, 0xBE, 0x01, 0x77, 0x77, 0x70, 0xBD, 0x0E, 0x60, 0x1E, 0x0A, 0x80, 0xC0, 0x00,
  0x5E, 0x04, 0x50, 0x6E, 0x04, 0x80, 0xC1, 0x00, 0xED, 0x09, 0x50, 0xCD, 0x0D, 0x80, 0xC2, 0x00,
  0x8D, 0x0E, 0x40, 0x1E, 0x07, 0x80, 0xC2, 0x00, 0x2E, 0x05, 0x30, 0x7E, 0x02, 0x80, 0xC3, 0x00,
  0xBD, 0x0A, 0x30, 0xCD, 0x0B, 0x80, 0xC4, 0x00, 0x5D, 0x0E, 0x20, 0x1E, 0x05, 0x80, 0xC5, 0x00,
  0xED, 0x81, 0x40, 0x6D, 0x0E, 0x80, 0xC6, 0x00, 0x8D, 0x81, 0x90, 0xBD, 0x09, 0x80, 0xC6, 0x00,
  0x2D, 0x0D, 0x01, 0xE0, 0x38, 0x0C, 0x70, 0x0C, 0xD0, 0x9D, 0x0C, 0x80, 0xD0, 0x00, 0x6F, 0xC0,
  0x78, 0x0D, 0x10, 0x0E, 0xFB, 0x01, 0x80, 0xD1, 0x00, 0x9F, 0xA0, 0xA8, 0x0D, 0x20, 0x03, 0xFA,
  0x04, 0x80, 0xD3, 0x00, 0xCF, 0x0D, 0x80, 0xD4, 0x00, 0x6F, 0x08, 0x80, 0xD4, 0x00, 0x1F, 0x02,
  0x80, 0xD4, 0x00, 0x3E, 0x0B, 0x80, 0xD5, 0x00, 0x9E, 0x05, 0x80, 0xD5, 0x00, 0xED, 0x0E, 0x80,
  0xD5, 0x00, 0x5E, 0x09, 0x80, 0xD5, 0x00, 0xBE, 0x03, 0x80, 0xD4, 0x00, 0x2E, 0x0D, 0x80, 0xD5,
  0x00, 0x8E, 0x07, 0x80, 0xD5, 0x00, 0xEE, 0x01, 0x80, 0xD4, 0x00, 0x5E, 0x0A, 0x80, 0xD5, 0x00,
  0xBE, 0x05, 0x80, 0xD4, 0x00, 0x1E, 0x0E, 0x80, 0xD5, 0x00, 0x7E, 0x08, 0x80, 0xD5, 0x00, 0xDE,
  0x02, 0x80, 0xD4, 0x00, 0x5E, 0x0B, 0x80, 0xD5, 0x00, 0xCE, 0x04, 0x80, 0xD4, 0x00, 0x5E, 0x0C,
  0x80, 0xD5, 0x00, 0xDE, 0x05, 0x80, 0xD4, 0x00, 0x9E, 0x0C, 0x80, 0xD4, 0x00, 0x5F, 0x03, 0x80,
  0xD3, 0x00, 0x30, 0xEE, 0x0A, 0x80, 0xD3, 0x00, 0x40, 0xEE, 0x0E, 0x01, 0x80, 0xD2, 0x00, 0x8F,
  0x90, 0x57, 0x77, 0x76, 0x82, 0x98, 0x42, 0x68, 0x14, 0x9E, 0xF9, 0x08, 0x77, 0x77, 0x70, 0xBC,
  0x0F, 0xD0, 0xEF, 0xC0, 0xB8, 0x0C, 0x00, 0x0B, 0xFF, 0xC0, 0xB8, 0x0C, 0x10, 0x0B, 0xFF, 0xB0,
  0xA8, 0x0C, 0x20, 0x0B, 0xFF, 0x90, 0xE0, 0x68, 0x0C, 0x30, 0x0B, 0xFE, 0x81, 0xE8, 0x18, 0x0C,
  0x50, 0x83, 0x25, 0x9C, 0xEC, 0x82, 0xDB, 0x84, 0x80, 0xC7, 0x00,
  // "þ" (U+00FE)
  0x01, 0x80, 0x23, 0x01, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4,
  0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00,
  0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E,
  0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06,
  0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80,
  0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4,
  0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00,
  0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E,
  0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x80, 0xD4, 0x00, 0x6E, 0x06, 0x76, 0x84, 0x26, 0x9B, 0xDE,
  0xC8, 0x4E, 0xDB, 0x95, 0x27, 0x75, 0x06, 0xE0, 0x67, 0x38, 0x12, 0x8D, 0xFF, 0xA8, 0x1D, 0x82,
  0x77, 0x20, 0x6E, 0x06, 0x71, 0x02, 0x0A, 0xFF, 0xF9, 0x0B, 0x03, 0x77, 0x06, 0xE0, 0x67, 0x07,
  0xFF, 0xFD, 0x0A, 0x01, 0x75, 0x06, 0xE0, 0x55, 0x01, 0x0B, 0xFF, 0xFF, 0x0E, 0x04, 0x74, 0x06,
  0xE0, 0x54, 0x02, 0x0D, 0xFF, 0xFF, 0xB0, 0x77, 0x30, 0x6E, 0x05, 0x30, 0x20, 0xDF, 0x98, 0x3C,
  0x85, 0x31, 0x58, 0x22, 0x47, 0xBF, 0xC0, 0x87, 0x20, 0x6E, 0x05, 0x20, 0x10, 0xDE, 0x81, 0xD6,
  0x17, 0x78, 0x11, 0x7D, 0xFA, 0x07, 0x71, 0x06, 0xE0, 0x42, 0x0C, 0xD0, 0xE0, 0x57, 0x76, 0x06,
  0x0E, 0xF9, 0x06, 0x70, 0x6E, 0x81, 0x40, 0x8D, 0x0A, 0x01, 0x77, 0x71, 0x02, 0x0C, 0xF0, 0xE0,
  0x26, 0x06, 0xE0, 0x03, 0xD0, 0x87, 0x77, 0x50, 0xBF, 0x0C, 0x60, 0x6E, 0x02, 0x0C, 0xC0, 0x87,
  0x77, 0x70, 0xCF, 0x06, 0x50, 0x6E, 0x07, 0xC0, 0xA7, 0x77, 0x71, 0x01, 0x0D, 0xE0, 0xE0, 0x14,
  0x06, 0xFB, 0x0D, 0x01, 0x77, 0x77, 0x20, 0x4F, 0x07, 0x40, 0x6F, 0xB0, 0x47, 0x77, 0x74, 0x0A,
  0xE0, 0xE4, 0x06, 0xFA, 0x0C, 0x77, 0x77, 0x50, 0x2F, 0x06, 0x30, 0x6F, 0xA0, 0x47, 0x77, 0x76,
  0x0A, 0xE0, 0xB3, 0x06, 0xF9, 0x0D, 0x77, 0x77, 0x70, 0x4F, 0x01, 0x20, 0x6F, 0x90, 0x78, 0x0C,
  0x00, 0x0D, 0xE0, 0x62, 0x06, 0xF9, 0x02, 0x80, 0xC0, 0x00, 0x8E, 0x0A, 0x20, 0x6F, 0x0D, 0x80,
  0xC1, 0x00, 0x4E, 0x0D, 0x20, 0x6F, 0x09, 0x80, 0xC2, 0x0F, 0x81, 0x10, 0x6F, 0x06, 0x80, 0xC2,
  0x00, 0xCE, 0x81, 0x40, 0x6F, 0x03, 0x80, 0xC2, 0x00, 0x9E, 0x81, 0x70, 0x6F, 0x80, 0xC3, 0x00,
  0x7E, 0x81, 0x90, 0x6E, 0x0D, 0x80, 0xC3, 0x00, 0x5E, 0x81, 0xB0, 0x6E, 0x0C, 0x80, 0xC3, 0x00,
  0x3E, 0x81, 0xD0, 0x6E, 0x0A, 0x80, 0xC3, 0x00, 0x2E, 0x81, 0xE0, 0x6E, 0x09, 0x80, 0xC3, 0x00,
  0x1F, 0x10, 0x6E, 0x08, 0x80, 0xC4, 0x0F, 0x01, 0x06, 0xE0, 0x88, 0x0C, 0x40, 0xF0, 0x10, 0x6E,
  0x08, 0x80, 0xC4, 0x00, 0xEE, 0x01, 0x06, 0xE0, 0x78, 0x0C, 0x40, 0x0E, 0xE0, 0x20, 0x6E, 0x08,
  0x80, 0xC4, 0x00, 0xEE, 0x02, 0x06, 0xE0, 0x88, 0x0C, 0x40, 0xF0, 0x10, 0x6E, 0x08, 0x80, 0xC4,
  0x0F, 0x01, 0x06, 0xE0, 0x98, 0x0C, 0x40, 0xF1, 0x06, 0xE0, 0xA8, 0x0C, 0x30, 0x02, 0xF1, 0x06,
  0xE0, 0xB8, 0x0C, 0x30, 0x03, 0xE8, 0x1D, 0x06, 0xE0, 0xC8, 0x0C, 0x30, 0x05, 0xE8, 0x1C, 0x06,
  0xE0, 0xE8, 0x0C, 0x30, 0x07, 0xE8, 0x1A, 0x06, 0xF0, 0x18, 0x0C, 0x20, 0x09, 0xE8, 0x18, 0x06,
  0xF0, 0x38, 0x0C, 0x20, 0x0C, 0xE8, 0x15, 0x06, 0xF0, 0x68, 0x0C, 0x20, 0xF8, 0x13, 0x06, 0xF0,
  0x98, 0x0C, 0x10, 0x03, 0xF2, 0x06, 0xF0, 0xD8, 0x0C, 0x10, 0x07, 0xE0, 0xB2, 0x06, 0xF9, 0x02,
  0x80, 0xC0, 0x00, 0xCE, 0x08, 0x20, 0x6F, 0x90, 0x77, 0x77, 0x77, 0x02, 0xF0, 0x32, 0x06, 0xF9,
  0x0C, 0x77, 0x77, 0x70, 0x8E, 0x0D, 0x30, 0x6F, 0xA0, 0x37, 0x77, 0x76, 0x0E, 0xE0, 0x83, 0x06,
  0xFA, 0x0A, 0x77, 0x77, 0x50, 0x7F, 0x02, 0x30, 0x6F, 0xB0, 0x27, 0x77, 0x73, 0x01, 0x0E, 0xE0,
  0xB4, 0x06, 0xFB, 0x0B, 0x77, 0x77, 0x30, 0xAF, 0x04, 0x40, 0x6F, 0xC0, 0x67, 0x77, 0x71, 0x05,
  0xF0, 0xB5, 0x06, 0xD0, 0xE0, 0x4D, 0x03, 0x77, 0x76, 0x03, 0xF9, 0x03, 0x50, 0x6E, 0x10, 0xBC,
  0x0E, 0x03, 0x77, 0x74, 0x03, 0x0E, 0xF0, 0x86, 0x06, 0xE1, 0x02, 0xD0, 0xE0, 0x47, 0x77, 0x20,
  0x50, 0xEF, 0x0C, 0x70, 0x6E, 0x81, 0x10, 0x6E, 0x09, 0x01, 0x77, 0x50, 0x10, 0x9F, 0x90, 0xE0,
  0x27, 0x06, 0xE0, 0x22, 0x09, 0xE8, 0x1E, 0x71, 0x77, 0x18, 0x11, 0x7E, 0xF9, 0x0E, 0x03, 0x71,
  0x06, 0xE0, 0x23, 0x0A, 0xF9, 0x81, 0xB6, 0x37, 0x28, 0x12, 0x6A, 0xFC, 0x04, 0x72, 0x06, 0xE0,
  0x34, 0x0A, 0xFC, 0x0D, 0x80, 0x1B, 0x0D, 0xFE, 0x0E, 0x03, 0x73, 0x06, 0xE0, 0x45, 0x07, 0xFF,
  0xFF, 0x90, 0xC0, 0x27, 0x40, 0x6E, 0x04, 0x60, 0x40, 0xDF, 0xFF, 0xD0, 0x77, 0x60, 0x6E, 0x05,
  0x71, 0x08, 0x0E, 0xFF, 0xF9, 0x09, 0x01, 0x77, 0x06, 0xE0, 0x57, 0x28, 0x11, 0x7D, 0xFF, 0xB8,
  0x1D, 0x71, 0x77, 0x20, 0x6E, 0x06, 0x75, 0x83, 0x26, 0xAC, 0xEF, 0x83, 0xEC, 0x96, 0x27, 0x75,
  0x06, 0xE0, 0x67, 0x74, 0x81, 0x11, 0x30, 0xF1, 0x77, 0x73, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06,
  0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0,
  0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68,
  0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D,
  0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40,
  0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06,
  0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0,
  0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68,
  0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x06, 0xE0, 0x68, 0x0D, 0x40, 0x01, 0x80, 0x23, 0x01,
  0x80, 0xD4, 0x00,
  // "ÿ" (U+00FF)
  0x77, 0x18, 0x23, 0x55, 0x27, 0x74, 0x82, 0x25, 0x53, 0x77, 0x77, 0x10, 0x10, 0xCC, 0x09, 0x77,
  0x20, 0x9C, 0x0C, 0x02, 0x77, 0x76, 0x0A, 0xE0, 0x77, 0x70, 0x5E, 0x0C, 0x77, 0x75, 0x01, 0xF0,
  0xD7, 0x70, 0xBF, 0x03, 0x77, 0x74, 0x03, 0xF9, 0x77, 0x0E, 0xF0, 0x57, 0x77, 0x40, 0x4F, 0x90,
  0x17, 0x60, 0xEF, 0x06, 0x77, 0x74, 0x03, 0xF9, 0x77, 0x0D, 0xF0, 0x57, 0x77, 0x5F, 0x0C, 0x77,
  0x0A, 0xF0, 0x27, 0x77, 0x50, 0x9E, 0x06, 0x77, 0x04, 0xE0, 0xB7, 0x77, 0x70, 0xAC, 0x08, 0x77,
  0x20, 0x7C, 0x0B, 0x01, 0x77, 0x77, 0x18, 0x12, 0x33, 0x77, 0x68, 0x13, 0x32, 0x80, 0x9A, 0xF0,
  0x00, 0xB8, 0x02, 0xD0, 0x68, 0x0C, 0x40, 0x01, 0x80, 0x3D, 0x03, 0x07, 0xE0, 0xC8, 0x0C, 0x40,
  0x06, 0xE8, 0x1D, 0x01, 0xF0, 0x38, 0x0C, 0x30, 0x0C, 0xE0, 0x72, 0x0A, 0xE0, 0x98, 0x0C, 0x20,
  0x02, 0xF0, 0x22, 0x04, 0xE0, 0xE8, 0x0C, 0x20, 0x08, 0xE0, 0xB4, 0x0D, 0xE0, 0x58, 0x0C, 0x10,
  0x0D, 0xE0, 0x54, 0x07, 0xE0, 0xB8, 0x0C, 0x00, 0x04, 0xE0, 0xE5, 0x01, 0xF0, 0x27, 0x77, 0x77,
  0x0A, 0xE0, 0x96, 0x0B, 0xE0, 0x77, 0x77, 0x76, 0x01, 0xF0, 0x36, 0x04, 0xE0, 0xD7, 0x77, 0x76,
  0x06, 0xE0, 0xC7, 0x10, 0xDE, 0x04, 0x77, 0x77, 0x50, 0xCE, 0x06, 0x71, 0x08, 0xE0, 0xA7, 0x77,
  0x74, 0x02, 0xF0, 0x17, 0x10, 0x2F, 0x01, 0x77, 0x77, 0x30, 0x8E, 0x0A, 0x73, 0x0B, 0xE0, 0x67,
  0x77, 0x73, 0x0D, 0xE0, 0x47, 0x30, 0x5E, 0x0C, 0x77, 0x77, 0x20, 0x4E, 0x0D, 0x75, 0x0E, 0xE0,
  0x37, 0x77, 0x71, 0x0A, 0xE0, 0x87, 0x50, 0x8E, 0x09, 0x77, 0x77, 0x10, 0xEE, 0x02, 0x75, 0x02,
  0xE0, 0xE7, 0x77, 0x70, 0x6E, 0x0B, 0x77, 0x0B, 0xE0, 0x57, 0x77, 0x60, 0xBE, 0x05, 0x77, 0x05,
  0xE0, 0xB7, 0x77, 0x50, 0x2E, 0x0E, 0x77, 0x20, 0xEE, 0x02, 0x77, 0x74, 0x07, 0xE0, 0x97, 0x72,
  0x09, 0xE0, 0x77, 0x77, 0x40, 0xDE, 0x03, 0x77, 0x20, 0x2E, 0x0D, 0x77, 0x73, 0x04, 0xE0, 0xD7,
  0x74, 0x0C, 0xE0, 0x47, 0x77, 0x20, 0x9E, 0x07, 0x77, 0x40, 0x6E, 0x0A, 0x77, 0x72, 0x0E, 0xE0,
  0x17, 0x75, 0x0E, 0xE0, 0x17, 0x77, 0x05, 0xE0, 0xA7, 0x76, 0x09, 0xE0, 0x67, 0x77, 0x0B, 0xE0,
  0x47, 0x76, 0x03, 0xE0, 0xC7, 0x76, 0x02, 0xE0, 0xE7, 0x77, 0x10, 0xCE, 0x03, 0x77, 0x50, 0x7E,
  0x08, 0x77, 0x71, 0x06, 0xE0, 0x87, 0x75, 0x0D, 0xE0, 0x27, 0x77, 0x10, 0x1E, 0x0E, 0x77, 0x40,
  0x3E, 0x0C, 0x77, 0x73, 0x09, 0xE0, 0x57, 0x73, 0x09, 0xE0, 0x67, 0x77, 0x30, 0x3E, 0x0B, 0x77,
  0x30, 0xED, 0x0E, 0x77, 0x75, 0x0D, 0xE0, 0x17, 0x71, 0x05, 0xE0, 0x97, 0x77, 0x50, 0x7E, 0x07,
  0x77, 0x10, 0xBE, 0x03, 0x77, 0x75, 0x01, 0xE0, 0xD7, 0x70, 0x1E, 0x0D, 0x77, 0x77, 0x0A, 0xE0,
  0x47, 0x60, 0x7E, 0x07, 0x77, 0x77, 0x04, 0xE0, 0xA7, 0x60, 0xDE, 0x01, 0x77, 0x77, 0x10, 0xDE,
  0x01, 0x74, 0x03, 0xE0, 0xB7, 0x77, 0x72, 0x07, 0xE0, 0x67, 0x40, 0x9E, 0x05, 0x77, 0x77, 0x20,
  0x1E, 0x0C, 0x74, 0x0E, 0xD0, 0xE7, 0x77, 0x74, 0x0A, 0xE0, 0x27, 0x20, 0x5E, 0x08, 0x77, 0x77,
  0x40, 0x4E, 0x07, 0x72, 0x0A, 0xE0, 0x37, 0x77, 0x75, 0x0D, 0xD0, 0xD7, 0x10, 0x1E, 0x0C, 0x77,
  0x77, 0x60, 0x8E, 0x03, 0x70, 0x6E, 0x06, 0x77, 0x77, 0x60, 0x2E, 0x09, 0x70, 0xBE, 0x01, 0x77,
  0x77, 0x70, 0xBD, 0x0E, 0x60, 0x1E, 0x0A, 0x80, 0xC0, 0x00, 0x5E, 0x04, 0x50, 0x6E, 0x04, 0x80,
  0xC1, 0x00, 0xED, 0x09, 0x50, 0xCD, 0x0D, 0x80, 0xC2, 0x00, 0x8D, 0x0E, 0x40, 0x1E, 0x07, 0x80,
  0xC2, 0x00, 0x2E, 0x05, 0x30, 0x7E, 0x02, 0x80, 0xC3, 0x00, 0xBD, 0x0A, 0x30, 0xCD, 0x0B, 0x80,
  0xC4, 0x00, 0x5D, 0x0E, 0x20, 0x1E, 0x05, 0x80, 0xC5, 0x00, 0xED, 0x81, 0x40, 0x6D, 0x0E, 0x80,
  0xC6, 0x00, 0x8D, 0x81, 0x90, 0xBD, 0x09, 0x80, 0xC6, 0x00, 0x2D, 0x0D, 0x01, 0xE0, 0x38, 0x0C,
  0x70, 0x0C, 0xD0, 0x9D, 0x0C, 0x80, 0xD0, 0x00, 0x6F, 0xC0, 0x78, 0x0D, 0x10, 0x0E, 0xFB, 0x01,
  0x80, 0xD1, 0x00, 0x9F, 0xA0, 0xA8, 0x0D, 0x20, 0x03, 0xFA, 0x04, 0x80, 0xD3, 0x00, 0xCF, 0x0D,
  0x80, 0xD4, 0x00, 0x6F, 0x08, 0x80, 0xD4, 0x00, 0x1F, 0x02, 0x80, 0xD4, 0x00, 0x3E, 0x0B, 0x80,
  0xD5, 0x00, 0x9E, 0x05, 0x80, 0xD5, 0x00, 0xED, 0x0E, 0x80, 0xD5, 0x00, 0x5E, 0x09, 0x80, 0xD5,
  0x00, 0xBE, 0x03, 0x80, 0xD4, 0x00, 0x2E, 0x0D, 0x80, 0xD5, 0x00, 0x8E, 0x07, 0x80, 0xD5, 0x00,
  0xEE, 0x01, 0x80, 0xD4, 0x00, 0x5E, 0x0A, 0x80, 0xD5, 0x00, 0xBE, 0x05, 0x80, 0xD4, 0x00, 0x1E,
  0x0E, 0x80, 0xD5, 0x00, 0x7E, 0x08, 0x80, 0xD5, 0x00, 0xDE, 0x02, 0x80, 0xD4, 0x00, 0x5E, 0x0B,
  0x80, 0xD5, 0x00, 0xCE, 0x04, 0x80, 0xD4, 0x00, 0x5E, 0x0C, 0x80, 0xD5, 0x00, 0xDE, 0x05, 0x80,
  0xD4, 0x00, 0x9E, 0x0C, 0x80, 0xD4, 0x00, 0x5F, 0x03, 0x80, 0xD3, 0x00, 0x30, 0xEE, 0x0A, 0x80,
  0xD3, 0x00, 0x40, 0xEE, 0x0E, 0x01, 0x80, 0xD2, 0x00, 0x8F, 0x90, 0x57, 0x77, 0x76, 0x82, 0x98,
  0x42, 0x68, 0x14, 0x9E, 0xF9, 0x08, 0x77, 0x77, 0x70, 0xBC, 0x0F, 0xD0, 0xEF, 0xC0, 0xB8, 0x0C,
  0x00, 0x0B, 0xFF, 0xC0, 0xB8, 0x0C, 0x10, 0x0B, 0xFF, 0xB0, 0xA8, 0x0C, 0x20, 0x0B, 0xFF, 0x90,
  0xE0, 0x68, 0x0C, 0x30, 0x0B, 0xFE, 0x81, 0xE8, 0x18, 0x0C, 0x50, 0x83, 0x25, 0x9C, 0xEC, 0x82,
  0xDB, 0x84, 0x80, 0xC7, 0x00,
  // "Ā" (U+0100)
  0x77, 0x60, 0x98, 0x0B, 0x4B, 0x03, 0x80, 0xC3, 0x00, 0xDF, 0xFF, 0xFC, 0x04, 0x80, 0xC3, 0x00,
  0xDF, 0xFF, 0xFC, 0x04, 0x80, 0xC3, 0x00, 0xDF, 0xFF, 0xFC, 0x04, 0x80, 0xC3, 0x00, 0xDF, 0xFF,
  0xFC, 0x04, 0x80, 0xC3, 0x00, 0xDF, 0xFF, 0xFC, 0x04, 0x80, 0x9B, 0x81, 0x00, 0x88, 0x02, 0xD0,
  0x38, 0x0F, 0x50, 0x0E, 0xE0, 0x98, 0x0F, 0x40, 0x05, 0xF0, 0xE8, 0x0F, 0x40, 0x0B, 0xF9, 0x06,
  0x80, 0xF2, 0x00, 0x2F, 0xA0, 0xB8, 0x0F, 0x20, 0x08, 0xFB, 0x02, 0x80, 0xF1, 0x00, 0xDF, 0xB0,
  0x88, 0x0F, 0x00, 0x04, 0xD0, 0xED, 0x0D, 0x80, 0xF0, 0x00, 0xAD, 0x07, 0x0E, 0xD0, 0x48, 0x0E,
  0x60, 0x01, 0xE0, 0x10, 0x9D, 0x0A, 0x80, 0xE6, 0x00, 0x7D, 0x81, 0xC0, 0x4E, 0x01, 0x80, 0xE5,
  0x00, 0xDD, 0x07, 0x20, 0xED, 0x06, 0x80, 0xE4, 0x00, 0x4E, 0x02, 0x20, 0x9D, 0x0C, 0x80, 0xE4,
  0x00, 0xAD, 0x0C, 0x30, 0x4E, 0x03, 0x80, 0xE2, 0x00, 0x1E, 0x07, 0x40, 0xED, 0x09, 0x80, 0xE2,
  0x00, 0x6E, 0x02, 0x40, 0x9D, 0x0E, 0x80, 0xE2, 0x00, 0xCD, 0x0C, 0x50, 0x4E, 0x05, 0x80, 0xE0,
  0x00, 0x3E, 0x07, 0x60, 0xED, 0x0B, 0x80, 0xE0, 0x00, 0x9E, 0x02, 0x60, 0xAE, 0x02, 0x80, 0xD7,
  0x00, 0xED, 0x0C, 0x70, 0x5E, 0x07, 0x80, 0xD6, 0x00, 0x6E, 0x07, 0x71, 0x0E, 0xD0, 0xD8, 0x0D,
  0x60, 0x0C, 0xE0, 0x17, 0x10, 0x9E, 0x04, 0x80, 0xD4, 0x00, 0x2E, 0x0A, 0x72, 0x03, 0xE0, 0xA8,
  0x0D, 0x40, 0x08, 0xE0, 0x47, 0x30, 0xDE, 0x01, 0x80, 0xD3, 0x00, 0xED, 0x0D, 0x74, 0x07, 0xE0,
  0x68, 0x0D, 0x20, 0x05, 0xE0, 0x87, 0x40, 0x2E, 0x0C, 0x80, 0xD2, 0x00, 0xBE, 0x02, 0x75, 0x0B,
  0xE0, 0x28, 0x0D, 0x00, 0x02, 0xE0, 0xB7, 0x60, 0x5E, 0x08, 0x80, 0xD0, 0x00, 0x8E, 0x05, 0x77,
  0x0E, 0xD0, 0xE8, 0x0D, 0x00, 0x0D, 0xD0, 0xE7, 0x71, 0x09, 0xE0, 0x58, 0x0C, 0x60, 0x04, 0xE0,
  0x97, 0x71, 0x04, 0xE0, 0xB8, 0x0C, 0x60, 0x0A, 0xE0, 0x37, 0x72, 0x0D, 0xE0, 0x18, 0x0C, 0x40,
  0x01, 0xE0, 0xC7, 0x73, 0x08, 0xE0, 0x78, 0x0C, 0x40, 0x07, 0xE0, 0x67, 0x73, 0x02, 0xE0, 0xD8,
  0x0C, 0x40, 0x0D, 0xE0, 0x17, 0x74, 0x0C, 0xE0, 0x38, 0x0C, 0x20, 0x03, 0xE0, 0xA7, 0x75, 0x06,
  0xE0, 0x98, 0x0C, 0x20, 0x0A, 0xE0, 0x47, 0x75, 0x01, 0xE0, 0xE8, 0x0C, 0x10, 0x01, 0xE0, 0xD7,
  0x77, 0x0A, 0xE0, 0x68, 0x0C, 0x00, 0x06, 0xE0, 0x87, 0x77, 0x04, 0xE0, 0xC8, 0x0C, 0x00, 0x0C,
  0xE0, 0x27, 0x77, 0x10, 0xDE, 0x02, 0x77, 0x77, 0x60, 0x3E, 0x0B, 0x77, 0x72, 0x08, 0xE0, 0x87,
  0x77, 0x76, 0x09, 0xE0, 0x57, 0x77, 0x20, 0x2E, 0x0E, 0x77, 0x77, 0x60, 0xED, 0x0E, 0x77, 0x74,
  0x0C, 0xE0, 0x47, 0x77, 0x74, 0x05, 0xE0, 0x97, 0x77, 0x40, 0x6E, 0x0A, 0x77, 0x77, 0x40, 0xBE,
  0x03, 0x77, 0x74, 0x01, 0xF0, 0x17, 0x77, 0x72, 0x02, 0xE0, 0xC7, 0x77, 0x60, 0xAE, 0x07, 0x77,
  0x77, 0x20, 0x8E, 0x06, 0x77, 0x76, 0x04, 0xE0, 0xD7, 0x77, 0x72, 0x0E, 0xE0, 0x17, 0x77, 0x70,
  0xEE, 0x03, 0x77, 0x77, 0x05, 0xE0, 0xA7, 0x77, 0x71, 0x08, 0xE0, 0x97, 0x77, 0x70, 0xBE, 0x04,
  0x77, 0x77, 0x10, 0x3E, 0x0E, 0x77, 0x76, 0x01, 0xF8, 0x0B, 0x3B, 0xF0, 0x57, 0x77, 0x50, 0x78,
  0x0D, 0x1F, 0x0B, 0x77, 0x75, 0x0D, 0x80, 0xD2, 0xF0, 0x27, 0x77, 0x30, 0x48, 0x0D, 0x3F, 0x08,
  0x77, 0x73, 0x0A, 0x80, 0xD3, 0xF0, 0xD7, 0x77, 0x20, 0x18, 0x0D, 0x5F, 0x04, 0x77, 0x71, 0x07,
  0xE0, 0xC8, 0x0B, 0x77, 0x0C, 0xE0, 0xA7, 0x77, 0x10, 0xDE, 0x04, 0x77, 0x77, 0x70, 0x5F, 0x01,
  0x77, 0x60, 0x3E, 0x0E, 0x80, 0xC1, 0x00, 0xEE, 0x06, 0x77, 0x60, 0x9E, 0x08, 0x80, 0xC1, 0x00,
  0x9E, 0x0C, 0x77, 0x50, 0x10, 0xEE, 0x02, 0x80, 0xC1, 0x00, 0x3F, 0x03, 0x77, 0x40, 0x6E, 0x0B,
  0x80, 0xC3, 0x00, 0xCE, 0x08, 0x77, 0x40, 0xCE, 0x05, 0x80, 0xC3, 0x00, 0x6E, 0x0E, 0x77, 0x30,
  0x3E, 0x0E, 0x80, 0xC4, 0x00, 0x1F, 0x05, 0x77, 0x20, 0x9E, 0x08, 0x80, 0xC5, 0x00, 0xAE, 0x0B,
  0x77, 0x20, 0xEE, 0x02, 0x80, 0xC5, 0x00, 0x4F, 0x01, 0x77, 0x05, 0xE0, 0xB8, 0x0C, 0x70, 0x0D,
  0xE0, 0x77, 0x70, 0xBE, 0x05, 0x80, 0xC7, 0x00, 0x7E, 0x0D, 0x76, 0x02, 0xE0, 0xE8, 0x0D, 0x00,
  0x01, 0xF0, 0x37, 0x50, 0x8E, 0x09, 0x80, 0xD1, 0x00, 0xBE, 0x09, 0x75, 0x0E, 0xE0, 0x28, 0x0D,
  0x10, 0x05, 0xE0, 0xE7, 0x40, 0x5E, 0x0C, 0x80, 0xD3, 0x00, 0xEE, 0x06, 0x73, 0x0B, 0xE0, 0x68,
  0x0D, 0x30, 0x08, 0xE0, 0xC7, 0x20, 0x1E, 0x0E, 0x80, 0xD4, 0x00, 0x2F, 0x02, 0x71, 0x07, 0xE0,
  0x98, 0x0D, 0x50, 0x0C, 0xE0, 0x87, 0x10, 0xDE, 0x03, 0x80, 0xD5, 0x00, 0x6E, 0x0E, 0x70, 0x4E,
  0x0C, 0x80, 0xD6, 0x00, 0x10, 0xEE, 0x04, 0x60, 0xAE, 0x06, 0x80, 0xD7, 0x00, 0x9E, 0x0A, 0x50,
  0x1E, 0x0E, 0x01, 0x80, 0xD7, 0x00, 0x3F, 0x01, 0x40, 0x7E, 0x09, 0x80, 0xE1, 0x00, 0xDE, 0x07,
  0x40, 0xDE, 0x03, 0x80, 0xE1, 0x00, 0x7E, 0x0D, 0x30, 0x3E, 0x0D, 0x80, 0xE2, 0x00, 0x1F, 0x03,
  0x20, 0x9E, 0x07, 0x80, 0xE3, 0x00, 0xBE, 0x09, 0x20, 0xEE, 0x01, 0x80, 0xE3, 0x00, 0x5E, 0x81,
  0xE0, 0x6E, 0x0A, 0x80, 0xE5, 0x00, 0xEE, 0x05, 0x0C, 0xE0, 0x48, 0x0E, 0x50, 0x08, 0xE0, 0xB0,
  // "ā" (U+0101)
  0x73, 0x0B, 0xFF, 0xFF, 0xC0, 0x57, 0x72, 0x0B, 0xFF, 0xFF, 0xC0, 0x57, 0x72, 0x0B, 0xFF, 0xFF,
  0xC0, 0x57, 0x72, 0x0B, 0xFF, 0xFF, 0xC0, 0x57, 0x72, 0x0B, 0xFF, 0xFF, 0xC0, 0x57, 0x72, 0x08,
  0x80, 0xB4, 0xB0, 0x48, 0x0E, 0xC5, 0x08, 0x41, 0x36, 0x8A, 0xB8, 0x02, 0xD8, 0x3B, 0xA8, 0x52,
  0x77, 0x77, 0x18, 0x21, 0x59, 0xDF, 0xFB, 0x81, 0xD9, 0x37, 0x77, 0x28, 0x11, 0x6B, 0xFF, 0xFB,
  0x0C, 0x05, 0x77, 0x50, 0x40, 0xBF, 0xFF, 0xF9, 0x0B, 0x01, 0x77, 0x10, 0x60, 0xDF, 0xFF, 0xFC,
  0x0E, 0x04, 0x76, 0x0A, 0xFF, 0xB0, 0xE8, 0x00, 0xDF, 0xF0, 0x57, 0x50, 0x5F, 0xC8, 0x3D, 0x96,
  0x31, 0x78, 0x22, 0x49, 0xDF, 0xB0, 0x37, 0x50, 0xEF, 0x81, 0xA5, 0x17, 0x72, 0x04, 0x0C, 0xF9,
  0x0D, 0x75, 0x09, 0xC8, 0x1C, 0x61, 0x77, 0x70, 0x7F, 0x90, 0x87, 0x40, 0x3A, 0x0A, 0x03, 0x77,
  0x74, 0x04, 0xF9, 0x01, 0x74, 0x08, 0x02, 0x77, 0x77, 0x06, 0xF0, 0x88, 0x0C, 0x60, 0x0A, 0xE0,
  0xD8, 0x0C, 0x60, 0x02, 0xF0, 0x38, 0x0C, 0x60, 0x0B, 0xE0, 0x78, 0x0C, 0x60, 0x05, 0xE0, 0xB8,
  0x0C, 0x60, 0x01, 0xE0, 0xE8, 0x0C, 0x70, 0x0C, 0xE0, 0x18, 0x0C, 0x60, 0x0A, 0xE0, 0x38, 0x0C,
  0x60, 0x07, 0xE0, 0x58, 0x0C, 0x60, 0x06, 0xE0, 0x68, 0x0C, 0x60, 0x05, 0xE0, 0x68, 0x0C, 0x60,
  0x04, 0xE0, 0x78, 0x0C, 0x60, 0x03, 0xE0, 0x78, 0x0C, 0x60, 0x03, 0xE0, 0x78, 0x0C, 0x60, 0x03,
  0xE0, 0x78, 0x0C, 0x60, 0x03, 0xE0, 0x78, 0x0C, 0x60, 0x03, 0xE0, 0x77, 0x77, 0x77, 0x86, 0x11,
  0x23, 0x35, 0x58, 0xE0, 0x77, 0x77, 0x28, 0x90, 0x24, 0x67, 0x9A, 0xBC, 0xDD, 0xFF, 0xA0, 0x77,
  0x74, 0x82, 0x37, 0xAD, 0xFF, 0xFE, 0x07, 0x77, 0x82, 0x16, 0xBE, 0xFF, 0xFF, 0xB0, 0x77, 0x50,
  0x50, 0xBF, 0xFF, 0xFF, 0x07, 0x73, 0x06, 0x0D, 0xFF, 0xFF, 0x81, 0xED, 0xDE, 0x07, 0x71, 0x03,
  0x0C, 0xFF, 0x98, 0x5D, 0xB9, 0x87, 0x55, 0x0F, 0x30, 0xF1, 0x40, 0x3E, 0x07, 0x70, 0x8F, 0xD8,
  0x2C, 0x85, 0x27, 0x74, 0x03, 0xE0, 0x76, 0x0B, 0xFB, 0x81, 0xA5, 0x17, 0x77, 0x10, 0x3E, 0x07,
  0x40, 0x10, 0xCF, 0x98, 0x1E, 0x81, 0x77, 0x74, 0x03, 0xE0, 0x74, 0x0B, 0xF9, 0x09, 0x01, 0x77,
  0x76, 0x03, 0xE0, 0x73, 0x07, 0xF0, 0xE0, 0x47, 0x77, 0x71, 0x03, 0xE0, 0x72, 0x02, 0xF0, 0xE0,
  0x37, 0x77, 0x72, 0x04, 0xE0, 0x72, 0x0A, 0xF0, 0x47, 0x77, 0x73, 0x05, 0xE8, 0x17, 0x02, 0xF0,
  0x87, 0x77, 0x74, 0x06, 0xE8, 0x17, 0x07, 0xE0, 0xE7, 0x77, 0x75, 0x08, 0xE8, 0x17, 0x0B, 0xE0,
  0x87, 0x77, 0x75, 0x0A, 0xE0, 0x71, 0xF0, 0x37, 0x77, 0x75, 0x0D, 0xE0, 0x70, 0x2F, 0x77, 0x77,
  0x50, 0x1F, 0x07, 0x04, 0xE0, 0xD7, 0x77, 0x75, 0x05, 0xF0, 0x70, 0x4E, 0x0B, 0x77, 0x77, 0x50,
  0x9F, 0x07, 0x05, 0xE0, 0xB7, 0x77, 0x75, 0x0E, 0xF0, 0x70, 0x4E, 0x0B, 0x77, 0x77, 0x40, 0x6F,
  0x90, 0x70, 0x4E, 0x0D, 0x77, 0x77, 0x40, 0xDF, 0x90, 0x70, 0x2F, 0x77, 0x77, 0x30, 0x6F, 0xA0,
  0x71, 0xF0, 0x47, 0x77, 0x71, 0x02, 0x0E, 0xFA, 0x81, 0x70, 0xCE, 0x09, 0x77, 0x77, 0x10, 0xCF,
  0xB8, 0x17, 0x08, 0xF0, 0x17, 0x77, 0x60, 0xAC, 0x09, 0x0E, 0xD8, 0x17, 0x03, 0xF0, 0xA7, 0x77,
  0x50, 0xAC, 0x81, 0xC0, 0xDD, 0x07, 0x20, 0xCF, 0x08, 0x77, 0x72, 0x01, 0x0C, 0xD8, 0x12, 0x0B,
  0xD0, 0x72, 0x05, 0xF9, 0x09, 0x77, 0x70, 0x60, 0xED, 0x05, 0x20, 0x9D, 0x07, 0x30, 0xBF, 0x90,
  0xD0, 0x47, 0x73, 0x06, 0x0D, 0xE0, 0x73, 0x07, 0xD0, 0x73, 0x01, 0x0E, 0xFA, 0x81, 0xC7, 0x27,
  0x38, 0x22, 0x5A, 0xEF, 0x08, 0x40, 0x5D, 0x07, 0x40, 0x30, 0xEF, 0xC8, 0x90, 0xEC, 0xA9, 0x99,
  0x9A, 0xCE, 0xFB, 0x06, 0x50, 0x3D, 0x07, 0x50, 0x30, 0xEF, 0xFF, 0xF0, 0xE0, 0x56, 0x01, 0xD0,
  0x76, 0x01, 0x0C, 0xFF, 0xFD, 0x0C, 0x01, 0x71, 0xD0, 0x77, 0x10, 0x60, 0xEF, 0xFF, 0x90, 0xD0,
  0x67, 0x30, 0xDC, 0x07, 0x73, 0x06, 0x0C, 0xFF, 0xC0, 0xB0, 0x57, 0x50, 0xBC, 0x07, 0x75, 0x83,
  0x16, 0x9C, 0xEF, 0x98, 0x3D, 0xB8, 0x51, 0x80, 0xC2, 0x08, 0x41, 0x23, 0x21, 0x17, 0x77, 0x50,
  // "Ă" (U+0102)
  0x77, 0x60, 0x48, 0x00, 0x57, 0x77, 0x28, 0x41, 0x55, 0x55, 0x28, 0x0C, 0x30, 0x0B, 0xC0, 0x17,
  0x77, 0x10, 0x6C, 0x06, 0x80, 0xC3, 0x00, 0x9C, 0x03, 0x77, 0x71, 0x09, 0xC0, 0x38, 0x0C, 0x30,
  0x07, 0xC0, 0x87, 0x77, 0x10, 0xDC, 0x80, 0xC4, 0x00, 0x3C, 0x0D, 0x77, 0x70, 0x4C, 0x0B, 0x80,
  0xC5, 0x00, 0xEC, 0x06, 0x77, 0x60, 0xCC, 0x07, 0x80, 0xC5, 0x00, 0x8C, 0x0E, 0x02, 0x77, 0x40,
  0x9D, 0x01, 0x80, 0xC5, 0x00, 0x2D, 0x0E, 0x04, 0x77, 0x10, 0x10, 0xBD, 0x09, 0x80, 0xC7, 0x00,
  0x9E, 0x0B, 0x04, 0x74, 0x81, 0x28, 0xED, 0x0E, 0x01, 0x80, 0xD0, 0x00, 0xDF, 0x89, 0x1E, 0xB8,
  0x65, 0x55, 0x57, 0xAD, 0xF9, 0x05, 0x80, 0xD1, 0x00, 0x30, 0xEF, 0xFF, 0xB0, 0x88, 0x0D, 0x30,
  0x03, 0x0E, 0xFF, 0xF9, 0x08, 0x80, 0xD5, 0x00, 0x20, 0xCF, 0xFD, 0x0E, 0x05, 0x80, 0xE0, 0x00,
  0x60, 0xDF, 0xFA, 0x09, 0x01, 0x80, 0xE3, 0x08, 0x14, 0x9D, 0xFA, 0x82, 0xEB, 0x61, 0x80, 0xF0,
  0x00, 0x10, 0x38, 0x01, 0x50, 0x40, 0x28, 0x09, 0xA8, 0x50, 0x08, 0x80, 0x2D, 0x03, 0x80, 0xF5,
  0x00, 0xEE, 0x09, 0x80, 0xF4, 0x00, 0x5F, 0x0E, 0x80, 0xF4, 0x00, 0xBF, 0x90, 0x68, 0x0F, 0x20,
  0x02, 0xFA, 0x0B, 0x80, 0xF2, 0x00, 0x8F, 0xB0, 0x28, 0x0F, 0x10, 0x0D, 0xFB, 0x08, 0x80, 0xF0,
  0x00, 0x4D, 0x0E, 0xD0, 0xD8, 0x0F, 0x00, 0x0A, 0xD0, 0x70, 0xED, 0x04, 0x80, 0xE6, 0x00, 0x1E,
  0x01, 0x09, 0xD0, 0xA8, 0x0E, 0x60, 0x07, 0xD8, 0x1C, 0x04, 0xE0, 0x18, 0x0E, 0x50, 0x0D, 0xD0,
  0x72, 0x0E, 0xD0, 0x68, 0x0E, 0x40, 0x04, 0xE0, 0x22, 0x09, 0xD0, 0xC8, 0x0E, 0x40, 0x0A, 0xD0,
  0xC3, 0x04, 0xE0, 0x38, 0x0E, 0x20, 0x01, 0xE0, 0x74, 0x0E, 0xD0, 0x98, 0x0E, 0x20, 0x06, 0xE0,
  0x24, 0x09, 0xD0, 0xE8, 0x0E, 0x20, 0x0C, 0xD0, 0xC5, 0x04, 0xE0, 0x58, 0x0E, 0x00, 0x03, 0xE0,
  0x76, 0x0E, 0xD0, 0xB8, 0x0E, 0x00, 0x09, 0xE0, 0x26, 0x0A, 0xE0, 0x28, 0x0D, 0x70, 0x0E, 0xD0,
  0xC7, 0x05, 0xE0, 0x78, 0x0D, 0x60, 0x06, 0xE0, 0x77, 0x10, 0xED, 0x0D, 0x80, 0xD6, 0x00, 0xCE,
  0x01, 0x71, 0x09, 0xE0, 0x48, 0x0D, 0x40, 0x02, 0xE0, 0xA7, 0x20, 0x3E, 0x0A, 0x80, 0xD4, 0x00,
  0x8E, 0x04, 0x73, 0x0D, 0xE0, 0x18, 0x0D, 0x30, 0x0E, 0xD0, 0xD7, 0x40, 0x7E, 0x06, 0x80, 0xD2,
  0x00, 0x5E, 0x08, 0x74, 0x02, 0xE0, 0xC8, 0x0D, 0x20, 0x0B, 0xE0, 0x27, 0x50, 0xBE, 0x02, 0x80,
  0xD0, 0x00, 0x2E, 0x0B, 0x76, 0x05, 0xE0, 0x88, 0x0D, 0x00, 0x08, 0xE0, 0x57, 0x70, 0xED, 0x0E,
  0x80, 0xD0, 0x00, 0xDD, 0x0E, 0x77, 0x10, 0x9E, 0x05, 0x80, 0xC6, 0x00, 0x4E, 0x09, 0x77, 0x10,
  0x4E, 0x0B, 0x80, 0xC6, 0x00, 0xAE, 0x03, 0x77, 0x20, 0xDE, 0x01, 0x80, 0xC4, 0x00, 0x1E, 0x0C,
  0x77, 0x30, 0x8E, 0x07, 0x80, 0xC4, 0x00, 0x7E, 0x06, 0x77, 0x30, 0x2E, 0x0D, 0x80, 0xC4, 0x00,
  0xDE, 0x01, 0x77, 0x40, 0xCE, 0x03, 0x80, 0xC2, 0x00, 0x3E, 0x0A, 0x77, 0x50, 0x6E, 0x09, 0x80,
  0xC2, 0x00, 0xAE, 0x04, 0x77, 0x50, 0x1E, 0x0E, 0x80, 0xC1, 0x00, 0x1E, 0x0D, 0x77, 0x70, 0xAE,
  0x06, 0x80, 0xC0, 0x00, 0x6E, 0x08, 0x77, 0x70, 0x4E, 0x0C, 0x80, 0xC0, 0x00, 0xCE, 0x02, 0x77,
  0x71, 0x0D, 0xE0, 0x27, 0x77, 0x76, 0x03, 0xE0, 0xB7, 0x77, 0x20, 0x8E, 0x08, 0x77, 0x77, 0x60,
  0x9E, 0x05, 0x77, 0x72, 0x02, 0xE0, 0xE7, 0x77, 0x76, 0x0E, 0xD0, 0xE7, 0x77, 0x40, 0xCE, 0x04,
  0x77, 0x77, 0x40, 0x5E, 0x09, 0x77, 0x74, 0x06, 0xE0, 0xA7, 0x77, 0x74, 0x0B, 0xE0, 0x37, 0x77,
  0x40, 0x1F, 0x01, 0x77, 0x77, 0x20, 0x2E, 0x0C, 0x77, 0x76, 0x0A, 0xE0, 0x77, 0x77, 0x72, 0x08,
  0xE0, 0x67, 0x77, 0x60, 0x4E, 0x0D, 0x77, 0x77, 0x20, 0xEE, 0x01, 0x77, 0x77, 0x0E, 0xE0, 0x37,
  0x77, 0x70, 0x5E, 0x0A, 0x77, 0x77, 0x10, 0x8E, 0x09, 0x77, 0x77, 0x0B, 0xE0, 0x47, 0x77, 0x71,
  0x03, 0xE0, 0xE7, 0x77, 0x60, 0x1F, 0x80, 0xB3, 0xBF, 0x05, 0x77, 0x75, 0x07, 0x80, 0xD1, 0xF0,
  0xB7, 0x77, 0x50, 0xD8, 0x0D, 0x2F, 0x02, 0x77, 0x73, 0x04, 0x80, 0xD3, 0xF0, 0x87, 0x77, 0x30,
  0xA8, 0x0D, 0x3F, 0x0D, 0x77, 0x72, 0x01, 0x80, 0xD5, 0xF0, 0x47, 0x77, 0x10, 0x7E, 0x0C, 0x80,
  0xB7, 0x70, 0xCE, 0x0A, 0x77, 0x71, 0x0D, 0xE0, 0x47, 0x77, 0x77, 0x05, 0xF0, 0x17, 0x76, 0x03,
  0xE0, 0xE8, 0x0C, 0x10, 0x0E, 0xE0, 0x67, 0x76, 0x09, 0xE0, 0x88, 0x0C, 0x10, 0x09, 0xE0, 0xC7,
  0x75, 0x01, 0x0E, 0xE0, 0x28, 0x0C, 0x10, 0x03, 0xF0, 0x37, 0x74, 0x06, 0xE0, 0xB8, 0x0C, 0x30,
  0x0C, 0xE0, 0x87, 0x74, 0x0C, 0xE0, 0x58, 0x0C, 0x30, 0x06, 0xE0, 0xE7, 0x73, 0x03, 0xE0, 0xE8,
  0x0C, 0x40, 0x01, 0xF0, 0x57, 0x72, 0x09, 0xE0, 0x88, 0x0C, 0x50, 0x0A, 0xE0, 0xB7, 0x72, 0x0E,
  0xE0, 0x28, 0x0C, 0x50, 0x04, 0xF0, 0x17, 0x70, 0x5E, 0x0B, 0x80, 0xC7, 0x00, 0xDE, 0x07, 0x77,
  0x0B, 0xE0, 0x58, 0x0C, 0x70, 0x07, 0xE0, 0xD7, 0x60, 0x2E, 0x0E, 0x80, 0xD0, 0x00, 0x1F, 0x03,
  0x75, 0x08, 0xE0, 0x98, 0x0D, 0x10, 0x0B, 0xE0, 0x97, 0x50, 0xEE, 0x02, 0x80, 0xD1, 0x00, 0x5E,
  0x0E, 0x74, 0x05, 0xE0, 0xC8, 0x0D, 0x30, 0x0E, 0xE0, 0x67, 0x30, 0xBE, 0x06, 0x80, 0xD3, 0x00,
  0x8E, 0x0C, 0x72, 0x01, 0xE0, 0xE8, 0x0D, 0x40, 0x02, 0xF0, 0x27, 0x10, 0x7E, 0x09, 0x80, 0xD5,
  0x00, 0xCE, 0x08, 0x71, 0x0D, 0xE0, 0x38, 0x0D, 0x50, 0x06, 0xE0, 0xE7, 0x04, 0xE0, 0xC8, 0x0D,
  0x60, 0x01, 0x0E, 0xE0, 0x46, 0x0A, 0xE0, 0x68, 0x0D, 0x70, 0x09, 0xE0, 0xA5, 0x01, 0xE0, 0xE0,
  0x18, 0x0D, 0x70, 0x03, 0xF0, 0x14, 0x07, 0xE0, 0x98, 0x0E, 0x10, 0x0D, 0xE0, 0x74, 0x0D, 0xE0,
  0x38, 0x0E, 0x10, 0x07, 0xE0, 0xD3, 0x03, 0xE0, 0xD8, 0x0E, 0x20, 0x01, 0xF0, 0x32, 0x09, 0xE0,
  0x78, 0x0E, 0x30, 0x0B, 0xE0, 0x92, 0x0E, 0xE0, 0x18, 0x0E, 0x30, 0x05, 0xE8, 0x1E, 0x06, 0xE0,
  0xA8, 0x0E, 0x50, 0x0E, 0xE0, 0x50, 0xCE, 0x04, 0x80, 0xE5, 0x00, 0x8E, 0x0B,
  // "ă" (U+0103)
  0x73, 0x84, 0x47, 0x77, 0x71, 0x77, 0x72, 0x80, 0x07, 0x05, 0x77, 0x20, 0x8C, 0x04, 0x77, 0x71,
  0x03, 0xC0, 0x97, 0x72, 0x06, 0xC0, 0x77, 0x77, 0x10, 0x6C, 0x06, 0x77, 0x20, 0x3C, 0x0B, 0x77,
  0x71, 0x0B, 0xC0, 0x37, 0x73, 0x0E, 0xC0, 0x27, 0x76, 0x02, 0xC0, 0xE7, 0x74, 0x0A, 0xC0, 0xB7,
  0x76, 0x0B, 0xC0, 0x97, 0x74, 0x04, 0xD0, 0x77, 0x74, 0x09, 0xD0, 0x37, 0x75, 0x0C, 0xD0, 0x97,
  0x71, 0x01, 0x0B, 0xD0, 0xB7, 0x76, 0x04, 0xE8, 0x1E, 0x82, 0x73, 0x03, 0x09, 0xF0, 0x27, 0x77,
  0x09, 0xF9, 0x89, 0x0E, 0xB9, 0x77, 0x78, 0x9C, 0xEF, 0x90, 0x67, 0x77, 0x20, 0xBF, 0xFF, 0xB0,
  0x97, 0x77, 0x40, 0xBF, 0xFF, 0x90, 0x87, 0x77, 0x60, 0x8F, 0xFD, 0x0E, 0x05, 0x77, 0x77, 0x10,
  0x20, 0xAF, 0xF9, 0x81, 0xE8, 0x17, 0x77, 0x74, 0x82, 0x16, 0xAD, 0xF9, 0x81, 0xD9, 0x58, 0x0C,
  0x40, 0x84, 0x23, 0x33, 0x32, 0x80, 0xE8, 0x10, 0x84, 0x13, 0x68, 0xAB, 0x80, 0x2D, 0x83, 0xBA,
  0x85, 0x27, 0x77, 0x71, 0x82, 0x15, 0x9D, 0xFF, 0xB8, 0x1D, 0x93, 0x77, 0x72, 0x81, 0x16, 0xBF,
  0xFF, 0xB0, 0xC0, 0x57, 0x75, 0x04, 0x0B, 0xFF, 0xFF, 0x90, 0xB0, 0x17, 0x71, 0x06, 0x0D, 0xFF,
  0xFF, 0xC0, 0xE0, 0x47, 0x60, 0xAF, 0xFB, 0x0E, 0x80, 0x0D, 0xFF, 0x05, 0x75, 0x05, 0xFC, 0x83,
  0xD9, 0x63, 0x17, 0x82, 0x24, 0x9D, 0xFB, 0x03, 0x75, 0x0E, 0xF8, 0x1A, 0x51, 0x77, 0x20, 0x40,
  0xCF, 0x90, 0xD7, 0x50, 0x9C, 0x81, 0xC6, 0x17, 0x77, 0x07, 0xF9, 0x08, 0x74, 0x03, 0xA0, 0xA0,
  0x37, 0x77, 0x40, 0x4F, 0x90, 0x17, 0x40, 0x80, 0x27, 0x77, 0x70, 0x6F, 0x08, 0x80, 0xC6, 0x00,
  0xAE, 0x0D, 0x80, 0xC6, 0x00, 0x2F, 0x03, 0x80, 0xC6, 0x00, 0xBE, 0x07, 0x80, 0xC6, 0x00, 0x5E,
  0x0B, 0x80, 0xC6, 0x00, 0x1E, 0x0E, 0x80, 0xC7, 0x00, 0xCE, 0x01, 0x80, 0xC6, 0x00, 0xAE, 0x03,
  0x80, 0xC6, 0x00, 0x7E, 0x05, 0x80, 0xC6, 0x00, 0x6E, 0x06, 0x80, 0xC6, 0x00, 0x5E, 0x06, 0x80,
  0xC6, 0x00, 0x4E, 0x07, 0x80, 0xC6, 0x00, 0x3E, 0x07, 0x80, 0xC6, 0x00, 0x3E, 0x07, 0x80, 0xC6,
  0x00, 0x3E, 0x07, 0x80, 0xC6, 0x00, 0x3E, 0x07, 0x80, 0xC6, 0x00, 0x3E, 0x07, 0x77, 0x77, 0x78,
  0x61, 0x12, 0x33, 0x55, 0x8E, 0x07, 0x77, 0x72, 0x89, 0x02, 0x46, 0x79, 0xAB, 0xCD, 0xDF, 0xFA,
  0x07, 0x77, 0x48, 0x23, 0x7A, 0xDF, 0xFF, 0xE0, 0x77, 0x78, 0x21, 0x6B, 0xEF, 0xFF, 0xFB, 0x07,
  0x75, 0x05, 0x0B, 0xFF, 0xFF, 0xF0, 0x77, 0x30, 0x60, 0xDF, 0xFF, 0xF8, 0x1E, 0xDD, 0xE0, 0x77,
  0x10, 0x30, 0xCF, 0xF9, 0x85, 0xDB, 0x98, 0x75, 0x50, 0xF3, 0x0F, 0x14, 0x03, 0xE0, 0x77, 0x08,
  0xFD, 0x82, 0xC8, 0x52, 0x77, 0x40, 0x3E, 0x07, 0x60, 0xBF, 0xB8, 0x1A, 0x51, 0x77, 0x71, 0x03,
  0xE0, 0x74, 0x01, 0x0C, 0xF9, 0x81, 0xE8, 0x17, 0x77, 0x40, 0x3E, 0x07, 0x40, 0xBF, 0x90, 0x90,
  0x17, 0x77, 0x60, 0x3E, 0x07, 0x30, 0x7F, 0x0E, 0x04, 0x77, 0x77, 0x10, 0x3E, 0x07, 0x20, 0x2F,
  0x0E, 0x03, 0x77, 0x77, 0x20, 0x4E, 0x07, 0x20, 0xAF, 0x04, 0x77, 0x77, 0x30, 0x5E, 0x81, 0x70,
  0x2F, 0x08, 0x77, 0x77, 0x40, 0x6E, 0x81, 0x70, 0x7E, 0x0E, 0x77, 0x77, 0x50, 0x8E, 0x81, 0x70,
  0xBE, 0x08, 0x77, 0x77, 0x50, 0xAE, 0x07, 0x1F, 0x03, 0x77, 0x77, 0x50, 0xDE, 0x07, 0x02, 0xF7,
  0x77, 0x75, 0x01, 0xF0, 0x70, 0x4E, 0x0D, 0x77, 0x77, 0x50, 0x5F, 0x07, 0x04, 0xE0, 0xB7, 0x77,
  0x75, 0x09, 0xF0, 0x70, 0x5E, 0x0B, 0x77, 0x77, 0x50, 0xEF, 0x07, 0x04, 0xE0, 0xB7, 0x77, 0x74,
  0x06, 0xF9, 0x07, 0x04, 0xE0, 0xD7, 0x77, 0x74, 0x0D, 0xF9, 0x07, 0x02, 0xF7, 0x77, 0x73, 0x06,
  0xFA, 0x07, 0x1F, 0x04, 0x77, 0x77, 0x10, 0x20, 0xEF, 0xA8, 0x17, 0x0C, 0xE0, 0x97, 0x77, 0x71,
  0x0C, 0xFB, 0x81, 0x70, 0x8F, 0x01, 0x77, 0x76, 0x0A, 0xC0, 0x90, 0xED, 0x81, 0x70, 0x3F, 0x0A,
  0x77, 0x75, 0x0A, 0xC8, 0x1C, 0x0D, 0xD0, 0x72, 0x0C, 0xF0, 0x87, 0x77, 0x20, 0x10, 0xCD, 0x81,
  0x20, 0xBD, 0x07, 0x20, 0x5F, 0x90, 0x97, 0x77, 0x06, 0x0E, 0xD0, 0x52, 0x09, 0xD0, 0x73, 0x0B,
  0xF9, 0x0D, 0x04, 0x77, 0x30, 0x60, 0xDE, 0x07, 0x30, 0x7D, 0x07, 0x30, 0x10, 0xEF, 0xA8, 0x1C,
  0x72, 0x73, 0x82, 0x25, 0xAE, 0xF0, 0x84, 0x05, 0xD0, 0x74, 0x03, 0x0E, 0xFC, 0x89, 0x0E, 0xCA,
  0x99, 0x99, 0xAC, 0xEF, 0xB0, 0x65, 0x03, 0xD0, 0x75, 0x03, 0x0E, 0xFF, 0xFF, 0x0E, 0x05, 0x60,
  0x1D, 0x07, 0x60, 0x10, 0xCF, 0xFF, 0xD0, 0xC0, 0x17, 0x1D, 0x07, 0x71, 0x06, 0x0E, 0xFF, 0xF9,
  0x0D, 0x06, 0x73, 0x0D, 0xC0, 0x77, 0x30, 0x60, 0xCF, 0xFC, 0x0B, 0x05, 0x75, 0x0B, 0xC0, 0x77,
  0x58, 0x31, 0x69, 0xCE, 0xF9, 0x83, 0xDB, 0x85, 0x18, 0x0C, 0x20, 0x84, 0x12, 0x32, 0x11, 0x77,
  0x75,
  // "Ą" (U+0104)
  0x77, 0x77, 0x50, 0x88, 0x02, 0xD0, 0x38, 0x0F, 0x50, 0x0E, 0xE0, 0x98, 0x0F, 0x40, 0x05, 0xF0,
  0xE8, 0x0F, 0x40, 0x0B, 0xF9, 0x06, 0x80, 0xF2, 0x00, 0x2F, 0xA0, 0xB8, 0x0F, 0x20, 0x08, 0xFB,
  0x02, 0x80, 0xF1, 0x00, 0xDF, 0xB0, 0x88, 0x0F, 0x00, 0x04, 0xD0, 0xED, 0x0D, 0x80, 0xF0, 0x00,
  0xAD, 0x07, 0x0E, 0xD0, 0x48, 0x0E, 0x60, 0x01, 0xE0, 0x10, 0x9D, 0x0A, 0x80, 0xE6, 0x00, 0x7D,
  0x81, 0xC0, 0x4E, 0x01, 0x80, 0xE5, 0x00, 0xDD, 0x07, 0x20, 0xED, 0x06, 0x80, 0xE4, 0x00, 0x4E,
  0x02, 0x20, 0x9D, 0x0C, 0x80, 0xE4, 0x00, 0xAD, 0x0C, 0x30, 0x4E, 0x03, 0x80, 0xE2, 0x00, 0x1E,
  0x07, 0x40, 0xED, 0x09, 0x80, 0xE2, 0x00, 0x6E, 0x02, 0x40, 0x9D, 0x0E, 0x80, 0xE2, 0x00, 0xCD,
  0x0C, 0x50, 0x4E, 0x05, 0x80, 0xE0, 0x00, 0x3E, 0x07, 0x60, 0xED, 0x0B, 0x80, 0xE0, 0x00, 0x9E,
  0x02, 0x60, 0xAE, 0x02, 0x80, 0xD7, 0x00, 0xED, 0x0C, 0x70, 0x5E, 0x07, 0x80, 0xD6, 0x00, 0x6E,
  0x07, 0x71, 0x0E, 0xD0, 0xD8, 0x0D, 0x60, 0x0C, 0xE0, 0x17, 0x10, 0x9E, 0x04, 0x80, 0xD4, 0x00,
  0x2E, 0x0A, 0x72, 0x03, 0xE0, 0xA8, 0x0D, 0x40, 0x08, 0xE0, 0x47, 0x30, 0xDE, 0x01, 0x80, 0xD3,
  0x00, 0xED, 0x0D, 0x74, 0x07, 0xE0, 0x68, 0x0D, 0x20, 0x05, 0xE0, 0x87, 0x40, 0x2E, 0x0C, 0x80,
  0xD2, 0x00, 0xBE, 0x02, 0x75, 0x0B, 0xE0, 0x28, 0x0D, 0x00, 0x02, 0xE0, 0xB7, 0x60, 0x5E, 0x08,
  0x80, 0xD0, 0x00, 0x8E, 0x05, 0x77, 0x0E, 0xD0, 0xE8, 0x0D, 0x00, 0x0D, 0xD0, 0xE7, 0x71, 0x09,
  0xE0, 0x58, 0x0C, 0x60, 0x04, 0xE0, 0x97, 0x71, 0x04, 0xE0, 0xB8, 0x0C, 0x60, 0x0A, 0xE0, 0x37,
  0x72, 0x0D, 0xE0, 0x18, 0x0C, 0x40, 0x01, 0xE0, 0xC7, 0x73, 0x08, 0xE0, 0x78, 0x0C, 0x40, 0x07,
  0xE0, 0x67, 0x73, 0x02, 0xE0, 0xD8, 0x0C, 0x40, 0x0D, 0xE0, 0x17, 0x74, 0x0C, 0xE0, 0x38, 0x0C,
  0x20, 0x03, 0xE0, 0xA7, 0x75, 0x06, 0xE0, 0x98, 0x0C, 0x20, 0x0A, 0xE0, 0x47, 0x75, 0x01, 0xE0,
  0xE8, 0x0C, 0x10, 0x01, 0xE0, 0xD7, 0x77, 0x0A, 0xE0, 0x68, 0x0C, 0x00, 0x06, 0xE0, 0x87, 0x77,
  0x04, 0xE0, 0xC8, 0x0C, 0x00, 0x0C, 0xE0, 0x27, 0x77, 0x10, 0xDE, 0x02, 0x77, 0x77, 0x60, 0x3E,
  0x0B, 0x77, 0x72, 0x08, 0xE0, 0x87, 0x77, 0x76, 0x09, 0xE0, 0x57, 0x77, 0x20, 0x2E, 0x0E, 0x77,
  0x77, 0x60, 0xED, 0x0E, 0x77, 0x74, 0x0C, 0xE0, 0x47, 0x77, 0x74, 0x05, 0xE0, 0x97, 0x77, 0x40,
  0x6E, 0x0A, 0x77, 0x77, 0x40, 0xBE, 0x03, 0x77, 0x74, 0x01, 0xF0, 0x17, 0x77, 0x72, 0x02, 0xE0,
  0xC7, 0x77, 0x60, 0xAE, 0x07, 0x77, 0x77, 0x20, 0x8E, 0x06, 0x77, 0x76, 0x04, 0xE0, 0xD7, 0x77,
  0x72, 0x0E, 0xE0, 0x17, 0x77, 0x70, 0xEE, 0x03, 0x77, 0x77, 0x05, 0xE0, 0xA7, 0x77, 0x71, 0x08,
  0xE0, 0x97, 0x77, 0x70, 0xBE, 0x04, 0x77, 0x77, 0x10, 0x3E, 0x0E, 0x77, 0x76, 0x01, 0xF8, 0x0B,
  0x3B, 0xF0, 0x57, 0x77, 0x50, 0x78, 0x0D, 0x1F, 0x0B, 0x77, 0x75, 0x0D, 0x80, 0xD2, 0xF0, 0x27,
  0x77, 0x30, 0x48, 0x0D, 0x3F, 0x08, 0x77, 0x73, 0x0A, 0x80, 0xD3, 0xF0, 0xD7, 0x77, 0x20, 0x18,
  0x0D, 0x5F, 0x04, 0x77, 0x71, 0x07, 0xE0, 0xC8, 0x0B, 0x77, 0x0C, 0xE0, 0xA7, 0x77, 0x10, 0xDE,
  0x04, 0x77, 0x77, 0x70, 0x5F, 0x01, 0x77, 0x60, 0x3E, 0x0E, 0x80, 0xC1, 0x00, 0xEE, 0x06, 0x77,
  0x60, 0x9E, 0x08, 0x80, 0xC1, 0x00, 0x9E, 0x0C, 0x77, 0x50, 0x10, 0xEE, 0x02, 0x80, 0xC1, 0x00,
  0x3F, 0x03, 0x77, 0x40, 0x6E, 0x0B, 0x80, 0xC3, 0x00, 0xCE, 0x08, 0x77, 0x40, 0xCE, 0x05, 0x80,
  0xC3, 0x00, 0x6E, 0x0E, 0x77, 0x30, 0x3E, 0x0E, 0x80, 0xC4, 0x00, 0x1F, 0x05, 0x77, 0x20, 0x9E,
  0x08, 0x80, 0xC5, 0x00, 0xAE, 0x0B, 0x77, 0x20, 0xEE, 0x02, 0x80, 0xC5, 0x00, 0x4F, 0x01, 0x77,
  0x05, 0xE0, 0xB8, 0x0C, 0x70, 0x0D, 0xE0, 0x77, 0x70, 0xBE, 0x05, 0x80, 0xC7, 0x00, 0x7E, 0x0D,
  0x76, 0x02, 0xE0, 0xE8, 0x0D, 0x00, 0x01, 0xF0, 0x37, 0x50, 0x8E, 0x09, 0x80, 0xD1, 0x00, 0xBE,
  0x09, 0x75, 0x0E, 0xE0, 0x28, 0x0D, 0x10, 0x05, 0xE0, 0xE7, 0x40, 0x5E, 0x0C, 0x80, 0xD3, 0x00,
  0xEE, 0x06, 0x73, 0x0B, 0xE0, 0x68, 0x0D, 0x30, 0x08, 0xE0, 0xC7, 0x20, 0x1E, 0x0E, 0x80, 0xD4,
  0x00, 0x2F, 0x02, 0x71, 0x07, 0xE0, 0x98, 0x0D, 0x50, 0x0C, 0xE0, 0x87, 0x10, 0xDE, 0x03, 0x80,
  0xD5, 0x00, 0x6E, 0x0E, 0x70, 0x4E, 0x0C, 0x80, 0xD6, 0x00, 0x10, 0xEE, 0x04, 0x60, 0xAE, 0x06,
  0x80, 0xD7, 0x00, 0x9E, 0x0A, 0x50, 0x1E, 0x0E, 0x01, 0x80, 0xD7, 0x00, 0x3F, 0x01, 0x40, 0x7E,
  0x09, 0x80, 0xE1, 0x00, 0xDE, 0x07, 0x40, 0xDE, 0x03, 0x80, 0xE1, 0x00, 0x7E, 0x0D, 0x30, 0x3E,
  0x0D, 0x80, 0xE2, 0x00, 0x1F, 0x03, 0x20, 0x9E, 0x07, 0x80, 0xE3, 0x00, 0xBE, 0x09, 0x20, 0xEE,
  0x01, 0x80, 0xE3, 0x00, 0x5E, 0x81, 0xE0, 0x6E, 0x0A, 0x80, 0xE5, 0x00, 0xEE, 0x05, 0x0C, 0xE0,
  0x48, 0x0E, 0x40, 0x01, 0x0D, 0xE0, 0xB8, 0x0F, 0x30, 0x03, 0x0E, 0xC0, 0xC0, 0x18, 0x0F, 0x40,
  0x04, 0x0E, 0xC0, 0xB8, 0x0F, 0x50, 0x04, 0xD0, 0xB8, 0x0F, 0x50, 0x03, 0x0E, 0xC0, 0xB8, 0x0F,
  0x50, 0x02, 0x0E, 0xC0, 0xC8, 0x0F, 0x50, 0x01, 0x0D, 0xC0, 0xD0, 0x18, 0x0F, 0x50, 0x0B, 0xC0,
  0xE0, 0x38, 0x0F, 0x50, 0x06, 0xD0, 0x68, 0x0F, 0x50, 0x01, 0x0E, 0xC0, 0xB8, 0x0F, 0x60, 0x08,
  0xD0, 0x28, 0x0F, 0x60, 0x0E, 0xC0, 0xB8, 0x0F, 0x60, 0x05, 0xD0, 0x58, 0x0F, 0x60, 0x09, 0xD0,
  0x18, 0x0F, 0x60, 0x0D, 0xC0, 0xE8, 0x0F, 0x70, 0x0E, 0xC0, 0xD8, 0x0F, 0x70, 0xD0, 0xD8, 0x0F,
  0x70, 0xD0, 0xE8, 0x0F, 0x70, 0x0E, 0xD0, 0x38, 0x0F, 0x60, 0x0C, 0xD0, 0x98, 0x0F, 0x60, 0x08,
  0xE0, 0x58, 0x0F, 0x50, 0x03, 0xF0, 0x90, 0x35, 0x81, 0x25, 0x58, 0x0E, 0x40, 0x0B, 0xFA, 0x81,
  0xDD, 0xEB, 0x0B, 0x80, 0xE4, 0x00, 0x20, 0xEF, 0xF0, 0xB8, 0x0E, 0x50, 0x03, 0x0E, 0xFE, 0x0B,
  0x80, 0xE6, 0x00, 0x10, 0xAF, 0xD0, 0xB8, 0x0F, 0x00, 0x81, 0x28, 0xCE, 0x82, 0xDB, 0x73, 0x80,
  0xF4, 0x08, 0x00, 0x15,
  // "ą" (U+0105)
  0x77, 0x58, 0x41, 0x36, 0x8A, 0xB8, 0x02, 0xD8, 0x3B, 0xA8, 0x52, 0x77, 0x77, 0x48, 0x21, 0x59,
  0xDF, 0xFB, 0x81, 0xD9, 0x37, 0x77, 0x58, 0x11, 0x6B, 0xFF, 0xFB, 0x0C, 0x05, 0x77, 0x71, 0x04,
  0x0B, 0xFF, 0xFF, 0x90, 0xB0, 0x17, 0x74, 0x06, 0x0D, 0xFF, 0xFF, 0xC0, 0xE0, 0x47, 0x72, 0x0A,
  0xFF, 0xB0, 0xE8, 0x00, 0xDF, 0xF0, 0x57, 0x71, 0x05, 0xFC, 0x83, 0xD9, 0x63, 0x17, 0x82, 0x24,
  0x9D, 0xFB, 0x03, 0x77, 0x10, 0xEF, 0x81, 0xA5, 0x17, 0x72, 0x04, 0x0C, 0xF9, 0x0D, 0x77, 0x10,
  0x9C, 0x81, 0xC6, 0x17, 0x77, 0x07, 0xF9, 0x08, 0x77, 0x03, 0xA0, 0xA0, 0x37, 0x77, 0x40, 0x4F,
  0x90, 0x17, 0x70, 0x80, 0x27, 0x77, 0x70, 0x6F, 0x08, 0x80, 0xD1, 0x00, 0xAE, 0x0D, 0x80, 0xD1,
  0x00, 0x2F, 0x03, 0x80, 0xD1, 0x00, 0xBE, 0x07, 0x80, 0xD1, 0x00, 0x5E, 0x0B, 0x80, 0xD1, 0x00,
  0x1E, 0x0E, 0x80, 0xD2, 0x00, 0xCE, 0x01, 0x80, 0xD1, 0x00, 0xAE, 0x03, 0x80, 0xD1, 0x00, 0x7E,
  0x05, 0x80, 0xD1, 0x00, 0x6E, 0x06, 0x80, 0xD1, 0x00, 0x5E, 0x06, 0x80, 0xD1, 0x00, 0x4E, 0x07,
  0x80, 0xD1, 0x00, 0x3E, 0x07, 0x80, 0xD1, 0x00, 0x3E, 0x07, 0x80, 0xD1, 0x00, 0x3E, 0x07, 0x80,
  0xD1, 0x00, 0x3E, 0x07, 0x80, 0xD1, 0x00, 0x3E, 0x07, 0x80, 0xC2, 0x08, 0x61, 0x12, 0x33, 0x55,
  0x8E, 0x07, 0x77, 0x75, 0x89, 0x02, 0x46, 0x79, 0xAB, 0xCD, 0xDF, 0xFA, 0x07, 0x77, 0x78, 0x23,
  0x7A, 0xDF, 0xFF, 0xE0, 0x77, 0x73, 0x82, 0x16, 0xBE, 0xFF, 0xFF, 0xB0, 0x77, 0x71, 0x05, 0x0B,
  0xFF, 0xFF, 0xF0, 0x77, 0x60, 0x60, 0xDF, 0xFF, 0xF8, 0x1E, 0xDD, 0xE0, 0x77, 0x40, 0x30, 0xCF,
  0xF9, 0x85, 0xDB, 0x98, 0x75, 0x50, 0xF3, 0x0F, 0x14, 0x03, 0xE0, 0x77, 0x30, 0x8F, 0xD8, 0x2C,
  0x85, 0x27, 0x74, 0x03, 0xE0, 0x77, 0x20, 0xBF, 0xB8, 0x1A, 0x51, 0x77, 0x71, 0x03, 0xE0, 0x77,
  0x01, 0x0C, 0xF9, 0x81, 0xE8, 0x17, 0x77, 0x40, 0x3E, 0x07, 0x70, 0xBF, 0x90, 0x90, 0x17, 0x77,
  0x60, 0x3E, 0x07, 0x60, 0x7F, 0x0E, 0x04, 0x77, 0x77, 0x10, 0x3E, 0x07, 0x50, 0x2F, 0x0E, 0x03,
  0x77, 0x77, 0x20, 0x4E, 0x07, 0x50, 0xAF, 0x04, 0x77, 0x77, 0x30, 0x5E, 0x07, 0x40, 0x2F, 0x08,
  0x77, 0x77, 0x40, 0x6E, 0x07, 0x40, 0x7E, 0x0E, 0x77, 0x77, 0x50, 0x8E, 0x07, 0x40, 0xBE, 0x08,
  0x77, 0x77, 0x50, 0xAE, 0x07, 0x4F, 0x03, 0x77, 0x77, 0x50, 0xDE, 0x07, 0x30, 0x2F, 0x77, 0x77,
  0x50, 0x1F, 0x07, 0x30, 0x4E, 0x0D, 0x77, 0x77, 0x50, 0x5F, 0x07, 0x30, 0x4E, 0x0B, 0x77, 0x77,
  0x50, 0x9F, 0x07, 0x30, 0x5E, 0x0B, 0x77, 0x77, 0x50, 0xEF, 0x07, 0x30, 0x4E, 0x0B, 0x77, 0x77,
  0x40, 0x6F, 0x90, 0x73, 0x04, 0xE0, 0xD7, 0x77, 0x74, 0x0D, 0xF9, 0x07, 0x30, 0x2F, 0x77, 0x77,
  0x30, 0x6F, 0xA0, 0x74, 0xF0, 0x47, 0x77, 0x71, 0x02, 0x0E, 0xFA, 0x07, 0x40, 0xCE, 0x09, 0x77,
  0x77, 0x10, 0xCF, 0xB0, 0x74, 0x08, 0xF0, 0x17, 0x77, 0x60, 0xAC, 0x09, 0x0E, 0xD0, 0x74, 0x03,
  0xF0, 0xA7, 0x77, 0x50, 0xAC, 0x81, 0xC0, 0xDD, 0x07, 0x50, 0xCF, 0x08, 0x77, 0x72, 0x01, 0x0C,
  0xD8, 0x12, 0x0B, 0xD0, 0x75, 0x05, 0xF9, 0x09, 0x77, 0x70, 0x60, 0xED, 0x05, 0x20, 0x9D, 0x07,
  0x60, 0xBF, 0x90, 0xD0, 0x47, 0x73, 0x06, 0x0D, 0xE0, 0x73, 0x07, 0xD0, 0x76, 0x01, 0x0E, 0xFA,
  0x81, 0xC7, 0x27, 0x38, 0x22, 0x5A, 0xEF, 0x08, 0x40, 0x5D, 0x07, 0x70, 0x30, 0xEF, 0xC8, 0x90,
  0xEC, 0xA9, 0x99, 0x9A, 0xCE, 0xFB, 0x06, 0x50, 0x3D, 0x07, 0x71, 0x03, 0x0E, 0xFF, 0xFF, 0x0E,
  0x05, 0x60, 0x1D, 0x07, 0x72, 0x01, 0x0C, 0xFF, 0xFD, 0x0C, 0x01, 0x71, 0xD0, 0x77, 0x40, 0x60,
  0xEF, 0xFF, 0x90, 0xD0, 0x67, 0x30, 0xDC, 0x07, 0x76, 0x06, 0x0C, 0xFF, 0xC0, 0xB0, 0x57, 0x50,
  0xCC, 0x07, 0x77, 0x18, 0x31, 0x69, 0xCE, 0xF9, 0x83, 0xDB, 0x85, 0x17, 0x60, 0xAD, 0x05, 0x77,
  0x78, 0x41, 0x23, 0x21, 0x17, 0x74, 0x0B, 0xC0, 0xE0, 0x48, 0x0D, 0x10, 0x0C, 0xC0, 0xE0, 0x38,
  0x0D, 0x10, 0x0B, 0xC0, 0xE0, 0x38, 0x0D, 0x10, 0x0B, 0xD0, 0x48, 0x0D, 0x10, 0x08, 0xD0, 0x58,
  0x0D, 0x10, 0x05, 0xD0, 0x88, 0x0D, 0x10, 0x01, 0x0E, 0xC0, 0xC8, 0x0D, 0x20, 0x09, 0xD0, 0x28,
  0x0D, 0x10, 0x02, 0xD0, 0x98, 0x0D, 0x20, 0x09, 0xD0, 0x28, 0x0D, 0x20, 0x0E, 0xC0, 0xC8, 0x0D,
  0x20, 0x03, 0xD0, 0x88, 0x0D, 0x20, 0x06, 0xD0, 0x58, 0x0D, 0x20, 0x08, 0xD0, 0x48, 0x0D, 0x20,
  0x09, 0xD0, 0x48, 0x0D, 0x20, 0x09, 0xD0, 0x68, 0x0D, 0x20, 0x08, 0xD0, 0x98, 0x0D, 0x20, 0x05,
  0xD0, 0xE0, 0x18, 0x0D, 0x10, 0x02, 0xE0, 0xB8, 0x0D, 0x20, 0x0C, 0xE8, 0x1D, 0x51, 0x48, 0x21,
  0x47, 0x17, 0x77, 0x77, 0x05, 0xFA, 0x81, 0xED, 0xDC, 0x01, 0x80, 0xC0, 0x00, 0xAF, 0xF9, 0x01,
  0x80, 0xC1, 0x00, 0xBF, 0xF0, 0x18, 0x0C, 0x20, 0x07, 0x0E, 0xFD, 0x01, 0x80, 0xC4, 0x08, 0x16,
  0xAE, 0xD8, 0x2E, 0xC9, 0x58, 0x0D, 0x10, 0x80, 0x01, 0x50,
  // "Ć" (U+0106)
  0x80, 0xD2, 0x00, 0x18, 0x04, 0xB0, 0x38, 0x0E, 0x20, 0x0A, 0xF0, 0xE0, 0x18, 0x0E, 0x10, 0x04,
  0xF9, 0x04, 0x80, 0xE1, 0x00, 0x10, 0xDF, 0x08, 0x80, 0xE2, 0x00, 0xAF, 0x0B, 0x80, 0xE2, 0x00,
  0x5F, 0x0C, 0x80, 0xE2, 0x00, 0x20, 0xEE, 0x0E, 0x01, 0x80, 0xE2, 0x00, 0xCE, 0x0E, 0x03, 0x80,
  0xE2, 0x00, 0x9F, 0x04, 0x80, 0xE2, 0x00, 0x5F, 0x05, 0x80, 0xE2, 0x00, 0x3F, 0x06, 0x80, 0xE2,
  0x00, 0x10, 0xDE, 0x06, 0x80, 0xE3, 0x00, 0xBE, 0x06, 0x80, 0xE3, 0x00, 0x9E, 0x07, 0x80, 0xE3,
  0x00, 0x7E, 0x06, 0x80, 0xE3, 0x00, 0x5E, 0x06, 0x80, 0xE3, 0x00, 0x3E, 0x05, 0x80, 0xE3, 0x00,
  0x20, 0xEC, 0x0E, 0x03, 0x80, 0xE4, 0x00, 0xDC, 0x0D, 0x02, 0x80, 0xE5, 0x08, 0x01, 0x50, 0x18,
  0x0F, 0xE5, 0x08, 0x51, 0x46, 0x89, 0xBB, 0x80, 0x1D, 0x85, 0xBB, 0x99, 0x75, 0x38, 0x0C, 0x50,
  0x82, 0x27, 0xAE, 0xFF, 0xE8, 0x2C, 0xA6, 0x27, 0x77, 0x75, 0x81, 0x38, 0xDF, 0xFF, 0xF8, 0x1D,
  0x94, 0x77, 0x77, 0x06, 0x0C, 0xFF, 0xFF, 0xE8, 0x1E, 0x93, 0x77, 0x72, 0x06, 0x0E, 0x80, 0xC3,
  0xF0, 0xB0, 0x47, 0x75, 0x05, 0x0D, 0x80, 0xC6, 0xF0, 0xC7, 0x73, 0x01, 0x0A, 0xFF, 0x98, 0x3E,
  0xCA, 0x87, 0x80, 0x15, 0x83, 0x78, 0x9B, 0xEF, 0xF0, 0x47, 0x72, 0x04, 0x0E, 0xFD, 0x82, 0xD9,
  0x52, 0x77, 0x18, 0x31, 0x47, 0xBE, 0xF9, 0x0D, 0x77, 0x20, 0x8F, 0xC8, 0x1E, 0x93, 0x77, 0x73,
  0x81, 0x49, 0xED, 0x06, 0x77, 0x10, 0xAF, 0xB0, 0xD0, 0x67, 0x77, 0x72, 0x04, 0x0A, 0xA0, 0xE7,
  0x71, 0x0B, 0xFA, 0x0E, 0x07, 0x77, 0x77, 0x68, 0x11, 0x86, 0x77, 0x0B, 0xFA, 0x0A, 0x01, 0x80,
  0xD7, 0x00, 0xBF, 0x90, 0xE0, 0x58, 0x0E, 0x00, 0x09, 0xF9, 0x0D, 0x03, 0x80, 0xE0, 0x00, 0x7F,
  0x90, 0xC0, 0x18, 0x0E, 0x00, 0x03, 0xF9, 0x0C, 0x01, 0x80, 0xE1, 0x00, 0xDF, 0x0D, 0x01, 0x80,
  0xE1, 0x00, 0x8F, 0x0E, 0x02, 0x80, 0xE1, 0x00, 0x2F, 0x90, 0x48, 0x0E, 0x20, 0x0B, 0xF0, 0x98,
  0x0E, 0x20, 0x04, 0xF0, 0xD8, 0x0E, 0x30, 0x0C, 0xF0, 0x48, 0x0E, 0x20, 0x03, 0xF0, 0xB8, 0x0E,
  0x30, 0x0A, 0xF0, 0x38, 0x0E, 0x20, 0x01, 0xF0, 0xA8, 0x0E, 0x30, 0x07, 0xF0, 0x48, 0x0E, 0x30,
  0x0D, 0xE0, 0xC8, 0x0E, 0x30, 0x02, 0xF0, 0x78, 0x0E, 0x30, 0x07, 0xF0, 0x18, 0x0E, 0x30, 0x0B,
  0xE0, 0xC8, 0x0E, 0x40, 0xF0, 0x78, 0x0E, 0x30, 0x03, 0xF0, 0x38, 0x0E, 0x30, 0x07, 0xF8, 0x0E,
  0x40, 0x09, 0xE0, 0xB8, 0x0E, 0x40, 0x0C, 0xE0, 0x98, 0x0E, 0x40, 0x0E, 0xE0, 0x68, 0x0E, 0x30,
  0x01, 0xF0, 0x48, 0x0E, 0x30, 0x03, 0xF0, 0x28, 0x0E, 0x30, 0x04, 0xF8, 0x0E, 0x40, 0x06, 0xE0,
  0xE8, 0x0E, 0x40, 0x07, 0xE0, 0xD8, 0x0E, 0x40, 0x07, 0xE0, 0xC8, 0x0E, 0x40, 0x08, 0xE0, 0xC8,
  0x0E, 0x40, 0x08, 0xE0, 0xC8, 0x0E, 0x40, 0x08, 0xE0, 0xB8, 0x0E, 0x40, 0x08, 0xE0, 0xC8, 0x0E,
  0x40, 0x07, 0xE0, 0xC8, 0x0E, 0x40, 0x07, 0xE0, 0xD8, 0x0E, 0x40, 0x06, 0xE0, 0xE8, 0x0E, 0x40,
  0x05, 0xF8, 0x0E, 0x40, 0x04, 0xF0, 0x18, 0x0E, 0x30, 0x02, 0xF0, 0x38, 0x0E, 0x40, 0xF0, 0x48,
  0x0E, 0x40, 0x0E, 0xE0, 0x78, 0x0E, 0x40, 0x0B, 0xE0, 0x98, 0x0E, 0x40, 0x09, 0xE0, 0xC8, 0x0E,
  0x40, 0x06, 0xF8, 0x0E, 0x40, 0x03, 0xF0, 0x38, 0x0E, 0x40, 0xF0, 0x88, 0x0E, 0x40, 0x0C, 0xE0,
  0xC8, 0x0E, 0x40, 0x07, 0xF0, 0x18, 0x0E, 0x30, 0x03, 0xF0, 0x68, 0x0E, 0x40, 0x0E, 0xE0, 0xC8,
  0x0E, 0x40, 0x09, 0xF0, 0x38, 0x0E, 0x30, 0x04, 0xF0, 0x98, 0x0E, 0x40, 0x0D, 0xF0, 0x18, 0x0E,
  0x30, 0x07, 0xF0, 0x98, 0x0E, 0x30, 0x01, 0x0E, 0xF0, 0x28, 0x0E, 0x30, 0x08, 0xF0, 0xB8, 0x0E,
  0x30, 0x01, 0xF9, 0x05, 0x80, 0xE3, 0x00, 0x8F, 0x0E, 0x02, 0x80, 0xE3, 0x00, 0xDF, 0x0C, 0x80,
  0xE3, 0x00, 0x5F, 0x90, 0xB8, 0x0E, 0x30, 0x0A, 0xF9, 0x0A, 0x80, 0xE2, 0x00, 0x10, 0xDF, 0x90,
  0xA8, 0x0E, 0x20, 0x02, 0x0E, 0xF9, 0x0C, 0x01, 0x80, 0xE1, 0x00, 0x5F, 0xA0, 0xD0, 0x48, 0x0E,
  0x10, 0x06, 0xFB, 0x09, 0x01, 0x80, 0xE0, 0x00, 0x6F, 0xB0, 0xE0, 0x77, 0x77, 0x77, 0x01, 0x03,
  0x77, 0x10, 0x5F, 0xC8, 0x1E, 0x82, 0x77, 0x77, 0x18, 0x33, 0x7C, 0xF9, 0x77, 0x20, 0x30, 0xDF,
  0xD8, 0x1C, 0x73, 0x77, 0x78, 0x22, 0x58, 0xCD, 0x09, 0x77, 0x30, 0x10, 0xBF, 0xF8, 0xA3, 0xEB,
  0x86, 0x43, 0x11, 0x10, 0x11, 0x12, 0x34, 0x67, 0xAC, 0xEF, 0xA0, 0x97, 0x75, 0x06, 0x0E, 0x80,
  0xC6, 0xF0, 0x97, 0x76, 0x01, 0x09, 0x80, 0xC5, 0xF0, 0x97, 0x77, 0x10, 0x20, 0x98, 0x0C, 0x2F,
  0x0E, 0x06, 0x77, 0x73, 0x81, 0x17, 0xDF, 0xFF, 0xFC, 0x81, 0xE9, 0x57, 0x77, 0x71, 0x81, 0x27,
  0xBF, 0xFF, 0xC8, 0x2E, 0xA7, 0x38, 0x0C, 0x00, 0x84, 0x36, 0x9B, 0xDE, 0xFC, 0x85, 0xEC, 0xB9,
  0x64, 0x18, 0x0D, 0x30, 0x0F, 0x10, 0x30, 0x20, 0xF1, 0x77, 0x60,
  // "ć" (U+0107)
  0x80, 0xC0, 0x00, 0x48, 0x04, 0xD0, 0x18, 0x0C, 0x20, 0x0D, 0xF0, 0xB8, 0x0C, 0x20, 0x08, 0xF0,
  0xE0, 0x18, 0x0C, 0x10, 0x03, 0xF9, 0x04, 0x80, 0xC2, 0x00, 0xDF, 0x06, 0x80, 0xC2, 0x00, 0xAF,
  0x09, 0x80, 0xC2, 0x00, 0x5F, 0x0B, 0x80, 0xC2, 0x00, 0x20, 0xEE, 0x0C, 0x80, 0xC3, 0x00, 0xDE,
  0x0D, 0x01, 0x80, 0xC2, 0x00, 0xAE, 0x0D, 0x01, 0x80, 0xC2, 0x00, 0x7E, 0x0E, 0x02, 0x80, 0xC2,
  0x00, 0x4E, 0x0E, 0x02, 0x80, 0xC2, 0x00, 0x20, 0xED, 0x0E, 0x03, 0x80, 0xC2, 0x00, 0x10, 0xDD,
  0x0E, 0x03, 0x80, 0xC3, 0x00, 0xBD, 0x0E, 0x03, 0x80, 0xC3, 0x00, 0x9D, 0x0D, 0x02, 0x80, 0xC3,
  0x00, 0x7D, 0x0D, 0x01, 0x80, 0xC3, 0x00, 0x6D, 0x0B, 0x01, 0x80, 0xC3, 0x00, 0x1D, 0x09, 0x80,
  0xC6, 0x08, 0x01, 0x38, 0x0D, 0xE7, 0x08, 0x43, 0x69, 0xBD, 0xED, 0x85, 0xED, 0xB9, 0x74, 0x17,
  0x77, 0x68, 0x15, 0xAE, 0xFF, 0xC8, 0x1D, 0x95, 0x77, 0x70, 0x30, 0x9F, 0xFF, 0xC8, 0x1E, 0xA3,
  0x77, 0x20, 0x20, 0xBF, 0xFF, 0xFA, 0x02, 0x77, 0x09, 0xFF, 0xFF, 0xB0, 0xC7, 0x60, 0x30, 0xDF,
  0xFF, 0xFC, 0x07, 0x75, 0x06, 0xFD, 0x89, 0x5E, 0xA7, 0x53, 0x11, 0x11, 0x23, 0x57, 0xAC, 0xF0,
  0x27, 0x40, 0x8F, 0xB8, 0x1D, 0x82, 0x77, 0x18, 0x21, 0x59, 0xEA, 0x0D, 0x74, 0x08, 0xFA, 0x0D,
  0x05, 0x77, 0x71, 0x81, 0x5B, 0x87, 0x30, 0x7F, 0xA0, 0x78, 0x0C, 0x00, 0x04, 0xF9, 0x0D, 0x02,
  0x80, 0xC0, 0x00, 0x10, 0xEF, 0x0C, 0x01, 0x80, 0xC1, 0x00, 0xAF, 0x0C, 0x01, 0x80, 0xC1, 0x00,
  0x5F, 0x0D, 0x01, 0x80, 0xC2, 0x00, 0xDF, 0x03, 0x80, 0xC2, 0x00, 0x6F, 0x07, 0x80, 0xC3, 0x00,
  0xDE, 0x0D, 0x80, 0xC3, 0x00, 0x5F, 0x04, 0x80, 0xC3, 0x00, 0xBE, 0x0C, 0x80, 0xC3, 0x00, 0x1F,
  0x05, 0x80, 0xC3, 0x00, 0x6E, 0x0E, 0x80, 0xC4, 0x00, 0xAE, 0x09, 0x80, 0xC4, 0x00, 0xEE, 0x05,
  0x80, 0xC3, 0x00, 0x2F, 0x01, 0x80, 0xC3, 0x00, 0x5E, 0x0C, 0x80, 0xC4, 0x00, 0x8E, 0x09, 0x80,
  0xC4, 0x00, 0xAE, 0x07, 0x80, 0xC4, 0x00, 0xCE, 0x04, 0x80, 0xC4, 0x00, 0xEE, 0x02, 0x80, 0xC4,
  0x0F, 0x01, 0x80, 0xC3, 0x00, 0x1F, 0x80, 0xC4, 0x00, 0x1F, 0x80, 0xC4, 0x00, 0x2E, 0x0E, 0x80,
  0xC4, 0x00, 0x2E, 0x0E, 0x80, 0xC4, 0x00, 0x1E, 0x0E, 0x80, 0xC4, 0x00, 0x1F, 0x80, 0xC5, 0x0F,
  0x80, 0xC5, 0x0F, 0x01, 0x80, 0xC4, 0x00, 0xEE, 0x03, 0x80, 0xC4, 0x00, 0xCE, 0x05, 0x80, 0xC4,
  0x00, 0xBE, 0x07, 0x80, 0xC4, 0x00, 0x8E, 0x0A, 0x80, 0xC4, 0x00, 0x5E, 0x0D, 0x80, 0xC4, 0x00,
  0x3F, 0x01, 0x80, 0xC4, 0x00, 0xEE, 0x05, 0x80, 0xC4, 0x00, 0xBE, 0x0A, 0x80, 0xC4, 0x00, 0x7F,
  0x80, 0xC4, 0x00, 0x2F, 0x06, 0x80, 0xC4, 0x00, 0xCE, 0x0D, 0x80, 0xC4, 0x00, 0x6F, 0x05, 0x80,
  0xC3, 0x00, 0x10, 0xEE, 0x0D, 0x80, 0xC4, 0x00, 0x8F, 0x07, 0x80, 0xC3, 0x00, 0x1F, 0x90, 0x28,
  0x0C, 0x30, 0x07, 0xF0, 0xD0, 0x18, 0x0C, 0x30, 0x0D, 0xF0, 0xB8, 0x0C, 0x30, 0x03, 0xF9, 0x0B,
  0x80, 0xC3, 0x00, 0x6F, 0x90, 0xD0, 0x37, 0x77, 0x70, 0x17, 0x20, 0x9F, 0xA0, 0x80, 0x17, 0x77,
  0x28, 0x21, 0x6C, 0x87, 0x30, 0xAF, 0xA8, 0x1E, 0x82, 0x77, 0x48, 0x12, 0x6B, 0xB0, 0x87, 0x40,
  0x9F, 0xC8, 0x2C, 0x84, 0x27, 0x28, 0x32, 0x47, 0xAD, 0xE0, 0x87, 0x50, 0x7F, 0xF9, 0x85, 0xDD,
  0xCC, 0xDD, 0xEF, 0xD0, 0x87, 0x60, 0x30, 0xDF, 0xFF, 0xFC, 0x08, 0x77, 0x10, 0x70, 0xEF, 0xFF,
  0xFA, 0x08, 0x77, 0x28, 0x11, 0x7E, 0xFF, 0xFD, 0x0B, 0x05, 0x77, 0x68, 0x15, 0xAE, 0xFF, 0xE8,
  0x1B, 0x71, 0x77, 0x74, 0x83, 0x36, 0xAC, 0xEF, 0xA8, 0x3E, 0xCA, 0x74, 0x77, 0x77, 0x78, 0x21,
  0x12, 0x30, 0xF1, 0x77,
  // "Ĉ" (U+0108)
  0x77, 0x77, 0x60, 0x18, 0x02, 0x70, 0x58, 0x0E, 0x40, 0x0A, 0xF0, 0x38, 0x0E, 0x20, 0x05, 0xF9,
  0x0C, 0x80, 0xE1, 0x00, 0x10, 0xEF, 0xA0, 0x88, 0x0E, 0x00, 0x0B, 0xFC, 0x04, 0x80, 0xD6, 0x00,
  0x7F, 0xD0, 0xE0, 0x18, 0x0D, 0x40, 0x04, 0xF0, 0xCE, 0x0B, 0x80, 0xD3, 0x00, 0x10, 0xEE, 0x81,
  0x50, 0xCE, 0x09, 0x80, 0xD2, 0x00, 0xCE, 0x06, 0x20, 0x10, 0xDE, 0x06, 0x80, 0xD0, 0x00, 0x9E,
  0x08, 0x40, 0x20, 0xEE, 0x03, 0x80, 0xC6, 0x00, 0x7E, 0x09, 0x60, 0x30, 0xED, 0x0E, 0x01, 0x80,
  0xC4, 0x00, 0x4E, 0x0A, 0x71, 0x04, 0xE0, 0xC8, 0x0C, 0x30, 0x02, 0x0E, 0xD0, 0xB7, 0x30, 0x5E,
  0x0A, 0x80, 0xC1, 0x00, 0x10, 0xDD, 0x0B, 0x75, 0x05, 0xE0, 0x88, 0x0C, 0x00, 0x0C, 0xD0, 0xB7,
  0x70, 0x5E, 0x06, 0x77, 0x77, 0x60, 0xBD, 0x0B, 0x77, 0x20, 0x5E, 0x04, 0x77, 0x77, 0x40, 0x9D,
  0x0B, 0x77, 0x40, 0x40, 0xEC, 0x0E, 0x03, 0x77, 0x77, 0x20, 0x8D, 0x09, 0x77, 0x60, 0x30, 0xEC,
  0x0E, 0x02, 0x77, 0x77, 0x04, 0xD0, 0x77, 0x77, 0x10, 0x20, 0xDC, 0x0D, 0x77, 0x77, 0x84, 0x25,
  0x55, 0x53, 0x77, 0x73, 0x01, 0x80, 0x15, 0x80, 0xFC, 0x40, 0x85, 0x14, 0x68, 0x9B, 0xB8, 0x01,
  0xD8, 0x5B, 0xB9, 0x97, 0x53, 0x80, 0xC5, 0x08, 0x22, 0x7A, 0xEF, 0xFE, 0x82, 0xCA, 0x62, 0x77,
  0x77, 0x58, 0x13, 0x8D, 0xFF, 0xFF, 0x81, 0xD9, 0x47, 0x77, 0x70, 0x60, 0xCF, 0xFF, 0xFE, 0x81,
  0xE9, 0x37, 0x77, 0x20, 0x60, 0xE8, 0x0C, 0x3F, 0x0B, 0x04, 0x77, 0x50, 0x50, 0xD8, 0x0C, 0x6F,
  0x0C, 0x77, 0x30, 0x10, 0xAF, 0xF9, 0x83, 0xEC, 0xA8, 0x78, 0x01, 0x58, 0x37, 0x89, 0xBE, 0xFF,
  0x04, 0x77, 0x20, 0x40, 0xEF, 0xD8, 0x2D, 0x95, 0x27, 0x71, 0x83, 0x14, 0x7B, 0xEF, 0x90, 0xD7,
  0x72, 0x08, 0xFC, 0x81, 0xE9, 0x37, 0x77, 0x38, 0x14, 0x9E, 0xD0, 0x67, 0x71, 0x0A, 0xFB, 0x0D,
  0x06, 0x77, 0x77, 0x20, 0x40, 0xAA, 0x0E, 0x77, 0x10, 0xBF, 0xA0, 0xE0, 0x77, 0x77, 0x76, 0x81,
  0x18, 0x67, 0x70, 0xBF, 0xA0, 0xA0, 0x18, 0x0D, 0x70, 0x0B, 0xF9, 0x0E, 0x05, 0x80, 0xE0, 0x00,
  0x9F, 0x90, 0xD0, 0x38, 0x0E, 0x00, 0x07, 0xF9, 0x0C, 0x01, 0x80, 0xE0, 0x00, 0x3F, 0x90, 0xC0,
  0x18, 0x0E, 0x10, 0x0D, 0xF0, 0xD0, 0x18, 0x0E, 0x10, 0x08, 0xF0, 0xE0, 0x28, 0x0E, 0x10, 0x02,
  0xF9, 0x04, 0x80, 0xE2, 0x00, 0xBF, 0x09, 0x80, 0xE2, 0x00, 0x4F, 0x0D, 0x80, 0xE3, 0x00, 0xCF,
  0x04, 0x80, 0xE2, 0x00, 0x3F, 0x0B, 0x80, 0xE3, 0x00, 0xAF, 0x03, 0x80, 0xE2, 0x00, 0x1F, 0x0A,
  0x80, 0xE3, 0x00, 0x7F, 0x04, 0x80, 0xE3, 0x00, 0xDE, 0x0C, 0x80, 0xE3, 0x00, 0x2F, 0x07, 0x80,
  0xE3, 0x00, 0x7F, 0x01, 0x80, 0xE3, 0x00, 0xBE, 0x0C, 0x80, 0xE4, 0x0F, 0x07, 0x80, 0xE3, 0x00,
  0x3F, 0x03, 0x80, 0xE3, 0x00, 0x7F, 0x80, 0xE4, 0x00, 0x9E, 0x0B, 0x80, 0xE4, 0x00, 0xCE, 0x09,
  0x80, 0xE4, 0x00, 0xEE, 0x06, 0x80, 0xE3, 0x00, 0x1F, 0x04, 0x80, 0xE3, 0x00, 0x3F, 0x02, 0x80,
  0xE3, 0x00, 0x4F, 0x80, 0xE4, 0x00, 0x6E, 0x0E, 0x80, 0xE4, 0x00, 0x7E, 0x0D, 0x80, 0xE4, 0x00,
  0x7E, 0x0C, 0x80, 0xE4, 0x00, 0x8E, 0x0C, 0x80, 0xE4, 0x00, 0x8E, 0x0C, 0x80, 0xE4, 0x00, 0x8E,
  0x0B, 0x80, 0xE4, 0x00, 0x8E, 0x0C, 0x80, 0xE4, 0x00, 0x7E, 0x0C, 0x80, 0xE4, 0x00, 0x7E, 0x0D,
  0x80, 0xE4, 0x00, 0x6E, 0x0E, 0x80, 0xE4, 0x00, 0x5F, 0x80, 0xE4, 0x00, 0x4F, 0x01, 0x80, 0xE3,
  0x00, 0x2F, 0x03, 0x80, 0xE4, 0x0F, 0x04, 0x80, 0xE4, 0x00, 0xEE, 0x07, 0x80, 0xE4, 0x00, 0xBE,
  0x09, 0x80, 0xE4, 0x00, 0x9E, 0x0C, 0x80, 0xE4, 0x00, 0x6F, 0x80, 0xE4, 0x00, 0x3F, 0x03, 0x80,
  0xE4, 0x0F, 0x08, 0x80, 0xE4, 0x00, 0xCE, 0x0C, 0x80, 0xE4, 0x00, 0x7F, 0x01, 0x80, 0xE3, 0x00,
  0x3F, 0x06, 0x80, 0xE4, 0x00, 0xEE, 0x0C, 0x80, 0xE4, 0x00, 0x9F, 0x03, 0x80, 0xE3, 0x00, 0x4F,
  0x09, 0x80, 0xE4, 0x00, 0xDF, 0x01, 0x80, 0xE3, 0x00, 0x7F, 0x09, 0x80, 0xE3, 0x00, 0x10, 0xEF,
  0x02, 0x80, 0xE3, 0x00, 0x8F, 0x0B, 0x80, 0xE3, 0x00, 0x1F, 0x90, 0x58, 0x0E, 0x30, 0x08, 0xF0,
  0xE0, 0x28, 0x0E, 0x30, 0x0D, 0xF0, 0xC8, 0x0E, 0x30, 0x05, 0xF9, 0x0B, 0x80, 0xE3, 0x00, 0xAF,
  0x90, 0xA8, 0x0E, 0x20, 0x01, 0x0D, 0xF9, 0x0A, 0x80, 0xE2, 0x00, 0x20, 0xEF, 0x90, 0xC0, 0x18,
  0x0E, 0x10, 0x05, 0xFA, 0x0D, 0x04, 0x80, 0xE1, 0x00, 0x6F, 0xB0, 0x90, 0x18, 0x0E, 0x00, 0x06,
  0xFB, 0x0E, 0x07, 0x77, 0x77, 0x70, 0x10, 0x37, 0x71, 0x05, 0xFC, 0x81, 0xE8, 0x27, 0x77, 0x71,
  0x83, 0x37, 0xCF, 0x97, 0x72, 0x03, 0x0D, 0xFD, 0x81, 0xC7, 0x37, 0x77, 0x82, 0x25, 0x8C, 0xD0,
  0x97, 0x73, 0x01, 0x0B, 0xFF, 0x8A, 0x3E, 0xB8, 0x64, 0x31, 0x11, 0x01, 0x11, 0x23, 0x46, 0x7A,
  0xCE, 0xFA, 0x09, 0x77, 0x50, 0x60, 0xE8, 0x0C, 0x6F, 0x09, 0x77, 0x60, 0x10, 0x98, 0x0C, 0x5F,
  0x09, 0x77, 0x71, 0x02, 0x09, 0x80, 0xC2, 0xF0, 0xE0, 0x67, 0x77, 0x38, 0x11, 0x7D, 0xFF, 0xFF,
  0xC8, 0x1E, 0x95, 0x77, 0x77, 0x18, 0x12, 0x7B, 0xFF, 0xFC, 0x82, 0xEA, 0x73, 0x80, 0xC0, 0x08,
  0x43, 0x69, 0xBD, 0xEF, 0xC8, 0x5E, 0xCB, 0x96, 0x41, 0x80, 0xD3, 0x00, 0xF1, 0x03, 0x02, 0x0F,
  0x17, 0x76,
  // "ĉ" (U+0109)
  0x77, 0x73, 0x04, 0x80, 0x2B, 0x07, 0x80, 0xC4, 0x00, 0xDF, 0x02, 0x80, 0xC2, 0x00, 0x9F, 0x90,
  0xC8, 0x0C, 0x10, 0x04, 0xFB, 0x07, 0x77, 0x77, 0x70, 0x10, 0xEF, 0xC0, 0x37, 0x77, 0x76, 0x0B,
  0xFD, 0x0D, 0x01, 0x77, 0x77, 0x40, 0x8E, 0x0D, 0x0B, 0xE0, 0xB7, 0x77, 0x73, 0x05, 0xE8, 0x2E,
  0x10, 0xCE, 0x08, 0x77, 0x77, 0x10, 0x20, 0xED, 0x0E, 0x03, 0x20, 0x10, 0xDE, 0x05, 0x77, 0x76,
  0x01, 0x0D, 0xE0, 0x44, 0x02, 0x0E, 0xE0, 0x37, 0x77, 0x50, 0xBE, 0x05, 0x60, 0x30, 0xED, 0x0D,
  0x01, 0x77, 0x73, 0x09, 0xE0, 0x67, 0x10, 0x4E, 0x0C, 0x77, 0x72, 0x06, 0xE0, 0x77, 0x30, 0x5E,
  0x09, 0x77, 0x70, 0x4E, 0x07, 0x75, 0x05, 0xE0, 0x77, 0x75, 0x03, 0x0E, 0xD0, 0x77, 0x70, 0x5E,
  0x05, 0x77, 0x30, 0x20, 0xED, 0x07, 0x77, 0x20, 0x5E, 0x04, 0x77, 0x10, 0x10, 0xDD, 0x06, 0x77,
  0x40, 0x40, 0xEC, 0x0E, 0x03, 0x77, 0x0C, 0xC0, 0xE0, 0x57, 0x76, 0x03, 0x0E, 0xC0, 0xE0, 0x27,
  0x50, 0x8C, 0x0E, 0x03, 0x77, 0x71, 0x02, 0x0D, 0xC0, 0xC7, 0x58, 0x42, 0x33, 0x33, 0x17, 0x77,
  0x30, 0x18, 0x01, 0x38, 0x0D, 0xC5, 0x08, 0x43, 0x69, 0xBD, 0xED, 0x85, 0xED, 0xB9, 0x74, 0x17,
  0x77, 0x68, 0x15, 0xAE, 0xFF, 0xC8, 0x1D, 0x95, 0x77, 0x70, 0x30, 0x9F, 0xFF, 0xC8, 0x1E, 0xA3,
  0x77, 0x20, 0x20, 0xBF, 0xFF, 0xFA, 0x02, 0x77, 0x09, 0xFF, 0xFF, 0xB0, 0xC7, 0x60, 0x30, 0xDF,
  0xFF, 0xFC, 0x07, 0x75, 0x06, 0xFD, 0x89, 0x5E, 0xA7, 0x53, 0x11, 0x11, 0x23, 0x57, 0xAC, 0xF0,
  0x27, 0x40, 0x8F, 0xB8, 0x1D, 0x82, 0x77, 0x18, 0x21, 0x59, 0xEA, 0x0D, 0x74, 0x08, 0xFA, 0x0D,
  0x05, 0x77, 0x71, 0x81, 0x5B, 0x87, 0x30, 0x7F, 0xA0, 0x78, 0x0C, 0x00, 0x04, 0xF9, 0x0D, 0x02,
  0x80, 0xC0, 0x00, 0x10, 0xEF, 0x0C, 0x01, 0x80, 0xC1, 0x00, 0xAF, 0x0C, 0x01, 0x80, 0xC1, 0x00,
  0x5F, 0x0D, 0x01, 0x80, 0xC2, 0x00, 0xDF, 0x03, 0x80, 0xC2, 0x00, 0x6F, 0x07, 0x80, 0xC3, 0x00,
  0xDE, 0x0D, 0x80, 0xC3, 0x00, 0x5F, 0x04, 0x80, 0xC3, 0x00, 0xBE, 0x0C, 0x80, 0xC3, 0x00, 0x1F,
  0x05, 0x80, 0xC3, 0x00, 0x6E, 0x0E, 0x80, 0xC4, 0x00, 0xAE, 0x09, 0x80, 0xC4, 0x00, 0xEE, 0x05,
  0x80, 0xC3, 0x00, 0x2F, 0x01, 0x80, 0xC3, 0x00, 0x5E, 0x0C, 0x80, 0xC4, 0x00, 0x8E, 0x09, 0x80,
  0xC4, 0x00, 0xAE, 0x07, 0x80, 0xC4, 0x00, 0xCE, 0x04, 0x80, 0xC4, 0x00, 0xEE, 0x02, 0x80, 0xC4,
  0x0F, 0x01, 0x80, 0xC3, 0x00, 0x1F, 0x80, 0xC4, 0x00, 0x1F, 0x80, 0xC4, 0x00, 0x2E, 0x0E, 0x80,
  0xC4, 0x00, 0x2E, 0x0E, 0x80, 0xC4, 0x00, 0x1E, 0x0E, 0x80, 0xC4, 0x00, 0x1F, 0x80, 0xC5, 0x0F,
  0x80, 0xC5, 0x0F, 0x01, 0x80, 0xC4, 0x00, 0xEE, 0x03, 0x80, 0xC4, 0x00, 0xCE, 0x05, 0x80, 0xC4,
  0x00, 0xBE, 0x07, 0x80, 0xC4, 0x00, 0x8E, 0x0A, 0x80, 0xC4, 0x00, 0x5E, 0x0D, 0x80, 0xC4, 0x00,
  0x3F, 0x01, 0x80, 0xC4, 0x00, 0xEE, 0x05, 0x80, 0xC4, 0x00, 0xBE, 0x0A, 0x80, 0xC4, 0x00, 0x7F,
  0x80, 0xC4, 0x00, 0x2F, 0x06, 0x80, 0xC4, 0x00, 0xCE, 0x0D, 0x80, 0xC4, 0x00, 0x6F, 0x05, 0x80,
  0xC3, 0x00, 0x10, 0xEE, 0x0D, 0x80, 0xC4, 0x00, 0x8F, 0x07, 0x80, 0xC3, 0x00, 0x1F, 0x90, 0x28,
  0x0C, 0x30, 0x07, 0xF0, 0xD0, 0x18, 0x0C, 