#include "28.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedMedium (Noto Sans Condensed Medium)
// Generated on Thu Mar 30 23:43:28 CEST 2023
static const uint8_t font_NotoSans_CondensedMedium_28_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x07, 0xD5,
  0xFB, 0xFA, 0x1C, 0x1D, 0x16, 0xF9, 0x07, 0x03, 0x1D, 0x07, 0x07, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x01, 0x01, 0x05, 0x15, 0x07, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x01, 0x0E, 0x09, 0x15, 0x0B, 0x00, 0x32, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x0E, 0x15, 0x0F, 0x00, 0x5C, // "#" (U+0023)
  0x00, 0x24, 0x01, 0xFF, 0x0C, 0x16, 0x0D, 0x00, 0xCE, // "$" (U+0024)
  0x00, 0x25, 0x01, 0x01, 0x13, 0x15, 0x15, 0x01, 0x3D, // "%" (U+0025)
  0x00, 0x26, 0x01, 0x01, 0x0F, 0x15, 0x10, 0x01, 0xF4, // "&" (U+0026)
  0x00, 0x27, 0x01, 0x0E, 0x04, 0x15, 0x06, 0x02, 0x74, // "'" (U+0027)
  0x00, 0x28, 0x01, 0xFD, 0x07, 0x15, 0x08, 0x02, 0x87, // "(" (U+0028)
  0x00, 0x29, 0x00, 0xFD, 0x07, 0x15, 0x08, 0x02, 0xD0, // ")" (U+0029)
  0x00, 0x2A, 0x01, 0x0C, 0x0B, 0x16, 0x0D, 0x03, 0x1B, // "*" (U+002A)
  0x00, 0x2B, 0x01, 0x04, 0x0C, 0x11, 0x0D, 0x03, 0x4E, // "+" (U+002B)
  0x00, 0x2C, 0x01, 0xFD, 0x05, 0x03, 0x07, 0x03, 0x7F, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x07, 0x07, 0x09, 0x08, 0x03, 0x93, // "-" (U+002D)
  0x00, 0x2E, 0x01, 0x01, 0x05, 0x04, 0x07, 0x03, 0x9C, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x0A, 0x15, 0x0B, 0x03, 0xA7, // "/" (U+002F)
  0x00, 0x30, 0x01, 0x01, 0x0C, 0x15, 0x0D, 0x03, 0xE7, // "0" (U+0030)
  0x00, 0x31, 0x02, 0x01, 0x09, 0x15, 0x0D, 0x04, 0x54, // "1" (U+0031)
  0x00, 0x32, 0x01, 0x01, 0x0C, 0x15, 0x0D, 0x04, 0x9A, // "2" (U+0032)
  0x00, 0x33, 0x01, 0x01, 0x0B, 0x15, 0x0D, 0x04, 0xEA, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x0C, 0x15, 0x0D, 0x05, 0x41, // "4" (U+0034)
  0x00, 0x35, 0x01, 0x01, 0x0C, 0x15, 0x0D, 0x05, 0x96, // "5" (U+0035)
  0x00, 0x36, 0x01, 0x01, 0x0C, 0x15, 0x0D, 0x05, 0xEA, // "6" (U+0036)
  0x00, 0x37, 0x01, 0x01, 0x0C, 0x15, 0x0D, 0x06, 0x52, // "7" (U+0037)
  0x00, 0x38, 0x01, 0x01, 0x0C, 0x15, 0x0D, 0x06, 0x97, // "8" (U+0038)
  0x00, 0x39, 0x01, 0x01, 0x0C, 0x15, 0x0D, 0x07, 0x0C, // "9" (U+0039)
  0x00, 0x3A, 0x01, 0x01, 0x05, 0x10, 0x07, 0x07, 0x72, // ":" (U+003A)
  0x00, 0x3B, 0x01, 0xFE, 0x05, 0x10, 0x07, 0x07, 0x8A, // ";" (U+003B)
  0x00, 0x3C, 0x01, 0x04, 0x0C, 0x11, 0x0D, 0x07, 0xAB, // "<" (U+003C)
  0x00, 0x3D, 0x01, 0x07, 0x0C, 0x0F, 0x0D, 0x07, 0xE7, // "=" (U+003D)
  0x00, 0x3E, 0x01, 0x04, 0x0C, 0x11, 0x0D, 0x07, 0xF8, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x09, 0x15, 0x0A, 0x08, 0x30, // "?" (U+003F)
  0x00, 0x40, 0x01, 0xFE, 0x13, 0x15, 0x15, 0x08, 0x71, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x0E, 0x15, 0x0F, 0x09, 0x37, // "A" (U+0041)
  0x00, 0x42, 0x02, 0x01, 0x0D, 0x15, 0x0F, 0x09, 0xA4, // "B" (U+0042)
  0x00, 0x43, 0x01, 0x01, 0x0D, 0x15, 0x0E, 0x0A, 0x0A, // "C" (U+0043)
  0x00, 0x44, 0x02, 0x01, 0x0F, 0x15, 0x11, 0x0A, 0x61, // "D" (U+0044)
  0x00, 0x45, 0x02, 0x01, 0x0B, 0x15, 0x0D, 0x0A, 0xC8, // "E" (U+0045)
  0x00, 0x46, 0x02, 0x01, 0x0B, 0x15, 0x0C, 0x0B, 0x02, // "F" (U+0046)
  0x00, 0x47, 0x01, 0x01, 0x0F, 0x15, 0x11, 0x0B, 0x37, // "G" (U+0047)
  0x00, 0x48, 0x02, 0x01, 0x0E, 0x15, 0x11, 0x0B, 0xAA, // "H" (U+0048)
  0x00, 0x49, 0x01, 0x01, 0x07, 0x15, 0x09, 0x0B, 0xF6, // "I" (U+0049)
  0x00, 0x4A, 0xFE, 0xFB, 0x04, 0x15, 0x07, 0x0C, 0x32, // "J" (U+004A)
  0x00, 0x4B, 0x02, 0x01, 0x0E, 0x15, 0x0E, 0x0C, 0x85, // "K" (U+004B)
  0x00, 0x4C, 0x02, 0x01, 0x0B, 0x15, 0x0C, 0x0C, 0xF0, // "L" (U+004C)
  0x00, 0x4D, 0x02, 0x01, 0x13, 0x15, 0x16, 0x0D, 0x1F, // "M" (U+004D)
  0x00, 0x4E, 0x02, 0x01, 0x0F, 0x15, 0x12, 0x0D, 0xCB, // "N" (U+004E)
  0x00, 0x4F, 0x01, 0x01, 0x10, 0x15, 0x12, 0x0E, 0x4C, // "O" (U+004F)
  0x00, 0x50, 0x02, 0x01, 0x0C, 0x15, 0x0E, 0x0E, 0xC8, // "P" (U+0050)
  0x00, 0x51, 0x01, 0xFC, 0x10, 0x15, 0x12, 0x0F, 0x16, // "Q" (U+0051)
  0x00, 0x52, 0x02, 0x01, 0x0E, 0x15, 0x0F, 0x0F, 0xA1, // "R" (U+0052)
  0x00, 0x53, 0x01, 0x01, 0x0B, 0x15, 0x0D, 0x10, 0x06, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x0C, 0x15, 0x0C, 0x10, 0x5B, // "T" (U+0054)
  0x00, 0x55, 0x02, 0x01, 0x0E, 0x15, 0x11, 0x10, 0xA7, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x0E, 0x15, 0x0E, 0x11, 0x0B, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x16, 0x15, 0x16, 0x11, 0x79, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x0D, 0x15, 0x0D, 0x12, 0x3A, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x0C, 0x15, 0x0D, 0x12, 0xA7, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x0B, 0x15, 0x0C, 0x13, 0x04, // "Z" (U+005A)
  0x00, 0x5B, 0x02, 0xFC, 0x08, 0x15, 0x09, 0x13, 0x4C, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x0A, 0x15, 0x0B, 0x13, 0x81, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0xFC, 0x06, 0x15, 0x09, 0x13, 0xC8, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x0A, 0x0D, 0x15, 0x0E, 0x14, 0x16, // "^" (U+005E)
  0x00, 0x5F, 0xFF, 0xFD, 0x0C, 0xFF, 0x0C, 0x14, 0x53, // "_" (U+005F)
  0x00, 0x60, 0x01, 0x13, 0x06, 0x17, 0x08, 0x14, 0x5D, // "`" (U+0060)
  0x00, 0x61, 0x01, 0x01, 0x0B, 0x10, 0x0D, 0x14, 0x6D, // "a" (U+0061)
  0x00, 0x62, 0x01, 0x01, 0x0D, 0x16, 0x0E, 0x14, 0xBA, // "b" (U+0062)
  0x00, 0x63, 0x01, 0x01, 0x0A, 0x10, 0x0B, 0x15, 0x2B, // "c" (U+0063)
  0x00, 0x64, 0x01, 0x01, 0x0C, 0x16, 0x0E, 0x15, 0x69, // "d" (U+0064)
  0x00, 0x65, 0x01, 0x01, 0x0C, 0x10, 0x0D, 0x15, 0xDE, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x08, 0x16, 0x08, 0x16, 0x26, // "f" (U+0066)
  0x00, 0x67, 0x01, 0xFA, 0x0C, 0x10, 0x0E, 0x16, 0x70, // "g" (U+0067)
  0x00, 0x68, 0x01, 0x01, 0x0C, 0x16, 0x0E, 0x16, 0xEF, // "h" (U+0068)
  0x00, 0x69, 0x01, 0x01, 0x04, 0x16, 0x07, 0x17, 0x5E, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xFA, 0x04, 0x16, 0x07, 0x17, 0x91, // "j" (U+006A)
  0x00, 0x6B, 0x01, 0x01, 0x0C, 0x16, 0x0D, 0x17, 0xE4, // "k" (U+006B)
  0x00, 0x6C, 0x01, 0x01, 0x04, 0x16, 0x07, 0x18, 0x53, // "l" (U+006C)
  0x00, 0x6D, 0x01, 0x01, 0x13, 0x10, 0x16, 0x18, 0x8A, // "m" (U+006D)
  0x00, 0x6E, 0x01, 0x01, 0x0C, 0x10, 0x0E, 0x19, 0x11, // "n" (U+006E)
  0x00, 0x6F, 0x01, 0x01, 0x0C, 0x10, 0x0E, 0x19, 0x6B, // "o" (U+006F)
  0x00, 0x70, 0x01, 0xFA, 0x0D, 0x10, 0x0E, 0x19, 0xBC, // "p" (U+0070)
  0x00, 0x71, 0x01, 0xFA, 0x0C, 0x10, 0x0E, 0x1A, 0x32, // "q" (U+0071)
  0x00, 0x72, 0x01, 0x01, 0x09, 0x10, 0x0A, 0x1A, 0xAB, // "r" (U+0072)
  0x00, 0x73, 0x01, 0x01, 0x09, 0x10, 0x0B, 0x1A, 0xE1, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x08, 0x14, 0x09, 0x1B, 0x1D, // "t" (U+0074)
  0x00, 0x75, 0x01, 0x01, 0x0C, 0x10, 0x0E, 0x1B, 0x5F, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x0B, 0x10, 0x0C, 0x1B, 0xBC, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x12, 0x10, 0x13, 0x1C, 0x0A, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x0B, 0x10, 0x0C, 0x1C, 0x91, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFA, 0x0B, 0x10, 0x0C, 0x1C, 0xE2, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x09, 0x10, 0x0A, 0x1D, 0x4B, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFC, 0x09, 0x15, 0x0A, 0x1D, 0x80, // "{" (U+007B)
  0x00, 0x7C, 0x05, 0xFA, 0x07, 0x16, 0x0D, 0x1D, 0xD5, // "|" (U+007C)
  0x00, 0x7D, 0x01, 0xFC, 0x09, 0x15, 0x0A, 0x1E, 0x03, // "}" (U+007D)
  0x00, 0x7E, 0x01, 0x09, 0x0C, 0x0C, 0x0D, 0x1E, 0x56, // "~" (U+007E)
  0x00, 0xA1, 0x01, 0xFC, 0x05, 0x10, 0x07, 0x1E, 0x6C, // "¡" (U+00A1)
  0x00, 0xA2, 0x02, 0x01, 0x0B, 0x15, 0x0D, 0x1E, 0x9E, // "¢" (U+00A2)
  0x00, 0xA3, 0x01, 0x01, 0x0C, 0x15, 0x0D, 0x1E, 0xE6, // "£" (U+00A3)
  0x00, 0xA4, 0x01, 0x04, 0x0D, 0x11, 0x10, 0x1F, 0x37, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x0C, 0x15, 0x0D, 0x1F, 0x8C, // "¥" (U+00A5)
  0x00, 0xA6, 0x05, 0xFA, 0x07, 0x16, 0x0D, 0x1F, 0xEA, // "¦" (U+00A6)
  0x00, 0xA7, 0x01, 0x01, 0x0A, 0x16, 0x0C, 0x20, 0x10, // "§" (U+00A7)
  0x00, 0xA8, 0x03, 0x13, 0x0B, 0x15, 0x0F, 0x20, 0x75, // "¨" (U+00A8)
  0x00, 0xA9, 0x01, 0x01, 0x15, 0x15, 0x17, 0x20, 0x86, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x0B, 0x07, 0x14, 0x09, 0x21, 0x3A, // "ª" (U+00AA)
  0x00, 0xAB, 0x01, 0x02, 0x0C, 0x0E, 0x0E, 0x21, 0x64, // "«" (U+00AB)
  0x00, 0xAC, 0x01, 0x04, 0x0C, 0x0C, 0x0D, 0x21, 0xAF, // "¬" (U+00AC)
  0x00, 0xAE, 0x01, 0x01, 0x15, 0x15, 0x17, 0x21, 0xC6, // "®" (U+00AE)
  0x00, 0xAF, 0xFF, 0x17, 0x0C, 0x19, 0x0D, 0x22, 0x7F, // "¯" (U+00AF)
  0x00, 0xB0, 0x01, 0x0E, 0x09, 0x15, 0x0B, 0x22, 0x86, // "°" (U+00B0)
  0x00, 0xB1, 0x01, 0x01, 0x0C, 0x12, 0x0D, 0x22, 0xAD, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x0D, 0x08, 0x18, 0x09, 0x22, 0xE6, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x0C, 0x08, 0x18, 0x09, 0x23, 0x13, // "³" (U+00B3)
  0x00, 0xB4, 0x01, 0x13, 0x06, 0x17, 0x08, 0x23, 0x45, // "´" (U+00B4)
  0x00, 0xB5, 0x01, 0xFA, 0x0C, 0x10, 0x0F, 0x23, 0x55, // "µ" (U+00B5)
  0x00, 0xB6, 0x01, 0xFC, 0x0C, 0x16, 0x0F, 0x23, 0xC8, // "¶" (U+00B6)
  0x00, 0xB7, 0x01, 0x09, 0x05, 0x0C, 0x07, 0x24, 0x45, // "·" (U+00B7)
  0x00, 0xB8, 0x00, 0xFA, 0x05, 0x00, 0x06, 0x24, 0x50, // "¸" (U+00B8)
  0x00, 0xB9, 0x01, 0x0D, 0x06, 0x18, 0x09, 0x24, 0x66, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x0B, 0x08, 0x14, 0x09, 0x24, 0x8C, // "º" (U+00BA)
  0x00, 0xBB, 0x01, 0x02, 0x0C, 0x0E, 0x0E, 0x24, 0xBA, // "»" (U+00BB)
  0x00, 0xBC, 0x01, 0x01, 0x14, 0x15, 0x15, 0x25, 0x05, // "¼" (U+00BC)
  0x00, 0xBD, 0x01, 0x01, 0x14, 0x15, 0x16, 0x25, 0x9F, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x14, 0x16, 0x15, 0x26, 0x35, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFB, 0x09, 0x0F, 0x0A, 0x26, 0xE6, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x0E, 0x1C, 0x0F, 0x27, 0x27, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x0E, 0x1C, 0x0F, 0x27, 0xA8, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x0E, 0x1C, 0x0F, 0x28, 0x2A, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x0E, 0x1B, 0x0F, 0x28, 0xB1, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x0E, 0x1A, 0x0F, 0x29, 0x37, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x0E, 0x1A, 0x0F, 0x29, 0xB8, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x12, 0x15, 0x14, 0x2A, 0x3E, // "Æ" (U+00C6)
  0x00, 0xC7, 0x01, 0xFA, 0x0D, 0x15, 0x0E, 0x2A, 0xBE, // "Ç" (U+00C7)
  0x00, 0xC8, 0x02, 0x01, 0x0B, 0x1C, 0x0D, 0x2B, 0x2E, // "È" (U+00C8)
  0x00, 0xC9, 0x02, 0x01, 0x0B, 0x1C, 0x0D, 0x2B, 0x7A, // "É" (U+00C9)
  0x00, 0xCA, 0x02, 0x01, 0x0B, 0x1C, 0x0D, 0x2B, 0xC6, // "Ê" (U+00CA)
  0x00, 0xCB, 0x02, 0x01, 0x0B, 0x1A, 0x0D, 0x2C, 0x18, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x07, 0x1C, 0x09, 0x2C, 0x65, // "Ì" (U+00CC)
  0x00, 0xCD, 0x01, 0x01, 0x08, 0x1C, 0x09, 0x2C, 0xB4, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x08, 0x1C, 0x09, 0x2D, 0x04, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x08, 0x1A, 0x09, 0x2D, 0x5B, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x0E, 0x15, 0x11, 0x2D, 0xAC, // "Ð" (U+00D0)
  0x00, 0xD1, 0x02, 0x01, 0x0F, 0x1B, 0x12, 0x2E, 0x24, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x01, 0x01, 0x10, 0x1C, 0x12, 0x2E, 0xBF, // "Ò" (U+00D2)
  0x00, 0xD3, 0x01, 0x01, 0x10, 0x1C, 0x12, 0x2F, 0x4F, // "Ó" (U+00D3)
  0x00, 0xD4, 0x01, 0x01, 0x10, 0x1C, 0x12, 0x2F, 0xDF, // "Ô" (U+00D4)
  0x00, 0xD5, 0x01, 0x01, 0x10, 0x1B, 0x12, 0x30, 0x75, // "Õ" (U+00D5)
  0x00, 0xD6, 0x01, 0x01, 0x10, 0x1A, 0x12, 0x31, 0x0A, // "Ö" (U+00D6)
  0x00, 0xD7, 0x01, 0x05, 0x0C, 0x10, 0x0D, 0x31, 0x9A, // "×" (U+00D7)
  0x00, 0xD8, 0x01, 0x00, 0x10, 0x16, 0x12, 0x31, 0xDA, // "Ø" (U+00D8)
  0x00, 0xD9, 0x02, 0x01, 0x0E, 0x1C, 0x11, 0x32, 0x78, // "Ù" (U+00D9)
  0x00, 0xDA, 0x02, 0x01, 0x0E, 0x1C, 0x11, 0x32, 0xF0, // "Ú" (U+00DA)
  0x00, 0xDB, 0x02, 0x01, 0x0E, 0x1C, 0x11, 0x33, 0x68, // "Û" (U+00DB)
  0x00, 0xDC, 0x02, 0x01, 0x0E, 0x1A, 0x11, 0x33, 0xE5, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x0C, 0x1C, 0x0D, 0x34, 0x5D, // "Ý" (U+00DD)
  0x00, 0xDE, 0x02, 0x01, 0x0C, 0x15, 0x0E, 0x34, 0xCE, // "Þ" (U+00DE)
  0x00, 0xDF, 0x01, 0x01, 0x0D, 0x16, 0x0F, 0x35, 0x1C, // "ß" (U+00DF)
  0x00, 0xE0, 0x01, 0x01, 0x0B, 0x17, 0x0D, 0x35, 0x9E, // "à" (U+00E0)
  0x00, 0xE1, 0x01, 0x01, 0x0B, 0x17, 0x0D, 0x35, 0xFE, // "á" (U+00E1)
  0x00, 0xE2, 0x01, 0x01, 0x0B, 0x17, 0x0D, 0x36, 0x5D, // "â" (U+00E2)
  0x00, 0xE3, 0x01, 0x01, 0x0B, 0x16, 0x0D, 0x36, 0xC2, // "ã" (U+00E3)
  0x00, 0xE4, 0x01, 0x01, 0x0B, 0x15, 0x0D, 0x37, 0x27, // "ä" (U+00E4)
  0x00, 0xE5, 0x01, 0x01, 0x0B, 0x18, 0x0D, 0x37, 0x88, // "å" (U+00E5)
  0x00, 0xE6, 0x01, 0x01, 0x13, 0x10, 0x14, 0x37, 0xF2, // "æ" (U+00E6)
  0x00, 0xE7, 0x01, 0xFA, 0x0A, 0x10, 0x0B, 0x38, 0x69, // "ç" (U+00E7)
  0x00, 0xE8, 0x01, 0x01, 0x0C, 0x17, 0x0D, 0x38, 0xBE, // "è" (U+00E8)
  0x00, 0xE9, 0x01, 0x01, 0x0C, 0x17, 0x0D, 0x39, 0x1A, // "é" (U+00E9)
  0x00, 0xEA, 0x01, 0x01, 0x0C, 0x17, 0x0D, 0x39, 0x75, // "ê" (U+00EA)
  0x00, 0xEB, 0x01, 0x01, 0x0C, 0x15, 0x0D, 0x39, 0xD6, // "ë" (U+00EB)
  0x00, 0xEC, 0xFF, 0x01, 0x04, 0x17, 0x07, 0x3A, 0x32, // "ì" (U+00EC)
  0x00, 0xED, 0x01, 0x01, 0x07, 0x17, 0x07, 0x3A, 0x72, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x07, 0x17, 0x07, 0x3A, 0xB4, // "î" (U+00EE)
  0x00, 0xEF, 0xFF, 0x01, 0x07, 0x15, 0x07, 0x3A, 0xFC, // "ï" (U+00EF)
  0x00, 0xF0, 0x01, 0x01, 0x0C, 0x17, 0x0E, 0x3B, 0x3E, // "ð" (U+00F0)
  0x00, 0xF1, 0x01, 0x01, 0x0C, 0x16, 0x0E, 0x3B, 0xAB, // "ñ" (U+00F1)
  0x00, 0xF2, 0x01, 0x01, 0x0C, 0x17, 0x0E, 0x3C, 0x1E, // "ò" (U+00F2)
  0x00, 0xF3, 0x01, 0x01, 0x0C, 0x17, 0x0E, 0x3C, 0x83, // "ó" (U+00F3)
  0x00, 0xF4, 0x01, 0x01, 0x0C, 0x17, 0x0E, 0x3C, 0xE7, // "ô" (U+00F4)
  0x00, 0xF5, 0x01, 0x01, 0x0C, 0x16, 0x0E, 0x3D, 0x50, // "õ" (U+00F5)
  0x00, 0xF6, 0x01, 0x01, 0x0C, 0x15, 0x0E, 0x3D, 0xBA, // "ö" (U+00F6)
  0x00, 0xF7, 0x01, 0x04, 0x0C, 0x11, 0x0D, 0x3E, 0x1E, // "÷" (U+00F7)
  0x00, 0xF8, 0x01, 0x00, 0x0C, 0x11, 0x0E, 0x3E, 0x44, // "ø" (U+00F8)
  0x00, 0xF9, 0x01, 0x01, 0x0C, 0x17, 0x0E, 0x3E, 0xAB, // "ù" (U+00F9)
  0x00, 0xFA, 0x01, 0x01, 0x0C, 0x17, 0x0E, 0x3F, 0x1C, // "ú" (U+00FA)
  0x00, 0xFB, 0x01, 0x01, 0x0C, 0x17, 0x0E, 0x3F, 0x8C, // "û" (U+00FB)
  0x00, 0xFC, 0x01, 0x01, 0x0C, 0x15, 0x0E, 0x40, 0x02, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFA, 0x0B, 0x17, 0x0C, 0x40, 0x73, // "ý" (U+00FD)
  0x00, 0xFE, 0x01, 0xFA, 0x0D, 0x16, 0x0E, 0x40, 0xEF, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFA, 0x0B, 0x15, 0x0C, 0x41, 0x79, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x0E, 0x1A, 0x0F, 0x41, 0xF6, // "Ā" (U+0100)
  0x01, 0x01, 0x01, 0x01, 0x0B, 0x15, 0x0D, 0x42, 0x70, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x0E, 0x1B, 0x0F, 0x42, 0xC9, // "Ă" (U+0102)
  0x01, 0x03, 0x01, 0x01, 0x0B, 0x16, 0x0D, 0x43, 0x4C, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFA, 0x0E, 0x15, 0x0F, 0x43, 0xAE, // "Ą" (U+0104)
  0x01, 0x05, 0x01, 0xFA, 0x0B, 0x10, 0x0D, 0x44, 0x35, // "ą" (U+0105)
  0x01, 0x06, 0x01, 0x01, 0x0D, 0x1C, 0x0E, 0x44, 0x9A, // "Ć" (U+0106)
  0x01, 0x07, 0x01, 0x01, 0x0A, 0x17, 0x0B, 0x45, 0x06, // "ć" (U+0107)
  0x01, 0x08, 0x01, 0x01, 0x0D, 0x1C, 0x0E, 0x45, 0x56, // "Ĉ" (U+0108)
  0x01, 0x09, 0x01, 0x01, 0x0A, 0x17, 0x0B, 0x45, 0xC6, // "ĉ" (U+0109)
  0x01, 0x0A, 0x01, 0x01, 0x0D, 0x1B, 0x0E, 0x46, 0x1C, // "Ċ" (U+010A)
  0x01, 0x0B, 0x01, 0x01, 0x0A, 0x16, 0x0B, 0x46, 0x83, // "ċ" (U+010B)
  0x01, 0x0C, 0x01, 0x01, 0x0D, 0x1C, 0x0E, 0x46, 0xCF, // "Č" (U+010C)
  0x01, 0x0D, 0x01, 0x01, 0x0A, 0x17, 0x0B, 0x47, 0x41, // "č" (U+010D)
  0x01, 0x0E, 0x02, 0x01, 0x0F, 0x1C, 0x11, 0x47, 0x99, // "Ď" (U+010E)
  0x01, 0x0F, 0x01, 0x01, 0x11, 0x16, 0x0E, 0x48, 0x1B, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x0E, 0x15, 0x11, 0x48, 0xA4, // "Đ" (U+0110)
  0x01, 0x11, 0x01, 0x01, 0x0E, 0x16, 0x0F, 0x49, 0x1C, // "đ" (U+0111)
  0x01, 0x12, 0x02, 0x01, 0x0B, 0x1A, 0x0D, 0x49, 0x9A, // "Ē" (U+0112)
  0x01, 0x13, 0x01, 0x01, 0x0C, 0x15, 0x0D, 0x49, 0xE0, // "ē" (U+0113)
  0x01, 0x14, 0x02, 0x01, 0x0B, 0x1B, 0x0D, 0x4A, 0x34, // "Ĕ" (U+0114)
  0x01, 0x15, 0x01, 0x01, 0x0C, 0x16, 0x0D, 0x4A, 0x83, // "ĕ" (U+0115)
  0x01, 0x16, 0x02, 0x01, 0x0B, 0x1B, 0x0D, 0x4A, 0xE0, // "Ė" (U+0116)
  0x01, 0x17, 0x01, 0x01, 0x0C, 0x16, 0x0D, 0x4B, 0x28, // "ė" (U+0117)
  0x01, 0x18, 0x02, 0xFA, 0x0B, 0x15, 0x0D, 0x4B, 0x7F, // "Ę" (U+0118)
  0x01, 0x19, 0x01, 0xFA, 0x0C, 0x10, 0x0D, 0x4B, 0xD0, // "ę" (U+0119)
  0x01, 0x1A, 0x02, 0x01, 0x0B, 0x1C, 0x0D, 0x4C, 0x35, // "Ě" (U+011A)
  0x01, 0x1B, 0x01, 0x01, 0x0C, 0x17, 0x0D, 0x4C, 0x89, // "ě" (U+011B)
  0x01, 0x1C, 0x01, 0x01, 0x0F, 0x1C, 0x11, 0x4C, 0xEB, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x01, 0xFA, 0x0C, 0x17, 0x0E, 0x4D, 0x78, // "ĝ" (U+011D)
  0x01, 0x1E, 0x01, 0x01, 0x0F, 0x1B, 0x11, 0x4E, 0x10, // "Ğ" (U+011E)
  0x01, 0x1F, 0x01, 0xFA, 0x0C, 0x16, 0x0E, 0x4E, 0x98, // "ğ" (U+011F)
  0x01, 0x20, 0x01, 0x01, 0x0F, 0x1B, 0x11, 0x4F, 0x2C, // "Ġ" (U+0120)
  0x01, 0x21, 0x01, 0xFA, 0x0C, 0x16, 0x0E, 0x4F, 0xAE, // "ġ" (U+0121)
  0x01, 0x22, 0x01, 0xFB, 0x0F, 0x15, 0x11, 0x50, 0x3D, // "Ģ" (U+0122)
  0x01, 0x23, 0x01, 0xFA, 0x0C, 0x16, 0x0E, 0x50, 0xC2, // "ģ" (U+0123)
  0x01, 0x24, 0x02, 0x01, 0x0E, 0x1C, 0x11, 0x51, 0x53, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x0C, 0x1D, 0x0E, 0x51, 0xB8, // "ĥ" (U+0125)
  0x01, 0x26, 0xFF, 0x01, 0x10, 0x15, 0x11, 0x52, 0x48, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x0C, 0x16, 0x0E, 0x52, 0xA0, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x01, 0x09, 0x1B, 0x09, 0x53, 0x18, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0x01, 0x08, 0x16, 0x07, 0x53, 0x6E, // "ĩ" (U+0129)
  0x01, 0x2A, 0x01, 0x01, 0x08, 0x1A, 0x09, 0x53, 0xB5, // "Ī" (U+012A)
  0x01, 0x2B, 0xFF, 0x01, 0x06, 0x15, 0x07, 0x53, 0xFE, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x07, 0x1B, 0x09, 0x54, 0x39, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFF, 0x01, 0x06, 0x16, 0x07, 0x54, 0x88, // "ĭ" (U+012D)
  0x01, 0x2E, 0x01, 0xFA, 0x07, 0x15, 0x09, 0x54, 0xC9, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFA, 0x04, 0x16, 0x07, 0x55, 0x1C, // "į" (U+012F)
  0x01, 0x30, 0x01, 0x01, 0x07, 0x1B, 0x09, 0x55, 0x6C, // "İ" (U+0130)
  0x01, 0x31, 0x01, 0x01, 0x04, 0x10, 0x07, 0x55, 0xB6, // "ı" (U+0131)
  0x01, 0x32, 0x01, 0xFB, 0x0C, 0x15, 0x10, 0x55, 0xDE, // "Ĳ" (U+0132)
  0x01, 0x33, 0x01, 0xFA, 0x0B, 0x16, 0x0D, 0x56, 0x68, // "ĳ" (U+0133)
  0x01, 0x34, 0xFE, 0xFB, 0x07, 0x1C, 0x07, 0x56, 0xF0, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFA, 0x07, 0x17, 0x07, 0x57, 0x5E, // "ĵ" (U+0135)
  0x01, 0x36, 0x02, 0xFB, 0x0E, 0x15, 0x0E, 0x57, 0xBD, // "Ķ" (U+0136)
  0x01, 0x37, 0x01, 0xFB, 0x0C, 0x16, 0x0D, 0x58, 0x3A, // "ķ" (U+0137)
  0x01, 0x38, 0x01, 0x01, 0x0C, 0x10, 0x0D, 0x58, 0xBC, // "ĸ" (U+0138)
  0x01, 0x39, 0x02, 0x01, 0x0B, 0x1C, 0x0C, 0x59, 0x16, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x01, 0x01, 0x07, 0x1D, 0x07, 0x59, 0x57, // "ĺ" (U+013A)
  0x01, 0x3B, 0x02, 0xFB, 0x0B, 0x15, 0x0C, 0x59, 0xAB, // "Ļ" (U+013B)
  0x01, 0x3C, 0x01, 0xFB, 0x05, 0x16, 0x07, 0x59, 0xEA, // "ļ" (U+013C)
  0x01, 0x3D, 0x02, 0x01, 0x0C, 0x15, 0x0C, 0x5A, 0x3A, // "Ľ" (U+013D)
  0x01, 0x3E, 0x01, 0x01, 0x09, 0x16, 0x07, 0x5A, 0x7E, // "ľ" (U+013E)
  0x01, 0x3F, 0x02, 0x01, 0x0B, 0x15, 0x0C, 0x5A, 0xCB, // "Ŀ" (U+013F)
  0x01, 0x40, 0x01, 0x01, 0x09, 0x16, 0x08, 0x5B, 0x04, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x0B, 0x15, 0x0C, 0x5B, 0x4F, // "Ł" (U+0141)
  0x01, 0x42, 0xFF, 0x01, 0x07, 0x16, 0x07, 0x5B, 0xA2, // "ł" (U+0142)
  0x01, 0x43, 0x02, 0x01, 0x0F, 0x1C, 0x12, 0x5B, 0xE8, // "Ń" (U+0143)
  0x01, 0x44, 0x01, 0x01, 0x0C, 0x17, 0x0E, 0x5C, 0x7E, // "ń" (U+0144)
  0x01, 0x45, 0x02, 0xFB, 0x0F, 0x15, 0x12, 0x5C, 0xEB, // "Ņ" (U+0145)
  0x01, 0x46, 0x01, 0xFB, 0x0C, 0x10, 0x0E, 0x5D, 0x7F, // "ņ" (U+0146)
  0x01, 0x47, 0x02, 0x01, 0x0F, 0x1C, 0x12, 0x5D, 0xEC, // "Ň" (U+0147)
  0x01, 0x48, 0x01, 0x01, 0x0C, 0x17, 0x0E, 0x5E, 0x89, // "ň" (U+0148)
  0x01, 0x49, 0xFF, 0x01, 0x0E, 0x15, 0x11, 0x5E, 0xFE, // "ŉ" (U+0149)
  0x01, 0x4A, 0x02, 0xFB, 0x0F, 0x15, 0x12, 0x5F, 0x74, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x01, 0xFA, 0x0C, 0x10, 0x0E, 0x60, 0x0A, // "ŋ" (U+014B)
  0x01, 0x4C, 0x01, 0x01, 0x10, 0x1A, 0x12, 0x60, 0x7E, // "Ō" (U+014C)
  0x01, 0x4D, 0x01, 0x01, 0x0C, 0x15, 0x0E, 0x61, 0x07, // "ō" (U+014D)
  0x01, 0x4E, 0x01, 0x01, 0x10, 0x1B, 0x12, 0x61, 0x64, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x01, 0x01, 0x0C, 0x16, 0x0E, 0x61, 0xF6, // "ŏ" (U+014F)
  0x01, 0x50, 0x01, 0x01, 0x10, 0x1C, 0x12, 0x62, 0x5C, // "Ő" (U+0150)
  0x01, 0x51, 0x01, 0x01, 0x0C, 0x17, 0x0E, 0x62, 0xF6, // "ő" (U+0151)
  0x01, 0x52, 0x01, 0x01, 0x13, 0x15, 0x15, 0x63, 0x64, // "Œ" (U+0152)
  0x01, 0x53, 0x01, 0x01, 0x14, 0x10, 0x16, 0x63, 0xE6, // "œ" (U+0153)
  0x01, 0x54, 0x02, 0x01, 0x0E, 0x1C, 0x0F, 0x64, 0x66, // "Ŕ" (U+0154)
  0x01, 0x55, 0x01, 0x01, 0x09, 0x17, 0x0A, 0x64, 0xDF, // "ŕ" (U+0155)
  0x01, 0x56, 0x02, 0xFB, 0x0E, 0x15, 0x0F, 0x65, 0x27, // "Ŗ" (U+0156)
  0x01, 0x57, 0x01, 0xFB, 0x09, 0x10, 0x0A, 0x65, 0x9E, // "ŗ" (U+0157)
  0x01, 0x58, 0x02, 0x01, 0x0E, 0x1C, 0x0F, 0x65, 0xE4, // "Ř" (U+0158)
  0x01, 0x59, 0x01, 0x01, 0x09, 0x17, 0x0A, 0x66, 0x64, // "ř" (U+0159)
  0x01, 0x5A, 0x01, 0x01, 0x0B, 0x1C, 0x0D, 0x66, 0xB2, // "Ś" (U+015A)
  0x01, 0x5B, 0x01, 0x01, 0x09, 0x17, 0x0B, 0x67, 0x19, // "ś" (U+015B)
  0x01, 0x5C, 0x01, 0x01, 0x0B, 0x1C, 0x0D, 0x67, 0x66, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x01, 0x01, 0x09, 0x17, 0x0B, 0x67, 0xD3, // "ŝ" (U+015D)
  0x01, 0x5E, 0x01, 0xFA, 0x0B, 0x15, 0x0D, 0x68, 0x26, // "Ş" (U+015E)
  0x01, 0x5F, 0x01, 0xFA, 0x09, 0x10, 0x0B, 0x68, 0x93, // "ş" (U+015F)
  0x01, 0x60, 0x01, 0x01, 0x0B, 0x1C, 0x0D, 0x68, 0xE5, // "Š" (U+0160)
  0x01, 0x61, 0x01, 0x01, 0x09, 0x17, 0x0B, 0x69, 0x54, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFA, 0x0C, 0x15, 0x0C, 0x69, 0xA7, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFA, 0x08, 0x14, 0x09, 0x6A, 0x0C, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x0C, 0x1C, 0x0C, 0x6A, 0x65, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x0C, 0x16, 0x09, 0x6A, 0xCC, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x0C, 0x15, 0x0C, 0x6B, 0x25, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x08, 0x14, 0x09, 0x6B, 0x74, // "ŧ" (U+0167)
  0x01, 0x68, 0x02, 0x01, 0x0E, 0x1B, 0x11, 0x6B, 0xB9, // "Ũ" (U+0168)
  0x01, 0x69, 0x01, 0x01, 0x0C, 0x16, 0x0E, 0x6C, 0x36, // "ũ" (U+0169)
  0x01, 0x6A, 0x02, 0x01, 0x0E, 0x1A, 0x11, 0x6C, 0xAC, // "Ū" (U+016A)
  0x01, 0x6B, 0x01, 0x01, 0x0C, 0x15, 0x0E, 0x6D, 0x1D, // "ū" (U+016B)
  0x01, 0x6C, 0x02, 0x01, 0x0E, 0x1B, 0x11, 0x6D, 0x86, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x01, 0x01, 0x0C, 0x16, 0x0E, 0x6D, 0xFF, // "ŭ" (U+016D)
  0x01, 0x6E, 0x02, 0x01, 0x0E, 0x1D, 0x11, 0x6E, 0x71, // "Ů" (U+016E)
  0x01, 0x6F, 0x01, 0x01, 0x0C, 0x18, 0x0E, 0x6E, 0xF3, // "ů" (U+016F)
  0x01, 0x70, 0x02, 0x01, 0x0E, 0x1C, 0x11, 0x6F, 0x6D, // "Ű" (U+0170)
  0x01, 0x71, 0x01, 0x01, 0x0D, 0x17, 0x0E, 0x6F, 0xEF, // "ű" (U+0171)
  0x01, 0x72, 0x02, 0xFA, 0x0E, 0x15, 0x11, 0x70, 0x70, // "Ų" (U+0172)
  0x01, 0x73, 0x01, 0xFA, 0x0C, 0x10, 0x0E, 0x70, 0xED, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x16, 0x1C, 0x16, 0x71, 0x63, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x12, 0x17, 0x13, 0x72, 0x42, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x0C, 0x1C, 0x0D, 0x72, 0xE4, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFA, 0x0B, 0x17, 0x0C, 0x73, 0x5A, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x0C, 0x1A, 0x0D, 0x73, 0xDC, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x0B, 0x1C, 0x0C, 0x74, 0x4D, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x09, 0x17, 0x0A, 0x74, 0xA8, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x0B, 0x1B, 0x0C, 0x74, 0xEF, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x09, 0x16, 0x0A, 0x75, 0x47, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x0B, 0x1C, 0x0C, 0x75, 0x8A, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x09, 0x17, 0x0A, 0x75, 0xEC, // "ž" (U+017E)
  0x01, 0x7F, 0x02, 0x01, 0x08, 0x16, 0x08, 0x76, 0x3B, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x10, 0x15, 0x12, 0x76, 0x7F, // "Ω" (U+03A9)
  0x03, 0xBC, 0x01, 0xFA, 0x0C, 0x10, 0x0F, 0x77, 0x04, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x0E, 0x10, 0x10, 0x77, 0x77, // "π" (U+03C0)
  0x20, 0x13, 0x01, 0x08, 0x0C, 0x0A, 0x0E, 0x77, 0xD6, // "–" (U+2013)
  0x20, 0x14, 0x01, 0x08, 0x1A, 0x0A, 0x1C, 0x77, 0xDB, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x0C, 0x15, 0x0D, 0x77, 0xE0, // "€" (U+20AC)
  0x20, 0xBF, 0x02, 0xFE, 0x0C, 0x18, 0x0D, 0x78, 0x3A, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x0F, 0x04, 0x15, 0x06, 0x78, 0xB8, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x0F, 0x04, 0x15, 0x06, 0x78, 0xCB, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0xFE, 0x04, 0x04, 0x07, 0x78, 0xDE, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x0F, 0x04, 0x15, 0x06, 0x78, 0xF1, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x0F, 0x09, 0x15, 0x0B, 0x79, 0x04, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x0F, 0x09, 0x15, 0x0B, 0x79, 0x2B, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0xFE, 0x09, 0x04, 0x0B, 0x79, 0x51, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x0F, 0x09, 0x15, 0x0B, 0x79, 0x77, // "‟" (U+201F)
  0x20, 0x20, 0x01, 0x01, 0x0B, 0x16, 0x0D, 0x79, 0x9E, // "†" (U+2020)
  0x20, 0x21, 0x01, 0x01, 0x0B, 0x16, 0x0D, 0x79, 0xF1, // "‡" (U+2021)
  0x20, 0x22, 0x01, 0x08, 0x08, 0x0F, 0x0B, 0x7A, 0x49, // "•" (U+2022)
  0x20, 0x26, 0x01, 0x01, 0x13, 0x04, 0x15, 0x7A, 0x61, // "…" (U+2026)
  0x20, 0x30, 0x01, 0x01, 0x1C, 0x15, 0x1D, 0x7A, 0x84, // "‰" (U+2030)
  0x20, 0x39, 0x01, 0x02, 0x07, 0x0E, 0x08, 0x7B, 0x79, // "‹" (U+2039)
  0x20, 0x3A, 0x01, 0x02, 0x07, 0x0E, 0x08, 0x7B, 0xA0, // "›" (U+203A)
  0x20, 0x44, 0xFB, 0x01, 0x07, 0x15, 0x03, 0x7B, 0xC6, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x0B, 0x11, 0x14, 0x13, 0x7C, 0x13, // "™" (U+2122)
  0x21, 0x52, 0x01, 0x00, 0x1B, 0x15, 0x1D, 0x7C, 0x6E, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x0C, 0x16, 0x0F, 0x7D, 0x42, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x0C, 0x16, 0x0F, 0x7D, 0xC4, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x02, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x61, 0x01, // "a (U+0022 U+0061)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x67, 0x01, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0x6D, 0x01, // "m (U+0022 U+006D)
  0x00, 0x22, 0x00, 0x6E, 0x01, // "n (U+0022 U+006E)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x70, 0x01, // "p (U+0022 U+0070)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0x72, 0x01, // "r (U+0022 U+0072)
  0x00, 0x22, 0x00, 0x73, 0x01, // "s (U+0022 U+0073)
  0x00, 0x22, 0x00, 0x75, 0x01, // "u (U+0022 U+0075)
  0x00, 0x22, 0x00, 0xC0, 0x02, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x02, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x02, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x02, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x02, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x02, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x02, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE1, 0x01, // "á (U+0022 U+00E1)
  0x00, 0x22, 0x00, 0xE2, 0x01, // "â (U+0022 U+00E2)
  0x00, 0x22, 0x00, 0xE3, 0x01, // "ã (U+0022 U+00E3)
  0x00, 0x22, 0x00, 0xE4, 0x01, // "ä (U+0022 U+00E4)
  0x00, 0x22, 0x00, 0xE5, 0x01, // "å (U+0022 U+00E5)
  0x00, 0x22, 0x00, 0xE6, 0x01, // "æ (U+0022 U+00E6)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x00, 0xF9, 0x01, // "ù (U+0022 U+00F9)
  0x00, 0x22, 0x00, 0xFA, 0x01, // "ú (U+0022 U+00FA)
  0x00, 0x22, 0x00, 0xFB, 0x01, // "û (U+0022 U+00FB)
  0x00, 0x22, 0x00, 0xFC, 0x01, // "ü (U+0022 U+00FC)
  0x00, 0x22, 0x01, 0x00, 0x02, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x01, 0x01, // "ā (U+0022 U+0101)
  0x00, 0x22, 0x01, 0x02, 0x02, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x03, 0x01, // "ă (U+0022 U+0103)
  0x00, 0x22, 0x01, 0x04, 0x02, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x05, 0x01, // "ą (U+0022 U+0105)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x1D, 0x01, // "ĝ (U+0022 U+011D)
  0x00, 0x22, 0x01, 0x1F, 0x01, // "ğ (U+0022 U+011F)
  0x00, 0x22, 0x01, 0x21, 0x01, // "ġ (U+0022 U+0121)
  0x00, 0x22, 0x01, 0x23, 0x01, // "ģ (U+0022 U+0123)
  0x00, 0x22, 0x01, 0x38, 0x01, // "ĸ (U+0022 U+0138)
  0x00, 0x22, 0x01, 0x44, 0x01, // "ń (U+0022 U+0144)
  0x00, 0x22, 0x01, 0x46, 0x01, // "ņ (U+0022 U+0146)
  0x00, 0x22, 0x01, 0x4B, 0x01, // "ŋ (U+0022 U+014B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x22, 0x01, 0x55, 0x01, // "ŕ (U+0022 U+0155)
  0x00, 0x22, 0x01, 0x57, 0x01, // "ŗ (U+0022 U+0157)
  0x00, 0x22, 0x01, 0x5B, 0x01, // "ś (U+0022 U+015B)
  0x00, 0x22, 0x01, 0x5F, 0x01, // "ş (U+0022 U+015F)
  0x00, 0x22, 0x01, 0x69, 0x01, // "ũ (U+0022 U+0169)
  0x00, 0x22, 0x01, 0x6B, 0x01, // "ū (U+0022 U+016B)
  0x00, 0x22, 0x01, 0x6D, 0x01, // "ŭ (U+0022 U+016D)
  0x00, 0x22, 0x01, 0x6F, 0x01, // "ů (U+0022 U+016F)
  0x00, 0x22, 0x01, 0x71, 0x01, // "ű (U+0022 U+0171)
  0x00, 0x22, 0x01, 0x73, 0x01, // "ų (U+0022 U+0173)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x59, 0x01, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x01, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x62, 0x01, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x01, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x01, // &Ŧ (U+0026 U+0166)
  0x00, 0x26, 0x01, 0x76, 0x01, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x01, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x02, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x61, 0x01, // 'a (U+0027 U+0061)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x67, 0x01, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0x6D, 0x01, // 'm (U+0027 U+006D)
  0x00, 0x27, 0x00, 0x6E, 0x01, // 'n (U+0027 U+006E)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x70, 0x01, // 'p (U+0027 U+0070)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0x72, 0x01, // 'r (U+0027 U+0072)
  0x00, 0x27, 0x00, 0x73, 0x01, // 's (U+0027 U+0073)
  0x00, 0x27, 0x00, 0x75, 0x01, // 'u (U+0027 U+0075)
  0x00, 0x27, 0x00, 0xC0, 0x02, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x02, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x02, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x02, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x02, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x02, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x02, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE1, 0x01, // 'á (U+0027 U+00E1)
  0x00, 0x27, 0x00, 0xE2, 0x01, // 'â (U+0027 U+00E2)
  0x00, 0x27, 0x00, 0xE3, 0x01, // 'ã (U+0027 U+00E3)
  0x00, 0x27, 0x00, 0xE4, 0x01, // 'ä (U+0027 U+00E4)
  0x00, 0x27, 0x00, 0xE5, 0x01, // 'å (U+0027 U+00E5)
  0x00, 0x27, 0x00, 0xE6, 0x01, // 'æ (U+0027 U+00E6)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x00, 0xF9, 0x01, // 'ù (U+0027 U+00F9)
  0x00, 0x27, 0x00, 0xFA, 0x01, // 'ú (U+0027 U+00FA)
  0x00, 0x27, 0x00, 0xFB, 0x01, // 'û (U+0027 U+00FB)
  0x00, 0x27, 0x00, 0xFC, 0x01, // 'ü (U+0027 U+00FC)
  0x00, 0x27, 0x01, 0x00, 0x02, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x01, 0x01, // 'ā (U+0027 U+0101)
  0x00, 0x27, 0x01, 0x02, 0x02, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x03, 0x01, // 'ă (U+0027 U+0103)
  0x00, 0x27, 0x01, 0x04, 0x02, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x05, 0x01, // 'ą (U+0027 U+0105)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x1D, 0x01, // 'ĝ (U+0027 U+011D)
  0x00, 0x27, 0x01, 0x1F, 0x01, // 'ğ (U+0027 U+011F)
  0x00, 0x27, 0x01, 0x21, 0x01, // 'ġ (U+0027 U+0121)
  0x00, 0x27, 0x01, 0x23, 0x01, // 'ģ (U+0027 U+0123)
  0x00, 0x27, 0x01, 0x38, 0x01, // 'ĸ (U+0027 U+0138)
  0x00, 0x27, 0x01, 0x44, 0x01, // 'ń (U+0027 U+0144)
  0x00, 0x27, 0x01, 0x46, 0x01, // 'ņ (U+0027 U+0146)
  0x00, 0x27, 0x01, 0x4B, 0x01, // 'ŋ (U+0027 U+014B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x27, 0x01, 0x55, 0x01, // 'ŕ (U+0027 U+0155)
  0x00, 0x27, 0x01, 0x57, 0x01, // 'ŗ (U+0027 U+0157)
  0x00, 0x27, 0x01, 0x5B, 0x01, // 'ś (U+0027 U+015B)
  0x00, 0x27, 0x01, 0x5F, 0x01, // 'ş (U+0027 U+015F)
  0x00, 0x27, 0x01, 0x69, 0x01, // 'ũ (U+0027 U+0169)
  0x00, 0x27, 0x01, 0x6B, 0x01, // 'ū (U+0027 U+016B)
  0x00, 0x27, 0x01, 0x6D, 0x01, // 'ŭ (U+0027 U+016D)
  0x00, 0x27, 0x01, 0x6F, 0x01, // 'ů (U+0027 U+016F)
  0x00, 0x27, 0x01, 0x71, 0x01, // 'ű (U+0027 U+0171)
  0x00, 0x27, 0x01, 0x73, 0x01, // 'ų (U+0027 U+0173)
  0x00, 0x2C, 0x00, 0x43, 0x01, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x01, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x01, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x01, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x01, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x01, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x01, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x01, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x01, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x01, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x01, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x01, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x01, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x01, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x01, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x01, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x01, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x01, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x01, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x01, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x01, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x01, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x01, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2D, 0x00, 0x54, 0x01, // -T (U+002D U+0054)
  0x00, 0x2D, 0x01, 0x62, 0x01, // -Ţ (U+002D U+0162)
  0x00, 0x2D, 0x01, 0x64, 0x01, // -Ť (U+002D U+0164)
  0x00, 0x2D, 0x01, 0x66, 0x01, // -Ŧ (U+002D U+0166)
  0x00, 0x2E, 0x00, 0x43, 0x01, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x01, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x01, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x01, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x01, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x01, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x01, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x01, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x01, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x01, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x01, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x01, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x01, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x01, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x01, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x01, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x01, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x01, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x01, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x01, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x01, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x01, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x01, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x04, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x04, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x04, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x04, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x04, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x04, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x04, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x04, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x04, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x04, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x02, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x02, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x19, 0x02, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x02, // A” (U+0041 U+201D)
  0x00, 0x43, 0x00, 0x43, 0x01, // CC (U+0043 U+0043)
  0x00, 0x43, 0x00, 0x47, 0x01, // CG (U+0043 U+0047)
  0x00, 0x43, 0x00, 0x4F, 0x01, // CO (U+0043 U+004F)
  0x00, 0x43, 0x00, 0x51, 0x01, // CQ (U+0043 U+0051)
  0x00, 0x43, 0x00, 0xC7, 0x01, // CÇ (U+0043 U+00C7)
  0x00, 0x43, 0x00, 0xD2, 0x01, // CÒ (U+0043 U+00D2)
  0x00, 0x43, 0x00, 0xD3, 0x01, // CÓ (U+0043 U+00D3)
  0x00, 0x43, 0x00, 0xD4, 0x01, // CÔ (U+0043 U+00D4)
  0x00, 0x43, 0x00, 0xD5, 0x01, // CÕ (U+0043 U+00D5)
  0x00, 0x43, 0x00, 0xD6, 0x01, // CÖ (U+0043 U+00D6)
  0x00, 0x43, 0x00, 0xD8, 0x01, // CØ (U+0043 U+00D8)
  0x00, 0x43, 0x01, 0x06, 0x01, // CĆ (U+0043 U+0106)
  0x00, 0x43, 0x01, 0x08, 0x01, // CĈ (U+0043 U+0108)
  0x00, 0x43, 0x01, 0x0A, 0x01, // CĊ (U+0043 U+010A)
  0x00, 0x43, 0x01, 0x0C, 0x01, // CČ (U+0043 U+010C)
  0x00, 0x43, 0x01, 0x1C, 0x01, // CĜ (U+0043 U+011C)
  0x00, 0x43, 0x01, 0x1E, 0x01, // CĞ (U+0043 U+011E)
  0x00, 0x43, 0x01, 0x20, 0x01, // CĠ (U+0043 U+0120)
  0x00, 0x43, 0x01, 0x22, 0x01, // CĢ (U+0043 U+0122)
  0x00, 0x43, 0x01, 0x4C, 0x01, // CŌ (U+0043 U+014C)
  0x00, 0x43, 0x01, 0x4E, 0x01, // CŎ (U+0043 U+014E)
  0x00, 0x43, 0x01, 0x50, 0x01, // CŐ (U+0043 U+0150)
  0x00, 0x43, 0x01, 0x52, 0x01, // CŒ (U+0043 U+0152)
  0x00, 0x44, 0x00, 0x2C, 0x01, // D, (U+0044 U+002C)
  0x00, 0x44, 0x00, 0x2E, 0x01, // D. (U+0044 U+002E)
  0x00, 0x44, 0x20, 0x1A, 0x01, // D‚ (U+0044 U+201A)
  0x00, 0x44, 0x20, 0x1E, 0x01, // D„ (U+0044 U+201E)
  0x00, 0x44, 0x20, 0x26, 0x01, // D… (U+0044 U+2026)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x02, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x02, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x01, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x01, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x62, 0x01, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x01, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x01, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x01, 0x74, 0x01, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x19, 0x02, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x02, // L” (U+004C U+201D)
  0x00, 0x4F, 0x00, 0x2C, 0x01, // O, (U+004F U+002C)
  0x00, 0x4F, 0x00, 0x2E, 0x01, // O. (U+004F U+002E)
  0x00, 0x4F, 0x20, 0x1A, 0x01, // O‚ (U+004F U+201A)
  0x00, 0x4F, 0x20, 0x1E, 0x01, // O„ (U+004F U+201E)
  0x00, 0x4F, 0x20, 0x26, 0x01, // O… (U+004F U+2026)
  0x00, 0x50, 0x00, 0x2C, 0x03, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x03, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x03, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x03, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x03, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x2C, 0x01, // Q, (U+0051 U+002C)
  0x00, 0x51, 0x00, 0x2E, 0x01, // Q. (U+0051 U+002E)
  0x00, 0x51, 0x20, 0x1A, 0x01, // Q‚ (U+0051 U+201A)
  0x00, 0x51, 0x20, 0x1E, 0x01, // Q„ (U+0051 U+201E)
  0x00, 0x51, 0x20, 0x26, 0x01, // Q… (U+0051 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2D, 0x01, // T- (U+0054 U+002D)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x02, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x01, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x01, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x01, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x01, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x01, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x01, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0x7A, 0x01, // Tz (U+0054 U+007A)
  0x00, 0x54, 0x00, 0xAB, 0x01, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xBB, 0x01, // T» (U+0054 U+00BB)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x02, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x02, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x02, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x02, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x02, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x02, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x01, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x01, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x01, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x01, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x02, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x02, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x02, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x01, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x01, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x01, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x4B, 0x01, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x01, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x01, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x01, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5F, 0x01, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x69, 0x01, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x01, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x01, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x01, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x01, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x01, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x01, 0x7A, 0x01, // Tź (U+0054 U+017A)
  0x00, 0x54, 0x01, 0x7C, 0x01, // Tż (U+0054 U+017C)
  0x00, 0x54, 0x01, 0x7E, 0x01, // Tž (U+0054 U+017E)
  0x00, 0x54, 0x20, 0x13, 0x01, // T– (U+0054 U+2013)
  0x00, 0x54, 0x20, 0x14, 0x01, // T— (U+0054 U+2014)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x01, // T‹ (U+0054 U+2039)
  0x00, 0x54, 0x20, 0x3A, 0x01, // T› (U+0054 U+203A)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0xAB, 0x01, // V« (U+0056 U+00AB)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x56, 0x20, 0x39, 0x01, // V‹ (U+0056 U+2039)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0xAB, 0x01, // W« (U+0057 U+00AB)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x57, 0x20, 0x39, 0x01, // W‹ (U+0057 U+2039)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6D, 0x01, // Ym (U+0059 U+006D)
  0x00, 0x59, 0x00, 0x6E, 0x01, // Yn (U+0059 U+006E)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x70, 0x01, // Yp (U+0059 U+0070)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x72, 0x01, // Yr (U+0059 U+0072)
  0x00, 0x59, 0x00, 0x73, 0x01, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0x75, 0x01, // Yu (U+0059 U+0075)
  0x00, 0x59, 0x00, 0xAB, 0x02, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xBB, 0x01, // Y» (U+0059 U+00BB)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x00, 0xF9, 0x01, // Yù (U+0059 U+00F9)
  0x00, 0x59, 0x00, 0xFA, 0x01, // Yú (U+0059 U+00FA)
  0x00, 0x59, 0x00, 0xFB, 0x01, // Yû (U+0059 U+00FB)
  0x00, 0x59, 0x00, 0xFC, 0x01, // Yü (U+0059 U+00FC)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x38, 0x01, // Yĸ (U+0059 U+0138)
  0x00, 0x59, 0x01, 0x44, 0x01, // Yń (U+0059 U+0144)
  0x00, 0x59, 0x01, 0x46, 0x01, // Yņ (U+0059 U+0146)
  0x00, 0x59, 0x01, 0x4B, 0x01, // Yŋ (U+0059 U+014B)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x55, 0x01, // Yŕ (U+0059 U+0155)
  0x00, 0x59, 0x01, 0x57, 0x01, // Yŗ (U+0059 U+0157)
  0x00, 0x59, 0x01, 0x5B, 0x01, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5F, 0x01, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x69, 0x01, // Yũ (U+0059 U+0169)
  0x00, 0x59, 0x01, 0x6B, 0x01, // Yū (U+0059 U+016B)
  0x00, 0x59, 0x01, 0x6D, 0x01, // Yŭ (U+0059 U+016D)
  0x00, 0x59, 0x01, 0x6F, 0x01, // Yů (U+0059 U+016F)
  0x00, 0x59, 0x01, 0x71, 0x01, // Yű (U+0059 U+0171)
  0x00, 0x59, 0x01, 0x73, 0x01, // Yų (U+0059 U+0173)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x02, // Y‹ (U+0059 U+2039)
  0x00, 0x59, 0x20, 0x3A, 0x01, // Y› (U+0059 U+203A)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0x76, 0x00, 0x2C, 0x01, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xA1, 0x00, 0x59, 0x01, // ¡Y (U+00A1 U+0059)
  0x00, 0xA1, 0x00, 0xDD, 0x01, // ¡Ý (U+00A1 U+00DD)
  0x00, 0xA1, 0x01, 0x76, 0x01, // ¡Ŷ (U+00A1 U+0176)
  0x00, 0xA1, 0x01, 0x78, 0x01, // ¡Ÿ (U+00A1 U+0178)
  0x00, 0xAB, 0x00, 0x54, 0x01, // «T (U+00AB U+0054)
  0x00, 0xAB, 0x00, 0x59, 0x01, // «Y (U+00AB U+0059)
  0x00, 0xAB, 0x00, 0xDD, 0x01, // «Ý (U+00AB U+00DD)
  0x00, 0xAB, 0x01, 0x62, 0x01, // «Ţ (U+00AB U+0162)
  0x00, 0xAB, 0x01, 0x64, 0x01, // «Ť (U+00AB U+0164)
  0x00, 0xAB, 0x01, 0x66, 0x01, // «Ŧ (U+00AB U+0166)
  0x00, 0xAB, 0x01, 0x76, 0x01, // «Ŷ (U+00AB U+0176)
  0x00, 0xAB, 0x01, 0x78, 0x01, // «Ÿ (U+00AB U+0178)
  0x00, 0xBB, 0x00, 0x54, 0x01, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x56, 0x01, // »V (U+00BB U+0056)
  0x00, 0xBB, 0x00, 0x57, 0x01, // »W (U+00BB U+0057)
  0x00, 0xBB, 0x00, 0x59, 0x02, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x02, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x01, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x01, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x01, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x74, 0x01, // »Ŵ (U+00BB U+0174)
  0x00, 0xBB, 0x01, 0x76, 0x02, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x02, // »Ÿ (U+00BB U+0178)
  0x00, 0xBF, 0x00, 0x54, 0x01, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x00, 0x56, 0x01, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x01, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x01, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x01, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x62, 0x01, // ¿Ţ (U+00BF U+0162)
  0x00, 0xBF, 0x01, 0x64, 0x01, // ¿Ť (U+00BF U+0164)
  0x00, 0xBF, 0x01, 0x66, 0x01, // ¿Ŧ (U+00BF U+0166)
  0x00, 0xBF, 0x01, 0x74, 0x01, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x01, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x01, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x02, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x02, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x19, 0x02, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x02, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x02, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x02, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x19, 0x02, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x02, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x02, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x02, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x19, 0x02, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x02, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x02, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x02, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x19, 0x02, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x02, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x02, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x02, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x19, 0x02, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x02, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x02, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x02, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x19, 0x02, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x02, // Å” (U+00C5 U+201D)
  0x00, 0xC7, 0x00, 0x43, 0x01, // ÇC (U+00C7 U+0043)
  0x00, 0xC7, 0x00, 0x47, 0x01, // ÇG (U+00C7 U+0047)
  0x00, 0xC7, 0x00, 0x4F, 0x01, // ÇO (U+00C7 U+004F)
  0x00, 0xC7, 0x00, 0x51, 0x01, // ÇQ (U+00C7 U+0051)
  0x00, 0xC7, 0x00, 0xC7, 0x01, // ÇÇ (U+00C7 U+00C7)
  0x00, 0xC7, 0x00, 0xD2, 0x01, // ÇÒ (U+00C7 U+00D2)
  0x00, 0xC7, 0x00, 0xD3, 0x01, // ÇÓ (U+00C7 U+00D3)
  0x00, 0xC7, 0x00, 0xD4, 0x01, // ÇÔ (U+00C7 U+00D4)
  0x00, 0xC7, 0x00, 0xD5, 0x01, // ÇÕ (U+00C7 U+00D5)
  0x00, 0xC7, 0x00, 0xD6, 0x01, // ÇÖ (U+00C7 U+00D6)
  0x00, 0xC7, 0x00, 0xD8, 0x01, // ÇØ (U+00C7 U+00D8)
  0x00, 0xC7, 0x01, 0x06, 0x01, // ÇĆ (U+00C7 U+0106)
  0x00, 0xC7, 0x01, 0x08, 0x01, // ÇĈ (U+00C7 U+0108)
  0x00, 0xC7, 0x01, 0x0A, 0x01, // ÇĊ (U+00C7 U+010A)
  0x00, 0xC7, 0x01, 0x0C, 0x01, // ÇČ (U+00C7 U+010C)
  0x00, 0xC7, 0x01, 0x1C, 0x01, // ÇĜ (U+00C7 U+011C)
  0x00, 0xC7, 0x01, 0x1E, 0x01, // ÇĞ (U+00C7 U+011E)
  0x00, 0xC7, 0x01, 0x20, 0x01, // ÇĠ (U+00C7 U+0120)
  0x00, 0xC7, 0x01, 0x22, 0x01, // ÇĢ (U+00C7 U+0122)
  0x00, 0xC7, 0x01, 0x4C, 0x01, // ÇŌ (U+00C7 U+014C)
  0x00, 0xC7, 0x01, 0x4E, 0x01, // ÇŎ (U+00C7 U+014E)
  0x00, 0xC7, 0x01, 0x50, 0x01, // ÇŐ (U+00C7 U+0150)
  0x00, 0xC7, 0x01, 0x52, 0x01, // ÇŒ (U+00C7 U+0152)
  0x00, 0xD0, 0x00, 0x2C, 0x01, // Ð, (U+00D0 U+002C)
  0x00, 0xD0, 0x00, 0x2E, 0x01, // Ð. (U+00D0 U+002E)
  0x00, 0xD0, 0x20, 0x1A, 0x01, // Ð‚ (U+00D0 U+201A)
  0x00, 0xD0, 0x20, 0x1E, 0x01, // Ð„ (U+00D0 U+201E)
  0x00, 0xD0, 0x20, 0x26, 0x01, // Ð… (U+00D0 U+2026)
  0x00, 0xD2, 0x00, 0x2C, 0x01, // Ò, (U+00D2 U+002C)
  0x00, 0xD2, 0x00, 0x2E, 0x01, // Ò. (U+00D2 U+002E)
  0x00, 0xD2, 0x20, 0x1A, 0x01, // Ò‚ (U+00D2 U+201A)
  0x00, 0xD2, 0x20, 0x1E, 0x01, // Ò„ (U+00D2 U+201E)
  0x00, 0xD2, 0x20, 0x26, 0x01, // Ò… (U+00D2 U+2026)
  0x00, 0xD3, 0x00, 0x2C, 0x01, // Ó, (U+00D3 U+002C)
  0x00, 0xD3, 0x00, 0x2E, 0x01, // Ó. (U+00D3 U+002E)
  0x00, 0xD3, 0x20, 0x1A, 0x01, // Ó‚ (U+00D3 U+201A)
  0x00, 0xD3, 0x20, 0x1E, 0x01, // Ó„ (U+00D3 U+201E)
  0x00, 0xD3, 0x20, 0x26, 0x01, // Ó… (U+00D3 U+2026)
  0x00, 0xD4, 0x00, 0x2C, 0x01, // Ô, (U+00D4 U+002C)
  0x00, 0xD4, 0x00, 0x2E, 0x01, // Ô. (U+00D4 U+002E)
  0x00, 0xD4, 0x20, 0x1A, 0x01, // Ô‚ (U+00D4 U+201A)
  0x00, 0xD4, 0x20, 0x1E, 0x01, // Ô„ (U+00D4 U+201E)
  0x00, 0xD4, 0x20, 0x26, 0x01, // Ô… (U+00D4 U+2026)
  0x00, 0xD5, 0x00, 0x2C, 0x01, // Õ, (U+00D5 U+002C)
  0x00, 0xD5, 0x00, 0x2E, 0x01, // Õ. (U+00D5 U+002E)
  0x00, 0xD5, 0x20, 0x1A, 0x01, // Õ‚ (U+00D5 U+201A)
  0x00, 0xD5, 0x20, 0x1E, 0x01, // Õ„ (U+00D5 U+201E)
  0x00, 0xD5, 0x20, 0x26, 0x01, // Õ… (U+00D5 U+2026)
  0x00, 0xD6, 0x00, 0x2C, 0x01, // Ö, (U+00D6 U+002C)
  0x00, 0xD6, 0x00, 0x2E, 0x01, // Ö. (U+00D6 U+002E)
  0x00, 0xD6, 0x20, 0x1A, 0x01, // Ö‚ (U+00D6 U+201A)
  0x00, 0xD6, 0x20, 0x1E, 0x01, // Ö„ (U+00D6 U+201E)
  0x00, 0xD6, 0x20, 0x26, 0x01, // Ö… (U+00D6 U+2026)
  0x00, 0xD8, 0x00, 0x2C, 0x01, // Ø, (U+00D8 U+002C)
  0x00, 0xD8, 0x00, 0x2E, 0x01, // Ø. (U+00D8 U+002E)
  0x00, 0xD8, 0x20, 0x1A, 0x01, // Ø‚ (U+00D8 U+201A)
  0x00, 0xD8, 0x20, 0x1E, 0x01, // Ø„ (U+00D8 U+201E)
  0x00, 0xD8, 0x20, 0x26, 0x01, // Ø… (U+00D8 U+2026)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6D, 0x01, // Ým (U+00DD U+006D)
  0x00, 0xDD, 0x00, 0x6E, 0x01, // Ýn (U+00DD U+006E)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x70, 0x01, // Ýp (U+00DD U+0070)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x72, 0x01, // Ýr (U+00DD U+0072)
  0x00, 0xDD, 0x00, 0x73, 0x01, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0x75, 0x01, // Ýu (U+00DD U+0075)
  0x00, 0xDD, 0x00, 0xAB, 0x02, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xBB, 0x01, // Ý» (U+00DD U+00BB)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x00, 0xF9, 0x01, // Ýù (U+00DD U+00F9)
  0x00, 0xDD, 0x00, 0xFA, 0x01, // Ýú (U+00DD U+00FA)
  0x00, 0xDD, 0x00, 0xFB, 0x01, // Ýû (U+00DD U+00FB)
  0x00, 0xDD, 0x00, 0xFC, 0x01, // Ýü (U+00DD U+00FC)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x38, 0x01, // Ýĸ (U+00DD U+0138)
  0x00, 0xDD, 0x01, 0x44, 0x01, // Ýń (U+00DD U+0144)
  0x00, 0xDD, 0x01, 0x46, 0x01, // Ýņ (U+00DD U+0146)
  0x00, 0xDD, 0x01, 0x4B, 0x01, // Ýŋ (U+00DD U+014B)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x55, 0x01, // Ýŕ (U+00DD U+0155)
  0x00, 0xDD, 0x01, 0x57, 0x01, // Ýŗ (U+00DD U+0157)
  0x00, 0xDD, 0x01, 0x5B, 0x01, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5F, 0x01, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x69, 0x01, // Ýũ (U+00DD U+0169)
  0x00, 0xDD, 0x01, 0x6B, 0x01, // Ýū (U+00DD U+016B)
  0x00, 0xDD, 0x01, 0x6D, 0x01, // Ýŭ (U+00DD U+016D)
  0x00, 0xDD, 0x01, 0x6F, 0x01, // Ýů (U+00DD U+016F)
  0x00, 0xDD, 0x01, 0x71, 0x01, // Ýű (U+00DD U+0171)
  0x00, 0xDD, 0x01, 0x73, 0x01, // Ýų (U+00DD U+0173)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x02, // Ý‹ (U+00DD U+2039)
  0x00, 0xDD, 0x20, 0x3A, 0x01, // Ý› (U+00DD U+203A)
  0x00, 0xDE, 0x00, 0x2C, 0x03, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x03, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x00, 0x41, 0x01, // ÞA (U+00DE U+0041)
  0x00, 0xDE, 0x00, 0xC0, 0x01, // ÞÀ (U+00DE U+00C0)
  0x00, 0xDE, 0x00, 0xC1, 0x01, // ÞÁ (U+00DE U+00C1)
  0x00, 0xDE, 0x00, 0xC2, 0x01, // ÞÂ (U+00DE U+00C2)
  0x00, 0xDE, 0x00, 0xC3, 0x01, // ÞÃ (U+00DE U+00C3)
  0x00, 0xDE, 0x00, 0xC4, 0x01, // ÞÄ (U+00DE U+00C4)
  0x00, 0xDE, 0x00, 0xC5, 0x01, // ÞÅ (U+00DE U+00C5)
  0x00, 0xDE, 0x00, 0xC6, 0x01, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDE, 0x01, 0x00, 0x01, // ÞĀ (U+00DE U+0100)
  0x00, 0xDE, 0x01, 0x02, 0x01, // ÞĂ (U+00DE U+0102)
  0x00, 0xDE, 0x01, 0x04, 0x01, // ÞĄ (U+00DE U+0104)
  0x00, 0xDE, 0x20, 0x1A, 0x03, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x03, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x03, // Þ… (U+00DE U+2026)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x02, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x02, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x19, 0x02, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x02, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x02, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x02, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x19, 0x02, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x02, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x02, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x02, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x19, 0x02, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x02, // Ą” (U+0104 U+201D)
  0x01, 0x06, 0x00, 0x43, 0x01, // ĆC (U+0106 U+0043)
  0x01, 0x06, 0x00, 0x47, 0x01, // ĆG (U+0106 U+0047)
  0x01, 0x06, 0x00, 0x4F, 0x01, // ĆO (U+0106 U+004F)
  0x01, 0x06, 0x00, 0x51, 0x01, // ĆQ (U+0106 U+0051)
  0x01, 0x06, 0x00, 0xC7, 0x01, // ĆÇ (U+0106 U+00C7)
  0x01, 0x06, 0x00, 0xD2, 0x01, // ĆÒ (U+0106 U+00D2)
  0x01, 0x06, 0x00, 0xD3, 0x01, // ĆÓ (U+0106 U+00D3)
  0x01, 0x06, 0x00, 0xD4, 0x01, // ĆÔ (U+0106 U+00D4)
  0x01, 0x06, 0x00, 0xD5, 0x01, // ĆÕ (U+0106 U+00D5)
  0x01, 0x06, 0x00, 0xD6, 0x01, // ĆÖ (U+0106 U+00D6)
  0x01, 0x06, 0x00, 0xD8, 0x01, // ĆØ (U+0106 U+00D8)
  0x01, 0x06, 0x01, 0x06, 0x01, // ĆĆ (U+0106 U+0106)
  0x01, 0x06, 0x01, 0x08, 0x01, // ĆĈ (U+0106 U+0108)
  0x01, 0x06, 0x01, 0x0A, 0x01, // ĆĊ (U+0106 U+010A)
  0x01, 0x06, 0x01, 0x0C, 0x01, // ĆČ (U+0106 U+010C)
  0x01, 0x06, 0x01, 0x1C, 0x01, // ĆĜ (U+0106 U+011C)
  0x01, 0x06, 0x01, 0x1E, 0x01, // ĆĞ (U+0106 U+011E)
  0x01, 0x06, 0x01, 0x20, 0x01, // ĆĠ (U+0106 U+0120)
  0x01, 0x06, 0x01, 0x22, 0x01, // ĆĢ (U+0106 U+0122)
  0x01, 0x06, 0x01, 0x4C, 0x01, // ĆŌ (U+0106 U+014C)
  0x01, 0x06, 0x01, 0x4E, 0x01, // ĆŎ (U+0106 U+014E)
  0x01, 0x06, 0x01, 0x50, 0x01, // ĆŐ (U+0106 U+0150)
  0x01, 0x06, 0x01, 0x52, 0x01, // ĆŒ (U+0106 U+0152)
  0x01, 0x08, 0x00, 0x43, 0x01, // ĈC (U+0108 U+0043)
  0x01, 0x08, 0x00, 0x47, 0x01, // ĈG (U+0108 U+0047)
  0x01, 0x08, 0x00, 0x4F, 0x01, // ĈO (U+0108 U+004F)
  0x01, 0x08, 0x00, 0x51, 0x01, // ĈQ (U+0108 U+0051)
  0x01, 0x08, 0x00, 0xC7, 0x01, // ĈÇ (U+0108 U+00C7)
  0x01, 0x08, 0x00, 0xD2, 0x01, // ĈÒ (U+0108 U+00D2)
  0x01, 0x08, 0x00, 0xD3, 0x01, // ĈÓ (U+0108 U+00D3)
  0x01, 0x08, 0x00, 0xD4, 0x01, // ĈÔ (U+0108 U+00D4)
  0x01, 0x08, 0x00, 0xD5, 0x01, // ĈÕ (U+0108 U+00D5)
  0x01, 0x08, 0x00, 0xD6, 0x01, // ĈÖ (U+0108 U+00D6)
  0x01, 0x08, 0x00, 0xD8, 0x01, // ĈØ (U+0108 U+00D8)
  0x01, 0x08, 0x01, 0x06, 0x01, // ĈĆ (U+0108 U+0106)
  0x01, 0x08, 0x01, 0x08, 0x01, // ĈĈ (U+0108 U+0108)
  0x01, 0x08, 0x01, 0x0A, 0x01, // ĈĊ (U+0108 U+010A)
  0x01, 0x08, 0x01, 0x0C, 0x01, // ĈČ (U+0108 U+010C)
  0x01, 0x08, 0x01, 0x1C, 0x01, // ĈĜ (U+0108 U+011C)
  0x01, 0x08, 0x01, 0x1E, 0x01, // ĈĞ (U+0108 U+011E)
  0x01, 0x08, 0x01, 0x20, 0x01, // ĈĠ (U+0108 U+0120)
  0x01, 0x08, 0x01, 0x22, 0x01, // ĈĢ (U+0108 U+0122)
  0x01, 0x08, 0x01, 0x4C, 0x01, // ĈŌ (U+0108 U+014C)
  0x01, 0x08, 0x01, 0x4E, 0x01, // ĈŎ (U+0108 U+014E)
  0x01, 0x08, 0x01, 0x50, 0x01, // ĈŐ (U+0108 U+0150)
  0x01, 0x08, 0x01, 0x52, 0x01, // ĈŒ (U+0108 U+0152)
  0x01, 0x0A, 0x00, 0x43, 0x01, // ĊC (U+010A U+0043)
  0x01, 0x0A, 0x00, 0x47, 0x01, // ĊG (U+010A U+0047)
  0x01, 0x0A, 0x00, 0x4F, 0x01, // ĊO (U+010A U+004F)
  0x01, 0x0A, 0x00, 0x51, 0x01, // ĊQ (U+010A U+0051)
  0x01, 0x0A, 0x00, 0xC7, 0x01, // ĊÇ (U+010A U+00C7)
  0x01, 0x0A, 0x00, 0xD2, 0x01, // ĊÒ (U+010A U+00D2)
  0x01, 0x0A, 0x00, 0xD3, 0x01, // ĊÓ (U+010A U+00D3)
  0x01, 0x0A, 0x00, 0xD4, 0x01, // ĊÔ (U+010A U+00D4)
  0x01, 0x0A, 0x00, 0xD5, 0x01, // ĊÕ (U+010A U+00D5)
  0x01, 0x0A, 0x00, 0xD6, 0x01, // ĊÖ (U+010A U+00D6)
  0x01, 0x0A, 0x00, 0xD8, 0x01, // ĊØ (U+010A U+00D8)
  0x01, 0x0A, 0x01, 0x06, 0x01, // ĊĆ (U+010A U+0106)
  0x01, 0x0A, 0x01, 0x08, 0x01, // ĊĈ (U+010A U+0108)
  0x01, 0x0A, 0x01, 0x0A, 0x01, // ĊĊ (U+010A U+010A)
  0x01, 0x0A, 0x01, 0x0C, 0x01, // ĊČ (U+010A U+010C)
  0x01, 0x0A, 0x01, 0x1C, 0x01, // ĊĜ (U+010A U+011C)
  0x01, 0x0A, 0x01, 0x1E, 0x01, // ĊĞ (U+010A U+011E)
  0x01, 0x0A, 0x01, 0x20, 0x01, // ĊĠ (U+010A U+0120)
  0x01, 0x0A, 0x01, 0x22, 0x01, // ĊĢ (U+010A U+0122)
  0x01, 0x0A, 0x01, 0x4C, 0x01, // ĊŌ (U+010A U+014C)
  0x01, 0x0A, 0x01, 0x4E, 0x01, // ĊŎ (U+010A U+014E)
  0x01, 0x0A, 0x01, 0x50, 0x01, // ĊŐ (U+010A U+0150)
  0x01, 0x0A, 0x01, 0x52, 0x01, // ĊŒ (U+010A U+0152)
  0x01, 0x0C, 0x00, 0x43, 0x01, // ČC (U+010C U+0043)
  0x01, 0x0C, 0x00, 0x47, 0x01, // ČG (U+010C U+0047)
  0x01, 0x0C, 0x00, 0x4F, 0x01, // ČO (U+010C U+004F)
  0x01, 0x0C, 0x00, 0x51, 0x01, // ČQ (U+010C U+0051)
  0x01, 0x0C, 0x00, 0xC7, 0x01, // ČÇ (U+010C U+00C7)
  0x01, 0x0C, 0x00, 0xD2, 0x01, // ČÒ (U+010C U+00D2)
  0x01, 0x0C, 0x00, 0xD3, 0x01, // ČÓ (U+010C U+00D3)
  0x01, 0x0C, 0x00, 0xD4, 0x01, // ČÔ (U+010C U+00D4)
  0x01, 0x0C, 0x00, 0xD5, 0x01, // ČÕ (U+010C U+00D5)
  0x01, 0x0C, 0x00, 0xD6, 0x01, // ČÖ (U+010C U+00D6)
  0x01, 0x0C, 0x00, 0xD8, 0x01, // ČØ (U+010C U+00D8)
  0x01, 0x0C, 0x01, 0x06, 0x01, // ČĆ (U+010C U+0106)
  0x01, 0x0C, 0x01, 0x08, 0x01, // ČĈ (U+010C U+0108)
  0x01, 0x0C, 0x01, 0x0A, 0x01, // ČĊ (U+010C U+010A)
  0x01, 0x0C, 0x01, 0x0C, 0x01, // ČČ (U+010C U+010C)
  0x01, 0x0C, 0x01, 0x1C, 0x01, // ČĜ (U+010C U+011C)
  0x01, 0x0C, 0x01, 0x1E, 0x01, // ČĞ (U+010C U+011E)
  0x01, 0x0C, 0x01, 0x20, 0x01, // ČĠ (U+010C U+0120)
  0x01, 0x0C, 0x01, 0x22, 0x01, // ČĢ (U+010C U+0122)
  0x01, 0x0C, 0x01, 0x4C, 0x01, // ČŌ (U+010C U+014C)
  0x01, 0x0C, 0x01, 0x4E, 0x01, // ČŎ (U+010C U+014E)
  0x01, 0x0C, 0x01, 0x50, 0x01, // ČŐ (U+010C U+0150)
  0x01, 0x0C, 0x01, 0x52, 0x01, // ČŒ (U+010C U+0152)
  0x01, 0x0E, 0x00, 0x2C, 0x01, // Ď, (U+010E U+002C)
  0x01, 0x0E, 0x00, 0x2E, 0x01, // Ď. (U+010E U+002E)
  0x01, 0x0E, 0x20, 0x1A, 0x01, // Ď‚ (U+010E U+201A)
  0x01, 0x0E, 0x20, 0x1E, 0x01, // Ď„ (U+010E U+201E)
  0x01, 0x0E, 0x20, 0x26, 0x01, // Ď… (U+010E U+2026)
  0x01, 0x10, 0x00, 0x2C, 0x01, // Đ, (U+0110 U+002C)
  0x01, 0x10, 0x00, 0x2E, 0x01, // Đ. (U+0110 U+002E)
  0x01, 0x10, 0x20, 0x1A, 0x01, // Đ‚ (U+0110 U+201A)
  0x01, 0x10, 0x20, 0x1E, 0x01, // Đ„ (U+0110 U+201E)
  0x01, 0x10, 0x20, 0x26, 0x01, // Đ… (U+0110 U+2026)
  0x01, 0x39, 0x00, 0x22, 0x02, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x02, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x01, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x01, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x62, 0x01, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x01, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x01, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x01, 0x74, 0x01, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x19, 0x02, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x02, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x02, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x02, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x01, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x01, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x62, 0x01, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x01, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x01, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x01, 0x74, 0x01, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x19, 0x02, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x02, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x02, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x02, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x00, 0x54, 0x01, // ĽT (U+013D U+0054)
  0x01, 0x3D, 0x00, 0x56, 0x01, // ĽV (U+013D U+0056)
  0x01, 0x3D, 0x00, 0x57, 0x01, // ĽW (U+013D U+0057)
  0x01, 0x3D, 0x00, 0x59, 0x01, // ĽY (U+013D U+0059)
  0x01, 0x3D, 0x00, 0xDD, 0x01, // ĽÝ (U+013D U+00DD)
  0x01, 0x3D, 0x01, 0x62, 0x01, // ĽŢ (U+013D U+0162)
  0x01, 0x3D, 0x01, 0x64, 0x01, // ĽŤ (U+013D U+0164)
  0x01, 0x3D, 0x01, 0x66, 0x01, // ĽŦ (U+013D U+0166)
  0x01, 0x3D, 0x01, 0x74, 0x01, // ĽŴ (U+013D U+0174)
  0x01, 0x3D, 0x01, 0x76, 0x01, // ĽŶ (U+013D U+0176)
  0x01, 0x3D, 0x01, 0x78, 0x01, // ĽŸ (U+013D U+0178)
  0x01, 0x3D, 0x20, 0x19, 0x02, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x02, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x02, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x02, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x00, 0x54, 0x01, // ĿT (U+013F U+0054)
  0x01, 0x3F, 0x00, 0x56, 0x01, // ĿV (U+013F U+0056)
  0x01, 0x3F, 0x00, 0x57, 0x01, // ĿW (U+013F U+0057)
  0x01, 0x3F, 0x00, 0x59, 0x01, // ĿY (U+013F U+0059)
  0x01, 0x3F, 0x00, 0xDD, 0x01, // ĿÝ (U+013F U+00DD)
  0x01, 0x3F, 0x01, 0x62, 0x01, // ĿŢ (U+013F U+0162)
  0x01, 0x3F, 0x01, 0x64, 0x01, // ĿŤ (U+013F U+0164)
  0x01, 0x3F, 0x01, 0x66, 0x01, // ĿŦ (U+013F U+0166)
  0x01, 0x3F, 0x01, 0x74, 0x01, // ĿŴ (U+013F U+0174)
  0x01, 0x3F, 0x01, 0x76, 0x01, // ĿŶ (U+013F U+0176)
  0x01, 0x3F, 0x01, 0x78, 0x01, // ĿŸ (U+013F U+0178)
  0x01, 0x3F, 0x20, 0x19, 0x02, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x02, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x02, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x02, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x01, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x01, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x62, 0x01, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x01, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x01, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x01, 0x74, 0x01, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x19, 0x02, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x02, // Ł” (U+0141 U+201D)
  0x01, 0x4C, 0x00, 0x2C, 0x01, // Ō, (U+014C U+002C)
  0x01, 0x4C, 0x00, 0x2E, 0x01, // Ō. (U+014C U+002E)
  0x01, 0x4C, 0x20, 0x1A, 0x01, // Ō‚ (U+014C U+201A)
  0x01, 0x4C, 0x20, 0x1E, 0x01, // Ō„ (U+014C U+201E)
  0x01, 0x4C, 0x20, 0x26, 0x01, // Ō… (U+014C U+2026)
  0x01, 0x4E, 0x00, 0x2C, 0x01, // Ŏ, (U+014E U+002C)
  0x01, 0x4E, 0x00, 0x2E, 0x01, // Ŏ. (U+014E U+002E)
  0x01, 0x4E, 0x20, 0x1A, 0x01, // Ŏ‚ (U+014E U+201A)
  0x01, 0x4E, 0x20, 0x1E, 0x01, // Ŏ„ (U+014E U+201E)
  0x01, 0x4E, 0x20, 0x26, 0x01, // Ŏ… (U+014E U+2026)
  0x01, 0x50, 0x00, 0x2C, 0x01, // Ő, (U+0150 U+002C)
  0x01, 0x50, 0x00, 0x2E, 0x01, // Ő. (U+0150 U+002E)
  0x01, 0x50, 0x20, 0x1A, 0x01, // Ő‚ (U+0150 U+201A)
  0x01, 0x50, 0x20, 0x1E, 0x01, // Ő„ (U+0150 U+201E)
  0x01, 0x50, 0x20, 0x26, 0x01, // Ő… (U+0150 U+2026)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2D, 0x01, // Ţ- (U+0162 U+002D)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x02, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x01, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x01, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x01, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x01, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x01, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x01, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0x7A, 0x01, // Ţz (U+0162 U+007A)
  0x01, 0x62, 0x00, 0xAB, 0x01, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xBB, 0x01, // Ţ» (U+0162 U+00BB)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x02, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x02, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x02, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x02, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x02, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x02, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x01, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x01, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x01, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x01, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x02, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x02, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x02, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x01, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x01, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x01, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x4B, 0x01, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x01, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x01, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x01, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5F, 0x01, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x69, 0x01, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x01, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x01, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x01, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x01, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x01, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x01, 0x7A, 0x01, // Ţź (U+0162 U+017A)
  0x01, 0x62, 0x01, 0x7C, 0x01, // Ţż (U+0162 U+017C)
  0x01, 0x62, 0x01, 0x7E, 0x01, // Ţž (U+0162 U+017E)
  0x01, 0x62, 0x20, 0x13, 0x01, // Ţ– (U+0162 U+2013)
  0x01, 0x62, 0x20, 0x14, 0x01, // Ţ— (U+0162 U+2014)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x01, // Ţ‹ (U+0162 U+2039)
  0x01, 0x62, 0x20, 0x3A, 0x01, // Ţ› (U+0162 U+203A)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2D, 0x01, // Ť- (U+0164 U+002D)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x02, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x01, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x01, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x01, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x01, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x01, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x01, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0x7A, 0x01, // Ťz (U+0164 U+007A)
  0x01, 0x64, 0x00, 0xAB, 0x01, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xBB, 0x01, // Ť» (U+0164 U+00BB)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x02, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x02, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x02, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x02, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x02, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x02, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x01, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x01, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x01, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x01, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x02, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x02, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x02, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x01, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x01, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x01, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x4B, 0x01, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x01, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x01, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x01, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5F, 0x01, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x69, 0x01, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x01, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x01, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x01, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x01, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x01, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x01, 0x7A, 0x01, // Ťź (U+0164 U+017A)
  0x01, 0x64, 0x01, 0x7C, 0x01, // Ťż (U+0164 U+017C)
  0x01, 0x64, 0x01, 0x7E, 0x01, // Ťž (U+0164 U+017E)
  0x01, 0x64, 0x20, 0x13, 0x01, // Ť– (U+0164 U+2013)
  0x01, 0x64, 0x20, 0x14, 0x01, // Ť— (U+0164 U+2014)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x01, // Ť‹ (U+0164 U+2039)
  0x01, 0x64, 0x20, 0x3A, 0x01, // Ť› (U+0164 U+203A)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2D, 0x01, // Ŧ- (U+0166 U+002D)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x02, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x01, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x01, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x01, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x01, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x01, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x01, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0x7A, 0x01, // Ŧz (U+0166 U+007A)
  0x01, 0x66, 0x00, 0xAB, 0x01, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xBB, 0x01, // Ŧ» (U+0166 U+00BB)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x02, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x02, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x02, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x02, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x02, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x02, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x01, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x01, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x01, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x01, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x02, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x02, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x02, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x01, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x01, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x01, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x4B, 0x01, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x01, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x01, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x01, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5F, 0x01, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x69, 0x01, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x01, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x01, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x01, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x01, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x01, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x01, 0x7A, 0x01, // Ŧź (U+0166 U+017A)
  0x01, 0x66, 0x01, 0x7C, 0x01, // Ŧż (U+0166 U+017C)
  0x01, 0x66, 0x01, 0x7E, 0x01, // Ŧž (U+0166 U+017E)
  0x01, 0x66, 0x20, 0x13, 0x01, // Ŧ– (U+0166 U+2013)
  0x01, 0x66, 0x20, 0x14, 0x01, // Ŧ— (U+0166 U+2014)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x01, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x66, 0x20, 0x3A, 0x01, // Ŧ› (U+0166 U+203A)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0xAB, 0x01, // Ŵ« (U+0174 U+00AB)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x74, 0x20, 0x39, 0x01, // Ŵ‹ (U+0174 U+2039)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6D, 0x01, // Ŷm (U+0176 U+006D)
  0x01, 0x76, 0x00, 0x6E, 0x01, // Ŷn (U+0176 U+006E)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x70, 0x01, // Ŷp (U+0176 U+0070)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x72, 0x01, // Ŷr (U+0176 U+0072)
  0x01, 0x76, 0x00, 0x73, 0x01, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0x75, 0x01, // Ŷu (U+0176 U+0075)
  0x01, 0x76, 0x00, 0xAB, 0x02, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xBB, 0x01, // Ŷ» (U+0176 U+00BB)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x00, 0xF9, 0x01, // Ŷù (U+0176 U+00F9)
  0x01, 0x76, 0x00, 0xFA, 0x01, // Ŷú (U+0176 U+00FA)
  0x01, 0x76, 0x00, 0xFB, 0x01, // Ŷû (U+0176 U+00FB)
  0x01, 0x76, 0x00, 0xFC, 0x01, // Ŷü (U+0176 U+00FC)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x38, 0x01, // Ŷĸ (U+0176 U+0138)
  0x01, 0x76, 0x01, 0x44, 0x01, // Ŷń (U+0176 U+0144)
  0x01, 0x76, 0x01, 0x46, 0x01, // Ŷņ (U+0176 U+0146)
  0x01, 0x76, 0x01, 0x4B, 0x01, // Ŷŋ (U+0176 U+014B)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x55, 0x01, // Ŷŕ (U+0176 U+0155)
  0x01, 0x76, 0x01, 0x57, 0x01, // Ŷŗ (U+0176 U+0157)
  0x01, 0x76, 0x01, 0x5B, 0x01, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5F, 0x01, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x69, 0x01, // Ŷũ (U+0176 U+0169)
  0x01, 0x76, 0x01, 0x6B, 0x01, // Ŷū (U+0176 U+016B)
  0x01, 0x76, 0x01, 0x6D, 0x01, // Ŷŭ (U+0176 U+016D)
  0x01, 0x76, 0x01, 0x6F, 0x01, // Ŷů (U+0176 U+016F)
  0x01, 0x76, 0x01, 0x71, 0x01, // Ŷű (U+0176 U+0171)
  0x01, 0x76, 0x01, 0x73, 0x01, // Ŷų (U+0176 U+0173)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x02, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x76, 0x20, 0x3A, 0x01, // Ŷ› (U+0176 U+203A)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6D, 0x01, // Ÿm (U+0178 U+006D)
  0x01, 0x78, 0x00, 0x6E, 0x01, // Ÿn (U+0178 U+006E)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x70, 0x01, // Ÿp (U+0178 U+0070)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x72, 0x01, // Ÿr (U+0178 U+0072)
  0x01, 0x78, 0x00, 0x73, 0x01, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0x75, 0x01, // Ÿu (U+0178 U+0075)
  0x01, 0x78, 0x00, 0xAB, 0x02, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xBB, 0x01, // Ÿ» (U+0178 U+00BB)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x00, 0xF9, 0x01, // Ÿù (U+0178 U+00F9)
  0x01, 0x78, 0x00, 0xFA, 0x01, // Ÿú (U+0178 U+00FA)
  0x01, 0x78, 0x00, 0xFB, 0x01, // Ÿû (U+0178 U+00FB)
  0x01, 0x78, 0x00, 0xFC, 0x01, // Ÿü (U+0178 U+00FC)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x38, 0x01, // Ÿĸ (U+0178 U+0138)
  0x01, 0x78, 0x01, 0x44, 0x01, // Ÿń (U+0178 U+0144)
  0x01, 0x78, 0x01, 0x46, 0x01, // Ÿņ (U+0178 U+0146)
  0x01, 0x78, 0x01, 0x4B, 0x01, // Ÿŋ (U+0178 U+014B)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x55, 0x01, // Ÿŕ (U+0178 U+0155)
  0x01, 0x78, 0x01, 0x57, 0x01, // Ÿŗ (U+0178 U+0157)
  0x01, 0x78, 0x01, 0x5B, 0x01, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5F, 0x01, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x69, 0x01, // Ÿũ (U+0178 U+0169)
  0x01, 0x78, 0x01, 0x6B, 0x01, // Ÿū (U+0178 U+016B)
  0x01, 0x78, 0x01, 0x6D, 0x01, // Ÿŭ (U+0178 U+016D)
  0x01, 0x78, 0x01, 0x6F, 0x01, // Ÿů (U+0178 U+016F)
  0x01, 0x78, 0x01, 0x71, 0x01, // Ÿű (U+0178 U+0171)
  0x01, 0x78, 0x01, 0x73, 0x01, // Ÿų (U+0178 U+0173)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x02, // Ÿ‹ (U+0178 U+2039)
  0x01, 0x78, 0x20, 0x3A, 0x01, // Ÿ› (U+0178 U+203A)
  0x20, 0x13, 0x00, 0x54, 0x01, // –T (U+2013 U+0054)
  0x20, 0x13, 0x01, 0x62, 0x01, // –Ţ (U+2013 U+0162)
  0x20, 0x13, 0x01, 0x64, 0x01, // –Ť (U+2013 U+0164)
  0x20, 0x13, 0x01, 0x66, 0x01, // –Ŧ (U+2013 U+0166)
  0x20, 0x14, 0x00, 0x54, 0x01, // —T (U+2014 U+0054)
  0x20, 0x14, 0x01, 0x62, 0x01, // —Ţ (U+2014 U+0162)
  0x20, 0x14, 0x01, 0x64, 0x01, // —Ť (U+2014 U+0164)
  0x20, 0x14, 0x01, 0x66, 0x01, // —Ŧ (U+2014 U+0166)
  0x20, 0x18, 0x00, 0x41, 0x02, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x61, 0x01, // ‘a (U+2018 U+0061)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x67, 0x01, // ‘g (U+2018 U+0067)
  0x20, 0x18, 0x00, 0x6D, 0x01, // ‘m (U+2018 U+006D)
  0x20, 0x18, 0x00, 0x6E, 0x01, // ‘n (U+2018 U+006E)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x70, 0x01, // ‘p (U+2018 U+0070)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0x72, 0x01, // ‘r (U+2018 U+0072)
  0x20, 0x18, 0x00, 0x73, 0x01, // ‘s (U+2018 U+0073)
  0x20, 0x18, 0x00, 0x75, 0x01, // ‘u (U+2018 U+0075)
  0x20, 0x18, 0x00, 0xC0, 0x02, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x02, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x02, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x02, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x02, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x02, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x02, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE1, 0x01, // ‘á (U+2018 U+00E1)
  0x20, 0x18, 0x00, 0xE2, 0x01, // ‘â (U+2018 U+00E2)
  0x20, 0x18, 0x00, 0xE3, 0x01, // ‘ã (U+2018 U+00E3)
  0x20, 0x18, 0x00, 0xE4, 0x01, // ‘ä (U+2018 U+00E4)
  0x20, 0x18, 0x00, 0xE5, 0x01, // ‘å (U+2018 U+00E5)
  0x20, 0x18, 0x00, 0xE6, 0x01, // ‘æ (U+2018 U+00E6)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x00, 0xF9, 0x01, // ‘ù (U+2018 U+00F9)
  0x20, 0x18, 0x00, 0xFA, 0x01, // ‘ú (U+2018 U+00FA)
  0x20, 0x18, 0x00, 0xFB, 0x01, // ‘û (U+2018 U+00FB)
  0x20, 0x18, 0x00, 0xFC, 0x01, // ‘ü (U+2018 U+00FC)
  0x20, 0x18, 0x01, 0x00, 0x02, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x01, 0x01, // ‘ā (U+2018 U+0101)
  0x20, 0x18, 0x01, 0x02, 0x02, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x03, 0x01, // ‘ă (U+2018 U+0103)
  0x20, 0x18, 0x01, 0x04, 0x02, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x05, 0x01, // ‘ą (U+2018 U+0105)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x1D, 0x01, // ‘ĝ (U+2018 U+011D)
  0x20, 0x18, 0x01, 0x1F, 0x01, // ‘ğ (U+2018 U+011F)
  0x20, 0x18, 0x01, 0x21, 0x01, // ‘ġ (U+2018 U+0121)
  0x20, 0x18, 0x01, 0x23, 0x01, // ‘ģ (U+2018 U+0123)
  0x20, 0x18, 0x01, 0x38, 0x01, // ‘ĸ (U+2018 U+0138)
  0x20, 0x18, 0x01, 0x44, 0x01, // ‘ń (U+2018 U+0144)
  0x20, 0x18, 0x01, 0x46, 0x01, // ‘ņ (U+2018 U+0146)
  0x20, 0x18, 0x01, 0x4B, 0x01, // ‘ŋ (U+2018 U+014B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x18, 0x01, 0x55, 0x01, // ‘ŕ (U+2018 U+0155)
  0x20, 0x18, 0x01, 0x57, 0x01, // ‘ŗ (U+2018 U+0157)
  0x20, 0x18, 0x01, 0x5B, 0x01, // ‘ś (U+2018 U+015B)
  0x20, 0x18, 0x01, 0x5F, 0x01, // ‘ş (U+2018 U+015F)
  0x20, 0x18, 0x01, 0x69, 0x01, // ‘ũ (U+2018 U+0169)
  0x20, 0x18, 0x01, 0x6B, 0x01, // ‘ū (U+2018 U+016B)
  0x20, 0x18, 0x01, 0x6D, 0x01, // ‘ŭ (U+2018 U+016D)
  0x20, 0x18, 0x01, 0x6F, 0x01, // ‘ů (U+2018 U+016F)
  0x20, 0x18, 0x01, 0x71, 0x01, // ‘ű (U+2018 U+0171)
  0x20, 0x18, 0x01, 0x73, 0x01, // ‘ų (U+2018 U+0173)
  0x20, 0x19, 0x00, 0x41, 0x02, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x61, 0x01, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x67, 0x01, // ’g (U+2019 U+0067)
  0x20, 0x19, 0x00, 0x6D, 0x01, // ’m (U+2019 U+006D)
  0x20, 0x19, 0x00, 0x6E, 0x01, // ’n (U+2019 U+006E)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x70, 0x01, // ’p (U+2019 U+0070)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0x72, 0x01, // ’r (U+2019 U+0072)
  0x20, 0x19, 0x00, 0x73, 0x01, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0x75, 0x01, // ’u (U+2019 U+0075)
  0x20, 0x19, 0x00, 0xC0, 0x02, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x02, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x02, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x02, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x02, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x02, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x02, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x01, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x01, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x01, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x01, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x01, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x01, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x00, 0xF9, 0x01, // ’ù (U+2019 U+00F9)
  0x20, 0x19, 0x00, 0xFA, 0x01, // ’ú (U+2019 U+00FA)
  0x20, 0x19, 0x00, 0xFB, 0x01, // ’û (U+2019 U+00FB)
  0x20, 0x19, 0x00, 0xFC, 0x01, // ’ü (U+2019 U+00FC)
  0x20, 0x19, 0x01, 0x00, 0x02, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x01, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x02, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x01, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x02, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x01, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x1D, 0x01, // ’ĝ (U+2019 U+011D)
  0x20, 0x19, 0x01, 0x1F, 0x01, // ’ğ (U+2019 U+011F)
  0x20, 0x19, 0x01, 0x21, 0x01, // ’ġ (U+2019 U+0121)
  0x20, 0x19, 0x01, 0x23, 0x01, // ’ģ (U+2019 U+0123)
  0x20, 0x19, 0x01, 0x38, 0x01, // ’ĸ (U+2019 U+0138)
  0x20, 0x19, 0x01, 0x44, 0x01, // ’ń (U+2019 U+0144)
  0x20, 0x19, 0x01, 0x46, 0x01, // ’ņ (U+2019 U+0146)
  0x20, 0x19, 0x01, 0x4B, 0x01, // ’ŋ (U+2019 U+014B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x19, 0x01, 0x55, 0x01, // ’ŕ (U+2019 U+0155)
  0x20, 0x19, 0x01, 0x57, 0x01, // ’ŗ (U+2019 U+0157)
  0x20, 0x19, 0x01, 0x5B, 0x01, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5F, 0x01, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x69, 0x01, // ’ũ (U+2019 U+0169)
  0x20, 0x19, 0x01, 0x6B, 0x01, // ’ū (U+2019 U+016B)
  0x20, 0x19, 0x01, 0x6D, 0x01, // ’ŭ (U+2019 U+016D)
  0x20, 0x19, 0x01, 0x6F, 0x01, // ’ů (U+2019 U+016F)
  0x20, 0x19, 0x01, 0x71, 0x01, // ’ű (U+2019 U+0171)
  0x20, 0x19, 0x01, 0x73, 0x01, // ’ų (U+2019 U+0173)
  0x20, 0x1A, 0x00, 0x43, 0x01, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x01, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x01, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x01, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x01, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x01, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x01, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x01, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x01, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x01, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x01, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x01, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x01, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x01, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x01, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x01, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x01, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x01, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x01, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x01, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x01, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x01, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x01, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x02, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x61, 0x01, // “a (U+201C U+0061)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x67, 0x01, // “g (U+201C U+0067)
  0x20, 0x1C, 0x00, 0x6D, 0x01, // “m (U+201C U+006D)
  0x20, 0x1C, 0x00, 0x6E, 0x01, // “n (U+201C U+006E)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x70, 0x01, // “p (U+201C U+0070)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0x72, 0x01, // “r (U+201C U+0072)
  0x20, 0x1C, 0x00, 0x73, 0x01, // “s (U+201C U+0073)
  0x20, 0x1C, 0x00, 0x75, 0x01, // “u (U+201C U+0075)
  0x20, 0x1C, 0x00, 0xC0, 0x02, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x02, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x02, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x02, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x02, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x02, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x02, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE1, 0x01, // “á (U+201C U+00E1)
  0x20, 0x1C, 0x00, 0xE2, 0x01, // “â (U+201C U+00E2)
  0x20, 0x1C, 0x00, 0xE3, 0x01, // “ã (U+201C U+00E3)
  0x20, 0x1C, 0x00, 0xE4, 0x01, // “ä (U+201C U+00E4)
  0x20, 0x1C, 0x00, 0xE5, 0x01, // “å (U+201C U+00E5)
  0x20, 0x1C, 0x00, 0xE6, 0x01, // “æ (U+201C U+00E6)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x00, 0xF9, 0x01, // “ù (U+201C U+00F9)
  0x20, 0x1C, 0x00, 0xFA, 0x01, // “ú (U+201C U+00FA)
  0x20, 0x1C, 0x00, 0xFB, 0x01, // “û (U+201C U+00FB)
  0x20, 0x1C, 0x00, 0xFC, 0x01, // “ü (U+201C U+00FC)
  0x20, 0x1C, 0x01, 0x00, 0x02, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x01, 0x01, // “ā (U+201C U+0101)
  0x20, 0x1C, 0x01, 0x02, 0x02, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x03, 0x01, // “ă (U+201C U+0103)
  0x20, 0x1C, 0x01, 0x04, 0x02, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x05, 0x01, // “ą (U+201C U+0105)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x1D, 0x01, // “ĝ (U+201C U+011D)
  0x20, 0x1C, 0x01, 0x1F, 0x01, // “ğ (U+201C U+011F)
  0x20, 0x1C, 0x01, 0x21, 0x01, // “ġ (U+201C U+0121)
  0x20, 0x1C, 0x01, 0x23, 0x01, // “ģ (U+201C U+0123)
  0x20, 0x1C, 0x01, 0x38, 0x01, // “ĸ (U+201C U+0138)
  0x20, 0x1C, 0x01, 0x44, 0x01, // “ń (U+201C U+0144)
  0x20, 0x1C, 0x01, 0x46, 0x01, // “ņ (U+201C U+0146)
  0x20, 0x1C, 0x01, 0x4B, 0x01, // “ŋ (U+201C U+014B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1C, 0x01, 0x55, 0x01, // “ŕ (U+201C U+0155)
  0x20, 0x1C, 0x01, 0x57, 0x01, // “ŗ (U+201C U+0157)
  0x20, 0x1C, 0x01, 0x5B, 0x01, // “ś (U+201C U+015B)
  0x20, 0x1C, 0x01, 0x5F, 0x01, // “ş (U+201C U+015F)
  0x20, 0x1C, 0x01, 0x69, 0x01, // “ũ (U+201C U+0169)
  0x20, 0x1C, 0x01, 0x6B, 0x01, // “ū (U+201C U+016B)
  0x20, 0x1C, 0x01, 0x6D, 0x01, // “ŭ (U+201C U+016D)
  0x20, 0x1C, 0x01, 0x6F, 0x01, // “ů (U+201C U+016F)
  0x20, 0x1C, 0x01, 0x71, 0x01, // “ű (U+201C U+0171)
  0x20, 0x1C, 0x01, 0x73, 0x01, // “ų (U+201C U+0173)
  0x20, 0x1D, 0x00, 0x41, 0x02, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x61, 0x01, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x67, 0x01, // ”g (U+201D U+0067)
  0x20, 0x1D, 0x00, 0x6D, 0x01, // ”m (U+201D U+006D)
  0x20, 0x1D, 0x00, 0x6E, 0x01, // ”n (U+201D U+006E)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x70, 0x01, // ”p (U+201D U+0070)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0x72, 0x01, // ”r (U+201D U+0072)
  0x20, 0x1D, 0x00, 0x73, 0x01, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0x75, 0x01, // ”u (U+201D U+0075)
  0x20, 0x1D, 0x00, 0xC0, 0x02, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x02, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x02, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x02, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x02, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x02, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x02, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x01, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x01, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x01, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x01, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x01, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x01, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x00, 0xF9, 0x01, // ”ù (U+201D U+00F9)
  0x20, 0x1D, 0x00, 0xFA, 0x01, // ”ú (U+201D U+00FA)
  0x20, 0x1D, 0x00, 0xFB, 0x01, // ”û (U+201D U+00FB)
  0x20, 0x1D, 0x00, 0xFC, 0x01, // ”ü (U+201D U+00FC)
  0x20, 0x1D, 0x01, 0x00, 0x02, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x01, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x02, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x01, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x02, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x01, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x1D, 0x01, // ”ĝ (U+201D U+011D)
  0x20, 0x1D, 0x01, 0x1F, 0x01, // ”ğ (U+201D U+011F)
  0x20, 0x1D, 0x01, 0x21, 0x01, // ”ġ (U+201D U+0121)
  0x20, 0x1D, 0x01, 0x23, 0x01, // ”ģ (U+201D U+0123)
  0x20, 0x1D, 0x01, 0x38, 0x01, // ”ĸ (U+201D U+0138)
  0x20, 0x1D, 0x01, 0x44, 0x01, // ”ń (U+201D U+0144)
  0x20, 0x1D, 0x01, 0x46, 0x01, // ”ņ (U+201D U+0146)
  0x20, 0x1D, 0x01, 0x4B, 0x01, // ”ŋ (U+201D U+014B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1D, 0x01, 0x55, 0x01, // ”ŕ (U+201D U+0155)
  0x20, 0x1D, 0x01, 0x57, 0x01, // ”ŗ (U+201D U+0157)
  0x20, 0x1D, 0x01, 0x5B, 0x01, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5F, 0x01, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x69, 0x01, // ”ũ (U+201D U+0169)
  0x20, 0x1D, 0x01, 0x6B, 0x01, // ”ū (U+201D U+016B)
  0x20, 0x1D, 0x01, 0x6D, 0x01, // ”ŭ (U+201D U+016D)
  0x20, 0x1D, 0x01, 0x6F, 0x01, // ”ů (U+201D U+016F)
  0x20, 0x1D, 0x01, 0x71, 0x01, // ”ű (U+201D U+0171)
  0x20, 0x1D, 0x01, 0x73, 0x01, // ”ų (U+201D U+0173)
  0x20, 0x1E, 0x00, 0x43, 0x01, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x01, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x01, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x01, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x01, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x01, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x01, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x01, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x01, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x01, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x01, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x01, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x01, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x01, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x01, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x01, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x01, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x01, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x01, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x01, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x01, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x01, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x01, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x39, 0x00, 0x54, 0x01, // ‹T (U+2039 U+0054)
  0x20, 0x39, 0x00, 0x59, 0x01, // ‹Y (U+2039 U+0059)
  0x20, 0x39, 0x00, 0xDD, 0x01, // ‹Ý (U+2039 U+00DD)
  0x20, 0x39, 0x01, 0x62, 0x01, // ‹Ţ (U+2039 U+0162)
  0x20, 0x39, 0x01, 0x64, 0x01, // ‹Ť (U+2039 U+0164)
  0x20, 0x39, 0x01, 0x66, 0x01, // ‹Ŧ (U+2039 U+0166)
  0x20, 0x39, 0x01, 0x76, 0x01, // ‹Ŷ (U+2039 U+0176)
  0x20, 0x39, 0x01, 0x78, 0x01, // ‹Ÿ (U+2039 U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x01, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x56, 0x01, // ›V (U+203A U+0056)
  0x20, 0x3A, 0x00, 0x57, 0x01, // ›W (U+203A U+0057)
  0x20, 0x3A, 0x00, 0x59, 0x02, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x02, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x01, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x01, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x01, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x74, 0x01, // ›Ŵ (U+203A U+0174)
  0x20, 0x3A, 0x01, 0x76, 0x02, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x02, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x04, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x04, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x04, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x04, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x04, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x04, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x04, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x04, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x04, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x04, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x01, 0xB0, 0x20, 0x1B, 0x01, 0x1B, 0x2B, 0x20, 0xEA, 0x28, 0x1E, 0xFE, 0x28, 0x1D, 0xFD, 0x28,
  0x1C, 0xFD, 0x28, 0x1C, 0xFC, 0x28, 0x1B, 0xFC, 0x28, 0x1B, 0xFB, 0x28, 0x1A, 0xFA, 0x28, 0x19,
  0xFA, 0x28, 0x19, 0xF9, 0x28, 0x18, 0xF9, 0x75, 0x83, 0xAE, 0xA0, 0x3B, 0x00, 0x3B, 0x83, 0x30,
  0xAE, 0xA1,
  // """ (U+0022)
  0x05, 0xA8, 0x19, 0x03, 0xA0, 0xB0, 0x4A, 0x81, 0x80, 0x2A, 0x0A, 0x03, 0xA8, 0x17, 0x01, 0xA0,
  0x90, 0x2A, 0x06, 0x2A, 0x08, 0x01, 0xA0, 0x52, 0x81, 0xEF, 0x71, 0xA0, 0x42, 0x81, 0xDF, 0x61,
  0xA0, 0x32, 0x85, 0xCF, 0x50, 0xEF, 0x22, 0x81, 0xBF, 0x50,
  // "#" (U+0023)
  0x58, 0x1C, 0xF5, 0x28, 0x1C, 0xF4, 0x78, 0x1E, 0xF2, 0x28, 0x1E, 0xF2, 0x7A, 0x3A, 0x78, 0x12,
  0xFE, 0x28, 0x12, 0xFD, 0x78, 0x14, 0xFC, 0x28, 0x15, 0xFB, 0x78, 0x17, 0xFA, 0x28, 0x17, 0xF9,
  0x40, 0xAF, 0xD8, 0x13, 0x0A, 0xFD, 0x89, 0x53, 0x01, 0x22, 0xEF, 0x52, 0x2E, 0xF4, 0x22, 0x5A,
  0x01, 0x2A, 0x01, 0x68, 0x12, 0xFE, 0x28, 0x12, 0xFE, 0x78, 0x14, 0xFC, 0x28, 0x15, 0xFC, 0x48,
  0x96, 0x26, 0x6A, 0xFC, 0x66, 0xAF, 0xC6, 0x63, 0x06, 0xFD, 0x81, 0x70, 0x6F, 0xD0, 0x74, 0x81,
  0xCF, 0x32, 0x81, 0xDF, 0x37, 0x81, 0xEF, 0x12, 0xA0, 0x16, 0x81, 0x1F, 0xE2, 0x81, 0x2F, 0xE7,
  0x81, 0x3F, 0xC2, 0x81, 0x4F, 0xC7, 0x81, 0x6F, 0xA2, 0x81, 0x6F, 0xA7, 0x81, 0x8F, 0x82, 0x81,
  0x9F, 0x85,
  // "$" (U+0024)
  0x48, 0x11, 0xF8, 0x72, 0x81, 0x1F, 0x87, 0x18, 0x41, 0x5F, 0xC7, 0x45, 0x08, 0xE0, 0xE0, 0x62,
  0x0B, 0xF9, 0x81, 0x80, 0x5A, 0x89, 0x6B, 0x3F, 0x82, 0x5B, 0x30, 0x9F, 0xE0, 0x1F, 0x85, 0x85,
  0xAF, 0xC0, 0x1F, 0x85, 0x85, 0x9F, 0xE0, 0x1F, 0x85, 0x05, 0xA8, 0x2C, 0x3F, 0x86, 0x0B, 0xC0,
  0x97, 0x08, 0xC0, 0xD0, 0x56, 0x02, 0x09, 0xC0, 0xA6, 0x82, 0x1F, 0xCD, 0xA0, 0x95, 0x83, 0x1F,
  0x80, 0xBA, 0x58, 0x31, 0xF8, 0x04, 0xA0, 0x34, 0x83, 0x1F, 0x80, 0x4A, 0x81, 0x26, 0x32, 0x89,
  0x61, 0xF8, 0x0C, 0xFE, 0x0A, 0xFD, 0x97, 0xFD, 0xDA, 0x81, 0x80, 0xAF, 0x90, 0xA2, 0x82, 0x17,
  0xBE, 0xA8, 0x1E, 0xA4, 0x78, 0x11, 0xF8, 0x72, 0x81, 0x1F, 0x87, 0x28, 0x11, 0xF8, 0x50,
  // "%" (U+0025)
  0x18, 0x31, 0xBE, 0xD6, 0x68, 0x1B, 0xF7, 0x50, 0xCC, 0x06, 0x40, 0x2A, 0x01, 0x40, 0x5A, 0x82,
  0x8C, 0xFE, 0x48, 0x18, 0xFA, 0x58, 0x39, 0xFA, 0x02, 0xA0, 0x33, 0x81, 0xEF, 0x45, 0x81, 0xCF,
  0x62, 0x81, 0xDF, 0x62, 0x81, 0x5F, 0xD6, 0x81, 0xDF, 0x52, 0x81, 0xCF, 0x72, 0x81, 0xBF, 0x76,
  0x81, 0xDF, 0x52, 0x83, 0xBF, 0x80, 0x2A, 0x01, 0x68, 0x1D, 0xF5, 0x28, 0x5B, 0xF7, 0x08, 0xFA,
  0x78, 0x1B, 0xF7, 0x28, 0x92, 0xDF, 0x60, 0xEF, 0x40, 0x9E, 0xE8, 0x28, 0x39, 0xFA, 0x01, 0xA8,
  0x43, 0x5F, 0xD0, 0xAC, 0x81, 0x80, 0x4A, 0x87, 0x8B, 0xFE, 0x0B, 0xF7, 0x2A, 0x04, 0x05, 0xA8,
  0x11, 0x0C, 0xC0, 0x60, 0x2A, 0x82, 0x17, 0xFB, 0x28, 0x97, 0xDF, 0x60, 0x1A, 0xED, 0x70, 0x8F,
  0xA0, 0x9F, 0x92, 0x81, 0xAF, 0x97, 0x85, 0xEF, 0x40, 0xAF, 0x82, 0x81, 0x9F, 0xA6, 0x81, 0x5F,
  0xD2, 0x81, 0xBF, 0x72, 0x81, 0x9F, 0xB6, 0x81, 0xBF, 0x72, 0x81, 0xAF, 0x82, 0x81, 0x9F, 0xA5,
  0x02, 0xA0, 0x12, 0x81, 0x9F, 0x92, 0x81, 0xBF, 0x95, 0x81, 0x8F, 0xB3, 0x81, 0x6F, 0xD2, 0x81,
  0xEF, 0x65, 0x81, 0xEF, 0x43, 0x01, 0xA0, 0x90, 0xAA, 0x01, 0x48, 0x15, 0xFD, 0x50, 0x9C, 0x09,
  0x58, 0x1B, 0xF7, 0x68, 0x29, 0xEE, 0x82,
  // "&" (U+0026)
  0x38, 0x45, 0xCF, 0xEA, 0x27, 0x10, 0x7D, 0x0E, 0x02, 0x60, 0x1A, 0x81, 0xE8, 0xAA, 0x09, 0x60,
  0x5A, 0x06, 0x28, 0x1D, 0xFD, 0x60, 0x6A, 0x03, 0x28, 0x1A, 0xFE, 0x60, 0x5A, 0x04, 0x28, 0x1B,
  0xFD, 0x60, 0x2A, 0x07, 0x28, 0x1E, 0xFA, 0x78, 0x3D, 0xFD, 0x08, 0xA0, 0x47, 0x06, 0xA0, 0xCA,
  0x0A, 0x72, 0x0D, 0xB0, 0xB7, 0x20, 0x50, 0xEB, 0x03, 0x71, 0x06, 0xA0, 0xEA, 0x0C, 0x30, 0xAA,
  0x02, 0x03, 0xA8, 0x1D, 0x18, 0xA0, 0x92, 0x83, 0xDF, 0xE0, 0xAA, 0x04, 0x20, 0xCA, 0x05, 0x02,
  0xA8, 0x3A, 0x0E, 0xFE, 0x38, 0x32, 0xEF, 0xEA, 0xA0, 0x51, 0xA0, 0xD4, 0x05, 0xC0, 0xD2, 0xA0,
  0xE5, 0x09, 0xB0, 0x52, 0x0C, 0xA0, 0x63, 0x01, 0x0D, 0xB0, 0x72, 0x06, 0xB8, 0x29, 0x79, 0xED,
  0x04, 0x20, 0xAF, 0x07, 0x05, 0xA0, 0xE0, 0x12, 0x85, 0x6C, 0xEE, 0xD9, 0x22, 0x0A, 0xA0, 0xB0,
  // "'" (U+0027)
  0x05, 0xA0, 0x90, 0x4A, 0x08, 0x03, 0xA0, 0x70, 0x2A, 0x06, 0x01, 0xA0, 0x51, 0xA0, 0x41, 0xA8,
  0x33, 0x0E, 0xF2,
  // "(" (U+0028)
  0x38, 0x21, 0xEF, 0x63, 0x81, 0xAF, 0xD3, 0x04, 0xA0, 0x43, 0x81, 0xCF, 0xD3, 0x03, 0xA0, 0x73,
  0x09, 0xA0, 0x13, 0x81, 0xEF, 0xC3, 0x02, 0xA0, 0x83, 0x05, 0xA0, 0x53, 0x08, 0xA0, 0x23, 0x09,
  0xA0, 0x13, 0x0A, 0xA4, 0x0B, 0xA4, 0x0A, 0xA4, 0x0A, 0xA0, 0x13, 0x08, 0xA0, 0x23, 0x06, 0xA0,
  0x53, 0x03, 0xA0, 0x84, 0x81, 0xEF, 0xC4, 0x0A, 0xA0, 0x13, 0x03, 0xA0, 0x64, 0x81, 0xCF, 0xC4,
  0x05, 0xA0, 0x44, 0x81, 0xBF, 0xC4, 0x82, 0x1E, 0xF6,
  // ")" (U+0029)
  0x82, 0x1E, 0xF7, 0x50, 0x6A, 0x02, 0x58, 0x1D, 0xFB, 0x50, 0x6A, 0x03, 0x40, 0x1A, 0x09, 0x58,
  0x1A, 0xFE, 0x50, 0x5A, 0x05, 0x40, 0x2A, 0x09, 0x58, 0x1E, 0xFC, 0x58, 0x1B, 0xFE, 0x50, 0xAA,
  0x01, 0x40, 0x9A, 0x02, 0x40, 0x8A, 0x02, 0x40, 0x9A, 0x02, 0x40, 0xAA, 0x01, 0x40, 0xBA, 0x58,
  0x1E, 0xFC, 0x40, 0x2A, 0x09, 0x40, 0x5A, 0x06, 0x40, 0x9A, 0x01, 0x48, 0x1E, 0xFA, 0x40, 0x6A,
  0x04, 0x48, 0x1C, 0xFC, 0x40, 0x6A, 0x02, 0x48, 0x1E, 0xF7, 0x40,
  // "*" (U+002A)
  0x4A, 0x0A, 0x71, 0x81, 0xDF, 0x87, 0x18, 0x1C, 0xF6, 0x48, 0x92, 0x78, 0x30, 0xAF, 0x40, 0x5A,
  0x4C, 0xA8, 0x2E, 0xDF, 0xCB, 0x81, 0x7D, 0xEF, 0x0E, 0x08, 0x30, 0x8B, 0x03, 0x50, 0x3A, 0x81,
  0xAF, 0xC5, 0x82, 0xDF, 0xA1, 0xA0, 0x93, 0x09, 0xA8, 0x13, 0x09, 0xA0, 0x43, 0x08, 0x0B, 0x28,
  0x12, 0xD5, 0x20,
  // "+" (U+002B)
  0x48, 0x16, 0xFD, 0x72, 0x81, 0x6F, 0xD7, 0x28, 0x16, 0xFD, 0x72, 0x81, 0x6F, 0xD7, 0x28, 0x16,
  0xFD, 0x72, 0x81, 0x6F, 0xD5, 0xFC, 0x06, 0xFC, 0x80, 0x16, 0x86, 0xAF, 0xE6, 0x66, 0x63, 0x48,
  0x16, 0xFD, 0x72, 0x81, 0x6F, 0xD7, 0x28, 0x16, 0xFD, 0x72, 0x81, 0x6F, 0xD7, 0x28, 0x16, 0xFD,
  0x50,
  // "," (U+002C)
  0x10, 0xCA, 0x85, 0x30, 0xEF, 0xE0, 0x1A, 0x81, 0xA0, 0x3A, 0x81, 0x60, 0x6A, 0x83, 0x10, 0x9F,
  0xA2, 0x81, 0xDF, 0x52,
  // "-" (U+002D)
  0x01, 0x80, 0x26, 0x00, 0x2E, 0x06, 0x02, 0xE0, 0x60,
  // "." (U+002E)
  0x18, 0x3A, 0xE9, 0x03, 0xB0, 0x20, 0x3B, 0x83, 0x20, 0xAE, 0x91,
  // "/" (U+002F)
  0x70, 0x5A, 0x03, 0x78, 0x1A, 0xFD, 0x70, 0x1A, 0x07, 0x70, 0x6A, 0x02, 0x78, 0x1B, 0xFC, 0x70,
  0x1A, 0x06, 0x70, 0x7A, 0x01, 0x78, 0x1C, 0xFB, 0x70, 0x2A, 0x05, 0x70, 0x8A, 0x71, 0x81, 0xDF,
  0xA7, 0x03, 0xA0, 0x57, 0x81, 0x9F, 0xE7, 0x18, 0x1E, 0xF9, 0x70, 0x4A, 0x04, 0x78, 0x1A, 0xFD,
  0x71, 0x81, 0xEF, 0x87, 0x05, 0xA0, 0x37, 0x81, 0xBF, 0xD7, 0x01, 0xA0, 0x77, 0x06, 0xA0, 0x27,
  // "0" (U+0030)
  0x38, 0x47, 0xCE, 0xD9, 0x15, 0x0A, 0xD0, 0xE0, 0x23, 0x06, 0xA8, 0x1D, 0x7A, 0xA0, 0xB3, 0x82,
  0xDF, 0xE1, 0x20, 0xAA, 0x81, 0x30, 0x3A, 0x09, 0x30, 0x3A, 0x81, 0x80, 0x6A, 0x05, 0x48, 0x3E,
  0xFC, 0x09, 0xA0, 0x34, 0x0C, 0xA1, 0x0B, 0xA0, 0x14, 0x0A, 0xA0, 0x10, 0xCA, 0x50, 0x9A, 0x03,
  0x0C, 0xA5, 0x09, 0xA0, 0x30, 0xDA, 0x50, 0x8A, 0x03, 0x0D, 0xA5, 0x09, 0xA0, 0x30, 0xCA, 0x50,
  0x9A, 0x02, 0x0B, 0xA0, 0x14, 0x0A, 0xA0, 0x10, 0x9A, 0x03, 0x40, 0xCA, 0x10, 0x7A, 0x05, 0x48,
  0x3E, 0xFC, 0x03, 0xA0, 0x93, 0x03, 0xA0, 0x92, 0x82, 0xEF, 0xE1, 0x20, 0xAA, 0x04, 0x20, 0x7A,
  0x81, 0xD7, 0xAA, 0x0C, 0x40, 0xBD, 0x0E, 0x03, 0x58, 0x47, 0xDF, 0xEA, 0x23,
  // "1" (U+0031)
  0x40, 0xAA, 0x04, 0x30, 0x9B, 0x04, 0x20, 0x9C, 0x81, 0x40, 0x9A, 0x0E, 0xA0, 0x40, 0x9A, 0x0B,
  0x08, 0xA8, 0x44, 0xCF, 0xB0, 0x8A, 0x81, 0x41, 0x92, 0x08, 0xA0, 0x44, 0x08, 0xA0, 0x44, 0x08,
  0xA0, 0x44, 0x08, 0xA0, 0x44, 0x08, 0xA0, 0x44, 0x08, 0xA0, 0x44, 0x08, 0xA0, 0x44, 0x08, 0xA0,
  0x44, 0x08, 0xA0, 0x44, 0x08, 0xA0, 0x44, 0x08, 0xA0, 0x44, 0x08, 0xA0, 0x44, 0x08, 0xA0, 0x44,
  0x08, 0xA0, 0x44, 0x08, 0xA0, 0x40,
  // "2" (U+0032)
  0x28, 0x56, 0xBE, 0xFD, 0x92, 0x30, 0x20, 0xDE, 0x0E, 0x03, 0x20, 0x9A, 0x82, 0xC7, 0x7C, 0xA0,
  0xD2, 0x81, 0x1D, 0x64, 0x0C, 0xA0, 0x57, 0x10, 0x5A, 0x08, 0x71, 0x03, 0xA0, 0x97, 0x10, 0x4A,
  0x08, 0x71, 0x07, 0xA0, 0x67, 0x10, 0xCA, 0x02, 0x70, 0x4A, 0x0B, 0x71, 0x0C, 0xA0, 0x47, 0x07,
  0xA0, 0xA7, 0x03, 0xA0, 0xE0, 0x16, 0x01, 0x0D, 0xA0, 0x47, 0x0A, 0xA0, 0x77, 0x06, 0xA0, 0xB7,
  0x83, 0x2E, 0xFD, 0x17, 0x0C, 0xA0, 0x37, 0x09, 0xA0, 0xC8, 0x03, 0x61, 0xFC, 0x01, 0xFC, 0x01,
  // "3" (U+0033)
  0x18, 0x61, 0x7C, 0xEF, 0xDA, 0x32, 0x05, 0x0E, 0xF8, 0x15, 0x09, 0xA8, 0x2B, 0x77, 0xCA, 0x83,
  0xE1, 0x0B, 0x34, 0x0B, 0xA0, 0x67, 0x04, 0xA0, 0x97, 0x02, 0xA0, 0x97, 0x05, 0xA0, 0x67, 0x82,
  0xCF, 0xE1, 0x48, 0x11, 0x4C, 0xA0, 0x63, 0x07, 0xC0, 0xC0, 0x44, 0x07, 0xC0, 0xB0, 0x54, 0x83,
  0x36, 0x79, 0xEA, 0x0A, 0x70, 0x10, 0xBA, 0x08, 0x70, 0x2A, 0x0D, 0x71, 0x0E, 0xA7, 0x10, 0xEA,
  0x70, 0x2A, 0x0E, 0x06, 0x60, 0xBA, 0x86, 0x9E, 0xEA, 0x77, 0x8D, 0xA8, 0x1E, 0x2E, 0xF8, 0x92,
  0xE4, 0x04, 0x9C, 0xDF, 0xEC, 0x81, 0x20,
  // "4" (U+0034)
  0x70, 0x6A, 0x0B, 0x72, 0x0D, 0xA0, 0xB7, 0x10, 0x6B, 0x0B, 0x71, 0x0E, 0xB0, 0xB7, 0x84, 0x7F,
  0xAE, 0xFB, 0x68, 0x21, 0xEF, 0x4A, 0x0B, 0x68, 0x18, 0xFC, 0x1A, 0x0B, 0x58, 0x21, 0xEF, 0x41,
  0xA0, 0xB5, 0x81, 0x8F, 0xC2, 0xA0, 0xB4, 0x01, 0xA0, 0x42, 0xA0, 0xB4, 0x81, 0x9F, 0xB3, 0xA0,
  0xB3, 0x02, 0xA0, 0x43, 0xA0, 0xB3, 0x81, 0xAF, 0xB4, 0xA0, 0xB2, 0x02, 0xA0, 0x34, 0xA0, 0xB2,
  0x07, 0xFD, 0x07, 0xFD, 0x03, 0x80, 0x37, 0xA8, 0x1D, 0x77, 0x71, 0xA0, 0xB7, 0x3A, 0x0B, 0x73,
  0xA0, 0xB7, 0x3A, 0x0B, 0x20,
  // "5" (U+0035)
  0x10, 0xAF, 0x0E, 0x30, 0xBF, 0x0E, 0x38, 0x1C, 0xFD, 0x80, 0x26, 0x38, 0x1D, 0xFA, 0x72, 0x81,
  0xEF, 0x97, 0x2A, 0x08, 0x71, 0x01, 0xA0, 0x77, 0x10, 0x2A, 0x06, 0x71, 0x03, 0xA8, 0x4D, 0xDF,
  0xEB, 0x43, 0x04, 0xF9, 0x07, 0x38, 0x49, 0xC8, 0x78, 0xDB, 0x03, 0x71, 0x0A, 0xA0, 0xA7, 0x10,
  0x1A, 0x0E, 0x72, 0x0D, 0xA0, 0x17, 0x10, 0xCA, 0x01, 0x71, 0x0E, 0xA7, 0x10, 0x3A, 0x82, 0xC0,
  0x42, 0x50, 0xCA, 0x87, 0x70, 0x8F, 0xB8, 0x78, 0xDA, 0x0D, 0x20, 0x8F, 0x0D, 0x02, 0x28, 0x61,
  0x8C, 0xEF, 0xEC, 0x74,
  // "6" (U+0036)
  0x48, 0x53, 0x9D, 0xEE, 0xD1, 0x40, 0x8E, 0x02, 0x30, 0x7B, 0x83, 0xA7, 0x79, 0x22, 0x02, 0xA0,
  0xD0, 0x27, 0x09, 0xA0, 0x37, 0x18, 0x1E, 0xFB, 0x71, 0x03, 0xA0, 0x67, 0x10, 0x6A, 0x83, 0x20,
  0x36, 0x54, 0x08, 0xA0, 0x10, 0xBB, 0x0E, 0x04, 0x28, 0x2A, 0xFE, 0xAE, 0x81, 0x20, 0xBB, 0x82,
  0x71, 0x19, 0xA8, 0x1A, 0x0B, 0xA0, 0x94, 0x0E, 0xA1, 0x0B, 0xA0, 0x34, 0x0A, 0xA0, 0x30, 0xAA,
  0x01, 0x40, 0x8A, 0x04, 0x09, 0xA0, 0x24, 0x07, 0xA0, 0x40, 0x6A, 0x05, 0x40, 0x8A, 0x00, 0x3A,
  0x09, 0x40, 0xCA, 0x20, 0xDA, 0x02, 0x20, 0x3A, 0x0B, 0x20, 0x5A, 0x82, 0xE8, 0x8E, 0xA0, 0x33,
  0x08, 0xE0, 0x75, 0x84, 0x5B, 0xEE, 0xB4, 0x30,
  // "7" (U+0037)
  0xFC, 0x05, 0xFC, 0x05, 0x80, 0x46, 0x0C, 0xA0, 0x27, 0x18, 0x1D, 0xFD, 0x71, 0x04, 0xA0, 0x77,
  0x10, 0x9A, 0x02, 0x71, 0x81, 0xEF, 0xC7, 0x10, 0x5A, 0x07, 0x71, 0x0A, 0xA0, 0x27, 0x01, 0xA0,
  0xC7, 0x10, 0x6A, 0x06, 0x71, 0x0B, 0xA0, 0x17, 0x01, 0xA0, 0xB7, 0x10, 0x7A, 0x06, 0x71, 0x0C,
  0xA0, 0x17, 0x02, 0xA0, 0xB7, 0x10, 0x8A, 0x06, 0x71, 0x0D, 0xA0, 0x17, 0x03, 0xA0, 0xB7, 0x10,
  0x9A, 0x05, 0x71, 0x0E, 0xA7,
  // "8" (U+0038)
  0x28, 0x51, 0x9D, 0xFE, 0xB5, 0x40, 0x30, 0xEE, 0x0A, 0x30, 0xDA, 0x81, 0xC7, 0x9B, 0x81, 0x50,
  0x4A, 0x0B, 0x30, 0x4A, 0x81, 0xB0, 0x6A, 0x05, 0x48, 0x3E, 0xFD, 0x05, 0xA0, 0x54, 0x83, 0xDF,
  0xC0, 0x2A, 0x09, 0x30, 0x2A, 0x09, 0x20, 0xCA, 0x04, 0x20, 0xBA, 0x03, 0x20, 0x20, 0xEA, 0x08,
  0x0C, 0xA0, 0x74, 0x03, 0x0E, 0xB0, 0xE0, 0x65, 0x03, 0x0D, 0xB0, 0xE0, 0x54, 0x04, 0xA8, 0x1E,
  0x7E, 0xA0, 0x82, 0x86, 0x1E, 0xFD, 0x10, 0x1C, 0xA8, 0x17, 0x08, 0xA0, 0x33, 0x01, 0x0E, 0xA8,
  0x21, 0xCF, 0xD5, 0x07, 0xA8, 0x25, 0xEF, 0xC5, 0x05, 0xA8, 0x26, 0xDF, 0xE5, 0x07, 0xA0, 0x50,
  0xAA, 0x06, 0x30, 0x10, 0xEA, 0x01, 0x03, 0xB8, 0x2A, 0x78, 0xEA, 0x09, 0x20, 0x7F, 0x0B, 0x48,
  0x53, 0xAD, 0xFE, 0xC6, 0x30,
  // "9" (U+0039)
  0x28, 0x51, 0x9D, 0xFD, 0x81, 0x40, 0x30, 0xED, 0x0D, 0x01, 0x30, 0xDA, 0x81, 0xA7, 0xBA, 0x0B,
  0x20, 0x5A, 0x09, 0x30, 0xBA, 0x81, 0x30, 0xAA, 0x02, 0x30, 0x2A, 0x83, 0x90, 0xDF, 0xE5, 0x85,
  0xDF, 0xD0, 0xEF, 0xE5, 0x0B, 0xA1, 0x0D, 0xA5, 0x0B, 0xA0, 0x10, 0xCA, 0x02, 0x40, 0xEA, 0x02,
  0x08, 0xA0, 0x83, 0x07, 0xB0, 0x02, 0xB8, 0x3A, 0x7A, 0xFE, 0xA8, 0x11, 0x07, 0xD0, 0xB0, 0x9A,
  0x38, 0x76, 0xCF, 0xE9, 0x0A, 0xFE, 0x72, 0x81, 0xDF, 0xC7, 0x10, 0x1A, 0x08, 0x71, 0x06, 0xA0,
  0x47, 0x18, 0x1D, 0xFE, 0x71, 0x0A, 0xA0, 0x73, 0x83, 0x97, 0x78, 0xDA, 0x0C, 0x40, 0xDD, 0x0B,
  0x01, 0x48, 0x4A, 0xEF, 0xDB, 0x55,
  // ":" (U+003A)
  0x18, 0x3A, 0xE9, 0x03, 0xB0, 0x20, 0x3B, 0x83, 0x20, 0xAE, 0x98, 0x0C, 0x60, 0x83, 0xAE, 0x90,
  0x3B, 0x02, 0x03, 0xB8, 0x32, 0x0A, 0xE9, 0x10,
  // ";" (U+003B)
  0x18, 0x3A, 0xE9, 0x03, 0xB0, 0x20, 0x3B, 0x83, 0x20, 0xAE, 0x98, 0x0C, 0x60, 0x0C, 0xA8, 0x52,
  0x0E, 0xFE, 0x01, 0xA8, 0x19, 0x04, 0xA8, 0x35, 0x07, 0xFE, 0x28, 0x1B, 0xF9, 0x28, 0x1E, 0xF4,
  0x20,
  // "<" (U+003C)
  0x73, 0x01, 0x03, 0x71, 0x82, 0x18, 0xF7, 0x68, 0x11, 0x8E, 0xA0, 0x64, 0x81, 0x18, 0xEA, 0x0D,
  0x06, 0x40, 0x70, 0xEA, 0x0D, 0x05, 0x40, 0x70, 0xEA, 0x0D, 0x05, 0x50, 0xEA, 0x0D, 0x05, 0x7B,
  0x0B, 0x03, 0x70, 0x10, 0x9B, 0x0C, 0x04, 0x70, 0x10, 0x9B, 0x0C, 0x05, 0x70, 0x10, 0x9B, 0x0D,
  0x06, 0x70, 0x10, 0x9B, 0x07, 0x71, 0x82, 0x19, 0xF7, 0x73, 0x01, 0x03,
  // "=" (U+003D)
  0x80, 0x76, 0x02, 0xFC, 0x06, 0xFC, 0x06, 0x80, 0xC0, 0x08, 0x07, 0x60, 0x2F, 0xC0, 0x6F, 0xC0,
  0x60,
  // ">" (U+003E)
  0x04, 0x74, 0x90, 0xC0, 0x47, 0x2B, 0x0C, 0x04, 0x70, 0x20, 0xAB, 0x0B, 0x03, 0x70, 0x20, 0xAB,
  0x0B, 0x03, 0x70, 0x20, 0x9B, 0x0A, 0x03, 0x70, 0x20, 0x9B, 0x06, 0x68, 0x11, 0x7E, 0xA0, 0x74,
  0x81, 0x18, 0xEA, 0x0C, 0x05, 0x30, 0x20, 0x9B, 0x0C, 0x05, 0x30, 0x20, 0xAB, 0x0C, 0x05, 0x5B,
  0x0C, 0x05, 0x79, 0x0C, 0x05, 0x72, 0x04, 0x74,
  // "?" (U+003F)
  0x18, 0x53, 0x9D, 0xFE, 0xC5, 0x20, 0x7F, 0x86, 0x80, 0x3F, 0xE9, 0x79, 0xB8, 0x13, 0x05, 0x40,
  0x6A, 0x08, 0x60, 0x1A, 0x0A, 0x60, 0x1A, 0x09, 0x60, 0x4A, 0x07, 0x60, 0xCA, 0x02, 0x50, 0x9A,
  0x09, 0x50, 0x6A, 0x0C, 0x50, 0x2A, 0x0D, 0x01, 0x50, 0x8A, 0x02, 0x68, 0x1C, 0xFA, 0x78, 0x1D,
  0xF6, 0x78, 0x18, 0x93, 0x77, 0x75, 0x82, 0x1C, 0xE7, 0x60, 0x6B, 0x60, 0x6B, 0x68, 0x21, 0xCE,
  0x74,
  // "@" (U+0040)
  0x68, 0x64, 0xAD, 0xFE, 0xD9, 0x27, 0x20, 0x20, 0xBF, 0x90, 0x87, 0x02, 0x0E, 0xA8, 0x3E, 0x97,
  0x8A, 0xB0, 0x95, 0x01, 0x0D, 0xA0, 0x65, 0x01, 0x0A, 0xA0, 0x64, 0x82, 0xAF, 0xE3, 0x71, 0x82,
  0x9F, 0xE1, 0x20, 0x2A, 0x05, 0x28, 0x91, 0x3B, 0xEE, 0xC7, 0x10, 0xEF, 0x72, 0x81, 0x9F, 0xC2,
  0x04, 0xE8, 0x35, 0x07, 0xFC, 0x28, 0x1E, 0xF5, 0x28, 0x3D, 0xFE, 0x78, 0xA8, 0x15, 0x02, 0xA0,
  0x10, 0x3A, 0x81, 0x10, 0x5A, 0x02, 0x28, 0x1E, 0xF4, 0x28, 0x4E, 0xF3, 0x5F, 0xC2, 0x81, 0xAF,
  0xB3, 0xA0, 0x42, 0x84, 0xDF, 0x57, 0xFA, 0x28, 0x1C, 0xF7, 0x20, 0x1A, 0x03, 0x28, 0x4B, 0xF6,
  0x9F, 0x92, 0x81, 0xDF, 0x52, 0x01, 0xA0, 0x22, 0x84, 0xCF, 0x59, 0xF8, 0x28, 0x1E, 0xF5, 0x20,
  0x3A, 0x02, 0x28, 0x4D, 0xF4, 0x8F, 0x92, 0x81, 0xDF, 0x62, 0x06, 0xA0, 0x12, 0xA8, 0x21, 0x8F,
  0xA2, 0x81, 0xAF, 0xA2, 0x0A, 0xA8, 0x73, 0x05, 0xFD, 0x06, 0xFD, 0x20, 0x6A, 0x89, 0x29, 0x9F,
  0x9F, 0xC7, 0xEF, 0x70, 0x3A, 0x02, 0x20, 0xDB, 0x81, 0xD1, 0xCB, 0x0D, 0x38, 0x1E, 0xF9, 0x28,
  0x91, 0x2B, 0xEC, 0x30, 0x2C, 0xEB, 0x23, 0x08, 0xA0, 0x27, 0x71, 0x83, 0x1E, 0xFE, 0x27, 0x71,
  0x06, 0xA8, 0x1E, 0x83, 0x28, 0x21, 0x36, 0xB7, 0x10, 0x6F, 0xB7, 0x20, 0x30, 0xBE, 0x0D, 0x06,
  0x74, 0x84, 0x14, 0x56, 0x52, 0x70,
  // "A" (U+0041)
  0x50, 0x7B, 0x02, 0x73, 0x0B, 0xB0, 0x67, 0x3C, 0x0A, 0x72, 0x04, 0xA8, 0x1A, 0xFE, 0x72, 0x08,
  0xA0, 0x5A, 0x03, 0x71, 0x82, 0xCF, 0xC1, 0xA0, 0x87, 0x01, 0xA8, 0x38, 0x0D, 0xFC, 0x70, 0x5A,
  0x81, 0x50, 0x9A, 0x01, 0x60, 0x9A, 0x81, 0x10, 0x5A, 0x05, 0x68, 0x1D, 0xFD, 0x20, 0x2A, 0x09,
  0x50, 0x2A, 0x09, 0x38, 0x1D, 0xFD, 0x50, 0x6A, 0x05, 0x30, 0xAA, 0x02, 0x40, 0xBA, 0x83, 0xBA,
  0xAA, 0xCA, 0x06, 0x40, 0xEF, 0xA0, 0xA3, 0x03, 0xFB, 0x0E, 0x30, 0x8A, 0x07, 0x50, 0xBA, 0x03,
  0x20, 0xCA, 0x03, 0x50, 0x7A, 0x81, 0x80, 0x1A, 0x0E, 0x60, 0x3A, 0x81, 0xC0, 0x5A, 0x0A, 0x70,
  0xEA, 0x01, 0x09, 0xA0, 0x67, 0x0A, 0xA0, 0x50, 0xDA, 0x02, 0x70, 0x6A, 0x09,
  // "B" (U+0042)
  0x0C, 0xD8, 0x1E, 0xB7, 0x30, 0xCF, 0x98, 0x2D, 0x20, 0xCA, 0x82, 0x76, 0x79, 0xB8, 0x1D, 0x0C,
  0xA4, 0x02, 0x0E, 0xA0, 0x30, 0xCA, 0x50, 0x9A, 0x06, 0x0C, 0xA5, 0x07, 0xA0, 0x60, 0xCA, 0x50,
  0x8A, 0x05, 0x0C, 0xA5, 0x0D, 0xA0, 0x10, 0xCA, 0x30, 0x20, 0xAA, 0x81, 0x80, 0xCF, 0x0E, 0x08,
  0x20, 0xCF, 0x0D, 0x06, 0x20, 0xCA, 0x83, 0x76, 0x79, 0xDA, 0x81, 0xA0, 0xCA, 0x50, 0xCA, 0x06,
  0x0C, 0xA5, 0x04, 0xA0, 0xB0, 0xCA, 0x50, 0x1A, 0x0D, 0x0C, 0xA5, 0x01, 0xA0, 0xD0, 0xCA, 0x50,
  0x4A, 0x00, 0xCA, 0x50, 0xCA, 0x07, 0x0C, 0xA8, 0x37, 0x66, 0x8D, 0xA8, 0x1E, 0x1C, 0xF9, 0x82,
  0xE4, 0x0C, 0xE8, 0x1D, 0x92, 0x20,
  // "C" (U+0043)
  0x48, 0x61, 0x8C, 0xEF, 0xDA, 0x54, 0x04, 0x0E, 0xF0, 0x52, 0x03, 0x0E, 0xA8, 0x4C, 0x87, 0xAF,
  0xE3, 0x0D, 0xA0, 0x94, 0x01, 0x06, 0x20, 0x5A, 0x0C, 0x72, 0x0C, 0xA0, 0x47, 0x2A, 0x0E, 0x72,
  0x04, 0xA0, 0xB7, 0x20, 0x6A, 0x08, 0x72, 0x07, 0xA0, 0x77, 0x20, 0x8A, 0x06, 0x72, 0x07, 0xA0,
  0x77, 0x20, 0x6A, 0x08, 0x72, 0x04, 0xA0, 0xA7, 0x20, 0x2A, 0x0D, 0x73, 0x0D, 0xA0, 0x37, 0x20,
  0x8A, 0x0B, 0x72, 0x01, 0x0E, 0xA0, 0x85, 0x01, 0x30, 0x5B, 0x84, 0xD8, 0x79, 0xCE, 0x40, 0x6F,
  0x0E, 0x58, 0x62, 0x8D, 0xEE, 0xDA, 0x51,
  // "D" (U+0044)
  0x0C, 0xC8, 0x2E, 0xDA, 0x45, 0x0C, 0xF9, 0x0B, 0x01, 0x30, 0xCA, 0x82, 0x76, 0x7A, 0xB0, 0xC3,
  0x0C, 0xA4, 0x02, 0x0D, 0xA0, 0x82, 0x0C, 0xA5, 0x02, 0xB8, 0x11, 0x0C, 0xA6, 0x0A, 0xA8, 0x16,
  0x0C, 0xA6, 0x05, 0xA8, 0x1A, 0x0C, 0xA6, 0x02, 0xA8, 0x1D, 0x0C, 0xA7, 0xB1, 0x0C, 0xA7, 0x0E,
  0xA1, 0x0C, 0xA7, 0x0E, 0xA0, 0x10, 0xCA, 0x70, 0xEA, 0x10, 0xCA, 0x7A, 0x81, 0xE0, 0xCA, 0x60,
  0x2A, 0x81, 0xC0, 0xCA, 0x60, 0x6A, 0x81, 0x90, 0xCA, 0x60, 0xBA, 0x81, 0x50, 0xCA, 0x50, 0x4A,
  0x0E, 0x20, 0xCA, 0x40, 0x30, 0xEA, 0x06, 0x20, 0xCA, 0x82, 0x76, 0x7B, 0xB0, 0xA3, 0x0C, 0xF9,
  0x09, 0x40, 0xCC, 0x82, 0xED, 0x93, 0x50,
  // "E" (U+0045)
  0x0C, 0xF9, 0x05, 0x0C, 0xF9, 0x05, 0x0C, 0xA0, 0x78, 0x01, 0x60, 0x20, 0xCA, 0x70, 0xCA, 0x70,
  0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCF, 0x81, 0xE0, 0xCF, 0x81, 0xE0, 0xCA, 0x07,
  0x80, 0x16, 0x10, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA,
  0x07, 0x80, 0x16, 0x02, 0x0C, 0xF9, 0x05, 0x0C, 0xF9, 0x05,
  // "F" (U+0046)
  0x0C, 0xF9, 0x04, 0x0C, 0xF9, 0x04, 0x0C, 0xA0, 0x78, 0x01, 0x60, 0x20, 0xCA, 0x70, 0xCA, 0x70,
  0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCF, 0x81, 0xE0, 0xCF, 0x81, 0xE0,
  0xCA, 0x07, 0x80, 0x16, 0x10, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA,
  0x70, 0xCA, 0x70, 0xCA, 0x70,
  // "G" (U+0047)
  0x58, 0x15, 0xAD, 0xA8, 0x1D, 0xA5, 0x50, 0x10, 0xCF, 0x90, 0xD3, 0x01, 0x0D, 0xA8, 0x6E, 0xA7,
  0x79, 0xEF, 0x83, 0x0C, 0xA0, 0xB0, 0x15, 0x06, 0x02, 0x20, 0x5A, 0x0D, 0x01, 0x73, 0x0B, 0xA0,
  0x57, 0x4A, 0x0E, 0x74, 0x04, 0xA0, 0xB7, 0x40, 0x6A, 0x08, 0x74, 0x07, 0xA0, 0x74, 0x04, 0x80,
  0x16, 0x01, 0x08, 0xA0, 0x64, 0x0A, 0xD0, 0x40, 0x7A, 0x07, 0x40, 0xAD, 0x04, 0x06, 0xA0, 0x87,
  0x08, 0xA0, 0x04, 0xA0, 0xB7, 0x08, 0xA0, 0x40, 0x1A, 0x0E, 0x70, 0x8A, 0x81, 0x40, 0xCA, 0x04,
  0x60, 0x8A, 0x81, 0x40, 0x7A, 0x0C, 0x60, 0x8A, 0x04, 0x20, 0xDA, 0x09, 0x50, 0x8A, 0x04, 0x20,
  0x4B, 0x84, 0xD8, 0x77, 0x9E, 0xA0, 0x43, 0x04, 0x0E, 0xFA, 0x04, 0x48, 0x90, 0x17, 0xCE, 0xFE,
  0xCB, 0x73, 0x10,
  // "H" (U+0048)
  0x0C, 0xA7, 0xA0, 0xD0, 0xCA, 0x7A, 0x0D, 0x0C, 0xA7, 0xA0, 0xD0, 0xCA, 0x7A, 0x0D, 0x0C, 0xA7,
  0xA0, 0xD0, 0xCA, 0x7A, 0x0D, 0x0C, 0xA7, 0xA0, 0xD0, 0xCA, 0x7A, 0x0D, 0x0C, 0xA7, 0xA0, 0xD0,
  0xCF, 0xC0, 0xD0, 0xCF, 0xC0, 0xD0, 0xCA, 0x07, 0x80, 0x16, 0x07, 0xA0, 0xD0, 0xCA, 0x7A, 0x0D,
  0x0C, 0xA7, 0xA0, 0xD0, 0xCA, 0x7A, 0x0D, 0x0C, 0xA7, 0xA0, 0xD0, 0xCA, 0x7A, 0x0D, 0x0C, 0xA7,
  0xA0, 0xD0, 0xCA, 0x7A, 0x0D, 0x0C, 0xA7, 0xA0, 0xD0, 0xCA, 0x7A, 0x0D,
  // "I" (U+0049)
  0xE0, 0xCE, 0x81, 0xC1, 0x7A, 0x0E, 0x05, 0x20, 0x1A, 0x0C, 0x30, 0x1A, 0x0C, 0x30, 0x1A, 0x0C,
  0x30, 0x1A, 0x0C, 0x30, 0x1A, 0x0C, 0x30, 0x1A, 0x0C, 0x30, 0x1A, 0x0C, 0x30, 0x1A, 0x0C, 0x30,
  0x1A, 0x0C, 0x30, 0x1A, 0x0C, 0x30, 0x1A, 0x0C, 0x30, 0x1A, 0x0C, 0x30, 0x1A, 0x0C, 0x30, 0x1A,
  0x0C, 0x30, 0x1A, 0x0C, 0x30, 0x3A, 0x82, 0xD1, 0x0D, 0xD0, 0xAE, 0x0C,
  // "J" (U+004A)
  0x48, 0x1E, 0xFE, 0x48, 0x1E, 0xFE, 0x48, 0x1E, 0xFE, 0x48, 0x1E, 0xFE, 0x48, 0x1E, 0xFE, 0x48,
  0x1E, 0xFE, 0x48, 0x1E, 0xFE, 0x48, 0x1E, 0xFE, 0x48, 0x1E, 0xFE, 0x48, 0x1E, 0xFE, 0x48, 0x1E,
  0xFE, 0x48, 0x1E, 0xFE, 0x48, 0x1E, 0xFE, 0x48, 0x1E, 0xFE, 0x48, 0x1E, 0xFE, 0x48, 0x1E, 0xFE,
  0x48, 0x1E, 0xFE, 0x48, 0x1E, 0xFE, 0x48, 0x1E, 0xFE, 0x48, 0x1E, 0xFE, 0x48, 0x1E, 0xFE, 0x48,
  0x1E, 0xFD, 0x30, 0x2A, 0x83, 0xB2, 0x01, 0xBA, 0x08, 0x0A, 0xC8, 0x1E, 0x1A, 0xB8, 0x5E, 0x40,
  0x25, 0x64, 0x30,
  // "K" (U+004B)
  0x0C, 0xA5, 0x02, 0xA8, 0x1E, 0x1C, 0xA5, 0x0A, 0xA8, 0x16, 0x0C, 0xA4, 0x04, 0xA0, 0xC2, 0x0C,
  0xA4, 0x0D, 0xA0, 0x32, 0x0C, 0xA3, 0x07, 0xA0, 0x93, 0x0C, 0xA2, 0x83, 0x1E, 0xFE, 0x13, 0x0C,
  0xA2, 0x0A, 0xA0, 0x54, 0x0C, 0xA1, 0x04, 0xA0, 0xB5, 0x0C, 0xA0, 0x10, 0xDA, 0x02, 0x50, 0xCA,
  0x08, 0xA0, 0xB6, 0x0C, 0xA0, 0xEB, 0x02, 0x50, 0xCB, 0x0E, 0xA0, 0xA5, 0x0C, 0xA8, 0x1B, 0x1E,
  0xA0, 0x24, 0x0C, 0xA8, 0x11, 0x07, 0xA0, 0xA4, 0x0C, 0xA3, 0x0E, 0xA0, 0x33, 0x0C, 0xA3, 0x07,
  0xA0, 0xB3, 0x0C, 0xA4, 0x0E, 0xA0, 0x32, 0x0C, 0xA4, 0x07, 0xA0, 0xB2, 0x0C, 0xA5, 0x0E, 0xA8,
  0x13, 0x0C, 0xA5, 0x06, 0xA8, 0x1B, 0x0C, 0xA6, 0x0E, 0xA0, 0x40,
  // "L" (U+004C)
  0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7,
  0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7,
  0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA8, 0x02, 0x90, 0x30, 0xCF, 0x90, 0x60, 0xCF, 0x90, 0x60,
  // "M" (U+004D)
  0x0C, 0xB0, 0x57, 0x10, 0x3B, 0x0E, 0x0C, 0xB0, 0xA7, 0x10, 0x8B, 0x0E, 0x0C, 0xB0, 0xE7, 0x10,
  0xCB, 0x0E, 0x0C, 0xC0, 0x36, 0x01, 0xC8, 0x2E, 0xCF, 0xBA, 0x08, 0x60, 0x6A, 0x87, 0xBF, 0xEC,
  0xFB, 0xCF, 0xC6, 0x89, 0x0A, 0xFB, 0xBF, 0xEC, 0xFC, 0x7A, 0x01, 0x58, 0x90, 0xEF, 0x7C, 0xFE,
  0xCF, 0xC3, 0xA0, 0x54, 0x04, 0xA8, 0x91, 0x2C, 0xFE, 0xCF, 0xD0, 0xEF, 0xA4, 0x89, 0x48, 0xFD,
  0x0C, 0xFE, 0xCF, 0xD0, 0x9F, 0xE4, 0x89, 0x2D, 0xF9, 0x0C, 0xFE, 0xCF, 0xD0, 0x5A, 0x03, 0x20,
  0x2A, 0x86, 0x40, 0xCF, 0xEC, 0xFD, 0x2A, 0x08, 0x28, 0x16, 0xFE, 0x28, 0x4C, 0xFE, 0xCF, 0xD2,
  0x81, 0xBF, 0xC2, 0x81, 0xBF, 0xA2, 0x84, 0xCF, 0xEC, 0xFD, 0x20, 0x6A, 0x01, 0x1A, 0x06, 0x28,
  0x4C, 0xFE, 0xCF, 0xD2, 0x02, 0xA0, 0x60, 0x4A, 0x01, 0x28, 0x4C, 0xFE, 0xCF, 0xD3, 0x84, 0xDF,
  0xA9, 0xFC, 0x38, 0x4C, 0xFE, 0xCF, 0xD3, 0x84, 0x8F, 0xED, 0xF8, 0x38, 0x4C, 0xFE, 0xCF, 0xD3,
  0x04, 0xC0, 0x33, 0x84, 0xCF, 0xEC, 0xFD, 0x40, 0xEA, 0x0E, 0x48, 0x4C, 0xFE, 0xCF, 0xD4, 0x0A,
  0xA0, 0x94, 0x84, 0xCF, 0xEC, 0xFD, 0x40, 0x6A, 0x05, 0x48, 0x1C, 0xFE,
  // "N" (U+004E)
  0x0C, 0xA0, 0xC7, 0x82, 0xDF, 0xCC, 0xB0, 0x46, 0x82, 0xDF, 0xCC, 0xB0, 0xB6, 0x82, 0xDF, 0xCC,
  0xC0, 0x35, 0x84, 0xDF, 0xCC, 0xFE, 0xA0, 0xA5, 0x85, 0xDF, 0xCC, 0xFA, 0xCA, 0x02, 0x48, 0x5D,
  0xFC, 0xCF, 0xB5, 0xA0, 0x94, 0x86, 0xDF, 0xCC, 0xFC, 0x0D, 0xA0, 0x13, 0x86, 0xDF, 0xCC, 0xFC,
  0x06, 0xA0, 0x83, 0x84, 0xDF, 0xCC, 0xFD, 0x28, 0x1E, 0xFE, 0x38, 0x4D, 0xFC, 0xCF, 0xD2, 0x07,
  0xA0, 0x62, 0x84, 0xDF, 0xCC, 0xFD, 0x28, 0x21, 0xEF, 0xD2, 0x84, 0xDF, 0xCC, 0xFD, 0x30, 0x9A,
  0x86, 0x50, 0xDF, 0xCC, 0xFD, 0x30, 0x2A, 0x86, 0xC0, 0xCF, 0xCC, 0xFD, 0x40, 0xAA, 0x85, 0x4C,
  0xFC, 0xCF, 0xD4, 0x02, 0xA8, 0x5B, 0xBF, 0xCC, 0xFD, 0x50, 0xBA, 0x84, 0xEF, 0xCC, 0xFD, 0x50,
  0x3C, 0x82, 0xCC, 0xFD, 0x60, 0xCB, 0x82, 0xCC, 0xFD, 0x60, 0x5B, 0x82, 0xCC, 0xFD, 0x70, 0xDA,
  0x0C,
  // "O" (U+004F)
  0x48, 0x63, 0x9D, 0xEE, 0xC7, 0x17, 0x08, 0xF0, 0xE0, 0x35, 0x08, 0xB8, 0x2A, 0x78, 0xCA, 0x0E,
  0x01, 0x30, 0x2B, 0x04, 0x40, 0x9A, 0x0A, 0x30, 0x9A, 0x08, 0x60, 0xDA, 0x02, 0x20, 0xEA, 0x01,
  0x60, 0x7A, 0x81, 0x70, 0x2A, 0x0C, 0x70, 0x3A, 0x81, 0xB0, 0x5A, 0x09, 0x71, 0xA8, 0x1E, 0x07,
  0xA0, 0x77, 0x10, 0xEA, 0x10, 0x7A, 0x07, 0x71, 0x0D, 0xA0, 0x10, 0x8A, 0x06, 0x71, 0x0C, 0xA0,
  0x20, 0x7A, 0x07, 0x71, 0x0D, 0xA0, 0x10, 0x6A, 0x07, 0x71, 0x0E, 0xA1, 0x04, 0xA0, 0x97, 0x1A,
  0x81, 0xE0, 0x1A, 0x0C, 0x70, 0x3A, 0x0B, 0x20, 0xDA, 0x01, 0x60, 0x7A, 0x07, 0x20, 0x7A, 0x08,
  0x60, 0xDA, 0x02, 0x20, 0x10, 0xEA, 0x04, 0x40, 0x9A, 0x0A, 0x40, 0x5B, 0x82, 0xA7, 0x8D, 0xA0,
  0xE0, 0x25, 0x07, 0xF0, 0xE0, 0x37, 0x86, 0x39, 0xDF, 0xEC, 0x71, 0x40,
  // "P" (U+0050)
  0x0C, 0xC8, 0x2E, 0xD9, 0x22, 0x0C, 0xF9, 0x81, 0x60, 0xCA, 0x82, 0x76, 0x8C, 0xB0, 0x30, 0xCA,
  0x40, 0xAA, 0x09, 0x0C, 0xA4, 0x01, 0xA0, 0xE0, 0xCA, 0x50, 0xEA, 0x0C, 0xA5, 0x0D, 0xA0, 0xCA,
  0x50, 0xEA, 0x0C, 0xA4, 0x02, 0xA0, 0x0C, 0xA4, 0x0B, 0xA0, 0x70, 0xCA, 0x82, 0x77, 0x8D, 0xA8,
  0x1E, 0x1C, 0xF8, 0x2E, 0x30, 0xCC, 0x82, 0xEC, 0x71, 0x20, 0xCA, 0x71, 0x0C, 0xA7, 0x10, 0xCA,
  0x71, 0x0C, 0xA7, 0x10, 0xCA, 0x71, 0x0C, 0xA7, 0x10, 0xCA, 0x71, 0x0C, 0xA7, 0x10,
  // "Q" (U+0051)
  0x48, 0x63, 0x9D, 0xEE, 0xC7, 0x17, 0x08, 0xF0, 0xE0, 0x35, 0x08, 0xB8, 0x2A, 0x78, 0xCA, 0x0E,
  0x02, 0x30, 0x2B, 0x04, 0x40, 0x9A, 0x0B, 0x30, 0x9A, 0x08, 0x60, 0xDA, 0x03, 0x20, 0xEA, 0x01,
  0x60, 0x7A, 0x81, 0x80, 0x2A, 0x0C, 0x70, 0x3A, 0x81, 0xC0, 0x5A, 0x09, 0x71, 0xA8, 0x1E, 0x07,
  0xA0, 0x77, 0x10, 0xEA, 0x01, 0x07, 0xA0, 0x77, 0x10, 0xDA, 0x02, 0x08, 0xA0, 0x67, 0x10, 0xCA,
  0x02, 0x07, 0xA0, 0x77, 0x10, 0xDA, 0x02, 0x06, 0xA0, 0x77, 0x10, 0xEA, 0x01, 0x04, 0xA0, 0x97,
  0x1B, 0x10, 0x1A, 0x0C, 0x70, 0x3A, 0x0C, 0x20, 0xDA, 0x01, 0x60, 0x7A, 0x08, 0x20, 0x7A, 0x08,
  0x60, 0xDA, 0x03, 0x20, 0x10, 0xEA, 0x04, 0x40, 0x9A, 0x0B, 0x40, 0x5B, 0x82, 0xA7, 0x8D, 0xB0,
  0x25, 0x07, 0xF0, 0xE0, 0x47, 0x81, 0x3A, 0xDC, 0x03, 0x75, 0x06, 0xA0, 0xB7, 0x60, 0xCA, 0x07,
  0x75, 0x03, 0xB0, 0x37, 0x50, 0x8A, 0x0D, 0x76, 0x0F, 0x70, 0x31,
  // "R" (U+0052)
  0x0C, 0xC8, 0x2E, 0xC9, 0x24, 0x0C, 0xF9, 0x06, 0x30, 0xCA, 0x82, 0x77, 0x8D, 0xB0, 0x42, 0x0C,
  0xA4, 0x09, 0xA0, 0xB2, 0x0C, 0xA5, 0xB2, 0x0C, 0xA5, 0x0D, 0xA8, 0x11, 0x0C, 0xA5, 0x0D, 0xA8,
  0x11, 0x0C, 0xA5, 0xA0, 0xE2, 0x0C, 0xA4, 0x06, 0xA0, 0xA2, 0x0C, 0xA2, 0x81, 0x16, 0xEA, 0x03,
  0x20, 0xCF, 0x90, 0x73, 0x0C, 0xF0, 0x44, 0x0C, 0xA8, 0x17, 0x6B, 0xA0, 0x34, 0x0C, 0xA2, 0x03,
  0xA0, 0xB4, 0x0C, 0xA3, 0x0B, 0xA0, 0x33, 0x0C, 0xA3, 0x04, 0xA0, 0xA3, 0x0C, 0xA4, 0x0D, 0xA0,
  0x22, 0x0C, 0xA4, 0x06, 0xA0, 0xA2, 0x0C, 0xA5, 0x0E, 0xA8, 0x12, 0x0C, 0xA5, 0x07, 0xA8, 0x19,
  0x0C, 0xA5, 0x01, 0xB0, 0x20,
  // "S" (U+0053)
  0x28, 0x61, 0x7C, 0xEF, 0xDA, 0x52, 0x02, 0x0D, 0xF8, 0x16, 0x0D, 0xA8, 0x2C, 0x77, 0xAA, 0x01,
  0x05, 0xA0, 0xB4, 0x82, 0x16, 0x09, 0xA0, 0x47, 0x0A, 0xA0, 0x37, 0x09, 0xA0, 0x67, 0x06, 0xA0,
  0xE0, 0x26, 0x01, 0x0E, 0xA0, 0xE0, 0x76, 0x05, 0xC0, 0xD0, 0x55, 0x04, 0x0E, 0xC0, 0x96, 0x08,
  0xC0, 0xA6, 0x01, 0x0B, 0xB0, 0x47, 0x0B, 0xA0, 0x97, 0x03, 0xA0, 0xB7, 0x01, 0xA0, 0xB7, 0x04,
  0xA8, 0x19, 0x72, 0x50, 0xCA, 0x86, 0x4D, 0xFB, 0x87, 0x8D, 0xA8, 0x1B, 0x0D, 0xF8, 0x91, 0xC1,
  0x03, 0x8C, 0xDF, 0xEC, 0x63,
  // "T" (U+0054)
  0x0A, 0xFC, 0x01, 0x0A, 0xFC, 0x84, 0x14, 0x66, 0x68, 0xA0, 0xC8, 0x00, 0x65, 0x02, 0xA0, 0x97,
  0x20, 0x2A, 0x09, 0x72, 0x02, 0xA0, 0x97, 0x20, 0x2A, 0x09, 0x72, 0x02, 0xA0, 0x97, 0x20, 0x2A,
  0x09, 0x72, 0x02, 0xA0, 0x97, 0x20, 0x2A, 0x09, 0x72, 0x02, 0xA0, 0x97, 0x20, 0x2A, 0x09, 0x72,
  0x02, 0xA0, 0x97, 0x20, 0x2A, 0x09, 0x72, 0x02, 0xA0, 0x97, 0x20, 0x2A, 0x09, 0x72, 0x02, 0xA0,
  0x97, 0x20, 0x2A, 0x09, 0x72, 0x02, 0xA0, 0x97, 0x20, 0x2A, 0x09, 0x50,
  // "U" (U+0055)
  0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60,
  0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A,
  0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03,
  0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x82, 0x9E,
  0xFD, 0x60, 0x3A, 0x09, 0x0D, 0xA6, 0x05, 0xA0, 0x80, 0xAA, 0x03, 0x50, 0x9A, 0x00, 0x5A, 0x0C,
  0x40, 0x2A, 0x0E, 0x20, 0xCA, 0x83, 0xD8, 0x79, 0xEA, 0x07, 0x20, 0x20, 0xDF, 0x0A, 0x58, 0x57,
  0xCE, 0xFE, 0xA5, 0x30,
  // "V" (U+0056)
  0x0D, 0xA0, 0x17, 0x0D, 0xA0, 0x10, 0x9A, 0x05, 0x60, 0x1A, 0x81, 0xC0, 0x5A, 0x08, 0x60, 0x5A,
  0x81, 0x80, 0x1A, 0x0C, 0x60, 0x9A, 0x04, 0x20, 0xCA, 0x01, 0x50, 0xDA, 0x30, 0x8A, 0x04, 0x40,
  0x1A, 0x0B, 0x30, 0x4A, 0x08, 0x40, 0x5A, 0x07, 0x4A, 0x0C, 0x40, 0x9A, 0x03, 0x40, 0xCA, 0x48,
  0x1D, 0xFE, 0x50, 0x8A, 0x04, 0x20, 0x1A, 0x0B, 0x50, 0x4A, 0x08, 0x20, 0x5A, 0x07, 0x6A, 0x0B,
  0x20, 0x8A, 0x02, 0x60, 0xBA, 0x28, 0x1C, 0xFE, 0x70, 0x7A, 0x03, 0x01, 0xA0, 0xA7, 0x03, 0xA0,
  0x70, 0x4A, 0x06, 0x71, 0x82, 0xEF, 0xA7, 0xA0, 0x27, 0x18, 0x4A, 0xFD, 0xAF, 0xD7, 0x20, 0x6A,
  0x81, 0xDF, 0x97, 0x20, 0x2C, 0x05, 0x73, 0x0E, 0xB0, 0x17, 0x30, 0xAA, 0x0C, 0x60,
  // "W" (U+0057)
  0x0B, 0xA0, 0x15, 0x04, 0xA0, 0x96, 0x0C, 0xA0, 0x10, 0x8A, 0x04, 0x50, 0x7A, 0x0C, 0x6A, 0x81,
  0xD0, 0x5A, 0x07, 0x50, 0xBB, 0x50, 0x3A, 0x81, 0xA0, 0x1A, 0x0A, 0x50, 0xEB, 0x03, 0x40, 0x6A,
  0x06, 0x28, 0x1E, 0xFD, 0x40, 0x2A, 0x81, 0xEF, 0x64, 0x09, 0xA0, 0x32, 0x0A, 0xA0, 0x13, 0x84,
  0x5F, 0xEA, 0xFA, 0x40, 0xCA, 0x30, 0x7A, 0x04, 0x38, 0x48, 0xFC, 0x8F, 0xD4, 0xA0, 0xC3, 0x04,
  0xA0, 0x73, 0x82, 0xCF, 0x96, 0xA0, 0x12, 0x03, 0xA0, 0x93, 0x01, 0xA0, 0xA3, 0xA0, 0x70, 0x3A,
  0x04, 0x20, 0x6A, 0x06, 0x48, 0x1D, 0xFD, 0x20, 0x3A, 0x03, 0x1A, 0x07, 0x20, 0x9A, 0x02, 0x40,
  0xAA, 0x81, 0x10, 0x6A, 0x28, 0x1C, 0xFB, 0x28, 0x1C, 0xFE, 0x50, 0x6A, 0x83, 0x40, 0xAF, 0xC2,
  0x81, 0x8F, 0xE2, 0xA0, 0xB5, 0x03, 0xA8, 0x37, 0x0D, 0xF9, 0x20, 0x5A, 0x02, 0x03, 0xA0, 0x86,
  0xA0, 0xA1, 0xA0, 0x52, 0x01, 0xA0, 0x50, 0x6A, 0x05, 0x68, 0x2C, 0xFC, 0x3A, 0x02, 0x38, 0x2D,
  0xF8, 0x9A, 0x02, 0x60, 0x9A, 0x81, 0x6F, 0xE4, 0x84, 0xAF, 0xAB, 0xFE, 0x70, 0x6A, 0x81, 0xAF,
  0xB4, 0x84, 0x7F, 0xCD, 0xFB, 0x70, 0x2A, 0x81, 0xEF, 0x84, 0x81, 0x3F, 0xEA, 0x07, 0x71, 0x0E,
  0xB0, 0x45, 0xC0, 0x47, 0x10, 0xBB, 0x01, 0x50, 0xCB, 0x01, 0x71, 0x08, 0xA0, 0xD6, 0x09, 0xA0,
  0xD5,
  // "X" (U+0058)
  0x02, 0xA0, 0xC5, 0x04, 0xA0, 0xB2, 0x0B, 0xA0, 0x34, 0x0A, 0xA0, 0x42, 0x04, 0xA0, 0x93, 0x01,
  0xA0, 0xD4, 0x81, 0xDF, 0xE3, 0x07, 0xA0, 0x64, 0x06, 0xA0, 0x62, 0x81, 0xDF, 0xE6, 0x83, 0xEF,
  0xC0, 0x5A, 0x08, 0x60, 0x8A, 0x03, 0x0B, 0xA0, 0x16, 0x01, 0xA0, 0xBA, 0x0A, 0x71, 0x0A, 0xC0,
  0x37, 0x10, 0x3B, 0x0B, 0x73, 0xB0, 0x87, 0x20, 0x7B, 0x0E, 0x72, 0x0D, 0xC0, 0x67, 0x05, 0xA8,
  0x26, 0xEF, 0xD7, 0x83, 0xDF, 0xE0, 0x8A, 0x04, 0x50, 0x4A, 0x81, 0x80, 0x2A, 0x0B, 0x50, 0xBA,
  0x01, 0x20, 0xBA, 0x03, 0x30, 0x3A, 0x0A, 0x30, 0x4A, 0x0A, 0x30, 0xAA, 0x03, 0x40, 0xDA, 0x81,
  0x20, 0x2A, 0x0B, 0x50, 0x7A, 0x81, 0x90, 0x9A, 0x05, 0x50, 0x1A, 0x0E, 0x01,
  // "Y" (U+0059)
  0x0C, 0xA0, 0x35, 0x02, 0xA0, 0xD0, 0x6A, 0x09, 0x50, 0x8A, 0x83, 0x71, 0xEF, 0xE5, 0x0D, 0xA8,
  0x11, 0x09, 0xA0, 0x53, 0x04, 0xA0, 0xA2, 0x03, 0xA0, 0xB3, 0x0A, 0xA0, 0x43, 0x0D, 0xA8, 0x12,
  0x01, 0xA0, 0xD4, 0x07, 0xA8, 0x18, 0x07, 0xA0, 0x74, 0x01, 0xA8, 0x1E, 0x0C, 0xA0, 0x15, 0x0A,
  0xA0, 0x8A, 0x0A, 0x60, 0x4D, 0x04, 0x70, 0xDB, 0x0D, 0x71, 0x07, 0xB0, 0x87, 0x10, 0x1B, 0x02,
  0x72, 0x81, 0xEF, 0xE7, 0x38, 0x1E, 0xFE, 0x73, 0x81, 0xEF, 0xE7, 0x38, 0x1E, 0xFE, 0x73, 0x81,
  0xEF, 0xE7, 0x38, 0x1E, 0xFE, 0x73, 0x81, 0xEF, 0xE7, 0x38, 0x1E, 0xFE, 0x50,
  // "Z" (U+005A)
  0x1F, 0xB0, 0x61, 0xFB, 0x06, 0x18, 0x03, 0x60, 0xEA, 0x03, 0x70, 0x4A, 0x0B, 0x71, 0x0B, 0xA0,
  0x47, 0x02, 0xA0, 0xC7, 0x10, 0x9A, 0x06, 0x70, 0x1A, 0x0E, 0x71, 0x08, 0xA0, 0x77, 0x18, 0x2E,
  0xFE, 0x17, 0x06, 0xA0, 0x97, 0x10, 0xDA, 0x02, 0x70, 0x4A, 0x0A, 0x71, 0x0B, 0xA0, 0x37, 0x03,
  0xA0, 0xC7, 0x10, 0xAA, 0x05, 0x70, 0x1A, 0x0D, 0x71, 0x08, 0xA0, 0x67, 0x10, 0xEA, 0x07, 0x80,
  0x26, 0x04, 0x03, 0xFB, 0x09, 0x03, 0xFB, 0x09,
  // "[" (U+005B)
  0xE0, 0x1E, 0x01, 0xA0, 0xB0, 0xF6, 0x1A, 0x08, 0x4A, 0x08, 0x4A, 0x08, 0x4A, 0x08, 0x4A, 0x08,
  0x4A, 0x08, 0x4A, 0x08, 0x4A, 0x08, 0x4A, 0x08, 0x4A, 0x08, 0x4A, 0x08, 0x4A, 0x08, 0x4A, 0x08,
  0x4A, 0x08, 0x4A, 0x08, 0x4A, 0x08, 0x4A, 0x08, 0x4A, 0x08, 0x4A, 0x08, 0x4A, 0x08, 0x4A, 0x0B,
  0x0F, 0x61, 0xE0, 0x1E, 0x01,
  // "\" (U+005C)
  0x07, 0xA0, 0x17, 0x01, 0xA0, 0x77, 0x18, 0x1B, 0xFC, 0x71, 0x06, 0xA0, 0x27, 0x01, 0xA0, 0x87,
  0x18, 0x1A, 0xFD, 0x71, 0x05, 0xA0, 0x37, 0x18, 0x1E, 0xF9, 0x71, 0x81, 0x9F, 0xE7, 0x10, 0x4A,
  0x04, 0x71, 0x81, 0xEF, 0xA7, 0x18, 0x19, 0xFE, 0x71, 0x03, 0xA0, 0x57, 0x18, 0x1D, 0xFB, 0x71,
  0x08, 0xA0, 0x17, 0x02, 0xA0, 0x67, 0x18, 0x1C, 0xFC, 0x71, 0x07, 0xA0, 0x27, 0x01, 0xA0, 0x77,
  0x18, 0x1B, 0xFD, 0x71, 0x06, 0xA0, 0x30,
  // "]" (U+005D)
  0x03, 0xD0, 0xD0, 0x3D, 0x86, 0xD1, 0x66, 0x6C, 0xFD, 0x48, 0x1A, 0xFD, 0x48, 0x1A, 0xFD, 0x48,
  0x1A, 0xFD, 0x48, 0x1A, 0xFD, 0x48, 0x1A, 0xFD, 0x48, 0x1A, 0xFD, 0x48, 0x1A, 0xFD, 0x48, 0x1A,
  0xFD, 0x48, 0x1A, 0xFD, 0x48, 0x1A, 0xFD, 0x48, 0x1A, 0xFD, 0x48, 0x1A, 0xFD, 0x48, 0x1A, 0xFD,
  0x48, 0x1A, 0xFD, 0x48, 0x1A, 0xFD, 0x48, 0x1A, 0xFD, 0x48, 0x1A, 0xFD, 0x48, 0x1A, 0xFD, 0x48,
  0x1A, 0xFD, 0x48, 0x91, 0xAF, 0xD1, 0x66, 0x6C, 0xFD, 0x3D, 0x0D, 0x03, 0xD0, 0xD0,
  // "^" (U+005E)
  0x58, 0x12, 0xFC, 0x74, 0x0A, 0xA0, 0x47, 0x20, 0x1B, 0x0B, 0x72, 0x81, 0x8F, 0xEA, 0x03, 0x78,
  0x51, 0xEF, 0x6B, 0xFB, 0x78, 0x37, 0xFE, 0x04, 0xA0, 0x26, 0x81, 0xEF, 0x72, 0x81, 0xCF, 0xA5,
  0x06, 0xA0, 0x12, 0x05, 0xA0, 0x24, 0x81, 0xDF, 0x94, 0x81, 0xDF, 0x93, 0x05, 0xA0, 0x24, 0x06,
  0xA0, 0x12, 0x81, 0xCF, 0xB6, 0x83, 0xEF, 0x90, 0x3A, 0x04, 0x60, 0x7A, 0x01,
  // "_" (U+005F)
  0x18, 0x09, 0x06, 0x03, 0x01, 0xFD, 0x07, 0x01, 0xFD, 0x07,
  // "`" (U+0060)
  0x82, 0x67, 0x73, 0x20, 0x5A, 0x0D, 0x30, 0x7A, 0x07, 0x38, 0x28, 0xFE, 0x23, 0x81, 0x7F, 0xB0,
  // "a" (U+0061)
  0x28, 0x54, 0xAD, 0xFE, 0xB4, 0x30, 0x8F, 0x05, 0x28, 0x43, 0xFC, 0x97, 0xBA, 0x0D, 0x30, 0x24,
  0x0A, 0xA0, 0x27, 0x06, 0xA0, 0x57, 0x05, 0xA0, 0x52, 0x81, 0x5B, 0xED, 0x81, 0x60, 0xAF, 0x90,
  0x06, 0xB8, 0x2B, 0x86, 0x9A, 0x06, 0x0C, 0xA0, 0x63, 0x05, 0xA8, 0x26, 0xEF, 0xE4, 0x06, 0xA8,
  0x26, 0xEF, 0xD4, 0x09, 0xA0, 0x60, 0xCA, 0x01, 0x20, 0x2B, 0x06, 0x08, 0xA8, 0x3D, 0x79, 0xEC,
  0xA8, 0x16, 0x1E, 0xC8, 0x96, 0xE2, 0xEF, 0x60, 0x3B, 0xFE, 0xA2, 0x0B, 0xF6,
  // "b" (U+0062)
  0x01, 0xA0, 0xA7, 0x20, 0x1A, 0x0A, 0x72, 0x01, 0xA0, 0xA7, 0x20, 0x1A, 0x0A, 0x72, 0x01, 0xA0,
  0xA7, 0x20, 0x1A, 0x0A, 0x72, 0x01, 0xA8, 0x59, 0x07, 0xDF, 0xC6, 0x30, 0x1A, 0x09, 0x0A, 0xD0,
  0x82, 0x01, 0xA8, 0x3E, 0xFA, 0x79, 0xB8, 0x13, 0x01, 0xB0, 0x83, 0x07, 0xA8, 0x19, 0x01, 0xB0,
  0x14, 0x83, 0xEF, 0xE0, 0x1A, 0x0D, 0x50, 0xBA, 0x00, 0x1A, 0x0B, 0x50, 0x9A, 0x03, 0x01, 0xA0,
  0xA5, 0x09, 0xA0, 0x30, 0x1A, 0x0A, 0x50, 0x9A, 0x03, 0x01, 0xA0, 0xB5, 0x09, 0xA0, 0x30, 0x1A,
  0x0D, 0x50, 0xBA, 0x00, 0x1B, 0x01, 0x48, 0x3E, 0xFE, 0x01, 0xB0, 0x93, 0x07, 0xA8, 0x19, 0x01,
  0xC8, 0x1B, 0x79, 0xB8, 0x12, 0x01, 0xA0, 0x60, 0xCD, 0x08, 0x20, 0x1A, 0x85, 0x30, 0x8D, 0xFC,
  0x63,
  // "c" (U+0063)
  0x38, 0x56, 0xCE, 0xEC, 0x81, 0x20, 0xAE, 0x81, 0x40, 0x7A, 0x83, 0xE8, 0x7B, 0xE2, 0x82, 0xEF,
  0xE2, 0x38, 0x11, 0x05, 0xA0, 0x86, 0x08, 0xA0, 0x46, 0x0A, 0xA0, 0x26, 0x0B, 0xA0, 0x16, 0x0B,
  0xA0, 0x16, 0x0A, 0xA0, 0x26, 0x09, 0xA0, 0x46, 0x06, 0xA0, 0x86, 0x01, 0xA0, 0xE0, 0x24, 0x81,
  0x10, 0x9A, 0x84, 0xE8, 0x79, 0xE4, 0x20, 0xCE, 0x04, 0x38, 0x47, 0xCE, 0xEC, 0x71,
  // "d" (U+0064)
  0x71, 0x02, 0xA0, 0x97, 0x10, 0x2A, 0x09, 0x71, 0x02, 0xA0, 0x97, 0x10, 0x2A, 0x09, 0x71, 0x02,
  0xA0, 0x97, 0x10, 0x2A, 0x09, 0x28, 0x51, 0xAE, 0xEB, 0x32, 0xA8, 0x29, 0x01, 0xED, 0x05, 0xA8,
  0x19, 0x0A, 0xA8, 0x3D, 0x78, 0xEE, 0xA0, 0x90, 0x1A, 0x0E, 0x01, 0x20, 0x10, 0xEA, 0x09, 0x06,
  0xA0, 0x74, 0x08, 0xA0, 0x09, 0xA0, 0x44, 0x05, 0xA0, 0x90, 0xAA, 0x02, 0x40, 0x3A, 0x09, 0x0B,
  0xA0, 0x14, 0x02, 0xA0, 0x90, 0xBA, 0x01, 0x40, 0x2A, 0x09, 0x0A, 0xA0, 0x24, 0x02, 0xA0, 0x09,
  0xA0, 0x44, 0x04, 0xA0, 0x90, 0x6A, 0x07, 0x40, 0x8A, 0x09, 0x02, 0xA0, 0xE0, 0x12, 0x01, 0x0E,
  0xA8, 0x19, 0x0B, 0xA8, 0x3D, 0x78, 0xEE, 0xA8, 0x29, 0x02, 0xED, 0x82, 0x4D, 0xF9, 0x28, 0x90,
  0x2A, 0xEE, 0xB4, 0x0B, 0xF9,
  // "e" (U+0065)
  0x38, 0x47, 0xCE, 0xEA, 0x35, 0x0B, 0xE0, 0x53, 0x08, 0xA8, 0x5C, 0x78, 0xEF, 0xE1, 0x28, 0x1E,
  0xFC, 0x30, 0x3A, 0x81, 0x80, 0x5A, 0x04, 0x48, 0x3C, 0xFC, 0x08, 0xA0, 0x14, 0x83, 0x9F, 0xE0,
  0xAF, 0xB1, 0x0B, 0xFB, 0x01, 0x0B, 0xA8, 0x04, 0x61, 0x0A, 0xA0, 0x17, 0x10, 0x8A, 0x03, 0x71,
  0x05, 0xA0, 0x87, 0x28, 0x2E, 0xFE, 0x34, 0x01, 0x02, 0x20, 0x7B, 0x84, 0x97, 0x7B, 0xF6, 0x30,
  0xAF, 0x06, 0x48, 0x55, 0xBE, 0xFE, 0xB6, 0x20,
  // "f" (U+0066)
  0x38, 0x41, 0x9E, 0xFD, 0x93, 0x0C, 0xC0, 0xB2, 0x04, 0xA8, 0x2D, 0x78, 0x52, 0x08, 0xA0, 0x45,
  0x09, 0xA0, 0x25, 0x0A, 0xA0, 0x13, 0x02, 0x0A, 0xD8, 0x1D, 0x0A, 0xE8, 0x3D, 0x04, 0x6C, 0xA8,
  0x17, 0x66, 0x30, 0xAA, 0x01, 0x50, 0xAA, 0x01, 0x50, 0xAA, 0x01, 0x50, 0xAA, 0x01, 0x50, 0xAA,
  0x01, 0x50, 0xAA, 0x01, 0x50, 0xAA, 0x01, 0x50, 0xAA, 0x01, 0x50, 0xAA, 0x01, 0x50, 0xAA, 0x01,
  0x50, 0xAA, 0x01, 0x50, 0xAA, 0x01, 0x50, 0xAA, 0x01, 0x30,
  // "g" (U+0067)
  0x28, 0x93, 0x19, 0xEE, 0xB4, 0x0C, 0xF9, 0x01, 0xDD, 0x84, 0x4E, 0xF9, 0x0A, 0xA8, 0x3D, 0x78,
  0xEE, 0xA0, 0x90, 0x1A, 0x0E, 0x01, 0x20, 0x10, 0xEA, 0x09, 0x06, 0xA0, 0x74, 0x08, 0xA0, 0x90,
  0x8A, 0x04, 0x40, 0x5A, 0x09, 0x0A, 0xA0, 0x24, 0x03, 0xA0, 0x90, 0xBA, 0x01, 0x40, 0x2A, 0x09,
  0x0B, 0xA0, 0x14, 0x02, 0xA0, 0x90, 0xAA, 0x01, 0x40, 0x2A, 0x00, 0x9A, 0x03, 0x40, 0x4A, 0x09,
  0x06, 0xA0, 0x74, 0x08, 0xA0, 0x90, 0x2A, 0x0D, 0x01, 0x20, 0x10, 0xEA, 0x81, 0x90, 0xBA, 0x83,
  0xD7, 0x8D, 0xEA, 0x82, 0x90, 0x2E, 0xC0, 0xE0, 0x5A, 0x09, 0x28, 0x52, 0xAE, 0xEB, 0x32, 0xA0,
  0x87, 0x10, 0x2A, 0x08, 0x71, 0x03, 0xA0, 0x77, 0x10, 0x7A, 0x81, 0x40, 0x55, 0x82, 0x2E, 0xFE,
  0x28, 0x4E, 0xEA, 0x77, 0x9B, 0x07, 0x20, 0xEF, 0x0A, 0x38, 0x63, 0x9C, 0xEF, 0xEB, 0x53,
  // "h" (U+0068)
  0x01, 0xA0, 0xA7, 0x10, 0x1A, 0x0A, 0x71, 0x01, 0xA0, 0xA7, 0x10, 0x1A, 0x0A, 0x71, 0x01, 0xA0,
  0xA7, 0x10, 0x1A, 0x0A, 0x71, 0x01, 0xA8, 0x59, 0x08, 0xDF, 0xD7, 0x20, 0x1A, 0x09, 0x0C, 0xD8,
  0x19, 0x01, 0xA8, 0x3E, 0xFA, 0x7A, 0xB0, 0x20, 0x1B, 0x08, 0x30, 0x9A, 0x06, 0x01, 0xB0, 0x13,
  0x03, 0xA0, 0x80, 0x1A, 0x0D, 0x40, 0x2A, 0x09, 0x01, 0xA0, 0xB4, 0x01, 0xA0, 0x90, 0x1A, 0x0A,
  0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0,
  0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A,
  0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09,
  // "i" (U+0069)
  0x18, 0x2A, 0xE6, 0x2A, 0x0C, 0x02, 0xA8, 0x3C, 0x0A, 0xE5, 0x71, 0x01, 0xA0, 0xA0, 0x1A, 0x0A,
  0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x01,
  0xA0, 0xA0, 0x1A, 0x0A, 0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x01, 0xA0,
  0xA0, 0x1A, 0x0A,
  // "j" (U+006A)
  0x38, 0x1A, 0xE6, 0x20, 0x2A, 0x0C, 0x20, 0x2A, 0x0C, 0x38, 0x1A, 0xE5, 0x77, 0x01, 0xA0, 0xA2,
  0x01, 0xA0, 0xA2, 0x01, 0xA0, 0xA2, 0x01, 0xA0, 0xA2, 0x01, 0xA0, 0xA2, 0x01, 0xA0, 0xA2, 0x01,
  0xA0, 0xA2, 0x01, 0xA0, 0xA2, 0x01, 0xA0, 0xA2, 0x01, 0xA0, 0xA2, 0x01, 0xA0, 0xA2, 0x01, 0xA0,
  0xA2, 0x01, 0xA0, 0xA2, 0x01, 0xA0, 0xA2, 0x01, 0xA0, 0xA2, 0x01, 0xA0, 0xA2, 0x01, 0xA0, 0xA2,
  0x01, 0xA0, 0xA2, 0x01, 0xA0, 0xA2, 0x04, 0xA8, 0x28, 0x78, 0xDA, 0x05, 0x0C, 0xB8, 0x5D, 0x0A,
  0xEE, 0xA2, 0x10,
  // "k" (U+006B)
  0x01, 0xA0, 0xA7, 0x10, 0x1A, 0x0A, 0x71, 0x01, 0xA0, 0xA7, 0x10, 0x1A, 0x0A, 0x71, 0x01, 0xA0,
  0xA7, 0x10, 0x1A, 0x0A, 0x71, 0x01, 0xA0, 0xA4, 0x0C, 0xA0, 0x30, 0x1A, 0x0A, 0x30, 0x7A, 0x81,
  0x80, 0x1A, 0x0A, 0x20, 0x2A, 0x0C, 0x20, 0x1A, 0x0A, 0x20, 0xBA, 0x03, 0x20, 0x1A, 0x81, 0xA0,
  0x6A, 0x07, 0x30, 0x1A, 0x83, 0x91, 0xEF, 0xC4, 0x01, 0xA0, 0x90, 0xAA, 0x04, 0x40, 0x1A, 0x0C,
  0xB0, 0x94, 0x01, 0xC0, 0xEA, 0x02, 0x30, 0x1B, 0x07, 0x05, 0xA0, 0x93, 0x01, 0xA0, 0xB2, 0x0D,
  0xA0, 0x22, 0x01, 0xA0, 0xA2, 0x05, 0xA0, 0x92, 0x01, 0xA0, 0xA3, 0x0D, 0xA8, 0x12, 0x01, 0xA0,
  0xA3, 0x06, 0xA8, 0x19, 0x01, 0xA0, 0xA4, 0x0E, 0xA0, 0x20, 0x1A, 0x0A, 0x40, 0x7A, 0x09,
  // "l" (U+006C)
  0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x01,
  0xA0, 0xA0, 0x1A, 0x0A, 0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x01, 0xA0,
  0xA0, 0x1A, 0x0A, 0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x01, 0xA0, 0xA0,
  0x1A, 0x0A, 0x01, 0xA0, 0xA0, 0x1A, 0x0A,
  // "m" (U+006D)
  0x01, 0xA8, 0x52, 0x19, 0xDE, 0xC5, 0x28, 0x64, 0xCE, 0xEA, 0x10, 0x1A, 0x05, 0x0C, 0xD0, 0x05,
  0xD8, 0x1D, 0x01, 0xA8, 0x3E, 0xF9, 0x7C, 0xA8, 0x4D, 0xED, 0x78, 0xEA, 0x06, 0x01, 0xB0, 0x73,
  0x0E, 0xA0, 0xE0, 0x12, 0x05, 0xA0, 0xA0, 0x1B, 0x01, 0x30, 0x9A, 0x09, 0x4A, 0x0C, 0x01, 0xA0,
  0xD4, 0x08, 0xA0, 0x64, 0x82, 0xEF, 0xD1, 0xA0, 0xB4, 0x07, 0xA0, 0x44, 0x82, 0xDF, 0xD1, 0xA0,
  0xA4, 0x07, 0xA0, 0x44, 0x82, 0xDF, 0xD1, 0xA0, 0xA4, 0x07, 0xA0, 0x44, 0x82, 0xDF, 0xD1, 0xA0,
  0xA4, 0x07, 0xA0, 0x44, 0x82, 0xDF, 0xD1, 0xA0, 0xA4, 0x07, 0xA0, 0x44, 0x82, 0xDF, 0xD1, 0xA0,
  0xA4, 0x07, 0xA0, 0x44, 0x82, 0xDF, 0xD1, 0xA0, 0xA4, 0x07, 0xA0, 0x44, 0x82, 0xDF, 0xD1, 0xA0,
  0xA4, 0x07, 0xA0, 0x44, 0x82, 0xDF, 0xD1, 0xA0, 0xA4, 0x07, 0xA0, 0x44, 0x82, 0xDF, 0xD1, 0xA0,
  0xA4, 0x07, 0xA0, 0x44, 0x81, 0xDF, 0xD0,
  // "n" (U+006E)
  0x01, 0xA8, 0x52, 0x08, 0xDF, 0xD7, 0x20, 0x1A, 0x05, 0x0C, 0xD8, 0x18, 0x01, 0xA8, 0x3E, 0xFA,
  0x7A, 0xB0, 0x20, 0x1B, 0x08, 0x30, 0x9A, 0x06, 0x01, 0xB0, 0x13, 0x04, 0xA0, 0x80, 0x1A, 0x0D,
  0x40, 0x2A, 0x09, 0x01, 0xA0, 0xB4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0,
  0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A,
  0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01,
  0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09,
  // "o" (U+006F)
  0x38, 0x46, 0xCE, 0xEC, 0x65, 0x0B, 0xE0, 0xB3, 0x08, 0xA8, 0x2D, 0x87, 0xDA, 0x08, 0x28, 0x2E,
  0xFE, 0x13, 0x0D, 0xA0, 0x10, 0x5A, 0x08, 0x40, 0x6A, 0x06, 0x08, 0xA0, 0x44, 0x02, 0xA0, 0x0A,
  0xA0, 0x25, 0xA0, 0xC0, 0xBA, 0x01, 0x5A, 0x0D, 0x0B, 0xA0, 0x15, 0xA0, 0xC0, 0xAA, 0x02, 0x5A,
  0x0B, 0x08, 0xA0, 0x44, 0x02, 0xA0, 0x90, 0x4A, 0x08, 0x40, 0x6A, 0x84, 0x60, 0xEF, 0xE1, 0x38,
  0x4D, 0xFE, 0x10, 0x6A, 0x82, 0xD8, 0x7D, 0xA0, 0x83, 0x09, 0xE0, 0xA5, 0x84, 0x5B, 0xEE, 0xC6,
  0x30,
  // "p" (U+0070)
  0x01, 0xA8, 0x53, 0x08, 0xDF, 0xC6, 0x30, 0x1A, 0x06, 0x0A, 0xD0, 0x82, 0x01, 0xA8, 0x3D, 0xFA,
  0x79, 0xB8, 0x13, 0x01, 0xB0, 0x83, 0x07, 0xA8, 0x19, 0x01, 0xB0, 0x14, 0x83, 0xEF, 0xE0, 0x1A,
  0x0D, 0x50, 0xBA, 0x00, 0x1A, 0x0B, 0x50, 0x9A, 0x03, 0x01, 0xA0, 0xA5, 0x09, 0xA0, 0x30, 0x1A,
  0x0A, 0x50, 0x9A, 0x03, 0x01, 0xA0, 0xB5, 0x09, 0xA0, 0x30, 0x1A, 0x0D, 0x50, 0xBA, 0x00, 0x1B,
  0x01, 0x48, 0x3E, 0xFD, 0x01, 0xB0, 0x83, 0x07, 0xA8, 0x19, 0x01, 0xA8, 0x3E, 0xFA, 0x79, 0xB8,
  0x12, 0x01, 0xA0, 0x90, 0xBD, 0x07, 0x20, 0x1A, 0x85, 0x90, 0x8D, 0xFC, 0x63, 0x01, 0xA0, 0xA7,
  0x20, 0x1A, 0x0A, 0x72, 0x01, 0xA0, 0xA7, 0x20, 0x1A, 0x0A, 0x72, 0x01, 0xA0, 0xA7, 0x20, 0x1A,
  0x0A, 0x72, 0x01, 0xA0, 0xA7, 0x20,
  // "q" (U+0071)
  0x28, 0x93, 0x19, 0xEE, 0xB3, 0x0C, 0xF9, 0x01, 0xDD, 0x84, 0x4E, 0xF9, 0x0A, 0xA8, 0x3D, 0x78,
  0xEE, 0xA0, 0x90, 0x1A, 0x0E, 0x01, 0x20, 0x10, 0xEA, 0x09, 0x06, 0xA0, 0x84, 0x09, 0xA0, 0x90,
  0x8A, 0x04, 0x40, 0x5A, 0x09, 0x0A, 0xA0, 0x24, 0x03, 0xA0, 0x90, 0xBA, 0x01, 0x40, 0x2A, 0x09,
  0x0B, 0xA0, 0x14, 0x02, 0xA0, 0x90, 0xAA, 0x01, 0x40, 0x2A, 0x00, 0x9A, 0x03, 0x40, 0x4A, 0x09,
  0x06, 0xA0, 0x74, 0x08, 0xA0, 0x90, 0x2A, 0x0D, 0x01, 0x20, 0x10, 0xEA, 0x81, 0x90, 0xAA, 0x83,
  0xD7, 0x8D, 0xDA, 0x82, 0x90, 0x1E, 0xC0, 0xE0, 0x4A, 0x09, 0x28, 0x51, 0xAE, 0xEB, 0x22, 0xA0,
  0x97, 0x10, 0x2A, 0x09, 0x71, 0x02, 0xA0, 0x97, 0x10, 0x2A, 0x09, 0x71, 0x02, 0xA0, 0x97, 0x10,
  0x2A, 0x09, 0x71, 0x02, 0xA0, 0x97, 0x10, 0x2A, 0x09,
  // "r" (U+0072)
  0x01, 0xA8, 0x52, 0x08, 0xEF, 0x61, 0xA0, 0x40, 0xAB, 0x04, 0x01, 0xA8, 0x5B, 0xFD, 0x78, 0x11,
  0xB0, 0xC4, 0x01, 0xB0, 0x44, 0x01, 0xA0, 0xE5, 0x01, 0xA0, 0xC5, 0x01, 0xA0, 0xA5, 0x01, 0xA0,
  0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5,
  0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5,
  // "s" (U+0073)
  0x18, 0x90, 0x18, 0xDF, 0xEC, 0x71, 0x1D, 0xE0, 0x0A, 0xA8, 0x7C, 0x77, 0xBF, 0x4E, 0xFD, 0x48,
  0x33, 0x0E, 0xFC, 0x60, 0xBA, 0x05, 0x50, 0x4B, 0x0A, 0x02, 0x40, 0x6C, 0x07, 0x40, 0x30, 0xCB,
  0x0B, 0x50, 0x50, 0xEA, 0x07, 0x50, 0x2A, 0x0C, 0x68, 0x2C, 0xFE, 0x54, 0x89, 0x01, 0xEF, 0xDF,
  0xD9, 0x77, 0xDA, 0x08, 0xF8, 0x90, 0xD1, 0x4A, 0xDE, 0xFD, 0x81, 0x10,
  // "t" (U+0074)
  0x30, 0x70, 0x66, 0x81, 0x3F, 0xD6, 0x81, 0x6F, 0xD6, 0x81, 0xAF, 0xD4, 0x01, 0x09, 0xD8, 0x1E,
  0x08, 0xE8, 0x5E, 0x03, 0x6E, 0xFE, 0x0F, 0x63, 0x81, 0xEF, 0xD6, 0x81, 0xEF, 0xD6, 0x81, 0xEF,
  0xD6, 0x81, 0xEF, 0xD6, 0x81, 0xEF, 0xD6, 0x81, 0xEF, 0xD6, 0x81, 0xEF, 0xD6, 0x81, 0xEF, 0xD6,
  0x81, 0xEF, 0xD6, 0x0D, 0xA0, 0x15, 0x0A, 0xA8, 0x2C, 0x79, 0x12, 0x04, 0xD0, 0x13, 0x84, 0x5D,
  0xFE, 0xA1,
  // "u" (U+0075)
  0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0,
  0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A,
  0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03,
  0xA0, 0x90, 0x2A, 0x09, 0x40, 0x4A, 0x09, 0x02, 0xA0, 0xA4, 0x05, 0xA0, 0x90, 0x1A, 0x0C, 0x40,
  0x9A, 0x81, 0x90, 0xEA, 0x02, 0x20, 0x20, 0xEA, 0x81, 0x90, 0x9A, 0x83, 0xE8, 0x8E, 0xEA, 0x82,
  0x90, 0x2E, 0xD8, 0x25, 0xDF, 0x92, 0x89, 0x02, 0xBE, 0xEB, 0x40, 0xBF, 0x90,
  // "v" (U+0076)
  0x0C, 0xA0, 0x15, 0x82, 0xEF, 0xD7, 0xA0, 0x44, 0x03, 0xA0, 0x90, 0x3A, 0x08, 0x40, 0x7A, 0x83,
  0x40, 0xEF, 0xC4, 0x0B, 0xA2, 0x0A, 0xA0, 0x13, 0x81, 0xEF, 0xB2, 0x06, 0xA0, 0x42, 0x03, 0xA0,
  0x72, 0x01, 0xA0, 0x82, 0x07, 0xA0, 0x33, 0x81, 0xDF, 0xC2, 0x81, 0xBF, 0xE4, 0x08, 0xA2, 0x81,
  0xEF, 0xA4, 0x04, 0xA0, 0x40, 0x3A, 0x05, 0x5A, 0x00, 0x7A, 0x01, 0x58, 0x4B, 0xFB, 0xAF, 0xC6,
  0x84, 0x7F, 0xDD, 0xF8, 0x60, 0x2C, 0x03, 0x70, 0xDA, 0x0E, 0x71, 0x09, 0xA0, 0xA4,
  // "w" (U+0077)
  0x0A, 0xA0, 0x23, 0x01, 0xB0, 0x34, 0x82, 0xEF, 0xB6, 0xA0, 0x53, 0x04, 0xB0, 0x63, 0x02, 0xA0,
  0x70, 0x3A, 0x08, 0x30, 0x8B, 0x09, 0x30, 0x6A, 0x04, 0x1A, 0x0B, 0x38, 0x3B, 0xFC, 0xFD, 0x30,
  0x9A, 0x83, 0x10, 0xBF, 0xE3, 0x81, 0xEF, 0x7A, 0x01, 0x28, 0x1C, 0xFC, 0x20, 0x8A, 0x81, 0x20,
  0x3A, 0x02, 0xA0, 0x42, 0xA0, 0x92, 0x05, 0xA8, 0x91, 0x50, 0x6F, 0xD0, 0xDF, 0x70, 0x3A, 0x06,
  0x20, 0x1A, 0x89, 0x18, 0x0A, 0xFA, 0x09, 0xFA, 0x06, 0xA0, 0x23, 0x89, 0x5D, 0xFB, 0x0D, 0xF7,
  0x06, 0xFD, 0x09, 0xFE, 0x48, 0x1A, 0xFE, 0x1A, 0x81, 0x40, 0x3A, 0x82, 0x1C, 0xFB, 0x40, 0x7A,
  0x04, 0xA0, 0x12, 0xA0, 0x4A, 0x07, 0x40, 0x3A, 0x81, 0x8F, 0xD3, 0x81, 0xCF, 0x8A, 0x04, 0x5A,
  0x81, 0xDF, 0x93, 0x81, 0x9F, 0xDA, 0x60, 0xCB, 0x06, 0x30, 0x6B, 0x0C, 0x60, 0x9B, 0x03, 0x30,
  0x3B, 0x09, 0x60, 0x5B, 0x5B, 0x05, 0x30,
  // "x" (U+0078)
  0x03, 0xA0, 0xC4, 0x08, 0xA8, 0x17, 0x0A, 0xA0, 0x43, 0x81, 0xEF, 0xE2, 0x03, 0xA0, 0xB2, 0x06,
  0xA0, 0x73, 0x0A, 0xA8, 0x32, 0x0D, 0xFE, 0x40, 0x3A, 0x09, 0x05, 0xA0, 0x75, 0x0A, 0xA8, 0x1D,
  0xFE, 0x60, 0x3C, 0x07, 0x70, 0xBA, 0x0E, 0x01, 0x70, 0xDB, 0x02, 0x60, 0x6C, 0x09, 0x68, 0x2D,
  0xFD, 0xBA, 0x02, 0x40, 0x6A, 0x07, 0x03, 0xA0, 0x94, 0x81, 0xDF, 0xE2, 0x0B, 0xA0, 0x22, 0x06,
  0xA0, 0x72, 0x04, 0xA0, 0x92, 0x82, 0xDF, 0xE1, 0x30, 0xCA, 0x02, 0x06, 0xA0, 0x84, 0x05, 0xA0,
  0xA0,
  // "y" (U+0079)
  0x0C, 0xA0, 0x25, 0x82, 0xEF, 0xE7, 0xA0, 0x64, 0x03, 0xA0, 0x90, 0x2A, 0x0A, 0x40, 0x7A, 0x83,
  0x50, 0xDF, 0xE4, 0x0B, 0xA8, 0x11, 0x09, 0xA0, 0x23, 0x81, 0xEF, 0xC2, 0x04, 0xA0, 0x62, 0x03,
  0xA0, 0x73, 0xA0, 0xB2, 0x07, 0xA0, 0x33, 0x81, 0xBF, 0xE2, 0x81, 0xBF, 0xE4, 0x06, 0xA0, 0x31,
  0xA0, 0xA4, 0x01, 0xA0, 0x70, 0x3A, 0x05, 0x58, 0x2C, 0xFA, 0x7A, 0x01, 0x58, 0x48, 0xFD, 0xAF,
  0xC6, 0x03, 0xA8, 0x1E, 0xF8, 0x70, 0xEB, 0x03, 0x70, 0xAA, 0x0E, 0x71, 0x05, 0xA0, 0xA7, 0x10,
  0x6A, 0x06, 0x71, 0x0A, 0xA0, 0x27, 0x1A, 0x0C, 0x71, 0x07, 0xA0, 0x75, 0x81, 0x48, 0xAA, 0x0E,
  0x01, 0x50, 0x6C, 0x05, 0x68, 0x35, 0xEF, 0xC4, 0x70,
  // "z" (U+007A)
  0x10, 0xEF, 0x81, 0x50, 0xEF, 0x05, 0x18, 0x01, 0x60, 0xEA, 0x02, 0x50, 0x3A, 0x0A, 0x60, 0xAA,
  0x03, 0x50, 0x2A, 0x0B, 0x60, 0x9A, 0x04, 0x50, 0x2A, 0x0C, 0x60, 0x9A, 0x05, 0x50, 0x1A, 0x0D,
  0x60, 0x8A, 0x05, 0x58, 0x21, 0xEF, 0xD6, 0x07, 0xA0, 0x66, 0x0E, 0xA8, 0x57, 0x66, 0x66, 0x33,
  0xF9, 0x08, 0x03, 0xF9, 0x08,
  // "{" (U+007B)
  0x58, 0x31, 0x8C, 0xE4, 0x40, 0x20, 0xEB, 0x04, 0x40, 0xBA, 0x81, 0xD8, 0x24, 0xA0, 0xD6, 0x01,
  0xA0, 0x96, 0x01, 0xA0, 0x86, 0x01, 0xA0, 0x86, 0x01, 0xA0, 0x86, 0x01, 0xA0, 0x86, 0x02, 0xA0,
  0x76, 0x08, 0xA0, 0x54, 0x07, 0x0B, 0xA0, 0xD4, 0x01, 0xB0, 0x70, 0x14, 0x01, 0xB0, 0xE0, 0x55,
  0x81, 0x14, 0xDA, 0x02, 0x60, 0x4A, 0x06, 0x60, 0x1A, 0x08, 0x60, 0x1A, 0x08, 0x60, 0x1A, 0x08,
  0x60, 0x1A, 0x08, 0x60, 0x1A, 0x08, 0x7A, 0x0B, 0x70, 0xDA, 0x07, 0x01, 0x50, 0x7C, 0x04, 0x50,
  0x8B, 0x04, 0x78, 0x14, 0x61,
  // "|" (U+007C)
  0x89, 0xA5, 0xEF, 0x7E, 0xF7, 0xEF, 0x7E, 0xF7, 0xEF, 0x7E, 0xF7, 0xEF, 0x7E, 0xF7, 0xEF, 0x7E,
  0xF7, 0xEF, 0x7E, 0xF7, 0xEF, 0x7E, 0xF7, 0xEF, 0x7E, 0xF7, 0xEF, 0x7E, 0xF7, 0xEF, 0x7E, 0xF7,
  0xEF, 0x7E, 0xF7, 0xEF, 0x7E, 0xF7, 0xEF, 0x7E, 0xF7, 0xEF, 0x7E, 0xF7, 0xEF, 0x70,
  // "}" (U+007D)
  0x82, 0xED, 0xA4, 0x5C, 0x07, 0x40, 0x70, 0xBB, 0x01, 0x50, 0x9A, 0x04, 0x50, 0x4A, 0x06, 0x50,
  0x3A, 0x06, 0x50, 0x3A, 0x06, 0x50, 0x3A, 0x06, 0x50, 0x3A, 0x06, 0x50, 0x3A, 0x07, 0x50, 0x1A,
  0x0D, 0x60, 0x9A, 0x81, 0xD8, 0x24, 0x06, 0x0D, 0xA0, 0x63, 0x02, 0x0B, 0xB0, 0x63, 0x0D, 0xA0,
  0x70, 0x13, 0x02, 0xA0, 0x95, 0x03, 0xA0, 0x65, 0x03, 0xA0, 0x65, 0x03, 0xA0, 0x65, 0x03, 0xA0,
  0x65, 0x04, 0xA0, 0x65, 0x06, 0xA0, 0x54, 0x04, 0x0D, 0xA0, 0x33, 0xC0, 0xB4, 0xB0, 0xB0, 0x14,
  0x81, 0x65, 0x26,
  // "~" (U+007E)
  0x84, 0x2A, 0xEE, 0xB6, 0x48, 0x13, 0x6E, 0xD8, 0x91, 0xEA, 0x79, 0xF8, 0xFC, 0x78, 0xCE, 0x06,
  0x08, 0x48, 0x43, 0x9D, 0xFD, 0x61,
  // "¡" (U+00A1)
  0x18, 0x39, 0xEA, 0x02, 0xB0, 0x30, 0x2B, 0x83, 0x30, 0x9E, 0xA7, 0x58, 0x19, 0xF9, 0x28, 0x19,
  0xF9, 0x28, 0x1A, 0xFA, 0x28, 0x1A, 0xFA, 0x28, 0x1B, 0xFB, 0x28, 0x1C, 0xFC, 0x28, 0x1C, 0xFC,
  0x28, 0x1D, 0xFD, 0x28, 0x1E, 0xFD, 0x28, 0x1E, 0xFE, 0x2B, 0x2B, 0x2B, 0x10, 0x1B, 0x01, 0x02,
  0xB0, 0x20,
  // "¢" (U+00A2)
  0x48, 0x15, 0xF7, 0x78, 0x15, 0xF7, 0x68, 0x41, 0x9F, 0xB5, 0x13, 0x07, 0xE8, 0x13, 0x07, 0xE8,
  0x2E, 0x01, 0xEA, 0x85, 0x71, 0x14, 0x60, 0x6A, 0x09, 0x60, 0x9A, 0x03, 0x60, 0xCA, 0x78, 0x1D,
  0xFE, 0x78, 0x1D, 0xFE, 0x78, 0x1D, 0xFE, 0x70, 0xCA, 0x70, 0x9A, 0x03, 0x60, 0x6A, 0x09, 0x60,
  0x10, 0xEA, 0x86, 0x71, 0x13, 0x91, 0x06, 0xF0, 0x22, 0x06, 0x0E, 0xC0, 0xC0, 0x14, 0x82, 0x7F,
  0x91, 0x68, 0x15, 0xF6, 0x78, 0x15, 0xF6, 0x30,
  // "£" (U+00A3)
  0x48, 0x55, 0xBE, 0xFD, 0x82, 0x40, 0x7E, 0x0E, 0x30, 0x2B, 0x83, 0x97, 0xAF, 0x93, 0x07, 0xA0,
  0x73, 0x00, 0x23, 0x09, 0xA0, 0x27, 0x10, 0xBA, 0x01, 0x71, 0x0B, 0xA0, 0x17, 0x10, 0xBA, 0x01,
  0x71, 0x0B, 0xA0, 0x16, 0x81, 0x56, 0xDA, 0x83, 0x76, 0x66, 0x12, 0x0D, 0xF9, 0x02, 0x20, 0xDF,
  0x90, 0x24, 0x0B, 0xA0, 0x17, 0x10, 0xBA, 0x01, 0x71, 0x0B, 0xA0, 0x17, 0x10, 0xCA, 0x72, 0x81,
  0xEF, 0xC7, 0x10, 0x6A, 0x05, 0x70, 0x6A, 0x0C, 0x80, 0x36, 0x03, 0x0D, 0xFB, 0x06, 0x0D, 0xFB,
  0x06,
  // "¤" (U+00A4)
  0x10, 0x60, 0x37, 0x18, 0xA1, 0x81, 0x4F, 0xE1, 0x5C, 0xFE, 0x91, 0x7F, 0xC0, 0xCF, 0xED, 0x0E,
  0xA8, 0x26, 0x02, 0xEA, 0x82, 0xB7, 0x8D, 0xA0, 0x93, 0x81, 0xEF, 0x54, 0x81, 0xBF, 0x82, 0x81,
  0x5F, 0x95, 0x81, 0x1E, 0xE2, 0x81, 0x8F, 0x56, 0x85, 0xBF, 0x20, 0x9F, 0x56, 0x85, 0xBF, 0x20,
  0x6F, 0x95, 0x01, 0x0E, 0x92, 0x82, 0x1E, 0xF5, 0x48, 0x1B, 0xF9, 0x20, 0x10, 0xEA, 0x82, 0xA7,
  0x8D, 0xA0, 0x82, 0x81, 0xCF, 0xED, 0x0E, 0xA8, 0x97, 0x53, 0xFE, 0x25, 0xCF, 0xE9, 0x18, 0xFC,
  0x06, 0x37, 0x10, 0x80, 0x10,
  // "¥" (U+00A5)
  0x02, 0xA0, 0xB5, 0x06, 0xA8, 0x18, 0x0C, 0xA0, 0x14, 0x0B, 0xA8, 0x12, 0x06, 0xA0, 0x63, 0x01,
  0xA0, 0xC2, 0x01, 0xA0, 0xC3, 0x06, 0xA0, 0x63, 0x0A, 0xA0, 0x22, 0x0B, 0xA0, 0x13, 0x05, 0xA8,
  0x17, 0x01, 0xA0, 0xA5, 0x83, 0xEF, 0xD0, 0x6A, 0x04, 0x50, 0x9A, 0x82, 0x2B, 0xFE, 0x60, 0x3A,
  0x09, 0xA0, 0x97, 0x0D, 0xC0, 0x37, 0x07, 0xB0, 0xD5, 0x01, 0xFA, 0x08, 0x20, 0x1F, 0xA0, 0x86,
  0x0B, 0xA0, 0x17, 0x20, 0xAA, 0x01, 0x50, 0x1F, 0xA0, 0x82, 0x01, 0xFA, 0x08, 0x30, 0xF6, 0x0C,
  0xA8, 0x27, 0x66, 0x36, 0x0A, 0xA0, 0x17, 0x20, 0xAA, 0x01, 0x72, 0x0A, 0xA0, 0x14,
  // "¦" (U+00A6)
  0x8B, 0x7E, 0xF7, 0xEF, 0x7E, 0xF7, 0xEF, 0x7E, 0xF7, 0xEF, 0x7E, 0xF7, 0xEF, 0x7E, 0xF7, 0xEF,
  0x7E, 0xF7, 0x77, 0x78, 0xB7, 0xEF, 0x7E, 0xF7, 0xEF, 0x7E, 0xF7, 0xEF, 0x7E, 0xF7, 0xEF, 0x7E,
  0xF7, 0xEF, 0x7E, 0xF7, 0xEF, 0x70,
  // "§" (U+00A7)
  0x28, 0x55, 0xCE, 0xFD, 0x81, 0x20, 0x9E, 0x81, 0xE0, 0x3A, 0x86, 0xD8, 0x7A, 0xE9, 0x06, 0xA0,
  0x23, 0x82, 0x11, 0x06, 0xA0, 0x16, 0x02, 0xA0, 0xA0, 0x16, 0x07, 0xA0, 0xE0, 0x75, 0x02, 0x0D,
  0xB0, 0xD0, 0x42, 0x84, 0x1D, 0xF9, 0x7E, 0xA8, 0x36, 0x07, 0xFB, 0x28, 0x61, 0xCF, 0xE1, 0xAF,
  0x93, 0x02, 0xA8, 0x33, 0x8F, 0xE1, 0x3A, 0x04, 0x02, 0xA8, 0x4E, 0x50, 0x5F, 0xE2, 0x05, 0x0E,
  0xA8, 0x2C, 0xEF, 0x63, 0x02, 0x0A, 0xB0, 0xC6, 0x03, 0x0B, 0xA0, 0x97, 0x09, 0xA0, 0x16, 0x04,
  0xA8, 0x13, 0x51, 0x40, 0x7A, 0x85, 0x2B, 0xFA, 0x77, 0xAA, 0x81, 0xD0, 0xAE, 0x0E, 0x03, 0x28,
  0x56, 0xCE, 0xFD, 0x92, 0x20,
  // "¨" (U+00A8)
  0x89, 0x01, 0xDD, 0x10, 0x2D, 0xD1, 0x5A, 0x81, 0x50, 0x6A, 0x89, 0x04, 0x1D, 0xD1, 0x02, 0xDD,
  0x10,
  // "©" (U+00A9)
  0x68, 0x72, 0x7C, 0xDF, 0xEC, 0x84, 0x73, 0x01, 0x0A, 0xB8, 0x1E, 0xDD, 0xB0, 0xC0, 0x37, 0x84,
  0x3E, 0xFC, 0x51, 0x40, 0x40, 0xBA, 0x06, 0x58, 0x23, 0xEF, 0x73, 0x82, 0x35, 0x63, 0x28, 0x25,
  0xEF, 0x54, 0x81, 0xDF, 0x52, 0x03, 0x0C, 0xC8, 0x5D, 0x50, 0x2E, 0xF2, 0x28, 0x17, 0xF8, 0x20,
  0x20, 0xEE, 0x05, 0x28, 0x15, 0xFB, 0x20, 0xE0, 0xD3, 0x0B, 0xA8, 0x36, 0x10, 0x38, 0x48, 0x4B,
  0xF2, 0x4F, 0x82, 0x02, 0xA0, 0x67, 0x28, 0x44, 0xF7, 0x7F, 0x32, 0x81, 0x6F, 0xE7, 0x49, 0x82,
  0xB9, 0xF1, 0x28, 0x18, 0xFC, 0x74, 0x81, 0xDC, 0xA9, 0x38, 0x18, 0xFB, 0x74, 0x83, 0xCD, 0x9F,
  0x12, 0x81, 0x8F, 0xC7, 0x48, 0x3D, 0xC7, 0xF3, 0x20, 0x5A, 0x01, 0x73, 0x98, 0x2B, 0x4F, 0x72,
  0x01, 0xA0, 0x97, 0x28, 0x44, 0xF7, 0x0E, 0xD3, 0x09, 0xA8, 0x4C, 0x77, 0x9D, 0x33, 0x85, 0xBF,
  0x30, 0x8F, 0x82, 0x01, 0x0C, 0xE0, 0x32, 0x81, 0x5F, 0xB2, 0x82, 0x1E, 0xF5, 0x38, 0x47, 0xCE,
  0xEC, 0x62, 0x82, 0x2E, 0xF3, 0x30, 0x3A, 0x07, 0x72, 0x82, 0x5E, 0xF6, 0x58, 0x44, 0xEF, 0xC5,
  0x14, 0x04, 0x0A, 0xA0, 0x77, 0x02, 0x0B, 0xB8, 0x1E, 0xDD, 0xB0, 0xC0, 0x37, 0x38, 0x73, 0x8C,
  0xEF, 0xEC, 0x94, 0x60,
  // "ª" (U+00AA)
  0x18, 0x43, 0xAD, 0xFD, 0x72, 0x85, 0x4E, 0x86, 0xDF, 0x65, 0x81, 0x4F, 0xB4, 0x86, 0x14, 0xFC,
  0x02, 0xAE, 0xB8, 0x92, 0xC0, 0xEF, 0x84, 0x5F, 0xC3, 0xFC, 0x28, 0x93, 0x4F, 0xC1, 0xFE, 0x33,
  0xCF, 0xC0, 0x8B, 0x81, 0x7C, 0xC2, 0x84, 0x23, 0x10, 0x23,
  // "«" (U+00AB)
  0x40, 0x25, 0x01, 0x48, 0x15, 0xFA, 0x38, 0x1A, 0xE7, 0x28, 0x22, 0xEF, 0xB2, 0x06, 0xA0, 0x52,
  0x84, 0xCF, 0xE1, 0x03, 0xA0, 0xB2, 0x09, 0xA8, 0x75, 0x01, 0xDF, 0xE1, 0x05, 0xA0, 0xB2, 0x0B,
  0xA0, 0x62, 0x0E, 0xA8, 0x13, 0x04, 0xA0, 0xD3, 0x06, 0xA0, 0xA2, 0x0B, 0xA0, 0x53, 0x0A, 0xA8,
  0x55, 0x01, 0xEF, 0xE1, 0x38, 0x4D, 0xFE, 0x10, 0x3A, 0x0A, 0x30, 0x2A, 0x0A, 0x20, 0x7A, 0x05,
  0x38, 0x26, 0xFB, 0x12, 0x81, 0xBF, 0x74, 0x03, 0x40, 0x10, 0x21,
  // "¬" (U+00AC)
  0x80, 0x76, 0x02, 0xFC, 0x04, 0xFC, 0x04, 0x72, 0xA0, 0x47, 0x2A, 0x04, 0x72, 0xA0, 0x47, 0x2A,
  0x04, 0x72, 0xA0, 0x47, 0x28, 0x17, 0x72,
  // "®" (U+00AE)
  0x68, 0x72, 0x7C, 0xDF, 0xEC, 0x84, 0x73, 0x01, 0x0A, 0xB8, 0x1E, 0xDD, 0xB0, 0xC0, 0x37, 0x84,
  0x3E, 0xFC, 0x51, 0x40, 0x40, 0xBA, 0x06, 0x58, 0x91, 0x3E, 0xF7, 0x16, 0x66, 0x64, 0x12, 0x82,
  0x5E, 0xF5, 0x48, 0x3D, 0xF5, 0x03, 0xE0, 0x62, 0x82, 0x2E, 0xF2, 0x28, 0x17, 0xF8, 0x20, 0x3F,
  0x03, 0x28, 0x15, 0xFB, 0x20, 0xE0, 0xD3, 0x03, 0xA2, 0x82, 0x4E, 0xF8, 0x38, 0x4B, 0xF2, 0x4F,
  0x83, 0x03, 0xA3, 0x81, 0xAF, 0xA3, 0x84, 0x4F, 0x77, 0xF3, 0x30, 0x3A, 0x38, 0x1A, 0xF9, 0x49,
  0x82, 0xB9, 0xF1, 0x30, 0x3A, 0x20, 0x5A, 0x04, 0x48, 0x1D, 0xCA, 0x94, 0x03, 0xE0, 0xA5, 0x83,
  0xCD, 0x9F, 0x13, 0x03, 0xA8, 0x2D, 0xDF, 0xD6, 0x83, 0xDC, 0x7F, 0x33, 0x03, 0xA2, 0x81, 0xEF,
  0x45, 0x98, 0x2B, 0x4F, 0x73, 0x03, 0xA2, 0x81, 0x7F, 0xD4, 0x84, 0x4F, 0x70, 0xED, 0x30, 0x3A,
  0x38, 0x1E, 0xF6, 0x38, 0x5B, 0xF3, 0x08, 0xF8, 0x20, 0x3A, 0x38, 0x16, 0xFE, 0x28, 0x15, 0xFB,
  0x28, 0x61, 0xEF, 0x50, 0x17, 0x74, 0x85, 0x77, 0x22, 0xEF, 0x33, 0x03, 0xA0, 0x77, 0x28, 0x25,
  0xEF, 0x65, 0x84, 0x4E, 0xFC, 0x51, 0x40, 0x40, 0xAA, 0x07, 0x70, 0x20, 0xBB, 0x81, 0xED, 0xDB,
  0x0C, 0x03, 0x73, 0x87, 0x38, 0xCE, 0xFE, 0xC9, 0x46,
  // "¯" (U+00AF)
  0x18, 0x09, 0x16, 0x01, 0xFE, 0x01, 0xFE,
  // "°" (U+00B0)
  0x18, 0x41, 0x9E, 0xFD, 0x72, 0x01, 0x0D, 0xA0, 0xDA, 0x83, 0xA0, 0x8F, 0xB2, 0x85, 0x2D, 0xF3,
  0xBF, 0x33, 0x84, 0x7F, 0x7B, 0xF3, 0x38, 0x47, 0xF7, 0x8F, 0xB2, 0x84, 0x2D, 0xF3, 0x1D, 0xA0,
  0xDA, 0x0A, 0x28, 0x41, 0x9E, 0xFD, 0x72,
  // "±" (U+00B1)
  0x48, 0x16, 0xFD, 0x72, 0x81, 0x6F, 0xD7, 0x28, 0x16, 0xFD, 0x72, 0x81, 0x6F, 0xD7, 0x28, 0x16,
  0xFD, 0x72, 0x81, 0x6F, 0xD5, 0xFC, 0x06, 0xFC, 0x80, 0x16, 0x86, 0xAF, 0xE6, 0x66, 0x63, 0x48,
  0x16, 0xFD, 0x72, 0x81, 0x6F, 0xD7, 0x28, 0x16, 0xFD, 0x72, 0x81, 0x6F, 0xD7, 0x28, 0x16, 0xFD,
  0x77, 0x38, 0x07, 0x60, 0x3F, 0xC0, 0x7F, 0xC0, 0x70,
  // "²" (U+00B2)
  0x18, 0x41, 0x9E, 0xEC, 0x62, 0x01, 0x0E, 0xA0, 0xEA, 0x06, 0x20, 0x90, 0x82, 0x81, 0x9F, 0xC6,
  0x81, 0x5F, 0xD6, 0x81, 0x8F, 0xA5, 0x82, 0x2E, 0xF3, 0x58, 0x1C, 0xF7, 0x58, 0x1B, 0xF9, 0x58,
  0x1A, 0xFA, 0x58, 0x19, 0xFB, 0x50, 0x3A, 0x80, 0x1E, 0x01, 0x04, 0xF0, 0x10,
  // "³" (U+00B3)
  0x18, 0x41, 0x8C, 0xDA, 0x32, 0x01, 0x0E, 0xD0, 0x32, 0x85, 0xB8, 0x11, 0xBF, 0xA6, 0x81, 0x4F,
  0xC6, 0x81, 0x5F, 0xB5, 0x82, 0x3D, 0xF5, 0x30, 0x8B, 0x06, 0x40, 0x70, 0xEA, 0x0D, 0x04, 0x68,
  0x16, 0xFE, 0x7A, 0x82, 0x32, 0x61, 0x20, 0x5A, 0x01, 0x04, 0xA0, 0xEB, 0x87, 0x90, 0x18, 0xCE,
  0xEC, 0x62,
  // "´" (U+00B4)
  0x28, 0x23, 0x77, 0x62, 0x0D, 0xA8, 0x16, 0x07, 0xA8, 0x47, 0x02, 0xEF, 0x82, 0x81, 0xBF, 0x83,
  // "µ" (U+00B5)
  0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0,
  0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A,
  0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01,
  0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x2A, 0x09, 0x01, 0xA0, 0xB4, 0x04, 0xA0, 0x90, 0x1A, 0x0D, 0x40,
  0x8A, 0x09, 0x01, 0xB0, 0x32, 0x01, 0x0E, 0xA0, 0x90, 0x1B, 0x83, 0xE8, 0x8D, 0xEA, 0x09, 0x01,
  0xF8, 0x37, 0xCF, 0x91, 0xA8, 0x90, 0x99, 0xED, 0x70, 0x9F, 0x91, 0xA0, 0x97, 0x10, 0x1A, 0x0A,
  0x71, 0x01, 0xA0, 0xA7, 0x10, 0x1A, 0x0A, 0x71, 0x01, 0xA0, 0xA7, 0x10, 0x1A, 0x0A, 0x71, 0x01,
  0xA0, 0xA7, 0x10,
  // "¶" (U+00B6)
  0x28, 0x11, 0x9E, 0xE8, 0x2B, 0x01, 0xDF, 0x98, 0x1B, 0x09, 0xD8, 0x5E, 0x67, 0xFB, 0x0E, 0xD0,
  0xE2, 0x90, 0xB0, 0x3E, 0x0E, 0x29, 0x0B, 0x05, 0xE0, 0xE2, 0x90, 0xB0, 0x6E, 0x0E, 0x29, 0x0B,
  0x06, 0xE0, 0xE2, 0x90, 0xB0, 0x6E, 0x0E, 0x29, 0x0B, 0x05, 0xE0, 0xE2, 0x90, 0xB0, 0x3E, 0x0E,
  0x29, 0x0B, 0x1E, 0x0E, 0x29, 0x81, 0xB0, 0xBD, 0x0E, 0x29, 0x81, 0xB0, 0x3D, 0x0E, 0x29, 0x0B,
  0x28, 0x44, 0xCF, 0xEF, 0xE2, 0x90, 0xB6, 0x0D, 0x0E, 0x29, 0x0B, 0x60, 0xD0, 0xE2, 0x90, 0xB6,
  0x0D, 0x0E, 0x29, 0x0B, 0x60, 0xD0, 0xE2, 0x90, 0xB6, 0x0D, 0x0E, 0x29, 0x0B, 0x60, 0xD0, 0xE2,
  0x90, 0xB6, 0x0D, 0x0E, 0x29, 0x0B, 0x60, 0xD0, 0xE2, 0x90, 0xB6, 0x0D, 0x0E, 0x29, 0x0B, 0x60,
  0xD0, 0xE2, 0x90, 0xB6, 0x0D, 0x0E, 0x29, 0x0B, 0x60, 0x05, 0x20, 0x60, 0x40,
  // "·" (U+00B7)
  0x18, 0x3A, 0xE9, 0x03, 0xB0, 0x20, 0x3B, 0x83, 0x20, 0xAE, 0x91,
  // "¸" (U+00B8)
  0x18, 0x14, 0xF5, 0x38, 0x1B, 0xF6, 0x38, 0x27, 0xDF, 0xC4, 0xA0, 0x42, 0x02, 0xA8, 0x13, 0xDD,
  0xA8, 0x5D, 0x0D, 0xFE, 0xA2, 0x10,
  // "¹" (U+00B9)
  0x28, 0x52, 0xCF, 0x80, 0x4E, 0xA0, 0x80, 0x7A, 0x89, 0x5C, 0xF8, 0x7E, 0x38, 0xF8, 0x01, 0x09,
  0xF8, 0x38, 0x19, 0xF8, 0x38, 0x19, 0xF8, 0x38, 0x19, 0xF8, 0x38, 0x19, 0xF8, 0x38, 0x19, 0xF8,
  0x38, 0x19, 0xF8, 0x38, 0x19, 0xF8,
  // "º" (U+00BA)
  0x28, 0x45, 0xCF, 0xE9, 0x12, 0x85, 0x5F, 0xD7, 0xAF, 0xC2, 0x81, 0xDF, 0x42, 0x82, 0xCF, 0x41,
  0xA3, 0x84, 0x8F, 0x82, 0xFE, 0x38, 0x46, 0xF9, 0x2F, 0xE3, 0x85, 0x7F, 0x80, 0xEF, 0x22, 0x89,
  0x1A, 0xF5, 0x07, 0xFB, 0x25, 0xFE, 0x30, 0x9B, 0x0D, 0x03, 0x48, 0x11, 0x33, 0x30,
  // "»" (U+00BB)
  0x10, 0x15, 0x02, 0x48, 0x18, 0xF8, 0x28, 0x21, 0xBF, 0x43, 0x07, 0xA0, 0x52, 0x82, 0xCF, 0xE1,
  0x38, 0x4C, 0xFE, 0x20, 0x2A, 0x0B, 0x30, 0x2A, 0x0C, 0x20, 0x7A, 0x08, 0x30, 0x7A, 0x09, 0x20,
  0xCA, 0x04, 0x30, 0xEA, 0x81, 0x30, 0x4A, 0x0D, 0x20, 0x6A, 0x0A, 0x20, 0xBA, 0x84, 0x50, 0x2E,
  0xFD, 0x20, 0x6A, 0x09, 0x20, 0xBA, 0x84, 0x20, 0x2E, 0xFC, 0x20, 0x6A, 0x06, 0x28, 0x2C, 0xFE,
  0x22, 0x81, 0x8F, 0x92, 0x82, 0x1C, 0xF4, 0x40, 0x25, 0x03, 0x40,
  // "¼" (U+00BC)
  0x28, 0x24, 0xEF, 0x57, 0x82, 0x4F, 0xE1, 0x40, 0x7B, 0x05, 0x78, 0x1C, 0xF8, 0x48, 0x4A, 0xFE,
  0xDF, 0x56, 0x82, 0x4F, 0xE1, 0x48, 0x4A, 0xC2, 0xCF, 0x56, 0x81, 0xCF, 0x75, 0x01, 0x28, 0x1D,
  0xF5, 0x58, 0x14, 0xFE, 0x72, 0x81, 0xDF, 0x55, 0x81, 0xCF, 0x77, 0x28, 0x1D, 0xF5, 0x48, 0x15,
  0xFE, 0x73, 0x81, 0xDF, 0x54, 0x81, 0xCF, 0x77, 0x38, 0x1D, 0xF5, 0x38, 0x15, 0xFE, 0x30, 0x6A,
  0x58, 0x1D, 0xF5, 0x38, 0x1C, 0xF7, 0x30, 0xEA, 0x58, 0x1D, 0xF5, 0x28, 0x15, 0xFE, 0x30, 0x70,
  0xEA, 0x58, 0x1D, 0xF5, 0x28, 0x1D, 0xF6, 0x30, 0xE0, 0xAA, 0x72, 0x81, 0x5F, 0xD3, 0x81, 0x7F,
  0x3A, 0x72, 0x81, 0xDF, 0x63, 0x81, 0xEA, 0x1A, 0x71, 0x81, 0x6F, 0xD3, 0x82, 0x7F, 0x31, 0xA7,
  0x18, 0x1D, 0xF6, 0x28, 0x31, 0xEB, 0x01, 0xA7, 0x81, 0x6F, 0xD3, 0x83, 0x8F, 0x40, 0x1A, 0x78,
  0x1D, 0xF6, 0x30, 0xDF, 0x08, 0x48, 0x16, 0xFD, 0x40, 0xB8, 0x00, 0xDA, 0x0D, 0x07, 0x48, 0x1D,
  0xF5, 0x71, 0x01, 0xA5, 0x81, 0x6F, 0xD7, 0x20, 0x1A, 0x20,
  // "½" (U+00BD)
  0x28, 0x24, 0xEF, 0x37, 0x81, 0xBF, 0x85, 0x07, 0xB0, 0x36, 0x03, 0xA0, 0x14, 0x84, 0xAF, 0xEE,
  0xF3, 0x68, 0x1B, 0xF8, 0x58, 0x4D, 0xD2, 0xDF, 0x35, 0x82, 0x3F, 0xE1, 0x50, 0x22, 0x81, 0xDF,
  0x35, 0x81, 0xBF, 0x87, 0x28, 0x1E, 0xF3, 0x48, 0x24, 0xFE, 0x17, 0x28, 0x1E, 0xF3, 0x48, 0x1B,
  0xF8, 0x73, 0x81, 0xEF, 0x33, 0x82, 0x4F, 0xE1, 0x73, 0x81, 0xEF, 0x33, 0x87, 0xCF, 0x70, 0x5B,
  0xEC, 0x85, 0x81, 0xEF, 0x32, 0x83, 0x4F, 0xE1, 0x8D, 0x0B, 0x48, 0x1E, 0xF3, 0x28, 0x7C, 0xF7,
  0x03, 0xB3, 0x05, 0xA0, 0x23, 0x85, 0xEF, 0x30, 0x4F, 0xE7, 0x81, 0xEF, 0x37, 0x81, 0xCF, 0x77,
  0xA0, 0x26, 0x81, 0x5F, 0xE7, 0x81, 0x7F, 0xB7, 0x81, 0xCF, 0x76, 0x82, 0x3F, 0xE2, 0x68, 0x15,
  0xFE, 0x68, 0x22, 0xEF, 0x57, 0x81, 0xDF, 0x65, 0x82, 0x1D, 0xF7, 0x78, 0x15, 0xFD, 0x68, 0x1B,
  0xF9, 0x71, 0x81, 0xDF, 0x65, 0x86, 0xAF, 0xE6, 0x66, 0x63, 0x38, 0x15, 0xFD, 0x60, 0xDE, 0x07,
  0x38, 0x1D, 0xF6, 0x60, 0xDE, 0x07,
  // "¾" (U+00BE)
  0x38, 0x15, 0x63, 0x73, 0x01, 0x50, 0x50, 0xEB, 0x0C, 0x01, 0x78, 0x1B, 0xF8, 0x30, 0x1E, 0x09,
  0x68, 0x24, 0xFE, 0x14, 0x85, 0x87, 0x20, 0x9F, 0xC6, 0x81, 0xCF, 0x77, 0x28, 0x13, 0xFC, 0x58,
  0x24, 0xFE, 0x17, 0x28, 0x19, 0xF7, 0x58, 0x1C, 0xF7, 0x78, 0x36, 0xDE, 0xF8, 0x58, 0x14, 0xFE,
  0x71, 0x08, 0xB0, 0xB0, 0x14, 0x81, 0xCF, 0x77, 0x38, 0x21, 0x8F, 0xC3, 0x81, 0x4F, 0xE7, 0x68,
  0x1E, 0xF2, 0x28, 0x1C, 0xF7, 0x38, 0x4E, 0xF8, 0x01, 0x13, 0x01, 0xA8, 0x33, 0x05, 0xFE, 0x30,
  0x7A, 0x86, 0x80, 0x3F, 0xA7, 0x7D, 0xA8, 0x31, 0x0C, 0xF7, 0x30, 0xEA, 0x81, 0x80, 0x3E, 0x83,
  0x70, 0x5F, 0xE3, 0x83, 0x7F, 0xBF, 0x82, 0x84, 0x5B, 0xEE, 0xC5, 0x28, 0x1D, 0xF6, 0x28, 0x41,
  0xEA, 0x9F, 0x87, 0x28, 0x15, 0xFE, 0x38, 0x48, 0xF3, 0x9F, 0x87, 0x28, 0x1D, 0xF6, 0x28, 0x51,
  0xEB, 0x09, 0xF8, 0x71, 0x81, 0x5F, 0xD3, 0x85, 0x8F, 0x30, 0x9F, 0x87, 0x18, 0x1D, 0xF6, 0x28,
  0x11, 0xEB, 0x28, 0x19, 0xF8, 0x78, 0x15, 0xFD, 0x30, 0x6F, 0x96, 0x81, 0xDF, 0x63, 0x87, 0x5D,
  0xDD, 0xDE, 0xFE, 0xD5, 0x81, 0x6F, 0xD7, 0x28, 0x19, 0xF8, 0x68, 0x1D, 0xF6, 0x72, 0x81, 0x9F,
  0x81,
  // "¿" (U+00BF)
  0x48, 0x27, 0xEC, 0x16, 0xB0, 0x66, 0xB0, 0x66, 0x82, 0x7E, 0xC1, 0x77, 0x75, 0x81, 0x39, 0x87,
  0x81, 0x6F, 0xD7, 0x81, 0xAF, 0xC6, 0x02, 0xA0, 0x85, 0x01, 0x0D, 0xA0, 0x25, 0x0C, 0xA0, 0x65,
  0x09, 0xA0, 0x85, 0x02, 0xA0, 0xC6, 0x07, 0xA0, 0x46, 0x09, 0xA0, 0x16, 0x0A, 0xA0, 0x16, 0x08,
  0xA0, 0x54, 0x81, 0x50, 0x3B, 0x86, 0x97, 0x9E, 0xF3, 0x09, 0xF0, 0x72, 0x85, 0x5C, 0xEF, 0xD9,
  0x31,
  // "À" (U+00C0)
  0x38, 0x26, 0x77, 0x37, 0x40, 0x5A, 0x0D, 0x75, 0x07, 0xA0, 0x77, 0x58, 0x28, 0xFE, 0x27, 0x58,
  0x17, 0xFB, 0x80, 0xC5, 0x00, 0x7B, 0x02, 0x73, 0x0B, 0xB0, 0x67, 0x3C, 0x0A, 0x72, 0x04, 0xA8,
  0x1A, 0xFE, 0x72, 0x08, 0xA0, 0x5A, 0x03, 0x71, 0x82, 0xCF, 0xC1, 0xA0, 0x87, 0x01, 0xA8, 0x38,
  0x0D, 0xFC, 0x70, 0x5A, 0x81, 0x50, 0x9A, 0x01, 0x60, 0x9A, 0x81, 0x10, 0x5A, 0x05, 0x68, 0x1D,
  0xFD, 0x20, 0x2A, 0x09, 0x50, 0x2A, 0x09, 0x38, 0x1D, 0xFD, 0x50, 0x6A, 0x05, 0x30, 0xAA, 0x02,
  0x40, 0xBA, 0x83, 0xBA, 0xAA, 0xCA, 0x06, 0x40, 0xEF, 0xA0, 0xA3, 0x03, 0xFB, 0x0E, 0x30, 0x8A,
  0x07, 0x50, 0xBA, 0x03, 0x20, 0xCA, 0x03, 0x50, 0x7A, 0x81, 0x80, 0x1A, 0x0E, 0x60, 0x3A, 0x81,
  0xC0, 0x5A, 0x0A, 0x70, 0xEA, 0x01, 0x09, 0xA0, 0x67, 0x0A, 0xA0, 0x50, 0xDA, 0x02, 0x70, 0x6A,
  0x09,
  // "Á" (U+00C1)
  0x71, 0x82, 0x37, 0x76, 0x74, 0x0D, 0xA0, 0x67, 0x30, 0x7A, 0x07, 0x73, 0x82, 0x2E, 0xF8, 0x74,
  0x81, 0xBF, 0x88, 0x0C, 0x50, 0x07, 0xB0, 0x27, 0x30, 0xBB, 0x06, 0x73, 0xC0, 0xA7, 0x20, 0x4A,
  0x81, 0xAF, 0xE7, 0x20, 0x8A, 0x05, 0xA0, 0x37, 0x18, 0x2C, 0xFC, 0x1A, 0x08, 0x70, 0x1A, 0x83,
  0x80, 0xDF, 0xC7, 0x05, 0xA8, 0x15, 0x09, 0xA0, 0x16, 0x09, 0xA8, 0x11, 0x05, 0xA0, 0x56, 0x81,
  0xDF, 0xD2, 0x02, 0xA0, 0x95, 0x02, 0xA0, 0x93, 0x81, 0xDF, 0xD5, 0x06, 0xA0, 0x53, 0x0A, 0xA0,
  0x24, 0x0B, 0xA8, 0x3B, 0xAA, 0xAC, 0xA0, 0x64, 0x0E, 0xFA, 0x0A, 0x30, 0x3F, 0xB0, 0xE3, 0x08,
  0xA0, 0x75, 0x0B, 0xA0, 0x32, 0x0C, 0xA0, 0x35, 0x07, 0xA8, 0x18, 0x01, 0xA0, 0xE6, 0x03, 0xA8,
  0x1C, 0x05, 0xA0, 0xA7, 0x0E, 0xA0, 0x10, 0x9A, 0x06, 0x70, 0xAA, 0x05, 0x0D, 0xA0, 0x27, 0x06,
  0xA0, 0x90,
  // "Â" (U+00C2)
  0x58, 0x21, 0x77, 0x67, 0x40, 0x9B, 0x04, 0x72, 0x04, 0xA8, 0x1C, 0xFD, 0x71, 0x86, 0x1D, 0xF5,
  0x0B, 0xFA, 0x78, 0x1A, 0xF5, 0x38, 0x1A, 0xF6, 0x80, 0xC2, 0x00, 0x7B, 0x02, 0x73, 0x0B, 0xB0,
  0x67, 0x3C, 0x0A, 0x72, 0x04, 0xA8, 0x1A, 0xFE, 0x72, 0x08, 0xA0, 0x5A, 0x03, 0x71, 0x82, 0xCF,
  0xC1, 0xA0, 0x87, 0x01, 0xA8, 0x38, 0x0D, 0xFC, 0x70, 0x5A, 0x81, 0x50, 0x9A, 0x01, 0x60, 0x9A,
  0x81, 0x10, 0x5A, 0x05, 0x68, 0x1D, 0xFD, 0x20, 0x2A, 0x09, 0x50, 0x2A, 0x09, 0x38, 0x1D, 0xFD,
  0x50, 0x6A, 0x05, 0x30, 0xAA, 0x02, 0x40, 0xBA, 0x83, 0xBA, 0xAA, 0xCA, 0x06, 0x40, 0xEF, 0xA0,
  0xA3, 0x03, 0xFB, 0x0E, 0x30, 0x8A, 0x07, 0x50, 0xBA, 0x03, 0x20, 0xCA, 0x03, 0x50, 0x7A, 0x81,
  0x80, 0x1A, 0x0E, 0x60, 0x3A, 0x81, 0xC0, 0x5A, 0x0A, 0x70, 0xEA, 0x01, 0x09, 0xA0, 0x67, 0x0A,
  0xA0, 0x50, 0xDA, 0x02, 0x70, 0x6A, 0x09,
  // "Ã" (U+00C3)
  0x48, 0x27, 0xED, 0x62, 0x81, 0x7F, 0x35, 0x04, 0xC8, 0x1C, 0x7E, 0x96, 0x82, 0x9F, 0x99, 0xC0,
  0xA6, 0x0C, 0x0D, 0x28, 0x32, 0xBE, 0xC1, 0x80, 0xC2, 0x00, 0x7B, 0x02, 0x73, 0x0B, 0xB0, 0x67,
  0x3C, 0x0A, 0x72, 0x04, 0xA8, 0x1A, 0xFE, 0x72, 0x08, 0xA0, 0x5A, 0x03, 0x71, 0x82, 0xCF, 0xC1,
  0xA0, 0x87, 0x01, 0xA8, 0x38, 0x0D, 0xFC, 0x70, 0x5A, 0x81, 0x50, 0x9A, 0x01, 0x60, 0x9A, 0x81,
  0x10, 0x5A, 0x05, 0x68, 0x1D, 0xFD, 0x20, 0x2A, 0x09, 0x50, 0x2A, 0x09, 0x38, 0x1D, 0xFD, 0x50,
  0x6A, 0x05, 0x30, 0xAA, 0x02, 0x40, 0xBA, 0x83, 0xBA, 0xAA, 0xCA, 0x06, 0x40, 0xEF, 0xA0, 0xA3,
  0x03, 0xFB, 0x0E, 0x30, 0x8A, 0x07, 0x50, 0xBA, 0x03, 0x20, 0xCA, 0x03, 0x50, 0x7A, 0x81, 0x80,
  0x1A, 0x0E, 0x60, 0x3A, 0x81, 0xC0, 0x5A, 0x0A, 0x70, 0xEA, 0x01, 0x09, 0xA0, 0x67, 0x0A, 0xA0,
  0x50, 0xDA, 0x02, 0x70, 0x6A, 0x09,
  // "Ä" (U+00C4)
  0x38, 0x71, 0xDD, 0x10, 0x2D, 0xD1, 0x60, 0x5A, 0x81, 0x50, 0x6A, 0x04, 0x68, 0x71, 0xDD, 0x10,
  0x2D, 0xD1, 0x80, 0xC2, 0x00, 0x7B, 0x02, 0x73, 0x0B, 0xB0, 0x67, 0x3C, 0x0A, 0x72, 0x04, 0xA8,
  0x1A, 0xFE, 0x72, 0x08, 0xA0, 0x5A, 0x03, 0x71, 0x82, 0xCF, 0xC1, 0xA0, 0x87, 0x01, 0xA8, 0x38,
  0x0D, 0xFC, 0x70, 0x5A, 0x81, 0x50, 0x9A, 0x01, 0x60, 0x9A, 0x81, 0x10, 0x5A, 0x05, 0x68, 0x1D,
  0xFD, 0x20, 0x2A, 0x09, 0x50, 0x2A, 0x09, 0x38, 0x1D, 0xFD, 0x50, 0x6A, 0x05, 0x30, 0xAA, 0x02,
  0x40, 0xBA, 0x83, 0xBA, 0xAA, 0xCA, 0x06, 0x40, 0xEF, 0xA0, 0xA3, 0x03, 0xFB, 0x0E, 0x30, 0x8A,
  0x07, 0x50, 0xBA, 0x03, 0x20, 0xCA, 0x03, 0x50, 0x7A, 0x81, 0x80, 0x1A, 0x0E, 0x60, 0x3A, 0x81,
  0xC0, 0x5A, 0x0A, 0x70, 0xEA, 0x01, 0x09, 0xA0, 0x67, 0x0A, 0xA0, 0x50, 0xDA, 0x02, 0x70, 0x6A,
  0x09,
  // "Å" (U+00C5)
  0x58, 0x37, 0xDE, 0xA2, 0x72, 0x84, 0x7F, 0xED, 0xFD, 0x72, 0x85, 0xCD, 0x10, 0x8F, 0x37, 0x10,
  0xC0, 0xD2, 0x81, 0x8F, 0x27, 0x18, 0x47, 0xFE, 0xDF, 0xD7, 0x3C, 0x04, 0x73, 0x0B, 0xB0, 0x67,
  0x3C, 0x0A, 0x72, 0x04, 0xA8, 0x1A, 0xFE, 0x72, 0x08, 0xA0, 0x5A, 0x03, 0x71, 0x82, 0xCF, 0xC1,
  0xA0, 0x87, 0x01, 0xA8, 0x38, 0x0D, 0xFC, 0x70, 0x5A, 0x81, 0x50, 0x9A, 0x01, 0x60, 0x9A, 0x81,
  0x10, 0x5A, 0x05, 0x68, 0x1D, 0xFD, 0x20, 0x2A, 0x09, 0x50, 0x2A, 0x09, 0x38, 0x1D, 0xFD, 0x50,
  0x6A, 0x05, 0x30, 0xAA, 0x02, 0x40, 0xBA, 0x83, 0xBA, 0xAA, 0xCA, 0x06, 0x40, 0xEF, 0xA0, 0xA3,
  0x03, 0xFB, 0x0E, 0x30, 0x8A, 0x07, 0x50, 0xBA, 0x03, 0x20, 0xCA, 0x03, 0x50, 0x7A, 0x81, 0x80,
  0x1A, 0x0E, 0x60, 0x3A, 0x81, 0xC0, 0x5A, 0x0A, 0x70, 0xEA, 0x01, 0x09, 0xA0, 0x67, 0x0A, 0xA0,
  0x50, 0xDA, 0x02, 0x70, 0x6A, 0x09,
  // "Æ" (U+00C6)
  0x60, 0x3F, 0xC0, 0xA6, 0x08, 0xFC, 0x0A, 0x68, 0x2D, 0xFD, 0x9A, 0x0B, 0x80, 0x16, 0x04, 0x50,
  0x3A, 0x08, 0x04, 0xA0, 0x87, 0x40, 0x8A, 0x03, 0x04, 0xA0, 0x87, 0x48, 0x3D, 0xFE, 0x04, 0xA0,
  0x87, 0x30, 0x3A, 0x81, 0x90, 0x4A, 0x08, 0x73, 0x08, 0xA8, 0x14, 0x04, 0xA0, 0x87, 0x30, 0xDA,
  0x20, 0x4A, 0x08, 0x72, 0x03, 0xA0, 0xB2, 0x04, 0xF9, 0x04, 0x30, 0x8A, 0x06, 0x20, 0x4F, 0x90,
  0x43, 0x0D, 0xA0, 0x12, 0x04, 0xA0, 0xB8, 0x01, 0x60, 0x12, 0x03, 0xA8, 0x3E, 0x66, 0x69, 0xA0,
  0x87, 0x10, 0x8F, 0xA0, 0x87, 0x10, 0xDF, 0xA0, 0x87, 0x03, 0xA0, 0xC4, 0x04, 0xA0, 0x87, 0x08,
  0xA0, 0x74, 0x04, 0xA0, 0x87, 0x0D, 0xA0, 0x24, 0x04, 0xA0, 0x86, 0x03, 0xA0, 0xC5, 0x04, 0xA0,
  0xB8, 0x01, 0x60, 0x40, 0x8A, 0x07, 0x50, 0x4F, 0x90, 0xA0, 0xDA, 0x02, 0x50, 0x4F, 0x90, 0xA0,
  // "Ç" (U+00C7)
  0x48, 0x61, 0x8C, 0xEF, 0xDA, 0x54, 0x04, 0x0E, 0xF0, 0x52, 0x03, 0x0E, 0xA8, 0x4C, 0x87, 0xAF,
  0xE3, 0x0D, 0xA0, 0x94, 0x01, 0x06, 0x20, 0x5A, 0x0C, 0x72, 0x0C, 0xA0, 0x47, 0x2A, 0x0E, 0x72,
  0x04, 0xA0, 0xB7, 0x20, 0x6A, 0x08, 0x72, 0x07, 0xA0, 0x77, 0x20, 0x8A, 0x06, 0x72, 0x07, 0xA0,
  0x77, 0x20, 0x6A, 0x08, 0x72, 0x04, 0xA0, 0xA7, 0x20, 0x2A, 0x0D, 0x73, 0x0D, 0xA0, 0x37, 0x20,
  0x8A, 0x0B, 0x72, 0x01, 0x0E, 0xA0, 0x85, 0x01, 0x30, 0x5B, 0x84, 0xD8, 0x79, 0xCE, 0x40, 0x6F,
  0x0E, 0x58, 0x62, 0x8D, 0xEE, 0xDA, 0x57, 0x81, 0x4F, 0x57, 0x38, 0x1B, 0xF6, 0x73, 0x82, 0x7D,
  0xFC, 0x74, 0xA0, 0x47, 0x20, 0x2A, 0x03, 0x70, 0x0D, 0xA0, 0xD7, 0x18, 0x3D, 0xFE, 0xA2, 0x30,
  // "È" (U+00C8)
  0x18, 0x26, 0x77, 0x36, 0x05, 0xA0, 0xD7, 0x07, 0xA0, 0x77, 0x82, 0x8F, 0xE2, 0x78, 0x17, 0xFB,
  0x77, 0x72, 0x0C, 0xF9, 0x05, 0x0C, 0xF9, 0x05, 0x0C, 0xA0, 0x78, 0x01, 0x60, 0x20, 0xCA, 0x70,
  0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCF, 0x81, 0xE0, 0xCF, 0x81, 0xE0,
  0xCA, 0x07, 0x80, 0x16, 0x10, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA,
  0x70, 0xCA, 0x07, 0x80, 0x16, 0x02, 0x0C, 0xF9, 0x05, 0x0C, 0xF9, 0x05,
  // "É" (U+00C9)
  0x58, 0x23, 0x77, 0x66, 0x0D, 0xA0, 0x65, 0x07, 0xA0, 0x75, 0x82, 0x2E, 0xF8, 0x68, 0x1B, 0xF8,
  0x77, 0x73, 0x0C, 0xF9, 0x05, 0x0C, 0xF9, 0x05, 0x0C, 0xA0, 0x78, 0x01, 0x60, 0x20, 0xCA, 0x70,
  0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCF, 0x81, 0xE0, 0xCF, 0x81, 0xE0,
  0xCA, 0x07, 0x80, 0x16, 0x10, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA,
  0x70, 0xCA, 0x07, 0x80, 0x16, 0x02, 0x0C, 0xF9, 0x05, 0x0C, 0xF9, 0x05,
  // "Ê" (U+00CA)
  0x28, 0x21, 0x77, 0x66, 0x09, 0xB0, 0x44, 0x04, 0xA8, 0x1C, 0xFD, 0x38, 0x61, 0xDF, 0x50, 0xBF,
  0xA2, 0x81, 0xAF, 0x53, 0x81, 0xAF, 0x67, 0x77, 0x0C, 0xF9, 0x05, 0x0C, 0xF9, 0x05, 0x0C, 0xA0,
  0x78, 0x01, 0x60, 0x20, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70,
  0xCF, 0x81, 0xE0, 0xCF, 0x81, 0xE0, 0xCA, 0x07, 0x80, 0x16, 0x10, 0xCA, 0x70, 0xCA, 0x70, 0xCA,
  0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x07, 0x80, 0x16, 0x02, 0x0C, 0xF9, 0x05, 0x0C,
  0xF9, 0x05,
  // "Ë" (U+00CB)
  0x89, 0x11, 0xDD, 0x10, 0x2D, 0xD1, 0x05, 0xA8, 0x15, 0x06, 0xA8, 0x91, 0x40, 0x1D, 0xD1, 0x02,
  0xDD, 0x17, 0x77, 0x0C, 0xF9, 0x05, 0x0C, 0xF9, 0x05, 0x0C, 0xA0, 0x78, 0x01, 0x60, 0x20, 0xCA,
  0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCF, 0x81, 0xE0, 0xCF, 0x81,
  0xE0, 0xCA, 0x07, 0x80, 0x16, 0x10, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70,
  0xCA, 0x70, 0xCA, 0x07, 0x80, 0x16, 0x02, 0x0C, 0xF9, 0x05, 0x0C, 0xF9, 0x05,
  // "Ì" (U+00CC)
  0x82, 0x67, 0x73, 0x40, 0x5A, 0x0D, 0x50, 0x7A, 0x07, 0x58, 0x28, 0xFE, 0x25, 0x81, 0x7F, 0xB7,
  0x75, 0xE0, 0xC1, 0xE8, 0x2C, 0x01, 0x7A, 0x0E, 0x05, 0x30, 0x1A, 0x0C, 0x40, 0x1A, 0x0C, 0x40,
  0x1A, 0x0C, 0x40, 0x1A, 0x0C, 0x40, 0x1A, 0x0C, 0x40, 0x1A, 0x0C, 0x40, 0x1A, 0x0C, 0x40, 0x1A,
  0x0C, 0x40, 0x1A, 0x0C, 0x40, 0x1A, 0x0C, 0x40, 0x1A, 0x0C, 0x40, 0x1A, 0x0C, 0x40, 0x1A, 0x0C,
  0x40, 0x1A, 0x0C, 0x40, 0x1A, 0x0C, 0x40, 0x3A, 0x0D, 0x01, 0x20, 0xDD, 0x0A, 0x1E, 0x0C,
  // "Í" (U+00CD)
  0x48, 0x23, 0x77, 0x64, 0x0D, 0xA0, 0x63, 0x07, 0xA0, 0x73, 0x82, 0x2E, 0xF8, 0x48, 0x1B, 0xF8,
  0x77, 0x5E, 0x0C, 0x1E, 0x82, 0xC0, 0x17, 0xA0, 0xE0, 0x53, 0x01, 0xA0, 0xC4, 0x01, 0xA0, 0xC4,
  0x01, 0xA0, 0xC4, 0x01, 0xA0, 0xC4, 0x01, 0xA0, 0xC4, 0x01, 0xA0, 0xC4, 0x01, 0xA0, 0xC4, 0x01,
  0xA0, 0xC4, 0x01, 0xA0, 0xC4, 0x01, 0xA0, 0xC4, 0x01, 0xA0, 0xC4, 0x01, 0xA0, 0xC4, 0x01, 0xA0,
  0xC4, 0x01, 0xA0, 0xC4, 0x01, 0xA0, 0xC4, 0x03, 0xA0, 0xD0, 0x12, 0x0D, 0xD0, 0xA1, 0xE0, 0xC1,
  // "Î" (U+00CE)
  0x28, 0x21, 0x77, 0x65, 0x09, 0xB0, 0x43, 0x04, 0xA8, 0x1C, 0xFD, 0x28, 0x92, 0x1D, 0xF5, 0x0B,
  0xFA, 0x0A, 0xF5, 0x38, 0x1A, 0xF6, 0x77, 0x5E, 0x0C, 0x2E, 0x0C, 0x20, 0x10, 0x7A, 0x0E, 0x05,
  0x40, 0x1A, 0x0C, 0x50, 0x1A, 0x0C, 0x50, 0x1A, 0x0C, 0x50, 0x1A, 0x0C, 0x50, 0x1A, 0x0C, 0x50,
  0x1A, 0x0C, 0x50, 0x1A, 0x0C, 0x50, 0x1A, 0x0C, 0x50, 0x1A, 0x0C, 0x50, 0x1A, 0x0C, 0x50, 0x1A,
  0x0C, 0x50, 0x1A, 0x0C, 0x50, 0x1A, 0x0C, 0x50, 0x1A, 0x0C, 0x50, 0x1A, 0x0C, 0x50, 0x3A, 0x0D,
  0x01, 0x30, 0xDD, 0x0A, 0x2E, 0x0C, 0x10,
  // "Ï" (U+00CF)
  0x89, 0x01, 0xDD, 0x10, 0x2D, 0xD1, 0x5A, 0x81, 0x50, 0x6A, 0x89, 0x04, 0x1D, 0xD1, 0x02, 0xDD,
  0x17, 0x75, 0xE0, 0xC2, 0xE0, 0xC2, 0x01, 0x07, 0xA0, 0xE0, 0x54, 0x01, 0xA0, 0xC5, 0x01, 0xA0,
  0xC5, 0x01, 0xA0, 0xC5, 0x01, 0xA0, 0xC5, 0x01, 0xA0, 0xC5, 0x01, 0xA0, 0xC5, 0x01, 0xA0, 0xC5,
  0x01, 0xA0, 0xC5, 0x01, 0xA0, 0xC5, 0x01, 0xA0, 0xC5, 0x01, 0xA0, 0xC5, 0x01, 0xA0, 0xC5, 0x01,
  0xA0, 0xC5, 0x01, 0xA0, 0xC5, 0x01, 0xA0, 0xC5, 0x03, 0xA0, 0xD0, 0x13, 0x0D, 0xD0, 0xA2, 0xE0,
  0xC1,
  // "Ð" (U+00D0)
  0x20, 0xCC, 0x82, 0xED, 0xA4, 0x60, 0xCF, 0x90, 0xB5, 0x0C, 0xA8, 0x27, 0x67, 0xAB, 0x0C, 0x40,
  0xCA, 0x01, 0x30, 0x20, 0xDA, 0x08, 0x30, 0xCA, 0x01, 0x40, 0x2B, 0x01, 0x20, 0xCA, 0x01, 0x50,
  0xAA, 0x06, 0x20, 0xCA, 0x01, 0x50, 0x5A, 0x0A, 0x20, 0xCA, 0x01, 0x50, 0x2A, 0x0D, 0x20, 0xCA,
  0x01, 0x6A, 0x0E, 0x06, 0xF0, 0x33, 0x0E, 0xA0, 0x6F, 0x03, 0x30, 0xEA, 0x81, 0x36, 0xDA, 0x82,
  0x76, 0x61, 0x30, 0xEA, 0x20, 0xCA, 0x01, 0x6A, 0x0E, 0x20, 0xCA, 0x01, 0x50, 0x2A, 0x0C, 0x20,
  0xCA, 0x01, 0x50, 0x6A, 0x09, 0x20, 0xCA, 0x01, 0x50, 0xBA, 0x04, 0x20, 0xCA, 0x01, 0x40, 0x4A,
  0x0E, 0x30, 0xCA, 0x01, 0x30, 0x30, 0xEA, 0x06, 0x30, 0xCA, 0x82, 0x76, 0x7B, 0xB0, 0xA4, 0x0C,
  0xF9, 0x09, 0x50, 0xCC, 0x82, 0xED, 0x93, 0x40,
  // "Ñ" (U+00D1)
  0x38, 0x27, 0xED, 0x62, 0x81, 0x7F, 0x34, 0x04, 0xC8, 0x1C, 0x7E, 0x95, 0x82, 0x9F, 0x99, 0xC0,
  0xA5, 0x0C, 0x0D, 0x28, 0x32, 0xBE, 0xC1, 0x77, 0x77, 0x30, 0xCA, 0x0C, 0x78, 0x2D, 0xFC, 0xCB,
  0x04, 0x68, 0x2D, 0xFC, 0xCB, 0x0B, 0x68, 0x2D, 0xFC, 0xCC, 0x03, 0x58, 0x4D, 0xFC, 0xCF, 0xEA,
  0x0A, 0x58, 0x5D, 0xFC, 0xCF, 0xAC, 0xA0, 0x24, 0x85, 0xDF, 0xCC, 0xFB, 0x5A, 0x09, 0x48, 0x6D,
  0xFC, 0xCF, 0xC0, 0xDA, 0x01, 0x38, 0x6D, 0xFC, 0xCF, 0xC0, 0x6A, 0x08, 0x38, 0x4D, 0xFC, 0xCF,
  0xD2, 0x81, 0xEF, 0xE3, 0x84, 0xDF, 0xCC, 0xFD, 0x20, 0x7A, 0x06, 0x28, 0x4D, 0xFC, 0xCF, 0xD2,
  0x82, 0x1E, 0xFD, 0x28, 0x4D, 0xFC, 0xCF, 0xD3, 0x09, 0xA8, 0x65, 0x0D, 0xFC, 0xCF, 0xD3, 0x02,
  0xA8, 0x6C, 0x0C, 0xFC, 0xCF, 0xD4, 0x0A, 0xA8, 0x54, 0xCF, 0xCC, 0xFD, 0x40, 0x2A, 0x85, 0xBB,
  0xFC, 0xCF, 0xD5, 0x0B, 0xA8, 0x4E, 0xFC, 0xCF, 0xD5, 0x03, 0xC8, 0x2C, 0xCF, 0xD6, 0x0C, 0xB8,
  0x2C, 0xCF, 0xD6, 0x05, 0xB8, 0x2C, 0xCF, 0xD7, 0x0D, 0xA0, 0xC0,
  // "Ò" (U+00D2)
  0x38, 0x26, 0x77, 0x37, 0x50, 0x5A, 0x0D, 0x76, 0x07, 0xA0, 0x77, 0x68, 0x28, 0xFE, 0x27, 0x68,
  0x17, 0xFB, 0x80, 0xC7, 0x08, 0x63, 0x9D, 0xEE, 0xC7, 0x17, 0x08, 0xF0, 0xE0, 0x35, 0x08, 0xB8,
  0x2A, 0x78, 0xCA, 0x0E, 0x01, 0x30, 0x2B, 0x04, 0x40, 0x9A, 0x0A, 0x30, 0x9A, 0x08, 0x60, 0xDA,
  0x02, 0x20, 0xEA, 0x01, 0x60, 0x7A, 0x81, 0x70, 0x2A, 0x0C, 0x70, 0x3A, 0x81, 0xB0, 0x5A, 0x09,
  0x71, 0xA8, 0x1E, 0x07, 0xA0, 0x77, 0x10, 0xEA, 0x10, 0x7A, 0x07, 0x71, 0x0D, 0xA0, 0x10, 0x8A,
  0x06, 0x71, 0x0C, 0xA0, 0x20, 0x7A, 0x07, 0x71, 0x0D, 0xA0, 0x10, 0x6A, 0x07, 0x71, 0x0E, 0xA1,
  0x04, 0xA0, 0x97, 0x1A, 0x81, 0xE0, 0x1A, 0x0C, 0x70, 0x3A, 0x0B, 0x20, 0xDA, 0x01, 0x60, 0x7A,
  0x07, 0x20, 0x7A, 0x08, 0x60, 0xDA, 0x02, 0x20, 0x10, 0xEA, 0x04, 0x40, 0x9A, 0x0A, 0x40, 0x5B,
  0x82, 0xA7, 0x8D, 0xA0, 0xE0, 0x25, 0x07, 0xF0, 0xE0, 0x37, 0x86, 0x39, 0xDF, 0xEC, 0x71, 0x40,
  // "Ó" (U+00D3)
  0x71, 0x82, 0x37, 0x76, 0x75, 0x0D, 0xA0, 0x67, 0x40, 0x7A, 0x07, 0x74, 0x82, 0x2E, 0xF8, 0x75,
  0x81, 0xBF, 0x88, 0x0C, 0x70, 0x86, 0x39, 0xDE, 0xEC, 0x71, 0x70, 0x8F, 0x0E, 0x03, 0x50, 0x8B,
  0x82, 0xA7, 0x8C, 0xA0, 0xE0, 0x13, 0x02, 0xB0, 0x44, 0x09, 0xA0, 0xA3, 0x09, 0xA0, 0x86, 0x0D,
  0xA0, 0x22, 0x0E, 0xA0, 0x16, 0x07, 0xA8, 0x17, 0x02, 0xA0, 0xC7, 0x03, 0xA8, 0x1B, 0x05, 0xA0,
  0x97, 0x1A, 0x81, 0xE0, 0x7A, 0x07, 0x71, 0x0E, 0xA1, 0x07, 0xA0, 0x77, 0x10, 0xDA, 0x01, 0x08,
  0xA0, 0x67, 0x10, 0xCA, 0x02, 0x07, 0xA0, 0x77, 0x10, 0xDA, 0x01, 0x06, 0xA0, 0x77, 0x10, 0xEA,
  0x10, 0x4A, 0x09, 0x71, 0xA8, 0x1E, 0x01, 0xA0, 0xC7, 0x03, 0xA0, 0xB2, 0x0D, 0xA0, 0x16, 0x07,
  0xA0, 0x72, 0x07, 0xA0, 0x86, 0x0D, 0xA0, 0x22, 0x01, 0x0E, 0xA0, 0x44, 0x09, 0xA0, 0xA4, 0x05,
  0xB8, 0x2A, 0x78, 0xDA, 0x0E, 0x02, 0x50, 0x7F, 0x0E, 0x03, 0x78, 0x63, 0x9D, 0xFE, 0xC7, 0x14,
  // "Ô" (U+00D4)
  0x68, 0x21, 0x77, 0x67, 0x50, 0x9B, 0x04, 0x73, 0x04, 0xA8, 0x1C, 0xFD, 0x72, 0x86, 0x1D, 0xF5,
  0x0B, 0xFA, 0x71, 0x81, 0xAF, 0x53, 0x81, 0xAF, 0x68, 0x0C, 0x30, 0x86, 0x39, 0xDE, 0xEC, 0x71,
  0x70, 0x8F, 0x0E, 0x03, 0x50, 0x8B, 0x82, 0xA7, 0x8C, 0xA0, 0xE0, 0x13, 0x02, 0xB0, 0x44, 0x09,
  0xA0, 0xA3, 0x09, 0xA0, 0x86, 0x0D, 0xA0, 0x22, 0x0E, 0xA0, 0x16, 0x07, 0xA8, 0x17, 0x02, 0xA0,
  0xC7, 0x03, 0xA8, 0x1B, 0x05, 0xA0, 0x97, 0x1A, 0x81, 0xE0, 0x7A, 0x07, 0x71, 0x0E, 0xA1, 0x07,
  0xA0, 0x77, 0x10, 0xDA, 0x01, 0x08, 0xA0, 0x67, 0x10, 0xCA, 0x02, 0x07, 0xA0, 0x77, 0x10, 0xDA,
  0x01, 0x06, 0xA0, 0x77, 0x10, 0xEA, 0x10, 0x4A, 0x09, 0x71, 0xA8, 0x1E, 0x01, 0xA0, 0xC7, 0x03,
  0xA0, 0xB2, 0x0D, 0xA0, 0x16, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x86, 0x0D, 0xA0, 0x22, 0x01, 0x0E,
  0xA0, 0x44, 0x09, 0xA0, 0xA4, 0x05, 0xB8, 0x2A, 0x78, 0xDA, 0x0E, 0x02, 0x50, 0x7F, 0x0E, 0x03,
  0x78, 0x63, 0x9D, 0xFE, 0xC7, 0x14,
  // "Õ" (U+00D5)
  0x48, 0x27, 0xED, 0x62, 0x81, 0x7F, 0x36, 0x04, 0xC8, 0x1C, 0x7E, 0x97, 0x82, 0x9F, 0x99, 0xC0,
  0xA7, 0x0C, 0x0D, 0x28, 0x32, 0xBE, 0xC1, 0x80, 0xC4, 0x08, 0x63, 0x9D, 0xEE, 0xC7, 0x17, 0x08,
  0xF0, 0xE0, 0x35, 0x08, 0xB8, 0x2A, 0x78, 0xCA, 0x0E, 0x01, 0x30, 0x2B, 0x04, 0x40, 0x9A, 0x0A,
  0x30, 0x9A, 0x08, 0x60, 0xDA, 0x02, 0x20, 0xEA, 0x01, 0x60, 0x7A, 0x81, 0x70, 0x2A, 0x0C, 0x70,
  0x3A, 0x81, 0xB0, 0x5A, 0x09, 0x71, 0xA8, 0x1E, 0x07, 0xA0, 0x77, 0x10, 0xEA, 0x10, 0x7A, 0x07,
  0x71, 0x0D, 0xA0, 0x10, 0x8A, 0x06, 0x71, 0x0C, 0xA0, 0x20, 0x7A, 0x07, 0x71, 0x0D, 0xA0, 0x10,
  0x6A, 0x07, 0x71, 0x0E, 0xA1, 0x04, 0xA0, 0x97, 0x1A, 0x81, 0xE0, 0x1A, 0x0C, 0x70, 0x3A, 0x0B,
  0x20, 0xDA, 0x01, 0x60, 0x7A, 0x07, 0x20, 0x7A, 0x08, 0x60, 0xDA, 0x02, 0x20, 0x10, 0xEA, 0x04,
  0x40, 0x9A, 0x0A, 0x40, 0x5B, 0x82, 0xA7, 0x8D, 0xA0, 0xE0, 0x25, 0x07, 0xF0, 0xE0, 0x37, 0x86,
  0x39, 0xDF, 0xEC, 0x71, 0x40,
  // "Ö" (U+00D6)
  0x38, 0x71, 0xDD, 0x10, 0x2D, 0xD1, 0x70, 0x5A, 0x81, 0x50, 0x6A, 0x04, 0x78, 0x71, 0xDD, 0x10,
  0x2D, 0xD1, 0x80, 0xC4, 0x08, 0x63, 0x9D, 0xEE, 0xC7, 0x17, 0x08, 0xF0, 0xE0, 0x35, 0x08, 0xB8,
  0x2A, 0x78, 0xCA, 0x0E, 0x01, 0x30, 0x2B, 0x04, 0x40, 0x9A, 0x0A, 0x30, 0x9A, 0x08, 0x60, 0xDA,
  0x02, 0x20, 0xEA, 0x01, 0x60, 0x7A, 0x81, 0x70, 0x2A, 0x0C, 0x70, 0x3A, 0x81, 0xB0, 0x5A, 0x09,
  0x71, 0xA8, 0x1E, 0x07, 0xA0, 0x77, 0x10, 0xEA, 0x10, 0x7A, 0x07, 0x71, 0x0D, 0xA0, 0x10, 0x8A,
  0x06, 0x71, 0x0C, 0xA0, 0x20, 0x7A, 0x07, 0x71, 0x0D, 0xA0, 0x10, 0x6A, 0x07, 0x71, 0x0E, 0xA1,
  0x04, 0xA0, 0x97, 0x1A, 0x81, 0xE0, 0x1A, 0x0C, 0x70, 0x3A, 0x0B, 0x20, 0xDA, 0x01, 0x60, 0x7A,
  0x07, 0x20, 0x7A, 0x08, 0x60, 0xDA, 0x02, 0x20, 0x10, 0xEA, 0x04, 0x40, 0x9A, 0x0A, 0x40, 0x5B,
  0x82, 0xA7, 0x8D, 0xA0, 0xE0, 0x25, 0x07, 0xF0, 0xE0, 0x37, 0x86, 0x39, 0xDF, 0xEC, 0x71, 0x40,
  // "×" (U+00D7)
  0x10, 0x27, 0x03, 0x28, 0x13, 0xE9, 0x58, 0x34, 0xEA, 0x07, 0xA0, 0x93, 0x85, 0x4E, 0xFC, 0x10,
  0x7A, 0x85, 0xA0, 0x4E, 0xFC, 0x13, 0x07, 0xA8, 0x3B, 0xEF, 0xC1, 0x50, 0x7B, 0x0C, 0x01, 0x60,
  0x4B, 0x0A, 0x68, 0x24, 0xEF, 0xDA, 0x09, 0x48, 0x44, 0xEF, 0xC1, 0x7A, 0x09, 0x28, 0x34, 0xEF,
  0xC1, 0x20, 0x7A, 0x84, 0x90, 0x6F, 0xC1, 0x48, 0x17, 0xFC, 0x20, 0x50, 0x16, 0x05, 0x01, 0x10,
  // "Ø" (U+00D8)
  0x75, 0x03, 0x07, 0x68, 0x91, 0x39, 0xDE, 0xEC, 0x70, 0xBF, 0x64, 0x08, 0xF8, 0x1E, 0xFD, 0x40,
  0x7B, 0x82, 0xA7, 0x8D, 0xB0, 0x63, 0x02, 0xB0, 0x44, 0x0C, 0xA0, 0x93, 0x09, 0xA0, 0x85, 0x0C,
  0xB0, 0x22, 0x0E, 0xA0, 0x14, 0x05, 0xC8, 0x17, 0x02, 0xA0, 0xC5, 0x81, 0xDF, 0x7A, 0x81, 0xB0,
  0x5A, 0x09, 0x48, 0x17, 0xFA, 0x1A, 0x81, 0xE0, 0x7A, 0x07, 0x38, 0x41, 0xEF, 0x20, 0xDA, 0x01,
  0x07, 0xA0, 0x63, 0x81, 0x8F, 0x82, 0x0C, 0xA0, 0x20, 0x8A, 0x06, 0x28, 0x22, 0xFE, 0x12, 0x0B,
  0xA0, 0x20, 0x7A, 0x06, 0x28, 0x1A, 0xF7, 0x30, 0xCA, 0x02, 0x07, 0xA8, 0x37, 0x03, 0xFD, 0x40,
  0xDA, 0x01, 0x05, 0xA8, 0x39, 0x0B, 0xF5, 0x48, 0x3E, 0xFE, 0x02, 0xA8, 0x2C, 0x4F, 0xC4, 0x02,
  0xA0, 0xC2, 0x0E, 0xA8, 0x1D, 0xF4, 0x40, 0x6A, 0x08, 0x20, 0x9B, 0x0B, 0x50, 0xDA, 0x03, 0x20,
  0x2B, 0x06, 0x40, 0x9A, 0x0B, 0x40, 0xAB, 0x82, 0xA7, 0x8C, 0xA0, 0xE0, 0x23, 0x01, 0x0E, 0xF9,
  0x0E, 0x03, 0x48, 0x91, 0x9F, 0x82, 0x9D, 0xFE, 0xC7, 0x15, 0x81, 0x5C, 0x17, 0x50,
  // "Ù" (U+00D9)
  0x28, 0x26, 0x77, 0x37, 0x20, 0x5A, 0x0D, 0x73, 0x07, 0xA0, 0x77, 0x38, 0x28, 0xFE, 0x27, 0x38,
  0x17, 0xFB, 0x77, 0x77, 0x3A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60,
  0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A,
  0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03,
  0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0,
  0xD6, 0x03, 0xA8, 0x29, 0xEF, 0xD6, 0x03, 0xA0, 0x90, 0xDA, 0x60, 0x5A, 0x08, 0x0A, 0xA0, 0x35,
  0x09, 0xA0, 0x05, 0xA0, 0xC4, 0x02, 0xA0, 0xE2, 0x0C, 0xA8, 0x3D, 0x87, 0x9E, 0xA0, 0x72, 0x02,
  0x0D, 0xF0, 0xA5, 0x85, 0x7C, 0xEF, 0xEA, 0x53,
  // "Ú" (U+00DA)
  0x78, 0x23, 0x77, 0x67, 0x20, 0xDA, 0x06, 0x71, 0x07, 0xA0, 0x77, 0x18, 0x22, 0xEF, 0x87, 0x28,
  0x1B, 0xF8, 0x77, 0x77, 0x3A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60,
  0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A,
  0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03,
  0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0,
  0xD6, 0x03, 0xA8, 0x29, 0xEF, 0xD6, 0x03, 0xA0, 0x90, 0xDA, 0x60, 0x5A, 0x08, 0x0A, 0xA0, 0x35,
  0x09, 0xA0, 0x05, 0xA0, 0xC4, 0x02, 0xA0, 0xE2, 0x0C, 0xA8, 0x3D, 0x87, 0x9E, 0xA0, 0x72, 0x02,
  0x0D, 0xF0, 0xA5, 0x85, 0x7C, 0xEF, 0xEA, 0x53,
  // "Û" (U+00DB)
  0x48, 0x21, 0x77, 0x67, 0x20, 0x9B, 0x04, 0x70, 0x4A, 0x81, 0xCF, 0xD6, 0x86, 0x1D, 0xF5, 0x0B,
  0xFA, 0x58, 0x1A, 0xF5, 0x38, 0x1A, 0xF6, 0x77, 0x77, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60,
  0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A,
  0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03,
  0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0,
  0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x82, 0x9E, 0xFD, 0x60, 0x3A, 0x09, 0x0D, 0xA6, 0x05,
  0xA0, 0x80, 0xAA, 0x03, 0x50, 0x9A, 0x00, 0x5A, 0x0C, 0x40, 0x2A, 0x0E, 0x20, 0xCA, 0x83, 0xD8,
  0x79, 0xEA, 0x07, 0x20, 0x20, 0xDF, 0x0A, 0x58, 0x57, 0xCE, 0xFE, 0xA5, 0x30,
  // "Ü" (U+00DC)
  0x28, 0x71, 0xDD, 0x10, 0x2D, 0xD1, 0x40, 0x5A, 0x81, 0x50, 0x6A, 0x04, 0x48, 0x71, 0xDD, 0x10,
  0x2D, 0xD1, 0x77, 0x77, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03,
  0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0,
  0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A,
  0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D,
  0x60, 0x3A, 0x82, 0x9E, 0xFD, 0x60, 0x3A, 0x09, 0x0D, 0xA6, 0x05, 0xA0, 0x80, 0xAA, 0x03, 0x50,
  0x9A, 0x00, 0x5A, 0x0C, 0x40, 0x2A, 0x0E, 0x20, 0xCA, 0x83, 0xD8, 0x79, 0xEA, 0x07, 0x20, 0x20,
  0xDF, 0x0A, 0x58, 0x57, 0xCE, 0xFE, 0xA5, 0x30,
  // "Ý" (U+00DD)
  0x78, 0x23, 0x77, 0x67, 0x20, 0xDA, 0x06, 0x71, 0x07, 0xA0, 0x77, 0x18, 0x22, 0xEF, 0x87, 0x28,
  0x1B, 0xF8, 0x77, 0x77, 0x30, 0xCA, 0x03, 0x50, 0x2A, 0x0D, 0x06, 0xA0, 0x95, 0x08, 0xA8, 0x37,
  0x1E, 0xFE, 0x50, 0xDA, 0x81, 0x10, 0x9A, 0x05, 0x30, 0x4A, 0x0A, 0x20, 0x3A, 0x0B, 0x30, 0xAA,
  0x04, 0x30, 0xDA, 0x81, 0x20, 0x1A, 0x0D, 0x40, 0x7A, 0x81, 0x80, 0x7A, 0x07, 0x40, 0x1A, 0x81,
  0xE0, 0xCA, 0x01, 0x50, 0xAA, 0x08, 0xA0, 0xA6, 0x04, 0xD0, 0x47, 0x0D, 0xB0, 0xD7, 0x10, 0x7B,
  0x08, 0x71, 0x01, 0xB0, 0x27, 0x28, 0x1E, 0xFE, 0x73, 0x81, 0xEF, 0xE7, 0x38, 0x1E, 0xFE, 0x73,
  0x81, 0xEF, 0xE7, 0x38, 0x1E, 0xFE, 0x73, 0x81, 0xEF, 0xE7, 0x38, 0x1E, 0xFE, 0x73, 0x81, 0xEF,
  0xE5,
  // "Þ" (U+00DE)
  0x0C, 0xA7, 0x10, 0xCA, 0x71, 0x0C, 0xA7, 0x10, 0xCA, 0x71, 0x0C, 0xC8, 0x2E, 0xD9, 0x22, 0x0C,
  0xF9, 0x81, 0x60, 0xCA, 0x82, 0x76, 0x8C, 0xB0, 0x20, 0xCA, 0x40, 0x9A, 0x09, 0x0C, 0xA4, 0x01,
  0xA0, 0xD0, 0xCA, 0x58, 0x2E, 0xFE, 0xCA, 0x58, 0x2E, 0xFE, 0xCA, 0x5A, 0x0D, 0x0C, 0xA4, 0x06,
  0xA0, 0x90, 0xCA, 0x20, 0x10, 0x7B, 0x03, 0x0C, 0xF9, 0x81, 0x80, 0xCE, 0x0D, 0x06, 0x20, 0xCA,
  0x82, 0x76, 0x53, 0x40, 0xCA, 0x71, 0x0C, 0xA7, 0x10, 0xCA, 0x71, 0x0C, 0xA7, 0x10,
  // "ß" (U+00DF)
  0x38, 0x54, 0xBE, 0xFE, 0xA3, 0x50, 0x9F, 0x07, 0x30, 0x5B, 0x81, 0x97, 0xAB, 0x02, 0x20, 0xBA,
  0x04, 0x30, 0x8A, 0x06, 0x2A, 0x0D, 0x40, 0x4A, 0x07, 0x2A, 0x0B, 0x40, 0x6A, 0x81, 0x50, 0x1A,
  0x0A, 0x38, 0x21, 0xDF, 0xD2, 0x01, 0xA0, 0xA3, 0x0C, 0xA0, 0x32, 0x01, 0xA0, 0xA2, 0x0A, 0xA0,
  0x43, 0x01, 0xA8, 0x1A, 0x01, 0xA0, 0xA4, 0x01, 0xA8, 0x1A, 0x02, 0xA0, 0x94, 0x01, 0xA0, 0xA2,
  0x82, 0xEF, 0xE3, 0x30, 0x1A, 0x0A, 0x20, 0x8A, 0x0E, 0x03, 0x20, 0x1A, 0x0A, 0x30, 0xBB, 0x81,
  0x40, 0x1A, 0x0A, 0x40, 0xAA, 0x81, 0xE1, 0x1A, 0x0A, 0x50, 0xAA, 0x09, 0x01, 0xA0, 0xA6, 0x82,
  0xEF, 0xD1, 0xA0, 0xA6, 0x82, 0xCF, 0xE1, 0xA8, 0x1A, 0x03, 0x38, 0x31, 0xEF, 0xD1, 0xA8, 0x5A,
  0x0D, 0xB7, 0x7D, 0xA0, 0x80, 0x1A, 0x81, 0xA0, 0xDD, 0x81, 0xD1, 0x1A, 0x87, 0xA0, 0x7C, 0xEF,
  0xD9, 0x11,
  // "à" (U+00E0)
  0x28, 0x26, 0x77, 0x37, 0x05, 0xA0, 0xD7, 0x10, 0x7A, 0x07, 0x71, 0x82, 0x8F, 0xE2, 0x71, 0x81,
  0x7F, 0xB7, 0x77, 0x68, 0x54, 0xAD, 0xFE, 0xB4, 0x30, 0x8F, 0x05, 0x28, 0x43, 0xFC, 0x97, 0xBA,
  0x0D, 0x30, 0x24, 0x0A, 0xA0, 0x27, 0x06, 0xA0, 0x57, 0x05, 0xA0, 0x52, 0x81, 0x5B, 0xED, 0x81,
  0x60, 0xAF, 0x90, 0x06, 0xB8, 0x2B, 0x86, 0x9A, 0x06, 0x0C, 0xA0, 0x63, 0x05, 0xA8, 0x26, 0xEF,
  0xE4, 0x06, 0xA8, 0x26, 0xEF, 0xD4, 0x09, 0xA0, 0x60, 0xCA, 0x01, 0x20, 0x2B, 0x06, 0x08, 0xA8,
  0x3D, 0x79, 0xEC, 0xA8, 0x16, 0x1E, 0xC8, 0x96, 0xE2, 0xEF, 0x60, 0x3B, 0xFE, 0xA2, 0x0B, 0xF6,
  // "á" (U+00E1)
  0x68, 0x23, 0x77, 0x67, 0x0D, 0xA0, 0x66, 0x07, 0xA0, 0x76, 0x82, 0x2E, 0xF8, 0x78, 0x1B, 0xF8,
  0x77, 0x77, 0x85, 0x4A, 0xDF, 0xEB, 0x43, 0x08, 0xF0, 0x52, 0x84, 0x3F, 0xC9, 0x7B, 0xA0, 0xD3,
  0x02, 0x40, 0xAA, 0x02, 0x70, 0x6A, 0x05, 0x70, 0x5A, 0x05, 0x28, 0x15, 0xBE, 0xD8, 0x16, 0x0A,
  0xF9, 0x00, 0x6B, 0x82, 0xB8, 0x69, 0xA0, 0x60, 0xCA, 0x06, 0x30, 0x5A, 0x82, 0x6E, 0xFE, 0x40,
  0x6A, 0x82, 0x6E, 0xFD, 0x40, 0x9A, 0x06, 0x0C, 0xA0, 0x12, 0x02, 0xB0, 0x60, 0x8A, 0x83, 0xD7,
  0x9E, 0xCA, 0x81, 0x61, 0xEC, 0x89, 0x6E, 0x2E, 0xF6, 0x03, 0xBF, 0xEA, 0x20, 0xBF, 0x60,
  // "â" (U+00E2)
  0x38, 0x21, 0x77, 0x67, 0x09, 0xB0, 0x45, 0x04, 0xA8, 0x1C, 0xFD, 0x48, 0x61, 0xDF, 0x50, 0xBF,
  0xA3, 0x81, 0xAF, 0x53, 0x81, 0xAF, 0x67, 0x77, 0x48, 0x54, 0xAD, 0xFE, 0xB4, 0x30, 0x8F, 0x05,
  0x28, 0x43, 0xFC, 0x97, 0xBA, 0x0D, 0x30, 0x24, 0x0A, 0xA0, 0x27, 0x06, 0xA0, 0x57, 0x05, 0xA0,
  0x52, 0x81, 0x5B, 0xED, 0x81, 0x60, 0xAF, 0x90, 0x06, 0xB8, 0x2B, 0x86, 0x9A, 0x06, 0x0C, 0xA0,
  0x63, 0x05, 0xA8, 0x26, 0xEF, 0xE4, 0x06, 0xA8, 0x26, 0xEF, 0xD4, 0x09, 0xA0, 0x60, 0xCA, 0x01,
  0x20, 0x2B, 0x06, 0x08, 0xA8, 0x3D, 0x79, 0xEC, 0xA8, 0x16, 0x1E, 0xC8, 0x96, 0xE2, 0xEF, 0x60,
  0x3B, 0xFE, 0xA2, 0x0B, 0xF6,
  // "ã" (U+00E3)
  0x28, 0x27, 0xED, 0x62, 0x83, 0x7F, 0x30, 0x4C, 0x81, 0xC7, 0xE9, 0x28, 0x29, 0xF9, 0x9C, 0x0A,
  0x20, 0xC0, 0xD2, 0x83, 0x2B, 0xEC, 0x17, 0x77, 0x48, 0x54, 0xAD, 0xFE, 0xB4, 0x30, 0x8F, 0x05,
  0x28, 0x43, 0xFC, 0x97, 0xBA, 0x0D, 0x30, 0x24, 0x0A, 0xA0, 0x27, 0x06, 0xA0, 0x57, 0x05, 0xA0,
  0x52, 0x81, 0x5B, 0xED, 0x81, 0x60, 0xAF, 0x90, 0x06, 0xB8, 0x2B, 0x86, 0x9A, 0x06, 0x0C, 0xA0,
  0x63, 0x05, 0xA8, 0x26, 0xEF, 0xE4, 0x06, 0xA8, 0x26, 0xEF, 0xD4, 0x09, 0xA0, 0x60, 0xCA, 0x01,
  0x20, 0x2B, 0x06, 0x08, 0xA8, 0x3D, 0x79, 0xEC, 0xA8, 0x16, 0x1E, 0xC8, 0x96, 0xE2, 0xEF, 0x60,
  0x3B, 0xFE, 0xA2, 0x0B, 0xF6,
  // "ä" (U+00E4)
  0x18, 0x71, 0xDD, 0x10, 0x2D, 0xD1, 0x20, 0x5A, 0x81, 0x50, 0x6A, 0x04, 0x28, 0x71, 0xDD, 0x10,
  0x2D, 0xD1, 0x77, 0x74, 0x85, 0x4A, 0xDF, 0xEB, 0x43, 0x08, 0xF0, 0x52, 0x84, 0x3F, 0xC9, 0x7B,
  0xA0, 0xD3, 0x02, 0x40, 0xAA, 0x02, 0x70, 0x6A, 0x05, 0x70, 0x5A, 0x05, 0x28, 0x15, 0xBE, 0xD8,
  0x16, 0x0A, 0xF9, 0x00, 0x6B, 0x82, 0xB8, 0x69, 0xA0, 0x60, 0xCA, 0x06, 0x30, 0x5A, 0x82, 0x6E,
  0xFE, 0x40, 0x6A, 0x82, 0x6E, 0xFD, 0x40, 0x9A, 0x06, 0x0C, 0xA0, 0x12, 0x02, 0xB0, 0x60, 0x8A,
  0x83, 0xD7, 0x9E, 0xCA, 0x81, 0x61, 0xEC, 0x89, 0x6E, 0x2E, 0xF6, 0x03, 0xBF, 0xEA, 0x20, 0xBF,
  0x60,
  // "å" (U+00E5)
  0x48, 0x37, 0xDE, 0xA2, 0x58, 0x47, 0xFE, 0xDF, 0xD5, 0x85, 0xCD, 0x10, 0x8F, 0x34, 0x0C, 0x0D,
  0x28, 0x18, 0xF2, 0x48, 0x47, 0xFE, 0xDF, 0xD6, 0x83, 0x8D, 0xEB, 0x27, 0x77, 0x58, 0x54, 0xAD,
  0xFE, 0xB4, 0x30, 0x8F, 0x05, 0x28, 0x43, 0xFC, 0x97, 0xBA, 0x0D, 0x30, 0x24, 0x0A, 0xA0, 0x27,
  0x06, 0xA0, 0x57, 0x05, 0xA0, 0x52, 0x81, 0x5B, 0xED, 0x81, 0x60, 0xAF, 0x90, 0x06, 0xB8, 0x2B,
  0x86, 0x9A, 0x06, 0x0C, 0xA0, 0x63, 0x05, 0xA8, 0x26, 0xEF, 0xE4, 0x06, 0xA8, 0x26, 0xEF, 0xD4,
  0x09, 0xA0, 0x60, 0xCA, 0x01, 0x20, 0x2B, 0x06, 0x08, 0xA8, 0x3D, 0x79, 0xEC, 0xA8, 0x16, 0x1E,
  0xC8, 0x96, 0xE2, 0xEF, 0x60, 0x3B, 0xFE, 0xA2, 0x0B, 0xF6,
  // "æ" (U+00E6)
  0x28, 0x44, 0xBE, 0xFD, 0x82, 0x84, 0x3B, 0xEE, 0xB4, 0x40, 0x9E, 0x0B, 0x04, 0xE0, 0x73, 0x84,
  0x4F, 0xC8, 0x7C, 0xC8, 0x2E, 0x87, 0xDA, 0x02, 0x30, 0x24, 0x0C, 0xA0, 0xE0, 0x12, 0x01, 0xA0,
  0xA7, 0x10, 0x8A, 0x08, 0x48, 0x1A, 0xFE, 0x71, 0x07, 0xA0, 0x54, 0x07, 0xA0, 0x12, 0x81, 0x5B,
  0xEF, 0xE8, 0x12, 0x0A, 0xFF, 0xA0, 0x20, 0x6B, 0x82, 0xA7, 0x6A, 0xA0, 0x98, 0x03, 0x60, 0x10,
  0xCA, 0x05, 0x30, 0x7A, 0x05, 0x71, 0x81, 0xEF, 0xE4, 0x08, 0xA0, 0x77, 0x18, 0x1E, 0xFD, 0x40,
  0xBA, 0x0C, 0x71, 0x0D, 0xA0, 0x12, 0x04, 0xC0, 0x54, 0x82, 0x13, 0x08, 0xA8, 0x1D, 0x79, 0xA0,
  0x40, 0xEA, 0x87, 0xA7, 0x7A, 0xE8, 0x01, 0xED, 0x82, 0x60, 0x4E, 0xE0, 0x82, 0x84, 0x2B, 0xEE,
  0xB4, 0x38, 0x52, 0x9D, 0xFD, 0xB7, 0x20,
  // "ç" (U+00E7)
  0x38, 0x56, 0xCE, 0xEC, 0x81, 0x20, 0xAE, 0x81, 0x40, 0x7A, 0x83, 0xE8, 0x7B, 0xE2, 0x82, 0xEF,
  0xE2, 0x38, 0x11, 0x05, 0xA0, 0x86, 0x08, 0xA0, 0x46, 0x0A, 0xA0, 0x26, 0x0B, 0xA0, 0x16, 0x0B,
  0xA0, 0x16, 0x0A, 0xA0, 0x26, 0x09, 0xA0, 0x46, 0x06, 0xA0, 0x86, 0x01, 0xA0, 0xE0, 0x24, 0x81,
  0x10, 0x9A, 0x84, 0xE8, 0x79, 0xE4, 0x20, 0xCE, 0x04, 0x38, 0x47, 0xCE, 0xEC, 0x75, 0x81, 0x4F,
  0x57, 0x81, 0xBF, 0x67, 0x82, 0x7D, 0xFC, 0x71, 0xA0, 0x46, 0x02, 0xA0, 0x34, 0x00, 0xDA, 0x0D,
  0x58, 0x3D, 0xFE, 0xA2, 0x20,
  // "è" (U+00E8)
  0x28, 0x26, 0x77, 0x37, 0x10, 0x5A, 0x0D, 0x72, 0x07, 0xA0, 0x77, 0x28, 0x28, 0xFE, 0x27, 0x28,
  0x17, 0xFB, 0x77, 0x77, 0x38, 0x47, 0xCE, 0xEA, 0x35, 0x0B, 0xE0, 0x53, 0x08, 0xA8, 0x5C, 0x78,
  0xEF, 0xE1, 0x28, 0x1E, 0xFC, 0x30, 0x3A, 0x81, 0x80, 0x5A, 0x04, 0x48, 0x3C, 0xFC, 0x08, 0xA0,
  0x14, 0x83, 0x9F, 0xE0, 0xAF, 0xB1, 0x0B, 0xFB, 0x01, 0x0B, 0xA8, 0x04, 0x61, 0x0A, 0xA0, 0x17,
  0x10, 0x8A, 0x03, 0x71, 0x05, 0xA0, 0x87, 0x28, 0x2E, 0xFE, 0x34, 0x01, 0x02, 0x20, 0x7B, 0x84,
  0x97, 0x7B, 0xF6, 0x30, 0xAF, 0x06, 0x48, 0x55, 0xBE, 0xFE, 0xB6, 0x20,
  // "é" (U+00E9)
  0x68, 0x23, 0x77, 0x67, 0x10, 0xDA, 0x06, 0x70, 0x7A, 0x07, 0x78, 0x22, 0xEF, 0x87, 0x18, 0x1B,
  0xF8, 0x77, 0x77, 0x48, 0x47, 0xCE, 0xEA, 0x35, 0x0B, 0xE0, 0x53, 0x08, 0xA8, 0x5C, 0x78, 0xEF,
  0xE1, 0x28, 0x1E, 0xFC, 0x30, 0x3A, 0x81, 0x80, 0x5A, 0x04, 0x48, 0x3C, 0xFC, 0x08, 0xA0, 0x14,
  0x83, 0x9F, 0xE0, 0xAF, 0xB1, 0x0B, 0xFB, 0x01, 0x0B, 0xA8, 0x04, 0x61, 0x0A, 0xA0, 0x17, 0x10,
  0x8A, 0x03, 0x71, 0x05, 0xA0, 0x87, 0x28, 0x2E, 0xFE, 0x34, 0x01, 0x02, 0x20, 0x7B, 0x84, 0x97,
  0x7B, 0xF6, 0x30, 0xAF, 0x06, 0x48, 0x55, 0xBE, 0xFE, 0xB6, 0x20,
  // "ê" (U+00EA)
  0x38, 0x21, 0x77, 0x67, 0x10, 0x9B, 0x04, 0x60, 0x4A, 0x81, 0xCF, 0xD5, 0x86, 0x1D, 0xF5, 0x0B,
  0xFA, 0x48, 0x1A, 0xF5, 0x38, 0x1A, 0xF6, 0x77, 0x77, 0x18, 0x47, 0xCE, 0xEA, 0x35, 0x0B, 0xE0,
  0x53, 0x08, 0xA8, 0x5C, 0x78, 0xEF, 0xE1, 0x28, 0x1E, 0xFC, 0x30, 0x3A, 0x81, 0x80, 0x5A, 0x04,
  0x48, 0x3C, 0xFC, 0x08, 0xA0, 0x14, 0x83, 0x9F, 0xE0, 0xAF, 0xB1, 0x0B, 0xFB, 0x01, 0x0B, 0xA8,
  0x04, 0x61, 0x0A, 0xA0, 0x17, 0x10, 0x8A, 0x03, 0x71, 0x05, 0xA0, 0x87, 0x28, 0x2E, 0xFE, 0x34,
  0x01, 0x02, 0x20, 0x7B, 0x84, 0x97, 0x7B, 0xF6, 0x30, 0xAF, 0x06, 0x48, 0x55, 0xBE, 0xFE, 0xB6,
  0x20,
  // "ë" (U+00EB)
  0x18, 0x71, 0xDD, 0x10, 0x2D, 0xD1, 0x30, 0x5A, 0x81, 0x50, 0x6A, 0x04, 0x38, 0x71, 0xDD, 0x10,
  0x2D, 0xD1, 0x77, 0x77, 0x18, 0x47, 0xCE, 0xEA, 0x35, 0x0B, 0xE0, 0x53, 0x08, 0xA8, 0x5C, 0x78,
  0xEF, 0xE1, 0x28, 0x1E, 0xFC, 0x30, 0x3A, 0x81, 0x80, 0x5A, 0x04, 0x48, 0x3C, 0xFC, 0x08, 0xA0,
  0x14, 0x83, 0x9F, 0xE0, 0xAF, 0xB1, 0x0B, 0xFB, 0x01, 0x0B, 0xA8, 0x04, 0x61, 0x0A, 0xA0, 0x17,
  0x10, 0x8A, 0x03, 0x71, 0x05, 0xA0, 0x87, 0x28, 0x2E, 0xFE, 0x34, 0x01, 0x02, 0x20, 0x7B, 0x84,
  0x97, 0x7B, 0xF6, 0x30, 0xAF, 0x06, 0x48, 0x55, 0xBE, 0xFE, 0xB6, 0x20,
  // "ì" (U+00EC)
  0x82, 0x67, 0x73, 0x20, 0x5A, 0x0D, 0x30, 0x7A, 0x07, 0x38, 0x28, 0xFE, 0x23, 0x81, 0x7F, 0xB7,
  0x70, 0x1A, 0x0A, 0x20, 0x1A, 0x0A, 0x20, 0x1A, 0x0A, 0x20, 0x1A, 0x0A, 0x20, 0x1A, 0x0A, 0x20,
  0x1A, 0x0A, 0x20, 0x1A, 0x0A, 0x20, 0x1A, 0x0A, 0x20, 0x1A, 0x0A, 0x20, 0x1A, 0x0A, 0x20, 0x1A,
  0x0A, 0x20, 0x1A, 0x0A, 0x20, 0x1A, 0x0A, 0x20, 0x1A, 0x0A, 0x20, 0x1A, 0x0A, 0x20, 0x1A, 0x0A,
  // "í" (U+00ED)
  0x38, 0x23, 0x77, 0x63, 0x0D, 0xA0, 0x62, 0x07, 0xA0, 0x72, 0x82, 0x2E, 0xF8, 0x38, 0x1B, 0xF8,
  0x77, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A,
  0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30,
  0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A,
  0x0A, 0x30,
  // "î" (U+00EE)
  0x28, 0x21, 0x77, 0x65, 0x09, 0xB0, 0x43, 0x04, 0xA8, 0x1C, 0xFD, 0x28, 0x92, 0x1D, 0xF5, 0x0B,
  0xFA, 0x0A, 0xF5, 0x38, 0x1A, 0xF6, 0x77, 0x60, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A,
  0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50,
  0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A,
  0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x30,
  // "ï" (U+00EF)
  0x89, 0x01, 0xDD, 0x10, 0x2D, 0xD1, 0x5A, 0x81, 0x50, 0x6A, 0x89, 0x04, 0x1D, 0xD1, 0x02, 0xDD,
  0x17, 0x76, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0,
  0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5,
  0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01,
  0xA0, 0xA3,
  // "ð" (U+00F0)
  0x40, 0x17, 0x38, 0x56, 0xE6, 0x02, 0xCA, 0x50, 0xBA, 0x0C, 0xA0, 0xC0, 0x15, 0x0A, 0xB0, 0x76,
  0x05, 0x0E, 0xB0, 0x95, 0x03, 0xA0, 0x90, 0xAA, 0x04, 0x58, 0x58, 0x30, 0x1E, 0xFD, 0x72, 0x05,
  0xA0, 0x57, 0x28, 0x1D, 0xFC, 0x48, 0x48, 0xDF, 0xD8, 0x9A, 0x82, 0x20, 0x1D, 0xD0, 0xEA, 0x81,
  0x60, 0xAA, 0x82, 0xD7, 0x7C, 0xB0, 0x90, 0x2A, 0x0D, 0x40, 0xCA, 0x0B, 0x07, 0xA0, 0x54, 0x04,
  0xA0, 0xD0, 0xAA, 0x02, 0x5A, 0x0D, 0x0B, 0xA6, 0x82, 0xEF, 0xDB, 0xA0, 0x15, 0x82, 0xEF, 0xC9,
  0xA0, 0x25, 0xA0, 0xA0, 0x6A, 0x07, 0x40, 0x4A, 0x07, 0x01, 0xA0, 0xD4, 0x0B, 0xA8, 0x12, 0x08,
  0xA8, 0x2D, 0x77, 0xCA, 0x09, 0x30, 0xAE, 0x0C, 0x58, 0x45, 0xCE, 0xEC, 0x73,
  // "ñ" (U+00F1)
  0x38, 0x27, 0xED, 0x62, 0x81, 0x7F, 0x32, 0x04, 0xC8, 0x1C, 0x7E, 0x93, 0x82, 0x9F, 0x99, 0xC0,
  0xA3, 0x0C, 0x0D, 0x28, 0x32, 0xBE, 0xC1, 0x77, 0x74, 0x01, 0xA8, 0x52, 0x08, 0xDF, 0xD7, 0x20,
  0x1A, 0x05, 0x0C, 0xD8, 0x18, 0x01, 0xA8, 0x3E, 0xFA, 0x7A, 0xB0, 0x20, 0x1B, 0x08, 0x30, 0x9A,
  0x06, 0x01, 0xB0, 0x13, 0x04, 0xA0, 0x80, 0x1A, 0x0D, 0x40, 0x2A, 0x09, 0x01, 0xA0, 0xB4, 0x01,
  0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40,
  0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4,
  0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A,
  0x40, 0x1A, 0x09,
  // "ò" (U+00F2)
  0x28, 0x26, 0x77, 0x37, 0x10, 0x5A, 0x0D, 0x72, 0x07, 0xA0, 0x77, 0x28, 0x28, 0xFE, 0x27, 0x28,
  0x17, 0xFB, 0x77, 0x77, 0x38, 0x46, 0xCE, 0xEC, 0x65, 0x0B, 0xE0, 0xB3, 0x08, 0xA8, 0x2D, 0x87,
  0xDA, 0x08, 0x28, 0x2E, 0xFE, 0x13, 0x0D, 0xA0, 0x10, 0x5A, 0x08, 0x40, 0x6A, 0x06, 0x08, 0xA0,
  0x44, 0x02, 0xA0, 0x0A, 0xA0, 0x25, 0xA0, 0xC0, 0xBA, 0x01, 0x5A, 0x0D, 0x0B, 0xA0, 0x15, 0xA0,
  0xC0, 0xAA, 0x02, 0x5A, 0x0B, 0x08, 0xA0, 0x44, 0x02, 0xA0, 0x90, 0x4A, 0x08, 0x40, 0x6A, 0x84,
  0x60, 0xEF, 0xE1, 0x38, 0x4D, 0xFE, 0x10, 0x6A, 0x82, 0xD8, 0x7D, 0xA0, 0x83, 0x09, 0xE0, 0xA5,
  0x84, 0x5B, 0xEE, 0xC6, 0x30,
  // "ó" (U+00F3)
  0x68, 0x23, 0x77, 0x67, 0x10, 0xDA, 0x06, 0x70, 0x7A, 0x07, 0x78, 0x22, 0xEF, 0x87, 0x18, 0x1B,
  0xF8, 0x77, 0x77, 0x48, 0x46, 0xCE, 0xEC, 0x65, 0x0B, 0xE0, 0xB3, 0x08, 0xA8, 0x2D, 0x87, 0xDA,
  0x08, 0x28, 0x2E, 0xFE, 0x13, 0x0D, 0xA0, 0x10, 0x5A, 0x08, 0x40, 0x6A, 0x06, 0x08, 0xA0, 0x44,
  0x02, 0xA0, 0x0A, 0xA0, 0x25, 0xA0, 0xC0, 0xBA, 0x01, 0x5A, 0x0D, 0x0B, 0xA0, 0x15, 0xA0, 0xC0,
  0xAA, 0x02, 0x5A, 0x0B, 0x08, 0xA0, 0x44, 0x02, 0xA0, 0x90, 0x4A, 0x08, 0x40, 0x6A, 0x84, 0x60,
  0xEF, 0xE1, 0x38, 0x4D, 0xFE, 0x10, 0x6A, 0x82, 0xD8, 0x7D, 0xA0, 0x83, 0x09, 0xE0, 0xA5, 0x84,
  0x5B, 0xEE, 0xC6, 0x30,
  // "ô" (U+00F4)
  0x48, 0x21, 0x77, 0x67, 0x10, 0x9B, 0x04, 0x60, 0x4A, 0x81, 0xCF, 0xD5, 0x86, 0x1D, 0xF5, 0x0B,
  0xFA, 0x48, 0x1A, 0xF5, 0x38, 0x1A, 0xF6, 0x77, 0x77, 0x84, 0x6C, 0xEE, 0xC6, 0x50, 0xBE, 0x0B,
  0x30, 0x8A, 0x82, 0xD8, 0x7D, 0xA0, 0x82, 0x82, 0xEF, 0xE1, 0x30, 0xDA, 0x01, 0x05, 0xA0, 0x84,
  0x06, 0xA0, 0x60, 0x8A, 0x04, 0x40, 0x2A, 0x00, 0xAA, 0x02, 0x5A, 0x0C, 0x0B, 0xA0, 0x15, 0xA0,
  0xD0, 0xBA, 0x01, 0x5A, 0x0C, 0x0A, 0xA0, 0x25, 0xA0, 0xB0, 0x8A, 0x04, 0x40, 0x2A, 0x09, 0x04,
  0xA0, 0x84, 0x06, 0xA8, 0x46, 0x0E, 0xFE, 0x13, 0x84, 0xDF, 0xE1, 0x06, 0xA8, 0x2D, 0x87, 0xDA,
  0x08, 0x30, 0x9E, 0x0A, 0x58, 0x45, 0xBE, 0xEC, 0x63,
  // "õ" (U+00F5)
  0x28, 0x27, 0xED, 0x62, 0x81, 0x7F, 0x32, 0x04, 0xC8, 0x1C, 0x7E, 0x93, 0x82, 0x9F, 0x99, 0xC0,
  0xA3, 0x0C, 0x0D, 0x28, 0x32, 0xBE, 0xC1, 0x77, 0x77, 0x18, 0x46, 0xCE, 0xEC, 0x65, 0x0B, 0xE0,
  0xB3, 0x08, 0xA8, 0x2D, 0x87, 0xDA, 0x08, 0x28, 0x2E, 0xFE, 0x13, 0x0D, 0xA0, 0x10, 0x5A, 0x08,
  0x40, 0x6A, 0x06, 0x08, 0xA0, 0x44, 0x02, 0xA0, 0x0A, 0xA0, 0x25, 0xA0, 0xC0, 0xBA, 0x01, 0x5A,
  0x0D, 0x0B, 0xA0, 0x15, 0xA0, 0xC0, 0xAA, 0x02, 0x5A, 0x0B, 0x08, 0xA0, 0x44, 0x02, 0xA0, 0x90,
  0x4A, 0x08, 0x40, 0x6A, 0x84, 0x60, 0xEF, 0xE1, 0x38, 0x4D, 0xFE, 0x10, 0x6A, 0x82, 0xD8, 0x7D,
  0xA0, 0x83, 0x09, 0xE0, 0xA5, 0x84, 0x5B, 0xEE, 0xC6, 0x30,
  // "ö" (U+00F6)
  0x28, 0x71, 0xDD, 0x10, 0x2D, 0xD1, 0x30, 0x5A, 0x81, 0x50, 0x6A, 0x04, 0x38, 0x71, 0xDD, 0x10,
  0x2D, 0xD1, 0x77, 0x77, 0x84, 0x6C, 0xEE, 0xC6, 0x50, 0xBE, 0x0B, 0x30, 0x8A, 0x82, 0xD8, 0x7D,
  0xA0, 0x82, 0x82, 0xEF, 0xE1, 0x30, 0xDA, 0x01, 0x05, 0xA0, 0x84, 0x06, 0xA0, 0x60, 0x8A, 0x04,
  0x40, 0x2A, 0x00, 0xAA, 0x02, 0x5A, 0x0C, 0x0B, 0xA0, 0x15, 0xA0, 0xD0, 0xBA, 0x01, 0x5A, 0x0C,
  0x0A, 0xA0, 0x25, 0xA0, 0xB0, 0x8A, 0x04, 0x40, 0x2A, 0x09, 0x04, 0xA0, 0x84, 0x06, 0xA8, 0x46,
  0x0E, 0xFE, 0x13, 0x84, 0xDF, 0xE1, 0x06, 0xA8, 0x2D, 0x87, 0xDA, 0x08, 0x30, 0x9E, 0x0A, 0x58,
  0x45, 0xBE, 0xEC, 0x63,
  // "÷" (U+00F7)
  0x48, 0x15, 0xEB, 0x72, 0x0C, 0xA0, 0x37, 0x10, 0xCA, 0x03, 0x71, 0x81, 0x5E, 0xB7, 0x73, 0x80,
  0x76, 0x03, 0xFC, 0x06, 0xFC, 0x06, 0x77, 0x77, 0x81, 0x5E, 0xB7, 0x20, 0xCA, 0x03, 0x71, 0x0C,
  0xA0, 0x37, 0x18, 0x15, 0xEB, 0x50,
  // "ø" (U+00F8)
  0x72, 0x81, 0x49, 0x13, 0x87, 0x6C, 0xEE, 0xB4, 0xCF, 0x32, 0x0B, 0xF0, 0xB2, 0x08, 0xA8, 0x2D,
  0x78, 0xEA, 0x81, 0x70, 0x1A, 0x0D, 0x01, 0x20, 0x5A, 0x81, 0xE0, 0x6A, 0x06, 0x30, 0xDB, 0x05,
  0x09, 0xA0, 0x22, 0x81, 0x6F, 0xAA, 0x09, 0x0B, 0xA2, 0x82, 0x1E, 0xE1, 0xA0, 0xB0, 0xCA, 0x28,
  0x68, 0xF6, 0x0E, 0xFC, 0xBA, 0x18, 0x12, 0xFC, 0x28, 0x2E, 0xFC, 0xAA, 0x18, 0x1A, 0xF4, 0x28,
  0x2E, 0xFC, 0x8A, 0x81, 0x7F, 0xB2, 0x01, 0xA0, 0x90, 0x4C, 0x02, 0x20, 0x5A, 0x81, 0x60, 0xEA,
  0x09, 0x30, 0xCA, 0x81, 0x10, 0x6A, 0x82, 0xD8, 0x7D, 0xA0, 0x82, 0x07, 0xF0, 0xB3, 0x86, 0xEE,
  0x5B, 0xEE, 0xC6, 0x38, 0x13, 0xE8, 0x72,
  // "ù" (U+00F9)
  0x28, 0x26, 0x77, 0x37, 0x10, 0x5A, 0x0D, 0x72, 0x07, 0xA0, 0x77, 0x28, 0x28, 0xFE, 0x27, 0x28,
  0x17, 0xFB, 0x77, 0x77, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02,
  0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90,
  0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09,
  0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x4A, 0x09, 0x02, 0xA0, 0xA4, 0x05, 0xA0,
  0x90, 0x1A, 0x0C, 0x40, 0x9A, 0x81, 0x90, 0xEA, 0x02, 0x20, 0x20, 0xEA, 0x81, 0x90, 0x9A, 0x83,
  0xE8, 0x8E, 0xEA, 0x82, 0x90, 0x2E, 0xD8, 0x25, 0xDF, 0x92, 0x89, 0x02, 0xBE, 0xEB, 0x40, 0xBF,
  0x90,
  // "ú" (U+00FA)
  0x68, 0x23, 0x77, 0x67, 0x10, 0xDA, 0x06, 0x70, 0x7A, 0x07, 0x78, 0x22, 0xEF, 0x87, 0x18, 0x1B,
  0xF8, 0x77, 0x77, 0x10, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A,
  0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02,
  0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90,
  0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x04, 0xA0, 0x90, 0x2A, 0x0A, 0x40, 0x5A, 0x09,
  0x01, 0xA0, 0xC4, 0x09, 0xA8, 0x19, 0x0E, 0xA0, 0x22, 0x02, 0x0E, 0xA8, 0x19, 0x09, 0xA8, 0x3E,
  0x88, 0xEE, 0xA8, 0x29, 0x02, 0xED, 0x82, 0x5D, 0xF9, 0x28, 0x90, 0x2B, 0xEE, 0xB4, 0x0B, 0xF9,
  // "û" (U+00FB)
  0x48, 0x21, 0x77, 0x67, 0x10, 0x9B, 0x04, 0x60, 0x4A, 0x81, 0xCF, 0xD5, 0x86, 0x1D, 0xF5, 0x0B,
  0xFA, 0x48, 0x1A, 0xF5, 0x38, 0x1A, 0xF6, 0x77, 0x74, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A,
  0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02,
  0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90,
  0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x4A, 0x09,
  0x02, 0xA0, 0xA4, 0x05, 0xA0, 0x90, 0x1A, 0x0C, 0x40, 0x9A, 0x81, 0x90, 0xEA, 0x02, 0x20, 0x20,
  0xEA, 0x81, 0x90, 0x9A, 0x83, 0xE8, 0x8E, 0xEA, 0x82, 0x90, 0x2E, 0xD8, 0x25, 0xDF, 0x92, 0x89,
  0x02, 0xBE, 0xEB, 0x40, 0xBF, 0x90,
  // "ü" (U+00FC)
  0x28, 0x71, 0xDD, 0x10, 0x2D, 0xD1, 0x30, 0x5A, 0x81, 0x50, 0x6A, 0x04, 0x38, 0x71, 0xDD, 0x10,
  0x2D, 0xD1, 0x77, 0x74, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02,
  0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90,
  0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09,
  0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x4A, 0x09, 0x02, 0xA0, 0xA4, 0x05, 0xA0,
  0x90, 0x1A, 0x0C, 0x40, 0x9A, 0x81, 0x90, 0xEA, 0x02, 0x20, 0x20, 0xEA, 0x81, 0x90, 0x9A, 0x83,
  0xE8, 0x8E, 0xEA, 0x82, 0x90, 0x2E, 0xD8, 0x25, 0xDF, 0x92, 0x89, 0x02, 0xBE, 0xEB, 0x40, 0xBF,
  0x90,
  // "ý" (U+00FD)
  0x68, 0x23, 0x77, 0x67, 0x10, 0xDA, 0x06, 0x70, 0x7A, 0x07, 0x78, 0x22, 0xEF, 0x87, 0x18, 0x1B,
  0xF8, 0x77, 0x77, 0x10, 0xCA, 0x02, 0x58, 0x2E, 0xFE, 0x7A, 0x06, 0x40, 0x3A, 0x09, 0x02, 0xA0,
  0xA4, 0x07, 0xA8, 0x35, 0x0D, 0xFE, 0x40, 0xBA, 0x81, 0x10, 0x9A, 0x02, 0x38, 0x1E, 0xFC, 0x20,
  0x4A, 0x06, 0x20, 0x3A, 0x07, 0x3A, 0x0B, 0x20, 0x7A, 0x03, 0x38, 0x1B, 0xFE, 0x28, 0x1B, 0xFE,
  0x40, 0x6A, 0x03, 0x1A, 0x0A, 0x40, 0x1A, 0x07, 0x03, 0xA0, 0x55, 0x82, 0xCF, 0xA7, 0xA0, 0x15,
  0x84, 0x8F, 0xDA, 0xFC, 0x60, 0x3A, 0x81, 0xEF, 0x87, 0x0E, 0xB0, 0x37, 0x0A, 0xA0, 0xE7, 0x10,
  0x5A, 0x0A, 0x71, 0x06, 0xA0, 0x67, 0x10, 0xAA, 0x02, 0x71, 0xA0, 0xC7, 0x10, 0x7A, 0x07, 0x58,
  0x14, 0x8A, 0xA0, 0xE0, 0x15, 0x06, 0xC0, 0x56, 0x83, 0x5E, 0xFC, 0x47,
  // "þ" (U+00FE)
  0x01, 0xA0, 0xA7, 0x20, 0x1A, 0x0A, 0x72, 0x01, 0xA0, 0xA7, 0x20, 0x1A, 0x0A, 0x72, 0x01, 0xA0,
  0xA7, 0x20, 0x1A, 0x0A, 0x72, 0x01, 0xA8, 0x5A, 0x07, 0xDF, 0xC5, 0x30, 0x1A, 0x09, 0x0A, 0xD0,
  0x82, 0x01, 0xA8, 0x3E, 0xFA, 0x79, 0xB8, 0x12, 0x01, 0xB0, 0x83, 0x07, 0xA8, 0x19, 0x01, 0xB0,
  0x14, 0x83, 0xEF, 0xE0, 0x1A, 0x0D, 0x50, 0xBA, 0x00, 0x1A, 0x0B, 0x50, 0x9A, 0x03, 0x01, 0xA0,
  0xA5, 0x09, 0xA0, 0x30, 0x1A, 0x0A, 0x50, 0x9A, 0x03, 0x01, 0xA0, 0xB5, 0x0A, 0xA0, 0x30, 0x1A,
  0x0D, 0x50, 0xCA, 0x00, 0x1B, 0x01, 0x4A, 0x81, 0xE0, 0x1B, 0x08, 0x30, 0x7A, 0x81, 0x90, 0x1A,
  0x83, 0xEF, 0xA7, 0x9B, 0x81, 0x20, 0x1A, 0x09, 0x0B, 0xD0, 0x82, 0x01, 0xA8, 0x5A, 0x08, 0xDF,
  0xD6, 0x30, 0x1A, 0x0A, 0x72, 0x01, 0xA0, 0xA7, 0x20, 0x1A, 0x0A, 0x72, 0x01, 0xA0, 0xA7, 0x20,
  0x1A, 0x0A, 0x72, 0x01, 0xA0, 0xA7, 0x20, 0x1A, 0x0A, 0x72,
  // "ÿ" (U+00FF)
  0x28, 0x71, 0xDD, 0x10, 0x2D, 0xD1, 0x30, 0x5A, 0x81, 0x50, 0x6A, 0x04, 0x38, 0x71, 0xDD, 0x10,
  0x2D, 0xD1, 0x77, 0x74, 0x0C, 0xA0, 0x25, 0x82, 0xEF, 0xE7, 0xA0, 0x64, 0x03, 0xA0, 0x90, 0x2A,
  0x0A, 0x40, 0x7A, 0x83, 0x50, 0xDF, 0xE4, 0x0B, 0xA8, 0x11, 0x09, 0xA0, 0x23, 0x81, 0xEF, 0xC2,
  0x04, 0xA0, 0x62, 0x03, 0xA0, 0x73, 0xA0, 0xB2, 0x07, 0xA0, 0x33, 0x81, 0xBF, 0xE2, 0x81, 0xBF,
  0xE4, 0x06, 0xA0, 0x31, 0xA0, 0xA4, 0x01, 0xA0, 0x70, 0x3A, 0x05, 0x58, 0x2C, 0xFA, 0x7A, 0x01,
  0x58, 0x48, 0xFD, 0xAF, 0xC6, 0x03, 0xA8, 0x1E, 0xF8, 0x70, 0xEB, 0x03, 0x70, 0xAA, 0x0E, 0x71,
  0x05, 0xA0, 0xA7, 0x10, 0x6A, 0x06, 0x71, 0x0A, 0xA0, 0x27, 0x1A, 0x0C, 0x71, 0x07, 0xA0, 0x75,
  0x81, 0x48, 0xAA, 0x0E, 0x01, 0x50, 0x6C, 0x05, 0x68, 0x35, 0xEF, 0xC4, 0x70,
  // "Ā" (U+0100)
  0x30, 0x58, 0x02, 0x60, 0x47, 0x0D, 0xE0, 0xA7, 0x0D, 0xE0, 0xA8, 0x0C, 0x30, 0x07, 0xB0, 0x27,
  0x30, 0xBB, 0x06, 0x73, 0xC0, 0xA7, 0x20, 0x4A, 0x81, 0xAF, 0xE7, 0x20, 0x8A, 0x05, 0xA0, 0x37,
  0x18, 0x2C, 0xFC, 0x1A, 0x08, 0x70, 0x1A, 0x83, 0x80, 0xDF, 0xC7, 0x05, 0xA8, 0x15, 0x09, 0xA0,
  0x16, 0x09, 0xA8, 0x11, 0x05, 0xA0, 0x56, 0x81, 0xDF, 0xD2, 0x02, 0xA0, 0x95, 0x02, 0xA0, 0x93,
  0x81, 0xDF, 0xD5, 0x06, 0xA0, 0x53, 0x0A, 0xA0, 0x24, 0x0B, 0xA8, 0x3B, 0xAA, 0xAC, 0xA0, 0x64,
  0x0E, 0xFA, 0x0A, 0x30, 0x3F, 0xB0, 0xE3, 0x08, 0xA0, 0x75, 0x0B, 0xA0, 0x32, 0x0C, 0xA0, 0x35,
  0x07, 0xA8, 0x18, 0x01, 0xA0, 0xE6, 0x03, 0xA8, 0x1C, 0x05, 0xA0, 0xA7, 0x0E, 0xA0, 0x10, 0x9A,
  0x06, 0x70, 0xAA, 0x05, 0x0D, 0xA0, 0x27, 0x06, 0xA0, 0x90,
  // "ā" (U+0101)
  0x20, 0x58, 0x02, 0x60, 0x43, 0x0D, 0xE0, 0xA3, 0x0D, 0xE0, 0xA7, 0x77, 0x48, 0x54, 0xAD, 0xFE,
  0xB4, 0x30, 0x8F, 0x05, 0x28, 0x43, 0xFC, 0x97, 0xBA, 0x0D, 0x30, 0x24, 0x0A, 0xA0, 0x27, 0x06,
  0xA0, 0x57, 0x05, 0xA0, 0x52, 0x81, 0x5B, 0xED, 0x81, 0x60, 0xAF, 0x90, 0x06, 0xB8, 0x2B, 0x86,
  0x9A, 0x06, 0x0C, 0xA0, 0x63, 0x05, 0xA8, 0x26, 0xEF, 0xE4, 0x06, 0xA8, 0x26, 0xEF, 0xD4, 0x09,
  0xA0, 0x60, 0xCA, 0x01, 0x20, 0x2B, 0x06, 0x08, 0xA8, 0x3D, 0x79, 0xEC, 0xA8, 0x16, 0x1E, 0xC8,
  0x96, 0xE2, 0xEF, 0x60, 0x3B, 0xFE, 0xA2, 0x0B, 0xF6,
  // "Ă" (U+0102)
  0x30, 0xC0, 0xE4, 0x0E, 0x0D, 0x78, 0x69, 0xFC, 0x77, 0xCF, 0xA7, 0x02, 0xD0, 0xE0, 0x27, 0x18,
  0x43, 0xBE, 0xEB, 0x38, 0x0C, 0x40, 0x07, 0xB0, 0x27, 0x30, 0xBB, 0x06, 0x73, 0xC0, 0xA7, 0x20,
  0x4A, 0x81, 0xAF, 0xE7, 0x20, 0x8A, 0x05, 0xA0, 0x37, 0x18, 0x2C, 0xFC, 0x1A, 0x08, 0x70, 0x1A,
  0x83, 0x80, 0xDF, 0xC7, 0x05, 0xA8, 0x15, 0x09, 0xA0, 0x16, 0x09, 0xA8, 0x11, 0x05, 0xA0, 0x56,
  0x81, 0xDF, 0xD2, 0x02, 0xA0, 0x95, 0x02, 0xA0, 0x93, 0x81, 0xDF, 0xD5, 0x06, 0xA0, 0x53, 0x0A,
  0xA0, 0x24, 0x0B, 0xA8, 0x3B, 0xAA, 0xAC, 0xA0, 0x64, 0x0E, 0xFA, 0x0A, 0x30, 0x3F, 0xB0, 0xE3,
  0x08, 0xA0, 0x75, 0x0B, 0xA0, 0x32, 0x0C, 0xA0, 0x35, 0x07, 0xA8, 0x18, 0x01, 0xA0, 0xE6, 0x03,
  0xA8, 0x1C, 0x05, 0xA0, 0xA7, 0x0E, 0xA0, 0x10, 0x9A, 0x06, 0x70, 0xAA, 0x05, 0x0D, 0xA0, 0x27,
  0x06, 0xA0, 0x90,
  // "ă" (U+0103)
  0x20, 0xC0, 0xE4, 0x0E, 0x0D, 0x38, 0x69, 0xFC, 0x77, 0xCF, 0xA3, 0x02, 0xD0, 0xE0, 0x24, 0x84,
  0x3B, 0xEE, 0xB3, 0x77, 0x75, 0x85, 0x4A, 0xDF, 0xEB, 0x43, 0x08, 0xF0, 0x52, 0x84, 0x3F, 0xC9,
  0x7B, 0xA0, 0xD3, 0x02, 0x40, 0xAA, 0x02, 0x70, 0x6A, 0x05, 0x70, 0x5A, 0x05, 0x28, 0x15, 0xBE,
  0xD8, 0x16, 0x0A, 0xF9, 0x00, 0x6B, 0x82, 0xB8, 0x69, 0xA0, 0x60, 0xCA, 0x06, 0x30, 0x5A, 0x82,
  0x6E, 0xFE, 0x40, 0x6A, 0x82, 0x6E, 0xFD, 0x40, 0x9A, 0x06, 0x0C, 0xA0, 0x12, 0x02, 0xB0, 0x60,
  0x8A, 0x83, 0xD7, 0x9E, 0xCA, 0x81, 0x61, 0xEC, 0x89, 0x6E, 0x2E, 0xF6, 0x03, 0xBF, 0xEA, 0x20,
  0xBF, 0x60,
  // "Ą" (U+0104)
  0x50, 0x7B, 0x02, 0x73, 0x0B, 0xB0, 0x67, 0x3C, 0x0A, 0x72, 0x04, 0xA8, 0x1A, 0xFE, 0x72, 0x08,
  0xA0, 0x5A, 0x03, 0x71, 0x82, 0xCF, 0xC1, 0xA0, 0x87, 0x01, 0xA8, 0x38, 0x0D, 0xFC, 0x70, 0x5A,
  0x81, 0x50, 0x9A, 0x01, 0x60, 0x9A, 0x81, 0x10, 0x5A, 0x05, 0x68, 0x1D, 0xFD, 0x20, 0x2A, 0x09,
  0x50, 0x2A, 0x09, 0x38, 0x1D, 0xFD, 0x50, 0x6A, 0x05, 0x30, 0xAA, 0x02, 0x40, 0xBA, 0x83, 0xBA,
  0xAA, 0xCA, 0x06, 0x40, 0xEF, 0xA0, 0xA3, 0x03, 0xFB, 0x0E, 0x30, 0x8A, 0x07, 0x50, 0xBA, 0x03,
  0x20, 0xCA, 0x03, 0x50, 0x7A, 0x81, 0x80, 0x1A, 0x0E, 0x60, 0x3A, 0x81, 0xC0, 0x5A, 0x0A, 0x70,
  0xEA, 0x01, 0x09, 0xA0, 0x67, 0x0A, 0xA0, 0x50, 0xDA, 0x02, 0x70, 0x6A, 0x09, 0x74, 0x81, 0x5F,
  0x87, 0x48, 0x12, 0xEC, 0x75, 0x81, 0x8F, 0x67, 0x58, 0x1C, 0xF5, 0x75, 0x83, 0xCF, 0xD7, 0x47,
  0x30, 0x8B, 0x09, 0x74, 0x82, 0x9E, 0xE7,
  // "ą" (U+0105)
  0x28, 0x54, 0xAD, 0xFE, 0xB4, 0x30, 0x8F, 0x05, 0x28, 0x43, 0xFC, 0x97, 0xBA, 0x0D, 0x30, 0x24,
  0x0A, 0xA0, 0x27, 0x06, 0xA0, 0x57, 0x05, 0xA0, 0x52, 0x81, 0x5B, 0xED, 0x81, 0x60, 0xAF, 0x90,
  0x06, 0xB8, 0x2B, 0x86, 0x9A, 0x06, 0x0C, 0xA0, 0x63, 0x05, 0xA8, 0x26, 0xEF, 0xE4, 0x06, 0xA8,
  0x26, 0xEF, 0xD4, 0x09, 0xA0, 0x60, 0xCA, 0x01, 0x20, 0x2B, 0x06, 0x08, 0xA8, 0x3D, 0x79, 0xEC,
  0xA8, 0x16, 0x1E, 0xC8, 0x92, 0xE2, 0xEF, 0x60, 0x3B, 0xFE, 0xA2, 0x1A, 0x06, 0x78, 0x15, 0xF8,
  0x78, 0x12, 0xEC, 0x71, 0x81, 0x8F, 0x67, 0x18, 0x1C, 0xF5, 0x71, 0x83, 0xCF, 0xD7, 0x46, 0x08,
  0xB0, 0x97, 0x82, 0x9E, 0xE7,
  // "Ć" (U+0106)
  0x71, 0x82, 0x37, 0x76, 0x72, 0x0D, 0xA0, 0x67, 0x10, 0x7A, 0x07, 0x71, 0x82, 0x2E, 0xF8, 0x72,
  0x81, 0xBF, 0x87, 0x77, 0x76, 0x86, 0x18, 0xCE, 0xFD, 0xA5, 0x40, 0x40, 0xEF, 0x05, 0x20, 0x30,
  0xEA, 0x84, 0xC8, 0x7A, 0xFE, 0x30, 0xDA, 0x09, 0x40, 0x10, 0x62, 0x05, 0xA0, 0xC7, 0x20, 0xCA,
  0x04, 0x72, 0xA0, 0xE7, 0x20, 0x4A, 0x0B, 0x72, 0x06, 0xA0, 0x87, 0x20, 0x7A, 0x07, 0x72, 0x08,
  0xA0, 0x67, 0x20, 0x7A, 0x07, 0x72, 0x06, 0xA0, 0x87, 0x20, 0x4A, 0x0A, 0x72, 0x02, 0xA0, 0xD7,
  0x30, 0xDA, 0x03, 0x72, 0x08, 0xA0, 0xB7, 0x20, 0x10, 0xEA, 0x08, 0x50, 0x13, 0x05, 0xB8, 0x4D,
  0x87, 0x9C, 0xE4, 0x06, 0xF0, 0xE5, 0x86, 0x28, 0xDE, 0xED, 0xA5, 0x10,
  // "ć" (U+0107)
  0x68, 0x23, 0x77, 0x66, 0x0D, 0xA0, 0x65, 0x07, 0xA0, 0x75, 0x82, 0x2E, 0xF8, 0x68, 0x1B, 0xF8,
  0x77, 0x75, 0x85, 0x6C, 0xEE, 0xC8, 0x12, 0x0A, 0xE8, 0x14, 0x07, 0xA8, 0x3E, 0x87, 0xBE, 0x28,
  0x2E, 0xFE, 0x23, 0x81, 0x10, 0x5A, 0x08, 0x60, 0x8A, 0x04, 0x60, 0xAA, 0x02, 0x60, 0xBA, 0x01,
  0x60, 0xBA, 0x01, 0x60, 0xAA, 0x02, 0x60, 0x9A, 0x04, 0x60, 0x6A, 0x08, 0x60, 0x1A, 0x0E, 0x02,
  0x48, 0x11, 0x09, 0xA8, 0x4E, 0x87, 0x9E, 0x42, 0x0C, 0xE0, 0x43, 0x84, 0x7C, 0xEE, 0xC7, 0x10,
  // "Ĉ" (U+0108)
  0x58, 0x21, 0x77, 0x67, 0x20, 0x9B, 0x04, 0x70, 0x4A, 0x81, 0xCF, 0xD6, 0x86, 0x1D, 0xF5, 0x0B,
  0xFA, 0x58, 0x1A, 0xF5, 0x38, 0x1A, 0xF6, 0x77, 0x77, 0x38, 0x61, 0x8C, 0xEF, 0xDA, 0x54, 0x04,
  0x0E, 0xF0, 0x52, 0x03, 0x0E, 0xA8, 0x4C, 0x87, 0xAF, 0xE3, 0x0D, 0xA0, 0x94, 0x01, 0x06, 0x20,
  0x5A, 0x0C, 0x72, 0x0C, 0xA0, 0x47, 0x2A, 0x0E, 0x72, 0x04, 0xA0, 0xB7, 0x20, 0x6A, 0x08, 0x72,
  0x07, 0xA0, 0x77, 0x20, 0x8A, 0x06, 0x72, 0x07, 0xA0, 0x77, 0x20, 0x6A, 0x08, 0x72, 0x04, 0xA0,
  0xA7, 0x20, 0x2A, 0x0D, 0x73, 0x0D, 0xA0, 0x37, 0x20, 0x8A, 0x0B, 0x72, 0x01, 0x0E, 0xA0, 0x85,
  0x01, 0x30, 0x5B, 0x84, 0xD8, 0x79, 0xCE, 0x40, 0x6F, 0x0E, 0x58, 0x62, 0x8D, 0xEE, 0xDA, 0x51,
  // "ĉ" (U+0109)
  0x38, 0x21, 0x77, 0x66, 0x09, 0xB0, 0x44, 0x04, 0xA8, 0x1C, 0xFD, 0x38, 0x61, 0xDF, 0x50, 0xBF,
  0xA2, 0x81, 0xAF, 0x53, 0x81, 0xAF, 0x67, 0x77, 0x28, 0x56, 0xCE, 0xEC, 0x81, 0x20, 0xAE, 0x81,
  0x40, 0x7A, 0x83, 0xE8, 0x7B, 0xE2, 0x82, 0xEF, 0xE2, 0x38, 0x11, 0x05, 0xA0, 0x86, 0x08, 0xA0,
  0x46, 0x0A, 0xA0, 0x26, 0x0B, 0xA0, 0x16, 0x0B, 0xA0, 0x16, 0x0A, 0xA0, 0x26, 0x09, 0xA0, 0x46,
  0x06, 0xA0, 0x86, 0x01, 0xA0, 0xE0, 0x24, 0x81, 0x10, 0x9A, 0x84, 0xE8, 0x79, 0xE4, 0x20, 0xCE,
  0x04, 0x38, 0x47, 0xCE, 0xEC, 0x71,
  // "Ċ" (U+010A)
  0x68, 0x15, 0xEB, 0x73, 0x0C, 0xA0, 0x37, 0x20, 0xCA, 0x02, 0x72, 0x81, 0x5E, 0xA7, 0x77, 0x76,
  0x86, 0x18, 0xCE, 0xFD, 0xA5, 0x40, 0x40, 0xEF, 0x05, 0x20, 0x30, 0xEA, 0x84, 0xC8, 0x7A, 0xFE,
  0x30, 0xDA, 0x09, 0x40, 0x10, 0x62, 0x05, 0xA0, 0xC7, 0x20, 0xCA, 0x04, 0x72, 0xA0, 0xE7, 0x20,
  0x4A, 0x0B, 0x72, 0x06, 0xA0, 0x87, 0x20, 0x7A, 0x07, 0x72, 0x08, 0xA0, 0x67, 0x20, 0x7A, 0x07,
  0x72, 0x06, 0xA0, 0x87, 0x20, 0x4A, 0x0A, 0x72, 0x02, 0xA0, 0xD7, 0x30, 0xDA, 0x03, 0x72, 0x08,
  0xA0, 0xB7, 0x20, 0x10, 0xEA, 0x08, 0x50, 0x13, 0x05, 0xB8, 0x4D, 0x87, 0x9C, 0xE4, 0x06, 0xF0,
  0xE5, 0x86, 0x28, 0xDE, 0xED, 0xA5, 0x10,
  // "ċ" (U+010B)
  0x48, 0x15, 0xEB, 0x70, 0xCA, 0x03, 0x60, 0xCA, 0x02, 0x68, 0x15, 0xEA, 0x77, 0x75, 0x85, 0x6C,
  0xEE, 0xC8, 0x12, 0x0A, 0xE8, 0x14, 0x07, 0xA8, 0x3E, 0x87, 0xBE, 0x28, 0x2E, 0xFE, 0x23, 0x81,
  0x10, 0x5A, 0x08, 0x60, 0x8A, 0x04, 0x60, 0xAA, 0x02, 0x60, 0xBA, 0x01, 0x60, 0xBA, 0x01, 0x60,
  0xAA, 0x02, 0x60, 0x9A, 0x04, 0x60, 0x6A, 0x08, 0x60, 0x1A, 0x0E, 0x02, 0x48, 0x11, 0x09, 0xA8,
  0x4E, 0x87, 0x9E, 0x42, 0x0C, 0xE0, 0x43, 0x84, 0x7C, 0xEE, 0xC7, 0x10,
  // "Č" (U+010C)
  0x30, 0x60, 0x74, 0x81, 0x27, 0x44, 0x87, 0x6F, 0xC1, 0x03, 0xEE, 0x25, 0x85, 0xAF, 0xB3, 0xEF,
  0x56, 0x01, 0x0D, 0xB0, 0x97, 0x10, 0x5A, 0x0E, 0x01, 0x77, 0x77, 0x58, 0x61, 0x8C, 0xEF, 0xDA,
  0x54, 0x04, 0x0E, 0xF0, 0x52, 0x03, 0x0E, 0xA8, 0x4C, 0x87, 0xAF, 0xE3, 0x0D, 0xA0, 0x94, 0x01,
  0x06, 0x20, 0x5A, 0x0C, 0x72, 0x0C, 0xA0, 0x47, 0x2A, 0x0E, 0x72, 0x04, 0xA0, 0xB7, 0x20, 0x6A,
  0x08, 0x72, 0x07, 0xA0, 0x77, 0x20, 0x8A, 0x06, 0x72, 0x07, 0xA0, 0x77, 0x20, 0x6A, 0x08, 0x72,
  0x04, 0xA0, 0xA7, 0x20, 0x2A, 0x0D, 0x73, 0x0D, 0xA0, 0x37, 0x20, 0x8A, 0x0B, 0x72, 0x01, 0x0E,
  0xA0, 0x85, 0x01, 0x30, 0x5B, 0x84, 0xD8, 0x79, 0xCE, 0x40, 0x6F, 0x0E, 0x58, 0x62, 0x8D, 0xEE,
  0xDA, 0x51,
  // "č" (U+010D)
  0x10, 0x60, 0x74, 0x89, 0x32, 0x74, 0x06, 0xFC, 0x10, 0x3E, 0xE2, 0x28, 0x5A, 0xFB, 0x3E, 0xF5,
  0x30, 0x10, 0xDB, 0x09, 0x50, 0x5A, 0x0E, 0x01, 0x77, 0x74, 0x85, 0x6C, 0xEE, 0xC8, 0x12, 0x0A,
  0xE8, 0x14, 0x07, 0xA8, 0x3E, 0x87, 0xBE, 0x28, 0x2E, 0xFE, 0x23, 0x81, 0x10, 0x5A, 0x08, 0x60,
  0x8A, 0x04, 0x60, 0xAA, 0x02, 0x60, 0xBA, 0x01, 0x60, 0xBA, 0x01, 0x60, 0xAA, 0x02, 0x60, 0x9A,
  0x04, 0x60, 0x6A, 0x08, 0x60, 0x1A, 0x0E, 0x02, 0x48, 0x11, 0x09, 0xA8, 0x4E, 0x87, 0x9E, 0x42,
  0x0C, 0xE0, 0x43, 0x84, 0x7C, 0xEE, 0xC7, 0x10,
  // "Ď" (U+010E)
  0x20, 0x60, 0x74, 0x81, 0x27, 0x45, 0x87, 0x6F, 0xC1, 0x03, 0xEE, 0x26, 0x85, 0xAF, 0xB3, 0xEF,
  0x57, 0x01, 0x0D, 0xB0, 0x97, 0x20, 0x5A, 0x0E, 0x01, 0x77, 0x77, 0x50, 0xCC, 0x82, 0xED, 0xA4,
  0x50, 0xCF, 0x90, 0xB0, 0x13, 0x0C, 0xA8, 0x27, 0x67, 0xAB, 0x0C, 0x30, 0xCA, 0x40, 0x20, 0xDA,
  0x08, 0x20, 0xCA, 0x50, 0x2B, 0x81, 0x10, 0xCA, 0x60, 0xAA, 0x81, 0x60, 0xCA, 0x60, 0x5A, 0x81,
  0xA0, 0xCA, 0x60, 0x2A, 0x81, 0xD0, 0xCA, 0x7B, 0x10, 0xCA, 0x70, 0xEA, 0x10, 0xCA, 0x70, 0xEA,
  0x01, 0x0C, 0xA7, 0x0E, 0xA1, 0x0C, 0xA7, 0xA8, 0x1E, 0x0C, 0xA6, 0x02, 0xA8, 0x1C, 0x0C, 0xA6,
  0x06, 0xA8, 0x19, 0x0C, 0xA6, 0x0B, 0xA8, 0x15, 0x0C, 0xA5, 0x04, 0xA0, 0xE2, 0x0C, 0xA4, 0x03,
  0x0E, 0xA0, 0x62, 0x0C, 0xA8, 0x27, 0x67, 0xBB, 0x0A, 0x30, 0xCF, 0x90, 0x94, 0x0C, 0xC8, 0x2E,
  0xD9, 0x35,
  // "ď" (U+010F)
  0x71, 0x02, 0xA8, 0x19, 0x09, 0xA0, 0x17, 0x10, 0x2A, 0x83, 0x90, 0xBF, 0xD7, 0x20, 0x2A, 0x83,
  0x90, 0xEF, 0x77, 0x20, 0x2A, 0x09, 0x01, 0xA0, 0x17, 0x20, 0x2A, 0x82, 0x93, 0xF9, 0x73, 0x02,
  0xA0, 0x97, 0x85, 0x1A, 0xEE, 0xB3, 0x2A, 0x09, 0x60, 0x10, 0xED, 0x05, 0xA0, 0x96, 0x0A, 0xA8,
  0x3D, 0x78, 0xEE, 0xA0, 0x95, 0x01, 0xA0, 0xE0, 0x12, 0x01, 0x0E, 0xA0, 0x95, 0x06, 0xA0, 0x74,
  0x08, 0xA0, 0x95, 0x09, 0xA0, 0x44, 0x05, 0xA0, 0x95, 0x0A, 0xA0, 0x24, 0x03, 0xA0, 0x95, 0x0B,
  0xA0, 0x14, 0x02, 0xA0, 0x95, 0x0B, 0xA0, 0x14, 0x02, 0xA0, 0x95, 0x0A, 0xA0, 0x24, 0x02, 0xA0,
  0x95, 0x09, 0xA0, 0x44, 0x04, 0xA0, 0x95, 0x06, 0xA0, 0x74, 0x08, 0xA0, 0x95, 0x02, 0xA0, 0xE0,
  0x12, 0x01, 0x0E, 0xA0, 0x96, 0x0B, 0xA8, 0x3D, 0x78, 0xEE, 0xA0, 0x96, 0x02, 0x0E, 0xD8, 0x24,
  0xDF, 0x97, 0x89, 0x02, 0xAE, 0xEB, 0x40, 0xBF, 0x95,
  // "Đ" (U+0110)
  0x20, 0xCC, 0x82, 0xED, 0xA4, 0x60, 0xCF, 0x90, 0xB5, 0x0C, 0xA8, 0x27, 0x67, 0xAB, 0x0C, 0x40,
  0xCA, 0x01, 0x30, 0x20, 0xDA, 0x08, 0x30, 0xCA, 0x01, 0x40, 0x2B, 0x01, 0x20, 0xCA, 0x01, 0x50,
  0xAA, 0x06, 0x20, 0xCA, 0x01, 0x50, 0x5A, 0x0A, 0x20, 0xCA, 0x01, 0x50, 0x2A, 0x0D, 0x20, 0xCA,
  0x01, 0x6A, 0x0E, 0x06, 0xF0, 0x33, 0x0E, 0xA0, 0x6F, 0x03, 0x30, 0xEA, 0x81, 0x36, 0xDA, 0x82,
  0x76, 0x61, 0x30, 0xEA, 0x20, 0xCA, 0x01, 0x6A, 0x0E, 0x20, 0xCA, 0x01, 0x50, 0x2A, 0x0C, 0x20,
  0xCA, 0x01, 0x50, 0x6A, 0x09, 0x20, 0xCA, 0x01, 0x50, 0xBA, 0x04, 0x20, 0xCA, 0x01, 0x40, 0x4A,
  0x0E, 0x30, 0xCA, 0x01, 0x30, 0x30, 0xEA, 0x06, 0x30, 0xCA, 0x82, 0x76, 0x7B, 0xB0, 0xA4, 0x0C,
  0xF9, 0x09, 0x50, 0xCC, 0x82, 0xED, 0x93, 0x40,
  // "đ" (U+0111)
  0x71, 0x02, 0xA0, 0x97, 0x30, 0x2A, 0x09, 0x70, 0xEF, 0x05, 0x50, 0xEF, 0x05, 0x50, 0xF6, 0x08,
  0xA8, 0x1B, 0x62, 0x71, 0x02, 0xA0, 0x94, 0x85, 0x1A, 0xEE, 0xB3, 0x2A, 0x09, 0x30, 0x10, 0xED,
  0x05, 0xA0, 0x93, 0x0A, 0xA8, 0x3D, 0x78, 0xEE, 0xA0, 0x92, 0x02, 0xA0, 0xE0, 0x12, 0x01, 0x0E,
  0xA0, 0x92, 0x06, 0xA0, 0x74, 0x08, 0xA0, 0x92, 0x09, 0xA0, 0x44, 0x05, 0xA0, 0x92, 0x0A, 0xA0,
  0x24, 0x03, 0xA0, 0x92, 0x0B, 0xA0, 0x14, 0x02, 0xA0, 0x92, 0x0B, 0xA0, 0x14, 0x02, 0xA0, 0x92,
  0x0A, 0xA0, 0x24, 0x02, 0xA0, 0x92, 0x09, 0xA0, 0x44, 0x04, 0xA0, 0x92, 0x06, 0xA0, 0x74, 0x08,
  0xA0, 0x92, 0x02, 0xA0, 0xE0, 0x12, 0x01, 0x0E, 0xA0, 0x93, 0x0A, 0xA8, 0x3D, 0x78, 0xDE, 0xA0,
  0x93, 0x01, 0x0E, 0xD8, 0x24, 0xEF, 0x94, 0x89, 0x01, 0xAE, 0xEB, 0x30, 0xBF, 0x92,
  // "Ē" (U+0112)
  0x10, 0x58, 0x02, 0x60, 0x42, 0x0D, 0xE0, 0xA2, 0x0D, 0xE0, 0xA7, 0x77, 0x0C, 0xF9, 0x05, 0x0C,
  0xF9, 0x05, 0x0C, 0xA0, 0x78, 0x01, 0x60, 0x20, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70,
  0xCA, 0x70, 0xCA, 0x70, 0xCF, 0x81, 0xE0, 0xCF, 0x81, 0xE0, 0xCA, 0x07, 0x80, 0x16, 0x10, 0xCA,
  0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x07, 0x80, 0x16, 0x02,
  0x0C, 0xF9, 0x05, 0x0C, 0xF9, 0x05,
  // "ē" (U+0113)
  0x20, 0x58, 0x02, 0x60, 0x44, 0x0D, 0xE0, 0xA4, 0x0D, 0xE0, 0xA7, 0x77, 0x71, 0x84, 0x7C, 0xEE,
  0xA3, 0x50, 0xBE, 0x05, 0x30, 0x8A, 0x85, 0xC7, 0x8E, 0xFE, 0x12, 0x81, 0xEF, 0xC3, 0x03, 0xA8,
  0x18, 0x05, 0xA0, 0x44, 0x83, 0xCF, 0xC0, 0x8A, 0x01, 0x48, 0x39, 0xFE, 0x0A, 0xFB, 0x10, 0xBF,
  0xB0, 0x10, 0xBA, 0x80, 0x46, 0x10, 0xAA, 0x01, 0x71, 0x08, 0xA0, 0x37, 0x10, 0x5A, 0x08, 0x72,
  0x82, 0xEF, 0xE3, 0x40, 0x10, 0x22, 0x07, 0xB8, 0x49, 0x77, 0xBF, 0x63, 0x0A, 0xF0, 0x64, 0x85,
  0x5B, 0xEF, 0xEB, 0x62,
  // "Ĕ" (U+0114)
  0x10, 0xC0, 0xE4, 0x0E, 0x0D, 0x28, 0x69, 0xFC, 0x77, 0xCF, 0xA2, 0x02, 0xD0, 0xE0, 0x23, 0x84,
  0x3B, 0xEE, 0xB3, 0x77, 0x71, 0x0C, 0xF9, 0x05, 0x0C, 0xF9, 0x05, 0x0C, 0xA0, 0x78, 0x01, 0x60,
  0x20, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCF, 0x81, 0xE0,
  0xCF, 0x81, 0xE0, 0xCA, 0x07, 0x80, 0x16, 0x10, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70,
  0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x07, 0x80, 0x16, 0x02, 0x0C, 0xF9, 0x05, 0x0C, 0xF9, 0x05,
  // "ĕ" (U+0115)
  0x20, 0xC0, 0xE4, 0x0E, 0x0D, 0x48, 0x69, 0xFC, 0x77, 0xCF, 0xA4, 0x02, 0xD0, 0xE0, 0x25, 0x84,
  0x3B, 0xEE, 0xB3, 0x77, 0x77, 0x28, 0x47, 0xCE, 0xEA, 0x35, 0x0B, 0xE0, 0x53, 0x08, 0xA8, 0x5C,
  0x78, 0xEF, 0xE1, 0x28, 0x1E, 0xFC, 0x30, 0x3A, 0x81, 0x80, 0x5A, 0x04, 0x48, 0x3C, 0xFC, 0x08,
  0xA0, 0x14, 0x83, 0x9F, 0xE0, 0xAF, 0xB1, 0x0B, 0xFB, 0x01, 0x0B, 0xA8, 0x04, 0x61, 0x0A, 0xA0,
  0x17, 0x10, 0x8A, 0x03, 0x71, 0x05, 0xA0, 0x87, 0x28, 0x2E, 0xFE, 0x34, 0x01, 0x02, 0x20, 0x7B,
  0x84, 0x97, 0x7B, 0xF6, 0x30, 0xAF, 0x06, 0x48, 0x55, 0xBE, 0xFE, 0xB6, 0x20,
  // "Ė" (U+0116)
  0x38, 0x15, 0xEB, 0x70, 0xCA, 0x03, 0x60, 0xCA, 0x02, 0x68, 0x15, 0xEA, 0x77, 0x73, 0x0C, 0xF9,
  0x05, 0x0C, 0xF9, 0x05, 0x0C, 0xA0, 0x78, 0x01, 0x60, 0x20, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70,
  0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCF, 0x81, 0xE0, 0xCF, 0x81, 0xE0, 0xCA, 0x07, 0x80, 0x16,
  0x10, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x07, 0x80,
  0x16, 0x02, 0x0C, 0xF9, 0x05, 0x0C, 0xF9, 0x05,
  // "ė" (U+0117)
  0x48, 0x15, 0xEB, 0x72, 0x0C, 0xA0, 0x37, 0x10, 0xCA, 0x02, 0x71, 0x81, 0x5E, 0xA7, 0x77, 0x74,
  0x84, 0x7C, 0xEE, 0xA3, 0x50, 0xBE, 0x05, 0x30, 0x8A, 0x85, 0xC7, 0x8E, 0xFE, 0x12, 0x81, 0xEF,
  0xC3, 0x03, 0xA8, 0x18, 0x05, 0xA0, 0x44, 0x83, 0xCF, 0xC0, 0x8A, 0x01, 0x48, 0x39, 0xFE, 0x0A,
  0xFB, 0x10, 0xBF, 0xB0, 0x10, 0xBA, 0x80, 0x46, 0x10, 0xAA, 0x01, 0x71, 0x08, 0xA0, 0x37, 0x10,
  0x5A, 0x08, 0x72, 0x82, 0xEF, 0xE3, 0x40, 0x10, 0x22, 0x07, 0xB8, 0x49, 0x77, 0xBF, 0x63, 0x0A,
  0xF0, 0x64, 0x85, 0x5B, 0xEF, 0xEB, 0x62,
  // "Ę" (U+0118)
  0x0C, 0xF9, 0x05, 0x0C, 0xF9, 0x05, 0x0C, 0xA0, 0x78, 0x01, 0x60, 0x20, 0xCA, 0x70, 0xCA, 0x70,
  0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCF, 0x81, 0xE0, 0xCF, 0x81, 0xE0, 0xCA, 0x07,
  0x80, 0x16, 0x10, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA, 0x70, 0xCA,
  0x07, 0x80, 0x16, 0x02, 0x0C, 0xF9, 0x05, 0x0C, 0xF9, 0x05, 0x68, 0x15, 0xF8, 0x68, 0x12, 0xEC,
  0x78, 0x18, 0xF6, 0x78, 0x1C, 0xF5, 0x78, 0x3C, 0xFD, 0x74, 0x50, 0x8B, 0x09, 0x68, 0x29, 0xEE,
  0x70,
  // "ę" (U+0119)
  0x38, 0x47, 0xCE, 0xDA, 0x25, 0x0B, 0xD0, 0xE0, 0x33, 0x08, 0xA8, 0x1D, 0x79, 0xA0, 0xD3, 0x82,
  0xEF, 0xD1, 0x20, 0x6A, 0x81, 0x50, 0x5A, 0x07, 0x48, 0x3E, 0xFA, 0x08, 0xA0, 0x34, 0x83, 0xAF,
  0xD0, 0xAA, 0x01, 0x40, 0x9A, 0x10, 0xBF, 0xB1, 0x0B, 0xFB, 0x01, 0x0A, 0xA0, 0x78, 0x03, 0x61,
  0x08, 0xA0, 0x17, 0x10, 0x5A, 0x05, 0x72, 0x82, 0xEF, 0xD1, 0x50, 0x12, 0x07, 0xA8, 0x5E, 0x97,
  0x8A, 0xE6, 0x30, 0xAF, 0x06, 0x48, 0x15, 0xBE, 0xB0, 0xD0, 0x17, 0x18, 0x1B, 0xF2, 0x71, 0x81,
  0x7F, 0x87, 0x28, 0x1E, 0xF2, 0x71, 0x02, 0xA0, 0x17, 0x10, 0x1A, 0x81, 0xA7, 0x37, 0x0C, 0xB0,
  0x57, 0x83, 0x2B, 0xEE, 0x31,
  // "Ě" (U+011A)
  0x06, 0x07, 0x48, 0x93, 0x27, 0x40, 0x6F, 0xC1, 0x03, 0xEE, 0x22, 0x85, 0xAF, 0xB3, 0xEF, 0x53,
  0x01, 0x0D, 0xB0, 0x95, 0x05, 0xA0, 0xE0, 0x17, 0x77, 0x20, 0xCF, 0x90, 0x50, 0xCF, 0x90, 0x50,
  0xCA, 0x07, 0x80, 0x16, 0x02, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C,
  0xA7, 0x0C, 0xF8, 0x1E, 0x0C, 0xF8, 0x1E, 0x0C, 0xA0, 0x78, 0x01, 0x61, 0x0C, 0xA7, 0x0C, 0xA7,
  0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA0, 0x78, 0x01, 0x60, 0x20, 0xCF, 0x90,
  0x50, 0xCF, 0x90, 0x50,
  // "ě" (U+011B)
  0x10, 0x60, 0x74, 0x81, 0x27, 0x43, 0x87, 0x6F, 0xC1, 0x03, 0xEE, 0x24, 0x85, 0xAF, 0xB3, 0xEF,
  0x55, 0x01, 0x0D, 0xB0, 0x97, 0x05, 0xA0, 0xE0, 0x17, 0x77, 0x73, 0x84, 0x7C, 0xEE, 0xA3, 0x50,
  0xBE, 0x05, 0x30, 0x8A, 0x85, 0xC7, 0x8E, 0xFE, 0x12, 0x81, 0xEF, 0xC3, 0x03, 0xA8, 0x18, 0x05,
  0xA0, 0x44, 0x83, 0xCF, 0xC0, 0x8A, 0x01, 0x48, 0x39, 0xFE, 0x0A, 0xFB, 0x10, 0xBF, 0xB0, 0x10,
  0xBA, 0x80, 0x46, 0x10, 0xAA, 0x01, 0x71, 0x08, 0xA0, 0x37, 0x10, 0x5A, 0x08, 0x72, 0x82, 0xEF,
  0xE3, 0x40, 0x10, 0x22, 0x07, 0xB8, 0x49, 0x77, 0xBF, 0x63, 0x0A, 0xF0, 0x64, 0x85, 0x5B, 0xEF,
  0xEB, 0x62,
  // "Ĝ" (U+011C)
  0x68, 0x21, 0x77, 0x67, 0x40, 0x9B, 0x04, 0x72, 0x04, 0xA8, 0x1C, 0xFD, 0x71, 0x86, 0x1D, 0xF5,
  0x0B, 0xFA, 0x78, 0x1A, 0xF5, 0x38, 0x1A, 0xF6, 0x80, 0xC1, 0x08, 0x15, 0xAD, 0xA8, 0x1D, 0xA5,
  0x50, 0x10, 0xCF, 0x90, 0xD3, 0x01, 0x0D, 0xA8, 0x6E, 0xA7, 0x79, 0xEF, 0x83, 0x0C, 0xA0, 0xB0,
  0x15, 0x06, 0x02, 0x20, 0x5A, 0x0D, 0x01, 0x73, 0x0B, 0xA0, 0x57, 0x4A, 0x0E, 0x74, 0x04, 0xA0,
  0xB7, 0x40, 0x6A, 0x08, 0x74, 0x07, 0xA0, 0x74, 0x04, 0x80, 0x16, 0x01, 0x08, 0xA0, 0x64, 0x0A,
  0xD0, 0x40, 0x7A, 0x07, 0x40, 0xAD, 0x04, 0x06, 0xA0, 0x87, 0x08, 0xA0, 0x04, 0xA0, 0xB7, 0x08,
  0xA0, 0x40, 0x1A, 0x0E, 0x70, 0x8A, 0x81, 0x40, 0xCA, 0x04, 0x60, 0x8A, 0x81, 0x40, 0x7A, 0x0C,
  0x60, 0x8A, 0x04, 0x20, 0xDA, 0x09, 0x50, 0x8A, 0x04, 0x20, 0x4B, 0x84, 0xD8, 0x77, 0x9E, 0xA0,
  0x43, 0x04, 0x0E, 0xFA, 0x04, 0x48, 0x90, 0x17, 0xCE, 0xFE, 0xCB, 0x73, 0x10,
  // "ĝ" (U+011D)
  0x48, 0x21, 0x77, 0x67, 0x10, 0x9B, 0x04, 0x60, 0x4A, 0x81, 0xCF, 0xD5, 0x86, 0x1D, 0xF5, 0x0B,
  0xFA, 0x48, 0x1A, 0xF5, 0x38, 0x1A, 0xF6, 0x77, 0x76, 0x89, 0x31, 0x9E, 0xEB, 0x40, 0xCF, 0x90,
  0x1D, 0xD8, 0x44, 0xEF, 0x90, 0xAA, 0x83, 0xD7, 0x8E, 0xEA, 0x09, 0x01, 0xA0, 0xE0, 0x12, 0x01,
  0x0E, 0xA0, 0x90, 0x6A, 0x07, 0x40, 0x8A, 0x09, 0x08, 0xA0, 0x44, 0x05, 0xA0, 0x90, 0xAA, 0x02,
  0x40, 0x3A, 0x09, 0x0B, 0xA0, 0x14, 0x02, 0xA0, 0x90, 0xBA, 0x01, 0x40, 0x2A, 0x09, 0x0A, 0xA0,
  0x14, 0x02, 0xA0, 0x09, 0xA0, 0x34, 0x04, 0xA0, 0x90, 0x6A, 0x07, 0x40, 0x8A, 0x09, 0x02, 0xA0,
  0xD0, 0x12, 0x01, 0x0E, 0xA8, 0x19, 0x0B, 0xA8, 0x3D, 0x78, 0xDE, 0xA8, 0x29, 0x02, 0xEC, 0x0E,
  0x05, 0xA0, 0x92, 0x85, 0x2A, 0xEE, 0xB3, 0x2A, 0x08, 0x71, 0x02, 0xA0, 0x87, 0x10, 0x3A, 0x07,
  0x71, 0x07, 0xA8, 0x14, 0x05, 0x58, 0x22, 0xEF, 0xE2, 0x84, 0xEE, 0xA7, 0x79, 0xB0, 0x72, 0x0E,
  0xF0, 0xA3, 0x86, 0x39, 0xCE, 0xFE, 0xB5, 0x30,
  // "Ğ" (U+011E)
  0x40, 0xC0, 0xE4, 0x0E, 0x0D, 0x78, 0x69, 0xFC, 0x77, 0xCF, 0xA7, 0x02, 0xD0, 0xE0, 0x27, 0x18,
  0x43, 0xBE, 0xEB, 0x38, 0x0C, 0x30, 0x81, 0x5A, 0xDA, 0x81, 0xDA, 0x55, 0x01, 0x0C, 0xF9, 0x0D,
  0x30, 0x10, 0xDA, 0x86, 0xEA, 0x77, 0x9E, 0xF8, 0x30, 0xCA, 0x0B, 0x01, 0x50, 0x60, 0x22, 0x05,
  0xA0, 0xD0, 0x17, 0x30, 0xBA, 0x05, 0x74, 0xA0, 0xE7, 0x40, 0x4A, 0x0B, 0x74, 0x06, 0xA0, 0x87,
  0x40, 0x7A, 0x07, 0x40, 0x48, 0x01, 0x60, 0x10, 0x8A, 0x06, 0x40, 0xAD, 0x04, 0x07, 0xA0, 0x74,
  0x0A, 0xD0, 0x40, 0x6A, 0x08, 0x70, 0x8A, 0x00, 0x4A, 0x0B, 0x70, 0x8A, 0x04, 0x01, 0xA0, 0xE7,
  0x08, 0xA8, 0x14, 0x0C, 0xA0, 0x46, 0x08, 0xA8, 0x14, 0x07, 0xA0, 0xC6, 0x08, 0xA0, 0x42, 0x0D,
  0xA0, 0x95, 0x08, 0xA0, 0x42, 0x04, 0xB8, 0x4D, 0x87, 0x79, 0xEA, 0x04, 0x30, 0x40, 0xEF, 0xA0,
  0x44, 0x89, 0x01, 0x7C, 0xEF, 0xEC, 0xB7, 0x31,
  // "ğ" (U+011F)
  0x20, 0xC0, 0xE4, 0x0E, 0x0D, 0x48, 0x69, 0xFC, 0x77, 0xCF, 0xA4, 0x02, 0xD0, 0xE0, 0x25, 0x84,
  0x3B, 0xEE, 0xB3, 0x77, 0x77, 0x18, 0x93, 0x19, 0xEE, 0xB4, 0x0C, 0xF9, 0x01, 0xDD, 0x84, 0x4E,
  0xF9, 0x0A, 0xA8, 0x3D, 0x78, 0xEE, 0xA0, 0x90, 0x1A, 0x0E, 0x01, 0x20, 0x10, 0xEA, 0x09, 0x06,
  0xA0, 0x74, 0x08, 0xA0, 0x90, 0x8A, 0x04, 0x40, 0x5A, 0x09, 0x0A, 0xA0, 0x24, 0x03, 0xA0, 0x90,
  0xBA, 0x01, 0x40, 0x2A, 0x09, 0x0B, 0xA0, 0x14, 0x02, 0xA0, 0x90, 0xAA, 0x01, 0x40, 0x2A, 0x00,
  0x9A, 0x03, 0x40, 0x4A, 0x09, 0x06, 0xA0, 0x74, 0x08, 0xA0, 0x90, 0x2A, 0x0D, 0x01, 0x20, 0x10,
  0xEA, 0x81, 0x90, 0xBA, 0x83, 0xD7, 0x8D, 0xEA, 0x82, 0x90, 0x2E, 0xC0, 0xE0, 0x5A, 0x09, 0x28,
  0x52, 0xAE, 0xEB, 0x32, 0xA0, 0x87, 0x10, 0x2A, 0x08, 0x71, 0x03, 0xA0, 0x77, 0x10, 0x7A, 0x81,
  0x40, 0x55, 0x82, 0x2E, 0xFE, 0x28, 0x4E, 0xEA, 0x77, 0x9B, 0x07, 0x20, 0xEF, 0x0A, 0x38, 0x63,
  0x9C, 0xEF, 0xEB, 0x53,
  // "Ġ" (U+0120)
  0x78, 0x15, 0xEB, 0x75, 0x0C, 0xA0, 0x37, 0x40, 0xCA, 0x02, 0x74, 0x81, 0x5E, 0xA8, 0x0C, 0x40,
  0x81, 0x5A, 0xDA, 0x81, 0xDA, 0x55, 0x01, 0x0C, 0xF9, 0x0D, 0x30, 0x10, 0xDA, 0x86, 0xEA, 0x77,
  0x9E, 0xF8, 0x30, 0xCA, 0x0B, 0x01, 0x50, 0x60, 0x22, 0x05, 0xA0, 0xD0, 0x17, 0x30, 0xBA, 0x05,
  0x74, 0xA0, 0xE7, 0x40, 0x4A, 0x0B, 0x74, 0x06, 0xA0, 0x87, 0x40, 0x7A, 0x07, 0x40, 0x48, 0x01,
  0x60, 0x10, 0x8A, 0x06, 0x40, 0xAD, 0x04, 0x07, 0xA0, 0x74, 0x0A, 0xD0, 0x40, 0x6A, 0x08, 0x70,
  0x8A, 0x00, 0x4A, 0x0B, 0x70, 0x8A, 0x04, 0x01, 0xA0, 0xE7, 0x08, 0xA8, 0x14, 0x0C, 0xA0, 0x46,
  0x08, 0xA8, 0x14, 0x07, 0xA0, 0xC6, 0x08, 0xA0, 0x42, 0x0D, 0xA0, 0x95, 0x08, 0xA0, 0x42, 0x04,
  0xB8, 0x4D, 0x87, 0x79, 0xEA, 0x04, 0x30, 0x40, 0xEF, 0xA0, 0x44, 0x89, 0x01, 0x7C, 0xEF, 0xEC,
  0xB7, 0x31,
  // "ġ" (U+0121)
  0x58, 0x15, 0xEB, 0x72, 0x0C, 0xA0, 0x37, 0x10, 0xCA, 0x02, 0x71, 0x81, 0x5E, 0xA7, 0x77, 0x72,
  0x89, 0x31, 0x9E, 0xEB, 0x40, 0xCF, 0x90, 0x1D, 0xD8, 0x44, 0xEF, 0x90, 0xAA, 0x83, 0xD7, 0x8E,
  0xEA, 0x09, 0x01, 0xA0, 0xE0, 0x12, 0x01, 0x0E, 0xA0, 0x90, 0x6A, 0x07, 0x40, 0x8A, 0x09, 0x08,
  0xA0, 0x44, 0x05, 0xA0, 0x90, 0xAA, 0x02, 0x40, 0x3A, 0x09, 0x0B, 0xA0, 0x14, 0x02, 0xA0, 0x90,
  0xBA, 0x01, 0x40, 0x2A, 0x09, 0x0A, 0xA0, 0x14, 0x02, 0xA0, 0x09, 0xA0, 0x34, 0x04, 0xA0, 0x90,
  0x6A, 0x07, 0x40, 0x8A, 0x09, 0x02, 0xA0, 0xD0, 0x12, 0x01, 0x0E, 0xA8, 0x19, 0x0B, 0xA8, 0x3D,
  0x78, 0xDE, 0xA8, 0x29, 0x02, 0xEC, 0x0E, 0x05, 0xA0, 0x92, 0x85, 0x2A, 0xEE, 0xB3, 0x2A, 0x08,
  0x71, 0x02, 0xA0, 0x87, 0x10, 0x3A, 0x07, 0x71, 0x07, 0xA8, 0x14, 0x05, 0x58, 0x22, 0xEF, 0xE2,
  0x84, 0xEE, 0xA7, 0x79, 0xB0, 0x72, 0x0E, 0xF0, 0xA3, 0x86, 0x39, 0xCE, 0xFE, 0xB5, 0x30,
  // "Ģ" (U+0122)
  0x58, 0x15, 0xAD, 0xA8, 0x1D, 0xA5, 0x50, 0x10, 0xCF, 0x90, 0xD3, 0x01, 0x0D, 0xA8, 0x6E, 0xA7,
  0x79, 0xEF, 0x83, 0x0C, 0xA0, 0xB0, 0x15, 0x06, 0x02, 0x20, 0x5A, 0x0D, 0x01, 0x73, 0x0B, 0xA0,
  0x57, 0x4A, 0x0E, 0x74, 0x04, 0xA0, 0xB7, 0x40, 0x6A, 0x08, 0x74, 0x07, 0xA0, 0x74, 0x04, 0x80,
  0x16, 0x01, 0x08, 0xA0, 0x64, 0x0A, 0xD0, 0x40, 0x7A, 0x07, 0x40, 0xAD, 0x04, 0x06, 0xA0, 0x87,
  0x08, 0xA0, 0x04, 0xA0, 0xB7, 0x08, 0xA0, 0x40, 0x1A, 0x0E, 0x70, 0x8A, 0x81, 0x40, 0xCA, 0x04,
  0x60, 0x8A, 0x81, 0x40, 0x7A, 0x0C, 0x60, 0x8A, 0x04, 0x20, 0xDA, 0x09, 0x50, 0x8A, 0x04, 0x20,
  0x4B, 0x84, 0xD8, 0x77, 0x9E, 0xA0, 0x43, 0x04, 0x0E, 0xFA, 0x04, 0x48, 0x90, 0x17, 0xCE, 0xFE,
  0xCB, 0x73, 0x77, 0x72, 0x09, 0xA0, 0x17, 0x48, 0x1C, 0xFC, 0x75, 0x81, 0xEF, 0x67, 0x48, 0x12,
  0xFE, 0x75, 0x81, 0x6F, 0x66,
  // "ģ" (U+0123)
  0x68, 0x1A, 0xF3, 0x71, 0x81, 0x3F, 0xE7, 0x28, 0x1B, 0xFB, 0x71, 0x01, 0xA0, 0x77, 0x10, 0x5A,
  0x05, 0x77, 0x48, 0x93, 0x19, 0xEE, 0xB4, 0x0C, 0xF9, 0x01, 0xDD, 0x84, 0x4E, 0xF9, 0x0A, 0xA8,
  0x3D, 0x78, 0xEE, 0xA0, 0x90, 0x1A, 0x0E, 0x01, 0x20, 0x10, 0xEA, 0x09, 0x06, 0xA0, 0x74, 0x08,
  0xA0, 0x90, 0x8A, 0x04, 0x40, 0x5A, 0x09, 0x0A, 0xA0, 0x24, 0x03, 0xA0, 0x90, 0xBA, 0x01, 0x40,
  0x2A, 0x09, 0x0B, 0xA0, 0x14, 0x02, 0xA0, 0x90, 0xAA, 0x01, 0x40, 0x2A, 0x00, 0x9A, 0x03, 0x40,
  0x4A, 0x09, 0x06, 0xA0, 0x74, 0x08, 0xA0, 0x90, 0x2A, 0x0D, 0x01, 0x20, 0x10, 0xEA, 0x81, 0x90,
  0xBA, 0x83, 0xD7, 0x8D, 0xEA, 0x82, 0x90, 0x2E, 0xC0, 0xE0, 0x5A, 0x09, 0x28, 0x52, 0xAE, 0xEB,
  0x32, 0xA0, 0x87, 0x10, 0x2A, 0x08, 0x71, 0x03, 0xA0, 0x77, 0x10, 0x7A, 0x81, 0x40, 0x55, 0x82,
  0x2E, 0xFE, 0x28, 0x4E, 0xEA, 0x77, 0x9B, 0x07, 0x20, 0xEF, 0x0A, 0x38, 0x63, 0x9C, 0xEF, 0xEB,
  0x53,
  // "Ĥ" (U+0124)
  0x48, 0x21, 0x77, 0x67, 0x20, 0x9B, 0x04, 0x70, 0x4A, 0x81, 0xCF, 0xD6, 0x86, 0x1D, 0xF5, 0x0B,
  0xFA, 0x58, 0x1A, 0xF5, 0x38, 0x1A, 0xF6, 0x77, 0x77, 0x0C, 0xA7, 0xA0, 0xD0, 0xCA, 0x7A, 0x0D,
  0x0C, 0xA7, 0xA0, 0xD0, 0xCA, 0x7A, 0x0D, 0x0C, 0xA7, 0xA0, 0xD0, 0xCA, 0x7A, 0x0D, 0x0C, 0xA7,
  0xA0, 0xD0, 0xCA, 0x7A, 0x0D, 0x0C, 0xA7, 0xA0, 0xD0, 0xCF, 0xC0, 0xD0, 0xCF, 0xC0, 0xD0, 0xCA,
  0x07, 0x80, 0x16, 0x07, 0xA0, 0xD0, 0xCA, 0x7A, 0x0D, 0x0C, 0xA7, 0xA0, 0xD0, 0xCA, 0x7A, 0x0D,
  0x0C, 0xA7, 0xA0, 0xD0, 0xCA, 0x7A, 0x0D, 0x0C, 0xA7, 0xA0, 0xD0, 0xCA, 0x7A, 0x0D, 0x0C, 0xA7,
  0xA0, 0xD0, 0xCA, 0x7A, 0x0D,
  // "ĥ" (U+0125)
  0x28, 0x21, 0x77, 0x67, 0x30, 0x9B, 0x04, 0x71, 0x04, 0xA8, 0x1C, 0xFD, 0x78, 0x61, 0xDF, 0x50,
  0xBF, 0xA6, 0x81, 0xAF, 0x53, 0x81, 0xAF, 0x67, 0x77, 0x77, 0x01, 0xA0, 0xA7, 0x30, 0x1A, 0x0A,
  0x73, 0x01, 0xA0, 0xA7, 0x30, 0x1A, 0x0A, 0x73, 0x01, 0xA0, 0xA7, 0x30, 0x1A, 0x0A, 0x73, 0x01,
  0xA8, 0x59, 0x08, 0xDF, 0xD7, 0x40, 0x1A, 0x09, 0x0C, 0xD0, 0x93, 0x01, 0xA8, 0x3E, 0xFA, 0x7A,
  0xB0, 0x22, 0x01, 0xB0, 0x83, 0x09, 0xA0, 0x62, 0x01, 0xB0, 0x13, 0x03, 0xA0, 0x82, 0x01, 0xA0,
  0xD4, 0x02, 0xA0, 0x92, 0x01, 0xA0, 0xB4, 0x01, 0xA0, 0x92, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x92,
  0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x92, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x92, 0x01, 0xA0, 0xA4, 0x01,
  0xA0, 0x92, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x92, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x92, 0x01, 0xA0,
  0xA4, 0x01, 0xA0, 0x92, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x92, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90,
  // "Ħ" (U+0126)
  0x30, 0xDA, 0x7A, 0x0C, 0x50, 0xDA, 0x7A, 0x0C, 0x50, 0xDA, 0x7A, 0x0C, 0x38, 0x16, 0x6E, 0xA8,
  0x02, 0x60, 0x7A, 0x82, 0xD6, 0x61, 0xFF, 0xB0, 0x1F, 0xFB, 0x30, 0xDA, 0x7A, 0x0C, 0x50, 0xDA,
  0x7A, 0x0C, 0x50, 0xDA, 0x7A, 0x0C, 0x50, 0xDF, 0xC0, 0xC5, 0x0D, 0xFC, 0x0C, 0x50, 0xDA, 0x80,
  0x26, 0x07, 0xA0, 0xC5, 0x0D, 0xA7, 0xA0, 0xC5, 0x0D, 0xA7, 0xA0, 0xC5, 0x0D, 0xA7, 0xA0, 0xC5,
  0x0D, 0xA7, 0xA0, 0xC5, 0x0D, 0xA7, 0xA0, 0xC5, 0x0D, 0xA7, 0xA0, 0xC5, 0x0D, 0xA7, 0xA0, 0xC5,
  0x0D, 0xA7, 0xA0, 0xC5, 0x0D, 0xA7, 0xA0, 0xC2,
  // "ħ" (U+0127)
  0x10, 0x1A, 0x0A, 0x72, 0x01, 0xA0, 0xA7, 0x10, 0xDF, 0x07, 0x40, 0xDF, 0x07, 0x40, 0x50, 0x7A,
  0x83, 0xC6, 0x66, 0x35, 0x01, 0xA0, 0xA7, 0x20, 0x1A, 0x85, 0xA0, 0x8D, 0xFD, 0x73, 0x01, 0xA0,
  0x90, 0xBD, 0x08, 0x20, 0x1A, 0x83, 0xEF, 0xB7, 0xAB, 0x81, 0x10, 0x1B, 0x09, 0x30, 0x9A, 0x81,
  0x60, 0x1B, 0x01, 0x30, 0x4A, 0x81, 0x80, 0x1A, 0x0D, 0x40, 0x2A, 0x81, 0x90, 0x1A, 0x0B, 0x40,
  0x1A, 0x81, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x81, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x81, 0x90, 0x1A,
  0x0A, 0x40, 0x1A, 0x81, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x81, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x81,
  0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x81, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x81, 0x90, 0x1A, 0x0A, 0x40,
  0x1A, 0x81, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09,
  // "Ĩ" (U+0128)
  0x18, 0x27, 0xED, 0x62, 0x82, 0x7F, 0x34, 0xC8, 0x7C, 0x7E, 0xF0, 0x9F, 0x99, 0xC8, 0x2A, 0x0C,
  0xD2, 0x83, 0x2B, 0xEC, 0x17, 0x77, 0x1E, 0x0C, 0x3E, 0x0C, 0x30, 0x10, 0x7A, 0x0E, 0x05, 0x50,
  0x1A, 0x0C, 0x60, 0x1A, 0x0C, 0x60, 0x1A, 0x0C, 0x60, 0x1A, 0x0C, 0x60, 0x1A, 0x0C, 0x60, 0x1A,
  0x0C, 0x60, 0x1A, 0x0C, 0x60, 0x1A, 0x0C, 0x60, 0x1A, 0x0C, 0x60, 0x1A, 0x0C, 0x60, 0x1A, 0x0C,
  0x60, 0x1A, 0x0C, 0x60, 0x1A, 0x0C, 0x60, 0x1A, 0x0C, 0x60, 0x1A, 0x0C, 0x60, 0x3A, 0x0D, 0x01,
  0x40, 0xDD, 0x0A, 0x3E, 0x0C, 0x20,
  // "ĩ" (U+0129)
  0x18, 0x27, 0xED, 0x62, 0x82, 0x7F, 0x34, 0xC8, 0x7C, 0x7E, 0xF0, 0x9F, 0x99, 0xC8, 0x2A, 0x0C,
  0xD2, 0x83, 0x2B, 0xEC, 0x17, 0x77, 0x20, 0x1A, 0x0A, 0x60, 0x1A, 0x0A, 0x60, 0x1A, 0x0A, 0x60,
  0x1A, 0x0A, 0x60, 0x1A, 0x0A, 0x60, 0x1A, 0x0A, 0x60, 0x1A, 0x0A, 0x60, 0x1A, 0x0A, 0x60, 0x1A,
  0x0A, 0x60, 0x1A, 0x0A, 0x60, 0x1A, 0x0A, 0x60, 0x1A, 0x0A, 0x60, 0x1A, 0x0A, 0x60, 0x1A, 0x0A,
  0x60, 0x1A, 0x0A, 0x60, 0x1A, 0x0A, 0x40,
  // "Ī" (U+012A)
  0x05, 0x80, 0x26, 0x04, 0x0D, 0xE0, 0xA0, 0xDE, 0x0A, 0x77, 0x2E, 0x0C, 0x1E, 0x82, 0xC0, 0x17,
  0xA0, 0xE0, 0x53, 0x01, 0xA0, 0xC4, 0x01, 0xA0, 0xC4, 0x01, 0xA0, 0xC4, 0x01, 0xA0, 0xC4, 0x01,
  0xA0, 0xC4, 0x01, 0xA0, 0xC4, 0x01, 0xA0, 0xC4, 0x01, 0xA0, 0xC4, 0x01, 0xA0, 0xC4, 0x01, 0xA0,
  0xC4, 0x01, 0xA0, 0xC4, 0x01, 0xA0, 0xC4, 0x01, 0xA0, 0xC4, 0x01, 0xA0, 0xC4, 0x01, 0xA0, 0xC4,
  0x03, 0xA0, 0xD0, 0x12, 0x0D, 0xD0, 0xA1, 0xE0, 0xC1,
  // "ī" (U+012B)
  0x05, 0x80, 0x26, 0x04, 0x0D, 0xE0, 0xA0, 0xDE, 0x0A, 0x77, 0x40, 0x1A, 0x0A, 0x40, 0x1A, 0x0A,
  0x40, 0x1A, 0x0A, 0x40, 0x1A, 0x0A, 0x40, 0x1A, 0x0A, 0x40, 0x1A, 0x0A, 0x40, 0x1A, 0x0A, 0x40,
  0x1A, 0x0A, 0x40, 0x1A, 0x0A, 0x40, 0x1A, 0x0A, 0x40, 0x1A, 0x0A, 0x40, 0x1A, 0x0A, 0x40, 0x1A,
  0x0A, 0x40, 0x1A, 0x0A, 0x40, 0x1A, 0x0A, 0x40, 0x1A, 0x0A, 0x20,
  // "Ĭ" (U+012C)
  0x0C, 0x0E, 0x48, 0x91, 0xED, 0x9F, 0xC7, 0x7C, 0xFA, 0x2D, 0x87, 0xE2, 0x03, 0xBE, 0xEB, 0x37,
  0x74, 0xE0, 0xC1, 0xE8, 0x2C, 0x01, 0x7A, 0x0E, 0x05, 0x30, 0x1A, 0x0C, 0x40, 0x1A, 0x0C, 0x40,
  0x1A, 0x0C, 0x40, 0x1A, 0x0C, 0x40, 0x1A, 0x0C, 0x40, 0x1A, 0x0C, 0x40, 0x1A, 0x0C, 0x40, 0x1A,
  0x0C, 0x40, 0x1A, 0x0C, 0x40, 0x1A, 0x0C, 0x40, 0x1A, 0x0C, 0x40, 0x1A, 0x0C, 0x40, 0x1A, 0x0C,
  0x40, 0x1A, 0x0C, 0x40, 0x1A, 0x0C, 0x40, 0x3A, 0x0D, 0x01, 0x20, 0xDD, 0x0A, 0x1E, 0x0C,
  // "ĭ" (U+012D)
  0x0C, 0x0E, 0x48, 0x91, 0xED, 0x9F, 0xC7, 0x7C, 0xFA, 0x2D, 0x87, 0xE2, 0x03, 0xBE, 0xEB, 0x37,
  0x75, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0xA4,
  0x01, 0xA0, 0xA4, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0xA4, 0x01,
  0xA0, 0xA4, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0xA4, 0x01, 0xA0,
  0xA2,
  // "Į" (U+012E)
  0xE0, 0xCE, 0x81, 0xC1, 0x7A, 0x0E, 0x05, 0x20, 0x1A, 0x0C, 0x30, 0x1A, 0x0C, 0x30, 0x1A, 0x0C,
  0x30, 0x1A, 0x0C, 0x30, 0x1A, 0x0C, 0x30, 0x1A, 0x0C, 0x30, 0x1A, 0x0C, 0x30, 0x1A, 0x0C, 0x30,
  0x1A, 0x0C, 0x30, 0x1A, 0x0C, 0x30, 0x1A, 0x0C, 0x30, 0x1A, 0x0C, 0x30, 0x1A, 0x0C, 0x30, 0x1A,
  0x0C, 0x30, 0x1A, 0x0C, 0x30, 0x3A, 0x82, 0xD1, 0x0D, 0xD0, 0xAE, 0x0C, 0x38, 0x15, 0xF8, 0x38,
  0x12, 0xEC, 0x48, 0x18, 0xF6, 0x48, 0x1C, 0xF5, 0x48, 0x3C, 0xFD, 0x74, 0x20, 0x8B, 0x09, 0x38,
  0x29, 0xEE, 0x70,
  // "į" (U+012F)
  0x28, 0x3A, 0xE6, 0x02, 0xA8, 0x1C, 0x02, 0xA0, 0xC2, 0x81, 0xAE, 0x57, 0x40, 0x1A, 0x81, 0xA0,
  0x1A, 0x81, 0xA0, 0x1A, 0x81, 0xA0, 0x1A, 0x81, 0xA0, 0x1A, 0x81, 0xA0, 0x1A, 0x81, 0xA0, 0x1A,
  0x81, 0xA0, 0x1A, 0x81, 0xA0, 0x1A, 0x81, 0xA0, 0x1A, 0x81, 0xA0, 0x1A, 0x81, 0xA0, 0x1A, 0x81,
  0xA0, 0x1A, 0x81, 0xA0, 0x1A, 0x81, 0xA0, 0x1A, 0x81, 0xA0, 0x1A, 0x87, 0xA0, 0x5F, 0x80, 0x2E,
  0xC2, 0x81, 0x8F, 0x62, 0x81, 0xCF, 0x52, 0x84, 0xCF, 0xD7, 0x48, 0xB8, 0x49, 0x09, 0xEE, 0x70,
  // "İ" (U+0130)
  0x28, 0x15, 0xEB, 0x40, 0xCA, 0x03, 0x30, 0xCA, 0x02, 0x38, 0x15, 0xEA, 0x77, 0x2E, 0x0C, 0xE8,
  0x1C, 0x17, 0xA0, 0xE0, 0x52, 0x01, 0xA0, 0xC3, 0x01, 0xA0, 0xC3, 0x01, 0xA0, 0xC3, 0x01, 0xA0,
  0xC3, 0x01, 0xA0, 0xC3, 0x01, 0xA0, 0xC3, 0x01, 0xA0, 0xC3, 0x01, 0xA0, 0xC3, 0x01, 0xA0, 0xC3,
  0x01, 0xA0, 0xC3, 0x01, 0xA0, 0xC3, 0x01, 0xA0, 0xC3, 0x01, 0xA0, 0xC3, 0x01, 0xA0, 0xC3, 0x01,
  0xA0, 0xC3, 0x03, 0xA8, 0x2D, 0x10, 0xDD, 0x0A, 0xE0, 0xC0,
  // "ı" (U+0131)
  0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x01,
  0xA0, 0xA0, 0x1A, 0x0A, 0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x01, 0xA0,
  0xA0, 0x1A, 0x0A, 0x01, 0xA0, 0xA0, 0x1A, 0x0A,
  // "Ĳ" (U+0132)
  0xE0, 0xC2, 0x81, 0xEF, 0xEE, 0x0C, 0x28, 0x3E, 0xFE, 0x17, 0xA0, 0xE0, 0x53, 0x83, 0xEF, 0xE0,
  0x1A, 0x0C, 0x48, 0x3E, 0xFE, 0x01, 0xA0, 0xC4, 0x83, 0xEF, 0xE0, 0x1A, 0x0C, 0x48, 0x3E, 0xFE,
  0x01, 0xA0, 0xC4, 0x83, 0xEF, 0xE0, 0x1A, 0x0C, 0x48, 0x3E, 0xFE, 0x01, 0xA0, 0xC4, 0x83, 0xEF,
  0xE0, 0x1A, 0x0C, 0x48, 0x3E, 0xFE, 0x01, 0xA0, 0xC4, 0x83, 0xEF, 0xE0, 0x1A, 0x0C, 0x48, 0x3E,
  0xFE, 0x01, 0xA0, 0xC4, 0x83, 0xEF, 0xE0, 0x1A, 0x0C, 0x48, 0x3E, 0xFE, 0x01, 0xA0, 0xC4, 0x83,
  0xEF, 0xE0, 0x1A, 0x0C, 0x48, 0x3E, 0xFE, 0x01, 0xA0, 0xC4, 0x83, 0xEF, 0xE0, 0x1A, 0x0C, 0x48,
  0x3E, 0xFE, 0x03, 0xA0, 0xD0, 0x13, 0x82, 0xEF, 0xED, 0xD0, 0xA2, 0x81, 0xEF, 0xEE, 0x0C, 0x28,
  0x1E, 0xFE, 0x72, 0x81, 0xEF, 0xD7, 0x10, 0x2A, 0x0B, 0x58, 0x22, 0x01, 0xBA, 0x08, 0x50, 0xAC,
  0x0E, 0x01, 0x50, 0xAB, 0x0E, 0x04, 0x68, 0x22, 0x56, 0x43,
  // "ĳ" (U+0133)
  0x18, 0x1A, 0xE6, 0x48, 0x2A, 0xE6, 0x2A, 0x0C, 0x30, 0x2A, 0x0C, 0x02, 0xA0, 0xC3, 0x02, 0xA8,
  0x3C, 0x0A, 0xE5, 0x48, 0x1A, 0xE5, 0x77, 0x71, 0x01, 0xA0, 0xA3, 0x01, 0xA0, 0xA0, 0x1A, 0x0A,
  0x30, 0x1A, 0x0A, 0x01, 0xA0, 0xA3, 0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x01, 0xA0,
  0xA3, 0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x01, 0xA0, 0xA3, 0x01, 0xA0, 0xA0, 0x1A,
  0x0A, 0x30, 0x1A, 0x0A, 0x01, 0xA0, 0xA3, 0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x01,
  0xA0, 0xA3, 0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x01, 0xA0, 0xA3, 0x01, 0xA0, 0xA0,
  0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x01, 0xA0, 0xA3, 0x01, 0xA0, 0xA0, 0x1A, 0x0A, 0x30, 0x1A, 0x0A,
  0x70, 0x1A, 0x0A, 0x70, 0x1A, 0x0A, 0x70, 0x1A, 0x0A, 0x70, 0x4A, 0x08, 0x58, 0x17, 0x8D, 0xA0,
  0x55, 0x0C, 0xB0, 0xD6, 0x83, 0xAE, 0xEA, 0x21,
  // "Ĵ" (U+0134)
  0x38, 0x21, 0x77, 0x66, 0x09, 0xB0, 0x44, 0x04, 0xA8, 0x1C, 0xFD, 0x38, 0x61, 0xDF, 0x50, 0xBF,
  0xA2, 0x81, 0xAF, 0x53, 0x81, 0xAF, 0x67, 0x77, 0x38, 0x1E, 0xFE, 0x78, 0x1E, 0xFE, 0x78, 0x1E,
  0xFE, 0x78, 0x1E, 0xFE, 0x78, 0x1E, 0xFE, 0x78, 0x1E, 0xFE, 0x78, 0x1E, 0xFE, 0x78, 0x1E, 0xFE,
  0x78, 0x1E, 0xFE, 0x78, 0x1E, 0xFE, 0x78, 0x1E, 0xFE, 0x78, 0x1E, 0xFE, 0x78, 0x1E, 0xFE, 0x78,
  0x1E, 0xFE, 0x78, 0x1E, 0xFE, 0x78, 0x1E, 0xFE, 0x78, 0x1E, 0xFE, 0x78, 0x1E, 0xFE, 0x78, 0x1E,
  0xFE, 0x78, 0x1E, 0xFE, 0x78, 0x1E, 0xFE, 0x78, 0x1E, 0xFD, 0x60, 0x2A, 0x0B, 0x38, 0x22, 0x01,
  0xBA, 0x08, 0x30, 0xAC, 0x0E, 0x01, 0x30, 0xAB, 0x0E, 0x04, 0x48, 0x22, 0x56, 0x46,
  // "ĵ" (U+0135)
  0x28, 0x21, 0x77, 0x65, 0x09, 0xB0, 0x43, 0x04, 0xA8, 0x1C, 0xFD, 0x28, 0x92, 0x1D, 0xF5, 0x0B,
  0xFA, 0x0A, 0xF5, 0x38, 0x1A, 0xF6, 0x77, 0x60, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A,
  0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50,
  0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A,
  0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A,
  0x50, 0x4A, 0x08, 0x38, 0x17, 0x8D, 0xA0, 0x53, 0x0C, 0xB0, 0xD4, 0x83, 0xAE, 0xEA, 0x24,
  // "Ķ" (U+0136)
  0x0C, 0xA5, 0x02, 0xA8, 0x1E, 0x1C, 0xA5, 0x0A, 0xA8, 0x16, 0x0C, 0xA4, 0x04, 0xA0, 0xC2, 0x0C,
  0xA4, 0x0D, 0xA0, 0x32, 0x0C, 0xA3, 0x07, 0xA0, 0x93, 0x0C, 0xA2, 0x83, 0x1E, 0xFE, 0x13, 0x0C,
  0xA2, 0x0A, 0xA0, 0x54, 0x0C, 0xA1, 0x04, 0xA0, 0xB5, 0x0C, 0xA0, 0x10, 0xDA, 0x02, 0x50, 0xCA,
  0x08, 0xA0, 0xB6, 0x0C, 0xA0, 0xEB, 0x02, 0x50, 0xCB, 0x0E, 0xA0, 0xA5, 0x0C, 0xA8, 0x1B, 0x1E,
  0xA0, 0x24, 0x0C, 0xA8, 0x11, 0x07, 0xA0, 0xA4, 0x0C, 0xA3, 0x0E, 0xA0, 0x33, 0x0C, 0xA3, 0x07,
  0xA0, 0xB3, 0x0C, 0xA4, 0x0E, 0xA0, 0x32, 0x0C, 0xA4, 0x07, 0xA0, 0xB2, 0x0C, 0xA5, 0x0E, 0xA8,
  0x13, 0x0C, 0xA5, 0x06, 0xA8, 0x1B, 0x0C, 0xA6, 0x0E, 0xA0, 0x47, 0x73, 0x09, 0xA0, 0x17, 0x28,
  0x1C, 0xFC, 0x73, 0x81, 0xEF, 0x67, 0x28, 0x12, 0xFE, 0x73, 0x81, 0x6F, 0x67,
  // "ķ" (U+0137)
  0x01, 0xA0, 0xA7, 0x10, 0x1A, 0x0A, 0x71, 0x01, 0xA0, 0xA7, 0x10, 0x1A, 0x0A, 0x71, 0x01, 0xA0,
  0xA7, 0x10, 0x1A, 0x0A, 0x71, 0x01, 0xA0, 0xA4, 0x0C, 0xA0, 0x30, 0x1A, 0x0A, 0x30, 0x7A, 0x81,
  0x80, 0x1A, 0x0A, 0x20, 0x2A, 0x0C, 0x20, 0x1A, 0x0A, 0x20, 0xBA, 0x03, 0x20, 0x1A, 0x81, 0xA0,
  0x6A, 0x07, 0x30, 0x1A, 0x83, 0x91, 0xEF, 0xC4, 0x01, 0xA0, 0x90, 0xAA, 0x04, 0x40, 0x1A, 0x0C,
  0xB0, 0x94, 0x01, 0xC0, 0xEA, 0x02, 0x30, 0x1B, 0x07, 0x05, 0xA0, 0x93, 0x01, 0xA0, 0xB2, 0x0D,
  0xA0, 0x22, 0x01, 0xA0, 0xA2, 0x05, 0xA0, 0x92, 0x01, 0xA0, 0xA3, 0x0D, 0xA8, 0x12, 0x01, 0xA0,
  0xA3, 0x06, 0xA8, 0x19, 0x01, 0xA0, 0xA4, 0x0E, 0xA0, 0x20, 0x1A, 0x0A, 0x40, 0x7A, 0x09, 0x77,
  0x20, 0x9A, 0x01, 0x71, 0x81, 0xCF, 0xC7, 0x28, 0x1E, 0xF6, 0x71, 0x81, 0x2F, 0xE7, 0x28, 0x16,
  0xF6, 0x60,
  // "ĸ" (U+0138)
  0x01, 0xA0, 0xA4, 0x0C, 0xA0, 0x30, 0x1A, 0x0A, 0x30, 0x6A, 0x81, 0x90, 0x1A, 0x0A, 0x28, 0x21,
  0xEF, 0xD2, 0x01, 0xA0, 0xA2, 0x0B, 0xA0, 0x32, 0x01, 0xA8, 0x1A, 0x05, 0xA0, 0x93, 0x01, 0xA8,
  0x3A, 0x1E, 0xFD, 0x40, 0x1A, 0x00, 0x9A, 0x05, 0x40, 0x1A, 0x0C, 0xB0, 0xA4, 0x01, 0xC0, 0xEA,
  0x02, 0x30, 0x1B, 0x08, 0x04, 0xA0, 0xA3, 0x01, 0xA0, 0xC2, 0x0C, 0xA0, 0x22, 0x01, 0xA0, 0xA2,
  0x05, 0xA0, 0x92, 0x01, 0xA0, 0xA3, 0x0D, 0xA8, 0x12, 0x01, 0xA0, 0xA3, 0x06, 0xA8, 0x19, 0x01,
  0xA0, 0xA4, 0x0E, 0xA0, 0x20, 0x1A, 0x0A, 0x40, 0x7A, 0x09,
  // "Ĺ" (U+0139)
  0x28, 0x23, 0x77, 0x66, 0x0D, 0xA0, 0x65, 0x07, 0xA0, 0x75, 0x82, 0x2E, 0xF8, 0x68, 0x1B, 0xF8,
  0x77, 0x76, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7,
  0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7,
  0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA8, 0x02, 0x90, 0x30, 0xCF, 0x90, 0x60, 0xCF, 0x90,
  0x60,
  // "ĺ" (U+013A)
  0x38, 0x23, 0x77, 0x63, 0x0D, 0xA0, 0x62, 0x07, 0xA0, 0x72, 0x82, 0x2E, 0xF8, 0x38, 0x1B, 0xF8,
  0x77, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A,
  0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30,
  0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A,
  0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A, 0x30, 0x1A, 0x0A,
  0x30, 0x1A, 0x0A, 0x30,
  // "Ļ" (U+013B)
  0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7,
  0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7,
  0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA8, 0x02, 0x90, 0x30, 0xCF, 0x90, 0x60, 0xCF, 0x90, 0x67, 0x60,
  0x9A, 0x01, 0x68, 0x1C, 0xFC, 0x78, 0x1E, 0xF6, 0x68, 0x12, 0xFE, 0x78, 0x16, 0xF6, 0x50,
  // "ļ" (U+013C)
  0x01, 0xA8, 0x1A, 0x01, 0xA8, 0x1A, 0x01, 0xA8, 0x1A, 0x01, 0xA8, 0x1A, 0x01, 0xA8, 0x1A, 0x01,
  0xA8, 0x1A, 0x01, 0xA8, 0x1A, 0x01, 0xA8, 0x1A, 0x01, 0xA8, 0x1A, 0x01, 0xA8, 0x1A, 0x01, 0xA8,
  0x1A, 0x01, 0xA8, 0x1A, 0x01, 0xA8, 0x1A, 0x01, 0xA8, 0x1A, 0x01, 0xA8, 0x1A, 0x01, 0xA8, 0x1A,
  0x01, 0xA8, 0x1A, 0x01, 0xA8, 0x1A, 0x01, 0xA8, 0x1A, 0x01, 0xA8, 0x1A, 0x01, 0xA8, 0x1A, 0x01,
  0xA0, 0xA7, 0x09, 0xA8, 0x31, 0x0C, 0xFC, 0x28, 0x5E, 0xF6, 0x02, 0xFE, 0x28, 0x16, 0xF6, 0x20,
  // "Ľ" (U+013D)
  0x0C, 0xA4, 0x09, 0xA0, 0x10, 0xCA, 0x48, 0x3B, 0xFD, 0x0C, 0xA4, 0x83, 0xEF, 0x70, 0xCA, 0x30,
  0x1A, 0x81, 0x10, 0xCA, 0x38, 0x13, 0xF9, 0x20, 0xCA, 0x71, 0x0C, 0xA7, 0x10, 0xCA, 0x71, 0x0C,
  0xA7, 0x10, 0xCA, 0x71, 0x0C, 0xA7, 0x10, 0xCA, 0x71, 0x0C, 0xA7, 0x10, 0xCA, 0x71, 0x0C, 0xA7,
  0x10, 0xCA, 0x71, 0x0C, 0xA7, 0x10, 0xCA, 0x71, 0x0C, 0xA8, 0x02, 0x98, 0x13, 0x0C, 0xF9, 0x81,
  0x60, 0xCF, 0x90, 0x61,
  // "ľ" (U+013E)
  0x01, 0xA8, 0x1A, 0x09, 0xA0, 0x01, 0xA8, 0x5A, 0x0B, 0xFD, 0x01, 0xA8, 0x5A, 0x0E, 0xF7, 0x01,
  0xA0, 0xA0, 0x1A, 0x81, 0x10, 0x1A, 0x82, 0xA3, 0xF9, 0x20, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50,
  0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A,
  0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A,
  0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50,
  // "Ŀ" (U+013F)
  0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA3,
  0x83, 0x5E, 0xB0, 0xCA, 0x30, 0xCA, 0x03, 0x0C, 0xA3, 0x0C, 0xA0, 0x20, 0xCA, 0x38, 0x35, 0xEA,
  0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA7, 0x0C, 0xA8,
  0x02, 0x90, 0x30, 0xCF, 0x90, 0x60, 0xCF, 0x90, 0x60,
  // "ŀ" (U+0140)
  0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01,
  0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA8, 0x5A, 0x05, 0xEB, 0x01, 0xA8, 0x1A,
  0x0C, 0xA0, 0x30, 0x1A, 0x81, 0xA0, 0xCA, 0x02, 0x01, 0xA8, 0x5A, 0x05, 0xEA, 0x01, 0xA0, 0xA5,
  0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01,
  0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5,
  // "Ł" (U+0141)
  0x20, 0x9A, 0x03, 0x71, 0x09, 0xA0, 0x37, 0x10, 0x9A, 0x03, 0x71, 0x09, 0xA0, 0x37, 0x10, 0x9A,
  0x03, 0x71, 0x09, 0xA0, 0x37, 0x10, 0x9A, 0x03, 0x71, 0x09, 0xA8, 0x23, 0x05, 0x55, 0x09, 0xA8,
  0x34, 0xAF, 0xE1, 0x40, 0x9D, 0x0B, 0x01, 0x40, 0x9B, 0x0E, 0x06, 0x50, 0x40, 0xEA, 0x0B, 0x01,
  0x50, 0x9C, 0x03, 0x60, 0xAC, 0x03, 0x68, 0x11, 0x7A, 0xA0, 0x37, 0x10, 0x9A, 0x03, 0x71, 0x09,
  0xA0, 0x37, 0x10, 0x9A, 0x03, 0x71, 0x09, 0xA0, 0xA8, 0x01, 0x90, 0x52, 0x09, 0xF9, 0x09, 0x20,
  0x9F, 0x90, 0x90,
  // "ł" (U+0142)
  0x38, 0x1D, 0xFD, 0x68, 0x1D, 0xFD, 0x68, 0x1D, 0xFD, 0x68, 0x1D, 0xFD, 0x68, 0x1D, 0xFD, 0x68,
  0x1D, 0xFD, 0x68, 0x1D, 0xFD, 0x68, 0x1D, 0xFD, 0x68, 0x3D, 0xFD, 0x58, 0x40, 0xDC, 0x05, 0x30,
  0xDB, 0x0B, 0x01, 0x20, 0x6B, 0x07, 0x30, 0xAB, 0x0D, 0x30, 0x3C, 0x0D, 0x48, 0x37, 0x5D, 0xFD,
  0x68, 0x1D, 0xFD, 0x68, 0x1D, 0xFD, 0x68, 0x1D, 0xFD, 0x68, 0x1D, 0xFD, 0x68, 0x1D, 0xFD, 0x68,
  0x1D, 0xFD, 0x68, 0x1D, 0xFD, 0x30,
  // "Ń" (U+0143)
  0x78, 0x23, 0x77, 0x67, 0x30, 0xDA, 0x06, 0x72, 0x07, 0xA0, 0x77, 0x28, 0x22, 0xEF, 0x87, 0x38,
  0x1B, 0xF8, 0x77, 0x77, 0x60, 0xCA, 0x0C, 0x78, 0x2D, 0xFC, 0xCB, 0x04, 0x68, 0x2D, 0xFC, 0xCB,
  0x0B, 0x68, 0x2D, 0xFC, 0xCC, 0x03, 0x58, 0x4D, 0xFC, 0xCF, 0xEA, 0x0A, 0x58, 0x5D, 0xFC, 0xCF,
  0xAC, 0xA0, 0x24, 0x85, 0xDF, 0xCC, 0xFB, 0x5A, 0x09, 0x48, 0x6D, 0xFC, 0xCF, 0xC0, 0xDA, 0x01,
  0x38, 0x6D, 0xFC, 0xCF, 0xC0, 0x6A, 0x08, 0x38, 0x4D, 0xFC, 0xCF, 0xD2, 0x81, 0xEF, 0xE3, 0x84,
  0xDF, 0xCC, 0xFD, 0x20, 0x7A, 0x06, 0x28, 0x4D, 0xFC, 0xCF, 0xD2, 0x82, 0x1E, 0xFD, 0x28, 0x4D,
  0xFC, 0xCF, 0xD3, 0x09, 0xA8, 0x65, 0x0D, 0xFC, 0xCF, 0xD3, 0x02, 0xA8, 0x6C, 0x0C, 0xFC, 0xCF,
  0xD4, 0x0A, 0xA8, 0x54, 0xCF, 0xCC, 0xFD, 0x40, 0x2A, 0x85, 0xBB, 0xFC, 0xCF, 0xD5, 0x0B, 0xA8,
  0x4E, 0xFC, 0xCF, 0xD5, 0x03, 0xC8, 0x2C, 0xCF, 0xD6, 0x0C, 0xB8, 0x2C, 0xCF, 0xD6, 0x05, 0xB8,
  0x2C, 0xCF, 0xD7, 0x0D, 0xA0, 0xC0,
  // "ń" (U+0144)
  0x78, 0x23, 0x77, 0x67, 0x10, 0xDA, 0x06, 0x70, 0x7A, 0x07, 0x78, 0x22, 0xEF, 0x87, 0x18, 0x1B,
  0xF8, 0x77, 0x77, 0x01, 0xA8, 0x52, 0x08, 0xDF, 0xD7, 0x20, 0x1A, 0x05, 0x0C, 0xD8, 0x18, 0x01,
  0xA8, 0x3E, 0xFA, 0x7A, 0xB0, 0x20, 0x1B, 0x08, 0x30, 0x9A, 0x06, 0x01, 0xB0, 0x13, 0x04, 0xA0,
  0x80, 0x1A, 0x0D, 0x40, 0x2A, 0x09, 0x01, 0xA0, 0xB4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A,
  0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01,
  0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40,
  0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09,
  // "Ņ" (U+0145)
  0x0C, 0xA0, 0xC7, 0x82, 0xDF, 0xCC, 0xB0, 0x46, 0x82, 0xDF, 0xCC, 0xB0, 0xB6, 0x82, 0xDF, 0xCC,
  0xC0, 0x35, 0x84, 0xDF, 0xCC, 0xFE, 0xA0, 0xA5, 0x85, 0xDF, 0xCC, 0xFA, 0xCA, 0x02, 0x48, 0x5D,
  0xFC, 0xCF, 0xB5, 0xA0, 0x94, 0x86, 0xDF, 0xCC, 0xFC, 0x0D, 0xA0, 0x13, 0x86, 0xDF, 0xCC, 0xFC,
  0x06, 0xA0, 0x83, 0x84, 0xDF, 0xCC, 0xFD, 0x28, 0x1E, 0xFE, 0x38, 0x4D, 0xFC, 0xCF, 0xD2, 0x07,
  0xA0, 0x62, 0x84, 0xDF, 0xCC, 0xFD, 0x28, 0x21, 0xEF, 0xD2, 0x84, 0xDF, 0xCC, 0xFD, 0x30, 0x9A,
  0x86, 0x50, 0xDF, 0xCC, 0xFD, 0x30, 0x2A, 0x86, 0xC0, 0xCF, 0xCC, 0xFD, 0x40, 0xAA, 0x85, 0x4C,
  0xFC, 0xCF, 0xD4, 0x02, 0xA8, 0x5B, 0xBF, 0xCC, 0xFD, 0x50, 0xBA, 0x84, 0xEF, 0xCC, 0xFD, 0x50,
  0x3C, 0x82, 0xCC, 0xFD, 0x60, 0xCB, 0x82, 0xCC, 0xFD, 0x60, 0x5B, 0x82, 0xCC, 0xFD, 0x70, 0xDA,
  0x0C, 0x77, 0x50, 0x9A, 0x01, 0x73, 0x81, 0xCF, 0xC7, 0x48, 0x1E, 0xF6, 0x73, 0x81, 0x2F, 0xE7,
  0x48, 0x16, 0xF6, 0x70,
  // "ņ" (U+0146)
  0x01, 0xA8, 0x52, 0x08, 0xDF, 0xD7, 0x20, 0x1A, 0x05, 0x0C, 0xD8, 0x18, 0x01, 0xA8, 0x3E, 0xFA,
  0x7A, 0xB0, 0x20, 0x1B, 0x08, 0x30, 0x9A, 0x06, 0x01, 0xB0, 0x13, 0x04, 0xA0, 0x80, 0x1A, 0x0D,
  0x40, 0x2A, 0x09, 0x01, 0xA0, 0xB4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0,
  0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A,
  0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01,
  0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x77, 0x30, 0x9A, 0x01, 0x71, 0x81,
  0xCF, 0xC7, 0x28, 0x1E, 0xF6, 0x71, 0x81, 0x2F, 0xE7, 0x28, 0x16, 0xF6, 0x50,
  // "Ň" (U+0147)
  0x30, 0x60, 0x74, 0x81, 0x27, 0x45, 0x87, 0x6F, 0xC1, 0x03, 0xEE, 0x26, 0x85, 0xAF, 0xB3, 0xEF,
  0x57, 0x01, 0x0D, 0xB0, 0x97, 0x20, 0x5A, 0x0E, 0x01, 0x77, 0x77, 0x40, 0xCA, 0x0C, 0x78, 0x2D,
  0xFC, 0xCB, 0x04, 0x68, 0x2D, 0xFC, 0xCB, 0x0B, 0x68, 0x2D, 0xFC, 0xCC, 0x03, 0x58, 0x4D, 0xFC,
  0xCF, 0xEA, 0x0A, 0x58, 0x5D, 0xFC, 0xCF, 0xAC, 0xA0, 0x24, 0x85, 0xDF, 0xCC, 0xFB, 0x5A, 0x09,
  0x48, 0x6D, 0xFC, 0xCF, 0xC0, 0xDA, 0x01, 0x38, 0x6D, 0xFC, 0xCF, 0xC0, 0x6A, 0x08, 0x38, 0x4D,
  0xFC, 0xCF, 0xD2, 0x81, 0xEF, 0xE3, 0x84, 0xDF, 0xCC, 0xFD, 0x20, 0x7A, 0x06, 0x28, 0x4D, 0xFC,
  0xCF, 0xD2, 0x82, 0x1E, 0xFD, 0x28, 0x4D, 0xFC, 0xCF, 0xD3, 0x09, 0xA8, 0x65, 0x0D, 0xFC, 0xCF,
  0xD3, 0x02, 0xA8, 0x6C, 0x0C, 0xFC, 0xCF, 0xD4, 0x0A, 0xA8, 0x54, 0xCF, 0xCC, 0xFD, 0x40, 0x2A,
  0x85, 0xBB, 0xFC, 0xCF, 0xD5, 0x0B, 0xA8, 0x4E, 0xFC, 0xCF, 0xD5, 0x03, 0xC8, 0x2C, 0xCF, 0xD6,
  0x0C, 0xB8, 0x2C, 0xCF, 0xD6, 0x05, 0xB8, 0x2C, 0xCF, 0xD7, 0x0D, 0xA0, 0xC0,
  // "ň" (U+0148)
  0x20, 0x60, 0x74, 0x81, 0x27, 0x43, 0x87, 0x6F, 0xC1, 0x03, 0xEE, 0x24, 0x85, 0xAF, 0xB3, 0xEF,
  0x55, 0x01, 0x0D, 0xB0, 0x97, 0x05, 0xA0, 0xE0, 0x17, 0x77, 0x60, 0x1A, 0x85, 0x20, 0x8D, 0xFD,
  0x72, 0x01, 0xA0, 0x50, 0xCD, 0x81, 0x80, 0x1A, 0x83, 0xEF, 0xA7, 0xAB, 0x02, 0x01, 0xB0, 0x83,
  0x09, 0xA0, 0x60, 0x1B, 0x01, 0x30, 0x4A, 0x08, 0x01, 0xA0, 0xD4, 0x02, 0xA0, 0x90, 0x1A, 0x0B,
  0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0,
  0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A,
  0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01,
  0xA0, 0xA4, 0x01, 0xA0, 0x90,
  // "ŉ" (U+0149)
  0x10, 0x2A, 0x0C, 0x75, 0x04, 0xA0, 0x97, 0x50, 0x7A, 0x04, 0x75, 0x0A, 0xA7, 0x68, 0x1C, 0xFA,
  0x76, 0xA0, 0x40, 0x1A, 0x85, 0x20, 0x8D, 0xFD, 0x72, 0x83, 0x3F, 0xE0, 0x1A, 0x05, 0x0C, 0xD0,
  0x85, 0x01, 0xA8, 0x3E, 0xFA, 0x7A, 0xB0, 0x24, 0x01, 0xB0, 0x83, 0x09, 0xA0, 0x64, 0x01, 0xB0,
  0x13, 0x04, 0xA0, 0x84, 0x01, 0xA0, 0xD4, 0x02, 0xA0, 0x94, 0x01, 0xA0, 0xB4, 0x01, 0xA0, 0x94,
  0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x94, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x94, 0x01, 0xA0, 0xA4, 0x01,
  0xA0, 0x94, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x94, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x94, 0x01, 0xA0,
  0xA4, 0x01, 0xA0, 0x94, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x94, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x94,
  0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90,
  // "Ŋ" (U+014A)
  0x0C, 0xA0, 0xC7, 0x82, 0xDF, 0xCC, 0xB0, 0x56, 0x82, 0xDF, 0xCC, 0xB0, 0xC6, 0x82, 0xDF, 0xCC,
  0xC0, 0x55, 0x84, 0xDF, 0xCC, 0xFD, 0xA0, 0xC5, 0x85, 0xDF, 0xCC, 0xFB, 0xBA, 0x05, 0x48, 0x5D,
  0xFC, 0xCF, 0xB3, 0xA0, 0xC4, 0x86, 0xDF, 0xCC, 0xFC, 0x0B, 0xA0, 0x53, 0x86, 0xDF, 0xCC, 0xFC,
  0x03, 0xA0, 0xC3, 0x84, 0xDF, 0xCC, 0xFD, 0x20, 0xAA, 0x05, 0x28, 0x4D, 0xFC, 0xCF, 0xD2, 0x03,
  0xA0, 0xC2, 0x84, 0xDF, 0xCC, 0xFD, 0x30, 0xAA, 0x86, 0x40, 0xDF, 0xCC, 0xFD, 0x30, 0x2A, 0x86,
  0xC0, 0xCF, 0xCC, 0xFD, 0x40, 0xAA, 0x85, 0x4C, 0xFC, 0xCF, 0xD4, 0x02, 0xA8, 0x5C, 0xBF, 0xCC,
  0xFD, 0x50, 0xAA, 0x84, 0xEF, 0xCC, 0xFD, 0x50, 0x2C, 0x82, 0xCC, 0xFD, 0x60, 0x9B, 0x82, 0xCC,
  0xFD, 0x60, 0x2B, 0x82, 0xCC, 0xFD, 0x70, 0x9A, 0x82, 0xCC, 0xFD, 0x70, 0x2A, 0x0C, 0x74, 0x81,
  0xEF, 0xB7, 0x30, 0x1A, 0x09, 0x78, 0x22, 0x01, 0xAA, 0x05, 0x70, 0xBC, 0x0D, 0x71, 0x0B, 0xB0,
  0xD0, 0x37, 0x18, 0x22, 0x56, 0x43,
  // "ŋ" (U+014B)
  0x01, 0xA8, 0x52, 0x08, 0xDF, 0xD7, 0x20, 0x1A, 0x05, 0x0C, 0xD8, 0x18, 0x01, 0xA8, 0x3E, 0xFA,
  0x7A, 0xB0, 0x01, 0xB0, 0x83, 0x09, 0xA0, 0x50, 0x1B, 0x01, 0x30, 0x4A, 0x08, 0x01, 0xA0, 0xD4,
  0x02, 0xA0, 0x90, 0x1A, 0x0B, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A,
  0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0,
  0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A,
  0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x97, 0x10, 0x1A, 0x09, 0x71, 0x01, 0xA0,
  0x97, 0x10, 0x2A, 0x09, 0x71, 0x04, 0xA0, 0x76, 0x81, 0x67, 0xDA, 0x03, 0x60, 0xBB, 0x0C, 0x78,
  0x39, 0xEE, 0xA1, 0x10,
  // "Ō" (U+014C)
  0x40, 0x58, 0x02, 0x60, 0x47, 0x10, 0xDE, 0x0A, 0x71, 0x0D, 0xE0, 0xA8, 0x0C, 0x40, 0x86, 0x39,
  0xDE, 0xEC, 0x71, 0x70, 0x8F, 0x0E, 0x03, 0x50, 0x8B, 0x82, 0xA7, 0x8C, 0xA0, 0xE0, 0x13, 0x02,
  0xB0, 0x44, 0x09, 0xA0, 0xA3, 0x09, 0xA0, 0x86, 0x0D, 0xA0, 0x22, 0x0E, 0xA0, 0x16, 0x07, 0xA8,
  0x17, 0x02, 0xA0, 0xC7, 0x03, 0xA8, 0x1B, 0x05, 0xA0, 0x97, 0x1A, 0x81, 0xE0, 0x7A, 0x07, 0x71,
  0x0E, 0xA1, 0x07, 0xA0, 0x77, 0x10, 0xDA, 0x01, 0x08, 0xA0, 0x67, 0x10, 0xCA, 0x02, 0x07, 0xA0,
  0x77, 0x10, 0xDA, 0x01, 0x06, 0xA0, 0x77, 0x10, 0xEA, 0x10, 0x4A, 0x09, 0x71, 0xA8, 0x1E, 0x01,
  0xA0, 0xC7, 0x03, 0xA0, 0xB2, 0x0D, 0xA0, 0x16, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x86, 0x0D, 0xA0,
  0x22, 0x01, 0x0E, 0xA0, 0x44, 0x09, 0xA0, 0xA4, 0x05, 0xB8, 0x2A, 0x78, 0xDA, 0x0E, 0x02, 0x50,
  0x7F, 0x0E, 0x03, 0x78, 0x63, 0x9D, 0xFE, 0xC7, 0x14,
  // "ō" (U+014D)
  0x20, 0x58, 0x02, 0x60, 0x44, 0x0D, 0xE0, 0xA4, 0x0D, 0xE0, 0xA7, 0x77, 0x71, 0x84, 0x6C, 0xEE,
  0xC6, 0x50, 0xBE, 0x0B, 0x30, 0x8A, 0x82, 0xD8, 0x7D, 0xA0, 0x82, 0x82, 0xEF, 0xE1, 0x30, 0xDA,
  0x01, 0x05, 0xA0, 0x84, 0x06, 0xA0, 0x60, 0x8A, 0x04, 0x40, 0x2A, 0x00, 0xAA, 0x02, 0x5A, 0x0C,
  0x0B, 0xA0, 0x15, 0xA0, 0xD0, 0xBA, 0x01, 0x5A, 0x0C, 0x0A, 0xA0, 0x25, 0xA0, 0xB0, 0x8A, 0x04,
  0x40, 0x2A, 0x09, 0x04, 0xA0, 0x84, 0x06, 0xA8, 0x46, 0x0E, 0xFE, 0x13, 0x84, 0xDF, 0xE1, 0x06,
  0xA8, 0x2D, 0x87, 0xDA, 0x08, 0x30, 0x9E, 0x0A, 0x58, 0x45, 0xBE, 0xEC, 0x63,
  // "Ŏ" (U+014E)
  0x40, 0xC0, 0xE4, 0x0E, 0x0D, 0x71, 0x86, 0x9F, 0xC7, 0x7C, 0xFA, 0x71, 0x02, 0xD0, 0xE0, 0x27,
  0x28, 0x43, 0xBE, 0xEB, 0x38, 0x0C, 0x50, 0x86, 0x39, 0xDE, 0xEC, 0x71, 0x70, 0x8F, 0x0E, 0x03,
  0x50, 0x8B, 0x82, 0xA7, 0x8C, 0xA0, 0xE0, 0x13, 0x02, 0xB0, 0x44, 0x09, 0xA0, 0xA3, 0x09, 0xA0,
  0x86, 0x0D, 0xA0, 0x22, 0x0E, 0xA0, 0x16, 0x07, 0xA8, 0x17, 0x02, 0xA0, 0xC7, 0x03, 0xA8, 0x1B,
  0x05, 0xA0, 0x97, 0x1A, 0x81, 0xE0, 0x7A, 0x07, 0x71, 0x0E, 0xA1, 0x07, 0xA0, 0x77, 0x10, 0xDA,
  0x01, 0x08, 0xA0, 0x67, 0x10, 0xCA, 0x02, 0x07, 0xA0, 0x77, 0x10, 0xDA, 0x01, 0x06, 0xA0, 0x77,
  0x10, 0xEA, 0x10, 0x4A, 0x09, 0x71, 0xA8, 0x1E, 0x01, 0xA0, 0xC7, 0x03, 0xA0, 0xB2, 0x0D, 0xA0,
  0x16, 0x07, 0xA0, 0x72, 0x07, 0xA0, 0x86, 0x0D, 0xA0, 0x22, 0x01, 0x0E, 0xA0, 0x44, 0x09, 0xA0,
  0xA4, 0x05, 0xB8, 0x2A, 0x78, 0xDA, 0x0E, 0x02, 0x50, 0x7F, 0x0E, 0x03, 0x78, 0x63, 0x9D, 0xFE,
  0xC7, 0x14,
  // "ŏ" (U+014F)
  0x20, 0xC0, 0xE4, 0x0E, 0x0D, 0x48, 0x69, 0xFC, 0x77, 0xCF, 0xA4, 0x02, 0xD0, 0xE0, 0x25, 0x84,
  0x3B, 0xEE, 0xB3, 0x77, 0x77, 0x28, 0x46, 0xCE, 0xEC, 0x65, 0x0B, 0xE0, 0xB3, 0x08, 0xA8, 0x2D,
  0x87, 0xDA, 0x08, 0x28, 0x2E, 0xFE, 0x13, 0x0D, 0xA0, 0x10, 0x5A, 0x08, 0x40, 0x6A, 0x06, 0x08,
  0xA0, 0x44, 0x02, 0xA0, 0x0A, 0xA0, 0x25, 0xA0, 0xC0, 0xBA, 0x01, 0x5A, 0x0D, 0x0B, 0xA0, 0x15,
  0xA0, 0xC0, 0xAA, 0x02, 0x5A, 0x0B, 0x08, 0xA0, 0x44, 0x02, 0xA0, 0x90, 0x4A, 0x08, 0x40, 0x6A,
  0x84, 0x60, 0xEF, 0xE1, 0x38, 0x4D, 0xFE, 0x10, 0x6A, 0x82, 0xD8, 0x7D, 0xA0, 0x83, 0x09, 0xE0,
  0xA5, 0x84, 0x5B, 0xEE, 0xC6, 0x30,
  // "Ő" (U+0150)
  0x60, 0xCA, 0x01, 0x05, 0xA0, 0x87, 0x04, 0xA8, 0x47, 0x0C, 0xFD, 0x17, 0x83, 0xBF, 0xB0, 0x4A,
  0x03, 0x78, 0x64, 0xFD, 0x10, 0xCF, 0x67, 0x18, 0x5B, 0xD1, 0x04, 0xF7, 0x80, 0xC5, 0x08, 0x63,
  0x9D, 0xEE, 0xC7, 0x17, 0x08, 0xF0, 0xE0, 0x35, 0x08, 0xB8, 0x2A, 0x78, 0xCA, 0x0E, 0x01, 0x30,
  0x2B, 0x04, 0x40, 0x9A, 0x0A, 0x30, 0x9A, 0x08, 0x60, 0xDA, 0x02, 0x20, 0xEA, 0x01, 0x60, 0x7A,
  0x81, 0x70, 0x2A, 0x0C, 0x70, 0x3A, 0x81, 0xB0, 0x5A, 0x09, 0x71, 0xA8, 0x1E, 0x07, 0xA0, 0x77,
  0x10, 0xEA, 0x10, 0x7A, 0x07, 0x71, 0x0D, 0xA0, 0x10, 0x8A, 0x06, 0x71, 0x0C, 0xA0, 0x20, 0x7A,
  0x07, 0x71, 0x0D, 0xA0, 0x10, 0x6A, 0x07, 0x71, 0x0E, 0xA1, 0x04, 0xA0, 0x97, 0x1A, 0x81, 0xE0,
  0x1A, 0x0C, 0x70, 0x3A, 0x0B, 0x20, 0xDA, 0x01, 0x60, 0x7A, 0x07, 0x20, 0x7A, 0x08, 0x60, 0xDA,
  0x02, 0x20, 0x10, 0xEA, 0x04, 0x40, 0x9A, 0x0A, 0x40, 0x5B, 0x82, 0xA7, 0x8D, 0xA0, 0xE0, 0x25,
  0x07, 0xF0, 0xE0, 0x37, 0x86, 0x39, 0xDF, 0xEC, 0x71, 0x40,
  // "ő" (U+0151)
  0x40, 0xCA, 0x01, 0x05, 0xA0, 0x83, 0x04, 0xA8, 0x47, 0x0C, 0xFD, 0x13, 0x83, 0xBF, 0xB0, 0x4A,
  0x03, 0x38, 0x64, 0xFD, 0x10, 0xCF, 0x64, 0x85, 0xBD, 0x10, 0x4F, 0x77, 0x77, 0x72, 0x84, 0x6C,
  0xEE, 0xC6, 0x50, 0xBE, 0x0B, 0x30, 0x8A, 0x82, 0xD8, 0x7D, 0xA0, 0x82, 0x82, 0xEF, 0xE1, 0x30,
  0xDA, 0x01, 0x05, 0xA0, 0x84, 0x06, 0xA0, 0x60, 0x8A, 0x04, 0x40, 0x2A, 0x00, 0xAA, 0x02, 0x5A,
  0x0C, 0x0B, 0xA0, 0x15, 0xA0, 0xD0, 0xBA, 0x01, 0x5A, 0x0C, 0x0A, 0xA0, 0x25, 0xA0, 0xB0, 0x8A,
  0x04, 0x40, 0x2A, 0x09, 0x04, 0xA0, 0x84, 0x06, 0xA8, 0x46, 0x0E, 0xFE, 0x13, 0x84, 0xDF, 0xE1,
  0x06, 0xA8, 0x2D, 0x87, 0xDA, 0x08, 0x30, 0x9E, 0x0A, 0x58, 0x45, 0xBE, 0xEC, 0x63,
  // "Œ" (U+0152)
  0x48, 0x22, 0x9D, 0xEF, 0xB0, 0x93, 0x07, 0xFF, 0x09, 0x20, 0x6B, 0x82, 0xB7, 0x7B, 0xA0, 0x98,
  0x01, 0x68, 0x23, 0x01, 0xEA, 0x05, 0x30, 0x7A, 0x05, 0x70, 0x8A, 0x08, 0x40, 0x7A, 0x05, 0x70,
  0xDA, 0x01, 0x40, 0x7A, 0x05, 0x60, 0x2A, 0x0C, 0x50, 0x7A, 0x05, 0x60, 0x5A, 0x09, 0x50, 0x7A,
  0x05, 0x60, 0x7A, 0x07, 0x50, 0x7A, 0x05, 0x60, 0x7A, 0x07, 0x50, 0x7F, 0x90, 0x20, 0x8A, 0x06,
  0x50, 0x7F, 0x90, 0x20, 0x7A, 0x07, 0x50, 0x7A, 0x09, 0x80, 0x16, 0x01, 0x06, 0xA0, 0x85, 0x07,
  0xA0, 0x56, 0x05, 0xA0, 0x95, 0x07, 0xA0, 0x56, 0x01, 0xA0, 0xD5, 0x07, 0xA0, 0x57, 0x0D, 0xA0,
  0x14, 0x07, 0xA0, 0x57, 0x08, 0xA0, 0x84, 0x07, 0xA0, 0x57, 0x01, 0xB0, 0x53, 0x07, 0xA0, 0x57,
  0x10, 0x6B, 0x82, 0xB7, 0x6B, 0xA0, 0x98, 0x01, 0x60, 0x33, 0x07, 0xFF, 0x09, 0x48, 0x13, 0x9D,
  0xFC, 0x09,
  // "œ" (U+0153)
  0x38, 0x46, 0xCE, 0xEB, 0x43, 0x84, 0x7D, 0xFD, 0x81, 0x40, 0xBE, 0x81, 0x60, 0xBD, 0x0D, 0x01,
  0x20, 0x8A, 0x82, 0xD7, 0x7D, 0xA0, 0xAA, 0x81, 0xA7, 0xAA, 0x0B, 0x28, 0x2E, 0xFE, 0x12, 0x01,
  0x0E, 0xB0, 0x73, 0x09, 0xA0, 0x20, 0x5A, 0x07, 0x40, 0x7A, 0x0E, 0x40, 0x2A, 0x07, 0x08, 0xA0,
  0x44, 0x03, 0xA0, 0xC5, 0x82, 0xEF, 0x9A, 0xA0, 0x24, 0x01, 0xFB, 0x0A, 0x0B, 0xA0, 0x15, 0xFB,
  0x00, 0xBA, 0x01, 0x5A, 0x0C, 0x80, 0x36, 0x04, 0x0A, 0xA0, 0x24, 0x01, 0xA0, 0xB7, 0x10, 0x8A,
  0x04, 0x40, 0x3A, 0x0E, 0x71, 0x04, 0xA0, 0x74, 0x07, 0xB0, 0x37, 0x18, 0x2E, 0xFE, 0x12, 0x01,
  0x0D, 0xB0, 0xC5, 0x03, 0x20, 0x7A, 0x82, 0xD7, 0x7D, 0xA0, 0x8A, 0x85, 0xD8, 0x78, 0xCF, 0x12,
  0x0A, 0xE8, 0x16, 0x09, 0xF0, 0x13, 0x84, 0x6C, 0xEE, 0xB4, 0x38, 0x55, 0xCE, 0xEC, 0x93, 0x10,
  // "Ŕ" (U+0154)
  0x68, 0x23, 0x77, 0x67, 0x20, 0xDA, 0x06, 0x71, 0x07, 0xA0, 0x77, 0x18, 0x22, 0xEF, 0x87, 0x28,
  0x1B, 0xF8, 0x77, 0x77, 0x40, 0xCC, 0x82, 0xEC, 0x92, 0x40, 0xCF, 0x90, 0x63, 0x0C, 0xA8, 0x27,
  0x78, 0xDB, 0x04, 0x20, 0xCA, 0x40, 0x9A, 0x0B, 0x20, 0xCA, 0x5B, 0x20, 0xCA, 0x50, 0xDA, 0x81,
  0x10, 0xCA, 0x50, 0xDA, 0x81, 0x10, 0xCA, 0x5A, 0x0E, 0x20, 0xCA, 0x40, 0x6A, 0x0A, 0x20, 0xCA,
  0x28, 0x11, 0x6E, 0xA0, 0x32, 0x0C, 0xF9, 0x07, 0x30, 0xCF, 0x04, 0x40, 0xCA, 0x81, 0x76, 0xBA,
  0x03, 0x40, 0xCA, 0x20, 0x3A, 0x0B, 0x40, 0xCA, 0x30, 0xBA, 0x03, 0x30, 0xCA, 0x30, 0x4A, 0x0A,
  0x30, 0xCA, 0x40, 0xDA, 0x02, 0x20, 0xCA, 0x40, 0x6A, 0x0A, 0x20, 0xCA, 0x50, 0xEA, 0x81, 0x20,
  0xCA, 0x50, 0x7A, 0x81, 0x90, 0xCA, 0x50, 0x1B, 0x02,
  // "ŕ" (U+0155)
  0x58, 0x23, 0x77, 0x65, 0x0D, 0xA0, 0x64, 0x07, 0xA0, 0x74, 0x82, 0x2E, 0xF8, 0x58, 0x1B, 0xF8,
  0x77, 0x70, 0x1A, 0x85, 0x20, 0x8E, 0xF6, 0x1A, 0x04, 0x0A, 0xB0, 0x40, 0x1A, 0x85, 0xBF, 0xD7,
  0x81, 0x1B, 0x0C, 0x40, 0x1B, 0x04, 0x40, 0x1A, 0x0E, 0x50, 0x1A, 0x0C, 0x50, 0x1A, 0x0A, 0x50,
  0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A,
  0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50,
  // "Ŗ" (U+0156)
  0x0C, 0xC8, 0x2E, 0xC9, 0x24, 0x0C, 0xF9, 0x06, 0x30, 0xCA, 0x82, 0x77, 0x8D, 0xB0, 0x42, 0x0C,
  0xA4, 0x09, 0xA0, 0xB2, 0x0C, 0xA5, 0xB2, 0x0C, 0xA5, 0x0D, 0xA8, 0x11, 0x0C, 0xA5, 0x0D, 0xA8,
  0x11, 0x0C, 0xA5, 0xA0, 0xE2, 0x0C, 0xA4, 0x06, 0xA0, 0xA2, 0x0C, 0xA2, 0x81, 0x16, 0xEA, 0x03,
  0x20, 0xCF, 0x90, 0x73, 0x0C, 0xF0, 0x44, 0x0C, 0xA8, 0x17, 0x6B, 0xA0, 0x34, 0x0C, 0xA2, 0x03,
  0xA0, 0xB4, 0x0C, 0xA3, 0x0B, 0xA0, 0x33, 0x0C, 0xA3, 0x04, 0xA0, 0xA3, 0x0C, 0xA4, 0x0D, 0xA0,
  0x22, 0x0C, 0xA4, 0x06, 0xA0, 0xA2, 0x0C, 0xA5, 0x0E, 0xA8, 0x12, 0x0C, 0xA5, 0x07, 0xA8, 0x19,
  0x0C, 0xA5, 0x01, 0xB0, 0x27, 0x73, 0x09, 0xA0, 0x17, 0x28, 0x1C, 0xFC, 0x73, 0x81, 0xEF, 0x67,
  0x28, 0x12, 0xFE, 0x73, 0x81, 0x6F, 0x67,
  // "ŗ" (U+0157)
  0x01, 0xA8, 0x52, 0x08, 0xEF, 0x61, 0xA0, 0x40, 0xAB, 0x04, 0x01, 0xA8, 0x5B, 0xFD, 0x78, 0x11,
  0xB0, 0xC4, 0x01, 0xB0, 0x44, 0x01, 0xA0, 0xE5, 0x01, 0xA0, 0xC5, 0x01, 0xA0, 0xA5, 0x01, 0xA0,
  0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA5,
  0x01, 0xA0, 0xA5, 0x01, 0xA0, 0xA7, 0x71, 0x09, 0xA0, 0x15, 0x81, 0xCF, 0xC6, 0x81, 0xEF, 0x65,
  0x81, 0x2F, 0xE6, 0x81, 0x6F, 0x66,
  // "Ř" (U+0158)
  0x10, 0x60, 0x74, 0x81, 0x27, 0x44, 0x87, 0x6F, 0xC1, 0x03, 0xEE, 0x25, 0x85, 0xAF, 0xB3, 0xEF,
  0x56, 0x01, 0x0D, 0xB0, 0x97, 0x10, 0x5A, 0x0E, 0x01, 0x77, 0x77, 0x30, 0xCC, 0x82, 0xEC, 0x92,
  0x40, 0xCF, 0x90, 0x63, 0x0C, 0xA8, 0x27, 0x78, 0xDB, 0x04, 0x20, 0xCA, 0x40, 0x9A, 0x0B, 0x20,
  0xCA, 0x5B, 0x20, 0xCA, 0x50, 0xDA, 0x81, 0x10, 0xCA, 0x50, 0xDA, 0x81, 0x10, 0xCA, 0x5A, 0x0E,
  0x20, 0xCA, 0x40, 0x6A, 0x0A, 0x20, 0xCA, 0x28, 0x11, 0x6E, 0xA0, 0x32, 0x0C, 0xF9, 0x07, 0x30,
  0xCF, 0x04, 0x40, 0xCA, 0x81, 0x76, 0xBA, 0x03, 0x40, 0xCA, 0x20, 0x3A, 0x0B, 0x40, 0xCA, 0x30,
  0xBA, 0x03, 0x30, 0xCA, 0x30, 0x4A, 0x0A, 0x30, 0xCA, 0x40, 0xDA, 0x02, 0x20, 0xCA, 0x40, 0x6A,
  0x0A, 0x20, 0xCA, 0x50, 0xEA, 0x81, 0x20, 0xCA, 0x50, 0x7A, 0x81, 0x90, 0xCA, 0x50, 0x1B, 0x02,
  // "ř" (U+0159)
  0x06, 0x07, 0x48, 0xA2, 0x27, 0x46, 0xFC, 0x10, 0x3E, 0xE2, 0x0A, 0xFB, 0x3E, 0xF5, 0x20, 0x10,
  0xDB, 0x09, 0x40, 0x5A, 0x0E, 0x01, 0x77, 0x60, 0x1A, 0x85, 0x20, 0x8E, 0xF6, 0x1A, 0x04, 0x0A,
  0xB0, 0x40, 0x1A, 0x85, 0xBF, 0xD7, 0x81, 0x1B, 0x0C, 0x40, 0x1B, 0x04, 0x40, 0x1A, 0x0E, 0x50,
  0x1A, 0x0C, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A,
  0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50, 0x1A, 0x0A, 0x50,
  // "Ś" (U+015A)
  0x68, 0x23, 0x77, 0x67, 0x0D, 0xA0, 0x66, 0x07, 0xA0, 0x76, 0x82, 0x2E, 0xF8, 0x78, 0x1B, 0xF8,
  0x77, 0x77, 0x86, 0x17, 0xCE, 0xFD, 0xA5, 0x20, 0x20, 0xDF, 0x81, 0x60, 0xDA, 0x82, 0xC7, 0x7A,
  0xA0, 0x10, 0x5A, 0x0B, 0x48, 0x21, 0x60, 0x9A, 0x04, 0x70, 0xAA, 0x03, 0x70, 0x9A, 0x06, 0x70,
  0x6A, 0x0E, 0x02, 0x60, 0x10, 0xEA, 0x0E, 0x07, 0x60, 0x5C, 0x0D, 0x05, 0x50, 0x40, 0xEC, 0x09,
  0x60, 0x8C, 0x0A, 0x60, 0x10, 0xBB, 0x04, 0x70, 0xBA, 0x09, 0x70, 0x3A, 0x0B, 0x70, 0x1A, 0x0B,
  0x70, 0x4A, 0x81, 0x97, 0x25, 0x0C, 0xA8, 0x64, 0xDF, 0xB8, 0x78, 0xDA, 0x81, 0xB0, 0xDF, 0x89,
  0x1C, 0x10, 0x38, 0xCD, 0xFE, 0xC6, 0x30,
  // "ś" (U+015B)
  0x58, 0x23, 0x77, 0x65, 0x0D, 0xA0, 0x64, 0x07, 0xA0, 0x74, 0x82, 0x2E, 0xF8, 0x58, 0x1B, 0xF8,
  0x77, 0x71, 0x89, 0x01, 0x8D, 0xFE, 0xC7, 0x11, 0xDE, 0x00, 0xAA, 0x87, 0xC7, 0x7B, 0xF4, 0xEF,
  0xD4, 0x83, 0x30, 0xEF, 0xC6, 0x0B, 0xA0, 0x55, 0x04, 0xB0, 0xA0, 0x24, 0x06, 0xC0, 0x74, 0x03,
  0x0C, 0xB0, 0xB5, 0x05, 0x0E, 0xA0, 0x75, 0x02, 0xA0, 0xC6, 0x82, 0xCF, 0xE5, 0x48, 0x90, 0x1E,
  0xFD, 0xFD, 0x97, 0x7D, 0xA0, 0x8F, 0x89, 0x0D, 0x14, 0xAD, 0xEF, 0xD8, 0x11,
  // "Ŝ" (U+015C)
  0x38, 0x21, 0x77, 0x67, 0x09, 0xB0, 0x45, 0x04, 0xA8, 0x1C, 0xFD, 0x48, 0x61, 0xDF, 0x50, 0xBF,
  0xA3, 0x81, 0xAF, 0x53, 0x81, 0xAF, 0x67, 0x77, 0x48, 0x61, 0x7C, 0xEF, 0xDA, 0x52, 0x02, 0x0D,
  0xF8, 0x16, 0x0D, 0xA8, 0x2C, 0x77, 0xAA, 0x01, 0x05, 0xA0, 0xB4, 0x82, 0x16, 0x09, 0xA0, 0x47,
  0x0A, 0xA0, 0x37, 0x09, 0xA0, 0x67, 0x06, 0xA0, 0xE0, 0x26, 0x01, 0x0E, 0xA0, 0xE0, 0x76, 0x05,
  0xC0, 0xD0, 0x55, 0x04, 0x0E, 0xC0, 0x96, 0x08, 0xC0, 0xA6, 0x01, 0x0B, 0xB0, 0x47, 0x0B, 0xA0,
  0x97, 0x03, 0xA0, 0xB7, 0x01, 0xA0, 0xB7, 0x04, 0xA8, 0x19, 0x72, 0x50, 0xCA, 0x86, 0x4D, 0xFB,
  0x87, 0x8D, 0xA8, 0x1B, 0x0D, 0xF8, 0x91, 0xC1, 0x03, 0x8C, 0xDF, 0xEC, 0x63,
  // "ŝ" (U+015D)
  0x28, 0x21, 0x77, 0x65, 0x09, 0xB0, 0x43, 0x04, 0xA8, 0x1C, 0xFD, 0x28, 0x92, 0x1D, 0xF5, 0x0B,
  0xFA, 0x0A, 0xF5, 0x38, 0x1A, 0xF6, 0x77, 0x58, 0x90, 0x18, 0xDF, 0xEC, 0x71, 0x1D, 0xE0, 0x0A,
  0xA8, 0x7C, 0x77, 0xBF, 0x4E, 0xFD, 0x48, 0x33, 0x0E, 0xFC, 0x60, 0xBA, 0x05, 0x50, 0x4B, 0x0A,
  0x02, 0x40, 0x6C, 0x07, 0x40, 0x30, 0xCB, 0x0B, 0x50, 0x50, 0xEA, 0x07, 0x50, 0x2A, 0x0C, 0x68,
  0x2C, 0xFE, 0x54, 0x89, 0x01, 0xEF, 0xDF, 0xD9, 0x77, 0xDA, 0x08, 0xF8, 0x90, 0xD1, 0x4A, 0xDE,
  0xFD, 0x81, 0x10,
  // "Ş" (U+015E)
  0x28, 0x61, 0x7C, 0xEF, 0xDA, 0x52, 0x02, 0x0D, 0xF8, 0x16, 0x0D, 0xA8, 0x2C, 0x77, 0xAA, 0x01,
  0x05, 0xA0, 0xB4, 0x82, 0x16, 0x09, 0xA0, 0x47, 0x0A, 0xA0, 0x37, 0x09, 0xA0, 0x67, 0x06, 0xA0,
  0xE0, 0x26, 0x01, 0x0E, 0xA0, 0xE0, 0x76, 0x05, 0xC0, 0xD0, 0x55, 0x04, 0x0E, 0xC0, 0x96, 0x08,
  0xC0, 0xA6, 0x01, 0x0B, 0xB0, 0x47, 0x0B, 0xA0, 0x97, 0x03, 0xA0, 0xB7, 0x01, 0xA0, 0xB7, 0x04,
  0xA8, 0x19, 0x72, 0x50, 0xCA, 0x86, 0x4D, 0xFB, 0x87, 0x8D, 0xA8, 0x1B, 0x0D, 0xF8, 0x91, 0xC1,
  0x03, 0x8C, 0xDF, 0xEC, 0x66, 0x81, 0x4F, 0x57, 0x18, 0x1B, 0xF6, 0x71, 0x82, 0x7D, 0xFC, 0x72,
  0xA0, 0x47, 0x02, 0xA0, 0x35, 0x00, 0xDA, 0x0D, 0x68, 0x3D, 0xFE, 0xA2, 0x40,
  // "ş" (U+015F)
  0x18, 0x90, 0x18, 0xDF, 0xEC, 0x71, 0x1D, 0xE0, 0x0A, 0xA8, 0x7C, 0x77, 0xBF, 0x4E, 0xFD, 0x48,
  0x33, 0x0E, 0xFC, 0x60, 0xBA, 0x05, 0x50, 0x4B, 0x0A, 0x02, 0x40, 0x6C, 0x07, 0x40, 0x30, 0xCB,
  0x0B, 0x50, 0x50, 0xEA, 0x07, 0x50, 0x2A, 0x0C, 0x68, 0x2C, 0xFE, 0x54, 0x89, 0x01, 0xEF, 0xDF,
  0xD9, 0x77, 0xDA, 0x08, 0xF8, 0x90, 0xD1, 0x4A, 0xDE, 0xFD, 0x81, 0x48, 0x14, 0xF5, 0x68, 0x1B,
  0xF6, 0x68, 0x27, 0xDF, 0xC7, 0xA0, 0x45, 0x02, 0xA0, 0x33, 0x00, 0xDA, 0x0D, 0x48, 0x3D, 0xFE,
  0xA2, 0x20,
  // "Š" (U+0160)
  0x10, 0x60, 0x74, 0x81, 0x27, 0x42, 0x87, 0x6F, 0xC1, 0x03, 0xEE, 0x23, 0x85, 0xAF, 0xB3, 0xEF,
  0x54, 0x01, 0x0D, 0xB0, 0x96, 0x05, 0xA0, 0xE0, 0x17, 0x77, 0x68, 0x61, 0x7C, 0xEF, 0xDA, 0x52,
  0x02, 0x0D, 0xF8, 0x16, 0x0D, 0xA8, 0x2C, 0x77, 0xAA, 0x01, 0x05, 0xA0, 0xB4, 0x82, 0x16, 0x09,
  0xA0, 0x47, 0x0A, 0xA0, 0x37, 0x09, 0xA0, 0x67, 0x06, 0xA0, 0xE0, 0x26, 0x01, 0x0E, 0xA0, 0xE0,
  0x76, 0x05, 0xC0, 0xD0, 0x55, 0x04, 0x0E, 0xC0, 0x96, 0x08, 0xC0, 0xA6, 0x01, 0x0B, 0xB0, 0x47,
  0x0B, 0xA0, 0x97, 0x03, 0xA0, 0xB7, 0x01, 0xA0, 0xB7, 0x04, 0xA8, 0x19, 0x72, 0x50, 0xCA, 0x86,
  0x4D, 0xFB, 0x87, 0x8D, 0xA8, 0x1B, 0x0D, 0xF8, 0x91, 0xC1, 0x03, 0x8C, 0xDF, 0xEC, 0x63,
  // "š" (U+0161)
  0x06, 0x07, 0x48, 0xA2, 0x27, 0x46, 0xFC, 0x10, 0x3E, 0xE2, 0x0A, 0xFB, 0x3E, 0xF5, 0x20, 0x10,
  0xDB, 0x09, 0x40, 0x5A, 0x0E, 0x01, 0x77, 0x78, 0x90, 0x18, 0xDF, 0xEC, 0x71, 0x1D, 0xE0, 0x0A,
  0xA8, 0x7C, 0x77, 0xBF, 0x4E, 0xFD, 0x48, 0x33, 0x0E, 0xFC, 0x60, 0xBA, 0x05, 0x50, 0x4B, 0x0A,
  0x02, 0x40, 0x6C, 0x07, 0x40, 0x30, 0xCB, 0x0B, 0x50, 0x50, 0xEA, 0x07, 0x50, 0x2A, 0x0C, 0x68,
  0x2C, 0xFE, 0x54, 0x89, 0x01, 0xEF, 0xDF, 0xD9, 0x77, 0xDA, 0x08, 0xF8, 0x90, 0xD1, 0x4A, 0xDE,
  0xFD, 0x81, 0x10,
  // "Ţ" (U+0162)
  0x0A, 0xFC, 0x01, 0x0A, 0xFC, 0x84, 0x14, 0x66, 0x68, 0xA0, 0xC8, 0x00, 0x65, 0x02, 0xA0, 0x97,
  0x20, 0x2A, 0x09, 0x72, 0x02, 0xA0, 0x97, 0x20, 0x2A, 0x09, 0x72, 0x02, 0xA0, 0x97, 0x20, 0x2A,
  0x09, 0x72, 0x02, 0xA0, 0x97, 0x20, 0x2A, 0x09, 0x72, 0x02, 0xA0, 0x97, 0x20, 0x2A, 0x09, 0x72,
  0x02, 0xA0, 0x97, 0x20, 0x2A, 0x09, 0x72, 0x02, 0xA0, 0x97, 0x20, 0x2A, 0x09, 0x72, 0x02, 0xA0,
  0x97, 0x20, 0x2A, 0x09, 0x72, 0x02, 0xA0, 0x97, 0x20, 0x2A, 0x09, 0x73, 0x81, 0x4F, 0x57, 0x38,
  0x1B, 0xF6, 0x73, 0x82, 0x7D, 0xFC, 0x74, 0xA0, 0x47, 0x20, 0x2A, 0x03, 0x70, 0x0D, 0xA0, 0xD7,
  0x18, 0x3D, 0xFE, 0xA2, 0x40,
  // "ţ" (U+0163)
  0x30, 0x70, 0x66, 0x81, 0x3F, 0xD6, 0x81, 0x6F, 0xD6, 0x81, 0xAF, 0xD4, 0x01, 0x09, 0xD8, 0x1E,
  0x08, 0xE8, 0x5E, 0x03, 0x6E, 0xFE, 0x0F, 0x63, 0x81, 0xEF, 0xD6, 0x81, 0xEF, 0xD6, 0x81, 0xEF,
  0xD6, 0x81, 0xEF, 0xD6, 0x81, 0xEF, 0xD6, 0x81, 0xEF, 0xD6, 0x81, 0xEF, 0xD6, 0x81, 0xEF, 0xD6,
  0x81, 0xEF, 0xD6, 0x0D, 0xA0, 0x15, 0x0A, 0xA8, 0x2C, 0x79, 0x12, 0x04, 0xD0, 0x13, 0x84, 0x5D,
  0xFE, 0xA1, 0x38, 0x14, 0xF5, 0x68, 0x1B, 0xF6, 0x68, 0x27, 0xDF, 0xC7, 0xA0, 0x45, 0x02, 0xA0,
  0x33, 0x00, 0xDA, 0x0D, 0x48, 0x3D, 0xFE, 0xA2, 0x20,
  // "Ť" (U+0164)
  0x20, 0x60, 0x74, 0x81, 0x27, 0x44, 0x87, 0x6F, 0xC1, 0x03, 0xEE, 0x25, 0x85, 0xAF, 0xB3, 0xEF,
  0x56, 0x01, 0x0D, 0xB0, 0x97, 0x10, 0x5A, 0x0E, 0x01, 0x77, 0x77, 0x20, 0xAF, 0xC0, 0x10, 0xAF,
  0xC8, 0x41, 0x46, 0x66, 0x8A, 0x0C, 0x80, 0x06, 0x50, 0x2A, 0x09, 0x72, 0x02, 0xA0, 0x97, 0x20,
  0x2A, 0x09, 0x72, 0x02, 0xA0, 0x97, 0x20, 0x2A, 0x09, 0x72, 0x02, 0xA0, 0x97, 0x20, 0x2A, 0x09,
  0x72, 0x02, 0xA0, 0x97, 0x20, 0x2A, 0x09, 0x72, 0x02, 0xA0, 0x97, 0x20, 0x2A, 0x09, 0x72, 0x02,
  0xA0, 0x97, 0x20, 0x2A, 0x09, 0x72, 0x02, 0xA0, 0x97, 0x20, 0x2A, 0x09, 0x72, 0x02, 0xA0, 0x97,
  0x20, 0x2A, 0x09, 0x72, 0x02, 0xA0, 0x95,
  // "ť" (U+0165)
  0x72, 0x09, 0xA0, 0x17, 0x28, 0x1B, 0xFD, 0x40, 0x70, 0x64, 0x81, 0xEF, 0x73, 0x81, 0x3F, 0xD3,
  0x01, 0xA0, 0x13, 0x81, 0x6F, 0xD3, 0x81, 0x3F, 0x94, 0x81, 0xAF, 0xD7, 0x10, 0x10, 0x9D, 0x0E,
  0x50, 0x8E, 0x0E, 0x58, 0x33, 0x6E, 0xFE, 0x0F, 0x67, 0x81, 0xEF, 0xD7, 0x38, 0x1E, 0xFD, 0x73,
  0x81, 0xEF, 0xD7, 0x38, 0x1E, 0xFD, 0x73, 0x81, 0xEF, 0xD7, 0x38, 0x1E, 0xFD, 0x73, 0x81, 0xEF,
  0xD7, 0x38, 0x1E, 0xFD, 0x73, 0x81, 0xEF, 0xD7, 0x30, 0xDA, 0x01, 0x72, 0x0A, 0xA8, 0x2C, 0x79,
  0x16, 0x04, 0xD0, 0x17, 0x84, 0x5D, 0xFE, 0xA1, 0x40,
  // "Ŧ" (U+0166)
  0x0A, 0xFC, 0x01, 0x0A, 0xFC, 0x84, 0x14, 0x66, 0x68, 0xA0, 0xC8, 0x00, 0x65, 0x03, 0xA0, 0x97,
  0x20, 0x3A, 0x09, 0x72, 0x03, 0xA0, 0x97, 0x20, 0x3A, 0x09, 0x72, 0x03, 0xA0, 0x97, 0x20, 0x3A,
  0x09, 0x68, 0x22, 0x66, 0x8A, 0x82, 0xC6, 0x64, 0x30, 0x4F, 0x90, 0xB3, 0x04, 0xF9, 0x0B, 0x60,
  0x3A, 0x09, 0x72, 0x03, 0xA0, 0x97, 0x20, 0x3A, 0x09, 0x72, 0x03, 0xA0, 0x97, 0x20, 0x3A, 0x09,
  0x72, 0x03, 0xA0, 0x97, 0x20, 0x3A, 0x09, 0x72, 0x03, 0xA0, 0x97, 0x20, 0x3A, 0x09, 0x50,
  // "ŧ" (U+0167)
  0x30, 0x70, 0x66, 0x81, 0x3F, 0xD6, 0x81, 0x6F, 0xD6, 0x81, 0xAF, 0xD4, 0x01, 0x09, 0xD8, 0x1E,
  0x08, 0xE8, 0x5E, 0x03, 0x6E, 0xFE, 0x0F, 0x63, 0x81, 0xEF, 0xD6, 0x81, 0xEF, 0xD4, 0x89, 0x03,
  0x6E, 0xFE, 0x66, 0x50, 0x6E, 0x81, 0xB0, 0x6E, 0x0B, 0x38, 0x1E, 0xFD, 0x68, 0x1E, 0xFD, 0x68,
  0x1E, 0xFD, 0x68, 0x1E, 0xFD, 0x60, 0xDA, 0x01, 0x50, 0xAA, 0x82, 0xC7, 0x91, 0x20, 0x4D, 0x01,
  0x38, 0x45, 0xDF, 0xEA, 0x10,
  // "Ũ" (U+0168)
  0x38, 0x27, 0xED, 0x62, 0x81, 0x7F, 0x33, 0x04, 0xC8, 0x1C, 0x7E, 0x94, 0x82, 0x9F, 0x99, 0xC0,
  0xA4, 0x0C, 0x0D, 0x28, 0x32, 0xBE, 0xC1, 0x77, 0x77, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60,
  0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A,
  0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03,
  0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0,
  0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x82, 0x9E, 0xFD, 0x60, 0x3A, 0x09, 0x0D, 0xA6, 0x05,
  0xA0, 0x80, 0xAA, 0x03, 0x50, 0x9A, 0x00, 0x5A, 0x0C, 0x40, 0x2A, 0x0E, 0x20, 0xCA, 0x83, 0xD8,
  0x79, 0xEA, 0x07, 0x20, 0x20, 0xDF, 0x0A, 0x58, 0x57, 0xCE, 0xFE, 0xA5, 0x30,
  // "ũ" (U+0169)
  0x38, 0x27, 0xED, 0x62, 0x81, 0x7F, 0x32, 0x04, 0xC8, 0x1C, 0x7E, 0x93, 0x82, 0x9F, 0x99, 0xC0,
  0xA3, 0x0C, 0x0D, 0x28, 0x32, 0xBE, 0xC1, 0x77, 0x74, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A,
  0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02,
  0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90,
  0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x4A, 0x09,
  0x02, 0xA0, 0xA4, 0x05, 0xA0, 0x90, 0x1A, 0x0C, 0x40, 0x9A, 0x81, 0x90, 0xEA, 0x02, 0x20, 0x20,
  0xEA, 0x81, 0x90, 0x9A, 0x83, 0xE8, 0x8E, 0xEA, 0x82, 0x90, 0x2E, 0xD8, 0x25, 0xDF, 0x92, 0x89,
  0x02, 0xBE, 0xEB, 0x40, 0xBF, 0x90,
  // "Ū" (U+016A)
  0x20, 0x58, 0x02, 0x60, 0x45, 0x0D, 0xE0, 0xA5, 0x0D, 0xE0, 0xA7, 0x77, 0x71, 0xA0, 0xD6, 0x03,
  0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0,
  0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A,
  0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D,
  0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x82, 0x9E, 0xFD, 0x60, 0x3A,
  0x09, 0x0D, 0xA6, 0x05, 0xA0, 0x80, 0xAA, 0x03, 0x50, 0x9A, 0x00, 0x5A, 0x0C, 0x40, 0x2A, 0x0E,
  0x20, 0xCA, 0x83, 0xD8, 0x79, 0xEA, 0x07, 0x20, 0x20, 0xDF, 0x0A, 0x58, 0x57, 0xCE, 0xFE, 0xA5,
  0x30,
  // "ū" (U+016B)
  0x20, 0x58, 0x02, 0x60, 0x44, 0x0D, 0xE0, 0xA4, 0x0D, 0xE0, 0xA7, 0x77, 0x50, 0x2A, 0x09, 0x40,
  0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94,
  0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09,
  0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0,
  0x94, 0x04, 0xA0, 0x90, 0x2A, 0x0A, 0x40, 0x5A, 0x09, 0x01, 0xA0, 0xC4, 0x09, 0xA8, 0x19, 0x0E,
  0xA0, 0x22, 0x02, 0x0E, 0xA8, 0x19, 0x09, 0xA8, 0x3E, 0x88, 0xEE, 0xA8, 0x29, 0x02, 0xED, 0x82,
  0x5D, 0xF9, 0x28, 0x90, 0x2B, 0xEE, 0xB4, 0x0B, 0xF9,
  // "Ŭ" (U+016C)
  0x20, 0xC0, 0xE4, 0x0E, 0x0D, 0x58, 0x69, 0xFC, 0x77, 0xCF, 0xA5, 0x02, 0xD0, 0xE0, 0x26, 0x84,
  0x3B, 0xEE, 0xB3, 0x77, 0x77, 0x2A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D,
  0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0,
  0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6,
  0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09,
  0xA0, 0xD6, 0x03, 0xA8, 0x29, 0xEF, 0xD6, 0x03, 0xA0, 0x90, 0xDA, 0x60, 0x5A, 0x08, 0x0A, 0xA0,
  0x35, 0x09, 0xA0, 0x05, 0xA0, 0xC4, 0x02, 0xA0, 0xE2, 0x0C, 0xA8, 0x3D, 0x87, 0x9E, 0xA0, 0x72,
  0x02, 0x0D, 0xF0, 0xA5, 0x85, 0x7C, 0xEF, 0xEA, 0x53,
  // "ŭ" (U+016D)
  0x20, 0xC0, 0xE4, 0x0E, 0x0D, 0x48, 0x69, 0xFC, 0x77, 0xCF, 0xA4, 0x02, 0xD0, 0xE0, 0x25, 0x84,
  0x3B, 0xEE, 0xB3, 0x77, 0x76, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09,
  0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0,
  0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A,
  0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x4A, 0x09, 0x02, 0xA0, 0xA4, 0x05,
  0xA0, 0x90, 0x1A, 0x0C, 0x40, 0x9A, 0x81, 0x90, 0xEA, 0x02, 0x20, 0x20, 0xEA, 0x81, 0x90, 0x9A,
  0x83, 0xE8, 0x8E, 0xEA, 0x82, 0x90, 0x2E, 0xD8, 0x25, 0xDF, 0x92, 0x89, 0x02, 0xBE, 0xEB, 0x40,
  0xBF, 0x90,
  // "Ů" (U+016E)
  0x48, 0x37, 0xDE, 0xA2, 0x78, 0x47, 0xFE, 0xDF, 0xD7, 0x85, 0xCD, 0x10, 0x8F, 0x36, 0x0C, 0x0D,
  0x28, 0x18, 0xF2, 0x68, 0x47, 0xFE, 0xDF, 0xD7, 0x18, 0x38, 0xDE, 0xB2, 0x77, 0x77, 0x2A, 0x0D,
  0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0,
  0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6,
  0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09,
  0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA8, 0x29, 0xEF, 0xD6,
  0x03, 0xA0, 0x90, 0xDA, 0x60, 0x5A, 0x08, 0x0A, 0xA0, 0x35, 0x09, 0xA0, 0x05, 0xA0, 0xC4, 0x02,
  0xA0, 0xE2, 0x0C, 0xA8, 0x3D, 0x87, 0x9E, 0xA0, 0x72, 0x02, 0x0D, 0xF0, 0xA5, 0x85, 0x7C, 0xEF,
  0xEA, 0x53,
  // "ů" (U+016F)
  0x48, 0x37, 0xDE, 0xA2, 0x68, 0x47, 0xFE, 0xDF, 0xD6, 0x85, 0xCD, 0x10, 0x8F, 0x35, 0x0C, 0x0D,
  0x28, 0x18, 0xF2, 0x58, 0x47, 0xFE, 0xDF, 0xD7, 0x83, 0x8D, 0xEB, 0x27, 0x77, 0x60, 0x2A, 0x09,
  0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0,
  0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A,
  0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02,
  0xA0, 0x94, 0x04, 0xA0, 0x90, 0x2A, 0x0A, 0x40, 0x5A, 0x09, 0x01, 0xA0, 0xC4, 0x09, 0xA8, 0x19,
  0x0E, 0xA0, 0x22, 0x02, 0x0E, 0xA8, 0x19, 0x09, 0xA8, 0x3E, 0x88, 0xEE, 0xA8, 0x29, 0x02, 0xED,
  0x82, 0x5D, 0xF9, 0x28, 0x90, 0x2B, 0xEE, 0xB4, 0x0B, 0xF9,
  // "Ű" (U+0170)
  0x50, 0xCA, 0x01, 0x05, 0xA0, 0x84, 0x04, 0xA8, 0x47, 0x0C, 0xFD, 0x14, 0x83, 0xBF, 0xB0, 0x4A,
  0x03, 0x48, 0x64, 0xFD, 0x10, 0xCF, 0x65, 0x85, 0xBD, 0x10, 0x4F, 0x77, 0x77, 0x71, 0xA0, 0xD6,
  0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09,
  0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60,
  0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A,
  0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x82, 0x9E, 0xFD, 0x60,
  0x3A, 0x09, 0x0D, 0xA6, 0x05, 0xA0, 0x80, 0xAA, 0x03, 0x50, 0x9A, 0x00, 0x5A, 0x0C, 0x40, 0x2A,
  0x0E, 0x20, 0xCA, 0x83, 0xD8, 0x79, 0xEA, 0x07, 0x20, 0x20, 0xDF, 0x0A, 0x58, 0x57, 0xCE, 0xFE,
  0xA5, 0x30,
  // "ű" (U+0171)
  0x50, 0xCA, 0x01, 0x05, 0xA0, 0x84, 0x04, 0xA8, 0x47, 0x0C, 0xFD, 0x14, 0x83, 0xBF, 0xB0, 0x4A,
  0x03, 0x48, 0x64, 0xFD, 0x10, 0xCF, 0x65, 0x85, 0xBD, 0x10, 0x4F, 0x77, 0x77, 0x71, 0x02, 0xA0,
  0x94, 0x03, 0xA8, 0x19, 0x02, 0xA0, 0x94, 0x03, 0xA8, 0x19, 0x02, 0xA0, 0x94, 0x03, 0xA8, 0x19,
  0x02, 0xA0, 0x94, 0x03, 0xA8, 0x19, 0x02, 0xA0, 0x94, 0x03, 0xA8, 0x19, 0x02, 0xA0, 0x94, 0x03,
  0xA8, 0x19, 0x02, 0xA0, 0x94, 0x03, 0xA8, 0x19, 0x02, 0xA0, 0x94, 0x03, 0xA8, 0x19, 0x02, 0xA0,
  0x94, 0x03, 0xA8, 0x19, 0x02, 0xA0, 0x94, 0x04, 0xA8, 0x19, 0x02, 0xA0, 0xA4, 0x05, 0xA8, 0x19,
  0x01, 0xA0, 0xC4, 0x09, 0xA0, 0x92, 0x0E, 0xA0, 0x22, 0x02, 0x0E, 0xA0, 0x92, 0x09, 0xA8, 0x3E,
  0x88, 0xEE, 0xA0, 0x92, 0x02, 0x0E, 0xD8, 0x25, 0xDF, 0x93, 0x89, 0x02, 0xBE, 0xEB, 0x40, 0xBF,
  0x91,
  // "Ų" (U+0172)
  0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60,
  0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A,
  0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03,
  0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x09, 0xA0, 0xD6, 0x03, 0xA0, 0x9A, 0x0D, 0x60, 0x3A, 0x82, 0x9E,
  0xFD, 0x60, 0x3A, 0x09, 0x0D, 0xA6, 0x05, 0xA0, 0x80, 0xAA, 0x03, 0x50, 0x9A, 0x00, 0x5A, 0x0C,
  0x40, 0x2B, 0x81, 0x10, 0xCA, 0x83, 0xD8, 0x79, 0xEA, 0x09, 0x20, 0x20, 0xDF, 0x0C, 0x58, 0x17,
  0xCE, 0xB0, 0xD0, 0x17, 0x28, 0x1B, 0xF2, 0x72, 0x81, 0x6F, 0x87, 0x38, 0x1D, 0xF3, 0x73, 0xA0,
  0x27, 0x3A, 0x81, 0xB7, 0x47, 0x10, 0xBB, 0x07, 0x71, 0x83, 0x1B, 0xEE, 0x52,
  // "ų" (U+0173)
  0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0,
  0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A,
  0x09, 0x02, 0xA0, 0x94, 0x03, 0xA0, 0x90, 0x2A, 0x09, 0x40, 0x3A, 0x09, 0x02, 0xA0, 0x94, 0x03,
  0xA0, 0x90, 0x2A, 0x09, 0x40, 0x4A, 0x09, 0x02, 0xA0, 0xA4, 0x05, 0xA0, 0x90, 0x1A, 0x0C, 0x40,
  0x9A, 0x81, 0x90, 0xEA, 0x02, 0x20, 0x20, 0xEA, 0x81, 0x90, 0x9A, 0x83, 0xE8, 0x8E, 0xEA, 0x82,
  0x90, 0x2E, 0xD8, 0x25, 0xDF, 0x92, 0x84, 0x2B, 0xEE, 0xB4, 0x1A, 0x09, 0x71, 0x81, 0x5F, 0x87,
  0x18, 0x12, 0xEC, 0x72, 0x81, 0x8F, 0x67, 0x28, 0x1C, 0xF5, 0x72, 0x83, 0xCF, 0xD7, 0x47, 0x08,
  0xB0, 0x97, 0x18, 0x29, 0xEE, 0x70,
  // "Ŵ" (U+0174)
  0x72, 0x82, 0x17, 0x76, 0x77, 0x50, 0x9B, 0x04, 0x77, 0x30, 0x4A, 0x81, 0xCF, 0xD7, 0x72, 0x86,
  0x1D, 0xF5, 0x0B, 0xFA, 0x77, 0x18, 0x1A, 0xF5, 0x38, 0x1A, 0xF6, 0x80, 0xE1, 0x00, 0xBA, 0x01,
  0x50, 0x4A, 0x09, 0x60, 0xCA, 0x01, 0x08, 0xA0, 0x45, 0x07, 0xA0, 0xC6, 0xA8, 0x1D, 0x05, 0xA0,
  0x75, 0x0B, 0xB5, 0x03, 0xA8, 0x1A, 0x01, 0xA0, 0xA5, 0x0E, 0xB0, 0x34, 0x06, 0xA0, 0x62, 0x81,
  0xEF, 0xD4, 0x02, 0xA8, 0x1E, 0xF6, 0x40, 0x9A, 0x03, 0x20, 0xAA, 0x01, 0x38, 0x45, 0xFE, 0xAF,
  0xA4, 0x0C, 0xA3, 0x07, 0xA0, 0x43, 0x84, 0x8F, 0xC8, 0xFD, 0x4A, 0x0C, 0x30, 0x4A, 0x07, 0x38,
  0x2C, 0xF9, 0x6A, 0x01, 0x20, 0x3A, 0x09, 0x30, 0x1A, 0x0A, 0x3A, 0x07, 0x03, 0xA0, 0x42, 0x06,
  0xA0, 0x64, 0x81, 0xDF, 0xD2, 0x03, 0xA0, 0x31, 0xA0, 0x72, 0x09, 0xA0, 0x24, 0x0A, 0xA8, 0x11,
  0x06, 0xA2, 0x81, 0xCF, 0xB2, 0x81, 0xCF, 0xE5, 0x06, 0xA8, 0x34, 0x0A, 0xFC, 0x28, 0x18, 0xFE,
  0x2A, 0x0B, 0x50, 0x3A, 0x83, 0x70, 0xDF, 0x92, 0x05, 0xA0, 0x20, 0x3A, 0x08, 0x6A, 0x0A, 0x1A,
  0x05, 0x20, 0x1A, 0x05, 0x06, 0xA0, 0x56, 0x82, 0xCF, 0xC3, 0xA0, 0x23, 0x82, 0xDF, 0x89, 0xA0,
  0x26, 0x09, 0xA8, 0x16, 0xFE, 0x48, 0x4A, 0xFA, 0xBF, 0xE7, 0x06, 0xA8, 0x1A, 0xFB, 0x48, 0x47,
  0xFC, 0xDF, 0xB7, 0x02, 0xA8, 0x1E, 0xF8, 0x48, 0x13, 0xFE, 0xA0, 0x77, 0x10, 0xEB, 0x04, 0x5C,
  0x04, 0x71, 0x0B, 0xB0, 0x15, 0x0C, 0xB0, 0x17, 0x10, 0x8A, 0x0D, 0x60, 0x9A, 0x0D, 0x50,
  // "ŵ" (U+0175)
  0x78, 0x21, 0x77, 0x67, 0x71, 0x09, 0xB0, 0x47, 0x60, 0x4A, 0x81, 0xCF, 0xD7, 0x58, 0x61, 0xDF,
  0x50, 0xBF, 0xA7, 0x48, 0x1A, 0xF5, 0x38, 0x1A, 0xF6, 0x80, 0xC7, 0x00, 0xAA, 0x02, 0x30, 0x1B,
  0x03, 0x48, 0x2E, 0xFB, 0x6A, 0x05, 0x30, 0x4B, 0x06, 0x30, 0x2A, 0x07, 0x03, 0xA0, 0x83, 0x08,
  0xB0, 0x93, 0x06, 0xA0, 0x41, 0xA0, 0xB3, 0x83, 0xBF, 0xCF, 0xD3, 0x09, 0xA8, 0x31, 0x0B, 0xFE,
  0x38, 0x1E, 0xF7, 0xA0, 0x12, 0x81, 0xCF, 0xC2, 0x08, 0xA8, 0x12, 0x03, 0xA0, 0x2A, 0x04, 0x2A,
  0x09, 0x20, 0x5A, 0x89, 0x15, 0x06, 0xFD, 0x0D, 0xF7, 0x03, 0xA0, 0x62, 0x01, 0xA8, 0x91, 0x80,
  0xAF, 0xA0, 0x9F, 0xA0, 0x6A, 0x02, 0x38, 0x95, 0xDF, 0xB0, 0xDF, 0x70, 0x6F, 0xD0, 0x9F, 0xE4,
  0x81, 0xAF, 0xE1, 0xA8, 0x14, 0x03, 0xA8, 0x21, 0xCF, 0xB4, 0x07, 0xA0, 0x4A, 0x01, 0x2A, 0x04,
  0xA0, 0x74, 0x03, 0xA8, 0x18, 0xFD, 0x38, 0x1C, 0xF8, 0xA0, 0x45, 0xA8, 0x1D, 0xF9, 0x38, 0x19,
  0xFD, 0xA6, 0x0C, 0xB0, 0x63, 0x06, 0xB0, 0xC6, 0x09, 0xB0, 0x33, 0x03, 0xB0, 0x96, 0x05, 0xB5,
  0xB0, 0x53,
  // "Ŷ" (U+0176)
  0x48, 0x21, 0x77, 0x67, 0x20, 0x9B, 0x04, 0x70, 0x4A, 0x81, 0xCF, 0xD6, 0x86, 0x1D, 0xF5, 0x0B,
  0xFA, 0x58, 0x1A, 0xF5, 0x38, 0x1A, 0xF6, 0x77, 0x77, 0x0C, 0xA0, 0x35, 0x02, 0xA0, 0xD0, 0x6A,
  0x09, 0x50, 0x8A, 0x83, 0x71, 0xEF, 0xE5, 0x0D, 0xA8, 0x11, 0x09, 0xA0, 0x53, 0x04, 0xA0, 0xA2,
  0x03, 0xA0, 0xB3, 0x0A, 0xA0, 0x43, 0x0D, 0xA8, 0x12, 0x01, 0xA0, 0xD4, 0x07, 0xA8, 0x18, 0x07,
  0xA0, 0x74, 0x01, 0xA8, 0x1E, 0x0C, 0xA0, 0x15, 0x0A, 0xA0, 0x8A, 0x0A, 0x60, 0x4D, 0x04, 0x70,
  0xDB, 0x0D, 0x71, 0x07, 0xB0, 0x87, 0x10, 0x1B, 0x02, 0x72, 0x81, 0xEF, 0xE7, 0x38, 0x1E, 0xFE,
  0x73, 0x81, 0xEF, 0xE7, 0x38, 0x1E, 0xFE, 0x73, 0x81, 0xEF, 0xE7, 0x38, 0x1E, 0xFE, 0x73, 0x81,
  0xEF, 0xE7, 0x38, 0x1E, 0xFE, 0x50,
  // "ŷ" (U+0177)
  0x48, 0x21, 0x77, 0x67, 0x10, 0x9B, 0x04, 0x60, 0x4A, 0x81, 0xCF, 0xD5, 0x86, 0x1D, 0xF5, 0x0B,
  0xFA, 0x48, 0x1A, 0xF5, 0x38, 0x1A, 0xF6, 0x77, 0x74, 0x0C, 0xA0, 0x25, 0x82, 0xEF, 0xE7, 0xA0,
  0x64, 0x03, 0xA0, 0x90, 0x2A, 0x0A, 0x40, 0x7A, 0x83, 0x50, 0xDF, 0xE4, 0x0B, 0xA8, 0x11, 0x09,
  0xA0, 0x23, 0x81, 0xEF, 0xC2, 0x04, 0xA0, 0x62, 0x03, 0xA0, 0x73, 0xA0, 0xB2, 0x07, 0xA0, 0x33,
  0x81, 0xBF, 0xE2, 0x81, 0xBF, 0xE4, 0x06, 0xA0, 0x31, 0xA0, 0xA4, 0x01, 0xA0, 0x70, 0x3A, 0x05,
  0x58, 0x2C, 0xFA, 0x7A, 0x01, 0x58, 0x48, 0xFD, 0xAF, 0xC6, 0x03, 0xA8, 0x1E, 0xF8, 0x70, 0xEB,
  0x03, 0x70, 0xAA, 0x0E, 0x71, 0x05, 0xA0, 0xA7, 0x10, 0x6A, 0x06, 0x71, 0x0A, 0xA0, 0x27, 0x1A,
  0x0C, 0x71, 0x07, 0xA0, 0x75, 0x81, 0x48, 0xAA, 0x0E, 0x01, 0x50, 0x6C, 0x05, 0x68, 0x35, 0xEF,
  0xC4, 0x70,
  // "Ÿ" (U+0178)
  0x28, 0x71, 0xDD, 0x10, 0x2D, 0xD1, 0x40, 0x5A, 0x81, 0x50, 0x6A, 0x04, 0x48, 0x71, 0xDD, 0x10,
  0x2D, 0xD1, 0x77, 0x77, 0x0C, 0xA0, 0x35, 0x02, 0xA0, 0xD0, 0x6A, 0x09, 0x50, 0x8A, 0x83, 0x71,
  0xEF, 0xE5, 0x0D, 0xA8, 0x11, 0x09, 0xA0, 0x53, 0x04, 0xA0, 0xA2, 0x03, 0xA0, 0xB3, 0x0A, 0xA0,
  0x43, 0x0D, 0xA8, 0x12, 0x01, 0xA0, 0xD4, 0x07, 0xA8, 0x18, 0x07, 0xA0, 0x74, 0x01, 0xA8, 0x1E,
  0x0C, 0xA0, 0x15, 0x0A, 0xA0, 0x8A, 0x0A, 0x60, 0x4D, 0x04, 0x70, 0xDB, 0x0D, 0x71, 0x07, 0xB0,
  0x87, 0x10, 0x1B, 0x02, 0x72, 0x81, 0xEF, 0xE7, 0x38, 0x1E, 0xFE, 0x73, 0x81, 0xEF, 0xE7, 0x38,
  0x1E, 0xFE, 0x73, 0x81, 0xEF, 0xE7, 0x38, 0x1E, 0xFE, 0x73, 0x81, 0xEF, 0xE7, 0x38, 0x1E, 0xFE,
  0x50,
  // "Ź" (U+0179)
  0x68, 0x23, 0x77, 0x67, 0x10, 0xDA, 0x06, 0x70, 0x7A, 0x07, 0x78, 0x22, 0xEF, 0x87, 0x18, 0x1B,
  0xF8, 0x77, 0x77, 0x2F, 0xB0, 0x61, 0xFB, 0x06, 0x18, 0x03, 0x60, 0xEA, 0x03, 0x70, 0x4A, 0x0B,
  0x71, 0x0B, 0xA0, 0x47, 0x02, 0xA0, 0xC7, 0x10, 0x9A, 0x06, 0x70, 0x1A, 0x0E, 0x71, 0x08, 0xA0,
  0x77, 0x18, 0x2E, 0xFE, 0x17, 0x06, 0xA0, 0x97, 0x10, 0xDA, 0x02, 0x70, 0x4A, 0x0A, 0x71, 0x0B,
  0xA0, 0x37, 0x03, 0xA0, 0xC7, 0x10, 0xAA, 0x05, 0x70, 0x1A, 0x0D, 0x71, 0x08, 0xA0, 0x67, 0x10,
  0xEA, 0x07, 0x80, 0x26, 0x04, 0x03, 0xFB, 0x09, 0x03, 0xFB, 0x09,
  // "ź" (U+017A)
  0x58, 0x23, 0x77, 0x66, 0x0D, 0xA0, 0x65, 0x07, 0xA0, 0x75, 0x82, 0x2E, 0xF8, 0x68, 0x1B, 0xF8,
  0x77, 0x74, 0x0E, 0xF8, 0x15, 0x0E, 0xF0, 0x51, 0x80, 0x16, 0x0E, 0xA0, 0x25, 0x03, 0xA0, 0xA6,
  0x0A, 0xA0, 0x35, 0x02, 0xA0, 0xB6, 0x09, 0xA0, 0x45, 0x02, 0xA0, 0xC6, 0x09, 0xA0, 0x55, 0x01,
  0xA0, 0xD6, 0x08, 0xA0, 0x55, 0x82, 0x1E, 0xFD, 0x60, 0x7A, 0x06, 0x60, 0xEA, 0x85, 0x76, 0x66,
  0x63, 0x3F, 0x90, 0x80, 0x3F, 0x90, 0x80,
  // "Ż" (U+017B)
  0x58, 0x15, 0xEB, 0x72, 0x0C, 0xA0, 0x37, 0x10, 0xCA, 0x02, 0x71, 0x81, 0x5E, 0xA7, 0x77, 0x71,
  0xFB, 0x06, 0x1F, 0xB0, 0x61, 0x80, 0x36, 0x0E, 0xA0, 0x37, 0x04, 0xA0, 0xB7, 0x10, 0xBA, 0x04,
  0x70, 0x2A, 0x0C, 0x71, 0x09, 0xA0, 0x67, 0x01, 0xA0, 0xE7, 0x10, 0x8A, 0x07, 0x71, 0x82, 0xEF,
  0xE1, 0x70, 0x6A, 0x09, 0x71, 0x0D, 0xA0, 0x27, 0x04, 0xA0, 0xA7, 0x10, 0xBA, 0x03, 0x70, 0x3A,
  0x0C, 0x71, 0x0A, 0xA0, 0x57, 0x01, 0xA0, 0xD7, 0x10, 0x8A, 0x06, 0x71, 0x0E, 0xA0, 0x78, 0x02,
  0x60, 0x40, 0x3F, 0xB0, 0x90, 0x3F, 0xB0, 0x90,
  // "ż" (U+017C)
  0x48, 0x15, 0xEB, 0x70, 0xCA, 0x03, 0x60, 0xCA, 0x02, 0x68, 0x15, 0xEA, 0x77, 0x73, 0x0E, 0xF8,
  0x15, 0x0E, 0xF0, 0x51, 0x80, 0x16, 0x0E, 0xA0, 0x25, 0x03, 0xA0, 0xA6, 0x0A, 0xA0, 0x35, 0x02,
  0xA0, 0xB6, 0x09, 0xA0, 0x45, 0x02, 0xA0, 0xC6, 0x09, 0xA0, 0x55, 0x01, 0xA0, 0xD6, 0x08, 0xA0,
  0x55, 0x82, 0x1E, 0xFD, 0x60, 0x7A, 0x06, 0x60, 0xEA, 0x85, 0x76, 0x66, 0x63, 0x3F, 0x90, 0x80,
  0x3F, 0x90, 0x80,
  // "Ž" (U+017D)
  0x20, 0x60, 0x74, 0x81, 0x27, 0x43, 0x87, 0x6F, 0xC1, 0x03, 0xEE, 0x24, 0x85, 0xAF, 0xB3, 0xEF,
  0x55, 0x01, 0x0D, 0xB0, 0x97, 0x05, 0xA0, 0xE0, 0x17, 0x77, 0x7F, 0xB0, 0x61, 0xFB, 0x06, 0x18,
  0x03, 0x60, 0xEA, 0x03, 0x70, 0x4A, 0x0B, 0x71, 0x0B, 0xA0, 0x47, 0x02, 0xA0, 0xC7, 0x10, 0x9A,
  0x06, 0x70, 0x1A, 0x0E, 0x71, 0x08, 0xA0, 0x77, 0x18, 0x2E, 0xFE, 0x17, 0x06, 0xA0, 0x97, 0x10,
  0xDA, 0x02, 0x70, 0x4A, 0x0A, 0x71, 0x0B, 0xA0, 0x37, 0x03, 0xA0, 0xC7, 0x10, 0xAA, 0x05, 0x70,
  0x1A, 0x0D, 0x71, 0x08, 0xA0, 0x67, 0x10, 0xEA, 0x07, 0x80, 0x26, 0x04, 0x03, 0xFB, 0x09, 0x03,
  0xFB, 0x09,
  // "ž" (U+017E)
  0x10, 0x60, 0x74, 0x89, 0x32, 0x74, 0x06, 0xFC, 0x10, 0x3E, 0xE2, 0x28, 0x5A, 0xFB, 0x3E, 0xF5,
  0x30, 0x10, 0xDB, 0x09, 0x50, 0x5A, 0x0E, 0x01, 0x77, 0x72, 0x0E, 0xF8, 0x15, 0x0E, 0xF0, 0x51,
  0x80, 0x16, 0x0E, 0xA0, 0x25, 0x03, 0xA0, 0xA6, 0x0A, 0xA0, 0x35, 0x02, 0xA0, 0xB6, 0x09, 0xA0,
  0x45, 0x02, 0xA0, 0xC6, 0x09, 0xA0, 0x55, 0x01, 0xA0, 0xD6, 0x08, 0xA0, 0x55, 0x82, 0x1E, 0xFD,
  0x60, 0x7A, 0x06, 0x60, 0xEA, 0x85, 0x76, 0x66, 0x63, 0x3F, 0x90, 0x80, 0x3F, 0x90, 0x80,
  // "ſ" (U+017F)
  0x18, 0x62, 0xBE, 0xEC, 0x61, 0xEC, 0x06, 0x08, 0xA8, 0x3C, 0x7A, 0x2C, 0xA0, 0x13, 0x81, 0xEF,
  0xD4, 0x81, 0xEF, 0xC4, 0x81, 0xEF, 0xC4, 0x81, 0xEF, 0xC4, 0x81, 0xEF, 0xC4, 0x81, 0xEF, 0xC4,
  0x81, 0xEF, 0xC4, 0x81, 0xEF, 0xC4, 0x81, 0xEF, 0xC4, 0x81, 0xEF, 0xC4, 0x81, 0xEF, 0xC4, 0x81,
  0xEF, 0xC4, 0x81, 0xEF, 0xC4, 0x81, 0xEF, 0xC4, 0x81, 0xEF, 0xC4, 0x81, 0xEF, 0xC4, 0x81, 0xEF,
  0xC4, 0x81, 0xEF, 0xC4,
  // "Ω" (U+03A9)
  0x58, 0x63, 0x9D, 0xEE, 0xC8, 0x17, 0x10, 0x9F, 0x0E, 0x05, 0x60, 0x9B, 0x82, 0xA7, 0x7B, 0xB0,
  0x54, 0x04, 0xA0, 0xE0, 0x34, 0x06, 0xA0, 0xE0, 0x13, 0x0B, 0xA0, 0x66, 0x0A, 0xA0, 0x62, 0x01,
  0xA0, 0xE7, 0x03, 0xA0, 0xB2, 0x04, 0xA0, 0xB7, 0x18, 0x1E, 0xFE, 0x20, 0x6A, 0x08, 0x71, 0x0C,
  0xA8, 0x11, 0x07, 0xA0, 0x77, 0x10, 0xBA, 0x81, 0x20, 0x7A, 0x07, 0x71, 0x0B, 0xA8, 0x13, 0x06,
  0xA0, 0x87, 0x10, 0xBA, 0x81, 0x10, 0x5A, 0x09, 0x71, 0x0C, 0xA2, 0x03, 0xA0, 0xA7, 0x18, 0x1E,
  0xFE, 0x38, 0x1E, 0xFD, 0x70, 0x2A, 0x0A, 0x30, 0xAA, 0x01, 0x60, 0x5A, 0x05, 0x30, 0x4A, 0x07,
  0x68, 0x1A, 0xFE, 0x58, 0x1B, 0xFE, 0x50, 0x3A, 0x07, 0x58, 0x22, 0xEF, 0x94, 0x81, 0xCF, 0xB3,
  0x83, 0x16, 0x66, 0xAA, 0x06, 0x20, 0xAA, 0x83, 0x76, 0x66, 0x2E, 0x09, 0x20, 0xED, 0x0E, 0x02,
  0xE0, 0x92, 0x0E, 0xD0, 0xE0,
  // "μ" (U+03BC)
  0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0,
  0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A,
  0x09, 0x01, 0xA0, 0xA4, 0x01, 0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x1A, 0x09, 0x01, 0xA0, 0xA4, 0x01,
  0xA0, 0x90, 0x1A, 0x0A, 0x40, 0x2A, 0x09, 0x01, 0xA0, 0xB4, 0x04, 0xA0, 0x90, 0x1A, 0x0D, 0x40,
  0x8A, 0x09, 0x01, 0xB0, 0x32, 0x01, 0x0E, 0xA0, 0x90, 0x1B, 0x83, 0xE8, 0x8D, 0xEA, 0x09, 0x01,
  0xF8, 0x37, 0xCF, 0x91, 0xA8, 0x90, 0x99, 0xED, 0x70, 0x9F, 0x91, 0xA0, 0x97, 0x10, 0x1A, 0x0A,
  0x71, 0x01, 0xA0, 0xA7, 0x10, 0x1A, 0x0A, 0x71, 0x01, 0xA0, 0xA7, 0x10, 0x1A, 0x0A, 0x71, 0x01,
  0xA0, 0xA7, 0x10,
  // "π" (U+03C0)
  0x01, 0x0B, 0xFE, 0x0B, 0xFF, 0x81, 0x56, 0x9A, 0x83, 0xA6, 0x66, 0x9A, 0x81, 0xB6, 0x62, 0x04,
  0xA0, 0x63, 0x03, 0xA0, 0x84, 0x04, 0xA0, 0x63, 0x03, 0xA0, 0x84, 0x04, 0xA0, 0x63, 0x03, 0xA0,
  0x84, 0x04, 0xA0, 0x63, 0x03, 0xA0, 0x84, 0x04, 0xA0, 0x63, 0x03, 0xA0, 0x84, 0x04, 0xA0, 0x63,
  0x03, 0xA0, 0x84, 0x04, 0xA0, 0x63, 0x03, 0xA0, 0x84, 0x04, 0xA0, 0x63, 0x03, 0xA0, 0x84, 0x04,
  0xA0, 0x63, 0x03, 0xA0, 0x84, 0x04, 0xA0, 0x63, 0x03, 0xA0, 0x94, 0x04, 0xA0, 0x63, 0x01, 0xA8,
  0x1E, 0x77, 0x20, 0x4A, 0x06, 0x40, 0xBB, 0x0C, 0x20, 0x4A, 0x06, 0x48, 0x31, 0xBF, 0xE8,
  // "–" (U+2013)
  0x80, 0x90, 0x6F, 0xFF, 0xB0,
  // "—" (U+2014)
  0x80, 0xA6, 0x68, 0x0E, 0x0F,
  // "€" (U+20AC)
  0x68, 0x57, 0xDF, 0xEC, 0x71, 0x50, 0xCE, 0x0B, 0x40, 0xBA, 0x84, 0xC7, 0x8C, 0xF5, 0x30, 0x4A,
  0x0A, 0x40, 0x54, 0x0B, 0xA0, 0x17, 0x10, 0x1A, 0x0B, 0x72, 0x04, 0xA0, 0x77, 0x20, 0x7A, 0x04,
  0x70, 0x7F, 0xA0, 0x12, 0x07, 0xFA, 0x01, 0x28, 0x13, 0x6D, 0xA0, 0x78, 0x00, 0x65, 0x0B, 0xA0,
  0x17, 0x07, 0xF9, 0x06, 0x38, 0x16, 0xDE, 0xA8, 0x3E, 0xDD, 0xD6, 0x50, 0x6A, 0x05, 0x72, 0x03,
  0xA0, 0x97, 0x38, 0x1E, 0xFE, 0x73, 0x07, 0xA0, 0x95, 0x01, 0x40, 0xDA, 0x84, 0xC7, 0x79, 0xE7,
  0x40, 0x20, 0xEE, 0x07, 0x58, 0x61, 0x8D, 0xFE, 0xC8, 0x20,
  // "₿" (U+20BF)
  0x28, 0x45, 0x70, 0x37, 0x15, 0x84, 0xAE, 0x06, 0xF2, 0x58, 0x4A, 0xE0, 0x6F, 0x23, 0x0C, 0xE0,
  0x73, 0x0C, 0xF8, 0x2C, 0x10, 0xCA, 0x81, 0x67, 0x9B, 0x81, 0x90, 0xCA, 0x30, 0x3A, 0x81, 0xE0,
  0xCA, 0x40, 0xCA, 0x01, 0x0C, 0xA4, 0x0A, 0xA0, 0x20, 0xCA, 0x40, 0xCA, 0x01, 0x0C, 0xA3, 0x84,
  0x1E, 0xFD, 0x0C, 0xA2, 0x02, 0x0B, 0xA8, 0x16, 0x0C, 0xF0, 0x82, 0x0C, 0xE0, 0xE0, 0x62, 0x0C,
  0xA8, 0x26, 0x68, 0xDA, 0x81, 0x90, 0xCA, 0x30, 0x10, 0xDA, 0x03, 0x0C, 0xA4, 0x07, 0xA0, 0x70,
  0xCA, 0x40, 0x5A, 0x09, 0x0C, 0xA4, 0x05, 0xA0, 0x80, 0xCA, 0x40, 0x7A, 0x07, 0x0C, 0xA3, 0x01,
  0x0D, 0xA0, 0x30, 0xCA, 0x82, 0x66, 0x8D, 0xA8, 0x1C, 0x0C, 0xF8, 0x2E, 0x20, 0xCE, 0x09, 0x01,
  0x48, 0x4A, 0xE0, 0x6F, 0x25, 0x84, 0xAE, 0x06, 0xF2, 0x58, 0x4A, 0xD0, 0x6F, 0x23,
  // "‘" (U+2018)
  0x28, 0x15, 0xFD, 0x28, 0x3B, 0xF9, 0x01, 0xA8, 0x16, 0x07, 0xA8, 0x13, 0x0B, 0xA2, 0xA8, 0x1D,
  0x04, 0xA0, 0xB1,
  // "’" (U+2019)
  0x10, 0x2A, 0x81, 0xC0, 0x4A, 0x81, 0x90, 0x7A, 0x81, 0x40, 0xAA, 0x28, 0x1C, 0xFA, 0x2A, 0x83,
  0x40, 0x3F, 0xE2,
  // "‚" (U+201A)
  0x10, 0x2A, 0x81, 0xC0, 0x4A, 0x81, 0x90, 0x7A, 0x81, 0x40, 0xAA, 0x28, 0x1C, 0xFA, 0x2A, 0x83,
  0x40, 0x3F, 0xE2,
  // "‛" (U+201B)
  0x04, 0xA0, 0xB2, 0xA0, 0xD2, 0x0B, 0xA2, 0x07, 0xA8, 0x13, 0x01, 0xA0, 0x62, 0x81, 0xBF, 0x92,
  0x81, 0x5F, 0xD0,
  // "“" (U+201C)
  0x28, 0x15, 0xFD, 0x28, 0x13, 0xFE, 0x28, 0x1B, 0xF9, 0x28, 0x39, 0xFB, 0x01, 0xA0, 0x62, 0x83,
  0xEF, 0x80, 0x7A, 0x81, 0x30, 0x5A, 0x81, 0x50, 0xBA, 0x20, 0x9A, 0x02, 0x1A, 0x0D, 0x20, 0xDA,
  0x10, 0x4A, 0x81, 0xB0, 0x2A, 0x0D, 0x10,
  // "”" (U+201D)
  0x10, 0x2A, 0x0C, 0x2A, 0x81, 0xE0, 0x4A, 0x81, 0x90, 0x2A, 0x81, 0xB0, 0x7A, 0x81, 0x40, 0x5A,
  0x81, 0x70, 0xAA, 0x20, 0x7A, 0x83, 0x20, 0xCF, 0xA2, 0x81, 0xBF, 0xC2, 0xA0, 0x42, 0x85, 0xEF,
  0x60, 0x3F, 0xE2, 0x02, 0xA0, 0x11,
  // "„" (U+201E)
  0x10, 0x2A, 0x0C, 0x2A, 0x81, 0xE0, 0x4A, 0x81, 0x90, 0x2A, 0x81, 0xB0, 0x7A, 0x81, 0x40, 0x5A,
  0x81, 0x70, 0xAA, 0x20, 0x7A, 0x83, 0x20, 0xCF, 0xA2, 0x81, 0xBF, 0xC2, 0xA0, 0x42, 0x85, 0xEF,
  0x60, 0x3F, 0xE2, 0x02, 0xA0, 0x11,
  // "‟" (U+201F)
  0x04, 0xA8, 0x1B, 0x02, 0xA0, 0xD2, 0xA0, 0xD2, 0x0D, 0xA2, 0x0B, 0xA2, 0x09, 0xA8, 0x12, 0x07,
  0xA8, 0x13, 0x05, 0xA8, 0x15, 0x01, 0xA0, 0x62, 0x81, 0xEF, 0x82, 0x81, 0xBF, 0x92, 0x81, 0x9F,
  0xB2, 0x81, 0x5F, 0xD2, 0x81, 0x3F, 0xE0,
  // "†" (U+2020)
  0x40, 0xCA, 0x71, 0x81, 0xBF, 0xE7, 0x18, 0x19, 0xFD, 0x71, 0x81, 0x8F, 0xB7, 0x18, 0x16, 0xF9,
  0x40, 0x01, 0x28, 0x15, 0xF8, 0x28, 0x11, 0x16, 0xA8, 0x3E, 0xDF, 0xEE, 0xA0, 0xB0, 0x6F, 0xA8,
  0x92, 0xB2, 0x32, 0x14, 0xF7, 0x12, 0x33, 0x48, 0x15, 0xF8, 0x71, 0x81, 0x5F, 0x97, 0x18, 0x16,
  0xF9, 0x71, 0x81, 0x7F, 0xA7, 0x18, 0x17, 0xFB, 0x71, 0x81, 0x8F, 0xB7, 0x18, 0x19, 0xFC, 0x71,
  0x81, 0x9F, 0xD7, 0x18, 0x1A, 0xFD, 0x71, 0x81, 0xAF, 0xE7, 0x10, 0xBA, 0x71, 0x0C, 0xA7, 0x10,
  0xCA, 0x01, 0x30,
  // "‡" (U+2021)
  0x40, 0xBA, 0x01, 0x78, 0x1A, 0xFE, 0x71, 0x81, 0x8F, 0xD7, 0x18, 0x16, 0xFB, 0x71, 0x81, 0x5F,
  0xA4, 0x89, 0x25, 0xB9, 0x89, 0xFB, 0x79, 0xA9, 0x7F, 0xA8, 0x92, 0xC4, 0x98, 0x78, 0xFB, 0x78,
  0x98, 0x48, 0x15, 0xFA, 0x71, 0x81, 0x7F, 0xC7, 0x18, 0x19, 0xFD, 0x71, 0x81, 0x9F, 0xD7, 0x18,
  0x18, 0xFC, 0x71, 0x81, 0x6F, 0xA4, 0x89, 0x23, 0x64, 0x36, 0xF9, 0x34, 0x55, 0x7F, 0xA8, 0x92,
  0xC7, 0xFD, 0xCC, 0xFD, 0xCD, 0xEC, 0x48, 0x15, 0xF9, 0x71, 0x81, 0x6F, 0xB7, 0x18, 0x18, 0xFD,
  0x71, 0x81, 0x9F, 0xE7, 0x10, 0xBA, 0x01, 0x30,
  // "•" (U+2022)
  0x28, 0x37, 0xDE, 0xC4, 0x20, 0x9D, 0x03, 0x1E, 0x0A, 0x02, 0xE0, 0xC0, 0x2E, 0x0B, 0x1E, 0x81,
  0x90, 0x8D, 0x02, 0x28, 0x37, 0xDF, 0xC4, 0x10,
  // "…" (U+2026)
  0x18, 0x1A, 0xE9, 0x48, 0x1A, 0xE9, 0x48, 0x3A, 0xE9, 0x03, 0xB0, 0x22, 0x03, 0xB0, 0x22, 0x03,
  0xB0, 0x20, 0x3B, 0x02, 0x20, 0x3B, 0x02, 0x20, 0x3B, 0x83, 0x20, 0xAE, 0x94, 0x81, 0xAE, 0x94,
  0x81, 0xAE, 0x91,
  // "‰" (U+2030)
  0x18, 0x31, 0xBE, 0xD6, 0x68, 0x1B, 0xF7, 0x77, 0x0C, 0xC0, 0x64, 0x02, 0xA0, 0x17, 0x60, 0x5A,
  0x82, 0x8C, 0xFE, 0x48, 0x18, 0xFA, 0x77, 0x83, 0x9F, 0xA0, 0x2A, 0x03, 0x38, 0x1E, 0xF4, 0x77,
  0x81, 0xCF, 0x62, 0x81, 0xDF, 0x62, 0x81, 0x5F, 0xD7, 0x71, 0x81, 0xDF, 0x52, 0x81, 0xCF, 0x72,
  0x81, 0xBF, 0x77, 0x71, 0x81, 0xDF, 0x52, 0x83, 0xBF, 0x80, 0x2A, 0x01, 0x77, 0x18, 0x1D, 0xF5,
  0x28, 0x5B, 0xF7, 0x08, 0xFA, 0x77, 0x28, 0x1B, 0xF7, 0x28, 0x92, 0xDF, 0x60, 0xEF, 0x40, 0x9E,
  0xE8, 0x48, 0x33, 0xCF, 0xD4, 0x28, 0x39, 0xFA, 0x01, 0xA8, 0x43, 0x5F, 0xD0, 0xAC, 0x08, 0x20,
  0x10, 0xEC, 0x81, 0x30, 0x4A, 0x87, 0x8B, 0xFE, 0x0B, 0xF7, 0x2A, 0x04, 0x05, 0xA8, 0x71, 0x07,
  0xFD, 0x2A, 0xFB, 0x20, 0xCC, 0x06, 0x02, 0xA8, 0x21, 0x7F, 0xB2, 0x87, 0xDF, 0x60, 0xCF, 0x70,
  0x2A, 0x28, 0x93, 0x1A, 0xED, 0x70, 0x8F, 0xA0, 0x9F, 0x92, 0x85, 0xAF, 0x90, 0xEF, 0x42, 0xA0,
  0x37, 0x85, 0xEF, 0x40, 0xAF, 0x82, 0x81, 0x9F, 0xA1, 0xA0, 0x32, 0x81, 0xEF, 0x46, 0x81, 0x5F,
  0xD2, 0x81, 0xBF, 0x72, 0x82, 0x9F, 0xB1, 0xA0, 0x32, 0x81, 0xEF, 0x56, 0x81, 0xBF, 0x72, 0x81,
  0xAF, 0x82, 0x81, 0x9F, 0xA1, 0xA0, 0x32, 0xA0, 0x45, 0x02, 0xA0, 0x12, 0x81, 0x9F, 0x92, 0x87,
  0xBF, 0x90, 0xEF, 0x40, 0x1A, 0x03, 0x58, 0x18, 0xFB, 0x38, 0x16, 0xFD, 0x28, 0x7E, 0xF6, 0x0B,
  0xF8, 0x04, 0xA6, 0x81, 0xEF, 0x43, 0x01, 0xA0, 0x90, 0xAA, 0x87, 0x10, 0x7F, 0xE7, 0xDF, 0xB5,
  0x81, 0x5F, 0xD5, 0x09, 0xC0, 0x92, 0x01, 0x0E, 0xC0, 0x35, 0x81, 0xBF, 0x76, 0x82, 0x9E, 0xE8,
  0x48, 0x32, 0xBF, 0xD5, 0x20,
  // "‹" (U+2039)
  0x40, 0x25, 0x81, 0x5F, 0xA3, 0x82, 0x2E, 0xFB, 0x38, 0x2C, 0xFE, 0x12, 0x09, 0xA0, 0x52, 0x05,
  0xA0, 0xB3, 0x0E, 0xA0, 0x33, 0x06, 0xA0, 0xA4, 0x0A, 0xA0, 0x54, 0x82, 0xDF, 0xE1, 0x30, 0x2A,
  0x0A, 0x48, 0x26, 0xFB, 0x14, 0x03, 0x20,
  // "›" (U+203A)
  0x10, 0x15, 0x81, 0x8F, 0x84, 0x07, 0xA0, 0x54, 0x82, 0xCF, 0xE2, 0x30, 0x2A, 0x0C, 0x40, 0x7A,
  0x09, 0x40, 0xEA, 0x03, 0x20, 0x6A, 0x0A, 0x28, 0x22, 0xEF, 0xD3, 0x0B, 0xA0, 0x22, 0x06, 0xA0,
  0x63, 0x81, 0x8F, 0x95, 0x02, 0x50,
  // "⁄" (U+2044)
  0x73, 0x81, 0x7F, 0xC7, 0x38, 0x1E, 0xF5, 0x72, 0x81, 0x7F, 0xC7, 0x38, 0x1E, 0xF4, 0x72, 0x81,
  0x7F, 0xC7, 0x28, 0x21, 0xEF, 0x47, 0x28, 0x17, 0xFC, 0x72, 0x82, 0x1E, 0xF4, 0x72, 0x81, 0x8F,
  0xC7, 0x28, 0x21, 0xEF, 0x47, 0x28, 0x18, 0xFB, 0x72, 0x82, 0x1E, 0xF4, 0x72, 0x81, 0x8F, 0xB7,
  0x20, 0x1A, 0x03, 0x72, 0x81, 0x8F, 0xB7, 0x20, 0x1A, 0x03, 0x72, 0x81, 0x9F, 0xB7, 0x20, 0x1A,
  0x03, 0x72, 0x81, 0x9F, 0xB7, 0x20, 0x2A, 0x03, 0x72, 0x81, 0x9F, 0xA7, 0x30,
  // "™" (U+2122)
  0x06, 0x80, 0x29, 0x18, 0x19, 0x94, 0x48, 0x28, 0x94, 0xAE, 0x01, 0xA0, 0xC3, 0x03, 0xA0, 0x72,
  0x81, 0x2F, 0x83, 0xB0, 0x12, 0x08, 0xA0, 0x72, 0x81, 0x2F, 0x83, 0x98, 0x1B, 0xF6, 0x28, 0x2D,
  0xBF, 0x72, 0x81, 0x2F, 0x83, 0x98, 0x79, 0xDB, 0x03, 0xF6, 0xF7, 0x28, 0x12, 0xF8, 0x39, 0x87,
  0x97, 0xF1, 0x8D, 0x2F, 0x72, 0x81, 0x2F, 0x83, 0x98, 0x79, 0x2F, 0x5D, 0x82, 0xF7, 0x28, 0x12,
  0xF8, 0x39, 0x87, 0x90, 0xDD, 0xF2, 0x2F, 0x72, 0x81, 0x2F, 0x83, 0x98, 0x79, 0x07, 0xFC, 0x02,
  0xF7, 0x28, 0x12, 0xF8, 0x39, 0x87, 0x90, 0x2F, 0x70, 0x2F, 0x70,
  // "⅒" (U+2152)
  0x76, 0x81, 0x7F, 0xC7, 0x68, 0x22, 0xCF, 0x87, 0x81, 0xEF, 0x57, 0x50, 0x40, 0xEA, 0x08, 0x68,
  0x17, 0xFC, 0x75, 0x07, 0xA8, 0x1C, 0xF8, 0x68, 0x1E, 0xF4, 0x75, 0x84, 0x7E, 0x38, 0xF8, 0x58,
  0x17, 0xFC, 0x77, 0x83, 0x10, 0x9F, 0x84, 0x82, 0x1E, 0xF4, 0x77, 0x28, 0x19, 0xF8, 0x48, 0x17,
  0xFC, 0x77, 0x38, 0x19, 0xF8, 0x38, 0x21, 0xEF, 0x47, 0x73, 0x81, 0x9F, 0x83, 0x81, 0x8F, 0xC7,
  0x74, 0x81, 0x9F, 0x82, 0x87, 0x1E, 0xF4, 0x02, 0xCF, 0x83, 0x83, 0x3B, 0xDB, 0x55, 0x81, 0x9F,
  0x82, 0x84, 0x8F, 0xB0, 0x4E, 0xA0, 0x82, 0x03, 0xD0, 0x54, 0x87, 0x9F, 0x80, 0x1E, 0xF4, 0x7A,
  0x81, 0xCF, 0x82, 0x85, 0xBF, 0xA0, 0x7F, 0xE4, 0x89, 0x69, 0xF8, 0x08, 0xFB, 0x07, 0xE3, 0x8F,
  0x80, 0x1A, 0x02, 0x28, 0x1E, 0xF4, 0x60, 0x1A, 0x03, 0x28, 0x51, 0x09, 0xF8, 0x03, 0xA3, 0x81,
  0xBF, 0x76, 0x81, 0x8F, 0xB5, 0x85, 0x9F, 0x80, 0x5F, 0xD3, 0x81, 0x9F, 0x95, 0x01, 0xA0, 0x35,
  0x85, 0x9F, 0x80, 0x5F, 0xD3, 0x81, 0x9F, 0xA5, 0x81, 0x9F, 0xB6, 0x85, 0x9F, 0x80, 0x4F, 0xD3,
  0x81, 0x9F, 0x94, 0x01, 0xA0, 0x36, 0x83, 0x9F, 0x80, 0x3A, 0x38, 0x1B, 0xF7, 0x48, 0x19, 0xFB,
  0x78, 0x19, 0xF8, 0x2A, 0x02, 0x28, 0x1E, 0xF5, 0x30, 0x2A, 0x03, 0x78, 0x19, 0xF8, 0x28, 0x6B,
  0xF9, 0x05, 0xFE, 0x13, 0x81, 0x9F, 0xA7, 0x18, 0x19, 0xF8, 0x20, 0x3A, 0x0E, 0xA0, 0x77, 0x77,
  0x83, 0x4C, 0xFD, 0x72,
  // "ﬁ" (U+FB01)
  0x38, 0x90, 0x19, 0xEF, 0xD9, 0x0A, 0xE6, 0x30, 0xCC, 0x0B, 0x02, 0xA0, 0xC2, 0x04, 0xA8, 0x3D,
  0x78, 0x52, 0xA0, 0xC2, 0x08, 0xA0, 0x44, 0x81, 0xAE, 0x52, 0x09, 0xA0, 0x27, 0x20, 0xAA, 0x01,
  0x70, 0x20, 0xAD, 0x81, 0xD0, 0x1A, 0x00, 0xAE, 0x81, 0xD0, 0x1A, 0x82, 0xA4, 0x6C, 0xA8, 0x37,
  0x66, 0x01, 0xA0, 0xA2, 0x0A, 0xA0, 0x13, 0x01, 0xA0, 0xA2, 0x0A, 0xA0, 0x13, 0x01, 0xA0, 0xA2,
  0x0A, 0xA0, 0x13, 0x01, 0xA0, 0xA2, 0x0A, 0xA0, 0x13, 0x01, 0xA0, 0xA2, 0x0A, 0xA0, 0x13, 0x01,
  0xA0, 0xA2, 0x0A, 0xA0, 0x13, 0x01, 0xA0, 0xA2, 0x0A, 0xA0, 0x13, 0x01, 0xA0, 0xA2, 0x0A, 0xA0,
  0x13, 0x01, 0xA0, 0xA2, 0x0A, 0xA0, 0x13, 0x01, 0xA0, 0xA2, 0x0A, 0xA0, 0x13, 0x01, 0xA0, 0xA2,
  0x0A, 0xA0, 0x13, 0x01, 0xA0, 0xA2, 0x0A, 0xA0, 0x13, 0x01, 0xA0, 0xA2, 0x0A, 0xA0, 0x13, 0x01,
  0xA0, 0xA0,
  // "ﬂ" (U+FB02)
  0x38, 0x51, 0x9E, 0xFD, 0x91, 0xA0, 0xA3, 0x0C, 0xC0, 0xB0, 0x1A, 0x0A, 0x20, 0x4A, 0x83, 0xD7,
  0x85, 0x1A, 0x0A, 0x20, 0x8A, 0x04, 0x30, 0x1A, 0x0A, 0x20, 0x9A, 0x02, 0x30, 0x1A, 0x0A, 0x20,
  0xAA, 0x01, 0x30, 0x1A, 0x81, 0xA2, 0xAD, 0x81, 0xD0, 0x1A, 0x00, 0xAE, 0x81, 0xD0, 0x1A, 0x82,
  0xA4, 0x6C, 0xA8, 0x37, 0x66, 0x01, 0xA0, 0xA2, 0x0A, 0xA0, 0x13, 0x01, 0xA0, 0xA2, 0x0A, 0xA0,
  0x13, 0x01, 0xA0, 0xA2, 0x0A, 0xA0, 0x13, 0x01, 0xA0, 0xA2, 0x0A, 0xA0, 0x13, 0x01, 0xA0, 0xA2,
  0x0A, 0xA0, 0x13, 0x01, 0xA0, 0xA2, 0x0A, 0xA0, 0x13, 0x01, 0xA0, 0xA2, 0x0A, 0xA0, 0x13, 0x01,
  0xA0, 0xA2, 0x0A, 0xA0, 0x13, 0x01, 0xA0, 0xA2, 0x0A, 0xA0, 0x13, 0x01, 0xA0, 0xA2, 0x0A, 0xA0,
  0x13, 0x01, 0xA0, 0xA2, 0x0A, 0xA0, 0x13, 0x01, 0xA0, 0xA2, 0x0A, 0xA0, 0x13, 0x01, 0xA0, 0xA2,
  0x0A, 0xA0, 0x13, 0x01, 0xA0, 0xA0,
};

const Font& font_NotoSans_CondensedMedium_28() {
  static SmoothFont font(font_NotoSans_CondensedMedium_28_data);
  return font;
}

}  // namespace roo_display
