#include "15.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedMedium (Noto Sans Condensed Medium)
// Generated on Thu Mar 30 23:43:28 CEST 2023
static const uint8_t font_NotoSans_CondensedMedium_15_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x04, 0x4C,
  0xFD, 0xFD, 0x0F, 0x0F, 0x0B, 0xFD, 0x05, 0x02, 0x10, 0x05, 0x04, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x01, 0x01, 0x02, 0x0A, 0x04, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x00, 0x08, 0x05, 0x0A, 0x06, 0x00, 0x0C, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x00, 0x17, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x06, 0x0B, 0x07, 0x00, 0x40, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x00, 0x66, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x00, 0xA2, // "&" (U+0026)
  0x00, 0x27, 0x00, 0x08, 0x02, 0x0A, 0x03, 0x00, 0xCE, // "'" (U+0027)
  0x00, 0x28, 0x00, 0xFF, 0x03, 0x0A, 0x05, 0x00, 0xD4, // "(" (U+0028)
  0x00, 0x29, 0x00, 0xFF, 0x03, 0x0A, 0x05, 0x00, 0xF0, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x06, 0x06, 0x0B, 0x07, 0x01, 0x0D, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x03, 0x06, 0x09, 0x07, 0x01, 0x25, // "+" (U+002B)
  0x00, 0x2C, 0x00, 0xFF, 0x02, 0x02, 0x04, 0x01, 0x37, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x04, 0x03, 0x05, 0x04, 0x01, 0x3F, // "-" (U+002D)
  0x00, 0x2E, 0x01, 0x01, 0x02, 0x02, 0x04, 0x01, 0x43, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x01, 0x46, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x01, 0x61, // "0" (U+0030)
  0x00, 0x31, 0x01, 0x01, 0x04, 0x0A, 0x07, 0x01, 0x89, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x01, 0x9F, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x01, 0xC0, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x01, 0xE4, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x02, 0x06, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x02, 0x29, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x02, 0x50, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x02, 0x6E, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x02, 0x95, // "9" (U+0039)
  0x00, 0x3A, 0x01, 0x01, 0x02, 0x08, 0x04, 0x02, 0xBC, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0xFF, 0x02, 0x08, 0x04, 0x02, 0xC3, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x03, 0x06, 0x09, 0x07, 0x02, 0xCF, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x03, 0x06, 0x07, 0x07, 0x02, 0xE6, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x03, 0x06, 0x09, 0x07, 0x02, 0xF4, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x03, 0x0A, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFF, 0x0A, 0x0A, 0x0B, 0x03, 0x26, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x03, 0x65, // "A" (U+0041)
  0x00, 0x42, 0x01, 0x01, 0x07, 0x0A, 0x08, 0x03, 0x8C, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x03, 0xB4, // "C" (U+0043)
  0x00, 0x44, 0x01, 0x01, 0x07, 0x0A, 0x09, 0x03, 0xD7, // "D" (U+0044)
  0x00, 0x45, 0x01, 0x01, 0x06, 0x0A, 0x07, 0x03, 0xFE, // "E" (U+0045)
  0x00, 0x46, 0x01, 0x01, 0x06, 0x0A, 0x06, 0x04, 0x19, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x04, 0x33, // "G" (U+0047)
  0x00, 0x48, 0x01, 0x01, 0x07, 0x0A, 0x09, 0x04, 0x5F, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x04, 0x83, // "I" (U+0049)
  0x00, 0x4A, 0xFF, 0xFD, 0x02, 0x0A, 0x04, 0x04, 0xA0, // "J" (U+004A)
  0x00, 0x4B, 0x01, 0x01, 0x07, 0x0A, 0x08, 0x04, 0xC2, // "K" (U+004B)
  0x00, 0x4C, 0x01, 0x01, 0x06, 0x0A, 0x06, 0x04, 0xEA, // "L" (U+004C)
  0x00, 0x4D, 0x01, 0x01, 0x0A, 0x0A, 0x0C, 0x05, 0x04, // "M" (U+004D)
  0x00, 0x4E, 0x01, 0x01, 0x08, 0x0A, 0x0A, 0x05, 0x39, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x05, 0x65, // "O" (U+004F)
  0x00, 0x50, 0x01, 0x01, 0x06, 0x0A, 0x08, 0x05, 0x92, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFE, 0x08, 0x0A, 0x09, 0x05, 0xB1, // "Q" (U+0051)
  0x00, 0x52, 0x01, 0x01, 0x07, 0x0A, 0x08, 0x05, 0xE7, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x06, 0x0F, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x06, 0x31, // "T" (U+0054)
  0x00, 0x55, 0x01, 0x01, 0x07, 0x0A, 0x09, 0x06, 0x50, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x06, 0x75, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x0B, 0x0A, 0x0C, 0x06, 0x9E, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x06, 0xDF, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x07, 0x05, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x07, 0x27, // "Z" (U+005A)
  0x00, 0x5B, 0x01, 0xFD, 0x04, 0x0A, 0x05, 0x07, 0x44, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x07, 0x66, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0xFD, 0x03, 0x0A, 0x05, 0x07, 0x80, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x05, 0x06, 0x0A, 0x07, 0x07, 0x9E, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFE, 0x06, 0xFF, 0x07, 0x07, 0xB4, // "_" (U+005F)
  0x00, 0x60, 0x00, 0x0A, 0x03, 0x0C, 0x04, 0x07, 0xB9, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x06, 0x08, 0x07, 0x07, 0xC1, // "a" (U+0061)
  0x00, 0x62, 0x01, 0x01, 0x06, 0x0B, 0x08, 0x07, 0xDE, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x05, 0x08, 0x06, 0x07, 0xFF, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x06, 0x0B, 0x08, 0x08, 0x19, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x06, 0x08, 0x07, 0x08, 0x3F, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x08, 0x5C, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFE, 0x06, 0x08, 0x08, 0x08, 0x76, // "g" (U+0067)
  0x00, 0x68, 0x01, 0x01, 0x06, 0x0B, 0x08, 0x08, 0xA0, // "h" (U+0068)
  0x00, 0x69, 0x01, 0x01, 0x02, 0x0B, 0x04, 0x08, 0xC3, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xFE, 0x02, 0x0B, 0x04, 0x08, 0xD0, // "j" (U+006A)
  0x00, 0x6B, 0x01, 0x01, 0x06, 0x0B, 0x07, 0x08, 0xEB, // "k" (U+006B)
  0x00, 0x6C, 0x01, 0x01, 0x02, 0x0B, 0x04, 0x09, 0x0C, // "l" (U+006C)
  0x00, 0x6D, 0x01, 0x01, 0x0A, 0x08, 0x0C, 0x09, 0x19, // "m" (U+006D)
  0x00, 0x6E, 0x01, 0x01, 0x06, 0x08, 0x08, 0x09, 0x49, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x06, 0x08, 0x08, 0x09, 0x66, // "o" (U+006F)
  0x00, 0x70, 0x01, 0xFE, 0x06, 0x08, 0x08, 0x09, 0x86, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFE, 0x06, 0x08, 0x08, 0x09, 0xA7, // "q" (U+0071)
  0x00, 0x72, 0x01, 0x01, 0x04, 0x08, 0x05, 0x09, 0xCD, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0xDE, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x09, 0xF7, // "t" (U+0074)
  0x00, 0x75, 0x01, 0x01, 0x06, 0x08, 0x08, 0x0A, 0x12, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x06, 0x08, 0x06, 0x0A, 0x2E, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x09, 0x08, 0x0A, 0x0A, 0x4C, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x06, 0x08, 0x07, 0x0A, 0x79, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFE, 0x06, 0x08, 0x07, 0x0A, 0x97, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0A, 0xBD, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFD, 0x04, 0x0A, 0x06, 0x0A, 0xD4, // "{" (U+007B)
  0x00, 0x7C, 0x02, 0xFE, 0x03, 0x0B, 0x07, 0x0A, 0xF9, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0xFD, 0x04, 0x0A, 0x06, 0x0B, 0x09, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x04, 0x06, 0x06, 0x07, 0x0B, 0x2C, // "~" (U+007E)
  0x00, 0xA1, 0x01, 0xFF, 0x02, 0x08, 0x04, 0x0B, 0x37, // "¡" (U+00A1)
  0x00, 0xA2, 0x01, 0x01, 0x05, 0x0A, 0x07, 0x0B, 0x43, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x0B, 0x5F, // "£" (U+00A3)
  0x00, 0xA4, 0x01, 0x02, 0x07, 0x09, 0x08, 0x0B, 0x80, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x0B, 0x9E, // "¥" (U+00A5)
  0x00, 0xA6, 0x02, 0xFE, 0x03, 0x0B, 0x07, 0x0B, 0xBF, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0B, 0xCD, // "§" (U+00A7)
  0x00, 0xA8, 0x02, 0x09, 0x05, 0x0A, 0x08, 0x0B, 0xF0, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x00, 0x0B, 0x0B, 0x0C, 0x0B, 0xF5, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x07, 0x04, 0x0A, 0x05, 0x0C, 0x38, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x02, 0x06, 0x07, 0x07, 0x0C, 0x44, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x06, 0x06, 0x07, 0x0C, 0x5B, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x00, 0x0B, 0x0B, 0x0C, 0x0C, 0x68, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x0B, 0x06, 0x0C, 0x07, 0x0C, 0xAE, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x06, 0x04, 0x0A, 0x06, 0x0C, 0xB1, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x06, 0x09, 0x07, 0x0C, 0xC0, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x06, 0x04, 0x0D, 0x05, 0x0C, 0xD8, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x07, 0x04, 0x0D, 0x05, 0x0C, 0xEF, // "³" (U+00B3)
  0x00, 0xB4, 0x00, 0x0A, 0x03, 0x0C, 0x04, 0x0D, 0x04, // "´" (U+00B4)
  0x00, 0xB5, 0x01, 0xFE, 0x06, 0x08, 0x08, 0x0D, 0x0C, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFE, 0x06, 0x0B, 0x08, 0x0D, 0x2E, // "¶" (U+00B6)
  0x00, 0xB7, 0x01, 0x05, 0x02, 0x06, 0x04, 0x0D, 0x61, // "·" (U+00B7)
  0x00, 0xB8, 0x00, 0xFD, 0x02, 0x00, 0x03, 0x0D, 0x64, // "¸" (U+00B8)
  0x00, 0xB9, 0x00, 0x07, 0x03, 0x0C, 0x05, 0x0D, 0x6C, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x06, 0x04, 0x0A, 0x05, 0x0D, 0x7B, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x02, 0x06, 0x07, 0x07, 0x0D, 0x89, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x0D, 0xA1, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x00, 0x0A, 0x0A, 0x0C, 0x0D, 0xD8, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x0B, 0x0B, 0x0B, 0x0E, 0x11, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFF, 0x05, 0x08, 0x06, 0x0E, 0x53, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x0E, 0x6F, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x0E, 0x9F, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x0E, 0xD0, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x0F, 0x02, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x0F, 0x36, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x0F, 0x64, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x09, 0x0A, 0x0B, 0x0F, 0x95, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFD, 0x07, 0x0A, 0x08, 0x0F, 0xC1, // "Ç" (U+00C7)
  0x00, 0xC8, 0x01, 0x01, 0x06, 0x0F, 0x07, 0x0F, 0xEF, // "È" (U+00C8)
  0x00, 0xC9, 0x01, 0x01, 0x06, 0x0F, 0x07, 0x10, 0x13, // "É" (U+00C9)
  0x00, 0xCA, 0x01, 0x01, 0x06, 0x0F, 0x07, 0x10, 0x38, // "Ê" (U+00CA)
  0x00, 0xCB, 0x01, 0x01, 0x06, 0x0D, 0x07, 0x10, 0x5E, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x04, 0x0F, 0x05, 0x10, 0x80, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x04, 0x0F, 0x05, 0x10, 0xA5, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x04, 0x0F, 0x05, 0x10, 0xCB, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x04, 0x0D, 0x05, 0x10, 0xF1, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x07, 0x0A, 0x09, 0x11, 0x14, // "Ð" (U+00D0)
  0x00, 0xD1, 0x01, 0x01, 0x08, 0x0E, 0x0A, 0x11, 0x41, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x08, 0x0F, 0x09, 0x11, 0x7A, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x08, 0x0F, 0x09, 0x11, 0xB1, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x08, 0x0F, 0x09, 0x11, 0xE8, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x12, 0x20, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x12, 0x59, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x03, 0x06, 0x09, 0x07, 0x12, 0x8D, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x08, 0x0B, 0x09, 0x12, 0xA7, // "Ø" (U+00D8)
  0x00, 0xD9, 0x01, 0x01, 0x07, 0x0F, 0x09, 0x12, 0xDD, // "Ù" (U+00D9)
  0x00, 0xDA, 0x01, 0x01, 0x07, 0x0F, 0x09, 0x13, 0x0B, // "Ú" (U+00DA)
  0x00, 0xDB, 0x01, 0x01, 0x07, 0x0F, 0x09, 0x13, 0x3A, // "Û" (U+00DB)
  0x00, 0xDC, 0x01, 0x01, 0x07, 0x0D, 0x09, 0x13, 0x6A, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x13, 0x96, // "Ý" (U+00DD)
  0x00, 0xDE, 0x01, 0x01, 0x06, 0x0A, 0x07, 0x13, 0xC2, // "Þ" (U+00DE)
  0x00, 0xDF, 0x01, 0x01, 0x07, 0x0B, 0x08, 0x13, 0xE2, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x14, 0x0E, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x14, 0x34, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x14, 0x5B, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x14, 0x83, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x14, 0xAB, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x14, 0xCF, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x0A, 0x08, 0x0B, 0x14, 0xF8, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFD, 0x05, 0x08, 0x06, 0x15, 0x24, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x15, 0x4A, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x15, 0x70, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x15, 0x97, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x15, 0xBF, // "ë" (U+00EB)
  0x00, 0xEC, 0xFF, 0x01, 0x02, 0x0C, 0x04, 0x15, 0xE3, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x03, 0x0C, 0x04, 0x15, 0xFB, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x03, 0x0C, 0x04, 0x16, 0x13, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x03, 0x0A, 0x04, 0x16, 0x2C, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x06, 0x0B, 0x08, 0x16, 0x42, // "ð" (U+00F0)
  0x00, 0xF1, 0x01, 0x01, 0x06, 0x0B, 0x08, 0x16, 0x6A, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x16, 0x91, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x16, 0xBA, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x16, 0xE4, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x06, 0x0B, 0x08, 0x17, 0x0F, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x06, 0x0A, 0x08, 0x17, 0x3A, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x03, 0x06, 0x09, 0x07, 0x17, 0x61, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x06, 0x09, 0x08, 0x17, 0x75, // "ø" (U+00F8)
  0x00, 0xF9, 0x01, 0x01, 0x06, 0x0C, 0x08, 0x17, 0x96, // "ù" (U+00F9)
  0x00, 0xFA, 0x01, 0x01, 0x06, 0x0C, 0x08, 0x17, 0xBB, // "ú" (U+00FA)
  0x00, 0xFB, 0x01, 0x01, 0x06, 0x0C, 0x08, 0x17, 0xE1, // "û" (U+00FB)
  0x00, 0xFC, 0x01, 0x01, 0x06, 0x0A, 0x08, 0x18, 0x07, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFE, 0x06, 0x0C, 0x07, 0x18, 0x2A, // "ý" (U+00FD)
  0x00, 0xFE, 0x01, 0xFE, 0x06, 0x0B, 0x08, 0x18, 0x5A, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFE, 0x06, 0x0A, 0x07, 0x18, 0x81, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x18, 0xAE, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x18, 0xDD, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x19, 0x01, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x19, 0x32, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFD, 0x07, 0x0A, 0x08, 0x19, 0x59, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFD, 0x06, 0x08, 0x07, 0x19, 0x89, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x19, 0xB1, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x19, 0xDE, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x1A, 0x01, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x1A, 0x2F, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x1A, 0x52, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x1A, 0x7A, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x1A, 0x99, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x1A, 0xC7, // "č" (U+010D)
  0x01, 0x0E, 0x01, 0x01, 0x07, 0x0F, 0x09, 0x1A, 0xEC, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x09, 0x0B, 0x08, 0x1B, 0x1F, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x07, 0x0A, 0x09, 0x1B, 0x52, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x1B, 0x7F, // "đ" (U+0111)
  0x01, 0x12, 0x01, 0x01, 0x06, 0x0D, 0x07, 0x1B, 0xAD, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x1B, 0xCF, // "ē" (U+0113)
  0x01, 0x14, 0x01, 0x01, 0x06, 0x0E, 0x07, 0x1B, 0xF3, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x1C, 0x18, // "ĕ" (U+0115)
  0x01, 0x16, 0x01, 0x01, 0x06, 0x0E, 0x07, 0x1C, 0x3F, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x1C, 0x60, // "ė" (U+0117)
  0x01, 0x18, 0x01, 0xFD, 0x06, 0x0A, 0x07, 0x1C, 0x82, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFE, 0x06, 0x08, 0x07, 0x1C, 0xA8, // "ę" (U+0119)
  0x01, 0x1A, 0x01, 0x01, 0x06, 0x0F, 0x07, 0x1C, 0xCE, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x1C, 0xF4, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x08, 0x0F, 0x09, 0x1D, 0x1C, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFE, 0x06, 0x0C, 0x08, 0x1D, 0x54, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x1D, 0x89, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFE, 0x06, 0x0B, 0x08, 0x1D, 0xC0, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x1D, 0xF4, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFE, 0x06, 0x0B, 0x08, 0x1E, 0x26, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x08, 0x0A, 0x09, 0x1E, 0x55, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFE, 0x06, 0x0B, 0x08, 0x1E, 0x89, // "ģ" (U+0123)
  0x01, 0x24, 0x01, 0x01, 0x07, 0x0F, 0x09, 0x1E, 0xBA, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x06, 0x0F, 0x08, 0x1E, 0xE9, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x09, 0x0A, 0x09, 0x1F, 0x1D, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x06, 0x0B, 0x08, 0x1F, 0x4C, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x04, 0x0E, 0x05, 0x1F, 0x76, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0x01, 0x04, 0x0B, 0x04, 0x1F, 0x9F, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x04, 0x0D, 0x05, 0x1F, 0xBA, // "Ī" (U+012A)
  0x01, 0x2B, 0xFF, 0x01, 0x03, 0x0A, 0x04, 0x1F, 0xDD, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x04, 0x0E, 0x05, 0x1F, 0xF3, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFF, 0x01, 0x03, 0x0B, 0x04, 0x20, 0x18, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFD, 0x04, 0x0A, 0x05, 0x20, 0x31, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFD, 0x02, 0x0B, 0x04, 0x20, 0x58, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x04, 0x0E, 0x05, 0x20, 0x70, // "İ" (U+0130)
  0x01, 0x31, 0x01, 0x01, 0x02, 0x08, 0x04, 0x20, 0x92, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0xFD, 0x07, 0x0A, 0x08, 0x20, 0x9C, // "Ĳ" (U+0132)
  0x01, 0x33, 0x01, 0xFE, 0x06, 0x0B, 0x07, 0x20, 0xD5, // "ĳ" (U+0133)
  0x01, 0x34, 0xFF, 0xFD, 0x03, 0x0F, 0x04, 0x21, 0x01, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFE, 0x03, 0x0C, 0x04, 0x21, 0x2D, // "ĵ" (U+0135)
  0x01, 0x36, 0x01, 0xFE, 0x07, 0x0A, 0x08, 0x21, 0x4E, // "Ķ" (U+0136)
  0x01, 0x37, 0x01, 0xFE, 0x06, 0x0B, 0x07, 0x21, 0x7D, // "ķ" (U+0137)
  0x01, 0x38, 0x01, 0x01, 0x06, 0x08, 0x07, 0x21, 0xA6, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x06, 0x0F, 0x06, 0x21, 0xC1, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x03, 0x0F, 0x04, 0x21, 0xE6, // "ĺ" (U+013A)
  0x01, 0x3B, 0x01, 0xFE, 0x06, 0x0A, 0x06, 0x22, 0x04, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFE, 0x02, 0x0B, 0x04, 0x22, 0x26, // "ļ" (U+013C)
  0x01, 0x3D, 0x01, 0x01, 0x06, 0x0A, 0x06, 0x22, 0x3D, // "Ľ" (U+013D)
  0x01, 0x3E, 0x01, 0x01, 0x05, 0x0B, 0x04, 0x22, 0x59, // "ľ" (U+013E)
  0x01, 0x3F, 0x01, 0x01, 0x06, 0x0A, 0x06, 0x22, 0x72, // "Ŀ" (U+013F)
  0x01, 0x40, 0x01, 0x01, 0x05, 0x0B, 0x04, 0x22, 0x8E, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x22, 0xA6, // "Ł" (U+0141)
  0x01, 0x42, 0xFF, 0x01, 0x03, 0x0B, 0x04, 0x22, 0xC5, // "ł" (U+0142)
  0x01, 0x43, 0x01, 0x01, 0x08, 0x0F, 0x0A, 0x22, 0xE2, // "Ń" (U+0143)
  0x01, 0x44, 0x01, 0x01, 0x06, 0x0C, 0x08, 0x23, 0x18, // "ń" (U+0144)
  0x01, 0x45, 0x01, 0xFE, 0x08, 0x0A, 0x0A, 0x23, 0x3F, // "Ņ" (U+0145)
  0x01, 0x46, 0x01, 0xFE, 0x06, 0x08, 0x08, 0x23, 0x72, // "ņ" (U+0146)
  0x01, 0x47, 0x01, 0x01, 0x08, 0x0F, 0x0A, 0x23, 0x96, // "Ň" (U+0147)
  0x01, 0x48, 0x01, 0x01, 0x06, 0x0C, 0x08, 0x23, 0xCE, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x07, 0x0A, 0x09, 0x23, 0xF6, // "ŉ" (U+0149)
  0x01, 0x4A, 0x01, 0xFD, 0x08, 0x0A, 0x0A, 0x24, 0x20, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x01, 0xFE, 0x06, 0x08, 0x08, 0x24, 0x56, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x08, 0x0D, 0x09, 0x24, 0x7B, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x06, 0x0A, 0x08, 0x24, 0xAF, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x24, 0xD6, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x06, 0x0B, 0x08, 0x25, 0x0D, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x08, 0x0F, 0x09, 0x25, 0x37, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x25, 0x71, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x25, 0x9D, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x0B, 0x08, 0x0C, 0x25, 0xD3, // "œ" (U+0153)
  0x01, 0x54, 0x01, 0x01, 0x07, 0x0F, 0x08, 0x26, 0x07, // "Ŕ" (U+0154)
  0x01, 0x55, 0x01, 0x01, 0x05, 0x0C, 0x05, 0x26, 0x39, // "ŕ" (U+0155)
  0x01, 0x56, 0x01, 0xFE, 0x07, 0x0A, 0x08, 0x26, 0x54, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x26, 0x83, // "ŗ" (U+0157)
  0x01, 0x58, 0x01, 0x01, 0x07, 0x0F, 0x08, 0x26, 0x9D, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x04, 0x0C, 0x05, 0x26, 0xD0, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x26, 0xEC, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x27, 0x18, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x27, 0x3A, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x27, 0x67, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFD, 0x06, 0x0A, 0x07, 0x27, 0x8A, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFD, 0x05, 0x08, 0x06, 0x27, 0xB7, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x27, 0xDB, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x28, 0x08, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFD, 0x06, 0x0A, 0x07, 0x28, 0x2B, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFD, 0x04, 0x0A, 0x05, 0x28, 0x56, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x28, 0x7C, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x06, 0x0B, 0x05, 0x28, 0xA7, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x28, 0xC9, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x28, 0xE9, // "ŧ" (U+0167)
  0x01, 0x68, 0x01, 0x01, 0x07, 0x0E, 0x09, 0x29, 0x04, // "Ũ" (U+0168)
  0x01, 0x69, 0x01, 0x01, 0x06, 0x0B, 0x08, 0x29, 0x35, // "ũ" (U+0169)
  0x01, 0x6A, 0x01, 0x01, 0x07, 0x0D, 0x09, 0x29, 0x5C, // "Ū" (U+016A)
  0x01, 0x6B, 0x01, 0x01, 0x06, 0x0A, 0x08, 0x29, 0x89, // "ū" (U+016B)
  0x01, 0x6C, 0x01, 0x01, 0x07, 0x0E, 0x09, 0x29, 0xAC, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x01, 0x01, 0x06, 0x0B, 0x08, 0x29, 0xDB, // "ŭ" (U+016D)
  0x01, 0x6E, 0x01, 0x01, 0x07, 0x0F, 0x09, 0x2A, 0x00, // "Ů" (U+016E)
  0x01, 0x6F, 0x01, 0x01, 0x06, 0x0C, 0x08, 0x2A, 0x32, // "ů" (U+016F)
  0x01, 0x70, 0x01, 0x01, 0x07, 0x0F, 0x09, 0x2A, 0x5B, // "Ű" (U+0170)
  0x01, 0x71, 0x01, 0x01, 0x06, 0x0C, 0x08, 0x2A, 0x8C, // "ű" (U+0171)
  0x01, 0x72, 0x01, 0xFE, 0x07, 0x0A, 0x09, 0x2A, 0xB2, // "Ų" (U+0172)
  0x01, 0x73, 0x01, 0xFD, 0x06, 0x08, 0x08, 0x2A, 0xDF, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x0B, 0x0F, 0x0C, 0x2B, 0x06, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x2B, 0x54, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x2B, 0x8C, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFE, 0x06, 0x0C, 0x07, 0x2B, 0xB9, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x06, 0x0D, 0x07, 0x2B, 0xEA, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x2C, 0x13, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x2C, 0x3B, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x06, 0x0E, 0x07, 0x2C, 0x5C, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x2C, 0x7F, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x2C, 0x9C, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x2C, 0xC5, // "ž" (U+017E)
  0x01, 0x7F, 0x01, 0x01, 0x04, 0x0B, 0x04, 0x2C, 0xE7, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x2D, 0x02, // "Ω" (U+03A9)
  0x03, 0xBC, 0x01, 0xFE, 0x06, 0x08, 0x08, 0x2D, 0x35, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x07, 0x08, 0x08, 0x2D, 0x57, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x04, 0x06, 0x05, 0x08, 0x2D, 0x7B, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x04, 0x0E, 0x05, 0x0F, 0x2D, 0x82, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x2D, 0x8A, // "€" (U+20AC)
  0x20, 0xBF, 0x01, 0xFF, 0x06, 0x0C, 0x07, 0x2D, 0xAC, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x08, 0x02, 0x0A, 0x03, 0x2D, 0xD9, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x08, 0x02, 0x0A, 0x03, 0x2D, 0xDF, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0xFF, 0x02, 0x01, 0x04, 0x2D, 0xE5, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x08, 0x02, 0x0A, 0x03, 0x2D, 0xEB, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x08, 0x05, 0x0A, 0x06, 0x2D, 0xF1, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x08, 0x05, 0x0A, 0x06, 0x2D, 0xFC, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0xFF, 0x05, 0x01, 0x06, 0x2E, 0x07, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x08, 0x05, 0x0A, 0x06, 0x2E, 0x12, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x2E, 0x1D, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x2E, 0x3C, // "‡" (U+2021)
  0x20, 0x22, 0x01, 0x04, 0x04, 0x07, 0x06, 0x2E, 0x60, // "•" (U+2022)
  0x20, 0x26, 0x01, 0x01, 0x09, 0x02, 0x0B, 0x2E, 0x6A, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x0F, 0x0A, 0x10, 0x2E, 0x75, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x02, 0x03, 0x07, 0x04, 0x2E, 0xC2, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x02, 0x03, 0x07, 0x04, 0x2E, 0xD0, // "›" (U+203A)
  0x20, 0x44, 0xFD, 0x01, 0x04, 0x0A, 0x02, 0x2E, 0xDF, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x06, 0x09, 0x0B, 0x0A, 0x2E, 0xFA, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x0E, 0x0A, 0x0F, 0x2F, 0x1A, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x06, 0x0B, 0x08, 0x2F, 0x63, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x06, 0x0B, 0x08, 0x2F, 0x8D, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x01, 0x62, 0x01, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x01, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x01, // &Ŧ (U+0026 U+0166)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x2C, 0x00, 0x43, 0x01, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x01, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x01, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x01, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x01, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x01, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x01, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x01, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x01, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x01, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x01, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x01, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x01, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x01, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x01, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x01, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x01, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x01, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x01, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x01, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x01, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x01, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x01, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x43, 0x01, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x01, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x01, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x01, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x01, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x01, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x01, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x01, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x01, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x01, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x01, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x01, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x01, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x01, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x01, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x01, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x01, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x01, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x01, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x01, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x01, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x01, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x01, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x02, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x02, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x02, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x02, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x02, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x02, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x02, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x02, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x02, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x02, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x01, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x01, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x01, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x01, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x01, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x01, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0xAB, 0x01, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x01, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x01, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x01, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x01, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x01, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x01, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x01, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x4B, 0x01, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x01, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x01, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x01, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5F, 0x01, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x69, 0x01, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x01, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x01, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x01, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x01, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x01, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x01, // T‹ (U+0054 U+2039)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0xBB, 0x00, 0x54, 0x01, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x01, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x01, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x01, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x00, 0x59, 0x01, // ĽY (U+013D U+0059)
  0x01, 0x3D, 0x00, 0xDD, 0x01, // ĽÝ (U+013D U+00DD)
  0x01, 0x3D, 0x01, 0x76, 0x01, // ĽŶ (U+013D U+0176)
  0x01, 0x3D, 0x01, 0x78, 0x01, // ĽŸ (U+013D U+0178)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x00, 0x59, 0x01, // ĿY (U+013F U+0059)
  0x01, 0x3F, 0x00, 0xDD, 0x01, // ĿÝ (U+013F U+00DD)
  0x01, 0x3F, 0x01, 0x76, 0x01, // ĿŶ (U+013F U+0176)
  0x01, 0x3F, 0x01, 0x78, 0x01, // ĿŸ (U+013F U+0178)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x01, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x01, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x01, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x01, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x01, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x01, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0xAB, 0x01, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x01, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x01, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x01, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x01, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x01, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x01, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x01, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x4B, 0x01, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x01, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x01, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x01, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5F, 0x01, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x69, 0x01, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x01, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x01, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x01, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x01, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x01, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x01, // Ţ‹ (U+0162 U+2039)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x01, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x01, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x01, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x01, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x01, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x01, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0xAB, 0x01, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x01, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x01, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x01, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x01, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x01, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x01, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x01, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x4B, 0x01, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x01, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x01, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x01, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5F, 0x01, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x69, 0x01, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x01, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x01, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x01, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x01, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x01, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x01, // Ť‹ (U+0164 U+2039)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x01, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x01, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x01, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x01, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x01, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x01, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0xAB, 0x01, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x01, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x01, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x01, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x01, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x01, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x01, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x01, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x4B, 0x01, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x01, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x01, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x01, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5F, 0x01, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x69, 0x01, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x01, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x01, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x01, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x01, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x01, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x01, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x1A, 0x00, 0x43, 0x01, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x01, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x01, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x01, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x01, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x01, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x01, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x01, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x01, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x01, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x01, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x01, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x01, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x01, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x01, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x01, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x01, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x01, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x01, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x01, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x01, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x01, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x01, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1E, 0x00, 0x43, 0x01, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x01, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x01, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x01, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x01, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x01, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x01, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x01, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x01, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x01, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x01, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x01, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x01, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x01, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x01, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x01, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x01, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x01, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x01, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x01, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x01, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x01, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x01, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x01, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x01, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x01, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x01, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x02, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x02, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x02, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x02, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x02, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x02, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x02, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x02, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x02, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x02, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x98, 0x93, 0xBE, 0xAD, 0xAD, 0x9C, 0x8B, 0x7B, 0x72, 0x82, 0xDA, 0xC9,
  // """ (U+0022)
  0x89, 0x61, 0xF6, 0x5F, 0x20, 0xF5, 0x3F, 0x10, 0xE4, 0x29, 0x10,
  // "#" (U+0023)
  0x28, 0x34, 0xD0, 0x98, 0x38, 0x67, 0x90, 0xC4, 0x04, 0xEA, 0x89, 0x2E, 0xFE, 0x90, 0x2D, 0x64,
  0xF2, 0x12, 0x82, 0xE3, 0x4D, 0x38, 0x31, 0xF1, 0x6B, 0x20, 0xAE, 0x86, 0x32, 0x7C, 0x3B, 0x83,
  0x28, 0x37, 0x90, 0xC4, 0x38, 0x39, 0x70, 0xF2, 0x20,
  // "$" (U+0024)
  0x30, 0xC4, 0x89, 0x72, 0x9E, 0xC8, 0x11, 0xEB, 0xD7, 0xB1, 0x4F, 0x1C, 0x38, 0x21, 0xF8, 0xD4,
  0x83, 0x4D, 0xF9, 0x24, 0x82, 0xDB, 0xE2, 0x38, 0x93, 0xC0, 0xD7, 0x25, 0x1C, 0x4E, 0x53, 0xEB,
  0x09, 0x38, 0x12, 0xD1, 0x50, 0xC3,
  // "%" (U+0025)
  0x18, 0x18, 0xEA, 0x28, 0x11, 0xE2, 0x28, 0x62, 0xF5, 0xE5, 0x07, 0xB3, 0x86, 0x5C, 0x0A, 0x80,
  0xD4, 0x38, 0x55, 0xC0, 0xA8, 0x5C, 0x48, 0x90, 0x3E, 0x2D, 0x6C, 0x58, 0xD8, 0x28, 0x90, 0xBF,
  0xD5, 0xE3, 0xE1, 0xD4, 0x28, 0x72, 0x0B, 0x76, 0xC0, 0xA7, 0x38, 0x62, 0xE1, 0x6C, 0x0B, 0x73,
  0x86, 0x99, 0x03, 0xF5, 0xE5, 0x28, 0x11, 0xE2, 0x28, 0x19, 0xEA, 0x10,
  // "&" (U+0026)
  0x18, 0x31, 0xBE, 0xD3, 0x48, 0x37, 0xF5, 0xCB, 0x48, 0x38, 0xD0, 0x9C, 0x48, 0x34, 0xF6, 0xE6,
  0x58, 0x1D, 0xF9, 0x58, 0xA4, 0xBB, 0x9D, 0x17, 0xF1, 0x5F, 0x30, 0xCB, 0xCB, 0x06, 0xF1, 0x02,
  0xA8, 0x53, 0x03, 0xF9, 0x48, 0xA0, 0x62, 0x86, 0x6D, 0xFC, 0x48, 0xF4,
  // "'" (U+0027)
  0x87, 0x1F, 0x60, 0xF5, 0x0E, 0x40,
  // "(" (U+0028)
  0x28, 0x78, 0xC0, 0x3F, 0x30, 0xAC, 0x28, 0xA0, 0xE7, 0x03, 0xF4, 0x04, 0xF2, 0x04, 0xF2, 0x03,
  0xF3, 0x20, 0xE0, 0x72, 0x0A, 0x0C, 0x28, 0x13, 0xF3, 0x20, 0x80, 0xC0,
  // ")" (U+0029)
  0x81, 0x4E, 0x12, 0x0B, 0x0A, 0x28, 0x14, 0xF2, 0x20, 0xE0, 0x72, 0x0B, 0x0A, 0x20, 0xA0, 0xC2,
  0x0A, 0x0C, 0x20, 0x0B, 0x28, 0x93, 0xE7, 0x04, 0xF3, 0x0A, 0xB0, 0x4E, 0x21,
  // "*" (U+002A)
  0x28, 0x14, 0xF1, 0x28, 0x90, 0x13, 0x3E, 0x04, 0x05, 0xFE, 0xA0, 0xE0, 0x22, 0x81, 0xCE, 0x83,
  0x83, 0x8D, 0x3F, 0x52, 0x82, 0x14, 0x05, 0x20,
  // "+" (U+002B)
  0x39, 0x03, 0x59, 0x03, 0x59, 0x03, 0x20, 0x7D, 0x86, 0xA1, 0x33, 0xF5, 0x32, 0x39, 0x03, 0x59,
  0x03, 0x20,
  // "," (U+002C)
  0x18, 0x90, 0xDB, 0x0F, 0x72, 0xF3, 0x5D, 0x10,
  // "-" (U+002D)
  0x08, 0xB0, 0x10, 0xF3,
  // "." (U+002E)
  0x82, 0xD9, 0xC9,
  // "/" (U+002F)
  0x40, 0xE0, 0x53, 0x06, 0x0E, 0x40, 0xC0, 0x83, 0x81, 0x3F, 0x23, 0x09, 0x0C, 0x40, 0xE0, 0x53,
  0x06, 0x0E, 0x40, 0xC0, 0x93, 0x81, 0x3F, 0x23, 0x09, 0x0C, 0x40,
  // "0" (U+0030)
  0x18, 0x32, 0xBF, 0xC3, 0x28, 0x96, 0xBD, 0x5B, 0xD0, 0x1F, 0x60, 0x3F, 0x44, 0xF3, 0x29, 0x82,
  0x75, 0xF2, 0x29, 0x82, 0x85, 0xF2, 0x29, 0x82, 0x84, 0xF3, 0x29, 0x89, 0x47, 0x1F, 0x60, 0x3F,
  0x40, 0xBD, 0x5B, 0xE2, 0x83, 0x2B, 0xEC, 0x31,
  // "1" (U+0031)
  0x18, 0x94, 0x1C, 0xF2, 0xDE, 0xFC, 0xA8, 0xF1, 0x08, 0x92, 0x08, 0x92, 0x08, 0x92, 0x08, 0x92,
  0x08, 0x92, 0x08, 0x92, 0x08, 0x90,
  // "2" (U+0032)
  0x18, 0x92, 0x7D, 0xEC, 0x30, 0x2D, 0x64, 0xCE, 0x58, 0x15, 0xF2, 0x48, 0x17, 0xF1, 0x40, 0xD0,
  0xB4, 0x81, 0x8E, 0x23, 0x81, 0x5F, 0x43, 0x81, 0x3F, 0x63, 0x86, 0x1E, 0xB3, 0x33, 0x17, 0xD0,
  0x70,
  // "3" (U+0033)
  0x89, 0x41, 0x8D, 0xEC, 0x40, 0x1A, 0x54, 0xBF, 0x14, 0x81, 0x4F, 0x23, 0x81, 0x2B, 0xC2, 0x01,
  0xA0, 0xC0, 0x13, 0x83, 0x35, 0xCD, 0x14, 0x81, 0x3F, 0x64, 0x89, 0x63, 0xF6, 0x57, 0x45, 0xCE,
  0x13, 0xCE, 0xEB, 0x31,
  // "4" (U+0034)
  0x38, 0x11, 0xEB, 0x48, 0x19, 0xFB, 0x38, 0x23, 0xEB, 0xB3, 0x82, 0xB7, 0xBB, 0x28, 0x34, 0xE0,
  0xBB, 0x28, 0x6D, 0x60, 0xBB, 0x06, 0xD2, 0x82, 0xBB, 0x0B, 0xE8, 0x52, 0x33, 0x3C, 0xC3, 0x40,
  0x0B, 0x10,
  // "5" (U+0035)
  0x10, 0xCB, 0x0D, 0x20, 0xD0, 0x90, 0xF3, 0x20, 0xE0, 0x65, 0x98, 0x2E, 0xFD, 0x42, 0x84, 0x54,
  0x4C, 0xE1, 0x48, 0x12, 0xF6, 0x48, 0x11, 0xF7, 0x48, 0x96, 0x4F, 0x42, 0x94, 0x5D, 0xD0, 0x1B,
  0xEE, 0xB2, 0x10,
  // "6" (U+0036)
  0x28, 0x25, 0xCF, 0xE2, 0x83, 0x5F, 0x84, 0x42, 0x0D, 0x08, 0x48, 0x97, 0x1F, 0x7E, 0xE7, 0x03,
  0xFC, 0x49, 0xF3, 0x4F, 0x42, 0x98, 0x27, 0x4F, 0x32, 0x83, 0xE8, 0x1F, 0x72, 0x98, 0x94, 0x70,
  0xAE, 0x49, 0xF2, 0x01, 0xBF, 0xD5, 0x10,
  // "7" (U+0037)
  0x07, 0xD8, 0x69, 0x13, 0x33, 0x4F, 0x64, 0x81, 0x7F, 0x14, 0x0D, 0x0A, 0x48, 0x13, 0xF4, 0x40,
  0xA0, 0xD4, 0x81, 0x1F, 0x74, 0x81, 0x7F, 0x14, 0x0D, 0x0B, 0x48, 0x14, 0xF5, 0x30,
  // "8" (U+0038)
  0x18, 0x33, 0xCE, 0xD6, 0x28, 0xB0, 0xEB, 0x49, 0xF2, 0x1F, 0x50, 0x1F, 0x50, 0xDA, 0x07, 0xE1,
  0x02, 0xDE, 0xE3, 0x28, 0x96, 0x7E, 0x9E, 0x90, 0x3F, 0x40, 0x2F, 0x66, 0xF1, 0x28, 0x95, 0xD9,
  0x2F, 0x94, 0x7F, 0x50, 0x5C, 0xED, 0x71,
  // "9" (U+0039)
  0x18, 0xA5, 0x4C, 0xFC, 0x20, 0x1E, 0xB4, 0xBD, 0x05, 0xF2, 0x02, 0xF4, 0x6F, 0x12, 0x98, 0x90,
  0x63, 0xF8, 0x18, 0xF7, 0x09, 0xA8, 0x19, 0xF6, 0x28, 0x31, 0x22, 0xF4, 0x40, 0x70, 0xE2, 0x83,
  0x44, 0x7F, 0x72, 0x82, 0xCF, 0xD6, 0x20,
  // ":" (U+003A)
  0x82, 0xD9, 0xD9, 0x71, 0x82, 0xE9, 0xC9,
  // ";" (U+003B)
  0x18, 0x3D, 0x90, 0xD9, 0x76, 0x89, 0x0D, 0xB0, 0xF7, 0x2F, 0x26, 0xC1,
  // "<" (U+003C)
  0x50, 0x40, 0x73, 0x89, 0x53, 0xBE, 0x60, 0x3B, 0xE8, 0x10, 0x6F, 0xA1, 0x38, 0x31, 0x9F, 0xA3,
  0x48, 0x31, 0x8F, 0xB3, 0x48, 0x11, 0x89,
  // "=" (U+003D)
  0x06, 0xD0, 0x90, 0x18, 0x01, 0x30, 0x27, 0x06, 0xD0, 0x90, 0x18, 0x01, 0x30, 0x20,
  // ">" (U+003E)
  0x00, 0x55, 0x82, 0x3D, 0xD5, 0x58, 0x26, 0xDD, 0x55, 0x81, 0x7F, 0x92, 0x89, 0x02, 0x9F, 0xA2,
  0x29, 0xFA, 0x22, 0x81, 0x6A, 0x24,
  // "?" (U+003F)
  0x89, 0x05, 0xCE, 0xD5, 0x06, 0x64, 0xA9, 0x48, 0x15, 0xF2, 0x30, 0xA0, 0xD3, 0x81, 0x8E, 0x32,
  0x81, 0x2F, 0x43, 0x04, 0x0C, 0x73, 0x81, 0x7E, 0x23, 0x81, 0x7D, 0x12,
  // "@" (U+0040)
  0x38, 0x45, 0xCE, 0xEA, 0x34, 0x86, 0x9E, 0x74, 0x49, 0xE3, 0x28, 0x75, 0xE2, 0x8E, 0xE7, 0x7D,
  0x28, 0xE3, 0xC7, 0x5E, 0x5A, 0xA0, 0xE3, 0x1F, 0x19, 0x90, 0x99, 0x0C, 0x53, 0xE0, 0xB7, 0x0A,
  0x90, 0xC4, 0x3E, 0x09, 0xB2, 0xDA, 0x3F, 0x21, 0xF1, 0x2E, 0xF5, 0xDF, 0x92, 0x0D, 0x08, 0x20,
  0x12, 0x02, 0x38, 0x54, 0xF9, 0x20, 0x26, 0x50, 0x40, 0xDB, 0x0B, 0x78, 0x11, 0x21, 0x40,
  // "A" (U+0041)
  0x28, 0x11, 0xFE, 0x58, 0x26, 0xEF, 0x44, 0x82, 0xBA, 0xC9, 0x49, 0x81, 0x68, 0xD3, 0x84, 0x5F,
  0x24, 0xF3, 0x28, 0x49, 0xE1, 0x1F, 0x82, 0x0E, 0xC8, 0x93, 0xC0, 0x3F, 0x84, 0x49, 0xF2, 0x8F,
  0x12, 0x83, 0x2F, 0x6D, 0xC4, 0x0D, 0x0B,
  // "B" (U+0042)
  0x0C, 0xA8, 0x93, 0xEB, 0x40, 0xCB, 0x35, 0xCE, 0x0C, 0xA2, 0x89, 0x16, 0xF2, 0xCB, 0x01, 0xBD,
  0x0C, 0xB8, 0x92, 0xD3, 0x0C, 0xB3, 0x4C, 0xE1, 0xCA, 0x28, 0x33, 0xF6, 0xCA, 0x28, 0x91, 0x3F,
  0x5C, 0xB3, 0x4C, 0xE1, 0xCB, 0x0C, 0x04, 0x10,
  // "C" (U+0043)
  0x28, 0x93, 0x3B, 0xEE, 0xB1, 0x03, 0xFB, 0x45, 0x92, 0x0B, 0x0D, 0x58, 0x11, 0xF8, 0x58, 0x12,
  0xF6, 0x58, 0x13, 0xF6, 0x58, 0x11, 0xF8, 0x60, 0xC0, 0xE6, 0x84, 0x4F, 0xC5, 0x47, 0x38, 0x34,
  0xCF, 0xEA, 0x10,
  // "D" (U+0044)
  0x0C, 0xA8, 0x93, 0xEA, 0x20, 0xCB, 0x35, 0xDE, 0x2C, 0xA2, 0x83, 0x1F, 0xAC, 0xA3, 0x82, 0xAE,
  0xCA, 0x38, 0x28, 0xFC, 0xA3, 0x82, 0x9F, 0xCA, 0x38, 0x2B, 0xEC, 0xA2, 0x89, 0x11, 0xF9, 0xCB,
  0x36, 0xDE, 0x1C, 0xA8, 0x1E, 0xA2, 0x10,
  // "E" (U+0045)
  0x0C, 0xC8, 0x71, 0xCB, 0x33, 0x30, 0xCA, 0x40, 0xC0, 0xB4, 0x0C, 0xB8, 0x90, 0xD0, 0xCB, 0x33,
  0x20, 0xCA, 0x40, 0xC0, 0xA4, 0x85, 0xCB, 0x33, 0x30, 0xCC, 0x01,
  // "F" (U+0046)
  0x0C, 0xC8, 0x71, 0xCB, 0x33, 0x30, 0xCA, 0x40, 0xC0, 0xB4, 0x0C, 0xB8, 0x90, 0xD0, 0xCB, 0x33,
  0x20, 0xCA, 0x40, 0xC0, 0xA4, 0x0C, 0x0A, 0x40, 0xC0, 0xA4,
  // "G" (U+0047)
  0x28, 0x42, 0xAD, 0xFD, 0x82, 0x85, 0x2E, 0xD6, 0x46, 0x72, 0x81, 0xBE, 0x16, 0x90, 0x96, 0x81,
  0x2F, 0x62, 0xB8, 0x22, 0x2F, 0x62, 0x85, 0x37, 0xF2, 0x1F, 0x83, 0x84, 0x5F, 0x20, 0xCD, 0x38,
  0x92, 0x5F, 0x20, 0x3F, 0xC5, 0x39, 0xF2, 0x28, 0x53, 0xBE, 0xED, 0xA1,
  // "H" (U+0048)
  0x0C, 0x0A, 0x38, 0x29, 0xEC, 0xA3, 0x82, 0x9E, 0xCA, 0x38, 0x29, 0xEC, 0xB3, 0x81, 0x9E, 0xCD,
  0x89, 0x0E, 0xCB, 0x33, 0x3A, 0xEC, 0xA3, 0x82, 0x9E, 0xCA, 0x38, 0x29, 0xEC, 0xA3, 0x82, 0x9E,
  0xCA, 0x30, 0x90, 0xE0,
  // "I" (U+0049)
  0x07, 0xB8, 0x32, 0x07, 0xF2, 0x28, 0x16, 0xF1, 0x28, 0x16, 0xF1, 0x28, 0x16, 0xF1, 0x28, 0x16,
  0xF1, 0x28, 0x16, 0xF1, 0x28, 0x16, 0xF1, 0x28, 0x36, 0xF2, 0x06, 0xB0, 0x20,
  // "J" (U+004A)
  0x20, 0xD0, 0xA2, 0x0D, 0x0A, 0x20, 0xD0, 0xA2, 0x0D, 0x0A, 0x20, 0xD0, 0xA2, 0x0D, 0x0A, 0x20,
  0xD0, 0xA2, 0x0D, 0x0A, 0x20, 0xD0, 0xA2, 0x0D, 0x0A, 0x28, 0x92, 0xE9, 0x13, 0xF7, 0xDF, 0xC1,
  0x12, 0x20,
  // "K" (U+004B)
  0x0C, 0x0A, 0x28, 0xA4, 0x5F, 0x5C, 0xA0, 0x1E, 0xA0, 0xCA, 0x0A, 0xD1, 0x0C, 0xA5, 0xF4, 0x28,
  0x2C, 0xCE, 0xB3, 0x83, 0xCF, 0xCF, 0x32, 0x83, 0xCB, 0x0D, 0xC2, 0x87, 0xCA, 0x05, 0xF5, 0x0C,
  0xA2, 0x83, 0xCD, 0x0C, 0xA2, 0x81, 0x3F, 0x70,
  // "L" (U+004C)
  0x0C, 0x0A, 0x40, 0xC0, 0xA4, 0x0C, 0x0A, 0x40, 0xC0, 0xA4, 0x0C, 0x0A, 0x40, 0xC0, 0xA4, 0x0C,
  0x0A, 0x40, 0xC0, 0xA4, 0x85, 0xCC, 0x44, 0x40, 0xCC, 0x01,
  // "M" (U+004D)
  0x81, 0xCF, 0x74, 0x84, 0xAF, 0xAC, 0xFC, 0x48, 0x5E, 0xFA, 0xCC, 0xF2, 0x28, 0x64, 0xEC, 0xAC,
  0x9E, 0x72, 0x86, 0x9A, 0xCA, 0xC9, 0x9C, 0x28, 0xC4, 0xE5, 0xCA, 0xC9, 0x4F, 0x14, 0xF0, 0xCA,
  0xC9, 0x0E, 0x69, 0xA0, 0xCA, 0xC9, 0x09, 0xCE, 0x50, 0xCA, 0xC9, 0x04, 0xA2, 0x82, 0xCA, 0xC9,
  0x20, 0xE0, 0xA2, 0x0C, 0x0A,
  // "N" (U+004E)
  0x81, 0xCF, 0x43, 0x98, 0x27, 0xCF, 0xC3, 0x98, 0x37, 0xCC, 0xF4, 0x29, 0x83, 0x7C, 0x8C, 0xC2,
  0x98, 0xB1, 0x7C, 0x93, 0xF5, 0x0F, 0x7C, 0x90, 0xBD, 0x0F, 0x7C, 0x90, 0x3F, 0x5E, 0x7C, 0x92,
  0x84, 0xAD, 0xE7, 0xC9, 0x20, 0x2A, 0x81, 0x7C, 0x93, 0x81, 0x9F, 0x70,
  // "O" (U+004F)
  0x28, 0x35, 0xCF, 0xD9, 0x38, 0x55, 0xFA, 0x46, 0xEB, 0x20, 0x0D, 0x38, 0x46, 0xF3, 0x1F, 0x83,
  0x84, 0x1F, 0x83, 0xF6, 0x49, 0x82, 0x92, 0xF6, 0x49, 0x82, 0x91, 0xF8, 0x38, 0x41, 0xF8, 0x0C,
  0xD3, 0x89, 0x16, 0xF3, 0x04, 0xFA, 0x46, 0xEB, 0x38, 0x34, 0xCE, 0xD9, 0x20,
  // "P" (U+0050)
  0x0C, 0xA8, 0x91, 0xD9, 0x1C, 0xB3, 0x6F, 0x9C, 0xA2, 0x82, 0xAE, 0xCA, 0x28, 0x79, 0xEC, 0xB0,
  0x4E, 0xAC, 0xB8, 0x4B, 0x1C, 0xB2, 0x12, 0x0C, 0x0A, 0x40, 0xC0, 0xA4, 0x0C, 0x0A, 0x40,
  // "Q" (U+0051)
  0x28, 0x45, 0xCF, 0xE9, 0x12, 0x85, 0x5F, 0xA4, 0x6E, 0xB2, 0x00, 0xD3, 0x84, 0x6F, 0x41, 0xF8,
  0x38, 0x41, 0xF8, 0x3F, 0x64, 0x98, 0x29, 0x2F, 0x64, 0x98, 0x29, 0x1F, 0x83, 0x84, 0x1F, 0x80,
  0xCD, 0x38, 0x91, 0x6F, 0x30, 0x4F, 0xA4, 0x6E, 0xB3, 0x05, 0x0C, 0xA0, 0xB7, 0x81, 0xBD, 0x16,
  0x81, 0x2F, 0xA7, 0x81, 0x57, 0x10,
  // "R" (U+0052)
  0x0C, 0xA8, 0x93, 0xD9, 0x10, 0xCB, 0x36, 0xFA, 0x0C, 0xA2, 0x83, 0x9E, 0x0C, 0xA2, 0x89, 0x19,
  0xF0, 0xCB, 0x03, 0xEA, 0x0C, 0xB8, 0x6B, 0x10, 0xCB, 0x3D, 0xA2, 0x87, 0xCA, 0x05, 0xF3, 0x0C,
  0xA2, 0x83, 0xCC, 0x0C, 0xA2, 0x81, 0x4F, 0x60,
  // "S" (U+0053)
  0x18, 0x96, 0x3C, 0xFE, 0xA0, 0x1E, 0xB4, 0x59, 0x04, 0xF4, 0x48, 0x12, 0xF9, 0x58, 0x27, 0xFD,
  0x54, 0x82, 0x3B, 0xFA, 0x58, 0x18, 0xF3, 0x48, 0x96, 0x4F, 0x44, 0x74, 0x4C, 0xE0, 0x3C, 0xEE,
  0xB2, 0x10,
  // "T" (U+0054)
  0x0C, 0xD8, 0x67, 0x23, 0x8F, 0x43, 0x12, 0x81, 0x6F, 0x14, 0x81, 0x6F, 0x14, 0x81, 0x6F, 0x14,
  0x81, 0x6F, 0x14, 0x81, 0x6F, 0x14, 0x81, 0x6F, 0x14, 0x81, 0x6F, 0x14, 0x81, 0x6F, 0x12,
  // "U" (U+0055)
  0x0E, 0x09, 0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9,
  0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A, 0xCC, 0xB3, 0x89, 0x5C, 0xB7, 0xF7, 0x48,
  0xF5, 0x07, 0xDE, 0xD6, 0x10,
  // "V" (U+0056)
  0x0D, 0x0B, 0x38, 0x21, 0xF7, 0x89, 0x38, 0x45, 0xF2, 0x4F, 0x42, 0x0A, 0x0D, 0x20, 0xE0, 0x82,
  0x0E, 0x09, 0x28, 0x4A, 0xC0, 0x3F, 0x42, 0x83, 0x6F, 0x17, 0xE3, 0x83, 0x1F, 0x5B, 0xA4, 0x82,
  0xC9, 0xF6, 0x48, 0x27, 0xEF, 0x14, 0x81, 0x3F, 0xC3,
  // "W" (U+0057)
  0x0C, 0x0B, 0x30, 0xD0, 0xC3, 0x82, 0xCB, 0x8E, 0x20, 0x1A, 0x39, 0x8A, 0x58, 0x5F, 0x20, 0x5D,
  0xE4, 0x03, 0xF4, 0x1F, 0x60, 0x9A, 0xC8, 0x07, 0x92, 0x89, 0x0D, 0x90, 0xC7, 0x8B, 0x0A, 0xC2,
  0x89, 0x09, 0xD1, 0xF3, 0x5F, 0x0E, 0x92, 0x89, 0x06, 0xF5, 0xF0, 0x1F, 0x5F, 0x52, 0x82, 0x2F,
  0xBB, 0x28, 0x2C, 0xBF, 0x13, 0x81, 0xEF, 0x82, 0x81, 0x9F, 0xD4, 0x81, 0xAF, 0x42, 0x81, 0x5F,
  0xA2,
  // "X" (U+0058)
  0x81, 0x6F, 0x22, 0x89, 0x5D, 0xA0, 0xD9, 0x05, 0xF3, 0x06, 0xF1, 0xCA, 0x38, 0x2D, 0xCF, 0x33,
  0x81, 0x6F, 0xA4, 0x81, 0x9F, 0xC3, 0x83, 0x1F, 0x9F, 0x42, 0x89, 0x59, 0xD0, 0xBC, 0x02, 0xF6,
  0x04, 0xF5, 0xAD, 0x30, 0xC0, 0xD0,
  // "Y" (U+0059)
  0x00, 0xC3, 0x89, 0x5C, 0xB5, 0xF3, 0x02, 0xF4, 0x0D, 0x90, 0x8D, 0x28, 0x37, 0xE1, 0xE6, 0x38,
  0x1E, 0xAE, 0x48, 0x18, 0xF8, 0x48, 0x14, 0xF4, 0x48, 0x14, 0xF4, 0x48, 0x14, 0xF4, 0x48, 0x14,
  0xF4, 0x20,
  // "Z" (U+005A)
  0x07, 0xD8, 0x51, 0x13, 0x33, 0xDD, 0x48, 0x14, 0xF5, 0x40, 0xB0, 0xC4, 0x81, 0x4F, 0x44, 0x00,
  0xC4, 0x81, 0x4F, 0x44, 0x0C, 0x0B, 0x48, 0x65, 0xF7, 0x33, 0x30, 0x9D, 0x03,
  // "[" (U+005B)
  0x0E, 0xA8, 0x55, 0xE8, 0x31, 0xE6, 0x20, 0xE0, 0x62, 0x0E, 0x06, 0x20, 0xE0, 0x62, 0x0E, 0x06,
  0x20, 0xE0, 0x62, 0x0E, 0x06, 0x20, 0xE0, 0x62, 0x0E, 0x06, 0x20, 0xE0, 0x72, 0x0E, 0xA8, 0x35,
  0x33, 0x31,
  // "\" (U+005C)
  0x09, 0x0C, 0x48, 0x13, 0xF2, 0x40, 0xC0, 0x84, 0x06, 0x0E, 0x50, 0xE0, 0x54, 0x09, 0x0B, 0x48,
  0x13, 0xF2, 0x40, 0xC0, 0x84, 0x06, 0x0E, 0x48, 0x11, 0xE5,
  // "]" (U+005D)
  0x09, 0xA8, 0x3A, 0x23, 0xBA, 0x20, 0x0A, 0x20, 0x0A, 0x20, 0x0A, 0x20, 0x0A, 0x20, 0x0A, 0x20,
  0x0A, 0x20, 0x0A, 0x20, 0x0A, 0x20, 0x0A, 0x28, 0x1A, 0xA9, 0xA8, 0x3A, 0x13, 0x32,
  // "^" (U+005E)
  0x28, 0x11, 0xE4, 0x48, 0x17, 0xFC, 0x48, 0x2E, 0x5E, 0x52, 0x83, 0x7C, 0x07, 0xC2, 0x0E, 0x05,
  0x28, 0x2E, 0x57, 0xD3, 0x07, 0x0D,
  // "_" (U+005F)
  0xE0, 0xA8, 0x02, 0x30, 0x20,
  // "`" (U+0060)
  0x81, 0x27, 0x32, 0x0B, 0x0D, 0x30, 0xB0, 0x70,
  // "a" (U+0061)
  0x18, 0x35, 0xCE, 0xD4, 0x28, 0x34, 0x64, 0xBD, 0x58, 0x46, 0xF1, 0x06, 0xDB, 0x8B, 0x31, 0x3F,
  0x93, 0x7F, 0x16, 0xF1, 0x07, 0xF1, 0x4F, 0x75, 0xDF, 0x10, 0x9E, 0xC3, 0xF1,
  // "b" (U+0062)
  0x90, 0x74, 0x90, 0x74, 0x90, 0x74, 0x98, 0x93, 0x8B, 0xFB, 0x1F, 0xE6, 0x5E, 0x9F, 0xA2, 0x82,
  0x9E, 0xF8, 0x20, 0x6A, 0x08, 0x20, 0x7A, 0x0A, 0x28, 0x94, 0x9E, 0xFE, 0x65, 0xE9, 0xF6, 0xBF,
  0xB1,
  // "c" (U+0063)
  0x18, 0x94, 0x1B, 0xFE, 0x50, 0xBD, 0x55, 0x22, 0xF6, 0x38, 0x14, 0xF3, 0x38, 0x15, 0xF3, 0x38,
  0x13, 0xF5, 0x48, 0x91, 0xDD, 0x55, 0x40, 0x2B, 0xED, 0x50,
  // "d" (U+0064)
  0x50, 0x0B, 0x50, 0x0B, 0x58, 0xA1, 0xBB, 0x03, 0xDE, 0x8B, 0xB0, 0xDD, 0x48, 0xFB, 0x2F, 0x52,
  0x83, 0xDB, 0x4F, 0x32, 0x83, 0xBB, 0x4F, 0x32, 0x83, 0xBB, 0x2F, 0x52, 0x89, 0x6D, 0xB0, 0xDD,
  0x48, 0xFB, 0x03, 0xDF, 0x98, 0xB0,
  // "e" (U+0065)
  0x18, 0x32, 0xBF, 0xD4, 0x28, 0x7B, 0xC4, 0x9E, 0x12, 0xF4, 0x29, 0x05, 0x04, 0xD8, 0x91, 0x74,
  0xF5, 0x33, 0x31, 0x2F, 0x55, 0x89, 0x2B, 0xD5, 0x48, 0x10, 0x1A, 0xEE, 0xB1,
  // "f" (U+0066)
  0x18, 0x92, 0x2C, 0xF9, 0x09, 0xE4, 0x20, 0xBB, 0x20, 0x9B, 0x83, 0x33, 0xCC, 0x32, 0x00, 0xB3,
  0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB3, 0x00, 0xB2,
  // "g" (U+0067)
  0x18, 0x96, 0x3C, 0xE9, 0x9B, 0x0C, 0xD4, 0x8F, 0xB2, 0xF5, 0x28, 0x3D, 0xB4, 0xF3, 0x28, 0x3B,
  0xB4, 0xF3, 0x28, 0x3B, 0xB2, 0xF5, 0x28, 0x96, 0xDB, 0x0D, 0xD4, 0x8F, 0xB0, 0x3D, 0xE9, 0xBB,
  0x58, 0x95, 0xC9, 0x07, 0x54, 0x8F, 0x40, 0x9E, 0xFD, 0x61,
  // "h" (U+0068)
  0x90, 0x74, 0x90, 0x74, 0x90, 0x74, 0x98, 0x93, 0x8B, 0xEB, 0x1F, 0xE6, 0x5F, 0x8F, 0xA2, 0x82,
  0xBB, 0xF8, 0x28, 0x2A, 0xBF, 0x72, 0x82, 0xAB, 0xF7, 0x28, 0x2A, 0xBF, 0x72, 0x82, 0xAB, 0xF7,
  0x20, 0xA0, 0xB0,
  // "i" (U+0069)
  0x81, 0xD7, 0x23, 0x98, 0x95, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x70,
  // "j" (U+006A)
  0x20, 0xD0, 0x72, 0x02, 0x79, 0x07, 0x29, 0x07, 0x29, 0x07, 0x29, 0x07, 0x29, 0x07, 0x29, 0x07,
  0x29, 0x07, 0x29, 0x07, 0x29, 0x86, 0x72, 0x5F, 0x56, 0xFB, 0x10,
  // "k" (U+006B)
  0x90, 0x74, 0x90, 0x74, 0x90, 0x74, 0x98, 0x95, 0x70, 0x4F, 0x5F, 0x71, 0xD9, 0x0F, 0x7A, 0xD2,
  0x98, 0x1B, 0xF8, 0x29, 0x8A, 0x5E, 0xAE, 0x10, 0xF7, 0x1E, 0x80, 0xF7, 0x08, 0xF1, 0xF7, 0x01,
  0xE9,
  // "l" (U+006C)
  0x98, 0xA3, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x70,
  // "m" (U+006D)
  0x98, 0xA3, 0x6C, 0xFB, 0x2C, 0xEB, 0x0F, 0xE5, 0x7F, 0xE6, 0x6F, 0x6F, 0xA2, 0x0E, 0x0B, 0x28,
  0x2D, 0x9F, 0x82, 0x0E, 0x09, 0x28, 0x2C, 0x9F, 0x72, 0x0E, 0x08, 0x28, 0x2C, 0x9F, 0x72, 0x0E,
  0x08, 0x28, 0x2C, 0x9F, 0x72, 0x0E, 0x08, 0x28, 0x2C, 0x9F, 0x72, 0x0E, 0x08, 0x20, 0xC0, 0x90,
  // "n" (U+006E)
  0x98, 0x93, 0x5B, 0xEB, 0x1F, 0xE6, 0x5F, 0x8F, 0xA2, 0x82, 0xBB, 0xF8, 0x28, 0x2A, 0xBF, 0x72,
  0x82, 0xAB, 0xF7, 0x28, 0x2A, 0xBF, 0x72, 0x82, 0xAB, 0xF7, 0x20, 0xA0, 0xB0,
  // "o" (U+006F)
  0x18, 0x32, 0xBF, 0xD6, 0x28, 0x7B, 0xD4, 0x7F, 0x42, 0xF5, 0x28, 0x3C, 0xA4, 0xF3, 0x28, 0x3A,
  0xD4, 0xF3, 0x28, 0x3A, 0xD2, 0xF5, 0x28, 0x95, 0xCB, 0x0B, 0xD4, 0x7F, 0x40, 0x1A, 0xED, 0x61,
  // "p" (U+0070)
  0x98, 0x93, 0x6B, 0xFB, 0x1F, 0xE6, 0x5E, 0x9F, 0xA2, 0x82, 0x9E, 0xF8, 0x20, 0x6A, 0x08, 0x20,
  0x6A, 0x0A, 0x28, 0x96, 0x9E, 0xFE, 0x65, 0xE9, 0xF8, 0xBF, 0xB1, 0xF7, 0x49, 0x07, 0x49, 0x07,
  0x40,
  // "q" (U+0071)
  0x18, 0x96, 0x3C, 0xF9, 0x9B, 0x0C, 0xD4, 0x8F, 0xB2, 0xF5, 0x28, 0x3D, 0xB4, 0xF3, 0x28, 0x3B,
  0xB4, 0xF3, 0x28, 0x3B, 0xB2, 0xF5, 0x28, 0x96, 0xDB, 0x0D, 0xD4, 0x8E, 0xB0, 0x3D, 0xE9, 0xBB,
  0x50, 0x0B, 0x50, 0x0B, 0x50, 0x0B,
  // "r" (U+0072)
  0x98, 0x75, 0xBE, 0xFE, 0x83, 0xFB, 0x29, 0x08, 0x29, 0x07, 0x29, 0x07, 0x29, 0x07, 0x29, 0x07,
  0x20,
  // "s" (U+0073)
  0x18, 0x94, 0x8E, 0xEB, 0x14, 0xF7, 0x48, 0x05, 0xF2, 0x48, 0x1C, 0xE8, 0x48, 0x16, 0xEC, 0x48,
  0x94, 0x3F, 0x44, 0x64, 0x8F, 0x24, 0xDF, 0xD6, 0x10,
  // "t" (U+0074)
  0x10, 0x30, 0x43, 0x0A, 0x09, 0x20, 0x8B, 0x83, 0x42, 0xEA, 0x32, 0x0D, 0x09, 0x30, 0xD0, 0x93,
  0x0D, 0x09, 0x30, 0xD0, 0x93, 0x87, 0xCD, 0x41, 0x04, 0xEE, 0x40,
  // "u" (U+0075)
  0x90, 0x72, 0x82, 0xBB, 0xF7, 0x28, 0x2B, 0xBF, 0x72, 0x82, 0xBB, 0xF7, 0x28, 0x2B, 0xBF, 0x72,
  0x82, 0xCB, 0xF8, 0x28, 0x94, 0xDB, 0xCD, 0x27, 0xFB, 0x3D, 0xE9, 0x8B,
  // "v" (U+0076)
  0x0C, 0x0B, 0x28, 0x33, 0xF4, 0x7E, 0x28, 0x77, 0xE0, 0x3F, 0x30, 0xCA, 0x28, 0x3E, 0x70, 0xF6,
  0x28, 0x39, 0xC4, 0xF1, 0x28, 0x25, 0xF9, 0xC4, 0x90, 0xE0, 0x74, 0x81, 0xBF, 0x32,
  // "w" (U+0077)
  0x00, 0xB2, 0x86, 0xCF, 0x10, 0x7E, 0x7E, 0x29, 0x8B, 0x7E, 0x40, 0xAB, 0x4F, 0x24, 0xEA, 0x80,
  0xE7, 0x0F, 0x58, 0xA7, 0xB2, 0xF3, 0x0C, 0x8B, 0x74, 0xE5, 0x92, 0x86, 0x8B, 0xE3, 0x1F, 0xAB,
  0x20, 0x50, 0xE9, 0x28, 0x1D, 0xE8, 0x28, 0x11, 0xFC, 0x28, 0x19, 0xF4, 0x10,
  // "x" (U+0078)
  0x89, 0x36, 0xF2, 0x09, 0xE1, 0x0D, 0xA1, 0xF7, 0x28, 0x25, 0xFA, 0xD4, 0x81, 0xCF, 0x64, 0x81,
  0xDF, 0x73, 0x8A, 0x27, 0xE9, 0xE1, 0x01, 0xE8, 0x1E, 0x80, 0x8E, 0x10, 0x7F, 0x20,
  // "y" (U+0079)
  0x0C, 0x0B, 0x28, 0x96, 0x3F, 0x47, 0xF1, 0x08, 0xE0, 0x2F, 0x50, 0xCA, 0x28, 0x3C, 0x91, 0xF5,
  0x28, 0x17, 0xE5, 0x93, 0x82, 0x2F, 0xCB, 0x48, 0x1C, 0xF6, 0x48, 0x18, 0xF1, 0x40, 0x0B, 0x38,
  0x23, 0x6F, 0x53, 0x81, 0xAE, 0x84,
  // "z" (U+007A)
  0x06, 0xC1, 0x83, 0x13, 0x3D, 0xC3, 0x81, 0x4F, 0x43, 0x0C, 0x0B, 0x38, 0x14, 0xF3, 0x30, 0xC0,
  0xB3, 0x85, 0x5F, 0x73, 0x30, 0x9C, 0x01,
  // "{" (U+007B)
  0x28, 0x12, 0xBE, 0x28, 0x1B, 0xD4, 0x20, 0xD0, 0x83, 0x0E, 0x08, 0x30, 0xE0, 0x72, 0x85, 0x4F,
  0x50, 0x8F, 0x92, 0x82, 0x17, 0xF4, 0x30, 0xE0, 0x73, 0x0E, 0x08, 0x30, 0xE0, 0x83, 0x81, 0xCC,
  0x12, 0x04, 0x0E, 0x94, 0x02,
  // "|" (U+007C)
  0x8B, 0x14, 0xF4, 0xF4, 0xF4, 0xF4, 0xF4, 0xF4, 0xF4, 0xF4, 0xF4, 0xF4, 0xF4, 0xF4, 0xF4, 0x90,
  // "}" (U+007D)
  0x81, 0x6D, 0x72, 0x82, 0x18, 0xF4, 0x39, 0x06, 0x39, 0x06, 0x39, 0x07, 0x38, 0x1C, 0xB1, 0x20,
  0x20, 0xD9, 0x28, 0x1B, 0xD4, 0x29, 0x07, 0x39, 0x06, 0x39, 0x06, 0x28, 0x55, 0xF5, 0x07, 0xFB,
  0x20, 0x01, 0x30,
  // "~" (U+007E)
  0x89, 0x12, 0xDE, 0x93, 0x17, 0x76, 0x4B, 0xA0, 0x64, 0x00, 0x11,
  // "¡" (U+00A1)
  0x82, 0xC9, 0xDA, 0x28, 0x94, 0xB7, 0xB7, 0xC8, 0xD9, 0xEA, 0xEA, 0xFB,
  // "¢" (U+00A2)
  0x20, 0x60, 0x82, 0x89, 0x17, 0xDE, 0xA5, 0xF6, 0x34, 0xBC, 0x30, 0xD0, 0xA3, 0x0C, 0x0B, 0x38,
  0x95, 0x9E, 0x20, 0x12, 0xEF, 0xDE, 0x01, 0xAB, 0x22, 0x06, 0x08, 0x10,
  // "£" (U+00A3)
  0x28, 0x96, 0x5D, 0xEC, 0x30, 0x1F, 0xA4, 0x71, 0x03, 0xF4, 0x48, 0x14, 0xF4, 0x30, 0x6C, 0x86,
  0x60, 0x16, 0xF6, 0x31, 0x28, 0x13, 0xF3, 0x48, 0x15, 0xF2, 0x38, 0x61, 0xCB, 0x33, 0x32, 0x6D,
  0x0A,
  // "¤" (U+00A4)
  0x02, 0x48, 0xA0, 0x20, 0xE9, 0xDE, 0x9E, 0x46, 0xE6, 0x4C, 0xB0, 0x96, 0x28, 0x31, 0xE0, 0xA6,
  0x39, 0x18, 0x76, 0xD3, 0x19, 0xB0, 0xCC, 0xA8, 0x90, 0xCE, 0x35, 0x01, 0x20, 0x41,
  // "¥" (U+00A5)
  0x81, 0x6F, 0x12, 0x89, 0x5E, 0x90, 0xE6, 0x04, 0xF2, 0x08, 0xC0, 0x9B, 0x28, 0x32, 0xF2, 0xE4,
  0x38, 0x1B, 0xBD, 0x3D, 0x02, 0x28, 0x13, 0xF5, 0x3D, 0x85, 0x20, 0x35, 0xF7, 0x33, 0x81, 0x2F,
  0x52,
  // "¦" (U+00A6)
  0x89, 0x14, 0xF4, 0xF4, 0xF4, 0xF4, 0xF4, 0x96, 0x87, 0x4F, 0x4F, 0x4F, 0x4F, 0x49,
  // "§" (U+00A7)
  0x18, 0x94, 0x5D, 0xEC, 0x21, 0xF8, 0x48, 0x11, 0xF5, 0x48, 0x92, 0x7F, 0xA2, 0x01, 0xD6, 0x9F,
  0x33, 0x92, 0x86, 0xC7, 0x0C, 0xD6, 0xE3, 0x28, 0x16, 0xDD, 0x58, 0x93, 0xE6, 0x37, 0x46, 0xF5,
  0x2B, 0xEE, 0x81,
  // "¨" (U+00A8)
  0x83, 0xD4, 0x4E, 0x12, 0x01,
  // "©" (U+00A9)
  0x38, 0x55, 0xBE, 0xFD, 0x81, 0x48, 0x79, 0xE8, 0x43, 0x6C, 0xD2, 0x28, 0x90, 0x6C, 0x13, 0xCF,
  0xC3, 0x8D, 0x28, 0x96, 0xD2, 0x1E, 0x93, 0x61, 0x0B, 0x52, 0xC0, 0x6D, 0x58, 0x55, 0x94, 0xA0,
  0x8A, 0x58, 0x53, 0xB3, 0xB0, 0x7C, 0x58, 0x90, 0x4A, 0x0E, 0x12, 0xF5, 0x13, 0x28, 0x59, 0x60,
  0x8B, 0x07, 0xA8, 0x2E, 0x15, 0xE3, 0x87, 0xCC, 0x52, 0x33, 0x9E, 0x44, 0x08, 0x0E, 0xB0, 0xB0,
  0x27, 0x00, 0x25,
  // "ª" (U+00AA)
  0x8A, 0x21, 0xAB, 0xB0, 0x2A, 0xBE, 0x28, 0x90, 0xE2, 0x4D, 0xAC, 0x20,
  // "«" (U+00AB)
  0x28, 0xA7, 0xA9, 0x09, 0xA0, 0x6F, 0x25, 0xF3, 0x3F, 0x72, 0xE8, 0x02, 0xF7, 0x2E, 0x82, 0x84,
  0x6F, 0x25, 0xF3, 0x28, 0x3A, 0x90, 0x99,
  // "¬" (U+00AC)
  0x07, 0xD8, 0x69, 0x13, 0x33, 0x3A, 0x95, 0x00, 0x95, 0x00, 0x95, 0x00, 0x10,
  // "®" (U+00AE)
  0x38, 0x55, 0xBE, 0xFD, 0x81, 0x48, 0x79, 0xE8, 0x43, 0x6C, 0xD2, 0x28, 0x16, 0xC1, 0x50, 0x80,
  0xD2, 0x82, 0xD2, 0x0D, 0xA8, 0x5B, 0x10, 0xB5, 0x2C, 0x28, 0x90, 0xD7, 0x5E, 0x50, 0x59, 0x4A,
  0x20, 0xDA, 0x85, 0xB1, 0x03, 0xB3, 0xB2, 0x82, 0xD7, 0x9A, 0x28, 0xA7, 0x4A, 0x0E, 0x10, 0xD5,
  0x1E, 0x30, 0x96, 0x08, 0xB0, 0x73, 0x05, 0x65, 0xE3, 0x87, 0xCC, 0x51, 0x13, 0x9E, 0x44, 0x08,
  0x0E, 0xB0, 0xB0, 0x27, 0x00, 0x25,
  // "¯" (U+00AF)
  0xF8, 0x03, 0x30,
  // "°" (U+00B0)
  0x18, 0x96, 0x8E, 0xE5, 0x3D, 0x45, 0xE4, 0xD2, 0x3F, 0x0B, 0xA0, 0x72, 0x02, 0x01, 0x10,
  // "±" (U+00B1)
  0x39, 0x03, 0x59, 0x03, 0x59, 0x03, 0x20, 0x7D, 0x86, 0xA1, 0x33, 0xF5, 0x32, 0x39, 0x03, 0x59,
  0x03, 0x20, 0x18, 0x01, 0x30, 0x20, 0x7D, 0x0A,
  // "²" (U+00B2)
  0x89, 0x02, 0xBD, 0x80, 0x36, 0x4F, 0x23, 0x90, 0x22, 0x08, 0x0B, 0x28, 0x54, 0xE1, 0x02, 0xE3,
  0x28, 0x39, 0xFE, 0xE4, 0x10, 0xF1, 0x10,
  // "³" (U+00B3)
  0x89, 0x03, 0xBD, 0x80, 0x35, 0x3F, 0x22, 0x85, 0x1E, 0x10, 0x9F, 0x82, 0x83, 0x13, 0xE3, 0x22,
  0x81, 0xD5, 0x7A, 0x0B, 0x10,
  // "´" (U+00B4)
  0x18, 0x90, 0x17, 0x40, 0x9E, 0x13, 0xE2, 0x10,
  // "µ" (U+00B5)
  0x90, 0x72, 0x82, 0xAB, 0xF7, 0x28, 0x2A, 0xBF, 0x72, 0x82, 0xAB, 0xF7, 0x28, 0x2A, 0xBF, 0x72,
  0x82, 0xBB, 0xF8, 0x28, 0x96, 0xDB, 0xFD, 0x48, 0xFB, 0xFC, 0xEB, 0x7B, 0xF7, 0x49, 0x07, 0x49,
  0x07, 0x40,
  // "¶" (U+00B6)
  0x10, 0x20, 0xCB, 0x81, 0xC0, 0xCA, 0x82, 0xC5, 0xC1, 0xB8, 0x2B, 0x1C, 0x2B, 0x82, 0xB1, 0xC2,
  0xB8, 0x1B, 0x1C, 0x1B, 0x83, 0xB1, 0xC0, 0x9A, 0x81, 0xB1, 0xC2, 0x83, 0x68, 0xB1, 0xC3, 0x82,
  0x2B, 0x1C, 0x38, 0x22, 0xB1, 0xC3, 0x82, 0x2B, 0x1C, 0x38, 0x22, 0xB1, 0xC3, 0x82, 0x2B, 0x1C,
  0x48, 0x12, 0x02,
  // "·" (U+00B7)
  0x82, 0xD9, 0xC9,
  // "¸" (U+00B8)
  0x89, 0x21, 0x60, 0x3B, 0x64, 0xAC, 0xDD, 0x50,
  // "¹" (U+00B9)
  0x18, 0x53, 0xE8, 0x2D, 0xB8, 0x20, 0x90, 0x82, 0x09, 0x08, 0x20, 0x90, 0x82, 0x09, 0x08,
  // "º" (U+00BA)
  0x18, 0xA5, 0xAB, 0xB1, 0x6A, 0x09, 0x78, 0x80, 0x79, 0x5B, 0x0A, 0x60, 0x8B, 0x91,
  // "»" (U+00BB)
  0x84, 0x3E, 0x22, 0xE2, 0x28, 0x3B, 0xC0, 0xBC, 0x28, 0xB0, 0x1E, 0x91, 0xE9, 0x02, 0xE9, 0x1E,
  0x90, 0xBC, 0x0B, 0xC0, 0x3E, 0x23, 0xE2, 0x10,
  // "¼" (U+00BC)
  0x18, 0x15, 0xE6, 0x30, 0x30, 0xE2, 0x82, 0x4C, 0xC6, 0x30, 0xC0, 0x64, 0x0C, 0x06, 0x20, 0x60,
  0xC5, 0x0C, 0x06, 0x20, 0xE0, 0x35, 0x87, 0xC6, 0x08, 0xA0, 0x4F, 0x32, 0x87, 0xC6, 0x2E, 0x20,
  0xCE, 0x34, 0x85, 0xA8, 0x07, 0x6E, 0x33, 0x86, 0x4E, 0x02, 0xC0, 0xE3, 0x38, 0x6C, 0x60, 0x7E,
  0xEF, 0xE2, 0x06, 0x0C, 0x50, 0xE0, 0x30,
  // "½" (U+00BD)
  0x18, 0x15, 0xE5, 0x30, 0x70, 0xB2, 0x82, 0x5C, 0xD5, 0x28, 0x11, 0xE2, 0x40, 0xC0, 0x52, 0x00,
  0x95, 0x84, 0xC5, 0x02, 0xE1, 0x58, 0x7C, 0x50, 0xB7, 0x7D, 0xD5, 0x28, 0x7C, 0x54, 0xD0, 0x31,
  0x7C, 0x40, 0xD0, 0x53, 0x08, 0x09, 0x30, 0x60, 0xC3, 0x06, 0x0C, 0x40, 0xE0, 0x32, 0x81, 0x6C,
  0x13, 0x08, 0x0A, 0x3C, 0x20, 0x20, 0x13, 0x80, 0x03,
  // "¾" (U+00BE)
  0x82, 0x3C, 0xF9, 0x40, 0xE0, 0x42, 0x83, 0x36, 0x4F, 0x22, 0x07, 0x0B, 0x58, 0x52, 0xE1, 0x01,
  0xE3, 0x48, 0x1A, 0xF8, 0x20, 0x80, 0xB5, 0x85, 0x24, 0xE4, 0x1E, 0x34, 0x89, 0x32, 0x11, 0xD5,
  0x8A, 0x01, 0xE7, 0x07, 0xA8, 0x6C, 0x2E, 0x20, 0x9C, 0x72, 0x89, 0x01, 0x20, 0x99, 0x04, 0x9A,
  0x74, 0x86, 0x2E, 0x20, 0xC1, 0xA7, 0x48, 0x49, 0x90, 0x3E, 0xEA, 0x03, 0x28, 0x12, 0xE1, 0x40,
  0xA0, 0x71,
  // "¿" (U+00BF)
  0x28, 0x11, 0xE7, 0x38, 0x12, 0xE7, 0x73, 0x0C, 0x04, 0x38, 0x14, 0xF2, 0x28, 0x13, 0xE8, 0x30,
  0xD0, 0xA3, 0x81, 0x2F, 0x54, 0x98, 0x90, 0xA4, 0x66, 0x05, 0xDF, 0xD6,
  // "À" (U+00C0)
  0x18, 0x12, 0x73, 0x60, 0xB0, 0xD7, 0x0B, 0x07, 0x77, 0x78, 0x11, 0xFE, 0x58, 0x26, 0xEF, 0x44,
  0x82, 0xBA, 0xC9, 0x49, 0x81, 0x68, 0xD3, 0x84, 0x5F, 0x24, 0xF3, 0x28, 0x49, 0xE1, 0x1F, 0x82,
  0x0E, 0xC8, 0x93, 0xC0, 0x3F, 0x84, 0x49, 0xF2, 0x8F, 0x12, 0x83, 0x2F, 0x6D, 0xC4, 0x0D, 0x0B,
  // "Á" (U+00C1)
  0x48, 0x11, 0x74, 0x58, 0x19, 0xE1, 0x48, 0x13, 0xE2, 0x77, 0x68, 0x11, 0xFE, 0x58, 0x26, 0xEF,
  0x44, 0x82, 0xBA, 0xC9, 0x49, 0x81, 0x68, 0xD3, 0x84, 0x5F, 0x24, 0xF3, 0x28, 0x49, 0xE1, 0x1F,
  0x82, 0x0E, 0xC8, 0x93, 0xC0, 0x3F, 0x84, 0x49, 0xF2, 0x8F, 0x12, 0x83, 0x2F, 0x6D, 0xC4, 0x0D,
  0x0B,
  // "Â" (U+00C2)
  0x30, 0x70, 0x55, 0x82, 0x7D, 0xE2, 0x38, 0x32, 0xD2, 0x5C, 0x77, 0x68, 0x11, 0xFE, 0x58, 0x26,
  0xEF, 0x44, 0x82, 0xBA, 0xC9, 0x49, 0x81, 0x68, 0xD3, 0x84, 0x5F, 0x24, 0xF3, 0x28, 0x49, 0xE1,
  0x1F, 0x82, 0x0E, 0xC8, 0x93, 0xC0, 0x3F, 0x84, 0x49, 0xF2, 0x8F, 0x12, 0x83, 0x2F, 0x6D, 0xC4,
  0x0D, 0x0B,
  // "Ã" (U+00C3)
  0x28, 0x3C, 0xD4, 0x86, 0x28, 0x44, 0xB6, 0xEE, 0x12, 0x00, 0x12, 0x01, 0x75, 0x81, 0x1F, 0xE5,
  0x82, 0x6E, 0xF4, 0x48, 0x2B, 0xAC, 0x94, 0x98, 0x16, 0x8D, 0x38, 0x45, 0xF2, 0x4F, 0x32, 0x84,
  0x9E, 0x11, 0xF8, 0x20, 0xEC, 0x89, 0x3C, 0x03, 0xF8, 0x44, 0x9F, 0x28, 0xF1, 0x28, 0x32, 0xF6,
  0xDC, 0x40, 0xD0, 0xB0,
  // "Ä" (U+00C4)
  0x28, 0x2D, 0x44, 0xE4, 0x01, 0x20, 0x17, 0x58, 0x11, 0xFE, 0x58, 0x26, 0xEF, 0x44, 0x82, 0xBA,
  0xC9, 0x49, 0x81, 0x68, 0xD3, 0x84, 0x5F, 0x24, 0xF3, 0x28, 0x49, 0xE1, 0x1F, 0x82, 0x0E, 0xC8,
  0x93, 0xC0, 0x3F, 0x84, 0x49, 0xF2, 0x8F, 0x12, 0x83, 0x2F, 0x6D, 0xC4, 0x0D, 0x0B,
  // "Å" (U+00C5)
  0x28, 0x21, 0xCF, 0x64, 0x82, 0x5B, 0x6D, 0x48, 0x22, 0xEF, 0x84, 0x01, 0xA5, 0x82, 0x6E, 0xF4,
  0x48, 0x2B, 0xAC, 0x94, 0x98, 0x16, 0x8D, 0x38, 0x45, 0xF2, 0x4F, 0x32, 0x84, 0x9E, 0x11, 0xF8,
  0x20, 0xEC, 0x89, 0x3C, 0x03, 0xF8, 0x44, 0x9F, 0x28, 0xF1, 0x28, 0x32, 0xF6, 0xDC, 0x40, 0xD0,
  0xB0,
  // "Æ" (U+00C6)
  0x30, 0x7E, 0x38, 0x2C, 0xAD, 0xC0, 0xF3, 0x28, 0x33, 0xF4, 0xCB, 0x58, 0x39, 0xE0, 0xCB, 0x58,
  0x2E, 0x90, 0xCB, 0x89, 0x3C, 0x05, 0xF4, 0x0C, 0xC3, 0x32, 0x0B, 0xC0, 0xB3, 0x85, 0x1F, 0x93,
  0x3D, 0xB3, 0x81, 0x7F, 0x22, 0x85, 0xCC, 0x33, 0x3D, 0xC3, 0x0C, 0xC0,
  // "Ç" (U+00C7)
  0x28, 0x93, 0x3B, 0xEE, 0xB1, 0x03, 0xFB, 0x45, 0x92, 0x0B, 0x0D, 0x58, 0x11, 0xF8, 0x58, 0x12,
  0xF6, 0x58, 0x13, 0xF6, 0x58, 0x11, 0xF8, 0x60, 0xC0, 0xE6, 0x84, 0x4F, 0xC5, 0x47, 0x38, 0x34,
  0xCF, 0xEA, 0x40, 0x10, 0x66, 0x81, 0x3B, 0x65, 0x81, 0x4A, 0xC5, 0x81, 0xDD, 0x52,
  // "È" (U+00C8)
  0x81, 0x27, 0x34, 0x0B, 0x0D, 0x50, 0xB0, 0x77, 0x70, 0xCC, 0x87, 0x1C, 0xB3, 0x33, 0x0C, 0xA4,
  0x0C, 0x0B, 0x40, 0xCB, 0x89, 0x0D, 0x0C, 0xB3, 0x32, 0x0C, 0xA4, 0x0C, 0x0A, 0x48, 0x5C, 0xB3,
  0x33, 0x0C, 0xC0, 0x10,
  // "É" (U+00C9)
  0x28, 0x11, 0x74, 0x38, 0x19, 0xE1, 0x28, 0x13, 0xE2, 0x77, 0x0C, 0xC8, 0x71, 0xCB, 0x33, 0x30,
  0xCA, 0x40, 0xC0, 0xB4, 0x0C, 0xB8, 0x90, 0xD0, 0xCB, 0x33, 0x20, 0xCA, 0x40, 0xC0, 0xA4, 0x85,
  0xCB, 0x33, 0x30, 0xCC, 0x01,
  // "Ê" (U+00CA)
  0x20, 0x70, 0x53, 0x89, 0x07, 0xDE, 0x20, 0x2D, 0x25, 0xC7, 0x60, 0xCC, 0x87, 0x1C, 0xB3, 0x33,
  0x0C, 0xA4, 0x0C, 0x0B, 0x40, 0xCB, 0x89, 0x0D, 0x0C, 0xB3, 0x32, 0x0C, 0xA4, 0x0C, 0x0A, 0x48,
  0x5C, 0xB3, 0x33, 0x0C, 0xC0, 0x10,
  // "Ë" (U+00CB)
  0x18, 0x2D, 0x44, 0xE2, 0x01, 0x20, 0x17, 0x0C, 0xC8, 0x71, 0xCB, 0x33, 0x30, 0xCA, 0x40, 0xC0,
  0xB4, 0x0C, 0xB8, 0x90, 0xD0, 0xCB, 0x33, 0x20, 0xCA, 0x40, 0xC0, 0xA4, 0x85, 0xCB, 0x33, 0x30,
  0xCC, 0x01,
  // "Ì" (U+00CC)
  0x81, 0x27, 0x33, 0x0B, 0x0D, 0x40, 0xB0, 0x77, 0x40, 0x7B, 0x83, 0x20, 0x7F, 0x22, 0x81, 0x6F,
  0x12, 0x81, 0x6F, 0x12, 0x81, 0x6F, 0x12, 0x81, 0x6F, 0x12, 0x81, 0x6F, 0x12, 0x81, 0x6F, 0x12,
  0x83, 0x6F, 0x20, 0x6B, 0x02,
  // "Í" (U+00CD)
  0x28, 0x11, 0x74, 0x28, 0x59, 0xE1, 0x03, 0xE2, 0x74, 0x07, 0xB8, 0x32, 0x07, 0xF2, 0x28, 0x16,
  0xF1, 0x28, 0x16, 0xF1, 0x28, 0x16, 0xF1, 0x28, 0x16, 0xF1, 0x28, 0x16, 0xF1, 0x28, 0x16, 0xF1,
  0x28, 0x36, 0xF2, 0x06, 0xB0, 0x20,
  // "Î" (U+00CE)
  0x20, 0x70, 0x52, 0x87, 0x7D, 0xE2, 0x2D, 0x25, 0xC7, 0x30, 0x7B, 0x83, 0x20, 0x7F, 0x22, 0x81,
  0x6F, 0x12, 0x81, 0x6F, 0x12, 0x81, 0x6F, 0x12, 0x81, 0x6F, 0x12, 0x81, 0x6F, 0x12, 0x81, 0x6F,
  0x12, 0x83, 0x6F, 0x20, 0x6B, 0x02,
  // "Ï" (U+00CF)
  0x84, 0xD4, 0x4E, 0x01, 0x20, 0x16, 0x07, 0xB8, 0x32, 0x07, 0xF2, 0x28, 0x16, 0xF1, 0x28, 0x16,
  0xF1, 0x28, 0x16, 0xF1, 0x28, 0x16, 0xF1, 0x28, 0x16, 0xF1, 0x28, 0x16, 0xF1, 0x28, 0x36, 0xF2,
  0x06, 0xB0, 0x20,
  // "Ð" (U+00D0)
  0x10, 0xCA, 0x81, 0xEA, 0x22, 0x89, 0x0C, 0xC3, 0x5D, 0xE2, 0x0C, 0xB2, 0x84, 0x1F, 0xA0, 0xCB,
  0x38, 0x1A, 0xEA, 0xB8, 0x95, 0x60, 0x8F, 0x2D, 0xC3, 0x10, 0x9F, 0x0C, 0xB3, 0x83, 0xBD, 0x0C,
  0xB2, 0x89, 0x31, 0xF9, 0x0C, 0xC3, 0x6D, 0xE1, 0x0C, 0xA8, 0x1E, 0xA2, 0x10,
  // "Ñ" (U+00D1)
  0x28, 0x3C, 0xD4, 0x86, 0x28, 0x44, 0xB6, 0xEE, 0x12, 0x00, 0x12, 0x01, 0x73, 0x81, 0xCF, 0x43,
  0x98, 0x27, 0xCF, 0xC3, 0x98, 0x37, 0xCC, 0xF4, 0x29, 0x83, 0x7C, 0x8C, 0xC2, 0x98, 0xB1, 0x7C,
  0x93, 0xF5, 0x0F, 0x7C, 0x90, 0xBD, 0x0F, 0x7C, 0x90, 0x3F, 0x5E, 0x7C, 0x92, 0x84, 0xAD, 0xE7,
  0xC9, 0x20, 0x2A, 0x81, 0x7C, 0x93, 0x81, 0x9F, 0x70,
  // "Ò" (U+00D2)
  0x28, 0x12, 0x73, 0x70, 0xB0, 0xD7, 0x10, 0xB0, 0x77, 0x77, 0x28, 0x35, 0xCF, 0xD9, 0x38, 0x55,
  0xFA, 0x46, 0xEB, 0x20, 0x0D, 0x38, 0x46, 0xF3, 0x1F, 0x83, 0x84, 0x1F, 0x83, 0xF6, 0x49, 0x82,
  0x92, 0xF6, 0x49, 0x82, 0x91, 0xF8, 0x38, 0x41, 0xF8, 0x0C, 0xD3, 0x89, 0x16, 0xF3, 0x04, 0xFA,
  0x46, 0xEB, 0x38, 0x34, 0xCE, 0xD9, 0x20,
  // "Ó" (U+00D3)
  0x48, 0x11, 0x74, 0x68, 0x19, 0xE1, 0x58, 0x13, 0xE2, 0x77, 0x72, 0x83, 0x5C, 0xFD, 0x93, 0x85,
  0x5F, 0xA4, 0x6E, 0xB2, 0x00, 0xD3, 0x84, 0x6F, 0x31, 0xF8, 0x38, 0x41, 0xF8, 0x3F, 0x64, 0x98,
  0x29, 0x2F, 0x64, 0x98, 0x29, 0x1F, 0x83, 0x84, 0x1F, 0x80, 0xCD, 0x38, 0x91, 0x6F, 0x30, 0x4F,
  0xA4, 0x6E, 0xB3, 0x83, 0x4C, 0xED, 0x92,
  // "Ô" (U+00D4)
  0x40, 0x70, 0x56, 0x82, 0x7D, 0xE2, 0x48, 0x32, 0xD2, 0x5C, 0x77, 0x71, 0x83, 0x5C, 0xFD, 0x93,
  0x85, 0x5F, 0xA4, 0x6E, 0xB2, 0x00, 0xD3, 0x84, 0x6F, 0x31, 0xF8, 0x38, 0x41, 0xF8, 0x3F, 0x64,
  0x98, 0x29, 0x2F, 0x64, 0x98, 0x29, 0x1F, 0x83, 0x84, 0x1F, 0x80, 0xCD, 0x38, 0x91, 0x6F, 0x30,
  0x4F, 0xA4, 0x6E, 0xB3, 0x83, 0x4C, 0xED, 0x92,
  // "Õ" (U+00D5)
  0x38, 0x3C, 0xD4, 0x86, 0x38, 0x44, 0xB6, 0xEE, 0x13, 0x00, 0x12, 0x01, 0x76, 0x83, 0x5C, 0xFD,
  0x93, 0x85, 0x5F, 0xA4, 0x6E, 0xB2, 0x00, 0xD3, 0x84, 0x6F, 0x31, 0xF8, 0x38, 0x41, 0xF8, 0x3F,
  0x64, 0x98, 0x29, 0x2F, 0x64, 0x98, 0x29, 0x1F, 0x83, 0x84, 0x1F, 0x80, 0xCD, 0x38, 0x91, 0x6F,
  0x30, 0x4F, 0xA4, 0x6E, 0xB3, 0x83, 0x4C, 0xED, 0x92,
  // "Ö" (U+00D6)
  0x38, 0x2D, 0x44, 0xE5, 0x01, 0x20, 0x17, 0x68, 0x35, 0xCF, 0xD9, 0x38, 0x55, 0xFA, 0x46, 0xEB,
  0x20, 0x0D, 0x38, 0x46, 0xF3, 0x1F, 0x83, 0x84, 0x1F, 0x83, 0xF6, 0x49, 0x82, 0x92, 0xF6, 0x49,
  0x82, 0x91, 0xF8, 0x38, 0x41, 0xF8, 0x0C, 0xD3, 0x89, 0x16, 0xF3, 0x04, 0xFA, 0x46, 0xEB, 0x38,
  0x34, 0xCE, 0xD9, 0x20,
  // "×" (U+00D7)
  0x10, 0x13, 0x89, 0x51, 0x02, 0xE4, 0x02, 0xD5, 0x07, 0xE6, 0xD9, 0x38, 0x18, 0xFB, 0x38, 0x95,
  0x2D, 0xCE, 0x40, 0x1D, 0x90, 0x7E, 0x30, 0x63, 0x05, 0x01,
  // "Ø" (U+00D8)
  0x70, 0x23, 0x89, 0x55, 0xCF, 0xD8, 0xE2, 0x05, 0xFA, 0x46, 0xFC, 0x20, 0xD0, 0xC2, 0x03, 0xA8,
  0x23, 0x1F, 0x72, 0x8B, 0x1C, 0x5F, 0x83, 0xF6, 0x07, 0xA0, 0xE9, 0x2F, 0x62, 0xD1, 0x0E, 0xA0,
  0xF8, 0xB6, 0x29, 0x83, 0x80, 0xCE, 0xC2, 0x89, 0x16, 0xF4, 0x05, 0xFA, 0x46, 0xEB, 0x28, 0x58,
  0xBC, 0xEE, 0x91, 0x20, 0x30, 0x16,
  // "Ù" (U+00D9)
  0x18, 0x12, 0x73, 0x50, 0xB0, 0xD6, 0x0B, 0x07, 0x77, 0x20, 0xE0, 0x93, 0x82, 0xAD, 0xE9, 0x38,
  0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A, 0xDE,
  0x93, 0x82, 0xAC, 0xCB, 0x38, 0x95, 0xCB, 0x7F, 0x74, 0x8F, 0x50, 0x7D, 0xED, 0x61,
  // "Ú" (U+00DA)
  0x38, 0x11, 0x74, 0x48, 0x19, 0xE1, 0x38, 0x13, 0xE2, 0x77, 0x20, 0xE0, 0x93, 0x82, 0xAD, 0xE9,
  0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A,
  0xDE, 0x93, 0x82, 0xAC, 0xCB, 0x38, 0x95, 0xCB, 0x7F, 0x74, 0x8F, 0x50, 0x7D, 0xED, 0x61,
  // "Û" (U+00DB)
  0x30, 0x70, 0x54, 0x82, 0x7D, 0xE2, 0x28, 0x32, 0xD2, 0x5C, 0x77, 0x10, 0xE0, 0x93, 0x82, 0xAD,
  0xE9, 0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9, 0x38,
  0x2A, 0xDE, 0x93, 0x82, 0xAC, 0xCB, 0x38, 0x95, 0xCB, 0x7F, 0x74, 0x8F, 0x50, 0x7D, 0xED, 0x61,
  // "Ü" (U+00DC)
  0x18, 0x2D, 0x44, 0xE3, 0x01, 0x20, 0x17, 0x20, 0xE0, 0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A, 0xDE,
  0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A, 0xDE, 0x93, 0x82,
  0xAC, 0xCB, 0x38, 0x95, 0xCB, 0x7F, 0x74, 0x8F, 0x50, 0x7D, 0xED, 0x61,
  // "Ý" (U+00DD)
  0x38, 0x11, 0x74, 0x48, 0x19, 0xE1, 0x38, 0x13, 0xE2, 0x77, 0x20, 0x0C, 0x38, 0x95, 0xCB, 0x5F,
  0x30, 0x2F, 0x40, 0xD9, 0x08, 0xD2, 0x83, 0x7E, 0x1E, 0x63, 0x81, 0xEA, 0xE4, 0x81, 0x8F, 0x84,
  0x81, 0x4F, 0x44, 0x81, 0x4F, 0x44, 0x81, 0x4F, 0x44, 0x81, 0x4F, 0x42,
  // "Þ" (U+00DE)
  0x0C, 0x0B, 0x40, 0xCA, 0x89, 0x1D, 0x80, 0xCB, 0x37, 0xF7, 0xCA, 0x28, 0x2B, 0xCC, 0xA2, 0x82,
  0x9E, 0xCA, 0x28, 0x7B, 0xDC, 0xB1, 0x5F, 0x8C, 0xB8, 0x4A, 0x0C, 0xB2, 0x12, 0x0C, 0x0A, 0x40,
  // "ß" (U+00DF)
  0x83, 0x1A, 0xEE, 0xA2, 0x87, 0xAE, 0x55, 0xF8, 0x0E, 0x82, 0x89, 0x5D, 0x90, 0xF7, 0x06, 0xF3,
  0x0F, 0x72, 0xF5, 0x29, 0x82, 0x74, 0xF4, 0x29, 0x86, 0x70, 0xBE, 0x40, 0xF7, 0x28, 0x3A, 0xF2,
  0xF7, 0x28, 0x96, 0x1F, 0x6F, 0x76, 0x47, 0xF4, 0xF7, 0x8E, 0xE9, 0x10,
  // "à" (U+00E0)
  0x18, 0x12, 0x73, 0x50, 0xB0, 0xD6, 0x0B, 0x07, 0x73, 0x83, 0x5C, 0xED, 0x42, 0x83, 0x46, 0x4B,
  0xD5, 0x84, 0x6F, 0x10, 0x6D, 0xB8, 0xB3, 0x13, 0xF9, 0x37, 0xF1, 0x6F, 0x10, 0x7F, 0x14, 0xF7,
  0x5D, 0xF1, 0x09, 0xEC, 0x3F, 0x10,
  // "á" (U+00E1)
  0x38, 0x11, 0x74, 0x48, 0x19, 0xE1, 0x38, 0x13, 0xE2, 0x73, 0x83, 0x5C, 0xED, 0x42, 0x83, 0x46,
  0x4B, 0xD5, 0x84, 0x6F, 0x10, 0x6D, 0xB8, 0xB3, 0x13, 0xF9, 0x37, 0xF1, 0x6F, 0x10, 0x7F, 0x14,
  0xF7, 0x5D, 0xF1, 0x09, 0xEC, 0x3F, 0x10,
  // "â" (U+00E2)
  0x30, 0x70, 0x54, 0x82, 0x7D, 0xE2, 0x28, 0x32, 0xD2, 0x5C, 0x72, 0x83, 0x5C, 0xED, 0x42, 0x83,
  0x46, 0x4B, 0xD5, 0x84, 0x6F, 0x10, 0x6D, 0xB8, 0xB3, 0x13, 0xF9, 0x37, 0xF1, 0x6F, 0x10, 0x7F,
  0x14, 0xF7, 0x5D, 0xF1, 0x09, 0xEC, 0x3F, 0x10,
  // "ã" (U+00E3)
  0x28, 0x95, 0xCD, 0x48, 0x60, 0x4B, 0x6E, 0xE1, 0x01, 0x12, 0x01, 0x28, 0x35, 0xCE, 0xD4, 0x28,
  0x34, 0x64, 0xBD, 0x58, 0x46, 0xF1, 0x06, 0xDB, 0x8B, 0x31, 0x3F, 0x93, 0x7F, 0x16, 0xF1, 0x07,
  0xF1, 0x4F, 0x75, 0xDF, 0x10, 0x9E, 0xC3, 0xF1,
  // "ä" (U+00E4)
  0x28, 0x2D, 0x44, 0xE3, 0x01, 0x20, 0x12, 0x83, 0x5C, 0xED, 0x42, 0x83, 0x46, 0x4B, 0xD5, 0x84,
  0x6F, 0x10, 0x6D, 0xB8, 0xB3, 0x13, 0xF9, 0x37, 0xF1, 0x6F, 0x10, 0x7F, 0x14, 0xF7, 0x5D, 0xF1,
  0x09, 0xEC, 0x3F, 0x10,
  // "å" (U+00E5)
  0x18, 0x21, 0xCF, 0x63, 0x82, 0x5B, 0x6D, 0x38, 0x22, 0xEF, 0x85, 0x02, 0x48, 0x35, 0xCE, 0xD4,
  0x28, 0x34, 0x64, 0xBD, 0x58, 0x46, 0xF1, 0x06, 0xDB, 0x8B, 0x31, 0x3F, 0x93, 0x7F, 0x16, 0xF1,
  0x07, 0xF1, 0x4F, 0x75, 0xDF, 0x10, 0x9E, 0xC3, 0xF1,
  // "æ" (U+00E6)
  0x18, 0x76, 0xDF, 0xC3, 0xBF, 0xC2, 0x28, 0x75, 0x64, 0xCF, 0xA4, 0xBD, 0x58, 0x90, 0x7F, 0x20,
  0x3F, 0x20, 0x6D, 0xF8, 0xA1, 0x43, 0xF9, 0x38, 0xF4, 0x33, 0x30, 0x6F, 0x10, 0x8F, 0x44, 0x89,
  0x04, 0xF7, 0x5D, 0xCD, 0x44, 0x82, 0x87, 0x9E, 0xD4, 0x1B, 0xEE, 0x91,
  // "ç" (U+00E7)
  0x18, 0x94, 0x1B, 0xFE, 0x50, 0xBD, 0x55, 0x22, 0xF6, 0x38, 0x14, 0xF3, 0x38, 0x15, 0xF3, 0x38,
  0x13, 0xF5, 0x48, 0x91, 0xDD, 0x55, 0x40, 0x2B, 0xED, 0x52, 0x01, 0x06, 0x48, 0x13, 0xB6, 0x38,
  0x14, 0xAC, 0x38, 0x1D, 0xD5, 0x10,
  // "è" (U+00E8)
  0x18, 0x12, 0x73, 0x50, 0xB0, 0xD6, 0x0B, 0x07, 0x73, 0x83, 0x2B, 0xFD, 0x42, 0x87, 0xBC, 0x49,
  0xE1, 0x2F, 0x42, 0x90, 0x50, 0x4D, 0x89, 0x17, 0x4F, 0x53, 0x33, 0x12, 0xF5, 0x58, 0x92, 0xBD,
  0x54, 0x81, 0x01, 0xAE, 0xEB, 0x10,
  // "é" (U+00E9)
  0x38, 0x11, 0x74, 0x48, 0x19, 0xE1, 0x38, 0x13, 0xE2, 0x73, 0x83, 0x2B, 0xFD, 0x42, 0x87, 0xBC,
  0x49, 0xE1, 0x2F, 0x42, 0x90, 0x50, 0x4D, 0x89, 0x17, 0x4F, 0x53, 0x33, 0x12, 0xF5, 0x58, 0x92,
  0xBD, 0x54, 0x81, 0x01, 0xAE, 0xEB, 0x10,
  // "ê" (U+00EA)
  0x30, 0x70, 0x54, 0x82, 0x7D, 0xE2, 0x28, 0x32, 0xD2, 0x5C, 0x72, 0x83, 0x2B, 0xFD, 0x42, 0x87,
  0xBC, 0x49, 0xE1, 0x2F, 0x42, 0x90, 0x50, 0x4D, 0x89, 0x17, 0x4F, 0x53, 0x33, 0x12, 0xF5, 0x58,
  0x92, 0xBD, 0x54, 0x81, 0x01, 0xAE, 0xEB, 0x10,
  // "ë" (U+00EB)
  0x28, 0x2D, 0x44, 0xE3, 0x01, 0x20, 0x12, 0x83, 0x2B, 0xFD, 0x42, 0x87, 0xBC, 0x49, 0xE1, 0x2F,
  0x42, 0x90, 0x50, 0x4D, 0x89, 0x17, 0x4F, 0x53, 0x33, 0x12, 0xF5, 0x58, 0x92, 0xBD, 0x54, 0x81,
  0x01, 0xAE, 0xEB, 0x10,
  // "ì" (U+00EC)
  0x81, 0x27, 0x32, 0x0B, 0x0D, 0x30, 0xB0, 0x76, 0x90, 0x72, 0x90, 0x72, 0x90, 0x72, 0x90, 0x72,
  0x90, 0x72, 0x90, 0x72, 0x90, 0x72, 0x90, 0x70,
  // "í" (U+00ED)
  0x18, 0x90, 0x17, 0x40, 0x9E, 0x13, 0xE2, 0x69, 0x07, 0x29, 0x07, 0x29, 0x07, 0x29, 0x07, 0x29,
  0x07, 0x29, 0x07, 0x29, 0x07, 0x29, 0x07, 0x10,
  // "î" (U+00EE)
  0x20, 0x70, 0x52, 0x87, 0x7D, 0xE2, 0x2D, 0x25, 0xC7, 0x90, 0x73, 0x90, 0x73, 0x90, 0x73, 0x90,
  0x73, 0x90, 0x73, 0x90, 0x73, 0x90, 0x73, 0x90, 0x71,
  // "ï" (U+00EF)
  0x83, 0xD4, 0x4E, 0x12, 0x82, 0x10, 0xF7, 0x29, 0x07, 0x29, 0x07, 0x29, 0x07, 0x29, 0x07, 0x29,
  0x07, 0x29, 0x07, 0x29, 0x07, 0x10,
  // "ð" (U+00F0)
  0x28, 0x29, 0xB9, 0xB3, 0x05, 0xA0, 0x13, 0x82, 0xA4, 0xDA, 0x58, 0xA2, 0x4F, 0x30, 0x2C, 0xFC,
  0xE8, 0x0D, 0xC4, 0x6F, 0xC3, 0xF4, 0x28, 0x3B, 0xD4, 0xF2, 0x28, 0x39, 0xD3, 0xF4, 0x28, 0x95,
  0xBB, 0x0C, 0xC4, 0x7F, 0x50, 0x1B, 0xEE, 0x71,
  // "ñ" (U+00F1)
  0x18, 0x90, 0xCD, 0x48, 0x64, 0xB6, 0xEE, 0x0F, 0x12, 0x89, 0x61, 0x0F, 0x5B, 0xEB, 0x1F, 0xE6,
  0x5F, 0x8F, 0xA2, 0x82, 0xBB, 0xF8, 0x28, 0x2A, 0xBF, 0x72, 0x82, 0xAB, 0xF7, 0x28, 0x2A, 0xBF,
  0x72, 0x82, 0xAB, 0xF7, 0x20, 0xA0, 0xB0,
  // "ò" (U+00F2)
  0x18, 0x12, 0x73, 0x50, 0xB0, 0xD6, 0x0B, 0x07, 0x73, 0x83, 0x2B, 0xFD, 0x62, 0x87, 0xBD, 0x47,
  0xF4, 0x2F, 0x52, 0x83, 0xCA, 0x4F, 0x32, 0x83, 0xAD, 0x4F, 0x32, 0x83, 0xAD, 0x2F, 0x52, 0x89,
  0x5C, 0xB0, 0xBD, 0x47, 0xF4, 0x01, 0xAE, 0xD6, 0x10,
  // "ó" (U+00F3)
  0x38, 0x11, 0x74, 0x48, 0x19, 0xE1, 0x38, 0x13, 0xE2, 0x73, 0x83, 0x2B, 0xFD, 0x62, 0x87, 0xBD,
  0x47, 0xF4, 0x2F, 0x52, 0x83, 0xCA, 0x4F, 0x32, 0x83, 0xAD, 0x4F, 0x32, 0x83, 0xAD, 0x2F, 0x52,
  0x89, 0x5C, 0xB0, 0xBD, 0x47, 0xF4, 0x01, 0xAE, 0xD6, 0x10,
  // "ô" (U+00F4)
  0x30, 0x70, 0x54, 0x82, 0x7D, 0xE2, 0x28, 0x32, 0xD2, 0x5C, 0x72, 0x83, 0x2B, 0xFD, 0x62, 0x87,
  0xBD, 0x47, 0xF4, 0x2F, 0x52, 0x83, 0xCA, 0x4F, 0x32, 0x83, 0xAD, 0x4F, 0x32, 0x83, 0xAD, 0x2F,
  0x52, 0x89, 0x5C, 0xB0, 0xBD, 0x47, 0xF4, 0x01, 0xAE, 0xD6, 0x10,
  // "õ" (U+00F5)
  0x28, 0x95, 0xCD, 0x48, 0x60, 0x4B, 0x6E, 0xE1, 0x01, 0x12, 0x01, 0x28, 0x32, 0xBF, 0xD6, 0x28,
  0x7B, 0xD4, 0x7F, 0x42, 0xF5, 0x28, 0x3C, 0xA4, 0xF3, 0x28, 0x3A, 0xD4, 0xF3, 0x28, 0x3A, 0xD2,
  0xF5, 0x28, 0x95, 0xCB, 0x0B, 0xD4, 0x7F, 0x40, 0x1A, 0xED, 0x61,
  // "ö" (U+00F6)
  0x28, 0x2D, 0x44, 0xE3, 0x01, 0x20, 0x12, 0x83, 0x2B, 0xFD, 0x62, 0x87, 0xBD, 0x47, 0xF4, 0x2F,
  0x52, 0x83, 0xCA, 0x4F, 0x32, 0x83, 0xAD, 0x4F, 0x32, 0x83, 0xAD, 0x2F, 0x52, 0x89, 0x5C, 0xB0,
  0xBD, 0x47, 0xF4, 0x01, 0xAE, 0xD6, 0x10,
  // "÷" (U+00F7)
  0x28, 0x11, 0xD4, 0x48, 0x11, 0xC3, 0x72, 0x07, 0xD0, 0xA0, 0x18, 0x01, 0x30, 0x22, 0x81, 0x1C,
  0x34, 0x81, 0x1D, 0x42,
  // "ø" (U+00F8)
  0x58, 0xE7, 0x12, 0x02, 0xBF, 0xDC, 0x60, 0xCD, 0x49, 0xF3, 0x2F, 0x50, 0xCE, 0xA4, 0xF2, 0x69,
  0x9C, 0x4F, 0x3D, 0x19, 0xC2, 0xFD, 0x60, 0xCA, 0x0A, 0xF4, 0x7F, 0x40, 0xCB, 0xED, 0x72, 0x07,
  0x50,
  // "ù" (U+00F9)
  0x81, 0x27, 0x34, 0x0B, 0x0D, 0x50, 0xB0, 0x77, 0x19, 0x07, 0x28, 0x2B, 0xBF, 0x72, 0x82, 0xBB,
  0xF7, 0x28, 0x2B, 0xBF, 0x72, 0x82, 0xBB, 0xF7, 0x28, 0x2C, 0xBF, 0x82, 0x89, 0x4D, 0xBC, 0xD2,
  0x7F, 0xB3, 0xDE, 0x98, 0xB0,
  // "ú" (U+00FA)
  0x28, 0x11, 0x74, 0x38, 0x19, 0xE1, 0x28, 0x13, 0xE2, 0x71, 0x90, 0x72, 0x82, 0xBB, 0xF7, 0x28,
  0x2B, 0xBF, 0x72, 0x82, 0xBB, 0xF7, 0x28, 0x2B, 0xBF, 0x72, 0x82, 0xCB, 0xF8, 0x28, 0x94, 0xDB,
  0xCD, 0x27, 0xFB, 0x3D, 0xE9, 0x8B,
  // "û" (U+00FB)
  0x20, 0x70, 0x53, 0x89, 0x07, 0xDE, 0x20, 0x2D, 0x25, 0xC7, 0x90, 0x72, 0x82, 0xBB, 0xF7, 0x28,
  0x2B, 0xBF, 0x72, 0x82, 0xBB, 0xF7, 0x28, 0x2B, 0xBF, 0x72, 0x82, 0xCB, 0xF8, 0x28, 0x94, 0xDB,
  0xCD, 0x27, 0xFB, 0x3D, 0xE9, 0x8B,
  // "ü" (U+00FC)
  0x18, 0x2D, 0x44, 0xE2, 0x01, 0x28, 0x21, 0x0F, 0x72, 0x82, 0xBB, 0xF7, 0x28, 0x2B, 0xBF, 0x72,
  0x82, 0xBB, 0xF7, 0x28, 0x2B, 0xBF, 0x72, 0x82, 0xCB, 0xF8, 0x28, 0x94, 0xDB, 0xCD, 0x27, 0xFB,
  0x3D, 0xE9, 0x8B,
  // "ý" (U+00FD)
  0x38, 0x11, 0x74, 0x48, 0x19, 0xE1, 0x38, 0x13, 0xE2, 0x72, 0x0C, 0x0B, 0x28, 0x96, 0x3F, 0x47,
  0xF1, 0x08, 0xE0, 0x2F, 0x50, 0xCA, 0x28, 0x3C, 0x91, 0xF5, 0x28, 0x17, 0xE5, 0x93, 0x82, 0x2F,
  0xCB, 0x48, 0x1C, 0xF6, 0x48, 0x18, 0xF1, 0x40, 0x0B, 0x38, 0x23, 0x6F, 0x53, 0x81, 0xAE, 0x84,
  // "þ" (U+00FE)
  0x90, 0x74, 0x90, 0x74, 0x90, 0x74, 0x98, 0x93, 0x8B, 0xFB, 0x1F, 0xE6, 0x5E, 0x9F, 0xA2, 0x82,
  0x9E, 0xF8, 0x20, 0x6A, 0x08, 0x20, 0x6A, 0x0A, 0x28, 0x96, 0x9E, 0xFE, 0x65, 0xE9, 0xF8, 0xBF,
  0xB1, 0xF8, 0x49, 0x08, 0x49, 0x08, 0x40,
  // "ÿ" (U+00FF)
  0x18, 0x2D, 0x44, 0xE3, 0x01, 0x20, 0x12, 0x0C, 0x0B, 0x28, 0x96, 0x3F, 0x47, 0xF1, 0x08, 0xE0,
  0x2F, 0x50, 0xCA, 0x28, 0x3C, 0x91, 0xF5, 0x28, 0x17, 0xE5, 0x93, 0x82, 0x2F, 0xCB, 0x48, 0x1C,
  0xF6, 0x48, 0x18, 0xF1, 0x40, 0x0B, 0x38, 0x23, 0x6F, 0x53, 0x81, 0xAE, 0x84,
  // "Ā" (U+0100)
  0x10, 0x6B, 0x09, 0x38, 0x31, 0x33, 0x32, 0x75, 0x81, 0x1F, 0xE5, 0x82, 0x6E, 0xF4, 0x48, 0x2B,
  0xAC, 0x94, 0x98, 0x16, 0x8D, 0x38, 0x45, 0xF2, 0x4F, 0x32, 0x84, 0x9E, 0x11, 0xF8, 0x20, 0xEC,
  0x89, 0x3C, 0x03, 0xF8, 0x44, 0x9F, 0x28, 0xF1, 0x28, 0x32, 0xF6, 0xDC, 0x40, 0xD0, 0xB0,
  // "ā" (U+0101)
  0x10, 0x6B, 0x09, 0x28, 0x31, 0x33, 0x32, 0x28, 0x35, 0xCE, 0xD4, 0x28, 0x34, 0x64, 0xBD, 0x58,
  0x46, 0xF1, 0x06, 0xDB, 0x8B, 0x31, 0x3F, 0x93, 0x7F, 0x16, 0xF1, 0x07, 0xF1, 0x4F, 0x75, 0xDF,
  0x10, 0x9E, 0xC3, 0xF1,
  // "Ă" (U+0102)
  0x18, 0x34, 0x91, 0x58, 0x38, 0x31, 0xDF, 0xE4, 0x50, 0x27, 0x78, 0x11, 0xFE, 0x58, 0x26, 0xEF,
  0x44, 0x82, 0xBA, 0xC9, 0x49, 0x81, 0x68, 0xD3, 0x84, 0x5F, 0x24, 0xF3, 0x28, 0x49, 0xE1, 0x1F,
  0x82, 0x0E, 0xC8, 0x93, 0xC0, 0x3F, 0x84, 0x49, 0xF2, 0x8F, 0x12, 0x83, 0x2F, 0x6D, 0xC4, 0x0D,
  0x0B,
  // "ă" (U+0103)
  0x18, 0x34, 0x91, 0x58, 0x28, 0x31, 0xDF, 0xE4, 0x40, 0x24, 0x83, 0x5C, 0xED, 0x42, 0x83, 0x46,
  0x4B, 0xD5, 0x84, 0x6F, 0x10, 0x6D, 0xB8, 0xB3, 0x13, 0xF9, 0x37, 0xF1, 0x6F, 0x10, 0x7F, 0x14,
  0xF7, 0x5D, 0xF1, 0x09, 0xEC, 0x3F, 0x10,
  // "Ą" (U+0104)
  0x28, 0x11, 0xFE, 0x58, 0x26, 0xEF, 0x44, 0x82, 0xBA, 0xC9, 0x49, 0x81, 0x68, 0xD3, 0x84, 0x5F,
  0x24, 0xF3, 0x28, 0x49, 0xE1, 0x1F, 0x82, 0x0E, 0xC8, 0x93, 0xC0, 0x3F, 0x84, 0x49, 0xF2, 0x8F,
  0x12, 0x83, 0x2F, 0x6D, 0xC4, 0xA5, 0x81, 0x1D, 0x15, 0x81, 0x5D, 0x15, 0x02, 0xA6, 0x01, 0x02,
  // "ą" (U+0105)
  0x18, 0x35, 0xCE, 0xD4, 0x28, 0x34, 0x64, 0xBD, 0x58, 0x46, 0xF1, 0x06, 0xDB, 0x8B, 0x31, 0x3F,
  0x93, 0x7F, 0x16, 0xF1, 0x07, 0xF1, 0x4F, 0x75, 0xDF, 0x10, 0x9E, 0xC6, 0xF1, 0x38, 0x11, 0xD1,
  0x48, 0x15, 0xD1, 0x40, 0x2A, 0x50, 0x10, 0x21,
  // "Ć" (U+0106)
  0x48, 0x11, 0x74, 0x58, 0x19, 0xE1, 0x48, 0x13, 0xE2, 0x77, 0x68, 0x93, 0x3B, 0xEE, 0xB1, 0x03,
  0xFB, 0x45, 0x92, 0x0B, 0x0D, 0x58, 0x11, 0xF8, 0x58, 0x12, 0xF6, 0x58, 0x13, 0xF6, 0x58, 0x11,
  0xF8, 0x60, 0xC0, 0xE6, 0x84, 0x4F, 0xC5, 0x47, 0x38, 0x34, 0xCF, 0xEA, 0x10,
  // "ć" (U+0107)
  0x38, 0x11, 0x74, 0x38, 0x19, 0xE1, 0x28, 0x13, 0xE2, 0x71, 0x89, 0x41, 0xBF, 0xE5, 0x0B, 0xD5,
  0x52, 0x2F, 0x63, 0x81, 0x4F, 0x33, 0x81, 0x5F, 0x33, 0x81, 0x3F, 0x54, 0x89, 0x1D, 0xD5, 0x54,
  0x02, 0xBE, 0xD5,
  // "Ĉ" (U+0108)
  0x40, 0x70, 0x55, 0x82, 0x7D, 0xE2, 0x38, 0x32, 0xD2, 0x5C, 0x77, 0x58, 0x93, 0x3B, 0xEE, 0xB1,
  0x03, 0xFB, 0x45, 0x92, 0x0B, 0x0D, 0x58, 0x11, 0xF8, 0x58, 0x12, 0xF6, 0x58, 0x13, 0xF6, 0x58,
  0x11, 0xF8, 0x60, 0xC0, 0xE6, 0x84, 0x4F, 0xC5, 0x47, 0x38, 0x34, 0xCF, 0xEA, 0x10,
  // "ĉ" (U+0109)
  0x30, 0x70, 0x53, 0x89, 0x07, 0xDE, 0x20, 0x2D, 0x25, 0xC7, 0x89, 0x41, 0xBF, 0xE5, 0x0B, 0xD5,
  0x52, 0x2F, 0x63, 0x81, 0x4F, 0x33, 0x81, 0x5F, 0x33, 0x81, 0x3F, 0x54, 0x89, 0x1D, 0xD5, 0x54,
  0x02, 0xBE, 0xD5,
  // "Ċ" (U+010A)
  0x38, 0x14, 0xF2, 0x60, 0x27, 0x77, 0x89, 0x33, 0xBE, 0xEB, 0x10, 0x3F, 0xB4, 0x59, 0x20, 0xB0,
  0xD5, 0x81, 0x1F, 0x85, 0x81, 0x2F, 0x65, 0x81, 0x3F, 0x65, 0x81, 0x1F, 0x86, 0x0C, 0x0E, 0x68,
  0x44, 0xFC, 0x54, 0x73, 0x83, 0x4C, 0xFE, 0xA1,
  // "ċ" (U+010B)
  0x28, 0x14, 0xF2, 0x40, 0x27, 0x28, 0x94, 0x1B, 0xFE, 0x50, 0xBD, 0x55, 0x22, 0xF6, 0x38, 0x14,
  0xF3, 0x38, 0x15, 0xF3, 0x38, 0x13, 0xF5, 0x48, 0x91, 0xDD, 0x55, 0x40, 0x2B, 0xED, 0x50,
  // "Č" (U+010C)
  0x20, 0x20, 0x52, 0x07, 0x48, 0x2C, 0x7B, 0x84, 0x81, 0x2F, 0xD7, 0x76, 0x89, 0x33, 0xBE, 0xEB,
  0x10, 0x3F, 0xB4, 0x59, 0x20, 0xB0, 0xD5, 0x81, 0x1F, 0x85, 0x81, 0x2F, 0x65, 0x81, 0x3F, 0x65,
  0x81, 0x1F, 0x86, 0x0C, 0x0E, 0x68, 0x44, 0xFC, 0x54, 0x73, 0x83, 0x4C, 0xFE, 0xA1,
  // "č" (U+010D)
  0x10, 0x20, 0x52, 0x07, 0x28, 0x2C, 0x7B, 0x82, 0x81, 0x2F, 0xD7, 0x18, 0x94, 0x1B, 0xFE, 0x50,
  0xBD, 0x55, 0x22, 0xF6, 0x38, 0x14, 0xF3, 0x38, 0x15, 0xF3, 0x38, 0x13, 0xF5, 0x48, 0x91, 0xDD,
  0x55, 0x40, 0x2B, 0xED, 0x50,
  // "Ď" (U+010E)
  0x10, 0x20, 0x52, 0x07, 0x38, 0x2C, 0x7B, 0x83, 0x81, 0x2F, 0xD7, 0x72, 0x0C, 0xA8, 0x93, 0xEA,
  0x20, 0xCB, 0x35, 0xDE, 0x2C, 0xA2, 0x83, 0x1F, 0xAC, 0xA3, 0x82, 0xAE, 0xCA, 0x38, 0x28, 0xFC,
  0xA3, 0x82, 0x9F, 0xCA, 0x38, 0x2B, 0xEC, 0xA2, 0x89, 0x11, 0xF9, 0xCB, 0x36, 0xDE, 0x1C, 0xA8,
  0x1E, 0xA2, 0x10,
  // "ď" (U+010F)
  0x58, 0x3B, 0xB2, 0xF3, 0x58, 0x2B, 0xB5, 0xB6, 0x82, 0xBB, 0x11, 0x28, 0x43, 0xDE, 0x8B, 0xB4,
  0x84, 0xDD, 0x48, 0xFB, 0x38, 0x12, 0xF5, 0x20, 0xD0, 0xB3, 0x81, 0x4F, 0x32, 0x00, 0xB3, 0x81,
  0x4F, 0x32, 0x00, 0xB3, 0x81, 0x2F, 0x52, 0x0D, 0x0B, 0x48, 0x4D, 0xD4, 0x8F, 0xB4, 0x84, 0x3D,
  0xF9, 0x8B, 0x30,
  // "Đ" (U+0110)
  0x10, 0xCA, 0x81, 0xEA, 0x22, 0x89, 0x0C, 0xC3, 0x5D, 0xE2, 0x0C, 0xB2, 0x84, 0x1F, 0xA0, 0xCB,
  0x38, 0x1A, 0xEA, 0xB8, 0x95, 0x60, 0x8F, 0x2D, 0xC3, 0x10, 0x9F, 0x0C, 0xB3, 0x83, 0xBD, 0x0C,
  0xB2, 0x89, 0x31, 0xF9, 0x0C, 0xC3, 0x6D, 0xE1, 0x0C, 0xA8, 0x1E, 0xA2, 0x10,
  // "đ" (U+0111)
  0x50, 0x0B, 0x40, 0xBB, 0x0A, 0x38, 0x92, 0x23, 0xCC, 0x20, 0x3D, 0xE9, 0xBB, 0x28, 0x90, 0xDD,
  0x48, 0xFB, 0x02, 0xF5, 0x28, 0x4D, 0xB0, 0x4F, 0x32, 0x84, 0xBB, 0x04, 0xF3, 0x28, 0x4B, 0xB0,
  0x2F, 0x52, 0x0D, 0x0B, 0x28, 0x4D, 0xD4, 0x8F, 0xB2, 0x84, 0x3D, 0xF9, 0x8B, 0x10,
  // "Ē" (U+0112)
  0x06, 0xB8, 0x59, 0x01, 0x33, 0x32, 0x70, 0xCC, 0x87, 0x1C, 0xB3, 0x33, 0x0C, 0xA4, 0x0C, 0x0B,
  0x40, 0xCB, 0x89, 0x0D, 0x0C, 0xB3, 0x32, 0x0C, 0xA4, 0x0C, 0x0A, 0x48, 0x5C, 0xB3, 0x33, 0x0C,
  0xC0, 0x10,
  // "ē" (U+0113)
  0x10, 0x6B, 0x09, 0x28, 0x31, 0x33, 0x32, 0x28, 0x32, 0xBF, 0xD4, 0x28, 0x7B, 0xC4, 0x9E, 0x12,
  0xF4, 0x29, 0x05, 0x04, 0xD8, 0x91, 0x74, 0xF5, 0x33, 0x31, 0x2F, 0x55, 0x89, 0x2B, 0xD5, 0x48,
  0x10, 0x1A, 0xEE, 0xB1,
  // "Ĕ" (U+0114)
  0x89, 0x14, 0x91, 0x58, 0x01, 0xDF, 0xE4, 0x30, 0x27, 0x20, 0xCC, 0x87, 0x1C, 0xB3, 0x33, 0x0C,
  0xA4, 0x0C, 0x0B, 0x40, 0xCB, 0x89, 0x0D, 0x0C, 0xB3, 0x32, 0x0C, 0xA4, 0x0C, 0x0A, 0x48, 0x5C,
  0xB3, 0x33, 0x0C, 0xC0, 0x10,
  // "ĕ" (U+0115)
  0x18, 0x34, 0x91, 0x58, 0x28, 0x31, 0xDF, 0xE4, 0x40, 0x24, 0x83, 0x2B, 0xFD, 0x42, 0x87, 0xBC,
  0x49, 0xE1, 0x2F, 0x42, 0x90, 0x50, 0x4D, 0x89, 0x17, 0x4F, 0x53, 0x33, 0x12, 0xF5, 0x58, 0x92,
  0xBD, 0x54, 0x81, 0x01, 0xAE, 0xEB, 0x10,
  // "Ė" (U+0116)
  0x18, 0x14, 0xF2, 0x40, 0x27, 0x71, 0x0C, 0xC8, 0x71, 0xCB, 0x33, 0x30, 0xCA, 0x40, 0xC0, 0xB4,
  0x0C, 0xB8, 0x90, 0xD0, 0xCB, 0x33, 0x20, 0xCA, 0x40, 0xC0, 0xA4, 0x85, 0xCB, 0x33, 0x30, 0xCC,
  0x01,
  // "ė" (U+0117)
  0x28, 0x14, 0xF2, 0x50, 0x27, 0x48, 0x32, 0xBF, 0xD4, 0x28, 0x7B, 0xC4, 0x9E, 0x12, 0xF4, 0x29,
  0x05, 0x04, 0xD8, 0x91, 0x74, 0xF5, 0x33, 0x31, 0x2F, 0x55, 0x89, 0x2B, 0xD5, 0x48, 0x10, 0x1A,
  0xEE, 0xB1,
  // "Ę" (U+0118)
  0x0C, 0xC8, 0x71, 0xCB, 0x33, 0x30, 0xCA, 0x40, 0xC0, 0xB4, 0x0C, 0xB8, 0x90, 0xD0, 0xCB, 0x33,
  0x20, 0xCA, 0x40, 0xC0, 0xA4, 0x85, 0xCB, 0x33, 0x30, 0xCC, 0x01, 0x28, 0x11, 0xD1, 0x38, 0x15,
  0xD1, 0x30, 0x2A, 0x40, 0x10, 0x21,
  // "ę" (U+0119)
  0x18, 0x32, 0xBF, 0xD4, 0x28, 0x7B, 0xC4, 0x9E, 0x12, 0xF4, 0x29, 0x05, 0x04, 0xD8, 0x91, 0x74,
  0xF5, 0x33, 0x31, 0x2F, 0x55, 0x89, 0x3B, 0xD5, 0x48, 0x10, 0x1A, 0xEF, 0xD1, 0x40, 0xB0, 0x24,
  0x81, 0x4E, 0x44, 0x82, 0x1D, 0xE1,
  // "Ě" (U+011A)
  0x02, 0x05, 0x20, 0x72, 0x82, 0xC7, 0xB8, 0x28, 0x12, 0xFD, 0x77, 0x0C, 0xC8, 0x71, 0xCB, 0x33,
  0x30, 0xCA, 0x40, 0xC0, 0xB4, 0x0C, 0xB8, 0x90, 0xD0, 0xCB, 0x33, 0x20, 0xCA, 0x40, 0xC0, 0xA4,
  0x85, 0xCB, 0x33, 0x30, 0xCC, 0x01,
  // "ě" (U+011B)
  0x10, 0x20, 0x52, 0x07, 0x38, 0x2C, 0x7B, 0x83, 0x81, 0x2F, 0xD7, 0x38, 0x32, 0xBF, 0xD4, 0x28,
  0x7B, 0xC4, 0x9E, 0x12, 0xF4, 0x29, 0x05, 0x04, 0xD8, 0x91, 0x74, 0xF5, 0x33, 0x31, 0x2F, 0x55,
  0x89, 0x2B, 0xD5, 0x48, 0x10, 0x1A, 0xEE, 0xB1,
  // "Ĝ" (U+011C)
  0x40, 0x70, 0x56, 0x82, 0x7D, 0xE2, 0x48, 0x32, 0xD2, 0x5C, 0x77, 0x71, 0x84, 0x2A, 0xDF, 0xD8,
  0x28, 0x52, 0xED, 0x64, 0x67, 0x28, 0x1B, 0xE1, 0x69, 0x09, 0x68, 0x12, 0xF6, 0x2B, 0x82, 0x22,
  0xF6, 0x28, 0x53, 0x7F, 0x21, 0xF8, 0x38, 0x45, 0xF2, 0x0C, 0xD3, 0x89, 0x25, 0xF2, 0x03, 0xFC,
  0x53, 0x9F, 0x22, 0x85, 0x3B, 0xEE, 0xDA, 0x10,
  // "ĝ" (U+011D)
  0x30, 0x70, 0x54, 0x82, 0x7D, 0xE2, 0x28, 0x32, 0xD2, 0x5C, 0x72, 0x89, 0x63, 0xCE, 0x99, 0xB0,
  0xCD, 0x48, 0xFB, 0x2F, 0x52, 0x83, 0xDB, 0x4F, 0x32, 0x83, 0xBB, 0x4F, 0x32, 0x83, 0xBB, 0x2F,
  0x52, 0x89, 0x6D, 0xB0, 0xDD, 0x48, 0xFB, 0x03, 0xDE, 0x9B, 0xB5, 0x89, 0x5C, 0x90, 0x75, 0x48,
  0xF4, 0x09, 0xEF, 0xD6, 0x10,
  // "Ğ" (U+011E)
  0x28, 0x34, 0x91, 0x58, 0x48, 0x31, 0xDF, 0xE4, 0x60, 0x27, 0x71, 0x84, 0x2A, 0xDF, 0xD8, 0x28,
  0x52, 0xED, 0x64, 0x67, 0x28, 0x1B, 0xE1, 0x69, 0x09, 0x68, 0x12, 0xF6, 0x2B, 0x82, 0x22, 0xF6,
  0x28, 0x53, 0x7F, 0x21, 0xF8, 0x38, 0x45, 0xF2, 0x0C, 0xD3, 0x89, 0x25, 0xF2, 0x03, 0xFC, 0x53,
  0x9F, 0x22, 0x85, 0x3B, 0xEE, 0xDA, 0x10,
  // "ğ" (U+011F)
  0x18, 0x34, 0x91, 0x58, 0x28, 0x31, 0xDF, 0xE4, 0x40, 0x24, 0x89, 0x63, 0xCE, 0x99, 0xB0, 0xCD,
  0x48, 0xFB, 0x2F, 0x52, 0x83, 0xDB, 0x4F, 0x32, 0x83, 0xBB, 0x4F, 0x32, 0x83, 0xBB, 0x2F, 0x52,
  0x89, 0x6D, 0xB0, 0xDD, 0x48, 0xFB, 0x03, 0xDE, 0x9B, 0xB5, 0x89, 0x5C, 0x90, 0x75, 0x48, 0xF4,
  0x09, 0xEF, 0xD6, 0x10,
  // "Ġ" (U+0120)
  0x48, 0x14, 0xF2, 0x70, 0x27, 0x77, 0x28, 0x42, 0xAD, 0xFD, 0x82, 0x85, 0x2E, 0xD6, 0x46, 0x72,
  0x81, 0xBE, 0x16, 0x90, 0x96, 0x81, 0x2F, 0x62, 0xB8, 0x22, 0x2F, 0x62, 0x85, 0x37, 0xF2, 0x1F,
  0x83, 0x84, 0x5F, 0x20, 0xCD, 0x38, 0x92, 0x5F, 0x20, 0x3F, 0xC5, 0x39, 0xF2, 0x28, 0x53, 0xBE,
  0xED, 0xA1,
  // "ġ" (U+0121)
  0x38, 0x14, 0xF2, 0x50, 0x27, 0x38, 0x96, 0x3C, 0xE9, 0x9B, 0x0C, 0xD4, 0x8F, 0xB2, 0xF5, 0x28,
  0x3D, 0xB4, 0xF3, 0x28, 0x3B, 0xB4, 0xF3, 0x28, 0x3B, 0xB2, 0xF5, 0x28, 0x96, 0xDB, 0x0D, 0xD4,
  0x8F, 0xB0, 0x3D, 0xE9, 0xBB, 0x58, 0x95, 0xC9, 0x07, 0x54, 0x8F, 0x40, 0x9E, 0xFD, 0x61,
  // "Ģ" (U+0122)
  0x28, 0x42, 0xAD, 0xFD, 0x82, 0x85, 0x2E, 0xD6, 0x46, 0x72, 0x81, 0xBE, 0x16, 0x90, 0x96, 0x81,
  0x2F, 0x62, 0xB8, 0x22, 0x2F, 0x62, 0x85, 0x37, 0xF2, 0x1F, 0x83, 0x84, 0x5F, 0x20, 0xCD, 0x38,
  0x92, 0x5F, 0x20, 0x3F, 0xC5, 0x39, 0xF2, 0x28, 0x53, 0xBE, 0xED, 0xA1, 0x50, 0x27, 0x81, 0x3F,
  0x26, 0x07, 0x09, 0x30,
  // "ģ" (U+0123)
  0x30, 0xB0, 0x44, 0x05, 0x95, 0x01, 0x02, 0x48, 0x96, 0x3C, 0xE9, 0x9B, 0x0C, 0xD4, 0x8F, 0xB2,
  0xF5, 0x28, 0x3D, 0xB4, 0xF3, 0x28, 0x3B, 0xB4, 0xF3, 0x28, 0x3B, 0xB2, 0xF5, 0x28, 0x96, 0xDB,
  0x0D, 0xD4, 0x8F, 0xB0, 0x3D, 0xE9, 0xBB, 0x58, 0x95, 0xC9, 0x07, 0x54, 0x8F, 0x40, 0x9E, 0xFD,
  0x61,
  // "Ĥ" (U+0124)
  0x30, 0x70, 0x54, 0x82, 0x7D, 0xE2, 0x28, 0x32, 0xD2, 0x5C, 0x77, 0x10, 0xC0, 0xA3, 0x82, 0x9E,
  0xCA, 0x38, 0x29, 0xEC, 0xA3, 0x82, 0x9E, 0xCB, 0x38, 0x19, 0xEC, 0xD8, 0x90, 0xEC, 0xB3, 0x33,
  0xAE, 0xCA, 0x38, 0x29, 0xEC, 0xA3, 0x82, 0x9E, 0xCA, 0x38, 0x29, 0xEC, 0xA3, 0x09, 0x0E,
  // "ĥ" (U+0125)
  0x20, 0x70, 0x55, 0x82, 0x7D, 0xE2, 0x38, 0x32, 0xD2, 0x5C, 0x76, 0x90, 0x76, 0x90, 0x76, 0x90,
  0x76, 0x98, 0x38, 0xBE, 0xB1, 0x29, 0x83, 0xE6, 0x5F, 0x82, 0x90, 0xA2, 0x00, 0xB2, 0x90, 0x82,
  0x0A, 0x0B, 0x29, 0x07, 0x20, 0xA0, 0xB2, 0x90, 0x72, 0x0A, 0x0B, 0x29, 0x07, 0x20, 0xA0, 0xB2,
  0x90, 0x72, 0x0A, 0x0B,
  // "Ħ" (U+0126)
  0x10, 0xD0, 0xA3, 0x09, 0x0E, 0x2F, 0xA8, 0x90, 0x13, 0xDB, 0x33, 0x3A, 0xE3, 0x20, 0xD0, 0xB3,
  0x09, 0x0E, 0x30, 0xDD, 0x0E, 0x38, 0x5D, 0xB3, 0x33, 0xAE, 0x30, 0xD0, 0xA3, 0x09, 0x0E, 0x30,
  0xD0, 0xA3, 0x09, 0x0E, 0x30, 0xD0, 0xA3, 0x09, 0x0E, 0x30, 0xD0, 0xA3, 0x09, 0x0E, 0x20,
  // "ħ" (U+0127)
  0x19, 0x08, 0x40, 0xEB, 0x08, 0x28, 0x32, 0xF9, 0x31, 0x39, 0x89, 0x58, 0xBE, 0xB1, 0x0F, 0xE6,
  0x5F, 0x80, 0xFA, 0x28, 0x3B, 0xB0, 0xF8, 0x28, 0x3A, 0xB0, 0xF7, 0x28, 0x3A, 0xB0, 0xF7, 0x28,
  0x3A, 0xB0, 0xF7, 0x28, 0x3A, 0xB0, 0xF7, 0x20, 0xA0, 0xB0,
  // "Ĩ" (U+0128)
  0x18, 0x90, 0xCD, 0x48, 0x64, 0xB6, 0xEE, 0x0F, 0x12, 0x01, 0x71, 0x07, 0xB0, 0x22, 0x81, 0x7F,
  0x23, 0x81, 0x6F, 0x13, 0x81, 0x6F, 0x13, 0x81, 0x6F, 0x13, 0x81, 0x6F, 0x13, 0x81, 0x6F, 0x13,
  0x81, 0x6F, 0x13, 0x81, 0x6F, 0x22, 0x06, 0xB0, 0x20,
  // "ĩ" (U+0129)
  0x18, 0x90, 0xCD, 0x48, 0x64, 0xB6, 0xEE, 0x0F, 0x12, 0x01, 0x39, 0x07, 0x49, 0x07, 0x49, 0x07,
  0x49, 0x07, 0x49, 0x07, 0x49, 0x07, 0x49, 0x07, 0x49, 0x07, 0x20,
  // "Ī" (U+012A)
  0x06, 0xB8, 0x49, 0x13, 0x33, 0x25, 0x07, 0xB8, 0x32, 0x07, 0xF2, 0x28, 0x16, 0xF1, 0x28, 0x16,
  0xF1, 0x28, 0x16, 0xF1, 0x28, 0x16, 0xF1, 0x28, 0x16, 0xF1, 0x28, 0x16, 0xF1, 0x28, 0x36, 0xF2,
  0x06, 0xB0, 0x20,
  // "ī" (U+012B)
  0x06, 0xB8, 0x49, 0x13, 0x33, 0x22, 0x90, 0x73, 0x90, 0x73, 0x90, 0x73, 0x90, 0x73, 0x90, 0x73,
  0x90, 0x73, 0x90, 0x73, 0x90, 0x71,
  // "Ĭ" (U+012C)
  0x89, 0x04, 0x91, 0x58, 0x1D, 0xFE, 0x42, 0x02, 0x70, 0x7B, 0x83, 0x20, 0x7F, 0x22, 0x81, 0x6F,
  0x12, 0x81, 0x6F, 0x12, 0x81, 0x6F, 0x12, 0x81, 0x6F, 0x12, 0x81, 0x6F, 0x12, 0x81, 0x6F, 0x12,
  0x83, 0x6F, 0x20, 0x6B, 0x02,
  // "ĭ" (U+012D)
  0x89, 0x04, 0x91, 0x58, 0x1D, 0xFE, 0x42, 0x02, 0x49, 0x07, 0x39, 0x07, 0x39, 0x07, 0x39, 0x07,
  0x39, 0x07, 0x39, 0x07, 0x39, 0x07, 0x39, 0x07, 0x10,
  // "Į" (U+012E)
  0x07, 0xB8, 0x32, 0x07, 0xF2, 0x28, 0x16, 0xF1, 0x28, 0x16, 0xF1, 0x28, 0x16, 0xF1, 0x28, 0x16,
  0xF1, 0x28, 0x16, 0xF1, 0x28, 0x16, 0xF1, 0x28, 0x36, 0xF2, 0x06, 0xB8, 0x32, 0x01, 0xD1, 0x28,
  0x15, 0xD1, 0x20, 0x2A, 0x30, 0x10, 0x21,
  // "į" (U+012F)
  0x18, 0x2D, 0x70, 0x25, 0x98, 0xB3, 0x70, 0xF7, 0x0F, 0x70, 0xF7, 0x0F, 0x70, 0xF7, 0x0F, 0x70,
  0xFB, 0x1D, 0x15, 0xD1, 0x2A, 0x10, 0x10, 0x20,
  // "İ" (U+0130)
  0x18, 0x14, 0xF2, 0x30, 0x27, 0x50, 0x7B, 0x83, 0x20, 0x7F, 0x22, 0x81, 0x6F, 0x12, 0x81, 0x6F,
  0x12, 0x81, 0x6F, 0x12, 0x81, 0x6F, 0x12, 0x81, 0x6F, 0x12, 0x81, 0x6F, 0x12, 0x83, 0x6F, 0x20,
  0x6B, 0x02,
  // "ı" (U+0131)
  0x98, 0x95, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x7F, 0x70,
  // "Ĳ" (U+0132)
  0x07, 0xB8, 0x62, 0x0D, 0xA0, 0x7F, 0x22, 0x84, 0xDA, 0x06, 0xF1, 0x28, 0x4D, 0xA0, 0x6F, 0x12,
  0x84, 0xDA, 0x06, 0xF1, 0x28, 0x4D, 0xA0, 0x6F, 0x12, 0x84, 0xDA, 0x06, 0xF1, 0x28, 0x4D, 0xA0,
  0x6F, 0x12, 0x84, 0xDA, 0x06, 0xF2, 0x28, 0x1D, 0xA6, 0xB8, 0x22, 0x0D, 0xA6, 0x0E, 0x09, 0x48,
  0x21, 0x3F, 0x74, 0x82, 0xDF, 0xC1, 0x40, 0x10, 0x22,
  // "ĳ" (U+0133)
  0x0D, 0x07, 0x28, 0x1D, 0x72, 0x30, 0x27, 0x90, 0x72, 0x98, 0x17, 0xF7, 0x29, 0x81, 0x7F, 0x72,
  0x98, 0x17, 0xF7, 0x29, 0x81, 0x7F, 0x72, 0x98, 0x17, 0xF7, 0x29, 0x81, 0x7F, 0x72, 0x98, 0x17,
  0xF7, 0x29, 0x07, 0x49, 0x07, 0x28, 0x22, 0x5F, 0x52, 0x81, 0x6F, 0xB1,
  // "Ĵ" (U+0134)
  0x20, 0x70, 0x52, 0x87, 0x7D, 0xE2, 0x2D, 0x25, 0xC7, 0x50, 0xD0, 0xA3, 0x0D, 0x0A, 0x30, 0xD0,
  0xA3, 0x0D, 0x0A, 0x30, 0xD0, 0xA3, 0x0D, 0x0A, 0x30, 0xD0, 0xA3, 0x0D, 0x0A, 0x30, 0xD0, 0xA3,
  0x0D, 0x0A, 0x38, 0x95, 0xE9, 0x01, 0x3F, 0x70, 0xDF, 0xC1, 0x01, 0x23,
  // "ĵ" (U+0135)
  0x20, 0x70, 0x52, 0x87, 0x7D, 0xE2, 0x2D, 0x25, 0xC7, 0x90, 0x73, 0x90, 0x73, 0x90, 0x73, 0x90,
  0x73, 0x90, 0x73, 0x90, 0x73, 0x90, 0x73, 0x90, 0x73, 0x98, 0x90, 0x70, 0x26, 0xF5, 0x06, 0xFB,
  0x20,
  // "Ķ" (U+0136)
  0x0C, 0x0A, 0x28, 0xA4, 0x5F, 0x5C, 0xA0, 0x1E, 0xA0, 0xCA, 0x0A, 0xD1, 0x0C, 0xA5, 0xF4, 0x28,
  0x2C, 0xCE, 0xB3, 0x83, 0xCF, 0xCF, 0x32, 0x83, 0xCB, 0x0D, 0xC2, 0x87, 0xCA, 0x05, 0xF5, 0x0C,
  0xA2, 0x83, 0xCD, 0x0C, 0xA2, 0x81, 0x3F, 0x73, 0x02, 0x58, 0x13, 0xF2, 0x40, 0x70, 0x93,
  // "ķ" (U+0137)
  0x90, 0x74, 0x90, 0x74, 0x90, 0x74, 0x98, 0x95, 0x70, 0x4F, 0x5F, 0x71, 0xD9, 0x0F, 0x7A, 0xD2,
  0x98, 0x1B, 0xF8, 0x29, 0x8A, 0x5E, 0xAE, 0x10, 0xF7, 0x1E, 0x80, 0xF7, 0x08, 0xF1, 0xF7, 0x01,
  0xE9, 0x20, 0x24, 0x81, 0x3F, 0x23, 0x07, 0x09, 0x30,
  // "ĸ" (U+0138)
  0x98, 0xA3, 0x80, 0x3F, 0x5F, 0x80, 0xDA, 0x0F, 0x79, 0xD1, 0x0F, 0xBF, 0x82, 0x98, 0xA5, 0xEB,
  0xE1, 0x0F, 0x81, 0xE8, 0x0F, 0x80, 0x8F, 0x1F, 0x80, 0x1E, 0x90,
  // "Ĺ" (U+0139)
  0x18, 0x11, 0x74, 0x48, 0x19, 0xE1, 0x38, 0x13, 0xE2, 0x77, 0x50, 0xC0, 0xA5, 0x0C, 0x0A, 0x50,
  0xC0, 0xA5, 0x0C, 0x0A, 0x50, 0xC0, 0xA5, 0x0C, 0x0A, 0x50, 0xC0, 0xA5, 0x0C, 0x0A, 0x50, 0x0C,
  0x0F, 0x42, 0x0C, 0xC0, 0x10,
  // "ĺ" (U+013A)
  0x18, 0x90, 0x17, 0x40, 0x9E, 0x13, 0xE2, 0x69, 0x07, 0x29, 0x07, 0x29, 0x07, 0x29, 0x07, 0x29,
  0x07, 0x29, 0x07, 0x29, 0x07, 0x29, 0x07, 0x29, 0x07, 0x29, 0x07, 0x29, 0x07, 0x10,
  // "Ļ" (U+013B)
  0x0C, 0x0A, 0x40, 0xC0, 0xA4, 0x0C, 0x0A, 0x40, 0xC0, 0xA4, 0x0C, 0x0A, 0x40, 0xC0, 0xA4, 0x0C,
  0x0A, 0x40, 0xC0, 0xA4, 0x85, 0xCC, 0x44, 0x40, 0xCC, 0x01, 0x20, 0x24, 0x81, 0x3F, 0x23, 0x07,
  0x09, 0x30,
  // "ļ" (U+013C)
  0x19, 0x8C, 0x57, 0x0F, 0x70, 0xF7, 0x0F, 0x70, 0xF7, 0x0F, 0x70, 0xF7, 0x0F, 0x70, 0xF7, 0x0F,
  0x70, 0xF7, 0x02, 0x03, 0xF2, 0x79, 0x10,
  // "Ľ" (U+013D)
  0x8A, 0x2C, 0xA0, 0x2F, 0x3C, 0xA0, 0x5B, 0x0C, 0xA0, 0x11, 0x0C, 0xA4, 0x0C, 0x0A, 0x40, 0xC0,
  0xA4, 0x0C, 0x0A, 0x40, 0xC0, 0xA4, 0x85, 0xCC, 0x44, 0x40, 0xCC, 0x01,
  // "ľ" (U+013E)
  0x98, 0x96, 0x72, 0xF3, 0xF7, 0x5B, 0x0F, 0x71, 0x10, 0xF7, 0x39, 0x07, 0x39, 0x07, 0x39, 0x07,
  0x39, 0x07, 0x39, 0x07, 0x39, 0x07, 0x39, 0x07, 0x30,
  // "Ŀ" (U+013F)
  0x0C, 0x0A, 0x40, 0xC0, 0xA4, 0x0C, 0x0A, 0x48, 0x6C, 0xA0, 0x4F, 0x2C, 0xA2, 0x82, 0x20, 0xCA,
  0x40, 0xC0, 0xA4, 0x0C, 0x0A, 0x48, 0x5C, 0xC4, 0x44, 0x0C, 0xC0, 0x10,
  // "ŀ" (U+0140)
  0x90, 0x73, 0x90, 0x73, 0x90, 0x73, 0x90, 0x73, 0x98, 0x91, 0x74, 0xF2, 0xF7, 0x02, 0x0F, 0x73,
  0x90, 0x73, 0x90, 0x73, 0x90, 0x73, 0x90, 0x73,
  // "Ł" (U+0141)
  0x10, 0xB0, 0xC5, 0x0B, 0x0C, 0x50, 0xB0, 0xC5, 0x82, 0xBC, 0x25, 0x38, 0x2B, 0xEF, 0x92, 0x82,
  0x4E, 0xE3, 0x38, 0x1A, 0xEC, 0x50, 0xB0, 0xC5, 0x86, 0xBD, 0x44, 0x41, 0x0B, 0xC0, 0x30,
  // "ł" (U+0142)
  0x20, 0xD0, 0x93, 0x0D, 0x09, 0x30, 0xD0, 0x93, 0x0D, 0x09, 0x38, 0x92, 0xDC, 0xA0, 0x1E, 0xE5,
  0x1E, 0xF9, 0x28, 0x13, 0xD9, 0x30, 0xD0, 0x93, 0x0D, 0x09, 0x30, 0xD0, 0x91,
  // "Ń" (U+0143)
  0x38, 0x11, 0x74, 0x58, 0x19, 0xE1, 0x48, 0x13, 0xE2, 0x77, 0x58, 0x1C, 0xF4, 0x39, 0x82, 0x7C,
  0xFC, 0x39, 0x83, 0x7C, 0xCF, 0x42, 0x98, 0x37, 0xC8, 0xCC, 0x29, 0x8B, 0x17, 0xC9, 0x3F, 0x50,
  0xF7, 0xC9, 0x0B, 0xD0, 0xF7, 0xC9, 0x03, 0xF5, 0xE7, 0xC9, 0x28, 0x4A, 0xDE, 0x7C, 0x92, 0x02,
  0xA8, 0x17, 0xC9, 0x38, 0x19, 0xF7,
  // "ń" (U+0144)
  0x28, 0x11, 0x74, 0x38, 0x19, 0xE1, 0x28, 0x13, 0xE2, 0x71, 0x98, 0x93, 0x5B, 0xEB, 0x1F, 0xE6,
  0x5F, 0x8F, 0xA2, 0x82, 0xBB, 0xF8, 0x28, 0x2A, 0xBF, 0x72, 0x82, 0xAB, 0xF7, 0x28, 0x2A, 0xBF,
  0x72, 0x82, 0xAB, 0xF7, 0x20, 0xA0, 0xB0,
  // "Ņ" (U+0145)
  0x81, 0xCF, 0x43, 0x98, 0x27, 0xCF, 0xC3, 0x98, 0x37, 0xCC, 0xF4, 0x29, 0x83, 0x7C, 0x8C, 0xC2,
  0x98, 0xB1, 0x7C, 0x93, 0xF5, 0x0F, 0x7C, 0x90, 0xBD, 0x0F, 0x7C, 0x90, 0x3F, 0x5E, 0x7C, 0x92,
  0x84, 0xAD, 0xE7, 0xC9, 0x20, 0x2A, 0x81, 0x7C, 0x93, 0x81, 0x9F, 0x73, 0x02, 0x68, 0x13, 0xF2,
  0x50, 0x70, 0x94,
  // "ņ" (U+0146)
  0x98, 0x93, 0x5B, 0xEB, 0x1F, 0xE6, 0x5F, 0x8F, 0xA2, 0x82, 0xBB, 0xF8, 0x28, 0x2A, 0xBF, 0x72,
  0x82, 0xAB, 0xF7, 0x28, 0x2A, 0xBF, 0x72, 0x82, 0xAB, 0xF7, 0x20, 0xA0, 0xB2, 0x02, 0x48, 0x13,
  0xF2, 0x30, 0x70, 0x93,
  // "Ň" (U+0147)
  0x10, 0x20, 0x52, 0x07, 0x48, 0x2C, 0x7B, 0x84, 0x81, 0x2F, 0xD7, 0x75, 0x81, 0xCF, 0x43, 0x98,
  0x27, 0xCF, 0xC3, 0x98, 0x37, 0xCC, 0xF4, 0x29, 0x83, 0x7C, 0x8C, 0xC2, 0x98, 0xB1, 0x7C, 0x93,
  0xF5, 0x0F, 0x7C, 0x90, 0xBD, 0x0F, 0x7C, 0x90, 0x3F, 0x5E, 0x7C, 0x92, 0x84, 0xAD, 0xE7, 0xC9,
  0x20, 0x2A, 0x81, 0x7C, 0x93, 0x81, 0x9F, 0x70,
  // "ň" (U+0148)
  0x02, 0x05, 0x20, 0x72, 0x82, 0xC7, 0xB8, 0x28, 0x12, 0xFD, 0x71, 0x98, 0x93, 0x5B, 0xEB, 0x1F,
  0xE6, 0x5F, 0x8F, 0xA2, 0x82, 0xBB, 0xF8, 0x28, 0x2A, 0xBF, 0x72, 0x82, 0xAB, 0xF7, 0x28, 0x2A,
  0xBF, 0x72, 0x82, 0xAB, 0xF7, 0x20, 0xA0, 0xB0,
  // "ŉ" (U+0149)
  0x81, 0x1F, 0x75, 0x81, 0x4F, 0x25, 0x86, 0x8A, 0xF5, 0xBE, 0xB1, 0x29, 0x83, 0xE6, 0x5F, 0x82,
  0x90, 0xA2, 0x00, 0xB2, 0x90, 0x82, 0x0A, 0x0B, 0x29, 0x07, 0x20, 0xA0, 0xB2, 0x90, 0x72, 0x0A,
  0x0B, 0x29, 0x07, 0x20, 0xA0, 0xB2, 0x90, 0x72, 0x0A, 0x0B,
  // "Ŋ" (U+014A)
  0x81, 0xCF, 0x43, 0x98, 0x27, 0xCF, 0xC3, 0x98, 0x37, 0xCB, 0xF6, 0x29, 0x83, 0x7C, 0x8A, 0xE2,
  0x98, 0xA1, 0x7C, 0x91, 0xF8, 0x0F, 0x7C, 0x90, 0x8E, 0x1E, 0x7C, 0x92, 0x84, 0xE9, 0xE7, 0xC9,
  0x20, 0x6A, 0x81, 0x7C, 0x93, 0x83, 0xCF, 0x7C, 0x93, 0x81, 0x3F, 0x76, 0x90, 0x64, 0x82, 0x15,
  0xF4, 0x4A, 0x0A, 0x50, 0x20, 0x12,
  // "ŋ" (U+014B)
  0x98, 0x93, 0x6B, 0xEB, 0x1F, 0xE6, 0x5F, 0x8F, 0xA2, 0x82, 0xBB, 0xF8, 0x28, 0x2A, 0xBF, 0x72,
  0x82, 0xAB, 0xF7, 0x28, 0x2A, 0xBF, 0x72, 0x82, 0xAB, 0xF7, 0x20, 0xA0, 0xB4, 0x00, 0xB3, 0x81,
  0x4D, 0x92, 0x82, 0x1F, 0xD2,
  // "Ō" (U+014C)
  0x20, 0x6B, 0x09, 0x48, 0x31, 0x33, 0x32, 0x76, 0x83, 0x5C, 0xFD, 0x93, 0x85, 0x5F, 0xA4, 0x6E,
  0xB2, 0x00, 0xD3, 0x84, 0x6F, 0x31, 0xF8, 0x38, 0x41, 0xF8, 0x3F, 0x64, 0x98, 0x29, 0x2F, 0x64,
  0x98, 0x29, 0x1F, 0x83, 0x84, 0x1F, 0x80, 0xCD, 0x38, 0x91, 0x6F, 0x30, 0x4F, 0xA4, 0x6E, 0xB3,
  0x83, 0x4C, 0xED, 0x92,
  // "ō" (U+014D)
  0x10, 0x6B, 0x09, 0x28, 0x31, 0x33, 0x32, 0x28, 0x32, 0xBF, 0xD6, 0x28, 0x7B, 0xD4, 0x7F, 0x42,
  0xF5, 0x28, 0x3C, 0xA4, 0xF3, 0x28, 0x3A, 0xD4, 0xF3, 0x28, 0x3A, 0xD2, 0xF5, 0x28, 0x95, 0xCB,
  0x0B, 0xD4, 0x7F, 0x40, 0x1A, 0xED, 0x61,
  // "Ŏ" (U+014E)
  0x28, 0x34, 0x91, 0x58, 0x48, 0x31, 0xDF, 0xE4, 0x60, 0x27, 0x71, 0x83, 0x5C, 0xFD, 0x93, 0x85,
  0x5F, 0xA4, 0x6E, 0xB2, 0x00, 0xD3, 0x84, 0x6F, 0x31, 0xF8, 0x38, 0x41, 0xF8, 0x3F, 0x64, 0x98,
  0x29, 0x2F, 0x64, 0x98, 0x29, 0x1F, 0x83, 0x84, 0x1F, 0x80, 0xCD, 0x38, 0x91, 0x6F, 0x30, 0x4F,
  0xA4, 0x6E, 0xB3, 0x83, 0x4C, 0xED, 0x92,
  // "ŏ" (U+014F)
  0x18, 0x34, 0x91, 0x58, 0x28, 0x31, 0xDF, 0xE4, 0x40, 0x24, 0x83, 0x2B, 0xFD, 0x62, 0x87, 0xBD,
  0x47, 0xF4, 0x2F, 0x52, 0x83, 0xCA, 0x4F, 0x32, 0x83, 0xAD, 0x4F, 0x32, 0x83, 0xAD, 0x2F, 0x52,
  0x89, 0x5C, 0xB0, 0xBD, 0x47, 0xF4, 0x01, 0xAE, 0xD6, 0x10,
  // "Ő" (U+0150)
  0x48, 0x22, 0x02, 0x14, 0x83, 0x8D, 0x3F, 0x43, 0x83, 0x2C, 0x1B, 0x57, 0x77, 0x18, 0x35, 0xCF,
  0xD9, 0x38, 0x55, 0xFA, 0x46, 0xEB, 0x20, 0x0D, 0x38, 0x46, 0xF3, 0x1F, 0x83, 0x84, 0x1F, 0x83,
  0xF6, 0x49, 0x82, 0x92, 0xF6, 0x49, 0x82, 0x91, 0xF8, 0x38, 0x41, 0xF8, 0x0C, 0xD3, 0x89, 0x16,
  0xF3, 0x04, 0xFA, 0x46, 0xEB, 0x38, 0x34, 0xCE, 0xD9, 0x20,
  // "ő" (U+0151)
  0x38, 0x22, 0x02, 0x12, 0x89, 0x18, 0xD3, 0xF4, 0x02, 0xC1, 0xB5, 0x72, 0x83, 0x2B, 0xFD, 0x62,
  0x87, 0xBD, 0x47, 0xF4, 0x2F, 0x52, 0x83, 0xCA, 0x4F, 0x32, 0x83, 0xAD, 0x4F, 0x32, 0x83, 0xAD,
  0x2F, 0x52, 0x89, 0x5C, 0xB0, 0xBD, 0x47, 0xF4, 0x01, 0xAE, 0xD6, 0x10,
  // "Œ" (U+0152)
  0x20, 0x50, 0xCE, 0x89, 0x57, 0x04, 0xFA, 0x48, 0xF5, 0x33, 0x10, 0xCD, 0x28, 0x15, 0xF2, 0x49,
  0x08, 0x28, 0x15, 0xF2, 0x38, 0x12, 0xF6, 0x20, 0x5C, 0x82, 0x42, 0xF6, 0x28, 0x75, 0xF5, 0x33,
  0x01, 0xF8, 0x28, 0x15, 0xF2, 0x40, 0xC0, 0xD2, 0x81, 0x5F, 0x24, 0x89, 0x04, 0xFA, 0x47, 0xF5,
  0x33, 0x12, 0x81, 0x4C, 0xED, 0x07,
  // "œ" (U+0153)
  0x18, 0x90, 0x2B, 0xFD, 0x43, 0xDE, 0xB1, 0x28, 0x94, 0xBD, 0x48, 0xEE, 0x84, 0xDA, 0x02, 0xF5,
  0x20, 0xD0, 0xE2, 0x84, 0x6F, 0x04, 0xF3, 0x20, 0xAD, 0x82, 0x14, 0xF3, 0x28, 0x90, 0xAD, 0x33,
  0x33, 0x02, 0xF5, 0x20, 0xD9, 0x68, 0x90, 0xBD, 0x47, 0xFD, 0xA4, 0x57, 0x28, 0x90, 0x1B, 0xFD,
  0x52, 0xCF, 0xD7, 0x10,
  // "Ŕ" (U+0154)
  0x28, 0x11, 0x74, 0x48, 0x19, 0xE1, 0x38, 0x13, 0xE2, 0x77, 0x30, 0xCA, 0x89, 0x3D, 0x91, 0x0C,
  0xB3, 0x6F, 0xA0, 0xCA, 0x28, 0x39, 0xE0, 0xCA, 0x28, 0x91, 0x9F, 0x0C, 0xB0, 0x3E, 0xA0, 0xCB,
  0x86, 0xB1, 0x0C, 0xB3, 0xDA, 0x28, 0x7C, 0xA0, 0x5F, 0x30, 0xCA, 0x28, 0x3C, 0xC0, 0xCA, 0x28,
  0x14, 0xF6,
  // "ŕ" (U+0155)
  0x28, 0x11, 0x74, 0x28, 0x59, 0xE1, 0x03, 0xE2, 0x69, 0x89, 0x15, 0xBE, 0x0F, 0xE8, 0x30, 0xFB,
  0x39, 0x08, 0x39, 0x07, 0x39, 0x07, 0x39, 0x07, 0x39, 0x07, 0x30,
  // "Ŗ" (U+0156)
  0x0C, 0xA8, 0x93, 0xD9, 0x10, 0xCB, 0x36, 0xFA, 0x0C, 0xA2, 0x83, 0x9E, 0x0C, 0xA2, 0x89, 0x19,
  0xF0, 0xCB, 0x03, 0xEA, 0x0C, 0xB8, 0x6B, 0x10, 0xCB, 0x3D, 0xA2, 0x87, 0xCA, 0x05, 0xF3, 0x0C,
  0xA2, 0x83, 0xCC, 0x0C, 0xA2, 0x81, 0x4F, 0x63, 0x02, 0x58, 0x13, 0xF2, 0x40, 0x70, 0x93,
  // "ŗ" (U+0157)
  0x19, 0x89, 0x15, 0xBE, 0x0F, 0xE8, 0x30, 0xFB, 0x39, 0x08, 0x39, 0x07, 0x39, 0x07, 0x39, 0x07,
  0x39, 0x07, 0x30, 0x23, 0x81, 0x3F, 0x22, 0x07, 0x09, 0x30,
  // "Ř" (U+0158)
  0x02, 0x05, 0x20, 0x73, 0x82, 0xC7, 0xB8, 0x38, 0x12, 0xFD, 0x77, 0x30, 0xCA, 0x89, 0x3D, 0x91,
  0x0C, 0xB3, 0x6F, 0xA0, 0xCA, 0x28, 0x39, 0xE0, 0xCA, 0x28, 0x91, 0x9F, 0x0C, 0xB0, 0x3E, 0xA0,
  0xCB, 0x86, 0xB1, 0x0C, 0xB3, 0xDA, 0x28, 0x7C, 0xA0, 0x5F, 0x30, 0xCA, 0x28, 0x3C, 0xC0, 0xCA,
  0x28, 0x14, 0xF6,
  // "ř" (U+0159)
  0x02, 0x05, 0x28, 0x90, 0x70, 0xC7, 0xB8, 0x02, 0xFD, 0x79, 0x89, 0x15, 0xBE, 0x0F, 0xE8, 0x30,
  0xFB, 0x39, 0x08, 0x39, 0x07, 0x39, 0x07, 0x39, 0x07, 0x39, 0x07, 0x20,
  // "Ś" (U+015A)
  0x38, 0x11, 0x74, 0x48, 0x19, 0xE1, 0x38, 0x13, 0xE2, 0x77, 0x38, 0x96, 0x3C, 0xFE, 0xA0, 0x1E,
  0xB4, 0x59, 0x04, 0xF4, 0x48, 0x12, 0xF9, 0x58, 0x27, 0xFD, 0x54, 0x82, 0x3B, 0xFA, 0x58, 0x18,
  0xF3, 0x48, 0x96, 0x4F, 0x44, 0x74, 0x4C, 0xE0, 0x3C, 0xEE, 0xB2, 0x10,
  // "ś" (U+015B)
  0x38, 0x11, 0x74, 0x38, 0x19, 0xE1, 0x28, 0x13, 0xE2, 0x71, 0x89, 0x48, 0xEE, 0xB1, 0x4F, 0x74,
  0x80, 0x5F, 0x24, 0x81, 0xCE, 0x84, 0x81, 0x6E, 0xC4, 0x89, 0x43, 0xF4, 0x46, 0x48, 0xF2, 0x4D,
  0xFD, 0x61,
  // "Ŝ" (U+015C)
  0x30, 0x70, 0x54, 0x82, 0x7D, 0xE2, 0x28, 0x32, 0xD2, 0x5C, 0x77, 0x28, 0x96, 0x3C, 0xFE, 0xA0,
  0x1E, 0xB4, 0x59, 0x04, 0xF4, 0x48, 0x12, 0xF9, 0x58, 0x27, 0xFD, 0x54, 0x82, 0x3B, 0xFA, 0x58,
  0x18, 0xF3, 0x48, 0x96, 0x4F, 0x44, 0x74, 0x4C, 0xE0, 0x3C, 0xEE, 0xB2, 0x10,
  // "ŝ" (U+015D)
  0x20, 0x70, 0x53, 0x89, 0x07, 0xDE, 0x20, 0x2D, 0x25, 0xC7, 0x18, 0x94, 0x8E, 0xEB, 0x14, 0xF7,
  0x48, 0x05, 0xF2, 0x48, 0x1C, 0xE8, 0x48, 0x16, 0xEC, 0x48, 0x94, 0x3F, 0x44, 0x64, 0x8F, 0x24,
  0xDF, 0xD6, 0x10,
  // "Ş" (U+015E)
  0x18, 0x96, 0x3C, 0xFE, 0xA0, 0x1E, 0xB4, 0x59, 0x04, 0xF4, 0x48, 0x12, 0xF9, 0x58, 0x27, 0xFD,
  0x54, 0x82, 0x3B, 0xFA, 0x58, 0x18, 0xF3, 0x48, 0x96, 0x4F, 0x44, 0x74, 0x4C, 0xE0, 0x3C, 0xEE,
  0xB2, 0x30, 0x10, 0x65, 0x81, 0x3B, 0x64, 0x81, 0x4A, 0xC4, 0x81, 0xDD, 0x52,
  // "ş" (U+015F)
  0x18, 0x94, 0x8E, 0xEB, 0x14, 0xF7, 0x48, 0x05, 0xF2, 0x48, 0x1C, 0xE8, 0x48, 0x16, 0xEC, 0x48,
  0x94, 0x3F, 0x44, 0x64, 0x8F, 0x24, 0xDF, 0xD6, 0x20, 0x10, 0x64, 0x81, 0x3B, 0x63, 0x81, 0x4A,
  0xC3, 0x81, 0xDD, 0x52,
  // "Š" (U+0160)
  0x10, 0x20, 0x52, 0x07, 0x38, 0x2C, 0x7B, 0x83, 0x81, 0x2F, 0xD7, 0x73, 0x89, 0x63, 0xCF, 0xEA,
  0x01, 0xEB, 0x45, 0x90, 0x4F, 0x44, 0x81, 0x2F, 0x95, 0x82, 0x7F, 0xD5, 0x48, 0x23, 0xBF, 0xA5,
  0x81, 0x8F, 0x34, 0x89, 0x64, 0xF4, 0x47, 0x44, 0xCE, 0x03, 0xCE, 0xEB, 0x21,
  // "š" (U+0161)
  0x02, 0x05, 0x20, 0x72, 0x82, 0xC7, 0xB8, 0x28, 0x12, 0xFD, 0x72, 0x89, 0x48, 0xEE, 0xB1, 0x4F,
  0x74, 0x80, 0x5F, 0x24, 0x81, 0xCE, 0x84, 0x81, 0x6E, 0xC4, 0x89, 0x43, 0xF4, 0x46, 0x48, 0xF2,
  0x4D, 0xFD, 0x61,
  // "Ţ" (U+0162)
  0x0C, 0xD8, 0x67, 0x23, 0x8F, 0x43, 0x12, 0x81, 0x6F, 0x14, 0x81, 0x6F, 0x14, 0x81, 0x6F, 0x14,
  0x81, 0x6F, 0x14, 0x81, 0x6F, 0x14, 0x81, 0x6F, 0x14, 0x81, 0x6F, 0x14, 0x81, 0x6F, 0x14, 0x01,
  0x06, 0x58, 0x13, 0xB6, 0x48, 0x14, 0xAC, 0x48, 0x1D, 0xD5, 0x20,
  // "ţ" (U+0163)
  0x10, 0x30, 0x43, 0x0A, 0x09, 0x20, 0x8B, 0x83, 0x42, 0xEA, 0x32, 0x0D, 0x09, 0x30, 0xD0, 0x93,
  0x0D, 0x09, 0x30, 0xD0, 0x93, 0x89, 0x2C, 0xD4, 0x10, 0x4E, 0xE4, 0x01, 0x63, 0x81, 0x3B, 0x62,
  0x81, 0x4A, 0xC2, 0x81, 0xDD, 0x51,
  // "Ť" (U+0164)
  0x02, 0x05, 0x20, 0x73, 0x82, 0xC7, 0xB8, 0x38, 0x12, 0xFD, 0x77, 0x30, 0xCD, 0x86, 0x72, 0x38,
  0xF4, 0x31, 0x28, 0x16, 0xF1, 0x48, 0x16, 0xF1, 0x48, 0x16, 0xF1, 0x48, 0x16, 0xF1, 0x48, 0x16,
  0xF1, 0x48, 0x16, 0xF1, 0x48, 0x16, 0xF1, 0x48, 0x16, 0xF1, 0x20,
  // "ť" (U+0165)
  0x48, 0x72, 0xF3, 0x03, 0x40, 0x5B, 0x28, 0x5A, 0x90, 0x11, 0x08, 0xB0, 0x42, 0x82, 0x2E, 0xA3,
  0x40, 0xD0, 0x95, 0x0D, 0x09, 0x50, 0xD0, 0x95, 0x0D, 0x09, 0x58, 0x2C, 0xD4, 0x13, 0x82, 0x4E,
  0xE4, 0x20,
  // "Ŧ" (U+0166)
  0x0C, 0xD8, 0x67, 0x23, 0x8F, 0x43, 0x12, 0x81, 0x6F, 0x14, 0x81, 0x7F, 0x12, 0x01, 0xC0, 0xB2,
  0x83, 0x38, 0xF4, 0x23, 0x81, 0x6F, 0x14, 0x81, 0x6F, 0x14, 0x81, 0x6F, 0x14, 0x81, 0x6F, 0x12,
  // "ŧ" (U+0167)
  0x10, 0x30, 0x43, 0x0A, 0x09, 0x20, 0x8B, 0x83, 0x42, 0xEA, 0x32, 0x0D, 0x09, 0x20, 0xAB, 0x83,
  0x22, 0xEA, 0x32, 0x0D, 0x09, 0x38, 0x7C, 0xC4, 0x10, 0x5E, 0xE4,
  // "Ũ" (U+0168)
  0x18, 0x95, 0xCD, 0x48, 0x60, 0x4B, 0x6E, 0xE1, 0x01, 0x12, 0x01, 0x72, 0x0E, 0x09, 0x38, 0x2A,
  0xDE, 0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A, 0xDE, 0x93,
  0x82, 0xAD, 0xE9, 0x38, 0x2A, 0xCC, 0xB3, 0x89, 0x5C, 0xB7, 0xF7, 0x48, 0xF5, 0x07, 0xDE, 0xD6,
  0x10,
  // "ũ" (U+0169)
  0x18, 0x90, 0xCD, 0x48, 0x64, 0xB6, 0xEE, 0x0F, 0x12, 0x82, 0x10, 0xF7, 0x28, 0x2B, 0xBF, 0x72,
  0x82, 0xBB, 0xF7, 0x28, 0x2B, 0xBF, 0x72, 0x82, 0xBB, 0xF7, 0x28, 0x2C, 0xBF, 0x82, 0x89, 0x4D,
  0xBC, 0xD2, 0x7F, 0xB3, 0xDE, 0x98, 0xB0,
  // "Ū" (U+016A)
  0x10, 0x6B, 0x09, 0x28, 0x31, 0x33, 0x32, 0x71, 0x0E, 0x09, 0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD,
  0xE9, 0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9, 0x38,
  0x2A, 0xCC, 0xB3, 0x89, 0x5C, 0xB7, 0xF7, 0x48, 0xF5, 0x07, 0xDE, 0xD6, 0x10,
  // "ū" (U+016B)
  0x06, 0xB8, 0x90, 0x90, 0x13, 0x33, 0x20, 0xF7, 0x28, 0x2B, 0xBF, 0x72, 0x82, 0xBB, 0xF7, 0x28,
  0x2B, 0xBF, 0x72, 0x82, 0xBB, 0xF7, 0x28, 0x2C, 0xBF, 0x82, 0x89, 0x4D, 0xBC, 0xD2, 0x7F, 0xB3,
  0xDE, 0x98, 0xB0,
  // "Ŭ" (U+016C)
  0x18, 0x34, 0x91, 0x58, 0x28, 0x31, 0xDF, 0xE4, 0x40, 0x27, 0x30, 0xE0, 0x93, 0x82, 0xAD, 0xE9,
  0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A,
  0xDE, 0x93, 0x82, 0xAC, 0xCB, 0x38, 0x95, 0xCB, 0x7F, 0x74, 0x8F, 0x50, 0x7D, 0xED, 0x61,
  // "ŭ" (U+016D)
  0x89, 0x14, 0x91, 0x58, 0x01, 0xDF, 0xE4, 0x30, 0x23, 0x90, 0x72, 0x82, 0xBB, 0xF7, 0x28, 0x2B,
  0xBF, 0x72, 0x82, 0xBB, 0xF7, 0x28, 0x2B, 0xBF, 0x72, 0x82, 0xCB, 0xF8, 0x28, 0x94, 0xDB, 0xCD,
  0x27, 0xFB, 0x3D, 0xE9, 0x8B,
  // "Ů" (U+016E)
  0x18, 0x21, 0xCF, 0x63, 0x82, 0x5B, 0x6D, 0x38, 0x22, 0xEF, 0x85, 0x02, 0x73, 0x0E, 0x09, 0x38,
  0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A, 0xDE,
  0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A, 0xCC, 0xB3, 0x89, 0x5C, 0xB7, 0xF7, 0x48, 0xF5, 0x07, 0xDE,
  0xD6, 0x10,
  // "ů" (U+016F)
  0x18, 0x21, 0xCF, 0x62, 0x82, 0x5B, 0x6D, 0x28, 0x22, 0xEF, 0x84, 0x02, 0x29, 0x07, 0x28, 0x2B,
  0xBF, 0x72, 0x82, 0xBB, 0xF7, 0x28, 0x2B, 0xBF, 0x72, 0x82, 0xBB, 0xF7, 0x28, 0x2C, 0xBF, 0x82,
  0x89, 0x4D, 0xBC, 0xD2, 0x7F, 0xB3, 0xDE, 0x98, 0xB0,
  // "Ű" (U+0170)
  0x38, 0x22, 0x02, 0x12, 0x89, 0x18, 0xD3, 0xF4, 0x02, 0xC1, 0xB5, 0x77, 0x10, 0xE0, 0x93, 0x82,
  0xAD, 0xE9, 0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9,
  0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAC, 0xCB, 0x38, 0x95, 0xCB, 0x7F, 0x74, 0x8F, 0x50, 0x7D, 0xED,
  0x61,
  // "ű" (U+0171)
  0x28, 0x95, 0x20, 0x21, 0x08, 0xD3, 0xF4, 0x2C, 0x1B, 0x57, 0x90, 0x72, 0x82, 0xBB, 0xF7, 0x28,
  0x2B, 0xBF, 0x72, 0x82, 0xBB, 0xF7, 0x28, 0x2B, 0xBF, 0x72, 0x82, 0xCB, 0xF8, 0x28, 0x94, 0xDB,
  0xCD, 0x27, 0xFB, 0x3D, 0xE9, 0x8B,
  // "Ų" (U+0172)
  0x0E, 0x09, 0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9,
  0x38, 0x2A, 0xDE, 0x93, 0x82, 0xAD, 0xE9, 0x38, 0x2A, 0xCC, 0xB3, 0x89, 0x2C, 0xB7, 0xF7, 0x48,
  0xF4, 0x07, 0xDA, 0x05, 0x40, 0x40, 0x95, 0x81, 0xAA, 0x24, 0x81, 0x6E, 0x91,
  // "ų" (U+0173)
  0x90, 0x72, 0x82, 0xBB, 0xF7, 0x28, 0x2B, 0xBF, 0x72, 0x82, 0xBB, 0xF7, 0x28, 0x2B, 0xBF, 0x72,
  0x82, 0xCB, 0xF8, 0x28, 0x93, 0xDB, 0xCD, 0x27, 0xFB, 0x3D, 0xE9, 0xB9, 0x38, 0x11, 0xD1, 0x38,
  0x15, 0xD1, 0x30, 0x2A, 0x40, 0x10, 0x20,
  // "Ŵ" (U+0174)
  0x50, 0x70, 0x57, 0x28, 0x27, 0xDE, 0x27, 0x83, 0x2D, 0x25, 0xC7, 0x77, 0x70, 0xC0, 0xB3, 0x0D,
  0x0C, 0x38, 0x2C, 0xB8, 0xE2, 0x01, 0xA3, 0x98, 0xA5, 0x85, 0xF2, 0x05, 0xDE, 0x40, 0x3F, 0x41,
  0xF6, 0x09, 0xAC, 0x80, 0x79, 0x28, 0x90, 0xD9, 0x0C, 0x78, 0xB0, 0xAC, 0x28, 0x90, 0x9D, 0x1F,
  0x35, 0xF0, 0xE9, 0x28, 0x90, 0x6F, 0x5F, 0x01, 0xF5, 0xF5, 0x28, 0x22, 0xFB, 0xB2, 0x82, 0xCB,
  0xF1, 0x38, 0x1E, 0xF8, 0x28, 0x19, 0xFD, 0x48, 0x1A, 0xF4, 0x28, 0x15, 0xFA, 0x20,
  // "ŵ" (U+0175)
  0x40, 0x70, 0x57, 0x82, 0x7D, 0xE2, 0x58, 0x32, 0xD2, 0x5C, 0x76, 0x00, 0xB2, 0x86, 0xCF, 0x10,
  0x7E, 0x7E, 0x29, 0x8B, 0x7E, 0x40, 0xAB, 0x4F, 0x24, 0xEA, 0x80, 0xE7, 0x0F, 0x58, 0xA7, 0xB2,
  0xF3, 0x0C, 0x8B, 0x74, 0xE5, 0x92, 0x86, 0x8B, 0xE3, 0x1F, 0xAB, 0x20, 0x50, 0xE9, 0x28, 0x1D,
  0xE8, 0x28, 0x11, 0xFC, 0x28, 0x19, 0xF4, 0x10,
  // "Ŷ" (U+0176)
  0x30, 0x70, 0x54, 0x82, 0x7D, 0xE2, 0x28, 0x32, 0xD2, 0x5C, 0x77, 0x10, 0x0C, 0x38, 0x95, 0xCB,
  0x5F, 0x30, 0x2F, 0x40, 0xD9, 0x08, 0xD2, 0x83, 0x7E, 0x1E, 0x63, 0x81, 0xEA, 0xE4, 0x81, 0x8F,
  0x84, 0x81, 0x4F, 0x44, 0x81, 0x4F, 0x44, 0x81, 0x4F, 0x44, 0x81, 0x4F, 0x42,
  // "ŷ" (U+0177)
  0x20, 0x70, 0x54, 0x82, 0x7D, 0xE2, 0x28, 0x32, 0xD2, 0x5C, 0x72, 0x0C, 0x0B, 0x28, 0x96, 0x3F,
  0x47, 0xF1, 0x08, 0xE0, 0x2F, 0x50, 0xCA, 0x28, 0x3C, 0x91, 0xF5, 0x28, 0x17, 0xE5, 0x93, 0x82,
  0x2F, 0xCB, 0x48, 0x1C, 0xF6, 0x48, 0x18, 0xF1, 0x40, 0x0B, 0x38, 0x23, 0x6F, 0x53, 0x81, 0xAE,
  0x84,
  // "Ÿ" (U+0178)
  0x18, 0x2D, 0x44, 0xE3, 0x01, 0x20, 0x17, 0x20, 0x0C, 0x38, 0x95, 0xCB, 0x5F, 0x30, 0x2F, 0x40,
  0xD9, 0x08, 0xD2, 0x83, 0x7E, 0x1E, 0x63, 0x81, 0xEA, 0xE4, 0x81, 0x8F, 0x84, 0x81, 0x4F, 0x44,
  0x81, 0x4F, 0x44, 0x81, 0x4F, 0x44, 0x81, 0x4F, 0x42,
  // "Ź" (U+0179)
  0x38, 0x11, 0x74, 0x48, 0x19, 0xE1, 0x38, 0x13, 0xE2, 0x77, 0x20, 0x7D, 0x85, 0x11, 0x33, 0x3D,
  0xD4, 0x81, 0x4F, 0x54, 0x0B, 0x0C, 0x48, 0x14, 0xF4, 0x40, 0x0C, 0x48, 0x14, 0xF4, 0x40, 0xC0,
  0xB4, 0x86, 0x5F, 0x73, 0x33, 0x09, 0xD0, 0x30,
  // "ź" (U+017A)
  0x28, 0x11, 0x74, 0x38, 0x19, 0xE1, 0x28, 0x13, 0xE2, 0x71, 0x06, 0xC1, 0x83, 0x13, 0x3D, 0xC3,
  0x81, 0x4F, 0x43, 0x0C, 0x0B, 0x38, 0x14, 0xF3, 0x30, 0xC0, 0xB3, 0x85, 0x5F, 0x73, 0x30, 0x9C,
  0x01,
  // "Ż" (U+017B)
  0x28, 0x14, 0xF2, 0x50, 0x27, 0x73, 0x07, 0xD8, 0x51, 0x13, 0x33, 0xDD, 0x48, 0x14, 0xF5, 0x40,
  0xB0, 0xC4, 0x81, 0x4F, 0x44, 0x00, 0xC4, 0x81, 0x4F, 0x44, 0x0C, 0x0B, 0x48, 0x65, 0xF7, 0x33,
  0x30, 0x9D, 0x03,
  // "ż" (U+017C)
  0x18, 0x14, 0xF2, 0x40, 0x27, 0x20, 0x6C, 0x18, 0x31, 0x33, 0xDC, 0x38, 0x14, 0xF4, 0x30, 0xC0,
  0xB3, 0x81, 0x4F, 0x33, 0x0C, 0x0B, 0x38, 0x55, 0xF7, 0x33, 0x09, 0xC0, 0x10,
  // "Ž" (U+017D)
  0x02, 0x05, 0x20, 0x73, 0x82, 0xC7, 0xB8, 0x38, 0x12, 0xFD, 0x77, 0x30, 0x7D, 0x85, 0x11, 0x33,
  0x3D, 0xD4, 0x81, 0x4F, 0x54, 0x0B, 0x0C, 0x48, 0x14, 0xF4, 0x40, 0x0C, 0x48, 0x14, 0xF4, 0x40,
  0xC0, 0xB4, 0x86, 0x5F, 0x73, 0x33, 0x09, 0xD0, 0x30,
  // "ž" (U+017E)
  0x02, 0x05, 0x20, 0x72, 0x82, 0xC7, 0xB8, 0x28, 0x12, 0xFD, 0x71, 0x06, 0xC1, 0x83, 0x13, 0x3D,
  0xC3, 0x81, 0x4F, 0x43, 0x0C, 0x0B, 0x38, 0x14, 0xF3, 0x30, 0xC0, 0xB3, 0x85, 0x5F, 0x73, 0x30,
  0x9C, 0x01,
  // "ſ" (U+017F)
  0x89, 0x03, 0xDE, 0x7B, 0xD4, 0x2D, 0x92, 0x0E, 0x09, 0x20, 0xE0, 0x92, 0x0E, 0x09, 0x20, 0xE0,
  0x92, 0x0E, 0x09, 0x20, 0xE0, 0x92, 0x0E, 0x09, 0x20, 0xE0, 0x92,
  // "Ω" (U+03A9)
  0x28, 0x46, 0xCF, 0xEA, 0x13, 0x85, 0x6F, 0xA4, 0x6E, 0xD3, 0x0E, 0x0C, 0x38, 0x54, 0xF6, 0x02,
  0xF7, 0x49, 0x83, 0x90, 0x2F, 0x64, 0x84, 0xDA, 0x01, 0xF7, 0x40, 0xE0, 0x92, 0x0D, 0x0A, 0x38,
  0x12, 0xF5, 0x28, 0x16, 0xE1, 0x20, 0x80, 0xD2, 0x89, 0x12, 0x3C, 0xB0, 0x4F, 0x63, 0x08, 0xB0,
  0x10, 0x9B, 0x01,
  // "μ" (U+03BC)
  0x90, 0x72, 0x82, 0xAB, 0xF7, 0x28, 0x2A, 0xBF, 0x72, 0x82, 0xAB, 0xF7, 0x28, 0x2A, 0xBF, 0x72,
  0x82, 0xBB, 0xF8, 0x28, 0x96, 0xDB, 0xFD, 0x48, 0xFB, 0xFC, 0xEB, 0x7B, 0xF7, 0x49, 0x07, 0x49,
  0x07, 0x40,
  // "π" (U+03C0)
  0x09, 0xF8, 0x91, 0x3A, 0xE3, 0x3C, 0xB3, 0x08, 0xE2, 0x0C, 0x0A, 0x20, 0x80, 0xE2, 0x0C, 0x0A,
  0x20, 0x80, 0xE2, 0x0C, 0x0A, 0x20, 0x80, 0xE2, 0x0C, 0x0A, 0x20, 0x80, 0xE2, 0x84, 0xBD, 0x40,
  0x8E, 0x28, 0x14, 0xEC,
  // "–" (U+2013)
  0x06, 0xD0, 0xE0, 0x18, 0x01, 0x30, 0x20,
  // "—" (U+2014)
  0x06, 0xFE, 0x06, 0x01, 0x80, 0x91, 0x30, 0x10,
  // "€" (U+20AC)
  0x28, 0x95, 0x3C, 0xFD, 0x70, 0x2F, 0xA4, 0x54, 0x09, 0xE4, 0x0B, 0xC8, 0x90, 0x60, 0x2C, 0xC3,
  0x31, 0x0A, 0xA0, 0x0E, 0x30, 0x80, 0xE5, 0x81, 0x4F, 0x35, 0x83, 0xCC, 0x45, 0x62, 0x83, 0x2B,
  0xFE, 0x70,
  // "₿" (U+20BF)
  0x18, 0x1A, 0x2D, 0x38, 0x1A, 0x2D, 0x20, 0xCB, 0x89, 0x08, 0x0C, 0xB3, 0x8F, 0x5C, 0xA2, 0x98,
  0x67, 0xCA, 0x05, 0xF4, 0xCB, 0x89, 0x09, 0x0C, 0xB3, 0x7F, 0x5C, 0xA2, 0x82, 0xDB, 0xCA, 0x28,
  0x7D, 0xAC, 0xB3, 0x7F, 0x6C, 0xB0, 0x82, 0x81, 0xA2, 0xD3, 0x81, 0x51, 0x62,
  // "‘" (U+2018)
  0x18, 0x4B, 0x82, 0xF3, 0x89, 0x10,
  // "’" (U+2019)
  0x86, 0x1F, 0x74, 0xF2, 0x8A, 0x10,
  // "‚" (U+201A)
  0x86, 0x1F, 0x74, 0xF2, 0x8A, 0x10,
  // "‛" (U+201B)
  0x87, 0x8F, 0x12, 0xF4, 0x0B, 0x80,
  // "“" (U+201C)
  0x18, 0x96, 0xB8, 0x0E, 0x42, 0xF3, 0x6F, 0x08, 0xF0, 0xBC, 0x10,
  // "”" (U+201D)
  0x89, 0x71, 0xF7, 0x5F, 0x34, 0xF2, 0x8D, 0x08, 0xA0, 0xC7, 0x10,
  // "„" (U+201E)
  0x89, 0x71, 0xF7, 0x5F, 0x34, 0xF2, 0x8D, 0x08, 0xA0, 0xC7, 0x10,
  // "‟" (U+201F)
  0x89, 0x08, 0xF0, 0xBC, 0x02, 0xF3, 0x69, 0x28, 0x3B, 0x80, 0xE4,
  // "†" (U+2020)
  0x28, 0x12, 0xF4, 0x48, 0x11, 0xF2, 0x59, 0x30, 0x2B, 0x87, 0xEF, 0x40, 0x10, 0xE0, 0x14, 0x90,
  0x15, 0x90, 0x14, 0x81, 0x1F, 0x24, 0x81, 0x1F, 0x34, 0x81, 0x2F, 0x44, 0x81, 0x3F, 0x42,
  // "‡" (U+2021)
  0x28, 0x12, 0xF4, 0x59, 0x02, 0x28, 0x94, 0x15, 0x4E, 0x55, 0x12, 0xCB, 0xFB, 0xC4, 0x39, 0x02,
  0x48, 0x11, 0xF3, 0x59, 0x02, 0x28, 0x94, 0x1A, 0x9F, 0x9A, 0x31, 0x75, 0xE6, 0x72, 0x39, 0x02,
  0x48, 0x12, 0xF4, 0x20,
  // "•" (U+2022)
  0x83, 0x6E, 0xD3, 0xEA, 0x0A, 0x0E, 0xA8, 0x3A, 0x6E, 0xD3,
  // "…" (U+2026)
  0x0D, 0x09, 0x28, 0x5D, 0x90, 0xD9, 0xC9, 0x28, 0x3C, 0x90, 0xC9,
  // "‰" (U+2030)
  0x18, 0x18, 0xEA, 0x28, 0x11, 0xE2, 0x78, 0x62, 0xF5, 0xE5, 0x07, 0xB7, 0x18, 0x65, 0xC0, 0xA8,
  0x0D, 0x47, 0x18, 0x55, 0xC0, 0xA8, 0x5C, 0x72, 0x89, 0x53, 0xE2, 0xD6, 0xC5, 0x8D, 0x80, 0x1B,
  0xD4, 0x28, 0x94, 0xBF, 0xD5, 0xE3, 0xE1, 0xD4, 0x8A, 0x3E, 0x38, 0x94, 0x20, 0xB7, 0x6C, 0x0A,
  0x7B, 0x60, 0xF2, 0x38, 0x93, 0x2E, 0x16, 0xC0, 0xB7, 0xB7, 0x0F, 0x23, 0x89, 0x29, 0x90, 0x3F,
  0x5E, 0x58, 0xB7, 0xE3, 0x81, 0x1E, 0x22, 0x86, 0x9E, 0xA0, 0x1C, 0xE5, 0x10,
  // "‹" (U+2039)
  0x28, 0x93, 0xA9, 0x06, 0xF2, 0x3F, 0x70, 0x2F, 0x72, 0x81, 0x6F, 0x22, 0x0A, 0x09,
  // "›" (U+203A)
  0x81, 0x3E, 0x22, 0x0B, 0x0C, 0x28, 0x94, 0x1E, 0x90, 0x2E, 0x90, 0xBC, 0x03, 0xE2, 0x10,
  // "⁄" (U+2044)
  0x58, 0x12, 0xE1, 0x50, 0xB0, 0x75, 0x05, 0x0D, 0x60, 0xD0, 0x55, 0x07, 0x0B, 0x58, 0x11, 0xE3,
  0x50, 0x09, 0x58, 0x12, 0xE1, 0x50, 0xB0, 0x75, 0x05, 0x0D, 0x60,
  // "™" (U+2122)
  0x81, 0xAD, 0xD0, 0xFA, 0x28, 0xE2, 0xE5, 0x07, 0x60, 0xBD, 0x05, 0xE5, 0x07, 0x60, 0xBA, 0x5A,
  0x95, 0x07, 0x60, 0xB5, 0xAB, 0x85, 0x07, 0x60, 0xB2, 0xD6, 0x85, 0x03, 0x20, 0x40, 0x41, 0x32,
  // "⅒" (U+2152)
  0x18, 0x13, 0xE8, 0x38, 0x12, 0xE1, 0x58, 0x22, 0xDB, 0x83, 0x0B, 0x07, 0x71, 0x09, 0x08, 0x20,
  0x50, 0xD7, 0x20, 0x90, 0x82, 0x0D, 0x05, 0x38, 0x19, 0xD8, 0x38, 0x93, 0x98, 0x07, 0xB3, 0xE8,
  0x5D, 0x3E, 0x42, 0x89, 0x39, 0x81, 0xE6, 0xDB, 0x88, 0x90, 0xA8, 0x40, 0x09, 0x28, 0x59, 0x89,
  0x80, 0x99, 0x38, 0x12, 0xE1, 0x28, 0x59, 0x88, 0x90, 0x98, 0x30, 0xB0, 0x73, 0x85, 0x98, 0x5C,
  0x0D, 0x52, 0x05, 0x0D, 0x48, 0x49, 0x80, 0xBF, 0xB1,
  // "ﬁ" (U+FB01)
  0x18, 0x92, 0x2C, 0xF9, 0xD7, 0x09, 0xE4, 0x22, 0x20, 0x0B, 0x40, 0x9B, 0x89, 0x33, 0xF7, 0x3C,
  0xC3, 0x0F, 0x70, 0xBB, 0x29, 0x82, 0x70, 0xBB, 0x29, 0x82, 0x70, 0xBB, 0x29, 0x82, 0x70, 0xBB,
  0x29, 0x82, 0x70, 0xBB, 0x29, 0x82, 0x70, 0xBB, 0x29, 0x07,
  // "ﬂ" (U+FB02)
  0x18, 0x96, 0x2C, 0xF9, 0xF7, 0x09, 0xE4, 0x2F, 0x70, 0xBB, 0x29, 0x07, 0x09, 0xB8, 0x93, 0x3F,
  0x73, 0xCC, 0x30, 0xF7, 0x0B, 0xB2, 0x98, 0x27, 0x0B, 0xB2, 0x98, 0x27, 0x0B, 0xB2, 0x98, 0x27,
  0x0B, 0xB2, 0x98, 0x27, 0x0B, 0xB2, 0x98, 0x27, 0x0B, 0xB2, 0x90, 0x70,
};

const Font& font_NotoSans_CondensedMedium_15() {
  static SmoothFont font(font_NotoSans_CondensedMedium_15_data);
  return font;
}

}  // namespace roo_display
