#include "14.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedMedium (Noto Sans Condensed Medium)
// Generated on Thu Mar 30 23:43:28 CEST 2023
static const uint8_t font_NotoSans_CondensedMedium_14_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x04, 0x4C,
  0xFD, 0xFD, 0x0E, 0x0F, 0x0B, 0xFD, 0x05, 0x02, 0x0F, 0x04, 0x03, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x01, 0x01, 0x02, 0x0A, 0x04, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x00, 0x08, 0x04, 0x0A, 0x06, 0x00, 0x0C, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x00, 0x15, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x06, 0x0B, 0x07, 0x00, 0x3C, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x00, 0x62, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x00, 0x99, // "&" (U+0026)
  0x00, 0x27, 0x00, 0x08, 0x02, 0x0A, 0x03, 0x00, 0xC3, // "'" (U+0027)
  0x00, 0x28, 0x00, 0xFF, 0x03, 0x0A, 0x04, 0x00, 0xC9, // "(" (U+0028)
  0x00, 0x29, 0x00, 0xFF, 0x03, 0x0A, 0x04, 0x00, 0xE4, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x06, 0x05, 0x0B, 0x06, 0x01, 0x00, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x03, 0x06, 0x09, 0x07, 0x01, 0x15, // "+" (U+002B)
  0x00, 0x2C, 0x00, 0xFF, 0x02, 0x02, 0x03, 0x01, 0x29, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x03, 0x03, 0x04, 0x04, 0x01, 0x31, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x01, 0x02, 0x02, 0x03, 0x01, 0x36, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x01, 0x3A, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x01, 0x54, // "0" (U+0030)
  0x00, 0x31, 0x01, 0x01, 0x04, 0x0A, 0x07, 0x01, 0x7B, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x01, 0x94, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x01, 0xB4, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x01, 0xD2, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x01, 0xF4, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x02, 0x12, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x02, 0x38, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x02, 0x54, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x02, 0x7B, // "9" (U+0039)
  0x00, 0x3A, 0x01, 0x01, 0x02, 0x08, 0x03, 0x02, 0x9D, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0xFF, 0x02, 0x08, 0x03, 0x02, 0xA4, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x03, 0x06, 0x08, 0x07, 0x02, 0xB0, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x03, 0x06, 0x07, 0x07, 0x02, 0xC3, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x06, 0x09, 0x07, 0x02, 0xD0, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x02, 0xE6, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFF, 0x09, 0x0A, 0x0A, 0x03, 0x00, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x07, 0x0A, 0x07, 0x03, 0x39, // "A" (U+0041)
  0x00, 0x42, 0x01, 0x01, 0x06, 0x0A, 0x08, 0x03, 0x5F, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x03, 0x81, // "C" (U+0043)
  0x00, 0x44, 0x01, 0x01, 0x07, 0x0A, 0x08, 0x03, 0xA2, // "D" (U+0044)
  0x00, 0x45, 0x01, 0x01, 0x05, 0x0A, 0x06, 0x03, 0xC9, // "E" (U+0045)
  0x00, 0x46, 0x01, 0x01, 0x05, 0x0A, 0x06, 0x03, 0xE2, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x03, 0xFA, // "G" (U+0047)
  0x00, 0x48, 0x01, 0x01, 0x07, 0x0A, 0x09, 0x04, 0x23, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x03, 0x0A, 0x04, 0x04, 0x46, // "I" (U+0049)
  0x00, 0x4A, 0xFF, 0xFD, 0x02, 0x0A, 0x04, 0x04, 0x5E, // "J" (U+004A)
  0x00, 0x4B, 0x01, 0x01, 0x07, 0x0A, 0x07, 0x04, 0x80, // "K" (U+004B)
  0x00, 0x4C, 0x01, 0x01, 0x05, 0x0A, 0x06, 0x04, 0xA7, // "L" (U+004C)
  0x00, 0x4D, 0x01, 0x01, 0x09, 0x0A, 0x0B, 0x04, 0xC1, // "M" (U+004D)
  0x00, 0x4E, 0x01, 0x01, 0x07, 0x0A, 0x09, 0x04, 0xF0, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x07, 0x0A, 0x09, 0x05, 0x17, // "O" (U+004F)
  0x00, 0x50, 0x01, 0x01, 0x06, 0x0A, 0x07, 0x05, 0x42, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFE, 0x08, 0x0A, 0x09, 0x05, 0x60, // "Q" (U+0051)
  0x00, 0x52, 0x01, 0x01, 0x06, 0x0A, 0x07, 0x05, 0x97, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x05, 0xB9, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x05, 0xD7, // "T" (U+0054)
  0x00, 0x55, 0x01, 0x01, 0x07, 0x0A, 0x08, 0x05, 0xF2, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x06, 0x1A, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x0A, 0x0A, 0x0B, 0x06, 0x3F, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x06, 0x7A, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x06, 0xA0, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x06, 0xBF, // "Z" (U+005A)
  0x00, 0x5B, 0x01, 0xFD, 0x03, 0x0A, 0x04, 0x06, 0xDC, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x06, 0xF0, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0xFD, 0x03, 0x0A, 0x04, 0x07, 0x09, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x05, 0x06, 0x0A, 0x07, 0x07, 0x2C, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFE, 0x06, 0xFF, 0x06, 0x07, 0x42, // "_" (U+005F)
  0x00, 0x60, 0x00, 0x0A, 0x03, 0x0C, 0x04, 0x07, 0x46, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x05, 0x08, 0x07, 0x07, 0x4E, // "a" (U+0061)
  0x00, 0x62, 0x01, 0x01, 0x06, 0x0B, 0x07, 0x07, 0x69, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x05, 0x08, 0x06, 0x07, 0x8B, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x07, 0xA5, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x05, 0x08, 0x07, 0x07, 0xCB, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x04, 0x0B, 0x04, 0x07, 0xE4, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFE, 0x06, 0x08, 0x07, 0x08, 0x02, // "g" (U+0067)
  0x00, 0x68, 0x01, 0x01, 0x06, 0x0B, 0x07, 0x08, 0x2A, // "h" (U+0068)
  0x00, 0x69, 0x01, 0x01, 0x02, 0x0B, 0x03, 0x08, 0x4A, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xFE, 0x02, 0x0B, 0x03, 0x08, 0x57, // "j" (U+006A)
  0x00, 0x6B, 0x01, 0x01, 0x06, 0x0B, 0x06, 0x08, 0x72, // "k" (U+006B)
  0x00, 0x6C, 0x01, 0x01, 0x02, 0x0B, 0x03, 0x08, 0x94, // "l" (U+006C)
  0x00, 0x6D, 0x01, 0x01, 0x09, 0x08, 0x0B, 0x08, 0xA1, // "m" (U+006D)
  0x00, 0x6E, 0x01, 0x01, 0x06, 0x08, 0x07, 0x08, 0xC7, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x06, 0x08, 0x07, 0x08, 0xE1, // "o" (U+006F)
  0x00, 0x70, 0x01, 0xFE, 0x06, 0x08, 0x07, 0x09, 0x01, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFE, 0x06, 0x08, 0x07, 0x09, 0x23, // "q" (U+0071)
  0x00, 0x72, 0x01, 0x01, 0x04, 0x08, 0x05, 0x09, 0x4A, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x04, 0x08, 0x05, 0x09, 0x5B, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x03, 0x0A, 0x04, 0x09, 0x72, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x06, 0x08, 0x07, 0x09, 0x88, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0xA6, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x09, 0x08, 0x0A, 0x09, 0xC2, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x05, 0x08, 0x06, 0x09, 0xED, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x0A, 0x08, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0A, 0x2C, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFD, 0x04, 0x0A, 0x05, 0x0A, 0x42, // "{" (U+007B)
  0x00, 0x7C, 0x02, 0xFE, 0x03, 0x0B, 0x06, 0x0A, 0x65, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0xFD, 0x04, 0x0A, 0x05, 0x0A, 0x75, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x04, 0x06, 0x06, 0x07, 0x0A, 0x9C, // "~" (U+007E)
  0x00, 0xA1, 0x01, 0xFF, 0x02, 0x08, 0x04, 0x0A, 0xA7, // "¡" (U+00A1)
  0x00, 0xA2, 0x01, 0x01, 0x05, 0x0A, 0x07, 0x0A, 0xB3, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x0A, 0xCF, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x02, 0x06, 0x09, 0x08, 0x0A, 0xED, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x0B, 0x0C, // "¥" (U+00A5)
  0x00, 0xA6, 0x02, 0xFE, 0x03, 0x0B, 0x06, 0x0B, 0x2D, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0B, 0x3C, // "§" (U+00A7)
  0x00, 0xA8, 0x01, 0x09, 0x05, 0x0A, 0x07, 0x0B, 0x5F, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x00, 0x0A, 0x0B, 0x0C, 0x0B, 0x65, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x07, 0x03, 0x0A, 0x05, 0x0B, 0xA3, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x02, 0x06, 0x07, 0x07, 0x0B, 0xAD, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x06, 0x06, 0x07, 0x0B, 0xC4, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x00, 0x0A, 0x0B, 0x0C, 0x0B, 0xD1, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x0B, 0x06, 0x0C, 0x06, 0x0C, 0x11, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x06, 0x04, 0x0A, 0x05, 0x0C, 0x16, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x06, 0x09, 0x07, 0x0C, 0x24, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x07, 0x03, 0x0C, 0x05, 0x0C, 0x3E, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x07, 0x03, 0x0C, 0x05, 0x0C, 0x4C, // "³" (U+00B3)
  0x00, 0xB4, 0x00, 0x0A, 0x03, 0x0C, 0x04, 0x0C, 0x5B, // "´" (U+00B4)
  0x00, 0xB5, 0x01, 0xFE, 0x06, 0x08, 0x07, 0x0C, 0x63, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFE, 0x06, 0x0B, 0x08, 0x0C, 0x82, // "¶" (U+00B6)
  0x00, 0xB7, 0x00, 0x05, 0x02, 0x06, 0x03, 0x0C, 0xB5, // "·" (U+00B7)
  0x00, 0xB8, 0x00, 0xFD, 0x02, 0x00, 0x03, 0x0C, 0xB9, // "¸" (U+00B8)
  0x00, 0xB9, 0x00, 0x07, 0x03, 0x0C, 0x05, 0x0C, 0xC1, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x06, 0x04, 0x0A, 0x05, 0x0C, 0xD0, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x02, 0x06, 0x07, 0x07, 0x0C, 0xDE, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x0A, 0x0A, 0x0A, 0x0C, 0xF5, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x00, 0x0A, 0x0A, 0x0B, 0x0D, 0x29, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x0A, 0x0B, 0x0B, 0x0D, 0x64, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFE, 0x04, 0x07, 0x05, 0x0D, 0xA2, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x07, 0x0E, 0x07, 0x0D, 0xBC, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x07, 0x0E, 0x07, 0x0D, 0xEB, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x07, 0x0E, 0x07, 0x0E, 0x1A, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x07, 0x0D, 0x07, 0x0E, 0x4A, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x07, 0x0C, 0x07, 0x0E, 0x7B, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x07, 0x0D, 0x07, 0x0E, 0xA8, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x0E, 0xD8, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFD, 0x06, 0x0A, 0x07, 0x0F, 0x06, // "Ç" (U+00C7)
  0x00, 0xC8, 0x01, 0x01, 0x05, 0x0E, 0x06, 0x0F, 0x33, // "È" (U+00C8)
  0x00, 0xC9, 0x01, 0x01, 0x05, 0x0E, 0x06, 0x0F, 0x54, // "É" (U+00C9)
  0x00, 0xCA, 0x01, 0x01, 0x05, 0x0E, 0x06, 0x0F, 0x76, // "Ê" (U+00CA)
  0x00, 0xCB, 0x01, 0x01, 0x05, 0x0C, 0x06, 0x0F, 0x98, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x03, 0x0E, 0x04, 0x0F, 0xB7, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x04, 0x0E, 0x04, 0x0F, 0xD8, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x04, 0x0E, 0x04, 0x0F, 0xFC, // "Î" (U+00CE)
  0x00, 0xCF, 0xFF, 0x01, 0x03, 0x0C, 0x04, 0x10, 0x20, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x10, 0x40, // "Ð" (U+00D0)
  0x00, 0xD1, 0x01, 0x01, 0x07, 0x0D, 0x09, 0x10, 0x6D, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x07, 0x0E, 0x09, 0x10, 0x9F, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x07, 0x0E, 0x09, 0x10, 0xD3, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x07, 0x0E, 0x09, 0x11, 0x07, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x07, 0x0D, 0x09, 0x11, 0x3C, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x07, 0x0C, 0x09, 0x11, 0x72, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x03, 0x05, 0x08, 0x07, 0x11, 0xA4, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x08, 0x0B, 0x09, 0x11, 0xB9, // "Ø" (U+00D8)
  0x00, 0xD9, 0x01, 0x01, 0x07, 0x0E, 0x08, 0x11, 0xED, // "Ù" (U+00D9)
  0x00, 0xDA, 0x01, 0x01, 0x07, 0x0E, 0x08, 0x12, 0x1F, // "Ú" (U+00DA)
  0x00, 0xDB, 0x01, 0x01, 0x07, 0x0E, 0x08, 0x12, 0x51, // "Û" (U+00DB)
  0x00, 0xDC, 0x01, 0x01, 0x07, 0x0C, 0x08, 0x12, 0x84, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x06, 0x0E, 0x07, 0x12, 0xB3, // "Ý" (U+00DD)
  0x00, 0xDE, 0x01, 0x01, 0x06, 0x0A, 0x07, 0x12, 0xDC, // "Þ" (U+00DE)
  0x00, 0xDF, 0x01, 0x01, 0x06, 0x0B, 0x07, 0x12, 0xFB, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x05, 0x0C, 0x07, 0x13, 0x20, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x05, 0x0C, 0x07, 0x13, 0x44, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x05, 0x0C, 0x07, 0x13, 0x68, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x13, 0x8D, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x13, 0xB7, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x05, 0x0C, 0x07, 0x13, 0xD9, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x09, 0x08, 0x0A, 0x14, 0x00, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFD, 0x05, 0x08, 0x06, 0x14, 0x28, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x05, 0x0C, 0x07, 0x14, 0x4E, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x05, 0x0C, 0x07, 0x14, 0x70, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x05, 0x0C, 0x07, 0x14, 0x92, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x14, 0xB5, // "ë" (U+00EB)
  0x00, 0xEC, 0xFF, 0x01, 0x02, 0x0C, 0x03, 0x14, 0xD5, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x03, 0x0C, 0x03, 0x14, 0xED, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x03, 0x0C, 0x03, 0x15, 0x05, // "î" (U+00EE)
  0x00, 0xEF, 0xFF, 0x01, 0x03, 0x0A, 0x03, 0x15, 0x1F, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x15, 0x35, // "ð" (U+00F0)
  0x00, 0xF1, 0x01, 0x01, 0x06, 0x0B, 0x07, 0x15, 0x5D, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x15, 0x81, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x15, 0xAA, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x15, 0xD3, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x15, 0xFE, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x16, 0x29, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x03, 0x06, 0x09, 0x07, 0x16, 0x50, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x06, 0x09, 0x07, 0x16, 0x61, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x16, 0x83, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x16, 0xAA, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x16, 0xD1, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x16, 0xFA, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFE, 0x05, 0x0C, 0x06, 0x17, 0x1F, // "ý" (U+00FD)
  0x00, 0xFE, 0x01, 0xFE, 0x06, 0x0B, 0x07, 0x17, 0x4C, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFE, 0x05, 0x0A, 0x06, 0x17, 0x74, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x07, 0x0C, 0x07, 0x17, 0x9F, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x17, 0xCB, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x07, 0x0D, 0x07, 0x17, 0xEC, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x18, 0x1B, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFD, 0x07, 0x0A, 0x07, 0x18, 0x3F, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFD, 0x05, 0x08, 0x07, 0x18, 0x6F, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x06, 0x0E, 0x07, 0x18, 0x94, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x18, 0xBE, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x06, 0x0E, 0x07, 0x18, 0xE1, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x19, 0x0C, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x06, 0x0D, 0x07, 0x19, 0x30, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x19, 0x55, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x06, 0x0E, 0x07, 0x19, 0x73, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x19, 0x9F, // "č" (U+010D)
  0x01, 0x0E, 0x01, 0x01, 0x07, 0x0E, 0x08, 0x19, 0xC4, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x07, 0x0B, 0x07, 0x19, 0xF6, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x1A, 0x23, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x07, 0x0B, 0x07, 0x1A, 0x50, // "đ" (U+0111)
  0x01, 0x12, 0x01, 0x01, 0x05, 0x0C, 0x06, 0x1A, 0x7C, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x1A, 0x9A, // "ē" (U+0113)
  0x01, 0x14, 0x01, 0x01, 0x05, 0x0D, 0x06, 0x1A, 0xB9, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x1A, 0xDA, // "ĕ" (U+0115)
  0x01, 0x16, 0x01, 0x01, 0x05, 0x0D, 0x06, 0x1A, 0xFC, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x1B, 0x19, // "ė" (U+0117)
  0x01, 0x18, 0x01, 0xFD, 0x05, 0x0A, 0x06, 0x1B, 0x36, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFE, 0x05, 0x08, 0x07, 0x1B, 0x59, // "ę" (U+0119)
  0x01, 0x1A, 0x01, 0x01, 0x05, 0x0E, 0x06, 0x1B, 0x7A, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x05, 0x0C, 0x07, 0x1B, 0x9C, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x1B, 0xC0, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFE, 0x06, 0x0C, 0x07, 0x1B, 0xF4, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x1C, 0x27, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFE, 0x06, 0x0B, 0x07, 0x1C, 0x5A, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x1C, 0x8C, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFE, 0x06, 0x0B, 0x07, 0x1C, 0xBA, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x07, 0x0A, 0x08, 0x1C, 0xE7, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFE, 0x06, 0x0B, 0x07, 0x1D, 0x17, // "ģ" (U+0123)
  0x01, 0x24, 0x01, 0x01, 0x07, 0x0E, 0x09, 0x1D, 0x46, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x06, 0x0F, 0x07, 0x1D, 0x74, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x1D, 0xA8, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x1D, 0xD3, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x04, 0x0D, 0x04, 0x1D, 0xFA, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0x01, 0x04, 0x0B, 0x03, 0x1E, 0x1F, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x04, 0x0C, 0x04, 0x1E, 0x39, // "Ī" (U+012A)
  0x01, 0x2B, 0xFF, 0x01, 0x03, 0x0A, 0x03, 0x1E, 0x59, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x04, 0x0D, 0x04, 0x1E, 0x6F, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFF, 0x01, 0x03, 0x0B, 0x03, 0x1E, 0x92, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFD, 0x03, 0x0A, 0x04, 0x1E, 0xAB, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFD, 0x02, 0x0B, 0x03, 0x1E, 0xCC, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x03, 0x0D, 0x04, 0x1E, 0xE3, // "İ" (U+0130)
  0x01, 0x31, 0x01, 0x01, 0x02, 0x08, 0x03, 0x1F, 0x00, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0xFD, 0x06, 0x0A, 0x08, 0x1F, 0x0A, // "Ĳ" (U+0132)
  0x01, 0x33, 0x01, 0xFE, 0x05, 0x0B, 0x07, 0x1F, 0x3D, // "ĳ" (U+0133)
  0x01, 0x34, 0xFF, 0xFD, 0x03, 0x0E, 0x04, 0x1F, 0x61, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFE, 0x03, 0x0C, 0x03, 0x1F, 0x8D, // "ĵ" (U+0135)
  0x01, 0x36, 0x01, 0xFE, 0x07, 0x0A, 0x07, 0x1F, 0xAE, // "Ķ" (U+0136)
  0x01, 0x37, 0x01, 0xFE, 0x06, 0x0B, 0x06, 0x1F, 0xDC, // "ķ" (U+0137)
  0x01, 0x38, 0x01, 0x01, 0x06, 0x08, 0x06, 0x20, 0x05, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x05, 0x0E, 0x06, 0x20, 0x21, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x03, 0x0F, 0x03, 0x20, 0x45, // "ĺ" (U+013A)
  0x01, 0x3B, 0x01, 0xFE, 0x05, 0x0A, 0x06, 0x20, 0x63, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFE, 0x02, 0x0B, 0x03, 0x20, 0x84, // "ļ" (U+013C)
  0x01, 0x3D, 0x01, 0x01, 0x05, 0x0A, 0x06, 0x20, 0x9B, // "Ľ" (U+013D)
  0x01, 0x3E, 0x01, 0x01, 0x04, 0x0B, 0x03, 0x20, 0xB5, // "ľ" (U+013E)
  0x01, 0x3F, 0x01, 0x01, 0x05, 0x0A, 0x06, 0x20, 0xCC, // "Ŀ" (U+013F)
  0x01, 0x40, 0x01, 0x01, 0x03, 0x0B, 0x04, 0x20, 0xE6, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x20, 0xF8, // "Ł" (U+0141)
  0x01, 0x42, 0xFF, 0x01, 0x03, 0x0B, 0x04, 0x21, 0x15, // "ł" (U+0142)
  0x01, 0x43, 0x01, 0x01, 0x07, 0x0E, 0x09, 0x21, 0x32, // "Ń" (U+0143)
  0x01, 0x44, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x21, 0x62, // "ń" (U+0144)
  0x01, 0x45, 0x01, 0xFE, 0x07, 0x0A, 0x09, 0x21, 0x85, // "Ņ" (U+0145)
  0x01, 0x46, 0x01, 0xFE, 0x06, 0x08, 0x07, 0x21, 0xB3, // "ņ" (U+0146)
  0x01, 0x47, 0x01, 0x01, 0x07, 0x0E, 0x09, 0x21, 0xD4, // "Ň" (U+0147)
  0x01, 0x48, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x22, 0x06, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x07, 0x0A, 0x08, 0x22, 0x2B, // "ŉ" (U+0149)
  0x01, 0x4A, 0x01, 0xFD, 0x07, 0x0A, 0x09, 0x22, 0x55, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x01, 0xFE, 0x06, 0x08, 0x07, 0x22, 0x86, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x07, 0x0C, 0x09, 0x22, 0xAA, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x22, 0xDB, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x07, 0x0D, 0x09, 0x23, 0x01, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x23, 0x35, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x07, 0x0E, 0x09, 0x23, 0x5F, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x23, 0x95, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x09, 0x0A, 0x0A, 0x23, 0xC0, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x0A, 0x08, 0x0B, 0x23, 0xF3, // "œ" (U+0153)
  0x01, 0x54, 0x01, 0x01, 0x06, 0x0E, 0x07, 0x24, 0x21, // "Ŕ" (U+0154)
  0x01, 0x55, 0x01, 0x01, 0x04, 0x0C, 0x05, 0x24, 0x4C, // "ŕ" (U+0155)
  0x01, 0x56, 0x01, 0xFE, 0x06, 0x0A, 0x07, 0x24, 0x64, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x24, 0x8D, // "ŗ" (U+0157)
  0x01, 0x58, 0x01, 0x01, 0x06, 0x0E, 0x07, 0x24, 0xA6, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x04, 0x0C, 0x05, 0x24, 0xD3, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x05, 0x0E, 0x06, 0x24, 0xEE, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x04, 0x0C, 0x05, 0x25, 0x15, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x05, 0x0E, 0x06, 0x25, 0x34, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x04, 0x0C, 0x05, 0x25, 0x5C, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFD, 0x05, 0x0A, 0x06, 0x25, 0x7C, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFD, 0x04, 0x08, 0x05, 0x25, 0xA6, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x05, 0x0E, 0x06, 0x25, 0xC8, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x04, 0x0C, 0x05, 0x25, 0xF1, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFD, 0x06, 0x0A, 0x06, 0x26, 0x10, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFD, 0x03, 0x0A, 0x04, 0x26, 0x36, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x06, 0x0E, 0x06, 0x26, 0x56, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x05, 0x0B, 0x04, 0x26, 0x7C, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x06, 0x0A, 0x06, 0x26, 0x98, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x03, 0x0A, 0x04, 0x26, 0xB5, // "ŧ" (U+0167)
  0x01, 0x68, 0x01, 0x01, 0x07, 0x0D, 0x08, 0x26, 0xCC, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x27, 0x00, // "ũ" (U+0169)
  0x01, 0x6A, 0x01, 0x01, 0x07, 0x0C, 0x08, 0x27, 0x29, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x27, 0x58, // "ū" (U+016B)
  0x01, 0x6C, 0x01, 0x01, 0x07, 0x0D, 0x08, 0x27, 0x7C, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x27, 0xAE, // "ŭ" (U+016D)
  0x01, 0x6E, 0x01, 0x01, 0x07, 0x0E, 0x08, 0x27, 0xD6, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x28, 0x0B, // "ů" (U+016F)
  0x01, 0x70, 0x01, 0x01, 0x07, 0x0E, 0x08, 0x28, 0x36, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x28, 0x6A, // "ű" (U+0171)
  0x01, 0x72, 0x01, 0xFE, 0x07, 0x0A, 0x08, 0x28, 0x93, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFD, 0x06, 0x08, 0x07, 0x28, 0xC3, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x28, 0xEB, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x29, 0x31, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x06, 0x0E, 0x07, 0x29, 0x67, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFE, 0x05, 0x0C, 0x06, 0x29, 0x91, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x29, 0xC0, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x05, 0x0E, 0x06, 0x29, 0xE7, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x04, 0x0C, 0x05, 0x2A, 0x0D, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x05, 0x0D, 0x06, 0x2A, 0x2C, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x2A, 0x4E, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x05, 0x0E, 0x06, 0x2A, 0x69, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x04, 0x0C, 0x05, 0x2A, 0x91, // "ž" (U+017E)
  0x01, 0x7F, 0x01, 0x01, 0x04, 0x0B, 0x04, 0x2A, 0xB0, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x08, 0x0A, 0x09, 0x2A, 0xC7, // "Ω" (U+03A9)
  0x03, 0xBC, 0x01, 0xFE, 0x06, 0x08, 0x07, 0x2A, 0xF7, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x07, 0x08, 0x08, 0x2B, 0x16, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x04, 0x06, 0x05, 0x07, 0x2B, 0x39, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x04, 0x0D, 0x05, 0x0E, 0x2B, 0x40, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x2B, 0x48, // "€" (U+20AC)
  0x20, 0xBF, 0x01, 0xFF, 0x06, 0x0C, 0x07, 0x2B, 0x69, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x08, 0x02, 0x0A, 0x03, 0x2B, 0x96, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x08, 0x02, 0x0A, 0x03, 0x2B, 0x9C, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0x00, 0x02, 0x02, 0x03, 0x2B, 0xA2, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x08, 0x02, 0x0A, 0x03, 0x2B, 0xA8, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x08, 0x04, 0x0A, 0x05, 0x2B, 0xAE, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x08, 0x04, 0x0A, 0x05, 0x2B, 0xB7, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0x00, 0x04, 0x02, 0x06, 0x2B, 0xC0, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x08, 0x04, 0x0A, 0x05, 0x2B, 0xC9, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x2B, 0xD2, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x2B, 0xF0, // "‡" (U+2021)
  0x20, 0x22, 0x01, 0x04, 0x04, 0x07, 0x05, 0x2C, 0x11, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x09, 0x02, 0x0A, 0x2C, 0x1A, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x0E, 0x0A, 0x0F, 0x2C, 0x26, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x02, 0x03, 0x07, 0x04, 0x2C, 0x6F, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x02, 0x03, 0x07, 0x04, 0x2C, 0x7D, // "›" (U+203A)
  0x20, 0x44, 0xFD, 0x01, 0x03, 0x0A, 0x02, 0x2C, 0x8C, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x06, 0x08, 0x0A, 0x0A, 0x2C, 0xA7, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x0E, 0x0A, 0x0E, 0x2C, 0xBF, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x2D, 0x05, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x2D, 0x30, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x01, 0x62, 0x01, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x01, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x01, // &Ŧ (U+0026 U+0166)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x2C, 0x00, 0x43, 0x01, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x01, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x01, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x01, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x01, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x01, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x01, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x01, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x01, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x01, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x01, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x01, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x01, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x01, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x01, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x01, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x01, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x01, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x01, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x01, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x01, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x01, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x01, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x43, 0x01, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x01, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x01, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x01, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x01, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x01, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x01, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x01, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x01, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x01, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x01, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x01, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x01, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x01, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x01, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x01, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x01, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x01, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x01, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x01, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x01, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x01, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x01, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x02, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x02, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x02, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x02, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x02, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x02, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x02, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x02, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x02, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x02, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x01, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x01, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x01, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x01, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x01, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x01, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0xAB, 0x01, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x01, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x01, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x01, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x01, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x01, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x01, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x01, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x4B, 0x01, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x01, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x01, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x01, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5F, 0x01, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x69, 0x01, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x01, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x01, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x01, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x01, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x01, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x01, // T‹ (U+0054 U+2039)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0xBB, 0x00, 0x54, 0x01, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x01, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x01, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x01, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x00, 0x59, 0x01, // ĽY (U+013D U+0059)
  0x01, 0x3D, 0x00, 0xDD, 0x01, // ĽÝ (U+013D U+00DD)
  0x01, 0x3D, 0x01, 0x76, 0x01, // ĽŶ (U+013D U+0176)
  0x01, 0x3D, 0x01, 0x78, 0x01, // ĽŸ (U+013D U+0178)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x00, 0x59, 0x01, // ĿY (U+013F U+0059)
  0x01, 0x3F, 0x00, 0xDD, 0x01, // ĿÝ (U+013F U+00DD)
  0x01, 0x3F, 0x01, 0x76, 0x01, // ĿŶ (U+013F U+0176)
  0x01, 0x3F, 0x01, 0x78, 0x01, // ĿŸ (U+013F U+0178)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x01, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x01, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x01, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x01, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x01, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x01, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0xAB, 0x01, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x01, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x01, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x01, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x01, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x01, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x01, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x01, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x4B, 0x01, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x01, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x01, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x01, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5F, 0x01, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x69, 0x01, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x01, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x01, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x01, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x01, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x01, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x01, // Ţ‹ (U+0162 U+2039)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x01, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x01, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x01, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x01, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x01, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x01, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0xAB, 0x01, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x01, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x01, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x01, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x01, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x01, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x01, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x01, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x4B, 0x01, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x01, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x01, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x01, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5F, 0x01, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x69, 0x01, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x01, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x01, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x01, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x01, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x01, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x01, // Ť‹ (U+0164 U+2039)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x01, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x01, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x01, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x01, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x01, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x01, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0xAB, 0x01, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x01, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x01, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x01, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x01, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x01, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x01, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x01, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x4B, 0x01, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x01, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x01, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x01, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5F, 0x01, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x69, 0x01, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x01, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x01, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x01, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x01, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x01, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x01, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x1A, 0x00, 0x43, 0x01, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x01, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x01, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x01, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x01, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x01, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x01, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x01, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x01, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x01, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x01, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x01, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x01, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x01, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x01, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x01, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x01, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x01, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x01, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x01, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x01, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x01, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x01, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1E, 0x00, 0x43, 0x01, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x01, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x01, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x01, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x01, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x01, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x01, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x01, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x01, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x01, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x01, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x01, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x01, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x01, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x01, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x01, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x01, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x01, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x01, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x01, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x01, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x01, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x01, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x01, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x01, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x01, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x01, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x02, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x02, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x02, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x02, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x02, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x02, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x02, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x02, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x02, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x02, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x98, 0x93, 0x8F, 0x7E, 0x7E, 0x6D, 0x5C, 0x5C, 0x42, 0x82, 0xD7, 0xD7,
  // """ (U+0022)
  0x89, 0x52, 0xF4, 0x9D, 0x1F, 0x37, 0xB0, 0xF1, 0x6A,
  // "#" (U+0023)
  0x28, 0x36, 0x90, 0xE1, 0x30, 0x80, 0x71, 0x94, 0x82, 0xA5, 0x3D, 0x20, 0x40, 0xEC, 0x87, 0xE1,
  0x02, 0xF2, 0x89, 0x12, 0x83, 0x2E, 0x0A, 0x62, 0x0A, 0xD8, 0x7B, 0x02, 0x8A, 0x2E, 0x42, 0x28,
  0x28, 0x71, 0xE4, 0x82, 0xB4, 0x3C, 0x30,
  // "$" (U+0024)
  0x30, 0xB4, 0x89, 0x72, 0x9E, 0xB5, 0x01, 0xEA, 0xD8, 0x80, 0x4E, 0x0B, 0x38, 0x22, 0xF6, 0xB4,
  0x82, 0x5E, 0xE7, 0x48, 0x21, 0xDD, 0xB4, 0x89, 0x3B, 0x2F, 0x13, 0x41, 0xC7, 0xE0, 0x4E, 0xA0,
  0xE0, 0x43, 0x02, 0x0C, 0x60, 0xB3,
  // "%" (U+0025)
  0x18, 0x19, 0xE7, 0x20, 0x70, 0x92, 0x81, 0x3E, 0x59, 0x20, 0xD0, 0x32, 0x85, 0x6A, 0x0D, 0x35,
  0xC3, 0x85, 0x6A, 0x0D, 0x3B, 0x53, 0x8A, 0x24, 0xD2, 0xF4, 0xE2, 0xCC, 0x10, 0xCF, 0x99, 0x8A,
  0x78, 0x92, 0x86, 0x10, 0xE2, 0xC4, 0x4C, 0x38, 0x56, 0xA0, 0xC4, 0x5C, 0x38, 0x5D, 0x40, 0xA9,
  0xAA, 0x20, 0x40, 0xD2, 0x82, 0x2D, 0xD2,
  // "&" (U+0026)
  0x18, 0x22, 0xCE, 0xB4, 0x83, 0x9D, 0x4F, 0x53, 0x83, 0x9A, 0x0D, 0x63, 0x83, 0x5E, 0x6E, 0x13,
  0x82, 0x1E, 0xF4, 0x48, 0x97, 0xCB, 0xD9, 0x0D, 0x75, 0xF1, 0x3F, 0x8F, 0x37, 0xE2, 0x8A, 0x27,
  0xFB, 0x04, 0xF7, 0x4B, 0xFD, 0x10, 0x7E, 0xEA, 0x2E, 0xA0,
  // "'" (U+0027)
  0x87, 0x2F, 0x41, 0xF3, 0x0F, 0x10,
  // "(" (U+0028)
  0x28, 0x3A, 0x80, 0x4E, 0x20, 0xB0, 0x92, 0x98, 0x54, 0x03, 0xF1, 0x05, 0x92, 0x05, 0x92, 0x85,
  0x4F, 0x10, 0x1F, 0x42, 0x0B, 0x09, 0x20, 0x50, 0xE3, 0x0B, 0x08,
  // ")" (U+0029)
  0x05, 0x0D, 0x30, 0xC0, 0x82, 0x06, 0x0E, 0x28, 0x11, 0xF3, 0x20, 0xE0, 0x62, 0x0C, 0x08, 0x20,
  0xC0, 0x82, 0x87, 0xD7, 0x01, 0xF4, 0x05, 0xE2, 0x83, 0xC8, 0x05, 0xD2,
  // "*" (U+002A)
  0x20, 0x70, 0xC2, 0x89, 0x71, 0x35, 0xA1, 0x36, 0xFE, 0xEF, 0xB0, 0x1D, 0xE4, 0x28, 0x90, 0x9B,
  0x6D, 0x10, 0x22, 0x05, 0x10,
  // "+" (U+002B)
  0x20, 0x30, 0xE5, 0x03, 0x0E, 0x50, 0x30, 0xE3, 0x07, 0xD8, 0x53, 0x12, 0x5E, 0x22, 0x30, 0x30,
  0xE5, 0x03, 0x0E, 0x30,
  // "," (U+002C)
  0x18, 0x90, 0xE8, 0x0F, 0x53, 0xF1, 0x6B, 0x10,
  // "-" (U+002D)
  0x09, 0xA0, 0xA0, 0x10, 0xF2,
  // "." (U+002E)
  0x84, 0x1D, 0x61, 0xD6,
  // "/" (U+002F)
  0x30, 0x40, 0xE3, 0x00, 0x93, 0x0E, 0x04, 0x20, 0x50, 0xD3, 0x0B, 0x08, 0x28, 0x12, 0xF2, 0x20,
  0x70, 0xC3, 0x0D, 0x06, 0x28, 0x13, 0xF1, 0x20, 0x90, 0xA3,
  // "0" (U+0030)
  0x18, 0x23, 0xCF, 0xA3, 0x8A, 0x3D, 0xB4, 0xE8, 0x02, 0xF3, 0x08, 0xD0, 0x5F, 0x10, 0x5F, 0x06,
  0x92, 0x82, 0x4F, 0x16, 0x92, 0x89, 0x64, 0xF1, 0x5F, 0x10, 0x5F, 0x02, 0xF3, 0x08, 0xD2, 0x83,
  0xDB, 0x4E, 0x82, 0x82, 0x3C, 0xEA, 0x20,
  // "1" (U+0031)
  0x18, 0x95, 0x2E, 0x93, 0xEF, 0x9D, 0x8B, 0x91, 0x0C, 0x92, 0x0C, 0x09, 0x20, 0xC0, 0x92, 0x0C,
  0x09, 0x20, 0xC0, 0x92, 0x0C, 0x09, 0x20, 0xC0, 0x90,
  // "2" (U+0032)
  0x18, 0x28, 0xEE, 0xA2, 0x84, 0x2C, 0x54, 0xE8, 0x50, 0xA0, 0xB5, 0x0B, 0x0A, 0x48, 0x12, 0xF5,
  0x40, 0xB0, 0xC4, 0x81, 0x8E, 0x13, 0x81, 0x4F, 0x43, 0x86, 0x2E, 0x93, 0x33, 0x07, 0xD0, 0x10,
  // "3" (U+0033)
  0x89, 0x21, 0x9D, 0xEB, 0x12, 0xA4, 0x4D, 0xA4, 0x09, 0x0C, 0x38, 0x33, 0xE6, 0x03, 0xA0, 0x83,
  0x82, 0x36, 0xE8, 0x40, 0x89, 0x48, 0x94, 0x8E, 0x56, 0x35, 0xEA, 0x4D, 0xFE, 0x91,
  // "4" (U+0034)
  0x38, 0x15, 0xF5, 0x48, 0x1C, 0xF5, 0x38, 0x25, 0xBF, 0x53, 0x82, 0xD4, 0xF5, 0x28, 0x36, 0xB0,
  0xF5, 0x28, 0x6E, 0x30, 0xF5, 0x07, 0xB2, 0x98, 0x16, 0x0B, 0xD8, 0x68, 0x23, 0x33, 0xF7, 0x14,
  0x90, 0x51,
  // "5" (U+0035)
  0x10, 0xDB, 0x89, 0x07, 0x0E, 0x73, 0x31, 0x0F, 0x33, 0x89, 0x21, 0xFE, 0xFA, 0x10, 0x53, 0x5E,
  0xA4, 0x07, 0x0E, 0x40, 0x69, 0x48, 0x93, 0x8D, 0x37, 0x46, 0xF7, 0x2C, 0xFE, 0x81,
  // "6" (U+0036)
  0x28, 0x27, 0xDF, 0x82, 0x83, 0x7E, 0x63, 0x22, 0x0E, 0x05, 0x48, 0xB7, 0x2F, 0x7E, 0xD2, 0x04,
  0xFA, 0x3C, 0xC0, 0x5F, 0x20, 0x5F, 0x04, 0xF1, 0x03, 0xF2, 0x2F, 0x40, 0x59, 0x28, 0x3C, 0xC4,
  0xCB, 0x28, 0x32, 0xCF, 0xB1, 0x10,
  // "7" (U+0037)
  0x08, 0xD8, 0x52, 0x13, 0x33, 0x8E, 0x50, 0xB0, 0x94, 0x81, 0x2F, 0x44, 0x07, 0x0D, 0x50, 0xD0,
  0x84, 0x81, 0x4F, 0x24, 0x09, 0x0C, 0x50, 0xE0, 0x74, 0x81, 0x6F, 0x13,
  // "8" (U+0038)
  0x18, 0xA1, 0x4D, 0xEB, 0x20, 0x1F, 0x93, 0xCB, 0x02, 0xF2, 0x06, 0xE2, 0x83, 0xD9, 0x0C, 0x92,
  0x82, 0x3E, 0xEB, 0x38, 0x95, 0x9D, 0x9E, 0x40, 0x4F, 0x20, 0x7E, 0x06, 0xE2, 0x87, 0x3F, 0x23,
  0xF7, 0x3A, 0xE2, 0x83, 0x6D, 0xEC, 0x31,
  // "9" (U+0039)
  0x18, 0x92, 0x5D, 0xE9, 0x01, 0xF8, 0x4E, 0x76, 0x92, 0x81, 0x7D, 0x69, 0x28, 0x90, 0x6F, 0x3F,
  0x51, 0xBF, 0x0A, 0xA0, 0x90, 0xE2, 0x82, 0x11, 0x7D, 0x48, 0x93, 0xC9, 0x04, 0x39, 0xE2, 0x0D,
  0xFC, 0x31,
  // ":" (U+003A)
  0x82, 0xE6, 0xE7, 0x71, 0x82, 0xD7, 0xD6,
  // ";" (U+003B)
  0x18, 0x3E, 0x60, 0xE7, 0x76, 0x89, 0x0E, 0x81, 0xF4, 0x3F, 0x06, 0xB1,
  // "<" (U+003C)
  0x48, 0x16, 0xD3, 0x28, 0x75, 0xDC, 0x50, 0x3D, 0xC4, 0x38, 0x24, 0xDB, 0x45, 0x82, 0x6D, 0xC5,
  0x58, 0x16, 0xD3,
  // "=" (U+003D)
  0x07, 0xD0, 0x30, 0x18, 0x01, 0x27, 0x10, 0x7D, 0x03, 0x01, 0x80, 0x12, 0x10,
  // ">" (U+003E)
  0x01, 0x68, 0x17, 0xB4, 0x58, 0x27, 0xEB, 0x35, 0x82, 0x6D, 0xB1, 0x38, 0x76, 0xDC, 0x10, 0x7D,
  0xC4, 0x28, 0x17, 0xC4, 0x40, 0x16,
  // "?" (U+003F)
  0x89, 0x06, 0xDE, 0xB2, 0x65, 0x3C, 0xA3, 0x08, 0x0C, 0x30, 0xD0, 0x82, 0x0A, 0x0C, 0x28, 0x14,
  0xE1, 0x20, 0x50, 0x97, 0x10, 0x80, 0xD3, 0x08, 0x0C, 0x20,
  // "@" (U+0040)
  0x38, 0x37, 0xDF, 0xD7, 0x48, 0x5B, 0xC5, 0x36, 0xD9, 0x28, 0xF6, 0x7C, 0x1A, 0xEC, 0x3E, 0x30,
  0xE4, 0x9B, 0x4F, 0x28, 0x82, 0xE0, 0xD4, 0x0F, 0x16, 0xA4, 0xC0, 0xE2, 0x1F, 0x16, 0x94, 0xC0,
  0xC6, 0x6E, 0x3B, 0x62, 0xE0, 0x6F, 0xD6, 0xFD, 0x10, 0xD6, 0x01, 0x20, 0x23, 0x85, 0x6F, 0x61,
  0x13, 0x34, 0x06, 0x0E, 0xA0, 0xE0, 0x56, 0x00, 0x24,
  // "A" (U+0041)
  0x28, 0x14, 0xFA, 0x58, 0x19, 0xEE, 0x58, 0x2D, 0x8F, 0x33, 0x83, 0x2F, 0x3D, 0x73, 0x83, 0x6E,
  0x09, 0xC3, 0x84, 0xBB, 0x16, 0xF1, 0x2D, 0x89, 0x25, 0x04, 0xF6, 0x44, 0xDA, 0x09, 0xE3, 0x83,
  0x9E, 0x0D, 0xA3, 0x81, 0x4F, 0x30,
  // "B" (U+0042)
  0x0E, 0xA8, 0x91, 0xE9, 0x0E, 0x93, 0x6F, 0x8E, 0x82, 0x87, 0xBA, 0xE8, 0x03, 0xE6, 0xEB, 0x89,
  0x0A, 0x0E, 0x93, 0x5E, 0x8E, 0x82, 0x82, 0x9D, 0xE8, 0x28, 0x79, 0xDE, 0x93, 0x5E, 0x9E, 0xA0,
  0xE0, 0x91,
  // "C" (U+0043)
  0x28, 0x95, 0x5C, 0xFD, 0x60, 0x4F, 0x93, 0x64, 0x0C, 0xB4, 0x81, 0x1F, 0x64, 0x81, 0x3F, 0x44,
  0x81, 0x3F, 0x44, 0x81, 0x2F, 0x55, 0x0D, 0x0B, 0x58, 0x46, 0xF9, 0x45, 0x32, 0x83, 0x6D, 0xFD,
  0x50,
  // "D" (U+0044)
  0x0E, 0xA0, 0xD0, 0x82, 0x87, 0xE9, 0x37, 0xFA, 0x0E, 0x82, 0x83, 0x6F, 0x2E, 0x82, 0x83, 0x1F,
  0x6E, 0x83, 0x98, 0x18, 0xE8, 0x39, 0x81, 0x7E, 0x82, 0x83, 0x2F, 0x6E, 0x82, 0x89, 0x17, 0xF1,
  0xE9, 0x37, 0xF9, 0x0E, 0xA0, 0xD0, 0x72,
  // "E" (U+0045)
  0x0E, 0xB8, 0x6A, 0xE9, 0x33, 0x2E, 0x83, 0x0E, 0x08, 0x30, 0xEB, 0x86, 0x7E, 0x92, 0x21, 0xE8,
  0x30, 0xE0, 0x83, 0x84, 0xE9, 0x33, 0x2E, 0xB0, 0xA0,
  // "F" (U+0046)
  0x0E, 0xB8, 0x6A, 0xE9, 0x33, 0x2E, 0x83, 0x0E, 0x08, 0x30, 0xEB, 0x86, 0x7E, 0x92, 0x21, 0xE8,
  0x30, 0xE0, 0x83, 0x0E, 0x08, 0x30, 0xE0, 0x83,
  // "G" (U+0047)
  0x28, 0x97, 0x3B, 0xEE, 0xB3, 0x03, 0xFB, 0x44, 0x72, 0x0C, 0xC5, 0x81, 0x1F, 0x65, 0x83, 0x3F,
  0x40, 0x5A, 0x89, 0x29, 0x3F, 0x30, 0x12, 0xC9, 0x1F, 0x53, 0x83, 0xB9, 0x0D, 0xB3, 0x89, 0x0B,
  0x90, 0x5F, 0x93, 0x4D, 0x92, 0x84, 0x5C, 0xFE, 0xC6,
  // "H" (U+0048)
  0x0E, 0x08, 0x39, 0x81, 0x6E, 0x83, 0x98, 0x16, 0xE8, 0x39, 0x81, 0x6E, 0x83, 0x90, 0x60, 0xED,
  0x89, 0x06, 0xE9, 0x22, 0x3F, 0x6E, 0x83, 0x98, 0x16, 0xE8, 0x39, 0x81, 0x6E, 0x83, 0x98, 0x16,
  0xE8, 0x39, 0x06,
  // "I" (U+0049)
  0x08, 0xA8, 0x6D, 0x09, 0xE1, 0x08, 0xD2, 0x08, 0x0D, 0x20, 0x80, 0xD2, 0x08, 0x0D, 0x20, 0x80,
  0xD2, 0x08, 0x0D, 0x28, 0x28, 0xD0, 0x7A, 0x0C,
  // "J" (U+004A)
  0x20, 0xE0, 0x72, 0x0E, 0x07, 0x20, 0xE0, 0x72, 0x0E, 0x07, 0x20, 0xE0, 0x72, 0x0E, 0x07, 0x20,
  0xE0, 0x72, 0x0E, 0x07, 0x20, 0xE0, 0x72, 0x0E, 0x07, 0x29, 0x89, 0x16, 0x04, 0xF4, 0xCF, 0xB0,
  0x11, 0x20,
  // "K" (U+004B)
  0x0E, 0x08, 0x28, 0x95, 0xBC, 0x0E, 0x80, 0x5F, 0x30, 0xE8, 0x1E, 0x82, 0x82, 0xE8, 0x9D, 0x38,
  0x2E, 0xBF, 0x63, 0x82, 0xEF, 0xDC, 0x38, 0x3E, 0x83, 0xF5, 0x28, 0x3E, 0x80, 0xAD, 0x28, 0x7E,
  0x80, 0x2F, 0x70, 0xE8, 0x28, 0x19, 0xE1,
  // "L" (U+004C)
  0x0E, 0x08, 0x30, 0xE0, 0x83, 0x0E, 0x08, 0x30, 0xE0, 0x83, 0x0E, 0x08, 0x30, 0xE0, 0x83, 0x0E,
  0x08, 0x30, 0xE0, 0x83, 0x84, 0xEA, 0x44, 0x3E, 0xB0, 0xB0,
  // "M" (U+004D)
  0x81, 0xEF, 0x43, 0x03, 0xA8, 0x1E, 0xF8, 0x30, 0x7A, 0x81, 0xEC, 0xD3, 0x8F, 0x7C, 0xCF, 0xE8,
  0xF2, 0x01, 0xF8, 0xFE, 0x6C, 0x70, 0x6C, 0x6F, 0xE6, 0x7C, 0x0B, 0x76, 0xFE, 0x63, 0xF2, 0xF2,
  0x6F, 0xE6, 0x0D, 0xBD, 0x06, 0xFE, 0x60, 0x9F, 0x80, 0x6F, 0xE6, 0x04, 0xF3, 0x06, 0x90,
  // "N" (U+004E)
  0x81, 0xEE, 0x12, 0x83, 0x6E, 0xEF, 0x82, 0x8D, 0x46, 0xEE, 0xCE, 0x10, 0x6E, 0xE7, 0xE7, 0x06,
  0xEE, 0x67, 0xE0, 0x6E, 0xE6, 0x1E, 0x76, 0xEE, 0x60, 0x8E, 0x6E, 0xE6, 0x01, 0xEC, 0xEE, 0x62,
  0x83, 0x8F, 0xEE, 0x62, 0x81, 0x1E, 0xE0,
  // "O" (U+004F)
  0x28, 0x37, 0xDF, 0xC4, 0x28, 0x90, 0x7F, 0x74, 0x9F, 0x30, 0xEA, 0x38, 0x3C, 0xA2, 0xF5, 0x38,
  0x38, 0xE3, 0xF4, 0x38, 0x36, 0xF3, 0xF3, 0x38, 0x37, 0xF1, 0xF5, 0x38, 0x38, 0xE0, 0xDA, 0x38,
  0x90, 0xDA, 0x06, 0xF7, 0x49, 0xF3, 0x28, 0x36, 0xDF, 0xC4, 0x10,
  // "P" (U+0050)
  0x0E, 0xA8, 0x91, 0xC5, 0x0E, 0x93, 0x9F, 0x3E, 0x82, 0x98, 0x17, 0xE8, 0x29, 0x86, 0x7E, 0x81,
  0x7F, 0x3E, 0xB8, 0x36, 0x0E, 0x92, 0x30, 0xE0, 0x84, 0x0E, 0x08, 0x40, 0xE0, 0x84,
  // "Q" (U+0051)
  0x28, 0x37, 0xDF, 0xC5, 0x38, 0x57, 0xF7, 0x49, 0xF4, 0x20, 0xE0, 0xA3, 0x84, 0xCB, 0x02, 0xF5,
  0x38, 0x48, 0xE0, 0x3F, 0x43, 0x84, 0x6F, 0x13, 0xF3, 0x38, 0x47, 0xF0, 0x1F, 0x53, 0x08, 0x0E,
  0x20, 0xD0, 0xA3, 0x0D, 0x0A, 0x28, 0x56, 0xF7, 0x49, 0xF3, 0x30, 0x60, 0xDA, 0x05, 0x68, 0x11,
  0xF7, 0x78, 0x18, 0xF2, 0x70, 0x70, 0x41,
  // "R" (U+0052)
  0x0E, 0xA8, 0x91, 0xC5, 0x0E, 0x93, 0x9F, 0x3E, 0x82, 0x98, 0x17, 0xE8, 0x28, 0x7E, 0x7E, 0x80,
  0x7F, 0x3E, 0xB8, 0xA4, 0x60, 0xE9, 0x4F, 0x40, 0xE8, 0x0A, 0xC0, 0xE8, 0x02, 0xF5, 0xE8, 0x20,
  0xA0, 0xD0,
  // "S" (U+0053)
  0x18, 0x94, 0x4D, 0xFD, 0x71, 0xF9, 0x36, 0x55, 0xF2, 0x38, 0x13, 0xF7, 0x48, 0x29, 0xFC, 0x33,
  0x82, 0x4D, 0xF4, 0x40, 0x0C, 0x48, 0x93, 0x9D, 0x47, 0x35, 0xE8, 0x4D, 0xFE, 0x91,
  // "T" (U+0054)
  0x0C, 0xD8, 0x51, 0x23, 0xAD, 0x33, 0x30, 0x90, 0xC5, 0x09, 0x0C, 0x50, 0x90, 0xC5, 0x09, 0x0C,
  0x50, 0x90, 0xC5, 0x09, 0x0C, 0x50, 0x90, 0xC5, 0x09, 0x0C, 0x30,
  // "U" (U+0055)
  0x90, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F,
  0x5F, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x4D, 0x82, 0x87, 0x3F,
  0x38, 0xE5, 0x4C, 0xD2, 0x83, 0x9D, 0xEB, 0x21,
  // "V" (U+0056)
  0x0D, 0x09, 0x38, 0x27, 0xE9, 0xD3, 0x83, 0xBA, 0x4F, 0x12, 0x98, 0x94, 0x60, 0xF5, 0x04, 0xF2,
  0x0B, 0x90, 0x8D, 0x28, 0x37, 0xD0, 0xC9, 0x28, 0x33, 0xF3, 0xF4, 0x30, 0xE0, 0xA9, 0x48, 0x1A,
  0xEB, 0x48, 0x16, 0xF7, 0x20,
  // "W" (U+0057)
  0x0C, 0x09, 0x28, 0x13, 0xF5, 0x28, 0x27, 0xE9, 0xC2, 0x81, 0x6F, 0x92, 0x81, 0xAB, 0x59, 0x28,
  0x1A, 0xDC, 0x28, 0xC0, 0xD8, 0x2F, 0x30, 0xD8, 0xF0, 0x1F, 0x50, 0xE7, 0x1F, 0x2F, 0x34, 0xF1,
  0x0B, 0xA5, 0xD0, 0xB7, 0x8D, 0x28, 0x77, 0xD8, 0xA0, 0x8A, 0xBA, 0x28, 0x74, 0xFB, 0x70, 0x4D,
  0xD6, 0x3A, 0x81, 0x30, 0x1A, 0x03, 0x30, 0xC9, 0x30, 0xD9, 0x20,
  // "X" (U+0058)
  0x89, 0x37, 0xE1, 0x04, 0xF3, 0x0E, 0x60, 0xAC, 0x28, 0x38, 0xD1, 0xF4, 0x28, 0x21, 0xFC, 0xD4,
  0x81, 0x9F, 0x64, 0x81, 0xBF, 0x73, 0x82, 0x3F, 0x9E, 0x38, 0x95, 0xBA, 0x1E, 0x60, 0x3F, 0x30,
  0x9D, 0x0A, 0xC2, 0x81, 0x2F, 0x60,
  // "Y" (U+0059)
  0x0C, 0x0B, 0x28, 0x72, 0xF5, 0x5F, 0x10, 0x8D, 0x28, 0x3E, 0x70, 0xE7, 0x28, 0x38, 0xD4, 0xF1,
  0x28, 0x22, 0xFD, 0xA4, 0x81, 0xBF, 0x34, 0x07, 0x95, 0x07, 0x95, 0x07, 0x95, 0x07, 0x93,
  // "Z" (U+005A)
  0x08, 0xC8, 0x5A, 0x13, 0x34, 0xF7, 0x30, 0x70, 0xE4, 0x0E, 0x07, 0x38, 0x17, 0xE1, 0x30, 0xE0,
  0x83, 0x81, 0x6F, 0x13, 0x0D, 0x09, 0x38, 0x55, 0xF5, 0x33, 0x29, 0xC0, 0xC0,
  // "[" (U+005B)
  0xC8, 0xB5, 0x63, 0xF4, 0x0F, 0x40, 0xF4, 0x0F, 0x40, 0xF4, 0x0F, 0x40, 0xF4, 0x0F, 0x40, 0xF4,
  0x0F, 0x41, 0xB0, 0xF2,
  // "\" (U+005C)
  0x09, 0x0A, 0x30, 0x49, 0x40, 0xD0, 0x63, 0x08, 0x0B, 0x38, 0x12, 0xF2, 0x30, 0xC0, 0x73, 0x06,
  0x0D, 0x38, 0x11, 0xF3, 0x30, 0xA0, 0x93, 0x04, 0x0E,
  // "]" (U+005D)
  0x09, 0xA8, 0x36, 0x13, 0xD6, 0x20, 0xD0, 0x62, 0x0D, 0x06, 0x20, 0xD0, 0x62, 0x0D, 0x06, 0x20,
  0xD0, 0x62, 0x0D, 0x06, 0x20, 0xD0, 0x62, 0x0D, 0x06, 0x20, 0xD0, 0x62, 0x81, 0xD6, 0x9A, 0x83,
  0x61, 0x22, 0x10,
  // "^" (U+005E)
  0x28, 0x13, 0xE1, 0x48, 0x1A, 0xF7, 0x38, 0x22, 0xF5, 0xE3, 0x89, 0x59, 0xA0, 0xC7, 0x01, 0xE3,
  0x05, 0xE0, 0x7B, 0x30, 0xD0, 0x60,
  // "_" (U+005F)
  0xE0, 0x38, 0x02, 0x21,
  // "`" (U+0060)
  0x81, 0x27, 0x22, 0x0C, 0x0A, 0x28, 0x11, 0xD3,
  // "a" (U+0061)
  0x18, 0x91, 0x6D, 0xEB, 0x10, 0x55, 0x4E, 0x74, 0x83, 0xAA, 0x07, 0xDA, 0x87, 0xA4, 0xF7, 0x3B,
  0xA7, 0xE2, 0x89, 0x4B, 0xA5, 0xF5, 0x6E, 0xA0, 0xAE, 0xA7, 0xA0,
  // "b" (U+0062)
  0x90, 0x54, 0x90, 0x54, 0x90, 0x54, 0x98, 0x93, 0x7D, 0xE7, 0x0F, 0xD4, 0x8F, 0x2F, 0x72, 0x82,
  0xE7, 0xF5, 0x28, 0x2C, 0x9F, 0x52, 0x82, 0xC9, 0xF7, 0x28, 0x93, 0xE7, 0xFD, 0x48, 0xF2, 0xF5,
  0xDE, 0x71,
  // "c" (U+0063)
  0x18, 0x94, 0x2C, 0xFD, 0x10, 0xCB, 0x46, 0x03, 0xF3, 0x38, 0x15, 0xF1, 0x38, 0x15, 0xF1, 0x38,
  0x13, 0xF3, 0x48, 0x91, 0xEB, 0x46, 0x10, 0x3C, 0xEC, 0x10,
  // "d" (U+0064)
  0x48, 0x11, 0xF4, 0x48, 0x11, 0xF4, 0x48, 0xF1, 0x1F, 0x40, 0x4D, 0xE6, 0xF4, 0x0E, 0xB4, 0xBF,
  0x43, 0xF3, 0x03, 0xF4, 0x5F, 0x10, 0x1F, 0x45, 0xF1, 0x01, 0xF4, 0x3F, 0x30, 0x3F, 0x40, 0xEB,
  0x4B, 0xF4, 0x04, 0xDE, 0x5E, 0x40,
  // "e" (U+0065)
  0x18, 0xA0, 0x3C, 0xFB, 0x10, 0xDA, 0x4C, 0xA3, 0xF1, 0x05, 0xE5, 0xD8, 0x75, 0xF3, 0x22, 0x23,
  0xF3, 0x48, 0x91, 0xCC, 0x44, 0x60, 0x2B, 0xFE, 0x70,
  // "f" (U+0066)
  0x18, 0x92, 0x3D, 0xE5, 0x0A, 0xC3, 0x10, 0xC8, 0x20, 0x9A, 0x84, 0xE0, 0x2D, 0x93, 0x20, 0xD0,
  0x83, 0x0D, 0x08, 0x30, 0xD0, 0x83, 0x0D, 0x08, 0x30, 0xD0, 0x83, 0x0D, 0x08, 0x20,
  // "g" (U+0067)
  0x18, 0xE5, 0x4D, 0xE5, 0xE4, 0x0D, 0xB4, 0xBF, 0x43, 0xF3, 0x03, 0xF4, 0x5F, 0x10, 0x1F, 0x45,
  0xF1, 0x01, 0xF4, 0x3F, 0x30, 0x3F, 0x40, 0xEB, 0x4B, 0xF4, 0x04, 0xEE, 0x6F, 0x44, 0x87, 0x2F,
  0x20, 0x74, 0x3B, 0xD2, 0x83, 0xAE, 0xEB, 0x21,
  // "h" (U+0068)
  0x90, 0x54, 0x90, 0x54, 0x90, 0x54, 0x98, 0xD5, 0x8D, 0xE7, 0x0F, 0xD4, 0x8F, 0x1F, 0x70, 0x1F,
  0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F, 0x40,
  // "i" (U+0069)
  0x81, 0xE4, 0x23, 0x98, 0x95, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x50,
  // "j" (U+006A)
  0x20, 0xE0, 0x42, 0x02, 0x79, 0x05, 0x29, 0x05, 0x29, 0x05, 0x29, 0x05, 0x29, 0x05, 0x29, 0x05,
  0x29, 0x05, 0x29, 0x05, 0x29, 0x86, 0x51, 0x6F, 0x35, 0xFA, 0x10,
  // "k" (U+006B)
  0x90, 0x54, 0x90, 0x54, 0x90, 0x54, 0x98, 0x95, 0x50, 0x8D, 0x0F, 0x53, 0xF4, 0x0F, 0x5D, 0x82,
  0x98, 0x1C, 0xF3, 0x29, 0x81, 0xDC, 0xA2, 0x98, 0x97, 0x54, 0xF2, 0x0F, 0x50, 0xCA, 0x0F, 0x50,
  0x5F, 0x20,
  // "l" (U+006C)
  0x98, 0xA3, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x50,
  // "m" (U+006D)
  0x98, 0x98, 0x55, 0xDE, 0x56, 0xED, 0x3F, 0xD4, 0xAF, 0xB4, 0xDB, 0xF7, 0x04, 0xF4, 0x07, 0xDF,
  0x50, 0x3F, 0x20, 0x7E, 0xF5, 0x03, 0xF1, 0x07, 0xEF, 0x50, 0x3F, 0x10, 0x7E, 0xF5, 0x03, 0xF1,
  0x07, 0xEF, 0x50, 0x3F, 0x10, 0x7E,
  // "n" (U+006E)
  0x98, 0xD5, 0x5D, 0xE7, 0x0F, 0xD4, 0x8F, 0x1F, 0x70, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F,
  0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F, 0x40,
  // "o" (U+006F)
  0x18, 0x32, 0xCF, 0xC2, 0x28, 0x96, 0xDB, 0x4A, 0xD0, 0x3F, 0x30, 0x2F, 0x35, 0xF1, 0x29, 0x82,
  0x55, 0xF1, 0x29, 0x89, 0x46, 0x3F, 0x30, 0x2F, 0x30, 0xDB, 0x4A, 0xD2, 0x83, 0x2C, 0xFC, 0x21,
  // "p" (U+0070)
  0x98, 0x93, 0x5D, 0xE7, 0x0F, 0xD4, 0x8F, 0x2F, 0x72, 0x82, 0xE7, 0xF5, 0x28, 0x2C, 0x9F, 0x52,
  0x82, 0xC9, 0xF7, 0x28, 0x96, 0xE7, 0xFD, 0x48, 0xF2, 0xF7, 0xDE, 0x70, 0xF5, 0x49, 0x05, 0x49,
  0x05, 0x40,
  // "q" (U+0071)
  0x18, 0xE5, 0x4D, 0xE5, 0xE4, 0x0D, 0xB4, 0xBF, 0x43, 0xF3, 0x03, 0xF4, 0x5F, 0x10, 0x1F, 0x45,
  0xF1, 0x01, 0xF4, 0x3F, 0x30, 0x3F, 0x40, 0xEB, 0x4B, 0xF4, 0x04, 0xDE, 0x6F, 0x44, 0x81, 0x1F,
  0x44, 0x81, 0x1F, 0x44, 0x81, 0x1F, 0x40,
  // "r" (U+0072)
  0x98, 0x74, 0xDA, 0xFD, 0x52, 0xF8, 0x29, 0x05, 0x29, 0x05, 0x29, 0x05, 0x29, 0x05, 0x29, 0x05,
  0x20,
  // "s" (U+0073)
  0x18, 0x92, 0x9E, 0xE8, 0x5E, 0x55, 0x56, 0xE1, 0x28, 0x21, 0xDE, 0x63, 0x81, 0x8F, 0x83, 0x89,
  0x27, 0xE5, 0x63, 0xBC, 0x5D, 0xFC, 0x30,
  // "t" (U+0074)
  0x10, 0x40, 0x32, 0x82, 0xB6, 0x08, 0xB8, 0x52, 0xF8, 0x30, 0xF6, 0x29, 0x06, 0x29, 0x06, 0x29,
  0x06, 0x28, 0x5D, 0xA3, 0x06, 0xED,
  // "u" (U+0075)
  0x8E, 0x61, 0xF4, 0x01, 0xF4, 0x1F, 0x40, 0x1F, 0x41, 0xF4, 0x01, 0xF4, 0x1F, 0x40, 0x1F, 0x41,
  0xF4, 0x01, 0xF4, 0x0F, 0x50, 0x3F, 0x40, 0xDA, 0x2A, 0xF4, 0x04, 0xDD, 0x6D, 0x40,
  // "v" (U+0076)
  0x0C, 0x09, 0x28, 0x28, 0xD8, 0xD2, 0x89, 0x2C, 0x94, 0xF1, 0x0F, 0x40, 0xE5, 0x49, 0x28, 0x2B,
  0x98, 0xB2, 0x82, 0x6C, 0xC7, 0x28, 0x22, 0xFE, 0x33, 0x0D, 0x0E, 0x20,
  // "w" (U+0077)
  0x84, 0xB9, 0x01, 0xFA, 0x29, 0x8B, 0x44, 0x8C, 0x04, 0xED, 0x03, 0xF1, 0x5F, 0x08, 0xAF, 0x17,
  0xD0, 0x1F, 0x3B, 0x6D, 0x4A, 0x92, 0x86, 0xD6, 0xE2, 0xA7, 0xD6, 0x28, 0x6A, 0xAE, 0x07, 0xBF,
  0x22, 0x85, 0x7E, 0xB0, 0x4E, 0xE3, 0x81, 0x3F, 0x82, 0x90, 0xB2,
  // "x" (U+0078)
  0x89, 0x77, 0xE1, 0x0D, 0x90, 0xE7, 0x5F, 0x20, 0x7D, 0xC9, 0x38, 0x1E, 0xF2, 0x20, 0x1A, 0x02,
  0x28, 0x93, 0x9C, 0xBA, 0x01, 0xF5, 0x4F, 0x38, 0xD2, 0x0C, 0x0A,
  // "y" (U+0079)
  0x0C, 0x09, 0x28, 0x28, 0xD7, 0xE2, 0x89, 0x3C, 0x82, 0xF2, 0x1F, 0x40, 0xD7, 0x5E, 0x28, 0x28,
  0xB9, 0xA2, 0x82, 0x4E, 0xD6, 0x38, 0x1E, 0xF1, 0x30, 0xA0, 0xC4, 0x0D, 0x08, 0x28, 0x23, 0x8F,
  0x22, 0x81, 0xAE, 0x63,
  // "z" (U+007A)
  0x07, 0xB8, 0x4A, 0x13, 0x3F, 0x62, 0x07, 0x0E, 0x30, 0xE0, 0x72, 0x81, 0x6E, 0x12, 0x0D, 0x08,
  0x28, 0x45, 0xF4, 0x32, 0x9B, 0x0C,
  // "{" (U+007B)
  0x28, 0x14, 0xC9, 0x28, 0x1D, 0xA2, 0x29, 0x04, 0x39, 0x04, 0x39, 0x04, 0x28, 0x56, 0xF2, 0x08,
  0xF6, 0x28, 0x21, 0x8E, 0x12, 0x81, 0x1F, 0x43, 0x90, 0x43, 0x90, 0x43, 0x0E, 0x08, 0x38, 0x16,
  0xF9, 0x40, 0x10,
  // "|" (U+007C)
  0x8B, 0x27, 0xB7, 0xB7, 0xB7, 0xB7, 0xB7, 0xB7, 0xB7, 0xB7, 0xB7, 0xB7, 0xB7, 0xB7, 0xB7, 0xB0,
  // "}" (U+007D)
  0x81, 0x7D, 0x52, 0x82, 0x19, 0xF1, 0x28, 0x12, 0xF3, 0x28, 0x11, 0xF3, 0x28, 0x11, 0xF3, 0x30,
  0xE0, 0x83, 0x81, 0x5E, 0xA2, 0x85, 0xDA, 0x20, 0x1F, 0x32, 0x81, 0x1F, 0x32, 0x81, 0x2F, 0x32,
  0x85, 0x6F, 0x10, 0x7F, 0x82, 0x00, 0x13,
  // "~" (U+007E)
  0x89, 0x43, 0xDE, 0x71, 0x43, 0x75, 0x5C, 0xFD, 0x14, 0x02, 0x20,
  // "¡" (U+00A1)
  0x82, 0xD6, 0xD7, 0x28, 0x94, 0xC4, 0xD5, 0xD5, 0xE6, 0xF7, 0xF7, 0xF8,
  // "¢" (U+00A2)
  0x20, 0xA0, 0x32, 0x89, 0x18, 0xED, 0x67, 0xE4, 0x32, 0xC9, 0x30, 0xE0, 0x73, 0x0D, 0x08, 0x30,
  0xB0, 0xD2, 0x89, 0x11, 0x3F, 0xEE, 0x90, 0x2C, 0x81, 0x20, 0xA0, 0x31,
  // "£" (U+00A3)
  0x28, 0x27, 0xEE, 0xA2, 0x83, 0x3F, 0x74, 0x62, 0x05, 0x95, 0x05, 0x94, 0x06, 0xC8, 0x51, 0x01,
  0x7F, 0x32, 0x30, 0x59, 0x50, 0x70, 0xE4, 0x86, 0x1D, 0x93, 0x33, 0x06, 0xD0, 0x30,
  // "¤" (U+00A4)
  0x10, 0x24, 0x8A, 0x02, 0x1E, 0x9E, 0xD9, 0xC0, 0x7D, 0x45, 0xE4, 0x0B, 0x42, 0x83, 0x77, 0x0B,
  0x32, 0x89, 0x26, 0x80, 0x7B, 0x13, 0xD4, 0x1D, 0xBA, 0x87, 0xCB, 0x04, 0x01, 0x10, 0x40,
  // "¥" (U+00A5)
  0x07, 0x0E, 0x28, 0x74, 0xF2, 0x1F, 0x40, 0x9B, 0x28, 0x3A, 0xA0, 0xE5, 0x28, 0x24, 0xE5, 0xE4,
  0x81, 0xDE, 0x82, 0x01, 0xC0, 0xB3, 0x05, 0x93, 0x01, 0xC0, 0xB2, 0x83, 0x27, 0xF3, 0x23, 0x05,
  0x93,
  // "¦" (U+00A6)
  0x89, 0x27, 0xB7, 0xB7, 0xB7, 0xB7, 0xB7, 0xB6, 0x89, 0x07, 0xB7, 0xB7, 0xB7, 0xB7, 0xB0,
  // "§" (U+00A7)
  0x18, 0x94, 0x7E, 0xEA, 0x02, 0xF5, 0x46, 0x01, 0xF3, 0x48, 0x93, 0x9F, 0x91, 0x02, 0xE4, 0xBD,
  0x04, 0xD2, 0x98, 0x41, 0x0C, 0xC8, 0xC3, 0x81, 0x7E, 0x84, 0x89, 0x43, 0xF0, 0x46, 0x38, 0xE0,
  0x2C, 0xFD, 0x41,
  // "¨" (U+00A8)
  0x87, 0x1E, 0x19, 0x70, 0x10, 0x11,
  // "©" (U+00A9)
  0x38, 0x46, 0xCF, 0xEA, 0x34, 0x86, 0xBC, 0x63, 0x48, 0xE5, 0x20, 0x80, 0xA5, 0x8A, 0x43, 0xE2,
  0x0E, 0x10, 0x8E, 0xE8, 0x06, 0x93, 0xA0, 0x6D, 0x53, 0x32, 0x84, 0xD5, 0x80, 0xB7, 0x58, 0x4D,
  0x49, 0x0B, 0x65, 0x89, 0x7D, 0x1D, 0x08, 0xC2, 0x02, 0x05, 0xA0, 0x98, 0x1B, 0xA8, 0x94, 0x81,
  0xD3, 0x01, 0xDA, 0x32, 0x35, 0xD8, 0x30, 0x10, 0x9B, 0x0D, 0x06, 0x70, 0x20, 0x14,
  // "ª" (U+00AA)
  0x89, 0x61, 0xAC, 0x82, 0xAB, 0xD9, 0x73, 0xE4, 0xD9, 0xC0,
  // "«" (U+00AB)
  0x28, 0xA7, 0x52, 0x06, 0x10, 0x3F, 0x36, 0xE1, 0x1E, 0x83, 0xF5, 0x05, 0xF3, 0x8F, 0x12, 0x83,
  0xAC, 0x0C, 0xA3, 0x83, 0xD5, 0x1E, 0x30,
  // "¬" (U+00AC)
  0x07, 0xD8, 0x62, 0x12, 0x22, 0x2F, 0x25, 0x90, 0x25, 0x90, 0x25, 0x02, 0x10,
  // "®" (U+00AE)
  0x38, 0x46, 0xCF, 0xEA, 0x34, 0x86, 0xBC, 0x63, 0x48, 0xE5, 0x20, 0x80, 0xA5, 0x85, 0x3E, 0x20,
  0xE1, 0x1A, 0x89, 0x3E, 0x60, 0x69, 0x3A, 0x01, 0xF3, 0x9C, 0x28, 0x3D, 0x58, 0x01, 0xB0, 0x42,
  0x87, 0xD4, 0x90, 0x1F, 0x3E, 0x22, 0x8B, 0x7D, 0x1D, 0x01, 0xF0, 0x7A, 0x05, 0xA0, 0x98, 0x19,
  0x01, 0x92, 0xD3, 0x01, 0xDA, 0x30, 0x15, 0xD8, 0x30, 0x10, 0x9B, 0x0D, 0x06, 0x70, 0x20, 0x14,
  // "¯" (U+00AF)
  0xE0, 0x88, 0x02, 0x20, 0x10,
  // "°" (U+00B0)
  0x18, 0xA1, 0x9E, 0xC2, 0x4C, 0x49, 0xA4, 0xB1, 0x6A, 0x0C, 0xFE, 0x32, 0x02, 0x20,
  // "±" (U+00B1)
  0x20, 0x30, 0xE5, 0x03, 0x0E, 0x50, 0x30, 0xE3, 0x07, 0xD8, 0x53, 0x12, 0x5E, 0x22, 0x30, 0x30,
  0xE5, 0x03, 0x0E, 0x30, 0x18, 0x01, 0x31, 0x07, 0xD0, 0x30,
  // "²" (U+00B2)
  0x86, 0x3C, 0xE7, 0x22, 0x4E, 0x28, 0x91, 0x6A, 0x03, 0xD1, 0x2D, 0x20, 0x90, 0xFE,
  // "³" (U+00B3)
  0x89, 0x24, 0xDE, 0x71, 0x14, 0xD0, 0xBF, 0x52, 0x89, 0x02, 0xE3, 0x02, 0xF7, 0xED, 0x60,
  // "´" (U+00B4)
  0x18, 0x90, 0x27, 0x20, 0xAC, 0x03, 0xD1, 0x10,
  // "µ" (U+00B5)
  0x98, 0xD7, 0x50, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F,
  0x4F, 0x60, 0x3F, 0x4F, 0xC4, 0xBF, 0x4F, 0xCE, 0x6D, 0x4F, 0x54, 0x90, 0x54, 0x90, 0x54,
  // "¶" (U+00B6)
  0x10, 0x30, 0xDB, 0x81, 0x50, 0xDA, 0x82, 0x89, 0x52, 0xB8, 0x27, 0x85, 0x3B, 0x82, 0x78, 0x53,
  0xB8, 0x27, 0x85, 0x1B, 0x83, 0x78, 0x50, 0xBA, 0x81, 0x78, 0x52, 0x83, 0x6A, 0x78, 0x53, 0x82,
  0x67, 0x85, 0x38, 0x26, 0x78, 0x53, 0x82, 0x67, 0x85, 0x38, 0x26, 0x78, 0x53, 0x82, 0x67, 0x85,
  0x38, 0x00, 0x10,
  // "·" (U+00B7)
  0x84, 0x1D, 0x61, 0xD6,
  // "¸" (U+00B8)
  0x89, 0x21, 0x50, 0x3C, 0x44, 0xB9, 0xDC, 0x30,
  // "¹" (U+00B9)
  0x18, 0x55, 0xE4, 0x3C, 0xD4, 0x20, 0xC0, 0x42, 0x0C, 0x04, 0x20, 0xC0, 0x42, 0x0C, 0x04,
  // "º" (U+00BA)
  0x8A, 0x61, 0xBC, 0x80, 0x69, 0x0D, 0x28, 0x70, 0xB4, 0x69, 0x0D, 0x20, 0x9B, 0x61,
  // "»" (U+00BB)
  0x83, 0x26, 0x03, 0x52, 0x84, 0x1E, 0x53, 0xF3, 0x28, 0xA7, 0x6E, 0x28, 0xD1, 0x01, 0xF7, 0x4F,
  0x40, 0xBB, 0x0D, 0x90, 0x3E, 0x16, 0xC2,
  // "¼" (U+00BC)
  0x18, 0x16, 0xF2, 0x30, 0xC0, 0x52, 0x82, 0x5B, 0xE2, 0x20, 0x40, 0xC5, 0x0E, 0x02, 0x20, 0xC0,
  0x45, 0x83, 0xE2, 0x05, 0xB6, 0x86, 0xE2, 0x0D, 0x30, 0xD8, 0x38, 0x6E, 0x27, 0xA0, 0x6D, 0x85,
  0x84, 0xE2, 0x1B, 0x88, 0x48, 0x57, 0x90, 0x94, 0x88, 0x38, 0x71, 0xE1, 0x0D, 0xEF, 0xE4, 0x20,
  0x90, 0x84, 0x00, 0x81,
  // "½" (U+00BD)
  0x18, 0x16, 0xF1, 0x28, 0x11, 0xE2, 0x28, 0x26, 0xBE, 0x12, 0x08, 0x09, 0x58, 0x4E, 0x10, 0x1E,
  0x15, 0x83, 0xE1, 0x08, 0x86, 0x86, 0xE1, 0x1E, 0x3B, 0xE9, 0x38, 0x7E, 0x19, 0x80, 0x31, 0xF1,
  0x38, 0x12, 0xE1, 0x20, 0x30, 0xD4, 0x0A, 0x07, 0x28, 0x11, 0xD3, 0x30, 0x20, 0xE2, 0x81, 0x1C,
  0x44, 0x0A, 0x06, 0x20, 0x6B, 0x03, 0x20, 0x23, 0x01, 0x0F, 0x21,
  // "¾" (U+00BE)
  0x82, 0x3D, 0xE6, 0x30, 0x70, 0xA2, 0x82, 0x45, 0x6D, 0x30, 0xE0, 0x24, 0x05, 0x0C, 0x20, 0x70,
  0xA4, 0x81, 0xBF, 0x42, 0x0E, 0x03, 0x48, 0x42, 0x5E, 0x06, 0xB4, 0x89, 0x22, 0x12, 0xF1, 0xD3,
  0x09, 0xB0, 0x8A, 0x85, 0x96, 0xB0, 0x3C, 0xB2, 0x87, 0x11, 0x0D, 0x40, 0xB6, 0xB4, 0x85, 0x5C,
  0x05, 0x84, 0xB4, 0x86, 0xD4, 0x0A, 0xEE, 0xF7, 0x20, 0x50, 0xC4, 0x04, 0x0B, 0x10,
  // "¿" (U+00BF)
  0x20, 0xC0, 0x83, 0x0D, 0x08, 0x71, 0x09, 0x05, 0x28, 0x11, 0xE4, 0x20, 0xC0, 0xA2, 0x08, 0x0D,
  0x30, 0xC0, 0x83, 0x89, 0x0A, 0xC3, 0x66, 0x2C, 0xED, 0x60,
  // "À" (U+00C0)
  0x18, 0x12, 0x72, 0x60, 0xC0, 0xA6, 0x81, 0x1D, 0x37, 0x68, 0x14, 0xFA, 0x58, 0x19, 0xEE, 0x58,
  0x2D, 0x8F, 0x33, 0x83, 0x2F, 0x3D, 0x73, 0x83, 0x6E, 0x09, 0xC3, 0x84, 0xBB, 0x16, 0xF1, 0x2D,
  0x89, 0x25, 0x04, 0xF6, 0x44, 0xDA, 0x09, 0xE3, 0x83, 0x9E, 0x0D, 0xA3, 0x81, 0x4F, 0x30,
  // "Á" (U+00C1)
  0x48, 0x12, 0x72, 0x50, 0xA0, 0xC5, 0x81, 0x3D, 0x17, 0x58, 0x14, 0xFA, 0x58, 0x19, 0xEE, 0x58,
  0x2D, 0x8F, 0x33, 0x83, 0x2F, 0x3D, 0x73, 0x83, 0x6E, 0x09, 0xC3, 0x84, 0xBB, 0x16, 0xF1, 0x2D,
  0x89, 0x25, 0x04, 0xF6, 0x44, 0xDA, 0x09, 0xE3, 0x83, 0x9E, 0x0D, 0xA3, 0x81, 0x4F, 0x30,
  // "Â" (U+00C2)
  0x28, 0x11, 0x73, 0x58, 0x18, 0xDD, 0x48, 0x33, 0xC0, 0x88, 0x75, 0x81, 0x4F, 0xA5, 0x81, 0x9E,
  0xE5, 0x82, 0xD8, 0xF3, 0x38, 0x32, 0xF3, 0xD7, 0x38, 0x36, 0xE0, 0x9C, 0x38, 0x4B, 0xB1, 0x6F,
  0x12, 0xD8, 0x92, 0x50, 0x4F, 0x64, 0x4D, 0xA0, 0x9E, 0x38, 0x39, 0xE0, 0xDA, 0x38, 0x14, 0xF3,
  // "Ã" (U+00C3)
  0x28, 0x3D, 0xB2, 0xC1, 0x28, 0x34, 0xA7, 0xFB, 0x38, 0x21, 0x10, 0x15, 0x81, 0x4F, 0xA5, 0x81,
  0x9E, 0xE5, 0x82, 0xD8, 0xF3, 0x38, 0x32, 0xF3, 0xD7, 0x38, 0x36, 0xE0, 0x9C, 0x38, 0x4B, 0xB1,
  0x6F, 0x12, 0xD8, 0x92, 0x50, 0x4F, 0x64, 0x4D, 0xA0, 0x9E, 0x38, 0x39, 0xE0, 0xDA, 0x38, 0x14,
  0xF3,
  // "Ä" (U+00C4)
  0x18, 0x31, 0xE1, 0x97, 0x48, 0x11, 0x01, 0x58, 0x14, 0xFA, 0x58, 0x19, 0xEE, 0x58, 0x2D, 0x8F,
  0x33, 0x83, 0x2F, 0x3D, 0x73, 0x83, 0x6E, 0x09, 0xC3, 0x84, 0xBB, 0x16, 0xF1, 0x2D, 0x89, 0x25,
  0x04, 0xF6, 0x44, 0xDA, 0x09, 0xE3, 0x83, 0x9E, 0x0D, 0xA3, 0x81, 0x4F, 0x30,
  // "Å" (U+00C5)
  0x28, 0x21, 0xDE, 0x34, 0x82, 0x6A, 0x79, 0x48, 0x22, 0xEF, 0x54, 0x81, 0x4F, 0xB5, 0x81, 0x9E,
  0xE5, 0x82, 0xD8, 0xF3, 0x38, 0x32, 0xF3, 0xD7, 0x38, 0x36, 0xE0, 0x9C, 0x38, 0x4B, 0xB1, 0x6F,
  0x12, 0xD8, 0x92, 0x50, 0x4F, 0x64, 0x4D, 0xA0, 0x9E, 0x38, 0x39, 0xE0, 0xDA, 0x38, 0x14, 0xF3,
  // "Æ" (U+00C6)
  0x30, 0xAD, 0x05, 0x28, 0x61, 0xF8, 0xF6, 0x33, 0x12, 0x83, 0x6E, 0x3F, 0x45, 0x83, 0xBA, 0x2F,
  0x44, 0x82, 0x1F, 0x52, 0xC8, 0x90, 0x20, 0x7F, 0x12, 0xF6, 0x22, 0x20, 0xCC, 0x04, 0x38, 0x52,
  0xF7, 0x24, 0xF4, 0x30, 0x79, 0x28, 0x62, 0xF6, 0x33, 0x1D, 0xA2, 0x02, 0xC0, 0x50,
  // "Ç" (U+00C7)
  0x28, 0x95, 0x5C, 0xFD, 0x60, 0x4F, 0x93, 0x64, 0x0C, 0xB4, 0x81, 0x1F, 0x64, 0x81, 0x3F, 0x44,
  0x81, 0x3F, 0x44, 0x81, 0x2F, 0x55, 0x0D, 0x0B, 0x58, 0x46, 0xF9, 0x45, 0x32, 0x83, 0x6D, 0xFD,
  0x53, 0x01, 0x05, 0x58, 0x13, 0xC4, 0x48, 0x14, 0xB9, 0x48, 0x1D, 0xC3, 0x10,
  // "È" (U+00C8)
  0x81, 0x27, 0x23, 0x0C, 0x0A, 0x38, 0x11, 0xD3, 0x60, 0xEB, 0x86, 0xAE, 0x93, 0x32, 0xE8, 0x30,
  0xE0, 0x83, 0x0E, 0xB8, 0x67, 0xE9, 0x22, 0x1E, 0x83, 0x0E, 0x08, 0x38, 0x4E, 0x93, 0x32, 0xEB,
  0x0A,
  // "É" (U+00C9)
  0x28, 0x12, 0x72, 0x20, 0xA0, 0xC2, 0x81, 0x3D, 0x16, 0x0E, 0xB8, 0x6A, 0xE9, 0x33, 0x2E, 0x83,
  0x0E, 0x08, 0x30, 0xEB, 0x86, 0x7E, 0x92, 0x21, 0xE8, 0x30, 0xE0, 0x83, 0x84, 0xE9, 0x33, 0x2E,
  0xB0, 0xA0,
  // "Ê" (U+00CA)
  0x18, 0x11, 0x73, 0x28, 0x78, 0xDD, 0x03, 0xC0, 0x88, 0x50, 0xEB, 0x86, 0xAE, 0x93, 0x32, 0xE8,
  0x30, 0xE0, 0x83, 0x0E, 0xB8, 0x67, 0xE9, 0x22, 0x1E, 0x83, 0x0E, 0x08, 0x38, 0x4E, 0x93, 0x32,
  0xEB, 0x0A,
  // "Ë" (U+00CB)
  0x89, 0x11, 0xE1, 0x97, 0x01, 0x01, 0x0E, 0xB8, 0x6A, 0xE9, 0x33, 0x2E, 0x83, 0x0E, 0x08, 0x30,
  0xEB, 0x86, 0x7E, 0x92, 0x21, 0xE8, 0x30, 0xE0, 0x83, 0x84, 0xE9, 0x33, 0x2E, 0xB0, 0xA0,
  // "Ì" (U+00CC)
  0x81, 0x27, 0x22, 0x0C, 0x0A, 0x28, 0x11, 0xD3, 0x40, 0x8A, 0x86, 0xD0, 0x9E, 0x10, 0x8D, 0x20,
  0x80, 0xD2, 0x08, 0x0D, 0x20, 0x80, 0xD2, 0x08, 0x0D, 0x20, 0x80, 0xD2, 0x82, 0x8D, 0x07, 0xA0,
  0xC0,
  // "Í" (U+00CD)
  0x28, 0x12, 0x72, 0x20, 0xA0, 0xC2, 0x81, 0x3D, 0x16, 0x08, 0xA0, 0xD2, 0x81, 0x9E, 0x12, 0x08,
  0x0D, 0x30, 0x80, 0xD3, 0x08, 0x0D, 0x30, 0x80, 0xD3, 0x08, 0x0D, 0x30, 0x80, 0xD3, 0x08, 0x0D,
  0x20, 0x7A, 0x0C, 0x10,
  // "Î" (U+00CE)
  0x18, 0x11, 0x73, 0x28, 0x78, 0xDD, 0x03, 0xC0, 0x88, 0x50, 0x8A, 0x0D, 0x28, 0x19, 0xE1, 0x20,
  0x80, 0xD3, 0x08, 0x0D, 0x30, 0x80, 0xD3, 0x08, 0x0D, 0x30, 0x80, 0xD3, 0x08, 0x0D, 0x30, 0x80,
  0xD2, 0x07, 0xA0, 0xC1,
  // "Ï" (U+00CF)
  0x87, 0x1E, 0x19, 0x70, 0x10, 0x12, 0x08, 0xA0, 0xD2, 0x81, 0x9E, 0x12, 0x08, 0x0D, 0x30, 0x80,
  0xD3, 0x08, 0x0D, 0x30, 0x80, 0xD3, 0x08, 0x0D, 0x30, 0x80, 0xD3, 0x08, 0x0D, 0x20, 0x7A, 0x0C,
  // "Ð" (U+00D0)
  0x10, 0xDA, 0x0D, 0x08, 0x38, 0x4D, 0x93, 0x7F, 0x92, 0x0D, 0x08, 0x28, 0x46, 0xF2, 0x0D, 0x82,
  0x82, 0x1F, 0x6B, 0xB8, 0x61, 0x0F, 0x72, 0xE9, 0x22, 0x98, 0x27, 0x0D, 0x82, 0x84, 0x2F, 0x50,
  0xD8, 0x28, 0x90, 0x7F, 0x10, 0xD9, 0x37, 0xF9, 0x20, 0xDA, 0x0D, 0x07, 0x20,
  // "Ñ" (U+00D1)
  0x28, 0x91, 0xDB, 0x2C, 0x10, 0x4A, 0x7F, 0xB2, 0x82, 0x11, 0x01, 0x28, 0x1E, 0xE1, 0x28, 0x36,
  0xEE, 0xF8, 0x28, 0xD4, 0x6E, 0xEC, 0xE1, 0x06, 0xEE, 0x7E, 0x70, 0x6E, 0xE6, 0x7E, 0x06, 0xEE,
  0x61, 0xE7, 0x6E, 0xE6, 0x08, 0xE6, 0xEE, 0x60, 0x1E, 0xCE, 0xE6, 0x28, 0x38, 0xFE, 0xE6, 0x28,
  0x11, 0xEE,
  // "Ò" (U+00D2)
  0x28, 0x12, 0x72, 0x60, 0xC0, 0xA6, 0x81, 0x1D, 0x37, 0x58, 0x37, 0xDF, 0xC4, 0x28, 0x90, 0x7F,
  0x74, 0x9F, 0x30, 0xEA, 0x38, 0x3C, 0xA2, 0xF5, 0x38, 0x38, 0xE3, 0xF4, 0x38, 0x36, 0xF3, 0xF3,
  0x38, 0x37, 0xF1, 0xF5, 0x38, 0x38, 0xE0, 0xDA, 0x38, 0x90, 0xDA, 0x06, 0xF7, 0x49, 0xF3, 0x28,
  0x36, 0xDF, 0xC4, 0x10,
  // "Ó" (U+00D3)
  0x48, 0x12, 0x72, 0x50, 0xA0, 0xC5, 0x81, 0x3D, 0x17, 0x58, 0x37, 0xDF, 0xC4, 0x28, 0x90, 0x7F,
  0x74, 0x9F, 0x30, 0xEA, 0x38, 0x3C, 0xA2, 0xF5, 0x38, 0x38, 0xE3, 0xF4, 0x38, 0x36, 0xF3, 0xF3,
  0x38, 0x37, 0xF1, 0xF5, 0x38, 0x38, 0xE0, 0xDA, 0x38, 0x90, 0xDA, 0x06, 0xF7, 0x49, 0xF3, 0x28,
  0x36, 0xDF, 0xC4, 0x10,
  // "Ô" (U+00D4)
  0x38, 0x11, 0x73, 0x58, 0x18, 0xDD, 0x48, 0x33, 0xC0, 0x88, 0x74, 0x83, 0x7D, 0xFC, 0x42, 0x89,
  0x07, 0xF7, 0x49, 0xF3, 0x0E, 0xA3, 0x83, 0xCA, 0x2F, 0x53, 0x83, 0x8E, 0x3F, 0x43, 0x83, 0x6F,
  0x3F, 0x33, 0x83, 0x7F, 0x1F, 0x53, 0x83, 0x8E, 0x0D, 0xA3, 0x89, 0x0D, 0xA0, 0x6F, 0x74, 0x9F,
  0x32, 0x83, 0x6D, 0xFC, 0x41,
  // "Õ" (U+00D5)
  0x38, 0x3D, 0xB2, 0xC1, 0x28, 0x34, 0xA7, 0xFB, 0x38, 0x21, 0x10, 0x14, 0x83, 0x7D, 0xFC, 0x42,
  0x89, 0x07, 0xF7, 0x49, 0xF3, 0x0E, 0xA3, 0x83, 0xCA, 0x2F, 0x53, 0x83, 0x8E, 0x3F, 0x43, 0x83,
  0x6F, 0x3F, 0x33, 0x83, 0x7F, 0x1F, 0x53, 0x83, 0x8E, 0x0D, 0xA3, 0x89, 0x0D, 0xA0, 0x6F, 0x74,
  0x9F, 0x32, 0x83, 0x6D, 0xFC, 0x41,
  // "Ö" (U+00D6)
  0x28, 0x31, 0xE1, 0x97, 0x48, 0x11, 0x01, 0x48, 0x37, 0xDF, 0xC4, 0x28, 0x90, 0x7F, 0x74, 0x9F,
  0x30, 0xEA, 0x38, 0x3C, 0xA2, 0xF5, 0x38, 0x38, 0xE3, 0xF4, 0x38, 0x36, 0xF3, 0xF3, 0x38, 0x37,
  0xF1, 0xF5, 0x38, 0x38, 0xE0, 0xDA, 0x38, 0x90, 0xDA, 0x06, 0xF7, 0x49, 0xF3, 0x28, 0x36, 0xDF,
  0xC4, 0x10,
  // "×" (U+00D7)
  0x10, 0x62, 0x89, 0x31, 0x71, 0xD9, 0x1C, 0xA0, 0x1D, 0xEA, 0x28, 0x93, 0x1C, 0xF9, 0x01, 0xCA,
  0x2D, 0x81, 0x82, 0x01, 0x08,
  // "Ø" (U+00D8)
  0x70, 0x13, 0x84, 0x7D, 0xFC, 0xA8, 0x28, 0x56, 0xF7, 0x4A, 0xF4, 0x20, 0xE0, 0xA2, 0x8C, 0x59,
  0xFB, 0x02, 0xF5, 0x03, 0xC8, 0xE0, 0x3F, 0x30, 0xC4, 0x6F, 0x13, 0xF3, 0x5A, 0x06, 0xF1, 0x1F,
  0x6D, 0x20, 0x8E, 0x28, 0x1D, 0xE8, 0x20, 0xC0, 0xB2, 0x85, 0x7F, 0x84, 0x9F, 0x32, 0x84, 0xAA,
  0xDF, 0xC5, 0x30, 0x47,
  // "Ù" (U+00D9)
  0x18, 0x12, 0x72, 0x50, 0xC0, 0xA5, 0x81, 0x1D, 0x37, 0x29, 0x06, 0x28, 0x31, 0xF5, 0xF6, 0x28,
  0x31, 0xF5, 0xF6, 0x28, 0x31, 0xF5, 0xF6, 0x28, 0x31, 0xF5, 0xF6, 0x28, 0x31, 0xF5, 0xF6, 0x28,
  0x31, 0xF5, 0xF6, 0x28, 0x31, 0xF4, 0xD8, 0x28, 0x73, 0xF3, 0x8E, 0x54, 0xCD, 0x28, 0x39, 0xDE,
  0xB2, 0x10,
  // "Ú" (U+00DA)
  0x38, 0x12, 0x72, 0x40, 0xA0, 0xC4, 0x81, 0x3D, 0x17, 0x29, 0x06, 0x28, 0x31, 0xF5, 0xF6, 0x28,
  0x31, 0xF5, 0xF6, 0x28, 0x31, 0xF5, 0xF6, 0x28, 0x31, 0xF5, 0xF6, 0x28, 0x31, 0xF5, 0xF6, 0x28,
  0x31, 0xF5, 0xF6, 0x28, 0x31, 0xF4, 0xD8, 0x28, 0x73, 0xF3, 0x8E, 0x54, 0xCD, 0x28, 0x39, 0xDE,
  0xB2, 0x10,
  // "Û" (U+00DB)
  0x28, 0x11, 0x73, 0x48, 0x18, 0xDD, 0x38, 0x33, 0xC0, 0x88, 0x71, 0x90, 0x62, 0x83, 0x1F, 0x5F,
  0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x5F,
  0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x4D, 0x82, 0x87, 0x3F, 0x38, 0xE5, 0x4C, 0xD2, 0x83,
  0x9D, 0xEB, 0x21,
  // "Ü" (U+00DC)
  0x83, 0x1E, 0x19, 0x73, 0x81, 0x10, 0x13, 0x90, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x5F,
  0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x5F,
  0x62, 0x83, 0x1F, 0x4D, 0x82, 0x87, 0x3F, 0x38, 0xE5, 0x4C, 0xD2, 0x83, 0x9D, 0xEB, 0x21,
  // "Ý" (U+00DD)
  0x38, 0x12, 0x72, 0x40, 0xA0, 0xC4, 0x81, 0x3D, 0x17, 0x20, 0xC0, 0xB2, 0x87, 0x2F, 0x55, 0xF1,
  0x08, 0xD2, 0x83, 0xE7, 0x0E, 0x72, 0x83, 0x8D, 0x4F, 0x12, 0x82, 0x2F, 0xDA, 0x48, 0x1B, 0xF3,
  0x40, 0x79, 0x50, 0x79, 0x50, 0x79, 0x50, 0x79, 0x30,
  // "Þ" (U+00DE)
  0x0E, 0x08, 0x40, 0xEA, 0x89, 0x7C, 0x40, 0xE9, 0x3A, 0xF1, 0xE8, 0x01, 0xF5, 0xE8, 0x29, 0x89,
  0x47, 0xE8, 0x01, 0xF6, 0xE8, 0x19, 0xF1, 0xEA, 0x84, 0xE5, 0x0E, 0x92, 0x30, 0xE0, 0x84,
  // "ß" (U+00DF)
  0x8C, 0x02, 0xBE, 0xD6, 0x0B, 0xC4, 0x8F, 0x1F, 0x60, 0x3F, 0x2F, 0x50, 0xBB, 0x0F, 0x56, 0xE1,
  0x0F, 0x58, 0xE2, 0x98, 0x93, 0x52, 0xEC, 0x0F, 0x50, 0x2E, 0xAF, 0x52, 0x89, 0x47, 0xEF, 0x57,
  0x3B, 0xCF, 0x5B, 0xFD, 0x30,
  // "à" (U+00E0)
  0x18, 0x12, 0x72, 0x40, 0xC0, 0xA4, 0x81, 0x1D, 0x37, 0x18, 0x91, 0x6D, 0xEB, 0x10, 0x55, 0x4E,
  0x74, 0x83, 0xAA, 0x07, 0xDA, 0x87, 0xA4, 0xF7, 0x3B, 0xA7, 0xE2, 0x89, 0x4B, 0xA5, 0xF5, 0x6E,
  0xA0, 0xAE, 0xA7, 0xA0,
  // "á" (U+00E1)
  0x38, 0x12, 0x72, 0x30, 0xA0, 0xC3, 0x81, 0x3D, 0x17, 0x18, 0x91, 0x6D, 0xEB, 0x10, 0x55, 0x4E,
  0x74, 0x83, 0xAA, 0x07, 0xDA, 0x87, 0xA4, 0xF7, 0x3B, 0xA7, 0xE2, 0x89, 0x4B, 0xA5, 0xF5, 0x6E,
  0xA0, 0xAE, 0xA7, 0xA0,
  // "â" (U+00E2)
  0x28, 0x11, 0x73, 0x38, 0x18, 0xDD, 0x28, 0x33, 0xC0, 0x88, 0x78, 0x91, 0x6D, 0xEB, 0x10, 0x55,
  0x4E, 0x74, 0x83, 0xAA, 0x07, 0xDA, 0x87, 0xA4, 0xF7, 0x3B, 0xA7, 0xE2, 0x89, 0x4B, 0xA5, 0xF5,
  0x6E, 0xA0, 0xAE, 0xA7, 0xA0,
  // "ã" (U+00E3)
  0x28, 0x91, 0xDB, 0x2C, 0x10, 0x4A, 0x7F, 0xB2, 0x82, 0x11, 0x01, 0x38, 0x36, 0xDE, 0xB1, 0x28,
  0x35, 0x54, 0xE7, 0x50, 0x0A, 0x20, 0x70, 0xDA, 0x89, 0x1A, 0x04, 0xF7, 0x3B, 0xA0, 0x7E, 0x28,
  0x7B, 0xA0, 0x5F, 0x56, 0xEA, 0x28, 0x3A, 0xEA, 0x7A, 0x10,
  // "ä" (U+00E4)
  0x18, 0x31, 0xE1, 0x97, 0x28, 0x11, 0x01, 0x28, 0x91, 0x6D, 0xEB, 0x10, 0x55, 0x4E, 0x74, 0x83,
  0xAA, 0x07, 0xDA, 0x87, 0xA4, 0xF7, 0x3B, 0xA7, 0xE2, 0x89, 0x4B, 0xA5, 0xF5, 0x6E, 0xA0, 0xAE,
  0xA7, 0xA0,
  // "å" (U+00E5)
  0x18, 0x21, 0xDE, 0x32, 0x82, 0x6A, 0x79, 0x28, 0x22, 0xEF, 0x53, 0x00, 0x13, 0x89, 0x16, 0xDE,
  0xB1, 0x05, 0x54, 0xE7, 0x48, 0x3A, 0xA0, 0x7D, 0xA8, 0x7A, 0x4F, 0x73, 0xBA, 0x7E, 0x28, 0x94,
  0xBA, 0x5F, 0x56, 0xEA, 0x0A, 0xEA, 0x7A,
  // "æ" (U+00E6)
  0x18, 0x67, 0xDE, 0x95, 0xEE, 0x62, 0x87, 0x55, 0x4E, 0xF5, 0x5F, 0x34, 0x00, 0xB2, 0x83, 0xC7,
  0x07, 0xEE, 0x89, 0x39, 0x4F, 0x73, 0xCB, 0x22, 0x21, 0x7E, 0x20, 0x0C, 0x48, 0xA2, 0x5F, 0x56,
  0xCF, 0x83, 0x62, 0x0A, 0xEB, 0x15, 0xDF, 0xC2,
  // "ç" (U+00E7)
  0x18, 0x94, 0x2C, 0xFD, 0x10, 0xCB, 0x46, 0x03, 0xF3, 0x38, 0x15, 0xF1, 0x38, 0x15, 0xF1, 0x38,
  0x13, 0xF3, 0x48, 0x91, 0xEB, 0x46, 0x10, 0x3C, 0xEC, 0x12, 0x01, 0x05, 0x48, 0x13, 0xC4, 0x38,
  0x14, 0xB9, 0x38, 0x1D, 0xC3, 0x10,
  // "è" (U+00E8)
  0x18, 0x12, 0x72, 0x40, 0xC0, 0xA4, 0x81, 0x1D, 0x37, 0x18, 0xA0, 0x3C, 0xFB, 0x10, 0xDA, 0x4C,
  0xA3, 0xF1, 0x05, 0xE5, 0xD8, 0x75, 0xF3, 0x22, 0x23, 0xF3, 0x48, 0x91, 0xCC, 0x44, 0x60, 0x2B,
  0xFE, 0x70,
  // "é" (U+00E9)
  0x38, 0x12, 0x72, 0x30, 0xA0, 0xC3, 0x81, 0x3D, 0x17, 0x18, 0xA0, 0x3C, 0xFB, 0x10, 0xDA, 0x4C,
  0xA3, 0xF1, 0x05, 0xE5, 0xD8, 0x75, 0xF3, 0x22, 0x23, 0xF3, 0x48, 0x91, 0xCC, 0x44, 0x60, 0x2B,
  0xFE, 0x70,
  // "ê" (U+00EA)
  0x28, 0x11, 0x73, 0x38, 0x18, 0xDD, 0x28, 0x33, 0xC0, 0x88, 0x78, 0xA0, 0x3C, 0xFB, 0x10, 0xDA,
  0x4C, 0xA3, 0xF1, 0x05, 0xE5, 0xD8, 0x75, 0xF3, 0x22, 0x23, 0xF3, 0x48, 0x91, 0xCC, 0x44, 0x60,
  0x2B, 0xFE, 0x70,
  // "ë" (U+00EB)
  0x18, 0x31, 0xE1, 0x97, 0x28, 0x11, 0x01, 0x28, 0xA0, 0x3C, 0xFB, 0x10, 0xDA, 0x4C, 0xA3, 0xF1,
  0x05, 0xE5, 0xD8, 0x75, 0xF3, 0x22, 0x23, 0xF3, 0x48, 0x91, 0xCC, 0x44, 0x60, 0x2B, 0xFE, 0x70,
  // "ì" (U+00EC)
  0x81, 0x27, 0x22, 0x0C, 0x0A, 0x28, 0x11, 0xD3, 0x69, 0x05, 0x29, 0x05, 0x29, 0x05, 0x29, 0x05,
  0x29, 0x05, 0x29, 0x05, 0x29, 0x05, 0x29, 0x05,
  // "í" (U+00ED)
  0x18, 0x90, 0x27, 0x20, 0xAC, 0x03, 0xD1, 0x69, 0x05, 0x29, 0x05, 0x29, 0x05, 0x29, 0x05, 0x29,
  0x05, 0x29, 0x05, 0x29, 0x05, 0x29, 0x05, 0x10,
  // "î" (U+00EE)
  0x18, 0x11, 0x73, 0x28, 0x78, 0xDD, 0x03, 0xC0, 0x88, 0x79, 0x05, 0x39, 0x05, 0x39, 0x05, 0x39,
  0x05, 0x39, 0x05, 0x39, 0x05, 0x39, 0x05, 0x39, 0x05, 0x10,
  // "ï" (U+00EF)
  0x87, 0x1E, 0x19, 0x70, 0x10, 0x13, 0x90, 0x53, 0x90, 0x53, 0x90, 0x53, 0x90, 0x53, 0x90, 0x53,
  0x90, 0x53, 0x90, 0x53, 0x90, 0x51,
  // "ð" (U+00F0)
  0x28, 0x2C, 0x8B, 0x53, 0x81, 0x7F, 0xB4, 0x82, 0xA5, 0xF4, 0x50, 0x90, 0xC2, 0x8A, 0x33, 0xCE,
  0xCF, 0x10, 0xEA, 0x3A, 0xF5, 0x4F, 0x20, 0x1F, 0x65, 0x93, 0x98, 0x94, 0x64, 0xF2, 0x01, 0xF4,
  0x0D, 0xB4, 0xAD, 0x28, 0x32, 0xCF, 0xC3, 0x10,
  // "ñ" (U+00F1)
  0x18, 0x95, 0xDB, 0x2C, 0x14, 0xA7, 0xFB, 0x01, 0x10, 0x12, 0x98, 0xD5, 0x5D, 0xE7, 0x0F, 0xD4,
  0x8F, 0x1F, 0x70, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F,
  0x4F, 0x50, 0x1F, 0x40,
  // "ò" (U+00F2)
  0x18, 0x12, 0x72, 0x50, 0xC0, 0xA5, 0x81, 0x1D, 0x37, 0x38, 0x32, 0xCF, 0xC2, 0x28, 0x96, 0xDB,
  0x4A, 0xD0, 0x3F, 0x30, 0x2F, 0x35, 0xF1, 0x29, 0x82, 0x55, 0xF1, 0x29, 0x89, 0x46, 0x3F, 0x30,
  0x2F, 0x30, 0xDB, 0x4A, 0xD2, 0x83, 0x2C, 0xFC, 0x21,
  // "ó" (U+00F3)
  0x38, 0x12, 0x72, 0x40, 0xA0, 0xC4, 0x81, 0x3D, 0x17, 0x38, 0x32, 0xCF, 0xC2, 0x28, 0x96, 0xDB,
  0x4A, 0xD0, 0x3F, 0x30, 0x2F, 0x35, 0xF1, 0x29, 0x82, 0x55, 0xF1, 0x29, 0x89, 0x46, 0x3F, 0x30,
  0x2F, 0x30, 0xDB, 0x4A, 0xD2, 0x83, 0x2C, 0xFC, 0x21,
  // "ô" (U+00F4)
  0x28, 0x11, 0x73, 0x48, 0x18, 0xDD, 0x38, 0x33, 0xC0, 0x88, 0x72, 0x83, 0x2C, 0xFC, 0x22, 0x89,
  0x6D, 0xB4, 0xAD, 0x03, 0xF3, 0x02, 0xF3, 0x5F, 0x12, 0x98, 0x25, 0x5F, 0x12, 0x98, 0x94, 0x63,
  0xF3, 0x02, 0xF3, 0x0D, 0xB4, 0xAD, 0x28, 0x32, 0xCF, 0xC2, 0x10,
  // "õ" (U+00F5)
  0x28, 0x91, 0xDB, 0x2C, 0x10, 0x4A, 0x7F, 0xB2, 0x82, 0x11, 0x01, 0x38, 0x32, 0xCF, 0xC2, 0x28,
  0x96, 0xDB, 0x4A, 0xD0, 0x3F, 0x30, 0x2F, 0x35, 0xF1, 0x29, 0x82, 0x55, 0xF1, 0x29, 0x89, 0x46,
  0x3F, 0x30, 0x2F, 0x30, 0xDB, 0x4A, 0xD2, 0x83, 0x2C, 0xFC, 0x21,
  // "ö" (U+00F6)
  0x18, 0x31, 0xE1, 0x97, 0x38, 0x11, 0x01, 0x38, 0x32, 0xCF, 0xC2, 0x28, 0x96, 0xDB, 0x4A, 0xD0,
  0x3F, 0x30, 0x2F, 0x35, 0xF1, 0x29, 0x82, 0x55, 0xF1, 0x29, 0x89, 0x46, 0x3F, 0x30, 0x2F, 0x30,
  0xDB, 0x4A, 0xD2, 0x83, 0x2C, 0xFC, 0x21,
  // "÷" (U+00F7)
  0x20, 0x40, 0xD5, 0x03, 0x0C, 0x73, 0x07, 0xD0, 0x30, 0x18, 0x01, 0x23, 0x03, 0x0C, 0x50, 0x30,
  0xD3,
  // "ø" (U+00F8)
  0x50, 0x32, 0x83, 0x3C, 0xFB, 0xD2, 0x8C, 0x6D, 0xB4, 0xCD, 0x03, 0xF2, 0x1D, 0xF3, 0x5F, 0x0A,
  0x5F, 0x55, 0xF3, 0xC0, 0xF5, 0x2F, 0xD3, 0x2F, 0x30, 0xCD, 0x3A, 0xD2, 0x83, 0xDC, 0xFC, 0x32,
  0x06, 0x50,
  // "ù" (U+00F9)
  0x18, 0x12, 0x72, 0x50, 0xC0, 0xA5, 0x81, 0x1D, 0x37, 0x28, 0xE6, 0x1F, 0x40, 0x1F, 0x41, 0xF4,
  0x01, 0xF4, 0x1F, 0x40, 0x1F, 0x41, 0xF4, 0x01, 0xF4, 0x1F, 0x40, 0x1F, 0x40, 0xF5, 0x03, 0xF4,
  0x0D, 0xA2, 0xAF, 0x40, 0x4D, 0xD6, 0xD4,
  // "ú" (U+00FA)
  0x38, 0x12, 0x72, 0x40, 0xA0, 0xC4, 0x81, 0x3D, 0x17, 0x28, 0xE6, 0x1F, 0x40, 0x1F, 0x41, 0xF4,
  0x01, 0xF4, 0x1F, 0x40, 0x1F, 0x41, 0xF4, 0x01, 0xF4, 0x1F, 0x40, 0x1F, 0x40, 0xF5, 0x03, 0xF4,
  0x0D, 0xA2, 0xAF, 0x40, 0x4D, 0xD6, 0xD4,
  // "û" (U+00FB)
  0x28, 0x11, 0x73, 0x48, 0x18, 0xDD, 0x38, 0x33, 0xC0, 0x88, 0x71, 0x8E, 0x61, 0xF4, 0x01, 0xF4,
  0x1F, 0x40, 0x1F, 0x41, 0xF4, 0x01, 0xF4, 0x1F, 0x40, 0x1F, 0x41, 0xF4, 0x01, 0xF4, 0x0F, 0x50,
  0x3F, 0x40, 0xDA, 0x2A, 0xF4, 0x04, 0xDD, 0x6D, 0x40,
  // "ü" (U+00FC)
  0x18, 0x31, 0xE1, 0x97, 0x38, 0x11, 0x01, 0x28, 0xE6, 0x1F, 0x40, 0x1F, 0x41, 0xF4, 0x01, 0xF4,
  0x1F, 0x40, 0x1F, 0x41, 0xF4, 0x01, 0xF4, 0x1F, 0x40, 0x1F, 0x40, 0xF5, 0x03, 0xF4, 0x0D, 0xA2,
  0xAF, 0x40, 0x4D, 0xD6, 0xD4,
  // "ý" (U+00FD)
  0x38, 0x12, 0x72, 0x30, 0xA0, 0xC3, 0x81, 0x3D, 0x17, 0x0C, 0x09, 0x28, 0x28, 0xD7, 0xE2, 0x89,
  0x3C, 0x82, 0xF2, 0x1F, 0x40, 0xD7, 0x5E, 0x28, 0x28, 0xB9, 0xA2, 0x82, 0x4E, 0xD6, 0x38, 0x1E,
  0xF1, 0x30, 0xA0, 0xC4, 0x0D, 0x08, 0x28, 0x23, 0x8F, 0x22, 0x81, 0xAE, 0x63,
  // "þ" (U+00FE)
  0x90, 0x54, 0x90, 0x54, 0x90, 0x54, 0x98, 0x93, 0x7D, 0xE7, 0x0F, 0xD4, 0x8F, 0x2F, 0x72, 0x82,
  0xE7, 0xF5, 0x28, 0x2C, 0x9F, 0x52, 0x82, 0xC9, 0xF7, 0x28, 0x96, 0xE7, 0xFD, 0x48, 0xF2, 0xF7,
  0xDE, 0x70, 0xF5, 0x49, 0x05, 0x49, 0x05, 0x40,
  // "ÿ" (U+00FF)
  0x83, 0x1E, 0x19, 0x72, 0x81, 0x10, 0x12, 0x0C, 0x09, 0x28, 0x28, 0xD7, 0xE2, 0x89, 0x3C, 0x82,
  0xF2, 0x1F, 0x40, 0xD7, 0x5E, 0x28, 0x28, 0xB9, 0xA2, 0x82, 0x4E, 0xD6, 0x38, 0x1E, 0xF1, 0x30,
  0xA0, 0xC4, 0x0D, 0x08, 0x28, 0x23, 0x8F, 0x22, 0x81, 0xAE, 0x63,
  // "Ā" (U+0100)
  0x10, 0x6B, 0x05, 0x30, 0x10, 0xF2, 0x58, 0x14, 0xFA, 0x58, 0x19, 0xEE, 0x58, 0x2D, 0x8F, 0x33,
  0x83, 0x2F, 0x3D, 0x73, 0x83, 0x6E, 0x09, 0xC3, 0x84, 0xBB, 0x16, 0xF1, 0x2D, 0x89, 0x25, 0x04,
  0xF6, 0x44, 0xDA, 0x09, 0xE3, 0x83, 0x9E, 0x0D, 0xA3, 0x81, 0x4F, 0x30,
  // "ā" (U+0101)
  0x10, 0x6B, 0x81, 0x50, 0x10, 0xF2, 0x28, 0x91, 0x6D, 0xEB, 0x10, 0x55, 0x4E, 0x74, 0x83, 0xAA,
  0x07, 0xDA, 0x87, 0xA4, 0xF7, 0x3B, 0xA7, 0xE2, 0x89, 0x4B, 0xA5, 0xF5, 0x6E, 0xA0, 0xAE, 0xA7,
  0xA0,
  // "Ă" (U+0102)
  0x18, 0x34, 0x81, 0x85, 0x38, 0x31, 0xDF, 0xD1, 0x50, 0x26, 0x81, 0x4F, 0xA5, 0x81, 0x9E, 0xE5,
  0x82, 0xD8, 0xF3, 0x38, 0x32, 0xF3, 0xD7, 0x38, 0x36, 0xE0, 0x9C, 0x38, 0x4B, 0xB1, 0x6F, 0x12,
  0xD8, 0x92, 0x50, 0x4F, 0x64, 0x4D, 0xA0, 0x9E, 0x38, 0x39, 0xE0, 0xDA, 0x38, 0x14, 0xF3,
  // "ă" (U+0103)
  0x18, 0x91, 0x48, 0x18, 0x50, 0x1D, 0xFD, 0x13, 0x02, 0x38, 0x91, 0x6D, 0xEB, 0x10, 0x55, 0x4E,
  0x74, 0x83, 0xAA, 0x07, 0xDA, 0x87, 0xA4, 0xF7, 0x3B, 0xA7, 0xE2, 0x89, 0x4B, 0xA5, 0xF5, 0x6E,
  0xA0, 0xAE, 0xA7, 0xA0,
  // "Ą" (U+0104)
  0x28, 0x14, 0xFA, 0x58, 0x19, 0xEE, 0x58, 0x2D, 0x8F, 0x33, 0x83, 0x2F, 0x3D, 0x73, 0x83, 0x6E,
  0x09, 0xC3, 0x84, 0xBB, 0x16, 0xF1, 0x2D, 0x89, 0x25, 0x04, 0xF6, 0x44, 0xDA, 0x09, 0xE3, 0x83,
  0x9E, 0x0D, 0xA3, 0x81, 0x7F, 0x34, 0x01, 0x0C, 0x60, 0x60, 0xB6, 0x81, 0x3F, 0xC6, 0x00, 0x11,
  // "ą" (U+0105)
  0x18, 0x91, 0x6D, 0xEB, 0x10, 0x55, 0x4E, 0x74, 0x83, 0xAA, 0x07, 0xDA, 0x87, 0xA4, 0xF7, 0x3B,
  0xA7, 0xE2, 0x89, 0x4B, 0xA5, 0xF5, 0x6E, 0xA0, 0xAE, 0xAA, 0xD3, 0x01, 0x0C, 0x40, 0x60, 0xB4,
  0x81, 0x3F, 0xC4, 0x00, 0x10,
  // "Ć" (U+0106)
  0x48, 0x12, 0x72, 0x40, 0xA0, 0xC4, 0x81, 0x3D, 0x17, 0x38, 0x95, 0x5C, 0xFD, 0x60, 0x4F, 0x93,
  0x64, 0x0C, 0xB4, 0x81, 0x1F, 0x64, 0x81, 0x3F, 0x44, 0x81, 0x3F, 0x44, 0x81, 0x2F, 0x55, 0x0D,
  0x0B, 0x58, 0x46, 0xF9, 0x45, 0x32, 0x83, 0x6D, 0xFD, 0x50,
  // "ć" (U+0107)
  0x38, 0x12, 0x72, 0x30, 0xA0, 0xC3, 0x81, 0x3D, 0x17, 0x18, 0x94, 0x2C, 0xFD, 0x10, 0xCB, 0x46,
  0x03, 0xF3, 0x38, 0x15, 0xF1, 0x38, 0x15, 0xF1, 0x38, 0x13, 0xF3, 0x48, 0x91, 0xEB, 0x46, 0x10,
  0x3C, 0xEC, 0x10,
  // "Ĉ" (U+0108)
  0x38, 0x11, 0x73, 0x48, 0x18, 0xDD, 0x38, 0x33, 0xC0, 0x88, 0x72, 0x89, 0x55, 0xCF, 0xD6, 0x04,
  0xF9, 0x36, 0x40, 0xCB, 0x48, 0x11, 0xF6, 0x48, 0x13, 0xF4, 0x48, 0x13, 0xF4, 0x48, 0x12, 0xF5,
  0x50, 0xD0, 0xB5, 0x84, 0x6F, 0x94, 0x53, 0x28, 0x36, 0xDF, 0xD5,
  // "ĉ" (U+0109)
  0x28, 0x11, 0x73, 0x38, 0x18, 0xDD, 0x28, 0x33, 0xC0, 0x88, 0x78, 0x94, 0x2C, 0xFD, 0x10, 0xCB,
  0x46, 0x03, 0xF3, 0x38, 0x15, 0xF1, 0x38, 0x15, 0xF1, 0x38, 0x13, 0xF3, 0x48, 0x91, 0xEB, 0x46,
  0x10, 0x3C, 0xEC, 0x10,
  // "Ċ" (U+010A)
  0x30, 0x40, 0xE6, 0x01, 0x74, 0x89, 0x55, 0xCF, 0xD6, 0x04, 0xF9, 0x36, 0x40, 0xCB, 0x48, 0x11,
  0xF6, 0x48, 0x13, 0xF4, 0x48, 0x13, 0xF4, 0x48, 0x12, 0xF5, 0x50, 0xD0, 0xB5, 0x84, 0x6F, 0x94,
  0x53, 0x28, 0x36, 0xDF, 0xD5,
  // "ċ" (U+010B)
  0x20, 0x40, 0xE5, 0x01, 0x72, 0x89, 0x42, 0xCF, 0xD1, 0x0C, 0xB4, 0x60, 0x3F, 0x33, 0x81, 0x5F,
  0x13, 0x81, 0x5F, 0x13, 0x81, 0x3F, 0x34, 0x89, 0x1E, 0xB4, 0x61, 0x03, 0xCE, 0xC1,
  // "Č" (U+010C)
  0x28, 0x32, 0x50, 0x25, 0x38, 0x2D, 0x6D, 0x33, 0x81, 0x4F, 0x97, 0x38, 0x95, 0x5C, 0xFD, 0x60,
  0x4F, 0x93, 0x64, 0x0C, 0xB4, 0x81, 0x1F, 0x64, 0x81, 0x3F, 0x44, 0x81, 0x3F, 0x44, 0x81, 0x2F,
  0x55, 0x0D, 0x0B, 0x58, 0x46, 0xF9, 0x45, 0x32, 0x83, 0x6D, 0xFD, 0x50,
  // "č" (U+010D)
  0x18, 0x32, 0x50, 0x25, 0x28, 0x2D, 0x6D, 0x32, 0x81, 0x4F, 0x97, 0x18, 0x94, 0x2C, 0xFD, 0x10,
  0xCB, 0x46, 0x03, 0xF3, 0x38, 0x15, 0xF1, 0x38, 0x15, 0xF1, 0x38, 0x13, 0xF3, 0x48, 0x91, 0xEB,
  0x46, 0x10, 0x3C, 0xEC, 0x10,
  // "Ď" (U+010E)
  0x83, 0x25, 0x02, 0x53, 0x82, 0xD6, 0xD3, 0x38, 0x14, 0xF9, 0x73, 0x0E, 0xA0, 0xD0, 0x82, 0x87,
  0xE9, 0x37, 0xFA, 0x0E, 0x82, 0x83, 0x6F, 0x2E, 0x82, 0x83, 0x1F, 0x6E, 0x83, 0x98, 0x18, 0xE8,
  0x39, 0x81, 0x7E, 0x82, 0x83, 0x2F, 0x6E, 0x82, 0x89, 0x17, 0xF1, 0xE9, 0x37, 0xF9, 0x0E, 0xA0,
  0xD0, 0x72,
  // "ď" (U+010F)
  0x48, 0x21, 0xF9, 0xE4, 0x82, 0x1F, 0xC8, 0x48, 0x11, 0xF5, 0x28, 0x44, 0xDE, 0x6F, 0x42, 0x8C,
  0x4E, 0xB4, 0xBF, 0x40, 0x3F, 0x30, 0x3F, 0x40, 0x5F, 0x10, 0x1F, 0x40, 0x5F, 0x10, 0x1F, 0x40,
  0x3F, 0x30, 0x3F, 0x42, 0x84, 0xEB, 0x4B, 0xF4, 0x28, 0x44, 0xDE, 0x5E, 0x41,
  // "Đ" (U+0110)
  0x10, 0xDA, 0x0D, 0x08, 0x38, 0x4D, 0x93, 0x7F, 0x92, 0x0D, 0x08, 0x28, 0x46, 0xF2, 0x0D, 0x82,
  0x82, 0x1F, 0x6B, 0xB8, 0x61, 0x0F, 0x72, 0xE9, 0x22, 0x98, 0x27, 0x0D, 0x82, 0x84, 0x2F, 0x50,
  0xD8, 0x28, 0x90, 0x7F, 0x10, 0xD9, 0x37, 0xF9, 0x20, 0xDA, 0x0D, 0x07, 0x20,
  // "đ" (U+0111)
  0x48, 0x11, 0xF4, 0x4C, 0x02, 0x38, 0x22, 0x4F, 0x62, 0x84, 0x4D, 0xE6, 0xF4, 0x28, 0xC4, 0xEB,
  0x4B, 0xF4, 0x03, 0xF3, 0x03, 0xF4, 0x05, 0xF1, 0x01, 0xF4, 0x05, 0xF1, 0x01, 0xF4, 0x03, 0xF3,
  0x03, 0xF4, 0x28, 0x4E, 0xB4, 0xBF, 0x42, 0x84, 0x4D, 0xE5, 0xE4, 0x10,
  // "Ē" (U+0112)
  0x06, 0xB8, 0x55, 0x12, 0x22, 0x0E, 0xB8, 0x6A, 0xE9, 0x33, 0x2E, 0x83, 0x0E, 0x08, 0x30, 0xEB,
  0x86, 0x7E, 0x92, 0x21, 0xE8, 0x30, 0xE0, 0x83, 0x84, 0xE9, 0x33, 0x2E, 0xB0, 0xA0,
  // "ē" (U+0113)
  0x10, 0x6B, 0x81, 0x50, 0x10, 0xF2, 0x28, 0xA0, 0x3C, 0xFB, 0x10, 0xDA, 0x4C, 0xA3, 0xF1, 0x05,
  0xE5, 0xD8, 0x75, 0xF3, 0x22, 0x23, 0xF3, 0x48, 0x91, 0xCC, 0x44, 0x60, 0x2B, 0xFE, 0x70,
  // "Ĕ" (U+0114)
  0x89, 0x04, 0x81, 0x85, 0x1D, 0xFD, 0x12, 0x02, 0x20, 0xEB, 0x86, 0xAE, 0x93, 0x32, 0xE8, 0x30,
  0xE0, 0x83, 0x0E, 0xB8, 0x67, 0xE9, 0x22, 0x1E, 0x83, 0x0E, 0x08, 0x38, 0x4E, 0x93, 0x32, 0xEB,
  0x0A,
  // "ĕ" (U+0115)
  0x18, 0x91, 0x48, 0x18, 0x50, 0x1D, 0xFD, 0x13, 0x02, 0x38, 0xA0, 0x3C, 0xFB, 0x10, 0xDA, 0x4C,
  0xA3, 0xF1, 0x05, 0xE5, 0xD8, 0x75, 0xF3, 0x22, 0x23, 0xF3, 0x48, 0x91, 0xCC, 0x44, 0x60, 0x2B,
  0xFE, 0x70,
  // "Ė" (U+0116)
  0x10, 0x40, 0xE4, 0x01, 0x70, 0xEB, 0x86, 0xAE, 0x93, 0x32, 0xE8, 0x30, 0xE0, 0x83, 0x0E, 0xB8,
  0x67, 0xE9, 0x22, 0x1E, 0x83, 0x0E, 0x08, 0x38, 0x4E, 0x93, 0x32, 0xEB, 0x0A,
  // "ė" (U+0117)
  0x20, 0x40, 0xE5, 0x01, 0x72, 0x8A, 0x03, 0xCF, 0xB1, 0x0D, 0xA4, 0xCA, 0x3F, 0x10, 0x5E, 0x5D,
  0x87, 0x5F, 0x32, 0x22, 0x3F, 0x34, 0x89, 0x1C, 0xC4, 0x46, 0x02, 0xBF, 0xE7,
  // "Ę" (U+0118)
  0x0E, 0xB8, 0x6A, 0xE9, 0x33, 0x2E, 0x83, 0x0E, 0x08, 0x30, 0xEB, 0x86, 0x7E, 0x92, 0x21, 0xE8,
  0x30, 0xE0, 0x83, 0x84, 0xE9, 0x33, 0x2E, 0xB0, 0xC2, 0x01, 0x0C, 0x30, 0x60, 0xB3, 0x81, 0x3F,
  0xC3, 0x00, 0x10,
  // "ę" (U+0119)
  0x18, 0xA0, 0x3C, 0xFB, 0x10, 0xDA, 0x4C, 0xA3, 0xF1, 0x05, 0xE5, 0xD8, 0x75, 0xF3, 0x22, 0x23,
  0xF3, 0x48, 0x6C, 0xC4, 0x46, 0x02, 0xBA, 0x09, 0x30, 0x20, 0xB4, 0x81, 0x7A, 0x23, 0x81, 0x4E,
  0x90,
  // "Ě" (U+011A)
  0x89, 0x42, 0x50, 0x25, 0x0D, 0x6D, 0x30, 0x4F, 0x96, 0x0E, 0xB8, 0x6A, 0xE9, 0x33, 0x2E, 0x83,
  0x0E, 0x08, 0x30, 0xEB, 0x86, 0x7E, 0x92, 0x21, 0xE8, 0x30, 0xE0, 0x83, 0x84, 0xE9, 0x33, 0x2E,
  0xB0, 0xA0,
  // "ě" (U+011B)
  0x18, 0x32, 0x50, 0x25, 0x28, 0x2D, 0x6D, 0x32, 0x81, 0x4F, 0x97, 0x18, 0xA0, 0x3C, 0xFB, 0x10,
  0xDA, 0x4C, 0xA3, 0xF1, 0x05, 0xE5, 0xD8, 0x75, 0xF3, 0x22, 0x23, 0xF3, 0x48, 0x91, 0xCC, 0x44,
  0x60, 0x2B, 0xFE, 0x70,
  // "Ĝ" (U+011C)
  0x38, 0x11, 0x73, 0x58, 0x18, 0xDD, 0x48, 0x33, 0xC0, 0x88, 0x74, 0x89, 0x73, 0xBE, 0xEB, 0x30,
  0x3F, 0xB4, 0x47, 0x20, 0xCC, 0x58, 0x11, 0xF6, 0x58, 0x33, 0xF4, 0x05, 0xA8, 0x92, 0x93, 0xF3,
  0x01, 0x2C, 0x91, 0xF5, 0x38, 0x3B, 0x90, 0xDB, 0x38, 0x90, 0xB9, 0x05, 0xF9, 0x34, 0xD9, 0x28,
  0x45, 0xCF, 0xEC, 0x60,
  // "ĝ" (U+011D)
  0x28, 0x11, 0x73, 0x48, 0x18, 0xDD, 0x38, 0x33, 0xC0, 0x88, 0x72, 0x8E, 0x54, 0xDE, 0x5E, 0x40,
  0xDB, 0x4B, 0xF4, 0x3F, 0x30, 0x3F, 0x45, 0xF1, 0x01, 0xF4, 0x5F, 0x10, 0x1F, 0x43, 0xF3, 0x03,
  0xF4, 0x0E, 0xB4, 0xBF, 0x40, 0x4E, 0xE6, 0xF4, 0x48, 0x72, 0xF2, 0x07, 0x43, 0xBD, 0x28, 0x3A,
  0xEE, 0xB2, 0x10,
  // "Ğ" (U+011E)
  0x28, 0x34, 0x81, 0x85, 0x38, 0x31, 0xDF, 0xD1, 0x50, 0x25, 0x89, 0x73, 0xBE, 0xEB, 0x30, 0x3F,
  0xB4, 0x47, 0x20, 0xCC, 0x58, 0x11, 0xF6, 0x58, 0x33, 0xF4, 0x05, 0xA8, 0x92, 0x93, 0xF3, 0x01,
  0x2C, 0x91, 0xF5, 0x38, 0x3B, 0x90, 0xDB, 0x38, 0x90, 0xB9, 0x05, 0xF9, 0x34, 0xD9, 0x28, 0x45,
  0xCF, 0xEC, 0x60,
  // "ğ" (U+011F)
  0x18, 0x34, 0x81, 0x85, 0x28, 0x31, 0xDF, 0xD1, 0x40, 0x24, 0x8E, 0x54, 0xDE, 0x5E, 0x40, 0xDB,
  0x4B, 0xF4, 0x3F, 0x30, 0x3F, 0x45, 0xF1, 0x01, 0xF4, 0x5F, 0x10, 0x1F, 0x43, 0xF3, 0x03, 0xF4,
  0x0E, 0xB4, 0xBF, 0x40, 0x4E, 0xE6, 0xF4, 0x48, 0x72, 0xF2, 0x07, 0x43, 0xBD, 0x28, 0x3A, 0xEE,
  0xB2, 0x10,
  // "Ġ" (U+0120)
  0x30, 0x40, 0xE7, 0x01, 0x76, 0x89, 0x73, 0xBE, 0xEB, 0x30, 0x3F, 0xB4, 0x47, 0x20, 0xCC, 0x58,
  0x11, 0xF6, 0x58, 0x33, 0xF4, 0x05, 0xA8, 0x92, 0x93, 0xF3, 0x01, 0x2C, 0x91, 0xF5, 0x38, 0x3B,
  0x90, 0xDB, 0x38, 0x90, 0xB9, 0x05, 0xF9, 0x34, 0xD9, 0x28, 0x45, 0xCF, 0xEC, 0x60,
  // "ġ" (U+0121)
  0x20, 0x40, 0xE6, 0x01, 0x74, 0x8E, 0x54, 0xDE, 0x5E, 0x40, 0xDB, 0x4B, 0xF4, 0x3F, 0x30, 0x3F,
  0x45, 0xF1, 0x01, 0xF4, 0x5F, 0x10, 0x1F, 0x43, 0xF3, 0x03, 0xF4, 0x0E, 0xB4, 0xBF, 0x40, 0x4E,
  0xE6, 0xF4, 0x48, 0x72, 0xF2, 0x07, 0x43, 0xBD, 0x28, 0x3A, 0xEE, 0xB2, 0x10,
  // "Ģ" (U+0122)
  0x28, 0x97, 0x3B, 0xEE, 0xB3, 0x03, 0xFB, 0x44, 0x72, 0x0C, 0xC5, 0x81, 0x1F, 0x65, 0x83, 0x3F,
  0x40, 0x5A, 0x89, 0x29, 0x3F, 0x30, 0x12, 0xC9, 0x1F, 0x53, 0x83, 0xB9, 0x0D, 0xB3, 0x89, 0x0B,
  0x90, 0x5F, 0x93, 0x4D, 0x92, 0x84, 0x5C, 0xFE, 0xC6, 0x40, 0x26, 0x06, 0x0D, 0x60, 0x90, 0x63,
  // "ģ" (U+0123)
  0x20, 0x10, 0xD5, 0x08, 0x0B, 0x50, 0x01, 0x48, 0xE5, 0x4D, 0xE5, 0xE4, 0x0D, 0xB4, 0xBF, 0x43,
  0xF3, 0x03, 0xF4, 0x5F, 0x10, 0x1F, 0x45, 0xF1, 0x01, 0xF4, 0x3F, 0x30, 0x3F, 0x40, 0xEB, 0x4B,
  0xF4, 0x04, 0xEE, 0x6F, 0x44, 0x87, 0x2F, 0x20, 0x74, 0x3B, 0xD2, 0x83, 0xAE, 0xEB, 0x21,
  // "Ĥ" (U+0124)
  0x28, 0x11, 0x73, 0x48, 0x18, 0xDD, 0x38, 0x33, 0xC0, 0x88, 0x71, 0x0E, 0x08, 0x39, 0x81, 0x6E,
  0x83, 0x98, 0x16, 0xE8, 0x39, 0x81, 0x6E, 0x83, 0x90, 0x60, 0xED, 0x89, 0x06, 0xE9, 0x22, 0x3F,
  0x6E, 0x83, 0x98, 0x16, 0xE8, 0x39, 0x81, 0x6E, 0x83, 0x98, 0x16, 0xE8, 0x39, 0x06,
  // "ĥ" (U+0125)
  0x18, 0x11, 0x73, 0x58, 0x18, 0xDD, 0x48, 0x33, 0xC0, 0x88, 0x76, 0x90, 0x56, 0x90, 0x56, 0x90,
  0x56, 0x98, 0x28, 0xDE, 0x73, 0x98, 0x3D, 0x48, 0xF1, 0x29, 0x83, 0x70, 0x1F, 0x42, 0x98, 0x35,
  0x01, 0xF4, 0x29, 0x83, 0x50, 0x1F, 0x42, 0x98, 0x35, 0x01, 0xF4, 0x29, 0x83, 0x50, 0x1F, 0x42,
  0x98, 0x35, 0x01, 0xF4,
  // "Ħ" (U+0126)
  0x10, 0xE0, 0x73, 0x90, 0x61, 0xF9, 0x89, 0x38, 0x2E, 0x92, 0x23, 0xF8, 0x10, 0xE8, 0x39, 0x06,
  0x20, 0xED, 0x06, 0x28, 0x5E, 0x92, 0x23, 0xF6, 0x20, 0xE0, 0x73, 0x90, 0x62, 0x0E, 0x07, 0x39,
  0x06, 0x20, 0xE0, 0x73, 0x90, 0x62, 0x0E, 0x07, 0x39, 0x06, 0x10,
  // "ħ" (U+0127)
  0x19, 0x05, 0x40, 0xEB, 0x03, 0x28, 0x23, 0xF7, 0x24, 0x98, 0x28, 0xDE, 0x72, 0x98, 0xD5, 0xD4,
  0x8F, 0x10, 0xF7, 0x01, 0xF4, 0x0F, 0x50, 0x1F, 0x40, 0xF5, 0x01, 0xF4, 0x0F, 0x50, 0x1F, 0x40,
  0xF5, 0x01, 0xF4, 0x0F, 0x50, 0x1F, 0x40,
  // "Ĩ" (U+0128)
  0x18, 0x95, 0xDB, 0x2C, 0x14, 0xA7, 0xFB, 0x01, 0x10, 0x13, 0x08, 0xA0, 0xD3, 0x81, 0x9E, 0x13,
  0x08, 0x0D, 0x40, 0x80, 0xD4, 0x08, 0x0D, 0x40, 0x80, 0xD4, 0x08, 0x0D, 0x40, 0x80, 0xD4, 0x08,
  0x0D, 0x30, 0x7A, 0x0C, 0x10,
  // "ĩ" (U+0129)
  0x18, 0x95, 0xDB, 0x2C, 0x14, 0xA7, 0xFB, 0x01, 0x10, 0x14, 0x90, 0x54, 0x90, 0x54, 0x90, 0x54,
  0x90, 0x54, 0x90, 0x54, 0x90, 0x54, 0x90, 0x54, 0x90, 0x52,
  // "Ī" (U+012A)
  0x06, 0xB8, 0x55, 0x12, 0x22, 0x08, 0xA0, 0xD2, 0x81, 0x9E, 0x12, 0x08, 0x0D, 0x30, 0x80, 0xD3,
  0x08, 0x0D, 0x30, 0x80, 0xD3, 0x08, 0x0D, 0x30, 0x80, 0xD3, 0x08, 0x0D, 0x20, 0x7A, 0x0C, 0x10,
  // "ī" (U+012B)
  0x06, 0xB0, 0x50, 0x10, 0xF2, 0x39, 0x05, 0x39, 0x05, 0x39, 0x05, 0x39, 0x05, 0x39, 0x05, 0x39,
  0x05, 0x39, 0x05, 0x39, 0x05, 0x10,
  // "Ĭ" (U+012C)
  0x89, 0x04, 0x81, 0x85, 0x1D, 0xFD, 0x12, 0x02, 0x20, 0x8A, 0x0D, 0x28, 0x19, 0xE1, 0x20, 0x80,
  0xD3, 0x08, 0x0D, 0x30, 0x80, 0xD3, 0x08, 0x0D, 0x30, 0x80, 0xD3, 0x08, 0x0D, 0x30, 0x80, 0xD2,
  0x07, 0xA0, 0xC1,
  // "ĭ" (U+012D)
  0x89, 0x04, 0x81, 0x85, 0x1D, 0xFD, 0x12, 0x02, 0x49, 0x05, 0x39, 0x05, 0x39, 0x05, 0x39, 0x05,
  0x39, 0x05, 0x39, 0x05, 0x39, 0x05, 0x39, 0x05, 0x10,
  // "Į" (U+012E)
  0x08, 0xA8, 0x6D, 0x09, 0xE1, 0x08, 0xD2, 0x08, 0x0D, 0x20, 0x80, 0xD2, 0x08, 0x0D, 0x20, 0x80,
  0xD2, 0x08, 0x0D, 0x28, 0x28, 0xD0, 0x7B, 0x10, 0x10, 0xC2, 0x06, 0x0B, 0x28, 0x13, 0xFC, 0x20,
  0x01,
  // "į" (U+012F)
  0x18, 0x2E, 0x40, 0x25, 0x98, 0xC0, 0x50, 0xF5, 0x0F, 0x50, 0xF5, 0x0F, 0x50, 0xF5, 0x0F, 0x50,
  0xF7, 0x1C, 0x06, 0xB0, 0x3F, 0xC0, 0x11,
  // "İ" (U+0130)
  0x10, 0x40, 0xE3, 0x01, 0x50, 0x8A, 0x86, 0xD0, 0x9E, 0x10, 0x8D, 0x20, 0x80, 0xD2, 0x08, 0x0D,
  0x20, 0x80, 0xD2, 0x08, 0x0D, 0x20, 0x80, 0xD2, 0x82, 0x8D, 0x07, 0xA0, 0xC0,
  // "ı" (U+0131)
  0x98, 0x95, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x5F, 0x50,
  // "Ĳ" (U+0132)
  0x08, 0xA8, 0x94, 0xD0, 0xE7, 0x09, 0xE1, 0x0E, 0x70, 0x8D, 0x28, 0x3E, 0x70, 0x8D, 0x28, 0x3E,
  0x70, 0x8D, 0x28, 0x3E, 0x70, 0x8D, 0x28, 0x3E, 0x70, 0x8D, 0x28, 0x3E, 0x70, 0x8D, 0x28, 0x3E,
  0x70, 0x8D, 0x28, 0x1E, 0x77, 0xA8, 0x2C, 0x0E, 0x75, 0x90, 0x64, 0x81, 0x4F, 0x43, 0x81, 0xCF,
  0xB4, 0x00, 0x12,
  // "ĳ" (U+0133)
  0x84, 0xE4, 0x0E, 0x42, 0x20, 0x26, 0x98, 0xC5, 0x50, 0xF5, 0xF5, 0x0F, 0x5F, 0x50, 0xF5, 0xF5,
  0x0F, 0x5F, 0x50, 0xF5, 0xF5, 0x0F, 0x5F, 0x50, 0xF5, 0xF5, 0x0F, 0x53, 0x98, 0x90, 0x50, 0x16,
  0xF3, 0x05, 0xFA, 0x10,
  // "Ĵ" (U+0134)
  0x18, 0x11, 0x73, 0x28, 0x78, 0xDD, 0x03, 0xC0, 0x88, 0x70, 0xE0, 0x73, 0x0E, 0x07, 0x30, 0xE0,
  0x73, 0x0E, 0x07, 0x30, 0xE0, 0x73, 0x0E, 0x07, 0x30, 0xE0, 0x73, 0x0E, 0x07, 0x30, 0xE0, 0x73,
  0x0E, 0x07, 0x39, 0x06, 0x28, 0x54, 0xF4, 0x0C, 0xFB, 0x20, 0x01, 0x30,
  // "ĵ" (U+0135)
  0x18, 0x11, 0x73, 0x28, 0x78, 0xDD, 0x03, 0xC0, 0x88, 0x79, 0x05, 0x39, 0x05, 0x39, 0x05, 0x39,
  0x05, 0x39, 0x05, 0x39, 0x05, 0x39, 0x05, 0x39, 0x05, 0x39, 0x89, 0x05, 0x01, 0x6F, 0x30, 0x5F,
  0xA2,
  // "Ķ" (U+0136)
  0x0E, 0x08, 0x28, 0x95, 0xBC, 0x0E, 0x80, 0x5F, 0x30, 0xE8, 0x1E, 0x82, 0x82, 0xE8, 0x9D, 0x38,
  0x2E, 0xBF, 0x63, 0x82, 0xEF, 0xDC, 0x38, 0x3E, 0x83, 0xF5, 0x28, 0x3E, 0x80, 0xAD, 0x28, 0x7E,
  0x80, 0x2F, 0x70, 0xE8, 0x28, 0x19, 0xE1, 0x30, 0x25, 0x06, 0x0D, 0x50, 0x90, 0x63,
  // "ķ" (U+0137)
  0x90, 0x54, 0x90, 0x54, 0x90, 0x54, 0x98, 0x95, 0x50, 0x8D, 0x0F, 0x53, 0xF4, 0x0F, 0x5D, 0x82,
  0x98, 0x1C, 0xF3, 0x29, 0x81, 0xDC, 0xA2, 0x98, 0x97, 0x54, 0xF2, 0x0F, 0x50, 0xCA, 0x0F, 0x50,
  0x5F, 0x22, 0x02, 0x40, 0x60, 0xD4, 0x09, 0x06, 0x30,
  // "ĸ" (U+0138)
  0x98, 0x95, 0x50, 0x8D, 0x0F, 0x53, 0xF4, 0x0F, 0x5C, 0x92, 0x98, 0x1B, 0xF4, 0x29, 0x81, 0xDC,
  0xA2, 0x98, 0x97, 0x54, 0xF3, 0x0F, 0x50, 0xCA, 0x0F, 0x50, 0x5F, 0x20,
  // "Ĺ" (U+0139)
  0x18, 0x12, 0x72, 0x30, 0xA0, 0xC3, 0x81, 0x3D, 0x17, 0x30, 0xE0, 0x84, 0x0E, 0x08, 0x40, 0xE0,
  0x84, 0x0E, 0x08, 0x40, 0xE0, 0x84, 0x0E, 0x08, 0x40, 0xE0, 0x84, 0x0E, 0x08, 0x48, 0x5E, 0xA4,
  0x43, 0x0E, 0xB0, 0xB0,
  // "ĺ" (U+013A)
  0x18, 0x90, 0x27, 0x20, 0xAC, 0x03, 0xD1, 0x69, 0x05, 0x29, 0x05, 0x29, 0x05, 0x29, 0x05, 0x29,
  0x05, 0x29, 0x05, 0x29, 0x05, 0x29, 0x05, 0x29, 0x05, 0x29, 0x05, 0x29, 0x05, 0x10,
  // "Ļ" (U+013B)
  0x0E, 0x08, 0x30, 0xE0, 0x83, 0x0E, 0x08, 0x30, 0xE0, 0x83, 0x0E, 0x08, 0x30, 0xE0, 0x83, 0x0E,
  0x08, 0x30, 0xE0, 0x83, 0x84, 0xEA, 0x44, 0x3E, 0xB0, 0xB2, 0x02, 0x30, 0x60, 0xD3, 0x09, 0x06,
  0x20,
  // "ļ" (U+013C)
  0x19, 0x8C, 0x55, 0x0F, 0x50, 0xF5, 0x0F, 0x50, 0xF5, 0x0F, 0x50, 0xF5, 0x0F, 0x50, 0xF5, 0x0F,
  0x50, 0xF5, 0x02, 0x06, 0xD0, 0x96, 0x10,
  // "Ľ" (U+013D)
  0x89, 0x7E, 0x80, 0x5E, 0xE8, 0x08, 0x8E, 0x80, 0x10, 0xE8, 0x30, 0xE0, 0x83, 0x0E, 0x08, 0x30,
  0xE0, 0x83, 0x0E, 0x08, 0x38, 0x4E, 0xA4, 0x43, 0xEB, 0x0B,
  // "ľ" (U+013E)
  0x98, 0x93, 0x55, 0xEF, 0x58, 0x8F, 0x51, 0x0F, 0x52, 0x90, 0x52, 0x90, 0x52, 0x90, 0x52, 0x90,
  0x52, 0x90, 0x52, 0x90, 0x52, 0x90, 0x52,
  // "Ŀ" (U+013F)
  0x0E, 0x08, 0x30, 0xE0, 0x83, 0x0E, 0x08, 0x38, 0x92, 0xE8, 0x4E, 0x0E, 0x80, 0x10, 0xE8, 0x30,
  0xE0, 0x83, 0x0E, 0x08, 0x38, 0x4E, 0xA4, 0x43, 0xEB, 0x0B,
  // "ŀ" (U+0140)
  0x98, 0xB5, 0x50, 0xF5, 0x0F, 0x50, 0xF5, 0x0F, 0xAE, 0xF5, 0x1F, 0x50, 0xF5, 0x0F, 0x50, 0xF5,
  0x0F, 0x51,
  // "Ł" (U+0141)
  0x10, 0xC0, 0x94, 0x0C, 0x09, 0x40, 0xC0, 0x94, 0x82, 0xC9, 0x43, 0x28, 0x7C, 0xEE, 0x50, 0x4E,
  0xC1, 0x28, 0x1A, 0xE9, 0x40, 0xC0, 0x94, 0x85, 0xCB, 0x44, 0x30, 0xCB, 0x0C,
  // "ł" (U+0142)
  0x20, 0xE0, 0x63, 0x0E, 0x06, 0x30, 0xE0, 0x63, 0x0E, 0x06, 0x38, 0x92, 0xEC, 0x70, 0x1E, 0xD3,
  0x1E, 0xF6, 0x28, 0x13, 0xE6, 0x30, 0xE0, 0x63, 0x0E, 0x06, 0x30, 0xE0, 0x61,
  // "Ń" (U+0143)
  0x38, 0x12, 0x72, 0x40, 0xA0, 0xC4, 0x81, 0x3D, 0x17, 0x28, 0x1E, 0xE1, 0x28, 0x36, 0xEE, 0xF8,
  0x28, 0xD4, 0x6E, 0xEC, 0xE1, 0x06, 0xEE, 0x7E, 0x70, 0x6E, 0xE6, 0x7E, 0x06, 0xEE, 0x61, 0xE7,
  0x6E, 0xE6, 0x08, 0xE6, 0xEE, 0x60, 0x1E, 0xCE, 0xE6, 0x28, 0x38, 0xFE, 0xE6, 0x28, 0x11, 0xEE,
  // "ń" (U+0144)
  0x28, 0x12, 0x72, 0x30, 0xA0, 0xC3, 0x81, 0x3D, 0x17, 0x19, 0x8D, 0x55, 0xDE, 0x70, 0xFD, 0x48,
  0xF1, 0xF7, 0x01, 0xF4, 0xF5, 0x01, 0xF4, 0xF5, 0x01, 0xF4, 0xF5, 0x01, 0xF4, 0xF5, 0x01, 0xF4,
  0xF5, 0x01, 0xF4,
  // "Ņ" (U+0145)
  0x81, 0xEE, 0x12, 0x83, 0x6E, 0xEF, 0x82, 0x8D, 0x46, 0xEE, 0xCE, 0x10, 0x6E, 0xE7, 0xE7, 0x06,
  0xEE, 0x67, 0xE0, 0x6E, 0xE6, 0x1E, 0x76, 0xEE, 0x60, 0x8E, 0x6E, 0xE6, 0x01, 0xEC, 0xEE, 0x62,
  0x83, 0x8F, 0xEE, 0x62, 0x81, 0x1E, 0xE3, 0x02, 0x50, 0x60, 0xD5, 0x09, 0x06, 0x30,
  // "ņ" (U+0146)
  0x98, 0xD5, 0x5D, 0xE7, 0x0F, 0xD4, 0x8F, 0x1F, 0x70, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F,
  0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F, 0x42, 0x02, 0x40, 0x60, 0xD4, 0x09, 0x06,
  0x30,
  // "Ň" (U+0147)
  0x18, 0x32, 0x50, 0x25, 0x38, 0x2D, 0x6D, 0x33, 0x81, 0x4F, 0x97, 0x28, 0x1E, 0xE1, 0x28, 0x36,
  0xEE, 0xF8, 0x28, 0xD4, 0x6E, 0xEC, 0xE1, 0x06, 0xEE, 0x7E, 0x70, 0x6E, 0xE6, 0x7E, 0x06, 0xEE,
  0x61, 0xE7, 0x6E, 0xE6, 0x08, 0xE6, 0xEE, 0x60, 0x1E, 0xCE, 0xE6, 0x28, 0x38, 0xFE, 0xE6, 0x28,
  0x11, 0xEE,
  // "ň" (U+0148)
  0x83, 0x25, 0x02, 0x52, 0x82, 0xD6, 0xD3, 0x28, 0x14, 0xF9, 0x71, 0x98, 0xD5, 0x5D, 0xE7, 0x0F,
  0xD4, 0x8F, 0x1F, 0x70, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50,
  0x1F, 0x4F, 0x50, 0x1F, 0x40,
  // "ŉ" (U+0149)
  0x81, 0x2F, 0x55, 0x05, 0x0E, 0x68, 0x58, 0x9F, 0x5D, 0xE7, 0x39, 0x83, 0xD4, 0x8F, 0x12, 0x98,
  0x37, 0x01, 0xF4, 0x29, 0x83, 0x50, 0x1F, 0x42, 0x98, 0x35, 0x01, 0xF4, 0x29, 0x83, 0x50, 0x1F,
  0x42, 0x98, 0x35, 0x01, 0xF4, 0x29, 0x83, 0x50, 0x1F, 0x40,
  // "Ŋ" (U+014A)
  0x81, 0xEE, 0x12, 0x83, 0x6E, 0xEF, 0x82, 0x8C, 0x56, 0xEE, 0xCF, 0x10, 0x6E, 0xE6, 0xD9, 0x06,
  0xEE, 0x65, 0xF2, 0x6E, 0xE6, 0x0C, 0xA6, 0xEE, 0x60, 0x4F, 0x9E, 0xE6, 0x28, 0x3B, 0xEE, 0xE6,
  0x28, 0x33, 0xFE, 0xE6, 0x30, 0xA0, 0xE5, 0x07, 0x0D, 0x50, 0x0B, 0x38, 0x25, 0xFE, 0x34, 0x02,
  0x20,
  // "ŋ" (U+014B)
  0x98, 0xD5, 0x5D, 0xE7, 0x0F, 0xD4, 0x8F, 0x1F, 0x70, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F,
  0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F, 0x43, 0x81, 0x1F, 0x42, 0x82, 0x16, 0xF3,
  0x28, 0x15, 0xFA, 0x10,
  // "Ō" (U+014C)
  0x20, 0x6B, 0x05, 0x30, 0x10, 0xF2, 0x48, 0x37, 0xDF, 0xC4, 0x28, 0x90, 0x7F, 0x74, 0x9F, 0x30,
  0xEA, 0x38, 0x3C, 0xA2, 0xF5, 0x38, 0x38, 0xE3, 0xF4, 0x38, 0x36, 0xF3, 0xF3, 0x38, 0x37, 0xF1,
  0xF5, 0x38, 0x38, 0xE0, 0xDA, 0x38, 0x90, 0xDA, 0x06, 0xF7, 0x49, 0xF3, 0x28, 0x36, 0xDF, 0xC4,
  0x10,
  // "ō" (U+014D)
  0x10, 0x6B, 0x05, 0x20, 0x10, 0xF2, 0x38, 0x32, 0xCF, 0xC2, 0x28, 0x96, 0xDB, 0x4A, 0xD0, 0x3F,
  0x30, 0x2F, 0x35, 0xF1, 0x29, 0x82, 0x55, 0xF1, 0x29, 0x89, 0x46, 0x3F, 0x30, 0x2F, 0x30, 0xDB,
  0x4A, 0xD2, 0x83, 0x2C, 0xFC, 0x21,
  // "Ŏ" (U+014E)
  0x28, 0x34, 0x81, 0x85, 0x38, 0x31, 0xDF, 0xD1, 0x50, 0x25, 0x83, 0x7D, 0xFC, 0x42, 0x89, 0x07,
  0xF7, 0x49, 0xF3, 0x0E, 0xA3, 0x83, 0xCA, 0x2F, 0x53, 0x83, 0x8E, 0x3F, 0x43, 0x83, 0x6F, 0x3F,
  0x33, 0x83, 0x7F, 0x1F, 0x53, 0x83, 0x8E, 0x0D, 0xA3, 0x89, 0x0D, 0xA0, 0x6F, 0x74, 0x9F, 0x32,
  0x83, 0x6D, 0xFC, 0x41,
  // "ŏ" (U+014F)
  0x18, 0x34, 0x81, 0x85, 0x28, 0x31, 0xDF, 0xD1, 0x40, 0x24, 0x83, 0x2C, 0xFC, 0x22, 0x89, 0x6D,
  0xB4, 0xAD, 0x03, 0xF3, 0x02, 0xF3, 0x5F, 0x12, 0x98, 0x25, 0x5F, 0x12, 0x98, 0x94, 0x63, 0xF3,
  0x02, 0xF3, 0x0D, 0xB4, 0xAD, 0x28, 0x32, 0xCF, 0xC2, 0x10,
  // "Ő" (U+0150)
  0x48, 0x12, 0x02, 0x48, 0x3A, 0xA6, 0xD1, 0x28, 0x33, 0xB1, 0xC2, 0x74, 0x83, 0x7D, 0xFC, 0x42,
  0x89, 0x07, 0xF7, 0x49, 0xF3, 0x0E, 0xA3, 0x83, 0xCA, 0x2F, 0x53, 0x83, 0x8E, 0x3F, 0x43, 0x83,
  0x6F, 0x3F, 0x33, 0x83, 0x7F, 0x1F, 0x53, 0x83, 0x8E, 0x0D, 0xA3, 0x89, 0x0D, 0xA0, 0x6F, 0x74,
  0x9F, 0x32, 0x83, 0x6D, 0xFC, 0x41,
  // "ő" (U+0151)
  0x38, 0x12, 0x02, 0x38, 0x91, 0xAA, 0x6D, 0x10, 0x3B, 0x1C, 0x27, 0x28, 0x32, 0xCF, 0xC2, 0x28,
  0x96, 0xDB, 0x4A, 0xD0, 0x3F, 0x30, 0x2F, 0x35, 0xF1, 0x29, 0x82, 0x55, 0xF1, 0x29, 0x89, 0x46,
  0x3F, 0x30, 0x2F, 0x30, 0xDB, 0x4A, 0xD2, 0x83, 0x2C, 0xFC, 0x21,
  // "Œ" (U+0152)
  0x20, 0x60, 0xDD, 0x89, 0x4C, 0x06, 0xF7, 0x3C, 0xB3, 0x32, 0x0D, 0xA2, 0x0B, 0x0A, 0x38, 0x11,
  0xF5, 0x20, 0xB0, 0xA3, 0x81, 0x3F, 0x42, 0x0B, 0xB8, 0x29, 0x3F, 0x42, 0x86, 0xBB, 0x22, 0x12,
  0xF5, 0x20, 0xB0, 0xA4, 0x0D, 0x0A, 0x20, 0xB0, 0xA4, 0x87, 0x6F, 0x83, 0xCB, 0x33, 0x22, 0x06,
  0x0D, 0xD0, 0xC0,
  // "œ" (U+0153)
  0x18, 0x73, 0xCF, 0xB1, 0x9E, 0xD4, 0x28, 0x97, 0xDB, 0x4B, 0xED, 0x48, 0xE0, 0x3F, 0x30, 0x3F,
  0x72, 0x98, 0x24, 0x5F, 0x12, 0xD8, 0x25, 0x5F, 0x12, 0x98, 0x92, 0x72, 0x22, 0x13, 0xF3, 0x03,
  0xF8, 0x58, 0x7C, 0xB4, 0xBE, 0xE5, 0x48, 0x28, 0x72, 0xCF, 0xB1, 0x8E, 0xEB, 0x10,
  // "Ŕ" (U+0154)
  0x28, 0x12, 0x72, 0x30, 0xA0, 0xC3, 0x81, 0x3D, 0x17, 0x10, 0xEA, 0x89, 0x1C, 0x50, 0xE9, 0x39,
  0xF3, 0xE8, 0x29, 0x81, 0x7E, 0x82, 0x87, 0xE7, 0xE8, 0x07, 0xF3, 0xEB, 0x8A, 0x46, 0x0E, 0x94,
  0xF4, 0x0E, 0x80, 0xAC, 0x0E, 0x80, 0x2F, 0x5E, 0x82, 0x0A, 0x0D,
  // "ŕ" (U+0155)
  0x18, 0x90, 0x27, 0x20, 0xAC, 0x03, 0xD1, 0x59, 0x87, 0x4D, 0xAF, 0xD5, 0x2F, 0x82, 0x90, 0x52,
  0x90, 0x52, 0x90, 0x52, 0x90, 0x52, 0x90, 0x52,
  // "Ŗ" (U+0156)
  0x0E, 0xA8, 0x91, 0xC5, 0x0E, 0x93, 0x9F, 0x3E, 0x82, 0x98, 0x17, 0xE8, 0x28, 0x7E, 0x7E, 0x80,
  0x7F, 0x3E, 0xB8, 0xA4, 0x60, 0xE9, 0x4F, 0x40, 0xE8, 0x0A, 0xC0, 0xE8, 0x02, 0xF5, 0xE8, 0x20,
  0xA0, 0xD3, 0x02, 0x40, 0x60, 0xD4, 0x09, 0x06, 0x20,
  // "ŗ" (U+0157)
  0x19, 0x89, 0x14, 0xDA, 0x0F, 0xD5, 0x20, 0xF8, 0x39, 0x05, 0x39, 0x05, 0x39, 0x05, 0x39, 0x05,
  0x39, 0x05, 0x30, 0x23, 0x06, 0x0D, 0x30, 0x90, 0x63,
  // "Ř" (U+0158)
  0x83, 0x25, 0x02, 0x52, 0x82, 0xD6, 0xD3, 0x28, 0x14, 0xF9, 0x71, 0x0E, 0xA8, 0x91, 0xC5, 0x0E,
  0x93, 0x9F, 0x3E, 0x82, 0x98, 0x17, 0xE8, 0x28, 0x7E, 0x7E, 0x80, 0x7F, 0x3E, 0xB8, 0xA4, 0x60,
  0xE9, 0x4F, 0x40, 0xE8, 0x0A, 0xC0, 0xE8, 0x02, 0xF5, 0xE8, 0x20, 0xA0, 0xD0,
  // "ř" (U+0159)
  0x89, 0x42, 0x50, 0x25, 0x0D, 0x6D, 0x30, 0x4F, 0x97, 0x98, 0x91, 0x4D, 0xA0, 0xFD, 0x52, 0x0F,
  0x83, 0x90, 0x53, 0x90, 0x53, 0x90, 0x53, 0x90, 0x53, 0x90, 0x52,
  // "Ś" (U+015A)
  0x38, 0x12, 0x72, 0x30, 0xA0, 0xC3, 0x81, 0x3D, 0x17, 0x18, 0x94, 0x4D, 0xFD, 0x71, 0xF9, 0x36,
  0x55, 0xF2, 0x38, 0x13, 0xF7, 0x48, 0x29, 0xFC, 0x33, 0x82, 0x4D, 0xF4, 0x40, 0x0C, 0x48, 0x93,
  0x9D, 0x47, 0x35, 0xE8, 0x4D, 0xFE, 0x91,
  // "ś" (U+015B)
  0x28, 0x12, 0x72, 0x20, 0xA0, 0xC2, 0x81, 0x3D, 0x17, 0x89, 0x29, 0xEE, 0x85, 0xE5, 0x55, 0x6E,
  0x12, 0x82, 0x1D, 0xE6, 0x38, 0x18, 0xF8, 0x38, 0x92, 0x7E, 0x56, 0x3B, 0xC5, 0xDF, 0xC3,
  // "Ŝ" (U+015C)
  0x28, 0x11, 0x73, 0x38, 0x18, 0xDD, 0x28, 0x33, 0xC0, 0x88, 0x78, 0x94, 0x4D, 0xFD, 0x71, 0xF9,
  0x36, 0x55, 0xF2, 0x38, 0x13, 0xF7, 0x48, 0x29, 0xFC, 0x33, 0x82, 0x4D, 0xF4, 0x40, 0x0C, 0x48,
  0x93, 0x9D, 0x47, 0x35, 0xE8, 0x4D, 0xFE, 0x91,
  // "ŝ" (U+015D)
  0x18, 0x11, 0x73, 0x28, 0x78, 0xDD, 0x03, 0xC0, 0x88, 0x68, 0x92, 0x9E, 0xE8, 0x5E, 0x55, 0x56,
  0xE1, 0x28, 0x21, 0xDE, 0x63, 0x81, 0x8F, 0x83, 0x89, 0x27, 0xE5, 0x63, 0xBC, 0x5D, 0xFC, 0x30,
  // "Ş" (U+015E)
  0x18, 0x94, 0x4D, 0xFD, 0x71, 0xF9, 0x36, 0x55, 0xF2, 0x38, 0x13, 0xF7, 0x48, 0x29, 0xFC, 0x33,
  0x82, 0x4D, 0xF4, 0x40, 0x0C, 0x48, 0x93, 0x9D, 0x47, 0x35, 0xE8, 0x4D, 0xFE, 0x93, 0x01, 0x05,
  0x48, 0x13, 0xC4, 0x38, 0x14, 0xB9, 0x38, 0x1D, 0xC3, 0x10,
  // "ş" (U+015F)
  0x18, 0x92, 0x9E, 0xE8, 0x5E, 0x55, 0x56, 0xE1, 0x28, 0x21, 0xDE, 0x63, 0x81, 0x8F, 0x83, 0x89,
  0x57, 0xE5, 0x63, 0xBC, 0x5D, 0xFC, 0x30, 0x15, 0x38, 0x13, 0xC4, 0x28, 0x14, 0xB9, 0x28, 0x1D,
  0xC3, 0x10,
  // "Š" (U+0160)
  0x18, 0x32, 0x50, 0x25, 0x28, 0x2D, 0x6D, 0x32, 0x81, 0x4F, 0x97, 0x18, 0x94, 0x4D, 0xFD, 0x71,
  0xF9, 0x36, 0x55, 0xF2, 0x38, 0x13, 0xF7, 0x48, 0x29, 0xFC, 0x33, 0x82, 0x4D, 0xF4, 0x40, 0x0C,
  0x48, 0x93, 0x9D, 0x47, 0x35, 0xE8, 0x4D, 0xFE, 0x91,
  // "š" (U+0161)
  0x89, 0x42, 0x50, 0x25, 0x0D, 0x6D, 0x30, 0x4F, 0x97, 0x89, 0x29, 0xEE, 0x85, 0xE5, 0x55, 0x6E,
  0x12, 0x82, 0x1D, 0xE6, 0x38, 0x18, 0xF8, 0x38, 0x92, 0x7E, 0x56, 0x3B, 0xC5, 0xDF, 0xC3,
  // "Ţ" (U+0162)
  0x0C, 0xD8, 0x51, 0x23, 0xAD, 0x33, 0x30, 0x90, 0xC5, 0x09, 0x0C, 0x50, 0x90, 0xC5, 0x09, 0x0C,
  0x50, 0x90, 0xC5, 0x09, 0x0C, 0x50, 0x90, 0xC5, 0x09, 0x0C, 0x50, 0x10, 0x55, 0x81, 0x3C, 0x44,
  0x81, 0x4B, 0x94, 0x81, 0xDC, 0x32,
  // "ţ" (U+0163)
  0x10, 0x40, 0x32, 0x82, 0xB6, 0x08, 0xB8, 0x52, 0xF8, 0x30, 0xF6, 0x29, 0x06, 0x29, 0x06, 0x29,
  0x06, 0x28, 0x90, 0xDA, 0x30, 0x6E, 0xD0, 0x15, 0x28, 0x91, 0x3C, 0x40, 0x4B, 0x90, 0xDC, 0x30,
  // "Ť" (U+0164)
  0x83, 0x25, 0x02, 0x53, 0x82, 0xD6, 0xD3, 0x38, 0x14, 0xF9, 0x73, 0x0C, 0xD8, 0x51, 0x23, 0xAD,
  0x33, 0x30, 0x90, 0xC5, 0x09, 0x0C, 0x50, 0x90, 0xC5, 0x09, 0x0C, 0x50, 0x90, 0xC5, 0x09, 0x0C,
  0x50, 0x90, 0xC5, 0x09, 0x0C, 0x30,
  // "ť" (U+0165)
  0x48, 0x95, 0x5E, 0x04, 0x30, 0x88, 0x0B, 0x60, 0x10, 0x8B, 0x28, 0x22, 0xF8, 0x33, 0x90, 0x64,
  0x90, 0x64, 0x90, 0x64, 0x90, 0x64, 0x81, 0xDA, 0x33, 0x81, 0x6E, 0xD2,
  // "Ŧ" (U+0166)
  0x0C, 0xD8, 0x51, 0x23, 0xAD, 0x33, 0x30, 0x90, 0xC5, 0x09, 0x0C, 0x30, 0x2C, 0x05, 0x28, 0x32,
  0xAD, 0x21, 0x30, 0x90, 0xC5, 0x09, 0x0C, 0x50, 0x90, 0xC5, 0x09, 0x0C, 0x30,
  // "ŧ" (U+0167)
  0x10, 0x40, 0x32, 0x82, 0xB6, 0x08, 0xB8, 0x72, 0xF8, 0x30, 0xF6, 0x0B, 0xA8, 0x6D, 0x2F, 0x82,
  0x0F, 0x62, 0x85, 0xDA, 0x30, 0x6E, 0xD0,
  // "Ũ" (U+0168)
  0x18, 0x91, 0xDB, 0x2C, 0x10, 0x4A, 0x7F, 0xB2, 0x82, 0x11, 0x01, 0x39, 0x06, 0x28, 0x31, 0xF5,
  0xF6, 0x28, 0x31, 0xF5, 0xF6, 0x28, 0x31, 0xF5, 0xF6, 0x28, 0x31, 0xF5, 0xF6, 0x28, 0x31, 0xF5,
  0xF6, 0x28, 0x31, 0xF5, 0xF6, 0x28, 0x31, 0xF4, 0xD8, 0x28, 0x73, 0xF3, 0x8E, 0x54, 0xCD, 0x28,
  0x39, 0xDE, 0xB2, 0x10,
  // "ũ" (U+0169)
  0x28, 0x91, 0xDB, 0x2C, 0x10, 0x4A, 0x7F, 0xB2, 0x82, 0x11, 0x01, 0x28, 0xE6, 0x1F, 0x40, 0x1F,
  0x41, 0xF4, 0x01, 0xF4, 0x1F, 0x40, 0x1F, 0x41, 0xF4, 0x01, 0xF4, 0x1F, 0x40, 0x1F, 0x40, 0xF5,
  0x03, 0xF4, 0x0D, 0xA2, 0xAF, 0x40, 0x4D, 0xD6, 0xD4,
  // "Ū" (U+016A)
  0x10, 0x6B, 0x05, 0x20, 0x10, 0xF2, 0x29, 0x06, 0x28, 0x31, 0xF5, 0xF6, 0x28, 0x31, 0xF5, 0xF6,
  0x28, 0x31, 0xF5, 0xF6, 0x28, 0x31, 0xF5, 0xF6, 0x28, 0x31, 0xF5, 0xF6, 0x28, 0x31, 0xF5, 0xF6,
  0x28, 0x31, 0xF4, 0xD8, 0x28, 0x73, 0xF3, 0x8E, 0x54, 0xCD, 0x28, 0x39, 0xDE, 0xB2, 0x10,
  // "ū" (U+016B)
  0x10, 0x6B, 0x05, 0x20, 0x10, 0xF2, 0x28, 0xE6, 0x1F, 0x40, 0x1F, 0x41, 0xF4, 0x01, 0xF4, 0x1F,
  0x40, 0x1F, 0x41, 0xF4, 0x01, 0xF4, 0x1F, 0x40, 0x1F, 0x40, 0xF5, 0x03, 0xF4, 0x0D, 0xA2, 0xAF,
  0x40, 0x4D, 0xD6, 0xD4,
  // "Ŭ" (U+016C)
  0x18, 0x34, 0x81, 0x85, 0x28, 0x31, 0xDF, 0xD1, 0x40, 0x23, 0x90, 0x62, 0x83, 0x1F, 0x5F, 0x62,
  0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x5F, 0x62,
  0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x4D, 0x82, 0x87, 0x3F, 0x38, 0xE5, 0x4C, 0xD2, 0x83, 0x9D,
  0xEB, 0x21,
  // "ŭ" (U+016D)
  0x18, 0x34, 0x81, 0x85, 0x28, 0x31, 0xDF, 0xD1, 0x40, 0x23, 0x8E, 0x61, 0xF4, 0x01, 0xF4, 0x1F,
  0x40, 0x1F, 0x41, 0xF4, 0x01, 0xF4, 0x1F, 0x40, 0x1F, 0x41, 0xF4, 0x01, 0xF4, 0x0F, 0x50, 0x3F,
  0x40, 0xDA, 0x2A, 0xF4, 0x04, 0xDD, 0x6D, 0x40,
  // "Ů" (U+016E)
  0x18, 0x21, 0xDE, 0x33, 0x82, 0x6A, 0x79, 0x38, 0x22, 0xEF, 0x54, 0x00, 0x13, 0x90, 0x62, 0x83,
  0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83,
  0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x4D, 0x82, 0x87, 0x3F, 0x38, 0xE5, 0x4C,
  0xD2, 0x83, 0x9D, 0xEB, 0x21,
  // "ů" (U+016F)
  0x28, 0x21, 0xDE, 0x33, 0x82, 0x6A, 0x79, 0x38, 0x22, 0xEF, 0x54, 0x00, 0x12, 0x8E, 0x61, 0xF4,
  0x01, 0xF4, 0x1F, 0x40, 0x1F, 0x41, 0xF4, 0x01, 0xF4, 0x1F, 0x40, 0x1F, 0x41, 0xF4, 0x01, 0xF4,
  0x0F, 0x50, 0x3F, 0x40, 0xDA, 0x2A, 0xF4, 0x04, 0xDD, 0x6D, 0x40,
  // "Ű" (U+0170)
  0x38, 0x12, 0x02, 0x38, 0x91, 0xAA, 0x6D, 0x10, 0x3B, 0x1C, 0x27, 0x19, 0x06, 0x28, 0x31, 0xF5,
  0xF6, 0x28, 0x31, 0xF5, 0xF6, 0x28, 0x31, 0xF5, 0xF6, 0x28, 0x31, 0xF5, 0xF6, 0x28, 0x31, 0xF5,
  0xF6, 0x28, 0x31, 0xF5, 0xF6, 0x28, 0x31, 0xF4, 0xD8, 0x28, 0x73, 0xF3, 0x8E, 0x54, 0xCD, 0x28,
  0x39, 0xDE, 0xB2, 0x10,
  // "ű" (U+0171)
  0x38, 0x12, 0x02, 0x38, 0x91, 0xAA, 0x6D, 0x10, 0x3B, 0x1C, 0x27, 0x18, 0xE6, 0x1F, 0x40, 0x1F,
  0x41, 0xF4, 0x01, 0xF4, 0x1F, 0x40, 0x1F, 0x41, 0xF4, 0x01, 0xF4, 0x1F, 0x40, 0x1F, 0x40, 0xF5,
  0x03, 0xF4, 0x0D, 0xA2, 0xAF, 0x40, 0x4D, 0xD6, 0xD4,
  // "Ų" (U+0172)
  0x90, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F,
  0x5F, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x5F, 0x62, 0x83, 0x1F, 0x4D, 0x82, 0x87, 0x3F,
  0x38, 0xE5, 0x4C, 0xC2, 0x83, 0x9D, 0xFD, 0x14, 0x09, 0x03, 0x50, 0xE0, 0x55, 0x81, 0xAE, 0x31,
  // "ų" (U+0173)
  0x8E, 0x61, 0xF4, 0x01, 0xF4, 0x1F, 0x40, 0x1F, 0x41, 0xF4, 0x01, 0xF4, 0x1F, 0x40, 0x1F, 0x41,
  0xF4, 0x01, 0xF4, 0x0F, 0x50, 0x3F, 0x40, 0xDA, 0x2A, 0xF4, 0x04, 0xDD, 0x6F, 0x64, 0x01, 0x0C,
  0x50, 0x60, 0xB5, 0x81, 0x3F, 0xC5, 0x00, 0x10,
  // "Ŵ" (U+0174)
  0x48, 0x11, 0x73, 0x71, 0x81, 0x8D, 0xD7, 0x83, 0x3C, 0x08, 0x87, 0x70, 0xC0, 0x92, 0x81, 0x3F,
  0x52, 0x82, 0x7E, 0x9C, 0x28, 0x16, 0xF9, 0x28, 0x1A, 0xB5, 0x92, 0x81, 0xAD, 0xC2, 0x8C, 0x0D,
  0x82, 0xF3, 0x0D, 0x8F, 0x01, 0xF5, 0x0E, 0x71, 0xF2, 0xF3, 0x4F, 0x10, 0xBA, 0x5D, 0x0B, 0x78,
  0xD2, 0x87, 0x7D, 0x8A, 0x08, 0xAB, 0xA2, 0x87, 0x4F, 0xB7, 0x04, 0xDD, 0x63, 0xA8, 0x13, 0x01,
  0xA0, 0x33, 0x0C, 0x93, 0x0D, 0x92,
  // "ŵ" (U+0175)
  0x38, 0x11, 0x73, 0x78, 0x18, 0xDD, 0x68, 0x33, 0xC0, 0x88, 0x76, 0x84, 0xB9, 0x01, 0xFA, 0x29,
  0x8B, 0x44, 0x8C, 0x04, 0xED, 0x03, 0xF1, 0x5F, 0x08, 0xAF, 0x17, 0xD0, 0x1F, 0x3B, 0x6D, 0x4A,
  0x92, 0x86, 0xD6, 0xE2, 0xA7, 0xD6, 0x28, 0x6A, 0xAE, 0x07, 0xBF, 0x22, 0x85, 0x7E, 0xB0, 0x4E,
  0xE3, 0x81, 0x3F, 0x82, 0x90, 0xB2,
  // "Ŷ" (U+0176)
  0x28, 0x11, 0x73, 0x48, 0x18, 0xDD, 0x38, 0x33, 0xC0, 0x88, 0x71, 0x0C, 0x0B, 0x28, 0x72, 0xF5,
  0x5F, 0x10, 0x8D, 0x28, 0x3E, 0x70, 0xE7, 0x28, 0x38, 0xD4, 0xF1, 0x28, 0x22, 0xFD, 0xA4, 0x81,
  0xBF, 0x34, 0x07, 0x95, 0x07, 0x95, 0x07, 0x95, 0x07, 0x93,
  // "ŷ" (U+0177)
  0x18, 0x11, 0x73, 0x38, 0x18, 0xDD, 0x28, 0x33, 0xC0, 0x88, 0x70, 0xC0, 0x92, 0x82, 0x8D, 0x7E,
  0x28, 0x93, 0xC8, 0x2F, 0x21, 0xF4, 0x0D, 0x75, 0xE2, 0x82, 0x8B, 0x9A, 0x28, 0x24, 0xED, 0x63,
  0x81, 0xEF, 0x13, 0x0A, 0x0C, 0x40, 0xD0, 0x82, 0x82, 0x38, 0xF2, 0x28, 0x1A, 0xE6, 0x30,
  // "Ÿ" (U+0178)
  0x18, 0x31, 0xE1, 0x97, 0x38, 0x11, 0x01, 0x20, 0xC0, 0xB2, 0x87, 0x2F, 0x55, 0xF1, 0x08, 0xD2,
  0x83, 0xE7, 0x0E, 0x72, 0x83, 0x8D, 0x4F, 0x12, 0x82, 0x2F, 0xDA, 0x48, 0x1B, 0xF3, 0x40, 0x79,
  0x50, 0x79, 0x50, 0x79, 0x50, 0x79, 0x30,
  // "Ź" (U+0179)
  0x38, 0x12, 0x72, 0x30, 0xA0, 0xC3, 0x81, 0x3D, 0x17, 0x08, 0xC8, 0x5A, 0x13, 0x34, 0xF7, 0x30,
  0x70, 0xE4, 0x0E, 0x07, 0x38, 0x17, 0xE1, 0x30, 0xE0, 0x83, 0x81, 0x6F, 0x13, 0x0D, 0x09, 0x38,
  0x55, 0xF5, 0x33, 0x29, 0xC0, 0xC0,
  // "ź" (U+017A)
  0x28, 0x12, 0x72, 0x20, 0xA0, 0xC2, 0x81, 0x3D, 0x16, 0x07, 0xB8, 0x4A, 0x13, 0x3F, 0x62, 0x07,
  0x0E, 0x30, 0xE0, 0x72, 0x81, 0x6E, 0x12, 0x0D, 0x08, 0x28, 0x45, 0xF4, 0x32, 0x9B, 0x0C,
  // "Ż" (U+017B)
  0x20, 0x40, 0xE5, 0x01, 0x71, 0x08, 0xC8, 0x5A, 0x13, 0x34, 0xF7, 0x30, 0x70, 0xE4, 0x0E, 0x07,
  0x38, 0x17, 0xE1, 0x30, 0xE0, 0x83, 0x81, 0x6F, 0x13, 0x0D, 0x09, 0x38, 0x55, 0xF5, 0x33, 0x29,
  0xC0, 0xC0,
  // "ż" (U+017C)
  0x10, 0x40, 0xE4, 0x01, 0x70, 0x7B, 0x84, 0xA1, 0x33, 0xF6, 0x20, 0x70, 0xE3, 0x0E, 0x07, 0x28,
  0x16, 0xE1, 0x20, 0xD0, 0x82, 0x84, 0x5F, 0x43, 0x29, 0xB0, 0xC0,
  // "Ž" (U+017D)
  0x83, 0x25, 0x02, 0x52, 0x82, 0xD6, 0xD3, 0x28, 0x14, 0xF9, 0x71, 0x08, 0xC8, 0x5A, 0x13, 0x34,
  0xF7, 0x30, 0x70, 0xE4, 0x0E, 0x07, 0x38, 0x17, 0xE1, 0x30, 0xE0, 0x83, 0x81, 0x6F, 0x13, 0x0D,
  0x09, 0x38, 0x55, 0xF5, 0x33, 0x29, 0xC0, 0xC0,
  // "ž" (U+017E)
  0x89, 0x42, 0x50, 0x25, 0x0D, 0x6D, 0x30, 0x4F, 0x96, 0x07, 0xB8, 0x4A, 0x13, 0x3F, 0x62, 0x07,
  0x0E, 0x30, 0xE0, 0x72, 0x81, 0x6E, 0x12, 0x0D, 0x08, 0x28, 0x45, 0xF4, 0x32, 0x9B, 0x0C,
  // "ſ" (U+017F)
  0x89, 0x04, 0xDE, 0x3C, 0xB4, 0x0E, 0x62, 0x90, 0x62, 0x90, 0x62, 0x90, 0x62, 0x90, 0x62, 0x90,
  0x62, 0x90, 0x62, 0x90, 0x62, 0x90, 0x62,
  // "Ω" (U+03A9)
  0x28, 0x37, 0xDF, 0xD6, 0x38, 0x57, 0xF7, 0x48, 0xF5, 0x20, 0xE0, 0x93, 0x84, 0xBC, 0x02, 0xF4,
  0x38, 0x46, 0xF0, 0x3F, 0x33, 0x84, 0x5F, 0x12, 0xF4, 0x30, 0x69, 0x20, 0xE0, 0x73, 0x09, 0x0C,
  0x20, 0x80, 0xC3, 0x89, 0x3D, 0x60, 0x13, 0xD7, 0x09, 0xC3, 0x19, 0xA8, 0x1C, 0x0E, 0xA0, 0x70,
  // "μ" (U+03BC)
  0x98, 0xD7, 0x50, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F, 0x4F, 0x50, 0x1F,
  0x4F, 0x60, 0x3F, 0x4F, 0xC4, 0xBF, 0x4F, 0xCE, 0x6D, 0x4F, 0x54, 0x90, 0x54, 0x90, 0x54,
  // "π" (U+03C0)
  0x0A, 0xE8, 0x96, 0x72, 0xBC, 0x34, 0xF6, 0x10, 0xAB, 0x01, 0xF4, 0x28, 0x4A, 0xB0, 0x1F, 0x42,
  0x84, 0xAB, 0x01, 0xF4, 0x28, 0x4A, 0xB0, 0x1F, 0x42, 0x0A, 0x0B, 0x29, 0x83, 0x71, 0x0A, 0xB2,
  0x81, 0x9F, 0x50,
  // "–" (U+2013)
  0x07, 0xD0, 0x70, 0x18, 0x01, 0x20, 0x10,
  // "—" (U+2014)
  0x07, 0xFD, 0x07, 0x01, 0x80, 0x90, 0x20, 0x10,
  // "€" (U+20AC)
  0x28, 0x91, 0x5D, 0xEC, 0x20, 0x4F, 0x73, 0x62, 0x0A, 0x0C, 0x40, 0xBC, 0x28, 0x32, 0xD9, 0x22,
  0x20, 0xBA, 0x0E, 0x0A, 0x30, 0xA0, 0xB5, 0x06, 0x0E, 0x68, 0x3E, 0xA3, 0x62, 0x28, 0x33, 0xCF,
  0xD2,
  // "₿" (U+20BF)
  0x18, 0x1C, 0x39, 0x38, 0x1C, 0x39, 0x20, 0xEA, 0x8A, 0x4D, 0x40, 0xE9, 0x3B, 0xE0, 0xE7, 0x05,
  0xF1, 0xE7, 0x0A, 0xD0, 0xEB, 0x8B, 0x14, 0x0E, 0x93, 0xAE, 0x0E, 0x70, 0x3F, 0x4E, 0x70, 0x3F,
  0x3E, 0x93, 0xAE, 0x0E, 0xA0, 0xD0, 0x42, 0x81, 0xC3, 0x93, 0x81, 0x51, 0x42,
  // "‘" (U+2018)
  0x18, 0x5C, 0x53, 0xF1, 0x8E, 0x10,
  // "’" (U+2019)
  0x86, 0x2F, 0x55, 0xE0, 0x89, 0x10,
  // "‚" (U+201A)
  0x86, 0x2F, 0x55, 0xE0, 0x89, 0x10,
  // "‛" (U+201B)
  0x87, 0x8E, 0x03, 0xF1, 0x0C, 0x50,
  // "“" (U+201C)
  0x18, 0x94, 0xC5, 0x3E, 0x3F, 0x1A, 0xA8, 0xE0, 0xE7,
  // "”" (U+201D)
  0x89, 0x52, 0xF5, 0x8D, 0x5E, 0x0B, 0x88, 0x90, 0xE2,
  // "„" (U+201E)
  0x89, 0x52, 0xF5, 0x8D, 0x5E, 0x0B, 0x88, 0x90, 0xE2,
  // "‟" (U+201F)
  0x89, 0x58, 0xE0, 0xE7, 0x3F, 0x1A, 0xA0, 0xC5, 0x3E,
  // "†" (U+2020)
  0x20, 0x59, 0x40, 0x40, 0xD4, 0x02, 0x0C, 0x28, 0x13, 0xFE, 0xA8, 0x5D, 0x01, 0x2B, 0x11, 0x20,
  0x20, 0xC4, 0x03, 0x0D, 0x40, 0x40, 0xD4, 0x04, 0x0E, 0x40, 0x59, 0x40, 0x69, 0x20,
  // "‡" (U+2021)
  0x20, 0x59, 0x40, 0x30, 0xD2, 0x89, 0x21, 0x55, 0xD4, 0x43, 0xCB, 0xEB, 0xB2, 0x03, 0x0D, 0x40,
  0x40, 0xE4, 0x03, 0x0D, 0x28, 0x92, 0x2A, 0x9E, 0x99, 0x17, 0x7D, 0x66, 0x20, 0x30, 0xD4, 0x05,
  0x92,
  // "•" (U+2022)
  0x81, 0x8E, 0xB1, 0xB0, 0x5B, 0x82, 0x58, 0xEB, 0x10,
  // "…" (U+2026)
  0x8A, 0x21, 0xD6, 0x1D, 0x60, 0x1D, 0x61, 0xD6, 0x1D, 0x60, 0x1D, 0x60,
  // "‰" (U+2030)
  0x18, 0x19, 0xE7, 0x20, 0x70, 0x97, 0x81, 0x3E, 0x59, 0x20, 0xD0, 0x37, 0x85, 0x6A, 0x0D, 0x35,
  0xC7, 0x18, 0x56, 0xA0, 0xD3, 0xB5, 0x71, 0x89, 0x44, 0xD2, 0xF4, 0xE2, 0xCC, 0x10, 0x9D, 0x52,
  0x89, 0x3C, 0xF9, 0x98, 0xA7, 0x89, 0x5C, 0x3E, 0x38, 0x93, 0x10, 0xE2, 0xC4, 0x4C, 0x79, 0x0F,
  0x23, 0x89, 0x26, 0xA0, 0xC4, 0x5C, 0x79, 0x0F, 0x23, 0x89, 0x1D, 0x40, 0xA9, 0xAA, 0x5D, 0x6E,
  0x30, 0x40, 0xD2, 0x86, 0x2D, 0xD2, 0x0A, 0xE6, 0x10,
  // "‹" (U+2039)
  0x28, 0x93, 0x52, 0x03, 0xF3, 0x1E, 0x80, 0x5F, 0x32, 0x0A, 0x0C, 0x30, 0xD0, 0x50,
  // "›" (U+203A)
  0x02, 0x06, 0x28, 0x11, 0xE5, 0x28, 0x94, 0x6E, 0x20, 0x1F, 0x70, 0xBB, 0x03, 0xE1, 0x10,
  // "⁄" (U+2044)
  0x50, 0x50, 0xC5, 0x0D, 0x03, 0x40, 0x60, 0xB5, 0x0E, 0x02, 0x40, 0x70, 0xA4, 0x81, 0x1E, 0x24,
  0x08, 0x09, 0x48, 0x12, 0xE1, 0x40, 0x90, 0x84, 0x02, 0x0E, 0x50,
  // "™" (U+2122)
  0x8D, 0x3B, 0xED, 0x7E, 0x50, 0x8A, 0x09, 0x40, 0xEA, 0x0C, 0xB0, 0x94, 0x0C, 0xC3, 0x9B, 0x09,
  0x40, 0xC7, 0xC3, 0xB0, 0x83, 0x0B, 0x2B, 0x1A,
  // "⅒" (U+2152)
  0x18, 0x15, 0xE4, 0x30, 0x50, 0xC6, 0x82, 0x3C, 0xD4, 0x30, 0xD0, 0x37, 0x10, 0xC0, 0x42, 0x06,
  0x0B, 0x72, 0x0C, 0x04, 0x20, 0xE0, 0x27, 0x28, 0x92, 0xC4, 0x07, 0xA5, 0xE4, 0x1B, 0xE7, 0x38,
  0x93, 0xC4, 0x1E, 0x5C, 0xD4, 0x7A, 0x1E, 0x14, 0x08, 0x09, 0x28, 0x5C, 0x49, 0x70, 0xC4, 0x38,
  0x12, 0xE1, 0x28, 0x5C, 0x49, 0x70, 0xC4, 0x30, 0x90, 0x83, 0x85, 0xC4, 0x6A, 0x1E, 0x12, 0x02,
  0x0E, 0x48, 0x4C, 0x40, 0xBE, 0x71,
  // "ﬁ" (U+FB01)
  0x18, 0x92, 0x3D, 0xE5, 0xE4, 0x0A, 0xC3, 0x12, 0x20, 0xC0, 0x84, 0x09, 0xA8, 0x94, 0xE0, 0xF5,
  0x2D, 0x93, 0x0F, 0x50, 0xD8, 0x29, 0x82, 0x50, 0xD8, 0x29, 0x82, 0x50, 0xD8, 0x29, 0x82, 0x50,
  0xD8, 0x29, 0x82, 0x50, 0xD8, 0x29, 0x82, 0x50, 0xD8, 0x29, 0x05,
  // "ﬂ" (U+FB02)
  0x18, 0x96, 0x3D, 0xE5, 0xF5, 0x0A, 0xC3, 0x1F, 0x50, 0xC8, 0x29, 0x05, 0x09, 0xA8, 0x94, 0xE0,
  0xF5, 0x2D, 0x93, 0x0F, 0x50, 0xD8, 0x29, 0x82, 0x50, 0xD8, 0x29, 0x82, 0x50, 0xD8, 0x29, 0x82,
  0x50, 0xD8, 0x29, 0x82, 0x50, 0xD8, 0x29, 0x82, 0x50, 0xD8, 0x29, 0x05,
};

const Font& font_NotoSans_CondensedMedium_14() {
  static SmoothFont font(font_NotoSans_CondensedMedium_14_data);
  return font;
}

}  // namespace roo_display
