#include "32.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-Condensed (Noto Sans Condensed)
// Generated on Thu Mar 30 23:43:40 CEST 2023
static const uint8_t font_NotoSans_Condensed_32_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x07, 0xD5,
  0xFA, 0xF9, 0x1E, 0x21, 0x19, 0xF8, 0x08, 0x04, 0x20, 0x07, 0x07, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x02, 0x01, 0x05, 0x17, 0x08, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x02, 0x10, 0x0A, 0x17, 0x0C, 0x00, 0x34, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x0F, 0x17, 0x11, 0x00, 0x59, // "#" (U+0023)
  0x00, 0x24, 0x01, 0xFF, 0x0D, 0x19, 0x0F, 0x00, 0xD8, // "$" (U+0024)
  0x00, 0x25, 0x01, 0x01, 0x15, 0x17, 0x17, 0x01, 0x5F, // "%" (U+0025)
  0x00, 0x26, 0x01, 0x01, 0x11, 0x17, 0x12, 0x02, 0x2A, // "&" (U+0026)
  0x00, 0x27, 0x02, 0x10, 0x04, 0x17, 0x07, 0x02, 0xC4, // "'" (U+0027)
  0x00, 0x28, 0x01, 0xFB, 0x08, 0x17, 0x09, 0x02, 0xD1, // "(" (U+0028)
  0x00, 0x29, 0x01, 0xFB, 0x07, 0x17, 0x09, 0x03, 0x29, // ")" (U+0029)
  0x00, 0x2A, 0x01, 0x0E, 0x0C, 0x19, 0x0E, 0x03, 0x80, // "*" (U+002A)
  0x00, 0x2B, 0x01, 0x05, 0x0D, 0x14, 0x0F, 0x03, 0xBC, // "+" (U+002B)
  0x00, 0x2C, 0x01, 0xFD, 0x05, 0x04, 0x08, 0x03, 0xF6, // "," (U+002C)
  0x00, 0x2D, 0x01, 0x09, 0x08, 0x0B, 0x09, 0x04, 0x0D, // "-" (U+002D)
  0x00, 0x2E, 0x02, 0x01, 0x05, 0x04, 0x08, 0x04, 0x13, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x0B, 0x17, 0x0C, 0x04, 0x1D, // "/" (U+002F)
  0x00, 0x30, 0x01, 0x01, 0x0D, 0x17, 0x0F, 0x04, 0x6F, // "0" (U+0030)
  0x00, 0x31, 0x02, 0x01, 0x09, 0x17, 0x0F, 0x04, 0xEE, // "1" (U+0031)
  0x00, 0x32, 0x01, 0x01, 0x0D, 0x17, 0x0F, 0x05, 0x2A, // "2" (U+0032)
  0x00, 0x33, 0x01, 0x01, 0x0D, 0x17, 0x0F, 0x05, 0x89, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x0E, 0x17, 0x0F, 0x05, 0xEF, // "4" (U+0034)
  0x00, 0x35, 0x01, 0x01, 0x0D, 0x17, 0x0F, 0x06, 0x5E, // "5" (U+0035)
  0x00, 0x36, 0x01, 0x01, 0x0D, 0x17, 0x0F, 0x06, 0xBD, // "6" (U+0036)
  0x00, 0x37, 0x01, 0x01, 0x0D, 0x17, 0x0F, 0x07, 0x31, // "7" (U+0037)
  0x00, 0x38, 0x01, 0x01, 0x0D, 0x17, 0x0F, 0x07, 0x83, // "8" (U+0038)
  0x00, 0x39, 0x01, 0x01, 0x0D, 0x17, 0x0F, 0x08, 0x00, // "9" (U+0039)
  0x00, 0x3A, 0x02, 0x01, 0x05, 0x12, 0x08, 0x08, 0x75, // ":" (U+003A)
  0x00, 0x3B, 0x01, 0xFD, 0x05, 0x12, 0x08, 0x08, 0x8C, // ";" (U+003B)
  0x00, 0x3C, 0x01, 0x05, 0x0D, 0x13, 0x0F, 0x08, 0xB1, // "<" (U+003C)
  0x00, 0x3D, 0x01, 0x08, 0x0D, 0x11, 0x0F, 0x08, 0xF4, // "=" (U+003D)
  0x00, 0x3E, 0x01, 0x05, 0x0D, 0x13, 0x0F, 0x09, 0x0B, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x0A, 0x17, 0x0B, 0x09, 0x4D, // "?" (U+003F)
  0x00, 0x40, 0x01, 0xFE, 0x15, 0x17, 0x17, 0x09, 0x98, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x0F, 0x17, 0x10, 0x0A, 0x77, // "A" (U+0041)
  0x00, 0x42, 0x02, 0x01, 0x0F, 0x17, 0x11, 0x0A, 0xEE, // "B" (U+0042)
  0x00, 0x43, 0x01, 0x01, 0x0F, 0x17, 0x10, 0x0B, 0x71, // "C" (U+0043)
  0x00, 0x44, 0x02, 0x01, 0x10, 0x17, 0x13, 0x0B, 0xCF, // "D" (U+0044)
  0x00, 0x45, 0x02, 0x01, 0x0C, 0x17, 0x0E, 0x0C, 0x53, // "E" (U+0045)
  0x00, 0x46, 0x02, 0x01, 0x0C, 0x17, 0x0E, 0x0C, 0xA0, // "F" (U+0046)
  0x00, 0x47, 0x01, 0x01, 0x11, 0x17, 0x13, 0x0C, 0xEA, // "G" (U+0047)
  0x00, 0x48, 0x02, 0x01, 0x10, 0x17, 0x13, 0x0D, 0x6A, // "H" (U+0048)
  0x00, 0x49, 0x01, 0x01, 0x08, 0x17, 0x0A, 0x0D, 0xE5, // "I" (U+0049)
  0x00, 0x4A, 0xFE, 0xFA, 0x05, 0x17, 0x08, 0x0E, 0x2B, // "J" (U+004A)
  0x00, 0x4B, 0x02, 0x01, 0x0F, 0x17, 0x10, 0x0E, 0x87, // "K" (U+004B)
  0x00, 0x4C, 0x02, 0x01, 0x0C, 0x17, 0x0D, 0x0F, 0x0D, // "L" (U+004C)
  0x00, 0x4D, 0x02, 0x01, 0x16, 0x17, 0x19, 0x0F, 0x54, // "M" (U+004D)
  0x00, 0x4E, 0x02, 0x01, 0x11, 0x17, 0x14, 0x10, 0x2B, // "N" (U+004E)
  0x00, 0x4F, 0x01, 0x01, 0x12, 0x17, 0x14, 0x10, 0xCF, // "O" (U+004F)
  0x00, 0x50, 0x02, 0x01, 0x0E, 0x17, 0x10, 0x11, 0x5F, // "P" (U+0050)
  0x00, 0x51, 0x01, 0xFB, 0x12, 0x17, 0x14, 0x11, 0xCB, // "Q" (U+0051)
  0x00, 0x52, 0x02, 0x01, 0x0F, 0x17, 0x10, 0x12, 0x70, // "R" (U+0052)
  0x00, 0x53, 0x01, 0x01, 0x0D, 0x17, 0x0F, 0x12, 0xF5, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x0D, 0x17, 0x0E, 0x13, 0x59, // "T" (U+0054)
  0x00, 0x55, 0x02, 0x01, 0x10, 0x17, 0x13, 0x13, 0xAD, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x0F, 0x17, 0x10, 0x14, 0x2D, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x18, 0x17, 0x19, 0x14, 0xA8, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x0E, 0x17, 0x0F, 0x15, 0x81, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x0D, 0x17, 0x0E, 0x15, 0xFE, // "Y" (U+0059)
  0x00, 0x5A, 0x01, 0x01, 0x0C, 0x17, 0x0E, 0x16, 0x66, // "Z" (U+005A)
  0x00, 0x5B, 0x02, 0xFB, 0x09, 0x17, 0x0A, 0x16, 0xB6, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x0B, 0x17, 0x0C, 0x17, 0x0E, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0xFB, 0x07, 0x17, 0x0A, 0x17, 0x5E, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x0B, 0x0E, 0x18, 0x0F, 0x17, 0xB6, // "^" (U+005E)
  0x00, 0x5F, 0xFF, 0xFC, 0x0E, 0xFE, 0x0E, 0x17, 0xFE, // "_" (U+005F)
  0x00, 0x60, 0x01, 0x15, 0x07, 0x1A, 0x09, 0x18, 0x07, // "`" (U+0060)
  0x00, 0x61, 0x01, 0x01, 0x0C, 0x12, 0x0F, 0x18, 0x1A, // "a" (U+0061)
  0x00, 0x62, 0x02, 0x01, 0x0E, 0x19, 0x10, 0x18, 0x75, // "b" (U+0062)
  0x00, 0x63, 0x01, 0x01, 0x0B, 0x12, 0x0C, 0x18, 0xF4, // "c" (U+0063)
  0x00, 0x64, 0x01, 0x01, 0x0D, 0x19, 0x10, 0x19, 0x39, // "d" (U+0064)
  0x00, 0x65, 0x01, 0x01, 0x0D, 0x12, 0x0F, 0x19, 0xA5, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x09, 0x1A, 0x09, 0x19, 0xF9, // "f" (U+0066)
  0x00, 0x67, 0x01, 0xF9, 0x0D, 0x12, 0x10, 0x1A, 0x4F, // "g" (U+0067)
  0x00, 0x68, 0x02, 0x01, 0x0D, 0x19, 0x10, 0x1A, 0xCD, // "h" (U+0068)
  0x00, 0x69, 0x02, 0x01, 0x05, 0x19, 0x07, 0x1B, 0x40, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xF9, 0x05, 0x19, 0x07, 0x1B, 0x71, // "j" (U+006A)
  0x00, 0x6B, 0x02, 0x01, 0x0D, 0x19, 0x0E, 0x1B, 0xCF, // "k" (U+006B)
  0x00, 0x6C, 0x02, 0x01, 0x04, 0x19, 0x07, 0x1C, 0x4C, // "l" (U+006C)
  0x00, 0x6D, 0x02, 0x01, 0x16, 0x12, 0x18, 0x1C, 0x74, // "m" (U+006D)
  0x00, 0x6E, 0x02, 0x01, 0x0D, 0x12, 0x10, 0x1D, 0x0E, // "n" (U+006E)
  0x00, 0x6F, 0x01, 0x01, 0x0E, 0x12, 0x10, 0x1D, 0x68, // "o" (U+006F)
  0x00, 0x70, 0x02, 0xF9, 0x0E, 0x12, 0x10, 0x1D, 0xCD, // "p" (U+0070)
  0x00, 0x71, 0x01, 0xF9, 0x0D, 0x12, 0x10, 0x1E, 0x4E, // "q" (U+0071)
  0x00, 0x72, 0x02, 0x01, 0x0A, 0x12, 0x0B, 0x1E, 0xBB, // "r" (U+0072)
  0x00, 0x73, 0x01, 0x01, 0x0A, 0x12, 0x0C, 0x1E, 0xF7, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x08, 0x16, 0x09, 0x1F, 0x3D, // "t" (U+0074)
  0x00, 0x75, 0x02, 0x01, 0x0D, 0x12, 0x10, 0x1F, 0x86, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x0C, 0x12, 0x0D, 0x1F, 0xE0, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x14, 0x12, 0x15, 0x20, 0x3A, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x0C, 0x12, 0x0D, 0x20, 0xD8, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xF9, 0x0C, 0x12, 0x0D, 0x21, 0x37, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x0A, 0x12, 0x0B, 0x21, 0xAD, // "z" (U+007A)
  0x00, 0x7B, 0x01, 0xFB, 0x0A, 0x17, 0x0C, 0x21, 0xEB, // "{" (U+007B)
  0x00, 0x7C, 0x06, 0xF9, 0x08, 0x19, 0x0E, 0x22, 0x4E, // "|" (U+007C)
  0x00, 0x7D, 0x01, 0xFB, 0x0A, 0x17, 0x0C, 0x22, 0x80, // "}" (U+007D)
  0x00, 0x7E, 0x01, 0x0B, 0x0D, 0x0F, 0x0F, 0x22, 0xE0, // "~" (U+007E)
  0x00, 0xA1, 0x02, 0xFB, 0x05, 0x12, 0x08, 0x22, 0xFC, // "¡" (U+00A1)
  0x00, 0xA2, 0x02, 0x01, 0x0C, 0x17, 0x0F, 0x23, 0x30, // "¢" (U+00A2)
  0x00, 0xA3, 0x01, 0x01, 0x0D, 0x17, 0x0F, 0x23, 0x85, // "£" (U+00A3)
  0x00, 0xA4, 0x02, 0x04, 0x0F, 0x13, 0x12, 0x23, 0xE1, // "¤" (U+00A4)
  0x00, 0xA5, 0x01, 0x01, 0x0D, 0x17, 0x0F, 0x24, 0x3E, // "¥" (U+00A5)
  0x00, 0xA6, 0x06, 0xF9, 0x08, 0x19, 0x0E, 0x24, 0xA7, // "¦" (U+00A6)
  0x00, 0xA7, 0x01, 0x01, 0x0B, 0x19, 0x0D, 0x24, 0xD0, // "§" (U+00A7)
  0x00, 0xA8, 0x04, 0x15, 0x0C, 0x17, 0x11, 0x25, 0x43, // "¨" (U+00A8)
  0x00, 0xA9, 0x01, 0x01, 0x18, 0x19, 0x1B, 0x25, 0x52, // "©" (U+00A9)
  0x00, 0xAA, 0x01, 0x0D, 0x08, 0x17, 0x0A, 0x26, 0x27, // "ª" (U+00AA)
  0x00, 0xAB, 0x01, 0x03, 0x0D, 0x0F, 0x0F, 0x26, 0x56, // "«" (U+00AB)
  0x00, 0xAC, 0x01, 0x04, 0x0D, 0x0D, 0x0F, 0x26, 0xA9, // "¬" (U+00AC)
  0x00, 0xAE, 0x01, 0x01, 0x18, 0x19, 0x1B, 0x26, 0xCC, // "®" (U+00AE)
  0x00, 0xAF, 0xFF, 0x1A, 0x0E, 0x1C, 0x0F, 0x27, 0xA3, // "¯" (U+00AF)
  0x00, 0xB0, 0x01, 0x10, 0x0A, 0x19, 0x0C, 0x27, 0xAD, // "°" (U+00B0)
  0x00, 0xB1, 0x01, 0x01, 0x0D, 0x14, 0x0F, 0x27, 0xDA, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x0E, 0x08, 0x1B, 0x0A, 0x28, 0x1F, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x0E, 0x09, 0x1B, 0x0A, 0x28, 0x52, // "³" (U+00B3)
  0x00, 0xB4, 0x01, 0x15, 0x07, 0x1A, 0x09, 0x28, 0x8E, // "´" (U+00B4)
  0x00, 0xB5, 0x02, 0xF9, 0x0D, 0x12, 0x10, 0x28, 0xA2, // "µ" (U+00B5)
  0x00, 0xB6, 0x01, 0xFC, 0x0E, 0x19, 0x11, 0x29, 0x15, // "¶" (U+00B6)
  0x00, 0xB7, 0x02, 0x0B, 0x05, 0x0E, 0x08, 0x29, 0xB1, // "·" (U+00B7)
  0x00, 0xB8, 0x00, 0xF9, 0x06, 0x00, 0x07, 0x29, 0xBB, // "¸" (U+00B8)
  0x00, 0xB9, 0x01, 0x0E, 0x07, 0x1B, 0x0A, 0x29, 0xD5, // "¹" (U+00B9)
  0x00, 0xBA, 0x01, 0x0D, 0x09, 0x17, 0x0B, 0x29, 0xF9, // "º" (U+00BA)
  0x00, 0xBB, 0x01, 0x03, 0x0D, 0x0F, 0x0F, 0x2A, 0x2B, // "»" (U+00BB)
  0x00, 0xBC, 0x01, 0x01, 0x16, 0x17, 0x17, 0x2A, 0x7D, // "¼" (U+00BC)
  0x00, 0xBD, 0x01, 0x01, 0x16, 0x17, 0x18, 0x2B, 0x36, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x17, 0x18, 0x18, 0x2B, 0xE8, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFB, 0x0A, 0x11, 0x0B, 0x2C, 0xB1, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x0F, 0x1F, 0x10, 0x2C, 0xFB, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x0F, 0x1F, 0x10, 0x2D, 0x8A, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x0F, 0x1F, 0x10, 0x2E, 0x1A, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x0F, 0x1D, 0x10, 0x2E, 0xB1, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x0F, 0x1C, 0x10, 0x2F, 0x43, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x0F, 0x1D, 0x10, 0x2F, 0xCE, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x14, 0x17, 0x16, 0x30, 0x62, // "Æ" (U+00C6)
  0x00, 0xC7, 0x01, 0xF9, 0x0F, 0x17, 0x10, 0x30, 0xEE, // "Ç" (U+00C7)
  0x00, 0xC8, 0x02, 0x01, 0x0C, 0x1F, 0x0E, 0x31, 0x6B, // "È" (U+00C8)
  0x00, 0xC9, 0x02, 0x01, 0x0C, 0x1F, 0x0E, 0x31, 0xCF, // "É" (U+00C9)
  0x00, 0xCA, 0x02, 0x01, 0x0C, 0x1F, 0x0E, 0x32, 0x31, // "Ê" (U+00CA)
  0x00, 0xCB, 0x02, 0x01, 0x0C, 0x1C, 0x0E, 0x32, 0x9B, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x08, 0x1F, 0x0A, 0x32, 0xFB, // "Ì" (U+00CC)
  0x00, 0xCD, 0x01, 0x01, 0x0A, 0x1F, 0x0A, 0x33, 0x57, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x09, 0x1F, 0x0A, 0x33, 0xB5, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x08, 0x1C, 0x0A, 0x34, 0x19, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x10, 0x17, 0x13, 0x34, 0x71, // "Ð" (U+00D0)
  0x00, 0xD1, 0x02, 0x01, 0x11, 0x1D, 0x14, 0x34, 0xFD, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x01, 0x01, 0x12, 0x1F, 0x14, 0x35, 0xBD, // "Ò" (U+00D2)
  0x00, 0xD3, 0x01, 0x01, 0x12, 0x1F, 0x14, 0x36, 0x67, // "Ó" (U+00D3)
  0x00, 0xD4, 0x01, 0x01, 0x12, 0x1F, 0x14, 0x37, 0x0F, // "Ô" (U+00D4)
  0x00, 0xD5, 0x01, 0x01, 0x12, 0x1D, 0x14, 0x37, 0xBF, // "Õ" (U+00D5)
  0x00, 0xD6, 0x01, 0x01, 0x12, 0x1C, 0x14, 0x38, 0x6B, // "Ö" (U+00D6)
  0x00, 0xD7, 0x01, 0x06, 0x0D, 0x12, 0x0F, 0x39, 0x0F, // "×" (U+00D7)
  0x00, 0xD8, 0x01, 0x00, 0x12, 0x18, 0x14, 0x39, 0x52, // "Ø" (U+00D8)
  0x00, 0xD9, 0x02, 0x01, 0x10, 0x1F, 0x13, 0x3A, 0x0B, // "Ù" (U+00D9)
  0x00, 0xDA, 0x02, 0x01, 0x10, 0x1F, 0x13, 0x3A, 0xA4, // "Ú" (U+00DA)
  0x00, 0xDB, 0x02, 0x01, 0x10, 0x1F, 0x13, 0x3B, 0x3D, // "Û" (U+00DB)
  0x00, 0xDC, 0x02, 0x01, 0x10, 0x1C, 0x13, 0x3B, 0xDD, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x0D, 0x1F, 0x0E, 0x3C, 0x71, // "Ý" (U+00DD)
  0x00, 0xDE, 0x02, 0x01, 0x0E, 0x17, 0x10, 0x3C, 0xF2, // "Þ" (U+00DE)
  0x00, 0xDF, 0x02, 0x01, 0x0F, 0x1A, 0x10, 0x3D, 0x5F, // "ß" (U+00DF)
  0x00, 0xE0, 0x01, 0x01, 0x0C, 0x1A, 0x0F, 0x3D, 0xF8, // "à" (U+00E0)
  0x00, 0xE1, 0x01, 0x01, 0x0C, 0x1A, 0x0F, 0x3E, 0x6B, // "á" (U+00E1)
  0x00, 0xE2, 0x01, 0x01, 0x0C, 0x1A, 0x0F, 0x3E, 0xDC, // "â" (U+00E2)
  0x00, 0xE3, 0x01, 0x01, 0x0C, 0x18, 0x0F, 0x3F, 0x54, // "ã" (U+00E3)
  0x00, 0xE4, 0x01, 0x01, 0x0C, 0x17, 0x0F, 0x3F, 0xC9, // "ä" (U+00E4)
  0x00, 0xE5, 0x01, 0x01, 0x0C, 0x1B, 0x0F, 0x40, 0x37, // "å" (U+00E5)
  0x00, 0xE6, 0x01, 0x01, 0x15, 0x12, 0x17, 0x40, 0xB2, // "æ" (U+00E6)
  0x00, 0xE7, 0x01, 0xF9, 0x0B, 0x12, 0x0C, 0x41, 0x3A, // "ç" (U+00E7)
  0x00, 0xE8, 0x01, 0x01, 0x0D, 0x1A, 0x0F, 0x41, 0x9C, // "è" (U+00E8)
  0x00, 0xE9, 0x01, 0x01, 0x0D, 0x1A, 0x0F, 0x42, 0x08, // "é" (U+00E9)
  0x00, 0xEA, 0x01, 0x01, 0x0D, 0x1A, 0x0F, 0x42, 0x75, // "ê" (U+00EA)
  0x00, 0xEB, 0x01, 0x01, 0x0D, 0x17, 0x0F, 0x42, 0xE8, // "ë" (U+00EB)
  0x00, 0xEC, 0xFF, 0x01, 0x05, 0x1A, 0x07, 0x43, 0x50, // "ì" (U+00EC)
  0x00, 0xED, 0x02, 0x01, 0x08, 0x1A, 0x07, 0x43, 0x9B, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x08, 0x1A, 0x07, 0x43, 0xE6, // "î" (U+00EE)
  0x00, 0xEF, 0xFF, 0x01, 0x07, 0x17, 0x07, 0x44, 0x39, // "ï" (U+00EF)
  0x00, 0xF0, 0x01, 0x01, 0x0E, 0x1A, 0x10, 0x44, 0x80, // "ð" (U+00F0)
  0x00, 0xF1, 0x02, 0x01, 0x0D, 0x18, 0x10, 0x45, 0x05, // "ñ" (U+00F1)
  0x00, 0xF2, 0x01, 0x01, 0x0E, 0x1A, 0x10, 0x45, 0x79, // "ò" (U+00F2)
  0x00, 0xF3, 0x01, 0x01, 0x0E, 0x1A, 0x10, 0x45, 0xF6, // "ó" (U+00F3)
  0x00, 0xF4, 0x01, 0x01, 0x0E, 0x1A, 0x10, 0x46, 0x73, // "ô" (U+00F4)
  0x00, 0xF5, 0x01, 0x01, 0x0E, 0x18, 0x10, 0x46, 0xF6, // "õ" (U+00F5)
  0x00, 0xF6, 0x01, 0x01, 0x0E, 0x17, 0x10, 0x47, 0x76, // "ö" (U+00F6)
  0x00, 0xF7, 0x01, 0x05, 0x0D, 0x14, 0x0F, 0x47, 0xEE, // "÷" (U+00F7)
  0x00, 0xF8, 0x01, 0xFF, 0x0E, 0x13, 0x10, 0x48, 0x14, // "ø" (U+00F8)
  0x00, 0xF9, 0x02, 0x01, 0x0D, 0x1A, 0x10, 0x48, 0x98, // "ù" (U+00F9)
  0x00, 0xFA, 0x02, 0x01, 0x0D, 0x1A, 0x10, 0x49, 0x0A, // "ú" (U+00FA)
  0x00, 0xFB, 0x02, 0x01, 0x0D, 0x1A, 0x10, 0x49, 0x7B, // "û" (U+00FB)
  0x00, 0xFC, 0x02, 0x01, 0x0D, 0x17, 0x10, 0x49, 0xF3, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xF9, 0x0C, 0x1A, 0x0D, 0x4A, 0x61, // "ý" (U+00FD)
  0x00, 0xFE, 0x02, 0xF9, 0x0E, 0x19, 0x10, 0x4A, 0xF0, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xF9, 0x0C, 0x17, 0x0D, 0x4B, 0x8A, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x0F, 0x1D, 0x10, 0x4C, 0x14, // "Ā" (U+0100)
  0x01, 0x01, 0x01, 0x01, 0x0C, 0x17, 0x0F, 0x4C, 0x98, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x0F, 0x1F, 0x10, 0x4C, 0xFF, // "Ă" (U+0102)
  0x01, 0x03, 0x01, 0x01, 0x0C, 0x19, 0x0F, 0x4D, 0x92, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFA, 0x10, 0x17, 0x10, 0x4E, 0x07, // "Ą" (U+0104)
  0x01, 0x05, 0x01, 0xFA, 0x0D, 0x12, 0x0F, 0x4E, 0x9A, // "ą" (U+0105)
  0x01, 0x06, 0x01, 0x01, 0x0F, 0x20, 0x10, 0x4F, 0x13, // "Ć" (U+0106)
  0x01, 0x07, 0x01, 0x01, 0x0B, 0x1A, 0x0C, 0x4F, 0x89, // "ć" (U+0107)
  0x01, 0x08, 0x01, 0x01, 0x0F, 0x20, 0x10, 0x4F, 0xE3, // "Ĉ" (U+0108)
  0x01, 0x09, 0x01, 0x01, 0x0C, 0x1A, 0x0C, 0x50, 0x60, // "ĉ" (U+0109)
  0x01, 0x0A, 0x01, 0x01, 0x0F, 0x1F, 0x10, 0x50, 0xC7, // "Ċ" (U+010A)
  0x01, 0x0B, 0x01, 0x01, 0x0B, 0x19, 0x0C, 0x51, 0x35, // "ċ" (U+010B)
  0x01, 0x0C, 0x01, 0x01, 0x0F, 0x20, 0x10, 0x51, 0x88, // "Č" (U+010C)
  0x01, 0x0D, 0x01, 0x01, 0x0C, 0x1A, 0x0C, 0x52, 0x06, // "č" (U+010D)
  0x01, 0x0E, 0x02, 0x01, 0x10, 0x20, 0x13, 0x52, 0x6F, // "Ď" (U+010E)
  0x01, 0x0F, 0x01, 0x01, 0x13, 0x19, 0x10, 0x53, 0x14, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x10, 0x17, 0x13, 0x53, 0x96, // "Đ" (U+0110)
  0x01, 0x11, 0x01, 0x01, 0x0F, 0x19, 0x10, 0x54, 0x22, // "đ" (U+0111)
  0x01, 0x12, 0x02, 0x01, 0x0C, 0x1D, 0x0E, 0x54, 0x96, // "Ē" (U+0112)
  0x01, 0x13, 0x01, 0x01, 0x0D, 0x17, 0x0F, 0x54, 0xF0, // "ē" (U+0113)
  0x01, 0x14, 0x02, 0x01, 0x0C, 0x1F, 0x0E, 0x55, 0x51, // "Ĕ" (U+0114)
  0x01, 0x15, 0x01, 0x01, 0x0D, 0x19, 0x0F, 0x55, 0xB9, // "ĕ" (U+0115)
  0x01, 0x16, 0x02, 0x01, 0x0C, 0x1F, 0x0E, 0x56, 0x28, // "Ė" (U+0116)
  0x01, 0x17, 0x01, 0x01, 0x0D, 0x19, 0x0F, 0x56, 0x84, // "ė" (U+0117)
  0x01, 0x18, 0x02, 0xFA, 0x0D, 0x17, 0x0E, 0x56, 0xE8, // "Ę" (U+0118)
  0x01, 0x19, 0x01, 0xF9, 0x0D, 0x12, 0x0F, 0x57, 0x59, // "ę" (U+0119)
  0x01, 0x1A, 0x02, 0x01, 0x0C, 0x20, 0x0E, 0x57, 0xC9, // "Ě" (U+011A)
  0x01, 0x1B, 0x01, 0x01, 0x0D, 0x1A, 0x0F, 0x58, 0x34, // "ě" (U+011B)
  0x01, 0x1C, 0x01, 0x01, 0x11, 0x20, 0x13, 0x58, 0xA7, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x01, 0xF9, 0x0D, 0x1A, 0x10, 0x59, 0x47, // "ĝ" (U+011D)
  0x01, 0x1E, 0x01, 0x01, 0x11, 0x1F, 0x13, 0x59, 0xE4, // "Ğ" (U+011E)
  0x01, 0x1F, 0x01, 0xF9, 0x0D, 0x19, 0x10, 0x5A, 0x80, // "ğ" (U+011F)
  0x01, 0x20, 0x01, 0x01, 0x11, 0x1F, 0x13, 0x5B, 0x19, // "Ġ" (U+0120)
  0x01, 0x21, 0x01, 0xF9, 0x0D, 0x19, 0x10, 0x5B, 0xA9, // "ġ" (U+0121)
  0x01, 0x22, 0x01, 0xFA, 0x11, 0x17, 0x13, 0x5C, 0x37, // "Ģ" (U+0122)
  0x01, 0x23, 0x01, 0xF9, 0x0D, 0x19, 0x10, 0x5C, 0xCA, // "ģ" (U+0123)
  0x01, 0x24, 0x02, 0x01, 0x10, 0x20, 0x13, 0x5D, 0x5B, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x0D, 0x21, 0x10, 0x5D, 0xF6, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x13, 0x17, 0x13, 0x5E, 0x9C, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x0D, 0x19, 0x10, 0x5F, 0x21, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x09, 0x1E, 0x0A, 0x5F, 0xAB, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFE, 0x01, 0x08, 0x18, 0x07, 0x60, 0x0D, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x08, 0x1D, 0x0A, 0x60, 0x65, // "Ī" (U+012A)
  0x01, 0x2B, 0xFF, 0x01, 0x07, 0x17, 0x07, 0x60, 0xB7, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x08, 0x1F, 0x0A, 0x60, 0xF8, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFF, 0x01, 0x07, 0x19, 0x07, 0x61, 0x57, // "ĭ" (U+012D)
  0x01, 0x2E, 0x01, 0xFA, 0x08, 0x17, 0x0A, 0x61, 0xA4, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFA, 0x05, 0x19, 0x07, 0x62, 0x01, // "į" (U+012F)
  0x01, 0x30, 0x01, 0x01, 0x08, 0x1F, 0x0A, 0x62, 0x58, // "İ" (U+0130)
  0x01, 0x31, 0x02, 0x01, 0x04, 0x12, 0x07, 0x62, 0xAC, // "ı" (U+0131)
  0x01, 0x32, 0x01, 0xFA, 0x0E, 0x17, 0x11, 0x62, 0xC9, // "Ĳ" (U+0132)
  0x01, 0x33, 0x02, 0xF9, 0x0C, 0x19, 0x0E, 0x63, 0x6E, // "ĳ" (U+0133)
  0x01, 0x34, 0xFE, 0xFA, 0x08, 0x20, 0x08, 0x63, 0xFF, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xF9, 0x08, 0x1A, 0x07, 0x64, 0x7A, // "ĵ" (U+0135)
  0x01, 0x36, 0x02, 0xFA, 0x0F, 0x17, 0x10, 0x64, 0xE8, // "Ķ" (U+0136)
  0x01, 0x37, 0x02, 0xFA, 0x0D, 0x19, 0x0E, 0x65, 0x81, // "ķ" (U+0137)
  0x01, 0x38, 0x02, 0x01, 0x0D, 0x12, 0x0E, 0x66, 0x11, // "ĸ" (U+0138)
  0x01, 0x39, 0x02, 0x01, 0x0C, 0x20, 0x0D, 0x66, 0x6D, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x02, 0x01, 0x08, 0x21, 0x07, 0x66, 0xCA, // "ĺ" (U+013A)
  0x01, 0x3B, 0x02, 0xFA, 0x0C, 0x17, 0x0D, 0x67, 0x2A, // "Ļ" (U+013B)
  0x01, 0x3C, 0x01, 0xFA, 0x05, 0x19, 0x07, 0x67, 0x83, // "ļ" (U+013C)
  0x01, 0x3D, 0x02, 0x01, 0x0D, 0x18, 0x0D, 0x67, 0xDD, // "Ľ" (U+013D)
  0x01, 0x3E, 0x02, 0x01, 0x09, 0x19, 0x07, 0x68, 0x3C, // "ľ" (U+013E)
  0x01, 0x3F, 0x02, 0x01, 0x0C, 0x17, 0x0D, 0x68, 0x8E, // "Ŀ" (U+013F)
  0x01, 0x40, 0x02, 0x01, 0x09, 0x19, 0x09, 0x68, 0xE1, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x0C, 0x17, 0x0E, 0x69, 0x32, // "Ł" (U+0141)
  0x01, 0x42, 0xFF, 0x01, 0x07, 0x19, 0x08, 0x69, 0x8F, // "ł" (U+0142)
  0x01, 0x43, 0x02, 0x01, 0x11, 0x20, 0x14, 0x69, 0xE4, // "Ń" (U+0143)
  0x01, 0x44, 0x02, 0x01, 0x0D, 0x1A, 0x10, 0x6A, 0xA1, // "ń" (U+0144)
  0x01, 0x45, 0x02, 0xFA, 0x11, 0x17, 0x14, 0x6B, 0x11, // "Ņ" (U+0145)
  0x01, 0x46, 0x02, 0xFA, 0x0D, 0x12, 0x10, 0x6B, 0xC9, // "ņ" (U+0146)
  0x01, 0x47, 0x02, 0x01, 0x11, 0x20, 0x14, 0x6C, 0x36, // "Ň" (U+0147)
  0x01, 0x48, 0x02, 0x01, 0x0D, 0x1A, 0x10, 0x6C, 0xFB, // "ň" (U+0148)
  0x01, 0x49, 0xFF, 0x01, 0x0F, 0x17, 0x12, 0x6D, 0x74, // "ŉ" (U+0149)
  0x01, 0x4A, 0x02, 0xFA, 0x11, 0x17, 0x14, 0x6D, 0xF8, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x02, 0xF9, 0x0D, 0x12, 0x10, 0x6E, 0xB4, // "ŋ" (U+014B)
  0x01, 0x4C, 0x01, 0x01, 0x12, 0x1D, 0x14, 0x6F, 0x2D, // "Ō" (U+014C)
  0x01, 0x4D, 0x01, 0x01, 0x0E, 0x17, 0x10, 0x6F, 0xCA, // "ō" (U+014D)
  0x01, 0x4E, 0x01, 0x01, 0x12, 0x1F, 0x14, 0x70, 0x3B, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x01, 0x01, 0x0E, 0x19, 0x10, 0x70, 0xE7, // "ŏ" (U+014F)
  0x01, 0x50, 0x01, 0x01, 0x12, 0x1F, 0x14, 0x71, 0x66, // "Ő" (U+0150)
  0x01, 0x51, 0x01, 0x01, 0x0E, 0x19, 0x10, 0x72, 0x18, // "ő" (U+0151)
  0x01, 0x52, 0x01, 0x01, 0x15, 0x17, 0x17, 0x72, 0x9D, // "Œ" (U+0152)
  0x01, 0x53, 0x01, 0x01, 0x17, 0x12, 0x19, 0x73, 0x34, // "œ" (U+0153)
  0x01, 0x54, 0x02, 0x01, 0x0F, 0x20, 0x10, 0x73, 0xCE, // "Ŕ" (U+0154)
  0x01, 0x55, 0x02, 0x01, 0x0A, 0x1A, 0x0B, 0x74, 0x6C, // "ŕ" (U+0155)
  0x01, 0x56, 0x02, 0xFA, 0x0F, 0x17, 0x10, 0x74, 0xBD, // "Ŗ" (U+0156)
  0x01, 0x57, 0x01, 0xFA, 0x0A, 0x12, 0x0B, 0x75, 0x56, // "ŗ" (U+0157)
  0x01, 0x58, 0x02, 0x01, 0x0F, 0x20, 0x10, 0x75, 0xA4, // "Ř" (U+0158)
  0x01, 0x59, 0x01, 0x01, 0x0A, 0x1A, 0x0B, 0x76, 0x49, // "ř" (U+0159)
  0x01, 0x5A, 0x01, 0x01, 0x0D, 0x20, 0x0F, 0x76, 0xA2, // "Ś" (U+015A)
  0x01, 0x5B, 0x01, 0x01, 0x0A, 0x1A, 0x0C, 0x77, 0x1F, // "ś" (U+015B)
  0x01, 0x5C, 0x01, 0x01, 0x0D, 0x20, 0x0F, 0x77, 0x7A, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x01, 0x01, 0x0B, 0x1A, 0x0C, 0x77, 0xFD, // "ŝ" (U+015D)
  0x01, 0x5E, 0x01, 0xF9, 0x0D, 0x17, 0x0F, 0x78, 0x65, // "Ş" (U+015E)
  0x01, 0x5F, 0x01, 0xF9, 0x0A, 0x12, 0x0C, 0x78, 0xE7, // "ş" (U+015F)
  0x01, 0x60, 0x01, 0x01, 0x0D, 0x20, 0x0F, 0x79, 0x48, // "Š" (U+0160)
  0x01, 0x61, 0x01, 0x01, 0x0A, 0x1A, 0x0C, 0x79, 0xCB, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xF9, 0x0D, 0x17, 0x0E, 0x7A, 0x2D, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xF9, 0x08, 0x16, 0x09, 0x7A, 0xA0, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x0D, 0x20, 0x0E, 0x7B, 0x05, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x0C, 0x19, 0x09, 0x7B, 0x79, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x0D, 0x17, 0x0E, 0x7B, 0xDB, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x08, 0x16, 0x09, 0x7C, 0x2F, // "ŧ" (U+0167)
  0x01, 0x68, 0x02, 0x01, 0x10, 0x1E, 0x13, 0x7C, 0x7A, // "Ũ" (U+0168)
  0x01, 0x69, 0x02, 0x01, 0x0D, 0x18, 0x10, 0x7D, 0x16, // "ũ" (U+0169)
  0x01, 0x6A, 0x02, 0x01, 0x10, 0x1D, 0x13, 0x7D, 0x8B, // "Ū" (U+016A)
  0x01, 0x6B, 0x02, 0x01, 0x0D, 0x17, 0x10, 0x7E, 0x18, // "ū" (U+016B)
  0x01, 0x6C, 0x02, 0x01, 0x10, 0x1F, 0x13, 0x7E, 0x7F, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x02, 0x01, 0x0D, 0x19, 0x10, 0x7F, 0x1B, // "ŭ" (U+016D)
  0x01, 0x6E, 0x02, 0x01, 0x10, 0x21, 0x13, 0x7F, 0x90, // "Ů" (U+016E)
  0x01, 0x6F, 0x02, 0x01, 0x0D, 0x1B, 0x10, 0x80, 0x34, // "ů" (U+016F)
  0x01, 0x70, 0x02, 0x01, 0x10, 0x1F, 0x13, 0x80, 0xAF, // "Ű" (U+0170)
  0x01, 0x71, 0x02, 0x01, 0x0E, 0x19, 0x10, 0x81, 0x50, // "ű" (U+0171)
  0x01, 0x72, 0x02, 0xF9, 0x10, 0x17, 0x13, 0x81, 0xD3, // "Ų" (U+0172)
  0x01, 0x73, 0x02, 0xFA, 0x0E, 0x12, 0x10, 0x82, 0x73, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x18, 0x20, 0x19, 0x82, 0xEE, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x14, 0x1A, 0x15, 0x83, 0xEB, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x0D, 0x20, 0x0E, 0x84, 0xAB, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xF9, 0x0C, 0x1A, 0x0D, 0x85, 0x32, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x0D, 0x1D, 0x0E, 0x85, 0xC7, // "Ÿ" (U+0178)
  0x01, 0x79, 0x01, 0x01, 0x0C, 0x20, 0x0E, 0x86, 0x43, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x0A, 0x1A, 0x0B, 0x86, 0xA9, // "ź" (U+017A)
  0x01, 0x7B, 0x01, 0x01, 0x0C, 0x1F, 0x0E, 0x86, 0xFC, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x0A, 0x19, 0x0B, 0x87, 0x5C, // "ż" (U+017C)
  0x01, 0x7D, 0x01, 0x01, 0x0C, 0x20, 0x0E, 0x87, 0xA9, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x0A, 0x1A, 0x0B, 0x88, 0x18, // "ž" (U+017E)
  0x01, 0x7F, 0x02, 0x01, 0x09, 0x19, 0x08, 0x88, 0x73, // "ſ" (U+017F)
  0x03, 0xA9, 0x01, 0x01, 0x12, 0x17, 0x14, 0x88, 0xC1, // "Ω" (U+03A9)
  0x03, 0xBC, 0x02, 0xF9, 0x0D, 0x12, 0x10, 0x89, 0x52, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x10, 0x12, 0x11, 0x89, 0xC5, // "π" (U+03C0)
  0x20, 0x13, 0x01, 0x09, 0x0E, 0x0B, 0x10, 0x8A, 0x22, // "–" (U+2013)
  0x20, 0x14, 0x01, 0x09, 0x1E, 0x0B, 0x20, 0x8A, 0x2C, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x0E, 0x17, 0x0F, 0x8A, 0x38, // "€" (U+20AC)
  0x20, 0xBF, 0x02, 0xFE, 0x0E, 0x1B, 0x0F, 0x8A, 0x9C, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x10, 0x05, 0x17, 0x06, 0x8B, 0x40, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x10, 0x05, 0x17, 0x06, 0x8B, 0x59, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0xFD, 0x05, 0x04, 0x07, 0x8B, 0x71, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x10, 0x05, 0x17, 0x06, 0x8B, 0x89, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x10, 0x0A, 0x17, 0x0B, 0x8B, 0xA1, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x10, 0x0A, 0x17, 0x0B, 0x8B, 0xD2, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0xFD, 0x0A, 0x04, 0x0C, 0x8C, 0x02, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x10, 0x0A, 0x17, 0x0B, 0x8C, 0x32, // "‟" (U+201F)
  0x20, 0x20, 0x01, 0x01, 0x0D, 0x19, 0x0F, 0x8C, 0x62, // "†" (U+2020)
  0x20, 0x21, 0x01, 0x01, 0x0D, 0x19, 0x0F, 0x8C, 0xBF, // "‡" (U+2021)
  0x20, 0x22, 0x02, 0x09, 0x09, 0x11, 0x0C, 0x8D, 0x1C, // "•" (U+2022)
  0x20, 0x26, 0x02, 0x01, 0x14, 0x04, 0x17, 0x8D, 0x39, // "…" (U+2026)
  0x20, 0x30, 0x01, 0x01, 0x1E, 0x17, 0x20, 0x8D, 0x5D, // "‰" (U+2030)
  0x20, 0x39, 0x01, 0x03, 0x07, 0x0F, 0x09, 0x8E, 0x77, // "‹" (U+2039)
  0x20, 0x3A, 0x01, 0x03, 0x07, 0x0F, 0x09, 0x8E, 0x9F, // "›" (U+203A)
  0x20, 0x44, 0xFA, 0x01, 0x08, 0x17, 0x04, 0x8E, 0xC7, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x0C, 0x13, 0x17, 0x15, 0x8F, 0x1B, // "™" (U+2122)
  0x21, 0x52, 0x01, 0x01, 0x1E, 0x17, 0x20, 0x8F, 0x8F, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x0E, 0x1A, 0x10, 0x90, 0x73, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x0D, 0x1A, 0x10, 0x91, 0x0B, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x02, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x61, 0x01, // "a (U+0022 U+0061)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x67, 0x01, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0x6D, 0x01, // "m (U+0022 U+006D)
  0x00, 0x22, 0x00, 0x6E, 0x01, // "n (U+0022 U+006E)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x70, 0x01, // "p (U+0022 U+0070)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0x72, 0x01, // "r (U+0022 U+0072)
  0x00, 0x22, 0x00, 0x73, 0x01, // "s (U+0022 U+0073)
  0x00, 0x22, 0x00, 0x75, 0x01, // "u (U+0022 U+0075)
  0x00, 0x22, 0x00, 0xC0, 0x02, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x02, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x02, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x02, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x02, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x02, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x02, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE1, 0x01, // "á (U+0022 U+00E1)
  0x00, 0x22, 0x00, 0xE2, 0x01, // "â (U+0022 U+00E2)
  0x00, 0x22, 0x00, 0xE3, 0x01, // "ã (U+0022 U+00E3)
  0x00, 0x22, 0x00, 0xE4, 0x01, // "ä (U+0022 U+00E4)
  0x00, 0x22, 0x00, 0xE5, 0x01, // "å (U+0022 U+00E5)
  0x00, 0x22, 0x00, 0xE6, 0x01, // "æ (U+0022 U+00E6)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x00, 0xF9, 0x01, // "ù (U+0022 U+00F9)
  0x00, 0x22, 0x00, 0xFA, 0x01, // "ú (U+0022 U+00FA)
  0x00, 0x22, 0x00, 0xFB, 0x01, // "û (U+0022 U+00FB)
  0x00, 0x22, 0x00, 0xFC, 0x01, // "ü (U+0022 U+00FC)
  0x00, 0x22, 0x01, 0x00, 0x02, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x01, 0x01, // "ā (U+0022 U+0101)
  0x00, 0x22, 0x01, 0x02, 0x02, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x03, 0x01, // "ă (U+0022 U+0103)
  0x00, 0x22, 0x01, 0x04, 0x02, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x05, 0x01, // "ą (U+0022 U+0105)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x1D, 0x01, // "ĝ (U+0022 U+011D)
  0x00, 0x22, 0x01, 0x1F, 0x01, // "ğ (U+0022 U+011F)
  0x00, 0x22, 0x01, 0x21, 0x01, // "ġ (U+0022 U+0121)
  0x00, 0x22, 0x01, 0x23, 0x01, // "ģ (U+0022 U+0123)
  0x00, 0x22, 0x01, 0x38, 0x01, // "ĸ (U+0022 U+0138)
  0x00, 0x22, 0x01, 0x44, 0x01, // "ń (U+0022 U+0144)
  0x00, 0x22, 0x01, 0x46, 0x01, // "ņ (U+0022 U+0146)
  0x00, 0x22, 0x01, 0x4B, 0x01, // "ŋ (U+0022 U+014B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x22, 0x01, 0x55, 0x01, // "ŕ (U+0022 U+0155)
  0x00, 0x22, 0x01, 0x57, 0x01, // "ŗ (U+0022 U+0157)
  0x00, 0x22, 0x01, 0x5B, 0x01, // "ś (U+0022 U+015B)
  0x00, 0x22, 0x01, 0x5F, 0x01, // "ş (U+0022 U+015F)
  0x00, 0x22, 0x01, 0x69, 0x01, // "ũ (U+0022 U+0169)
  0x00, 0x22, 0x01, 0x6B, 0x01, // "ū (U+0022 U+016B)
  0x00, 0x22, 0x01, 0x6D, 0x01, // "ŭ (U+0022 U+016D)
  0x00, 0x22, 0x01, 0x6F, 0x01, // "ů (U+0022 U+016F)
  0x00, 0x22, 0x01, 0x71, 0x01, // "ű (U+0022 U+0171)
  0x00, 0x22, 0x01, 0x73, 0x01, // "ų (U+0022 U+0173)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x59, 0x01, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x01, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x62, 0x01, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x01, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x01, // &Ŧ (U+0026 U+0166)
  0x00, 0x26, 0x01, 0x76, 0x01, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x01, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x02, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x61, 0x01, // 'a (U+0027 U+0061)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x67, 0x01, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0x6D, 0x01, // 'm (U+0027 U+006D)
  0x00, 0x27, 0x00, 0x6E, 0x01, // 'n (U+0027 U+006E)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x70, 0x01, // 'p (U+0027 U+0070)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0x72, 0x01, // 'r (U+0027 U+0072)
  0x00, 0x27, 0x00, 0x73, 0x01, // 's (U+0027 U+0073)
  0x00, 0x27, 0x00, 0x75, 0x01, // 'u (U+0027 U+0075)
  0x00, 0x27, 0x00, 0xC0, 0x02, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x02, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x02, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x02, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x02, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x02, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x02, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE1, 0x01, // 'á (U+0027 U+00E1)
  0x00, 0x27, 0x00, 0xE2, 0x01, // 'â (U+0027 U+00E2)
  0x00, 0x27, 0x00, 0xE3, 0x01, // 'ã (U+0027 U+00E3)
  0x00, 0x27, 0x00, 0xE4, 0x01, // 'ä (U+0027 U+00E4)
  0x00, 0x27, 0x00, 0xE5, 0x01, // 'å (U+0027 U+00E5)
  0x00, 0x27, 0x00, 0xE6, 0x01, // 'æ (U+0027 U+00E6)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x00, 0xF9, 0x01, // 'ù (U+0027 U+00F9)
  0x00, 0x27, 0x00, 0xFA, 0x01, // 'ú (U+0027 U+00FA)
  0x00, 0x27, 0x00, 0xFB, 0x01, // 'û (U+0027 U+00FB)
  0x00, 0x27, 0x00, 0xFC, 0x01, // 'ü (U+0027 U+00FC)
  0x00, 0x27, 0x01, 0x00, 0x02, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x01, 0x01, // 'ā (U+0027 U+0101)
  0x00, 0x27, 0x01, 0x02, 0x02, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x03, 0x01, // 'ă (U+0027 U+0103)
  0x00, 0x27, 0x01, 0x04, 0x02, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x05, 0x01, // 'ą (U+0027 U+0105)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x1D, 0x01, // 'ĝ (U+0027 U+011D)
  0x00, 0x27, 0x01, 0x1F, 0x01, // 'ğ (U+0027 U+011F)
  0x00, 0x27, 0x01, 0x21, 0x01, // 'ġ (U+0027 U+0121)
  0x00, 0x27, 0x01, 0x23, 0x01, // 'ģ (U+0027 U+0123)
  0x00, 0x27, 0x01, 0x38, 0x01, // 'ĸ (U+0027 U+0138)
  0x00, 0x27, 0x01, 0x44, 0x01, // 'ń (U+0027 U+0144)
  0x00, 0x27, 0x01, 0x46, 0x01, // 'ņ (U+0027 U+0146)
  0x00, 0x27, 0x01, 0x4B, 0x01, // 'ŋ (U+0027 U+014B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x27, 0x01, 0x55, 0x01, // 'ŕ (U+0027 U+0155)
  0x00, 0x27, 0x01, 0x57, 0x01, // 'ŗ (U+0027 U+0157)
  0x00, 0x27, 0x01, 0x5B, 0x01, // 'ś (U+0027 U+015B)
  0x00, 0x27, 0x01, 0x5F, 0x01, // 'ş (U+0027 U+015F)
  0x00, 0x27, 0x01, 0x69, 0x01, // 'ũ (U+0027 U+0169)
  0x00, 0x27, 0x01, 0x6B, 0x01, // 'ū (U+0027 U+016B)
  0x00, 0x27, 0x01, 0x6D, 0x01, // 'ŭ (U+0027 U+016D)
  0x00, 0x27, 0x01, 0x6F, 0x01, // 'ů (U+0027 U+016F)
  0x00, 0x27, 0x01, 0x71, 0x01, // 'ű (U+0027 U+0171)
  0x00, 0x27, 0x01, 0x73, 0x01, // 'ų (U+0027 U+0173)
  0x00, 0x2C, 0x00, 0x43, 0x01, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x01, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x01, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x01, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x02, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x01, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x01, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x01, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x01, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x01, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x01, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x01, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x01, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x01, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x01, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x01, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x01, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x01, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x01, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x01, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x01, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x01, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x01, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x01, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x02, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x02, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x02, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2D, 0x00, 0x54, 0x01, // -T (U+002D U+0054)
  0x00, 0x2D, 0x01, 0x62, 0x01, // -Ţ (U+002D U+0162)
  0x00, 0x2D, 0x01, 0x64, 0x01, // -Ť (U+002D U+0164)
  0x00, 0x2D, 0x01, 0x66, 0x01, // -Ŧ (U+002D U+0166)
  0x00, 0x2E, 0x00, 0x43, 0x01, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x01, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x01, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x01, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x02, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x01, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x01, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x01, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x01, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x01, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x01, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x01, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x01, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x01, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x01, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x01, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x01, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x01, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x01, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x01, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x01, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x01, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x01, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x01, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x02, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x02, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x02, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x05, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x05, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x05, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x05, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x05, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x05, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x05, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x05, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x05, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x05, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x02, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x02, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x19, 0x02, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x02, // A” (U+0041 U+201D)
  0x00, 0x43, 0x00, 0x43, 0x01, // CC (U+0043 U+0043)
  0x00, 0x43, 0x00, 0x47, 0x01, // CG (U+0043 U+0047)
  0x00, 0x43, 0x00, 0x4F, 0x01, // CO (U+0043 U+004F)
  0x00, 0x43, 0x00, 0x51, 0x01, // CQ (U+0043 U+0051)
  0x00, 0x43, 0x00, 0xC7, 0x01, // CÇ (U+0043 U+00C7)
  0x00, 0x43, 0x00, 0xD2, 0x01, // CÒ (U+0043 U+00D2)
  0x00, 0x43, 0x00, 0xD3, 0x01, // CÓ (U+0043 U+00D3)
  0x00, 0x43, 0x00, 0xD4, 0x01, // CÔ (U+0043 U+00D4)
  0x00, 0x43, 0x00, 0xD5, 0x01, // CÕ (U+0043 U+00D5)
  0x00, 0x43, 0x00, 0xD6, 0x01, // CÖ (U+0043 U+00D6)
  0x00, 0x43, 0x00, 0xD8, 0x01, // CØ (U+0043 U+00D8)
  0x00, 0x43, 0x01, 0x06, 0x01, // CĆ (U+0043 U+0106)
  0x00, 0x43, 0x01, 0x08, 0x01, // CĈ (U+0043 U+0108)
  0x00, 0x43, 0x01, 0x0A, 0x01, // CĊ (U+0043 U+010A)
  0x00, 0x43, 0x01, 0x0C, 0x01, // CČ (U+0043 U+010C)
  0x00, 0x43, 0x01, 0x1C, 0x01, // CĜ (U+0043 U+011C)
  0x00, 0x43, 0x01, 0x1E, 0x01, // CĞ (U+0043 U+011E)
  0x00, 0x43, 0x01, 0x20, 0x01, // CĠ (U+0043 U+0120)
  0x00, 0x43, 0x01, 0x22, 0x01, // CĢ (U+0043 U+0122)
  0x00, 0x43, 0x01, 0x4C, 0x01, // CŌ (U+0043 U+014C)
  0x00, 0x43, 0x01, 0x4E, 0x01, // CŎ (U+0043 U+014E)
  0x00, 0x43, 0x01, 0x50, 0x01, // CŐ (U+0043 U+0150)
  0x00, 0x43, 0x01, 0x52, 0x01, // CŒ (U+0043 U+0152)
  0x00, 0x44, 0x00, 0x2C, 0x01, // D, (U+0044 U+002C)
  0x00, 0x44, 0x00, 0x2E, 0x01, // D. (U+0044 U+002E)
  0x00, 0x44, 0x20, 0x1A, 0x01, // D‚ (U+0044 U+201A)
  0x00, 0x44, 0x20, 0x1E, 0x01, // D„ (U+0044 U+201E)
  0x00, 0x44, 0x20, 0x26, 0x01, // D… (U+0044 U+2026)
  0x00, 0x46, 0x00, 0x2C, 0x02, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x02, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x02, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x02, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x02, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x02, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x02, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x01, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x01, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x62, 0x01, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x01, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x01, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x01, 0x74, 0x01, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x19, 0x02, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x02, // L” (U+004C U+201D)
  0x00, 0x4F, 0x00, 0x2C, 0x01, // O, (U+004F U+002C)
  0x00, 0x4F, 0x00, 0x2E, 0x01, // O. (U+004F U+002E)
  0x00, 0x4F, 0x20, 0x1A, 0x01, // O‚ (U+004F U+201A)
  0x00, 0x4F, 0x20, 0x1E, 0x01, // O„ (U+004F U+201E)
  0x00, 0x4F, 0x20, 0x26, 0x01, // O… (U+004F U+2026)
  0x00, 0x50, 0x00, 0x2C, 0x03, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x03, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x03, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x03, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x03, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x2C, 0x01, // Q, (U+0051 U+002C)
  0x00, 0x51, 0x00, 0x2E, 0x01, // Q. (U+0051 U+002E)
  0x00, 0x51, 0x20, 0x1A, 0x01, // Q‚ (U+0051 U+201A)
  0x00, 0x51, 0x20, 0x1E, 0x01, // Q„ (U+0051 U+201E)
  0x00, 0x51, 0x20, 0x26, 0x01, // Q… (U+0051 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2D, 0x01, // T- (U+0054 U+002D)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x02, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x02, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x02, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x02, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x02, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x01, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x01, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x02, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x01, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x02, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x01, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x01, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x01, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0x7A, 0x01, // Tz (U+0054 U+007A)
  0x00, 0x54, 0x00, 0xAB, 0x01, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xBB, 0x01, // T» (U+0054 U+00BB)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xE0, 0x02, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x02, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x02, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x02, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x02, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x02, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x02, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x02, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x02, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x02, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x02, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x02, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x02, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x02, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x02, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x02, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x02, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x02, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x01, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x01, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x01, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x01, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x02, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x02, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x02, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x02, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x02, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x02, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x02, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x02, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x02, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x02, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x02, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x02, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x02, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x02, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x02, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x02, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x02, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x02, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x01, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x01, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x01, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x4B, 0x01, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4D, 0x02, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x02, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x02, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x02, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x01, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x01, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x01, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5F, 0x01, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x69, 0x01, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x01, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x01, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x01, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x01, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x01, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x01, 0x7A, 0x01, // Tź (U+0054 U+017A)
  0x00, 0x54, 0x01, 0x7C, 0x01, // Tż (U+0054 U+017C)
  0x00, 0x54, 0x01, 0x7E, 0x01, // Tž (U+0054 U+017E)
  0x00, 0x54, 0x20, 0x13, 0x01, // T– (U+0054 U+2013)
  0x00, 0x54, 0x20, 0x14, 0x01, // T— (U+0054 U+2014)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x01, // T‹ (U+0054 U+2039)
  0x00, 0x54, 0x20, 0x3A, 0x01, // T› (U+0054 U+203A)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0xAB, 0x01, // V« (U+0056 U+00AB)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x56, 0x20, 0x39, 0x01, // V‹ (U+0056 U+2039)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0xAB, 0x01, // W« (U+0057 U+00AB)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x57, 0x20, 0x39, 0x01, // W‹ (U+0057 U+2039)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6D, 0x01, // Ym (U+0059 U+006D)
  0x00, 0x59, 0x00, 0x6E, 0x01, // Yn (U+0059 U+006E)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x70, 0x01, // Yp (U+0059 U+0070)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x72, 0x01, // Yr (U+0059 U+0072)
  0x00, 0x59, 0x00, 0x73, 0x01, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0x75, 0x01, // Yu (U+0059 U+0075)
  0x00, 0x59, 0x00, 0xAB, 0x02, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xBB, 0x01, // Y» (U+0059 U+00BB)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x00, 0xF9, 0x01, // Yù (U+0059 U+00F9)
  0x00, 0x59, 0x00, 0xFA, 0x01, // Yú (U+0059 U+00FA)
  0x00, 0x59, 0x00, 0xFB, 0x01, // Yû (U+0059 U+00FB)
  0x00, 0x59, 0x00, 0xFC, 0x01, // Yü (U+0059 U+00FC)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x38, 0x01, // Yĸ (U+0059 U+0138)
  0x00, 0x59, 0x01, 0x44, 0x01, // Yń (U+0059 U+0144)
  0x00, 0x59, 0x01, 0x46, 0x01, // Yņ (U+0059 U+0146)
  0x00, 0x59, 0x01, 0x4B, 0x01, // Yŋ (U+0059 U+014B)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x55, 0x01, // Yŕ (U+0059 U+0155)
  0x00, 0x59, 0x01, 0x57, 0x01, // Yŗ (U+0059 U+0157)
  0x00, 0x59, 0x01, 0x5B, 0x01, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5F, 0x01, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x69, 0x01, // Yũ (U+0059 U+0169)
  0x00, 0x59, 0x01, 0x6B, 0x01, // Yū (U+0059 U+016B)
  0x00, 0x59, 0x01, 0x6D, 0x01, // Yŭ (U+0059 U+016D)
  0x00, 0x59, 0x01, 0x6F, 0x01, // Yů (U+0059 U+016F)
  0x00, 0x59, 0x01, 0x71, 0x01, // Yű (U+0059 U+0171)
  0x00, 0x59, 0x01, 0x73, 0x01, // Yų (U+0059 U+0173)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x02, // Y‹ (U+0059 U+2039)
  0x00, 0x59, 0x20, 0x3A, 0x01, // Y› (U+0059 U+203A)
  0x00, 0x72, 0x00, 0x2C, 0x02, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x02, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x02, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x02, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x02, // r… (U+0072 U+2026)
  0x00, 0x76, 0x00, 0x2C, 0x01, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xA1, 0x00, 0x59, 0x01, // ¡Y (U+00A1 U+0059)
  0x00, 0xA1, 0x00, 0xDD, 0x01, // ¡Ý (U+00A1 U+00DD)
  0x00, 0xA1, 0x01, 0x76, 0x01, // ¡Ŷ (U+00A1 U+0176)
  0x00, 0xA1, 0x01, 0x78, 0x01, // ¡Ÿ (U+00A1 U+0178)
  0x00, 0xAB, 0x00, 0x54, 0x01, // «T (U+00AB U+0054)
  0x00, 0xAB, 0x00, 0x59, 0x01, // «Y (U+00AB U+0059)
  0x00, 0xAB, 0x00, 0xDD, 0x01, // «Ý (U+00AB U+00DD)
  0x00, 0xAB, 0x01, 0x62, 0x01, // «Ţ (U+00AB U+0162)
  0x00, 0xAB, 0x01, 0x64, 0x01, // «Ť (U+00AB U+0164)
  0x00, 0xAB, 0x01, 0x66, 0x01, // «Ŧ (U+00AB U+0166)
  0x00, 0xAB, 0x01, 0x76, 0x01, // «Ŷ (U+00AB U+0176)
  0x00, 0xAB, 0x01, 0x78, 0x01, // «Ÿ (U+00AB U+0178)
  0x00, 0xBB, 0x00, 0x54, 0x01, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x56, 0x01, // »V (U+00BB U+0056)
  0x00, 0xBB, 0x00, 0x57, 0x01, // »W (U+00BB U+0057)
  0x00, 0xBB, 0x00, 0x59, 0x02, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x02, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x01, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x01, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x01, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x74, 0x01, // »Ŵ (U+00BB U+0174)
  0x00, 0xBB, 0x01, 0x76, 0x02, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x02, // »Ÿ (U+00BB U+0178)
  0x00, 0xBF, 0x00, 0x54, 0x01, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x00, 0x56, 0x01, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x01, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x01, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x01, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x62, 0x01, // ¿Ţ (U+00BF U+0162)
  0x00, 0xBF, 0x01, 0x64, 0x01, // ¿Ť (U+00BF U+0164)
  0x00, 0xBF, 0x01, 0x66, 0x01, // ¿Ŧ (U+00BF U+0166)
  0x00, 0xBF, 0x01, 0x74, 0x01, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x01, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x01, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x02, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x02, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x19, 0x02, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x02, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x02, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x02, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x19, 0x02, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x02, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x02, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x02, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x19, 0x02, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x02, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x02, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x02, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x19, 0x02, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x02, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x02, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x02, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x19, 0x02, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x02, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x02, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x02, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x19, 0x02, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x02, // Å” (U+00C5 U+201D)
  0x00, 0xC7, 0x00, 0x43, 0x01, // ÇC (U+00C7 U+0043)
  0x00, 0xC7, 0x00, 0x47, 0x01, // ÇG (U+00C7 U+0047)
  0x00, 0xC7, 0x00, 0x4F, 0x01, // ÇO (U+00C7 U+004F)
  0x00, 0xC7, 0x00, 0x51, 0x01, // ÇQ (U+00C7 U+0051)
  0x00, 0xC7, 0x00, 0xC7, 0x01, // ÇÇ (U+00C7 U+00C7)
  0x00, 0xC7, 0x00, 0xD2, 0x01, // ÇÒ (U+00C7 U+00D2)
  0x00, 0xC7, 0x00, 0xD3, 0x01, // ÇÓ (U+00C7 U+00D3)
  0x00, 0xC7, 0x00, 0xD4, 0x01, // ÇÔ (U+00C7 U+00D4)
  0x00, 0xC7, 0x00, 0xD5, 0x01, // ÇÕ (U+00C7 U+00D5)
  0x00, 0xC7, 0x00, 0xD6, 0x01, // ÇÖ (U+00C7 U+00D6)
  0x00, 0xC7, 0x00, 0xD8, 0x01, // ÇØ (U+00C7 U+00D8)
  0x00, 0xC7, 0x01, 0x06, 0x01, // ÇĆ (U+00C7 U+0106)
  0x00, 0xC7, 0x01, 0x08, 0x01, // ÇĈ (U+00C7 U+0108)
  0x00, 0xC7, 0x01, 0x0A, 0x01, // ÇĊ (U+00C7 U+010A)
  0x00, 0xC7, 0x01, 0x0C, 0x01, // ÇČ (U+00C7 U+010C)
  0x00, 0xC7, 0x01, 0x1C, 0x01, // ÇĜ (U+00C7 U+011C)
  0x00, 0xC7, 0x01, 0x1E, 0x01, // ÇĞ (U+00C7 U+011E)
  0x00, 0xC7, 0x01, 0x20, 0x01, // ÇĠ (U+00C7 U+0120)
  0x00, 0xC7, 0x01, 0x22, 0x01, // ÇĢ (U+00C7 U+0122)
  0x00, 0xC7, 0x01, 0x4C, 0x01, // ÇŌ (U+00C7 U+014C)
  0x00, 0xC7, 0x01, 0x4E, 0x01, // ÇŎ (U+00C7 U+014E)
  0x00, 0xC7, 0x01, 0x50, 0x01, // ÇŐ (U+00C7 U+0150)
  0x00, 0xC7, 0x01, 0x52, 0x01, // ÇŒ (U+00C7 U+0152)
  0x00, 0xD0, 0x00, 0x2C, 0x01, // Ð, (U+00D0 U+002C)
  0x00, 0xD0, 0x00, 0x2E, 0x01, // Ð. (U+00D0 U+002E)
  0x00, 0xD0, 0x20, 0x1A, 0x01, // Ð‚ (U+00D0 U+201A)
  0x00, 0xD0, 0x20, 0x1E, 0x01, // Ð„ (U+00D0 U+201E)
  0x00, 0xD0, 0x20, 0x26, 0x01, // Ð… (U+00D0 U+2026)
  0x00, 0xD2, 0x00, 0x2C, 0x01, // Ò, (U+00D2 U+002C)
  0x00, 0xD2, 0x00, 0x2E, 0x01, // Ò. (U+00D2 U+002E)
  0x00, 0xD2, 0x20, 0x1A, 0x01, // Ò‚ (U+00D2 U+201A)
  0x00, 0xD2, 0x20, 0x1E, 0x01, // Ò„ (U+00D2 U+201E)
  0x00, 0xD2, 0x20, 0x26, 0x01, // Ò… (U+00D2 U+2026)
  0x00, 0xD3, 0x00, 0x2C, 0x01, // Ó, (U+00D3 U+002C)
  0x00, 0xD3, 0x00, 0x2E, 0x01, // Ó. (U+00D3 U+002E)
  0x00, 0xD3, 0x20, 0x1A, 0x01, // Ó‚ (U+00D3 U+201A)
  0x00, 0xD3, 0x20, 0x1E, 0x01, // Ó„ (U+00D3 U+201E)
  0x00, 0xD3, 0x20, 0x26, 0x01, // Ó… (U+00D3 U+2026)
  0x00, 0xD4, 0x00, 0x2C, 0x01, // Ô, (U+00D4 U+002C)
  0x00, 0xD4, 0x00, 0x2E, 0x01, // Ô. (U+00D4 U+002E)
  0x00, 0xD4, 0x20, 0x1A, 0x01, // Ô‚ (U+00D4 U+201A)
  0x00, 0xD4, 0x20, 0x1E, 0x01, // Ô„ (U+00D4 U+201E)
  0x00, 0xD4, 0x20, 0x26, 0x01, // Ô… (U+00D4 U+2026)
  0x00, 0xD5, 0x00, 0x2C, 0x01, // Õ, (U+00D5 U+002C)
  0x00, 0xD5, 0x00, 0x2E, 0x01, // Õ. (U+00D5 U+002E)
  0x00, 0xD5, 0x20, 0x1A, 0x01, // Õ‚ (U+00D5 U+201A)
  0x00, 0xD5, 0x20, 0x1E, 0x01, // Õ„ (U+00D5 U+201E)
  0x00, 0xD5, 0x20, 0x26, 0x01, // Õ… (U+00D5 U+2026)
  0x00, 0xD6, 0x00, 0x2C, 0x01, // Ö, (U+00D6 U+002C)
  0x00, 0xD6, 0x00, 0x2E, 0x01, // Ö. (U+00D6 U+002E)
  0x00, 0xD6, 0x20, 0x1A, 0x01, // Ö‚ (U+00D6 U+201A)
  0x00, 0xD6, 0x20, 0x1E, 0x01, // Ö„ (U+00D6 U+201E)
  0x00, 0xD6, 0x20, 0x26, 0x01, // Ö… (U+00D6 U+2026)
  0x00, 0xD8, 0x00, 0x2C, 0x01, // Ø, (U+00D8 U+002C)
  0x00, 0xD8, 0x00, 0x2E, 0x01, // Ø. (U+00D8 U+002E)
  0x00, 0xD8, 0x20, 0x1A, 0x01, // Ø‚ (U+00D8 U+201A)
  0x00, 0xD8, 0x20, 0x1E, 0x01, // Ø„ (U+00D8 U+201E)
  0x00, 0xD8, 0x20, 0x26, 0x01, // Ø… (U+00D8 U+2026)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6D, 0x01, // Ým (U+00DD U+006D)
  0x00, 0xDD, 0x00, 0x6E, 0x01, // Ýn (U+00DD U+006E)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x70, 0x01, // Ýp (U+00DD U+0070)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x72, 0x01, // Ýr (U+00DD U+0072)
  0x00, 0xDD, 0x00, 0x73, 0x01, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0x75, 0x01, // Ýu (U+00DD U+0075)
  0x00, 0xDD, 0x00, 0xAB, 0x02, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xBB, 0x01, // Ý» (U+00DD U+00BB)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x00, 0xF9, 0x01, // Ýù (U+00DD U+00F9)
  0x00, 0xDD, 0x00, 0xFA, 0x01, // Ýú (U+00DD U+00FA)
  0x00, 0xDD, 0x00, 0xFB, 0x01, // Ýû (U+00DD U+00FB)
  0x00, 0xDD, 0x00, 0xFC, 0x01, // Ýü (U+00DD U+00FC)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x38, 0x01, // Ýĸ (U+00DD U+0138)
  0x00, 0xDD, 0x01, 0x44, 0x01, // Ýń (U+00DD U+0144)
  0x00, 0xDD, 0x01, 0x46, 0x01, // Ýņ (U+00DD U+0146)
  0x00, 0xDD, 0x01, 0x4B, 0x01, // Ýŋ (U+00DD U+014B)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x55, 0x01, // Ýŕ (U+00DD U+0155)
  0x00, 0xDD, 0x01, 0x57, 0x01, // Ýŗ (U+00DD U+0157)
  0x00, 0xDD, 0x01, 0x5B, 0x01, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5F, 0x01, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x69, 0x01, // Ýũ (U+00DD U+0169)
  0x00, 0xDD, 0x01, 0x6B, 0x01, // Ýū (U+00DD U+016B)
  0x00, 0xDD, 0x01, 0x6D, 0x01, // Ýŭ (U+00DD U+016D)
  0x00, 0xDD, 0x01, 0x6F, 0x01, // Ýů (U+00DD U+016F)
  0x00, 0xDD, 0x01, 0x71, 0x01, // Ýű (U+00DD U+0171)
  0x00, 0xDD, 0x01, 0x73, 0x01, // Ýų (U+00DD U+0173)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x02, // Ý‹ (U+00DD U+2039)
  0x00, 0xDD, 0x20, 0x3A, 0x01, // Ý› (U+00DD U+203A)
  0x00, 0xDE, 0x00, 0x2C, 0x03, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x03, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x00, 0x41, 0x01, // ÞA (U+00DE U+0041)
  0x00, 0xDE, 0x00, 0xC0, 0x01, // ÞÀ (U+00DE U+00C0)
  0x00, 0xDE, 0x00, 0xC1, 0x01, // ÞÁ (U+00DE U+00C1)
  0x00, 0xDE, 0x00, 0xC2, 0x01, // ÞÂ (U+00DE U+00C2)
  0x00, 0xDE, 0x00, 0xC3, 0x01, // ÞÃ (U+00DE U+00C3)
  0x00, 0xDE, 0x00, 0xC4, 0x01, // ÞÄ (U+00DE U+00C4)
  0x00, 0xDE, 0x00, 0xC5, 0x01, // ÞÅ (U+00DE U+00C5)
  0x00, 0xDE, 0x00, 0xC6, 0x01, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDE, 0x01, 0x00, 0x01, // ÞĀ (U+00DE U+0100)
  0x00, 0xDE, 0x01, 0x02, 0x01, // ÞĂ (U+00DE U+0102)
  0x00, 0xDE, 0x01, 0x04, 0x01, // ÞĄ (U+00DE U+0104)
  0x00, 0xDE, 0x20, 0x1A, 0x03, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x03, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x03, // Þ… (U+00DE U+2026)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x02, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x02, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x19, 0x02, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x02, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x02, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x02, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x19, 0x02, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x02, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x02, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x02, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x19, 0x02, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x02, // Ą” (U+0104 U+201D)
  0x01, 0x06, 0x00, 0x43, 0x01, // ĆC (U+0106 U+0043)
  0x01, 0x06, 0x00, 0x47, 0x01, // ĆG (U+0106 U+0047)
  0x01, 0x06, 0x00, 0x4F, 0x01, // ĆO (U+0106 U+004F)
  0x01, 0x06, 0x00, 0x51, 0x01, // ĆQ (U+0106 U+0051)
  0x01, 0x06, 0x00, 0xC7, 0x01, // ĆÇ (U+0106 U+00C7)
  0x01, 0x06, 0x00, 0xD2, 0x01, // ĆÒ (U+0106 U+00D2)
  0x01, 0x06, 0x00, 0xD3, 0x01, // ĆÓ (U+0106 U+00D3)
  0x01, 0x06, 0x00, 0xD4, 0x01, // ĆÔ (U+0106 U+00D4)
  0x01, 0x06, 0x00, 0xD5, 0x01, // ĆÕ (U+0106 U+00D5)
  0x01, 0x06, 0x00, 0xD6, 0x01, // ĆÖ (U+0106 U+00D6)
  0x01, 0x06, 0x00, 0xD8, 0x01, // ĆØ (U+0106 U+00D8)
  0x01, 0x06, 0x01, 0x06, 0x01, // ĆĆ (U+0106 U+0106)
  0x01, 0x06, 0x01, 0x08, 0x01, // ĆĈ (U+0106 U+0108)
  0x01, 0x06, 0x01, 0x0A, 0x01, // ĆĊ (U+0106 U+010A)
  0x01, 0x06, 0x01, 0x0C, 0x01, // ĆČ (U+0106 U+010C)
  0x01, 0x06, 0x01, 0x1C, 0x01, // ĆĜ (U+0106 U+011C)
  0x01, 0x06, 0x01, 0x1E, 0x01, // ĆĞ (U+0106 U+011E)
  0x01, 0x06, 0x01, 0x20, 0x01, // ĆĠ (U+0106 U+0120)
  0x01, 0x06, 0x01, 0x22, 0x01, // ĆĢ (U+0106 U+0122)
  0x01, 0x06, 0x01, 0x4C, 0x01, // ĆŌ (U+0106 U+014C)
  0x01, 0x06, 0x01, 0x4E, 0x01, // ĆŎ (U+0106 U+014E)
  0x01, 0x06, 0x01, 0x50, 0x01, // ĆŐ (U+0106 U+0150)
  0x01, 0x06, 0x01, 0x52, 0x01, // ĆŒ (U+0106 U+0152)
  0x01, 0x08, 0x00, 0x43, 0x01, // ĈC (U+0108 U+0043)
  0x01, 0x08, 0x00, 0x47, 0x01, // ĈG (U+0108 U+0047)
  0x01, 0x08, 0x00, 0x4F, 0x01, // ĈO (U+0108 U+004F)
  0x01, 0x08, 0x00, 0x51, 0x01, // ĈQ (U+0108 U+0051)
  0x01, 0x08, 0x00, 0xC7, 0x01, // ĈÇ (U+0108 U+00C7)
  0x01, 0x08, 0x00, 0xD2, 0x01, // ĈÒ (U+0108 U+00D2)
  0x01, 0x08, 0x00, 0xD3, 0x01, // ĈÓ (U+0108 U+00D3)
  0x01, 0x08, 0x00, 0xD4, 0x01, // ĈÔ (U+0108 U+00D4)
  0x01, 0x08, 0x00, 0xD5, 0x01, // ĈÕ (U+0108 U+00D5)
  0x01, 0x08, 0x00, 0xD6, 0x01, // ĈÖ (U+0108 U+00D6)
  0x01, 0x08, 0x00, 0xD8, 0x01, // ĈØ (U+0108 U+00D8)
  0x01, 0x08, 0x01, 0x06, 0x01, // ĈĆ (U+0108 U+0106)
  0x01, 0x08, 0x01, 0x08, 0x01, // ĈĈ (U+0108 U+0108)
  0x01, 0x08, 0x01, 0x0A, 0x01, // ĈĊ (U+0108 U+010A)
  0x01, 0x08, 0x01, 0x0C, 0x01, // ĈČ (U+0108 U+010C)
  0x01, 0x08, 0x01, 0x1C, 0x01, // ĈĜ (U+0108 U+011C)
  0x01, 0x08, 0x01, 0x1E, 0x01, // ĈĞ (U+0108 U+011E)
  0x01, 0x08, 0x01, 0x20, 0x01, // ĈĠ (U+0108 U+0120)
  0x01, 0x08, 0x01, 0x22, 0x01, // ĈĢ (U+0108 U+0122)
  0x01, 0x08, 0x01, 0x4C, 0x01, // ĈŌ (U+0108 U+014C)
  0x01, 0x08, 0x01, 0x4E, 0x01, // ĈŎ (U+0108 U+014E)
  0x01, 0x08, 0x01, 0x50, 0x01, // ĈŐ (U+0108 U+0150)
  0x01, 0x08, 0x01, 0x52, 0x01, // ĈŒ (U+0108 U+0152)
  0x01, 0x0A, 0x00, 0x43, 0x01, // ĊC (U+010A U+0043)
  0x01, 0x0A, 0x00, 0x47, 0x01, // ĊG (U+010A U+0047)
  0x01, 0x0A, 0x00, 0x4F, 0x01, // ĊO (U+010A U+004F)
  0x01, 0x0A, 0x00, 0x51, 0x01, // ĊQ (U+010A U+0051)
  0x01, 0x0A, 0x00, 0xC7, 0x01, // ĊÇ (U+010A U+00C7)
  0x01, 0x0A, 0x00, 0xD2, 0x01, // ĊÒ (U+010A U+00D2)
  0x01, 0x0A, 0x00, 0xD3, 0x01, // ĊÓ (U+010A U+00D3)
  0x01, 0x0A, 0x00, 0xD4, 0x01, // ĊÔ (U+010A U+00D4)
  0x01, 0x0A, 0x00, 0xD5, 0x01, // ĊÕ (U+010A U+00D5)
  0x01, 0x0A, 0x00, 0xD6, 0x01, // ĊÖ (U+010A U+00D6)
  0x01, 0x0A, 0x00, 0xD8, 0x01, // ĊØ (U+010A U+00D8)
  0x01, 0x0A, 0x01, 0x06, 0x01, // ĊĆ (U+010A U+0106)
  0x01, 0x0A, 0x01, 0x08, 0x01, // ĊĈ (U+010A U+0108)
  0x01, 0x0A, 0x01, 0x0A, 0x01, // ĊĊ (U+010A U+010A)
  0x01, 0x0A, 0x01, 0x0C, 0x01, // ĊČ (U+010A U+010C)
  0x01, 0x0A, 0x01, 0x1C, 0x01, // ĊĜ (U+010A U+011C)
  0x01, 0x0A, 0x01, 0x1E, 0x01, // ĊĞ (U+010A U+011E)
  0x01, 0x0A, 0x01, 0x20, 0x01, // ĊĠ (U+010A U+0120)
  0x01, 0x0A, 0x01, 0x22, 0x01, // ĊĢ (U+010A U+0122)
  0x01, 0x0A, 0x01, 0x4C, 0x01, // ĊŌ (U+010A U+014C)
  0x01, 0x0A, 0x01, 0x4E, 0x01, // ĊŎ (U+010A U+014E)
  0x01, 0x0A, 0x01, 0x50, 0x01, // ĊŐ (U+010A U+0150)
  0x01, 0x0A, 0x01, 0x52, 0x01, // ĊŒ (U+010A U+0152)
  0x01, 0x0C, 0x00, 0x43, 0x01, // ČC (U+010C U+0043)
  0x01, 0x0C, 0x00, 0x47, 0x01, // ČG (U+010C U+0047)
  0x01, 0x0C, 0x00, 0x4F, 0x01, // ČO (U+010C U+004F)
  0x01, 0x0C, 0x00, 0x51, 0x01, // ČQ (U+010C U+0051)
  0x01, 0x0C, 0x00, 0xC7, 0x01, // ČÇ (U+010C U+00C7)
  0x01, 0x0C, 0x00, 0xD2, 0x01, // ČÒ (U+010C U+00D2)
  0x01, 0x0C, 0x00, 0xD3, 0x01, // ČÓ (U+010C U+00D3)
  0x01, 0x0C, 0x00, 0xD4, 0x01, // ČÔ (U+010C U+00D4)
  0x01, 0x0C, 0x00, 0xD5, 0x01, // ČÕ (U+010C U+00D5)
  0x01, 0x0C, 0x00, 0xD6, 0x01, // ČÖ (U+010C U+00D6)
  0x01, 0x0C, 0x00, 0xD8, 0x01, // ČØ (U+010C U+00D8)
  0x01, 0x0C, 0x01, 0x06, 0x01, // ČĆ (U+010C U+0106)
  0x01, 0x0C, 0x01, 0x08, 0x01, // ČĈ (U+010C U+0108)
  0x01, 0x0C, 0x01, 0x0A, 0x01, // ČĊ (U+010C U+010A)
  0x01, 0x0C, 0x01, 0x0C, 0x01, // ČČ (U+010C U+010C)
  0x01, 0x0C, 0x01, 0x1C, 0x01, // ČĜ (U+010C U+011C)
  0x01, 0x0C, 0x01, 0x1E, 0x01, // ČĞ (U+010C U+011E)
  0x01, 0x0C, 0x01, 0x20, 0x01, // ČĠ (U+010C U+0120)
  0x01, 0x0C, 0x01, 0x22, 0x01, // ČĢ (U+010C U+0122)
  0x01, 0x0C, 0x01, 0x4C, 0x01, // ČŌ (U+010C U+014C)
  0x01, 0x0C, 0x01, 0x4E, 0x01, // ČŎ (U+010C U+014E)
  0x01, 0x0C, 0x01, 0x50, 0x01, // ČŐ (U+010C U+0150)
  0x01, 0x0C, 0x01, 0x52, 0x01, // ČŒ (U+010C U+0152)
  0x01, 0x0E, 0x00, 0x2C, 0x01, // Ď, (U+010E U+002C)
  0x01, 0x0E, 0x00, 0x2E, 0x01, // Ď. (U+010E U+002E)
  0x01, 0x0E, 0x20, 0x1A, 0x01, // Ď‚ (U+010E U+201A)
  0x01, 0x0E, 0x20, 0x1E, 0x01, // Ď„ (U+010E U+201E)
  0x01, 0x0E, 0x20, 0x26, 0x01, // Ď… (U+010E U+2026)
  0x01, 0x10, 0x00, 0x2C, 0x01, // Đ, (U+0110 U+002C)
  0x01, 0x10, 0x00, 0x2E, 0x01, // Đ. (U+0110 U+002E)
  0x01, 0x10, 0x20, 0x1A, 0x01, // Đ‚ (U+0110 U+201A)
  0x01, 0x10, 0x20, 0x1E, 0x01, // Đ„ (U+0110 U+201E)
  0x01, 0x10, 0x20, 0x26, 0x01, // Đ… (U+0110 U+2026)
  0x01, 0x39, 0x00, 0x22, 0x02, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x02, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x01, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x01, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x62, 0x01, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x01, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x01, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x01, 0x74, 0x01, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x19, 0x02, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x02, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x02, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x02, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x01, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x01, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x62, 0x01, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x01, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x01, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x01, 0x74, 0x01, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x19, 0x02, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x02, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x02, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x02, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x00, 0x54, 0x01, // ĽT (U+013D U+0054)
  0x01, 0x3D, 0x00, 0x56, 0x01, // ĽV (U+013D U+0056)
  0x01, 0x3D, 0x00, 0x57, 0x01, // ĽW (U+013D U+0057)
  0x01, 0x3D, 0x00, 0x59, 0x01, // ĽY (U+013D U+0059)
  0x01, 0x3D, 0x00, 0xDD, 0x01, // ĽÝ (U+013D U+00DD)
  0x01, 0x3D, 0x01, 0x62, 0x01, // ĽŢ (U+013D U+0162)
  0x01, 0x3D, 0x01, 0x64, 0x01, // ĽŤ (U+013D U+0164)
  0x01, 0x3D, 0x01, 0x66, 0x01, // ĽŦ (U+013D U+0166)
  0x01, 0x3D, 0x01, 0x74, 0x01, // ĽŴ (U+013D U+0174)
  0x01, 0x3D, 0x01, 0x76, 0x01, // ĽŶ (U+013D U+0176)
  0x01, 0x3D, 0x01, 0x78, 0x01, // ĽŸ (U+013D U+0178)
  0x01, 0x3D, 0x20, 0x19, 0x02, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x02, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x02, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x02, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x00, 0x54, 0x01, // ĿT (U+013F U+0054)
  0x01, 0x3F, 0x00, 0x56, 0x01, // ĿV (U+013F U+0056)
  0x01, 0x3F, 0x00, 0x57, 0x01, // ĿW (U+013F U+0057)
  0x01, 0x3F, 0x00, 0x59, 0x01, // ĿY (U+013F U+0059)
  0x01, 0x3F, 0x00, 0xDD, 0x01, // ĿÝ (U+013F U+00DD)
  0x01, 0x3F, 0x01, 0x62, 0x01, // ĿŢ (U+013F U+0162)
  0x01, 0x3F, 0x01, 0x64, 0x01, // ĿŤ (U+013F U+0164)
  0x01, 0x3F, 0x01, 0x66, 0x01, // ĿŦ (U+013F U+0166)
  0x01, 0x3F, 0x01, 0x74, 0x01, // ĿŴ (U+013F U+0174)
  0x01, 0x3F, 0x01, 0x76, 0x01, // ĿŶ (U+013F U+0176)
  0x01, 0x3F, 0x01, 0x78, 0x01, // ĿŸ (U+013F U+0178)
  0x01, 0x3F, 0x20, 0x19, 0x02, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x02, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x02, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x02, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x01, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x01, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x62, 0x01, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x01, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x01, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x01, 0x74, 0x01, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x19, 0x02, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x02, // Ł” (U+0141 U+201D)
  0x01, 0x4C, 0x00, 0x2C, 0x01, // Ō, (U+014C U+002C)
  0x01, 0x4C, 0x00, 0x2E, 0x01, // Ō. (U+014C U+002E)
  0x01, 0x4C, 0x20, 0x1A, 0x01, // Ō‚ (U+014C U+201A)
  0x01, 0x4C, 0x20, 0x1E, 0x01, // Ō„ (U+014C U+201E)
  0x01, 0x4C, 0x20, 0x26, 0x01, // Ō… (U+014C U+2026)
  0x01, 0x4E, 0x00, 0x2C, 0x01, // Ŏ, (U+014E U+002C)
  0x01, 0x4E, 0x00, 0x2E, 0x01, // Ŏ. (U+014E U+002E)
  0x01, 0x4E, 0x20, 0x1A, 0x01, // Ŏ‚ (U+014E U+201A)
  0x01, 0x4E, 0x20, 0x1E, 0x01, // Ŏ„ (U+014E U+201E)
  0x01, 0x4E, 0x20, 0x26, 0x01, // Ŏ… (U+014E U+2026)
  0x01, 0x50, 0x00, 0x2C, 0x01, // Ő, (U+0150 U+002C)
  0x01, 0x50, 0x00, 0x2E, 0x01, // Ő. (U+0150 U+002E)
  0x01, 0x50, 0x20, 0x1A, 0x01, // Ő‚ (U+0150 U+201A)
  0x01, 0x50, 0x20, 0x1E, 0x01, // Ő„ (U+0150 U+201E)
  0x01, 0x50, 0x20, 0x26, 0x01, // Ő… (U+0150 U+2026)
  0x01, 0x55, 0x00, 0x2C, 0x02, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x02, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x02, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x02, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x02, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x02, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x02, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x02, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x02, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x02, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x02, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x02, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x02, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x02, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x02, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2D, 0x01, // Ţ- (U+0162 U+002D)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x02, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x02, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x02, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x02, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x02, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x01, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x01, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x02, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x01, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x02, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x01, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x01, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x01, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0x7A, 0x01, // Ţz (U+0162 U+007A)
  0x01, 0x62, 0x00, 0xAB, 0x01, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xBB, 0x01, // Ţ» (U+0162 U+00BB)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xE0, 0x02, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x02, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x02, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x02, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x02, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x02, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x02, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x02, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x02, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x02, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x02, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x02, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x02, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x02, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x02, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x02, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x02, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x02, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x01, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x01, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x01, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x01, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x02, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x02, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x02, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x02, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x02, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x02, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x02, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x02, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x02, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x02, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x02, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x02, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x02, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x02, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x02, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x02, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x02, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x02, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x01, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x01, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x01, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x4B, 0x01, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4D, 0x02, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x02, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x02, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x02, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x01, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x01, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x01, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5F, 0x01, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x69, 0x01, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x01, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x01, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x01, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x01, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x01, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x01, 0x7A, 0x01, // Ţź (U+0162 U+017A)
  0x01, 0x62, 0x01, 0x7C, 0x01, // Ţż (U+0162 U+017C)
  0x01, 0x62, 0x01, 0x7E, 0x01, // Ţž (U+0162 U+017E)
  0x01, 0x62, 0x20, 0x13, 0x01, // Ţ– (U+0162 U+2013)
  0x01, 0x62, 0x20, 0x14, 0x01, // Ţ— (U+0162 U+2014)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x01, // Ţ‹ (U+0162 U+2039)
  0x01, 0x62, 0x20, 0x3A, 0x01, // Ţ› (U+0162 U+203A)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2D, 0x01, // Ť- (U+0164 U+002D)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x02, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x02, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x02, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x02, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x02, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x01, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x01, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x02, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x01, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x02, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x01, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x01, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x01, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0x7A, 0x01, // Ťz (U+0164 U+007A)
  0x01, 0x64, 0x00, 0xAB, 0x01, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xBB, 0x01, // Ť» (U+0164 U+00BB)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xE0, 0x02, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x02, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x02, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x02, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x02, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x02, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x02, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x02, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x02, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x02, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x02, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x02, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x02, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x02, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x02, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x02, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x02, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x02, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x01, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x01, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x01, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x01, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x02, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x02, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x02, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x02, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x02, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x02, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x02, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x02, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x02, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x02, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x02, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x02, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x02, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x02, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x02, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x02, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x02, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x02, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x01, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x01, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x01, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x4B, 0x01, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4D, 0x02, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x02, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x02, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x02, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x01, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x01, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x01, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5F, 0x01, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x69, 0x01, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x01, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x01, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x01, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x01, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x01, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x01, 0x7A, 0x01, // Ťź (U+0164 U+017A)
  0x01, 0x64, 0x01, 0x7C, 0x01, // Ťż (U+0164 U+017C)
  0x01, 0x64, 0x01, 0x7E, 0x01, // Ťž (U+0164 U+017E)
  0x01, 0x64, 0x20, 0x13, 0x01, // Ť– (U+0164 U+2013)
  0x01, 0x64, 0x20, 0x14, 0x01, // Ť— (U+0164 U+2014)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x01, // Ť‹ (U+0164 U+2039)
  0x01, 0x64, 0x20, 0x3A, 0x01, // Ť› (U+0164 U+203A)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2D, 0x01, // Ŧ- (U+0166 U+002D)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x02, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x02, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x02, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x02, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x02, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x01, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x01, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x02, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x01, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x02, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x01, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x01, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x01, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0x7A, 0x01, // Ŧz (U+0166 U+007A)
  0x01, 0x66, 0x00, 0xAB, 0x01, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xBB, 0x01, // Ŧ» (U+0166 U+00BB)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xE0, 0x02, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x02, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x02, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x02, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x02, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x02, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x02, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x02, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x02, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x02, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x02, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x02, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x02, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x02, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x02, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x02, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x02, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x02, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x01, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x01, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x01, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x01, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x02, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x02, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x02, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x02, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x02, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x02, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x02, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x02, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x02, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x02, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x02, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x02, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x02, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x02, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x02, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x02, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x02, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x02, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x01, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x01, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x01, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x4B, 0x01, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4D, 0x02, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x02, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x02, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x02, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x01, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x01, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x01, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5F, 0x01, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x69, 0x01, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x01, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x01, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x01, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x01, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x01, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x01, 0x7A, 0x01, // Ŧź (U+0166 U+017A)
  0x01, 0x66, 0x01, 0x7C, 0x01, // Ŧż (U+0166 U+017C)
  0x01, 0x66, 0x01, 0x7E, 0x01, // Ŧž (U+0166 U+017E)
  0x01, 0x66, 0x20, 0x13, 0x01, // Ŧ– (U+0166 U+2013)
  0x01, 0x66, 0x20, 0x14, 0x01, // Ŧ— (U+0166 U+2014)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x01, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x66, 0x20, 0x3A, 0x01, // Ŧ› (U+0166 U+203A)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0xAB, 0x01, // Ŵ« (U+0174 U+00AB)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x74, 0x20, 0x39, 0x01, // Ŵ‹ (U+0174 U+2039)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6D, 0x01, // Ŷm (U+0176 U+006D)
  0x01, 0x76, 0x00, 0x6E, 0x01, // Ŷn (U+0176 U+006E)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x70, 0x01, // Ŷp (U+0176 U+0070)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x72, 0x01, // Ŷr (U+0176 U+0072)
  0x01, 0x76, 0x00, 0x73, 0x01, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0x75, 0x01, // Ŷu (U+0176 U+0075)
  0x01, 0x76, 0x00, 0xAB, 0x02, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xBB, 0x01, // Ŷ» (U+0176 U+00BB)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x00, 0xF9, 0x01, // Ŷù (U+0176 U+00F9)
  0x01, 0x76, 0x00, 0xFA, 0x01, // Ŷú (U+0176 U+00FA)
  0x01, 0x76, 0x00, 0xFB, 0x01, // Ŷû (U+0176 U+00FB)
  0x01, 0x76, 0x00, 0xFC, 0x01, // Ŷü (U+0176 U+00FC)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x38, 0x01, // Ŷĸ (U+0176 U+0138)
  0x01, 0x76, 0x01, 0x44, 0x01, // Ŷń (U+0176 U+0144)
  0x01, 0x76, 0x01, 0x46, 0x01, // Ŷņ (U+0176 U+0146)
  0x01, 0x76, 0x01, 0x4B, 0x01, // Ŷŋ (U+0176 U+014B)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x55, 0x01, // Ŷŕ (U+0176 U+0155)
  0x01, 0x76, 0x01, 0x57, 0x01, // Ŷŗ (U+0176 U+0157)
  0x01, 0x76, 0x01, 0x5B, 0x01, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5F, 0x01, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x69, 0x01, // Ŷũ (U+0176 U+0169)
  0x01, 0x76, 0x01, 0x6B, 0x01, // Ŷū (U+0176 U+016B)
  0x01, 0x76, 0x01, 0x6D, 0x01, // Ŷŭ (U+0176 U+016D)
  0x01, 0x76, 0x01, 0x6F, 0x01, // Ŷů (U+0176 U+016F)
  0x01, 0x76, 0x01, 0x71, 0x01, // Ŷű (U+0176 U+0171)
  0x01, 0x76, 0x01, 0x73, 0x01, // Ŷų (U+0176 U+0173)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x02, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x76, 0x20, 0x3A, 0x01, // Ŷ› (U+0176 U+203A)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6D, 0x01, // Ÿm (U+0178 U+006D)
  0x01, 0x78, 0x00, 0x6E, 0x01, // Ÿn (U+0178 U+006E)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x70, 0x01, // Ÿp (U+0178 U+0070)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x72, 0x01, // Ÿr (U+0178 U+0072)
  0x01, 0x78, 0x00, 0x73, 0x01, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0x75, 0x01, // Ÿu (U+0178 U+0075)
  0x01, 0x78, 0x00, 0xAB, 0x02, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xBB, 0x01, // Ÿ» (U+0178 U+00BB)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x00, 0xF9, 0x01, // Ÿù (U+0178 U+00F9)
  0x01, 0x78, 0x00, 0xFA, 0x01, // Ÿú (U+0178 U+00FA)
  0x01, 0x78, 0x00, 0xFB, 0x01, // Ÿû (U+0178 U+00FB)
  0x01, 0x78, 0x00, 0xFC, 0x01, // Ÿü (U+0178 U+00FC)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x38, 0x01, // Ÿĸ (U+0178 U+0138)
  0x01, 0x78, 0x01, 0x44, 0x01, // Ÿń (U+0178 U+0144)
  0x01, 0x78, 0x01, 0x46, 0x01, // Ÿņ (U+0178 U+0146)
  0x01, 0x78, 0x01, 0x4B, 0x01, // Ÿŋ (U+0178 U+014B)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x55, 0x01, // Ÿŕ (U+0178 U+0155)
  0x01, 0x78, 0x01, 0x57, 0x01, // Ÿŗ (U+0178 U+0157)
  0x01, 0x78, 0x01, 0x5B, 0x01, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5F, 0x01, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x69, 0x01, // Ÿũ (U+0178 U+0169)
  0x01, 0x78, 0x01, 0x6B, 0x01, // Ÿū (U+0178 U+016B)
  0x01, 0x78, 0x01, 0x6D, 0x01, // Ÿŭ (U+0178 U+016D)
  0x01, 0x78, 0x01, 0x6F, 0x01, // Ÿů (U+0178 U+016F)
  0x01, 0x78, 0x01, 0x71, 0x01, // Ÿű (U+0178 U+0171)
  0x01, 0x78, 0x01, 0x73, 0x01, // Ÿų (U+0178 U+0173)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x02, // Ÿ‹ (U+0178 U+2039)
  0x01, 0x78, 0x20, 0x3A, 0x01, // Ÿ› (U+0178 U+203A)
  0x20, 0x13, 0x00, 0x54, 0x01, // –T (U+2013 U+0054)
  0x20, 0x13, 0x01, 0x62, 0x01, // –Ţ (U+2013 U+0162)
  0x20, 0x13, 0x01, 0x64, 0x01, // –Ť (U+2013 U+0164)
  0x20, 0x13, 0x01, 0x66, 0x01, // –Ŧ (U+2013 U+0166)
  0x20, 0x14, 0x00, 0x54, 0x01, // —T (U+2014 U+0054)
  0x20, 0x14, 0x01, 0x62, 0x01, // —Ţ (U+2014 U+0162)
  0x20, 0x14, 0x01, 0x64, 0x01, // —Ť (U+2014 U+0164)
  0x20, 0x14, 0x01, 0x66, 0x01, // —Ŧ (U+2014 U+0166)
  0x20, 0x18, 0x00, 0x41, 0x02, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x61, 0x01, // ‘a (U+2018 U+0061)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x67, 0x01, // ‘g (U+2018 U+0067)
  0x20, 0x18, 0x00, 0x6D, 0x01, // ‘m (U+2018 U+006D)
  0x20, 0x18, 0x00, 0x6E, 0x01, // ‘n (U+2018 U+006E)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x70, 0x01, // ‘p (U+2018 U+0070)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0x72, 0x01, // ‘r (U+2018 U+0072)
  0x20, 0x18, 0x00, 0x73, 0x01, // ‘s (U+2018 U+0073)
  0x20, 0x18, 0x00, 0x75, 0x01, // ‘u (U+2018 U+0075)
  0x20, 0x18, 0x00, 0xC0, 0x02, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x02, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x02, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x02, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x02, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x02, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x02, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE1, 0x01, // ‘á (U+2018 U+00E1)
  0x20, 0x18, 0x00, 0xE2, 0x01, // ‘â (U+2018 U+00E2)
  0x20, 0x18, 0x00, 0xE3, 0x01, // ‘ã (U+2018 U+00E3)
  0x20, 0x18, 0x00, 0xE4, 0x01, // ‘ä (U+2018 U+00E4)
  0x20, 0x18, 0x00, 0xE5, 0x01, // ‘å (U+2018 U+00E5)
  0x20, 0x18, 0x00, 0xE6, 0x01, // ‘æ (U+2018 U+00E6)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x00, 0xF9, 0x01, // ‘ù (U+2018 U+00F9)
  0x20, 0x18, 0x00, 0xFA, 0x01, // ‘ú (U+2018 U+00FA)
  0x20, 0x18, 0x00, 0xFB, 0x01, // ‘û (U+2018 U+00FB)
  0x20, 0x18, 0x00, 0xFC, 0x01, // ‘ü (U+2018 U+00FC)
  0x20, 0x18, 0x01, 0x00, 0x02, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x01, 0x01, // ‘ā (U+2018 U+0101)
  0x20, 0x18, 0x01, 0x02, 0x02, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x03, 0x01, // ‘ă (U+2018 U+0103)
  0x20, 0x18, 0x01, 0x04, 0x02, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x05, 0x01, // ‘ą (U+2018 U+0105)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x1D, 0x01, // ‘ĝ (U+2018 U+011D)
  0x20, 0x18, 0x01, 0x1F, 0x01, // ‘ğ (U+2018 U+011F)
  0x20, 0x18, 0x01, 0x21, 0x01, // ‘ġ (U+2018 U+0121)
  0x20, 0x18, 0x01, 0x23, 0x01, // ‘ģ (U+2018 U+0123)
  0x20, 0x18, 0x01, 0x38, 0x01, // ‘ĸ (U+2018 U+0138)
  0x20, 0x18, 0x01, 0x44, 0x01, // ‘ń (U+2018 U+0144)
  0x20, 0x18, 0x01, 0x46, 0x01, // ‘ņ (U+2018 U+0146)
  0x20, 0x18, 0x01, 0x4B, 0x01, // ‘ŋ (U+2018 U+014B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x18, 0x01, 0x55, 0x01, // ‘ŕ (U+2018 U+0155)
  0x20, 0x18, 0x01, 0x57, 0x01, // ‘ŗ (U+2018 U+0157)
  0x20, 0x18, 0x01, 0x5B, 0x01, // ‘ś (U+2018 U+015B)
  0x20, 0x18, 0x01, 0x5F, 0x01, // ‘ş (U+2018 U+015F)
  0x20, 0x18, 0x01, 0x69, 0x01, // ‘ũ (U+2018 U+0169)
  0x20, 0x18, 0x01, 0x6B, 0x01, // ‘ū (U+2018 U+016B)
  0x20, 0x18, 0x01, 0x6D, 0x01, // ‘ŭ (U+2018 U+016D)
  0x20, 0x18, 0x01, 0x6F, 0x01, // ‘ů (U+2018 U+016F)
  0x20, 0x18, 0x01, 0x71, 0x01, // ‘ű (U+2018 U+0171)
  0x20, 0x18, 0x01, 0x73, 0x01, // ‘ų (U+2018 U+0173)
  0x20, 0x19, 0x00, 0x41, 0x02, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x61, 0x01, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x67, 0x01, // ’g (U+2019 U+0067)
  0x20, 0x19, 0x00, 0x6D, 0x01, // ’m (U+2019 U+006D)
  0x20, 0x19, 0x00, 0x6E, 0x01, // ’n (U+2019 U+006E)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x70, 0x01, // ’p (U+2019 U+0070)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0x72, 0x01, // ’r (U+2019 U+0072)
  0x20, 0x19, 0x00, 0x73, 0x01, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0x75, 0x01, // ’u (U+2019 U+0075)
  0x20, 0x19, 0x00, 0xC0, 0x02, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x02, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x02, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x02, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x02, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x02, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x02, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x01, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x01, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x01, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x01, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x01, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x01, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x00, 0xF9, 0x01, // ’ù (U+2019 U+00F9)
  0x20, 0x19, 0x00, 0xFA, 0x01, // ’ú (U+2019 U+00FA)
  0x20, 0x19, 0x00, 0xFB, 0x01, // ’û (U+2019 U+00FB)
  0x20, 0x19, 0x00, 0xFC, 0x01, // ’ü (U+2019 U+00FC)
  0x20, 0x19, 0x01, 0x00, 0x02, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x01, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x02, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x01, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x02, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x01, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x1D, 0x01, // ’ĝ (U+2019 U+011D)
  0x20, 0x19, 0x01, 0x1F, 0x01, // ’ğ (U+2019 U+011F)
  0x20, 0x19, 0x01, 0x21, 0x01, // ’ġ (U+2019 U+0121)
  0x20, 0x19, 0x01, 0x23, 0x01, // ’ģ (U+2019 U+0123)
  0x20, 0x19, 0x01, 0x38, 0x01, // ’ĸ (U+2019 U+0138)
  0x20, 0x19, 0x01, 0x44, 0x01, // ’ń (U+2019 U+0144)
  0x20, 0x19, 0x01, 0x46, 0x01, // ’ņ (U+2019 U+0146)
  0x20, 0x19, 0x01, 0x4B, 0x01, // ’ŋ (U+2019 U+014B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x19, 0x01, 0x55, 0x01, // ’ŕ (U+2019 U+0155)
  0x20, 0x19, 0x01, 0x57, 0x01, // ’ŗ (U+2019 U+0157)
  0x20, 0x19, 0x01, 0x5B, 0x01, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5F, 0x01, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x69, 0x01, // ’ũ (U+2019 U+0169)
  0x20, 0x19, 0x01, 0x6B, 0x01, // ’ū (U+2019 U+016B)
  0x20, 0x19, 0x01, 0x6D, 0x01, // ’ŭ (U+2019 U+016D)
  0x20, 0x19, 0x01, 0x6F, 0x01, // ’ů (U+2019 U+016F)
  0x20, 0x19, 0x01, 0x71, 0x01, // ’ű (U+2019 U+0171)
  0x20, 0x19, 0x01, 0x73, 0x01, // ’ų (U+2019 U+0173)
  0x20, 0x1A, 0x00, 0x43, 0x01, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x01, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x01, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x01, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x02, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x01, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x01, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x01, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x01, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x01, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x01, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x01, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x01, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x01, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x01, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x01, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x01, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x01, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x01, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x01, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x01, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x01, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x01, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x01, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x02, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x02, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x02, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x02, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x61, 0x01, // “a (U+201C U+0061)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x67, 0x01, // “g (U+201C U+0067)
  0x20, 0x1C, 0x00, 0x6D, 0x01, // “m (U+201C U+006D)
  0x20, 0x1C, 0x00, 0x6E, 0x01, // “n (U+201C U+006E)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x70, 0x01, // “p (U+201C U+0070)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0x72, 0x01, // “r (U+201C U+0072)
  0x20, 0x1C, 0x00, 0x73, 0x01, // “s (U+201C U+0073)
  0x20, 0x1C, 0x00, 0x75, 0x01, // “u (U+201C U+0075)
  0x20, 0x1C, 0x00, 0xC0, 0x02, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x02, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x02, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x02, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x02, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x02, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x02, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE1, 0x01, // “á (U+201C U+00E1)
  0x20, 0x1C, 0x00, 0xE2, 0x01, // “â (U+201C U+00E2)
  0x20, 0x1C, 0x00, 0xE3, 0x01, // “ã (U+201C U+00E3)
  0x20, 0x1C, 0x00, 0xE4, 0x01, // “ä (U+201C U+00E4)
  0x20, 0x1C, 0x00, 0xE5, 0x01, // “å (U+201C U+00E5)
  0x20, 0x1C, 0x00, 0xE6, 0x01, // “æ (U+201C U+00E6)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x00, 0xF9, 0x01, // “ù (U+201C U+00F9)
  0x20, 0x1C, 0x00, 0xFA, 0x01, // “ú (U+201C U+00FA)
  0x20, 0x1C, 0x00, 0xFB, 0x01, // “û (U+201C U+00FB)
  0x20, 0x1C, 0x00, 0xFC, 0x01, // “ü (U+201C U+00FC)
  0x20, 0x1C, 0x01, 0x00, 0x02, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x01, 0x01, // “ā (U+201C U+0101)
  0x20, 0x1C, 0x01, 0x02, 0x02, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x03, 0x01, // “ă (U+201C U+0103)
  0x20, 0x1C, 0x01, 0x04, 0x02, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x05, 0x01, // “ą (U+201C U+0105)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x1D, 0x01, // “ĝ (U+201C U+011D)
  0x20, 0x1C, 0x01, 0x1F, 0x01, // “ğ (U+201C U+011F)
  0x20, 0x1C, 0x01, 0x21, 0x01, // “ġ (U+201C U+0121)
  0x20, 0x1C, 0x01, 0x23, 0x01, // “ģ (U+201C U+0123)
  0x20, 0x1C, 0x01, 0x38, 0x01, // “ĸ (U+201C U+0138)
  0x20, 0x1C, 0x01, 0x44, 0x01, // “ń (U+201C U+0144)
  0x20, 0x1C, 0x01, 0x46, 0x01, // “ņ (U+201C U+0146)
  0x20, 0x1C, 0x01, 0x4B, 0x01, // “ŋ (U+201C U+014B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1C, 0x01, 0x55, 0x01, // “ŕ (U+201C U+0155)
  0x20, 0x1C, 0x01, 0x57, 0x01, // “ŗ (U+201C U+0157)
  0x20, 0x1C, 0x01, 0x5B, 0x01, // “ś (U+201C U+015B)
  0x20, 0x1C, 0x01, 0x5F, 0x01, // “ş (U+201C U+015F)
  0x20, 0x1C, 0x01, 0x69, 0x01, // “ũ (U+201C U+0169)
  0x20, 0x1C, 0x01, 0x6B, 0x01, // “ū (U+201C U+016B)
  0x20, 0x1C, 0x01, 0x6D, 0x01, // “ŭ (U+201C U+016D)
  0x20, 0x1C, 0x01, 0x6F, 0x01, // “ů (U+201C U+016F)
  0x20, 0x1C, 0x01, 0x71, 0x01, // “ű (U+201C U+0171)
  0x20, 0x1C, 0x01, 0x73, 0x01, // “ų (U+201C U+0173)
  0x20, 0x1D, 0x00, 0x41, 0x02, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x61, 0x01, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x67, 0x01, // ”g (U+201D U+0067)
  0x20, 0x1D, 0x00, 0x6D, 0x01, // ”m (U+201D U+006D)
  0x20, 0x1D, 0x00, 0x6E, 0x01, // ”n (U+201D U+006E)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x70, 0x01, // ”p (U+201D U+0070)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0x72, 0x01, // ”r (U+201D U+0072)
  0x20, 0x1D, 0x00, 0x73, 0x01, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0x75, 0x01, // ”u (U+201D U+0075)
  0x20, 0x1D, 0x00, 0xC0, 0x02, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x02, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x02, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x02, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x02, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x02, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x02, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x01, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x01, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x01, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x01, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x01, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x01, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x00, 0xF9, 0x01, // ”ù (U+201D U+00F9)
  0x20, 0x1D, 0x00, 0xFA, 0x01, // ”ú (U+201D U+00FA)
  0x20, 0x1D, 0x00, 0xFB, 0x01, // ”û (U+201D U+00FB)
  0x20, 0x1D, 0x00, 0xFC, 0x01, // ”ü (U+201D U+00FC)
  0x20, 0x1D, 0x01, 0x00, 0x02, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x01, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x02, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x01, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x02, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x01, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x1D, 0x01, // ”ĝ (U+201D U+011D)
  0x20, 0x1D, 0x01, 0x1F, 0x01, // ”ğ (U+201D U+011F)
  0x20, 0x1D, 0x01, 0x21, 0x01, // ”ġ (U+201D U+0121)
  0x20, 0x1D, 0x01, 0x23, 0x01, // ”ģ (U+201D U+0123)
  0x20, 0x1D, 0x01, 0x38, 0x01, // ”ĸ (U+201D U+0138)
  0x20, 0x1D, 0x01, 0x44, 0x01, // ”ń (U+201D U+0144)
  0x20, 0x1D, 0x01, 0x46, 0x01, // ”ņ (U+201D U+0146)
  0x20, 0x1D, 0x01, 0x4B, 0x01, // ”ŋ (U+201D U+014B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1D, 0x01, 0x55, 0x01, // ”ŕ (U+201D U+0155)
  0x20, 0x1D, 0x01, 0x57, 0x01, // ”ŗ (U+201D U+0157)
  0x20, 0x1D, 0x01, 0x5B, 0x01, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5F, 0x01, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x69, 0x01, // ”ũ (U+201D U+0169)
  0x20, 0x1D, 0x01, 0x6B, 0x01, // ”ū (U+201D U+016B)
  0x20, 0x1D, 0x01, 0x6D, 0x01, // ”ŭ (U+201D U+016D)
  0x20, 0x1D, 0x01, 0x6F, 0x01, // ”ů (U+201D U+016F)
  0x20, 0x1D, 0x01, 0x71, 0x01, // ”ű (U+201D U+0171)
  0x20, 0x1D, 0x01, 0x73, 0x01, // ”ų (U+201D U+0173)
  0x20, 0x1E, 0x00, 0x43, 0x01, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x01, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x01, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x01, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x02, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x01, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x01, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x01, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x01, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x01, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x01, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x01, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x01, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x01, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x01, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x01, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x01, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x01, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x01, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x01, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x01, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x01, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x01, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x01, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x02, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x02, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x02, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x39, 0x00, 0x54, 0x01, // ‹T (U+2039 U+0054)
  0x20, 0x39, 0x00, 0x59, 0x01, // ‹Y (U+2039 U+0059)
  0x20, 0x39, 0x00, 0xDD, 0x01, // ‹Ý (U+2039 U+00DD)
  0x20, 0x39, 0x01, 0x62, 0x01, // ‹Ţ (U+2039 U+0162)
  0x20, 0x39, 0x01, 0x64, 0x01, // ‹Ť (U+2039 U+0164)
  0x20, 0x39, 0x01, 0x66, 0x01, // ‹Ŧ (U+2039 U+0166)
  0x20, 0x39, 0x01, 0x76, 0x01, // ‹Ŷ (U+2039 U+0176)
  0x20, 0x39, 0x01, 0x78, 0x01, // ‹Ÿ (U+2039 U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x01, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x56, 0x01, // ›V (U+203A U+0056)
  0x20, 0x3A, 0x00, 0x57, 0x01, // ›W (U+203A U+0057)
  0x20, 0x3A, 0x00, 0x59, 0x02, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x02, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x01, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x01, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x01, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x74, 0x01, // ›Ŵ (U+203A U+0174)
  0x20, 0x3A, 0x01, 0x76, 0x02, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x02, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x05, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x05, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x05, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x05, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x05, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x05, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x05, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x05, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x05, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x05, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x0A, 0xA0, 0x70, 0xAA, 0x07, 0x09, 0xA0, 0x60, 0x8A, 0x06, 0x08, 0xA0, 0x50, 0x7A, 0x04, 0x07,
  0xA0, 0x40, 0x6A, 0x03, 0x05, 0xA0, 0x30, 0x5A, 0x02, 0x04, 0xA0, 0x10, 0x3A, 0x01, 0x03, 0xA1,
  0x02, 0xA1, 0x85, 0x2F, 0xE0, 0x1F, 0xE2, 0x90, 0xD7, 0x28, 0x35, 0xED, 0x3C, 0xA0, 0xA0, 0xCA,
  0x83, 0xA5, 0xED, 0x30,
  // """ (U+0022)
  0xA0, 0xD2, 0x07, 0xA0, 0x7A, 0x0C, 0x20, 0x6A, 0x82, 0x6D, 0xFB, 0x20, 0x5A, 0x82, 0x5C, 0xFA,
  0x20, 0x4A, 0x82, 0x4B, 0xF9, 0x20, 0x3A, 0x82, 0x2A, 0xF8, 0x20, 0x1A, 0x82, 0x19, 0xF7, 0x3A,
  0x18, 0x18, 0xF6, 0x3A, 0x10,
  // "#" (U+0023)
  0x50, 0x1A, 0x38, 0x15, 0xFA, 0x78, 0x13, 0xFD, 0x38, 0x18, 0xF7, 0x78, 0x15, 0xFB, 0x38, 0x1A,
  0xF5, 0x78, 0x18, 0xF8, 0x38, 0x1D, 0xF2, 0x78, 0x1A, 0xF6, 0x3A, 0x71, 0x81, 0xCF, 0x32, 0x81,
  0x2F, 0xD4, 0x07, 0xFE, 0x81, 0xD0, 0x7F, 0xE0, 0xD2, 0x89, 0x11, 0x15, 0xFC, 0x11, 0x1A, 0xF8,
  0x0F, 0x14, 0x81, 0x6F, 0xA3, 0x81, 0xBF, 0x57, 0x81, 0x8F, 0x83, 0x81, 0xDF, 0x37, 0x81, 0xAF,
  0x63, 0xA0, 0x17, 0x81, 0xCF, 0x42, 0x81, 0x2F, 0xE4, 0x89, 0x71, 0x55, 0x5E, 0xF7, 0x55, 0x8F,
  0xD5, 0x55, 0x05, 0xFF, 0x10, 0x5F, 0xF4, 0x81, 0x5F, 0xB3, 0x81, 0xAF, 0x57, 0x81, 0x7F, 0x93,
  0x81, 0xDF, 0x37, 0x81, 0x9F, 0x73, 0xA0, 0x17, 0x81, 0xBF, 0x42, 0x81, 0x1F, 0xE7, 0x18, 0x1D,
  0xF2, 0x28, 0x14, 0xFC, 0x71, 0xA3, 0x81, 0x6F, 0xA7, 0x81, 0x2F, 0xD3, 0x81, 0x8F, 0x85,
  // "$" (U+0024)
  0x58, 0x14, 0xF6, 0x73, 0x81, 0x4F, 0x67, 0x38, 0x25, 0xF7, 0x16, 0x81, 0x18, 0xEC, 0x81, 0xEA,
  0x52, 0x02, 0x0D, 0xF9, 0x0E, 0x20, 0xCA, 0x89, 0x09, 0x8F, 0x85, 0x8D, 0xA0, 0x3A, 0x83, 0x70,
  0x4F, 0x63, 0x81, 0x10, 0x6A, 0x28, 0x14, 0xF6, 0x50, 0x7A, 0x28, 0x14, 0xF6, 0x50, 0x5A, 0x83,
  0x30, 0x4F, 0x65, 0x01, 0xA8, 0x3D, 0x24, 0xF6, 0x60, 0x7B, 0x81, 0xCF, 0x67, 0x07, 0xC0, 0xD0,
  0x67, 0x81, 0x19, 0xEB, 0x0D, 0x04, 0x78, 0x15, 0xFE, 0xB0, 0x76, 0x83, 0x4F, 0x64, 0xDA, 0x03,
  0x58, 0x34, 0xF6, 0x02, 0xA0, 0x85, 0x81, 0x4F, 0x62, 0x81, 0xCF, 0xA5, 0x81, 0x4F, 0x62, 0x82,
  0xCF, 0x91, 0x48, 0x34, 0xF6, 0x03, 0xA8, 0x95, 0x67, 0xD8, 0x41, 0x5F, 0x77, 0xEF, 0xE0, 0x7F,
  0xA8, 0x4E, 0x30, 0x3A, 0xED, 0x81, 0xE9, 0x15, 0x83, 0x24, 0x8F, 0x77, 0x38, 0x14, 0xF6, 0x73,
  0x81, 0x4F, 0x67, 0x38, 0x14, 0xF5, 0x50,
  // "%" (U+0025)
  0x28, 0x36, 0xDF, 0xC3, 0x68, 0x12, 0xFE, 0x60, 0x6D, 0x02, 0x58, 0x19, 0xF9, 0x68, 0x5E, 0xFB,
  0x6D, 0xFA, 0x58, 0x1E, 0xF3, 0x58, 0x13, 0xFE, 0x20, 0x4A, 0x48, 0x16, 0xFC, 0x68, 0x16, 0xFB,
  0x3A, 0x03, 0x38, 0x1C, 0xF5, 0x68, 0x18, 0xF9, 0x38, 0x1D, 0xF5, 0x28, 0x13, 0xFE, 0x78, 0x19,
  0xF9, 0x38, 0x1C, 0xF6, 0x28, 0x1A, 0xF8, 0x78, 0x19, 0xF9, 0x38, 0x3C, 0xF6, 0x01, 0xA0, 0x27,
  0x81, 0x8F, 0x93, 0x89, 0x3D, 0xF5, 0x07, 0xFB, 0x05, 0xDF, 0xC3, 0x28, 0x16, 0xFB, 0x3A, 0x84,
  0x30, 0xDF, 0x54, 0xC8, 0x4E, 0x20, 0x3F, 0xE2, 0x04, 0xA1, 0x89, 0x14, 0xFE, 0x0C, 0xF8, 0x0A,
  0xFA, 0x28, 0x92, 0xDF, 0xB6, 0xDF, 0xA0, 0xAF, 0x72, 0xA2, 0x02, 0xA2, 0x05, 0xD0, 0x20, 0x1A,
  0x82, 0x15, 0xFC, 0x38, 0x1E, 0xF3, 0x28, 0x93, 0x6D, 0xFC, 0x30, 0x8F, 0xA0, 0x7F, 0xA3, 0x81,
  0xCF, 0x67, 0x18, 0x5E, 0xF4, 0x08, 0xFA, 0x38, 0x1B, 0xF7, 0x78, 0x15, 0xFD, 0x28, 0x18, 0xFA,
  0x38, 0x1B, 0xF7, 0x78, 0x1B, 0xF7, 0x28, 0x18, 0xFA, 0x38, 0x1B, 0xF7, 0x60, 0x2A, 0x01, 0x28,
  0x17, 0xFB, 0x38, 0x1D, 0xF6, 0x68, 0x18, 0xFA, 0x38, 0x14, 0xFD, 0x3A, 0x03, 0x68, 0x1E, 0xF3,
  0x30, 0x1A, 0x81, 0x20, 0x4A, 0x68, 0x15, 0xFC, 0x58, 0x5B, 0xFC, 0x6D, 0xFA, 0x68, 0x1C, 0xF6,
  0x50, 0x3D, 0x02, 0x58, 0x13, 0xFE, 0x78, 0x34, 0xCF, 0xC3, 0x20,
  // "&" (U+0026)
  0x38, 0x51, 0x9D, 0xFD, 0x91, 0x72, 0x01, 0x0D, 0xD0, 0xD7, 0x20, 0x9A, 0x81, 0xA6, 0xAA, 0x07,
  0x71, 0x81, 0xDF, 0xD3, 0x81, 0xDF, 0xC7, 0x1A, 0x09, 0x38, 0x1A, 0xFD, 0x71, 0xA0, 0x93, 0x81,
  0xAF, 0xC7, 0x18, 0x1D, 0xFC, 0x38, 0x1D, 0xFA, 0x71, 0x08, 0xA8, 0x12, 0x04, 0xA0, 0x57, 0x10,
  0x2A, 0x83, 0xA2, 0xDF, 0xC7, 0x30, 0x9A, 0x82, 0xEF, 0xE2, 0x73, 0x01, 0xB0, 0xD0, 0x27, 0x30,
  0x20, 0xCB, 0x0D, 0x01, 0x72, 0x83, 0x1E, 0xFD, 0x6A, 0x0B, 0x30, 0x1A, 0x09, 0x28, 0x4C, 0xFE,
  0x20, 0x7A, 0x07, 0x20, 0x5A, 0x81, 0x60, 0x5A, 0x06, 0x30, 0xBA, 0x81, 0x40, 0x8A, 0x81, 0x10,
  0xAA, 0x01, 0x38, 0x61, 0xEF, 0xE2, 0xEF, 0xC2, 0x81, 0xCF, 0xE5, 0x04, 0xA0, 0xEA, 0x06, 0x20,
  0xCA, 0x60, 0x8B, 0x0D, 0x30, 0xBA, 0x02, 0x50, 0x1B, 0x07, 0x30, 0x7A, 0x0A, 0x40, 0x20, 0xDB,
  0x0E, 0x02, 0x20, 0x10, 0xEA, 0x82, 0xB7, 0x69, 0xB0, 0x9A, 0x0C, 0x30, 0x4F, 0x82, 0xE4, 0x09,
  0xA0, 0x93, 0x86, 0x29, 0xDF, 0xEC, 0x71, 0x30, 0xDA, 0x05,
  // "'" (U+0027)
  0xA0, 0xDA, 0x8A, 0x1C, 0xDF, 0xBC, 0xFA, 0xBF, 0x9A, 0xF8, 0x9F, 0x78, 0xF6,
  // "(" (U+0028)
  0x40, 0x4A, 0x02, 0x48, 0x1D, 0xF8, 0x48, 0x28, 0xFE, 0x13, 0x01, 0xA0, 0x84, 0x08, 0xA0, 0x14,
  0x81, 0xEF, 0xB4, 0x04, 0xA0, 0x64, 0x08, 0xA0, 0x14, 0x81, 0xCF, 0xD5, 0xA0, 0xA4, 0x03, 0xA0,
  0x74, 0x05, 0xA0, 0x54, 0x06, 0xA0, 0x34, 0x07, 0xA0, 0x34, 0x08, 0xA0, 0x24, 0x07, 0xA0, 0x24,
  0x07, 0xA0, 0x34, 0x05, 0xA0, 0x54, 0x03, 0xA0, 0x64, 0x01, 0xA0, 0x95, 0x81, 0xDF, 0xC5, 0x09,
  0xA0, 0x14, 0x05, 0xA0, 0x55, 0x81, 0xEF, 0xB5, 0x09, 0xA0, 0x14, 0x02, 0xA0, 0x75, 0x82, 0x9F,
  0xE1, 0x48, 0x21, 0xEF, 0x95, 0x04, 0xA0, 0x20,
  // ")" (U+0029)
  0x81, 0xBF, 0xA4, 0x02, 0xA0, 0x54, 0x81, 0x9F, 0xE4, 0x02, 0xA0, 0x74, 0x81, 0xBF, 0xE4, 0x05,
  0xA0, 0x44, 0x81, 0xEF, 0xA4, 0x81, 0xBF, 0xE4, 0x07, 0xA0, 0x33, 0x04, 0xA0, 0x63, 0x01, 0xA0,
  0x94, 0xA0, 0xB4, 0x81, 0xDF, 0xC4, 0x81, 0xCF, 0xD4, 0x81, 0xCF, 0xD4, 0x81, 0xCF, 0xD4, 0x81,
  0xDF, 0xC4, 0x81, 0xEF, 0xB3, 0x01, 0xA0, 0x93, 0x04, 0xA0, 0x63, 0x07, 0xA0, 0x33, 0x81, 0xBF,
  0xE4, 0x81, 0xEF, 0xB3, 0x05, 0xA0, 0x53, 0x81, 0xAF, 0xE3, 0x01, 0xA0, 0x73, 0x82, 0x9F, 0xE1,
  0x20, 0x2A, 0x05, 0x38, 0x1B, 0xFA, 0x40,
  // "*" (U+002A)
  0x40, 0x4A, 0x06, 0x71, 0x02, 0xA0, 0x57, 0x10, 0x1A, 0x03, 0x40, 0x20, 0x33, 0xA0, 0x12, 0x89,
  0x52, 0x37, 0xFD, 0x94, 0xDF, 0x48, 0xDF, 0xAA, 0xFB, 0x84, 0xC3, 0x57, 0x8C, 0xA8, 0x3D, 0x87,
  0x54, 0x38, 0x41, 0xEF, 0xEF, 0x36, 0x84, 0xBF, 0xA7, 0xFD, 0x50, 0x7A, 0x83, 0x31, 0xEF, 0xA3,
  0x02, 0xA0, 0xB2, 0x08, 0xA0, 0x43, 0x81, 0x4D, 0x32, 0x81, 0x1D, 0x52,
  // "+" (U+002B)
  0x58, 0x18, 0xFA, 0x73, 0x81, 0x8F, 0xA7, 0x38, 0x18, 0xFA, 0x73, 0x81, 0x8F, 0xA7, 0x38, 0x18,
  0xFA, 0x73, 0x81, 0x8F, 0xA7, 0x38, 0x18, 0xFA, 0x50, 0xDF, 0xC0, 0xE0, 0xDF, 0xC8, 0x7E, 0x45,
  0x55, 0x5B, 0xFC, 0x80, 0x15, 0x58, 0x18, 0xFA, 0x73, 0x81, 0x8F, 0xA7, 0x38, 0x18, 0xFA, 0x73,
  0x81, 0x8F, 0xA7, 0x38, 0x18, 0xFA, 0x73, 0x81, 0x8F, 0xA5,
  // "," (U+002C)
  0x10, 0x5A, 0x81, 0x90, 0x7A, 0x81, 0x60, 0xAA, 0x83, 0x20, 0xCF, 0xD2, 0xA8, 0x18, 0x03, 0xA8,
  0x32, 0x07, 0xFC, 0x28, 0x1A, 0xF6, 0x20,
  // "-" (U+002D)
  0x80, 0x35, 0x01, 0xF0, 0x3F, 0x03,
  // "." (U+002E)
  0x83, 0x6E, 0xD2, 0xEA, 0x08, 0x0E, 0xA8, 0x38, 0x6E, 0xD2,
  // "/" (U+002F)
  0x71, 0x03, 0xA0, 0x47, 0x18, 0x19, 0xFE, 0x72, 0x81, 0xEF, 0x87, 0x10, 0x5A, 0x03, 0x71, 0x81,
  0xAF, 0xD7, 0x10, 0x1A, 0x07, 0x71, 0x06, 0xA0, 0x17, 0x18, 0x1C, 0xFB, 0x71, 0x02, 0xA0, 0x57,
  0x18, 0x18, 0xFE, 0x72, 0x81, 0xDF, 0xA7, 0x10, 0x4A, 0x04, 0x71, 0x81, 0x9F, 0xD7, 0x28, 0x1E,
  0xF8, 0x71, 0x05, 0xA0, 0x27, 0x18, 0x1B, 0xFC, 0x71, 0x01, 0xA0, 0x77, 0x10, 0x7A, 0x01, 0x71,
  0x81, 0xCF, 0xB7, 0x10, 0x3A, 0x05, 0x71, 0x81, 0x8F, 0xE7, 0x28, 0x1E, 0xF9, 0x71, 0x04, 0xA0,
  0x47, 0x10,
  // "0" (U+0030)
  0x38, 0x51, 0x9D, 0xFD, 0x91, 0x50, 0x20, 0xED, 0x0E, 0x02, 0x40, 0xDA, 0x81, 0x96, 0x9A, 0x0C,
  0x30, 0x5A, 0x07, 0x30, 0x7A, 0x06, 0x28, 0x1B, 0xFE, 0x58, 0x1E, 0xFC, 0x2A, 0x0A, 0x50, 0x9A,
  0x01, 0x03, 0xA0, 0x75, 0x06, 0xA0, 0x40, 0x5A, 0x05, 0x50, 0x4A, 0x06, 0x07, 0xA0, 0x35, 0x02,
  0xA0, 0x08, 0xA0, 0x25, 0x01, 0xA0, 0x09, 0xA0, 0x25, 0x01, 0xA0, 0xA0, 0x9A, 0x02, 0x50, 0x1A,
  0x0A, 0x09, 0xA0, 0x25, 0x01, 0xA0, 0xA0, 0x8A, 0x02, 0x50, 0x1A, 0x09, 0x07, 0xA0, 0x35, 0x02,
  0xA0, 0x80, 0x6A, 0x05, 0x50, 0x4A, 0x06, 0x04, 0xA0, 0x75, 0x06, 0xA0, 0x40, 0x1A, 0x0A, 0x50,
  0x9A, 0x83, 0x10, 0xDF, 0xE5, 0x81, 0xEF, 0xC2, 0x07, 0xA0, 0x73, 0x07, 0xA0, 0x62, 0x01, 0x0E,
  0xA8, 0x19, 0x69, 0xA0, 0xD4, 0x04, 0x0E, 0xD0, 0xE0, 0x35, 0x85, 0x29, 0xEF, 0xD9, 0x23,
  // "1" (U+0031)
  0x40, 0x10, 0xCA, 0x30, 0x10, 0xCB, 0x20, 0x10, 0xDC, 0x10, 0x10, 0xDA, 0x0C, 0xA0, 0x20, 0xDA,
  0x05, 0x09, 0xA8, 0x47, 0xFE, 0x40, 0xAA, 0x10, 0x80, 0x32, 0x0A, 0xA5, 0x0A, 0xA5, 0x0A, 0xA5,
  0x0A, 0xA5, 0x0A, 0xA5, 0x0A, 0xA5, 0x0A, 0xA5, 0x0A, 0xA5, 0x0A, 0xA5, 0x0A, 0xA5, 0x0A, 0xA5,
  0x0A, 0xA5, 0x0A, 0xA5, 0x0A, 0xA5, 0x0A, 0xA5, 0x0A, 0xA5, 0x0A, 0xA0,
  // "2" (U+0032)
  0x28, 0x62, 0x9D, 0xEE, 0xD8, 0x14, 0x09, 0xF0, 0xE0, 0x42, 0x05, 0xA8, 0x3E, 0x86, 0x7B, 0xA0,
  0xE0, 0x12, 0x0A, 0x09, 0x50, 0x9A, 0x08, 0x72, 0x01, 0xA0, 0xC7, 0x38, 0x1D, 0xFE, 0x73, 0x81,
  0xDF, 0xD7, 0x38, 0x1E, 0xFC, 0x72, 0x02, 0xA0, 0x97, 0x20, 0x8A, 0x04, 0x71, 0x82, 0x1E, 0xFD,
  0x72, 0x09, 0xA0, 0x57, 0x10, 0x4A, 0x0B, 0x71, 0x83, 0x1E, 0xFE, 0x17, 0x10, 0xBA, 0x04, 0x71,
  0x08, 0xA0, 0x87, 0x10, 0x4A, 0x0B, 0x71, 0x83, 0x1E, 0xFD, 0x17, 0x18, 0x2C, 0xFE, 0x27, 0x10,
  0x9A, 0x05, 0x71, 0x05, 0xA0, 0xC8, 0x04, 0x50, 0x20, 0xCF, 0xC0, 0x80, 0xCF, 0xC0, 0x80,
  // "3" (U+0033)
  0x28, 0x63, 0x9D, 0xEF, 0xDA, 0x33, 0x01, 0x0A, 0xF9, 0x07, 0x20, 0x7A, 0x83, 0xD8, 0x67, 0xAB,
  0x03, 0x20, 0xB0, 0x55, 0x06, 0xA0, 0xA7, 0x38, 0x1E, 0xFE, 0x73, 0x81, 0xBF, 0xE7, 0x38, 0x1D,
  0xFD, 0x72, 0x03, 0xA0, 0x87, 0x18, 0x32, 0xDF, 0xE1, 0x48, 0x25, 0x56, 0x9A, 0x0D, 0x02, 0x5D,
  0x07, 0x7E, 0x0B, 0x02, 0x78, 0x11, 0x38, 0xA0, 0xE0, 0x37, 0x20, 0x3A, 0x0D, 0x73, 0x09, 0xA0,
  0x37, 0x20, 0x6A, 0x06, 0x72, 0x05, 0xA0, 0x67, 0x20, 0x7A, 0x05, 0x72, 0x0C, 0xA8, 0x12, 0x52,
  0x60, 0x8A, 0x89, 0x0C, 0x0B, 0xFC, 0x86, 0x57, 0xCB, 0x81, 0x30, 0xBF, 0x90, 0xE0, 0x42, 0x82,
  0x17, 0xBD, 0xA8, 0x2E, 0xC7, 0x13,
  // "4" (U+0034)
  0x71, 0x02, 0xA0, 0xE7, 0x40, 0xBA, 0x0E, 0x73, 0x04, 0xB0, 0xE7, 0x38, 0x3C, 0xFD, 0xFE, 0x72,
  0x84, 0x5F, 0xCA, 0xFE, 0x72, 0x84, 0xDF, 0x5A, 0xFE, 0x71, 0x85, 0x6F, 0xD0, 0xBF, 0xE7, 0x18,
  0x5E, 0xF5, 0x0B, 0xFE, 0x78, 0x18, 0xFC, 0x28, 0x1B, 0xFE, 0x68, 0x21, 0xEF, 0x42, 0x81, 0xBF,
  0xE6, 0x81, 0x9F, 0xB3, 0x81, 0xBF, 0xE5, 0x02, 0xA0, 0x33, 0x81, 0xBF, 0xE5, 0x81, 0xAF, 0xB4,
  0x81, 0xBF, 0xE4, 0x03, 0xA0, 0x24, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xA5, 0x81, 0xBF, 0xE3, 0x04,
  0xA0, 0x88, 0x01, 0x68, 0x5C, 0xFE, 0x66, 0x36, 0xFE, 0x09, 0x06, 0xFE, 0x09, 0x72, 0x81, 0xBF,
  0xE7, 0x58, 0x1B, 0xFE, 0x75, 0x81, 0xBF, 0xE7, 0x58, 0x1B, 0xFE, 0x75, 0x81, 0xBF, 0xE3,
  // "5" (U+0035)
  0x10, 0x5F, 0xA0, 0x32, 0x06, 0xFA, 0x03, 0x20, 0x7A, 0x80, 0x35, 0x01, 0x28, 0x18, 0xFE, 0x73,
  0x81, 0x9F, 0xD7, 0x38, 0x1A, 0xFC, 0x73, 0x81, 0xBF, 0xA7, 0x38, 0x1D, 0xF9, 0x73, 0x87, 0xEF,
  0xDD, 0xEF, 0xDA, 0x34, 0xFA, 0x06, 0x38, 0x56, 0xEA, 0x75, 0x7B, 0xB0, 0x47, 0x20, 0x6A, 0x0D,
  0x73, 0x0B, 0xA0, 0x37, 0x20, 0x5A, 0x06, 0x72, 0x03, 0xA0, 0x87, 0x20, 0x3A, 0x08, 0x72, 0x04,
  0xA0, 0x77, 0x20, 0x8A, 0x04, 0x71, 0x85, 0x1E, 0xFE, 0x03, 0x46, 0x0A, 0xA8, 0x90, 0x80, 0x4F,
  0xD9, 0x65, 0x8D, 0xA0, 0xD2, 0x04, 0xF9, 0x0C, 0x01, 0x38, 0x65, 0xAD, 0xEF, 0xEB, 0x64,
  // "6" (U+0036)
  0x58, 0x55, 0xAD, 0xFE, 0xC4, 0x40, 0x10, 0xBE, 0x06, 0x40, 0xCA, 0x84, 0xD8, 0x66, 0x84, 0x30,
  0x8A, 0x09, 0x71, 0x01, 0xA0, 0xB7, 0x20, 0x7A, 0x03, 0x72, 0x81, 0xBF, 0xC7, 0x38, 0x1E, 0xF8,
  0x72, 0x02, 0xA8, 0x55, 0x08, 0xDE, 0xD7, 0x30, 0x4A, 0x04, 0x0C, 0xD0, 0xC2, 0x05, 0xA8, 0x4B,
  0xFA, 0x67, 0xDA, 0x81, 0x90, 0x6B, 0x05, 0x40, 0xDA, 0x01, 0x07, 0xA0, 0xB5, 0x06, 0xA0, 0x50,
  0x7A, 0x06, 0x50, 0x1A, 0x09, 0x06, 0xA0, 0x46, 0xA0, 0xA0, 0x5A, 0x05, 0x6A, 0x0B, 0x03, 0xA0,
  0x76, 0xA0, 0x91, 0xA0, 0xB5, 0x02, 0xA8, 0x18, 0x0B, 0xA0, 0x14, 0x06, 0xA8, 0x13, 0x05, 0xA0,
  0xA3, 0x82, 0x1D, 0xFD, 0x30, 0xBA, 0x82, 0xB6, 0x7D, 0xA0, 0x53, 0x01, 0x0C, 0xE0, 0x86, 0x84,
  0x7C, 0xEE, 0xB4, 0x30,
  // "7" (U+0037)
  0x0D, 0xFC, 0x0C, 0x0D, 0xFC, 0x0C, 0x04, 0x80, 0x45, 0x06, 0xA0, 0x97, 0x20, 0x5A, 0x04, 0x72,
  0x81, 0xBF, 0xD7, 0x20, 0x1A, 0x08, 0x72, 0x07, 0xA0, 0x27, 0x28, 0x1D, 0xFC, 0x72, 0x03, 0xA0,
  0x77, 0x20, 0x9A, 0x01, 0x72, 0x81, 0xEF, 0xB7, 0x20, 0x5A, 0x06, 0x72, 0x0B, 0xA0, 0x17, 0x10,
  0x1A, 0x0A, 0x72, 0x07, 0xA0, 0x47, 0x28, 0x1C, 0xFE, 0x72, 0x03, 0xA0, 0x97, 0x20, 0x8A, 0x03,
  0x72, 0x81, 0xEF, 0xD7, 0x20, 0x4A, 0x08, 0x72, 0x0A, 0xA0, 0x27, 0x10, 0x1A, 0x0C, 0x72, 0x06,
  0xA0, 0x67,
  // "8" (U+0038)
  0x38, 0x54, 0xAE, 0xFE, 0xB5, 0x50, 0x9F, 0x0B, 0x30, 0x6A, 0x83, 0xE8, 0x68, 0xEA, 0x08, 0x20,
  0xDA, 0x02, 0x30, 0x10, 0xEA, 0x10, 0x1A, 0x0A, 0x50, 0x8A, 0x03, 0x02, 0xA0, 0x85, 0x06, 0xA0,
  0x41, 0xA0, 0x95, 0x07, 0xA8, 0x33, 0x0B, 0xFE, 0x58, 0x1D, 0xFE, 0x20, 0x4A, 0x0A, 0x30, 0x8A,
  0x06, 0x30, 0x8A, 0x81, 0xC3, 0xBA, 0x08, 0x50, 0x8C, 0x0E, 0x06, 0x60, 0x40, 0xEB, 0x0D, 0x03,
  0x50, 0x8A, 0x81, 0xB7, 0xEA, 0x06, 0x30, 0x8A, 0x08, 0x20, 0x20, 0xCA, 0x81, 0x70, 0x2A, 0x0A,
  0x50, 0xBA, 0x04, 0x08, 0xA0, 0x25, 0x02, 0xA0, 0xA0, 0xBA, 0x78, 0x2D, 0xFD, 0xBA, 0x78, 0x2D,
  0xFD, 0xAA, 0x03, 0x50, 0x1A, 0x0B, 0x05, 0xA0, 0xB5, 0x0A, 0xA8, 0x16, 0x0C, 0xA8, 0x3D, 0x75,
  0x7C, 0xA0, 0xD2, 0x01, 0x0C, 0xF0, 0xD0, 0x24, 0x85, 0x6B, 0xEF, 0xEC, 0x63,
  // "9" (U+0039)
  0x38, 0x44, 0xAD, 0xFD, 0x86, 0x08, 0xE0, 0xD0, 0x13, 0x06, 0xA8, 0x2D, 0x76, 0xAA, 0x0C, 0x38,
  0x2E, 0xFD, 0x13, 0x07, 0xA8, 0x15, 0x04, 0xA0, 0x65, 0x83, 0xDF, 0xC0, 0x8A, 0x02, 0x50, 0x8A,
  0x01, 0x09, 0xA6, 0x05, 0xA0, 0x40, 0xAA, 0x60, 0x3A, 0x06, 0x09, 0xA0, 0x25, 0x04, 0xA0, 0x70,
  0x6A, 0x05, 0x50, 0x9A, 0x08, 0x02, 0xA0, 0xC4, 0x03, 0xB8, 0x17, 0x0A, 0xA8, 0x4D, 0x76, 0x9F,
  0xCA, 0x82, 0x60, 0x1D, 0xD0, 0xD0, 0x4A, 0x05, 0x28, 0x61, 0x8D, 0xFD, 0x81, 0x4A, 0x04, 0x72,
  0x07, 0xA0, 0x17, 0x28, 0x1A, 0xFE, 0x73, 0x81, 0xEF, 0xB7, 0x20, 0x5A, 0x06, 0x72, 0x82, 0xDF,
  0xE1, 0x70, 0x10, 0xBA, 0x07, 0x38, 0x45, 0x86, 0x68, 0xEA, 0x0C, 0x40, 0x7E, 0x0B, 0x01, 0x40,
  0x50, 0xDA, 0x81, 0xDA, 0x45,
  // ":" (U+003A)
  0x83, 0x6E, 0xD2, 0xDA, 0x08, 0x0D, 0xA8, 0x38, 0x6E, 0xD2, 0x80, 0xC4, 0x08, 0x36, 0xED, 0x2D,
  0xA0, 0x80, 0xDA, 0x83, 0x86, 0xED, 0x20,
  // ";" (U+003B)
  0x18, 0x46, 0xEC, 0x20, 0xEA, 0x81, 0x80, 0xEA, 0x84, 0x80, 0x6E, 0xC2, 0x80, 0xD7, 0x00, 0x7A,
  0x81, 0x80, 0x9A, 0x81, 0x50, 0xBA, 0x85, 0x10, 0xEF, 0xC0, 0x2A, 0x81, 0x70, 0x5A, 0x83, 0x10,
  0x8F, 0xB2, 0x81, 0xCF, 0x52,
  // "<" (U+003C)
  0x74, 0x01, 0x07, 0x73, 0x81, 0x7E, 0xE7, 0x10, 0x70, 0xEA, 0x0D, 0x60, 0x60, 0xDA, 0x0E, 0x07,
  0x50, 0x50, 0xDA, 0x0E, 0x07, 0x50, 0x50, 0xDA, 0x0E, 0x07, 0x50, 0x40, 0xCA, 0x0E, 0x07, 0x70,
  0xDA, 0x09, 0x72, 0x09, 0xB0, 0xA0, 0x27, 0x10, 0x20, 0xAB, 0x0A, 0x03, 0x71, 0x02, 0x0A, 0xB0,
  0xB0, 0x37, 0x10, 0x20, 0xAB, 0x0B, 0x04, 0x71, 0x03, 0x0A, 0xB0, 0xB7, 0x28, 0x23, 0xAF, 0xE7,
  0x40, 0x30, 0xA0,
  // "=" (U+003D)
  0x04, 0x80, 0x75, 0x04, 0x0C, 0xFC, 0x0D, 0x0C, 0xFC, 0x0D, 0x80, 0xE0, 0x00, 0x48, 0x07, 0x50,
  0x40, 0xCF, 0xC0, 0xD0, 0xCF, 0xC0, 0xD0,
  // ">" (U+003E)
  0x07, 0x01, 0x74, 0x82, 0xDF, 0x81, 0x72, 0x0B, 0xA0, 0xE0, 0x87, 0x20, 0x60, 0xDA, 0x0E, 0x07,
  0x72, 0x06, 0x0D, 0xA0, 0xE0, 0x67, 0x20, 0x60, 0xDA, 0x0D, 0x06, 0x72, 0x06, 0x0D, 0xA0, 0xD0,
  0x57, 0x20, 0x8B, 0x70, 0x20, 0x9B, 0x0B, 0x50, 0x20, 0x9B, 0x0B, 0x03, 0x40, 0x20, 0xAB, 0x0B,
  0x03, 0x40, 0x30, 0xAB, 0x0B, 0x03, 0x50, 0xAB, 0x0B, 0x03, 0x78, 0x2D, 0xFB, 0x37, 0x20, 0x90,
  0x47, 0x40,
  // "?" (U+003F)
  0x18, 0x62, 0x8C, 0xEF, 0xD9, 0x22, 0x05, 0xF8, 0x90, 0xE4, 0x02, 0xFE, 0x96, 0x6B, 0xA0, 0xE2,
  0x05, 0x01, 0x40, 0x9A, 0x05, 0x70, 0x3A, 0x07, 0x70, 0x1A, 0x08, 0x70, 0x2A, 0x07, 0x70, 0x7A,
  0x03, 0x68, 0x21, 0xEF, 0xC7, 0x0B, 0xA0, 0x36, 0x09, 0xA0, 0x76, 0x05, 0xA0, 0x97, 0x81, 0xDF,
  0xC7, 0x03, 0xA0, 0x37, 0x81, 0x5F, 0xC7, 0x18, 0x16, 0xFA, 0x71, 0x81, 0x37, 0x47, 0x77, 0x72,
  0x82, 0x8E, 0xC1, 0x7B, 0x06, 0x7B, 0x06, 0x78, 0x28, 0xEC, 0x14,
  // "@" (U+0040)
  0x78, 0x64, 0x9C, 0xEF, 0xEB, 0x67, 0x40, 0x20, 0xCF, 0x90, 0xD0, 0x47, 0x10, 0x40, 0xEA, 0x84,
  0xD9, 0x75, 0x7B, 0xB0, 0x66, 0x04, 0xA0, 0xE0, 0x56, 0x02, 0x0C, 0xA0, 0x44, 0x83, 0x1E, 0xFD,
  0x17, 0x18, 0x21, 0xCF, 0xD4, 0x82, 0x8F, 0xE2, 0x28, 0x92, 0x29, 0xEF, 0xDA, 0x50, 0x1E, 0xF6,
  0x20, 0x1A, 0x07, 0x20, 0x20, 0xED, 0x0E, 0x28, 0x17, 0xFC, 0x28, 0x16, 0xFE, 0x38, 0x6D, 0xFE,
  0x75, 0xAF, 0xD2, 0x02, 0xA8, 0x31, 0x0B, 0xF9, 0x20, 0x5A, 0x03, 0x28, 0x16, 0xFD, 0x38, 0x5C,
  0xF5, 0x0E, 0xF4, 0x28, 0x1A, 0xFB, 0x38, 0x17, 0xFC, 0x38, 0x2A, 0xF7, 0x2A, 0x01, 0x28, 0x1D,
  0xF7, 0x38, 0x18, 0xFC, 0x38, 0x49, 0xF9, 0x4F, 0xE3, 0xA0, 0x43, 0x81, 0x9F, 0xB3, 0x84, 0x8F,
  0x95, 0xFD, 0x3A, 0x03, 0x38, 0x1A, 0xFA, 0x38, 0x48, 0xF8, 0x5F, 0xC3, 0xA0, 0x33, 0x81, 0xBF,
  0xA3, 0x84, 0x9F, 0x75, 0xFD, 0x3A, 0x05, 0x38, 0x1E, 0xFA, 0x38, 0x2C, 0xF5, 0x4A, 0x38, 0x1C,
  0xF8, 0x20, 0x2A, 0x0B, 0x20, 0x1A, 0x01, 0x02, 0xA0, 0x22, 0x89, 0x48, 0xFE, 0x31, 0xBE, 0xAF,
  0x41, 0xBF, 0xB2, 0x81, 0xEF, 0x62, 0x02, 0xD0, 0x80, 0x5D, 0x03, 0x28, 0x1B, 0xFB, 0x30, 0x50,
  0xEA, 0x0B, 0x20, 0xBB, 0x06, 0x30, 0x6A, 0x03, 0x38, 0x11, 0x43, 0x48, 0x13, 0x41, 0x58, 0x1E,
  0xFC, 0x77, 0x40, 0x6A, 0x0C, 0x01, 0x77, 0x30, 0x9A, 0x81, 0xE7, 0x32, 0x83, 0x13, 0x6A, 0x77,
  0x20, 0x9F, 0xB0, 0x77, 0x38, 0x13, 0xAE, 0xD0, 0xD0, 0x77, 0x78, 0x33, 0x45, 0x41, 0x71,
  // "A" (U+0041)
  0x60, 0x9A, 0x0B, 0x75, 0x0D, 0xB7, 0x40, 0x2A, 0x81, 0xEF, 0x47, 0x38, 0x46, 0xFD, 0xBF, 0x97,
  0x38, 0x4B, 0xF9, 0x8F, 0xD7, 0x3A, 0x06, 0x04, 0xA0, 0x27, 0x10, 0x4A, 0x02, 0x1A, 0x07, 0x71,
  0x81, 0x9F, 0xE2, 0x81, 0xCF, 0xB7, 0x18, 0x1D, 0xF9, 0x20, 0x7A, 0x70, 0x2A, 0x05, 0x20, 0x3A,
  0x04, 0x60, 0x6A, 0x01, 0x38, 0x1E, 0xF9, 0x68, 0x1B, 0xFD, 0x48, 0x1A, 0xFD, 0x6A, 0x08, 0x40,
  0x6A, 0x02, 0x40, 0x4F, 0xB0, 0x74, 0x08, 0xFB, 0x0B, 0x48, 0x1D, 0xFE, 0x80, 0x29, 0x0D, 0xA3,
  0x02, 0xA0, 0x96, 0x06, 0xA0, 0x52, 0x06, 0xA0, 0x56, 0x02, 0xA0, 0x92, 0x0B, 0xA0, 0x17, 0x81,
  0xDF, 0xD2, 0xA0, 0xC7, 0x10, 0x9A, 0x02, 0x04, 0xA0, 0x87, 0x10, 0x5A, 0x07, 0x08, 0xA0, 0x47,
  0x10, 0x1A, 0x0B, 0x0D, 0xA7, 0x30, 0xCA,
  // "B" (U+0042)
  0x06, 0xE8, 0x2E, 0xB7, 0x13, 0x06, 0xFA, 0x0E, 0x05, 0x20, 0x6A, 0x84, 0x85, 0x55, 0x7C, 0xB8,
  0x13, 0x06, 0xA0, 0x45, 0x09, 0xA8, 0x1A, 0x06, 0xA0, 0x45, 0x01, 0xA8, 0x1D, 0x06, 0xA0, 0x46,
  0x83, 0xDF, 0xE0, 0x6A, 0x04, 0x68, 0x3E, 0xFD, 0x06, 0xA0, 0x45, 0x02, 0xA8, 0x1A, 0x06, 0xA0,
  0x45, 0x0A, 0xA8, 0x14, 0x06, 0xA8, 0x48, 0x55, 0x57, 0xCA, 0x07, 0x20, 0x6F, 0x90, 0xC0, 0x33,
  0x06, 0xFA, 0x0C, 0x03, 0x20, 0x6A, 0x04, 0x38, 0x11, 0x5E, 0xA8, 0x15, 0x06, 0xA0, 0x45, 0x84,
  0x2E, 0xFE, 0x06, 0xA0, 0x46, 0x09, 0xA0, 0x40, 0x6A, 0x04, 0x60, 0x5A, 0x07, 0x06, 0xA0, 0x46,
  0x05, 0xA0, 0x70, 0x6A, 0x04, 0x60, 0x7A, 0x00, 0x6A, 0x04, 0x60, 0xCA, 0x03, 0x06, 0xA0, 0x45,
  0x05, 0xA8, 0x1D, 0x06, 0xA8, 0x48, 0x55, 0x56, 0xAB, 0x81, 0x50, 0x6F, 0xB0, 0x72, 0x06, 0xF8,
  0x1D, 0x93, 0x30,
  // "C" (U+0043)
  0x58, 0x71, 0x8C, 0xEF, 0xEC, 0x82, 0x50, 0x60, 0xEF, 0x90, 0x13, 0x07, 0xB8, 0x5B, 0x75, 0x7B,
  0xF9, 0x30, 0x4B, 0x05, 0x50, 0x02, 0x30, 0xCA, 0x06, 0x73, 0x04, 0xA0, 0xC7, 0x40, 0x8A, 0x06,
  0x74, 0x0C, 0xA0, 0x17, 0x4A, 0x0D, 0x74, 0x02, 0xA0, 0xB7, 0x40, 0x3A, 0x09, 0x74, 0x04, 0xA0,
  0x97, 0x40, 0x3A, 0x09, 0x74, 0x02, 0xA0, 0xA7, 0x40, 0x1A, 0x0C, 0x75, 0x0D, 0xA7, 0x50, 0x9A,
  0x05, 0x74, 0x05, 0xA0, 0xB7, 0x50, 0xDA, 0x05, 0x74, 0x05, 0xB0, 0x56, 0x01, 0x40, 0x8B, 0x85,
  0xC7, 0x67, 0x9D, 0x85, 0x07, 0xF9, 0x08, 0x68, 0x72, 0x8C, 0xEF, 0xEC, 0x72, 0x10,
  // "D" (U+0044)
  0x06, 0xD8, 0x2E, 0xDA, 0x55, 0x06, 0xFA, 0x0C, 0x03, 0x30, 0x6A, 0x84, 0x85, 0x56, 0x9E, 0xA0,
  0xE0, 0x32, 0x06, 0xA0, 0x45, 0x09, 0xA0, 0xD2, 0x06, 0xA0, 0x46, 0x0A, 0xA8, 0x18, 0x06, 0xA0,
  0x46, 0x84, 0x1E, 0xFE, 0x06, 0xA0, 0x47, 0x0A, 0xA0, 0x40, 0x6A, 0x04, 0x70, 0x5A, 0x08, 0x06,
  0xA0, 0x47, 0x03, 0xA0, 0xA0, 0x6A, 0x04, 0x70, 0x1A, 0x0C, 0x06, 0xA0, 0x47, 0x1A, 0x0D, 0x06,
  0xA0, 0x47, 0x1A, 0x0D, 0x06, 0xA0, 0x47, 0x1A, 0x0C, 0x06, 0xA0, 0x47, 0x01, 0xA0, 0xB0, 0x6A,
  0x04, 0x70, 0x3A, 0x0A, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x70, 0x6A, 0x04, 0x70, 0xBA, 0x03, 0x06,
  0xA0, 0x46, 0x02, 0xA8, 0x1D, 0x06, 0xA0, 0x46, 0x0B, 0xA8, 0x17, 0x06, 0xA0, 0x44, 0x01, 0x0B,
  0xA0, 0xC2, 0x06, 0xA8, 0x48, 0x55, 0x7A, 0xEA, 0x0D, 0x02, 0x20, 0x6F, 0xA0, 0xB0, 0x23, 0x06,
  0xD8, 0x2E, 0xD9, 0x45,
  // "E" (U+0045)
  0x06, 0xFA, 0x0B, 0x06, 0xFA, 0x0B, 0x06, 0xA0, 0x88, 0x02, 0x50, 0x40, 0x6A, 0x04, 0x70, 0x6A,
  0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x08,
  0x80, 0x25, 0x01, 0x06, 0xFA, 0x04, 0x06, 0xFA, 0x04, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06,
  0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0,
  0x47, 0x06, 0xA0, 0x88, 0x02, 0x50, 0x40, 0x6F, 0xA0, 0xB0, 0x6F, 0xA0, 0xB0,
  // "F" (U+0046)
  0x06, 0xFA, 0x0B, 0x06, 0xFA, 0x0B, 0x06, 0xA0, 0x88, 0x02, 0x50, 0x40, 0x6A, 0x04, 0x70, 0x6A,
  0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04,
  0x70, 0x6A, 0x08, 0x80, 0x25, 0x01, 0x06, 0xFA, 0x04, 0x06, 0xFA, 0x04, 0x06, 0xA0, 0x47, 0x06,
  0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0,
  0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47,
  // "G" (U+0047)
  0x68, 0x74, 0x9D, 0xEF, 0xEC, 0x84, 0x60, 0x20, 0xCF, 0xA0, 0xB4, 0x03, 0x0E, 0xA8, 0x7E, 0x96,
  0x57, 0xAE, 0xF7, 0x30, 0x10, 0xEA, 0x09, 0x70, 0x70, 0x13, 0x0B, 0xA0, 0x87, 0x50, 0x3A, 0x0D,
  0x76, 0x08, 0xA0, 0x67, 0x60, 0xDA, 0x01, 0x76, 0xA0, 0xD7, 0x60, 0x2A, 0x0A, 0x76, 0x04, 0xA0,
  0x95, 0x01, 0x80, 0x25, 0x01, 0x04, 0xA0, 0x95, 0x02, 0xE0, 0x40, 0x3A, 0x09, 0x50, 0x2E, 0x04,
  0x02, 0xA0, 0xB7, 0x20, 0x6A, 0x04, 0x1A, 0x0D, 0x72, 0x06, 0xA8, 0x14, 0x0C, 0xA0, 0x17, 0x10,
  0x6A, 0x81, 0x40, 0x8A, 0x05, 0x71, 0x06, 0xA8, 0x14, 0x04, 0xA0, 0xC7, 0x10, 0x6A, 0x04, 0x20,
  0xCA, 0x07, 0x70, 0x6A, 0x04, 0x20, 0x3B, 0x06, 0x60, 0x6A, 0x04, 0x30, 0x6B, 0x85, 0xD8, 0x66,
  0x79, 0xDA, 0x04, 0x40, 0x50, 0xEF, 0xB0, 0x45, 0x82, 0x17, 0xBE, 0xA8, 0x3E, 0xCA, 0x62, 0x10,
  // "H" (U+0048)
  0x06, 0xA0, 0x47, 0x03, 0xA0, 0x80, 0x6A, 0x04, 0x70, 0x3A, 0x08, 0x06, 0xA0, 0x47, 0x03, 0xA0,
  0x80, 0x6A, 0x04, 0x70, 0x3A, 0x08, 0x06, 0xA0, 0x47, 0x03, 0xA0, 0x80, 0x6A, 0x04, 0x70, 0x3A,
  0x08, 0x06, 0xA0, 0x47, 0x03, 0xA0, 0x80, 0x6A, 0x04, 0x70, 0x3A, 0x08, 0x06, 0xA0, 0x47, 0x03,
  0xA0, 0x80, 0x6A, 0x08, 0x80, 0x35, 0x07, 0xA0, 0x80, 0x6F, 0xE0, 0x80, 0x6F, 0xE0, 0x80, 0x6A,
  0x04, 0x70, 0x3A, 0x08, 0x06, 0xA0, 0x47, 0x03, 0xA0, 0x80, 0x6A, 0x04, 0x70, 0x3A, 0x08, 0x06,
  0xA0, 0x47, 0x03, 0xA0, 0x80, 0x6A, 0x04, 0x70, 0x3A, 0x08, 0x06, 0xA0, 0x47, 0x03, 0xA0, 0x80,
  0x6A, 0x04, 0x70, 0x3A, 0x08, 0x06, 0xA0, 0x47, 0x03, 0xA0, 0x80, 0x6A, 0x04, 0x70, 0x3A, 0x08,
  0x06, 0xA0, 0x47, 0x03, 0xA0, 0x80, 0x6A, 0x04, 0x70, 0x3A, 0x08,
  // "I" (U+0049)
  0x0D, 0xE0, 0x60, 0xCE, 0x82, 0x50, 0x2B, 0xA0, 0x54, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09,
  0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0,
  0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24,
  0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x22, 0x08,
  0x0D, 0xC8, 0x1C, 0x3D, 0xE0, 0x60,
  // "J" (U+004A)
  0x40, 0x8A, 0x02, 0x40, 0x8A, 0x02, 0x40, 0x8A, 0x02, 0x40, 0x8A, 0x02, 0x40, 0x8A, 0x02, 0x40,
  0x8A, 0x02, 0x40, 0x8A, 0x02, 0x40, 0x8A, 0x02, 0x40, 0x8A, 0x02, 0x40, 0x8A, 0x02, 0x40, 0x8A,
  0x02, 0x40, 0x8A, 0x02, 0x40, 0x8A, 0x02, 0x40, 0x8A, 0x02, 0x40, 0x8A, 0x02, 0x40, 0x8A, 0x02,
  0x40, 0x8A, 0x02, 0x40, 0x8A, 0x02, 0x40, 0x8A, 0x02, 0x40, 0x8A, 0x02, 0x40, 0x8A, 0x02, 0x40,
  0x8A, 0x02, 0x40, 0x8A, 0x02, 0x40, 0x8A, 0x02, 0x40, 0x8A, 0x02, 0x40, 0xAA, 0x48, 0x71, 0xEF,
  0xD0, 0x76, 0x6D, 0xA8, 0x17, 0x0D, 0xC0, 0xC2, 0x83, 0xAE, 0xFD, 0x83,
  // "K" (U+004B)
  0x06, 0xA0, 0x46, 0x09, 0xA0, 0x06, 0xA0, 0x45, 0x03, 0xA8, 0x1B, 0x06, 0xA0, 0x45, 0x0D, 0xA8,
  0x12, 0x06, 0xA0, 0x44, 0x07, 0xA0, 0x72, 0x06, 0xA0, 0x43, 0x02, 0xA0, 0xC3, 0x06, 0xA0, 0x43,
  0x0B, 0xA0, 0x23, 0x06, 0xA0, 0x42, 0x06, 0xA0, 0x74, 0x06, 0xA8, 0x44, 0x01, 0xEF, 0xC5, 0x06,
  0xA8, 0x14, 0x0A, 0xA0, 0x35, 0x06, 0xA0, 0x04, 0xA0, 0x86, 0x06, 0xA0, 0x50, 0xDA, 0x03, 0x60,
  0x6A, 0x0D, 0xB0, 0xB6, 0x06, 0xB0, 0xE0, 0xCA, 0x04, 0x50, 0x6A, 0x81, 0xE2, 0x3A, 0x0C, 0x50,
  0x6A, 0x05, 0x20, 0xAA, 0x05, 0x40, 0x6A, 0x04, 0x20, 0x2A, 0x0D, 0x40, 0x6A, 0x04, 0x30, 0x9A,
  0x07, 0x30, 0x6A, 0x04, 0x38, 0x31, 0xEF, 0xE1, 0x20, 0x6A, 0x04, 0x40, 0x8A, 0x08, 0x20, 0x6A,
  0x04, 0x50, 0xEA, 0x81, 0x20, 0x6A, 0x04, 0x50, 0x6A, 0x81, 0xA0, 0x6A, 0x04, 0x60, 0xDA, 0x03,
  0x06, 0xA0, 0x46, 0x05, 0xA0, 0xB0,
  // "L" (U+004C)
  0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06,
  0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0,
  0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47,
  0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0xA8, 0x02,
  0x80, 0x06, 0xFA, 0x0B, 0x06, 0xFA, 0x0B,
  // "M" (U+004D)
  0x06, 0xB0, 0xA7, 0x40, 0xDB, 0x04, 0x06, 0xB0, 0xE7, 0x30, 0x2C, 0x04, 0x06, 0xC0, 0x47, 0x20,
  0x7C, 0x04, 0x06, 0xA8, 0x1E, 0xF9, 0x72, 0x81, 0xCF, 0xEA, 0x04, 0x06, 0xA8, 0x1A, 0xFD, 0x71,
  0x01, 0xA0, 0x9A, 0x04, 0x06, 0xA0, 0x6A, 0x03, 0x70, 0x6A, 0x06, 0xA0, 0x40, 0x6A, 0x02, 0xA0,
  0x87, 0x82, 0xBF, 0xB5, 0xA0, 0x40, 0x6A, 0x82, 0x2B, 0xFC, 0x7A, 0x00, 0x6A, 0x04, 0x06, 0xA0,
  0x20, 0x6A, 0x02, 0x50, 0x5A, 0x01, 0x06, 0xA0, 0x40, 0x6A, 0x02, 0x01, 0xA0, 0x65, 0x83, 0xAF,
  0xB0, 0x6A, 0x04, 0x06, 0xA8, 0x32, 0x0B, 0xFB, 0x58, 0x3E, 0xF7, 0x06, 0xA0, 0x40, 0x6A, 0x81,
  0x20, 0x7A, 0x01, 0x30, 0x4A, 0x81, 0x20, 0x6A, 0x04, 0x06, 0xA8, 0x12, 0x02, 0xA0, 0x53, 0x81,
  0x8F, 0xC2, 0x06, 0xA0, 0x40, 0x6A, 0x02, 0x28, 0x1C, 0xFA, 0x38, 0x1D, 0xF7, 0x20, 0x6A, 0x04,
  0x06, 0xA0, 0x22, 0x81, 0x8F, 0xE2, 0x03, 0xA0, 0x32, 0x06, 0xA0, 0x40, 0x6A, 0x02, 0x20, 0x3A,
  0x83, 0x40, 0x7F, 0xD3, 0x06, 0xA0, 0x40, 0x6A, 0x02, 0x38, 0x5D, 0xF9, 0x0C, 0xF8, 0x30, 0x6A,
  0x04, 0x06, 0xA0, 0x23, 0x82, 0x9F, 0xE2, 0xA0, 0x43, 0x06, 0xA0, 0x40, 0x6A, 0x02, 0x30, 0x4A,
  0x81, 0xAF, 0xE4, 0x06, 0xA0, 0x40, 0x6A, 0x02, 0x40, 0xEB, 0x09, 0x40, 0x6A, 0x04, 0x06, 0xA0,
  0x24, 0x0A, 0xB0, 0x44, 0x06, 0xA0, 0x40, 0x6A, 0x02, 0x40, 0x5A, 0x0E, 0x50, 0x6A, 0x04, 0x06,
  0xA0, 0x25, 0xA0, 0xA5, 0x06, 0xA0, 0x40,
  // "N" (U+004E)
  0x06, 0xB0, 0x17, 0x01, 0xA0, 0x70, 0x6B, 0x09, 0x70, 0x1A, 0x07, 0x06, 0xC0, 0x16, 0x01, 0xA0,
  0x70, 0x6C, 0x08, 0x60, 0x1A, 0x86, 0x76, 0xFE, 0xDF, 0xE1, 0x50, 0x1A, 0x07, 0x06, 0xA0, 0x5A,
  0x08, 0x50, 0x1A, 0x07, 0x06, 0xA8, 0x31, 0xDF, 0xE1, 0x40, 0x1A, 0x07, 0x06, 0xA0, 0x10, 0x6A,
  0x08, 0x40, 0x1A, 0x07, 0x06, 0xA8, 0x42, 0x0D, 0xFE, 0x13, 0x01, 0xA0, 0x70, 0x6A, 0x81, 0x20,
  0x6A, 0x07, 0x30, 0x1A, 0x07, 0x06, 0xA0, 0x22, 0x81, 0xDF, 0xE3, 0x01, 0xA0, 0x70, 0x6A, 0x02,
  0x20, 0x6A, 0x07, 0x20, 0x1A, 0x07, 0x06, 0xA0, 0x23, 0x81, 0xEF, 0xE2, 0x01, 0xA0, 0x70, 0x6A,
  0x02, 0x30, 0x7A, 0x81, 0x60, 0x1A, 0x07, 0x06, 0xA0, 0x24, 0x83, 0xEF, 0xD0, 0x1A, 0x07, 0x06,
  0xA0, 0x24, 0x07, 0xA0, 0x61, 0xA0, 0x70, 0x6A, 0x02, 0x58, 0x1E, 0xFD, 0x1A, 0x07, 0x06, 0xA0,
  0x25, 0x07, 0xA0, 0x6A, 0x07, 0x06, 0xA0, 0x25, 0x86, 0x1E, 0xFD, 0xEF, 0x76, 0xA0, 0x26, 0x07,
  0xC0, 0x70, 0x6A, 0x02, 0x60, 0x10, 0xEB, 0x07, 0x06, 0xA0, 0x27, 0x08, 0xB0, 0x70, 0x6A, 0x02,
  0x70, 0x10, 0xEA, 0x07,
  // "O" (U+004F)
  0x58, 0x64, 0xAD, 0xEE, 0xD9, 0x37, 0x10, 0x10, 0xBF, 0x90, 0x87, 0x0C, 0xA8, 0x3E, 0x96, 0x69,
  0xB0, 0x85, 0x08, 0xA0, 0xC0, 0x14, 0x02, 0x0D, 0xA0, 0x43, 0x01, 0xA0, 0xE0, 0x16, 0x03, 0xA0,
  0xC3, 0x06, 0xA0, 0x87, 0x10, 0xBA, 0x03, 0x20, 0xBA, 0x02, 0x71, 0x05, 0xA0, 0x72, 0x81, 0xEF,
  0xE7, 0x20, 0x1A, 0x81, 0xB0, 0x1A, 0x0C, 0x73, 0x83, 0xEF, 0xE0, 0x3A, 0x0A, 0x73, 0x0D, 0xA1,
  0x03, 0xA0, 0x97, 0x30, 0xCA, 0x01, 0x04, 0xA0, 0x97, 0x30, 0xCA, 0x01, 0x03, 0xA0, 0x97, 0x30,
  0xCA, 0x01, 0x02, 0xA0, 0xA7, 0x30, 0xDA, 0x10, 0x1A, 0x0C, 0x73, 0xA0, 0xE2, 0x81, 0xDF, 0xE7,
  0x20, 0x2A, 0x0B, 0x20, 0x9A, 0x03, 0x71, 0x05, 0xA0, 0x72, 0x05, 0xA0, 0x87, 0x10, 0xBA, 0x03,
  0x38, 0x2E, 0xFE, 0x16, 0x03, 0xA0, 0xC4, 0x06, 0xA0, 0xC0, 0x14, 0x02, 0x0D, 0xA0, 0x45, 0x0B,
  0xA8, 0x3E, 0x96, 0x69, 0xB0, 0x87, 0x0A, 0xF9, 0x08, 0x72, 0x86, 0x4A, 0xDF, 0xED, 0x93, 0x50,
  // "P" (U+0050)
  0x06, 0xD8, 0x2E, 0xC8, 0x23, 0x06, 0xFA, 0x07, 0x20, 0x6A, 0x83, 0x85, 0x57, 0xBB, 0x81, 0x60,
  0x6A, 0x04, 0x40, 0x5A, 0x81, 0xE0, 0x6A, 0x04, 0x50, 0xAA, 0x04, 0x06, 0xA0, 0x45, 0x06, 0xA0,
  0x70, 0x6A, 0x04, 0x50, 0x4A, 0x08, 0x06, 0xA0, 0x45, 0x05, 0xA0, 0x70, 0x6A, 0x04, 0x50, 0x7A,
  0x00, 0x6A, 0x04, 0x50, 0xBA, 0x02, 0x06, 0xA0, 0x44, 0x07, 0xA8, 0x1C, 0x06, 0xA8, 0x38, 0x56,
  0x8C, 0xB8, 0x13, 0x06, 0xF9, 0x0E, 0x04, 0x20, 0x6D, 0x82, 0xEB, 0x71, 0x30, 0x6A, 0x04, 0x72,
  0x06, 0xA0, 0x47, 0x20, 0x6A, 0x04, 0x72, 0x06, 0xA0, 0x47, 0x20, 0x6A, 0x04, 0x72, 0x06, 0xA0,
  0x47, 0x20, 0x6A, 0x04, 0x72, 0x06, 0xA0, 0x47, 0x20, 0x6A, 0x04, 0x72,
  // "Q" (U+0051)
  0x58, 0x64, 0xAD, 0xEE, 0xD9, 0x37, 0x10, 0x10, 0xBF, 0x90, 0x87, 0x0C, 0xA8, 0x3E, 0x96, 0x69,
  0xB0, 0x95, 0x08, 0xA0, 0xC0, 0x14, 0x02, 0x0D, 0xA0, 0x53, 0x01, 0xA0, 0xE0, 0x16, 0x03, 0xA0,
  0xD3, 0x06, 0xA0, 0x87, 0x10, 0xBA, 0x03, 0x20, 0xBA, 0x02, 0x71, 0x05, 0xA0, 0x82, 0x81, 0xEF,
  0xE7, 0x20, 0x1A, 0x81, 0xB0, 0x1A, 0x0C, 0x73, 0x83, 0xEF, 0xE0, 0x3A, 0x0A, 0x73, 0x0D, 0xA1,
  0x03, 0xA0, 0x97, 0x30, 0xCA, 0x01, 0x04, 0xA0, 0x97, 0x30, 0xCA, 0x01, 0x03, 0xA0, 0x97, 0x30,
  0xCA, 0x01, 0x02, 0xA0, 0xA7, 0x30, 0xDA, 0x10, 0x1A, 0x0C, 0x73, 0xA0, 0xE2, 0x81, 0xDF, 0xE7,
  0x20, 0x2A, 0x0C, 0x20, 0xAA, 0x03, 0x71, 0x05, 0xA0, 0x82, 0x05, 0xA0, 0x87, 0x10, 0xBA, 0x03,
  0x38, 0x2E, 0xFE, 0x16, 0x03, 0xA0, 0xD4, 0x07, 0xA0, 0xC0, 0x14, 0x02, 0x0D, 0xA0, 0x55, 0x0B,
  0xA8, 0x3E, 0x96, 0x69, 0xB0, 0x97, 0x0A, 0xF9, 0x08, 0x72, 0x81, 0x4A, 0xDC, 0x06, 0x77, 0x02,
  0xA0, 0xD7, 0x71, 0x08, 0xA0, 0x97, 0x71, 0x0E, 0xA0, 0x47, 0x70, 0x5A, 0x0D, 0x77, 0x10, 0xBA,
  0x09, 0x77, 0x02, 0x0F, 0x72,
  // "R" (U+0052)
  0x06, 0xD8, 0x2E, 0xC9, 0x34, 0x06, 0xFA, 0x08, 0x30, 0x6A, 0x83, 0x85, 0x57, 0xAB, 0x07, 0x20,
  0x6A, 0x04, 0x40, 0x4A, 0x82, 0xE1, 0x06, 0xA0, 0x45, 0x09, 0xA8, 0x15, 0x06, 0xA0, 0x45, 0x05,
  0xA8, 0x17, 0x06, 0xA0, 0x45, 0x04, 0xA8, 0x18, 0x06, 0xA0, 0x45, 0x05, 0xA8, 0x16, 0x06, 0xA0,
  0x45, 0x08, 0xA8, 0x14, 0x06, 0xA0, 0x44, 0x82, 0x1E, 0xFE, 0x20, 0x6A, 0x04, 0x28, 0x11, 0x5D,
  0xA0, 0x62, 0x06, 0xFA, 0x08, 0x30, 0x6F, 0x0E, 0x03, 0x40, 0x6A, 0x82, 0x85, 0x5B, 0xA0, 0x24,
  0x06, 0xA0, 0x42, 0x03, 0xA0, 0xA4, 0x06, 0xA0, 0x43, 0x0B, 0xA0, 0x23, 0x06, 0xA0, 0x43, 0x04,
  0xA0, 0xA3, 0x06, 0xA0, 0x44, 0x0C, 0xA0, 0x22, 0x06, 0xA0, 0x44, 0x05, 0xA0, 0x92, 0x06, 0xA0,
  0x45, 0x0D, 0xA8, 0x12, 0x06, 0xA0, 0x45, 0x06, 0xA8, 0x19, 0x06, 0xA0, 0x46, 0x0E, 0xA0, 0x20,
  0x6A, 0x04, 0x60, 0x7A, 0x09,
  // "S" (U+0053)
  0x38, 0x73, 0x9D, 0xEE, 0xDA, 0x61, 0x30, 0x8F, 0x90, 0xB2, 0x07, 0xB8, 0x59, 0x66, 0x9E, 0xF6,
  0x28, 0x2E, 0xFE, 0x25, 0x82, 0x61, 0x04, 0xA0, 0x87, 0x20, 0x6A, 0x05, 0x72, 0x06, 0xA0, 0x67,
  0x20, 0x4A, 0x0B, 0x73, 0x0E, 0xA0, 0x77, 0x20, 0x7B, 0x0B, 0x02, 0x71, 0x09, 0xC0, 0xA0, 0x27,
  0x05, 0x0D, 0xC0, 0x77, 0x10, 0x70, 0xEB, 0x0A, 0x72, 0x08, 0xB0, 0x67, 0x20, 0x5A, 0x0D, 0x73,
  0x0C, 0xA0, 0x17, 0x20, 0x8A, 0x03, 0x72, 0x09, 0xA0, 0x17, 0x28, 0x4D, 0xFE, 0x04, 0x16, 0x08,
  0xA8, 0x90, 0x80, 0xAF, 0xC8, 0x65, 0x7B, 0xA8, 0x2D, 0x10, 0xAF, 0x90, 0xD0, 0x22, 0x87, 0x16,
  0xAD, 0xEF, 0xEB, 0x64,
  // "T" (U+0054)
  0x0A, 0xFD, 0x07, 0x0A, 0xFD, 0x85, 0x73, 0x55, 0x55, 0x9A, 0x84, 0x85, 0x55, 0x52, 0x50, 0x6A,
  0x04, 0x73, 0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04, 0x73, 0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04, 0x73,
  0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04, 0x73, 0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04, 0x73, 0x06, 0xA0,
  0x47, 0x30, 0x6A, 0x04, 0x73, 0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04, 0x73, 0x06, 0xA0, 0x47, 0x30,
  0x6A, 0x04, 0x73, 0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04, 0x73, 0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04,
  0x73, 0x06, 0xA0, 0x45,
  // "U" (U+0055)
  0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0,
  0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A,
  0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06,
  0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70,
  0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17,
  0x06, 0xA0, 0x40, 0x9A, 0x02, 0x70, 0x6A, 0x04, 0x08, 0xA0, 0x27, 0x07, 0xA0, 0x30, 0x6A, 0x05,
  0x70, 0xAA, 0x01, 0x03, 0xA0, 0xA7, 0x81, 0xEF, 0xD2, 0x0C, 0xA0, 0x55, 0x09, 0xA0, 0x72, 0x03,
  0xB8, 0x3B, 0x65, 0x7C, 0xA0, 0xD4, 0x05, 0xF9, 0x0D, 0x02, 0x58, 0x61, 0x8C, 0xEF, 0xEB, 0x64,
  // "V" (U+0056)
  0x0D, 0xA7, 0x20, 0x5A, 0x07, 0x09, 0xA0, 0x47, 0x10, 0x9A, 0x03, 0x05, 0xA0, 0x87, 0x18, 0x1D,
  0xFE, 0x2A, 0x0C, 0x70, 0x2A, 0x0A, 0x20, 0xCA, 0x70, 0x6A, 0x06, 0x20, 0x7A, 0x04, 0x60, 0xAA,
  0x01, 0x20, 0x3A, 0x08, 0x68, 0x1E, 0xFD, 0x48, 0x1E, 0xFC, 0x50, 0x3A, 0x08, 0x40, 0xAA, 0x01,
  0x40, 0x7A, 0x04, 0x40, 0x6A, 0x05, 0x40, 0xBA, 0x50, 0x2A, 0x09, 0x48, 0x1E, 0xFB, 0x68, 0x1D,
  0xFD, 0x30, 0x3A, 0x07, 0x60, 0x9A, 0x01, 0x20, 0x7A, 0x03, 0x60, 0x5A, 0x05, 0x28, 0x1B, 0xFE,
  0x70, 0x1A, 0x09, 0x2A, 0x0A, 0x71, 0x83, 0xCF, 0xD0, 0x4A, 0x05, 0x71, 0x07, 0xA0, 0x10, 0x8A,
  0x01, 0x71, 0x03, 0xA8, 0x25, 0xBF, 0xC7, 0x38, 0x4E, 0xF8, 0xEF, 0x87, 0x38, 0x1A, 0xFD, 0xA0,
  0x47, 0x30, 0x6C, 0x74, 0x02, 0xB0, 0xB7, 0x50, 0xDA, 0x07, 0x60,
  // "W" (U+0057)
  0x0A, 0xA0, 0x17, 0x81, 0xEF, 0xE7, 0x01, 0xA0, 0xB0, 0x7A, 0x05, 0x60, 0x2B, 0x02, 0x60, 0x4A,
  0x07, 0x03, 0xA0, 0x86, 0x06, 0xB0, 0x66, 0x07, 0xA0, 0x41, 0xA0, 0xB6, 0x09, 0xB0, 0x96, 0x0A,
  0xA2, 0x81, 0xCF, 0xE6, 0x83, 0xDF, 0xCF, 0xD6, 0x81, 0xEF, 0xC2, 0x09, 0xA0, 0x24, 0x01, 0xA0,
  0x8A, 0x01, 0x40, 0x2A, 0x09, 0x20, 0x5A, 0x06, 0x40, 0x4A, 0x03, 0xA0, 0x44, 0x05, 0xA0, 0x62,
  0x02, 0xA0, 0x94, 0x85, 0x8F, 0xD0, 0xEF, 0x84, 0x08, 0xA0, 0x23, 0x81, 0xEF, 0xC4, 0x85, 0xBF,
  0xA0, 0xBF, 0xB4, 0x81, 0xCF, 0xE4, 0x0A, 0xA4, 0x83, 0xEF, 0x70, 0x7A, 0x4A, 0x0B, 0x40, 0x7A,
  0x03, 0x20, 0x3A, 0x81, 0x30, 0x3A, 0x03, 0x20, 0x3A, 0x07, 0x40, 0x3A, 0x07, 0x20, 0x6A, 0x3A,
  0x07, 0x20, 0x6A, 0x04, 0x5A, 0x0A, 0x28, 0x1A, 0xFC, 0x38, 0x1C, 0xFA, 0x20, 0x9A, 0x01, 0x58,
  0x1C, 0xFD, 0x28, 0x1D, 0xF8, 0x38, 0x18, 0xFE, 0x28, 0x1D, 0xFD, 0x60, 0x8A, 0x00, 0x1A, 0x05,
  0x30, 0x5A, 0x02, 0x01, 0xA0, 0x96, 0x05, 0xA0, 0x04, 0xA0, 0x13, 0x01, 0xA0, 0x50, 0x4A, 0x06,
  0x60, 0x1A, 0x82, 0x67, 0xFD, 0x58, 0x2D, 0xF8, 0x7A, 0x02, 0x78, 0x4D, 0xF9, 0xAF, 0xA5, 0x84,
  0x9F, 0xA9, 0xFE, 0x71, 0x84, 0xAF, 0xBD, 0xF6, 0x58, 0x46, 0xFD, 0xBF, 0xB7, 0x18, 0x16, 0xFE,
  0xA0, 0x35, 0x02, 0xA8, 0x1E, 0xF8, 0x71, 0x03, 0xB0, 0xE7, 0x0E, 0xB0, 0x47, 0x2B, 0x0B, 0x70,
  0xBB, 0x01, 0x72, 0x0B, 0xA0, 0x87, 0x07, 0xA0, 0xD5,
  // "X" (U+0058)
  0x82, 0x1E, 0xFD, 0x78, 0x1E, 0xFD, 0x20, 0x9A, 0x04, 0x50, 0x6A, 0x06, 0x20, 0x2A, 0x0A, 0x58,
  0x1D, 0xFE, 0x40, 0xAA, 0x02, 0x30, 0x4A, 0x07, 0x40, 0x3A, 0x08, 0x38, 0x2B, 0xFE, 0x15, 0x81,
  0xBF, 0xE2, 0x02, 0xA0, 0x86, 0x04, 0xA8, 0x16, 0x08, 0xA0, 0x17, 0x85, 0xCF, 0xC0, 0xEF, 0xA7,
  0x10, 0x5A, 0x0A, 0xA0, 0x37, 0x20, 0xDB, 0x0B, 0x73, 0x06, 0xB0, 0x47, 0x30, 0x5B, 0x01, 0x73,
  0x0C, 0xB0, 0x87, 0x20, 0x4A, 0x81, 0xEF, 0xE7, 0x28, 0x2B, 0xFD, 0x4A, 0x07, 0x70, 0x3A, 0x83,
  0x70, 0xCF, 0xD7, 0x84, 0xBF, 0xE1, 0x05, 0xA0, 0x65, 0x02, 0xA0, 0x83, 0x81, 0xEF, 0xD5, 0x0A,
  0xA0, 0x13, 0x08, 0xA0, 0x43, 0x02, 0xA0, 0xA4, 0x01, 0xA0, 0xC3, 0x09, 0xA0, 0x35, 0x0A, 0xA8,
  0x13, 0x01, 0xA0, 0xB6, 0x03, 0xA8, 0x1B, 0x08, 0xA0, 0x47, 0x0C, 0xA0, 0x20,
  // "Y" (U+0059)
  0x0C, 0xA0, 0x17, 0x82, 0xDF, 0xE6, 0xA0, 0x76, 0x03, 0xA8, 0x39, 0x0E, 0xFD, 0x60, 0x9A, 0x81,
  0x20, 0x9A, 0x04, 0x58, 0x1E, 0xFC, 0x20, 0x2A, 0x0A, 0x40, 0x6A, 0x05, 0x30, 0xCA, 0x01, 0x38,
  0x1C, 0xFE, 0x40, 0x5A, 0x06, 0x20, 0x2A, 0x08, 0x58, 0x1E, 0xFC, 0x20, 0x8A, 0x02, 0x50, 0x8A,
  0x83, 0x30, 0xEF, 0xB6, 0x02, 0xA0, 0x90, 0x5A, 0x05, 0x78, 0x4B, 0xFE, 0xBF, 0xE7, 0x10, 0x5C,
  0x08, 0x72, 0x0E, 0xB0, 0x27, 0x20, 0x8A, 0x0B, 0x73, 0x04, 0xA0, 0x77, 0x30, 0x4A, 0x07, 0x73,
  0x04, 0xA0, 0x77, 0x30, 0x4A, 0x07, 0x73, 0x04, 0xA0, 0x77, 0x30, 0x4A, 0x07, 0x73, 0x04, 0xA0,
  0x77, 0x30, 0x4A, 0x07, 0x73, 0x04, 0xA0, 0x75,
  // "Z" (U+005A)
  0x0D, 0xFB, 0x08, 0x0D, 0xFB, 0x08, 0x04, 0x80, 0x35, 0x0C, 0xA0, 0x47, 0x01, 0xA0, 0xD7, 0x10,
  0x8A, 0x06, 0x71, 0x81, 0xEF, 0xE7, 0x10, 0x6A, 0x07, 0x71, 0x82, 0xDF, 0xE1, 0x70, 0x5A, 0x08,
  0x71, 0x0C, 0xA0, 0x17, 0x04, 0xA0, 0xA7, 0x10, 0xBA, 0x02, 0x70, 0x2A, 0x0B, 0x71, 0x09, 0xA0,
  0x47, 0x01, 0xA0, 0xC7, 0x10, 0x8A, 0x05, 0x71, 0x81, 0xEF, 0xD7, 0x10, 0x7A, 0x06, 0x71, 0x81,
  0xDF, 0xE7, 0x10, 0x5A, 0x08, 0x71, 0x0C, 0xA0, 0x78, 0x03, 0x50, 0x4F, 0xC0, 0xBF, 0xC0, 0xB0,
  // "[" (U+005B)
  0x09, 0xE0, 0x30, 0x9E, 0x89, 0x23, 0x9F, 0xE5, 0x55, 0x51, 0x9F, 0xE5, 0x81, 0x9F, 0xE5, 0x81,
  0x9F, 0xE5, 0x81, 0x9F, 0xE5, 0x81, 0x9F, 0xE5, 0x81, 0x9F, 0xE5, 0x81, 0x9F, 0xE5, 0x81, 0x9F,
  0xE5, 0x81, 0x9F, 0xE5, 0x81, 0x9F, 0xE5, 0x81, 0x9F, 0xE5, 0x81, 0x9F, 0xE5, 0x81, 0x9F, 0xE5,
  0x81, 0x9F, 0xE5, 0x81, 0x9F, 0xE5, 0x81, 0x9F, 0xE5, 0x81, 0x9F, 0xE5, 0x81, 0x9F, 0xE5, 0x81,
  0x9F, 0xE5, 0x81, 0x9F, 0xE5, 0x81, 0x9F, 0xE5, 0x81, 0x9F, 0xE5, 0x81, 0x9F, 0xE5, 0x87, 0x9F,
  0xE5, 0x55, 0x51, 0x9E, 0x03, 0x09, 0xE0, 0x30,
  // "\" (U+005C)
  0x04, 0xA0, 0x37, 0x28, 0x1E, 0xF9, 0x72, 0x81, 0x8F, 0xE7, 0x20, 0x3A, 0x05, 0x72, 0x81, 0xDF,
  0xA7, 0x20, 0x7A, 0x01, 0x71, 0x01, 0xA0, 0x67, 0x28, 0x1B, 0xFC, 0x72, 0x05, 0xA0, 0x27, 0x28,
  0x1E, 0xF8, 0x72, 0x81, 0xAF, 0xD7, 0x20, 0x4A, 0x04, 0x72, 0x81, 0xEF, 0x97, 0x28, 0x18, 0xFE,
  0x72, 0x02, 0xA0, 0x57, 0x28, 0x1C, 0xFB, 0x72, 0x07, 0xA0, 0x17, 0x10, 0x1A, 0x07, 0x72, 0x81,
  0xBF, 0xC7, 0x20, 0x5A, 0x03, 0x72, 0x81, 0xEF, 0x87, 0x28, 0x19, 0xFE, 0x72, 0x04, 0xA0, 0x40,
  // "]" (U+005D)
  0x01, 0xE0, 0xC0, 0x1E, 0x87, 0xC0, 0x55, 0x55, 0xDF, 0xC5, 0x81, 0xCF, 0xC5, 0x81, 0xCF, 0xC5,
  0x81, 0xCF, 0xC5, 0x81, 0xCF, 0xC5, 0x81, 0xCF, 0xC5, 0x81, 0xCF, 0xC5, 0x81, 0xCF, 0xC5, 0x81,
  0xCF, 0xC5, 0x81, 0xCF, 0xC5, 0x81, 0xCF, 0xC5, 0x81, 0xCF, 0xC5, 0x81, 0xCF, 0xC5, 0x81, 0xCF,
  0xC5, 0x81, 0xCF, 0xC5, 0x81, 0xCF, 0xC5, 0x81, 0xCF, 0xC5, 0x81, 0xCF, 0xC5, 0x81, 0xCF, 0xC5,
  0x81, 0xCF, 0xC5, 0x81, 0xCF, 0xC5, 0x81, 0xCF, 0xC5, 0x81, 0xCF, 0xC5, 0x89, 0x2C, 0xFC, 0x05,
  0x55, 0x5D, 0xFC, 0x1E, 0x0C, 0x01, 0xE0, 0xC0,
  // "^" (U+005E)
  0x68, 0x12, 0x73, 0x75, 0x81, 0x9F, 0xD7, 0x40, 0x1B, 0x05, 0x73, 0x08, 0xB0, 0xC7, 0x38, 0x1E,
  0xF7, 0xA0, 0x47, 0x18, 0x57, 0xFD, 0x0A, 0xFB, 0x71, 0x83, 0xDF, 0x70, 0x3A, 0x03, 0x60, 0x5A,
  0x01, 0x28, 0x1B, 0xFA, 0x68, 0x1C, 0xF9, 0x30, 0x4A, 0x02, 0x40, 0x4A, 0x02, 0x48, 0x1D, 0xF9,
  0x48, 0x1B, 0xFB, 0x50, 0x6A, 0x01, 0x20, 0x2A, 0x04, 0x68, 0x1E, 0xF8, 0x28, 0x19, 0xFD, 0x78,
  0x37, 0xFE, 0x11, 0xA0, 0x67, 0x82, 0x1E, 0xF7,
  // "_" (U+005F)
  0x18, 0x09, 0x25, 0x10, 0x1F, 0xF0, 0x01, 0xFF, 0x01,
  // "`" (U+0060)
  0x82, 0x57, 0x74, 0x30, 0x5A, 0x0E, 0x40, 0x9A, 0x07, 0x48, 0x2B, 0xFE, 0x14, 0x81, 0xCF, 0x94,
  0x82, 0x1C, 0xF3,
  // "a" (U+0061)
  0x28, 0x61, 0x7B, 0xEF, 0xEA, 0x33, 0x02, 0x0E, 0xF0, 0x43, 0x84, 0xDE, 0x96, 0x6A, 0xA0, 0xD3,
  0x02, 0x50, 0x9A, 0x03, 0x71, 0x03, 0xA0, 0x67, 0x10, 0x2A, 0x07, 0x71, 0x01, 0xA0, 0x72, 0x82,
  0x17, 0xBE, 0xD8, 0x28, 0x03, 0xEF, 0x98, 0x18, 0x0E, 0xA8, 0x3D, 0x86, 0x56, 0xA0, 0x80, 0x6A,
  0x0B, 0x40, 0x1A, 0x08, 0x0A, 0xA0, 0x24, 0x02, 0xA0, 0x80, 0xBA, 0x50, 0x4A, 0x08, 0x0B, 0xA5,
  0x08, 0xA0, 0x08, 0xA0, 0x53, 0x03, 0xB0, 0x80, 0x3B, 0x89, 0x08, 0x68, 0xFB, 0xDF, 0x80, 0x9D,
  0x83, 0xD1, 0xBF, 0x82, 0x89, 0x07, 0xDF, 0xD9, 0x10, 0x8F, 0x80,
  // "b" (U+0062)
  0x81, 0xBF, 0xE7, 0x38, 0x1B, 0xFE, 0x73, 0x81, 0xBF, 0xE7, 0x38, 0x1B, 0xFE, 0x73, 0x81, 0xBF,
  0xE7, 0x38, 0x1B, 0xFE, 0x73, 0x81, 0xBF, 0xE7, 0x38, 0x90, 0xBF, 0xE0, 0x2A, 0xEE, 0xC6, 0x38,
  0x3B, 0xFD, 0x3E, 0xD0, 0xA2, 0x87, 0xBF, 0xDD, 0xE8, 0x68, 0xEA, 0x81, 0x60, 0xBA, 0x0E, 0x02,
  0x38, 0x42, 0xEF, 0xE0, 0xBA, 0x08, 0x50, 0x9A, 0x04, 0x0B, 0xA0, 0x35, 0x04, 0xA0, 0x70, 0xBA,
  0x01, 0x50, 0x1A, 0x0A, 0x0B, 0xA7, 0xA8, 0x2B, 0xBF, 0xE7, 0x84, 0xEF, 0xCB, 0xFE, 0x78, 0x2E,
  0xFC, 0xBA, 0x7A, 0x00, 0xBA, 0x01, 0x50, 0x1A, 0x0A, 0x0B, 0xA0, 0x35, 0x04, 0xA0, 0x70, 0xBA,
  0x08, 0x50, 0x9A, 0x03, 0x0B, 0xA0, 0xE0, 0x23, 0x02, 0xA8, 0x91, 0xD0, 0xBF, 0xDE, 0xE8, 0x67,
  0xEA, 0x85, 0x60, 0xBF, 0x93, 0xED, 0x0A, 0x28, 0x90, 0xBF, 0x60, 0x2A, 0xEE, 0xC6, 0x30,
  // "c" (U+0063)
  0x38, 0x61, 0x7C, 0xEE, 0xC8, 0x22, 0x02, 0x0D, 0xE0, 0x52, 0x0D, 0xA8, 0x3B, 0x66, 0xAE, 0x20,
  0x7A, 0x09, 0x78, 0x1D, 0xFE, 0x70, 0x2A, 0x09, 0x70, 0x4A, 0x06, 0x70, 0x6A, 0x04, 0x70, 0x7A,
  0x03, 0x70, 0x7A, 0x03, 0x70, 0x6A, 0x04, 0x70, 0x5A, 0x06, 0x70, 0x2A, 0x09, 0x71, 0x81, 0xEF,
  0xE7, 0x10, 0x9A, 0x08, 0x70, 0x10, 0xEA, 0x84, 0xB6, 0x68, 0xD5, 0x20, 0x30, 0xEE, 0x05, 0x38,
  0x61, 0x8D, 0xFE, 0xC7, 0x10,
  // "d" (U+0064)
  0x73, 0x0A, 0xA7, 0x30, 0xAA, 0x73, 0x0A, 0xA7, 0x30, 0xAA, 0x73, 0x0A, 0xA7, 0x30, 0xAA, 0x73,
  0x0A, 0xA3, 0x86, 0x3B, 0xEE, 0xB4, 0x0A, 0xA2, 0x05, 0xE0, 0x60, 0x9A, 0x10, 0x2B, 0x84, 0x96,
  0x7D, 0xFC, 0xA1, 0x09, 0xA0, 0x64, 0x0C, 0xB1, 0x81, 0xEF, 0xD5, 0x04, 0xB0, 0x3A, 0x08, 0x60,
  0xEA, 0x05, 0xA0, 0x56, 0x0C, 0xA0, 0x7A, 0x03, 0x60, 0xAA, 0x07, 0xA0, 0x36, 0x0A, 0xA0, 0x7A,
  0x03, 0x60, 0x9A, 0x07, 0xA0, 0x36, 0x0A, 0xA0, 0x5A, 0x05, 0x60, 0xBA, 0x03, 0xA0, 0x86, 0x0E,
  0xA1, 0x81, 0xEF, 0xD5, 0x03, 0xB1, 0x0A, 0xA0, 0x64, 0x0C, 0xB1, 0x02, 0xB8, 0x49, 0x67, 0xDF,
  0xBA, 0x20, 0x6E, 0x07, 0x05, 0xA3, 0x86, 0x3B, 0xEE, 0xB4, 0x03, 0xA0,
  // "e" (U+0065)
  0x38, 0x51, 0x9D, 0xFD, 0xA2, 0x50, 0x30, 0xEE, 0x04, 0x40, 0xEA, 0x82, 0x86, 0x7E, 0xA0, 0x12,
  0x07, 0xA0, 0x33, 0x02, 0xA0, 0x92, 0x81, 0xDF, 0xA5, 0x83, 0xAF, 0xE0, 0x2A, 0x06, 0x50, 0x5A,
  0x02, 0x04, 0xA0, 0x35, 0x03, 0xA0, 0x40, 0x6F, 0xC0, 0x50, 0x7F, 0xC0, 0x50, 0x7A, 0x07, 0x80,
  0x45, 0x02, 0x06, 0xA0, 0x37, 0x20, 0x4A, 0x05, 0x72, 0x01, 0xA0, 0x97, 0x38, 0x1C, 0xFE, 0x73,
  0x05, 0xA0, 0xA6, 0x04, 0x30, 0xCA, 0x85, 0xC7, 0x56, 0xAE, 0xA3, 0x01, 0x0C, 0xF0, 0xA5, 0x85,
  0x7C, 0xEF, 0xEB, 0x62,
  // "f" (U+0066)
  0x58, 0x21, 0x44, 0x25, 0x08, 0xC0, 0xB3, 0x06, 0xD0, 0x73, 0x85, 0xDF, 0xE4, 0x03, 0x12, 0x01,
  0xA0, 0x96, 0x03, 0xA0, 0x66, 0x04, 0xA0, 0x56, 0x05, 0xA0, 0x54, 0x81, 0x28, 0xED, 0x81, 0x90,
  0x9F, 0x83, 0x90, 0x35, 0x8A, 0x82, 0x95, 0x53, 0x30, 0x4A, 0x05, 0x60, 0x4A, 0x05, 0x60, 0x4A,
  0x05, 0x60, 0x4A, 0x05, 0x60, 0x4A, 0x05, 0x60, 0x4A, 0x05, 0x60, 0x4A, 0x05, 0x60, 0x4A, 0x05,
  0x60, 0x4A, 0x05, 0x60, 0x4A, 0x05, 0x60, 0x4A, 0x05, 0x60, 0x4A, 0x05, 0x60, 0x4A, 0x05, 0x60,
  0x4A, 0x05, 0x60, 0x4A, 0x05, 0x40,
  // "g" (U+0067)
  0x38, 0x63, 0xAE, 0xEB, 0x40, 0x3A, 0x20, 0x5E, 0x06, 0x05, 0xA1, 0x02, 0x0E, 0xA8, 0x49, 0x67,
  0xDF, 0xAA, 0x10, 0x9A, 0x06, 0x30, 0x10, 0xDB, 0x18, 0x1E, 0xFD, 0x50, 0x4B, 0x03, 0xA0, 0x86,
  0xB0, 0x5A, 0x05, 0x60, 0xCA, 0x07, 0xA0, 0x36, 0x0A, 0xA0, 0x7A, 0x03, 0x60, 0xAA, 0x07, 0xA0,
  0x36, 0x09, 0xA0, 0x7A, 0x03, 0x60, 0xAA, 0x05, 0xA0, 0x56, 0x0B, 0xA0, 0x3A, 0x08, 0x60, 0xEA,
  0x18, 0x1E, 0xFC, 0x50, 0x3B, 0x10, 0xAA, 0x06, 0x40, 0xCB, 0x10, 0x2B, 0x84, 0x96, 0x7D, 0xFB,
  0xA2, 0x06, 0xE0, 0x60, 0x9A, 0x38, 0x64, 0xBE, 0xEB, 0x40, 0x9A, 0x73, 0x0A, 0xA7, 0x38, 0x1A,
  0xFE, 0x73, 0x81, 0xDF, 0xC7, 0x20, 0x2A, 0x82, 0x90, 0x42, 0x60, 0xCA, 0x89, 0x03, 0x08, 0xFC,
  0x86, 0x58, 0xDA, 0x0A, 0x20, 0x8F, 0x90, 0xB4, 0x81, 0x6A, 0xDA, 0x81, 0xDA, 0x53,
  // "h" (U+0068)
  0x81, 0xBF, 0xE7, 0x28, 0x1B, 0xFE, 0x72, 0x81, 0xBF, 0xE7, 0x28, 0x1B, 0xFE, 0x72, 0x81, 0xBF,
  0xE7, 0x28, 0x1B, 0xFE, 0x72, 0x81, 0xBF, 0xE7, 0x28, 0x90, 0xBF, 0xE0, 0x2A, 0xEE, 0xC7, 0x28,
  0x3B, 0xFD, 0x4E, 0xD8, 0x91, 0xA0, 0xBF, 0xDD, 0xE8, 0x68, 0xEA, 0x04, 0x0B, 0xA0, 0xE0, 0x23,
  0x04, 0xA0, 0xA0, 0xBA, 0x08, 0x58, 0x2E, 0xFD, 0xBA, 0x03, 0x58, 0x2B, 0xFE, 0xBA, 0x01, 0x58,
  0x2B, 0xFE, 0xBA, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF,
  0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A,
  0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE,
  0x68, 0x1A, 0xFE,
  // "i" (U+0069)
  0x83, 0x6E, 0xA0, 0xDA, 0x01, 0x0D, 0xA8, 0x21, 0x6E, 0x97, 0x68, 0x98, 0x5B, 0xFE, 0x0B, 0xFE,
  0x0B, 0xFE, 0x0B, 0xFE, 0x0B, 0xFE, 0x0B, 0xFE, 0x0B, 0xFE, 0x0B, 0xFE, 0x0B, 0xFE, 0x0B, 0xFE,
  0x0B, 0xFE, 0x0B, 0xFE, 0x0B, 0xFE, 0x0B, 0xFE, 0x0B, 0xFE, 0x0B, 0xFE, 0x0B, 0xFE, 0x0B, 0xFE,
  0x10,
  // "j" (U+006A)
  0x38, 0x16, 0xEA, 0x40, 0xDA, 0x01, 0x30, 0xDA, 0x01, 0x38, 0x16, 0xE9, 0x77, 0x74, 0x81, 0xBF,
  0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4,
  0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81,
  0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF,
  0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xCF, 0xD4,
  0x85, 0xEF, 0xB0, 0x66, 0xBA, 0x81, 0x80, 0xCB, 0x86, 0xE1, 0x0A, 0xEE, 0xB2, 0x20,
  // "k" (U+006B)
  0x81, 0xBF, 0xE7, 0x28, 0x1B, 0xFE, 0x72, 0x81, 0xBF, 0xE7, 0x28, 0x1B, 0xFE, 0x72, 0x81, 0xBF,
  0xE7, 0x28, 0x1B, 0xFE, 0x72, 0x81, 0xBF, 0xE7, 0x28, 0x1B, 0xFE, 0x50, 0xBA, 0x82, 0x3B, 0xFE,
  0x40, 0x6A, 0x83, 0x70, 0xBF, 0xE3, 0x82, 0x1E, 0xFC, 0x28, 0x1B, 0xFE, 0x38, 0x2B, 0xFE, 0x22,
  0x81, 0xBF, 0xE2, 0x06, 0xA0, 0x63, 0x86, 0xBF, 0xE0, 0x1E, 0xFB, 0x48, 0x6B, 0xFD, 0x0B, 0xFE,
  0x14, 0x82, 0xBF, 0xD5, 0xA0, 0xB5, 0x82, 0xBF, 0xDD, 0xB0, 0x24, 0x0B, 0xB0, 0xAA, 0x0A, 0x40,
  0xBA, 0x81, 0xA0, 0xAA, 0x02, 0x38, 0x1B, 0xFE, 0x20, 0x3A, 0x0A, 0x38, 0x1B, 0xFE, 0x30, 0xBA,
  0x02, 0x28, 0x1B, 0xFE, 0x30, 0x3A, 0x0A, 0x28, 0x1B, 0xFE, 0x40, 0xBA, 0x83, 0x20, 0xBF, 0xE4,
  0x04, 0xA8, 0x3A, 0x0B, 0xFE, 0x50, 0xCA, 0x82, 0x2B, 0xFE, 0x50, 0x5A, 0x09,
  // "l" (U+006C)
  0x89, 0x91, 0xBF, 0xEB, 0xFE, 0xBF, 0xEB, 0xFE, 0xBF, 0xEB, 0xFE, 0xBF, 0xEB, 0xFE, 0xBF, 0xEB,
  0xFE, 0xBF, 0xEB, 0xFE, 0xBF, 0xEB, 0xFE, 0xBF, 0xEB, 0xFE, 0xBF, 0xEB, 0xFE, 0xBF, 0xEB, 0xFE,
  0xBF, 0xEB, 0xFE, 0xBF, 0xEB, 0xFE, 0xBF, 0xE0,
  // "m" (U+006D)
  0x89, 0x0B, 0xF7, 0x03, 0xBE, 0xEB, 0x32, 0x85, 0x18, 0xDF, 0xD9, 0x12, 0x82, 0xBF, 0x94, 0xE8,
  0x14, 0x1C, 0xD0, 0xD2, 0x86, 0xBF, 0xCE, 0xD7, 0x6B, 0xA8, 0x5C, 0x9F, 0xA6, 0x7E, 0xA8, 0x17,
  0x0B, 0xA0, 0xD0, 0x13, 0x0B, 0xB0, 0x73, 0x03, 0xA8, 0x1C, 0x0B, 0xA0, 0x74, 0x05, 0xA0, 0xE5,
  0x83, 0xCF, 0xE0, 0xBA, 0x03, 0x40, 0x3A, 0x0B, 0x50, 0x9A, 0x10, 0xBA, 0x50, 0x2A, 0x08, 0x50,
  0x9A, 0x01, 0x0B, 0xA5, 0x02, 0xA0, 0x75, 0x09, 0xA8, 0x21, 0xBF, 0xE5, 0x02, 0xA0, 0x75, 0x09,
  0xA8, 0x21, 0xBF, 0xE5, 0x02, 0xA0, 0x75, 0x09, 0xA8, 0x21, 0xBF, 0xE5, 0x02, 0xA0, 0x75, 0x09,
  0xA8, 0x21, 0xBF, 0xE5, 0x02, 0xA0, 0x75, 0x09, 0xA8, 0x21, 0xBF, 0xE5, 0x02, 0xA0, 0x75, 0x09,
  0xA8, 0x21, 0xBF, 0xE5, 0x02, 0xA0, 0x75, 0x09, 0xA8, 0x21, 0xBF, 0xE5, 0x02, 0xA0, 0x75, 0x09,
  0xA8, 0x21, 0xBF, 0xE5, 0x02, 0xA0, 0x75, 0x09, 0xA8, 0x21, 0xBF, 0xE5, 0x02, 0xA0, 0x75, 0x09,
  0xA8, 0x21, 0xBF, 0xE5, 0x02, 0xA0, 0x75, 0x09, 0xA0, 0x10,
  // "n" (U+006E)
  0x89, 0x0B, 0xF7, 0x02, 0xAE, 0xFC, 0x72, 0x83, 0xBF, 0x93, 0xED, 0x89, 0x1A, 0x0B, 0xFC, 0xDE,
  0x86, 0x7E, 0xA0, 0x40, 0xBA, 0x0E, 0x02, 0x30, 0x5A, 0x0A, 0x0B, 0xA0, 0x75, 0x82, 0xEF, 0xCB,
  0xA0, 0x35, 0x82, 0xBF, 0xEB, 0xA6, 0x82, 0xBF, 0xEB, 0xA6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A,
  0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE,
  0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF,
  0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x81, 0xAF, 0xE0,
  // "o" (U+006F)
  0x38, 0x51, 0x8D, 0xEE, 0xC6, 0x60, 0x30, 0xEE, 0x0B, 0x40, 0x10, 0xEA, 0x82, 0xA6, 0x6C, 0xA0,
  0xA3, 0x08, 0xA0, 0x74, 0x0A, 0xA0, 0x42, 0x81, 0xDF, 0xD5, 0x01, 0xA8, 0x1A, 0x02, 0xA0, 0x86,
  0x83, 0xCF, 0xE0, 0x5A, 0x05, 0x60, 0x8A, 0x01, 0x07, 0xA0, 0x36, 0x07, 0xA0, 0x30, 0x7A, 0x03,
  0x60, 0x6A, 0x04, 0x07, 0xA0, 0x36, 0x06, 0xA0, 0x40, 0x7A, 0x03, 0x60, 0x7A, 0x03, 0x05, 0xA0,
  0x56, 0x08, 0xA0, 0x10, 0x2A, 0x08, 0x68, 0x1C, 0xFE, 0x28, 0x1D, 0xFD, 0x50, 0x1A, 0x09, 0x20,
  0x7A, 0x07, 0x40, 0xAA, 0x03, 0x30, 0xDA, 0x82, 0xA6, 0x6C, 0xA0, 0xA4, 0x02, 0x0D, 0xE0, 0xB7,
  0x84, 0x8D, 0xEE, 0xC6, 0x40,
  // "p" (U+0070)
  0x89, 0x0B, 0xF7, 0x02, 0xAE, 0xEC, 0x63, 0x83, 0xBF, 0x93, 0xED, 0x0A, 0x28, 0x7B, 0xFC, 0xDE,
  0x86, 0x8E, 0xA8, 0x16, 0x0B, 0xA0, 0xE0, 0x23, 0x02, 0xA8, 0x1E, 0x0B, 0xA0, 0x85, 0x09, 0xA0,
  0x40, 0xBA, 0x03, 0x50, 0x4A, 0x07, 0x0B, 0xA6, 0x01, 0xA0, 0xA0, 0xBA, 0x7A, 0x82, 0xBB, 0xFE,
  0x78, 0x4E, 0xFC, 0xBF, 0xE7, 0x82, 0xEF, 0xCB, 0xA7, 0xA0, 0x0B, 0xA0, 0x15, 0x01, 0xA0, 0xA0,
  0xBA, 0x03, 0x50, 0x4A, 0x07, 0x0B, 0xA0, 0x85, 0x09, 0xA0, 0x30, 0xBA, 0x0E, 0x02, 0x30, 0x3A,
  0x89, 0x1D, 0x0B, 0xFD, 0xEE, 0x86, 0x8E, 0xA8, 0x56, 0x0B, 0xFD, 0x3E, 0xD0, 0xA2, 0x89, 0x0B,
  0xFE, 0x02, 0xAE, 0xEC, 0x63, 0x81, 0xBF, 0xE7, 0x38, 0x1B, 0xFE, 0x73, 0x81, 0xBF, 0xE7, 0x38,
  0x1B, 0xFE, 0x73, 0x81, 0xBF, 0xE7, 0x38, 0x1B, 0xFE, 0x73, 0x81, 0xBF, 0xE7, 0x38, 0x1B, 0xFE,
  0x73,
  // "q" (U+0071)
  0x38, 0x63, 0xAE, 0xEB, 0x40, 0x3A, 0x20, 0x5E, 0x06, 0x05, 0xA1, 0x02, 0xB8, 0x49, 0x67, 0xDF,
  0xAA, 0x10, 0x9A, 0x06, 0x40, 0xCB, 0x18, 0x1E, 0xFD, 0x50, 0x4B, 0x03, 0xA0, 0x86, 0xB0, 0x5A,
  0x05, 0x60, 0xCA, 0x07, 0xA0, 0x36, 0x0A, 0xA0, 0x7A, 0x03, 0x60, 0xAA, 0x07, 0xA0, 0x36, 0x09,
  0xA0, 0x7A, 0x03, 0x60, 0xAA, 0x05, 0xA0, 0x56, 0x0B, 0xA0, 0x3A, 0x08, 0x60, 0xEA, 0x18, 0x1E,
  0xFD, 0x50, 0x4B, 0x10, 0xAA, 0x06, 0x40, 0xCB, 0x10, 0x2B, 0x84, 0x96, 0x7D, 0xFB, 0xA2, 0x06,
  0xE0, 0x60, 0x9A, 0x38, 0x64, 0xBE, 0xEB, 0x40, 0xAA, 0x73, 0x0A, 0xA7, 0x30, 0xAA, 0x73, 0x0A,
  0xA7, 0x30, 0xAA, 0x73, 0x0A, 0xA7, 0x30, 0xAA, 0x73, 0x0A, 0xA7, 0x30, 0xAA,
  // "r" (U+0072)
  0x89, 0x4B, 0xF6, 0x02, 0xAE, 0xF5, 0xBF, 0x82, 0xEB, 0x89, 0x53, 0xBF, 0x9B, 0xFA, 0x68, 0x1B,
  0xFE, 0xF7, 0x40, 0xBA, 0x0C, 0x50, 0xBA, 0x05, 0x50, 0xBA, 0x01, 0x50, 0xBA, 0x68, 0x1B, 0xFE,
  0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68,
  0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x60,
  // "s" (U+0073)
  0x28, 0x54, 0xAE, 0xFE, 0xB6, 0x20, 0x8F, 0x0B, 0x04, 0xA8, 0x6E, 0x76, 0x7B, 0xF5, 0xAA, 0x02,
  0x48, 0x33, 0x0B, 0xFC, 0x78, 0x2A, 0xFE, 0x16, 0x06, 0xA0, 0xB0, 0x16, 0x0C, 0xA0, 0xE0, 0x76,
  0x0A, 0xB0, 0xD0, 0x45, 0x04, 0x0D, 0xB0, 0x76, 0x06, 0x0E, 0xA0, 0x56, 0x03, 0xA0, 0xC7, 0x0A,
  0xA7, 0x09, 0xA0, 0x50, 0x14, 0x89, 0x11, 0xEF, 0xDB, 0xFA, 0x75, 0x7D, 0xA0, 0x70, 0xBF, 0x89,
  0x0B, 0x02, 0x8C, 0xEF, 0xEB, 0x62,
  // "t" (U+0074)
  0x38, 0x1C, 0xF1, 0x68, 0x1E, 0xF1, 0x50, 0x2A, 0x01, 0x50, 0x6A, 0x01, 0x38, 0x11, 0x8E, 0xD0,
  0x80, 0x7F, 0x82, 0x82, 0x5B, 0xA8, 0x26, 0x55, 0x32, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09,
  0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0,
  0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x08, 0xA0, 0x45, 0x04, 0xA8, 0x2D,
  0x65, 0x63, 0x0C, 0xC0, 0xB3, 0x84, 0x19, 0xEF, 0xD7,
  // "u" (U+0075)
  0x81, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC,
  0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF,
  0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6,
  0x84, 0xDF, 0xDC, 0xFD, 0x68, 0x4E, 0xFD, 0xCF, 0xE5, 0x01, 0xA0, 0xD0, 0xAA, 0x01, 0x40, 0x6A,
  0x0D, 0x07, 0xA0, 0x73, 0x01, 0x0D, 0xA0, 0xD0, 0x1B, 0x89, 0x08, 0x57, 0xDF, 0xBF, 0xD0, 0x7E,
  0x82, 0x67, 0xFD, 0x28, 0x90, 0x5C, 0xEE, 0xB4, 0x05, 0xFD,
  // "v" (U+0076)
  0x81, 0xBF, 0xE7, 0x82, 0xCF, 0xE7, 0xA0, 0x35, 0x01, 0xA0, 0xA0, 0x3A, 0x07, 0x50, 0x5A, 0x83,
  0x60, 0xEF, 0xB5, 0x09, 0xA8, 0x31, 0x0A, 0xFE, 0x58, 0x1D, 0xFC, 0x20, 0x6A, 0x03, 0x30, 0x1A,
  0x08, 0x20, 0x1A, 0x07, 0x30, 0x5A, 0x04, 0x38, 0x1D, 0xFB, 0x38, 0x19, 0xFE, 0x40, 0x8A, 0x38,
  0x1D, 0xFB, 0x40, 0x4A, 0x81, 0x40, 0x1A, 0x06, 0x5A, 0x81, 0x80, 0x5A, 0x02, 0x58, 0x5B, 0xFB,
  0x09, 0xFD, 0x60, 0x7A, 0x18, 0x1D, 0xF9, 0x60, 0x2A, 0x04, 0xA0, 0x47, 0x81, 0xDF, 0xAA, 0x71,
  0x09, 0xB0, 0xB7, 0x10, 0x5B, 0x07, 0x71, 0x01, 0xB0, 0x34,
  // "w" (U+0077)
  0x09, 0xA0, 0x15, 0xB0, 0x25, 0x82, 0xEF, 0xA5, 0xA0, 0x54, 0x03, 0xB0, 0x54, 0x02, 0xA0, 0x70,
  0x2A, 0x08, 0x40, 0x7B, 0x09, 0x40, 0x6A, 0x83, 0x30, 0xEF, 0xB4, 0x83, 0xBF, 0xCF, 0xC4, 0x09,
  0xA2, 0x81, 0xAF, 0xE4, 0x81, 0xEF, 0x7A, 0x48, 0x1C, 0xFB, 0x20, 0x7A, 0x02, 0x20, 0x2A, 0x02,
  0xA0, 0x33, 0xA0, 0x82, 0x03, 0xA0, 0x52, 0x85, 0x6F, 0xE0, 0xCF, 0x72, 0x03, 0xA0, 0x43, 0xA0,
  0x82, 0x85, 0x9F, 0xA0, 0x9F, 0xA2, 0x06, 0xA0, 0x13, 0x81, 0xCF, 0xC2, 0x85, 0xDF, 0x70, 0x6F,
  0xE2, 0x81, 0xAF, 0xD4, 0x09, 0xA1, 0x01, 0xA8, 0x13, 0x02, 0xA8, 0x32, 0x0D, 0xF9, 0x40, 0x5A,
  0x02, 0x04, 0xA3, 0x82, 0xEF, 0x51, 0xA0, 0x64, 0x02, 0xA8, 0x25, 0x7F, 0xC3, 0x82, 0xBF, 0x93,
  0xA0, 0x25, 0x84, 0xEF, 0x8A, 0xF8, 0x38, 0x48, 0xFB, 0x6F, 0xE6, 0x84, 0xBF, 0xAC, 0xF5, 0x38,
  0x45, 0xFE, 0x9F, 0xB6, 0x81, 0x7F, 0xDA, 0x01, 0x30, 0x1A, 0x81, 0xDF, 0x76, 0x04, 0xB0, 0xD5,
  0x0E, 0xB0, 0x47, 0xB0, 0xA5, 0x0A, 0xB7, 0x10, 0xCA, 0x06, 0x50, 0x7A, 0x0C, 0x40,
  // "x" (U+0078)
  0x18, 0x1E, 0xFD, 0x50, 0x5A, 0x81, 0x70, 0x7A, 0x05, 0x48, 0x2C, 0xFE, 0x12, 0x81, 0xEF, 0xC3,
  0x04, 0xA0, 0x73, 0x07, 0xA0, 0x42, 0x82, 0xBF, 0xE1, 0x48, 0x3E, 0xFB, 0x03, 0xA0, 0x75, 0x07,
  0xA8, 0x23, 0xAF, 0xE7, 0x81, 0xEF, 0xCA, 0x07, 0x70, 0x6B, 0x0E, 0x72, 0x0E, 0xA0, 0x77, 0x10,
  0x3B, 0x09, 0x71, 0x0A, 0xC0, 0x16, 0x03, 0xA8, 0x28, 0xEF, 0x96, 0x83, 0xBF, 0xE0, 0x8A, 0x02,
  0x40, 0x3A, 0x81, 0x70, 0x1A, 0x09, 0x48, 0x2B, 0xFE, 0x12, 0x09, 0xA0, 0x22, 0x03, 0xA0, 0x83,
  0x02, 0xA0, 0xA2, 0x82, 0xBF, 0xE1, 0x40, 0xAA, 0x02, 0x04, 0xA0, 0x85, 0x02, 0xA0, 0xA0,
  // "y" (U+0079)
  0x0B, 0xA7, 0x82, 0xCF, 0xE7, 0xA0, 0x46, 0xA0, 0xA0, 0x2A, 0x08, 0x50, 0x4A, 0x83, 0x60, 0xDF,
  0xC5, 0x08, 0xA8, 0x11, 0x09, 0xA0, 0x14, 0x81, 0xCF, 0xC2, 0x04, 0xA0, 0x53, 0x01, 0xA0, 0x83,
  0xA0, 0x93, 0x05, 0xA0, 0x43, 0x81, 0xBF, 0xD3, 0x81, 0x9F, 0xE4, 0x06, 0xA0, 0x22, 0x81, 0xDF,
  0xB4, 0x02, 0xA8, 0x16, 0x01, 0xA0, 0x65, 0x83, 0xDF, 0xA0, 0x5A, 0x02, 0x58, 0x58, 0xFE, 0x09,
  0xFD, 0x60, 0x4A, 0x82, 0x2D, 0xF9, 0x78, 0x1E, 0xF6, 0xA0, 0x47, 0x81, 0xAF, 0xDA, 0x71, 0x06,
  0xB0, 0xB7, 0x10, 0x1B, 0x07, 0x72, 0x0C, 0xA0, 0x37, 0x28, 0x1C, 0xFE, 0x72, 0x01, 0xA0, 0x97,
  0x20, 0x5A, 0x05, 0x72, 0x0B, 0xA7, 0x20, 0x3A, 0x0A, 0x68, 0x24, 0x57, 0xEA, 0x02, 0x60, 0x9C,
  0x07, 0x78, 0x37, 0xEF, 0xC5, 0x71,
  // "z" (U+007A)
  0x10, 0xAF, 0x98, 0x13, 0x0A, 0xF9, 0x81, 0x30, 0x38, 0x01, 0x58, 0x2E, 0xFE, 0x16, 0x03, 0xA0,
  0x87, 0x0A, 0xA0, 0x16, 0x02, 0xA0, 0x97, 0x09, 0xA0, 0x26, 0x01, 0xA0, 0xA7, 0x08, 0xA0, 0x36,
  0x82, 0x1E, 0xFB, 0x70, 0x7A, 0x04, 0x78, 0x1E, 0xFC, 0x70, 0x6A, 0x05, 0x78, 0x1D, 0xFD, 0x70,
  0x5A, 0x06, 0x70, 0xCA, 0x06, 0x80, 0x15, 0x02, 0x01, 0xFA, 0x07, 0x01, 0xFA, 0x07,
  // "{" (U+007B)
  0x58, 0x31, 0x8C, 0xE7, 0x40, 0x20, 0xEB, 0x07, 0x40, 0xCA, 0x81, 0xC7, 0x33, 0x03, 0xA0, 0xB6,
  0x05, 0xA0, 0x56, 0x06, 0xA0, 0x36, 0x06, 0xA0, 0x36, 0x06, 0xA0, 0x36, 0x06, 0xA0, 0x36, 0x06,
  0xA0, 0x36, 0x06, 0xA0, 0x26, 0x0A, 0xA0, 0x14, 0x02, 0x08, 0xA0, 0xA4, 0x0C, 0xA0, 0xE0, 0x95,
  0x0C, 0xA0, 0x90, 0x35, 0x81, 0x47, 0xDA, 0x05, 0x68, 0x21, 0xEF, 0xD7, 0x08, 0xA0, 0x16, 0x06,
  0xA0, 0x36, 0x06, 0xA0, 0x36, 0x06, 0xA0, 0x36, 0x06, 0xA0, 0x36, 0x06, 0xA0, 0x36, 0x06, 0xA0,
  0x36, 0x05, 0xA0, 0x56, 0x02, 0xA0, 0xC7, 0x0C, 0xA8, 0x1C, 0x73, 0x40, 0x20, 0xEB, 0x07, 0x58,
  0x31, 0x7C, 0xE7,
  // "|" (U+007C)
  0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0,
  0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A,
  0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06,
  0xA0, 0x60,
  // "}" (U+007D)
  0x82, 0xBE, 0xB6, 0x60, 0xCB, 0x0B, 0x58, 0x14, 0x8E, 0xA0, 0x86, 0x82, 0x1E, 0xFE, 0x70, 0x9A,
  0x01, 0x60, 0x7A, 0x01, 0x60, 0x7A, 0x01, 0x60, 0x7A, 0x01, 0x60, 0x7A, 0x01, 0x60, 0x7A, 0x01,
  0x60, 0x6A, 0x03, 0x60, 0x4A, 0x07, 0x78, 0x3D, 0xFE, 0x51, 0x50, 0x20, 0xBB, 0x08, 0x50, 0x40,
  0xCA, 0x08, 0x40, 0x8A, 0x81, 0xB7, 0x33, 0x02, 0xA0, 0x96, 0x05, 0xA0, 0x36, 0x07, 0xA0, 0x16,
  0x07, 0xA0, 0x16, 0x07, 0xA0, 0x16, 0x07, 0xA0, 0x16, 0x07, 0xA0, 0x16, 0x07, 0xA0, 0x16, 0x09,
  0xA6, 0x82, 0x1E, 0xFD, 0x48, 0x14, 0x8E, 0xA0, 0x74, 0x0C, 0xB0, 0xB5, 0x82, 0xBE, 0xB5, 0x60,
  // "~" (U+007E)
  0x28, 0x13, 0x53, 0x71, 0x01, 0x0C, 0xB8, 0x1D, 0x71, 0x38, 0x11, 0xBC, 0xE8, 0x92, 0xE9, 0x67,
  0xEF, 0xDB, 0x30, 0x3A, 0xE0, 0xB0, 0x75, 0x84, 0x28, 0xDE, 0xD8, 0x10,
  // "¡" (U+00A1)
  0x83, 0x5E, 0xD3, 0xCA, 0x0A, 0x0C, 0xA8, 0x3A, 0x5E, 0xD3, 0x75, 0x89, 0x31, 0xFD, 0x01, 0xFE,
  0x02, 0xFE, 0x03, 0xA1, 0x03, 0xA1, 0x04, 0xA0, 0x10, 0x5A, 0x01, 0x05, 0xA0, 0x20, 0x6A, 0x02,
  0x06, 0xA0, 0x30, 0x7A, 0x03, 0x08, 0xA0, 0x40, 0x8A, 0x05, 0x09, 0xA0, 0x50, 0x9A, 0x06, 0x0A,
  0xA0, 0x60, 0xBA, 0x07,
  // "¢" (U+00A2)
  0x58, 0x16, 0xF7, 0x71, 0x81, 0x6F, 0x77, 0x18, 0x28, 0xFA, 0x35, 0x07, 0x0E, 0xC0, 0xE0, 0x52,
  0x09, 0xF8, 0x14, 0x04, 0xA8, 0x4E, 0x51, 0x03, 0x92, 0x0B, 0xA0, 0x36, 0x01, 0xA0, 0xB7, 0x03,
  0xA0, 0x77, 0x05, 0xA0, 0x57, 0x06, 0xA0, 0x47, 0x07, 0xA0, 0x47, 0x06, 0xA0, 0x57, 0x04, 0xA0,
  0x77, 0x02, 0xA0, 0xB7, 0x10, 0xDA, 0x03, 0x70, 0x7A, 0x0E, 0x05, 0x28, 0x12, 0x74, 0x20, 0xCF,
  0x06, 0x20, 0x10, 0xBD, 0x0E, 0x04, 0x48, 0x33, 0xAF, 0xB5, 0x78, 0x16, 0xF6, 0x71, 0x81, 0x6F,
  0x67, 0x18, 0x16, 0xF6, 0x30,
  // "£" (U+00A3)
  0x58, 0x57, 0xCE, 0xFD, 0x93, 0x50, 0xCF, 0x05, 0x30, 0x8A, 0x85, 0xD7, 0x68, 0xDE, 0x13, 0x82,
  0xEF, 0xE1, 0x40, 0x33, 0x02, 0xA0, 0x97, 0x20, 0x3A, 0x08, 0x72, 0x03, 0xA0, 0x77, 0x20, 0x3A,
  0x07, 0x72, 0x03, 0xA0, 0x77, 0x20, 0x3A, 0x07, 0x70, 0xCF, 0xA0, 0x32, 0x0C, 0xFA, 0x03, 0x28,
  0x14, 0x57, 0xA8, 0x4A, 0x55, 0x55, 0x14, 0x03, 0xA0, 0x77, 0x20, 0x3A, 0x07, 0x72, 0x03, 0xA0,
  0x77, 0x20, 0x3A, 0x07, 0x72, 0x05, 0xA0, 0x57, 0x20, 0x9A, 0x01, 0x71, 0x82, 0x2E, 0xF8, 0x71,
  0x82, 0x4D, 0xFD, 0x80, 0x45, 0x04, 0x0B, 0xFC, 0x0D, 0x0B, 0xFC, 0x0D,
  // "¤" (U+00A4)
  0x03, 0x07, 0x73, 0x89, 0x79, 0x1E, 0xF5, 0x05, 0xCE, 0xEB, 0x30, 0x9F, 0xB7, 0xA0, 0xBE, 0x0B,
  0xA8, 0x14, 0x0A, 0xB8, 0x29, 0x66, 0xBB, 0x07, 0x28, 0x25, 0xFD, 0x24, 0x82, 0x4E, 0xF3, 0x28,
  0x1D, 0xF3, 0x68, 0x56, 0xFA, 0x02, 0xFC, 0x71, 0x84, 0xEE, 0x04, 0xFA, 0x71, 0x84, 0xCF, 0x13,
  0xFB, 0x71, 0x0D, 0x92, 0x90, 0xE0, 0x16, 0x81, 0x3F, 0xD2, 0x81, 0x9F, 0xA6, 0x81, 0xCF, 0x62,
  0x05, 0xA8, 0x4B, 0x30, 0x15, 0xDA, 0x82, 0x20, 0x2E, 0xFB, 0x85, 0xD1, 0xDF, 0xB3, 0xCC, 0x85,
  0x92, 0xDF, 0xB7, 0xC3, 0x82, 0x25, 0x41, 0x28, 0x12, 0xE5, 0x75, 0x01, 0x10,
  // "¥" (U+00A5)
  0x81, 0xDF, 0xE7, 0x82, 0xDF, 0xD7, 0xA0, 0x45, 0x03, 0xA0, 0x70, 0x2A, 0x09, 0x50, 0x9A, 0x83,
  0x10, 0xBF, 0xE5, 0x81, 0xEF, 0xB2, 0x05, 0xA0, 0x43, 0x04, 0xA0, 0x53, 0x81, 0xEF, 0xA3, 0x81,
  0x9F, 0xE4, 0x81, 0x9F, 0xE3, 0x81, 0xEF, 0x94, 0x03, 0xA8, 0x15, 0x05, 0xA0, 0x35, 0x85, 0xDF,
  0xA0, 0xAF, 0xC6, 0x07, 0xA8, 0x21, 0xEF, 0x66, 0x01, 0xA0, 0xBA, 0x01, 0x70, 0xAB, 0x0A, 0x50,
  0xCF, 0xA0, 0xC2, 0x0C, 0xFA, 0x0C, 0x68, 0x1D, 0xFD, 0x73, 0x81, 0xDF, 0xD6, 0x89, 0x14, 0x55,
  0x5E, 0xFE, 0x55, 0x54, 0x20, 0xCF, 0xA0, 0xC2, 0x0C, 0xFA, 0x0C, 0x68, 0x1D, 0xFD, 0x73, 0x81,
  0xDF, 0xD7, 0x38, 0x1D, 0xFD, 0x73, 0x81, 0xDF, 0xD5,
  // "¦" (U+00A6)
  0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0,
  0x6A, 0x06, 0xA0, 0x67, 0x77, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A,
  0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x6A, 0x06, 0xA0, 0x60,
  // "§" (U+00A7)
  0x28, 0x61, 0x8D, 0xFE, 0xD8, 0x22, 0x02, 0x0E, 0xF8, 0x11, 0x0C, 0xA8, 0x69, 0x66, 0x9E, 0xC0,
  0x1A, 0x07, 0x48, 0x21, 0x30, 0x3A, 0x03, 0x70, 0x1A, 0x07, 0x71, 0x0B, 0xA0, 0x77, 0x02, 0x0E,
  0xA0, 0xD0, 0x56, 0x07, 0xC0, 0xC0, 0x23, 0x83, 0x7F, 0xE7, 0xCA, 0x82, 0xE4, 0x02, 0xA0, 0x32,
  0x86, 0x5E, 0xFE, 0x16, 0xFD, 0x40, 0x3A, 0x82, 0x66, 0xFE, 0x58, 0x2C, 0xF7, 0x3A, 0x08, 0x48,
  0x3C, 0xF6, 0x0B, 0xA8, 0x2A, 0x20, 0x3A, 0x01, 0x20, 0xAB, 0x82, 0xAE, 0xF8, 0x40, 0x50, 0xDB,
  0x0B, 0x70, 0x60, 0xEA, 0x06, 0x70, 0x10, 0xBA, 0x01, 0x70, 0x1A, 0x05, 0x71, 0xA8, 0x16, 0x42,
  0x50, 0x6A, 0x86, 0x48, 0xFB, 0x76, 0x6A, 0xA8, 0x1D, 0x07, 0xF0, 0xE0, 0x32, 0x86, 0x5B, 0xEF,
  0xEC, 0x81, 0x20,
  // "¨" (U+00A8)
  0x82, 0x2E, 0xC1, 0x28, 0x2A, 0xE6, 0x6A, 0x03, 0x2A, 0x82, 0xB2, 0xDC, 0x38, 0x1A, 0xE5,
  // "©" (U+00A9)
  0x73, 0x83, 0x34, 0x53, 0x27, 0x72, 0x05, 0x0B, 0xE8, 0x1D, 0x82, 0x74, 0x04, 0x0C, 0xFC, 0x09,
  0x72, 0x06, 0xB8, 0x1A, 0x52, 0x28, 0x21, 0x37, 0xDA, 0x0C, 0x01, 0x60, 0x7A, 0x0C, 0x02, 0x72,
  0x06, 0xA0, 0xD0, 0x14, 0x04, 0xA0, 0x95, 0x82, 0x35, 0x42, 0x38, 0x23, 0xDF, 0xB4, 0x81, 0xDF,
  0xA4, 0x07, 0x0E, 0xC0, 0xD0, 0x62, 0x82, 0x2E, 0xF6, 0x28, 0x15, 0xFD, 0x40, 0xAF, 0x08, 0x38,
  0x16, 0xFD, 0x28, 0x1B, 0xF5, 0x30, 0x6A, 0x85, 0xB3, 0x01, 0x39, 0x24, 0x84, 0xCF, 0x40, 0xFE,
  0x48, 0x1E, 0xFB, 0x74, 0x84, 0x6F, 0x84, 0xF9, 0x30, 0x4A, 0x03, 0x74, 0x84, 0x1F, 0xC5, 0xF6,
  0x38, 0x17, 0xFE, 0x76, 0x83, 0xEE, 0x6F, 0x53, 0x81, 0x8F, 0xC7, 0x68, 0x3C, 0xF6, 0xF5, 0x38,
  0x18, 0xFC, 0x76, 0x83, 0xCF, 0x5F, 0x63, 0x81, 0x7F, 0xE7, 0x68, 0x3D, 0xD3, 0xF9, 0x30, 0x4A,
  0x02, 0x74, 0x84, 0x1F, 0xB0, 0xED, 0x48, 0x1E, 0xFA, 0x74, 0x85, 0x5F, 0x70, 0x9F, 0x43, 0x08,
  0xA8, 0x5A, 0x30, 0x13, 0x73, 0x48, 0x5B, 0xF2, 0x02, 0xFC, 0x40, 0xCF, 0x04, 0x38, 0x14, 0xFB,
  0x38, 0x1A, 0xF8, 0x40, 0x8D, 0x0B, 0x02, 0x28, 0x21, 0xEF, 0x33, 0x82, 0x1D, 0xF6, 0x58, 0x23,
  0x54, 0x13, 0x82, 0x1C, 0xF8, 0x58, 0x23, 0xEF, 0xA7, 0x38, 0x24, 0xEF, 0xA7, 0x84, 0x2D, 0xFE,
  0x83, 0x48, 0x11, 0x5B, 0xA0, 0x87, 0x30, 0x8C, 0x81, 0xDD, 0xEB, 0x0C, 0x04, 0x75, 0x89, 0x01,
  0x5A, 0xDE, 0xFD, 0xC8, 0x37,
  // "ª" (U+00AA)
  0x89, 0x61, 0x8C, 0xEE, 0xB4, 0x01, 0xD9, 0x67, 0xEF, 0x25, 0x81, 0x7F, 0x73, 0x86, 0x11, 0x6F,
  0x90, 0x9E, 0xC8, 0x79, 0xBF, 0xC6, 0x47, 0xF9, 0xA0, 0x12, 0x83, 0x6F, 0x9F, 0xE3, 0x86, 0xAF,
  0x9C, 0xF6, 0x27, 0xA8, 0x19, 0x3E, 0xA8, 0x2D, 0x3F, 0x92, 0x03, 0x02, 0x20, 0x30, 0x20,
  // "«" (U+00AB)
  0x48, 0x15, 0xA2, 0x38, 0x12, 0xB3, 0x38, 0x22, 0xEF, 0x82, 0x82, 0x1D, 0xFB, 0x38, 0x1C, 0xFD,
  0x38, 0x2B, 0xFE, 0x12, 0x0A, 0xA0, 0x32, 0x07, 0xA0, 0x52, 0x06, 0xA0, 0x82, 0x04, 0xA0, 0xB2,
  0x03, 0xA0, 0xC2, 0x83, 0x1E, 0xFE, 0x12, 0x0C, 0xA0, 0x52, 0x09, 0xA0, 0x73, 0x04, 0xA0, 0xC2,
  0x83, 0x2E, 0xFE, 0x13, 0x07, 0xA0, 0x72, 0x05, 0xA0, 0xA4, 0x0B, 0xA0, 0x32, 0x09, 0xA0, 0x53,
  0x82, 0x1D, 0xFC, 0x38, 0x2C, 0xFE, 0x13, 0x03, 0xA0, 0x82, 0x82, 0x1E, 0xFA, 0x48, 0x16, 0xB3,
  0x38, 0x13, 0xC4,
  // "¬" (U+00AC)
  0x04, 0x80, 0x75, 0x04, 0x0D, 0xFC, 0x0B, 0x0D, 0xFC, 0x0B, 0x73, 0x81, 0x7F, 0xB7, 0x38, 0x17,
  0xFB, 0x73, 0x81, 0x7F, 0xB7, 0x38, 0x17, 0xFB, 0x73, 0x81, 0x7F, 0xB7, 0x38, 0x17, 0xFB, 0x73,
  0x81, 0x37, 0x50,
  // "®" (U+00AE)
  0x73, 0x83, 0x34, 0x53, 0x27, 0x72, 0x05, 0x0B, 0xE8, 0x1D, 0x82, 0x74, 0x04, 0x0C, 0xFC, 0x09,
  0x72, 0x06, 0xB8, 0x1A, 0x52, 0x28, 0x21, 0x37, 0xDA, 0x0C, 0x01, 0x60, 0x7A, 0x0C, 0x02, 0x72,
  0x06, 0xA0, 0xD0, 0x14, 0x04, 0xA0, 0x92, 0x80, 0x15, 0x03, 0x48, 0x23, 0xDF, 0xB4, 0x81, 0xDF,
  0xA3, 0xE0, 0xE0, 0x63, 0x82, 0x2E, 0xF6, 0x28, 0x15, 0xFD, 0x4F, 0x90, 0x53, 0x81, 0x6F, 0xD2,
  0x81, 0xBF, 0x54, 0xA8, 0x55, 0x01, 0x5E, 0xFB, 0x48, 0x4C, 0xF4, 0x0F, 0xE5, 0xA0, 0x53, 0x81,
  0x9F, 0xD4, 0x84, 0x6F, 0x84, 0xF9, 0x5A, 0x05, 0x38, 0x1B, 0xFC, 0x48, 0x41, 0xFC, 0x5F, 0x65,
  0xA8, 0x28, 0x56, 0xBA, 0x06, 0x58, 0x3E, 0xE6, 0xF5, 0x5F, 0x0A, 0x68, 0x3C, 0xF6, 0xF5, 0x5E,
  0x0B, 0x78, 0x3C, 0xF5, 0xF6, 0x5A, 0x81, 0x50, 0x5A, 0x02, 0x68, 0x3D, 0xD3, 0xF9, 0x5A, 0x05,
  0x28, 0x1C, 0xFA, 0x58, 0x41, 0xFB, 0x0E, 0xD5, 0xA0, 0x52, 0x05, 0xA0, 0x24, 0x85, 0x5F, 0x70,
  0x9F, 0x44, 0xA0, 0x53, 0x81, 0xDF, 0xA4, 0x85, 0xBF, 0x20, 0x2F, 0xC4, 0xA0, 0x53, 0x06, 0xA0,
  0x22, 0x81, 0x4F, 0xB3, 0x81, 0xAF, 0x83, 0x81, 0xBC, 0x34, 0x86, 0xBC, 0x70, 0x1E, 0xF3, 0x38,
  0x21, 0xDF, 0x67, 0x58, 0x21, 0xCF, 0x85, 0x82, 0x3E, 0xFA, 0x73, 0x82, 0x4E, 0xFA, 0x78, 0x42,
  0xDF, 0xE8, 0x34, 0x81, 0x15, 0xBA, 0x08, 0x73, 0x08, 0xC8, 0x1D, 0xDE, 0xB0, 0xC0, 0x47, 0x58,
  0x90, 0x15, 0xAD, 0xEF, 0xDC, 0x83, 0x70,
  // "¯" (U+00AF)
  0x18, 0x09, 0x25, 0x03, 0x01, 0xFF, 0x0A, 0x01, 0xFF, 0x0A,
  // "°" (U+00B0)
  0x38, 0x21, 0x45, 0x25, 0x09, 0xC0, 0xB0, 0x12, 0x09, 0xE8, 0x1D, 0x02, 0xA8, 0x90, 0x71, 0x04,
  0xEF, 0x66, 0xFA, 0x48, 0x45, 0xFA, 0x6F, 0x74, 0x84, 0x3F, 0xB5, 0xFC, 0x48, 0x90, 0x8F, 0x91,
  0xEF, 0xC6, 0x6A, 0xA8, 0x14, 0x05, 0xE0, 0x93, 0x84, 0x4B, 0xEF, 0xC6, 0x20,
  // "±" (U+00B1)
  0x58, 0x18, 0xFA, 0x73, 0x81, 0x8F, 0xA7, 0x38, 0x18, 0xFA, 0x73, 0x81, 0x8F, 0xA7, 0x38, 0x18,
  0xFA, 0x73, 0x81, 0x8F, 0xA5, 0x86, 0x45, 0x55, 0x5B, 0xFC, 0x80, 0x15, 0x0D, 0xFC, 0x0E, 0x0D,
  0xFC, 0x0E, 0x58, 0x18, 0xFA, 0x73, 0x81, 0x8F, 0xA7, 0x38, 0x18, 0xFA, 0x73, 0x81, 0x8F, 0xA7,
  0x38, 0x18, 0xFA, 0x73, 0x81, 0x8F, 0xA7, 0x38, 0x18, 0xFA, 0x77, 0x40, 0x48, 0x09, 0x05, 0x0D,
  0xFC, 0x0E, 0x0D, 0xFC, 0x0E,
  // "²" (U+00B2)
  0x28, 0x46, 0xCE, 0xEB, 0x32, 0x0B, 0xA0, 0xEA, 0x89, 0x1E, 0x20, 0xAC, 0x20, 0x1C, 0xFA, 0x68,
  0x16, 0xFC, 0x68, 0x17, 0xFB, 0x68, 0x1B, 0xF7, 0x58, 0x24, 0xFE, 0x14, 0x82, 0x2E, 0xF5, 0x48,
  0x21, 0xDF, 0x75, 0x81, 0xBF, 0x95, 0x81, 0xAF, 0xB5, 0x81, 0x8F, 0xC5, 0x02, 0xA0, 0xE8, 0x01,
  0xD0, 0x3F, 0x90,
  // "³" (U+00B3)
  0x18, 0x51, 0x8D, 0xFD, 0xA2, 0x20, 0x10, 0xEA, 0x0E, 0xA0, 0xE0, 0x22, 0x86, 0x99, 0x10, 0x1C,
  0xF9, 0x78, 0x15, 0xFB, 0x78, 0x17, 0xF9, 0x58, 0x31, 0x5E, 0xF3, 0x30, 0x4B, 0x0D, 0x03, 0x48,
  0x13, 0xDE, 0xA0, 0xB0, 0x16, 0x82, 0x1A, 0xFB, 0x70, 0x1A, 0x01, 0x7A, 0x82, 0x22, 0x82, 0x28,
  0x41, 0x9F, 0xE0, 0x3B, 0x0E, 0xB0, 0x52, 0x85, 0x7B, 0xEF, 0xEA, 0x32,
  // "´" (U+00B4)
  0x30, 0xF7, 0x02, 0x20, 0x5A, 0x0D, 0x01, 0x20, 0xDA, 0x03, 0x20, 0x6A, 0x06, 0x28, 0x21, 0xEF,
  0x83, 0x81, 0x9F, 0x84,
  // "µ" (U+00B5)
  0x81, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE,
  0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF,
  0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4B, 0xFE, 0xBF, 0xE6,
  0x84, 0xBF, 0xEB, 0xFE, 0x68, 0x2D, 0xFE, 0xBA, 0x6A, 0x0E, 0x0B, 0xA0, 0x24, 0x05, 0xA0, 0xE0,
  0xBA, 0x08, 0x40, 0xCA, 0x0E, 0x0B, 0xB8, 0x91, 0x95, 0x7D, 0xFB, 0xFE, 0xBF, 0xED, 0x8A, 0x18,
  0x5F, 0xEB, 0xFD, 0x4C, 0xFD, 0x60, 0x3F, 0xEB, 0xFD, 0x72, 0x81, 0xBF, 0xE7, 0x28, 0x1B, 0xFE,
  0x72, 0x81, 0xBF, 0xE7, 0x28, 0x1B, 0xFE, 0x72, 0x81, 0xBF, 0xE7, 0x28, 0x1B, 0xFE, 0x72, 0x81,
  0xBF, 0xE7, 0x20,
  // "¶" (U+00B6)
  0x38, 0x13, 0xBE, 0xF0, 0x32, 0x05, 0xFB, 0x03, 0x20, 0xEE, 0x85, 0x55, 0xBF, 0x30, 0x6E, 0x0E,
  0x28, 0x39, 0xF3, 0x0B, 0xE0, 0xE2, 0x83, 0x9F, 0x30, 0xDE, 0x0E, 0x28, 0x19, 0xF3, 0x1F, 0x0E,
  0x28, 0x29, 0xF3, 0x1F, 0x0E, 0x28, 0x29, 0xF3, 0x1F, 0x0E, 0x28, 0x29, 0xF3, 0x1F, 0x0E, 0x28,
  0x19, 0xF3, 0x1F, 0x0E, 0x28, 0x39, 0xF3, 0x0E, 0xE0, 0xE2, 0x83, 0x9F, 0x30, 0xBE, 0x0E, 0x28,
  0x39, 0xF3, 0x07, 0xE0, 0xE2, 0x83, 0x9F, 0x30, 0x1E, 0x0E, 0x28, 0x19, 0xF3, 0x20, 0x7D, 0x0E,
  0x28, 0x19, 0xF3, 0x38, 0x45, 0xBD, 0xCF, 0xE2, 0x81, 0x9F, 0x37, 0x00, 0xE2, 0x81, 0x9F, 0x37,
  0x00, 0xE2, 0x81, 0x9F, 0x37, 0x00, 0xE2, 0x81, 0x9F, 0x37, 0x00, 0xE2, 0x81, 0x9F, 0x37, 0x00,
  0xE2, 0x81, 0x9F, 0x37, 0x00, 0xE2, 0x81, 0x9F, 0x37, 0x00, 0xE2, 0x81, 0x9F, 0x37, 0x00, 0xE2,
  0x81, 0x9F, 0x37, 0x00, 0xE2, 0x81, 0x9F, 0x37, 0x00, 0xE2, 0x81, 0x9F, 0x37, 0x00, 0xE2, 0x81,
  0x9F, 0x37, 0x00, 0xE2, 0x81, 0x9F, 0x37, 0x0B, 0x0C, 0x28, 0x17, 0xD3,
  // "·" (U+00B7)
  0x83, 0x6E, 0xD2, 0xEA, 0x08, 0x0E, 0xA8, 0x38, 0x6E, 0xD2,
  // "¸" (U+00B8)
  0x20, 0xA0, 0xE4, 0x82, 0x2F, 0xB1, 0x38, 0x34, 0xBF, 0xE4, 0x48, 0x14, 0xFE, 0x40, 0x1A, 0x83,
  0x14, 0x56, 0xCA, 0x10, 0x9C, 0x85, 0x80, 0x8E, 0xEC, 0x62,
  // "¹" (U+00B9)
  0x30, 0x6A, 0x02, 0x20, 0x9B, 0x89, 0x72, 0x1C, 0xFD, 0xEF, 0x28, 0xFB, 0x1E, 0xF2, 0x06, 0x28,
  0x1E, 0xF2, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02, 0x4A, 0x02,
  0x4A, 0x02, 0x4A, 0x02,
  // "º" (U+00BA)
  0x18, 0x41, 0x9E, 0xFD, 0x72, 0x89, 0x21, 0xDF, 0x97, 0xCF, 0x90, 0x8F, 0x83, 0x84, 0xDF, 0x3D,
  0xF3, 0x38, 0x18, 0xF7, 0xA0, 0x13, 0x81, 0x6F, 0x9A, 0x48, 0x46, 0xF9, 0xDF, 0x23, 0x84, 0x7F,
  0x89, 0xF5, 0x38, 0x91, 0xBF, 0x42, 0xFE, 0x42, 0x8F, 0xC2, 0x04, 0x0D, 0xB0, 0xB0, 0x14, 0x81,
  0x34, 0x23,
  // "»" (U+00BB)
  0x81, 0x2A, 0x53, 0x81, 0x19, 0x74, 0x82, 0x7F, 0xE2, 0x20, 0x5A, 0x04, 0x48, 0x1C, 0xFD, 0x38,
  0x2A, 0xFE, 0x13, 0x03, 0xA0, 0xA2, 0x82, 0x1E, 0xFC, 0x40, 0x7A, 0x07, 0x20, 0x5A, 0x09, 0x40,
  0xCA, 0x04, 0x20, 0xAA, 0x06, 0x30, 0x4A, 0x0D, 0x20, 0x2A, 0x0E, 0x30, 0xCA, 0x05, 0x20, 0x9A,
  0x07, 0x20, 0x7A, 0x08, 0x20, 0x4A, 0x0A, 0x20, 0x2A, 0x0B, 0x28, 0x31, 0xEF, 0xD1, 0x28, 0x2C,
  0xFE, 0x12, 0x82, 0xAF, 0xE2, 0x20, 0x7A, 0x03, 0x20, 0x5A, 0x05, 0x38, 0x12, 0xB6, 0x38, 0x11,
  0xA9, 0x40,
  // "¼" (U+00BC)
  0x38, 0x1A, 0xFD, 0x72, 0x82, 0x3F, 0xE1, 0x40, 0x20, 0xCA, 0x0D, 0x72, 0x81, 0xBF, 0x84, 0x84,
  0x5E, 0xFB, 0xFD, 0x71, 0x81, 0x4F, 0xE5, 0x84, 0xBF, 0x73, 0xFD, 0x71, 0x81, 0xCF, 0x65, 0x84,
  0x13, 0x03, 0xFD, 0x78, 0x15, 0xFD, 0x72, 0x81, 0x4F, 0xD7, 0x81, 0xDF, 0x57, 0x28, 0x14, 0xFD,
  0x68, 0x16, 0xFC, 0x73, 0x81, 0x4F, 0xD6, 0x81, 0xEF, 0x47, 0x38, 0x14, 0xFD, 0x58, 0x18, 0xFB,
  0x74, 0x81, 0x4F, 0xD4, 0x82, 0x1E, 0xF3, 0x38, 0x17, 0xFE, 0x58, 0x14, 0xFD, 0x48, 0x19, 0xFA,
  0x30, 0x1A, 0x0E, 0x58, 0x14, 0xFD, 0x30, 0x2A, 0x02, 0x30, 0xAA, 0x0E, 0x58, 0x14, 0xFD, 0x38,
  0x1A, 0xF8, 0x38, 0x34, 0xFB, 0xFE, 0x58, 0x14, 0xFD, 0x28, 0x23, 0xFE, 0x13, 0x83, 0xCE, 0x4F,
  0xE7, 0x38, 0x1B, 0xF7, 0x38, 0x46, 0xF7, 0x2F, 0xE7, 0x28, 0x14, 0xFE, 0x38, 0x51, 0xED, 0x02,
  0xFE, 0x72, 0x81, 0xCF, 0x63, 0x85, 0x9F, 0x50, 0x2F, 0xE7, 0x18, 0x15, 0xFD, 0x38, 0x12, 0xFB,
  0x28, 0x12, 0xFE, 0x71, 0x81, 0xDF, 0x53, 0x81, 0xAF, 0xE0, 0xFD, 0xA0, 0xD0, 0x95, 0x81, 0x6F,
  0xC4, 0x0A, 0xF9, 0x0A, 0x58, 0x1E, 0xF3, 0x72, 0x81, 0x2F, 0xE6, 0x81, 0x8F, 0xB7, 0x38, 0x12,
  0xFE, 0x58, 0x21, 0xEF, 0x27, 0x38, 0x12, 0xFE, 0x20,
  // "½" (U+00BD)
  0x28, 0x21, 0xBF, 0xC7, 0x28, 0x1C, 0xF7, 0x50, 0x30, 0xDA, 0x0C, 0x71, 0x81, 0x5F, 0xD5, 0x05,
  0xA8, 0x1C, 0xFC, 0x71, 0x81, 0xDF, 0x65, 0x84, 0xDF, 0x64, 0xFC, 0x78, 0x16, 0xFD, 0x68, 0x42,
  0x30, 0x5F, 0xC7, 0x81, 0xEF, 0x57, 0x28, 0x15, 0xFC, 0x68, 0x17, 0xFC, 0x73, 0x81, 0x5F, 0xC5,
  0x82, 0x1E, 0xF3, 0x73, 0x81, 0x5F, 0xC5, 0x81, 0x9F, 0xA7, 0x48, 0x15, 0xFC, 0x40, 0x2A, 0x02,
  0x74, 0x81, 0x5F, 0xC4, 0x89, 0x1A, 0xF9, 0x01, 0x9D, 0xFD, 0x81, 0x48, 0x15, 0xFC, 0x30, 0x3A,
  0x81, 0x12, 0xED, 0x0C, 0x48, 0x15, 0xFC, 0x38, 0x90, 0xBF, 0x80, 0x1E, 0x81, 0x04, 0xA0, 0x53,
  0x81, 0x5F, 0xC2, 0x82, 0x4F, 0xE1, 0x20, 0x14, 0x81, 0xBF, 0x73, 0x81, 0x5F, 0xC2, 0x81, 0xCF,
  0x77, 0x18, 0x1B, 0xF6, 0x78, 0x15, 0xFD, 0x71, 0x01, 0xA0, 0x17, 0x81, 0xDF, 0x67, 0x18, 0x1B,
  0xF8, 0x78, 0x16, 0xFD, 0x71, 0x81, 0x8F, 0xB7, 0x18, 0x1E, 0xF4, 0x78, 0x27, 0xFC, 0x17, 0x81,
  0x7F, 0xB7, 0x82, 0x6F, 0xD1, 0x78, 0x21, 0xEF, 0x36, 0x82, 0x5F, 0xD1, 0x71, 0x81, 0x8F, 0xA6,
  0x04, 0xA8, 0x47, 0x55, 0x55, 0x33, 0x01, 0xA0, 0x26, 0x08, 0xF0, 0xA3, 0x81, 0x9F, 0x97, 0x08,
  0xF0, 0xA0,
  // "¾" (U+00BE)
  0x28, 0x46, 0xCE, 0xDA, 0x27, 0x28, 0x13, 0x87, 0x50, 0xBD, 0x0E, 0x02, 0x71, 0x81, 0xCF, 0x75,
  0x86, 0xDE, 0x86, 0x8E, 0xF9, 0x78, 0x15, 0xFE, 0x60, 0x20, 0x13, 0x81, 0x7F, 0xB7, 0x81, 0xCF,
  0x67, 0x48, 0x17, 0xF9, 0x68, 0x15, 0xFD, 0x74, 0x82, 0x4E, 0xF3, 0x68, 0x1D, 0xF5, 0x71, 0x04,
  0xB0, 0xE0, 0x56, 0x81, 0x6F, 0xC7, 0x20, 0x4B, 0x0E, 0x07, 0x68, 0x1E, 0xF4, 0x72, 0x85, 0x15,
  0x69, 0xEF, 0x84, 0x81, 0x7F, 0xC7, 0x70, 0x4A, 0x38, 0x21, 0xEF, 0x47, 0x71, 0xA0, 0x22, 0x81,
  0x8F, 0xB4, 0x81, 0xCF, 0x97, 0x10, 0x3A, 0x84, 0x10, 0x1E, 0xF3, 0x30, 0x6A, 0x09, 0x28, 0x73,
  0xE9, 0x76, 0x8E, 0xFC, 0x28, 0x19, 0xFA, 0x38, 0x31, 0xEE, 0xF9, 0x20, 0x3E, 0x82, 0xE3, 0x01,
  0xA0, 0x23, 0x83, 0x9E, 0x8F, 0x93, 0x85, 0x5B, 0xEF, 0xD9, 0x22, 0x81, 0x9F, 0x93, 0x84, 0x2F,
  0x77, 0xF9, 0x74, 0x02, 0xA0, 0x23, 0x84, 0xBE, 0x08, 0xF9, 0x74, 0x81, 0xAF, 0x93, 0x85, 0x5F,
  0x60, 0x8F, 0x97, 0x38, 0x23, 0xFE, 0x13, 0x00, 0xD2, 0x81, 0x8F, 0x97, 0x38, 0x1B, 0xF8, 0x38,
  0x17, 0xF5, 0x28, 0x18, 0xF9, 0x72, 0x82, 0x4F, 0xE1, 0x3A, 0x0F, 0xD8, 0x3E, 0xFE, 0xD4, 0x78,
  0x1C, 0xF7, 0x4F, 0xA0, 0x56, 0x81, 0x4F, 0xE7, 0x38, 0x18, 0xF9, 0x71, 0x81, 0xCF, 0x67, 0x38,
  0x18, 0xF9, 0x78, 0x15, 0xFD, 0x74, 0x81, 0x8F, 0x92,
  // "¿" (U+00BF)
  0x58, 0x1B, 0xE8, 0x70, 0x6B, 0x70, 0x6B, 0x78, 0x21, 0xCE, 0x87, 0x77, 0x72, 0x81, 0x47, 0x37,
  0x18, 0x1A, 0xF6, 0x71, 0x81, 0xCF, 0x57, 0x02, 0xA0, 0x37, 0x81, 0xCF, 0xD7, 0x09, 0xA0, 0x56,
  0x07, 0xA0, 0x96, 0x03, 0xA0, 0xB7, 0x82, 0xCF, 0xE1, 0x60, 0x3A, 0x07, 0x70, 0x7A, 0x02, 0x70,
  0x8A, 0x01, 0x70, 0x7A, 0x03, 0x70, 0x5A, 0x09, 0x40, 0x10, 0x52, 0x0E, 0xA8, 0x7A, 0x66, 0x9E,
  0xF2, 0x04, 0xF9, 0x05, 0x28, 0x62, 0x9D, 0xFE, 0xC8, 0x21,
  // "À" (U+00C0)
  0x38, 0x25, 0x77, 0x47, 0x50, 0x5A, 0x0E, 0x76, 0x09, 0xA0, 0x77, 0x68, 0x2B, 0xFE, 0x17, 0x68,
  0x1C, 0xF9, 0x76, 0x82, 0x1C, 0xF3, 0x80, 0xD0, 0x00, 0x9A, 0x0B, 0x75, 0x0D, 0xB7, 0x40, 0x2A,
  0x81, 0xEF, 0x47, 0x38, 0x46, 0xFD, 0xBF, 0x97, 0x38, 0x4B, 0xF9, 0x8F, 0xD7, 0x3A, 0x06, 0x04,
  0xA0, 0x27, 0x10, 0x4A, 0x02, 0x1A, 0x07, 0x71, 0x81, 0x9F, 0xE2, 0x81, 0xCF, 0xB7, 0x18, 0x1D,
  0xF9, 0x20, 0x7A, 0x70, 0x2A, 0x05, 0x20, 0x3A, 0x04, 0x60, 0x6A, 0x01, 0x38, 0x1E, 0xF9, 0x68,
  0x1B, 0xFD, 0x48, 0x1A, 0xFD, 0x6A, 0x08, 0x40, 0x6A, 0x02, 0x40, 0x4F, 0xB0, 0x74, 0x08, 0xFB,
  0x0B, 0x48, 0x1D, 0xFE, 0x80, 0x29, 0x0D, 0xA3, 0x02, 0xA0, 0x96, 0x06, 0xA0, 0x52, 0x06, 0xA0,
  0x56, 0x02, 0xA0, 0x92, 0x0B, 0xA0, 0x17, 0x81, 0xDF, 0xD2, 0xA0, 0xC7, 0x10, 0x9A, 0x02, 0x04,
  0xA0, 0x87, 0x10, 0x5A, 0x07, 0x08, 0xA0, 0x47, 0x10, 0x1A, 0x0B, 0x0D, 0xA7, 0x30, 0xCA,
  // "Á" (U+00C1)
  0x73, 0x0F, 0x70, 0x27, 0x40, 0x5A, 0x0D, 0x01, 0x74, 0x0D, 0xA0, 0x37, 0x40, 0x6A, 0x06, 0x74,
  0x82, 0x1E, 0xF8, 0x75, 0x81, 0x9F, 0x88, 0x0D, 0x00, 0x09, 0xA0, 0xB7, 0x50, 0xDB, 0x74, 0x02,
  0xA8, 0x1E, 0xF4, 0x73, 0x84, 0x6F, 0xDB, 0xF9, 0x73, 0x84, 0xBF, 0x98, 0xFD, 0x73, 0xA0, 0x60,
  0x4A, 0x02, 0x71, 0x04, 0xA0, 0x21, 0xA0, 0x77, 0x18, 0x19, 0xFE, 0x28, 0x1C, 0xFB, 0x71, 0x81,
  0xDF, 0x92, 0x07, 0xA7, 0x02, 0xA0, 0x52, 0x03, 0xA0, 0x46, 0x06, 0xA0, 0x13, 0x81, 0xEF, 0x96,
  0x81, 0xBF, 0xD4, 0x81, 0xAF, 0xD6, 0xA0, 0x84, 0x06, 0xA0, 0x24, 0x04, 0xFB, 0x07, 0x40, 0x8F,
  0xB0, 0xB4, 0x81, 0xDF, 0xE8, 0x02, 0x90, 0xDA, 0x30, 0x2A, 0x09, 0x60, 0x6A, 0x05, 0x20, 0x6A,
  0x05, 0x60, 0x2A, 0x09, 0x20, 0xBA, 0x01, 0x78, 0x1D, 0xFD, 0x2A, 0x0C, 0x71, 0x09, 0xA0, 0x20,
  0x4A, 0x08, 0x71, 0x05, 0xA0, 0x70, 0x8A, 0x04, 0x71, 0x01, 0xA0, 0xB0, 0xDA, 0x73, 0x0C, 0xA0,
  // "Â" (U+00C2)
  0x68, 0x24, 0x77, 0x17, 0x40, 0x10, 0xEA, 0x09, 0x74, 0x09, 0xC0, 0x37, 0x20, 0x3A, 0x82, 0x49,
  0xFC, 0x72, 0x81, 0xDF, 0x52, 0x81, 0xAF, 0x87, 0x81, 0x9F, 0x64, 0x81, 0xAF, 0x38, 0x0C, 0x50,
  0x09, 0xA0, 0xB7, 0x50, 0xDB, 0x74, 0x02, 0xA8, 0x1E, 0xF4, 0x73, 0x84, 0x6F, 0xDB, 0xF9, 0x73,
  0x84, 0xBF, 0x98, 0xFD, 0x73, 0xA0, 0x60, 0x4A, 0x02, 0x71, 0x04, 0xA0, 0x21, 0xA0, 0x77, 0x18,
  0x19, 0xFE, 0x28, 0x1C, 0xFB, 0x71, 0x81, 0xDF, 0x92, 0x07, 0xA7, 0x02, 0xA0, 0x52, 0x03, 0xA0,
  0x46, 0x06, 0xA0, 0x13, 0x81, 0xEF, 0x96, 0x81, 0xBF, 0xD4, 0x81, 0xAF, 0xD6, 0xA0, 0x84, 0x06,
  0xA0, 0x24, 0x04, 0xFB, 0x07, 0x40, 0x8F, 0xB0, 0xB4, 0x81, 0xDF, 0xE8, 0x02, 0x90, 0xDA, 0x30,
  0x2A, 0x09, 0x60, 0x6A, 0x05, 0x20, 0x6A, 0x05, 0x60, 0x2A, 0x09, 0x20, 0xBA, 0x01, 0x78, 0x1D,
  0xFD, 0x2A, 0x0C, 0x71, 0x09, 0xA0, 0x20, 0x4A, 0x08, 0x71, 0x05, 0xA0, 0x70, 0x8A, 0x04, 0x71,
  0x01, 0xA0, 0xB0, 0xDA, 0x73, 0x0C, 0xA0,
  // "Ã" (U+00C3)
  0x48, 0x34, 0xDE, 0xA2, 0x28, 0x15, 0xF5, 0x60, 0xEC, 0x83, 0x96, 0xDF, 0x25, 0x83, 0x6F, 0xB6,
  0xCC, 0x0B, 0x68, 0x19, 0xF1, 0x28, 0x35, 0xCF, 0xB1, 0x80, 0xC5, 0x00, 0x9A, 0x0B, 0x75, 0x0D,
  0xB7, 0x40, 0x2A, 0x81, 0xEF, 0x47, 0x38, 0x46, 0xFD, 0xBF, 0x97, 0x38, 0x4B, 0xF9, 0x8F, 0xD7,
  0x3A, 0x06, 0x04, 0xA0, 0x27, 0x10, 0x4A, 0x02, 0x1A, 0x07, 0x71, 0x81, 0x9F, 0xE2, 0x81, 0xCF,
  0xB7, 0x18, 0x1D, 0xF9, 0x20, 0x7A, 0x70, 0x2A, 0x05, 0x20, 0x3A, 0x04, 0x60, 0x6A, 0x01, 0x38,
  0x1E, 0xF9, 0x68, 0x1B, 0xFD, 0x48, 0x1A, 0xFD, 0x6A, 0x08, 0x40, 0x6A, 0x02, 0x40, 0x4F, 0xB0,
  0x74, 0x08, 0xFB, 0x0B, 0x48, 0x1D, 0xFE, 0x80, 0x29, 0x0D, 0xA3, 0x02, 0xA0, 0x96, 0x06, 0xA0,
  0x52, 0x06, 0xA0, 0x56, 0x02, 0xA0, 0x92, 0x0B, 0xA0, 0x17, 0x81, 0xDF, 0xD2, 0xA0, 0xC7, 0x10,
  0x9A, 0x02, 0x04, 0xA0, 0x87, 0x10, 0x5A, 0x07, 0x08, 0xA0, 0x47, 0x10, 0x1A, 0x0B, 0x0D, 0xA7,
  0x30, 0xCA,
  // "Ä" (U+00C4)
  0x38, 0x22, 0xEC, 0x12, 0x81, 0xAE, 0x67, 0x06, 0xA0, 0x32, 0xA0, 0xB7, 0x81, 0x2D, 0xC3, 0x81,
  0xAE, 0x58, 0x0C, 0x60, 0x09, 0xA0, 0xB7, 0x50, 0xDB, 0x74, 0x02, 0xA8, 0x1E, 0xF4, 0x73, 0x84,
  0x6F, 0xDB, 0xF9, 0x73, 0x84, 0xBF, 0x98, 0xFD, 0x73, 0xA0, 0x60, 0x4A, 0x02, 0x71, 0x04, 0xA0,
  0x21, 0xA0, 0x77, 0x18, 0x19, 0xFE, 0x28, 0x1C, 0xFB, 0x71, 0x81, 0xDF, 0x92, 0x07, 0xA7, 0x02,
  0xA0, 0x52, 0x03, 0xA0, 0x46, 0x06, 0xA0, 0x13, 0x81, 0xEF, 0x96, 0x81, 0xBF, 0xD4, 0x81, 0xAF,
  0xD6, 0xA0, 0x84, 0x06, 0xA0, 0x24, 0x04, 0xFB, 0x07, 0x40, 0x8F, 0xB0, 0xB4, 0x81, 0xDF, 0xE8,
  0x02, 0x90, 0xDA, 0x30, 0x2A, 0x09, 0x60, 0x6A, 0x05, 0x20, 0x6A, 0x05, 0x60, 0x2A, 0x09, 0x20,
  0xBA, 0x01, 0x78, 0x1D, 0xFD, 0x2A, 0x0C, 0x71, 0x09, 0xA0, 0x20, 0x4A, 0x08, 0x71, 0x05, 0xA0,
  0x70, 0x8A, 0x04, 0x71, 0x01, 0xA0, 0xB0, 0xDA, 0x73, 0x0C, 0xA0,
  // "Å" (U+00C5)
  0x58, 0x32, 0x9C, 0xA4, 0x73, 0x01, 0x0E, 0xC0, 0x67, 0x28, 0x58, 0xF7, 0x03, 0xEE, 0x72, 0x0A,
  0x93, 0x09, 0x97, 0x28, 0x58, 0xF4, 0x01, 0xDE, 0x72, 0x02, 0xA0, 0xDA, 0x07, 0x73, 0x04, 0xC7,
  0x50, 0xDB, 0x74, 0x02, 0xA8, 0x1E, 0xF4, 0x73, 0x84, 0x6F, 0xDB, 0xF9, 0x73, 0x84, 0xBF, 0x98,
  0xFD, 0x73, 0xA0, 0x60, 0x4A, 0x02, 0x71, 0x04, 0xA0, 0x21, 0xA0, 0x77, 0x18, 0x19, 0xFE, 0x28,
  0x1C, 0xFB, 0x71, 0x81, 0xDF, 0x92, 0x07, 0xA7, 0x02, 0xA0, 0x52, 0x03, 0xA0, 0x46, 0x06, 0xA0,
  0x13, 0x81, 0xEF, 0x96, 0x81, 0xBF, 0xD4, 0x81, 0xAF, 0xD6, 0xA0, 0x84, 0x06, 0xA0, 0x24, 0x04,
  0xFB, 0x07, 0x40, 0x8F, 0xB0, 0xB4, 0x81, 0xDF, 0xE8, 0x02, 0x90, 0xDA, 0x30, 0x2A, 0x09, 0x60,
  0x6A, 0x05, 0x20, 0x6A, 0x05, 0x60, 0x2A, 0x09, 0x20, 0xBA, 0x01, 0x78, 0x1D, 0xFD, 0x2A, 0x0C,
  0x71, 0x09, 0xA0, 0x20, 0x4A, 0x08, 0x71, 0x05, 0xA0, 0x70, 0x8A, 0x04, 0x71, 0x01, 0xA0, 0xB0,
  0xDA, 0x73, 0x0C, 0xA0,
  // "Æ" (U+00C6)
  0x70, 0x2F, 0xD0, 0x97, 0x08, 0xFD, 0x09, 0x78, 0x2D, 0xFC, 0x8A, 0x0A, 0x80, 0x25, 0x03, 0x60,
  0x3A, 0x06, 0x03, 0xA0, 0x77, 0x60, 0x9A, 0x01, 0x03, 0xA0, 0x77, 0x68, 0x3E, 0xFB, 0x03, 0xA0,
  0x77, 0x50, 0x4A, 0x81, 0x50, 0x3A, 0x07, 0x75, 0x09, 0xA2, 0x03, 0xA0, 0x77, 0x58, 0x1E, 0xFA,
  0x20, 0x3A, 0x07, 0x74, 0x05, 0xA0, 0x52, 0x03, 0xA0, 0xA8, 0x02, 0x55, 0x81, 0xAF, 0xE3, 0x03,
  0xFA, 0x02, 0x4A, 0x0A, 0x30, 0x3F, 0xA0, 0x23, 0x05, 0xA0, 0x43, 0x03, 0xA0, 0x77, 0x30, 0xBF,
  0xA0, 0x77, 0x20, 0x1F, 0xB0, 0x77, 0x20, 0x6A, 0x84, 0x75, 0x55, 0x58, 0xA0, 0x77, 0x28, 0x1C,
  0xFE, 0x50, 0x4A, 0x07, 0x71, 0x02, 0xA0, 0xA5, 0x04, 0xA0, 0x77, 0x10, 0x7A, 0x05, 0x50, 0x4A,
  0x07, 0x71, 0x81, 0xDF, 0xE6, 0x04, 0xA0, 0x77, 0x02, 0xA0, 0xA6, 0x04, 0xA0, 0xA8, 0x02, 0x50,
  0x30, 0x8A, 0x05, 0x60, 0x4F, 0xA0, 0x90, 0xDA, 0x70, 0x4F, 0xA0, 0x90,
  // "Ç" (U+00C7)
  0x58, 0x71, 0x8C, 0xEF, 0xEC, 0x82, 0x50, 0x60, 0xEF, 0x90, 0x13, 0x07, 0xB8, 0x5B, 0x75, 0x7B,
  0xF9, 0x30, 0x4B, 0x05, 0x50, 0x02, 0x30, 0xCA, 0x06, 0x73, 0x04, 0xA0, 0xC7, 0x40, 0x8A, 0x06,
  0x74, 0x0C, 0xA0, 0x17, 0x4A, 0x0D, 0x74, 0x02, 0xA0, 0xB7, 0x40, 0x3A, 0x09, 0x74, 0x04, 0xA0,
  0x97, 0x40, 0x3A, 0x09, 0x74, 0x02, 0xA0, 0xA7, 0x40, 0x1A, 0x0C, 0x75, 0x0D, 0xA7, 0x50, 0x9A,
  0x05, 0x74, 0x05, 0xA0, 0xB7, 0x50, 0xDA, 0x05, 0x74, 0x05, 0xB0, 0x56, 0x01, 0x40, 0x8B, 0x85,
  0xC7, 0x67, 0x9D, 0x85, 0x07, 0xF9, 0x08, 0x68, 0x72, 0x8C, 0xEF, 0xEC, 0x72, 0x71, 0x0A, 0x0E,
  0x75, 0x82, 0x2F, 0xB1, 0x74, 0x83, 0x4B, 0xFE, 0x47, 0x58, 0x14, 0xFE, 0x75, 0x01, 0xA0, 0x17,
  0x18, 0x24, 0x56, 0xCA, 0x72, 0x09, 0xC0, 0x87, 0x28, 0x38, 0xEE, 0xC6, 0x50,
  // "È" (U+00C8)
  0x18, 0x25, 0x77, 0x47, 0x05, 0xA0, 0xE7, 0x10, 0x9A, 0x07, 0x71, 0x82, 0xBF, 0xE1, 0x71, 0x81,
  0xCF, 0x97, 0x18, 0x21, 0xCF, 0x37, 0x77, 0x40, 0x6F, 0xA0, 0xB0, 0x6F, 0xA0, 0xB0, 0x6A, 0x08,
  0x80, 0x25, 0x04, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06,
  0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x88, 0x02, 0x50, 0x10, 0x6F, 0xA0, 0x40, 0x6F, 0xA0,
  0x40, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70,
  0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x08, 0x80, 0x25, 0x04, 0x06, 0xFA,
  0x0B, 0x06, 0xFA, 0x0B,
  // "É" (U+00C9)
  0x70, 0xF7, 0x02, 0x60, 0x5A, 0x0D, 0x01, 0x60, 0xDA, 0x03, 0x60, 0x6A, 0x06, 0x68, 0x21, 0xEF,
  0x87, 0x81, 0x9F, 0x87, 0x77, 0x50, 0x6F, 0xA0, 0xB0, 0x6F, 0xA0, 0xB0, 0x6A, 0x08, 0x80, 0x25,
  0x04, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47,
  0x06, 0xA0, 0x47, 0x06, 0xA0, 0x88, 0x02, 0x50, 0x10, 0x6F, 0xA0, 0x40, 0x6F, 0xA0, 0x40, 0x6A,
  0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04,
  0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x08, 0x80, 0x25, 0x04, 0x06, 0xFA, 0x0B, 0x06,
  0xFA, 0x0B,
  // "Ê" (U+00CA)
  0x48, 0x24, 0x77, 0x16, 0x01, 0x0E, 0xA0, 0x96, 0x09, 0xC0, 0x34, 0x03, 0xA8, 0x24, 0x9F, 0xC4,
  0x81, 0xDF, 0x52, 0x81, 0xAF, 0x82, 0x81, 0x9F, 0x64, 0x81, 0xAF, 0x37, 0x77, 0x10, 0x6F, 0xA0,
  0xB0, 0x6F, 0xA0, 0xB0, 0x6A, 0x08, 0x80, 0x25, 0x04, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06,
  0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x88, 0x02, 0x50,
  0x10, 0x6F, 0xA0, 0x40, 0x6F, 0xA0, 0x40, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70,
  0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A,
  0x08, 0x80, 0x25, 0x04, 0x06, 0xFA, 0x0B, 0x06, 0xFA, 0x0B,
  // "Ë" (U+00CB)
  0x18, 0x22, 0xEC, 0x12, 0x81, 0xAE, 0x62, 0x06, 0xA0, 0x32, 0xA0, 0xB2, 0x81, 0x2D, 0xC3, 0x81,
  0xAE, 0x57, 0x77, 0x20, 0x6F, 0xA0, 0xB0, 0x6F, 0xA0, 0xB0, 0x6A, 0x08, 0x80, 0x25, 0x04, 0x06,
  0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0,
  0x47, 0x06, 0xA0, 0x88, 0x02, 0x50, 0x10, 0x6F, 0xA0, 0x40, 0x6F, 0xA0, 0x40, 0x6A, 0x04, 0x70,
  0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A,
  0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x08, 0x80, 0x25, 0x04, 0x06, 0xFA, 0x0B, 0x06, 0xFA, 0x0B,
  // "Ì" (U+00CC)
  0x82, 0x57, 0x74, 0x50, 0x5A, 0x0E, 0x60, 0x9A, 0x07, 0x68, 0x2B, 0xFE, 0x16, 0x81, 0xCF, 0x96,
  0x82, 0x1C, 0xF3, 0x77, 0x70, 0xDE, 0x81, 0x60, 0xCE, 0x05, 0x20, 0x20, 0xBA, 0x05, 0x50, 0x9A,
  0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02,
  0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50,
  0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A,
  0x02, 0x50, 0x9A, 0x02, 0x30, 0x80, 0xDC, 0x82, 0xC3, 0x0D, 0xE0, 0x60,
  // "Í" (U+00CD)
  0x60, 0xF7, 0x02, 0x50, 0x5A, 0x0D, 0x01, 0x50, 0xDA, 0x03, 0x50, 0x6A, 0x06, 0x58, 0x21, 0xEF,
  0x86, 0x81, 0x9F, 0x87, 0x77, 0x30, 0xDE, 0x06, 0x20, 0xCE, 0x05, 0x30, 0x20, 0xBA, 0x05, 0x60,
  0x9A, 0x02, 0x60, 0x9A, 0x02, 0x60, 0x9A, 0x02, 0x60, 0x9A, 0x02, 0x60, 0x9A, 0x02, 0x60, 0x9A,
  0x02, 0x60, 0x9A, 0x02, 0x60, 0x9A, 0x02, 0x60, 0x9A, 0x02, 0x60, 0x9A, 0x02, 0x60, 0x9A, 0x02,
  0x60, 0x9A, 0x02, 0x60, 0x9A, 0x02, 0x60, 0x9A, 0x02, 0x60, 0x9A, 0x02, 0x60, 0x9A, 0x02, 0x60,
  0x9A, 0x02, 0x60, 0x9A, 0x02, 0x40, 0x80, 0xDC, 0x0C, 0x03, 0x20, 0xDE, 0x06, 0x20,
  // "Î" (U+00CE)
  0x38, 0x24, 0x77, 0x15, 0x01, 0x0E, 0xA0, 0x95, 0x09, 0xC0, 0x33, 0x03, 0xA8, 0x24, 0x9F, 0xC3,
  0x81, 0xDF, 0x52, 0x85, 0xAF, 0x80, 0x9F, 0x64, 0x81, 0xAF, 0x37, 0x77, 0x0D, 0xE0, 0x62, 0x0C,
  0xE0, 0x53, 0x02, 0x0B, 0xA0, 0x56, 0x09, 0xA0, 0x26, 0x09, 0xA0, 0x26, 0x09, 0xA0, 0x26, 0x09,
  0xA0, 0x26, 0x09, 0xA0, 0x26, 0x09, 0xA0, 0x26, 0x09, 0xA0, 0x26, 0x09, 0xA0, 0x26, 0x09, 0xA0,
  0x26, 0x09, 0xA0, 0x26, 0x09, 0xA0, 0x26, 0x09, 0xA0, 0x26, 0x09, 0xA0, 0x26, 0x09, 0xA0, 0x26,
  0x09, 0xA0, 0x26, 0x09, 0xA0, 0x26, 0x09, 0xA0, 0x26, 0x09, 0xA0, 0x24, 0x08, 0x0D, 0xC0, 0xC0,
  0x32, 0x0D, 0xE0, 0x61,
  // "Ï" (U+00CF)
  0x82, 0x2E, 0xC1, 0x28, 0x2A, 0xE6, 0x6A, 0x03, 0x2A, 0x82, 0xB2, 0xDC, 0x38, 0x1A, 0xE5, 0x77,
  0x50, 0xDE, 0x81, 0x60, 0xCE, 0x05, 0x20, 0x20, 0xBA, 0x05, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02,
  0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50,
  0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A,
  0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02,
  0x30, 0x80, 0xDC, 0x82, 0xC3, 0x0D, 0xE0, 0x60,
  // "Ð" (U+00D0)
  0x20, 0x5D, 0x82, 0xED, 0xA5, 0x70, 0x5F, 0xA0, 0xC0, 0x25, 0x05, 0xA8, 0x49, 0x55, 0x69, 0xEA,
  0x0E, 0x03, 0x40, 0x5A, 0x05, 0x50, 0x9A, 0x0D, 0x40, 0x5A, 0x05, 0x60, 0xAA, 0x08, 0x30, 0x5A,
  0x05, 0x68, 0x21, 0xEF, 0xE3, 0x05, 0xA0, 0x57, 0x0A, 0xA0, 0x42, 0x05, 0xA0, 0x57, 0x05, 0xA0,
  0x72, 0x05, 0xA0, 0x57, 0x03, 0xA0, 0xA2, 0x05, 0xA0, 0x57, 0x01, 0xA0, 0xB0, 0x3F, 0x90, 0x34,
  0xA0, 0xC0, 0x3F, 0x90, 0x34, 0xA8, 0x2D, 0x15, 0x9A, 0x83, 0x95, 0x55, 0x14, 0xA0, 0xC2, 0x05,
  0xA0, 0x57, 0x01, 0xA0, 0xB2, 0x05, 0xA0, 0x57, 0x03, 0xA0, 0x92, 0x05, 0xA0, 0x57, 0x06, 0xA0,
  0x62, 0x05, 0xA0, 0x57, 0x0B, 0xA0, 0x32, 0x05, 0xA0, 0x56, 0x02, 0xA0, 0xD3, 0x05, 0xA0, 0x56,
  0x0B, 0xA0, 0x63, 0x05, 0xA0, 0x54, 0x01, 0x0B, 0xA0, 0xC4, 0x05, 0xA8, 0x49, 0x55, 0x7A, 0xEA,
  0x0D, 0x02, 0x40, 0x5F, 0xA0, 0xB0, 0x15, 0x05, 0xD8, 0x2E, 0xD9, 0x45,
  // "Ñ" (U+00D1)
  0x48, 0x34, 0xDE, 0xA2, 0x28, 0x15, 0xF5, 0x60, 0xEC, 0x83, 0x96, 0xDF, 0x25, 0x83, 0x6F, 0xB6,
  0xCC, 0x0B, 0x68, 0x19, 0xF1, 0x28, 0x35, 0xCF, 0xB1, 0x77, 0x77, 0x70, 0x6B, 0x01, 0x70, 0x1A,
  0x07, 0x06, 0xB0, 0x97, 0x01, 0xA0, 0x70, 0x6C, 0x01, 0x60, 0x1A, 0x07, 0x06, 0xC0, 0x86, 0x01,
  0xA8, 0x67, 0x6F, 0xED, 0xFE, 0x15, 0x01, 0xA0, 0x70, 0x6A, 0x05, 0xA0, 0x85, 0x01, 0xA0, 0x70,
  0x6A, 0x83, 0x1D, 0xFE, 0x14, 0x01, 0xA0, 0x70, 0x6A, 0x01, 0x06, 0xA0, 0x84, 0x01, 0xA0, 0x70,
  0x6A, 0x84, 0x20, 0xDF, 0xE1, 0x30, 0x1A, 0x07, 0x06, 0xA8, 0x12, 0x06, 0xA0, 0x73, 0x01, 0xA0,
  0x70, 0x6A, 0x02, 0x28, 0x1D, 0xFE, 0x30, 0x1A, 0x07, 0x06, 0xA0, 0x22, 0x06, 0xA0, 0x72, 0x01,
  0xA0, 0x70, 0x6A, 0x02, 0x38, 0x1E, 0xFE, 0x20, 0x1A, 0x07, 0x06, 0xA0, 0x23, 0x07, 0xA8, 0x16,
  0x01, 0xA0, 0x70, 0x6A, 0x02, 0x48, 0x3E, 0xFD, 0x01, 0xA0, 0x70, 0x6A, 0x02, 0x40, 0x7A, 0x06,
  0x1A, 0x07, 0x06, 0xA0, 0x25, 0x81, 0xEF, 0xD1, 0xA0, 0x70, 0x6A, 0x02, 0x50, 0x7A, 0x06, 0xA0,
  0x70, 0x6A, 0x02, 0x58, 0x61, 0xEF, 0xDE, 0xF7, 0x6A, 0x02, 0x60, 0x7C, 0x07, 0x06, 0xA0, 0x26,
  0x01, 0x0E, 0xB0, 0x70, 0x6A, 0x02, 0x70, 0x8B, 0x07, 0x06, 0xA0, 0x27, 0x01, 0x0E, 0xA0, 0x70,
  // "Ò" (U+00D2)
  0x48, 0x25, 0x77, 0x47, 0x70, 0x5A, 0x0E, 0x77, 0x10, 0x9A, 0x07, 0x77, 0x18, 0x2B, 0xFE, 0x17,
  0x71, 0x81, 0xCF, 0x97, 0x71, 0x82, 0x1C, 0xF3, 0x80, 0xD4, 0x08, 0x64, 0xAD, 0xEE, 0xD9, 0x37,
  0x10, 0x10, 0xBF, 0x90, 0x87, 0x0C, 0xA8, 0x3E, 0x96, 0x69, 0xB0, 0x85, 0x08, 0xA0, 0xC0, 0x14,
  0x02, 0x0D, 0xA0, 0x43, 0x01, 0xA0, 0xE0, 0x16, 0x03, 0xA0, 0xC3, 0x06, 0xA0, 0x87, 0x10, 0xBA,
  0x03, 0x20, 0xBA, 0x02, 0x71, 0x05, 0xA0, 0x72, 0x81, 0xEF, 0xE7, 0x20, 0x1A, 0x81, 0xB0, 0x1A,
  0x0C, 0x73, 0x83, 0xEF, 0xE0, 0x3A, 0x0A, 0x73, 0x0D, 0xA1, 0x03, 0xA0, 0x97, 0x30, 0xCA, 0x01,
  0x04, 0xA0, 0x97, 0x30, 0xCA, 0x01, 0x03, 0xA0, 0x97, 0x30, 0xCA, 0x01, 0x02, 0xA0, 0xA7, 0x30,
  0xDA, 0x10, 0x1A, 0x0C, 0x73, 0xA0, 0xE2, 0x81, 0xDF, 0xE7, 0x20, 0x2A, 0x0B, 0x20, 0x9A, 0x03,
  0x71, 0x05, 0xA0, 0x72, 0x05, 0xA0, 0x87, 0x10, 0xBA, 0x03, 0x38, 0x2E, 0xFE, 0x16, 0x03, 0xA0,
  0xC4, 0x06, 0xA0, 0xC0, 0x14, 0x02, 0x0D, 0xA0, 0x45, 0x0B, 0xA8, 0x3E, 0x96, 0x69, 0xB0, 0x87,
  0x0A, 0xF9, 0x08, 0x72, 0x86, 0x4A, 0xDF, 0xED, 0x93, 0x50,
  // "Ó" (U+00D3)
  0x74, 0x0F, 0x70, 0x27, 0x60, 0x5A, 0x0D, 0x01, 0x76, 0x0D, 0xA0, 0x37, 0x60, 0x6A, 0x06, 0x76,
  0x82, 0x1E, 0xF8, 0x77, 0x81, 0x9F, 0x88, 0x0D, 0x40, 0x86, 0x4A, 0xDE, 0xED, 0x93, 0x71, 0x01,
  0x0B, 0xF9, 0x08, 0x70, 0xCA, 0x83, 0xE9, 0x66, 0x9B, 0x08, 0x50, 0x8A, 0x0C, 0x01, 0x40, 0x20,
  0xDA, 0x04, 0x30, 0x1A, 0x0E, 0x01, 0x60, 0x3A, 0x0C, 0x30, 0x6A, 0x08, 0x71, 0x0B, 0xA0, 0x32,
  0x0B, 0xA0, 0x27, 0x10, 0x5A, 0x07, 0x28, 0x1E, 0xFE, 0x72, 0x01, 0xA8, 0x1B, 0x01, 0xA0, 0xC7,
  0x38, 0x3E, 0xFE, 0x03, 0xA0, 0xA7, 0x30, 0xDA, 0x10, 0x3A, 0x09, 0x73, 0x0C, 0xA0, 0x10, 0x4A,
  0x09, 0x73, 0x0C, 0xA0, 0x10, 0x3A, 0x09, 0x73, 0x0C, 0xA0, 0x10, 0x2A, 0x0A, 0x73, 0x0D, 0xA1,
  0x01, 0xA0, 0xC7, 0x3A, 0x0E, 0x28, 0x1D, 0xFE, 0x72, 0x02, 0xA0, 0xB2, 0x09, 0xA0, 0x37, 0x10,
  0x5A, 0x07, 0x20, 0x5A, 0x08, 0x71, 0x0B, 0xA0, 0x33, 0x82, 0xEF, 0xE1, 0x60, 0x3A, 0x0C, 0x40,
  0x6A, 0x0C, 0x01, 0x40, 0x20, 0xDA, 0x04, 0x50, 0xBA, 0x83, 0xE9, 0x66, 0x9B, 0x08, 0x70, 0xAF,
  0x90, 0x87, 0x28, 0x64, 0xAD, 0xFE, 0xD9, 0x35,
  // "Ô" (U+00D4)
  0x78, 0x24, 0x77, 0x17, 0x60, 0x10, 0xEA, 0x09, 0x76, 0x09, 0xC0, 0x37, 0x40, 0x3A, 0x82, 0x49,
  0xFC, 0x74, 0x81, 0xDF, 0x52, 0x81, 0xAF, 0x87, 0x28, 0x19, 0xF6, 0x48, 0x1A, 0xF3, 0x80, 0xD1,
  0x08, 0x64, 0xAD, 0xEE, 0xD9, 0x37, 0x10, 0x10, 0xBF, 0x90, 0x87, 0x0C, 0xA8, 0x3E, 0x96, 0x69,
  0xB0, 0x85, 0x08, 0xA0, 0xC0, 0x14, 0x02, 0x0D, 0xA0, 0x43, 0x01, 0xA0, 0xE0, 0x16, 0x03, 0xA0,
  0xC3, 0x06, 0xA0, 0x87, 0x10, 0xBA, 0x03, 0x20, 0xBA, 0x02, 0x71, 0x05, 0xA0, 0x72, 0x81, 0xEF,
  0xE7, 0x20, 0x1A, 0x81, 0xB0, 0x1A, 0x0C, 0x73, 0x83, 0xEF, 0xE0, 0x3A, 0x0A, 0x73, 0x0D, 0xA1,
  0x03, 0xA0, 0x97, 0x30, 0xCA, 0x01, 0x04, 0xA0, 0x97, 0x30, 0xCA, 0x01, 0x03, 0xA0, 0x97, 0x30,
  0xCA, 0x01, 0x02, 0xA0, 0xA7, 0x30, 0xDA, 0x10, 0x1A, 0x0C, 0x73, 0xA0, 0xE2, 0x81, 0xDF, 0xE7,
  0x20, 0x2A, 0x0B, 0x20, 0x9A, 0x03, 0x71, 0x05, 0xA0, 0x72, 0x05, 0xA0, 0x87, 0x10, 0xBA, 0x03,
  0x38, 0x2E, 0xFE, 0x16, 0x03, 0xA0, 0xC4, 0x06, 0xA0, 0xC0, 0x14, 0x02, 0x0D, 0xA0, 0x45, 0x0B,
  0xA8, 0x3E, 0x96, 0x69, 0xB0, 0x87, 0x0A, 0xF9, 0x08, 0x72, 0x86, 0x4A, 0xDF, 0xED, 0x93, 0x50,
  // "Õ" (U+00D5)
  0x58, 0x34, 0xDE, 0xA2, 0x28, 0x15, 0xF5, 0x71, 0x0E, 0xC8, 0x39, 0x6D, 0xF2, 0x78, 0x36, 0xFB,
  0x6C, 0xC0, 0xB7, 0x18, 0x19, 0xF1, 0x28, 0x35, 0xCF, 0xB1, 0x80, 0xD1, 0x08, 0x64, 0xAD, 0xEE,
  0xD9, 0x37, 0x10, 0x10, 0xBF, 0x90, 0x87, 0x0C, 0xA8, 0x3E, 0x96, 0x69, 0xB0, 0x85, 0x08, 0xA0,
  0xC0, 0x14, 0x02, 0x0D, 0xA0, 0x43, 0x01, 0xA0, 0xE0, 0x16, 0x03, 0xA0, 0xC3, 0x06, 0xA0, 0x87,
  0x10, 0xBA, 0x03, 0x20, 0xBA, 0x02, 0x71, 0x05, 0xA0, 0x72, 0x81, 0xEF, 0xE7, 0x20, 0x1A, 0x81,
  0xB0, 0x1A, 0x0C, 0x73, 0x83, 0xEF, 0xE0, 0x3A, 0x0A, 0x73, 0x0D, 0xA1, 0x03, 0xA0, 0x97, 0x30,
  0xCA, 0x01, 0x04, 0xA0, 0x97, 0x30, 0xCA, 0x01, 0x03, 0xA0, 0x97, 0x30, 0xCA, 0x01, 0x02, 0xA0,
  0xA7, 0x30, 0xDA, 0x10, 0x1A, 0x0C, 0x73, 0xA0, 0xE2, 0x81, 0xDF, 0xE7, 0x20, 0x2A, 0x0B, 0x20,
  0x9A, 0x03, 0x71, 0x05, 0xA0, 0x72, 0x05, 0xA0, 0x87, 0x10, 0xBA, 0x03, 0x38, 0x2E, 0xFE, 0x16,
  0x03, 0xA0, 0xC4, 0x06, 0xA0, 0xC0, 0x14, 0x02, 0x0D, 0xA0, 0x45, 0x0B, 0xA8, 0x3E, 0x96, 0x69,
  0xB0, 0x87, 0x0A, 0xF9, 0x08, 0x72, 0x86, 0x4A, 0xDF, 0xED, 0x93, 0x50,
  // "Ö" (U+00D6)
  0x48, 0x22, 0xEC, 0x12, 0x81, 0xAE, 0x67, 0x20, 0x6A, 0x03, 0x2A, 0x0B, 0x72, 0x81, 0x2D, 0xC3,
  0x81, 0xAE, 0x58, 0x0D, 0x20, 0x86, 0x4A, 0xDE, 0xED, 0x93, 0x71, 0x01, 0x0B, 0xF9, 0x08, 0x70,
  0xCA, 0x83, 0xE9, 0x66, 0x9B, 0x08, 0x50, 0x8A, 0x0C, 0x01, 0x40, 0x20, 0xDA, 0x04, 0x30, 0x1A,
  0x0E, 0x01, 0x60, 0x3A, 0x0C, 0x30, 0x6A, 0x08, 0x71, 0x0B, 0xA0, 0x32, 0x0B, 0xA0, 0x27, 0x10,
  0x5A, 0x07, 0x28, 0x1E, 0xFE, 0x72, 0x01, 0xA8, 0x1B, 0x01, 0xA0, 0xC7, 0x38, 0x3E, 0xFE, 0x03,
  0xA0, 0xA7, 0x30, 0xDA, 0x10, 0x3A, 0x09, 0x73, 0x0C, 0xA0, 0x10, 0x4A, 0x09, 0x73, 0x0C, 0xA0,
  0x10, 0x3A, 0x09, 0x73, 0x0C, 0xA0, 0x10, 0x2A, 0x0A, 0x73, 0x0D, 0xA1, 0x01, 0xA0, 0xC7, 0x3A,
  0x0E, 0x28, 0x1D, 0xFE, 0x72, 0x02, 0xA0, 0xB2, 0x09, 0xA0, 0x37, 0x10, 0x5A, 0x07, 0x20, 0x5A,
  0x08, 0x71, 0x0B, 0xA0, 0x33, 0x82, 0xEF, 0xE1, 0x60, 0x3A, 0x0C, 0x40, 0x6A, 0x0C, 0x01, 0x40,
  0x20, 0xDA, 0x04, 0x50, 0xBA, 0x83, 0xE9, 0x66, 0x9B, 0x08, 0x70, 0xAF, 0x90, 0x87, 0x28, 0x64,
  0xAD, 0xFE, 0xD9, 0x35,
  // "×" (U+00D7)
  0x10, 0x27, 0x28, 0x33, 0x02, 0xEC, 0x78, 0x5B, 0xF5, 0x3E, 0xFC, 0x50, 0xBA, 0x84, 0x40, 0x4E,
  0xFC, 0x30, 0xBA, 0x04, 0x38, 0x44, 0xEF, 0xC1, 0xBA, 0x04, 0x50, 0x40, 0xEC, 0x04, 0x70, 0x4B,
  0x05, 0x71, 0x0B, 0xB0, 0xC0, 0x16, 0x0B, 0xA0, 0x8A, 0x0C, 0x01, 0x40, 0xBA, 0x85, 0x40, 0x4E,
  0xFC, 0x12, 0x0B, 0xA0, 0x43, 0x84, 0x4E, 0xFC, 0x16, 0xA0, 0x45, 0x85, 0x3E, 0xF7, 0x08, 0x47,
  0x03, 0x08, 0x10,
  // "Ø" (U+00D8)
  0x77, 0x81, 0x49, 0x16, 0x89, 0x24, 0xAD, 0xEE, 0xC8, 0x20, 0xDF, 0x64, 0x01, 0x0B, 0xF9, 0x81,
  0xBF, 0xC5, 0x0C, 0xA8, 0x3E, 0x96, 0x69, 0xC0, 0x44, 0x08, 0xA0, 0xC0, 0x14, 0x03, 0x0E, 0xA0,
  0x33, 0x01, 0xA0, 0xE0, 0x15, 0x01, 0x0E, 0xA0, 0xC3, 0x06, 0xA0, 0x86, 0x0A, 0xC0, 0x32, 0x0B,
  0xA0, 0x25, 0x82, 0x3F, 0xE7, 0xA0, 0x82, 0x81, 0xEF, 0xE6, 0x82, 0xCF, 0x62, 0xA8, 0x1B, 0x01,
  0xA0, 0xB5, 0x81, 0x6F, 0xC2, 0x83, 0xEF, 0xE0, 0x3A, 0x09, 0x58, 0x1E, 0xF4, 0x20, 0xDA, 0x10,
  0x3A, 0x09, 0x48, 0x18, 0xFA, 0x30, 0xBA, 0x01, 0x04, 0xA0, 0x83, 0x02, 0xA0, 0x23, 0x0B, 0xA0,
  0x10, 0x3A, 0x09, 0x38, 0x1A, 0xF8, 0x40, 0xCA, 0x01, 0x03, 0xA0, 0x92, 0x81, 0x4F, 0xD5, 0x0C,
  0xA1, 0x01, 0xA0, 0xB2, 0x81, 0xDF, 0x55, 0x81, 0xEF, 0xE2, 0x85, 0xEF, 0xE0, 0x6F, 0xC5, 0x01,
  0xA0, 0xB2, 0x0B, 0xA8, 0x24, 0xEF, 0x35, 0x05, 0xA0, 0x82, 0x06, 0xA8, 0x1E, 0xF9, 0x60, 0xAA,
  0x03, 0x20, 0x10, 0xEA, 0x0E, 0x01, 0x50, 0x3A, 0x0D, 0x40, 0x7A, 0x0D, 0x01, 0x40, 0x20, 0xDA,
  0x04, 0x40, 0x4B, 0x83, 0xE9, 0x66, 0x9B, 0x09, 0x58, 0x1C, 0xFC, 0xF9, 0x08, 0x58, 0x92, 0x6F,
  0xD0, 0x3A, 0xDF, 0xED, 0x93, 0x68, 0x14, 0xD4, 0x77,
  // "Ù" (U+00D9)
  0x38, 0x25, 0x77, 0x47, 0x40, 0x5A, 0x0E, 0x75, 0x09, 0xA0, 0x77, 0x58, 0x2B, 0xFE, 0x17, 0x58,
  0x1C, 0xF9, 0x75, 0x82, 0x1C, 0xF3, 0x77, 0x77, 0x70, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0,
  0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A,
  0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09,
  0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40,
  0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04,
  0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x27, 0x06, 0xA0,
  0x40, 0x8A, 0x02, 0x70, 0x7A, 0x03, 0x06, 0xA0, 0x57, 0x0A, 0xA0, 0x10, 0x3A, 0x0A, 0x78, 0x1E,
  0xFD, 0x20, 0xCA, 0x05, 0x50, 0x9A, 0x07, 0x20, 0x3B, 0x83, 0xB6, 0x57, 0xCA, 0x0D, 0x40, 0x5F,
  0x90, 0xD0, 0x25, 0x86, 0x18, 0xCE, 0xFE, 0xB6, 0x40,
  // "Ú" (U+00DA)
  0x72, 0x0F, 0x70, 0x27, 0x30, 0x5A, 0x0D, 0x01, 0x73, 0x0D, 0xA0, 0x37, 0x30, 0x6A, 0x06, 0x73,
  0x82, 0x1E, 0xF8, 0x74, 0x81, 0x9F, 0x88, 0x0C, 0x00, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A,
  0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09,
  0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40,
  0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04,
  0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0,
  0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x02, 0x70, 0x6A,
  0x04, 0x08, 0xA0, 0x27, 0x07, 0xA0, 0x30, 0x6A, 0x05, 0x70, 0xAA, 0x01, 0x03, 0xA0, 0xA7, 0x81,
  0xEF, 0xD2, 0x0C, 0xA0, 0x55, 0x09, 0xA0, 0x72, 0x03, 0xB8, 0x3B, 0x65, 0x7C, 0xA0, 0xD4, 0x05,
  0xF9, 0x0D, 0x02, 0x58, 0x61, 0x8C, 0xEF, 0xEB, 0x64,
  // "Û" (U+00DB)
  0x68, 0x24, 0x77, 0x17, 0x30, 0x10, 0xEA, 0x09, 0x73, 0x09, 0xC0, 0x37, 0x10, 0x3A, 0x82, 0x49,
  0xFC, 0x71, 0x81, 0xDF, 0x52, 0x81, 0xAF, 0x86, 0x81, 0x9F, 0x64, 0x81, 0xAF, 0x37, 0x77, 0x74,
  0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0,
  0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A,
  0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06,
  0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70,
  0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17,
  0x06, 0xA0, 0x40, 0x9A, 0x02, 0x70, 0x6A, 0x04, 0x08, 0xA0, 0x27, 0x07, 0xA0, 0x30, 0x6A, 0x05,
  0x70, 0xAA, 0x01, 0x03, 0xA0, 0xA7, 0x81, 0xEF, 0xD2, 0x0C, 0xA0, 0x55, 0x09, 0xA0, 0x72, 0x03,
  0xB8, 0x3B, 0x65, 0x7C, 0xA0, 0xD4, 0x05, 0xF9, 0x0D, 0x02, 0x58, 0x61, 0x8C, 0xEF, 0xEB, 0x64,
  // "Ü" (U+00DC)
  0x38, 0x22, 0xEC, 0x12, 0x81, 0xAE, 0x66, 0x06, 0xA0, 0x32, 0xA0, 0xB6, 0x81, 0x2D, 0xC3, 0x81,
  0xAE, 0x57, 0x77, 0x75, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09,
  0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40,
  0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04,
  0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0,
  0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A,
  0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x02, 0x70, 0x6A, 0x04, 0x08, 0xA0, 0x27, 0x07,
  0xA0, 0x30, 0x6A, 0x05, 0x70, 0xAA, 0x01, 0x03, 0xA0, 0xA7, 0x81, 0xEF, 0xD2, 0x0C, 0xA0, 0x55,
  0x09, 0xA0, 0x72, 0x03, 0xB8, 0x3B, 0x65, 0x7C, 0xA0, 0xD4, 0x05, 0xF9, 0x0D, 0x02, 0x58, 0x61,
  0x8C, 0xEF, 0xEB, 0x64,
  // "Ý" (U+00DD)
  0x72, 0x0F, 0x70, 0x27, 0x20, 0x5A, 0x0D, 0x01, 0x72, 0x0D, 0xA0, 0x37, 0x20, 0x6A, 0x06, 0x72,
  0x82, 0x1E, 0xF8, 0x73, 0x81, 0x9F, 0x87, 0x77, 0x75, 0x0C, 0xA0, 0x17, 0x82, 0xDF, 0xE6, 0xA0,
  0x76, 0x03, 0xA8, 0x39, 0x0E, 0xFD, 0x60, 0x9A, 0x81, 0x20, 0x9A, 0x04, 0x58, 0x1E, 0xFC, 0x20,
  0x2A, 0x0A, 0x40, 0x6A, 0x05, 0x30, 0xCA, 0x01, 0x38, 0x1C, 0xFE, 0x40, 0x5A, 0x06, 0x20, 0x2A,
  0x08, 0x58, 0x1E, 0xFC, 0x20, 0x8A, 0x02, 0x50, 0x8A, 0x83, 0x30, 0xEF, 0xB6, 0x02, 0xA0, 0x90,
  0x5A, 0x05, 0x78, 0x4B, 0xFE, 0xBF, 0xE7, 0x10, 0x5C, 0x08, 0x72, 0x0E, 0xB0, 0x27, 0x20, 0x8A,
  0x0B, 0x73, 0x04, 0xA0, 0x77, 0x30, 0x4A, 0x07, 0x73, 0x04, 0xA0, 0x77, 0x30, 0x4A, 0x07, 0x73,
  0x04, 0xA0, 0x77, 0x30, 0x4A, 0x07, 0x73, 0x04, 0xA0, 0x77, 0x30, 0x4A, 0x07, 0x73, 0x04, 0xA0,
  0x75,
  // "Þ" (U+00DE)
  0x06, 0xA0, 0x47, 0x20, 0x6A, 0x04, 0x72, 0x06, 0xA0, 0x47, 0x20, 0x6A, 0x83, 0x85, 0x54, 0x25,
  0x06, 0xF0, 0xE0, 0x73, 0x06, 0xFA, 0x0C, 0x20, 0x6A, 0x04, 0x28, 0x11, 0x6E, 0xA8, 0x18, 0x06,
  0xA0, 0x44, 0x02, 0xA8, 0x1E, 0x06, 0xA0, 0x45, 0x09, 0xA0, 0x40, 0x6A, 0x04, 0x50, 0x6A, 0x00,
  0x6A, 0x04, 0x50, 0x5A, 0x00, 0x6A, 0x04, 0x50, 0x5A, 0x05, 0x06, 0xA0, 0x45, 0x08, 0xA0, 0x40,
  0x6A, 0x04, 0x58, 0x3D, 0xFE, 0x06, 0xA0, 0x44, 0x08, 0xA8, 0x1A, 0x06, 0xA8, 0x38, 0x56, 0x8D,
  0xA8, 0x2E, 0x10, 0x6F, 0x90, 0xD0, 0x32, 0x06, 0xD8, 0x1E, 0xB7, 0x40, 0x6A, 0x04, 0x72, 0x06,
  0xA0, 0x47, 0x20, 0x6A, 0x04, 0x72, 0x06, 0xA0, 0x47, 0x20, 0x6A, 0x04, 0x72,
  // "ß" (U+00DF)
  0x48, 0x22, 0x45, 0x37, 0x10, 0x40, 0xDC, 0x0E, 0x07, 0x50, 0x5F, 0x90, 0x83, 0x01, 0x0E, 0xA8,
  0x37, 0x11, 0x5E, 0xA0, 0x22, 0x06, 0xA0, 0x64, 0x06, 0xA0, 0x62, 0x09, 0xA0, 0x14, 0x03, 0xA0,
  0x72, 0x81, 0xBF, 0xE5, 0x04, 0xA0, 0x52, 0x81, 0xBF, 0xE5, 0x0B, 0xA0, 0x12, 0x81, 0xBF, 0xE4,
  0x07, 0xA0, 0x63, 0x81, 0xBF, 0xE3, 0x05, 0xA0, 0xA4, 0x81, 0xBF, 0xE2, 0x82, 0x1E, 0xFC, 0x58,
  0x1B, 0xFE, 0x20, 0x6A, 0x03, 0x58, 0x1B, 0xFE, 0x20, 0x7A, 0x02, 0x58, 0x1B, 0xFE, 0x20, 0x5A,
  0x08, 0x58, 0x1B, 0xFE, 0x30, 0xDA, 0x05, 0x48, 0x1B, 0xFE, 0x30, 0x4B, 0x06, 0x38, 0x1B, 0xFE,
  0x40, 0x5B, 0x05, 0x28, 0x1B, 0xFE, 0x50, 0x5B, 0x83, 0x20, 0xBF, 0xE6, 0x06, 0xA8, 0x3B, 0x0B,
  0xFE, 0x70, 0xCA, 0x18, 0x1B, 0xFE, 0x70, 0x8A, 0x82, 0x2B, 0xFE, 0x70, 0x8A, 0x85, 0x1B, 0xFE,
  0x02, 0x14, 0x89, 0x4D, 0xFE, 0x0B, 0xFE, 0x06, 0xE9, 0x66, 0xCA, 0x85, 0x90, 0xBF, 0xE0, 0x6E,
  0x89, 0x4D, 0x10, 0xBF, 0xE0, 0x29, 0xDE, 0xFD, 0x83,
  // "à" (U+00E0)
  0x28, 0x25, 0x77, 0x47, 0x10, 0x5A, 0x0E, 0x72, 0x09, 0xA0, 0x77, 0x28, 0x2B, 0xFE, 0x17, 0x28,
  0x1C, 0xF9, 0x72, 0x82, 0x1C, 0xF3, 0x77, 0x77, 0x18, 0x61, 0x7B, 0xEF, 0xEA, 0x33, 0x02, 0x0E,
  0xF0, 0x43, 0x84, 0xDE, 0x96, 0x6A, 0xA0, 0xD3, 0x02, 0x50, 0x9A, 0x03, 0x71, 0x03, 0xA0, 0x67,
  0x10, 0x2A, 0x07, 0x71, 0x01, 0xA0, 0x72, 0x82, 0x17, 0xBE, 0xD8, 0x28, 0x03, 0xEF, 0x98, 0x18,
  0x0E, 0xA8, 0x3D, 0x86, 0x56, 0xA0, 0x80, 0x6A, 0x0B, 0x40, 0x1A, 0x08, 0x0A, 0xA0, 0x24, 0x02,
  0xA0, 0x80, 0xBA, 0x50, 0x4A, 0x08, 0x0B, 0xA5, 0x08, 0xA0, 0x08, 0xA0, 0x53, 0x03, 0xB0, 0x80,
  0x3B, 0x89, 0x08, 0x68, 0xFB, 0xDF, 0x80, 0x9D, 0x83, 0xD1, 0xBF, 0x82, 0x89, 0x07, 0xDF, 0xD9,
  0x10, 0x8F, 0x80,
  // "á" (U+00E1)
  0x71, 0x0F, 0x70, 0x27, 0x05, 0xA0, 0xD0, 0x17, 0x0D, 0xA0, 0x37, 0x06, 0xA0, 0x67, 0x82, 0x1E,
  0xF8, 0x71, 0x81, 0x9F, 0x87, 0x77, 0x72, 0x86, 0x17, 0xBE, 0xFE, 0xA3, 0x30, 0x20, 0xEF, 0x04,
  0x38, 0x4D, 0xE9, 0x66, 0xAA, 0x0D, 0x30, 0x25, 0x09, 0xA0, 0x37, 0x10, 0x3A, 0x06, 0x71, 0x02,
  0xA0, 0x77, 0x10, 0x1A, 0x07, 0x28, 0x21, 0x7B, 0xED, 0x82, 0x80, 0x3E, 0xF9, 0x81, 0x80, 0xEA,
  0x83, 0xD8, 0x65, 0x6A, 0x08, 0x06, 0xA0, 0xB4, 0x01, 0xA0, 0x80, 0xAA, 0x02, 0x40, 0x2A, 0x08,
  0x0B, 0xA5, 0x04, 0xA0, 0x80, 0xBA, 0x50, 0x8A, 0x00, 0x8A, 0x05, 0x30, 0x3B, 0x08, 0x03, 0xB8,
  0x90, 0x86, 0x8F, 0xBD, 0xF8, 0x09, 0xD8, 0x3D, 0x1B, 0xF8, 0x28, 0x90, 0x7D, 0xFD, 0x91, 0x08,
  0xF8,
  // "â" (U+00E2)
  0x58, 0x24, 0x77, 0x17, 0x01, 0x0E, 0xA0, 0x97, 0x09, 0xC0, 0x35, 0x03, 0xA8, 0x24, 0x9F, 0xC5,
  0x81, 0xDF, 0x52, 0x81, 0xAF, 0x83, 0x81, 0x9F, 0x64, 0x81, 0xAF, 0x37, 0x77, 0x58, 0x61, 0x7B,
  0xEF, 0xEA, 0x33, 0x02, 0x0E, 0xF0, 0x43, 0x84, 0xDE, 0x96, 0x6A, 0xA0, 0xD3, 0x02, 0x50, 0x9A,
  0x03, 0x71, 0x03, 0xA0, 0x67, 0x10, 0x2A, 0x07, 0x71, 0x01, 0xA0, 0x72, 0x82, 0x17, 0xBE, 0xD8,
  0x28, 0x03, 0xEF, 0x98, 0x18, 0x0E, 0xA8, 0x3D, 0x86, 0x56, 0xA0, 0x80, 0x6A, 0x0B, 0x40, 0x1A,
  0x08, 0x0A, 0xA0, 0x24, 0x02, 0xA0, 0x80, 0xBA, 0x50, 0x4A, 0x08, 0x0B, 0xA5, 0x08, 0xA0, 0x08,
  0xA0, 0x53, 0x03, 0xB0, 0x80, 0x3B, 0x89, 0x08, 0x68, 0xFB, 0xDF, 0x80, 0x9D, 0x83, 0xD1, 0xBF,
  0x82, 0x89, 0x07, 0xDF, 0xD9, 0x10, 0x8F, 0x80,
  // "ã" (U+00E3)
  0x28, 0x34, 0xDE, 0xA2, 0x28, 0x15, 0xF5, 0x20, 0xEC, 0x89, 0x19, 0x6D, 0xF2, 0x06, 0xFB, 0x6C,
  0xC0, 0xB2, 0x81, 0x9F, 0x12, 0x83, 0x5C, 0xFB, 0x17, 0x77, 0x68, 0x61, 0x7B, 0xEF, 0xEA, 0x33,
  0x02, 0x0E, 0xF0, 0x43, 0x84, 0xDE, 0x96, 0x6A, 0xA0, 0xD3, 0x02, 0x50, 0x9A, 0x03, 0x71, 0x03,
  0xA0, 0x67, 0x10, 0x2A, 0x07, 0x71, 0x01, 0xA0, 0x72, 0x82, 0x17, 0xBE, 0xD8, 0x28, 0x03, 0xEF,
  0x98, 0x18, 0x0E, 0xA8, 0x3D, 0x86, 0x56, 0xA0, 0x80, 0x6A, 0x0B, 0x40, 0x1A, 0x08, 0x0A, 0xA0,
  0x24, 0x02, 0xA0, 0x80, 0xBA, 0x50, 0x4A, 0x08, 0x0B, 0xA5, 0x08, 0xA0, 0x08, 0xA0, 0x53, 0x03,
  0xB0, 0x80, 0x3B, 0x89, 0x08, 0x68, 0xFB, 0xDF, 0x80, 0x9D, 0x83, 0xD1, 0xBF, 0x82, 0x89, 0x07,
  0xDF, 0xD9, 0x10, 0x8F, 0x80,
  // "ä" (U+00E4)
  0x28, 0x22, 0xEC, 0x12, 0x81, 0xAE, 0x63, 0x06, 0xA0, 0x32, 0xA0, 0xB3, 0x81, 0x2D, 0xC3, 0x81,
  0xAE, 0x57, 0x77, 0x68, 0x61, 0x7B, 0xEF, 0xEA, 0x33, 0x02, 0x0E, 0xF0, 0x43, 0x84, 0xDE, 0x96,
  0x6A, 0xA0, 0xD3, 0x02, 0x50, 0x9A, 0x03, 0x71, 0x03, 0xA0, 0x67, 0x10, 0x2A, 0x07, 0x71, 0x01,
  0xA0, 0x72, 0x82, 0x17, 0xBE, 0xD8, 0x28, 0x03, 0xEF, 0x98, 0x18, 0x0E, 0xA8, 0x3D, 0x86, 0x56,
  0xA0, 0x80, 0x6A, 0x0B, 0x40, 0x1A, 0x08, 0x0A, 0xA0, 0x24, 0x02, 0xA0, 0x80, 0xBA, 0x50, 0x4A,
  0x08, 0x0B, 0xA5, 0x08, 0xA0, 0x08, 0xA0, 0x53, 0x03, 0xB0, 0x80, 0x3B, 0x89, 0x08, 0x68, 0xFB,
  0xDF, 0x80, 0x9D, 0x83, 0xD1, 0xBF, 0x82, 0x89, 0x07, 0xDF, 0xD9, 0x10, 0x8F, 0x80,
  // "å" (U+00E5)
  0x48, 0x32, 0x9C, 0xA4, 0x60, 0x10, 0xEC, 0x06, 0x58, 0x58, 0xF7, 0x03, 0xEE, 0x50, 0xA9, 0x30,
  0x99, 0x58, 0x58, 0xF4, 0x01, 0xDE, 0x50, 0x2A, 0x0D, 0xA0, 0x76, 0x83, 0x4C, 0xED, 0x77, 0x77,
  0x71, 0x86, 0x17, 0xBE, 0xFE, 0xA3, 0x30, 0x20, 0xEF, 0x04, 0x38, 0x4D, 0xE9, 0x66, 0xAA, 0x0D,
  0x30, 0x25, 0x09, 0xA0, 0x37, 0x10, 0x3A, 0x06, 0x71, 0x02, 0xA0, 0x77, 0x10, 0x1A, 0x07, 0x28,
  0x21, 0x7B, 0xED, 0x82, 0x80, 0x3E, 0xF9, 0x81, 0x80, 0xEA, 0x83, 0xD8, 0x65, 0x6A, 0x08, 0x06,
  0xA0, 0xB4, 0x01, 0xA0, 0x80, 0xAA, 0x02, 0x40, 0x2A, 0x08, 0x0B, 0xA5, 0x04, 0xA0, 0x80, 0xBA,
  0x50, 0x8A, 0x00, 0x8A, 0x05, 0x30, 0x3B, 0x08, 0x03, 0xB8, 0x90, 0x86, 0x8F, 0xBD, 0xF8, 0x09,
  0xD8, 0x3D, 0x1B, 0xF8, 0x28, 0x90, 0x7D, 0xFD, 0x91, 0x08, 0xF8,
  // "æ" (U+00E6)
  0x28, 0x52, 0x8C, 0xEF, 0xD7, 0x38, 0x47, 0xCE, 0xDA, 0x24, 0x04, 0xF8, 0x1A, 0x0B, 0xE0, 0x53,
  0x85, 0x1E, 0xE8, 0x66, 0xCA, 0x0B, 0xA8, 0x29, 0x67, 0xEA, 0x02, 0x30, 0x35, 0x0C, 0xB0, 0x63,
  0x82, 0x2E, 0xF9, 0x72, 0x06, 0xA0, 0xD5, 0x81, 0x9F, 0xE7, 0x20, 0x4A, 0x09, 0x50, 0x5A, 0x02,
  0x71, 0x04, 0xA0, 0x75, 0x03, 0xA0, 0x42, 0x82, 0x17, 0xCE, 0xFF, 0x82, 0x50, 0x3E, 0xFF, 0xB8,
  0x15, 0x1E, 0xA8, 0x3C, 0x75, 0x58, 0xA0, 0x98, 0x04, 0x50, 0x20, 0x6A, 0x0A, 0x40, 0x4A, 0x07,
  0x72, 0x0A, 0xA0, 0x24, 0x04, 0xA0, 0x97, 0x20, 0xBA, 0x50, 0x6A, 0x0C, 0x72, 0x0B, 0xA5, 0x0B,
  0xB0, 0x27, 0x10, 0x8A, 0x05, 0x38, 0x14, 0xFC, 0xA0, 0xC6, 0x81, 0x30, 0x3A, 0x82, 0xE8, 0x69,
  0xA0, 0x20, 0x7A, 0x85, 0xD7, 0x56, 0x9E, 0xA2, 0x09, 0xE0, 0x42, 0x09, 0xF0, 0xA3, 0x84, 0x7D,
  0xFD, 0xA3, 0x48, 0x54, 0xBD, 0xFE, 0xB6, 0x20,
  // "ç" (U+00E7)
  0x38, 0x61, 0x7C, 0xEE, 0xC8, 0x22, 0x02, 0x0D, 0xE0, 0x52, 0x0D, 0xA8, 0x3B, 0x66, 0xAE, 0x20,
  0x7A, 0x09, 0x78, 0x1D, 0xFE, 0x70, 0x2A, 0x09, 0x70, 0x4A, 0x06, 0x70, 0x6A, 0x04, 0x70, 0x7A,
  0x03, 0x70, 0x7A, 0x03, 0x70, 0x6A, 0x04, 0x70, 0x5A, 0x06, 0x70, 0x2A, 0x09, 0x71, 0x81, 0xEF,
  0xE7, 0x10, 0x9A, 0x08, 0x70, 0x10, 0xEA, 0x84, 0xB6, 0x68, 0xD5, 0x20, 0x30, 0xEE, 0x05, 0x38,
  0x61, 0x8D, 0xFE, 0xC7, 0x15, 0x0A, 0x0E, 0x71, 0x82, 0x2F, 0xB1, 0x78, 0x34, 0xBF, 0xE4, 0x71,
  0x81, 0x4F, 0xE7, 0x10, 0x1A, 0x01, 0x48, 0x24, 0x56, 0xCA, 0x50, 0x9C, 0x08, 0x58, 0x38, 0xEE,
  0xC6, 0x30,
  // "è" (U+00E8)
  0x28, 0x25, 0x77, 0x47, 0x20, 0x5A, 0x0E, 0x73, 0x09, 0xA0, 0x77, 0x38, 0x2B, 0xFE, 0x17, 0x38,
  0x1C, 0xF9, 0x73, 0x82, 0x1C, 0xF3, 0x77, 0x77, 0x58, 0x51, 0x9D, 0xFD, 0xA2, 0x50, 0x30, 0xEE,
  0x04, 0x40, 0xEA, 0x82, 0x86, 0x7E, 0xA0, 0x12, 0x07, 0xA0, 0x33, 0x02, 0xA0, 0x92, 0x81, 0xDF,
  0xA5, 0x83, 0xAF, 0xE0, 0x2A, 0x06, 0x50, 0x5A, 0x02, 0x04, 0xA0, 0x35, 0x03, 0xA0, 0x40, 0x6F,
  0xC0, 0x50, 0x7F, 0xC0, 0x50, 0x7A, 0x07, 0x80, 0x45, 0x02, 0x06, 0xA0, 0x37, 0x20, 0x4A, 0x05,
  0x72, 0x01, 0xA0, 0x97, 0x38, 0x1C, 0xFE, 0x73, 0x05, 0xA0, 0xA6, 0x04, 0x30, 0xCA, 0x85, 0xC7,
  0x56, 0xAE, 0xA3, 0x01, 0x0C, 0xF0, 0xA5, 0x85, 0x7C, 0xEF, 0xEB, 0x62,
  // "é" (U+00E9)
  0x71, 0x0F, 0x70, 0x27, 0x10, 0x5A, 0x0D, 0x01, 0x71, 0x0D, 0xA0, 0x37, 0x10, 0x6A, 0x06, 0x71,
  0x82, 0x1E, 0xF8, 0x72, 0x81, 0x9F, 0x87, 0x77, 0x76, 0x85, 0x19, 0xDF, 0xDA, 0x25, 0x03, 0x0E,
  0xE0, 0x44, 0x0E, 0xA8, 0x28, 0x67, 0xEA, 0x01, 0x20, 0x7A, 0x03, 0x30, 0x2A, 0x09, 0x28, 0x1D,
  0xFA, 0x58, 0x3A, 0xFE, 0x02, 0xA0, 0x65, 0x05, 0xA0, 0x20, 0x4A, 0x03, 0x50, 0x3A, 0x04, 0x06,
  0xFC, 0x05, 0x07, 0xFC, 0x05, 0x07, 0xA0, 0x78, 0x04, 0x50, 0x20, 0x6A, 0x03, 0x72, 0x04, 0xA0,
  0x57, 0x20, 0x1A, 0x09, 0x73, 0x81, 0xCF, 0xE7, 0x30, 0x5A, 0x0A, 0x60, 0x43, 0x0C, 0xA8, 0x5C,
  0x75, 0x6A, 0xEA, 0x30, 0x10, 0xCF, 0x0A, 0x58, 0x57, 0xCE, 0xFE, 0xB6, 0x20,
  // "ê" (U+00EA)
  0x58, 0x24, 0x77, 0x17, 0x10, 0x10, 0xEA, 0x09, 0x71, 0x09, 0xC0, 0x36, 0x03, 0xA8, 0x24, 0x9F,
  0xC6, 0x81, 0xDF, 0x52, 0x81, 0xAF, 0x84, 0x81, 0x9F, 0x64, 0x81, 0xAF, 0x37, 0x77, 0x72, 0x85,
  0x19, 0xDF, 0xDA, 0x25, 0x03, 0x0E, 0xE0, 0x44, 0x0E, 0xA8, 0x28, 0x67, 0xEA, 0x01, 0x20, 0x7A,
  0x03, 0x30, 0x2A, 0x09, 0x28, 0x1D, 0xFA, 0x58, 0x3A, 0xFE, 0x02, 0xA0, 0x65, 0x05, 0xA0, 0x20,
  0x4A, 0x03, 0x50, 0x3A, 0x04, 0x06, 0xFC, 0x05, 0x07, 0xFC, 0x05, 0x07, 0xA0, 0x78, 0x04, 0x50,
  0x20, 0x6A, 0x03, 0x72, 0x04, 0xA0, 0x57, 0x20, 0x1A, 0x09, 0x73, 0x81, 0xCF, 0xE7, 0x30, 0x5A,
  0x0A, 0x60, 0x43, 0x0C, 0xA8, 0x5C, 0x75, 0x6A, 0xEA, 0x30, 0x10, 0xCF, 0x0A, 0x58, 0x57, 0xCE,
  0xFE, 0xB6, 0x20,
  // "ë" (U+00EB)
  0x28, 0x22, 0xEC, 0x12, 0x81, 0xAE, 0x64, 0x06, 0xA0, 0x32, 0xA0, 0xB4, 0x81, 0x2D, 0xC3, 0x81,
  0xAE, 0x57, 0x77, 0x73, 0x85, 0x19, 0xDF, 0xDA, 0x25, 0x03, 0x0E, 0xE0, 0x44, 0x0E, 0xA8, 0x28,
  0x67, 0xEA, 0x01, 0x20, 0x7A, 0x03, 0x30, 0x2A, 0x09, 0x28, 0x1D, 0xFA, 0x58, 0x3A, 0xFE, 0x02,
  0xA0, 0x65, 0x05, 0xA0, 0x20, 0x4A, 0x03, 0x50, 0x3A, 0x04, 0x06, 0xFC, 0x05, 0x07, 0xFC, 0x05,
  0x07, 0xA0, 0x78, 0x04, 0x50, 0x20, 0x6A, 0x03, 0x72, 0x04, 0xA0, 0x57, 0x20, 0x1A, 0x09, 0x73,
  0x81, 0xCF, 0xE7, 0x30, 0x5A, 0x0A, 0x60, 0x43, 0x0C, 0xA8, 0x5C, 0x75, 0x6A, 0xEA, 0x30, 0x10,
  0xCF, 0x0A, 0x58, 0x57, 0xCE, 0xFE, 0xB6, 0x20,
  // "ì" (U+00EC)
  0x82, 0x57, 0x74, 0x30, 0x5A, 0x0E, 0x40, 0x9A, 0x07, 0x48, 0x2B, 0xFE, 0x14, 0x81, 0xCF, 0x94,
  0x82, 0x1C, 0xF3, 0x77, 0x38, 0x1B, 0xFE, 0x48, 0x1B, 0xFE, 0x48, 0x1B, 0xFE, 0x48, 0x1B, 0xFE,
  0x48, 0x1B, 0xFE, 0x48, 0x1B, 0xFE, 0x48, 0x1B, 0xFE, 0x48, 0x1B, 0xFE, 0x48, 0x1B, 0xFE, 0x48,
  0x1B, 0xFE, 0x48, 0x1B, 0xFE, 0x48, 0x1B, 0xFE, 0x48, 0x1B, 0xFE, 0x48, 0x1B, 0xFE, 0x48, 0x1B,
  0xFE, 0x48, 0x1B, 0xFE, 0x48, 0x1B, 0xFE, 0x48, 0x1B, 0xFE, 0x10,
  // "í" (U+00ED)
  0x30, 0xF7, 0x02, 0x20, 0x5A, 0x0D, 0x01, 0x20, 0xDA, 0x03, 0x20, 0x6A, 0x06, 0x28, 0x21, 0xEF,
  0x83, 0x81, 0x9F, 0x87, 0x74, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF,
  0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4,
  0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81,
  0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4,
  // "î" (U+00EE)
  0x38, 0x24, 0x77, 0x15, 0x01, 0x0E, 0xA0, 0x95, 0x09, 0xC0, 0x33, 0x03, 0xA8, 0x24, 0x9F, 0xC3,
  0x81, 0xDF, 0x52, 0x85, 0xAF, 0x80, 0x9F, 0x64, 0x81, 0xAF, 0x37, 0x77, 0x28, 0x1B, 0xFE, 0x78,
  0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B,
  0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE,
  0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78,
  0x1B, 0xFE, 0x40,
  // "ï" (U+00EF)
  0x82, 0x2E, 0xC1, 0x28, 0x2A, 0xE6, 0x6A, 0x03, 0x2A, 0x82, 0xB2, 0xDC, 0x38, 0x1A, 0xE5, 0x77,
  0x78, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68,
  0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B,
  0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE,
  0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x30,
  // "ð" (U+00F0)
  0x40, 0x35, 0x03, 0x68, 0x71, 0xED, 0x40, 0x3C, 0xE2, 0x50, 0x20, 0xDA, 0x0B, 0xA0, 0xB0, 0x27,
  0x0B, 0xB0, 0x57, 0x10, 0x8C, 0x05, 0x78, 0x6C, 0xFE, 0x6C, 0xFE, 0x26, 0x86, 0x6B, 0x10, 0x1E,
  0xFC, 0x74, 0x06, 0xA0, 0x47, 0x48, 0x1D, 0xFB, 0x74, 0x06, 0xA0, 0x34, 0x85, 0x29, 0xDF, 0xD9,
  0x3A, 0x08, 0x30, 0x5E, 0x82, 0xDE, 0xFC, 0x20, 0x2B, 0x82, 0xA6, 0x7C, 0xC2, 0x0B, 0xA0, 0x54,
  0x09, 0xB0, 0x20, 0x1A, 0x0B, 0x60, 0xEA, 0x03, 0x04, 0xA0, 0x66, 0x09, 0xA0, 0x50, 0x6A, 0x03,
  0x60, 0x6A, 0x05, 0x07, 0xA0, 0x26, 0x05, 0xA0, 0x50, 0x7A, 0x03, 0x60, 0x5A, 0x04, 0x06, 0xA0,
  0x46, 0x06, 0xA0, 0x20, 0x3A, 0x07, 0x60, 0x9A, 0x28, 0x1E, 0xFD, 0x68, 0x1D, 0xFB, 0x20, 0x8A,
  0x06, 0x40, 0x7A, 0x05, 0x30, 0xDA, 0x82, 0xA6, 0x6A, 0xA0, 0xC4, 0x02, 0x0D, 0xE0, 0xC0, 0x15,
  0x85, 0x18, 0xDF, 0xEC, 0x74,
  // "ñ" (U+00F1)
  0x28, 0x34, 0xDE, 0xA2, 0x28, 0x15, 0xF5, 0x20, 0xEC, 0x89, 0x19, 0x6D, 0xF2, 0x06, 0xFB, 0x6C,
  0xC0, 0xB2, 0x81, 0x9F, 0x12, 0x83, 0x5C, 0xFB, 0x17, 0x77, 0x48, 0x90, 0xBF, 0x70, 0x2A, 0xEF,
  0xC7, 0x28, 0x3B, 0xF9, 0x3E, 0xD8, 0x91, 0xA0, 0xBF, 0xCD, 0xE8, 0x67, 0xEA, 0x04, 0x0B, 0xA0,
  0xE0, 0x23, 0x05, 0xA0, 0xA0, 0xBA, 0x07, 0x58, 0x2E, 0xFC, 0xBA, 0x03, 0x58, 0x2B, 0xFE, 0xBA,
  0x68, 0x2B, 0xFE, 0xBA, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE,
  0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68,
  0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB,
  0xFE, 0x68, 0x1A, 0xFE,
  // "ò" (U+00F2)
  0x38, 0x25, 0x77, 0x47, 0x30, 0x5A, 0x0E, 0x74, 0x09, 0xA0, 0x77, 0x48, 0x2B, 0xFE, 0x17, 0x48,
  0x1C, 0xF9, 0x74, 0x82, 0x1C, 0xF3, 0x77, 0x77, 0x78, 0x51, 0x8D, 0xEE, 0xC6, 0x60, 0x30, 0xEE,
  0x0B, 0x40, 0x10, 0xEA, 0x82, 0xA6, 0x6C, 0xA0, 0xA3, 0x08, 0xA0, 0x74, 0x0A, 0xA0, 0x42, 0x81,
  0xDF, 0xD5, 0x01, 0xA8, 0x1A, 0x02, 0xA0, 0x86, 0x83, 0xCF, 0xE0, 0x5A, 0x05, 0x60, 0x8A, 0x01,
  0x07, 0xA0, 0x36, 0x07, 0xA0, 0x30, 0x7A, 0x03, 0x60, 0x6A, 0x04, 0x07, 0xA0, 0x36, 0x06, 0xA0,
  0x40, 0x7A, 0x03, 0x60, 0x7A, 0x03, 0x05, 0xA0, 0x56, 0x08, 0xA0, 0x10, 0x2A, 0x08, 0x68, 0x1C,
  0xFE, 0x28, 0x1D, 0xFD, 0x50, 0x1A, 0x09, 0x20, 0x7A, 0x07, 0x40, 0xAA, 0x03, 0x30, 0xDA, 0x82,
  0xA6, 0x6C, 0xA0, 0xA4, 0x02, 0x0D, 0xE0, 0xB7, 0x84, 0x8D, 0xEE, 0xC6, 0x40,
  // "ó" (U+00F3)
  0x71, 0x0F, 0x70, 0x27, 0x20, 0x5A, 0x0D, 0x01, 0x72, 0x0D, 0xA0, 0x37, 0x20, 0x6A, 0x06, 0x72,
  0x82, 0x1E, 0xF8, 0x73, 0x81, 0x9F, 0x88, 0x0C, 0x10, 0x85, 0x18, 0xDE, 0xEC, 0x66, 0x03, 0x0E,
  0xE0, 0xB4, 0x01, 0x0E, 0xA8, 0x2A, 0x66, 0xCA, 0x0A, 0x30, 0x8A, 0x07, 0x40, 0xAA, 0x04, 0x28,
  0x1D, 0xFD, 0x50, 0x1A, 0x81, 0xA0, 0x2A, 0x08, 0x68, 0x3C, 0xFE, 0x05, 0xA0, 0x56, 0x08, 0xA0,
  0x10, 0x7A, 0x03, 0x60, 0x7A, 0x03, 0x07, 0xA0, 0x36, 0x06, 0xA0, 0x40, 0x7A, 0x03, 0x60, 0x6A,
  0x04, 0x07, 0xA0, 0x36, 0x07, 0xA0, 0x30, 0x5A, 0x05, 0x60, 0x8A, 0x01, 0x02, 0xA0, 0x86, 0x81,
  0xCF, 0xE2, 0x81, 0xDF, 0xD5, 0x01, 0xA0, 0x92, 0x07, 0xA0, 0x74, 0x0A, 0xA0, 0x33, 0x0D, 0xA8,
  0x2A, 0x66, 0xCA, 0x0A, 0x40, 0x20, 0xDE, 0x0B, 0x78, 0x48, 0xDE, 0xEC, 0x64,
  // "ô" (U+00F4)
  0x58, 0x24, 0x77, 0x17, 0x20, 0x10, 0xEA, 0x09, 0x72, 0x09, 0xC0, 0x37, 0x03, 0xA8, 0x24, 0x9F,
  0xC7, 0x81, 0xDF, 0x52, 0x81, 0xAF, 0x85, 0x81, 0x9F, 0x64, 0x81, 0xAF, 0x37, 0x77, 0x75, 0x85,
  0x18, 0xDE, 0xEC, 0x66, 0x03, 0x0E, 0xE0, 0xB4, 0x01, 0x0E, 0xA8, 0x2A, 0x66, 0xCA, 0x0A, 0x30,
  0x8A, 0x07, 0x40, 0xAA, 0x04, 0x28, 0x1D, 0xFD, 0x50, 0x1A, 0x81, 0xA0, 0x2A, 0x08, 0x68, 0x3C,
  0xFE, 0x05, 0xA0, 0x56, 0x08, 0xA0, 0x10, 0x7A, 0x03, 0x60, 0x7A, 0x03, 0x07, 0xA0, 0x36, 0x06,
  0xA0, 0x40, 0x7A, 0x03, 0x60, 0x6A, 0x04, 0x07, 0xA0, 0x36, 0x07, 0xA0, 0x30, 0x5A, 0x05, 0x60,
  0x8A, 0x01, 0x02, 0xA0, 0x86, 0x81, 0xCF, 0xE2, 0x81, 0xDF, 0xD5, 0x01, 0xA0, 0x92, 0x07, 0xA0,
  0x74, 0x0A, 0xA0, 0x33, 0x0D, 0xA8, 0x2A, 0x66, 0xCA, 0x0A, 0x40, 0x20, 0xDE, 0x0B, 0x78, 0x48,
  0xDE, 0xEC, 0x64,
  // "õ" (U+00F5)
  0x38, 0x34, 0xDE, 0xA2, 0x28, 0x15, 0xF5, 0x40, 0xEC, 0x83, 0x96, 0xDF, 0x23, 0x83, 0x6F, 0xB6,
  0xCC, 0x0B, 0x48, 0x19, 0xF1, 0x28, 0x35, 0xCF, 0xB1, 0x77, 0x77, 0x58, 0x51, 0x8D, 0xEE, 0xC6,
  0x60, 0x30, 0xEE, 0x0B, 0x40, 0x10, 0xEA, 0x82, 0xA6, 0x6C, 0xA0, 0xA3, 0x08, 0xA0, 0x74, 0x0A,
  0xA0, 0x42, 0x81, 0xDF, 0xD5, 0x01, 0xA8, 0x1A, 0x02, 0xA0, 0x86, 0x83, 0xCF, 0xE0, 0x5A, 0x05,
  0x60, 0x8A, 0x01, 0x07, 0xA0, 0x36, 0x07, 0xA0, 0x30, 0x7A, 0x03, 0x60, 0x6A, 0x04, 0x07, 0xA0,
  0x36, 0x06, 0xA0, 0x40, 0x7A, 0x03, 0x60, 0x7A, 0x03, 0x05, 0xA0, 0x56, 0x08, 0xA0, 0x10, 0x2A,
  0x08, 0x68, 0x1C, 0xFE, 0x28, 0x1D, 0xFD, 0x50, 0x1A, 0x09, 0x20, 0x7A, 0x07, 0x40, 0xAA, 0x03,
  0x30, 0xDA, 0x82, 0xA6, 0x6C, 0xA0, 0xA4, 0x02, 0x0D, 0xE0, 0xB7, 0x84, 0x8D, 0xEE, 0xC6, 0x40,
  // "ö" (U+00F6)
  0x28, 0x22, 0xEC, 0x12, 0x81, 0xAE, 0x65, 0x06, 0xA0, 0x32, 0xA0, 0xB5, 0x81, 0x2D, 0xC3, 0x81,
  0xAE, 0x57, 0x77, 0x76, 0x85, 0x18, 0xDE, 0xEC, 0x66, 0x03, 0x0E, 0xE0, 0xB4, 0x01, 0x0E, 0xA8,
  0x2A, 0x66, 0xCA, 0x0A, 0x30, 0x8A, 0x07, 0x40, 0xAA, 0x04, 0x28, 0x1D, 0xFD, 0x50, 0x1A, 0x81,
  0xA0, 0x2A, 0x08, 0x68, 0x3C, 0xFE, 0x05, 0xA0, 0x56, 0x08, 0xA0, 0x10, 0x7A, 0x03, 0x60, 0x7A,
  0x03, 0x07, 0xA0, 0x36, 0x06, 0xA0, 0x40, 0x7A, 0x03, 0x60, 0x6A, 0x04, 0x07, 0xA0, 0x36, 0x07,
  0xA0, 0x30, 0x5A, 0x05, 0x60, 0x8A, 0x01, 0x02, 0xA0, 0x86, 0x81, 0xCF, 0xE2, 0x81, 0xDF, 0xD5,
  0x01, 0xA0, 0x92, 0x07, 0xA0, 0x74, 0x0A, 0xA0, 0x33, 0x0D, 0xA8, 0x2A, 0x66, 0xCA, 0x0A, 0x40,
  0x20, 0xDE, 0x0B, 0x78, 0x48, 0xDE, 0xEC, 0x64,
  // "÷" (U+00F7)
  0x58, 0x18, 0xEA, 0x73, 0xB0, 0x27, 0x2B, 0x02, 0x72, 0x81, 0x8E, 0x98, 0x0D, 0x00, 0x0D, 0xFC,
  0x0E, 0x0D, 0xFC, 0x0E, 0x04, 0x80, 0x90, 0x57, 0x77, 0x73, 0x81, 0x8E, 0xA7, 0x3B, 0x02, 0x72,
  0xB0, 0x27, 0x28, 0x18, 0xEA, 0x50,
  // "ø" (U+00F8)
  0x74, 0x0C, 0x07, 0x48, 0x90, 0x18, 0xDE, 0xEB, 0x46, 0xFB, 0x30, 0x30, 0xEE, 0x81, 0xEF, 0x32,
  0x01, 0x0E, 0xA8, 0x2A, 0x67, 0xCA, 0x0C, 0x30, 0x8A, 0x06, 0x30, 0x1B, 0x02, 0x28, 0x1E, 0xFC,
  0x40, 0x8B, 0x81, 0x80, 0x3A, 0x07, 0x38, 0x61, 0xFE, 0xCF, 0xD0, 0x6A, 0x04, 0x38, 0x2A, 0xF7,
  0x8A, 0x01, 0x07, 0xA0, 0x22, 0x83, 0x3F, 0xD0, 0x7A, 0x03, 0x08, 0xA0, 0x22, 0x83, 0xCF, 0x50,
  0x6A, 0x04, 0x08, 0xA8, 0x32, 0x05, 0xFB, 0x20, 0x5A, 0x04, 0x07, 0xA8, 0x33, 0x0D, 0xF3, 0x20,
  0x6A, 0x03, 0x05, 0xA8, 0x25, 0x7F, 0x93, 0x08, 0xA0, 0x10, 0x2A, 0x82, 0xAE, 0xE1, 0x38, 0x1B,
  0xFE, 0x20, 0xDB, 0x07, 0x30, 0x1A, 0x09, 0x20, 0x6A, 0x0E, 0x40, 0xAA, 0x03, 0x30, 0xEA, 0x82,
  0xA6, 0x6C, 0xA0, 0xA3, 0x04, 0xF9, 0x0B, 0x48, 0x7C, 0xF5, 0x7C, 0xEE, 0xB6, 0x48, 0x12, 0xFC,
  0x75, 0x02, 0x03, 0x74,
  // "ù" (U+00F9)
  0x28, 0x25, 0x77, 0x47, 0x10, 0x5A, 0x0E, 0x72, 0x09, 0xA0, 0x77, 0x28, 0x2B, 0xFE, 0x17, 0x28,
  0x1C, 0xF9, 0x72, 0x82, 0x1C, 0xF3, 0x77, 0x76, 0x81, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68,
  0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC,
  0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84,
  0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xDF, 0xDC, 0xFD, 0x68, 0x4E, 0xFD, 0xCF,
  0xE5, 0x01, 0xA0, 0xD0, 0xAA, 0x01, 0x40, 0x6A, 0x0D, 0x07, 0xA0, 0x73, 0x01, 0x0D, 0xA0, 0xD0,
  0x1B, 0x89, 0x08, 0x57, 0xDF, 0xBF, 0xD0, 0x7E, 0x82, 0x67, 0xFD, 0x28, 0x90, 0x5C, 0xEE, 0xB4,
  0x05, 0xFD,
  // "ú" (U+00FA)
  0x70, 0xF7, 0x02, 0x70, 0x5A, 0x0D, 0x01, 0x70, 0xDA, 0x03, 0x70, 0x6A, 0x06, 0x78, 0x21, 0xEF,
  0x87, 0x18, 0x19, 0xF8, 0x77, 0x77, 0x18, 0x1C, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF,
  0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6,
  0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD,
  0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4D, 0xFD, 0xCF, 0xD6, 0x84, 0xEF, 0xDC, 0xFE, 0x50,
  0x1A, 0x0D, 0x0A, 0xA0, 0x14, 0x06, 0xA0, 0xD0, 0x7A, 0x07, 0x30, 0x10, 0xDA, 0x0D, 0x01, 0xB8,
  0x90, 0x85, 0x7D, 0xFB, 0xFD, 0x07, 0xE8, 0x26, 0x7F, 0xD2, 0x89, 0x05, 0xCE, 0xEB, 0x40, 0x5F,
  0xD0,
  // "û" (U+00FB)
  0x48, 0x24, 0x77, 0x17, 0x01, 0x0E, 0xA0, 0x97, 0x09, 0xC0, 0x35, 0x03, 0xA8, 0x24, 0x9F, 0xC5,
  0x81, 0xDF, 0x52, 0x81, 0xAF, 0x83, 0x81, 0x9F, 0x64, 0x81, 0xAF, 0x37, 0x77, 0x48, 0x1C, 0xFC,
  0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF,
  0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6,
  0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4D, 0xFD,
  0xCF, 0xD6, 0x84, 0xEF, 0xDC, 0xFE, 0x50, 0x1A, 0x0D, 0x0A, 0xA0, 0x14, 0x06, 0xA0, 0xD0, 0x7A,
  0x07, 0x30, 0x10, 0xDA, 0x0D, 0x01, 0xB8, 0x90, 0x85, 0x7D, 0xFB, 0xFD, 0x07, 0xE8, 0x26, 0x7F,
  0xD2, 0x89, 0x05, 0xCE, 0xEB, 0x40, 0x5F, 0xD0,
  // "ü" (U+00FC)
  0x18, 0x22, 0xEC, 0x12, 0x81, 0xAE, 0x63, 0x06, 0xA0, 0x32, 0xA0, 0xB3, 0x81, 0x2D, 0xC3, 0x81,
  0xAE, 0x57, 0x77, 0x58, 0x1C, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68,
  0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC,
  0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84,
  0xCF, 0xDC, 0xFC, 0x68, 0x4D, 0xFD, 0xCF, 0xD6, 0x84, 0xEF, 0xDC, 0xFE, 0x50, 0x1A, 0x0D, 0x0A,
  0xA0, 0x14, 0x06, 0xA0, 0xD0, 0x7A, 0x07, 0x30, 0x10, 0xDA, 0x0D, 0x01, 0xB8, 0x90, 0x85, 0x7D,
  0xFB, 0xFD, 0x07, 0xE8, 0x26, 0x7F, 0xD2, 0x89, 0x05, 0xCE, 0xEB, 0x40, 0x5F, 0xD0,
  // "ý" (U+00FD)
  0x71, 0x0F, 0x70, 0x27, 0x10, 0x5A, 0x0D, 0x01, 0x71, 0x0D, 0xA0, 0x37, 0x10, 0x6A, 0x06, 0x71,
  0x82, 0x1E, 0xF8, 0x72, 0x81, 0x9F, 0x87, 0x77, 0x73, 0x0B, 0xA7, 0x82, 0xCF, 0xE7, 0xA0, 0x46,
  0xA0, 0xA0, 0x2A, 0x08, 0x50, 0x4A, 0x83, 0x60, 0xDF, 0xC5, 0x08, 0xA8, 0x11, 0x09, 0xA0, 0x14,
  0x81, 0xCF, 0xC2, 0x04, 0xA0, 0x53, 0x01, 0xA0, 0x83, 0xA0, 0x93, 0x05, 0xA0, 0x43, 0x81, 0xBF,
  0xD3, 0x81, 0x9F, 0xE4, 0x06, 0xA0, 0x22, 0x81, 0xDF, 0xB4, 0x02, 0xA8, 0x16, 0x01, 0xA0, 0x65,
  0x83, 0xDF, 0xA0, 0x5A, 0x02, 0x58, 0x58, 0xFE, 0x09, 0xFD, 0x60, 0x4A, 0x82, 0x2D, 0xF9, 0x78,
  0x1E, 0xF6, 0xA0, 0x47, 0x81, 0xAF, 0xDA, 0x71, 0x06, 0xB0, 0xB7, 0x10, 0x1B, 0x07, 0x72, 0x0C,
  0xA0, 0x37, 0x28, 0x1C, 0xFE, 0x72, 0x01, 0xA0, 0x97, 0x20, 0x5A, 0x05, 0x72, 0x0B, 0xA7, 0x20,
  0x3A, 0x0A, 0x68, 0x24, 0x57, 0xEA, 0x02, 0x60, 0x9C, 0x07, 0x78, 0x37, 0xEF, 0xC5, 0x71,
  // "þ" (U+00FE)
  0x81, 0xBF, 0xE7, 0x38, 0x1B, 0xFE, 0x73, 0x81, 0xBF, 0xE7, 0x38, 0x1B, 0xFE, 0x73, 0x81, 0xBF,
  0xE7, 0x38, 0x1B, 0xFE, 0x73, 0x81, 0xBF, 0xE7, 0x38, 0x90, 0xBF, 0xE0, 0x2A, 0xEE, 0xC6, 0x38,
  0x3B, 0xFD, 0x3E, 0xD0, 0xA2, 0x87, 0xBF, 0xDD, 0xE8, 0x67, 0xEA, 0x81, 0x60, 0xBA, 0x0E, 0x02,
  0x38, 0x42, 0xEF, 0xD0, 0xBA, 0x08, 0x50, 0x8A, 0x03, 0x0B, 0xA0, 0x35, 0x04, 0xA0, 0x70, 0xBA,
  0x60, 0x1A, 0x82, 0xAB, 0xFE, 0x7A, 0x82, 0xBB, 0xFE, 0x78, 0x4E, 0xFC, 0xBF, 0xE7, 0x82, 0xEF,
  0xCB, 0xA7, 0xA0, 0x0B, 0xA0, 0x15, 0x02, 0xA0, 0xA0, 0xBA, 0x03, 0x50, 0x4A, 0x07, 0x0B, 0xA0,
  0x85, 0x09, 0xA0, 0x30, 0xBA, 0x0E, 0x02, 0x30, 0x2A, 0x89, 0x1D, 0x0B, 0xFD, 0xDE, 0x86, 0x8E,
  0xA8, 0x56, 0x0B, 0xFD, 0x3E, 0xD0, 0xA2, 0x89, 0x0B, 0xFE, 0x02, 0x9D, 0xFC, 0x63, 0x81, 0xBF,
  0xE7, 0x38, 0x1B, 0xFE, 0x73, 0x81, 0xBF, 0xE7, 0x38, 0x1B, 0xFE, 0x73, 0x81, 0xBF, 0xE7, 0x38,
  0x1B, 0xFE, 0x73, 0x81, 0xBF, 0xE7, 0x38, 0x1B, 0xFE, 0x73,
  // "ÿ" (U+00FF)
  0x28, 0x22, 0xEC, 0x12, 0x81, 0xAE, 0x64, 0x06, 0xA0, 0x32, 0xA0, 0xB4, 0x81, 0x2D, 0xC3, 0x81,
  0xAE, 0x57, 0x77, 0x70, 0xBA, 0x78, 0x2C, 0xFE, 0x7A, 0x04, 0x6A, 0x0A, 0x02, 0xA0, 0x85, 0x04,
  0xA8, 0x36, 0x0D, 0xFC, 0x50, 0x8A, 0x81, 0x10, 0x9A, 0x01, 0x48, 0x1C, 0xFC, 0x20, 0x4A, 0x05,
  0x30, 0x1A, 0x08, 0x3A, 0x09, 0x30, 0x5A, 0x04, 0x38, 0x1B, 0xFD, 0x38, 0x19, 0xFE, 0x40, 0x6A,
  0x02, 0x28, 0x1D, 0xFB, 0x40, 0x2A, 0x81, 0x60, 0x1A, 0x06, 0x58, 0x3D, 0xFA, 0x05, 0xA0, 0x25,
  0x85, 0x8F, 0xE0, 0x9F, 0xD6, 0x04, 0xA8, 0x22, 0xDF, 0x97, 0x81, 0xEF, 0x6A, 0x04, 0x78, 0x1A,
  0xFD, 0xA7, 0x10, 0x6B, 0x0B, 0x71, 0x01, 0xB0, 0x77, 0x20, 0xCA, 0x03, 0x72, 0x81, 0xCF, 0xE7,
  0x20, 0x1A, 0x09, 0x72, 0x05, 0xA0, 0x57, 0x20, 0xBA, 0x72, 0x03, 0xA0, 0xA6, 0x82, 0x45, 0x7E,
  0xA0, 0x26, 0x09, 0xC0, 0x77, 0x83, 0x7E, 0xFC, 0x57, 0x10,
  // "Ā" (U+0100)
  0x40, 0x48, 0x03, 0x50, 0x37, 0x0B, 0xF0, 0x87, 0x0B, 0xF0, 0x88, 0x0E, 0x50, 0x09, 0xA0, 0xB7,
  0x50, 0xDB, 0x74, 0x02, 0xA8, 0x1E, 0xF4, 0x73, 0x84, 0x6F, 0xDB, 0xF9, 0x73, 0x84, 0xBF, 0x98,
  0xFD, 0x73, 0xA0, 0x60, 0x4A, 0x02, 0x71, 0x04, 0xA0, 0x21, 0xA0, 0x77, 0x18, 0x19, 0xFE, 0x28,
  0x1C, 0xFB, 0x71, 0x81, 0xDF, 0x92, 0x07, 0xA7, 0x02, 0xA0, 0x52, 0x03, 0xA0, 0x46, 0x06, 0xA0,
  0x13, 0x81, 0xEF, 0x96, 0x81, 0xBF, 0xD4, 0x81, 0xAF, 0xD6, 0xA0, 0x84, 0x06, 0xA0, 0x24, 0x04,
  0xFB, 0x07, 0x40, 0x8F, 0xB0, 0xB4, 0x81, 0xDF, 0xE8, 0x02, 0x90, 0xDA, 0x30, 0x2A, 0x09, 0x60,
  0x6A, 0x05, 0x20, 0x6A, 0x05, 0x60, 0x2A, 0x09, 0x20, 0xBA, 0x01, 0x78, 0x1D, 0xFD, 0x2A, 0x0C,
  0x71, 0x09, 0xA0, 0x20, 0x4A, 0x08, 0x71, 0x05, 0xA0, 0x70, 0x8A, 0x04, 0x71, 0x01, 0xA0, 0xB0,
  0xDA, 0x73, 0x0C, 0xA0,
  // "ā" (U+0101)
  0x20, 0x48, 0x03, 0x50, 0x33, 0x0B, 0xF0, 0x83, 0x0B, 0xF0, 0x87, 0x77, 0x68, 0x61, 0x7B, 0xEF,
  0xEA, 0x33, 0x02, 0x0E, 0xF0, 0x43, 0x84, 0xDE, 0x96, 0x6A, 0xA0, 0xD3, 0x02, 0x50, 0x9A, 0x03,
  0x71, 0x03, 0xA0, 0x67, 0x10, 0x2A, 0x07, 0x71, 0x01, 0xA0, 0x72, 0x82, 0x17, 0xBE, 0xD8, 0x28,
  0x03, 0xEF, 0x98, 0x18, 0x0E, 0xA8, 0x3D, 0x86, 0x56, 0xA0, 0x80, 0x6A, 0x0B, 0x40, 0x1A, 0x08,
  0x0A, 0xA0, 0x24, 0x02, 0xA0, 0x80, 0xBA, 0x50, 0x4A, 0x08, 0x0B, 0xA5, 0x08, 0xA0, 0x08, 0xA0,
  0x53, 0x03, 0xB0, 0x80, 0x3B, 0x89, 0x08, 0x68, 0xFB, 0xDF, 0x80, 0x9D, 0x83, 0xD1, 0xBF, 0x82,
  0x89, 0x07, 0xDF, 0xD9, 0x10, 0x8F, 0x80,
  // "Ă" (U+0102)
  0x40, 0x50, 0x75, 0x07, 0x05, 0x78, 0x19, 0xF4, 0x38, 0x14, 0xF9, 0x78, 0x75, 0xFE, 0x86, 0x8E,
  0xF4, 0x71, 0x0C, 0xD0, 0xA7, 0x28, 0x41, 0x9E, 0xFD, 0x78, 0x0E, 0x70, 0x09, 0xA0, 0xB7, 0x50,
  0xDB, 0x74, 0x02, 0xA8, 0x1E, 0xF4, 0x73, 0x84, 0x6F, 0xDB, 0xF9, 0x73, 0x84, 0xBF, 0x98, 0xFD,
  0x73, 0xA0, 0x60, 0x4A, 0x02, 0x71, 0x04, 0xA0, 0x21, 0xA0, 0x77, 0x18, 0x19, 0xFE, 0x28, 0x1C,
  0xFB, 0x71, 0x81, 0xDF, 0x92, 0x07, 0xA7, 0x02, 0xA0, 0x52, 0x03, 0xA0, 0x46, 0x06, 0xA0, 0x13,
  0x81, 0xEF, 0x96, 0x81, 0xBF, 0xD4, 0x81, 0xAF, 0xD6, 0xA0, 0x84, 0x06, 0xA0, 0x24, 0x04, 0xFB,
  0x07, 0x40, 0x8F, 0xB0, 0xB4, 0x81, 0xDF, 0xE8, 0x02, 0x90, 0xDA, 0x30, 0x2A, 0x09, 0x60, 0x6A,
  0x05, 0x20, 0x6A, 0x05, 0x60, 0x2A, 0x09, 0x20, 0xBA, 0x01, 0x78, 0x1D, 0xFD, 0x2A, 0x0C, 0x71,
  0x09, 0xA0, 0x20, 0x4A, 0x08, 0x71, 0x05, 0xA0, 0x70, 0x8A, 0x04, 0x71, 0x01, 0xA0, 0xB0, 0xDA,
  0x73, 0x0C, 0xA0,
  // "ă" (U+0103)
  0x20, 0x50, 0x75, 0x07, 0x05, 0x38, 0x19, 0xF4, 0x38, 0x14, 0xF9, 0x38, 0x75, 0xFE, 0x86, 0x8E,
  0xF4, 0x40, 0xCD, 0x0A, 0x58, 0x41, 0x9E, 0xFD, 0x77, 0x77, 0x71, 0x86, 0x17, 0xBE, 0xFE, 0xA3,
  0x30, 0x20, 0xEF, 0x04, 0x38, 0x4D, 0xE9, 0x66, 0xAA, 0x0D, 0x30, 0x25, 0x09, 0xA0, 0x37, 0x10,
  0x3A, 0x06, 0x71, 0x02, 0xA0, 0x77, 0x10, 0x1A, 0x07, 0x28, 0x21, 0x7B, 0xED, 0x82, 0x80, 0x3E,
  0xF9, 0x81, 0x80, 0xEA, 0x83, 0xD8, 0x65, 0x6A, 0x08, 0x06, 0xA0, 0xB4, 0x01, 0xA0, 0x80, 0xAA,
  0x02, 0x40, 0x2A, 0x08, 0x0B, 0xA5, 0x04, 0xA0, 0x80, 0xBA, 0x50, 0x8A, 0x00, 0x8A, 0x05, 0x30,
  0x3B, 0x08, 0x03, 0xB8, 0x90, 0x86, 0x8F, 0xBD, 0xF8, 0x09, 0xD8, 0x3D, 0x1B, 0xF8, 0x28, 0x90,
  0x7D, 0xFD, 0x91, 0x08, 0xF8,
  // "Ą" (U+0104)
  0x60, 0x9A, 0x0B, 0x76, 0x0D, 0xB7, 0x50, 0x2A, 0x81, 0xEF, 0x47, 0x48, 0x46, 0xFD, 0xBF, 0x97,
  0x48, 0x4B, 0xF9, 0x8F, 0xD7, 0x4A, 0x06, 0x04, 0xA0, 0x27, 0x20, 0x4A, 0x02, 0x1A, 0x07, 0x72,
  0x81, 0x9F, 0xE2, 0x81, 0xCF, 0xB7, 0x28, 0x1D, 0xF9, 0x20, 0x7A, 0x71, 0x02, 0xA0, 0x52, 0x03,
  0xA0, 0x47, 0x06, 0xA0, 0x13, 0x81, 0xEF, 0x97, 0x81, 0xBF, 0xD4, 0x81, 0xAF, 0xD7, 0xA0, 0x84,
  0x06, 0xA0, 0x25, 0x04, 0xFB, 0x07, 0x50, 0x8F, 0xB0, 0xB5, 0x81, 0xDF, 0xE8, 0x02, 0x90, 0xDA,
  0x40, 0x2A, 0x09, 0x60, 0x6A, 0x05, 0x30, 0x6A, 0x05, 0x60, 0x2A, 0x09, 0x30, 0xBA, 0x01, 0x78,
  0x1D, 0xFD, 0x3A, 0x0C, 0x71, 0x09, 0xA8, 0x12, 0x04, 0xA0, 0x87, 0x10, 0x5A, 0x81, 0x70, 0x8A,
  0x04, 0x71, 0x01, 0xA8, 0x1B, 0x0D, 0xA7, 0x3B, 0x76, 0x81, 0x7F, 0x67, 0x68, 0x11, 0xFC, 0x77,
  0x81, 0x7F, 0x87, 0x78, 0x1A, 0xF8, 0x77, 0x83, 0x9F, 0xE6, 0x67, 0x50, 0x5C, 0x01, 0x75, 0x82,
  0x7D, 0xFC, 0x10,
  // "ą" (U+0105)
  0x28, 0x61, 0x7B, 0xEF, 0xEA, 0x34, 0x02, 0x0E, 0xF0, 0x44, 0x84, 0xDE, 0x96, 0x6A, 0xA0, 0xD4,
  0x02, 0x50, 0x9A, 0x03, 0x72, 0x03, 0xA0, 0x67, 0x20, 0x2A, 0x07, 0x72, 0x01, 0xA0, 0x73, 0x82,
  0x17, 0xBE, 0xD0, 0x82, 0x03, 0x0E, 0xF9, 0x08, 0x20, 0xEA, 0x83, 0xD8, 0x65, 0x6A, 0x81, 0x80,
  0x6A, 0x0B, 0x40, 0x1A, 0x81, 0x80, 0xAA, 0x02, 0x40, 0x2A, 0x81, 0x80, 0xBA, 0x50, 0x4A, 0x81,
  0x80, 0xBA, 0x50, 0x8A, 0x81, 0x80, 0x8A, 0x05, 0x30, 0x3B, 0x81, 0x80, 0x3B, 0x86, 0x86, 0x8F,
  0xBD, 0xF8, 0x20, 0x9D, 0x83, 0xD1, 0xBF, 0x83, 0x84, 0x7D, 0xFD, 0x91, 0x1A, 0x0A, 0x72, 0x81,
  0x7F, 0x67, 0x28, 0x11, 0xFC, 0x73, 0x81, 0x7F, 0x87, 0x38, 0x1A, 0xF8, 0x73, 0x83, 0x9F, 0xE6,
  0x67, 0x10, 0x5C, 0x01, 0x71, 0x82, 0x7D, 0xFC, 0x10,
  // "Ć" (U+0106)
  0x73, 0x0F, 0x70, 0x27, 0x30, 0x5A, 0x0D, 0x01, 0x73, 0x0D, 0xA0, 0x37, 0x30, 0x6A, 0x06, 0x73,
  0x82, 0x1E, 0xF8, 0x74, 0x81, 0x9F, 0x88, 0x0E, 0x30, 0x87, 0x18, 0xCE, 0xFE, 0xC8, 0x25, 0x06,
  0x0E, 0xF9, 0x01, 0x30, 0x7B, 0x85, 0xB7, 0x57, 0xBF, 0x93, 0x04, 0xB0, 0x55, 0x00, 0x23, 0x0C,
  0xA0, 0x67, 0x30, 0x4A, 0x0C, 0x74, 0x08, 0xA0, 0x67, 0x40, 0xCA, 0x01, 0x74, 0xA0, 0xD7, 0x40,
  0x2A, 0x0B, 0x74, 0x03, 0xA0, 0x97, 0x40, 0x4A, 0x09, 0x74, 0x03, 0xA0, 0x97, 0x40, 0x2A, 0x0A,
  0x74, 0x01, 0xA0, 0xC7, 0x50, 0xDA, 0x75, 0x09, 0xA0, 0x57, 0x40, 0x5A, 0x0B, 0x75, 0x0D, 0xA0,
  0x57, 0x40, 0x5B, 0x05, 0x60, 0x14, 0x08, 0xB8, 0x5C, 0x76, 0x79, 0xD8, 0x50, 0x7F, 0x90, 0x86,
  0x87, 0x28, 0xCE, 0xFE, 0xC7, 0x21,
  // "ć" (U+0107)
  0x70, 0xF7, 0x02, 0x60, 0x5A, 0x0D, 0x01, 0x60, 0xDA, 0x03, 0x60, 0x6A, 0x06, 0x68, 0x21, 0xEF,
  0x87, 0x81, 0x9F, 0x87, 0x77, 0x71, 0x86, 0x17, 0xCE, 0xEC, 0x82, 0x20, 0x20, 0xDE, 0x05, 0x20,
  0xDA, 0x83, 0xB6, 0x6A, 0xE2, 0x07, 0xA0, 0x97, 0x81, 0xDF, 0xE7, 0x02, 0xA0, 0x97, 0x04, 0xA0,
  0x67, 0x06, 0xA0, 0x47, 0x07, 0xA0, 0x37, 0x07, 0xA0, 0x37, 0x06, 0xA0, 0x47, 0x05, 0xA0, 0x67,
  0x02, 0xA0, 0x97, 0x18, 0x1E, 0xFE, 0x71, 0x09, 0xA0, 0x87, 0x01, 0x0E, 0xA8, 0x4B, 0x66, 0x8D,
  0x52, 0x03, 0x0E, 0xE0, 0x53, 0x86, 0x18, 0xDF, 0xEC, 0x71,
  // "Ĉ" (U+0108)
  0x78, 0x24, 0x77, 0x17, 0x30, 0x10, 0xEA, 0x09, 0x73, 0x09, 0xC0, 0x37, 0x10, 0x3A, 0x82, 0x49,
  0xFC, 0x71, 0x81, 0xDF, 0x52, 0x81, 0xAF, 0x86, 0x81, 0x9F, 0x64, 0x81, 0xAF, 0x38, 0x0D, 0x70,
  0x87, 0x18, 0xCE, 0xFE, 0xC8, 0x25, 0x06, 0x0E, 0xF9, 0x01, 0x30, 0x7B, 0x85, 0xB7, 0x57, 0xBF,
  0x93, 0x04, 0xB0, 0x55, 0x00, 0x23, 0x0C, 0xA0, 0x67, 0x30, 0x4A, 0x0C, 0x74, 0x08, 0xA0, 0x67,
  0x40, 0xCA, 0x01, 0x74, 0xA0, 0xD7, 0x40, 0x2A, 0x0B, 0x74, 0x03, 0xA0, 0x97, 0x40, 0x4A, 0x09,
  0x74, 0x03, 0xA0, 0x97, 0x40, 0x2A, 0x0A, 0x74, 0x01, 0xA0, 0xC7, 0x50, 0xDA, 0x75, 0x09, 0xA0,
  0x57, 0x40, 0x5A, 0x0B, 0x75, 0x0D, 0xA0, 0x57, 0x40, 0x5B, 0x05, 0x60, 0x14, 0x08, 0xB8, 0x5C,
  0x76, 0x79, 0xD8, 0x50, 0x7F, 0x90, 0x86, 0x87, 0x28, 0xCE, 0xFE, 0xC7, 0x21,
  // "ĉ" (U+0109)
  0x58, 0x24, 0x77, 0x17, 0x01, 0x0E, 0xA0, 0x97, 0x09, 0xC0, 0x35, 0x03, 0xA8, 0x24, 0x9F, 0xC5,
  0x81, 0xDF, 0x52, 0x81, 0xAF, 0x83, 0x81, 0x9F, 0x64, 0x81, 0xAF, 0x37, 0x77, 0x68, 0x61, 0x7C,
  0xEE, 0xC8, 0x23, 0x02, 0x0D, 0xE0, 0x53, 0x0D, 0xA8, 0x3B, 0x66, 0xAE, 0x30, 0x7A, 0x09, 0x71,
  0x81, 0xDF, 0xE7, 0x10, 0x2A, 0x09, 0x71, 0x04, 0xA0, 0x67, 0x10, 0x6A, 0x04, 0x71, 0x07, 0xA0,
  0x37, 0x10, 0x7A, 0x03, 0x71, 0x06, 0xA0, 0x47, 0x10, 0x5A, 0x06, 0x71, 0x02, 0xA0, 0x97, 0x28,
  0x1E, 0xFE, 0x72, 0x09, 0xA0, 0x87, 0x10, 0x10, 0xEA, 0x84, 0xB6, 0x68, 0xD5, 0x30, 0x30, 0xEE,
  0x05, 0x48, 0x61, 0x8D, 0xFE, 0xC7, 0x11,
  // "Ċ" (U+010A)
  0x78, 0x13, 0xEC, 0x75, 0x0A, 0xA0, 0x57, 0x40, 0xAA, 0x05, 0x74, 0x81, 0x3E, 0xC8, 0x09, 0x82,
  0x08, 0x71, 0x8C, 0xEF, 0xEC, 0x82, 0x50, 0x60, 0xEF, 0x90, 0x13, 0x07, 0xB8, 0x5B, 0x75, 0x7B,
  0xF9, 0x30, 0x4B, 0x05, 0x50, 0x02, 0x30, 0xCA, 0x06, 0x73, 0x04, 0xA0, 0xC7, 0x40, 0x8A, 0x06,
  0x74, 0x0C, 0xA0, 0x17, 0x4A, 0x0D, 0x74, 0x02, 0xA0, 0xB7, 0x40, 0x3A, 0x09, 0x74, 0x04, 0xA0,
  0x97, 0x40, 0x3A, 0x09, 0x74, 0x02, 0xA0, 0xA7, 0x40, 0x1A, 0x0C, 0x75, 0x0D, 0xA7, 0x50, 0x9A,
  0x05, 0x74, 0x05, 0xA0, 0xB7, 0x50, 0xDA, 0x05, 0x74, 0x05, 0xB0, 0x56, 0x01, 0x40, 0x8B, 0x85,
  0xC7, 0x67, 0x9D, 0x85, 0x07, 0xF9, 0x08, 0x68, 0x72, 0x8C, 0xEF, 0xEC, 0x72, 0x10,
  // "ċ" (U+010B)
  0x58, 0x13, 0xEC, 0x71, 0x0A, 0xA0, 0x57, 0x0A, 0xA0, 0x57, 0x81, 0x3E, 0xC8, 0x0C, 0x30, 0x86,
  0x17, 0xCE, 0xEC, 0x82, 0x20, 0x20, 0xDE, 0x05, 0x20, 0xDA, 0x83, 0xB6, 0x6A, 0xE2, 0x07, 0xA0,
  0x97, 0x81, 0xDF, 0xE7, 0x02, 0xA0, 0x97, 0x04, 0xA0, 0x67, 0x06, 0xA0, 0x47, 0x07, 0xA0, 0x37,
  0x07, 0xA0, 0x37, 0x06, 0xA0, 0x47, 0x05, 0xA0, 0x67, 0x02, 0xA0, 0x97, 0x18, 0x1E, 0xFE, 0x71,
  0x09, 0xA0, 0x87, 0x01, 0x0E, 0xA8, 0x4B, 0x66, 0x8D, 0x52, 0x03, 0x0E, 0xE0, 0x53, 0x86, 0x18,
  0xDF, 0xEC, 0x71,
  // "Č" (U+010C)
  0x48, 0x15, 0x71, 0x48, 0x13, 0x73, 0x58, 0x15, 0xFC, 0x38, 0x23, 0xED, 0x16, 0x86, 0x9F, 0xB0,
  0x2E, 0xF3, 0x71, 0x84, 0xDF, 0xAD, 0xF8, 0x72, 0x05, 0xB0, 0xD7, 0x40, 0xBA, 0x05, 0x80, 0xE2,
  0x08, 0x71, 0x8C, 0xEF, 0xEC, 0x82, 0x50, 0x60, 0xEF, 0x90, 0x13, 0x07, 0xB8, 0x5B, 0x75, 0x7B,
  0xF9, 0x30, 0x4B, 0x05, 0x50, 0x02, 0x30, 0xCA, 0x06, 0x73, 0x04, 0xA0, 0xC7, 0x40, 0x8A, 0x06,
  0x74, 0x0C, 0xA0, 0x17, 0x4A, 0x0D, 0x74, 0x02, 0xA0, 0xB7, 0x40, 0x3A, 0x09, 0x74, 0x04, 0xA0,
  0x97, 0x40, 0x3A, 0x09, 0x74, 0x02, 0xA0, 0xA7, 0x40, 0x1A, 0x0C, 0x75, 0x0D, 0xA7, 0x50, 0x9A,
  0x05, 0x74, 0x05, 0xA0, 0xB7, 0x50, 0xDA, 0x05, 0x74, 0x05, 0xB0, 0x56, 0x01, 0x40, 0x8B, 0x85,
  0xC7, 0x67, 0x9D, 0x85, 0x07, 0xF9, 0x08, 0x68, 0x72, 0x8C, 0xEF, 0xEC, 0x72, 0x10,
  // "č" (U+010D)
  0x28, 0x15, 0x71, 0x48, 0x13, 0x73, 0x28, 0x15, 0xFC, 0x38, 0x23, 0xED, 0x13, 0x86, 0x9F, 0xB0,
  0x2E, 0xF3, 0x58, 0x4D, 0xFA, 0xDF, 0x86, 0x05, 0xB0, 0xD7, 0x10, 0xBA, 0x05, 0x77, 0x77, 0x28,
  0x61, 0x7C, 0xEE, 0xC8, 0x23, 0x02, 0x0D, 0xE0, 0x53, 0x0D, 0xA8, 0x3B, 0x66, 0xAE, 0x30, 0x7A,
  0x09, 0x71, 0x81, 0xDF, 0xE7, 0x10, 0x2A, 0x09, 0x71, 0x04, 0xA0, 0x67, 0x10, 0x6A, 0x04, 0x71,
  0x07, 0xA0, 0x37, 0x10, 0x7A, 0x03, 0x71, 0x06, 0xA0, 0x47, 0x10, 0x5A, 0x06, 0x71, 0x02, 0xA0,
  0x97, 0x28, 0x1E, 0xFE, 0x72, 0x09, 0xA0, 0x87, 0x10, 0x10, 0xEA, 0x84, 0xB6, 0x68, 0xD5, 0x30,
  0x30, 0xEE, 0x05, 0x48, 0x61, 0x8D, 0xFE, 0xC7, 0x11,
  // "Ď" (U+010E)
  0x28, 0x15, 0x71, 0x48, 0x13, 0x73, 0x58, 0x15, 0xFC, 0x38, 0x23, 0xED, 0x16, 0x86, 0x9F, 0xB0,
  0x2E, 0xF3, 0x71, 0x84, 0xDF, 0xAD, 0xF8, 0x72, 0x05, 0xB0, 0xD7, 0x40, 0xBA, 0x05, 0x80, 0xD7,
  0x00, 0x6D, 0x82, 0xED, 0xA5, 0x50, 0x6F, 0xA0, 0xC0, 0x33, 0x06, 0xA8, 0x48, 0x55, 0x69, 0xEA,
  0x0E, 0x03, 0x20, 0x6A, 0x04, 0x50, 0x9A, 0x0D, 0x20, 0x6A, 0x04, 0x60, 0xAA, 0x81, 0x80, 0x6A,
  0x04, 0x68, 0x41, 0xEF, 0xE0, 0x6A, 0x04, 0x70, 0xAA, 0x04, 0x06, 0xA0, 0x47, 0x05, 0xA0, 0x80,
  0x6A, 0x04, 0x70, 0x3A, 0x0A, 0x06, 0xA0, 0x47, 0x01, 0xA0, 0xC0, 0x6A, 0x04, 0x71, 0xA0, 0xD0,
  0x6A, 0x04, 0x71, 0xA0, 0xD0, 0x6A, 0x04, 0x71, 0xA0, 0xC0, 0x6A, 0x04, 0x70, 0x1A, 0x0B, 0x06,
  0xA0, 0x47, 0x03, 0xA0, 0xA0, 0x6A, 0x04, 0x70, 0x6A, 0x07, 0x06, 0xA0, 0x47, 0x0B, 0xA0, 0x30,
  0x6A, 0x04, 0x60, 0x2A, 0x81, 0xD0, 0x6A, 0x04, 0x60, 0xBA, 0x81, 0x70, 0x6A, 0x04, 0x40, 0x10,
  0xBA, 0x0C, 0x20, 0x6A, 0x84, 0x85, 0x57, 0xAE, 0xA0, 0xD0, 0x22, 0x06, 0xFA, 0x0B, 0x02, 0x30,
  0x6D, 0x82, 0xED, 0x94, 0x50,
  // "ď" (U+010F)
  0x73, 0x0A, 0xA2, 0x07, 0xA0, 0x37, 0x30, 0xAA, 0x28, 0x19, 0xFE, 0x74, 0x0A, 0xA2, 0x81, 0xCF,
  0x87, 0x40, 0xAA, 0x28, 0x1E, 0xF1, 0x74, 0x0A, 0xA1, 0x81, 0x2F, 0x87, 0x50, 0xAA, 0x77, 0x20,
  0xAA, 0x72, 0x86, 0x3B, 0xEE, 0xB4, 0x0A, 0xA7, 0x10, 0x5E, 0x06, 0x09, 0xA7, 0x02, 0xB8, 0x49,
  0x67, 0xDF, 0xCA, 0x70, 0x9A, 0x06, 0x40, 0xCB, 0x78, 0x1E, 0xFD, 0x50, 0x4B, 0x60, 0x3A, 0x08,
  0x60, 0xEA, 0x60, 0x5A, 0x05, 0x60, 0xCA, 0x60, 0x7A, 0x03, 0x60, 0xAA, 0x60, 0x7A, 0x03, 0x60,
  0xAA, 0x60, 0x7A, 0x03, 0x60, 0x9A, 0x60, 0x7A, 0x03, 0x60, 0xAA, 0x60, 0x5A, 0x05, 0x60, 0xBA,
  0x60, 0x3A, 0x08, 0x60, 0xEA, 0x78, 0x1E, 0xFD, 0x50, 0x3B, 0x70, 0xAA, 0x06, 0x40, 0xCB, 0x70,
  0x2B, 0x84, 0x96, 0x7D, 0xFB, 0xA7, 0x10, 0x6E, 0x07, 0x05, 0xA7, 0x28, 0x63, 0xBE, 0xEB, 0x40,
  0x3A, 0x60,
  // "Đ" (U+0110)
  0x20, 0x5D, 0x82, 0xED, 0xA5, 0x70, 0x5F, 0xA0, 0xC0, 0x25, 0x05, 0xA8, 0x49, 0x55, 0x69, 0xEA,
  0x0E, 0x03, 0x40, 0x5A, 0x05, 0x50, 0x9A, 0x0D, 0x40, 0x5A, 0x05, 0x60, 0xAA, 0x08, 0x30, 0x5A,
  0x05, 0x68, 0x21, 0xEF, 0xE3, 0x05, 0xA0, 0x57, 0x0A, 0xA0, 0x42, 0x05, 0xA0, 0x57, 0x05, 0xA0,
  0x72, 0x05, 0xA0, 0x57, 0x03, 0xA0, 0xA2, 0x05, 0xA0, 0x57, 0x01, 0xA0, 0xB0, 0x3F, 0x90, 0x34,
  0xA0, 0xC0, 0x3F, 0x90, 0x34, 0xA8, 0x2D, 0x15, 0x9A, 0x83, 0x95, 0x55, 0x14, 0xA0, 0xC2, 0x05,
  0xA0, 0x57, 0x01, 0xA0, 0xB2, 0x05, 0xA0, 0x57, 0x03, 0xA0, 0x92, 0x05, 0xA0, 0x57, 0x06, 0xA0,
  0x62, 0x05, 0xA0, 0x57, 0x0B, 0xA0, 0x32, 0x05, 0xA0, 0x56, 0x02, 0xA0, 0xD3, 0x05, 0xA0, 0x56,
  0x0B, 0xA0, 0x63, 0x05, 0xA0, 0x54, 0x01, 0x0B, 0xA0, 0xC4, 0x05, 0xA8, 0x49, 0x55, 0x7A, 0xEA,
  0x0D, 0x02, 0x40, 0x5F, 0xA0, 0xB0, 0x15, 0x05, 0xD8, 0x2E, 0xD9, 0x45,
  // "đ" (U+0111)
  0x73, 0x0A, 0xA7, 0x50, 0xAA, 0x78, 0x41, 0x55, 0x55, 0xCA, 0x00, 0x55, 0x03, 0xFA, 0x50, 0x3F,
  0xA7, 0x30, 0xAA, 0x75, 0x0A, 0xA5, 0x86, 0x4B, 0xEE, 0xB4, 0x0A, 0xA4, 0x06, 0xE0, 0x60, 0x9A,
  0x30, 0x2B, 0x84, 0x96, 0x7D, 0xFC, 0xA3, 0x09, 0xA0, 0x64, 0x0C, 0xB3, 0x81, 0xEF, 0xD5, 0x04,
  0xB2, 0x03, 0xA0, 0x86, 0x0E, 0xA2, 0x05, 0xA0, 0x56, 0x0C, 0xA2, 0x07, 0xA0, 0x46, 0x0A, 0xA2,
  0x07, 0xA0, 0x36, 0x0A, 0xA2, 0x07, 0xA0, 0x36, 0x0A, 0xA2, 0x07, 0xA0, 0x46, 0x0A, 0xA2, 0x05,
  0xA0, 0x56, 0x0C, 0xA2, 0x03, 0xA0, 0x86, 0x0E, 0xA3, 0x81, 0xEF, 0xD5, 0x04, 0xB3, 0x0A, 0xA0,
  0x64, 0x0C, 0xB3, 0x02, 0xB8, 0x49, 0x67, 0xDF, 0xBA, 0x40, 0x6E, 0x06, 0x05, 0xA5, 0x86, 0x3B,
  0xEE, 0xB4, 0x03, 0xA2,
  // "Ē" (U+0112)
  0x10, 0x48, 0x03, 0x50, 0x32, 0x0B, 0xF0, 0x82, 0x0B, 0xF0, 0x87, 0x77, 0x76, 0x06, 0xFA, 0x0B,
  0x06, 0xFA, 0x0B, 0x06, 0xA0, 0x88, 0x02, 0x50, 0x40, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A,
  0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x08, 0x80, 0x25, 0x01,
  0x06, 0xFA, 0x04, 0x06, 0xFA, 0x04, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06,
  0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0,
  0x88, 0x02, 0x50, 0x40, 0x6F, 0xA0, 0xB0, 0x6F, 0xA0, 0xB0,
  // "ē" (U+0113)
  0x20, 0x48, 0x03, 0x50, 0x34, 0x0B, 0xF0, 0x84, 0x0B, 0xF0, 0x87, 0x77, 0x73, 0x85, 0x19, 0xDF,
  0xDA, 0x25, 0x03, 0x0E, 0xE0, 0x44, 0x0E, 0xA8, 0x28, 0x67, 0xEA, 0x01, 0x20, 0x7A, 0x03, 0x30,
  0x2A, 0x09, 0x28, 0x1D, 0xFA, 0x58, 0x3A, 0xFE, 0x02, 0xA0, 0x65, 0x05, 0xA0, 0x20, 0x4A, 0x03,
  0x50, 0x3A, 0x04, 0x06, 0xFC, 0x05, 0x07, 0xFC, 0x05, 0x07, 0xA0, 0x78, 0x04, 0x50, 0x20, 0x6A,
  0x03, 0x72, 0x04, 0xA0, 0x57, 0x20, 0x1A, 0x09, 0x73, 0x81, 0xCF, 0xE7, 0x30, 0x5A, 0x0A, 0x60,
  0x43, 0x0C, 0xA8, 0x5C, 0x75, 0x6A, 0xEA, 0x30, 0x10, 0xCF, 0x0A, 0x58, 0x57, 0xCE, 0xFE, 0xB6,
  0x20,
  // "Ĕ" (U+0114)
  0x10, 0x50, 0x75, 0x07, 0x05, 0x28, 0x19, 0xF4, 0x38, 0x14, 0xF9, 0x28, 0x75, 0xFE, 0x86, 0x8E,
  0xF4, 0x30, 0xCD, 0x0A, 0x48, 0x41, 0x9E, 0xFD, 0x78, 0x0C, 0x00, 0x06, 0xFA, 0x0B, 0x06, 0xFA,
  0x0B, 0x06, 0xA0, 0x88, 0x02, 0x50, 0x40, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70,
  0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x08, 0x80, 0x25, 0x01, 0x06, 0xFA,
  0x04, 0x06, 0xFA, 0x04, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47,
  0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x88, 0x02,
  0x50, 0x40, 0x6F, 0xA0, 0xB0, 0x6F, 0xA0, 0xB0,
  // "ĕ" (U+0115)
  0x20, 0x50, 0x75, 0x07, 0x05, 0x48, 0x19, 0xF4, 0x38, 0x14, 0xF9, 0x48, 0x75, 0xFE, 0x86, 0x8E,
  0xF4, 0x50, 0xCD, 0x0A, 0x68, 0x41, 0x9E, 0xFD, 0x77, 0x77, 0x75, 0x85, 0x19, 0xDF, 0xDA, 0x25,
  0x03, 0x0E, 0xE0, 0x44, 0x0E, 0xA8, 0x28, 0x67, 0xEA, 0x01, 0x20, 0x7A, 0x03, 0x30, 0x2A, 0x09,
  0x28, 0x1D, 0xFA, 0x58, 0x3A, 0xFE, 0x02, 0xA0, 0x65, 0x05, 0xA0, 0x20, 0x4A, 0x03, 0x50, 0x3A,
  0x04, 0x06, 0xFC, 0x05, 0x07, 0xFC, 0x05, 0x07, 0xA0, 0x78, 0x04, 0x50, 0x20, 0x6A, 0x03, 0x72,
  0x04, 0xA0, 0x57, 0x20, 0x1A, 0x09, 0x73, 0x81, 0xCF, 0xE7, 0x30, 0x5A, 0x0A, 0x60, 0x43, 0x0C,
  0xA8, 0x5C, 0x75, 0x6A, 0xEA, 0x30, 0x10, 0xCF, 0x0A, 0x58, 0x57, 0xCE, 0xFE, 0xB6, 0x20,
  // "Ė" (U+0116)
  0x48, 0x13, 0xEC, 0x71, 0x0A, 0xA0, 0x57, 0x0A, 0xA0, 0x57, 0x81, 0x3E, 0xC8, 0x0D, 0x40, 0x06,
  0xFA, 0x0B, 0x06, 0xFA, 0x0B, 0x06, 0xA0, 0x88, 0x02, 0x50, 0x40, 0x6A, 0x04, 0x70, 0x6A, 0x04,
  0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x08, 0x80,
  0x25, 0x01, 0x06, 0xFA, 0x04, 0x06, 0xFA, 0x04, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0,
  0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47,
  0x06, 0xA0, 0x88, 0x02, 0x50, 0x40, 0x6F, 0xA0, 0xB0, 0x6F, 0xA0, 0xB0,
  // "ė" (U+0117)
  0x58, 0x13, 0xEC, 0x73, 0x0A, 0xA0, 0x57, 0x20, 0xAA, 0x05, 0x72, 0x81, 0x3E, 0xC8, 0x0D, 0x30,
  0x85, 0x19, 0xDF, 0xDA, 0x25, 0x03, 0x0E, 0xE0, 0x44, 0x0E, 0xA8, 0x28, 0x67, 0xEA, 0x01, 0x20,
  0x7A, 0x03, 0x30, 0x2A, 0x09, 0x28, 0x1D, 0xFA, 0x58, 0x3A, 0xFE, 0x02, 0xA0, 0x65, 0x05, 0xA0,
  0x20, 0x4A, 0x03, 0x50, 0x3A, 0x04, 0x06, 0xFC, 0x05, 0x07, 0xFC, 0x05, 0x07, 0xA0, 0x78, 0x04,
  0x50, 0x20, 0x6A, 0x03, 0x72, 0x04, 0xA0, 0x57, 0x20, 0x1A, 0x09, 0x73, 0x81, 0xCF, 0xE7, 0x30,
  0x5A, 0x0A, 0x60, 0x43, 0x0C, 0xA8, 0x5C, 0x75, 0x6A, 0xEA, 0x30, 0x10, 0xCF, 0x0A, 0x58, 0x57,
  0xCE, 0xFE, 0xB6, 0x20,
  // "Ę" (U+0118)
  0x06, 0xFA, 0x81, 0xB0, 0x6F, 0xA8, 0x1B, 0x06, 0xA0, 0x88, 0x02, 0x58, 0x14, 0x06, 0xA0, 0x47,
  0x10, 0x6A, 0x04, 0x71, 0x06, 0xA0, 0x47, 0x10, 0x6A, 0x04, 0x71, 0x06, 0xA0, 0x47, 0x10, 0x6A,
  0x04, 0x71, 0x06, 0xA0, 0x88, 0x02, 0x58, 0x11, 0x06, 0xFA, 0x81, 0x40, 0x6F, 0xA8, 0x14, 0x06,
  0xA0, 0x47, 0x10, 0x6A, 0x04, 0x71, 0x06, 0xA0, 0x47, 0x10, 0x6A, 0x04, 0x71, 0x06, 0xA0, 0x47,
  0x10, 0x6A, 0x04, 0x71, 0x06, 0xA0, 0x47, 0x10, 0x6A, 0x04, 0x71, 0x06, 0xA0, 0x88, 0x02, 0x58,
  0x14, 0x06, 0xFA, 0x81, 0xB0, 0x6F, 0xA0, 0xE7, 0x18, 0x17, 0xF6, 0x71, 0x81, 0x1F, 0xC7, 0x28,
  0x17, 0xF8, 0x72, 0x81, 0xAF, 0x87, 0x28, 0x39, 0xFE, 0x66, 0x70, 0x5C, 0x01, 0x78, 0x27, 0xDF,
  0xC1,
  // "ę" (U+0119)
  0x38, 0x51, 0x9D, 0xFD, 0xA2, 0x50, 0x30, 0xEE, 0x04, 0x40, 0xEA, 0x82, 0x86, 0x7E, 0xA0, 0x12,
  0x07, 0xA0, 0x33, 0x02, 0xA0, 0x92, 0x81, 0xDF, 0xA5, 0x83, 0xAF, 0xE0, 0x2A, 0x06, 0x50, 0x5A,
  0x02, 0x04, 0xA0, 0x35, 0x03, 0xA0, 0x40, 0x6F, 0xC0, 0x50, 0x7F, 0xC0, 0x50, 0x7A, 0x07, 0x80,
  0x45, 0x02, 0x06, 0xA0, 0x37, 0x20, 0x4A, 0x05, 0x72, 0x01, 0xA0, 0x97, 0x38, 0x1C, 0xFE, 0x73,
  0x05, 0xA0, 0xA6, 0x04, 0x30, 0xCA, 0x85, 0xC7, 0x56, 0xAE, 0xA3, 0x01, 0x0C, 0xF0, 0xA5, 0x86,
  0x7C, 0xEF, 0xEF, 0xE3, 0x72, 0x81, 0xAF, 0x47, 0x28, 0x16, 0xF9, 0x73, 0x81, 0xEF, 0x27, 0x20,
  0x2A, 0x73, 0x03, 0xA0, 0x47, 0x30, 0xEB, 0x09, 0x71, 0x06, 0xB0, 0x97, 0x28, 0x21, 0x44, 0x11,
  // "Ě" (U+011A)
  0x18, 0x15, 0x71, 0x48, 0x53, 0x73, 0x05, 0xFC, 0x38, 0x23, 0xED, 0x12, 0x86, 0x9F, 0xB0, 0x2E,
  0xF3, 0x48, 0x4D, 0xFA, 0xDF, 0x85, 0x05, 0xB0, 0xD7, 0x0B, 0xA0, 0x58, 0x0C, 0x00, 0x06, 0xFA,
  0x0B, 0x06, 0xFA, 0x0B, 0x06, 0xA0, 0x88, 0x02, 0x50, 0x40, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70,
  0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x04, 0x70, 0x6A, 0x08, 0x80, 0x25,
  0x01, 0x06, 0xFA, 0x04, 0x06, 0xFA, 0x04, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47,
  0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06,
  0xA0, 0x88, 0x02, 0x50, 0x40, 0x6F, 0xA0, 0xB0, 0x6F, 0xA0, 0xB0,
  // "ě" (U+011B)
  0x28, 0x15, 0x71, 0x48, 0x13, 0x73, 0x38, 0x15, 0xFC, 0x38, 0x23, 0xED, 0x14, 0x86, 0x9F, 0xB0,
  0x2E, 0xF3, 0x68, 0x4D, 0xFA, 0xDF, 0x87, 0x05, 0xB0, 0xD7, 0x20, 0xBA, 0x05, 0x77, 0x77, 0x58,
  0x51, 0x9D, 0xFD, 0xA2, 0x50, 0x30, 0xEE, 0x04, 0x40, 0xEA, 0x82, 0x86, 0x7E, 0xA0, 0x12, 0x07,
  0xA0, 0x33, 0x02, 0xA0, 0x92, 0x81, 0xDF, 0xA5, 0x83, 0xAF, 0xE0, 0x2A, 0x06, 0x50, 0x5A, 0x02,
  0x04, 0xA0, 0x35, 0x03, 0xA0, 0x40, 0x6F, 0xC0, 0x50, 0x7F, 0xC0, 0x50, 0x7A, 0x07, 0x80, 0x45,
  0x02, 0x06, 0xA0, 0x37, 0x20, 0x4A, 0x05, 0x72, 0x01, 0xA0, 0x97, 0x38, 0x1C, 0xFE, 0x73, 0x05,
  0xA0, 0xA6, 0x04, 0x30, 0xCA, 0x85, 0xC7, 0x56, 0xAE, 0xA3, 0x01, 0x0C, 0xF0, 0xA5, 0x85, 0x7C,
  0xEF, 0xEB, 0x62,
  // "Ĝ" (U+011C)
  0x71, 0x82, 0x47, 0x71, 0x75, 0x01, 0x0E, 0xA0, 0x97, 0x50, 0x9C, 0x03, 0x73, 0x03, 0xA8, 0x24,
  0x9F, 0xC7, 0x38, 0x1D, 0xF5, 0x28, 0x1A, 0xF8, 0x71, 0x81, 0x9F, 0x64, 0x81, 0xAF, 0x38, 0x0E,
  0x70, 0x87, 0x49, 0xDE, 0xFE, 0xC8, 0x46, 0x02, 0x0C, 0xFA, 0x0B, 0x40, 0x30, 0xEA, 0x87, 0xE9,
  0x65, 0x7A, 0xEF, 0x73, 0x01, 0x0E, 0xA0, 0x97, 0x07, 0x01, 0x30, 0xBA, 0x08, 0x75, 0x03, 0xA0,
  0xD7, 0x60, 0x8A, 0x06, 0x76, 0x0D, 0xA0, 0x17, 0x6A, 0x0D, 0x76, 0x02, 0xA0, 0xA7, 0x60, 0x4A,
  0x09, 0x50, 0x18, 0x02, 0x50, 0x10, 0x4A, 0x09, 0x50, 0x2E, 0x04, 0x03, 0xA0, 0x95, 0x02, 0xE0,
  0x40, 0x2A, 0x0B, 0x72, 0x06, 0xA0, 0x41, 0xA0, 0xD7, 0x20, 0x6A, 0x81, 0x40, 0xCA, 0x01, 0x71,
  0x06, 0xA8, 0x14, 0x08, 0xA0, 0x57, 0x10, 0x6A, 0x81, 0x40, 0x4A, 0x0C, 0x71, 0x06, 0xA0, 0x42,
  0x0C, 0xA0, 0x77, 0x06, 0xA0, 0x42, 0x03, 0xB0, 0x66, 0x06, 0xA0, 0x43, 0x06, 0xB8, 0x5D, 0x86,
  0x67, 0x9D, 0xA0, 0x44, 0x05, 0x0E, 0xFB, 0x04, 0x58, 0x21, 0x7B, 0xEA, 0x83, 0xEC, 0xA6, 0x21,
  // "ĝ" (U+011D)
  0x58, 0x24, 0x77, 0x17, 0x10, 0x10, 0xEA, 0x09, 0x71, 0x09, 0xC0, 0x36, 0x03, 0xA8, 0x24, 0x9F,
  0xC6, 0x81, 0xDF, 0x52, 0x81, 0xAF, 0x84, 0x81, 0x9F, 0x64, 0x81, 0xAF, 0x37, 0x77, 0x72, 0x86,
  0x3A, 0xEE, 0xB4, 0x03, 0xA2, 0x05, 0xE0, 0x60, 0x5A, 0x10, 0x20, 0xEA, 0x84, 0x96, 0x7D, 0xFA,
  0xA1, 0x09, 0xA0, 0x63, 0x01, 0x0D, 0xB1, 0x81, 0xEF, 0xD5, 0x04, 0xB0, 0x3A, 0x08, 0x6B, 0x05,
  0xA0, 0x56, 0x0C, 0xA0, 0x7A, 0x03, 0x60, 0xAA, 0x07, 0xA0, 0x36, 0x0A, 0xA0, 0x7A, 0x03, 0x60,
  0x9A, 0x07, 0xA0, 0x36, 0x0A, 0xA0, 0x5A, 0x05, 0x60, 0xBA, 0x03, 0xA0, 0x86, 0x0E, 0xA1, 0x81,
  0xEF, 0xC5, 0x03, 0xB1, 0x0A, 0xA0, 0x64, 0x0C, 0xB1, 0x02, 0xB8, 0x49, 0x67, 0xDF, 0xBA, 0x20,
  0x6E, 0x06, 0x09, 0xA3, 0x86, 0x4B, 0xEE, 0xB4, 0x09, 0xA7, 0x30, 0xAA, 0x73, 0x81, 0xAF, 0xE7,
  0x38, 0x1D, 0xFC, 0x72, 0x02, 0xA8, 0x29, 0x04, 0x26, 0x0C, 0xA8, 0x90, 0x30, 0x8F, 0xC8, 0x65,
  0x8D, 0xA0, 0xA2, 0x08, 0xF9, 0x0B, 0x48, 0x16, 0xAD, 0xA8, 0x1D, 0xA5, 0x30,
  // "Ğ" (U+011E)
  0x50, 0x50, 0x75, 0x07, 0x05, 0x71, 0x81, 0x9F, 0x43, 0x81, 0x4F, 0x97, 0x18, 0x75, 0xFE, 0x86,
  0x8E, 0xF4, 0x72, 0x0C, 0xD0, 0xA7, 0x38, 0x41, 0x9E, 0xFD, 0x78, 0x0F, 0x20, 0x87, 0x49, 0xDE,
  0xFE, 0xC8, 0x46, 0x02, 0x0C, 0xFA, 0x0B, 0x40, 0x30, 0xEA, 0x87, 0xE9, 0x65, 0x7A, 0xEF, 0x73,
  0x01, 0x0E, 0xA0, 0x97, 0x07, 0x01, 0x30, 0xBA, 0x08, 0x75, 0x03, 0xA0, 0xD7, 0x60, 0x8A, 0x06,
  0x76, 0x0D, 0xA0, 0x17, 0x6A, 0x0D, 0x76, 0x02, 0xA0, 0xA7, 0x60, 0x4A, 0x09, 0x50, 0x18, 0x02,
  0x50, 0x10, 0x4A, 0x09, 0x50, 0x2E, 0x04, 0x03, 0xA0, 0x95, 0x02, 0xE0, 0x40, 0x2A, 0x0B, 0x72,
  0x06, 0xA0, 0x41, 0xA0, 0xD7, 0x20, 0x6A, 0x81, 0x40, 0xCA, 0x01, 0x71, 0x06, 0xA8, 0x14, 0x08,
  0xA0, 0x57, 0x10, 0x6A, 0x81, 0x40, 0x4A, 0x0C, 0x71, 0x06, 0xA0, 0x42, 0x0C, 0xA0, 0x77, 0x06,
  0xA0, 0x42, 0x03, 0xB0, 0x66, 0x06, 0xA0, 0x43, 0x06, 0xB8, 0x5D, 0x86, 0x67, 0x9D, 0xA0, 0x44,
  0x05, 0x0E, 0xFB, 0x04, 0x58, 0x21, 0x7B, 0xEA, 0x83, 0xEC, 0xA6, 0x21,
  // "ğ" (U+011F)
  0x30, 0x50, 0x75, 0x07, 0x05, 0x48, 0x19, 0xF4, 0x38, 0x14, 0xF9, 0x48, 0x75, 0xFE, 0x86, 0x8E,
  0xF4, 0x50, 0xCD, 0x0A, 0x68, 0x41, 0x9E, 0xFD, 0x77, 0x77, 0x74, 0x86, 0x3A, 0xEE, 0xB4, 0x03,
  0xA2, 0x05, 0xE0, 0x60, 0x5A, 0x10, 0x20, 0xEA, 0x84, 0x96, 0x7D, 0xFA, 0xA1, 0x09, 0xA0, 0x63,
  0x01, 0x0D, 0xB1, 0x81, 0xEF, 0xD5, 0x04, 0xB0, 0x3A, 0x08, 0x6B, 0x05, 0xA0, 0x56, 0x0C, 0xA0,
  0x7A, 0x03, 0x60, 0xAA, 0x07, 0xA0, 0x36, 0x0A, 0xA0, 0x7A, 0x03, 0x60, 0x9A, 0x07, 0xA0, 0x36,
  0x0A, 0xA0, 0x5A, 0x05, 0x60, 0xBA, 0x03, 0xA0, 0x86, 0x0E, 0xA1, 0x81, 0xEF, 0xC5, 0x03, 0xB1,
  0x0A, 0xA0, 0x64, 0x0C, 0xB1, 0x02, 0xB8, 0x49, 0x67, 0xDF, 0xBA, 0x20, 0x6E, 0x06, 0x09, 0xA3,
  0x86, 0x4B, 0xEE, 0xB4, 0x09, 0xA7, 0x30, 0xAA, 0x73, 0x81, 0xAF, 0xE7, 0x38, 0x1D, 0xFC, 0x72,
  0x02, 0xA8, 0x29, 0x04, 0x26, 0x0C, 0xA8, 0x90, 0x30, 0x8F, 0xC8, 0x65, 0x8D, 0xA0, 0xA2, 0x08,
  0xF9, 0x0B, 0x48, 0x16, 0xAD, 0xA8, 0x1D, 0xA5, 0x30,
  // "Ġ" (U+0120)
  0x71, 0x81, 0x3E, 0xC7, 0x70, 0xAA, 0x05, 0x76, 0x0A, 0xA0, 0x57, 0x68, 0x13, 0xEC, 0x80, 0x99,
  0x40, 0x87, 0x49, 0xDE, 0xFE, 0xC8, 0x46, 0x02, 0x0C, 0xFA, 0x0B, 0x40, 0x30, 0xEA, 0x87, 0xE9,
  0x65, 0x7A, 0xEF, 0x73, 0x01, 0x0E, 0xA0, 0x97, 0x07, 0x01, 0x30, 0xBA, 0x08, 0x75, 0x03, 0xA0,
  0xD7, 0x60, 0x8A, 0x06, 0x76, 0x0D, 0xA0, 0x17, 0x6A, 0x0D, 0x76, 0x02, 0xA0, 0xA7, 0x60, 0x4A,
  0x09, 0x50, 0x18, 0x02, 0x50, 0x10, 0x4A, 0x09, 0x50, 0x2E, 0x04, 0x03, 0xA0, 0x95, 0x02, 0xE0,
  0x40, 0x2A, 0x0B, 0x72, 0x06, 0xA0, 0x41, 0xA0, 0xD7, 0x20, 0x6A, 0x81, 0x40, 0xCA, 0x01, 0x71,
  0x06, 0xA8, 0x14, 0x08, 0xA0, 0x57, 0x10, 0x6A, 0x81, 0x40, 0x4A, 0x0C, 0x71, 0x06, 0xA0, 0x42,
  0x0C, 0xA0, 0x77, 0x06, 0xA0, 0x42, 0x03, 0xB0, 0x66, 0x06, 0xA0, 0x43, 0x06, 0xB8, 0x5D, 0x86,
  0x67, 0x9D, 0xA0, 0x44, 0x05, 0x0E, 0xFB, 0x04, 0x58, 0x21, 0x7B, 0xEA, 0x83, 0xEC, 0xA6, 0x21,
  // "ġ" (U+0121)
  0x58, 0x13, 0xEC, 0x73, 0x0A, 0xA0, 0x57, 0x20, 0xAA, 0x05, 0x72, 0x81, 0x3E, 0xC8, 0x0D, 0x30,
  0x86, 0x3A, 0xEE, 0xB4, 0x03, 0xA2, 0x05, 0xE0, 0x60, 0x5A, 0x10, 0x20, 0xEA, 0x84, 0x96, 0x7D,
  0xFA, 0xA1, 0x09, 0xA0, 0x63, 0x01, 0x0D, 0xB1, 0x81, 0xEF, 0xD5, 0x04, 0xB0, 0x3A, 0x08, 0x6B,
  0x05, 0xA0, 0x56, 0x0C, 0xA0, 0x7A, 0x03, 0x60, 0xAA, 0x07, 0xA0, 0x36, 0x0A, 0xA0, 0x7A, 0x03,
  0x60, 0x9A, 0x07, 0xA0, 0x36, 0x0A, 0xA0, 0x5A, 0x05, 0x60, 0xBA, 0x03, 0xA0, 0x86, 0x0E, 0xA1,
  0x81, 0xEF, 0xC5, 0x03, 0xB1, 0x0A, 0xA0, 0x64, 0x0C, 0xB1, 0x02, 0xB8, 0x49, 0x67, 0xDF, 0xBA,
  0x20, 0x6E, 0x06, 0x09, 0xA3, 0x86, 0x4B, 0xEE, 0xB4, 0x09, 0xA7, 0x30, 0xAA, 0x73, 0x81, 0xAF,
  0xE7, 0x38, 0x1D, 0xFC, 0x72, 0x02, 0xA8, 0x29, 0x04, 0x26, 0x0C, 0xA8, 0x90, 0x30, 0x8F, 0xC8,
  0x65, 0x8D, 0xA0, 0xA2, 0x08, 0xF9, 0x0B, 0x48, 0x16, 0xAD, 0xA8, 0x1D, 0xA5, 0x30,
  // "Ģ" (U+0122)
  0x68, 0x74, 0x9D, 0xEF, 0xEC, 0x84, 0x60, 0x20, 0xCF, 0xA0, 0xB4, 0x03, 0x0E, 0xA8, 0x7E, 0x96,
  0x57, 0xAE, 0xF7, 0x30, 0x10, 0xEA, 0x09, 0x70, 0x70, 0x13, 0x0B, 0xA0, 0x87, 0x50, 0x3A, 0x0D,
  0x76, 0x08, 0xA0, 0x67, 0x60, 0xDA, 0x01, 0x76, 0xA0, 0xD7, 0x60, 0x2A, 0x0A, 0x76, 0x04, 0xA0,
  0x95, 0x01, 0x80, 0x25, 0x01, 0x04, 0xA0, 0x95, 0x02, 0xE0, 0x40, 0x3A, 0x09, 0x50, 0x2E, 0x04,
  0x02, 0xA0, 0xB7, 0x20, 0x6A, 0x04, 0x1A, 0x0D, 0x72, 0x06, 0xA8, 0x14, 0x0C, 0xA0, 0x17, 0x10,
  0x6A, 0x81, 0x40, 0x8A, 0x05, 0x71, 0x06, 0xA8, 0x14, 0x04, 0xA0, 0xC7, 0x10, 0x6A, 0x04, 0x20,
  0xCA, 0x07, 0x70, 0x6A, 0x04, 0x20, 0x3B, 0x06, 0x60, 0x6A, 0x04, 0x30, 0x6B, 0x85, 0xD8, 0x66,
  0x79, 0xDA, 0x04, 0x40, 0x50, 0xEF, 0xB0, 0x45, 0x82, 0x17, 0xBE, 0xA8, 0x3E, 0xCA, 0x62, 0x80,
  0xC7, 0x00, 0x8A, 0x03, 0x76, 0x81, 0xAF, 0xD7, 0x78, 0x1E, 0xF6, 0x76, 0x81, 0x2F, 0xD7, 0x78,
  0x17, 0xF4, 0x70,
  // "ģ" (U+0123)
  0x68, 0x15, 0xF7, 0x72, 0x82, 0x1E, 0xF1, 0x72, 0x81, 0x8F, 0xC7, 0x3A, 0x08, 0x72, 0x05, 0xA0,
  0x57, 0x77, 0x76, 0x86, 0x3A, 0xEE, 0xB4, 0x03, 0xA2, 0x05, 0xE0, 0x60, 0x5A, 0x10, 0x20, 0xEA,
  0x84, 0x96, 0x7D, 0xFA, 0xA1, 0x09, 0xA0, 0x63, 0x01, 0x0D, 0xB1, 0x81, 0xEF, 0xD5, 0x04, 0xB0,
  0x3A, 0x08, 0x6B, 0x05, 0xA0, 0x56, 0x0C, 0xA0, 0x7A, 0x03, 0x60, 0xAA, 0x07, 0xA0, 0x36, 0x0A,
  0xA0, 0x7A, 0x03, 0x60, 0x9A, 0x07, 0xA0, 0x36, 0x0A, 0xA0, 0x5A, 0x05, 0x60, 0xBA, 0x03, 0xA0,
  0x86, 0x0E, 0xA1, 0x81, 0xEF, 0xC5, 0x03, 0xB1, 0x0A, 0xA0, 0x64, 0x0C, 0xB1, 0x02, 0xB8, 0x49,
  0x67, 0xDF, 0xBA, 0x20, 0x6E, 0x06, 0x09, 0xA3, 0x86, 0x4B, 0xEE, 0xB4, 0x09, 0xA7, 0x30, 0xAA,
  0x73, 0x81, 0xAF, 0xE7, 0x38, 0x1D, 0xFC, 0x72, 0x02, 0xA8, 0x29, 0x04, 0x26, 0x0C, 0xA8, 0x90,
  0x30, 0x8F, 0xC8, 0x65, 0x8D, 0xA0, 0xA2, 0x08, 0xF9, 0x0B, 0x48, 0x16, 0xAD, 0xA8, 0x1D, 0xA5,
  0x30,
  // "Ĥ" (U+0124)
  0x68, 0x24, 0x77, 0x17, 0x30, 0x10, 0xEA, 0x09, 0x73, 0x09, 0xC0, 0x37, 0x10, 0x3A, 0x82, 0x49,
  0xFC, 0x71, 0x81, 0xDF, 0x52, 0x81, 0xAF, 0x86, 0x81, 0x9F, 0x64, 0x81, 0xAF, 0x38, 0x0D, 0x30,
  0x06, 0xA0, 0x47, 0x03, 0xA0, 0x80, 0x6A, 0x04, 0x70, 0x3A, 0x08, 0x06, 0xA0, 0x47, 0x03, 0xA0,
  0x80, 0x6A, 0x04, 0x70, 0x3A, 0x08, 0x06, 0xA0, 0x47, 0x03, 0xA0, 0x80, 0x6A, 0x04, 0x70, 0x3A,
  0x08, 0x06, 0xA0, 0x47, 0x03, 0xA0, 0x80, 0x6A, 0x04, 0x70, 0x3A, 0x08, 0x06, 0xA0, 0x47, 0x03,
  0xA0, 0x80, 0x6A, 0x08, 0x80, 0x35, 0x07, 0xA0, 0x80, 0x6F, 0xE0, 0x80, 0x6F, 0xE0, 0x80, 0x6A,
  0x04, 0x70, 0x3A, 0x08, 0x06, 0xA0, 0x47, 0x03, 0xA0, 0x80, 0x6A, 0x04, 0x70, 0x3A, 0x08, 0x06,
  0xA0, 0x47, 0x03, 0xA0, 0x80, 0x6A, 0x04, 0x70, 0x3A, 0x08, 0x06, 0xA0, 0x47, 0x03, 0xA0, 0x80,
  0x6A, 0x04, 0x70, 0x3A, 0x08, 0x06, 0xA0, 0x47, 0x03, 0xA0, 0x80, 0x6A, 0x04, 0x70, 0x3A, 0x08,
  0x06, 0xA0, 0x47, 0x03, 0xA0, 0x80, 0x6A, 0x04, 0x70, 0x3A, 0x08,
  // "ĥ" (U+0125)
  0x38, 0x24, 0x77, 0x17, 0x30, 0x10, 0xEA, 0x09, 0x73, 0x09, 0xC0, 0x37, 0x10, 0x3A, 0x82, 0x49,
  0xFC, 0x71, 0x81, 0xDF, 0x52, 0x81, 0xAF, 0x86, 0x81, 0x9F, 0x64, 0x81, 0xAF, 0x38, 0x0C, 0x20,
  0x81, 0xBF, 0xE7, 0x58, 0x1B, 0xFE, 0x75, 0x81, 0xBF, 0xE7, 0x58, 0x1B, 0xFE, 0x75, 0x81, 0xBF,
  0xE7, 0x58, 0x1B, 0xFE, 0x75, 0x81, 0xBF, 0xE7, 0x58, 0x90, 0xBF, 0xE0, 0x2A, 0xEE, 0xC7, 0x58,
  0x3B, 0xFD, 0x4E, 0xD0, 0xA4, 0x87, 0xBF, 0xDD, 0xE8, 0x68, 0xEA, 0x04, 0x30, 0xBA, 0x0E, 0x02,
  0x30, 0x4A, 0x0A, 0x30, 0xBA, 0x08, 0x58, 0x1E, 0xFD, 0x30, 0xBA, 0x03, 0x58, 0x1B, 0xFE, 0x30,
  0xBA, 0x01, 0x58, 0x1B, 0xFE, 0x30, 0xBA, 0x68, 0x1A, 0xFE, 0x38, 0x1B, 0xFE, 0x68, 0x1A, 0xFE,
  0x38, 0x1B, 0xFE, 0x68, 0x1A, 0xFE, 0x38, 0x1B, 0xFE, 0x68, 0x1A, 0xFE, 0x38, 0x1B, 0xFE, 0x68,
  0x1A, 0xFE, 0x38, 0x1B, 0xFE, 0x68, 0x1A, 0xFE, 0x38, 0x1B, 0xFE, 0x68, 0x1A, 0xFE, 0x38, 0x1B,
  0xFE, 0x68, 0x1A, 0xFE, 0x38, 0x1B, 0xFE, 0x68, 0x1A, 0xFE, 0x38, 0x1B, 0xFE, 0x68, 0x1A, 0xFE,
  0x38, 0x1B, 0xFE, 0x68, 0x1A, 0xFE,
  // "Ħ" (U+0126)
  0x20, 0x6A, 0x04, 0x70, 0x4A, 0x07, 0x50, 0x6A, 0x04, 0x70, 0x4A, 0x07, 0x50, 0x6A, 0x04, 0x70,
  0x4A, 0x07, 0x38, 0x15, 0x59, 0xA0, 0x88, 0x03, 0x50, 0x8A, 0x81, 0xA5, 0x51, 0xFF, 0xD0, 0x1F,
  0xFD, 0x01, 0x20, 0x6A, 0x04, 0x70, 0x3A, 0x07, 0x50, 0x6A, 0x04, 0x70, 0x3A, 0x07, 0x50, 0x6A,
  0x04, 0x70, 0x3A, 0x07, 0x50, 0x6A, 0x08, 0x80, 0x35, 0x07, 0xA0, 0x75, 0x06, 0xFE, 0x07, 0x50,
  0x6F, 0xE0, 0x75, 0x06, 0xA0, 0x47, 0x04, 0xA0, 0x75, 0x06, 0xA0, 0x47, 0x04, 0xA0, 0x75, 0x06,
  0xA0, 0x47, 0x04, 0xA0, 0x75, 0x06, 0xA0, 0x47, 0x04, 0xA0, 0x75, 0x06, 0xA0, 0x47, 0x04, 0xA0,
  0x75, 0x06, 0xA0, 0x47, 0x04, 0xA0, 0x75, 0x06, 0xA0, 0x47, 0x04, 0xA0, 0x75, 0x06, 0xA0, 0x47,
  0x04, 0xA0, 0x75, 0x06, 0xA0, 0x47, 0x04, 0xA0, 0x75, 0x06, 0xA0, 0x47, 0x04, 0xA0, 0x75, 0x06,
  0xA0, 0x47, 0x04, 0xA0, 0x73,
  // "ħ" (U+0127)
  0x28, 0x1B, 0xFE, 0x74, 0x81, 0xBF, 0xE7, 0x48, 0x1B, 0xFE, 0x72, 0x0B, 0xF9, 0x08, 0x40, 0xBF,
  0x90, 0x84, 0x89, 0x04, 0x5C, 0xFE, 0x55, 0x55, 0x26, 0x81, 0xBF, 0xE7, 0x48, 0x90, 0xBF, 0xE0,
  0x2A, 0xEE, 0xC7, 0x48, 0x3B, 0xFD, 0x3E, 0xD0, 0xA3, 0x87, 0xBF, 0xCD, 0xE8, 0x68, 0xEA, 0x04,
  0x20, 0xBA, 0x0E, 0x02, 0x30, 0x4A, 0x09, 0x20, 0xBA, 0x07, 0x58, 0x1E, 0xFC, 0x20, 0xBA, 0x03,
  0x58, 0x1B, 0xFE, 0x20, 0xBA, 0x68, 0x1B, 0xFE, 0x28, 0x1B, 0xFE, 0x68, 0x1A, 0xFE, 0x28, 0x1B,
  0xFE, 0x68, 0x1A, 0xFE, 0x28, 0x1B, 0xFD, 0x68, 0x1A, 0xFE, 0x28, 0x1B, 0xFD, 0x68, 0x1A, 0xFE,
  0x28, 0x1B, 0xFD, 0x68, 0x1A, 0xFE, 0x28, 0x1B, 0xFD, 0x68, 0x1A, 0xFE, 0x28, 0x1B, 0xFD, 0x68,
  0x1A, 0xFE, 0x28, 0x1B, 0xFD, 0x68, 0x1A, 0xFE, 0x28, 0x1B, 0xFD, 0x68, 0x1A, 0xFE, 0x28, 0x1B,
  0xFD, 0x68, 0x1A, 0xFE, 0x28, 0x1B, 0xFD, 0x68, 0x1A, 0xFE,
  // "Ĩ" (U+0128)
  0x18, 0x34, 0xDE, 0xA2, 0x28, 0x35, 0xF5, 0x0E, 0xC8, 0x90, 0x96, 0xDF, 0x26, 0xFB, 0x6C, 0xC8,
  0x3B, 0x09, 0xF1, 0x28, 0x35, 0xCF, 0xB1, 0x80, 0xC0, 0x00, 0xDE, 0x06, 0x30, 0xCE, 0x05, 0x40,
  0x20, 0xBA, 0x05, 0x70, 0x9A, 0x02, 0x70, 0x9A, 0x02, 0x70, 0x9A, 0x02, 0x70, 0x9A, 0x02, 0x70,
  0x9A, 0x02, 0x70, 0x9A, 0x02, 0x70, 0x9A, 0x02, 0x70, 0x9A, 0x02, 0x70, 0x9A, 0x02, 0x70, 0x9A,
  0x02, 0x70, 0x9A, 0x02, 0x70, 0x9A, 0x02, 0x70, 0x9A, 0x02, 0x70, 0x9A, 0x02, 0x70, 0x9A, 0x02,
  0x70, 0x9A, 0x02, 0x70, 0x9A, 0x02, 0x70, 0x9A, 0x02, 0x50, 0x80, 0xDC, 0x0C, 0x03, 0x30, 0xDE,
  0x06, 0x10,
  // "ĩ" (U+0129)
  0x18, 0x34, 0xDE, 0xA2, 0x28, 0x35, 0xF5, 0x0E, 0xC8, 0x90, 0x96, 0xDF, 0x26, 0xFB, 0x6C, 0xC8,
  0x3B, 0x09, 0xF1, 0x28, 0x35, 0xCF, 0xB1, 0x77, 0x76, 0x81, 0xBF, 0xE7, 0x18, 0x1B, 0xFE, 0x71,
  0x81, 0xBF, 0xE7, 0x18, 0x1B, 0xFE, 0x71, 0x81, 0xBF, 0xE7, 0x18, 0x1B, 0xFE, 0x71, 0x81, 0xBF,
  0xE7, 0x18, 0x1B, 0xFE, 0x71, 0x81, 0xBF, 0xE7, 0x18, 0x1B, 0xFE, 0x71, 0x81, 0xBF, 0xE7, 0x18,
  0x1B, 0xFE, 0x71, 0x81, 0xBF, 0xE7, 0x18, 0x1B, 0xFE, 0x71, 0x81, 0xBF, 0xE7, 0x18, 0x1B, 0xFE,
  0x71, 0x81, 0xBF, 0xE7, 0x18, 0x1B, 0xFE, 0x40,
  // "Ī" (U+012A)
  0x04, 0x80, 0x35, 0x03, 0x0B, 0xF0, 0x80, 0xBF, 0x08, 0x77, 0x77, 0x0D, 0xE8, 0x16, 0x0C, 0xE0,
  0x52, 0x02, 0x0B, 0xA0, 0x55, 0x09, 0xA0, 0x25, 0x09, 0xA0, 0x25, 0x09, 0xA0, 0x25, 0x09, 0xA0,
  0x25, 0x09, 0xA0, 0x25, 0x09, 0xA0, 0x25, 0x09, 0xA0, 0x25, 0x09, 0xA0, 0x25, 0x09, 0xA0, 0x25,
  0x09, 0xA0, 0x25, 0x09, 0xA0, 0x25, 0x09, 0xA0, 0x25, 0x09, 0xA0, 0x25, 0x09, 0xA0, 0x25, 0x09,
  0xA0, 0x25, 0x09, 0xA0, 0x25, 0x09, 0xA0, 0x25, 0x09, 0xA0, 0x23, 0x08, 0x0D, 0xC8, 0x2C, 0x30,
  0xDE, 0x06,
  // "ī" (U+012B)
  0x04, 0x80, 0x35, 0x03, 0x0B, 0xF0, 0x80, 0xBF, 0x08, 0x77, 0x78, 0x1B, 0xFE, 0x68, 0x1B, 0xFE,
  0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68,
  0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B,
  0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE, 0x68, 0x1B, 0xFE,
  0x30,
  // "Ĭ" (U+012C)
  0x05, 0x07, 0x58, 0x37, 0x59, 0xF4, 0x38, 0x94, 0x4F, 0x95, 0xFE, 0x86, 0x8E, 0xF4, 0x0C, 0xD0,
  0xA2, 0x84, 0x19, 0xEF, 0xD7, 0x77, 0x77, 0x20, 0xDE, 0x81, 0x60, 0xCE, 0x05, 0x20, 0x20, 0xBA,
  0x05, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02,
  0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50,
  0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A,
  0x02, 0x50, 0x9A, 0x02, 0x50, 0x9A, 0x02, 0x30, 0x80, 0xDC, 0x82, 0xC3, 0x0D, 0xE0, 0x60,
  // "ĭ" (U+012D)
  0x05, 0x07, 0x58, 0x37, 0x59, 0xF4, 0x38, 0x94, 0x4F, 0x95, 0xFE, 0x86, 0x8E, 0xF4, 0x0C, 0xD0,
  0xA2, 0x84, 0x19, 0xEF, 0xD7, 0x77, 0x72, 0x81, 0xBF, 0xE6, 0x81, 0xBF, 0xE6, 0x81, 0xBF, 0xE6,
  0x81, 0xBF, 0xE6, 0x81, 0xBF, 0xE6, 0x81, 0xBF, 0xE6, 0x81, 0xBF, 0xE6, 0x81, 0xBF, 0xE6, 0x81,
  0xBF, 0xE6, 0x81, 0xBF, 0xE6, 0x81, 0xBF, 0xE6, 0x81, 0xBF, 0xE6, 0x81, 0xBF, 0xE6, 0x81, 0xBF,
  0xE6, 0x81, 0xBF, 0xE6, 0x81, 0xBF, 0xE6, 0x81, 0xBF, 0xE6, 0x81, 0xBF, 0xE3,
  // "Į" (U+012E)
  0x0D, 0xE0, 0x60, 0xCE, 0x82, 0x50, 0x2B, 0xA0, 0x54, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09,
  0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0,
  0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24,
  0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x24, 0x09, 0xA0, 0x22, 0x08,
  0x0D, 0xC8, 0x1C, 0x3D, 0xE0, 0x63, 0x81, 0x7F, 0x64, 0x81, 0x1F, 0xC5, 0x81, 0x7F, 0x85, 0x81,
  0xAF, 0x85, 0x83, 0x9F, 0xE6, 0x63, 0x05, 0xC0, 0x13, 0x82, 0x7D, 0xFC, 0x10,
  // "į" (U+012F)
  0x28, 0x16, 0xEA, 0x30, 0xDA, 0x01, 0x20, 0xDA, 0x01, 0x28, 0x16, 0xE9, 0x77, 0x78, 0x1B, 0xFE,
  0x38, 0x1B, 0xFE, 0x38, 0x1B, 0xFE, 0x38, 0x1B, 0xFE, 0x38, 0x1B, 0xFE, 0x38, 0x1B, 0xFE, 0x38,
  0x1B, 0xFE, 0x38, 0x1B, 0xFE, 0x38, 0x1B, 0xFE, 0x38, 0x1B, 0xFE, 0x38, 0x1B, 0xFE, 0x38, 0x1B,
  0xFE, 0x38, 0x1B, 0xFE, 0x38, 0x1B, 0xFE, 0x38, 0x1B, 0xFE, 0x38, 0x1B, 0xFE, 0x38, 0x1B, 0xFE,
  0x3B, 0x28, 0x17, 0xF6, 0x28, 0x11, 0xFC, 0x38, 0x17, 0xF8, 0x38, 0x1A, 0xF8, 0x38, 0x59, 0xFE,
  0x66, 0x05, 0xC8, 0x41, 0x07, 0xDF, 0xC1,
  // "İ" (U+0130)
  0x28, 0x13, 0xEC, 0x50, 0xAA, 0x05, 0x40, 0xAA, 0x05, 0x48, 0x13, 0xEC, 0x77, 0x77, 0x70, 0xDE,
  0x06, 0x0C, 0xE8, 0x25, 0x02, 0xBA, 0x05, 0x40, 0x9A, 0x02, 0x40, 0x9A, 0x02, 0x40, 0x9A, 0x02,
  0x40, 0x9A, 0x02, 0x40, 0x9A, 0x02, 0x40, 0x9A, 0x02, 0x40, 0x9A, 0x02, 0x40, 0x9A, 0x02, 0x40,
  0x9A, 0x02, 0x40, 0x9A, 0x02, 0x40, 0x9A, 0x02, 0x40, 0x9A, 0x02, 0x40, 0x9A, 0x02, 0x40, 0x9A,
  0x02, 0x40, 0x9A, 0x02, 0x40, 0x9A, 0x02, 0x40, 0x9A, 0x02, 0x40, 0x9A, 0x02, 0x20, 0x80, 0xDC,
  0x81, 0xC3, 0xDE, 0x06,
  // "ı" (U+0131)
  0x8E, 0x4B, 0xFE, 0xBF, 0xEB, 0xFE, 0xBF, 0xEB, 0xFE, 0xBF, 0xEB, 0xFE, 0xBF, 0xEB, 0xFE, 0xBF,
  0xEB, 0xFE, 0xBF, 0xEB, 0xFE, 0xBF, 0xEB, 0xFE, 0xBF, 0xEB, 0xFE, 0xBF, 0xE0,
  // "Ĳ" (U+0132)
  0x0D, 0xE0, 0x62, 0x08, 0xA0, 0x20, 0xCE, 0x05, 0x20, 0x8A, 0x82, 0x20, 0x2B, 0xA0, 0x54, 0x08,
  0xA0, 0x22, 0x09, 0xA0, 0x24, 0x08, 0xA0, 0x22, 0x09, 0xA0, 0x24, 0x08, 0xA0, 0x22, 0x09, 0xA0,
  0x24, 0x08, 0xA0, 0x22, 0x09, 0xA0, 0x24, 0x08, 0xA0, 0x22, 0x09, 0xA0, 0x24, 0x08, 0xA0, 0x22,
  0x09, 0xA0, 0x24, 0x08, 0xA0, 0x22, 0x09, 0xA0, 0x24, 0x08, 0xA0, 0x22, 0x09, 0xA0, 0x24, 0x08,
  0xA0, 0x22, 0x09, 0xA0, 0x24, 0x08, 0xA0, 0x22, 0x09, 0xA0, 0x24, 0x08, 0xA0, 0x22, 0x09, 0xA0,
  0x24, 0x08, 0xA0, 0x22, 0x09, 0xA0, 0x24, 0x08, 0xA0, 0x22, 0x09, 0xA0, 0x24, 0x08, 0xA0, 0x22,
  0x09, 0xA0, 0x24, 0x08, 0xA0, 0x22, 0x09, 0xA0, 0x24, 0x08, 0xA0, 0x22, 0x09, 0xA0, 0x24, 0x08,
  0xA0, 0x22, 0x09, 0xA0, 0x24, 0x08, 0xA0, 0x22, 0x09, 0xA0, 0x24, 0x08, 0xA8, 0x12, 0x8D, 0xC0,
  0xC0, 0x32, 0x08, 0xA0, 0x20, 0xDE, 0x06, 0x20, 0x8A, 0x02, 0x73, 0x08, 0xA0, 0x27, 0x30, 0x8A,
  0x02, 0x73, 0x0A, 0xA7, 0x38, 0x21, 0xEF, 0xD7, 0x82, 0x76, 0x6D, 0xA0, 0x77, 0x0D, 0xC0, 0xC7,
  0x18, 0x3A, 0xEF, 0xD8, 0x30,
  // "ĳ" (U+0133)
  0x81, 0x6E, 0xA4, 0x83, 0x6E, 0xA0, 0xDA, 0x01, 0x30, 0xDA, 0x01, 0x0D, 0xA0, 0x13, 0x0D, 0xA8,
  0x21, 0x6E, 0x94, 0x81, 0x6E, 0x97, 0x77, 0x76, 0x81, 0xBF, 0xE4, 0x85, 0xBF, 0xE0, 0xBF, 0xE4,
  0x85, 0xBF, 0xE0, 0xBF, 0xE4, 0x85, 0xBF, 0xE0, 0xBF, 0xE4, 0x85, 0xBF, 0xE0, 0xBF, 0xE4, 0x85,
  0xBF, 0xE0, 0xBF, 0xE4, 0x85, 0xBF, 0xE0, 0xBF, 0xE4, 0x85, 0xBF, 0xE0, 0xBF, 0xE4, 0x85, 0xBF,
  0xE0, 0xBF, 0xE4, 0x85, 0xBF, 0xE0, 0xBF, 0xE4, 0x85, 0xBF, 0xE0, 0xBF, 0xE4, 0x85, 0xBF, 0xE0,
  0xBF, 0xE4, 0x85, 0xBF, 0xE0, 0xBF, 0xE4, 0x85, 0xBF, 0xE0, 0xBF, 0xE4, 0x85, 0xBF, 0xE0, 0xBF,
  0xE4, 0x85, 0xBF, 0xE0, 0xBF, 0xE4, 0x85, 0xBF, 0xE0, 0xBF, 0xE4, 0x85, 0xBF, 0xE0, 0xBF, 0xE4,
  0x81, 0xBF, 0xE7, 0x18, 0x1B, 0xFE, 0x71, 0x81, 0xBF, 0xE7, 0x18, 0x1B, 0xFE, 0x71, 0x81, 0xCF,
  0xD7, 0x18, 0x1E, 0xFB, 0x58, 0x16, 0x6B, 0xA0, 0x85, 0x0C, 0xB0, 0xE0, 0x15, 0x83, 0xAE, 0xEB,
  0x22,
  // "Ĵ" (U+0134)
  0x48, 0x24, 0x77, 0x16, 0x01, 0x0E, 0xA0, 0x96, 0x09, 0xC0, 0x34, 0x03, 0xA8, 0x24, 0x9F, 0xC4,
  0x81, 0xDF, 0x52, 0x81, 0xAF, 0x82, 0x81, 0x9F, 0x64, 0x81, 0xAF, 0x38, 0x0C, 0x10, 0x08, 0xA0,
  0x27, 0x08, 0xA0, 0x27, 0x08, 0xA0, 0x27, 0x08, 0xA0, 0x27, 0x08, 0xA0, 0x27, 0x08, 0xA0, 0x27,
  0x08, 0xA0, 0x27, 0x08, 0xA0, 0x27, 0x08, 0xA0, 0x27, 0x08, 0xA0, 0x27, 0x08, 0xA0, 0x27, 0x08,
  0xA0, 0x27, 0x08, 0xA0, 0x27, 0x08, 0xA0, 0x27, 0x08, 0xA0, 0x27, 0x08, 0xA0, 0x27, 0x08, 0xA0,
  0x27, 0x08, 0xA0, 0x27, 0x08, 0xA0, 0x27, 0x08, 0xA0, 0x27, 0x08, 0xA0, 0x27, 0x08, 0xA0, 0x27,
  0x08, 0xA0, 0x27, 0x08, 0xA0, 0x27, 0x08, 0xA0, 0x27, 0x0A, 0xA7, 0x82, 0x1E, 0xFD, 0x48, 0x27,
  0x66, 0xDA, 0x07, 0x40, 0xDC, 0x0C, 0x58, 0x3A, 0xEF, 0xD8, 0x60,
  // "ĵ" (U+0135)
  0x38, 0x24, 0x77, 0x15, 0x01, 0x0E, 0xA0, 0x95, 0x09, 0xC0, 0x33, 0x03, 0xA8, 0x24, 0x9F, 0xC3,
  0x81, 0xDF, 0x52, 0x85, 0xAF, 0x80, 0x9F, 0x64, 0x81, 0xAF, 0x37, 0x77, 0x28, 0x1B, 0xFE, 0x78,
  0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B,
  0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE,
  0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78,
  0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1C, 0xFD, 0x78, 0x1E,
  0xFB, 0x48, 0x16, 0x6B, 0xA0, 0x74, 0x0C, 0xB0, 0xE0, 0x14, 0x83, 0xAE, 0xEB, 0x25,
  // "Ķ" (U+0136)
  0x06, 0xA0, 0x46, 0x09, 0xA0, 0x06, 0xA0, 0x45, 0x03, 0xA8, 0x1B, 0x06, 0xA0, 0x45, 0x0D, 0xA8,
  0x12, 0x06, 0xA0, 0x44, 0x07, 0xA0, 0x72, 0x06, 0xA0, 0x43, 0x02, 0xA0, 0xC3, 0x06, 0xA0, 0x43,
  0x0B, 0xA0, 0x23, 0x06, 0xA0, 0x42, 0x06, 0xA0, 0x74, 0x06, 0xA8, 0x44, 0x01, 0xEF, 0xC5, 0x06,
  0xA8, 0x14, 0x0A, 0xA0, 0x35, 0x06, 0xA0, 0x04, 0xA0, 0x86, 0x06, 0xA0, 0x50, 0xDA, 0x03, 0x60,
  0x6A, 0x0D, 0xB0, 0xB6, 0x06, 0xB0, 0xE0, 0xCA, 0x04, 0x50, 0x6A, 0x81, 0xE2, 0x3A, 0x0C, 0x50,
  0x6A, 0x05, 0x20, 0xAA, 0x05, 0x40, 0x6A, 0x04, 0x20, 0x2A, 0x0D, 0x40, 0x6A, 0x04, 0x30, 0x9A,
  0x07, 0x30, 0x6A, 0x04, 0x38, 0x31, 0xEF, 0xE1, 0x20, 0x6A, 0x04, 0x40, 0x8A, 0x08, 0x20, 0x6A,
  0x04, 0x50, 0xEA, 0x81, 0x20, 0x6A, 0x04, 0x50, 0x6A, 0x81, 0xA0, 0x6A, 0x04, 0x60, 0xDA, 0x03,
  0x06, 0xA0, 0x46, 0x05, 0xA0, 0xB7, 0x77, 0x75, 0x08, 0xA0, 0x37, 0x38, 0x1A, 0xFD, 0x74, 0x81,
  0xEF, 0x67, 0x38, 0x12, 0xFD, 0x74, 0x81, 0x7F, 0x47,
  // "ķ" (U+0137)
  0x81, 0xBF, 0xE7, 0x28, 0x1B, 0xFE, 0x72, 0x81, 0xBF, 0xE7, 0x28, 0x1B, 0xFE, 0x72, 0x81, 0xBF,
  0xE7, 0x28, 0x1B, 0xFE, 0x72, 0x81, 0xBF, 0xE7, 0x28, 0x1B, 0xFE, 0x50, 0xBA, 0x82, 0x3B, 0xFE,
  0x40, 0x6A, 0x83, 0x70, 0xBF, 0xE3, 0x82, 0x1E, 0xFC, 0x28, 0x1B, 0xFE, 0x38, 0x2B, 0xFE, 0x22,
  0x81, 0xBF, 0xE2, 0x06, 0xA0, 0x63, 0x86, 0xBF, 0xE0, 0x1E, 0xFB, 0x48, 0x6B, 0xFD, 0x0B, 0xFE,
  0x14, 0x82, 0xBF, 0xD5, 0xA0, 0xB5, 0x82, 0xBF, 0xDD, 0xB0, 0x24, 0x0B, 0xB0, 0xAA, 0x0A, 0x40,
  0xBA, 0x81, 0xA0, 0xAA, 0x02, 0x38, 0x1B, 0xFE, 0x20, 0x3A, 0x0A, 0x38, 0x1B, 0xFE, 0x30, 0xBA,
  0x02, 0x28, 0x1B, 0xFE, 0x30, 0x3A, 0x0A, 0x28, 0x1B, 0xFE, 0x40, 0xBA, 0x83, 0x20, 0xBF, 0xE4,
  0x04, 0xA8, 0x3A, 0x0B, 0xFE, 0x50, 0xCA, 0x82, 0x2B, 0xFE, 0x50, 0x5A, 0x09, 0x77, 0x77, 0x08,
  0xA0, 0x37, 0x18, 0x1A, 0xFD, 0x72, 0x81, 0xEF, 0x67, 0x18, 0x12, 0xFD, 0x72, 0x81, 0x7F, 0x46,
  // "ĸ" (U+0138)
  0x0B, 0xA5, 0x0B, 0xA0, 0x30, 0xBA, 0x40, 0x6A, 0x81, 0x80, 0xBA, 0x38, 0x21, 0xEF, 0xC2, 0x0B,
  0xA3, 0x0A, 0xA0, 0x32, 0x0B, 0xA2, 0x05, 0xA0, 0x83, 0x0B, 0xA1, 0x82, 0x1E, 0xFC, 0x48, 0x3B,
  0xFE, 0x09, 0xA0, 0x34, 0x82, 0xBF, 0xD4, 0xA0, 0xC5, 0x82, 0xBF, 0xDC, 0xB0, 0x44, 0x0B, 0xB0,
  0xBA, 0x0B, 0x40, 0xBA, 0x81, 0xC0, 0x9A, 0x03, 0x30, 0xBA, 0x81, 0x10, 0x2A, 0x0B, 0x30, 0xBA,
  0x30, 0xAA, 0x03, 0x20, 0xBA, 0x30, 0x3A, 0x0A, 0x20, 0xBA, 0x40, 0xBA, 0x81, 0x20, 0xBA, 0x40,
  0x3A, 0x81, 0xA0, 0xBA, 0x50, 0xCA, 0x02, 0x0B, 0xA5, 0x04, 0xA0, 0xA0,
  // "Ĺ" (U+0139)
  0x30, 0xF7, 0x02, 0x60, 0x5A, 0x0D, 0x01, 0x60, 0xDA, 0x03, 0x60, 0x6A, 0x06, 0x68, 0x21, 0xEF,
  0x87, 0x81, 0x9F, 0x88, 0x0C, 0x50, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06,
  0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0,
  0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47,
  0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06,
  0xA0, 0x47, 0x06, 0xA0, 0xA8, 0x02, 0x80, 0x06, 0xFA, 0x0B, 0x06, 0xFA, 0x0B,
  // "ĺ" (U+013A)
  0x30, 0xF7, 0x02, 0x20, 0x5A, 0x0D, 0x01, 0x20, 0xDA, 0x03, 0x20, 0x6A, 0x06, 0x28, 0x21, 0xEF,
  0x83, 0x81, 0x9F, 0x87, 0x74, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF,
  0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4,
  0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81,
  0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF,
  0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4, 0x81, 0xBF, 0xE4,
  // "Ļ" (U+013B)
  0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06,
  0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0,
  0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47,
  0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0xA8, 0x02,
  0x80, 0x06, 0xFA, 0x0B, 0x06, 0xFA, 0x0B, 0x77, 0x75, 0x08, 0xA0, 0x37, 0x81, 0xAF, 0xD7, 0x18,
  0x1E, 0xF6, 0x78, 0x12, 0xFD, 0x71, 0x81, 0x7F, 0x45,
  // "ļ" (U+013C)
  0x18, 0x1B, 0xFE, 0x28, 0x1B, 0xFE, 0x28, 0x1B, 0xFE, 0x28, 0x1B, 0xFE, 0x28, 0x1B, 0xFE, 0x28,
  0x1B, 0xFE, 0x28, 0x1B, 0xFE, 0x28, 0x1B, 0xFE, 0x28, 0x1B, 0xFE, 0x28, 0x1B, 0xFE, 0x28, 0x1B,
  0xFE, 0x28, 0x1B, 0xFE, 0x28, 0x1B, 0xFE, 0x28, 0x1B, 0xFE, 0x28, 0x1B, 0xFE, 0x28, 0x1B, 0xFE,
  0x28, 0x1B, 0xFE, 0x28, 0x1B, 0xFE, 0x28, 0x1B, 0xFE, 0x28, 0x1B, 0xFE, 0x28, 0x1B, 0xFE, 0x28,
  0x1B, 0xFE, 0x28, 0x1B, 0xFE, 0x28, 0x1B, 0xFE, 0x28, 0x1B, 0xFE, 0x75, 0x08, 0xA8, 0x33, 0x0A,
  0xFD, 0x28, 0x5E, 0xF6, 0x02, 0xFD, 0x28, 0x17, 0xF4, 0x20,
  // "Ľ" (U+013D)
  0x71, 0x07, 0xA0, 0x30, 0x6A, 0x04, 0x48, 0x39, 0xFE, 0x06, 0xA0, 0x44, 0x83, 0xCF, 0x80, 0x6A,
  0x04, 0x48, 0x3E, 0xF1, 0x06, 0xA0, 0x43, 0x81, 0x2F, 0x82, 0x06, 0xA0, 0x47, 0x10, 0x6A, 0x04,
  0x71, 0x06, 0xA0, 0x47, 0x10, 0x6A, 0x04, 0x71, 0x06, 0xA0, 0x47, 0x10, 0x6A, 0x04, 0x71, 0x06,
  0xA0, 0x47, 0x10, 0x6A, 0x04, 0x71, 0x06, 0xA0, 0x47, 0x10, 0x6A, 0x04, 0x71, 0x06, 0xA0, 0x47,
  0x10, 0x6A, 0x04, 0x71, 0x06, 0xA0, 0x47, 0x10, 0x6A, 0x04, 0x71, 0x06, 0xA0, 0x47, 0x10, 0x6A,
  0x04, 0x71, 0x06, 0xA0, 0xA8, 0x02, 0x88, 0x16, 0x06, 0xFA, 0x81, 0xB0, 0x6F, 0xA0, 0xB1,
  // "ľ" (U+013E)
  0x83, 0xBF, 0xE0, 0x7A, 0x8B, 0x53, 0xBF, 0xE0, 0x9F, 0xE0, 0xBF, 0xE0, 0xCF, 0x80, 0xBF, 0xE0,
  0xEF, 0x10, 0xBF, 0xE2, 0xF8, 0x28, 0x1B, 0xFE, 0x58, 0x1B, 0xFE, 0x58, 0x1B, 0xFE, 0x58, 0x1B,
  0xFE, 0x58, 0x1B, 0xFE, 0x58, 0x1B, 0xFE, 0x58, 0x1B, 0xFE, 0x58, 0x1B, 0xFE, 0x58, 0x1B, 0xFE,
  0x58, 0x1B, 0xFE, 0x58, 0x1B, 0xFE, 0x58, 0x1B, 0xFE, 0x58, 0x1B, 0xFE, 0x58, 0x1B, 0xFE, 0x58,
  0x1B, 0xFE, 0x58, 0x1B, 0xFE, 0x58, 0x1B, 0xFE, 0x58, 0x1B, 0xFE, 0x58, 0x1B, 0xFE, 0x58, 0x1B,
  0xFE, 0x50,
  // "Ŀ" (U+013F)
  0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06,
  0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x42, 0x81, 0x3E, 0xC2, 0x06, 0xA0,
  0x42, 0x0A, 0xA8, 0x15, 0x06, 0xA0, 0x42, 0x0A, 0xA8, 0x15, 0x06, 0xA0, 0x42, 0x81, 0x3E, 0xC2,
  0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06,
  0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0x47, 0x06, 0xA0, 0xA8, 0x02, 0x80, 0x06, 0xFA, 0x0B,
  0x06, 0xFA, 0x0B,
  // "ŀ" (U+0140)
  0x81, 0xBF, 0xE5, 0x81, 0xBF, 0xE5, 0x81, 0xBF, 0xE5, 0x81, 0xBF, 0xE5, 0x81, 0xBF, 0xE5, 0x81,
  0xBF, 0xE5, 0x81, 0xBF, 0xE5, 0x81, 0xBF, 0xE5, 0x81, 0xBF, 0xE5, 0x89, 0x3B, 0xFE, 0x03, 0xEC,
  0x0B, 0xFE, 0x0A, 0xA8, 0x45, 0xBF, 0xE0, 0xAA, 0x89, 0x25, 0xBF, 0xE0, 0x3E, 0xC0, 0xBF, 0xE5,
  0x81, 0xBF, 0xE5, 0x81, 0xBF, 0xE5, 0x81, 0xBF, 0xE5, 0x81, 0xBF, 0xE5, 0x81, 0xBF, 0xE5, 0x81,
  0xBF, 0xE5, 0x81, 0xBF, 0xE5, 0x81, 0xBF, 0xE5, 0x81, 0xBF, 0xE5, 0x81, 0xBF, 0xE5, 0x81, 0xBF,
  0xE5,
  // "Ł" (U+0141)
  0x20, 0x4A, 0x06, 0x72, 0x04, 0xA0, 0x67, 0x20, 0x4A, 0x06, 0x72, 0x04, 0xA0, 0x67, 0x20, 0x4A,
  0x06, 0x72, 0x04, 0xA0, 0x67, 0x20, 0x4A, 0x06, 0x72, 0x04, 0xA0, 0x67, 0x20, 0x4A, 0x06, 0x20,
  0x20, 0x35, 0x04, 0xA8, 0x36, 0x08, 0xFD, 0x50, 0x4A, 0x0A, 0x0D, 0xA0, 0xC0, 0x24, 0x04, 0xC0,
  0xE0, 0x66, 0x07, 0xB0, 0xA0, 0x15, 0x01, 0x0B, 0xB0, 0x87, 0x0C, 0xC0, 0x67, 0x81, 0x3C, 0x8A,
  0x06, 0x72, 0x04, 0xA0, 0x67, 0x20, 0x4A, 0x06, 0x72, 0x04, 0xA0, 0x67, 0x20, 0x4A, 0x06, 0x72,
  0x04, 0xA0, 0xB8, 0x02, 0x80, 0x62, 0x04, 0xFA, 0x0C, 0x20, 0x4F, 0xA0, 0xC0,
  // "ł" (U+0142)
  0x30, 0x9A, 0x01, 0x50, 0x9A, 0x01, 0x50, 0x9A, 0x01, 0x50, 0x9A, 0x01, 0x50, 0x9A, 0x01, 0x50,
  0x9A, 0x01, 0x50, 0x9A, 0x01, 0x50, 0x9A, 0x01, 0x50, 0x9A, 0x01, 0x50, 0x9A, 0x81, 0x17, 0x13,
  0x09, 0xA8, 0x1B, 0xFB, 0x30, 0x9C, 0x08, 0x30, 0xBA, 0x0E, 0x04, 0x20, 0x10, 0xBB, 0x02, 0x20,
  0x30, 0xEC, 0x01, 0x28, 0x21, 0xED, 0xCA, 0x01, 0x38, 0x13, 0x19, 0xA0, 0x15, 0x09, 0xA0, 0x15,
  0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09,
  0xA0, 0x15, 0x09, 0xA0, 0x12,
  // "Ń" (U+0143)
  0x72, 0x0F, 0x70, 0x27, 0x40, 0x5A, 0x0D, 0x01, 0x74, 0x0D, 0xA0, 0x37, 0x40, 0x6A, 0x06, 0x74,
  0x82, 0x1E, 0xF8, 0x75, 0x81, 0x9F, 0x88, 0x0E, 0x30, 0x06, 0xB0, 0x17, 0x01, 0xA0, 0x70, 0x6B,
  0x09, 0x70, 0x1A, 0x07, 0x06, 0xC0, 0x16, 0x01, 0xA0, 0x70, 0x6C, 0x08, 0x60, 0x1A, 0x86, 0x76,
  0xFE, 0xDF, 0xE1, 0x50, 0x1A, 0x07, 0x06, 0xA0, 0x5A, 0x08, 0x50, 0x1A, 0x07, 0x06, 0xA8, 0x31,
  0xDF, 0xE1, 0x40, 0x1A, 0x07, 0x06, 0xA0, 0x10, 0x6A, 0x08, 0x40, 0x1A, 0x07, 0x06, 0xA8, 0x42,
  0x0D, 0xFE, 0x13, 0x01, 0xA0, 0x70, 0x6A, 0x81, 0x20, 0x6A, 0x07, 0x30, 0x1A, 0x07, 0x06, 0xA0,
  0x22, 0x81, 0xDF, 0xE3, 0x01, 0xA0, 0x70, 0x6A, 0x02, 0x20, 0x6A, 0x07, 0x20, 0x1A, 0x07, 0x06,
  0xA0, 0x23, 0x81, 0xEF, 0xE2, 0x01, 0xA0, 0x70, 0x6A, 0x02, 0x30, 0x7A, 0x81, 0x60, 0x1A, 0x07,
  0x06, 0xA0, 0x24, 0x83, 0xEF, 0xD0, 0x1A, 0x07, 0x06, 0xA0, 0x24, 0x07, 0xA0, 0x61, 0xA0, 0x70,
  0x6A, 0x02, 0x58, 0x1E, 0xFD, 0x1A, 0x07, 0x06, 0xA0, 0x25, 0x07, 0xA0, 0x6A, 0x07, 0x06, 0xA0,
  0x25, 0x86, 0x1E, 0xFD, 0xEF, 0x76, 0xA0, 0x26, 0x07, 0xC0, 0x70, 0x6A, 0x02, 0x60, 0x10, 0xEB,
  0x07, 0x06, 0xA0, 0x27, 0x08, 0xB0, 0x70, 0x6A, 0x02, 0x70, 0x10, 0xEA, 0x07,
  // "ń" (U+0144)
  0x70, 0xF7, 0x02, 0x70, 0x5A, 0x0D, 0x01, 0x70, 0xDA, 0x03, 0x70, 0x6A, 0x06, 0x78, 0x21, 0xEF,
  0x87, 0x18, 0x19, 0xF8, 0x77, 0x77, 0x18, 0x90, 0xBF, 0x70, 0x2A, 0xEF, 0xC7, 0x28, 0x3B, 0xF9,
  0x3E, 0xD8, 0x91, 0xA0, 0xBF, 0xCD, 0xE8, 0x67, 0xEA, 0x04, 0x0B, 0xA0, 0xE0, 0x23, 0x05, 0xA0,
  0xA0, 0xBA, 0x07, 0x58, 0x2E, 0xFC, 0xBA, 0x03, 0x58, 0x2B, 0xFE, 0xBA, 0x68, 0x2B, 0xFE, 0xBA,
  0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF,
  0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6,
  0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x1A, 0xFE,
  // "Ņ" (U+0145)
  0x06, 0xB0, 0x17, 0x01, 0xA0, 0x70, 0x6B, 0x09, 0x70, 0x1A, 0x07, 0x06, 0xC0, 0x16, 0x01, 0xA0,
  0x70, 0x6C, 0x08, 0x60, 0x1A, 0x86, 0x76, 0xFE, 0xDF, 0xE1, 0x50, 0x1A, 0x07, 0x06, 0xA0, 0x5A,
  0x08, 0x50, 0x1A, 0x07, 0x06, 0xA8, 0x31, 0xDF, 0xE1, 0x40, 0x1A, 0x07, 0x06, 0xA0, 0x10, 0x6A,
  0x08, 0x40, 0x1A, 0x07, 0x06, 0xA8, 0x42, 0x0D, 0xFE, 0x13, 0x01, 0xA0, 0x70, 0x6A, 0x81, 0x20,
  0x6A, 0x07, 0x30, 0x1A, 0x07, 0x06, 0xA0, 0x22, 0x81, 0xDF, 0xE3, 0x01, 0xA0, 0x70, 0x6A, 0x02,
  0x20, 0x6A, 0x07, 0x20, 0x1A, 0x07, 0x06, 0xA0, 0x23, 0x81, 0xEF, 0xE2, 0x01, 0xA0, 0x70, 0x6A,
  0x02, 0x30, 0x7A, 0x81, 0x60, 0x1A, 0x07, 0x06, 0xA0, 0x24, 0x83, 0xEF, 0xD0, 0x1A, 0x07, 0x06,
  0xA0, 0x24, 0x07, 0xA0, 0x61, 0xA0, 0x70, 0x6A, 0x02, 0x58, 0x1E, 0xFD, 0x1A, 0x07, 0x06, 0xA0,
  0x25, 0x07, 0xA0, 0x6A, 0x07, 0x06, 0xA0, 0x25, 0x86, 0x1E, 0xFD, 0xEF, 0x76, 0xA0, 0x26, 0x07,
  0xC0, 0x70, 0x6A, 0x02, 0x60, 0x10, 0xEB, 0x07, 0x06, 0xA0, 0x27, 0x08, 0xB0, 0x70, 0x6A, 0x02,
  0x70, 0x10, 0xEA, 0x07, 0x80, 0xC2, 0x00, 0x8A, 0x03, 0x75, 0x81, 0xAF, 0xD7, 0x68, 0x1E, 0xF6,
  0x75, 0x81, 0x2F, 0xD7, 0x68, 0x17, 0xF4, 0x71,
  // "ņ" (U+0146)
  0x89, 0x0B, 0xF7, 0x02, 0xAE, 0xFC, 0x72, 0x83, 0xBF, 0x93, 0xED, 0x89, 0x1A, 0x0B, 0xFC, 0xDE,
  0x86, 0x7E, 0xA0, 0x40, 0xBA, 0x0E, 0x02, 0x30, 0x5A, 0x0A, 0x0B, 0xA0, 0x75, 0x82, 0xEF, 0xCB,
  0xA0, 0x35, 0x82, 0xBF, 0xEB, 0xA6, 0x82, 0xBF, 0xEB, 0xA6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A,
  0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE,
  0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF,
  0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x81, 0xAF, 0xE7, 0x77, 0x71, 0x08, 0xA0, 0x37, 0x18,
  0x1A, 0xFD, 0x72, 0x81, 0xEF, 0x67, 0x18, 0x12, 0xFD, 0x72, 0x81, 0x7F, 0x45,
  // "Ň" (U+0147)
  0x38, 0x15, 0x71, 0x48, 0x13, 0x73, 0x68, 0x15, 0xFC, 0x38, 0x23, 0xED, 0x17, 0x86, 0x9F, 0xB0,
  0x2E, 0xF3, 0x72, 0x84, 0xDF, 0xAD, 0xF8, 0x73, 0x05, 0xB0, 0xD7, 0x50, 0xBA, 0x05, 0x80, 0xE2,
  0x00, 0x6B, 0x01, 0x70, 0x1A, 0x07, 0x06, 0xB0, 0x97, 0x01, 0xA0, 0x70, 0x6C, 0x01, 0x60, 0x1A,
  0x07, 0x06, 0xC0, 0x86, 0x01, 0xA8, 0x67, 0x6F, 0xED, 0xFE, 0x15, 0x01, 0xA0, 0x70, 0x6A, 0x05,
  0xA0, 0x85, 0x01, 0xA0, 0x70, 0x6A, 0x83, 0x1D, 0xFE, 0x14, 0x01, 0xA0, 0x70, 0x6A, 0x01, 0x06,
  0xA0, 0x84, 0x01, 0xA0, 0x70, 0x6A, 0x84, 0x20, 0xDF, 0xE1, 0x30, 0x1A, 0x07, 0x06, 0xA8, 0x12,
  0x06, 0xA0, 0x73, 0x01, 0xA0, 0x70, 0x6A, 0x02, 0x28, 0x1D, 0xFE, 0x30, 0x1A, 0x07, 0x06, 0xA0,
  0x22, 0x06, 0xA0, 0x72, 0x01, 0xA0, 0x70, 0x6A, 0x02, 0x38, 0x1E, 0xFE, 0x20, 0x1A, 0x07, 0x06,
  0xA0, 0x23, 0x07, 0xA8, 0x16, 0x01, 0xA0, 0x70, 0x6A, 0x02, 0x48, 0x3E, 0xFD, 0x01, 0xA0, 0x70,
  0x6A, 0x02, 0x40, 0x7A, 0x06, 0x1A, 0x07, 0x06, 0xA0, 0x25, 0x81, 0xEF, 0xD1, 0xA0, 0x70, 0x6A,
  0x02, 0x50, 0x7A, 0x06, 0xA0, 0x70, 0x6A, 0x02, 0x58, 0x61, 0xEF, 0xDE, 0xF7, 0x6A, 0x02, 0x60,
  0x7C, 0x07, 0x06, 0xA0, 0x26, 0x01, 0x0E, 0xB0, 0x70, 0x6A, 0x02, 0x70, 0x8B, 0x07, 0x06, 0xA0,
  0x27, 0x01, 0x0E, 0xA0, 0x70,
  // "ň" (U+0148)
  0x18, 0x15, 0x71, 0x48, 0x13, 0x73, 0x28, 0x15, 0xFC, 0x38, 0x23, 0xED, 0x13, 0x86, 0x9F, 0xB0,
  0x2E, 0xF3, 0x58, 0x4D, 0xFA, 0xDF, 0x86, 0x05, 0xB0, 0xD7, 0x10, 0xBA, 0x05, 0x77, 0x77, 0x89,
  0x0B, 0xF7, 0x02, 0xAE, 0xFC, 0x72, 0x83, 0xBF, 0x93, 0xED, 0x89, 0x1A, 0x0B, 0xFC, 0xDE, 0x86,
  0x7E, 0xA0, 0x40, 0xBA, 0x0E, 0x02, 0x30, 0x5A, 0x0A, 0x0B, 0xA0, 0x75, 0x82, 0xEF, 0xCB, 0xA0,
  0x35, 0x82, 0xBF, 0xEB, 0xA6, 0x82, 0xBF, 0xEB, 0xA6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE,
  0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68,
  0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB,
  0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x81, 0xAF, 0xE0,
  // "ŉ" (U+0149)
  0x20, 0xDA, 0x01, 0x76, 0xA0, 0xD7, 0x60, 0x2A, 0x09, 0x76, 0x05, 0xA0, 0x47, 0x68, 0x18, 0xFE,
  0x77, 0x89, 0x4B, 0xF9, 0x0B, 0xF7, 0x02, 0xAE, 0xFC, 0x73, 0x87, 0xEF, 0x30, 0xBF, 0x93, 0xED,
  0x83, 0xA0, 0x3F, 0xD2, 0x87, 0xBF, 0xCD, 0xE8, 0x67, 0xEA, 0x04, 0x50, 0xBA, 0x0E, 0x02, 0x30,
  0x5A, 0x0A, 0x50, 0xBA, 0x07, 0x58, 0x1E, 0xFC, 0x50, 0xBA, 0x03, 0x58, 0x1B, 0xFE, 0x50, 0xBA,
  0x68, 0x1B, 0xFE, 0x50, 0xBA, 0x68, 0x1A, 0xFE, 0x58, 0x1B, 0xFE, 0x68, 0x1A, 0xFE, 0x58, 0x1B,
  0xFE, 0x68, 0x1A, 0xFE, 0x58, 0x1B, 0xFE, 0x68, 0x1A, 0xFE, 0x58, 0x1B, 0xFE, 0x68, 0x1A, 0xFE,
  0x58, 0x1B, 0xFE, 0x68, 0x1A, 0xFE, 0x58, 0x1B, 0xFE, 0x68, 0x1A, 0xFE, 0x58, 0x1B, 0xFE, 0x68,
  0x1A, 0xFE, 0x58, 0x1B, 0xFE, 0x68, 0x1A, 0xFE, 0x58, 0x1B, 0xFE, 0x68, 0x1A, 0xFE, 0x58, 0x1B,
  0xFE, 0x68, 0x1A, 0xFE,
  // "Ŋ" (U+014A)
  0x06, 0xB0, 0x27, 0x01, 0xA0, 0x70, 0x6B, 0x09, 0x70, 0x1A, 0x07, 0x06, 0xC0, 0x26, 0x01, 0xA0,
  0x70, 0x6C, 0x0A, 0x60, 0x1A, 0x83, 0x76, 0xFE, 0xCA, 0x02, 0x50, 0x1A, 0x07, 0x06, 0xA0, 0x4A,
  0x0A, 0x50, 0x1A, 0x07, 0x06, 0xA0, 0x10, 0xBA, 0x03, 0x40, 0x1A, 0x07, 0x06, 0xA0, 0x10, 0x3A,
  0x0B, 0x40, 0x1A, 0x07, 0x06, 0xA8, 0x12, 0x0A, 0xA0, 0x33, 0x01, 0xA0, 0x70, 0x6A, 0x81, 0x20,
  0x2A, 0x0B, 0x30, 0x1A, 0x07, 0x06, 0xA0, 0x22, 0x09, 0xA0, 0x32, 0x01, 0xA0, 0x70, 0x6A, 0x02,
  0x20, 0x2A, 0x0B, 0x20, 0x1A, 0x07, 0x06, 0xA0, 0x23, 0x09, 0xA8, 0x14, 0x01, 0xA0, 0x70, 0x6A,
  0x02, 0x38, 0x41, 0xEF, 0xC0, 0x1A, 0x07, 0x06, 0xA0, 0x24, 0x08, 0xA0, 0x41, 0xA0, 0x70, 0x6A,
  0x02, 0x48, 0x21, 0xEF, 0xC1, 0xA0, 0x70, 0x6A, 0x02, 0x50, 0x7A, 0x05, 0xA0, 0x70, 0x6A, 0x02,
  0x68, 0x5E, 0xFD, 0xEF, 0x76, 0xA0, 0x26, 0x06, 0xC0, 0x70, 0x6A, 0x02, 0x70, 0xDB, 0x07, 0x06,
  0xA0, 0x27, 0x06, 0xB0, 0x70, 0x6A, 0x02, 0x71, 0x0D, 0xA0, 0x70, 0x6A, 0x02, 0x71, 0x05, 0xA0,
  0x77, 0x50, 0x1A, 0x07, 0x75, 0x03, 0xA0, 0x67, 0x50, 0x7A, 0x03, 0x71, 0x85, 0x21, 0x05, 0xEF,
  0xE7, 0x20, 0x7D, 0x06, 0x72, 0x07, 0xC0, 0x77, 0x48, 0x23, 0x54, 0x13,
  // "ŋ" (U+014B)
  0x89, 0x0B, 0xF7, 0x02, 0xAE, 0xFC, 0x72, 0x83, 0xBF, 0x94, 0xED, 0x89, 0x1A, 0x0B, 0xFC, 0xDE,
  0x85, 0x8E, 0xA0, 0x30, 0xBA, 0x0E, 0x01, 0x30, 0x5A, 0x09, 0x0B, 0xA0, 0x75, 0x82, 0xEF, 0xCB,
  0xA0, 0x35, 0x82, 0xBF, 0xEB, 0xA6, 0x84, 0xBF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84,
  0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF,
  0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A,
  0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x1A, 0xFE, 0x72, 0x81, 0xAF, 0xE7, 0x28, 0x1A,
  0xFE, 0x72, 0x81, 0xAF, 0xE7, 0x28, 0x1B, 0xFD, 0x72, 0x81, 0xEF, 0xB6, 0x81, 0x56, 0xAA, 0x07,
  0x60, 0x9B, 0x0E, 0x01, 0x68, 0x37, 0xEE, 0xB3, 0x10,
  // "Ō" (U+014C)
  0x40, 0x48, 0x03, 0x50, 0x37, 0x20, 0xBF, 0x08, 0x72, 0x0B, 0xF0, 0x88, 0x0F, 0x40, 0x86, 0x4A,
  0xDE, 0xED, 0x93, 0x71, 0x01, 0x0B, 0xF9, 0x08, 0x70, 0xCA, 0x83, 0xE9, 0x66, 0x9B, 0x08, 0x50,
  0x8A, 0x0C, 0x01, 0x40, 0x20, 0xDA, 0x04, 0x30, 0x1A, 0x0E, 0x01, 0x60, 0x3A, 0x0C, 0x30, 0x6A,
  0x08, 0x71, 0x0B, 0xA0, 0x32, 0x0B, 0xA0, 0x27, 0x10, 0x5A, 0x07, 0x28, 0x1E, 0xFE, 0x72, 0x01,
  0xA8, 0x1B, 0x01, 0xA0, 0xC7, 0x38, 0x3E, 0xFE, 0x03, 0xA0, 0xA7, 0x30, 0xDA, 0x10, 0x3A, 0x09,
  0x73, 0x0C, 0xA0, 0x10, 0x4A, 0x09, 0x73, 0x0C, 0xA0, 0x10, 0x3A, 0x09, 0x73, 0x0C, 0xA0, 0x10,
  0x2A, 0x0A, 0x73, 0x0D, 0xA1, 0x01, 0xA0, 0xC7, 0x3A, 0x0E, 0x28, 0x1D, 0xFE, 0x72, 0x02, 0xA0,
  0xB2, 0x09, 0xA0, 0x37, 0x10, 0x5A, 0x07, 0x20, 0x5A, 0x08, 0x71, 0x0B, 0xA0, 0x33, 0x82, 0xEF,
  0xE1, 0x60, 0x3A, 0x0C, 0x40, 0x6A, 0x0C, 0x01, 0x40, 0x20, 0xDA, 0x04, 0x50, 0xBA, 0x83, 0xE9,
  0x66, 0x9B, 0x08, 0x70, 0xAF, 0x90, 0x87, 0x28, 0x64, 0xAD, 0xFE, 0xD9, 0x35,
  // "ō" (U+014D)
  0x20, 0x48, 0x03, 0x50, 0x35, 0x0B, 0xF0, 0x85, 0x0B, 0xF0, 0x87, 0x77, 0x76, 0x85, 0x18, 0xDE,
  0xEC, 0x66, 0x03, 0x0E, 0xE0, 0xB4, 0x01, 0x0E, 0xA8, 0x2A, 0x66, 0xCA, 0x0A, 0x30, 0x8A, 0x07,
  0x40, 0xAA, 0x04, 0x28, 0x1D, 0xFD, 0x50, 0x1A, 0x81, 0xA0, 0x2A, 0x08, 0x68, 0x3C, 0xFE, 0x05,
  0xA0, 0x56, 0x08, 0xA0, 0x10, 0x7A, 0x03, 0x60, 0x7A, 0x03, 0x07, 0xA0, 0x36, 0x06, 0xA0, 0x40,
  0x7A, 0x03, 0x60, 0x6A, 0x04, 0x07, 0xA0, 0x36, 0x07, 0xA0, 0x30, 0x5A, 0x05, 0x60, 0x8A, 0x01,
  0x02, 0xA0, 0x86, 0x81, 0xCF, 0xE2, 0x81, 0xDF, 0xD5, 0x01, 0xA0, 0x92, 0x07, 0xA0, 0x74, 0x0A,
  0xA0, 0x33, 0x0D, 0xA8, 0x2A, 0x66, 0xCA, 0x0A, 0x40, 0x20, 0xDE, 0x0B, 0x78, 0x48, 0xDE, 0xEC,
  0x64,
  // "Ŏ" (U+014E)
  0x40, 0x50, 0x75, 0x07, 0x05, 0x72, 0x81, 0x9F, 0x43, 0x81, 0x4F, 0x97, 0x28, 0x75, 0xFE, 0x86,
  0x8E, 0xF4, 0x73, 0x0C, 0xD0, 0xA7, 0x48, 0x41, 0x9E, 0xFD, 0x78, 0x0F, 0x60, 0x86, 0x4A, 0xDE,
  0xED, 0x93, 0x71, 0x01, 0x0B, 0xF9, 0x08, 0x70, 0xCA, 0x83, 0xE9, 0x66, 0x9B, 0x08, 0x50, 0x8A,
  0x0C, 0x01, 0x40, 0x20, 0xDA, 0x04, 0x30, 0x1A, 0x0E, 0x01, 0x60, 0x3A, 0x0C, 0x30, 0x6A, 0x08,
  0x71, 0x0B, 0xA0, 0x32, 0x0B, 0xA0, 0x27, 0x10, 0x5A, 0x07, 0x28, 0x1E, 0xFE, 0x72, 0x01, 0xA8,
  0x1B, 0x01, 0xA0, 0xC7, 0x38, 0x3E, 0xFE, 0x03, 0xA0, 0xA7, 0x30, 0xDA, 0x10, 0x3A, 0x09, 0x73,
  0x0C, 0xA0, 0x10, 0x4A, 0x09, 0x73, 0x0C, 0xA0, 0x10, 0x3A, 0x09, 0x73, 0x0C, 0xA0, 0x10, 0x2A,
  0x0A, 0x73, 0x0D, 0xA1, 0x01, 0xA0, 0xC7, 0x3A, 0x0E, 0x28, 0x1D, 0xFE, 0x72, 0x02, 0xA0, 0xB2,
  0x09, 0xA0, 0x37, 0x10, 0x5A, 0x07, 0x20, 0x5A, 0x08, 0x71, 0x0B, 0xA0, 0x33, 0x82, 0xEF, 0xE1,
  0x60, 0x3A, 0x0C, 0x40, 0x6A, 0x0C, 0x01, 0x40, 0x20, 0xDA, 0x04, 0x50, 0xBA, 0x83, 0xE9, 0x66,
  0x9B, 0x08, 0x70, 0xAF, 0x90, 0x87, 0x28, 0x64, 0xAD, 0xFE, 0xD9, 0x35,
  // "ŏ" (U+014F)
  0x20, 0x50, 0x75, 0x07, 0x05, 0x58, 0x19, 0xF4, 0x38, 0x14, 0xF9, 0x58, 0x75, 0xFE, 0x86, 0x8E,
  0xF4, 0x60, 0xCD, 0x0A, 0x78, 0x41, 0x9E, 0xFD, 0x78, 0x0C, 0x00, 0x85, 0x18, 0xDE, 0xEC, 0x66,
  0x03, 0x0E, 0xE0, 0xB4, 0x01, 0x0E, 0xA8, 0x2A, 0x66, 0xCA, 0x0A, 0x30, 0x8A, 0x07, 0x40, 0xAA,
  0x04, 0x28, 0x1D, 0xFD, 0x50, 0x1A, 0x81, 0xA0, 0x2A, 0x08, 0x68, 0x3C, 0xFE, 0x05, 0xA0, 0x56,
  0x08, 0xA0, 0x10, 0x7A, 0x03, 0x60, 0x7A, 0x03, 0x07, 0xA0, 0x36, 0x06, 0xA0, 0x40, 0x7A, 0x03,
  0x60, 0x6A, 0x04, 0x07, 0xA0, 0x36, 0x07, 0xA0, 0x30, 0x5A, 0x05, 0x60, 0x8A, 0x01, 0x02, 0xA0,
  0x86, 0x81, 0xCF, 0xE2, 0x81, 0xDF, 0xD5, 0x01, 0xA0, 0x92, 0x07, 0xA0, 0x74, 0x0A, 0xA0, 0x33,
  0x0D, 0xA8, 0x2A, 0x66, 0xCA, 0x0A, 0x40, 0x20, 0xDE, 0x0B, 0x78, 0x48, 0xDE, 0xEC, 0x64,
  // "Ő" (U+0150)
  0x70, 0x5A, 0x81, 0x80, 0x6A, 0x07, 0x72, 0x81, 0xDF, 0xD2, 0x81, 0xEF, 0xC7, 0x28, 0x76, 0xFE,
  0x20, 0x7F, 0xD1, 0x71, 0x87, 0x1E, 0xE4, 0x01, 0xEE, 0x27, 0x28, 0x19, 0xE3, 0x28, 0x1A, 0xE3,
  0x80, 0xF4, 0x08, 0x64, 0xAD, 0xEE, 0xD9, 0x37, 0x10, 0x10, 0xBF, 0x90, 0x87, 0x0C, 0xA8, 0x3E,
  0x96, 0x69, 0xB0, 0x85, 0x08, 0xA0, 0xC0, 0x14, 0x02, 0x0D, 0xA0, 0x43, 0x01, 0xA0, 0xE0, 0x16,
  0x03, 0xA0, 0xC3, 0x06, 0xA0, 0x87, 0x10, 0xBA, 0x03, 0x20, 0xBA, 0x02, 0x71, 0x05, 0xA0, 0x72,
  0x81, 0xEF, 0xE7, 0x20, 0x1A, 0x81, 0xB0, 0x1A, 0x0C, 0x73, 0x83, 0xEF, 0xE0, 0x3A, 0x0A, 0x73,
  0x0D, 0xA1, 0x03, 0xA0, 0x97, 0x30, 0xCA, 0x01, 0x04, 0xA0, 0x97, 0x30, 0xCA, 0x01, 0x03, 0xA0,
  0x97, 0x30, 0xCA, 0x01, 0x02, 0xA0, 0xA7, 0x30, 0xDA, 0x10, 0x1A, 0x0C, 0x73, 0xA0, 0xE2, 0x81,
  0xDF, 0xE7, 0x20, 0x2A, 0x0B, 0x20, 0x9A, 0x03, 0x71, 0x05, 0xA0, 0x72, 0x05, 0xA0, 0x87, 0x10,
  0xBA, 0x03, 0x38, 0x2E, 0xFE, 0x16, 0x03, 0xA0, 0xC4, 0x06, 0xA0, 0xC0, 0x14, 0x02, 0x0D, 0xA0,
  0x45, 0x0B, 0xA8, 0x3E, 0x96, 0x69, 0xB0, 0x87, 0x0A, 0xF9, 0x08, 0x72, 0x86, 0x4A, 0xDF, 0xED,
  0x93, 0x50,
  // "ő" (U+0151)
  0x50, 0x5A, 0x81, 0x80, 0x6A, 0x07, 0x58, 0x1D, 0xFD, 0x28, 0x1E, 0xFC, 0x58, 0x76, 0xFE, 0x20,
  0x7F, 0xD1, 0x48, 0x71, 0xEE, 0x40, 0x1E, 0xE2, 0x58, 0x19, 0xE3, 0x28, 0x1A, 0xE3, 0x77, 0x77,
  0x68, 0x51, 0x8D, 0xEE, 0xC6, 0x60, 0x30, 0xEE, 0x0B, 0x40, 0x10, 0xEA, 0x82, 0xA6, 0x6C, 0xA0,
  0xA3, 0x08, 0xA0, 0x74, 0x0A, 0xA0, 0x42, 0x81, 0xDF, 0xD5, 0x01, 0xA8, 0x1A, 0x02, 0xA0, 0x86,
  0x83, 0xCF, 0xE0, 0x5A, 0x05, 0x60, 0x8A, 0x01, 0x07, 0xA0, 0x36, 0x07, 0xA0, 0x30, 0x7A, 0x03,
  0x60, 0x6A, 0x04, 0x07, 0xA0, 0x36, 0x06, 0xA0, 0x40, 0x7A, 0x03, 0x60, 0x7A, 0x03, 0x05, 0xA0,
  0x56, 0x08, 0xA0, 0x10, 0x2A, 0x08, 0x68, 0x1C, 0xFE, 0x28, 0x1D, 0xFD, 0x50, 0x1A, 0x09, 0x20,
  0x7A, 0x07, 0x40, 0xAA, 0x03, 0x30, 0xDA, 0x82, 0xA6, 0x6C, 0xA0, 0xA4, 0x02, 0x0D, 0xE0, 0xB7,
  0x84, 0x8D, 0xEE, 0xC6, 0x40,
  // "Œ" (U+0152)
  0x58, 0x23, 0x8C, 0xEF, 0xC0, 0xC4, 0x08, 0xFF, 0x90, 0xC3, 0x0A, 0xA8, 0x3E, 0x96, 0x57, 0xA0,
  0xB8, 0x02, 0x50, 0x42, 0x06, 0xA0, 0xD0, 0x13, 0x02, 0xA0, 0x87, 0x28, 0x2E, 0xFE, 0x24, 0x02,
  0xA0, 0x87, 0x10, 0x5A, 0x08, 0x50, 0x2A, 0x08, 0x71, 0x0A, 0xA0, 0x25, 0x02, 0xA0, 0x87, 0x18,
  0x1E, 0xFE, 0x60, 0x2A, 0x08, 0x70, 0x1A, 0x0C, 0x60, 0x2A, 0x08, 0x70, 0x3A, 0x0A, 0x60, 0x2A,
  0x0B, 0x80, 0x25, 0x01, 0x03, 0xA0, 0x96, 0x02, 0xFA, 0x05, 0x04, 0xA0, 0x96, 0x02, 0xFA, 0x05,
  0x03, 0xA0, 0x96, 0x02, 0xA0, 0x87, 0x03, 0xA0, 0xA6, 0x02, 0xA0, 0x87, 0x01, 0xA0, 0xC6, 0x02,
  0xA0, 0x87, 0x18, 0x1E, 0xFE, 0x60, 0x2A, 0x08, 0x71, 0x0A, 0xA0, 0x35, 0x02, 0xA0, 0x87, 0x10,
  0x5A, 0x09, 0x50, 0x2A, 0x08, 0x72, 0x82, 0xEF, 0xE2, 0x40, 0x2A, 0x08, 0x72, 0x06, 0xA0, 0xD0,
  0x23, 0x02, 0xA0, 0x87, 0x30, 0xAB, 0x82, 0xA6, 0x57, 0xA0, 0xB8, 0x02, 0x50, 0x44, 0x09, 0xFF,
  0x90, 0xC5, 0x82, 0x38, 0xCE, 0xFC, 0x0C,
  // "œ" (U+0153)
  0x38, 0x51, 0x8D, 0xEE, 0xB4, 0x38, 0x51, 0x8D, 0xED, 0x92, 0x50, 0x30, 0xEE, 0x82, 0x70, 0x1D,
  0xD0, 0xE0, 0x33, 0x01, 0x0E, 0xA8, 0x2A, 0x67, 0xDA, 0x89, 0x04, 0xBF, 0xE8, 0x68, 0xEF, 0xE3,
  0x08, 0xA0, 0x64, 0x81, 0xCF, 0xEA, 0x03, 0x30, 0x4A, 0x07, 0x28, 0x1D, 0xFD, 0x50, 0x3B, 0x09,
  0x58, 0x3C, 0xFC, 0x02, 0xA0, 0x86, 0x0E, 0xA0, 0x55, 0x08, 0xA1, 0x05, 0xA0, 0x56, 0x0B, 0xA0,
  0x35, 0x06, 0xA0, 0x10, 0x7A, 0x03, 0x60, 0x9F, 0xC0, 0x20, 0x7A, 0x03, 0x60, 0x8F, 0xC0, 0x30,
  0x7A, 0x03, 0x60, 0x8A, 0x06, 0x80, 0x45, 0x01, 0x07, 0xA0, 0x36, 0x09, 0xA0, 0x27, 0x20, 0x5A,
  0x05, 0x60, 0xBA, 0x04, 0x72, 0x02, 0xA0, 0x86, 0x0D, 0xA0, 0x77, 0x38, 0x1D, 0xFD, 0x50, 0x3B,
  0x0D, 0x73, 0x07, 0xA0, 0x74, 0x81, 0xBF, 0xEA, 0x08, 0x50, 0x10, 0x33, 0x0D, 0xA8, 0x2A, 0x66,
  0xCA, 0x04, 0x09, 0xA8, 0x5C, 0x75, 0x7A, 0xE8, 0x30, 0x20, 0xDE, 0x07, 0x20, 0xBF, 0x08, 0x48,
  0x51, 0x8D, 0xEE, 0xB4, 0x48, 0x55, 0xBE, 0xFD, 0xA5, 0x20,
  // "Ŕ" (U+0154)
  0x70, 0xF7, 0x02, 0x72, 0x05, 0xA0, 0xD0, 0x17, 0x20, 0xDA, 0x03, 0x72, 0x06, 0xA0, 0x67, 0x28,
  0x21, 0xEF, 0x87, 0x38, 0x19, 0xF8, 0x80, 0xD5, 0x00, 0x6D, 0x82, 0xEC, 0x93, 0x40, 0x6F, 0xA0,
  0x83, 0x06, 0xA8, 0x38, 0x55, 0x7A, 0xB0, 0x72, 0x06, 0xA0, 0x44, 0x04, 0xA8, 0x2E, 0x10, 0x6A,
  0x04, 0x50, 0x9A, 0x81, 0x50, 0x6A, 0x04, 0x50, 0x5A, 0x81, 0x70, 0x6A, 0x04, 0x50, 0x4A, 0x81,
  0x80, 0x6A, 0x04, 0x50, 0x5A, 0x81, 0x60, 0x6A, 0x04, 0x50, 0x8A, 0x81, 0x40, 0x6A, 0x04, 0x48,
  0x21, 0xEF, 0xE2, 0x06, 0xA0, 0x42, 0x81, 0x15, 0xDA, 0x06, 0x20, 0x6F, 0xA0, 0x83, 0x06, 0xF0,
  0xE0, 0x34, 0x06, 0xA8, 0x28, 0x55, 0xBA, 0x02, 0x40, 0x6A, 0x04, 0x20, 0x3A, 0x0A, 0x40, 0x6A,
  0x04, 0x30, 0xBA, 0x02, 0x30, 0x6A, 0x04, 0x30, 0x4A, 0x0A, 0x30, 0x6A, 0x04, 0x40, 0xCA, 0x02,
  0x20, 0x6A, 0x04, 0x40, 0x5A, 0x09, 0x20, 0x6A, 0x04, 0x50, 0xDA, 0x81, 0x20, 0x6A, 0x04, 0x50,
  0x6A, 0x81, 0x90, 0x6A, 0x04, 0x60, 0xEA, 0x02, 0x06, 0xA0, 0x46, 0x07, 0xA0, 0x90,
  // "ŕ" (U+0155)
  0x50, 0xF7, 0x02, 0x40, 0x5A, 0x0D, 0x01, 0x40, 0xDA, 0x03, 0x40, 0x6A, 0x06, 0x48, 0x21, 0xEF,
  0x85, 0x81, 0x9F, 0x87, 0x77, 0x18, 0x94, 0xBF, 0x60, 0x2A, 0xEF, 0x5B, 0xF8, 0x2E, 0xB8, 0x95,
  0x3B, 0xF9, 0xBF, 0xA6, 0x81, 0xBF, 0xEF, 0x74, 0x0B, 0xA0, 0xC5, 0x0B, 0xA0, 0x55, 0x0B, 0xA0,
  0x15, 0x0B, 0xA6, 0x81, 0xBF, 0xE6, 0x81, 0xBF, 0xE6, 0x81, 0xBF, 0xE6, 0x81, 0xBF, 0xE6, 0x81,
  0xBF, 0xE6, 0x81, 0xBF, 0xE6, 0x81, 0xBF, 0xE6, 0x81, 0xBF, 0xE6, 0x81, 0xBF, 0xE6, 0x81, 0xBF,
  0xE6,
  // "Ŗ" (U+0156)
  0x06, 0xD8, 0x2E, 0xC9, 0x34, 0x06, 0xFA, 0x08, 0x30, 0x6A, 0x83, 0x85, 0x57, 0xAB, 0x07, 0x20,
  0x6A, 0x04, 0x40, 0x4A, 0x82, 0xE1, 0x06, 0xA0, 0x45, 0x09, 0xA8, 0x15, 0x06, 0xA0, 0x45, 0x05,
  0xA8, 0x17, 0x06, 0xA0, 0x45, 0x04, 0xA8, 0x18, 0x06, 0xA0, 0x45, 0x05, 0xA8, 0x16, 0x06, 0xA0,
  0x45, 0x08, 0xA8, 0x14, 0x06, 0xA0, 0x44, 0x82, 0x1E, 0xFE, 0x20, 0x6A, 0x04, 0x28, 0x11, 0x5D,
  0xA0, 0x62, 0x06, 0xFA, 0x08, 0x30, 0x6F, 0x0E, 0x03, 0x40, 0x6A, 0x82, 0x85, 0x5B, 0xA0, 0x24,
  0x06, 0xA0, 0x42, 0x03, 0xA0, 0xA4, 0x06, 0xA0, 0x43, 0x0B, 0xA0, 0x23, 0x06, 0xA0, 0x43, 0x04,
  0xA0, 0xA3, 0x06, 0xA0, 0x44, 0x0C, 0xA0, 0x22, 0x06, 0xA0, 0x44, 0x05, 0xA0, 0x92, 0x06, 0xA0,
  0x45, 0x0D, 0xA8, 0x12, 0x06, 0xA0, 0x45, 0x06, 0xA8, 0x19, 0x06, 0xA0, 0x46, 0x0E, 0xA0, 0x20,
  0x6A, 0x04, 0x60, 0x7A, 0x09, 0x77, 0x77, 0x50, 0x8A, 0x03, 0x73, 0x81, 0xAF, 0xD7, 0x48, 0x1E,
  0xF6, 0x73, 0x81, 0x2F, 0xD7, 0x48, 0x17, 0xF4, 0x70,
  // "ŗ" (U+0157)
  0x18, 0x95, 0xBF, 0x60, 0x2A, 0xEF, 0x50, 0xBF, 0x82, 0xEB, 0x89, 0x73, 0x0B, 0xF9, 0xBF, 0xA6,
  0x81, 0x0B, 0xFE, 0xF7, 0x50, 0xBA, 0x0C, 0x60, 0xBA, 0x05, 0x60, 0xBA, 0x01, 0x60, 0xBA, 0x78,
  0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B,
  0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x78, 0x1B, 0xFE, 0x77, 0x76, 0x08,
  0xA0, 0x36, 0x81, 0xAF, 0xD7, 0x81, 0xEF, 0x66, 0x81, 0x2F, 0xD7, 0x81, 0x7F, 0x47,
  // "Ř" (U+0158)
  0x18, 0x15, 0x71, 0x48, 0x13, 0x73, 0x48, 0x15, 0xFC, 0x38, 0x23, 0xED, 0x15, 0x86, 0x9F, 0xB0,
  0x2E, 0xF3, 0x78, 0x4D, 0xFA, 0xDF, 0x87, 0x10, 0x5B, 0x0D, 0x73, 0x0B, 0xA0, 0x58, 0x0D, 0x40,
  0x06, 0xD8, 0x2E, 0xC9, 0x34, 0x06, 0xFA, 0x08, 0x30, 0x6A, 0x83, 0x85, 0x57, 0xAB, 0x07, 0x20,
  0x6A, 0x04, 0x40, 0x4A, 0x82, 0xE1, 0x06, 0xA0, 0x45, 0x09, 0xA8, 0x15, 0x06, 0xA0, 0x45, 0x05,
  0xA8, 0x17, 0x06, 0xA0, 0x45, 0x04, 0xA8, 0x18, 0x06, 0xA0, 0x45, 0x05, 0xA8, 0x16, 0x06, 0xA0,
  0x45, 0x08, 0xA8, 0x14, 0x06, 0xA0, 0x44, 0x82, 0x1E, 0xFE, 0x20, 0x6A, 0x04, 0x28, 0x11, 0x5D,
  0xA0, 0x62, 0x06, 0xFA, 0x08, 0x30, 0x6F, 0x0E, 0x03, 0x40, 0x6A, 0x82, 0x85, 0x5B, 0xA0, 0x24,
  0x06, 0xA0, 0x42, 0x03, 0xA0, 0xA4, 0x06, 0xA0, 0x43, 0x0B, 0xA0, 0x23, 0x06, 0xA0, 0x43, 0x04,
  0xA0, 0xA3, 0x06, 0xA0, 0x44, 0x0C, 0xA0, 0x22, 0x06, 0xA0, 0x44, 0x05, 0xA0, 0x92, 0x06, 0xA0,
  0x45, 0x0D, 0xA8, 0x12, 0x06, 0xA0, 0x45, 0x06, 0xA8, 0x19, 0x06, 0xA0, 0x46, 0x0E, 0xA0, 0x20,
  0x6A, 0x04, 0x60, 0x7A, 0x09,
  // "ř" (U+0159)
  0x81, 0x57, 0x14, 0x84, 0x37, 0x35, 0xFC, 0x38, 0x93, 0x3E, 0xD1, 0x09, 0xFB, 0x02, 0xEF, 0x33,
  0x84, 0xDF, 0xAD, 0xF8, 0x40, 0x5B, 0x0D, 0x60, 0xBA, 0x05, 0x77, 0x73, 0x89, 0x5B, 0xF6, 0x02,
  0xAE, 0xF5, 0x0B, 0xF8, 0x2E, 0xB8, 0x97, 0x30, 0xBF, 0x9B, 0xFA, 0x68, 0x10, 0xBF, 0xEF, 0x75,
  0x0B, 0xA0, 0xC6, 0x0B, 0xA0, 0x56, 0x0B, 0xA0, 0x16, 0x0B, 0xA7, 0x81, 0xBF, 0xE7, 0x81, 0xBF,
  0xE7, 0x81, 0xBF, 0xE7, 0x81, 0xBF, 0xE7, 0x81, 0xBF, 0xE7, 0x81, 0xBF, 0xE7, 0x81, 0xBF, 0xE7,
  0x81, 0xBF, 0xE7, 0x81, 0xBF, 0xE7, 0x81, 0xBF, 0xE6,
  // "Ś" (U+015A)
  0x71, 0x0F, 0x70, 0x27, 0x10, 0x5A, 0x0D, 0x01, 0x71, 0x0D, 0xA0, 0x37, 0x10, 0x6A, 0x06, 0x71,
  0x82, 0x1E, 0xF8, 0x72, 0x81, 0x9F, 0x88, 0x0D, 0x30, 0x87, 0x39, 0xDE, 0xED, 0xA6, 0x13, 0x08,
  0xF9, 0x0B, 0x20, 0x7B, 0x85, 0x96, 0x69, 0xEF, 0x62, 0x82, 0xEF, 0xE2, 0x58, 0x26, 0x10, 0x4A,
  0x08, 0x72, 0x06, 0xA0, 0x57, 0x20, 0x6A, 0x06, 0x72, 0x04, 0xA0, 0xB7, 0x30, 0xEA, 0x07, 0x72,
  0x07, 0xB0, 0xB0, 0x27, 0x10, 0x9C, 0x0A, 0x02, 0x70, 0x50, 0xDC, 0x07, 0x71, 0x07, 0x0E, 0xB0,
  0xA7, 0x20, 0x8B, 0x06, 0x72, 0x05, 0xA0, 0xD7, 0x30, 0xCA, 0x01, 0x72, 0x08, 0xA0, 0x37, 0x20,
  0x9A, 0x01, 0x72, 0x84, 0xDF, 0xE0, 0x41, 0x60, 0x8A, 0x89, 0x08, 0x0A, 0xFC, 0x86, 0x57, 0xBA,
  0x82, 0xD1, 0x0A, 0xF9, 0x0D, 0x02, 0x28, 0x71, 0x6A, 0xDE, 0xFE, 0xB6, 0x40,
  // "ś" (U+015B)
  0x60, 0xF7, 0x02, 0x50, 0x5A, 0x0D, 0x01, 0x50, 0xDA, 0x03, 0x50, 0x6A, 0x06, 0x58, 0x21, 0xEF,
  0x86, 0x81, 0x9F, 0x87, 0x77, 0x58, 0x54, 0xAE, 0xFE, 0xB6, 0x20, 0x8F, 0x0B, 0x04, 0xA8, 0x6E,
  0x76, 0x7B, 0xF5, 0xAA, 0x02, 0x48, 0x33, 0x0B, 0xFC, 0x78, 0x2A, 0xFE, 0x16, 0x06, 0xA0, 0xB0,
  0x16, 0x0C, 0xA0, 0xE0, 0x76, 0x0A, 0xB0, 0xD0, 0x45, 0x04, 0x0D, 0xB0, 0x76, 0x06, 0x0E, 0xA0,
  0x56, 0x03, 0xA0, 0xC7, 0x0A, 0xA7, 0x09, 0xA0, 0x50, 0x14, 0x89, 0x11, 0xEF, 0xDB, 0xFA, 0x75,
  0x7D, 0xA0, 0x70, 0xBF, 0x89, 0x0B, 0x02, 0x8C, 0xEF, 0xEB, 0x62,
  // "Ŝ" (U+015C)
  0x58, 0x24, 0x77, 0x17, 0x10, 0x10, 0xEA, 0x09, 0x71, 0x09, 0xC0, 0x36, 0x03, 0xA8, 0x24, 0x9F,
  0xC6, 0x81, 0xDF, 0x52, 0x81, 0xAF, 0x84, 0x81, 0x9F, 0x64, 0x81, 0xAF, 0x38, 0x0C, 0x70, 0x87,
  0x39, 0xDE, 0xED, 0xA6, 0x13, 0x08, 0xF9, 0x0B, 0x20, 0x7B, 0x85, 0x96, 0x69, 0xEF, 0x62, 0x82,
  0xEF, 0xE2, 0x58, 0x26, 0x10, 0x4A, 0x08, 0x72, 0x06, 0xA0, 0x57, 0x20, 0x6A, 0x06, 0x72, 0x04,
  0xA0, 0xB7, 0x30, 0xEA, 0x07, 0x72, 0x07, 0xB0, 0xB0, 0x27, 0x10, 0x9C, 0x0A, 0x02, 0x70, 0x50,
  0xDC, 0x07, 0x71, 0x07, 0x0E, 0xB0, 0xA7, 0x20, 0x8B, 0x06, 0x72, 0x05, 0xA0, 0xD7, 0x30, 0xCA,
  0x01, 0x72, 0x08, 0xA0, 0x37, 0x20, 0x9A, 0x01, 0x72, 0x84, 0xDF, 0xE0, 0x41, 0x60, 0x8A, 0x89,
  0x08, 0x0A, 0xFC, 0x86, 0x57, 0xBA, 0x82, 0xD1, 0x0A, 0xF9, 0x0D, 0x02, 0x28, 0x71, 0x6A, 0xDE,
  0xFE, 0xB6, 0x40,
  // "ŝ" (U+015D)
  0x48, 0x24, 0x77, 0x16, 0x01, 0x0E, 0xA0, 0x96, 0x09, 0xC0, 0x34, 0x03, 0xA8, 0x24, 0x9F, 0xC4,
  0x81, 0xDF, 0x52, 0x81, 0xAF, 0x82, 0x81, 0x9F, 0x64, 0x81, 0xAF, 0x37, 0x77, 0x38, 0x54, 0xAE,
  0xFE, 0xB6, 0x30, 0x8F, 0x81, 0xB0, 0x4A, 0x87, 0xE7, 0x67, 0xBF, 0x50, 0xAA, 0x02, 0x40, 0x32,
  0x81, 0xBF, 0xC7, 0x18, 0x2A, 0xFE, 0x17, 0x06, 0xA0, 0xB0, 0x17, 0x0C, 0xA0, 0xE0, 0x77, 0x0A,
  0xB0, 0xD0, 0x46, 0x04, 0x0D, 0xB0, 0x77, 0x06, 0x0E, 0xA0, 0x57, 0x03, 0xA0, 0xC7, 0x10, 0xAA,
  0x71, 0x09, 0xA1, 0x05, 0x01, 0x48, 0x92, 0x1E, 0xFD, 0x0B, 0xFA, 0x75, 0x7D, 0xA8, 0x17, 0x0B,
  0xF0, 0xB2, 0x86, 0x28, 0xCE, 0xFE, 0xB6, 0x30,
  // "Ş" (U+015E)
  0x38, 0x73, 0x9D, 0xEE, 0xDA, 0x61, 0x30, 0x8F, 0x90, 0xB2, 0x07, 0xB8, 0x59, 0x66, 0x9E, 0xF6,
  0x28, 0x2E, 0xFE, 0x25, 0x82, 0x61, 0x04, 0xA0, 0x87, 0x20, 0x6A, 0x05, 0x72, 0x06, 0xA0, 0x67,
  0x20, 0x4A, 0x0B, 0x73, 0x0E, 0xA0, 0x77, 0x20, 0x7B, 0x0B, 0x02, 0x71, 0x09, 0xC0, 0xA0, 0x27,
  0x05, 0x0D, 0xC0, 0x77, 0x10, 0x70, 0xEB, 0x0A, 0x72, 0x08, 0xB0, 0x67, 0x20, 0x5A, 0x0D, 0x73,
  0x0C, 0xA0, 0x17, 0x20, 0x8A, 0x03, 0x72, 0x09, 0xA0, 0x17, 0x28, 0x4D, 0xFE, 0x04, 0x16, 0x08,
  0xA8, 0x90, 0x80, 0xAF, 0xC8, 0x65, 0x7B, 0xA8, 0x2D, 0x10, 0xAF, 0x90, 0xD0, 0x22, 0x87, 0x16,
  0xAD, 0xEF, 0xEB, 0x67, 0x20, 0xA0, 0xE7, 0x38, 0x22, 0xFB, 0x17, 0x28, 0x34, 0xBF, 0xE4, 0x73,
  0x81, 0x4F, 0xE7, 0x30, 0x1A, 0x01, 0x68, 0x24, 0x56, 0xCA, 0x70, 0x9C, 0x08, 0x78, 0x38, 0xEE,
  0xC6, 0x50,
  // "ş" (U+015F)
  0x28, 0x54, 0xAE, 0xFE, 0xB6, 0x20, 0x8F, 0x0B, 0x04, 0xA8, 0x6E, 0x76, 0x7B, 0xF5, 0xAA, 0x02,
  0x48, 0x33, 0x0B, 0xFC, 0x78, 0x2A, 0xFE, 0x16, 0x06, 0xA0, 0xB0, 0x16, 0x0C, 0xA0, 0xE0, 0x76,
  0x0A, 0xB0, 0xD0, 0x45, 0x04, 0x0D, 0xB0, 0x76, 0x06, 0x0E, 0xA0, 0x56, 0x03, 0xA0, 0xC7, 0x0A,
  0xA7, 0x09, 0xA0, 0x50, 0x14, 0x89, 0x11, 0xEF, 0xDB, 0xFA, 0x75, 0x7D, 0xA0, 0x70, 0xBF, 0x89,
  0x0B, 0x02, 0x8C, 0xEF, 0xEB, 0x66, 0x0A, 0x0E, 0x78, 0x22, 0xFB, 0x16, 0x83, 0x4B, 0xFE, 0x47,
  0x81, 0x4F, 0xE7, 0x01, 0xA0, 0x13, 0x82, 0x45, 0x6C, 0xA4, 0x09, 0xC0, 0x84, 0x83, 0x8E, 0xEC,
  0x63,
  // "Š" (U+0160)
  0x28, 0x15, 0x71, 0x48, 0x13, 0x73, 0x38, 0x15, 0xFC, 0x38, 0x23, 0xED, 0x14, 0x86, 0x9F, 0xB0,
  0x2E, 0xF3, 0x68, 0x4D, 0xFA, 0xDF, 0x87, 0x05, 0xB0, 0xD7, 0x20, 0xBA, 0x05, 0x80, 0xD2, 0x08,
  0x73, 0x9D, 0xEE, 0xDA, 0x61, 0x30, 0x8F, 0x90, 0xB2, 0x07, 0xB8, 0x59, 0x66, 0x9E, 0xF6, 0x28,
  0x2E, 0xFE, 0x25, 0x82, 0x61, 0x04, 0xA0, 0x87, 0x20, 0x6A, 0x05, 0x72, 0x06, 0xA0, 0x67, 0x20,
  0x4A, 0x0B, 0x73, 0x0E, 0xA0, 0x77, 0x20, 0x7B, 0x0B, 0x02, 0x71, 0x09, 0xC0, 0xA0, 0x27, 0x05,
  0x0D, 0xC0, 0x77, 0x10, 0x70, 0xEB, 0x0A, 0x72, 0x08, 0xB0, 0x67, 0x20, 0x5A, 0x0D, 0x73, 0x0C,
  0xA0, 0x17, 0x20, 0x8A, 0x03, 0x72, 0x09, 0xA0, 0x17, 0x28, 0x4D, 0xFE, 0x04, 0x16, 0x08, 0xA8,
  0x90, 0x80, 0xAF, 0xC8, 0x65, 0x7B, 0xA8, 0x2D, 0x10, 0xAF, 0x90, 0xD0, 0x22, 0x87, 0x16, 0xAD,
  0xEF, 0xEB, 0x64,
  // "š" (U+0161)
  0x81, 0x57, 0x14, 0x84, 0x37, 0x35, 0xFC, 0x38, 0x93, 0x3E, 0xD1, 0x09, 0xFB, 0x02, 0xEF, 0x33,
  0x84, 0xDF, 0xAD, 0xF8, 0x40, 0x5B, 0x0D, 0x60, 0xBA, 0x05, 0x77, 0x74, 0x85, 0x4A, 0xEF, 0xEB,
  0x62, 0x08, 0xF0, 0xB0, 0x4A, 0x86, 0xE7, 0x67, 0xBF, 0x5A, 0xA0, 0x24, 0x83, 0x30, 0xBF, 0xC7,
  0x82, 0xAF, 0xE1, 0x60, 0x6A, 0x0B, 0x01, 0x60, 0xCA, 0x0E, 0x07, 0x60, 0xAB, 0x0D, 0x04, 0x50,
  0x40, 0xDB, 0x07, 0x60, 0x60, 0xEA, 0x05, 0x60, 0x3A, 0x0C, 0x70, 0xAA, 0x70, 0x9A, 0x05, 0x01,
  0x48, 0x91, 0x1E, 0xFD, 0xBF, 0xA7, 0x57, 0xDA, 0x07, 0x0B, 0xF8, 0x90, 0xB0, 0x28, 0xCE, 0xFE,
  0xB6, 0x20,
  // "Ţ" (U+0162)
  0x0A, 0xFD, 0x07, 0x0A, 0xFD, 0x85, 0x73, 0x55, 0x55, 0x9A, 0x84, 0x85, 0x55, 0x52, 0x50, 0x6A,
  0x04, 0x73, 0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04, 0x73, 0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04, 0x73,
  0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04, 0x73, 0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04, 0x73, 0x06, 0xA0,
  0x47, 0x30, 0x6A, 0x04, 0x73, 0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04, 0x73, 0x06, 0xA0, 0x47, 0x30,
  0x6A, 0x04, 0x73, 0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04, 0x73, 0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04,
  0x73, 0x06, 0xA0, 0x47, 0x40, 0xA0, 0xE7, 0x48, 0x22, 0xFB, 0x17, 0x38, 0x34, 0xBF, 0xE4, 0x74,
  0x81, 0x4F, 0xE7, 0x40, 0x1A, 0x01, 0x78, 0x24, 0x56, 0xCA, 0x71, 0x09, 0xC0, 0x87, 0x18, 0x38,
  0xEE, 0xC6, 0x50,
  // "ţ" (U+0163)
  0x38, 0x1C, 0xF1, 0x68, 0x1E, 0xF1, 0x50, 0x2A, 0x01, 0x50, 0x6A, 0x01, 0x38, 0x11, 0x8E, 0xD0,
  0x80, 0x7F, 0x82, 0x82, 0x5B, 0xA8, 0x26, 0x55, 0x32, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09,
  0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0,
  0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x08, 0xA0, 0x45, 0x04, 0xA8, 0x2D,
  0x65, 0x63, 0x0C, 0xC0, 0xB3, 0x84, 0x19, 0xEF, 0xD7, 0x40, 0xA0, 0xE6, 0x82, 0x2F, 0xB1, 0x58,
  0x34, 0xBF, 0xE4, 0x68, 0x14, 0xFE, 0x60, 0x1A, 0x01, 0x28, 0x24, 0x56, 0xCA, 0x30, 0x9C, 0x08,
  0x38, 0x38, 0xEE, 0xC6, 0x20,
  // "Ť" (U+0164)
  0x28, 0x15, 0x71, 0x48, 0x13, 0x73, 0x48, 0x15, 0xFC, 0x38, 0x23, 0xED, 0x15, 0x86, 0x9F, 0xB0,
  0x2E, 0xF3, 0x78, 0x4D, 0xFA, 0xDF, 0x87, 0x10, 0x5B, 0x0D, 0x73, 0x0B, 0xA0, 0x58, 0x0D, 0x30,
  0x0A, 0xFD, 0x07, 0x0A, 0xFD, 0x85, 0x73, 0x55, 0x55, 0x9A, 0x84, 0x85, 0x55, 0x52, 0x50, 0x6A,
  0x04, 0x73, 0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04, 0x73, 0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04, 0x73,
  0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04, 0x73, 0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04, 0x73, 0x06, 0xA0,
  0x47, 0x30, 0x6A, 0x04, 0x73, 0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04, 0x73, 0x06, 0xA0, 0x47, 0x30,
  0x6A, 0x04, 0x73, 0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04, 0x73, 0x06, 0xA0, 0x47, 0x30, 0x6A, 0x04,
  0x73, 0x06, 0xA0, 0x45,
  // "ť" (U+0165)
  0x72, 0x07, 0xA0, 0x37, 0x28, 0x19, 0xFE, 0x73, 0x81, 0xCF, 0x84, 0x81, 0xCF, 0x13, 0x81, 0xEF,
  0x14, 0x81, 0xEF, 0x12, 0x81, 0x2F, 0x84, 0x02, 0xA0, 0x17, 0x20, 0x6A, 0x01, 0x78, 0x11, 0x8E,
  0xD0, 0x84, 0x07, 0xF0, 0x84, 0x81, 0x25, 0xBA, 0x82, 0x65, 0x53, 0x60, 0x9A, 0x01, 0x72, 0x09,
  0xA0, 0x17, 0x20, 0x9A, 0x01, 0x72, 0x09, 0xA0, 0x17, 0x20, 0x9A, 0x01, 0x72, 0x09, 0xA0, 0x17,
  0x20, 0x9A, 0x01, 0x72, 0x09, 0xA0, 0x17, 0x20, 0x9A, 0x01, 0x72, 0x09, 0xA0, 0x17, 0x20, 0x9A,
  0x01, 0x72, 0x08, 0xA0, 0x47, 0x20, 0x4A, 0x82, 0xD6, 0x56, 0x70, 0xCC, 0x0B, 0x78, 0x41, 0x9E,
  0xFD, 0x74,
  // "Ŧ" (U+0166)
  0x0A, 0xFD, 0x07, 0x0A, 0xFD, 0x85, 0x73, 0x55, 0x55, 0xAA, 0x84, 0x85, 0x55, 0x52, 0x50, 0x7A,
  0x04, 0x73, 0x07, 0xA0, 0x47, 0x30, 0x7A, 0x04, 0x73, 0x07, 0xA0, 0x47, 0x30, 0x7A, 0x04, 0x73,
  0x07, 0xA0, 0x47, 0x30, 0x7A, 0x04, 0x60, 0x2F, 0xB3, 0x02, 0xFB, 0x40, 0xF5, 0x0A, 0xA0, 0x80,
  0xF5, 0x70, 0x7A, 0x04, 0x73, 0x07, 0xA0, 0x47, 0x30, 0x7A, 0x04, 0x73, 0x07, 0xA0, 0x47, 0x30,
  0x7A, 0x04, 0x73, 0x07, 0xA0, 0x47, 0x30, 0x7A, 0x04, 0x73, 0x07, 0xA0, 0x47, 0x30, 0x7A, 0x04,
  0x73, 0x07, 0xA0, 0x45,
  // "ŧ" (U+0167)
  0x38, 0x1C, 0xF1, 0x68, 0x1E, 0xF1, 0x50, 0x2A, 0x01, 0x50, 0x6A, 0x01, 0x38, 0x11, 0x8E, 0xD0,
  0x80, 0x7F, 0x82, 0x82, 0x5B, 0xA8, 0x26, 0x55, 0x32, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09,
  0xA0, 0x13, 0x81, 0x25, 0xBA, 0x83, 0x65, 0x52, 0x5F, 0x06, 0x05, 0xF0, 0x62, 0x09, 0xA0, 0x15,
  0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x09, 0xA0, 0x15, 0x08, 0xA0, 0x45, 0x05,
  0xA8, 0x2D, 0x65, 0x63, 0x0D, 0xC0, 0xB3, 0x84, 0x1A, 0xEF, 0xD7,
  // "Ũ" (U+0168)
  0x38, 0x34, 0xDE, 0xA2, 0x28, 0x15, 0xF5, 0x50, 0xEC, 0x83, 0x96, 0xDF, 0x24, 0x83, 0x6F, 0xB6,
  0xCC, 0x0B, 0x58, 0x19, 0xF1, 0x28, 0x35, 0xCF, 0xB1, 0x80, 0xD4, 0x00, 0x9A, 0x01, 0x70, 0x6A,
  0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06,
  0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70,
  0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17,
  0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01,
  0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0,
  0x27, 0x06, 0xA0, 0x40, 0x8A, 0x02, 0x70, 0x7A, 0x03, 0x06, 0xA0, 0x57, 0x0A, 0xA0, 0x10, 0x3A,
  0x0A, 0x78, 0x1E, 0xFD, 0x20, 0xCA, 0x05, 0x50, 0x9A, 0x07, 0x20, 0x3B, 0x83, 0xB6, 0x57, 0xCA,
  0x0D, 0x40, 0x5F, 0x90, 0xD0, 0x25, 0x86, 0x18, 0xCE, 0xFE, 0xB6, 0x40,
  // "ũ" (U+0169)
  0x28, 0x34, 0xDE, 0xA2, 0x28, 0x15, 0xF5, 0x20, 0xEC, 0x89, 0x19, 0x6D, 0xF2, 0x06, 0xFB, 0x6C,
  0xC0, 0xB2, 0x81, 0x9F, 0x12, 0x83, 0x5C, 0xFB, 0x17, 0x77, 0x48, 0x1C, 0xFC, 0x68, 0x4C, 0xFD,
  0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68,
  0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC,
  0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4D, 0xFD, 0xCF, 0xD6, 0x84,
  0xEF, 0xDC, 0xFE, 0x50, 0x1A, 0x0D, 0x0A, 0xA0, 0x14, 0x06, 0xA0, 0xD0, 0x7A, 0x07, 0x30, 0x10,
  0xDA, 0x0D, 0x01, 0xB8, 0x90, 0x85, 0x7D, 0xFB, 0xFD, 0x07, 0xE8, 0x26, 0x7F, 0xD2, 0x89, 0x05,
  0xCE, 0xEB, 0x40, 0x5F, 0xD0,
  // "Ū" (U+016A)
  0x30, 0x48, 0x03, 0x50, 0x36, 0x0B, 0xF0, 0x86, 0x0B, 0xF0, 0x88, 0x0D, 0x40, 0x09, 0xA0, 0x17,
  0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01,
  0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0,
  0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A,
  0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09,
  0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40,
  0x9A, 0x02, 0x70, 0x6A, 0x04, 0x08, 0xA0, 0x27, 0x07, 0xA0, 0x30, 0x6A, 0x05, 0x70, 0xAA, 0x01,
  0x03, 0xA0, 0xA7, 0x81, 0xEF, 0xD2, 0x0C, 0xA0, 0x55, 0x09, 0xA0, 0x72, 0x03, 0xB8, 0x3B, 0x65,
  0x7C, 0xA0, 0xD4, 0x05, 0xF9, 0x0D, 0x02, 0x58, 0x61, 0x8C, 0xEF, 0xEB, 0x64,
  // "ū" (U+016B)
  0x20, 0x48, 0x03, 0x50, 0x33, 0x0B, 0xF0, 0x83, 0x0B, 0xF0, 0x87, 0x77, 0x48, 0x1C, 0xFC, 0x68,
  0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC,
  0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84,
  0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4D, 0xFD, 0xCF,
  0xD6, 0x84, 0xEF, 0xDC, 0xFE, 0x50, 0x1A, 0x0D, 0x0A, 0xA0, 0x14, 0x06, 0xA0, 0xD0, 0x7A, 0x07,
  0x30, 0x10, 0xDA, 0x0D, 0x01, 0xB8, 0x90, 0x85, 0x7D, 0xFB, 0xFD, 0x07, 0xE8, 0x26, 0x7F, 0xD2,
  0x89, 0x05, 0xCE, 0xEB, 0x40, 0x5F, 0xD0,
  // "Ŭ" (U+016C)
  0x30, 0x50, 0x75, 0x07, 0x05, 0x68, 0x19, 0xF4, 0x38, 0x14, 0xF9, 0x68, 0x75, 0xFE, 0x86, 0x8E,
  0xF4, 0x70, 0xCD, 0x0A, 0x71, 0x84, 0x19, 0xEF, 0xD7, 0x80, 0xD6, 0x00, 0x9A, 0x01, 0x70, 0x6A,
  0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06,
  0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70,
  0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17,
  0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01,
  0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0,
  0x27, 0x06, 0xA0, 0x40, 0x8A, 0x02, 0x70, 0x7A, 0x03, 0x06, 0xA0, 0x57, 0x0A, 0xA0, 0x10, 0x3A,
  0x0A, 0x78, 0x1E, 0xFD, 0x20, 0xCA, 0x05, 0x50, 0x9A, 0x07, 0x20, 0x3B, 0x83, 0xB6, 0x57, 0xCA,
  0x0D, 0x40, 0x5F, 0x90, 0xD0, 0x25, 0x86, 0x18, 0xCE, 0xFE, 0xB6, 0x40,
  // "ŭ" (U+016D)
  0x20, 0x50, 0x75, 0x07, 0x05, 0x38, 0x19, 0xF4, 0x38, 0x14, 0xF9, 0x38, 0x75, 0xFE, 0x86, 0x8E,
  0xF4, 0x40, 0xCD, 0x0A, 0x58, 0x41, 0x9E, 0xFD, 0x77, 0x77, 0x68, 0x1C, 0xFC, 0x68, 0x4C, 0xFD,
  0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68,
  0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC,
  0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4D, 0xFD, 0xCF, 0xD6, 0x84,
  0xEF, 0xDC, 0xFE, 0x50, 0x1A, 0x0D, 0x0A, 0xA0, 0x14, 0x06, 0xA0, 0xD0, 0x7A, 0x07, 0x30, 0x10,
  0xDA, 0x0D, 0x01, 0xB8, 0x90, 0x85, 0x7D, 0xFB, 0xFD, 0x07, 0xE8, 0x26, 0x7F, 0xD2, 0x89, 0x05,
  0xCE, 0xEB, 0x40, 0x5F, 0xD0,
  // "Ů" (U+016E)
  0x58, 0x32, 0x9C, 0xA4, 0x72, 0x01, 0x0E, 0xC0, 0x67, 0x18, 0x58, 0xF7, 0x03, 0xEE, 0x71, 0x0A,
  0x93, 0x09, 0x97, 0x18, 0x58, 0xF4, 0x01, 0xDE, 0x71, 0x02, 0xA0, 0xDA, 0x07, 0x72, 0x83, 0x4C,
  0xED, 0x78, 0x0D, 0x60, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09,
  0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40,
  0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04,
  0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0,
  0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A,
  0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x02, 0x70, 0x6A, 0x04, 0x08, 0xA0, 0x27, 0x07,
  0xA0, 0x30, 0x6A, 0x05, 0x70, 0xAA, 0x01, 0x03, 0xA0, 0xA7, 0x81, 0xEF, 0xD2, 0x0C, 0xA0, 0x55,
  0x09, 0xA0, 0x72, 0x03, 0xB8, 0x3B, 0x65, 0x7C, 0xA0, 0xD4, 0x05, 0xF9, 0x0D, 0x02, 0x58, 0x61,
  0x8C, 0xEF, 0xEB, 0x64,
  // "ů" (U+016F)
  0x38, 0x32, 0x9C, 0xA4, 0x60, 0x10, 0xEC, 0x06, 0x58, 0x58, 0xF7, 0x03, 0xEE, 0x50, 0xA9, 0x30,
  0x99, 0x58, 0x58, 0xF4, 0x01, 0xDE, 0x50, 0x2A, 0x0D, 0xA0, 0x76, 0x83, 0x4C, 0xED, 0x77, 0x77,
  0x78, 0x1C, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF,
  0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C,
  0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC, 0x68, 0x4C, 0xFD, 0xCF, 0xC6, 0x84, 0xCF, 0xDC, 0xFC,
  0x68, 0x4D, 0xFD, 0xCF, 0xD6, 0x84, 0xEF, 0xDC, 0xFE, 0x50, 0x1A, 0x0D, 0x0A, 0xA0, 0x14, 0x06,
  0xA0, 0xD0, 0x7A, 0x07, 0x30, 0x10, 0xDA, 0x0D, 0x01, 0xB8, 0x90, 0x85, 0x7D, 0xFB, 0xFD, 0x07,
  0xE8, 0x26, 0x7F, 0xD2, 0x89, 0x05, 0xCE, 0xEB, 0x40, 0x5F, 0xD0,
  // "Ű" (U+0170)
  0x50, 0x5A, 0x81, 0x80, 0x6A, 0x07, 0x68, 0x1D, 0xFD, 0x28, 0x1E, 0xFC, 0x68, 0x76, 0xFE, 0x20,
  0x7F, 0xD1, 0x58, 0x71, 0xEE, 0x40, 0x1E, 0xE2, 0x68, 0x19, 0xE3, 0x28, 0x1A, 0xE3, 0x80, 0xD5,
  0x00, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A,
  0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06,
  0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70,
  0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17,
  0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01,
  0x70, 0x6A, 0x04, 0x09, 0xA0, 0x27, 0x06, 0xA0, 0x40, 0x8A, 0x02, 0x70, 0x7A, 0x03, 0x06, 0xA0,
  0x57, 0x0A, 0xA0, 0x10, 0x3A, 0x0A, 0x78, 0x1E, 0xFD, 0x20, 0xCA, 0x05, 0x50, 0x9A, 0x07, 0x20,
  0x3B, 0x83, 0xB6, 0x57, 0xCA, 0x0D, 0x40, 0x5F, 0x90, 0xD0, 0x25, 0x86, 0x18, 0xCE, 0xFE, 0xB6,
  0x40,
  // "ű" (U+0171)
  0x40, 0x5A, 0x81, 0x80, 0x6A, 0x07, 0x48, 0x1D, 0xFD, 0x28, 0x1E, 0xFC, 0x48, 0x76, 0xFE, 0x20,
  0x7F, 0xD1, 0x38, 0x71, 0xEE, 0x40, 0x1E, 0xE2, 0x48, 0x19, 0xE3, 0x28, 0x1A, 0xE3, 0x77, 0x77,
  0x18, 0x1C, 0xFC, 0x68, 0x5C, 0xFD, 0x0C, 0xFC, 0x68, 0x5C, 0xFD, 0x0C, 0xFC, 0x68, 0x5C, 0xFD,
  0x0C, 0xFC, 0x68, 0x5C, 0xFD, 0x0C, 0xFC, 0x68, 0x5C, 0xFD, 0x0C, 0xFC, 0x68, 0x5C, 0xFD, 0x0C,
  0xFC, 0x68, 0x5C, 0xFD, 0x0C, 0xFC, 0x68, 0x5C, 0xFD, 0x0C, 0xFC, 0x68, 0x5C, 0xFD, 0x0C, 0xFC,
  0x68, 0x5C, 0xFD, 0x0C, 0xFC, 0x68, 0x5D, 0xFD, 0x0C, 0xFD, 0x68, 0x5E, 0xFD, 0x0C, 0xFE, 0x50,
  0x1A, 0x81, 0xD0, 0xAA, 0x01, 0x40, 0x6A, 0x81, 0xD0, 0x7A, 0x07, 0x30, 0x10, 0xDA, 0x81, 0xD0,
  0x1B, 0x86, 0x85, 0x7D, 0xFB, 0xFD, 0x20, 0x7E, 0x82, 0x67, 0xFD, 0x38, 0x90, 0x5C, 0xEE, 0xB4,
  0x05, 0xFD, 0x10,
  // "Ų" (U+0172)
  0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0,
  0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A,
  0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06,
  0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70,
  0x6A, 0x04, 0x09, 0xA0, 0x17, 0x06, 0xA0, 0x40, 0x9A, 0x01, 0x70, 0x6A, 0x04, 0x09, 0xA0, 0x17,
  0x06, 0xA0, 0x40, 0x9A, 0x02, 0x70, 0x6A, 0x04, 0x08, 0xA0, 0x27, 0x07, 0xA0, 0x30, 0x6A, 0x05,
  0x70, 0xAA, 0x02, 0x03, 0xA0, 0xA7, 0x81, 0xEF, 0xD2, 0x0C, 0xA0, 0x55, 0x09, 0xA0, 0x82, 0x03,
  0xB8, 0x3B, 0x65, 0x7C, 0xA0, 0xE0, 0x13, 0x05, 0xF9, 0x0E, 0x03, 0x58, 0x41, 0x8C, 0xEF, 0xEA,
  0x04, 0x74, 0x81, 0x7F, 0x67, 0x48, 0x12, 0xFC, 0x75, 0x81, 0x9F, 0x67, 0x58, 0x1D, 0xF4, 0x75,
  0x83, 0xDF, 0x90, 0x17, 0x30, 0xAB, 0x0D, 0x73, 0x02, 0x0D, 0xA0, 0xD7, 0x58, 0x14, 0x52, 0x30,
  // "ų" (U+0173)
  0x81, 0xCF, 0xC6, 0x85, 0xCF, 0xD0, 0xCF, 0xC6, 0x85, 0xCF, 0xD0, 0xCF, 0xC6, 0x85, 0xCF, 0xD0,
  0xCF, 0xC6, 0x85, 0xCF, 0xD0, 0xCF, 0xC6, 0x85, 0xCF, 0xD0, 0xCF, 0xC6, 0x85, 0xCF, 0xD0, 0xCF,
  0xC6, 0x85, 0xCF, 0xD0, 0xCF, 0xC6, 0x85, 0xCF, 0xD0, 0xCF, 0xC6, 0x85, 0xCF, 0xD0, 0xCF, 0xC6,
  0x85, 0xCF, 0xD0, 0xCF, 0xC6, 0x85, 0xDF, 0xD0, 0xCF, 0xD6, 0x85, 0xEF, 0xD0, 0xCF, 0xE5, 0x01,
  0xA8, 0x1D, 0x0A, 0xA0, 0x14, 0x06, 0xA8, 0x1D, 0x07, 0xA0, 0x73, 0x01, 0x0D, 0xA8, 0x1D, 0x01,
  0xB8, 0x68, 0x57, 0xDF, 0xBF, 0xD2, 0x07, 0xE8, 0x26, 0x7F, 0xD3, 0x84, 0x5C, 0xEE, 0xB4, 0x1B,
  0x72, 0x81, 0x7F, 0x67, 0x28, 0x11, 0xFC, 0x73, 0x81, 0x7F, 0x87, 0x38, 0x1A, 0xF8, 0x73, 0x83,
  0x9F, 0xE6, 0x67, 0x10, 0x5C, 0x01, 0x71, 0x82, 0x7D, 0xFC, 0x10,
  // "Ŵ" (U+0174)
  0x74, 0x82, 0x47, 0x71, 0x77, 0x60, 0x10, 0xEA, 0x09, 0x77, 0x60, 0x9C, 0x03, 0x77, 0x40, 0x3A,
  0x82, 0x49, 0xFC, 0x77, 0x48, 0x1D, 0xF5, 0x28, 0x1A, 0xF8, 0x77, 0x28, 0x19, 0xF6, 0x48, 0x1A,
  0xF3, 0x80, 0x99, 0x60, 0x0A, 0xA0, 0x17, 0x81, 0xEF, 0xE7, 0x01, 0xA0, 0xB0, 0x7A, 0x05, 0x60,
  0x2B, 0x02, 0x60, 0x4A, 0x07, 0x03, 0xA0, 0x86, 0x06, 0xB0, 0x66, 0x07, 0xA0, 0x41, 0xA0, 0xB6,
  0x09, 0xB0, 0x96, 0x0A, 0xA2, 0x81, 0xCF, 0xE6, 0x83, 0xDF, 0xCF, 0xD6, 0x81, 0xEF, 0xC2, 0x09,
  0xA0, 0x24, 0x01, 0xA0, 0x8A, 0x01, 0x40, 0x2A, 0x09, 0x20, 0x5A, 0x06, 0x40, 0x4A, 0x03, 0xA0,
  0x44, 0x05, 0xA0, 0x62, 0x02, 0xA0, 0x94, 0x85, 0x8F, 0xD0, 0xEF, 0x84, 0x08, 0xA0, 0x23, 0x81,
  0xEF, 0xC4, 0x85, 0xBF, 0xA0, 0xBF, 0xB4, 0x81, 0xCF, 0xE4, 0x0A, 0xA4, 0x83, 0xEF, 0x70, 0x7A,
  0x4A, 0x0B, 0x40, 0x7A, 0x03, 0x20, 0x3A, 0x81, 0x30, 0x3A, 0x03, 0x20, 0x3A, 0x07, 0x40, 0x3A,
  0x07, 0x20, 0x6A, 0x3A, 0x07, 0x20, 0x6A, 0x04, 0x5A, 0x0A, 0x28, 0x1A, 0xFC, 0x38, 0x1C, 0xFA,
  0x20, 0x9A, 0x01, 0x58, 0x1C, 0xFD, 0x28, 0x1D, 0xF8, 0x38, 0x18, 0xFE, 0x28, 0x1D, 0xFD, 0x60,
  0x8A, 0x00, 0x1A, 0x05, 0x30, 0x5A, 0x02, 0x01, 0xA0, 0x96, 0x05, 0xA0, 0x04, 0xA0, 0x13, 0x01,
  0xA0, 0x50, 0x4A, 0x06, 0x60, 0x1A, 0x82, 0x67, 0xFD, 0x58, 0x2D, 0xF8, 0x7A, 0x02, 0x78, 0x4D,
  0xF9, 0xAF, 0xA5, 0x84, 0x9F, 0xA9, 0xFE, 0x71, 0x84, 0xAF, 0xBD, 0xF6, 0x58, 0x46, 0xFD, 0xBF,
  0xB7, 0x18, 0x16, 0xFE, 0xA0, 0x35, 0x02, 0xA8, 0x1E, 0xF8, 0x71, 0x03, 0xB0, 0xE7, 0x0E, 0xB0,
  0x47, 0x2B, 0x0B, 0x70, 0xBB, 0x01, 0x72, 0x0B, 0xA0, 0x87, 0x07, 0xA0, 0xD5,
  // "ŵ" (U+0175)
  0x72, 0x82, 0x47, 0x71, 0x77, 0x20, 0x10, 0xEA, 0x09, 0x77, 0x20, 0x9C, 0x03, 0x77, 0x03, 0xA8,
  0x24, 0x9F, 0xC7, 0x78, 0x1D, 0xF5, 0x28, 0x1A, 0xF8, 0x75, 0x81, 0x9F, 0x64, 0x81, 0xAF, 0x38,
  0x0D, 0x30, 0x09, 0xA0, 0x15, 0xB0, 0x25, 0x82, 0xEF, 0xA5, 0xA0, 0x54, 0x03, 0xB0, 0x54, 0x02,
  0xA0, 0x70, 0x2A, 0x08, 0x40, 0x7B, 0x09, 0x40, 0x6A, 0x83, 0x30, 0xEF, 0xB4, 0x83, 0xBF, 0xCF,
  0xC4, 0x09, 0xA2, 0x81, 0xAF, 0xE4, 0x81, 0xEF, 0x7A, 0x48, 0x1C, 0xFB, 0x20, 0x7A, 0x02, 0x20,
  0x2A, 0x02, 0xA0, 0x33, 0xA0, 0x82, 0x03, 0xA0, 0x52, 0x85, 0x6F, 0xE0, 0xCF, 0x72, 0x03, 0xA0,
  0x43, 0xA0, 0x82, 0x85, 0x9F, 0xA0, 0x9F, 0xA2, 0x06, 0xA0, 0x13, 0x81, 0xCF, 0xC2, 0x85, 0xDF,
  0x70, 0x6F, 0xE2, 0x81, 0xAF, 0xD4, 0x09, 0xA1, 0x01, 0xA8, 0x13, 0x02, 0xA8, 0x32, 0x0D, 0xF9,
  0x40, 0x5A, 0x02, 0x04, 0xA3, 0x82, 0xEF, 0x51, 0xA0, 0x64, 0x02, 0xA8, 0x25, 0x7F, 0xC3, 0x82,
  0xBF, 0x93, 0xA0, 0x25, 0x84, 0xEF, 0x8A, 0xF8, 0x38, 0x48, 0xFB, 0x6F, 0xE6, 0x84, 0xBF, 0xAC,
  0xF5, 0x38, 0x45, 0xFE, 0x9F, 0xB6, 0x81, 0x7F, 0xDA, 0x01, 0x30, 0x1A, 0x81, 0xDF, 0x76, 0x04,
  0xB0, 0xD5, 0x0E, 0xB0, 0x47, 0xB0, 0xA5, 0x0A, 0xB7, 0x10, 0xCA, 0x06, 0x50, 0x7A, 0x0C, 0x40,
  // "Ŷ" (U+0176)
  0x58, 0x24, 0x77, 0x17, 0x20, 0x10, 0xEA, 0x09, 0x72, 0x09, 0xC0, 0x37, 0x03, 0xA8, 0x24, 0x9F,
  0xC7, 0x81, 0xDF, 0x52, 0x81, 0xAF, 0x85, 0x81, 0x9F, 0x64, 0x81, 0xAF, 0x38, 0x0D, 0x00, 0x0C,
  0xA0, 0x17, 0x82, 0xDF, 0xE6, 0xA0, 0x76, 0x03, 0xA8, 0x39, 0x0E, 0xFD, 0x60, 0x9A, 0x81, 0x20,
  0x9A, 0x04, 0x58, 0x1E, 0xFC, 0x20, 0x2A, 0x0A, 0x40, 0x6A, 0x05, 0x30, 0xCA, 0x01, 0x38, 0x1C,
  0xFE, 0x40, 0x5A, 0x06, 0x20, 0x2A, 0x08, 0x58, 0x1E, 0xFC, 0x20, 0x8A, 0x02, 0x50, 0x8A, 0x83,
  0x30, 0xEF, 0xB6, 0x02, 0xA0, 0x90, 0x5A, 0x05, 0x78, 0x4B, 0xFE, 0xBF, 0xE7, 0x10, 0x5C, 0x08,
  0x72, 0x0E, 0xB0, 0x27, 0x20, 0x8A, 0x0B, 0x73, 0x04, 0xA0, 0x77, 0x30, 0x4A, 0x07, 0x73, 0x04,
  0xA0, 0x77, 0x30, 0x4A, 0x07, 0x73, 0x04, 0xA0, 0x77, 0x30, 0x4A, 0x07, 0x73, 0x04, 0xA0, 0x77,
  0x30, 0x4A, 0x07, 0x73, 0x04, 0xA0, 0x75,
  // "ŷ" (U+0177)
  0x58, 0x24, 0x77, 0x17, 0x10, 0x10, 0xEA, 0x09, 0x71, 0x09, 0xC0, 0x36, 0x03, 0xA8, 0x24, 0x9F,
  0xC6, 0x81, 0xDF, 0x52, 0x81, 0xAF, 0x84, 0x81, 0x9F, 0x64, 0x81, 0xAF, 0x37, 0x77, 0x60, 0xBA,
  0x78, 0x2C, 0xFE, 0x7A, 0x04, 0x6A, 0x0A, 0x02, 0xA0, 0x85, 0x04, 0xA8, 0x36, 0x0D, 0xFC, 0x50,
  0x8A, 0x81, 0x10, 0x9A, 0x01, 0x48, 0x1C, 0xFC, 0x20, 0x4A, 0x05, 0x30, 0x1A, 0x08, 0x3A, 0x09,
  0x30, 0x5A, 0x04, 0x38, 0x1B, 0xFD, 0x38, 0x19, 0xFE, 0x40, 0x6A, 0x02, 0x28, 0x1D, 0xFB, 0x40,
  0x2A, 0x81, 0x60, 0x1A, 0x06, 0x58, 0x3D, 0xFA, 0x05, 0xA0, 0x25, 0x85, 0x8F, 0xE0, 0x9F, 0xD6,
  0x04, 0xA8, 0x22, 0xDF, 0x97, 0x81, 0xEF, 0x6A, 0x04, 0x78, 0x1A, 0xFD, 0xA7, 0x10, 0x6B, 0x0B,
  0x71, 0x01, 0xB0, 0x77, 0x20, 0xCA, 0x03, 0x72, 0x81, 0xCF, 0xE7, 0x20, 0x1A, 0x09, 0x72, 0x05,
  0xA0, 0x57, 0x20, 0xBA, 0x72, 0x03, 0xA0, 0xA6, 0x82, 0x45, 0x7E, 0xA0, 0x26, 0x09, 0xC0, 0x77,
  0x83, 0x7E, 0xFC, 0x57, 0x10,
  // "Ÿ" (U+0178)
  0x28, 0x22, 0xEC, 0x12, 0x81, 0xAE, 0x65, 0x06, 0xA0, 0x32, 0xA0, 0xB5, 0x81, 0x2D, 0xC3, 0x81,
  0xAE, 0x58, 0x0D, 0x10, 0x0C, 0xA0, 0x17, 0x82, 0xDF, 0xE6, 0xA0, 0x76, 0x03, 0xA8, 0x39, 0x0E,
  0xFD, 0x60, 0x9A, 0x81, 0x20, 0x9A, 0x04, 0x58, 0x1E, 0xFC, 0x20, 0x2A, 0x0A, 0x40, 0x6A, 0x05,
  0x30, 0xCA, 0x01, 0x38, 0x1C, 0xFE, 0x40, 0x5A, 0x06, 0x20, 0x2A, 0x08, 0x58, 0x1E, 0xFC, 0x20,
  0x8A, 0x02, 0x50, 0x8A, 0x83, 0x30, 0xEF, 0xB6, 0x02, 0xA0, 0x90, 0x5A, 0x05, 0x78, 0x4B, 0xFE,
  0xBF, 0xE7, 0x10, 0x5C, 0x08, 0x72, 0x0E, 0xB0, 0x27, 0x20, 0x8A, 0x0B, 0x73, 0x04, 0xA0, 0x77,
  0x30, 0x4A, 0x07, 0x73, 0x04, 0xA0, 0x77, 0x30, 0x4A, 0x07, 0x73, 0x04, 0xA0, 0x77, 0x30, 0x4A,
  0x07, 0x73, 0x04, 0xA0, 0x77, 0x30, 0x4A, 0x07, 0x73, 0x04, 0xA0, 0x75,
  // "Ź" (U+0179)
  0x70, 0xF7, 0x02, 0x70, 0x5A, 0x0D, 0x01, 0x70, 0xDA, 0x03, 0x70, 0x6A, 0x06, 0x78, 0x21, 0xEF,
  0x87, 0x18, 0x19, 0xF8, 0x80, 0xC5, 0x00, 0xDF, 0xB0, 0x80, 0xDF, 0xB0, 0x80, 0x48, 0x03, 0x50,
  0xCA, 0x04, 0x70, 0x1A, 0x0D, 0x71, 0x08, 0xA0, 0x67, 0x18, 0x1E, 0xFE, 0x71, 0x06, 0xA0, 0x77,
  0x18, 0x2D, 0xFE, 0x17, 0x05, 0xA0, 0x87, 0x10, 0xCA, 0x01, 0x70, 0x4A, 0x0A, 0x71, 0x0B, 0xA0,
  0x27, 0x02, 0xA0, 0xB7, 0x10, 0x9A, 0x04, 0x70, 0x1A, 0x0C, 0x71, 0x08, 0xA0, 0x57, 0x18, 0x1E,
  0xFD, 0x71, 0x07, 0xA0, 0x67, 0x18, 0x1D, 0xFE, 0x71, 0x05, 0xA0, 0x87, 0x10, 0xCA, 0x07, 0x80,
  0x35, 0x04, 0xFC, 0x0B, 0xFC, 0x0B,
  // "ź" (U+017A)
  0x70, 0xF7, 0x02, 0x60, 0x5A, 0x0D, 0x01, 0x60, 0xDA, 0x03, 0x60, 0x6A, 0x06, 0x68, 0x21, 0xEF,
  0x87, 0x81, 0x9F, 0x87, 0x77, 0x60, 0xAF, 0x98, 0x13, 0x0A, 0xF9, 0x81, 0x30, 0x38, 0x01, 0x58,
  0x2E, 0xFE, 0x16, 0x03, 0xA0, 0x87, 0x0A, 0xA0, 0x16, 0x02, 0xA0, 0x97, 0x09, 0xA0, 0x26, 0x01,
  0xA0, 0xA7, 0x08, 0xA0, 0x36, 0x82, 0x1E, 0xFB, 0x70, 0x7A, 0x04, 0x78, 0x1E, 0xFC, 0x70, 0x6A,
  0x05, 0x78, 0x1D, 0xFD, 0x70, 0x5A, 0x06, 0x70, 0xCA, 0x06, 0x80, 0x15, 0x02, 0x01, 0xFA, 0x07,
  0x01, 0xFA, 0x07,
  // "Ż" (U+017B)
  0x48, 0x13, 0xEC, 0x72, 0x0A, 0xA0, 0x57, 0x10, 0xAA, 0x05, 0x71, 0x81, 0x3E, 0xC8, 0x0E, 0x10,
  0x0D, 0xFB, 0x08, 0x0D, 0xFB, 0x08, 0x04, 0x80, 0x35, 0x0C, 0xA0, 0x47, 0x01, 0xA0, 0xD7, 0x10,
  0x8A, 0x06, 0x71, 0x81, 0xEF, 0xE7, 0x10, 0x6A, 0x07, 0x71, 0x82, 0xDF, 0xE1, 0x70, 0x5A, 0x08,
  0x71, 0x0C, 0xA0, 0x17, 0x04, 0xA0, 0xA7, 0x10, 0xBA, 0x02, 0x70, 0x2A, 0x0B, 0x71, 0x09, 0xA0,
  0x47, 0x01, 0xA0, 0xC7, 0x10, 0x8A, 0x05, 0x71, 0x81, 0xEF, 0xD7, 0x10, 0x7A, 0x06, 0x71, 0x81,
  0xDF, 0xE7, 0x10, 0x5A, 0x08, 0x71, 0x0C, 0xA0, 0x78, 0x03, 0x50, 0x4F, 0xC0, 0xBF, 0xC0, 0xB0,
  // "ż" (U+017C)
  0x48, 0x13, 0xEC, 0x71, 0x0A, 0xA0, 0x57, 0x0A, 0xA0, 0x57, 0x81, 0x3E, 0xC8, 0x0C, 0x20, 0x0A,
  0xF9, 0x81, 0x30, 0xAF, 0x98, 0x13, 0x03, 0x80, 0x15, 0x82, 0xEF, 0xE1, 0x60, 0x3A, 0x08, 0x70,
  0xAA, 0x01, 0x60, 0x2A, 0x09, 0x70, 0x9A, 0x02, 0x60, 0x1A, 0x0A, 0x70, 0x8A, 0x03, 0x68, 0x21,
  0xEF, 0xB7, 0x07, 0xA0, 0x47, 0x81, 0xEF, 0xC7, 0x06, 0xA0, 0x57, 0x81, 0xDF, 0xD7, 0x05, 0xA0,
  0x67, 0x0C, 0xA0, 0x68, 0x01, 0x50, 0x20, 0x1F, 0xA0, 0x70, 0x1F, 0xA0, 0x70,
  // "Ž" (U+017D)
  0x18, 0x15, 0x71, 0x48, 0x13, 0x73, 0x28, 0x15, 0xFC, 0x38, 0x23, 0xED, 0x13, 0x86, 0x9F, 0xB0,
  0x2E, 0xF3, 0x58, 0x4D, 0xFA, 0xDF, 0x86, 0x05, 0xB0, 0xD7, 0x10, 0xBA, 0x05, 0x80, 0xC4, 0x00,
  0xDF, 0xB0, 0x80, 0xDF, 0xB0, 0x80, 0x48, 0x03, 0x50, 0xCA, 0x04, 0x70, 0x1A, 0x0D, 0x71, 0x08,
  0xA0, 0x67, 0x18, 0x1E, 0xFE, 0x71, 0x06, 0xA0, 0x77, 0x18, 0x2D, 0xFE, 0x17, 0x05, 0xA0, 0x87,
  0x10, 0xCA, 0x01, 0x70, 0x4A, 0x0A, 0x71, 0x0B, 0xA0, 0x27, 0x02, 0xA0, 0xB7, 0x10, 0x9A, 0x04,
  0x70, 0x1A, 0x0C, 0x71, 0x08, 0xA0, 0x57, 0x18, 0x1E, 0xFD, 0x71, 0x07, 0xA0, 0x67, 0x18, 0x1D,
  0xFE, 0x71, 0x05, 0xA0, 0x87, 0x10, 0xCA, 0x07, 0x80, 0x35, 0x04, 0xFC, 0x0B, 0xFC, 0x0B,
  // "ž" (U+017E)
  0x18, 0x15, 0x71, 0x48, 0x53, 0x73, 0x05, 0xFC, 0x38, 0x23, 0xED, 0x12, 0x86, 0x9F, 0xB0, 0x2E,
  0xF3, 0x48, 0x4D, 0xFA, 0xDF, 0x85, 0x05, 0xB0, 0xD7, 0x0B, 0xA0, 0x57, 0x77, 0x50, 0xAF, 0x98,
  0x13, 0x0A, 0xF9, 0x81, 0x30, 0x38, 0x01, 0x58, 0x2E, 0xFE, 0x16, 0x03, 0xA0, 0x87, 0x0A, 0xA0,
  0x16, 0x02, 0xA0, 0x97, 0x09, 0xA0, 0x26, 0x01, 0xA0, 0xA7, 0x08, 0xA0, 0x36, 0x82, 0x1E, 0xFB,
  0x70, 0x7A, 0x04, 0x78, 0x1E, 0xFC, 0x70, 0x6A, 0x05, 0x78, 0x1D, 0xFD, 0x70, 0x5A, 0x06, 0x70,
  0xCA, 0x06, 0x80, 0x15, 0x02, 0x01, 0xFA, 0x07, 0x01, 0xFA, 0x07,
  // "ſ" (U+017F)
  0x28, 0x66, 0xCF, 0xEB, 0x40, 0x7D, 0x89, 0x04, 0x1E, 0xFE, 0x76, 0xB0, 0x5A, 0x06, 0x40, 0x7A,
  0x02, 0x40, 0x9A, 0x01, 0x40, 0x9A, 0x01, 0x40, 0x9A, 0x01, 0x40, 0x9A, 0x01, 0x40, 0x9A, 0x01,
  0x40, 0x9A, 0x01, 0x40, 0x9A, 0x01, 0x40, 0x9A, 0x01, 0x40, 0x9A, 0x01, 0x40, 0x9A, 0x01, 0x40,
  0x9A, 0x01, 0x40, 0x9A, 0x01, 0x40, 0x9A, 0x01, 0x40, 0x9A, 0x01, 0x40, 0x9A, 0x01, 0x40, 0x9A,
  0x01, 0x40, 0x9A, 0x01, 0x40, 0x9A, 0x01, 0x40, 0x9A, 0x01, 0x40, 0x9A, 0x01, 0x40,
  // "Ω" (U+03A9)
  0x58, 0x64, 0x9D, 0xEE, 0xD9, 0x47, 0x10, 0x10, 0xBF, 0x90, 0xB0, 0x15, 0x01, 0x0D, 0xA8, 0x4E,
  0x96, 0x69, 0xEA, 0x0C, 0x01, 0x40, 0x9A, 0x0B, 0x01, 0x40, 0x10, 0xBA, 0x09, 0x30, 0x2A, 0x0D,
  0x70, 0x10, 0xEA, 0x02, 0x20, 0x8A, 0x06, 0x71, 0x07, 0xA0, 0x72, 0x0C, 0xA0, 0x17, 0x10, 0x2A,
  0x0B, 0x2A, 0x0D, 0x73, 0x83, 0xEF, 0xE0, 0x1A, 0x0B, 0x73, 0x0B, 0xA0, 0x10, 0x2A, 0x0A, 0x73,
  0x0B, 0xA0, 0x20, 0x3A, 0x0A, 0x73, 0x0A, 0xA0, 0x02, 0xA0, 0xB7, 0x30, 0xBA, 0x00, 0x1A, 0x0C,
  0x73, 0x0C, 0xA2, 0x81, 0xEF, 0xD7, 0x38, 0x1D, 0xFE, 0x20, 0xBA, 0x01, 0x71, 0x01, 0xA0, 0xB2,
  0x07, 0xA0, 0x57, 0x10, 0x5A, 0x07, 0x20, 0x2A, 0x09, 0x71, 0x09, 0xA0, 0x13, 0x81, 0xAF, 0xE7,
  0x18, 0x1E, 0xFA, 0x40, 0x2A, 0x08, 0x60, 0x8A, 0x02, 0x50, 0x6A, 0x03, 0x40, 0x3A, 0x06, 0x38,
  0x00, 0x58, 0x2C, 0xFE, 0x22, 0x82, 0x2E, 0xFC, 0x80, 0x05, 0xF0, 0x82, 0x08, 0xFF, 0x08, 0x20,
  0x8F,
  // "μ" (U+03BC)
  0x81, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE,
  0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF,
  0xEB, 0xFE, 0x68, 0x4A, 0xFE, 0xBF, 0xE6, 0x84, 0xAF, 0xEB, 0xFE, 0x68, 0x4B, 0xFE, 0xBF, 0xE6,
  0x84, 0xBF, 0xEB, 0xFE, 0x68, 0x2D, 0xFE, 0xBA, 0x6A, 0x0E, 0x0B, 0xA0, 0x24, 0x05, 0xA0, 0xE0,
  0xBA, 0x08, 0x40, 0xCA, 0x0E, 0x0B, 0xB8, 0x91, 0x95, 0x7D, 0xFB, 0xFE, 0xBF, 0xED, 0x8A, 0x18,
  0x5F, 0xEB, 0xFD, 0x4C, 0xFD, 0x60, 0x3F, 0xEB, 0xFD, 0x72, 0x81, 0xBF, 0xE7, 0x28, 0x1B, 0xFE,
  0x72, 0x81, 0xBF, 0xE7, 0x28, 0x1B, 0xFE, 0x72, 0x81, 0xBF, 0xE7, 0x28, 0x1B, 0xFE, 0x72, 0x81,
  0xBF, 0xE7, 0x20,
  // "π" (U+03C0)
  0x01, 0x09, 0xFF, 0x06, 0x0B, 0xFF, 0x98, 0x26, 0x45, 0x5A, 0x84, 0xC5, 0x55, 0x56, 0xA8, 0x2B,
  0x55, 0x23, 0xA0, 0xA4, 0x01, 0xA0, 0x96, 0xA0, 0xA4, 0x01, 0xA0, 0x96, 0xA0, 0xA4, 0x01, 0xA0,
  0x96, 0xA0, 0xA4, 0x01, 0xA0, 0x96, 0xA0, 0xA4, 0x01, 0xA0, 0x96, 0xA0, 0xA4, 0x01, 0xA0, 0x96,
  0xA0, 0xA4, 0x01, 0xA0, 0x96, 0xA0, 0xA4, 0x01, 0xA0, 0x96, 0xA0, 0xA4, 0x01, 0xA0, 0x96, 0xA0,
  0xA4, 0x01, 0xA0, 0x96, 0xA0, 0xA5, 0xA0, 0x96, 0xA0, 0xA5, 0xA0, 0xB6, 0xA0, 0xA5, 0x0D, 0xA8,
  0x17, 0x61, 0x3A, 0x0A, 0x50, 0x7C, 0x01, 0x3A, 0x0A, 0x68, 0x38, 0xEF, 0xE1,
  // "–" (U+2013)
  0x04, 0x80, 0x90, 0x50, 0x40, 0xCF, 0xD0, 0x0C, 0xFD, 0x0C,
  // "—" (U+2014)
  0x04, 0x80, 0xB0, 0x50, 0x40, 0xCF, 0xFF, 0xF0, 0x0C, 0xFF, 0xFF, 0x0C,
  // "€" (U+20AC)
  0x68, 0x62, 0x9D, 0xFE, 0xC9, 0x36, 0x04, 0x0E, 0xF0, 0x44, 0x03, 0xB8, 0x49, 0x66, 0x9E, 0xC5,
  0x0D, 0xA0, 0x35, 0x02, 0x40, 0x5A, 0x07, 0x74, 0x0B, 0xA0, 0x17, 0x48, 0x1E, 0xFB, 0x72, 0x81,
  0x25, 0x6A, 0x0B, 0x80, 0x15, 0x01, 0x30, 0x7F, 0xB0, 0x43, 0x07, 0xFB, 0x04, 0x50, 0x5A, 0x06,
  0x74, 0x05, 0xA0, 0x57, 0x40, 0x5A, 0x06, 0x72, 0x07, 0xFA, 0x08, 0x40, 0x7F, 0xA0, 0x84, 0x81,
  0x25, 0x6A, 0x84, 0xB5, 0x55, 0x53, 0x78, 0x1E, 0xFB, 0x75, 0x0A, 0xA0, 0x17, 0x40, 0x5A, 0x07,
  0x75, 0x0D, 0xA0, 0x45, 0x01, 0x50, 0x4B, 0x83, 0xA6, 0x67, 0xB9, 0x60, 0x5F, 0x97, 0x86, 0x29,
  0xDE, 0xED, 0xA5, 0x10,
  // "₿" (U+20BF)
  0x28, 0x51, 0xFA, 0x07, 0xF3, 0x68, 0x51, 0xFA, 0x07, 0xF3, 0x68, 0x51, 0xFA, 0x07, 0xF3, 0x68,
  0x51, 0xFA, 0x07, 0xF3, 0x40, 0x6F, 0x08, 0x40, 0x6F, 0x90, 0xE0, 0x22, 0x06, 0xA8, 0x38, 0x56,
  0x8E, 0xA0, 0xD2, 0x06, 0xA0, 0x44, 0x0D, 0xA8, 0x14, 0x06, 0xA0, 0x44, 0x06, 0xA8, 0x17, 0x06,
  0xA0, 0x44, 0x03, 0xA8, 0x19, 0x06, 0xA0, 0x44, 0x04, 0xA8, 0x18, 0x06, 0xA0, 0x44, 0x06, 0xA8,
  0x15, 0x06, 0xA0, 0x44, 0x0D, 0xA8, 0x11, 0x06, 0xA8, 0x38, 0x55, 0x7C, 0xA0, 0x62, 0x06, 0xF0,
  0xD0, 0x33, 0x06, 0xF9, 0x0C, 0x03, 0x20, 0x6A, 0x04, 0x28, 0x61, 0x6E, 0xFE, 0x20, 0x6A, 0x04,
  0x40, 0x6A, 0x81, 0xA0, 0x6A, 0x04, 0x58, 0x3E, 0xFE, 0x06, 0xA0, 0x45, 0x0C, 0xA0, 0x10, 0x6A,
  0x04, 0x50, 0xCA, 0x01, 0x06, 0xA0, 0x45, 0x0D, 0xA0, 0x10, 0x6A, 0x04, 0x40, 0x2A, 0x81, 0xD0,
  0x6A, 0x04, 0x40, 0x9A, 0x81, 0x90, 0x6A, 0x83, 0x85, 0x56, 0xBA, 0x82, 0xE2, 0x06, 0xFA, 0x05,
  0x20, 0x6F, 0x0A, 0x02, 0x58, 0x51, 0xFA, 0x07, 0xF3, 0x68, 0x51, 0xFA, 0x07, 0xF3, 0x68, 0x51,
  0xFA, 0x06, 0xF3, 0x40,
  // "‘" (U+2018)
  0x38, 0x1E, 0xF2, 0x28, 0x14, 0xFE, 0x38, 0x1A, 0xFA, 0x20, 0x1A, 0x07, 0x20, 0x6A, 0x04, 0x20,
  0xAA, 0x01, 0x28, 0x1E, 0xFE, 0x20, 0x3A, 0x0C, 0x20,
  // "’" (U+2019)
  0x20, 0xDA, 0x01, 0x2A, 0x0D, 0x20, 0x2A, 0x09, 0x20, 0x5A, 0x04, 0x28, 0x18, 0xFE, 0x38, 0x1B,
  0xF9, 0x38, 0x1E, 0xF3, 0x28, 0x13, 0xFD, 0x30,
  // "‚" (U+201A)
  0x20, 0xDA, 0x01, 0x2A, 0x0D, 0x20, 0x2A, 0x09, 0x20, 0x5A, 0x04, 0x28, 0x18, 0xFE, 0x38, 0x1B,
  0xF9, 0x38, 0x1E, 0xF3, 0x28, 0x13, 0xFD, 0x30,
  // "‛" (U+201B)
  0x03, 0xA0, 0xD3, 0x81, 0xEF, 0xE3, 0x0A, 0xA0, 0x12, 0x06, 0xA0, 0x42, 0x01, 0xA0, 0x73, 0x81,
  0xAF, 0xA3, 0x81, 0x4F, 0xE4, 0x81, 0xEF, 0x20,
  // "“" (U+201C)
  0x38, 0x1E, 0xF1, 0x28, 0x17, 0xF9, 0x28, 0x15, 0xFD, 0x38, 0x1D, 0xF5, 0x28, 0x1B, 0xFA, 0x20,
  0x3A, 0x81, 0x20, 0x1A, 0x07, 0x28, 0x19, 0xFE, 0x20, 0x6A, 0x03, 0x28, 0x1E, 0xFB, 0x20, 0xAA,
  0x81, 0x10, 0x3A, 0x09, 0x28, 0x1E, 0xFE, 0x20, 0x7A, 0x81, 0x70, 0x3A, 0x0C, 0x20, 0xBA, 0x05,
  0x10,
  // "”" (U+201D)
  0x20, 0xEA, 0x81, 0x10, 0x6A, 0x09, 0x2A, 0x0D, 0x20, 0x8A, 0x81, 0x50, 0x3A, 0x09, 0x20, 0xBA,
  0x81, 0x10, 0x5A, 0x04, 0x28, 0x1D, 0xFC, 0x28, 0x18, 0xFE, 0x20, 0x1A, 0x07, 0x28, 0x1B, 0xF9,
  0x20, 0x4A, 0x01, 0x28, 0x1E, 0xF3, 0x28, 0x18, 0xFB, 0x28, 0x13, 0xFD, 0x38, 0x1B, 0xF5, 0x20,
  // "„" (U+201E)
  0x20, 0xEA, 0x81, 0x10, 0x6A, 0x09, 0x2A, 0x0D, 0x20, 0x8A, 0x81, 0x50, 0x3A, 0x09, 0x20, 0xBA,
  0x81, 0x10, 0x5A, 0x04, 0x28, 0x1D, 0xFC, 0x28, 0x18, 0xFE, 0x20, 0x1A, 0x07, 0x28, 0x1B, 0xF9,
  0x20, 0x4A, 0x01, 0x28, 0x1E, 0xF3, 0x28, 0x18, 0xFB, 0x28, 0x13, 0xFD, 0x38, 0x1B, 0xF5, 0x20,
  // "‟" (U+201F)
  0x03, 0xA0, 0xC2, 0x0B, 0xA0, 0x42, 0x81, 0xEF, 0xE2, 0x07, 0xA0, 0x62, 0x0A, 0xA8, 0x11, 0x03,
  0xA0, 0x82, 0x06, 0xA0, 0x32, 0x81, 0xEF, 0xB2, 0x01, 0xA0, 0x72, 0x81, 0x9F, 0xE3, 0x81, 0xAF,
  0xA2, 0x03, 0xA0, 0x22, 0x81, 0x4F, 0xD3, 0x81, 0xDF, 0x63, 0x81, 0xEF, 0x12, 0x81, 0x7F, 0x90,
  // "†" (U+2020)
  0x5A, 0x0E, 0x73, 0x81, 0xDF, 0xC7, 0x38, 0x1C, 0xFB, 0x73, 0x81, 0xAF, 0x97, 0x38, 0x19, 0xF8,
  0x73, 0x81, 0x8F, 0x65, 0x89, 0x41, 0x86, 0x53, 0x8F, 0x74, 0x56, 0x81, 0x2F, 0xC8, 0x94, 0x22,
  0xEC, 0xBA, 0xBF, 0xBA, 0xBC, 0xE2, 0x58, 0x16, 0xF5, 0x73, 0x81, 0x7F, 0x67, 0x38, 0x18, 0xF6,
  0x73, 0x81, 0x8F, 0x77, 0x38, 0x19, 0xF7, 0x73, 0x81, 0x9F, 0x87, 0x38, 0x1A, 0xF9, 0x73, 0x81,
  0xAF, 0x97, 0x38, 0x1B, 0xFA, 0x73, 0x81, 0xCF, 0xA7, 0x38, 0x1C, 0xFB, 0x73, 0x81, 0xDF, 0xC7,
  0x38, 0x1D, 0xFC, 0x73, 0x81, 0xEF, 0xD7, 0x38, 0x1E, 0xFD, 0x73, 0xA0, 0xE5,
  // "‡" (U+2021)
  0x5A, 0x0D, 0x73, 0x81, 0xDF, 0xB7, 0x38, 0x1B, 0xFA, 0x73, 0x81, 0xAF, 0x87, 0x38, 0x18, 0xF7,
  0x68, 0x93, 0x32, 0x10, 0x7F, 0x50, 0x12, 0x31, 0x3C, 0x81, 0xEF, 0xEC, 0x00, 0x3F, 0xC0, 0x35,
  0x81, 0x7F, 0x57, 0x38, 0x18, 0xF7, 0x73, 0x81, 0xAF, 0x87, 0x38, 0x1B, 0xFA, 0x73, 0x81, 0xCF,
  0xB7, 0x38, 0x1B, 0xFA, 0x73, 0x81, 0xAF, 0x87, 0x38, 0x18, 0xF7, 0x73, 0x81, 0x7F, 0x55, 0x03,
  0xFC, 0x00, 0x3F, 0xC8, 0x94, 0x31, 0x43, 0x21, 0x7F, 0x51, 0x23, 0x51, 0x58, 0x18, 0xF7, 0x73,
  0x81, 0xAF, 0x87, 0x38, 0x1B, 0xFA, 0x73, 0x81, 0xDF, 0xB7, 0x3A, 0x0D, 0x50,
  // "•" (U+2022)
  0x18, 0x72, 0xAE, 0xEB, 0x30, 0x1E, 0xC8, 0x1E, 0x27, 0xE0, 0x80, 0xAE, 0x0C, 0x0B, 0xE0, 0xD0,
  0xAE, 0x0C, 0x06, 0xE8, 0x18, 0x1D, 0xC8, 0x7E, 0x10, 0x2A, 0xEE, 0xB2, 0x10,
  // "…" (U+2026)
  0x82, 0x6E, 0xD2, 0x48, 0x26, 0xED, 0x23, 0x83, 0x6E, 0xD2, 0xEA, 0x08, 0x40, 0xEA, 0x08, 0x30,
  0xEA, 0x08, 0x0E, 0xA0, 0x84, 0x0E, 0xA0, 0x83, 0x0E, 0xA8, 0x38, 0x6E, 0xD2, 0x48, 0x26, 0xED,
  0x23, 0x82, 0x6E, 0xD2,
  // "‰" (U+2030)
  0x28, 0x36, 0xDF, 0xC3, 0x68, 0x12, 0xFE, 0x77, 0x10, 0x6D, 0x02, 0x58, 0x19, 0xF9, 0x77, 0x18,
  0x5E, 0xFB, 0x6D, 0xFA, 0x58, 0x1E, 0xF3, 0x77, 0x81, 0x3F, 0xE2, 0x04, 0xA4, 0x81, 0x6F, 0xC7,
  0x71, 0x81, 0x6F, 0xB3, 0xA0, 0x33, 0x81, 0xCF, 0x57, 0x71, 0x81, 0x8F, 0x93, 0x81, 0xDF, 0x52,
  0x81, 0x3F, 0xE7, 0x72, 0x81, 0x9F, 0x93, 0x81, 0xCF, 0x62, 0x81, 0xAF, 0x87, 0x72, 0x81, 0x9F,
  0x93, 0x83, 0xCF, 0x60, 0x1A, 0x02, 0x77, 0x28, 0x18, 0xF9, 0x38, 0x93, 0xDF, 0x50, 0x7F, 0xB0,
  0x5D, 0xFC, 0x34, 0x83, 0x1A, 0xEE, 0x82, 0x81, 0x6F, 0xB3, 0xA8, 0x43, 0x0D, 0xF5, 0x4C, 0x0E,
  0x02, 0x30, 0xCC, 0x83, 0x90, 0x3F, 0xE2, 0x04, 0xA1, 0x89, 0x14, 0xFE, 0x0C, 0xF8, 0x0A, 0xFA,
  0x28, 0x35, 0xFD, 0x14, 0xA8, 0x94, 0x20, 0xDF, 0xB6, 0xDF, 0xA0, 0xAF, 0x72, 0xA2, 0x02, 0xA2,
  0x81, 0xAF, 0x72, 0x83, 0xAF, 0x70, 0x5D, 0x02, 0x01, 0xA8, 0x21, 0x5F, 0xC3, 0x85, 0xEF, 0x30,
  0xDF, 0x42, 0x81, 0x7F, 0xB2, 0x89, 0x36, 0xDF, 0xC3, 0x08, 0xFA, 0x07, 0xFA, 0x38, 0x1C, 0xF6,
  0x1A, 0x02, 0x28, 0x15, 0xFD, 0x71, 0x85, 0xEF, 0x40, 0x8F, 0xA3, 0x81, 0xBF, 0x71, 0xA0, 0x22,
  0x81, 0x4F, 0xE7, 0x81, 0x5F, 0xD2, 0x81, 0x8F, 0xA3, 0x82, 0xBF, 0x71, 0xA0, 0x22, 0x81, 0x4F,
  0xE7, 0x81, 0xBF, 0x72, 0x81, 0x8F, 0xA3, 0x81, 0xBF, 0x71, 0xA0, 0x22, 0x81, 0x4F, 0xE6, 0x02,
  0xA0, 0x12, 0x81, 0x7F, 0xB3, 0x81, 0xDF, 0x61, 0xA0, 0x32, 0x81, 0x5F, 0xD6, 0x81, 0x8F, 0xA3,
  0x81, 0x4F, 0xD3, 0xA8, 0x33, 0x0D, 0xF5, 0x28, 0x18, 0xFB, 0x68, 0x1E, 0xF3, 0x30, 0x1A, 0x81,
  0x20, 0x4A, 0x28, 0x19, 0xF9, 0x28, 0x1C, 0xF7, 0x58, 0x15, 0xFC, 0x58, 0x5B, 0xFC, 0x6D, 0xFA,
  0x20, 0x4A, 0x07, 0x09, 0xA0, 0x25, 0x81, 0xCF, 0x65, 0x03, 0xD0, 0x23, 0x0B, 0xC0, 0x95, 0x81,
  0x3F, 0xE7, 0x83, 0x4C, 0xFC, 0x34, 0x83, 0x1A, 0xEE, 0x82,
  // "‹" (U+2039)
  0x48, 0x15, 0xA2, 0x38, 0x22, 0xEF, 0x83, 0x81, 0xCF, 0xD3, 0x0A, 0xA0, 0x32, 0x06, 0xA0, 0x82,
  0x03, 0xA0, 0xC3, 0x0C, 0xA0, 0x53, 0x04, 0xA0, 0xC4, 0x07, 0xA0, 0x74, 0x0B, 0xA0, 0x33, 0x82,
  0x1D, 0xFC, 0x40, 0x3A, 0x08, 0x48, 0x16, 0xB3,
  // "›" (U+203A)
  0x81, 0x2A, 0x54, 0x07, 0xA0, 0x34, 0x82, 0xCF, 0xD1, 0x30, 0x3A, 0x0A, 0x40, 0x7A, 0x07, 0x40,
  0xCA, 0x04, 0x30, 0x4A, 0x0D, 0x30, 0xCA, 0x05, 0x20, 0x7A, 0x08, 0x20, 0x2A, 0x0C, 0x38, 0x2C,
  0xFE, 0x12, 0x07, 0xA0, 0x43, 0x81, 0x2B, 0x74,
  // "⁄" (U+2044)
  0x75, 0x81, 0x4F, 0xE7, 0x58, 0x1C, 0xF6, 0x74, 0x81, 0x5F, 0xD7, 0x58, 0x1D, 0xF5, 0x74, 0x81,
  0x7F, 0xC7, 0x48, 0x21, 0xEF, 0x47, 0x48, 0x18, 0xFB, 0x74, 0x82, 0x1E, 0xF3, 0x74, 0x81, 0x9F,
  0xA7, 0x40, 0x2A, 0x02, 0x74, 0x81, 0xAF, 0x97, 0x48, 0x23, 0xFE, 0x17, 0x48, 0x1B, 0xF8, 0x74,
  0x81, 0x4F, 0xE7, 0x58, 0x1C, 0xF6, 0x74, 0x81, 0x5F, 0xD7, 0x58, 0x1D, 0xF5, 0x74, 0x81, 0x7F,
  0xC7, 0x58, 0x1E, 0xF4, 0x74, 0x81, 0x8F, 0xB7, 0x48, 0x21, 0xEF, 0x37, 0x48, 0x19, 0xFA, 0x74,
  0x02, 0xA0, 0x27, 0x40,
  // "™" (U+2122)
  0x07, 0x80, 0x3D, 0x18, 0x1C, 0xD9, 0x58, 0x2C, 0xD7, 0x8F, 0x1A, 0x0E, 0x40, 0x4A, 0x09, 0x38,
  0x19, 0xF1, 0x3B, 0x04, 0x30, 0x9A, 0x09, 0x38, 0x19, 0xF1, 0x39, 0x81, 0xBF, 0x93, 0x82, 0xDB,
  0xF9, 0x38, 0x19, 0xF1, 0x39, 0x81, 0x9C, 0xE2, 0x83, 0x3F, 0x6F, 0x93, 0x81, 0x9F, 0x13, 0x98,
  0x90, 0xA7, 0xF3, 0x08, 0xE2, 0xF9, 0x38, 0x19, 0xF1, 0x39, 0x89, 0x0A, 0x2F, 0x80, 0xD9, 0x1F,
  0x93, 0x81, 0x9F, 0x13, 0x98, 0x90, 0xA0, 0xCD, 0x2F, 0x41, 0xF9, 0x38, 0x19, 0xF1, 0x39, 0x89,
  0x0A, 0x07, 0xF9, 0xE0, 0x1F, 0x93, 0x81, 0x9F, 0x13, 0x98, 0x1A, 0x02, 0xA8, 0x39, 0x01, 0xF9,
  0x38, 0x19, 0xF1, 0x39, 0x0A, 0x28, 0x5C, 0xF3, 0x01, 0xF9, 0x30, 0x40, 0x74, 0x07, 0x04, 0x20,
  0x40, 0x73, 0x07, 0x04,
  // "⅒" (U+2152)
  0x30, 0x6A, 0x02, 0x71, 0x81, 0x4F, 0xE7, 0x70, 0x9B, 0x02, 0x71, 0x81, 0xCF, 0x67, 0x58, 0x51,
  0xCF, 0xDE, 0xF2, 0x78, 0x15, 0xFD, 0x76, 0x85, 0x8F, 0xB1, 0xEF, 0x27, 0x81, 0xDF, 0x57, 0x70,
  0x62, 0x81, 0xEF, 0x26, 0x81, 0x7F, 0xC7, 0x74, 0xA0, 0x25, 0x82, 0x1E, 0xF4, 0x77, 0x4A, 0x02,
  0x58, 0x18, 0xFB, 0x77, 0x5A, 0x02, 0x48, 0x21, 0xEF, 0x37, 0x75, 0xA0, 0x24, 0x81, 0x9F, 0xA7,
  0x76, 0xA0, 0x23, 0x02, 0xA8, 0x12, 0x06, 0xA0, 0x23, 0x84, 0x1A, 0xEE, 0xB3, 0x6A, 0x02, 0x38,
  0x3A, 0xF9, 0x09, 0xB0, 0x22, 0x01, 0x0D, 0xA0, 0xEA, 0x03, 0x5A, 0x02, 0x28, 0x90, 0x3F, 0xE3,
  0xCF, 0xDE, 0xF2, 0x28, 0x67, 0xFD, 0x10, 0x9F, 0xC5, 0xA0, 0x22, 0x89, 0x0B, 0xF8, 0x8F, 0xB1,
  0xEF, 0x22, 0x81, 0xDF, 0x52, 0x01, 0xA0, 0x24, 0xA8, 0x32, 0x04, 0xFE, 0x20, 0x62, 0x81, 0xEF,
  0x22, 0xA0, 0x23, 0x81, 0xCF, 0x67, 0x18, 0x1C, 0xF6, 0x5A, 0x81, 0x20, 0x2A, 0x48, 0x1A, 0xF8,
  0x78, 0x15, 0xFD, 0x6A, 0x81, 0x20, 0x3A, 0x48, 0x19, 0xF9, 0x78, 0x1D, 0xF5, 0x6A, 0x81, 0x20,
  0x3A, 0x48, 0x19, 0xF9, 0x68, 0x17, 0xFC, 0x7A, 0x81, 0x20, 0x2A, 0x48, 0x1A, 0xF8, 0x68, 0x1E,
  0xF4, 0x7A, 0x02, 0x2A, 0x02, 0x38, 0x1C, 0xF6, 0x58, 0x18, 0xFB, 0x71, 0xA0, 0x22, 0x81, 0xCF,
  0x62, 0x01, 0xA0, 0x34, 0x82, 0x1E, 0xF3, 0x71, 0xA0, 0x22, 0x86, 0x6F, 0xD1, 0x09, 0xFD, 0x58,
  0x19, 0xFA, 0x72, 0xA0, 0x23, 0x0C, 0xA0, 0xEA, 0x04, 0x40, 0x2A, 0x02, 0x72, 0xA0, 0x23, 0x84,
  0x19, 0xEE, 0xC4, 0x20,
  // "ﬁ" (U+FB01)
  0x58, 0x21, 0x44, 0x27, 0x30, 0x8C, 0x83, 0xB0, 0x6E, 0xA4, 0x06, 0xD8, 0x17, 0x0D, 0xA0, 0x13,
  0x87, 0xDF, 0xE4, 0x03, 0x10, 0xDA, 0x01, 0x20, 0x1A, 0x09, 0x58, 0x16, 0xE9, 0x30, 0x3A, 0x06,
  0x74, 0x04, 0xA0, 0x57, 0x40, 0x5A, 0x05, 0x72, 0x81, 0x28, 0xED, 0x09, 0x28, 0x3B, 0xFE, 0x09,
  0xF0, 0x92, 0x85, 0xBF, 0xE0, 0x35, 0x8A, 0x82, 0x95, 0x53, 0x28, 0x1B, 0xFE, 0x30, 0x4A, 0x05,
  0x58, 0x1B, 0xFE, 0x30, 0x4A, 0x05, 0x58, 0x1B, 0xFE, 0x30, 0x4A, 0x05, 0x58, 0x1B, 0xFE, 0x30,
  0x4A, 0x05, 0x58, 0x1B, 0xFE, 0x30, 0x4A, 0x05, 0x58, 0x1B, 0xFE, 0x30, 0x4A, 0x05, 0x58, 0x1B,
  0xFE, 0x30, 0x4A, 0x05, 0x58, 0x1B, 0xFE, 0x30, 0x4A, 0x05, 0x58, 0x1B, 0xFE, 0x30, 0x4A, 0x05,
  0x58, 0x1B, 0xFE, 0x30, 0x4A, 0x05, 0x58, 0x1B, 0xFE, 0x30, 0x4A, 0x05, 0x58, 0x1B, 0xFE, 0x30,
  0x4A, 0x05, 0x58, 0x1B, 0xFE, 0x30, 0x4A, 0x05, 0x58, 0x1B, 0xFE, 0x30, 0x4A, 0x05, 0x58, 0x1B,
  0xFE, 0x30, 0x4A, 0x05, 0x58, 0x1B, 0xFE, 0x10,
  // "ﬂ" (U+FB02)
  0x58, 0x21, 0x44, 0x27, 0x20, 0x8C, 0x83, 0xB0, 0xBF, 0xE3, 0x06, 0xD8, 0x37, 0x0B, 0xFE, 0x38,
  0x91, 0xDF, 0xE4, 0x03, 0x10, 0xBF, 0xE2, 0x01, 0xA0, 0x95, 0x81, 0xBF, 0xE2, 0x03, 0xA0, 0x65,
  0x81, 0xBF, 0xE2, 0x04, 0xA0, 0x55, 0x81, 0xBF, 0xE2, 0x05, 0xA0, 0x55, 0x84, 0xBF, 0xE2, 0x8E,
  0xD0, 0x92, 0x82, 0xBF, 0xE9, 0xF0, 0x92, 0x84, 0xBF, 0xE3, 0x58, 0xA8, 0x29, 0x55, 0x32, 0x81,
  0xBF, 0xE2, 0x04, 0xA0, 0x55, 0x81, 0xBF, 0xE2, 0x04, 0xA0, 0x55, 0x81, 0xBF, 0xE2, 0x04, 0xA0,
  0x55, 0x81, 0xBF, 0xE2, 0x04, 0xA0, 0x55, 0x81, 0xBF, 0xE2, 0x04, 0xA0, 0x55, 0x81, 0xBF, 0xE2,
  0x04, 0xA0, 0x55, 0x81, 0xBF, 0xE2, 0x04, 0xA0, 0x55, 0x81, 0xBF, 0xE2, 0x04, 0xA0, 0x55, 0x81,
  0xBF, 0xE2, 0x04, 0xA0, 0x55, 0x81, 0xBF, 0xE2, 0x04, 0xA0, 0x55, 0x81, 0xBF, 0xE2, 0x04, 0xA0,
  0x55, 0x81, 0xBF, 0xE2, 0x04, 0xA0, 0x55, 0x81, 0xBF, 0xE2, 0x04, 0xA0, 0x55, 0x81, 0xBF, 0xE2,
  0x04, 0xA0, 0x55, 0x81, 0xBF, 0xE2, 0x04, 0xA0, 0x55, 0x81, 0xBF, 0xE0,
};

const Font& font_NotoSans_Condensed_32() {
  static SmoothFont font(font_NotoSans_Condensed_32_data);
  return font;
}

}  // namespace roo_display
