#include "16.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-Condensed (Noto Sans Condensed)
// Generated on Thu Mar 30 23:43:37 CEST 2023
static const uint8_t font_NotoSans_Condensed_16_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x04, 0x9E,
  0xFD, 0xFC, 0x0F, 0x11, 0x0C, 0xFC, 0x06, 0x02, 0x10, 0x05, 0x04, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x01, 0x01, 0x02, 0x0C, 0x04, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x01, 0x09, 0x05, 0x0C, 0x06, 0x00, 0x0D, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x00, 0x19, // "#" (U+0023)
  0x00, 0x24, 0x00, 0xFF, 0x06, 0x0C, 0x08, 0x00, 0x49, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x0A, 0x0C, 0x0B, 0x00, 0x78, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x00, 0xBD, // "&" (U+0026)
  0x00, 0x27, 0x01, 0x09, 0x02, 0x0C, 0x03, 0x00, 0xF2, // "'" (U+0027)
  0x00, 0x28, 0x00, 0xFE, 0x03, 0x0C, 0x05, 0x00, 0xF7, // "(" (U+0028)
  0x00, 0x29, 0x00, 0xFE, 0x03, 0x0C, 0x05, 0x01, 0x19, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x07, 0x06, 0x0C, 0x07, 0x01, 0x3D, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x03, 0x06, 0x0A, 0x08, 0x01, 0x53, // "+" (U+002B)
  0x00, 0x2C, 0x00, 0xFF, 0x02, 0x02, 0x04, 0x01, 0x6A, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x04, 0x04, 0x05, 0x05, 0x01, 0x72, // "-" (U+002D)
  0x00, 0x2E, 0x01, 0x01, 0x02, 0x02, 0x04, 0x01, 0x77, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x01, 0x7A, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x01, 0x9B, // "0" (U+0030)
  0x00, 0x31, 0x01, 0x01, 0x04, 0x0C, 0x08, 0x01, 0xCB, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x01, 0xE4, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x02, 0x09, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x02, 0x30, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x02, 0x56, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x02, 0x7C, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x02, 0xA9, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x02, 0xCA, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x02, 0xF9, // "9" (U+0039)
  0x00, 0x3A, 0x01, 0x01, 0x02, 0x09, 0x04, 0x03, 0x25, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0xFF, 0x02, 0x09, 0x04, 0x03, 0x2C, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x03, 0x06, 0x0A, 0x08, 0x03, 0x39, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x04, 0x06, 0x08, 0x08, 0x03, 0x51, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x03, 0x06, 0x0A, 0x08, 0x03, 0x5D, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x03, 0x75, // "?" (U+003F)
  0x00, 0x40, 0x00, 0xFF, 0x0A, 0x0C, 0x0C, 0x03, 0x97, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x03, 0xE2, // "A" (U+0041)
  0x00, 0x42, 0x01, 0x01, 0x07, 0x0C, 0x08, 0x04, 0x0F, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x04, 0x3C, // "C" (U+0043)
  0x00, 0x44, 0x01, 0x01, 0x08, 0x0C, 0x09, 0x04, 0x63, // "D" (U+0044)
  0x00, 0x45, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x04, 0x95, // "E" (U+0045)
  0x00, 0x46, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x04, 0xB4, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x08, 0x0C, 0x0A, 0x04, 0xD2, // "G" (U+0047)
  0x00, 0x48, 0x01, 0x01, 0x08, 0x0C, 0x0A, 0x05, 0x04, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x04, 0x0C, 0x05, 0x05, 0x34, // "I" (U+0049)
  0x00, 0x4A, 0xFF, 0xFD, 0x02, 0x0C, 0x04, 0x05, 0x57, // "J" (U+004A)
  0x00, 0x4B, 0x01, 0x01, 0x07, 0x0C, 0x08, 0x05, 0x7E, // "K" (U+004B)
  0x00, 0x4C, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x05, 0xAD, // "L" (U+004C)
  0x00, 0x4D, 0x01, 0x01, 0x0B, 0x0C, 0x0C, 0x05, 0xCC, // "M" (U+004D)
  0x00, 0x4E, 0x01, 0x01, 0x08, 0x0C, 0x0A, 0x06, 0x10, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x08, 0x0C, 0x0A, 0x06, 0x44, // "O" (U+004F)
  0x00, 0x50, 0x01, 0x01, 0x07, 0x0C, 0x08, 0x06, 0x79, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFE, 0x08, 0x0C, 0x0A, 0x06, 0xA2, // "Q" (U+0051)
  0x00, 0x52, 0x01, 0x01, 0x07, 0x0C, 0x08, 0x06, 0xDF, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x07, 0x0E, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x07, 0x35, // "T" (U+0054)
  0x00, 0x55, 0x01, 0x01, 0x08, 0x0C, 0x09, 0x07, 0x5A, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x07, 0x8C, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x0C, 0x0C, 0x0D, 0x07, 0xBC, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x08, 0x0D, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x08, 0x3A, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x08, 0x63, // "Z" (U+005A)
  0x00, 0x5B, 0x01, 0xFE, 0x04, 0x0C, 0x05, 0x08, 0x85, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x08, 0xAA, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0xFE, 0x03, 0x0C, 0x05, 0x08, 0xCA, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x06, 0x07, 0x0C, 0x08, 0x08, 0xEF, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFE, 0x07, 0xFF, 0x07, 0x09, 0x0A, // "_" (U+005F)
  0x00, 0x60, 0x00, 0x0B, 0x03, 0x0D, 0x04, 0x09, 0x0E, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x06, 0x09, 0x07, 0x09, 0x16, // "a" (U+0061)
  0x00, 0x62, 0x01, 0x01, 0x07, 0x0C, 0x08, 0x09, 0x37, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x05, 0x09, 0x06, 0x09, 0x61, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x09, 0x7C, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x06, 0x09, 0x07, 0x09, 0xA6, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x04, 0x0C, 0x04, 0x09, 0xC7, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFD, 0x06, 0x09, 0x08, 0x09, 0xE3, // "g" (U+0067)
  0x00, 0x68, 0x01, 0x01, 0x06, 0x0C, 0x08, 0x0A, 0x14, // "h" (U+0068)
  0x00, 0x69, 0x01, 0x01, 0x02, 0x0C, 0x04, 0x0A, 0x3B, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xFD, 0x02, 0x0C, 0x04, 0x0A, 0x49, // "j" (U+006A)
  0x00, 0x6B, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x0A, 0x6E, // "k" (U+006B)
  0x00, 0x6C, 0x01, 0x01, 0x02, 0x0C, 0x04, 0x0A, 0x94, // "l" (U+006C)
  0x00, 0x6D, 0x01, 0x01, 0x0A, 0x09, 0x0C, 0x0A, 0xA2, // "m" (U+006D)
  0x00, 0x6E, 0x01, 0x01, 0x06, 0x09, 0x08, 0x0A, 0xD7, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x07, 0x09, 0x08, 0x0A, 0xF7, // "o" (U+006F)
  0x00, 0x70, 0x01, 0xFD, 0x07, 0x09, 0x08, 0x0B, 0x1F, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFD, 0x06, 0x09, 0x08, 0x0B, 0x4B, // "q" (U+0071)
  0x00, 0x72, 0x01, 0x01, 0x05, 0x09, 0x05, 0x0B, 0x77, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0B, 0x8E, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x0B, 0xAA, // "t" (U+0074)
  0x00, 0x75, 0x01, 0x01, 0x06, 0x09, 0x08, 0x0B, 0xC7, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x06, 0x09, 0x07, 0x0B, 0xE7, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x0A, 0x09, 0x0B, 0x0C, 0x08, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x06, 0x09, 0x07, 0x0C, 0x3F, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFD, 0x06, 0x09, 0x07, 0x0C, 0x61, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x05, 0x09, 0x06, 0x0C, 0x8E, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFE, 0x05, 0x0C, 0x06, 0x0C, 0xA7, // "{" (U+007B)
  0x00, 0x7C, 0x03, 0xFD, 0x04, 0x0C, 0x07, 0x0C, 0xD0, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0xFE, 0x05, 0x0C, 0x06, 0x0C, 0xE2, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x05, 0x06, 0x07, 0x08, 0x0D, 0x0B, // "~" (U+007E)
  0x00, 0xA1, 0x01, 0xFE, 0x02, 0x09, 0x04, 0x0D, 0x16, // "¡" (U+00A1)
  0x00, 0xA2, 0x01, 0x01, 0x06, 0x0C, 0x08, 0x0D, 0x23, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x0D, 0x45, // "£" (U+00A3)
  0x00, 0xA4, 0x01, 0x02, 0x07, 0x0A, 0x09, 0x0D, 0x6C, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x0D, 0x8C, // "¥" (U+00A5)
  0x00, 0xA6, 0x03, 0xFD, 0x04, 0x0C, 0x07, 0x0D, 0xB5, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x05, 0x0C, 0x07, 0x0D, 0xC5, // "§" (U+00A7)
  0x00, 0xA8, 0x02, 0x0B, 0x06, 0x0C, 0x09, 0x0D, 0xEB, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x00, 0x0C, 0x0C, 0x0D, 0x0D, 0xF1, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x08, 0x04, 0x0C, 0x05, 0x0E, 0x3E, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x02, 0x06, 0x08, 0x08, 0x0E, 0x4C, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x06, 0x06, 0x08, 0x0E, 0x67, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x00, 0x0C, 0x0C, 0x0D, 0x0E, 0x74, // "®" (U+00AE)
  0x00, 0xAF, 0xFF, 0x0D, 0x07, 0x0E, 0x07, 0x0E, 0xC8, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x07, 0x05, 0x0C, 0x06, 0x0E, 0xCE, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x06, 0x0A, 0x08, 0x0E, 0xE2, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x08, 0x04, 0x0E, 0x05, 0x0E, 0xFD, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x07, 0x04, 0x0D, 0x05, 0x0F, 0x12, // "³" (U+00B3)
  0x00, 0xB4, 0x00, 0x0B, 0x03, 0x0D, 0x04, 0x0F, 0x26, // "´" (U+00B4)
  0x00, 0xB5, 0x01, 0xFD, 0x06, 0x09, 0x08, 0x0F, 0x2D, // "µ" (U+00B5)
  0x00, 0xB6, 0x01, 0xFE, 0x07, 0x0C, 0x09, 0x0F, 0x56, // "¶" (U+00B6)
  0x00, 0xB7, 0x01, 0x06, 0x02, 0x07, 0x04, 0x0F, 0x8A, // "·" (U+00B7)
  0x00, 0xB8, 0x00, 0xFD, 0x02, 0x00, 0x03, 0x0F, 0x8D, // "¸" (U+00B8)
  0x00, 0xB9, 0x00, 0x08, 0x03, 0x0E, 0x05, 0x0F, 0x95, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x08, 0x04, 0x0C, 0x05, 0x0F, 0xA7, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x02, 0x06, 0x08, 0x08, 0x0F, 0xB5, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x0B, 0x0C, 0x0C, 0x0F, 0xD0, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x00, 0x0B, 0x0C, 0x0C, 0x10, 0x14, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x0B, 0x0C, 0x0C, 0x10, 0x5D, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFE, 0x05, 0x09, 0x06, 0x10, 0xA5, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x07, 0x10, 0x08, 0x10, 0xC7, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x07, 0x10, 0x08, 0x10, 0xFC, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x07, 0x10, 0x08, 0x11, 0x32, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x11, 0x69, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x11, 0xA2, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x11, 0xD6, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x0A, 0x0C, 0x0B, 0x12, 0x09, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFD, 0x07, 0x0C, 0x08, 0x12, 0x3F, // "Ç" (U+00C7)
  0x00, 0xC8, 0x01, 0x01, 0x06, 0x10, 0x07, 0x12, 0x71, // "È" (U+00C8)
  0x00, 0xC9, 0x01, 0x01, 0x06, 0x10, 0x07, 0x12, 0x99, // "É" (U+00C9)
  0x00, 0xCA, 0x01, 0x01, 0x06, 0x10, 0x07, 0x12, 0xC1, // "Ê" (U+00CA)
  0x00, 0xCB, 0x01, 0x01, 0x06, 0x0F, 0x07, 0x12, 0xEA, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x04, 0x10, 0x05, 0x13, 0x10, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x04, 0x10, 0x05, 0x13, 0x3B, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x04, 0x10, 0x05, 0x13, 0x66, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x04, 0x0F, 0x05, 0x13, 0x92, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x13, 0xBB, // "Ð" (U+00D0)
  0x00, 0xD1, 0x01, 0x01, 0x08, 0x0F, 0x0A, 0x13, 0xF3, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x08, 0x10, 0x0A, 0x14, 0x34, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x08, 0x10, 0x0A, 0x14, 0x72, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x08, 0x10, 0x0A, 0x14, 0xB0, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x08, 0x0F, 0x0A, 0x14, 0xF0, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x08, 0x0F, 0x0A, 0x15, 0x31, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x03, 0x06, 0x09, 0x08, 0x15, 0x6E, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x08, 0x0D, 0x0A, 0x15, 0x87, // "Ø" (U+00D8)
  0x00, 0xD9, 0x01, 0x01, 0x08, 0x10, 0x09, 0x15, 0xC7, // "Ù" (U+00D9)
  0x00, 0xDA, 0x01, 0x01, 0x08, 0x10, 0x09, 0x16, 0x02, // "Ú" (U+00DA)
  0x00, 0xDB, 0x01, 0x01, 0x08, 0x10, 0x09, 0x16, 0x3D, // "Û" (U+00DB)
  0x00, 0xDC, 0x01, 0x01, 0x08, 0x0F, 0x09, 0x16, 0x7A, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x06, 0x10, 0x07, 0x16, 0xB4, // "Ý" (U+00DD)
  0x00, 0xDE, 0x01, 0x01, 0x07, 0x0C, 0x08, 0x16, 0xE7, // "Þ" (U+00DE)
  0x00, 0xDF, 0x01, 0x01, 0x07, 0x0C, 0x08, 0x17, 0x10, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x06, 0x0D, 0x07, 0x17, 0x3F, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x06, 0x0D, 0x07, 0x17, 0x69, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x06, 0x0D, 0x07, 0x17, 0x93, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x17, 0xBF, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x17, 0xEB, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x06, 0x0D, 0x07, 0x18, 0x14, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x0A, 0x09, 0x0B, 0x18, 0x41, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFD, 0x05, 0x09, 0x06, 0x18, 0x74, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x06, 0x0D, 0x07, 0x18, 0x9A, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x06, 0x0D, 0x07, 0x18, 0xC3, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x06, 0x0D, 0x07, 0x18, 0xED, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x19, 0x18, // "ë" (U+00EB)
  0x00, 0xEC, 0xFF, 0x01, 0x02, 0x0D, 0x04, 0x19, 0x40, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x03, 0x0D, 0x04, 0x19, 0x5E, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x03, 0x0D, 0x04, 0x19, 0x7B, // "î" (U+00EE)
  0x00, 0xEF, 0xFF, 0x01, 0x03, 0x0C, 0x04, 0x19, 0x9B, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x19, 0xB8, // "ð" (U+00F0)
  0x00, 0xF1, 0x01, 0x01, 0x06, 0x0C, 0x08, 0x19, 0xED, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x1A, 0x17, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x1A, 0x47, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x1A, 0x78, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x1A, 0xAA, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x1A, 0xDE, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x03, 0x06, 0x0A, 0x08, 0x1B, 0x0D, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x07, 0x0A, 0x08, 0x1B, 0x1F, // "ø" (U+00F8)
  0x00, 0xF9, 0x01, 0x01, 0x06, 0x0D, 0x08, 0x1B, 0x49, // "ù" (U+00F9)
  0x00, 0xFA, 0x01, 0x01, 0x06, 0x0D, 0x08, 0x1B, 0x72, // "ú" (U+00FA)
  0x00, 0xFB, 0x01, 0x01, 0x06, 0x0D, 0x08, 0x1B, 0x9B, // "û" (U+00FB)
  0x00, 0xFC, 0x01, 0x01, 0x06, 0x0C, 0x08, 0x1B, 0xC5, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFD, 0x06, 0x0D, 0x07, 0x1B, 0xEC, // "ý" (U+00FD)
  0x00, 0xFE, 0x01, 0xFD, 0x07, 0x0C, 0x08, 0x1C, 0x22, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFD, 0x06, 0x0C, 0x07, 0x1C, 0x56, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x1C, 0x8B, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x1C, 0xBE, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x1C, 0xE6, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x1D, 0x1B, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFC, 0x07, 0x0C, 0x08, 0x1D, 0x45, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFC, 0x06, 0x09, 0x07, 0x1D, 0x7E, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x07, 0x10, 0x08, 0x1D, 0xAC, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x05, 0x0D, 0x06, 0x1D, 0xDC, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x07, 0x10, 0x08, 0x1E, 0x00, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x05, 0x0D, 0x06, 0x1E, 0x31, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x07, 0x0F, 0x08, 0x1E, 0x56, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x1E, 0x83, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x07, 0x10, 0x08, 0x1E, 0xA4, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x06, 0x0D, 0x06, 0x1E, 0xD7, // "č" (U+010D)
  0x01, 0x0E, 0x01, 0x01, 0x08, 0x10, 0x09, 0x1F, 0x00, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x09, 0x0C, 0x08, 0x1F, 0x3E, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x1F, 0x74, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x1F, 0xAC, // "đ" (U+0111)
  0x01, 0x12, 0x01, 0x01, 0x06, 0x0E, 0x07, 0x1F, 0xDC, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x20, 0x01, // "ē" (U+0113)
  0x01, 0x14, 0x01, 0x01, 0x06, 0x0F, 0x07, 0x20, 0x28, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x20, 0x50, // "ĕ" (U+0115)
  0x01, 0x16, 0x01, 0x01, 0x06, 0x0F, 0x07, 0x20, 0x79, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x20, 0x9E, // "ė" (U+0117)
  0x01, 0x18, 0x01, 0xFC, 0x06, 0x0C, 0x07, 0x20, 0xC5, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFD, 0x06, 0x09, 0x07, 0x20, 0xF1, // "ę" (U+0119)
  0x01, 0x1A, 0x01, 0x01, 0x06, 0x10, 0x07, 0x21, 0x1D, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x06, 0x0D, 0x07, 0x21, 0x47, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x08, 0x10, 0x0A, 0x21, 0x74, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFD, 0x06, 0x0D, 0x08, 0x21, 0xB0, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x08, 0x0F, 0x0A, 0x21, 0xEB, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFD, 0x06, 0x0C, 0x08, 0x22, 0x25, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x08, 0x0F, 0x0A, 0x22, 0x5E, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFD, 0x06, 0x0C, 0x08, 0x22, 0x96, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFD, 0x08, 0x0C, 0x0A, 0x22, 0xCD, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFD, 0x06, 0x0C, 0x08, 0x23, 0x07, // "ģ" (U+0123)
  0x01, 0x24, 0x01, 0x01, 0x08, 0x10, 0x0A, 0x23, 0x40, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x06, 0x11, 0x08, 0x23, 0x7B, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x23, 0xB7, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x23, 0xF4, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x04, 0x0F, 0x05, 0x24, 0x22, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0x01, 0x04, 0x0C, 0x04, 0x24, 0x50, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x04, 0x0E, 0x05, 0x24, 0x71, // "Ī" (U+012A)
  0x01, 0x2B, 0xFF, 0x01, 0x03, 0x0B, 0x04, 0x24, 0x99, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x04, 0x0F, 0x05, 0x24, 0xB6, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFF, 0x01, 0x03, 0x0C, 0x04, 0x24, 0xE1, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFC, 0x04, 0x0C, 0x05, 0x25, 0x00, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFC, 0x02, 0x0C, 0x04, 0x25, 0x2F, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x04, 0x0F, 0x05, 0x25, 0x4A, // "İ" (U+0130)
  0x01, 0x31, 0x01, 0x01, 0x02, 0x09, 0x04, 0x25, 0x73, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0xFD, 0x07, 0x0C, 0x08, 0x25, 0x7E, // "Ĳ" (U+0132)
  0x01, 0x33, 0x01, 0xFD, 0x06, 0x0C, 0x07, 0x25, 0xBF, // "ĳ" (U+0133)
  0x01, 0x34, 0xFF, 0xFD, 0x03, 0x10, 0x04, 0x25, 0xF4, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFD, 0x03, 0x0D, 0x04, 0x26, 0x25, // "ĵ" (U+0135)
  0x01, 0x36, 0x01, 0xFD, 0x07, 0x0C, 0x08, 0x26, 0x4F, // "Ķ" (U+0136)
  0x01, 0x37, 0x01, 0xFD, 0x06, 0x0C, 0x07, 0x26, 0x87, // "ķ" (U+0137)
  0x01, 0x38, 0x01, 0x01, 0x06, 0x09, 0x07, 0x26, 0xB6, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x06, 0x10, 0x07, 0x26, 0xD5, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x03, 0x11, 0x04, 0x26, 0xFE, // "ĺ" (U+013A)
  0x01, 0x3B, 0x01, 0xFD, 0x06, 0x0C, 0x07, 0x27, 0x23, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFD, 0x02, 0x0C, 0x04, 0x27, 0x4B, // "ļ" (U+013C)
  0x01, 0x3D, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x27, 0x64, // "Ľ" (U+013D)
  0x01, 0x3E, 0x01, 0x01, 0x04, 0x0C, 0x04, 0x27, 0x86, // "ľ" (U+013E)
  0x01, 0x3F, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x27, 0xA3, // "Ŀ" (U+013F)
  0x01, 0x40, 0x01, 0x01, 0x05, 0x0C, 0x04, 0x27, 0xC4, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x27, 0xE3, // "Ł" (U+0141)
  0x01, 0x42, 0xFF, 0x01, 0x03, 0x0C, 0x04, 0x28, 0x07, // "ł" (U+0142)
  0x01, 0x43, 0x01, 0x01, 0x08, 0x10, 0x0A, 0x28, 0x27, // "Ń" (U+0143)
  0x01, 0x44, 0x01, 0x01, 0x06, 0x0D, 0x08, 0x28, 0x65, // "ń" (U+0144)
  0x01, 0x45, 0x01, 0xFD, 0x08, 0x0C, 0x0A, 0x28, 0x8E, // "Ņ" (U+0145)
  0x01, 0x46, 0x01, 0xFD, 0x06, 0x09, 0x08, 0x28, 0xCB, // "ņ" (U+0146)
  0x01, 0x47, 0x01, 0x01, 0x08, 0x10, 0x0A, 0x28, 0xF3, // "Ň" (U+0147)
  0x01, 0x48, 0x01, 0x01, 0x06, 0x0D, 0x08, 0x29, 0x34, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x07, 0x0C, 0x09, 0x29, 0x5F, // "ŉ" (U+0149)
  0x01, 0x4A, 0x01, 0xFD, 0x08, 0x0C, 0x0A, 0x29, 0x91, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x01, 0xFD, 0x06, 0x09, 0x08, 0x29, 0xCF, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x08, 0x0E, 0x0A, 0x29, 0xF9, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x07, 0x0B, 0x08, 0x2A, 0x35, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x08, 0x0F, 0x0A, 0x2A, 0x63, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x2A, 0xA1, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x08, 0x10, 0x0A, 0x2A, 0xD1, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x07, 0x0D, 0x08, 0x2B, 0x13, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x0A, 0x0C, 0x0C, 0x2B, 0x47, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x0B, 0x09, 0x0C, 0x2B, 0x88, // "œ" (U+0153)
  0x01, 0x54, 0x01, 0x01, 0x07, 0x10, 0x08, 0x2B, 0xC3, // "Ŕ" (U+0154)
  0x01, 0x55, 0x01, 0x01, 0x05, 0x0D, 0x05, 0x2B, 0xFC, // "ŕ" (U+0155)
  0x01, 0x56, 0x01, 0xFD, 0x07, 0x0C, 0x08, 0x2C, 0x1B, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFD, 0x05, 0x09, 0x05, 0x2C, 0x53, // "ŗ" (U+0157)
  0x01, 0x58, 0x01, 0x01, 0x07, 0x10, 0x08, 0x2C, 0x74, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x05, 0x0D, 0x05, 0x2C, 0xAF, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x06, 0x10, 0x07, 0x2C, 0xD3, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x05, 0x0D, 0x06, 0x2D, 0x03, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x06, 0x10, 0x07, 0x2D, 0x28, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x05, 0x0D, 0x06, 0x2D, 0x59, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFD, 0x06, 0x0C, 0x07, 0x2D, 0x7F, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFD, 0x05, 0x09, 0x06, 0x2D, 0xB0, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x06, 0x10, 0x07, 0x2D, 0xD6, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x05, 0x0D, 0x06, 0x2E, 0x09, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFD, 0x06, 0x0C, 0x07, 0x2E, 0x2F, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFD, 0x04, 0x0B, 0x05, 0x2E, 0x5F, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x06, 0x10, 0x07, 0x2E, 0x87, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x06, 0x0C, 0x05, 0x2E, 0xB9, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x06, 0x0C, 0x07, 0x2E, 0xDD, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x2F, 0x02, // "ŧ" (U+0167)
  0x01, 0x68, 0x01, 0x01, 0x08, 0x0F, 0x09, 0x2F, 0x20, // "Ũ" (U+0168)
  0x01, 0x69, 0x01, 0x01, 0x06, 0x0C, 0x08, 0x2F, 0x5E, // "ũ" (U+0169)
  0x01, 0x6A, 0x01, 0x01, 0x08, 0x0E, 0x09, 0x2F, 0x88, // "Ū" (U+016A)
  0x01, 0x6B, 0x01, 0x01, 0x06, 0x0B, 0x08, 0x2F, 0xC1, // "ū" (U+016B)
  0x01, 0x6C, 0x01, 0x01, 0x08, 0x0F, 0x09, 0x2F, 0xE7, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x01, 0x01, 0x06, 0x0C, 0x08, 0x30, 0x22, // "ŭ" (U+016D)
  0x01, 0x6E, 0x01, 0x01, 0x08, 0x10, 0x09, 0x30, 0x4B, // "Ů" (U+016E)
  0x01, 0x6F, 0x01, 0x01, 0x06, 0x0D, 0x08, 0x30, 0x89, // "ů" (U+016F)
  0x01, 0x70, 0x01, 0x01, 0x08, 0x10, 0x09, 0x30, 0xB5, // "Ű" (U+0170)
  0x01, 0x71, 0x01, 0x01, 0x07, 0x0D, 0x08, 0x30, 0xF4, // "ű" (U+0171)
  0x01, 0x72, 0x01, 0xFD, 0x08, 0x0C, 0x09, 0x31, 0x25, // "Ų" (U+0172)
  0x01, 0x73, 0x01, 0xFC, 0x06, 0x09, 0x08, 0x31, 0x63, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x0C, 0x10, 0x0D, 0x31, 0x8F, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x0A, 0x0D, 0x0B, 0x31, 0xEC, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x06, 0x10, 0x07, 0x32, 0x2F, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFD, 0x06, 0x0D, 0x07, 0x32, 0x63, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x32, 0x9B, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x06, 0x10, 0x07, 0x32, 0xCC, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x05, 0x0D, 0x06, 0x32, 0xF8, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x06, 0x0F, 0x07, 0x33, 0x1B, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x05, 0x0C, 0x06, 0x33, 0x44, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x06, 0x10, 0x07, 0x33, 0x63, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x05, 0x0D, 0x06, 0x33, 0x92, // "ž" (U+017E)
  0x01, 0x7F, 0x01, 0x01, 0x04, 0x0C, 0x04, 0x33, 0xB6, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x09, 0x0C, 0x0A, 0x33, 0xD4, // "Ω" (U+03A9)
  0x03, 0xBC, 0x01, 0xFD, 0x06, 0x09, 0x08, 0x34, 0x10, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x08, 0x09, 0x09, 0x34, 0x39, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x04, 0x07, 0x05, 0x08, 0x34, 0x65, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x04, 0x0F, 0x05, 0x10, 0x34, 0x6C, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x34, 0x74, // "€" (U+20AC)
  0x20, 0xBF, 0x01, 0xFF, 0x06, 0x0E, 0x08, 0x34, 0x9E, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x09, 0x02, 0x0C, 0x03, 0x34, 0xD3, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x09, 0x02, 0x0C, 0x03, 0x34, 0xDB, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0xFF, 0x02, 0x02, 0x04, 0x34, 0xE2, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x09, 0x02, 0x0C, 0x03, 0x34, 0xE9, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x09, 0x05, 0x0C, 0x06, 0x34, 0xF1, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x09, 0x05, 0x0C, 0x06, 0x34, 0xFF, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0xFF, 0x05, 0x02, 0x06, 0x35, 0x0D, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x09, 0x05, 0x0C, 0x06, 0x35, 0x1B, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x35, 0x2A, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x35, 0x4C, // "‡" (U+2021)
  0x20, 0x22, 0x01, 0x05, 0x04, 0x08, 0x06, 0x35, 0x6E, // "•" (U+2022)
  0x20, 0x26, 0x01, 0x01, 0x0A, 0x02, 0x0B, 0x35, 0x78, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x0F, 0x0C, 0x10, 0x35, 0x85, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x02, 0x03, 0x08, 0x05, 0x35, 0xE1, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x02, 0x03, 0x08, 0x05, 0x35, 0xF2, // "›" (U+203A)
  0x20, 0x44, 0xFD, 0x01, 0x04, 0x0C, 0x02, 0x36, 0x03, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x07, 0x09, 0x0C, 0x0B, 0x36, 0x22, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x00, 0x0F, 0x0C, 0x10, 0x36, 0x42, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x36, 0x9A, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x06, 0x0C, 0x08, 0x36, 0xC9, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x01, 0x62, 0x01, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x01, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x01, // &Ŧ (U+0026 U+0166)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x2C, 0x00, 0x43, 0x01, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x01, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x01, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x01, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x01, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x01, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x01, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x01, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x01, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x01, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x01, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x01, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x01, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x01, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x01, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x01, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x01, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x01, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x01, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x01, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x01, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x01, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x01, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2E, 0x00, 0x43, 0x01, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x01, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x01, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x01, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x01, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x01, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x01, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x01, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x01, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x01, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x01, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x01, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x01, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x01, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x01, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x01, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x01, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x01, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x01, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x01, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x01, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x01, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x01, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x03, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x03, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x03, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x03, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x03, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x03, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x03, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x03, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x03, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x03, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x02, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x02, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x20, 0x1A, 0x02, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x02, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x02, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x01, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x01, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x01, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x01, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x01, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x01, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0xAB, 0x01, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x01, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x01, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x01, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x01, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x01, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x01, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x01, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x4B, 0x01, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x01, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x01, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x01, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5F, 0x01, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x69, 0x01, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x01, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x01, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x01, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x01, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x01, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x01, // T‹ (U+0054 U+2039)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0xBB, 0x00, 0x54, 0x01, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x01, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x01, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x01, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDE, 0x00, 0x2C, 0x02, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x02, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x00, 0xC6, 0x01, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDE, 0x20, 0x1A, 0x02, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x02, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x02, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x00, 0x59, 0x01, // ĽY (U+013D U+0059)
  0x01, 0x3D, 0x00, 0xDD, 0x01, // ĽÝ (U+013D U+00DD)
  0x01, 0x3D, 0x01, 0x76, 0x01, // ĽŶ (U+013D U+0176)
  0x01, 0x3D, 0x01, 0x78, 0x01, // ĽŸ (U+013D U+0178)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x00, 0x59, 0x01, // ĿY (U+013F U+0059)
  0x01, 0x3F, 0x00, 0xDD, 0x01, // ĿÝ (U+013F U+00DD)
  0x01, 0x3F, 0x01, 0x76, 0x01, // ĿŶ (U+013F U+0176)
  0x01, 0x3F, 0x01, 0x78, 0x01, // ĿŸ (U+013F U+0178)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x01, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x01, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x01, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x01, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x01, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x01, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0xAB, 0x01, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x01, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x01, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x01, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x01, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x01, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x01, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x01, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x4B, 0x01, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x01, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x01, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x01, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5F, 0x01, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x69, 0x01, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x01, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x01, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x01, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x01, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x01, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x01, // Ţ‹ (U+0162 U+2039)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x01, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x01, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x01, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x01, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x01, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x01, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0xAB, 0x01, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x01, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x01, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x01, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x01, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x01, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x01, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x01, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x4B, 0x01, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x01, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x01, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x01, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5F, 0x01, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x69, 0x01, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x01, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x01, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x01, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x01, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x01, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x01, // Ť‹ (U+0164 U+2039)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x01, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x01, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x01, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x01, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x01, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x01, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0xAB, 0x01, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x01, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x01, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x01, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x01, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x01, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x01, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x01, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x4B, 0x01, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x01, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x01, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x01, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5F, 0x01, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x69, 0x01, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x01, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x01, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x01, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x01, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x01, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x01, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x1A, 0x00, 0x43, 0x01, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x01, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x01, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x01, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x01, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x01, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x01, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x01, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x01, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x01, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x01, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x01, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x01, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x01, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x01, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x01, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x01, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x01, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x01, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x01, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x01, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x01, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x01, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1E, 0x00, 0x43, 0x01, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x01, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x01, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x01, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x01, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x01, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x01, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x01, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x01, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x01, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x01, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x01, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x01, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x01, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x01, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x01, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x01, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x01, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x01, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x01, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x01, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x01, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x01, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x01, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x01, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x01, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x01, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x03, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x03, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x03, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x03, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x03, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x03, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x03, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x03, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x03, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x03, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x89, 0x6C, 0xBC, 0xAB, 0xAA, 0x9A, 0x99, 0x89, 0x78, 0x74, 0x82, 0xCB, 0xB9,
  // """ (U+0022)
  0x98, 0x96, 0x63, 0xF3, 0xE5, 0x2F, 0x2D, 0x41, 0xF1, 0xC3, 0x19, 0x10,
  // "#" (U+0023)
  0x39, 0x10, 0x30, 0xC3, 0x83, 0x2D, 0x05, 0xA3, 0x83, 0x4B, 0x06, 0x93, 0x86, 0x69, 0x08, 0x70,
  0x3E, 0xA8, 0x92, 0xEF, 0xED, 0x01, 0xB6, 0x1D, 0x31, 0x28, 0x1D, 0x21, 0x92, 0x0A, 0xE8, 0x95,
  0x81, 0x5D, 0x27, 0xB2, 0x10, 0x4B, 0x07, 0x83, 0x83, 0x69, 0x09, 0x63, 0x83, 0x87, 0x0B, 0x42,
  // "$" (U+0024)
  0x30, 0xA0, 0x24, 0x89, 0x76, 0xDA, 0x71, 0x0B, 0xCD, 0x9B, 0x52, 0xF1, 0xA2, 0x28, 0x32, 0xF2,
  0xA2, 0x38, 0x2A, 0xED, 0x34, 0x82, 0x5D, 0xF9, 0x48, 0x2A, 0x5C, 0x93, 0x89, 0x3A, 0x26, 0xC2,
  0x51, 0xA5, 0xC9, 0x2D, 0xB0, 0xA0, 0x12, 0x81, 0x1B, 0x35, 0x0A, 0x02, 0x50, 0x40, 0x12,
  // "%" (U+0025)
  0x18, 0x16, 0xEA, 0x30, 0xA0, 0x63, 0x85, 0xE5, 0xC5, 0x01, 0xE3, 0x86, 0x3D, 0x07, 0x90, 0x79,
  0x38, 0x64, 0xC0, 0x6A, 0x0D, 0x33, 0x85, 0x3D, 0x07, 0x94, 0xD4, 0x89, 0x01, 0xE2, 0xB7, 0xA7,
  0x6E, 0xB2, 0x89, 0x08, 0xFD, 0x2E, 0x1E, 0x2B, 0x62, 0x87, 0x10, 0x6A, 0x3D, 0x06, 0xA4, 0x85,
  0xC4, 0x4D, 0x06, 0xB3, 0x86, 0x3D, 0x03, 0xD0, 0x7A, 0x30, 0x90, 0x72, 0x82, 0xE5, 0xC6, 0x30,
  0xE0, 0x12, 0x81, 0x5E, 0xB1,
  // "&" (U+0026)
  0x28, 0x29, 0xED, 0x34, 0x83, 0x5E, 0x4A, 0xC4, 0x83, 0x7C, 0x05, 0xE4, 0x83, 0x5E, 0x08, 0xB5,
  0x82, 0xDA, 0xE3, 0x58, 0x1B, 0xF7, 0x58, 0xA0, 0xAE, 0xBE, 0x11, 0xF3, 0x3F, 0x41, 0xDA, 0x5F,
  0x05, 0x92, 0x86, 0x3F, 0xDA, 0x05, 0xF1, 0x28, 0x92, 0xAF, 0x40, 0x1E, 0xA3, 0x7F, 0xDC, 0x28,
  0x64, 0xDF, 0xC4, 0x2F, 0x70,
  // "'" (U+0027)
  0x98, 0x56, 0xE5, 0xD4, 0xC3,
  // "(" (U+0028)
  0x20, 0x40, 0xD2, 0x83, 0xD6, 0x05, 0xE2, 0x0A, 0x09, 0x28, 0xA4, 0xE6, 0x01, 0xF3, 0x03, 0xF2,
  0x03, 0xF1, 0x02, 0xF2, 0x01, 0xF4, 0x20, 0xD0, 0x72, 0x08, 0x0C, 0x28, 0x12, 0xF2, 0x20, 0x90,
  0xA3, 0x07,
  // ")" (U+0029)
  0x81, 0x3E, 0x12, 0x0B, 0x09, 0x28, 0x14, 0xE1, 0x20, 0xE0, 0x62, 0x0B, 0x09, 0x20, 0x80, 0xC2,
  0x07, 0x0D, 0x20, 0x60, 0xE2, 0x07, 0x0D, 0x20, 0x90, 0xB2, 0x87, 0xC8, 0x01, 0xF3, 0x07, 0xD2,
  0x83, 0xE4, 0x02, 0x62,
  // "*" (U+002A)
  0x28, 0x11, 0xF2, 0x59, 0x01, 0x28, 0xA2, 0x4F, 0xBF, 0xBF, 0x50, 0x39, 0xFA, 0x31, 0x01, 0xE5,
  0xE2, 0x28, 0x35, 0xA0, 0x96, 0x10,
  // "+" (U+002B)
  0x30, 0xC0, 0x55, 0x0C, 0x05, 0x50, 0xC0, 0x55, 0x0C, 0x05, 0x20, 0x6D, 0x86, 0xE1, 0x22, 0xC7,
  0x22, 0x30, 0xC0, 0x55, 0x0C, 0x05, 0x20,
  // "," (U+002C)
  0x18, 0x90, 0xBB, 0x0D, 0x71, 0xF2, 0x4C, 0x10,
  // "-" (U+002D)
  0x07, 0xB0, 0x01, 0x0F, 0x21,
  // "." (U+002E)
  0x82, 0xDA, 0xC9,
  // "/" (U+002F)
  0x40, 0xA0, 0x83, 0x81, 0x1F, 0x33, 0x06, 0x0D, 0x40, 0xB0, 0x83, 0x81, 0x1F, 0x23, 0x07, 0x0C,
  0x40, 0xC0, 0x73, 0x81, 0x2F, 0x13, 0x08, 0x0B, 0x40, 0xD0, 0x63, 0x81, 0x3F, 0x13, 0x08, 0x0A,
  0x40,
  // "0" (U+0030)
  0x28, 0x29, 0xED, 0x42, 0x87, 0x8D, 0x48, 0xE1, 0x0E, 0x62, 0x83, 0xE6, 0x2F, 0x32, 0x83, 0xAA,
  0x3F, 0x12, 0x83, 0x9B, 0x4F, 0x12, 0x83, 0x8C, 0x4F, 0x12, 0x83, 0x8C, 0x3F, 0x12, 0x83, 0x9B,
  0x2F, 0x32, 0x83, 0xAA, 0x0E, 0x62, 0x87, 0xE6, 0x08, 0xD4, 0x8E, 0x12, 0x82, 0xAE, 0xD4, 0x10,
  // "1" (U+0031)
  0x28, 0x93, 0xAF, 0x0A, 0xEF, 0x9D, 0x6F, 0x31, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20,
  0x59, 0x20, 0x59, 0x20, 0x59, 0x20, 0x59, 0x20, 0x59,
  // "2" (U+0032)
  0x18, 0x93, 0x6D, 0xFC, 0x40, 0x1D, 0x63, 0x9E, 0x15, 0x90, 0x65, 0x0E, 0x07, 0x48, 0x12, 0xF4,
  0x40, 0x80, 0xD4, 0x81, 0x2F, 0x54, 0x0C, 0x0A, 0x48, 0x18, 0xD1, 0x38, 0x14, 0xF3, 0x38, 0x61,
  0xE9, 0x22, 0x22, 0x6D, 0x0B,
  // "3" (U+0033)
  0x18, 0x93, 0x7D, 0xFD, 0x50, 0x2C, 0x63, 0x8F, 0x35, 0x0E, 0x06, 0x50, 0xE0, 0x53, 0x81, 0x19,
  0xD3, 0xA0, 0xD0, 0x23, 0x83, 0x34, 0xAE, 0x25, 0x0D, 0x08, 0x50, 0xB0, 0xA5, 0x89, 0x5D, 0x84,
  0x84, 0x39, 0xF2, 0x3C, 0xEE, 0xC3, 0x10,
  // "4" (U+0034)
  0x40, 0xB9, 0x50, 0x3A, 0x50, 0xC0, 0xA9, 0x48, 0x14, 0xD5, 0x94, 0x81, 0xC5, 0x59, 0x38, 0x25,
  0xC0, 0x59, 0x38, 0x2D, 0x40, 0x59, 0x20, 0x60, 0xC2, 0x05, 0x92, 0x0B, 0xE8, 0x64, 0x22, 0x22,
  0x7F, 0x25, 0x05, 0x96, 0x05, 0x92,
  // "5" (U+0035)
  0x10, 0xAC, 0x82, 0x10, 0xB9, 0x0F, 0x22, 0x0C, 0x06, 0x50, 0xD0, 0x55, 0x0E, 0x04, 0x59, 0x82,
  0xEF, 0xD6, 0x28, 0x44, 0x43, 0x8F, 0x45, 0x0B, 0x0A, 0x50, 0x90, 0xB5, 0x89, 0x5D, 0x91, 0x84,
  0x3A, 0xF2, 0x1B, 0xEF, 0xC4, 0x10,
  // "6" (U+0036)
  0x28, 0x95, 0x2B, 0xEE, 0x20, 0x1E, 0x93, 0x41, 0x08, 0xB5, 0x0D, 0x05, 0x48, 0x97, 0x1F, 0x6D,
  0xE8, 0x02, 0xFC, 0x46, 0xF5, 0x3F, 0x52, 0x83, 0xAA, 0x3F, 0x22, 0x83, 0x8C, 0x1F, 0x42, 0x83,
  0x8C, 0x0E, 0x82, 0x87, 0xBA, 0x07, 0xE4, 0x6F, 0x42, 0x82, 0x8E, 0xE6, 0x10,
  // "7" (U+0037)
  0x06, 0xD8, 0x6E, 0x12, 0x22, 0x2A, 0xB5, 0x0E, 0x05, 0x48, 0x14, 0xF1, 0x40, 0x0A, 0x50, 0xE0,
  0x54, 0x05, 0x0E, 0x50, 0xB0, 0xA4, 0x81, 0x1F, 0x54, 0x06, 0x0E, 0x50, 0xB0, 0xA4, 0x81, 0x1F,
  0x43,
  // "8" (U+0038)
  0x18, 0x31, 0xAE, 0xD7, 0x28, 0x7B, 0xC3, 0x6F, 0x50, 0xF4, 0x28, 0x3B, 0x90, 0xF5, 0x28, 0x7C,
  0x80, 0x9D, 0x16, 0xE2, 0x28, 0x2B, 0xEE, 0x32, 0x89, 0x44, 0xE9, 0xEA, 0x01, 0xE6, 0x01, 0xD8,
  0x59, 0x38, 0x37, 0xD4, 0xF1, 0x28, 0x95, 0x8C, 0x1E, 0xA3, 0x5E, 0x70, 0x3B, 0xED, 0x81,
  // "9" (U+0039)
  0x18, 0x32, 0xBE, 0xD3, 0x28, 0x7C, 0xB3, 0x8E, 0x12, 0xF2, 0x28, 0x1D, 0x64, 0x93, 0x83, 0xAA,
  0x4F, 0x12, 0x89, 0x1B, 0xB0, 0xE8, 0x04, 0xFB, 0x05, 0xA8, 0x1B, 0xAA, 0x38, 0x22, 0x0B, 0x85,
  0x0E, 0x05, 0x48, 0x75, 0xF1, 0x03, 0x36, 0xE7, 0x28, 0x2A, 0xFD, 0x72,
  // ":" (U+003A)
  0x82, 0xC9, 0xDA, 0x73, 0x82, 0xDA, 0xB9,
  // ";" (U+003B)
  0x18, 0x3C, 0x90, 0xDA, 0x77, 0x28, 0x90, 0xBB, 0x0E, 0x71, 0xF2, 0x5B, 0x10,
  // "<" (U+003C)
  0x60, 0x24, 0x81, 0x19, 0xE2, 0x89, 0x01, 0x9E, 0x91, 0x18, 0xE9, 0x12, 0x81, 0x5F, 0x85, 0x82,
  0x3B, 0xE7, 0x58, 0x23, 0xBE, 0x75, 0x03, 0x0A,
  // "=" (U+003D)
  0x06, 0xD0, 0xE0, 0x18, 0x02, 0x27, 0x06, 0xD0, 0xE0, 0x18, 0x02, 0x20,
  // ">" (U+003E)
  0x01, 0x68, 0x16, 0xD6, 0x58, 0x25, 0xCD, 0x55, 0x82, 0x5C, 0xC4, 0x48, 0x12, 0xDE, 0x28, 0x73,
  0xAE, 0x70, 0x2B, 0xE7, 0x38, 0x15, 0x71, 0x40,
  // "?" (U+003F)
  0x89, 0x25, 0xCE, 0xD4, 0x05, 0x63, 0x9E, 0x13, 0x81, 0x1F, 0x33, 0x81, 0x2F, 0x23, 0x09, 0x0C,
  0x38, 0x15, 0xF3, 0x30, 0xE0, 0x63, 0x02, 0x0E, 0x40, 0x10, 0x77, 0x38, 0x16, 0xF2, 0x38, 0x15,
  0xD1, 0x20,
  // "@" (U+0040)
  0x38, 0x43, 0xAE, 0xEB, 0x34, 0x86, 0x4F, 0x94, 0x37, 0xE5, 0x28, 0x11, 0xE5, 0x48, 0x99, 0x54,
  0xE1, 0x08, 0xA0, 0x4D, 0xEB, 0x0B, 0x60, 0xD4, 0x0E, 0x76, 0xE0, 0x6A, 0x0F, 0x15, 0xC0, 0x3D,
  0x04, 0xB2, 0xE0, 0x7A, 0x04, 0xD0, 0x4B, 0x2E, 0x07, 0x90, 0x6C, 0x05, 0xA1, 0xF0, 0x5D, 0x1B,
  0xD1, 0xB6, 0x0E, 0x40, 0xCF, 0x98, 0xFD, 0x20, 0x80, 0xC2, 0x02, 0x20, 0x23, 0x86, 0x1D, 0xB3,
  0x01, 0x41, 0x40, 0x20, 0xBB, 0x0C, 0x02, 0x68, 0x11, 0x21, 0x40,
  // "A" (U+0041)
  0x30, 0xD0, 0xE5, 0x82, 0x2F, 0xE3, 0x48, 0x26, 0xCB, 0x74, 0x82, 0xA9, 0x7B, 0x48, 0x1E, 0x54,
  0x93, 0x84, 0x3F, 0x10, 0xF4, 0x28, 0x47, 0xD1, 0x1C, 0x92, 0x0C, 0xC0, 0xD2, 0x98, 0x77, 0x33,
  0x6F, 0x25, 0xF1, 0x39, 0x81, 0x69, 0xC4, 0x82, 0xBA, 0xD8, 0x40, 0x70, 0xE0,
  // "B" (U+0042)
  0x0B, 0xA8, 0x93, 0xEC, 0x40, 0xBB, 0x23, 0xAF, 0x2B, 0xA3, 0x98, 0x16, 0xBA, 0x39, 0x81, 0x6B,
  0xA2, 0x82, 0x7E, 0x1B, 0xB8, 0x92, 0xE4, 0x0B, 0xB2, 0x39, 0xE2, 0xBA, 0x38, 0x2C, 0x9B, 0xA3,
  0x82, 0xAB, 0xBA, 0x38, 0x90, 0xD9, 0xBB, 0x23, 0x8F, 0x3B, 0xB0, 0xC0, 0x51,
  // "C" (U+0043)
  0x28, 0x41, 0x9D, 0xEC, 0x42, 0x89, 0x0C, 0xD5, 0x37, 0x30, 0x7F, 0x25, 0x0C, 0x09, 0x69, 0x06,
  0x58, 0x11, 0xF4, 0x58, 0x11, 0xF5, 0x69, 0x06, 0x60, 0xD0, 0xA6, 0x81, 0x7F, 0x16, 0x84, 0xDD,
  0x53, 0x52, 0x28, 0x41, 0x9E, 0xFC, 0x20,
  // "D" (U+0044)
  0x0B, 0xA8, 0x1E, 0xB3, 0x28, 0x90, 0xBB, 0x24, 0xAF, 0x30, 0xBA, 0x38, 0x3B, 0xD0, 0xBA, 0x38,
  0x34, 0xF2, 0xBA, 0x38, 0x31, 0xF5, 0xBA, 0x49, 0x81, 0x6B, 0xA4, 0x98, 0x16, 0xBA, 0x38, 0x31,
  0xF5, 0xBA, 0x38, 0x35, 0xF2, 0xBA, 0x38, 0x92, 0xBC, 0x0B, 0xB2, 0x4B, 0xE3, 0x0B, 0xA8, 0x1E,
  0xB3, 0x20,
  // "E" (U+0045)
  0x0B, 0xC8, 0x76, 0xBB, 0x22, 0x21, 0xBA, 0x40, 0xB0, 0xA4, 0x0B, 0x0A, 0x40, 0xBC, 0x87, 0x2B,
  0xB2, 0x22, 0x0B, 0xA4, 0x0B, 0x0A, 0x40, 0xB0, 0xA4, 0x85, 0xBB, 0x22, 0x21, 0xBC, 0x06,
  // "F" (U+0046)
  0x0B, 0xC8, 0x76, 0xBB, 0x22, 0x21, 0xBA, 0x40, 0xB0, 0xA4, 0x0B, 0x0A, 0x40, 0xB0, 0xA4, 0x0B,
  0xC8, 0x72, 0xBB, 0x22, 0x20, 0xBA, 0x40, 0xB0, 0xA4, 0x0B, 0x0A, 0x40, 0xB0, 0xA4,
  // "G" (U+0047)
  0x38, 0x47, 0xDE, 0xDA, 0x22, 0x89, 0x1B, 0xE6, 0x35, 0xA2, 0x06, 0xF2, 0x60, 0xC0, 0xA7, 0x90,
  0x66, 0x81, 0x1F, 0x46, 0x81, 0x1F, 0x42, 0x09, 0xA8, 0x29, 0x0F, 0x62, 0x85, 0x12, 0xB9, 0x0C,
  0x94, 0x84, 0xA9, 0x07, 0xF2, 0x30, 0xA0, 0x92, 0x85, 0xCD, 0x63, 0x4C, 0x92, 0x85, 0x18, 0xDF,
  0xEB, 0x50,
  // "H" (U+0048)
  0x0B, 0x0A, 0x38, 0x31, 0xF3, 0xBA, 0x38, 0x31, 0xF3, 0xBA, 0x38, 0x31, 0xF3, 0xBA, 0x38, 0x31,
  0xF3, 0xBA, 0x38, 0x21, 0xF3, 0xBE, 0x89, 0x13, 0xBB, 0x22, 0x24, 0xF3, 0xBA, 0x38, 0x31, 0xF3,
  0xBA, 0x38, 0x31, 0xF3, 0xBA, 0x38, 0x31, 0xF3, 0xBA, 0x38, 0x31, 0xF3, 0xBA, 0x38, 0x11, 0xF3,
  // "I" (U+0049)
  0x06, 0xB8, 0x32, 0x05, 0xF2, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14,
  0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x34, 0xF1,
  0x05, 0xB0, 0x20,
  // "J" (U+004A)
  0x20, 0xB0, 0x92, 0x0B, 0x09, 0x20, 0xB0, 0x92, 0x0B, 0x09, 0x20, 0xB0, 0x92, 0x0B, 0x09, 0x20,
  0xB0, 0x92, 0x0B, 0x09, 0x20, 0xB0, 0x92, 0x0B, 0x09, 0x20, 0xB0, 0x92, 0x0B, 0x09, 0x28, 0x92,
  0xC8, 0x02, 0xF5, 0xEF, 0xB0, 0x11, 0x20,
  // "K" (U+004B)
  0x0B, 0x0A, 0x38, 0x2D, 0x8B, 0xA2, 0x89, 0x58, 0xD0, 0xBA, 0x02, 0xF4, 0x0B, 0xA0, 0xBA, 0x28,
  0x3B, 0xA6, 0xE1, 0x28, 0x2B, 0xBE, 0xA3, 0x83, 0xBF, 0xCF, 0x22, 0x83, 0xBB, 0x0D, 0xA2, 0x87,
  0xBA, 0x05, 0xF3, 0x0B, 0xA2, 0x83, 0xCB, 0x0B, 0xA2, 0x83, 0x4F, 0x3B, 0xA3, 0x0C, 0x0B,
  // "L" (U+004C)
  0x0B, 0x0A, 0x40, 0xB0, 0xA4, 0x0B, 0x0A, 0x40, 0xB0, 0xA4, 0x0B, 0x0A, 0x40, 0xB0, 0xA4, 0x0B,
  0x0A, 0x40, 0xB0, 0xA4, 0x0B, 0x0A, 0x40, 0xB0, 0xA4, 0x85, 0xBB, 0x44, 0x41, 0xBC, 0x05,
  // "M" (U+004D)
  0x81, 0xBF, 0x65, 0x84, 0xEF, 0x2B, 0xFA, 0x40, 0x4A, 0x82, 0x2B, 0xCE, 0x48, 0x69, 0xCF, 0x2B,
  0x8E, 0x43, 0x86, 0xD7, 0xF2, 0xB8, 0xA9, 0x28, 0x72, 0xF3, 0xF2, 0xB9, 0x5D, 0x28, 0xE1, 0x7B,
  0x3F, 0x2B, 0x91, 0xF2, 0x0C, 0x63, 0xF2, 0xB9, 0x0C, 0x71, 0xF1, 0x3F, 0x2B, 0x90, 0x7B, 0x5C,
  0x03, 0xF2, 0xB9, 0x02, 0xFB, 0x70, 0x3F, 0x2B, 0x92, 0x87, 0xDF, 0x30, 0x3F, 0x2B, 0x92, 0x09,
  0x0E, 0x28, 0x13, 0xF2,
  // "N" (U+004E)
  0x81, 0xBF, 0x23, 0x83, 0x8B, 0xBF, 0x93, 0x84, 0x8B, 0xBC, 0xF1, 0x28, 0x48, 0xBB, 0x8D, 0x82,
  0x8B, 0x28, 0xBB, 0x86, 0xE1, 0x08, 0xBB, 0x90, 0xE7, 0x08, 0xBB, 0x90, 0x7E, 0x08, 0xBB, 0x92,
  0x84, 0xE6, 0x8B, 0xB9, 0x28, 0x48, 0xD8, 0xBB, 0x92, 0x84, 0x1F, 0xDB, 0xB9, 0x38, 0x39, 0xFB,
  0xB9, 0x38, 0x12, 0xFB,
  // "O" (U+004F)
  0x28, 0x42, 0xBE, 0xEA, 0x12, 0x85, 0x1E, 0xB4, 0x4C, 0xD2, 0x09, 0x0D, 0x38, 0x41, 0xE6, 0x0D,
  0x84, 0x83, 0xAB, 0x1F, 0x54, 0x83, 0x7F, 0x2F, 0x44, 0x83, 0x6F, 0x1F, 0x44, 0x83, 0x6F, 0x0F,
  0x54, 0x83, 0x7E, 0x0D, 0x84, 0x83, 0xAB, 0x08, 0xD3, 0x89, 0x11, 0xE6, 0x01, 0xDB, 0x34, 0xCD,
  0x38, 0x42, 0xAE, 0xEA, 0x11,
  // "P" (U+0050)
  0x0B, 0xA8, 0x93, 0xD9, 0x10, 0xBB, 0x35, 0xDB, 0x0B, 0xA2, 0x83, 0x4F, 0x2B, 0xA2, 0x83, 0x2F,
  0x3B, 0xA2, 0x89, 0x14, 0xF2, 0xBA, 0x02, 0xCC, 0x0B, 0xB8, 0x5C, 0x20, 0xBB, 0x21, 0x30, 0xB0,
  0xA5, 0x0B, 0x0A, 0x50, 0xB0, 0xA5, 0x0B, 0x0A, 0x50,
  // "Q" (U+0051)
  0x28, 0x42, 0xBE, 0xEA, 0x12, 0x85, 0x1E, 0xB4, 0x4C, 0xD2, 0x09, 0x0D, 0x38, 0x41, 0xE7, 0x0D,
  0x84, 0x83, 0xAC, 0x1F, 0x54, 0x83, 0x7F, 0x2F, 0x44, 0x83, 0x6F, 0x1F, 0x44, 0x83, 0x6F, 0x0F,
  0x54, 0x83, 0x7E, 0x0D, 0x84, 0x83, 0xAC, 0x08, 0xD3, 0x89, 0x11, 0xE7, 0x01, 0xDB, 0x34, 0xCD,
  0x38, 0x42, 0xAE, 0xFD, 0x16, 0x81, 0x6F, 0x37, 0x0B, 0x0D, 0x78, 0x11, 0x73,
  // "R" (U+0052)
  0x0B, 0xA8, 0x93, 0xD9, 0x10, 0xBB, 0x35, 0xDB, 0x0B, 0xA2, 0x83, 0x4F, 0x2B, 0xA2, 0x83, 0x2F,
  0x3B, 0xA2, 0x89, 0x14, 0xF2, 0xBA, 0x02, 0xCC, 0x0B, 0xB8, 0x6B, 0x10, 0xBB, 0x2B, 0xB2, 0x87,
  0xBA, 0x04, 0xF3, 0x0B, 0xA2, 0x83, 0xCA, 0x0B, 0xA2, 0x83, 0x4F, 0x3B, 0xA3, 0x0D, 0x0A,
  // "S" (U+0053)
  0x18, 0x96, 0x1A, 0xEE, 0xB3, 0x0C, 0xC4, 0x48, 0x12, 0xF3, 0x48, 0x13, 0xF4, 0x58, 0x1E, 0xC1,
  0x48, 0x24, 0xEE, 0x74, 0x82, 0x1A, 0xFB, 0x58, 0x15, 0xF6, 0x50, 0xD0, 0x85, 0x89, 0x5D, 0x74,
  0x84, 0x39, 0xE2, 0x2C, 0xEF, 0xC3, 0x10,
  // "T" (U+0054)
  0x0D, 0xD8, 0x6B, 0x22, 0x5F, 0x42, 0x22, 0x81, 0x3F, 0x24, 0x81, 0x3F, 0x24, 0x81, 0x3F, 0x24,
  0x81, 0x3F, 0x24, 0x81, 0x3F, 0x24, 0x81, 0x3F, 0x24, 0x81, 0x3F, 0x24, 0x81, 0x3F, 0x24, 0x81,
  0x3F, 0x24, 0x81, 0x3F, 0x22,
  // "U" (U+0055)
  0x0C, 0x08, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33,
  0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33,
  0xF2, 0xB9, 0x38, 0x34, 0xF1, 0x9C, 0x38, 0x90, 0x7E, 0x02, 0xF8, 0x35, 0xE8, 0x28, 0x35, 0xCF,
  0xE8, 0x20,
  // "V" (U+0056)
  0x0D, 0x08, 0x48, 0x2B, 0xA9, 0xC4, 0x83, 0xE6, 0x5F, 0x12, 0x84, 0x3F, 0x21, 0xF4, 0x20, 0x70,
  0xD2, 0x0C, 0x08, 0x20, 0xB0, 0x92, 0x08, 0x0C, 0x20, 0xE0, 0x52, 0x84, 0x4F, 0x03, 0xF1, 0x39,
  0x81, 0x47, 0xD4, 0x82, 0xC8, 0xB9, 0x48, 0x28, 0xBE, 0x44, 0x03, 0xA0, 0x15, 0x0E, 0x0C, 0x30,
  // "W" (U+0057)
  0x0C, 0x09, 0x30, 0x89, 0x38, 0x31, 0xF4, 0x9C, 0x38, 0x1B, 0xF3, 0x28, 0x24, 0xF1, 0x59, 0x38,
  0x1E, 0xD7, 0x28, 0x91, 0x7D, 0x02, 0xF3, 0x02, 0xF8, 0xA2, 0x00, 0xA2, 0x85, 0xE6, 0x06, 0xC5,
  0xD2, 0x0E, 0x07, 0x28, 0x91, 0xB9, 0x09, 0x91, 0xF1, 0x1F, 0x32, 0x87, 0x7D, 0x0C, 0x60, 0xD5,
  0x59, 0x38, 0x90, 0x4F, 0x1F, 0x20, 0xA8, 0x8C, 0x38, 0x21, 0xF6, 0xE2, 0x82, 0x7B, 0xB9, 0x48,
  0x1D, 0xBB, 0x28, 0x23, 0xDD, 0x64, 0x81, 0xAF, 0x83, 0xA0, 0x34, 0x81, 0x6F, 0x43, 0x0C, 0x0E,
  0x30,
  // "X" (U+0058)
  0x81, 0x6E, 0x12, 0x83, 0x9C, 0x0E, 0x62, 0x86, 0xE6, 0x08, 0xD0, 0x6E, 0x28, 0x31, 0xF4, 0xC7,
  0x38, 0x2A, 0xDF, 0x13, 0x81, 0x3F, 0x94, 0x81, 0x6F, 0xB4, 0x82, 0xD9, 0xF3, 0x28, 0x34, 0xF1,
  0xBA, 0x28, 0x7B, 0x90, 0x4F, 0x13, 0xF2, 0x28, 0x2D, 0x8A, 0xB3, 0x07, 0x0E,
  // "Y" (U+0059)
  0x0C, 0x0A, 0x38, 0x38, 0xD6, 0xF1, 0x28, 0x95, 0xE8, 0x1F, 0x60, 0x4F, 0x20, 0xAC, 0x0A, 0xB2,
  0x83, 0x4F, 0x4F, 0x53, 0x81, 0xDE, 0xE4, 0x81, 0x7F, 0x84, 0x81, 0x2F, 0x34, 0x81, 0x2F, 0x34,
  0x81, 0x2F, 0x34, 0x81, 0x2F, 0x34, 0x81, 0x2F, 0x32,
  // "Z" (U+005A)
  0x06, 0xD8, 0x63, 0x12, 0x22, 0x8F, 0x14, 0x0D, 0x09, 0x48, 0x14, 0xF2, 0x40, 0x0B, 0x48, 0x12,
  0xF4, 0x40, 0x90, 0xD5, 0x0E, 0x06, 0x40, 0x60, 0xE5, 0x0D, 0x08, 0x48, 0x64, 0xF5, 0x22, 0x21,
  0x8D, 0x06,
  // "[" (U+005B)
  0x0C, 0xA8, 0x59, 0xC8, 0x21, 0xC7, 0x20, 0xC0, 0x72, 0x0C, 0x07, 0x20, 0xC0, 0x72, 0x0C, 0x07,
  0x20, 0xC0, 0x72, 0x0C, 0x07, 0x20, 0xC0, 0x72, 0x0C, 0x07, 0x20, 0xC0, 0x72, 0x0C, 0x07, 0x20,
  0xCA, 0x83, 0x92, 0x22, 0x10,
  // "\" (U+005C)
  0x09, 0x0A, 0x48, 0x13, 0xF1, 0x40, 0xD0, 0x64, 0x08, 0x0B, 0x48, 0x12, 0xF1, 0x40, 0xC0, 0x74,
  0x07, 0x0C, 0x48, 0x11, 0xF2, 0x40, 0xB0, 0x74, 0x06, 0x0D, 0x48, 0x11, 0xF3, 0x40, 0xB0, 0x80,
  // "]" (U+005D)
  0x08, 0xA8, 0x3D, 0x12, 0x7D, 0x20, 0x60, 0xD2, 0x06, 0x0D, 0x20, 0x60, 0xD2, 0x06, 0x0D, 0x20,
  0x60, 0xD2, 0x06, 0x0D, 0x20, 0x60, 0xD2, 0x06, 0x0D, 0x20, 0x60, 0xD2, 0x06, 0x0D, 0x28, 0x16,
  0xD8, 0xA0, 0xD0, 0x10, 0xF2,
  // "^" (U+005E)
  0x30, 0x50, 0x25, 0x81, 0x1F, 0xA5, 0x82, 0x8B, 0xE2, 0x48, 0x2E, 0x38, 0xA3, 0x84, 0x7B, 0x01,
  0xF2, 0x20, 0xE0, 0x42, 0x83, 0x99, 0x06, 0xC3, 0x81, 0x2F, 0x20,
  // "_" (U+005F)
  0xF0, 0x18, 0x03, 0x21,
  // "`" (U+0060)
  0x81, 0x27, 0x22, 0x0A, 0x0C, 0x30, 0xA0, 0x60,
  // "a" (U+0061)
  0x18, 0x34, 0xBE, 0xD5, 0x28, 0x35, 0x73, 0xAE, 0x58, 0x12, 0xF3, 0x48, 0x51, 0xF3, 0x04, 0xCE,
  0xA8, 0x73, 0x2F, 0x93, 0x3F, 0x35, 0x92, 0x89, 0x72, 0xF3, 0x3F, 0x63, 0xAF, 0x30, 0x8E, 0xD4,
  0xC3,
  // "b" (U+0062)
  0x0D, 0x07, 0x50, 0xD0, 0x75, 0x0D, 0x07, 0x58, 0x96, 0xD7, 0xAF, 0xC2, 0x0D, 0xE6, 0x4C, 0xC0,
  0xDB, 0x28, 0x33, 0xF2, 0xD8, 0x39, 0x81, 0x5D, 0x73, 0x98, 0x16, 0xD8, 0x39, 0x81, 0x5D, 0xB2,
  0x89, 0x63, 0xF2, 0xDE, 0x74, 0xCC, 0x0D, 0x4A, 0xFC, 0x21,
  // "c" (U+0063)
  0x28, 0x93, 0x9E, 0xE7, 0x09, 0xE5, 0x43, 0x0E, 0x63, 0x81, 0x2F, 0x23, 0x81, 0x3F, 0x13, 0x81,
  0x3F, 0x24, 0x90, 0x64, 0x83, 0xAE, 0x54, 0x52, 0x82, 0xAE, 0xE7,
  // "d" (U+0064)
  0x50, 0x59, 0x50, 0x59, 0x58, 0xA1, 0x5F, 0x01, 0xBF, 0xB6, 0xF0, 0xAD, 0x46, 0xEF, 0x0F, 0x52,
  0x83, 0x9F, 0x3F, 0x22, 0x83, 0x5F, 0x3F, 0x12, 0x83, 0x5F, 0x3F, 0x22, 0x83, 0x5F, 0x1F, 0x52,
  0x89, 0x58, 0xF0, 0xAD, 0x45, 0xDF, 0x01, 0xBF, 0xB3, 0x90,
  // "e" (U+0065)
  0x28, 0x2A, 0xED, 0x42, 0x87, 0x9D, 0x47, 0xF1, 0x0F, 0x52, 0x83, 0xD7, 0x2F, 0x22, 0x81, 0xA9,
  0x3D, 0x89, 0x1A, 0x2F, 0x42, 0x22, 0x20, 0xE5, 0x58, 0x48, 0xD5, 0x36, 0x32, 0x83, 0x8E, 0xEB,
  0x20,
  // "f" (U+0066)
  0x18, 0x92, 0x1B, 0xEB, 0x07, 0xE3, 0x30, 0x9A, 0x20, 0x9B, 0x83, 0x42, 0xBB, 0x22, 0x00, 0xA3,
  0x00, 0xA3, 0x00, 0xA3, 0x00, 0xA3, 0x00, 0xA3, 0x00, 0xA3, 0x00, 0xA2,
  // "g" (U+0067)
  0x18, 0x96, 0x1B, 0xFB, 0x4F, 0x0A, 0xD4, 0x6D, 0xF0, 0xF5, 0x28, 0x39, 0xF3, 0xF2, 0x28, 0x36,
  0xF3, 0xF1, 0x28, 0x35, 0xF2, 0xF2, 0x28, 0x35, 0xF0, 0xF5, 0x28, 0x95, 0x8F, 0x0A, 0xD4, 0x5D,
  0xF0, 0x1B, 0xFB, 0x69, 0x50, 0x50, 0xE5, 0x89, 0x58, 0xC0, 0x85, 0x36, 0xE6, 0x07, 0xDF, 0xD7,
  0x10,
  // "h" (U+0068)
  0x0D, 0x07, 0x40, 0xD0, 0x74, 0x0D, 0x07, 0x48, 0x94, 0xD7, 0xAE, 0xC2, 0xDE, 0x73, 0xCA, 0xDB,
  0x28, 0x26, 0xED, 0x82, 0x82, 0x5F, 0xD7, 0x28, 0x25, 0xFD, 0x72, 0x82, 0x5F, 0xD7, 0x28, 0x25,
  0xFD, 0x72, 0x82, 0x5F, 0xD7, 0x20, 0x59,
  // "i" (U+0069)
  0x82, 0xC6, 0x95, 0x28, 0xA0, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7,
  // "j" (U+006A)
  0x20, 0xC0, 0x62, 0x09, 0x05, 0x60, 0xD0, 0x72, 0x0D, 0x07, 0x20, 0xD0, 0x72, 0x0D, 0x07, 0x20,
  0xD0, 0x72, 0x0D, 0x07, 0x20, 0xD0, 0x72, 0x0D, 0x07, 0x20, 0xD0, 0x72, 0x0D, 0x07, 0x28, 0x7D,
  0x61, 0x4F, 0x45, 0xFA, 0x10,
  // "k" (U+006B)
  0x0D, 0x07, 0x40, 0xD0, 0x74, 0x0D, 0x07, 0x48, 0xA4, 0xD7, 0x01, 0xE6, 0xD7, 0x0A, 0xB0, 0xD7,
  0x5E, 0x10, 0xD8, 0xE6, 0x28, 0x2D, 0xEE, 0xA2, 0x8A, 0x2D, 0xA3, 0xF3, 0x0D, 0x70, 0xBA, 0x0D,
  0x70, 0x4F, 0x3D, 0x72, 0x0C, 0x0A,
  // "l" (U+006C)
  0x8A, 0x6D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x70,
  // "m" (U+006D)
  0x8A, 0x4D, 0x5B, 0xFB, 0x19, 0xED, 0x3D, 0xE6, 0x4E, 0xD8, 0x3C, 0xCD, 0xA2, 0x0A, 0x0E, 0x28,
  0x25, 0xFD, 0x82, 0x09, 0x0C, 0x28, 0x24, 0xFD, 0x72, 0x09, 0x0B, 0x28, 0x24, 0xFD, 0x72, 0x09,
  0x0B, 0x28, 0x24, 0xFD, 0x72, 0x09, 0x0B, 0x28, 0x24, 0xFD, 0x72, 0x09, 0x0B, 0x28, 0x24, 0xFD,
  0x72, 0x09, 0x0B, 0x20, 0x49,
  // "n" (U+006E)
  0x89, 0x4D, 0x5A, 0xEC, 0x2D, 0xE7, 0x3D, 0xAD, 0xB2, 0x82, 0x6E, 0xD8, 0x28, 0x25, 0xFD, 0x72,
  0x82, 0x5F, 0xD7, 0x28, 0x25, 0xFD, 0x72, 0x82, 0x5F, 0xD7, 0x28, 0x25, 0xFD, 0x72, 0x05, 0x90,
  // "o" (U+006F)
  0x28, 0x29, 0xEE, 0x83, 0x84, 0x9D, 0x45, 0xE7, 0x20, 0xE0, 0x52, 0x84, 0x7D, 0x02, 0xF2, 0x28,
  0x44, 0xF1, 0x3F, 0x12, 0x84, 0x3F, 0x22, 0xF2, 0x20, 0x49, 0x20, 0xE0, 0x52, 0x07, 0x0D, 0x28,
  0x48, 0xD4, 0x5E, 0x63, 0x82, 0x9E, 0xE8, 0x20,
  // "p" (U+0070)
  0x89, 0x6D, 0x5A, 0xFC, 0x20, 0xDD, 0x74, 0xCD, 0x0D, 0xB2, 0x83, 0x3F, 0x3D, 0x83, 0x98, 0x15,
  0xD7, 0x39, 0x81, 0x6D, 0x83, 0x98, 0x14, 0xDB, 0x28, 0xA1, 0x3F, 0x2D, 0xE7, 0x4C, 0xC0, 0xD7,
  0xAF, 0xC2, 0x0D, 0x75, 0x0D, 0x07, 0x50, 0xD0, 0x75, 0x0D, 0x07, 0x50,
  // "q" (U+0071)
  0x18, 0x96, 0x1B, 0xFB, 0x4F, 0x0A, 0xD4, 0x6D, 0xF0, 0xF5, 0x28, 0x39, 0xF3, 0xF2, 0x28, 0x36,
  0xF3, 0xF1, 0x28, 0x35, 0xF3, 0xF2, 0x28, 0x35, 0xF1, 0xF5, 0x28, 0x95, 0x9F, 0x0B, 0xD4, 0x5D,
  0xF0, 0x1B, 0xFB, 0x69, 0x50, 0x59, 0x50, 0x59, 0x50, 0x59, 0x50, 0x59,
  // "r" (U+0072)
  0x89, 0x2D, 0x4A, 0xF2, 0xDC, 0x83, 0x0D, 0xC3, 0x0D, 0x09, 0x30, 0xD0, 0x73, 0x0D, 0x07, 0x30,
  0xD0, 0x73, 0x0D, 0x07, 0x30, 0xD0, 0x73,
  // "s" (U+0073)
  0x18, 0x93, 0x6D, 0xEB, 0x23, 0xF6, 0x37, 0x15, 0xE4, 0x82, 0x1E, 0xA1, 0x38, 0x22, 0xCE, 0x64,
  0x81, 0x6F, 0x44, 0x89, 0x3C, 0x74, 0x73, 0x5F, 0x43, 0xCE, 0xD7, 0x10,
  // "t" (U+0074)
  0x10, 0x60, 0x83, 0x0A, 0x08, 0x20, 0x8B, 0x83, 0x42, 0xD9, 0x22, 0x0C, 0x08, 0x30, 0xC0, 0x83,
  0x0C, 0x08, 0x30, 0xC0, 0x83, 0x0C, 0x08, 0x38, 0x7A, 0xC3, 0x10, 0x3D, 0xE4,
  // "u" (U+0075)
  0x0E, 0x06, 0x28, 0x26, 0xEE, 0x62, 0x82, 0x6E, 0xE6, 0x28, 0x26, 0xEE, 0x62, 0x82, 0x6E, 0xE6,
  0x28, 0x26, 0xEE, 0x62, 0x82, 0x7E, 0xC7, 0x28, 0x94, 0x9E, 0x9C, 0x14, 0xEE, 0x1B, 0xEC, 0x5E,
  // "v" (U+0076)
  0x0C, 0x08, 0x38, 0x2E, 0x68, 0xC2, 0x87, 0x3F, 0x14, 0xF1, 0x07, 0xD2, 0x83, 0xE4, 0x0B, 0x82,
  0x83, 0xB8, 0x0E, 0x42, 0x81, 0x6C, 0x39, 0x38, 0x22, 0xF8, 0xB4, 0x81, 0xDE, 0x74, 0x81, 0x9F,
  0x22,
  // "w" (U+0077)
  0x0B, 0x09, 0x28, 0x18, 0xF1, 0x29, 0x81, 0x48, 0xC2, 0x86, 0xCE, 0x50, 0x3F, 0x14, 0x92, 0x98,
  0x96, 0xA8, 0x07, 0xD0, 0x1F, 0x33, 0xD5, 0xC0, 0xA9, 0x28, 0x7D, 0x67, 0xA2, 0xF0, 0xD5, 0x28,
  0x79, 0x9A, 0x70, 0xE4, 0xF2, 0x28, 0x66, 0xCD, 0x30, 0xBA, 0xE3, 0x81, 0x3E, 0xE2, 0x81, 0x7E,
  0xA4, 0x0E, 0x0B, 0x28, 0x14, 0xF7, 0x20,
  // "x" (U+0078)
  0x89, 0x35, 0xF1, 0x04, 0xF2, 0x0D, 0x80, 0xB9, 0x28, 0x35, 0xE4, 0xF2, 0x38, 0x1D, 0xE9, 0x48,
  0x18, 0xF4, 0x48, 0x1E, 0xDA, 0x38, 0x95, 0x7D, 0x2F, 0x30, 0x1E, 0x60, 0xAB, 0x07, 0xD2, 0x81,
  0x3F, 0x30,
  // "y" (U+0079)
  0x0C, 0x08, 0x38, 0x2E, 0x68, 0xD2, 0x87, 0x3F, 0x13, 0xF1, 0x07, 0xD2, 0x83, 0xE5, 0x0B, 0x82,
  0x83, 0xA9, 0x0E, 0x42, 0x81, 0x5D, 0x39, 0x38, 0x21, 0xF9, 0xB4, 0x81, 0xBE, 0x64, 0x81, 0x7F,
  0x24, 0x07, 0x0D, 0x50, 0xB0, 0x93, 0x82, 0x26, 0xF3, 0x38, 0x1B, 0xE6, 0x40,
  // "z" (U+007A)
  0x05, 0xC8, 0x41, 0x12, 0x29, 0xD4, 0x0E, 0x06, 0x30, 0x60, 0xE4, 0x0D, 0x07, 0x38, 0x15, 0xE1,
  0x30, 0xC0, 0x83, 0x85, 0x4F, 0x42, 0x20, 0x8C, 0x03,
  // "{" (U+007B)
  0x38, 0x18, 0xD3, 0x28, 0x16, 0xE5, 0x30, 0x0A, 0x40, 0xA0, 0x94, 0x0A, 0x09, 0x40, 0xB0, 0x93,
  0x81, 0x3E, 0x52, 0x81, 0x6F, 0x93, 0x82, 0x15, 0xF5, 0x40, 0xB0, 0x94, 0x0A, 0x09, 0x40, 0xA0,
  0x94, 0x81, 0x9D, 0x23, 0x82, 0x1C, 0xF3, 0x40, 0x11,
  // "|" (U+007C)
  0x98, 0xB5, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F,
  0x2F, 0x20,
  // "}" (U+007D)
  0x81, 0x5D, 0x73, 0x82, 0x16, 0xF4, 0x40, 0xC0, 0x74, 0x0B, 0x08, 0x40, 0xB0, 0x84, 0x0B, 0x08,
  0x48, 0x18, 0xD2, 0x48, 0x1B, 0xF4, 0x28, 0x17, 0xD4, 0x30, 0xB0, 0x84, 0x0B, 0x08, 0x40, 0xB0,
  0x83, 0x81, 0x3E, 0x62, 0x81, 0x6F, 0xB3, 0x00, 0x14,
  // "~" (U+007E)
  0x89, 0x11, 0xCE, 0xA3, 0x08, 0x66, 0x49, 0xA0, 0xB5, 0x01, 0x10,
  // "¡" (U+00A1)
  0x82, 0xBA, 0xCB, 0x48, 0x96, 0x87, 0x97, 0x98, 0xA8, 0xB9, 0xBA, 0xCA, 0xDB,
  // "¢" (U+00A2)
  0x20, 0x20, 0xB4, 0x81, 0x6D, 0x52, 0x89, 0x3B, 0xFD, 0xF2, 0x4F, 0x40, 0x10, 0x9C, 0x40, 0x0A,
  0x40, 0x0A, 0x40, 0x90, 0xC4, 0x81, 0x4F, 0x44, 0x83, 0xAF, 0xDF, 0x32, 0x81, 0x5C, 0x33, 0x02,
  0x0B, 0x20,
  // "£" (U+00A3)
  0x28, 0x32, 0xBE, 0xD5, 0x28, 0x3B, 0xB3, 0x65, 0x29, 0x05, 0x48, 0x11, 0xF3, 0x48, 0x11, 0xF3,
  0x48, 0x11, 0xF3, 0x30, 0x6C, 0x86, 0x90, 0x14, 0xF6, 0x21, 0x28, 0x11, 0xF3, 0x48, 0x13, 0xF2,
  0x38, 0x61, 0xBA, 0x22, 0x22, 0x5D, 0x0E,
  // "¤" (U+00A4)
  0x02, 0x58, 0x97, 0x2D, 0x7B, 0xEA, 0x9B, 0x3F, 0x73, 0x8F, 0x26, 0x93, 0x82, 0xA5, 0x95, 0x30,
  0x60, 0xF7, 0x38, 0x97, 0x86, 0x3E, 0x40, 0x5F, 0x1B, 0xBE, 0xFD, 0xBA, 0x52, 0x02, 0x20, 0x50,
  // "¥" (U+00A5)
  0x81, 0x5F, 0x12, 0x83, 0x8D, 0x0E, 0x62, 0x89, 0x5D, 0x70, 0x9B, 0x03, 0xF1, 0x03, 0xF1, 0x8A,
  0x38, 0x2C, 0x7E, 0x43, 0x81, 0x6E, 0xE3, 0x0D, 0xC0, 0x63, 0x0E, 0x06, 0x50, 0xE0, 0x63, 0x0D,
  0xC8, 0x66, 0x02, 0x2E, 0x82, 0x13, 0x0E, 0x06, 0x20,
  // "¦" (U+00A6)
  0x98, 0x91, 0x2F, 0x2F, 0x2F, 0x2F, 0x2F, 0x27, 0x19, 0x89, 0x12, 0xF2, 0xF2, 0xF2, 0xF2, 0xF2,
  // "§" (U+00A7)
  0x18, 0x94, 0x4C, 0xEC, 0x40, 0xE8, 0x36, 0x31, 0xF3, 0x48, 0x19, 0xE6, 0x38, 0x49, 0xBC, 0xD2,
  0x39, 0x28, 0x94, 0xAA, 0x1F, 0x50, 0x7A, 0x04, 0xDC, 0xD2, 0x38, 0x17, 0xE4, 0x48, 0x93, 0x8A,
  0x37, 0x34, 0xD8, 0x1B, 0xEE, 0x91,
  // "¨" (U+00A8)
  0x84, 0x97, 0x0D, 0x31, 0x20, 0x11,
  // "©" (U+00A9)
  0x38, 0x52, 0x9D, 0xFE, 0xA3, 0x58, 0x75, 0xEA, 0x53, 0x48, 0xE8, 0x38, 0x91, 0x3E, 0x40, 0x9E,
  0xE8, 0x2D, 0x62, 0x89, 0x1B, 0x50, 0x9D, 0x44, 0x50, 0x2E, 0x28, 0x3D, 0x01, 0xF2, 0x58, 0x5A,
  0x42, 0xB0, 0x3E, 0x68, 0x57, 0x73, 0xA0, 0x3E, 0x68, 0x67, 0x71, 0xD0, 0x1F, 0x15, 0x8A, 0x39,
  0x50, 0xC4, 0x0B, 0xA1, 0x13, 0x01, 0xE1, 0x04, 0xD2, 0x2D, 0xA8, 0x28, 0x0B, 0x83, 0x87, 0x7E,
  0x72, 0x23, 0x5C, 0xB5, 0x04, 0x0C, 0xB0, 0xD0, 0x77, 0x18, 0x11, 0x21, 0x50,
  // "ª" (U+00AA)
  0x18, 0x1B, 0xCB, 0x48, 0x97, 0xB4, 0x1A, 0xBE, 0x47, 0x80, 0xC4, 0x3D, 0xAA, 0x40,
  // "«" (U+00AB)
  0x20, 0x10, 0x32, 0x03, 0x28, 0xA7, 0xB9, 0x0A, 0xA0, 0x7D, 0x06, 0xE1, 0x3F, 0x43, 0xF6, 0x01,
  0xD8, 0x0D, 0xA2, 0x84, 0x3E, 0x32, 0xE5, 0x28, 0x36, 0x90, 0x5B,
  // "¬" (U+00AC)
  0x06, 0xD8, 0x6D, 0x12, 0x22, 0x25, 0xD5, 0x03, 0x0D, 0x50, 0x30, 0xD6, 0x02,
  // "®" (U+00AE)
  0x38, 0x52, 0x9D, 0xFE, 0xA3, 0x58, 0x75, 0xEA, 0x53, 0x48, 0xE8, 0x38, 0x13, 0xE4, 0x58, 0x12,
  0xD6, 0x28, 0x2B, 0x50, 0x7A, 0x83, 0xC4, 0x02, 0xE2, 0x0D, 0x28, 0x37, 0xB3, 0x9D, 0x28, 0x2A,
  0x42, 0xB2, 0x83, 0x7A, 0x07, 0xD2, 0x82, 0x77, 0x3A, 0x20, 0x7A, 0x0E, 0x03, 0x28, 0x27, 0x71,
  0xD2, 0x83, 0x7B, 0x3E, 0x22, 0x8A, 0x39, 0x50, 0xC4, 0x07, 0xA0, 0x8B, 0x01, 0xE1, 0x04, 0xD2,
  0x46, 0x28, 0x29, 0x2B, 0x83, 0x87, 0x7E, 0x72, 0x01, 0x5C, 0xB5, 0x04, 0x0C, 0xB0, 0xD0, 0x77,
  0x18, 0x11, 0x21, 0x50,
  // "¯" (U+00AF)
  0x01, 0xF0, 0x51, 0x80, 0x32, 0x10,
  // "°" (U+00B0)
  0x18, 0x25, 0xDE, 0x62, 0x85, 0xE5, 0x4E, 0x23, 0xC2, 0x89, 0x09, 0x51, 0xE2, 0x1D, 0x30, 0x7A,
  0x09, 0x30, 0x01, 0x20,
  // "±" (U+00B1)
  0x30, 0xC0, 0x55, 0x0C, 0x05, 0x50, 0xC0, 0x52, 0x06, 0xD8, 0x6E, 0x12, 0x2C, 0x72, 0x23, 0x0C,
  0x05, 0x50, 0xC0, 0x55, 0x0C, 0x05, 0x20, 0x18, 0x02, 0x20, 0x6E,
  // "²" (U+00B2)
  0x89, 0x02, 0xBE, 0xA0, 0x24, 0x1C, 0x53, 0x0C, 0x04, 0x20, 0x50, 0xC2, 0x85, 0x3D, 0x10, 0x2D,
  0x22, 0x83, 0x8E, 0xEE, 0x70,
  // "³" (U+00B3)
  0x89, 0x03, 0xCE, 0xA0, 0x23, 0x1C, 0x52, 0x85, 0x1D, 0x30, 0x9F, 0xA4, 0x81, 0xA7, 0x22, 0x84,
  0xA7, 0x6D, 0xEA, 0x10,
  // "´" (U+00B4)
  0x28, 0x77, 0x40, 0x7D, 0x12, 0xD2, 0x10,
  // "µ" (U+00B5)
  0x0D, 0x07, 0x28, 0x25, 0xFD, 0x72, 0x82, 0x5F, 0xD7, 0x28, 0x25, 0xFD, 0x72, 0x82, 0x5F, 0xD7,
  0x28, 0x25, 0xFD, 0x72, 0x82, 0x6F, 0xD8, 0x28, 0x96, 0x9F, 0xDE, 0x46, 0xDF, 0xDB, 0xEC, 0x4F,
  0xD7, 0x40, 0xD0, 0x74, 0x0D, 0x07, 0x40, 0xD0, 0x74,
  // "¶" (U+00B6)
  0x01, 0x0B, 0xC0, 0x10, 0x9B, 0x82, 0x2D, 0x1E, 0xB1, 0x0C, 0x01, 0xC1, 0x0C, 0x01, 0xC1, 0x0C,
  0x01, 0xC1, 0x81, 0xC1, 0xCB, 0x18, 0x1C, 0x14, 0xB1, 0x87, 0xC1, 0x02, 0x4E, 0x0C, 0x13, 0x82,
  0xE0, 0xC1, 0x38, 0x2E, 0x0C, 0x13, 0x82, 0xE0, 0xC1, 0x38, 0x2E, 0x0C, 0x13, 0x82, 0xE0, 0xC1,
  0x38, 0x29, 0x08, 0x10,
  // "·" (U+00B7)
  0x82, 0xDA, 0xC9,
  // "¸" (U+00B8)
  0x18, 0x91, 0xD0, 0x17, 0xC3, 0x6F, 0xBD, 0x60,
  // "¹" (U+00B9)
  0x18, 0x91, 0x2D, 0x92, 0xDA, 0x90, 0x17, 0x92, 0x07, 0x09, 0x20, 0x70, 0x92, 0x07, 0x09, 0x20,
  0x70, 0x90,
  // "º" (U+00BA)
  0x18, 0xA6, 0xAB, 0xB2, 0x5A, 0x05, 0xA7, 0x80, 0x3C, 0x4B, 0x06, 0x90, 0x8B, 0xA1,
  // "»" (U+00BB)
  0x10, 0x32, 0x04, 0x28, 0x42, 0xE4, 0x1E, 0x52, 0x84, 0x6E, 0x15, 0xE2, 0x28, 0xA7, 0xCB, 0x0B,
  0xD0, 0x1E, 0x71, 0xE8, 0x0B, 0xA0, 0xAB, 0x02, 0xC0, 0x1C, 0x11,
  // "¼" (U+00BC)
  0x18, 0x13, 0xD6, 0x40, 0xB0, 0x62, 0x82, 0x3E, 0xC6, 0x30, 0x30, 0xD3, 0x82, 0x12, 0x96, 0x30,
  0xB0, 0x55, 0x09, 0x06, 0x20, 0x40, 0xC6, 0x09, 0x06, 0x20, 0xC0, 0x56, 0x83, 0x96, 0x04, 0xC2,
  0x0D, 0x07, 0x38, 0x79, 0x60, 0xC4, 0x06, 0xD7, 0x50, 0x50, 0xC2, 0x81, 0xB9, 0x75, 0x85, 0xD4,
  0x07, 0x69, 0x74, 0x86, 0x5B, 0x01, 0xD0, 0x97, 0x48, 0x4D, 0x30, 0x5E, 0xEA, 0x05, 0x20, 0x60,
  0xB5, 0x09, 0x07, 0x10,
  // "½" (U+00BD)
  0x18, 0x13, 0xE6, 0x38, 0x11, 0xE2, 0x28, 0x24, 0xEC, 0x63, 0x08, 0x09, 0x38, 0x22, 0x2A, 0x62,
  0x81, 0x1E, 0x15, 0x0A, 0x06, 0x20, 0x80, 0x96, 0x84, 0xA6, 0x01, 0xE1, 0x68, 0x7A, 0x60, 0x88,
  0x4C, 0xE8, 0x38, 0x90, 0xA6, 0x1E, 0x12, 0x21, 0xE2, 0x40, 0x90, 0x84, 0x0E, 0x01, 0x38, 0x11,
  0xE1, 0x30, 0x70, 0x94, 0x09, 0x08, 0x30, 0x50, 0xC4, 0x81, 0x1E, 0x12, 0x81, 0x4C, 0x14, 0x09,
  0x08, 0x30, 0xBB, 0x05, 0x20, 0x24, 0x80, 0x02, 0x10,
  // "¾" (U+00BE)
  0x82, 0x2C, 0xEA, 0x40, 0x60, 0xB2, 0x83, 0x46, 0x4D, 0x53, 0x0D, 0x03, 0x48, 0x11, 0xD3, 0x20,
  0x60, 0xB4, 0x81, 0xAF, 0xA3, 0x0D, 0x03, 0x48, 0x51, 0x3C, 0x60, 0x7A, 0x48, 0x93, 0x21, 0x0A,
  0x80, 0xE2, 0x08, 0xC0, 0x7A, 0x86, 0xD2, 0x7A, 0x01, 0xBC, 0x20, 0x10, 0x22, 0x84, 0xE2, 0x09,
  0x5C, 0x58, 0x57, 0x90, 0x2A, 0x3C, 0x48, 0x61, 0xE2, 0x0A, 0x33, 0xC4, 0x08, 0x09, 0x20, 0x0E,
  0xA0, 0x92, 0x81, 0x1E, 0x14, 0x03, 0x0C, 0x10,
  // "¿" (U+00BF)
  0x28, 0x11, 0xE5, 0x38, 0x12, 0xF6, 0x73, 0x07, 0x01, 0x40, 0xE0, 0x23, 0x06, 0x0E, 0x38, 0x13,
  0xF5, 0x30, 0xC0, 0x93, 0x81, 0x2F, 0x23, 0x81, 0x3F, 0x13, 0x89, 0x21, 0xE9, 0x36, 0x50, 0x4D,
  0xEC, 0x50,
  // "À" (U+00C0)
  0x18, 0x12, 0x72, 0x60, 0xA0, 0xC7, 0x0A, 0x06, 0x77, 0x0D, 0x0E, 0x58, 0x22, 0xFE, 0x34, 0x82,
  0x6C, 0xB7, 0x48, 0x2A, 0x97, 0xB4, 0x81, 0xE5, 0x49, 0x38, 0x43, 0xF1, 0x0F, 0x42, 0x84, 0x7D,
  0x11, 0xC9, 0x20, 0xCC, 0x0D, 0x29, 0x87, 0x73, 0x36, 0xF2, 0x5F, 0x13, 0x98, 0x16, 0x9C, 0x48,
  0x2B, 0xAD, 0x84, 0x07, 0x0E,
  // "Á" (U+00C1)
  0x50, 0x70, 0x45, 0x81, 0x7D, 0x14, 0x81, 0x2D, 0x27, 0x60, 0xD0, 0xE5, 0x82, 0x2F, 0xE3, 0x48,
  0x26, 0xCB, 0x74, 0x82, 0xA9, 0x7B, 0x48, 0x1E, 0x54, 0x93, 0x84, 0x3F, 0x10, 0xF4, 0x28, 0x47,
  0xD1, 0x1C, 0x92, 0x0C, 0xC0, 0xD2, 0x98, 0x77, 0x33, 0x6F, 0x25, 0xF1, 0x39, 0x81, 0x69, 0xC4,
  0x82, 0xBA, 0xD8, 0x40, 0x70, 0xE0,
  // "Â" (U+00C2)
  0x30, 0x60, 0x55, 0x82, 0x5D, 0xE3, 0x38, 0x32, 0xC1, 0x3C, 0x76, 0x0D, 0x0E, 0x58, 0x22, 0xFE,
  0x34, 0x82, 0x6C, 0xB7, 0x48, 0x2A, 0x97, 0xB4, 0x81, 0xE5, 0x49, 0x38, 0x43, 0xF1, 0x0F, 0x42,
  0x84, 0x7D, 0x11, 0xC9, 0x20, 0xCC, 0x0D, 0x29, 0x87, 0x73, 0x36, 0xF2, 0x5F, 0x13, 0x98, 0x16,
  0x9C, 0x48, 0x2B, 0xAD, 0x84, 0x07, 0x0E,
  // "Ã" (U+00C3)
  0x28, 0x3B, 0xD5, 0x49, 0x28, 0x43, 0xB5, 0xDF, 0x42, 0x00, 0x12, 0x01, 0x50, 0xD0, 0xE5, 0x82,
  0x2F, 0xE3, 0x48, 0x26, 0xCB, 0x74, 0x82, 0xA9, 0x7B, 0x48, 0x1E, 0x54, 0x93, 0x84, 0x3F, 0x10,
  0xF4, 0x28, 0x47, 0xD1, 0x1C, 0x92, 0x0C, 0xC0, 0xD2, 0x98, 0x77, 0x33, 0x6F, 0x25, 0xF1, 0x39,
  0x81, 0x69, 0xC4, 0x82, 0xBA, 0xD8, 0x40, 0x70, 0xE0,
  // "Ä" (U+00C4)
  0x28, 0x39, 0x70, 0xD3, 0x30, 0x12, 0x01, 0x76, 0x0D, 0x0E, 0x58, 0x22, 0xFE, 0x34, 0x82, 0x6C,
  0xB7, 0x48, 0x2A, 0x97, 0xB4, 0x81, 0xE5, 0x49, 0x38, 0x43, 0xF1, 0x0F, 0x42, 0x84, 0x7D, 0x11,
  0xC9, 0x20, 0xCC, 0x0D, 0x29, 0x87, 0x73, 0x36, 0xF2, 0x5F, 0x13, 0x98, 0x16, 0x9C, 0x48, 0x2B,
  0xAD, 0x84, 0x07, 0x0E,
  // "Å" (U+00C5)
  0x38, 0x1C, 0xE8, 0x48, 0x24, 0xB4, 0xE4, 0x01, 0xA0, 0xB4, 0x02, 0xA0, 0x34, 0x82, 0x6C, 0xB7,
  0x48, 0x2A, 0x97, 0xB4, 0x81, 0xE5, 0x49, 0x38, 0x43, 0xF1, 0x0F, 0x42, 0x84, 0x7D, 0x11, 0xC9,
  0x20, 0xCC, 0x0D, 0x29, 0x87, 0x73, 0x36, 0xF2, 0x5F, 0x13, 0x98, 0x16, 0x9C, 0x48, 0x2B, 0xAD,
  0x84, 0x07, 0x0E,
  // "Æ" (U+00C6)
  0x30, 0x2E, 0x04, 0x38, 0x27, 0xCA, 0xC0, 0xF2, 0x48, 0x2D, 0x79, 0xB6, 0x83, 0x2F, 0x29, 0xB6,
  0x83, 0x8D, 0x09, 0xB6, 0x82, 0xD8, 0x09, 0xC8, 0x61, 0x02, 0xF3, 0x09, 0xC0, 0xF2, 0x20, 0x8C,
  0x0B, 0x58, 0x4D, 0x92, 0x2B, 0xB4, 0x81, 0x3F, 0x32, 0x09, 0x0B, 0x40, 0x80, 0xE3, 0x86, 0x9C,
  0x22, 0x20, 0xD9, 0x30, 0x9C, 0x04,
  // "Ç" (U+00C7)
  0x28, 0x41, 0x9D, 0xEC, 0x42, 0x89, 0x0C, 0xD5, 0x37, 0x30, 0x7F, 0x25, 0x0C, 0x09, 0x69, 0x06,
  0x58, 0x11, 0xF4, 0x58, 0x11, 0xF5, 0x69, 0x06, 0x60, 0xD0, 0xA6, 0x81, 0x7F, 0x16, 0x84, 0xDD,
  0x53, 0x52, 0x28, 0x41, 0x9E, 0xFC, 0x24, 0x0D, 0x68, 0x11, 0x7C, 0x50, 0x30, 0x69, 0x58, 0x1B,
  0xD6, 0x20,
  // "È" (U+00C8)
  0x81, 0x27, 0x24, 0x0A, 0x0C, 0x50, 0xA0, 0x67, 0x10, 0xBC, 0x87, 0x6B, 0xB2, 0x22, 0x1B, 0xA4,
  0x0B, 0x0A, 0x40, 0xB0, 0xA4, 0x0B, 0xC8, 0x72, 0xBB, 0x22, 0x20, 0xBA, 0x40, 0xB0, 0xA4, 0x0B,
  0x0A, 0x48, 0x5B, 0xB2, 0x22, 0x1B, 0xC0, 0x60,
  // "É" (U+00C9)
  0x40, 0x70, 0x43, 0x81, 0x7D, 0x12, 0x81, 0x2D, 0x27, 0x0B, 0xC8, 0x76, 0xBB, 0x22, 0x21, 0xBA,
  0x40, 0xB0, 0xA4, 0x0B, 0x0A, 0x40, 0xBC, 0x87, 0x2B, 0xB2, 0x22, 0x0B, 0xA4, 0x0B, 0x0A, 0x40,
  0xB0, 0xA4, 0x85, 0xBB, 0x22, 0x21, 0xBC, 0x06,
  // "Ê" (U+00CA)
  0x20, 0x60, 0x53, 0x89, 0x05, 0xDE, 0x30, 0x2C, 0x13, 0xC7, 0x0B, 0xC8, 0x76, 0xBB, 0x22, 0x21,
  0xBA, 0x40, 0xB0, 0xA4, 0x0B, 0x0A, 0x40, 0xBC, 0x87, 0x2B, 0xB2, 0x22, 0x0B, 0xA4, 0x0B, 0x0A,
  0x40, 0xB0, 0xA4, 0x85, 0xBB, 0x22, 0x21, 0xBC, 0x06,
  // "Ë" (U+00CB)
  0x18, 0x59, 0x70, 0xD3, 0x01, 0x20, 0x17, 0x0B, 0xC8, 0x76, 0xBB, 0x22, 0x21, 0xBA, 0x40, 0xB0,
  0xA4, 0x0B, 0x0A, 0x40, 0xBC, 0x87, 0x2B, 0xB2, 0x22, 0x0B, 0xA4, 0x0B, 0x0A, 0x40, 0xB0, 0xA4,
  0x85, 0xBB, 0x22, 0x21, 0xBC, 0x06,
  // "Ì" (U+00CC)
  0x81, 0x27, 0x23, 0x0A, 0x0C, 0x40, 0xA0, 0x66, 0x06, 0xB8, 0x32, 0x05, 0xF2, 0x28, 0x14, 0xF1,
  0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28,
  0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x34, 0xF1, 0x05, 0xB0, 0x20,
  // "Í" (U+00CD)
  0x30, 0x70, 0x42, 0x85, 0x7D, 0x10, 0x2D, 0x26, 0x06, 0xB8, 0x32, 0x05, 0xF2, 0x28, 0x14, 0xF1,
  0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28,
  0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x34, 0xF1, 0x05, 0xB0, 0x20,
  // "Î" (U+00CE)
  0x20, 0x60, 0x52, 0x87, 0x5D, 0xE3, 0x2C, 0x13, 0xC5, 0x06, 0xB8, 0x32, 0x05, 0xF2, 0x28, 0x14,
  0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1,
  0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x34, 0xF1, 0x05, 0xB0, 0x20,
  // "Ï" (U+00CF)
  0x84, 0x97, 0x0D, 0x31, 0x20, 0x16, 0x06, 0xB8, 0x32, 0x05, 0xF2, 0x28, 0x14, 0xF1, 0x28, 0x14,
  0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1,
  0x28, 0x14, 0xF1, 0x28, 0x34, 0xF1, 0x05, 0xB0, 0x20,
  // "Ð" (U+00D0)
  0x10, 0xAA, 0x81, 0xEB, 0x33, 0x85, 0xAB, 0x24, 0xAF, 0x32, 0x00, 0xA3, 0x0B, 0x0C, 0x20, 0x0A,
  0x38, 0x44, 0xF2, 0x0A, 0xA3, 0x82, 0x1F, 0x59, 0xB0, 0x92, 0x98, 0x46, 0x1B, 0xB2, 0x12, 0x98,
  0x26, 0x0A, 0xA3, 0x84, 0x1F, 0x40, 0xAA, 0x38, 0x45, 0xF1, 0x0A, 0xA3, 0x0B, 0x0C, 0x28, 0x5A,
  0xB2, 0x4B, 0xE3, 0x20, 0xAA, 0x81, 0xEA, 0x32,
  // "Ñ" (U+00D1)
  0x28, 0x3B, 0xD5, 0x49, 0x28, 0x43, 0xB5, 0xDF, 0x42, 0x00, 0x12, 0x01, 0x28, 0x1B, 0xF2, 0x38,
  0x38, 0xBB, 0xF9, 0x38, 0x48, 0xBB, 0xCF, 0x12, 0x84, 0x8B, 0xB8, 0xD8, 0x28, 0xB2, 0x8B, 0xB8,
  0x6E, 0x10, 0x8B, 0xB9, 0x0E, 0x70, 0x8B, 0xB9, 0x07, 0xE0, 0x8B, 0xB9, 0x28, 0x4E, 0x68, 0xBB,
  0x92, 0x84, 0x8D, 0x8B, 0xB9, 0x28, 0x41, 0xFD, 0xBB, 0x93, 0x83, 0x9F, 0xBB, 0x93, 0x81, 0x2F,
  0xB0,
  // "Ò" (U+00D2)
  0x28, 0x12, 0x72, 0x70, 0xA0, 0xC7, 0x10, 0xA0, 0x67, 0x78, 0x42, 0xBE, 0xEA, 0x12, 0x85, 0x1E,
  0xB4, 0x4C, 0xD2, 0x09, 0x0D, 0x38, 0x41, 0xE6, 0x0D, 0x84, 0x83, 0xAB, 0x1F, 0x54, 0x83, 0x7F,
  0x2F, 0x44, 0x83, 0x6F, 0x1F, 0x44, 0x83, 0x6F, 0x0F, 0x54, 0x83, 0x7E, 0x0D, 0x84, 0x83, 0xAB,
  0x08, 0xD3, 0x89, 0x11, 0xE6, 0x01, 0xDB, 0x34, 0xCD, 0x38, 0x42, 0xAE, 0xEA, 0x11,
  // "Ó" (U+00D3)
  0x60, 0x70, 0x46, 0x81, 0x7D, 0x15, 0x81, 0x2D, 0x27, 0x68, 0x42, 0xBE, 0xEA, 0x12, 0x85, 0x1E,
  0xB4, 0x4C, 0xD2, 0x09, 0x0D, 0x38, 0x41, 0xE6, 0x0D, 0x84, 0x83, 0xAB, 0x1F, 0x54, 0x83, 0x7F,
  0x2F, 0x44, 0x83, 0x6F, 0x1F, 0x44, 0x83, 0x6F, 0x0F, 0x54, 0x83, 0x7E, 0x0D, 0x84, 0x83, 0xAB,
  0x08, 0xD3, 0x89, 0x11, 0xE6, 0x01, 0xDB, 0x34, 0xCD, 0x38, 0x42, 0xAE, 0xEA, 0x11,
  // "Ô" (U+00D4)
  0x40, 0x60, 0x56, 0x82, 0x5D, 0xE3, 0x48, 0x32, 0xC1, 0x3C, 0x76, 0x84, 0x2B, 0xEE, 0xA1, 0x28,
  0x51, 0xEB, 0x44, 0xCD, 0x20, 0x90, 0xD3, 0x84, 0x1E, 0x60, 0xD8, 0x48, 0x3A, 0xB1, 0xF5, 0x48,
  0x37, 0xF2, 0xF4, 0x48, 0x36, 0xF1, 0xF4, 0x48, 0x36, 0xF0, 0xF5, 0x48, 0x37, 0xE0, 0xD8, 0x48,
  0x3A, 0xB0, 0x8D, 0x38, 0x91, 0x1E, 0x60, 0x1D, 0xB3, 0x4C, 0xD3, 0x84, 0x2A, 0xEE, 0xA1, 0x10,
  // "Õ" (U+00D5)
  0x38, 0x3B, 0xD5, 0x49, 0x38, 0x43, 0xB5, 0xDF, 0x43, 0x00, 0x12, 0x01, 0x48, 0x42, 0xBE, 0xEA,
  0x12, 0x85, 0x1E, 0xB4, 0x4C, 0xD2, 0x09, 0x0D, 0x38, 0x41, 0xE6, 0x0D, 0x84, 0x83, 0xAB, 0x1F,
  0x54, 0x83, 0x7F, 0x2F, 0x44, 0x83, 0x6F, 0x1F, 0x44, 0x83, 0x6F, 0x0F, 0x54, 0x83, 0x7E, 0x0D,
  0x84, 0x83, 0xAB, 0x08, 0xD3, 0x89, 0x11, 0xE6, 0x01, 0xDB, 0x34, 0xCD, 0x38, 0x42, 0xAE, 0xEA,
  0x11,
  // "Ö" (U+00D6)
  0x38, 0x39, 0x70, 0xD3, 0x40, 0x12, 0x01, 0x76, 0x84, 0x2B, 0xEE, 0xA1, 0x28, 0x51, 0xEB, 0x44,
  0xCD, 0x20, 0x90, 0xD3, 0x84, 0x1E, 0x60, 0xD8, 0x48, 0x3A, 0xB1, 0xF5, 0x48, 0x37, 0xF2, 0xF4,
  0x48, 0x36, 0xF1, 0xF4, 0x48, 0x36, 0xF0, 0xF5, 0x48, 0x37, 0xE0, 0xD8, 0x48, 0x3A, 0xB0, 0x8D,
  0x38, 0x91, 0x1E, 0x60, 0x1D, 0xB3, 0x4C, 0xD3, 0x84, 0x2A, 0xEE, 0xA1, 0x10,
  // "×" (U+00D7)
  0x10, 0x73, 0x89, 0x53, 0x51, 0xCA, 0x03, 0xE6, 0x01, 0xCB, 0xE6, 0x38, 0x14, 0xFC, 0x38, 0x95,
  0x3E, 0x7C, 0xA0, 0x1E, 0x60, 0x1C, 0x80, 0x34, 0x02,
  // "Ø" (U+00D8)
  0x70, 0x10, 0x22, 0x8A, 0x12, 0xBE, 0xE9, 0x98, 0x01, 0xEB, 0x44, 0xDF, 0x10, 0x9D, 0x38, 0x49,
  0xF7, 0x0D, 0x82, 0x85, 0x2D, 0xBC, 0x1F, 0x52, 0x8B, 0x1B, 0x67, 0xF2, 0xF4, 0x04, 0xC0, 0x6F,
  0x2F, 0x40, 0xC4, 0x06, 0xF0, 0xF5, 0x5B, 0x28, 0x57, 0xF0, 0xD9, 0xD2, 0x28, 0x4A, 0xC0, 0x8F,
  0x92, 0x89, 0x11, 0xE7, 0x02, 0xFB, 0x44, 0xCD, 0x28, 0x58, 0xAA, 0xEE, 0xA1, 0x20, 0x40, 0x16,
  // "Ù" (U+00D9)
  0x18, 0x12, 0x72, 0x60, 0xA0, 0xC7, 0x0A, 0x06, 0x74, 0x0C, 0x08, 0x38, 0x33, 0xF2, 0xC8, 0x38,
  0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38,
  0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xB9, 0x38, 0x34, 0xF1, 0x9C, 0x38,
  0x90, 0x7E, 0x02, 0xF8, 0x35, 0xE8, 0x28, 0x35, 0xCF, 0xE8, 0x20,
  // "Ú" (U+00DA)
  0x40, 0x70, 0x45, 0x81, 0x7D, 0x14, 0x81, 0x2D, 0x27, 0x40, 0xC0, 0x83, 0x83, 0x3F, 0x2C, 0x83,
  0x83, 0x3F, 0x2C, 0x83, 0x83, 0x3F, 0x2C, 0x83, 0x83, 0x3F, 0x2C, 0x83, 0x83, 0x3F, 0x2C, 0x83,
  0x83, 0x3F, 0x2C, 0x83, 0x83, 0x3F, 0x2C, 0x83, 0x83, 0x3F, 0x2B, 0x93, 0x83, 0x4F, 0x19, 0xC3,
  0x89, 0x07, 0xE0, 0x2F, 0x83, 0x5E, 0x82, 0x83, 0x5C, 0xFE, 0x82,
  // "Û" (U+00DB)
  0x30, 0x60, 0x55, 0x82, 0x5D, 0xE3, 0x38, 0x32, 0xC1, 0x3C, 0x73, 0x0C, 0x08, 0x38, 0x33, 0xF2,
  0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2,
  0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xB9, 0x38, 0x34, 0xF1,
  0x9C, 0x38, 0x90, 0x7E, 0x02, 0xF8, 0x35, 0xE8, 0x28, 0x35, 0xCF, 0xE8, 0x20,
  // "Ü" (U+00DC)
  0x18, 0x39, 0x70, 0xD3, 0x30, 0x12, 0x01, 0x74, 0x0C, 0x08, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33,
  0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33,
  0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xB9, 0x38, 0x34, 0xF1, 0x9C, 0x38, 0x90,
  0x7E, 0x02, 0xF8, 0x35, 0xE8, 0x28, 0x35, 0xCF, 0xE8, 0x20,
  // "Ý" (U+00DD)
  0x40, 0x70, 0x44, 0x81, 0x7D, 0x13, 0x81, 0x2D, 0x27, 0x20, 0xC0, 0xA3, 0x83, 0x8D, 0x6F, 0x12,
  0x89, 0x5E, 0x81, 0xF6, 0x04, 0xF2, 0x0A, 0xC0, 0xAB, 0x28, 0x34, 0xF4, 0xF5, 0x38, 0x1D, 0xEE,
  0x48, 0x17, 0xF8, 0x48, 0x12, 0xF3, 0x48, 0x12, 0xF3, 0x48, 0x12, 0xF3, 0x48, 0x12, 0xF3, 0x48,
  0x12, 0xF3, 0x20,
  // "Þ" (U+00DE)
  0x0B, 0x0A, 0x50, 0xB0, 0xA5, 0x0B, 0xA8, 0x93, 0xEA, 0x10, 0xBB, 0x35, 0xDB, 0x0B, 0xA2, 0x83,
  0x5F, 0x1B, 0xA2, 0x83, 0x2F, 0x3B, 0xA2, 0x89, 0x14, 0xF1, 0xBA, 0x02, 0xCB, 0x0B, 0xB8, 0x5B,
  0x10, 0xBB, 0x21, 0x30, 0xB0, 0xA5, 0x0B, 0x0A, 0x50,
  // "ß" (U+00DF)
  0x18, 0x95, 0x9E, 0xEA, 0x10, 0x8E, 0x44, 0xD8, 0x0C, 0x82, 0x89, 0x5A, 0xB0, 0xD7, 0x02, 0xE5,
  0x0D, 0x70, 0xD8, 0x28, 0x3D, 0x73, 0xF2, 0x28, 0x3D, 0x70, 0xE9, 0x28, 0x7D, 0x70, 0x3E, 0x90,
  0xD7, 0x28, 0x32, 0xF5, 0xD7, 0x38, 0x95, 0xC8, 0xD7, 0x64, 0x5E, 0x5D, 0x77, 0xEE, 0x91,
  // "à" (U+00E0)
  0x18, 0x12, 0x72, 0x50, 0xA0, 0xC6, 0x0A, 0x06, 0x73, 0x83, 0x4B, 0xED, 0x52, 0x83, 0x57, 0x3A,
  0xE5, 0x81, 0x2F, 0x34, 0x85, 0x1F, 0x30, 0x4C, 0xEA, 0x87, 0x32, 0xF9, 0x33, 0xF3, 0x59, 0x28,
  0x97, 0x2F, 0x33, 0xF6, 0x3A, 0xF3, 0x08, 0xED, 0x4C, 0x30,
  // "á" (U+00E1)
  0x40, 0x70, 0x44, 0x81, 0x7D, 0x13, 0x81, 0x2D, 0x27, 0x38, 0x34, 0xBE, 0xD5, 0x28, 0x35, 0x73,
  0xAE, 0x58, 0x12, 0xF3, 0x48, 0x51, 0xF3, 0x04, 0xCE, 0xA8, 0x73, 0x2F, 0x93, 0x3F, 0x35, 0x92,
  0x89, 0x72, 0xF3, 0x3F, 0x63, 0xAF, 0x30, 0x8E, 0xD4, 0xC3,
  // "â" (U+00E2)
  0x30, 0x60, 0x54, 0x82, 0x5D, 0xE3, 0x28, 0x32, 0xC1, 0x3C, 0x72, 0x83, 0x4B, 0xED, 0x52, 0x83,
  0x57, 0x3A, 0xE5, 0x81, 0x2F, 0x34, 0x85, 0x1F, 0x30, 0x4C, 0xEA, 0x87, 0x32, 0xF9, 0x33, 0xF3,
  0x59, 0x28, 0x97, 0x2F, 0x33, 0xF6, 0x3A, 0xF3, 0x08, 0xED, 0x4C, 0x30,
  // "ã" (U+00E3)
  0x28, 0x95, 0xBD, 0x54, 0x90, 0x3B, 0x5D, 0xF4, 0x01, 0x12, 0x01, 0x28, 0x34, 0xBE, 0xD5, 0x28,
  0x35, 0x73, 0xAE, 0x58, 0x12, 0xF3, 0x48, 0x51, 0xF3, 0x04, 0xCE, 0xA8, 0x73, 0x2F, 0x93, 0x3F,
  0x35, 0x92, 0x89, 0x72, 0xF3, 0x3F, 0x63, 0xAF, 0x30, 0x8E, 0xD4, 0xC3,
  // "ä" (U+00E4)
  0x18, 0x39, 0x70, 0xD3, 0x20, 0x12, 0x01, 0x73, 0x83, 0x4B, 0xED, 0x52, 0x83, 0x57, 0x3A, 0xE5,
  0x81, 0x2F, 0x34, 0x85, 0x1F, 0x30, 0x4C, 0xEA, 0x87, 0x32, 0xF9, 0x33, 0xF3, 0x59, 0x28, 0x97,
  0x2F, 0x33, 0xF6, 0x3A, 0xF3, 0x08, 0xED, 0x4C, 0x30,
  // "å" (U+00E5)
  0x28, 0x1C, 0xE8, 0x38, 0x24, 0xB4, 0xE3, 0x82, 0x1E, 0xFA, 0x50, 0x24, 0x83, 0x4B, 0xED, 0x52,
  0x83, 0x57, 0x3A, 0xE5, 0x81, 0x2F, 0x34, 0x85, 0x1F, 0x30, 0x4C, 0xEA, 0x87, 0x32, 0xF9, 0x33,
  0xF3, 0x59, 0x28, 0x97, 0x2F, 0x33, 0xF6, 0x3A, 0xF3, 0x08, 0xED, 0x4C, 0x30,
  // "æ" (U+00E6)
  0x18, 0x75, 0xCE, 0xC2, 0x8E, 0xD5, 0x28, 0x90, 0x56, 0x3B, 0xEE, 0x47, 0xF1, 0x48, 0x13, 0xF7,
  0x20, 0xC0, 0x74, 0x81, 0x2F, 0x42, 0x84, 0x99, 0x05, 0xCE, 0xE8, 0x93, 0xA2, 0xF9, 0x34, 0xF5,
  0x22, 0x22, 0x59, 0x28, 0x13, 0xF6, 0x48, 0xA4, 0x3F, 0x64, 0xCA, 0xE5, 0x35, 0x30, 0x8E, 0xD6,
  0x07, 0xEE, 0xC2,
  // "ç" (U+00E7)
  0x28, 0x93, 0x9E, 0xE7, 0x09, 0xE5, 0x43, 0x0E, 0x63, 0x81, 0x2F, 0x23, 0x81, 0x3F, 0x13, 0x81,
  0x3F, 0x24, 0x90, 0x64, 0x83, 0xAE, 0x54, 0x52, 0x82, 0xAF, 0xE7, 0x30, 0xD4, 0x81, 0x17, 0xC3,
  0x03, 0x06, 0x93, 0x81, 0xBD, 0x61,
  // "è" (U+00E8)
  0x18, 0x12, 0x72, 0x50, 0xA0, 0xC6, 0x0A, 0x06, 0x74, 0x82, 0xAE, 0xD4, 0x28, 0x79, 0xD4, 0x7F,
  0x10, 0xF5, 0x28, 0x3D, 0x72, 0xF2, 0x28, 0x1A, 0x93, 0xD8, 0x91, 0xA2, 0xF4, 0x22, 0x22, 0x0E,
  0x55, 0x84, 0x8D, 0x53, 0x63, 0x28, 0x38, 0xEE, 0xB2,
  // "é" (U+00E9)
  0x40, 0x70, 0x44, 0x81, 0x7D, 0x13, 0x81, 0x2D, 0x27, 0x48, 0x2A, 0xED, 0x42, 0x87, 0x9D, 0x47,
  0xF1, 0x0F, 0x52, 0x83, 0xD7, 0x2F, 0x22, 0x81, 0xA9, 0x3D, 0x89, 0x1A, 0x2F, 0x42, 0x22, 0x20,
  0xE5, 0x58, 0x48, 0xD5, 0x36, 0x32, 0x83, 0x8E, 0xEB, 0x20,
  // "ê" (U+00EA)
  0x30, 0x60, 0x54, 0x82, 0x5D, 0xE3, 0x28, 0x32, 0xC1, 0x3C, 0x73, 0x82, 0xAE, 0xD4, 0x28, 0x79,
  0xD4, 0x7F, 0x10, 0xF5, 0x28, 0x3D, 0x72, 0xF2, 0x28, 0x1A, 0x93, 0xD8, 0x91, 0xA2, 0xF4, 0x22,
  0x22, 0x0E, 0x55, 0x84, 0x8D, 0x53, 0x63, 0x28, 0x38, 0xEE, 0xB2,
  // "ë" (U+00EB)
  0x18, 0x39, 0x70, 0xD3, 0x20, 0x12, 0x01, 0x74, 0x82, 0xAE, 0xD4, 0x28, 0x79, 0xD4, 0x7F, 0x10,
  0xF5, 0x28, 0x3D, 0x72, 0xF2, 0x28, 0x1A, 0x93, 0xD8, 0x91, 0xA2, 0xF4, 0x22, 0x22, 0x0E, 0x55,
  0x84, 0x8D, 0x53, 0x63, 0x28, 0x38, 0xEE, 0xB2,
  // "ì" (U+00EC)
  0x81, 0x27, 0x22, 0x0A, 0x0C, 0x30, 0xA0, 0x66, 0x0D, 0x07, 0x20, 0xD0, 0x72, 0x0D, 0x07, 0x20,
  0xD0, 0x72, 0x0D, 0x07, 0x20, 0xD0, 0x72, 0x0D, 0x07, 0x20, 0xD0, 0x72, 0x0D, 0x07,
  // "í" (U+00ED)
  0x28, 0x77, 0x40, 0x7D, 0x12, 0xD2, 0x60, 0xD0, 0x72, 0x0D, 0x07, 0x20, 0xD0, 0x72, 0x0D, 0x07,
  0x20, 0xD0, 0x72, 0x0D, 0x07, 0x20, 0xD0, 0x72, 0x0D, 0x07, 0x20, 0xD0, 0x71,
  // "î" (U+00EE)
  0x20, 0x60, 0x52, 0x87, 0x5D, 0xE3, 0x2C, 0x13, 0xC7, 0x0D, 0x07, 0x30, 0xD0, 0x73, 0x0D, 0x07,
  0x30, 0xD0, 0x73, 0x0D, 0x07, 0x30, 0xD0, 0x73, 0x0D, 0x07, 0x30, 0xD0, 0x73, 0x0D, 0x07, 0x10,
  // "ï" (U+00EF)
  0x84, 0x97, 0x0D, 0x31, 0x20, 0x17, 0x10, 0xD0, 0x73, 0x0D, 0x07, 0x30, 0xD0, 0x73, 0x0D, 0x07,
  0x30, 0xD0, 0x73, 0x0D, 0x07, 0x30, 0xD0, 0x73, 0x0D, 0x07, 0x30, 0xD0, 0x71,
  // "ð" (U+00F0)
  0x28, 0x24, 0x40, 0x74, 0x82, 0x4E, 0xE8, 0x48, 0x29, 0xCE, 0x54, 0x83, 0x40, 0x6E, 0x16, 0x0D,
  0x07, 0x28, 0x41, 0xAE, 0xDB, 0xC2, 0x89, 0x0A, 0xD4, 0x4E, 0xF0, 0x1F, 0x52, 0x84, 0x6F, 0x13,
  0xF1, 0x28, 0x43, 0xF2, 0x3F, 0x12, 0x84, 0x3F, 0x10, 0xF5, 0x20, 0x60, 0xE2, 0x84, 0x9D, 0x44,
  0xD8, 0x38, 0x29, 0xEE, 0x92,
  // "ñ" (U+00F1)
  0x18, 0x93, 0xBD, 0x54, 0x93, 0xB5, 0xDF, 0x41, 0x12, 0x89, 0x61, 0x0D, 0x5A, 0xEC, 0x2D, 0xE7,
  0x3D, 0xAD, 0xB2, 0x82, 0x6E, 0xD8, 0x28, 0x25, 0xFD, 0x72, 0x82, 0x5F, 0xD7, 0x28, 0x25, 0xFD,
  0x72, 0x82, 0x5F, 0xD7, 0x28, 0x25, 0xFD, 0x72, 0x05, 0x90,
  // "ò" (U+00F2)
  0x18, 0x12, 0x72, 0x60, 0xA0, 0xC7, 0x0A, 0x06, 0x76, 0x82, 0x9E, 0xE8, 0x38, 0x49, 0xD4, 0x5E,
  0x72, 0x0E, 0x05, 0x28, 0x47, 0xD0, 0x2F, 0x22, 0x84, 0x4F, 0x13, 0xF1, 0x28, 0x43, 0xF2, 0x2F,
  0x22, 0x04, 0x92, 0x0E, 0x05, 0x20, 0x70, 0xD2, 0x84, 0x8D, 0x45, 0xE6, 0x38, 0x29, 0xEE, 0x82,
  // "ó" (U+00F3)
  0x40, 0x70, 0x45, 0x81, 0x7D, 0x14, 0x81, 0x2D, 0x27, 0x68, 0x29, 0xEE, 0x83, 0x84, 0x9D, 0x45,
  0xE7, 0x20, 0xE0, 0x52, 0x84, 0x7D, 0x02, 0xF2, 0x28, 0x44, 0xF1, 0x3F, 0x12, 0x84, 0x3F, 0x22,
  0xF2, 0x20, 0x49, 0x20, 0xE0, 0x52, 0x07, 0x0D, 0x28, 0x48, 0xD4, 0x5E, 0x63, 0x82, 0x9E, 0xE8,
  0x20,
  // "ô" (U+00F4)
  0x30, 0x60, 0x55, 0x82, 0x5D, 0xE3, 0x38, 0x32, 0xC1, 0x3C, 0x75, 0x82, 0x9E, 0xE8, 0x38, 0x49,
  0xD4, 0x5E, 0x72, 0x0E, 0x05, 0x28, 0x47, 0xD0, 0x2F, 0x22, 0x84, 0x4F, 0x13, 0xF1, 0x28, 0x43,
  0xF2, 0x2F, 0x22, 0x04, 0x92, 0x0E, 0x05, 0x20, 0x70, 0xD2, 0x84, 0x8D, 0x45, 0xE6, 0x38, 0x29,
  0xEE, 0x82,
  // "õ" (U+00F5)
  0x28, 0x3B, 0xD5, 0x49, 0x28, 0x43, 0xB5, 0xDF, 0x42, 0x00, 0x12, 0x01, 0x48, 0x29, 0xEE, 0x83,
  0x84, 0x9D, 0x45, 0xE7, 0x20, 0xE0, 0x52, 0x84, 0x7D, 0x02, 0xF2, 0x28, 0x44, 0xF1, 0x3F, 0x12,
  0x84, 0x3F, 0x22, 0xF2, 0x20, 0x49, 0x20, 0xE0, 0x52, 0x07, 0x0D, 0x28, 0x48, 0xD4, 0x5E, 0x63,
  0x82, 0x9E, 0xE8, 0x20,
  // "ö" (U+00F6)
  0x28, 0x39, 0x70, 0xD3, 0x30, 0x12, 0x01, 0x75, 0x82, 0x9E, 0xE8, 0x38, 0x49, 0xD4, 0x5E, 0x72,
  0x0E, 0x05, 0x28, 0x47, 0xD0, 0x2F, 0x22, 0x84, 0x4F, 0x13, 0xF1, 0x28, 0x43, 0xF2, 0x2F, 0x22,
  0x04, 0x92, 0x0E, 0x05, 0x20, 0x70, 0xD2, 0x84, 0x8D, 0x45, 0xE6, 0x38, 0x29, 0xEE, 0x82,
  // "÷" (U+00F7)
  0x30, 0xC0, 0x65, 0x0D, 0x06, 0x72, 0x06, 0xD0, 0xE0, 0x18, 0x02, 0x27, 0x30, 0xD0, 0x65, 0x0D,
  0x06, 0x20,
  // "ø" (U+00F8)
  0x60, 0x53, 0x83, 0x9E, 0xD9, 0xC2, 0x84, 0x9D, 0x45, 0xF7, 0x29, 0x8B, 0x25, 0x05, 0xEC, 0x03,
  0xF2, 0x0D, 0x6F, 0x04, 0xF1, 0x78, 0x2F, 0x12, 0xF3, 0xD0, 0x39, 0x28, 0x4E, 0xD5, 0x07, 0xD2,
  0x84, 0x8F, 0x45, 0xE6, 0x28, 0x3B, 0xBE, 0xE8, 0x30, 0x86,
  // "ù" (U+00F9)
  0x81, 0x27, 0x24, 0x0A, 0x0C, 0x50, 0xA0, 0x67, 0x10, 0xE0, 0x62, 0x82, 0x6E, 0xE6, 0x28, 0x26,
  0xEE, 0x62, 0x82, 0x6E, 0xE6, 0x28, 0x26, 0xEE, 0x62, 0x82, 0x6E, 0xE6, 0x28, 0x27, 0xEC, 0x72,
  0x89, 0x49, 0xE9, 0xC1, 0x4E, 0xE1, 0xBE, 0xC5, 0xE0,
  // "ú" (U+00FA)
  0x40, 0x70, 0x43, 0x81, 0x7D, 0x12, 0x81, 0x2D, 0x27, 0x0E, 0x06, 0x28, 0x26, 0xEE, 0x62, 0x82,
  0x6E, 0xE6, 0x28, 0x26, 0xEE, 0x62, 0x82, 0x6E, 0xE6, 0x28, 0x26, 0xEE, 0x62, 0x82, 0x7E, 0xC7,
  0x28, 0x94, 0x9E, 0x9C, 0x14, 0xEE, 0x1B, 0xEC, 0x5E,
  // "û" (U+00FB)
  0x20, 0x60, 0x53, 0x89, 0x05, 0xDE, 0x30, 0x2C, 0x13, 0xC7, 0x0E, 0x06, 0x28, 0x26, 0xEE, 0x62,
  0x82, 0x6E, 0xE6, 0x28, 0x26, 0xEE, 0x62, 0x82, 0x6E, 0xE6, 0x28, 0x26, 0xEE, 0x62, 0x82, 0x7E,
  0xC7, 0x28, 0x94, 0x9E, 0x9C, 0x14, 0xEE, 0x1B, 0xEC, 0x5E,
  // "ü" (U+00FC)
  0x18, 0x59, 0x70, 0xD3, 0x01, 0x20, 0x17, 0x0E, 0x06, 0x28, 0x26, 0xEE, 0x62, 0x82, 0x6E, 0xE6,
  0x28, 0x26, 0xEE, 0x62, 0x82, 0x6E, 0xE6, 0x28, 0x26, 0xEE, 0x62, 0x82, 0x7E, 0xC7, 0x28, 0x94,
  0x9E, 0x9C, 0x14, 0xEE, 0x1B, 0xEC, 0x5E,
  // "ý" (U+00FD)
  0x40, 0x70, 0x44, 0x81, 0x7D, 0x13, 0x81, 0x2D, 0x27, 0x20, 0xC0, 0x83, 0x82, 0xE6, 0x8D, 0x28,
  0x73, 0xF1, 0x3F, 0x10, 0x7D, 0x28, 0x3E, 0x50, 0xB8, 0x28, 0x3A, 0x90, 0xE4, 0x28, 0x15, 0xD3,
  0x93, 0x82, 0x1F, 0x9B, 0x48, 0x1B, 0xE6, 0x48, 0x17, 0xF2, 0x40, 0x70, 0xD5, 0x0B, 0x09, 0x38,
  0x22, 0x6F, 0x33, 0x81, 0xBE, 0x64,
  // "þ" (U+00FE)
  0x0D, 0x07, 0x50, 0xD0, 0x75, 0x0D, 0x07, 0x58, 0x96, 0xD7, 0xAF, 0xC2, 0x0D, 0xE6, 0x4C, 0xC0,
  0xDB, 0x28, 0x33, 0xF2, 0xD8, 0x39, 0x81, 0x5D, 0x73, 0x98, 0x16, 0xD8, 0x28, 0x31, 0xF4, 0xDB,
  0x28, 0xA1, 0x3F, 0x2D, 0xE7, 0x3C, 0xC0, 0xD7, 0xAF, 0xC2, 0x0D, 0x75, 0x0D, 0x07, 0x50, 0xD0,
  0x75, 0x0D, 0x07, 0x50,
  // "ÿ" (U+00FF)
  0x18, 0x39, 0x70, 0xD3, 0x20, 0x12, 0x01, 0x72, 0x0C, 0x08, 0x38, 0x2E, 0x68, 0xD2, 0x87, 0x3F,
  0x13, 0xF1, 0x07, 0xD2, 0x83, 0xE5, 0x0B, 0x82, 0x83, 0xA9, 0x0E, 0x42, 0x81, 0x5D, 0x39, 0x38,
  0x21, 0xF9, 0xB4, 0x81, 0xBE, 0x64, 0x81, 0x7F, 0x24, 0x07, 0x0D, 0x50, 0xB0, 0x93, 0x82, 0x26,
  0xF3, 0x38, 0x1B, 0xE6, 0x40,
  // "Ā" (U+0100)
  0x10, 0x5B, 0x0C, 0x30, 0x18, 0x00, 0x25, 0x0D, 0x0E, 0x58, 0x22, 0xFE, 0x34, 0x82, 0x6C, 0xB7,
  0x48, 0x2A, 0x97, 0xB4, 0x81, 0xE5, 0x49, 0x38, 0x43, 0xF1, 0x0F, 0x42, 0x84, 0x7D, 0x11, 0xC9,
  0x20, 0xCC, 0x0D, 0x29, 0x87, 0x73, 0x36, 0xF2, 0x5F, 0x13, 0x98, 0x16, 0x9C, 0x48, 0x2B, 0xAD,
  0x84, 0x07, 0x0E,
  // "ā" (U+0101)
  0x10, 0x5B, 0x0C, 0x20, 0x18, 0x00, 0x22, 0x83, 0x4B, 0xED, 0x52, 0x83, 0x57, 0x3A, 0xE5, 0x81,
  0x2F, 0x34, 0x85, 0x1F, 0x30, 0x4C, 0xEA, 0x87, 0x32, 0xF9, 0x33, 0xF3, 0x59, 0x28, 0x97, 0x2F,
  0x33, 0xF6, 0x3A, 0xF3, 0x08, 0xED, 0x4C, 0x30,
  // "Ă" (U+0102)
  0x18, 0x33, 0x91, 0x39, 0x40, 0xCA, 0x05, 0x50, 0x27, 0x0D, 0x0E, 0x58, 0x22, 0xFE, 0x34, 0x82,
  0x6C, 0xB7, 0x48, 0x2A, 0x97, 0xB4, 0x81, 0xE5, 0x49, 0x38, 0x43, 0xF1, 0x0F, 0x42, 0x84, 0x7D,
  0x11, 0xC9, 0x20, 0xCC, 0x0D, 0x29, 0x87, 0x73, 0x36, 0xF2, 0x5F, 0x13, 0x98, 0x16, 0x9C, 0x48,
  0x2B, 0xAD, 0x84, 0x07, 0x0E,
  // "ă" (U+0103)
  0x18, 0x33, 0x91, 0x39, 0x30, 0xCA, 0x05, 0x40, 0x24, 0x83, 0x4B, 0xED, 0x52, 0x83, 0x57, 0x3A,
  0xE5, 0x81, 0x2F, 0x34, 0x85, 0x1F, 0x30, 0x4C, 0xEA, 0x87, 0x32, 0xF9, 0x33, 0xF3, 0x59, 0x28,
  0x97, 0x2F, 0x33, 0xF6, 0x3A, 0xF3, 0x08, 0xED, 0x4C, 0x30,
  // "Ą" (U+0104)
  0x30, 0xD0, 0xE5, 0x82, 0x2F, 0xE3, 0x48, 0x26, 0xCB, 0x74, 0x82, 0xA9, 0x7B, 0x48, 0x1E, 0x54,
  0x93, 0x84, 0x3F, 0x10, 0xF4, 0x28, 0x47, 0xD1, 0x1C, 0x92, 0x0C, 0xC0, 0xD2, 0x98, 0x77, 0x33,
  0x6F, 0x25, 0xF1, 0x39, 0x81, 0x69, 0xC4, 0x82, 0xBA, 0xD8, 0x40, 0x70, 0xE6, 0x00, 0x55, 0x01,
  0x0D, 0x60, 0x50, 0xD6, 0x02, 0x0E, 0x96, 0x00, 0x10,
  // "ą" (U+0105)
  0x18, 0x34, 0xBE, 0xD5, 0x28, 0x35, 0x73, 0xAE, 0x58, 0x12, 0xF3, 0x48, 0x51, 0xF3, 0x04, 0xCE,
  0xA8, 0x73, 0x2F, 0x93, 0x3F, 0x35, 0x92, 0x89, 0x72, 0xF3, 0x3F, 0x63, 0xAF, 0x30, 0x8E, 0xD4,
  0xC3, 0x40, 0x05, 0x40, 0x10, 0xD5, 0x05, 0x0D, 0x50, 0x20, 0xE9, 0x50, 0x01, 0x10,
  // "Ć" (U+0106)
  0x50, 0x70, 0x45, 0x81, 0x7D, 0x14, 0x81, 0x2D, 0x27, 0x58, 0x41, 0x9D, 0xEC, 0x42, 0x89, 0x0C,
  0xD5, 0x37, 0x30, 0x7F, 0x25, 0x0C, 0x09, 0x69, 0x06, 0x58, 0x11, 0xF4, 0x58, 0x11, 0xF5, 0x69,
  0x06, 0x60, 0xD0, 0xA6, 0x81, 0x7F, 0x16, 0x84, 0xDD, 0x53, 0x52, 0x28, 0x41, 0x9E, 0xFC, 0x20,
  // "ć" (U+0107)
  0x40, 0x70, 0x43, 0x81, 0x7D, 0x12, 0x81, 0x2D, 0x27, 0x28, 0x93, 0x9E, 0xE7, 0x09, 0xE5, 0x43,
  0x0E, 0x63, 0x81, 0x2F, 0x23, 0x81, 0x3F, 0x13, 0x81, 0x3F, 0x24, 0x90, 0x64, 0x83, 0xAE, 0x54,
  0x52, 0x82, 0xAE, 0xE7,
  // "Ĉ" (U+0108)
  0x40, 0x60, 0x55, 0x82, 0x5D, 0xE3, 0x38, 0x32, 0xC1, 0x3C, 0x74, 0x84, 0x19, 0xDE, 0xC4, 0x28,
  0x90, 0xCD, 0x53, 0x73, 0x07, 0xF2, 0x50, 0xC0, 0x96, 0x90, 0x65, 0x81, 0x1F, 0x45, 0x81, 0x1F,
  0x56, 0x90, 0x66, 0x0D, 0x0A, 0x68, 0x17, 0xF1, 0x68, 0x4D, 0xD5, 0x35, 0x22, 0x84, 0x19, 0xEF,
  0xC2,
  // "ĉ" (U+0109)
  0x30, 0x60, 0x53, 0x89, 0x05, 0xDE, 0x30, 0x2C, 0x13, 0xC7, 0x18, 0x93, 0x9E, 0xE7, 0x09, 0xE5,
  0x43, 0x0E, 0x63, 0x81, 0x2F, 0x23, 0x81, 0x3F, 0x13, 0x81, 0x3F, 0x24, 0x90, 0x64, 0x83, 0xAE,
  0x54, 0x52, 0x82, 0xAE, 0xE7,
  // "Ċ" (U+010A)
  0x40, 0x20, 0xB6, 0x81, 0x3D, 0x17, 0x48, 0x41, 0x9D, 0xEC, 0x42, 0x89, 0x0C, 0xD5, 0x37, 0x30,
  0x7F, 0x25, 0x0C, 0x09, 0x69, 0x06, 0x58, 0x11, 0xF4, 0x58, 0x11, 0xF5, 0x69, 0x06, 0x60, 0xD0,
  0xA6, 0x81, 0x7F, 0x16, 0x84, 0xDD, 0x53, 0x52, 0x28, 0x41, 0x9E, 0xFC, 0x20,
  // "ċ" (U+010B)
  0x20, 0x20, 0xB4, 0x81, 0x3D, 0x17, 0x28, 0x93, 0x9E, 0xE7, 0x09, 0xE5, 0x43, 0x0E, 0x63, 0x81,
  0x2F, 0x23, 0x81, 0x3F, 0x13, 0x81, 0x3F, 0x24, 0x90, 0x64, 0x83, 0xAE, 0x54, 0x52, 0x82, 0xAE,
  0xE7,
  // "Č" (U+010C)
  0x20, 0x20, 0x52, 0x06, 0x01, 0x38, 0x2B, 0x79, 0x84, 0x81, 0x1E, 0xC7, 0x58, 0x41, 0x9D, 0xEC,
  0x42, 0x89, 0x0C, 0xD5, 0x37, 0x30, 0x7F, 0x25, 0x0C, 0x09, 0x69, 0x06, 0x58, 0x11, 0xF4, 0x58,
  0x11, 0xF5, 0x69, 0x06, 0x60, 0xD0, 0xA6, 0x81, 0x7F, 0x16, 0x84, 0xDD, 0x53, 0x52, 0x28, 0x41,
  0x9E, 0xFC, 0x20,
  // "č" (U+010D)
  0x10, 0x20, 0x52, 0x06, 0x01, 0x28, 0x2B, 0x79, 0x83, 0x81, 0x1E, 0xC7, 0x48, 0x29, 0xEE, 0x72,
  0x83, 0x9E, 0x54, 0x32, 0x0E, 0x06, 0x48, 0x12, 0xF2, 0x48, 0x13, 0xF1, 0x48, 0x13, 0xF2, 0x59,
  0x06, 0x58, 0x3A, 0xE5, 0x45, 0x38, 0x2A, 0xEE, 0x71,
  // "Ď" (U+010E)
  0x10, 0x20, 0x52, 0x06, 0x01, 0x38, 0x2B, 0x79, 0x84, 0x81, 0x1E, 0xC7, 0x40, 0xBA, 0x81, 0xEB,
  0x32, 0x89, 0x0B, 0xB2, 0x4A, 0xF3, 0x0B, 0xA3, 0x83, 0xBD, 0x0B, 0xA3, 0x83, 0x4F, 0x2B, 0xA3,
  0x83, 0x1F, 0x5B, 0xA4, 0x98, 0x16, 0xBA, 0x49, 0x81, 0x6B, 0xA3, 0x83, 0x1F, 0x5B, 0xA3, 0x83,
  0x5F, 0x2B, 0xA3, 0x89, 0x2B, 0xC0, 0xBB, 0x24, 0xBE, 0x30, 0xBA, 0x81, 0xEB, 0x32,
  // "ď" (U+010F)
  0x58, 0x35, 0xF0, 0xC8, 0x58, 0x35, 0xF0, 0xE3, 0x58, 0x25, 0xF1, 0xA2, 0x83, 0x1B, 0xFB, 0x69,
  0x48, 0x3A, 0xD4, 0x6E, 0x94, 0x90, 0x52, 0x09, 0x93, 0x81, 0x3F, 0x22, 0x05, 0x93, 0x81, 0x3F,
  0x12, 0x05, 0x93, 0x81, 0x3F, 0x22, 0x05, 0x93, 0x81, 0x1F, 0x52, 0x08, 0x94, 0x83, 0xAD, 0x45,
  0xD9, 0x48, 0x31, 0xBF, 0xB3, 0x93,
  // "Đ" (U+0110)
  0x10, 0xAA, 0x81, 0xEB, 0x33, 0x85, 0xAB, 0x24, 0xAF, 0x32, 0x00, 0xA3, 0x0B, 0x0C, 0x20, 0x0A,
  0x38, 0x44, 0xF2, 0x0A, 0xA3, 0x82, 0x1F, 0x59, 0xB0, 0x92, 0x98, 0x46, 0x1B, 0xB2, 0x12, 0x98,
  0x26, 0x0A, 0xA3, 0x84, 0x1F, 0x40, 0xAA, 0x38, 0x45, 0xF1, 0x0A, 0xA3, 0x0B, 0x0C, 0x28, 0x5A,
  0xB2, 0x4B, 0xE3, 0x20, 0xAA, 0x81, 0xEA, 0x32,
  // "đ" (U+0111)
  0x50, 0x59, 0x40, 0x9C, 0x38, 0x91, 0x12, 0x7F, 0x30, 0x1B, 0xFB, 0x69, 0x28, 0x3A, 0xD4, 0x6E,
  0x92, 0x90, 0x52, 0x84, 0x9F, 0x03, 0xF2, 0x28, 0x45, 0xF0, 0x3F, 0x12, 0x84, 0x5F, 0x03, 0xF2,
  0x28, 0x45, 0xF0, 0x1F, 0x52, 0x08, 0x92, 0x83, 0xAD, 0x45, 0xD9, 0x28, 0x31, 0xBF, 0xB3, 0x91,
  // "Ē" (U+0112)
  0x05, 0xB8, 0x7C, 0x01, 0x22, 0x22, 0x0B, 0xC8, 0x76, 0xBB, 0x22, 0x21, 0xBA, 0x40, 0xB0, 0xA4,
  0x0B, 0x0A, 0x40, 0xBC, 0x87, 0x2B, 0xB2, 0x22, 0x0B, 0xA4, 0x0B, 0x0A, 0x40, 0xB0, 0xA4, 0x85,
  0xBB, 0x22, 0x21, 0xBC, 0x06,
  // "ē" (U+0113)
  0x10, 0x5B, 0x0C, 0x20, 0x18, 0x00, 0x23, 0x82, 0xAE, 0xD4, 0x28, 0x79, 0xD4, 0x7F, 0x10, 0xF5,
  0x28, 0x3D, 0x72, 0xF2, 0x28, 0x1A, 0x93, 0xD8, 0x91, 0xA2, 0xF4, 0x22, 0x22, 0x0E, 0x55, 0x84,
  0x8D, 0x53, 0x63, 0x28, 0x38, 0xEE, 0xB2,
  // "Ĕ" (U+0114)
  0x83, 0x39, 0x13, 0x92, 0x0C, 0xA0, 0x53, 0x02, 0x30, 0xBC, 0x87, 0x6B, 0xB2, 0x22, 0x1B, 0xA4,
  0x0B, 0x0A, 0x40, 0xB0, 0xA4, 0x0B, 0xC8, 0x72, 0xBB, 0x22, 0x20, 0xBA, 0x40, 0xB0, 0xA4, 0x0B,
  0x0A, 0x48, 0x5B, 0xB2, 0x22, 0x1B, 0xC0, 0x60,
  // "ĕ" (U+0115)
  0x18, 0x33, 0x91, 0x39, 0x30, 0xCA, 0x05, 0x40, 0x25, 0x82, 0xAE, 0xD4, 0x28, 0x79, 0xD4, 0x7F,
  0x10, 0xF5, 0x28, 0x3D, 0x72, 0xF2, 0x28, 0x1A, 0x93, 0xD8, 0x91, 0xA2, 0xF4, 0x22, 0x22, 0x0E,
  0x55, 0x84, 0x8D, 0x53, 0x63, 0x28, 0x38, 0xEE, 0xB2,
  // "Ė" (U+0116)
  0x20, 0x20, 0xB4, 0x81, 0x3D, 0x17, 0x0B, 0xC8, 0x76, 0xBB, 0x22, 0x21, 0xBA, 0x40, 0xB0, 0xA4,
  0x0B, 0x0A, 0x40, 0xBC, 0x87, 0x2B, 0xB2, 0x22, 0x0B, 0xA4, 0x0B, 0x0A, 0x40, 0xB0, 0xA4, 0x85,
  0xBB, 0x22, 0x21, 0xBC, 0x06,
  // "ė" (U+0117)
  0x20, 0x20, 0xB5, 0x81, 0x3D, 0x17, 0x48, 0x2A, 0xED, 0x42, 0x87, 0x9D, 0x47, 0xF1, 0x0F, 0x52,
  0x83, 0xD7, 0x2F, 0x22, 0x81, 0xA9, 0x3D, 0x89, 0x1A, 0x2F, 0x42, 0x22, 0x20, 0xE5, 0x58, 0x48,
  0xD5, 0x36, 0x32, 0x83, 0x8E, 0xEB, 0x20,
  // "Ę" (U+0118)
  0x0B, 0xC8, 0x76, 0xBB, 0x22, 0x21, 0xBA, 0x40, 0xB0, 0xA4, 0x0B, 0x0A, 0x40, 0xBC, 0x87, 0x2B,
  0xB2, 0x22, 0x0B, 0xA4, 0x0B, 0x0A, 0x40, 0xB0, 0xA4, 0x85, 0xBB, 0x22, 0x21, 0xBC, 0x06, 0x30,
  0x05, 0x30, 0x10, 0xD4, 0x05, 0x0D, 0x40, 0x20, 0xE9, 0x40, 0x01, 0x10,
  // "ę" (U+0119)
  0x28, 0x2A, 0xED, 0x42, 0x87, 0x9D, 0x47, 0xF1, 0x0F, 0x52, 0x83, 0xD7, 0x2F, 0x22, 0x81, 0xA9,
  0x3D, 0x89, 0x1A, 0x2F, 0x42, 0x22, 0x20, 0xE5, 0x58, 0x48, 0xD5, 0x36, 0x32, 0x08, 0x0E, 0xA0,
  0x34, 0x00, 0x75, 0x0E, 0x01, 0x48, 0x21, 0xF4, 0x14, 0x81, 0xAE, 0x30,
  // "Ě" (U+011A)
  0x02, 0x05, 0x28, 0x56, 0x10, 0xB7, 0x98, 0x28, 0x11, 0xEC, 0x71, 0x0B, 0xC8, 0x76, 0xBB, 0x22,
  0x21, 0xBA, 0x40, 0xB0, 0xA4, 0x0B, 0x0A, 0x40, 0xBC, 0x87, 0x2B, 0xB2, 0x22, 0x0B, 0xA4, 0x0B,
  0x0A, 0x40, 0xB0, 0xA4, 0x85, 0xBB, 0x22, 0x21, 0xBC, 0x06,
  // "ě" (U+011B)
  0x10, 0x20, 0x52, 0x06, 0x01, 0x28, 0x2B, 0x79, 0x83, 0x81, 0x1E, 0xC7, 0x48, 0x2A, 0xED, 0x42,
  0x87, 0x9D, 0x47, 0xF1, 0x0F, 0x52, 0x83, 0xD7, 0x2F, 0x22, 0x81, 0xA9, 0x3D, 0x89, 0x1A, 0x2F,
  0x42, 0x22, 0x20, 0xE5, 0x58, 0x48, 0xD5, 0x36, 0x32, 0x83, 0x8E, 0xEB, 0x20,
  // "Ĝ" (U+011C)
  0x40, 0x60, 0x56, 0x82, 0x5D, 0xE3, 0x48, 0x32, 0xC1, 0x3C, 0x77, 0x84, 0x7D, 0xED, 0xA2, 0x28,
  0x91, 0xBE, 0x63, 0x5A, 0x20, 0x6F, 0x26, 0x0C, 0x0A, 0x79, 0x06, 0x68, 0x11, 0xF4, 0x68, 0x11,
  0xF4, 0x20, 0x9A, 0x82, 0x90, 0xF6, 0x28, 0x51, 0x2B, 0x90, 0xC9, 0x48, 0x4A, 0x90, 0x7F, 0x23,
  0x0A, 0x09, 0x28, 0x5C, 0xD6, 0x34, 0xC9, 0x28, 0x51, 0x8D, 0xFE, 0xB5,
  // "ĝ" (U+011D)
  0x30, 0x60, 0x54, 0x82, 0x5D, 0xE3, 0x28, 0x32, 0xC1, 0x3C, 0x72, 0x89, 0x61, 0xBF, 0xB4, 0xF0,
  0xAD, 0x46, 0xDF, 0x0F, 0x52, 0x83, 0x9F, 0x3F, 0x22, 0x83, 0x6F, 0x3F, 0x12, 0x83, 0x5F, 0x2F,
  0x22, 0x83, 0x5F, 0x0F, 0x52, 0x89, 0x58, 0xF0, 0xAD, 0x45, 0xDF, 0x01, 0xBF, 0xB6, 0x95, 0x05,
  0x0E, 0x58, 0x95, 0x8C, 0x08, 0x53, 0x6E, 0x60, 0x7D, 0xFD, 0x71,
  // "Ğ" (U+011E)
  0x38, 0x33, 0x91, 0x39, 0x50, 0xCA, 0x05, 0x60, 0x26, 0x84, 0x7D, 0xED, 0xA2, 0x28, 0x91, 0xBE,
  0x63, 0x5A, 0x20, 0x6F, 0x26, 0x0C, 0x0A, 0x79, 0x06, 0x68, 0x11, 0xF4, 0x68, 0x11, 0xF4, 0x20,
  0x9A, 0x82, 0x90, 0xF6, 0x28, 0x51, 0x2B, 0x90, 0xC9, 0x48, 0x4A, 0x90, 0x7F, 0x23, 0x0A, 0x09,
  0x28, 0x5C, 0xD6, 0x34, 0xC9, 0x28, 0x51, 0x8D, 0xFE, 0xB5,
  // "ğ" (U+011F)
  0x18, 0x33, 0x91, 0x39, 0x30, 0xCA, 0x05, 0x40, 0x24, 0x89, 0x61, 0xBF, 0xB4, 0xF0, 0xAD, 0x46,
  0xDF, 0x0F, 0x52, 0x83, 0x9F, 0x3F, 0x22, 0x83, 0x6F, 0x3F, 0x12, 0x83, 0x5F, 0x2F, 0x22, 0x83,
  0x5F, 0x0F, 0x52, 0x89, 0x58, 0xF0, 0xAD, 0x45, 0xDF, 0x01, 0xBF, 0xB6, 0x95, 0x05, 0x0E, 0x58,
  0x95, 0x8C, 0x08, 0x53, 0x6E, 0x60, 0x7D, 0xFD, 0x71,
  // "Ġ" (U+0120)
  0x40, 0x20, 0xB7, 0x81, 0x3D, 0x17, 0x78, 0x47, 0xDE, 0xDA, 0x22, 0x89, 0x1B, 0xE6, 0x35, 0xA2,
  0x06, 0xF2, 0x60, 0xC0, 0xA7, 0x90, 0x66, 0x81, 0x1F, 0x46, 0x81, 0x1F, 0x42, 0x09, 0xA8, 0x29,
  0x0F, 0x62, 0x85, 0x12, 0xB9, 0x0C, 0x94, 0x84, 0xA9, 0x07, 0xF2, 0x30, 0xA0, 0x92, 0x85, 0xCD,
  0x63, 0x4C, 0x92, 0x85, 0x18, 0xDF, 0xEB, 0x50,
  // "ġ" (U+0121)
  0x30, 0x20, 0xB5, 0x81, 0x3D, 0x17, 0x28, 0x96, 0x1B, 0xFB, 0x4F, 0x0A, 0xD4, 0x6D, 0xF0, 0xF5,
  0x28, 0x39, 0xF3, 0xF2, 0x28, 0x36, 0xF3, 0xF1, 0x28, 0x35, 0xF2, 0xF2, 0x28, 0x35, 0xF0, 0xF5,
  0x28, 0x95, 0x8F, 0x0A, 0xD4, 0x5D, 0xF0, 0x1B, 0xFB, 0x69, 0x50, 0x50, 0xE5, 0x89, 0x58, 0xC0,
  0x85, 0x36, 0xE6, 0x07, 0xDF, 0xD7, 0x10,
  // "Ģ" (U+0122)
  0x38, 0x47, 0xDE, 0xDA, 0x22, 0x89, 0x1B, 0xE6, 0x35, 0xA2, 0x06, 0xF2, 0x60, 0xC0, 0xA7, 0x90,
  0x66, 0x81, 0x1F, 0x46, 0x81, 0x1F, 0x42, 0x09, 0xA8, 0x29, 0x0F, 0x62, 0x85, 0x12, 0xB9, 0x0C,
  0x94, 0x84, 0xA9, 0x07, 0xF2, 0x30, 0xA0, 0x92, 0x85, 0xCD, 0x63, 0x4C, 0x92, 0x85, 0x18, 0xDF,
  0xEB, 0x57, 0x70, 0xA0, 0x77, 0x0E, 0x03, 0x60, 0x20, 0xB3,
  // "ģ" (U+0123)
  0x30, 0x40, 0xA5, 0x0C, 0x05, 0x48, 0x11, 0xD2, 0x38, 0x96, 0x1B, 0xFB, 0x4F, 0x0A, 0xD4, 0x6D,
  0xF0, 0xF5, 0x28, 0x39, 0xF3, 0xF2, 0x28, 0x36, 0xF3, 0xF1, 0x28, 0x35, 0xF2, 0xF2, 0x28, 0x35,
  0xF0, 0xF5, 0x28, 0x95, 0x8F, 0x0A, 0xD4, 0x5D, 0xF0, 0x1B, 0xFB, 0x69, 0x50, 0x50, 0xE5, 0x89,
  0x58, 0xC0, 0x85, 0x36, 0xE6, 0x07, 0xDF, 0xD7, 0x10,
  // "Ĥ" (U+0124)
  0x30, 0x60, 0x55, 0x82, 0x5D, 0xE3, 0x38, 0x32, 0xC1, 0x3C, 0x73, 0x0B, 0x0A, 0x38, 0x31, 0xF3,
  0xBA, 0x38, 0x31, 0xF3, 0xBA, 0x38, 0x31, 0xF3, 0xBA, 0x38, 0x31, 0xF3, 0xBA, 0x38, 0x21, 0xF3,
  0xBE, 0x89, 0x13, 0xBB, 0x22, 0x24, 0xF3, 0xBA, 0x38, 0x31, 0xF3, 0xBA, 0x38, 0x31, 0xF3, 0xBA,
  0x38, 0x31, 0xF3, 0xBA, 0x38, 0x31, 0xF3, 0xBA, 0x38, 0x11, 0xF3,
  // "ĥ" (U+0125)
  0x20, 0x60, 0x55, 0x82, 0x5D, 0xE3, 0x38, 0x32, 0xC1, 0x3C, 0x77, 0x70, 0xD0, 0x76, 0x0D, 0x07,
  0x60, 0xD0, 0x76, 0x84, 0xD7, 0xAE, 0xC2, 0x28, 0x4D, 0xE7, 0x3C, 0xA2, 0x0D, 0x0B, 0x20, 0x60,
  0xE2, 0x0D, 0x08, 0x20, 0x59, 0x20, 0xD0, 0x72, 0x05, 0x92, 0x0D, 0x07, 0x20, 0x59, 0x20, 0xD0,
  0x72, 0x05, 0x92, 0x0D, 0x07, 0x20, 0x59, 0x20, 0xD0, 0x72, 0x05, 0x90,
  // "Ħ" (U+0126)
  0x10, 0xB0, 0x93, 0x81, 0x2F, 0x32, 0x0B, 0x09, 0x38, 0x12, 0xF3, 0x1F, 0xA8, 0x94, 0x82, 0xBB,
  0x22, 0x24, 0xF5, 0x10, 0xBA, 0x38, 0x11, 0xF3, 0x20, 0xBE, 0x03, 0x28, 0x6B, 0xB2, 0x22, 0x4F,
  0x32, 0x0B, 0x09, 0x38, 0x12, 0xF3, 0x20, 0xB0, 0x93, 0x81, 0x2F, 0x32, 0x0B, 0x09, 0x38, 0x12,
  0xF3, 0x20, 0xB0, 0x93, 0x81, 0x2F, 0x32, 0x0B, 0x09, 0x38, 0x12, 0xF3, 0x10,
  // "ħ" (U+0127)
  0x10, 0xD0, 0x74, 0x0D, 0xB0, 0xB2, 0x83, 0x2D, 0x82, 0x23, 0x89, 0x6D, 0x7A, 0xEC, 0x20, 0xDE,
  0x73, 0xDA, 0x0D, 0xB2, 0x83, 0x6D, 0x0D, 0x82, 0x83, 0x5F, 0x0D, 0x72, 0x83, 0x5F, 0x0D, 0x72,
  0x83, 0x5F, 0x0D, 0x72, 0x83, 0x5F, 0x0D, 0x72, 0x83, 0x5F, 0x0D, 0x72, 0x05, 0x90,
  // "Ĩ" (U+0128)
  0x18, 0x93, 0xBD, 0x54, 0x93, 0xB5, 0xDF, 0x41, 0x12, 0x01, 0x20, 0x6B, 0x02, 0x28, 0x15, 0xF2,
  0x38, 0x14, 0xF1, 0x38, 0x14, 0xF1, 0x38, 0x14, 0xF1, 0x38, 0x14, 0xF1, 0x38, 0x14, 0xF1, 0x38,
  0x14, 0xF1, 0x38, 0x14, 0xF1, 0x38, 0x14, 0xF1, 0x38, 0x14, 0xF1, 0x20, 0x5B, 0x02,
  // "ĩ" (U+0129)
  0x18, 0x93, 0xBD, 0x54, 0x93, 0xB5, 0xDF, 0x41, 0x12, 0x01, 0x30, 0xD0, 0x74, 0x0D, 0x07, 0x40,
  0xD0, 0x74, 0x0D, 0x07, 0x40, 0xD0, 0x74, 0x0D, 0x07, 0x40, 0xD0, 0x74, 0x0D, 0x07, 0x40, 0xD0,
  0x72,
  // "Ī" (U+012A)
  0x05, 0xB8, 0x5C, 0x12, 0x22, 0x26, 0xB8, 0x32, 0x05, 0xF2, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1,
  0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28,
  0x14, 0xF1, 0x28, 0x34, 0xF1, 0x05, 0xB0, 0x20,
  // "ī" (U+012B)
  0x05, 0xB0, 0xC0, 0x18, 0x00, 0x22, 0x0D, 0x07, 0x30, 0xD0, 0x73, 0x0D, 0x07, 0x30, 0xD0, 0x73,
  0x0D, 0x07, 0x30, 0xD0, 0x73, 0x0D, 0x07, 0x30, 0xD0, 0x73, 0x0D, 0x07, 0x10,
  // "Ĭ" (U+012C)
  0x85, 0x39, 0x13, 0x90, 0xCA, 0x05, 0x20, 0x22, 0x06, 0xB8, 0x32, 0x05, 0xF2, 0x28, 0x14, 0xF1,
  0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28,
  0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x34, 0xF1, 0x05, 0xB0, 0x20,
  // "ĭ" (U+012D)
  0x85, 0x39, 0x13, 0x90, 0xCA, 0x05, 0x20, 0x24, 0x0D, 0x07, 0x30, 0xD0, 0x73, 0x0D, 0x07, 0x30,
  0xD0, 0x73, 0x0D, 0x07, 0x30, 0xD0, 0x73, 0x0D, 0x07, 0x30, 0xD0, 0x73, 0x0D, 0x07, 0x10,
  // "Į" (U+012E)
  0x06, 0xB8, 0x32, 0x05, 0xF2, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14,
  0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x34, 0xF1,
  0x05, 0xB0, 0x22, 0x00, 0x52, 0x01, 0x0D, 0x30, 0x50, 0xD3, 0x02, 0x0E, 0x93, 0x00, 0x11,
  // "į" (U+012F)
  0x18, 0x3C, 0x60, 0x95, 0x48, 0xC7, 0xD7, 0x0D, 0x70, 0xD7, 0x0D, 0x70, 0xD7, 0x0D, 0x70, 0xD7,
  0x0D, 0x70, 0xD7, 0x05, 0x51, 0xD0, 0x5D, 0x02, 0xEF, 0x01, 0x10,
  // "İ" (U+0130)
  0x10, 0x20, 0xB3, 0x81, 0x3D, 0x16, 0x06, 0xB8, 0x32, 0x05, 0xF2, 0x28, 0x14, 0xF1, 0x28, 0x14,
  0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1, 0x28, 0x14, 0xF1,
  0x28, 0x14, 0xF1, 0x28, 0x34, 0xF1, 0x05, 0xB0, 0x20,
  // "ı" (U+0131)
  0x8A, 0x0D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x7D, 0x70,
  // "Ĳ" (U+0132)
  0x06, 0xB8, 0x62, 0x0B, 0x90, 0x5F, 0x22, 0x84, 0xB9, 0x04, 0xF1, 0x28, 0x4B, 0x90, 0x4F, 0x12,
  0x84, 0xB9, 0x04, 0xF1, 0x28, 0x4B, 0x90, 0x4F, 0x12, 0x84, 0xB9, 0x04, 0xF1, 0x28, 0x4B, 0x90,
  0x4F, 0x12, 0x84, 0xB9, 0x04, 0xF1, 0x28, 0x4B, 0x90, 0x4F, 0x12, 0x84, 0xB9, 0x04, 0xF1, 0x28,
  0x1B, 0x95, 0xB8, 0x22, 0x0B, 0x96, 0x0C, 0x08, 0x58, 0x12, 0xF5, 0x48, 0x1E, 0xFB, 0x50, 0x01,
  0x20,
  // "ĳ" (U+0133)
  0x0C, 0x06, 0x28, 0x2C, 0x69, 0x52, 0x09, 0x05, 0x60, 0xD0, 0x72, 0x82, 0xD7, 0xD7, 0x28, 0x2D,
  0x7D, 0x72, 0x82, 0xD7, 0xD7, 0x28, 0x2D, 0x7D, 0x72, 0x82, 0xD7, 0xD7, 0x28, 0x2D, 0x7D, 0x72,
  0x82, 0xD7, 0xD7, 0x28, 0x2D, 0x7D, 0x72, 0x0D, 0x07, 0x40, 0xD0, 0x74, 0x0D, 0x06, 0x28, 0x21,
  0x4F, 0x42, 0x81, 0x5F, 0xA1,
  // "Ĵ" (U+0134)
  0x20, 0x60, 0x52, 0x87, 0x5D, 0xE3, 0x2C, 0x13, 0xC7, 0x0B, 0x09, 0x30, 0xB0, 0x93, 0x0B, 0x09,
  0x30, 0xB0, 0x93, 0x0B, 0x09, 0x30, 0xB0, 0x93, 0x0B, 0x09, 0x30, 0xB0, 0x93, 0x0B, 0x09, 0x30,
  0xB0, 0x93, 0x0B, 0x09, 0x30, 0xB0, 0x93, 0x0C, 0x08, 0x28, 0x52, 0xF5, 0x0E, 0xFB, 0x20, 0x01,
  0x30,
  // "ĵ" (U+0135)
  0x20, 0x60, 0x52, 0x87, 0x5D, 0xE3, 0x2C, 0x13, 0xC7, 0x0D, 0x07, 0x30, 0xD0, 0x73, 0x0D, 0x07,
  0x30, 0xD0, 0x73, 0x0D, 0x07, 0x30, 0xD0, 0x73, 0x0D, 0x07, 0x30, 0xD0, 0x73, 0x0D, 0x07, 0x30,
  0xD0, 0x73, 0x89, 0x1D, 0x60, 0x14, 0xF4, 0x05, 0xEA, 0x20,
  // "Ķ" (U+0136)
  0x0B, 0x0A, 0x38, 0x2D, 0x8B, 0xA2, 0x89, 0x58, 0xD0, 0xBA, 0x02, 0xF4, 0x0B, 0xA0, 0xBA, 0x28,
  0x3B, 0xA6, 0xE1, 0x28, 0x2B, 0xBE, 0xA3, 0x83, 0xBF, 0xCF, 0x22, 0x83, 0xBB, 0x0D, 0xA2, 0x87,
  0xBA, 0x05, 0xF3, 0x0B, 0xA2, 0x83, 0xCB, 0x0B, 0xA2, 0x83, 0x4F, 0x3B, 0xA3, 0x0C, 0x0B, 0x73,
  0x0A, 0x07, 0x50, 0xE0, 0x34, 0x02, 0x0B, 0x30,
  // "ķ" (U+0137)
  0x0D, 0x07, 0x40, 0xD0, 0x74, 0x0D, 0x07, 0x48, 0xA4, 0xD7, 0x01, 0xE6, 0xD7, 0x0A, 0xB0, 0xD7,
  0x5E, 0x10, 0xD8, 0xE6, 0x28, 0x2D, 0xEE, 0xA2, 0x8A, 0x2D, 0xA3, 0xF3, 0x0D, 0x70, 0xBA, 0x0D,
  0x70, 0x4F, 0x3D, 0x72, 0x0C, 0x0A, 0x71, 0x0A, 0x07, 0x40, 0xE0, 0x33, 0x02, 0x0B, 0x30,
  // "ĸ" (U+0138)
  0x8A, 0x4D, 0x70, 0x1E, 0x6D, 0x70, 0xAB, 0x0D, 0x75, 0xE2, 0x0D, 0x8E, 0x72, 0x82, 0xDE, 0xEB,
  0x28, 0xA2, 0xDB, 0x3F, 0x30, 0xD7, 0x0B, 0xB0, 0xD7, 0x03, 0xF3, 0xD7, 0x20, 0xB0, 0xA0,
  // "Ĺ" (U+0139)
  0x20, 0x70, 0x44, 0x81, 0x7D, 0x13, 0x81, 0x2D, 0x27, 0x50, 0xB0, 0xA5, 0x0B, 0x0A, 0x50, 0xB0,
  0xA5, 0x0B, 0x0A, 0x50, 0xB0, 0xA5, 0x0B, 0x0A, 0x50, 0xB0, 0xA5, 0x0B, 0x0A, 0x50, 0xB0, 0xA5,
  0x0B, 0x0A, 0x58, 0x6B, 0xB4, 0x44, 0x10, 0xBC, 0x05,
  // "ĺ" (U+013A)
  0x28, 0x77, 0x40, 0x7D, 0x12, 0xD2, 0x73, 0x0D, 0x07, 0x20, 0xD0, 0x72, 0x0D, 0x07, 0x20, 0xD0,
  0x72, 0x0D, 0x07, 0x20, 0xD0, 0x72, 0x0D, 0x07, 0x20, 0xD0, 0x72, 0x0D, 0x07, 0x20, 0xD0, 0x72,
  0x0D, 0x07, 0x20, 0xD0, 0x71,
  // "Ļ" (U+013B)
  0x0B, 0x0A, 0x40, 0xB0, 0xA4, 0x0B, 0x0A, 0x40, 0xB0, 0xA4, 0x0B, 0x0A, 0x40, 0xB0, 0xA4, 0x0B,
  0x0A, 0x40, 0xB0, 0xA4, 0x0B, 0x0A, 0x40, 0xB0, 0xA4, 0x85, 0xBB, 0x44, 0x41, 0xBC, 0x05, 0x71,
  0x0A, 0x07, 0x40, 0xE0, 0x33, 0x02, 0x0B, 0x30,
  // "ļ" (U+013C)
  0x18, 0xC1, 0xD7, 0x0D, 0x70, 0xD7, 0x0D, 0x70, 0xD7, 0x0D, 0x70, 0xD7, 0x0D, 0x70, 0xD7, 0x0D,
  0x70, 0xD7, 0x0D, 0x74, 0x85, 0xA7, 0x0E, 0x32, 0xB1,
  // "Ľ" (U+013D)
  0x0B, 0x0A, 0x40, 0xB0, 0xA2, 0x82, 0xC8, 0xBA, 0x28, 0x2E, 0x3B, 0xA2, 0x82, 0xA0, 0xBA, 0x40,
  0xB0, 0xA4, 0x0B, 0x0A, 0x40, 0xB0, 0xA4, 0x0B, 0x0A, 0x40, 0xB0, 0xA4, 0x85, 0xBB, 0x44, 0x41,
  0xBC, 0x05,
  // "ľ" (U+013E)
  0x89, 0x4D, 0x7C, 0x8D, 0x7E, 0x3D, 0x8A, 0x0D, 0x72, 0x0D, 0x07, 0x20, 0xD0, 0x72, 0x0D, 0x07,
  0x20, 0xD0, 0x72, 0x0D, 0x07, 0x20, 0xD0, 0x72, 0x0D, 0x07, 0x20, 0xD0, 0x72,
  // "Ŀ" (U+013F)
  0x0B, 0x0A, 0x40, 0xB0, 0xA4, 0x0B, 0x0A, 0x40, 0xB0, 0xA4, 0x0B, 0x0A, 0x48, 0x94, 0xBA, 0x02,
  0xB0, 0xBA, 0x03, 0xD1, 0xBA, 0x40, 0xB0, 0xA4, 0x0B, 0x0A, 0x48, 0x5B, 0xB4, 0x44, 0x1B, 0xC0,
  0x50,
  // "ŀ" (U+0140)
  0x0D, 0x07, 0x30, 0xD0, 0x73, 0x0D, 0x07, 0x30, 0xD0, 0x73, 0x0D, 0x07, 0x38, 0x92, 0xD7, 0x2B,
  0x0D, 0x73, 0xD1, 0xD7, 0x30, 0xD0, 0x73, 0x0D, 0x07, 0x30, 0xD0, 0x73, 0x0D, 0x07, 0x30,
  // "Ł" (U+0141)
  0x10, 0xA0, 0xB5, 0x0A, 0x0B, 0x50, 0xA0, 0xB5, 0x0A, 0x0B, 0x58, 0x2A, 0xB0, 0x53, 0x82, 0xAD,
  0xDC, 0x38, 0x1B, 0xF7, 0x38, 0x1B, 0xFB, 0x48, 0x12, 0xAB, 0x50, 0xA0, 0xB5, 0x86, 0xAC, 0x44,
  0x41, 0x0A, 0xC0, 0x60,
  // "ł" (U+0142)
  0x20, 0xC0, 0x83, 0x0C, 0x08, 0x30, 0xC0, 0x83, 0x0C, 0x08, 0x38, 0x1C, 0x83, 0x28, 0x92, 0xCF,
  0xB0, 0x6F, 0xA0, 0x1B, 0xD8, 0x30, 0xC0, 0x83, 0x0C, 0x08, 0x30, 0xC0, 0x83, 0x0C, 0x08, 0x10,
  // "Ń" (U+0143)
  0x50, 0x70, 0x45, 0x81, 0x7D, 0x14, 0x81, 0x2D, 0x27, 0x38, 0x1B, 0xF2, 0x38, 0x38, 0xBB, 0xF9,
  0x38, 0x48, 0xBB, 0xCF, 0x12, 0x84, 0x8B, 0xB8, 0xD8, 0x28, 0xB2, 0x8B, 0xB8, 0x6E, 0x10, 0x8B,
  0xB9, 0x0E, 0x70, 0x8B, 0xB9, 0x07, 0xE0, 0x8B, 0xB9, 0x28, 0x4E, 0x68, 0xBB, 0x92, 0x84, 0x8D,
  0x8B, 0xB9, 0x28, 0x41, 0xFD, 0xBB, 0x93, 0x83, 0x9F, 0xBB, 0x93, 0x81, 0x2F, 0xB0,
  // "ń" (U+0144)
  0x40, 0x70, 0x43, 0x81, 0x7D, 0x12, 0x81, 0x2D, 0x27, 0x89, 0x4D, 0x5A, 0xEC, 0x2D, 0xE7, 0x3D,
  0xAD, 0xB2, 0x82, 0x6E, 0xD8, 0x28, 0x25, 0xFD, 0x72, 0x82, 0x5F, 0xD7, 0x28, 0x25, 0xFD, 0x72,
  0x82, 0x5F, 0xD7, 0x28, 0x25, 0xFD, 0x72, 0x05, 0x90,
  // "Ņ" (U+0145)
  0x81, 0xBF, 0x23, 0x83, 0x8B, 0xBF, 0x93, 0x84, 0x8B, 0xBC, 0xF1, 0x28, 0x48, 0xBB, 0x8D, 0x82,
  0x8B, 0x28, 0xBB, 0x86, 0xE1, 0x08, 0xBB, 0x90, 0xE7, 0x08, 0xBB, 0x90, 0x7E, 0x08, 0xBB, 0x92,
  0x84, 0xE6, 0x8B, 0xB9, 0x28, 0x48, 0xD8, 0xBB, 0x92, 0x84, 0x1F, 0xDB, 0xB9, 0x38, 0x39, 0xFB,
  0xB9, 0x38, 0x12, 0xFB, 0x74, 0x0A, 0x07, 0x60, 0xE0, 0x35, 0x02, 0x0B, 0x40,
  // "ņ" (U+0146)
  0x89, 0x4D, 0x5A, 0xEC, 0x2D, 0xE7, 0x3D, 0xAD, 0xB2, 0x82, 0x6E, 0xD8, 0x28, 0x25, 0xFD, 0x72,
  0x82, 0x5F, 0xD7, 0x28, 0x25, 0xFD, 0x72, 0x82, 0x5F, 0xD7, 0x28, 0x25, 0xFD, 0x72, 0x05, 0x97,
  0x10, 0xA0, 0x74, 0x0E, 0x03, 0x30, 0x20, 0xB3,
  // "Ň" (U+0147)
  0x10, 0x20, 0x52, 0x06, 0x01, 0x38, 0x2B, 0x79, 0x84, 0x81, 0x1E, 0xC7, 0x48, 0x1B, 0xF2, 0x38,
  0x38, 0xBB, 0xF9, 0x38, 0x48, 0xBB, 0xCF, 0x12, 0x84, 0x8B, 0xB8, 0xD8, 0x28, 0xB2, 0x8B, 0xB8,
  0x6E, 0x10, 0x8B, 0xB9, 0x0E, 0x70, 0x8B, 0xB9, 0x07, 0xE0, 0x8B, 0xB9, 0x28, 0x4E, 0x68, 0xBB,
  0x92, 0x84, 0x8D, 0x8B, 0xB9, 0x28, 0x41, 0xFD, 0xBB, 0x93, 0x83, 0x9F, 0xBB, 0x93, 0x81, 0x2F,
  0xB0,
  // "ň" (U+0148)
  0x02, 0x05, 0x28, 0x56, 0x10, 0xB7, 0x98, 0x28, 0x11, 0xEC, 0x71, 0x89, 0x4D, 0x5A, 0xEC, 0x2D,
  0xE7, 0x3D, 0xAD, 0xB2, 0x82, 0x6E, 0xD8, 0x28, 0x25, 0xFD, 0x72, 0x82, 0x5F, 0xD7, 0x28, 0x25,
  0xFD, 0x72, 0x82, 0x5F, 0xD7, 0x28, 0x25, 0xFD, 0x72, 0x05, 0x90,
  // "ŉ" (U+0149)
  0x19, 0x07, 0x58, 0x12, 0xF3, 0x50, 0x50, 0xE6, 0x86, 0x88, 0xD5, 0xAE, 0xC2, 0x28, 0x4D, 0xE7,
  0x3D, 0xA2, 0x0D, 0x0B, 0x20, 0x60, 0xE2, 0x0D, 0x08, 0x20, 0x59, 0x20, 0xD0, 0x72, 0x05, 0x92,
  0x0D, 0x07, 0x20, 0x59, 0x20, 0xD0, 0x72, 0x05, 0x92, 0x0D, 0x07, 0x20, 0x59, 0x20, 0xD0, 0x72,
  0x05, 0x90,
  // "Ŋ" (U+014A)
  0x81, 0xBF, 0x23, 0x83, 0x8B, 0xBF, 0xA3, 0x84, 0x8B, 0xBC, 0xF2, 0x28, 0x48, 0xBB, 0x8C, 0xA2,
  0x8B, 0x28, 0xBB, 0x84, 0xF2, 0x08, 0xBB, 0x90, 0xC9, 0x08, 0xBB, 0x90, 0x4F, 0x28, 0xBB, 0x92,
  0x84, 0xC9, 0x8B, 0xB9, 0x28, 0x44, 0xF9, 0xBB, 0x93, 0x83, 0xCF, 0xBB, 0x93, 0x83, 0x4F, 0xBB,
  0x94, 0x0C, 0x0B, 0x60, 0x90, 0xA5, 0x81, 0x1D, 0x74, 0x82, 0xBF, 0xC1, 0x50, 0x22,
  // "ŋ" (U+014B)
  0x89, 0x4D, 0x5A, 0xEC, 0x2D, 0xD6, 0x3D, 0xAD, 0xA2, 0x82, 0x7D, 0xD8, 0x28, 0x25, 0xFD, 0x72,
  0x82, 0x5F, 0xD7, 0x28, 0x25, 0xFD, 0x72, 0x82, 0x5F, 0xD7, 0x28, 0x25, 0xFD, 0x72, 0x05, 0x94,
  0x05, 0x94, 0x05, 0x0E, 0x38, 0x13, 0xAC, 0x38, 0x1C, 0xE4,
  // "Ō" (U+014C)
  0x20, 0x5B, 0x0C, 0x40, 0x18, 0x00, 0x24, 0x84, 0x2B, 0xEE, 0xA1, 0x28, 0x51, 0xEB, 0x44, 0xCD,
  0x20, 0x90, 0xD3, 0x84, 0x1E, 0x60, 0xD8, 0x48, 0x3A, 0xB1, 0xF5, 0x48, 0x37, 0xF2, 0xF4, 0x48,
  0x36, 0xF1, 0xF4, 0x48, 0x36, 0xF0, 0xF5, 0x48, 0x37, 0xE0, 0xD8, 0x48, 0x3A, 0xB0, 0x8D, 0x38,
  0x91, 0x1E, 0x60, 0x1D, 0xB3, 0x4C, 0xD3, 0x84, 0x2A, 0xEE, 0xA1, 0x10,
  // "ō" (U+014D)
  0x10, 0x5B, 0x0C, 0x30, 0x18, 0x00, 0x24, 0x82, 0x9E, 0xE8, 0x38, 0x49, 0xD4, 0x5E, 0x72, 0x0E,
  0x05, 0x28, 0x47, 0xD0, 0x2F, 0x22, 0x84, 0x4F, 0x13, 0xF1, 0x28, 0x43, 0xF2, 0x2F, 0x22, 0x04,
  0x92, 0x0E, 0x05, 0x20, 0x70, 0xD2, 0x84, 0x8D, 0x45, 0xE6, 0x38, 0x29, 0xEE, 0x82,
  // "Ŏ" (U+014E)
  0x28, 0x33, 0x91, 0x39, 0x50, 0xCA, 0x05, 0x60, 0x26, 0x84, 0x2B, 0xEE, 0xA1, 0x28, 0x51, 0xEB,
  0x44, 0xCD, 0x20, 0x90, 0xD3, 0x84, 0x1E, 0x60, 0xD8, 0x48, 0x3A, 0xB1, 0xF5, 0x48, 0x37, 0xF2,
  0xF4, 0x48, 0x36, 0xF1, 0xF4, 0x48, 0x36, 0xF0, 0xF5, 0x48, 0x37, 0xE0, 0xD8, 0x48, 0x3A, 0xB0,
  0x8D, 0x38, 0x91, 0x1E, 0x60, 0x1D, 0xB3, 0x4C, 0xD3, 0x84, 0x2A, 0xEE, 0xA1, 0x10,
  // "ŏ" (U+014F)
  0x18, 0x33, 0x91, 0x39, 0x40, 0xCA, 0x05, 0x50, 0x26, 0x82, 0x9E, 0xE8, 0x38, 0x49, 0xD4, 0x5E,
  0x72, 0x0E, 0x05, 0x28, 0x47, 0xD0, 0x2F, 0x22, 0x84, 0x4F, 0x13, 0xF1, 0x28, 0x43, 0xF2, 0x2F,
  0x22, 0x04, 0x92, 0x0E, 0x05, 0x20, 0x70, 0xD2, 0x84, 0x8D, 0x45, 0xE6, 0x38, 0x29, 0xEE, 0x82,
  // "Ő" (U+0150)
  0x38, 0x33, 0xD2, 0xA8, 0x48, 0x3A, 0x93, 0xE1, 0x38, 0x33, 0xB0, 0xA4, 0x76, 0x84, 0x2B, 0xEE,
  0xA1, 0x28, 0x51, 0xEB, 0x44, 0xCD, 0x20, 0x90, 0xD3, 0x84, 0x1E, 0x60, 0xD8, 0x48, 0x3A, 0xB1,
  0xF5, 0x48, 0x37, 0xF2, 0xF4, 0x48, 0x36, 0xF1, 0xF4, 0x48, 0x36, 0xF0, 0xF5, 0x48, 0x37, 0xE0,
  0xD8, 0x48, 0x3A, 0xB0, 0x8D, 0x38, 0x91, 0x1E, 0x60, 0x1D, 0xB3, 0x4C, 0xD3, 0x84, 0x2A, 0xEE,
  0xA1, 0x10,
  // "ő" (U+0151)
  0x28, 0x33, 0xD2, 0xA8, 0x38, 0x3A, 0x93, 0xE1, 0x28, 0x33, 0xB0, 0xA4, 0x75, 0x82, 0x9E, 0xE8,
  0x38, 0x49, 0xD4, 0x5E, 0x72, 0x0E, 0x05, 0x28, 0x47, 0xD0, 0x2F, 0x22, 0x84, 0x4F, 0x13, 0xF1,
  0x28, 0x43, 0xF2, 0x2F, 0x22, 0x04, 0x92, 0x0E, 0x05, 0x20, 0x70, 0xD2, 0x84, 0x8D, 0x45, 0xE6,
  0x38, 0x29, 0xEE, 0x82,
  // "Œ" (U+0152)
  0x28, 0x12, 0xAE, 0xD8, 0x95, 0xD0, 0x1D, 0xC4, 0x4F, 0x62, 0x22, 0x08, 0xE2, 0x81, 0x1F, 0x44,
  0x0D, 0x08, 0x28, 0x11, 0xF4, 0x49, 0x05, 0x28, 0x11, 0xF4, 0x38, 0x12, 0xF4, 0x20, 0x1C, 0x82,
  0xA2, 0xF4, 0x28, 0x71, 0xF6, 0x22, 0x10, 0xF5, 0x28, 0x11, 0xF4, 0x40, 0xD0, 0x82, 0x81, 0x1F,
  0x44, 0x85, 0x8E, 0x10, 0x1F, 0x44, 0x85, 0x1E, 0xC4, 0x3F, 0x60, 0xF2, 0x28, 0x12, 0xAE, 0xD0,
  0xD0,
  // "œ" (U+0153)
  0x28, 0x79, 0xEE, 0x60, 0x9E, 0xD4, 0x28, 0x94, 0x9D, 0x45, 0xEA, 0xD4, 0x8E, 0x10, 0xE5, 0x28,
  0x18, 0xF5, 0x28, 0x3D, 0x52, 0xF2, 0x28, 0x15, 0xF2, 0x28, 0x3B, 0x83, 0xF1, 0x20, 0x4D, 0x82,
  0x92, 0xF2, 0x28, 0x90, 0x5F, 0x42, 0x22, 0x10, 0xE6, 0x28, 0x18, 0xF4, 0x58, 0x91, 0x8D, 0x45,
  0xEB, 0xD5, 0x36, 0x22, 0x89, 0x09, 0xEE, 0x70, 0x8E, 0xEB, 0x20,
  // "Ŕ" (U+0154)
  0x40, 0x70, 0x44, 0x81, 0x7D, 0x13, 0x81, 0x2D, 0x27, 0x20, 0xBA, 0x89, 0x3D, 0x91, 0x0B, 0xB3,
  0x5D, 0xB0, 0xBA, 0x28, 0x34, 0xF2, 0xBA, 0x28, 0x32, 0xF3, 0xBA, 0x28, 0x91, 0x4F, 0x2B, 0xA0,
  0x2C, 0xC0, 0xBB, 0x86, 0xB1, 0x0B, 0xB2, 0xBB, 0x28, 0x7B, 0xA0, 0x4F, 0x30, 0xBA, 0x28, 0x3C,
  0xA0, 0xBA, 0x28, 0x34, 0xF3, 0xBA, 0x30, 0xD0, 0xA0,
  // "ŕ" (U+0155)
  0x30, 0x70, 0x42, 0x85, 0x7D, 0x10, 0x2D, 0x26, 0x89, 0x2D, 0x4A, 0xF2, 0xDC, 0x83, 0x0D, 0xC3,
  0x0D, 0x09, 0x30, 0xD0, 0x73, 0x0D, 0x07, 0x30, 0xD0, 0x73, 0x0D, 0x07, 0x30, 0xD0, 0x73,
  // "Ŗ" (U+0156)
  0x0B, 0xA8, 0x93, 0xD9, 0x10, 0xBB, 0x35, 0xDB, 0x0B, 0xA2, 0x83, 0x4F, 0x2B, 0xA2, 0x83, 0x2F,
  0x3B, 0xA2, 0x89, 0x14, 0xF2, 0xBA, 0x02, 0xCC, 0x0B, 0xB8, 0x6B, 0x10, 0xBB, 0x2B, 0xB2, 0x87,
  0xBA, 0x04, 0xF3, 0x0B, 0xA2, 0x83, 0xCA, 0x0B, 0xA2, 0x83, 0x4F, 0x3B, 0xA3, 0x0D, 0x0A, 0x72,
  0x0A, 0x07, 0x50, 0xE0, 0x34, 0x02, 0x0B, 0x40,
  // "ŗ" (U+0157)
  0x18, 0x90, 0xD4, 0xAF, 0x20, 0xDC, 0x83, 0x20, 0xD0, 0xC4, 0x0D, 0x09, 0x40, 0xD0, 0x74, 0x0D,
  0x07, 0x40, 0xD0, 0x74, 0x0D, 0x07, 0x40, 0xD0, 0x77, 0x30, 0xA0, 0x74, 0x0E, 0x03, 0x30, 0x20,
  0xB4,
  // "Ř" (U+0158)
  0x02, 0x05, 0x20, 0x60, 0x12, 0x82, 0xB7, 0x98, 0x38, 0x11, 0xEC, 0x73, 0x0B, 0xA8, 0x93, 0xD9,
  0x10, 0xBB, 0x35, 0xDB, 0x0B, 0xA2, 0x83, 0x4F, 0x2B, 0xA2, 0x83, 0x2F, 0x3B, 0xA2, 0x89, 0x14,
  0xF2, 0xBA, 0x02, 0xCC, 0x0B, 0xB8, 0x6B, 0x10, 0xBB, 0x2B, 0xB2, 0x87, 0xBA, 0x04, 0xF3, 0x0B,
  0xA2, 0x83, 0xCA, 0x0B, 0xA2, 0x83, 0x4F, 0x3B, 0xA3, 0x0D, 0x0A,
  // "ř" (U+0159)
  0x02, 0x05, 0x28, 0x56, 0x10, 0xB7, 0x98, 0x28, 0x11, 0xEC, 0x72, 0x89, 0x0D, 0x4A, 0xF2, 0x0D,
  0xC8, 0x32, 0x0D, 0x0C, 0x40, 0xD0, 0x94, 0x0D, 0x07, 0x40, 0xD0, 0x74, 0x0D, 0x07, 0x40, 0xD0,
  0x74, 0x0D, 0x07, 0x30,
  // "Ś" (U+015A)
  0x40, 0x70, 0x44, 0x81, 0x7D, 0x13, 0x81, 0x2D, 0x27, 0x38, 0x96, 0x1A, 0xEE, 0xB3, 0x0C, 0xC4,
  0x48, 0x12, 0xF3, 0x48, 0x13, 0xF4, 0x58, 0x1E, 0xC1, 0x48, 0x24, 0xEE, 0x74, 0x82, 0x1A, 0xFB,
  0x58, 0x15, 0xF6, 0x50, 0xD0, 0x85, 0x89, 0x5D, 0x74, 0x84, 0x39, 0xE2, 0x2C, 0xEF, 0xC3, 0x10,
  // "ś" (U+015B)
  0x40, 0x70, 0x43, 0x81, 0x7D, 0x12, 0x81, 0x2D, 0x27, 0x18, 0x93, 0x6D, 0xEB, 0x23, 0xF6, 0x37,
  0x15, 0xE4, 0x82, 0x1E, 0xA1, 0x38, 0x22, 0xCE, 0x64, 0x81, 0x6F, 0x44, 0x89, 0x3C, 0x74, 0x73,
  0x5F, 0x43, 0xCE, 0xD7, 0x10,
  // "Ŝ" (U+015C)
  0x30, 0x60, 0x54, 0x82, 0x5D, 0xE3, 0x28, 0x32, 0xC1, 0x3C, 0x72, 0x89, 0x61, 0xAE, 0xEB, 0x30,
  0xCC, 0x44, 0x81, 0x2F, 0x34, 0x81, 0x3F, 0x45, 0x81, 0xEC, 0x14, 0x82, 0x4E, 0xE7, 0x48, 0x21,
  0xAF, 0xB5, 0x81, 0x5F, 0x65, 0x0D, 0x08, 0x58, 0x95, 0xD7, 0x48, 0x43, 0x9E, 0x22, 0xCE, 0xFC,
  0x31,
  // "ŝ" (U+015D)
  0x20, 0x60, 0x53, 0x89, 0x05, 0xDE, 0x30, 0x2C, 0x13, 0xC7, 0x18, 0x93, 0x6D, 0xEB, 0x23, 0xF6,
  0x37, 0x15, 0xE4, 0x82, 0x1E, 0xA1, 0x38, 0x22, 0xCE, 0x64, 0x81, 0x6F, 0x44, 0x89, 0x3C, 0x74,
  0x73, 0x5F, 0x43, 0xCE, 0xD7, 0x10,
  // "Ş" (U+015E)
  0x18, 0x96, 0x1A, 0xEE, 0xB3, 0x0C, 0xC4, 0x48, 0x12, 0xF3, 0x48, 0x13, 0xF4, 0x58, 0x1E, 0xC1,
  0x48, 0x24, 0xEE, 0x74, 0x82, 0x1A, 0xFB, 0x58, 0x15, 0xF6, 0x50, 0xD0, 0x85, 0x89, 0x5D, 0x74,
  0x84, 0x39, 0xE2, 0x2C, 0xEF, 0xC3, 0x40, 0xD5, 0x81, 0x17, 0xC4, 0x03, 0x06, 0x94, 0x81, 0xBD,
  0x62,
  // "ş" (U+015F)
  0x18, 0x93, 0x6D, 0xEB, 0x23, 0xF6, 0x37, 0x15, 0xE4, 0x82, 0x1E, 0xA1, 0x38, 0x22, 0xCE, 0x64,
  0x81, 0x6F, 0x44, 0x89, 0x3C, 0x74, 0x73, 0x5F, 0x43, 0xCF, 0xE7, 0x30, 0xD4, 0x81, 0x17, 0xC3,
  0x03, 0x06, 0x93, 0x81, 0xBD, 0x62,
  // "Š" (U+0160)
  0x10, 0x20, 0x52, 0x06, 0x01, 0x28, 0x2B, 0x79, 0x83, 0x81, 0x1E, 0xC7, 0x38, 0x96, 0x1A, 0xEE,
  0xB3, 0x0C, 0xC4, 0x48, 0x12, 0xF3, 0x48, 0x13, 0xF4, 0x58, 0x1E, 0xC1, 0x48, 0x24, 0xEE, 0x74,
  0x82, 0x1A, 0xFB, 0x58, 0x15, 0xF6, 0x50, 0xD0, 0x85, 0x89, 0x5D, 0x74, 0x84, 0x39, 0xE2, 0x2C,
  0xEF, 0xC3, 0x10,
  // "š" (U+0161)
  0x02, 0x05, 0x28, 0x56, 0x10, 0xB7, 0x98, 0x28, 0x11, 0xEC, 0x72, 0x89, 0x36, 0xDE, 0xB2, 0x3F,
  0x63, 0x71, 0x5E, 0x48, 0x21, 0xEA, 0x13, 0x82, 0x2C, 0xE6, 0x48, 0x16, 0xF4, 0x48, 0x93, 0xC7,
  0x47, 0x35, 0xF4, 0x3C, 0xED, 0x71,
  // "Ţ" (U+0162)
  0x0D, 0xD8, 0x6B, 0x22, 0x5F, 0x42, 0x22, 0x81, 0x3F, 0x24, 0x81, 0x3F, 0x24, 0x81, 0x3F, 0x24,
  0x81, 0x3F, 0x24, 0x81, 0x3F, 0x24, 0x81, 0x3F, 0x24, 0x81, 0x3F, 0x24, 0x81, 0x3F, 0x24, 0x81,
  0x3F, 0x24, 0x81, 0x3F, 0x25, 0x0D, 0x58, 0x11, 0x7C, 0x40, 0x30, 0x69, 0x48, 0x1B, 0xD6, 0x20,
  // "ţ" (U+0163)
  0x10, 0x60, 0x83, 0x0A, 0x08, 0x20, 0x8B, 0x83, 0x42, 0xD9, 0x22, 0x0C, 0x08, 0x30, 0xC0, 0x83,
  0x0C, 0x08, 0x30, 0xC0, 0x83, 0x0C, 0x08, 0x38, 0x7A, 0xC3, 0x10, 0x3E, 0xE4, 0x20, 0xD3, 0x81,
  0x17, 0xC2, 0x03, 0x06, 0x92, 0x81, 0xBD, 0x61,
  // "Ť" (U+0164)
  0x10, 0x20, 0x52, 0x06, 0x01, 0x28, 0x2B, 0x79, 0x83, 0x81, 0x1E, 0xC7, 0x20, 0xDD, 0x86, 0xB2,
  0x25, 0xF4, 0x22, 0x28, 0x13, 0xF2, 0x48, 0x13, 0xF2, 0x48, 0x13, 0xF2, 0x48, 0x13, 0xF2, 0x48,
  0x13, 0xF2, 0x48, 0x13, 0xF2, 0x48, 0x13, 0xF2, 0x48, 0x13, 0xF2, 0x48, 0x13, 0xF2, 0x48, 0x13,
  0xF2, 0x20,
  // "ť" (U+0165)
  0x58, 0x3C, 0x80, 0x68, 0x28, 0x3E, 0x30, 0xA8, 0x28, 0x1A, 0x08, 0xB0, 0x42, 0x82, 0x2D, 0x92,
  0x40, 0xC0, 0x85, 0x0C, 0x08, 0x50, 0xC0, 0x85, 0x0C, 0x08, 0x50, 0xC0, 0x85, 0x82, 0xAC, 0x31,
  0x38, 0x23, 0xDE, 0x42,
  // "Ŧ" (U+0166)
  0x0D, 0xD8, 0x6B, 0x22, 0x5F, 0x42, 0x22, 0x81, 0x3F, 0x24, 0x81, 0x3F, 0x24, 0x81, 0x3F, 0x22,
  0x01, 0xD2, 0x83, 0x25, 0xF4, 0x23, 0x81, 0x3F, 0x24, 0x81, 0x3F, 0x24, 0x81, 0x3F, 0x24, 0x81,
  0x3F, 0x24, 0x81, 0x3F, 0x22,
  // "ŧ" (U+0167)
  0x10, 0x60, 0x83, 0x0A, 0x08, 0x20, 0x8B, 0x83, 0x42, 0xD9, 0x22, 0x0C, 0x08, 0x20, 0xAB, 0x83,
  0x22, 0xD9, 0x22, 0x0C, 0x08, 0x30, 0xC0, 0x83, 0x87, 0xAC, 0x31, 0x03, 0xDE, 0x40,
  // "Ũ" (U+0168)
  0x28, 0x3B, 0xD5, 0x49, 0x28, 0x43, 0xB5, 0xDF, 0x42, 0x00, 0x12, 0x01, 0x20, 0xC0, 0x83, 0x83,
  0x3F, 0x2C, 0x83, 0x83, 0x3F, 0x2C, 0x83, 0x83, 0x3F, 0x2C, 0x83, 0x83, 0x3F, 0x2C, 0x83, 0x83,
  0x3F, 0x2C, 0x83, 0x83, 0x3F, 0x2C, 0x83, 0x83, 0x3F, 0x2C, 0x83, 0x83, 0x3F, 0x2B, 0x93, 0x83,
  0x4F, 0x19, 0xC3, 0x89, 0x07, 0xE0, 0x2F, 0x83, 0x5E, 0x82, 0x83, 0x5C, 0xFE, 0x82,
  // "ũ" (U+0169)
  0x18, 0x93, 0xBD, 0x54, 0x93, 0xB5, 0xDF, 0x41, 0x12, 0x82, 0x10, 0xE6, 0x28, 0x26, 0xEE, 0x62,
  0x82, 0x6E, 0xE6, 0x28, 0x26, 0xEE, 0x62, 0x82, 0x6E, 0xE6, 0x28, 0x26, 0xEE, 0x62, 0x82, 0x7E,
  0xC7, 0x28, 0x94, 0x9E, 0x9C, 0x14, 0xEE, 0x1B, 0xEC, 0x5E,
  // "Ū" (U+016A)
  0x10, 0x5B, 0x0C, 0x30, 0x18, 0x00, 0x22, 0x0C, 0x08, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2,
  0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2,
  0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xB9, 0x38, 0x34, 0xF1, 0x9C, 0x38, 0x90, 0x7E,
  0x02, 0xF8, 0x35, 0xE8, 0x28, 0x35, 0xCF, 0xE8, 0x20,
  // "ū" (U+016B)
  0x05, 0xB8, 0x90, 0xC0, 0x12, 0x22, 0x20, 0xE6, 0x28, 0x26, 0xEE, 0x62, 0x82, 0x6E, 0xE6, 0x28,
  0x26, 0xEE, 0x62, 0x82, 0x6E, 0xE6, 0x28, 0x26, 0xEE, 0x62, 0x82, 0x7E, 0xC7, 0x28, 0x94, 0x9E,
  0x9C, 0x14, 0xEE, 0x1B, 0xEC, 0x5E,
  // "Ŭ" (U+016C)
  0x18, 0x33, 0x91, 0x39, 0x40, 0xCA, 0x05, 0x50, 0x24, 0x0C, 0x08, 0x38, 0x33, 0xF2, 0xC8, 0x38,
  0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38,
  0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xB9, 0x38, 0x34, 0xF1, 0x9C, 0x38,
  0x90, 0x7E, 0x02, 0xF8, 0x35, 0xE8, 0x28, 0x35, 0xCF, 0xE8, 0x20,
  // "ŭ" (U+016D)
  0x83, 0x39, 0x13, 0x92, 0x0C, 0xA0, 0x53, 0x02, 0x30, 0xE0, 0x62, 0x82, 0x6E, 0xE6, 0x28, 0x26,
  0xEE, 0x62, 0x82, 0x6E, 0xE6, 0x28, 0x26, 0xEE, 0x62, 0x82, 0x6E, 0xE6, 0x28, 0x27, 0xEC, 0x72,
  0x89, 0x49, 0xE9, 0xC1, 0x4E, 0xE1, 0xBE, 0xC5, 0xE0,
  // "Ů" (U+016E)
  0x28, 0x1C, 0xE8, 0x48, 0x24, 0xB4, 0xE4, 0x82, 0x1E, 0xFA, 0x60, 0x24, 0x0C, 0x08, 0x38, 0x33,
  0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33,
  0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xB9, 0x38, 0x34,
  0xF1, 0x9C, 0x38, 0x90, 0x7E, 0x02, 0xF8, 0x35, 0xE8, 0x28, 0x35, 0xCF, 0xE8, 0x20,
  // "ů" (U+016F)
  0x28, 0x1C, 0xE8, 0x28, 0x24, 0xB4, 0xE2, 0x82, 0x1E, 0xFA, 0x40, 0x22, 0x0E, 0x06, 0x28, 0x26,
  0xEE, 0x62, 0x82, 0x6E, 0xE6, 0x28, 0x26, 0xEE, 0x62, 0x82, 0x6E, 0xE6, 0x28, 0x26, 0xEE, 0x62,
  0x82, 0x7E, 0xC7, 0x28, 0x94, 0x9E, 0x9C, 0x14, 0xEE, 0x1B, 0xEC, 0x5E,
  // "Ű" (U+0170)
  0x28, 0x33, 0xD2, 0xA8, 0x38, 0x3A, 0x93, 0xE1, 0x28, 0x33, 0xB0, 0xA4, 0x73, 0x0C, 0x08, 0x38,
  0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38,
  0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xB9, 0x38,
  0x34, 0xF1, 0x9C, 0x38, 0x90, 0x7E, 0x02, 0xF8, 0x35, 0xE8, 0x28, 0x35, 0xCF, 0xE8, 0x20,
  // "ű" (U+0171)
  0x28, 0x33, 0xD2, 0xA8, 0x28, 0x91, 0xA9, 0x3E, 0x10, 0x3B, 0x0A, 0x47, 0x10, 0xE0, 0x62, 0x83,
  0x6E, 0x0E, 0x62, 0x83, 0x6E, 0x0E, 0x62, 0x83, 0x6E, 0x0E, 0x62, 0x83, 0x6E, 0x0E, 0x62, 0x83,
  0x6E, 0x0E, 0x62, 0x83, 0x7E, 0x0C, 0x72, 0x89, 0x69, 0xE0, 0x9C, 0x14, 0xEE, 0x01, 0xBE, 0xC5,
  0xE1,
  // "Ų" (U+0172)
  0x0C, 0x08, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33,
  0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33, 0xF2, 0xC8, 0x38, 0x33,
  0xF2, 0xB9, 0x38, 0x34, 0xF2, 0x9C, 0x38, 0x90, 0x7F, 0x02, 0xF8, 0x35, 0xEA, 0x20, 0x50, 0xCA,
  0x0D, 0x01, 0x50, 0xC0, 0x35, 0x05, 0x0B, 0x68, 0x16, 0xC3, 0x58, 0x11, 0xDD, 0x20,
  // "ų" (U+0173)
  0x0E, 0x06, 0x28, 0x26, 0xEE, 0x62, 0x82, 0x6E, 0xE6, 0x28, 0x26, 0xEE, 0x62, 0x82, 0x6E, 0xE6,
  0x28, 0x26, 0xEE, 0x62, 0x82, 0x7E, 0xC7, 0x28, 0x94, 0x9E, 0x9C, 0x14, 0xEE, 0x1B, 0xEC, 0x5E,
  0x40, 0x05, 0x30, 0x10, 0xD4, 0x05, 0x0D, 0x40, 0x20, 0xE9, 0x40, 0x01,
  // "Ŵ" (U+0174)
  0x50, 0x60, 0x57, 0x38, 0x25, 0xDE, 0x37, 0x18, 0x32, 0xC1, 0x3C, 0x77, 0x40, 0xC0, 0x93, 0x08,
  0x93, 0x83, 0x1F, 0x49, 0xC3, 0x81, 0xBF, 0x32, 0x82, 0x4F, 0x15, 0x93, 0x81, 0xED, 0x72, 0x89,
  0x17, 0xD0, 0x2F, 0x30, 0x2F, 0x8A, 0x20, 0x0A, 0x28, 0x5E, 0x60, 0x6C, 0x5D, 0x20, 0xE0, 0x72,
  0x89, 0x1B, 0x90, 0x99, 0x1F, 0x11, 0xF3, 0x28, 0x77, 0xD0, 0xC6, 0x0D, 0x55, 0x93, 0x89, 0x04,
  0xF1, 0xF2, 0x0A, 0x88, 0xC3, 0x82, 0x1F, 0x6E, 0x28, 0x27, 0xBB, 0x94, 0x81, 0xDB, 0xB2, 0x82,
  0x3D, 0xD6, 0x48, 0x1A, 0xF8, 0x3A, 0x03, 0x48, 0x16, 0xF4, 0x30, 0xC0, 0xE3,
  // "ŵ" (U+0175)
  0x40, 0x60, 0x57, 0x18, 0x25, 0xDE, 0x36, 0x83, 0x2C, 0x13, 0xC7, 0x71, 0x0B, 0x09, 0x28, 0x18,
  0xF1, 0x29, 0x81, 0x48, 0xC2, 0x86, 0xCE, 0x50, 0x3F, 0x14, 0x92, 0x98, 0x96, 0xA8, 0x07, 0xD0,
  0x1F, 0x33, 0xD5, 0xC0, 0xA9, 0x28, 0x7D, 0x67, 0xA2, 0xF0, 0xD5, 0x28, 0x79, 0x9A, 0x70, 0xE4,
  0xF2, 0x28, 0x66, 0xCD, 0x30, 0xBA, 0xE3, 0x81, 0x3E, 0xE2, 0x81, 0x7E, 0xA4, 0x0E, 0x0B, 0x28,
  0x14, 0xF7, 0x20,
  // "Ŷ" (U+0176)
  0x30, 0x60, 0x54, 0x82, 0x5D, 0xE3, 0x28, 0x32, 0xC1, 0x3C, 0x71, 0x0C, 0x0A, 0x38, 0x38, 0xD6,
  0xF1, 0x28, 0x95, 0xE8, 0x1F, 0x60, 0x4F, 0x20, 0xAC, 0x0A, 0xB2, 0x83, 0x4F, 0x4F, 0x53, 0x81,
  0xDE, 0xE4, 0x81, 0x7F, 0x84, 0x81, 0x2F, 0x34, 0x81, 0x2F, 0x34, 0x81, 0x2F, 0x34, 0x81, 0x2F,
  0x34, 0x81, 0x2F, 0x32,
  // "ŷ" (U+0177)
  0x20, 0x60, 0x54, 0x82, 0x5D, 0xE3, 0x28, 0x32, 0xC1, 0x3C, 0x72, 0x0C, 0x08, 0x38, 0x2E, 0x68,
  0xD2, 0x87, 0x3F, 0x13, 0xF1, 0x07, 0xD2, 0x83, 0xE5, 0x0B, 0x82, 0x83, 0xA9, 0x0E, 0x42, 0x81,
  0x5D, 0x39, 0x38, 0x21, 0xF9, 0xB4, 0x81, 0xBE, 0x64, 0x81, 0x7F, 0x24, 0x07, 0x0D, 0x50, 0xB0,
  0x93, 0x82, 0x26, 0xF3, 0x38, 0x1B, 0xE6, 0x40,
  // "Ÿ" (U+0178)
  0x18, 0x39, 0x70, 0xD3, 0x20, 0x12, 0x01, 0x72, 0x0C, 0x0A, 0x38, 0x38, 0xD6, 0xF1, 0x28, 0x95,
  0xE8, 0x1F, 0x60, 0x4F, 0x20, 0xAC, 0x0A, 0xB2, 0x83, 0x4F, 0x4F, 0x53, 0x81, 0xDE, 0xE4, 0x81,
  0x7F, 0x84, 0x81, 0x2F, 0x34, 0x81, 0x2F, 0x34, 0x81, 0x2F, 0x34, 0x81, 0x2F, 0x34, 0x81, 0x2F,
  0x32,
  // "Ź" (U+0179)
  0x40, 0x70, 0x44, 0x81, 0x7D, 0x13, 0x81, 0x2D, 0x27, 0x20, 0x6D, 0x86, 0x31, 0x22, 0x28, 0xF1,
  0x40, 0xD0, 0x94, 0x81, 0x4F, 0x24, 0x00, 0xB4, 0x81, 0x2F, 0x44, 0x09, 0x0D, 0x50, 0xE0, 0x64,
  0x06, 0x0E, 0x50, 0xD0, 0x84, 0x86, 0x4F, 0x52, 0x22, 0x18, 0xD0, 0x60,
  // "ź" (U+017A)
  0x30, 0x70, 0x43, 0x81, 0x7D, 0x12, 0x81, 0x2D, 0x27, 0x10, 0x5C, 0x84, 0x11, 0x22, 0x9D, 0x40,
  0xE0, 0x63, 0x06, 0x0E, 0x40, 0xD0, 0x73, 0x81, 0x5E, 0x13, 0x0C, 0x08, 0x38, 0x54, 0xF4, 0x22,
  0x08, 0xC0, 0x30,
  // "Ż" (U+017B)
  0x20, 0x20, 0xB5, 0x81, 0x3D, 0x17, 0x20, 0x6D, 0x86, 0x31, 0x22, 0x28, 0xF1, 0x40, 0xD0, 0x94,
  0x81, 0x4F, 0x24, 0x00, 0xB4, 0x81, 0x2F, 0x44, 0x09, 0x0D, 0x50, 0xE0, 0x64, 0x06, 0x0E, 0x50,
  0xD0, 0x84, 0x86, 0x4F, 0x52, 0x22, 0x18, 0xD0, 0x60,
  // "ż" (U+017C)
  0x20, 0x20, 0xB4, 0x81, 0x3D, 0x17, 0x05, 0xC8, 0x41, 0x12, 0x29, 0xD4, 0x0E, 0x06, 0x30, 0x60,
  0xE4, 0x0D, 0x07, 0x38, 0x15, 0xE1, 0x30, 0xC0, 0x83, 0x85, 0x4F, 0x42, 0x20, 0x8C, 0x03,
  // "Ž" (U+017D)
  0x10, 0x20, 0x52, 0x06, 0x01, 0x28, 0x2B, 0x79, 0x83, 0x81, 0x1E, 0xC7, 0x20, 0x6D, 0x86, 0x31,
  0x22, 0x28, 0xF1, 0x40, 0xD0, 0x94, 0x81, 0x4F, 0x24, 0x00, 0xB4, 0x81, 0x2F, 0x44, 0x09, 0x0D,
  0x50, 0xE0, 0x64, 0x06, 0x0E, 0x50, 0xD0, 0x84, 0x86, 0x4F, 0x52, 0x22, 0x18, 0xD0, 0x60,
  // "ž" (U+017E)
  0x02, 0x05, 0x28, 0x56, 0x10, 0xB7, 0x98, 0x28, 0x11, 0xEC, 0x71, 0x05, 0xC8, 0x41, 0x12, 0x29,
  0xD4, 0x0E, 0x06, 0x30, 0x60, 0xE4, 0x0D, 0x07, 0x38, 0x15, 0xE1, 0x30, 0xC0, 0x83, 0x85, 0x4F,
  0x42, 0x20, 0x8C, 0x03,
  // "ſ" (U+017F)
  0x89, 0x01, 0xCE, 0x89, 0xD3, 0x3B, 0x82, 0x0C, 0x08, 0x20, 0xC0, 0x82, 0x0C, 0x08, 0x20, 0xC0,
  0x82, 0x0C, 0x08, 0x20, 0xC0, 0x82, 0x0C, 0x08, 0x20, 0xC0, 0x82, 0x0C, 0x08, 0x20,
  // "Ω" (U+03A9)
  0x28, 0x42, 0xBE, 0xEB, 0x23, 0x86, 0x2E, 0xA4, 0x4A, 0xE2, 0x20, 0x90, 0xD4, 0x0D, 0x09, 0x20,
  0xE0, 0x74, 0x84, 0x8E, 0x01, 0xF5, 0x48, 0x46, 0xF0, 0x1F, 0x54, 0x84, 0x5F, 0x10, 0xF5, 0x40,
  0x69, 0x20, 0xD0, 0x84, 0x08, 0x0D, 0x20, 0x90, 0xC4, 0x0C, 0x09, 0x28, 0x12, 0xF3, 0x28, 0x63,
  0xF2, 0x01, 0x29, 0xD2, 0x83, 0xD9, 0x21, 0x7B, 0x03, 0x04, 0xB0, 0x70,
  // "μ" (U+03BC)
  0x0D, 0x07, 0x28, 0x25, 0xFD, 0x72, 0x82, 0x5F, 0xD7, 0x28, 0x25, 0xFD, 0x72, 0x82, 0x5F, 0xD7,
  0x28, 0x25, 0xFD, 0x72, 0x82, 0x6F, 0xD8, 0x28, 0x96, 0x9F, 0xDE, 0x46, 0xDF, 0xDB, 0xEC, 0x4F,
  0xD7, 0x40, 0xD0, 0x74, 0x0D, 0x07, 0x40, 0xD0, 0x74,
  // "π" (U+03C0)
  0x09, 0xF8, 0x72, 0x29, 0xD2, 0x29, 0xC2, 0x20, 0x70, 0xC2, 0x08, 0x0C, 0x30, 0x70, 0xC2, 0x08,
  0x0C, 0x30, 0x70, 0xC2, 0x08, 0x0C, 0x30, 0x70, 0xC2, 0x08, 0x0C, 0x30, 0x70, 0xC2, 0x08, 0x0C,
  0x30, 0x70, 0xC2, 0x81, 0x7E, 0x42, 0x07, 0x0C, 0x28, 0x11, 0xDE, 0x10,
  // "–" (U+2013)
  0x06, 0xE0, 0x60, 0x18, 0x02, 0x20, 0x10,
  // "—" (U+2014)
  0x06, 0xFF, 0x06, 0x01, 0x80, 0x92, 0x20, 0x10,
  // "€" (U+20AC)
  0x38, 0x39, 0xEE, 0xA1, 0x28, 0x3B, 0xD4, 0x48, 0x28, 0x13, 0xF3, 0x50, 0x70, 0xD5, 0x0B, 0xC0,
  0x92, 0x84, 0x2B, 0xB2, 0x21, 0x30, 0x0A, 0x50, 0xBC, 0x04, 0x28, 0x32, 0x8D, 0x22, 0x48, 0x13,
  0xF2, 0x68, 0x3B, 0xC4, 0x36, 0x38, 0x31, 0xAE, 0xEB, 0x10,
  // "₿" (U+20BF)
  0x18, 0x24, 0x25, 0x12, 0x84, 0x85, 0xB1, 0x0B, 0xB8, 0x90, 0x90, 0xBB, 0x36, 0xF8, 0xBA, 0x28,
  0x2A, 0xBB, 0xA2, 0x87, 0xAB, 0xBA, 0x02, 0xE6, 0xBB, 0x89, 0x0B, 0x0B, 0xB2, 0x5E, 0x8B, 0xA2,
  0x82, 0x8E, 0xBA, 0x28, 0x26, 0xFB, 0xA2, 0x87, 0x8E, 0xBB, 0x25, 0xE9, 0xBB, 0x0A, 0x28, 0x28,
  0x5B, 0x12, 0x81, 0x32, 0x52,
  // "‘" (U+2018)
  0x18, 0x90, 0x87, 0x0E, 0x44, 0xF1, 0x8E, 0x10,
  // "’" (U+2019)
  0x19, 0x87, 0x72, 0xF3, 0x5E, 0x08, 0x81,
  // "‚" (U+201A)
  0x19, 0x87, 0x72, 0xF3, 0x5E, 0x08, 0x81,
  // "‛" (U+201B)
  0x89, 0x28, 0xE0, 0x4F, 0x10, 0xE4, 0x08, 0x70,
  // "“" (U+201C)
  0x18, 0xA4, 0x87, 0x0C, 0x30, 0xE4, 0x3F, 0x04, 0xF1, 0x8D, 0x08, 0xE0, 0xCA, 0x10,
  // "”" (U+201D)
  0x19, 0x8A, 0x37, 0x3F, 0x32, 0xF3, 0x6E, 0x05, 0xE0, 0x9A, 0x08, 0x80, 0xC4, 0x10,
  // "„" (U+201E)
  0x19, 0x8A, 0x37, 0x3F, 0x32, 0xF3, 0x6E, 0x05, 0xE0, 0x9A, 0x08, 0x80, 0xC4, 0x10,
  // "‟" (U+201F)
  0x89, 0x18, 0xE0, 0xCA, 0x04, 0xF1, 0x8D, 0x28, 0x1E, 0x43, 0x92, 0x83, 0x87, 0x0C, 0x30,
  // "†" (U+2020)
  0x39, 0x06, 0x50, 0xD0, 0x55, 0x0C, 0x03, 0x28, 0x94, 0x1C, 0xBE, 0xBB, 0x70, 0x43, 0xC5, 0x43,
  0x30, 0xB0, 0x35, 0x0C, 0x03, 0x50, 0xD0, 0x45, 0x0D, 0x05, 0x50, 0xE0, 0x55, 0x0E, 0x06, 0x59,
  0x07, 0x20,
  // "‡" (U+2021)
  0x30, 0xE0, 0x65, 0x0D, 0x04, 0x38, 0x51, 0x0B, 0x30, 0x11, 0xD0, 0x93, 0x0B, 0x03, 0x50, 0xD0,
  0x55, 0x0D, 0x05, 0x50, 0xB0, 0x32, 0x01, 0xD8, 0x69, 0x02, 0x1B, 0x31, 0x13, 0x0D, 0x04, 0x50,
  0xE0, 0x62,
  // "•" (U+2022)
  0x83, 0x4D, 0xE5, 0xCA, 0x0D, 0x0C, 0xA8, 0x3D, 0x4D, 0xE5,
  // "…" (U+2026)
  0x0D, 0x0A, 0x20, 0xD0, 0xA2, 0x82, 0xDA, 0xC9, 0x20, 0xC0, 0x92, 0x0C, 0x09,
  // "‰" (U+2030)
  0x18, 0x16, 0xEA, 0x30, 0xA0, 0x67, 0x18, 0x5E, 0x5C, 0x50, 0x1E, 0x71, 0x86, 0x3D, 0x07, 0x90,
  0x79, 0x71, 0x86, 0x4C, 0x06, 0xA0, 0xD3, 0x71, 0x85, 0x3D, 0x07, 0x94, 0xD7, 0x28, 0x90, 0x1E,
  0x2B, 0x7A, 0x76, 0xEB, 0x28, 0x19, 0xE8, 0x28, 0x95, 0x8F, 0xD2, 0xE1, 0xE2, 0xB6, 0x3D, 0x1E,
  0x22, 0x89, 0x41, 0x06, 0xA3, 0xD0, 0x6A, 0x79, 0x0A, 0x64, 0x89, 0x2C, 0x44, 0xD0, 0x6B, 0x88,
  0x09, 0x73, 0x89, 0x33, 0xD0, 0x3D, 0x07, 0xA7, 0x90, 0xB6, 0x30, 0x90, 0x72, 0x87, 0xE5, 0xC6,
  0x3D, 0x4E, 0x23, 0x0E, 0x01, 0x28, 0x15, 0xEB, 0x28, 0x19, 0xE8, 0x10,
  // "‹" (U+2039)
  0x20, 0x10, 0x32, 0x89, 0x3B, 0x90, 0x7D, 0x03, 0xF4, 0x01, 0xD8, 0x28, 0x13, 0xE3, 0x20, 0x60,
  0x90,
  // "›" (U+203A)
  0x10, 0x32, 0x81, 0x2E, 0x42, 0x81, 0x6E, 0x12, 0x89, 0x3C, 0xB0, 0x1E, 0x70, 0xBA, 0x02, 0xC1,
  0x10,
  // "⁄" (U+2044)
  0x60, 0xC0, 0x55, 0x04, 0x0D, 0x60, 0xC0, 0x55, 0x05, 0x0C, 0x60, 0xC0, 0x45, 0x05, 0x0C, 0x60,
  0xD0, 0x45, 0x06, 0x0B, 0x60, 0xD0, 0x35, 0x06, 0x0B, 0x60, 0xD0, 0x35, 0x06, 0x0A, 0x60,
  // "™" (U+2122)
  0x84, 0xAD, 0xED, 0x7D, 0x28, 0xE2, 0x8B, 0x04, 0x80, 0x7E, 0x30, 0xCC, 0x04, 0x80, 0x79, 0x82,
  0x9C, 0x04, 0x80, 0x75, 0xC7, 0x4C, 0x04, 0x80, 0x75, 0xAC, 0x1C, 0x04, 0x70, 0x64, 0x58, 0x0B,
  // "⅒" (U+2152)
  0x18, 0x12, 0xD9, 0x40, 0xC0, 0x56, 0x82, 0x2D, 0xA9, 0x30, 0x40, 0xD7, 0x18, 0x11, 0x79, 0x30,
  0xC0, 0x57, 0x20, 0x70, 0x92, 0x05, 0x0C, 0x73, 0x07, 0x09, 0x20, 0xC0, 0x47, 0x38, 0x67, 0x90,
  0x5C, 0x2D, 0x97, 0x18, 0x67, 0x90, 0xD6, 0xDA, 0x92, 0x81, 0x9E, 0xA5, 0x89, 0x26, 0xB0, 0x17,
  0x90, 0x4C, 0x0A, 0x74, 0x0D, 0x03, 0x28, 0x67, 0x90, 0x88, 0x05, 0xB3, 0x06, 0x0B, 0x38, 0x67,
  0x90, 0x97, 0x04, 0xC3, 0x0D, 0x03, 0x38, 0x67, 0x90, 0x88, 0x05, 0xB2, 0x06, 0x0A, 0x48, 0x67,
  0x90, 0x4D, 0x0A, 0x77, 0x58, 0x18, 0xEA, 0x10,
  // "ﬁ" (U+FB01)
  0x18, 0x96, 0x1B, 0xEB, 0xC6, 0x07, 0xE3, 0x39, 0x50, 0x9A, 0x40, 0x9B, 0x89, 0x34, 0xD7, 0x2B,
  0xB2, 0x0D, 0x70, 0xAA, 0x28, 0x3D, 0x70, 0xAA, 0x28, 0x3D, 0x70, 0xAA, 0x28, 0x3D, 0x70, 0xAA,
  0x28, 0x3D, 0x70, 0xAA, 0x28, 0x3D, 0x70, 0xAA, 0x28, 0x3D, 0x70, 0xAA, 0x20, 0xD0, 0x70,
  // "ﬂ" (U+FB02)
  0x18, 0x96, 0x1B, 0xEB, 0xD7, 0x07, 0xE3, 0x3D, 0x70, 0x9A, 0x28, 0x1D, 0x79, 0xB8, 0x93, 0x4D,
  0x72, 0xBB, 0x20, 0xD7, 0x0A, 0xA2, 0x83, 0xD7, 0x0A, 0xA2, 0x83, 0xD7, 0x0A, 0xA2, 0x83, 0xD7,
  0x0A, 0xA2, 0x83, 0xD7, 0x0A, 0xA2, 0x83, 0xD7, 0x0A, 0xA2, 0x83, 0xD7, 0x0A, 0xA2, 0x0D, 0x07,
};

const Font& font_NotoSans_Condensed_16() {
  static SmoothFont font(font_NotoSans_Condensed_16_data);
  return font;
}

}  // namespace roo_display
