#include "20.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-Medium (Noto Sans Medium)
// Generated on Thu Mar 30 23:43:05 CEST 2023
static const uint8_t font_NotoSans_Medium_20_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x07, 0x9D,
  0xFC, 0xFB, 0x17, 0x14, 0x0F, 0xFB, 0x06, 0x03, 0x18, 0x06, 0x05, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x01, 0x01, 0x03, 0x0E, 0x05, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x01, 0x0A, 0x07, 0x0E, 0x09, 0x00, 0x17, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x0C, 0x0E, 0x0D, 0x00, 0x2A, // "#" (U+0023)
  0x00, 0x24, 0x01, 0x00, 0x0A, 0x0F, 0x0B, 0x00, 0x73, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x10, 0x0E, 0x11, 0x00, 0xB7, // "%" (U+0025)
  0x00, 0x26, 0x01, 0x01, 0x0E, 0x0E, 0x0F, 0x01, 0x25, // "&" (U+0026)
  0x00, 0x27, 0x01, 0x0A, 0x03, 0x0E, 0x05, 0x01, 0x7C, // "'" (U+0027)
  0x00, 0x28, 0x00, 0xFE, 0x05, 0x0E, 0x06, 0x01, 0x85, // "(" (U+0028)
  0x00, 0x29, 0x00, 0xFE, 0x05, 0x0E, 0x06, 0x01, 0xB5, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x07, 0x0A, 0x0F, 0x0B, 0x01, 0xE8, // "*" (U+002A)
  0x00, 0x2B, 0x01, 0x03, 0x0A, 0x0C, 0x0B, 0x02, 0x13, // "+" (U+002B)
  0x00, 0x2C, 0x00, 0xFE, 0x03, 0x02, 0x05, 0x02, 0x34, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x05, 0x05, 0x06, 0x06, 0x02, 0x40, // "-" (U+002D)
  0x00, 0x2E, 0x01, 0x01, 0x03, 0x03, 0x05, 0x02, 0x46, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x02, 0x4C, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x02, 0x77, // "0" (U+0030)
  0x00, 0x31, 0x01, 0x01, 0x07, 0x0E, 0x0B, 0x02, 0xC0, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x02, 0xEF, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x03, 0x28, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x0B, 0x0E, 0x0B, 0x03, 0x67, // "4" (U+0034)
  0x00, 0x35, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x03, 0xA0, // "5" (U+0035)
  0x00, 0x36, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x03, 0xD7, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x04, 0x18, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x04, 0x48, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x04, 0x92, // "9" (U+0039)
  0x00, 0x3A, 0x01, 0x01, 0x03, 0x0B, 0x05, 0x04, 0xD7, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0xFE, 0x03, 0x0B, 0x05, 0x04, 0xE5, // ";" (U+003B)
  0x00, 0x3C, 0x01, 0x03, 0x0A, 0x0D, 0x0B, 0x04, 0xFA, // "<" (U+003C)
  0x00, 0x3D, 0x01, 0x05, 0x0A, 0x0A, 0x0B, 0x05, 0x23, // "=" (U+003D)
  0x00, 0x3E, 0x01, 0x03, 0x0A, 0x0C, 0x0B, 0x05, 0x33, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x08, 0x0E, 0x09, 0x05, 0x59, // "?" (U+003F)
  0x00, 0x40, 0x01, 0xFF, 0x10, 0x0E, 0x12, 0x05, 0x89, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x0C, 0x0E, 0x0D, 0x06, 0x01, // "A" (U+0041)
  0x00, 0x42, 0x01, 0x01, 0x0B, 0x0E, 0x0D, 0x06, 0x44, // "B" (U+0042)
  0x00, 0x43, 0x01, 0x01, 0x0B, 0x0E, 0x0D, 0x06, 0x8C, // "C" (U+0043)
  0x00, 0x44, 0x01, 0x01, 0x0D, 0x0E, 0x0F, 0x06, 0xC9, // "D" (U+0044)
  0x00, 0x45, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x07, 0x17, // "E" (U+0045)
  0x00, 0x46, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x07, 0x44, // "F" (U+0046)
  0x00, 0x47, 0x01, 0x01, 0x0C, 0x0E, 0x0F, 0x07, 0x66, // "G" (U+0047)
  0x00, 0x48, 0x01, 0x01, 0x0C, 0x0E, 0x0F, 0x07, 0xAC, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x06, 0x0E, 0x07, 0x07, 0xE8, // "I" (U+0049)
  0x00, 0x4A, 0xFE, 0xFD, 0x03, 0x0E, 0x06, 0x08, 0x13, // "J" (U+004A)
  0x00, 0x4B, 0x01, 0x01, 0x0C, 0x0E, 0x0D, 0x08, 0x3C, // "K" (U+004B)
  0x00, 0x4C, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x08, 0x8C, // "L" (U+004C)
  0x00, 0x4D, 0x01, 0x01, 0x10, 0x0E, 0x12, 0x08, 0xB8, // "M" (U+004D)
  0x00, 0x4E, 0x01, 0x01, 0x0D, 0x0E, 0x10, 0x09, 0x26, // "N" (U+004E)
  0x00, 0x4F, 0x01, 0x01, 0x0E, 0x0E, 0x10, 0x09, 0x7C, // "O" (U+004F)
  0x00, 0x50, 0x01, 0x01, 0x0B, 0x0E, 0x0C, 0x09, 0xCB, // "P" (U+0050)
  0x00, 0x51, 0x01, 0xFE, 0x0E, 0x0E, 0x10, 0x0A, 0x09, // "Q" (U+0051)
  0x00, 0x52, 0x01, 0x01, 0x0C, 0x0E, 0x0D, 0x0A, 0x63, // "R" (U+0052)
  0x00, 0x53, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x0A, 0xB1, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x0A, 0xEA, // "T" (U+0054)
  0x00, 0x55, 0x01, 0x01, 0x0C, 0x0E, 0x0F, 0x0B, 0x1D, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x0C, 0x0E, 0x0C, 0x0B, 0x61, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x12, 0x0E, 0x13, 0x0B, 0xA8, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x0C, 0x1E, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x0B, 0x0E, 0x0C, 0x0C, 0x67, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x0C, 0xA5, // "Z" (U+005A)
  0x00, 0x5B, 0x01, 0xFD, 0x06, 0x0E, 0x07, 0x0C, 0xD4, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x0D, 0x0A, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0xFD, 0x05, 0x0E, 0x07, 0x0D, 0x34, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x06, 0x0A, 0x0E, 0x0B, 0x0D, 0x6A, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFE, 0x08, 0xFF, 0x09, 0x0D, 0x93, // "_" (U+005F)
  0x00, 0x60, 0x01, 0x0D, 0x05, 0x0F, 0x06, 0x0D, 0x98, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x09, 0x0B, 0x0B, 0x0D, 0xA1, // "a" (U+0061)
  0x00, 0x62, 0x01, 0x01, 0x0B, 0x0F, 0x0C, 0x0D, 0xD8, // "b" (U+0062)
  0x00, 0x63, 0x01, 0x01, 0x08, 0x0B, 0x0A, 0x0E, 0x23, // "c" (U+0063)
  0x00, 0x64, 0x01, 0x01, 0x0A, 0x0F, 0x0C, 0x0E, 0x4D, // "d" (U+0064)
  0x00, 0x65, 0x01, 0x01, 0x0A, 0x0B, 0x0B, 0x0E, 0x92, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x07, 0x0F, 0x07, 0x0E, 0xC3, // "f" (U+0066)
  0x00, 0x67, 0x01, 0xFC, 0x0A, 0x0B, 0x0C, 0x0E, 0xF6, // "g" (U+0067)
  0x00, 0x68, 0x01, 0x01, 0x0A, 0x0F, 0x0D, 0x0F, 0x44, // "h" (U+0068)
  0x00, 0x69, 0x01, 0x01, 0x03, 0x0F, 0x05, 0x0F, 0x84, // "i" (U+0069)
  0x00, 0x6A, 0xFE, 0xFC, 0x03, 0x0F, 0x05, 0x0F, 0x9C, // "j" (U+006A)
  0x00, 0x6B, 0x01, 0x01, 0x0A, 0x0F, 0x0B, 0x0F, 0xD5, // "k" (U+006B)
  0x00, 0x6C, 0x01, 0x01, 0x03, 0x0F, 0x05, 0x10, 0x1B, // "l" (U+006C)
  0x00, 0x6D, 0x01, 0x01, 0x11, 0x0B, 0x13, 0x10, 0x33, // "m" (U+006D)
  0x00, 0x6E, 0x01, 0x01, 0x0A, 0x0B, 0x0D, 0x10, 0x8C, // "n" (U+006E)
  0x00, 0x6F, 0x01, 0x01, 0x0B, 0x0B, 0x0C, 0x10, 0xC1, // "o" (U+006F)
  0x00, 0x70, 0x01, 0xFC, 0x0B, 0x0B, 0x0C, 0x10, 0xFB, // "p" (U+0070)
  0x00, 0x71, 0x01, 0xFC, 0x0A, 0x0B, 0x0C, 0x11, 0x48, // "q" (U+0071)
  0x00, 0x72, 0x01, 0x01, 0x08, 0x0B, 0x09, 0x11, 0x90, // "r" (U+0072)
  0x00, 0x73, 0x01, 0x01, 0x08, 0x0B, 0x0A, 0x11, 0xB5, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x11, 0xE1, // "t" (U+0074)
  0x00, 0x75, 0x01, 0x01, 0x0A, 0x0B, 0x0D, 0x12, 0x06, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x0A, 0x0B, 0x0B, 0x12, 0x3B, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x0F, 0x0B, 0x10, 0x12, 0x70, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x0A, 0x0B, 0x0B, 0x12, 0xC6, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFC, 0x0A, 0x0B, 0x0B, 0x12, 0xFB, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x08, 0x0B, 0x0A, 0x13, 0x42, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFD, 0x06, 0x0E, 0x08, 0x13, 0x69, // "{" (U+007B)
  0x00, 0x7C, 0x04, 0xFC, 0x06, 0x0F, 0x0B, 0x13, 0x9D, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0xFD, 0x07, 0x0E, 0x08, 0x13, 0xBD, // "}" (U+007D)
  0x00, 0x7E, 0x01, 0x07, 0x0A, 0x09, 0x0B, 0x13, 0xFA, // "~" (U+007E)
  0x00, 0xA1, 0x01, 0xFD, 0x03, 0x0B, 0x05, 0x14, 0x09, // "¡" (U+00A1)
  0x00, 0xA2, 0x01, 0x01, 0x09, 0x0E, 0x0B, 0x14, 0x20, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x14, 0x56, // "£" (U+00A3)
  0x00, 0xA4, 0x01, 0x03, 0x09, 0x0C, 0x0B, 0x14, 0x90, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x14, 0xBF, // "¥" (U+00A5)
  0x00, 0xA6, 0x04, 0xFC, 0x06, 0x0F, 0x0B, 0x14, 0xFF, // "¦" (U+00A6)
  0x00, 0xA7, 0x01, 0x01, 0x08, 0x0F, 0x0A, 0x15, 0x1B, // "§" (U+00A7)
  0x00, 0xA8, 0x03, 0x0E, 0x08, 0x0F, 0x0C, 0x15, 0x59, // "¨" (U+00A8)
  0x00, 0xA9, 0x01, 0x01, 0x0F, 0x0F, 0x11, 0x15, 0x61, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x09, 0x06, 0x0E, 0x07, 0x15, 0xC7, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x02, 0x09, 0x0A, 0x0B, 0x15, 0xDE, // "«" (U+00AB)
  0x00, 0xAC, 0x01, 0x03, 0x0A, 0x08, 0x0B, 0x16, 0x0C, // "¬" (U+00AC)
  0x00, 0xAE, 0x01, 0x01, 0x0F, 0x0F, 0x11, 0x16, 0x1D, // "®" (U+00AE)
  0x00, 0xAF, 0xFF, 0x10, 0x0A, 0x11, 0x0A, 0x16, 0x8C, // "¯" (U+00AF)
  0x00, 0xB0, 0x01, 0x09, 0x07, 0x0F, 0x09, 0x16, 0x92, // "°" (U+00B0)
  0x00, 0xB1, 0x01, 0x01, 0x0A, 0x0C, 0x0B, 0x16, 0xAD, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x09, 0x06, 0x12, 0x07, 0x16, 0xD3, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x08, 0x06, 0x12, 0x07, 0x16, 0xF3, // "³" (U+00B3)
  0x00, 0xB4, 0x00, 0x0D, 0x05, 0x0F, 0x06, 0x17, 0x1A, // "´" (U+00B4)
  0x00, 0xB5, 0x01, 0xFC, 0x0A, 0x0B, 0x0D, 0x17, 0x24, // "µ" (U+00B5)
  0x00, 0xB6, 0x01, 0xFD, 0x0B, 0x0F, 0x0D, 0x17, 0x67, // "¶" (U+00B6)
  0x00, 0xB7, 0x01, 0x07, 0x03, 0x09, 0x05, 0x17, 0xBF, // "·" (U+00B7)
  0x00, 0xB8, 0x00, 0xFB, 0x04, 0x00, 0x04, 0x17, 0xC5, // "¸" (U+00B8)
  0x00, 0xB9, 0x01, 0x09, 0x05, 0x11, 0x07, 0x17, 0xD5, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x09, 0x06, 0x0E, 0x08, 0x17, 0xF0, // "º" (U+00BA)
  0x00, 0xBB, 0x01, 0x02, 0x09, 0x0A, 0x0B, 0x18, 0x09, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x0F, 0x0F, 0x0F, 0x18, 0x36, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x0F, 0x0F, 0x10, 0x18, 0x99, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x0F, 0x0F, 0x10, 0x18, 0xFA, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFE, 0x08, 0x0B, 0x09, 0x19, 0x64, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x0C, 0x13, 0x0D, 0x19, 0x94, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x0C, 0x13, 0x0D, 0x19, 0xE4, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x0C, 0x13, 0x0D, 0x1A, 0x35, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x0C, 0x13, 0x0D, 0x1A, 0x88, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x0C, 0x13, 0x0D, 0x1A, 0xDE, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x0C, 0x11, 0x0D, 0x1B, 0x2C, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x10, 0x0E, 0x12, 0x1B, 0x7C, // "Æ" (U+00C6)
  0x00, 0xC7, 0x01, 0xFB, 0x0B, 0x0E, 0x0D, 0x1B, 0xD1, // "Ç" (U+00C7)
  0x00, 0xC8, 0x01, 0x01, 0x09, 0x13, 0x0B, 0x1C, 0x21, // "È" (U+00C8)
  0x00, 0xC9, 0x01, 0x01, 0x09, 0x13, 0x0B, 0x1C, 0x59, // "É" (U+00C9)
  0x00, 0xCA, 0x01, 0x01, 0x09, 0x13, 0x0B, 0x1C, 0x92, // "Ê" (U+00CA)
  0x00, 0xCB, 0x01, 0x01, 0x09, 0x13, 0x0B, 0x1C, 0xCF, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x06, 0x13, 0x07, 0x1D, 0x07, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x06, 0x13, 0x07, 0x1D, 0x3D, // "Í" (U+00CD)
  0x00, 0xCE, 0xFF, 0x01, 0x06, 0x13, 0x07, 0x1D, 0x74, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x06, 0x13, 0x07, 0x1D, 0xAF, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x0D, 0x0E, 0x0F, 0x1D, 0xE4, // "Ð" (U+00D0)
  0x00, 0xD1, 0x01, 0x01, 0x0D, 0x13, 0x10, 0x1E, 0x30, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x1E, 0x99, // "Ò" (U+00D2)
  0x00, 0xD3, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x1E, 0xF5, // "Ó" (U+00D3)
  0x00, 0xD4, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x1F, 0x52, // "Ô" (U+00D4)
  0x00, 0xD5, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x1F, 0xB2, // "Õ" (U+00D5)
  0x00, 0xD6, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x20, 0x14, // "Ö" (U+00D6)
  0x00, 0xD7, 0x01, 0x03, 0x09, 0x0C, 0x0B, 0x20, 0x6F, // "×" (U+00D7)
  0x00, 0xD8, 0x01, 0x00, 0x0E, 0x0F, 0x10, 0x20, 0x9B, // "Ø" (U+00D8)
  0x00, 0xD9, 0x01, 0x01, 0x0C, 0x13, 0x0F, 0x21, 0x03, // "Ù" (U+00D9)
  0x00, 0xDA, 0x01, 0x01, 0x0C, 0x13, 0x0F, 0x21, 0x53, // "Ú" (U+00DA)
  0x00, 0xDB, 0x01, 0x01, 0x0C, 0x13, 0x0F, 0x21, 0xA3, // "Û" (U+00DB)
  0x00, 0xDC, 0x01, 0x01, 0x0C, 0x13, 0x0F, 0x21, 0xF7, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x0B, 0x13, 0x0C, 0x22, 0x46, // "Ý" (U+00DD)
  0x00, 0xDE, 0x01, 0x01, 0x0B, 0x0E, 0x0C, 0x22, 0x91, // "Þ" (U+00DE)
  0x00, 0xDF, 0x01, 0x01, 0x0C, 0x0F, 0x0D, 0x22, 0xD0, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x09, 0x0F, 0x0B, 0x23, 0x2B, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x09, 0x0F, 0x0B, 0x23, 0x6D, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x09, 0x0F, 0x0B, 0x23, 0xAF, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x09, 0x0F, 0x0B, 0x23, 0xF5, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x09, 0x0F, 0x0B, 0x24, 0x3D, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x09, 0x10, 0x0B, 0x24, 0x7F, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x10, 0x0B, 0x12, 0x24, 0xC7, // "æ" (U+00E6)
  0x00, 0xE7, 0x01, 0xFB, 0x08, 0x0B, 0x0A, 0x25, 0x1C, // "ç" (U+00E7)
  0x00, 0xE8, 0x01, 0x01, 0x0A, 0x0F, 0x0B, 0x25, 0x58, // "è" (U+00E8)
  0x00, 0xE9, 0x01, 0x01, 0x0A, 0x0F, 0x0B, 0x25, 0x94, // "é" (U+00E9)
  0x00, 0xEA, 0x01, 0x01, 0x0A, 0x0F, 0x0B, 0x25, 0xD1, // "ê" (U+00EA)
  0x00, 0xEB, 0x01, 0x01, 0x0A, 0x0F, 0x0B, 0x26, 0x11, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x04, 0x0F, 0x05, 0x26, 0x4D, // "ì" (U+00EC)
  0x00, 0xED, 0x01, 0x01, 0x06, 0x0F, 0x05, 0x26, 0x78, // "í" (U+00ED)
  0x00, 0xEE, 0xFE, 0x01, 0x05, 0x0F, 0x05, 0x26, 0xA3, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x05, 0x0F, 0x05, 0x26, 0xD3, // "ï" (U+00EF)
  0x00, 0xF0, 0x01, 0x01, 0x0B, 0x10, 0x0C, 0x26, 0xFD, // "ð" (U+00F0)
  0x00, 0xF1, 0x01, 0x01, 0x0A, 0x0F, 0x0D, 0x27, 0x4C, // "ñ" (U+00F1)
  0x00, 0xF2, 0x01, 0x01, 0x0B, 0x0F, 0x0C, 0x27, 0x92, // "ò" (U+00F2)
  0x00, 0xF3, 0x01, 0x01, 0x0B, 0x0F, 0x0C, 0x27, 0xD7, // "ó" (U+00F3)
  0x00, 0xF4, 0x01, 0x01, 0x0B, 0x0F, 0x0C, 0x28, 0x1C, // "ô" (U+00F4)
  0x00, 0xF5, 0x01, 0x01, 0x0B, 0x0F, 0x0C, 0x28, 0x65, // "õ" (U+00F5)
  0x00, 0xF6, 0x01, 0x01, 0x0B, 0x0F, 0x0C, 0x28, 0xB0, // "ö" (U+00F6)
  0x00, 0xF7, 0x01, 0x03, 0x0A, 0x0C, 0x0B, 0x28, 0xF4, // "÷" (U+00F7)
  0x00, 0xF8, 0x01, 0x00, 0x0B, 0x0C, 0x0C, 0x29, 0x0D, // "ø" (U+00F8)
  0x00, 0xF9, 0x01, 0x01, 0x0A, 0x0F, 0x0D, 0x29, 0x52, // "ù" (U+00F9)
  0x00, 0xFA, 0x01, 0x01, 0x0A, 0x0F, 0x0D, 0x29, 0x92, // "ú" (U+00FA)
  0x00, 0xFB, 0x01, 0x01, 0x0A, 0x0F, 0x0D, 0x29, 0xD2, // "û" (U+00FB)
  0x00, 0xFC, 0x01, 0x01, 0x0A, 0x0F, 0x0D, 0x2A, 0x16, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFC, 0x0A, 0x0F, 0x0B, 0x2A, 0x56, // "ý" (U+00FD)
  0x00, 0xFE, 0x01, 0xFC, 0x0B, 0x0F, 0x0C, 0x2A, 0xA9, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFC, 0x0A, 0x0F, 0x0B, 0x2B, 0x04, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x0C, 0x12, 0x0D, 0x2B, 0x56, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x09, 0x0E, 0x0B, 0x2B, 0xA3, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x0C, 0x13, 0x0D, 0x2B, 0xE2, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x09, 0x0F, 0x0B, 0x2C, 0x36, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFD, 0x0D, 0x0E, 0x0D, 0x2C, 0x7D, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFD, 0x0A, 0x0B, 0x0B, 0x2C, 0xD0, // "ą" (U+0105)
  0x01, 0x06, 0x01, 0x01, 0x0B, 0x13, 0x0D, 0x2D, 0x19, // "Ć" (U+0106)
  0x01, 0x07, 0x01, 0x01, 0x09, 0x0F, 0x0A, 0x2D, 0x62, // "ć" (U+0107)
  0x01, 0x08, 0x01, 0x01, 0x0B, 0x13, 0x0D, 0x2D, 0x99, // "Ĉ" (U+0108)
  0x01, 0x09, 0x01, 0x01, 0x08, 0x0F, 0x0A, 0x2D, 0xE5, // "ĉ" (U+0109)
  0x01, 0x0A, 0x01, 0x01, 0x0B, 0x12, 0x0D, 0x2E, 0x1D, // "Ċ" (U+010A)
  0x01, 0x0B, 0x01, 0x01, 0x08, 0x0E, 0x0A, 0x2E, 0x62, // "ċ" (U+010B)
  0x01, 0x0C, 0x01, 0x01, 0x0B, 0x13, 0x0D, 0x2E, 0x93, // "Č" (U+010C)
  0x01, 0x0D, 0x01, 0x01, 0x08, 0x0F, 0x0A, 0x2E, 0xDF, // "č" (U+010D)
  0x01, 0x0E, 0x01, 0x01, 0x0D, 0x13, 0x0F, 0x2F, 0x16, // "Ď" (U+010E)
  0x01, 0x0F, 0x01, 0x01, 0x0E, 0x0F, 0x0C, 0x2F, 0x75, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x0D, 0x0E, 0x0F, 0x2F, 0xCB, // "Đ" (U+0110)
  0x01, 0x11, 0x01, 0x01, 0x0C, 0x0F, 0x0D, 0x30, 0x17, // "đ" (U+0111)
  0x01, 0x12, 0x01, 0x01, 0x09, 0x12, 0x0B, 0x30, 0x6A, // "Ē" (U+0112)
  0x01, 0x13, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x30, 0xA0, // "ē" (U+0113)
  0x01, 0x14, 0x01, 0x01, 0x09, 0x13, 0x0B, 0x30, 0xD9, // "Ĕ" (U+0114)
  0x01, 0x15, 0x01, 0x01, 0x0A, 0x0F, 0x0B, 0x31, 0x17, // "ĕ" (U+0115)
  0x01, 0x16, 0x01, 0x01, 0x09, 0x12, 0x0B, 0x31, 0x58, // "Ė" (U+0116)
  0x01, 0x17, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x31, 0x8E, // "ė" (U+0117)
  0x01, 0x18, 0x01, 0xFD, 0x0A, 0x0E, 0x0B, 0x31, 0xC7, // "Ę" (U+0118)
  0x01, 0x19, 0x01, 0xFC, 0x0A, 0x0B, 0x0B, 0x32, 0x04, // "ę" (U+0119)
  0x01, 0x1A, 0x01, 0x01, 0x09, 0x13, 0x0B, 0x32, 0x45, // "Ě" (U+011A)
  0x01, 0x1B, 0x01, 0x01, 0x0A, 0x0F, 0x0B, 0x32, 0x82, // "ě" (U+011B)
  0x01, 0x1C, 0x01, 0x01, 0x0C, 0x13, 0x0F, 0x32, 0xC2, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x01, 0xFC, 0x0A, 0x0F, 0x0C, 0x33, 0x18, // "ĝ" (U+011D)
  0x01, 0x1E, 0x01, 0x01, 0x0C, 0x13, 0x0F, 0x33, 0x74, // "Ğ" (U+011E)
  0x01, 0x1F, 0x01, 0xFC, 0x0A, 0x0F, 0x0C, 0x33, 0xCB, // "ğ" (U+011F)
  0x01, 0x20, 0x01, 0x01, 0x0C, 0x12, 0x0F, 0x34, 0x28, // "Ġ" (U+0120)
  0x01, 0x21, 0x01, 0xFC, 0x0A, 0x0E, 0x0C, 0x34, 0x78, // "ġ" (U+0121)
  0x01, 0x22, 0x01, 0xFC, 0x0C, 0x0E, 0x0F, 0x34, 0xCE, // "Ģ" (U+0122)
  0x01, 0x23, 0x01, 0xFC, 0x0A, 0x0F, 0x0C, 0x35, 0x20, // "ģ" (U+0123)
  0x01, 0x24, 0x01, 0x01, 0x0C, 0x13, 0x0F, 0x35, 0x77, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFE, 0x01, 0x0A, 0x13, 0x0D, 0x35, 0xC3, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x0E, 0x0E, 0x0F, 0x36, 0x1B, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x0A, 0x0F, 0x0D, 0x36, 0x5D, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x07, 0x13, 0x07, 0x36, 0xA6, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFE, 0x01, 0x06, 0x0F, 0x05, 0x36, 0xE4, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x06, 0x12, 0x07, 0x37, 0x15, // "Ī" (U+012A)
  0x01, 0x2B, 0xFF, 0x01, 0x05, 0x0E, 0x05, 0x37, 0x48, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x07, 0x13, 0x07, 0x37, 0x71, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFF, 0x01, 0x06, 0x0F, 0x05, 0x37, 0xAD, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFD, 0x06, 0x0E, 0x07, 0x37, 0xDD, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFD, 0x04, 0x0F, 0x05, 0x38, 0x15, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x06, 0x12, 0x07, 0x38, 0x4A, // "İ" (U+0130)
  0x01, 0x31, 0x01, 0x01, 0x03, 0x0B, 0x05, 0x38, 0x7E, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0xFD, 0x0A, 0x0E, 0x0D, 0x38, 0x90, // "Ĳ" (U+0132)
  0x01, 0x33, 0x01, 0xFC, 0x08, 0x0F, 0x0B, 0x38, 0xE7, // "ĳ" (U+0133)
  0x01, 0x34, 0xFE, 0xFD, 0x06, 0x13, 0x06, 0x39, 0x39, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFE, 0xFC, 0x05, 0x0F, 0x05, 0x39, 0x73, // "ĵ" (U+0135)
  0x01, 0x36, 0x01, 0xFC, 0x0C, 0x0E, 0x0D, 0x39, 0xB4, // "Ķ" (U+0136)
  0x01, 0x37, 0x01, 0xFC, 0x0A, 0x0F, 0x0B, 0x3A, 0x0F, // "ķ" (U+0137)
  0x01, 0x38, 0x01, 0x01, 0x0A, 0x0B, 0x0B, 0x3A, 0x5F, // "ĸ" (U+0138)
  0x01, 0x39, 0x01, 0x01, 0x0A, 0x13, 0x0B, 0x3A, 0x9A, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x01, 0x01, 0x06, 0x13, 0x05, 0x3A, 0xD2, // "ĺ" (U+013A)
  0x01, 0x3B, 0x01, 0xFC, 0x0A, 0x0E, 0x0B, 0x3B, 0x09, // "Ļ" (U+013B)
  0x01, 0x3C, 0x01, 0xFC, 0x04, 0x0F, 0x05, 0x3B, 0x3F, // "ļ" (U+013C)
  0x01, 0x3D, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x3B, 0x66, // "Ľ" (U+013D)
  0x01, 0x3E, 0x01, 0x01, 0x07, 0x0F, 0x05, 0x3B, 0x98, // "ľ" (U+013E)
  0x01, 0x3F, 0x01, 0x01, 0x0A, 0x0E, 0x0B, 0x3B, 0xC7, // "Ŀ" (U+013F)
  0x01, 0x40, 0x01, 0x01, 0x07, 0x0F, 0x06, 0x3B, 0xF8, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x3C, 0x27, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x05, 0x0F, 0x05, 0x3C, 0x59, // "ł" (U+0142)
  0x01, 0x43, 0x01, 0x01, 0x0D, 0x13, 0x10, 0x3C, 0x89, // "Ń" (U+0143)
  0x01, 0x44, 0x01, 0x01, 0x0A, 0x0F, 0x0D, 0x3C, 0xED, // "ń" (U+0144)
  0x01, 0x45, 0x01, 0xFC, 0x0D, 0x0E, 0x10, 0x3D, 0x2D, // "Ņ" (U+0145)
  0x01, 0x46, 0x01, 0xFC, 0x0A, 0x0B, 0x0D, 0x3D, 0x8E, // "ņ" (U+0146)
  0x01, 0x47, 0x01, 0x01, 0x0D, 0x13, 0x10, 0x3D, 0xCD, // "Ň" (U+0147)
  0x01, 0x48, 0x01, 0x01, 0x0A, 0x0F, 0x0D, 0x3E, 0x34, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x0C, 0x0E, 0x0E, 0x3E, 0x78, // "ŉ" (U+0149)
  0x01, 0x4A, 0x01, 0xFD, 0x0D, 0x0E, 0x10, 0x3E, 0xBF, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x01, 0xFC, 0x0A, 0x0B, 0x0D, 0x3F, 0x23, // "ŋ" (U+014B)
  0x01, 0x4C, 0x01, 0x01, 0x0E, 0x12, 0x10, 0x3F, 0x67, // "Ō" (U+014C)
  0x01, 0x4D, 0x01, 0x01, 0x0B, 0x0E, 0x0C, 0x3F, 0xC0, // "ō" (U+014D)
  0x01, 0x4E, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x40, 0x02, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x01, 0x01, 0x0B, 0x0F, 0x0C, 0x40, 0x63, // "ŏ" (U+014F)
  0x01, 0x50, 0x01, 0x01, 0x0E, 0x13, 0x10, 0x40, 0xAD, // "Ő" (U+0150)
  0x01, 0x51, 0x01, 0x01, 0x0B, 0x0F, 0x0C, 0x41, 0x0D, // "ő" (U+0151)
  0x01, 0x52, 0x01, 0x01, 0x11, 0x0E, 0x13, 0x41, 0x57, // "Œ" (U+0152)
  0x01, 0x53, 0x01, 0x01, 0x12, 0x0B, 0x13, 0x41, 0xAF, // "œ" (U+0153)
  0x01, 0x54, 0x01, 0x01, 0x0C, 0x13, 0x0D, 0x42, 0x0A, // "Ŕ" (U+0154)
  0x01, 0x55, 0x01, 0x01, 0x08, 0x0F, 0x09, 0x42, 0x65, // "ŕ" (U+0155)
  0x01, 0x56, 0x01, 0xFC, 0x0C, 0x0E, 0x0D, 0x42, 0x96, // "Ŗ" (U+0156)
  0x01, 0x57, 0x01, 0xFC, 0x08, 0x0B, 0x09, 0x42, 0xF0, // "ŗ" (U+0157)
  0x01, 0x58, 0x01, 0x01, 0x0C, 0x13, 0x0D, 0x43, 0x1F, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x08, 0x0F, 0x09, 0x43, 0x7D, // "ř" (U+0159)
  0x01, 0x5A, 0x01, 0x01, 0x09, 0x13, 0x0B, 0x43, 0xB2, // "Ś" (U+015A)
  0x01, 0x5B, 0x01, 0x01, 0x08, 0x0F, 0x0A, 0x43, 0xF6, // "ś" (U+015B)
  0x01, 0x5C, 0x01, 0x01, 0x09, 0x13, 0x0B, 0x44, 0x2D, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x08, 0x0F, 0x0A, 0x44, 0x75, // "ŝ" (U+015D)
  0x01, 0x5E, 0x01, 0xFB, 0x09, 0x0E, 0x0B, 0x44, 0xB2, // "Ş" (U+015E)
  0x01, 0x5F, 0x01, 0xFB, 0x08, 0x0B, 0x0A, 0x44, 0xFD, // "ş" (U+015F)
  0x01, 0x60, 0x01, 0x01, 0x09, 0x13, 0x0B, 0x45, 0x3B, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x08, 0x0F, 0x0A, 0x45, 0x82, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFB, 0x0A, 0x0E, 0x0B, 0x45, 0xBF, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFB, 0x07, 0x0E, 0x08, 0x46, 0x05, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x0A, 0x13, 0x0B, 0x46, 0x3D, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x0A, 0x0F, 0x08, 0x46, 0x80, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x46, 0xB3, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x07, 0x0E, 0x08, 0x46, 0xE7, // "ŧ" (U+0167)
  0x01, 0x68, 0x01, 0x01, 0x0C, 0x13, 0x0F, 0x47, 0x11, // "Ũ" (U+0168)
  0x01, 0x69, 0x01, 0x01, 0x0A, 0x0F, 0x0D, 0x47, 0x67, // "ũ" (U+0169)
  0x01, 0x6A, 0x01, 0x01, 0x0C, 0x12, 0x0F, 0x47, 0xAD, // "Ū" (U+016A)
  0x01, 0x6B, 0x01, 0x01, 0x0A, 0x0E, 0x0D, 0x47, 0xFA, // "ū" (U+016B)
  0x01, 0x6C, 0x01, 0x01, 0x0C, 0x13, 0x0F, 0x48, 0x37, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x01, 0x01, 0x0A, 0x0F, 0x0D, 0x48, 0x8C, // "ŭ" (U+016D)
  0x01, 0x6E, 0x01, 0x01, 0x0C, 0x14, 0x0F, 0x48, 0xD1, // "Ů" (U+016E)
  0x01, 0x6F, 0x01, 0x01, 0x0A, 0x10, 0x0D, 0x49, 0x27, // "ů" (U+016F)
  0x01, 0x70, 0x01, 0x01, 0x0C, 0x13, 0x0F, 0x49, 0x6D, // "Ű" (U+0170)
  0x01, 0x71, 0x01, 0x01, 0x0B, 0x0F, 0x0D, 0x49, 0xC2, // "ű" (U+0171)
  0x01, 0x72, 0x01, 0xFC, 0x0C, 0x0E, 0x0F, 0x4A, 0x0D, // "Ų" (U+0172)
  0x01, 0x73, 0x01, 0xFD, 0x0B, 0x0B, 0x0D, 0x4A, 0x63, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x12, 0x13, 0x13, 0x4A, 0xAB, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x0F, 0x0F, 0x10, 0x4B, 0x33, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x0B, 0x13, 0x0C, 0x4B, 0x99, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFC, 0x0A, 0x0F, 0x0B, 0x4B, 0xE7, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x0B, 0x13, 0x0C, 0x4C, 0x3D, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x0A, 0x13, 0x0B, 0x4C, 0x87, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x08, 0x0F, 0x0A, 0x4C, 0xC2, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x0A, 0x12, 0x0B, 0x4C, 0xF4, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x08, 0x0E, 0x0A, 0x4D, 0x2C, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x0A, 0x13, 0x0B, 0x4D, 0x5B, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x08, 0x0F, 0x0A, 0x4D, 0x9A, // "ž" (U+017E)
  0x01, 0x7F, 0x01, 0x01, 0x07, 0x0F, 0x07, 0x4D, 0xCF, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x0E, 0x0E, 0x10, 0x4D, 0xFE, // "Ω" (U+03A9)
  0x03, 0xBC, 0x01, 0xFC, 0x0A, 0x0B, 0x0D, 0x4E, 0x52, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x0C, 0x0B, 0x0E, 0x4E, 0x95, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x05, 0x09, 0x06, 0x0A, 0x4E, 0xD8, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x05, 0x13, 0x06, 0x14, 0x4E, 0xDF, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x0A, 0x0E, 0x0B, 0x4E, 0xE7, // "€" (U+20AC)
  0x20, 0xBF, 0x01, 0xFF, 0x0A, 0x11, 0x0B, 0x4F, 0x25, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x0A, 0x03, 0x0E, 0x04, 0x4F, 0x81, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x0A, 0x03, 0x0E, 0x04, 0x4F, 0x8D, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0xFE, 0x03, 0x02, 0x05, 0x4F, 0x99, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x0A, 0x03, 0x0E, 0x04, 0x4F, 0xA5, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x0A, 0x07, 0x0E, 0x08, 0x4F, 0xB1, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x0A, 0x07, 0x0E, 0x08, 0x4F, 0xC7, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0xFE, 0x07, 0x02, 0x09, 0x4F, 0xDD, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x0A, 0x07, 0x0E, 0x08, 0x4F, 0xF3, // "‟" (U+201F)
  0x20, 0x20, 0x01, 0x01, 0x08, 0x0F, 0x0A, 0x50, 0x0A, // "†" (U+2020)
  0x20, 0x21, 0x01, 0x01, 0x09, 0x0F, 0x0A, 0x50, 0x32, // "‡" (U+2021)
  0x20, 0x22, 0x01, 0x06, 0x06, 0x0A, 0x08, 0x50, 0x63, // "•" (U+2022)
  0x20, 0x26, 0x01, 0x01, 0x0E, 0x03, 0x10, 0x50, 0x73, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x17, 0x0E, 0x18, 0x50, 0x89, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x02, 0x05, 0x0A, 0x07, 0x51, 0x21, // "‹" (U+2039)
  0x20, 0x3A, 0x01, 0x02, 0x05, 0x0A, 0x07, 0x51, 0x3B, // "›" (U+203A)
  0x20, 0x44, 0xFC, 0x01, 0x06, 0x0E, 0x03, 0x51, 0x54, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x07, 0x0D, 0x0E, 0x0F, 0x51, 0x82, // "™" (U+2122)
  0x21, 0x52, 0x01, 0x00, 0x14, 0x0E, 0x15, 0x51, 0xBE, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x0A, 0x0F, 0x0D, 0x52, 0x3C, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x0A, 0x0F, 0x0D, 0x52, 0x92, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x61, 0x01, // "a (U+0022 U+0061)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x67, 0x01, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0x6D, 0x01, // "m (U+0022 U+006D)
  0x00, 0x22, 0x00, 0x6E, 0x01, // "n (U+0022 U+006E)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x70, 0x01, // "p (U+0022 U+0070)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0x72, 0x01, // "r (U+0022 U+0072)
  0x00, 0x22, 0x00, 0x73, 0x01, // "s (U+0022 U+0073)
  0x00, 0x22, 0x00, 0x75, 0x01, // "u (U+0022 U+0075)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x02, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE1, 0x01, // "á (U+0022 U+00E1)
  0x00, 0x22, 0x00, 0xE2, 0x01, // "â (U+0022 U+00E2)
  0x00, 0x22, 0x00, 0xE3, 0x01, // "ã (U+0022 U+00E3)
  0x00, 0x22, 0x00, 0xE4, 0x01, // "ä (U+0022 U+00E4)
  0x00, 0x22, 0x00, 0xE5, 0x01, // "å (U+0022 U+00E5)
  0x00, 0x22, 0x00, 0xE6, 0x01, // "æ (U+0022 U+00E6)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x00, 0xF9, 0x01, // "ù (U+0022 U+00F9)
  0x00, 0x22, 0x00, 0xFA, 0x01, // "ú (U+0022 U+00FA)
  0x00, 0x22, 0x00, 0xFB, 0x01, // "û (U+0022 U+00FB)
  0x00, 0x22, 0x00, 0xFC, 0x01, // "ü (U+0022 U+00FC)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x01, 0x01, // "ā (U+0022 U+0101)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x03, 0x01, // "ă (U+0022 U+0103)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x05, 0x01, // "ą (U+0022 U+0105)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x1D, 0x01, // "ĝ (U+0022 U+011D)
  0x00, 0x22, 0x01, 0x1F, 0x01, // "ğ (U+0022 U+011F)
  0x00, 0x22, 0x01, 0x21, 0x01, // "ġ (U+0022 U+0121)
  0x00, 0x22, 0x01, 0x23, 0x01, // "ģ (U+0022 U+0123)
  0x00, 0x22, 0x01, 0x38, 0x01, // "ĸ (U+0022 U+0138)
  0x00, 0x22, 0x01, 0x44, 0x01, // "ń (U+0022 U+0144)
  0x00, 0x22, 0x01, 0x46, 0x01, // "ņ (U+0022 U+0146)
  0x00, 0x22, 0x01, 0x4B, 0x01, // "ŋ (U+0022 U+014B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x22, 0x01, 0x55, 0x01, // "ŕ (U+0022 U+0155)
  0x00, 0x22, 0x01, 0x57, 0x01, // "ŗ (U+0022 U+0157)
  0x00, 0x22, 0x01, 0x5B, 0x01, // "ś (U+0022 U+015B)
  0x00, 0x22, 0x01, 0x5F, 0x01, // "ş (U+0022 U+015F)
  0x00, 0x22, 0x01, 0x69, 0x01, // "ũ (U+0022 U+0169)
  0x00, 0x22, 0x01, 0x6B, 0x01, // "ū (U+0022 U+016B)
  0x00, 0x22, 0x01, 0x6D, 0x01, // "ŭ (U+0022 U+016D)
  0x00, 0x22, 0x01, 0x6F, 0x01, // "ů (U+0022 U+016F)
  0x00, 0x22, 0x01, 0x71, 0x01, // "ű (U+0022 U+0171)
  0x00, 0x22, 0x01, 0x73, 0x01, // "ų (U+0022 U+0173)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x59, 0x01, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x01, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x62, 0x01, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x01, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x01, // &Ŧ (U+0026 U+0166)
  0x00, 0x26, 0x01, 0x76, 0x01, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x01, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x61, 0x01, // 'a (U+0027 U+0061)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x67, 0x01, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0x6D, 0x01, // 'm (U+0027 U+006D)
  0x00, 0x27, 0x00, 0x6E, 0x01, // 'n (U+0027 U+006E)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x70, 0x01, // 'p (U+0027 U+0070)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0x72, 0x01, // 'r (U+0027 U+0072)
  0x00, 0x27, 0x00, 0x73, 0x01, // 's (U+0027 U+0073)
  0x00, 0x27, 0x00, 0x75, 0x01, // 'u (U+0027 U+0075)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x02, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE1, 0x01, // 'á (U+0027 U+00E1)
  0x00, 0x27, 0x00, 0xE2, 0x01, // 'â (U+0027 U+00E2)
  0x00, 0x27, 0x00, 0xE3, 0x01, // 'ã (U+0027 U+00E3)
  0x00, 0x27, 0x00, 0xE4, 0x01, // 'ä (U+0027 U+00E4)
  0x00, 0x27, 0x00, 0xE5, 0x01, // 'å (U+0027 U+00E5)
  0x00, 0x27, 0x00, 0xE6, 0x01, // 'æ (U+0027 U+00E6)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x00, 0xF9, 0x01, // 'ù (U+0027 U+00F9)
  0x00, 0x27, 0x00, 0xFA, 0x01, // 'ú (U+0027 U+00FA)
  0x00, 0x27, 0x00, 0xFB, 0x01, // 'û (U+0027 U+00FB)
  0x00, 0x27, 0x00, 0xFC, 0x01, // 'ü (U+0027 U+00FC)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x01, 0x01, // 'ā (U+0027 U+0101)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x03, 0x01, // 'ă (U+0027 U+0103)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x05, 0x01, // 'ą (U+0027 U+0105)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x1D, 0x01, // 'ĝ (U+0027 U+011D)
  0x00, 0x27, 0x01, 0x1F, 0x01, // 'ğ (U+0027 U+011F)
  0x00, 0x27, 0x01, 0x21, 0x01, // 'ġ (U+0027 U+0121)
  0x00, 0x27, 0x01, 0x23, 0x01, // 'ģ (U+0027 U+0123)
  0x00, 0x27, 0x01, 0x38, 0x01, // 'ĸ (U+0027 U+0138)
  0x00, 0x27, 0x01, 0x44, 0x01, // 'ń (U+0027 U+0144)
  0x00, 0x27, 0x01, 0x46, 0x01, // 'ņ (U+0027 U+0146)
  0x00, 0x27, 0x01, 0x4B, 0x01, // 'ŋ (U+0027 U+014B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x27, 0x01, 0x55, 0x01, // 'ŕ (U+0027 U+0155)
  0x00, 0x27, 0x01, 0x57, 0x01, // 'ŗ (U+0027 U+0157)
  0x00, 0x27, 0x01, 0x5B, 0x01, // 'ś (U+0027 U+015B)
  0x00, 0x27, 0x01, 0x5F, 0x01, // 'ş (U+0027 U+015F)
  0x00, 0x27, 0x01, 0x69, 0x01, // 'ũ (U+0027 U+0169)
  0x00, 0x27, 0x01, 0x6B, 0x01, // 'ū (U+0027 U+016B)
  0x00, 0x27, 0x01, 0x6D, 0x01, // 'ŭ (U+0027 U+016D)
  0x00, 0x27, 0x01, 0x6F, 0x01, // 'ů (U+0027 U+016F)
  0x00, 0x27, 0x01, 0x71, 0x01, // 'ű (U+0027 U+0171)
  0x00, 0x27, 0x01, 0x73, 0x01, // 'ų (U+0027 U+0173)
  0x00, 0x2C, 0x00, 0x43, 0x01, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x01, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x01, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x01, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x01, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x01, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x01, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x01, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x01, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x01, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x01, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x01, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x01, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x01, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x01, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x01, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x01, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x01, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x01, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x01, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x01, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x01, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x01, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2D, 0x00, 0x54, 0x01, // -T (U+002D U+0054)
  0x00, 0x2D, 0x01, 0x62, 0x01, // -Ţ (U+002D U+0162)
  0x00, 0x2D, 0x01, 0x64, 0x01, // -Ť (U+002D U+0164)
  0x00, 0x2D, 0x01, 0x66, 0x01, // -Ŧ (U+002D U+0166)
  0x00, 0x2E, 0x00, 0x43, 0x01, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x01, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x01, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x01, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x01, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x01, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x01, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x01, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x01, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x01, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x01, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x01, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x01, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x01, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x01, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x01, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x01, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x01, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x01, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x01, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x01, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x01, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x01, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x04, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x04, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x04, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x04, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x04, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x04, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x04, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x04, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x04, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x04, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x56, 0x01, // AV (U+0041 U+0056)
  0x00, 0x41, 0x00, 0x57, 0x01, // AW (U+0041 U+0057)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x74, 0x01, // AŴ (U+0041 U+0174)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x44, 0x00, 0x2C, 0x01, // D, (U+0044 U+002C)
  0x00, 0x44, 0x00, 0x2E, 0x01, // D. (U+0044 U+002E)
  0x00, 0x44, 0x00, 0x54, 0x01, // DT (U+0044 U+0054)
  0x00, 0x44, 0x01, 0x62, 0x01, // DŢ (U+0044 U+0162)
  0x00, 0x44, 0x01, 0x64, 0x01, // DŤ (U+0044 U+0164)
  0x00, 0x44, 0x01, 0x66, 0x01, // DŦ (U+0044 U+0166)
  0x00, 0x44, 0x20, 0x1A, 0x01, // D‚ (U+0044 U+201A)
  0x00, 0x44, 0x20, 0x1E, 0x01, // D„ (U+0044 U+201E)
  0x00, 0x44, 0x20, 0x26, 0x01, // D… (U+0044 U+2026)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x02, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x02, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x19, 0x02, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x02, // L” (U+004C U+201D)
  0x00, 0x4F, 0x00, 0x2C, 0x01, // O, (U+004F U+002C)
  0x00, 0x4F, 0x00, 0x2E, 0x01, // O. (U+004F U+002E)
  0x00, 0x4F, 0x00, 0x54, 0x01, // OT (U+004F U+0054)
  0x00, 0x4F, 0x01, 0x62, 0x01, // OŢ (U+004F U+0162)
  0x00, 0x4F, 0x01, 0x64, 0x01, // OŤ (U+004F U+0164)
  0x00, 0x4F, 0x01, 0x66, 0x01, // OŦ (U+004F U+0166)
  0x00, 0x4F, 0x20, 0x1A, 0x01, // O‚ (U+004F U+201A)
  0x00, 0x4F, 0x20, 0x1E, 0x01, // O„ (U+004F U+201E)
  0x00, 0x4F, 0x20, 0x26, 0x01, // O… (U+004F U+2026)
  0x00, 0x50, 0x00, 0x2C, 0x03, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x03, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x03, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x03, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x03, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x2C, 0x01, // Q, (U+0051 U+002C)
  0x00, 0x51, 0x00, 0x2E, 0x01, // Q. (U+0051 U+002E)
  0x00, 0x51, 0x00, 0x54, 0x01, // QT (U+0051 U+0054)
  0x00, 0x51, 0x01, 0x62, 0x01, // QŢ (U+0051 U+0162)
  0x00, 0x51, 0x01, 0x64, 0x01, // QŤ (U+0051 U+0164)
  0x00, 0x51, 0x01, 0x66, 0x01, // QŦ (U+0051 U+0166)
  0x00, 0x51, 0x20, 0x1A, 0x01, // Q‚ (U+0051 U+201A)
  0x00, 0x51, 0x20, 0x1E, 0x01, // Q„ (U+0051 U+201E)
  0x00, 0x51, 0x20, 0x26, 0x01, // Q… (U+0051 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2D, 0x01, // T- (U+0054 U+002D)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x02, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x01, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x01, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x01, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x01, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x01, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x01, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0x7A, 0x01, // Tz (U+0054 U+007A)
  0x00, 0x54, 0x00, 0xAB, 0x01, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xBB, 0x01, // T» (U+0054 U+00BB)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x02, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x02, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x02, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x02, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x02, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x02, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x01, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x01, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x01, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x01, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x02, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x02, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x02, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x01, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x01, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x01, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x4B, 0x01, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x01, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x01, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x01, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5F, 0x01, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x69, 0x01, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x01, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x01, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x01, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x01, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x01, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x01, 0x7A, 0x01, // Tź (U+0054 U+017A)
  0x00, 0x54, 0x01, 0x7C, 0x01, // Tż (U+0054 U+017C)
  0x00, 0x54, 0x01, 0x7E, 0x01, // Tž (U+0054 U+017E)
  0x00, 0x54, 0x20, 0x13, 0x01, // T– (U+0054 U+2013)
  0x00, 0x54, 0x20, 0x14, 0x01, // T— (U+0054 U+2014)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x01, // T‹ (U+0054 U+2039)
  0x00, 0x54, 0x20, 0x3A, 0x01, // T› (U+0054 U+203A)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0x41, 0x01, // VA (U+0056 U+0041)
  0x00, 0x56, 0x00, 0xAB, 0x01, // V« (U+0056 U+00AB)
  0x00, 0x56, 0x00, 0xC0, 0x01, // VÀ (U+0056 U+00C0)
  0x00, 0x56, 0x00, 0xC1, 0x01, // VÁ (U+0056 U+00C1)
  0x00, 0x56, 0x00, 0xC2, 0x01, // VÂ (U+0056 U+00C2)
  0x00, 0x56, 0x00, 0xC3, 0x01, // VÃ (U+0056 U+00C3)
  0x00, 0x56, 0x00, 0xC4, 0x01, // VÄ (U+0056 U+00C4)
  0x00, 0x56, 0x00, 0xC5, 0x01, // VÅ (U+0056 U+00C5)
  0x00, 0x56, 0x01, 0x00, 0x01, // VĀ (U+0056 U+0100)
  0x00, 0x56, 0x01, 0x02, 0x01, // VĂ (U+0056 U+0102)
  0x00, 0x56, 0x01, 0x04, 0x01, // VĄ (U+0056 U+0104)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x56, 0x20, 0x39, 0x01, // V‹ (U+0056 U+2039)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0x41, 0x01, // WA (U+0057 U+0041)
  0x00, 0x57, 0x00, 0xAB, 0x01, // W« (U+0057 U+00AB)
  0x00, 0x57, 0x00, 0xC0, 0x01, // WÀ (U+0057 U+00C0)
  0x00, 0x57, 0x00, 0xC1, 0x01, // WÁ (U+0057 U+00C1)
  0x00, 0x57, 0x00, 0xC2, 0x01, // WÂ (U+0057 U+00C2)
  0x00, 0x57, 0x00, 0xC3, 0x01, // WÃ (U+0057 U+00C3)
  0x00, 0x57, 0x00, 0xC4, 0x01, // WÄ (U+0057 U+00C4)
  0x00, 0x57, 0x00, 0xC5, 0x01, // WÅ (U+0057 U+00C5)
  0x00, 0x57, 0x01, 0x00, 0x01, // WĀ (U+0057 U+0100)
  0x00, 0x57, 0x01, 0x02, 0x01, // WĂ (U+0057 U+0102)
  0x00, 0x57, 0x01, 0x04, 0x01, // WĄ (U+0057 U+0104)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x57, 0x20, 0x39, 0x01, // W‹ (U+0057 U+2039)
  0x00, 0x59, 0x00, 0x26, 0x01, // Y& (U+0059 U+0026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6D, 0x01, // Ym (U+0059 U+006D)
  0x00, 0x59, 0x00, 0x6E, 0x01, // Yn (U+0059 U+006E)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x70, 0x01, // Yp (U+0059 U+0070)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x72, 0x01, // Yr (U+0059 U+0072)
  0x00, 0x59, 0x00, 0x73, 0x01, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0x75, 0x01, // Yu (U+0059 U+0075)
  0x00, 0x59, 0x00, 0xAB, 0x02, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xBB, 0x01, // Y» (U+0059 U+00BB)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x00, 0xF9, 0x01, // Yù (U+0059 U+00F9)
  0x00, 0x59, 0x00, 0xFA, 0x01, // Yú (U+0059 U+00FA)
  0x00, 0x59, 0x00, 0xFB, 0x01, // Yû (U+0059 U+00FB)
  0x00, 0x59, 0x00, 0xFC, 0x01, // Yü (U+0059 U+00FC)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x38, 0x01, // Yĸ (U+0059 U+0138)
  0x00, 0x59, 0x01, 0x44, 0x01, // Yń (U+0059 U+0144)
  0x00, 0x59, 0x01, 0x46, 0x01, // Yņ (U+0059 U+0146)
  0x00, 0x59, 0x01, 0x4B, 0x01, // Yŋ (U+0059 U+014B)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x55, 0x01, // Yŕ (U+0059 U+0155)
  0x00, 0x59, 0x01, 0x57, 0x01, // Yŗ (U+0059 U+0157)
  0x00, 0x59, 0x01, 0x5B, 0x01, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5F, 0x01, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x69, 0x01, // Yũ (U+0059 U+0169)
  0x00, 0x59, 0x01, 0x6B, 0x01, // Yū (U+0059 U+016B)
  0x00, 0x59, 0x01, 0x6D, 0x01, // Yŭ (U+0059 U+016D)
  0x00, 0x59, 0x01, 0x6F, 0x01, // Yů (U+0059 U+016F)
  0x00, 0x59, 0x01, 0x71, 0x01, // Yű (U+0059 U+0171)
  0x00, 0x59, 0x01, 0x73, 0x01, // Yų (U+0059 U+0173)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x02, // Y‹ (U+0059 U+2039)
  0x00, 0x59, 0x20, 0x3A, 0x01, // Y› (U+0059 U+203A)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0x76, 0x00, 0x2C, 0x01, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xA1, 0x00, 0x59, 0x01, // ¡Y (U+00A1 U+0059)
  0x00, 0xA1, 0x00, 0xDD, 0x01, // ¡Ý (U+00A1 U+00DD)
  0x00, 0xA1, 0x01, 0x76, 0x01, // ¡Ŷ (U+00A1 U+0176)
  0x00, 0xA1, 0x01, 0x78, 0x01, // ¡Ÿ (U+00A1 U+0178)
  0x00, 0xAB, 0x00, 0x54, 0x01, // «T (U+00AB U+0054)
  0x00, 0xAB, 0x00, 0x59, 0x01, // «Y (U+00AB U+0059)
  0x00, 0xAB, 0x00, 0xDD, 0x01, // «Ý (U+00AB U+00DD)
  0x00, 0xAB, 0x01, 0x62, 0x01, // «Ţ (U+00AB U+0162)
  0x00, 0xAB, 0x01, 0x64, 0x01, // «Ť (U+00AB U+0164)
  0x00, 0xAB, 0x01, 0x66, 0x01, // «Ŧ (U+00AB U+0166)
  0x00, 0xAB, 0x01, 0x76, 0x01, // «Ŷ (U+00AB U+0176)
  0x00, 0xAB, 0x01, 0x78, 0x01, // «Ÿ (U+00AB U+0178)
  0x00, 0xBB, 0x00, 0x54, 0x01, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x56, 0x01, // »V (U+00BB U+0056)
  0x00, 0xBB, 0x00, 0x57, 0x01, // »W (U+00BB U+0057)
  0x00, 0xBB, 0x00, 0x59, 0x02, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x02, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x01, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x01, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x01, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x74, 0x01, // »Ŵ (U+00BB U+0174)
  0x00, 0xBB, 0x01, 0x76, 0x02, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x02, // »Ÿ (U+00BB U+0178)
  0x00, 0xBF, 0x00, 0x54, 0x01, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x00, 0x56, 0x01, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x01, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x01, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x01, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x62, 0x01, // ¿Ţ (U+00BF U+0162)
  0x00, 0xBF, 0x01, 0x64, 0x01, // ¿Ť (U+00BF U+0164)
  0x00, 0xBF, 0x01, 0x66, 0x01, // ¿Ŧ (U+00BF U+0166)
  0x00, 0xBF, 0x01, 0x74, 0x01, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x01, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x01, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x56, 0x01, // ÀV (U+00C0 U+0056)
  0x00, 0xC0, 0x00, 0x57, 0x01, // ÀW (U+00C0 U+0057)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x74, 0x01, // ÀŴ (U+00C0 U+0174)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x56, 0x01, // ÁV (U+00C1 U+0056)
  0x00, 0xC1, 0x00, 0x57, 0x01, // ÁW (U+00C1 U+0057)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x74, 0x01, // ÁŴ (U+00C1 U+0174)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x56, 0x01, // ÂV (U+00C2 U+0056)
  0x00, 0xC2, 0x00, 0x57, 0x01, // ÂW (U+00C2 U+0057)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x74, 0x01, // ÂŴ (U+00C2 U+0174)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x56, 0x01, // ÃV (U+00C3 U+0056)
  0x00, 0xC3, 0x00, 0x57, 0x01, // ÃW (U+00C3 U+0057)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x74, 0x01, // ÃŴ (U+00C3 U+0174)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x56, 0x01, // ÄV (U+00C4 U+0056)
  0x00, 0xC4, 0x00, 0x57, 0x01, // ÄW (U+00C4 U+0057)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x74, 0x01, // ÄŴ (U+00C4 U+0174)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x56, 0x01, // ÅV (U+00C5 U+0056)
  0x00, 0xC5, 0x00, 0x57, 0x01, // ÅW (U+00C5 U+0057)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x74, 0x01, // ÅŴ (U+00C5 U+0174)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xD0, 0x00, 0x2C, 0x01, // Ð, (U+00D0 U+002C)
  0x00, 0xD0, 0x00, 0x2E, 0x01, // Ð. (U+00D0 U+002E)
  0x00, 0xD0, 0x00, 0x54, 0x01, // ÐT (U+00D0 U+0054)
  0x00, 0xD0, 0x01, 0x62, 0x01, // ÐŢ (U+00D0 U+0162)
  0x00, 0xD0, 0x01, 0x64, 0x01, // ÐŤ (U+00D0 U+0164)
  0x00, 0xD0, 0x01, 0x66, 0x01, // ÐŦ (U+00D0 U+0166)
  0x00, 0xD0, 0x20, 0x1A, 0x01, // Ð‚ (U+00D0 U+201A)
  0x00, 0xD0, 0x20, 0x1E, 0x01, // Ð„ (U+00D0 U+201E)
  0x00, 0xD0, 0x20, 0x26, 0x01, // Ð… (U+00D0 U+2026)
  0x00, 0xD2, 0x00, 0x2C, 0x01, // Ò, (U+00D2 U+002C)
  0x00, 0xD2, 0x00, 0x2E, 0x01, // Ò. (U+00D2 U+002E)
  0x00, 0xD2, 0x00, 0x54, 0x01, // ÒT (U+00D2 U+0054)
  0x00, 0xD2, 0x01, 0x62, 0x01, // ÒŢ (U+00D2 U+0162)
  0x00, 0xD2, 0x01, 0x64, 0x01, // ÒŤ (U+00D2 U+0164)
  0x00, 0xD2, 0x01, 0x66, 0x01, // ÒŦ (U+00D2 U+0166)
  0x00, 0xD2, 0x20, 0x1A, 0x01, // Ò‚ (U+00D2 U+201A)
  0x00, 0xD2, 0x20, 0x1E, 0x01, // Ò„ (U+00D2 U+201E)
  0x00, 0xD2, 0x20, 0x26, 0x01, // Ò… (U+00D2 U+2026)
  0x00, 0xD3, 0x00, 0x2C, 0x01, // Ó, (U+00D3 U+002C)
  0x00, 0xD3, 0x00, 0x2E, 0x01, // Ó. (U+00D3 U+002E)
  0x00, 0xD3, 0x00, 0x54, 0x01, // ÓT (U+00D3 U+0054)
  0x00, 0xD3, 0x01, 0x62, 0x01, // ÓŢ (U+00D3 U+0162)
  0x00, 0xD3, 0x01, 0x64, 0x01, // ÓŤ (U+00D3 U+0164)
  0x00, 0xD3, 0x01, 0x66, 0x01, // ÓŦ (U+00D3 U+0166)
  0x00, 0xD3, 0x20, 0x1A, 0x01, // Ó‚ (U+00D3 U+201A)
  0x00, 0xD3, 0x20, 0x1E, 0x01, // Ó„ (U+00D3 U+201E)
  0x00, 0xD3, 0x20, 0x26, 0x01, // Ó… (U+00D3 U+2026)
  0x00, 0xD4, 0x00, 0x2C, 0x01, // Ô, (U+00D4 U+002C)
  0x00, 0xD4, 0x00, 0x2E, 0x01, // Ô. (U+00D4 U+002E)
  0x00, 0xD4, 0x00, 0x54, 0x01, // ÔT (U+00D4 U+0054)
  0x00, 0xD4, 0x01, 0x62, 0x01, // ÔŢ (U+00D4 U+0162)
  0x00, 0xD4, 0x01, 0x64, 0x01, // ÔŤ (U+00D4 U+0164)
  0x00, 0xD4, 0x01, 0x66, 0x01, // ÔŦ (U+00D4 U+0166)
  0x00, 0xD4, 0x20, 0x1A, 0x01, // Ô‚ (U+00D4 U+201A)
  0x00, 0xD4, 0x20, 0x1E, 0x01, // Ô„ (U+00D4 U+201E)
  0x00, 0xD4, 0x20, 0x26, 0x01, // Ô… (U+00D4 U+2026)
  0x00, 0xD5, 0x00, 0x2C, 0x01, // Õ, (U+00D5 U+002C)
  0x00, 0xD5, 0x00, 0x2E, 0x01, // Õ. (U+00D5 U+002E)
  0x00, 0xD5, 0x00, 0x54, 0x01, // ÕT (U+00D5 U+0054)
  0x00, 0xD5, 0x01, 0x62, 0x01, // ÕŢ (U+00D5 U+0162)
  0x00, 0xD5, 0x01, 0x64, 0x01, // ÕŤ (U+00D5 U+0164)
  0x00, 0xD5, 0x01, 0x66, 0x01, // ÕŦ (U+00D5 U+0166)
  0x00, 0xD5, 0x20, 0x1A, 0x01, // Õ‚ (U+00D5 U+201A)
  0x00, 0xD5, 0x20, 0x1E, 0x01, // Õ„ (U+00D5 U+201E)
  0x00, 0xD5, 0x20, 0x26, 0x01, // Õ… (U+00D5 U+2026)
  0x00, 0xD6, 0x00, 0x2C, 0x01, // Ö, (U+00D6 U+002C)
  0x00, 0xD6, 0x00, 0x2E, 0x01, // Ö. (U+00D6 U+002E)
  0x00, 0xD6, 0x00, 0x54, 0x01, // ÖT (U+00D6 U+0054)
  0x00, 0xD6, 0x01, 0x62, 0x01, // ÖŢ (U+00D6 U+0162)
  0x00, 0xD6, 0x01, 0x64, 0x01, // ÖŤ (U+00D6 U+0164)
  0x00, 0xD6, 0x01, 0x66, 0x01, // ÖŦ (U+00D6 U+0166)
  0x00, 0xD6, 0x20, 0x1A, 0x01, // Ö‚ (U+00D6 U+201A)
  0x00, 0xD6, 0x20, 0x1E, 0x01, // Ö„ (U+00D6 U+201E)
  0x00, 0xD6, 0x20, 0x26, 0x01, // Ö… (U+00D6 U+2026)
  0x00, 0xD8, 0x00, 0x2C, 0x01, // Ø, (U+00D8 U+002C)
  0x00, 0xD8, 0x00, 0x2E, 0x01, // Ø. (U+00D8 U+002E)
  0x00, 0xD8, 0x00, 0x54, 0x01, // ØT (U+00D8 U+0054)
  0x00, 0xD8, 0x01, 0x62, 0x01, // ØŢ (U+00D8 U+0162)
  0x00, 0xD8, 0x01, 0x64, 0x01, // ØŤ (U+00D8 U+0164)
  0x00, 0xD8, 0x01, 0x66, 0x01, // ØŦ (U+00D8 U+0166)
  0x00, 0xD8, 0x20, 0x1A, 0x01, // Ø‚ (U+00D8 U+201A)
  0x00, 0xD8, 0x20, 0x1E, 0x01, // Ø„ (U+00D8 U+201E)
  0x00, 0xD8, 0x20, 0x26, 0x01, // Ø… (U+00D8 U+2026)
  0x00, 0xDD, 0x00, 0x26, 0x01, // Ý& (U+00DD U+0026)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6D, 0x01, // Ým (U+00DD U+006D)
  0x00, 0xDD, 0x00, 0x6E, 0x01, // Ýn (U+00DD U+006E)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x70, 0x01, // Ýp (U+00DD U+0070)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x72, 0x01, // Ýr (U+00DD U+0072)
  0x00, 0xDD, 0x00, 0x73, 0x01, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0x75, 0x01, // Ýu (U+00DD U+0075)
  0x00, 0xDD, 0x00, 0xAB, 0x02, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xBB, 0x01, // Ý» (U+00DD U+00BB)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x00, 0xF9, 0x01, // Ýù (U+00DD U+00F9)
  0x00, 0xDD, 0x00, 0xFA, 0x01, // Ýú (U+00DD U+00FA)
  0x00, 0xDD, 0x00, 0xFB, 0x01, // Ýû (U+00DD U+00FB)
  0x00, 0xDD, 0x00, 0xFC, 0x01, // Ýü (U+00DD U+00FC)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x38, 0x01, // Ýĸ (U+00DD U+0138)
  0x00, 0xDD, 0x01, 0x44, 0x01, // Ýń (U+00DD U+0144)
  0x00, 0xDD, 0x01, 0x46, 0x01, // Ýņ (U+00DD U+0146)
  0x00, 0xDD, 0x01, 0x4B, 0x01, // Ýŋ (U+00DD U+014B)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x55, 0x01, // Ýŕ (U+00DD U+0155)
  0x00, 0xDD, 0x01, 0x57, 0x01, // Ýŗ (U+00DD U+0157)
  0x00, 0xDD, 0x01, 0x5B, 0x01, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5F, 0x01, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x69, 0x01, // Ýũ (U+00DD U+0169)
  0x00, 0xDD, 0x01, 0x6B, 0x01, // Ýū (U+00DD U+016B)
  0x00, 0xDD, 0x01, 0x6D, 0x01, // Ýŭ (U+00DD U+016D)
  0x00, 0xDD, 0x01, 0x6F, 0x01, // Ýů (U+00DD U+016F)
  0x00, 0xDD, 0x01, 0x71, 0x01, // Ýű (U+00DD U+0171)
  0x00, 0xDD, 0x01, 0x73, 0x01, // Ýų (U+00DD U+0173)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x02, // Ý‹ (U+00DD U+2039)
  0x00, 0xDD, 0x20, 0x3A, 0x01, // Ý› (U+00DD U+203A)
  0x00, 0xDE, 0x00, 0x2C, 0x03, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x03, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x00, 0x41, 0x01, // ÞA (U+00DE U+0041)
  0x00, 0xDE, 0x00, 0xC0, 0x01, // ÞÀ (U+00DE U+00C0)
  0x00, 0xDE, 0x00, 0xC1, 0x01, // ÞÁ (U+00DE U+00C1)
  0x00, 0xDE, 0x00, 0xC2, 0x01, // ÞÂ (U+00DE U+00C2)
  0x00, 0xDE, 0x00, 0xC3, 0x01, // ÞÃ (U+00DE U+00C3)
  0x00, 0xDE, 0x00, 0xC4, 0x01, // ÞÄ (U+00DE U+00C4)
  0x00, 0xDE, 0x00, 0xC5, 0x01, // ÞÅ (U+00DE U+00C5)
  0x00, 0xDE, 0x00, 0xC6, 0x01, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDE, 0x01, 0x00, 0x01, // ÞĀ (U+00DE U+0100)
  0x00, 0xDE, 0x01, 0x02, 0x01, // ÞĂ (U+00DE U+0102)
  0x00, 0xDE, 0x01, 0x04, 0x01, // ÞĄ (U+00DE U+0104)
  0x00, 0xDE, 0x20, 0x1A, 0x03, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x03, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x03, // Þ… (U+00DE U+2026)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x56, 0x01, // ĀV (U+0100 U+0056)
  0x01, 0x00, 0x00, 0x57, 0x01, // ĀW (U+0100 U+0057)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x74, 0x01, // ĀŴ (U+0100 U+0174)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x56, 0x01, // ĂV (U+0102 U+0056)
  0x01, 0x02, 0x00, 0x57, 0x01, // ĂW (U+0102 U+0057)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x74, 0x01, // ĂŴ (U+0102 U+0174)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x56, 0x01, // ĄV (U+0104 U+0056)
  0x01, 0x04, 0x00, 0x57, 0x01, // ĄW (U+0104 U+0057)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x74, 0x01, // ĄŴ (U+0104 U+0174)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x0E, 0x00, 0x2C, 0x01, // Ď, (U+010E U+002C)
  0x01, 0x0E, 0x00, 0x2E, 0x01, // Ď. (U+010E U+002E)
  0x01, 0x0E, 0x00, 0x54, 0x01, // ĎT (U+010E U+0054)
  0x01, 0x0E, 0x01, 0x62, 0x01, // ĎŢ (U+010E U+0162)
  0x01, 0x0E, 0x01, 0x64, 0x01, // ĎŤ (U+010E U+0164)
  0x01, 0x0E, 0x01, 0x66, 0x01, // ĎŦ (U+010E U+0166)
  0x01, 0x0E, 0x20, 0x1A, 0x01, // Ď‚ (U+010E U+201A)
  0x01, 0x0E, 0x20, 0x1E, 0x01, // Ď„ (U+010E U+201E)
  0x01, 0x0E, 0x20, 0x26, 0x01, // Ď… (U+010E U+2026)
  0x01, 0x10, 0x00, 0x2C, 0x01, // Đ, (U+0110 U+002C)
  0x01, 0x10, 0x00, 0x2E, 0x01, // Đ. (U+0110 U+002E)
  0x01, 0x10, 0x00, 0x54, 0x01, // ĐT (U+0110 U+0054)
  0x01, 0x10, 0x01, 0x62, 0x01, // ĐŢ (U+0110 U+0162)
  0x01, 0x10, 0x01, 0x64, 0x01, // ĐŤ (U+0110 U+0164)
  0x01, 0x10, 0x01, 0x66, 0x01, // ĐŦ (U+0110 U+0166)
  0x01, 0x10, 0x20, 0x1A, 0x01, // Đ‚ (U+0110 U+201A)
  0x01, 0x10, 0x20, 0x1E, 0x01, // Đ„ (U+0110 U+201E)
  0x01, 0x10, 0x20, 0x26, 0x01, // Đ… (U+0110 U+2026)
  0x01, 0x39, 0x00, 0x22, 0x02, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x02, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x19, 0x02, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x02, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x02, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x02, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x19, 0x02, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x02, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x02, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x02, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x00, 0x59, 0x01, // ĽY (U+013D U+0059)
  0x01, 0x3D, 0x00, 0xDD, 0x01, // ĽÝ (U+013D U+00DD)
  0x01, 0x3D, 0x01, 0x76, 0x01, // ĽŶ (U+013D U+0176)
  0x01, 0x3D, 0x01, 0x78, 0x01, // ĽŸ (U+013D U+0178)
  0x01, 0x3D, 0x20, 0x19, 0x02, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x02, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x02, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x02, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x00, 0x59, 0x01, // ĿY (U+013F U+0059)
  0x01, 0x3F, 0x00, 0xDD, 0x01, // ĿÝ (U+013F U+00DD)
  0x01, 0x3F, 0x01, 0x76, 0x01, // ĿŶ (U+013F U+0176)
  0x01, 0x3F, 0x01, 0x78, 0x01, // ĿŸ (U+013F U+0178)
  0x01, 0x3F, 0x20, 0x19, 0x02, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x02, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x02, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x02, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x19, 0x02, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x02, // Ł” (U+0141 U+201D)
  0x01, 0x4C, 0x00, 0x2C, 0x01, // Ō, (U+014C U+002C)
  0x01, 0x4C, 0x00, 0x2E, 0x01, // Ō. (U+014C U+002E)
  0x01, 0x4C, 0x00, 0x54, 0x01, // ŌT (U+014C U+0054)
  0x01, 0x4C, 0x01, 0x62, 0x01, // ŌŢ (U+014C U+0162)
  0x01, 0x4C, 0x01, 0x64, 0x01, // ŌŤ (U+014C U+0164)
  0x01, 0x4C, 0x01, 0x66, 0x01, // ŌŦ (U+014C U+0166)
  0x01, 0x4C, 0x20, 0x1A, 0x01, // Ō‚ (U+014C U+201A)
  0x01, 0x4C, 0x20, 0x1E, 0x01, // Ō„ (U+014C U+201E)
  0x01, 0x4C, 0x20, 0x26, 0x01, // Ō… (U+014C U+2026)
  0x01, 0x4E, 0x00, 0x2C, 0x01, // Ŏ, (U+014E U+002C)
  0x01, 0x4E, 0x00, 0x2E, 0x01, // Ŏ. (U+014E U+002E)
  0x01, 0x4E, 0x00, 0x54, 0x01, // ŎT (U+014E U+0054)
  0x01, 0x4E, 0x01, 0x62, 0x01, // ŎŢ (U+014E U+0162)
  0x01, 0x4E, 0x01, 0x64, 0x01, // ŎŤ (U+014E U+0164)
  0x01, 0x4E, 0x01, 0x66, 0x01, // ŎŦ (U+014E U+0166)
  0x01, 0x4E, 0x20, 0x1A, 0x01, // Ŏ‚ (U+014E U+201A)
  0x01, 0x4E, 0x20, 0x1E, 0x01, // Ŏ„ (U+014E U+201E)
  0x01, 0x4E, 0x20, 0x26, 0x01, // Ŏ… (U+014E U+2026)
  0x01, 0x50, 0x00, 0x2C, 0x01, // Ő, (U+0150 U+002C)
  0x01, 0x50, 0x00, 0x2E, 0x01, // Ő. (U+0150 U+002E)
  0x01, 0x50, 0x00, 0x54, 0x01, // ŐT (U+0150 U+0054)
  0x01, 0x50, 0x01, 0x62, 0x01, // ŐŢ (U+0150 U+0162)
  0x01, 0x50, 0x01, 0x64, 0x01, // ŐŤ (U+0150 U+0164)
  0x01, 0x50, 0x01, 0x66, 0x01, // ŐŦ (U+0150 U+0166)
  0x01, 0x50, 0x20, 0x1A, 0x01, // Ő‚ (U+0150 U+201A)
  0x01, 0x50, 0x20, 0x1E, 0x01, // Ő„ (U+0150 U+201E)
  0x01, 0x50, 0x20, 0x26, 0x01, // Ő… (U+0150 U+2026)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2D, 0x01, // Ţ- (U+0162 U+002D)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x02, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x01, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x01, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x01, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x01, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x01, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x01, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0x7A, 0x01, // Ţz (U+0162 U+007A)
  0x01, 0x62, 0x00, 0xAB, 0x01, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xBB, 0x01, // Ţ» (U+0162 U+00BB)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x02, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x02, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x02, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x02, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x02, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x02, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x01, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x01, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x01, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x01, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x02, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x02, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x02, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x01, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x01, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x01, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x4B, 0x01, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x01, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x01, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x01, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5F, 0x01, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x69, 0x01, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x01, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x01, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x01, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x01, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x01, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x01, 0x7A, 0x01, // Ţź (U+0162 U+017A)
  0x01, 0x62, 0x01, 0x7C, 0x01, // Ţż (U+0162 U+017C)
  0x01, 0x62, 0x01, 0x7E, 0x01, // Ţž (U+0162 U+017E)
  0x01, 0x62, 0x20, 0x13, 0x01, // Ţ– (U+0162 U+2013)
  0x01, 0x62, 0x20, 0x14, 0x01, // Ţ— (U+0162 U+2014)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x01, // Ţ‹ (U+0162 U+2039)
  0x01, 0x62, 0x20, 0x3A, 0x01, // Ţ› (U+0162 U+203A)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2D, 0x01, // Ť- (U+0164 U+002D)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x02, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x01, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x01, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x01, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x01, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x01, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x01, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0x7A, 0x01, // Ťz (U+0164 U+007A)
  0x01, 0x64, 0x00, 0xAB, 0x01, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xBB, 0x01, // Ť» (U+0164 U+00BB)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x02, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x02, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x02, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x02, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x02, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x02, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x01, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x01, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x01, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x01, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x02, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x02, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x02, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x01, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x01, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x01, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x4B, 0x01, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x01, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x01, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x01, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5F, 0x01, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x69, 0x01, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x01, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x01, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x01, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x01, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x01, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x01, 0x7A, 0x01, // Ťź (U+0164 U+017A)
  0x01, 0x64, 0x01, 0x7C, 0x01, // Ťż (U+0164 U+017C)
  0x01, 0x64, 0x01, 0x7E, 0x01, // Ťž (U+0164 U+017E)
  0x01, 0x64, 0x20, 0x13, 0x01, // Ť– (U+0164 U+2013)
  0x01, 0x64, 0x20, 0x14, 0x01, // Ť— (U+0164 U+2014)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x01, // Ť‹ (U+0164 U+2039)
  0x01, 0x64, 0x20, 0x3A, 0x01, // Ť› (U+0164 U+203A)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2D, 0x01, // Ŧ- (U+0166 U+002D)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x02, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x01, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x01, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x01, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x01, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x01, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x01, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0x7A, 0x01, // Ŧz (U+0166 U+007A)
  0x01, 0x66, 0x00, 0xAB, 0x01, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xBB, 0x01, // Ŧ» (U+0166 U+00BB)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x02, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x02, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x02, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x02, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x02, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x02, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x01, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x01, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x01, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x01, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x02, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x02, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x02, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x01, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x01, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x01, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x4B, 0x01, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x01, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x01, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x01, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5F, 0x01, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x69, 0x01, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x01, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x01, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x01, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x01, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x01, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x01, 0x7A, 0x01, // Ŧź (U+0166 U+017A)
  0x01, 0x66, 0x01, 0x7C, 0x01, // Ŧż (U+0166 U+017C)
  0x01, 0x66, 0x01, 0x7E, 0x01, // Ŧž (U+0166 U+017E)
  0x01, 0x66, 0x20, 0x13, 0x01, // Ŧ– (U+0166 U+2013)
  0x01, 0x66, 0x20, 0x14, 0x01, // Ŧ— (U+0166 U+2014)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x01, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x66, 0x20, 0x3A, 0x01, // Ŧ› (U+0166 U+203A)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0x41, 0x01, // ŴA (U+0174 U+0041)
  0x01, 0x74, 0x00, 0xAB, 0x01, // Ŵ« (U+0174 U+00AB)
  0x01, 0x74, 0x00, 0xC0, 0x01, // ŴÀ (U+0174 U+00C0)
  0x01, 0x74, 0x00, 0xC1, 0x01, // ŴÁ (U+0174 U+00C1)
  0x01, 0x74, 0x00, 0xC2, 0x01, // ŴÂ (U+0174 U+00C2)
  0x01, 0x74, 0x00, 0xC3, 0x01, // ŴÃ (U+0174 U+00C3)
  0x01, 0x74, 0x00, 0xC4, 0x01, // ŴÄ (U+0174 U+00C4)
  0x01, 0x74, 0x00, 0xC5, 0x01, // ŴÅ (U+0174 U+00C5)
  0x01, 0x74, 0x01, 0x00, 0x01, // ŴĀ (U+0174 U+0100)
  0x01, 0x74, 0x01, 0x02, 0x01, // ŴĂ (U+0174 U+0102)
  0x01, 0x74, 0x01, 0x04, 0x01, // ŴĄ (U+0174 U+0104)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x74, 0x20, 0x39, 0x01, // Ŵ‹ (U+0174 U+2039)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x26, 0x01, // Ŷ& (U+0176 U+0026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6D, 0x01, // Ŷm (U+0176 U+006D)
  0x01, 0x76, 0x00, 0x6E, 0x01, // Ŷn (U+0176 U+006E)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x70, 0x01, // Ŷp (U+0176 U+0070)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x72, 0x01, // Ŷr (U+0176 U+0072)
  0x01, 0x76, 0x00, 0x73, 0x01, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0x75, 0x01, // Ŷu (U+0176 U+0075)
  0x01, 0x76, 0x00, 0xAB, 0x02, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xBB, 0x01, // Ŷ» (U+0176 U+00BB)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x00, 0xF9, 0x01, // Ŷù (U+0176 U+00F9)
  0x01, 0x76, 0x00, 0xFA, 0x01, // Ŷú (U+0176 U+00FA)
  0x01, 0x76, 0x00, 0xFB, 0x01, // Ŷû (U+0176 U+00FB)
  0x01, 0x76, 0x00, 0xFC, 0x01, // Ŷü (U+0176 U+00FC)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x38, 0x01, // Ŷĸ (U+0176 U+0138)
  0x01, 0x76, 0x01, 0x44, 0x01, // Ŷń (U+0176 U+0144)
  0x01, 0x76, 0x01, 0x46, 0x01, // Ŷņ (U+0176 U+0146)
  0x01, 0x76, 0x01, 0x4B, 0x01, // Ŷŋ (U+0176 U+014B)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x55, 0x01, // Ŷŕ (U+0176 U+0155)
  0x01, 0x76, 0x01, 0x57, 0x01, // Ŷŗ (U+0176 U+0157)
  0x01, 0x76, 0x01, 0x5B, 0x01, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5F, 0x01, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x69, 0x01, // Ŷũ (U+0176 U+0169)
  0x01, 0x76, 0x01, 0x6B, 0x01, // Ŷū (U+0176 U+016B)
  0x01, 0x76, 0x01, 0x6D, 0x01, // Ŷŭ (U+0176 U+016D)
  0x01, 0x76, 0x01, 0x6F, 0x01, // Ŷů (U+0176 U+016F)
  0x01, 0x76, 0x01, 0x71, 0x01, // Ŷű (U+0176 U+0171)
  0x01, 0x76, 0x01, 0x73, 0x01, // Ŷų (U+0176 U+0173)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x02, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x76, 0x20, 0x3A, 0x01, // Ŷ› (U+0176 U+203A)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x26, 0x01, // Ÿ& (U+0178 U+0026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6D, 0x01, // Ÿm (U+0178 U+006D)
  0x01, 0x78, 0x00, 0x6E, 0x01, // Ÿn (U+0178 U+006E)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x70, 0x01, // Ÿp (U+0178 U+0070)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x72, 0x01, // Ÿr (U+0178 U+0072)
  0x01, 0x78, 0x00, 0x73, 0x01, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0x75, 0x01, // Ÿu (U+0178 U+0075)
  0x01, 0x78, 0x00, 0xAB, 0x02, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xBB, 0x01, // Ÿ» (U+0178 U+00BB)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x00, 0xF9, 0x01, // Ÿù (U+0178 U+00F9)
  0x01, 0x78, 0x00, 0xFA, 0x01, // Ÿú (U+0178 U+00FA)
  0x01, 0x78, 0x00, 0xFB, 0x01, // Ÿû (U+0178 U+00FB)
  0x01, 0x78, 0x00, 0xFC, 0x01, // Ÿü (U+0178 U+00FC)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x38, 0x01, // Ÿĸ (U+0178 U+0138)
  0x01, 0x78, 0x01, 0x44, 0x01, // Ÿń (U+0178 U+0144)
  0x01, 0x78, 0x01, 0x46, 0x01, // Ÿņ (U+0178 U+0146)
  0x01, 0x78, 0x01, 0x4B, 0x01, // Ÿŋ (U+0178 U+014B)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x55, 0x01, // Ÿŕ (U+0178 U+0155)
  0x01, 0x78, 0x01, 0x57, 0x01, // Ÿŗ (U+0178 U+0157)
  0x01, 0x78, 0x01, 0x5B, 0x01, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5F, 0x01, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x69, 0x01, // Ÿũ (U+0178 U+0169)
  0x01, 0x78, 0x01, 0x6B, 0x01, // Ÿū (U+0178 U+016B)
  0x01, 0x78, 0x01, 0x6D, 0x01, // Ÿŭ (U+0178 U+016D)
  0x01, 0x78, 0x01, 0x6F, 0x01, // Ÿů (U+0178 U+016F)
  0x01, 0x78, 0x01, 0x71, 0x01, // Ÿű (U+0178 U+0171)
  0x01, 0x78, 0x01, 0x73, 0x01, // Ÿų (U+0178 U+0173)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x02, // Ÿ‹ (U+0178 U+2039)
  0x01, 0x78, 0x20, 0x3A, 0x01, // Ÿ› (U+0178 U+203A)
  0x20, 0x13, 0x00, 0x54, 0x01, // –T (U+2013 U+0054)
  0x20, 0x13, 0x01, 0x62, 0x01, // –Ţ (U+2013 U+0162)
  0x20, 0x13, 0x01, 0x64, 0x01, // –Ť (U+2013 U+0164)
  0x20, 0x13, 0x01, 0x66, 0x01, // –Ŧ (U+2013 U+0166)
  0x20, 0x14, 0x00, 0x54, 0x01, // —T (U+2014 U+0054)
  0x20, 0x14, 0x01, 0x62, 0x01, // —Ţ (U+2014 U+0162)
  0x20, 0x14, 0x01, 0x64, 0x01, // —Ť (U+2014 U+0164)
  0x20, 0x14, 0x01, 0x66, 0x01, // —Ŧ (U+2014 U+0166)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x61, 0x01, // ‘a (U+2018 U+0061)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x67, 0x01, // ‘g (U+2018 U+0067)
  0x20, 0x18, 0x00, 0x6D, 0x01, // ‘m (U+2018 U+006D)
  0x20, 0x18, 0x00, 0x6E, 0x01, // ‘n (U+2018 U+006E)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x70, 0x01, // ‘p (U+2018 U+0070)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0x72, 0x01, // ‘r (U+2018 U+0072)
  0x20, 0x18, 0x00, 0x73, 0x01, // ‘s (U+2018 U+0073)
  0x20, 0x18, 0x00, 0x75, 0x01, // ‘u (U+2018 U+0075)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x02, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE1, 0x01, // ‘á (U+2018 U+00E1)
  0x20, 0x18, 0x00, 0xE2, 0x01, // ‘â (U+2018 U+00E2)
  0x20, 0x18, 0x00, 0xE3, 0x01, // ‘ã (U+2018 U+00E3)
  0x20, 0x18, 0x00, 0xE4, 0x01, // ‘ä (U+2018 U+00E4)
  0x20, 0x18, 0x00, 0xE5, 0x01, // ‘å (U+2018 U+00E5)
  0x20, 0x18, 0x00, 0xE6, 0x01, // ‘æ (U+2018 U+00E6)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x00, 0xF9, 0x01, // ‘ù (U+2018 U+00F9)
  0x20, 0x18, 0x00, 0xFA, 0x01, // ‘ú (U+2018 U+00FA)
  0x20, 0x18, 0x00, 0xFB, 0x01, // ‘û (U+2018 U+00FB)
  0x20, 0x18, 0x00, 0xFC, 0x01, // ‘ü (U+2018 U+00FC)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x01, 0x01, // ‘ā (U+2018 U+0101)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x03, 0x01, // ‘ă (U+2018 U+0103)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x05, 0x01, // ‘ą (U+2018 U+0105)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x1D, 0x01, // ‘ĝ (U+2018 U+011D)
  0x20, 0x18, 0x01, 0x1F, 0x01, // ‘ğ (U+2018 U+011F)
  0x20, 0x18, 0x01, 0x21, 0x01, // ‘ġ (U+2018 U+0121)
  0x20, 0x18, 0x01, 0x23, 0x01, // ‘ģ (U+2018 U+0123)
  0x20, 0x18, 0x01, 0x38, 0x01, // ‘ĸ (U+2018 U+0138)
  0x20, 0x18, 0x01, 0x44, 0x01, // ‘ń (U+2018 U+0144)
  0x20, 0x18, 0x01, 0x46, 0x01, // ‘ņ (U+2018 U+0146)
  0x20, 0x18, 0x01, 0x4B, 0x01, // ‘ŋ (U+2018 U+014B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x18, 0x01, 0x55, 0x01, // ‘ŕ (U+2018 U+0155)
  0x20, 0x18, 0x01, 0x57, 0x01, // ‘ŗ (U+2018 U+0157)
  0x20, 0x18, 0x01, 0x5B, 0x01, // ‘ś (U+2018 U+015B)
  0x20, 0x18, 0x01, 0x5F, 0x01, // ‘ş (U+2018 U+015F)
  0x20, 0x18, 0x01, 0x69, 0x01, // ‘ũ (U+2018 U+0169)
  0x20, 0x18, 0x01, 0x6B, 0x01, // ‘ū (U+2018 U+016B)
  0x20, 0x18, 0x01, 0x6D, 0x01, // ‘ŭ (U+2018 U+016D)
  0x20, 0x18, 0x01, 0x6F, 0x01, // ‘ů (U+2018 U+016F)
  0x20, 0x18, 0x01, 0x71, 0x01, // ‘ű (U+2018 U+0171)
  0x20, 0x18, 0x01, 0x73, 0x01, // ‘ų (U+2018 U+0173)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x61, 0x01, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x67, 0x01, // ’g (U+2019 U+0067)
  0x20, 0x19, 0x00, 0x6D, 0x01, // ’m (U+2019 U+006D)
  0x20, 0x19, 0x00, 0x6E, 0x01, // ’n (U+2019 U+006E)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x70, 0x01, // ’p (U+2019 U+0070)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0x72, 0x01, // ’r (U+2019 U+0072)
  0x20, 0x19, 0x00, 0x73, 0x01, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0x75, 0x01, // ’u (U+2019 U+0075)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x02, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x01, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x01, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x01, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x01, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x01, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x01, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x00, 0xF9, 0x01, // ’ù (U+2019 U+00F9)
  0x20, 0x19, 0x00, 0xFA, 0x01, // ’ú (U+2019 U+00FA)
  0x20, 0x19, 0x00, 0xFB, 0x01, // ’û (U+2019 U+00FB)
  0x20, 0x19, 0x00, 0xFC, 0x01, // ’ü (U+2019 U+00FC)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x01, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x01, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x01, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x1D, 0x01, // ’ĝ (U+2019 U+011D)
  0x20, 0x19, 0x01, 0x1F, 0x01, // ’ğ (U+2019 U+011F)
  0x20, 0x19, 0x01, 0x21, 0x01, // ’ġ (U+2019 U+0121)
  0x20, 0x19, 0x01, 0x23, 0x01, // ’ģ (U+2019 U+0123)
  0x20, 0x19, 0x01, 0x38, 0x01, // ’ĸ (U+2019 U+0138)
  0x20, 0x19, 0x01, 0x44, 0x01, // ’ń (U+2019 U+0144)
  0x20, 0x19, 0x01, 0x46, 0x01, // ’ņ (U+2019 U+0146)
  0x20, 0x19, 0x01, 0x4B, 0x01, // ’ŋ (U+2019 U+014B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x19, 0x01, 0x55, 0x01, // ’ŕ (U+2019 U+0155)
  0x20, 0x19, 0x01, 0x57, 0x01, // ’ŗ (U+2019 U+0157)
  0x20, 0x19, 0x01, 0x5B, 0x01, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5F, 0x01, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x69, 0x01, // ’ũ (U+2019 U+0169)
  0x20, 0x19, 0x01, 0x6B, 0x01, // ’ū (U+2019 U+016B)
  0x20, 0x19, 0x01, 0x6D, 0x01, // ’ŭ (U+2019 U+016D)
  0x20, 0x19, 0x01, 0x6F, 0x01, // ’ů (U+2019 U+016F)
  0x20, 0x19, 0x01, 0x71, 0x01, // ’ű (U+2019 U+0171)
  0x20, 0x19, 0x01, 0x73, 0x01, // ’ų (U+2019 U+0173)
  0x20, 0x1A, 0x00, 0x43, 0x01, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x01, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x01, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x01, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x01, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x01, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x01, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x01, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x01, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x01, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x01, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x01, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x01, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x01, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x01, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x01, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x01, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x01, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x01, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x01, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x01, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x01, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x01, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x61, 0x01, // “a (U+201C U+0061)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x67, 0x01, // “g (U+201C U+0067)
  0x20, 0x1C, 0x00, 0x6D, 0x01, // “m (U+201C U+006D)
  0x20, 0x1C, 0x00, 0x6E, 0x01, // “n (U+201C U+006E)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x70, 0x01, // “p (U+201C U+0070)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0x72, 0x01, // “r (U+201C U+0072)
  0x20, 0x1C, 0x00, 0x73, 0x01, // “s (U+201C U+0073)
  0x20, 0x1C, 0x00, 0x75, 0x01, // “u (U+201C U+0075)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x02, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE1, 0x01, // “á (U+201C U+00E1)
  0x20, 0x1C, 0x00, 0xE2, 0x01, // “â (U+201C U+00E2)
  0x20, 0x1C, 0x00, 0xE3, 0x01, // “ã (U+201C U+00E3)
  0x20, 0x1C, 0x00, 0xE4, 0x01, // “ä (U+201C U+00E4)
  0x20, 0x1C, 0x00, 0xE5, 0x01, // “å (U+201C U+00E5)
  0x20, 0x1C, 0x00, 0xE6, 0x01, // “æ (U+201C U+00E6)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x00, 0xF9, 0x01, // “ù (U+201C U+00F9)
  0x20, 0x1C, 0x00, 0xFA, 0x01, // “ú (U+201C U+00FA)
  0x20, 0x1C, 0x00, 0xFB, 0x01, // “û (U+201C U+00FB)
  0x20, 0x1C, 0x00, 0xFC, 0x01, // “ü (U+201C U+00FC)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x01, 0x01, // “ā (U+201C U+0101)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x03, 0x01, // “ă (U+201C U+0103)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x05, 0x01, // “ą (U+201C U+0105)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x1D, 0x01, // “ĝ (U+201C U+011D)
  0x20, 0x1C, 0x01, 0x1F, 0x01, // “ğ (U+201C U+011F)
  0x20, 0x1C, 0x01, 0x21, 0x01, // “ġ (U+201C U+0121)
  0x20, 0x1C, 0x01, 0x23, 0x01, // “ģ (U+201C U+0123)
  0x20, 0x1C, 0x01, 0x38, 0x01, // “ĸ (U+201C U+0138)
  0x20, 0x1C, 0x01, 0x44, 0x01, // “ń (U+201C U+0144)
  0x20, 0x1C, 0x01, 0x46, 0x01, // “ņ (U+201C U+0146)
  0x20, 0x1C, 0x01, 0x4B, 0x01, // “ŋ (U+201C U+014B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1C, 0x01, 0x55, 0x01, // “ŕ (U+201C U+0155)
  0x20, 0x1C, 0x01, 0x57, 0x01, // “ŗ (U+201C U+0157)
  0x20, 0x1C, 0x01, 0x5B, 0x01, // “ś (U+201C U+015B)
  0x20, 0x1C, 0x01, 0x5F, 0x01, // “ş (U+201C U+015F)
  0x20, 0x1C, 0x01, 0x69, 0x01, // “ũ (U+201C U+0169)
  0x20, 0x1C, 0x01, 0x6B, 0x01, // “ū (U+201C U+016B)
  0x20, 0x1C, 0x01, 0x6D, 0x01, // “ŭ (U+201C U+016D)
  0x20, 0x1C, 0x01, 0x6F, 0x01, // “ů (U+201C U+016F)
  0x20, 0x1C, 0x01, 0x71, 0x01, // “ű (U+201C U+0171)
  0x20, 0x1C, 0x01, 0x73, 0x01, // “ų (U+201C U+0173)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x61, 0x01, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x67, 0x01, // ”g (U+201D U+0067)
  0x20, 0x1D, 0x00, 0x6D, 0x01, // ”m (U+201D U+006D)
  0x20, 0x1D, 0x00, 0x6E, 0x01, // ”n (U+201D U+006E)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x70, 0x01, // ”p (U+201D U+0070)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0x72, 0x01, // ”r (U+201D U+0072)
  0x20, 0x1D, 0x00, 0x73, 0x01, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0x75, 0x01, // ”u (U+201D U+0075)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x02, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x01, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x01, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x01, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x01, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x01, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x01, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x00, 0xF9, 0x01, // ”ù (U+201D U+00F9)
  0x20, 0x1D, 0x00, 0xFA, 0x01, // ”ú (U+201D U+00FA)
  0x20, 0x1D, 0x00, 0xFB, 0x01, // ”û (U+201D U+00FB)
  0x20, 0x1D, 0x00, 0xFC, 0x01, // ”ü (U+201D U+00FC)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x01, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x01, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x01, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x1D, 0x01, // ”ĝ (U+201D U+011D)
  0x20, 0x1D, 0x01, 0x1F, 0x01, // ”ğ (U+201D U+011F)
  0x20, 0x1D, 0x01, 0x21, 0x01, // ”ġ (U+201D U+0121)
  0x20, 0x1D, 0x01, 0x23, 0x01, // ”ģ (U+201D U+0123)
  0x20, 0x1D, 0x01, 0x38, 0x01, // ”ĸ (U+201D U+0138)
  0x20, 0x1D, 0x01, 0x44, 0x01, // ”ń (U+201D U+0144)
  0x20, 0x1D, 0x01, 0x46, 0x01, // ”ņ (U+201D U+0146)
  0x20, 0x1D, 0x01, 0x4B, 0x01, // ”ŋ (U+201D U+014B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1D, 0x01, 0x55, 0x01, // ”ŕ (U+201D U+0155)
  0x20, 0x1D, 0x01, 0x57, 0x01, // ”ŗ (U+201D U+0157)
  0x20, 0x1D, 0x01, 0x5B, 0x01, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5F, 0x01, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x69, 0x01, // ”ũ (U+201D U+0169)
  0x20, 0x1D, 0x01, 0x6B, 0x01, // ”ū (U+201D U+016B)
  0x20, 0x1D, 0x01, 0x6D, 0x01, // ”ŭ (U+201D U+016D)
  0x20, 0x1D, 0x01, 0x6F, 0x01, // ”ů (U+201D U+016F)
  0x20, 0x1D, 0x01, 0x71, 0x01, // ”ű (U+201D U+0171)
  0x20, 0x1D, 0x01, 0x73, 0x01, // ”ų (U+201D U+0173)
  0x20, 0x1E, 0x00, 0x43, 0x01, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x01, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x01, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x01, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x01, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x01, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x01, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x01, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x01, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x01, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x01, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x01, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x01, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x01, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x01, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x01, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x01, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x01, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x01, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x01, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x01, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x01, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x01, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x39, 0x00, 0x54, 0x01, // ‹T (U+2039 U+0054)
  0x20, 0x39, 0x00, 0x59, 0x01, // ‹Y (U+2039 U+0059)
  0x20, 0x39, 0x00, 0xDD, 0x01, // ‹Ý (U+2039 U+00DD)
  0x20, 0x39, 0x01, 0x62, 0x01, // ‹Ţ (U+2039 U+0162)
  0x20, 0x39, 0x01, 0x64, 0x01, // ‹Ť (U+2039 U+0164)
  0x20, 0x39, 0x01, 0x66, 0x01, // ‹Ŧ (U+2039 U+0166)
  0x20, 0x39, 0x01, 0x76, 0x01, // ‹Ŷ (U+2039 U+0176)
  0x20, 0x39, 0x01, 0x78, 0x01, // ‹Ÿ (U+2039 U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x01, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x56, 0x01, // ›V (U+203A U+0056)
  0x20, 0x3A, 0x00, 0x57, 0x01, // ›W (U+203A U+0057)
  0x20, 0x3A, 0x00, 0x59, 0x02, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x02, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x01, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x01, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x01, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x74, 0x01, // ›Ŵ (U+203A U+0174)
  0x20, 0x3A, 0x01, 0x76, 0x02, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x02, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x04, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x04, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x04, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x04, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x04, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x04, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x04, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x04, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x04, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x04, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x07, 0xA8, 0xB1, 0x6F, 0xE5, 0xFD, 0x5F, 0xC4, 0xFB, 0x3F, 0xB2, 0xFA, 0x1F, 0x91, 0xF8, 0x0F,
  0x83, 0x82, 0x3C, 0x99, 0xA8, 0x14, 0xEB,
  // """ (U+0022)
  0x8C, 0x0A, 0xF6, 0x0D, 0xF3, 0x9F, 0x40, 0xCF, 0x17, 0xF3, 0x0A, 0xF0, 0x6F, 0x20, 0x9E, 0x05,
  0xF1, 0x08, 0xD1,
  // "#" (U+0023)
  0x48, 0x13, 0xF6, 0x20, 0xE0, 0x96, 0x85, 0x6F, 0x30, 0x2F, 0x66, 0x09, 0x92, 0x81, 0x5F, 0x36,
  0x00, 0xC2, 0x08, 0x94, 0x0C, 0xFB, 0x89, 0x46, 0x06, 0x8A, 0xFB, 0x88, 0xFC, 0x88, 0x33, 0x85,
  0x6F, 0x30, 0x2F, 0x66, 0x09, 0x92, 0x81, 0x6F, 0x33, 0x89, 0x45, 0xBB, 0xEF, 0xBB, 0xDF, 0xBB,
  0x80, 0x8F, 0xB0, 0xB3, 0x81, 0x2F, 0x72, 0x0E, 0x0A, 0x68, 0x55, 0xF4, 0x02, 0xF7, 0x68, 0x58,
  0xF1, 0x05, 0xF4, 0x60, 0xB0, 0xD2, 0x81, 0x8F, 0x14,
  // "$" (U+0024)
  0x40, 0xE0, 0x56, 0x83, 0x13, 0xE8, 0x24, 0x09, 0xE8, 0xA0, 0xA0, 0x8F, 0xE9, 0xFA, 0xAD, 0x90,
  0xCF, 0x50, 0xE5, 0x48, 0x4B, 0xF5, 0x0E, 0x54, 0x06, 0xA8, 0x19, 0xE5, 0x50, 0x70, 0xEA, 0x81,
  0xE8, 0x25, 0x06, 0xC0, 0x75, 0x81, 0xE7, 0x7A, 0x03, 0x48, 0x6E, 0x50, 0xBF, 0x66, 0x22, 0x89,
  0x2E, 0x52, 0xEF, 0x4D, 0xFE, 0xCF, 0xEA, 0x89, 0x0A, 0x06, 0xBD, 0xEF, 0xEA, 0x56, 0x0E, 0x05,
  0x71, 0x0E, 0x05, 0x40,
  // "%" (U+0025)
  0x28, 0x2A, 0xEE, 0x85, 0x81, 0xBE, 0x14, 0x84, 0x8F, 0xDE, 0xF6, 0x38, 0x14, 0xF7, 0x58, 0x4E,
  0xE0, 0x1F, 0xC3, 0x0C, 0x0D, 0x69, 0x0A, 0x20, 0xB0, 0xE2, 0x81, 0x6F, 0x55, 0x81, 0x1F, 0x92,
  0x0B, 0x92, 0x83, 0xEC, 0x01, 0x14, 0x90, 0xB2, 0x85, 0xCE, 0x08, 0xF4, 0xBA, 0x0B, 0x38, 0x95,
  0xCE, 0x24, 0xFB, 0x2F, 0xA7, 0xF9, 0x8F, 0x82, 0x05, 0xC8, 0x44, 0xAF, 0x2C, 0xE2, 0x0C, 0x0E,
  0x38, 0x90, 0x5A, 0xA4, 0x3F, 0x80, 0xEC, 0x20, 0xA9, 0x78, 0x4C, 0xE1, 0x0F, 0xB2, 0x81, 0x9F,
  0x25, 0x81, 0x5F, 0x62, 0x0E, 0x0C, 0x20, 0xA9, 0x60, 0xD0, 0xC3, 0x84, 0xBF, 0x10, 0xED, 0x58,
  0x17, 0xF4, 0x38, 0x45, 0xFE, 0xDF, 0x74, 0x81, 0x1E, 0xB5, 0x82, 0x7E, 0xE9, 0x20,
  // "&" (U+0026)
  0x28, 0x43, 0xBE, 0xEC, 0x47, 0x04, 0xA0, 0xD0, 0xCA, 0x04, 0x68, 0x1A, 0xF8, 0x28, 0x18, 0xF9,
  0x68, 0x1A, 0xF5, 0x28, 0x15, 0xFA, 0x68, 0x66, 0xFB, 0x01, 0xCF, 0x47, 0x84, 0xBF, 0xAE, 0xF7,
  0x71, 0x06, 0xB0, 0x47, 0x18, 0x49, 0xFC, 0xAF, 0xA3, 0x85, 0x6F, 0xB0, 0x8F, 0xC2, 0x89, 0x2A,
  0xFC, 0x10, 0xBF, 0x50, 0xDF, 0x43, 0x84, 0x9F, 0xD6, 0xFE, 0x2A, 0x04, 0x40, 0x9B, 0x04, 0x28,
  0x1C, 0xFB, 0x40, 0x7A, 0x0E, 0x03, 0x20, 0x4A, 0x81, 0xEC, 0xCA, 0x83, 0xEA, 0xFE, 0x32, 0x89,
  0x32, 0x9D, 0xFE, 0xC7, 0x10, 0x8F, 0xE3,
  // "'" (U+0027)
  0x89, 0x5A, 0xF6, 0x9F, 0x47, 0xF3, 0x6F, 0x25, 0xF1,
  // "(" (U+0028)
  0x38, 0x19, 0xF4, 0x28, 0x14, 0xFA, 0x38, 0x1D, 0xF2, 0x28, 0x14, 0xFB, 0x38, 0x19, 0xF6, 0x38,
  0x1D, 0xF2, 0x3A, 0x38, 0x11, 0xFD, 0x38, 0x12, 0xFC, 0x38, 0x12, 0xFD, 0x49, 0x0E, 0x48, 0x1D,
  0xF2, 0x38, 0x1A, 0xF6, 0x38, 0x15, 0xFB, 0x48, 0x1D, 0xF2, 0x38, 0x15, 0xFA, 0x48, 0x19, 0xF4,
  // ")" (U+0029)
  0x81, 0x2E, 0xC4, 0x81, 0x7F, 0x84, 0x81, 0xEF, 0x13, 0x81, 0x8F, 0x73, 0x81, 0x3F, 0xD4, 0x81,
  0xEF, 0x13, 0x81, 0xBF, 0x43, 0x81, 0xAF, 0x53, 0x81, 0x9F, 0x63, 0x81, 0xAF, 0x53, 0x81, 0xBF,
  0x43, 0x81, 0xEF, 0x12, 0x81, 0x3F, 0xD3, 0x81, 0x8F, 0x83, 0x81, 0xEF, 0x12, 0x81, 0x6F, 0x82,
  0x81, 0x1E, 0xC3,
  // "*" (U+002A)
  0x48, 0x18, 0xF7, 0x71, 0x81, 0x7F, 0x55, 0x02, 0x28, 0x15, 0xF3, 0x20, 0x22, 0x98, 0x92, 0xD9,
  0x7F, 0x79, 0xDF, 0x02, 0xCD, 0xC8, 0x2E, 0xDC, 0x13, 0x83, 0x1E, 0xFD, 0x16, 0x83, 0xBF, 0x5F,
  0xB5, 0x85, 0x8F, 0xA0, 0xBF, 0x74, 0x85, 0x5D, 0x30, 0x3D, 0x52,
  // "+" (U+002B)
  0x38, 0x11, 0xF8, 0x78, 0x11, 0xF8, 0x78, 0x11, 0xF8, 0x78, 0x11, 0xF8, 0x48, 0x00, 0xB9, 0x83,
  0xDB, 0xBB, 0x5F, 0xA0, 0x63, 0x81, 0x1F, 0x87, 0x81, 0x1F, 0x87, 0x81, 0x1F, 0x87, 0x81, 0x1F,
  0x84,
  // "," (U+002C)
  0x18, 0xA0, 0x5F, 0xE0, 0x7F, 0x90, 0xAF, 0x40, 0xED, 0x02, 0xF7, 0x10,
  // "-" (U+002D)
  0x85, 0x3B, 0xBB, 0xB8, 0x4C, 0x0A,
  // "." (U+002E)
  0x82, 0x3C, 0x99, 0xA8, 0x14, 0xEB,
  // "/" (U+002F)
  0x58, 0x1A, 0xF5, 0x48, 0x11, 0xFE, 0x58, 0x17, 0xF8, 0x58, 0x1C, 0xF2, 0x48, 0x13, 0xFC, 0x58,
  0x19, 0xF6, 0x58, 0x1E, 0xF1, 0x48, 0x15, 0xFA, 0x58, 0x1B, 0xF4, 0x48, 0x11, 0xFD, 0x58, 0x17,
  0xF8, 0x58, 0x1D, 0xF2, 0x48, 0x13, 0xFB, 0x58, 0x19, 0xF6, 0x50,
  // "0" (U+0030)
  0x38, 0x47, 0xDE, 0xEA, 0x14, 0x86, 0xAF, 0xEB, 0xDF, 0xE2, 0x28, 0x24, 0xFD, 0x12, 0x81, 0x9F,
  0xA2, 0x81, 0xAF, 0x73, 0x01, 0xA8, 0x31, 0x0D, 0xF3, 0x48, 0x1C, 0xF4, 0x1A, 0x01, 0x48, 0x2A,
  0xF7, 0x1A, 0x58, 0x29, 0xF8, 0x1A, 0x58, 0x19, 0xF7, 0x1A, 0x01, 0x48, 0x5A, 0xF7, 0x0D, 0xF3,
  0x48, 0x5C, 0xF5, 0x09, 0xF7, 0x30, 0x1A, 0x84, 0x10, 0x3F, 0xD1, 0x28, 0x19, 0xFB, 0x38, 0x69,
  0xFE, 0xBD, 0xFE, 0x24, 0x84, 0x7D, 0xFD, 0xA2, 0x20,
  // "1" (U+0031)
  0x38, 0x22, 0xCF, 0x62, 0x04, 0x0E, 0xA8, 0x97, 0x60, 0x7F, 0xEC, 0xF6, 0x2F, 0xD2, 0x9F, 0x60,
  0x42, 0x81, 0xAF, 0x64, 0x81, 0xAF, 0x64, 0x81, 0xAF, 0x64, 0x81, 0xAF, 0x64, 0x81, 0xAF, 0x64,
  0x81, 0xAF, 0x64, 0x81, 0xAF, 0x64, 0x81, 0xAF, 0x64, 0x81, 0xAF, 0x64, 0x81, 0xAF, 0x60,
  // "2" (U+0032)
  0x28, 0x53, 0xAD, 0xFE, 0xA3, 0x30, 0x8A, 0x81, 0xDB, 0xEA, 0x03, 0x28, 0x15, 0xD4, 0x38, 0x1A,
  0xFB, 0x71, 0x81, 0x3F, 0xE7, 0x18, 0x13, 0xFD, 0x71, 0x81, 0x8F, 0x97, 0x03, 0xA0, 0x26, 0x82,
  0x2E, 0xF6, 0x68, 0x22, 0xDF, 0x76, 0x82, 0x2D, 0xF7, 0x68, 0x22, 0xDF, 0x66, 0x82, 0x2D, 0xF6,
  0x78, 0x1D, 0xFE, 0x80, 0x2B, 0x05, 0x01, 0xFA, 0x08,
  // "3" (U+0033)
  0x28, 0x56, 0xBE, 0xFE, 0xB4, 0x30, 0xCA, 0x81, 0xCB, 0xDA, 0x06, 0x20, 0x30, 0x64, 0x81, 0x8F,
  0xD7, 0x18, 0x14, 0xFD, 0x78, 0x21, 0xBF, 0x74, 0x84, 0xAB, 0xCF, 0xC6, 0x50, 0xEB, 0x0C, 0x07,
  0x78, 0x31, 0x5C, 0xFB, 0x71, 0x01, 0xA0, 0x37, 0x18, 0x1D, 0xF5, 0x71, 0xA8, 0x24, 0x17, 0x14,
  0x83, 0x9F, 0xE0, 0x2A, 0x82, 0xDB, 0xCE, 0xA0, 0x42, 0x86, 0x7B, 0xDF, 0xED, 0x92, 0x20,
  // "4" (U+0034)
  0x60, 0x5A, 0x01, 0x70, 0x20, 0xEA, 0x01, 0x78, 0x3C, 0xDE, 0xF1, 0x68, 0x48, 0xF5, 0xEF, 0x15,
  0x81, 0x4F, 0xA1, 0xA0, 0x14, 0x81, 0x1D, 0xD2, 0xA0, 0x14, 0x81, 0xAF, 0x32, 0xA0, 0x13, 0x81,
  0x6F, 0x73, 0xA0, 0x12, 0x81, 0x2F, 0xB4, 0xA0, 0x12, 0x09, 0xFB, 0x01, 0x06, 0x80, 0x2B, 0xA0,
  0x0B, 0x71, 0xA0, 0x17, 0x2A, 0x01, 0x72, 0xA0, 0x12,
  // "5" (U+0035)
  0x1F, 0x83, 0x50, 0x1F, 0xE8, 0x01, 0xB8, 0x34, 0x02, 0xFC, 0x78, 0x13, 0xFB, 0x78, 0x15, 0xF9,
  0x78, 0x66, 0xFE, 0xEF, 0xEB, 0x42, 0x84, 0x4E, 0xDB, 0xCE, 0xA0, 0x67, 0x82, 0x9F, 0xE1, 0x78,
  0x1E, 0xF4, 0x78, 0x1D, 0xF5, 0x7A, 0x81, 0x35, 0x13, 0x8A, 0x51, 0xAF, 0xC0, 0xCF, 0xEC, 0xCE,
  0xFE, 0x30, 0x5B, 0xDE, 0xFD, 0x81, 0x20,
  // "6" (U+0036)
  0x38, 0x15, 0xBE, 0xA0, 0x73, 0x0B, 0xA8, 0x2D, 0xBC, 0x72, 0x82, 0xAF, 0xC2, 0x58, 0x13, 0xFD,
  0x78, 0x19, 0xF7, 0x78, 0x6C, 0xF3, 0x7D, 0xFD, 0x82, 0x84, 0xEF, 0xAF, 0xCC, 0xA0, 0xB1, 0xA0,
  0xC0, 0x12, 0x03, 0xA0, 0x4A, 0x03, 0x48, 0x49, 0xF7, 0xDF, 0x24, 0x84, 0x8F, 0x8A, 0xF7, 0x48,
  0x5A, 0xF6, 0x3F, 0xE3, 0x20, 0x4A, 0x81, 0x20, 0x8A, 0x00, 0xCA, 0x07, 0x38, 0x45, 0xBE, 0xEC,
  0x52,
  // "7" (U+0037)
  0x03, 0xFA, 0x08, 0x02, 0x80, 0x3B, 0x81, 0xEF, 0x77, 0x01, 0xA0, 0x17, 0x81, 0x8F, 0x97, 0x18,
  0x1E, 0xF2, 0x78, 0x17, 0xFB, 0x71, 0x81, 0xEF, 0x47, 0x81, 0x6F, 0xC7, 0x18, 0x1D, 0xF5, 0x78,
  0x15, 0xFD, 0x71, 0x81, 0xCF, 0x77, 0x81, 0x4F, 0xE7, 0x18, 0x1B, 0xF8, 0x70, 0x2A, 0x01, 0x50,
  // "8" (U+0038)
  0x28, 0x51, 0x9D, 0xFE, 0xB4, 0x38, 0x41, 0xEF, 0xEB, 0xDA, 0x06, 0x28, 0x17, 0xFB, 0x38, 0x16,
  0xFE, 0x28, 0x19, 0xF7, 0x4A, 0x28, 0x15, 0xFB, 0x38, 0x15, 0xFB, 0x38, 0x6B, 0xFC, 0x58, 0xFD,
  0x24, 0x09, 0xB0, 0xC5, 0x86, 0x7F, 0xE9, 0xEF, 0xB1, 0x28, 0x27, 0xFB, 0x12, 0x81, 0x9F, 0xD2,
  0x81, 0xEF, 0x14, 0x82, 0xBF, 0x51, 0xA5, 0x85, 0x9F, 0x70, 0xDF, 0x83, 0x84, 0x3E, 0xF4, 0x05,
  0xA8, 0x1E, 0xBC, 0xA0, 0xA3, 0x85, 0x3A, 0xEF, 0xEB, 0x62,
  // "9" (U+0039)
  0x28, 0x51, 0x9D, 0xFD, 0x81, 0x38, 0x72, 0xEF, 0xEC, 0xEF, 0xD2, 0x28, 0x1A, 0xFA, 0x38, 0x19,
  0xFB, 0x2A, 0x02, 0x48, 0x2E, 0xF2, 0x1A, 0x58, 0x1A, 0xF5, 0x1A, 0x02, 0x48, 0x91, 0xCF, 0x70,
  0xBF, 0xC2, 0x02, 0xAA, 0x82, 0x70, 0x2E, 0xC8, 0x2C, 0xAF, 0x52, 0x87, 0x17, 0xAA, 0x70, 0xCF,
  0x47, 0x18, 0x1E, 0xF1, 0x78, 0x17, 0xFA, 0x70, 0x7A, 0x02, 0x28, 0x61, 0xDB, 0xCE, 0xFE, 0x53,
  0x85, 0x1E, 0xFE, 0xC8, 0x23,
  // ":" (U+003A)
  0x82, 0x5E, 0xB9, 0xA8, 0x14, 0xD9, 0x77, 0x18, 0x23, 0xC9, 0x9A, 0x81, 0x4E, 0xB0,
  // ";" (U+003B)
  0x18, 0x35, 0xEB, 0x0A, 0xA1, 0x81, 0x4D, 0x97, 0x77, 0x48, 0xA0, 0x7F, 0xC0, 0x9F, 0x70, 0xCF,
  0x20, 0xFC, 0x04, 0xF6, 0x10,
  // "<" (U+003C)
  0x72, 0x01, 0x78, 0x14, 0xC7, 0x58, 0x34, 0xCF, 0xE4, 0x38, 0x34, 0xCF, 0xD6, 0x38, 0x34, 0xCF,
  0xD6, 0x48, 0x2C, 0xFC, 0x56, 0x83, 0xCF, 0xD7, 0x16, 0x04, 0x0B, 0xA0, 0xA0, 0x36, 0x84, 0x29,
  0xEF, 0xC6, 0x68, 0x31, 0x7D, 0xF7, 0x71, 0x05, 0x04,
  // "=" (U+003D)
  0x0A, 0x80, 0x4B, 0x04, 0x0E, 0xF9, 0x05, 0x77, 0x60, 0xA8, 0x04, 0xB0, 0x40, 0xEF, 0x90, 0x50,
  // ">" (U+003E)
  0x0E, 0x07, 0x71, 0x82, 0xCF, 0xE7, 0x78, 0x33, 0xBF, 0xE7, 0x78, 0x33, 0xAF, 0xE7, 0x78, 0x32,
  0x9F, 0xE4, 0x58, 0x34, 0xBF, 0xE4, 0x28, 0x41, 0x7D, 0xFD, 0x72, 0x03, 0x0A, 0xA0, 0xC0, 0x54,
  0xA0, 0xA0, 0x36, 0x08, 0x01, 0x71,
  // "?" (U+003F)
  0x89, 0x01, 0x7C, 0xEF, 0xD8, 0x10, 0x9A, 0x86, 0xCC, 0xEF, 0xC0, 0x15, 0x38, 0x21, 0xDF, 0x46,
  0x81, 0xAF, 0x65, 0x82, 0x1D, 0xF3, 0x48, 0x21, 0xCF, 0x84, 0x82, 0x2E, 0xF7, 0x58, 0x1D, 0xF4,
  0x58, 0x12, 0xFA, 0x68, 0x12, 0x94, 0x77, 0x18, 0x13, 0xC9, 0x60, 0x9A, 0x68, 0x14, 0xEB, 0x40,
  // "@" (U+0040)
  0x48, 0x71, 0x7B, 0xEF, 0xEC, 0x71, 0x60, 0x70, 0xEA, 0x85, 0xDB, 0xCE, 0xFE, 0x54, 0x82, 0x9F,
  0xD5, 0x58, 0x25, 0xEF, 0x52, 0x8A, 0x06, 0xFA, 0x01, 0x8D, 0xFD, 0xB4, 0x1D, 0xE1, 0x0E, 0xD2,
  0x8A, 0x0C, 0xFD, 0xBD, 0xF8, 0x04, 0xF7, 0x6F, 0x50, 0x7F, 0x92, 0x81, 0x3F, 0x72, 0x81, 0xEA,
  0xA9, 0x20, 0xC9, 0x38, 0x14, 0xF7, 0x20, 0xFC, 0x0D, 0x20, 0xE0, 0xC3, 0x81, 0x5F, 0x62, 0x82,
  0xDC, 0xDC, 0x20, 0x0D, 0x38, 0x18, 0xF6, 0x29, 0x81, 0x9B, 0xD2, 0x89, 0x7A, 0xF6, 0x04, 0xEE,
  0xA0, 0x9F, 0x49, 0xF1, 0x02, 0xC0, 0xA0, 0x7B, 0x83, 0xB0, 0x5F, 0x72, 0x82, 0x39, 0xA7, 0x28,
  0x17, 0xA7, 0x38, 0x1D, 0xF4, 0x76, 0x89, 0x22, 0xEF, 0xA4, 0x10, 0x12, 0x59, 0x15, 0x02, 0x0B,
  0xF0, 0xE0, 0x17, 0x85, 0x27, 0x9A, 0xA8, 0x55,
  // "A" (U+0041)
  0x58, 0x1C, 0xFD, 0x72, 0x02, 0xB0, 0x37, 0x18, 0x38, 0xFA, 0xF9, 0x71, 0x83, 0xEF, 0x1E, 0xE7,
  0x85, 0x5F, 0xB0, 0x9F, 0x66, 0x85, 0xBF, 0x50, 0x4F, 0xC5, 0x81, 0x1F, 0xE3, 0x81, 0xDF, 0x24,
  0x81, 0x7F, 0x93, 0x81, 0x7F, 0x84, 0x0D, 0xF0, 0xE3, 0x04, 0xA8, 0x01, 0xDA, 0x05, 0x28, 0x1A,
  0xF8, 0x58, 0x37, 0xFB, 0x01, 0xA0, 0x25, 0x02, 0xA8, 0x21, 0x6F, 0xC7, 0x84, 0xBF, 0x7C, 0xF6,
  0x78, 0x16, 0xFD,
  // "B" (U+0042)
  0x01, 0xD8, 0x4E, 0xB7, 0x10, 0x1A, 0x0F, 0xB0, 0xDA, 0x81, 0xD1, 0x1A, 0x01, 0x38, 0x33, 0xEF,
  0x71, 0xA0, 0x14, 0x82, 0xAF, 0x91, 0xA0, 0x14, 0x82, 0xBF, 0x71, 0xA0, 0x12, 0x84, 0x16, 0xFE,
  0x11, 0xF8, 0x29, 0x20, 0x1A, 0x0F, 0xB0, 0xCA, 0x81, 0x91, 0x1A, 0x01, 0x38, 0x31, 0xCF, 0xA1,
  0xA0, 0x14, 0x04, 0xA0, 0x1A, 0x01, 0x40, 0x5A, 0x01, 0xA0, 0x13, 0x83, 0x1C, 0xFC, 0x1A, 0x0F,
  0xB0, 0xCA, 0x81, 0xE3, 0x1E, 0x81, 0xD9, 0x21,
  // "C" (U+0043)
  0x38, 0x62, 0x8C, 0xEE, 0xDA, 0x52, 0x07, 0xA8, 0x6E, 0xCB, 0xEF, 0xB0, 0x6A, 0x07, 0x48, 0x44,
  0x31, 0xEF, 0x67, 0x81, 0x6F, 0xD7, 0x18, 0x1A, 0xF9, 0x71, 0x81, 0xBF, 0x77, 0x18, 0x1B, 0xF7,
  0x71, 0x81, 0xAF, 0x97, 0x18, 0x17, 0xFD, 0x71, 0x02, 0xA0, 0x57, 0x18, 0x28, 0xFE, 0x54, 0x00,
  0x12, 0x0A, 0xA8, 0x4E, 0xBC, 0xDF, 0x73, 0x81, 0x4A, 0xDA, 0x81, 0xDA, 0x30,
  // "D" (U+0044)
  0x01, 0xD8, 0x1D, 0xB6, 0x40, 0x1A, 0x0F, 0xB0, 0xDA, 0x0D, 0x03, 0x20, 0x1A, 0x01, 0x38, 0x52,
  0xAF, 0xE2, 0x01, 0xA0, 0x15, 0x83, 0xBF, 0xB0, 0x1A, 0x01, 0x50, 0x3A, 0x00, 0x1A, 0x01, 0x68,
  0x2E, 0xF4, 0x1A, 0x01, 0x68, 0x2C, 0xF6, 0x1A, 0x01, 0x68, 0x2D, 0xF6, 0x1A, 0x01, 0x68, 0x2E,
  0xF4, 0x1A, 0x01, 0x50, 0x3A, 0x00, 0x1A, 0x01, 0x58, 0x3C, 0xFA, 0x01, 0xA0, 0x13, 0x85, 0x3C,
  0xFE, 0x20, 0x1A, 0x82, 0xBB, 0xCE, 0xA0, 0xD0, 0x32, 0x01, 0xC8, 0x2E, 0xDA, 0x54,
  // "E" (U+0045)
  0x01, 0xF0, 0xE0, 0x1A, 0x80, 0x1B, 0x0A, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15,
  0x01, 0xA0, 0x15, 0x01, 0xF0, 0x90, 0x1A, 0x80, 0x1B, 0x06, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15,
  0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01, 0xA8, 0x01, 0xB0, 0xA0, 0x1F, 0x0E,
  // "F" (U+0046)
  0x01, 0xF0, 0xE0, 0x1A, 0x80, 0x1B, 0x0A, 0x01, 0xA6, 0x01, 0xA6, 0x01, 0xA6, 0x01, 0xA6, 0x01,
  0xA8, 0x01, 0xB0, 0x60, 0x1F, 0x08, 0x01, 0xA6, 0x01, 0xA6, 0x01, 0xA6, 0x01, 0xA6, 0x01, 0xA6,
  0x01, 0xA6,
  // "G" (U+0047)
  0x38, 0x71, 0x7B, 0xDF, 0xEC, 0x94, 0x20, 0x50, 0xEA, 0x81, 0xDB, 0xDA, 0x81, 0x80, 0x5A, 0x09,
  0x01, 0x48, 0x45, 0x10, 0xEF, 0x87, 0x18, 0x16, 0xFE, 0x72, 0x81, 0x9F, 0x97, 0x28, 0x1B, 0xF7,
  0x30, 0x18, 0x02, 0xB9, 0x07, 0x30, 0x2D, 0x81, 0xAF, 0x96, 0x01, 0xA8, 0x17, 0xFD, 0x60, 0x1A,
  0x01, 0xA0, 0x65, 0x01, 0xA1, 0x08, 0xA0, 0x74, 0x01, 0xA2, 0x09, 0xA8, 0x3E, 0xCB, 0xCE, 0xA3,
  0x81, 0x3A, 0xDA, 0x82, 0xED, 0xA6,
  // "H" (U+0048)
  0x01, 0xA0, 0x15, 0x01, 0xA0, 0x1A, 0x01, 0x50, 0x1A, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x1A, 0x01,
  0x50, 0x1A, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x1A, 0x01, 0x50, 0x1A, 0x01, 0xFC, 0x01, 0xA8, 0x03,
  0xBA, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x1A, 0x01, 0x50, 0x1A, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x1A,
  0x01, 0x50, 0x1A, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x1A, 0x01, 0x50, 0x1A,
  // "I" (U+0049)
  0x03, 0xD8, 0x64, 0x18, 0xDF, 0xE8, 0x12, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94,
  0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81,
  0x8F, 0x94, 0x81, 0x8F, 0x93, 0x85, 0x6C, 0xFD, 0x61, 0x3D, 0x04,
  // "J" (U+004A)
  0x30, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x2A,
  0x30, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x30, 0x2A, 0x38, 0x13, 0xFE, 0x38,
  0x49, 0xFB, 0x7B, 0xDA, 0x84, 0x37, 0xEE, 0xB4, 0x10,
  // "K" (U+004B)
  0x01, 0xA0, 0x14, 0x83, 0x6F, 0xE2, 0x1A, 0x01, 0x38, 0x44, 0xFE, 0x30, 0x1A, 0x01, 0x28, 0x23,
  0xEF, 0x42, 0x01, 0xA8, 0x41, 0x02, 0xEF, 0x63, 0x01, 0xA8, 0x31, 0x1D, 0xF7, 0x40, 0x1A, 0x82,
  0x1B, 0xF9, 0x50, 0x1A, 0x0A, 0xA0, 0x45, 0x01, 0xB8, 0x2D, 0xFD, 0x14, 0x01, 0xA8, 0x36, 0x0D,
  0xFA, 0x40, 0x1A, 0x81, 0x10, 0x2A, 0x06, 0x30, 0x1A, 0x01, 0x28, 0x26, 0xFE, 0x22, 0x01, 0xA0,
  0x13, 0x81, 0xAF, 0xC2, 0x01, 0xA0, 0x13, 0x84, 0x1D, 0xF8, 0x01, 0xA0, 0x14, 0x03, 0xA0, 0x40,
  // "L" (U+004C)
  0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01,
  0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA0,
  0x16, 0x01, 0xA0, 0x16, 0x01, 0xA8, 0x02, 0xD0, 0x20, 0x1F, 0x90, 0x20,
  // "M" (U+004D)
  0x01, 0xB0, 0x27, 0x0C, 0xA0, 0x70, 0x1B, 0x08, 0x60, 0x2B, 0x84, 0x71, 0xFC, 0xED, 0x68, 0x91,
  0x8F, 0xDF, 0x71, 0xFC, 0x9F, 0x35, 0x89, 0x1E, 0xE9, 0xF7, 0x1F, 0xC4, 0xF9, 0x48, 0x92, 0x4F,
  0x89, 0xF7, 0x1F, 0xD0, 0xDE, 0x48, 0x93, 0xAF, 0x29, 0xF7, 0x1F, 0xD0, 0x8F, 0x52, 0x89, 0x41,
  0xFC, 0x09, 0xF7, 0x1F, 0xD0, 0x3F, 0xA2, 0x89, 0x06, 0xF6, 0x09, 0xF7, 0x1F, 0xD2, 0x89, 0x4D,
  0xF1, 0x0C, 0xF1, 0x09, 0xF7, 0x1F, 0xD2, 0x84, 0x7F, 0x62, 0xFA, 0x28, 0x49, 0xF7, 0x1F, 0xD2,
  0x84, 0x2F, 0xC8, 0xF4, 0x28, 0x49, 0xF7, 0x1F, 0xD3, 0x82, 0xBF, 0xEE, 0x38, 0x49, 0xF7, 0x1F,
  0xD3, 0x06, 0xA0, 0x83, 0x84, 0x9F, 0x71, 0xFD, 0x30, 0x1A, 0x02, 0x38, 0x19, 0xF7,
  // "N" (U+004E)
  0x01, 0xA0, 0xC6, 0x82, 0x5F, 0x91, 0xB0, 0x65, 0x82, 0x5F, 0x91, 0xB0, 0xE0, 0x14, 0x87, 0x5F,
  0x91, 0xFB, 0xBF, 0xA4, 0x85, 0x5F, 0x91, 0xFC, 0x2A, 0x05, 0x38, 0x90, 0x5F, 0x91, 0xFC, 0x07,
  0xFD, 0x38, 0x45, 0xF9, 0x1F, 0xD2, 0x81, 0xCF, 0x82, 0x84, 0x5F, 0x91, 0xFD, 0x20, 0x3A, 0x86,
  0x30, 0x5F, 0x91, 0xFD, 0x38, 0x90, 0x8F, 0xC0, 0x5F, 0x91, 0xFD, 0x48, 0x7D, 0xF7, 0x5F, 0x91,
  0xFD, 0x48, 0x73, 0xFE, 0x6F, 0x91, 0xFD, 0x58, 0x69, 0xFE, 0xF9, 0x1F, 0xD5, 0x01, 0x0D, 0xA8,
  0x29, 0x1F, 0xD6, 0x05, 0xA0, 0x90,
  // "O" (U+004F)
  0x38, 0x64, 0xAD, 0xEE, 0xC8, 0x25, 0x09, 0xA8, 0x5E, 0xBC, 0xEF, 0xE5, 0x38, 0x28, 0xFE, 0x54,
  0x08, 0xA8, 0x13, 0x02, 0xA0, 0x46, 0x85, 0x9F, 0xC0, 0x7F, 0xD7, 0x02, 0xA8, 0x22, 0xAF, 0x97,
  0x18, 0x4E, 0xF5, 0xBF, 0x77, 0x18, 0x4C, 0xF7, 0xBF, 0x77, 0x18, 0x4C, 0xF7, 0xAF, 0x97, 0x18,
  0x4E, 0xF5, 0x6F, 0xD7, 0x02, 0xA0, 0x20, 0x1A, 0x05, 0x68, 0x19, 0xFC, 0x28, 0x28, 0xFE, 0x44,
  0x08, 0xA0, 0x33, 0x09, 0xA8, 0x5E, 0xBC, 0xEF, 0xE5, 0x58, 0x64, 0xAD, 0xEE, 0xC8, 0x23,
  // "P" (U+0050)
  0x01, 0xD8, 0x1D, 0x93, 0x20, 0x1A, 0x82, 0xBB, 0xCE, 0xA8, 0x15, 0x01, 0xA0, 0x12, 0x84, 0x1A,
  0xFE, 0x01, 0xA0, 0x13, 0x01, 0xA0, 0x30, 0x1A, 0x01, 0x4A, 0x03, 0x01, 0xA0, 0x13, 0x03, 0xA0,
  0x01, 0xA8, 0x71, 0x01, 0x5D, 0xFA, 0x01, 0xF0, 0xB2, 0x01, 0xA8, 0x3B, 0xBA, 0x83, 0x30, 0x1A,
  0x01, 0x70, 0x1A, 0x01, 0x70, 0x1A, 0x01, 0x70, 0x1A, 0x01, 0x70, 0x1A, 0x01, 0x70,
  // "Q" (U+0051)
  0x38, 0x64, 0xAD, 0xEE, 0xC8, 0x25, 0x09, 0xA8, 0x5E, 0xBC, 0xEF, 0xE5, 0x38, 0x28, 0xFE, 0x54,
  0x08, 0xA8, 0x13, 0x02, 0xA0, 0x46, 0x85, 0x9F, 0xC0, 0x7F, 0xD7, 0x02, 0xA8, 0x22, 0xAF, 0x97,
  0x18, 0x4E, 0xF5, 0xBF, 0x77, 0x18, 0x4C, 0xF7, 0xBF, 0x77, 0x18, 0x4C, 0xF6, 0xAF, 0x97, 0x18,
  0x4E, 0xF5, 0x6F, 0xD7, 0x02, 0xA0, 0x20, 0x1A, 0x05, 0x68, 0x19, 0xFB, 0x28, 0x28, 0xFE, 0x44,
  0x08, 0xA0, 0x43, 0x09, 0xA8, 0x2E, 0xBC, 0xEA, 0x06, 0x58, 0x24, 0xAD, 0xEA, 0x0D, 0x02, 0x73,
  0x04, 0xA0, 0x67, 0x40, 0x5A, 0x07, 0x74, 0x06, 0xA0, 0x61,
  // "R" (U+0052)
  0x01, 0xD8, 0x1D, 0xA4, 0x30, 0x1A, 0x82, 0xBB, 0xCE, 0xA0, 0x72, 0x01, 0xA0, 0x13, 0x08, 0xA2,
  0x01, 0xA0, 0x14, 0xA8, 0x13, 0x01, 0xA0, 0x13, 0x01, 0xA8, 0x13, 0x01, 0xA0, 0x13, 0x81, 0x9F,
  0xD2, 0x01, 0xA8, 0x5B, 0xBC, 0xEF, 0xD2, 0x20, 0x1E, 0x0B, 0x40, 0x1A, 0x84, 0x10, 0x2F, 0xE1,
  0x30, 0x1A, 0x01, 0x28, 0x19, 0xFA, 0x30, 0x1A, 0x01, 0x28, 0x21, 0xEF, 0x42, 0x01, 0xA0, 0x13,
  0x81, 0x7F, 0xD2, 0x01, 0xA0, 0x14, 0x83, 0xDF, 0x80, 0x1A, 0x01, 0x40, 0x4A, 0x02,
  // "S" (U+0053)
  0x18, 0xA2, 0x18, 0xCE, 0xEC, 0x94, 0x2E, 0xFE, 0xBC, 0xEF, 0x8A, 0xFB, 0x48, 0x34, 0x2C, 0xF5,
  0x68, 0x1B, 0xF9, 0x60, 0x5A, 0x0A, 0x02, 0x50, 0x60, 0xEA, 0x0C, 0x05, 0x48, 0x11, 0x7E, 0xA0,
  0xB0, 0x15, 0x82, 0x6E, 0xFA, 0x60, 0x4A, 0x60, 0x1A, 0x06, 0x01, 0x48, 0x19, 0xFC, 0xA8, 0x90,
  0xDB, 0xCE, 0xFE, 0x37, 0xBD, 0xA8, 0x1D, 0x92, 0x10,
  // "T" (U+0054)
  0x0B, 0xFB, 0x85, 0x8B, 0xBB, 0xDF, 0xE8, 0x00, 0xB4, 0x81, 0x7F, 0xA7, 0x18, 0x17, 0xFA, 0x71,
  0x81, 0x7F, 0xA7, 0x18, 0x17, 0xFA, 0x71, 0x81, 0x7F, 0xA7, 0x18, 0x17, 0xFA, 0x71, 0x81, 0x7F,
  0xA7, 0x18, 0x17, 0xFA, 0x71, 0x81, 0x7F, 0xA7, 0x18, 0x17, 0xFA, 0x71, 0x81, 0x7F, 0xA7, 0x18,
  0x17, 0xFA, 0x40,
  // "U" (U+0055)
  0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE,
  0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8,
  0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA0, 0x2A, 0x68, 0x53, 0xFE, 0x0E, 0xF4, 0x58,
  0x67, 0xFB, 0x09, 0xFD, 0x33, 0x82, 0x4E, 0xF5, 0x20, 0xCA, 0x81, 0xDB, 0xDA, 0x08, 0x48, 0x57,
  0xCE, 0xFD, 0xA4, 0x20,
  // "V" (U+0056)
  0x81, 0xCF, 0x66, 0x01, 0xA8, 0x21, 0x7F, 0xB6, 0x83, 0x7F, 0xB0, 0x1A, 0x01, 0x58, 0x1C, 0xF6,
  0x28, 0x1B, 0xF6, 0x40, 0x2A, 0x01, 0x28, 0x16, 0xFC, 0x48, 0x17, 0xFA, 0x4A, 0x02, 0x38, 0x1D,
  0xF4, 0x48, 0x1A, 0xF7, 0x28, 0x13, 0xFE, 0x58, 0x14, 0xFC, 0x28, 0x18, 0xF9, 0x68, 0x5E, 0xF2,
  0x0D, 0xF3, 0x68, 0x49, 0xF7, 0x3F, 0xD7, 0x84, 0x3F, 0xC8, 0xF8, 0x71, 0x83, 0xDF, 0xCF, 0x27,
  0x10, 0x8A, 0x0C, 0x72, 0x02, 0xA0, 0x65,
  // "W" (U+0057)
  0x81, 0xBF, 0x75, 0x81, 0xDF, 0x95, 0x84, 0xAF, 0x76, 0xFB, 0x40, 0x2A, 0x0D, 0x58, 0x2E, 0xF3,
  0x2A, 0x40, 0x6B, 0x02, 0x38, 0x13, 0xFE, 0x28, 0x1E, 0xF4, 0x38, 0x3B, 0xF9, 0xF7, 0x38, 0x16,
  0xFA, 0x28, 0x19, 0xF8, 0x39, 0x82, 0xE3, 0xFB, 0x38, 0x1A, 0xF6, 0x28, 0x15, 0xFB, 0x28, 0x54,
  0xFA, 0x0E, 0xF1, 0x28, 0x1E, 0xF2, 0x20, 0x1A, 0x28, 0x91, 0x9F, 0x60, 0x9F, 0x50, 0x3F, 0xD4,
  0x89, 0x5D, 0xF4, 0x0D, 0xF1, 0x05, 0xFA, 0x07, 0xF9, 0x48, 0x48, 0xF8, 0x2F, 0xC3, 0x98, 0x3E,
  0x0A, 0xF5, 0x48, 0x44, 0xFB, 0x6F, 0x83, 0x84, 0xBF, 0x3E, 0xF1, 0x59, 0x82, 0xE9, 0xF3, 0x38,
  0x37, 0xF8, 0xFC, 0x68, 0x2B, 0xFE, 0xE4, 0x83, 0x2F, 0xEF, 0x86, 0x07, 0xA0, 0x95, 0x0D, 0xA0,
  0x46, 0x03, 0xA0, 0x55, 0x08, 0xA4,
  // "X" (U+0058)
  0x82, 0x4F, 0xE1, 0x58, 0x5C, 0xF7, 0x0A, 0xFA, 0x48, 0x16, 0xFC, 0x28, 0x21, 0xEF, 0x42, 0x82,
  0x1E, 0xF2, 0x38, 0x15, 0xFD, 0x28, 0x1A, 0xF7, 0x58, 0x4A, 0xF8, 0x4F, 0xD6, 0x84, 0x1E, 0xFD,
  0xF3, 0x70, 0x6A, 0x09, 0x71, 0x0A, 0xA0, 0xC7, 0x84, 0x5F, 0xDC, 0xF7, 0x58, 0x31, 0xEF, 0x32,
  0xA0, 0x24, 0x81, 0x9F, 0x92, 0x81, 0x8F, 0xC3, 0x81, 0x4F, 0xD4, 0x81, 0xDF, 0x72, 0x81, 0xDF,
  0x44, 0x04, 0xA8, 0x22, 0x9F, 0xA6, 0x81, 0x9F, 0xC0,
  // "Y" (U+0059)
  0x81, 0xBF, 0x96, 0x82, 0xDF, 0x52, 0xA0, 0x24, 0x81, 0x6F, 0xC2, 0x81, 0x9F, 0xA4, 0x81, 0xEF,
  0x42, 0x01, 0xA0, 0x22, 0x81, 0x7F, 0xB4, 0x86, 0x8F, 0xA0, 0x1E, 0xF2, 0x48, 0x51, 0xEF, 0x38,
  0xF9, 0x68, 0x47, 0xFC, 0xEE, 0x17, 0x0D, 0xA0, 0x87, 0x18, 0x15, 0xFE, 0x72, 0x81, 0x3F, 0xE7,
  0x28, 0x13, 0xFE, 0x72, 0x81, 0x3F, 0xE7, 0x28, 0x13, 0xFE, 0x72, 0x81, 0x3F, 0xE5,
  // "Z" (U+005A)
  0x01, 0xFA, 0x09, 0x01, 0x80, 0x3B, 0xA0, 0x77, 0x81, 0x8F, 0xD7, 0x03, 0xA0, 0x37, 0x81, 0xCF,
  0x87, 0x81, 0x8F, 0xC7, 0x03, 0xA0, 0x37, 0x81, 0xDF, 0x77, 0x81, 0x8F, 0xC7, 0x03, 0xA0, 0x27,
  0x81, 0xDF, 0x77, 0x81, 0x9F, 0xC7, 0x03, 0xA0, 0xC8, 0x02, 0xB0, 0x80, 0x4F, 0xA0, 0xC0,
  // "[" (U+005B)
  0x07, 0xC8, 0x90, 0x17, 0xFD, 0xBB, 0x17, 0xF7, 0x38, 0x17, 0xF7, 0x38, 0x17, 0xF7, 0x38, 0x17,
  0xF7, 0x38, 0x17, 0xF7, 0x38, 0x17, 0xF7, 0x38, 0x17, 0xF7, 0x38, 0x17, 0xF7, 0x38, 0x17, 0xF7,
  0x38, 0x17, 0xF7, 0x38, 0x17, 0xF7, 0x38, 0x17, 0xF7, 0x38, 0x17, 0xF7, 0x38, 0x17, 0xF7, 0x30,
  0x7C, 0x85, 0x15, 0xBB, 0xBB, 0x10,
  // "\" (U+005C)
  0x81, 0x9F, 0x55, 0x81, 0x3F, 0xB6, 0x81, 0xDF, 0x25, 0x81, 0x7F, 0x85, 0x81, 0x1F, 0xD6, 0x81,
  0xBF, 0x45, 0x81, 0x5F, 0xA6, 0x81, 0xEF, 0x15, 0x81, 0x9F, 0x65, 0x81, 0x3F, 0xC6, 0x81, 0xCF,
  0x25, 0x81, 0x7F, 0x85, 0x81, 0x1F, 0xE6, 0x81, 0xAF, 0x50,
  // "]" (U+005D)
  0x07, 0xC8, 0x21, 0x5B, 0xBA, 0x01, 0x38, 0x1E, 0xF1, 0x38, 0x1E, 0xF1, 0x38, 0x1E, 0xF1, 0x38,
  0x1E, 0xF1, 0x38, 0x1E, 0xF1, 0x38, 0x1E, 0xF1, 0x38, 0x1E, 0xF1, 0x38, 0x1E, 0xF1, 0x38, 0x1E,
  0xF1, 0x38, 0x1E, 0xF1, 0x38, 0x1E, 0xF1, 0x38, 0x1E, 0xF1, 0x38, 0x1E, 0xF1, 0x38, 0x2E, 0xF1,
  0x7C, 0x01, 0x05, 0x80, 0x0B, 0x10,
  // "^" (U+005E)
  0x48, 0x14, 0xF4, 0x71, 0x81, 0xCF, 0xC7, 0x83, 0x3F, 0xAF, 0x56, 0x83, 0xBD, 0x0C, 0xD5, 0x85,
  0x3F, 0x70, 0x4F, 0x64, 0x0A, 0x0E, 0x30, 0xC0, 0xD3, 0x81, 0x2F, 0x83, 0x81, 0x4F, 0x72, 0x81,
  0x9F, 0x14, 0x84, 0xCE, 0x01, 0xFA, 0x58, 0x14, 0xF7,
  // "_" (U+005F)
  0x80, 0x4B, 0x08, 0xF9, 0x0B,
  // "`" (U+0060)
  0x81, 0xDF, 0x92, 0x82, 0x1C, 0xF4, 0x38, 0x1A, 0xE1,
  // "a" (U+0061)
  0x28, 0x53, 0x9D, 0xFE, 0xC5, 0x38, 0x3B, 0xFE, 0xCD, 0xA0, 0x52, 0x00, 0x23, 0x81, 0x8F, 0xB7,
  0x81, 0x3F, 0xD2, 0x89, 0x11, 0x69, 0xBB, 0xCF, 0xD0, 0x4E, 0xE8, 0x4D, 0x0D, 0xFB, 0x32, 0x82,
  0x3F, 0xD1, 0xA0, 0x23, 0x85, 0x5F, 0xD0, 0xEF, 0x42, 0x84, 0x2D, 0xFD, 0x09, 0xA8, 0x4C, 0xCF,
  0x9E, 0xD2, 0x86, 0x8D, 0xFD, 0x70, 0xBD,
  // "b" (U+0062)
  0x81, 0x5F, 0xC7, 0x18, 0x15, 0xFC, 0x71, 0x81, 0x5F, 0xC7, 0x18, 0x15, 0xFC, 0x71, 0x87, 0x5F,
  0xB2, 0xBE, 0xEB, 0x32, 0x85, 0x5F, 0xDE, 0xEC, 0xEA, 0x81, 0x30, 0x5A, 0x09, 0x38, 0x3A, 0xFC,
  0x05, 0xA0, 0x13, 0x02, 0xA8, 0x22, 0x5F, 0xD5, 0x84, 0xEF, 0x45, 0xFC, 0x58, 0x4D, 0xF5, 0x5F,
  0xD5, 0x82, 0xEF, 0x45, 0xA0, 0x13, 0x02, 0xA0, 0x20, 0x5A, 0x08, 0x38, 0x91, 0xAF, 0xC0, 0x5F,
  0xCF, 0xDB, 0xEA, 0x89, 0x13, 0x05, 0xF5, 0x3B, 0xEE, 0xB3, 0x20,
  // "c" (U+0063)
  0x28, 0x65, 0xBE, 0xED, 0x90, 0x9A, 0x86, 0xDC, 0xEC, 0x4F, 0xE4, 0x38, 0x21, 0xAF, 0x85, 0x81,
  0xDF, 0x55, 0x81, 0xEF, 0x35, 0x81, 0xDF, 0x55, 0x81, 0xBF, 0x85, 0x82, 0x6F, 0xE3, 0x38, 0x13,
  0x0B, 0xA8, 0x2D, 0xCE, 0xE2, 0x06, 0x0C, 0xA0, 0xD0, 0x70,
  // "d" (U+0064)
  0x78, 0x15, 0xFB, 0x78, 0x15, 0xFB, 0x78, 0x15, 0xFB, 0x78, 0x15, 0xFB, 0x28, 0x90, 0x8D, 0xFD,
  0x75, 0xFB, 0x0C, 0xA8, 0x90, 0xCC, 0xFC, 0xFB, 0x6F, 0xE2, 0x28, 0x53, 0xEF, 0xBB, 0xF8, 0x48,
  0x49, 0xFB, 0xDF, 0x54, 0x84, 0x6F, 0xBE, 0xF3, 0x48, 0x44, 0xFB, 0xDF, 0x44, 0x84, 0x5F, 0xBB,
  0xF8, 0x48, 0x58, 0xFB, 0x6F, 0xE3, 0x28, 0x43, 0xEF, 0xB0, 0xCA, 0x89, 0x6C, 0xCF, 0xBF, 0xB0,
  0x18, 0xDF, 0xD6, 0x0F, 0xB0,
  // "e" (U+0065)
  0x28, 0x45, 0xCE, 0xEB, 0x43, 0x09, 0xA0, 0x0C, 0xA8, 0x45, 0x04, 0xFE, 0x22, 0x85, 0x5F, 0xE0,
  0xAF, 0x74, 0x89, 0x4C, 0xF4, 0xDF, 0xCB, 0xBB, 0xBE, 0xF6, 0xEF, 0x98, 0x27, 0xDF, 0x47, 0x81,
  0xAF, 0x87, 0x04, 0xA0, 0x54, 0x04, 0x20, 0x8A, 0x83, 0xDB, 0xDF, 0xE3, 0x85, 0x4B, 0xEF, 0xEB,
  0x61,
  // "f" (U+0066)
  0x38, 0x36, 0xCE, 0xEA, 0x20, 0x6A, 0x81, 0xCC, 0x92, 0x81, 0xCF, 0x75, 0x81, 0xDF, 0x43, 0x04,
  0x0C, 0xC8, 0x7E, 0x07, 0xBE, 0xFC, 0xBA, 0x38, 0x1D, 0xF4, 0x58, 0x1D, 0xF4, 0x58, 0x1D, 0xF4,
  0x58, 0x1D, 0xF4, 0x58, 0x1D, 0xF4, 0x58, 0x1D, 0xF4, 0x58, 0x1D, 0xF4, 0x58, 0x1D, 0xF4, 0x58,
  0x1D, 0xF4, 0x30,
  // "g" (U+0067)
  0x28, 0x90, 0x8D, 0xFD, 0x61, 0xFB, 0x0B, 0xA8, 0x90, 0xCD, 0xFB, 0xFB, 0x5F, 0xE3, 0x28, 0x53,
  0xEF, 0xBB, 0xF8, 0x48, 0x48, 0xFB, 0xDF, 0x54, 0x84, 0x5F, 0xBE, 0xF3, 0x48, 0x44, 0xFB, 0xDF,
  0x44, 0x84, 0x5F, 0xBB, 0xF8, 0x48, 0x58, 0xFB, 0x6F, 0xE3, 0x28, 0x42, 0xEF, 0xB0, 0xCA, 0x89,
  0x6C, 0xCF, 0xCF, 0xB0, 0x18, 0xDF, 0xD6, 0x5F, 0xB7, 0x81, 0x6F, 0xB7, 0x83, 0x9F, 0x91, 0x54,
  0x03, 0xA8, 0x55, 0x2F, 0xEC, 0xBC, 0xA8, 0x90, 0xB0, 0x18, 0xCE, 0xFE, 0xC7, 0x20,
  // "h" (U+0068)
  0x81, 0x5F, 0xC7, 0x81, 0x5F, 0xC7, 0x81, 0x5F, 0xC7, 0x81, 0x5F, 0xC7, 0x89, 0x75, 0xFB, 0x2A,
  0xEE, 0xC5, 0x05, 0xFC, 0xEE, 0xBD, 0xA0, 0x05, 0xA0, 0x93, 0x82, 0x9F, 0xC5, 0xA0, 0x13, 0x03,
  0xA8, 0x15, 0xFD, 0x40, 0x1A, 0x81, 0x5F, 0xC4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A, 0x81, 0x5F,
  0xC4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A, 0x81, 0x5F, 0xC4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A,
  // "i" (U+0069)
  0x86, 0x4E, 0xA5, 0xFC, 0x01, 0x48, 0xB7, 0x5F, 0xC5, 0xFC, 0x5F, 0xC5, 0xFC, 0x5F, 0xC5, 0xFC,
  0x5F, 0xC5, 0xFC, 0x5F, 0xC5, 0xFC, 0x5F, 0xC0,
  // "j" (U+006A)
  0x38, 0x14, 0xEA, 0x38, 0x15, 0xFC, 0x40, 0x17, 0x38, 0x15, 0xFC, 0x38, 0x15, 0xFC, 0x38, 0x15,
  0xFC, 0x38, 0x15, 0xFC, 0x38, 0x15, 0xFC, 0x38, 0x15, 0xFC, 0x38, 0x15, 0xFC, 0x38, 0x15, 0xFC,
  0x38, 0x15, 0xFC, 0x38, 0x15, 0xFC, 0x38, 0x15, 0xFC, 0x38, 0x15, 0xFC, 0x38, 0x15, 0xFB, 0x38,
  0x48, 0xFA, 0x2C, 0xCA, 0x84, 0x41, 0xEF, 0xD6, 0x10,
  // "k" (U+006B)
  0x81, 0x5F, 0xB7, 0x81, 0x5F, 0xB7, 0x81, 0x5F, 0xB7, 0x81, 0x5F, 0xB7, 0x81, 0x5F, 0xB3, 0x85,
  0x3E, 0xF5, 0x5F, 0xB2, 0x89, 0x32, 0xEF, 0x60, 0x5F, 0xB0, 0x1D, 0xF7, 0x28, 0x55, 0xFB, 0x0C,
  0xF8, 0x38, 0x45, 0xFB, 0xAF, 0xA4, 0x81, 0x5F, 0xEA, 0x0E, 0x01, 0x30, 0x5A, 0x82, 0x8B, 0xFB,
  0x38, 0x65, 0xFC, 0x01, 0xEF, 0x72, 0x81, 0x5F, 0xB2, 0x04, 0xA8, 0x33, 0x05, 0xFB, 0x38, 0x58,
  0xFD, 0x15, 0xFB, 0x48, 0x1C, 0xFA,
  // "l" (U+006C)
  0x8D, 0x35, 0xFC, 0x5F, 0xC5, 0xFC, 0x5F, 0xC5, 0xFC, 0x5F, 0xC5, 0xFC, 0x5F, 0xC5, 0xFC, 0x5F,
  0xC5, 0xFC, 0x5F, 0xC5, 0xFC, 0x5F, 0xC5, 0xFC,
  // "m" (U+006D)
  0x8B, 0x45, 0xF6, 0x3B, 0xEE, 0xB3, 0x05, 0xCE, 0xD9, 0x10, 0x5F, 0xBE, 0xEC, 0xEF, 0xE8, 0xFD,
  0xCA, 0x81, 0xD0, 0x5A, 0x09, 0x20, 0x10, 0xEA, 0x06, 0x20, 0x3A, 0x03, 0x05, 0xA0, 0x13, 0x81,
  0x9F, 0xC4, 0x84, 0xCF, 0x55, 0xFD, 0x48, 0x18, 0xFA, 0x48, 0x4B, 0xF6, 0x5F, 0xC4, 0x81, 0x8F,
  0x94, 0x84, 0xBF, 0x65, 0xFC, 0x48, 0x18, 0xF9, 0x48, 0x4B, 0xF6, 0x5F, 0xC4, 0x81, 0x8F, 0x94,
  0x84, 0xBF, 0x65, 0xFC, 0x48, 0x18, 0xF9, 0x48, 0x4B, 0xF6, 0x5F, 0xC4, 0x81, 0x8F, 0x94, 0x84,
  0xBF, 0x65, 0xFC, 0x48, 0x18, 0xF9, 0x48, 0x1B, 0xF6,
  // "n" (U+006E)
  0x89, 0x75, 0xF6, 0x2A, 0xEE, 0xC5, 0x05, 0xFB, 0xEE, 0xCD, 0xA0, 0x60, 0x5A, 0x0A, 0x38, 0x29,
  0xFC, 0x5A, 0x01, 0x30, 0x3A, 0x81, 0x5F, 0xD4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A, 0x81, 0x5F,
  0xC4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A, 0x81, 0x5F, 0xC4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A,
  0x81, 0x5F, 0xC4, 0x01, 0xA0,
  // "o" (U+006F)
  0x28, 0x45, 0xBE, 0xEC, 0x64, 0x09, 0xA0, 0xD0, 0xCA, 0x0B, 0x28, 0x24, 0xFE, 0x32, 0x86, 0x2D,
  0xF7, 0x0A, 0xF8, 0x48, 0x55, 0xFD, 0x0D, 0xF5, 0x40, 0x1A, 0x18, 0x1E, 0xF3, 0x5A, 0x82, 0x2D,
  0xF5, 0x40, 0x2A, 0x82, 0x1A, 0xF8, 0x48, 0x65, 0xFD, 0x04, 0xFE, 0x32, 0x82, 0x2D, 0xF7, 0x20,
  0x8A, 0x0D, 0x0C, 0xA0, 0xB4, 0x84, 0x5B, 0xEF, 0xC7, 0x30,
  // "p" (U+0070)
  0x87, 0x5F, 0x72, 0xBE, 0xEB, 0x32, 0x85, 0x5F, 0xCE, 0xEC, 0xEA, 0x81, 0x30, 0x5A, 0x09, 0x38,
  0x3B, 0xFC, 0x05, 0xA4, 0x02, 0xA8, 0x22, 0x5F, 0xD5, 0x84, 0xEF, 0x45, 0xFC, 0x58, 0x4D, 0xF5,
  0x5F, 0xD5, 0x82, 0xEF, 0x45, 0xA0, 0x13, 0x02, 0xA0, 0x20, 0x5A, 0x09, 0x38, 0x91, 0xAF, 0xC0,
  0x5F, 0xDF, 0xEB, 0xDA, 0x89, 0x13, 0x05, 0xFB, 0x3B, 0xEE, 0xB3, 0x28, 0x15, 0xFC, 0x71, 0x81,
  0x5F, 0xC7, 0x18, 0x15, 0xFC, 0x71, 0x81, 0x5F, 0xC7, 0x18, 0x15, 0xFC, 0x71,
  // "q" (U+0071)
  0x28, 0x90, 0x8D, 0xFD, 0x61, 0xFB, 0x0B, 0xA8, 0x90, 0xCD, 0xFB, 0xFB, 0x6F, 0xE2, 0x28, 0x53,
  0xEF, 0xBB, 0xF8, 0x48, 0x49, 0xFB, 0xDF, 0x54, 0x84, 0x6F, 0xBE, 0xF3, 0x48, 0x44, 0xFB, 0xDF,
  0x44, 0x84, 0x5F, 0xBB, 0xF8, 0x48, 0x58, 0xFB, 0x6F, 0xE3, 0x28, 0x43, 0xEF, 0xB0, 0xCA, 0x84,
  0xCC, 0xFB, 0xFB, 0x28, 0x68, 0xDF, 0xC6, 0x5F, 0xB7, 0x81, 0x5F, 0xB7, 0x81, 0x5F, 0xB7, 0x81,
  0x5F, 0xB7, 0x81, 0x5F, 0xB7, 0x81, 0x5F, 0xB0,
  // "r" (U+0072)
  0x89, 0x75, 0xF6, 0x19, 0xEE, 0x15, 0xF9, 0xDF, 0xCD, 0x05, 0xA0, 0xC0, 0x13, 0x05, 0xA0, 0x24,
  0x81, 0x5F, 0xD5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81,
  0x5F, 0xC5, 0x81, 0x5F, 0xC5,
  // "s" (U+0073)
  0x18, 0x66, 0xCE, 0xEC, 0x92, 0x9A, 0x83, 0xCC, 0xEF, 0x5A, 0x03, 0x38, 0x34, 0x0E, 0xF6, 0x50,
  0x6A, 0x0C, 0x05, 0x40, 0x30, 0xBA, 0x0E, 0x06, 0x40, 0x10, 0x8A, 0x06, 0x58, 0x26, 0xFB, 0x54,
  0x81, 0x7F, 0xBA, 0x81, 0xDB, 0xDA, 0x86, 0x47, 0xCE, 0xFD, 0xA3, 0x10,
  // "t" (U+0074)
  0x20, 0x30, 0x76, 0x09, 0x96, 0x0E, 0x94, 0x04, 0x0D, 0xD8, 0x11, 0x7B, 0xA0, 0xFB, 0x20, 0x2A,
  0x50, 0x2A, 0x50, 0x2A, 0x50, 0x2A, 0x50, 0x2A, 0x50, 0x2A, 0x6A, 0x03, 0x58, 0x4B, 0xFE, 0xCD,
  0x22, 0x84, 0x1A, 0xEE, 0xC1,
  // "u" (U+0075)
  0x81, 0x6F, 0xA4, 0x84, 0x2F, 0xE6, 0xFA, 0x48, 0x42, 0xFE, 0x6F, 0xA4, 0x84, 0x2F, 0xE6, 0xFA,
  0x48, 0x42, 0xFE, 0x6F, 0xA4, 0x84, 0x2F, 0xE6, 0xFA, 0x48, 0x43, 0xFE, 0x6F, 0xA4, 0x84, 0x4F,
  0xE6, 0xFC, 0x48, 0x27, 0xFE, 0x4A, 0x01, 0x38, 0xA5, 0xDF, 0xE0, 0xDF, 0xE9, 0x9D, 0xDF, 0xE0,
  0x19, 0xDF, 0xD9, 0x1D, 0xE0,
  // "v" (U+0076)
  0x81, 0xCF, 0x65, 0x84, 0xDF, 0x56, 0xFB, 0x48, 0x33, 0xFE, 0x01, 0xA0, 0x13, 0x81, 0x9F, 0x92,
  0x81, 0xAF, 0x73, 0x81, 0xEF, 0x32, 0x81, 0x5F, 0xC2, 0x81, 0x4F, 0xD4, 0x85, 0xEF, 0x20, 0x9F,
  0x74, 0x85, 0x9F, 0x70, 0xEF, 0x14, 0x84, 0x3F, 0xC4, 0xFB, 0x68, 0x3D, 0xF9, 0xF5, 0x60, 0x7A,
  0x0E, 0x70, 0x1A, 0x09, 0x40,
  // "w" (U+0077)
  0x81, 0xAF, 0x73, 0x03, 0xA0, 0x53, 0x84, 0x5F, 0xC5, 0xFB, 0x30, 0x8A, 0x0A, 0x38, 0x29, 0xF7,
  0x1A, 0x38, 0x2C, 0xEC, 0xE3, 0x8A, 0x0D, 0xF3, 0x0C, 0xF3, 0x01, 0xFA, 0x9F, 0x30, 0x1F, 0xE2,
  0x89, 0x48, 0xF7, 0x05, 0xF6, 0x5F, 0x70, 0x5F, 0xA2, 0x89, 0x44, 0xFB, 0x0A, 0xF2, 0x1F, 0xC0,
  0x9F, 0x63, 0x98, 0x2E, 0x0E, 0xD2, 0x84, 0xCF, 0x1D, 0xF2, 0x38, 0x3B, 0xF6, 0xF9, 0x28, 0x37,
  0xF6, 0xFD, 0x48, 0x37, 0xFB, 0xF4, 0x28, 0x33, 0xFC, 0xF9, 0x40, 0x3A, 0x0E, 0x40, 0xEA, 0x04,
  0x58, 0x1E, 0xFB, 0x40, 0xAA, 0x30,
  // "x" (U+0078)
  0x03, 0xA0, 0x33, 0x86, 0x5F, 0xE1, 0x08, 0xFC, 0x28, 0x21, 0xEF, 0x63, 0x85, 0xCF, 0x70, 0x9F,
  0xB4, 0x02, 0xA8, 0x26, 0xFE, 0x15, 0x07, 0xB0, 0x56, 0x01, 0xA0, 0xD7, 0x09, 0xB0, 0x75, 0x85,
  0x5F, 0xE3, 0xEF, 0x33, 0x86, 0x1E, 0xF5, 0x07, 0xFC, 0x38, 0x1A, 0xFA, 0x38, 0x6C, 0xF8, 0x05,
  0xFE, 0x13, 0x02, 0xA0, 0x30,
  // "y" (U+0079)
  0x81, 0xCF, 0x75, 0x84, 0xDF, 0x56, 0xFC, 0x48, 0x13, 0xFE, 0x28, 0x1E, 0xF2, 0x38, 0x18, 0xF9,
  0x28, 0x19, 0xF8, 0x38, 0x1D, 0xF4, 0x28, 0x13, 0xFD, 0x28, 0x13, 0xFD, 0x48, 0x5D, 0xF3, 0x09,
  0xF8, 0x48, 0x57, 0xF9, 0x0D, 0xF2, 0x48, 0x41, 0xFE, 0x3F, 0xC6, 0x83, 0xAF, 0xAF, 0x66, 0x04,
  0xB0, 0x17, 0x81, 0xDF, 0xA7, 0x18, 0x1C, 0xF4, 0x78, 0x12, 0xFE, 0x71, 0x81, 0xBF, 0x75, 0x83,
  0x7B, 0xEF, 0xC6, 0x83, 0x9F, 0xD9, 0x16,
  // "z" (U+007A)
  0x10, 0xEE, 0x89, 0x09, 0x0A, 0xBB, 0xBB, 0xEF, 0x85, 0x82, 0x4F, 0xD1, 0x48, 0x21, 0xEF, 0x45,
  0x81, 0xAF, 0x85, 0x81, 0x6F, 0xC5, 0x82, 0x2E, 0xF2, 0x58, 0x1C, 0xF6, 0x58, 0x18, 0xFB, 0x50,
  0x2A, 0x85, 0xCB, 0xBB, 0xB8, 0x4F, 0x0C,
  // "{" (U+007B)
  0x48, 0x17, 0xCE, 0x30, 0xAA, 0x0C, 0x3A, 0x03, 0x49, 0x0E, 0x48, 0x11, 0xFE, 0x48, 0x11, 0xFE,
  0x48, 0x11, 0xFD, 0x38, 0x22, 0xAF, 0xA2, 0x82, 0x8F, 0xE8, 0x38, 0x36, 0xDF, 0xC2, 0x48, 0x17,
  0xFB, 0x48, 0x11, 0xFE, 0x48, 0x11, 0xFE, 0x48, 0x11, 0xFE, 0x59, 0x0E, 0x58, 0x1E, 0xF7, 0x40,
  0x7B, 0x48, 0x14, 0x9B,
  // "|" (U+007C)
  0x8F, 0x24, 0xF5, 0x4F, 0x54, 0xF5, 0x4F, 0x54, 0xF5, 0x4F, 0x54, 0xF5, 0x4F, 0x54, 0xF5, 0x4F,
  0x54, 0xF5, 0x4F, 0x54, 0xF5, 0x4F, 0x54, 0xF5, 0x4F, 0x54, 0xF5, 0x4F, 0x54, 0xF5, 0x4F, 0x50,
  // "}" (U+007D)
  0x82, 0x4E, 0xC5, 0x40, 0x30, 0xDA, 0x04, 0x58, 0x18, 0xF9, 0x58, 0x13, 0xFB, 0x58, 0x13, 0xFB,
  0x58, 0x13, 0xFB, 0x58, 0x13, 0xFC, 0x68, 0x2E, 0xF6, 0x14, 0x03, 0x0A, 0xA0, 0x33, 0x83, 0x6E,
  0xFC, 0x22, 0x82, 0x1F, 0xE2, 0x48, 0x13, 0xFB, 0x58, 0x13, 0xFB, 0x58, 0x13, 0xFB, 0x58, 0x14,
  0xFB, 0x48, 0x21, 0xBF, 0x93, 0x04, 0xA0, 0xE0, 0x23, 0x82, 0x3A, 0x71, 0x40,
  // "~" (U+007E)
  0x83, 0x39, 0xA9, 0x53, 0x02, 0x04, 0xE8, 0x94, 0xCC, 0xF7, 0xA2, 0x03, 0x7C, 0xEE, 0xA1,
  // "¡" (U+00A1)
  0x82, 0x4E, 0xB9, 0xA8, 0x14, 0xC9, 0x68, 0xB4, 0x1F, 0x71, 0xF8, 0x2F, 0x93, 0xFA, 0x4F, 0xB5,
  0xFB, 0x5F, 0xC6, 0xFD, 0x7F, 0xE8, 0xFE,
  // "¢" (U+00A2)
  0x48, 0x15, 0xF1, 0x48, 0x90, 0x19, 0xDF, 0xEC, 0x60, 0x2E, 0xA8, 0x7C, 0xDF, 0x80, 0xBF, 0xC1,
  0x28, 0x12, 0x11, 0xA0, 0x35, 0x03, 0xA6, 0x81, 0x4F, 0xD6, 0x81, 0x3F, 0xE6, 0x01, 0xA0, 0x26,
  0x82, 0xCF, 0xB1, 0x38, 0x90, 0x20, 0x3E, 0xFE, 0xCC, 0xE9, 0x28, 0x51, 0x9E, 0xFE, 0xC4, 0x48,
  0x15, 0xF1, 0x68, 0x15, 0xF1, 0x20,
  // "£" (U+00A3)
  0x48, 0x57, 0xCE, 0xEC, 0x71, 0x30, 0xBA, 0x83, 0xCC, 0xFE, 0x12, 0x82, 0x3F, 0xE2, 0x30, 0x33,
  0x81, 0x6F, 0xB7, 0x18, 0x16, 0xFB, 0x71, 0x81, 0x6F, 0xB6, 0x04, 0xF0, 0xA2, 0x87, 0x3B, 0xDF,
  0xEB, 0xBB, 0x74, 0x81, 0x6F, 0xB7, 0x18, 0x16, 0xFB, 0x71, 0x81, 0x8F, 0x97, 0x82, 0x1D, 0xE2,
  0x68, 0x23, 0xEF, 0xD8, 0x02, 0xB0, 0x90, 0x4F, 0xA0, 0xC0,
  // "¤" (U+00A4)
  0x10, 0x55, 0x89, 0x31, 0x49, 0xF7, 0xBE, 0xD7, 0xDE, 0x1D, 0xA0, 0xC0, 0xDA, 0x83, 0x60, 0xBE,
  0x22, 0x84, 0x9F, 0x31, 0xF7, 0x49, 0x82, 0x81, 0xF7, 0x49, 0x83, 0x80, 0xCD, 0x22, 0x83, 0x8F,
  0x41, 0xDA, 0x0C, 0x0D, 0xA8, 0x92, 0x59, 0xF7, 0xBE, 0xD7, 0xDE, 0x04, 0x50, 0x10, 0x40,
  // "¥" (U+00A5)
  0x81, 0x7F, 0xA5, 0x85, 0x4F, 0xD0, 0xDF, 0x24, 0x85, 0xBF, 0x50, 0x5F, 0xA3, 0x81, 0x3F, 0xB3,
  0x81, 0xCF, 0x22, 0x81, 0xBF, 0x23, 0x85, 0x3F, 0x90, 0x3F, 0x95, 0x84, 0xAF, 0x2B, 0xE1, 0x48,
  0x61, 0x4F, 0xCF, 0x81, 0x12, 0x02, 0xF0, 0x83, 0x86, 0x44, 0x8F, 0xC4, 0x42, 0x58, 0x14, 0xFB,
  0x50, 0x2F, 0x08, 0x28, 0x71, 0xBB, 0xCF, 0xEB, 0xB6, 0x58, 0x14, 0xFB, 0x71, 0x81, 0x4F, 0xB4,
  // "¦" (U+00A6)
  0x8A, 0x64, 0xF5, 0x4F, 0x54, 0xF5, 0x4F, 0x54, 0xF5, 0x4F, 0x54, 0xF5, 0x4F, 0x57, 0x58, 0xA6,
  0x4F, 0x54, 0xF5, 0x4F, 0x54, 0xF5, 0x4F, 0x54, 0xF5, 0x4F, 0x54, 0xF5,
  // "§" (U+00A7)
  0x18, 0x64, 0xBE, 0xFD, 0x93, 0x5A, 0x86, 0xCC, 0xEF, 0x79, 0xF5, 0x38, 0x33, 0x17, 0xF9, 0x68,
  0x3B, 0xFE, 0x93, 0x28, 0x91, 0x1C, 0xEA, 0xEF, 0xA0, 0x8F, 0x22, 0x84, 0x8F, 0x9A, 0xF2, 0x38,
  0xA0, 0xEC, 0x5F, 0xD5, 0x02, 0xFA, 0x05, 0xDF, 0xEE, 0xC1, 0x38, 0x34, 0xAF, 0xE3, 0x58, 0x34,
  0xFB, 0x41, 0x38, 0x63, 0xFC, 0xDF, 0xDB, 0xCA, 0x86, 0x65, 0xBE, 0xFD, 0xB4, 0x10,
  // "¨" (U+00A8)
  0x89, 0x29, 0x80, 0x1A, 0x6D, 0xC0, 0x2E, 0x90,
  // "©" (U+00A9)
  0x48, 0x57, 0xBE, 0xFD, 0x94, 0x68, 0x90, 0x3E, 0xA4, 0x10, 0x26, 0xDA, 0x48, 0x13, 0xE5, 0x70,
  0xB0, 0xC3, 0x0D, 0x06, 0x28, 0x35, 0xCE, 0xD8, 0x28, 0x3C, 0x80, 0x6C, 0x20, 0x5A, 0x81, 0xCD,
  0xD2, 0x83, 0x3F, 0x1B, 0x72, 0x81, 0xEE, 0x22, 0x01, 0x38, 0x6D, 0x5E, 0x40, 0x3F, 0x77, 0x86,
  0xA8, 0xF3, 0x05, 0xF4, 0x78, 0x69, 0x9E, 0x40, 0x4F, 0x47, 0x86, 0xA8, 0xB7, 0x02, 0xF7, 0x78,
  0x2D, 0x67, 0xD2, 0x84, 0xCE, 0x40, 0x14, 0x28, 0x63, 0xF1, 0x0E, 0x70, 0x4C, 0x0C, 0x20, 0xC0,
  0x92, 0x89, 0x24, 0xF6, 0x02, 0x9B, 0x93, 0x0A, 0xD4, 0x89, 0x14, 0xEA, 0x41, 0x02, 0x6D, 0xB1,
  0x68, 0x57, 0xCE, 0xFD, 0xA4, 0x40,
  // "ª" (U+00AA)
  0x18, 0x38, 0xDF, 0xD7, 0x28, 0x73, 0x21, 0x5F, 0x30, 0x7D, 0xB8, 0xA4, 0x54, 0xF6, 0x12, 0xF5,
  0x5F, 0x41, 0x9F, 0x50, 0xAE, 0xD7, 0xD5,
  // "«" (U+00AB)
  0x40, 0x63, 0x05, 0x01, 0x38, 0x5A, 0xF7, 0x06, 0xFB, 0x28, 0xB0, 0x7F, 0xB0, 0x4F, 0xD1, 0x05,
  0xFD, 0x12, 0xEF, 0x30, 0x1E, 0xF3, 0x0C, 0xF7, 0x38, 0x69, 0xFA, 0x05, 0xFD, 0x13, 0x85, 0xBF,
  0x70, 0x8F, 0xB3, 0x86, 0x1D, 0xF4, 0x0A, 0xF8, 0x38, 0x12, 0xB3, 0x20, 0xB0, 0x50,
  // "¬" (U+00AC)
  0x80, 0x5B, 0x05, 0xFA, 0x06, 0x78, 0x12, 0xF6, 0x78, 0x12, 0xF6, 0x78, 0x12, 0xF6, 0x78, 0x11,
  0x73,
  // "®" (U+00AE)
  0x48, 0x57, 0xBE, 0xFD, 0x94, 0x68, 0x90, 0x3E, 0xA4, 0x10, 0x26, 0xDA, 0x48, 0x13, 0xE5, 0x70,
  0xB0, 0xC3, 0x82, 0xD6, 0x06, 0xA8, 0x1E, 0xC4, 0x28, 0x3C, 0x80, 0x6C, 0x28, 0x93, 0x6F, 0xBC,
  0xFE, 0x10, 0x3F, 0x1B, 0x72, 0x85, 0x6F, 0x10, 0x5F, 0x32, 0x82, 0xD5, 0xE4, 0x28, 0x56, 0xF1,
  0x09, 0xF2, 0x28, 0x2A, 0x8F, 0x32, 0x06, 0xC0, 0x83, 0x82, 0x99, 0xE4, 0x28, 0x36, 0xFB, 0xDE,
  0x48, 0x2A, 0x8B, 0x72, 0x84, 0x6F, 0x13, 0xF8, 0x38, 0x2D, 0x67, 0xD2, 0x8A, 0x76, 0xF1, 0x09,
  0xF2, 0x03, 0xF1, 0x0E, 0x70, 0x6F, 0x10, 0x1E, 0xA0, 0xC9, 0x28, 0x34, 0xF6, 0x12, 0x38, 0x21,
  0x3B, 0xD4, 0x89, 0x14, 0xEA, 0x41, 0x02, 0x6D, 0xB1, 0x68, 0x57, 0xCE, 0xFD, 0xA4, 0x40,
  // "¯" (U+00AF)
  0x18, 0x06, 0xB1, 0x01, 0xFB, 0x01,
  // "°" (U+00B0)
  0x18, 0x23, 0x9A, 0x72, 0x04, 0xC8, 0x91, 0xC0, 0xCD, 0x20, 0x7F, 0x5E, 0x83, 0x98, 0x17, 0xDB,
  0x28, 0x96, 0x3F, 0x67, 0xFD, 0xCF, 0xE1, 0x07, 0xDE, 0xB2, 0x10,
  // "±" (U+00B1)
  0x38, 0x11, 0xF8, 0x78, 0x11, 0xF8, 0x78, 0x11, 0xF8, 0x78, 0x11, 0xF8, 0x4F, 0xA8, 0x91, 0x6B,
  0xBB, 0xBF, 0xDB, 0xBB, 0x53, 0x81, 0x1F, 0x87, 0x81, 0x1F, 0x87, 0x81, 0x1F, 0x87, 0x81, 0x1F,
  0x84, 0x80, 0x5B, 0x05, 0xFA, 0x07,
  // "²" (U+00B2)
  0x30, 0x14, 0x08, 0xB8, 0x77, 0x02, 0xE8, 0x5C, 0xF2, 0x48, 0x17, 0xF3, 0x40, 0xC0, 0xD4, 0x81,
  0xAE, 0x23, 0x81, 0xBD, 0x22, 0x86, 0x1C, 0xE4, 0x22, 0x07, 0xD0, 0x50, 0x28, 0x01, 0x50, 0x10,
  // "³" (U+00B3)
  0x30, 0x13, 0x01, 0x0A, 0xA8, 0x90, 0xE6, 0x03, 0xE7, 0x5C, 0xF1, 0x48, 0x16, 0xF3, 0x28, 0x22,
  0x4C, 0xD2, 0x04, 0xA0, 0xE0, 0x32, 0x84, 0x15, 0x6B, 0xE2, 0x48, 0x91, 0x2F, 0x76, 0x63, 0x39,
  0xF5, 0x6C, 0x09, 0x28, 0x21, 0x44, 0x12,
  // "´" (U+00B4)
  0x28, 0x94, 0x7F, 0xD1, 0x03, 0xFD, 0x10, 0x1D, 0xB1, 0x20,
  // "µ" (U+00B5)
  0x81, 0x5F, 0xC4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A, 0x81, 0x5F, 0xC4, 0x01, 0xA8, 0x15, 0xFC,
  0x40, 0x1A, 0x81, 0x5F, 0xC4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A, 0x81, 0x5F, 0xC4, 0x03, 0xA8,
  0x15, 0xFD, 0x40, 0x6A, 0x05, 0xA0, 0x42, 0x01, 0x0D, 0xA0, 0x5B, 0x8A, 0x1C, 0xCF, 0xCE, 0xF5,
  0xFC, 0xAE, 0xEA, 0x1B, 0xF5, 0xFB, 0x78, 0x15, 0xFC, 0x78, 0x15, 0xFC, 0x78, 0x15, 0xFC, 0x78,
  0x15, 0xFC, 0x70,
  // "¶" (U+00B6)
  0x18, 0x11, 0x9D, 0xE8, 0x11, 0x0D, 0xD8, 0x3B, 0xCF, 0x17, 0xD8, 0x4E, 0x02, 0xF1, 0xBD, 0x84,
  0xE0, 0x2F, 0x1D, 0xD8, 0x4E, 0x02, 0xF1, 0xDD, 0x84, 0xE0, 0x2F, 0x1C, 0xD8, 0x4E, 0x02, 0xF1,
  0x9D, 0x84, 0xE0, 0x2F, 0x13, 0xD8, 0x5E, 0x02, 0xF1, 0x07, 0xC8, 0x3E, 0x02, 0xF1, 0x28, 0x71,
  0x45, 0x8E, 0x02, 0xF1, 0x58, 0x45, 0xE0, 0x2F, 0x15, 0x84, 0x5E, 0x02, 0xF1, 0x58, 0x45, 0xE0,
  0x2F, 0x15, 0x84, 0x5E, 0x02, 0xF1, 0x58, 0x45, 0xE0, 0x2F, 0x15, 0x84, 0x5E, 0x02, 0xF1, 0x58,
  0x45, 0xE0, 0x2F, 0x15, 0x01, 0x03, 0x20, 0x31,
  // "·" (U+00B7)
  0x82, 0x3C, 0x99, 0xA8, 0x14, 0xEB,
  // "¸" (U+00B8)
  0x10, 0x70, 0x82, 0x82, 0x1D, 0xD5, 0x38, 0x7A, 0xF1, 0x78, 0xDF, 0x1E, 0xA8, 0x27, 0x02, 0x23,
  // "¹" (U+00B9)
  0x18, 0x94, 0x3E, 0xF1, 0x7F, 0xEF, 0x1D, 0x79, 0xF1, 0x28, 0x19, 0xF1, 0x28, 0x19, 0xF1, 0x28,
  0x19, 0xF1, 0x28, 0x19, 0xF1, 0x28, 0x19, 0xF1, 0x28, 0x19, 0xF1,
  // "º" (U+00BA)
  0x18, 0x96, 0x3B, 0xED, 0x80, 0x1E, 0x91, 0x3D, 0x94, 0xF2, 0x28, 0x38, 0xD4, 0xF2, 0x28, 0x92,
  0x8E, 0x1E, 0x80, 0x1D, 0x90, 0x4D, 0xA0, 0xA0, 0x10,
  // "»" (U+00BB)
  0x02, 0x04, 0x20, 0x10, 0x53, 0x85, 0xDF, 0x30, 0xAF, 0x72, 0x86, 0x3F, 0xE1, 0x1D, 0xF4, 0x28,
  0x65, 0xFC, 0x02, 0xEE, 0x22, 0x8B, 0x6A, 0xF9, 0x06, 0xFD, 0x02, 0xEE, 0x30, 0xCF, 0x61, 0xDF,
  0x50, 0xAF, 0x90, 0xBF, 0x70, 0x7F, 0xB2, 0x07, 0x09, 0x28, 0x15, 0xB1, 0x20,
  // "¼" (U+00BC)
  0x28, 0x15, 0xFD, 0x58, 0x11, 0xF9, 0x48, 0x28, 0xFE, 0xD5, 0x81, 0xAE, 0x13, 0x83, 0x2E, 0x6B,
  0xD4, 0x81, 0x3F, 0x75, 0x82, 0x10, 0xCD, 0x40, 0xC0, 0xD7, 0x10, 0xC0, 0xD3, 0x81, 0x5F, 0x57,
  0x10, 0xC0, 0xD3, 0x0D, 0x0C, 0x72, 0x0C, 0x0D, 0x28, 0x47, 0xF3, 0x01, 0xE9, 0x58, 0x4C, 0xD0,
  0x1E, 0xA2, 0x0A, 0xA5, 0x89, 0x0C, 0xD0, 0x9F, 0x20, 0x4E, 0xC9, 0x78, 0x13, 0xF8, 0x28, 0x1D,
  0x6B, 0x97, 0x0B, 0x0E, 0x28, 0x29, 0xC0, 0xB9, 0x68, 0x91, 0x4F, 0x60, 0x3F, 0x41, 0xBF, 0x15,
  0x0D, 0x0C, 0x20, 0x9E, 0x03, 0x38, 0x17, 0xF4, 0x28, 0x52, 0x33, 0x3C, 0xF3, 0x38, 0x11, 0xEB,
  0x70, 0xB9, 0x20,
  // "½" (U+00BD)
  0x28, 0x17, 0xFB, 0x58, 0x18, 0xF3, 0x40, 0xAA, 0x0B, 0x48, 0x11, 0xEA, 0x48, 0x34, 0xE4, 0xEB,
  0x48, 0x1A, 0xF1, 0x58, 0x21, 0x0E, 0xB3, 0x81, 0x3F, 0x87, 0x10, 0xE0, 0xB3, 0x0C, 0x0E, 0x72,
  0x0E, 0x0B, 0x28, 0x15, 0xF6, 0x72, 0x0E, 0x0B, 0x28, 0x2D, 0xC1, 0x9A, 0x0D, 0x04, 0x48, 0x92,
  0xEB, 0x07, 0xF4, 0x4E, 0x75, 0xDE, 0x48, 0x3E, 0xB1, 0xEA, 0x58, 0x19, 0xF1, 0x58, 0x19, 0xF2,
  0x50, 0x0D, 0x58, 0x12, 0xF8, 0x58, 0x19, 0xF3, 0x58, 0x1B, 0xE1, 0x48, 0x19, 0xF4, 0x58, 0x14,
  0xF6, 0x48, 0x19, 0xE4, 0x60, 0x0D, 0x48, 0x57, 0xFD, 0xBB, 0xB2, 0x28, 0x16, 0xF4, 0x40, 0x9D,
  0x03,
  // "¾" (U+00BE)
  0x18, 0x32, 0x9A, 0x92, 0x58, 0x12, 0xB6, 0x20, 0x3C, 0x0E, 0x01, 0x48, 0x1B, 0xE1, 0x38, 0x47,
  0x20, 0x8F, 0x43, 0x81, 0x4F, 0x76, 0x82, 0x19, 0xE1, 0x30, 0x0D, 0x50, 0x3A, 0x0E, 0x04, 0x38,
  0x16, 0xF5, 0x78, 0x61, 0x8F, 0x30, 0x1E, 0xB7, 0x28, 0xB3, 0x1F, 0x80, 0x9F, 0x20, 0x6F, 0x90,
  0x55, 0x10, 0x8F, 0x62, 0xF9, 0x01, 0xEF, 0x90, 0x7C, 0x89, 0x0E, 0x1B, 0xE1, 0x0B, 0xBF, 0x92,
  0x89, 0x46, 0xAA, 0x81, 0x4F, 0x60, 0x5E, 0x4F, 0x97, 0x87, 0xDD, 0x01, 0xE6, 0x2F, 0x96, 0x89,
  0x17, 0xF4, 0x09, 0xC1, 0x3F, 0x91, 0x48, 0x11, 0xEB, 0x2E, 0x0C, 0x48, 0x19, 0xF2, 0x20, 0xF3,
  0x82, 0x5F, 0xA3, 0x38, 0x13, 0xF8, 0x68, 0x12, 0xF9, 0x10,
  // "¿" (U+00BF)
  0x48, 0x1B, 0xE4, 0x6A, 0x09, 0x68, 0x19, 0xC3, 0x77, 0x18, 0x14, 0x92, 0x68, 0x1A, 0xF2, 0x58,
  0x15, 0xFD, 0x58, 0x27, 0xFE, 0x24, 0x82, 0x8F, 0xC1, 0x48, 0x23, 0xFD, 0x15, 0x81, 0x6F, 0xA6,
  0x82, 0x4F, 0xD1, 0x38, 0x65, 0x10, 0xDF, 0xEB, 0xCA, 0x89, 0x09, 0x01, 0x8D, 0xFE, 0xC7, 0x10,
  // "À" (U+00C0)
  0x48, 0x1D, 0xF9, 0x73, 0x82, 0x1C, 0xF4, 0x74, 0x81, 0xAE, 0x17, 0x77, 0x77, 0x81, 0xCF, 0xD7,
  0x20, 0x2B, 0x03, 0x71, 0x83, 0x8F, 0xAF, 0x97, 0x18, 0x3E, 0xF1, 0xEE, 0x78, 0x55, 0xFB, 0x09,
  0xF6, 0x68, 0x5B, 0xF5, 0x04, 0xFC, 0x58, 0x11, 0xFE, 0x38, 0x1D, 0xF2, 0x48, 0x17, 0xF9, 0x38,
  0x17, 0xF8, 0x40, 0xDF, 0x0E, 0x30, 0x4A, 0x80, 0x1D, 0xA0, 0x52, 0x81, 0xAF, 0x85, 0x83, 0x7F,
  0xB0, 0x1A, 0x02, 0x50, 0x2A, 0x82, 0x16, 0xFC, 0x78, 0x4B, 0xF7, 0xCF, 0x67, 0x81, 0x6F, 0xD0,
  // "Á" (U+00C1)
  0x68, 0x27, 0xFD, 0x17, 0x18, 0x23, 0xFD, 0x17, 0x18, 0x21, 0xDB, 0x18, 0x0C, 0x00, 0x81, 0xCF,
  0xD7, 0x20, 0x2B, 0x03, 0x71, 0x83, 0x8F, 0xAF, 0x97, 0x18, 0x3E, 0xF1, 0xEE, 0x78, 0x55, 0xFB,
  0x09, 0xF6, 0x68, 0x5B, 0xF5, 0x04, 0xFC, 0x58, 0x11, 0xFE, 0x38, 0x1D, 0xF2, 0x48, 0x17, 0xF9,
  0x38, 0x17, 0xF8, 0x40, 0xDF, 0x0E, 0x30, 0x4A, 0x80, 0x1D, 0xA0, 0x52, 0x81, 0xAF, 0x85, 0x83,
  0x7F, 0xB0, 0x1A, 0x02, 0x50, 0x2A, 0x82, 0x16, 0xFC, 0x78, 0x4B, 0xF7, 0xCF, 0x67, 0x81, 0x6F,
  0xD0,
  // "Â" (U+00C2)
  0x48, 0x32, 0xEF, 0xD1, 0x78, 0x41, 0xDE, 0x8F, 0xB6, 0x86, 0x1C, 0xC2, 0x04, 0xDB, 0x77, 0x77,
  0x68, 0x1C, 0xFD, 0x72, 0x02, 0xB0, 0x37, 0x18, 0x38, 0xFA, 0xF9, 0x71, 0x83, 0xEF, 0x1E, 0xE7,
  0x85, 0x5F, 0xB0, 0x9F, 0x66, 0x85, 0xBF, 0x50, 0x4F, 0xC5, 0x81, 0x1F, 0xE3, 0x81, 0xDF, 0x24,
  0x81, 0x7F, 0x93, 0x81, 0x7F, 0x84, 0x0D, 0xF0, 0xE3, 0x04, 0xA8, 0x01, 0xDA, 0x05, 0x28, 0x1A,
  0xF8, 0x58, 0x37, 0xFB, 0x01, 0xA0, 0x25, 0x02, 0xA8, 0x21, 0x6F, 0xC7, 0x84, 0xBF, 0x7C, 0xF6,
  0x78, 0x16, 0xFD,
  // "Ã" (U+00C3)
  0x38, 0x21, 0x9A, 0x52, 0x0A, 0x03, 0x50, 0xBB, 0x82, 0xDD, 0xE1, 0x48, 0x61, 0xF4, 0x18, 0xDE,
  0x57, 0x77, 0x76, 0x81, 0xCF, 0xD7, 0x20, 0x2B, 0x03, 0x71, 0x83, 0x8F, 0xAF, 0x97, 0x18, 0x3E,
  0xF1, 0xEE, 0x78, 0x55, 0xFB, 0x09, 0xF6, 0x68, 0x5B, 0xF5, 0x04, 0xFC, 0x58, 0x11, 0xFE, 0x38,
  0x1D, 0xF2, 0x48, 0x17, 0xF9, 0x38, 0x17, 0xF8, 0x40, 0xDF, 0x0E, 0x30, 0x4A, 0x80, 0x1D, 0xA0,
  0x52, 0x81, 0xAF, 0x85, 0x83, 0x7F, 0xB0, 0x1A, 0x02, 0x50, 0x2A, 0x82, 0x16, 0xFC, 0x78, 0x4B,
  0xF7, 0xCF, 0x67, 0x81, 0x6F, 0xD0,
  // "Ä" (U+00C4)
  0x48, 0x49, 0x80, 0x1A, 0x67, 0x84, 0xDC, 0x02, 0xE9, 0x80, 0xD3, 0x08, 0x1C, 0xFD, 0x72, 0x02,
  0xB0, 0x37, 0x18, 0x38, 0xFA, 0xF9, 0x71, 0x83, 0xEF, 0x1E, 0xE7, 0x85, 0x5F, 0xB0, 0x9F, 0x66,
  0x85, 0xBF, 0x50, 0x4F, 0xC5, 0x81, 0x1F, 0xE3, 0x81, 0xDF, 0x24, 0x81, 0x7F, 0x93, 0x81, 0x7F,
  0x84, 0x0D, 0xF0, 0xE3, 0x04, 0xA8, 0x01, 0xDA, 0x05, 0x28, 0x1A, 0xF8, 0x58, 0x37, 0xFB, 0x01,
  0xA0, 0x25, 0x02, 0xA8, 0x21, 0x6F, 0xC7, 0x84, 0xBF, 0x7C, 0xF6, 0x78, 0x16, 0xFD,
  // "Å" (U+00C5)
  0x48, 0x26, 0xEE, 0x87, 0x18, 0x41, 0xF3, 0x2E, 0x37, 0x84, 0x1F, 0x22, 0xE3, 0x71, 0x07, 0xB7,
  0x20, 0x2B, 0x03, 0x71, 0x83, 0x8F, 0xAF, 0x97, 0x18, 0x3E, 0xF1, 0xEE, 0x78, 0x55, 0xFB, 0x09,
  0xF6, 0x68, 0x5B, 0xF5, 0x04, 0xFC, 0x58, 0x11, 0xFE, 0x38, 0x1D, 0xF2, 0x48, 0x17, 0xF9, 0x38,
  0x17, 0xF8, 0x40, 0xDF, 0x0E, 0x30, 0x4A, 0x80, 0x1D, 0xA0, 0x52, 0x81, 0xAF, 0x85, 0x83, 0x7F,
  0xB0, 0x1A, 0x02, 0x50, 0x2A, 0x82, 0x16, 0xFC, 0x78, 0x4B, 0xF7, 0xCF, 0x67, 0x81, 0x6F, 0xD0,
  // "Æ" (U+00C6)
  0x60, 0x9F, 0xA0, 0xD5, 0x82, 0x1F, 0xEB, 0xA8, 0x4C, 0xBB, 0xBB, 0x95, 0x85, 0x8F, 0x80, 0xEF,
  0x37, 0x28, 0x61, 0xEF, 0x10, 0xEF, 0x37, 0x28, 0x17, 0xF9, 0x28, 0x1E, 0xF3, 0x72, 0x81, 0xEF,
  0x22, 0x81, 0xEF, 0x37, 0x18, 0x16, 0xFA, 0x30, 0xEE, 0x07, 0x38, 0x1D, 0xF2, 0x38, 0x6E, 0xFC,
  0xBB, 0xBB, 0x52, 0x06, 0xF9, 0x03, 0x70, 0xD9, 0x80, 0x1B, 0xA0, 0x36, 0x81, 0x5F, 0xC5, 0x81,
  0xEF, 0x36, 0x81, 0xCF, 0x55, 0x81, 0xEF, 0x35, 0x81, 0x4F, 0xD6, 0x89, 0x1E, 0xFC, 0xBB, 0xBB,
  0x9C, 0xF6, 0x60, 0xEE, 0x0D,
  // "Ç" (U+00C7)
  0x38, 0x62, 0x8C, 0xEE, 0xDA, 0x52, 0x07, 0xA8, 0x6E, 0xCB, 0xEF, 0xB0, 0x6A, 0x07, 0x48, 0x44,
  0x31, 0xEF, 0x67, 0x81, 0x6F, 0xD7, 0x18, 0x1A, 0xF9, 0x71, 0x81, 0xBF, 0x77, 0x18, 0x1B, 0xF7,
  0x71, 0x81, 0xAF, 0x97, 0x18, 0x17, 0xFD, 0x71, 0x02, 0xA0, 0x57, 0x18, 0x28, 0xFE, 0x54, 0x00,
  0x12, 0x0A, 0xA8, 0x4E, 0xBC, 0xDF, 0x73, 0x81, 0x4A, 0xDA, 0x81, 0xDA, 0x35, 0x07, 0x08, 0x71,
  0x82, 0x1D, 0xD5, 0x72, 0x81, 0xAF, 0x16, 0x83, 0x78, 0xDF, 0x16, 0x0E, 0xA0, 0x77, 0x00, 0x25,
  // "È" (U+00C8)
  0x28, 0x1D, 0xF9, 0x68, 0x21, 0xCF, 0x47, 0x81, 0xAE, 0x17, 0x76, 0x01, 0xF0, 0xE0, 0x1A, 0x80,
  0x1B, 0x0A, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01, 0xF0,
  0x90, 0x1A, 0x80, 0x1B, 0x06, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01, 0xA0,
  0x15, 0x01, 0xA8, 0x01, 0xB0, 0xA0, 0x1F, 0x0E,
  // "É" (U+00C9)
  0x58, 0x27, 0xFD, 0x14, 0x82, 0x3F, 0xD1, 0x48, 0x21, 0xDB, 0x17, 0x76, 0x01, 0xF0, 0xE0, 0x1A,
  0x80, 0x1B, 0x0A, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01,
  0xF0, 0x90, 0x1A, 0x80, 0x1B, 0x06, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01,
  0xA0, 0x15, 0x01, 0xA8, 0x01, 0xB0, 0xA0, 0x1F, 0x0E,
  // "Ê" (U+00CA)
  0x38, 0x32, 0xEF, 0xD1, 0x38, 0x41, 0xDE, 0x8F, 0xB2, 0x86, 0x1C, 0xC2, 0x04, 0xDB, 0x77, 0x40,
  0x1F, 0x0E, 0x01, 0xA8, 0x01, 0xB0, 0xA0, 0x1A, 0x01, 0x50, 0x1A, 0x01, 0x50, 0x1A, 0x01, 0x50,
  0x1A, 0x01, 0x50, 0x1F, 0x09, 0x01, 0xA8, 0x01, 0xB0, 0x60, 0x1A, 0x01, 0x50, 0x1A, 0x01, 0x50,
  0x1A, 0x01, 0x50, 0x1A, 0x01, 0x50, 0x1A, 0x80, 0x1B, 0x0A, 0x01, 0xF0, 0xE0,
  // "Ë" (U+00CB)
  0x28, 0x49, 0x80, 0x1A, 0x63, 0x84, 0xDC, 0x02, 0xE9, 0x77, 0x77, 0x01, 0xF0, 0xE0, 0x1A, 0x80,
  0x1B, 0x0A, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01, 0xF0,
  0x90, 0x1A, 0x80, 0x1B, 0x06, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01, 0xA0,
  0x15, 0x01, 0xA8, 0x01, 0xB0, 0xA0, 0x1F, 0x0E,
  // "Ì" (U+00CC)
  0x18, 0x1D, 0xF9, 0x48, 0x21, 0xCF, 0x45, 0x81, 0xAE, 0x17, 0x71, 0x03, 0xD8, 0x64, 0x18, 0xDF,
  0xE8, 0x12, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F,
  0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x93,
  0x85, 0x6C, 0xFD, 0x61, 0x3D, 0x04,
  // "Í" (U+00CD)
  0x38, 0x27, 0xFD, 0x12, 0x82, 0x3F, 0xD1, 0x28, 0x21, 0xDB, 0x17, 0x72, 0x03, 0xD8, 0x64, 0x18,
  0xDF, 0xE8, 0x12, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81,
  0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F,
  0x93, 0x85, 0x6C, 0xFD, 0x61, 0x3D, 0x04,
  // "Î" (U+00CE)
  0x28, 0x32, 0xEF, 0xD1, 0x28, 0x95, 0x1D, 0xE8, 0xFB, 0x01, 0xCC, 0x20, 0x4D, 0xB7, 0x73, 0x03,
  0xD8, 0x74, 0x01, 0x8D, 0xFE, 0x81, 0x38, 0x18, 0xF9, 0x58, 0x18, 0xF9, 0x58, 0x18, 0xF9, 0x58,
  0x18, 0xF9, 0x58, 0x18, 0xF9, 0x58, 0x18, 0xF9, 0x58, 0x18, 0xF9, 0x58, 0x18, 0xF9, 0x58, 0x18,
  0xF9, 0x58, 0x18, 0xF9, 0x48, 0x66, 0xCF, 0xD6, 0x10, 0x3D, 0x04,
  // "Ï" (U+00CF)
  0x18, 0x93, 0x98, 0x01, 0xA6, 0x0D, 0xC0, 0x2E, 0x97, 0x77, 0x03, 0xD8, 0x64, 0x18, 0xDF, 0xE8,
  0x12, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94,
  0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x93, 0x85,
  0x6C, 0xFD, 0x61, 0x3D, 0x04,
  // "Ð" (U+00D0)
  0x2D, 0x81, 0xDB, 0x66, 0xA8, 0x2C, 0xBB, 0xDA, 0x0D, 0x03, 0x4A, 0x02, 0x38, 0x32, 0xBF, 0xE2,
  0x3A, 0x02, 0x58, 0x1B, 0xFB, 0x3A, 0x02, 0x50, 0x3A, 0x01, 0x2A, 0x02, 0x68, 0x2E, 0xF4, 0x6E,
  0x05, 0x38, 0x3C, 0xF6, 0x5B, 0xA8, 0x2C, 0xBB, 0x43, 0x81, 0xDF, 0x62, 0xA0, 0x26, 0x81, 0xEF,
  0x42, 0xA0, 0x25, 0x03, 0xA0, 0x12, 0xA0, 0x25, 0x81, 0xCF, 0xA3, 0xA0, 0x23, 0x83, 0x3C, 0xFE,
  0x23, 0xA8, 0x2C, 0xBC, 0xEA, 0x0D, 0x02, 0x4C, 0x82, 0xED, 0xA5, 0x40,
  // "Ñ" (U+00D1)
  0x38, 0x21, 0x9A, 0x52, 0x0A, 0x03, 0x50, 0xBB, 0x82, 0xDD, 0xE1, 0x48, 0x61, 0xF4, 0x18, 0xDE,
  0x57, 0x77, 0x71, 0x01, 0xA0, 0xC6, 0x82, 0x5F, 0x91, 0xB0, 0x65, 0x82, 0x5F, 0x91, 0xB0, 0xE0,
  0x14, 0x87, 0x5F, 0x91, 0xFB, 0xBF, 0xA4, 0x85, 0x5F, 0x91, 0xFC, 0x2A, 0x05, 0x38, 0x90, 0x5F,
  0x91, 0xFC, 0x07, 0xFD, 0x38, 0x45, 0xF9, 0x1F, 0xD2, 0x81, 0xCF, 0x82, 0x84, 0x5F, 0x91, 0xFD,
  0x20, 0x3A, 0x86, 0x30, 0x5F, 0x91, 0xFD, 0x38, 0x90, 0x8F, 0xC0, 0x5F, 0x91, 0xFD, 0x48, 0x7D,
  0xF7, 0x5F, 0x91, 0xFD, 0x48, 0x73, 0xFE, 0x6F, 0x91, 0xFD, 0x58, 0x69, 0xFE, 0xF9, 0x1F, 0xD5,
  0x01, 0x0D, 0xA8, 0x29, 0x1F, 0xD6, 0x05, 0xA0, 0x90,
  // "Ò" (U+00D2)
  0x48, 0x1D, 0xF9, 0x74, 0x82, 0x1C, 0xF4, 0x75, 0x81, 0xAE, 0x18, 0x0C, 0x00, 0x86, 0x4A, 0xDE,
  0xEC, 0x82, 0x50, 0x9A, 0x85, 0xEB, 0xCE, 0xFE, 0x53, 0x82, 0x8F, 0xE5, 0x40, 0x8A, 0x81, 0x30,
  0x2A, 0x04, 0x68, 0x59, 0xFC, 0x07, 0xFD, 0x70, 0x2A, 0x82, 0x2A, 0xF9, 0x71, 0x84, 0xEF, 0x5B,
  0xF7, 0x71, 0x84, 0xCF, 0x7B, 0xF7, 0x71, 0x84, 0xCF, 0x7A, 0xF9, 0x71, 0x84, 0xEF, 0x56, 0xFD,
  0x70, 0x2A, 0x02, 0x01, 0xA0, 0x56, 0x81, 0x9F, 0xC2, 0x82, 0x8F, 0xE4, 0x40, 0x8A, 0x03, 0x30,
  0x9A, 0x85, 0xEB, 0xCE, 0xFE, 0x55, 0x86, 0x4A, 0xDE, 0xEC, 0x82, 0x30,
  // "Ó" (U+00D3)
  0x78, 0x27, 0xFD, 0x17, 0x28, 0x23, 0xFD, 0x17, 0x28, 0x21, 0xDB, 0x18, 0x0C, 0x00, 0x86, 0x4A,
  0xDE, 0xEC, 0x82, 0x50, 0x9A, 0x85, 0xEB, 0xCE, 0xFE, 0x53, 0x82, 0x8F, 0xE5, 0x40, 0x8A, 0x81,
  0x30, 0x2A, 0x04, 0x68, 0x59, 0xFC, 0x07, 0xFD, 0x70, 0x2A, 0x82, 0x2A, 0xF9, 0x71, 0x84, 0xEF,
  0x5B, 0xF7, 0x71, 0x84, 0xCF, 0x7B, 0xF7, 0x71, 0x84, 0xCF, 0x7A, 0xF9, 0x71, 0x84, 0xEF, 0x56,
  0xFD, 0x70, 0x2A, 0x02, 0x01, 0xA0, 0x56, 0x81, 0x9F, 0xC2, 0x82, 0x8F, 0xE4, 0x40, 0x8A, 0x03,
  0x30, 0x9A, 0x85, 0xEB, 0xCE, 0xFE, 0x55, 0x86, 0x4A, 0xDE, 0xEC, 0x82, 0x30,
  // "Ô" (U+00D4)
  0x48, 0x32, 0xEF, 0xD1, 0x71, 0x84, 0x1D, 0xE8, 0xFB, 0x78, 0x61, 0xCC, 0x20, 0x4D, 0xB7, 0x77,
  0x77, 0x86, 0x4A, 0xDE, 0xEC, 0x82, 0x50, 0x9A, 0x85, 0xEB, 0xCE, 0xFE, 0x53, 0x82, 0x8F, 0xE5,
  0x40, 0x8A, 0x81, 0x30, 0x2A, 0x04, 0x68, 0x59, 0xFC, 0x07, 0xFD, 0x70, 0x2A, 0x82, 0x2A, 0xF9,
  0x71, 0x84, 0xEF, 0x5B, 0xF7, 0x71, 0x84, 0xCF, 0x7B, 0xF7, 0x71, 0x84, 0xCF, 0x7A, 0xF9, 0x71,
  0x84, 0xEF, 0x56, 0xFD, 0x70, 0x2A, 0x02, 0x01, 0xA0, 0x56, 0x81, 0x9F, 0xC2, 0x82, 0x8F, 0xE4,
  0x40, 0x8A, 0x03, 0x30, 0x9A, 0x85, 0xEB, 0xCE, 0xFE, 0x55, 0x86, 0x4A, 0xDE, 0xEC, 0x82, 0x30,
  // "Õ" (U+00D5)
  0x38, 0x21, 0x9A, 0x52, 0x0A, 0x03, 0x60, 0xBB, 0x82, 0xDD, 0xE1, 0x58, 0x61, 0xF4, 0x18, 0xDE,
  0x57, 0x77, 0x77, 0x86, 0x4A, 0xDE, 0xEC, 0x82, 0x50, 0x9A, 0x85, 0xEB, 0xCE, 0xFE, 0x53, 0x82,
  0x8F, 0xE5, 0x40, 0x8A, 0x81, 0x30, 0x2A, 0x04, 0x68, 0x59, 0xFC, 0x07, 0xFD, 0x70, 0x2A, 0x82,
  0x2A, 0xF9, 0x71, 0x84, 0xEF, 0x5B, 0xF7, 0x71, 0x84, 0xCF, 0x7B, 0xF7, 0x71, 0x84, 0xCF, 0x7A,
  0xF9, 0x71, 0x84, 0xEF, 0x56, 0xFD, 0x70, 0x2A, 0x02, 0x01, 0xA0, 0x56, 0x81, 0x9F, 0xC2, 0x82,
  0x8F, 0xE4, 0x40, 0x8A, 0x03, 0x30, 0x9A, 0x85, 0xEB, 0xCE, 0xFE, 0x55, 0x86, 0x4A, 0xDE, 0xEC,
  0x82, 0x30,
  // "Ö" (U+00D6)
  0x48, 0x49, 0x80, 0x1A, 0x67, 0x18, 0x4D, 0xC0, 0x2E, 0x98, 0x0D, 0x50, 0x86, 0x4A, 0xDE, 0xEC,
  0x82, 0x50, 0x9A, 0x85, 0xEB, 0xCE, 0xFE, 0x53, 0x82, 0x8F, 0xE5, 0x40, 0x8A, 0x81, 0x30, 0x2A,
  0x04, 0x68, 0x59, 0xFC, 0x07, 0xFD, 0x70, 0x2A, 0x82, 0x2A, 0xF9, 0x71, 0x84, 0xEF, 0x5B, 0xF7,
  0x71, 0x84, 0xCF, 0x7B, 0xF7, 0x71, 0x84, 0xCF, 0x7A, 0xF9, 0x71, 0x84, 0xEF, 0x56, 0xFD, 0x70,
  0x2A, 0x02, 0x01, 0xA0, 0x56, 0x81, 0x9F, 0xC2, 0x82, 0x8F, 0xE4, 0x40, 0x8A, 0x03, 0x30, 0x9A,
  0x85, 0xEB, 0xCE, 0xFE, 0x55, 0x86, 0x4A, 0xDE, 0xEC, 0x82, 0x30,
  // "×" (U+00D7)
  0x10, 0x35, 0x83, 0x11, 0x6F, 0x63, 0x8A, 0x21, 0xDD, 0x1C, 0xF6, 0x02, 0xDF, 0x40, 0x1C, 0xF7,
  0xDF, 0x43, 0x01, 0x0C, 0xA0, 0x44, 0x02, 0x0D, 0xA0, 0x63, 0x8A, 0x22, 0xDF, 0x6D, 0xF6, 0x01,
  0xDF, 0x50, 0x1C, 0xF6, 0x5F, 0x53, 0x83, 0x1C, 0xB0, 0x25, 0x01, 0x10,
  // "Ø" (U+00D8)
  0x74, 0x03, 0x58, 0x90, 0x4A, 0xDE, 0xEC, 0x87, 0xF5, 0x30, 0x9A, 0x82, 0xEB, 0xCE, 0xA0, 0xC3,
  0x82, 0x8F, 0xE5, 0x30, 0x10, 0xEA, 0x81, 0x40, 0x2A, 0x04, 0x48, 0x79, 0xFD, 0xFC, 0x07, 0xFD,
  0x48, 0x24, 0xF9, 0x3A, 0x82, 0x2A, 0xF9, 0x38, 0x11, 0xED, 0x28, 0x4E, 0xF5, 0xBF, 0x73, 0x81,
  0xBF, 0x22, 0x84, 0xDF, 0x7B, 0xF8, 0x28, 0x17, 0xF6, 0x38, 0x90, 0xCF, 0x7A, 0xF9, 0x03, 0xFA,
  0x48, 0x90, 0xEF, 0x57, 0xFD, 0x1D, 0xD1, 0x30, 0x2A, 0x00, 0x2A, 0x81, 0xDF, 0x44, 0x81, 0x9F,
  0xC2, 0x09, 0xA0, 0xA4, 0x08, 0xA0, 0x32, 0x03, 0xB8, 0x5E, 0xCC, 0xEF, 0xE5, 0x38, 0x90, 0xBE,
  0x5A, 0xDE, 0xEC, 0x82, 0x40, 0x10, 0x37, 0x40,
  // "Ù" (U+00D9)
  0x48, 0x1D, 0xF9, 0x72, 0x82, 0x1C, 0xF4, 0x73, 0x81, 0xAE, 0x17, 0x77, 0x68, 0x13, 0xFE, 0x60,
  0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13,
  0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02,
  0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x02, 0xA6, 0x85, 0x3F, 0xE0, 0xEF, 0x45, 0x86, 0x7F, 0xB0, 0x9F,
  0xD3, 0x38, 0x24, 0xEF, 0x52, 0x0C, 0xA8, 0x1D, 0xBD, 0xA0, 0x84, 0x85, 0x7C, 0xEF, 0xDA, 0x42,
  // "Ú" (U+00DA)
  0x68, 0x27, 0xFD, 0x17, 0x82, 0x3F, 0xD1, 0x78, 0x21, 0xDB, 0x17, 0x77, 0x78, 0x13, 0xFE, 0x60,
  0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13,
  0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02,
  0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x02, 0xA6, 0x85, 0x3F, 0xE0, 0xEF, 0x45, 0x86, 0x7F, 0xB0, 0x9F,
  0xD3, 0x38, 0x24, 0xEF, 0x52, 0x0C, 0xA8, 0x1D, 0xBD, 0xA0, 0x84, 0x85, 0x7C, 0xEF, 0xDA, 0x42,
  // "Û" (U+00DB)
  0x48, 0x32, 0xEF, 0xD1, 0x68, 0x41, 0xDE, 0x8F, 0xB5, 0x86, 0x1C, 0xC2, 0x04, 0xDB, 0x77, 0x75,
  0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE,
  0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8,
  0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA0, 0x2A, 0x68, 0x53, 0xFE, 0x0E, 0xF4, 0x58,
  0x67, 0xFB, 0x09, 0xFD, 0x33, 0x82, 0x4E, 0xF5, 0x20, 0xCA, 0x81, 0xDB, 0xDA, 0x08, 0x48, 0x57,
  0xCE, 0xFD, 0xA4, 0x20,
  // "Ü" (U+00DC)
  0x48, 0x49, 0x80, 0x1A, 0x66, 0x84, 0xDC, 0x02, 0xE9, 0x80, 0xC2, 0x08, 0x13, 0xFE, 0x60, 0x2A,
  0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE,
  0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8,
  0x13, 0xFE, 0x60, 0x2A, 0x02, 0xA6, 0x85, 0x3F, 0xE0, 0xEF, 0x45, 0x86, 0x7F, 0xB0, 0x9F, 0xD3,
  0x38, 0x24, 0xEF, 0x52, 0x0C, 0xA8, 0x1D, 0xBD, 0xA0, 0x84, 0x85, 0x7C, 0xEF, 0xDA, 0x42,
  // "Ý" (U+00DD)
  0x68, 0x27, 0xFD, 0x17, 0x82, 0x3F, 0xD1, 0x78, 0x21, 0xDB, 0x17, 0x77, 0x78, 0x1B, 0xF9, 0x68,
  0x2D, 0xF5, 0x2A, 0x02, 0x48, 0x16, 0xFC, 0x28, 0x19, 0xFA, 0x48, 0x1E, 0xF4, 0x20, 0x1A, 0x02,
  0x28, 0x17, 0xFB, 0x48, 0x68, 0xFA, 0x01, 0xEF, 0x24, 0x85, 0x1E, 0xF3, 0x8F, 0x96, 0x84, 0x7F,
  0xCE, 0xE1, 0x70, 0xDA, 0x08, 0x71, 0x81, 0x5F, 0xE7, 0x28, 0x13, 0xFE, 0x72, 0x81, 0x3F, 0xE7,
  0x28, 0x13, 0xFE, 0x72, 0x81, 0x3F, 0xE7, 0x28, 0x13, 0xFE, 0x50,
  // "Þ" (U+00DE)
  0x01, 0xA0, 0x17, 0x01, 0xA0, 0x17, 0x01, 0xA8, 0x3B, 0xBA, 0x95, 0x30, 0x1F, 0x82, 0xD2, 0x01,
  0xA8, 0x71, 0x01, 0x4D, 0xFC, 0x01, 0xA0, 0x13, 0x03, 0xA0, 0x20, 0x1A, 0x01, 0x4A, 0x03, 0x01,
  0xA0, 0x13, 0x02, 0xA0, 0x20, 0x1A, 0x01, 0x28, 0x41, 0xBF, 0xC0, 0x1A, 0x81, 0xBB, 0xCA, 0x82,
  0xE2, 0x01, 0xC8, 0x2E, 0xC8, 0x12, 0x01, 0xA0, 0x17, 0x01, 0xA0, 0x17, 0x01, 0xA0, 0x17,
  // "ß" (U+00DF)
  0x28, 0x56, 0xBE, 0xFE, 0xB4, 0x40, 0x9A, 0x81, 0xDB, 0xDA, 0x06, 0x20, 0x2A, 0x04, 0x38, 0x18,
  0xFD, 0x28, 0x14, 0xFC, 0x48, 0x14, 0xFD, 0x28, 0x15, 0xFC, 0x38, 0x22, 0xDF, 0x52, 0x81, 0x5F,
  0xC2, 0x82, 0x3E, 0xF5, 0x38, 0x15, 0xFC, 0x28, 0x1C, 0xF5, 0x48, 0x15, 0xFC, 0x28, 0x1C, 0xF8,
  0x48, 0x15, 0xFC, 0x20, 0x4A, 0x0B, 0x02, 0x28, 0x15, 0xFC, 0x38, 0x72, 0xCF, 0xE3, 0x05, 0xFC,
  0x58, 0x58, 0xFE, 0x05, 0xFC, 0x68, 0x7E, 0xF3, 0x5F, 0xC0, 0x31, 0x20, 0x1A, 0x8A, 0x62, 0x5F,
  0xC0, 0x9F, 0xDB, 0xEF, 0xC0, 0x5F, 0xC0, 0x4B, 0xEF, 0xD8, 0x11,
  // "à" (U+00E0)
  0x38, 0x1D, 0xF9, 0x78, 0x21, 0xCF, 0x47, 0x18, 0x1A, 0xE1, 0x77, 0x85, 0x39, 0xDF, 0xEC, 0x53,
  0x83, 0xBF, 0xEC, 0xDA, 0x05, 0x20, 0x02, 0x38, 0x18, 0xFB, 0x78, 0x13, 0xFD, 0x28, 0x91, 0x16,
  0x9B, 0xBC, 0xFD, 0x04, 0xEE, 0x84, 0xD0, 0xDF, 0xB3, 0x28, 0x23, 0xFD, 0x1A, 0x02, 0x38, 0x55,
  0xFD, 0x0E, 0xF4, 0x28, 0x42, 0xDF, 0xD0, 0x9A, 0x84, 0xCC, 0xF9, 0xED, 0x28, 0x68, 0xDF, 0xD7,
  0x0B, 0xD0,
  // "á" (U+00E1)
  0x68, 0x27, 0xFD, 0x15, 0x82, 0x3F, 0xD1, 0x58, 0x21, 0xDB, 0x17, 0x78, 0x53, 0x9D, 0xFE, 0xC5,
  0x38, 0x3B, 0xFE, 0xCD, 0xA0, 0x52, 0x00, 0x23, 0x81, 0x8F, 0xB7, 0x81, 0x3F, 0xD2, 0x89, 0x11,
  0x69, 0xBB, 0xCF, 0xD0, 0x4E, 0xE8, 0x4D, 0x0D, 0xFB, 0x32, 0x82, 0x3F, 0xD1, 0xA0, 0x23, 0x85,
  0x5F, 0xD0, 0xEF, 0x42, 0x84, 0x2D, 0xFD, 0x09, 0xA8, 0x4C, 0xCF, 0x9E, 0xD2, 0x86, 0x8D, 0xFD,
  0x70, 0xBD,
  // "â" (U+00E2)
  0x38, 0x32, 0xEF, 0xD1, 0x48, 0x41, 0xDE, 0x8F, 0xB3, 0x86, 0x1C, 0xC2, 0x04, 0xDB, 0x76, 0x85,
  0x39, 0xDF, 0xEC, 0x53, 0x83, 0xBF, 0xEC, 0xDA, 0x05, 0x20, 0x02, 0x38, 0x18, 0xFB, 0x78, 0x13,
  0xFD, 0x28, 0x91, 0x16, 0x9B, 0xBC, 0xFD, 0x04, 0xEE, 0x84, 0xD0, 0xDF, 0xB3, 0x28, 0x23, 0xFD,
  0x1A, 0x02, 0x38, 0x55, 0xFD, 0x0E, 0xF4, 0x28, 0x42, 0xDF, 0xD0, 0x9A, 0x84, 0xCC, 0xF9, 0xED,
  0x28, 0x68, 0xDF, 0xD7, 0x0B, 0xD0,
  // "ã" (U+00E3)
  0x28, 0x21, 0x9A, 0x52, 0x0A, 0x03, 0x20, 0xBB, 0x89, 0x3D, 0xDE, 0x10, 0x1F, 0x41, 0x8D, 0xE5,
  0x76, 0x85, 0x39, 0xDF, 0xEC, 0x53, 0x83, 0xBF, 0xEC, 0xDA, 0x05, 0x20, 0x02, 0x38, 0x18, 0xFB,
  0x78, 0x13, 0xFD, 0x28, 0x91, 0x16, 0x9B, 0xBC, 0xFD, 0x04, 0xEE, 0x84, 0xD0, 0xDF, 0xB3, 0x28,
  0x23, 0xFD, 0x1A, 0x02, 0x38, 0x55, 0xFD, 0x0E, 0xF4, 0x28, 0x42, 0xDF, 0xD0, 0x9A, 0x84, 0xCC,
  0xF9, 0xED, 0x28, 0x68, 0xDF, 0xD7, 0x0B, 0xD0,
  // "ä" (U+00E4)
  0x38, 0x49, 0x80, 0x1A, 0x64, 0x84, 0xDC, 0x02, 0xE9, 0x77, 0x72, 0x85, 0x39, 0xDF, 0xEC, 0x53,
  0x83, 0xBF, 0xEC, 0xDA, 0x05, 0x20, 0x02, 0x38, 0x18, 0xFB, 0x78, 0x13, 0xFD, 0x28, 0x91, 0x16,
  0x9B, 0xBC, 0xFD, 0x04, 0xEE, 0x84, 0xD0, 0xDF, 0xB3, 0x28, 0x23, 0xFD, 0x1A, 0x02, 0x38, 0x55,
  0xFD, 0x0E, 0xF4, 0x28, 0x42, 0xDF, 0xD0, 0x9A, 0x84, 0xCC, 0xF9, 0xED, 0x28, 0x68, 0xDF, 0xD7,
  0x0B, 0xD0,
  // "å" (U+00E5)
  0x48, 0x26, 0xEE, 0x85, 0x84, 0x1F, 0x32, 0xE3, 0x48, 0x41, 0xF2, 0x2E, 0x35, 0x82, 0x7E, 0xE8,
  0x77, 0x85, 0x39, 0xDF, 0xEC, 0x53, 0x83, 0xBF, 0xEC, 0xDA, 0x05, 0x20, 0x02, 0x38, 0x18, 0xFB,
  0x78, 0x13, 0xFD, 0x28, 0x91, 0x16, 0x9B, 0xBC, 0xFD, 0x04, 0xEE, 0x84, 0xD0, 0xDF, 0xB3, 0x28,
  0x23, 0xFD, 0x1A, 0x02, 0x38, 0x55, 0xFD, 0x0E, 0xF4, 0x28, 0x42, 0xDF, 0xD0, 0x9A, 0x84, 0xCC,
  0xF9, 0xED, 0x28, 0x68, 0xDF, 0xD7, 0x0B, 0xD0,
  // "æ" (U+00E6)
  0x28, 0x93, 0x4A, 0xDF, 0xE9, 0x11, 0x9E, 0xEC, 0x64, 0x89, 0x1D, 0xFD, 0xBE, 0xFC, 0xDF, 0xDC,
  0xA0, 0x83, 0x03, 0x01, 0x30, 0xBA, 0x07, 0x28, 0x22, 0xEF, 0x27, 0x81, 0x7F, 0xE4, 0x81, 0x9F,
  0x72, 0x89, 0x71, 0x7A, 0xBB, 0xDF, 0xEB, 0xBB, 0xBD, 0xF9, 0x04, 0xFF, 0x84, 0x90, 0xDF, 0xB2,
  0x28, 0x17, 0xFC, 0x70, 0x1A, 0x02, 0x38, 0x19, 0xFE, 0x71, 0xA0, 0x42, 0x03, 0x0E, 0xA0, 0x94,
  0x04, 0x20, 0x9A, 0x89, 0x3C, 0xDF, 0xC2, 0xDF, 0xEC, 0xCE, 0xF1, 0x28, 0x38, 0xEF, 0xD8, 0x28,
  0x51, 0x8D, 0xFE, 0xC7, 0x10,
  // "ç" (U+00E7)
  0x28, 0x65, 0xBE, 0xED, 0x90, 0x9A, 0x86, 0xDC, 0xEC, 0x4F, 0xE4, 0x38, 0x21, 0xAF, 0x85, 0x81,
  0xDF, 0x55, 0x81, 0xEF, 0x35, 0x81, 0xDF, 0x55, 0x81, 0xBF, 0x85, 0x82, 0x6F, 0xE3, 0x38, 0x13,
  0x0B, 0xA8, 0x2D, 0xCE, 0xE2, 0x06, 0x0C, 0xA0, 0xD0, 0x74, 0x07, 0x08, 0x58, 0x21, 0xDD, 0x56,
  0x81, 0xAF, 0x13, 0x83, 0x78, 0xDF, 0x13, 0x0E, 0xA0, 0x74, 0x00, 0x23,
  // "è" (U+00E8)
  0x28, 0x1D, 0xF9, 0x78, 0x21, 0xCF, 0x47, 0x18, 0x1A, 0xE1, 0x77, 0x18, 0x45, 0xCE, 0xEB, 0x43,
  0x09, 0xA0, 0x0C, 0xA8, 0x45, 0x04, 0xFE, 0x22, 0x85, 0x5F, 0xE0, 0xAF, 0x74, 0x89, 0x4C, 0xF4,
  0xDF, 0xCB, 0xBB, 0xBE, 0xF6, 0xEF, 0x98, 0x27, 0xDF, 0x47, 0x81, 0xAF, 0x87, 0x04, 0xA0, 0x54,
  0x04, 0x20, 0x8A, 0x83, 0xDB, 0xDF, 0xE3, 0x85, 0x4B, 0xEF, 0xEB, 0x61,
  // "é" (U+00E9)
  0x58, 0x27, 0xFD, 0x15, 0x82, 0x3F, 0xD1, 0x58, 0x21, 0xDB, 0x17, 0x71, 0x84, 0x5C, 0xEE, 0xB4,
  0x30, 0x9A, 0x00, 0xCA, 0x84, 0x50, 0x4F, 0xE2, 0x28, 0x55, 0xFE, 0x0A, 0xF7, 0x48, 0x94, 0xCF,
  0x4D, 0xFC, 0xBB, 0xBB, 0xEF, 0x6E, 0xF9, 0x82, 0x7D, 0xF4, 0x78, 0x1A, 0xF8, 0x70, 0x4A, 0x05,
  0x40, 0x42, 0x08, 0xA8, 0x3D, 0xBD, 0xFE, 0x38, 0x54, 0xBE, 0xFE, 0xB6, 0x10,
  // "ê" (U+00EA)
  0x28, 0x32, 0xEF, 0xD1, 0x48, 0x41, 0xDE, 0x8F, 0xB3, 0x86, 0x1C, 0xC2, 0x04, 0xDB, 0x77, 0x84,
  0x5C, 0xEE, 0xB4, 0x30, 0x9A, 0x00, 0xCA, 0x84, 0x50, 0x4F, 0xE2, 0x28, 0x55, 0xFE, 0x0A, 0xF7,
  0x48, 0x94, 0xCF, 0x4D, 0xFC, 0xBB, 0xBB, 0xEF, 0x6E, 0xF9, 0x82, 0x7D, 0xF4, 0x78, 0x1A, 0xF8,
  0x70, 0x4A, 0x05, 0x40, 0x42, 0x08, 0xA8, 0x3D, 0xBD, 0xFE, 0x38, 0x54, 0xBE, 0xFE, 0xB6, 0x10,
  // "ë" (U+00EB)
  0x28, 0x49, 0x80, 0x1A, 0x64, 0x84, 0xDC, 0x02, 0xE9, 0x77, 0x73, 0x84, 0x5C, 0xEE, 0xB4, 0x30,
  0x9A, 0x00, 0xCA, 0x84, 0x50, 0x4F, 0xE2, 0x28, 0x55, 0xFE, 0x0A, 0xF7, 0x48, 0x94, 0xCF, 0x4D,
  0xFC, 0xBB, 0xBB, 0xEF, 0x6E, 0xF9, 0x82, 0x7D, 0xF4, 0x78, 0x1A, 0xF8, 0x70, 0x4A, 0x05, 0x40,
  0x42, 0x08, 0xA8, 0x3D, 0xBD, 0xFE, 0x38, 0x54, 0xBE, 0xFE, 0xB6, 0x10,
  // "ì" (U+00EC)
  0x81, 0xDF, 0x92, 0x82, 0x1C, 0xF4, 0x38, 0x1A, 0xE1, 0x68, 0x15, 0xFC, 0x28, 0x15, 0xFC, 0x28,
  0x15, 0xFC, 0x28, 0x15, 0xFC, 0x28, 0x15, 0xFC, 0x28, 0x15, 0xFC, 0x28, 0x15, 0xFC, 0x28, 0x15,
  0xFC, 0x28, 0x15, 0xFC, 0x28, 0x15, 0xFC, 0x28, 0x15, 0xFC, 0x10,
  // "í" (U+00ED)
  0x28, 0x94, 0x7F, 0xD1, 0x03, 0xFD, 0x10, 0x1D, 0xB1, 0x71, 0x81, 0x5F, 0xC3, 0x81, 0x5F, 0xC3,
  0x81, 0x5F, 0xC3, 0x81, 0x5F, 0xC3, 0x81, 0x5F, 0xC3, 0x81, 0x5F, 0xC3, 0x81, 0x5F, 0xC3, 0x81,
  0x5F, 0xC3, 0x81, 0x5F, 0xC3, 0x81, 0x5F, 0xC3, 0x81, 0x5F, 0xC3,
  // "î" (U+00EE)
  0x28, 0x32, 0xEF, 0xD1, 0x28, 0x95, 0x1D, 0xE8, 0xFB, 0x01, 0xCC, 0x20, 0x4D, 0xB7, 0x48, 0x15,
  0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC,
  0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x20,
  // "ï" (U+00EF)
  0x89, 0x29, 0x80, 0x1A, 0x6D, 0xC0, 0x2E, 0x97, 0x68, 0x15, 0xFC, 0x38, 0x15, 0xFC, 0x38, 0x15,
  0xFC, 0x38, 0x15, 0xFC, 0x38, 0x15, 0xFC, 0x38, 0x15, 0xFC, 0x38, 0x15, 0xFC, 0x38, 0x15, 0xFC,
  0x38, 0x15, 0xFC, 0x38, 0x15, 0xFC, 0x38, 0x15, 0xFC, 0x20,
  // "ð" (U+00F0)
  0x30, 0x43, 0x00, 0x14, 0x85, 0x3F, 0xD5, 0x6E, 0xB5, 0x06, 0x0E, 0xA0, 0xA0, 0x14, 0x02, 0x0A,
  0xB0, 0x95, 0x85, 0x8E, 0x61, 0xDF, 0x75, 0x01, 0x28, 0x22, 0xFE, 0x13, 0x86, 0x39, 0xBA, 0x69,
  0xF7, 0x20, 0x8D, 0x89, 0x2E, 0xFC, 0x05, 0xFE, 0x61, 0x15, 0xEA, 0x18, 0x1B, 0xF8, 0x40, 0x5A,
  0x82, 0x1E, 0xF4, 0x5A, 0x82, 0x2E, 0xF3, 0x40, 0x1A, 0x82, 0x1B, 0xF6, 0x48, 0x64, 0xFD, 0x06,
  0xFD, 0x22, 0x82, 0x1C, 0xF7, 0x20, 0xAA, 0x00, 0xCA, 0x0B, 0x48, 0x46, 0xCE, 0xFC, 0x73,
  // "ñ" (U+00F1)
  0x28, 0x21, 0x9A, 0x52, 0x0A, 0x03, 0x20, 0xBB, 0x89, 0x3D, 0xDE, 0x10, 0x1F, 0x41, 0x8D, 0xE5,
  0x74, 0x89, 0x75, 0xF6, 0x2A, 0xEE, 0xC5, 0x05, 0xFB, 0xEE, 0xCD, 0xA0, 0x60, 0x5A, 0x0A, 0x38,
  0x29, 0xFC, 0x5A, 0x01, 0x30, 0x3A, 0x81, 0x5F, 0xD4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A, 0x81,
  0x5F, 0xC4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A, 0x81, 0x5F, 0xC4, 0x01, 0xA8, 0x15, 0xFC, 0x40,
  0x1A, 0x81, 0x5F, 0xC4, 0x01, 0xA0,
  // "ò" (U+00F2)
  0x28, 0x1D, 0xF9, 0x71, 0x82, 0x1C, 0xF4, 0x72, 0x81, 0xAE, 0x17, 0x73, 0x84, 0x5B, 0xEE, 0xC6,
  0x40, 0x9A, 0x0D, 0x0C, 0xA0, 0xB2, 0x82, 0x4F, 0xE3, 0x28, 0x62, 0xDF, 0x70, 0xAF, 0x84, 0x85,
  0x5F, 0xD0, 0xDF, 0x54, 0x01, 0xA1, 0x81, 0xEF, 0x35, 0xA8, 0x22, 0xDF, 0x54, 0x02, 0xA8, 0x21,
  0xAF, 0x84, 0x86, 0x5F, 0xD0, 0x4F, 0xE3, 0x28, 0x22, 0xDF, 0x72, 0x08, 0xA0, 0xD0, 0xCA, 0x0B,
  0x48, 0x45, 0xBE, 0xFC, 0x73,
  // "ó" (U+00F3)
  0x58, 0x27, 0xFD, 0x16, 0x82, 0x3F, 0xD1, 0x68, 0x21, 0xDB, 0x17, 0x73, 0x84, 0x5B, 0xEE, 0xC6,
  0x40, 0x9A, 0x0D, 0x0C, 0xA0, 0xB2, 0x82, 0x4F, 0xE3, 0x28, 0x62, 0xDF, 0x70, 0xAF, 0x84, 0x85,
  0x5F, 0xD0, 0xDF, 0x54, 0x01, 0xA1, 0x81, 0xEF, 0x35, 0xA8, 0x22, 0xDF, 0x54, 0x02, 0xA8, 0x21,
  0xAF, 0x84, 0x86, 0x5F, 0xD0, 0x4F, 0xE3, 0x28, 0x22, 0xDF, 0x72, 0x08, 0xA0, 0xD0, 0xCA, 0x0B,
  0x48, 0x45, 0xBE, 0xFC, 0x73,
  // "ô" (U+00F4)
  0x38, 0x32, 0xEF, 0xD1, 0x58, 0x41, 0xDE, 0x8F, 0xB4, 0x86, 0x1C, 0xC2, 0x04, 0xDB, 0x77, 0x18,
  0x45, 0xBE, 0xEC, 0x64, 0x09, 0xA0, 0xD0, 0xCA, 0x0B, 0x28, 0x24, 0xFE, 0x32, 0x86, 0x2D, 0xF7,
  0x0A, 0xF8, 0x48, 0x55, 0xFD, 0x0D, 0xF5, 0x40, 0x1A, 0x18, 0x1E, 0xF3, 0x5A, 0x82, 0x2D, 0xF5,
  0x40, 0x2A, 0x82, 0x1A, 0xF8, 0x48, 0x65, 0xFD, 0x04, 0xFE, 0x32, 0x82, 0x2D, 0xF7, 0x20, 0x8A,
  0x0D, 0x0C, 0xA0, 0xB4, 0x84, 0x5B, 0xEF, 0xC7, 0x30,
  // "õ" (U+00F5)
  0x28, 0x21, 0x9A, 0x52, 0x0A, 0x03, 0x30, 0xBB, 0x82, 0xDD, 0xE1, 0x28, 0x61, 0xF4, 0x18, 0xDE,
  0x57, 0x71, 0x84, 0x5B, 0xEE, 0xC6, 0x40, 0x9A, 0x0D, 0x0C, 0xA0, 0xB2, 0x82, 0x4F, 0xE3, 0x28,
  0x62, 0xDF, 0x70, 0xAF, 0x84, 0x85, 0x5F, 0xD0, 0xDF, 0x54, 0x01, 0xA1, 0x81, 0xEF, 0x35, 0xA8,
  0x22, 0xDF, 0x54, 0x02, 0xA8, 0x21, 0xAF, 0x84, 0x86, 0x5F, 0xD0, 0x4F, 0xE3, 0x28, 0x22, 0xDF,
  0x72, 0x08, 0xA0, 0xD0, 0xCA, 0x0B, 0x48, 0x45, 0xBE, 0xFC, 0x73,
  // "ö" (U+00F6)
  0x28, 0x49, 0x80, 0x1A, 0x65, 0x84, 0xDC, 0x02, 0xE9, 0x77, 0x76, 0x84, 0x5B, 0xEE, 0xC6, 0x40,
  0x9A, 0x0D, 0x0C, 0xA0, 0xB2, 0x82, 0x4F, 0xE3, 0x28, 0x62, 0xDF, 0x70, 0xAF, 0x84, 0x85, 0x5F,
  0xD0, 0xDF, 0x54, 0x01, 0xA1, 0x81, 0xEF, 0x35, 0xA8, 0x22, 0xDF, 0x54, 0x02, 0xA8, 0x21, 0xAF,
  0x84, 0x86, 0x5F, 0xD0, 0x4F, 0xE3, 0x28, 0x22, 0xDF, 0x72, 0x08, 0xA0, 0xD0, 0xCA, 0x0B, 0x48,
  0x45, 0xBE, 0xFC, 0x73,
  // "÷" (U+00F7)
  0x38, 0x12, 0xC6, 0x78, 0x17, 0xFD, 0x78, 0x13, 0xE8, 0x77, 0x80, 0x5B, 0x05, 0xFA, 0x07, 0x76,
  0x81, 0x2C, 0x67, 0x81, 0x7F, 0xD7, 0x81, 0x3E, 0x84,
  // "ø" (U+00F8)
  0x71, 0x02, 0x48, 0x65, 0xBE, 0xEC, 0x7F, 0x52, 0x09, 0xA0, 0xD0, 0xCB, 0x84, 0x10, 0x4F, 0xE3,
  0x20, 0x9A, 0x83, 0x60, 0xAF, 0x82, 0x89, 0x44, 0xFC, 0xFD, 0x0D, 0xF5, 0x01, 0xEC, 0x2A, 0x86,
  0x1E, 0xF3, 0x0B, 0xE2, 0x1A, 0x87, 0x2D, 0xF4, 0x7F, 0x50, 0x1A, 0x84, 0x1A, 0xFB, 0xFA, 0x28,
  0x35, 0xFD, 0x04, 0xA0, 0xD2, 0x82, 0x2D, 0xF7, 0x20, 0xCA, 0x00, 0xCA, 0x0B, 0x28, 0x63, 0xFA,
  0xBE, 0xFC, 0x74, 0x03, 0x72,
  // "ù" (U+00F9)
  0x38, 0x1D, 0xF9, 0x78, 0x21, 0xCF, 0x47, 0x18, 0x1A, 0xE1, 0x75, 0x81, 0x6F, 0xA4, 0x84, 0x2F,
  0xE6, 0xFA, 0x48, 0x42, 0xFE, 0x6F, 0xA4, 0x84, 0x2F, 0xE6, 0xFA, 0x48, 0x42, 0xFE, 0x6F, 0xA4,
  0x84, 0x2F, 0xE6, 0xFA, 0x48, 0x43, 0xFE, 0x6F, 0xA4, 0x84, 0x4F, 0xE6, 0xFC, 0x48, 0x27, 0xFE,
  0x4A, 0x01, 0x38, 0xA5, 0xDF, 0xE0, 0xDF, 0xE9, 0x9D, 0xDF, 0xE0, 0x19, 0xDF, 0xD9, 0x1D, 0xE0,
  // "ú" (U+00FA)
  0x58, 0x27, 0xFD, 0x15, 0x82, 0x3F, 0xD1, 0x58, 0x21, 0xDB, 0x17, 0x68, 0x16, 0xFA, 0x48, 0x42,
  0xFE, 0x6F, 0xA4, 0x84, 0x2F, 0xE6, 0xFA, 0x48, 0x42, 0xFE, 0x6F, 0xA4, 0x84, 0x2F, 0xE6, 0xFA,
  0x48, 0x42, 0xFE, 0x6F, 0xA4, 0x84, 0x3F, 0xE6, 0xFA, 0x48, 0x44, 0xFE, 0x6F, 0xC4, 0x82, 0x7F,
  0xE4, 0xA0, 0x13, 0x8A, 0x5D, 0xFE, 0x0D, 0xFE, 0x99, 0xDD, 0xFE, 0x01, 0x9D, 0xFD, 0x91, 0xDE,
  // "û" (U+00FB)
  0x38, 0x32, 0xEF, 0xD1, 0x48, 0x41, 0xDE, 0x8F, 0xB3, 0x86, 0x1C, 0xC2, 0x04, 0xDB, 0x74, 0x81,
  0x6F, 0xA4, 0x84, 0x2F, 0xE6, 0xFA, 0x48, 0x42, 0xFE, 0x6F, 0xA4, 0x84, 0x2F, 0xE6, 0xFA, 0x48,
  0x42, 0xFE, 0x6F, 0xA4, 0x84, 0x2F, 0xE6, 0xFA, 0x48, 0x43, 0xFE, 0x6F, 0xA4, 0x84, 0x4F, 0xE6,
  0xFC, 0x48, 0x27, 0xFE, 0x4A, 0x01, 0x38, 0xA5, 0xDF, 0xE0, 0xDF, 0xE9, 0x9D, 0xDF, 0xE0, 0x19,
  0xDF, 0xD9, 0x1D, 0xE0,
  // "ü" (U+00FC)
  0x28, 0x49, 0x80, 0x1A, 0x64, 0x84, 0xDC, 0x02, 0xE9, 0x77, 0x71, 0x81, 0x6F, 0xA4, 0x84, 0x2F,
  0xE6, 0xFA, 0x48, 0x42, 0xFE, 0x6F, 0xA4, 0x84, 0x2F, 0xE6, 0xFA, 0x48, 0x42, 0xFE, 0x6F, 0xA4,
  0x84, 0x2F, 0xE6, 0xFA, 0x48, 0x43, 0xFE, 0x6F, 0xA4, 0x84, 0x4F, 0xE6, 0xFC, 0x48, 0x27, 0xFE,
  0x4A, 0x01, 0x38, 0xA5, 0xDF, 0xE0, 0xDF, 0xE9, 0x9D, 0xDF, 0xE0, 0x19, 0xDF, 0xD9, 0x1D, 0xE0,
  // "ý" (U+00FD)
  0x58, 0x27, 0xFD, 0x16, 0x82, 0x3F, 0xD1, 0x68, 0x21, 0xDB, 0x17, 0x71, 0x81, 0xCF, 0x75, 0x84,
  0xDF, 0x56, 0xFC, 0x48, 0x13, 0xFE, 0x28, 0x1E, 0xF2, 0x38, 0x18, 0xF9, 0x28, 0x19, 0xF8, 0x38,
  0x1D, 0xF4, 0x28, 0x13, 0xFD, 0x28, 0x13, 0xFD, 0x48, 0x5D, 0xF3, 0x09, 0xF8, 0x48, 0x57, 0xF9,
  0x0D, 0xF2, 0x48, 0x41, 0xFE, 0x3F, 0xC6, 0x83, 0xAF, 0xAF, 0x66, 0x04, 0xB0, 0x17, 0x81, 0xDF,
  0xA7, 0x18, 0x1C, 0xF4, 0x78, 0x12, 0xFE, 0x71, 0x81, 0xBF, 0x75, 0x83, 0x7B, 0xEF, 0xC6, 0x83,
  0x9F, 0xD9, 0x16,
  // "þ" (U+00FE)
  0x81, 0x5F, 0xC7, 0x18, 0x15, 0xFC, 0x71, 0x81, 0x5F, 0xC7, 0x18, 0x15, 0xFC, 0x71, 0x87, 0x5F,
  0xB2, 0xBE, 0xEB, 0x32, 0x85, 0x5F, 0xDE, 0xEC, 0xEA, 0x81, 0x30, 0x5A, 0x09, 0x38, 0x3A, 0xFC,
  0x05, 0xA4, 0x01, 0xA8, 0x22, 0x5F, 0xD5, 0x84, 0xEF, 0x45, 0xFC, 0x58, 0x4D, 0xF5, 0x5F, 0xD5,
  0x82, 0xEF, 0x45, 0xA0, 0x13, 0x02, 0xA0, 0x20, 0x5A, 0x09, 0x38, 0x91, 0xAF, 0xC0, 0x5F, 0xDF,
  0xEC, 0xEA, 0x89, 0x13, 0x05, 0xFB, 0x3B, 0xEE, 0xB3, 0x28, 0x15, 0xFC, 0x71, 0x81, 0x5F, 0xC7,
  0x18, 0x15, 0xFC, 0x71, 0x81, 0x5F, 0xC7, 0x18, 0x15, 0xFC, 0x71,
  // "ÿ" (U+00FF)
  0x28, 0x49, 0x80, 0x1A, 0x65, 0x84, 0xDC, 0x02, 0xE9, 0x77, 0x74, 0x81, 0xCF, 0x75, 0x84, 0xDF,
  0x56, 0xFC, 0x48, 0x13, 0xFE, 0x28, 0x1E, 0xF2, 0x38, 0x18, 0xF9, 0x28, 0x19, 0xF8, 0x38, 0x1D,
  0xF4, 0x28, 0x13, 0xFD, 0x28, 0x13, 0xFD, 0x48, 0x5D, 0xF3, 0x09, 0xF8, 0x48, 0x57, 0xF9, 0x0D,
  0xF2, 0x48, 0x41, 0xFE, 0x3F, 0xC6, 0x83, 0xAF, 0xAF, 0x66, 0x04, 0xB0, 0x17, 0x81, 0xDF, 0xA7,
  0x18, 0x1C, 0xF4, 0x78, 0x12, 0xFE, 0x71, 0x81, 0xBF, 0x75, 0x83, 0x7B, 0xEF, 0xC6, 0x83, 0x9F,
  0xD9, 0x16,
  // "Ā" (U+0100)
  0x30, 0x28, 0x01, 0xB0, 0xA6, 0x03, 0xD0, 0xE7, 0x77, 0x76, 0x81, 0xCF, 0xD7, 0x20, 0x2B, 0x03,
  0x71, 0x83, 0x8F, 0xAF, 0x97, 0x18, 0x3E, 0xF1, 0xEE, 0x78, 0x55, 0xFB, 0x09, 0xF6, 0x68, 0x5B,
  0xF5, 0x04, 0xFC, 0x58, 0x11, 0xFE, 0x38, 0x1D, 0xF2, 0x48, 0x17, 0xF9, 0x38, 0x17, 0xF8, 0x40,
  0xDF, 0x0E, 0x30, 0x4A, 0x80, 0x1D, 0xA0, 0x52, 0x81, 0xAF, 0x85, 0x83, 0x7F, 0xB0, 0x1A, 0x02,
  0x50, 0x2A, 0x82, 0x16, 0xFC, 0x78, 0x4B, 0xF7, 0xCF, 0x67, 0x81, 0x6F, 0xD0,
  // "ā" (U+0101)
  0x20, 0x28, 0x01, 0xB0, 0xA3, 0x03, 0xD0, 0xE7, 0x68, 0x53, 0x9D, 0xFE, 0xC5, 0x38, 0x3B, 0xFE,
  0xCD, 0xA0, 0x52, 0x00, 0x23, 0x81, 0x8F, 0xB7, 0x81, 0x3F, 0xD2, 0x89, 0x11, 0x69, 0xBB, 0xCF,
  0xD0, 0x4E, 0xE8, 0x4D, 0x0D, 0xFB, 0x32, 0x82, 0x3F, 0xD1, 0xA0, 0x23, 0x85, 0x5F, 0xD0, 0xEF,
  0x42, 0x84, 0x2D, 0xFD, 0x09, 0xA8, 0x4C, 0xCF, 0x9E, 0xD2, 0x86, 0x8D, 0xFD, 0x70, 0xBD,
  // "Ă" (U+0102)
  0x28, 0x11, 0xF3, 0x28, 0x11, 0xE5, 0x68, 0x4B, 0xEC, 0xCF, 0xD7, 0x84, 0x1A, 0xEE, 0xB2, 0x77,
  0x77, 0x78, 0x1C, 0xFD, 0x72, 0x02, 0xB0, 0x37, 0x18, 0x38, 0xFA, 0xF9, 0x71, 0x83, 0xEF, 0x1E,
  0xE7, 0x85, 0x5F, 0xB0, 0x9F, 0x66, 0x85, 0xBF, 0x50, 0x4F, 0xC5, 0x81, 0x1F, 0xE3, 0x81, 0xDF,
  0x24, 0x81, 0x7F, 0x93, 0x81, 0x7F, 0x84, 0x0D, 0xF0, 0xE3, 0x04, 0xA8, 0x01, 0xDA, 0x05, 0x28,
  0x1A, 0xF8, 0x58, 0x37, 0xFB, 0x01, 0xA0, 0x25, 0x02, 0xA8, 0x21, 0x6F, 0xC7, 0x84, 0xBF, 0x7C,
  0xF6, 0x78, 0x16, 0xFD,
  // "ă" (U+0103)
  0x28, 0x11, 0xF3, 0x28, 0x11, 0xE5, 0x38, 0x4B, 0xEC, 0xCF, 0xD4, 0x84, 0x1A, 0xEE, 0xB2, 0x76,
  0x85, 0x39, 0xDF, 0xEC, 0x53, 0x83, 0xBF, 0xEC, 0xDA, 0x05, 0x20, 0x02, 0x38, 0x18, 0xFB, 0x78,
  0x13, 0xFD, 0x28, 0x91, 0x16, 0x9B, 0xBC, 0xFD, 0x04, 0xEE, 0x84, 0xD0, 0xDF, 0xB3, 0x28, 0x23,
  0xFD, 0x1A, 0x02, 0x38, 0x55, 0xFD, 0x0E, 0xF4, 0x28, 0x42, 0xDF, 0xD0, 0x9A, 0x84, 0xCC, 0xF9,
  0xED, 0x28, 0x68, 0xDF, 0xD7, 0x0B, 0xD0,
  // "Ą" (U+0104)
  0x58, 0x1C, 0xFD, 0x73, 0x02, 0xB0, 0x37, 0x28, 0x38, 0xFA, 0xF9, 0x72, 0x83, 0xEF, 0x1E, 0xE7,
  0x18, 0x55, 0xFB, 0x09, 0xF6, 0x78, 0x5B, 0xF5, 0x04, 0xFC, 0x68, 0x11, 0xFE, 0x38, 0x1D, 0xF2,
  0x58, 0x17, 0xF9, 0x38, 0x17, 0xF8, 0x50, 0xDF, 0x0E, 0x40, 0x4A, 0x80, 0x1D, 0xA0, 0x53, 0x81,
  0xAF, 0x85, 0x81, 0x7F, 0xB2, 0x01, 0xA0, 0x25, 0x02, 0xA8, 0x31, 0x06, 0xFC, 0x78, 0x5B, 0xF7,
  0x0C, 0xF6, 0x70, 0x8A, 0x74, 0x0C, 0x0A, 0x74, 0x81, 0x2F, 0x77, 0x48, 0x31, 0xFE, 0xB3, 0x73,
  0x82, 0x7E, 0xE3,
  // "ą" (U+0105)
  0x28, 0x53, 0x9D, 0xFE, 0xC5, 0x48, 0x3B, 0xFE, 0xCD, 0xA0, 0x53, 0x00, 0x23, 0x81, 0x8F, 0xB7,
  0x18, 0x13, 0xFD, 0x38, 0x61, 0x69, 0xBB, 0xCF, 0xD2, 0x04, 0x0E, 0xE0, 0xD2, 0x82, 0xDF, 0xB3,
  0x28, 0x33, 0xFD, 0x01, 0xA0, 0x23, 0x81, 0x5F, 0xD2, 0x81, 0xEF, 0x42, 0x82, 0x2D, 0xFD, 0x20,
  0x9A, 0x84, 0xCC, 0xF9, 0xFD, 0x38, 0x48, 0xDF, 0xD7, 0x2A, 0x71, 0x0C, 0x0A, 0x71, 0x81, 0x2F,
  0x77, 0x18, 0x31, 0xFE, 0xB3, 0x78, 0x27, 0xEE, 0x30,
  // "Ć" (U+0106)
  0x68, 0x27, 0xFD, 0x16, 0x82, 0x3F, 0xD1, 0x68, 0x21, 0xDB, 0x17, 0x77, 0x78, 0x62, 0x8C, 0xEE,
  0xDA, 0x52, 0x07, 0xA8, 0x6E, 0xCB, 0xEF, 0xB0, 0x6A, 0x07, 0x48, 0x44, 0x31, 0xEF, 0x67, 0x81,
  0x6F, 0xD7, 0x18, 0x1A, 0xF9, 0x71, 0x81, 0xBF, 0x77, 0x18, 0x1B, 0xF7, 0x71, 0x81, 0xAF, 0x97,
  0x18, 0x17, 0xFD, 0x71, 0x02, 0xA0, 0x57, 0x18, 0x28, 0xFE, 0x54, 0x00, 0x12, 0x0A, 0xA8, 0x4E,
  0xBC, 0xDF, 0x73, 0x81, 0x4A, 0xDA, 0x81, 0xDA, 0x30,
  // "ć" (U+0107)
  0x58, 0x27, 0xFD, 0x14, 0x82, 0x3F, 0xD1, 0x48, 0x21, 0xDB, 0x17, 0x68, 0x45, 0xBE, 0xED, 0x92,
  0x09, 0xA8, 0x7D, 0xCE, 0xC0, 0x4F, 0xE4, 0x38, 0x31, 0x0A, 0xF8, 0x68, 0x1D, 0xF5, 0x68, 0x1E,
  0xF3, 0x68, 0x1D, 0xF5, 0x68, 0x1B, 0xF8, 0x68, 0x26, 0xFE, 0x33, 0x03, 0x20, 0xBA, 0x82, 0xDC,
  0xEE, 0x30, 0x60, 0xCA, 0x0D, 0x07, 0x10,
  // "Ĉ" (U+0108)
  0x48, 0x32, 0xEF, 0xD1, 0x58, 0x41, 0xDE, 0x8F, 0xB4, 0x86, 0x1C, 0xC2, 0x04, 0xDB, 0x77, 0x75,
  0x86, 0x28, 0xCE, 0xED, 0xA5, 0x20, 0x7A, 0x86, 0xEC, 0xBE, 0xFB, 0x06, 0xA0, 0x74, 0x84, 0x43,
  0x1E, 0xF6, 0x78, 0x16, 0xFD, 0x71, 0x81, 0xAF, 0x97, 0x18, 0x1B, 0xF7, 0x71, 0x81, 0xBF, 0x77,
  0x18, 0x1A, 0xF9, 0x71, 0x81, 0x7F, 0xD7, 0x10, 0x2A, 0x05, 0x71, 0x82, 0x8F, 0xE5, 0x40, 0x01,
  0x20, 0xAA, 0x84, 0xEB, 0xCD, 0xF7, 0x38, 0x14, 0xAD, 0xA8, 0x1D, 0xA3,
  // "ĉ" (U+0109)
  0x28, 0x32, 0xEF, 0xD1, 0x28, 0x95, 0x1D, 0xE8, 0xFB, 0x01, 0xCC, 0x20, 0x4D, 0xB7, 0x38, 0x65,
  0xBE, 0xED, 0x90, 0x9A, 0x86, 0xDC, 0xEC, 0x4F, 0xE4, 0x38, 0x21, 0xAF, 0x85, 0x81, 0xDF, 0x55,
  0x81, 0xEF, 0x35, 0x81, 0xDF, 0x55, 0x81, 0xBF, 0x85, 0x82, 0x6F, 0xE3, 0x38, 0x13, 0x0B, 0xA8,
  0x2D, 0xCE, 0xE2, 0x06, 0x0C, 0xA0, 0xD0, 0x70,
  // "Ċ" (U+010A)
  0x58, 0x21, 0xEE, 0x17, 0x82, 0x1D, 0xD1, 0x77, 0x76, 0x86, 0x28, 0xCE, 0xED, 0xA5, 0x20, 0x7A,
  0x86, 0xEC, 0xBE, 0xFB, 0x06, 0xA0, 0x74, 0x84, 0x43, 0x1E, 0xF6, 0x78, 0x16, 0xFD, 0x71, 0x81,
  0xAF, 0x97, 0x18, 0x1B, 0xF7, 0x71, 0x81, 0xBF, 0x77, 0x18, 0x1A, 0xF9, 0x71, 0x81, 0x7F, 0xD7,
  0x10, 0x2A, 0x05, 0x71, 0x82, 0x8F, 0xE5, 0x40, 0x01, 0x20, 0xAA, 0x84, 0xEB, 0xCD, 0xF7, 0x38,
  0x14, 0xAD, 0xA8, 0x1D, 0xA3,
  // "ċ" (U+010B)
  0x38, 0x21, 0xEE, 0x14, 0x82, 0x1D, 0xD1, 0x74, 0x86, 0x5B, 0xEE, 0xD9, 0x09, 0xA8, 0x6D, 0xCE,
  0xC4, 0xFE, 0x43, 0x82, 0x1A, 0xF8, 0x58, 0x1D, 0xF5, 0x58, 0x1E, 0xF3, 0x58, 0x1D, 0xF5, 0x58,
  0x1B, 0xF8, 0x58, 0x26, 0xFE, 0x33, 0x81, 0x30, 0xBA, 0x82, 0xDC, 0xEE, 0x20, 0x60, 0xCA, 0x0D,
  0x07,
  // "Č" (U+010C)
  0x28, 0x61, 0xDC, 0x20, 0x3D, 0xB4, 0x84, 0x1D, 0xE8, 0xFB, 0x68, 0x32, 0xEF, 0xD1, 0x77, 0x76,
  0x86, 0x28, 0xCE, 0xED, 0xA5, 0x20, 0x7A, 0x86, 0xEC, 0xBE, 0xFB, 0x06, 0xA0, 0x74, 0x84, 0x43,
  0x1E, 0xF6, 0x78, 0x16, 0xFD, 0x71, 0x81, 0xAF, 0x97, 0x18, 0x1B, 0xF7, 0x71, 0x81, 0xBF, 0x77,
  0x18, 0x1A, 0xF9, 0x71, 0x81, 0x7F, 0xD7, 0x10, 0x2A, 0x05, 0x71, 0x82, 0x8F, 0xE5, 0x40, 0x01,
  0x20, 0xAA, 0x84, 0xEB, 0xCD, 0xF7, 0x38, 0x14, 0xAD, 0xA8, 0x1D, 0xA3,
  // "č" (U+010D)
  0x89, 0x51, 0xDC, 0x20, 0x3D, 0xB0, 0x1D, 0xE8, 0xFB, 0x38, 0x32, 0xEF, 0xD1, 0x74, 0x86, 0x5B,
  0xEE, 0xD9, 0x09, 0xA8, 0x6D, 0xCE, 0xC4, 0xFE, 0x43, 0x82, 0x1A, 0xF8, 0x58, 0x1D, 0xF5, 0x58,
  0x1E, 0xF3, 0x58, 0x1D, 0xF5, 0x58, 0x1B, 0xF8, 0x58, 0x26, 0xFE, 0x33, 0x81, 0x30, 0xBA, 0x82,
  0xDC, 0xEE, 0x20, 0x60, 0xCA, 0x0D, 0x07,
  // "Ď" (U+010E)
  0x28, 0x61, 0xDC, 0x20, 0x3D, 0xB6, 0x84, 0x1D, 0xE8, 0xFB, 0x71, 0x83, 0x2E, 0xFD, 0x17, 0x77,
  0x72, 0x01, 0xD8, 0x1D, 0xB6, 0x40, 0x1A, 0x0F, 0xB0, 0xDA, 0x0D, 0x03, 0x20, 0x1A, 0x01, 0x38,
  0x52, 0xAF, 0xE2, 0x01, 0xA0, 0x15, 0x83, 0xBF, 0xB0, 0x1A, 0x01, 0x50, 0x3A, 0x00, 0x1A, 0x01,
  0x68, 0x2E, 0xF4, 0x1A, 0x01, 0x68, 0x2C, 0xF6, 0x1A, 0x01, 0x68, 0x2D, 0xF6, 0x1A, 0x01, 0x68,
  0x2E, 0xF4, 0x1A, 0x01, 0x50, 0x3A, 0x00, 0x1A, 0x01, 0x58, 0x3C, 0xFA, 0x01, 0xA0, 0x13, 0x85,
  0x3C, 0xFE, 0x20, 0x1A, 0x82, 0xBB, 0xCE, 0xA0, 0xD0, 0x32, 0x01, 0xC8, 0x2E, 0xDA, 0x54,
  // "ď" (U+010F)
  0x78, 0x55, 0xFB, 0x0B, 0xF3, 0x78, 0x45, 0xFB, 0x0E, 0xC7, 0x18, 0x45, 0xFB, 0x3F, 0x37, 0x18,
  0x15, 0xFB, 0x68, 0x68, 0xDF, 0xD7, 0x5F, 0xB5, 0x0C, 0xA8, 0x4C, 0xCF, 0xCF, 0xB4, 0x82, 0x6F,
  0xE2, 0x28, 0x23, 0xEF, 0xB4, 0x81, 0xBF, 0x84, 0x81, 0x9F, 0xB4, 0x81, 0xDF, 0x54, 0x81, 0x6F,
  0xB4, 0x81, 0xEF, 0x34, 0x81, 0x4F, 0xB4, 0x81, 0xDF, 0x44, 0x81, 0x5F, 0xB4, 0x81, 0xBF, 0x84,
  0x81, 0x8F, 0xB4, 0x82, 0x6F, 0xE3, 0x28, 0x23, 0xEF, 0xB5, 0x0C, 0xA8, 0x4C, 0xCF, 0xBF, 0xB5,
  0x87, 0x18, 0xDF, 0xD6, 0x0F, 0xB4,
  // "Đ" (U+0110)
  0x2D, 0x81, 0xDB, 0x66, 0xA8, 0x2C, 0xBB, 0xDA, 0x0D, 0x03, 0x4A, 0x02, 0x38, 0x32, 0xBF, 0xE2,
  0x3A, 0x02, 0x58, 0x1B, 0xFB, 0x3A, 0x02, 0x50, 0x3A, 0x01, 0x2A, 0x02, 0x68, 0x2E, 0xF4, 0x6E,
  0x05, 0x38, 0x3C, 0xF6, 0x5B, 0xA8, 0x2C, 0xBB, 0x43, 0x81, 0xDF, 0x62, 0xA0, 0x26, 0x81, 0xEF,
  0x42, 0xA0, 0x25, 0x03, 0xA0, 0x12, 0xA0, 0x25, 0x81, 0xCF, 0xA3, 0xA0, 0x23, 0x83, 0x3C, 0xFE,
  0x23, 0xA8, 0x2C, 0xBC, 0xEA, 0x0D, 0x02, 0x4C, 0x82, 0xED, 0xA5, 0x40,
  // "đ" (U+0111)
  0x78, 0x15, 0xFB, 0x58, 0x73, 0xBB, 0xBC, 0xFE, 0xB3, 0x30, 0x4F, 0x04, 0x78, 0x15, 0xFB, 0x48,
  0x68, 0xDF, 0xD6, 0x5F, 0xB3, 0x0C, 0xA8, 0x4C, 0xCF, 0xCF, 0xB2, 0x82, 0x6F, 0xE2, 0x28, 0x23,
  0xEF, 0xB2, 0x81, 0xBF, 0x84, 0x81, 0x9F, 0xB2, 0x81, 0xDF, 0x54, 0x81, 0x6F, 0xB2, 0x81, 0xEF,
  0x34, 0x81, 0x4F, 0xB2, 0x81, 0xDF, 0x44, 0x81, 0x5F, 0xB2, 0x81, 0xBF, 0x84, 0x81, 0x8F, 0xB2,
  0x82, 0x6F, 0xE3, 0x28, 0x23, 0xEF, 0xB3, 0x0C, 0xA8, 0x4C, 0xCF, 0xBF, 0xB3, 0x87, 0x18, 0xDF,
  0xD6, 0x0F, 0xB2,
  // "Ē" (U+0112)
  0x10, 0x28, 0x01, 0xB0, 0xA2, 0x03, 0xD0, 0xE7, 0x75, 0x01, 0xF0, 0xE0, 0x1A, 0x80, 0x1B, 0x0A,
  0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01, 0xF0, 0x90, 0x1A,
  0x80, 0x1B, 0x06, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x15, 0x01,
  0xA8, 0x01, 0xB0, 0xA0, 0x1F, 0x0E,
  // "ē" (U+0113)
  0x10, 0x28, 0x01, 0xB0, 0xA3, 0x03, 0xD0, 0xE7, 0x78, 0x45, 0xCE, 0xEB, 0x43, 0x09, 0xA0, 0x0C,
  0xA8, 0x45, 0x04, 0xFE, 0x22, 0x85, 0x5F, 0xE0, 0xAF, 0x74, 0x89, 0x4C, 0xF4, 0xDF, 0xCB, 0xBB,
  0xBE, 0xF6, 0xEF, 0x98, 0x27, 0xDF, 0x47, 0x81, 0xAF, 0x87, 0x04, 0xA0, 0x54, 0x04, 0x20, 0x8A,
  0x83, 0xDB, 0xDF, 0xE3, 0x85, 0x4B, 0xEF, 0xEB, 0x61,
  // "Ĕ" (U+0114)
  0x18, 0x11, 0xF3, 0x28, 0x11, 0xE5, 0x28, 0x4B, 0xEC, 0xCF, 0xD3, 0x84, 0x1A, 0xEE, 0xB2, 0x77,
  0x50, 0x1F, 0x0E, 0x01, 0xA8, 0x01, 0xB0, 0xA0, 0x1A, 0x01, 0x50, 0x1A, 0x01, 0x50, 0x1A, 0x01,
  0x50, 0x1A, 0x01, 0x50, 0x1F, 0x09, 0x01, 0xA8, 0x01, 0xB0, 0x60, 0x1A, 0x01, 0x50, 0x1A, 0x01,
  0x50, 0x1A, 0x01, 0x50, 0x1A, 0x01, 0x50, 0x1A, 0x80, 0x1B, 0x0A, 0x01, 0xF0, 0xE0,
  // "ĕ" (U+0115)
  0x18, 0x11, 0xF3, 0x28, 0x11, 0xE5, 0x38, 0x4B, 0xEC, 0xCF, 0xD4, 0x84, 0x1A, 0xEE, 0xB2, 0x77,
  0x84, 0x5C, 0xEE, 0xB4, 0x30, 0x9A, 0x00, 0xCA, 0x84, 0x50, 0x4F, 0xE2, 0x28, 0x55, 0xFE, 0x0A,
  0xF7, 0x48, 0x94, 0xCF, 0x4D, 0xFC, 0xBB, 0xBB, 0xEF, 0x6E, 0xF9, 0x82, 0x7D, 0xF4, 0x78, 0x1A,
  0xF8, 0x70, 0x4A, 0x05, 0x40, 0x42, 0x08, 0xA8, 0x3D, 0xBD, 0xFE, 0x38, 0x54, 0xBE, 0xFE, 0xB6,
  0x10,
  // "Ė" (U+0116)
  0x38, 0x21, 0xEE, 0x15, 0x82, 0x1D, 0xD1, 0x77, 0x60, 0x1F, 0x0E, 0x01, 0xA8, 0x01, 0xB0, 0xA0,
  0x1A, 0x01, 0x50, 0x1A, 0x01, 0x50, 0x1A, 0x01, 0x50, 0x1A, 0x01, 0x50, 0x1F, 0x09, 0x01, 0xA8,
  0x01, 0xB0, 0x60, 0x1A, 0x01, 0x50, 0x1A, 0x01, 0x50, 0x1A, 0x01, 0x50, 0x1A, 0x01, 0x50, 0x1A,
  0x80, 0x1B, 0x0A, 0x01, 0xF0, 0xE0,
  // "ė" (U+0117)
  0x38, 0x21, 0xEE, 0x16, 0x82, 0x1D, 0xD1, 0x77, 0x18, 0x45, 0xCE, 0xEB, 0x43, 0x09, 0xA0, 0x0C,
  0xA8, 0x45, 0x04, 0xFE, 0x22, 0x85, 0x5F, 0xE0, 0xAF, 0x74, 0x89, 0x4C, 0xF4, 0xDF, 0xCB, 0xBB,
  0xBE, 0xF6, 0xEF, 0x98, 0x27, 0xDF, 0x47, 0x81, 0xAF, 0x87, 0x04, 0xA0, 0x54, 0x04, 0x20, 0x8A,
  0x83, 0xDB, 0xDF, 0xE3, 0x85, 0x4B, 0xEF, 0xEB, 0x61,
  // "Ę" (U+0118)
  0x01, 0xF8, 0x1E, 0x01, 0xA8, 0x01, 0xB8, 0x1A, 0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA0,
  0x16, 0x01, 0xA0, 0x16, 0x01, 0xF8, 0x19, 0x01, 0xA8, 0x01, 0xB8, 0x16, 0x01, 0xA0, 0x16, 0x01,
  0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA8, 0x00, 0xB8, 0x2C, 0xB0, 0x1F, 0x97,
  0x0C, 0x0A, 0x78, 0x12, 0xF7, 0x78, 0x31, 0xFE, 0xB3, 0x68, 0x27, 0xEE, 0x30,
  // "ę" (U+0119)
  0x28, 0x45, 0xCE, 0xEB, 0x33, 0x09, 0xA0, 0xC0, 0xDA, 0x81, 0x30, 0x4A, 0x04, 0x28, 0x57, 0xFD,
  0x0A, 0xF9, 0x48, 0x4E, 0xF3, 0xDF, 0x54, 0x82, 0xBF, 0x5E, 0xF9, 0x82, 0x6D, 0xFC, 0x80, 0x2B,
  0x82, 0x5A, 0xF6, 0x78, 0x24, 0xFD, 0x24, 0x02, 0x20, 0x8A, 0x83, 0xDB, 0xCE, 0xE3, 0x81, 0x4B,
  0xEB, 0x0A, 0x70, 0x0B, 0x78, 0x16, 0xF1, 0x70, 0xA9, 0x71, 0x82, 0x8F, 0xD9, 0x68, 0x21, 0xCF,
  0xA1,
  // "Ě" (U+011A)
  0x18, 0x61, 0xDC, 0x20, 0x3D, 0xB2, 0x84, 0x1D, 0xE8, 0xFB, 0x48, 0x32, 0xEF, 0xD1, 0x77, 0x50,
  0x1F, 0x0E, 0x01, 0xA8, 0x01, 0xB0, 0xA0, 0x1A, 0x01, 0x50, 0x1A, 0x01, 0x50, 0x1A, 0x01, 0x50,
  0x1A, 0x01, 0x50, 0x1F, 0x09, 0x01, 0xA8, 0x01, 0xB0, 0x60, 0x1A, 0x01, 0x50, 0x1A, 0x01, 0x50,
  0x1A, 0x01, 0x50, 0x1A, 0x01, 0x50, 0x1A, 0x80, 0x1B, 0x0A, 0x01, 0xF0, 0xE0,
  // "ě" (U+011B)
  0x86, 0x1D, 0xC2, 0x03, 0xDB, 0x38, 0x41, 0xDE, 0x8F, 0xB5, 0x83, 0x2E, 0xFD, 0x17, 0x71, 0x84,
  0x5C, 0xEE, 0xB4, 0x30, 0x9A, 0x00, 0xCA, 0x84, 0x50, 0x4F, 0xE2, 0x28, 0x55, 0xFE, 0x0A, 0xF7,
  0x48, 0x94, 0xCF, 0x4D, 0xFC, 0xBB, 0xBB, 0xEF, 0x6E, 0xF9, 0x82, 0x7D, 0xF4, 0x78, 0x1A, 0xF8,
  0x70, 0x4A, 0x05, 0x40, 0x42, 0x08, 0xA8, 0x3D, 0xBD, 0xFE, 0x38, 0x54, 0xBE, 0xFE, 0xB6, 0x10,
  // "Ĝ" (U+011C)
  0x58, 0x32, 0xEF, 0xD1, 0x68, 0x41, 0xDE, 0x8F, 0xB5, 0x86, 0x1C, 0xC2, 0x04, 0xDB, 0x77, 0x77,
  0x87, 0x17, 0xBD, 0xFE, 0xC9, 0x42, 0x05, 0x0E, 0xA8, 0x1D, 0xBD, 0xA8, 0x18, 0x05, 0xA0, 0x90,
  0x14, 0x84, 0x51, 0x0E, 0xF8, 0x71, 0x81, 0x6F, 0xE7, 0x28, 0x19, 0xF9, 0x72, 0x81, 0xBF, 0x73,
  0x01, 0x80, 0x2B, 0x90, 0x73, 0x02, 0xD8, 0x1A, 0xF9, 0x60, 0x1A, 0x81, 0x7F, 0xD6, 0x01, 0xA0,
  0x1A, 0x06, 0x50, 0x1A, 0x10, 0x8A, 0x07, 0x40, 0x1A, 0x20, 0x9A, 0x83, 0xEC, 0xBC, 0xEA, 0x38,
  0x13, 0xAD, 0xA8, 0x2E, 0xDA, 0x60,
  // "ĝ" (U+011D)
  0x38, 0x32, 0xEF, 0xD1, 0x48, 0x41, 0xDE, 0x8F, 0xB3, 0x86, 0x1C, 0xC2, 0x04, 0xDB, 0x76, 0x89,
  0x08, 0xDF, 0xD6, 0x1F, 0xB0, 0xBA, 0x89, 0x0C, 0xDF, 0xBF, 0xB5, 0xFE, 0x32, 0x85, 0x3E, 0xFB,
  0xBF, 0x84, 0x84, 0x8F, 0xBD, 0xF5, 0x48, 0x45, 0xFB, 0xEF, 0x34, 0x84, 0x4F, 0xBD, 0xF4, 0x48,
  0x45, 0xFB, 0xBF, 0x84, 0x85, 0x8F, 0xB6, 0xFE, 0x32, 0x84, 0x2E, 0xFB, 0x0C, 0xA8, 0x96, 0xCC,
  0xFC, 0xFB, 0x01, 0x8D, 0xFD, 0x65, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x39, 0xF9, 0x15, 0x40, 0x3A,
  0x85, 0x52, 0xFE, 0xCB, 0xCA, 0x89, 0x0B, 0x01, 0x8C, 0xEF, 0xEC, 0x72,
  // "Ğ" (U+011E)
  0x38, 0x11, 0xF3, 0x28, 0x11, 0xE5, 0x58, 0x4B, 0xEC, 0xCF, 0xD6, 0x84, 0x1A, 0xEE, 0xB2, 0x77,
  0x77, 0x18, 0x71, 0x7B, 0xDF, 0xEC, 0x94, 0x20, 0x50, 0xEA, 0x81, 0xDB, 0xDA, 0x81, 0x80, 0x5A,
  0x09, 0x01, 0x48, 0x45, 0x10, 0xEF, 0x87, 0x18, 0x16, 0xFE, 0x72, 0x81, 0x9F, 0x97, 0x28, 0x1B,
  0xF7, 0x30, 0x18, 0x02, 0xB9, 0x07, 0x30, 0x2D, 0x81, 0xAF, 0x96, 0x01, 0xA8, 0x17, 0xFD, 0x60,
  0x1A, 0x01, 0xA0, 0x65, 0x01, 0xA1, 0x08, 0xA0, 0x74, 0x01, 0xA2, 0x09, 0xA8, 0x3E, 0xCB, 0xCE,
  0xA3, 0x81, 0x3A, 0xDA, 0x82, 0xED, 0xA6,
  // "ğ" (U+011F)
  0x18, 0x11, 0xF3, 0x28, 0x11, 0xE5, 0x38, 0x4B, 0xEC, 0xCF, 0xD4, 0x84, 0x1A, 0xEE, 0xB2, 0x77,
  0x89, 0x08, 0xDF, 0xD6, 0x1F, 0xB0, 0xBA, 0x89, 0x0C, 0xDF, 0xBF, 0xB5, 0xFE, 0x32, 0x85, 0x3E,
  0xFB, 0xBF, 0x84, 0x84, 0x8F, 0xBD, 0xF5, 0x48, 0x45, 0xFB, 0xEF, 0x34, 0x84, 0x4F, 0xBD, 0xF4,
  0x48, 0x45, 0xFB, 0xBF, 0x84, 0x85, 0x8F, 0xB6, 0xFE, 0x32, 0x84, 0x2E, 0xFB, 0x0C, 0xA8, 0x96,
  0xCC, 0xFC, 0xFB, 0x01, 0x8D, 0xFD, 0x65, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x39, 0xF9, 0x15, 0x40,
  0x3A, 0x85, 0x52, 0xFE, 0xCB, 0xCA, 0x89, 0x0B, 0x01, 0x8C, 0xEF, 0xEC, 0x72,
  // "Ġ" (U+0120)
  0x58, 0x21, 0xEE, 0x17, 0x18, 0x21, 0xDD, 0x17, 0x77, 0x72, 0x87, 0x17, 0xBD, 0xFE, 0xC9, 0x42,
  0x05, 0x0E, 0xA8, 0x1D, 0xBD, 0xA8, 0x18, 0x05, 0xA0, 0x90, 0x14, 0x84, 0x51, 0x0E, 0xF8, 0x71,
  0x81, 0x6F, 0xE7, 0x28, 0x19, 0xF9, 0x72, 0x81, 0xBF, 0x73, 0x01, 0x80, 0x2B, 0x90, 0x73, 0x02,
  0xD8, 0x1A, 0xF9, 0x60, 0x1A, 0x81, 0x7F, 0xD6, 0x01, 0xA0, 0x1A, 0x06, 0x50, 0x1A, 0x10, 0x8A,
  0x07, 0x40, 0x1A, 0x20, 0x9A, 0x83, 0xEC, 0xBC, 0xEA, 0x38, 0x13, 0xAD, 0xA8, 0x2E, 0xDA, 0x60,
  // "ġ" (U+0121)
  0x38, 0x21, 0xEE, 0x16, 0x82, 0x1D, 0xD1, 0x77, 0x18, 0x90, 0x8D, 0xFD, 0x61, 0xFB, 0x0B, 0xA8,
  0x90, 0xCD, 0xFB, 0xFB, 0x5F, 0xE3, 0x28, 0x53, 0xEF, 0xBB, 0xF8, 0x48, 0x48, 0xFB, 0xDF, 0x54,
  0x84, 0x5F, 0xBE, 0xF3, 0x48, 0x44, 0xFB, 0xDF, 0x44, 0x84, 0x5F, 0xBB, 0xF8, 0x48, 0x58, 0xFB,
  0x6F, 0xE3, 0x28, 0x42, 0xEF, 0xB0, 0xCA, 0x89, 0x6C, 0xCF, 0xCF, 0xB0, 0x18, 0xDF, 0xD6, 0x5F,
  0xB7, 0x81, 0x6F, 0xB7, 0x83, 0x9F, 0x91, 0x54, 0x03, 0xA8, 0x55, 0x2F, 0xEC, 0xBC, 0xA8, 0x90,
  0xB0, 0x18, 0xCE, 0xFE, 0xC7, 0x20,
  // "Ģ" (U+0122)
  0x38, 0x71, 0x7B, 0xDF, 0xEC, 0x94, 0x20, 0x50, 0xEA, 0x81, 0xDB, 0xDA, 0x81, 0x80, 0x5A, 0x09,
  0x01, 0x48, 0x45, 0x10, 0xEF, 0x87, 0x18, 0x16, 0xFE, 0x72, 0x81, 0x9F, 0x97, 0x28, 0x1B, 0xF7,
  0x30, 0x18, 0x02, 0xB9, 0x07, 0x30, 0x2D, 0x81, 0xAF, 0x96, 0x01, 0xA8, 0x17, 0xFD, 0x60, 0x1A,
  0x01, 0xA0, 0x65, 0x01, 0xA1, 0x08, 0xA0, 0x74, 0x01, 0xA2, 0x09, 0xA8, 0x3E, 0xCB, 0xCE, 0xA3,
  0x81, 0x3A, 0xDA, 0x82, 0xED, 0xA6, 0x77, 0x77, 0x28, 0x1C, 0xF3, 0x72, 0x90, 0xB7, 0x28, 0x15,
  0xE1, 0x40,
  // "ģ" (U+0123)
  0x48, 0x12, 0xF4, 0x70, 0xC0, 0xE7, 0x81, 0x4F, 0xB7, 0x72, 0x89, 0x08, 0xDF, 0xD6, 0x1F, 0xB0,
  0xBA, 0x89, 0x0C, 0xDF, 0xBF, 0xB5, 0xFE, 0x32, 0x85, 0x3E, 0xFB, 0xBF, 0x84, 0x84, 0x8F, 0xBD,
  0xF5, 0x48, 0x45, 0xFB, 0xEF, 0x34, 0x84, 0x4F, 0xBD, 0xF4, 0x48, 0x45, 0xFB, 0xBF, 0x84, 0x85,
  0x8F, 0xB6, 0xFE, 0x32, 0x84, 0x2E, 0xFB, 0x0C, 0xA8, 0x96, 0xCC, 0xFC, 0xFB, 0x01, 0x8D, 0xFD,
  0x65, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x39, 0xF9, 0x15, 0x40, 0x3A, 0x85, 0x52, 0xFE, 0xCB, 0xCA,
  0x89, 0x0B, 0x01, 0x8C, 0xEF, 0xEC, 0x72,
  // "Ĥ" (U+0124)
  0x48, 0x32, 0xEF, 0xD1, 0x68, 0x41, 0xDE, 0x8F, 0xB5, 0x86, 0x1C, 0xC2, 0x04, 0xDB, 0x77, 0x75,
  0x01, 0xA0, 0x15, 0x01, 0xA0, 0x1A, 0x01, 0x50, 0x1A, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x1A, 0x01,
  0x50, 0x1A, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x1A, 0x01, 0x50, 0x1A, 0x01, 0xFC, 0x01, 0xA8, 0x03,
  0xBA, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x1A, 0x01, 0x50, 0x1A, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x1A,
  0x01, 0x50, 0x1A, 0x01, 0xA0, 0x15, 0x01, 0xA0, 0x1A, 0x01, 0x50, 0x1A,
  // "ĥ" (U+0125)
  0x28, 0x32, 0xEF, 0xD1, 0x78, 0x41, 0xDE, 0x8F, 0xB6, 0x86, 0x1C, 0xC2, 0x04, 0xDB, 0x77, 0x78,
  0x15, 0xFC, 0x73, 0x81, 0x5F, 0xC7, 0x38, 0x15, 0xFC, 0x73, 0x81, 0x5F, 0xC7, 0x38, 0x75, 0xFB,
  0x2A, 0xEE, 0xC5, 0x48, 0x55, 0xFC, 0xEE, 0xBD, 0xA0, 0x53, 0x05, 0xA0, 0x93, 0x81, 0x9F, 0xC3,
  0x05, 0xA0, 0x13, 0x03, 0xA3, 0x81, 0x5F, 0xD4, 0x01, 0xA3, 0x81, 0x5F, 0xC4, 0x01, 0xA3, 0x81,
  0x5F, 0xC4, 0x01, 0xA3, 0x81, 0x5F, 0xC4, 0x01, 0xA3, 0x81, 0x5F, 0xC4, 0x01, 0xA3, 0x81, 0x5F,
  0xC4, 0x01, 0xA3, 0x81, 0x5F, 0xC4, 0x01, 0xA0,
  // "Ħ" (U+0126)
  0x10, 0x1A, 0x01, 0x50, 0x1A, 0x30, 0x1A, 0x01, 0x50, 0x1A, 0x2F, 0xF8, 0x1E, 0xBB, 0xA8, 0x03,
  0xBA, 0x82, 0xBA, 0x01, 0xA0, 0x15, 0x01, 0xA3, 0x01, 0xA0, 0x15, 0x01, 0xA3, 0x01, 0xFC, 0x30,
  0x1A, 0x80, 0x3B, 0xA3, 0x01, 0xA0, 0x15, 0x01, 0xA3, 0x01, 0xA0, 0x15, 0x01, 0xA3, 0x01, 0xA0,
  0x15, 0x01, 0xA3, 0x01, 0xA0, 0x15, 0x01, 0xA3, 0x01, 0xA0, 0x15, 0x01, 0xA3, 0x01, 0xA0, 0x15,
  0x01, 0xA2,
  // "ħ" (U+0127)
  0x18, 0x15, 0xFC, 0x78, 0x69, 0xCF, 0xEB, 0xBB, 0x73, 0x0D, 0xE0, 0xA4, 0x81, 0x5F, 0xC7, 0x18,
  0x75, 0xFB, 0x2A, 0xEE, 0xC4, 0x28, 0x55, 0xFC, 0xEE, 0xBD, 0xA8, 0x15, 0x05, 0xA0, 0xA3, 0x83,
  0xAF, 0xC0, 0x5A, 0x02, 0x38, 0x53, 0xFE, 0x05, 0xFD, 0x40, 0x1A, 0x18, 0x15, 0xFC, 0x40, 0x1A,
  0x18, 0x15, 0xFC, 0x40, 0x1A, 0x18, 0x15, 0xFC, 0x40, 0x1A, 0x18, 0x15, 0xFC, 0x40, 0x1A, 0x18,
  0x15, 0xFC, 0x40, 0x1A, 0x18, 0x15, 0xFC, 0x40, 0x1A,
  // "Ĩ" (U+0128)
  0x18, 0x21, 0x9A, 0x52, 0x82, 0xA3, 0x0B, 0xB8, 0x92, 0xDD, 0xE1, 0x1F, 0x41, 0x8D, 0xE5, 0x77,
  0x60, 0x3D, 0x04, 0x28, 0x51, 0x8D, 0xFE, 0x81, 0x48, 0x18, 0xF9, 0x68, 0x18, 0xF9, 0x68, 0x18,
  0xF9, 0x68, 0x18, 0xF9, 0x68, 0x18, 0xF9, 0x68, 0x18, 0xF9, 0x68, 0x18, 0xF9, 0x68, 0x18, 0xF9,
  0x68, 0x18, 0xF9, 0x68, 0x18, 0xF9, 0x58, 0x46, 0xCF, 0xD6, 0x12, 0x03, 0xD0, 0x41,
  // "ĩ" (U+0129)
  0x18, 0x21, 0x9A, 0x52, 0x82, 0xA3, 0x0B, 0xB8, 0x92, 0xDD, 0xE1, 0x1F, 0x41, 0x8D, 0xE5, 0x76,
  0x81, 0x5F, 0xC6, 0x81, 0x5F, 0xC6, 0x81, 0x5F, 0xC6, 0x81, 0x5F, 0xC6, 0x81, 0x5F, 0xC6, 0x81,
  0x5F, 0xC6, 0x81, 0x5F, 0xC6, 0x81, 0x5F, 0xC6, 0x81, 0x5F, 0xC6, 0x81, 0x5F, 0xC6, 0x81, 0x5F,
  0xC3,
  // "Ī" (U+012A)
  0x02, 0x80, 0x1B, 0x0A, 0x03, 0xD0, 0xE7, 0x70, 0x3D, 0x86, 0x41, 0x8D, 0xFE, 0x81, 0x28, 0x18,
  0xF9, 0x48, 0x18, 0xF9, 0x48, 0x18, 0xF9, 0x48, 0x18, 0xF9, 0x48, 0x18, 0xF9, 0x48, 0x18, 0xF9,
  0x48, 0x18, 0xF9, 0x48, 0x18, 0xF9, 0x48, 0x18, 0xF9, 0x48, 0x18, 0xF9, 0x38, 0x56, 0xCF, 0xD6,
  0x13, 0xD0, 0x40,
  // "ī" (U+012B)
  0x02, 0x80, 0x1B, 0x0A, 0x03, 0xD0, 0xE7, 0x28, 0x15, 0xFC, 0x48, 0x15, 0xFC, 0x48, 0x15, 0xFC,
  0x48, 0x15, 0xFC, 0x48, 0x15, 0xFC, 0x48, 0x15, 0xFC, 0x48, 0x15, 0xFC, 0x48, 0x15, 0xFC, 0x48,
  0x15, 0xFC, 0x48, 0x15, 0xFC, 0x48, 0x15, 0xFC, 0x20,
  // "Ĭ" (U+012C)
  0x81, 0x1F, 0x32, 0x89, 0x01, 0xE5, 0x0B, 0xEC, 0xCF, 0xD2, 0x84, 0x1A, 0xEE, 0xB2, 0x77, 0x30,
  0x3D, 0x87, 0x40, 0x18, 0xDF, 0xE8, 0x13, 0x81, 0x8F, 0x95, 0x81, 0x8F, 0x95, 0x81, 0x8F, 0x95,
  0x81, 0x8F, 0x95, 0x81, 0x8F, 0x95, 0x81, 0x8F, 0x95, 0x81, 0x8F, 0x95, 0x81, 0x8F, 0x95, 0x81,
  0x8F, 0x95, 0x81, 0x8F, 0x94, 0x86, 0x6C, 0xFD, 0x61, 0x03, 0xD0, 0x41,
  // "ĭ" (U+012D)
  0x81, 0x1F, 0x32, 0x89, 0x01, 0xE5, 0x0B, 0xEC, 0xCF, 0xD2, 0x84, 0x1A, 0xEE, 0xB2, 0x74, 0x81,
  0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F,
  0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC3,
  // "Į" (U+012E)
  0x03, 0xD8, 0x64, 0x18, 0xDF, 0xE8, 0x12, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94,
  0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81, 0x8F, 0x94, 0x81,
  0x8F, 0x94, 0x81, 0x8F, 0x93, 0x85, 0x6C, 0xFE, 0x71, 0x3D, 0x04, 0x30, 0xC0, 0xA4, 0x81, 0x2F,
  0x74, 0x83, 0x1F, 0xEB, 0x33, 0x82, 0x7E, 0xE3,
  // "į" (U+012F)
  0x18, 0x14, 0xEA, 0x28, 0x15, 0xFC, 0x30, 0x17, 0x18, 0x15, 0xFC, 0x28, 0x15, 0xFC, 0x28, 0x15,
  0xFC, 0x28, 0x15, 0xFC, 0x28, 0x15, 0xFC, 0x28, 0x15, 0xFC, 0x28, 0x15, 0xFC, 0x28, 0x15, 0xFC,
  0x28, 0x15, 0xFC, 0x28, 0x15, 0xFC, 0x20, 0x7A, 0x20, 0xC0, 0xA2, 0x81, 0x2F, 0x72, 0x89, 0x01,
  0xFE, 0xB3, 0x07, 0xEE, 0x30,
  // "İ" (U+0130)
  0x28, 0x21, 0xEE, 0x13, 0x82, 0x1D, 0xD1, 0x77, 0x10, 0x3D, 0x86, 0x41, 0x8D, 0xFE, 0x81, 0x28,
  0x18, 0xF9, 0x48, 0x18, 0xF9, 0x48, 0x18, 0xF9, 0x48, 0x18, 0xF9, 0x48, 0x18, 0xF9, 0x48, 0x18,
  0xF9, 0x48, 0x18, 0xF9, 0x48, 0x18, 0xF9, 0x48, 0x18, 0xF9, 0x48, 0x18, 0xF9, 0x38, 0x56, 0xCF,
  0xD6, 0x13, 0xD0, 0x40,
  // "ı" (U+0131)
  0x8B, 0x75, 0xFC, 0x5F, 0xC5, 0xFC, 0x5F, 0xC5, 0xFC, 0x5F, 0xC5, 0xFC, 0x5F, 0xC5, 0xFC, 0x5F,
  0xC5, 0xFC,
  // "Ĳ" (U+0132)
  0x03, 0xD8, 0x14, 0x02, 0xA8, 0x71, 0x8D, 0xFE, 0x81, 0x02, 0xA2, 0x81, 0x8F, 0x93, 0x02, 0xA2,
  0x81, 0x8F, 0x93, 0x02, 0xA2, 0x81, 0x8F, 0x93, 0x02, 0xA2, 0x81, 0x8F, 0x93, 0x02, 0xA2, 0x81,
  0x8F, 0x93, 0x02, 0xA2, 0x81, 0x8F, 0x93, 0x02, 0xA2, 0x81, 0x8F, 0x93, 0x02, 0xA2, 0x81, 0x8F,
  0x93, 0x02, 0xA2, 0x81, 0x8F, 0x93, 0x02, 0xA2, 0x81, 0x8F, 0x93, 0x02, 0xA1, 0x86, 0x6C, 0xFD,
  0x61, 0x02, 0xA0, 0x3D, 0x81, 0x40, 0x2A, 0x71, 0x81, 0x3F, 0xE7, 0x18, 0x19, 0xFB, 0x58, 0x17,
  0xBD, 0xA0, 0x35, 0x83, 0x7E, 0xEB, 0x41,
  // "ĳ" (U+0133)
  0x81, 0x4E, 0xA2, 0x84, 0x4E, 0xA5, 0xFC, 0x28, 0x35, 0xFC, 0x01, 0x40, 0x17, 0x28, 0x15, 0xFC,
  0x28, 0x45, 0xFC, 0x5F, 0xC2, 0x84, 0x5F, 0xC5, 0xFC, 0x28, 0x45, 0xFC, 0x5F, 0xC2, 0x84, 0x5F,
  0xC5, 0xFC, 0x28, 0x45, 0xFC, 0x5F, 0xC2, 0x84, 0x5F, 0xC5, 0xFC, 0x28, 0x45, 0xFC, 0x5F, 0xC2,
  0x84, 0x5F, 0xC5, 0xFC, 0x28, 0x45, 0xFC, 0x5F, 0xC2, 0x84, 0x5F, 0xC5, 0xFC, 0x28, 0x15, 0xFC,
  0x58, 0x15, 0xFC, 0x58, 0x15, 0xFB, 0x58, 0x18, 0xFA, 0x28, 0x12, 0xCC, 0xA0, 0x42, 0x83, 0x1E,
  0xFD, 0x61,
  // "Ĵ" (U+0134)
  0x38, 0x32, 0xEF, 0xD1, 0x38, 0x41, 0xDE, 0x8F, 0xB2, 0x86, 0x1C, 0xC2, 0x04, 0xDB, 0x77, 0x70,
  0x2A, 0x60, 0x2A, 0x60, 0x2A, 0x60, 0x2A, 0x60, 0x2A, 0x60, 0x2A, 0x60, 0x2A, 0x60, 0x2A, 0x60,
  0x2A, 0x60, 0x2A, 0x60, 0x2A, 0x60, 0x2A, 0x60, 0x2A, 0x60, 0x2A, 0x68, 0x13, 0xFE, 0x68, 0x19,
  0xFB, 0x38, 0x17, 0xBD, 0xA0, 0x33, 0x83, 0x7E, 0xEB, 0x44,
  // "ĵ" (U+0135)
  0x28, 0x32, 0xEF, 0xD1, 0x28, 0x95, 0x1D, 0xE8, 0xFB, 0x01, 0xCC, 0x20, 0x4D, 0xB7, 0x48, 0x15,
  0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC,
  0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58,
  0x15, 0xFC, 0x58, 0x15, 0xFB, 0x58, 0x18, 0xFA, 0x28, 0x12, 0xCC, 0xA0, 0x42, 0x83, 0x1E, 0xFD,
  0x63,
  // "Ķ" (U+0136)
  0x01, 0xA0, 0x14, 0x83, 0x6F, 0xE2, 0x1A, 0x01, 0x38, 0x44, 0xFE, 0x30, 0x1A, 0x01, 0x28, 0x23,
  0xEF, 0x42, 0x01, 0xA8, 0x41, 0x02, 0xEF, 0x63, 0x01, 0xA8, 0x31, 0x1D, 0xF7, 0x40, 0x1A, 0x82,
  0x1B, 0xF9, 0x50, 0x1A, 0x0A, 0xA0, 0x45, 0x01, 0xB8, 0x2D, 0xFD, 0x14, 0x01, 0xA8, 0x36, 0x0D,
  0xFA, 0x40, 0x1A, 0x81, 0x10, 0x2A, 0x06, 0x30, 0x1A, 0x01, 0x28, 0x26, 0xFE, 0x22, 0x01, 0xA0,
  0x13, 0x81, 0xAF, 0xC2, 0x01, 0xA0, 0x13, 0x84, 0x1D, 0xF8, 0x01, 0xA0, 0x14, 0x03, 0xA0, 0x47,
  0x77, 0x71, 0x81, 0xCF, 0x37, 0x29, 0x0B, 0x72, 0x81, 0x5E, 0x15,
  // "ķ" (U+0137)
  0x81, 0x5F, 0xB7, 0x81, 0x5F, 0xB7, 0x81, 0x5F, 0xB7, 0x81, 0x5F, 0xB7, 0x81, 0x5F, 0xB3, 0x85,
  0x3E, 0xF5, 0x5F, 0xB2, 0x89, 0x32, 0xEF, 0x60, 0x5F, 0xB0, 0x1D, 0xF7, 0x28, 0x55, 0xFB, 0x0C,
  0xF8, 0x38, 0x45, 0xFB, 0xAF, 0xA4, 0x81, 0x5F, 0xEA, 0x0E, 0x01, 0x30, 0x5A, 0x82, 0x8B, 0xFB,
  0x38, 0x65, 0xFC, 0x01, 0xEF, 0x72, 0x81, 0x5F, 0xB2, 0x04, 0xA8, 0x33, 0x05, 0xFB, 0x38, 0x58,
  0xFD, 0x15, 0xFB, 0x48, 0x1C, 0xFA, 0x77, 0x73, 0x81, 0xCF, 0x37, 0x90, 0xB7, 0x81, 0x5E, 0x14,
  // "ĸ" (U+0138)
  0x81, 0x5F, 0xD3, 0x85, 0x2E, 0xF5, 0x5F, 0xD2, 0x86, 0x1D, 0xF7, 0x05, 0xFD, 0x28, 0x1B, 0xFA,
  0x28, 0x55, 0xFC, 0x09, 0xFC, 0x38, 0x55, 0xFC, 0x6F, 0xD1, 0x38, 0x15, 0xFD, 0xA0, 0xE0, 0x13,
  0x05, 0xA8, 0x2C, 0xAF, 0xB3, 0x81, 0x5F, 0xD2, 0x81, 0xDF, 0x72, 0x81, 0x5F, 0xD2, 0x03, 0xA8,
  0x33, 0x05, 0xFD, 0x38, 0x57, 0xFD, 0x15, 0xFD, 0x48, 0x1B, 0xFA,
  // "Ĺ" (U+0139)
  0x28, 0x27, 0xFD, 0x15, 0x82, 0x3F, 0xD1, 0x58, 0x21, 0xDB, 0x17, 0x77, 0x50, 0x1A, 0x01, 0x60,
  0x1A, 0x01, 0x60, 0x1A, 0x01, 0x60, 0x1A, 0x01, 0x60, 0x1A, 0x01, 0x60, 0x1A, 0x01, 0x60, 0x1A,
  0x01, 0x60, 0x1A, 0x01, 0x60, 0x1A, 0x01, 0x60, 0x1A, 0x01, 0x60, 0x1A, 0x01, 0x60, 0x1A, 0x01,
  0x60, 0x1A, 0x80, 0x2D, 0x02, 0x01, 0xF9, 0x02,
  // "ĺ" (U+013A)
  0x28, 0x94, 0x7F, 0xD1, 0x03, 0xFD, 0x10, 0x1D, 0xB1, 0x71, 0x81, 0x5F, 0xC3, 0x81, 0x5F, 0xC3,
  0x81, 0x5F, 0xC3, 0x81, 0x5F, 0xC3, 0x81, 0x5F, 0xC3, 0x81, 0x5F, 0xC3, 0x81, 0x5F, 0xC3, 0x81,
  0x5F, 0xC3, 0x81, 0x5F, 0xC3, 0x81, 0x5F, 0xC3, 0x81, 0x5F, 0xC3, 0x81, 0x5F, 0xC3, 0x81, 0x5F,
  0xC3, 0x81, 0x5F, 0xC3, 0x81, 0x5F, 0xC3,
  // "Ļ" (U+013B)
  0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01,
  0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA0,
  0x16, 0x01, 0xA0, 0x16, 0x01, 0xA8, 0x02, 0xD0, 0x20, 0x1F, 0x90, 0x27, 0x77, 0x38, 0x1C, 0xF3,
  0x79, 0x0B, 0x78, 0x15, 0xE1, 0x40,
  // "ļ" (U+013C)
  0x8F, 0x15, 0xFC, 0x05, 0xFC, 0x05, 0xFC, 0x05, 0xFC, 0x05, 0xFC, 0x05, 0xFC, 0x05, 0xFC, 0x05,
  0xFC, 0x05, 0xFC, 0x05, 0xFC, 0x05, 0xFC, 0x05, 0xFC, 0x05, 0xFC, 0x05, 0xFC, 0x05, 0xFC, 0x73,
  0x89, 0x0C, 0xF3, 0x0F, 0xB0, 0x5E, 0x11,
  // "Ľ" (U+013D)
  0x01, 0xA0, 0x13, 0x82, 0xBF, 0x31, 0xA0, 0x13, 0x82, 0xEC, 0x01, 0xA0, 0x12, 0x83, 0x3F, 0x30,
  0x1A, 0x01, 0x60, 0x1A, 0x01, 0x60, 0x1A, 0x01, 0x60, 0x1A, 0x01, 0x60, 0x1A, 0x01, 0x60, 0x1A,
  0x01, 0x60, 0x1A, 0x01, 0x60, 0x1A, 0x01, 0x60, 0x1A, 0x01, 0x60, 0x1A, 0x80, 0x2D, 0x02, 0x01,
  0xF9, 0x02,
  // "ľ" (U+013E)
  0x8A, 0x65, 0xFC, 0x0B, 0xF3, 0x5F, 0xC0, 0xEC, 0x05, 0xFC, 0x3F, 0x30, 0x5F, 0xC4, 0x81, 0x5F,
  0xC4, 0x81, 0x5F, 0xC4, 0x81, 0x5F, 0xC4, 0x81, 0x5F, 0xC4, 0x81, 0x5F, 0xC4, 0x81, 0x5F, 0xC4,
  0x81, 0x5F, 0xC4, 0x81, 0x5F, 0xC4, 0x81, 0x5F, 0xC4, 0x81, 0x5F, 0xC4, 0x81, 0x5F, 0xC4,
  // "Ŀ" (U+013F)
  0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01,
  0xA0, 0x16, 0x01, 0xA8, 0x61, 0x01, 0xEE, 0x10, 0x1A, 0x86, 0x10, 0x1D, 0xD1, 0x01, 0xA0, 0x16,
  0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA0, 0x16, 0x01, 0xA8, 0x02, 0xD0, 0x20, 0x1F, 0x90,
  0x20,
  // "ŀ" (U+0140)
  0x81, 0x5F, 0xC4, 0x81, 0x5F, 0xC4, 0x81, 0x5F, 0xC4, 0x81, 0x5F, 0xC4, 0x81, 0x5F, 0xC4, 0x81,
  0x5F, 0xC4, 0x81, 0x5F, 0xC4, 0x89, 0x75, 0xFC, 0x1E, 0xE1, 0x5F, 0xC1, 0xDD, 0x15, 0xFC, 0x48,
  0x15, 0xFC, 0x48, 0x15, 0xFC, 0x48, 0x15, 0xFC, 0x48, 0x15, 0xFC, 0x48, 0x15, 0xFC, 0x40,
  // "Ł" (U+0141)
  0x10, 0x1A, 0x01, 0x70, 0x1A, 0x01, 0x70, 0x1A, 0x01, 0x70, 0x1A, 0x01, 0x70, 0x1A, 0x81, 0x10,
  0x15, 0x01, 0xA8, 0x14, 0xBD, 0x50, 0x1C, 0x08, 0x50, 0x7A, 0x0A, 0x02, 0x50, 0x9B, 0x01, 0x60,
  0x20, 0x7A, 0x01, 0x70, 0x1A, 0x01, 0x70, 0x1A, 0x01, 0x70, 0x1A, 0x80, 0x2D, 0x81, 0x20, 0x1F,
  0x90, 0x20,
  // "ł" (U+0142)
  0x18, 0x16, 0xFA, 0x38, 0x16, 0xFA, 0x38, 0x16, 0xFA, 0x38, 0x16, 0xFA, 0x38, 0x16, 0xFA, 0x38,
  0x26, 0xFA, 0x12, 0x85, 0x6F, 0xDE, 0x40, 0x7A, 0x81, 0xC2, 0x9A, 0x0B, 0x28, 0x2C, 0xEF, 0xA2,
  0x82, 0x16, 0xFA, 0x38, 0x16, 0xFA, 0x38, 0x16, 0xFA, 0x38, 0x16, 0xFA, 0x38, 0x16, 0xFA, 0x20,
  // "Ń" (U+0143)
  0x78, 0x27, 0xFD, 0x17, 0x18, 0x23, 0xFD, 0x17, 0x18, 0x21, 0xDB, 0x17, 0x77, 0x72, 0x01, 0xA0,
  0xC6, 0x82, 0x5F, 0x91, 0xB0, 0x65, 0x82, 0x5F, 0x91, 0xB0, 0xE0, 0x14, 0x87, 0x5F, 0x91, 0xFB,
  0xBF, 0xA4, 0x85, 0x5F, 0x91, 0xFC, 0x2A, 0x05, 0x38, 0x90, 0x5F, 0x91, 0xFC, 0x07, 0xFD, 0x38,
  0x45, 0xF9, 0x1F, 0xD2, 0x81, 0xCF, 0x82, 0x84, 0x5F, 0x91, 0xFD, 0x20, 0x3A, 0x86, 0x30, 0x5F,
  0x91, 0xFD, 0x38, 0x90, 0x8F, 0xC0, 0x5F, 0x91, 0xFD, 0x48, 0x7D, 0xF7, 0x5F, 0x91, 0xFD, 0x48,
  0x73, 0xFE, 0x6F, 0x91, 0xFD, 0x58, 0x69, 0xFE, 0xF9, 0x1F, 0xD5, 0x01, 0x0D, 0xA8, 0x29, 0x1F,
  0xD6, 0x05, 0xA0, 0x90,
  // "ń" (U+0144)
  0x58, 0x27, 0xFD, 0x15, 0x82, 0x3F, 0xD1, 0x58, 0x21, 0xDB, 0x17, 0x68, 0x97, 0x5F, 0x62, 0xAE,
  0xEC, 0x50, 0x5F, 0xBE, 0xEC, 0xDA, 0x06, 0x05, 0xA0, 0xA3, 0x82, 0x9F, 0xC5, 0xA0, 0x13, 0x03,
  0xA8, 0x15, 0xFD, 0x40, 0x1A, 0x81, 0x5F, 0xC4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A, 0x81, 0x5F,
  0xC4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A, 0x81, 0x5F, 0xC4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A,
  // "Ņ" (U+0145)
  0x01, 0xA0, 0xC6, 0x82, 0x5F, 0x91, 0xB0, 0x65, 0x82, 0x5F, 0x91, 0xB0, 0xE0, 0x14, 0x87, 0x5F,
  0x91, 0xFB, 0xBF, 0xA4, 0x85, 0x5F, 0x91, 0xFC, 0x2A, 0x05, 0x38, 0x90, 0x5F, 0x91, 0xFC, 0x07,
  0xFD, 0x38, 0x45, 0xF9, 0x1F, 0xD2, 0x81, 0xCF, 0x82, 0x84, 0x5F, 0x91, 0xFD, 0x20, 0x3A, 0x86,
  0x30, 0x5F, 0x91, 0xFD, 0x38, 0x90, 0x8F, 0xC0, 0x5F, 0x91, 0xFD, 0x48, 0x7D, 0xF7, 0x5F, 0x91,
  0xFD, 0x48, 0x73, 0xFE, 0x6F, 0x91, 0xFD, 0x58, 0x69, 0xFE, 0xF9, 0x1F, 0xD5, 0x01, 0x0D, 0xA8,
  0x29, 0x1F, 0xD6, 0x05, 0xA0, 0x97, 0x77, 0x74, 0x81, 0xCF, 0x37, 0x39, 0x0B, 0x73, 0x81, 0x5E,
  0x15,
  // "ņ" (U+0146)
  0x89, 0x75, 0xF6, 0x2A, 0xEE, 0xC5, 0x05, 0xFB, 0xEE, 0xCD, 0xA0, 0x60, 0x5A, 0x0A, 0x38, 0x29,
  0xFC, 0x5A, 0x01, 0x30, 0x3A, 0x81, 0x5F, 0xD4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A, 0x81, 0x5F,
  0xC4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A, 0x81, 0x5F, 0xC4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A,
  0x81, 0x5F, 0xC4, 0x01, 0xA7, 0x77, 0x38, 0x1C, 0xF3, 0x79, 0x0B, 0x78, 0x15, 0xE1, 0x40,
  // "Ň" (U+0147)
  0x28, 0x61, 0xDC, 0x20, 0x3D, 0xB6, 0x84, 0x1D, 0xE8, 0xFB, 0x71, 0x83, 0x2E, 0xFD, 0x17, 0x77,
  0x72, 0x01, 0xA0, 0xC6, 0x82, 0x5F, 0x91, 0xB0, 0x65, 0x82, 0x5F, 0x91, 0xB0, 0xE0, 0x14, 0x87,
  0x5F, 0x91, 0xFB, 0xBF, 0xA4, 0x85, 0x5F, 0x91, 0xFC, 0x2A, 0x05, 0x38, 0x90, 0x5F, 0x91, 0xFC,
  0x07, 0xFD, 0x38, 0x45, 0xF9, 0x1F, 0xD2, 0x81, 0xCF, 0x82, 0x84, 0x5F, 0x91, 0xFD, 0x20, 0x3A,
  0x86, 0x30, 0x5F, 0x91, 0xFD, 0x38, 0x90, 0x8F, 0xC0, 0x5F, 0x91, 0xFD, 0x48, 0x7D, 0xF7, 0x5F,
  0x91, 0xFD, 0x48, 0x73, 0xFE, 0x6F, 0x91, 0xFD, 0x58, 0x69, 0xFE, 0xF9, 0x1F, 0xD5, 0x01, 0x0D,
  0xA8, 0x29, 0x1F, 0xD6, 0x05, 0xA0, 0x90,
  // "ň" (U+0148)
  0x18, 0x61, 0xDC, 0x20, 0x3D, 0xB3, 0x84, 0x1D, 0xE8, 0xFB, 0x58, 0x32, 0xEF, 0xD1, 0x75, 0x89,
  0x75, 0xF6, 0x2A, 0xEE, 0xC5, 0x05, 0xFB, 0xEE, 0xCD, 0xA0, 0x60, 0x5A, 0x0A, 0x38, 0x29, 0xFC,
  0x5A, 0x01, 0x30, 0x3A, 0x81, 0x5F, 0xD4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A, 0x81, 0x5F, 0xC4,
  0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A, 0x81, 0x5F, 0xC4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A, 0x81,
  0x5F, 0xC4, 0x01, 0xA0,
  // "ŉ" (U+0149)
  0x18, 0x1D, 0xF6, 0x73, 0xA0, 0x17, 0x28, 0x13, 0xFC, 0x73, 0x8A, 0x56, 0xF6, 0x5F, 0x62, 0xAE,
  0xEC, 0x50, 0xAE, 0x05, 0xFB, 0xEE, 0xCD, 0xA0, 0x63, 0x05, 0xA0, 0xA3, 0x81, 0x9F, 0xC3, 0x05,
  0xA0, 0x13, 0x03, 0xA3, 0x81, 0x5F, 0xD4, 0x01, 0xA3, 0x81, 0x5F, 0xC4, 0x01, 0xA3, 0x81, 0x5F,
  0xC4, 0x01, 0xA3, 0x81, 0x5F, 0xC4, 0x01, 0xA3, 0x81, 0x5F, 0xC4, 0x01, 0xA3, 0x81, 0x5F, 0xC4,
  0x01, 0xA3, 0x81, 0x5F, 0xC4, 0x01, 0xA0,
  // "Ŋ" (U+014A)
  0x01, 0xA0, 0xC6, 0x82, 0x5F, 0x91, 0xB0, 0x75, 0x84, 0x5F, 0x91, 0xFD, 0xA0, 0x34, 0x87, 0x5F,
  0x91, 0xFB, 0x7F, 0xC4, 0x89, 0x05, 0xF9, 0x1F, 0xC0, 0xCF, 0x83, 0x86, 0x5F, 0x91, 0xFD, 0x02,
  0xA0, 0x32, 0x84, 0x5F, 0x91, 0xFD, 0x28, 0x17, 0xFD, 0x28, 0x45, 0xF9, 0x1F, 0xD3, 0x89, 0x0B,
  0xF8, 0x05, 0xF9, 0x1F, 0xD3, 0x89, 0x02, 0xEF, 0x35, 0xF9, 0x1F, 0xD4, 0x87, 0x6F, 0xD5, 0xF9,
  0x1F, 0xD5, 0x86, 0xBF, 0xCF, 0x91, 0xFD, 0x50, 0x10, 0xEA, 0x82, 0x91, 0xFD, 0x60, 0x5A, 0x82,
  0x91, 0xFD, 0x78, 0x1A, 0xF9, 0x73, 0x81, 0x6F, 0x87, 0x84, 0x10, 0x3D, 0xF5, 0x7C, 0x0B, 0x71,
  0x82, 0x9B, 0x95, 0x20,
  // "ŋ" (U+014B)
  0x89, 0x75, 0xF6, 0x2A, 0xEE, 0xC5, 0x05, 0xFC, 0xEE, 0xBD, 0xA0, 0x60, 0x5A, 0x09, 0x38, 0x29,
  0xFC, 0x5A, 0x01, 0x30, 0x3A, 0x81, 0x5F, 0xD4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A, 0x81, 0x5F,
  0xC4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A, 0x81, 0x5F, 0xC4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A,
  0x81, 0x5F, 0xC4, 0x01, 0xA7, 0x01, 0xA7, 0x01, 0xA7, 0x81, 0x4F, 0xD5, 0x83, 0x7B, 0xEF, 0x95,
  0x82, 0x7F, 0xE9, 0x10,
  // "Ō" (U+014C)
  0x30, 0x28, 0x01, 0xB0, 0xA7, 0x03, 0xD0, 0xE7, 0x77, 0x77, 0x86, 0x4A, 0xDE, 0xEC, 0x82, 0x50,
  0x9A, 0x85, 0xEB, 0xCE, 0xFE, 0x53, 0x82, 0x8F, 0xE5, 0x40, 0x8A, 0x81, 0x30, 0x2A, 0x04, 0x68,
  0x59, 0xFC, 0x07, 0xFD, 0x70, 0x2A, 0x82, 0x2A, 0xF9, 0x71, 0x84, 0xEF, 0x5B, 0xF7, 0x71, 0x84,
  0xCF, 0x7B, 0xF7, 0x71, 0x84, 0xCF, 0x7A, 0xF9, 0x71, 0x84, 0xEF, 0x56, 0xFD, 0x70, 0x2A, 0x02,
  0x01, 0xA0, 0x56, 0x81, 0x9F, 0xC2, 0x82, 0x8F, 0xE4, 0x40, 0x8A, 0x03, 0x30, 0x9A, 0x85, 0xEB,
  0xCE, 0xFE, 0x55, 0x86, 0x4A, 0xDE, 0xEC, 0x82, 0x30,
  // "ō" (U+014D)
  0x10, 0x28, 0x01, 0xB0, 0xA4, 0x03, 0xD0, 0xE7, 0x72, 0x84, 0x5B, 0xEE, 0xC6, 0x40, 0x9A, 0x0D,
  0x0C, 0xA0, 0xB2, 0x82, 0x4F, 0xE3, 0x28, 0x62, 0xDF, 0x70, 0xAF, 0x84, 0x85, 0x5F, 0xD0, 0xDF,
  0x54, 0x01, 0xA1, 0x81, 0xEF, 0x35, 0xA8, 0x22, 0xDF, 0x54, 0x02, 0xA8, 0x21, 0xAF, 0x84, 0x86,
  0x5F, 0xD0, 0x4F, 0xE3, 0x28, 0x22, 0xDF, 0x72, 0x08, 0xA0, 0xD0, 0xCA, 0x0B, 0x48, 0x45, 0xBE,
  0xFC, 0x73,
  // "Ŏ" (U+014E)
  0x38, 0x11, 0xF3, 0x28, 0x11, 0xE5, 0x78, 0x4B, 0xEC, 0xCF, 0xD7, 0x18, 0x41, 0xAE, 0xEB, 0x27,
  0x77, 0x77, 0x86, 0x4A, 0xDE, 0xEC, 0x82, 0x50, 0x9A, 0x85, 0xEB, 0xCE, 0xFE, 0x53, 0x82, 0x8F,
  0xE5, 0x40, 0x8A, 0x81, 0x30, 0x2A, 0x04, 0x68, 0x59, 0xFC, 0x07, 0xFD, 0x70, 0x2A, 0x82, 0x2A,
  0xF9, 0x71, 0x84, 0xEF, 0x5B, 0xF7, 0x71, 0x84, 0xCF, 0x7B, 0xF7, 0x71, 0x84, 0xCF, 0x7A, 0xF9,
  0x71, 0x84, 0xEF, 0x56, 0xFD, 0x70, 0x2A, 0x02, 0x01, 0xA0, 0x56, 0x81, 0x9F, 0xC2, 0x82, 0x8F,
  0xE4, 0x40, 0x8A, 0x03, 0x30, 0x9A, 0x85, 0xEB, 0xCE, 0xFE, 0x55, 0x86, 0x4A, 0xDE, 0xEC, 0x82,
  0x30,
  // "ŏ" (U+014F)
  0x18, 0x11, 0xF3, 0x28, 0x11, 0xE5, 0x48, 0x4B, 0xEC, 0xCF, 0xD5, 0x84, 0x1A, 0xEE, 0xB2, 0x77,
  0x28, 0x45, 0xBE, 0xEC, 0x64, 0x09, 0xA0, 0xD0, 0xCA, 0x0B, 0x28, 0x24, 0xFE, 0x32, 0x86, 0x2D,
  0xF7, 0x0A, 0xF8, 0x48, 0x55, 0xFD, 0x0D, 0xF5, 0x40, 0x1A, 0x18, 0x1E, 0xF3, 0x5A, 0x82, 0x2D,
  0xF5, 0x40, 0x2A, 0x82, 0x1A, 0xF8, 0x48, 0x65, 0xFD, 0x04, 0xFE, 0x32, 0x82, 0x2D, 0xF7, 0x20,
  0x8A, 0x0D, 0x0C, 0xA0, 0xB4, 0x84, 0x5B, 0xEF, 0xC7, 0x30,
  // "Ő" (U+0150)
  0x58, 0x5B, 0xF8, 0x1E, 0xF3, 0x68, 0x54, 0xF9, 0x0A, 0xF4, 0x68, 0x51, 0xE8, 0x05, 0xE4, 0x77,
  0x77, 0x78, 0x64, 0xAD, 0xEE, 0xC8, 0x25, 0x09, 0xA8, 0x5E, 0xBC, 0xEF, 0xE5, 0x38, 0x28, 0xFE,
  0x54, 0x08, 0xA8, 0x13, 0x02, 0xA0, 0x46, 0x85, 0x9F, 0xC0, 0x7F, 0xD7, 0x02, 0xA8, 0x22, 0xAF,
  0x97, 0x18, 0x4E, 0xF5, 0xBF, 0x77, 0x18, 0x4C, 0xF7, 0xBF, 0x77, 0x18, 0x4C, 0xF7, 0xAF, 0x97,
  0x18, 0x4E, 0xF5, 0x6F, 0xD7, 0x02, 0xA0, 0x20, 0x1A, 0x05, 0x68, 0x19, 0xFC, 0x28, 0x28, 0xFE,
  0x44, 0x08, 0xA0, 0x33, 0x09, 0xA8, 0x5E, 0xBC, 0xEF, 0xE5, 0x58, 0x64, 0xAD, 0xEE, 0xC8, 0x23,
  // "ő" (U+0151)
  0x48, 0x5B, 0xF8, 0x1E, 0xF3, 0x38, 0x54, 0xF9, 0x0A, 0xF4, 0x38, 0x51, 0xE8, 0x05, 0xE4, 0x77,
  0x18, 0x45, 0xBE, 0xEC, 0x64, 0x09, 0xA0, 0xD0, 0xCA, 0x0B, 0x28, 0x24, 0xFE, 0x32, 0x86, 0x2D,
  0xF7, 0x0A, 0xF8, 0x48, 0x55, 0xFD, 0x0D, 0xF5, 0x40, 0x1A, 0x18, 0x1E, 0xF3, 0x5A, 0x82, 0x2D,
  0xF5, 0x40, 0x2A, 0x82, 0x1A, 0xF8, 0x48, 0x65, 0xFD, 0x04, 0xFE, 0x32, 0x82, 0x2D, 0xF7, 0x20,
  0x8A, 0x0D, 0x0C, 0xA0, 0xB4, 0x84, 0x5B, 0xEF, 0xC7, 0x30,
  // "Œ" (U+0152)
  0x38, 0x14, 0xAD, 0xFB, 0x09, 0x20, 0xAA, 0x82, 0xDB, 0xBD, 0xA8, 0x01, 0xB8, 0x47, 0x09, 0xFE,
  0x43, 0x81, 0x2F, 0xE6, 0x02, 0xA0, 0x44, 0x81, 0x2F, 0xE6, 0x81, 0x7F, 0xC5, 0x81, 0x2F, 0xE6,
  0x81, 0xAF, 0x85, 0x81, 0x2F, 0xE6, 0x81, 0xBF, 0x75, 0x02, 0xF8, 0x24, 0xBF, 0x75, 0x02, 0xA8,
  0x01, 0xB8, 0x23, 0xAF, 0x85, 0x81, 0x2F, 0xE6, 0x81, 0x7F, 0xC5, 0x81, 0x2F, 0xE6, 0x02, 0xA0,
  0x44, 0x81, 0x2F, 0xE7, 0x82, 0x8F, 0xE4, 0x38, 0x12, 0xFE, 0x71, 0x0A, 0xA8, 0x2D, 0xBB, 0xDA,
  0x80, 0x1B, 0x07, 0x38, 0x14, 0xAD, 0xFB, 0x09,
  // "œ" (U+0153)
  0x28, 0x46, 0xCE, 0xEB, 0x42, 0x84, 0x7D, 0xFE, 0x91, 0x30, 0xAA, 0x00, 0xCA, 0x89, 0x46, 0xAF,
  0xEC, 0xDF, 0xE1, 0x05, 0xFE, 0x32, 0x03, 0x0E, 0xA0, 0xB3, 0x85, 0x9F, 0xA0, 0xBF, 0x84, 0x08,
  0xA0, 0x23, 0x85, 0x2F, 0xE0, 0xEF, 0x44, 0x04, 0xA8, 0x01, 0xBA, 0x82, 0x1E, 0xF3, 0x40, 0x3F,
  0xA8, 0x21, 0xDF, 0x54, 0x04, 0xA7, 0x18, 0x1A, 0xF8, 0x40, 0x8A, 0x04, 0x78, 0x24, 0xFE, 0x32,
  0x03, 0x0E, 0xA0, 0xC0, 0x23, 0x01, 0x03, 0x20, 0x8A, 0x00, 0xCA, 0x07, 0x09, 0xA8, 0x3C, 0xCD,
  0xF9, 0x38, 0x45, 0xBE, 0xEB, 0x52, 0x85, 0x5C, 0xEF, 0xDA, 0x31,
  // "Ŕ" (U+0154)
  0x58, 0x27, 0xFD, 0x17, 0x82, 0x3F, 0xD1, 0x78, 0x21, 0xDB, 0x17, 0x77, 0x71, 0x01, 0xD8, 0x1D,
  0xA4, 0x30, 0x1A, 0x82, 0xBB, 0xCE, 0xA0, 0x72, 0x01, 0xA0, 0x13, 0x08, 0xA2, 0x01, 0xA0, 0x14,
  0xA8, 0x13, 0x01, 0xA0, 0x13, 0x01, 0xA8, 0x13, 0x01, 0xA0, 0x13, 0x81, 0x9F, 0xD2, 0x01, 0xA8,
  0x5B, 0xBC, 0xEF, 0xD2, 0x20, 0x1E, 0x0B, 0x40, 0x1A, 0x84, 0x10, 0x2F, 0xE1, 0x30, 0x1A, 0x01,
  0x28, 0x19, 0xFA, 0x30, 0x1A, 0x01, 0x28, 0x21, 0xEF, 0x42, 0x01, 0xA0, 0x13, 0x81, 0x7F, 0xD2,
  0x01, 0xA0, 0x14, 0x83, 0xDF, 0x80, 0x1A, 0x01, 0x40, 0x4A, 0x02,
  // "ŕ" (U+0155)
  0x48, 0x27, 0xFD, 0x13, 0x82, 0x3F, 0xD1, 0x38, 0x21, 0xDB, 0x17, 0x38, 0x97, 0x5F, 0x61, 0x9E,
  0xE1, 0x5F, 0x9D, 0xFC, 0xD0, 0x5A, 0x0C, 0x01, 0x30, 0x5A, 0x02, 0x48, 0x15, 0xFD, 0x58, 0x15,
  0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC,
  0x50,
  // "Ŗ" (U+0156)
  0x01, 0xD8, 0x1D, 0xA4, 0x30, 0x1A, 0x82, 0xBB, 0xCE, 0xA0, 0x72, 0x01, 0xA0, 0x13, 0x08, 0xA2,
  0x01, 0xA0, 0x14, 0xA8, 0x13, 0x01, 0xA0, 0x13, 0x01, 0xA8, 0x13, 0x01, 0xA0, 0x13, 0x81, 0x9F,
  0xD2, 0x01, 0xA8, 0x5B, 0xBC, 0xEF, 0xD2, 0x20, 0x1E, 0x0B, 0x40, 0x1A, 0x84, 0x10, 0x2F, 0xE1,
  0x30, 0x1A, 0x01, 0x28, 0x19, 0xFA, 0x30, 0x1A, 0x01, 0x28, 0x21, 0xEF, 0x42, 0x01, 0xA0, 0x13,
  0x81, 0x7F, 0xD2, 0x01, 0xA0, 0x14, 0x83, 0xDF, 0x80, 0x1A, 0x01, 0x40, 0x4A, 0x02, 0x77, 0x77,
  0x18, 0x1C, 0xF3, 0x72, 0x90, 0xB7, 0x28, 0x15, 0xE1, 0x50,
  // "ŗ" (U+0157)
  0x89, 0x75, 0xF6, 0x19, 0xEE, 0x15, 0xF9, 0xDF, 0xCD, 0x05, 0xA0, 0xC0, 0x13, 0x05, 0xA0, 0x24,
  0x81, 0x5F, 0xD5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81,
  0x5F, 0xC5, 0x81, 0x5F, 0xC7, 0x77, 0x18, 0x1C, 0xF3, 0x59, 0x0B, 0x58, 0x15, 0xE1, 0x50,
  // "Ř" (U+0158)
  0x18, 0x61, 0xDC, 0x20, 0x3D, 0xB5, 0x84, 0x1D, 0xE8, 0xFB, 0x78, 0x32, 0xEF, 0xD1, 0x77, 0x77,
  0x01, 0xD8, 0x1D, 0xA4, 0x30, 0x1A, 0x82, 0xBB, 0xCE, 0xA0, 0x72, 0x01, 0xA0, 0x13, 0x08, 0xA2,
  0x01, 0xA0, 0x14, 0xA8, 0x13, 0x01, 0xA0, 0x13, 0x01, 0xA8, 0x13, 0x01, 0xA0, 0x13, 0x81, 0x9F,
  0xD2, 0x01, 0xA8, 0x5B, 0xBC, 0xEF, 0xD2, 0x20, 0x1E, 0x0B, 0x40, 0x1A, 0x84, 0x10, 0x2F, 0xE1,
  0x30, 0x1A, 0x01, 0x28, 0x19, 0xFA, 0x30, 0x1A, 0x01, 0x28, 0x21, 0xEF, 0x42, 0x01, 0xA0, 0x13,
  0x81, 0x7F, 0xD2, 0x01, 0xA0, 0x14, 0x83, 0xDF, 0x80, 0x1A, 0x01, 0x40, 0x4A, 0x02,
  // "ř" (U+0159)
  0x86, 0x1D, 0xC2, 0x03, 0xDB, 0x28, 0x41, 0xDE, 0x8F, 0xB4, 0x83, 0x2E, 0xFD, 0x17, 0x58, 0x96,
  0x5F, 0x61, 0x9E, 0xE1, 0x05, 0xF9, 0xDF, 0xCD, 0x20, 0x5A, 0x0C, 0x01, 0x40, 0x5A, 0x02, 0x58,
  0x15, 0xFD, 0x68, 0x15, 0xFC, 0x68, 0x15, 0xFC, 0x68, 0x15, 0xFC, 0x68, 0x15, 0xFC, 0x68, 0x15,
  0xFC, 0x68, 0x15, 0xFC, 0x50,
  // "Ś" (U+015A)
  0x58, 0x27, 0xFD, 0x14, 0x82, 0x3F, 0xD1, 0x48, 0x21, 0xDB, 0x17, 0x77, 0x8A, 0x21, 0x8C, 0xEE,
  0xC9, 0x42, 0xEF, 0xEB, 0xCE, 0xF8, 0xAF, 0xB4, 0x83, 0x42, 0xCF, 0x56, 0x81, 0xBF, 0x96, 0x05,
  0xA0, 0xA0, 0x25, 0x06, 0x0E, 0xA0, 0xC0, 0x54, 0x81, 0x17, 0xEA, 0x0B, 0x01, 0x58, 0x26, 0xEF,
  0xA6, 0x04, 0xA6, 0x01, 0xA0, 0x60, 0x14, 0x81, 0x9F, 0xCA, 0x89, 0x0D, 0xBC, 0xEF, 0xE3, 0x7B,
  0xDA, 0x81, 0xD9, 0x21,
  // "ś" (U+015B)
  0x48, 0x27, 0xFD, 0x13, 0x82, 0x3F, 0xD1, 0x38, 0x21, 0xDB, 0x17, 0x48, 0x66, 0xCE, 0xEC, 0x92,
  0x9A, 0x83, 0xCC, 0xEF, 0x5A, 0x03, 0x38, 0x34, 0x0E, 0xF6, 0x50, 0x6A, 0x0C, 0x05, 0x40, 0x30,
  0xBA, 0x0E, 0x06, 0x40, 0x10, 0x8A, 0x06, 0x58, 0x26, 0xFB, 0x54, 0x81, 0x7F, 0xBA, 0x81, 0xDB,
  0xDA, 0x86, 0x47, 0xCE, 0xFD, 0xA3, 0x10,
  // "Ŝ" (U+015C)
  0x28, 0x32, 0xEF, 0xD1, 0x38, 0x41, 0xDE, 0x8F, 0xB2, 0x86, 0x1C, 0xC2, 0x04, 0xDB, 0x77, 0x68,
  0xA2, 0x18, 0xCE, 0xEC, 0x94, 0x2E, 0xFE, 0xBC, 0xEF, 0x8A, 0xFB, 0x48, 0x34, 0x2C, 0xF5, 0x68,
  0x1B, 0xF9, 0x60, 0x5A, 0x0A, 0x02, 0x50, 0x60, 0xEA, 0x0C, 0x05, 0x48, 0x11, 0x7E, 0xA0, 0xB0,
  0x15, 0x82, 0x6E, 0xFA, 0x60, 0x4A, 0x60, 0x1A, 0x06, 0x01, 0x48, 0x19, 0xFC, 0xA8, 0x90, 0xDB,
  0xCE, 0xFE, 0x37, 0xBD, 0xA8, 0x1D, 0x92, 0x10,
  // "ŝ" (U+015D)
  0x28, 0x32, 0xEF, 0xD1, 0x38, 0x41, 0xDE, 0x8F, 0xB2, 0x86, 0x1C, 0xC2, 0x04, 0xDB, 0x75, 0x87,
  0x6C, 0xEE, 0xC9, 0x20, 0x9A, 0x83, 0xCC, 0xEF, 0x51, 0xA0, 0x33, 0x04, 0x28, 0x1E, 0xF6, 0x60,
  0x6A, 0x0C, 0x05, 0x50, 0x30, 0xBA, 0x0E, 0x06, 0x50, 0x10, 0x8A, 0x06, 0x68, 0x36, 0xFB, 0x05,
  0x48, 0x17, 0xFB, 0x1A, 0x81, 0xDB, 0xDA, 0x87, 0x40, 0x7C, 0xEF, 0xDA, 0x31,
  // "Ş" (U+015E)
  0x18, 0xA2, 0x18, 0xCE, 0xEC, 0x94, 0x2E, 0xFE, 0xBC, 0xEF, 0x8A, 0xFB, 0x48, 0x34, 0x2C, 0xF5,
  0x68, 0x1B, 0xF9, 0x60, 0x5A, 0x0A, 0x02, 0x50, 0x60, 0xEA, 0x0C, 0x05, 0x48, 0x11, 0x7E, 0xA0,
  0xB0, 0x15, 0x82, 0x6E, 0xFA, 0x60, 0x4A, 0x60, 0x1A, 0x06, 0x01, 0x48, 0x19, 0xFC, 0xA8, 0x90,
  0xDB, 0xCE, 0xFE, 0x37, 0xBD, 0xA8, 0x1D, 0x92, 0x40, 0x70, 0x86, 0x82, 0x1D, 0xD5, 0x78, 0x1A,
  0xF1, 0x48, 0x37, 0x8D, 0xF1, 0x40, 0xEA, 0x07, 0x50, 0x02, 0x50,
  // "ş" (U+015F)
  0x18, 0x66, 0xCE, 0xEC, 0x92, 0x9A, 0x83, 0xCC, 0xEF, 0x5A, 0x03, 0x38, 0x34, 0x0E, 0xF6, 0x50,
  0x6A, 0x0C, 0x05, 0x40, 0x30, 0xBA, 0x0E, 0x06, 0x40, 0x10, 0x8A, 0x06, 0x58, 0x26, 0xFB, 0x54,
  0x81, 0x7F, 0xBA, 0x81, 0xDB, 0xDA, 0x86, 0x47, 0xCE, 0xFD, 0xA3, 0x40, 0x70, 0x85, 0x82, 0x1D,
  0xD5, 0x68, 0x1A, 0xF1, 0x38, 0x37, 0x8D, 0xF1, 0x30, 0xEA, 0x07, 0x40, 0x02, 0x40,
  // "Š" (U+0160)
  0x86, 0x1D, 0xC2, 0x03, 0xDB, 0x28, 0x41, 0xDE, 0x8F, 0xB4, 0x83, 0x2E, 0xFD, 0x17, 0x77, 0x8A,
  0x21, 0x8C, 0xEE, 0xC9, 0x42, 0xEF, 0xEB, 0xCE, 0xF8, 0xAF, 0xB4, 0x83, 0x42, 0xCF, 0x56, 0x81,
  0xBF, 0x96, 0x05, 0xA0, 0xA0, 0x25, 0x06, 0x0E, 0xA0, 0xC0, 0x54, 0x81, 0x17, 0xEA, 0x0B, 0x01,
  0x58, 0x26, 0xEF, 0xA6, 0x04, 0xA6, 0x01, 0xA0, 0x60, 0x14, 0x81, 0x9F, 0xCA, 0x89, 0x0D, 0xBC,
  0xEF, 0xE3, 0x7B, 0xDA, 0x81, 0xD9, 0x21,
  // "š" (U+0161)
  0x86, 0x1D, 0xC2, 0x03, 0xDB, 0x28, 0x41, 0xDE, 0x8F, 0xB4, 0x83, 0x2E, 0xFD, 0x17, 0x68, 0x76,
  0xCE, 0xEC, 0x92, 0x09, 0xA8, 0x3C, 0xCE, 0xF5, 0x1A, 0x03, 0x30, 0x42, 0x81, 0xEF, 0x66, 0x06,
  0xA0, 0xC0, 0x55, 0x03, 0x0B, 0xA0, 0xE0, 0x65, 0x01, 0x08, 0xA0, 0x66, 0x83, 0x6F, 0xB0, 0x54,
  0x81, 0x7F, 0xB1, 0xA8, 0x1D, 0xBD, 0xA8, 0x74, 0x07, 0xCE, 0xFD, 0xA3, 0x10,
  // "Ţ" (U+0162)
  0x0B, 0xFB, 0x85, 0x8B, 0xBB, 0xDF, 0xE8, 0x00, 0xB4, 0x81, 0x7F, 0xA7, 0x18, 0x17, 0xFA, 0x71,
  0x81, 0x7F, 0xA7, 0x18, 0x17, 0xFA, 0x71, 0x81, 0x7F, 0xA7, 0x18, 0x17, 0xFA, 0x71, 0x81, 0x7F,
  0xA7, 0x18, 0x17, 0xFA, 0x71, 0x81, 0x7F, 0xA7, 0x18, 0x17, 0xFA, 0x71, 0x81, 0x7F, 0xA7, 0x18,
  0x17, 0xFA, 0x72, 0x07, 0x08, 0x71, 0x82, 0x1D, 0xD5, 0x72, 0x81, 0xAF, 0x16, 0x83, 0x78, 0xDF,
  0x16, 0x0E, 0xA0, 0x77, 0x00, 0x25,
  // "ţ" (U+0163)
  0x20, 0x30, 0x76, 0x09, 0x96, 0x0E, 0x94, 0x04, 0x0D, 0xD8, 0x11, 0x7B, 0xA0, 0xFB, 0x20, 0x2A,
  0x50, 0x2A, 0x50, 0x2A, 0x50, 0x2A, 0x50, 0x2A, 0x50, 0x2A, 0x6A, 0x03, 0x58, 0x4B, 0xFE, 0xCD,
  0x22, 0x84, 0x1A, 0xEE, 0xC1, 0x30, 0x70, 0x85, 0x82, 0x1D, 0xD5, 0x68, 0x1A, 0xF1, 0x38, 0x37,
  0x8D, 0xF1, 0x30, 0xEA, 0x07, 0x40, 0x02, 0x40,
  // "Ť" (U+0164)
  0x18, 0x61, 0xDC, 0x20, 0x3D, 0xB4, 0x84, 0x1D, 0xE8, 0xFB, 0x68, 0x32, 0xEF, 0xD1, 0x77, 0x74,
  0x0B, 0xFB, 0x85, 0x8B, 0xBB, 0xDF, 0xE8, 0x00, 0xB4, 0x81, 0x7F, 0xA7, 0x18, 0x17, 0xFA, 0x71,
  0x81, 0x7F, 0xA7, 0x18, 0x17, 0xFA, 0x71, 0x81, 0x7F, 0xA7, 0x18, 0x17, 0xFA, 0x71, 0x81, 0x7F,
  0xA7, 0x18, 0x17, 0xFA, 0x71, 0x81, 0x7F, 0xA7, 0x18, 0x17, 0xFA, 0x71, 0x81, 0x7F, 0xA7, 0x18,
  0x17, 0xFA, 0x40,
  // "ť" (U+0165)
  0x71, 0x81, 0xBF, 0x32, 0x03, 0x07, 0x40, 0xE0, 0xC3, 0x09, 0x93, 0x81, 0x3F, 0x33, 0x0E, 0x97,
  0x04, 0x0D, 0xD0, 0x13, 0x07, 0x0B, 0xA0, 0xFB, 0x50, 0x2A, 0x71, 0x02, 0xA7, 0x10, 0x2A, 0x71,
  0x02, 0xA7, 0x10, 0x2A, 0x71, 0x02, 0xA7, 0x2A, 0x03, 0x71, 0x84, 0xBF, 0xEC, 0xD2, 0x58, 0x41,
  0xAE, 0xEC, 0x13,
  // "Ŧ" (U+0166)
  0x0B, 0xFB, 0x85, 0x8B, 0xBB, 0xDF, 0xE8, 0x00, 0xB4, 0x81, 0x7F, 0xA7, 0x18, 0x17, 0xFA, 0x71,
  0x81, 0x7F, 0xA7, 0x18, 0x17, 0xFA, 0x50, 0x4F, 0x07, 0x28, 0x73, 0xBB, 0xDF, 0xEB, 0xB5, 0x58,
  0x17, 0xFA, 0x71, 0x81, 0x7F, 0xA7, 0x18, 0x17, 0xFA, 0x71, 0x81, 0x7F, 0xA7, 0x18, 0x17, 0xFA,
  0x71, 0x81, 0x7F, 0xA4,
  // "ŧ" (U+0167)
  0x20, 0x30, 0x76, 0x09, 0x96, 0x0E, 0x94, 0x04, 0x0D, 0xD8, 0x11, 0x7B, 0xA0, 0xFB, 0x20, 0x2A,
  0x50, 0x2A, 0x40, 0x7D, 0x82, 0xD0, 0x5B, 0xA8, 0x1B, 0xB9, 0x20, 0x2A, 0x50, 0x2A, 0x50, 0x1A,
  0x03, 0x58, 0x4C, 0xFE, 0xBD, 0x22, 0x84, 0x1A, 0xEE, 0xC1,
  // "Ũ" (U+0168)
  0x38, 0x21, 0x9A, 0x52, 0x0A, 0x03, 0x40, 0xBB, 0x82, 0xDD, 0xE1, 0x38, 0x61, 0xF4, 0x18, 0xDE,
  0x57, 0x77, 0x58, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A,
  0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE,
  0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x02, 0xA6, 0x85, 0x3F, 0xE0,
  0xEF, 0x45, 0x86, 0x7F, 0xB0, 0x9F, 0xD3, 0x38, 0x24, 0xEF, 0x52, 0x0C, 0xA8, 0x1D, 0xBD, 0xA0,
  0x84, 0x85, 0x7C, 0xEF, 0xDA, 0x42,
  // "ũ" (U+0169)
  0x28, 0x21, 0x9A, 0x52, 0x0A, 0x03, 0x20, 0xBB, 0x89, 0x3D, 0xDE, 0x10, 0x1F, 0x41, 0x8D, 0xE5,
  0x74, 0x81, 0x6F, 0xA4, 0x84, 0x2F, 0xE6, 0xFA, 0x48, 0x42, 0xFE, 0x6F, 0xA4, 0x84, 0x2F, 0xE6,
  0xFA, 0x48, 0x42, 0xFE, 0x6F, 0xA4, 0x84, 0x2F, 0xE6, 0xFA, 0x48, 0x43, 0xFE, 0x6F, 0xA4, 0x84,
  0x4F, 0xE6, 0xFC, 0x48, 0x27, 0xFE, 0x4A, 0x01, 0x38, 0xA5, 0xDF, 0xE0, 0xDF, 0xE9, 0x9D, 0xDF,
  0xE0, 0x19, 0xDF, 0xD9, 0x1D, 0xE0,
  // "Ū" (U+016A)
  0x30, 0x28, 0x01, 0xB0, 0xA5, 0x03, 0xD0, 0xE7, 0x77, 0x58, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F,
  0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A,
  0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE,
  0x60, 0x2A, 0x02, 0xA6, 0x85, 0x3F, 0xE0, 0xEF, 0x45, 0x86, 0x7F, 0xB0, 0x9F, 0xD3, 0x38, 0x24,
  0xEF, 0x52, 0x0C, 0xA8, 0x1D, 0xBD, 0xA0, 0x84, 0x85, 0x7C, 0xEF, 0xDA, 0x42,
  // "ū" (U+016B)
  0x10, 0x28, 0x01, 0xB0, 0xA3, 0x03, 0xD0, 0xE7, 0x58, 0x16, 0xFA, 0x48, 0x42, 0xFE, 0x6F, 0xA4,
  0x84, 0x2F, 0xE6, 0xFA, 0x48, 0x42, 0xFE, 0x6F, 0xA4, 0x84, 0x2F, 0xE6, 0xFA, 0x48, 0x42, 0xFE,
  0x6F, 0xA4, 0x84, 0x3F, 0xE6, 0xFA, 0x48, 0x44, 0xFE, 0x6F, 0xC4, 0x82, 0x7F, 0xE4, 0xA0, 0x13,
  0x8A, 0x5D, 0xFE, 0x0D, 0xFE, 0x99, 0xDD, 0xFE, 0x01, 0x9D, 0xFD, 0x91, 0xDE,
  // "Ŭ" (U+016C)
  0x28, 0x11, 0xF3, 0x28, 0x11, 0xE5, 0x58, 0x4B, 0xEC, 0xCF, 0xD6, 0x84, 0x1A, 0xEE, 0xB2, 0x77,
  0x76, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13,
  0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02,
  0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA0, 0x2A, 0x68, 0x53, 0xFE, 0x0E, 0xF4,
  0x58, 0x67, 0xFB, 0x09, 0xFD, 0x33, 0x82, 0x4E, 0xF5, 0x20, 0xCA, 0x81, 0xDB, 0xDA, 0x08, 0x48,
  0x57, 0xCE, 0xFD, 0xA4, 0x20,
  // "ŭ" (U+016D)
  0x18, 0x11, 0xF3, 0x28, 0x11, 0xE5, 0x38, 0x4B, 0xEC, 0xCF, 0xD4, 0x84, 0x1A, 0xEE, 0xB2, 0x75,
  0x81, 0x6F, 0xA4, 0x84, 0x2F, 0xE6, 0xFA, 0x48, 0x42, 0xFE, 0x6F, 0xA4, 0x84, 0x2F, 0xE6, 0xFA,
  0x48, 0x42, 0xFE, 0x6F, 0xA4, 0x84, 0x2F, 0xE6, 0xFA, 0x48, 0x43, 0xFE, 0x6F, 0xA4, 0x84, 0x4F,
  0xE6, 0xFC, 0x48, 0x27, 0xFE, 0x4A, 0x01, 0x38, 0xA5, 0xDF, 0xE0, 0xDF, 0xE9, 0x9D, 0xDF, 0xE0,
  0x19, 0xDF, 0xD9, 0x1D, 0xE0,
  // "Ů" (U+016E)
  0x48, 0x26, 0xEE, 0x87, 0x84, 0x1F, 0x32, 0xE3, 0x68, 0x41, 0xF2, 0x2E, 0x37, 0x82, 0x7E, 0xE8,
  0x77, 0x77, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8,
  0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6,
  0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA0, 0x2A, 0x68, 0x53, 0xFE, 0x0E,
  0xF4, 0x58, 0x67, 0xFB, 0x09, 0xFD, 0x33, 0x82, 0x4E, 0xF5, 0x20, 0xCA, 0x81, 0xDB, 0xDA, 0x08,
  0x48, 0x57, 0xCE, 0xFD, 0xA4, 0x20,
  // "ů" (U+016F)
  0x38, 0x26, 0xEE, 0x85, 0x84, 0x1F, 0x32, 0xE3, 0x48, 0x41, 0xF2, 0x2E, 0x35, 0x82, 0x7E, 0xE8,
  0x76, 0x81, 0x6F, 0xA4, 0x84, 0x2F, 0xE6, 0xFA, 0x48, 0x42, 0xFE, 0x6F, 0xA4, 0x84, 0x2F, 0xE6,
  0xFA, 0x48, 0x42, 0xFE, 0x6F, 0xA4, 0x84, 0x2F, 0xE6, 0xFA, 0x48, 0x43, 0xFE, 0x6F, 0xA4, 0x84,
  0x4F, 0xE6, 0xFC, 0x48, 0x27, 0xFE, 0x4A, 0x01, 0x38, 0xA5, 0xDF, 0xE0, 0xDF, 0xE9, 0x9D, 0xDF,
  0xE0, 0x19, 0xDF, 0xD9, 0x1D, 0xE0,
  // "Ű" (U+0170)
  0x58, 0x5B, 0xF8, 0x1E, 0xF3, 0x48, 0x54, 0xF9, 0x0A, 0xF4, 0x48, 0x51, 0xE8, 0x05, 0xE4, 0x77,
  0x75, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13,
  0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02,
  0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA0, 0x2A, 0x68, 0x53, 0xFE, 0x0E, 0xF4,
  0x58, 0x67, 0xFB, 0x09, 0xFD, 0x33, 0x82, 0x4E, 0xF5, 0x20, 0xCA, 0x81, 0xDB, 0xDA, 0x08, 0x48,
  0x57, 0xCE, 0xFD, 0xA4, 0x20,
  // "ű" (U+0171)
  0x48, 0x5B, 0xF8, 0x1E, 0xF3, 0x38, 0x54, 0xF9, 0x0A, 0xF4, 0x38, 0x51, 0xE8, 0x05, 0xE4, 0x76,
  0x81, 0x6F, 0xA4, 0x85, 0x2F, 0xE0, 0x6F, 0xA4, 0x85, 0x2F, 0xE0, 0x6F, 0xA4, 0x85, 0x2F, 0xE0,
  0x6F, 0xA4, 0x85, 0x2F, 0xE0, 0x6F, 0xA4, 0x85, 0x2F, 0xE0, 0x6F, 0xA4, 0x85, 0x3F, 0xE0, 0x6F,
  0xA4, 0x85, 0x4F, 0xE0, 0x6F, 0xC4, 0x83, 0x7F, 0xE0, 0x4A, 0x01, 0x38, 0x1D, 0xFE, 0x28, 0x7D,
  0xFE, 0x99, 0xDD, 0xFE, 0x28, 0x71, 0x9D, 0xFD, 0x91, 0xDE, 0x10,
  // "Ų" (U+0172)
  0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE,
  0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8, 0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA8,
  0x13, 0xFE, 0x60, 0x2A, 0x81, 0x3F, 0xE6, 0x02, 0xA0, 0x2A, 0x68, 0x53, 0xFE, 0x0E, 0xF4, 0x58,
  0x67, 0xFC, 0x09, 0xFD, 0x33, 0x82, 0x4E, 0xF7, 0x20, 0xCA, 0x81, 0xDB, 0xDA, 0x0C, 0x48, 0x67,
  0xCE, 0xFE, 0xFD, 0x17, 0x18, 0x18, 0xE2, 0x72, 0x90, 0x97, 0x28, 0x12, 0xF7, 0x72, 0x01, 0xA0,
  0xB0, 0x37, 0x18, 0x26, 0xEE, 0x31,
  // "ų" (U+0173)
  0x81, 0x6F, 0xA4, 0x85, 0x2F, 0xE0, 0x6F, 0xA4, 0x85, 0x2F, 0xE0, 0x6F, 0xA4, 0x85, 0x2F, 0xE0,
  0x6F, 0xA4, 0x85, 0x2F, 0xE0, 0x6F, 0xA4, 0x85, 0x2F, 0xE0, 0x6F, 0xA4, 0x85, 0x3F, 0xE0, 0x6F,
  0xA4, 0x85, 0x4F, 0xE0, 0x6F, 0xC4, 0x83, 0x7F, 0xE0, 0x4A, 0x01, 0x38, 0x1D, 0xFE, 0x28, 0x7D,
  0xFE, 0x99, 0xDD, 0xFE, 0x28, 0x51, 0x9D, 0xFD, 0x93, 0xA7, 0x10, 0xC0, 0xA7, 0x18, 0x12, 0xF7,
  0x71, 0x83, 0x1F, 0xEB, 0x37, 0x82, 0x7E, 0xE3,
  // "Ŵ" (U+0174)
  0x78, 0x32, 0xEF, 0xD1, 0x76, 0x84, 0x1D, 0xE8, 0xFB, 0x75, 0x86, 0x1C, 0xC2, 0x04, 0xDB, 0x80,
  0xD0, 0x08, 0x1B, 0xF7, 0x58, 0x1D, 0xF9, 0x58, 0x4A, 0xF7, 0x6F, 0xB4, 0x02, 0xA0, 0xD5, 0x82,
  0xEF, 0x32, 0xA4, 0x06, 0xB0, 0x23, 0x81, 0x3F, 0xE2, 0x81, 0xEF, 0x43, 0x83, 0xBF, 0x9F, 0x73,
  0x81, 0x6F, 0xA2, 0x81, 0x9F, 0x83, 0x98, 0x2E, 0x3F, 0xB3, 0x81, 0xAF, 0x62, 0x81, 0x5F, 0xB2,
  0x85, 0x4F, 0xA0, 0xEF, 0x12, 0x81, 0xEF, 0x22, 0x01, 0xA2, 0x89, 0x19, 0xF6, 0x09, 0xF5, 0x03,
  0xFD, 0x48, 0x95, 0xDF, 0x40, 0xDF, 0x10, 0x5F, 0xA0, 0x7F, 0x94, 0x84, 0x8F, 0x82, 0xFC, 0x39,
  0x83, 0xE0, 0xAF, 0x54, 0x84, 0x4F, 0xB6, 0xF8, 0x38, 0x4B, 0xF3, 0xEF, 0x15, 0x98, 0x2E, 0x9F,
  0x33, 0x83, 0x7F, 0x8F, 0xC6, 0x82, 0xBF, 0xEE, 0x48, 0x32, 0xFE, 0xF8, 0x60, 0x7A, 0x09, 0x50,
  0xDA, 0x04, 0x60, 0x3A, 0x05, 0x50, 0x8A, 0x40,
  // "ŵ" (U+0175)
  0x68, 0x32, 0xEF, 0xD1, 0x73, 0x84, 0x1D, 0xE8, 0xFB, 0x72, 0x86, 0x1C, 0xC2, 0x04, 0xDB, 0x77,
  0x68, 0x1A, 0xF7, 0x30, 0x3A, 0x05, 0x38, 0x45, 0xFC, 0x5F, 0xB3, 0x08, 0xA0, 0xA3, 0x82, 0x9F,
  0x71, 0xA3, 0x82, 0xCE, 0xCE, 0x38, 0xA0, 0xDF, 0x30, 0xCF, 0x30, 0x1F, 0xA9, 0xF3, 0x01, 0xFE,
  0x28, 0x94, 0x8F, 0x70, 0x5F, 0x65, 0xF7, 0x05, 0xFA, 0x28, 0x94, 0x4F, 0xB0, 0xAF, 0x21, 0xFC,
  0x09, 0xF6, 0x39, 0x82, 0xE0, 0xED, 0x28, 0x4C, 0xF1, 0xDF, 0x23, 0x83, 0xBF, 0x6F, 0x92, 0x83,
  0x7F, 0x6F, 0xD4, 0x83, 0x7F, 0xBF, 0x42, 0x83, 0x3F, 0xCF, 0x94, 0x03, 0xA0, 0xE4, 0x0E, 0xA0,
  0x45, 0x81, 0xEF, 0xB4, 0x0A, 0xA3,
  // "Ŷ" (U+0176)
  0x38, 0x32, 0xEF, 0xD1, 0x68, 0x41, 0xDE, 0x8F, 0xB5, 0x86, 0x1C, 0xC2, 0x04, 0xDB, 0x77, 0x76,
  0x81, 0xBF, 0x96, 0x82, 0xDF, 0x52, 0xA0, 0x24, 0x81, 0x6F, 0xC2, 0x81, 0x9F, 0xA4, 0x81, 0xEF,
  0x42, 0x01, 0xA0, 0x22, 0x81, 0x7F, 0xB4, 0x86, 0x8F, 0xA0, 0x1E, 0xF2, 0x48, 0x51, 0xEF, 0x38,
  0xF9, 0x68, 0x47, 0xFC, 0xEE, 0x17, 0x0D, 0xA0, 0x87, 0x18, 0x15, 0xFE, 0x72, 0x81, 0x3F, 0xE7,
  0x28, 0x13, 0xFE, 0x72, 0x81, 0x3F, 0xE7, 0x28, 0x13, 0xFE, 0x72, 0x81, 0x3F, 0xE5,
  // "ŷ" (U+0177)
  0x38, 0x32, 0xEF, 0xD1, 0x58, 0x41, 0xDE, 0x8F, 0xB4, 0x86, 0x1C, 0xC2, 0x04, 0xDB, 0x76, 0x81,
  0xCF, 0x75, 0x84, 0xDF, 0x56, 0xFC, 0x48, 0x13, 0xFE, 0x28, 0x1E, 0xF2, 0x38, 0x18, 0xF9, 0x28,
  0x19, 0xF8, 0x38, 0x1D, 0xF4, 0x28, 0x13, 0xFD, 0x28, 0x13, 0xFD, 0x48, 0x5D, 0xF3, 0x09, 0xF8,
  0x48, 0x57, 0xF9, 0x0D, 0xF2, 0x48, 0x41, 0xFE, 0x3F, 0xC6, 0x83, 0xAF, 0xAF, 0x66, 0x04, 0xB0,
  0x17, 0x81, 0xDF, 0xA7, 0x18, 0x1C, 0xF4, 0x78, 0x12, 0xFE, 0x71, 0x81, 0xBF, 0x75, 0x83, 0x7B,
  0xEF, 0xC6, 0x83, 0x9F, 0xD9, 0x16,
  // "Ÿ" (U+0178)
  0x38, 0x49, 0x80, 0x1A, 0x66, 0x84, 0xDC, 0x02, 0xE9, 0x80, 0xC3, 0x08, 0x1B, 0xF9, 0x68, 0x2D,
  0xF5, 0x2A, 0x02, 0x48, 0x16, 0xFC, 0x28, 0x19, 0xFA, 0x48, 0x1E, 0xF4, 0x20, 0x1A, 0x02, 0x28,
  0x17, 0xFB, 0x48, 0x68, 0xFA, 0x01, 0xEF, 0x24, 0x85, 0x1E, 0xF3, 0x8F, 0x96, 0x84, 0x7F, 0xCE,
  0xE1, 0x70, 0xDA, 0x08, 0x71, 0x81, 0x5F, 0xE7, 0x28, 0x13, 0xFE, 0x72, 0x81, 0x3F, 0xE7, 0x28,
  0x13, 0xFE, 0x72, 0x81, 0x3F, 0xE7, 0x28, 0x13, 0xFE, 0x50,
  // "Ź" (U+0179)
  0x68, 0x27, 0xFD, 0x16, 0x82, 0x3F, 0xD1, 0x68, 0x21, 0xDB, 0x17, 0x77, 0x40, 0x1F, 0xA0, 0x90,
  0x18, 0x03, 0xBA, 0x07, 0x78, 0x18, 0xFD, 0x70, 0x3A, 0x03, 0x78, 0x1C, 0xF8, 0x78, 0x18, 0xFC,
  0x70, 0x3A, 0x03, 0x78, 0x1D, 0xF7, 0x78, 0x18, 0xFC, 0x70, 0x3A, 0x02, 0x78, 0x1D, 0xF7, 0x78,
  0x19, 0xFC, 0x70, 0x3A, 0x0C, 0x80, 0x2B, 0x08, 0x04, 0xFA, 0x0C,
  // "ź" (U+017A)
  0x58, 0x27, 0xFD, 0x14, 0x82, 0x3F, 0xD1, 0x48, 0x21, 0xDB, 0x17, 0x50, 0xEE, 0x89, 0x09, 0x0A,
  0xBB, 0xBB, 0xEF, 0x85, 0x82, 0x4F, 0xD1, 0x48, 0x21, 0xEF, 0x45, 0x81, 0xAF, 0x85, 0x81, 0x6F,
  0xC5, 0x82, 0x2E, 0xF2, 0x58, 0x1C, 0xF6, 0x58, 0x18, 0xFB, 0x50, 0x2A, 0x85, 0xCB, 0xBB, 0xB8,
  0x4F, 0x0C,
  // "Ż" (U+017B)
  0x48, 0x21, 0xEE, 0x17, 0x82, 0x1D, 0xD1, 0x77, 0x74, 0x01, 0xFA, 0x09, 0x01, 0x80, 0x3B, 0xA0,
  0x77, 0x81, 0x8F, 0xD7, 0x03, 0xA0, 0x37, 0x81, 0xCF, 0x87, 0x81, 0x8F, 0xC7, 0x03, 0xA0, 0x37,
  0x81, 0xDF, 0x77, 0x81, 0x8F, 0xC7, 0x03, 0xA0, 0x27, 0x81, 0xDF, 0x77, 0x81, 0x9F, 0xC7, 0x03,
  0xA0, 0xC8, 0x02, 0xB0, 0x80, 0x4F, 0xA0, 0xC0,
  // "ż" (U+017C)
  0x38, 0x21, 0xEE, 0x15, 0x82, 0x1D, 0xD1, 0x75, 0x0E, 0xE8, 0x90, 0x90, 0xAB, 0xBB, 0xBE, 0xF8,
  0x58, 0x24, 0xFD, 0x14, 0x82, 0x1E, 0xF4, 0x58, 0x1A, 0xF8, 0x58, 0x16, 0xFC, 0x58, 0x22, 0xEF,
  0x25, 0x81, 0xCF, 0x65, 0x81, 0x8F, 0xB5, 0x02, 0xA8, 0x5C, 0xBB, 0xBB, 0x84, 0xF0, 0xC0,
  // "Ž" (U+017D)
  0x18, 0x61, 0xDC, 0x20, 0x3D, 0xB4, 0x84, 0x1D, 0xE8, 0xFB, 0x68, 0x32, 0xEF, 0xD1, 0x77, 0x74,
  0x01, 0xFA, 0x09, 0x01, 0x80, 0x3B, 0xA0, 0x77, 0x81, 0x8F, 0xD7, 0x03, 0xA0, 0x37, 0x81, 0xCF,
  0x87, 0x81, 0x8F, 0xC7, 0x03, 0xA0, 0x37, 0x81, 0xDF, 0x77, 0x81, 0x8F, 0xC7, 0x03, 0xA0, 0x27,
  0x81, 0xDF, 0x77, 0x81, 0x9F, 0xC7, 0x03, 0xA0, 0xC8, 0x02, 0xB0, 0x80, 0x4F, 0xA0, 0xC0,
  // "ž" (U+017E)
  0x86, 0x1D, 0xC2, 0x03, 0xDB, 0x28, 0x41, 0xDE, 0x8F, 0xB4, 0x83, 0x2E, 0xFD, 0x17, 0x50, 0xEE,
  0x89, 0x09, 0x0A, 0xBB, 0xBB, 0xEF, 0x85, 0x82, 0x4F, 0xD1, 0x48, 0x21, 0xEF, 0x45, 0x81, 0xAF,
  0x85, 0x81, 0x6F, 0xC5, 0x82, 0x2E, 0xF2, 0x58, 0x1C, 0xF6, 0x58, 0x18, 0xFB, 0x50, 0x2A, 0x85,
  0xCB, 0xBB, 0xB8, 0x4F, 0x0C,
  // "ſ" (U+017F)
  0x18, 0x97, 0x19, 0xDF, 0xD4, 0x0D, 0xFE, 0xCE, 0x23, 0xFE, 0x13, 0x81, 0x5F, 0xC4, 0x81, 0x5F,
  0xC4, 0x81, 0x5F, 0xC4, 0x81, 0x5F, 0xC4, 0x81, 0x5F, 0xC4, 0x81, 0x5F, 0xC4, 0x81, 0x5F, 0xC4,
  0x81, 0x5F, 0xC4, 0x81, 0x5F, 0xC4, 0x81, 0x5F, 0xC4, 0x81, 0x5F, 0xC4, 0x81, 0x5F, 0xC4,
  // "Ω" (U+03A9)
  0x48, 0x64, 0xAD, 0xEE, 0xC8, 0x26, 0x0B, 0xA8, 0x2D, 0xBC, 0xEA, 0x07, 0x48, 0x2A, 0xFD, 0x34,
  0x06, 0xA0, 0x52, 0x03, 0xA0, 0x36, 0x81, 0x7F, 0xD2, 0x81, 0x9F, 0xB7, 0x1A, 0x83, 0x30, 0xBF,
  0x87, 0x18, 0x5D, 0xF5, 0x0B, 0xF7, 0x71, 0x85, 0xCF, 0x60, 0x9F, 0x97, 0x18, 0x5E, 0xF4, 0x06,
  0xFC, 0x70, 0x1A, 0x84, 0x10, 0x1E, 0xF1, 0x68, 0x16, 0xFA, 0x38, 0x16, 0xFA, 0x58, 0x21, 0xEE,
  0x24, 0x81, 0x8F, 0x83, 0x82, 0x1C, 0xE4, 0x20, 0x30, 0xFB, 0xA0, 0x82, 0x85, 0xDF, 0xDB, 0xBB,
  0x4D, 0x09, 0x20, 0xED,
  // "μ" (U+03BC)
  0x81, 0x5F, 0xC4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A, 0x81, 0x5F, 0xC4, 0x01, 0xA8, 0x15, 0xFC,
  0x40, 0x1A, 0x81, 0x5F, 0xC4, 0x01, 0xA8, 0x15, 0xFC, 0x40, 0x1A, 0x81, 0x5F, 0xC4, 0x03, 0xA8,
  0x15, 0xFD, 0x40, 0x6A, 0x05, 0xA0, 0x42, 0x01, 0x0D, 0xA0, 0x5B, 0x8A, 0x1C, 0xCF, 0xCE, 0xF5,
  0xFC, 0xAE, 0xEA, 0x1B, 0xF5, 0xFB, 0x78, 0x15, 0xFC, 0x78, 0x15, 0xFC, 0x78, 0x15, 0xFC, 0x78,
  0x15, 0xFC, 0x70,
  // "π" (U+03C0)
  0x04, 0x0D, 0xFC, 0x89, 0x38, 0xBD, 0xFD, 0xBB, 0xBC, 0xFE, 0xBB, 0x28, 0x18, 0xF8, 0x38, 0x14,
  0xFD, 0x48, 0x18, 0xF8, 0x38, 0x14, 0xFD, 0x48, 0x18, 0xF8, 0x38, 0x14, 0xFD, 0x48, 0x18, 0xF8,
  0x38, 0x14, 0xFD, 0x48, 0x18, 0xF8, 0x38, 0x14, 0xFD, 0x48, 0x18, 0xF8, 0x38, 0x14, 0xFD, 0x48,
  0x18, 0xF8, 0x38, 0x13, 0xFE, 0x48, 0x18, 0xF8, 0x30, 0x1A, 0x0C, 0x09, 0x28, 0x18, 0xF8, 0x48,
  0x25, 0xDE, 0x90,
  // "–" (U+2013)
  0x02, 0x80, 0x4B, 0x02, 0x03, 0xF9, 0x03,
  // "—" (U+2014)
  0x02, 0x80, 0x96, 0xB0, 0x20, 0x3F, 0xFC, 0x03,
  // "€" (U+20AC)
  0x48, 0x53, 0xAD, 0xFE, 0xB6, 0x30, 0x7A, 0x83, 0xDB, 0xDF, 0xD2, 0x04, 0xA0, 0x54, 0x01, 0x28,
  0x1B, 0xF7, 0x60, 0x50, 0xBA, 0x83, 0xCB, 0xBB, 0x82, 0x07, 0xF0, 0xB3, 0x02, 0xA7, 0x10, 0x3A,
  0x80, 0x01, 0x30, 0x7F, 0x01, 0x28, 0x32, 0x4D, 0xF7, 0x0F, 0x45, 0x81, 0x8F, 0xA7, 0x18, 0x22,
  0xEF, 0x74, 0x02, 0x30, 0x4A, 0x83, 0xEC, 0xCE, 0xB4, 0x85, 0x3A, 0xDF, 0xEC, 0x60,
  // "₿" (U+20BF)
  0x28, 0x31, 0x70, 0x46, 0x58, 0x33, 0xF1, 0x8C, 0x58, 0x33, 0xF1, 0x8C, 0x30, 0x1D, 0x0E, 0x06,
  0x20, 0x1A, 0x81, 0xBB, 0xDA, 0x81, 0xA0, 0x1A, 0x01, 0x20, 0x5A, 0x02, 0x01, 0xA0, 0x13, 0x82,
  0xEF, 0x41, 0xA0, 0x13, 0xA0, 0x30, 0x1A, 0x86, 0x10, 0x19, 0xFC, 0x01, 0xE8, 0x2A, 0x10, 0x1A,
  0x81, 0xBB, 0xCA, 0x81, 0x90, 0x1A, 0x01, 0x28, 0x32, 0xEF, 0x61, 0xA0, 0x13, 0x82, 0x9F, 0xA1,
  0xA0, 0x13, 0x82, 0x9F, 0xA1, 0xA0, 0x12, 0x83, 0x2E, 0xF7, 0x1A, 0x81, 0xBB, 0xCA, 0x81, 0xD0,
  0x1D, 0x81, 0xE8, 0x13, 0x83, 0x3F, 0x18, 0xC5, 0x83, 0x3F, 0x17, 0xB3,
  // "‘" (U+2018)
  0x18, 0xA0, 0x3F, 0x60, 0x9F, 0x20, 0xFE, 0x05, 0xFC, 0x0A, 0xF9, 0x10,
  // "’" (U+2019)
  0x18, 0x1D, 0xF6, 0x1A, 0x89, 0x11, 0x3F, 0xC0, 0x6F, 0x60, 0xAE, 0x20,
  // "‚" (U+201A)
  0x18, 0x1D, 0xF6, 0x1A, 0x89, 0x11, 0x3F, 0xC0, 0x6F, 0x60, 0xAE, 0x20,
  // "‛" (U+201B)
  0x85, 0xAF, 0x90, 0x5F, 0xC2, 0x90, 0xE2, 0x85, 0x9F, 0x20, 0x3F, 0x60,
  // "“" (U+201C)
  0x18, 0xC4, 0x3F, 0x50, 0x4F, 0x50, 0xAF, 0x20, 0xBF, 0x11, 0xFE, 0x01, 0xFD, 0x05, 0xFB, 0x06,
  0xFA, 0x0A, 0xF8, 0x0B, 0xF8, 0x10,
  // "”" (U+201D)
  0x18, 0x5D, 0xF6, 0x0E, 0xF5, 0x1A, 0x00, 0x1A, 0x18, 0xA0, 0x3F, 0xC0, 0x4F, 0xB0, 0x6F, 0x60,
  0x7F, 0x50, 0xAE, 0x20, 0xB0, 0xE2,
  // "„" (U+201E)
  0x18, 0x5D, 0xF6, 0x0E, 0xF5, 0x1A, 0x00, 0x1A, 0x18, 0xA0, 0x3F, 0xC0, 0x4F, 0xB0, 0x6F, 0x60,
  0x7F, 0x50, 0xAE, 0x20, 0xB0, 0xE2,
  // "‟" (U+201F)
  0x8A, 0x5A, 0xF8, 0x0B, 0xF8, 0x05, 0xFB, 0x06, 0xFA, 0x01, 0xFE, 0x01, 0xFD, 0x28, 0x95, 0xAF,
  0x20, 0xBF, 0x10, 0x3F, 0x60, 0x4F, 0x50,
  // "†" (U+2020)
  0x3A, 0x01, 0x50, 0xD0, 0xE6, 0x0B, 0x0C, 0x38, 0x72, 0x21, 0x9A, 0x02, 0x3B, 0xF8, 0x66, 0x86,
  0xBC, 0x67, 0x93, 0x09, 0x0A, 0x60, 0xA0, 0xB6, 0x0B, 0x0C, 0x60, 0xC0, 0xD6, 0x0C, 0x0E, 0x60,
  0xD9, 0x60, 0xE9, 0x6A, 0x01, 0x5A, 0x02, 0x20,
  // "‡" (U+2021)
  0x38, 0x1E, 0xF2, 0x60, 0xC9, 0x70, 0xA0, 0xD4, 0x89, 0x07, 0x86, 0xBD, 0x67, 0x90, 0xCF, 0x87,
  0x12, 0x10, 0x9C, 0x01, 0x24, 0x0C, 0x97, 0x81, 0xDF, 0x16, 0x0B, 0x94, 0x89, 0x02, 0x10, 0x9C,
  0x01, 0x20, 0xCF, 0x87, 0x17, 0x86, 0xBD, 0x67, 0x94, 0x0A, 0x0D, 0x70, 0xC9, 0x78, 0x1E, 0xF2,
  0x30,
  // "•" (U+2022)
  0x18, 0x4A, 0xED, 0x40, 0x7B, 0x81, 0xE0, 0x9C, 0x01, 0x07, 0xB0, 0xE2, 0x82, 0xAE, 0xD4, 0x10,
  // "…" (U+2026)
  0x81, 0x3C, 0x92, 0x81, 0x3C, 0x93, 0x82, 0x3C, 0x99, 0xA2, 0x09, 0xA3, 0x09, 0xA8, 0x14, 0xEB,
  0x28, 0x14, 0xEB, 0x38, 0x14, 0xEB,
  // "‰" (U+2030)
  0x28, 0x2A, 0xEE, 0x85, 0x81, 0xBE, 0x17, 0x48, 0x48, 0xFD, 0xEF, 0x63, 0x81, 0x4F, 0x77, 0x58,
  0x4E, 0xE0, 0x1F, 0xC3, 0x0C, 0x0D, 0x76, 0x90, 0xA2, 0x0B, 0x0E, 0x28, 0x16, 0xF5, 0x75, 0x81,
  0x1F, 0x92, 0x0B, 0x92, 0x83, 0xEC, 0x01, 0x15, 0x00, 0x14, 0x90, 0xB2, 0x85, 0xCE, 0x08, 0xF4,
  0xBA, 0x0B, 0x30, 0x9A, 0x0C, 0x01, 0x28, 0xA4, 0xCE, 0x24, 0xFB, 0x2F, 0xA7, 0xF9, 0x8F, 0x80,
  0x5F, 0xA7, 0xFA, 0x20, 0x5C, 0x84, 0x4A, 0xF2, 0xCE, 0x28, 0x90, 0xCE, 0x0A, 0xF1, 0x0A, 0xF1,
  0x28, 0x90, 0x5A, 0xA4, 0x3F, 0x80, 0xEC, 0x28, 0x3A, 0xF0, 0xCE, 0x28, 0x18, 0xF2, 0x68, 0x4C,
  0xE1, 0x0F, 0xB2, 0x83, 0x9F, 0x2D, 0xD2, 0x81, 0x7F, 0x35, 0x81, 0x5F, 0x62, 0x0E, 0x0C, 0x28,
  0x3A, 0xF0, 0xCE, 0x28, 0x19, 0xF2, 0x50, 0xD0, 0xC3, 0x89, 0x3B, 0xF1, 0x0E, 0xD0, 0x9F, 0x30,
  0xDE, 0x58, 0x17, 0xF4, 0x38, 0x93, 0x5F, 0xED, 0xF7, 0x03, 0xFE, 0xDF, 0x94, 0x81, 0x1E, 0xB5,
  0x82, 0x7E, 0xE9, 0x38, 0x36, 0xEE, 0xA1, 0x10,
  // "‹" (U+2039)
  0x40, 0x64, 0x81, 0xAF, 0x72, 0x81, 0x7F, 0xB2, 0x87, 0x5F, 0xD1, 0x01, 0xEF, 0x33, 0x81, 0x9F,
  0xA4, 0x81, 0xBF, 0x73, 0x82, 0x1D, 0xF4, 0x38, 0x12, 0xB3,
  // "›" (U+203A)
  0x02, 0x04, 0x38, 0x1D, 0xF3, 0x28, 0x23, 0xFE, 0x12, 0x81, 0x5F, 0xC3, 0x89, 0x6A, 0xF9, 0x02,
  0xEE, 0x31, 0xDF, 0x50, 0xBF, 0x72, 0x07, 0x09, 0x30,
  // "⁄" (U+2044)
  0x71, 0x81, 0xAF, 0x27, 0x81, 0x3F, 0x77, 0x10, 0xC0, 0xD7, 0x18, 0x17, 0xF4, 0x78, 0x11, 0xEA,
  0x71, 0x81, 0xAE, 0x17, 0x81, 0x4F, 0x77, 0x10, 0x0D, 0x71, 0x81, 0x7F, 0x37, 0x81, 0x1E, 0xA7,
  0x18, 0x1A, 0xE1, 0x78, 0x14, 0xF6, 0x71, 0x0D, 0x0C, 0x71, 0x81, 0x7F, 0x37, 0x10,
  // "™" (U+2122)
  0x87, 0x9E, 0xEE, 0xE9, 0x7E, 0x73, 0x89, 0x1D, 0xE1, 0x1A, 0xA1, 0x17, 0xED, 0x20, 0x40, 0xE9,
  0x20, 0x09, 0x28, 0x57, 0xBE, 0x30, 0xAA, 0x92, 0x00, 0x92, 0x85, 0x7A, 0x98, 0x0E, 0x59, 0x20,
  0x09, 0x28, 0x57, 0xA4, 0xE6, 0xA4, 0x92, 0x00, 0x92, 0x85, 0x7A, 0x0E, 0xE4, 0x49, 0x20, 0x09,
  0x28, 0x57, 0xA0, 0x8E, 0x04, 0x92, 0x00, 0x13, 0x01, 0x20, 0x12, 0x01,
  // "⅒" (U+2152)
  0x18, 0x23, 0xEF, 0x14, 0x81, 0xAF, 0x27, 0x18, 0x37, 0xFE, 0xF1, 0x38, 0x13, 0xF7, 0x72, 0x83,
  0xD7, 0x9F, 0x13, 0x0C, 0x0D, 0x75, 0x81, 0x9F, 0x12, 0x81, 0x7F, 0x47, 0x58, 0x59, 0xF1, 0x01,
  0xEA, 0x76, 0x89, 0x19, 0xF1, 0x0A, 0xE1, 0x3E, 0xF1, 0x30, 0x25, 0x89, 0x49, 0xF1, 0x4F, 0x77,
  0xFE, 0xF1, 0x06, 0xEA, 0x07, 0x38, 0xA0, 0x9F, 0x1D, 0xD1, 0xD7, 0x9F, 0x11, 0xFD, 0x6C, 0xF3,
  0x28, 0x39, 0xF8, 0xF3, 0x38, 0x90, 0x9F, 0x16, 0xF5, 0x02, 0xF9, 0x38, 0x11, 0xEA, 0x48, 0x49,
  0xF1, 0x8F, 0x22, 0x90, 0xB3, 0x81, 0xAE, 0x14, 0x84, 0x9F, 0x18, 0xF2, 0x29, 0x0B, 0x28, 0x14,
  0xF6, 0x58, 0x90, 0x9F, 0x17, 0xF4, 0x01, 0xF9, 0x20, 0xD0, 0xC6, 0x89, 0x49, 0xF1, 0x2F, 0xB3,
  0xAF, 0x40, 0x7F, 0x36, 0x83, 0x9F, 0x10, 0x8B, 0x0A, 0x77, 0x28, 0x12, 0x43, 0x20,
  // "ﬁ" (U+FB01)
  0x38, 0x66, 0xCE, 0xEA, 0x4E, 0xA2, 0x06, 0xA8, 0x4C, 0xC9, 0x5F, 0xC2, 0x81, 0xCF, 0x74, 0x01,
  0x38, 0x1D, 0xF4, 0x60, 0x40, 0xCC, 0x89, 0x6E, 0x05, 0xFC, 0x7B, 0xEF, 0xCB, 0xA0, 0x5F, 0xC2,
  0x81, 0xDF, 0x43, 0x81, 0x5F, 0xC2, 0x81, 0xDF, 0x43, 0x81, 0x5F, 0xC2, 0x81, 0xDF, 0x43, 0x81,
  0x5F, 0xC2, 0x81, 0xDF, 0x43, 0x81, 0x5F, 0xC2, 0x81, 0xDF, 0x43, 0x81, 0x5F, 0xC2, 0x81, 0xDF,
  0x43, 0x81, 0x5F, 0xC2, 0x81, 0xDF, 0x43, 0x81, 0x5F, 0xC2, 0x81, 0xDF, 0x43, 0x81, 0x5F, 0xC2,
  0x81, 0xDF, 0x43, 0x81, 0x5F, 0xC0,
  // "ﬂ" (U+FB02)
  0x38, 0x66, 0xCE, 0xEA, 0x5F, 0xC2, 0x06, 0xA8, 0x4C, 0xC9, 0x5F, 0xC2, 0x81, 0xCF, 0x73, 0x81,
  0x5F, 0xC2, 0x81, 0xDF, 0x43, 0x83, 0x5F, 0xC4, 0xCC, 0x89, 0x6E, 0x05, 0xFC, 0x7B, 0xEF, 0xCB,
  0xA0, 0x5F, 0xC2, 0x81, 0xDF, 0x43, 0x81, 0x5F, 0xC2, 0x81, 0xDF, 0x43, 0x81, 0x5F, 0xC2, 0x81,
  0xDF, 0x43, 0x81, 0x5F, 0xC2, 0x81, 0xDF, 0x43, 0x81, 0x5F, 0xC2, 0x81, 0xDF, 0x43, 0x81, 0x5F,
  0xC2, 0x81, 0xDF, 0x43, 0x81, 0x5F, 0xC2, 0x81, 0xDF, 0x43, 0x81, 0x5F, 0xC2, 0x81, 0xDF, 0x43,
  0x81, 0x5F, 0xC2, 0x81, 0xDF, 0x43, 0x81, 0x5F, 0xC0,
};

const Font& font_NotoSans_Medium_20() {
  static SmoothFont font(font_NotoSans_Medium_20_data);
  return font;
}

}  // namespace roo_display
