#include "21.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedMedium (Noto Sans Condensed Medium)
// Generated on Thu Mar 30 23:43:28 CEST 2023
static const uint8_t font_NotoSans_CondensedMedium_21_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x06, 0x12,
  0xFC, 0xFB, 0x15, 0x16, 0x10, 0xFB, 0x07, 0x02, 0x16, 0x05, 0x05, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x01, 0x01, 0x03, 0x10, 0x05, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x01, 0x0B, 0x07, 0x10, 0x09, 0x00, 0x18, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x0A, 0x10, 0x0B, 0x00, 0x2F, // "#" (U+0023)
  0x00, 0x24, 0x01, 0xFF, 0x09, 0x10, 0x0A, 0x00, 0x7B, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x0E, 0x10, 0x10, 0x00, 0xC1, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x0B, 0x10, 0x0C, 0x01, 0x38, // "&" (U+0026)
  0x00, 0x27, 0x01, 0x0B, 0x03, 0x10, 0x05, 0x01, 0x90, // "'" (U+0027)
  0x00, 0x28, 0x01, 0xFE, 0x05, 0x10, 0x06, 0x01, 0x9B, // "(" (U+0028)
  0x00, 0x29, 0x00, 0xFE, 0x05, 0x10, 0x06, 0x01, 0xCC, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x08, 0x08, 0x10, 0x0A, 0x02, 0x05, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x04, 0x09, 0x0D, 0x0A, 0x02, 0x2C, // "+" (U+002B)
  0x00, 0x2C, 0x00, 0xFE, 0x03, 0x02, 0x05, 0x02, 0x4D, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x06, 0x05, 0x07, 0x06, 0x02, 0x59, // "-" (U+002D)
  0x00, 0x2E, 0x01, 0x01, 0x03, 0x03, 0x05, 0x02, 0x5F, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x07, 0x10, 0x08, 0x02, 0x65, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x09, 0x10, 0x0A, 0x02, 0x95, // "0" (U+0030)
  0x00, 0x31, 0x01, 0x01, 0x06, 0x10, 0x0A, 0x02, 0xE3, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x09, 0x10, 0x0A, 0x03, 0x14, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x08, 0x10, 0x0A, 0x03, 0x4E, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x09, 0x10, 0x0A, 0x03, 0x8E, // "4" (U+0034)
  0x00, 0x35, 0x01, 0x01, 0x09, 0x10, 0x0A, 0x03, 0xCB, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x09, 0x10, 0x0A, 0x04, 0x06, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x09, 0x10, 0x0A, 0x04, 0x4D, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x09, 0x10, 0x0A, 0x04, 0x7F, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x09, 0x10, 0x0A, 0x04, 0xD2, // "9" (U+0039)
  0x00, 0x3A, 0x01, 0x01, 0x03, 0x0C, 0x05, 0x05, 0x19, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0xFF, 0x03, 0x0C, 0x05, 0x05, 0x26, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x03, 0x09, 0x0D, 0x0A, 0x05, 0x3B, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x06, 0x09, 0x0B, 0x0A, 0x05, 0x63, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x03, 0x09, 0x0D, 0x0A, 0x05, 0x72, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x07, 0x10, 0x08, 0x05, 0x9B, // "?" (U+003F)
  0x00, 0x40, 0x01, 0xFF, 0x0E, 0x10, 0x10, 0x05, 0xCD, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x0A, 0x10, 0x0B, 0x06, 0x43, // "A" (U+0041)
  0x00, 0x42, 0x01, 0x01, 0x0A, 0x10, 0x0B, 0x06, 0x86, // "B" (U+0042)
  0x00, 0x43, 0x01, 0x01, 0x09, 0x10, 0x0B, 0x06, 0xD4, // "C" (U+0043)
  0x00, 0x44, 0x01, 0x01, 0x0B, 0x10, 0x0C, 0x07, 0x0F, // "D" (U+0044)
  0x00, 0x45, 0x01, 0x01, 0x08, 0x10, 0x0A, 0x07, 0x60, // "E" (U+0045)
  0x00, 0x46, 0x01, 0x01, 0x08, 0x10, 0x09, 0x07, 0x92, // "F" (U+0046)
  0x00, 0x47, 0x01, 0x01, 0x0B, 0x10, 0x0D, 0x07, 0xC3, // "G" (U+0047)
  0x00, 0x48, 0x01, 0x01, 0x0B, 0x10, 0x0D, 0x08, 0x0F, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x05, 0x10, 0x07, 0x08, 0x50, // "I" (U+0049)
  0x00, 0x4A, 0xFE, 0xFD, 0x03, 0x10, 0x05, 0x08, 0x81, // "J" (U+004A)
  0x00, 0x4B, 0x01, 0x01, 0x0A, 0x10, 0x0B, 0x08, 0xBE, // "K" (U+004B)
  0x00, 0x4C, 0x01, 0x01, 0x08, 0x10, 0x09, 0x09, 0x0F, // "L" (U+004C)
  0x00, 0x4D, 0x01, 0x01, 0x0E, 0x10, 0x11, 0x09, 0x40, // "M" (U+004D)
  0x00, 0x4E, 0x01, 0x01, 0x0B, 0x10, 0x0D, 0x09, 0xB2, // "N" (U+004E)
  0x00, 0x4F, 0x01, 0x01, 0x0C, 0x10, 0x0D, 0x0A, 0x0B, // "O" (U+004F)
  0x00, 0x50, 0x01, 0x01, 0x09, 0x10, 0x0B, 0x0A, 0x63, // "P" (U+0050)
  0x00, 0x51, 0x01, 0xFD, 0x0C, 0x10, 0x0D, 0x0A, 0xA4, // "Q" (U+0051)
  0x00, 0x52, 0x01, 0x01, 0x0A, 0x10, 0x0B, 0x0B, 0x0A, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x08, 0x10, 0x0A, 0x0B, 0x5D, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x09, 0x10, 0x09, 0x0B, 0x9A, // "T" (U+0054)
  0x00, 0x55, 0x01, 0x01, 0x0A, 0x10, 0x0D, 0x0B, 0xCE, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x0A, 0x10, 0x0B, 0x0C, 0x19, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x10, 0x10, 0x11, 0x0C, 0x64, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x09, 0x10, 0x0A, 0x0C, 0xE6, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x09, 0x10, 0x0A, 0x0D, 0x30, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x08, 0x10, 0x09, 0x0D, 0x6A, // "Z" (U+005A)
  0x00, 0x5B, 0x01, 0xFE, 0x06, 0x10, 0x07, 0x0D, 0x9E, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x07, 0x10, 0x08, 0x0D, 0xD7, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0xFE, 0x05, 0x10, 0x07, 0x0E, 0x06, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x08, 0x09, 0x10, 0x0A, 0x0E, 0x3F, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFE, 0x09, 0xFF, 0x09, 0x0E, 0x67, // "_" (U+005F)
  0x00, 0x60, 0x01, 0x0E, 0x05, 0x11, 0x06, 0x0E, 0x6C, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x08, 0x0C, 0x0A, 0x0E, 0x78, // "a" (U+0061)
  0x00, 0x62, 0x01, 0x01, 0x09, 0x10, 0x0B, 0x0E, 0xAF, // "b" (U+0062)
  0x00, 0x63, 0x01, 0x01, 0x07, 0x0C, 0x08, 0x0E, 0xF4, // "c" (U+0063)
  0x00, 0x64, 0x01, 0x01, 0x09, 0x10, 0x0B, 0x0F, 0x1B, // "d" (U+0064)
  0x00, 0x65, 0x01, 0x01, 0x08, 0x0C, 0x0A, 0x0F, 0x5E, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x06, 0x10, 0x06, 0x0F, 0x8A, // "f" (U+0066)
  0x00, 0x67, 0x01, 0xFC, 0x09, 0x0C, 0x0B, 0x0F, 0xBE, // "g" (U+0067)
  0x00, 0x68, 0x01, 0x01, 0x09, 0x10, 0x0B, 0x10, 0x0B, // "h" (U+0068)
  0x00, 0x69, 0x01, 0x01, 0x03, 0x10, 0x05, 0x10, 0x50, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xFC, 0x03, 0x10, 0x05, 0x10, 0x6A, // "j" (U+006A)
  0x00, 0x6B, 0x01, 0x01, 0x09, 0x10, 0x0A, 0x10, 0xA6, // "k" (U+006B)
  0x00, 0x6C, 0x01, 0x01, 0x03, 0x10, 0x05, 0x10, 0xEE, // "l" (U+006C)
  0x00, 0x6D, 0x01, 0x01, 0x0E, 0x0C, 0x10, 0x11, 0x08, // "m" (U+006D)
  0x00, 0x6E, 0x01, 0x01, 0x09, 0x0C, 0x0B, 0x11, 0x64, // "n" (U+006E)
  0x00, 0x6F, 0x01, 0x01, 0x09, 0x0C, 0x0B, 0x11, 0x9D, // "o" (U+006F)
  0x00, 0x70, 0x01, 0xFC, 0x09, 0x0C, 0x0B, 0x11, 0xD6, // "p" (U+0070)
  0x00, 0x71, 0x01, 0xFC, 0x09, 0x0C, 0x0B, 0x12, 0x1D, // "q" (U+0071)
  0x00, 0x72, 0x01, 0x01, 0x06, 0x0C, 0x07, 0x12, 0x64, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x12, 0x89, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x06, 0x0F, 0x06, 0x12, 0xB8, // "t" (U+0074)
  0x00, 0x75, 0x01, 0x01, 0x09, 0x0C, 0x0B, 0x12, 0xE8, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x13, 0x20, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x0D, 0x0C, 0x0E, 0x13, 0x52, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x08, 0x0C, 0x09, 0x13, 0xA9, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFC, 0x08, 0x0C, 0x09, 0x13, 0xDD, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x07, 0x0C, 0x08, 0x14, 0x1F, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFE, 0x06, 0x10, 0x08, 0x14, 0x46, // "{" (U+007B)
  0x00, 0x7C, 0x03, 0xFC, 0x05, 0x10, 0x09, 0x14, 0x80, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0xFE, 0x07, 0x10, 0x08, 0x14, 0xA1, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x07, 0x09, 0x09, 0x0A, 0x14, 0xDE, // "~" (U+007E)
  0x00, 0xA1, 0x01, 0xFD, 0x03, 0x0C, 0x05, 0x14, 0xF0, // "¡" (U+00A1)
  0x00, 0xA2, 0x01, 0x01, 0x08, 0x10, 0x0A, 0x15, 0x08, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x09, 0x10, 0x0A, 0x15, 0x39, // "£" (U+00A3)
  0x00, 0xA4, 0x01, 0x03, 0x0A, 0x0D, 0x0C, 0x15, 0x74, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x09, 0x10, 0x0A, 0x15, 0xAB, // "¥" (U+00A5)
  0x00, 0xA6, 0x03, 0xFC, 0x05, 0x10, 0x09, 0x15, 0xF1, // "¦" (U+00A6)
  0x00, 0xA7, 0x01, 0x01, 0x07, 0x10, 0x09, 0x16, 0x0E, // "§" (U+00A7)
  0x00, 0xA8, 0x02, 0x0F, 0x08, 0x10, 0x0B, 0x16, 0x4A, // "¨" (U+00A8)
  0x00, 0xA9, 0x01, 0x01, 0x10, 0x10, 0x11, 0x16, 0x53, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x0A, 0x05, 0x0F, 0x07, 0x16, 0xC9, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x02, 0x09, 0x0A, 0x0A, 0x16, 0xDD, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x04, 0x09, 0x09, 0x0A, 0x17, 0x0D, // "¬" (U+00AC)
  0x00, 0xAE, 0x01, 0x01, 0x10, 0x10, 0x11, 0x17, 0x20, // "®" (U+00AE)
  0x00, 0xAF, 0xFF, 0x12, 0x09, 0x13, 0x0A, 0x17, 0x9E, // "¯" (U+00AF)
  0x00, 0xB0, 0x01, 0x0B, 0x07, 0x11, 0x08, 0x17, 0xA5, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x09, 0x0D, 0x0A, 0x17, 0xC0, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x09, 0x06, 0x13, 0x07, 0x17, 0xE8, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x09, 0x06, 0x13, 0x07, 0x18, 0x0A, // "³" (U+00B3)
  0x00, 0xB4, 0x00, 0x0E, 0x04, 0x11, 0x06, 0x18, 0x2F, // "´" (U+00B4)
  0x00, 0xB5, 0x01, 0xFC, 0x09, 0x0C, 0x0B, 0x18, 0x3A, // "µ" (U+00B5)
  0x00, 0xB6, 0x01, 0xFD, 0x09, 0x10, 0x0B, 0x18, 0x81, // "¶" (U+00B6)
  0x00, 0xB7, 0x01, 0x07, 0x03, 0x09, 0x05, 0x18, 0xD4, // "·" (U+00B7)
  0x00, 0xB8, 0x00, 0xFB, 0x03, 0x00, 0x04, 0x18, 0xDA, // "¸" (U+00B8)
  0x00, 0xB9, 0x01, 0x0A, 0x04, 0x12, 0x07, 0x18, 0xE8, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x08, 0x06, 0x0F, 0x07, 0x18, 0xFF, // "º" (U+00BA)
  0x00, 0xBB, 0x01, 0x02, 0x09, 0x0A, 0x0A, 0x19, 0x1B, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x0F, 0x0F, 0x10, 0x19, 0x47, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x0F, 0x0F, 0x10, 0x19, 0xAE, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x0F, 0x10, 0x10, 0x1A, 0x10, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFC, 0x07, 0x0B, 0x08, 0x1A, 0x82, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x0A, 0x15, 0x0B, 0x1A, 0xB5, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x0A, 0x15, 0x0B, 0x1B, 0x06, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x0A, 0x15, 0x0B, 0x1B, 0x56, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x0A, 0x14, 0x0B, 0x1B, 0xAA, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x0A, 0x14, 0x0B, 0x1B, 0xFD, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x0A, 0x13, 0x0B, 0x1C, 0x4B, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x0D, 0x10, 0x0F, 0x1C, 0x9A, // "Æ" (U+00C6)
  0x00, 0xC7, 0x01, 0xFB, 0x09, 0x10, 0x0B, 0x1C, 0xF0, // "Ç" (U+00C7)
  0x00, 0xC8, 0x01, 0x01, 0x08, 0x15, 0x0A, 0x1D, 0x3E, // "È" (U+00C8)
  0x00, 0xC9, 0x01, 0x01, 0x08, 0x15, 0x0A, 0x1D, 0x7D, // "É" (U+00C9)
  0x00, 0xCA, 0x01, 0x01, 0x08, 0x15, 0x0A, 0x1D, 0xBC, // "Ê" (U+00CA)
  0x00, 0xCB, 0x01, 0x01, 0x08, 0x14, 0x0A, 0x1E, 0x00, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x05, 0x15, 0x07, 0x1E, 0x3D, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x06, 0x15, 0x07, 0x1E, 0x7A, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x06, 0x15, 0x07, 0x1E, 0xBA, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x06, 0x14, 0x07, 0x1E, 0xFD, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x0B, 0x10, 0x0C, 0x1F, 0x39, // "Ð" (U+00D0)
  0x00, 0xD1, 0x01, 0x01, 0x0B, 0x14, 0x0D, 0x1F, 0x95, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x01, 0x01, 0x0C, 0x15, 0x0D, 0x1F, 0xFE, // "Ò" (U+00D2)
  0x00, 0xD3, 0x01, 0x01, 0x0C, 0x15, 0x0D, 0x20, 0x65, // "Ó" (U+00D3)
  0x00, 0xD4, 0x01, 0x01, 0x0C, 0x15, 0x0D, 0x20, 0xCC, // "Ô" (U+00D4)
  0x00, 0xD5, 0x01, 0x01, 0x0C, 0x14, 0x0D, 0x21, 0x36, // "Õ" (U+00D5)
  0x00, 0xD6, 0x01, 0x01, 0x0C, 0x14, 0x0D, 0x21, 0x9E, // "Ö" (U+00D6)
  0x00, 0xD7, 0x01, 0x04, 0x08, 0x0C, 0x0A, 0x22, 0x02, // "×" (U+00D7)
  0x00, 0xD8, 0x01, 0x00, 0x0C, 0x11, 0x0D, 0x22, 0x27, // "Ø" (U+00D8)
  0x00, 0xD9, 0x01, 0x01, 0x0A, 0x15, 0x0D, 0x22, 0x93, // "Ù" (U+00D9)
  0x00, 0xDA, 0x01, 0x01, 0x0A, 0x15, 0x0D, 0x22, 0xEC, // "Ú" (U+00DA)
  0x00, 0xDB, 0x01, 0x01, 0x0A, 0x15, 0x0D, 0x23, 0x44, // "Û" (U+00DB)
  0x00, 0xDC, 0x01, 0x01, 0x0A, 0x14, 0x0D, 0x23, 0xA1, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x09, 0x15, 0x0A, 0x23, 0xF8, // "Ý" (U+00DD)
  0x00, 0xDE, 0x01, 0x01, 0x09, 0x10, 0x0A, 0x24, 0x3F, // "Þ" (U+00DE)
  0x00, 0xDF, 0x01, 0x01, 0x0A, 0x10, 0x0B, 0x24, 0x7D, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x08, 0x11, 0x0A, 0x24, 0xD1, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x08, 0x11, 0x0A, 0x25, 0x15, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x08, 0x11, 0x0A, 0x25, 0x59, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x08, 0x10, 0x0A, 0x25, 0xA1, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x08, 0x10, 0x0A, 0x25, 0xE7, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x08, 0x12, 0x0A, 0x26, 0x29, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x0E, 0x0C, 0x0F, 0x26, 0x74, // "æ" (U+00E6)
  0x00, 0xE7, 0x01, 0xFB, 0x07, 0x0C, 0x08, 0x26, 0xCA, // "ç" (U+00E7)
  0x00, 0xE8, 0x01, 0x01, 0x08, 0x11, 0x0A, 0x27, 0x03, // "è" (U+00E8)
  0x00, 0xE9, 0x01, 0x01, 0x08, 0x11, 0x0A, 0x27, 0x3B, // "é" (U+00E9)
  0x00, 0xEA, 0x01, 0x01, 0x08, 0x11, 0x0A, 0x27, 0x73, // "ê" (U+00EA)
  0x00, 0xEB, 0x01, 0x01, 0x08, 0x10, 0x0A, 0x27, 0xB0, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x04, 0x11, 0x05, 0x27, 0xE6, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x04, 0x11, 0x05, 0x28, 0x16, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x05, 0x11, 0x05, 0x28, 0x46, // "î" (U+00EE)
  0x00, 0xEF, 0xFF, 0x01, 0x05, 0x10, 0x05, 0x28, 0x7B, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x09, 0x11, 0x0B, 0x28, 0xA9, // "ð" (U+00F0)
  0x00, 0xF1, 0x01, 0x01, 0x09, 0x10, 0x0B, 0x28, 0xF7, // "ñ" (U+00F1)
  0x00, 0xF2, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x29, 0x3F, // "ò" (U+00F2)
  0x00, 0xF3, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x29, 0x84, // "ó" (U+00F3)
  0x00, 0xF4, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x29, 0xC9, // "ô" (U+00F4)
  0x00, 0xF5, 0x01, 0x01, 0x09, 0x10, 0x0B, 0x2A, 0x13, // "õ" (U+00F5)
  0x00, 0xF6, 0x01, 0x01, 0x09, 0x10, 0x0B, 0x2A, 0x5B, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x03, 0x09, 0x0D, 0x0A, 0x2A, 0x9F, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x09, 0x0D, 0x0B, 0x2A, 0xB9, // "ø" (U+00F8)
  0x00, 0xF9, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x2A, 0xFF, // "ù" (U+00F9)
  0x00, 0xFA, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x2B, 0x44, // "ú" (U+00FA)
  0x00, 0xFB, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x2B, 0x89, // "û" (U+00FB)
  0x00, 0xFC, 0x01, 0x01, 0x09, 0x10, 0x0B, 0x2B, 0xD3, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFC, 0x08, 0x11, 0x09, 0x2C, 0x17, // "ý" (U+00FD)
  0x00, 0xFE, 0x01, 0xFC, 0x09, 0x10, 0x0B, 0x2C, 0x66, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFC, 0x08, 0x10, 0x09, 0x2C, 0xB9, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x0A, 0x13, 0x0B, 0x2D, 0x07, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x08, 0x0F, 0x0A, 0x2D, 0x52, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x0A, 0x14, 0x0B, 0x2D, 0x91, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x08, 0x10, 0x0A, 0x2D, 0xE3, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFC, 0x0B, 0x10, 0x0B, 0x2E, 0x29, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFC, 0x09, 0x0C, 0x0A, 0x2E, 0x7F, // "ą" (U+0105)
  0x01, 0x06, 0x01, 0x01, 0x09, 0x15, 0x0B, 0x2E, 0xC8, // "Ć" (U+0106)
  0x01, 0x07, 0x01, 0x01, 0x07, 0x11, 0x08, 0x2F, 0x10, // "ć" (U+0107)
  0x01, 0x08, 0x01, 0x01, 0x0A, 0x15, 0x0B, 0x2F, 0x43, // "Ĉ" (U+0108)
  0x01, 0x09, 0x01, 0x01, 0x08, 0x11, 0x08, 0x2F, 0x92, // "ĉ" (U+0109)
  0x01, 0x0A, 0x01, 0x01, 0x09, 0x15, 0x0B, 0x2F, 0xCD, // "Ċ" (U+010A)
  0x01, 0x0B, 0x01, 0x01, 0x07, 0x11, 0x08, 0x30, 0x11, // "ċ" (U+010B)
  0x01, 0x0C, 0x01, 0x01, 0x0A, 0x15, 0x0B, 0x30, 0x40, // "Č" (U+010C)
  0x01, 0x0D, 0x01, 0x01, 0x08, 0x11, 0x08, 0x30, 0x90, // "č" (U+010D)
  0x01, 0x0E, 0x01, 0x01, 0x0B, 0x15, 0x0C, 0x30, 0xCA, // "Ď" (U+010E)
  0x01, 0x0F, 0x01, 0x01, 0x0C, 0x10, 0x0B, 0x31, 0x2D, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x0B, 0x10, 0x0C, 0x31, 0x80, // "Đ" (U+0110)
  0x01, 0x11, 0x01, 0x01, 0x0A, 0x10, 0x0B, 0x31, 0xDC, // "đ" (U+0111)
  0x01, 0x12, 0x01, 0x01, 0x08, 0x13, 0x0A, 0x32, 0x2A, // "Ē" (U+0112)
  0x01, 0x13, 0x01, 0x01, 0x08, 0x0F, 0x0A, 0x32, 0x64, // "ē" (U+0113)
  0x01, 0x14, 0x01, 0x01, 0x08, 0x14, 0x0A, 0x32, 0x97, // "Ĕ" (U+0114)
  0x01, 0x15, 0x01, 0x01, 0x08, 0x10, 0x0A, 0x32, 0xD8, // "ĕ" (U+0115)
  0x01, 0x16, 0x01, 0x01, 0x08, 0x15, 0x0A, 0x33, 0x12, // "Ė" (U+0116)
  0x01, 0x17, 0x01, 0x01, 0x08, 0x11, 0x0A, 0x33, 0x4D, // "ė" (U+0117)
  0x01, 0x18, 0x01, 0xFC, 0x08, 0x10, 0x0A, 0x33, 0x81, // "Ę" (U+0118)
  0x01, 0x19, 0x01, 0xFC, 0x08, 0x0C, 0x0A, 0x33, 0xC2, // "ę" (U+0119)
  0x01, 0x1A, 0x01, 0x01, 0x08, 0x15, 0x0A, 0x33, 0xFB, // "Ě" (U+011A)
  0x01, 0x1B, 0x01, 0x01, 0x08, 0x11, 0x0A, 0x34, 0x3E, // "ě" (U+011B)
  0x01, 0x1C, 0x01, 0x01, 0x0B, 0x15, 0x0D, 0x34, 0x7A, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x01, 0xFC, 0x09, 0x11, 0x0B, 0x34, 0xD7, // "ĝ" (U+011D)
  0x01, 0x1E, 0x01, 0x01, 0x0B, 0x14, 0x0D, 0x35, 0x35, // "Ğ" (U+011E)
  0x01, 0x1F, 0x01, 0xFC, 0x09, 0x10, 0x0B, 0x35, 0x90, // "ğ" (U+011F)
  0x01, 0x20, 0x01, 0x01, 0x0B, 0x15, 0x0D, 0x35, 0xEB, // "Ġ" (U+0120)
  0x01, 0x21, 0x01, 0xFC, 0x09, 0x11, 0x0B, 0x36, 0x41, // "ġ" (U+0121)
  0x01, 0x22, 0x01, 0xFC, 0x0B, 0x10, 0x0D, 0x36, 0x97, // "Ģ" (U+0122)
  0x01, 0x23, 0x01, 0xFC, 0x09, 0x10, 0x0B, 0x36, 0xED, // "ģ" (U+0123)
  0x01, 0x24, 0x01, 0x01, 0x0B, 0x15, 0x0D, 0x37, 0x43, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x09, 0x16, 0x0B, 0x37, 0x96, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x0C, 0x10, 0x0D, 0x37, 0xFD, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x09, 0x10, 0x0B, 0x38, 0x4C, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x06, 0x14, 0x07, 0x38, 0x99, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFE, 0x01, 0x05, 0x10, 0x05, 0x38, 0xDB, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x06, 0x13, 0x07, 0x39, 0x0D, // "Ī" (U+012A)
  0x01, 0x2B, 0xFF, 0x01, 0x05, 0x0F, 0x05, 0x39, 0x47, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x06, 0x14, 0x07, 0x39, 0x73, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFF, 0x01, 0x05, 0x10, 0x05, 0x39, 0xB3, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFC, 0x06, 0x10, 0x07, 0x39, 0xE4, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFC, 0x04, 0x10, 0x05, 0x3A, 0x24, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x05, 0x15, 0x07, 0x3A, 0x5F, // "İ" (U+0130)
  0x01, 0x31, 0x01, 0x01, 0x03, 0x0C, 0x05, 0x3A, 0x98, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0xFD, 0x09, 0x10, 0x0C, 0x3A, 0xAC, // "Ĳ" (U+0132)
  0x01, 0x33, 0x01, 0xFC, 0x08, 0x10, 0x0A, 0x3B, 0x18, // "ĳ" (U+0133)
  0x01, 0x34, 0xFE, 0xFD, 0x06, 0x15, 0x05, 0x3B, 0x70, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFC, 0x05, 0x11, 0x05, 0x3B, 0xC0, // "ĵ" (U+0135)
  0x01, 0x36, 0x01, 0xFC, 0x0A, 0x10, 0x0B, 0x3C, 0x05, // "Ķ" (U+0136)
  0x01, 0x37, 0x01, 0xFC, 0x09, 0x10, 0x0A, 0x3C, 0x60, // "ķ" (U+0137)
  0x01, 0x38, 0x01, 0x01, 0x09, 0x0C, 0x0A, 0x3C, 0xB1, // "ĸ" (U+0138)
  0x01, 0x39, 0x01, 0x01, 0x08, 0x15, 0x09, 0x3C, 0xED, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x04, 0x16, 0x05, 0x3D, 0x2B, // "ĺ" (U+013A)
  0x01, 0x3B, 0x01, 0xFC, 0x08, 0x10, 0x09, 0x3D, 0x67, // "Ļ" (U+013B)
  0x01, 0x3C, 0x01, 0xFC, 0x03, 0x10, 0x05, 0x3D, 0xA1, // "ļ" (U+013C)
  0x01, 0x3D, 0x01, 0x01, 0x08, 0x10, 0x09, 0x3D, 0xC0, // "Ľ" (U+013D)
  0x01, 0x3E, 0x01, 0x01, 0x06, 0x10, 0x05, 0x3D, 0xF5, // "ľ" (U+013E)
  0x01, 0x3F, 0x01, 0x01, 0x08, 0x10, 0x09, 0x3E, 0x26, // "Ŀ" (U+013F)
  0x01, 0x40, 0x01, 0x01, 0x07, 0x10, 0x06, 0x3E, 0x5C, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x08, 0x10, 0x09, 0x3E, 0x8F, // "Ł" (U+0141)
  0x01, 0x42, 0xFF, 0x01, 0x05, 0x10, 0x05, 0x3E, 0xC7, // "ł" (U+0142)
  0x01, 0x43, 0x01, 0x01, 0x0B, 0x15, 0x0D, 0x3E, 0xFB, // "Ń" (U+0143)
  0x01, 0x44, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x3F, 0x62, // "ń" (U+0144)
  0x01, 0x45, 0x01, 0xFC, 0x0B, 0x10, 0x0D, 0x3F, 0xA8, // "Ņ" (U+0145)
  0x01, 0x46, 0x01, 0xFC, 0x09, 0x0C, 0x0B, 0x40, 0x0B, // "ņ" (U+0146)
  0x01, 0x47, 0x01, 0x01, 0x0B, 0x15, 0x0D, 0x40, 0x4D, // "Ň" (U+0147)
  0x01, 0x48, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x40, 0xB7, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x0B, 0x10, 0x0D, 0x41, 0x01, // "ŉ" (U+0149)
  0x01, 0x4A, 0x01, 0xFD, 0x0B, 0x10, 0x0D, 0x41, 0x56, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x01, 0xFC, 0x09, 0x0C, 0x0B, 0x41, 0xBB, // "ŋ" (U+014B)
  0x01, 0x4C, 0x01, 0x01, 0x0C, 0x13, 0x0D, 0x42, 0x05, // "Ō" (U+014C)
  0x01, 0x4D, 0x01, 0x01, 0x09, 0x0F, 0x0B, 0x42, 0x66, // "ō" (U+014D)
  0x01, 0x4E, 0x01, 0x01, 0x0C, 0x14, 0x0D, 0x42, 0xA7, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x01, 0x01, 0x09, 0x10, 0x0B, 0x43, 0x0E, // "ŏ" (U+014F)
  0x01, 0x50, 0x01, 0x01, 0x0C, 0x15, 0x0D, 0x43, 0x55, // "Ő" (U+0150)
  0x01, 0x51, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x43, 0xC1, // "ő" (U+0151)
  0x01, 0x52, 0x01, 0x01, 0x0E, 0x10, 0x10, 0x44, 0x0D, // "Œ" (U+0152)
  0x01, 0x53, 0x01, 0x01, 0x0F, 0x0C, 0x10, 0x44, 0x64, // "œ" (U+0153)
  0x01, 0x54, 0x01, 0x01, 0x0A, 0x15, 0x0B, 0x44, 0xBB, // "Ŕ" (U+0154)
  0x01, 0x55, 0x01, 0x01, 0x06, 0x11, 0x07, 0x45, 0x1B, // "ŕ" (U+0155)
  0x01, 0x56, 0x01, 0xFC, 0x0A, 0x10, 0x0B, 0x45, 0x4D, // "Ŗ" (U+0156)
  0x01, 0x57, 0x01, 0xFC, 0x06, 0x0C, 0x07, 0x45, 0xA9, // "ŗ" (U+0157)
  0x01, 0x58, 0x01, 0x01, 0x0A, 0x15, 0x0B, 0x45, 0xD7, // "Ř" (U+0158)
  0x01, 0x59, 0x01, 0x01, 0x07, 0x11, 0x07, 0x46, 0x3B, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x08, 0x15, 0x0A, 0x46, 0x71, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x07, 0x11, 0x08, 0x46, 0xBA, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x08, 0x15, 0x0A, 0x46, 0xF6, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x07, 0x11, 0x08, 0x47, 0x44, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFB, 0x08, 0x10, 0x0A, 0x47, 0x84, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFB, 0x07, 0x0C, 0x08, 0x47, 0xD3, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x08, 0x15, 0x0A, 0x48, 0x14, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x07, 0x11, 0x08, 0x48, 0x62, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFB, 0x09, 0x10, 0x09, 0x48, 0xA2, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFB, 0x06, 0x0F, 0x06, 0x48, 0xE9, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x09, 0x15, 0x09, 0x49, 0x2B, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x08, 0x10, 0x06, 0x49, 0x70, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x09, 0x10, 0x09, 0x49, 0xA7, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x06, 0x0F, 0x06, 0x49, 0xDC, // "ŧ" (U+0167)
  0x01, 0x68, 0x01, 0x01, 0x0A, 0x14, 0x0D, 0x4A, 0x0D, // "Ũ" (U+0168)
  0x01, 0x69, 0x01, 0x01, 0x09, 0x10, 0x0B, 0x4A, 0x68, // "ũ" (U+0169)
  0x01, 0x6A, 0x01, 0x01, 0x0A, 0x13, 0x0D, 0x4A, 0xB0, // "Ū" (U+016A)
  0x01, 0x6B, 0x01, 0x01, 0x09, 0x0F, 0x0B, 0x4B, 0x04, // "ū" (U+016B)
  0x01, 0x6C, 0x01, 0x01, 0x0A, 0x14, 0x0D, 0x4B, 0x45, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x01, 0x01, 0x09, 0x10, 0x0B, 0x4B, 0x9F, // "ŭ" (U+016D)
  0x01, 0x6E, 0x01, 0x01, 0x0A, 0x16, 0x0D, 0x4B, 0xE6, // "Ů" (U+016E)
  0x01, 0x6F, 0x01, 0x01, 0x09, 0x12, 0x0B, 0x4C, 0x46, // "ů" (U+016F)
  0x01, 0x70, 0x01, 0x01, 0x0A, 0x15, 0x0D, 0x4C, 0x93, // "Ű" (U+0170)
  0x01, 0x71, 0x01, 0x01, 0x09, 0x11, 0x0B, 0x4C, 0xF2, // "ű" (U+0171)
  0x01, 0x72, 0x01, 0xFC, 0x0A, 0x10, 0x0D, 0x4D, 0x3E, // "Ų" (U+0172)
  0x01, 0x73, 0x01, 0xFC, 0x09, 0x0C, 0x0B, 0x4D, 0x99, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x10, 0x15, 0x11, 0x4D, 0xE0, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x0D, 0x11, 0x0E, 0x4E, 0x76, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x09, 0x15, 0x0A, 0x4E, 0xE0, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFC, 0x08, 0x11, 0x09, 0x4F, 0x2B, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x09, 0x14, 0x0A, 0x4F, 0x7F, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x08, 0x15, 0x09, 0x4F, 0xC5, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x07, 0x11, 0x08, 0x50, 0x06, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x08, 0x15, 0x09, 0x50, 0x3A, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x07, 0x11, 0x08, 0x50, 0x77, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x08, 0x15, 0x09, 0x50, 0xA7, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x07, 0x11, 0x08, 0x50, 0xEC, // "ž" (U+017E)
  0x01, 0x7F, 0x01, 0x01, 0x06, 0x10, 0x06, 0x51, 0x24, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x0C, 0x10, 0x0D, 0x51, 0x55, // "Ω" (U+03A9)
  0x03, 0xBC, 0x01, 0xFC, 0x09, 0x0C, 0x0B, 0x51, 0xB4, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x0B, 0x0C, 0x0C, 0x51, 0xFB, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x06, 0x09, 0x07, 0x0B, 0x52, 0x3A, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x06, 0x14, 0x07, 0x15, 0x52, 0x41, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x09, 0x10, 0x0A, 0x52, 0x49, // "€" (U+20AC)
  0x20, 0xBF, 0x01, 0xFF, 0x09, 0x12, 0x0A, 0x52, 0x8A, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x0C, 0x03, 0x10, 0x04, 0x52, 0xE2, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x0C, 0x03, 0x10, 0x04, 0x52, 0xEE, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0xFF, 0x03, 0x03, 0x05, 0x52, 0xFA, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x0C, 0x03, 0x10, 0x04, 0x53, 0x06, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x0C, 0x07, 0x10, 0x08, 0x53, 0x12, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x0C, 0x07, 0x10, 0x08, 0x53, 0x28, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0x00, 0x07, 0x04, 0x08, 0x53, 0x3F, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x0C, 0x07, 0x10, 0x08, 0x53, 0x56, // "‟" (U+201F)
  0x20, 0x20, 0x01, 0x01, 0x08, 0x10, 0x0A, 0x53, 0x6D, // "†" (U+2020)
  0x20, 0x21, 0x01, 0x01, 0x08, 0x10, 0x0A, 0x53, 0x98, // "‡" (U+2021)
  0x20, 0x22, 0x01, 0x06, 0x06, 0x0B, 0x08, 0x53, 0xC4, // "•" (U+2022)
  0x20, 0x26, 0x01, 0x01, 0x0D, 0x03, 0x0F, 0x53, 0xD5, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x15, 0x10, 0x16, 0x53, 0xED, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x02, 0x05, 0x0A, 0x06, 0x54, 0x8A, // "‹" (U+2039)
  0x20, 0x3A, 0x01, 0x02, 0x05, 0x0A, 0x06, 0x54, 0xA6, // "›" (U+203A)
  0x20, 0x44, 0xFC, 0x01, 0x05, 0x10, 0x02, 0x54, 0xBE, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x08, 0x0D, 0x0F, 0x0E, 0x54, 0xEB, // "™" (U+2122)
  0x21, 0x52, 0x01, 0x00, 0x15, 0x10, 0x16, 0x55, 0x29, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x09, 0x10, 0x0B, 0x55, 0xB2, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x09, 0x10, 0x0B, 0x56, 0x03, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x61, 0x01, // "a (U+0022 U+0061)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE1, 0x01, // "á (U+0022 U+00E1)
  0x00, 0x22, 0x00, 0xE2, 0x01, // "â (U+0022 U+00E2)
  0x00, 0x22, 0x00, 0xE3, 0x01, // "ã (U+0022 U+00E3)
  0x00, 0x22, 0x00, 0xE4, 0x01, // "ä (U+0022 U+00E4)
  0x00, 0x22, 0x00, 0xE5, 0x01, // "å (U+0022 U+00E5)
  0x00, 0x22, 0x00, 0xE6, 0x01, // "æ (U+0022 U+00E6)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x01, 0x01, // "ā (U+0022 U+0101)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x03, 0x01, // "ă (U+0022 U+0103)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x05, 0x01, // "ą (U+0022 U+0105)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x01, 0x62, 0x01, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x01, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x01, // &Ŧ (U+0026 U+0166)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x61, 0x01, // 'a (U+0027 U+0061)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE1, 0x01, // 'á (U+0027 U+00E1)
  0x00, 0x27, 0x00, 0xE2, 0x01, // 'â (U+0027 U+00E2)
  0x00, 0x27, 0x00, 0xE3, 0x01, // 'ã (U+0027 U+00E3)
  0x00, 0x27, 0x00, 0xE4, 0x01, // 'ä (U+0027 U+00E4)
  0x00, 0x27, 0x00, 0xE5, 0x01, // 'å (U+0027 U+00E5)
  0x00, 0x27, 0x00, 0xE6, 0x01, // 'æ (U+0027 U+00E6)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x01, 0x01, // 'ā (U+0027 U+0101)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x03, 0x01, // 'ă (U+0027 U+0103)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x05, 0x01, // 'ą (U+0027 U+0105)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x2C, 0x00, 0x43, 0x01, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x01, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x01, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x01, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x01, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x01, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x01, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x01, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x01, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x01, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x01, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x01, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x01, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x01, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x01, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x01, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x01, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x01, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x01, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x01, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x01, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x01, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x01, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2D, 0x00, 0x54, 0x01, // -T (U+002D U+0054)
  0x00, 0x2D, 0x01, 0x62, 0x01, // -Ţ (U+002D U+0162)
  0x00, 0x2D, 0x01, 0x64, 0x01, // -Ť (U+002D U+0164)
  0x00, 0x2D, 0x01, 0x66, 0x01, // -Ŧ (U+002D U+0166)
  0x00, 0x2E, 0x00, 0x43, 0x01, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x01, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x01, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x01, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x01, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x01, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x01, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x01, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x01, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x01, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x01, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x01, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x01, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x01, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x01, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x01, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x01, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x01, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x01, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x01, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x01, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x01, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x01, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x03, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x03, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x03, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x03, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x03, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x03, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x03, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x03, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x03, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x03, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x44, 0x00, 0x2C, 0x01, // D, (U+0044 U+002C)
  0x00, 0x44, 0x00, 0x2E, 0x01, // D. (U+0044 U+002E)
  0x00, 0x44, 0x20, 0x1A, 0x01, // D‚ (U+0044 U+201A)
  0x00, 0x44, 0x20, 0x1E, 0x01, // D„ (U+0044 U+201E)
  0x00, 0x44, 0x20, 0x26, 0x01, // D… (U+0044 U+2026)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x01, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x01, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x62, 0x01, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x01, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x01, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x01, 0x74, 0x01, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x4F, 0x00, 0x2C, 0x01, // O, (U+004F U+002C)
  0x00, 0x4F, 0x00, 0x2E, 0x01, // O. (U+004F U+002E)
  0x00, 0x4F, 0x20, 0x1A, 0x01, // O‚ (U+004F U+201A)
  0x00, 0x4F, 0x20, 0x1E, 0x01, // O„ (U+004F U+201E)
  0x00, 0x4F, 0x20, 0x26, 0x01, // O… (U+004F U+2026)
  0x00, 0x50, 0x00, 0x2C, 0x02, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x02, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x02, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x02, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x02, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x2C, 0x01, // Q, (U+0051 U+002C)
  0x00, 0x51, 0x00, 0x2E, 0x01, // Q. (U+0051 U+002E)
  0x00, 0x51, 0x20, 0x1A, 0x01, // Q‚ (U+0051 U+201A)
  0x00, 0x51, 0x20, 0x1E, 0x01, // Q„ (U+0051 U+201E)
  0x00, 0x51, 0x20, 0x26, 0x01, // Q… (U+0051 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2D, 0x01, // T- (U+0054 U+002D)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x01, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x01, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x01, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x01, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x01, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x01, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0x7A, 0x01, // Tz (U+0054 U+007A)
  0x00, 0x54, 0x00, 0xAB, 0x01, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x01, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x01, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x01, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x01, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x01, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x01, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x01, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x4B, 0x01, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x01, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x01, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x01, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5F, 0x01, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x69, 0x01, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x01, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x01, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x01, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x01, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x01, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x01, 0x7A, 0x01, // Tź (U+0054 U+017A)
  0x00, 0x54, 0x01, 0x7C, 0x01, // Tż (U+0054 U+017C)
  0x00, 0x54, 0x01, 0x7E, 0x01, // Tž (U+0054 U+017E)
  0x00, 0x54, 0x20, 0x13, 0x01, // T– (U+0054 U+2013)
  0x00, 0x54, 0x20, 0x14, 0x01, // T— (U+0054 U+2014)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x01, // T‹ (U+0054 U+2039)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x73, 0x01, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x5B, 0x01, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5F, 0x01, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0x76, 0x00, 0x2C, 0x01, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xBB, 0x00, 0x54, 0x01, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x01, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x01, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x01, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xBF, 0x00, 0x54, 0x01, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x00, 0x59, 0x01, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x01, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x62, 0x01, // ¿Ţ (U+00BF U+0162)
  0x00, 0xBF, 0x01, 0x64, 0x01, // ¿Ť (U+00BF U+0164)
  0x00, 0xBF, 0x01, 0x66, 0x01, // ¿Ŧ (U+00BF U+0166)
  0x00, 0xBF, 0x01, 0x76, 0x01, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x01, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xD0, 0x00, 0x2C, 0x01, // Ð, (U+00D0 U+002C)
  0x00, 0xD0, 0x00, 0x2E, 0x01, // Ð. (U+00D0 U+002E)
  0x00, 0xD0, 0x20, 0x1A, 0x01, // Ð‚ (U+00D0 U+201A)
  0x00, 0xD0, 0x20, 0x1E, 0x01, // Ð„ (U+00D0 U+201E)
  0x00, 0xD0, 0x20, 0x26, 0x01, // Ð… (U+00D0 U+2026)
  0x00, 0xD2, 0x00, 0x2C, 0x01, // Ò, (U+00D2 U+002C)
  0x00, 0xD2, 0x00, 0x2E, 0x01, // Ò. (U+00D2 U+002E)
  0x00, 0xD2, 0x20, 0x1A, 0x01, // Ò‚ (U+00D2 U+201A)
  0x00, 0xD2, 0x20, 0x1E, 0x01, // Ò„ (U+00D2 U+201E)
  0x00, 0xD2, 0x20, 0x26, 0x01, // Ò… (U+00D2 U+2026)
  0x00, 0xD3, 0x00, 0x2C, 0x01, // Ó, (U+00D3 U+002C)
  0x00, 0xD3, 0x00, 0x2E, 0x01, // Ó. (U+00D3 U+002E)
  0x00, 0xD3, 0x20, 0x1A, 0x01, // Ó‚ (U+00D3 U+201A)
  0x00, 0xD3, 0x20, 0x1E, 0x01, // Ó„ (U+00D3 U+201E)
  0x00, 0xD3, 0x20, 0x26, 0x01, // Ó… (U+00D3 U+2026)
  0x00, 0xD4, 0x00, 0x2C, 0x01, // Ô, (U+00D4 U+002C)
  0x00, 0xD4, 0x00, 0x2E, 0x01, // Ô. (U+00D4 U+002E)
  0x00, 0xD4, 0x20, 0x1A, 0x01, // Ô‚ (U+00D4 U+201A)
  0x00, 0xD4, 0x20, 0x1E, 0x01, // Ô„ (U+00D4 U+201E)
  0x00, 0xD4, 0x20, 0x26, 0x01, // Ô… (U+00D4 U+2026)
  0x00, 0xD5, 0x00, 0x2C, 0x01, // Õ, (U+00D5 U+002C)
  0x00, 0xD5, 0x00, 0x2E, 0x01, // Õ. (U+00D5 U+002E)
  0x00, 0xD5, 0x20, 0x1A, 0x01, // Õ‚ (U+00D5 U+201A)
  0x00, 0xD5, 0x20, 0x1E, 0x01, // Õ„ (U+00D5 U+201E)
  0x00, 0xD5, 0x20, 0x26, 0x01, // Õ… (U+00D5 U+2026)
  0x00, 0xD6, 0x00, 0x2C, 0x01, // Ö, (U+00D6 U+002C)
  0x00, 0xD6, 0x00, 0x2E, 0x01, // Ö. (U+00D6 U+002E)
  0x00, 0xD6, 0x20, 0x1A, 0x01, // Ö‚ (U+00D6 U+201A)
  0x00, 0xD6, 0x20, 0x1E, 0x01, // Ö„ (U+00D6 U+201E)
  0x00, 0xD6, 0x20, 0x26, 0x01, // Ö… (U+00D6 U+2026)
  0x00, 0xD8, 0x00, 0x2C, 0x01, // Ø, (U+00D8 U+002C)
  0x00, 0xD8, 0x00, 0x2E, 0x01, // Ø. (U+00D8 U+002E)
  0x00, 0xD8, 0x20, 0x1A, 0x01, // Ø‚ (U+00D8 U+201A)
  0x00, 0xD8, 0x20, 0x1E, 0x01, // Ø„ (U+00D8 U+201E)
  0x00, 0xD8, 0x20, 0x26, 0x01, // Ø… (U+00D8 U+2026)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x73, 0x01, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x5B, 0x01, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5F, 0x01, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDE, 0x00, 0x2C, 0x02, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x02, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x00, 0x41, 0x01, // ÞA (U+00DE U+0041)
  0x00, 0xDE, 0x00, 0xC0, 0x01, // ÞÀ (U+00DE U+00C0)
  0x00, 0xDE, 0x00, 0xC1, 0x01, // ÞÁ (U+00DE U+00C1)
  0x00, 0xDE, 0x00, 0xC2, 0x01, // ÞÂ (U+00DE U+00C2)
  0x00, 0xDE, 0x00, 0xC3, 0x01, // ÞÃ (U+00DE U+00C3)
  0x00, 0xDE, 0x00, 0xC4, 0x01, // ÞÄ (U+00DE U+00C4)
  0x00, 0xDE, 0x00, 0xC5, 0x01, // ÞÅ (U+00DE U+00C5)
  0x00, 0xDE, 0x00, 0xC6, 0x01, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDE, 0x01, 0x00, 0x01, // ÞĀ (U+00DE U+0100)
  0x00, 0xDE, 0x01, 0x02, 0x01, // ÞĂ (U+00DE U+0102)
  0x00, 0xDE, 0x01, 0x04, 0x01, // ÞĄ (U+00DE U+0104)
  0x00, 0xDE, 0x20, 0x1A, 0x02, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x02, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x02, // Þ… (U+00DE U+2026)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x0E, 0x00, 0x2C, 0x01, // Ď, (U+010E U+002C)
  0x01, 0x0E, 0x00, 0x2E, 0x01, // Ď. (U+010E U+002E)
  0x01, 0x0E, 0x20, 0x1A, 0x01, // Ď‚ (U+010E U+201A)
  0x01, 0x0E, 0x20, 0x1E, 0x01, // Ď„ (U+010E U+201E)
  0x01, 0x0E, 0x20, 0x26, 0x01, // Ď… (U+010E U+2026)
  0x01, 0x10, 0x00, 0x2C, 0x01, // Đ, (U+0110 U+002C)
  0x01, 0x10, 0x00, 0x2E, 0x01, // Đ. (U+0110 U+002E)
  0x01, 0x10, 0x20, 0x1A, 0x01, // Đ‚ (U+0110 U+201A)
  0x01, 0x10, 0x20, 0x1E, 0x01, // Đ„ (U+0110 U+201E)
  0x01, 0x10, 0x20, 0x26, 0x01, // Đ… (U+0110 U+2026)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x01, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x01, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x62, 0x01, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x01, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x01, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x01, 0x74, 0x01, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x01, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x01, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x62, 0x01, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x01, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x01, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x01, 0x74, 0x01, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x00, 0x54, 0x01, // ĽT (U+013D U+0054)
  0x01, 0x3D, 0x00, 0x56, 0x01, // ĽV (U+013D U+0056)
  0x01, 0x3D, 0x00, 0x57, 0x01, // ĽW (U+013D U+0057)
  0x01, 0x3D, 0x00, 0x59, 0x01, // ĽY (U+013D U+0059)
  0x01, 0x3D, 0x00, 0xDD, 0x01, // ĽÝ (U+013D U+00DD)
  0x01, 0x3D, 0x01, 0x62, 0x01, // ĽŢ (U+013D U+0162)
  0x01, 0x3D, 0x01, 0x64, 0x01, // ĽŤ (U+013D U+0164)
  0x01, 0x3D, 0x01, 0x66, 0x01, // ĽŦ (U+013D U+0166)
  0x01, 0x3D, 0x01, 0x74, 0x01, // ĽŴ (U+013D U+0174)
  0x01, 0x3D, 0x01, 0x76, 0x01, // ĽŶ (U+013D U+0176)
  0x01, 0x3D, 0x01, 0x78, 0x01, // ĽŸ (U+013D U+0178)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x00, 0x54, 0x01, // ĿT (U+013F U+0054)
  0x01, 0x3F, 0x00, 0x56, 0x01, // ĿV (U+013F U+0056)
  0x01, 0x3F, 0x00, 0x57, 0x01, // ĿW (U+013F U+0057)
  0x01, 0x3F, 0x00, 0x59, 0x01, // ĿY (U+013F U+0059)
  0x01, 0x3F, 0x00, 0xDD, 0x01, // ĿÝ (U+013F U+00DD)
  0x01, 0x3F, 0x01, 0x62, 0x01, // ĿŢ (U+013F U+0162)
  0x01, 0x3F, 0x01, 0x64, 0x01, // ĿŤ (U+013F U+0164)
  0x01, 0x3F, 0x01, 0x66, 0x01, // ĿŦ (U+013F U+0166)
  0x01, 0x3F, 0x01, 0x74, 0x01, // ĿŴ (U+013F U+0174)
  0x01, 0x3F, 0x01, 0x76, 0x01, // ĿŶ (U+013F U+0176)
  0x01, 0x3F, 0x01, 0x78, 0x01, // ĿŸ (U+013F U+0178)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x01, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x01, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x62, 0x01, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x01, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x01, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x01, 0x74, 0x01, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x4C, 0x00, 0x2C, 0x01, // Ō, (U+014C U+002C)
  0x01, 0x4C, 0x00, 0x2E, 0x01, // Ō. (U+014C U+002E)
  0x01, 0x4C, 0x20, 0x1A, 0x01, // Ō‚ (U+014C U+201A)
  0x01, 0x4C, 0x20, 0x1E, 0x01, // Ō„ (U+014C U+201E)
  0x01, 0x4C, 0x20, 0x26, 0x01, // Ō… (U+014C U+2026)
  0x01, 0x4E, 0x00, 0x2C, 0x01, // Ŏ, (U+014E U+002C)
  0x01, 0x4E, 0x00, 0x2E, 0x01, // Ŏ. (U+014E U+002E)
  0x01, 0x4E, 0x20, 0x1A, 0x01, // Ŏ‚ (U+014E U+201A)
  0x01, 0x4E, 0x20, 0x1E, 0x01, // Ŏ„ (U+014E U+201E)
  0x01, 0x4E, 0x20, 0x26, 0x01, // Ŏ… (U+014E U+2026)
  0x01, 0x50, 0x00, 0x2C, 0x01, // Ő, (U+0150 U+002C)
  0x01, 0x50, 0x00, 0x2E, 0x01, // Ő. (U+0150 U+002E)
  0x01, 0x50, 0x20, 0x1A, 0x01, // Ő‚ (U+0150 U+201A)
  0x01, 0x50, 0x20, 0x1E, 0x01, // Ő„ (U+0150 U+201E)
  0x01, 0x50, 0x20, 0x26, 0x01, // Ő… (U+0150 U+2026)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2D, 0x01, // Ţ- (U+0162 U+002D)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x01, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x01, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x01, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x01, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x01, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x01, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0x7A, 0x01, // Ţz (U+0162 U+007A)
  0x01, 0x62, 0x00, 0xAB, 0x01, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x01, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x01, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x01, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x01, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x01, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x01, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x01, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x4B, 0x01, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x01, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x01, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x01, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5F, 0x01, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x69, 0x01, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x01, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x01, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x01, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x01, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x01, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x01, 0x7A, 0x01, // Ţź (U+0162 U+017A)
  0x01, 0x62, 0x01, 0x7C, 0x01, // Ţż (U+0162 U+017C)
  0x01, 0x62, 0x01, 0x7E, 0x01, // Ţž (U+0162 U+017E)
  0x01, 0x62, 0x20, 0x13, 0x01, // Ţ– (U+0162 U+2013)
  0x01, 0x62, 0x20, 0x14, 0x01, // Ţ— (U+0162 U+2014)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x01, // Ţ‹ (U+0162 U+2039)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2D, 0x01, // Ť- (U+0164 U+002D)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x01, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x01, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x01, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x01, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x01, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x01, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0x7A, 0x01, // Ťz (U+0164 U+007A)
  0x01, 0x64, 0x00, 0xAB, 0x01, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x01, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x01, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x01, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x01, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x01, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x01, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x01, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x4B, 0x01, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x01, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x01, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x01, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5F, 0x01, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x69, 0x01, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x01, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x01, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x01, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x01, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x01, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x01, 0x7A, 0x01, // Ťź (U+0164 U+017A)
  0x01, 0x64, 0x01, 0x7C, 0x01, // Ťż (U+0164 U+017C)
  0x01, 0x64, 0x01, 0x7E, 0x01, // Ťž (U+0164 U+017E)
  0x01, 0x64, 0x20, 0x13, 0x01, // Ť– (U+0164 U+2013)
  0x01, 0x64, 0x20, 0x14, 0x01, // Ť— (U+0164 U+2014)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x01, // Ť‹ (U+0164 U+2039)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2D, 0x01, // Ŧ- (U+0166 U+002D)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x01, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x01, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x01, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x01, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x01, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x01, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0x7A, 0x01, // Ŧz (U+0166 U+007A)
  0x01, 0x66, 0x00, 0xAB, 0x01, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x01, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x01, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x01, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x01, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x01, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x01, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x01, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x4B, 0x01, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x01, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x01, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x01, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5F, 0x01, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x69, 0x01, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x01, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x01, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x01, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x01, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x01, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x01, 0x7A, 0x01, // Ŧź (U+0166 U+017A)
  0x01, 0x66, 0x01, 0x7C, 0x01, // Ŧż (U+0166 U+017C)
  0x01, 0x66, 0x01, 0x7E, 0x01, // Ŧž (U+0166 U+017E)
  0x01, 0x66, 0x20, 0x13, 0x01, // Ŧ– (U+0166 U+2013)
  0x01, 0x66, 0x20, 0x14, 0x01, // Ŧ— (U+0166 U+2014)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x01, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x73, 0x01, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x5B, 0x01, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5F, 0x01, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x73, 0x01, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x5B, 0x01, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5F, 0x01, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x20, 0x13, 0x00, 0x54, 0x01, // –T (U+2013 U+0054)
  0x20, 0x13, 0x01, 0x62, 0x01, // –Ţ (U+2013 U+0162)
  0x20, 0x13, 0x01, 0x64, 0x01, // –Ť (U+2013 U+0164)
  0x20, 0x13, 0x01, 0x66, 0x01, // –Ŧ (U+2013 U+0166)
  0x20, 0x14, 0x00, 0x54, 0x01, // —T (U+2014 U+0054)
  0x20, 0x14, 0x01, 0x62, 0x01, // —Ţ (U+2014 U+0162)
  0x20, 0x14, 0x01, 0x64, 0x01, // —Ť (U+2014 U+0164)
  0x20, 0x14, 0x01, 0x66, 0x01, // —Ŧ (U+2014 U+0166)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x61, 0x01, // ‘a (U+2018 U+0061)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE1, 0x01, // ‘á (U+2018 U+00E1)
  0x20, 0x18, 0x00, 0xE2, 0x01, // ‘â (U+2018 U+00E2)
  0x20, 0x18, 0x00, 0xE3, 0x01, // ‘ã (U+2018 U+00E3)
  0x20, 0x18, 0x00, 0xE4, 0x01, // ‘ä (U+2018 U+00E4)
  0x20, 0x18, 0x00, 0xE5, 0x01, // ‘å (U+2018 U+00E5)
  0x20, 0x18, 0x00, 0xE6, 0x01, // ‘æ (U+2018 U+00E6)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x01, 0x01, // ‘ā (U+2018 U+0101)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x03, 0x01, // ‘ă (U+2018 U+0103)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x05, 0x01, // ‘ą (U+2018 U+0105)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x61, 0x01, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x01, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x01, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x01, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x01, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x01, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x01, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x01, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x01, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x01, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x1A, 0x00, 0x43, 0x01, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x01, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x01, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x01, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x01, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x01, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x01, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x01, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x01, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x01, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x01, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x01, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x01, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x01, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x01, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x01, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x01, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x01, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x01, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x01, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x01, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x01, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x01, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x61, 0x01, // “a (U+201C U+0061)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE1, 0x01, // “á (U+201C U+00E1)
  0x20, 0x1C, 0x00, 0xE2, 0x01, // “â (U+201C U+00E2)
  0x20, 0x1C, 0x00, 0xE3, 0x01, // “ã (U+201C U+00E3)
  0x20, 0x1C, 0x00, 0xE4, 0x01, // “ä (U+201C U+00E4)
  0x20, 0x1C, 0x00, 0xE5, 0x01, // “å (U+201C U+00E5)
  0x20, 0x1C, 0x00, 0xE6, 0x01, // “æ (U+201C U+00E6)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x01, 0x01, // “ā (U+201C U+0101)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x03, 0x01, // “ă (U+201C U+0103)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x05, 0x01, // “ą (U+201C U+0105)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x61, 0x01, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x01, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x01, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x01, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x01, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x01, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x01, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x01, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x01, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x01, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1E, 0x00, 0x43, 0x01, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x01, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x01, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x01, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x01, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x01, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x01, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x01, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x01, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x01, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x01, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x01, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x01, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x01, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x01, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x01, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x01, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x01, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x01, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x01, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x01, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x01, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x01, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x01, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x01, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x01, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x01, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x03, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x03, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x03, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x03, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x03, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x03, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x03, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x03, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x03, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x03, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x8B, 0x78, 0xFD, 0x8F, 0xC7, 0xFB, 0x7F, 0xB6, 0xFA, 0x5F, 0x95, 0xF9, 0x4F, 0x84, 0xF8, 0x3F,
  0x72, 0xF6, 0x68, 0x75, 0xE9, 0xAF, 0xE5, 0xE9,
  // """ (U+0022)
  0x8C, 0x6B, 0xF7, 0x0E, 0xF4, 0xAF, 0x60, 0xDF, 0x39, 0xF5, 0x0C, 0xF2, 0x8F, 0x40, 0xBF, 0x17,
  0xF3, 0x0A, 0xF0, 0x6F, 0x20, 0x99, 0x10,
  // "#" (U+0023)
  0x38, 0x51, 0xF7, 0x05, 0xF3, 0x48, 0x53, 0xF5, 0x07, 0xF1, 0x48, 0x45, 0xF3, 0x09, 0xE5, 0x84,
  0x7F, 0x10, 0xBD, 0x50, 0x99, 0x20, 0xD0, 0xB3, 0xFA, 0x89, 0x2A, 0x09, 0x9E, 0xD9, 0xAF, 0xB9,
  0x63, 0x98, 0x38, 0x04, 0xF4, 0x48, 0x52, 0xF6, 0x06, 0xF2, 0x48, 0x34, 0xF4, 0x08, 0x93, 0x08,
  0xFA, 0x89, 0x21, 0x7C, 0xEF, 0xCC, 0xFE, 0xCC, 0x12, 0x0A, 0x0D, 0x20, 0xE0, 0x95, 0x84, 0xCB,
  0x01, 0xF7, 0x58, 0x4E, 0x90, 0x4F, 0x54, 0x85, 0x1F, 0x60, 0x6F, 0x23,
  // "$" (U+0024)
  0x30, 0x80, 0xA7, 0x09, 0x0B, 0x50, 0x60, 0xDB, 0x8B, 0x0D, 0x60, 0x6F, 0xED, 0xDC, 0xF9, 0x0D,
  0xF2, 0x8A, 0x01, 0x10, 0xFD, 0x08, 0xA4, 0x83, 0xDF, 0x18, 0xA4, 0x83, 0x7F, 0xEC, 0xA5, 0x09,
  0xB0, 0x80, 0x14, 0x02, 0x0B, 0xA0, 0xE0, 0x34, 0x83, 0x8B, 0x8F, 0xD4, 0x84, 0x8A, 0x0C, 0xF1,
  0x38, 0x94, 0x8A, 0x0B, 0xF1, 0xB5, 0x18, 0xB7, 0xFC, 0x1E, 0x89, 0x0E, 0x30, 0x39, 0xBE, 0xD7,
  0x15, 0x08, 0x0A, 0x70, 0x80, 0xA4,
  // "%" (U+0025)
  0x28, 0x2A, 0xFC, 0x13, 0x81, 0x1F, 0x84, 0x83, 0x8F, 0xEF, 0xB3, 0x81, 0x7F, 0x24, 0x84, 0xEC,
  0x0A, 0xF1, 0x20, 0xD0, 0xC4, 0x89, 0x11, 0xF9, 0x06, 0xF4, 0x04, 0xF6, 0x48, 0x90, 0x2F, 0x80,
  0x5F, 0x50, 0xAE, 0x58, 0x90, 0x2F, 0x80, 0x5F, 0x51, 0xF9, 0x58, 0x94, 0x1F, 0x90, 0x6F, 0x47,
  0xF3, 0x17, 0x71, 0x28, 0x90, 0xDD, 0x0A, 0xF1, 0xDC, 0x1D, 0xA0, 0xD2, 0x89, 0x48, 0xFE, 0xFB,
  0x4F, 0x66, 0xF5, 0x6F, 0x52, 0x89, 0x3A, 0xFC, 0x2A, 0xF1, 0xAF, 0x01, 0xF9, 0x58, 0x41, 0xF9,
  0x0B, 0xE2, 0x90, 0xB5, 0x84, 0x6F, 0x30, 0xBD, 0x20, 0xE0, 0xB5, 0x0C, 0x0D, 0x20, 0xA0, 0xE2,
  0x90, 0xA4, 0x81, 0x3F, 0x72, 0x84, 0x8F, 0x34, 0xF8, 0x48, 0x19, 0xF1, 0x28, 0x12, 0xFE, 0xA0,
  0x24, 0x0E, 0x0A, 0x48, 0x26, 0xEE, 0x61,
  // "&" (U+0026)
  0x38, 0x38, 0xDE, 0xA1, 0x68, 0x48, 0xFE, 0xEF, 0xB6, 0x85, 0xEF, 0x20, 0xEF, 0x15, 0x90, 0xE2,
  0x81, 0xBF, 0x35, 0x85, 0xEF, 0x10, 0xDF, 0x15, 0x84, 0x9F, 0x87, 0xFA, 0x60, 0x2B, 0x0D, 0x01,
  0x60, 0x20, 0xEA, 0x03, 0x60, 0x20, 0xEB, 0x0A, 0x28, 0x6B, 0xF5, 0x0B, 0xFB, 0x3A, 0x84, 0x50,
  0xEF, 0x11, 0xA8, 0x92, 0x10, 0x6F, 0xE6, 0xFD, 0x03, 0xFD, 0x30, 0xAB, 0x83, 0x70, 0x2F, 0xE3,
  0x83, 0x1E, 0xFE, 0x12, 0x81, 0xEF, 0x72, 0x07, 0xB0, 0x42, 0x07, 0xA8, 0x6D, 0xEF, 0xEA, 0xFE,
  0x12, 0x89, 0x07, 0xDF, 0xE9, 0x20, 0xCF, 0xB0,
  // "'" (U+0027)
  0x8A, 0x0B, 0xF7, 0xAF, 0x69, 0xF5, 0x8F, 0x47, 0xF3, 0x6F, 0x20,
  // "(" (U+0028)
  0x28, 0x55, 0xF7, 0x01, 0xED, 0x28, 0x18, 0xF6, 0x28, 0x5E, 0xF1, 0x04, 0xFB, 0x28, 0x18, 0xF7,
  0x28, 0x1B, 0xF4, 0x28, 0x1E, 0xF1, 0x2A, 0x3A, 0x3A, 0x38, 0x1E, 0xF1, 0x28, 0x1C, 0xF3, 0x28,
  0x19, 0xF7, 0x28, 0x15, 0xFA, 0x38, 0x1E, 0xF1, 0x28, 0x18, 0xF6, 0x28, 0x11, 0xED, 0x38, 0x15,
  0xF7,
  // ")" (U+0029)
  0x81, 0x2F, 0xA4, 0x81, 0x9F, 0x53, 0x81, 0x1F, 0xD4, 0x81, 0xBF, 0x33, 0x81, 0x5F, 0x93, 0x81,
  0x2F, 0xD4, 0x81, 0xEF, 0x13, 0x81, 0xCF, 0x33, 0x81, 0xBF, 0x43, 0x81, 0xAF, 0x53, 0x81, 0xBF,
  0x43, 0x81, 0xCF, 0x33, 0x81, 0xEF, 0x12, 0x81, 0x2F, 0xD3, 0x81, 0x5F, 0xA3, 0x81, 0xBF, 0x42,
  0x81, 0x1F, 0xD3, 0x81, 0x9F, 0x52, 0x81, 0x2F, 0xB3,
  // "*" (U+002A)
  0x38, 0x13, 0xFB, 0x68, 0x12, 0xF9, 0x48, 0x77, 0x30, 0xF7, 0x15, 0x41, 0xA8, 0x1D, 0xFD, 0xA8,
  0x39, 0x16, 0x8C, 0xA8, 0x19, 0x74, 0x28, 0x31, 0xEC, 0xF8, 0x48, 0x4B, 0xF3, 0xBF, 0x42, 0x85,
  0x2D, 0xB0, 0x4F, 0x74, 0x02, 0x20, 0x22,
  // "+" (U+002B)
  0x40, 0xC0, 0xE7, 0x10, 0xC0, 0xE7, 0x10, 0xC0, 0xE7, 0x10, 0xC0, 0xE4, 0x03, 0xF9, 0x05, 0x03,
  0x0F, 0xCA, 0x0F, 0xC0, 0x44, 0x0C, 0x0E, 0x71, 0x0C, 0x0E, 0x71, 0x0C, 0x0E, 0x71, 0x0C, 0x0E,
  0x40,
  // "," (U+002C)
  0x18, 0xA0, 0x5F, 0xD0, 0x7F, 0x90, 0xAF, 0x40, 0xEE, 0x02, 0xF8, 0x10,
  // "-" (U+002D)
  0x85, 0x4C, 0xCC, 0xC7, 0x5C, 0x08,
  // "." (U+002E)
  0x87, 0x6E, 0x8A, 0xFD, 0x6E, 0x80,
  // "/" (U+002F)
  0x58, 0x14, 0xF9, 0x58, 0x1A, 0xF4, 0x50, 0x0E, 0x58, 0x15, 0xF8, 0x58, 0x1A, 0xF3, 0x48, 0x11,
  0xFD, 0x58, 0x16, 0xF8, 0x58, 0x1B, 0xF2, 0x48, 0x11, 0xFC, 0x58, 0x16, 0xF7, 0x58, 0x1C, 0xF2,
  0x48, 0x12, 0xFC, 0x58, 0x17, 0xF6, 0x58, 0x1C, 0xF1, 0x48, 0x12, 0xFB, 0x58, 0x18, 0xF6, 0x50,
  // "0" (U+0030)
  0x28, 0x41, 0x9E, 0xEA, 0x14, 0x84, 0xCF, 0xEE, 0xFC, 0x38, 0x15, 0xFD, 0x28, 0x1C, 0xF5, 0x28,
  0x1A, 0xF6, 0x28, 0x16, 0xFA, 0x28, 0x1D, 0xF3, 0x28, 0x12, 0xFE, 0x2A, 0x01, 0x3A, 0x10, 0x1A,
  0x48, 0x2E, 0xF2, 0x1A, 0x48, 0x2E, 0xF2, 0x2A, 0x48, 0x2E, 0xF2, 0x1A, 0x48, 0x1E, 0xF2, 0x1A,
  0x01, 0x3A, 0x28, 0x1D, 0xF3, 0x28, 0x12, 0xFE, 0x28, 0x1A, 0xF6, 0x28, 0x15, 0xFA, 0x28, 0x15,
  0xFD, 0x28, 0x1C, 0xF5, 0x38, 0x4C, 0xFE, 0xEF, 0xC4, 0x84, 0x19, 0xEE, 0xA1, 0x20,
  // "1" (U+0031)
  0x38, 0x15, 0xFE, 0x20, 0x5A, 0x81, 0xE0, 0x5B, 0x0E, 0x04, 0xA8, 0x76, 0xFE, 0x2E, 0x42, 0xFE,
  0x38, 0x12, 0xFE, 0x38, 0x12, 0xFE, 0x38, 0x12, 0xFE, 0x38, 0x12, 0xFE, 0x38, 0x12, 0xFE, 0x38,
  0x12, 0xFE, 0x38, 0x12, 0xFE, 0x38, 0x12, 0xFE, 0x38, 0x12, 0xFE, 0x38, 0x12, 0xFE, 0x38, 0x12,
  0xFE,
  // "2" (U+0032)
  0x28, 0x47, 0xDF, 0xE9, 0x13, 0x0C, 0xA0, 0xDA, 0x0D, 0x38, 0x69, 0xB1, 0x01, 0xDF, 0x67, 0x81,
  0x7F, 0xA7, 0x81, 0x7F, 0xA7, 0x81, 0x9F, 0x97, 0x81, 0xDF, 0x56, 0x81, 0x5F, 0xE7, 0x81, 0xDF,
  0x66, 0x81, 0xAF, 0xB6, 0x82, 0x5F, 0xE1, 0x58, 0x22, 0xEF, 0x46, 0x81, 0xCF, 0x86, 0x81, 0x7F,
  0xC6, 0x02, 0xA0, 0xD8, 0x01, 0xC0, 0x10, 0x3F, 0x90, 0x10,
  // "3" (U+0033)
  0x18, 0x51, 0x8D, 0xFE, 0xA2, 0x28, 0x2E, 0xFE, 0xDA, 0x83, 0xE1, 0x08, 0x82, 0x82, 0x1D, 0xF7,
  0x68, 0x17, 0xFA, 0x68, 0x16, 0xFA, 0x68, 0x1A, 0xF6, 0x48, 0x22, 0x8F, 0xC3, 0x05, 0xB0, 0x90,
  0x13, 0x84, 0x4D, 0xEF, 0xE8, 0x68, 0x23, 0xDF, 0x86, 0x81, 0x5F, 0xE6, 0x03, 0xA6, 0x84, 0x5F,
  0xE2, 0x61, 0x28, 0x32, 0xDF, 0xA3, 0xA0, 0xE0, 0xDA, 0x89, 0x0E, 0x21, 0x8C, 0xEF, 0xD9, 0x11,
  // "4" (U+0034)
  0x50, 0x5A, 0x01, 0x60, 0xCA, 0x01, 0x50, 0x5B, 0x01, 0x58, 0x3C, 0xCE, 0xF1, 0x48, 0x15, 0xF5,
  0xA0, 0x14, 0x0C, 0x0D, 0x1A, 0x01, 0x38, 0x15, 0xF6, 0x1A, 0x01, 0x30, 0xC0, 0xE2, 0xA0, 0x12,
  0x81, 0x5F, 0x72, 0xA0, 0x12, 0x0C, 0x0E, 0x3A, 0x83, 0x10, 0x5F, 0x73, 0xA8, 0x11, 0x09, 0xF9,
  0x0B, 0x08, 0x80, 0x1D, 0xA0, 0xD0, 0xA6, 0xA0, 0x17, 0xA0, 0x17, 0xA0, 0x11,
  // "5" (U+0035)
  0x04, 0xE8, 0x94, 0x30, 0x5F, 0xEC, 0xCC, 0xC2, 0x06, 0xF8, 0x68, 0x17, 0xF7, 0x68, 0x18, 0xF6,
  0x68, 0x19, 0xF5, 0x68, 0x5A, 0xFB, 0xCC, 0x81, 0x20, 0x9D, 0x0D, 0x01, 0x28, 0x54, 0x10, 0x4D,
  0xF9, 0x68, 0x15, 0xFE, 0x60, 0x1A, 0x01, 0x50, 0x2A, 0x68, 0x46, 0xFD, 0x07, 0x22, 0x87, 0x3E,
  0xF8, 0x0E, 0xFE, 0xDA, 0x0C, 0x28, 0x56, 0xCE, 0xFD, 0x81, 0x20,
  // "6" (U+0036)
  0x38, 0x41, 0x8D, 0xFE, 0x43, 0x02, 0x0D, 0xA8, 0x1D, 0xE5, 0x38, 0x2B, 0xFA, 0x15, 0x81, 0x3F,
  0xD7, 0x81, 0x8F, 0x77, 0x81, 0xCF, 0x37, 0x85, 0xEF, 0x2B, 0xED, 0x63, 0xA8, 0x1C, 0xEE, 0xA0,
  0x52, 0xA0, 0xC2, 0x83, 0x8F, 0xC0, 0x1A, 0x03, 0x3A, 0x01, 0x1A, 0x01, 0x38, 0x5D, 0xF2, 0x0D,
  0xF3, 0x38, 0x5E, 0xF2, 0x0A, 0xF6, 0x20, 0x1A, 0x28, 0x64, 0xFD, 0x10, 0x8F, 0xB3, 0x82, 0xBF,
  0xEE, 0xA0, 0x34, 0x83, 0x8E, 0xEB, 0x32,
  // "7" (U+0037)
  0x04, 0xF9, 0x04, 0x03, 0x80, 0x2C, 0xA0, 0x36, 0x81, 0x2F, 0xE7, 0x81, 0x7F, 0x97, 0x81, 0xDF,
  0x36, 0x81, 0x3F, 0xE7, 0x81, 0x8F, 0x97, 0x81, 0xDF, 0x36, 0x81, 0x3F, 0xD7, 0x81, 0x9F, 0x87,
  0x81, 0xEF, 0x36, 0x81, 0x4F, 0xD7, 0x81, 0x9F, 0x87, 0x81, 0xEF, 0x36, 0x81, 0x5F, 0xD7, 0x81,
  0xAF, 0x85,
  // "8" (U+0038)
  0x28, 0x42, 0xAE, 0xEB, 0x33, 0x03, 0xA0, 0x0E, 0xA0, 0x42, 0x81, 0xAF, 0xA2, 0x81, 0x9F, 0xB2,
  0x81, 0xCF, 0x42, 0x81, 0x2F, 0xD2, 0x81, 0xBF, 0x42, 0x81, 0x3F, 0xC2, 0x81, 0x6F, 0xB2, 0x81,
  0xAF, 0x73, 0x84, 0xCF, 0xBA, 0xFC, 0x40, 0x10, 0xDA, 0x0C, 0x58, 0x49, 0xFD, 0xEF, 0x93, 0x86,
  0x8F, 0xB0, 0x2D, 0xF8, 0x28, 0x1E, 0xF1, 0x20, 0x2A, 0x82, 0x12, 0xFD, 0x48, 0x4C, 0xF4, 0x2F,
  0xE4, 0x85, 0xDF, 0x40, 0xEF, 0x72, 0x81, 0x6F, 0xE2, 0x06, 0xA0, 0x0E, 0xA0, 0x73, 0x84, 0x5B,
  0xEF, 0xC5, 0x20,
  // "9" (U+0039)
  0x28, 0x33, 0xBE, 0xE9, 0x48, 0x52, 0xEF, 0xEE, 0xFB, 0x38, 0x6A, 0xF9, 0x01, 0xDF, 0x52, 0xA0,
  0x22, 0x83, 0x5F, 0xB0, 0x2A, 0x38, 0x51, 0xFE, 0x02, 0xFE, 0x4A, 0x2A, 0x01, 0x20, 0x3A, 0x83,
  0x10, 0xCF, 0x82, 0x0B, 0xA8, 0x11, 0x05, 0xA8, 0x2E, 0xED, 0xE9, 0x38, 0x56, 0xDF, 0xB2, 0xFE,
  0x78, 0x12, 0xFC, 0x78, 0x16, 0xF8, 0x78, 0x1D, 0xF3, 0x58, 0x21, 0xAF, 0xB3, 0x81, 0x6D, 0xDA,
  0x0D, 0x01, 0x38, 0x45, 0xEF, 0xD8, 0x13,
  // ":" (U+003A)
  0x87, 0x6E, 0x8A, 0xFD, 0x5E, 0x87, 0x74, 0x87, 0x6E, 0x8A, 0xFD, 0x5E, 0x80,
  // ";" (U+003B)
  0x18, 0x91, 0x6E, 0x80, 0xAF, 0xD0, 0x6E, 0x87, 0x77, 0x48, 0xA0, 0x6F, 0xC0, 0x8F, 0x80, 0xBF,
  0x40, 0xED, 0x02, 0xF7, 0x10,
  // "<" (U+003C)
  0x71, 0x00, 0x17, 0x81, 0x7E, 0x55, 0x83, 0x7E, 0xFD, 0x23, 0x83, 0x6E, 0xFC, 0x53, 0x83, 0x6D,
  0xFC, 0x54, 0x04, 0xA0, 0x87, 0x83, 0x8E, 0xFB, 0x46, 0x84, 0x18, 0xEF, 0xC5, 0x68, 0x41, 0x7E,
  0xFD, 0x26, 0x82, 0x17, 0xE5, 0x71, 0x00, 0x10,
  // "=" (U+003D)
  0x03, 0xF9, 0x04, 0x02, 0x80, 0x4C, 0x03, 0x77, 0x60, 0x28, 0x04, 0xC0, 0x03, 0xF9, 0x04,
  // ">" (U+003E)
  0x00, 0x17, 0x18, 0x23, 0xE8, 0x16, 0x83, 0x1C, 0xFE, 0x77, 0x83, 0x4C, 0xFE, 0x77, 0x83, 0x4C,
  0xFE, 0x77, 0x07, 0xA0, 0x54, 0x03, 0x0B, 0xA0, 0x80, 0x12, 0x84, 0x4B, 0xFE, 0x81, 0x28, 0x42,
  0xCF, 0xE8, 0x14, 0x82, 0x3E, 0x81, 0x60, 0x01, 0x71,
  // "?" (U+003F)
  0x84, 0x18, 0xDF, 0xD8, 0x28, 0x29, 0xFE, 0xDA, 0x82, 0x90, 0x27, 0x20, 0x2A, 0x01, 0x58, 0x1C,
  0xF3, 0x58, 0x1D, 0xF2, 0x48, 0x13, 0xFE, 0x48, 0x21, 0xDF, 0x64, 0x81, 0xBF, 0xA4, 0x81, 0x4F,
  0xC5, 0x81, 0x9F, 0x35, 0x0A, 0x96, 0x01, 0x02, 0x77, 0x81, 0xBE, 0x34, 0x01, 0xA0, 0x85, 0x81,
  0xBE, 0x33,
  // "@" (U+0040)
  0x48, 0x56, 0xBE, 0xFD, 0x81, 0x50, 0x10, 0xCA, 0x0E, 0x0D, 0xA0, 0xD0, 0x14, 0x82, 0xCF, 0xA2,
  0x28, 0x21, 0x8F, 0xD3, 0x81, 0x7F, 0x86, 0x85, 0x6F, 0x70, 0x1E, 0xC2, 0x89, 0x47, 0xDE, 0xC6,
  0x0C, 0xE0, 0x5F, 0x50, 0x7A, 0x86, 0xDF, 0xB0, 0x6F, 0x39, 0x92, 0x89, 0x6E, 0xD1, 0x0E, 0xB0,
  0x3F, 0x6C, 0xC0, 0x3F, 0x72, 0x98, 0x98, 0x0A, 0x01, 0xF7, 0xDA, 0x06, 0xF4, 0x01, 0xFA, 0x01,
  0xF8, 0xEA, 0x06, 0xF3, 0x02, 0xF9, 0x02, 0xF7, 0xEB, 0x05, 0xF5, 0x05, 0xF9, 0x04, 0xF4, 0xDD,
  0x02, 0xFB, 0x1B, 0xEC, 0x1B, 0xF1, 0xAF, 0x10, 0xCB, 0x04, 0xB8, 0x94, 0x80, 0x6F, 0x80, 0x1A,
  0xC4, 0x07, 0xC8, 0x38, 0x1E, 0xE3, 0x74, 0x89, 0x05, 0xFE, 0x72, 0x01, 0x36, 0x25, 0x06, 0xF0,
  0x36, 0x85, 0x27, 0xBC, 0xB8, 0x24,
  // "A" (U+0041)
  0x48, 0x1D, 0xFD, 0x70, 0x2B, 0x02, 0x68, 0x36, 0xFC, 0xF6, 0x68, 0x3A, 0xF6, 0xFA, 0x68, 0x3E,
  0xE0, 0xEE, 0x58, 0x53, 0xFB, 0x0B, 0xF3, 0x48, 0x57, 0xF7, 0x07, 0xF7, 0x48, 0x5B, 0xF3, 0x03,
  0xFC, 0x4A, 0x30, 0xE9, 0x30, 0x4F, 0x04, 0x20, 0x8F, 0x09, 0x28, 0x1C, 0xF5, 0x38, 0x34, 0xFD,
  0x01, 0xA0, 0x14, 0xA8, 0x21, 0x5F, 0xD5, 0x84, 0xCF, 0x69, 0xF9, 0x58, 0x48, 0xFA, 0xDF, 0x55,
  0x81, 0x5F, 0xE0,
  // "B" (U+0042)
  0x05, 0xC8, 0x1E, 0xA4, 0x28, 0x35, 0xFE, 0xCD, 0xB8, 0x35, 0x05, 0xFC, 0x38, 0x5B, 0xFD, 0x05,
  0xFC, 0x30, 0x3A, 0x18, 0x15, 0xFC, 0x30, 0x1A, 0x18, 0x15, 0xFC, 0x38, 0x54, 0xFD, 0x05, 0xFC,
  0x28, 0x43, 0xCF, 0x70, 0x5E, 0x07, 0x28, 0x93, 0x5F, 0xEC, 0xDE, 0xFC, 0x30, 0x5F, 0xC3, 0x85,
  0x8F, 0xE0, 0x5F, 0xC4, 0x84, 0xEF, 0x45, 0xFC, 0x48, 0x4C, 0xF6, 0x5F, 0xC4, 0x84, 0xEF, 0x55,
  0xFC, 0x30, 0x7A, 0x85, 0x15, 0xFE, 0xCC, 0xEA, 0x81, 0x70, 0x5D, 0x0C, 0x05, 0x20,
  // "C" (U+0043)
  0x38, 0x47, 0xCF, 0xEC, 0x62, 0x0B, 0xA8, 0x7E, 0xEF, 0xD0, 0x8F, 0xE3, 0x28, 0x13, 0x51, 0xA0,
  0x45, 0x81, 0x6F, 0xD6, 0x81, 0xAF, 0x96, 0x81, 0xCF, 0x66, 0x81, 0xDF, 0x56, 0x81, 0xDF, 0x56,
  0x81, 0xCF, 0x66, 0x81, 0xAF, 0x86, 0x81, 0x7F, 0xC6, 0x02, 0xA0, 0x36, 0x82, 0xAF, 0xD3, 0x28,
  0x31, 0x30, 0x1D, 0xA8, 0x2D, 0xDF, 0xA3, 0x84, 0x8D, 0xFE, 0xC5,
  // "D" (U+0044)
  0x05, 0xC8, 0x1D, 0x92, 0x38, 0x35, 0xFE, 0xCD, 0xB0, 0x42, 0x81, 0x5F, 0xC2, 0x87, 0x1A, 0xFE,
  0x10, 0x5F, 0xC4, 0x85, 0xCF, 0x80, 0x5F, 0xC4, 0x85, 0x5F, 0xE0, 0x5F, 0xC4, 0x01, 0xA8, 0x21,
  0x5F, 0xC5, 0xA8, 0x23, 0x5F, 0xC5, 0x84, 0xEF, 0x45, 0xFC, 0x58, 0x4E, 0xF4, 0x5F, 0xC5, 0xA8,
  0x23, 0x5F, 0xC4, 0x02, 0xA8, 0x21, 0x5F, 0xC4, 0x85, 0x6F, 0xD0, 0x5F, 0xC4, 0x85, 0xDF, 0x70,
  0x5F, 0xC2, 0x82, 0x1B, 0xFD, 0x28, 0x35, 0xFE, 0xCD, 0xA0, 0xE0, 0x32, 0x05, 0xC8, 0x1D, 0x81,
  0x30,
  // "E" (U+0045)
  0x05, 0xE8, 0x92, 0x75, 0xFE, 0xCC, 0xCC, 0x65, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58,
  0x15, 0xFC, 0x58, 0x15, 0xFC, 0x50, 0x5E, 0x89, 0x23, 0x5F, 0xEC, 0xCC, 0xC2, 0x5F, 0xC5, 0x81,
  0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x87, 0x5F, 0xEC, 0xCC, 0xC6,
  0x5E, 0x07,
  // "F" (U+0046)
  0x05, 0xE8, 0x92, 0x75, 0xFE, 0xCC, 0xCC, 0x65, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58,
  0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x50, 0x5E, 0x89, 0x22, 0x5F, 0xEC, 0xCC, 0xC2,
  0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F,
  0xC5,
  // "G" (U+0047)
  0x38, 0x53, 0xAD, 0xFD, 0xB5, 0x30, 0x8A, 0x0E, 0x0D, 0xB8, 0x11, 0x06, 0xA0, 0x63, 0x85, 0x47,
  0x01, 0xEF, 0x67, 0x81, 0x5F, 0xD7, 0x18, 0x1A, 0xF8, 0x71, 0x81, 0xCF, 0x67, 0x18, 0x1D, 0xF5,
  0x38, 0x00, 0xC8, 0x26, 0xDF, 0x53, 0xC8, 0x27, 0xCF, 0x65, 0x84, 0xAF, 0x7A, 0xF8, 0x58, 0x4A,
  0xF7, 0x6F, 0xC5, 0x82, 0xAF, 0x71, 0xA0, 0x44, 0x86, 0xAF, 0x70, 0x8F, 0xE4, 0x38, 0x1A, 0xF7,
  0x20, 0xBA, 0x81, 0xED, 0xEA, 0x07, 0x38, 0x66, 0xCF, 0xED, 0xB8, 0x20,
  // "H" (U+0048)
  0x81, 0x5F, 0xC5, 0xA8, 0x21, 0x5F, 0xC5, 0xA8, 0x21, 0x5F, 0xC5, 0xA8, 0x21, 0x5F, 0xC5, 0xA8,
  0x21, 0x5F, 0xC5, 0xA8, 0x21, 0x5F, 0xC5, 0xA8, 0x21, 0x5F, 0xC5, 0xA0, 0x10, 0x5F, 0xA8, 0x21,
  0x5F, 0xE8, 0x01, 0xCA, 0x82, 0x15, 0xFC, 0x5A, 0x82, 0x15, 0xFC, 0x5A, 0x82, 0x15, 0xFC, 0x5A,
  0x82, 0x15, 0xFC, 0x5A, 0x82, 0x15, 0xFC, 0x5A, 0x82, 0x15, 0xFC, 0x5A, 0x82, 0x15, 0xFC, 0x5A,
  0x01,
  // "I" (U+0049)
  0x04, 0xC8, 0x1D, 0x2B, 0xA0, 0xD0, 0x82, 0x81, 0xCF, 0x53, 0x81, 0xCF, 0x53, 0x81, 0xCF, 0x53,
  0x81, 0xCF, 0x53, 0x81, 0xCF, 0x53, 0x81, 0xCF, 0x53, 0x81, 0xCF, 0x53, 0x81, 0xCF, 0x53, 0x81,
  0xCF, 0x53, 0x81, 0xCF, 0x53, 0x81, 0xCF, 0x53, 0x89, 0x1C, 0xF5, 0x01, 0x8E, 0xFB, 0x54, 0xC0,
  0xD0,
  // "J" (U+004A)
  0x38, 0x16, 0xFB, 0x38, 0x16, 0xFB, 0x38, 0x16, 0xFB, 0x38, 0x16, 0xFB, 0x38, 0x16, 0xFB, 0x38,
  0x16, 0xFB, 0x38, 0x16, 0xFB, 0x38, 0x16, 0xFB, 0x38, 0x16, 0xFB, 0x38, 0x16, 0xFB, 0x38, 0x16,
  0xFB, 0x38, 0x16, 0xFB, 0x38, 0x16, 0xFB, 0x38, 0x16, 0xFB, 0x38, 0x16, 0xFB, 0x38, 0x16, 0xFA,
  0x38, 0x18, 0xF9, 0x28, 0x32, 0xDF, 0x63, 0xB8, 0x5D, 0x12, 0xBC, 0x91, 0x10,
  // "K" (U+004B)
  0x81, 0x5F, 0xC4, 0x84, 0xDF, 0x65, 0xFC, 0x38, 0x57, 0xFC, 0x05, 0xFC, 0x28, 0x61, 0xEF, 0x30,
  0x5F, 0xC2, 0x81, 0xAF, 0xA2, 0x86, 0x5F, 0xC0, 0x3F, 0xE1, 0x28, 0x55, 0xFC, 0x0C, 0xF6, 0x38,
  0x45, 0xFC, 0x6F, 0xC4, 0x84, 0x5F, 0xDE, 0xF9, 0x40, 0x5D, 0x02, 0x30, 0x5A, 0x82, 0x5B, 0xF9,
  0x38, 0x35, 0xFC, 0x03, 0xA0, 0x22, 0x81, 0x5F, 0xC2, 0x81, 0xBF, 0x92, 0x81, 0x5F, 0xC2, 0x04,
  0xA8, 0x32, 0x05, 0xFC, 0x38, 0x5B, 0xFA, 0x05, 0xFC, 0x30, 0x4A, 0x82, 0x25, 0xFC, 0x48, 0x1B,
  0xFA,
  // "L" (U+004C)
  0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81,
  0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F,
  0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x05, 0xA8, 0x00, 0xE0, 0x80, 0x5E,
  0x08,
  // "M" (U+004D)
  0x05, 0xA0, 0xC6, 0x03, 0xA0, 0xE0, 0x5B, 0x01, 0x50, 0x7A, 0x0E, 0x05, 0xB0, 0x55, 0x0C, 0xA8,
  0x4E, 0x5F, 0xCF, 0xA4, 0x89, 0x01, 0xFC, 0xFE, 0x5F, 0x9F, 0xE4, 0x89, 0x15, 0xF8, 0xFE, 0x5F,
  0x9B, 0xF3, 0x38, 0x91, 0xAF, 0x4F, 0xE5, 0xF9, 0x6F, 0x73, 0x89, 0x1E, 0xD1, 0xFE, 0x5F, 0x92,
  0xFC, 0x28, 0xE1, 0x3F, 0x91, 0xFE, 0x5F, 0x90, 0xDF, 0x10, 0x7F, 0x51, 0xFE, 0x5F, 0x90, 0x8F,
  0x50, 0xCF, 0x01, 0xFE, 0x5F, 0x90, 0x4F, 0xA1, 0xFB, 0x01, 0xFE, 0x5F, 0x92, 0x89, 0x2E, 0xE5,
  0xF7, 0x01, 0xFE, 0x5F, 0x92, 0x89, 0x2A, 0xFD, 0xF2, 0x01, 0xFE, 0x5F, 0x92, 0x06, 0xA0, 0xD2,
  0x84, 0x1F, 0xE5, 0xF9, 0x20, 0x1A, 0x08, 0x28, 0x41, 0xFE, 0x5F, 0x93, 0x81, 0xCF, 0x42, 0x81,
  0x1F, 0xE0,
  // "N" (U+004E)
  0x05, 0xA0, 0x64, 0x82, 0x2F, 0xD5, 0xA0, 0xD4, 0x82, 0x2F, 0xD5, 0xB0, 0x53, 0x86, 0x2F, 0xD5,
  0xFE, 0xFC, 0x38, 0x72, 0xFD, 0x5F, 0x9E, 0xF3, 0x28, 0x72, 0xFD, 0x5F, 0x98, 0xFA, 0x28, 0x52,
  0xFD, 0x5F, 0x91, 0xA8, 0xA3, 0x20, 0x2F, 0xD5, 0xF9, 0x09, 0xF9, 0x02, 0xFD, 0x5F, 0x90, 0x2A,
  0x85, 0x12, 0xFD, 0x5F, 0x92, 0x87, 0xAF, 0x82, 0xFD, 0x5F, 0x92, 0x87, 0x3F, 0xE2, 0xFD, 0x5F,
  0x93, 0x86, 0xCF, 0x7F, 0xD5, 0xF9, 0x38, 0x65, 0xFE, 0xFD, 0x5F, 0x94, 0x0D, 0xA8, 0x2D, 0x5F,
  0x94, 0x06, 0xA8, 0x2D, 0x5F, 0x95, 0x81, 0xEF, 0xD0,
  // "O" (U+004F)
  0x28, 0x51, 0x9D, 0xFE, 0xA2, 0x40, 0x20, 0xEA, 0x83, 0xDE, 0xFE, 0x33, 0x82, 0xBF, 0xC1, 0x28,
  0x19, 0xFD, 0x20, 0x3A, 0x02, 0x48, 0x5D, 0xF5, 0x08, 0xFB, 0x58, 0x57, 0xFA, 0x0B, 0xF7, 0x58,
  0x54, 0xFE, 0x0D, 0xF5, 0x50, 0x2A, 0x18, 0x1D, 0xF5, 0x50, 0x2A, 0x82, 0x1D, 0xF5, 0x50, 0x2A,
  0x82, 0x1C, 0xF5, 0x50, 0x2A, 0x18, 0x1A, 0xF7, 0x58, 0x54, 0xFE, 0x07, 0xFB, 0x58, 0x38, 0xFA,
  0x02, 0xA0, 0x14, 0x81, 0xDF, 0x52, 0x82, 0xAF, 0xC1, 0x28, 0x19, 0xFD, 0x30, 0x10, 0xDA, 0x83,
  0xDE, 0xFE, 0x34, 0x85, 0x18, 0xDF, 0xEA, 0x23,
  // "P" (U+0050)
  0x05, 0xC0, 0xD0, 0x82, 0x83, 0x5F, 0xEC, 0xEA, 0x83, 0xC0, 0x5F, 0xC2, 0x85, 0x4E, 0xF6, 0x5F,
  0xC3, 0x84, 0x9F, 0xA5, 0xFC, 0x38, 0x46, 0xFC, 0x5F, 0xC3, 0x84, 0x6F, 0xB5, 0xFC, 0x38, 0x49,
  0xF9, 0x5F, 0xC2, 0x05, 0xA8, 0x44, 0x5F, 0xEC, 0xEA, 0x81, 0xA0, 0x5B, 0x81, 0xEC, 0x72, 0x81,
  0x5F, 0xC6, 0x81, 0x5F, 0xC6, 0x81, 0x5F, 0xC6, 0x81, 0x5F, 0xC6, 0x81, 0x5F, 0xC6, 0x81, 0x5F,
  0xC6,
  // "Q" (U+0051)
  0x28, 0x51, 0x9D, 0xFE, 0xA2, 0x40, 0x20, 0xEA, 0x0D, 0x0E, 0xA0, 0x33, 0x82, 0xBF, 0xC1, 0x28,
  0x19, 0xFE, 0x20, 0x3A, 0x02, 0x48, 0x5D, 0xF6, 0x08, 0xFB, 0x58, 0x57, 0xFB, 0x0B, 0xF7, 0x58,
  0x54, 0xFE, 0x0D, 0xF5, 0x50, 0x2A, 0x18, 0x1D, 0xF5, 0x50, 0x2A, 0x82, 0x1D, 0xF5, 0x50, 0x2A,
  0x82, 0x1C, 0xF5, 0x50, 0x2A, 0x18, 0x1A, 0xF7, 0x58, 0x54, 0xFE, 0x07, 0xFB, 0x58, 0x38, 0xFA,
  0x02, 0xA0, 0x14, 0x81, 0xDF, 0x62, 0x82, 0xAF, 0xC1, 0x28, 0x19, 0xFE, 0x30, 0x10, 0xDA, 0x0D,
  0x0E, 0xA0, 0x44, 0x81, 0x19, 0xDB, 0x04, 0x72, 0x81, 0xBF, 0x97, 0x20, 0x2A, 0x05, 0x72, 0x82,
  0x8F, 0xE1, 0x72, 0x81, 0x77, 0x41,
  // "R" (U+0052)
  0x05, 0xB8, 0x1E, 0xC8, 0x38, 0x35, 0xFE, 0xCE, 0xA0, 0xC2, 0x81, 0x5F, 0xC2, 0x86, 0x3E, 0xF6,
  0x05, 0xFC, 0x38, 0x58, 0xFB, 0x05, 0xFC, 0x38, 0x56, 0xFC, 0x05, 0xFC, 0x38, 0x56, 0xFB, 0x05,
  0xFC, 0x38, 0x90, 0xAF, 0x90, 0x5F, 0xC0, 0x17, 0xA8, 0x13, 0x05, 0xE0, 0x62, 0x85, 0x5F, 0xEC,
  0xEF, 0x83, 0x86, 0x5F, 0xC0, 0x3F, 0xE1, 0x28, 0x15, 0xFC, 0x28, 0x1B, 0xF7, 0x28, 0x15, 0xFC,
  0x28, 0x64, 0xFE, 0x10, 0x5F, 0xC3, 0x85, 0xCF, 0x70, 0x5F, 0xC3, 0x85, 0x5F, 0xE1, 0x5F, 0xC4,
  0x81, 0xDF, 0x70,
  // "S" (U+0053)
  0x28, 0x93, 0x2A, 0xEE, 0xD9, 0x30, 0x2E, 0xFE, 0xDA, 0x83, 0x60, 0xAF, 0xA3, 0x84, 0x61, 0x0E,
  0xF3, 0x6A, 0x03, 0x68, 0x1D, 0xF9, 0x60, 0x7A, 0x0B, 0x02, 0x50, 0xBB, 0x08, 0x50, 0x60, 0xEA,
  0x0B, 0x50, 0x10, 0xAA, 0x06, 0x68, 0x1A, 0xFB, 0x68, 0x16, 0xFC, 0x68, 0x47, 0xFB, 0x18, 0x22,
  0x83, 0x2D, 0xF6, 0x2A, 0x0E, 0x0D, 0xA0, 0xB2, 0x84, 0x8C, 0xEF, 0xD7, 0x20,
  // "T" (U+0054)
  0x0B, 0xF9, 0x89, 0x11, 0x9C, 0xCD, 0xFE, 0xCC, 0xC1, 0x38, 0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78,
  0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16,
  0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16, 0xFB,
  0x78, 0x16, 0xFB, 0x40,
  // "U" (U+0055)
  0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA,
  0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8,
  0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4,
  0x02, 0xA8, 0x16, 0xFB, 0x48, 0x43, 0xFE, 0x4F, 0xE4, 0x85, 0x6F, 0xB0, 0xEF, 0x82, 0x84, 0x2D,
  0xF6, 0x05, 0xA0, 0xE0, 0xDA, 0x0C, 0x38, 0x44, 0xBE, 0xFD, 0x82,
  // "V" (U+0056)
  0x81, 0xDF, 0x55, 0x84, 0xAF, 0x89, 0xF9, 0x58, 0x4E, 0xF4, 0x5F, 0xC4, 0x02, 0xA1, 0x01, 0xA0,
  0x13, 0x81, 0x6F, 0xB2, 0x81, 0xDF, 0x43, 0x81, 0xAF, 0x72, 0x81, 0x9F, 0x83, 0x81, 0xDF, 0x32,
  0x81, 0x5F, 0xC2, 0x81, 0x2F, 0xE3, 0x01, 0xA2, 0x81, 0x5F, 0xB4, 0x85, 0xCF, 0x40, 0x9F, 0x74,
  0x85, 0x8F, 0x70, 0xDF, 0x34, 0x84, 0x4F, 0xB1, 0xFE, 0x69, 0x82, 0xE4, 0xFA, 0x68, 0x3C, 0xF9,
  0xF6, 0x68, 0x38, 0xFE, 0xF2, 0x60, 0x4A, 0x0D, 0x71, 0xA0, 0xA4,
  // "W" (U+0057)
  0x81, 0xCF, 0x54, 0x81, 0xBF, 0x74, 0x84, 0x9F, 0x89, 0xF8, 0x48, 0x1E, 0xFA, 0x48, 0x4C, 0xF4,
  0x5F, 0xB3, 0x02, 0xA0, 0xD4, 0xA8, 0x21, 0x2F, 0xE3, 0x83, 0x5F, 0xEF, 0x12, 0x81, 0x3F, 0xD2,
  0x81, 0xEF, 0x22, 0x83, 0x9F, 0xAF, 0x42, 0x81, 0x6F, 0xA2, 0x81, 0xBF, 0x52, 0x83, 0xCF, 0x5F,
  0x82, 0x81, 0x9F, 0x72, 0x81, 0x8F, 0x82, 0x98, 0x2C, 0x2F, 0xB2, 0x81, 0xCF, 0x42, 0x89, 0x05,
  0xFB, 0x03, 0xF9, 0x0E, 0xE2, 0xA0, 0x12, 0x89, 0x42, 0xFE, 0x06, 0xF6, 0x0B, 0xF2, 0x3F, 0xD4,
  0x89, 0x3E, 0xF1, 0x9F, 0x30, 0x7F, 0x56, 0xFA, 0x48, 0x2B, 0xF4, 0xC9, 0x28, 0x44, 0xF8, 0x9F,
  0x74, 0x83, 0x7F, 0x7F, 0xC2, 0x84, 0x1F, 0xAB, 0xF3, 0x48, 0x34, 0xFB, 0xF8, 0x30, 0xFD, 0x95,
  0x01, 0xB0, 0x53, 0x09, 0xA0, 0xD6, 0x0D, 0xA0, 0x23, 0x06, 0xA0, 0x96, 0x81, 0xAF, 0xE4, 0x03,
  0xA0, 0x63,
  // "X" (U+0058)
  0x81, 0x5F, 0xD4, 0x85, 0xBF, 0x70, 0xDF, 0x42, 0x02, 0xA8, 0x31, 0x07, 0xFA, 0x28, 0x18, 0xF9,
  0x28, 0x61, 0xEF, 0x10, 0xEF, 0x23, 0x84, 0x9F, 0x75, 0xFB, 0x48, 0x42, 0xFD, 0xBF, 0x55, 0x0B,
  0xA0, 0xD6, 0x04, 0xA0, 0x76, 0x07, 0xA0, 0x86, 0x0D, 0xA0, 0xE0, 0x14, 0x84, 0x5F, 0xBA, 0xF7,
  0x48, 0x4C, 0xF4, 0x3F, 0xD3, 0x81, 0x4F, 0xD2, 0x81, 0xCF, 0x52, 0x81, 0xBF, 0x62, 0x85, 0x6F,
  0xC0, 0x3F, 0xE4, 0x84, 0xEF, 0x4A, 0xF8, 0x48, 0x19, 0xFB,
  // "Y" (U+0059)
  0x81, 0xCF, 0x74, 0x84, 0xAF, 0x96, 0xFD, 0x30, 0x1A, 0x03, 0x01, 0xA0, 0x32, 0x81, 0x6F, 0xC2,
  0x81, 0xAF, 0x92, 0x81, 0xCF, 0x62, 0x83, 0x4F, 0xE0, 0x2A, 0x01, 0x38, 0x4D, 0xF5, 0x8F, 0xA4,
  0x84, 0x7F, 0xCE, 0xF4, 0x40, 0x1B, 0x0D, 0x60, 0xBA, 0x07, 0x60, 0x5A, 0x01, 0x60, 0x2A, 0x70,
  0x2A, 0x70, 0x2A, 0x70, 0x2A, 0x70, 0x2A, 0x70, 0x2A, 0x40,
  // "Z" (U+005A)
  0x04, 0xF0, 0x80, 0x38, 0x01, 0xCA, 0x07, 0x50, 0x2A, 0x02, 0x58, 0x19, 0xFA, 0x58, 0x21, 0xEF,
  0x35, 0x81, 0x7F, 0xC6, 0x81, 0xDF, 0x55, 0x81, 0x5F, 0xD6, 0x81, 0xCF, 0x75, 0x82, 0x3F, 0xE1,
  0x58, 0x1A, 0xF9, 0x50, 0x1A, 0x02, 0x58, 0x18, 0xFA, 0x68, 0x1E, 0xF4, 0x50, 0x5A, 0x80, 0x1C,
  0x08, 0x06, 0xF0, 0xA0,
  // "[" (U+005B)
  0x08, 0xC8, 0x90, 0x18, 0xFD, 0xCC, 0x08, 0xF6, 0x38, 0x18, 0xF6, 0x38, 0x18, 0xF6, 0x38, 0x18,
  0xF6, 0x38, 0x18, 0xF6, 0x38, 0x18, 0xF6, 0x38, 0x18, 0xF6, 0x38, 0x18, 0xF6, 0x38, 0x18, 0xF6,
  0x38, 0x18, 0xF6, 0x38, 0x18, 0xF6, 0x38, 0x18, 0xF6, 0x38, 0x18, 0xF6, 0x38, 0x18, 0xF6, 0x38,
  0x18, 0xF6, 0x38, 0x58, 0xFD, 0xCC, 0x08, 0xC0, 0x10,
  // "\" (U+005C)
  0x81, 0x8F, 0x55, 0x81, 0x3F, 0xB6, 0x81, 0xDF, 0x15, 0x81, 0x8F, 0x65, 0x81, 0x2F, 0xC6, 0x81,
  0xCF, 0x15, 0x81, 0x7F, 0x75, 0x81, 0x1F, 0xC6, 0x81, 0xCF, 0x25, 0x81, 0x6F, 0x85, 0x81, 0x1F,
  0xD6, 0x81, 0xBF, 0x35, 0x81, 0x5F, 0x86, 0x90, 0xE6, 0x81, 0xAF, 0x45, 0x81, 0x5F, 0x90,
  // "]" (U+005D)
  0x06, 0xC8, 0x52, 0x5C, 0xCE, 0xF2, 0x38, 0x1B, 0xF2, 0x38, 0x1B, 0xF2, 0x38, 0x1B, 0xF2, 0x38,
  0x1B, 0xF2, 0x38, 0x1B, 0xF2, 0x38, 0x1B, 0xF2, 0x38, 0x1B, 0xF2, 0x38, 0x1B, 0xF2, 0x38, 0x1B,
  0xF2, 0x38, 0x1B, 0xF2, 0x38, 0x1B, 0xF2, 0x38, 0x1B, 0xF2, 0x38, 0x1B, 0xF2, 0x38, 0x1B, 0xF2,
  0x38, 0x90, 0xBF, 0x25, 0xCC, 0xEF, 0x26, 0xC0, 0x20,
  // "^" (U+005E)
  0x40, 0xA0, 0xD7, 0x02, 0xA0, 0x66, 0x82, 0x9F, 0xED, 0x58, 0x41, 0xFB, 0x7F, 0x54, 0x84, 0x8F,
  0x41, 0xEC, 0x40, 0xE0, 0xD2, 0x81, 0x8F, 0x42, 0x81, 0x7F, 0x62, 0x81, 0x1F, 0xC2, 0x0D, 0x0E,
  0x48, 0x49, 0xF3, 0x5F, 0x74, 0x81, 0x2F, 0xB0,
  // "_" (U+005F)
  0x80, 0x5C, 0x04, 0xFA, 0x05,
  // "`" (U+0060)
  0x81, 0x77, 0x32, 0x81, 0x8F, 0xC3, 0x81, 0xAF, 0x53, 0x81, 0xAE, 0x10,
  // "a" (U+0061)
  0x28, 0x45, 0xBE, 0xFB, 0x32, 0x01, 0xA8, 0x2D, 0xEF, 0xE3, 0x85, 0x62, 0x01, 0xDF, 0x56, 0x81,
  0x9F, 0x76, 0x81, 0x8F, 0x82, 0x81, 0x6C, 0xEB, 0x81, 0x80, 0xAA, 0x84, 0xEC, 0xEF, 0x81, 0xA0,
  0x52, 0x84, 0x8F, 0x83, 0xFE, 0x38, 0x29, 0xF8, 0x1A, 0x86, 0x20, 0x3E, 0xF8, 0x0C, 0xA8, 0x94,
  0xDF, 0x9F, 0x80, 0x1B, 0xED, 0x51, 0xF8,
  // "b" (U+0062)
  0x81, 0x8F, 0x76, 0x81, 0x8F, 0x76, 0x81, 0x8F, 0x76, 0x81, 0x8F, 0x76, 0x8A, 0x18, 0xF7, 0x5D,
  0xEB, 0x20, 0x8F, 0xBF, 0xDE, 0xFD, 0x08, 0xA8, 0x74, 0x01, 0xDF, 0x68, 0xFC, 0x38, 0x47, 0xFB,
  0x8F, 0x93, 0x84, 0x4F, 0xD8, 0xF8, 0x38, 0x42, 0xFE, 0x8F, 0x83, 0x84, 0x3F, 0xE8, 0xF9, 0x38,
  0x44, 0xFD, 0x8F, 0xC3, 0x82, 0x7F, 0xA8, 0xA8, 0xA5, 0x50, 0x1D, 0xF6, 0x8F, 0xBF, 0xEE, 0xFD,
  0x08, 0xF2, 0x6D, 0xFB, 0x21,
  // "c" (U+0063)
  0x18, 0x61, 0x9E, 0xFD, 0x70, 0xCA, 0x89, 0x3D, 0xF9, 0x6F, 0xD1, 0x01, 0x2C, 0xF6, 0x48, 0x1E,
  0xF2, 0x4A, 0x01, 0x4A, 0x5A, 0x02, 0x48, 0x1C, 0xF5, 0x48, 0x27, 0xFD, 0x12, 0x81, 0x31, 0xDA,
  0x89, 0x0D, 0xFA, 0x01, 0xAE, 0xEC, 0x50,
  // "d" (U+0064)
  0x68, 0x19, 0xF6, 0x68, 0x19, 0xF6, 0x68, 0x19, 0xF6, 0x68, 0xA6, 0x9F, 0x60, 0x3C, 0xFC, 0x49,
  0xF6, 0x1E, 0xFE, 0xEF, 0xCF, 0x68, 0xFC, 0x20, 0x7A, 0x82, 0x6C, 0xF5, 0x38, 0x1D, 0xF6, 0xA0,
  0x23, 0x81, 0xAF, 0x6A, 0x01, 0x38, 0x19, 0xF6, 0xA4, 0x81, 0x9F, 0x6A, 0x02, 0x38, 0x4B, 0xF6,
  0xDF, 0x53, 0x84, 0xDF, 0x68, 0xFC, 0x20, 0x7A, 0x8A, 0x16, 0x1E, 0xFE, 0xEF, 0xBF, 0x60, 0x3C,
  0xFD, 0x54, 0xF6,
  // "e" (U+0065)
  0x18, 0x41, 0x9E, 0xEA, 0x22, 0x89, 0x0D, 0xFE, 0xEF, 0xD1, 0x7F, 0xC2, 0x84, 0x9F, 0x7C, 0xF4,
  0x28, 0x12, 0xFC, 0xA0, 0x13, 0xFD, 0x80, 0x2C, 0xA0, 0x15, 0x81, 0xCF, 0x45, 0x82, 0x6F, 0xD2,
  0x28, 0x22, 0x30, 0xCA, 0x89, 0x2D, 0xEF, 0x80, 0x18, 0xDF, 0xDA, 0x30,
  // "f" (U+0066)
  0x28, 0x32, 0xBE, 0xE7, 0x28, 0x7D, 0xFE, 0xD6, 0x02, 0xFE, 0x48, 0x13, 0xFD, 0x30, 0x50, 0xDB,
  0x82, 0xE0, 0x9D, 0xA0, 0xC0, 0xB2, 0x81, 0x3F, 0xC4, 0x81, 0x3F, 0xC4, 0x81, 0x3F, 0xC4, 0x81,
  0x3F, 0xC4, 0x81, 0x3F, 0xC4, 0x81, 0x3F, 0xC4, 0x81, 0x3F, 0xC4, 0x81, 0x3F, 0xC4, 0x81, 0x3F,
  0xC4, 0x81, 0x3F, 0xC3,
  // "g" (U+0067)
  0x18, 0xA2, 0x2B, 0xFD, 0x45, 0xF6, 0x1E, 0xFE, 0xEF, 0xBF, 0x68, 0xFC, 0x20, 0x7A, 0x82, 0x6C,
  0xF5, 0x38, 0x1D, 0xF6, 0xA0, 0x23, 0x81, 0xAF, 0x6A, 0x01, 0x38, 0x19, 0xF6, 0xA4, 0x81, 0x9F,
  0x6A, 0x02, 0x38, 0x4A, 0xF6, 0xDF, 0x53, 0x84, 0xDF, 0x68, 0xFC, 0x20, 0x6A, 0x81, 0x61, 0xEA,
  0x89, 0x4E, 0xFB, 0xF6, 0x03, 0xCF, 0xC4, 0x9F, 0x66, 0x81, 0xAF, 0x56, 0x83, 0xCF, 0x33, 0x43,
  0x83, 0x7F, 0xE0, 0x7A, 0x0D, 0x0E, 0xA8, 0x75, 0x02, 0x9D, 0xFE, 0xB4, 0x20,
  // "h" (U+0068)
  0x81, 0x8F, 0x76, 0x81, 0x8F, 0x76, 0x81, 0x8F, 0x76, 0x81, 0x8F, 0x76, 0x89, 0x48, 0xF7, 0x6D,
  0xFB, 0x20, 0x8F, 0xBF, 0xDA, 0x81, 0xD0, 0x8A, 0x87, 0x40, 0x1E, 0xF4, 0x8F, 0xC3, 0x84, 0xAF,
  0x68, 0xF9, 0x38, 0x49, 0xF7, 0x8F, 0x83, 0x84, 0x9F, 0x78, 0xF7, 0x38, 0x49, 0xF7, 0x8F, 0x73,
  0x84, 0x9F, 0x78, 0xF7, 0x38, 0x49, 0xF7, 0x8F, 0x73, 0x84, 0x9F, 0x78, 0xF7, 0x38, 0x49, 0xF7,
  0x8F, 0x73, 0x81, 0x9F, 0x70,
  // "i" (U+0069)
  0x87, 0x5E, 0x59, 0xF9, 0x4C, 0x43, 0x8C, 0x28, 0xF7, 0x8F, 0x78, 0xF7, 0x8F, 0x78, 0xF7, 0x8F,
  0x78, 0xF7, 0x8F, 0x78, 0xF7, 0x8F, 0x78, 0xF7, 0x8F, 0x70,
  // "j" (U+006A)
  0x28, 0x15, 0xE5, 0x28, 0x19, 0xF9, 0x28, 0x14, 0xC4, 0x78, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28,
  0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18,
  0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7,
  0x28, 0x18, 0xF7, 0x28, 0x3B, 0xF5, 0x8E, 0xA8, 0x31, 0x8F, 0xD5, 0x10,
  // "k" (U+006B)
  0x81, 0x8F, 0x76, 0x81, 0x8F, 0x76, 0x81, 0x8F, 0x76, 0x81, 0x8F, 0x76, 0x81, 0x8F, 0x72, 0x85,
  0x3F, 0xE2, 0x8F, 0x72, 0x89, 0x1C, 0xF6, 0x08, 0xF7, 0x07, 0xFB, 0x28, 0x58, 0xF7, 0x2F, 0xE1,
  0x28, 0x48, 0xF7, 0xCF, 0x53, 0x81, 0x8F, 0xCA, 0x06, 0x30, 0x8A, 0x81, 0xCF, 0xD3, 0x85, 0x8F,
  0xB0, 0xCF, 0x62, 0x85, 0x8F, 0x70, 0x5F, 0xD2, 0x81, 0x8F, 0x72, 0x85, 0xDF, 0x60, 0x8F, 0x72,
  0x85, 0x6F, 0xD0, 0x8F, 0x73, 0x81, 0xDF, 0x60,
  // "l" (U+006C)
  0x8D, 0x68, 0xF7, 0x8F, 0x78, 0xF7, 0x8F, 0x78, 0xF7, 0x8F, 0x78, 0xF7, 0x8F, 0x78, 0xF7, 0x8F,
  0x78, 0xF7, 0x8F, 0x78, 0xF7, 0x8F, 0x78, 0xF7, 0x8F, 0x70,
  // "m" (U+006D)
  0x8A, 0x18, 0xF2, 0x7D, 0xEA, 0x11, 0xAE, 0xE8, 0x08, 0xFA, 0xFD, 0xA8, 0x2B, 0xCF, 0xEA, 0x05,
  0x08, 0xA8, 0x13, 0x05, 0xA8, 0x7D, 0x10, 0x9F, 0xB8, 0xFC, 0x38, 0x1E, 0xF7, 0x28, 0x44, 0xFD,
  0x8F, 0x93, 0x81, 0xDF, 0x42, 0x84, 0x2F, 0xD8, 0xF8, 0x38, 0x1D, 0xF3, 0x28, 0x42, 0xFD, 0x8F,
  0x73, 0x81, 0xDF, 0x32, 0x84, 0x2F, 0xD8, 0xF7, 0x38, 0x1D, 0xF3, 0x28, 0x42, 0xFD, 0x8F, 0x73,
  0x81, 0xDF, 0x32, 0x84, 0x2F, 0xD8, 0xF7, 0x38, 0x1D, 0xF3, 0x28, 0x42, 0xFD, 0x8F, 0x73, 0x81,
  0xDF, 0x32, 0x84, 0x2F, 0xD8, 0xF7, 0x38, 0x1D, 0xF3, 0x28, 0x12, 0xFD,
  // "n" (U+006E)
  0x89, 0x48, 0xF2, 0x6D, 0xFB, 0x20, 0x8F, 0xAF, 0xDA, 0x81, 0xD0, 0x8A, 0x87, 0x40, 0x1E, 0xF4,
  0x8F, 0xC3, 0x84, 0xAF, 0x68, 0xF9, 0x38, 0x49, 0xF7, 0x8F, 0x73, 0x84, 0x9F, 0x78, 0xF7, 0x38,
  0x49, 0xF7, 0x8F, 0x73, 0x84, 0x9F, 0x78, 0xF7, 0x38, 0x49, 0xF7, 0x8F, 0x73, 0x84, 0x9F, 0x78,
  0xF7, 0x38, 0x49, 0xF7, 0x8F, 0x73, 0x81, 0x9F, 0x70,
  // "o" (U+006F)
  0x18, 0x41, 0x9E, 0xFC, 0x53, 0x82, 0xCF, 0xED, 0xA8, 0x94, 0x60, 0x7F, 0xC1, 0x04, 0xFE, 0x0C,
  0xF5, 0x38, 0x1C, 0xF5, 0xA0, 0x23, 0x81, 0x9F, 0x8A, 0x01, 0x38, 0x17, 0xF9, 0xA0, 0x13, 0x84,
  0x7F, 0x9E, 0xF2, 0x38, 0x49, 0xF8, 0xBF, 0x63, 0x89, 0x1C, 0xF4, 0x6F, 0xC1, 0x04, 0xFE, 0x28,
  0x2B, 0xFE, 0xDA, 0x05, 0x38, 0x38, 0xDE, 0xC5, 0x20,
  // "p" (U+0070)
  0x8A, 0x18, 0xF3, 0x5D, 0xEB, 0x20, 0x8F, 0xAF, 0xDE, 0xFD, 0x08, 0xA8, 0x75, 0x01, 0xDF, 0x68,
  0xFB, 0x38, 0x47, 0xFB, 0x8F, 0x93, 0x84, 0x4F, 0xD8, 0xF7, 0x38, 0x43, 0xFE, 0x8F, 0x73, 0x84,
  0x2F, 0xE8, 0xF9, 0x38, 0x44, 0xFD, 0x8F, 0xC3, 0x82, 0x7F, 0xA8, 0xA8, 0xB1, 0x50, 0x1D, 0xF6,
  0x8F, 0xBF, 0xDE, 0xFD, 0x08, 0xF7, 0x6D, 0xFB, 0x20, 0x8F, 0x76, 0x81, 0x8F, 0x76, 0x81, 0x8F,
  0x76, 0x81, 0x8F, 0x76, 0x81, 0x8F, 0x76,
  // "q" (U+0071)
  0x18, 0xA2, 0x2B, 0xFD, 0x55, 0xF6, 0x1E, 0xFE, 0xDF, 0xBF, 0x68, 0xFC, 0x20, 0x6A, 0x82, 0x6C,
  0xF6, 0x38, 0x1D, 0xF6, 0xA0, 0x23, 0x81, 0xAF, 0x6A, 0x01, 0x38, 0x19, 0xF6, 0xA4, 0x81, 0x9F,
  0x6A, 0x02, 0x38, 0x4A, 0xF6, 0xDF, 0x53, 0x84, 0xDF, 0x68, 0xFC, 0x20, 0x6A, 0x8A, 0x16, 0x1E,
  0xFE, 0xEF, 0xBF, 0x60, 0x3C, 0xFC, 0x49, 0xF6, 0x68, 0x19, 0xF6, 0x68, 0x19, 0xF6, 0x68, 0x19,
  0xF6, 0x68, 0x19, 0xF6, 0x68, 0x19, 0xF6,
  // "r" (U+0072)
  0x89, 0x38, 0xF2, 0x5D, 0xE8, 0xF8, 0xFE, 0xD8, 0xA0, 0x82, 0x81, 0x8F, 0xE3, 0x81, 0x8F, 0x93,
  0x81, 0x8F, 0x83, 0x81, 0x8F, 0x73, 0x81, 0x8F, 0x73, 0x81, 0x8F, 0x73, 0x81, 0x8F, 0x73, 0x81,
  0x8F, 0x73, 0x81, 0x8F, 0x73,
  // "s" (U+0073)
  0x18, 0x92, 0x18, 0xDE, 0xD8, 0x10, 0xBF, 0xED, 0xA8, 0x92, 0x21, 0xFE, 0x10, 0x16, 0x02, 0xFD,
  0x68, 0x2D, 0xFA, 0x14, 0x83, 0x3E, 0xFE, 0x74, 0x01, 0x0A, 0xA0, 0xA5, 0x82, 0x4E, 0xF4, 0x58,
  0x39, 0xF6, 0x25, 0x38, 0x2C, 0xF4, 0x3A, 0x89, 0x2D, 0xEF, 0xD0, 0x19, 0xDF, 0xDA, 0x21,
  // "t" (U+0074)
  0x20, 0x60, 0x55, 0x0E, 0x09, 0x48, 0x13, 0xF9, 0x30, 0x40, 0xDC, 0x18, 0x48, 0xEF, 0xEC, 0xC2,
  0x81, 0x7F, 0x94, 0x81, 0x7F, 0x94, 0x81, 0x7F, 0x94, 0x81, 0x7F, 0x94, 0x81, 0x7F, 0x94, 0x81,
  0x7F, 0x94, 0x81, 0x6F, 0xA4, 0x81, 0x5F, 0xD4, 0x01, 0xA8, 0x1D, 0xE1, 0x28, 0x25, 0xDF, 0xC1,
  // "u" (U+0075)
  0x81, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7,
  0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF,
  0x69, 0xF7, 0x38, 0x4B, 0xF6, 0x8F, 0x83, 0x84, 0xEF, 0x66, 0xFD, 0x20, 0x4A, 0x8A, 0x16, 0x0E,
  0xFC, 0xBF, 0xCF, 0x60, 0x4C, 0xFD, 0x64, 0xF6,
  // "v" (U+0076)
  0x81, 0xCF, 0x53, 0x84, 0x4F, 0xD8, 0xF8, 0x38, 0x48, 0xF9, 0x3F, 0xC3, 0x85, 0xBF, 0x40, 0xEF,
  0x12, 0xA2, 0x85, 0xAF, 0x40, 0x4F, 0xB2, 0x85, 0x6F, 0x80, 0x7F, 0x72, 0x85, 0x2F, 0xC0, 0xBF,
  0x33, 0x83, 0xDF, 0x1F, 0xE4, 0x83, 0x9F, 0x7F, 0xA4, 0x83, 0x4F, 0xDF, 0x55, 0xB0, 0x15, 0x81,
  0xBF, 0xC3,
  // "w" (U+0077)
  0x81, 0xBF, 0x52, 0x01, 0xA0, 0x63, 0xA8, 0x17, 0xF8, 0x20, 0x4A, 0x0A, 0x28, 0x43, 0xFC, 0x4F,
  0xC2, 0x82, 0x8F, 0xDD, 0x28, 0x46, 0xF8, 0x0F, 0xE2, 0x8C, 0x2B, 0xE9, 0xF1, 0x09, 0xF5, 0x0C,
  0xF2, 0x0E, 0xB7, 0xF4, 0x0D, 0xF1, 0x09, 0xF5, 0x3F, 0x83, 0xF7, 0x0F, 0xD2, 0x89, 0x26, 0xF8,
  0x6F, 0x50, 0xFA, 0x3F, 0xA2, 0x89, 0x22, 0xFB, 0x8F, 0x10, 0xDD, 0x6F, 0x73, 0x82, 0xED, 0xBE,
  0x28, 0x39, 0xF9, 0xF3, 0x38, 0x2B, 0xFE, 0xA2, 0x81, 0x6F, 0xE9, 0x40, 0x8A, 0x07, 0x20, 0x3A,
  0x0C, 0x40, 0x4A, 0x04, 0x3A, 0x08, 0x20,
  // "x" (U+0078)
  0x81, 0x5F, 0xD3, 0x8A, 0x2A, 0xF8, 0x0C, 0xF5, 0x02, 0xFE, 0x10, 0x5F, 0xC0, 0x9F, 0x83, 0x84,
  0xCF, 0x5F, 0xE1, 0x30, 0x5B, 0x08, 0x50, 0xCA, 0x01, 0x50, 0xEA, 0x02, 0x48, 0x37, 0xFE, 0xFA,
  0x48, 0x4E, 0xF3, 0xEF, 0x22, 0x85, 0x7F, 0xA0, 0x8F, 0xA2, 0x89, 0x1E, 0xF3, 0x01, 0xEF, 0x27,
  0xFB, 0x38, 0x19, 0xFA,
  // "y" (U+0079)
  0x81, 0xCF, 0x53, 0x84, 0x4F, 0xD7, 0xFA, 0x38, 0x48, 0xF9, 0x3F, 0xE3, 0x85, 0xCF, 0x40, 0xDF,
  0x22, 0xA2, 0x85, 0x9F, 0x70, 0x4F, 0xB2, 0x85, 0x4F, 0xB0, 0x8F, 0x73, 0x84, 0xEE, 0x0C, 0xF2,
  0x38, 0x3A, 0xF4, 0xFD, 0x48, 0x36, 0xFA, 0xF9, 0x40, 0x1B, 0x05, 0x50, 0xCA, 0x01, 0x58, 0x18,
  0xFB, 0x68, 0x1A, 0xF7, 0x68, 0x1E, 0xF2, 0x58, 0x17, 0xFC, 0x40, 0x80, 0xEA, 0x04, 0x48, 0x28,
  0xFD, 0x55,
  // "z" (U+007A)
  0x02, 0xE1, 0x85, 0x2C, 0xCC, 0xDF, 0xE5, 0x81, 0x9F, 0x84, 0x01, 0xA0, 0x14, 0x81, 0x8F, 0x94,
  0x82, 0x1E, 0xF2, 0x48, 0x17, 0xFA, 0x58, 0x1E, 0xF3, 0x48, 0x17, 0xFB, 0x58, 0x1D, 0xF3, 0x40,
  0x5A, 0x80, 0x0C, 0x02, 0x06, 0xE0, 0x20,
  // "{" (U+007B)
  0x48, 0x17, 0xDE, 0x30, 0x7A, 0x0D, 0x38, 0x1E, 0xF5, 0x49, 0x0E, 0x48, 0x11, 0xFE, 0x48, 0x11,
  0xFE, 0x48, 0x11, 0xFE, 0x48, 0x12, 0xFD, 0x38, 0x21, 0xAF, 0x92, 0x05, 0xA0, 0x90, 0x12, 0x83,
  0x4E, 0xFD, 0x34, 0x81, 0x7F, 0xB4, 0x81, 0x1F, 0xD4, 0x81, 0x1F, 0xE4, 0x81, 0x1F, 0xE5, 0x90,
  0xE5, 0x81, 0xEF, 0x44, 0x09, 0xA0, 0xD4, 0x81, 0x8D, 0xE0,
  // "|" (U+007C)
  0x8F, 0x52, 0xF9, 0x2F, 0x92, 0xF9, 0x2F, 0x92, 0xF9, 0x2F, 0x92, 0xF9, 0x2F, 0x92, 0xF9, 0x2F,
  0x92, 0xF9, 0x2F, 0x92, 0xF9, 0x2F, 0x92, 0xF9, 0x2F, 0x92, 0xF9, 0x2F, 0x92, 0xF9, 0x2F, 0x92,
  0xF9,
  // "}" (U+007D)
  0x82, 0x3E, 0xC5, 0x40, 0x30, 0xEA, 0x04, 0x58, 0x19, 0xFA, 0x58, 0x13, 0xFC, 0x58, 0x12, 0xFC,
  0x58, 0x12, 0xFC, 0x58, 0x12, 0xFC, 0x58, 0x12, 0xFE, 0x68, 0x2D, 0xF7, 0x14, 0x03, 0x0B, 0xA0,
  0x13, 0x82, 0x5D, 0xFD, 0x4A, 0x04, 0x48, 0x12, 0xFD, 0x58, 0x12, 0xFC, 0x58, 0x12, 0xFC, 0x58,
  0x13, 0xFC, 0x58, 0x18, 0xFA, 0x30, 0x30, 0xEA, 0x05, 0x38, 0x23, 0xEC, 0x64,
  // "~" (U+007E)
  0x18, 0x38, 0xEE, 0xA4, 0x28, 0x44, 0x54, 0xFD, 0xEA, 0x84, 0xED, 0xF6, 0x46, 0x28, 0x34, 0xAE,
  0xE9, 0x10,
  // "¡" (U+00A1)
  0x87, 0x5E, 0x99, 0xFE, 0x5E, 0x96, 0x8B, 0x73, 0xF6, 0x3F, 0x74, 0xF8, 0x4F, 0x85, 0xF9, 0x6F,
  0x96, 0xFA, 0x7F, 0xB7, 0xFB, 0x8F, 0xC9, 0xFD,
  // "¢" (U+00A2)
  0x49, 0x05, 0x69, 0x05, 0x40, 0x50, 0xCA, 0x82, 0xC3, 0x05, 0xD8, 0x90, 0x40, 0xDF, 0xB2, 0x15,
  0x02, 0xA0, 0x14, 0x81, 0x5F, 0xC5, 0x81, 0x6F, 0xB5, 0x81, 0x6F, 0xB5, 0x81, 0x5F, 0xC5, 0x02,
  0xA6, 0x87, 0xDF, 0xA1, 0x04, 0x30, 0x4D, 0x05, 0x28, 0x44, 0xBF, 0xD9, 0x14, 0x90, 0x56, 0x90,
  0x52,
  // "£" (U+00A3)
  0x38, 0x41, 0xAE, 0xEC, 0x64, 0x84, 0xDF, 0xED, 0xFD, 0x38, 0x54, 0xFD, 0x10, 0x24, 0x38, 0x17,
  0xF9, 0x78, 0x18, 0xF8, 0x78, 0x18, 0xF8, 0x78, 0x18, 0xF8, 0x58, 0x62, 0xCE, 0xFE, 0xCC, 0x82,
  0x02, 0xE0, 0x94, 0x81, 0x8F, 0x87, 0x81, 0x8F, 0x87, 0x81, 0x8F, 0x87, 0x81, 0xBF, 0x56, 0x81,
  0x3F, 0xC6, 0x82, 0x1E, 0xFD, 0x80, 0x1C, 0x04, 0x02, 0xF9, 0x05,
  // "¤" (U+00A4)
  0x01, 0x04, 0x68, 0x94, 0x50, 0xAE, 0x4A, 0xED, 0x77, 0xF5, 0x2E, 0xA0, 0xD0, 0xEA, 0x0B, 0x28,
  0x1A, 0xE4, 0x28, 0x57, 0xF5, 0x01, 0xF6, 0x48, 0x4B, 0xB0, 0x3F, 0x34, 0x84, 0x8D, 0x01, 0xF6,
  0x40, 0x0B, 0x28, 0x1B, 0xE3, 0x28, 0x47, 0xF6, 0x02, 0xEA, 0x0D, 0x0E, 0xA8, 0x94, 0xA0, 0xAE,
  0x4A, 0xED, 0x78, 0xF4, 0x14, 0x60, 0x61,
  // "¥" (U+00A5)
  0x81, 0x5F, 0xD4, 0x85, 0xDF, 0x50, 0xEF, 0x32, 0x81, 0x2F, 0xE2, 0x81, 0xAF, 0x82, 0x81, 0x8F,
  0xA2, 0x81, 0x4F, 0xD2, 0x81, 0xDF, 0x53, 0x84, 0xEF, 0x32, 0xFE, 0x48, 0x49, 0xF9, 0x8F, 0x94,
  0x84, 0x4F, 0xED, 0xF4, 0x50, 0xEA, 0x0E, 0x48, 0x11, 0x2A, 0xA8, 0x1A, 0x21, 0x20, 0x9E, 0x0A,
  0x28, 0x13, 0x55, 0xA8, 0x15, 0x53, 0x5A, 0x01, 0x40, 0x9E, 0x0A, 0x28, 0x17, 0xCC, 0xA8, 0x1D,
  0xC8, 0x5A, 0x01, 0x7A, 0x01, 0x30,
  // "¦" (U+00A6)
  0x8A, 0x62, 0xF9, 0x2F, 0x92, 0xF9, 0x2F, 0x92, 0xF9, 0x2F, 0x92, 0xF9, 0x2F, 0x97, 0x71, 0x8A,
  0x62, 0xF9, 0x2F, 0x92, 0xF9, 0x2F, 0x92, 0xF9, 0x2F, 0x92, 0xF9, 0x2F, 0x90,
  // "§" (U+00A7)
  0x18, 0x56, 0xCE, 0xD9, 0x26, 0xA0, 0xDA, 0x82, 0x5C, 0xF3, 0x28, 0x36, 0x0C, 0xF2, 0x48, 0x25,
  0xFD, 0x64, 0x0C, 0xA8, 0x92, 0xD4, 0x09, 0xF5, 0x7E, 0xF4, 0xFB, 0x28, 0x43, 0xFA, 0xDE, 0x22,
  0x90, 0xA0, 0x5A, 0x85, 0x88, 0xF4, 0x02, 0xBA, 0x0A, 0x48, 0x23, 0xDF, 0x44, 0x83, 0x3F, 0x97,
  0x12, 0x81, 0x7F, 0x9A, 0x0D, 0x0E, 0xA8, 0x53, 0x6C, 0xEE, 0xB3, 0x10,
  // "¨" (U+00A8)
  0x89, 0x41, 0xB7, 0x04, 0xB3, 0x2D, 0x90, 0x6E, 0x40,
  // "©" (U+00A9)
  0x48, 0x64, 0xAD, 0xFE, 0xC7, 0x16, 0x01, 0x0B, 0xB0, 0xD0, 0xEA, 0x0E, 0x05, 0x48, 0x31, 0xDF,
  0xA3, 0x38, 0x31, 0x7E, 0xF5, 0x38, 0xB7, 0xBF, 0x50, 0x2B, 0xEE, 0xB4, 0x2D, 0xF2, 0x04, 0xF7,
  0x02, 0xEF, 0xED, 0xF8, 0x02, 0xEA, 0x09, 0xD2, 0x81, 0xBF, 0x72, 0x00, 0x12, 0x83, 0x8F, 0x0D,
  0x82, 0x90, 0xC7, 0x87, 0x2F, 0x4F, 0x50, 0x2F, 0x97, 0x18, 0x6E, 0x6F, 0x40, 0x2F, 0x97, 0x18,
  0x2D, 0x6D, 0x62, 0x90, 0xC7, 0x19, 0x81, 0x49, 0x92, 0x81, 0xBF, 0x63, 0x01, 0x28, 0x32, 0xF1,
  0x4E, 0x20, 0x3A, 0x82, 0xED, 0xF6, 0x20, 0x90, 0xB2, 0x0B, 0x09, 0x28, 0x90, 0x3B, 0xEE, 0xB2,
  0x03, 0xF3, 0x28, 0x11, 0xE8, 0x78, 0x13, 0xE6, 0x48, 0x91, 0x2C, 0xC6, 0x20, 0x13, 0x9E, 0x57,
  0x86, 0x5A, 0xDF, 0xEC, 0x71, 0x40,
  // "ª" (U+00AA)
  0x18, 0xC1, 0x8D, 0xFC, 0x30, 0x32, 0x1B, 0xB0, 0x6C, 0xEF, 0xD4, 0xF6, 0x1A, 0xD5, 0xF4, 0x2E,
  0xD0, 0xBE, 0xB7, 0xD0,
  // "«" (U+00AB)
  0x38, 0x56, 0xB2, 0x02, 0xC4, 0x28, 0x97, 0x3F, 0xD1, 0x0D, 0xF3, 0x01, 0xDF, 0x40, 0xAF, 0x82,
  0x85, 0xAF, 0x90, 0x7F, 0xD2, 0x02, 0xA8, 0x33, 0x0E, 0xF7, 0x38, 0x68, 0xFB, 0x04, 0xFE, 0x13,
  0x85, 0xBF, 0x60, 0x8F, 0xA3, 0x86, 0x1E, 0xE2, 0x0B, 0xF5, 0x30, 0x40, 0x72, 0x81, 0x19, 0x10,
  // "¬" (U+00AC)
  0x03, 0x80, 0x4C, 0x02, 0x03, 0xF9, 0x03, 0x78, 0x17, 0xF3, 0x78, 0x17, 0xF3, 0x78, 0x17, 0xF3,
  0x78, 0x17, 0xF3,
  // "®" (U+00AE)
  0x48, 0x64, 0xAD, 0xFE, 0xC7, 0x16, 0x01, 0x0B, 0xB0, 0xD0, 0xEA, 0x0E, 0x05, 0x48, 0x31, 0xDF,
  0xA3, 0x38, 0x31, 0x7E, 0xF5, 0x38, 0x2B, 0xF5, 0x2B, 0x89, 0x6D, 0x70, 0x2D, 0xF2, 0x04, 0xF7,
  0x02, 0xFE, 0xDA, 0x86, 0x70, 0x2E, 0xA0, 0x9D, 0x28, 0x52, 0xF7, 0x01, 0xFB, 0x28, 0x38, 0xF0,
  0xD8, 0x28, 0x52, 0xF7, 0x02, 0xFA, 0x28, 0x32, 0xF4, 0xF5, 0x28, 0x22, 0xFE, 0xDA, 0x04, 0x38,
  0x2E, 0x6F, 0x42, 0x02, 0xC0, 0x74, 0x82, 0xD6, 0xD6, 0x28, 0x42, 0xF7, 0x1E, 0xB4, 0x98, 0x14,
  0x99, 0x28, 0x52, 0xF7, 0x08, 0xF3, 0x28, 0x32, 0xF1, 0x4E, 0x28, 0x52, 0xF7, 0x01, 0xFB, 0x20,
  0x90, 0xB2, 0x84, 0xB9, 0x02, 0xC6, 0x28, 0x48, 0xC2, 0x3F, 0x32, 0x81, 0x1E, 0x87, 0x81, 0x3E,
  0x64, 0x89, 0x12, 0xCC, 0x62, 0x01, 0x39, 0xE5, 0x78, 0x65, 0xAD, 0xFE, 0xC7, 0x14,
  // "¯" (U+00AF)
  0x18, 0x05, 0xC0, 0xA0, 0x1F, 0xA0, 0xC0,
  // "°" (U+00B0)
  0x18, 0x25, 0xBB, 0x62, 0x07, 0xC8, 0x91, 0x70, 0xEB, 0x11, 0xBE, 0x0F, 0x62, 0x83, 0x5F, 0x1E,
  0xA2, 0x87, 0x9F, 0x08, 0xFE, 0xEF, 0x92, 0x82, 0x8E, 0xE8, 0x20,
  // "±" (U+00B1)
  0x40, 0xC0, 0xE7, 0x10, 0xC0, 0xE7, 0x10, 0xC0, 0xE7, 0x10, 0xC0, 0xE4, 0x03, 0xF9, 0x05, 0x03,
  0x0F, 0xCA, 0x0F, 0xC0, 0x44, 0x0C, 0x0E, 0x71, 0x0C, 0x0E, 0x71, 0x0C, 0x0E, 0x71, 0x0C, 0x0E,
  0x77, 0x03, 0x80, 0x4C, 0x04, 0x03, 0xF9, 0x05,
  // "²" (U+00B2)
  0x30, 0x14, 0x09, 0xA8, 0x7D, 0x20, 0x2E, 0x76, 0xEB, 0x50, 0xB0, 0xE5, 0x0E, 0x0B, 0x48, 0x18,
  0xF4, 0x38, 0x15, 0xF7, 0x38, 0x13, 0xF9, 0x38, 0x62, 0xEC, 0x21, 0x10, 0x7D, 0x01, 0x02, 0x80,
  0x14, 0x10,
  // "³" (U+00B3)
  0x30, 0x13, 0x01, 0x0A, 0xA8, 0x7D, 0x20, 0x2D, 0x66, 0xEB, 0x50, 0xB0, 0xD3, 0x82, 0x24, 0xE8,
  0x20, 0x2A, 0x0C, 0x01, 0x38, 0x24, 0x6E, 0xC5, 0x89, 0x17, 0xF1, 0x45, 0x23, 0xCF, 0x05, 0xB0,
  0xE0, 0x52, 0x81, 0x13, 0x33,
  // "´" (U+00B4)
  0x28, 0x13, 0x77, 0x28, 0x91, 0xCF, 0x80, 0x5F, 0xA0, 0x1E, 0xB2,
  // "µ" (U+00B5)
  0x81, 0x9F, 0x73, 0x84, 0x9F, 0x79, 0xF7, 0x38, 0x49, 0xF7, 0x9F, 0x73, 0x84, 0x9F, 0x79, 0xF7,
  0x38, 0x49, 0xF7, 0x9F, 0x73, 0x84, 0x9F, 0x79, 0xF7, 0x38, 0x49, 0xF7, 0x9F, 0x73, 0x84, 0x9F,
  0x79, 0xF7, 0x38, 0x4A, 0xF7, 0x9F, 0x93, 0x87, 0xEF, 0x79, 0xFE, 0x10, 0x6A, 0x07, 0x09, 0xA8,
  0xA0, 0xED, 0xFB, 0xF7, 0x9F, 0x9D, 0xE7, 0x3F, 0x79, 0xF7, 0x68, 0x19, 0xF7, 0x68, 0x19, 0xF7,
  0x68, 0x19, 0xF7, 0x68, 0x19, 0xF7, 0x60,
  // "¶" (U+00B6)
  0x10, 0x30, 0xBD, 0x81, 0x81, 0xEB, 0x83, 0xEC, 0xE8, 0x6C, 0x83, 0xA0, 0xB8, 0xAC, 0x83, 0xA0,
  0xB8, 0xCC, 0x83, 0xA0, 0xB8, 0xCC, 0x83, 0xA0, 0xB8, 0xCC, 0x83, 0xA0, 0xB8, 0xBC, 0x83, 0xA0,
  0xB8, 0x8C, 0x83, 0xA0, 0xB8, 0x3C, 0x84, 0xA0, 0xB8, 0x09, 0xB8, 0x2A, 0x0B, 0x82, 0x85, 0x24,
  0xBA, 0x0B, 0x84, 0x83, 0xAA, 0x0B, 0x84, 0x83, 0xAA, 0x0B, 0x84, 0x83, 0xAA, 0x0B, 0x84, 0x83,
  0xAA, 0x0B, 0x84, 0x83, 0xAA, 0x0B, 0x84, 0x83, 0xAA, 0x0B, 0x84, 0x83, 0xAA, 0x0B, 0x84, 0x83,
  0x88, 0x09, 0x70,
  // "·" (U+00B7)
  0x87, 0x6E, 0x8A, 0xFD, 0x6E, 0x80,
  // "¸" (U+00B8)
  0x18, 0x58, 0x50, 0x1D, 0xD4, 0x28, 0x5C, 0xE9, 0x9F, 0xEE, 0xA8, 0x26, 0x23, 0x11,
  // "¹" (U+00B9)
  0x18, 0x23, 0xDE, 0x6A, 0x83, 0xED, 0x8A, 0xE2, 0x0A, 0x0E, 0x20, 0xA0, 0xE2, 0x0A, 0x0E, 0x20,
  0xA0, 0xE2, 0x0A, 0x0E, 0x20, 0xA0, 0xE0,
  // "º" (U+00BA)
  0x18, 0x32, 0xBE, 0xC3, 0x28, 0xC6, 0xDA, 0x19, 0xE1, 0x3F, 0x40, 0x2F, 0x55, 0xF2, 0x01, 0xF6,
  0x4F, 0x30, 0x2F, 0x50, 0xE9, 0x07, 0xE1, 0x04, 0xDF, 0xE5, 0x40, 0x13,
  // "»" (U+00BB)
  0x09, 0x08, 0x20, 0x70, 0xB3, 0x85, 0xBF, 0x50, 0x8F, 0x92, 0x86, 0x2E, 0xE2, 0x0C, 0xF5, 0x28,
  0x66, 0xFD, 0x03, 0xFE, 0x22, 0x8B, 0x6E, 0xF5, 0x0B, 0xF9, 0x09, 0xFB, 0x05, 0xFD, 0x14, 0xFD,
  0x11, 0xEF, 0x30, 0xDF, 0x30, 0xAF, 0x72, 0x00, 0x62, 0x04, 0x08, 0x30,
  // "¼" (U+00BC)
  0x28, 0x15, 0xEB, 0x58, 0x11, 0xEA, 0x40, 0x8A, 0x0B, 0x58, 0x18, 0xF2, 0x38, 0x32, 0xE6, 0xDB,
  0x48, 0x11, 0xF9, 0x58, 0x21, 0x0D, 0xB4, 0x81, 0x9F, 0x17, 0x0D, 0x0B, 0x38, 0x12, 0xF8, 0x71,
  0x0D, 0x0B, 0x38, 0x1A, 0xE1, 0x71, 0x0D, 0x0B, 0x28, 0x13, 0xF7, 0x28, 0x1A, 0xF4, 0x40, 0xD0,
  0xB2, 0x0B, 0x0E, 0x20, 0x3A, 0x04, 0x48, 0x4D, 0xB0, 0x4F, 0x62, 0x82, 0xCB, 0xF4, 0x70, 0xC0,
  0xD2, 0x83, 0x6D, 0x5F, 0x46, 0x89, 0x05, 0xF5, 0x01, 0xE5, 0x5F, 0x46, 0x0D, 0x0C, 0x28, 0x49,
  0xC1, 0x6F, 0x55, 0x81, 0x6F, 0x42, 0x0E, 0xD0, 0x64, 0x0E, 0x0B, 0x30, 0xF4, 0x82, 0x8F, 0x71,
  0x38, 0x17, 0xF3, 0x68, 0x15, 0xF4, 0x10,
  // "½" (U+00BD)
  0x28, 0x15, 0xFA, 0x58, 0x15, 0xF5, 0x40, 0x9A, 0x0A, 0x50, 0xD0, 0xC4, 0x83, 0x3E, 0x5D, 0xA4,
  0x81, 0x6F, 0x45, 0x82, 0x10, 0xEA, 0x40, 0xE0, 0xB7, 0x10, 0xE0, 0xA3, 0x81, 0x7F, 0x37, 0x10,
  0xE0, 0xA2, 0x81, 0x1E, 0xA2, 0x01, 0x60, 0xE0, 0xA2, 0x86, 0x8F, 0x25, 0xEF, 0xE6, 0x48, 0x93,
  0xEA, 0x01, 0xF9, 0x0C, 0x95, 0xCF, 0x13, 0x84, 0xEA, 0x09, 0xF1, 0x48, 0x17, 0xF2, 0x58, 0x12,
  0xF8, 0x50, 0xB0, 0xD6, 0x81, 0xBE, 0x14, 0x81, 0x7F, 0x35, 0x81, 0x3F, 0x74, 0x81, 0x6F, 0x56,
  0x0B, 0x0E, 0x48, 0x16, 0xF5, 0x68, 0x14, 0xF6, 0x30, 0x1A, 0x0F, 0xC0, 0x43, 0x0C, 0x0D, 0x40,
  0x2D, 0x05,
  // "¾" (U+00BE)
  0x18, 0x36, 0xDE, 0xB1, 0x58, 0x19, 0xF1, 0x28, 0x44, 0xFE, 0xDF, 0xA4, 0x81, 0x2F, 0x94, 0x04,
  0x20, 0xB0, 0xD4, 0x81, 0x9F, 0x16, 0x81, 0x2D, 0xA3, 0x81, 0x2F, 0x95, 0x02, 0xA0, 0xC0, 0x13,
  0x81, 0x9F, 0x15, 0x83, 0x2C, 0xEF, 0x72, 0x81, 0x2F, 0x97, 0x28, 0x59, 0xF1, 0x09, 0xF1, 0x50,
  0x13, 0x84, 0x9F, 0x12, 0xF9, 0x28, 0x94, 0x4F, 0x90, 0x6F, 0xDD, 0xFC, 0x09, 0xF1, 0x28, 0x93,
  0xCF, 0x90, 0x2A, 0xEE, 0xA1, 0x2F, 0x92, 0x82, 0x78, 0xF9, 0x78, 0x79, 0xF1, 0x01, 0xE1, 0xF9,
  0x68, 0x12, 0xF9, 0x28, 0x3A, 0x90, 0xF9, 0x68, 0x91, 0x9F, 0x10, 0x3F, 0x31, 0xFA, 0x14, 0x81,
  0x2F, 0x92, 0x08, 0xD0, 0xB4, 0x81, 0x9F, 0x12, 0x85, 0x24, 0x44, 0xFB, 0x33, 0x81, 0x1F, 0x97,
  0x90, 0x91,
  // "¿" (U+00BF)
  0x38, 0x13, 0xEB, 0x50, 0x8A, 0x01, 0x48, 0x14, 0xEB, 0x77, 0x02, 0x01, 0x58, 0x11, 0xFA, 0x58,
  0x14, 0xF9, 0x58, 0x1C, 0xF4, 0x48, 0x1A, 0xFB, 0x48, 0x26, 0xFD, 0x14, 0x81, 0xEF, 0x34, 0x81,
  0x2F, 0xD5, 0x81, 0x3F, 0xC5, 0x01, 0xA0, 0x22, 0x82, 0x72, 0x09, 0xA0, 0xDA, 0x09, 0x28, 0x48,
  0xDF, 0xD8, 0x10,
  // "À" (U+00C0)
  0x28, 0x17, 0x73, 0x71, 0x81, 0x8F, 0xC7, 0x28, 0x1A, 0xF5, 0x72, 0x81, 0xAE, 0x17, 0x75, 0x81,
  0xDF, 0xD7, 0x02, 0xB0, 0x26, 0x83, 0x6F, 0xCF, 0x66, 0x83, 0xAF, 0x6F, 0xA6, 0x83, 0xEE, 0x0E,
  0xE5, 0x85, 0x3F, 0xB0, 0xBF, 0x34, 0x85, 0x7F, 0x70, 0x7F, 0x74, 0x85, 0xBF, 0x30, 0x3F, 0xC4,
  0xA3, 0x0E, 0x93, 0x04, 0xF0, 0x42, 0x08, 0xF0, 0x92, 0x81, 0xCF, 0x53, 0x83, 0x4F, 0xD0, 0x1A,
  0x01, 0x4A, 0x82, 0x15, 0xFD, 0x58, 0x4C, 0xF6, 0x9F, 0x95, 0x84, 0x8F, 0xAD, 0xF5, 0x58, 0x15,
  0xFE,
  // "Á" (U+00C1)
  0x68, 0x13, 0x77, 0x71, 0x81, 0xCF, 0x87, 0x81, 0x5F, 0xA7, 0x81, 0x1E, 0xB7, 0x75, 0x81, 0xDF,
  0xD7, 0x02, 0xB0, 0x26, 0x83, 0x6F, 0xCF, 0x66, 0x83, 0xAF, 0x6F, 0xA6, 0x83, 0xEE, 0x0E, 0xE5,
  0x85, 0x3F, 0xB0, 0xBF, 0x34, 0x85, 0x7F, 0x70, 0x7F, 0x74, 0x85, 0xBF, 0x30, 0x3F, 0xC4, 0xA3,
  0x0E, 0x93, 0x04, 0xF0, 0x42, 0x08, 0xF0, 0x92, 0x81, 0xCF, 0x53, 0x83, 0x4F, 0xD0, 0x1A, 0x01,
  0x4A, 0x82, 0x15, 0xFD, 0x58, 0x4C, 0xF6, 0x9F, 0x95, 0x84, 0x8F, 0xAD, 0xF5, 0x58, 0x15, 0xFE,
  // "Â" (U+00C2)
  0x48, 0x21, 0x77, 0x17, 0x09, 0xA0, 0x96, 0x84, 0x4F, 0x89, 0xF4, 0x50, 0xD0, 0x92, 0x81, 0x9E,
  0x17, 0x72, 0x81, 0xDF, 0xD7, 0x02, 0xB0, 0x26, 0x83, 0x6F, 0xCF, 0x66, 0x83, 0xAF, 0x6F, 0xA6,
  0x83, 0xEE, 0x0E, 0xE5, 0x85, 0x3F, 0xB0, 0xBF, 0x34, 0x85, 0x7F, 0x70, 0x7F, 0x74, 0x85, 0xBF,
  0x30, 0x3F, 0xC4, 0xA3, 0x0E, 0x93, 0x04, 0xF0, 0x42, 0x08, 0xF0, 0x92, 0x81, 0xCF, 0x53, 0x83,
  0x4F, 0xD0, 0x1A, 0x01, 0x4A, 0x82, 0x15, 0xFD, 0x58, 0x4C, 0xF6, 0x9F, 0x95, 0x84, 0x8F, 0xAD,
  0xF5, 0x58, 0x15, 0xFE,
  // "Ã" (U+00C3)
  0x28, 0x54, 0xED, 0x40, 0xA9, 0x48, 0x5C, 0xEE, 0xFD, 0xF6, 0x38, 0x51, 0xF2, 0x19, 0xEB, 0x77,
  0x48, 0x1D, 0xFD, 0x70, 0x2B, 0x02, 0x68, 0x36, 0xFC, 0xF6, 0x68, 0x3A, 0xF6, 0xFA, 0x68, 0x3E,
  0xE0, 0xEE, 0x58, 0x53, 0xFB, 0x0B, 0xF3, 0x48, 0x57, 0xF7, 0x07, 0xF7, 0x48, 0x5B, 0xF3, 0x03,
  0xFC, 0x4A, 0x30, 0xE9, 0x30, 0x4F, 0x04, 0x20, 0x8F, 0x09, 0x28, 0x1C, 0xF5, 0x38, 0x34, 0xFD,
  0x01, 0xA0, 0x14, 0xA8, 0x21, 0x5F, 0xD5, 0x84, 0xCF, 0x69, 0xF9, 0x58, 0x48, 0xFA, 0xDF, 0x55,
  0x81, 0x5F, 0xE0,
  // "Ä" (U+00C4)
  0x28, 0x51, 0xB7, 0x04, 0xB3, 0x48, 0x52, 0xD9, 0x06, 0xE4, 0x77, 0x77, 0x81, 0xDF, 0xD7, 0x02,
  0xB0, 0x26, 0x83, 0x6F, 0xCF, 0x66, 0x83, 0xAF, 0x6F, 0xA6, 0x83, 0xEE, 0x0E, 0xE5, 0x85, 0x3F,
  0xB0, 0xBF, 0x34, 0x85, 0x7F, 0x70, 0x7F, 0x74, 0x85, 0xBF, 0x30, 0x3F, 0xC4, 0xA3, 0x0E, 0x93,
  0x04, 0xF0, 0x42, 0x08, 0xF0, 0x92, 0x81, 0xCF, 0x53, 0x83, 0x4F, 0xD0, 0x1A, 0x01, 0x4A, 0x82,
  0x15, 0xFD, 0x58, 0x4C, 0xF6, 0x9F, 0x95, 0x84, 0x8F, 0xAD, 0xF5, 0x58, 0x15, 0xFE,
  // "Å" (U+00C5)
  0x38, 0x24, 0xDE, 0x77, 0x83, 0xE6, 0x2E, 0x35, 0x84, 0x1F, 0x10, 0xC6, 0x60, 0xEB, 0x03, 0x60,
  0x7B, 0x02, 0x68, 0x36, 0xFC, 0xF6, 0x68, 0x3A, 0xF6, 0xFA, 0x68, 0x3E, 0xE0, 0xEE, 0x58, 0x53,
  0xFB, 0x0B, 0xF3, 0x48, 0x57, 0xF7, 0x07, 0xF7, 0x48, 0x5B, 0xF3, 0x03, 0xFC, 0x4A, 0x30, 0xE9,
  0x30, 0x4F, 0x04, 0x20, 0x8F, 0x09, 0x28, 0x1C, 0xF5, 0x38, 0x34, 0xFD, 0x01, 0xA0, 0x14, 0xA8,
  0x21, 0x5F, 0xD5, 0x84, 0xCF, 0x69, 0xF9, 0x58, 0x48, 0xFA, 0xDF, 0x55, 0x81, 0x5F, 0xE0,
  // "Æ" (U+00C6)
  0x50, 0xEF, 0x94, 0x84, 0x4F, 0xEE, 0xFD, 0x80, 0x0C, 0x48, 0x49, 0xF6, 0xBF, 0x67, 0x18, 0x4E,
  0xF1, 0xBF, 0x67, 0x85, 0x3F, 0xC0, 0xBF, 0x67, 0x85, 0x9F, 0x70, 0xBF, 0x67, 0x85, 0xEF, 0x20,
  0xBF, 0x66, 0x81, 0x3F, 0xD2, 0x0B, 0xD0, 0xB2, 0x81, 0x8F, 0x82, 0x85, 0xBF, 0xDC, 0xCC, 0x92,
  0x86, 0xDF, 0xDC, 0xCE, 0xF6, 0x50, 0x3F, 0x06, 0x58, 0x18, 0xF9, 0x38, 0x1B, 0xF6, 0x58, 0x1D,
  0xF4, 0x38, 0x1B, 0xF6, 0x48, 0x13, 0xFE, 0x48, 0x1B, 0xF6, 0x48, 0x18, 0xFA, 0x48, 0x90, 0xBF,
  0xDC, 0xCC, 0xCD, 0xF6, 0x40, 0xBE,
  // "Ç" (U+00C7)
  0x38, 0x47, 0xCF, 0xEC, 0x62, 0x0B, 0xA8, 0x7E, 0xEF, 0xD0, 0x8F, 0xE3, 0x28, 0x13, 0x51, 0xA0,
  0x45, 0x81, 0x6F, 0xD6, 0x81, 0xAF, 0x96, 0x81, 0xCF, 0x66, 0x81, 0xDF, 0x56, 0x81, 0xDF, 0x56,
  0x81, 0xCF, 0x66, 0x81, 0xAF, 0x86, 0x81, 0x7F, 0xC6, 0x02, 0xA0, 0x36, 0x82, 0xAF, 0xD3, 0x28,
  0x31, 0x30, 0x1D, 0xA8, 0x2D, 0xDF, 0xA3, 0x84, 0x8D, 0xFE, 0xC5, 0x40, 0x80, 0x56, 0x82, 0x1D,
  0xD4, 0x70, 0xC0, 0xE5, 0x82, 0x99, 0xFE, 0x50, 0xEA, 0x06, 0x58, 0x12, 0x31, 0x30,
  // "È" (U+00C8)
  0x18, 0x17, 0x73, 0x58, 0x18, 0xFC, 0x68, 0x1A, 0xF5, 0x68, 0x1A, 0xE1, 0x73, 0x05, 0xE8, 0x92,
  0x75, 0xFE, 0xCC, 0xCC, 0x65, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58,
  0x15, 0xFC, 0x50, 0x5E, 0x89, 0x23, 0x5F, 0xEC, 0xCC, 0xC2, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81,
  0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x87, 0x5F, 0xEC, 0xCC, 0xC6, 0x5E, 0x07,
  // "É" (U+00C9)
  0x48, 0x13, 0x77, 0x58, 0x1C, 0xF8, 0x48, 0x15, 0xFA, 0x48, 0x11, 0xEB, 0x74, 0x05, 0xE8, 0x92,
  0x75, 0xFE, 0xCC, 0xCC, 0x65, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58,
  0x15, 0xFC, 0x50, 0x5E, 0x89, 0x23, 0x5F, 0xEC, 0xCC, 0xC2, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81,
  0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x87, 0x5F, 0xEC, 0xCC, 0xC6, 0x5E, 0x07,
  // "Ê" (U+00CA)
  0x28, 0x21, 0x77, 0x14, 0x09, 0xA0, 0x93, 0x84, 0x4F, 0x89, 0xF4, 0x20, 0xD0, 0x92, 0x81, 0x9E,
  0x17, 0x10, 0x5E, 0x89, 0x27, 0x5F, 0xEC, 0xCC, 0xC6, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F,
  0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x05, 0xE8, 0x92, 0x35, 0xFE, 0xCC, 0xCC, 0x25, 0xFC,
  0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x75, 0xFE, 0xCC,
  0xCC, 0x65, 0xE0, 0x70,
  // "Ë" (U+00CB)
  0x89, 0x51, 0xB7, 0x04, 0xB3, 0x02, 0xD9, 0x06, 0xE4, 0x77, 0x30, 0x5E, 0x89, 0x27, 0x5F, 0xEC,
  0xCC, 0xC6, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5,
  0x05, 0xE8, 0x92, 0x35, 0xFE, 0xCC, 0xCC, 0x25, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58,
  0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x75, 0xFE, 0xCC, 0xCC, 0x65, 0xE0, 0x70,
  // "Ì" (U+00CC)
  0x81, 0x77, 0x33, 0x81, 0x8F, 0xC4, 0x81, 0xAF, 0x54, 0x81, 0xAE, 0x17, 0x04, 0xC8, 0x1D, 0x2B,
  0xA0, 0xD0, 0x82, 0x81, 0xCF, 0x53, 0x81, 0xCF, 0x53, 0x81, 0xCF, 0x53, 0x81, 0xCF, 0x53, 0x81,
  0xCF, 0x53, 0x81, 0xCF, 0x53, 0x81, 0xCF, 0x53, 0x81, 0xCF, 0x53, 0x81, 0xCF, 0x53, 0x81, 0xCF,
  0x53, 0x81, 0xCF, 0x53, 0x89, 0x1C, 0xF5, 0x01, 0x8E, 0xFB, 0x54, 0xC0, 0xD0,
  // "Í" (U+00CD)
  0x48, 0x13, 0x77, 0x48, 0x1C, 0xF8, 0x38, 0x15, 0xFA, 0x38, 0x11, 0xEB, 0x72, 0x04, 0xC8, 0x2D,
  0x02, 0xBA, 0x0D, 0x08, 0x38, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5,
  0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48,
  0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x28, 0x61, 0x8E, 0xFB, 0x50, 0x4C, 0x0D, 0x10,
  // "Î" (U+00CE)
  0x18, 0x21, 0x77, 0x13, 0x09, 0xA0, 0x92, 0x87, 0x4F, 0x89, 0xF4, 0x0D, 0x92, 0x81, 0x9E, 0x17,
  0x04, 0xC8, 0x2D, 0x02, 0xBA, 0x0D, 0x08, 0x38, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5,
  0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48,
  0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x28, 0x61, 0x8E, 0xFB, 0x50,
  0x4C, 0x0D, 0x10,
  // "Ï" (U+00CF)
  0x89, 0x41, 0xB7, 0x04, 0xB3, 0x2D, 0x90, 0x6E, 0x47, 0x70, 0x4C, 0x82, 0xD0, 0x2B, 0xA0, 0xD0,
  0x83, 0x81, 0xCF, 0x54, 0x81, 0xCF, 0x54, 0x81, 0xCF, 0x54, 0x81, 0xCF, 0x54, 0x81, 0xCF, 0x54,
  0x81, 0xCF, 0x54, 0x81, 0xCF, 0x54, 0x81, 0xCF, 0x54, 0x81, 0xCF, 0x54, 0x81, 0xCF, 0x54, 0x81,
  0xCF, 0x54, 0x81, 0xCF, 0x52, 0x86, 0x18, 0xEF, 0xB5, 0x04, 0xC0, 0xD1,
  // "Ð" (U+00D0)
  0x10, 0x5C, 0x81, 0xD9, 0x24, 0x05, 0xA0, 0xC0, 0xDA, 0x0E, 0x04, 0x38, 0x15, 0xFC, 0x28, 0x31,
  0xAF, 0xE1, 0x28, 0x15, 0xFC, 0x48, 0x1C, 0xF8, 0x28, 0x15, 0xFC, 0x48, 0x15, 0xFD, 0x28, 0x15,
  0xFC, 0x40, 0x1A, 0x83, 0x10, 0x5F, 0xC5, 0xA8, 0x13, 0x7D, 0xA8, 0x1C, 0xC2, 0x28, 0x2E, 0xF4,
  0x9D, 0x02, 0x28, 0x5E, 0xF4, 0x05, 0xFC, 0x5A, 0x83, 0x30, 0x5F, 0xC4, 0x02, 0xA2, 0x81, 0x5F,
  0xC4, 0x81, 0x6F, 0xC2, 0x81, 0x5F, 0xC4, 0x81, 0xDF, 0x72, 0x81, 0x5F, 0xC2, 0x82, 0x1B, 0xFD,
  0x30, 0x5A, 0x0C, 0x0D, 0xA0, 0xE0, 0x33, 0x05, 0xC8, 0x1D, 0x81, 0x30,
  // "Ñ" (U+00D1)
  0x38, 0x54, 0xED, 0x40, 0xA9, 0x48, 0x5C, 0xEE, 0xFD, 0xF6, 0x38, 0x51, 0xF2, 0x19, 0xEB, 0x76,
  0x05, 0xA0, 0x64, 0x82, 0x2F, 0xD5, 0xA0, 0xD4, 0x82, 0x2F, 0xD5, 0xB0, 0x53, 0x86, 0x2F, 0xD5,
  0xFE, 0xFC, 0x38, 0x72, 0xFD, 0x5F, 0x9E, 0xF3, 0x28, 0x72, 0xFD, 0x5F, 0x98, 0xFA, 0x28, 0x52,
  0xFD, 0x5F, 0x91, 0xA8, 0xA3, 0x20, 0x2F, 0xD5, 0xF9, 0x09, 0xF9, 0x02, 0xFD, 0x5F, 0x90, 0x2A,
  0x85, 0x12, 0xFD, 0x5F, 0x92, 0x87, 0xAF, 0x82, 0xFD, 0x5F, 0x92, 0x87, 0x3F, 0xE2, 0xFD, 0x5F,
  0x93, 0x86, 0xCF, 0x7F, 0xD5, 0xF9, 0x38, 0x65, 0xFE, 0xFD, 0x5F, 0x94, 0x0D, 0xA8, 0x2D, 0x5F,
  0x94, 0x06, 0xA8, 0x2D, 0x5F, 0x95, 0x81, 0xEF, 0xD0,
  // "Ò" (U+00D2)
  0x38, 0x17, 0x73, 0x72, 0x81, 0x8F, 0xC7, 0x38, 0x1A, 0xF5, 0x73, 0x81, 0xAE, 0x17, 0x74, 0x85,
  0x19, 0xDF, 0xEA, 0x24, 0x02, 0x0E, 0xA8, 0x3D, 0xEF, 0xE3, 0x38, 0x2B, 0xFC, 0x12, 0x81, 0x9F,
  0xD2, 0x03, 0xA0, 0x24, 0x85, 0xDF, 0x50, 0x8F, 0xB5, 0x85, 0x7F, 0xA0, 0xBF, 0x75, 0x85, 0x4F,
  0xE0, 0xDF, 0x55, 0x02, 0xA1, 0x81, 0xDF, 0x55, 0x02, 0xA8, 0x21, 0xDF, 0x55, 0x02, 0xA8, 0x21,
  0xCF, 0x55, 0x02, 0xA1, 0x81, 0xAF, 0x75, 0x85, 0x4F, 0xE0, 0x7F, 0xB5, 0x83, 0x8F, 0xA0, 0x2A,
  0x01, 0x48, 0x1D, 0xF5, 0x28, 0x2A, 0xFC, 0x12, 0x81, 0x9F, 0xD3, 0x01, 0x0D, 0xA8, 0x3D, 0xEF,
  0xE3, 0x48, 0x51, 0x8D, 0xFE, 0xA2, 0x30,
  // "Ó" (U+00D3)
  0x68, 0x13, 0x77, 0x72, 0x81, 0xCF, 0x87, 0x18, 0x15, 0xFA, 0x71, 0x81, 0x1E, 0xB7, 0x75, 0x85,
  0x19, 0xDF, 0xEA, 0x24, 0x02, 0x0E, 0xA8, 0x3D, 0xEF, 0xE3, 0x38, 0x2B, 0xFC, 0x12, 0x81, 0x9F,
  0xD2, 0x03, 0xA0, 0x24, 0x85, 0xDF, 0x50, 0x8F, 0xB5, 0x85, 0x7F, 0xA0, 0xBF, 0x75, 0x85, 0x4F,
  0xE0, 0xDF, 0x55, 0x02, 0xA1, 0x81, 0xDF, 0x55, 0x02, 0xA8, 0x21, 0xDF, 0x55, 0x02, 0xA8, 0x21,
  0xCF, 0x55, 0x02, 0xA1, 0x81, 0xAF, 0x75, 0x85, 0x4F, 0xE0, 0x7F, 0xB5, 0x83, 0x8F, 0xA0, 0x2A,
  0x01, 0x48, 0x1D, 0xF5, 0x28, 0x2A, 0xFC, 0x12, 0x81, 0x9F, 0xD3, 0x01, 0x0D, 0xA8, 0x3D, 0xEF,
  0xE3, 0x48, 0x51, 0x8D, 0xFE, 0xA2, 0x30,
  // "Ô" (U+00D4)
  0x48, 0x21, 0x77, 0x17, 0x10, 0x9A, 0x09, 0x78, 0x44, 0xF8, 0x9F, 0x46, 0x0D, 0x09, 0x28, 0x19,
  0xE1, 0x77, 0x28, 0x51, 0x9D, 0xFE, 0xA2, 0x40, 0x20, 0xEA, 0x83, 0xDE, 0xFE, 0x33, 0x82, 0xBF,
  0xC1, 0x28, 0x19, 0xFD, 0x20, 0x3A, 0x02, 0x48, 0x5D, 0xF5, 0x08, 0xFB, 0x58, 0x57, 0xFA, 0x0B,
  0xF7, 0x58, 0x54, 0xFE, 0x0D, 0xF5, 0x50, 0x2A, 0x18, 0x1D, 0xF5, 0x50, 0x2A, 0x82, 0x1D, 0xF5,
  0x50, 0x2A, 0x82, 0x1C, 0xF5, 0x50, 0x2A, 0x18, 0x1A, 0xF7, 0x58, 0x54, 0xFE, 0x07, 0xFB, 0x58,
  0x38, 0xFA, 0x02, 0xA0, 0x14, 0x81, 0xDF, 0x52, 0x82, 0xAF, 0xC1, 0x28, 0x19, 0xFD, 0x30, 0x10,
  0xDA, 0x83, 0xDE, 0xFE, 0x34, 0x85, 0x18, 0xDF, 0xEA, 0x23,
  // "Õ" (U+00D5)
  0x28, 0x54, 0xED, 0x40, 0xA9, 0x58, 0x5C, 0xEE, 0xFD, 0xF6, 0x48, 0x51, 0xF2, 0x19, 0xEB, 0x77,
  0x48, 0x51, 0x9D, 0xFE, 0xA2, 0x40, 0x20, 0xEA, 0x83, 0xDE, 0xFE, 0x33, 0x82, 0xBF, 0xC1, 0x28,
  0x19, 0xFD, 0x20, 0x3A, 0x02, 0x48, 0x5D, 0xF5, 0x08, 0xFB, 0x58, 0x57, 0xFA, 0x0B, 0xF7, 0x58,
  0x54, 0xFE, 0x0D, 0xF5, 0x50, 0x2A, 0x18, 0x1D, 0xF5, 0x50, 0x2A, 0x82, 0x1D, 0xF5, 0x50, 0x2A,
  0x82, 0x1C, 0xF5, 0x50, 0x2A, 0x18, 0x1A, 0xF7, 0x58, 0x54, 0xFE, 0x07, 0xFB, 0x58, 0x38, 0xFA,
  0x02, 0xA0, 0x14, 0x81, 0xDF, 0x52, 0x82, 0xAF, 0xC1, 0x28, 0x19, 0xFD, 0x30, 0x10, 0xDA, 0x83,
  0xDE, 0xFE, 0x34, 0x85, 0x18, 0xDF, 0xEA, 0x23,
  // "Ö" (U+00D6)
  0x28, 0x51, 0xB7, 0x04, 0xB3, 0x58, 0x52, 0xD9, 0x06, 0xE4, 0x77, 0x77, 0x18, 0x51, 0x9D, 0xFE,
  0xA2, 0x40, 0x20, 0xEA, 0x83, 0xDE, 0xFE, 0x33, 0x82, 0xBF, 0xC1, 0x28, 0x19, 0xFD, 0x20, 0x3A,
  0x02, 0x48, 0x5D, 0xF5, 0x08, 0xFB, 0x58, 0x57, 0xFA, 0x0B, 0xF7, 0x58, 0x54, 0xFE, 0x0D, 0xF5,
  0x50, 0x2A, 0x18, 0x1D, 0xF5, 0x50, 0x2A, 0x82, 0x1D, 0xF5, 0x50, 0x2A, 0x82, 0x1C, 0xF5, 0x50,
  0x2A, 0x18, 0x1A, 0xF7, 0x58, 0x54, 0xFE, 0x07, 0xFB, 0x58, 0x38, 0xFA, 0x02, 0xA0, 0x14, 0x81,
  0xDF, 0x52, 0x82, 0xAF, 0xC1, 0x28, 0x19, 0xFD, 0x30, 0x10, 0xDA, 0x83, 0xDE, 0xFE, 0x34, 0x85,
  0x18, 0xDF, 0xEA, 0x23,
  // "×" (U+00D7)
  0x00, 0x24, 0x83, 0x23, 0xDE, 0x32, 0x8A, 0x02, 0xDE, 0x4F, 0xE3, 0x2D, 0xF4, 0x04, 0xFE, 0xDF,
  0x43, 0x06, 0xA0, 0x73, 0x02, 0x0D, 0xA8, 0x94, 0xE2, 0x02, 0xDF, 0x44, 0xFE, 0x2D, 0xF4, 0x28,
  0x34, 0xFD, 0x34, 0x40, 0x04,
  // "Ø" (U+00D8)
  0x72, 0x05, 0x01, 0x38, 0x71, 0x8D, 0xFD, 0x94, 0xF7, 0x20, 0x10, 0xDA, 0x0D, 0x0E, 0xA0, 0xE0,
  0x12, 0x87, 0xBF, 0xC1, 0x01, 0xBF, 0xD2, 0x03, 0xA0, 0x13, 0x09, 0xA8, 0x35, 0x08, 0xFB, 0x38,
  0x72, 0xFD, 0xFB, 0x0B, 0xF7, 0x38, 0x7B, 0xD5, 0xFE, 0x0C, 0xF5, 0x28, 0x23, 0xF5, 0x2A, 0x18,
  0x1D, 0xF4, 0x28, 0x2C, 0xC0, 0x1A, 0x89, 0x01, 0xDF, 0x50, 0x5F, 0x30, 0x1A, 0x85, 0x1C, 0xF6,
  0x0D, 0xA2, 0x02, 0xA8, 0x51, 0xBF, 0x86, 0xF2, 0x28, 0x73, 0xFE, 0x08, 0xFC, 0xE9, 0x38, 0x37,
  0xFB, 0x03, 0xB0, 0x13, 0x81, 0xDF, 0x62, 0x82, 0xBF, 0xD1, 0x28, 0x19, 0xFE, 0x30, 0x9B, 0x0D,
  0x0E, 0xA0, 0x42, 0x87, 0x2F, 0x88, 0xDF, 0xEA, 0x23, 0x01, 0x08, 0x73,
  // "Ù" (U+00D9)
  0x28, 0x17, 0x73, 0x78, 0x18, 0xFC, 0x71, 0x81, 0xAF, 0x57, 0x18, 0x1A, 0xE1, 0x76, 0x81, 0x7F,
  0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A,
  0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA,
  0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8,
  0x16, 0xFB, 0x48, 0x43, 0xFE, 0x4F, 0xE4, 0x85, 0x6F, 0xB0, 0xEF, 0x82, 0x84, 0x2D, 0xF6, 0x05,
  0xA0, 0xE0, 0xDA, 0x0C, 0x38, 0x44, 0xBE, 0xFD, 0x82,
  // "Ú" (U+00DA)
  0x58, 0x13, 0x77, 0x78, 0x1C, 0xF8, 0x68, 0x15, 0xFA, 0x68, 0x11, 0xEB, 0x77, 0x81, 0x7F, 0xA4,
  0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81,
  0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40,
  0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x16,
  0xFB, 0x48, 0x43, 0xFE, 0x4F, 0xE4, 0x85, 0x6F, 0xB0, 0xEF, 0x82, 0x84, 0x2D, 0xF6, 0x05, 0xA0,
  0xE0, 0xDA, 0x0C, 0x38, 0x44, 0xBE, 0xFD, 0x82,
  // "Û" (U+00DB)
  0x38, 0x21, 0x77, 0x16, 0x09, 0xA0, 0x95, 0x84, 0x4F, 0x89, 0xF4, 0x40, 0xD0, 0x92, 0x81, 0x9E,
  0x17, 0x48, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81,
  0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40,
  0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17,
  0xFA, 0x40, 0x2A, 0x81, 0x6F, 0xB4, 0x84, 0x3F, 0xE4, 0xFE, 0x48, 0x56, 0xFB, 0x0E, 0xF8, 0x28,
  0x42, 0xDF, 0x60, 0x5A, 0x0E, 0x0D, 0xA0, 0xC3, 0x84, 0x4B, 0xEF, 0xD8, 0x20,
  // "Ü" (U+00DC)
  0x28, 0x51, 0xB7, 0x04, 0xB3, 0x38, 0x52, 0xD9, 0x06, 0xE4, 0x77, 0x78, 0x17, 0xFA, 0x40, 0x2A,
  0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA,
  0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8,
  0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x6F, 0xB4,
  0x84, 0x3F, 0xE4, 0xFE, 0x48, 0x56, 0xFB, 0x0E, 0xF8, 0x28, 0x42, 0xDF, 0x60, 0x5A, 0x0E, 0x0D,
  0xA0, 0xC3, 0x84, 0x4B, 0xEF, 0xD8, 0x20,
  // "Ý" (U+00DD)
  0x58, 0x13, 0x77, 0x78, 0x1C, 0xF8, 0x68, 0x15, 0xFA, 0x68, 0x11, 0xEB, 0x77, 0x81, 0xCF, 0x74,
  0x84, 0xAF, 0x96, 0xFD, 0x30, 0x1A, 0x03, 0x01, 0xA0, 0x32, 0x81, 0x6F, 0xC2, 0x81, 0xAF, 0x92,
  0x81, 0xCF, 0x62, 0x83, 0x4F, 0xE0, 0x2A, 0x01, 0x38, 0x4D, 0xF5, 0x8F, 0xA4, 0x84, 0x7F, 0xCE,
  0xF4, 0x40, 0x1B, 0x0D, 0x60, 0xBA, 0x07, 0x60, 0x5A, 0x01, 0x60, 0x2A, 0x70, 0x2A, 0x70, 0x2A,
  0x70, 0x2A, 0x70, 0x2A, 0x70, 0x2A, 0x40,
  // "Þ" (U+00DE)
  0x81, 0x5F, 0xC6, 0x81, 0x5F, 0xC6, 0x81, 0x5F, 0xC6, 0x85, 0x5F, 0xEC, 0xCA, 0x52, 0x05, 0xE8,
  0x6A, 0x05, 0xFC, 0x01, 0x6A, 0x82, 0x55, 0xFC, 0x38, 0x4A, 0xF9, 0x5F, 0xC3, 0x84, 0x7F, 0xB5,
  0xFC, 0x38, 0x47, 0xFA, 0x5F, 0xC3, 0x87, 0xBF, 0x85, 0xFC, 0x01, 0x7A, 0x03, 0x05, 0xE8, 0x77,
  0x05, 0xFE, 0xCB, 0x94, 0x28, 0x15, 0xFC, 0x68, 0x15, 0xFC, 0x68, 0x15, 0xFC, 0x60,
  // "ß" (U+00DF)
  0x28, 0x48, 0xDF, 0xD9, 0x13, 0x0C, 0xA0, 0xDA, 0x0D, 0x28, 0x93, 0x4F, 0xE2, 0x01, 0xEF, 0x40,
  0x7F, 0x93, 0x85, 0xBF, 0x50, 0x8F, 0x72, 0x89, 0x31, 0xEE, 0x10, 0x8F, 0x70, 0x1D, 0xF5, 0x28,
  0x58, 0xF7, 0x0A, 0xF7, 0x38, 0x58, 0xF7, 0x0D, 0xF3, 0x38, 0x58, 0xF7, 0x0B, 0xFB, 0x38, 0x93,
  0x8F, 0x70, 0x2E, 0xFB, 0x10, 0x8F, 0x72, 0x86, 0x2D, 0xFB, 0x08, 0xF7, 0x38, 0x51, 0xEF, 0x48,
  0xF7, 0x48, 0x69, 0xF6, 0x8F, 0x73, 0x22, 0x8A, 0x4C, 0xF5, 0x8F, 0x76, 0xFD, 0xEF, 0xD1, 0x8F,
  0x73, 0xBE, 0xEB, 0x21,
  // "à" (U+00E0)
  0x28, 0x17, 0x73, 0x68, 0x18, 0xFC, 0x78, 0x1A, 0xF5, 0x78, 0x1A, 0xE1, 0x76, 0x84, 0x5B, 0xEF,
  0xB3, 0x20, 0x1A, 0x82, 0xDE, 0xFE, 0x38, 0x56, 0x20, 0x1D, 0xF5, 0x68, 0x19, 0xF7, 0x68, 0x18,
  0xF8, 0x28, 0x16, 0xCE, 0xB8, 0x18, 0x0A, 0xA8, 0x4E, 0xCE, 0xF8, 0x1A, 0x05, 0x28, 0x48, 0xF8,
  0x3F, 0xE3, 0x82, 0x9F, 0x81, 0xA8, 0x62, 0x03, 0xEF, 0x80, 0xCA, 0x89, 0x4D, 0xF9, 0xF8, 0x01,
  0xBE, 0xD5, 0x1F, 0x80,
  // "á" (U+00E1)
  0x58, 0x13, 0x77, 0x68, 0x1C, 0xF8, 0x58, 0x15, 0xFA, 0x58, 0x11, 0xEB, 0x77, 0x84, 0x5B, 0xEF,
  0xB3, 0x20, 0x1A, 0x82, 0xDE, 0xFE, 0x38, 0x56, 0x20, 0x1D, 0xF5, 0x68, 0x19, 0xF7, 0x68, 0x18,
  0xF8, 0x28, 0x16, 0xCE, 0xB8, 0x18, 0x0A, 0xA8, 0x4E, 0xCE, 0xF8, 0x1A, 0x05, 0x28, 0x48, 0xF8,
  0x3F, 0xE3, 0x82, 0x9F, 0x81, 0xA8, 0x62, 0x03, 0xEF, 0x80, 0xCA, 0x89, 0x4D, 0xF9, 0xF8, 0x01,
  0xBE, 0xD5, 0x1F, 0x80,
  // "â" (U+00E2)
  0x38, 0x21, 0x77, 0x15, 0x09, 0xA0, 0x94, 0x84, 0x4F, 0x89, 0xF4, 0x30, 0xD0, 0x92, 0x81, 0x9E,
  0x17, 0x48, 0x45, 0xBE, 0xFB, 0x32, 0x01, 0xA8, 0x2D, 0xEF, 0xE3, 0x85, 0x62, 0x01, 0xDF, 0x56,
  0x81, 0x9F, 0x76, 0x81, 0x8F, 0x82, 0x81, 0x6C, 0xEB, 0x81, 0x80, 0xAA, 0x84, 0xEC, 0xEF, 0x81,
  0xA0, 0x52, 0x84, 0x8F, 0x83, 0xFE, 0x38, 0x29, 0xF8, 0x1A, 0x86, 0x20, 0x3E, 0xF8, 0x0C, 0xA8,
  0x94, 0xDF, 0x9F, 0x80, 0x1B, 0xED, 0x51, 0xF8,
  // "ã" (U+00E3)
  0x28, 0x54, 0xED, 0x40, 0xA9, 0x28, 0x95, 0xCE, 0xEF, 0xDF, 0x60, 0x1F, 0x21, 0x9E, 0xB7, 0x58,
  0x45, 0xBE, 0xFB, 0x32, 0x01, 0xA8, 0x2D, 0xEF, 0xE3, 0x85, 0x62, 0x01, 0xDF, 0x56, 0x81, 0x9F,
  0x76, 0x81, 0x8F, 0x82, 0x81, 0x6C, 0xEB, 0x81, 0x80, 0xAA, 0x84, 0xEC, 0xEF, 0x81, 0xA0, 0x52,
  0x84, 0x8F, 0x83, 0xFE, 0x38, 0x29, 0xF8, 0x1A, 0x86, 0x20, 0x3E, 0xF8, 0x0C, 0xA8, 0x94, 0xDF,
  0x9F, 0x80, 0x1B, 0xED, 0x51, 0xF8,
  // "ä" (U+00E4)
  0x18, 0x51, 0xB7, 0x04, 0xB3, 0x28, 0x52, 0xD9, 0x06, 0xE4, 0x77, 0x78, 0x45, 0xBE, 0xFB, 0x32,
  0x01, 0xA8, 0x2D, 0xEF, 0xE3, 0x85, 0x62, 0x01, 0xDF, 0x56, 0x81, 0x9F, 0x76, 0x81, 0x8F, 0x82,
  0x81, 0x6C, 0xEB, 0x81, 0x80, 0xAA, 0x84, 0xEC, 0xEF, 0x81, 0xA0, 0x52, 0x84, 0x8F, 0x83, 0xFE,
  0x38, 0x29, 0xF8, 0x1A, 0x86, 0x20, 0x3E, 0xF8, 0x0C, 0xA8, 0x94, 0xDF, 0x9F, 0x80, 0x1B, 0xED,
  0x51, 0xF8,
  // "å" (U+00E5)
  0x38, 0x24, 0xDE, 0x75, 0x83, 0xE6, 0x2E, 0x33, 0x84, 0x1F, 0x10, 0xC6, 0x48, 0x3E, 0x52, 0xE3,
  0x48, 0x24, 0xDE, 0x87, 0x68, 0x45, 0xBE, 0xFB, 0x32, 0x01, 0xA8, 0x2D, 0xEF, 0xE3, 0x85, 0x62,
  0x01, 0xDF, 0x56, 0x81, 0x9F, 0x76, 0x81, 0x8F, 0x82, 0x81, 0x6C, 0xEB, 0x81, 0x80, 0xAA, 0x84,
  0xEC, 0xEF, 0x81, 0xA0, 0x52, 0x84, 0x8F, 0x83, 0xFE, 0x38, 0x29, 0xF8, 0x1A, 0x86, 0x20, 0x3E,
  0xF8, 0x0C, 0xA8, 0x94, 0xDF, 0x9F, 0x80, 0x1B, 0xED, 0x51, 0xF8,
  // "æ" (U+00E6)
  0x28, 0x91, 0x6C, 0xFE, 0x90, 0x4C, 0xFC, 0x53, 0x02, 0xA0, 0xDA, 0x0B, 0xA0, 0xDA, 0x04, 0x38,
  0x36, 0x10, 0x1E, 0xA8, 0x33, 0x04, 0xFD, 0x78, 0x1A, 0xFB, 0x38, 0x1C, 0xF2, 0x68, 0x19, 0xF8,
  0x38, 0x19, 0xF4, 0x28, 0x16, 0xCE, 0xFA, 0x81, 0x50, 0xAA, 0x83, 0xEC, 0xEF, 0xE8, 0x01, 0xC0,
  0x50, 0x1A, 0x05, 0x28, 0x19, 0xF8, 0x68, 0x13, 0xFE, 0x38, 0x1B, 0xFB, 0x60, 0x1A, 0x85, 0x20,
  0x4F, 0xEF, 0x53, 0x05, 0x20, 0xBA, 0x82, 0xDF, 0x94, 0xA8, 0x2E, 0xDF, 0xE2, 0x83, 0x1B, 0xED,
  0x82, 0x84, 0x3B, 0xEE, 0xC5, 0x10,
  // "ç" (U+00E7)
  0x18, 0x61, 0x9E, 0xFD, 0x70, 0xCA, 0x89, 0x3D, 0xF9, 0x6F, 0xD1, 0x01, 0x2C, 0xF6, 0x48, 0x1E,
  0xF2, 0x4A, 0x01, 0x4A, 0x5A, 0x02, 0x48, 0x1C, 0xF5, 0x48, 0x27, 0xFD, 0x12, 0x81, 0x31, 0xDA,
  0x89, 0x0D, 0xFA, 0x01, 0xAE, 0xEC, 0x53, 0x08, 0x05, 0x48, 0x21, 0xDD, 0x45, 0x0C, 0x0E, 0x38,
  0x29, 0x9F, 0xE3, 0x0E, 0xA0, 0x63, 0x81, 0x23, 0x12,
  // "è" (U+00E8)
  0x18, 0x17, 0x73, 0x58, 0x18, 0xFC, 0x68, 0x1A, 0xF5, 0x68, 0x1A, 0xE1, 0x74, 0x84, 0x19, 0xEE,
  0xA2, 0x28, 0x90, 0xDF, 0xEE, 0xFD, 0x17, 0xFC, 0x28, 0x49, 0xF7, 0xCF, 0x42, 0x81, 0x2F, 0xCA,
  0x01, 0x3F, 0xD8, 0x02, 0xCA, 0x01, 0x58, 0x1C, 0xF4, 0x58, 0x26, 0xFD, 0x22, 0x82, 0x23, 0x0C,
  0xA8, 0x92, 0xDE, 0xF8, 0x01, 0x8D, 0xFD, 0xA3,
  // "é" (U+00E9)
  0x48, 0x13, 0x77, 0x58, 0x1C, 0xF8, 0x48, 0x15, 0xFA, 0x48, 0x11, 0xEB, 0x75, 0x84, 0x19, 0xEE,
  0xA2, 0x28, 0x90, 0xDF, 0xEE, 0xFD, 0x17, 0xFC, 0x28, 0x49, 0xF7, 0xCF, 0x42, 0x81, 0x2F, 0xCA,
  0x01, 0x3F, 0xD8, 0x02, 0xCA, 0x01, 0x58, 0x1C, 0xF4, 0x58, 0x26, 0xFD, 0x22, 0x82, 0x23, 0x0C,
  0xA8, 0x92, 0xDE, 0xF8, 0x01, 0x8D, 0xFD, 0xA3,
  // "ê" (U+00EA)
  0x28, 0x21, 0x77, 0x14, 0x09, 0xA0, 0x93, 0x84, 0x4F, 0x89, 0xF4, 0x20, 0xD0, 0x92, 0x81, 0x9E,
  0x17, 0x28, 0x41, 0x9E, 0xEA, 0x22, 0x89, 0x0D, 0xFE, 0xEF, 0xD1, 0x7F, 0xC2, 0x84, 0x9F, 0x7C,
  0xF4, 0x28, 0x12, 0xFC, 0xA0, 0x13, 0xFD, 0x80, 0x2C, 0xA0, 0x15, 0x81, 0xCF, 0x45, 0x82, 0x6F,
  0xD2, 0x28, 0x22, 0x30, 0xCA, 0x89, 0x2D, 0xEF, 0x80, 0x18, 0xDF, 0xDA, 0x30,
  // "ë" (U+00EB)
  0x89, 0x51, 0xB7, 0x04, 0xB3, 0x02, 0xD9, 0x06, 0xE4, 0x77, 0x48, 0x41, 0x9E, 0xEA, 0x22, 0x89,
  0x0D, 0xFE, 0xEF, 0xD1, 0x7F, 0xC2, 0x84, 0x9F, 0x7C, 0xF4, 0x28, 0x12, 0xFC, 0xA0, 0x13, 0xFD,
  0x80, 0x2C, 0xA0, 0x15, 0x81, 0xCF, 0x45, 0x82, 0x6F, 0xD2, 0x28, 0x22, 0x30, 0xCA, 0x89, 0x2D,
  0xEF, 0x80, 0x18, 0xDF, 0xDA, 0x30,
  // "ì" (U+00EC)
  0x81, 0x77, 0x32, 0x81, 0x8F, 0xC3, 0x81, 0xAF, 0x53, 0x81, 0xAE, 0x16, 0x81, 0x8F, 0x72, 0x81,
  0x8F, 0x72, 0x81, 0x8F, 0x72, 0x81, 0x8F, 0x72, 0x81, 0x8F, 0x72, 0x81, 0x8F, 0x72, 0x81, 0x8F,
  0x72, 0x81, 0x8F, 0x72, 0x81, 0x8F, 0x72, 0x81, 0x8F, 0x72, 0x81, 0x8F, 0x72, 0x81, 0x8F, 0x71,
  // "í" (U+00ED)
  0x28, 0x13, 0x77, 0x28, 0x91, 0xCF, 0x80, 0x5F, 0xA0, 0x1E, 0xB7, 0x18, 0x18, 0xF7, 0x28, 0x18,
  0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7,
  0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x10,
  // "î" (U+00EE)
  0x18, 0x21, 0x77, 0x13, 0x09, 0xA0, 0x92, 0x87, 0x4F, 0x89, 0xF4, 0x0D, 0x92, 0x81, 0x9E, 0x17,
  0x28, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48,
  0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18,
  0xF7, 0x48, 0x18, 0xF7, 0x20,
  // "ï" (U+00EF)
  0x89, 0x41, 0xB7, 0x04, 0xB3, 0x2D, 0x90, 0x6E, 0x47, 0x72, 0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74,
  0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81,
  0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81, 0x8F, 0x72,
  // "ð" (U+00F0)
  0x38, 0x48, 0x91, 0x4C, 0x14, 0x84, 0x9F, 0xEF, 0xB1, 0x48, 0x33, 0xEF, 0xE1, 0x48, 0x42, 0xFC,
  0xAF, 0xA5, 0x04, 0x28, 0x1D, 0xF4, 0x78, 0x15, 0xFB, 0x48, 0x58, 0xCB, 0x5E, 0xF1, 0x20, 0xCE,
  0x86, 0x40, 0x7F, 0xD3, 0x17, 0xA8, 0x37, 0x0C, 0xF5, 0x38, 0x1C, 0xF9, 0x1A, 0x02, 0x38, 0x28,
  0xFA, 0x1A, 0x48, 0x16, 0xFA, 0x1A, 0x01, 0x38, 0x57, 0xF8, 0x0C, 0xF5, 0x38, 0x93, 0xBF, 0x50,
  0x7F, 0xC1, 0x04, 0xFE, 0x12, 0x0C, 0xA0, 0xDA, 0x06, 0x38, 0x41, 0x9D, 0xFC, 0x52,
  // "ñ" (U+00F1)
  0x18, 0x54, 0xED, 0x40, 0xA9, 0x28, 0x95, 0xCE, 0xEF, 0xDF, 0x60, 0x1F, 0x21, 0x9E, 0xB7, 0x48,
  0x94, 0x8F, 0x26, 0xDF, 0xB2, 0x08, 0xFA, 0xFD, 0xA8, 0x1D, 0x08, 0xA8, 0x74, 0x01, 0xEF, 0x48,
  0xFC, 0x38, 0x4A, 0xF6, 0x8F, 0x93, 0x84, 0x9F, 0x78, 0xF7, 0x38, 0x49, 0xF7, 0x8F, 0x73, 0x84,
  0x9F, 0x78, 0xF7, 0x38, 0x49, 0xF7, 0x8F, 0x73, 0x84, 0x9F, 0x78, 0xF7, 0x38, 0x49, 0xF7, 0x8F,
  0x73, 0x84, 0x9F, 0x78, 0xF7, 0x38, 0x19, 0xF7,
  // "ò" (U+00F2)
  0x28, 0x17, 0x73, 0x68, 0x18, 0xFC, 0x78, 0x1A, 0xF5, 0x78, 0x1A, 0xE1, 0x75, 0x84, 0x19, 0xEF,
  0xC5, 0x38, 0x2C, 0xFE, 0xDA, 0x89, 0x46, 0x07, 0xFC, 0x10, 0x4F, 0xE0, 0xCF, 0x53, 0x81, 0xCF,
  0x5A, 0x02, 0x38, 0x19, 0xF8, 0xA0, 0x13, 0x81, 0x7F, 0x9A, 0x01, 0x38, 0x47, 0xF9, 0xEF, 0x23,
  0x84, 0x9F, 0x8B, 0xF6, 0x38, 0x91, 0xCF, 0x46, 0xFC, 0x10, 0x4F, 0xE2, 0x82, 0xBF, 0xED, 0xA0,
  0x53, 0x83, 0x8D, 0xEC, 0x52,
  // "ó" (U+00F3)
  0x48, 0x13, 0x77, 0x68, 0x1C, 0xF8, 0x58, 0x15, 0xFA, 0x58, 0x11, 0xEB, 0x77, 0x84, 0x19, 0xEF,
  0xC5, 0x38, 0x2C, 0xFE, 0xDA, 0x89, 0x46, 0x07, 0xFC, 0x10, 0x4F, 0xE0, 0xCF, 0x53, 0x81, 0xCF,
  0x5A, 0x02, 0x38, 0x19, 0xF8, 0xA0, 0x13, 0x81, 0x7F, 0x9A, 0x01, 0x38, 0x47, 0xF9, 0xEF, 0x23,
  0x84, 0x9F, 0x8B, 0xF6, 0x38, 0x91, 0xCF, 0x46, 0xFC, 0x10, 0x4F, 0xE2, 0x82, 0xBF, 0xED, 0xA0,
  0x53, 0x83, 0x8D, 0xEC, 0x52,
  // "ô" (U+00F4)
  0x28, 0x21, 0x77, 0x15, 0x09, 0xA0, 0x94, 0x84, 0x4F, 0x89, 0xF4, 0x30, 0xD0, 0x92, 0x81, 0x9E,
  0x17, 0x48, 0x41, 0x9E, 0xFC, 0x53, 0x82, 0xCF, 0xED, 0xA8, 0x94, 0x60, 0x7F, 0xC1, 0x04, 0xFE,
  0x0C, 0xF5, 0x38, 0x1C, 0xF5, 0xA0, 0x23, 0x81, 0x9F, 0x8A, 0x01, 0x38, 0x17, 0xF9, 0xA0, 0x13,
  0x84, 0x7F, 0x9E, 0xF2, 0x38, 0x49, 0xF8, 0xBF, 0x63, 0x89, 0x1C, 0xF4, 0x6F, 0xC1, 0x04, 0xFE,
  0x28, 0x2B, 0xFE, 0xDA, 0x05, 0x38, 0x38, 0xDE, 0xC5, 0x20,
  // "õ" (U+00F5)
  0x18, 0x54, 0xED, 0x40, 0xA9, 0x28, 0x95, 0xCE, 0xEF, 0xDF, 0x60, 0x1F, 0x21, 0x9E, 0xB7, 0x58,
  0x41, 0x9E, 0xFC, 0x53, 0x82, 0xCF, 0xED, 0xA8, 0x94, 0x60, 0x7F, 0xC1, 0x04, 0xFE, 0x0C, 0xF5,
  0x38, 0x1C, 0xF5, 0xA0, 0x23, 0x81, 0x9F, 0x8A, 0x01, 0x38, 0x17, 0xF9, 0xA0, 0x13, 0x84, 0x7F,
  0x9E, 0xF2, 0x38, 0x49, 0xF8, 0xBF, 0x63, 0x89, 0x1C, 0xF4, 0x6F, 0xC1, 0x04, 0xFE, 0x28, 0x2B,
  0xFE, 0xDA, 0x05, 0x38, 0x38, 0xDE, 0xC5, 0x20,
  // "ö" (U+00F6)
  0x18, 0x51, 0xB7, 0x04, 0xB3, 0x28, 0x52, 0xD9, 0x06, 0xE4, 0x77, 0x68, 0x41, 0x9E, 0xFC, 0x53,
  0x82, 0xCF, 0xED, 0xA8, 0x94, 0x60, 0x7F, 0xC1, 0x04, 0xFE, 0x0C, 0xF5, 0x38, 0x1C, 0xF5, 0xA0,
  0x23, 0x81, 0x9F, 0x8A, 0x01, 0x38, 0x17, 0xF9, 0xA0, 0x13, 0x84, 0x7F, 0x9E, 0xF2, 0x38, 0x49,
  0xF8, 0xBF, 0x63, 0x89, 0x1C, 0xF4, 0x6F, 0xC1, 0x04, 0xFE, 0x28, 0x2B, 0xFE, 0xDA, 0x05, 0x38,
  0x38, 0xDE, 0xC5, 0x20,
  // "÷" (U+00F7)
  0x40, 0xA0, 0xB7, 0x01, 0xA0, 0x27, 0x0C, 0x0D, 0x77, 0x73, 0x03, 0xF9, 0x05, 0x03, 0x80, 0x4C,
  0x04, 0x77, 0x0A, 0x0B, 0x70, 0x1A, 0x02, 0x70, 0xC0, 0xD4,
  // "ø" (U+00F8)
  0x71, 0x07, 0x38, 0x61, 0x9E, 0xEB, 0x9F, 0x22, 0x82, 0xDF, 0xED, 0xA0, 0xA2, 0x81, 0x7F, 0xC2,
  0x81, 0x9F, 0xD2, 0x81, 0xCF, 0x42, 0x0E, 0xA0, 0x41, 0xA8, 0x61, 0x08, 0xD9, 0xF7, 0x1A, 0x18,
  0x51, 0xF5, 0x7F, 0x91, 0xA1, 0x8A, 0x3A, 0xC0, 0x7F, 0x90, 0xEF, 0x5F, 0x40, 0x8F, 0x80, 0xBF,
  0xEA, 0x28, 0x3C, 0xF5, 0x05, 0xA8, 0x33, 0x04, 0xFE, 0x3A, 0x0E, 0x0D, 0xA0, 0x62, 0x85, 0x6F,
  0x9D, 0xFC, 0x53, 0x07, 0x08, 0x70,
  // "ù" (U+00F9)
  0x28, 0x17, 0x73, 0x68, 0x18, 0xFC, 0x78, 0x1A, 0xF5, 0x78, 0x1A, 0xE1, 0x74, 0x81, 0x9F, 0x73,
  0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6,
  0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38,
  0x4B, 0xF6, 0x8F, 0x83, 0x84, 0xEF, 0x66, 0xFD, 0x20, 0x4A, 0x8A, 0x16, 0x0E, 0xFC, 0xBF, 0xCF,
  0x60, 0x4C, 0xFD, 0x64, 0xF6,
  // "ú" (U+00FA)
  0x48, 0x13, 0x77, 0x68, 0x1C, 0xF8, 0x58, 0x15, 0xFA, 0x58, 0x11, 0xEB, 0x76, 0x81, 0x9F, 0x73,
  0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6,
  0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38,
  0x4B, 0xF6, 0x8F, 0x83, 0x84, 0xEF, 0x66, 0xFD, 0x20, 0x4A, 0x8A, 0x16, 0x0E, 0xFC, 0xBF, 0xCF,
  0x60, 0x4C, 0xFD, 0x64, 0xF6,
  // "û" (U+00FB)
  0x28, 0x21, 0x77, 0x15, 0x09, 0xA0, 0x94, 0x84, 0x4F, 0x89, 0xF4, 0x30, 0xD0, 0x92, 0x81, 0x9E,
  0x17, 0x38, 0x19, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6,
  0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38,
  0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xBF, 0x68, 0xF8, 0x38, 0x4E, 0xF6, 0x6F, 0xD2, 0x04, 0xA8, 0xA1,
  0x60, 0xEF, 0xCB, 0xFC, 0xF6, 0x04, 0xCF, 0xD6, 0x4F, 0x60,
  // "ü" (U+00FC)
  0x18, 0x51, 0xB7, 0x04, 0xB3, 0x28, 0x52, 0xD9, 0x06, 0xE4, 0x77, 0x58, 0x19, 0xF7, 0x38, 0x4A,
  0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7,
  0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xBF,
  0x68, 0xF8, 0x38, 0x4E, 0xF6, 0x6F, 0xD2, 0x04, 0xA8, 0xA1, 0x60, 0xEF, 0xCB, 0xFC, 0xF6, 0x04,
  0xCF, 0xD6, 0x4F, 0x60,
  // "ý" (U+00FD)
  0x48, 0x13, 0x77, 0x68, 0x1C, 0xF8, 0x58, 0x15, 0xFA, 0x58, 0x11, 0xEB, 0x76, 0x81, 0xCF, 0x53,
  0x84, 0x4F, 0xD7, 0xFA, 0x38, 0x48, 0xF9, 0x3F, 0xE3, 0x85, 0xCF, 0x40, 0xDF, 0x22, 0xA2, 0x85,
  0x9F, 0x70, 0x4F, 0xB2, 0x85, 0x4F, 0xB0, 0x8F, 0x73, 0x84, 0xEE, 0x0C, 0xF2, 0x38, 0x3A, 0xF4,
  0xFD, 0x48, 0x36, 0xFA, 0xF9, 0x40, 0x1B, 0x05, 0x50, 0xCA, 0x01, 0x58, 0x18, 0xFB, 0x68, 0x1A,
  0xF7, 0x68, 0x1E, 0xF2, 0x58, 0x17, 0xFC, 0x40, 0x80, 0xEA, 0x04, 0x48, 0x28, 0xFD, 0x55,
  // "þ" (U+00FE)
  0x81, 0x8F, 0x76, 0x81, 0x8F, 0x76, 0x81, 0x8F, 0x76, 0x81, 0x8F, 0x76, 0x8A, 0x18, 0xF7, 0x5D,
  0xEB, 0x20, 0x8F, 0xBF, 0xDE, 0xFD, 0x08, 0xA8, 0x75, 0x01, 0xDF, 0x68, 0xFB, 0x38, 0x47, 0xFA,
  0x8F, 0x83, 0x84, 0x4F, 0xD8, 0xF7, 0x38, 0x42, 0xFE, 0x8F, 0x73, 0x84, 0x3F, 0xE8, 0xF9, 0x38,
  0x44, 0xFD, 0x8F, 0xC3, 0x82, 0x7F, 0xA8, 0xA8, 0xB1, 0x50, 0x1D, 0xF6, 0x8F, 0xCF, 0xDE, 0xFD,
  0x08, 0xF7, 0x6D, 0xFB, 0x20, 0x8F, 0x86, 0x81, 0x8F, 0x86, 0x81, 0x8F, 0x86, 0x81, 0x8F, 0x86,
  0x81, 0x8F, 0x86,
  // "ÿ" (U+00FF)
  0x18, 0x51, 0xB7, 0x04, 0xB3, 0x28, 0x52, 0xD9, 0x06, 0xE4, 0x77, 0x58, 0x1C, 0xF5, 0x38, 0x44,
  0xFD, 0x7F, 0xA3, 0x84, 0x8F, 0x93, 0xFE, 0x38, 0x5C, 0xF4, 0x0D, 0xF2, 0x2A, 0x28, 0x59, 0xF7,
  0x04, 0xFB, 0x28, 0x54, 0xFB, 0x08, 0xF7, 0x38, 0x4E, 0xE0, 0xCF, 0x23, 0x83, 0xAF, 0x4F, 0xD4,
  0x83, 0x6F, 0xAF, 0x94, 0x01, 0xB0, 0x55, 0x0C, 0xA0, 0x15, 0x81, 0x8F, 0xB6, 0x81, 0xAF, 0x76,
  0x81, 0xEF, 0x25, 0x81, 0x7F, 0xC4, 0x08, 0x0E, 0xA0, 0x44, 0x82, 0x8F, 0xD5, 0x50,
  // "Ā" (U+0100)
  0x20, 0x28, 0x01, 0xC0, 0x64, 0x02, 0xD0, 0x77, 0x73, 0x81, 0xDF, 0xD7, 0x02, 0xB0, 0x26, 0x83,
  0x6F, 0xCF, 0x66, 0x83, 0xAF, 0x6F, 0xA6, 0x83, 0xEE, 0x0E, 0xE5, 0x85, 0x3F, 0xB0, 0xBF, 0x34,
  0x85, 0x7F, 0x70, 0x7F, 0x74, 0x85, 0xBF, 0x30, 0x3F, 0xC4, 0xA3, 0x0E, 0x93, 0x04, 0xF0, 0x42,
  0x08, 0xF0, 0x92, 0x81, 0xCF, 0x53, 0x83, 0x4F, 0xD0, 0x1A, 0x01, 0x4A, 0x82, 0x15, 0xFD, 0x58,
  0x4C, 0xF6, 0x9F, 0x95, 0x84, 0x8F, 0xAD, 0xF5, 0x58, 0x15, 0xFE,
  // "ā" (U+0101)
  0x10, 0x28, 0x01, 0xC0, 0x62, 0x02, 0xD0, 0x77, 0x58, 0x45, 0xBE, 0xFB, 0x32, 0x01, 0xA8, 0x2D,
  0xEF, 0xE3, 0x85, 0x62, 0x01, 0xDF, 0x56, 0x81, 0x9F, 0x76, 0x81, 0x8F, 0x82, 0x81, 0x6C, 0xEB,
  0x81, 0x80, 0xAA, 0x84, 0xEC, 0xEF, 0x81, 0xA0, 0x52, 0x84, 0x8F, 0x83, 0xFE, 0x38, 0x29, 0xF8,
  0x1A, 0x86, 0x20, 0x3E, 0xF8, 0x0C, 0xA8, 0x94, 0xDF, 0x9F, 0x80, 0x1B, 0xED, 0x51, 0xF8,
  // "Ă" (U+0102)
  0x28, 0x11, 0xF5, 0x20, 0xB0, 0x95, 0x84, 0xCF, 0xDE, 0xF4, 0x58, 0x32, 0xBE, 0xD6, 0x77, 0x48,
  0x1D, 0xFD, 0x70, 0x2B, 0x02, 0x68, 0x36, 0xFC, 0xF6, 0x68, 0x3A, 0xF6, 0xFA, 0x68, 0x3E, 0xE0,
  0xEE, 0x58, 0x53, 0xFB, 0x0B, 0xF3, 0x48, 0x57, 0xF7, 0x07, 0xF7, 0x48, 0x5B, 0xF3, 0x03, 0xFC,
  0x4A, 0x30, 0xE9, 0x30, 0x4F, 0x04, 0x20, 0x8F, 0x09, 0x28, 0x1C, 0xF5, 0x38, 0x34, 0xFD, 0x01,
  0xA0, 0x14, 0xA8, 0x21, 0x5F, 0xD5, 0x84, 0xCF, 0x69, 0xF9, 0x58, 0x48, 0xFA, 0xDF, 0x55, 0x81,
  0x5F, 0xE0,
  // "ă" (U+0103)
  0x18, 0x11, 0xF5, 0x20, 0xB0, 0x93, 0x84, 0xCF, 0xDE, 0xF4, 0x38, 0x32, 0xBE, 0xD6, 0x76, 0x84,
  0x5B, 0xEF, 0xB3, 0x20, 0x1A, 0x82, 0xDE, 0xFE, 0x38, 0x56, 0x20, 0x1D, 0xF5, 0x68, 0x19, 0xF7,
  0x68, 0x18, 0xF8, 0x28, 0x16, 0xCE, 0xB8, 0x18, 0x0A, 0xA8, 0x4E, 0xCE, 0xF8, 0x1A, 0x05, 0x28,
  0x48, 0xF8, 0x3F, 0xE3, 0x82, 0x9F, 0x81, 0xA8, 0x62, 0x03, 0xEF, 0x80, 0xCA, 0x89, 0x4D, 0xF9,
  0xF8, 0x01, 0xBE, 0xD5, 0x1F, 0x80,
  // "Ą" (U+0104)
  0x48, 0x1D, 0xFD, 0x71, 0x02, 0xB0, 0x27, 0x83, 0x6F, 0xCF, 0x67, 0x83, 0xAF, 0x6F, 0xA7, 0x83,
  0xEE, 0x0E, 0xE6, 0x85, 0x3F, 0xB0, 0xBF, 0x35, 0x85, 0x7F, 0x70, 0x7F, 0x75, 0x85, 0xBF, 0x30,
  0x3F, 0xC5, 0xA3, 0x0E, 0x94, 0x04, 0xF0, 0x43, 0x08, 0xF0, 0x93, 0x81, 0xCF, 0x53, 0x81, 0x4F,
  0xD2, 0x01, 0xA0, 0x14, 0xA8, 0x31, 0x05, 0xFD, 0x58, 0x5C, 0xF6, 0x09, 0xF9, 0x58, 0x58, 0xFA,
  0x0D, 0xF5, 0x50, 0x5A, 0x72, 0x81, 0x4E, 0x27, 0x20, 0xD0, 0x97, 0x28, 0x11, 0xF9, 0x73, 0xA0,
  0xD0, 0x27, 0x18, 0x26, 0xEE, 0x20,
  // "ą" (U+0105)
  0x28, 0x45, 0xBE, 0xFB, 0x33, 0x01, 0xA8, 0x2D, 0xEF, 0xE4, 0x85, 0x62, 0x01, 0xDF, 0x57, 0x81,
  0x9F, 0x77, 0x81, 0x8F, 0x83, 0x81, 0x6C, 0xEB, 0x08, 0x20, 0xAA, 0x85, 0xEC, 0xEF, 0x80, 0x1A,
  0x05, 0x28, 0x58, 0xF8, 0x03, 0xFE, 0x38, 0x39, 0xF8, 0x01, 0xA8, 0x42, 0x03, 0xEF, 0x82, 0x0C,
  0xA8, 0x3D, 0xF9, 0xF8, 0x28, 0x61, 0xBE, 0xD5, 0x1F, 0xC7, 0x81, 0x4E, 0x27, 0x0D, 0x09, 0x78,
  0x11, 0xF9, 0x71, 0xA0, 0xD0, 0x26, 0x82, 0x6E, 0xE2,
  // "Ć" (U+0106)
  0x58, 0x13, 0x77, 0x68, 0x1C, 0xF8, 0x58, 0x15, 0xFA, 0x58, 0x11, 0xEB, 0x77, 0x18, 0x47, 0xCF,
  0xEC, 0x62, 0x0B, 0xA8, 0x7E, 0xEF, 0xD0, 0x8F, 0xE3, 0x28, 0x13, 0x51, 0xA0, 0x45, 0x81, 0x6F,
  0xD6, 0x81, 0xAF, 0x96, 0x81, 0xCF, 0x66, 0x81, 0xDF, 0x56, 0x81, 0xDF, 0x56, 0x81, 0xCF, 0x66,
  0x81, 0xAF, 0x86, 0x81, 0x7F, 0xC6, 0x02, 0xA0, 0x36, 0x82, 0xAF, 0xD3, 0x28, 0x31, 0x30, 0x1D,
  0xA8, 0x2D, 0xDF, 0xA3, 0x84, 0x8D, 0xFE, 0xC5,
  // "ć" (U+0107)
  0x48, 0x13, 0x77, 0x48, 0x1C, 0xF8, 0x38, 0x15, 0xFA, 0x38, 0x11, 0xEB, 0x73, 0x86, 0x19, 0xEF,
  0xD7, 0x0C, 0xA8, 0x93, 0xDF, 0x96, 0xFD, 0x10, 0x12, 0xCF, 0x64, 0x81, 0xEF, 0x24, 0xA0, 0x14,
  0xA5, 0xA0, 0x24, 0x81, 0xCF, 0x54, 0x82, 0x7F, 0xD1, 0x28, 0x13, 0x1D, 0xA8, 0x90, 0xDF, 0xA0,
  0x1A, 0xEE, 0xC5,
  // "Ĉ" (U+0108)
  0x48, 0x21, 0x77, 0x16, 0x09, 0xA0, 0x95, 0x84, 0x4F, 0x89, 0xF4, 0x40, 0xD0, 0x92, 0x81, 0x9E,
  0x17, 0x68, 0x47, 0xCF, 0xEC, 0x63, 0x0B, 0xA8, 0x2E, 0xEF, 0xD2, 0x82, 0x8F, 0xE3, 0x28, 0x23,
  0x50, 0x1A, 0x04, 0x68, 0x16, 0xFD, 0x78, 0x1A, 0xF9, 0x78, 0x1C, 0xF6, 0x78, 0x1D, 0xF5, 0x78,
  0x1D, 0xF5, 0x78, 0x1C, 0xF6, 0x78, 0x1A, 0xF8, 0x78, 0x17, 0xFC, 0x70, 0x2A, 0x03, 0x78, 0x2A,
  0xFD, 0x32, 0x01, 0x03, 0x20, 0x10, 0xDA, 0x82, 0xDD, 0xFA, 0x48, 0x48, 0xDF, 0xEC, 0x51,
  // "ĉ" (U+0109)
  0x28, 0x21, 0x77, 0x14, 0x09, 0xA0, 0x93, 0x84, 0x4F, 0x89, 0xF4, 0x20, 0xD0, 0x92, 0x81, 0x9E,
  0x17, 0x28, 0x41, 0x9E, 0xFD, 0x72, 0x0C, 0xA8, 0x95, 0xDF, 0x90, 0x6F, 0xD1, 0x01, 0x20, 0xCF,
  0x65, 0x81, 0xEF, 0x25, 0xA0, 0x15, 0xA6, 0xA0, 0x25, 0x81, 0xCF, 0x55, 0x82, 0x7F, 0xD1, 0x28,
  0x23, 0x01, 0xDA, 0x81, 0xDF, 0xA2, 0x84, 0x1A, 0xEE, 0xC5, 0x10,
  // "Ċ" (U+010A)
  0x50, 0x0A, 0x60, 0x1A, 0x02, 0x60, 0xC0, 0xD7, 0x77, 0x28, 0x47, 0xCF, 0xEC, 0x62, 0x0B, 0xA8,
  0x7E, 0xEF, 0xD0, 0x8F, 0xE3, 0x28, 0x13, 0x51, 0xA0, 0x45, 0x81, 0x6F, 0xD6, 0x81, 0xAF, 0x96,
  0x81, 0xCF, 0x66, 0x81, 0xDF, 0x56, 0x81, 0xDF, 0x56, 0x81, 0xCF, 0x66, 0x81, 0xAF, 0x86, 0x81,
  0x7F, 0xC6, 0x02, 0xA0, 0x36, 0x82, 0xAF, 0xD3, 0x28, 0x31, 0x30, 0x1D, 0xA8, 0x2D, 0xDF, 0xA3,
  0x84, 0x8D, 0xFE, 0xC5,
  // "ċ" (U+010B)
  0x30, 0x0A, 0x40, 0x1A, 0x02, 0x40, 0xC0, 0xD7, 0x73, 0x86, 0x19, 0xEF, 0xD7, 0x0C, 0xA8, 0x93,
  0xDF, 0x96, 0xFD, 0x10, 0x12, 0xCF, 0x64, 0x81, 0xEF, 0x24, 0xA0, 0x14, 0xA5, 0xA0, 0x24, 0x81,
  0xCF, 0x54, 0x82, 0x7F, 0xD1, 0x28, 0x13, 0x1D, 0xA8, 0x90, 0xDF, 0xA0, 0x1A, 0xEE, 0xC5,
  // "Č" (U+010C)
  0x30, 0x70, 0x22, 0x81, 0x27, 0x13, 0x84, 0x9E, 0x22, 0xE9, 0x58, 0x2D, 0xDE, 0xD6, 0x04, 0xA0,
  0x47, 0x71, 0x84, 0x7C, 0xFE, 0xC6, 0x30, 0xBA, 0x82, 0xEE, 0xFD, 0x28, 0x28, 0xFE, 0x32, 0x82,
  0x35, 0x01, 0xA0, 0x46, 0x81, 0x6F, 0xD7, 0x81, 0xAF, 0x97, 0x81, 0xCF, 0x67, 0x81, 0xDF, 0x57,
  0x81, 0xDF, 0x57, 0x81, 0xCF, 0x67, 0x81, 0xAF, 0x87, 0x81, 0x7F, 0xC7, 0x02, 0xA0, 0x37, 0x82,
  0xAF, 0xD3, 0x20, 0x10, 0x32, 0x01, 0x0D, 0xA8, 0x2D, 0xDF, 0xA4, 0x84, 0x8D, 0xFE, 0xC5, 0x10,
  // "č" (U+010D)
  0x10, 0x70, 0x22, 0x89, 0x02, 0x71, 0x09, 0xE2, 0x2E, 0x93, 0x82, 0xDD, 0xED, 0x40, 0x4A, 0x04,
  0x74, 0x84, 0x19, 0xEF, 0xD7, 0x20, 0xCA, 0x89, 0x5D, 0xF9, 0x06, 0xFD, 0x10, 0x12, 0x0C, 0xF6,
  0x58, 0x1E, 0xF2, 0x5A, 0x01, 0x5A, 0x6A, 0x02, 0x58, 0x1C, 0xF5, 0x58, 0x27, 0xFD, 0x12, 0x82,
  0x30, 0x1D, 0xA8, 0x1D, 0xFA, 0x28, 0x41, 0xAE, 0xEC, 0x51,
  // "Ď" (U+010E)
  0x20, 0x70, 0x22, 0x81, 0x27, 0x14, 0x84, 0x9E, 0x22, 0xE9, 0x68, 0x2D, 0xDE, 0xD7, 0x04, 0xA0,
  0x47, 0x71, 0x05, 0xC8, 0x1D, 0x92, 0x38, 0x35, 0xFE, 0xCD, 0xB0, 0x42, 0x81, 0x5F, 0xC2, 0x87,
  0x1A, 0xFE, 0x10, 0x5F, 0xC4, 0x85, 0xCF, 0x80, 0x5F, 0xC4, 0x85, 0x5F, 0xE0, 0x5F, 0xC4, 0x01,
  0xA8, 0x21, 0x5F, 0xC5, 0xA8, 0x23, 0x5F, 0xC5, 0x84, 0xEF, 0x45, 0xFC, 0x58, 0x4E, 0xF4, 0x5F,
  0xC5, 0xA8, 0x23, 0x5F, 0xC4, 0x02, 0xA8, 0x21, 0x5F, 0xC4, 0x85, 0x6F, 0xD0, 0x5F, 0xC4, 0x85,
  0xDF, 0x70, 0x5F, 0xC2, 0x82, 0x1B, 0xFD, 0x28, 0x35, 0xFE, 0xCD, 0xA0, 0xE0, 0x32, 0x05, 0xC8,
  0x1D, 0x81, 0x30,
  // "ď" (U+010F)
  0x68, 0x49, 0xF6, 0x0F, 0xE6, 0x84, 0x9F, 0x62, 0xF9, 0x68, 0x49, 0xF6, 0x6E, 0x16, 0x81, 0x9F,
  0x64, 0x86, 0x3C, 0xFC, 0x49, 0xF6, 0x38, 0x71, 0xEF, 0xEE, 0xFC, 0xF6, 0x38, 0x18, 0xFC, 0x20,
  0x7A, 0x06, 0x38, 0x1C, 0xF5, 0x38, 0x1D, 0xF6, 0x3A, 0x02, 0x38, 0x1A, 0xF6, 0x3A, 0x01, 0x38,
  0x19, 0xF6, 0x3A, 0x48, 0x19, 0xF6, 0x3A, 0x02, 0x38, 0x1B, 0xF6, 0x38, 0x1D, 0xF5, 0x38, 0x1D,
  0xF6, 0x38, 0x18, 0xFC, 0x20, 0x7A, 0x06, 0x38, 0x71, 0xEF, 0xEE, 0xFB, 0xF6, 0x48, 0x63, 0xCF,
  0xD5, 0x4F, 0x63,
  // "Đ" (U+0110)
  0x10, 0x5C, 0x81, 0xD9, 0x24, 0x05, 0xA0, 0xC0, 0xDA, 0x0E, 0x04, 0x38, 0x15, 0xFC, 0x28, 0x31,
  0xAF, 0xE1, 0x28, 0x15, 0xFC, 0x48, 0x1C, 0xF8, 0x28, 0x15, 0xFC, 0x48, 0x15, 0xFD, 0x28, 0x15,
  0xFC, 0x40, 0x1A, 0x83, 0x10, 0x5F, 0xC5, 0xA8, 0x13, 0x7D, 0xA8, 0x1C, 0xC2, 0x28, 0x2E, 0xF4,
  0x9D, 0x02, 0x28, 0x5E, 0xF4, 0x05, 0xFC, 0x5A, 0x83, 0x30, 0x5F, 0xC4, 0x02, 0xA2, 0x81, 0x5F,
  0xC4, 0x81, 0x6F, 0xC2, 0x81, 0x5F, 0xC4, 0x81, 0xDF, 0x72, 0x81, 0x5F, 0xC2, 0x82, 0x1B, 0xFD,
  0x30, 0x5A, 0x0C, 0x0D, 0xA0, 0xE0, 0x33, 0x05, 0xC8, 0x1D, 0x81, 0x30,
  // "đ" (U+0111)
  0x68, 0x19, 0xF6, 0x40, 0x6D, 0x0B, 0x38, 0x55, 0xCC, 0xEF, 0xD9, 0x68, 0x19, 0xF6, 0x28, 0xA4,
  0x3C, 0xFC, 0x49, 0xF6, 0x01, 0xEF, 0xEE, 0xFC, 0xF6, 0x08, 0xFC, 0x20, 0x7A, 0x83, 0x60, 0xDF,
  0x53, 0x81, 0xDF, 0x61, 0xA0, 0x23, 0x81, 0xAF, 0x61, 0xA0, 0x13, 0x81, 0x9F, 0x61, 0xA0, 0x13,
  0x81, 0x9F, 0x61, 0xA0, 0x23, 0x85, 0xAF, 0x60, 0xCF, 0x53, 0x85, 0xDF, 0x60, 0x8F, 0xC2, 0x06,
  0xA8, 0x91, 0x60, 0x1E, 0xFE, 0xEF, 0xBF, 0x62, 0x86, 0x3C, 0xFD, 0x55, 0xF6, 0x10,
  // "Ē" (U+0112)
  0x02, 0x80, 0x1C, 0x81, 0x60, 0x2D, 0x07, 0x72, 0x05, 0xE8, 0x92, 0x75, 0xFE, 0xCC, 0xCC, 0x65,
  0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x50, 0x5E, 0x89,
  0x23, 0x5F, 0xEC, 0xCC, 0xC2, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5,
  0x81, 0x5F, 0xC5, 0x87, 0x5F, 0xEC, 0xCC, 0xC6, 0x5E, 0x07,
  // "ē" (U+0113)
  0x02, 0x80, 0x1C, 0x81, 0x60, 0x2D, 0x07, 0x73, 0x84, 0x19, 0xEE, 0xA2, 0x28, 0x90, 0xDF, 0xEE,
  0xFD, 0x17, 0xFC, 0x28, 0x49, 0xF7, 0xCF, 0x42, 0x81, 0x2F, 0xCA, 0x01, 0x3F, 0xD8, 0x02, 0xCA,
  0x01, 0x58, 0x1C, 0xF4, 0x58, 0x26, 0xFD, 0x22, 0x82, 0x23, 0x0C, 0xA8, 0x92, 0xDE, 0xF8, 0x01,
  0x8D, 0xFD, 0xA3,
  // "Ĕ" (U+0114)
  0x81, 0x1F, 0x52, 0x0B, 0x09, 0x28, 0x4C, 0xFD, 0xEF, 0x42, 0x83, 0x2B, 0xED, 0x67, 0x30, 0x5E,
  0x89, 0x27, 0x5F, 0xEC, 0xCC, 0xC6, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F,
  0xC5, 0x81, 0x5F, 0xC5, 0x05, 0xE8, 0x92, 0x35, 0xFE, 0xCC, 0xCC, 0x25, 0xFC, 0x58, 0x15, 0xFC,
  0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x75, 0xFE, 0xCC, 0xCC, 0x65, 0xE0,
  0x70,
  // "ĕ" (U+0115)
  0x81, 0x1F, 0x52, 0x0B, 0x09, 0x28, 0x4C, 0xFD, 0xEF, 0x42, 0x83, 0x2B, 0xED, 0x67, 0x48, 0x41,
  0x9E, 0xEA, 0x22, 0x89, 0x0D, 0xFE, 0xEF, 0xD1, 0x7F, 0xC2, 0x84, 0x9F, 0x7C, 0xF4, 0x28, 0x12,
  0xFC, 0xA0, 0x13, 0xFD, 0x80, 0x2C, 0xA0, 0x15, 0x81, 0xCF, 0x45, 0x82, 0x6F, 0xD2, 0x28, 0x22,
  0x30, 0xCA, 0x89, 0x2D, 0xEF, 0x80, 0x18, 0xDF, 0xDA, 0x30,
  // "Ė" (U+0116)
  0x30, 0x0A, 0x50, 0x1A, 0x02, 0x50, 0xC0, 0xD7, 0x75, 0x05, 0xE8, 0x92, 0x75, 0xFE, 0xCC, 0xCC,
  0x65, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x50, 0x5E,
  0x89, 0x23, 0x5F, 0xEC, 0xCC, 0xC2, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F,
  0xC5, 0x81, 0x5F, 0xC5, 0x87, 0x5F, 0xEC, 0xCC, 0xC6, 0x5E, 0x07,
  // "ė" (U+0117)
  0x30, 0x0A, 0x50, 0x1A, 0x02, 0x50, 0xC0, 0xD7, 0x76, 0x84, 0x19, 0xEE, 0xA2, 0x28, 0x90, 0xDF,
  0xEE, 0xFD, 0x17, 0xFC, 0x28, 0x49, 0xF7, 0xCF, 0x42, 0x81, 0x2F, 0xCA, 0x01, 0x3F, 0xD8, 0x02,
  0xCA, 0x01, 0x58, 0x1C, 0xF4, 0x58, 0x26, 0xFD, 0x22, 0x82, 0x23, 0x0C, 0xA8, 0x92, 0xDE, 0xF8,
  0x01, 0x8D, 0xFD, 0xA3,
  // "Ę" (U+0118)
  0x05, 0xE8, 0x92, 0x75, 0xFE, 0xCC, 0xCC, 0x65, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58,
  0x15, 0xFC, 0x58, 0x15, 0xFC, 0x50, 0x5E, 0x89, 0x23, 0x5F, 0xEC, 0xCC, 0xC2, 0x5F, 0xC5, 0x81,
  0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x87, 0x5F, 0xEC, 0xCC, 0xC6,
  0x5E, 0x07, 0x48, 0x14, 0xE2, 0x50, 0xD0, 0x95, 0x81, 0x1F, 0x96, 0xA0, 0xD0, 0x24, 0x82, 0x6E,
  0xE2,
  // "ę" (U+0119)
  0x18, 0x41, 0x9E, 0xEA, 0x22, 0x89, 0x0D, 0xFE, 0xEF, 0xD1, 0x7F, 0xC2, 0x84, 0x9F, 0x7C, 0xF4,
  0x28, 0x12, 0xFC, 0xA0, 0x13, 0xFD, 0x80, 0x2C, 0xA0, 0x15, 0x81, 0xCF, 0x45, 0x82, 0x6F, 0xD2,
  0x28, 0x22, 0x30, 0xCA, 0x86, 0xDE, 0xF8, 0x01, 0x8D, 0xB0, 0x45, 0x0D, 0x07, 0x50, 0x90, 0xE6,
  0x00, 0xD6, 0x82, 0xBF, 0xE7, 0x48, 0x23, 0xDE, 0x60,
  // "Ě" (U+011A)
  0x10, 0x70, 0x22, 0x89, 0x02, 0x71, 0x09, 0xE2, 0x2E, 0x93, 0x82, 0xDD, 0xED, 0x40, 0x4A, 0x04,
  0x73, 0x05, 0xE8, 0x92, 0x75, 0xFE, 0xCC, 0xCC, 0x65, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC,
  0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x50, 0x5E, 0x89, 0x23, 0x5F, 0xEC, 0xCC, 0xC2, 0x5F, 0xC5,
  0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x87, 0x5F, 0xEC, 0xCC,
  0xC6, 0x5E, 0x07,
  // "ě" (U+011B)
  0x10, 0x70, 0x22, 0x89, 0x02, 0x71, 0x09, 0xE2, 0x2E, 0x93, 0x82, 0xDD, 0xED, 0x40, 0x4A, 0x04,
  0x74, 0x84, 0x19, 0xEE, 0xA2, 0x28, 0x90, 0xDF, 0xEE, 0xFD, 0x17, 0xFC, 0x28, 0x49, 0xF7, 0xCF,
  0x42, 0x81, 0x2F, 0xCA, 0x01, 0x3F, 0xD8, 0x02, 0xCA, 0x01, 0x58, 0x1C, 0xF4, 0x58, 0x26, 0xFD,
  0x22, 0x82, 0x23, 0x0C, 0xA8, 0x92, 0xDE, 0xF8, 0x01, 0x8D, 0xFD, 0xA3,
  // "Ĝ" (U+011C)
  0x48, 0x21, 0x77, 0x17, 0x09, 0xA0, 0x96, 0x84, 0x4F, 0x89, 0xF4, 0x50, 0xD0, 0x92, 0x81, 0x9E,
  0x17, 0x71, 0x85, 0x3A, 0xDF, 0xDB, 0x53, 0x08, 0xA0, 0xE0, 0xDB, 0x81, 0x10, 0x6A, 0x06, 0x38,
  0x54, 0x70, 0x1E, 0xF6, 0x78, 0x15, 0xFD, 0x71, 0x81, 0xAF, 0x87, 0x18, 0x1C, 0xF6, 0x71, 0x81,
  0xDF, 0x53, 0x80, 0x0C, 0x82, 0x6D, 0xF5, 0x3C, 0x82, 0x7C, 0xF6, 0x58, 0x4A, 0xF7, 0xAF, 0x85,
  0x84, 0xAF, 0x76, 0xFC, 0x58, 0x2A, 0xF7, 0x1A, 0x04, 0x48, 0x6A, 0xF7, 0x08, 0xFE, 0x43, 0x81,
  0xAF, 0x72, 0x0B, 0xA8, 0x1E, 0xDE, 0xA0, 0x73, 0x86, 0x6C, 0xFE, 0xDB, 0x82,
  // "ĝ" (U+011D)
  0x28, 0x21, 0x77, 0x15, 0x09, 0xA0, 0x94, 0x84, 0x4F, 0x89, 0xF4, 0x30, 0xD0, 0x92, 0x81, 0x9E,
  0x17, 0x48, 0xA2, 0x2B, 0xFD, 0x45, 0xF6, 0x1E, 0xFE, 0xEF, 0xBF, 0x68, 0xFC, 0x20, 0x7A, 0x82,
  0x6C, 0xF5, 0x38, 0x1D, 0xF6, 0xA0, 0x23, 0x81, 0xAF, 0x6A, 0x01, 0x38, 0x19, 0xF6, 0xA4, 0x81,
  0x9F, 0x6A, 0x02, 0x38, 0x4A, 0xF6, 0xDF, 0x53, 0x84, 0xDF, 0x68, 0xFC, 0x20, 0x6A, 0x81, 0x61,
  0xEA, 0x89, 0x4E, 0xFB, 0xF6, 0x03, 0xCF, 0xC4, 0x9F, 0x66, 0x81, 0xAF, 0x56, 0x83, 0xCF, 0x33,
  0x43, 0x83, 0x7F, 0xE0, 0x7A, 0x0D, 0x0E, 0xA8, 0x75, 0x02, 0x9D, 0xFE, 0xB4, 0x20,
  // "Ğ" (U+011E)
  0x28, 0x11, 0xF5, 0x20, 0xB0, 0x95, 0x84, 0xCF, 0xDE, 0xF4, 0x58, 0x32, 0xBE, 0xD6, 0x77, 0x38,
  0x53, 0xAD, 0xFD, 0xB5, 0x30, 0x8A, 0x0E, 0x0D, 0xB8, 0x11, 0x06, 0xA0, 0x63, 0x85, 0x47, 0x01,
  0xEF, 0x67, 0x81, 0x5F, 0xD7, 0x18, 0x1A, 0xF8, 0x71, 0x81, 0xCF, 0x67, 0x18, 0x1D, 0xF5, 0x38,
  0x00, 0xC8, 0x26, 0xDF, 0x53, 0xC8, 0x27, 0xCF, 0x65, 0x84, 0xAF, 0x7A, 0xF8, 0x58, 0x4A, 0xF7,
  0x6F, 0xC5, 0x82, 0xAF, 0x71, 0xA0, 0x44, 0x86, 0xAF, 0x70, 0x8F, 0xE4, 0x38, 0x1A, 0xF7, 0x20,
  0xBA, 0x81, 0xED, 0xEA, 0x07, 0x38, 0x66, 0xCF, 0xED, 0xB8, 0x20,
  // "ğ" (U+011F)
  0x18, 0x11, 0xF5, 0x20, 0xB0, 0x93, 0x84, 0xCF, 0xDE, 0xF4, 0x38, 0x32, 0xBE, 0xD6, 0x75, 0x8A,
  0x22, 0xBF, 0xD4, 0x5F, 0x61, 0xEF, 0xEE, 0xFB, 0xF6, 0x8F, 0xC2, 0x07, 0xA8, 0x26, 0xCF, 0x53,
  0x81, 0xDF, 0x6A, 0x02, 0x38, 0x1A, 0xF6, 0xA0, 0x13, 0x81, 0x9F, 0x6A, 0x48, 0x19, 0xF6, 0xA0,
  0x23, 0x84, 0xAF, 0x6D, 0xF5, 0x38, 0x4D, 0xF6, 0x8F, 0xC2, 0x06, 0xA8, 0x16, 0x1E, 0xA8, 0x94,
  0xEF, 0xBF, 0x60, 0x3C, 0xFC, 0x49, 0xF6, 0x68, 0x1A, 0xF5, 0x68, 0x3C, 0xF3, 0x34, 0x38, 0x37,
  0xFE, 0x07, 0xA0, 0xD0, 0xEA, 0x87, 0x50, 0x29, 0xDF, 0xEB, 0x42,
  // "Ġ" (U+0120)
  0x50, 0x0A, 0x71, 0x01, 0xA0, 0x27, 0x10, 0xC0, 0xD7, 0x77, 0x71, 0x85, 0x3A, 0xDF, 0xDB, 0x53,
  0x08, 0xA0, 0xE0, 0xDB, 0x81, 0x10, 0x6A, 0x06, 0x38, 0x54, 0x70, 0x1E, 0xF6, 0x78, 0x15, 0xFD,
  0x71, 0x81, 0xAF, 0x87, 0x18, 0x1C, 0xF6, 0x71, 0x81, 0xDF, 0x53, 0x80, 0x0C, 0x82, 0x6D, 0xF5,
  0x3C, 0x82, 0x7C, 0xF6, 0x58, 0x4A, 0xF7, 0xAF, 0x85, 0x84, 0xAF, 0x76, 0xFC, 0x58, 0x2A, 0xF7,
  0x1A, 0x04, 0x48, 0x6A, 0xF7, 0x08, 0xFE, 0x43, 0x81, 0xAF, 0x72, 0x0B, 0xA8, 0x1E, 0xDE, 0xA0,
  0x73, 0x86, 0x6C, 0xFE, 0xDB, 0x82,
  // "ġ" (U+0121)
  0x40, 0x0A, 0x60, 0x1A, 0x02, 0x60, 0xC0, 0xD7, 0x77, 0x18, 0xA2, 0x2B, 0xFD, 0x45, 0xF6, 0x1E,
  0xFE, 0xEF, 0xBF, 0x68, 0xFC, 0x20, 0x7A, 0x82, 0x6C, 0xF5, 0x38, 0x1D, 0xF6, 0xA0, 0x23, 0x81,
  0xAF, 0x6A, 0x01, 0x38, 0x19, 0xF6, 0xA4, 0x81, 0x9F, 0x6A, 0x02, 0x38, 0x4A, 0xF6, 0xDF, 0x53,
  0x84, 0xDF, 0x68, 0xFC, 0x20, 0x6A, 0x81, 0x61, 0xEA, 0x89, 0x4E, 0xFB, 0xF6, 0x03, 0xCF, 0xC4,
  0x9F, 0x66, 0x81, 0xAF, 0x56, 0x83, 0xCF, 0x33, 0x43, 0x83, 0x7F, 0xE0, 0x7A, 0x0D, 0x0E, 0xA8,
  0x75, 0x02, 0x9D, 0xFE, 0xB4, 0x20,
  // "Ģ" (U+0122)
  0x38, 0x53, 0xAD, 0xFD, 0xB5, 0x30, 0x8A, 0x0E, 0x0D, 0xB8, 0x11, 0x06, 0xA0, 0x63, 0x85, 0x47,
  0x01, 0xEF, 0x67, 0x81, 0x5F, 0xD7, 0x18, 0x1A, 0xF8, 0x71, 0x81, 0xCF, 0x67, 0x18, 0x1D, 0xF5,
  0x38, 0x00, 0xC8, 0x26, 0xDF, 0x53, 0xC8, 0x27, 0xCF, 0x65, 0x84, 0xAF, 0x7A, 0xF8, 0x58, 0x4A,
  0xF7, 0x6F, 0xC5, 0x82, 0xAF, 0x71, 0xA0, 0x44, 0x86, 0xAF, 0x70, 0x8F, 0xE4, 0x38, 0x1A, 0xF7,
  0x20, 0xBA, 0x81, 0xED, 0xEA, 0x07, 0x38, 0x66, 0xCF, 0xED, 0xB8, 0x27, 0x77, 0x69, 0x0E, 0x71,
  0x81, 0x3F, 0x87, 0x10, 0x70, 0xD5,
  // "ģ" (U+0123)
  0x48, 0x15, 0xF1, 0x58, 0x11, 0xEC, 0x68, 0x16, 0xF8, 0x76, 0x8A, 0x22, 0xBF, 0xD4, 0x5F, 0x61,
  0xEF, 0xEE, 0xFB, 0xF6, 0x8F, 0xC2, 0x07, 0xA8, 0x26, 0xCF, 0x53, 0x81, 0xDF, 0x6A, 0x02, 0x38,
  0x1A, 0xF6, 0xA0, 0x13, 0x81, 0x9F, 0x6A, 0x48, 0x19, 0xF6, 0xA0, 0x23, 0x84, 0xAF, 0x6D, 0xF5,
  0x38, 0x4D, 0xF6, 0x8F, 0xC2, 0x06, 0xA8, 0x16, 0x1E, 0xA8, 0x94, 0xEF, 0xBF, 0x60, 0x3C, 0xFC,
  0x49, 0xF6, 0x68, 0x1A, 0xF5, 0x68, 0x3C, 0xF3, 0x34, 0x38, 0x37, 0xFE, 0x07, 0xA0, 0xD0, 0xEA,
  0x87, 0x50, 0x29, 0xDF, 0xEB, 0x42,
  // "Ĥ" (U+0124)
  0x38, 0x21, 0x77, 0x17, 0x09, 0xA0, 0x96, 0x84, 0x4F, 0x89, 0xF4, 0x50, 0xD0, 0x92, 0x81, 0x9E,
  0x17, 0x68, 0x15, 0xFC, 0x5A, 0x82, 0x15, 0xFC, 0x5A, 0x82, 0x15, 0xFC, 0x5A, 0x82, 0x15, 0xFC,
  0x5A, 0x82, 0x15, 0xFC, 0x5A, 0x82, 0x15, 0xFC, 0x5A, 0x82, 0x15, 0xFC, 0x5A, 0x01, 0x05, 0xFA,
  0x82, 0x15, 0xFE, 0x80, 0x1C, 0xA8, 0x21, 0x5F, 0xC5, 0xA8, 0x21, 0x5F, 0xC5, 0xA8, 0x21, 0x5F,
  0xC5, 0xA8, 0x21, 0x5F, 0xC5, 0xA8, 0x21, 0x5F, 0xC5, 0xA8, 0x21, 0x5F, 0xC5, 0xA8, 0x21, 0x5F,
  0xC5, 0xA0, 0x10,
  // "ĥ" (U+0125)
  0x18, 0x21, 0x77, 0x17, 0x09, 0xA0, 0x96, 0x84, 0x4F, 0x89, 0xF4, 0x50, 0xD0, 0x92, 0x81, 0x9E,
  0x17, 0x77, 0x78, 0x18, 0xF7, 0x71, 0x81, 0x8F, 0x77, 0x18, 0x18, 0xF7, 0x71, 0x81, 0x8F, 0x77,
  0x18, 0x68, 0xF7, 0x6D, 0xFB, 0x23, 0x83, 0x8F, 0xBF, 0xDA, 0x0D, 0x30, 0x8A, 0x84, 0x40, 0x1E,
  0xF4, 0x28, 0x18, 0xFC, 0x38, 0x1A, 0xF6, 0x28, 0x18, 0xF9, 0x38, 0x19, 0xF7, 0x28, 0x18, 0xF8,
  0x38, 0x19, 0xF7, 0x28, 0x18, 0xF7, 0x38, 0x19, 0xF7, 0x28, 0x18, 0xF7, 0x38, 0x19, 0xF7, 0x28,
  0x18, 0xF7, 0x38, 0x19, 0xF7, 0x28, 0x18, 0xF7, 0x38, 0x19, 0xF7, 0x28, 0x18, 0xF7, 0x38, 0x19,
  0xF7, 0x28, 0x18, 0xF7, 0x38, 0x19, 0xF7,
  // "Ħ" (U+0126)
  0x18, 0x16, 0xFB, 0x5A, 0x01, 0x28, 0x16, 0xFB, 0x5A, 0x01, 0x28, 0x16, 0xFB, 0x5A, 0x01, 0x1F,
  0xD8, 0x3B, 0xCD, 0xFE, 0x80, 0x1C, 0xA8, 0x4D, 0x90, 0x6F, 0xC5, 0xA0, 0x12, 0x81, 0x6F, 0xC5,
  0xA0, 0x12, 0x06, 0xFA, 0x01, 0x28, 0x16, 0xFE, 0x80, 0x1C, 0xA0, 0x12, 0x81, 0x6F, 0xB5, 0xA0,
  0x12, 0x81, 0x6F, 0xB5, 0xA0, 0x12, 0x81, 0x6F, 0xB5, 0xA0, 0x12, 0x81, 0x6F, 0xB5, 0xA0, 0x12,
  0x81, 0x6F, 0xB5, 0xA0, 0x12, 0x81, 0x6F, 0xB5, 0xA0, 0x12, 0x81, 0x6F, 0xB5, 0xA0, 0x11,
  // "ħ" (U+0127)
  0x18, 0x19, 0xF7, 0x68, 0x5B, 0xEF, 0xEC, 0xC4, 0x30, 0xDD, 0x05, 0x48, 0x19, 0xF7, 0x78, 0x69,
  0xF7, 0x6D, 0xFB, 0x22, 0x83, 0x9F, 0xBF, 0xDA, 0x0D, 0x20, 0x9A, 0x89, 0x04, 0x02, 0xEF, 0x40,
  0x9F, 0xC3, 0x85, 0xAF, 0x60, 0x9F, 0x93, 0x85, 0x9F, 0x70, 0x9F, 0x83, 0x85, 0x9F, 0x70, 0x9F,
  0x73, 0x85, 0x9F, 0x70, 0x9F, 0x73, 0x85, 0x9F, 0x70, 0x9F, 0x73, 0x85, 0x9F, 0x70, 0x9F, 0x73,
  0x85, 0x9F, 0x70, 0x9F, 0x73, 0x85, 0x9F, 0x70, 0x9F, 0x73, 0x81, 0x9F, 0x70,
  // "Ĩ" (U+0128)
  0x18, 0xA4, 0x4E, 0xD4, 0x0A, 0x90, 0xCE, 0xEF, 0xDF, 0x61, 0xF2, 0x19, 0xEB, 0x73, 0x04, 0xC0,
  0xD2, 0x02, 0x0B, 0xA0, 0xD0, 0x84, 0x81, 0xCF, 0x55, 0x81, 0xCF, 0x55, 0x81, 0xCF, 0x55, 0x81,
  0xCF, 0x55, 0x81, 0xCF, 0x55, 0x81, 0xCF, 0x55, 0x81, 0xCF, 0x55, 0x81, 0xCF, 0x55, 0x81, 0xCF,
  0x55, 0x81, 0xCF, 0x55, 0x81, 0xCF, 0x55, 0x81, 0xCF, 0x53, 0x84, 0x18, 0xEF, 0xB5, 0x20, 0x4C,
  0x0D, 0x10,
  // "ĩ" (U+0129)
  0x18, 0xA4, 0x4E, 0xD4, 0x0A, 0x90, 0xCE, 0xEF, 0xDF, 0x61, 0xF2, 0x19, 0xEB, 0x75, 0x81, 0x8F,
  0x75, 0x81, 0x8F, 0x75, 0x81, 0x8F, 0x75, 0x81, 0x8F, 0x75, 0x81, 0x8F, 0x75, 0x81, 0x8F, 0x75,
  0x81, 0x8F, 0x75, 0x81, 0x8F, 0x75, 0x81, 0x8F, 0x75, 0x81, 0x8F, 0x75, 0x81, 0x8F, 0x75, 0x81,
  0x8F, 0x72,
  // "Ī" (U+012A)
  0x02, 0x80, 0x1C, 0x06, 0x02, 0xD0, 0x77, 0x04, 0xC8, 0x2D, 0x02, 0xBA, 0x0D, 0x08, 0x38, 0x1C,
  0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5,
  0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48,
  0x1C, 0xF5, 0x28, 0x61, 0x8E, 0xFB, 0x50, 0x4C, 0x0D, 0x10,
  // "ī" (U+012B)
  0x02, 0x80, 0x1C, 0x06, 0x02, 0xD0, 0x77, 0x28, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7,
  0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48,
  0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x20,
  // "Ĭ" (U+012C)
  0x81, 0x1F, 0x52, 0x89, 0x5B, 0x90, 0xCF, 0xDE, 0xF4, 0x02, 0xBE, 0xD6, 0x71, 0x04, 0xC8, 0x2D,
  0x02, 0xBA, 0x0D, 0x08, 0x38, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5,
  0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48,
  0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x28, 0x61, 0x8E, 0xFB, 0x50, 0x4C, 0x0D, 0x10,
  // "ĭ" (U+012D)
  0x81, 0x1F, 0x52, 0x89, 0x5B, 0x90, 0xCF, 0xDE, 0xF4, 0x02, 0xBE, 0xD6, 0x73, 0x81, 0x8F, 0x74,
  0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81,
  0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81, 0x8F,
  0x72,
  // "Į" (U+012E)
  0x04, 0xC8, 0x2D, 0x02, 0xBA, 0x0D, 0x08, 0x38, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5,
  0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48,
  0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x48, 0x1C, 0xF5, 0x28, 0x61, 0x8E, 0xFB, 0x50,
  0x4D, 0x48, 0x14, 0xE2, 0x40, 0xD0, 0x94, 0x81, 0x1F, 0x95, 0xA0, 0xD0, 0x23, 0x82, 0x6E, 0xE2,
  // "į" (U+012F)
  0x18, 0x15, 0xE5, 0x28, 0x19, 0xF9, 0x28, 0x14, 0xC4, 0x78, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28,
  0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18,
  0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xFB, 0x28, 0x14, 0xE2,
  0x20, 0xD0, 0x92, 0x81, 0x1F, 0x93, 0xA8, 0x5D, 0x20, 0x6E, 0xE2,
  // "İ" (U+0130)
  0x20, 0x0A, 0x30, 0x1A, 0x02, 0x30, 0xC0, 0xD7, 0x70, 0x4C, 0x81, 0xD2, 0xBA, 0x0D, 0x08, 0x28,
  0x1C, 0xF5, 0x38, 0x1C, 0xF5, 0x38, 0x1C, 0xF5, 0x38, 0x1C, 0xF5, 0x38, 0x1C, 0xF5, 0x38, 0x1C,
  0xF5, 0x38, 0x1C, 0xF5, 0x38, 0x1C, 0xF5, 0x38, 0x1C, 0xF5, 0x38, 0x1C, 0xF5, 0x38, 0x1C, 0xF5,
  0x38, 0x91, 0xCF, 0x50, 0x18, 0xEF, 0xB5, 0x4C, 0x0D,
  // "ı" (U+0131)
  0x8C, 0x28, 0xF7, 0x8F, 0x78, 0xF7, 0x8F, 0x78, 0xF7, 0x8F, 0x78, 0xF7, 0x8F, 0x78, 0xF7, 0x8F,
  0x78, 0xF7, 0x8F, 0x70,
  // "Ĳ" (U+0132)
  0x04, 0xC8, 0x5D, 0x06, 0xFB, 0x2B, 0xA8, 0x4D, 0x80, 0x6F, 0xB2, 0x81, 0xCF, 0x52, 0x81, 0x6F,
  0xB2, 0x81, 0xCF, 0x52, 0x81, 0x6F, 0xB2, 0x81, 0xCF, 0x52, 0x81, 0x6F, 0xB2, 0x81, 0xCF, 0x52,
  0x81, 0x6F, 0xB2, 0x81, 0xCF, 0x52, 0x81, 0x6F, 0xB2, 0x81, 0xCF, 0x52, 0x81, 0x6F, 0xB2, 0x81,
  0xCF, 0x52, 0x81, 0x6F, 0xB2, 0x81, 0xCF, 0x52, 0x81, 0x6F, 0xB2, 0x81, 0xCF, 0x52, 0x81, 0x6F,
  0xB2, 0x81, 0xCF, 0x52, 0x81, 0x6F, 0xB2, 0x81, 0xCF, 0x52, 0x81, 0x6F, 0xB2, 0x81, 0xCF, 0x52,
  0x89, 0x46, 0xFB, 0x18, 0xEF, 0xB5, 0x06, 0xFB, 0x4C, 0x83, 0xD0, 0x6F, 0xA7, 0x81, 0x8F, 0x96,
  0x82, 0x2D, 0xF6, 0x40, 0x3B, 0x0D, 0x01, 0x48, 0x32, 0xBC, 0x91, 0x10,
  // "ĳ" (U+0133)
  0x81, 0x5E, 0x52, 0x84, 0x5E, 0x59, 0xF9, 0x28, 0x49, 0xF9, 0x4C, 0x42, 0x81, 0x4C, 0x47, 0x18,
  0x18, 0xF7, 0x28, 0x48, 0xF7, 0x8F, 0x72, 0x84, 0x8F, 0x78, 0xF7, 0x28, 0x48, 0xF7, 0x8F, 0x72,
  0x84, 0x8F, 0x78, 0xF7, 0x28, 0x48, 0xF7, 0x8F, 0x72, 0x84, 0x8F, 0x78, 0xF7, 0x28, 0x48, 0xF7,
  0x8F, 0x72, 0x84, 0x8F, 0x78, 0xF7, 0x28, 0x48, 0xF7, 0x8F, 0x72, 0x84, 0x8F, 0x78, 0xF7, 0x28,
  0x48, 0xF7, 0x8F, 0x72, 0x81, 0x8F, 0x75, 0x81, 0x8F, 0x75, 0x81, 0x8F, 0x75, 0x81, 0xBF, 0x53,
  0x08, 0x0E, 0xA0, 0x13, 0x82, 0x8F, 0xD5, 0x10,
  // "Ĵ" (U+0134)
  0x38, 0x21, 0x77, 0x15, 0x09, 0xA0, 0x94, 0x84, 0x4F, 0x89, 0xF4, 0x30, 0xD0, 0x92, 0x81, 0x9E,
  0x17, 0x58, 0x16, 0xFB, 0x68, 0x16, 0xFB, 0x68, 0x16, 0xFB, 0x68, 0x16, 0xFB, 0x68, 0x16, 0xFB,
  0x68, 0x16, 0xFB, 0x68, 0x16, 0xFB, 0x68, 0x16, 0xFB, 0x68, 0x16, 0xFB, 0x68, 0x16, 0xFB, 0x68,
  0x16, 0xFB, 0x68, 0x16, 0xFB, 0x68, 0x16, 0xFB, 0x68, 0x16, 0xFB, 0x68, 0x16, 0xFB, 0x68, 0x16,
  0xFA, 0x68, 0x18, 0xF9, 0x58, 0x22, 0xDF, 0x63, 0x03, 0xB0, 0xD0, 0x13, 0x83, 0x2B, 0xC9, 0x14,
  // "ĵ" (U+0135)
  0x18, 0x21, 0x77, 0x13, 0x09, 0xA0, 0x92, 0x87, 0x4F, 0x89, 0xF4, 0x0D, 0x92, 0x81, 0x9E, 0x17,
  0x28, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48,
  0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18,
  0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x1C, 0xF5, 0x20, 0x90, 0xEA,
  0x01, 0x28, 0x28, 0xFD, 0x53,
  // "Ķ" (U+0136)
  0x81, 0x5F, 0xC4, 0x84, 0xDF, 0x65, 0xFC, 0x38, 0x57, 0xFC, 0x05, 0xFC, 0x28, 0x61, 0xEF, 0x30,
  0x5F, 0xC2, 0x81, 0xAF, 0xA2, 0x86, 0x5F, 0xC0, 0x3F, 0xE1, 0x28, 0x55, 0xFC, 0x0C, 0xF6, 0x38,
  0x45, 0xFC, 0x6F, 0xC4, 0x84, 0x5F, 0xDE, 0xF9, 0x40, 0x5D, 0x02, 0x30, 0x5A, 0x82, 0x5B, 0xF9,
  0x38, 0x35, 0xFC, 0x03, 0xA0, 0x22, 0x81, 0x5F, 0xC2, 0x81, 0xBF, 0x92, 0x81, 0x5F, 0xC2, 0x04,
  0xA8, 0x32, 0x05, 0xFC, 0x38, 0x5B, 0xFA, 0x05, 0xFC, 0x30, 0x4A, 0x82, 0x25, 0xFC, 0x48, 0x1B,
  0xFA, 0x77, 0x73, 0x90, 0xE7, 0x81, 0x3F, 0x87, 0x07, 0x0D, 0x50,
  // "ķ" (U+0137)
  0x81, 0x8F, 0x76, 0x81, 0x8F, 0x76, 0x81, 0x8F, 0x76, 0x81, 0x8F, 0x76, 0x81, 0x8F, 0x72, 0x85,
  0x3F, 0xE2, 0x8F, 0x72, 0x89, 0x1C, 0xF6, 0x08, 0xF7, 0x07, 0xFB, 0x28, 0x58, 0xF7, 0x2F, 0xE1,
  0x28, 0x48, 0xF7, 0xCF, 0x53, 0x81, 0x8F, 0xCA, 0x06, 0x30, 0x8A, 0x81, 0xCF, 0xD3, 0x85, 0x8F,
  0xB0, 0xCF, 0x62, 0x85, 0x8F, 0x70, 0x5F, 0xD2, 0x81, 0x8F, 0x72, 0x85, 0xDF, 0x60, 0x8F, 0x72,
  0x85, 0x6F, 0xD0, 0x8F, 0x73, 0x81, 0xDF, 0x67, 0x77, 0x90, 0xE6, 0x81, 0x3F, 0x86, 0x07, 0x0D,
  0x50,
  // "ĸ" (U+0138)
  0x81, 0x8F, 0x82, 0x85, 0x3F, 0xE2, 0x8F, 0x82, 0x89, 0x1C, 0xF6, 0x08, 0xF8, 0x07, 0xFB, 0x28,
  0x58, 0xF8, 0x2E, 0xE2, 0x28, 0x48, 0xF7, 0xBF, 0x63, 0x81, 0x8F, 0xBA, 0x06, 0x30, 0x8A, 0x81,
  0xDF, 0xD3, 0x85, 0x8F, 0xC0, 0xCF, 0x62, 0x85, 0x8F, 0x80, 0x5F, 0xD2, 0x81, 0x8F, 0x82, 0x85,
  0xDF, 0x60, 0x8F, 0x82, 0x85, 0x5F, 0xD0, 0x8F, 0x83, 0x81, 0xDF, 0x60,
  // "Ĺ" (U+0139)
  0x28, 0x13, 0x77, 0x58, 0x1C, 0xF8, 0x48, 0x15, 0xFA, 0x48, 0x11, 0xEB, 0x76, 0x81, 0x5F, 0xC5,
  0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81,
  0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F,
  0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x05, 0xA8, 0x00, 0xE0, 0x80, 0x5E, 0x08,
  // "ĺ" (U+013A)
  0x28, 0x13, 0x77, 0x28, 0x91, 0xCF, 0x80, 0x5F, 0xA0, 0x1E, 0xB7, 0x68, 0x18, 0xF7, 0x28, 0x18,
  0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7,
  0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28,
  0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x28, 0x18, 0xF7, 0x10,
  // "Ļ" (U+013B)
  0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81,
  0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F,
  0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x05, 0xA8, 0x00, 0xE0, 0x80, 0x5E,
  0x08, 0x77, 0x59, 0x0E, 0x58, 0x13, 0xF8, 0x50, 0x70, 0xD4,
  // "ļ" (U+013C)
  0x8D, 0x68, 0xF7, 0x8F, 0x78, 0xF7, 0x8F, 0x78, 0xF7, 0x8F, 0x78, 0xF7, 0x8F, 0x78, 0xF7, 0x8F,
  0x78, 0xF7, 0x8F, 0x78, 0xF7, 0x8F, 0x78, 0xF7, 0x8F, 0x77, 0x98, 0x4E, 0x3F, 0x87, 0xD1,
  // "Ľ" (U+013D)
  0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC3, 0x98, 0x2E, 0x5F, 0xC2, 0x84, 0x2F, 0x95, 0xFC, 0x28, 0x46,
  0xE1, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81,
  0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x05, 0xA8,
  0x00, 0xE0, 0x80, 0x5E, 0x08,
  // "ľ" (U+013E)
  0x8A, 0x38, 0xF7, 0x0F, 0xE8, 0xF7, 0x2F, 0x98, 0xF7, 0x6E, 0x18, 0xF7, 0x38, 0x18, 0xF7, 0x38,
  0x18, 0xF7, 0x38, 0x18, 0xF7, 0x38, 0x18, 0xF7, 0x38, 0x18, 0xF7, 0x38, 0x18, 0xF7, 0x38, 0x18,
  0xF7, 0x38, 0x18, 0xF7, 0x38, 0x18, 0xF7, 0x38, 0x18, 0xF7, 0x38, 0x18, 0xF7, 0x38, 0x18, 0xF7,
  0x30,
  // "Ŀ" (U+013F)
  0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81, 0x5F, 0xC5, 0x81,
  0x5F, 0xC2, 0x86, 0xAA, 0x05, 0xFC, 0x01, 0xA8, 0x22, 0x5F, 0xC2, 0x84, 0xCD, 0x05, 0xFC, 0x58,
  0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x58, 0x15, 0xFC, 0x50, 0x5A,
  0x80, 0x0E, 0x08, 0x05, 0xE0, 0x80,
  // "ŀ" (U+0140)
  0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74, 0x89,
  0x18, 0xF7, 0x0A, 0xA0, 0x8F, 0x71, 0xA8, 0x91, 0x28, 0xF7, 0x0C, 0xD0, 0x8F, 0x74, 0x81, 0x8F,
  0x74, 0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74, 0x81, 0x8F, 0x74,
  0x81, 0x8F, 0x74,
  // "Ł" (U+0141)
  0x18, 0x13, 0xFE, 0x68, 0x13, 0xFE, 0x68, 0x13, 0xFE, 0x68, 0x13, 0xFE, 0x68, 0x13, 0xFE, 0x68,
  0x43, 0xFE, 0x01, 0x23, 0x84, 0x3F, 0xE6, 0xEB, 0x30, 0x3B, 0x0E, 0x05, 0x30, 0x6A, 0x0B, 0x01,
  0x30, 0x9A, 0x0E, 0x58, 0x2A, 0xEF, 0xE6, 0x81, 0x3F, 0xE6, 0x81, 0x3F, 0xE6, 0x81, 0x3F, 0xE6,
  0x03, 0xA8, 0x00, 0xE8, 0x1A, 0x03, 0xE0, 0xA0,
  // "ł" (U+0142)
  0x28, 0x16, 0xFA, 0x48, 0x16, 0xFA, 0x48, 0x16, 0xFA, 0x48, 0x16, 0xFA, 0x48, 0x16, 0xFA, 0x48,
  0x16, 0xFA, 0x48, 0x36, 0xFC, 0xD3, 0x20, 0x6A, 0x89, 0x1E, 0x40, 0x2C, 0xFD, 0x20, 0x2E, 0xA0,
  0xA3, 0x82, 0x89, 0xFA, 0x48, 0x16, 0xFA, 0x48, 0x16, 0xFA, 0x48, 0x16, 0xFA, 0x48, 0x16, 0xFA,
  0x48, 0x16, 0xFA, 0x20,
  // "Ń" (U+0143)
  0x68, 0x13, 0x77, 0x71, 0x81, 0xCF, 0x87, 0x81, 0x5F, 0xA7, 0x81, 0x1E, 0xB7, 0x71, 0x05, 0xA0,
  0x64, 0x82, 0x2F, 0xD5, 0xA0, 0xD4, 0x82, 0x2F, 0xD5, 0xB0, 0x53, 0x86, 0x2F, 0xD5, 0xFE, 0xFC,
  0x38, 0x72, 0xFD, 0x5F, 0x9E, 0xF3, 0x28, 0x72, 0xFD, 0x5F, 0x98, 0xFA, 0x28, 0x52, 0xFD, 0x5F,
  0x91, 0xA8, 0xA3, 0x20, 0x2F, 0xD5, 0xF9, 0x09, 0xF9, 0x02, 0xFD, 0x5F, 0x90, 0x2A, 0x85, 0x12,
  0xFD, 0x5F, 0x92, 0x87, 0xAF, 0x82, 0xFD, 0x5F, 0x92, 0x87, 0x3F, 0xE2, 0xFD, 0x5F, 0x93, 0x86,
  0xCF, 0x7F, 0xD5, 0xF9, 0x38, 0x65, 0xFE, 0xFD, 0x5F, 0x94, 0x0D, 0xA8, 0x2D, 0x5F, 0x94, 0x06,
  0xA8, 0x2D, 0x5F, 0x95, 0x81, 0xEF, 0xD0,
  // "ń" (U+0144)
  0x48, 0x13, 0x77, 0x68, 0x1C, 0xF8, 0x58, 0x15, 0xFA, 0x58, 0x11, 0xEB, 0x76, 0x89, 0x48, 0xF2,
  0x6D, 0xFB, 0x20, 0x8F, 0xAF, 0xDA, 0x81, 0xD0, 0x8A, 0x87, 0x40, 0x1E, 0xF4, 0x8F, 0xC3, 0x84,
  0xAF, 0x68, 0xF9, 0x38, 0x49, 0xF7, 0x8F, 0x73, 0x84, 0x9F, 0x78, 0xF7, 0x38, 0x49, 0xF7, 0x8F,
  0x73, 0x84, 0x9F, 0x78, 0xF7, 0x38, 0x49, 0xF7, 0x8F, 0x73, 0x84, 0x9F, 0x78, 0xF7, 0x38, 0x49,
  0xF7, 0x8F, 0x73, 0x81, 0x9F, 0x70,
  // "Ņ" (U+0145)
  0x05, 0xA0, 0x64, 0x82, 0x2F, 0xD5, 0xA0, 0xD4, 0x82, 0x2F, 0xD5, 0xB0, 0x53, 0x86, 0x2F, 0xD5,
  0xFE, 0xFC, 0x38, 0x72, 0xFD, 0x5F, 0x9E, 0xF3, 0x28, 0x72, 0xFD, 0x5F, 0x98, 0xFA, 0x28, 0x52,
  0xFD, 0x5F, 0x91, 0xA8, 0xA3, 0x20, 0x2F, 0xD5, 0xF9, 0x09, 0xF9, 0x02, 0xFD, 0x5F, 0x90, 0x2A,
  0x85, 0x12, 0xFD, 0x5F, 0x92, 0x87, 0xAF, 0x82, 0xFD, 0x5F, 0x92, 0x87, 0x3F, 0xE2, 0xFD, 0x5F,
  0x93, 0x86, 0xCF, 0x7F, 0xD5, 0xF9, 0x38, 0x65, 0xFE, 0xFD, 0x5F, 0x94, 0x0D, 0xA8, 0x2D, 0x5F,
  0x94, 0x06, 0xA8, 0x2D, 0x5F, 0x95, 0x81, 0xEF, 0xD7, 0x77, 0x69, 0x0E, 0x71, 0x81, 0x3F, 0x87,
  0x10, 0x70, 0xD5,
  // "ņ" (U+0146)
  0x89, 0x48, 0xF2, 0x6D, 0xFB, 0x20, 0x8F, 0xAF, 0xDA, 0x81, 0xD0, 0x8A, 0x87, 0x40, 0x1E, 0xF4,
  0x8F, 0xC3, 0x84, 0xAF, 0x68, 0xF9, 0x38, 0x49, 0xF7, 0x8F, 0x73, 0x84, 0x9F, 0x78, 0xF7, 0x38,
  0x49, 0xF7, 0x8F, 0x73, 0x84, 0x9F, 0x78, 0xF7, 0x38, 0x49, 0xF7, 0x8F, 0x73, 0x84, 0x9F, 0x78,
  0xF7, 0x38, 0x49, 0xF7, 0x8F, 0x73, 0x81, 0x9F, 0x77, 0x77, 0x19, 0x0E, 0x68, 0x13, 0xF8, 0x60,
  0x70, 0xD4,
  // "Ň" (U+0147)
  0x30, 0x70, 0x22, 0x81, 0x27, 0x14, 0x84, 0x9E, 0x22, 0xE9, 0x68, 0x2D, 0xDE, 0xD7, 0x04, 0xA0,
  0x47, 0x70, 0x5A, 0x06, 0x48, 0x22, 0xFD, 0x5A, 0x0D, 0x48, 0x22, 0xFD, 0x5B, 0x05, 0x38, 0x62,
  0xFD, 0x5F, 0xEF, 0xC3, 0x87, 0x2F, 0xD5, 0xF9, 0xEF, 0x32, 0x87, 0x2F, 0xD5, 0xF9, 0x8F, 0xA2,
  0x85, 0x2F, 0xD5, 0xF9, 0x1A, 0x8A, 0x32, 0x02, 0xFD, 0x5F, 0x90, 0x9F, 0x90, 0x2F, 0xD5, 0xF9,
  0x02, 0xA8, 0x51, 0x2F, 0xD5, 0xF9, 0x28, 0x7A, 0xF8, 0x2F, 0xD5, 0xF9, 0x28, 0x73, 0xFE, 0x2F,
  0xD5, 0xF9, 0x38, 0x6C, 0xF7, 0xFD, 0x5F, 0x93, 0x86, 0x5F, 0xEF, 0xD5, 0xF9, 0x40, 0xDA, 0x82,
  0xD5, 0xF9, 0x40, 0x6A, 0x82, 0xD5, 0xF9, 0x58, 0x1E, 0xFD,
  // "ň" (U+0148)
  0x20, 0x70, 0x22, 0x81, 0x27, 0x12, 0x84, 0x9E, 0x22, 0xE9, 0x48, 0x2D, 0xDE, 0xD5, 0x04, 0xA0,
  0x47, 0x48, 0x94, 0x8F, 0x26, 0xDF, 0xB2, 0x08, 0xFA, 0xFD, 0xA8, 0x1D, 0x08, 0xA8, 0x74, 0x01,
  0xEF, 0x48, 0xFC, 0x38, 0x4A, 0xF6, 0x8F, 0x93, 0x84, 0x9F, 0x78, 0xF7, 0x38, 0x49, 0xF7, 0x8F,
  0x73, 0x84, 0x9F, 0x78, 0xF7, 0x38, 0x49, 0xF7, 0x8F, 0x73, 0x84, 0x9F, 0x78, 0xF7, 0x38, 0x49,
  0xF7, 0x8F, 0x73, 0x84, 0x9F, 0x78, 0xF7, 0x38, 0x19, 0xF7,
  // "ŉ" (U+0149)
  0x18, 0x1A, 0xF9, 0x72, 0x81, 0xCF, 0x57, 0x2A, 0x72, 0x81, 0x2F, 0xA7, 0x28, 0x91, 0x6F, 0x48,
  0xF2, 0x6D, 0xFB, 0x24, 0x83, 0x8F, 0xAF, 0xDA, 0x0D, 0x40, 0x8A, 0x84, 0x40, 0x1E, 0xF4, 0x38,
  0x18, 0xFC, 0x38, 0x1A, 0xF6, 0x38, 0x18, 0xF9, 0x38, 0x19, 0xF7, 0x38, 0x18, 0xF7, 0x38, 0x19,
  0xF7, 0x38, 0x18, 0xF7, 0x38, 0x19, 0xF7, 0x38, 0x18, 0xF7, 0x38, 0x19, 0xF7, 0x38, 0x18, 0xF7,
  0x38, 0x19, 0xF7, 0x38, 0x18, 0xF7, 0x38, 0x19, 0xF7, 0x38, 0x18, 0xF7, 0x38, 0x19, 0xF7, 0x38,
  0x18, 0xF7, 0x38, 0x19, 0xF7,
  // "Ŋ" (U+014A)
  0x05, 0xA0, 0x64, 0x82, 0x2F, 0xD5, 0xA0, 0xE4, 0x82, 0x2F, 0xD5, 0xB0, 0x63, 0x86, 0x2F, 0xD5,
  0xFD, 0xFD, 0x38, 0x72, 0xFD, 0x5F, 0x8D, 0xF6, 0x28, 0x72, 0xFD, 0x5F, 0x96, 0xFD, 0x28, 0xB2,
  0x2F, 0xD5, 0xF9, 0x0D, 0xF5, 0x02, 0xFD, 0x5F, 0x90, 0x6F, 0xD0, 0x2F, 0xD5, 0xF9, 0x28, 0x7D,
  0xF5, 0x2F, 0xD5, 0xF9, 0x28, 0x76, 0xFD, 0x2F, 0xD5, 0xF9, 0x38, 0x6D, 0xF6, 0xFD, 0x5F, 0x93,
  0x86, 0x6F, 0xDF, 0xD5, 0xF9, 0x40, 0xDA, 0x82, 0xD5, 0xF9, 0x40, 0x6A, 0x82, 0xD5, 0xF9, 0x58,
  0x4D, 0xFD, 0x5F, 0x95, 0x81, 0x6F, 0xD7, 0x18, 0x13, 0xFC, 0x71, 0x81, 0x8F, 0x96, 0x00, 0xDA,
  0x03, 0x68, 0x2D, 0xFD, 0x51,
  // "ŋ" (U+014B)
  0x89, 0x48, 0xF2, 0x6D, 0xFB, 0x20, 0x8F, 0xBF, 0xDA, 0x81, 0xD0, 0x8A, 0x87, 0x50, 0x1E, 0xF3,
  0x8F, 0xB3, 0x84, 0xAF, 0x58, 0xF9, 0x38, 0x49, 0xF7, 0x8F, 0x73, 0x84, 0x9F, 0x78, 0xF7, 0x38,
  0x49, 0xF7, 0x8F, 0x73, 0x84, 0x9F, 0x78, 0xF7, 0x38, 0x49, 0xF7, 0x8F, 0x73, 0x84, 0x9F, 0x78,
  0xF7, 0x38, 0x49, 0xF7, 0x8F, 0x73, 0x81, 0x9F, 0x76, 0x81, 0x9F, 0x76, 0x81, 0x9F, 0x76, 0x81,
  0xCF, 0x54, 0x83, 0x7D, 0xFE, 0x14, 0x82, 0x7F, 0xD4, 0x10,
  // "Ō" (U+014C)
  0x20, 0x28, 0x01, 0xC0, 0x65, 0x02, 0xD0, 0x77, 0x73, 0x85, 0x19, 0xDF, 0xEA, 0x24, 0x02, 0x0E,
  0xA8, 0x3D, 0xEF, 0xE3, 0x38, 0x2B, 0xFC, 0x12, 0x81, 0x9F, 0xD2, 0x03, 0xA0, 0x24, 0x85, 0xDF,
  0x50, 0x8F, 0xB5, 0x85, 0x7F, 0xA0, 0xBF, 0x75, 0x85, 0x4F, 0xE0, 0xDF, 0x55, 0x02, 0xA1, 0x81,
  0xDF, 0x55, 0x02, 0xA8, 0x21, 0xDF, 0x55, 0x02, 0xA8, 0x21, 0xCF, 0x55, 0x02, 0xA1, 0x81, 0xAF,
  0x75, 0x85, 0x4F, 0xE0, 0x7F, 0xB5, 0x83, 0x8F, 0xA0, 0x2A, 0x01, 0x48, 0x1D, 0xF5, 0x28, 0x2A,
  0xFC, 0x12, 0x81, 0x9F, 0xD3, 0x01, 0x0D, 0xA8, 0x3D, 0xEF, 0xE3, 0x48, 0x51, 0x8D, 0xFE, 0xA2,
  0x30,
  // "ō" (U+014D)
  0x10, 0x28, 0x01, 0xC0, 0x62, 0x02, 0xD0, 0x77, 0x48, 0x41, 0x9E, 0xFC, 0x53, 0x82, 0xCF, 0xED,
  0xA8, 0x94, 0x60, 0x7F, 0xC1, 0x04, 0xFE, 0x0C, 0xF5, 0x38, 0x1C, 0xF5, 0xA0, 0x23, 0x81, 0x9F,
  0x8A, 0x01, 0x38, 0x17, 0xF9, 0xA0, 0x13, 0x84, 0x7F, 0x9E, 0xF2, 0x38, 0x49, 0xF8, 0xBF, 0x63,
  0x89, 0x1C, 0xF4, 0x6F, 0xC1, 0x04, 0xFE, 0x28, 0x2B, 0xFE, 0xDA, 0x05, 0x38, 0x38, 0xDE, 0xC5,
  0x20,
  // "Ŏ" (U+014E)
  0x28, 0x11, 0xF5, 0x20, 0xB0, 0x96, 0x84, 0xCF, 0xDE, 0xF4, 0x68, 0x32, 0xBE, 0xD6, 0x77, 0x48,
  0x51, 0x9D, 0xFE, 0xA2, 0x40, 0x20, 0xEA, 0x83, 0xDE, 0xFE, 0x33, 0x82, 0xBF, 0xC1, 0x28, 0x19,
  0xFD, 0x20, 0x3A, 0x02, 0x48, 0x5D, 0xF5, 0x08, 0xFB, 0x58, 0x57, 0xFA, 0x0B, 0xF7, 0x58, 0x54,
  0xFE, 0x0D, 0xF5, 0x50, 0x2A, 0x18, 0x1D, 0xF5, 0x50, 0x2A, 0x82, 0x1D, 0xF5, 0x50, 0x2A, 0x82,
  0x1C, 0xF5, 0x50, 0x2A, 0x18, 0x1A, 0xF7, 0x58, 0x54, 0xFE, 0x07, 0xFB, 0x58, 0x38, 0xFA, 0x02,
  0xA0, 0x14, 0x81, 0xDF, 0x52, 0x82, 0xAF, 0xC1, 0x28, 0x19, 0xFD, 0x30, 0x10, 0xDA, 0x83, 0xDE,
  0xFE, 0x34, 0x85, 0x18, 0xDF, 0xEA, 0x23,
  // "ŏ" (U+014F)
  0x18, 0x11, 0xF5, 0x20, 0xB0, 0x93, 0x84, 0xCF, 0xDE, 0xF4, 0x38, 0x32, 0xBE, 0xD6, 0x75, 0x84,
  0x19, 0xEF, 0xC5, 0x38, 0x2C, 0xFE, 0xDA, 0x89, 0x46, 0x07, 0xFC, 0x10, 0x4F, 0xE0, 0xCF, 0x53,
  0x81, 0xCF, 0x5A, 0x02, 0x38, 0x19, 0xF8, 0xA0, 0x13, 0x81, 0x7F, 0x9A, 0x01, 0x38, 0x47, 0xF9,
  0xEF, 0x23, 0x84, 0x9F, 0x8B, 0xF6, 0x38, 0x91, 0xCF, 0x46, 0xFC, 0x10, 0x4F, 0xE2, 0x82, 0xBF,
  0xED, 0xA0, 0x53, 0x83, 0x8D, 0xEC, 0x52,
  // "Ő" (U+0150)
  0x48, 0x4A, 0xF7, 0x5F, 0xD5, 0x85, 0x1F, 0xD0, 0xBF, 0x35, 0x84, 0x8F, 0x33, 0xF7, 0x58, 0x41,
  0xE5, 0x0B, 0xA7, 0x74, 0x85, 0x19, 0xDF, 0xEA, 0x24, 0x02, 0x0E, 0xA8, 0x3D, 0xEF, 0xE3, 0x38,
  0x2B, 0xFC, 0x12, 0x81, 0x9F, 0xD2, 0x03, 0xA0, 0x24, 0x85, 0xDF, 0x50, 0x8F, 0xB5, 0x85, 0x7F,
  0xA0, 0xBF, 0x75, 0x85, 0x4F, 0xE0, 0xDF, 0x55, 0x02, 0xA1, 0x81, 0xDF, 0x55, 0x02, 0xA8, 0x21,
  0xDF, 0x55, 0x02, 0xA8, 0x21, 0xCF, 0x55, 0x02, 0xA1, 0x81, 0xAF, 0x75, 0x85, 0x4F, 0xE0, 0x7F,
  0xB5, 0x83, 0x8F, 0xA0, 0x2A, 0x01, 0x48, 0x1D, 0xF5, 0x28, 0x2A, 0xFC, 0x12, 0x81, 0x9F, 0xD3,
  0x01, 0x0D, 0xA8, 0x3D, 0xEF, 0xE3, 0x48, 0x51, 0x8D, 0xFE, 0xA2, 0x30,
  // "ő" (U+0151)
  0x38, 0x4A, 0xF7, 0x5F, 0xD2, 0x85, 0x1F, 0xD0, 0xBF, 0x32, 0x84, 0x8F, 0x33, 0xF7, 0x28, 0x41,
  0xE5, 0x0B, 0xA7, 0x58, 0x41, 0x9E, 0xFC, 0x53, 0x82, 0xCF, 0xED, 0xA8, 0x94, 0x60, 0x7F, 0xC1,
  0x04, 0xFE, 0x0C, 0xF5, 0x38, 0x1C, 0xF5, 0xA0, 0x23, 0x81, 0x9F, 0x8A, 0x01, 0x38, 0x17, 0xF9,
  0xA0, 0x13, 0x84, 0x7F, 0x9E, 0xF2, 0x38, 0x49, 0xF8, 0xBF, 0x63, 0x89, 0x1C, 0xF4, 0x6F, 0xC1,
  0x04, 0xFE, 0x28, 0x2B, 0xFE, 0xDA, 0x05, 0x38, 0x38, 0xDE, 0xC5, 0x20,
  // "Œ" (U+0152)
  0x30, 0x80, 0xDF, 0x98, 0x2A, 0x01, 0xDA, 0x00, 0xDA, 0x80, 0x0C, 0x86, 0x80, 0xAF, 0xC1, 0x01,
  0xA5, 0x02, 0xA0, 0x22, 0x01, 0xA5, 0x81, 0x7F, 0xB3, 0x01, 0xA5, 0x81, 0xAF, 0x73, 0x01, 0xA5,
  0x81, 0xCF, 0x53, 0x01, 0xA5, 0x81, 0xDF, 0x53, 0x01, 0xE8, 0x26, 0xDF, 0x53, 0x01, 0xA8, 0x00,
  0xC8, 0x25, 0xCF, 0x53, 0x01, 0xA5, 0x81, 0xAF, 0x73, 0x01, 0xA5, 0x81, 0x7F, 0xB3, 0x01, 0xA5,
  0x02, 0xA0, 0x22, 0x01, 0xA6, 0x84, 0xAF, 0xC2, 0x01, 0xA6, 0x01, 0x0D, 0xA0, 0x0D, 0xA8, 0x00,
  0xC0, 0x82, 0x82, 0x17, 0xCE, 0xF0, 0xA0,
  // "œ" (U+0153)
  0x18, 0x92, 0x19, 0xEE, 0xB3, 0x03, 0xBE, 0xD6, 0x38, 0x90, 0xDF, 0xED, 0xFE, 0x4E, 0xFD, 0xA8,
  0x37, 0x07, 0xFC, 0x20, 0x5B, 0x87, 0x40, 0x3E, 0xE0, 0xCF, 0x53, 0x81, 0xDF, 0xC3, 0x81, 0xAF,
  0x4A, 0x02, 0x38, 0x19, 0xF9, 0x38, 0x17, 0xF7, 0xA4, 0x08, 0xF0, 0x8A, 0x01, 0x38, 0x18, 0xFE,
  0x80, 0x1C, 0x82, 0x7E, 0xF2, 0x38, 0x19, 0xF9, 0x68, 0x1B, 0xF5, 0x38, 0x1C, 0xFC, 0x68, 0x46,
  0xFC, 0x10, 0x5B, 0x07, 0x30, 0x52, 0x82, 0xCF, 0xED, 0xA8, 0x34, 0xEF, 0xED, 0xA8, 0x95, 0x10,
  0x19, 0xEE, 0xB3, 0x02, 0xAE, 0xEC, 0x71,
  // "Ŕ" (U+0154)
  0x48, 0x13, 0x77, 0x78, 0x1C, 0xF8, 0x68, 0x15, 0xFA, 0x68, 0x11, 0xEB, 0x77, 0x10, 0x5B, 0x81,
  0xEC, 0x83, 0x83, 0x5F, 0xEC, 0xEA, 0x0C, 0x28, 0x15, 0xFC, 0x28, 0x63, 0xEF, 0x60, 0x5F, 0xC3,
  0x85, 0x8F, 0xB0, 0x5F, 0xC3, 0x85, 0x6F, 0xC0, 0x5F, 0xC3, 0x85, 0x6F, 0xB0, 0x5F, 0xC3, 0x89,
  0x0A, 0xF9, 0x05, 0xFC, 0x01, 0x7A, 0x81, 0x30, 0x5E, 0x06, 0x28, 0x55, 0xFE, 0xCE, 0xF8, 0x38,
  0x65, 0xFC, 0x03, 0xFE, 0x12, 0x81, 0x5F, 0xC2, 0x81, 0xBF, 0x72, 0x81, 0x5F, 0xC2, 0x86, 0x4F,
  0xE1, 0x05, 0xFC, 0x38, 0x5C, 0xF7, 0x05, 0xFC, 0x38, 0x55, 0xFE, 0x15, 0xFC, 0x48, 0x1D, 0xF7,
  // "ŕ" (U+0155)
  0x38, 0x13, 0x77, 0x38, 0x1C, 0xF8, 0x28, 0x15, 0xFA, 0x28, 0x11, 0xEB, 0x71, 0x89, 0x38, 0xF2,
  0x5D, 0xE8, 0xF8, 0xFE, 0xD8, 0xA0, 0x82, 0x81, 0x8F, 0xE3, 0x81, 0x8F, 0x93, 0x81, 0x8F, 0x83,
  0x81, 0x8F, 0x73, 0x81, 0x8F, 0x73, 0x81, 0x8F, 0x73, 0x81, 0x8F, 0x73, 0x81, 0x8F, 0x73, 0x81,
  0x8F, 0x73,
  // "Ŗ" (U+0156)
  0x05, 0xB8, 0x1E, 0xC8, 0x38, 0x35, 0xFE, 0xCE, 0xA0, 0xC2, 0x81, 0x5F, 0xC2, 0x86, 0x3E, 0xF6,
  0x05, 0xFC, 0x38, 0x58, 0xFB, 0x05, 0xFC, 0x38, 0x56, 0xFC, 0x05, 0xFC, 0x38, 0x56, 0xFB, 0x05,
  0xFC, 0x38, 0x90, 0xAF, 0x90, 0x5F, 0xC0, 0x17, 0xA8, 0x13, 0x05, 0xE0, 0x62, 0x85, 0x5F, 0xEC,
  0xEF, 0x83, 0x86, 0x5F, 0xC0, 0x3F, 0xE1, 0x28, 0x15, 0xFC, 0x28, 0x1B, 0xF7, 0x28, 0x15, 0xFC,
  0x28, 0x64, 0xFE, 0x10, 0x5F, 0xC3, 0x85, 0xCF, 0x70, 0x5F, 0xC3, 0x85, 0x5F, 0xE1, 0x5F, 0xC4,
  0x81, 0xDF, 0x77, 0x77, 0x39, 0x0E, 0x78, 0x13, 0xF8, 0x70, 0x70, 0xD5,
  // "ŗ" (U+0157)
  0x89, 0x38, 0xF2, 0x5D, 0xE8, 0xF8, 0xFE, 0xD8, 0xA0, 0x82, 0x81, 0x8F, 0xE3, 0x81, 0x8F, 0x93,
  0x81, 0x8F, 0x83, 0x81, 0x8F, 0x73, 0x81, 0x8F, 0x73, 0x81, 0x8F, 0x73, 0x81, 0x8F, 0x73, 0x81,
  0x8F, 0x73, 0x81, 0x8F, 0x77, 0x72, 0x90, 0xE3, 0x81, 0x3F, 0x83, 0x07, 0x0D, 0x40,
  // "Ř" (U+0158)
  0x20, 0x70, 0x22, 0x81, 0x27, 0x13, 0x84, 0x9E, 0x22, 0xE9, 0x58, 0x2D, 0xDE, 0xD6, 0x04, 0xA0,
  0x47, 0x60, 0x5B, 0x81, 0xEC, 0x83, 0x83, 0x5F, 0xEC, 0xEA, 0x0C, 0x28, 0x15, 0xFC, 0x28, 0x63,
  0xEF, 0x60, 0x5F, 0xC3, 0x85, 0x8F, 0xB0, 0x5F, 0xC3, 0x85, 0x6F, 0xC0, 0x5F, 0xC3, 0x85, 0x6F,
  0xB0, 0x5F, 0xC3, 0x89, 0x0A, 0xF9, 0x05, 0xFC, 0x01, 0x7A, 0x81, 0x30, 0x5E, 0x06, 0x28, 0x55,
  0xFE, 0xCE, 0xF8, 0x38, 0x65, 0xFC, 0x03, 0xFE, 0x12, 0x81, 0x5F, 0xC2, 0x81, 0xBF, 0x72, 0x81,
  0x5F, 0xC2, 0x86, 0x4F, 0xE1, 0x05, 0xFC, 0x38, 0x5C, 0xF7, 0x05, 0xFC, 0x38, 0x55, 0xFE, 0x15,
  0xFC, 0x48, 0x1D, 0xF7,
  // "ř" (U+0159)
  0x07, 0x02, 0x28, 0x72, 0x71, 0x9E, 0x22, 0xE9, 0x28, 0x2D, 0xDE, 0xD3, 0x04, 0xA0, 0x47, 0x28,
  0x95, 0x8F, 0x25, 0xDE, 0x08, 0xF8, 0xFE, 0xD0, 0x8A, 0x08, 0x38, 0x18, 0xFE, 0x48, 0x18, 0xF9,
  0x48, 0x18, 0xF8, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48, 0x18, 0xF7, 0x48,
  0x18, 0xF7, 0x48, 0x18, 0xF7, 0x40,
  // "Ś" (U+015A)
  0x58, 0x13, 0x77, 0x68, 0x1C, 0xF8, 0x58, 0x15, 0xFA, 0x58, 0x11, 0xEB, 0x77, 0x89, 0x32, 0xAE,
  0xED, 0x93, 0x02, 0xEF, 0xED, 0xA8, 0x36, 0x0A, 0xFA, 0x38, 0x46, 0x10, 0xEF, 0x36, 0xA0, 0x36,
  0x81, 0xDF, 0x96, 0x07, 0xA0, 0xB0, 0x25, 0x0B, 0xB0, 0x85, 0x06, 0x0E, 0xA0, 0xB5, 0x01, 0x0A,
  0xA0, 0x66, 0x81, 0xAF, 0xB6, 0x81, 0x6F, 0xC6, 0x84, 0x7F, 0xB1, 0x82, 0x28, 0x32, 0xDF, 0x62,
  0xA0, 0xE0, 0xDA, 0x0B, 0x28, 0x48, 0xCE, 0xFD, 0x72,
  // "ś" (U+015B)
  0x48, 0x13, 0x77, 0x58, 0x1C, 0xF8, 0x48, 0x15, 0xFA, 0x48, 0x11, 0xEB, 0x75, 0x89, 0x21, 0x8D,
  0xED, 0x81, 0x0B, 0xFE, 0xDA, 0x89, 0x22, 0x1F, 0xE1, 0x01, 0x60, 0x2F, 0xD6, 0x82, 0xDF, 0xA1,
  0x48, 0x33, 0xEF, 0xE7, 0x40, 0x10, 0xAA, 0x0A, 0x58, 0x24, 0xEF, 0x45, 0x83, 0x9F, 0x62, 0x53,
  0x82, 0xCF, 0x43, 0xA8, 0x92, 0xDE, 0xFD, 0x01, 0x9D, 0xFD, 0xA2, 0x10,
  // "Ŝ" (U+015C)
  0x38, 0x21, 0x77, 0x15, 0x09, 0xA0, 0x94, 0x84, 0x4F, 0x89, 0xF4, 0x30, 0xD0, 0x92, 0x81, 0x9E,
  0x17, 0x48, 0x93, 0x2A, 0xEE, 0xD9, 0x30, 0x2E, 0xFE, 0xDA, 0x83, 0x60, 0xAF, 0xA3, 0x84, 0x61,
  0x0E, 0xF3, 0x6A, 0x03, 0x68, 0x1D, 0xF9, 0x60, 0x7A, 0x0B, 0x02, 0x50, 0xBB, 0x08, 0x50, 0x60,
  0xEA, 0x0B, 0x50, 0x10, 0xAA, 0x06, 0x68, 0x1A, 0xFB, 0x68, 0x16, 0xFC, 0x68, 0x47, 0xFB, 0x18,
  0x22, 0x83, 0x2D, 0xF6, 0x2A, 0x0E, 0x0D, 0xA0, 0xB2, 0x84, 0x8C, 0xEF, 0xD7, 0x20,
  // "ŝ" (U+015D)
  0x28, 0x21, 0x77, 0x14, 0x09, 0xA0, 0x93, 0x84, 0x4F, 0x89, 0xF4, 0x20, 0xD0, 0x92, 0x81, 0x9E,
  0x17, 0x28, 0x92, 0x18, 0xDE, 0xD8, 0x10, 0xBF, 0xED, 0xA8, 0x92, 0x21, 0xFE, 0x10, 0x16, 0x02,
  0xFD, 0x68, 0x2D, 0xFA, 0x14, 0x83, 0x3E, 0xFE, 0x74, 0x01, 0x0A, 0xA0, 0xA5, 0x82, 0x4E, 0xF4,
  0x58, 0x39, 0xF6, 0x25, 0x38, 0x2C, 0xF4, 0x3A, 0x89, 0x2D, 0xEF, 0xD0, 0x19, 0xDF, 0xDA, 0x21,
  // "Ş" (U+015E)
  0x28, 0x93, 0x2A, 0xEE, 0xD9, 0x30, 0x2E, 0xFE, 0xDA, 0x83, 0x60, 0xAF, 0xA3, 0x84, 0x61, 0x0E,
  0xF3, 0x6A, 0x03, 0x68, 0x1D, 0xF9, 0x60, 0x7A, 0x0B, 0x02, 0x50, 0xBB, 0x08, 0x50, 0x60, 0xEA,
  0x0B, 0x50, 0x10, 0xAA, 0x06, 0x68, 0x1A, 0xFB, 0x68, 0x16, 0xFC, 0x68, 0x47, 0xFB, 0x18, 0x22,
  0x83, 0x2D, 0xF6, 0x2A, 0x0E, 0x0D, 0xA0, 0xB2, 0x84, 0x8C, 0xEF, 0xD7, 0x60, 0x80, 0x56, 0x82,
  0x1D, 0xD4, 0x70, 0xC0, 0xE5, 0x82, 0x99, 0xFE, 0x50, 0xEA, 0x06, 0x58, 0x12, 0x31, 0x30,
  // "ş" (U+015F)
  0x18, 0x92, 0x18, 0xDE, 0xD8, 0x10, 0xBF, 0xED, 0xA8, 0x92, 0x21, 0xFE, 0x10, 0x16, 0x02, 0xFD,
  0x68, 0x2D, 0xFA, 0x14, 0x83, 0x3E, 0xFE, 0x74, 0x01, 0x0A, 0xA0, 0xA5, 0x82, 0x4E, 0xF4, 0x58,
  0x39, 0xF6, 0x25, 0x38, 0x2C, 0xF4, 0x3A, 0x89, 0x2D, 0xEF, 0xD0, 0x19, 0xDF, 0xDA, 0x24, 0x08,
  0x05, 0x58, 0x21, 0xDD, 0x46, 0x0C, 0x0E, 0x48, 0x29, 0x9F, 0xE4, 0x0E, 0xA0, 0x64, 0x81, 0x23,
  0x13,
  // "Š" (U+0160)
  0x20, 0x70, 0x22, 0x81, 0x27, 0x12, 0x84, 0x9E, 0x22, 0xE9, 0x48, 0x2D, 0xDE, 0xD5, 0x04, 0xA0,
  0x47, 0x68, 0x93, 0x2A, 0xEE, 0xD9, 0x30, 0x2E, 0xFE, 0xDA, 0x83, 0x60, 0xAF, 0xA3, 0x84, 0x61,
  0x0E, 0xF3, 0x6A, 0x03, 0x68, 0x1D, 0xF9, 0x60, 0x7A, 0x0B, 0x02, 0x50, 0xBB, 0x08, 0x50, 0x60,
  0xEA, 0x0B, 0x50, 0x10, 0xAA, 0x06, 0x68, 0x1A, 0xFB, 0x68, 0x16, 0xFC, 0x68, 0x47, 0xFB, 0x18,
  0x22, 0x83, 0x2D, 0xF6, 0x2A, 0x0E, 0x0D, 0xA0, 0xB2, 0x84, 0x8C, 0xEF, 0xD7, 0x20,
  // "š" (U+0161)
  0x10, 0x70, 0x22, 0x89, 0x02, 0x71, 0x09, 0xE2, 0x2E, 0x93, 0x82, 0xDD, 0xED, 0x40, 0x4A, 0x04,
  0x74, 0x89, 0x21, 0x8D, 0xED, 0x81, 0x0B, 0xFE, 0xDA, 0x89, 0x22, 0x1F, 0xE1, 0x01, 0x60, 0x2F,
  0xD6, 0x82, 0xDF, 0xA1, 0x48, 0x33, 0xEF, 0xE7, 0x40, 0x10, 0xAA, 0x0A, 0x58, 0x24, 0xEF, 0x45,
  0x83, 0x9F, 0x62, 0x53, 0x82, 0xCF, 0x43, 0xA8, 0x92, 0xDE, 0xFD, 0x01, 0x9D, 0xFD, 0xA2, 0x10,
  // "Ţ" (U+0162)
  0x0B, 0xF9, 0x89, 0x11, 0x9C, 0xCD, 0xFE, 0xCC, 0xC1, 0x38, 0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78,
  0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16,
  0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16, 0xFB,
  0x78, 0x16, 0xFB, 0x71, 0x08, 0x05, 0x78, 0x21, 0xDD, 0x47, 0x10, 0xC0, 0xE6, 0x82, 0x99, 0xFE,
  0x60, 0xEA, 0x06, 0x68, 0x12, 0x31, 0x40,
  // "ţ" (U+0163)
  0x20, 0x60, 0x55, 0x0E, 0x09, 0x48, 0x13, 0xF9, 0x30, 0x40, 0xDC, 0x18, 0x48, 0xEF, 0xEC, 0xC2,
  0x81, 0x7F, 0x94, 0x81, 0x7F, 0x94, 0x81, 0x7F, 0x94, 0x81, 0x7F, 0x94, 0x81, 0x7F, 0x94, 0x81,
  0x7F, 0x94, 0x81, 0x6F, 0xA4, 0x81, 0x5F, 0xD4, 0x01, 0xA8, 0x1D, 0xE1, 0x28, 0x25, 0xDF, 0xC4,
  0x08, 0x05, 0x48, 0x21, 0xDD, 0x45, 0x0C, 0x0E, 0x38, 0x29, 0x9F, 0xE3, 0x0E, 0xA0, 0x63, 0x81,
  0x23, 0x12,
  // "Ť" (U+0164)
  0x20, 0x70, 0x22, 0x81, 0x27, 0x13, 0x84, 0x9E, 0x22, 0xE9, 0x58, 0x2D, 0xDE, 0xD6, 0x04, 0xA0,
  0x47, 0x60, 0xBF, 0x98, 0x91, 0x19, 0xCC, 0xDF, 0xEC, 0xCC, 0x13, 0x81, 0x6F, 0xB7, 0x81, 0x6F,
  0xB7, 0x81, 0x6F, 0xB7, 0x81, 0x6F, 0xB7, 0x81, 0x6F, 0xB7, 0x81, 0x6F, 0xB7, 0x81, 0x6F, 0xB7,
  0x81, 0x6F, 0xB7, 0x81, 0x6F, 0xB7, 0x81, 0x6F, 0xB7, 0x81, 0x6F, 0xB7, 0x81, 0x6F, 0xB7, 0x81,
  0x6F, 0xB7, 0x81, 0x6F, 0xB4,
  // "ť" (U+0165)
  0x79, 0x0E, 0x20, 0x60, 0x52, 0x81, 0x2F, 0x92, 0x0E, 0x09, 0x28, 0x56, 0xE1, 0x03, 0xF9, 0x50,
  0x40, 0xDC, 0x38, 0x48, 0xEF, 0xEC, 0xC4, 0x81, 0x7F, 0x96, 0x81, 0x7F, 0x96, 0x81, 0x7F, 0x96,
  0x81, 0x7F, 0x96, 0x81, 0x7F, 0x96, 0x81, 0x7F, 0x96, 0x81, 0x6F, 0xA6, 0x81, 0x5F, 0xD6, 0x01,
  0xA8, 0x1D, 0xE1, 0x48, 0x25, 0xDF, 0xC3,
  // "Ŧ" (U+0166)
  0x0B, 0xF9, 0x89, 0x11, 0x9C, 0xCD, 0xFE, 0xCC, 0xC1, 0x38, 0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78,
  0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16, 0xFB, 0x58, 0x59, 0xCD, 0xFE, 0xCC, 0x30, 0xBE, 0x58,
  0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16, 0xFB, 0x78, 0x16,
  0xFB, 0x78, 0x16, 0xFB, 0x40,
  // "ŧ" (U+0167)
  0x20, 0x60, 0x55, 0x0E, 0x09, 0x48, 0x13, 0xF9, 0x30, 0x40, 0xDC, 0x18, 0x48, 0xEF, 0xEC, 0xC2,
  0x81, 0x7F, 0x94, 0x81, 0x7F, 0x93, 0x86, 0x7E, 0xFE, 0xCA, 0x09, 0xC0, 0xC2, 0x81, 0x7F, 0x94,
  0x81, 0x7F, 0x94, 0x81, 0x6F, 0xA4, 0x81, 0x5F, 0xD4, 0x01, 0xA8, 0x1D, 0xE1, 0x28, 0x25, 0xDF,
  0xC1,
  // "Ũ" (U+0168)
  0x28, 0x54, 0xED, 0x40, 0xA9, 0x38, 0x5C, 0xEE, 0xFD, 0xF6, 0x28, 0x51, 0xF2, 0x19, 0xEB, 0x75,
  0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA,
  0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8,
  0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4,
  0x02, 0xA8, 0x16, 0xFB, 0x48, 0x43, 0xFE, 0x4F, 0xE4, 0x85, 0x6F, 0xB0, 0xEF, 0x82, 0x84, 0x2D,
  0xF6, 0x05, 0xA0, 0xE0, 0xDA, 0x0C, 0x38, 0x44, 0xBE, 0xFD, 0x82,
  // "ũ" (U+0169)
  0x18, 0x54, 0xED, 0x40, 0xA9, 0x28, 0x95, 0xCE, 0xEF, 0xDF, 0x60, 0x1F, 0x21, 0x9E, 0xB7, 0x48,
  0x19, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73,
  0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6,
  0x9F, 0x73, 0x84, 0xBF, 0x68, 0xF8, 0x38, 0x4E, 0xF6, 0x6F, 0xD2, 0x04, 0xA8, 0xA1, 0x60, 0xEF,
  0xCB, 0xFC, 0xF6, 0x04, 0xCF, 0xD6, 0x4F, 0x60,
  // "Ū" (U+016A)
  0x20, 0x28, 0x01, 0xC0, 0x63, 0x02, 0xD0, 0x77, 0x48, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4,
  0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81,
  0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40,
  0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x6F, 0xB4, 0x84, 0x3F, 0xE4,
  0xFE, 0x48, 0x56, 0xFB, 0x0E, 0xF8, 0x28, 0x42, 0xDF, 0x60, 0x5A, 0x0E, 0x0D, 0xA0, 0xC3, 0x84,
  0x4B, 0xEF, 0xD8, 0x20,
  // "ū" (U+016B)
  0x10, 0x28, 0x01, 0xC0, 0x62, 0x02, 0xD0, 0x77, 0x38, 0x19, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73,
  0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6,
  0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xBF, 0x68, 0xF8, 0x38,
  0x4E, 0xF6, 0x6F, 0xD2, 0x04, 0xA8, 0xA1, 0x60, 0xEF, 0xCB, 0xFC, 0xF6, 0x04, 0xCF, 0xD6, 0x4F,
  0x60,
  // "Ŭ" (U+016C)
  0x18, 0x11, 0xF5, 0x20, 0xB0, 0x94, 0x84, 0xCF, 0xDE, 0xF4, 0x48, 0x32, 0xBE, 0xD6, 0x76, 0x81,
  0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40,
  0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17,
  0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02,
  0xA8, 0x16, 0xFB, 0x48, 0x43, 0xFE, 0x4F, 0xE4, 0x85, 0x6F, 0xB0, 0xEF, 0x82, 0x84, 0x2D, 0xF6,
  0x05, 0xA0, 0xE0, 0xDA, 0x0C, 0x38, 0x44, 0xBE, 0xFD, 0x82,
  // "ŭ" (U+016D)
  0x18, 0x11, 0xF5, 0x20, 0xB0, 0x93, 0x84, 0xCF, 0xDE, 0xF4, 0x38, 0x32, 0xBE, 0xD6, 0x74, 0x81,
  0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38,
  0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69,
  0xF7, 0x38, 0x4B, 0xF6, 0x8F, 0x83, 0x84, 0xEF, 0x66, 0xFD, 0x20, 0x4A, 0x8A, 0x16, 0x0E, 0xFC,
  0xBF, 0xCF, 0x60, 0x4C, 0xFD, 0x64, 0xF6,
  // "Ů" (U+016E)
  0x38, 0x24, 0xDE, 0x76, 0x83, 0xE6, 0x2E, 0x34, 0x84, 0x1F, 0x10, 0xC6, 0x58, 0x3E, 0x52, 0xE3,
  0x58, 0x24, 0xDE, 0x87, 0x68, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA,
  0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8,
  0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4,
  0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x6F, 0xB4, 0x84, 0x3F, 0xE4, 0xFE, 0x48, 0x56, 0xFB,
  0x0E, 0xF8, 0x28, 0x42, 0xDF, 0x60, 0x5A, 0x0E, 0x0D, 0xA0, 0xC3, 0x84, 0x4B, 0xEF, 0xD8, 0x20,
  // "ů" (U+016F)
  0x28, 0x24, 0xDE, 0x75, 0x83, 0xE6, 0x2E, 0x33, 0x84, 0x1F, 0x10, 0xC6, 0x48, 0x3E, 0x52, 0xE3,
  0x48, 0x24, 0xDE, 0x87, 0x58, 0x19, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7,
  0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF,
  0x69, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xBF, 0x68, 0xF8, 0x38, 0x4E, 0xF6, 0x6F, 0xD2,
  0x04, 0xA8, 0xA1, 0x60, 0xEF, 0xCB, 0xFC, 0xF6, 0x04, 0xCF, 0xD6, 0x4F, 0x60,
  // "Ű" (U+0170)
  0x48, 0x4A, 0xF7, 0x5F, 0xD3, 0x85, 0x1F, 0xD0, 0xBF, 0x33, 0x84, 0x8F, 0x33, 0xF7, 0x38, 0x41,
  0xE5, 0x0B, 0xA7, 0x58, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40,
  0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17,
  0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02,
  0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x6F, 0xB4, 0x84, 0x3F, 0xE4, 0xFE, 0x48, 0x56, 0xFB, 0x0E,
  0xF8, 0x28, 0x42, 0xDF, 0x60, 0x5A, 0x0E, 0x0D, 0xA0, 0xC3, 0x84, 0x4B, 0xEF, 0xD8, 0x20,
  // "ű" (U+0171)
  0x38, 0x4A, 0xF7, 0x5F, 0xD2, 0x85, 0x1F, 0xD0, 0xBF, 0x32, 0x84, 0x8F, 0x33, 0xF7, 0x28, 0x41,
  0xE5, 0x0B, 0xA7, 0x48, 0x19, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38,
  0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69,
  0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xBF, 0x68, 0xF8, 0x38, 0x4E, 0xF6, 0x6F, 0xD2, 0x04,
  0xA8, 0xA1, 0x60, 0xEF, 0xCB, 0xFC, 0xF6, 0x04, 0xCF, 0xD6, 0x4F, 0x60,
  // "Ų" (U+0172)
  0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA,
  0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8,
  0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4, 0x02, 0xA8, 0x17, 0xFA, 0x40, 0x2A, 0x81, 0x7F, 0xA4,
  0x02, 0xA8, 0x16, 0xFB, 0x48, 0x43, 0xFE, 0x4F, 0xE4, 0x85, 0x6F, 0xB0, 0xEF, 0x82, 0x84, 0x2D,
  0xF6, 0x05, 0xA0, 0xE0, 0xDA, 0x0B, 0x38, 0x14, 0xBE, 0xA0, 0xC7, 0x81, 0x3E, 0x27, 0x0C, 0x0A,
  0x71, 0x90, 0xA7, 0x18, 0x2E, 0xFD, 0x56, 0x82, 0x5E, 0xE4, 0x10,
  // "ų" (U+0173)
  0x81, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7,
  0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF, 0x69, 0xF7, 0x38, 0x4A, 0xF6, 0x9F, 0x73, 0x84, 0xAF,
  0x69, 0xF7, 0x38, 0x4B, 0xF6, 0x8F, 0x83, 0x84, 0xEF, 0x66, 0xFD, 0x20, 0x4A, 0x8A, 0x16, 0x0E,
  0xFC, 0xBF, 0xCF, 0x60, 0x4C, 0xFD, 0x6A, 0xF6, 0x58, 0x14, 0xE2, 0x60, 0xD0, 0x96, 0x81, 0x1F,
  0x97, 0xA0, 0xD0, 0x25, 0x82, 0x6E, 0xE2,
  // "Ŵ" (U+0174)
  0x68, 0x21, 0x77, 0x17, 0x60, 0x9A, 0x09, 0x75, 0x84, 0x4F, 0x89, 0xF4, 0x74, 0x0D, 0x09, 0x28,
  0x19, 0xE1, 0x77, 0x71, 0x81, 0xCF, 0x54, 0x81, 0xBF, 0x74, 0x84, 0x9F, 0x89, 0xF8, 0x48, 0x1E,
  0xFA, 0x48, 0x4C, 0xF4, 0x5F, 0xB3, 0x02, 0xA0, 0xD4, 0xA8, 0x21, 0x2F, 0xE3, 0x83, 0x5F, 0xEF,
  0x12, 0x81, 0x3F, 0xD2, 0x81, 0xEF, 0x22, 0x83, 0x9F, 0xAF, 0x42, 0x81, 0x6F, 0xA2, 0x81, 0xBF,
  0x52, 0x83, 0xCF, 0x5F, 0x82, 0x81, 0x9F, 0x72, 0x81, 0x8F, 0x82, 0x98, 0x2C, 0x2F, 0xB2, 0x81,
  0xCF, 0x42, 0x89, 0x05, 0xFB, 0x03, 0xF9, 0x0E, 0xE2, 0xA0, 0x12, 0x89, 0x42, 0xFE, 0x06, 0xF6,
  0x0B, 0xF2, 0x3F, 0xD4, 0x89, 0x3E, 0xF1, 0x9F, 0x30, 0x7F, 0x56, 0xFA, 0x48, 0x2B, 0xF4, 0xC9,
  0x28, 0x44, 0xF8, 0x9F, 0x74, 0x83, 0x7F, 0x7F, 0xC2, 0x84, 0x1F, 0xAB, 0xF3, 0x48, 0x34, 0xFB,
  0xF8, 0x30, 0xFD, 0x95, 0x01, 0xB0, 0x53, 0x09, 0xA0, 0xD6, 0x0D, 0xA0, 0x23, 0x06, 0xA0, 0x96,
  0x81, 0xAF, 0xE4, 0x03, 0xA0, 0x63,
  // "ŵ" (U+0175)
  0x58, 0x21, 0x77, 0x17, 0x30, 0x9A, 0x09, 0x72, 0x84, 0x4F, 0x89, 0xF4, 0x71, 0x0D, 0x09, 0x28,
  0x19, 0xE1, 0x77, 0x38, 0x1B, 0xF5, 0x20, 0x1A, 0x06, 0x3A, 0x81, 0x7F, 0x82, 0x04, 0xA0, 0xA2,
  0x84, 0x3F, 0xC4, 0xFC, 0x28, 0x28, 0xFD, 0xD2, 0x84, 0x6F, 0x80, 0xFE, 0x28, 0xC2, 0xBE, 0x9F,
  0x10, 0x9F, 0x50, 0xCF, 0x20, 0xEB, 0x7F, 0x40, 0xDF, 0x10, 0x9F, 0x53, 0xF8, 0x3F, 0x70, 0xFD,
  0x28, 0x92, 0x6F, 0x86, 0xF5, 0x0F, 0xA3, 0xFA, 0x28, 0x92, 0x2F, 0xB8, 0xF1, 0x0D, 0xD6, 0xF7,
  0x38, 0x2E, 0xDB, 0xE2, 0x83, 0x9F, 0x9F, 0x33, 0x82, 0xBF, 0xEA, 0x28, 0x16, 0xFE, 0x94, 0x08,
  0xA0, 0x72, 0x03, 0xA0, 0xC4, 0x04, 0xA0, 0x43, 0xA0, 0x82,
  // "Ŷ" (U+0176)
  0x38, 0x21, 0x77, 0x16, 0x09, 0xA0, 0x95, 0x84, 0x4F, 0x89, 0xF4, 0x40, 0xD0, 0x92, 0x81, 0x9E,
  0x17, 0x48, 0x1C, 0xF7, 0x48, 0x4A, 0xF9, 0x6F, 0xD3, 0x01, 0xA0, 0x30, 0x1A, 0x03, 0x28, 0x16,
  0xFC, 0x28, 0x1A, 0xF9, 0x28, 0x1C, 0xF6, 0x28, 0x34, 0xFE, 0x02, 0xA0, 0x13, 0x84, 0xDF, 0x58,
  0xFA, 0x48, 0x47, 0xFC, 0xEF, 0x44, 0x01, 0xB0, 0xD6, 0x0B, 0xA0, 0x76, 0x05, 0xA0, 0x16, 0x02,
  0xA7, 0x02, 0xA7, 0x02, 0xA7, 0x02, 0xA7, 0x02, 0xA7, 0x02, 0xA4,
  // "ŷ" (U+0177)
  0x38, 0x21, 0x77, 0x15, 0x09, 0xA0, 0x94, 0x84, 0x4F, 0x89, 0xF4, 0x30, 0xD0, 0x92, 0x81, 0x9E,
  0x17, 0x28, 0x1C, 0xF5, 0x38, 0x44, 0xFD, 0x7F, 0xA3, 0x84, 0x8F, 0x93, 0xFE, 0x38, 0x5C, 0xF4,
  0x0D, 0xF2, 0x2A, 0x28, 0x59, 0xF7, 0x04, 0xFB, 0x28, 0x54, 0xFB, 0x08, 0xF7, 0x38, 0x4E, 0xE0,
  0xCF, 0x23, 0x83, 0xAF, 0x4F, 0xD4, 0x83, 0x6F, 0xAF, 0x94, 0x01, 0xB0, 0x55, 0x0C, 0xA0, 0x15,
  0x81, 0x8F, 0xB6, 0x81, 0xAF, 0x76, 0x81, 0xEF, 0x25, 0x81, 0x7F, 0xC4, 0x08, 0x0E, 0xA0, 0x44,
  0x82, 0x8F, 0xD5, 0x50,
  // "Ÿ" (U+0178)
  0x18, 0x51, 0xB7, 0x04, 0xB3, 0x38, 0x52, 0xD9, 0x06, 0xE4, 0x77, 0x71, 0x81, 0xCF, 0x74, 0x84,
  0xAF, 0x96, 0xFD, 0x30, 0x1A, 0x03, 0x01, 0xA0, 0x32, 0x81, 0x6F, 0xC2, 0x81, 0xAF, 0x92, 0x81,
  0xCF, 0x62, 0x83, 0x4F, 0xE0, 0x2A, 0x01, 0x38, 0x4D, 0xF5, 0x8F, 0xA4, 0x84, 0x7F, 0xCE, 0xF4,
  0x40, 0x1B, 0x0D, 0x60, 0xBA, 0x07, 0x60, 0x5A, 0x01, 0x60, 0x2A, 0x70, 0x2A, 0x70, 0x2A, 0x70,
  0x2A, 0x70, 0x2A, 0x70, 0x2A, 0x40,
  // "Ź" (U+0179)
  0x58, 0x13, 0x77, 0x68, 0x1C, 0xF8, 0x58, 0x15, 0xFA, 0x58, 0x11, 0xEB, 0x75, 0x04, 0xF0, 0x80,
  0x38, 0x01, 0xCA, 0x07, 0x50, 0x2A, 0x02, 0x58, 0x19, 0xFA, 0x58, 0x21, 0xEF, 0x35, 0x81, 0x7F,
  0xC6, 0x81, 0xDF, 0x55, 0x81, 0x5F, 0xD6, 0x81, 0xCF, 0x75, 0x82, 0x3F, 0xE1, 0x58, 0x1A, 0xF9,
  0x50, 0x1A, 0x02, 0x58, 0x18, 0xFA, 0x68, 0x1E, 0xF4, 0x50, 0x5A, 0x80, 0x1C, 0x08, 0x06, 0xF0,
  0xA0,
  // "ź" (U+017A)
  0x48, 0x13, 0x77, 0x58, 0x1C, 0xF8, 0x48, 0x15, 0xFA, 0x48, 0x11, 0xEB, 0x74, 0x02, 0xE1, 0x85,
  0x2C, 0xCC, 0xDF, 0xE5, 0x81, 0x9F, 0x84, 0x01, 0xA0, 0x14, 0x81, 0x8F, 0x94, 0x82, 0x1E, 0xF2,
  0x48, 0x17, 0xFA, 0x58, 0x1E, 0xF3, 0x48, 0x17, 0xFB, 0x58, 0x1D, 0xF3, 0x40, 0x5A, 0x80, 0x0C,
  0x02, 0x06, 0xE0, 0x20,
  // "Ż" (U+017B)
  0x40, 0x0A, 0x60, 0x1A, 0x02, 0x60, 0xC0, 0xD7, 0x77, 0x04, 0xF0, 0x80, 0x38, 0x01, 0xCA, 0x07,
  0x50, 0x2A, 0x02, 0x58, 0x19, 0xFA, 0x58, 0x21, 0xEF, 0x35, 0x81, 0x7F, 0xC6, 0x81, 0xDF, 0x55,
  0x81, 0x5F, 0xD6, 0x81, 0xCF, 0x75, 0x82, 0x3F, 0xE1, 0x58, 0x1A, 0xF9, 0x50, 0x1A, 0x02, 0x58,
  0x18, 0xFA, 0x68, 0x1E, 0xF4, 0x50, 0x5A, 0x80, 0x1C, 0x08, 0x06, 0xF0, 0xA0,
  // "ż" (U+017C)
  0x30, 0x0A, 0x50, 0x1A, 0x02, 0x50, 0xC0, 0xD7, 0x75, 0x02, 0xE1, 0x85, 0x2C, 0xCC, 0xDF, 0xE5,
  0x81, 0x9F, 0x84, 0x01, 0xA0, 0x14, 0x81, 0x8F, 0x94, 0x82, 0x1E, 0xF2, 0x48, 0x17, 0xFA, 0x58,
  0x1E, 0xF3, 0x48, 0x17, 0xFB, 0x58, 0x1D, 0xF3, 0x40, 0x5A, 0x80, 0x0C, 0x02, 0x06, 0xE0, 0x20,
  // "Ž" (U+017D)
  0x20, 0x70, 0x22, 0x81, 0x27, 0x12, 0x84, 0x9E, 0x22, 0xE9, 0x48, 0x2D, 0xDE, 0xD5, 0x04, 0xA0,
  0x47, 0x40, 0x4F, 0x08, 0x03, 0x80, 0x1C, 0xA0, 0x75, 0x02, 0xA0, 0x25, 0x81, 0x9F, 0xA5, 0x82,
  0x1E, 0xF3, 0x58, 0x17, 0xFC, 0x68, 0x1D, 0xF5, 0x58, 0x15, 0xFD, 0x68, 0x1C, 0xF7, 0x58, 0x23,
  0xFE, 0x15, 0x81, 0xAF, 0x95, 0x01, 0xA0, 0x25, 0x81, 0x8F, 0xA6, 0x81, 0xEF, 0x45, 0x05, 0xA8,
  0x01, 0xC0, 0x80, 0x6F, 0x0A,
  // "ž" (U+017E)
  0x10, 0x70, 0x22, 0x89, 0x02, 0x71, 0x09, 0xE2, 0x2E, 0x93, 0x82, 0xDD, 0xED, 0x40, 0x4A, 0x04,
  0x73, 0x02, 0xE1, 0x85, 0x2C, 0xCC, 0xDF, 0xE5, 0x81, 0x9F, 0x84, 0x01, 0xA0, 0x14, 0x81, 0x8F,
  0x94, 0x82, 0x1E, 0xF2, 0x48, 0x17, 0xFA, 0x58, 0x1E, 0xF3, 0x48, 0x17, 0xFB, 0x58, 0x1D, 0xF3,
  0x40, 0x5A, 0x80, 0x0C, 0x02, 0x06, 0xE0, 0x20,
  // "ſ" (U+017F)
  0x18, 0x94, 0x3C, 0xED, 0x51, 0xEF, 0xEE, 0x35, 0xFD, 0x38, 0x16, 0xFA, 0x38, 0x17, 0xF9, 0x38,
  0x17, 0xF9, 0x38, 0x17, 0xF9, 0x38, 0x17, 0xF9, 0x38, 0x17, 0xF9, 0x38, 0x17, 0xF9, 0x38, 0x17,
  0xF9, 0x38, 0x17, 0xF9, 0x38, 0x17, 0xF9, 0x38, 0x17, 0xF9, 0x38, 0x17, 0xF9, 0x38, 0x17, 0xF9,
  0x30,
  // "Ω" (U+03A9)
  0x38, 0x51, 0x9D, 0xFE, 0xA3, 0x50, 0x20, 0xEA, 0x0D, 0x0E, 0xA0, 0x64, 0x82, 0xDF, 0xB1, 0x20,
  0x7A, 0x02, 0x28, 0x25, 0xFE, 0x14, 0x81, 0xBF, 0x92, 0x81, 0x9F, 0xA5, 0x81, 0x5F, 0xD2, 0x81,
  0xCF, 0x75, 0x02, 0xA2, 0x81, 0xDF, 0x55, 0x01, 0xA8, 0x31, 0x0D, 0xF5, 0x6A, 0x83, 0x10, 0xCF,
  0x65, 0x01, 0xA2, 0x81, 0xAF, 0x75, 0x81, 0x3F, 0xE2, 0x81, 0x6F, 0xB5, 0x81, 0x6F, 0xA2, 0x81,
  0x2F, 0xE5, 0x81, 0xAF, 0x53, 0x81, 0x9F, 0x63, 0x81, 0x2F, 0xD4, 0x82, 0x1D, 0xE2, 0x28, 0x1C,
  0xF3, 0x28, 0x94, 0x5C, 0xCD, 0xFA, 0x06, 0xFE, 0xCC, 0x86, 0xC8, 0x1B, 0x06, 0xC0, 0xA0,
  // "μ" (U+03BC)
  0x81, 0x9F, 0x73, 0x84, 0x9F, 0x79, 0xF7, 0x38, 0x49, 0xF7, 0x9F, 0x73, 0x84, 0x9F, 0x79, 0xF7,
  0x38, 0x49, 0xF7, 0x9F, 0x73, 0x84, 0x9F, 0x79, 0xF7, 0x38, 0x49, 0xF7, 0x9F, 0x73, 0x84, 0x9F,
  0x79, 0xF7, 0x38, 0x4A, 0xF7, 0x9F, 0x93, 0x87, 0xEF, 0x79, 0xFE, 0x10, 0x6A, 0x07, 0x09, 0xA8,
  0xA0, 0xED, 0xFB, 0xF7, 0x9F, 0x9D, 0xE7, 0x3F, 0x79, 0xF7, 0x68, 0x19, 0xF7, 0x68, 0x19, 0xF7,
  0x68, 0x19, 0xF7, 0x68, 0x19, 0xF7, 0x60,
  // "π" (U+03C0)
  0x05, 0x0E, 0xFA, 0x81, 0x3A, 0xCA, 0x86, 0xDC, 0xCE, 0xFD, 0xC3, 0x2A, 0x01, 0x28, 0x1A, 0xF6,
  0x4A, 0x01, 0x28, 0x1A, 0xF6, 0x4A, 0x01, 0x28, 0x1A, 0xF6, 0x4A, 0x01, 0x28, 0x1A, 0xF6, 0x4A,
  0x01, 0x28, 0x1A, 0xF6, 0x4A, 0x01, 0x28, 0x1A, 0xF6, 0x4A, 0x01, 0x28, 0x1A, 0xF6, 0x4A, 0x01,
  0x28, 0x19, 0xF7, 0x4A, 0x01, 0x20, 0x6A, 0x0E, 0x01, 0x2A, 0x01, 0x38, 0x2A, 0xED, 0x10,
  // "–" (U+2013)
  0x02, 0x80, 0x4C, 0x09, 0x03, 0xF9, 0x0B,
  // "—" (U+2014)
  0x02, 0x80, 0x97, 0xC0, 0x20, 0x3F, 0xFD, 0x03,
  // "€" (U+20AC)
  0x48, 0x45, 0xCE, 0xD9, 0x23, 0x07, 0xA0, 0xDA, 0x06, 0x28, 0x22, 0xFE, 0x32, 0x07, 0x38, 0x19,
  0xF8, 0x78, 0x1E, 0xF3, 0x60, 0x1A, 0x60, 0x9E, 0x08, 0x20, 0x80, 0xDA, 0x0F, 0xC0, 0x72, 0x82,
  0x15, 0xFD, 0x0F, 0x13, 0x09, 0xE0, 0x12, 0x02, 0x05, 0xA0, 0xF4, 0x58, 0x1E, 0xF2, 0x78, 0x1A,
  0xF7, 0x78, 0x23, 0xFE, 0x42, 0x03, 0x02, 0x30, 0x9A, 0x82, 0xEE, 0xF5, 0x48, 0x46, 0xDF, 0xEA,
  0x20,
  // "₿" (U+20BF)
  0x28, 0x2B, 0x65, 0xD5, 0x82, 0xB6, 0x5D, 0x30, 0x5C, 0x0E, 0x05, 0x28, 0x35, 0xFE, 0xCE, 0xA8,
  0x36, 0x05, 0xFB, 0x28, 0x58, 0xFD, 0x05, 0xFB, 0x20, 0x1A, 0x82, 0x15, 0xFB, 0x3A, 0x82, 0x15,
  0xFB, 0x28, 0x94, 0x2F, 0xE0, 0x5F, 0xB0, 0x1A, 0xF9, 0x05, 0xD0, 0xA2, 0x89, 0x25, 0xFE, 0xCD,
  0xFE, 0x50, 0x5F, 0xB2, 0x05, 0xA8, 0x21, 0x5F, 0xB3, 0x84, 0xDF, 0x55, 0xFB, 0x38, 0x4B, 0xF6,
  0x5F, 0xB3, 0x84, 0xDF, 0x55, 0xFB, 0x20, 0x5A, 0x84, 0x25, 0xFE, 0xCD, 0xA8, 0x19, 0x05, 0xD0,
  0x74, 0x82, 0xB6, 0x5D, 0x58, 0x2B, 0x65, 0xD3,
  // "‘" (U+2018)
  0x18, 0xA0, 0x1F, 0x90, 0x7F, 0x50, 0xDF, 0x22, 0xFE, 0x06, 0xFC, 0x10,
  // "’" (U+2019)
  0x18, 0x5A, 0xF9, 0x0C, 0xF5, 0x1A, 0x18, 0x52, 0xFA, 0x06, 0xF4, 0x10,
  // "‚" (U+201A)
  0x18, 0x5A, 0xF9, 0x0C, 0xF5, 0x1A, 0x18, 0x52, 0xFA, 0x06, 0xF4, 0x10,
  // "‛" (U+201B)
  0x85, 0x6F, 0xC0, 0x2F, 0xE2, 0x89, 0x1D, 0xF2, 0x07, 0xF5, 0x01, 0xF9,
  // "“" (U+201C)
  0x18, 0xC4, 0x1F, 0x90, 0x3F, 0x60, 0x7F, 0x50, 0x9F, 0x30, 0xDF, 0x20, 0xEF, 0x02, 0xFE, 0x04,
  0xFD, 0x06, 0xFC, 0x08, 0xFA, 0x10,
  // "”" (U+201D)
  0x18, 0x95, 0xAF, 0x90, 0xCF, 0x60, 0xCF, 0x50, 0xEF, 0x21, 0xA1, 0x8A, 0x12, 0xFD, 0x02, 0xFA,
  0x05, 0xF7, 0x06, 0xF4, 0x08, 0xF1, 0x10,
  // "„" (U+201E)
  0x18, 0x95, 0xAF, 0x90, 0xCF, 0x60, 0xCF, 0x50, 0xEF, 0x21, 0xA1, 0x8A, 0x12, 0xFD, 0x02, 0xFA,
  0x05, 0xF7, 0x06, 0xF4, 0x08, 0xF1, 0x10,
  // "‟" (U+201F)
  0x89, 0x56, 0xFC, 0x08, 0xFA, 0x02, 0xFE, 0x04, 0xFD, 0x28, 0x3D, 0xF2, 0x0E, 0x92, 0x89, 0x57,
  0xF5, 0x09, 0xF3, 0x01, 0xF9, 0x03, 0xF7,
  // "†" (U+2020)
  0x20, 0x1A, 0x69, 0x0E, 0x60, 0xD0, 0xC6, 0x0C, 0x0B, 0x38, 0x96, 0x9A, 0x8D, 0xC8, 0xA9, 0xCE,
  0xDE, 0xED, 0xEC, 0x30, 0xB0, 0x96, 0x0B, 0x0A, 0x60, 0xC0, 0xB6, 0x0D, 0x0B, 0x60, 0xD0, 0xC6,
  0x0E, 0x0D, 0x69, 0x0E, 0x69, 0x0E, 0x50, 0x1A, 0x50, 0x1A, 0x30,
  // "‡" (U+2021)
  0x3A, 0x60, 0x0E, 0x60, 0xD0, 0xC3, 0x87, 0x21, 0x0B, 0xB0, 0x12, 0xDE, 0x87, 0xD7, 0x86, 0xCC,
  0x68, 0x73, 0x00, 0xC6, 0x00, 0xE6, 0x00, 0xE6, 0x0D, 0x0C, 0x38, 0x75, 0x53, 0xCB, 0x34, 0x5D,
  0xE8, 0x7D, 0x44, 0x3B, 0xB3, 0x44, 0x30, 0x0C, 0x60, 0x0E, 0x6A, 0x30,
  // "•" (U+2022)
  0x18, 0x48, 0xEE, 0x80, 0x5C, 0x05, 0x09, 0xC0, 0x80, 0x9C, 0x08, 0x05, 0xC8, 0x45, 0x08, 0xEE,
  0x81,
  // "…" (U+2026)
  0x81, 0x6E, 0x82, 0x81, 0x6E, 0x82, 0x84, 0x6E, 0x8A, 0xFD, 0x28, 0x1A, 0xFD, 0x28, 0x4A, 0xFD,
  0x6E, 0x82, 0x81, 0x6E, 0x82, 0x81, 0x6E, 0x80,
  // "‰" (U+2030)
  0x28, 0x2A, 0xFC, 0x13, 0x81, 0x1F, 0x87, 0x48, 0x38, 0xFE, 0xFB, 0x38, 0x17, 0xF2, 0x74, 0x84,
  0xEC, 0x0A, 0xF1, 0x20, 0xD0, 0xC7, 0x48, 0x91, 0x1F, 0x90, 0x6F, 0x40, 0x4F, 0x67, 0x48, 0x90,
  0x2F, 0x80, 0x5F, 0x50, 0xAE, 0x75, 0x89, 0x02, 0xF8, 0x05, 0xF5, 0x1F, 0x97, 0x58, 0x94, 0x1F,
  0x90, 0x6F, 0x47, 0xF3, 0x17, 0x71, 0x38, 0x15, 0x74, 0x38, 0x90, 0xDD, 0x0A, 0xF1, 0xDC, 0x1D,
  0xA0, 0xD2, 0x07, 0xB0, 0x52, 0x8A, 0x28, 0xFE, 0xFB, 0x4F, 0x66, 0xF5, 0x6F, 0x50, 0xDC, 0x1D,
  0xC3, 0x8A, 0x2A, 0xFC, 0x2A, 0xF1, 0xAF, 0x01, 0xF9, 0x2F, 0x70, 0x8F, 0x15, 0x84, 0x1F, 0x90,
  0xBE, 0x29, 0x86, 0xB3, 0xF6, 0x07, 0xF3, 0x58, 0x46, 0xF3, 0x0B, 0xD2, 0x87, 0xEB, 0x4F, 0x60,
  0x6F, 0x35, 0x0C, 0x0D, 0x20, 0xA0, 0xE2, 0x98, 0x6A, 0x3F, 0x70, 0x8F, 0x24, 0x81, 0x3F, 0x72,
  0x89, 0x18, 0xF3, 0x4F, 0x80, 0xFB, 0x0C, 0x95, 0x81, 0x9F, 0x12, 0x81, 0x2F, 0xEA, 0x85, 0x20,
  0xAF, 0xEF, 0xA5, 0x0E, 0x0A, 0x48, 0x26, 0xEE, 0x62, 0x83, 0x1B, 0xFB, 0x11,
  // "‹" (U+2039)
  0x38, 0x16, 0xB2, 0x28, 0x73, 0xFD, 0x10, 0x1D, 0xF4, 0x28, 0x1A, 0xF9, 0x20, 0x2A, 0x03, 0x38,
  0x18, 0xFB, 0x48, 0x1B, 0xF6, 0x38, 0x21, 0xEE, 0x23, 0x04, 0x07, 0x10,
  // "›" (U+203A)
  0x09, 0x08, 0x38, 0x1B, 0xF5, 0x28, 0x22, 0xEE, 0x22, 0x81, 0x6F, 0xD3, 0x89, 0x6E, 0xF5, 0x09,
  0xFB, 0x04, 0xFD, 0x10, 0xDF, 0x32, 0x00, 0x63,
  // "⁄" (U+2044)
  0x71, 0x0D, 0x0C, 0x78, 0x16, 0xF4, 0x70, 0xD0, 0xC7, 0x81, 0x6F, 0x47, 0x0D, 0x0C, 0x78, 0x16,
  0xF5, 0x70, 0xD0, 0xC7, 0x81, 0x6F, 0x57, 0x0D, 0x0C, 0x78, 0x16, 0xF5, 0x70, 0xD0, 0xC7, 0x81,
  0x6F, 0x57, 0x0D, 0x0C, 0x78, 0x16, 0xF5, 0x70, 0xD0, 0xC7, 0x81, 0x6F, 0x57,
  // "™" (U+2122)
  0x0B, 0xC8, 0x15, 0xFE, 0x38, 0x7C, 0xF1, 0x22, 0xD8, 0x21, 0xA8, 0x14, 0x02, 0xA0, 0x12, 0x0D,
  0x06, 0x29, 0x85, 0xB9, 0x07, 0xBF, 0x12, 0x0D, 0x06, 0x29, 0x85, 0x6E, 0x0C, 0x6F, 0x12, 0x0D,
  0x06, 0x29, 0x85, 0x3D, 0x6D, 0x2F, 0x12, 0x0D, 0x06, 0x29, 0x85, 0x38, 0xE8, 0x2F, 0x12, 0x0D,
  0x06, 0x29, 0x85, 0x33, 0xF3, 0x2F, 0x12, 0x02, 0x01, 0x20, 0x22, 0x02, 0x20, 0x21,
  // "⅒" (U+2152)
  0x73, 0x0D, 0x0C, 0x73, 0x81, 0x3D, 0xE5, 0x81, 0x6F, 0x47, 0x20, 0x6A, 0x0E, 0x50, 0xD0, 0xC7,
  0x38, 0x2D, 0x8A, 0xE4, 0x81, 0x6F, 0x47, 0x50, 0xA0, 0xE4, 0x0D, 0x0C, 0x76, 0x0A, 0x0E, 0x38,
  0x16, 0xF5, 0x76, 0x0A, 0x0E, 0x30, 0xD0, 0xC7, 0x10, 0x15, 0x0A, 0x0E, 0x28, 0x56, 0xF5, 0x03,
  0xDE, 0x28, 0x34, 0xEF, 0xD3, 0x30, 0xA0, 0xE2, 0x82, 0xDC, 0x06, 0xA0, 0xE2, 0x83, 0xED, 0x5D,
  0xD3, 0x8A, 0x1A, 0xE0, 0x6F, 0x50, 0xD8, 0xAE, 0x04, 0xF5, 0x06, 0xF3, 0x50, 0xD0, 0xC4, 0x89,
  0x0A, 0xE0, 0x7F, 0x30, 0x3F, 0x64, 0x81, 0x6F, 0x54, 0x89, 0x0A, 0xE0, 0x7F, 0x20, 0x3F, 0x74,
  0x0D, 0x0C, 0x58, 0x90, 0xAE, 0x07, 0xF3, 0x03, 0xF6, 0x38, 0x16, 0xF5, 0x58, 0x90, 0xAE, 0x05,
  0xF5, 0x06, 0xF4, 0x30, 0xD0, 0xC6, 0x87, 0xAE, 0x01, 0xEC, 0x3C, 0xE3, 0x81, 0x6F, 0x56, 0x0A,
  0x0E, 0x20, 0x6B, 0x05, 0x77, 0x38, 0x11, 0x41, 0x20,
  // "ﬁ" (U+FB01)
  0x28, 0x62, 0xBE, 0xE7, 0x5E, 0x52, 0x89, 0x2D, 0xFE, 0xD6, 0x9F, 0x90, 0x2F, 0xE3, 0x85, 0x4C,
  0x40, 0x3F, 0xD6, 0x05, 0x0D, 0xB8, 0x5E, 0x08, 0xF7, 0x9D, 0xA8, 0x90, 0xCB, 0x08, 0xF7, 0x03,
  0xFC, 0x38, 0x58, 0xF7, 0x03, 0xFC, 0x38, 0x58, 0xF7, 0x03, 0xFC, 0x38, 0x58, 0xF7, 0x03, 0xFC,
  0x38, 0x58, 0xF7, 0x03, 0xFC, 0x38, 0x58, 0xF7, 0x03, 0xFC, 0x38, 0x58, 0xF7, 0x03, 0xFC, 0x38,
  0x58, 0xF7, 0x03, 0xFC, 0x38, 0x58, 0xF7, 0x03, 0xFC, 0x38, 0x58, 0xF7, 0x03, 0xFC, 0x38, 0x18,
  0xF7,
  // "ﬂ" (U+FB02)
  0x28, 0x62, 0xBE, 0xE7, 0x8F, 0x72, 0x89, 0x2D, 0xFE, 0xD6, 0x8F, 0x70, 0x2F, 0xE3, 0x85, 0x8F,
  0x70, 0x3F, 0xD3, 0x83, 0x8F, 0x75, 0xDB, 0x85, 0xE0, 0x8F, 0x79, 0xDA, 0x89, 0x0C, 0xB0, 0x8F,
  0x70, 0x3F, 0xC3, 0x85, 0x8F, 0x70, 0x3F, 0xC3, 0x85, 0x8F, 0x70, 0x3F, 0xC3, 0x85, 0x8F, 0x70,
  0x3F, 0xC3, 0x85, 0x8F, 0x70, 0x3F, 0xC3, 0x85, 0x8F, 0x70, 0x3F, 0xC3, 0x85, 0x8F, 0x70, 0x3F,
  0xC3, 0x85, 0x8F, 0x70, 0x3F, 0xC3, 0x85, 0x8F, 0x70, 0x3F, 0xC3, 0x85, 0x8F, 0x70, 0x3F, 0xC3,
  0x81, 0x8F, 0x70,
};

const Font& font_NotoSans_CondensedMedium_21() {
  static SmoothFont font(font_NotoSans_CondensedMedium_21_data);
  return font;
}

}  // namespace roo_display
