#include "roo_windows/widgets/resources/circular_shadow.h"

#include "roo_display/color/named.h"

namespace roo_windows {

using namespace roo_display;

// Image file shadow_18 18x18, 4-bit Alpha,  RLE, 118 bytes.
static const uint8_t circular_shadow_18_data[] PROGMEM = {
    0x68, 0x31, 0x22, 0x21, 0x73, 0x87, 0x24, 0x67, 0x77, 0x53, 0x17, 0x89,
    0x13, 0x69, 0xBC, 0xCB, 0xA8, 0x52, 0x58, 0x93, 0x37, 0xBC, 0xDE, 0xEE,
    0xDC, 0xA6, 0x23, 0x84, 0x26, 0xBD, 0xEE, 0xB8, 0x4E, 0xEC, 0x95, 0x12,
    0x82, 0x49, 0xCE, 0xE8, 0x91, 0xEE, 0xC8, 0x20, 0x16, 0xBD, 0xEF, 0x87,
    0xED, 0x94, 0x02, 0x7C, 0xEF, 0x98, 0x7E, 0xDA, 0x51, 0x27, 0xCE, 0xFA,
    0x86, 0xDB, 0x51, 0x27, 0xBE, 0xF9, 0x89, 0x0E, 0xDA, 0x50, 0x15, 0xAD,
    0xEF, 0x82, 0xEC, 0x94, 0x28, 0x33, 0x8C, 0xEE, 0xD8, 0x3E, 0xDB, 0x72,
    0x28, 0x94, 0x15, 0xAC, 0xEE, 0xEF, 0xEE, 0xDC, 0x84, 0x48, 0x93, 0x26,
    0x9C, 0xDD, 0xDD, 0xCB, 0x84, 0x15, 0x89, 0x12, 0x58, 0x9A, 0xBA, 0x97,
    0x41, 0x78, 0x61, 0x24, 0x55, 0x54, 0x27, 0x50, 0x01, 0x71,
};

const Pictogram& circular_shadow_18() {
  static Pictogram value(Box(1, 1, 17, 17), Box(0, 0, 17, 17),
                         circular_shadow_18_data, Alpha4(color::Black));
  return value;
}

// Image file shadow_24 24x24, 4-bit Alpha,  RLE, 193 bytes.
static const uint8_t circular_shadow_24_data[] PROGMEM = {
    0x74, 0x01, 0x77, 0x38, 0x71, 0x23, 0x44, 0x33, 0x21, 0x74, 0x89, 0x31,
    0x34, 0x67, 0x88, 0x87, 0x64, 0x21, 0x71, 0x83, 0x24, 0x68, 0xA8, 0x01,
    0xB8, 0x3A, 0x86, 0x31, 0x68, 0x42, 0x47, 0xAB, 0xC8, 0x01, 0xD8, 0x4C,
    0xB9, 0x74, 0x14, 0x84, 0x14, 0x7A, 0xCD, 0x80, 0x3E, 0x84, 0xDC, 0xA7,
    0x31, 0x38, 0x53, 0x6A, 0xCD, 0xEE, 0xD8, 0x5E, 0xED, 0xC9, 0x62, 0x28,
    0x41, 0x48, 0xBD, 0xEF, 0x98, 0x94, 0xEE, 0xDB, 0x84, 0x10, 0x26, 0xAC,
    0xEE, 0xFA, 0x89, 0x2E, 0xEC, 0x95, 0x20, 0x37, 0xBD, 0xEF, 0xC8, 0x91,
    0xED, 0xA7, 0x30, 0x48, 0xBD, 0xEF, 0xC8, 0x91, 0xED, 0xB7, 0x31, 0x48,
    0xBD, 0xEF, 0xC8, 0x91, 0xED, 0xB8, 0x30, 0x38, 0xBD, 0xEF, 0xC8, 0x91,
    0xED, 0xB7, 0x30, 0x37, 0xBD, 0xEF, 0xC8, 0x92, 0xED, 0xA7, 0x20, 0x26,
    0xAC, 0xEE, 0xFA, 0x89, 0x4E, 0xEC, 0x95, 0x20, 0x14, 0x8B, 0xDE, 0xEF,
    0x85, 0xEE, 0xDB, 0x84, 0x12, 0x85, 0x26, 0x9C, 0xDE, 0xED, 0x85, 0xEE,
    0xDC, 0x95, 0x23, 0x84, 0x13, 0x7A, 0xCD, 0x80, 0x3E, 0x84, 0xDC, 0x96,
    0x31, 0x48, 0x41, 0x47, 0x9B, 0xC8, 0x01, 0xD8, 0x4C, 0xB9, 0x63, 0x16,
    0x89, 0x51, 0x36, 0x89, 0xAB, 0xBB, 0xA9, 0x85, 0x31, 0x71, 0x89, 0x31,
    0x24, 0x57, 0x78, 0x77, 0x54, 0x21, 0x74, 0x87, 0x12, 0x33, 0x33, 0x22,
    0x16,
};

const Pictogram& circular_shadow_24() {
  static Pictogram value(Box(1, 1, 22, 22), Box(0, 0, 23, 23),
                         circular_shadow_24_data, Alpha4(color::Black));
  return value;
}

// Image file shadow_36 36x36, 4-bit Alpha,  RLE, 399 bytes.
static const uint8_t circular_shadow_36_data[] PROGMEM = {
    0x77, 0x80, 0x11, 0x77, 0x73, 0x82, 0x11, 0x22, 0x80, 0x13, 0x82, 0x22,
    0x11, 0x77, 0x48, 0x97, 0x11, 0x23, 0x45, 0x56, 0x66, 0x55, 0x44, 0x32,
    0x17, 0x71, 0x8A, 0x11, 0x23, 0x56, 0x78, 0x89, 0x99, 0x98, 0x76, 0x54,
    0x31, 0x76, 0x86, 0x13, 0x46, 0x79, 0xAA, 0x80, 0x1B, 0x87, 0xAA, 0x98,
    0x75, 0x32, 0x17, 0x38, 0xA6, 0x23, 0x57, 0x9A, 0xBB, 0xCC, 0xDD, 0xDC,
    0xCC, 0xBA, 0x97, 0x64, 0x21, 0x71, 0x8B, 0x01, 0x35, 0x79, 0xBC, 0xCD,
    0xDD, 0xEE, 0xED, 0xDD, 0xCC, 0xBA, 0x86, 0x42, 0x16, 0x87, 0x13, 0x57,
    0x9B, 0xCD, 0xD8, 0x05, 0xE8, 0x7D, 0xDC, 0xBA, 0x86, 0x32, 0x58, 0x61,
    0x24, 0x79, 0xBC, 0xD8, 0x00, 0xED, 0x80, 0x0E, 0x86, 0xDC, 0xBA, 0x85,
    0x31, 0x48, 0x51, 0x36, 0x9B, 0xCD, 0x0F, 0xEF, 0xA0, 0xFE, 0x85, 0xDC,
    0xB9, 0x74, 0x23, 0x85, 0x12, 0x57, 0xAC, 0xD0, 0xFE, 0xFC, 0x0F, 0xE8,
    0x5D, 0xCA, 0x86, 0x31, 0x28, 0x71, 0x36, 0x9B, 0xCD, 0xEE, 0xFE, 0x0F,
    0xE8, 0x4D, 0xB9, 0x74, 0x22, 0x86, 0x24, 0x7A, 0xBD, 0xEE, 0xFF, 0x98,
    0x6E, 0xED, 0xCA, 0x85, 0x22, 0x86, 0x25, 0x8A, 0xCD, 0xEE, 0xFF, 0xA8,
    0x96, 0xED, 0xCB, 0x96, 0x31, 0x13, 0x58, 0xBC, 0xDE, 0xFF, 0xB8, 0x96,
    0xEE, 0xDB, 0x96, 0x31, 0x13, 0x69, 0xBD, 0xEE, 0xFF, 0xB8, 0x96, 0xEE,
    0xDB, 0x97, 0x41, 0x13, 0x69, 0xBD, 0xEE, 0xFF, 0xB8, 0x96, 0xEE, 0xDC,
    0xA7, 0x41, 0x13, 0x69, 0xBD, 0xEE, 0xFF, 0xB8, 0x96, 0xEE, 0xDC, 0xA7,
    0x41, 0x13, 0x59, 0xBC, 0xDE, 0xFF, 0xB8, 0x97, 0xEE, 0xDB, 0x96, 0x41,
    0x02, 0x58, 0xAC, 0xDE, 0xEF, 0xFA, 0x89, 0x7E, 0xDD, 0xB9, 0x63, 0x10,
    0x24, 0x7A, 0xCD, 0xEE, 0xFF, 0x98, 0xA1, 0xEE, 0xDC, 0xB8, 0x53, 0x10,
    0x14, 0x69, 0xBC, 0xDE, 0xEF, 0xF8, 0x6E, 0xED, 0xCA, 0x74, 0x22, 0x85,
    0x13, 0x58, 0xAC, 0xD0, 0xFE, 0xFD, 0x87, 0xEE, 0xDC, 0xB9, 0x63, 0x13,
    0x85, 0x24, 0x79, 0xBC, 0xD0, 0xFE, 0xFB, 0x89, 0x0E, 0xED, 0xDB, 0xA7,
    0x52, 0x13, 0x86, 0x13, 0x57, 0xAB, 0xCD, 0x0F, 0xEF, 0x0F, 0xE8, 0x6D,
    0xDC, 0xA8, 0x63, 0x15, 0x86, 0x13, 0x68, 0xAB, 0xCD, 0x80, 0x7E, 0x86,
    0xDD, 0xCA, 0x96, 0x42, 0x78, 0x52, 0x46, 0x8A, 0xBC, 0x0F, 0xD8, 0x01,
    0xE0, 0xFD, 0x86, 0xCB, 0xA9, 0x74, 0x21, 0x78, 0x90, 0x12, 0x46, 0x89,
    0xAB, 0xCC, 0x80, 0x2D, 0x87, 0xCC, 0xBA, 0x86, 0x43, 0x17, 0x28, 0xA5,
    0x12, 0x35, 0x78, 0x9A, 0xBB, 0xBC, 0xCB, 0xBB, 0xA9, 0x76, 0x42, 0x17,
    0x48, 0xA3, 0x12, 0x34, 0x67, 0x89, 0x99, 0xAA, 0x99, 0x87, 0x65, 0x32,
    0x17, 0x78, 0x97, 0x12, 0x34, 0x56, 0x67, 0x77, 0x66, 0x54, 0x32, 0x17,
    0x74, 0x89, 0x41, 0x22, 0x33, 0x44, 0x44, 0x33, 0x21, 0x17, 0x77, 0x18,
    0x04, 0x17, 0x50,
};

const Pictogram& circular_shadow_36() {
  static Pictogram value(Box(2, 2, 34, 34), Box(0, 0, 35, 35),
                         circular_shadow_36_data, Alpha4(color::Black));
  return value;
}

// Image file shadow_48 48x48, 4-bit Alpha,  RLE, 679 bytes.
static const uint8_t circular_shadow_48_data[] PROGMEM = {
    0x77, 0x48, 0x04, 0x17, 0x77, 0x74, 0x0F, 0x10, 0xF2, 0x80, 0x03, 0x0F,
    0x20, 0xF1, 0x77, 0x75, 0x8A, 0x21, 0x12, 0x33, 0x44, 0x45, 0x55, 0x54,
    0x44, 0x33, 0x21, 0x17, 0x77, 0x18, 0x71, 0x12, 0x34, 0x55, 0x66, 0x80,
    0x27, 0x87, 0x66, 0x54, 0x43, 0x21, 0x17, 0x75, 0x89, 0x01, 0x23, 0x45,
    0x67, 0x78, 0x88, 0x02, 0x98, 0x90, 0x88, 0x77, 0x65, 0x43, 0x21, 0x77,
    0x28, 0x92, 0x11, 0x24, 0x56, 0x78, 0x99, 0xAA, 0x80, 0x2B, 0x89, 0x1A,
    0xA9, 0x98, 0x76, 0x43, 0x21, 0x77, 0x89, 0x21, 0x23, 0x45, 0x78, 0x9A,
    0xAB, 0xB8, 0x04, 0xC8, 0x91, 0xBB, 0xAA, 0x98, 0x65, 0x42, 0x17, 0x58,
    0x90, 0x12, 0x34, 0x67, 0x8A, 0xAB, 0x0F, 0xC8, 0x04, 0xD0, 0xFC, 0x87,
    0xBA, 0x98, 0x75, 0x42, 0x17, 0x48, 0x90, 0x13, 0x46, 0x79, 0xAB, 0xCC,
    0x80, 0x0D, 0x80, 0x2E, 0x80, 0x0D, 0x89, 0x0C, 0xBB, 0xA8, 0x75, 0x42,
    0x17, 0x28, 0x71, 0x24, 0x67, 0x9A, 0xBC, 0x0F, 0xD8, 0x09, 0x0E, 0x89,
    0x2D, 0xDC, 0xCB, 0xA9, 0x75, 0x42, 0x17, 0x89, 0x11, 0x24, 0x57, 0x9A,
    0xBC, 0xDD, 0x80, 0x3E, 0xA8, 0x02, 0xE0, 0xFD, 0x86, 0xCB, 0xA8, 0x75,
    0x32, 0x78, 0x90, 0x13, 0x57, 0x8A, 0xBC, 0xDD, 0x80, 0x0E, 0xFA, 0x80,
    0x1E, 0x89, 0x0D, 0xDC, 0xBA, 0x86, 0x43, 0x15, 0x89, 0x01, 0x24, 0x68,
    0xAB, 0xCD, 0xD0, 0xFE, 0xFE, 0x80, 0x0E, 0x89, 0x0D, 0xDC, 0xB9, 0x75,
    0x32, 0x14, 0x87, 0x13, 0x57, 0x9A, 0xCD, 0xD0, 0xFE, 0xFF, 0x98, 0x00,
    0xE8, 0x7D, 0xCB, 0xA9, 0x64, 0x31, 0x38, 0x71, 0x24, 0x68, 0xAB, 0xCD,
    0x0F, 0xEF, 0xFB, 0x0F, 0xE8, 0x7D, 0xDC, 0xB9, 0x75, 0x32, 0x38, 0x91,
    0x13, 0x57, 0x9A, 0xCD, 0xDE, 0xEF, 0xFD, 0x0F, 0xE8, 0x7D, 0xCB, 0xA8,
    0x64, 0x21, 0x28, 0x61, 0x35, 0x79, 0xBC, 0xD0, 0xFE, 0xFF, 0xE8, 0x91,
    0xEE, 0xDD, 0xCB, 0x97, 0x53, 0x12, 0x89, 0x02, 0x46, 0x8A, 0xBC, 0xDE,
    0xEF, 0xFF, 0x0F, 0xE8, 0xA2, 0xDC, 0xB9, 0x85, 0x31, 0x01, 0x24, 0x68,
    0xAC, 0xDD, 0xEE, 0xFF, 0xF9, 0x8A, 0x1E, 0xED, 0xCB, 0xA8, 0x64, 0x20,
    0x12, 0x47, 0x9B, 0xCD, 0x0F, 0xEF, 0xFF, 0x98, 0xA1, 0xEE, 0xDD, 0xCA,
    0x86, 0x42, 0x11, 0x35, 0x79, 0xBC, 0xD0, 0xFE, 0xFF, 0xF9, 0x8A, 0x3E,
    0xED, 0xDC, 0xA9, 0x64, 0x21, 0x13, 0x57, 0x9B, 0xCD, 0xEE, 0xFF, 0xFA,
    0x0F, 0xE8, 0xA0, 0xDC, 0xA9, 0x64, 0x21, 0x13, 0x57, 0x9B, 0xCD, 0xEE,
    0xFF, 0xFA, 0x0F, 0xE8, 0x96, 0xDC, 0xA9, 0x64, 0x21, 0x13, 0x57, 0x9B,
    0xCD, 0x0F, 0xEF, 0xFF, 0x98, 0xA1, 0xEE, 0xDD, 0xCA, 0x96, 0x42, 0x11,
    0x24, 0x79, 0xBC, 0xD0, 0xFE, 0xFF, 0xF9, 0x8A, 0x4E, 0xED, 0xDC, 0xA8,
    0x64, 0x21, 0x12, 0x46, 0x8A, 0xCD, 0xDE, 0xEF, 0xFF, 0x98, 0x90, 0xEE,
    0xDC, 0xBA, 0x86, 0x42, 0x28, 0x62, 0x46, 0x8A, 0xBC, 0xD0, 0xFE, 0xFF,
    0xE0, 0xFE, 0x86, 0xDC, 0xB9, 0x75, 0x31, 0x28, 0x61, 0x35, 0x79, 0xBC,
    0xD0, 0xFE, 0xFF, 0xE8, 0x91, 0xEE, 0xDD, 0xCB, 0x97, 0x53, 0x12, 0x87,
    0x13, 0x47, 0x9A, 0xCD, 0xD0, 0xFE, 0xFF, 0xC0, 0xFE, 0x87, 0xDC, 0xBA,
    0x86, 0x42, 0x12, 0x89, 0x01, 0x24, 0x68, 0xAB, 0xCD, 0xD0, 0xFE, 0xFF,
    0xA0, 0xFE, 0x87, 0xDD, 0xCB, 0x97, 0x53, 0x14, 0x87, 0x13, 0x57, 0x9A,
    0xBC, 0xD8, 0x00, 0xEF, 0xF0, 0xFE, 0x89, 0x0D, 0xDC, 0xBA, 0x86, 0x42,
    0x14, 0x89, 0x01, 0x24, 0x68, 0x9B, 0xCD, 0xD8, 0x00, 0xEF, 0xD8, 0x00,
    0xE8, 0x7D, 0xCB, 0xA9, 0x75, 0x32, 0x68, 0x90, 0x13, 0x46, 0x8A, 0xBC,
    0xDD, 0x80, 0x1E, 0xF9, 0x80, 0x0E, 0x89, 0x1D, 0xDC, 0xCB, 0x98, 0x64,
    0x21, 0x68, 0x71, 0x23, 0x57, 0x8A, 0xBC, 0x0F, 0xD8, 0x09, 0x2E, 0x89,
    0x1D, 0xDC, 0xCB, 0xA8, 0x65, 0x31, 0x71, 0x89, 0x01, 0x24, 0x57, 0x9A,
    0xBC, 0xC0, 0xFD, 0x80, 0x6E, 0x0F, 0xD8, 0x90, 0xCB, 0xBA, 0x87, 0x53,
    0x21, 0x72, 0x89, 0x11, 0x24, 0x57, 0x8A, 0xBB, 0xCC, 0x80, 0x1D, 0x00,
    0xE8, 0x01, 0xD8, 0x91, 0xCC, 0xBA, 0x98, 0x75, 0x32, 0x17, 0x48, 0x90,
    0x12, 0x45, 0x78, 0x9A, 0xBB, 0x0F, 0xC8, 0x02, 0xD0, 0xFC, 0x89, 0x0B,
    0xBA, 0x98, 0x65, 0x32, 0x17, 0x68, 0x71, 0x24, 0x56, 0x79, 0x9A, 0x0F,
    0xB8, 0x02, 0xC0, 0xFB, 0x87, 0xA9, 0x87, 0x65, 0x32, 0x17, 0x71, 0x89,
    0x01, 0x23, 0x45, 0x67, 0x89, 0x98, 0x04, 0xA8, 0x90, 0x99, 0x87, 0x65,
    0x43, 0x21, 0x77, 0x38, 0xB0, 0x12, 0x33, 0x45, 0x67, 0x88, 0x89, 0x99,
    0x98, 0x87, 0x76, 0x54, 0x32, 0x11, 0x77, 0x68, 0x51, 0x23, 0x34, 0x55,
    0x80, 0x46, 0x85, 0x55, 0x43, 0x22, 0x17, 0x77, 0x28, 0x41, 0x12, 0x23,
    0x38, 0x04, 0x48, 0x33, 0x32, 0x11, 0x77, 0x77, 0x0F, 0x18, 0x04, 0x20,
    0xF1, 0x77, 0x77, 0x68, 0x02, 0x17, 0x75,
};

const Pictogram& circular_shadow_48() {
  static Pictogram value(Box(3, 3, 46, 46), Box(0, 0, 47, 47),
                         circular_shadow_48_data, Alpha4(color::Black));
  return value;
}

}  // namespace roo_windows