#include "30.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedMedium (Noto Sans Condensed Medium)
// Generated on Thu Mar 30 23:43:29 CEST 2023
static const uint8_t font_NotoSans_CondensedMedium_30_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x07, 0xD5,
  0xFB, 0xFA, 0x1E, 0x1F, 0x17, 0xF9, 0x08, 0x03, 0x20, 0x08, 0x07, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x01, 0x01, 0x05, 0x16, 0x08, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x01, 0x0F, 0x0A, 0x16, 0x0C, 0x00, 0x39, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x0F, 0x16, 0x10, 0x00, 0x64, // "#" (U+0023)
  0x00, 0x24, 0x01, 0xFF, 0x0D, 0x17, 0x0E, 0x00, 0xE3, // "$" (U+0024)
  0x00, 0x25, 0x01, 0x01, 0x15, 0x16, 0x16, 0x01, 0x5A, // "%" (U+0025)
  0x00, 0x26, 0x01, 0x01, 0x11, 0x16, 0x11, 0x02, 0x21, // "&" (U+0026)
  0x00, 0x27, 0x01, 0x0F, 0x04, 0x16, 0x07, 0x02, 0xAE, // "'" (U+0027)
  0x00, 0x28, 0x01, 0xFC, 0x08, 0x16, 0x09, 0x02, 0xC1, // "(" (U+0028)
  0x00, 0x29, 0x01, 0xFC, 0x07, 0x16, 0x09, 0x03, 0x13, // ")" (U+0029)
  0x00, 0x2A, 0x01, 0x0C, 0x0C, 0x17, 0x0E, 0x03, 0x63, // "*" (U+002A)
  0x00, 0x2B, 0x01, 0x05, 0x0D, 0x13, 0x0E, 0x03, 0xA0, // "+" (U+002B)
  0x00, 0x2C, 0x01, 0xFD, 0x05, 0x04, 0x07, 0x03, 0xCB, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x08, 0x07, 0x0A, 0x09, 0x03, 0xE2, // "-" (U+002D)
  0x00, 0x2E, 0x01, 0x01, 0x05, 0x04, 0x07, 0x03, 0xEB, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x0A, 0x16, 0x0B, 0x03, 0xF6, // "/" (U+002F)
  0x00, 0x30, 0x01, 0x01, 0x0D, 0x16, 0x0E, 0x04, 0x39, // "0" (U+0030)
  0x00, 0x31, 0x02, 0x01, 0x09, 0x16, 0x0E, 0x04, 0xAD, // "1" (U+0031)
  0x00, 0x32, 0x01, 0x01, 0x0C, 0x16, 0x0E, 0x04, 0xF7, // "2" (U+0032)
  0x00, 0x33, 0x01, 0x01, 0x0C, 0x16, 0x0E, 0x05, 0x4A, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x0D, 0x16, 0x0E, 0x05, 0xAB, // "4" (U+0034)
  0x00, 0x35, 0x01, 0x01, 0x0C, 0x16, 0x0E, 0x06, 0x13, // "5" (U+0035)
  0x00, 0x36, 0x01, 0x01, 0x0D, 0x16, 0x0E, 0x06, 0x6C, // "6" (U+0036)
  0x00, 0x37, 0x01, 0x01, 0x0D, 0x16, 0x0E, 0x06, 0xDC, // "7" (U+0037)
  0x00, 0x38, 0x01, 0x01, 0x0D, 0x16, 0x0E, 0x07, 0x27, // "8" (U+0038)
  0x00, 0x39, 0x01, 0x01, 0x0C, 0x16, 0x0E, 0x07, 0x9F, // "9" (U+0039)
  0x00, 0x3A, 0x01, 0x01, 0x05, 0x11, 0x07, 0x08, 0x06, // ":" (U+003A)
  0x00, 0x3B, 0x01, 0xFD, 0x05, 0x11, 0x07, 0x08, 0x1E, // ";" (U+003B)
  0x00, 0x3C, 0x01, 0x04, 0x0D, 0x12, 0x0E, 0x08, 0x42, // "<" (U+003C)
  0x00, 0x3D, 0x01, 0x07, 0x0D, 0x0F, 0x0E, 0x08, 0x84, // "=" (U+003D)
  0x00, 0x3E, 0x01, 0x04, 0x0D, 0x12, 0x0E, 0x08, 0x9B, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x0A, 0x16, 0x0B, 0x08, 0xDE, // "?" (U+003F)
  0x00, 0x40, 0x01, 0xFE, 0x14, 0x16, 0x16, 0x09, 0x2B, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x0F, 0x16, 0x10, 0x09, 0xF9, // "A" (U+0041)
  0x00, 0x42, 0x02, 0x01, 0x0E, 0x16, 0x10, 0x0A, 0x6C, // "B" (U+0042)
  0x00, 0x43, 0x01, 0x01, 0x0E, 0x16, 0x0F, 0x0A, 0xE5, // "C" (U+0043)
  0x00, 0x44, 0x02, 0x01, 0x10, 0x16, 0x12, 0x0B, 0x43, // "D" (U+0044)
  0x00, 0x45, 0x02, 0x01, 0x0C, 0x16, 0x0E, 0x0B, 0xC1, // "E" (U+0045)
  0x00, 0x46, 0x02, 0x01, 0x0C, 0x16, 0x0D, 0x0C, 0x0C, // "F" (U+0046)
  0x00, 0x47, 0x01, 0x01, 0x10, 0x16, 0x12, 0x0C, 0x55, // "G" (U+0047)
  0x00, 0x48, 0x02, 0x01, 0x0F, 0x16, 0x12, 0x0C, 0xC8, // "H" (U+0048)
  0x00, 0x49, 0x01, 0x01, 0x08, 0x16, 0x09, 0x0D, 0x3E, // "I" (U+0049)
  0x00, 0x4A, 0xFE, 0xFB, 0x05, 0x16, 0x08, 0x0D, 0x7E, // "J" (U+004A)
  0x00, 0x4B, 0x02, 0x01, 0x0F, 0x16, 0x0F, 0x0D, 0xD5, // "K" (U+004B)
  0x00, 0x4C, 0x02, 0x01, 0x0C, 0x16, 0x0D, 0x0E, 0x55, // "L" (U+004C)
  0x00, 0x4D, 0x02, 0x01, 0x15, 0x16, 0x18, 0x0E, 0x9A, // "M" (U+004D)
  0x00, 0x4E, 0x02, 0x01, 0x10, 0x16, 0x13, 0x0F, 0x63, // "N" (U+004E)
  0x00, 0x4F, 0x01, 0x01, 0x11, 0x16, 0x13, 0x0F, 0xF1, // "O" (U+004F)
  0x00, 0x50, 0x02, 0x01, 0x0D, 0x16, 0x0F, 0x10, 0x77, // "P" (U+0050)
  0x00, 0x51, 0x01, 0xFC, 0x11, 0x16, 0x13, 0x10, 0xDD, // "Q" (U+0051)
  0x00, 0x52, 0x02, 0x01, 0x0F, 0x16, 0x10, 0x11, 0x76, // "R" (U+0052)
  0x00, 0x53, 0x01, 0x01, 0x0C, 0x16, 0x0E, 0x11, 0xF5, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x0C, 0x16, 0x0D, 0x12, 0x51, // "T" (U+0054)
  0x00, 0x55, 0x02, 0x01, 0x0F, 0x16, 0x12, 0x12, 0xA0, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x0F, 0x16, 0x0F, 0x13, 0x19, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x17, 0x16, 0x18, 0x13, 0x8E, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x0D, 0x16, 0x0E, 0x14, 0x5A, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x0D, 0x16, 0x0E, 0x14, 0xCE, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x0C, 0x16, 0x0D, 0x15, 0x31, // "Z" (U+005A)
  0x00, 0x5B, 0x02, 0xFB, 0x08, 0x16, 0x09, 0x15, 0x82, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x0A, 0x16, 0x0B, 0x15, 0xD6, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0xFB, 0x07, 0x16, 0x09, 0x16, 0x1E, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x0A, 0x0E, 0x16, 0x0F, 0x16, 0x73, // "^" (U+005E)
  0x00, 0x5F, 0xFF, 0xFC, 0x0D, 0xFE, 0x0D, 0x16, 0xB7, // "_" (U+005F)
  0x00, 0x60, 0x01, 0x14, 0x07, 0x18, 0x09, 0x16, 0xC1, // "`" (U+0060)
  0x00, 0x61, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x16, 0xD3, // "a" (U+0061)
  0x00, 0x62, 0x02, 0x01, 0x0E, 0x17, 0x10, 0x17, 0x2C, // "b" (U+0062)
  0x00, 0x63, 0x01, 0x01, 0x0B, 0x11, 0x0C, 0x17, 0xA1, // "c" (U+0063)
  0x00, 0x64, 0x01, 0x01, 0x0D, 0x17, 0x10, 0x17, 0xE0, // "d" (U+0064)
  0x00, 0x65, 0x01, 0x01, 0x0C, 0x11, 0x0E, 0x18, 0x59, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x09, 0x17, 0x09, 0x18, 0xA8, // "f" (U+0066)
  0x00, 0x67, 0x01, 0xFA, 0x0D, 0x11, 0x10, 0x18, 0xF5, // "g" (U+0067)
  0x00, 0x68, 0x02, 0x01, 0x0D, 0x17, 0x10, 0x19, 0x78, // "h" (U+0068)
  0x00, 0x69, 0x02, 0x01, 0x05, 0x17, 0x07, 0x19, 0xDF, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xFA, 0x05, 0x17, 0x07, 0x1A, 0x0A, // "j" (U+006A)
  0x00, 0x6B, 0x02, 0x01, 0x0D, 0x17, 0x0E, 0x1A, 0x4A, // "k" (U+006B)
  0x00, 0x6C, 0x02, 0x01, 0x04, 0x17, 0x07, 0x1A, 0xB1, // "l" (U+006C)
  0x00, 0x6D, 0x02, 0x01, 0x15, 0x11, 0x17, 0x1A, 0xD4, // "m" (U+006D)
  0x00, 0x6E, 0x02, 0x01, 0x0D, 0x11, 0x10, 0x1B, 0x5F, // "n" (U+006E)
  0x00, 0x6F, 0x01, 0x01, 0x0D, 0x11, 0x0F, 0x1B, 0xB7, // "o" (U+006F)
  0x00, 0x70, 0x02, 0xFA, 0x0E, 0x11, 0x10, 0x1C, 0x12, // "p" (U+0070)
  0x00, 0x71, 0x01, 0xFA, 0x0D, 0x11, 0x10, 0x1C, 0x8A, // "q" (U+0071)
  0x00, 0x72, 0x02, 0x01, 0x0A, 0x11, 0x0A, 0x1D, 0x05, // "r" (U+0072)
  0x00, 0x73, 0x01, 0x01, 0x0A, 0x11, 0x0C, 0x1D, 0x35, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x08, 0x15, 0x09, 0x1D, 0x76, // "t" (U+0074)
  0x00, 0x75, 0x02, 0x01, 0x0D, 0x11, 0x10, 0x1D, 0xBB, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x0C, 0x11, 0x0D, 0x1E, 0x0E, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x14, 0x11, 0x14, 0x1E, 0x63, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x0C, 0x11, 0x0D, 0x1E, 0xFC, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFA, 0x0C, 0x11, 0x0D, 0x1F, 0x51, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x0A, 0x11, 0x0B, 0x1F, 0xBF, // "z" (U+007A)
  0x00, 0x7B, 0x01, 0xFC, 0x09, 0x16, 0x0B, 0x1F, 0xF9, // "{" (U+007B)
  0x00, 0x7C, 0x05, 0xFA, 0x07, 0x17, 0x0E, 0x20, 0x47, // "|" (U+007C)
  0x00, 0x7D, 0x01, 0xFC, 0x0A, 0x16, 0x0B, 0x20, 0x74, // "}" (U+007D)
  0x00, 0x7E, 0x01, 0x0A, 0x0D, 0x0E, 0x0E, 0x20, 0xC2, // "~" (U+007E)
  0x00, 0xA1, 0x02, 0xFC, 0x05, 0x11, 0x08, 0x20, 0xDE, // "¡" (U+00A1)
  0x00, 0xA2, 0x02, 0x01, 0x0C, 0x16, 0x0E, 0x21, 0x0D, // "¢" (U+00A2)
  0x00, 0xA3, 0x01, 0x01, 0x0D, 0x16, 0x0E, 0x21, 0x5A, // "£" (U+00A3)
  0x00, 0xA4, 0x01, 0x04, 0x0E, 0x12, 0x11, 0x21, 0xB4, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x0D, 0x16, 0x0E, 0x22, 0x0E, // "¥" (U+00A5)
  0x00, 0xA6, 0x05, 0xFA, 0x07, 0x17, 0x0E, 0x22, 0x73, // "¦" (U+00A6)
  0x00, 0xA7, 0x01, 0x01, 0x0A, 0x17, 0x0D, 0x22, 0x99, // "§" (U+00A7)
  0x00, 0xA8, 0x04, 0x14, 0x0C, 0x16, 0x10, 0x22, 0xFA, // "¨" (U+00A8)
  0x00, 0xA9, 0x01, 0x01, 0x17, 0x17, 0x19, 0x23, 0x0A, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x0D, 0x08, 0x16, 0x0A, 0x23, 0xD5, // "ª" (U+00AA)
  0x00, 0xAB, 0x01, 0x02, 0x0D, 0x0F, 0x0F, 0x24, 0x04, // "«" (U+00AB)
  0x00, 0xAC, 0x01, 0x05, 0x0D, 0x0D, 0x0E, 0x24, 0x57, // "¬" (U+00AC)
  0x00, 0xAE, 0x01, 0x01, 0x17, 0x17, 0x19, 0x24, 0x76, // "®" (U+00AE)
  0x00, 0xAF, 0xFF, 0x18, 0x0D, 0x1A, 0x0E, 0x25, 0x4E, // "¯" (U+00AF)
  0x00, 0xB0, 0x01, 0x0E, 0x0A, 0x16, 0x0B, 0x25, 0x56, // "°" (U+00B0)
  0x00, 0xB1, 0x01, 0x01, 0x0D, 0x13, 0x0E, 0x25, 0x82, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x0D, 0x08, 0x19, 0x0A, 0x25, 0xB9, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x0D, 0x08, 0x19, 0x0A, 0x25, 0xE5, // "³" (U+00B3)
  0x00, 0xB4, 0x01, 0x14, 0x07, 0x18, 0x09, 0x26, 0x19, // "´" (U+00B4)
  0x00, 0xB5, 0x02, 0xFA, 0x0D, 0x11, 0x10, 0x26, 0x29, // "µ" (U+00B5)
  0x00, 0xB6, 0x01, 0xFC, 0x0D, 0x17, 0x10, 0x26, 0x8F, // "¶" (U+00B6)
  0x00, 0xB7, 0x01, 0x0A, 0x05, 0x0D, 0x07, 0x27, 0x19, // "·" (U+00B7)
  0x00, 0xB8, 0x00, 0xFA, 0x05, 0x01, 0x06, 0x27, 0x24, // "¸" (U+00B8)
  0x00, 0xB9, 0x01, 0x0D, 0x06, 0x19, 0x0A, 0x27, 0x3E, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x0D, 0x09, 0x16, 0x0A, 0x27, 0x5E, // "º" (U+00BA)
  0x00, 0xBB, 0x01, 0x02, 0x0D, 0x0F, 0x0F, 0x27, 0x92, // "»" (U+00BB)
  0x00, 0xBC, 0x01, 0x01, 0x15, 0x16, 0x16, 0x27, 0xE3, // "¼" (U+00BC)
  0x00, 0xBD, 0x01, 0x01, 0x15, 0x16, 0x17, 0x28, 0x8A, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x16, 0x17, 0x17, 0x29, 0x2D, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFB, 0x0A, 0x10, 0x0B, 0x29, 0xE9, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x0F, 0x1D, 0x10, 0x2A, 0x36, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x0F, 0x1D, 0x10, 0x2A, 0xBF, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x0F, 0x1D, 0x10, 0x2B, 0x46, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x0F, 0x1C, 0x10, 0x2B, 0xD5, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x0F, 0x1B, 0x10, 0x2C, 0x61, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x0F, 0x1C, 0x10, 0x2C, 0xE7, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x13, 0x16, 0x16, 0x2D, 0x76, // "Æ" (U+00C6)
  0x00, 0xC7, 0x01, 0xFA, 0x0E, 0x16, 0x0F, 0x2D, 0xF7, // "Ç" (U+00C7)
  0x00, 0xC8, 0x02, 0x01, 0x0C, 0x1D, 0x0E, 0x2E, 0x71, // "È" (U+00C8)
  0x00, 0xC9, 0x02, 0x01, 0x0C, 0x1D, 0x0E, 0x2E, 0xD1, // "É" (U+00C9)
  0x00, 0xCA, 0x02, 0x01, 0x0C, 0x1D, 0x0E, 0x2F, 0x2E, // "Ê" (U+00CA)
  0x00, 0xCB, 0x02, 0x01, 0x0C, 0x1B, 0x0E, 0x2F, 0x94, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x08, 0x1D, 0x09, 0x2F, 0xF2, // "Ì" (U+00CC)
  0x00, 0xCD, 0x01, 0x01, 0x09, 0x1D, 0x09, 0x30, 0x47, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x09, 0x1D, 0x09, 0x30, 0x9B, // "Î" (U+00CE)
  0x00, 0xCF, 0x01, 0x01, 0x09, 0x1B, 0x09, 0x30, 0xF8, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x10, 0x16, 0x12, 0x31, 0x4B, // "Ð" (U+00D0)
  0x00, 0xD1, 0x02, 0x01, 0x10, 0x1C, 0x13, 0x31, 0xCE, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x01, 0x01, 0x11, 0x1D, 0x13, 0x32, 0x76, // "Ò" (U+00D2)
  0x00, 0xD3, 0x01, 0x01, 0x11, 0x1D, 0x13, 0x33, 0x12, // "Ó" (U+00D3)
  0x00, 0xD4, 0x01, 0x01, 0x11, 0x1D, 0x13, 0x33, 0xAC, // "Ô" (U+00D4)
  0x00, 0xD5, 0x01, 0x01, 0x11, 0x1C, 0x13, 0x34, 0x4F, // "Õ" (U+00D5)
  0x00, 0xD6, 0x01, 0x01, 0x11, 0x1B, 0x13, 0x34, 0xEE, // "Ö" (U+00D6)
  0x00, 0xD7, 0x01, 0x05, 0x0C, 0x11, 0x0E, 0x35, 0x88, // "×" (U+00D7)
  0x00, 0xD8, 0x01, 0x00, 0x11, 0x17, 0x13, 0x35, 0xC9, // "Ø" (U+00D8)
  0x00, 0xD9, 0x02, 0x01, 0x0F, 0x1D, 0x12, 0x36, 0x71, // "Ù" (U+00D9)
  0x00, 0xDA, 0x02, 0x01, 0x0F, 0x1D, 0x12, 0x37, 0x00, // "Ú" (U+00DA)
  0x00, 0xDB, 0x02, 0x01, 0x0F, 0x1D, 0x12, 0x37, 0x8D, // "Û" (U+00DB)
  0x00, 0xDC, 0x02, 0x01, 0x0F, 0x1B, 0x12, 0x38, 0x22, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x0D, 0x1D, 0x0E, 0x38, 0xAE, // "Ý" (U+00DD)
  0x00, 0xDE, 0x02, 0x01, 0x0D, 0x16, 0x0F, 0x39, 0x25, // "Þ" (U+00DE)
  0x00, 0xDF, 0x02, 0x01, 0x0E, 0x17, 0x10, 0x39, 0x8B, // "ß" (U+00DF)
  0x00, 0xE0, 0x01, 0x01, 0x0C, 0x18, 0x0E, 0x3A, 0x08, // "à" (U+00E0)
  0x00, 0xE1, 0x01, 0x01, 0x0C, 0x18, 0x0E, 0x3A, 0x77, // "á" (U+00E1)
  0x00, 0xE2, 0x01, 0x01, 0x0C, 0x18, 0x0E, 0x3A, 0xE2, // "â" (U+00E2)
  0x00, 0xE3, 0x01, 0x01, 0x0C, 0x17, 0x0E, 0x3B, 0x56, // "ã" (U+00E3)
  0x00, 0xE4, 0x01, 0x01, 0x0C, 0x16, 0x0E, 0x3B, 0xC8, // "ä" (U+00E4)
  0x00, 0xE5, 0x01, 0x01, 0x0C, 0x1A, 0x0E, 0x3C, 0x34, // "å" (U+00E5)
  0x00, 0xE6, 0x01, 0x01, 0x14, 0x11, 0x16, 0x3C, 0xAE, // "æ" (U+00E6)
  0x00, 0xE7, 0x01, 0xFA, 0x0B, 0x11, 0x0C, 0x3D, 0x30, // "ç" (U+00E7)
  0x00, 0xE8, 0x01, 0x01, 0x0C, 0x18, 0x0E, 0x3D, 0x89, // "è" (U+00E8)
  0x00, 0xE9, 0x01, 0x01, 0x0C, 0x18, 0x0E, 0x3D, 0xEE, // "é" (U+00E9)
  0x00, 0xEA, 0x01, 0x01, 0x0C, 0x18, 0x0E, 0x3E, 0x4F, // "ê" (U+00EA)
  0x00, 0xEB, 0x01, 0x01, 0x0C, 0x16, 0x0E, 0x3E, 0xB8, // "ë" (U+00EB)
  0x00, 0xEC, 0xFF, 0x01, 0x05, 0x18, 0x07, 0x3F, 0x1A, // "ì" (U+00EC)
  0x00, 0xED, 0x02, 0x01, 0x08, 0x18, 0x07, 0x3F, 0x4F, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x08, 0x18, 0x07, 0x3F, 0x82, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x08, 0x16, 0x07, 0x3F, 0xBF, // "ï" (U+00EF)
  0x00, 0xF0, 0x01, 0x01, 0x0D, 0x18, 0x0F, 0x3F, 0xF2, // "ð" (U+00F0)
  0x00, 0xF1, 0x02, 0x01, 0x0D, 0x17, 0x10, 0x40, 0x6C, // "ñ" (U+00F1)
  0x00, 0xF2, 0x01, 0x01, 0x0D, 0x18, 0x0F, 0x40, 0xDD, // "ò" (U+00F2)
  0x00, 0xF3, 0x01, 0x01, 0x0D, 0x18, 0x0F, 0x41, 0x4E, // "ó" (U+00F3)
  0x00, 0xF4, 0x01, 0x01, 0x0D, 0x18, 0x0F, 0x41, 0xBC, // "ô" (U+00F4)
  0x00, 0xF5, 0x01, 0x01, 0x0D, 0x17, 0x0F, 0x42, 0x32, // "õ" (U+00F5)
  0x00, 0xF6, 0x01, 0x01, 0x0D, 0x16, 0x0F, 0x42, 0xA6, // "ö" (U+00F6)
  0x00, 0xF7, 0x01, 0x04, 0x0D, 0x12, 0x0E, 0x43, 0x14, // "÷" (U+00F7)
  0x00, 0xF8, 0x01, 0xFF, 0x0D, 0x12, 0x0F, 0x43, 0x40, // "ø" (U+00F8)
  0x00, 0xF9, 0x02, 0x01, 0x0D, 0x18, 0x10, 0x43, 0xB5, // "ù" (U+00F9)
  0x00, 0xFA, 0x02, 0x01, 0x0D, 0x18, 0x10, 0x44, 0x1E, // "ú" (U+00FA)
  0x00, 0xFB, 0x02, 0x01, 0x0D, 0x18, 0x10, 0x44, 0x83, // "û" (U+00FB)
  0x00, 0xFC, 0x02, 0x01, 0x0D, 0x16, 0x10, 0x44, 0xF1, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFA, 0x0C, 0x18, 0x0D, 0x45, 0x57, // "ý" (U+00FD)
  0x00, 0xFE, 0x02, 0xFA, 0x0E, 0x17, 0x10, 0x45, 0xD9, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFA, 0x0C, 0x16, 0x0D, 0x46, 0x5E, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x0F, 0x1B, 0x10, 0x46, 0xDF, // "Ā" (U+0100)
  0x01, 0x01, 0x01, 0x01, 0x0C, 0x16, 0x0E, 0x47, 0x5E, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x0F, 0x1D, 0x10, 0x47, 0xC3, // "Ă" (U+0102)
  0x01, 0x03, 0x01, 0x01, 0x0C, 0x18, 0x0E, 0x48, 0x52, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFA, 0x0F, 0x16, 0x10, 0x48, 0xC6, // "Ą" (U+0104)
  0x01, 0x05, 0x01, 0xFA, 0x0C, 0x11, 0x0E, 0x49, 0x51, // "ą" (U+0105)
  0x01, 0x06, 0x01, 0x01, 0x0E, 0x1D, 0x0F, 0x49, 0xC3, // "Ć" (U+0106)
  0x01, 0x07, 0x01, 0x01, 0x0B, 0x18, 0x0C, 0x4A, 0x35, // "ć" (U+0107)
  0x01, 0x08, 0x01, 0x01, 0x0E, 0x1D, 0x0F, 0x4A, 0x86, // "Ĉ" (U+0108)
  0x01, 0x09, 0x01, 0x01, 0x0B, 0x18, 0x0C, 0x4B, 0x00, // "ĉ" (U+0109)
  0x01, 0x0A, 0x01, 0x01, 0x0E, 0x1C, 0x0F, 0x4B, 0x5A, // "Ċ" (U+010A)
  0x01, 0x0B, 0x01, 0x01, 0x0B, 0x17, 0x0C, 0x4B, 0xC9, // "ċ" (U+010B)
  0x01, 0x0C, 0x01, 0x01, 0x0E, 0x1D, 0x0F, 0x4C, 0x17, // "Č" (U+010C)
  0x01, 0x0D, 0x01, 0x01, 0x0B, 0x18, 0x0C, 0x4C, 0x92, // "č" (U+010D)
  0x01, 0x0E, 0x02, 0x01, 0x10, 0x1D, 0x12, 0x4C, 0xEC, // "Ď" (U+010E)
  0x01, 0x0F, 0x01, 0x01, 0x12, 0x17, 0x10, 0x4D, 0x87, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x10, 0x16, 0x12, 0x4E, 0x14, // "Đ" (U+0110)
  0x01, 0x11, 0x01, 0x01, 0x0F, 0x17, 0x10, 0x4E, 0x97, // "đ" (U+0111)
  0x01, 0x12, 0x02, 0x01, 0x0C, 0x1B, 0x0E, 0x4F, 0x18, // "Ē" (U+0112)
  0x01, 0x13, 0x01, 0x01, 0x0C, 0x16, 0x0E, 0x4F, 0x70, // "ē" (U+0113)
  0x01, 0x14, 0x02, 0x01, 0x0C, 0x1D, 0x0E, 0x4F, 0xCB, // "Ĕ" (U+0114)
  0x01, 0x15, 0x01, 0x01, 0x0C, 0x18, 0x0E, 0x50, 0x31, // "ĕ" (U+0115)
  0x01, 0x16, 0x02, 0x01, 0x0C, 0x1C, 0x0E, 0x50, 0x9B, // "Ė" (U+0116)
  0x01, 0x17, 0x01, 0x01, 0x0C, 0x17, 0x0E, 0x50, 0xF5, // "ė" (U+0117)
  0x01, 0x18, 0x02, 0xFA, 0x0C, 0x16, 0x0E, 0x51, 0x54, // "Ę" (U+0118)
  0x01, 0x19, 0x01, 0xFA, 0x0C, 0x11, 0x0E, 0x51, 0xB7, // "ę" (U+0119)
  0x01, 0x1A, 0x02, 0x01, 0x0C, 0x1D, 0x0E, 0x52, 0x1D, // "Ě" (U+011A)
  0x01, 0x1B, 0x01, 0x01, 0x0C, 0x18, 0x0E, 0x52, 0x83, // "ě" (U+011B)
  0x01, 0x1C, 0x01, 0x01, 0x10, 0x1D, 0x12, 0x52, 0xED, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x01, 0xFA, 0x0D, 0x18, 0x10, 0x53, 0x7D, // "ĝ" (U+011D)
  0x01, 0x1E, 0x01, 0x01, 0x10, 0x1D, 0x12, 0x54, 0x1B, // "Ğ" (U+011E)
  0x01, 0x1F, 0x01, 0xFA, 0x0D, 0x18, 0x10, 0x54, 0xAA, // "ğ" (U+011F)
  0x01, 0x20, 0x01, 0x01, 0x10, 0x1C, 0x12, 0x55, 0x48, // "Ġ" (U+0120)
  0x01, 0x21, 0x01, 0xFA, 0x0D, 0x17, 0x10, 0x55, 0xCC, // "ġ" (U+0121)
  0x01, 0x22, 0x01, 0xFA, 0x10, 0x16, 0x12, 0x56, 0x5F, // "Ģ" (U+0122)
  0x01, 0x23, 0x01, 0xFA, 0x0D, 0x17, 0x10, 0x56, 0xE5, // "ģ" (U+0123)
  0x01, 0x24, 0x02, 0x01, 0x0F, 0x1D, 0x12, 0x57, 0x78, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x0D, 0x1F, 0x10, 0x58, 0x0A, // "ĥ" (U+0125)
  0x01, 0x26, 0xFF, 0x01, 0x12, 0x16, 0x12, 0x58, 0x94, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x0D, 0x17, 0x10, 0x59, 0x15, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x01, 0x09, 0x1C, 0x09, 0x59, 0x87, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFE, 0x01, 0x07, 0x17, 0x07, 0x59, 0xE0, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x08, 0x1B, 0x09, 0x5A, 0x18, // "Ī" (U+012A)
  0x01, 0x2B, 0xFF, 0x01, 0x07, 0x16, 0x07, 0x5A, 0x64, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x08, 0x1D, 0x09, 0x5A, 0x91, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFF, 0x01, 0x07, 0x18, 0x07, 0x5A, 0xEA, // "ĭ" (U+012D)
  0x01, 0x2E, 0x01, 0xFA, 0x08, 0x16, 0x09, 0x5B, 0x24, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFA, 0x05, 0x17, 0x07, 0x5B, 0x7A, // "į" (U+012F)
  0x01, 0x30, 0x01, 0x01, 0x08, 0x1C, 0x09, 0x5B, 0xBC, // "İ" (U+0130)
  0x01, 0x31, 0x02, 0x01, 0x04, 0x11, 0x07, 0x5C, 0x0B, // "ı" (U+0131)
  0x01, 0x32, 0x01, 0xFB, 0x0E, 0x16, 0x11, 0x5C, 0x25, // "Ĳ" (U+0132)
  0x01, 0x33, 0x02, 0xFA, 0x0C, 0x17, 0x0E, 0x5C, 0xBE, // "ĳ" (U+0133)
  0x01, 0x34, 0xFE, 0xFB, 0x08, 0x1D, 0x08, 0x5D, 0x2B, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFA, 0x08, 0x18, 0x07, 0x5D, 0x9E, // "ĵ" (U+0135)
  0x01, 0x36, 0x02, 0xFA, 0x0F, 0x16, 0x0F, 0x5D, 0xEF, // "Ķ" (U+0136)
  0x01, 0x37, 0x02, 0xFA, 0x0D, 0x17, 0x0E, 0x5E, 0x83, // "ķ" (U+0137)
  0x01, 0x38, 0x02, 0x01, 0x0D, 0x11, 0x0E, 0x5E, 0xFD, // "ĸ" (U+0138)
  0x01, 0x39, 0x02, 0x01, 0x0C, 0x1D, 0x0D, 0x5F, 0x55, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x02, 0x01, 0x08, 0x1F, 0x07, 0x5F, 0xAC, // "ĺ" (U+013A)
  0x01, 0x3B, 0x02, 0xFA, 0x0C, 0x16, 0x0D, 0x5F, 0xEC, // "Ļ" (U+013B)
  0x01, 0x3C, 0x01, 0xFA, 0x05, 0x17, 0x07, 0x60, 0x42, // "ļ" (U+013C)
  0x01, 0x3D, 0x02, 0x01, 0x0C, 0x16, 0x0D, 0x60, 0x7F, // "Ľ" (U+013D)
  0x01, 0x3E, 0x02, 0x01, 0x09, 0x17, 0x07, 0x60, 0xD0, // "ľ" (U+013E)
  0x01, 0x3F, 0x02, 0x01, 0x0C, 0x16, 0x0D, 0x61, 0x0B, // "Ŀ" (U+013F)
  0x01, 0x40, 0x02, 0x01, 0x09, 0x17, 0x09, 0x61, 0x5C, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x0C, 0x16, 0x0D, 0x61, 0x94, // "Ł" (U+0141)
  0x01, 0x42, 0xFF, 0x01, 0x07, 0x17, 0x08, 0x61, 0xEB, // "ł" (U+0142)
  0x01, 0x43, 0x02, 0x01, 0x10, 0x1D, 0x13, 0x62, 0x39, // "Ń" (U+0143)
  0x01, 0x44, 0x02, 0x01, 0x0D, 0x18, 0x10, 0x62, 0xDC, // "ń" (U+0144)
  0x01, 0x45, 0x02, 0xFA, 0x10, 0x16, 0x13, 0x63, 0x47, // "Ņ" (U+0145)
  0x01, 0x46, 0x02, 0xFA, 0x0D, 0x11, 0x10, 0x63, 0xE9, // "ņ" (U+0146)
  0x01, 0x47, 0x02, 0x01, 0x10, 0x1D, 0x13, 0x64, 0x54, // "Ň" (U+0147)
  0x01, 0x48, 0x02, 0x01, 0x0D, 0x18, 0x10, 0x64, 0xFF, // "ň" (U+0148)
  0x01, 0x49, 0xFF, 0x01, 0x0F, 0x16, 0x12, 0x65, 0x73, // "ŉ" (U+0149)
  0x01, 0x4A, 0x02, 0xFB, 0x10, 0x16, 0x13, 0x65, 0xE9, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x02, 0xFA, 0x0D, 0x11, 0x10, 0x66, 0x8F, // "ŋ" (U+014B)
  0x01, 0x4C, 0x01, 0x01, 0x11, 0x1B, 0x13, 0x67, 0x01, // "Ō" (U+014C)
  0x01, 0x4D, 0x01, 0x01, 0x0D, 0x16, 0x0F, 0x67, 0x95, // "ō" (U+014D)
  0x01, 0x4E, 0x01, 0x01, 0x11, 0x1D, 0x13, 0x67, 0xFC, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x01, 0x01, 0x0D, 0x18, 0x0F, 0x68, 0x9F, // "ŏ" (U+014F)
  0x01, 0x50, 0x01, 0x01, 0x11, 0x1D, 0x13, 0x69, 0x15, // "Ő" (U+0150)
  0x01, 0x51, 0x01, 0x01, 0x0E, 0x18, 0x0F, 0x69, 0xBC, // "ő" (U+0151)
  0x01, 0x52, 0x01, 0x01, 0x14, 0x16, 0x16, 0x6A, 0x3A, // "Œ" (U+0152)
  0x01, 0x53, 0x01, 0x01, 0x16, 0x11, 0x17, 0x6A, 0xC5, // "œ" (U+0153)
  0x01, 0x54, 0x02, 0x01, 0x0F, 0x1D, 0x10, 0x6B, 0x52, // "Ŕ" (U+0154)
  0x01, 0x55, 0x02, 0x01, 0x0A, 0x18, 0x0A, 0x6B, 0xE5, // "ŕ" (U+0155)
  0x01, 0x56, 0x02, 0xFA, 0x0F, 0x16, 0x10, 0x6C, 0x27, // "Ŗ" (U+0156)
  0x01, 0x57, 0x01, 0xFA, 0x0A, 0x11, 0x0A, 0x6C, 0xBA, // "ŗ" (U+0157)
  0x01, 0x58, 0x02, 0x01, 0x0F, 0x1D, 0x10, 0x6C, 0xFC, // "Ř" (U+0158)
  0x01, 0x59, 0x01, 0x01, 0x0A, 0x18, 0x0A, 0x6D, 0x98, // "ř" (U+0159)
  0x01, 0x5A, 0x01, 0x01, 0x0C, 0x1D, 0x0E, 0x6D, 0xE3, // "Ś" (U+015A)
  0x01, 0x5B, 0x01, 0x01, 0x0A, 0x18, 0x0C, 0x6E, 0x51, // "ś" (U+015B)
  0x01, 0x5C, 0x01, 0x01, 0x0C, 0x1D, 0x0E, 0x6E, 0xA3, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x01, 0x01, 0x0A, 0x18, 0x0C, 0x6F, 0x1A, // "ŝ" (U+015D)
  0x01, 0x5E, 0x01, 0xFA, 0x0C, 0x16, 0x0E, 0x6F, 0x75, // "Ş" (U+015E)
  0x01, 0x5F, 0x01, 0xFA, 0x0A, 0x11, 0x0C, 0x6F, 0xEC, // "ş" (U+015F)
  0x01, 0x60, 0x01, 0x01, 0x0C, 0x1D, 0x0E, 0x70, 0x45, // "Š" (U+0160)
  0x01, 0x61, 0x01, 0x01, 0x0A, 0x18, 0x0C, 0x70, 0xBD, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFA, 0x0C, 0x16, 0x0D, 0x71, 0x17, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFA, 0x08, 0x15, 0x09, 0x71, 0x81, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x0C, 0x1D, 0x0D, 0x71, 0xE0, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x0C, 0x17, 0x09, 0x72, 0x4B, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x0C, 0x16, 0x0D, 0x72, 0xA8, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x08, 0x15, 0x09, 0x72, 0xFA, // "ŧ" (U+0167)
  0x01, 0x68, 0x02, 0x01, 0x0F, 0x1C, 0x12, 0x73, 0x41, // "Ũ" (U+0168)
  0x01, 0x69, 0x02, 0x01, 0x0D, 0x17, 0x10, 0x73, 0xD3, // "ũ" (U+0169)
  0x01, 0x6A, 0x02, 0x01, 0x0F, 0x1B, 0x12, 0x74, 0x3F, // "Ū" (U+016A)
  0x01, 0x6B, 0x02, 0x01, 0x0D, 0x16, 0x10, 0x74, 0xC5, // "ū" (U+016B)
  0x01, 0x6C, 0x02, 0x01, 0x0F, 0x1D, 0x12, 0x75, 0x24, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x02, 0x01, 0x0D, 0x18, 0x10, 0x75, 0xB8, // "ŭ" (U+016D)
  0x01, 0x6E, 0x02, 0x01, 0x0F, 0x1F, 0x12, 0x76, 0x26, // "Ů" (U+016E)
  0x01, 0x6F, 0x02, 0x01, 0x0D, 0x1A, 0x10, 0x76, 0xC1, // "ů" (U+016F)
  0x01, 0x70, 0x02, 0x01, 0x0F, 0x1D, 0x12, 0x77, 0x34, // "Ű" (U+0170)
  0x01, 0x71, 0x02, 0x01, 0x0E, 0x18, 0x10, 0x77, 0xCD, // "ű" (U+0171)
  0x01, 0x72, 0x02, 0xFA, 0x0F, 0x16, 0x12, 0x78, 0x47, // "Ų" (U+0172)
  0x01, 0x73, 0x02, 0xFA, 0x0D, 0x11, 0x10, 0x78, 0xD9, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x17, 0x1D, 0x18, 0x79, 0x44, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x14, 0x18, 0x14, 0x7A, 0x30, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x0D, 0x1D, 0x0E, 0x7A, 0xE8, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFA, 0x0C, 0x18, 0x0D, 0x7B, 0x67, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x0D, 0x1B, 0x0E, 0x7B, 0xF0, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x0C, 0x1D, 0x0D, 0x7C, 0x67, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x0A, 0x18, 0x0B, 0x7C, 0xCB, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x0C, 0x1C, 0x0D, 0x7D, 0x16, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x0A, 0x17, 0x0B, 0x7D, 0x77, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x0C, 0x1D, 0x0D, 0x7D, 0xBF, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x0A, 0x18, 0x0B, 0x7E, 0x2B, // "ž" (U+017E)
  0x01, 0x7F, 0x02, 0x01, 0x09, 0x17, 0x08, 0x7E, 0x7F, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x12, 0x16, 0x13, 0x7E, 0xC6, // "Ω" (U+03A9)
  0x03, 0xBC, 0x02, 0xFA, 0x0D, 0x11, 0x10, 0x7F, 0x52, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x0F, 0x11, 0x11, 0x7F, 0xB8, // "π" (U+03C0)
  0x20, 0x13, 0x01, 0x08, 0x0D, 0x0A, 0x0F, 0x80, 0x1D, // "–" (U+2013)
  0x20, 0x14, 0x01, 0x08, 0x1C, 0x0A, 0x1E, 0x80, 0x27, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x0D, 0x16, 0x0E, 0x80, 0x33, // "€" (U+20AC)
  0x20, 0xBF, 0x02, 0xFE, 0x0D, 0x19, 0x0E, 0x80, 0x90, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x0F, 0x05, 0x16, 0x06, 0x81, 0x21, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x0F, 0x05, 0x16, 0x06, 0x81, 0x37, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0xFD, 0x05, 0x04, 0x07, 0x81, 0x4E, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x0F, 0x05, 0x16, 0x06, 0x81, 0x65, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x0F, 0x0A, 0x16, 0x0B, 0x81, 0x7B, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x0F, 0x0A, 0x16, 0x0B, 0x81, 0xA7, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0xFD, 0x0A, 0x04, 0x0C, 0x81, 0xD6, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x0F, 0x0A, 0x16, 0x0B, 0x82, 0x05, // "‟" (U+201F)
  0x20, 0x20, 0x01, 0x01, 0x0C, 0x17, 0x0E, 0x82, 0x31, // "†" (U+2020)
  0x20, 0x21, 0x01, 0x01, 0x0C, 0x17, 0x0E, 0x82, 0x85, // "‡" (U+2021)
  0x20, 0x22, 0x01, 0x08, 0x09, 0x10, 0x0B, 0x82, 0xDF, // "•" (U+2022)
  0x20, 0x26, 0x01, 0x01, 0x14, 0x04, 0x16, 0x82, 0xFA, // "…" (U+2026)
  0x20, 0x30, 0x01, 0x01, 0x1E, 0x16, 0x20, 0x83, 0x1F, // "‰" (U+2030)
  0x20, 0x39, 0x01, 0x02, 0x07, 0x0F, 0x09, 0x84, 0x2E, // "‹" (U+2039)
  0x20, 0x3A, 0x01, 0x02, 0x07, 0x0F, 0x09, 0x84, 0x59, // "›" (U+203A)
  0x20, 0x44, 0xFB, 0x01, 0x08, 0x16, 0x03, 0x84, 0x83, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x0C, 0x12, 0x16, 0x14, 0x84, 0xD2, // "™" (U+2122)
  0x21, 0x52, 0x01, 0x01, 0x1E, 0x16, 0x1F, 0x85, 0x37, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x0E, 0x17, 0x10, 0x86, 0x08, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x0D, 0x17, 0x10, 0x86, 0x82, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x02, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0x61, 0x01, // "a (U+0022 U+0061)
  0x00, 0x22, 0x00, 0x63, 0x01, // "c (U+0022 U+0063)
  0x00, 0x22, 0x00, 0x64, 0x01, // "d (U+0022 U+0064)
  0x00, 0x22, 0x00, 0x65, 0x01, // "e (U+0022 U+0065)
  0x00, 0x22, 0x00, 0x67, 0x01, // "g (U+0022 U+0067)
  0x00, 0x22, 0x00, 0x6D, 0x01, // "m (U+0022 U+006D)
  0x00, 0x22, 0x00, 0x6E, 0x01, // "n (U+0022 U+006E)
  0x00, 0x22, 0x00, 0x6F, 0x01, // "o (U+0022 U+006F)
  0x00, 0x22, 0x00, 0x70, 0x01, // "p (U+0022 U+0070)
  0x00, 0x22, 0x00, 0x71, 0x01, // "q (U+0022 U+0071)
  0x00, 0x22, 0x00, 0x72, 0x01, // "r (U+0022 U+0072)
  0x00, 0x22, 0x00, 0x73, 0x01, // "s (U+0022 U+0073)
  0x00, 0x22, 0x00, 0x75, 0x01, // "u (U+0022 U+0075)
  0x00, 0x22, 0x00, 0xC0, 0x02, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x02, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x02, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x02, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x02, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x02, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x02, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x00, 0xE0, 0x01, // "à (U+0022 U+00E0)
  0x00, 0x22, 0x00, 0xE1, 0x01, // "á (U+0022 U+00E1)
  0x00, 0x22, 0x00, 0xE2, 0x01, // "â (U+0022 U+00E2)
  0x00, 0x22, 0x00, 0xE3, 0x01, // "ã (U+0022 U+00E3)
  0x00, 0x22, 0x00, 0xE4, 0x01, // "ä (U+0022 U+00E4)
  0x00, 0x22, 0x00, 0xE5, 0x01, // "å (U+0022 U+00E5)
  0x00, 0x22, 0x00, 0xE6, 0x01, // "æ (U+0022 U+00E6)
  0x00, 0x22, 0x00, 0xE7, 0x01, // "ç (U+0022 U+00E7)
  0x00, 0x22, 0x00, 0xE8, 0x01, // "è (U+0022 U+00E8)
  0x00, 0x22, 0x00, 0xE9, 0x01, // "é (U+0022 U+00E9)
  0x00, 0x22, 0x00, 0xEA, 0x01, // "ê (U+0022 U+00EA)
  0x00, 0x22, 0x00, 0xEB, 0x01, // "ë (U+0022 U+00EB)
  0x00, 0x22, 0x00, 0xF2, 0x01, // "ò (U+0022 U+00F2)
  0x00, 0x22, 0x00, 0xF3, 0x01, // "ó (U+0022 U+00F3)
  0x00, 0x22, 0x00, 0xF4, 0x01, // "ô (U+0022 U+00F4)
  0x00, 0x22, 0x00, 0xF5, 0x01, // "õ (U+0022 U+00F5)
  0x00, 0x22, 0x00, 0xF6, 0x01, // "ö (U+0022 U+00F6)
  0x00, 0x22, 0x00, 0xF8, 0x01, // "ø (U+0022 U+00F8)
  0x00, 0x22, 0x00, 0xF9, 0x01, // "ù (U+0022 U+00F9)
  0x00, 0x22, 0x00, 0xFA, 0x01, // "ú (U+0022 U+00FA)
  0x00, 0x22, 0x00, 0xFB, 0x01, // "û (U+0022 U+00FB)
  0x00, 0x22, 0x00, 0xFC, 0x01, // "ü (U+0022 U+00FC)
  0x00, 0x22, 0x01, 0x00, 0x02, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x01, 0x01, // "ā (U+0022 U+0101)
  0x00, 0x22, 0x01, 0x02, 0x02, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x03, 0x01, // "ă (U+0022 U+0103)
  0x00, 0x22, 0x01, 0x04, 0x02, // "Ą (U+0022 U+0104)
  0x00, 0x22, 0x01, 0x05, 0x01, // "ą (U+0022 U+0105)
  0x00, 0x22, 0x01, 0x07, 0x01, // "ć (U+0022 U+0107)
  0x00, 0x22, 0x01, 0x09, 0x01, // "ĉ (U+0022 U+0109)
  0x00, 0x22, 0x01, 0x0B, 0x01, // "ċ (U+0022 U+010B)
  0x00, 0x22, 0x01, 0x0D, 0x01, // "č (U+0022 U+010D)
  0x00, 0x22, 0x01, 0x0F, 0x01, // "ď (U+0022 U+010F)
  0x00, 0x22, 0x01, 0x11, 0x01, // "đ (U+0022 U+0111)
  0x00, 0x22, 0x01, 0x13, 0x01, // "ē (U+0022 U+0113)
  0x00, 0x22, 0x01, 0x15, 0x01, // "ĕ (U+0022 U+0115)
  0x00, 0x22, 0x01, 0x17, 0x01, // "ė (U+0022 U+0117)
  0x00, 0x22, 0x01, 0x19, 0x01, // "ę (U+0022 U+0119)
  0x00, 0x22, 0x01, 0x1B, 0x01, // "ě (U+0022 U+011B)
  0x00, 0x22, 0x01, 0x1D, 0x01, // "ĝ (U+0022 U+011D)
  0x00, 0x22, 0x01, 0x1F, 0x01, // "ğ (U+0022 U+011F)
  0x00, 0x22, 0x01, 0x21, 0x01, // "ġ (U+0022 U+0121)
  0x00, 0x22, 0x01, 0x23, 0x01, // "ģ (U+0022 U+0123)
  0x00, 0x22, 0x01, 0x38, 0x01, // "ĸ (U+0022 U+0138)
  0x00, 0x22, 0x01, 0x44, 0x01, // "ń (U+0022 U+0144)
  0x00, 0x22, 0x01, 0x46, 0x01, // "ņ (U+0022 U+0146)
  0x00, 0x22, 0x01, 0x4B, 0x01, // "ŋ (U+0022 U+014B)
  0x00, 0x22, 0x01, 0x4D, 0x01, // "ō (U+0022 U+014D)
  0x00, 0x22, 0x01, 0x4F, 0x01, // "ŏ (U+0022 U+014F)
  0x00, 0x22, 0x01, 0x51, 0x01, // "ő (U+0022 U+0151)
  0x00, 0x22, 0x01, 0x53, 0x01, // "œ (U+0022 U+0153)
  0x00, 0x22, 0x01, 0x55, 0x01, // "ŕ (U+0022 U+0155)
  0x00, 0x22, 0x01, 0x57, 0x01, // "ŗ (U+0022 U+0157)
  0x00, 0x22, 0x01, 0x5B, 0x01, // "ś (U+0022 U+015B)
  0x00, 0x22, 0x01, 0x5F, 0x01, // "ş (U+0022 U+015F)
  0x00, 0x22, 0x01, 0x69, 0x01, // "ũ (U+0022 U+0169)
  0x00, 0x22, 0x01, 0x6B, 0x01, // "ū (U+0022 U+016B)
  0x00, 0x22, 0x01, 0x6D, 0x01, // "ŭ (U+0022 U+016D)
  0x00, 0x22, 0x01, 0x6F, 0x01, // "ů (U+0022 U+016F)
  0x00, 0x22, 0x01, 0x71, 0x01, // "ű (U+0022 U+0171)
  0x00, 0x22, 0x01, 0x73, 0x01, // "ų (U+0022 U+0173)
  0x00, 0x26, 0x00, 0x54, 0x01, // &T (U+0026 U+0054)
  0x00, 0x26, 0x00, 0x59, 0x01, // &Y (U+0026 U+0059)
  0x00, 0x26, 0x00, 0xDD, 0x01, // &Ý (U+0026 U+00DD)
  0x00, 0x26, 0x01, 0x62, 0x01, // &Ţ (U+0026 U+0162)
  0x00, 0x26, 0x01, 0x64, 0x01, // &Ť (U+0026 U+0164)
  0x00, 0x26, 0x01, 0x66, 0x01, // &Ŧ (U+0026 U+0166)
  0x00, 0x26, 0x01, 0x76, 0x01, // &Ŷ (U+0026 U+0176)
  0x00, 0x26, 0x01, 0x78, 0x01, // &Ÿ (U+0026 U+0178)
  0x00, 0x27, 0x00, 0x41, 0x02, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0x61, 0x01, // 'a (U+0027 U+0061)
  0x00, 0x27, 0x00, 0x63, 0x01, // 'c (U+0027 U+0063)
  0x00, 0x27, 0x00, 0x64, 0x01, // 'd (U+0027 U+0064)
  0x00, 0x27, 0x00, 0x65, 0x01, // 'e (U+0027 U+0065)
  0x00, 0x27, 0x00, 0x67, 0x01, // 'g (U+0027 U+0067)
  0x00, 0x27, 0x00, 0x6D, 0x01, // 'm (U+0027 U+006D)
  0x00, 0x27, 0x00, 0x6E, 0x01, // 'n (U+0027 U+006E)
  0x00, 0x27, 0x00, 0x6F, 0x01, // 'o (U+0027 U+006F)
  0x00, 0x27, 0x00, 0x70, 0x01, // 'p (U+0027 U+0070)
  0x00, 0x27, 0x00, 0x71, 0x01, // 'q (U+0027 U+0071)
  0x00, 0x27, 0x00, 0x72, 0x01, // 'r (U+0027 U+0072)
  0x00, 0x27, 0x00, 0x73, 0x01, // 's (U+0027 U+0073)
  0x00, 0x27, 0x00, 0x75, 0x01, // 'u (U+0027 U+0075)
  0x00, 0x27, 0x00, 0xC0, 0x02, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x02, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x02, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x02, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x02, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x02, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x02, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x00, 0xE0, 0x01, // 'à (U+0027 U+00E0)
  0x00, 0x27, 0x00, 0xE1, 0x01, // 'á (U+0027 U+00E1)
  0x00, 0x27, 0x00, 0xE2, 0x01, // 'â (U+0027 U+00E2)
  0x00, 0x27, 0x00, 0xE3, 0x01, // 'ã (U+0027 U+00E3)
  0x00, 0x27, 0x00, 0xE4, 0x01, // 'ä (U+0027 U+00E4)
  0x00, 0x27, 0x00, 0xE5, 0x01, // 'å (U+0027 U+00E5)
  0x00, 0x27, 0x00, 0xE6, 0x01, // 'æ (U+0027 U+00E6)
  0x00, 0x27, 0x00, 0xE7, 0x01, // 'ç (U+0027 U+00E7)
  0x00, 0x27, 0x00, 0xE8, 0x01, // 'è (U+0027 U+00E8)
  0x00, 0x27, 0x00, 0xE9, 0x01, // 'é (U+0027 U+00E9)
  0x00, 0x27, 0x00, 0xEA, 0x01, // 'ê (U+0027 U+00EA)
  0x00, 0x27, 0x00, 0xEB, 0x01, // 'ë (U+0027 U+00EB)
  0x00, 0x27, 0x00, 0xF2, 0x01, // 'ò (U+0027 U+00F2)
  0x00, 0x27, 0x00, 0xF3, 0x01, // 'ó (U+0027 U+00F3)
  0x00, 0x27, 0x00, 0xF4, 0x01, // 'ô (U+0027 U+00F4)
  0x00, 0x27, 0x00, 0xF5, 0x01, // 'õ (U+0027 U+00F5)
  0x00, 0x27, 0x00, 0xF6, 0x01, // 'ö (U+0027 U+00F6)
  0x00, 0x27, 0x00, 0xF8, 0x01, // 'ø (U+0027 U+00F8)
  0x00, 0x27, 0x00, 0xF9, 0x01, // 'ù (U+0027 U+00F9)
  0x00, 0x27, 0x00, 0xFA, 0x01, // 'ú (U+0027 U+00FA)
  0x00, 0x27, 0x00, 0xFB, 0x01, // 'û (U+0027 U+00FB)
  0x00, 0x27, 0x00, 0xFC, 0x01, // 'ü (U+0027 U+00FC)
  0x00, 0x27, 0x01, 0x00, 0x02, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x01, 0x01, // 'ā (U+0027 U+0101)
  0x00, 0x27, 0x01, 0x02, 0x02, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x03, 0x01, // 'ă (U+0027 U+0103)
  0x00, 0x27, 0x01, 0x04, 0x02, // 'Ą (U+0027 U+0104)
  0x00, 0x27, 0x01, 0x05, 0x01, // 'ą (U+0027 U+0105)
  0x00, 0x27, 0x01, 0x07, 0x01, // 'ć (U+0027 U+0107)
  0x00, 0x27, 0x01, 0x09, 0x01, // 'ĉ (U+0027 U+0109)
  0x00, 0x27, 0x01, 0x0B, 0x01, // 'ċ (U+0027 U+010B)
  0x00, 0x27, 0x01, 0x0D, 0x01, // 'č (U+0027 U+010D)
  0x00, 0x27, 0x01, 0x0F, 0x01, // 'ď (U+0027 U+010F)
  0x00, 0x27, 0x01, 0x11, 0x01, // 'đ (U+0027 U+0111)
  0x00, 0x27, 0x01, 0x13, 0x01, // 'ē (U+0027 U+0113)
  0x00, 0x27, 0x01, 0x15, 0x01, // 'ĕ (U+0027 U+0115)
  0x00, 0x27, 0x01, 0x17, 0x01, // 'ė (U+0027 U+0117)
  0x00, 0x27, 0x01, 0x19, 0x01, // 'ę (U+0027 U+0119)
  0x00, 0x27, 0x01, 0x1B, 0x01, // 'ě (U+0027 U+011B)
  0x00, 0x27, 0x01, 0x1D, 0x01, // 'ĝ (U+0027 U+011D)
  0x00, 0x27, 0x01, 0x1F, 0x01, // 'ğ (U+0027 U+011F)
  0x00, 0x27, 0x01, 0x21, 0x01, // 'ġ (U+0027 U+0121)
  0x00, 0x27, 0x01, 0x23, 0x01, // 'ģ (U+0027 U+0123)
  0x00, 0x27, 0x01, 0x38, 0x01, // 'ĸ (U+0027 U+0138)
  0x00, 0x27, 0x01, 0x44, 0x01, // 'ń (U+0027 U+0144)
  0x00, 0x27, 0x01, 0x46, 0x01, // 'ņ (U+0027 U+0146)
  0x00, 0x27, 0x01, 0x4B, 0x01, // 'ŋ (U+0027 U+014B)
  0x00, 0x27, 0x01, 0x4D, 0x01, // 'ō (U+0027 U+014D)
  0x00, 0x27, 0x01, 0x4F, 0x01, // 'ŏ (U+0027 U+014F)
  0x00, 0x27, 0x01, 0x51, 0x01, // 'ő (U+0027 U+0151)
  0x00, 0x27, 0x01, 0x53, 0x01, // 'œ (U+0027 U+0153)
  0x00, 0x27, 0x01, 0x55, 0x01, // 'ŕ (U+0027 U+0155)
  0x00, 0x27, 0x01, 0x57, 0x01, // 'ŗ (U+0027 U+0157)
  0x00, 0x27, 0x01, 0x5B, 0x01, // 'ś (U+0027 U+015B)
  0x00, 0x27, 0x01, 0x5F, 0x01, // 'ş (U+0027 U+015F)
  0x00, 0x27, 0x01, 0x69, 0x01, // 'ũ (U+0027 U+0169)
  0x00, 0x27, 0x01, 0x6B, 0x01, // 'ū (U+0027 U+016B)
  0x00, 0x27, 0x01, 0x6D, 0x01, // 'ŭ (U+0027 U+016D)
  0x00, 0x27, 0x01, 0x6F, 0x01, // 'ů (U+0027 U+016F)
  0x00, 0x27, 0x01, 0x71, 0x01, // 'ű (U+0027 U+0171)
  0x00, 0x27, 0x01, 0x73, 0x01, // 'ų (U+0027 U+0173)
  0x00, 0x2C, 0x00, 0x43, 0x01, // ,C (U+002C U+0043)
  0x00, 0x2C, 0x00, 0x47, 0x01, // ,G (U+002C U+0047)
  0x00, 0x2C, 0x00, 0x4F, 0x01, // ,O (U+002C U+004F)
  0x00, 0x2C, 0x00, 0x51, 0x01, // ,Q (U+002C U+0051)
  0x00, 0x2C, 0x00, 0x54, 0x02, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x00, 0x56, 0x01, // ,V (U+002C U+0056)
  0x00, 0x2C, 0x00, 0x57, 0x01, // ,W (U+002C U+0057)
  0x00, 0x2C, 0x00, 0x59, 0x01, // ,Y (U+002C U+0059)
  0x00, 0x2C, 0x00, 0xC7, 0x01, // ,Ç (U+002C U+00C7)
  0x00, 0x2C, 0x00, 0xD2, 0x01, // ,Ò (U+002C U+00D2)
  0x00, 0x2C, 0x00, 0xD3, 0x01, // ,Ó (U+002C U+00D3)
  0x00, 0x2C, 0x00, 0xD4, 0x01, // ,Ô (U+002C U+00D4)
  0x00, 0x2C, 0x00, 0xD5, 0x01, // ,Õ (U+002C U+00D5)
  0x00, 0x2C, 0x00, 0xD6, 0x01, // ,Ö (U+002C U+00D6)
  0x00, 0x2C, 0x00, 0xD8, 0x01, // ,Ø (U+002C U+00D8)
  0x00, 0x2C, 0x00, 0xDD, 0x01, // ,Ý (U+002C U+00DD)
  0x00, 0x2C, 0x01, 0x06, 0x01, // ,Ć (U+002C U+0106)
  0x00, 0x2C, 0x01, 0x08, 0x01, // ,Ĉ (U+002C U+0108)
  0x00, 0x2C, 0x01, 0x0A, 0x01, // ,Ċ (U+002C U+010A)
  0x00, 0x2C, 0x01, 0x0C, 0x01, // ,Č (U+002C U+010C)
  0x00, 0x2C, 0x01, 0x1C, 0x01, // ,Ĝ (U+002C U+011C)
  0x00, 0x2C, 0x01, 0x1E, 0x01, // ,Ğ (U+002C U+011E)
  0x00, 0x2C, 0x01, 0x20, 0x01, // ,Ġ (U+002C U+0120)
  0x00, 0x2C, 0x01, 0x22, 0x01, // ,Ģ (U+002C U+0122)
  0x00, 0x2C, 0x01, 0x4C, 0x01, // ,Ō (U+002C U+014C)
  0x00, 0x2C, 0x01, 0x4E, 0x01, // ,Ŏ (U+002C U+014E)
  0x00, 0x2C, 0x01, 0x50, 0x01, // ,Ő (U+002C U+0150)
  0x00, 0x2C, 0x01, 0x52, 0x01, // ,Œ (U+002C U+0152)
  0x00, 0x2C, 0x01, 0x62, 0x02, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x02, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x02, // ,Ŧ (U+002C U+0166)
  0x00, 0x2C, 0x01, 0x74, 0x01, // ,Ŵ (U+002C U+0174)
  0x00, 0x2C, 0x01, 0x76, 0x01, // ,Ŷ (U+002C U+0176)
  0x00, 0x2C, 0x01, 0x78, 0x01, // ,Ÿ (U+002C U+0178)
  0x00, 0x2D, 0x00, 0x54, 0x01, // -T (U+002D U+0054)
  0x00, 0x2D, 0x01, 0x62, 0x01, // -Ţ (U+002D U+0162)
  0x00, 0x2D, 0x01, 0x64, 0x01, // -Ť (U+002D U+0164)
  0x00, 0x2D, 0x01, 0x66, 0x01, // -Ŧ (U+002D U+0166)
  0x00, 0x2E, 0x00, 0x43, 0x01, // .C (U+002E U+0043)
  0x00, 0x2E, 0x00, 0x47, 0x01, // .G (U+002E U+0047)
  0x00, 0x2E, 0x00, 0x4F, 0x01, // .O (U+002E U+004F)
  0x00, 0x2E, 0x00, 0x51, 0x01, // .Q (U+002E U+0051)
  0x00, 0x2E, 0x00, 0x54, 0x02, // .T (U+002E U+0054)
  0x00, 0x2E, 0x00, 0x56, 0x01, // .V (U+002E U+0056)
  0x00, 0x2E, 0x00, 0x57, 0x01, // .W (U+002E U+0057)
  0x00, 0x2E, 0x00, 0x59, 0x01, // .Y (U+002E U+0059)
  0x00, 0x2E, 0x00, 0xC7, 0x01, // .Ç (U+002E U+00C7)
  0x00, 0x2E, 0x00, 0xD2, 0x01, // .Ò (U+002E U+00D2)
  0x00, 0x2E, 0x00, 0xD3, 0x01, // .Ó (U+002E U+00D3)
  0x00, 0x2E, 0x00, 0xD4, 0x01, // .Ô (U+002E U+00D4)
  0x00, 0x2E, 0x00, 0xD5, 0x01, // .Õ (U+002E U+00D5)
  0x00, 0x2E, 0x00, 0xD6, 0x01, // .Ö (U+002E U+00D6)
  0x00, 0x2E, 0x00, 0xD8, 0x01, // .Ø (U+002E U+00D8)
  0x00, 0x2E, 0x00, 0xDD, 0x01, // .Ý (U+002E U+00DD)
  0x00, 0x2E, 0x01, 0x06, 0x01, // .Ć (U+002E U+0106)
  0x00, 0x2E, 0x01, 0x08, 0x01, // .Ĉ (U+002E U+0108)
  0x00, 0x2E, 0x01, 0x0A, 0x01, // .Ċ (U+002E U+010A)
  0x00, 0x2E, 0x01, 0x0C, 0x01, // .Č (U+002E U+010C)
  0x00, 0x2E, 0x01, 0x1C, 0x01, // .Ĝ (U+002E U+011C)
  0x00, 0x2E, 0x01, 0x1E, 0x01, // .Ğ (U+002E U+011E)
  0x00, 0x2E, 0x01, 0x20, 0x01, // .Ġ (U+002E U+0120)
  0x00, 0x2E, 0x01, 0x22, 0x01, // .Ģ (U+002E U+0122)
  0x00, 0x2E, 0x01, 0x4C, 0x01, // .Ō (U+002E U+014C)
  0x00, 0x2E, 0x01, 0x4E, 0x01, // .Ŏ (U+002E U+014E)
  0x00, 0x2E, 0x01, 0x50, 0x01, // .Ő (U+002E U+0150)
  0x00, 0x2E, 0x01, 0x52, 0x01, // .Œ (U+002E U+0152)
  0x00, 0x2E, 0x01, 0x62, 0x02, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x02, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x02, // .Ŧ (U+002E U+0166)
  0x00, 0x2E, 0x01, 0x74, 0x01, // .Ŵ (U+002E U+0174)
  0x00, 0x2E, 0x01, 0x76, 0x01, // .Ŷ (U+002E U+0176)
  0x00, 0x2E, 0x01, 0x78, 0x01, // .Ÿ (U+002E U+0178)
  0x00, 0x30, 0x20, 0x44, 0x04, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x04, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x04, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x04, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x04, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x04, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x04, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x04, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x04, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x04, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x02, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x02, // A' (U+0041 U+0027)
  0x00, 0x41, 0x00, 0x54, 0x01, // AT (U+0041 U+0054)
  0x00, 0x41, 0x00, 0x59, 0x01, // AY (U+0041 U+0059)
  0x00, 0x41, 0x00, 0xDD, 0x01, // AÝ (U+0041 U+00DD)
  0x00, 0x41, 0x01, 0x62, 0x01, // AŢ (U+0041 U+0162)
  0x00, 0x41, 0x01, 0x64, 0x01, // AŤ (U+0041 U+0164)
  0x00, 0x41, 0x01, 0x66, 0x01, // AŦ (U+0041 U+0166)
  0x00, 0x41, 0x01, 0x76, 0x01, // AŶ (U+0041 U+0176)
  0x00, 0x41, 0x01, 0x78, 0x01, // AŸ (U+0041 U+0178)
  0x00, 0x41, 0x20, 0x19, 0x02, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x02, // A” (U+0041 U+201D)
  0x00, 0x43, 0x00, 0x43, 0x01, // CC (U+0043 U+0043)
  0x00, 0x43, 0x00, 0x47, 0x01, // CG (U+0043 U+0047)
  0x00, 0x43, 0x00, 0x4F, 0x01, // CO (U+0043 U+004F)
  0x00, 0x43, 0x00, 0x51, 0x01, // CQ (U+0043 U+0051)
  0x00, 0x43, 0x00, 0xC7, 0x01, // CÇ (U+0043 U+00C7)
  0x00, 0x43, 0x00, 0xD2, 0x01, // CÒ (U+0043 U+00D2)
  0x00, 0x43, 0x00, 0xD3, 0x01, // CÓ (U+0043 U+00D3)
  0x00, 0x43, 0x00, 0xD4, 0x01, // CÔ (U+0043 U+00D4)
  0x00, 0x43, 0x00, 0xD5, 0x01, // CÕ (U+0043 U+00D5)
  0x00, 0x43, 0x00, 0xD6, 0x01, // CÖ (U+0043 U+00D6)
  0x00, 0x43, 0x00, 0xD8, 0x01, // CØ (U+0043 U+00D8)
  0x00, 0x43, 0x01, 0x06, 0x01, // CĆ (U+0043 U+0106)
  0x00, 0x43, 0x01, 0x08, 0x01, // CĈ (U+0043 U+0108)
  0x00, 0x43, 0x01, 0x0A, 0x01, // CĊ (U+0043 U+010A)
  0x00, 0x43, 0x01, 0x0C, 0x01, // CČ (U+0043 U+010C)
  0x00, 0x43, 0x01, 0x1C, 0x01, // CĜ (U+0043 U+011C)
  0x00, 0x43, 0x01, 0x1E, 0x01, // CĞ (U+0043 U+011E)
  0x00, 0x43, 0x01, 0x20, 0x01, // CĠ (U+0043 U+0120)
  0x00, 0x43, 0x01, 0x22, 0x01, // CĢ (U+0043 U+0122)
  0x00, 0x43, 0x01, 0x4C, 0x01, // CŌ (U+0043 U+014C)
  0x00, 0x43, 0x01, 0x4E, 0x01, // CŎ (U+0043 U+014E)
  0x00, 0x43, 0x01, 0x50, 0x01, // CŐ (U+0043 U+0150)
  0x00, 0x43, 0x01, 0x52, 0x01, // CŒ (U+0043 U+0152)
  0x00, 0x44, 0x00, 0x2C, 0x01, // D, (U+0044 U+002C)
  0x00, 0x44, 0x00, 0x2E, 0x01, // D. (U+0044 U+002E)
  0x00, 0x44, 0x20, 0x1A, 0x01, // D‚ (U+0044 U+201A)
  0x00, 0x44, 0x20, 0x1E, 0x01, // D„ (U+0044 U+201E)
  0x00, 0x44, 0x20, 0x26, 0x01, // D… (U+0044 U+2026)
  0x00, 0x46, 0x00, 0x2C, 0x02, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x02, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x02, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x02, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x02, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x02, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x02, // L' (U+004C U+0027)
  0x00, 0x4C, 0x00, 0x54, 0x01, // LT (U+004C U+0054)
  0x00, 0x4C, 0x00, 0x56, 0x01, // LV (U+004C U+0056)
  0x00, 0x4C, 0x00, 0x57, 0x01, // LW (U+004C U+0057)
  0x00, 0x4C, 0x00, 0x59, 0x01, // LY (U+004C U+0059)
  0x00, 0x4C, 0x00, 0xDD, 0x01, // LÝ (U+004C U+00DD)
  0x00, 0x4C, 0x01, 0x62, 0x01, // LŢ (U+004C U+0162)
  0x00, 0x4C, 0x01, 0x64, 0x01, // LŤ (U+004C U+0164)
  0x00, 0x4C, 0x01, 0x66, 0x01, // LŦ (U+004C U+0166)
  0x00, 0x4C, 0x01, 0x74, 0x01, // LŴ (U+004C U+0174)
  0x00, 0x4C, 0x01, 0x76, 0x01, // LŶ (U+004C U+0176)
  0x00, 0x4C, 0x01, 0x78, 0x01, // LŸ (U+004C U+0178)
  0x00, 0x4C, 0x20, 0x19, 0x02, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x02, // L” (U+004C U+201D)
  0x00, 0x4F, 0x00, 0x2C, 0x01, // O, (U+004F U+002C)
  0x00, 0x4F, 0x00, 0x2E, 0x01, // O. (U+004F U+002E)
  0x00, 0x4F, 0x20, 0x1A, 0x01, // O‚ (U+004F U+201A)
  0x00, 0x4F, 0x20, 0x1E, 0x01, // O„ (U+004F U+201E)
  0x00, 0x4F, 0x20, 0x26, 0x01, // O… (U+004F U+2026)
  0x00, 0x50, 0x00, 0x2C, 0x03, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x03, // P. (U+0050 U+002E)
  0x00, 0x50, 0x00, 0x41, 0x01, // PA (U+0050 U+0041)
  0x00, 0x50, 0x00, 0xC0, 0x01, // PÀ (U+0050 U+00C0)
  0x00, 0x50, 0x00, 0xC1, 0x01, // PÁ (U+0050 U+00C1)
  0x00, 0x50, 0x00, 0xC2, 0x01, // PÂ (U+0050 U+00C2)
  0x00, 0x50, 0x00, 0xC3, 0x01, // PÃ (U+0050 U+00C3)
  0x00, 0x50, 0x00, 0xC4, 0x01, // PÄ (U+0050 U+00C4)
  0x00, 0x50, 0x00, 0xC5, 0x01, // PÅ (U+0050 U+00C5)
  0x00, 0x50, 0x00, 0xC6, 0x01, // PÆ (U+0050 U+00C6)
  0x00, 0x50, 0x01, 0x00, 0x01, // PĀ (U+0050 U+0100)
  0x00, 0x50, 0x01, 0x02, 0x01, // PĂ (U+0050 U+0102)
  0x00, 0x50, 0x01, 0x04, 0x01, // PĄ (U+0050 U+0104)
  0x00, 0x50, 0x20, 0x1A, 0x03, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x03, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x03, // P… (U+0050 U+2026)
  0x00, 0x51, 0x00, 0x2C, 0x01, // Q, (U+0051 U+002C)
  0x00, 0x51, 0x00, 0x2E, 0x01, // Q. (U+0051 U+002E)
  0x00, 0x51, 0x20, 0x1A, 0x01, // Q‚ (U+0051 U+201A)
  0x00, 0x51, 0x20, 0x1E, 0x01, // Q„ (U+0051 U+201E)
  0x00, 0x51, 0x20, 0x26, 0x01, // Q… (U+0051 U+2026)
  0x00, 0x54, 0x00, 0x2C, 0x01, // T, (U+0054 U+002C)
  0x00, 0x54, 0x00, 0x2D, 0x01, // T- (U+0054 U+002D)
  0x00, 0x54, 0x00, 0x2E, 0x01, // T. (U+0054 U+002E)
  0x00, 0x54, 0x00, 0x41, 0x01, // TA (U+0054 U+0041)
  0x00, 0x54, 0x00, 0x61, 0x02, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x02, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x02, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x02, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x02, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6D, 0x01, // Tm (U+0054 U+006D)
  0x00, 0x54, 0x00, 0x6E, 0x01, // Tn (U+0054 U+006E)
  0x00, 0x54, 0x00, 0x6F, 0x02, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x70, 0x01, // Tp (U+0054 U+0070)
  0x00, 0x54, 0x00, 0x71, 0x02, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0x72, 0x01, // Tr (U+0054 U+0072)
  0x00, 0x54, 0x00, 0x73, 0x01, // Ts (U+0054 U+0073)
  0x00, 0x54, 0x00, 0x75, 0x01, // Tu (U+0054 U+0075)
  0x00, 0x54, 0x00, 0x7A, 0x01, // Tz (U+0054 U+007A)
  0x00, 0x54, 0x00, 0xAB, 0x01, // T« (U+0054 U+00AB)
  0x00, 0x54, 0x00, 0xBB, 0x01, // T» (U+0054 U+00BB)
  0x00, 0x54, 0x00, 0xC0, 0x01, // TÀ (U+0054 U+00C0)
  0x00, 0x54, 0x00, 0xC1, 0x01, // TÁ (U+0054 U+00C1)
  0x00, 0x54, 0x00, 0xC2, 0x01, // TÂ (U+0054 U+00C2)
  0x00, 0x54, 0x00, 0xC3, 0x01, // TÃ (U+0054 U+00C3)
  0x00, 0x54, 0x00, 0xC4, 0x01, // TÄ (U+0054 U+00C4)
  0x00, 0x54, 0x00, 0xC5, 0x01, // TÅ (U+0054 U+00C5)
  0x00, 0x54, 0x00, 0xE0, 0x02, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x02, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x02, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x02, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x02, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x02, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x02, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x02, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x02, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x02, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x02, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x02, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x02, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x02, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x02, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x02, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x02, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x02, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x00, 0xF9, 0x01, // Tù (U+0054 U+00F9)
  0x00, 0x54, 0x00, 0xFA, 0x01, // Tú (U+0054 U+00FA)
  0x00, 0x54, 0x00, 0xFB, 0x01, // Tû (U+0054 U+00FB)
  0x00, 0x54, 0x00, 0xFC, 0x01, // Tü (U+0054 U+00FC)
  0x00, 0x54, 0x01, 0x00, 0x01, // TĀ (U+0054 U+0100)
  0x00, 0x54, 0x01, 0x01, 0x02, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x02, 0x01, // TĂ (U+0054 U+0102)
  0x00, 0x54, 0x01, 0x03, 0x02, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x04, 0x01, // TĄ (U+0054 U+0104)
  0x00, 0x54, 0x01, 0x05, 0x02, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x02, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x02, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x02, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x02, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x02, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x02, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x02, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x02, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x02, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x02, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x02, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x02, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x02, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x02, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x02, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x38, 0x01, // Tĸ (U+0054 U+0138)
  0x00, 0x54, 0x01, 0x44, 0x01, // Tń (U+0054 U+0144)
  0x00, 0x54, 0x01, 0x46, 0x01, // Tņ (U+0054 U+0146)
  0x00, 0x54, 0x01, 0x4B, 0x01, // Tŋ (U+0054 U+014B)
  0x00, 0x54, 0x01, 0x4D, 0x02, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x02, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x02, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x02, // Tœ (U+0054 U+0153)
  0x00, 0x54, 0x01, 0x55, 0x01, // Tŕ (U+0054 U+0155)
  0x00, 0x54, 0x01, 0x57, 0x01, // Tŗ (U+0054 U+0157)
  0x00, 0x54, 0x01, 0x5B, 0x01, // Tś (U+0054 U+015B)
  0x00, 0x54, 0x01, 0x5F, 0x01, // Tş (U+0054 U+015F)
  0x00, 0x54, 0x01, 0x69, 0x01, // Tũ (U+0054 U+0169)
  0x00, 0x54, 0x01, 0x6B, 0x01, // Tū (U+0054 U+016B)
  0x00, 0x54, 0x01, 0x6D, 0x01, // Tŭ (U+0054 U+016D)
  0x00, 0x54, 0x01, 0x6F, 0x01, // Tů (U+0054 U+016F)
  0x00, 0x54, 0x01, 0x71, 0x01, // Tű (U+0054 U+0171)
  0x00, 0x54, 0x01, 0x73, 0x01, // Tų (U+0054 U+0173)
  0x00, 0x54, 0x01, 0x7A, 0x01, // Tź (U+0054 U+017A)
  0x00, 0x54, 0x01, 0x7C, 0x01, // Tż (U+0054 U+017C)
  0x00, 0x54, 0x01, 0x7E, 0x01, // Tž (U+0054 U+017E)
  0x00, 0x54, 0x20, 0x13, 0x01, // T– (U+0054 U+2013)
  0x00, 0x54, 0x20, 0x14, 0x01, // T— (U+0054 U+2014)
  0x00, 0x54, 0x20, 0x1A, 0x01, // T‚ (U+0054 U+201A)
  0x00, 0x54, 0x20, 0x1E, 0x01, // T„ (U+0054 U+201E)
  0x00, 0x54, 0x20, 0x26, 0x01, // T… (U+0054 U+2026)
  0x00, 0x54, 0x20, 0x39, 0x01, // T‹ (U+0054 U+2039)
  0x00, 0x54, 0x20, 0x3A, 0x01, // T› (U+0054 U+203A)
  0x00, 0x56, 0x00, 0x2C, 0x01, // V, (U+0056 U+002C)
  0x00, 0x56, 0x00, 0x2E, 0x01, // V. (U+0056 U+002E)
  0x00, 0x56, 0x00, 0xAB, 0x01, // V« (U+0056 U+00AB)
  0x00, 0x56, 0x20, 0x1A, 0x01, // V‚ (U+0056 U+201A)
  0x00, 0x56, 0x20, 0x1E, 0x01, // V„ (U+0056 U+201E)
  0x00, 0x56, 0x20, 0x26, 0x01, // V… (U+0056 U+2026)
  0x00, 0x56, 0x20, 0x39, 0x01, // V‹ (U+0056 U+2039)
  0x00, 0x57, 0x00, 0x2C, 0x01, // W, (U+0057 U+002C)
  0x00, 0x57, 0x00, 0x2E, 0x01, // W. (U+0057 U+002E)
  0x00, 0x57, 0x00, 0xAB, 0x01, // W« (U+0057 U+00AB)
  0x00, 0x57, 0x20, 0x1A, 0x01, // W‚ (U+0057 U+201A)
  0x00, 0x57, 0x20, 0x1E, 0x01, // W„ (U+0057 U+201E)
  0x00, 0x57, 0x20, 0x26, 0x01, // W… (U+0057 U+2026)
  0x00, 0x57, 0x20, 0x39, 0x01, // W‹ (U+0057 U+2039)
  0x00, 0x59, 0x00, 0x2C, 0x01, // Y, (U+0059 U+002C)
  0x00, 0x59, 0x00, 0x2E, 0x01, // Y. (U+0059 U+002E)
  0x00, 0x59, 0x00, 0x41, 0x01, // YA (U+0059 U+0041)
  0x00, 0x59, 0x00, 0x61, 0x01, // Ya (U+0059 U+0061)
  0x00, 0x59, 0x00, 0x63, 0x01, // Yc (U+0059 U+0063)
  0x00, 0x59, 0x00, 0x64, 0x01, // Yd (U+0059 U+0064)
  0x00, 0x59, 0x00, 0x65, 0x01, // Ye (U+0059 U+0065)
  0x00, 0x59, 0x00, 0x67, 0x01, // Yg (U+0059 U+0067)
  0x00, 0x59, 0x00, 0x6D, 0x01, // Ym (U+0059 U+006D)
  0x00, 0x59, 0x00, 0x6E, 0x01, // Yn (U+0059 U+006E)
  0x00, 0x59, 0x00, 0x6F, 0x01, // Yo (U+0059 U+006F)
  0x00, 0x59, 0x00, 0x70, 0x01, // Yp (U+0059 U+0070)
  0x00, 0x59, 0x00, 0x71, 0x01, // Yq (U+0059 U+0071)
  0x00, 0x59, 0x00, 0x72, 0x01, // Yr (U+0059 U+0072)
  0x00, 0x59, 0x00, 0x73, 0x01, // Ys (U+0059 U+0073)
  0x00, 0x59, 0x00, 0x75, 0x01, // Yu (U+0059 U+0075)
  0x00, 0x59, 0x00, 0xAB, 0x02, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x00, 0xBB, 0x01, // Y» (U+0059 U+00BB)
  0x00, 0x59, 0x00, 0xC0, 0x01, // YÀ (U+0059 U+00C0)
  0x00, 0x59, 0x00, 0xC1, 0x01, // YÁ (U+0059 U+00C1)
  0x00, 0x59, 0x00, 0xC2, 0x01, // YÂ (U+0059 U+00C2)
  0x00, 0x59, 0x00, 0xC3, 0x01, // YÃ (U+0059 U+00C3)
  0x00, 0x59, 0x00, 0xC4, 0x01, // YÄ (U+0059 U+00C4)
  0x00, 0x59, 0x00, 0xC5, 0x01, // YÅ (U+0059 U+00C5)
  0x00, 0x59, 0x00, 0xE0, 0x01, // Yà (U+0059 U+00E0)
  0x00, 0x59, 0x00, 0xE1, 0x01, // Yá (U+0059 U+00E1)
  0x00, 0x59, 0x00, 0xE2, 0x01, // Yâ (U+0059 U+00E2)
  0x00, 0x59, 0x00, 0xE3, 0x01, // Yã (U+0059 U+00E3)
  0x00, 0x59, 0x00, 0xE4, 0x01, // Yä (U+0059 U+00E4)
  0x00, 0x59, 0x00, 0xE5, 0x01, // Yå (U+0059 U+00E5)
  0x00, 0x59, 0x00, 0xE6, 0x01, // Yæ (U+0059 U+00E6)
  0x00, 0x59, 0x00, 0xE7, 0x01, // Yç (U+0059 U+00E7)
  0x00, 0x59, 0x00, 0xE8, 0x01, // Yè (U+0059 U+00E8)
  0x00, 0x59, 0x00, 0xE9, 0x01, // Yé (U+0059 U+00E9)
  0x00, 0x59, 0x00, 0xEA, 0x01, // Yê (U+0059 U+00EA)
  0x00, 0x59, 0x00, 0xEB, 0x01, // Yë (U+0059 U+00EB)
  0x00, 0x59, 0x00, 0xF2, 0x01, // Yò (U+0059 U+00F2)
  0x00, 0x59, 0x00, 0xF3, 0x01, // Yó (U+0059 U+00F3)
  0x00, 0x59, 0x00, 0xF4, 0x01, // Yô (U+0059 U+00F4)
  0x00, 0x59, 0x00, 0xF5, 0x01, // Yõ (U+0059 U+00F5)
  0x00, 0x59, 0x00, 0xF6, 0x01, // Yö (U+0059 U+00F6)
  0x00, 0x59, 0x00, 0xF8, 0x01, // Yø (U+0059 U+00F8)
  0x00, 0x59, 0x00, 0xF9, 0x01, // Yù (U+0059 U+00F9)
  0x00, 0x59, 0x00, 0xFA, 0x01, // Yú (U+0059 U+00FA)
  0x00, 0x59, 0x00, 0xFB, 0x01, // Yû (U+0059 U+00FB)
  0x00, 0x59, 0x00, 0xFC, 0x01, // Yü (U+0059 U+00FC)
  0x00, 0x59, 0x01, 0x00, 0x01, // YĀ (U+0059 U+0100)
  0x00, 0x59, 0x01, 0x01, 0x01, // Yā (U+0059 U+0101)
  0x00, 0x59, 0x01, 0x02, 0x01, // YĂ (U+0059 U+0102)
  0x00, 0x59, 0x01, 0x03, 0x01, // Yă (U+0059 U+0103)
  0x00, 0x59, 0x01, 0x04, 0x01, // YĄ (U+0059 U+0104)
  0x00, 0x59, 0x01, 0x05, 0x01, // Yą (U+0059 U+0105)
  0x00, 0x59, 0x01, 0x07, 0x01, // Yć (U+0059 U+0107)
  0x00, 0x59, 0x01, 0x09, 0x01, // Yĉ (U+0059 U+0109)
  0x00, 0x59, 0x01, 0x0B, 0x01, // Yċ (U+0059 U+010B)
  0x00, 0x59, 0x01, 0x0D, 0x01, // Yč (U+0059 U+010D)
  0x00, 0x59, 0x01, 0x0F, 0x01, // Yď (U+0059 U+010F)
  0x00, 0x59, 0x01, 0x11, 0x01, // Yđ (U+0059 U+0111)
  0x00, 0x59, 0x01, 0x13, 0x01, // Yē (U+0059 U+0113)
  0x00, 0x59, 0x01, 0x15, 0x01, // Yĕ (U+0059 U+0115)
  0x00, 0x59, 0x01, 0x17, 0x01, // Yė (U+0059 U+0117)
  0x00, 0x59, 0x01, 0x19, 0x01, // Yę (U+0059 U+0119)
  0x00, 0x59, 0x01, 0x1B, 0x01, // Yě (U+0059 U+011B)
  0x00, 0x59, 0x01, 0x1D, 0x01, // Yĝ (U+0059 U+011D)
  0x00, 0x59, 0x01, 0x1F, 0x01, // Yğ (U+0059 U+011F)
  0x00, 0x59, 0x01, 0x21, 0x01, // Yġ (U+0059 U+0121)
  0x00, 0x59, 0x01, 0x23, 0x01, // Yģ (U+0059 U+0123)
  0x00, 0x59, 0x01, 0x38, 0x01, // Yĸ (U+0059 U+0138)
  0x00, 0x59, 0x01, 0x44, 0x01, // Yń (U+0059 U+0144)
  0x00, 0x59, 0x01, 0x46, 0x01, // Yņ (U+0059 U+0146)
  0x00, 0x59, 0x01, 0x4B, 0x01, // Yŋ (U+0059 U+014B)
  0x00, 0x59, 0x01, 0x4D, 0x01, // Yō (U+0059 U+014D)
  0x00, 0x59, 0x01, 0x4F, 0x01, // Yŏ (U+0059 U+014F)
  0x00, 0x59, 0x01, 0x51, 0x01, // Yő (U+0059 U+0151)
  0x00, 0x59, 0x01, 0x53, 0x01, // Yœ (U+0059 U+0153)
  0x00, 0x59, 0x01, 0x55, 0x01, // Yŕ (U+0059 U+0155)
  0x00, 0x59, 0x01, 0x57, 0x01, // Yŗ (U+0059 U+0157)
  0x00, 0x59, 0x01, 0x5B, 0x01, // Yś (U+0059 U+015B)
  0x00, 0x59, 0x01, 0x5F, 0x01, // Yş (U+0059 U+015F)
  0x00, 0x59, 0x01, 0x69, 0x01, // Yũ (U+0059 U+0169)
  0x00, 0x59, 0x01, 0x6B, 0x01, // Yū (U+0059 U+016B)
  0x00, 0x59, 0x01, 0x6D, 0x01, // Yŭ (U+0059 U+016D)
  0x00, 0x59, 0x01, 0x6F, 0x01, // Yů (U+0059 U+016F)
  0x00, 0x59, 0x01, 0x71, 0x01, // Yű (U+0059 U+0171)
  0x00, 0x59, 0x01, 0x73, 0x01, // Yų (U+0059 U+0173)
  0x00, 0x59, 0x20, 0x1A, 0x01, // Y‚ (U+0059 U+201A)
  0x00, 0x59, 0x20, 0x1E, 0x01, // Y„ (U+0059 U+201E)
  0x00, 0x59, 0x20, 0x26, 0x01, // Y… (U+0059 U+2026)
  0x00, 0x59, 0x20, 0x39, 0x02, // Y‹ (U+0059 U+2039)
  0x00, 0x59, 0x20, 0x3A, 0x01, // Y› (U+0059 U+203A)
  0x00, 0x72, 0x00, 0x2C, 0x02, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x02, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x02, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x02, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x02, // r… (U+0072 U+2026)
  0x00, 0x76, 0x00, 0x2C, 0x01, // v, (U+0076 U+002C)
  0x00, 0x76, 0x00, 0x2E, 0x01, // v. (U+0076 U+002E)
  0x00, 0x76, 0x20, 0x1A, 0x01, // v‚ (U+0076 U+201A)
  0x00, 0x76, 0x20, 0x1E, 0x01, // v„ (U+0076 U+201E)
  0x00, 0x76, 0x20, 0x26, 0x01, // v… (U+0076 U+2026)
  0x00, 0x77, 0x00, 0x2C, 0x01, // w, (U+0077 U+002C)
  0x00, 0x77, 0x00, 0x2E, 0x01, // w. (U+0077 U+002E)
  0x00, 0x77, 0x20, 0x1A, 0x01, // w‚ (U+0077 U+201A)
  0x00, 0x77, 0x20, 0x1E, 0x01, // w„ (U+0077 U+201E)
  0x00, 0x77, 0x20, 0x26, 0x01, // w… (U+0077 U+2026)
  0x00, 0x79, 0x00, 0x2C, 0x01, // y, (U+0079 U+002C)
  0x00, 0x79, 0x00, 0x2E, 0x01, // y. (U+0079 U+002E)
  0x00, 0x79, 0x20, 0x1A, 0x01, // y‚ (U+0079 U+201A)
  0x00, 0x79, 0x20, 0x1E, 0x01, // y„ (U+0079 U+201E)
  0x00, 0x79, 0x20, 0x26, 0x01, // y… (U+0079 U+2026)
  0x00, 0xA1, 0x00, 0x59, 0x01, // ¡Y (U+00A1 U+0059)
  0x00, 0xA1, 0x00, 0xDD, 0x01, // ¡Ý (U+00A1 U+00DD)
  0x00, 0xA1, 0x01, 0x76, 0x01, // ¡Ŷ (U+00A1 U+0176)
  0x00, 0xA1, 0x01, 0x78, 0x01, // ¡Ÿ (U+00A1 U+0178)
  0x00, 0xAB, 0x00, 0x54, 0x01, // «T (U+00AB U+0054)
  0x00, 0xAB, 0x00, 0x59, 0x01, // «Y (U+00AB U+0059)
  0x00, 0xAB, 0x00, 0xDD, 0x01, // «Ý (U+00AB U+00DD)
  0x00, 0xAB, 0x01, 0x62, 0x01, // «Ţ (U+00AB U+0162)
  0x00, 0xAB, 0x01, 0x64, 0x01, // «Ť (U+00AB U+0164)
  0x00, 0xAB, 0x01, 0x66, 0x01, // «Ŧ (U+00AB U+0166)
  0x00, 0xAB, 0x01, 0x76, 0x01, // «Ŷ (U+00AB U+0176)
  0x00, 0xAB, 0x01, 0x78, 0x01, // «Ÿ (U+00AB U+0178)
  0x00, 0xBB, 0x00, 0x54, 0x01, // »T (U+00BB U+0054)
  0x00, 0xBB, 0x00, 0x56, 0x01, // »V (U+00BB U+0056)
  0x00, 0xBB, 0x00, 0x57, 0x01, // »W (U+00BB U+0057)
  0x00, 0xBB, 0x00, 0x59, 0x02, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x02, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x62, 0x01, // »Ţ (U+00BB U+0162)
  0x00, 0xBB, 0x01, 0x64, 0x01, // »Ť (U+00BB U+0164)
  0x00, 0xBB, 0x01, 0x66, 0x01, // »Ŧ (U+00BB U+0166)
  0x00, 0xBB, 0x01, 0x74, 0x01, // »Ŵ (U+00BB U+0174)
  0x00, 0xBB, 0x01, 0x76, 0x02, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x02, // »Ÿ (U+00BB U+0178)
  0x00, 0xBF, 0x00, 0x54, 0x01, // ¿T (U+00BF U+0054)
  0x00, 0xBF, 0x00, 0x56, 0x01, // ¿V (U+00BF U+0056)
  0x00, 0xBF, 0x00, 0x57, 0x01, // ¿W (U+00BF U+0057)
  0x00, 0xBF, 0x00, 0x59, 0x01, // ¿Y (U+00BF U+0059)
  0x00, 0xBF, 0x00, 0xDD, 0x01, // ¿Ý (U+00BF U+00DD)
  0x00, 0xBF, 0x01, 0x62, 0x01, // ¿Ţ (U+00BF U+0162)
  0x00, 0xBF, 0x01, 0x64, 0x01, // ¿Ť (U+00BF U+0164)
  0x00, 0xBF, 0x01, 0x66, 0x01, // ¿Ŧ (U+00BF U+0166)
  0x00, 0xBF, 0x01, 0x74, 0x01, // ¿Ŵ (U+00BF U+0174)
  0x00, 0xBF, 0x01, 0x76, 0x01, // ¿Ŷ (U+00BF U+0176)
  0x00, 0xBF, 0x01, 0x78, 0x01, // ¿Ÿ (U+00BF U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x02, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x02, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x00, 0x54, 0x01, // ÀT (U+00C0 U+0054)
  0x00, 0xC0, 0x00, 0x59, 0x01, // ÀY (U+00C0 U+0059)
  0x00, 0xC0, 0x00, 0xDD, 0x01, // ÀÝ (U+00C0 U+00DD)
  0x00, 0xC0, 0x01, 0x62, 0x01, // ÀŢ (U+00C0 U+0162)
  0x00, 0xC0, 0x01, 0x64, 0x01, // ÀŤ (U+00C0 U+0164)
  0x00, 0xC0, 0x01, 0x66, 0x01, // ÀŦ (U+00C0 U+0166)
  0x00, 0xC0, 0x01, 0x76, 0x01, // ÀŶ (U+00C0 U+0176)
  0x00, 0xC0, 0x01, 0x78, 0x01, // ÀŸ (U+00C0 U+0178)
  0x00, 0xC0, 0x20, 0x19, 0x02, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x02, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x02, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x02, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x00, 0x54, 0x01, // ÁT (U+00C1 U+0054)
  0x00, 0xC1, 0x00, 0x59, 0x01, // ÁY (U+00C1 U+0059)
  0x00, 0xC1, 0x00, 0xDD, 0x01, // ÁÝ (U+00C1 U+00DD)
  0x00, 0xC1, 0x01, 0x62, 0x01, // ÁŢ (U+00C1 U+0162)
  0x00, 0xC1, 0x01, 0x64, 0x01, // ÁŤ (U+00C1 U+0164)
  0x00, 0xC1, 0x01, 0x66, 0x01, // ÁŦ (U+00C1 U+0166)
  0x00, 0xC1, 0x01, 0x76, 0x01, // ÁŶ (U+00C1 U+0176)
  0x00, 0xC1, 0x01, 0x78, 0x01, // ÁŸ (U+00C1 U+0178)
  0x00, 0xC1, 0x20, 0x19, 0x02, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x02, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x02, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x02, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x00, 0x54, 0x01, // ÂT (U+00C2 U+0054)
  0x00, 0xC2, 0x00, 0x59, 0x01, // ÂY (U+00C2 U+0059)
  0x00, 0xC2, 0x00, 0xDD, 0x01, // ÂÝ (U+00C2 U+00DD)
  0x00, 0xC2, 0x01, 0x62, 0x01, // ÂŢ (U+00C2 U+0162)
  0x00, 0xC2, 0x01, 0x64, 0x01, // ÂŤ (U+00C2 U+0164)
  0x00, 0xC2, 0x01, 0x66, 0x01, // ÂŦ (U+00C2 U+0166)
  0x00, 0xC2, 0x01, 0x76, 0x01, // ÂŶ (U+00C2 U+0176)
  0x00, 0xC2, 0x01, 0x78, 0x01, // ÂŸ (U+00C2 U+0178)
  0x00, 0xC2, 0x20, 0x19, 0x02, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x02, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x02, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x02, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x00, 0x54, 0x01, // ÃT (U+00C3 U+0054)
  0x00, 0xC3, 0x00, 0x59, 0x01, // ÃY (U+00C3 U+0059)
  0x00, 0xC3, 0x00, 0xDD, 0x01, // ÃÝ (U+00C3 U+00DD)
  0x00, 0xC3, 0x01, 0x62, 0x01, // ÃŢ (U+00C3 U+0162)
  0x00, 0xC3, 0x01, 0x64, 0x01, // ÃŤ (U+00C3 U+0164)
  0x00, 0xC3, 0x01, 0x66, 0x01, // ÃŦ (U+00C3 U+0166)
  0x00, 0xC3, 0x01, 0x76, 0x01, // ÃŶ (U+00C3 U+0176)
  0x00, 0xC3, 0x01, 0x78, 0x01, // ÃŸ (U+00C3 U+0178)
  0x00, 0xC3, 0x20, 0x19, 0x02, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x02, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x02, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x02, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x00, 0x54, 0x01, // ÄT (U+00C4 U+0054)
  0x00, 0xC4, 0x00, 0x59, 0x01, // ÄY (U+00C4 U+0059)
  0x00, 0xC4, 0x00, 0xDD, 0x01, // ÄÝ (U+00C4 U+00DD)
  0x00, 0xC4, 0x01, 0x62, 0x01, // ÄŢ (U+00C4 U+0162)
  0x00, 0xC4, 0x01, 0x64, 0x01, // ÄŤ (U+00C4 U+0164)
  0x00, 0xC4, 0x01, 0x66, 0x01, // ÄŦ (U+00C4 U+0166)
  0x00, 0xC4, 0x01, 0x76, 0x01, // ÄŶ (U+00C4 U+0176)
  0x00, 0xC4, 0x01, 0x78, 0x01, // ÄŸ (U+00C4 U+0178)
  0x00, 0xC4, 0x20, 0x19, 0x02, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x02, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x02, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x02, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x00, 0x54, 0x01, // ÅT (U+00C5 U+0054)
  0x00, 0xC5, 0x00, 0x59, 0x01, // ÅY (U+00C5 U+0059)
  0x00, 0xC5, 0x00, 0xDD, 0x01, // ÅÝ (U+00C5 U+00DD)
  0x00, 0xC5, 0x01, 0x62, 0x01, // ÅŢ (U+00C5 U+0162)
  0x00, 0xC5, 0x01, 0x64, 0x01, // ÅŤ (U+00C5 U+0164)
  0x00, 0xC5, 0x01, 0x66, 0x01, // ÅŦ (U+00C5 U+0166)
  0x00, 0xC5, 0x01, 0x76, 0x01, // ÅŶ (U+00C5 U+0176)
  0x00, 0xC5, 0x01, 0x78, 0x01, // ÅŸ (U+00C5 U+0178)
  0x00, 0xC5, 0x20, 0x19, 0x02, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x02, // Å” (U+00C5 U+201D)
  0x00, 0xC7, 0x00, 0x43, 0x01, // ÇC (U+00C7 U+0043)
  0x00, 0xC7, 0x00, 0x47, 0x01, // ÇG (U+00C7 U+0047)
  0x00, 0xC7, 0x00, 0x4F, 0x01, // ÇO (U+00C7 U+004F)
  0x00, 0xC7, 0x00, 0x51, 0x01, // ÇQ (U+00C7 U+0051)
  0x00, 0xC7, 0x00, 0xC7, 0x01, // ÇÇ (U+00C7 U+00C7)
  0x00, 0xC7, 0x00, 0xD2, 0x01, // ÇÒ (U+00C7 U+00D2)
  0x00, 0xC7, 0x00, 0xD3, 0x01, // ÇÓ (U+00C7 U+00D3)
  0x00, 0xC7, 0x00, 0xD4, 0x01, // ÇÔ (U+00C7 U+00D4)
  0x00, 0xC7, 0x00, 0xD5, 0x01, // ÇÕ (U+00C7 U+00D5)
  0x00, 0xC7, 0x00, 0xD6, 0x01, // ÇÖ (U+00C7 U+00D6)
  0x00, 0xC7, 0x00, 0xD8, 0x01, // ÇØ (U+00C7 U+00D8)
  0x00, 0xC7, 0x01, 0x06, 0x01, // ÇĆ (U+00C7 U+0106)
  0x00, 0xC7, 0x01, 0x08, 0x01, // ÇĈ (U+00C7 U+0108)
  0x00, 0xC7, 0x01, 0x0A, 0x01, // ÇĊ (U+00C7 U+010A)
  0x00, 0xC7, 0x01, 0x0C, 0x01, // ÇČ (U+00C7 U+010C)
  0x00, 0xC7, 0x01, 0x1C, 0x01, // ÇĜ (U+00C7 U+011C)
  0x00, 0xC7, 0x01, 0x1E, 0x01, // ÇĞ (U+00C7 U+011E)
  0x00, 0xC7, 0x01, 0x20, 0x01, // ÇĠ (U+00C7 U+0120)
  0x00, 0xC7, 0x01, 0x22, 0x01, // ÇĢ (U+00C7 U+0122)
  0x00, 0xC7, 0x01, 0x4C, 0x01, // ÇŌ (U+00C7 U+014C)
  0x00, 0xC7, 0x01, 0x4E, 0x01, // ÇŎ (U+00C7 U+014E)
  0x00, 0xC7, 0x01, 0x50, 0x01, // ÇŐ (U+00C7 U+0150)
  0x00, 0xC7, 0x01, 0x52, 0x01, // ÇŒ (U+00C7 U+0152)
  0x00, 0xD0, 0x00, 0x2C, 0x01, // Ð, (U+00D0 U+002C)
  0x00, 0xD0, 0x00, 0x2E, 0x01, // Ð. (U+00D0 U+002E)
  0x00, 0xD0, 0x20, 0x1A, 0x01, // Ð‚ (U+00D0 U+201A)
  0x00, 0xD0, 0x20, 0x1E, 0x01, // Ð„ (U+00D0 U+201E)
  0x00, 0xD0, 0x20, 0x26, 0x01, // Ð… (U+00D0 U+2026)
  0x00, 0xD2, 0x00, 0x2C, 0x01, // Ò, (U+00D2 U+002C)
  0x00, 0xD2, 0x00, 0x2E, 0x01, // Ò. (U+00D2 U+002E)
  0x00, 0xD2, 0x20, 0x1A, 0x01, // Ò‚ (U+00D2 U+201A)
  0x00, 0xD2, 0x20, 0x1E, 0x01, // Ò„ (U+00D2 U+201E)
  0x00, 0xD2, 0x20, 0x26, 0x01, // Ò… (U+00D2 U+2026)
  0x00, 0xD3, 0x00, 0x2C, 0x01, // Ó, (U+00D3 U+002C)
  0x00, 0xD3, 0x00, 0x2E, 0x01, // Ó. (U+00D3 U+002E)
  0x00, 0xD3, 0x20, 0x1A, 0x01, // Ó‚ (U+00D3 U+201A)
  0x00, 0xD3, 0x20, 0x1E, 0x01, // Ó„ (U+00D3 U+201E)
  0x00, 0xD3, 0x20, 0x26, 0x01, // Ó… (U+00D3 U+2026)
  0x00, 0xD4, 0x00, 0x2C, 0x01, // Ô, (U+00D4 U+002C)
  0x00, 0xD4, 0x00, 0x2E, 0x01, // Ô. (U+00D4 U+002E)
  0x00, 0xD4, 0x20, 0x1A, 0x01, // Ô‚ (U+00D4 U+201A)
  0x00, 0xD4, 0x20, 0x1E, 0x01, // Ô„ (U+00D4 U+201E)
  0x00, 0xD4, 0x20, 0x26, 0x01, // Ô… (U+00D4 U+2026)
  0x00, 0xD5, 0x00, 0x2C, 0x01, // Õ, (U+00D5 U+002C)
  0x00, 0xD5, 0x00, 0x2E, 0x01, // Õ. (U+00D5 U+002E)
  0x00, 0xD5, 0x20, 0x1A, 0x01, // Õ‚ (U+00D5 U+201A)
  0x00, 0xD5, 0x20, 0x1E, 0x01, // Õ„ (U+00D5 U+201E)
  0x00, 0xD5, 0x20, 0x26, 0x01, // Õ… (U+00D5 U+2026)
  0x00, 0xD6, 0x00, 0x2C, 0x01, // Ö, (U+00D6 U+002C)
  0x00, 0xD6, 0x00, 0x2E, 0x01, // Ö. (U+00D6 U+002E)
  0x00, 0xD6, 0x20, 0x1A, 0x01, // Ö‚ (U+00D6 U+201A)
  0x00, 0xD6, 0x20, 0x1E, 0x01, // Ö„ (U+00D6 U+201E)
  0x00, 0xD6, 0x20, 0x26, 0x01, // Ö… (U+00D6 U+2026)
  0x00, 0xD8, 0x00, 0x2C, 0x01, // Ø, (U+00D8 U+002C)
  0x00, 0xD8, 0x00, 0x2E, 0x01, // Ø. (U+00D8 U+002E)
  0x00, 0xD8, 0x20, 0x1A, 0x01, // Ø‚ (U+00D8 U+201A)
  0x00, 0xD8, 0x20, 0x1E, 0x01, // Ø„ (U+00D8 U+201E)
  0x00, 0xD8, 0x20, 0x26, 0x01, // Ø… (U+00D8 U+2026)
  0x00, 0xDD, 0x00, 0x2C, 0x01, // Ý, (U+00DD U+002C)
  0x00, 0xDD, 0x00, 0x2E, 0x01, // Ý. (U+00DD U+002E)
  0x00, 0xDD, 0x00, 0x41, 0x01, // ÝA (U+00DD U+0041)
  0x00, 0xDD, 0x00, 0x61, 0x01, // Ýa (U+00DD U+0061)
  0x00, 0xDD, 0x00, 0x63, 0x01, // Ýc (U+00DD U+0063)
  0x00, 0xDD, 0x00, 0x64, 0x01, // Ýd (U+00DD U+0064)
  0x00, 0xDD, 0x00, 0x65, 0x01, // Ýe (U+00DD U+0065)
  0x00, 0xDD, 0x00, 0x67, 0x01, // Ýg (U+00DD U+0067)
  0x00, 0xDD, 0x00, 0x6D, 0x01, // Ým (U+00DD U+006D)
  0x00, 0xDD, 0x00, 0x6E, 0x01, // Ýn (U+00DD U+006E)
  0x00, 0xDD, 0x00, 0x6F, 0x01, // Ýo (U+00DD U+006F)
  0x00, 0xDD, 0x00, 0x70, 0x01, // Ýp (U+00DD U+0070)
  0x00, 0xDD, 0x00, 0x71, 0x01, // Ýq (U+00DD U+0071)
  0x00, 0xDD, 0x00, 0x72, 0x01, // Ýr (U+00DD U+0072)
  0x00, 0xDD, 0x00, 0x73, 0x01, // Ýs (U+00DD U+0073)
  0x00, 0xDD, 0x00, 0x75, 0x01, // Ýu (U+00DD U+0075)
  0x00, 0xDD, 0x00, 0xAB, 0x02, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x00, 0xBB, 0x01, // Ý» (U+00DD U+00BB)
  0x00, 0xDD, 0x00, 0xC0, 0x01, // ÝÀ (U+00DD U+00C0)
  0x00, 0xDD, 0x00, 0xC1, 0x01, // ÝÁ (U+00DD U+00C1)
  0x00, 0xDD, 0x00, 0xC2, 0x01, // ÝÂ (U+00DD U+00C2)
  0x00, 0xDD, 0x00, 0xC3, 0x01, // ÝÃ (U+00DD U+00C3)
  0x00, 0xDD, 0x00, 0xC4, 0x01, // ÝÄ (U+00DD U+00C4)
  0x00, 0xDD, 0x00, 0xC5, 0x01, // ÝÅ (U+00DD U+00C5)
  0x00, 0xDD, 0x00, 0xE0, 0x01, // Ýà (U+00DD U+00E0)
  0x00, 0xDD, 0x00, 0xE1, 0x01, // Ýá (U+00DD U+00E1)
  0x00, 0xDD, 0x00, 0xE2, 0x01, // Ýâ (U+00DD U+00E2)
  0x00, 0xDD, 0x00, 0xE3, 0x01, // Ýã (U+00DD U+00E3)
  0x00, 0xDD, 0x00, 0xE4, 0x01, // Ýä (U+00DD U+00E4)
  0x00, 0xDD, 0x00, 0xE5, 0x01, // Ýå (U+00DD U+00E5)
  0x00, 0xDD, 0x00, 0xE6, 0x01, // Ýæ (U+00DD U+00E6)
  0x00, 0xDD, 0x00, 0xE7, 0x01, // Ýç (U+00DD U+00E7)
  0x00, 0xDD, 0x00, 0xE8, 0x01, // Ýè (U+00DD U+00E8)
  0x00, 0xDD, 0x00, 0xE9, 0x01, // Ýé (U+00DD U+00E9)
  0x00, 0xDD, 0x00, 0xEA, 0x01, // Ýê (U+00DD U+00EA)
  0x00, 0xDD, 0x00, 0xEB, 0x01, // Ýë (U+00DD U+00EB)
  0x00, 0xDD, 0x00, 0xF2, 0x01, // Ýò (U+00DD U+00F2)
  0x00, 0xDD, 0x00, 0xF3, 0x01, // Ýó (U+00DD U+00F3)
  0x00, 0xDD, 0x00, 0xF4, 0x01, // Ýô (U+00DD U+00F4)
  0x00, 0xDD, 0x00, 0xF5, 0x01, // Ýõ (U+00DD U+00F5)
  0x00, 0xDD, 0x00, 0xF6, 0x01, // Ýö (U+00DD U+00F6)
  0x00, 0xDD, 0x00, 0xF8, 0x01, // Ýø (U+00DD U+00F8)
  0x00, 0xDD, 0x00, 0xF9, 0x01, // Ýù (U+00DD U+00F9)
  0x00, 0xDD, 0x00, 0xFA, 0x01, // Ýú (U+00DD U+00FA)
  0x00, 0xDD, 0x00, 0xFB, 0x01, // Ýû (U+00DD U+00FB)
  0x00, 0xDD, 0x00, 0xFC, 0x01, // Ýü (U+00DD U+00FC)
  0x00, 0xDD, 0x01, 0x00, 0x01, // ÝĀ (U+00DD U+0100)
  0x00, 0xDD, 0x01, 0x01, 0x01, // Ýā (U+00DD U+0101)
  0x00, 0xDD, 0x01, 0x02, 0x01, // ÝĂ (U+00DD U+0102)
  0x00, 0xDD, 0x01, 0x03, 0x01, // Ýă (U+00DD U+0103)
  0x00, 0xDD, 0x01, 0x04, 0x01, // ÝĄ (U+00DD U+0104)
  0x00, 0xDD, 0x01, 0x05, 0x01, // Ýą (U+00DD U+0105)
  0x00, 0xDD, 0x01, 0x07, 0x01, // Ýć (U+00DD U+0107)
  0x00, 0xDD, 0x01, 0x09, 0x01, // Ýĉ (U+00DD U+0109)
  0x00, 0xDD, 0x01, 0x0B, 0x01, // Ýċ (U+00DD U+010B)
  0x00, 0xDD, 0x01, 0x0D, 0x01, // Ýč (U+00DD U+010D)
  0x00, 0xDD, 0x01, 0x0F, 0x01, // Ýď (U+00DD U+010F)
  0x00, 0xDD, 0x01, 0x11, 0x01, // Ýđ (U+00DD U+0111)
  0x00, 0xDD, 0x01, 0x13, 0x01, // Ýē (U+00DD U+0113)
  0x00, 0xDD, 0x01, 0x15, 0x01, // Ýĕ (U+00DD U+0115)
  0x00, 0xDD, 0x01, 0x17, 0x01, // Ýė (U+00DD U+0117)
  0x00, 0xDD, 0x01, 0x19, 0x01, // Ýę (U+00DD U+0119)
  0x00, 0xDD, 0x01, 0x1B, 0x01, // Ýě (U+00DD U+011B)
  0x00, 0xDD, 0x01, 0x1D, 0x01, // Ýĝ (U+00DD U+011D)
  0x00, 0xDD, 0x01, 0x1F, 0x01, // Ýğ (U+00DD U+011F)
  0x00, 0xDD, 0x01, 0x21, 0x01, // Ýġ (U+00DD U+0121)
  0x00, 0xDD, 0x01, 0x23, 0x01, // Ýģ (U+00DD U+0123)
  0x00, 0xDD, 0x01, 0x38, 0x01, // Ýĸ (U+00DD U+0138)
  0x00, 0xDD, 0x01, 0x44, 0x01, // Ýń (U+00DD U+0144)
  0x00, 0xDD, 0x01, 0x46, 0x01, // Ýņ (U+00DD U+0146)
  0x00, 0xDD, 0x01, 0x4B, 0x01, // Ýŋ (U+00DD U+014B)
  0x00, 0xDD, 0x01, 0x4D, 0x01, // Ýō (U+00DD U+014D)
  0x00, 0xDD, 0x01, 0x4F, 0x01, // Ýŏ (U+00DD U+014F)
  0x00, 0xDD, 0x01, 0x51, 0x01, // Ýő (U+00DD U+0151)
  0x00, 0xDD, 0x01, 0x53, 0x01, // Ýœ (U+00DD U+0153)
  0x00, 0xDD, 0x01, 0x55, 0x01, // Ýŕ (U+00DD U+0155)
  0x00, 0xDD, 0x01, 0x57, 0x01, // Ýŗ (U+00DD U+0157)
  0x00, 0xDD, 0x01, 0x5B, 0x01, // Ýś (U+00DD U+015B)
  0x00, 0xDD, 0x01, 0x5F, 0x01, // Ýş (U+00DD U+015F)
  0x00, 0xDD, 0x01, 0x69, 0x01, // Ýũ (U+00DD U+0169)
  0x00, 0xDD, 0x01, 0x6B, 0x01, // Ýū (U+00DD U+016B)
  0x00, 0xDD, 0x01, 0x6D, 0x01, // Ýŭ (U+00DD U+016D)
  0x00, 0xDD, 0x01, 0x6F, 0x01, // Ýů (U+00DD U+016F)
  0x00, 0xDD, 0x01, 0x71, 0x01, // Ýű (U+00DD U+0171)
  0x00, 0xDD, 0x01, 0x73, 0x01, // Ýų (U+00DD U+0173)
  0x00, 0xDD, 0x20, 0x1A, 0x01, // Ý‚ (U+00DD U+201A)
  0x00, 0xDD, 0x20, 0x1E, 0x01, // Ý„ (U+00DD U+201E)
  0x00, 0xDD, 0x20, 0x26, 0x01, // Ý… (U+00DD U+2026)
  0x00, 0xDD, 0x20, 0x39, 0x02, // Ý‹ (U+00DD U+2039)
  0x00, 0xDD, 0x20, 0x3A, 0x01, // Ý› (U+00DD U+203A)
  0x00, 0xDE, 0x00, 0x2C, 0x03, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x03, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x00, 0x41, 0x01, // ÞA (U+00DE U+0041)
  0x00, 0xDE, 0x00, 0xC0, 0x01, // ÞÀ (U+00DE U+00C0)
  0x00, 0xDE, 0x00, 0xC1, 0x01, // ÞÁ (U+00DE U+00C1)
  0x00, 0xDE, 0x00, 0xC2, 0x01, // ÞÂ (U+00DE U+00C2)
  0x00, 0xDE, 0x00, 0xC3, 0x01, // ÞÃ (U+00DE U+00C3)
  0x00, 0xDE, 0x00, 0xC4, 0x01, // ÞÄ (U+00DE U+00C4)
  0x00, 0xDE, 0x00, 0xC5, 0x01, // ÞÅ (U+00DE U+00C5)
  0x00, 0xDE, 0x00, 0xC6, 0x01, // ÞÆ (U+00DE U+00C6)
  0x00, 0xDE, 0x01, 0x00, 0x01, // ÞĀ (U+00DE U+0100)
  0x00, 0xDE, 0x01, 0x02, 0x01, // ÞĂ (U+00DE U+0102)
  0x00, 0xDE, 0x01, 0x04, 0x01, // ÞĄ (U+00DE U+0104)
  0x00, 0xDE, 0x20, 0x1A, 0x03, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x03, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x03, // Þ… (U+00DE U+2026)
  0x00, 0xFD, 0x00, 0x2C, 0x01, // ý, (U+00FD U+002C)
  0x00, 0xFD, 0x00, 0x2E, 0x01, // ý. (U+00FD U+002E)
  0x00, 0xFD, 0x20, 0x1A, 0x01, // ý‚ (U+00FD U+201A)
  0x00, 0xFD, 0x20, 0x1E, 0x01, // ý„ (U+00FD U+201E)
  0x00, 0xFD, 0x20, 0x26, 0x01, // ý… (U+00FD U+2026)
  0x00, 0xFF, 0x00, 0x2C, 0x01, // ÿ, (U+00FF U+002C)
  0x00, 0xFF, 0x00, 0x2E, 0x01, // ÿ. (U+00FF U+002E)
  0x00, 0xFF, 0x20, 0x1A, 0x01, // ÿ‚ (U+00FF U+201A)
  0x00, 0xFF, 0x20, 0x1E, 0x01, // ÿ„ (U+00FF U+201E)
  0x00, 0xFF, 0x20, 0x26, 0x01, // ÿ… (U+00FF U+2026)
  0x01, 0x00, 0x00, 0x22, 0x02, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x02, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x00, 0x54, 0x01, // ĀT (U+0100 U+0054)
  0x01, 0x00, 0x00, 0x59, 0x01, // ĀY (U+0100 U+0059)
  0x01, 0x00, 0x00, 0xDD, 0x01, // ĀÝ (U+0100 U+00DD)
  0x01, 0x00, 0x01, 0x62, 0x01, // ĀŢ (U+0100 U+0162)
  0x01, 0x00, 0x01, 0x64, 0x01, // ĀŤ (U+0100 U+0164)
  0x01, 0x00, 0x01, 0x66, 0x01, // ĀŦ (U+0100 U+0166)
  0x01, 0x00, 0x01, 0x76, 0x01, // ĀŶ (U+0100 U+0176)
  0x01, 0x00, 0x01, 0x78, 0x01, // ĀŸ (U+0100 U+0178)
  0x01, 0x00, 0x20, 0x19, 0x02, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x02, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x02, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x02, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x00, 0x54, 0x01, // ĂT (U+0102 U+0054)
  0x01, 0x02, 0x00, 0x59, 0x01, // ĂY (U+0102 U+0059)
  0x01, 0x02, 0x00, 0xDD, 0x01, // ĂÝ (U+0102 U+00DD)
  0x01, 0x02, 0x01, 0x62, 0x01, // ĂŢ (U+0102 U+0162)
  0x01, 0x02, 0x01, 0x64, 0x01, // ĂŤ (U+0102 U+0164)
  0x01, 0x02, 0x01, 0x66, 0x01, // ĂŦ (U+0102 U+0166)
  0x01, 0x02, 0x01, 0x76, 0x01, // ĂŶ (U+0102 U+0176)
  0x01, 0x02, 0x01, 0x78, 0x01, // ĂŸ (U+0102 U+0178)
  0x01, 0x02, 0x20, 0x19, 0x02, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x02, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x02, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x02, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x00, 0x54, 0x01, // ĄT (U+0104 U+0054)
  0x01, 0x04, 0x00, 0x59, 0x01, // ĄY (U+0104 U+0059)
  0x01, 0x04, 0x00, 0xDD, 0x01, // ĄÝ (U+0104 U+00DD)
  0x01, 0x04, 0x01, 0x62, 0x01, // ĄŢ (U+0104 U+0162)
  0x01, 0x04, 0x01, 0x64, 0x01, // ĄŤ (U+0104 U+0164)
  0x01, 0x04, 0x01, 0x66, 0x01, // ĄŦ (U+0104 U+0166)
  0x01, 0x04, 0x01, 0x76, 0x01, // ĄŶ (U+0104 U+0176)
  0x01, 0x04, 0x01, 0x78, 0x01, // ĄŸ (U+0104 U+0178)
  0x01, 0x04, 0x20, 0x19, 0x02, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x02, // Ą” (U+0104 U+201D)
  0x01, 0x06, 0x00, 0x43, 0x01, // ĆC (U+0106 U+0043)
  0x01, 0x06, 0x00, 0x47, 0x01, // ĆG (U+0106 U+0047)
  0x01, 0x06, 0x00, 0x4F, 0x01, // ĆO (U+0106 U+004F)
  0x01, 0x06, 0x00, 0x51, 0x01, // ĆQ (U+0106 U+0051)
  0x01, 0x06, 0x00, 0xC7, 0x01, // ĆÇ (U+0106 U+00C7)
  0x01, 0x06, 0x00, 0xD2, 0x01, // ĆÒ (U+0106 U+00D2)
  0x01, 0x06, 0x00, 0xD3, 0x01, // ĆÓ (U+0106 U+00D3)
  0x01, 0x06, 0x00, 0xD4, 0x01, // ĆÔ (U+0106 U+00D4)
  0x01, 0x06, 0x00, 0xD5, 0x01, // ĆÕ (U+0106 U+00D5)
  0x01, 0x06, 0x00, 0xD6, 0x01, // ĆÖ (U+0106 U+00D6)
  0x01, 0x06, 0x00, 0xD8, 0x01, // ĆØ (U+0106 U+00D8)
  0x01, 0x06, 0x01, 0x06, 0x01, // ĆĆ (U+0106 U+0106)
  0x01, 0x06, 0x01, 0x08, 0x01, // ĆĈ (U+0106 U+0108)
  0x01, 0x06, 0x01, 0x0A, 0x01, // ĆĊ (U+0106 U+010A)
  0x01, 0x06, 0x01, 0x0C, 0x01, // ĆČ (U+0106 U+010C)
  0x01, 0x06, 0x01, 0x1C, 0x01, // ĆĜ (U+0106 U+011C)
  0x01, 0x06, 0x01, 0x1E, 0x01, // ĆĞ (U+0106 U+011E)
  0x01, 0x06, 0x01, 0x20, 0x01, // ĆĠ (U+0106 U+0120)
  0x01, 0x06, 0x01, 0x22, 0x01, // ĆĢ (U+0106 U+0122)
  0x01, 0x06, 0x01, 0x4C, 0x01, // ĆŌ (U+0106 U+014C)
  0x01, 0x06, 0x01, 0x4E, 0x01, // ĆŎ (U+0106 U+014E)
  0x01, 0x06, 0x01, 0x50, 0x01, // ĆŐ (U+0106 U+0150)
  0x01, 0x06, 0x01, 0x52, 0x01, // ĆŒ (U+0106 U+0152)
  0x01, 0x08, 0x00, 0x43, 0x01, // ĈC (U+0108 U+0043)
  0x01, 0x08, 0x00, 0x47, 0x01, // ĈG (U+0108 U+0047)
  0x01, 0x08, 0x00, 0x4F, 0x01, // ĈO (U+0108 U+004F)
  0x01, 0x08, 0x00, 0x51, 0x01, // ĈQ (U+0108 U+0051)
  0x01, 0x08, 0x00, 0xC7, 0x01, // ĈÇ (U+0108 U+00C7)
  0x01, 0x08, 0x00, 0xD2, 0x01, // ĈÒ (U+0108 U+00D2)
  0x01, 0x08, 0x00, 0xD3, 0x01, // ĈÓ (U+0108 U+00D3)
  0x01, 0x08, 0x00, 0xD4, 0x01, // ĈÔ (U+0108 U+00D4)
  0x01, 0x08, 0x00, 0xD5, 0x01, // ĈÕ (U+0108 U+00D5)
  0x01, 0x08, 0x00, 0xD6, 0x01, // ĈÖ (U+0108 U+00D6)
  0x01, 0x08, 0x00, 0xD8, 0x01, // ĈØ (U+0108 U+00D8)
  0x01, 0x08, 0x01, 0x06, 0x01, // ĈĆ (U+0108 U+0106)
  0x01, 0x08, 0x01, 0x08, 0x01, // ĈĈ (U+0108 U+0108)
  0x01, 0x08, 0x01, 0x0A, 0x01, // ĈĊ (U+0108 U+010A)
  0x01, 0x08, 0x01, 0x0C, 0x01, // ĈČ (U+0108 U+010C)
  0x01, 0x08, 0x01, 0x1C, 0x01, // ĈĜ (U+0108 U+011C)
  0x01, 0x08, 0x01, 0x1E, 0x01, // ĈĞ (U+0108 U+011E)
  0x01, 0x08, 0x01, 0x20, 0x01, // ĈĠ (U+0108 U+0120)
  0x01, 0x08, 0x01, 0x22, 0x01, // ĈĢ (U+0108 U+0122)
  0x01, 0x08, 0x01, 0x4C, 0x01, // ĈŌ (U+0108 U+014C)
  0x01, 0x08, 0x01, 0x4E, 0x01, // ĈŎ (U+0108 U+014E)
  0x01, 0x08, 0x01, 0x50, 0x01, // ĈŐ (U+0108 U+0150)
  0x01, 0x08, 0x01, 0x52, 0x01, // ĈŒ (U+0108 U+0152)
  0x01, 0x0A, 0x00, 0x43, 0x01, // ĊC (U+010A U+0043)
  0x01, 0x0A, 0x00, 0x47, 0x01, // ĊG (U+010A U+0047)
  0x01, 0x0A, 0x00, 0x4F, 0x01, // ĊO (U+010A U+004F)
  0x01, 0x0A, 0x00, 0x51, 0x01, // ĊQ (U+010A U+0051)
  0x01, 0x0A, 0x00, 0xC7, 0x01, // ĊÇ (U+010A U+00C7)
  0x01, 0x0A, 0x00, 0xD2, 0x01, // ĊÒ (U+010A U+00D2)
  0x01, 0x0A, 0x00, 0xD3, 0x01, // ĊÓ (U+010A U+00D3)
  0x01, 0x0A, 0x00, 0xD4, 0x01, // ĊÔ (U+010A U+00D4)
  0x01, 0x0A, 0x00, 0xD5, 0x01, // ĊÕ (U+010A U+00D5)
  0x01, 0x0A, 0x00, 0xD6, 0x01, // ĊÖ (U+010A U+00D6)
  0x01, 0x0A, 0x00, 0xD8, 0x01, // ĊØ (U+010A U+00D8)
  0x01, 0x0A, 0x01, 0x06, 0x01, // ĊĆ (U+010A U+0106)
  0x01, 0x0A, 0x01, 0x08, 0x01, // ĊĈ (U+010A U+0108)
  0x01, 0x0A, 0x01, 0x0A, 0x01, // ĊĊ (U+010A U+010A)
  0x01, 0x0A, 0x01, 0x0C, 0x01, // ĊČ (U+010A U+010C)
  0x01, 0x0A, 0x01, 0x1C, 0x01, // ĊĜ (U+010A U+011C)
  0x01, 0x0A, 0x01, 0x1E, 0x01, // ĊĞ (U+010A U+011E)
  0x01, 0x0A, 0x01, 0x20, 0x01, // ĊĠ (U+010A U+0120)
  0x01, 0x0A, 0x01, 0x22, 0x01, // ĊĢ (U+010A U+0122)
  0x01, 0x0A, 0x01, 0x4C, 0x01, // ĊŌ (U+010A U+014C)
  0x01, 0x0A, 0x01, 0x4E, 0x01, // ĊŎ (U+010A U+014E)
  0x01, 0x0A, 0x01, 0x50, 0x01, // ĊŐ (U+010A U+0150)
  0x01, 0x0A, 0x01, 0x52, 0x01, // ĊŒ (U+010A U+0152)
  0x01, 0x0C, 0x00, 0x43, 0x01, // ČC (U+010C U+0043)
  0x01, 0x0C, 0x00, 0x47, 0x01, // ČG (U+010C U+0047)
  0x01, 0x0C, 0x00, 0x4F, 0x01, // ČO (U+010C U+004F)
  0x01, 0x0C, 0x00, 0x51, 0x01, // ČQ (U+010C U+0051)
  0x01, 0x0C, 0x00, 0xC7, 0x01, // ČÇ (U+010C U+00C7)
  0x01, 0x0C, 0x00, 0xD2, 0x01, // ČÒ (U+010C U+00D2)
  0x01, 0x0C, 0x00, 0xD3, 0x01, // ČÓ (U+010C U+00D3)
  0x01, 0x0C, 0x00, 0xD4, 0x01, // ČÔ (U+010C U+00D4)
  0x01, 0x0C, 0x00, 0xD5, 0x01, // ČÕ (U+010C U+00D5)
  0x01, 0x0C, 0x00, 0xD6, 0x01, // ČÖ (U+010C U+00D6)
  0x01, 0x0C, 0x00, 0xD8, 0x01, // ČØ (U+010C U+00D8)
  0x01, 0x0C, 0x01, 0x06, 0x01, // ČĆ (U+010C U+0106)
  0x01, 0x0C, 0x01, 0x08, 0x01, // ČĈ (U+010C U+0108)
  0x01, 0x0C, 0x01, 0x0A, 0x01, // ČĊ (U+010C U+010A)
  0x01, 0x0C, 0x01, 0x0C, 0x01, // ČČ (U+010C U+010C)
  0x01, 0x0C, 0x01, 0x1C, 0x01, // ČĜ (U+010C U+011C)
  0x01, 0x0C, 0x01, 0x1E, 0x01, // ČĞ (U+010C U+011E)
  0x01, 0x0C, 0x01, 0x20, 0x01, // ČĠ (U+010C U+0120)
  0x01, 0x0C, 0x01, 0x22, 0x01, // ČĢ (U+010C U+0122)
  0x01, 0x0C, 0x01, 0x4C, 0x01, // ČŌ (U+010C U+014C)
  0x01, 0x0C, 0x01, 0x4E, 0x01, // ČŎ (U+010C U+014E)
  0x01, 0x0C, 0x01, 0x50, 0x01, // ČŐ (U+010C U+0150)
  0x01, 0x0C, 0x01, 0x52, 0x01, // ČŒ (U+010C U+0152)
  0x01, 0x0E, 0x00, 0x2C, 0x01, // Ď, (U+010E U+002C)
  0x01, 0x0E, 0x00, 0x2E, 0x01, // Ď. (U+010E U+002E)
  0x01, 0x0E, 0x20, 0x1A, 0x01, // Ď‚ (U+010E U+201A)
  0x01, 0x0E, 0x20, 0x1E, 0x01, // Ď„ (U+010E U+201E)
  0x01, 0x0E, 0x20, 0x26, 0x01, // Ď… (U+010E U+2026)
  0x01, 0x10, 0x00, 0x2C, 0x01, // Đ, (U+0110 U+002C)
  0x01, 0x10, 0x00, 0x2E, 0x01, // Đ. (U+0110 U+002E)
  0x01, 0x10, 0x20, 0x1A, 0x01, // Đ‚ (U+0110 U+201A)
  0x01, 0x10, 0x20, 0x1E, 0x01, // Đ„ (U+0110 U+201E)
  0x01, 0x10, 0x20, 0x26, 0x01, // Đ… (U+0110 U+2026)
  0x01, 0x39, 0x00, 0x22, 0x02, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x02, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x00, 0x54, 0x01, // ĹT (U+0139 U+0054)
  0x01, 0x39, 0x00, 0x56, 0x01, // ĹV (U+0139 U+0056)
  0x01, 0x39, 0x00, 0x57, 0x01, // ĹW (U+0139 U+0057)
  0x01, 0x39, 0x00, 0x59, 0x01, // ĹY (U+0139 U+0059)
  0x01, 0x39, 0x00, 0xDD, 0x01, // ĹÝ (U+0139 U+00DD)
  0x01, 0x39, 0x01, 0x62, 0x01, // ĹŢ (U+0139 U+0162)
  0x01, 0x39, 0x01, 0x64, 0x01, // ĹŤ (U+0139 U+0164)
  0x01, 0x39, 0x01, 0x66, 0x01, // ĹŦ (U+0139 U+0166)
  0x01, 0x39, 0x01, 0x74, 0x01, // ĹŴ (U+0139 U+0174)
  0x01, 0x39, 0x01, 0x76, 0x01, // ĹŶ (U+0139 U+0176)
  0x01, 0x39, 0x01, 0x78, 0x01, // ĹŸ (U+0139 U+0178)
  0x01, 0x39, 0x20, 0x19, 0x02, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x02, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x02, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x02, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x00, 0x54, 0x01, // ĻT (U+013B U+0054)
  0x01, 0x3B, 0x00, 0x56, 0x01, // ĻV (U+013B U+0056)
  0x01, 0x3B, 0x00, 0x57, 0x01, // ĻW (U+013B U+0057)
  0x01, 0x3B, 0x00, 0x59, 0x01, // ĻY (U+013B U+0059)
  0x01, 0x3B, 0x00, 0xDD, 0x01, // ĻÝ (U+013B U+00DD)
  0x01, 0x3B, 0x01, 0x62, 0x01, // ĻŢ (U+013B U+0162)
  0x01, 0x3B, 0x01, 0x64, 0x01, // ĻŤ (U+013B U+0164)
  0x01, 0x3B, 0x01, 0x66, 0x01, // ĻŦ (U+013B U+0166)
  0x01, 0x3B, 0x01, 0x74, 0x01, // ĻŴ (U+013B U+0174)
  0x01, 0x3B, 0x01, 0x76, 0x01, // ĻŶ (U+013B U+0176)
  0x01, 0x3B, 0x01, 0x78, 0x01, // ĻŸ (U+013B U+0178)
  0x01, 0x3B, 0x20, 0x19, 0x02, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x02, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x02, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x02, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x00, 0x54, 0x01, // ĽT (U+013D U+0054)
  0x01, 0x3D, 0x00, 0x56, 0x01, // ĽV (U+013D U+0056)
  0x01, 0x3D, 0x00, 0x57, 0x01, // ĽW (U+013D U+0057)
  0x01, 0x3D, 0x00, 0x59, 0x01, // ĽY (U+013D U+0059)
  0x01, 0x3D, 0x00, 0xDD, 0x01, // ĽÝ (U+013D U+00DD)
  0x01, 0x3D, 0x01, 0x62, 0x01, // ĽŢ (U+013D U+0162)
  0x01, 0x3D, 0x01, 0x64, 0x01, // ĽŤ (U+013D U+0164)
  0x01, 0x3D, 0x01, 0x66, 0x01, // ĽŦ (U+013D U+0166)
  0x01, 0x3D, 0x01, 0x74, 0x01, // ĽŴ (U+013D U+0174)
  0x01, 0x3D, 0x01, 0x76, 0x01, // ĽŶ (U+013D U+0176)
  0x01, 0x3D, 0x01, 0x78, 0x01, // ĽŸ (U+013D U+0178)
  0x01, 0x3D, 0x20, 0x19, 0x02, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x02, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x02, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x02, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x00, 0x54, 0x01, // ĿT (U+013F U+0054)
  0x01, 0x3F, 0x00, 0x56, 0x01, // ĿV (U+013F U+0056)
  0x01, 0x3F, 0x00, 0x57, 0x01, // ĿW (U+013F U+0057)
  0x01, 0x3F, 0x00, 0x59, 0x01, // ĿY (U+013F U+0059)
  0x01, 0x3F, 0x00, 0xDD, 0x01, // ĿÝ (U+013F U+00DD)
  0x01, 0x3F, 0x01, 0x62, 0x01, // ĿŢ (U+013F U+0162)
  0x01, 0x3F, 0x01, 0x64, 0x01, // ĿŤ (U+013F U+0164)
  0x01, 0x3F, 0x01, 0x66, 0x01, // ĿŦ (U+013F U+0166)
  0x01, 0x3F, 0x01, 0x74, 0x01, // ĿŴ (U+013F U+0174)
  0x01, 0x3F, 0x01, 0x76, 0x01, // ĿŶ (U+013F U+0176)
  0x01, 0x3F, 0x01, 0x78, 0x01, // ĿŸ (U+013F U+0178)
  0x01, 0x3F, 0x20, 0x19, 0x02, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x02, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x02, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x02, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x00, 0x54, 0x01, // ŁT (U+0141 U+0054)
  0x01, 0x41, 0x00, 0x56, 0x01, // ŁV (U+0141 U+0056)
  0x01, 0x41, 0x00, 0x57, 0x01, // ŁW (U+0141 U+0057)
  0x01, 0x41, 0x00, 0x59, 0x01, // ŁY (U+0141 U+0059)
  0x01, 0x41, 0x00, 0xDD, 0x01, // ŁÝ (U+0141 U+00DD)
  0x01, 0x41, 0x01, 0x62, 0x01, // ŁŢ (U+0141 U+0162)
  0x01, 0x41, 0x01, 0x64, 0x01, // ŁŤ (U+0141 U+0164)
  0x01, 0x41, 0x01, 0x66, 0x01, // ŁŦ (U+0141 U+0166)
  0x01, 0x41, 0x01, 0x74, 0x01, // ŁŴ (U+0141 U+0174)
  0x01, 0x41, 0x01, 0x76, 0x01, // ŁŶ (U+0141 U+0176)
  0x01, 0x41, 0x01, 0x78, 0x01, // ŁŸ (U+0141 U+0178)
  0x01, 0x41, 0x20, 0x19, 0x02, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x02, // Ł” (U+0141 U+201D)
  0x01, 0x4C, 0x00, 0x2C, 0x01, // Ō, (U+014C U+002C)
  0x01, 0x4C, 0x00, 0x2E, 0x01, // Ō. (U+014C U+002E)
  0x01, 0x4C, 0x20, 0x1A, 0x01, // Ō‚ (U+014C U+201A)
  0x01, 0x4C, 0x20, 0x1E, 0x01, // Ō„ (U+014C U+201E)
  0x01, 0x4C, 0x20, 0x26, 0x01, // Ō… (U+014C U+2026)
  0x01, 0x4E, 0x00, 0x2C, 0x01, // Ŏ, (U+014E U+002C)
  0x01, 0x4E, 0x00, 0x2E, 0x01, // Ŏ. (U+014E U+002E)
  0x01, 0x4E, 0x20, 0x1A, 0x01, // Ŏ‚ (U+014E U+201A)
  0x01, 0x4E, 0x20, 0x1E, 0x01, // Ŏ„ (U+014E U+201E)
  0x01, 0x4E, 0x20, 0x26, 0x01, // Ŏ… (U+014E U+2026)
  0x01, 0x50, 0x00, 0x2C, 0x01, // Ő, (U+0150 U+002C)
  0x01, 0x50, 0x00, 0x2E, 0x01, // Ő. (U+0150 U+002E)
  0x01, 0x50, 0x20, 0x1A, 0x01, // Ő‚ (U+0150 U+201A)
  0x01, 0x50, 0x20, 0x1E, 0x01, // Ő„ (U+0150 U+201E)
  0x01, 0x50, 0x20, 0x26, 0x01, // Ő… (U+0150 U+2026)
  0x01, 0x55, 0x00, 0x2C, 0x02, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x02, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x02, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x02, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x02, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x02, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x02, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x02, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x02, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x02, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x02, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x02, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x02, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x02, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x02, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x2C, 0x01, // Ţ, (U+0162 U+002C)
  0x01, 0x62, 0x00, 0x2D, 0x01, // Ţ- (U+0162 U+002D)
  0x01, 0x62, 0x00, 0x2E, 0x01, // Ţ. (U+0162 U+002E)
  0x01, 0x62, 0x00, 0x41, 0x01, // ŢA (U+0162 U+0041)
  0x01, 0x62, 0x00, 0x61, 0x02, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x02, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x02, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x02, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x02, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6D, 0x01, // Ţm (U+0162 U+006D)
  0x01, 0x62, 0x00, 0x6E, 0x01, // Ţn (U+0162 U+006E)
  0x01, 0x62, 0x00, 0x6F, 0x02, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x70, 0x01, // Ţp (U+0162 U+0070)
  0x01, 0x62, 0x00, 0x71, 0x02, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0x72, 0x01, // Ţr (U+0162 U+0072)
  0x01, 0x62, 0x00, 0x73, 0x01, // Ţs (U+0162 U+0073)
  0x01, 0x62, 0x00, 0x75, 0x01, // Ţu (U+0162 U+0075)
  0x01, 0x62, 0x00, 0x7A, 0x01, // Ţz (U+0162 U+007A)
  0x01, 0x62, 0x00, 0xAB, 0x01, // Ţ« (U+0162 U+00AB)
  0x01, 0x62, 0x00, 0xBB, 0x01, // Ţ» (U+0162 U+00BB)
  0x01, 0x62, 0x00, 0xC0, 0x01, // ŢÀ (U+0162 U+00C0)
  0x01, 0x62, 0x00, 0xC1, 0x01, // ŢÁ (U+0162 U+00C1)
  0x01, 0x62, 0x00, 0xC2, 0x01, // ŢÂ (U+0162 U+00C2)
  0x01, 0x62, 0x00, 0xC3, 0x01, // ŢÃ (U+0162 U+00C3)
  0x01, 0x62, 0x00, 0xC4, 0x01, // ŢÄ (U+0162 U+00C4)
  0x01, 0x62, 0x00, 0xC5, 0x01, // ŢÅ (U+0162 U+00C5)
  0x01, 0x62, 0x00, 0xE0, 0x02, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x02, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x02, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x02, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x02, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x02, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x02, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x02, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x02, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x02, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x02, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x02, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x02, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x02, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x02, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x02, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x02, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x02, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x00, 0xF9, 0x01, // Ţù (U+0162 U+00F9)
  0x01, 0x62, 0x00, 0xFA, 0x01, // Ţú (U+0162 U+00FA)
  0x01, 0x62, 0x00, 0xFB, 0x01, // Ţû (U+0162 U+00FB)
  0x01, 0x62, 0x00, 0xFC, 0x01, // Ţü (U+0162 U+00FC)
  0x01, 0x62, 0x01, 0x00, 0x01, // ŢĀ (U+0162 U+0100)
  0x01, 0x62, 0x01, 0x01, 0x02, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x02, 0x01, // ŢĂ (U+0162 U+0102)
  0x01, 0x62, 0x01, 0x03, 0x02, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x04, 0x01, // ŢĄ (U+0162 U+0104)
  0x01, 0x62, 0x01, 0x05, 0x02, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x02, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x02, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x02, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x02, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x02, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x02, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x02, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x02, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x02, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x02, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x02, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x02, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x02, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x02, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x02, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x38, 0x01, // Ţĸ (U+0162 U+0138)
  0x01, 0x62, 0x01, 0x44, 0x01, // Ţń (U+0162 U+0144)
  0x01, 0x62, 0x01, 0x46, 0x01, // Ţņ (U+0162 U+0146)
  0x01, 0x62, 0x01, 0x4B, 0x01, // Ţŋ (U+0162 U+014B)
  0x01, 0x62, 0x01, 0x4D, 0x02, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x02, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x02, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x02, // Ţœ (U+0162 U+0153)
  0x01, 0x62, 0x01, 0x55, 0x01, // Ţŕ (U+0162 U+0155)
  0x01, 0x62, 0x01, 0x57, 0x01, // Ţŗ (U+0162 U+0157)
  0x01, 0x62, 0x01, 0x5B, 0x01, // Ţś (U+0162 U+015B)
  0x01, 0x62, 0x01, 0x5F, 0x01, // Ţş (U+0162 U+015F)
  0x01, 0x62, 0x01, 0x69, 0x01, // Ţũ (U+0162 U+0169)
  0x01, 0x62, 0x01, 0x6B, 0x01, // Ţū (U+0162 U+016B)
  0x01, 0x62, 0x01, 0x6D, 0x01, // Ţŭ (U+0162 U+016D)
  0x01, 0x62, 0x01, 0x6F, 0x01, // Ţů (U+0162 U+016F)
  0x01, 0x62, 0x01, 0x71, 0x01, // Ţű (U+0162 U+0171)
  0x01, 0x62, 0x01, 0x73, 0x01, // Ţų (U+0162 U+0173)
  0x01, 0x62, 0x01, 0x7A, 0x01, // Ţź (U+0162 U+017A)
  0x01, 0x62, 0x01, 0x7C, 0x01, // Ţż (U+0162 U+017C)
  0x01, 0x62, 0x01, 0x7E, 0x01, // Ţž (U+0162 U+017E)
  0x01, 0x62, 0x20, 0x13, 0x01, // Ţ– (U+0162 U+2013)
  0x01, 0x62, 0x20, 0x14, 0x01, // Ţ— (U+0162 U+2014)
  0x01, 0x62, 0x20, 0x1A, 0x01, // Ţ‚ (U+0162 U+201A)
  0x01, 0x62, 0x20, 0x1E, 0x01, // Ţ„ (U+0162 U+201E)
  0x01, 0x62, 0x20, 0x26, 0x01, // Ţ… (U+0162 U+2026)
  0x01, 0x62, 0x20, 0x39, 0x01, // Ţ‹ (U+0162 U+2039)
  0x01, 0x62, 0x20, 0x3A, 0x01, // Ţ› (U+0162 U+203A)
  0x01, 0x64, 0x00, 0x2C, 0x01, // Ť, (U+0164 U+002C)
  0x01, 0x64, 0x00, 0x2D, 0x01, // Ť- (U+0164 U+002D)
  0x01, 0x64, 0x00, 0x2E, 0x01, // Ť. (U+0164 U+002E)
  0x01, 0x64, 0x00, 0x41, 0x01, // ŤA (U+0164 U+0041)
  0x01, 0x64, 0x00, 0x61, 0x02, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x02, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x02, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x02, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x02, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6D, 0x01, // Ťm (U+0164 U+006D)
  0x01, 0x64, 0x00, 0x6E, 0x01, // Ťn (U+0164 U+006E)
  0x01, 0x64, 0x00, 0x6F, 0x02, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x70, 0x01, // Ťp (U+0164 U+0070)
  0x01, 0x64, 0x00, 0x71, 0x02, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0x72, 0x01, // Ťr (U+0164 U+0072)
  0x01, 0x64, 0x00, 0x73, 0x01, // Ťs (U+0164 U+0073)
  0x01, 0x64, 0x00, 0x75, 0x01, // Ťu (U+0164 U+0075)
  0x01, 0x64, 0x00, 0x7A, 0x01, // Ťz (U+0164 U+007A)
  0x01, 0x64, 0x00, 0xAB, 0x01, // Ť« (U+0164 U+00AB)
  0x01, 0x64, 0x00, 0xBB, 0x01, // Ť» (U+0164 U+00BB)
  0x01, 0x64, 0x00, 0xC0, 0x01, // ŤÀ (U+0164 U+00C0)
  0x01, 0x64, 0x00, 0xC1, 0x01, // ŤÁ (U+0164 U+00C1)
  0x01, 0x64, 0x00, 0xC2, 0x01, // ŤÂ (U+0164 U+00C2)
  0x01, 0x64, 0x00, 0xC3, 0x01, // ŤÃ (U+0164 U+00C3)
  0x01, 0x64, 0x00, 0xC4, 0x01, // ŤÄ (U+0164 U+00C4)
  0x01, 0x64, 0x00, 0xC5, 0x01, // ŤÅ (U+0164 U+00C5)
  0x01, 0x64, 0x00, 0xE0, 0x02, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x02, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x02, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x02, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x02, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x02, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x02, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x02, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x02, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x02, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x02, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x02, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x02, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x02, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x02, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x02, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x02, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x02, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x00, 0xF9, 0x01, // Ťù (U+0164 U+00F9)
  0x01, 0x64, 0x00, 0xFA, 0x01, // Ťú (U+0164 U+00FA)
  0x01, 0x64, 0x00, 0xFB, 0x01, // Ťû (U+0164 U+00FB)
  0x01, 0x64, 0x00, 0xFC, 0x01, // Ťü (U+0164 U+00FC)
  0x01, 0x64, 0x01, 0x00, 0x01, // ŤĀ (U+0164 U+0100)
  0x01, 0x64, 0x01, 0x01, 0x02, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x02, 0x01, // ŤĂ (U+0164 U+0102)
  0x01, 0x64, 0x01, 0x03, 0x02, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x04, 0x01, // ŤĄ (U+0164 U+0104)
  0x01, 0x64, 0x01, 0x05, 0x02, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x02, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x02, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x02, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x02, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x02, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x02, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x02, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x02, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x02, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x02, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x02, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x02, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x02, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x02, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x02, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x38, 0x01, // Ťĸ (U+0164 U+0138)
  0x01, 0x64, 0x01, 0x44, 0x01, // Ťń (U+0164 U+0144)
  0x01, 0x64, 0x01, 0x46, 0x01, // Ťņ (U+0164 U+0146)
  0x01, 0x64, 0x01, 0x4B, 0x01, // Ťŋ (U+0164 U+014B)
  0x01, 0x64, 0x01, 0x4D, 0x02, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x02, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x02, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x02, // Ťœ (U+0164 U+0153)
  0x01, 0x64, 0x01, 0x55, 0x01, // Ťŕ (U+0164 U+0155)
  0x01, 0x64, 0x01, 0x57, 0x01, // Ťŗ (U+0164 U+0157)
  0x01, 0x64, 0x01, 0x5B, 0x01, // Ťś (U+0164 U+015B)
  0x01, 0x64, 0x01, 0x5F, 0x01, // Ťş (U+0164 U+015F)
  0x01, 0x64, 0x01, 0x69, 0x01, // Ťũ (U+0164 U+0169)
  0x01, 0x64, 0x01, 0x6B, 0x01, // Ťū (U+0164 U+016B)
  0x01, 0x64, 0x01, 0x6D, 0x01, // Ťŭ (U+0164 U+016D)
  0x01, 0x64, 0x01, 0x6F, 0x01, // Ťů (U+0164 U+016F)
  0x01, 0x64, 0x01, 0x71, 0x01, // Ťű (U+0164 U+0171)
  0x01, 0x64, 0x01, 0x73, 0x01, // Ťų (U+0164 U+0173)
  0x01, 0x64, 0x01, 0x7A, 0x01, // Ťź (U+0164 U+017A)
  0x01, 0x64, 0x01, 0x7C, 0x01, // Ťż (U+0164 U+017C)
  0x01, 0x64, 0x01, 0x7E, 0x01, // Ťž (U+0164 U+017E)
  0x01, 0x64, 0x20, 0x13, 0x01, // Ť– (U+0164 U+2013)
  0x01, 0x64, 0x20, 0x14, 0x01, // Ť— (U+0164 U+2014)
  0x01, 0x64, 0x20, 0x1A, 0x01, // Ť‚ (U+0164 U+201A)
  0x01, 0x64, 0x20, 0x1E, 0x01, // Ť„ (U+0164 U+201E)
  0x01, 0x64, 0x20, 0x26, 0x01, // Ť… (U+0164 U+2026)
  0x01, 0x64, 0x20, 0x39, 0x01, // Ť‹ (U+0164 U+2039)
  0x01, 0x64, 0x20, 0x3A, 0x01, // Ť› (U+0164 U+203A)
  0x01, 0x66, 0x00, 0x2C, 0x01, // Ŧ, (U+0166 U+002C)
  0x01, 0x66, 0x00, 0x2D, 0x01, // Ŧ- (U+0166 U+002D)
  0x01, 0x66, 0x00, 0x2E, 0x01, // Ŧ. (U+0166 U+002E)
  0x01, 0x66, 0x00, 0x41, 0x01, // ŦA (U+0166 U+0041)
  0x01, 0x66, 0x00, 0x61, 0x02, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x02, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x02, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x02, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x02, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6D, 0x01, // Ŧm (U+0166 U+006D)
  0x01, 0x66, 0x00, 0x6E, 0x01, // Ŧn (U+0166 U+006E)
  0x01, 0x66, 0x00, 0x6F, 0x02, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x70, 0x01, // Ŧp (U+0166 U+0070)
  0x01, 0x66, 0x00, 0x71, 0x02, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0x72, 0x01, // Ŧr (U+0166 U+0072)
  0x01, 0x66, 0x00, 0x73, 0x01, // Ŧs (U+0166 U+0073)
  0x01, 0x66, 0x00, 0x75, 0x01, // Ŧu (U+0166 U+0075)
  0x01, 0x66, 0x00, 0x7A, 0x01, // Ŧz (U+0166 U+007A)
  0x01, 0x66, 0x00, 0xAB, 0x01, // Ŧ« (U+0166 U+00AB)
  0x01, 0x66, 0x00, 0xBB, 0x01, // Ŧ» (U+0166 U+00BB)
  0x01, 0x66, 0x00, 0xC0, 0x01, // ŦÀ (U+0166 U+00C0)
  0x01, 0x66, 0x00, 0xC1, 0x01, // ŦÁ (U+0166 U+00C1)
  0x01, 0x66, 0x00, 0xC2, 0x01, // ŦÂ (U+0166 U+00C2)
  0x01, 0x66, 0x00, 0xC3, 0x01, // ŦÃ (U+0166 U+00C3)
  0x01, 0x66, 0x00, 0xC4, 0x01, // ŦÄ (U+0166 U+00C4)
  0x01, 0x66, 0x00, 0xC5, 0x01, // ŦÅ (U+0166 U+00C5)
  0x01, 0x66, 0x00, 0xE0, 0x02, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x02, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x02, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x02, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x02, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x02, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x02, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x02, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x02, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x02, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x02, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x02, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x02, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x02, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x02, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x02, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x02, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x02, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x00, 0xF9, 0x01, // Ŧù (U+0166 U+00F9)
  0x01, 0x66, 0x00, 0xFA, 0x01, // Ŧú (U+0166 U+00FA)
  0x01, 0x66, 0x00, 0xFB, 0x01, // Ŧû (U+0166 U+00FB)
  0x01, 0x66, 0x00, 0xFC, 0x01, // Ŧü (U+0166 U+00FC)
  0x01, 0x66, 0x01, 0x00, 0x01, // ŦĀ (U+0166 U+0100)
  0x01, 0x66, 0x01, 0x01, 0x02, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x02, 0x01, // ŦĂ (U+0166 U+0102)
  0x01, 0x66, 0x01, 0x03, 0x02, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x04, 0x01, // ŦĄ (U+0166 U+0104)
  0x01, 0x66, 0x01, 0x05, 0x02, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x02, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x02, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x02, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x02, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x02, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x02, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x02, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x02, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x02, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x02, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x02, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x02, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x02, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x02, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x02, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x38, 0x01, // Ŧĸ (U+0166 U+0138)
  0x01, 0x66, 0x01, 0x44, 0x01, // Ŧń (U+0166 U+0144)
  0x01, 0x66, 0x01, 0x46, 0x01, // Ŧņ (U+0166 U+0146)
  0x01, 0x66, 0x01, 0x4B, 0x01, // Ŧŋ (U+0166 U+014B)
  0x01, 0x66, 0x01, 0x4D, 0x02, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x02, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x02, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x02, // Ŧœ (U+0166 U+0153)
  0x01, 0x66, 0x01, 0x55, 0x01, // Ŧŕ (U+0166 U+0155)
  0x01, 0x66, 0x01, 0x57, 0x01, // Ŧŗ (U+0166 U+0157)
  0x01, 0x66, 0x01, 0x5B, 0x01, // Ŧś (U+0166 U+015B)
  0x01, 0x66, 0x01, 0x5F, 0x01, // Ŧş (U+0166 U+015F)
  0x01, 0x66, 0x01, 0x69, 0x01, // Ŧũ (U+0166 U+0169)
  0x01, 0x66, 0x01, 0x6B, 0x01, // Ŧū (U+0166 U+016B)
  0x01, 0x66, 0x01, 0x6D, 0x01, // Ŧŭ (U+0166 U+016D)
  0x01, 0x66, 0x01, 0x6F, 0x01, // Ŧů (U+0166 U+016F)
  0x01, 0x66, 0x01, 0x71, 0x01, // Ŧű (U+0166 U+0171)
  0x01, 0x66, 0x01, 0x73, 0x01, // Ŧų (U+0166 U+0173)
  0x01, 0x66, 0x01, 0x7A, 0x01, // Ŧź (U+0166 U+017A)
  0x01, 0x66, 0x01, 0x7C, 0x01, // Ŧż (U+0166 U+017C)
  0x01, 0x66, 0x01, 0x7E, 0x01, // Ŧž (U+0166 U+017E)
  0x01, 0x66, 0x20, 0x13, 0x01, // Ŧ– (U+0166 U+2013)
  0x01, 0x66, 0x20, 0x14, 0x01, // Ŧ— (U+0166 U+2014)
  0x01, 0x66, 0x20, 0x1A, 0x01, // Ŧ‚ (U+0166 U+201A)
  0x01, 0x66, 0x20, 0x1E, 0x01, // Ŧ„ (U+0166 U+201E)
  0x01, 0x66, 0x20, 0x26, 0x01, // Ŧ… (U+0166 U+2026)
  0x01, 0x66, 0x20, 0x39, 0x01, // Ŧ‹ (U+0166 U+2039)
  0x01, 0x66, 0x20, 0x3A, 0x01, // Ŧ› (U+0166 U+203A)
  0x01, 0x74, 0x00, 0x2C, 0x01, // Ŵ, (U+0174 U+002C)
  0x01, 0x74, 0x00, 0x2E, 0x01, // Ŵ. (U+0174 U+002E)
  0x01, 0x74, 0x00, 0xAB, 0x01, // Ŵ« (U+0174 U+00AB)
  0x01, 0x74, 0x20, 0x1A, 0x01, // Ŵ‚ (U+0174 U+201A)
  0x01, 0x74, 0x20, 0x1E, 0x01, // Ŵ„ (U+0174 U+201E)
  0x01, 0x74, 0x20, 0x26, 0x01, // Ŵ… (U+0174 U+2026)
  0x01, 0x74, 0x20, 0x39, 0x01, // Ŵ‹ (U+0174 U+2039)
  0x01, 0x75, 0x00, 0x2C, 0x01, // ŵ, (U+0175 U+002C)
  0x01, 0x75, 0x00, 0x2E, 0x01, // ŵ. (U+0175 U+002E)
  0x01, 0x75, 0x20, 0x1A, 0x01, // ŵ‚ (U+0175 U+201A)
  0x01, 0x75, 0x20, 0x1E, 0x01, // ŵ„ (U+0175 U+201E)
  0x01, 0x75, 0x20, 0x26, 0x01, // ŵ… (U+0175 U+2026)
  0x01, 0x76, 0x00, 0x2C, 0x01, // Ŷ, (U+0176 U+002C)
  0x01, 0x76, 0x00, 0x2E, 0x01, // Ŷ. (U+0176 U+002E)
  0x01, 0x76, 0x00, 0x41, 0x01, // ŶA (U+0176 U+0041)
  0x01, 0x76, 0x00, 0x61, 0x01, // Ŷa (U+0176 U+0061)
  0x01, 0x76, 0x00, 0x63, 0x01, // Ŷc (U+0176 U+0063)
  0x01, 0x76, 0x00, 0x64, 0x01, // Ŷd (U+0176 U+0064)
  0x01, 0x76, 0x00, 0x65, 0x01, // Ŷe (U+0176 U+0065)
  0x01, 0x76, 0x00, 0x67, 0x01, // Ŷg (U+0176 U+0067)
  0x01, 0x76, 0x00, 0x6D, 0x01, // Ŷm (U+0176 U+006D)
  0x01, 0x76, 0x00, 0x6E, 0x01, // Ŷn (U+0176 U+006E)
  0x01, 0x76, 0x00, 0x6F, 0x01, // Ŷo (U+0176 U+006F)
  0x01, 0x76, 0x00, 0x70, 0x01, // Ŷp (U+0176 U+0070)
  0x01, 0x76, 0x00, 0x71, 0x01, // Ŷq (U+0176 U+0071)
  0x01, 0x76, 0x00, 0x72, 0x01, // Ŷr (U+0176 U+0072)
  0x01, 0x76, 0x00, 0x73, 0x01, // Ŷs (U+0176 U+0073)
  0x01, 0x76, 0x00, 0x75, 0x01, // Ŷu (U+0176 U+0075)
  0x01, 0x76, 0x00, 0xAB, 0x02, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x00, 0xBB, 0x01, // Ŷ» (U+0176 U+00BB)
  0x01, 0x76, 0x00, 0xC0, 0x01, // ŶÀ (U+0176 U+00C0)
  0x01, 0x76, 0x00, 0xC1, 0x01, // ŶÁ (U+0176 U+00C1)
  0x01, 0x76, 0x00, 0xC2, 0x01, // ŶÂ (U+0176 U+00C2)
  0x01, 0x76, 0x00, 0xC3, 0x01, // ŶÃ (U+0176 U+00C3)
  0x01, 0x76, 0x00, 0xC4, 0x01, // ŶÄ (U+0176 U+00C4)
  0x01, 0x76, 0x00, 0xC5, 0x01, // ŶÅ (U+0176 U+00C5)
  0x01, 0x76, 0x00, 0xE0, 0x01, // Ŷà (U+0176 U+00E0)
  0x01, 0x76, 0x00, 0xE1, 0x01, // Ŷá (U+0176 U+00E1)
  0x01, 0x76, 0x00, 0xE2, 0x01, // Ŷâ (U+0176 U+00E2)
  0x01, 0x76, 0x00, 0xE3, 0x01, // Ŷã (U+0176 U+00E3)
  0x01, 0x76, 0x00, 0xE4, 0x01, // Ŷä (U+0176 U+00E4)
  0x01, 0x76, 0x00, 0xE5, 0x01, // Ŷå (U+0176 U+00E5)
  0x01, 0x76, 0x00, 0xE6, 0x01, // Ŷæ (U+0176 U+00E6)
  0x01, 0x76, 0x00, 0xE7, 0x01, // Ŷç (U+0176 U+00E7)
  0x01, 0x76, 0x00, 0xE8, 0x01, // Ŷè (U+0176 U+00E8)
  0x01, 0x76, 0x00, 0xE9, 0x01, // Ŷé (U+0176 U+00E9)
  0x01, 0x76, 0x00, 0xEA, 0x01, // Ŷê (U+0176 U+00EA)
  0x01, 0x76, 0x00, 0xEB, 0x01, // Ŷë (U+0176 U+00EB)
  0x01, 0x76, 0x00, 0xF2, 0x01, // Ŷò (U+0176 U+00F2)
  0x01, 0x76, 0x00, 0xF3, 0x01, // Ŷó (U+0176 U+00F3)
  0x01, 0x76, 0x00, 0xF4, 0x01, // Ŷô (U+0176 U+00F4)
  0x01, 0x76, 0x00, 0xF5, 0x01, // Ŷõ (U+0176 U+00F5)
  0x01, 0x76, 0x00, 0xF6, 0x01, // Ŷö (U+0176 U+00F6)
  0x01, 0x76, 0x00, 0xF8, 0x01, // Ŷø (U+0176 U+00F8)
  0x01, 0x76, 0x00, 0xF9, 0x01, // Ŷù (U+0176 U+00F9)
  0x01, 0x76, 0x00, 0xFA, 0x01, // Ŷú (U+0176 U+00FA)
  0x01, 0x76, 0x00, 0xFB, 0x01, // Ŷû (U+0176 U+00FB)
  0x01, 0x76, 0x00, 0xFC, 0x01, // Ŷü (U+0176 U+00FC)
  0x01, 0x76, 0x01, 0x00, 0x01, // ŶĀ (U+0176 U+0100)
  0x01, 0x76, 0x01, 0x01, 0x01, // Ŷā (U+0176 U+0101)
  0x01, 0x76, 0x01, 0x02, 0x01, // ŶĂ (U+0176 U+0102)
  0x01, 0x76, 0x01, 0x03, 0x01, // Ŷă (U+0176 U+0103)
  0x01, 0x76, 0x01, 0x04, 0x01, // ŶĄ (U+0176 U+0104)
  0x01, 0x76, 0x01, 0x05, 0x01, // Ŷą (U+0176 U+0105)
  0x01, 0x76, 0x01, 0x07, 0x01, // Ŷć (U+0176 U+0107)
  0x01, 0x76, 0x01, 0x09, 0x01, // Ŷĉ (U+0176 U+0109)
  0x01, 0x76, 0x01, 0x0B, 0x01, // Ŷċ (U+0176 U+010B)
  0x01, 0x76, 0x01, 0x0D, 0x01, // Ŷč (U+0176 U+010D)
  0x01, 0x76, 0x01, 0x0F, 0x01, // Ŷď (U+0176 U+010F)
  0x01, 0x76, 0x01, 0x11, 0x01, // Ŷđ (U+0176 U+0111)
  0x01, 0x76, 0x01, 0x13, 0x01, // Ŷē (U+0176 U+0113)
  0x01, 0x76, 0x01, 0x15, 0x01, // Ŷĕ (U+0176 U+0115)
  0x01, 0x76, 0x01, 0x17, 0x01, // Ŷė (U+0176 U+0117)
  0x01, 0x76, 0x01, 0x19, 0x01, // Ŷę (U+0176 U+0119)
  0x01, 0x76, 0x01, 0x1B, 0x01, // Ŷě (U+0176 U+011B)
  0x01, 0x76, 0x01, 0x1D, 0x01, // Ŷĝ (U+0176 U+011D)
  0x01, 0x76, 0x01, 0x1F, 0x01, // Ŷğ (U+0176 U+011F)
  0x01, 0x76, 0x01, 0x21, 0x01, // Ŷġ (U+0176 U+0121)
  0x01, 0x76, 0x01, 0x23, 0x01, // Ŷģ (U+0176 U+0123)
  0x01, 0x76, 0x01, 0x38, 0x01, // Ŷĸ (U+0176 U+0138)
  0x01, 0x76, 0x01, 0x44, 0x01, // Ŷń (U+0176 U+0144)
  0x01, 0x76, 0x01, 0x46, 0x01, // Ŷņ (U+0176 U+0146)
  0x01, 0x76, 0x01, 0x4B, 0x01, // Ŷŋ (U+0176 U+014B)
  0x01, 0x76, 0x01, 0x4D, 0x01, // Ŷō (U+0176 U+014D)
  0x01, 0x76, 0x01, 0x4F, 0x01, // Ŷŏ (U+0176 U+014F)
  0x01, 0x76, 0x01, 0x51, 0x01, // Ŷő (U+0176 U+0151)
  0x01, 0x76, 0x01, 0x53, 0x01, // Ŷœ (U+0176 U+0153)
  0x01, 0x76, 0x01, 0x55, 0x01, // Ŷŕ (U+0176 U+0155)
  0x01, 0x76, 0x01, 0x57, 0x01, // Ŷŗ (U+0176 U+0157)
  0x01, 0x76, 0x01, 0x5B, 0x01, // Ŷś (U+0176 U+015B)
  0x01, 0x76, 0x01, 0x5F, 0x01, // Ŷş (U+0176 U+015F)
  0x01, 0x76, 0x01, 0x69, 0x01, // Ŷũ (U+0176 U+0169)
  0x01, 0x76, 0x01, 0x6B, 0x01, // Ŷū (U+0176 U+016B)
  0x01, 0x76, 0x01, 0x6D, 0x01, // Ŷŭ (U+0176 U+016D)
  0x01, 0x76, 0x01, 0x6F, 0x01, // Ŷů (U+0176 U+016F)
  0x01, 0x76, 0x01, 0x71, 0x01, // Ŷű (U+0176 U+0171)
  0x01, 0x76, 0x01, 0x73, 0x01, // Ŷų (U+0176 U+0173)
  0x01, 0x76, 0x20, 0x1A, 0x01, // Ŷ‚ (U+0176 U+201A)
  0x01, 0x76, 0x20, 0x1E, 0x01, // Ŷ„ (U+0176 U+201E)
  0x01, 0x76, 0x20, 0x26, 0x01, // Ŷ… (U+0176 U+2026)
  0x01, 0x76, 0x20, 0x39, 0x02, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x76, 0x20, 0x3A, 0x01, // Ŷ› (U+0176 U+203A)
  0x01, 0x77, 0x00, 0x2C, 0x01, // ŷ, (U+0177 U+002C)
  0x01, 0x77, 0x00, 0x2E, 0x01, // ŷ. (U+0177 U+002E)
  0x01, 0x77, 0x20, 0x1A, 0x01, // ŷ‚ (U+0177 U+201A)
  0x01, 0x77, 0x20, 0x1E, 0x01, // ŷ„ (U+0177 U+201E)
  0x01, 0x77, 0x20, 0x26, 0x01, // ŷ… (U+0177 U+2026)
  0x01, 0x78, 0x00, 0x2C, 0x01, // Ÿ, (U+0178 U+002C)
  0x01, 0x78, 0x00, 0x2E, 0x01, // Ÿ. (U+0178 U+002E)
  0x01, 0x78, 0x00, 0x41, 0x01, // ŸA (U+0178 U+0041)
  0x01, 0x78, 0x00, 0x61, 0x01, // Ÿa (U+0178 U+0061)
  0x01, 0x78, 0x00, 0x63, 0x01, // Ÿc (U+0178 U+0063)
  0x01, 0x78, 0x00, 0x64, 0x01, // Ÿd (U+0178 U+0064)
  0x01, 0x78, 0x00, 0x65, 0x01, // Ÿe (U+0178 U+0065)
  0x01, 0x78, 0x00, 0x67, 0x01, // Ÿg (U+0178 U+0067)
  0x01, 0x78, 0x00, 0x6D, 0x01, // Ÿm (U+0178 U+006D)
  0x01, 0x78, 0x00, 0x6E, 0x01, // Ÿn (U+0178 U+006E)
  0x01, 0x78, 0x00, 0x6F, 0x01, // Ÿo (U+0178 U+006F)
  0x01, 0x78, 0x00, 0x70, 0x01, // Ÿp (U+0178 U+0070)
  0x01, 0x78, 0x00, 0x71, 0x01, // Ÿq (U+0178 U+0071)
  0x01, 0x78, 0x00, 0x72, 0x01, // Ÿr (U+0178 U+0072)
  0x01, 0x78, 0x00, 0x73, 0x01, // Ÿs (U+0178 U+0073)
  0x01, 0x78, 0x00, 0x75, 0x01, // Ÿu (U+0178 U+0075)
  0x01, 0x78, 0x00, 0xAB, 0x02, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x00, 0xBB, 0x01, // Ÿ» (U+0178 U+00BB)
  0x01, 0x78, 0x00, 0xC0, 0x01, // ŸÀ (U+0178 U+00C0)
  0x01, 0x78, 0x00, 0xC1, 0x01, // ŸÁ (U+0178 U+00C1)
  0x01, 0x78, 0x00, 0xC2, 0x01, // ŸÂ (U+0178 U+00C2)
  0x01, 0x78, 0x00, 0xC3, 0x01, // ŸÃ (U+0178 U+00C3)
  0x01, 0x78, 0x00, 0xC4, 0x01, // ŸÄ (U+0178 U+00C4)
  0x01, 0x78, 0x00, 0xC5, 0x01, // ŸÅ (U+0178 U+00C5)
  0x01, 0x78, 0x00, 0xE0, 0x01, // Ÿà (U+0178 U+00E0)
  0x01, 0x78, 0x00, 0xE1, 0x01, // Ÿá (U+0178 U+00E1)
  0x01, 0x78, 0x00, 0xE2, 0x01, // Ÿâ (U+0178 U+00E2)
  0x01, 0x78, 0x00, 0xE3, 0x01, // Ÿã (U+0178 U+00E3)
  0x01, 0x78, 0x00, 0xE4, 0x01, // Ÿä (U+0178 U+00E4)
  0x01, 0x78, 0x00, 0xE5, 0x01, // Ÿå (U+0178 U+00E5)
  0x01, 0x78, 0x00, 0xE6, 0x01, // Ÿæ (U+0178 U+00E6)
  0x01, 0x78, 0x00, 0xE7, 0x01, // Ÿç (U+0178 U+00E7)
  0x01, 0x78, 0x00, 0xE8, 0x01, // Ÿè (U+0178 U+00E8)
  0x01, 0x78, 0x00, 0xE9, 0x01, // Ÿé (U+0178 U+00E9)
  0x01, 0x78, 0x00, 0xEA, 0x01, // Ÿê (U+0178 U+00EA)
  0x01, 0x78, 0x00, 0xEB, 0x01, // Ÿë (U+0178 U+00EB)
  0x01, 0x78, 0x00, 0xF2, 0x01, // Ÿò (U+0178 U+00F2)
  0x01, 0x78, 0x00, 0xF3, 0x01, // Ÿó (U+0178 U+00F3)
  0x01, 0x78, 0x00, 0xF4, 0x01, // Ÿô (U+0178 U+00F4)
  0x01, 0x78, 0x00, 0xF5, 0x01, // Ÿõ (U+0178 U+00F5)
  0x01, 0x78, 0x00, 0xF6, 0x01, // Ÿö (U+0178 U+00F6)
  0x01, 0x78, 0x00, 0xF8, 0x01, // Ÿø (U+0178 U+00F8)
  0x01, 0x78, 0x00, 0xF9, 0x01, // Ÿù (U+0178 U+00F9)
  0x01, 0x78, 0x00, 0xFA, 0x01, // Ÿú (U+0178 U+00FA)
  0x01, 0x78, 0x00, 0xFB, 0x01, // Ÿû (U+0178 U+00FB)
  0x01, 0x78, 0x00, 0xFC, 0x01, // Ÿü (U+0178 U+00FC)
  0x01, 0x78, 0x01, 0x00, 0x01, // ŸĀ (U+0178 U+0100)
  0x01, 0x78, 0x01, 0x01, 0x01, // Ÿā (U+0178 U+0101)
  0x01, 0x78, 0x01, 0x02, 0x01, // ŸĂ (U+0178 U+0102)
  0x01, 0x78, 0x01, 0x03, 0x01, // Ÿă (U+0178 U+0103)
  0x01, 0x78, 0x01, 0x04, 0x01, // ŸĄ (U+0178 U+0104)
  0x01, 0x78, 0x01, 0x05, 0x01, // Ÿą (U+0178 U+0105)
  0x01, 0x78, 0x01, 0x07, 0x01, // Ÿć (U+0178 U+0107)
  0x01, 0x78, 0x01, 0x09, 0x01, // Ÿĉ (U+0178 U+0109)
  0x01, 0x78, 0x01, 0x0B, 0x01, // Ÿċ (U+0178 U+010B)
  0x01, 0x78, 0x01, 0x0D, 0x01, // Ÿč (U+0178 U+010D)
  0x01, 0x78, 0x01, 0x0F, 0x01, // Ÿď (U+0178 U+010F)
  0x01, 0x78, 0x01, 0x11, 0x01, // Ÿđ (U+0178 U+0111)
  0x01, 0x78, 0x01, 0x13, 0x01, // Ÿē (U+0178 U+0113)
  0x01, 0x78, 0x01, 0x15, 0x01, // Ÿĕ (U+0178 U+0115)
  0x01, 0x78, 0x01, 0x17, 0x01, // Ÿė (U+0178 U+0117)
  0x01, 0x78, 0x01, 0x19, 0x01, // Ÿę (U+0178 U+0119)
  0x01, 0x78, 0x01, 0x1B, 0x01, // Ÿě (U+0178 U+011B)
  0x01, 0x78, 0x01, 0x1D, 0x01, // Ÿĝ (U+0178 U+011D)
  0x01, 0x78, 0x01, 0x1F, 0x01, // Ÿğ (U+0178 U+011F)
  0x01, 0x78, 0x01, 0x21, 0x01, // Ÿġ (U+0178 U+0121)
  0x01, 0x78, 0x01, 0x23, 0x01, // Ÿģ (U+0178 U+0123)
  0x01, 0x78, 0x01, 0x38, 0x01, // Ÿĸ (U+0178 U+0138)
  0x01, 0x78, 0x01, 0x44, 0x01, // Ÿń (U+0178 U+0144)
  0x01, 0x78, 0x01, 0x46, 0x01, // Ÿņ (U+0178 U+0146)
  0x01, 0x78, 0x01, 0x4B, 0x01, // Ÿŋ (U+0178 U+014B)
  0x01, 0x78, 0x01, 0x4D, 0x01, // Ÿō (U+0178 U+014D)
  0x01, 0x78, 0x01, 0x4F, 0x01, // Ÿŏ (U+0178 U+014F)
  0x01, 0x78, 0x01, 0x51, 0x01, // Ÿő (U+0178 U+0151)
  0x01, 0x78, 0x01, 0x53, 0x01, // Ÿœ (U+0178 U+0153)
  0x01, 0x78, 0x01, 0x55, 0x01, // Ÿŕ (U+0178 U+0155)
  0x01, 0x78, 0x01, 0x57, 0x01, // Ÿŗ (U+0178 U+0157)
  0x01, 0x78, 0x01, 0x5B, 0x01, // Ÿś (U+0178 U+015B)
  0x01, 0x78, 0x01, 0x5F, 0x01, // Ÿş (U+0178 U+015F)
  0x01, 0x78, 0x01, 0x69, 0x01, // Ÿũ (U+0178 U+0169)
  0x01, 0x78, 0x01, 0x6B, 0x01, // Ÿū (U+0178 U+016B)
  0x01, 0x78, 0x01, 0x6D, 0x01, // Ÿŭ (U+0178 U+016D)
  0x01, 0x78, 0x01, 0x6F, 0x01, // Ÿů (U+0178 U+016F)
  0x01, 0x78, 0x01, 0x71, 0x01, // Ÿű (U+0178 U+0171)
  0x01, 0x78, 0x01, 0x73, 0x01, // Ÿų (U+0178 U+0173)
  0x01, 0x78, 0x20, 0x1A, 0x01, // Ÿ‚ (U+0178 U+201A)
  0x01, 0x78, 0x20, 0x1E, 0x01, // Ÿ„ (U+0178 U+201E)
  0x01, 0x78, 0x20, 0x26, 0x01, // Ÿ… (U+0178 U+2026)
  0x01, 0x78, 0x20, 0x39, 0x02, // Ÿ‹ (U+0178 U+2039)
  0x01, 0x78, 0x20, 0x3A, 0x01, // Ÿ› (U+0178 U+203A)
  0x20, 0x13, 0x00, 0x54, 0x01, // –T (U+2013 U+0054)
  0x20, 0x13, 0x01, 0x62, 0x01, // –Ţ (U+2013 U+0162)
  0x20, 0x13, 0x01, 0x64, 0x01, // –Ť (U+2013 U+0164)
  0x20, 0x13, 0x01, 0x66, 0x01, // –Ŧ (U+2013 U+0166)
  0x20, 0x14, 0x00, 0x54, 0x01, // —T (U+2014 U+0054)
  0x20, 0x14, 0x01, 0x62, 0x01, // —Ţ (U+2014 U+0162)
  0x20, 0x14, 0x01, 0x64, 0x01, // —Ť (U+2014 U+0164)
  0x20, 0x14, 0x01, 0x66, 0x01, // —Ŧ (U+2014 U+0166)
  0x20, 0x18, 0x00, 0x41, 0x02, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0x61, 0x01, // ‘a (U+2018 U+0061)
  0x20, 0x18, 0x00, 0x63, 0x01, // ‘c (U+2018 U+0063)
  0x20, 0x18, 0x00, 0x64, 0x01, // ‘d (U+2018 U+0064)
  0x20, 0x18, 0x00, 0x65, 0x01, // ‘e (U+2018 U+0065)
  0x20, 0x18, 0x00, 0x67, 0x01, // ‘g (U+2018 U+0067)
  0x20, 0x18, 0x00, 0x6D, 0x01, // ‘m (U+2018 U+006D)
  0x20, 0x18, 0x00, 0x6E, 0x01, // ‘n (U+2018 U+006E)
  0x20, 0x18, 0x00, 0x6F, 0x01, // ‘o (U+2018 U+006F)
  0x20, 0x18, 0x00, 0x70, 0x01, // ‘p (U+2018 U+0070)
  0x20, 0x18, 0x00, 0x71, 0x01, // ‘q (U+2018 U+0071)
  0x20, 0x18, 0x00, 0x72, 0x01, // ‘r (U+2018 U+0072)
  0x20, 0x18, 0x00, 0x73, 0x01, // ‘s (U+2018 U+0073)
  0x20, 0x18, 0x00, 0x75, 0x01, // ‘u (U+2018 U+0075)
  0x20, 0x18, 0x00, 0xC0, 0x02, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x02, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x02, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x02, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x02, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x02, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x02, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x00, 0xE0, 0x01, // ‘à (U+2018 U+00E0)
  0x20, 0x18, 0x00, 0xE1, 0x01, // ‘á (U+2018 U+00E1)
  0x20, 0x18, 0x00, 0xE2, 0x01, // ‘â (U+2018 U+00E2)
  0x20, 0x18, 0x00, 0xE3, 0x01, // ‘ã (U+2018 U+00E3)
  0x20, 0x18, 0x00, 0xE4, 0x01, // ‘ä (U+2018 U+00E4)
  0x20, 0x18, 0x00, 0xE5, 0x01, // ‘å (U+2018 U+00E5)
  0x20, 0x18, 0x00, 0xE6, 0x01, // ‘æ (U+2018 U+00E6)
  0x20, 0x18, 0x00, 0xE7, 0x01, // ‘ç (U+2018 U+00E7)
  0x20, 0x18, 0x00, 0xE8, 0x01, // ‘è (U+2018 U+00E8)
  0x20, 0x18, 0x00, 0xE9, 0x01, // ‘é (U+2018 U+00E9)
  0x20, 0x18, 0x00, 0xEA, 0x01, // ‘ê (U+2018 U+00EA)
  0x20, 0x18, 0x00, 0xEB, 0x01, // ‘ë (U+2018 U+00EB)
  0x20, 0x18, 0x00, 0xF2, 0x01, // ‘ò (U+2018 U+00F2)
  0x20, 0x18, 0x00, 0xF3, 0x01, // ‘ó (U+2018 U+00F3)
  0x20, 0x18, 0x00, 0xF4, 0x01, // ‘ô (U+2018 U+00F4)
  0x20, 0x18, 0x00, 0xF5, 0x01, // ‘õ (U+2018 U+00F5)
  0x20, 0x18, 0x00, 0xF6, 0x01, // ‘ö (U+2018 U+00F6)
  0x20, 0x18, 0x00, 0xF8, 0x01, // ‘ø (U+2018 U+00F8)
  0x20, 0x18, 0x00, 0xF9, 0x01, // ‘ù (U+2018 U+00F9)
  0x20, 0x18, 0x00, 0xFA, 0x01, // ‘ú (U+2018 U+00FA)
  0x20, 0x18, 0x00, 0xFB, 0x01, // ‘û (U+2018 U+00FB)
  0x20, 0x18, 0x00, 0xFC, 0x01, // ‘ü (U+2018 U+00FC)
  0x20, 0x18, 0x01, 0x00, 0x02, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x01, 0x01, // ‘ā (U+2018 U+0101)
  0x20, 0x18, 0x01, 0x02, 0x02, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x03, 0x01, // ‘ă (U+2018 U+0103)
  0x20, 0x18, 0x01, 0x04, 0x02, // ‘Ą (U+2018 U+0104)
  0x20, 0x18, 0x01, 0x05, 0x01, // ‘ą (U+2018 U+0105)
  0x20, 0x18, 0x01, 0x07, 0x01, // ‘ć (U+2018 U+0107)
  0x20, 0x18, 0x01, 0x09, 0x01, // ‘ĉ (U+2018 U+0109)
  0x20, 0x18, 0x01, 0x0B, 0x01, // ‘ċ (U+2018 U+010B)
  0x20, 0x18, 0x01, 0x0D, 0x01, // ‘č (U+2018 U+010D)
  0x20, 0x18, 0x01, 0x0F, 0x01, // ‘ď (U+2018 U+010F)
  0x20, 0x18, 0x01, 0x11, 0x01, // ‘đ (U+2018 U+0111)
  0x20, 0x18, 0x01, 0x13, 0x01, // ‘ē (U+2018 U+0113)
  0x20, 0x18, 0x01, 0x15, 0x01, // ‘ĕ (U+2018 U+0115)
  0x20, 0x18, 0x01, 0x17, 0x01, // ‘ė (U+2018 U+0117)
  0x20, 0x18, 0x01, 0x19, 0x01, // ‘ę (U+2018 U+0119)
  0x20, 0x18, 0x01, 0x1B, 0x01, // ‘ě (U+2018 U+011B)
  0x20, 0x18, 0x01, 0x1D, 0x01, // ‘ĝ (U+2018 U+011D)
  0x20, 0x18, 0x01, 0x1F, 0x01, // ‘ğ (U+2018 U+011F)
  0x20, 0x18, 0x01, 0x21, 0x01, // ‘ġ (U+2018 U+0121)
  0x20, 0x18, 0x01, 0x23, 0x01, // ‘ģ (U+2018 U+0123)
  0x20, 0x18, 0x01, 0x38, 0x01, // ‘ĸ (U+2018 U+0138)
  0x20, 0x18, 0x01, 0x44, 0x01, // ‘ń (U+2018 U+0144)
  0x20, 0x18, 0x01, 0x46, 0x01, // ‘ņ (U+2018 U+0146)
  0x20, 0x18, 0x01, 0x4B, 0x01, // ‘ŋ (U+2018 U+014B)
  0x20, 0x18, 0x01, 0x4D, 0x01, // ‘ō (U+2018 U+014D)
  0x20, 0x18, 0x01, 0x4F, 0x01, // ‘ŏ (U+2018 U+014F)
  0x20, 0x18, 0x01, 0x51, 0x01, // ‘ő (U+2018 U+0151)
  0x20, 0x18, 0x01, 0x53, 0x01, // ‘œ (U+2018 U+0153)
  0x20, 0x18, 0x01, 0x55, 0x01, // ‘ŕ (U+2018 U+0155)
  0x20, 0x18, 0x01, 0x57, 0x01, // ‘ŗ (U+2018 U+0157)
  0x20, 0x18, 0x01, 0x5B, 0x01, // ‘ś (U+2018 U+015B)
  0x20, 0x18, 0x01, 0x5F, 0x01, // ‘ş (U+2018 U+015F)
  0x20, 0x18, 0x01, 0x69, 0x01, // ‘ũ (U+2018 U+0169)
  0x20, 0x18, 0x01, 0x6B, 0x01, // ‘ū (U+2018 U+016B)
  0x20, 0x18, 0x01, 0x6D, 0x01, // ‘ŭ (U+2018 U+016D)
  0x20, 0x18, 0x01, 0x6F, 0x01, // ‘ů (U+2018 U+016F)
  0x20, 0x18, 0x01, 0x71, 0x01, // ‘ű (U+2018 U+0171)
  0x20, 0x18, 0x01, 0x73, 0x01, // ‘ų (U+2018 U+0173)
  0x20, 0x19, 0x00, 0x41, 0x02, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0x61, 0x01, // ’a (U+2019 U+0061)
  0x20, 0x19, 0x00, 0x63, 0x01, // ’c (U+2019 U+0063)
  0x20, 0x19, 0x00, 0x64, 0x01, // ’d (U+2019 U+0064)
  0x20, 0x19, 0x00, 0x65, 0x01, // ’e (U+2019 U+0065)
  0x20, 0x19, 0x00, 0x67, 0x01, // ’g (U+2019 U+0067)
  0x20, 0x19, 0x00, 0x6D, 0x01, // ’m (U+2019 U+006D)
  0x20, 0x19, 0x00, 0x6E, 0x01, // ’n (U+2019 U+006E)
  0x20, 0x19, 0x00, 0x6F, 0x01, // ’o (U+2019 U+006F)
  0x20, 0x19, 0x00, 0x70, 0x01, // ’p (U+2019 U+0070)
  0x20, 0x19, 0x00, 0x71, 0x01, // ’q (U+2019 U+0071)
  0x20, 0x19, 0x00, 0x72, 0x01, // ’r (U+2019 U+0072)
  0x20, 0x19, 0x00, 0x73, 0x01, // ’s (U+2019 U+0073)
  0x20, 0x19, 0x00, 0x75, 0x01, // ’u (U+2019 U+0075)
  0x20, 0x19, 0x00, 0xC0, 0x02, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x02, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x02, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x02, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x02, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x02, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x02, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x00, 0xE0, 0x01, // ’à (U+2019 U+00E0)
  0x20, 0x19, 0x00, 0xE1, 0x01, // ’á (U+2019 U+00E1)
  0x20, 0x19, 0x00, 0xE2, 0x01, // ’â (U+2019 U+00E2)
  0x20, 0x19, 0x00, 0xE3, 0x01, // ’ã (U+2019 U+00E3)
  0x20, 0x19, 0x00, 0xE4, 0x01, // ’ä (U+2019 U+00E4)
  0x20, 0x19, 0x00, 0xE5, 0x01, // ’å (U+2019 U+00E5)
  0x20, 0x19, 0x00, 0xE6, 0x01, // ’æ (U+2019 U+00E6)
  0x20, 0x19, 0x00, 0xE7, 0x01, // ’ç (U+2019 U+00E7)
  0x20, 0x19, 0x00, 0xE8, 0x01, // ’è (U+2019 U+00E8)
  0x20, 0x19, 0x00, 0xE9, 0x01, // ’é (U+2019 U+00E9)
  0x20, 0x19, 0x00, 0xEA, 0x01, // ’ê (U+2019 U+00EA)
  0x20, 0x19, 0x00, 0xEB, 0x01, // ’ë (U+2019 U+00EB)
  0x20, 0x19, 0x00, 0xF2, 0x01, // ’ò (U+2019 U+00F2)
  0x20, 0x19, 0x00, 0xF3, 0x01, // ’ó (U+2019 U+00F3)
  0x20, 0x19, 0x00, 0xF4, 0x01, // ’ô (U+2019 U+00F4)
  0x20, 0x19, 0x00, 0xF5, 0x01, // ’õ (U+2019 U+00F5)
  0x20, 0x19, 0x00, 0xF6, 0x01, // ’ö (U+2019 U+00F6)
  0x20, 0x19, 0x00, 0xF8, 0x01, // ’ø (U+2019 U+00F8)
  0x20, 0x19, 0x00, 0xF9, 0x01, // ’ù (U+2019 U+00F9)
  0x20, 0x19, 0x00, 0xFA, 0x01, // ’ú (U+2019 U+00FA)
  0x20, 0x19, 0x00, 0xFB, 0x01, // ’û (U+2019 U+00FB)
  0x20, 0x19, 0x00, 0xFC, 0x01, // ’ü (U+2019 U+00FC)
  0x20, 0x19, 0x01, 0x00, 0x02, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x01, 0x01, // ’ā (U+2019 U+0101)
  0x20, 0x19, 0x01, 0x02, 0x02, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x03, 0x01, // ’ă (U+2019 U+0103)
  0x20, 0x19, 0x01, 0x04, 0x02, // ’Ą (U+2019 U+0104)
  0x20, 0x19, 0x01, 0x05, 0x01, // ’ą (U+2019 U+0105)
  0x20, 0x19, 0x01, 0x07, 0x01, // ’ć (U+2019 U+0107)
  0x20, 0x19, 0x01, 0x09, 0x01, // ’ĉ (U+2019 U+0109)
  0x20, 0x19, 0x01, 0x0B, 0x01, // ’ċ (U+2019 U+010B)
  0x20, 0x19, 0x01, 0x0D, 0x01, // ’č (U+2019 U+010D)
  0x20, 0x19, 0x01, 0x0F, 0x01, // ’ď (U+2019 U+010F)
  0x20, 0x19, 0x01, 0x11, 0x01, // ’đ (U+2019 U+0111)
  0x20, 0x19, 0x01, 0x13, 0x01, // ’ē (U+2019 U+0113)
  0x20, 0x19, 0x01, 0x15, 0x01, // ’ĕ (U+2019 U+0115)
  0x20, 0x19, 0x01, 0x17, 0x01, // ’ė (U+2019 U+0117)
  0x20, 0x19, 0x01, 0x19, 0x01, // ’ę (U+2019 U+0119)
  0x20, 0x19, 0x01, 0x1B, 0x01, // ’ě (U+2019 U+011B)
  0x20, 0x19, 0x01, 0x1D, 0x01, // ’ĝ (U+2019 U+011D)
  0x20, 0x19, 0x01, 0x1F, 0x01, // ’ğ (U+2019 U+011F)
  0x20, 0x19, 0x01, 0x21, 0x01, // ’ġ (U+2019 U+0121)
  0x20, 0x19, 0x01, 0x23, 0x01, // ’ģ (U+2019 U+0123)
  0x20, 0x19, 0x01, 0x38, 0x01, // ’ĸ (U+2019 U+0138)
  0x20, 0x19, 0x01, 0x44, 0x01, // ’ń (U+2019 U+0144)
  0x20, 0x19, 0x01, 0x46, 0x01, // ’ņ (U+2019 U+0146)
  0x20, 0x19, 0x01, 0x4B, 0x01, // ’ŋ (U+2019 U+014B)
  0x20, 0x19, 0x01, 0x4D, 0x01, // ’ō (U+2019 U+014D)
  0x20, 0x19, 0x01, 0x4F, 0x01, // ’ŏ (U+2019 U+014F)
  0x20, 0x19, 0x01, 0x51, 0x01, // ’ő (U+2019 U+0151)
  0x20, 0x19, 0x01, 0x53, 0x01, // ’œ (U+2019 U+0153)
  0x20, 0x19, 0x01, 0x55, 0x01, // ’ŕ (U+2019 U+0155)
  0x20, 0x19, 0x01, 0x57, 0x01, // ’ŗ (U+2019 U+0157)
  0x20, 0x19, 0x01, 0x5B, 0x01, // ’ś (U+2019 U+015B)
  0x20, 0x19, 0x01, 0x5F, 0x01, // ’ş (U+2019 U+015F)
  0x20, 0x19, 0x01, 0x69, 0x01, // ’ũ (U+2019 U+0169)
  0x20, 0x19, 0x01, 0x6B, 0x01, // ’ū (U+2019 U+016B)
  0x20, 0x19, 0x01, 0x6D, 0x01, // ’ŭ (U+2019 U+016D)
  0x20, 0x19, 0x01, 0x6F, 0x01, // ’ů (U+2019 U+016F)
  0x20, 0x19, 0x01, 0x71, 0x01, // ’ű (U+2019 U+0171)
  0x20, 0x19, 0x01, 0x73, 0x01, // ’ų (U+2019 U+0173)
  0x20, 0x1A, 0x00, 0x43, 0x01, // ‚C (U+201A U+0043)
  0x20, 0x1A, 0x00, 0x47, 0x01, // ‚G (U+201A U+0047)
  0x20, 0x1A, 0x00, 0x4F, 0x01, // ‚O (U+201A U+004F)
  0x20, 0x1A, 0x00, 0x51, 0x01, // ‚Q (U+201A U+0051)
  0x20, 0x1A, 0x00, 0x54, 0x02, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x00, 0x56, 0x01, // ‚V (U+201A U+0056)
  0x20, 0x1A, 0x00, 0x57, 0x01, // ‚W (U+201A U+0057)
  0x20, 0x1A, 0x00, 0x59, 0x01, // ‚Y (U+201A U+0059)
  0x20, 0x1A, 0x00, 0xC7, 0x01, // ‚Ç (U+201A U+00C7)
  0x20, 0x1A, 0x00, 0xD2, 0x01, // ‚Ò (U+201A U+00D2)
  0x20, 0x1A, 0x00, 0xD3, 0x01, // ‚Ó (U+201A U+00D3)
  0x20, 0x1A, 0x00, 0xD4, 0x01, // ‚Ô (U+201A U+00D4)
  0x20, 0x1A, 0x00, 0xD5, 0x01, // ‚Õ (U+201A U+00D5)
  0x20, 0x1A, 0x00, 0xD6, 0x01, // ‚Ö (U+201A U+00D6)
  0x20, 0x1A, 0x00, 0xD8, 0x01, // ‚Ø (U+201A U+00D8)
  0x20, 0x1A, 0x00, 0xDD, 0x01, // ‚Ý (U+201A U+00DD)
  0x20, 0x1A, 0x01, 0x06, 0x01, // ‚Ć (U+201A U+0106)
  0x20, 0x1A, 0x01, 0x08, 0x01, // ‚Ĉ (U+201A U+0108)
  0x20, 0x1A, 0x01, 0x0A, 0x01, // ‚Ċ (U+201A U+010A)
  0x20, 0x1A, 0x01, 0x0C, 0x01, // ‚Č (U+201A U+010C)
  0x20, 0x1A, 0x01, 0x1C, 0x01, // ‚Ĝ (U+201A U+011C)
  0x20, 0x1A, 0x01, 0x1E, 0x01, // ‚Ğ (U+201A U+011E)
  0x20, 0x1A, 0x01, 0x20, 0x01, // ‚Ġ (U+201A U+0120)
  0x20, 0x1A, 0x01, 0x22, 0x01, // ‚Ģ (U+201A U+0122)
  0x20, 0x1A, 0x01, 0x4C, 0x01, // ‚Ō (U+201A U+014C)
  0x20, 0x1A, 0x01, 0x4E, 0x01, // ‚Ŏ (U+201A U+014E)
  0x20, 0x1A, 0x01, 0x50, 0x01, // ‚Ő (U+201A U+0150)
  0x20, 0x1A, 0x01, 0x52, 0x01, // ‚Œ (U+201A U+0152)
  0x20, 0x1A, 0x01, 0x62, 0x02, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x02, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x02, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1A, 0x01, 0x74, 0x01, // ‚Ŵ (U+201A U+0174)
  0x20, 0x1A, 0x01, 0x76, 0x01, // ‚Ŷ (U+201A U+0176)
  0x20, 0x1A, 0x01, 0x78, 0x01, // ‚Ÿ (U+201A U+0178)
  0x20, 0x1C, 0x00, 0x41, 0x02, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0x61, 0x01, // “a (U+201C U+0061)
  0x20, 0x1C, 0x00, 0x63, 0x01, // “c (U+201C U+0063)
  0x20, 0x1C, 0x00, 0x64, 0x01, // “d (U+201C U+0064)
  0x20, 0x1C, 0x00, 0x65, 0x01, // “e (U+201C U+0065)
  0x20, 0x1C, 0x00, 0x67, 0x01, // “g (U+201C U+0067)
  0x20, 0x1C, 0x00, 0x6D, 0x01, // “m (U+201C U+006D)
  0x20, 0x1C, 0x00, 0x6E, 0x01, // “n (U+201C U+006E)
  0x20, 0x1C, 0x00, 0x6F, 0x01, // “o (U+201C U+006F)
  0x20, 0x1C, 0x00, 0x70, 0x01, // “p (U+201C U+0070)
  0x20, 0x1C, 0x00, 0x71, 0x01, // “q (U+201C U+0071)
  0x20, 0x1C, 0x00, 0x72, 0x01, // “r (U+201C U+0072)
  0x20, 0x1C, 0x00, 0x73, 0x01, // “s (U+201C U+0073)
  0x20, 0x1C, 0x00, 0x75, 0x01, // “u (U+201C U+0075)
  0x20, 0x1C, 0x00, 0xC0, 0x02, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x02, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x02, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x02, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x02, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x02, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x02, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x00, 0xE0, 0x01, // “à (U+201C U+00E0)
  0x20, 0x1C, 0x00, 0xE1, 0x01, // “á (U+201C U+00E1)
  0x20, 0x1C, 0x00, 0xE2, 0x01, // “â (U+201C U+00E2)
  0x20, 0x1C, 0x00, 0xE3, 0x01, // “ã (U+201C U+00E3)
  0x20, 0x1C, 0x00, 0xE4, 0x01, // “ä (U+201C U+00E4)
  0x20, 0x1C, 0x00, 0xE5, 0x01, // “å (U+201C U+00E5)
  0x20, 0x1C, 0x00, 0xE6, 0x01, // “æ (U+201C U+00E6)
  0x20, 0x1C, 0x00, 0xE7, 0x01, // “ç (U+201C U+00E7)
  0x20, 0x1C, 0x00, 0xE8, 0x01, // “è (U+201C U+00E8)
  0x20, 0x1C, 0x00, 0xE9, 0x01, // “é (U+201C U+00E9)
  0x20, 0x1C, 0x00, 0xEA, 0x01, // “ê (U+201C U+00EA)
  0x20, 0x1C, 0x00, 0xEB, 0x01, // “ë (U+201C U+00EB)
  0x20, 0x1C, 0x00, 0xF2, 0x01, // “ò (U+201C U+00F2)
  0x20, 0x1C, 0x00, 0xF3, 0x01, // “ó (U+201C U+00F3)
  0x20, 0x1C, 0x00, 0xF4, 0x01, // “ô (U+201C U+00F4)
  0x20, 0x1C, 0x00, 0xF5, 0x01, // “õ (U+201C U+00F5)
  0x20, 0x1C, 0x00, 0xF6, 0x01, // “ö (U+201C U+00F6)
  0x20, 0x1C, 0x00, 0xF8, 0x01, // “ø (U+201C U+00F8)
  0x20, 0x1C, 0x00, 0xF9, 0x01, // “ù (U+201C U+00F9)
  0x20, 0x1C, 0x00, 0xFA, 0x01, // “ú (U+201C U+00FA)
  0x20, 0x1C, 0x00, 0xFB, 0x01, // “û (U+201C U+00FB)
  0x20, 0x1C, 0x00, 0xFC, 0x01, // “ü (U+201C U+00FC)
  0x20, 0x1C, 0x01, 0x00, 0x02, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x01, 0x01, // “ā (U+201C U+0101)
  0x20, 0x1C, 0x01, 0x02, 0x02, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x03, 0x01, // “ă (U+201C U+0103)
  0x20, 0x1C, 0x01, 0x04, 0x02, // “Ą (U+201C U+0104)
  0x20, 0x1C, 0x01, 0x05, 0x01, // “ą (U+201C U+0105)
  0x20, 0x1C, 0x01, 0x07, 0x01, // “ć (U+201C U+0107)
  0x20, 0x1C, 0x01, 0x09, 0x01, // “ĉ (U+201C U+0109)
  0x20, 0x1C, 0x01, 0x0B, 0x01, // “ċ (U+201C U+010B)
  0x20, 0x1C, 0x01, 0x0D, 0x01, // “č (U+201C U+010D)
  0x20, 0x1C, 0x01, 0x0F, 0x01, // “ď (U+201C U+010F)
  0x20, 0x1C, 0x01, 0x11, 0x01, // “đ (U+201C U+0111)
  0x20, 0x1C, 0x01, 0x13, 0x01, // “ē (U+201C U+0113)
  0x20, 0x1C, 0x01, 0x15, 0x01, // “ĕ (U+201C U+0115)
  0x20, 0x1C, 0x01, 0x17, 0x01, // “ė (U+201C U+0117)
  0x20, 0x1C, 0x01, 0x19, 0x01, // “ę (U+201C U+0119)
  0x20, 0x1C, 0x01, 0x1B, 0x01, // “ě (U+201C U+011B)
  0x20, 0x1C, 0x01, 0x1D, 0x01, // “ĝ (U+201C U+011D)
  0x20, 0x1C, 0x01, 0x1F, 0x01, // “ğ (U+201C U+011F)
  0x20, 0x1C, 0x01, 0x21, 0x01, // “ġ (U+201C U+0121)
  0x20, 0x1C, 0x01, 0x23, 0x01, // “ģ (U+201C U+0123)
  0x20, 0x1C, 0x01, 0x38, 0x01, // “ĸ (U+201C U+0138)
  0x20, 0x1C, 0x01, 0x44, 0x01, // “ń (U+201C U+0144)
  0x20, 0x1C, 0x01, 0x46, 0x01, // “ņ (U+201C U+0146)
  0x20, 0x1C, 0x01, 0x4B, 0x01, // “ŋ (U+201C U+014B)
  0x20, 0x1C, 0x01, 0x4D, 0x01, // “ō (U+201C U+014D)
  0x20, 0x1C, 0x01, 0x4F, 0x01, // “ŏ (U+201C U+014F)
  0x20, 0x1C, 0x01, 0x51, 0x01, // “ő (U+201C U+0151)
  0x20, 0x1C, 0x01, 0x53, 0x01, // “œ (U+201C U+0153)
  0x20, 0x1C, 0x01, 0x55, 0x01, // “ŕ (U+201C U+0155)
  0x20, 0x1C, 0x01, 0x57, 0x01, // “ŗ (U+201C U+0157)
  0x20, 0x1C, 0x01, 0x5B, 0x01, // “ś (U+201C U+015B)
  0x20, 0x1C, 0x01, 0x5F, 0x01, // “ş (U+201C U+015F)
  0x20, 0x1C, 0x01, 0x69, 0x01, // “ũ (U+201C U+0169)
  0x20, 0x1C, 0x01, 0x6B, 0x01, // “ū (U+201C U+016B)
  0x20, 0x1C, 0x01, 0x6D, 0x01, // “ŭ (U+201C U+016D)
  0x20, 0x1C, 0x01, 0x6F, 0x01, // “ů (U+201C U+016F)
  0x20, 0x1C, 0x01, 0x71, 0x01, // “ű (U+201C U+0171)
  0x20, 0x1C, 0x01, 0x73, 0x01, // “ų (U+201C U+0173)
  0x20, 0x1D, 0x00, 0x41, 0x02, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0x61, 0x01, // ”a (U+201D U+0061)
  0x20, 0x1D, 0x00, 0x63, 0x01, // ”c (U+201D U+0063)
  0x20, 0x1D, 0x00, 0x64, 0x01, // ”d (U+201D U+0064)
  0x20, 0x1D, 0x00, 0x65, 0x01, // ”e (U+201D U+0065)
  0x20, 0x1D, 0x00, 0x67, 0x01, // ”g (U+201D U+0067)
  0x20, 0x1D, 0x00, 0x6D, 0x01, // ”m (U+201D U+006D)
  0x20, 0x1D, 0x00, 0x6E, 0x01, // ”n (U+201D U+006E)
  0x20, 0x1D, 0x00, 0x6F, 0x01, // ”o (U+201D U+006F)
  0x20, 0x1D, 0x00, 0x70, 0x01, // ”p (U+201D U+0070)
  0x20, 0x1D, 0x00, 0x71, 0x01, // ”q (U+201D U+0071)
  0x20, 0x1D, 0x00, 0x72, 0x01, // ”r (U+201D U+0072)
  0x20, 0x1D, 0x00, 0x73, 0x01, // ”s (U+201D U+0073)
  0x20, 0x1D, 0x00, 0x75, 0x01, // ”u (U+201D U+0075)
  0x20, 0x1D, 0x00, 0xC0, 0x02, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x02, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x02, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x02, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x02, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x02, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x02, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x00, 0xE0, 0x01, // ”à (U+201D U+00E0)
  0x20, 0x1D, 0x00, 0xE1, 0x01, // ”á (U+201D U+00E1)
  0x20, 0x1D, 0x00, 0xE2, 0x01, // ”â (U+201D U+00E2)
  0x20, 0x1D, 0x00, 0xE3, 0x01, // ”ã (U+201D U+00E3)
  0x20, 0x1D, 0x00, 0xE4, 0x01, // ”ä (U+201D U+00E4)
  0x20, 0x1D, 0x00, 0xE5, 0x01, // ”å (U+201D U+00E5)
  0x20, 0x1D, 0x00, 0xE6, 0x01, // ”æ (U+201D U+00E6)
  0x20, 0x1D, 0x00, 0xE7, 0x01, // ”ç (U+201D U+00E7)
  0x20, 0x1D, 0x00, 0xE8, 0x01, // ”è (U+201D U+00E8)
  0x20, 0x1D, 0x00, 0xE9, 0x01, // ”é (U+201D U+00E9)
  0x20, 0x1D, 0x00, 0xEA, 0x01, // ”ê (U+201D U+00EA)
  0x20, 0x1D, 0x00, 0xEB, 0x01, // ”ë (U+201D U+00EB)
  0x20, 0x1D, 0x00, 0xF2, 0x01, // ”ò (U+201D U+00F2)
  0x20, 0x1D, 0x00, 0xF3, 0x01, // ”ó (U+201D U+00F3)
  0x20, 0x1D, 0x00, 0xF4, 0x01, // ”ô (U+201D U+00F4)
  0x20, 0x1D, 0x00, 0xF5, 0x01, // ”õ (U+201D U+00F5)
  0x20, 0x1D, 0x00, 0xF6, 0x01, // ”ö (U+201D U+00F6)
  0x20, 0x1D, 0x00, 0xF8, 0x01, // ”ø (U+201D U+00F8)
  0x20, 0x1D, 0x00, 0xF9, 0x01, // ”ù (U+201D U+00F9)
  0x20, 0x1D, 0x00, 0xFA, 0x01, // ”ú (U+201D U+00FA)
  0x20, 0x1D, 0x00, 0xFB, 0x01, // ”û (U+201D U+00FB)
  0x20, 0x1D, 0x00, 0xFC, 0x01, // ”ü (U+201D U+00FC)
  0x20, 0x1D, 0x01, 0x00, 0x02, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x01, 0x01, // ”ā (U+201D U+0101)
  0x20, 0x1D, 0x01, 0x02, 0x02, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x03, 0x01, // ”ă (U+201D U+0103)
  0x20, 0x1D, 0x01, 0x04, 0x02, // ”Ą (U+201D U+0104)
  0x20, 0x1D, 0x01, 0x05, 0x01, // ”ą (U+201D U+0105)
  0x20, 0x1D, 0x01, 0x07, 0x01, // ”ć (U+201D U+0107)
  0x20, 0x1D, 0x01, 0x09, 0x01, // ”ĉ (U+201D U+0109)
  0x20, 0x1D, 0x01, 0x0B, 0x01, // ”ċ (U+201D U+010B)
  0x20, 0x1D, 0x01, 0x0D, 0x01, // ”č (U+201D U+010D)
  0x20, 0x1D, 0x01, 0x0F, 0x01, // ”ď (U+201D U+010F)
  0x20, 0x1D, 0x01, 0x11, 0x01, // ”đ (U+201D U+0111)
  0x20, 0x1D, 0x01, 0x13, 0x01, // ”ē (U+201D U+0113)
  0x20, 0x1D, 0x01, 0x15, 0x01, // ”ĕ (U+201D U+0115)
  0x20, 0x1D, 0x01, 0x17, 0x01, // ”ė (U+201D U+0117)
  0x20, 0x1D, 0x01, 0x19, 0x01, // ”ę (U+201D U+0119)
  0x20, 0x1D, 0x01, 0x1B, 0x01, // ”ě (U+201D U+011B)
  0x20, 0x1D, 0x01, 0x1D, 0x01, // ”ĝ (U+201D U+011D)
  0x20, 0x1D, 0x01, 0x1F, 0x01, // ”ğ (U+201D U+011F)
  0x20, 0x1D, 0x01, 0x21, 0x01, // ”ġ (U+201D U+0121)
  0x20, 0x1D, 0x01, 0x23, 0x01, // ”ģ (U+201D U+0123)
  0x20, 0x1D, 0x01, 0x38, 0x01, // ”ĸ (U+201D U+0138)
  0x20, 0x1D, 0x01, 0x44, 0x01, // ”ń (U+201D U+0144)
  0x20, 0x1D, 0x01, 0x46, 0x01, // ”ņ (U+201D U+0146)
  0x20, 0x1D, 0x01, 0x4B, 0x01, // ”ŋ (U+201D U+014B)
  0x20, 0x1D, 0x01, 0x4D, 0x01, // ”ō (U+201D U+014D)
  0x20, 0x1D, 0x01, 0x4F, 0x01, // ”ŏ (U+201D U+014F)
  0x20, 0x1D, 0x01, 0x51, 0x01, // ”ő (U+201D U+0151)
  0x20, 0x1D, 0x01, 0x53, 0x01, // ”œ (U+201D U+0153)
  0x20, 0x1D, 0x01, 0x55, 0x01, // ”ŕ (U+201D U+0155)
  0x20, 0x1D, 0x01, 0x57, 0x01, // ”ŗ (U+201D U+0157)
  0x20, 0x1D, 0x01, 0x5B, 0x01, // ”ś (U+201D U+015B)
  0x20, 0x1D, 0x01, 0x5F, 0x01, // ”ş (U+201D U+015F)
  0x20, 0x1D, 0x01, 0x69, 0x01, // ”ũ (U+201D U+0169)
  0x20, 0x1D, 0x01, 0x6B, 0x01, // ”ū (U+201D U+016B)
  0x20, 0x1D, 0x01, 0x6D, 0x01, // ”ŭ (U+201D U+016D)
  0x20, 0x1D, 0x01, 0x6F, 0x01, // ”ů (U+201D U+016F)
  0x20, 0x1D, 0x01, 0x71, 0x01, // ”ű (U+201D U+0171)
  0x20, 0x1D, 0x01, 0x73, 0x01, // ”ų (U+201D U+0173)
  0x20, 0x1E, 0x00, 0x43, 0x01, // „C (U+201E U+0043)
  0x20, 0x1E, 0x00, 0x47, 0x01, // „G (U+201E U+0047)
  0x20, 0x1E, 0x00, 0x4F, 0x01, // „O (U+201E U+004F)
  0x20, 0x1E, 0x00, 0x51, 0x01, // „Q (U+201E U+0051)
  0x20, 0x1E, 0x00, 0x54, 0x02, // „T (U+201E U+0054)
  0x20, 0x1E, 0x00, 0x56, 0x01, // „V (U+201E U+0056)
  0x20, 0x1E, 0x00, 0x57, 0x01, // „W (U+201E U+0057)
  0x20, 0x1E, 0x00, 0x59, 0x01, // „Y (U+201E U+0059)
  0x20, 0x1E, 0x00, 0xC7, 0x01, // „Ç (U+201E U+00C7)
  0x20, 0x1E, 0x00, 0xD2, 0x01, // „Ò (U+201E U+00D2)
  0x20, 0x1E, 0x00, 0xD3, 0x01, // „Ó (U+201E U+00D3)
  0x20, 0x1E, 0x00, 0xD4, 0x01, // „Ô (U+201E U+00D4)
  0x20, 0x1E, 0x00, 0xD5, 0x01, // „Õ (U+201E U+00D5)
  0x20, 0x1E, 0x00, 0xD6, 0x01, // „Ö (U+201E U+00D6)
  0x20, 0x1E, 0x00, 0xD8, 0x01, // „Ø (U+201E U+00D8)
  0x20, 0x1E, 0x00, 0xDD, 0x01, // „Ý (U+201E U+00DD)
  0x20, 0x1E, 0x01, 0x06, 0x01, // „Ć (U+201E U+0106)
  0x20, 0x1E, 0x01, 0x08, 0x01, // „Ĉ (U+201E U+0108)
  0x20, 0x1E, 0x01, 0x0A, 0x01, // „Ċ (U+201E U+010A)
  0x20, 0x1E, 0x01, 0x0C, 0x01, // „Č (U+201E U+010C)
  0x20, 0x1E, 0x01, 0x1C, 0x01, // „Ĝ (U+201E U+011C)
  0x20, 0x1E, 0x01, 0x1E, 0x01, // „Ğ (U+201E U+011E)
  0x20, 0x1E, 0x01, 0x20, 0x01, // „Ġ (U+201E U+0120)
  0x20, 0x1E, 0x01, 0x22, 0x01, // „Ģ (U+201E U+0122)
  0x20, 0x1E, 0x01, 0x4C, 0x01, // „Ō (U+201E U+014C)
  0x20, 0x1E, 0x01, 0x4E, 0x01, // „Ŏ (U+201E U+014E)
  0x20, 0x1E, 0x01, 0x50, 0x01, // „Ő (U+201E U+0150)
  0x20, 0x1E, 0x01, 0x52, 0x01, // „Œ (U+201E U+0152)
  0x20, 0x1E, 0x01, 0x62, 0x02, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x02, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x02, // „Ŧ (U+201E U+0166)
  0x20, 0x1E, 0x01, 0x74, 0x01, // „Ŵ (U+201E U+0174)
  0x20, 0x1E, 0x01, 0x76, 0x01, // „Ŷ (U+201E U+0176)
  0x20, 0x1E, 0x01, 0x78, 0x01, // „Ÿ (U+201E U+0178)
  0x20, 0x39, 0x00, 0x54, 0x01, // ‹T (U+2039 U+0054)
  0x20, 0x39, 0x00, 0x59, 0x01, // ‹Y (U+2039 U+0059)
  0x20, 0x39, 0x00, 0xDD, 0x01, // ‹Ý (U+2039 U+00DD)
  0x20, 0x39, 0x01, 0x62, 0x01, // ‹Ţ (U+2039 U+0162)
  0x20, 0x39, 0x01, 0x64, 0x01, // ‹Ť (U+2039 U+0164)
  0x20, 0x39, 0x01, 0x66, 0x01, // ‹Ŧ (U+2039 U+0166)
  0x20, 0x39, 0x01, 0x76, 0x01, // ‹Ŷ (U+2039 U+0176)
  0x20, 0x39, 0x01, 0x78, 0x01, // ‹Ÿ (U+2039 U+0178)
  0x20, 0x3A, 0x00, 0x54, 0x01, // ›T (U+203A U+0054)
  0x20, 0x3A, 0x00, 0x56, 0x01, // ›V (U+203A U+0056)
  0x20, 0x3A, 0x00, 0x57, 0x01, // ›W (U+203A U+0057)
  0x20, 0x3A, 0x00, 0x59, 0x02, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x02, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x62, 0x01, // ›Ţ (U+203A U+0162)
  0x20, 0x3A, 0x01, 0x64, 0x01, // ›Ť (U+203A U+0164)
  0x20, 0x3A, 0x01, 0x66, 0x01, // ›Ŧ (U+203A U+0166)
  0x20, 0x3A, 0x01, 0x74, 0x01, // ›Ŵ (U+203A U+0174)
  0x20, 0x3A, 0x01, 0x76, 0x02, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x02, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x04, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x04, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x04, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x04, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x04, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x04, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x04, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x04, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x04, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x04, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x1B, 0x81, 0x70, 0xEA, 0x81, 0x70, 0xDA, 0x81, 0x60, 0xDA, 0x81, 0x50, 0xCA, 0x81, 0x50, 0xCA,
  0x81, 0x40, 0xBA, 0x81, 0x40, 0xAA, 0x81, 0x30, 0xAA, 0x81, 0x20, 0x9A, 0x81, 0x20, 0x9A, 0x81,
  0x10, 0x8A, 0x81, 0x10, 0x7A, 0x20, 0x7A, 0x28, 0x16, 0xFE, 0x28, 0x15, 0xFE, 0x75, 0x83, 0x8E,
  0xD2, 0x1B, 0x09, 0x01, 0xB8, 0x49, 0x07, 0xEC, 0x20,
  // """ (U+0022)
  0x03, 0xA0, 0xE2, 0x0B, 0xA0, 0x60, 0x2A, 0x0D, 0x20, 0xAA, 0x05, 0x01, 0xA0, 0xC2, 0x09, 0xA0,
  0x41, 0xA0, 0xB2, 0x08, 0xA8, 0x33, 0x0E, 0xFA, 0x20, 0x7A, 0x83, 0x20, 0xDF, 0x92, 0x05, 0xA8,
  0x31, 0x0C, 0xF8, 0x20, 0x4A, 0x28, 0x1B, 0xF7, 0x20, 0x3A, 0x10,
  // "#" (U+0023)
  0x58, 0x16, 0xFD, 0x3A, 0x02, 0x78, 0x18, 0xFA, 0x20, 0x2A, 0x71, 0x81, 0xAF, 0x82, 0x81, 0x5F,
  0xD7, 0x18, 0x1D, 0xF6, 0x28, 0x17, 0xFB, 0x71, 0xA0, 0x42, 0x81, 0x9F, 0x97, 0x02, 0xA0, 0x12,
  0x81, 0xCF, 0x64, 0x08, 0xFE, 0x81, 0x30, 0x8F, 0xE8, 0x91, 0x30, 0x24, 0x4A, 0xFB, 0x44, 0x7A,
  0x0F, 0x40, 0x14, 0x81, 0xAF, 0x82, 0x81, 0x5F, 0xD7, 0x18, 0x1D, 0xF6, 0x28, 0x17, 0xFB, 0x71,
  0xA0, 0x42, 0x81, 0xAF, 0x97, 0x01, 0xA0, 0x22, 0x81, 0xCF, 0x74, 0x05, 0xFE, 0x81, 0x60, 0x5F,
  0xE8, 0x91, 0x60, 0x39, 0x9C, 0xFD, 0x99, 0xAA, 0x0F, 0x90, 0x34, 0x81, 0xAF, 0x82, 0x81, 0x5F,
  0xE7, 0x18, 0x1C, 0xF6, 0x28, 0x17, 0xFC, 0x71, 0x81, 0xEF, 0x42, 0x81, 0x9F, 0x97, 0x01, 0xA0,
  0x22, 0x81, 0xCF, 0x77, 0x03, 0xA3, 0x81, 0xEF, 0x57, 0x81, 0x5F, 0xD2, 0x01, 0xA0, 0x35,
  // "$" (U+0024)
  0x58, 0x19, 0xF1, 0x73, 0x81, 0x9F, 0x17, 0x28, 0x43, 0xBF, 0x86, 0x35, 0x06, 0x0E, 0xE0, 0xD0,
  0x42, 0x08, 0xFA, 0x81, 0x50, 0x2A, 0x86, 0xE5, 0xAF, 0x24, 0x8D, 0x20, 0x7A, 0x83, 0x40, 0x9F,
  0x15, 0x09, 0xA2, 0x81, 0x9F, 0x15, 0x08, 0xA8, 0x33, 0x09, 0xF1, 0x50, 0x4A, 0x83, 0xC2, 0x9F,
  0x16, 0x0B, 0xB8, 0x1E, 0xF1, 0x70, 0x9C, 0x0D, 0x06, 0x70, 0x30, 0xAC, 0x0D, 0x03, 0x78, 0x19,
  0xFE, 0xB0, 0x36, 0x82, 0x9F, 0x17, 0xA0, 0xC6, 0x83, 0x9F, 0x10, 0xBA, 0x68, 0x39, 0xF1, 0x08,
  0xA0, 0x01, 0x48, 0x97, 0x9F, 0x10, 0xCF, 0xE0, 0x9C, 0x73, 0x1A, 0xF4, 0xBA, 0x81, 0x90, 0x9F,
  0xA8, 0x3D, 0x10, 0x5E, 0xF0, 0xA0, 0x14, 0x85, 0x36, 0x8D, 0xF6, 0x17, 0x28, 0x19, 0xF1, 0x73,
  0x81, 0x9F, 0x17, 0x38, 0x19, 0xF1, 0x50,
  // "%" (U+0025)
  0x28, 0x38, 0xEE, 0xA1, 0x68, 0x1C, 0xF9, 0x60, 0x9C, 0x0D, 0x50, 0x3A, 0x02, 0x50, 0x2A, 0x0C,
  0x0B, 0xA0, 0x64, 0x81, 0x9F, 0xC6, 0x81, 0x7F, 0xE2, 0x81, 0xBF, 0xC4, 0x81, 0xEF, 0x56, 0x81,
  0xAF, 0xB2, 0x07, 0xA3, 0x81, 0x6F, 0xE7, 0x81, 0xCF, 0x92, 0x05, 0xA0, 0x12, 0x81, 0xCF, 0x87,
  0x81, 0xCF, 0x82, 0x04, 0xA8, 0x12, 0x03, 0xA0, 0x27, 0x81, 0xCF, 0x92, 0x04, 0xA8, 0x31, 0x0A,
  0xFB, 0x71, 0x81, 0xBF, 0xA2, 0x05, 0xA1, 0x01, 0xA8, 0x55, 0x09, 0xEE, 0xA1, 0x28, 0x19, 0xFC,
  0x28, 0x78, 0xFE, 0x07, 0xFE, 0x0A, 0xC0, 0xC2, 0x05, 0xA8, 0x90, 0x41, 0xEF, 0xA0, 0xDF, 0x72,
  0xA0, 0x70, 0x5A, 0x05, 0x20, 0xED, 0x03, 0x04, 0xA8, 0x21, 0x7F, 0xD2, 0x81, 0xBF, 0xB2, 0x04,
  0xC8, 0x78, 0x0A, 0xFA, 0x0A, 0xFA, 0x28, 0x17, 0xFE, 0x38, 0x42, 0x78, 0x40, 0x1A, 0x83, 0x40,
  0xCF, 0x92, 0x06, 0xA7, 0x18, 0x17, 0xFD, 0x28, 0x1D, 0xF8, 0x20, 0x5A, 0x01, 0x78, 0x1D, 0xF7,
  0x28, 0x1D, 0xF8, 0x20, 0x5A, 0x01, 0x60, 0x5A, 0x01, 0x28, 0x1C, 0xF9, 0x20, 0x6A, 0x78, 0x1B,
  0xFA, 0x38, 0x1A, 0xFB, 0x28, 0x18, 0xFE, 0x60, 0x2A, 0x03, 0x38, 0x17, 0xFE, 0x28, 0x1C, 0xFB,
  0x68, 0x18, 0xFD, 0x40, 0x2A, 0x0C, 0x0B, 0xA0, 0x56, 0x81, 0xEF, 0x65, 0x09, 0xC0, 0xC6, 0x82,
  0x5F, 0xE1, 0x68, 0x38, 0xEE, 0xA1, 0x20,
  // "&" (U+0026)
  0x38, 0x43, 0xAE, 0xFD, 0x87, 0x30, 0x3E, 0x0C, 0x72, 0x0C, 0xA8, 0x1C, 0x9E, 0xA0, 0x57, 0x01,
  0xA0, 0xD2, 0x05, 0xA0, 0xA7, 0x03, 0xA0, 0x92, 0x01, 0xA0, 0xB7, 0x02, 0xA0, 0xA2, 0x01, 0xA0,
  0xA7, 0x18, 0x1E, 0xFD, 0x20, 0x5A, 0x07, 0x71, 0x0A, 0xA8, 0x44, 0x1D, 0xFE, 0x17, 0x10, 0x2A,
  0x00, 0xDA, 0x05, 0x73, 0x09, 0xC0, 0x77, 0x30, 0x10, 0xCB, 0x0B, 0x73, 0x02, 0x0E, 0xD0, 0x63,
  0x0C, 0xA0, 0x42, 0x0D, 0xA0, 0x90, 0x5A, 0x0E, 0x02, 0x20, 0xEA, 0x81, 0x10, 0x6A, 0x0C, 0x20,
  0x9A, 0x81, 0xC0, 0x3A, 0x0C, 0x20, 0xBA, 0x05, 0x30, 0xCA, 0x00, 0x9A, 0x07, 0x20, 0xEA, 0x02,
  0x30, 0x20, 0xED, 0x01, 0x20, 0xEA, 0x02, 0x40, 0x5C, 0x09, 0x30, 0xDA, 0x05, 0x50, 0xCB, 0x02,
  0x30, 0x9A, 0x0C, 0x01, 0x30, 0x9C, 0x0A, 0x30, 0x3B, 0x82, 0xEA, 0xAE, 0xE0, 0x63, 0x06, 0xF8,
  0x1D, 0x36, 0xB0, 0x33, 0x85, 0x4A, 0xEF, 0xEB, 0x63, 0x0B, 0xA0, 0xD0, 0x10,
  // "'" (U+0027)
  0x03, 0xA0, 0xE0, 0x2A, 0x0D, 0x01, 0xA0, 0xC1, 0xA8, 0x97, 0xB0, 0xEF, 0xA0, 0xDF, 0x90, 0xCF,
  0x80, 0xBF, 0x70,
  // "(" (U+0028)
  0x48, 0x2A, 0xFE, 0x13, 0x04, 0xA0, 0x54, 0x81, 0xDF, 0xC4, 0x06, 0xA0, 0x54, 0x81, 0xDF, 0xE4,
  0x03, 0xA0, 0x94, 0x09, 0xA0, 0x44, 0x0D, 0xA4, 0x02, 0xA0, 0xC4, 0x04, 0xA0, 0x94, 0x07, 0xA0,
  0x74, 0x08, 0xA0, 0x64, 0x09, 0xA0, 0x54, 0x0A, 0xA0, 0x44, 0x09, 0xA0, 0x44, 0x09, 0xA0, 0x54,
  0x07, 0xA0, 0x64, 0x05, 0xA0, 0x84, 0x02, 0xA0, 0xB5, 0x81, 0xEF, 0xE5, 0x0A, 0xA0, 0x34, 0x05,
  0xA0, 0x95, 0x81, 0xDF, 0xE5, 0x07, 0xA0, 0x54, 0x82, 0x1E, 0xFC, 0x50, 0x5A, 0x06, 0x58, 0x1A,
  0xFE, 0x10,
  // ")" (U+0029)
  0x81, 0xDF, 0xB4, 0x05, 0xA0, 0x54, 0x82, 0xCF, 0xE1, 0x30, 0x5A, 0x07, 0x48, 0x1E, 0xFD, 0x40,
  0x9A, 0x04, 0x30, 0x3A, 0x09, 0x4A, 0x0E, 0x40, 0xCA, 0x02, 0x30, 0x8A, 0x05, 0x30, 0x6A, 0x07,
  0x30, 0x5A, 0x09, 0x30, 0x4A, 0x0A, 0x30, 0x3A, 0x0A, 0x30, 0x4A, 0x0A, 0x30, 0x5A, 0x09, 0x30,
  0x6A, 0x07, 0x30, 0x8A, 0x05, 0x30, 0xBA, 0x03, 0x3A, 0x0E, 0x30, 0x3A, 0x0B, 0x30, 0x8A, 0x05,
  0x38, 0x1E, 0xFE, 0x30, 0x4A, 0x08, 0x38, 0x2C, 0xFE, 0x12, 0x05, 0xA0, 0x73, 0x81, 0xDF, 0xB4,
  // "*" (U+002A)
  0x40, 0x9A, 0x03, 0x71, 0x08, 0xA0, 0x17, 0x10, 0x6A, 0x58, 0x55, 0x61, 0x05, 0xFD, 0x28, 0x23,
  0x81, 0xAA, 0x84, 0xB9, 0xFD, 0x9E, 0xA0, 0x30, 0xDF, 0xB8, 0x36, 0x34, 0x67, 0xB8, 0x3B, 0x65,
  0x31, 0x38, 0x49, 0xFE, 0xFE, 0x25, 0x05, 0xA8, 0x25, 0xCF, 0xC4, 0x84, 0x1E, 0xFD, 0x05, 0xA0,
  0x93, 0x82, 0x5E, 0xF6, 0x28, 0x2D, 0xFC, 0x13, 0x02, 0x09, 0x30, 0x50, 0x73,
  // "+" (U+002B)
  0x5A, 0x06, 0x73, 0xA0, 0x67, 0x3A, 0x06, 0x73, 0xA0, 0x67, 0x3A, 0x06, 0x73, 0xA0, 0x65, 0x08,
  0x80, 0x09, 0xA8, 0x5B, 0x99, 0x99, 0x2E, 0xFC, 0x04, 0x0E, 0xFC, 0x04, 0x5A, 0x06, 0x73, 0xA0,
  0x67, 0x3A, 0x06, 0x73, 0xA0, 0x67, 0x3A, 0x06, 0x73, 0xA0, 0x65,
  // "," (U+002C)
  0x10, 0x9A, 0x81, 0x90, 0xBA, 0x81, 0x50, 0xDA, 0x01, 0x1A, 0x81, 0xD0, 0x3A, 0x81, 0x90, 0x6A,
  0x83, 0x30, 0x9F, 0xD2, 0x81, 0xCF, 0x82,
  // "-" (U+002D)
  0x18, 0x02, 0x90, 0x80, 0x1E, 0x0E, 0x01, 0xE0, 0xE0,
  // "." (U+002E)
  0x18, 0x39, 0xEC, 0x12, 0xB0, 0x70, 0x2B, 0x84, 0x70, 0x8E, 0xC1,
  // "/" (U+002F)
  0x71, 0x81, 0xCF, 0xE7, 0x02, 0xA0, 0x97, 0x07, 0xA0, 0x37, 0x81, 0xDF, 0xD7, 0x03, 0xA0, 0x77,
  0x09, 0xA0, 0x27, 0x81, 0xEF, 0xC7, 0x04, 0xA0, 0x67, 0x0A, 0xA0, 0x16, 0x01, 0xA0, 0xA7, 0x06,
  0xA0, 0x57, 0x81, 0xBF, 0xE7, 0x02, 0xA0, 0x97, 0x07, 0xA0, 0x37, 0x81, 0xDF, 0xD7, 0x03, 0xA0,
  0x87, 0x09, 0xA0, 0x27, 0x81, 0xEF, 0xC7, 0x04, 0xA0, 0x77, 0x0A, 0xA0, 0x16, 0x01, 0xA0, 0xB7,
  0x06, 0xA0, 0x57,
  // "0" (U+0030)
  0x38, 0x44, 0xBE, 0xEC, 0x66, 0x06, 0xE0, 0xA4, 0x02, 0xB8, 0x1B, 0x9E, 0xA0, 0x73, 0x09, 0xA0,
  0x82, 0x03, 0xA0, 0xE3, 0xA0, 0xE4, 0x0A, 0xA8, 0x15, 0x03, 0xA0, 0xB4, 0x05, 0xA8, 0x19, 0x06,
  0xA0, 0x84, 0x02, 0xA8, 0x1C, 0x08, 0xA0, 0x65, 0xA8, 0x1E, 0x0A, 0xA0, 0x55, 0xB1, 0x0B, 0xA0,
  0x55, 0x0E, 0xA0, 0x10, 0xBA, 0x04, 0x50, 0xEA, 0x01, 0x0B, 0xA0, 0x45, 0x0D, 0xA0, 0x10, 0xBA,
  0x05, 0x50, 0xEA, 0x01, 0x0A, 0xA0, 0x55, 0xB1, 0x09, 0xA0, 0x65, 0xA8, 0x1E, 0x07, 0xA0, 0x84,
  0x02, 0xA8, 0x1C, 0x04, 0xA0, 0xB4, 0x05, 0xA8, 0x19, 0x01, 0xA0, 0xE4, 0x09, 0xA0, 0x52, 0x0A,
  0xA0, 0x82, 0x02, 0xA0, 0xE0, 0x12, 0x03, 0xB8, 0x1B, 0x9E, 0xA0, 0x84, 0x07, 0xE0, 0xB6, 0x84,
  0x4B, 0xEF, 0xD7, 0x40,
  // "1" (U+0031)
  0x48, 0x23, 0xEF, 0xE3, 0x03, 0x0E, 0xA0, 0xE2, 0x03, 0x0E, 0xB8, 0x2E, 0x03, 0xEC, 0x81, 0xE3,
  0xEA, 0x07, 0xA0, 0xE0, 0xCA, 0x07, 0x01, 0xA8, 0x4E, 0x2E, 0x60, 0x1A, 0x0E, 0x40, 0x1A, 0x0E,
  0x40, 0x1A, 0x0E, 0x40, 0x1A, 0x0E, 0x40, 0x1A, 0x0E, 0x40, 0x1A, 0x0E, 0x40, 0x1A, 0x0E, 0x40,
  0x1A, 0x0E, 0x40, 0x1A, 0x0E, 0x40, 0x1A, 0x0E, 0x40, 0x1A, 0x0E, 0x40, 0x1A, 0x0E, 0x40, 0x1A,
  0x0E, 0x40, 0x1A, 0x0E, 0x40, 0x1A, 0x0E, 0x40, 0x1A, 0x0E,
  // "2" (U+0032)
  0x28, 0x54, 0xAD, 0xFE, 0xC6, 0x40, 0xAF, 0x0B, 0x20, 0x8B, 0x81, 0xB9, 0xBB, 0x84, 0x90, 0x1D,
  0xB1, 0x30, 0x6B, 0x81, 0x10, 0x26, 0x0C, 0xA0, 0x57, 0x10, 0x9A, 0x06, 0x71, 0x09, 0xA0, 0x67,
  0x10, 0xCA, 0x04, 0x70, 0x1B, 0x01, 0x70, 0x7A, 0x0B, 0x70, 0x10, 0xEA, 0x04, 0x70, 0xAA, 0x0A,
  0x70, 0x5A, 0x0E, 0x01, 0x60, 0x20, 0xEA, 0x05, 0x70, 0xCA, 0x08, 0x70, 0x9A, 0x0B, 0x70, 0x5A,
  0x0D, 0x01, 0x60, 0x20, 0xEA, 0x03, 0x70, 0xCA, 0x06, 0x70, 0x9A, 0x0E, 0x80, 0x39, 0x08, 0x0E,
  0xFC, 0x0E, 0xFC,
  // "3" (U+0033)
  0x28, 0x65, 0xAD, 0xFE, 0xC8, 0x12, 0x03, 0x0D, 0xF8, 0x2E, 0x20, 0x8A, 0x82, 0xEA, 0x9B, 0xB0,
  0xC2, 0x0C, 0x07, 0x40, 0x3B, 0x03, 0x71, 0x0A, 0xA0, 0x67, 0x10, 0x8A, 0x06, 0x71, 0x0A, 0xA0,
  0x47, 0x03, 0xA0, 0xD6, 0x84, 0x26, 0xEF, 0xE3, 0x30, 0x3D, 0x0A, 0x02, 0x40, 0x3C, 0x81, 0xE8,
  0x24, 0x83, 0x29, 0x9A, 0xEA, 0x0E, 0x05, 0x71, 0x07, 0xB0, 0x37, 0x10, 0xAA, 0x09, 0x71, 0x04,
  0xA0, 0xD7, 0x10, 0x3A, 0x0E, 0x71, 0x05, 0xA0, 0xD7, 0x10, 0xAA, 0x81, 0xA9, 0x45, 0x06, 0xB8,
  0x65, 0xDF, 0xEA, 0x99, 0xCB, 0x81, 0xB0, 0xDF, 0x98, 0x5B, 0x10, 0x28, 0xBE, 0xA8, 0x1D, 0xA5,
  0x30,
  // "4" (U+0034)
  0x71, 0x0C, 0xA0, 0x87, 0x20, 0x5B, 0x08, 0x72, 0x0D, 0xB0, 0x87, 0x10, 0x7C, 0x08, 0x78, 0x21,
  0xEF, 0x9A, 0x08, 0x78, 0x28, 0xFD, 0x6A, 0x08, 0x60, 0x1A, 0x05, 0x06, 0xA0, 0x86, 0x83, 0xAF,
  0xC0, 0x7A, 0x08, 0x50, 0x3A, 0x81, 0x40, 0x7A, 0x08, 0x58, 0x1B, 0xFB, 0x20, 0x7A, 0x08, 0x40,
  0x4A, 0x03, 0x20, 0x7A, 0x08, 0x48, 0x1C, 0xFB, 0x30, 0x7A, 0x08, 0x30, 0x5A, 0x03, 0x30, 0x7A,
  0x08, 0x38, 0x1D, 0xFA, 0x40, 0x7A, 0x08, 0x20, 0x5A, 0x84, 0xB9, 0x99, 0x9C, 0xA8, 0x2C, 0x99,
  0x7F, 0xD0, 0xE0, 0x7F, 0xD0, 0xE7, 0x10, 0x7A, 0x08, 0x73, 0x07, 0xA0, 0x87, 0x30, 0x7A, 0x08,
  0x73, 0x07, 0xA0, 0x87, 0x30, 0x7A, 0x08, 0x20,
  // "5" (U+0035)
  0x10, 0x8F, 0x90, 0xB2, 0x09, 0xF9, 0x0B, 0x20, 0xAA, 0x80, 0x29, 0x06, 0x20, 0xBA, 0x72, 0x81,
  0xCF, 0xE7, 0x28, 0x1D, 0xFD, 0x72, 0x81, 0xEF, 0xC7, 0x2A, 0x0B, 0x71, 0x01, 0xA8, 0x5E, 0xCE,
  0xFD, 0x81, 0x20, 0x2F, 0x90, 0xE0, 0x22, 0x84, 0x9E, 0xB9, 0x9C, 0xB0, 0xD7, 0x10, 0x40, 0xEA,
  0x06, 0x71, 0x07, 0xA0, 0xB7, 0x10, 0x2A, 0x0E, 0x71, 0x01, 0xB7, 0x10, 0x1A, 0x0E, 0x71, 0x04,
  0xA0, 0xC7, 0x10, 0xBA, 0x81, 0x85, 0x75, 0x07, 0xB8, 0x62, 0x6F, 0xEB, 0x99, 0xDB, 0x81, 0x80,
  0x6F, 0x90, 0x93, 0x81, 0x6B, 0xDA, 0x81, 0xDA, 0x43,
  // "6" (U+0036)
  0x58, 0x46, 0xBD, 0xFE, 0xC5, 0x03, 0x0D, 0xE4, 0x02, 0xB8, 0x3E, 0xA9, 0xAC, 0x40, 0xCA, 0x08,
  0x71, 0x05, 0xA0, 0xA7, 0x20, 0xBA, 0x01, 0x72, 0xA0, 0xB7, 0x20, 0x3A, 0x84, 0x70, 0x37, 0x85,
  0x40, 0x6A, 0x05, 0x09, 0xC0, 0xD0, 0x22, 0x08, 0xA0, 0xAE, 0x0D, 0x20, 0x9B, 0x83, 0xC3, 0x04,
  0xEA, 0x81, 0x70, 0xAA, 0x0E, 0x01, 0x30, 0x5A, 0x81, 0xC0, 0xAA, 0x08, 0x5B, 0x10, 0xAA, 0x06,
  0x50, 0xDA, 0x02, 0x09, 0xA0, 0x65, 0x0C, 0xA0, 0x20, 0x7A, 0x08, 0x50, 0xDA, 0x01, 0x04, 0xA0,
  0xB5, 0x0E, 0xA2, 0x0E, 0xA0, 0x13, 0x03, 0xA0, 0xC2, 0x09, 0xA0, 0xA3, 0x0B, 0xA0, 0x72, 0x01,
  0x0E, 0xA8, 0x1C, 0x9D, 0xA0, 0xD4, 0x04, 0x0E, 0xD0, 0xE0, 0x35, 0x85, 0x29, 0xDF, 0xD9, 0x13,
  // "7" (U+0037)
  0xFD, 0x04, 0xFD, 0x04, 0x08, 0x80, 0x49, 0xB0, 0x17, 0x10, 0x3A, 0x0B, 0x72, 0x08, 0xA0, 0x67,
  0x20, 0xEA, 0x01, 0x71, 0x04, 0xA0, 0xB7, 0x20, 0xAA, 0x05, 0x72, 0x81, 0xEF, 0xE7, 0x20, 0x5A,
  0x0A, 0x72, 0x0B, 0xA0, 0x47, 0x10, 0x1A, 0x0E, 0x72, 0x07, 0xA0, 0x97, 0x20, 0xDA, 0x03, 0x71,
  0x03, 0xA0, 0xD7, 0x20, 0x8A, 0x08, 0x72, 0x0E, 0xA0, 0x37, 0x10, 0x4A, 0x0D, 0x72, 0x0A, 0xA0,
  0x77, 0x2B, 0x02, 0x71, 0x06, 0xA0, 0xC7, 0x20, 0xBA, 0x06, 0x70,
  // "8" (U+0038)
  0x38, 0x56, 0xCE, 0xFD, 0x92, 0x40, 0x10, 0xCF, 0x05, 0x30, 0xAB, 0x81, 0xA9, 0xDB, 0x81, 0x20,
  0x1B, 0x04, 0x30, 0xBA, 0x81, 0x80, 0x4A, 0x0B, 0x40, 0x4A, 0x81, 0xA0, 0x4A, 0x09, 0x40, 0x3A,
  0x81, 0xA0, 0x1A, 0x0C, 0x40, 0x5A, 0x08, 0x20, 0xCA, 0x05, 0x30, 0xDA, 0x02, 0x20, 0x3B, 0x81,
  0x62, 0xCA, 0x08, 0x40, 0x5E, 0x09, 0x60, 0x7C, 0x09, 0x60, 0x7E, 0x09, 0x40, 0x7A, 0x82, 0xD3,
  0x3D, 0xA0, 0xB2, 0x02, 0xA0, 0xD0, 0x12, 0x01, 0x0C, 0xA8, 0x18, 0x09, 0xA0, 0x54, 0x01, 0xB1,
  0x0C, 0xA0, 0x15, 0x0B, 0xA0, 0x30, 0xDA, 0x01, 0x50, 0xAA, 0x04, 0x0C, 0xA0, 0x45, 0x0D, 0xA0,
  0x20, 0x8A, 0x0C, 0x01, 0x30, 0x8A, 0x82, 0xD0, 0x1E, 0xA8, 0x2E, 0xA9, 0xCB, 0x05, 0x20, 0x40,
  0xEF, 0x08, 0x48, 0x61, 0x8C, 0xEF, 0xDA, 0x33,
  // "9" (U+0039)
  0x38, 0x46, 0xCE, 0xEB, 0x54, 0x01, 0x0C, 0xE0, 0x93, 0x0A, 0xA8, 0x1E, 0xAA, 0xB8, 0x16, 0x03,
  0xA0, 0xE0, 0x22, 0x03, 0xA8, 0x1E, 0x08, 0xA0, 0x84, 0x09, 0xA0, 0x50, 0xBA, 0x04, 0x40, 0x4A,
  0x09, 0x0C, 0xA0, 0x24, 0x01, 0xA0, 0x0C, 0xA0, 0x35, 0xA0, 0xE0, 0xBA, 0x05, 0x40, 0x2B, 0x08,
  0xA0, 0xA4, 0x08, 0xB0, 0x3B, 0x82, 0x60, 0x17, 0xC1, 0x0B, 0xE8, 0x5B, 0xEF, 0xE0, 0x1B, 0xC0,
  0xC0, 0x1A, 0x0C, 0x38, 0x44, 0x78, 0x50, 0x1A, 0x0A, 0x71, 0x04, 0xA0, 0x87, 0x10, 0x8A, 0x04,
  0x71, 0x0E, 0xA7, 0x10, 0x8A, 0x09, 0x70, 0x6B, 0x02, 0x28, 0x39, 0xA9, 0xAD, 0xB0, 0x63, 0x0A,
  0xE0, 0x64, 0x85, 0x8E, 0xFE, 0xC8, 0x24,
  // ":" (U+003A)
  0x18, 0x38, 0xEC, 0x11, 0xB0, 0x80, 0x1B, 0x84, 0x80, 0x8E, 0xC1, 0x80, 0xD2, 0x08, 0x38, 0xEC,
  0x21, 0xB0, 0x80, 0x1B, 0x84, 0x80, 0x8E, 0xC1,
  // ";" (U+003B)
  0x18, 0x38, 0xEC, 0x12, 0xB0, 0x80, 0x1B, 0x84, 0x80, 0x8E, 0xC1, 0x80, 0xD2, 0x00, 0xAA, 0x81,
  0x80, 0xCA, 0x81, 0x40, 0xEA, 0x00, 0x1A, 0x81, 0xC0, 0x4A, 0x81, 0x80, 0x7A, 0x83, 0x20, 0xAF,
  0xC2, 0x81, 0xDF, 0x72,
  // "<" (U+003C)
  0x74, 0x05, 0x03, 0x72, 0x82, 0x4C, 0xF5, 0x70, 0x40, 0xCB, 0x05, 0x50, 0x40, 0xBB, 0x0C, 0x05,
  0x40, 0x30, 0xBB, 0x0C, 0x04, 0x40, 0x30, 0xBB, 0x0C, 0x04, 0x50, 0xAB, 0x0B, 0x04, 0x70, 0xEA,
  0x0C, 0x01, 0x71, 0x06, 0x0D, 0xB0, 0x90, 0x27, 0x10, 0x60, 0xDB, 0x0A, 0x03, 0x71, 0x06, 0x0D,
  0xB0, 0xB0, 0x47, 0x10, 0x60, 0xDB, 0x0C, 0x02, 0x71, 0x06, 0x0D, 0xA0, 0x57, 0x38, 0x16, 0xD5,
  0x75, 0x01,
  // "=" (U+003D)
  0x0D, 0xFC, 0x04, 0x0D, 0xFC, 0x04, 0x07, 0x80, 0x79, 0x02, 0x80, 0xC3, 0x00, 0x78, 0x07, 0x90,
  0x20, 0xDF, 0xC0, 0x40, 0xDF, 0xC0, 0x40,
  // ">" (U+003E)
  0x07, 0x01, 0x74, 0x82, 0xEE, 0x81, 0x72, 0x0E, 0xA0, 0xE0, 0x77, 0x10, 0x20, 0x9B, 0x0E, 0x07,
  0x71, 0x01, 0x09, 0xB0, 0xE0, 0x77, 0x10, 0x10, 0x9B, 0x0E, 0x06, 0x71, 0x81, 0x18, 0xEA, 0x0D,
  0x03, 0x71, 0x07, 0xB0, 0x56, 0x06, 0x0D, 0xB0, 0x90, 0x13, 0x81, 0x17, 0xEB, 0x09, 0x02, 0x38,
  0x11, 0x8E, 0xB0, 0x90, 0x24, 0x08, 0xC0, 0x90, 0x26, 0x0E, 0xA0, 0x90, 0x27, 0x18, 0x1D, 0x91,
  0x73, 0x01, 0x75,
  // "?" (U+003F)
  0x18, 0x62, 0x8C, 0xEF, 0xD9, 0x12, 0x06, 0xF8, 0x2E, 0x20, 0x3A, 0x82, 0xC9, 0xAE, 0xA0, 0xC2,
  0x08, 0x02, 0x30, 0x10, 0xEA, 0x02, 0x70, 0x9A, 0x05, 0x70, 0x8A, 0x05, 0x70, 0xBA, 0x03, 0x60,
  0x2A, 0x0E, 0x70, 0xBA, 0x08, 0x60, 0x9A, 0x0C, 0x60, 0x6A, 0x0E, 0x01, 0x58, 0x31, 0xEF, 0xE3,
  0x60, 0x6A, 0x06, 0x78, 0x19, 0xFE, 0x71, 0x81, 0xAF, 0xC7, 0x18, 0x15, 0x75, 0x77, 0x77, 0x28,
  0x2A, 0xEC, 0x16, 0x03, 0xB0, 0x66, 0x03, 0xB0, 0x67, 0x82, 0x9E, 0xC1, 0x40,
  // "@" (U+0040)
  0x68, 0x71, 0x6B, 0xEF, 0xEC, 0x82, 0x73, 0x06, 0x0E, 0xF9, 0x08, 0x71, 0x09, 0xB8, 0x3E, 0xB9,
  0x9C, 0xB0, 0xB6, 0x08, 0xA0, 0xD0, 0x55, 0x02, 0x0C, 0xA0, 0x94, 0x04, 0xA0, 0xC0, 0x17, 0x10,
  0xAA, 0x03, 0x38, 0x2D, 0xFD, 0x12, 0x89, 0x16, 0xCE, 0xEB, 0x71, 0x0D, 0xFB, 0x20, 0x5A, 0x05,
  0x20, 0x9E, 0x81, 0x60, 0x5A, 0x83, 0x10, 0xAF, 0xC2, 0x05, 0xA8, 0x1D, 0x9B, 0xA0, 0x52, 0xA8,
  0x36, 0x0E, 0xF7, 0x28, 0x4C, 0xFD, 0x10, 0x1A, 0x05, 0x28, 0x2B, 0xF9, 0x3A, 0x81, 0x20, 0x2A,
  0x06, 0x20, 0x2A, 0x04, 0x28, 0x29, 0xFB, 0x5A, 0x20, 0x5A, 0x01, 0x20, 0x3A, 0x03, 0x28, 0x48,
  0xFC, 0x7F, 0xD2, 0x06, 0xA3, 0x04, 0xA0, 0x32, 0x84, 0x8F, 0xB7, 0xFC, 0x28, 0x17, 0xFE, 0x30,
  0x5A, 0x02, 0x28, 0x49, 0xFA, 0x7F, 0xC2, 0x06, 0xA3, 0x07, 0xA0, 0x22, 0x84, 0xBF, 0x87, 0xFD,
  0x20, 0x5A, 0x02, 0x20, 0xBA, 0x02, 0x28, 0x2E, 0xF5, 0x6A, 0x20, 0x1A, 0x87, 0xB1, 0x4F, 0xDF,
  0x80, 0x8A, 0x01, 0x03, 0xA0, 0x32, 0x0B, 0xD0, 0x3D, 0x09, 0x2A, 0x08, 0x20, 0x20, 0xDB, 0x81,
  0x70, 0x9B, 0x0C, 0x38, 0x2B, 0xFE, 0x12, 0x82, 0x16, 0x84, 0x38, 0x15, 0x85, 0x40, 0x5A, 0x09,
  0x77, 0x30, 0xCA, 0x08, 0x77, 0x20, 0x20, 0xEA, 0x81, 0xC5, 0x12, 0x83, 0x14, 0x8C, 0x17, 0x03,
  0x0E, 0xFB, 0x01, 0x71, 0x01, 0x09, 0xF0, 0xE0, 0x77, 0x58, 0x44, 0x78, 0x87, 0x47,
  // "A" (U+0041)
  0x50, 0x1B, 0x0C, 0x74, 0x05, 0xC0, 0x17, 0x30, 0x9C, 0x05, 0x73, 0x81, 0xDF, 0xCA, 0x09, 0x72,
  0x02, 0xA8, 0x28, 0xCF, 0xE7, 0x20, 0x7A, 0x05, 0x09, 0xA0, 0x37, 0x10, 0xBA, 0x02, 0x06, 0xA0,
  0x77, 0x1A, 0x81, 0xD0, 0x2A, 0x0B, 0x70, 0x4A, 0x0A, 0x20, 0xDA, 0x70, 0x8A, 0x06, 0x20, 0xAA,
  0x04, 0x60, 0xCA, 0x02, 0x20, 0x6A, 0x09, 0x50, 0x1A, 0x0E, 0x30, 0x2A, 0x0D, 0x50, 0x5A, 0x0A,
  0x40, 0xDA, 0x02, 0x40, 0xAF, 0xB0, 0x64, 0x0E, 0xFB, 0x0B, 0x30, 0x3B, 0x80, 0x2D, 0xA0, 0xE3,
  0x07, 0xA0, 0xB6, 0x0E, 0xA0, 0x42, 0x0B, 0xA0, 0x76, 0x0A, 0xA0, 0x82, 0xB0, 0x36, 0x06, 0xA8,
  0x1C, 0x04, 0xA0, 0xE7, 0x02, 0xB0, 0x10, 0x9A, 0x0A, 0x71, 0x0D, 0xA0, 0x60, 0xDA, 0x05, 0x71,
  0x08, 0xA0, 0xA0,
  // "B" (U+0042)
  0x0A, 0xD8, 0x2E, 0xDA, 0x53, 0x0A, 0xFA, 0x82, 0xC1, 0x0A, 0xA8, 0x3B, 0x99, 0xAD, 0xB8, 0x1B,
  0x0A, 0xA0, 0x64, 0x08, 0xB0, 0x20, 0xAA, 0x06, 0x50, 0xDA, 0x05, 0x0A, 0xA0, 0x65, 0x0B, 0xA0,
  0x60, 0xAA, 0x06, 0x50, 0xCA, 0x04, 0x0A, 0xA0, 0x64, 0x02, 0xA8, 0x1E, 0x1A, 0xA0, 0x63, 0x03,
  0x0C, 0xA8, 0x17, 0x0A, 0xF9, 0x0E, 0x07, 0x20, 0xAF, 0x90, 0xA0, 0x32, 0x0A, 0xA8, 0x3B, 0x99,
  0xAC, 0xB8, 0x16, 0x0A, 0xA0, 0x64, 0x05, 0xB0, 0x30, 0xAA, 0x06, 0x50, 0xAA, 0x09, 0x0A, 0xA0,
  0x65, 0x06, 0xA0, 0xC0, 0xAA, 0x06, 0x50, 0x4A, 0x0D, 0x0A, 0xA0, 0x65, 0x06, 0xA0, 0xC0, 0xAA,
  0x06, 0x50, 0xAA, 0x00, 0xAA, 0x06, 0x40, 0x4B, 0x05, 0x0A, 0xA8, 0x3B, 0x99, 0x9B, 0xB8, 0x1C,
  0x0A, 0xFA, 0x82, 0xD1, 0x0A, 0xE8, 0x1E, 0xC7, 0x30,
  // "C" (U+0043)
  0x58, 0x64, 0xAD, 0xFE, 0xD9, 0x44, 0x01, 0x0B, 0xF9, 0x05, 0x30, 0xCB, 0x84, 0xC9, 0x9D, 0xFE,
  0x30, 0x8A, 0x0E, 0x04, 0x40, 0x50, 0x72, 0x02, 0xB0, 0x57, 0x20, 0x8A, 0x0C, 0x73, 0x0C, 0xA0,
  0x57, 0x20, 0x1B, 0x01, 0x72, 0x03, 0xA0, 0xE7, 0x30, 0x5A, 0x0C, 0x73, 0x06, 0xA0, 0xB7, 0x30,
  0x6A, 0x0B, 0x73, 0x05, 0xA0, 0xC7, 0x30, 0x4A, 0x0E, 0x73, 0x01, 0xB0, 0x17, 0x30, 0xEA, 0x05,
  0x73, 0x09, 0xA0, 0xB7, 0x30, 0x3B, 0x04, 0x73, 0x0A, 0xA0, 0xE0, 0x45, 0x04, 0x30, 0x10, 0xDB,
  0x84, 0xC9, 0xAB, 0xED, 0x40, 0x20, 0xCF, 0x0D, 0x68, 0x66, 0xBD, 0xFE, 0xD9, 0x41,
  // "D" (U+0044)
  0x0A, 0xD8, 0x2E, 0xC8, 0x25, 0x0A, 0xFA, 0x08, 0x40, 0xAA, 0x83, 0xB9, 0x9A, 0xEB, 0x0A, 0x30,
  0xAA, 0x06, 0x40, 0x8B, 0x06, 0x20, 0xAA, 0x06, 0x50, 0x8A, 0x0E, 0x20, 0xAA, 0x06, 0x60, 0xEA,
  0x81, 0x50, 0xAA, 0x06, 0x60, 0x9A, 0x81, 0xA0, 0xAA, 0x06, 0x60, 0x5A, 0x81, 0xD0, 0xAA, 0x06,
  0x60, 0x2B, 0x10, 0xAA, 0x06, 0x60, 0x1B, 0x01, 0x0A, 0xA0, 0x66, 0x01, 0xB0, 0x20, 0xAA, 0x06,
  0x60, 0x1B, 0x01, 0x0A, 0xA0, 0x66, 0x01, 0xB0, 0x10, 0xAA, 0x06, 0x60, 0x3B, 0x10, 0xAA, 0x06,
  0x60, 0x6A, 0x81, 0xC0, 0xAA, 0x06, 0x60, 0xAA, 0x81, 0x90, 0xAA, 0x06, 0x50, 0x10, 0xEA, 0x81,
  0x40, 0xAA, 0x06, 0x50, 0xAA, 0x0D, 0x20, 0xAA, 0x06, 0x30, 0x10, 0x9B, 0x04, 0x20, 0xAA, 0x82,
  0xB9, 0x9B, 0xC0, 0x73, 0x0A, 0xF9, 0x0E, 0x06, 0x40, 0xAD, 0x82, 0xDB, 0x71, 0x50,
  // "E" (U+0045)
  0x0A, 0xFA, 0x02, 0x0A, 0xFA, 0x02, 0x0A, 0xA0, 0xB8, 0x02, 0x90, 0x10, 0xAA, 0x06, 0x70, 0xAA,
  0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAF, 0x98,
  0x1B, 0x0A, 0xF9, 0x81, 0xB0, 0xAA, 0x0B, 0x80, 0x19, 0x81, 0x60, 0xAA, 0x06, 0x70, 0xAA, 0x06,
  0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70,
  0xAA, 0x0B, 0x80, 0x29, 0x01, 0x0A, 0xFA, 0x02, 0x0A, 0xFA, 0x02,
  // "F" (U+0046)
  0x0A, 0xFA, 0x01, 0x0A, 0xFA, 0x01, 0x0A, 0xA0, 0xB8, 0x02, 0x90, 0x10, 0xAA, 0x06, 0x70, 0xAA,
  0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06,
  0x70, 0xAF, 0x98, 0x1A, 0x0A, 0xF9, 0x81, 0xA0, 0xAA, 0x0B, 0x80, 0x19, 0x81, 0x60, 0xAA, 0x06,
  0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70,
  0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70,
  // "G" (U+0047)
  0x58, 0x71, 0x7B, 0xEF, 0xED, 0x95, 0x60, 0x7F, 0xA0, 0xD4, 0x09, 0xB8, 0x3E, 0xB9, 0x9C, 0xA0,
  0x93, 0x07, 0xB0, 0x95, 0x81, 0x28, 0x32, 0x01, 0x0E, 0xA0, 0x87, 0x40, 0x7A, 0x0D, 0x75, 0x0D,
  0xA0, 0x67, 0x40, 0x1B, 0x01, 0x74, 0x04, 0xA0, 0xE7, 0x50, 0x5A, 0x0C, 0x75, 0x06, 0xA0, 0xB5,
  0xE0, 0x50, 0x6A, 0x0B, 0x5E, 0x00, 0x5A, 0x0C, 0x50, 0xF9, 0x0D, 0xA0, 0x50, 0x3A, 0x0E, 0x71,
  0x0A, 0xA0, 0x50, 0x1B, 0x01, 0x70, 0xAA, 0x81, 0x50, 0xDA, 0x05, 0x70, 0xAA, 0x81, 0x50, 0x8A,
  0x0C, 0x70, 0xAA, 0x81, 0x50, 0x2B, 0x06, 0x60, 0xAA, 0x05, 0x20, 0x9B, 0x05, 0x50, 0xAA, 0x05,
  0x30, 0xCB, 0x83, 0xDA, 0x9A, 0xCB, 0x05, 0x30, 0x10, 0xBF, 0xB0, 0x55, 0x81, 0x4A, 0xDA, 0x83,
  0xED, 0xA6, 0x21,
  // "H" (U+0048)
  0x0A, 0xA0, 0x66, 0x02, 0xA0, 0xE0, 0xAA, 0x06, 0x60, 0x2A, 0x0E, 0x0A, 0xA0, 0x66, 0x02, 0xA0,
  0xE0, 0xAA, 0x06, 0x60, 0x2A, 0x0E, 0x0A, 0xA0, 0x66, 0x02, 0xA0, 0xE0, 0xAA, 0x06, 0x60, 0x2A,
  0x0E, 0x0A, 0xA0, 0x66, 0x02, 0xA0, 0xE0, 0xAA, 0x06, 0x60, 0x2A, 0x0E, 0x0A, 0xA0, 0x66, 0x02,
  0xA0, 0xE0, 0xAF, 0xD0, 0xE0, 0xAF, 0xD0, 0xE0, 0xAA, 0x0B, 0x80, 0x29, 0x0A, 0xA0, 0xE0, 0xAA,
  0x06, 0x60, 0x2A, 0x0E, 0x0A, 0xA0, 0x66, 0x02, 0xA0, 0xE0, 0xAA, 0x06, 0x60, 0x2A, 0x0E, 0x0A,
  0xA0, 0x66, 0x02, 0xA0, 0xE0, 0xAA, 0x06, 0x60, 0x2A, 0x0E, 0x0A, 0xA0, 0x66, 0x02, 0xA0, 0xE0,
  0xAA, 0x06, 0x60, 0x2A, 0x0E, 0x0A, 0xA0, 0x66, 0x02, 0xA0, 0xE0, 0xAA, 0x06, 0x60, 0x2A, 0x0E,
  0x0A, 0xA0, 0x66, 0x02, 0xA0, 0xE0,
  // "I" (U+0049)
  0xF0, 0x5F, 0x82, 0x52, 0x8E, 0xA0, 0xA0, 0x43, 0x0D, 0xA0, 0x34, 0x0D, 0xA0, 0x34, 0x0D, 0xA0,
  0x34, 0x0D, 0xA0, 0x34, 0x0D, 0xA0, 0x34, 0x0D, 0xA0, 0x34, 0x0D, 0xA0, 0x34, 0x0D, 0xA0, 0x34,
  0x0D, 0xA0, 0x34, 0x0D, 0xA0, 0x34, 0x0D, 0xA0, 0x34, 0x0D, 0xA0, 0x34, 0x0D, 0xA0, 0x34, 0x0D,
  0xA0, 0x34, 0x0D, 0xA0, 0x34, 0x0D, 0xA0, 0x33, 0x03, 0x0E, 0xA0, 0x62, 0x0D, 0xE0, 0x4F, 0x05,
  // "J" (U+004A)
  0x40, 0xBA, 0x04, 0x40, 0xBA, 0x04, 0x40, 0xBA, 0x04, 0x40, 0xBA, 0x04, 0x40, 0xBA, 0x04, 0x40,
  0xBA, 0x04, 0x40, 0xBA, 0x04, 0x40, 0xBA, 0x04, 0x40, 0xBA, 0x04, 0x40, 0xBA, 0x04, 0x40, 0xBA,
  0x04, 0x40, 0xBA, 0x04, 0x40, 0xBA, 0x04, 0x40, 0xBA, 0x04, 0x40, 0xBA, 0x04, 0x40, 0xBA, 0x04,
  0x40, 0xBA, 0x04, 0x40, 0xBA, 0x04, 0x40, 0xBA, 0x04, 0x40, 0xBA, 0x04, 0x40, 0xBA, 0x04, 0x40,
  0xBA, 0x04, 0x40, 0xCA, 0x04, 0x40, 0xEA, 0x02, 0x30, 0x5A, 0x83, 0xE0, 0x99, 0xAB, 0x81, 0x90,
  0xBC, 0x87, 0xD1, 0x09, 0xEF, 0xD9, 0x12,
  // "K" (U+004B)
  0x0A, 0xA0, 0x65, 0x04, 0xA8, 0x1E, 0x1A, 0xA0, 0x65, 0x0D, 0xA8, 0x16, 0x0A, 0xA0, 0x64, 0x08,
  0xA0, 0xC2, 0x0A, 0xA0, 0x63, 0x02, 0xB0, 0x22, 0x0A, 0xA0, 0x63, 0x0B, 0xA0, 0x83, 0x0A, 0xA0,
  0x62, 0x05, 0xA0, 0xD4, 0x0A, 0xA8, 0x26, 0x01, 0xEA, 0x04, 0x40, 0xAA, 0x81, 0x60, 0x9A, 0x0A,
  0x50, 0xAA, 0x06, 0x03, 0xA0, 0xE0, 0x15, 0x0A, 0xA0, 0x60, 0xCA, 0x06, 0x60, 0xAA, 0x0C, 0xB0,
  0x86, 0x0A, 0xE0, 0xE0, 0x15, 0x0A, 0xB0, 0xB0, 0xCA, 0x09, 0x50, 0xAA, 0x81, 0xB0, 0x4B, 0x02,
  0x40, 0xAA, 0x06, 0x20, 0xBA, 0x09, 0x40, 0xAA, 0x06, 0x20, 0x3B, 0x02, 0x30, 0xAA, 0x06, 0x30,
  0xBA, 0x0A, 0x30, 0xAA, 0x06, 0x30, 0x3B, 0x03, 0x20, 0xAA, 0x06, 0x40, 0xAA, 0x0B, 0x20, 0xAA,
  0x06, 0x40, 0x2B, 0x81, 0x30, 0xAA, 0x06, 0x50, 0xAA, 0x81, 0xB0, 0xAA, 0x06, 0x50, 0x2B, 0x04,
  // "L" (U+004C)
  0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A,
  0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0,
  0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67,
  0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0xD8, 0x02, 0xC0, 0x20, 0xAF,
  0xA0, 0x30, 0xAF, 0xA0, 0x30,
  // "M" (U+004D)
  0x0A, 0xB0, 0xC7, 0x20, 0x1C, 0x05, 0x0A, 0xC0, 0x17, 0x10, 0x6C, 0x05, 0x0A, 0xC0, 0x67, 0x10,
  0xAC, 0x05, 0x0A, 0xC0, 0xA7, 0x10, 0xEC, 0x05, 0x0A, 0xA8, 0x1C, 0xFE, 0x70, 0x4A, 0x0C, 0xA0,
  0x50, 0xAA, 0x08, 0xA0, 0x46, 0x09, 0xA0, 0x8A, 0x05, 0x0A, 0xA0, 0x4A, 0x09, 0x68, 0x2D, 0xFB,
  0x8A, 0x05, 0x0A, 0xA8, 0x22, 0xEF, 0xD5, 0x02, 0xA0, 0x60, 0x8A, 0x05, 0x0A, 0xA0, 0x20, 0x9A,
  0x02, 0x40, 0x7A, 0x02, 0x09, 0xA0, 0x50, 0xAA, 0x02, 0x04, 0xA0, 0x74, 0x83, 0xCF, 0xD0, 0x9A,
  0x05, 0x0A, 0xA0, 0x21, 0xA0, 0xB3, 0x01, 0xA8, 0x18, 0x09, 0xA0, 0x50, 0xAA, 0x81, 0x20, 0xBA,
  0x01, 0x20, 0x5A, 0x81, 0x30, 0x9A, 0x05, 0x0A, 0xA8, 0x12, 0x06, 0xA0, 0x52, 0x81, 0xAF, 0xE2,
  0x09, 0xA0, 0x50, 0xAA, 0x81, 0x20, 0x1A, 0x0A, 0x28, 0x1E, 0xF9, 0x20, 0x9A, 0x05, 0x0A, 0xA0,
  0x22, 0x83, 0xCF, 0xE0, 0x4A, 0x05, 0x20, 0x9A, 0x05, 0x0A, 0xA0, 0x22, 0x07, 0xA0, 0x30, 0x8A,
  0x30, 0x9A, 0x05, 0x0A, 0xA0, 0x22, 0x03, 0xA8, 0x28, 0xDF, 0xB3, 0x09, 0xA0, 0x50, 0xAA, 0x02,
  0x38, 0x1E, 0xFE, 0xA0, 0x63, 0x09, 0xA0, 0x50, 0xAA, 0x02, 0x30, 0x9C, 0x01, 0x30, 0x9A, 0x05,
  0x0A, 0xA0, 0x23, 0x04, 0xB0, 0xC4, 0x09, 0xA0, 0x50, 0xAA, 0x02, 0x4B, 0x07, 0x40, 0x9A, 0x05,
  0x0A, 0xA0, 0x24, 0x0B, 0xA0, 0x34, 0x09, 0xA0, 0x50,
  // "N" (U+004E)
  0x0A, 0xB0, 0x37, 0x82, 0xEF, 0xEA, 0xB0, 0xA7, 0x82, 0xEF, 0xEA, 0xC0, 0x26, 0x82, 0xEF, 0xEA,
  0xC0, 0xA6, 0x82, 0xEF, 0xEA, 0xD0, 0x25, 0x82, 0xEF, 0xEA, 0xA0, 0x9A, 0x09, 0x58, 0x2E, 0xFE,
  0xAA, 0x03, 0xB0, 0x14, 0x82, 0xEF, 0xEA, 0xA0, 0x10, 0xAA, 0x08, 0x48, 0x2E, 0xFE, 0xAA, 0x00,
  0x2A, 0x0E, 0x01, 0x38, 0x2E, 0xFE, 0xAA, 0x81, 0x20, 0xAA, 0x07, 0x38, 0x2E, 0xFE, 0xAA, 0x81,
  0x20, 0x3A, 0x0E, 0x38, 0x2E, 0xFE, 0xAA, 0x02, 0x20, 0xBA, 0x06, 0x28, 0x2E, 0xFE, 0xAA, 0x02,
  0x20, 0x4A, 0x0D, 0x28, 0x2E, 0xFE, 0xAA, 0x02, 0x30, 0xCA, 0x84, 0x50, 0xEF, 0xEA, 0xA0, 0x23,
  0x04, 0xA8, 0x4D, 0x0D, 0xFE, 0xAA, 0x02, 0x40, 0xCA, 0x83, 0x4C, 0xFE, 0xAA, 0x02, 0x40, 0x5A,
  0x83, 0xCC, 0xFE, 0xAA, 0x02, 0x50, 0xDC, 0x0E, 0x0A, 0xA0, 0x25, 0x06, 0xC0, 0xE0, 0xAA, 0x02,
  0x60, 0xDB, 0x0E, 0x0A, 0xA0, 0x26, 0x07, 0xB0, 0xE0, 0xAA, 0x02, 0x70, 0xEA, 0x0E,
  // "O" (U+004F)
  0x48, 0x61, 0x7B, 0xEF, 0xEB, 0x67, 0x10, 0x40, 0xEF, 0x0D, 0x02, 0x50, 0x30, 0xEB, 0x81, 0xB9,
  0xBB, 0x0D, 0x01, 0x40, 0xDA, 0x0C, 0x01, 0x30, 0x20, 0xDA, 0x0A, 0x30, 0x5A, 0x0E, 0x02, 0x50,
  0x2B, 0x02, 0x20, 0xAA, 0x09, 0x70, 0xAA, 0x08, 0x2B, 0x03, 0x70, 0x5A, 0x81, 0xC0, 0x2B, 0x71,
  0x02, 0xB1, 0x04, 0xA0, 0xD7, 0x2B, 0x02, 0x05, 0xA0, 0xC7, 0x20, 0xEA, 0x03, 0x06, 0xA0, 0xB7,
  0x20, 0xDA, 0x04, 0x06, 0xA0, 0xB7, 0x20, 0xDA, 0x04, 0x05, 0xA0, 0xC7, 0x20, 0xEA, 0x03, 0x04,
  0xA0, 0xD7, 0x2B, 0x02, 0x01, 0xB7, 0x10, 0x2B, 0x20, 0xDA, 0x03, 0x70, 0x5A, 0x0C, 0x20, 0xAA,
  0x08, 0x70, 0xAA, 0x08, 0x20, 0x4A, 0x0E, 0x01, 0x50, 0x3B, 0x02, 0x30, 0xBA, 0x0C, 0x01, 0x30,
  0x20, 0xDA, 0x0A, 0x40, 0x20, 0xEB, 0x81, 0xB9, 0xBB, 0x0D, 0x01, 0x50, 0x30, 0xDF, 0x0D, 0x02,
  0x71, 0x85, 0x7B, 0xEF, 0xEB, 0x65,
  // "P" (U+0050)
  0x0A, 0xD8, 0x2E, 0xB7, 0x12, 0x0A, 0xF9, 0x82, 0xE3, 0x0A, 0xA8, 0x2B, 0x99, 0xBB, 0x81, 0xE1,
  0xAA, 0x06, 0x30, 0x30, 0xEA, 0x07, 0x0A, 0xA0, 0x64, 0x07, 0xA0, 0xC0, 0xAA, 0x06, 0x40, 0x3A,
  0x0E, 0x0A, 0xA0, 0x64, 0x01, 0xB0, 0xAA, 0x06, 0x40, 0x2A, 0x0E, 0x0A, 0xA0, 0x64, 0x05, 0xA0,
  0xC0, 0xAA, 0x06, 0x40, 0xCA, 0x08, 0x0A, 0xA0, 0x62, 0x04, 0x0B, 0xB0, 0x20, 0xAF, 0xA8, 0x16,
  0x0A, 0xF0, 0xE0, 0x52, 0x0A, 0xA8, 0x3B, 0x98, 0x74, 0x40, 0xAA, 0x06, 0x71, 0x0A, 0xA0, 0x67,
  0x10, 0xAA, 0x06, 0x71, 0x0A, 0xA0, 0x67, 0x10, 0xAA, 0x06, 0x71, 0x0A, 0xA0, 0x67, 0x10, 0xAA,
  0x06, 0x71, 0x0A, 0xA0, 0x67, 0x10,
  // "Q" (U+0051)
  0x48, 0x61, 0x7B, 0xEF, 0xDB, 0x67, 0x10, 0x40, 0xEF, 0x0C, 0x02, 0x50, 0x30, 0xEB, 0x81, 0xB9,
  0xBB, 0x0D, 0x01, 0x40, 0xDA, 0x0C, 0x01, 0x30, 0x20, 0xDA, 0x0A, 0x30, 0x5A, 0x0E, 0x02, 0x50,
  0x2B, 0x03, 0x20, 0xAA, 0x09, 0x70, 0xAA, 0x08, 0x2B, 0x03, 0x70, 0x5A, 0x81, 0xD0, 0x2B, 0x71,
  0x02, 0xB1, 0x04, 0xA0, 0xD7, 0x2B, 0x03, 0x05, 0xA0, 0xC7, 0x20, 0xEA, 0x04, 0x06, 0xA0, 0xB7,
  0x20, 0xDA, 0x04, 0x06, 0xA0, 0xB7, 0x20, 0xDA, 0x00, 0x5A, 0x0C, 0x72, 0x0E, 0xA0, 0x04, 0xA0,
  0xD7, 0x2B, 0x03, 0x01, 0xB7, 0x10, 0x2B, 0x81, 0x10, 0xDA, 0x03, 0x70, 0x5A, 0x0D, 0x20, 0x9A,
  0x08, 0x70, 0xAA, 0x09, 0x20, 0x3A, 0x0E, 0x01, 0x50, 0x3B, 0x03, 0x30, 0xBA, 0x0C, 0x01, 0x30,
  0x20, 0xDA, 0x0B, 0x40, 0x20, 0xEB, 0x81, 0xB9, 0xBB, 0x0E, 0x01, 0x50, 0x30, 0xDF, 0x0D, 0x02,
  0x78, 0x21, 0x7C, 0xEB, 0x0E, 0x01, 0x76, 0x0C, 0xA0, 0x97, 0x60, 0x3B, 0x04, 0x76, 0x09, 0xA0,
  0xE0, 0x17, 0x60, 0xEA, 0x0A, 0x76, 0x05, 0xB0, 0x51,
  // "R" (U+0052)
  0x0A, 0xD8, 0x2E, 0xB7, 0x14, 0x0A, 0xF9, 0x0E, 0x04, 0x30, 0xAA, 0x82, 0xB9, 0x9B, 0xB0, 0xE0,
  0x12, 0x0A, 0xA0, 0x63, 0x02, 0x0E, 0xA0, 0x92, 0x0A, 0xA0, 0x64, 0x06, 0xA0, 0xD2, 0x0A, 0xA0,
  0x64, 0x02, 0xB2, 0x0A, 0xA0, 0x64, 0x01, 0xB2, 0x0A, 0xA0, 0x64, 0x02, 0xA0, 0xE2, 0x0A, 0xA0,
  0x64, 0x07, 0xA0, 0xB2, 0x0A, 0xA0, 0x63, 0x03, 0x0E, 0xA0, 0x52, 0x0A, 0xA8, 0x2B, 0x99, 0xBB,
  0x0A, 0x30, 0xAF, 0x90, 0x94, 0x0A, 0xF0, 0xB5, 0x0A, 0xA0, 0x62, 0x0E, 0xA0, 0x34, 0x0A, 0xA0,
  0x62, 0x07, 0xA0, 0xA4, 0x0A, 0xA0, 0x62, 0x01, 0x0E, 0xA0, 0x23, 0x0A, 0xA0, 0x63, 0x08, 0xA0,
  0xA3, 0x0A, 0xA0, 0x63, 0x01, 0xB0, 0x22, 0x0A, 0xA0, 0x64, 0x0A, 0xA0, 0xA2, 0x0A, 0xA0, 0x64,
  0x02, 0xB8, 0x12, 0x0A, 0xA0, 0x65, 0x0B, 0xA8, 0x1A, 0x0A, 0xA0, 0x65, 0x04, 0xB0, 0x20,
  // "S" (U+0053)
  0x38, 0x65, 0xBD, 0xFE, 0xC8, 0x33, 0x0B, 0xF9, 0x81, 0x30, 0xAB, 0x86, 0xB9, 0xAE, 0xFE, 0x02,
  0xB0, 0x44, 0x82, 0x57, 0x07, 0xA0, 0xA7, 0x10, 0x9A, 0x07, 0x71, 0x08, 0xA0, 0x97, 0x10, 0x6A,
  0x0E, 0x02, 0x70, 0x1B, 0x0E, 0x05, 0x70, 0x8C, 0x0B, 0x03, 0x60, 0x8D, 0x09, 0x60, 0x40, 0xDC,
  0x0C, 0x01, 0x60, 0x60, 0xDB, 0x0B, 0x71, 0x0A, 0xB0, 0x37, 0x10, 0xDA, 0x07, 0x71, 0x08, 0xA0,
  0x97, 0x10, 0x7A, 0x08, 0x71, 0x0B, 0xA8, 0x15, 0x96, 0x50, 0x6A, 0x87, 0xE0, 0xCF, 0xEB, 0x99,
  0xCB, 0x81, 0x70, 0xCF, 0x90, 0x82, 0x87, 0x27, 0xBD, 0xEF, 0xD9, 0x33,
  // "T" (U+0054)
  0x09, 0xFD, 0x09, 0xFD, 0x84, 0x59, 0x99, 0x9E, 0xA8, 0x3A, 0x99, 0x98, 0x50, 0xDA, 0x02, 0x72,
  0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0,
  0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20,
  0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02,
  0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x40,
  // "U" (U+0055)
  0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0,
  0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A,
  0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05,
  0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60,
  0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36,
  0x05, 0xA0, 0xA0, 0xCA, 0x04, 0x60, 0x6A, 0x09, 0x0A, 0xA0, 0x66, 0x08, 0xA0, 0x80, 0x7A, 0x0B,
  0x60, 0xDA, 0x04, 0x01, 0xB0, 0x64, 0x08, 0xA0, 0xE2, 0x08, 0xB8, 0x2C, 0x99, 0xDB, 0x06, 0x30,
  0xAF, 0x90, 0x85, 0x86, 0x4A, 0xDF, 0xED, 0x93, 0x30,
  // "V" (U+0056)
  0x0D, 0xA0, 0x47, 0x01, 0xB0, 0x10, 0x9A, 0x08, 0x70, 0x4A, 0x81, 0xC0, 0x5A, 0x0C, 0x70, 0x8A,
  0x81, 0x80, 0x1B, 0x01, 0x60, 0xCA, 0x04, 0x20, 0xCA, 0x04, 0x50, 0x1B, 0x30, 0x8A, 0x08, 0x50,
  0x5A, 0x0B, 0x30, 0x4A, 0x0C, 0x50, 0x9A, 0x07, 0x4B, 0x50, 0xCA, 0x03, 0x40, 0xBA, 0x04, 0x30,
  0x1A, 0x0E, 0x50, 0x7A, 0x08, 0x30, 0x5A, 0x0A, 0x50, 0x3A, 0x0C, 0x30, 0x9A, 0x06, 0x60, 0xEA,
  0x30, 0xDA, 0x01, 0x60, 0xAA, 0x81, 0x40, 0x1A, 0x0D, 0x70, 0x6A, 0x81, 0x80, 0x5A, 0x09, 0x70,
  0x1A, 0x81, 0xC0, 0x9A, 0x04, 0x71, 0x0D, 0xA1, 0x0C, 0xA0, 0x17, 0x10, 0x9A, 0x03, 0xA0, 0xC7,
  0x20, 0x5A, 0x09, 0xA0, 0x77, 0x20, 0x1A, 0x0E, 0xA0, 0x37, 0x30, 0xCB, 0x0E, 0x74, 0x08, 0xB0,
  0xA7, 0x40, 0x4B, 0x06, 0x60,
  // "W" (U+0057)
  0x0B, 0xA0, 0x46, 0x09, 0xA0, 0x76, 0x06, 0xA0, 0xA0, 0x8A, 0x07, 0x60, 0xCA, 0x0A, 0x60, 0x9A,
  0x06, 0x04, 0xA0, 0xB6, 0xB0, 0xE6, 0x0D, 0xA0, 0x30, 0x1A, 0x0E, 0x50, 0x3C, 0x02, 0x5B, 0x20,
  0xDA, 0x01, 0x48, 0x17, 0xFE, 0xA0, 0x54, 0x03, 0xA0, 0xC2, 0x0A, 0xA0, 0x54, 0x84, 0xAF, 0xCE,
  0xF8, 0x40, 0x7A, 0x09, 0x20, 0x6A, 0x08, 0x48, 0x4D, 0xF9, 0xCF, 0xC4, 0x0A, 0xA0, 0x52, 0x03,
  0xA0, 0xB3, 0x01, 0xA0, 0x70, 0x9A, 0x40, 0xDA, 0x02, 0x3A, 0x0E, 0x30, 0x5A, 0x04, 0x06, 0xA0,
  0x32, 0x01, 0xA0, 0xE4, 0x0C, 0xA0, 0x22, 0x08, 0xA0, 0x10, 0x3A, 0x06, 0x20, 0x4A, 0x0B, 0x40,
  0x9A, 0x05, 0x28, 0x1C, 0xFD, 0x2A, 0x0A, 0x20, 0x7A, 0x07, 0x40, 0x5A, 0x08, 0x2A, 0x09, 0x28,
  0x1C, 0xFD, 0x20, 0xAA, 0x04, 0x40, 0x2A, 0x81, 0xB0, 0x3A, 0x06, 0x20, 0x8A, 0x81, 0x10, 0xDA,
  0x01, 0x58, 0x3E, 0xFE, 0x06, 0xA0, 0x32, 0x05, 0xA0, 0x40, 0x1A, 0x0D, 0x60, 0xBA, 0x02, 0x09,
  0xA3, 0x01, 0xA0, 0x70, 0x4A, 0x0A, 0x60, 0x7A, 0x82, 0x4C, 0xFB, 0x48, 0x2D, 0xFA, 0x7A, 0x06,
  0x60, 0x4A, 0x82, 0x7E, 0xF8, 0x48, 0x2A, 0xFC, 0x9A, 0x03, 0x60, 0x1A, 0x0B, 0xA0, 0x54, 0x06,
  0xA0, 0xBA, 0x71, 0x0D, 0xC0, 0x14, 0x03, 0xC0, 0xC7, 0x10, 0xAB, 0x0D, 0x6C, 0x09, 0x71, 0x06,
  0xB0, 0xA6, 0x0C, 0xB0, 0x57, 0x10, 0x3B, 0x07, 0x60, 0x8B, 0x02, 0x40,
  // "X" (U+0058)
  0x02, 0xB0, 0x15, 0x09, 0xA8, 0x19, 0x0A, 0xA0, 0x75, 0x0E, 0xA8, 0x12, 0x03, 0xA0, 0xD4, 0x06,
  0xA0, 0xB3, 0x0C, 0xA0, 0x43, 0x0C, 0xA0, 0x43, 0x05, 0xA0, 0xB2, 0x03, 0xA0, 0xC5, 0x0D, 0xA8,
  0x12, 0x0A, 0xA0, 0x65, 0x06, 0xA0, 0x80, 0x1A, 0x0E, 0x78, 0x2E, 0xFE, 0x7A, 0x07, 0x70, 0x8C,
  0x0E, 0x01, 0x70, 0x1C, 0x09, 0x72, 0x0A, 0xB0, 0x27, 0x20, 0xDB, 0x04, 0x71, 0x05, 0xC0, 0xC7,
  0x10, 0xCA, 0x0D, 0xA0, 0x36, 0x04, 0xA0, 0xB0, 0x5A, 0x0B, 0x60, 0xBA, 0x81, 0x40, 0xDA, 0x02,
  0x40, 0x3A, 0x0C, 0x20, 0x7A, 0x0A, 0x40, 0xBA, 0x05, 0x20, 0x1B, 0x02, 0x20, 0x2A, 0x0D, 0x40,
  0x9A, 0x09, 0x20, 0xAA, 0x07, 0x40, 0x3A, 0x81, 0xE1, 0x2A, 0x0E, 0x60, 0xCA, 0x08, 0x09, 0xA0,
  0x86, 0x05, 0xA0, 0xE0,
  // "Y" (U+0059)
  0x0C, 0xA0, 0x66, 0x06, 0xA0, 0xC0, 0x6A, 0x0C, 0x60, 0xCA, 0x81, 0x50, 0xEA, 0x03, 0x40, 0x3A,
  0x0E, 0x20, 0x9A, 0x09, 0x40, 0x9A, 0x08, 0x20, 0x3A, 0x0E, 0x40, 0xEA, 0x02, 0x30, 0xCA, 0x05,
  0x20, 0x5A, 0x0B, 0x40, 0x6A, 0x0B, 0x20, 0xBA, 0x05, 0x50, 0xEA, 0x02, 0x01, 0xA0, 0xE6, 0x09,
  0xA0, 0x80, 0x7A, 0x08, 0x60, 0x3A, 0x00, 0xDA, 0x02, 0x70, 0xCC, 0x0B, 0x71, 0x06, 0xC0, 0x57,
  0x20, 0xEA, 0x0E, 0x73, 0x09, 0xA0, 0x97, 0x30, 0x8A, 0x08, 0x73, 0x08, 0xA0, 0x87, 0x30, 0x8A,
  0x08, 0x73, 0x08, 0xA0, 0x87, 0x30, 0x8A, 0x08, 0x73, 0x08, 0xA0, 0x87, 0x30, 0x8A, 0x08, 0x73,
  0x08, 0xA0, 0x85,
  // "Z" (U+005A)
  0x1F, 0xC0, 0x31, 0xFC, 0x81, 0x30, 0x88, 0x02, 0x90, 0xAB, 0x01, 0x71, 0x09, 0xA0, 0x97, 0x10,
  0x1B, 0x02, 0x71, 0x08, 0xA0, 0xA7, 0x20, 0xEA, 0x03, 0x71, 0x07, 0xA0, 0xB7, 0x20, 0xDA, 0x04,
  0x71, 0x06, 0xA0, 0xC7, 0x20, 0xDA, 0x05, 0x71, 0x04, 0xA0, 0xD7, 0x20, 0xBA, 0x06, 0x71, 0x03,
  0xA0, 0xE7, 0x20, 0xAA, 0x07, 0x71, 0x02, 0xA0, 0xE0, 0x17, 0x10, 0x9A, 0x09, 0x71, 0x01, 0xB0,
  0x27, 0x10, 0x8A, 0x0A, 0x72, 0x0E, 0xA0, 0xB8, 0x03, 0x90, 0x30, 0x2F, 0xC0, 0x60, 0x2F, 0xC0,
  0x60,
  // "[" (U+005B)
  0x0E, 0xD0, 0xA0, 0xED, 0x89, 0x1A, 0xEF, 0xE9, 0x99, 0x6E, 0xFD, 0x48, 0x1E, 0xFD, 0x48, 0x1E,
  0xFD, 0x48, 0x1E, 0xFD, 0x48, 0x1E, 0xFD, 0x48, 0x1E, 0xFD, 0x48, 0x1E, 0xFD, 0x48, 0x1E, 0xFD,
  0x48, 0x1E, 0xFD, 0x48, 0x1E, 0xFD, 0x48, 0x1E, 0xFD, 0x48, 0x1E, 0xFD, 0x48, 0x1E, 0xFD, 0x48,
  0x1E, 0xFD, 0x48, 0x1E, 0xFD, 0x48, 0x1E, 0xFD, 0x48, 0x1E, 0xFD, 0x48, 0x1E, 0xFD, 0x48, 0x1E,
  0xFD, 0x48, 0x1E, 0xFD, 0x48, 0x1E, 0xFD, 0x48, 0x1E, 0xFD, 0x40, 0xED, 0x0A, 0x0E, 0xD0, 0xA0,
  0x88, 0x01, 0x90, 0x60,
  // "\" (U+005C)
  0x06, 0xA0, 0x57, 0x01, 0xA0, 0xA7, 0x10, 0xBA, 0x01, 0x70, 0x5A, 0x06, 0x71, 0x81, 0xEF, 0xC7,
  0x10, 0x9A, 0x02, 0x70, 0x4A, 0x07, 0x71, 0x81, 0xDF, 0xD7, 0x10, 0x8A, 0x03, 0x70, 0x2A, 0x09,
  0x71, 0x81, 0xCF, 0xE7, 0x10, 0x7A, 0x04, 0x70, 0x1A, 0x0A, 0x71, 0x0B, 0xA0, 0x17, 0x05, 0xA0,
  0x67, 0x18, 0x1E, 0xFB, 0x71, 0x0A, 0xA0, 0x27, 0x04, 0xA0, 0x77, 0x18, 0x1E, 0xFD, 0x71, 0x08,
  0xA0, 0x37, 0x03, 0xA0, 0x97, 0x18, 0x1D, 0xFE,
  // "]" (U+005D)
  0x02, 0xE0, 0x50, 0x2E, 0x84, 0x51, 0x99, 0x9B, 0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05, 0xA0, 0x54,
  0x05, 0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05,
  0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05, 0xA0,
  0x54, 0x05, 0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05, 0xA0, 0x54,
  0x05, 0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05, 0xA0, 0x54, 0x05, 0xA0, 0x50, 0x2E, 0x05, 0x02, 0xE0,
  0x50, 0x18, 0x02, 0x90, 0x30,
  // "^" (U+005E)
  0x68, 0x1B, 0xF5, 0x74, 0x03, 0xA0, 0xC7, 0x40, 0xAB, 0x04, 0x72, 0x01, 0xC0, 0xB7, 0x28, 0x28,
  0xFE, 0x7A, 0x03, 0x78, 0x61, 0xEF, 0x90, 0xEF, 0xA7, 0x07, 0xA8, 0x12, 0x07, 0xA0, 0x26, 0x81,
  0xEF, 0xB2, 0x82, 0x1E, 0xF9, 0x50, 0x6A, 0x04, 0x30, 0x8A, 0x02, 0x48, 0x1D, 0xFC, 0x40, 0x1A,
  0x09, 0x30, 0x4A, 0x05, 0x50, 0x9A, 0x01, 0x28, 0x1B, 0xFE, 0x60, 0x2A, 0x81, 0x80, 0x3A, 0x07,
  0x78, 0x2B, 0xFE, 0x10,
  // "_" (U+005F)
  0x18, 0x09, 0x19, 0x03, 0x01, 0xFE, 0x05, 0x01, 0xFE, 0x05,
  // "`" (U+0060)
  0x09, 0xA0, 0xD3, 0x01, 0x0D, 0xA0, 0x63, 0x83, 0x2E, 0xFE, 0x13, 0x82, 0x3E, 0xF9, 0x48, 0x23,
  0xEF, 0x40,
  // "a" (U+0061)
  0x28, 0x62, 0x8C, 0xEF, 0xD9, 0x13, 0x05, 0xF0, 0xD0, 0x12, 0x01, 0xA8, 0x1B, 0x9A, 0xB0, 0x93,
  0x05, 0x01, 0x30, 0x4A, 0x0E, 0x72, 0x0D, 0xA0, 0x17, 0x10, 0xBA, 0x02, 0x38, 0x43, 0x68, 0x89,
  0xDA, 0x82, 0x30, 0x2B, 0xF9, 0x81, 0x31, 0xDF, 0xA0, 0x30, 0x7B, 0x06, 0x01, 0x20, 0xBA, 0x03,
  0x0C, 0xA0, 0x74, 0x0B, 0xA0, 0x30, 0xDA, 0x02, 0x40, 0xDA, 0x03, 0x0D, 0xA0, 0x23, 0x02, 0xB0,
  0x30, 0xBA, 0x07, 0x30, 0xBB, 0x03, 0x06, 0xB8, 0x3B, 0x9D, 0xFA, 0xA8, 0x13, 0x0C, 0xD0, 0x80,
  0x3A, 0x89, 0x03, 0x01, 0x9E, 0xEC, 0x60, 0x1A, 0x03,
  // "b" (U+0062)
  0x0E, 0xA7, 0x30, 0xEA, 0x73, 0x0E, 0xA7, 0x30, 0xEA, 0x73, 0x0E, 0xA7, 0x30, 0xEA, 0x73, 0x0E,
  0xA1, 0x84, 0x3B, 0xEE, 0xB3, 0x38, 0x2E, 0xFE, 0x4E, 0x04, 0x28, 0x6E, 0xFE, 0xDE, 0xA9, 0xEA,
  0x0E, 0x20, 0xEA, 0x0E, 0x02, 0x20, 0x10, 0xDA, 0x81, 0x70, 0xEA, 0x08, 0x40, 0x5A, 0x81, 0xB0,
  0xEA, 0x04, 0x40, 0x1A, 0x81, 0xE0, 0xEA, 0x01, 0x50, 0xEA, 0x01, 0x0E, 0xA6, 0x0D, 0xA0, 0x20,
  0xEA, 0x60, 0xCA, 0x03, 0x0E, 0xA6, 0x0D, 0xA0, 0x20, 0xEA, 0x01, 0x50, 0xEA, 0x01, 0x0E, 0xA0,
  0x44, 0x01, 0xA8, 0x1E, 0x0E, 0xA0, 0x84, 0x06, 0xA8, 0x1B, 0x0E, 0xA0, 0xE0, 0x32, 0x01, 0x0D,
  0xA8, 0x90, 0x60, 0xEF, 0xEE, 0xFA, 0x9E, 0xA0, 0xE2, 0x82, 0xEF, 0xA5, 0xE0, 0x42, 0x89, 0x0E,
  0xF7, 0x04, 0xBE, 0xEB, 0x33,
  // "c" (U+0063)
  0x38, 0x52, 0x9D, 0xFD, 0xB6, 0x30, 0x5F, 0x81, 0x10, 0x3B, 0x83, 0xD9, 0xAE, 0xA2, 0x0B, 0xA0,
  0x94, 0x81, 0x10, 0x1A, 0x0E, 0x70, 0x5A, 0x0A, 0x70, 0x8A, 0x07, 0x70, 0x9A, 0x05, 0x70, 0xAA,
  0x05, 0x70, 0xAA, 0x05, 0x70, 0x9A, 0x07, 0x70, 0x6A, 0x0A, 0x70, 0x3A, 0x0E, 0x71, 0x0D, 0xA0,
  0x94, 0x04, 0x20, 0x5B, 0x82, 0xC9, 0xAD, 0x93, 0x08, 0xF4, 0x85, 0x4A, 0xEF, 0xDA, 0x41,
  // "d" (U+0064)
  0x72, 0x07, 0xA0, 0x77, 0x20, 0x7A, 0x07, 0x72, 0x07, 0xA0, 0x77, 0x20, 0x7A, 0x07, 0x72, 0x07,
  0xA0, 0x77, 0x20, 0x7A, 0x07, 0x38, 0x57, 0xDF, 0xD8, 0x07, 0xA0, 0x72, 0x0B, 0xD0, 0xC0, 0x6A,
  0x81, 0x70, 0x7B, 0x83, 0xB9, 0xCF, 0xDA, 0x81, 0x70, 0xEA, 0x07, 0x30, 0x8B, 0x07, 0x03, 0xA0,
  0xE5, 0x0E, 0xA0, 0x70, 0x6A, 0x09, 0x50, 0xAA, 0x07, 0x09, 0xA0, 0x75, 0x08, 0xA0, 0x70, 0x9A,
  0x05, 0x50, 0x7A, 0x07, 0x0A, 0xA0, 0x55, 0x06, 0xA0, 0x70, 0xAA, 0x05, 0x50, 0x7A, 0x07, 0x09,
  0xA0, 0x75, 0x08, 0xA0, 0x70, 0x6A, 0x09, 0x50, 0xAA, 0x07, 0x03, 0xA0, 0xD5, 0x0E, 0xA8, 0x17,
  0x0E, 0xA0, 0x73, 0x09, 0xB8, 0x17, 0x07, 0xB8, 0x3B, 0x9C, 0xFD, 0xA0, 0x72, 0x0B, 0xD0, 0xC0,
  0x3A, 0x07, 0x38, 0x37, 0xDF, 0xD8, 0x28, 0x1E, 0xF7,
  // "e" (U+0065)
  0x38, 0x54, 0xAE, 0xEC, 0x71, 0x40, 0x7E, 0x0D, 0x01, 0x20, 0x4B, 0x81, 0xB9, 0xDA, 0x0B, 0x20,
  0xCA, 0x05, 0x30, 0xBA, 0x04, 0x02, 0xA0, 0xB4, 0x03, 0xA0, 0x80, 0x6A, 0x07, 0x5A, 0x0C, 0x08,
  0xA0, 0xB8, 0x01, 0x98, 0x2E, 0xFD, 0x9F, 0xB0, 0xE0, 0xAF, 0xB0, 0xE0, 0x9A, 0x05, 0x71, 0x08,
  0xA0, 0x67, 0x10, 0x5A, 0x09, 0x71, 0x01, 0xA0, 0xE7, 0x20, 0xBA, 0x0A, 0x58, 0x25, 0x20, 0x2B,
  0x85, 0xE9, 0x9A, 0xEF, 0x32, 0x05, 0xF9, 0x03, 0x38, 0x12, 0x9D, 0xA8, 0x1D, 0x94, 0x10,
  // "f" (U+0066)
  0x48, 0x47, 0xDF, 0xEC, 0x53, 0x09, 0xD0, 0x52, 0x01, 0xB8, 0x2B, 0x9C, 0x12, 0x05, 0xA0, 0xB6,
  0x07, 0xA0, 0x76, 0x08, 0xA0, 0x74, 0x01, 0x09, 0xE8, 0x17, 0x0A, 0xF8, 0x37, 0x06, 0x9C, 0xA8,
  0x2B, 0x99, 0x43, 0x08, 0xA0, 0x76, 0x08, 0xA0, 0x76, 0x08, 0xA0, 0x76, 0x08, 0xA0, 0x76, 0x08,
  0xA0, 0x76, 0x08, 0xA0, 0x76, 0x08, 0xA0, 0x76, 0x08, 0xA0, 0x76, 0x08, 0xA0, 0x76, 0x08, 0xA0,
  0x76, 0x08, 0xA0, 0x76, 0x08, 0xA0, 0x76, 0x08, 0xA0, 0x76, 0x08, 0xA0, 0x74,
  // "g" (U+0067)
  0x38, 0x37, 0xDF, 0xD8, 0x2A, 0x07, 0x20, 0xAD, 0x0C, 0x03, 0xA8, 0x17, 0x06, 0xB8, 0x3B, 0x9C,
  0xFD, 0xA8, 0x17, 0x0D, 0xA0, 0x73, 0x09, 0xB0, 0x70, 0x3A, 0x0E, 0x50, 0xEA, 0x07, 0x06, 0xA0,
  0x95, 0x0A, 0xA0, 0x70, 0x8A, 0x07, 0x50, 0x8A, 0x07, 0x09, 0xA0, 0x55, 0x07, 0xA0, 0x70, 0xAA,
  0x05, 0x50, 0x6A, 0x07, 0x0A, 0xA0, 0x55, 0x07, 0xA0, 0x70, 0x9A, 0x07, 0x50, 0x7A, 0x00, 0x7A,
  0x09, 0x50, 0xAA, 0x07, 0x03, 0xA0, 0xD5, 0x0E, 0xA8, 0x17, 0x0E, 0xA0, 0x73, 0x08, 0xB8, 0x17,
  0x07, 0xB8, 0x3B, 0x9C, 0xFD, 0xA0, 0x72, 0x0B, 0xD0, 0xB0, 0x6A, 0x07, 0x38, 0x57, 0xDF, 0xD7,
  0x07, 0xA0, 0x77, 0x20, 0x7A, 0x06, 0x72, 0x09, 0xA0, 0x47, 0x20, 0xDA, 0x82, 0x10, 0x62, 0x50,
  0x9A, 0x0B, 0x28, 0x5C, 0xFD, 0xA9, 0xAD, 0xB0, 0x32, 0x0C, 0xF9, 0x06, 0x38, 0x71, 0x7B, 0xDF,
  0xED, 0x92, 0x30,
  // "h" (U+0068)
  0x0E, 0xA7, 0x20, 0xEA, 0x72, 0x0E, 0xA7, 0x20, 0xEA, 0x72, 0x0E, 0xA7, 0x20, 0xEA, 0x72, 0x0E,
  0xA1, 0x84, 0x4B, 0xEE, 0xB4, 0x28, 0x2E, 0xFE, 0x5E, 0x89, 0x05, 0x0E, 0xFE, 0xEF, 0xA9, 0xEA,
  0x81, 0xE0, 0xEA, 0x0E, 0x02, 0x20, 0x10, 0xEA, 0x04, 0x0E, 0xA0, 0x84, 0x09, 0xA0, 0x60, 0xEA,
  0x04, 0x40, 0x7A, 0x07, 0x0E, 0xA0, 0x14, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5,
  0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08,
  0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50,
  0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80,
  // "i" (U+0069)
  0x81, 0x8E, 0xA1, 0xB0, 0x2B, 0x82, 0x28, 0xE9, 0x72, 0x0E, 0xA1, 0x0E, 0xA1, 0x0E, 0xA1, 0x0E,
  0xA1, 0x0E, 0xA1, 0x0E, 0xA1, 0x0E, 0xA1, 0x0E, 0xA1, 0x0E, 0xA1, 0x0E, 0xA1, 0x0E, 0xA1, 0x0E,
  0xA1, 0x0E, 0xA1, 0x0E, 0xA1, 0x0E, 0xA1, 0x0E, 0xA1, 0x0E, 0xA1,
  // "j" (U+006A)
  0x38, 0x18, 0xEA, 0x4B, 0x02, 0x3B, 0x02, 0x38, 0x18, 0xE9, 0x77, 0x40, 0xEA, 0x40, 0xEA, 0x40,
  0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40,
  0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40,
  0xEA, 0x4B, 0x30, 0x3A, 0x83, 0xD0, 0xAA, 0xEA, 0x81, 0x90, 0xDC, 0x85, 0x20, 0xBE, 0xEB, 0x32,
  // "k" (U+006B)
  0x0E, 0xA7, 0x20, 0xEA, 0x72, 0x0E, 0xA7, 0x20, 0xEA, 0x72, 0x0E, 0xA7, 0x20, 0xEA, 0x72, 0x0E,
  0xA4, 0x02, 0xA8, 0x1E, 0x2E, 0xA4, 0x0C, 0xA8, 0x16, 0x0E, 0xA3, 0x07, 0xA0, 0xB2, 0x0E, 0xA2,
  0x02, 0xA0, 0xE0, 0x12, 0x0E, 0xA2, 0x0B, 0xA0, 0x53, 0x0E, 0xA1, 0x06, 0xA0, 0xA4, 0x0E, 0xA8,
  0x31, 0xEF, 0xE1, 0x48, 0x2E, 0xFE, 0xAA, 0x0E, 0x01, 0x40, 0xEE, 0x07, 0x40, 0xEB, 0x08, 0xA0,
  0xE0, 0x13, 0x0E, 0xA8, 0x17, 0x0A, 0xA0, 0x73, 0x0E, 0xA2, 0x02, 0xA0, 0xE0, 0x12, 0x0E, 0xA3,
  0x0A, 0xA0, 0x72, 0x0E, 0xA3, 0x03, 0xA8, 0x2E, 0x10, 0xEA, 0x40, 0xBA, 0x81, 0x70, 0xEA, 0x40,
  0x3A, 0x81, 0xE1, 0xEA, 0x50, 0xBA, 0x07,
  // "l" (U+006C)
  0x0E, 0xA0, 0xEA, 0x0E, 0xA0, 0xEA, 0x0E, 0xA0, 0xEA, 0x0E, 0xA0, 0xEA, 0x0E, 0xA0, 0xEA, 0x0E,
  0xA0, 0xEA, 0x0E, 0xA0, 0xEA, 0x0E, 0xA0, 0xEA, 0x0E, 0xA0, 0xEA, 0x0E, 0xA0, 0xEA, 0x0E, 0xA0,
  0xEA, 0x0E, 0xA0,
  // "m" (U+006D)
  0x89, 0x0E, 0xF7, 0x04, 0xBE, 0xEA, 0x22, 0x84, 0x4B, 0xEE, 0xB3, 0x28, 0x2E, 0xF9, 0x6D, 0x81,
  0xE2, 0x6E, 0x87, 0x30, 0xEF, 0xDE, 0xE9, 0xBB, 0x83, 0xBE, 0xEA, 0xAB, 0x81, 0xB0, 0xEA, 0x0E,
  0x01, 0x20, 0x6B, 0x0E, 0x02, 0x20, 0x5B, 0x10, 0xEA, 0x07, 0x4B, 0x09, 0x40, 0xDA, 0x02, 0x0E,
  0xA0, 0x44, 0x0D, 0xA0, 0x54, 0x0B, 0xA0, 0x30, 0xEA, 0x01, 0x40, 0xCA, 0x03, 0x40, 0xAA, 0x04,
  0x0E, 0xA5, 0x0C, 0xA0, 0x24, 0x0A, 0xA0, 0x40, 0xEA, 0x50, 0xCA, 0x02, 0x40, 0xAA, 0x04, 0x0E,
  0xA5, 0x0C, 0xA0, 0x24, 0x0A, 0xA0, 0x40, 0xEA, 0x50, 0xCA, 0x02, 0x40, 0xAA, 0x04, 0x0E, 0xA5,
  0x0C, 0xA0, 0x24, 0x0A, 0xA0, 0x40, 0xEA, 0x50, 0xCA, 0x02, 0x40, 0xAA, 0x04, 0x0E, 0xA5, 0x0C,
  0xA0, 0x24, 0x0A, 0xA0, 0x40, 0xEA, 0x50, 0xCA, 0x02, 0x40, 0xAA, 0x04, 0x0E, 0xA5, 0x0C, 0xA0,
  0x24, 0x0A, 0xA0, 0x40, 0xEA, 0x50, 0xCA, 0x02, 0x40, 0xAA, 0x04,
  // "n" (U+006E)
  0x89, 0x0E, 0xF7, 0x04, 0xBE, 0xEB, 0x42, 0x82, 0xEF, 0x95, 0xE8, 0x90, 0x50, 0xEF, 0xDE, 0xEA,
  0xAE, 0xA8, 0x1E, 0x0E, 0xA0, 0xE0, 0x22, 0x02, 0x0E, 0xA0, 0x40, 0xEA, 0x08, 0x40, 0xAA, 0x06,
  0x0E, 0xA0, 0x44, 0x07, 0xA0, 0x70, 0xEA, 0x01, 0x40, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80,
  0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06,
  0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E,
  0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08,
  // "o" (U+006F)
  0x38, 0x53, 0xAD, 0xFE, 0xA3, 0x50, 0x6F, 0x06, 0x30, 0x4B, 0x81, 0xC9, 0xBB, 0x04, 0x20, 0xCA,
  0x08, 0x30, 0x6A, 0x81, 0xD0, 0x2A, 0x0E, 0x50, 0xCA, 0x03, 0x06, 0xA0, 0x95, 0x08, 0xA0, 0x70,
  0x8A, 0x07, 0x50, 0x5A, 0x0A, 0x09, 0xA0, 0x55, 0x04, 0xA0, 0xB0, 0xAA, 0x05, 0x50, 0x3A, 0x0C,
  0x09, 0xA0, 0x55, 0x04, 0xA0, 0xB0, 0x8A, 0x07, 0x50, 0x5A, 0x0A, 0x05, 0xA0, 0x95, 0x08, 0xA0,
  0x70, 0x1A, 0x0E, 0x50, 0xCA, 0x81, 0x30, 0xAA, 0x08, 0x30, 0x6A, 0x0C, 0x20, 0x2B, 0x81, 0xC9,
  0xBB, 0x04, 0x30, 0x4F, 0x06, 0x58, 0x52, 0xAE, 0xFE, 0xA3, 0x30,
  // "p" (U+0070)
  0x89, 0x0E, 0xF8, 0x03, 0xBE, 0xEB, 0x33, 0x82, 0xEF, 0xA4, 0xE0, 0x42, 0x86, 0xEF, 0xDD, 0xEA,
  0x9E, 0xA8, 0x2E, 0x10, 0xEA, 0x0E, 0x02, 0x20, 0x10, 0xDA, 0x81, 0x70, 0xEA, 0x08, 0x40, 0x5A,
  0x81, 0xB0, 0xEA, 0x04, 0x40, 0x1A, 0x81, 0xE0, 0xEA, 0x01, 0x50, 0xEA, 0x01, 0x0E, 0xA6, 0x0D,
  0xA0, 0x20, 0xEA, 0x60, 0xCA, 0x03, 0x0E, 0xA6, 0x0D, 0xA0, 0x20, 0xEA, 0x01, 0x50, 0xEA, 0x01,
  0x0E, 0xA0, 0x44, 0x01, 0xA8, 0x1E, 0x0E, 0xA0, 0x84, 0x05, 0xA8, 0x1B, 0x0E, 0xA0, 0xE0, 0x22,
  0x01, 0x0D, 0xA8, 0x90, 0x60, 0xEF, 0xEE, 0xFA, 0x9E, 0xA0, 0xE2, 0x82, 0xEF, 0xE4, 0xE0, 0x42,
  0x0E, 0xA1, 0x84, 0x3B, 0xEE, 0xB3, 0x30, 0xEA, 0x73, 0x0E, 0xA7, 0x30, 0xEA, 0x73, 0x0E, 0xA7,
  0x30, 0xEA, 0x73, 0x0E, 0xA7, 0x30, 0xEA, 0x73,
  // "q" (U+0071)
  0x38, 0x37, 0xDF, 0xD8, 0x2A, 0x07, 0x20, 0xAD, 0x0C, 0x03, 0xA8, 0x17, 0x06, 0xB8, 0x3B, 0x9C,
  0xFD, 0xA8, 0x17, 0x0D, 0xA0, 0x73, 0x09, 0xB0, 0x70, 0x3A, 0x0E, 0x50, 0xEA, 0x07, 0x06, 0xA0,
  0x95, 0x0B, 0xA0, 0x70, 0x9A, 0x07, 0x50, 0x8A, 0x07, 0x09, 0xA0, 0x55, 0x07, 0xA0, 0x70, 0xAA,
  0x05, 0x50, 0x6A, 0x07, 0x0A, 0xA0, 0x55, 0x07, 0xA0, 0x70, 0x9A, 0x07, 0x50, 0x8A, 0x00, 0x7A,
  0x09, 0x50, 0xAA, 0x07, 0x03, 0xA0, 0xD5, 0x0E, 0xA8, 0x17, 0x0E, 0xA0, 0x73, 0x08, 0xB8, 0x17,
  0x07, 0xB8, 0x3B, 0x9C, 0xFC, 0xA0, 0x72, 0x0B, 0xD0, 0xB0, 0x6A, 0x07, 0x38, 0x57, 0xDF, 0xD7,
  0x07, 0xA0, 0x77, 0x20, 0x7A, 0x07, 0x72, 0x07, 0xA0, 0x77, 0x20, 0x7A, 0x07, 0x72, 0x07, 0xA0,
  0x77, 0x20, 0x7A, 0x07, 0x72, 0x07, 0xA0, 0x77, 0x20, 0x7A, 0x07,
  // "r" (U+0072)
  0x84, 0xEF, 0x60, 0x3B, 0xA8, 0x31, 0xEF, 0x93, 0xB8, 0x92, 0xE0, 0xEF, 0xCD, 0xFC, 0x99, 0x0E,
  0xB0, 0x74, 0x0E, 0xA0, 0xC5, 0x0E, 0xA0, 0x65, 0x0E, 0xA0, 0x25, 0x0E, 0xA0, 0x15, 0x0E, 0xA6,
  0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6,
  // "s" (U+0073)
  0x28, 0x56, 0xCE, 0xFD, 0xA4, 0x20, 0xBF, 0x05, 0x07, 0xB8, 0x5A, 0x9B, 0xFE, 0x0C, 0xA0, 0x43,
  0x82, 0x25, 0x0D, 0xA7, 0x0B, 0xA0, 0x56, 0x06, 0xB0, 0x86, 0x0B, 0xB0, 0xE0, 0x55, 0x08, 0xC0,
  0xB5, 0x02, 0x0B, 0xB0, 0xC6, 0x05, 0x0E, 0xA0, 0x66, 0x07, 0xA0, 0x96, 0x04, 0xA8, 0x1A, 0x82,
  0x40, 0xAA, 0x85, 0x8D, 0xFC, 0x99, 0xCB, 0x03, 0x0D, 0xF8, 0x90, 0x70, 0x38, 0xCE, 0xFE, 0xA4,
  0x20,
  // "t" (U+0074)
  0x38, 0x16, 0x71, 0x6A, 0x02, 0x50, 0x3A, 0x02, 0x50, 0x7A, 0x02, 0x38, 0x11, 0x8E, 0xD0, 0x08,
  0xF8, 0x28, 0x49, 0xEA, 0x82, 0xA9, 0x94, 0x20, 0xCA, 0x02, 0x50, 0xCA, 0x02, 0x50, 0xCA, 0x02,
  0x50, 0xCA, 0x02, 0x50, 0xCA, 0x02, 0x50, 0xCA, 0x02, 0x50, 0xCA, 0x02, 0x50, 0xCA, 0x02, 0x50,
  0xCA, 0x02, 0x50, 0xBA, 0x03, 0x50, 0xAA, 0x07, 0x50, 0x7B, 0x81, 0xAA, 0x92, 0x01, 0x0E, 0xC0,
  0xA3, 0x84, 0x2B, 0xEE, 0xC6,
  // "u" (U+0075)
  0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50,
  0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A,
  0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x8A, 0x07, 0xA0, 0xE5, 0x09,
  0xA0, 0x7B, 0x50, 0xBA, 0x07, 0x0E, 0xA0, 0x33, 0x01, 0xB0, 0x70, 0xBA, 0x0A, 0x30, 0x9B, 0x07,
  0x06, 0xB8, 0x3C, 0xAD, 0xFD, 0xA8, 0x17, 0x0C, 0xD0, 0xD0, 0x2A, 0x07, 0x28, 0x48, 0xDF, 0xD8,
  0x11, 0xA0, 0x70,
  // "v" (U+0076)
  0x0B, 0xA0, 0x45, 0x04, 0xA0, 0xB0, 0x7A, 0x08, 0x50, 0x8A, 0x07, 0x03, 0xA0, 0xC5, 0x0C, 0xA8,
  0x12, 0x0E, 0xA4, 0x01, 0xA0, 0xD2, 0x0A, 0xA0, 0x43, 0x05, 0xA0, 0x92, 0x05, 0xA0, 0x83, 0x08,
  0xA0, 0x52, 0x01, 0xA0, 0xC3, 0x0C, 0xA4, 0x0C, 0xA2, 0x01, 0xA0, 0xB4, 0x08, 0xA8, 0x14, 0x05,
  0xA0, 0x74, 0x04, 0xA8, 0x18, 0x09, 0xA0, 0x35, 0x85, 0xEF, 0xB0, 0xCF, 0xE6, 0x82, 0xAF, 0xE1,
  0xA0, 0x96, 0x06, 0xA0, 0x7A, 0x05, 0x60, 0x2A, 0x0C, 0xA0, 0x17, 0x0D, 0xB0, 0xC7, 0x10, 0x9B,
  0x07, 0x71, 0x04, 0xB0, 0x34,
  // "w" (U+0077)
  0x09, 0xA0, 0x54, 0x07, 0xB5, 0x0C, 0xA0, 0x10, 0x6A, 0x08, 0x40, 0xBB, 0x03, 0x4A, 0x81, 0xD0,
  0x2A, 0x0B, 0x40, 0xEB, 0x06, 0x30, 0x3A, 0x09, 0x28, 0x1E, 0xFE, 0x30, 0x2A, 0x81, 0xDF, 0xA3,
  0x07, 0xA0, 0x62, 0x0B, 0xA0, 0x22, 0x84, 0x6F, 0xE8, 0xFD, 0x30, 0xAA, 0x02, 0x20, 0x8A, 0x05,
  0x28, 0x29, 0xFC, 0x6A, 0x01, 0x28, 0x1D, 0xFE, 0x30, 0x4A, 0x09, 0x28, 0x2D, 0xF9, 0x3A, 0x81,
  0x40, 0x1A, 0x0B, 0x30, 0x1A, 0x81, 0xC0, 0x1A, 0x06, 0x1A, 0x81, 0x70, 0x4A, 0x07, 0x40, 0xDA,
  0x10, 0x4A, 0x85, 0x30, 0xCF, 0xB0, 0x7A, 0x04, 0x40, 0x9A, 0x02, 0x07, 0xA2, 0x83, 0x8F, 0xE0,
  0xBA, 0x50, 0x6A, 0x82, 0x5A, 0xFB, 0x20, 0x5A, 0x82, 0x1D, 0xFC, 0x50, 0x3A, 0x82, 0x7D, 0xF8,
  0x20, 0x2A, 0x05, 0xA0, 0x96, 0x81, 0xEF, 0xAA, 0x05, 0x38, 0x1E, 0xF9, 0xA0, 0x56, 0x81, 0xBF,
  0xEA, 0x01, 0x38, 0x1B, 0xFD, 0xA0, 0x26, 0x08, 0xB0, 0xE4, 0x08, 0xB0, 0xE7, 0x04, 0xB0, 0xA4,
  0x05, 0xB0, 0xA7, 0x01, 0xB0, 0x74, 0x02, 0xB0, 0x74,
  // "x" (U+0078)
  0x02, 0xB0, 0x14, 0x0D, 0xA8, 0x14, 0x0A, 0xA0, 0x83, 0x05, 0xA0, 0xC2, 0x02, 0xA0, 0xE3, 0x0C,
  0xA0, 0x43, 0x0A, 0xA8, 0x17, 0x04, 0xA0, 0xC4, 0x02, 0xA8, 0x1D, 0x0B, 0xA0, 0x45, 0x09, 0xA0,
  0x9A, 0x0C, 0x60, 0x2D, 0x04, 0x70, 0x9B, 0x0C, 0x71, 0x05, 0xB0, 0x77, 0x10, 0xDB, 0x0D, 0x70,
  0x5D, 0x06, 0x60, 0xDA, 0x04, 0xA0, 0xE5, 0x05, 0xA8, 0x1A, 0x09, 0xA0, 0x74, 0x0D, 0xA8, 0x13,
  0x02, 0xA0, 0xE3, 0x05, 0xA0, 0xB3, 0x0A, 0xA0, 0x72, 0x0D, 0xA0, 0x43, 0x03, 0xA8, 0x1E, 0x05,
  0xA0, 0xC5, 0x0B, 0xA0, 0x70,
  // "y" (U+0079)
  0x0B, 0xA0, 0x55, 0x05, 0xA0, 0xB0, 0x7A, 0x09, 0x50, 0x9A, 0x07, 0x02, 0xA0, 0xD5, 0x0D, 0xA8,
  0x12, 0x0D, 0xA0, 0x23, 0x01, 0xA0, 0xD2, 0x08, 0xA0, 0x63, 0x05, 0xA0, 0x92, 0x03, 0xA0, 0xA3,
  0x09, 0xA0, 0x43, 0x81, 0xEF, 0xE3, 0x0D, 0xA4, 0x0A, 0xA8, 0x13, 0x02, 0xA0, 0xB4, 0x05, 0xA8,
  0x17, 0x06, 0xA0, 0x74, 0x01, 0xA8, 0x1B, 0x0A, 0xA0, 0x25, 0x0B, 0xA1, 0x81, 0xEF, 0xD6, 0x06,
  0xA0, 0x5A, 0x09, 0x60, 0x2A, 0x0B, 0xA0, 0x47, 0x0D, 0xC7, 0x10, 0x8B, 0x0B, 0x71, 0x03, 0xB0,
  0x67, 0x2B, 0x02, 0x71, 0x02, 0xA0, 0xD7, 0x20, 0x7A, 0x08, 0x72, 0x0C, 0xA0, 0x37, 0x10, 0x6A,
  0x0D, 0x68, 0x15, 0xAB, 0xB0, 0x66, 0x06, 0xC0, 0xA7, 0x83, 0x5E, 0xFD, 0x77, 0x10,
  // "z" (U+007A)
  0x10, 0xCF, 0x92, 0x0C, 0xF9, 0x28, 0x47, 0x99, 0x99, 0xBA, 0x0D, 0x70, 0xAA, 0x06, 0x60, 0x2A,
  0x0D, 0x70, 0xAA, 0x06, 0x60, 0x2A, 0x0E, 0x70, 0x9A, 0x07, 0x60, 0x1A, 0x0E, 0x01, 0x60, 0x8A,
  0x08, 0x60, 0x10, 0xEA, 0x01, 0x60, 0x8A, 0x09, 0x70, 0xEA, 0x02, 0x60, 0x7A, 0x09, 0x70, 0xEA,
  0x0A, 0x80, 0x19, 0x00, 0x2F, 0xA0, 0x30, 0x2F, 0xA0, 0x30,
  // "{" (U+007B)
  0x58, 0x25, 0xBD, 0xE4, 0x0A, 0xB0, 0xE3, 0x05, 0xB0, 0xD0, 0x93, 0x0A, 0xA0, 0x85, 0x0B, 0xA0,
  0x15, 0x0C, 0xA6, 0x0C, 0xA6, 0x0C, 0xA6, 0x0C, 0xA6, 0x0C, 0xA6, 0x81, 0xEF, 0xE5, 0x07, 0xA0,
  0xB3, 0x09, 0x0C, 0xA0, 0xE0, 0x33, 0xB0, 0x90, 0x14, 0xC0, 0xA0, 0x13, 0x81, 0x13, 0xCA, 0x09,
  0x50, 0x1A, 0x0E, 0x60, 0xDA, 0x60, 0xCA, 0x60, 0xCA, 0x60, 0xCA, 0x60, 0xCA, 0x60, 0xCA, 0x01,
  0x50, 0xAA, 0x08, 0x50, 0x5B, 0x0C, 0x09, 0x40, 0xBB, 0x0E, 0x58, 0x26, 0xBE, 0xE0,
  // "|" (U+007C)
  0x08, 0xA0, 0x8A, 0x08, 0xA0, 0x8A, 0x08, 0xA0, 0x8A, 0x08, 0xA0, 0x8A, 0x08, 0xA0, 0x8A, 0x08,
  0xA0, 0x8A, 0x08, 0xA0, 0x8A, 0x08, 0xA0, 0x8A, 0x08, 0xA0, 0x8A, 0x08, 0xA0, 0x8A, 0x08, 0xA0,
  0x8A, 0x08, 0xA0, 0x8A, 0x08, 0xA0, 0x8A, 0x08, 0xA0, 0x8A, 0x08, 0xA0, 0x8A,
  // "}" (U+007D)
  0x82, 0xDE, 0xB5, 0x60, 0xEB, 0x0B, 0x50, 0x90, 0xCB, 0x06, 0x60, 0x8A, 0x0B, 0x60, 0x1A, 0x0D,
  0x7A, 0x0D, 0x7A, 0x0D, 0x7A, 0x0D, 0x7A, 0x0D, 0x7A, 0x0D, 0x70, 0xEA, 0x70, 0xBA, 0x08, 0x60,
  0x30, 0xEA, 0x0D, 0x0A, 0x50, 0x20, 0x8B, 0x01, 0x40, 0x9C, 0x01, 0x30, 0x8A, 0x81, 0xC4, 0x14,
  0x0D, 0xA0, 0x26, 0xA0, 0xE7, 0xA0, 0xD7, 0xA0, 0xD7, 0xA0, 0xD7, 0xA0, 0xD6, 0x01, 0xA0, 0xD6,
  0x07, 0xA0, 0xB4, 0x09, 0x0C, 0xB0, 0x64, 0x0E, 0xB0, 0xB5, 0x82, 0xDE, 0xB6, 0x60,
  // "~" (U+007E)
  0x18, 0x31, 0x78, 0x61, 0x68, 0x12, 0x5E, 0xC0, 0x80, 0x13, 0x81, 0x96, 0xEF, 0x89, 0x1B, 0x9D,
  0xF6, 0xF9, 0x11, 0x5B, 0xD8, 0x1E, 0x27, 0x58, 0x44, 0xBD, 0xEB, 0x21,
  // "¡" (U+00A1)
  0x82, 0x7E, 0xC2, 0xB0, 0x9B, 0x83, 0x97, 0xED, 0x27, 0x18, 0x76, 0xFE, 0x07, 0xFE, 0x07, 0xA1,
  0x08, 0xA1, 0x08, 0xA0, 0x10, 0x9A, 0x01, 0x0A, 0xA0, 0x20, 0xAA, 0x02, 0x0B, 0xA0, 0x30, 0xBA,
  0x04, 0x0C, 0xA0, 0x40, 0xDA, 0x05, 0x0D, 0xA0, 0x50, 0xEA, 0x06, 0x0E, 0xA0, 0x7B, 0x07,
  // "¢" (U+00A2)
  0x58, 0x1D, 0xF1, 0x71, 0x81, 0xDF, 0x17, 0x83, 0x4E, 0xF8, 0x44, 0x03, 0x0D, 0xD8, 0x2E, 0x10,
  0x3F, 0x0C, 0x20, 0xBA, 0x86, 0xC3, 0x02, 0x65, 0x02, 0xA0, 0xE0, 0x16, 0x06, 0xA0, 0x97, 0x09,
  0xA0, 0x67, 0x0A, 0xA0, 0x57, 0x0B, 0xA0, 0x47, 0x0B, 0xA0, 0x47, 0x0A, 0xA0, 0x67, 0x08, 0xA0,
  0x97, 0x04, 0xA0, 0xE0, 0x17, 0x0E, 0xA8, 0x4C, 0x30, 0x15, 0xA2, 0x06, 0xF0, 0xE3, 0x09, 0xE0,
  0xD4, 0x85, 0x39, 0xEF, 0xA7, 0x16, 0x0D, 0x97, 0x20, 0xD9, 0x72, 0x0D, 0x94,
  // "£" (U+00A3)
  0x48, 0x62, 0x9D, 0xFE, 0xC7, 0x14, 0x03, 0x0E, 0xE0, 0xC4, 0x0D, 0xA8, 0x4E, 0x9A, 0xDF, 0x73,
  0x03, 0xA0, 0xE0, 0x13, 0x05, 0x01, 0x30, 0x6A, 0x09, 0x72, 0x07, 0xA0, 0x87, 0x20, 0x7A, 0x08,
  0x72, 0x07, 0xA0, 0x87, 0x20, 0x7A, 0x08, 0x78, 0x17, 0x9C, 0xA8, 0x3C, 0x99, 0x97, 0x30, 0xCF,
  0x90, 0xD3, 0x0C, 0xF9, 0x0D, 0x50, 0x7A, 0x08, 0x72, 0x07, 0xA0, 0x87, 0x20, 0x7A, 0x08, 0x72,
  0x07, 0xA0, 0x77, 0x20, 0x9A, 0x05, 0x72, 0x0D, 0xA0, 0x17, 0x10, 0x6A, 0x08, 0x71, 0x07, 0xA0,
  0xE8, 0x04, 0x90, 0x20, 0xBF, 0xC0, 0x40, 0xBF, 0xC0, 0x40,
  // "¤" (U+00A4)
  0x10, 0x40, 0x77, 0x28, 0x1A, 0x12, 0xA8, 0x96, 0x41, 0x9D, 0xFC, 0x60, 0xAF, 0xC0, 0xBF, 0xEE,
  0xD0, 0xDA, 0x82, 0x60, 0x1D, 0xB8, 0x1B, 0x9C, 0xB0, 0x93, 0x82, 0xAF, 0xC1, 0x38, 0x24, 0xEF,
  0x52, 0x02, 0xA0, 0x15, 0x81, 0x5F, 0xC2, 0x81, 0x6F, 0xA7, 0x85, 0xEF, 0x10, 0x7F, 0x97, 0x85,
  0xEF, 0x20, 0x5F, 0xC6, 0x01, 0xA2, 0x82, 0x1E, 0xF5, 0x58, 0x1A, 0xFA, 0x30, 0x9A, 0x83, 0x71,
  0x03, 0xAA, 0x04, 0x20, 0x4F, 0xB8, 0x5D, 0x02, 0xEF, 0xCA, 0xC0, 0xE0, 0x8A, 0x89, 0x5B, 0x0B,
  0xD1, 0x03, 0x78, 0x61, 0x05, 0xF7, 0x20, 0x27, 0x20, 0x31,
  // "¥" (U+00A5)
  0x01, 0xA0, 0xE6, 0x0A, 0xA8, 0x16, 0x0B, 0xA0, 0x54, 0x01, 0xB8, 0x11, 0x05, 0xA0, 0xB4, 0x05,
  0xA0, 0xA3, 0x0E, 0xA0, 0x13, 0x0B, 0xA0, 0x53, 0x0A, 0xA0, 0x62, 0x01, 0xA0, 0xE4, 0x04, 0xA0,
  0xB2, 0x06, 0xA0, 0x95, 0x0E, 0xA8, 0x11, 0x0B, 0xA0, 0x35, 0x08, 0xA0, 0x60, 0x1A, 0x0D, 0x60,
  0x3A, 0x0C, 0x06, 0xA0, 0x77, 0x0D, 0xA0, 0xDA, 0x02, 0x70, 0x7C, 0x0B, 0x68, 0x12, 0x24, 0xC8,
  0x17, 0x22, 0x4F, 0xB0, 0x53, 0xFB, 0x05, 0x60, 0x5A, 0x0A, 0x73, 0x05, 0xA0, 0xA7, 0xFB, 0x05,
  0x3F, 0xB0, 0x53, 0x82, 0x89, 0x9B, 0xA8, 0x3D, 0x99, 0x93, 0x60, 0x5A, 0x0A, 0x73, 0x05, 0xA0,
  0xA7, 0x30, 0x5A, 0x0A, 0x50,
  // "¦" (U+00A6)
  0x08, 0xA0, 0x8A, 0x08, 0xA0, 0x8A, 0x08, 0xA0, 0x8A, 0x08, 0xA0, 0x8A, 0x08, 0xA0, 0x8A, 0x08,
  0xA0, 0x8A, 0x77, 0x40, 0x8A, 0x08, 0xA0, 0x8A, 0x08, 0xA0, 0x8A, 0x08, 0xA0, 0x8A, 0x08, 0xA0,
  0x8A, 0x08, 0xA0, 0x8A, 0x08, 0xA0,
  // "§" (U+00A7)
  0x28, 0x53, 0xAE, 0xFE, 0xB5, 0x20, 0x5F, 0x81, 0x91, 0xEA, 0x85, 0xB9, 0xAE, 0xF5, 0x4A, 0x08,
  0x48, 0x17, 0x05, 0xA0, 0x56, 0x02, 0xA0, 0xB7, 0x0A, 0xA0, 0xD0, 0x56, 0x0B, 0xB0, 0xD0, 0x43,
  0x05, 0xA0, 0xEB, 0x81, 0x90, 0x2A, 0x82, 0x60, 0x5D, 0xA8, 0x28, 0x7F, 0xE3, 0x85, 0x1D, 0xFE,
  0x8F, 0xE4, 0x07, 0xA0, 0x5A, 0x0A, 0x38, 0x37, 0xFE, 0x0C, 0xA8, 0x4D, 0x62, 0xEF, 0x82, 0x09,
  0xD0, 0xB4, 0x03, 0x0B, 0xB0, 0x96, 0x03, 0x0D, 0xA0, 0x67, 0x81, 0xDF, 0xD7, 0x83, 0xAF, 0xE6,
  0x44, 0x89, 0x02, 0xEF, 0xD9, 0xFE, 0xA9, 0xAB, 0x00, 0x8F, 0x0B, 0x28, 0x54, 0xBE, 0xFE, 0xB6,
  0x20,
  // "¨" (U+00A8)
  0x81, 0xAE, 0x72, 0x81, 0x7E, 0xA1, 0xA0, 0xC2, 0x0C, 0xA8, 0x21, 0xAE, 0x72, 0x81, 0x7E, 0xA1,
  // "©" (U+00A9)
  0x78, 0x72, 0x6A, 0xBC, 0xB9, 0x61, 0x75, 0x02, 0x0A, 0xFA, 0x09, 0x01, 0x72, 0x06, 0xA8, 0x1C,
  0x73, 0x28, 0x51, 0x37, 0xDF, 0xE4, 0x70, 0x7A, 0x06, 0x72, 0x08, 0xA0, 0x55, 0x82, 0x4F, 0xE3,
  0x38, 0x41, 0x68, 0x85, 0x12, 0x05, 0xA0, 0x34, 0x81, 0xEF, 0x43, 0x07, 0xD0, 0xE0, 0x72, 0x81,
  0x6F, 0xD3, 0x81, 0x7F, 0x83, 0x08, 0xF0, 0x73, 0x81, 0xBF, 0x52, 0x81, 0xDF, 0x12, 0x03, 0xA0,
  0xD0, 0x52, 0x81, 0x39, 0x13, 0x85, 0x3F, 0xC0, 0x3F, 0xA3, 0x09, 0xA0, 0x27, 0x38, 0x4C, 0xF1,
  0x6F, 0x63, 0x81, 0xDF, 0xA7, 0x48, 0x49, 0xF4, 0x7F, 0x43, 0xA0, 0x67, 0x48, 0x46, 0xF6, 0x8F,
  0x32, 0x01, 0xA0, 0x57, 0x48, 0x46, 0xF7, 0x8F, 0x42, 0x01, 0xA0, 0x57, 0x48, 0x46, 0xF6, 0x6F,
  0x63, 0xA0, 0x77, 0x48, 0x48, 0xF4, 0x3F, 0x93, 0x81, 0xCF, 0xC7, 0x48, 0x4B, 0xF1, 0x0E, 0xE3,
  0x07, 0xA0, 0x84, 0x00, 0x13, 0x81, 0x1F, 0xD2, 0x81, 0x9F, 0x62, 0x01, 0x0E, 0xA8, 0x4D, 0x99,
  0xBF, 0x43, 0x81, 0x9F, 0x72, 0x82, 0x1F, 0xE2, 0x20, 0x30, 0xEE, 0x04, 0x28, 0x14, 0xFE, 0x48,
  0x27, 0xFD, 0x12, 0x85, 0x18, 0xDF, 0xEB, 0x62, 0x82, 0x2E, 0xF5, 0x58, 0x2A, 0xFE, 0x47, 0x28,
  0x25, 0xEF, 0x87, 0x09, 0xA0, 0xA0, 0x44, 0x81, 0x15, 0xBA, 0x07, 0x72, 0x05, 0x0D, 0xB8, 0x1E,
  0xDE, 0xB0, 0xC0, 0x37, 0x58, 0x74, 0x9C, 0xEF, 0xEC, 0x83, 0x70,
  // "ª" (U+00AA)
  0x18, 0x52, 0x8C, 0xEE, 0xB2, 0x28, 0x53, 0xFB, 0x9C, 0xFD, 0x30, 0x23, 0x81, 0xEF, 0x36, 0x81,
  0xBF, 0x52, 0x81, 0x6B, 0xEB, 0x89, 0x15, 0x0B, 0xFD, 0x97, 0xDF, 0x52, 0xA0, 0x12, 0x82, 0xCF,
  0x52, 0xA2, 0x02, 0xA8, 0xA1, 0x50, 0xDF, 0xB9, 0xED, 0xF5, 0x02, 0xCF, 0xD6, 0x4F, 0x50,
  // "«" (U+00AB)
  0x40, 0x15, 0x01, 0x68, 0x1D, 0xC4, 0x38, 0x1C, 0xD4, 0x30, 0xAA, 0x04, 0x20, 0x9A, 0x05, 0x20,
  0x7A, 0x0A, 0x20, 0x5A, 0x0B, 0x20, 0x3A, 0x89, 0x1E, 0x10, 0x2E, 0xFE, 0x10, 0x1D, 0xA0, 0x42,
  0x0D, 0xA0, 0x62, 0x0B, 0xA0, 0xA2, 0x0A, 0xA0, 0xB3, 0x0B, 0xA0, 0xA2, 0x0A, 0xA0, 0xB3, 0x01,
  0x0D, 0xA0, 0x52, 0x0D, 0xA0, 0x63, 0x03, 0xA8, 0x6E, 0x10, 0x2E, 0xFE, 0x13, 0x07, 0xA0, 0xA2,
  0x05, 0xA0, 0xB4, 0x0A, 0xA0, 0x52, 0x09, 0xA0, 0x63, 0x82, 0x1D, 0xC3, 0x38, 0x1C, 0xD4, 0x40,
  0x15, 0x01, 0x20,
  // "¬" (U+00AC)
  0x08, 0x80, 0x79, 0x01, 0x0E, 0xFC, 0x02, 0x0E, 0xFC, 0x02, 0x72, 0x04, 0xA0, 0x27, 0x20, 0x4A,
  0x02, 0x72, 0x04, 0xA0, 0x27, 0x20, 0x4A, 0x02, 0x72, 0x04, 0xA0, 0x27, 0x20, 0x4A, 0x02,
  // "®" (U+00AE)
  0x78, 0x72, 0x6A, 0xBC, 0xB9, 0x61, 0x75, 0x02, 0x0A, 0xFA, 0x09, 0x01, 0x72, 0x06, 0xA8, 0x1C,
  0x73, 0x28, 0x51, 0x37, 0xDF, 0xE4, 0x70, 0x7A, 0x06, 0x72, 0x08, 0xA0, 0x55, 0x89, 0x24, 0xFE,
  0x30, 0x69, 0x99, 0x86, 0x23, 0x05, 0xA0, 0x34, 0x81, 0xEF, 0x42, 0x0A, 0xE0, 0x93, 0x81, 0x6F,
  0xD3, 0x81, 0x7F, 0x83, 0x0A, 0xF0, 0x53, 0x81, 0xBF, 0x52, 0x81, 0xDF, 0x13, 0x84, 0xAF, 0xA0,
  0x15, 0xA0, 0xA3, 0x85, 0x3F, 0xC0, 0x3F, 0xA4, 0x81, 0xAF, 0xA3, 0x81, 0xBF, 0xC4, 0x84, 0xCF,
  0x16, 0xF6, 0x48, 0x1A, 0xFA, 0x38, 0x1B, 0xFB, 0x48, 0x49, 0xF4, 0x7F, 0x44, 0x81, 0xAF, 0xA2,
  0x05, 0xA0, 0x64, 0x84, 0x6F, 0x68, 0xF3, 0x48, 0x3A, 0xFE, 0xDE, 0xA0, 0xB5, 0x84, 0x6F, 0x78,
  0xF4, 0x40, 0xAD, 0x0D, 0x68, 0x46, 0xF6, 0x6F, 0x64, 0x83, 0xAF, 0xA0, 0x3A, 0x03, 0x58, 0x48,
  0xF4, 0x3F, 0x94, 0x81, 0xAF, 0xA2, 0x81, 0xBF, 0xB5, 0x84, 0xBF, 0x10, 0xEE, 0x48, 0x1A, 0xFA,
  0x20, 0x3A, 0x04, 0x38, 0x11, 0xFD, 0x28, 0x19, 0xF6, 0x38, 0x1A, 0xFA, 0x38, 0x1B, 0xFC, 0x38,
  0x19, 0xF7, 0x28, 0x21, 0xFE, 0x22, 0x81, 0xAF, 0xA3, 0x04, 0xA8, 0x35, 0x04, 0xFE, 0x48, 0x67,
  0xFD, 0x10, 0x12, 0x14, 0x85, 0x22, 0x12, 0xEF, 0x55, 0x82, 0xAF, 0xE4, 0x72, 0x82, 0x5E, 0xF8,
  0x70, 0x9A, 0x0A, 0x04, 0x48, 0x11, 0x5B, 0xA0, 0x77, 0x20, 0x50, 0xDB, 0x81, 0xED, 0xEB, 0x0C,
  0x03, 0x75, 0x87, 0x49, 0xCE, 0xFE, 0xC8, 0x37,
  // "¯" (U+00AF)
  0x18, 0x09, 0x19, 0x08, 0x01, 0xFF, 0x01, 0xFF,
  // "°" (U+00B0)
  0x28, 0x46, 0xCE, 0xD9, 0x13, 0x09, 0xD8, 0x2E, 0x20, 0x4A, 0x89, 0x05, 0x02, 0xBF, 0xB0, 0x9F,
  0x83, 0x01, 0xA8, 0x21, 0xAF, 0x64, 0x84, 0xEF, 0x29, 0xF8, 0x4A, 0x83, 0x14, 0xFE, 0x42, 0x81,
  0xAF, 0xC2, 0x0A, 0xA0, 0xEA, 0x0E, 0x03, 0x38, 0x47, 0xDF, 0xEA, 0x22,
  // "±" (U+00B1)
  0x5A, 0x06, 0x73, 0xA0, 0x67, 0x3A, 0x06, 0x73, 0xA0, 0x67, 0x3A, 0x06, 0x73, 0xA0, 0x65, 0x0E,
  0xFC, 0x04, 0x0E, 0xFC, 0x04, 0x08, 0x80, 0x09, 0xA8, 0x4B, 0x99, 0x99, 0x25, 0xA0, 0x67, 0x3A,
  0x06, 0x73, 0xA0, 0x67, 0x3A, 0x06, 0x73, 0xA0, 0x67, 0x3A, 0x06, 0x77, 0x40, 0x88, 0x07, 0x90,
  0x30, 0xEF, 0xC0, 0x50, 0xEF, 0xC0, 0x50,
  // "²" (U+00B2)
  0x18, 0x51, 0x8D, 0xFE, 0xA1, 0x20, 0xDD, 0x0D, 0x28, 0x39, 0xB3, 0x05, 0xA0, 0x56, 0x81, 0xEF,
  0x76, 0xA0, 0x55, 0x81, 0x7F, 0xE5, 0x82, 0x2E, 0xF5, 0x48, 0x21, 0xDF, 0x94, 0x82, 0x1C, 0xFA,
  0x58, 0x1B, 0xFB, 0x58, 0x2A, 0xFD, 0x14, 0x03, 0xF0, 0xA0, 0x3F, 0x0A,
  // "³" (U+00B3)
  0x18, 0x90, 0x29, 0xEF, 0xEA, 0x20, 0x1E, 0xD8, 0x6E, 0x10, 0x78, 0x20, 0x4A, 0x05, 0x68, 0x1D,
  0xF5, 0x48, 0x31, 0x7F, 0xE1, 0x20, 0x6B, 0x0C, 0x02, 0x30, 0x6B, 0x0E, 0x07, 0x50, 0x10, 0x6A,
  0x06, 0x68, 0x19, 0xFB, 0x68, 0x93, 0x8F, 0xC3, 0xA4, 0x21, 0x5E, 0xF8, 0x3E, 0x89, 0x0D, 0x10,
  0x7C, 0xEF, 0xD9, 0x11,
  // "´" (U+00B4)
  0x20, 0x5B, 0x03, 0x20, 0xDA, 0x08, 0x20, 0x6A, 0x0A, 0x28, 0x21, 0xEF, 0xB3, 0x81, 0xAF, 0xA4,
  // "µ" (U+00B5)
  0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50,
  0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80,
  0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x08,
  0xA0, 0x80, 0xEA, 0x01, 0x40, 0xAA, 0x08, 0x0E, 0xA0, 0x44, 0x0E, 0xA0, 0x80, 0xEA, 0x0A, 0x30,
  0x8B, 0x08, 0x0E, 0xB8, 0x3C, 0x9C, 0xFD, 0xA0, 0x80, 0xEE, 0x0E, 0x02, 0xA8, 0x94, 0x8E, 0xFE,
  0x5D, 0xEB, 0x30, 0xDF, 0x8E, 0xA7, 0x20, 0xEA, 0x72, 0x0E, 0xA7, 0x20, 0xEA, 0x72, 0x0E, 0xA7,
  0x20, 0xEA, 0x72, 0x0E, 0xA7, 0x20,
  // "¶" (U+00B6)
  0x30, 0x70, 0xDF, 0x0A, 0x20, 0xBE, 0x84, 0xEE, 0xFA, 0x06, 0xE8, 0x58, 0x03, 0xFA, 0x0C, 0xE8,
  0x38, 0x03, 0xFA, 0x1F, 0x84, 0x80, 0x3F, 0xA3, 0xF8, 0x48, 0x03, 0xFA, 0x4F, 0x84, 0x80, 0x3F,
  0xA5, 0xF8, 0x48, 0x03, 0xFA, 0x4F, 0x84, 0x80, 0x3F, 0xA4, 0xF8, 0x48, 0x03, 0xFA, 0x2F, 0x85,
  0x80, 0x3F, 0xA0, 0xEE, 0x85, 0x80, 0x3F, 0xA0, 0xAE, 0x85, 0x80, 0x3F, 0xA0, 0x3E, 0x83, 0x80,
  0x3F, 0xA2, 0x05, 0x0E, 0xC8, 0x38, 0x03, 0xFA, 0x48, 0x74, 0x57, 0xF8, 0x03, 0xFA, 0x68, 0x55,
  0xF8, 0x03, 0xFA, 0x68, 0x55, 0xF8, 0x03, 0xFA, 0x68, 0x55, 0xF8, 0x03, 0xFA, 0x68, 0x55, 0xF8,
  0x03, 0xFA, 0x68, 0x55, 0xF8, 0x03, 0xFA, 0x68, 0x55, 0xF8, 0x03, 0xFA, 0x68, 0x55, 0xF8, 0x03,
  0xFA, 0x68, 0x55, 0xF8, 0x03, 0xFA, 0x68, 0x55, 0xF8, 0x03, 0xFA, 0x68, 0x55, 0xF8, 0x03, 0xFA,
  0x68, 0x55, 0xF8, 0x03, 0xFA, 0x68, 0x52, 0x63, 0x01, 0x64,
  // "·" (U+00B7)
  0x18, 0x39, 0xEC, 0x12, 0xB0, 0x70, 0x2B, 0x84, 0x70, 0x8E, 0xC1,
  // "¸" (U+00B8)
  0x20, 0x70, 0x53, 0x81, 0x5F, 0x63, 0x82, 0xCF, 0xD6, 0x20, 0x20, 0x8A, 0x06, 0x38, 0x1B, 0xFA,
  0x28, 0x41, 0xDF, 0x9D, 0xDB, 0x84, 0x3C, 0xFE, 0xB3, 0x10,
  // "¹" (U+00B9)
  0x30, 0x8A, 0x10, 0x10, 0xBB, 0x82, 0x2D, 0xFE, 0xA8, 0x29, 0xFC, 0x5A, 0x18, 0x17, 0x04, 0xA3,
  0x04, 0xA3, 0x04, 0xA3, 0x04, 0xA3, 0x04, 0xA3, 0x04, 0xA3, 0x04, 0xA3, 0x04, 0xA3, 0x04, 0xA0,
  // "º" (U+00BA)
  0x28, 0x42, 0xBE, 0xEB, 0x33, 0x83, 0x2E, 0xFA, 0xAA, 0x04, 0x28, 0x1A, 0xF9, 0x28, 0x17, 0xFC,
  0x28, 0x1E, 0xF3, 0x20, 0x1A, 0x00, 0x1A, 0x02, 0x3A, 0x03, 0x01, 0xA0, 0x23, 0xA8, 0x33, 0x0E,
  0xF3, 0x20, 0x1A, 0x83, 0x10, 0xAF, 0x92, 0x81, 0x6F, 0xC2, 0x83, 0x2E, 0xFA, 0x9A, 0x04, 0x38,
  0x42, 0xBE, 0xEB, 0x42,
  // "»" (U+00BB)
  0x20, 0x15, 0x01, 0x48, 0x15, 0xDB, 0x38, 0x15, 0xDC, 0x40, 0x7A, 0x08, 0x20, 0x6A, 0x09, 0x40,
  0xCA, 0x04, 0x20, 0xBA, 0x05, 0x30, 0x2A, 0x86, 0xE1, 0x01, 0xEF, 0xE2, 0x30, 0x7A, 0x0C, 0x20,
  0x6A, 0x0D, 0x40, 0xCA, 0x08, 0x20, 0xBA, 0x09, 0x30, 0xCA, 0x08, 0x20, 0xBA, 0x09, 0x20, 0x7A,
  0x0C, 0x20, 0x6A, 0x0C, 0x20, 0x2A, 0x86, 0xE1, 0x02, 0xEF, 0xE2, 0x20, 0xCA, 0x04, 0x20, 0xBA,
  0x05, 0x20, 0x7A, 0x08, 0x20, 0x6A, 0x09, 0x38, 0x15, 0xDB, 0x38, 0x14, 0xDC, 0x60, 0x15, 0x01,
  0x40,
  // "¼" (U+00BC)
  0x28, 0x21, 0xBF, 0xC7, 0x10, 0x3A, 0x03, 0x40, 0x20, 0xDA, 0x0C, 0x71, 0x81, 0xBF, 0xB4, 0x84,
  0x4E, 0xFE, 0xFC, 0x70, 0x3A, 0x03, 0x48, 0x4D, 0xFA, 0x8F, 0xC7, 0x81, 0xBF, 0xA5, 0x84, 0x47,
  0x08, 0xFC, 0x60, 0x4A, 0x02, 0x71, 0x81, 0x8F, 0xC6, 0x81, 0xCF, 0xA7, 0x28, 0x18, 0xFC, 0x50,
  0x5A, 0x02, 0x72, 0x81, 0x8F, 0xC5, 0x81, 0xDF, 0x97, 0x38, 0x18, 0xFC, 0x40, 0x5A, 0x01, 0x73,
  0x81, 0x8F, 0xC4, 0x81, 0xDF, 0x83, 0x04, 0xA0, 0x64, 0x81, 0x8F, 0xC3, 0x82, 0x6F, 0xE1, 0x30,
  0xDA, 0x06, 0x48, 0x18, 0xFC, 0x38, 0x1D, 0xF8, 0x38, 0x37, 0xFE, 0xF6, 0x48, 0x18, 0xFC, 0x28,
  0x26, 0xFE, 0x12, 0x84, 0x2F, 0xAD, 0xF6, 0x72, 0x81, 0xEF, 0x73, 0x84, 0xBF, 0x2E, 0xF6, 0x71,
  0x81, 0x7F, 0xE3, 0x85, 0x5F, 0x80, 0xEF, 0x67, 0x82, 0x1E, 0xF7, 0x30, 0x0D, 0x28, 0x1E, 0xF6,
  0x78, 0x18, 0xFD, 0x38, 0x18, 0xF5, 0x28, 0x1E, 0xF6, 0x68, 0x21, 0xEF, 0x63, 0xFA, 0x58, 0x18,
  0xFD, 0x4F, 0xA4, 0x01, 0xA0, 0x57, 0x28, 0x1E, 0xF6, 0x58, 0x19, 0xFD, 0x73, 0x81, 0xEF, 0x64,
  0x02, 0xA0, 0x57, 0x38, 0x1E, 0xF6, 0x10,
  // "½" (U+00BD)
  0x28, 0x21, 0xCF, 0xA7, 0x18, 0x1A, 0xFB, 0x50, 0x20, 0xDA, 0x0A, 0x70, 0x3A, 0x03, 0x40, 0x40,
  0xEB, 0x0A, 0x78, 0x1B, 0xFB, 0x58, 0x4E, 0xFA, 0x9F, 0xA6, 0x03, 0xA0, 0x35, 0x84, 0x58, 0x09,
  0xFA, 0x68, 0x1B, 0xFA, 0x72, 0x81, 0x9F, 0xA5, 0x04, 0xA0, 0x27, 0x28, 0x19, 0xFA, 0x58, 0x1C,
  0xFA, 0x73, 0x81, 0x9F, 0xA4, 0x05, 0xA0, 0x27, 0x38, 0x19, 0xFA, 0x48, 0x1D, 0xF9, 0x74, 0x81,
  0x9F, 0xA3, 0x05, 0xA8, 0x21, 0x06, 0xDA, 0x0C, 0x04, 0x48, 0x19, 0xFA, 0x38, 0x3D, 0xF8, 0x0A,
  0xE0, 0x43, 0x81, 0x9F, 0xA2, 0x89, 0x36, 0xFE, 0x10, 0x4C, 0x40, 0x3E, 0xFA, 0x38, 0x19, 0xFA,
  0x28, 0x1D, 0xF8, 0x78, 0x19, 0xFA, 0x78, 0x26, 0xFE, 0x17, 0x81, 0xCF, 0x87, 0x81, 0xEF, 0x77,
  0x03, 0xA0, 0x16, 0x81, 0x7F, 0xE7, 0x82, 0x1E, 0xF5, 0x68, 0x21, 0xEF, 0x76, 0x82, 0x1D, 0xF8,
  0x78, 0x18, 0xFD, 0x68, 0x21, 0xDF, 0x97, 0x82, 0x1E, 0xF6, 0x58, 0x21, 0xCF, 0x97, 0x18, 0x18,
  0xFD, 0x68, 0x6B, 0xFE, 0x99, 0x99, 0x83, 0x01, 0xA0, 0x56, 0x0E, 0xE0, 0xE3, 0x81, 0x9F, 0xD7,
  0x0E, 0xE0, 0xE0,
  // "¾" (U+00BE)
  0x28, 0x31, 0x68, 0x72, 0x72, 0x81, 0x12, 0x25, 0x05, 0x0E, 0xC0, 0x87, 0x18, 0x1B, 0xFB, 0x40,
  0x1F, 0x03, 0x60, 0x3A, 0x03, 0x58, 0x37, 0x82, 0x04, 0xA0, 0x66, 0x81, 0xBF, 0xA7, 0x48, 0x1D,
  0xF5, 0x50, 0x4A, 0x02, 0x73, 0x81, 0x5F, 0xE6, 0x81, 0xCF, 0xA7, 0x18, 0x44, 0xDE, 0xFC, 0x25,
  0x04, 0xA0, 0x27, 0x10, 0x5B, 0x0D, 0x06, 0x58, 0x1C, 0xF9, 0x74, 0x83, 0x15, 0xEF, 0x53, 0x05,
  0xA0, 0x27, 0x68, 0x18, 0xFB, 0x38, 0x1D, 0xF9, 0x77, 0x81, 0x8F, 0xC2, 0x05, 0xA0, 0x13, 0x81,
  0xBF, 0xE2, 0x87, 0x28, 0x31, 0x04, 0xEF, 0xB2, 0x81, 0xDF, 0x93, 0x05, 0xA0, 0xE2, 0x02, 0xF8,
  0x45, 0x06, 0xFE, 0x12, 0x83, 0x1E, 0xDF, 0xE2, 0x01, 0x0D, 0xD0, 0x72, 0x81, 0xDF, 0x83, 0x83,
  0x9E, 0x7F, 0xE4, 0x83, 0x48, 0x86, 0x22, 0x82, 0x6F, 0xE1, 0x28, 0x43, 0xF7, 0x6F, 0xE7, 0x48,
  0x1E, 0xF8, 0x38, 0x4C, 0xE0, 0x6F, 0xE7, 0x38, 0x27, 0xFE, 0x12, 0x85, 0x6F, 0x60, 0x6F, 0xE7,
  0x38, 0x1E, 0xF7, 0x28, 0x11, 0xED, 0x28, 0x16, 0xFE, 0x72, 0x81, 0x7F, 0xE3, 0x07, 0xF9, 0x07,
  0x68, 0x21, 0xEF, 0x73, 0x08, 0xF9, 0x08, 0x68, 0x18, 0xFE, 0x72, 0x81, 0x6F, 0xE7, 0x82, 0x1E,
  0xF6, 0x72, 0x81, 0x6F, 0xE7, 0x81, 0x8F, 0xD7, 0x38, 0x16, 0xFE, 0x20,
  // "¿" (U+00BF)
  0x48, 0x21, 0xCE, 0x97, 0x06, 0xB0, 0x36, 0x06, 0xB0, 0x36, 0x82, 0x1C, 0xEA, 0x77, 0x77, 0x28,
  0x15, 0x75, 0x71, 0x81, 0xCF, 0xA7, 0x18, 0x1E, 0xF9, 0x70, 0x6A, 0x06, 0x68, 0x33, 0xEF, 0xE1,
  0x50, 0x10, 0xEA, 0x06, 0x60, 0xCA, 0x09, 0x60, 0x8A, 0x0B, 0x70, 0xEA, 0x01, 0x60, 0x3A, 0x0A,
  0x70, 0x5A, 0x08, 0x70, 0x5A, 0x09, 0x70, 0x2A, 0x0E, 0x01, 0x30, 0x30, 0x82, 0x0C, 0xA8, 0x2E,
  0xA9, 0xCA, 0x82, 0x30, 0x2E, 0xF0, 0x62, 0x86, 0x19, 0xDF, 0xEC, 0x82, 0x10,
  // "À" (U+00C0)
  0x30, 0x9A, 0x0D, 0x75, 0x01, 0x0D, 0xA0, 0x67, 0x58, 0x32, 0xEF, 0xE1, 0x75, 0x82, 0x3E, 0xF9,
  0x76, 0x82, 0x3E, 0xF4, 0x80, 0xC7, 0x00, 0x1B, 0x0C, 0x74, 0x05, 0xC0, 0x17, 0x30, 0x9C, 0x05,
  0x73, 0x81, 0xDF, 0xCA, 0x09, 0x72, 0x02, 0xA8, 0x28, 0xCF, 0xE7, 0x20, 0x7A, 0x05, 0x09, 0xA0,
  0x37, 0x10, 0xBA, 0x02, 0x06, 0xA0, 0x77, 0x1A, 0x81, 0xD0, 0x2A, 0x0B, 0x70, 0x4A, 0x0A, 0x20,
  0xDA, 0x70, 0x8A, 0x06, 0x20, 0xAA, 0x04, 0x60, 0xCA, 0x02, 0x20, 0x6A, 0x09, 0x50, 0x1A, 0x0E,
  0x30, 0x2A, 0x0D, 0x50, 0x5A, 0x0A, 0x40, 0xDA, 0x02, 0x40, 0xAF, 0xB0, 0x64, 0x0E, 0xFB, 0x0B,
  0x30, 0x3B, 0x80, 0x2D, 0xA0, 0xE3, 0x07, 0xA0, 0xB6, 0x0E, 0xA0, 0x42, 0x0B, 0xA0, 0x76, 0x0A,
  0xA0, 0x82, 0xB0, 0x36, 0x06, 0xA8, 0x1C, 0x04, 0xA0, 0xE7, 0x02, 0xB0, 0x10, 0x9A, 0x0A, 0x71,
  0x0D, 0xA0, 0x60, 0xDA, 0x05, 0x71, 0x08, 0xA0, 0xA0,
  // "Á" (U+00C1)
  0x71, 0x05, 0xB0, 0x37, 0x40, 0xDA, 0x08, 0x74, 0x06, 0xA0, 0xA7, 0x48, 0x21, 0xEF, 0xB7, 0x58,
  0x1A, 0xFA, 0x80, 0xD0, 0x00, 0x1B, 0x0C, 0x74, 0x05, 0xC0, 0x17, 0x30, 0x9C, 0x05, 0x73, 0x81,
  0xDF, 0xCA, 0x09, 0x72, 0x02, 0xA8, 0x28, 0xCF, 0xE7, 0x20, 0x7A, 0x05, 0x09, 0xA0, 0x37, 0x10,
  0xBA, 0x02, 0x06, 0xA0, 0x77, 0x1A, 0x81, 0xD0, 0x2A, 0x0B, 0x70, 0x4A, 0x0A, 0x20, 0xDA, 0x70,
  0x8A, 0x06, 0x20, 0xAA, 0x04, 0x60, 0xCA, 0x02, 0x20, 0x6A, 0x09, 0x50, 0x1A, 0x0E, 0x30, 0x2A,
  0x0D, 0x50, 0x5A, 0x0A, 0x40, 0xDA, 0x02, 0x40, 0xAF, 0xB0, 0x64, 0x0E, 0xFB, 0x0B, 0x30, 0x3B,
  0x80, 0x2D, 0xA0, 0xE3, 0x07, 0xA0, 0xB6, 0x0E, 0xA0, 0x42, 0x0B, 0xA0, 0x76, 0x0A, 0xA0, 0x82,
  0xB0, 0x36, 0x06, 0xA8, 0x1C, 0x04, 0xA0, 0xE7, 0x02, 0xB0, 0x10, 0x9A, 0x0A, 0x71, 0x0D, 0xA0,
  0x60, 0xDA, 0x05, 0x71, 0x08, 0xA0, 0xA0,
  // "Â" (U+00C2)
  0x50, 0x10, 0xEA, 0x06, 0x74, 0x09, 0xB0, 0xE0, 0x17, 0x20, 0x3A, 0x82, 0x8E, 0xFA, 0x72, 0x86,
  0xDF, 0x80, 0x3E, 0xF5, 0x78, 0x19, 0xF8, 0x38, 0x22, 0xEE, 0x28, 0x0C, 0x40, 0x01, 0xB0, 0xC7,
  0x40, 0x5C, 0x01, 0x73, 0x09, 0xC0, 0x57, 0x38, 0x1D, 0xFC, 0xA0, 0x97, 0x20, 0x2A, 0x82, 0x8C,
  0xFE, 0x72, 0x07, 0xA0, 0x50, 0x9A, 0x03, 0x71, 0x0B, 0xA0, 0x20, 0x6A, 0x07, 0x71, 0xA8, 0x1D,
  0x02, 0xA0, 0xB7, 0x04, 0xA0, 0xA2, 0x0D, 0xA7, 0x08, 0xA0, 0x62, 0x0A, 0xA0, 0x46, 0x0C, 0xA0,
  0x22, 0x06, 0xA0, 0x95, 0x01, 0xA0, 0xE3, 0x02, 0xA0, 0xD5, 0x05, 0xA0, 0xA4, 0x0D, 0xA0, 0x24,
  0x0A, 0xFB, 0x06, 0x40, 0xEF, 0xB0, 0xB3, 0x03, 0xB8, 0x02, 0xDA, 0x0E, 0x30, 0x7A, 0x0B, 0x60,
  0xEA, 0x04, 0x20, 0xBA, 0x07, 0x60, 0xAA, 0x08, 0x2B, 0x03, 0x60, 0x6A, 0x81, 0xC0, 0x4A, 0x0E,
  0x70, 0x2B, 0x01, 0x09, 0xA0, 0xA7, 0x10, 0xDA, 0x06, 0x0D, 0xA0, 0x57, 0x10, 0x8A, 0x0A,
  // "Ã" (U+00C3)
  0x48, 0x35, 0xEE, 0x92, 0x20, 0xD0, 0xE6, 0x02, 0xD8, 0x2A, 0xBF, 0xB6, 0x83, 0x7F, 0xCA, 0xEC,
  0x05, 0x68, 0x7A, 0xF1, 0x01, 0x8D, 0xE8, 0x80, 0xC5, 0x00, 0x1B, 0x0C, 0x74, 0x05, 0xC0, 0x17,
  0x30, 0x9C, 0x05, 0x73, 0x81, 0xDF, 0xCA, 0x09, 0x72, 0x02, 0xA8, 0x28, 0xCF, 0xE7, 0x20, 0x7A,
  0x05, 0x09, 0xA0, 0x37, 0x10, 0xBA, 0x02, 0x06, 0xA0, 0x77, 0x1A, 0x81, 0xD0, 0x2A, 0x0B, 0x70,
  0x4A, 0x0A, 0x20, 0xDA, 0x70, 0x8A, 0x06, 0x20, 0xAA, 0x04, 0x60, 0xCA, 0x02, 0x20, 0x6A, 0x09,
  0x50, 0x1A, 0x0E, 0x30, 0x2A, 0x0D, 0x50, 0x5A, 0x0A, 0x40, 0xDA, 0x02, 0x40, 0xAF, 0xB0, 0x64,
  0x0E, 0xFB, 0x0B, 0x30, 0x3B, 0x80, 0x2D, 0xA0, 0xE3, 0x07, 0xA0, 0xB6, 0x0E, 0xA0, 0x42, 0x0B,
  0xA0, 0x76, 0x0A, 0xA0, 0x82, 0xB0, 0x36, 0x06, 0xA8, 0x1C, 0x04, 0xA0, 0xE7, 0x02, 0xB0, 0x10,
  0x9A, 0x0A, 0x71, 0x0D, 0xA0, 0x60, 0xDA, 0x05, 0x71, 0x08, 0xA0, 0xA0,
  // "Ä" (U+00C4)
  0x48, 0x1A, 0xE7, 0x28, 0x17, 0xEA, 0x71, 0xA0, 0xC2, 0x0C, 0xA0, 0x17, 0x81, 0xAE, 0x72, 0x81,
  0x7E, 0xA8, 0x0C, 0x50, 0x01, 0xB0, 0xC7, 0x40, 0x5C, 0x01, 0x73, 0x09, 0xC0, 0x57, 0x38, 0x1D,
  0xFC, 0xA0, 0x97, 0x20, 0x2A, 0x82, 0x8C, 0xFE, 0x72, 0x07, 0xA0, 0x50, 0x9A, 0x03, 0x71, 0x0B,
  0xA0, 0x20, 0x6A, 0x07, 0x71, 0xA8, 0x1D, 0x02, 0xA0, 0xB7, 0x04, 0xA0, 0xA2, 0x0D, 0xA7, 0x08,
  0xA0, 0x62, 0x0A, 0xA0, 0x46, 0x0C, 0xA0, 0x22, 0x06, 0xA0, 0x95, 0x01, 0xA0, 0xE3, 0x02, 0xA0,
  0xD5, 0x05, 0xA0, 0xA4, 0x0D, 0xA0, 0x24, 0x0A, 0xFB, 0x06, 0x40, 0xEF, 0xB0, 0xB3, 0x03, 0xB8,
  0x02, 0xDA, 0x0E, 0x30, 0x7A, 0x0B, 0x60, 0xEA, 0x04, 0x20, 0xBA, 0x07, 0x60, 0xAA, 0x08, 0x2B,
  0x03, 0x60, 0x6A, 0x81, 0xC0, 0x4A, 0x0E, 0x70, 0x2B, 0x01, 0x09, 0xA0, 0xA7, 0x10, 0xDA, 0x06,
  0x0D, 0xA0, 0x57, 0x10, 0x8A, 0x0A,
  // "Å" (U+00C5)
  0x58, 0x33, 0xAC, 0xA2, 0x73, 0x02, 0xC0, 0xE0, 0x27, 0x28, 0x59, 0xF6, 0x06, 0xF9, 0x72, 0x0B,
  0x93, 0x90, 0xB7, 0x28, 0x5A, 0xF3, 0x04, 0xF9, 0x72, 0x03, 0xA0, 0xDA, 0x03, 0x73, 0x06, 0xC7,
  0x40, 0x5C, 0x01, 0x73, 0x09, 0xC0, 0x57, 0x38, 0x1D, 0xFC, 0xA0, 0x97, 0x20, 0x2A, 0x82, 0x8C,
  0xFE, 0x72, 0x07, 0xA0, 0x50, 0x9A, 0x03, 0x71, 0x0B, 0xA0, 0x20, 0x6A, 0x07, 0x71, 0xA8, 0x1D,
  0x02, 0xA0, 0xB7, 0x04, 0xA0, 0xA2, 0x0D, 0xA7, 0x08, 0xA0, 0x62, 0x0A, 0xA0, 0x46, 0x0C, 0xA0,
  0x22, 0x06, 0xA0, 0x95, 0x01, 0xA0, 0xE3, 0x02, 0xA0, 0xD5, 0x05, 0xA0, 0xA4, 0x0D, 0xA0, 0x24,
  0x0A, 0xFB, 0x06, 0x40, 0xEF, 0xB0, 0xB3, 0x03, 0xB8, 0x02, 0xDA, 0x0E, 0x30, 0x7A, 0x0B, 0x60,
  0xEA, 0x04, 0x20, 0xBA, 0x07, 0x60, 0xAA, 0x08, 0x2B, 0x03, 0x60, 0x6A, 0x81, 0xC0, 0x4A, 0x0E,
  0x70, 0x2B, 0x01, 0x09, 0xA0, 0xA7, 0x10, 0xDA, 0x06, 0x0D, 0xA0, 0x57, 0x10, 0x8A, 0x0A,
  // "Æ" (U+00C6)
  0x70, 0xAF, 0xD6, 0x01, 0xFE, 0x60, 0x6A, 0x0B, 0x0D, 0xA0, 0xB8, 0x02, 0x96, 0x0B, 0xA0, 0x30,
  0x9A, 0x06, 0x74, 0x01, 0xA8, 0x1D, 0x09, 0xA0, 0x67, 0x40, 0x6A, 0x81, 0x80, 0x9A, 0x06, 0x74,
  0x0B, 0xA8, 0x13, 0x09, 0xA0, 0x67, 0x30, 0x1A, 0x0E, 0x20, 0x9A, 0x06, 0x73, 0x06, 0xA0, 0x92,
  0x09, 0xA0, 0x67, 0x30, 0xCA, 0x04, 0x20, 0x9F, 0x90, 0x93, 0x02, 0xA0, 0xE3, 0x09, 0xF9, 0x09,
  0x30, 0x7A, 0x0A, 0x30, 0x9A, 0x0B, 0x80, 0x19, 0x05, 0x30, 0xCA, 0x05, 0x30, 0x9A, 0x06, 0x71,
  0x02, 0xFB, 0x06, 0x71, 0x07, 0xFB, 0x06, 0x71, 0x0D, 0xA8, 0x4A, 0x99, 0x99, 0xDA, 0x06, 0x70,
  0x2B, 0x50, 0x9A, 0x06, 0x70, 0x8A, 0x0A, 0x50, 0x9A, 0x06, 0x70, 0xDA, 0x05, 0x50, 0x9A, 0x06,
  0x60, 0x3B, 0x60, 0x9A, 0x0B, 0x80, 0x29, 0x08, 0xA0, 0xA6, 0x09, 0xFA, 0x0D, 0xA0, 0x56, 0x09,
  0xFA,
  // "Ç" (U+00C7)
  0x58, 0x64, 0xAD, 0xFE, 0xD9, 0x44, 0x01, 0x0B, 0xF9, 0x05, 0x30, 0xCB, 0x84, 0xC9, 0x9D, 0xFE,
  0x30, 0x8A, 0x0E, 0x04, 0x40, 0x50, 0x72, 0x02, 0xB0, 0x57, 0x20, 0x8A, 0x0C, 0x73, 0x0C, 0xA0,
  0x57, 0x20, 0x1B, 0x01, 0x72, 0x03, 0xA0, 0xE7, 0x30, 0x5A, 0x0C, 0x73, 0x06, 0xA0, 0xB7, 0x30,
  0x6A, 0x0B, 0x73, 0x05, 0xA0, 0xC7, 0x30, 0x4A, 0x0E, 0x73, 0x01, 0xB0, 0x17, 0x30, 0xEA, 0x05,
  0x73, 0x09, 0xA0, 0xB7, 0x30, 0x3B, 0x04, 0x73, 0x0A, 0xA0, 0xE0, 0x45, 0x04, 0x30, 0x10, 0xDB,
  0x84, 0xC9, 0xAB, 0xED, 0x40, 0x20, 0xCF, 0x0D, 0x60, 0x60, 0xBA, 0x82, 0xED, 0x94, 0x78, 0x15,
  0xF6, 0x74, 0x82, 0xCF, 0xD6, 0x73, 0x02, 0x08, 0xA0, 0x67, 0x48, 0x1B, 0xFA, 0x73, 0x82, 0x1D,
  0xF9, 0x71, 0x00, 0xDB, 0x03, 0x71, 0x83, 0xCF, 0xEB, 0x34,
  // "È" (U+00C8)
  0x10, 0x9A, 0x0D, 0x70, 0x10, 0xDA, 0x06, 0x78, 0x32, 0xEF, 0xE1, 0x78, 0x23, 0xEF, 0x97, 0x18,
  0x23, 0xEF, 0x47, 0x77, 0x40, 0xAF, 0xA0, 0x20, 0xAF, 0xA0, 0x20, 0xAA, 0x0B, 0x80, 0x29, 0x01,
  0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A,
  0xA0, 0x67, 0x0A, 0xF9, 0x81, 0xB0, 0xAF, 0x98, 0x1B, 0x0A, 0xA0, 0xB8, 0x01, 0x98, 0x16, 0x0A,
  0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0,
  0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0xB8, 0x02, 0x90, 0x10, 0xAF, 0xA0, 0x20, 0xAF, 0xA0, 0x20,
  // "É" (U+00C9)
  0x60, 0x5B, 0x03, 0x60, 0xDA, 0x08, 0x60, 0x6A, 0x0A, 0x68, 0x21, 0xEF, 0xB7, 0x81, 0xAF, 0xA7,
  0x77, 0x50, 0xAF, 0xA0, 0x20, 0xAF, 0xA0, 0x20, 0xAA, 0x0B, 0x80, 0x29, 0x01, 0x0A, 0xA0, 0x67,
  0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A,
  0xF9, 0x81, 0xB0, 0xAF, 0x98, 0x1B, 0x0A, 0xA0, 0xB8, 0x01, 0x98, 0x16, 0x0A, 0xA0, 0x67, 0x0A,
  0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0,
  0x67, 0x0A, 0xA0, 0xB8, 0x02, 0x90, 0x10, 0xAF, 0xA0, 0x20, 0xAF, 0xA0, 0x20,
  // "Ê" (U+00CA)
  0x30, 0x10, 0xEA, 0x06, 0x60, 0x9B, 0x0E, 0x01, 0x40, 0x3A, 0x82, 0x8E, 0xFA, 0x48, 0x6D, 0xF8,
  0x03, 0xEF, 0x52, 0x81, 0x9F, 0x83, 0x82, 0x2E, 0xE2, 0x77, 0x71, 0x0A, 0xFA, 0x02, 0x0A, 0xFA,
  0x02, 0x0A, 0xA0, 0xB8, 0x02, 0x90, 0x10, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70,
  0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAF, 0x98, 0x1B, 0x0A, 0xF9, 0x81, 0xB0,
  0xAA, 0x0B, 0x80, 0x19, 0x81, 0x60, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA,
  0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x0B, 0x80, 0x29, 0x01,
  0x0A, 0xFA, 0x02, 0x0A, 0xFA, 0x02,
  // "Ë" (U+00CB)
  0x18, 0x1A, 0xE7, 0x28, 0x17, 0xEA, 0x3A, 0x0C, 0x20, 0xCA, 0x01, 0x28, 0x1A, 0xE7, 0x28, 0x17,
  0xEA, 0x77, 0x73, 0x0A, 0xFA, 0x02, 0x0A, 0xFA, 0x02, 0x0A, 0xA0, 0xB8, 0x02, 0x90, 0x10, 0xAA,
  0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06,
  0x70, 0xAF, 0x98, 0x1B, 0x0A, 0xF9, 0x81, 0xB0, 0xAA, 0x0B, 0x80, 0x19, 0x81, 0x60, 0xAA, 0x06,
  0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70,
  0xAA, 0x06, 0x70, 0xAA, 0x0B, 0x80, 0x29, 0x01, 0x0A, 0xFA, 0x02, 0x0A, 0xFA, 0x02,
  // "Ì" (U+00CC)
  0x09, 0xA0, 0xD5, 0x01, 0x0D, 0xA0, 0x65, 0x83, 0x2E, 0xFE, 0x15, 0x82, 0x3E, 0xF9, 0x68, 0x23,
  0xEF, 0x47, 0x77, 0xF0, 0x51, 0xF8, 0x35, 0x02, 0x8E, 0xA0, 0xA0, 0x44, 0x0D, 0xA0, 0x35, 0x0D,
  0xA0, 0x35, 0x0D, 0xA0, 0x35, 0x0D, 0xA0, 0x35, 0x0D, 0xA0, 0x35, 0x0D, 0xA0, 0x35, 0x0D, 0xA0,
  0x35, 0x0D, 0xA0, 0x35, 0x0D, 0xA0, 0x35, 0x0D, 0xA0, 0x35, 0x0D, 0xA0, 0x35, 0x0D, 0xA0, 0x35,
  0x0D, 0xA0, 0x35, 0x0D, 0xA0, 0x35, 0x0D, 0xA0, 0x35, 0x0D, 0xA0, 0x34, 0x03, 0x0E, 0xA0, 0x63,
  0x0D, 0xE0, 0x41, 0xF0, 0x50,
  // "Í" (U+00CD)
  0x40, 0x5B, 0x03, 0x40, 0xDA, 0x08, 0x40, 0x6A, 0x0A, 0x48, 0x21, 0xEF, 0xB5, 0x81, 0xAF, 0xA7,
  0x77, 0x1F, 0x05, 0x1F, 0x83, 0x50, 0x28, 0xEA, 0x0A, 0x04, 0x40, 0xDA, 0x03, 0x50, 0xDA, 0x03,
  0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50,
  0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA,
  0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x40, 0x30, 0xEA, 0x06, 0x30, 0xDE,
  0x04, 0x1F, 0x05, 0x10,
  // "Î" (U+00CE)
  0x20, 0x10, 0xEA, 0x06, 0x50, 0x9B, 0x0E, 0x01, 0x30, 0x3A, 0x82, 0x8E, 0xFA, 0x38, 0x92, 0xDF,
  0x80, 0x3E, 0xF5, 0x09, 0xF8, 0x38, 0x22, 0xEE, 0x27, 0x77, 0xF0, 0x52, 0xF0, 0x52, 0x81, 0x28,
  0xEA, 0x0A, 0x04, 0x50, 0xDA, 0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA, 0x03, 0x60,
  0xDA, 0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA,
  0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA, 0x03,
  0x60, 0xDA, 0x03, 0x50, 0x30, 0xEA, 0x06, 0x40, 0xDE, 0x04, 0x2F, 0x05, 0x10,
  // "Ï" (U+00CF)
  0x81, 0xAE, 0x72, 0x81, 0x7E, 0xA1, 0xA0, 0xC2, 0x0C, 0xA8, 0x21, 0xAE, 0x72, 0x81, 0x7E, 0xA7,
  0x75, 0xF0, 0x51, 0xF8, 0x35, 0x02, 0x8E, 0xA0, 0xA0, 0x44, 0x0D, 0xA0, 0x35, 0x0D, 0xA0, 0x35,
  0x0D, 0xA0, 0x35, 0x0D, 0xA0, 0x35, 0x0D, 0xA0, 0x35, 0x0D, 0xA0, 0x35, 0x0D, 0xA0, 0x35, 0x0D,
  0xA0, 0x35, 0x0D, 0xA0, 0x35, 0x0D, 0xA0, 0x35, 0x0D, 0xA0, 0x35, 0x0D, 0xA0, 0x35, 0x0D, 0xA0,
  0x35, 0x0D, 0xA0, 0x35, 0x0D, 0xA0, 0x35, 0x0D, 0xA0, 0x34, 0x03, 0x0E, 0xA0, 0x63, 0x0D, 0xE0,
  0x41, 0xF0, 0x51,
  // "Ð" (U+00D0)
  0x20, 0x9D, 0x82, 0xEC, 0x82, 0x70, 0x9F, 0xA0, 0x86, 0x09, 0xA8, 0x3B, 0x99, 0xAE, 0xB0, 0x95,
  0x09, 0xA0, 0x64, 0x08, 0xB0, 0x64, 0x09, 0xA0, 0x65, 0x08, 0xA0, 0xE4, 0x09, 0xA0, 0x66, 0x0E,
  0xA0, 0x53, 0x09, 0xA0, 0x66, 0x09, 0xA0, 0xA3, 0x09, 0xA0, 0x66, 0x05, 0xA0, 0xD3, 0x09, 0xA0,
  0x66, 0x02, 0xB1, 0x81, 0x39, 0xDA, 0x82, 0xB9, 0x97, 0x30, 0x1B, 0x01, 0x06, 0xF0, 0xC3, 0x01,
  0xB0, 0x10, 0x6F, 0x0C, 0x30, 0x1B, 0x01, 0x20, 0x9A, 0x06, 0x60, 0x1B, 0x30, 0x9A, 0x06, 0x60,
  0x3A, 0x0E, 0x30, 0x9A, 0x06, 0x60, 0x6A, 0x0C, 0x30, 0x9A, 0x06, 0x60, 0xAA, 0x08, 0x30, 0x9A,
  0x06, 0x50, 0x10, 0xEA, 0x03, 0x30, 0x9A, 0x06, 0x50, 0xAA, 0x0D, 0x40, 0x9A, 0x06, 0x30, 0x10,
  0x9B, 0x04, 0x40, 0x9A, 0x82, 0xB9, 0x9B, 0xC0, 0x75, 0x09, 0xF9, 0x0E, 0x06, 0x60, 0x9D, 0x82,
  0xDB, 0x71, 0x50,
  // "Ñ" (U+00D1)
  0x48, 0x35, 0xEE, 0x92, 0x20, 0xD0, 0xE5, 0x02, 0xD8, 0x2A, 0xBF, 0xB5, 0x83, 0x7F, 0xCA, 0xEC,
  0x05, 0x58, 0x7A, 0xF1, 0x01, 0x8D, 0xE8, 0x77, 0x77, 0x50, 0xAB, 0x03, 0x78, 0x2E, 0xFE, 0xAB,
  0x0A, 0x78, 0x2E, 0xFE, 0xAC, 0x02, 0x68, 0x2E, 0xFE, 0xAC, 0x0A, 0x68, 0x2E, 0xFE, 0xAD, 0x02,
  0x58, 0x2E, 0xFE, 0xAA, 0x09, 0xA0, 0x95, 0x82, 0xEF, 0xEA, 0xA0, 0x3B, 0x01, 0x48, 0x2E, 0xFE,
  0xAA, 0x01, 0x0A, 0xA0, 0x84, 0x82, 0xEF, 0xEA, 0xA0, 0x02, 0xA0, 0xE0, 0x13, 0x82, 0xEF, 0xEA,
  0xA8, 0x12, 0x0A, 0xA0, 0x73, 0x82, 0xEF, 0xEA, 0xA8, 0x12, 0x03, 0xA0, 0xE3, 0x82, 0xEF, 0xEA,
  0xA0, 0x22, 0x0B, 0xA0, 0x62, 0x82, 0xEF, 0xEA, 0xA0, 0x22, 0x04, 0xA0, 0xD2, 0x82, 0xEF, 0xEA,
  0xA0, 0x23, 0x0C, 0xA8, 0x45, 0x0E, 0xFE, 0xAA, 0x02, 0x30, 0x4A, 0x84, 0xD0, 0xDF, 0xEA, 0xA0,
  0x24, 0x0C, 0xA8, 0x34, 0xCF, 0xEA, 0xA0, 0x24, 0x05, 0xA8, 0x3C, 0xCF, 0xEA, 0xA0, 0x25, 0x0D,
  0xC0, 0xE0, 0xAA, 0x02, 0x50, 0x6C, 0x0E, 0x0A, 0xA0, 0x26, 0x0D, 0xB0, 0xE0, 0xAA, 0x02, 0x60,
  0x7B, 0x0E, 0x0A, 0xA0, 0x27, 0x0E, 0xA0, 0xE0,
  // "Ò" (U+00D2)
  0x40, 0x9A, 0x0D, 0x76, 0x01, 0x0D, 0xA0, 0x67, 0x68, 0x32, 0xEF, 0xE1, 0x76, 0x82, 0x3E, 0xF9,
  0x77, 0x82, 0x3E, 0xF4, 0x80, 0xD0, 0x08, 0x61, 0x7B, 0xEF, 0xEB, 0x67, 0x10, 0x40, 0xEF, 0x0D,
  0x02, 0x50, 0x30, 0xEB, 0x81, 0xB9, 0xBB, 0x0D, 0x01, 0x40, 0xDA, 0x0C, 0x01, 0x30, 0x20, 0xDA,
  0x0A, 0x30, 0x5A, 0x0E, 0x02, 0x50, 0x2B, 0x02, 0x20, 0xAA, 0x09, 0x70, 0xAA, 0x08, 0x2B, 0x03,
  0x70, 0x5A, 0x81, 0xC0, 0x2B, 0x71, 0x02, 0xB1, 0x04, 0xA0, 0xD7, 0x2B, 0x02, 0x05, 0xA0, 0xC7,
  0x20, 0xEA, 0x03, 0x06, 0xA0, 0xB7, 0x20, 0xDA, 0x04, 0x06, 0xA0, 0xB7, 0x20, 0xDA, 0x04, 0x05,
  0xA0, 0xC7, 0x20, 0xEA, 0x03, 0x04, 0xA0, 0xD7, 0x2B, 0x02, 0x01, 0xB7, 0x10, 0x2B, 0x20, 0xDA,
  0x03, 0x70, 0x5A, 0x0C, 0x20, 0xAA, 0x08, 0x70, 0xAA, 0x08, 0x20, 0x4A, 0x0E, 0x01, 0x50, 0x3B,
  0x02, 0x30, 0xBA, 0x0C, 0x01, 0x30, 0x20, 0xDA, 0x0A, 0x40, 0x20, 0xEB, 0x81, 0xB9, 0xBB, 0x0D,
  0x01, 0x50, 0x30, 0xDF, 0x0D, 0x02, 0x71, 0x85, 0x7B, 0xEF, 0xEB, 0x65,
  // "Ó" (U+00D3)
  0x72, 0x05, 0xB0, 0x37, 0x50, 0xDA, 0x08, 0x75, 0x06, 0xA0, 0xA7, 0x58, 0x21, 0xEF, 0xB7, 0x68,
  0x1A, 0xFA, 0x80, 0xD1, 0x08, 0x61, 0x7B, 0xEF, 0xEB, 0x67, 0x10, 0x40, 0xEF, 0x0D, 0x02, 0x50,
  0x30, 0xEB, 0x81, 0xB9, 0xBB, 0x0D, 0x01, 0x40, 0xDA, 0x0C, 0x01, 0x30, 0x20, 0xDA, 0x0A, 0x30,
  0x5A, 0x0E, 0x02, 0x50, 0x2B, 0x02, 0x20, 0xAA, 0x09, 0x70, 0xAA, 0x08, 0x2B, 0x03, 0x70, 0x5A,
  0x81, 0xC0, 0x2B, 0x71, 0x02, 0xB1, 0x04, 0xA0, 0xD7, 0x2B, 0x02, 0x05, 0xA0, 0xC7, 0x20, 0xEA,
  0x03, 0x06, 0xA0, 0xB7, 0x20, 0xDA, 0x04, 0x06, 0xA0, 0xB7, 0x20, 0xDA, 0x04, 0x05, 0xA0, 0xC7,
  0x20, 0xEA, 0x03, 0x04, 0xA0, 0xD7, 0x2B, 0x02, 0x01, 0xB7, 0x10, 0x2B, 0x20, 0xDA, 0x03, 0x70,
  0x5A, 0x0C, 0x20, 0xAA, 0x08, 0x70, 0xAA, 0x08, 0x20, 0x4A, 0x0E, 0x01, 0x50, 0x3B, 0x02, 0x30,
  0xBA, 0x0C, 0x01, 0x30, 0x20, 0xDA, 0x0A, 0x40, 0x20, 0xEB, 0x81, 0xB9, 0xBB, 0x0D, 0x01, 0x50,
  0x30, 0xDF, 0x0D, 0x02, 0x71, 0x85, 0x7B, 0xEF, 0xEB, 0x65,
  // "Ô" (U+00D4)
  0x60, 0x10, 0xEA, 0x06, 0x75, 0x09, 0xB0, 0xE0, 0x17, 0x30, 0x3A, 0x82, 0x8E, 0xFA, 0x73, 0x86,
  0xDF, 0x80, 0x3E, 0xF5, 0x71, 0x81, 0x9F, 0x83, 0x82, 0x2E, 0xE2, 0x80, 0xC5, 0x08, 0x61, 0x7B,
  0xEF, 0xEB, 0x67, 0x10, 0x40, 0xEF, 0x0D, 0x02, 0x50, 0x30, 0xEB, 0x81, 0xB9, 0xBB, 0x0D, 0x01,
  0x40, 0xDA, 0x0C, 0x01, 0x30, 0x20, 0xDA, 0x0A, 0x30, 0x5A, 0x0E, 0x02, 0x50, 0x2B, 0x02, 0x20,
  0xAA, 0x09, 0x70, 0xAA, 0x08, 0x2B, 0x03, 0x70, 0x5A, 0x81, 0xC0, 0x2B, 0x71, 0x02, 0xB1, 0x04,
  0xA0, 0xD7, 0x2B, 0x02, 0x05, 0xA0, 0xC7, 0x20, 0xEA, 0x03, 0x06, 0xA0, 0xB7, 0x20, 0xDA, 0x04,
  0x06, 0xA0, 0xB7, 0x20, 0xDA, 0x04, 0x05, 0xA0, 0xC7, 0x20, 0xEA, 0x03, 0x04, 0xA0, 0xD7, 0x2B,
  0x02, 0x01, 0xB7, 0x10, 0x2B, 0x20, 0xDA, 0x03, 0x70, 0x5A, 0x0C, 0x20, 0xAA, 0x08, 0x70, 0xAA,
  0x08, 0x20, 0x4A, 0x0E, 0x01, 0x50, 0x3B, 0x02, 0x30, 0xBA, 0x0C, 0x01, 0x30, 0x20, 0xDA, 0x0A,
  0x40, 0x20, 0xEB, 0x81, 0xB9, 0xBB, 0x0D, 0x01, 0x50, 0x30, 0xDF, 0x0D, 0x02, 0x71, 0x85, 0x7B,
  0xEF, 0xEB, 0x65,
  // "Õ" (U+00D5)
  0x48, 0x35, 0xEE, 0x92, 0x20, 0xD0, 0xE7, 0x02, 0xD8, 0x2A, 0xBF, 0xB7, 0x83, 0x7F, 0xCA, 0xEC,
  0x05, 0x78, 0x7A, 0xF1, 0x01, 0x8D, 0xE8, 0x80, 0xC7, 0x08, 0x61, 0x7B, 0xEF, 0xEB, 0x67, 0x10,
  0x40, 0xEF, 0x0D, 0x02, 0x50, 0x30, 0xEB, 0x81, 0xB9, 0xBB, 0x0D, 0x01, 0x40, 0xDA, 0x0C, 0x01,
  0x30, 0x20, 0xDA, 0x0A, 0x30, 0x5A, 0x0E, 0x02, 0x50, 0x2B, 0x02, 0x20, 0xAA, 0x09, 0x70, 0xAA,
  0x08, 0x2B, 0x03, 0x70, 0x5A, 0x81, 0xC0, 0x2B, 0x71, 0x02, 0xB1, 0x04, 0xA0, 0xD7, 0x2B, 0x02,
  0x05, 0xA0, 0xC7, 0x20, 0xEA, 0x03, 0x06, 0xA0, 0xB7, 0x20, 0xDA, 0x04, 0x06, 0xA0, 0xB7, 0x20,
  0xDA, 0x04, 0x05, 0xA0, 0xC7, 0x20, 0xEA, 0x03, 0x04, 0xA0, 0xD7, 0x2B, 0x02, 0x01, 0xB7, 0x10,
  0x2B, 0x20, 0xDA, 0x03, 0x70, 0x5A, 0x0C, 0x20, 0xAA, 0x08, 0x70, 0xAA, 0x08, 0x20, 0x4A, 0x0E,
  0x01, 0x50, 0x3B, 0x02, 0x30, 0xBA, 0x0C, 0x01, 0x30, 0x20, 0xDA, 0x0A, 0x40, 0x20, 0xEB, 0x81,
  0xB9, 0xBB, 0x0D, 0x01, 0x50, 0x30, 0xDF, 0x0D, 0x02, 0x71, 0x85, 0x7B, 0xEF, 0xEB, 0x65,
  // "Ö" (U+00D6)
  0x48, 0x1A, 0xE7, 0x28, 0x17, 0xEA, 0x72, 0xA0, 0xC2, 0x0C, 0xA0, 0x17, 0x18, 0x1A, 0xE7, 0x28,
  0x17, 0xEA, 0x80, 0xC7, 0x08, 0x61, 0x7B, 0xEF, 0xEB, 0x67, 0x10, 0x40, 0xEF, 0x0D, 0x02, 0x50,
  0x30, 0xEB, 0x81, 0xB9, 0xBB, 0x0D, 0x01, 0x40, 0xDA, 0x0C, 0x01, 0x30, 0x20, 0xDA, 0x0A, 0x30,
  0x5A, 0x0E, 0x02, 0x50, 0x2B, 0x02, 0x20, 0xAA, 0x09, 0x70, 0xAA, 0x08, 0x2B, 0x03, 0x70, 0x5A,
  0x81, 0xC0, 0x2B, 0x71, 0x02, 0xB1, 0x04, 0xA0, 0xD7, 0x2B, 0x02, 0x05, 0xA0, 0xC7, 0x20, 0xEA,
  0x03, 0x06, 0xA0, 0xB7, 0x20, 0xDA, 0x04, 0x06, 0xA0, 0xB7, 0x20, 0xDA, 0x04, 0x05, 0xA0, 0xC7,
  0x20, 0xEA, 0x03, 0x04, 0xA0, 0xD7, 0x2B, 0x02, 0x01, 0xB7, 0x10, 0x2B, 0x20, 0xDA, 0x03, 0x70,
  0x5A, 0x0C, 0x20, 0xAA, 0x08, 0x70, 0xAA, 0x08, 0x20, 0x4A, 0x0E, 0x01, 0x50, 0x3B, 0x02, 0x30,
  0xBA, 0x0C, 0x01, 0x30, 0x20, 0xDA, 0x0A, 0x40, 0x20, 0xEB, 0x81, 0xB9, 0xBB, 0x0D, 0x01, 0x50,
  0x30, 0xDF, 0x0D, 0x02, 0x71, 0x85, 0x7B, 0xEF, 0xEB, 0x65,
  // "×" (U+00D7)
  0x10, 0x20, 0x17, 0x84, 0x40, 0x2E, 0xD1, 0x58, 0x28, 0xF8, 0x5A, 0x0D, 0x01, 0x30, 0x8A, 0x81,
  0xB0, 0x6A, 0x82, 0xD1, 0x08, 0xA0, 0xB3, 0x06, 0xA0, 0xD0, 0x9A, 0x0B, 0x50, 0x6C, 0x0B, 0x70,
  0xBB, 0x02, 0x60, 0x8C, 0x0D, 0x01, 0x40, 0x8A, 0x0B, 0x06, 0xA0, 0xD0, 0x12, 0x08, 0xA0, 0xB2,
  0x06, 0xA8, 0x1D, 0x17, 0xA0, 0xB4, 0x06, 0xA8, 0x2C, 0x1D, 0xB6, 0x83, 0x6F, 0x40, 0x17, 0x10,
  0x11,
  // "Ø" (U+00D8)
  0x76, 0x03, 0x08, 0x78, 0x91, 0x7B, 0xEF, 0xEB, 0x50, 0xCF, 0x84, 0x03, 0x0D, 0xF8, 0x2D, 0xFE,
  0x13, 0x03, 0x0E, 0xB8, 0x1B, 0x9B, 0xC0, 0x74, 0x0C, 0xA0, 0xC0, 0x13, 0x03, 0x0E, 0xA0, 0x83,
  0x05, 0xA0, 0xE0, 0x15, 0x0D, 0xB0, 0x22, 0x0A, 0xA0, 0x85, 0x07, 0xC0, 0x82, 0x0E, 0xA0, 0x34,
  0x82, 0x1E, 0xFA, 0xA8, 0x1C, 0x02, 0xB5, 0x82, 0x9F, 0xA2, 0xB1, 0x04, 0xA0, 0xD4, 0x02, 0xA0,
  0x21, 0xB0, 0x20, 0x5A, 0x0B, 0x48, 0x1B, 0xF8, 0x20, 0xDA, 0x04, 0x06, 0xA0, 0xB3, 0x82, 0x4F,
  0xE1, 0x20, 0xCA, 0x04, 0x06, 0xA0, 0xB3, 0x81, 0xCF, 0x63, 0x0C, 0xA0, 0x40, 0x5A, 0x0B, 0x28,
  0x16, 0xFD, 0x40, 0xDA, 0x00, 0x4A, 0x0D, 0x28, 0x1E, 0xF4, 0x40, 0xEA, 0x03, 0x02, 0xB1, 0x81,
  0x8F, 0xB4, 0x01, 0xB2, 0x0E, 0xA0, 0x5A, 0x02, 0x40, 0x5A, 0x0D, 0x20, 0xAC, 0x09, 0x50, 0xAA,
  0x08, 0x20, 0x5B, 0x0E, 0x01, 0x40, 0x2B, 0x03, 0x30, 0xCA, 0x0D, 0x01, 0x30, 0x20, 0xDA, 0x0A,
  0x40, 0x6C, 0x81, 0xA9, 0xBB, 0x0D, 0x01, 0x48, 0x1D, 0xFE, 0xF0, 0xC0, 0x24, 0x89, 0x16, 0xFD,
  0x06, 0xBE, 0xFD, 0xB6, 0x68, 0x14, 0xC5, 0x76,
  // "Ù" (U+00D9)
  0x20, 0x9A, 0x0D, 0x73, 0x01, 0x0D, 0xA0, 0x67, 0x38, 0x32, 0xEF, 0xE1, 0x73, 0x82, 0x3E, 0xF9,
  0x74, 0x82, 0x3E, 0xF4, 0x77, 0x77, 0x50, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05,
  0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60,
  0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36,
  0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03,
  0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0,
  0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0C, 0xA0, 0x46, 0x06, 0xA0, 0x90, 0xAA,
  0x06, 0x60, 0x8A, 0x08, 0x07, 0xA0, 0xB6, 0x0D, 0xA0, 0x40, 0x1B, 0x06, 0x40, 0x8A, 0x0E, 0x20,
  0x8B, 0x82, 0xC9, 0x9D, 0xB0, 0x63, 0x0A, 0xF9, 0x08, 0x58, 0x64, 0xAD, 0xFE, 0xD9, 0x33,
  // "Ú" (U+00DA)
  0x70, 0x5B, 0x03, 0x72, 0x0D, 0xA0, 0x87, 0x20, 0x6A, 0x0A, 0x72, 0x82, 0x1E, 0xFB, 0x73, 0x81,
  0xAF, 0xA7, 0x77, 0x76, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D,
  0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0,
  0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A,
  0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0,
  0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A,
  0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xCA, 0x04, 0x60, 0x6A, 0x09, 0x0A, 0xA0, 0x66, 0x08,
  0xA0, 0x80, 0x7A, 0x0B, 0x60, 0xDA, 0x04, 0x01, 0xB0, 0x64, 0x08, 0xA0, 0xE2, 0x08, 0xB8, 0x2C,
  0x99, 0xDB, 0x06, 0x30, 0xAF, 0x90, 0x85, 0x86, 0x4A, 0xDF, 0xED, 0x93, 0x30,
  // "Û" (U+00DB)
  0x40, 0x10, 0xEA, 0x06, 0x72, 0x09, 0xB0, 0xE0, 0x17, 0x03, 0xA8, 0x28, 0xEF, 0xA7, 0x86, 0xDF,
  0x80, 0x3E, 0xF5, 0x58, 0x19, 0xF8, 0x38, 0x22, 0xEE, 0x27, 0x77, 0x72, 0x0D, 0xA0, 0x36, 0x05,
  0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60,
  0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36,
  0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03,
  0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0,
  0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xCA,
  0x04, 0x60, 0x6A, 0x09, 0x0A, 0xA0, 0x66, 0x08, 0xA0, 0x80, 0x7A, 0x0B, 0x60, 0xDA, 0x04, 0x01,
  0xB0, 0x64, 0x08, 0xA0, 0xE2, 0x08, 0xB8, 0x2C, 0x99, 0xDB, 0x06, 0x30, 0xAF, 0x90, 0x85, 0x86,
  0x4A, 0xDF, 0xED, 0x93, 0x30,
  // "Ü" (U+00DC)
  0x38, 0x1A, 0xE7, 0x28, 0x17, 0xEA, 0x6A, 0x0C, 0x20, 0xCA, 0x01, 0x58, 0x1A, 0xE7, 0x28, 0x17,
  0xEA, 0x77, 0x77, 0x30, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA,
  0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D,
  0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0,
  0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A,
  0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0,
  0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0C, 0xA0, 0x46, 0x06, 0xA0, 0x90, 0xAA, 0x06, 0x60, 0x8A,
  0x08, 0x07, 0xA0, 0xB6, 0x0D, 0xA0, 0x40, 0x1B, 0x06, 0x40, 0x8A, 0x0E, 0x20, 0x8B, 0x82, 0xC9,
  0x9D, 0xB0, 0x63, 0x0A, 0xF9, 0x08, 0x58, 0x64, 0xAD, 0xFE, 0xD9, 0x33,
  // "Ý" (U+00DD)
  0x70, 0x5B, 0x03, 0x72, 0x0D, 0xA0, 0x87, 0x20, 0x6A, 0x0A, 0x72, 0x82, 0x1E, 0xFB, 0x73, 0x81,
  0xAF, 0xA7, 0x77, 0x76, 0x0C, 0xA0, 0x66, 0x06, 0xA0, 0xC0, 0x6A, 0x0C, 0x60, 0xCA, 0x81, 0x50,
  0xEA, 0x03, 0x40, 0x3A, 0x0E, 0x20, 0x9A, 0x09, 0x40, 0x9A, 0x08, 0x20, 0x3A, 0x0E, 0x40, 0xEA,
  0x02, 0x30, 0xCA, 0x05, 0x20, 0x5A, 0x0B, 0x40, 0x6A, 0x0B, 0x20, 0xBA, 0x05, 0x50, 0xEA, 0x02,
  0x01, 0xA0, 0xE6, 0x09, 0xA0, 0x80, 0x7A, 0x08, 0x60, 0x3A, 0x00, 0xDA, 0x02, 0x70, 0xCC, 0x0B,
  0x71, 0x06, 0xC0, 0x57, 0x20, 0xEA, 0x0E, 0x73, 0x09, 0xA0, 0x97, 0x30, 0x8A, 0x08, 0x73, 0x08,
  0xA0, 0x87, 0x30, 0x8A, 0x08, 0x73, 0x08, 0xA0, 0x87, 0x30, 0x8A, 0x08, 0x73, 0x08, 0xA0, 0x87,
  0x30, 0x8A, 0x08, 0x73, 0x08, 0xA0, 0x85,
  // "Þ" (U+00DE)
  0x0A, 0xA0, 0x67, 0x10, 0xAA, 0x06, 0x71, 0x0A, 0xA0, 0x67, 0x10, 0xAA, 0x06, 0x71, 0x0A, 0xD8,
  0x2E, 0xB7, 0x12, 0x0A, 0xF9, 0x82, 0xE3, 0x0A, 0xA8, 0x2B, 0x99, 0xBB, 0x81, 0xE1, 0xAA, 0x06,
  0x30, 0x30, 0xEA, 0x07, 0x0A, 0xA0, 0x64, 0x07, 0xA0, 0xB0, 0xAA, 0x06, 0x40, 0x3A, 0x0D, 0x0A,
  0xA0, 0x64, 0x02, 0xA0, 0xD0, 0xAA, 0x06, 0x40, 0x4A, 0x0C, 0x0A, 0xA0, 0x64, 0x08, 0xA0, 0x90,
  0xAA, 0x06, 0x30, 0x4B, 0x04, 0x0A, 0xA8, 0x2B, 0x99, 0xCB, 0x81, 0xB0, 0xAF, 0x98, 0x2B, 0x10,
  0xAC, 0x82, 0xED, 0xA5, 0x30, 0xAA, 0x06, 0x71, 0x0A, 0xA0, 0x67, 0x10, 0xAA, 0x06, 0x71, 0x0A,
  0xA0, 0x67, 0x10, 0xAA, 0x06, 0x71,
  // "ß" (U+00DF)
  0x28, 0x62, 0x9D, 0xFE, 0xC8, 0x14, 0x05, 0x0E, 0xE0, 0xE0, 0x32, 0x02, 0xB8, 0x2D, 0xAA, 0xEA,
  0x0E, 0x20, 0x8A, 0x0C, 0x30, 0x10, 0xEA, 0x81, 0x40, 0xCA, 0x04, 0x40, 0x9A, 0x81, 0x50, 0xEA,
  0x01, 0x40, 0xAA, 0x81, 0x40, 0xEA, 0x40, 0x2A, 0x0E, 0x20, 0xEA, 0x30, 0x10, 0xDA, 0x03, 0x20,
  0xEA, 0x30, 0xCA, 0x06, 0x30, 0xEA, 0x20, 0x7A, 0x08, 0x40, 0xEA, 0x20, 0xAA, 0x03, 0x40, 0xEA,
  0x20, 0x9A, 0x07, 0x40, 0xEA, 0x20, 0x4B, 0x05, 0x30, 0xEA, 0x30, 0xAB, 0x07, 0x20, 0xEA, 0x40,
  0xAB, 0x81, 0x70, 0xEA, 0x50, 0x9B, 0x03, 0x0E, 0xA6, 0x0A, 0xA0, 0xB0, 0xEA, 0x60, 0x2A, 0x00,
  0xEA, 0x7A, 0x00, 0xEA, 0x10, 0x30, 0x23, 0x05, 0xA0, 0xC0, 0xEA, 0x18, 0x37, 0xFB, 0x9A, 0xB0,
  0x70, 0xEA, 0x10, 0x7E, 0x81, 0xC0, 0xEA, 0x18, 0x52, 0x9D, 0xEF, 0xC7, 0x20,
  // "à" (U+00E0)
  0x20, 0x9A, 0x0D, 0x71, 0x01, 0x0D, 0xA0, 0x67, 0x18, 0x32, 0xEF, 0xE1, 0x71, 0x82, 0x3E, 0xF9,
  0x72, 0x82, 0x3E, 0xF4, 0x77, 0x77, 0x18, 0x62, 0x8C, 0xEF, 0xD9, 0x13, 0x05, 0xF0, 0xD0, 0x12,
  0x01, 0xA8, 0x1B, 0x9A, 0xB0, 0x93, 0x05, 0x01, 0x30, 0x4A, 0x0E, 0x72, 0x0D, 0xA0, 0x17, 0x10,
  0xBA, 0x02, 0x38, 0x43, 0x68, 0x89, 0xDA, 0x82, 0x30, 0x2B, 0xF9, 0x81, 0x31, 0xDF, 0xA0, 0x30,
  0x7B, 0x06, 0x01, 0x20, 0xBA, 0x03, 0x0C, 0xA0, 0x74, 0x0B, 0xA0, 0x30, 0xDA, 0x02, 0x40, 0xDA,
  0x03, 0x0D, 0xA0, 0x23, 0x02, 0xB0, 0x30, 0xBA, 0x07, 0x30, 0xBB, 0x03, 0x06, 0xB8, 0x3B, 0x9D,
  0xFA, 0xA8, 0x13, 0x0C, 0xD0, 0x80, 0x3A, 0x89, 0x03, 0x01, 0x9E, 0xEC, 0x60, 0x1A, 0x03,
  // "á" (U+00E1)
  0x60, 0x5B, 0x03, 0x70, 0xDA, 0x08, 0x70, 0x6A, 0x0A, 0x78, 0x21, 0xEF, 0xB7, 0x18, 0x1A, 0xFA,
  0x77, 0x77, 0x38, 0x62, 0x8C, 0xEF, 0xD9, 0x13, 0x05, 0xF0, 0xD0, 0x12, 0x01, 0xA8, 0x1B, 0x9A,
  0xB0, 0x93, 0x05, 0x01, 0x30, 0x4A, 0x0E, 0x72, 0x0D, 0xA0, 0x17, 0x10, 0xBA, 0x02, 0x38, 0x43,
  0x68, 0x89, 0xDA, 0x82, 0x30, 0x2B, 0xF9, 0x81, 0x31, 0xDF, 0xA0, 0x30, 0x7B, 0x06, 0x01, 0x20,
  0xBA, 0x03, 0x0C, 0xA0, 0x74, 0x0B, 0xA0, 0x30, 0xDA, 0x02, 0x40, 0xDA, 0x03, 0x0D, 0xA0, 0x23,
  0x02, 0xB0, 0x30, 0xBA, 0x07, 0x30, 0xBB, 0x03, 0x06, 0xB8, 0x3B, 0x9D, 0xFA, 0xA8, 0x13, 0x0C,
  0xD0, 0x80, 0x3A, 0x89, 0x03, 0x01, 0x9E, 0xEC, 0x60, 0x1A, 0x03,
  // "â" (U+00E2)
  0x40, 0x10, 0xEA, 0x06, 0x70, 0x9B, 0x0E, 0x01, 0x50, 0x3A, 0x82, 0x8E, 0xFA, 0x58, 0x6D, 0xF8,
  0x03, 0xEF, 0x53, 0x81, 0x9F, 0x83, 0x82, 0x2E, 0xE2, 0x77, 0x75, 0x86, 0x28, 0xCE, 0xFD, 0x91,
  0x30, 0x5F, 0x0D, 0x01, 0x20, 0x1A, 0x81, 0xB9, 0xAB, 0x09, 0x30, 0x50, 0x13, 0x04, 0xA0, 0xE7,
  0x20, 0xDA, 0x01, 0x71, 0x0B, 0xA0, 0x23, 0x84, 0x36, 0x88, 0x9D, 0xA8, 0x23, 0x02, 0xBF, 0x98,
  0x13, 0x1D, 0xFA, 0x03, 0x07, 0xB0, 0x60, 0x12, 0x0B, 0xA0, 0x30, 0xCA, 0x07, 0x40, 0xBA, 0x03,
  0x0D, 0xA0, 0x24, 0x0D, 0xA0, 0x30, 0xDA, 0x02, 0x30, 0x2B, 0x03, 0x0B, 0xA0, 0x73, 0x0B, 0xB0,
  0x30, 0x6B, 0x83, 0xB9, 0xDF, 0xAA, 0x81, 0x30, 0xCD, 0x08, 0x03, 0xA8, 0x90, 0x30, 0x19, 0xEE,
  0xC6, 0x01, 0xA0, 0x30,
  // "ã" (U+00E3)
  0x28, 0x35, 0xEE, 0x92, 0x20, 0xD0, 0xE2, 0x02, 0xD8, 0x2A, 0xBF, 0xB2, 0x83, 0x7F, 0xCA, 0xEC,
  0x05, 0x28, 0x7A, 0xF1, 0x01, 0x8D, 0xE8, 0x77, 0x77, 0x86, 0x28, 0xCE, 0xFD, 0x91, 0x30, 0x5F,
  0x0D, 0x01, 0x20, 0x1A, 0x81, 0xB9, 0xAB, 0x09, 0x30, 0x50, 0x13, 0x04, 0xA0, 0xE7, 0x20, 0xDA,
  0x01, 0x71, 0x0B, 0xA0, 0x23, 0x84, 0x36, 0x88, 0x9D, 0xA8, 0x23, 0x02, 0xBF, 0x98, 0x13, 0x1D,
  0xFA, 0x03, 0x07, 0xB0, 0x60, 0x12, 0x0B, 0xA0, 0x30, 0xCA, 0x07, 0x40, 0xBA, 0x03, 0x0D, 0xA0,
  0x24, 0x0D, 0xA0, 0x30, 0xDA, 0x02, 0x30, 0x2B, 0x03, 0x0B, 0xA0, 0x73, 0x0B, 0xB0, 0x30, 0x6B,
  0x83, 0xB9, 0xDF, 0xAA, 0x81, 0x30, 0xCD, 0x08, 0x03, 0xA8, 0x90, 0x30, 0x19, 0xEE, 0xC6, 0x01,
  0xA0, 0x30,
  // "ä" (U+00E4)
  0x28, 0x1A, 0xE7, 0x28, 0x17, 0xEA, 0x4A, 0x0C, 0x20, 0xCA, 0x01, 0x38, 0x1A, 0xE7, 0x28, 0x17,
  0xEA, 0x77, 0x77, 0x86, 0x28, 0xCE, 0xFD, 0x91, 0x30, 0x5F, 0x0D, 0x01, 0x20, 0x1A, 0x81, 0xB9,
  0xAB, 0x09, 0x30, 0x50, 0x13, 0x04, 0xA0, 0xE7, 0x20, 0xDA, 0x01, 0x71, 0x0B, 0xA0, 0x23, 0x84,
  0x36, 0x88, 0x9D, 0xA8, 0x23, 0x02, 0xBF, 0x98, 0x13, 0x1D, 0xFA, 0x03, 0x07, 0xB0, 0x60, 0x12,
  0x0B, 0xA0, 0x30, 0xCA, 0x07, 0x40, 0xBA, 0x03, 0x0D, 0xA0, 0x24, 0x0D, 0xA0, 0x30, 0xDA, 0x02,
  0x30, 0x2B, 0x03, 0x0B, 0xA0, 0x73, 0x0B, 0xB0, 0x30, 0x6B, 0x83, 0xB9, 0xDF, 0xAA, 0x81, 0x30,
  0xCD, 0x08, 0x03, 0xA8, 0x90, 0x30, 0x19, 0xEE, 0xC6, 0x01, 0xA0, 0x30,
  // "å" (U+00E5)
  0x48, 0x33, 0xAC, 0xA2, 0x60, 0x2C, 0x0E, 0x02, 0x58, 0x59, 0xF6, 0x06, 0xF9, 0x50, 0xB9, 0x39,
  0x0B, 0x58, 0x5A, 0xF3, 0x04, 0xF9, 0x50, 0x3A, 0x0D, 0xA0, 0x36, 0x83, 0x5C, 0xEC, 0x47, 0x77,
  0x71, 0x86, 0x28, 0xCE, 0xFD, 0x91, 0x30, 0x5F, 0x0D, 0x01, 0x20, 0x1A, 0x81, 0xB9, 0xAB, 0x09,
  0x30, 0x50, 0x13, 0x04, 0xA0, 0xE7, 0x20, 0xDA, 0x01, 0x71, 0x0B, 0xA0, 0x23, 0x84, 0x36, 0x88,
  0x9D, 0xA8, 0x23, 0x02, 0xBF, 0x98, 0x13, 0x1D, 0xFA, 0x03, 0x07, 0xB0, 0x60, 0x12, 0x0B, 0xA0,
  0x30, 0xCA, 0x07, 0x40, 0xBA, 0x03, 0x0D, 0xA0, 0x24, 0x0D, 0xA0, 0x30, 0xDA, 0x02, 0x30, 0x2B,
  0x03, 0x0B, 0xA0, 0x73, 0x0B, 0xB0, 0x30, 0x6B, 0x83, 0xB9, 0xDF, 0xAA, 0x81, 0x30, 0xCD, 0x08,
  0x03, 0xA8, 0x90, 0x30, 0x19, 0xEE, 0xC6, 0x01, 0xA0, 0x30,
  // "æ" (U+00E6)
  0x28, 0x52, 0x9D, 0xEE, 0xB5, 0x28, 0x44, 0xBE, 0xEB, 0x54, 0x06, 0xF0, 0x06, 0xE0, 0x93, 0x03,
  0xA8, 0x1B, 0x9B, 0xA0, 0xEA, 0x82, 0xEA, 0x9E, 0xA0, 0x63, 0x05, 0x01, 0x30, 0x6B, 0x0E, 0x02,
  0x28, 0x22, 0xEF, 0xD7, 0x20, 0xEA, 0x07, 0x40, 0x9A, 0x03, 0x71, 0x0D, 0xA0, 0x34, 0x05, 0xA0,
  0x63, 0x84, 0x36, 0x88, 0x9E, 0xA8, 0x01, 0x90, 0xAA, 0x82, 0x70, 0x2C, 0xFF, 0xA8, 0x18, 0x1D,
  0xFF, 0xB0, 0x80, 0x7A, 0x81, 0xE7, 0x22, 0x0D, 0xA0, 0x17, 0x10, 0xCA, 0x07, 0x40, 0xDA, 0x02,
  0x71, 0x0D, 0xA0, 0x24, 0xB0, 0x57, 0x10, 0xDA, 0x02, 0x30, 0x3B, 0x0B, 0x71, 0x0B, 0xA0, 0x73,
  0x81, 0xCF, 0xEA, 0x07, 0x48, 0x21, 0x60, 0x6B, 0x84, 0xB9, 0xDF, 0xB3, 0xB8, 0x4C, 0x99, 0xCF,
  0xD2, 0x0C, 0xD8, 0x2C, 0x10, 0x5F, 0x0D, 0x28, 0x51, 0x9E, 0xFD, 0x81, 0x38, 0x62, 0x9D, 0xFE,
  0xC8, 0x11,
  // "ç" (U+00E7)
  0x38, 0x52, 0x9D, 0xFD, 0xB6, 0x30, 0x5F, 0x81, 0x10, 0x3B, 0x83, 0xD9, 0xAE, 0xA2, 0x0B, 0xA0,
  0x94, 0x81, 0x10, 0x1A, 0x0E, 0x70, 0x5A, 0x0A, 0x70, 0x8A, 0x07, 0x70, 0x9A, 0x05, 0x70, 0xAA,
  0x05, 0x70, 0xAA, 0x05, 0x70, 0x9A, 0x07, 0x70, 0x6A, 0x0A, 0x70, 0x3A, 0x0E, 0x71, 0x0D, 0xA0,
  0x94, 0x04, 0x20, 0x5B, 0x82, 0xC9, 0xAD, 0x93, 0x08, 0xF4, 0x04, 0x0B, 0xA8, 0x1D, 0xA4, 0x58,
  0x15, 0xF6, 0x71, 0x82, 0xCF, 0xD6, 0x70, 0x20, 0x8A, 0x06, 0x71, 0x81, 0xBF, 0xA7, 0x82, 0x1D,
  0xF9, 0x50, 0x0D, 0xB0, 0x35, 0x83, 0xCF, 0xEB, 0x33,
  // "è" (U+00E8)
  0x20, 0x9A, 0x0D, 0x71, 0x01, 0x0D, 0xA0, 0x67, 0x18, 0x32, 0xEF, 0xE1, 0x71, 0x82, 0x3E, 0xF9,
  0x72, 0x82, 0x3E, 0xF4, 0x77, 0x77, 0x28, 0x54, 0xAE, 0xEC, 0x71, 0x40, 0x7E, 0x0D, 0x01, 0x20,
  0x4B, 0x81, 0xB9, 0xDA, 0x0B, 0x20, 0xCA, 0x05, 0x30, 0xBA, 0x04, 0x02, 0xA0, 0xB4, 0x03, 0xA0,
  0x80, 0x6A, 0x07, 0x5A, 0x0C, 0x08, 0xA0, 0xB8, 0x01, 0x98, 0x2E, 0xFD, 0x9F, 0xB0, 0xE0, 0xAF,
  0xB0, 0xE0, 0x9A, 0x05, 0x71, 0x08, 0xA0, 0x67, 0x10, 0x5A, 0x09, 0x71, 0x01, 0xA0, 0xE7, 0x20,
  0xBA, 0x0A, 0x58, 0x25, 0x20, 0x2B, 0x85, 0xE9, 0x9A, 0xEF, 0x32, 0x05, 0xF9, 0x03, 0x38, 0x12,
  0x9D, 0xA8, 0x1D, 0x94, 0x10,
  // "é" (U+00E9)
  0x60, 0x5B, 0x03, 0x70, 0xDA, 0x08, 0x70, 0x6A, 0x0A, 0x78, 0x21, 0xEF, 0xB7, 0x18, 0x1A, 0xFA,
  0x77, 0x77, 0x48, 0x54, 0xAE, 0xEC, 0x71, 0x40, 0x7E, 0x0D, 0x01, 0x20, 0x4B, 0x81, 0xB9, 0xDA,
  0x0B, 0x20, 0xCA, 0x05, 0x30, 0xBA, 0x04, 0x02, 0xA0, 0xB4, 0x03, 0xA0, 0x80, 0x6A, 0x07, 0x5A,
  0x0C, 0x08, 0xA0, 0xB8, 0x01, 0x98, 0x2E, 0xFD, 0x9F, 0xB0, 0xE0, 0xAF, 0xB0, 0xE0, 0x9A, 0x05,
  0x71, 0x08, 0xA0, 0x67, 0x10, 0x5A, 0x09, 0x71, 0x01, 0xA0, 0xE7, 0x20, 0xBA, 0x0A, 0x58, 0x25,
  0x20, 0x2B, 0x85, 0xE9, 0x9A, 0xEF, 0x32, 0x05, 0xF9, 0x03, 0x38, 0x12, 0x9D, 0xA8, 0x1D, 0x94,
  0x10,
  // "ê" (U+00EA)
  0x30, 0x10, 0xEA, 0x06, 0x70, 0x9B, 0x0E, 0x01, 0x50, 0x3A, 0x82, 0x8E, 0xFA, 0x58, 0x6D, 0xF8,
  0x03, 0xEF, 0x53, 0x81, 0x9F, 0x83, 0x82, 0x2E, 0xE2, 0x77, 0x77, 0x85, 0x4A, 0xEE, 0xC7, 0x14,
  0x07, 0xE0, 0xD0, 0x12, 0x04, 0xB8, 0x1B, 0x9D, 0xA0, 0xB2, 0x0C, 0xA0, 0x53, 0x0B, 0xA0, 0x40,
  0x2A, 0x0B, 0x40, 0x3A, 0x08, 0x06, 0xA0, 0x75, 0xA0, 0xC0, 0x8A, 0x0B, 0x80, 0x19, 0x82, 0xEF,
  0xD9, 0xFB, 0x0E, 0x0A, 0xFB, 0x0E, 0x09, 0xA0, 0x57, 0x10, 0x8A, 0x06, 0x71, 0x05, 0xA0, 0x97,
  0x10, 0x1A, 0x0E, 0x72, 0x0B, 0xA0, 0xA5, 0x82, 0x52, 0x02, 0xB8, 0x5E, 0x99, 0xAE, 0xF3, 0x20,
  0x5F, 0x90, 0x33, 0x81, 0x29, 0xDA, 0x81, 0xD9, 0x41,
  // "ë" (U+00EB)
  0x28, 0x1A, 0xE7, 0x28, 0x17, 0xEA, 0x4A, 0x0C, 0x20, 0xCA, 0x01, 0x38, 0x1A, 0xE7, 0x28, 0x17,
  0xEA, 0x77, 0x77, 0x18, 0x54, 0xAE, 0xEC, 0x71, 0x40, 0x7E, 0x0D, 0x01, 0x20, 0x4B, 0x81, 0xB9,
  0xDA, 0x0B, 0x20, 0xCA, 0x05, 0x30, 0xBA, 0x04, 0x02, 0xA0, 0xB4, 0x03, 0xA0, 0x80, 0x6A, 0x07,
  0x5A, 0x0C, 0x08, 0xA0, 0xB8, 0x01, 0x98, 0x2E, 0xFD, 0x9F, 0xB0, 0xE0, 0xAF, 0xB0, 0xE0, 0x9A,
  0x05, 0x71, 0x08, 0xA0, 0x67, 0x10, 0x5A, 0x09, 0x71, 0x01, 0xA0, 0xE7, 0x20, 0xBA, 0x0A, 0x58,
  0x25, 0x20, 0x2B, 0x85, 0xE9, 0x9A, 0xEF, 0x32, 0x05, 0xF9, 0x03, 0x38, 0x12, 0x9D, 0xA8, 0x1D,
  0x94, 0x10,
  // "ì" (U+00EC)
  0x09, 0xA0, 0xD3, 0x01, 0x0D, 0xA0, 0x63, 0x83, 0x2E, 0xFE, 0x13, 0x82, 0x3E, 0xF9, 0x48, 0x23,
  0xEF, 0x47, 0x73, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E,
  0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E,
  0xA4, 0x0E, 0xA4, 0x0E, 0xA1,
  // "í" (U+00ED)
  0x20, 0x5B, 0x03, 0x20, 0xDA, 0x08, 0x20, 0x6A, 0x0A, 0x28, 0x21, 0xEF, 0xB3, 0x81, 0xAF, 0xA7,
  0x74, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E,
  0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E, 0xA4, 0x0E,
  0xA4, 0x0E, 0xA4,
  // "î" (U+00EE)
  0x20, 0x10, 0xEA, 0x06, 0x50, 0x9B, 0x0E, 0x01, 0x30, 0x3A, 0x82, 0x8E, 0xFA, 0x38, 0x92, 0xDF,
  0x80, 0x3E, 0xF5, 0x09, 0xF8, 0x38, 0x22, 0xEE, 0x27, 0x77, 0x20, 0xEA, 0x70, 0xEA, 0x70, 0xEA,
  0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA,
  0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x40,
  // "ï" (U+00EF)
  0x81, 0xAE, 0x72, 0x81, 0x7E, 0xA1, 0xA0, 0xC2, 0x0C, 0xA8, 0x21, 0xAE, 0x72, 0x81, 0x7E, 0xA7,
  0x77, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E,
  0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E,
  0xA6, 0x0E, 0xA4,
  // "ð" (U+00F0)
  0x40, 0x80, 0x33, 0x08, 0x02, 0x50, 0x6A, 0x83, 0x83, 0xDF, 0xC5, 0x02, 0x0D, 0xC0, 0xD0, 0x36,
  0x03, 0xB0, 0xD7, 0x06, 0x0E, 0xC0, 0x76, 0x83, 0xDF, 0xA2, 0xEA, 0x03, 0x50, 0x30, 0x42, 0x04,
  0xA0, 0xB7, 0x30, 0xAA, 0x03, 0x72, 0x03, 0xA0, 0xA4, 0x85, 0x5B, 0xEE, 0xC4, 0xDA, 0x30, 0x9E,
  0x0E, 0xA8, 0x14, 0x06, 0xB8, 0x1C, 0x9B, 0xC8, 0x17, 0x0E, 0xA0, 0x63, 0x05, 0xB0, 0x90, 0x4A,
  0x0C, 0x50, 0xBA, 0x0B, 0x08, 0xA0, 0x75, 0x06, 0xA0, 0xC0, 0x9A, 0x05, 0x50, 0x3A, 0x0C, 0x0A,
  0xA0, 0x55, 0x02, 0xA0, 0xB0, 0x9A, 0x06, 0x50, 0x3A, 0x0A, 0x07, 0xA0, 0x85, 0x05, 0xA0, 0x80,
  0x3A, 0x0D, 0x50, 0xAA, 0x81, 0x40, 0xCA, 0x06, 0x30, 0x4A, 0x0D, 0x20, 0x4B, 0x81, 0xC9, 0xBB,
  0x05, 0x30, 0x6F, 0x08, 0x58, 0x52, 0x9D, 0xFE, 0xA4, 0x30,
  // "ñ" (U+00F1)
  0x28, 0x35, 0xEE, 0x92, 0x20, 0xD0, 0xE2, 0x02, 0xD8, 0x2A, 0xBF, 0xB2, 0x83, 0x7F, 0xCA, 0xEC,
  0x05, 0x28, 0x7A, 0xF1, 0x01, 0x8D, 0xE8, 0x77, 0x75, 0x89, 0x0E, 0xF7, 0x04, 0xBE, 0xEB, 0x42,
  0x82, 0xEF, 0x95, 0xE8, 0x90, 0x50, 0xEF, 0xDE, 0xEA, 0xAE, 0xA8, 0x1E, 0x0E, 0xA0, 0xE0, 0x22,
  0x02, 0x0E, 0xA0, 0x40, 0xEA, 0x08, 0x40, 0xAA, 0x06, 0x0E, 0xA0, 0x44, 0x07, 0xA0, 0x70, 0xEA,
  0x01, 0x40, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06,
  0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E,
  0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A,
  0x08,
  // "ò" (U+00F2)
  0x20, 0x9A, 0x0D, 0x72, 0x01, 0x0D, 0xA0, 0x67, 0x28, 0x32, 0xEF, 0xE1, 0x72, 0x82, 0x3E, 0xF9,
  0x73, 0x82, 0x3E, 0xF4, 0x77, 0x77, 0x58, 0x53, 0xAD, 0xFE, 0xA3, 0x50, 0x6F, 0x06, 0x30, 0x4B,
  0x81, 0xC9, 0xBB, 0x04, 0x20, 0xCA, 0x08, 0x30, 0x6A, 0x81, 0xD0, 0x2A, 0x0E, 0x50, 0xCA, 0x03,
  0x06, 0xA0, 0x95, 0x08, 0xA0, 0x70, 0x8A, 0x07, 0x50, 0x5A, 0x0A, 0x09, 0xA0, 0x55, 0x04, 0xA0,
  0xB0, 0xAA, 0x05, 0x50, 0x3A, 0x0C, 0x09, 0xA0, 0x55, 0x04, 0xA0, 0xB0, 0x8A, 0x07, 0x50, 0x5A,
  0x0A, 0x05, 0xA0, 0x95, 0x08, 0xA0, 0x70, 0x1A, 0x0E, 0x50, 0xCA, 0x81, 0x30, 0xAA, 0x08, 0x30,
  0x6A, 0x0C, 0x20, 0x2B, 0x81, 0xC9, 0xBB, 0x04, 0x30, 0x4F, 0x06, 0x58, 0x52, 0xAE, 0xFE, 0xA3,
  0x30,
  // "ó" (U+00F3)
  0x70, 0x5B, 0x03, 0x71, 0x0D, 0xA0, 0x87, 0x10, 0x6A, 0x0A, 0x71, 0x82, 0x1E, 0xFB, 0x72, 0x81,
  0xAF, 0xA7, 0x77, 0x76, 0x85, 0x3A, 0xDF, 0xEA, 0x35, 0x06, 0xF0, 0x63, 0x04, 0xB8, 0x1C, 0x9B,
  0xB0, 0x42, 0x0C, 0xA0, 0x83, 0x06, 0xA8, 0x1D, 0x02, 0xA0, 0xE5, 0x0C, 0xA0, 0x30, 0x6A, 0x09,
  0x50, 0x8A, 0x07, 0x08, 0xA0, 0x75, 0x05, 0xA0, 0xA0, 0x9A, 0x05, 0x50, 0x4A, 0x0B, 0x0A, 0xA0,
  0x55, 0x03, 0xA0, 0xC0, 0x9A, 0x05, 0x50, 0x4A, 0x0B, 0x08, 0xA0, 0x75, 0x05, 0xA0, 0xA0, 0x5A,
  0x09, 0x50, 0x8A, 0x07, 0x01, 0xA0, 0xE5, 0x0C, 0xA8, 0x13, 0x0A, 0xA0, 0x83, 0x06, 0xA0, 0xC2,
  0x02, 0xB8, 0x1C, 0x9B, 0xB0, 0x43, 0x04, 0xF0, 0x65, 0x85, 0x2A, 0xEF, 0xEA, 0x33,
  // "ô" (U+00F4)
  0x40, 0x10, 0xEA, 0x06, 0x71, 0x09, 0xB0, 0xE0, 0x16, 0x03, 0xA8, 0x28, 0xEF, 0xA6, 0x86, 0xDF,
  0x80, 0x3E, 0xF5, 0x48, 0x19, 0xF8, 0x38, 0x22, 0xEE, 0x27, 0x77, 0x72, 0x85, 0x3A, 0xDF, 0xEA,
  0x35, 0x06, 0xF0, 0x63, 0x04, 0xB8, 0x1C, 0x9B, 0xB0, 0x42, 0x0C, 0xA0, 0x83, 0x06, 0xA8, 0x1D,
  0x02, 0xA0, 0xE5, 0x0C, 0xA0, 0x30, 0x6A, 0x09, 0x50, 0x8A, 0x07, 0x08, 0xA0, 0x75, 0x05, 0xA0,
  0xA0, 0x9A, 0x05, 0x50, 0x4A, 0x0B, 0x0A, 0xA0, 0x55, 0x03, 0xA0, 0xC0, 0x9A, 0x05, 0x50, 0x4A,
  0x0B, 0x08, 0xA0, 0x75, 0x05, 0xA0, 0xA0, 0x5A, 0x09, 0x50, 0x8A, 0x07, 0x01, 0xA0, 0xE5, 0x0C,
  0xA8, 0x13, 0x0A, 0xA0, 0x83, 0x06, 0xA0, 0xC2, 0x02, 0xB8, 0x1C, 0x9B, 0xB0, 0x43, 0x04, 0xF0,
  0x65, 0x85, 0x2A, 0xEF, 0xEA, 0x33,
  // "õ" (U+00F5)
  0x28, 0x35, 0xEE, 0x92, 0x20, 0xD0, 0xE3, 0x02, 0xD8, 0x2A, 0xBF, 0xB3, 0x83, 0x7F, 0xCA, 0xEC,
  0x05, 0x38, 0x7A, 0xF1, 0x01, 0x8D, 0xE8, 0x77, 0x77, 0x48, 0x53, 0xAD, 0xFE, 0xA3, 0x50, 0x6F,
  0x06, 0x30, 0x4B, 0x81, 0xC9, 0xBB, 0x04, 0x20, 0xCA, 0x08, 0x30, 0x6A, 0x81, 0xD0, 0x2A, 0x0E,
  0x50, 0xCA, 0x03, 0x06, 0xA0, 0x95, 0x08, 0xA0, 0x70, 0x8A, 0x07, 0x50, 0x5A, 0x0A, 0x09, 0xA0,
  0x55, 0x04, 0xA0, 0xB0, 0xAA, 0x05, 0x50, 0x3A, 0x0C, 0x09, 0xA0, 0x55, 0x04, 0xA0, 0xB0, 0x8A,
  0x07, 0x50, 0x5A, 0x0A, 0x05, 0xA0, 0x95, 0x08, 0xA0, 0x70, 0x1A, 0x0E, 0x50, 0xCA, 0x81, 0x30,
  0xAA, 0x08, 0x30, 0x6A, 0x0C, 0x20, 0x2B, 0x81, 0xC9, 0xBB, 0x04, 0x30, 0x4F, 0x06, 0x58, 0x52,
  0xAE, 0xFE, 0xA3, 0x30,
  // "ö" (U+00F6)
  0x38, 0x1A, 0xE7, 0x28, 0x17, 0xEA, 0x5A, 0x0C, 0x20, 0xCA, 0x01, 0x48, 0x1A, 0xE7, 0x28, 0x17,
  0xEA, 0x77, 0x77, 0x38, 0x53, 0xAD, 0xFE, 0xA3, 0x50, 0x6F, 0x06, 0x30, 0x4B, 0x81, 0xC9, 0xBB,
  0x04, 0x20, 0xCA, 0x08, 0x30, 0x6A, 0x81, 0xD0, 0x2A, 0x0E, 0x50, 0xCA, 0x03, 0x06, 0xA0, 0x95,
  0x08, 0xA0, 0x70, 0x8A, 0x07, 0x50, 0x5A, 0x0A, 0x09, 0xA0, 0x55, 0x04, 0xA0, 0xB0, 0xAA, 0x05,
  0x50, 0x3A, 0x0C, 0x09, 0xA0, 0x55, 0x04, 0xA0, 0xB0, 0x8A, 0x07, 0x50, 0x5A, 0x0A, 0x05, 0xA0,
  0x95, 0x08, 0xA0, 0x70, 0x1A, 0x0E, 0x50, 0xCA, 0x81, 0x30, 0xAA, 0x08, 0x30, 0x6A, 0x0C, 0x20,
  0x2B, 0x81, 0xC9, 0xBB, 0x04, 0x30, 0x4F, 0x06, 0x58, 0x52, 0xAE, 0xFE, 0xA3, 0x30,
  // "÷" (U+00F7)
  0x48, 0x21, 0xCE, 0x57, 0x20, 0x6A, 0x0C, 0x72, 0x06, 0xA0, 0xC7, 0x28, 0x21, 0xCE, 0x57, 0x77,
  0x73, 0x0E, 0xFC, 0x04, 0x0E, 0xFC, 0x04, 0x08, 0x80, 0x79, 0x02, 0x77, 0x77, 0x28, 0x21, 0xCE,
  0x57, 0x20, 0x6A, 0x0C, 0x72, 0x06, 0xA0, 0xC7, 0x28, 0x21, 0xCE, 0x55,
  // "ø" (U+00F8)
  0x73, 0x81, 0x88, 0x13, 0x89, 0x03, 0xAD, 0xFD, 0x93, 0xEF, 0x22, 0x06, 0xF9, 0x09, 0x20, 0x4B,
  0x81, 0xC9, 0xCB, 0x04, 0x20, 0xCA, 0x07, 0x30, 0xBA, 0x81, 0xB0, 0x2A, 0x0D, 0x30, 0x1C, 0x02,
  0x06, 0xA0, 0x83, 0x81, 0xAF, 0xDA, 0x06, 0x09, 0xA0, 0x52, 0x82, 0x3F, 0xD5, 0xA0, 0x90, 0xAA,
  0x04, 0x28, 0x2C, 0xF4, 0x3A, 0x00, 0xAA, 0x85, 0x40, 0x5F, 0xB0, 0x2A, 0x0B, 0x0A, 0xA8, 0x55,
  0x0D, 0xF2, 0x03, 0xA0, 0xB0, 0x8A, 0x82, 0x68, 0xF9, 0x20, 0x4A, 0x09, 0x05, 0xA8, 0x2B, 0xFE,
  0x12, 0x07, 0xA0, 0x70, 0x1C, 0x07, 0x30, 0xCA, 0x81, 0x30, 0xAA, 0x0E, 0x30, 0x6A, 0x0C, 0x20,
  0x2B, 0x81, 0xC9, 0xBB, 0x04, 0x20, 0x5F, 0x90, 0x63, 0x87, 0xDF, 0x69, 0xDF, 0xDA, 0x33, 0x81,
  0x2D, 0xC7, 0x50, 0x27, 0x30,
  // "ù" (U+00F9)
  0x20, 0x9A, 0x0D, 0x71, 0x01, 0x0D, 0xA0, 0x67, 0x18, 0x32, 0xEF, 0xE1, 0x71, 0x82, 0x3E, 0xF9,
  0x72, 0x82, 0x3E, 0xF4, 0x77, 0x76, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0,
  0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A,
  0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E,
  0x50, 0x8A, 0x07, 0xA0, 0xE5, 0x09, 0xA0, 0x7B, 0x50, 0xBA, 0x07, 0x0E, 0xA0, 0x33, 0x01, 0xB0,
  0x70, 0xBA, 0x0A, 0x30, 0x9B, 0x07, 0x06, 0xB8, 0x3C, 0xAD, 0xFD, 0xA8, 0x17, 0x0C, 0xD0, 0xD0,
  0x2A, 0x07, 0x28, 0x48, 0xDF, 0xD8, 0x11, 0xA0, 0x70,
  // "ú" (U+00FA)
  0x60, 0x5B, 0x03, 0x70, 0xDA, 0x08, 0x70, 0x6A, 0x0A, 0x78, 0x21, 0xEF, 0xB7, 0x18, 0x1A, 0xFA,
  0x77, 0x77, 0x1A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07,
  0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50,
  0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x08, 0xA0, 0x7A,
  0x0E, 0x50, 0x9A, 0x07, 0xB5, 0x0B, 0xA0, 0x70, 0xEA, 0x03, 0x30, 0x1B, 0x07, 0x0B, 0xA0, 0xA3,
  0x09, 0xB0, 0x70, 0x6B, 0x83, 0xCA, 0xDF, 0xDA, 0x81, 0x70, 0xCD, 0x0D, 0x02, 0xA0, 0x72, 0x84,
  0x8D, 0xFD, 0x81, 0x1A, 0x07,
  // "û" (U+00FB)
  0x30, 0x10, 0xEA, 0x06, 0x70, 0x9B, 0x0E, 0x01, 0x50, 0x3A, 0x82, 0x8E, 0xFA, 0x58, 0x6D, 0xF8,
  0x03, 0xEF, 0x53, 0x81, 0x9F, 0x83, 0x82, 0x2E, 0xE2, 0x77, 0x74, 0xA0, 0xE5, 0x07, 0xA0, 0x7A,
  0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07,
  0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0,
  0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x8A, 0x07, 0xA0, 0xE5, 0x09, 0xA0, 0x7B, 0x50, 0xBA, 0x07,
  0x0E, 0xA0, 0x33, 0x01, 0xB0, 0x70, 0xBA, 0x0A, 0x30, 0x9B, 0x07, 0x06, 0xB8, 0x3C, 0xAD, 0xFD,
  0xA8, 0x17, 0x0C, 0xD0, 0xD0, 0x2A, 0x07, 0x28, 0x48, 0xDF, 0xD8, 0x11, 0xA0, 0x70,
  // "ü" (U+00FC)
  0x28, 0x1A, 0xE7, 0x28, 0x17, 0xEA, 0x4A, 0x0C, 0x20, 0xCA, 0x01, 0x38, 0x1A, 0xE7, 0x28, 0x17,
  0xEA, 0x77, 0x75, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0,
  0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5,
  0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x8A, 0x07,
  0xA0, 0xE5, 0x09, 0xA0, 0x7B, 0x50, 0xBA, 0x07, 0x0E, 0xA0, 0x33, 0x01, 0xB0, 0x70, 0xBA, 0x0A,
  0x30, 0x9B, 0x07, 0x06, 0xB8, 0x3C, 0xAD, 0xFD, 0xA8, 0x17, 0x0C, 0xD0, 0xD0, 0x2A, 0x07, 0x28,
  0x48, 0xDF, 0xD8, 0x11, 0xA0, 0x70,
  // "ý" (U+00FD)
  0x70, 0x5B, 0x03, 0x71, 0x0D, 0xA0, 0x87, 0x10, 0x6A, 0x0A, 0x71, 0x82, 0x1E, 0xFB, 0x72, 0x81,
  0xAF, 0xA7, 0x77, 0x73, 0x0B, 0xA0, 0x55, 0x05, 0xA0, 0xB0, 0x7A, 0x09, 0x50, 0x9A, 0x07, 0x02,
  0xA0, 0xD5, 0x0D, 0xA8, 0x12, 0x0D, 0xA0, 0x23, 0x01, 0xA0, 0xD2, 0x08, 0xA0, 0x63, 0x05, 0xA0,
  0x92, 0x03, 0xA0, 0xA3, 0x09, 0xA0, 0x43, 0x81, 0xEF, 0xE3, 0x0D, 0xA4, 0x0A, 0xA8, 0x13, 0x02,
  0xA0, 0xB4, 0x05, 0xA8, 0x17, 0x06, 0xA0, 0x74, 0x01, 0xA8, 0x1B, 0x0A, 0xA0, 0x25, 0x0B, 0xA1,
  0x81, 0xEF, 0xD6, 0x06, 0xA0, 0x5A, 0x09, 0x60, 0x2A, 0x0B, 0xA0, 0x47, 0x0D, 0xC7, 0x10, 0x8B,
  0x0B, 0x71, 0x03, 0xB0, 0x67, 0x2B, 0x02, 0x71, 0x02, 0xA0, 0xD7, 0x20, 0x7A, 0x08, 0x72, 0x0C,
  0xA0, 0x37, 0x10, 0x6A, 0x0D, 0x68, 0x15, 0xAB, 0xB0, 0x66, 0x06, 0xC0, 0xA7, 0x83, 0x5E, 0xFD,
  0x77, 0x10,
  // "þ" (U+00FE)
  0x0E, 0xA7, 0x30, 0xEA, 0x73, 0x0E, 0xA7, 0x30, 0xEA, 0x73, 0x0E, 0xA7, 0x30, 0xEA, 0x73, 0x0E,
  0xA1, 0x84, 0x3B, 0xEE, 0xB3, 0x30, 0xEA, 0x04, 0xE0, 0x42, 0x0E, 0xA8, 0x3D, 0xEA, 0x9E, 0xA0,
  0xE2, 0x0E, 0xA0, 0xE0, 0x22, 0x01, 0x0D, 0xA8, 0x16, 0x0E, 0xA0, 0x84, 0x05, 0xA8, 0x1B, 0x0E,
  0xA0, 0x44, 0x01, 0xA8, 0x1E, 0x0E, 0xA0, 0x15, 0x0E, 0xA0, 0x10, 0xEA, 0x60, 0xDA, 0x02, 0x0E,
  0xA6, 0x0C, 0xA0, 0x30, 0xEA, 0x60, 0xDA, 0x02, 0x0E, 0xA0, 0x15, 0x0E, 0xA0, 0x10, 0xEA, 0x04,
  0x40, 0x2A, 0x81, 0xE0, 0xEA, 0x08, 0x40, 0x6A, 0x81, 0xB0, 0xEA, 0x0E, 0x02, 0x30, 0xDA, 0x89,
  0x06, 0x0E, 0xFE, 0xEF, 0xA9, 0xDA, 0x0E, 0x28, 0x2E, 0xFE, 0x5E, 0x04, 0x20, 0xEA, 0x18, 0x43,
  0xBE, 0xEB, 0x33, 0x0E, 0xA7, 0x30, 0xEA, 0x73, 0x0E, 0xA7, 0x30, 0xEA, 0x73, 0x0E, 0xA7, 0x30,
  0xEA, 0x73, 0x0E, 0xA7, 0x30,
  // "ÿ" (U+00FF)
  0x28, 0x1A, 0xE7, 0x28, 0x17, 0xEA, 0x5A, 0x0C, 0x20, 0xCA, 0x01, 0x48, 0x1A, 0xE7, 0x28, 0x17,
  0xEA, 0x77, 0x77, 0x10, 0xBA, 0x05, 0x50, 0x5A, 0x0B, 0x07, 0xA0, 0x95, 0x09, 0xA0, 0x70, 0x2A,
  0x0D, 0x50, 0xDA, 0x81, 0x20, 0xDA, 0x02, 0x30, 0x1A, 0x0D, 0x20, 0x8A, 0x06, 0x30, 0x5A, 0x09,
  0x20, 0x3A, 0x0A, 0x30, 0x9A, 0x04, 0x38, 0x1E, 0xFE, 0x30, 0xDA, 0x40, 0xAA, 0x81, 0x30, 0x2A,
  0x0B, 0x40, 0x5A, 0x81, 0x70, 0x6A, 0x07, 0x40, 0x1A, 0x81, 0xB0, 0xAA, 0x02, 0x50, 0xBA, 0x18,
  0x1E, 0xFD, 0x60, 0x6A, 0x05, 0xA0, 0x96, 0x02, 0xA0, 0xBA, 0x04, 0x70, 0xDC, 0x71, 0x08, 0xB0,
  0xB7, 0x10, 0x3B, 0x06, 0x72, 0xB0, 0x27, 0x10, 0x2A, 0x0D, 0x72, 0x07, 0xA0, 0x87, 0x20, 0xCA,
  0x03, 0x71, 0x06, 0xA0, 0xD6, 0x81, 0x5A, 0xBB, 0x06, 0x60, 0x6C, 0x0A, 0x78, 0x35, 0xEF, 0xD7,
  0x71,
  // "Ā" (U+0100)
  0x40, 0x78, 0x03, 0x90, 0x27, 0x0C, 0xF0, 0x47, 0x0C, 0xF0, 0x48, 0x0C, 0x40, 0x01, 0xB0, 0xC7,
  0x40, 0x5C, 0x01, 0x73, 0x09, 0xC0, 0x57, 0x38, 0x1D, 0xFC, 0xA0, 0x97, 0x20, 0x2A, 0x82, 0x8C,
  0xFE, 0x72, 0x07, 0xA0, 0x50, 0x9A, 0x03, 0x71, 0x0B, 0xA0, 0x20, 0x6A, 0x07, 0x71, 0xA8, 0x1D,
  0x02, 0xA0, 0xB7, 0x04, 0xA0, 0xA2, 0x0D, 0xA7, 0x08, 0xA0, 0x62, 0x0A, 0xA0, 0x46, 0x0C, 0xA0,
  0x22, 0x06, 0xA0, 0x95, 0x01, 0xA0, 0xE3, 0x02, 0xA0, 0xD5, 0x05, 0xA0, 0xA4, 0x0D, 0xA0, 0x24,
  0x0A, 0xFB, 0x06, 0x40, 0xEF, 0xB0, 0xB3, 0x03, 0xB8, 0x02, 0xDA, 0x0E, 0x30, 0x7A, 0x0B, 0x60,
  0xEA, 0x04, 0x20, 0xBA, 0x07, 0x60, 0xAA, 0x08, 0x2B, 0x03, 0x60, 0x6A, 0x81, 0xC0, 0x4A, 0x0E,
  0x70, 0x2B, 0x01, 0x09, 0xA0, 0xA7, 0x10, 0xDA, 0x06, 0x0D, 0xA0, 0x57, 0x10, 0x8A, 0x0A,
  // "ā" (U+0101)
  0x20, 0x78, 0x03, 0x90, 0x23, 0x0C, 0xF0, 0x43, 0x0C, 0xF0, 0x47, 0x77, 0x68, 0x62, 0x8C, 0xEF,
  0xD9, 0x13, 0x05, 0xF0, 0xD0, 0x12, 0x01, 0xA8, 0x1B, 0x9A, 0xB0, 0x93, 0x05, 0x01, 0x30, 0x4A,
  0x0E, 0x72, 0x0D, 0xA0, 0x17, 0x10, 0xBA, 0x02, 0x38, 0x43, 0x68, 0x89, 0xDA, 0x82, 0x30, 0x2B,
  0xF9, 0x81, 0x31, 0xDF, 0xA0, 0x30, 0x7B, 0x06, 0x01, 0x20, 0xBA, 0x03, 0x0C, 0xA0, 0x74, 0x0B,
  0xA0, 0x30, 0xDA, 0x02, 0x40, 0xDA, 0x03, 0x0D, 0xA0, 0x23, 0x02, 0xB0, 0x30, 0xBA, 0x07, 0x30,
  0xBB, 0x03, 0x06, 0xB8, 0x3B, 0x9D, 0xFA, 0xA8, 0x13, 0x0C, 0xD0, 0x80, 0x3A, 0x89, 0x03, 0x01,
  0x9E, 0xEC, 0x60, 0x1A, 0x03,
  // "Ă" (U+0102)
  0x30, 0x60, 0x74, 0x81, 0x27, 0x47, 0x81, 0xAF, 0x63, 0x81, 0x9F, 0x77, 0x06, 0xA8, 0x1B, 0x9C,
  0xA0, 0x27, 0x10, 0xDD, 0x09, 0x72, 0x84, 0x19, 0xEF, 0xD6, 0x80, 0xC7, 0x00, 0x1B, 0x0C, 0x74,
  0x05, 0xC0, 0x17, 0x30, 0x9C, 0x05, 0x73, 0x81, 0xDF, 0xCA, 0x09, 0x72, 0x02, 0xA8, 0x28, 0xCF,
  0xE7, 0x20, 0x7A, 0x05, 0x09, 0xA0, 0x37, 0x10, 0xBA, 0x02, 0x06, 0xA0, 0x77, 0x1A, 0x81, 0xD0,
  0x2A, 0x0B, 0x70, 0x4A, 0x0A, 0x20, 0xDA, 0x70, 0x8A, 0x06, 0x20, 0xAA, 0x04, 0x60, 0xCA, 0x02,
  0x20, 0x6A, 0x09, 0x50, 0x1A, 0x0E, 0x30, 0x2A, 0x0D, 0x50, 0x5A, 0x0A, 0x40, 0xDA, 0x02, 0x40,
  0xAF, 0xB0, 0x64, 0x0E, 0xFB, 0x0B, 0x30, 0x3B, 0x80, 0x2D, 0xA0, 0xE3, 0x07, 0xA0, 0xB6, 0x0E,
  0xA0, 0x42, 0x0B, 0xA0, 0x76, 0x0A, 0xA0, 0x82, 0xB0, 0x36, 0x06, 0xA8, 0x1C, 0x04, 0xA0, 0xE7,
  0x02, 0xB0, 0x10, 0x9A, 0x0A, 0x71, 0x0D, 0xA0, 0x60, 0xDA, 0x05, 0x71, 0x08, 0xA0, 0xA0,
  // "ă" (U+0103)
  0x20, 0x60, 0x74, 0x81, 0x27, 0x43, 0x81, 0xAF, 0x63, 0x81, 0x9F, 0x73, 0x06, 0xA8, 0x1B, 0x9C,
  0xA0, 0x24, 0x0D, 0xD0, 0x95, 0x84, 0x19, 0xEF, 0xD6, 0x77, 0x77, 0x18, 0x62, 0x8C, 0xEF, 0xD9,
  0x13, 0x05, 0xF0, 0xD0, 0x12, 0x01, 0xA8, 0x1B, 0x9A, 0xB0, 0x93, 0x05, 0x01, 0x30, 0x4A, 0x0E,
  0x72, 0x0D, 0xA0, 0x17, 0x10, 0xBA, 0x02, 0x38, 0x43, 0x68, 0x89, 0xDA, 0x82, 0x30, 0x2B, 0xF9,
  0x81, 0x31, 0xDF, 0xA0, 0x30, 0x7B, 0x06, 0x01, 0x20, 0xBA, 0x03, 0x0C, 0xA0, 0x74, 0x0B, 0xA0,
  0x30, 0xDA, 0x02, 0x40, 0xDA, 0x03, 0x0D, 0xA0, 0x23, 0x02, 0xB0, 0x30, 0xBA, 0x07, 0x30, 0xBB,
  0x03, 0x06, 0xB8, 0x3B, 0x9D, 0xFA, 0xA8, 0x13, 0x0C, 0xD0, 0x80, 0x3A, 0x89, 0x03, 0x01, 0x9E,
  0xEC, 0x60, 0x1A, 0x03,
  // "Ą" (U+0104)
  0x50, 0x1B, 0x0C, 0x74, 0x05, 0xC0, 0x17, 0x30, 0x9C, 0x05, 0x73, 0x81, 0xDF, 0xCA, 0x09, 0x72,
  0x02, 0xA8, 0x28, 0xCF, 0xE7, 0x20, 0x7A, 0x05, 0x09, 0xA0, 0x37, 0x10, 0xBA, 0x02, 0x06, 0xA0,
  0x77, 0x1A, 0x81, 0xD0, 0x2A, 0x0B, 0x70, 0x4A, 0x0A, 0x20, 0xDA, 0x70, 0x8A, 0x06, 0x20, 0xAA,
  0x04, 0x60, 0xCA, 0x02, 0x20, 0x6A, 0x09, 0x50, 0x1A, 0x0E, 0x30, 0x2A, 0x0D, 0x50, 0x5A, 0x0A,
  0x40, 0xDA, 0x02, 0x40, 0xAF, 0xB0, 0x64, 0x0E, 0xFB, 0x0B, 0x30, 0x3B, 0x80, 0x2D, 0xA0, 0xE3,
  0x07, 0xA0, 0xB6, 0x0E, 0xA0, 0x42, 0x0B, 0xA0, 0x76, 0x0A, 0xA0, 0x82, 0xB0, 0x36, 0x06, 0xA8,
  0x1C, 0x04, 0xA0, 0xE7, 0x02, 0xB0, 0x10, 0x9A, 0x0A, 0x71, 0x0D, 0xA0, 0x60, 0xDA, 0x05, 0x71,
  0xB0, 0xA7, 0x48, 0x17, 0xF8, 0x75, 0x81, 0x2F, 0xD7, 0x68, 0x18, 0xF9, 0x76, 0x81, 0xBF, 0x97,
  0x60, 0xAA, 0x0A, 0x09, 0x74, 0x06, 0xC7, 0x58, 0x27, 0xDF, 0xC1,
  // "ą" (U+0105)
  0x28, 0x62, 0x8C, 0xEF, 0xD9, 0x13, 0x05, 0xF0, 0xD0, 0x12, 0x01, 0xA8, 0x1B, 0x9A, 0xB0, 0x93,
  0x05, 0x01, 0x30, 0x4A, 0x0E, 0x72, 0x0D, 0xA0, 0x17, 0x10, 0xBA, 0x02, 0x38, 0x43, 0x68, 0x89,
  0xDA, 0x82, 0x30, 0x2B, 0xF9, 0x81, 0x31, 0xDF, 0xA0, 0x30, 0x7B, 0x06, 0x01, 0x20, 0xBA, 0x03,
  0x0C, 0xA0, 0x74, 0x0B, 0xA0, 0x30, 0xDA, 0x02, 0x40, 0xDA, 0x03, 0x0D, 0xA0, 0x23, 0x02, 0xB0,
  0x30, 0xBA, 0x07, 0x30, 0xBB, 0x03, 0x06, 0xB8, 0x3B, 0x9D, 0xFA, 0xA8, 0x13, 0x0C, 0xD0, 0x80,
  0x3A, 0x89, 0x03, 0x01, 0x9E, 0xEC, 0x60, 0x1A, 0x04, 0x71, 0x81, 0x7F, 0x87, 0x18, 0x12, 0xFD,
  0x72, 0x81, 0x8F, 0x97, 0x28, 0x1B, 0xF9, 0x72, 0x0A, 0xA0, 0xA0, 0x97, 0x06, 0xC7, 0x18, 0x27,
  0xDF, 0xC0,
  // "Ć" (U+0106)
  0x71, 0x05, 0xB0, 0x37, 0x20, 0xDA, 0x08, 0x72, 0x06, 0xA0, 0xA7, 0x28, 0x21, 0xEF, 0xB7, 0x38,
  0x1A, 0xFA, 0x80, 0xC2, 0x08, 0x64, 0xAD, 0xFE, 0xD9, 0x44, 0x01, 0x0B, 0xF9, 0x05, 0x30, 0xCB,
  0x84, 0xC9, 0x9D, 0xFE, 0x30, 0x8A, 0x0E, 0x04, 0x40, 0x50, 0x72, 0x02, 0xB0, 0x57, 0x20, 0x8A,
  0x0C, 0x73, 0x0C, 0xA0, 0x57, 0x20, 0x1B, 0x01, 0x72, 0x03, 0xA0, 0xE7, 0x30, 0x5A, 0x0C, 0x73,
  0x06, 0xA0, 0xB7, 0x30, 0x6A, 0x0B, 0x73, 0x05, 0xA0, 0xC7, 0x30, 0x4A, 0x0E, 0x73, 0x01, 0xB0,
  0x17, 0x30, 0xEA, 0x05, 0x73, 0x09, 0xA0, 0xB7, 0x30, 0x3B, 0x04, 0x73, 0x0A, 0xA0, 0xE0, 0x45,
  0x04, 0x30, 0x10, 0xDB, 0x84, 0xC9, 0xAB, 0xED, 0x40, 0x20, 0xCF, 0x0D, 0x68, 0x66, 0xBD, 0xFE,
  0xD9, 0x41,
  // "ć" (U+0107)
  0x60, 0x5B, 0x03, 0x60, 0xDA, 0x08, 0x60, 0x6A, 0x0A, 0x68, 0x21, 0xEF, 0xB7, 0x81, 0xAF, 0xA7,
  0x77, 0x71, 0x85, 0x29, 0xDF, 0xDB, 0x63, 0x05, 0xF8, 0x11, 0x03, 0xB8, 0x3D, 0x9A, 0xEA, 0x20,
  0xBA, 0x09, 0x48, 0x11, 0x01, 0xA0, 0xE7, 0x05, 0xA0, 0xA7, 0x08, 0xA0, 0x77, 0x09, 0xA0, 0x57,
  0x0A, 0xA0, 0x57, 0x0A, 0xA0, 0x57, 0x09, 0xA0, 0x77, 0x06, 0xA0, 0xA7, 0x03, 0xA0, 0xE7, 0x10,
  0xDA, 0x09, 0x40, 0x42, 0x05, 0xB8, 0x2C, 0x9A, 0xD9, 0x30, 0x8F, 0x48, 0x54, 0xAE, 0xFD, 0xA4,
  0x10,
  // "Ĉ" (U+0108)
  0x60, 0x10, 0xEA, 0x06, 0x72, 0x09, 0xB0, 0xE0, 0x17, 0x03, 0xA8, 0x28, 0xEF, 0xA7, 0x86, 0xDF,
  0x80, 0x3E, 0xF5, 0x58, 0x19, 0xF8, 0x38, 0x22, 0xEE, 0x27, 0x77, 0x75, 0x86, 0x4A, 0xDF, 0xED,
  0x94, 0x40, 0x10, 0xBF, 0x90, 0x53, 0x0C, 0xB8, 0x4C, 0x99, 0xDF, 0xE3, 0x08, 0xA0, 0xE0, 0x44,
  0x05, 0x07, 0x20, 0x2B, 0x05, 0x72, 0x08, 0xA0, 0xC7, 0x30, 0xCA, 0x05, 0x72, 0x01, 0xB0, 0x17,
  0x20, 0x3A, 0x0E, 0x73, 0x05, 0xA0, 0xC7, 0x30, 0x6A, 0x0B, 0x73, 0x06, 0xA0, 0xB7, 0x30, 0x5A,
  0x0C, 0x73, 0x04, 0xA0, 0xE7, 0x30, 0x1B, 0x01, 0x73, 0x0E, 0xA0, 0x57, 0x30, 0x9A, 0x0B, 0x73,
  0x03, 0xB0, 0x47, 0x30, 0xAA, 0x0E, 0x04, 0x50, 0x43, 0x01, 0x0D, 0xB8, 0x4C, 0x9A, 0xBE, 0xD4,
  0x02, 0x0C, 0xF0, 0xD6, 0x86, 0x6B, 0xDF, 0xED, 0x94, 0x10,
  // "ĉ" (U+0109)
  0x30, 0x10, 0xEA, 0x06, 0x60, 0x9B, 0x0E, 0x01, 0x40, 0x3A, 0x82, 0x8E, 0xFA, 0x48, 0x6D, 0xF8,
  0x03, 0xEF, 0x52, 0x81, 0x9F, 0x83, 0x82, 0x2E, 0xE2, 0x77, 0x74, 0x85, 0x29, 0xDF, 0xDB, 0x63,
  0x05, 0xF8, 0x11, 0x03, 0xB8, 0x3D, 0x9A, 0xEA, 0x20, 0xBA, 0x09, 0x48, 0x11, 0x01, 0xA0, 0xE7,
  0x05, 0xA0, 0xA7, 0x08, 0xA0, 0x77, 0x09, 0xA0, 0x57, 0x0A, 0xA0, 0x57, 0x0A, 0xA0, 0x57, 0x09,
  0xA0, 0x77, 0x06, 0xA0, 0xA7, 0x03, 0xA0, 0xE7, 0x10, 0xDA, 0x09, 0x40, 0x42, 0x05, 0xB8, 0x2C,
  0x9A, 0xD9, 0x30, 0x8F, 0x48, 0x54, 0xAE, 0xFD, 0xA4, 0x10,
  // "Ċ" (U+010A)
  0x78, 0x24, 0xED, 0x27, 0x30, 0xBA, 0x07, 0x73, 0x0B, 0xA0, 0x77, 0x38, 0x24, 0xED, 0x18, 0x0C,
  0x00, 0x86, 0x4A, 0xDF, 0xED, 0x94, 0x40, 0x10, 0xBF, 0x90, 0x53, 0x0C, 0xB8, 0x4C, 0x99, 0xDF,
  0xE3, 0x08, 0xA0, 0xE0, 0x44, 0x05, 0x07, 0x20, 0x2B, 0x05, 0x72, 0x08, 0xA0, 0xC7, 0x30, 0xCA,
  0x05, 0x72, 0x01, 0xB0, 0x17, 0x20, 0x3A, 0x0E, 0x73, 0x05, 0xA0, 0xC7, 0x30, 0x6A, 0x0B, 0x73,
  0x06, 0xA0, 0xB7, 0x30, 0x5A, 0x0C, 0x73, 0x04, 0xA0, 0xE7, 0x30, 0x1B, 0x01, 0x73, 0x0E, 0xA0,
  0x57, 0x30, 0x9A, 0x0B, 0x73, 0x03, 0xB0, 0x47, 0x30, 0xAA, 0x0E, 0x04, 0x50, 0x43, 0x01, 0x0D,
  0xB8, 0x4C, 0x9A, 0xBE, 0xD4, 0x02, 0x0C, 0xF0, 0xD6, 0x86, 0x6B, 0xDF, 0xED, 0x94, 0x10,
  // "ċ" (U+010B)
  0x48, 0x24, 0xED, 0x27, 0x0B, 0xA0, 0x77, 0x0B, 0xA0, 0x77, 0x82, 0x4E, 0xD1, 0x77, 0x77, 0x85,
  0x29, 0xDF, 0xDB, 0x63, 0x05, 0xF8, 0x11, 0x03, 0xB8, 0x3D, 0x9A, 0xEA, 0x20, 0xBA, 0x09, 0x48,
  0x11, 0x01, 0xA0, 0xE7, 0x05, 0xA0, 0xA7, 0x08, 0xA0, 0x77, 0x09, 0xA0, 0x57, 0x0A, 0xA0, 0x57,
  0x0A, 0xA0, 0x57, 0x09, 0xA0, 0x77, 0x06, 0xA0, 0xA7, 0x03, 0xA0, 0xE7, 0x10, 0xDA, 0x09, 0x40,
  0x42, 0x05, 0xB8, 0x2C, 0x9A, 0xD9, 0x30, 0x8F, 0x48, 0x54, 0xAE, 0xFD, 0xA4, 0x10,
  // "Č" (U+010C)
  0x48, 0x1A, 0xF8, 0x38, 0x22, 0xDF, 0x24, 0x87, 0x1E, 0xF7, 0x02, 0xEF, 0x66, 0x04, 0xA8, 0x27,
  0xDF, 0xB7, 0x10, 0x9B, 0x0E, 0x01, 0x71, 0x01, 0x0E, 0xA0, 0x78, 0x0C, 0x00, 0x86, 0x4A, 0xDF,
  0xED, 0x94, 0x40, 0x10, 0xBF, 0x90, 0x53, 0x0C, 0xB8, 0x4C, 0x99, 0xDF, 0xE3, 0x08, 0xA0, 0xE0,
  0x44, 0x05, 0x07, 0x20, 0x2B, 0x05, 0x72, 0x08, 0xA0, 0xC7, 0x30, 0xCA, 0x05, 0x72, 0x01, 0xB0,
  0x17, 0x20, 0x3A, 0x0E, 0x73, 0x05, 0xA0, 0xC7, 0x30, 0x6A, 0x0B, 0x73, 0x06, 0xA0, 0xB7, 0x30,
  0x5A, 0x0C, 0x73, 0x04, 0xA0, 0xE7, 0x30, 0x1B, 0x01, 0x73, 0x0E, 0xA0, 0x57, 0x30, 0x9A, 0x0B,
  0x73, 0x03, 0xB0, 0x47, 0x30, 0xAA, 0x0E, 0x04, 0x50, 0x43, 0x01, 0x0D, 0xB8, 0x4C, 0x9A, 0xBE,
  0xD4, 0x02, 0x0C, 0xF0, 0xD6, 0x86, 0x6B, 0xDF, 0xED, 0x94, 0x10,
  // "č" (U+010D)
  0x18, 0x1A, 0xF8, 0x38, 0x94, 0x2D, 0xF2, 0x01, 0xEF, 0x70, 0x2E, 0xF6, 0x30, 0x4A, 0x82, 0x7D,
  0xFB, 0x50, 0x9B, 0x0E, 0x01, 0x50, 0x10, 0xEA, 0x07, 0x77, 0x77, 0x85, 0x29, 0xDF, 0xDB, 0x63,
  0x05, 0xF8, 0x11, 0x03, 0xB8, 0x3D, 0x9A, 0xEA, 0x20, 0xBA, 0x09, 0x48, 0x11, 0x01, 0xA0, 0xE7,
  0x05, 0xA0, 0xA7, 0x08, 0xA0, 0x77, 0x09, 0xA0, 0x57, 0x0A, 0xA0, 0x57, 0x0A, 0xA0, 0x57, 0x09,
  0xA0, 0x77, 0x06, 0xA0, 0xA7, 0x03, 0xA0, 0xE7, 0x10, 0xDA, 0x09, 0x40, 0x42, 0x05, 0xB8, 0x2C,
  0x9A, 0xD9, 0x30, 0x8F, 0x48, 0x54, 0xAE, 0xFD, 0xA4, 0x10,
  // "Ď" (U+010E)
  0x28, 0x1A, 0xF8, 0x38, 0x22, 0xDF, 0x25, 0x87, 0x1E, 0xF7, 0x02, 0xEF, 0x67, 0x04, 0xA8, 0x27,
  0xDF, 0xB7, 0x20, 0x9B, 0x0E, 0x01, 0x72, 0x01, 0x0E, 0xA0, 0x78, 0x0C, 0x00, 0x0A, 0xD8, 0x2E,
  0xC8, 0x25, 0x0A, 0xFA, 0x08, 0x40, 0xAA, 0x83, 0xB9, 0x9A, 0xEB, 0x0A, 0x30, 0xAA, 0x06, 0x40,
  0x8B, 0x06, 0x20, 0xAA, 0x06, 0x50, 0x8A, 0x0E, 0x20, 0xAA, 0x06, 0x60, 0xEA, 0x81, 0x50, 0xAA,
  0x06, 0x60, 0x9A, 0x81, 0xA0, 0xAA, 0x06, 0x60, 0x5A, 0x81, 0xD0, 0xAA, 0x06, 0x60, 0x2B, 0x10,
  0xAA, 0x06, 0x60, 0x1B, 0x01, 0x0A, 0xA0, 0x66, 0x01, 0xB0, 0x20, 0xAA, 0x06, 0x60, 0x1B, 0x01,
  0x0A, 0xA0, 0x66, 0x01, 0xB0, 0x10, 0xAA, 0x06, 0x60, 0x3B, 0x10, 0xAA, 0x06, 0x60, 0x6A, 0x81,
  0xC0, 0xAA, 0x06, 0x60, 0xAA, 0x81, 0x90, 0xAA, 0x06, 0x50, 0x10, 0xEA, 0x81, 0x40, 0xAA, 0x06,
  0x50, 0xAA, 0x0D, 0x20, 0xAA, 0x06, 0x30, 0x10, 0x9B, 0x04, 0x20, 0xAA, 0x82, 0xB9, 0x9B, 0xC0,
  0x73, 0x0A, 0xF9, 0x0E, 0x06, 0x40, 0xAD, 0x82, 0xDB, 0x71, 0x50,
  // "ď" (U+010F)
  0x72, 0x07, 0xA8, 0x17, 0x03, 0xA0, 0xA7, 0x20, 0x7A, 0x81, 0x70, 0x5A, 0x06, 0x72, 0x07, 0xA8,
  0x37, 0x08, 0xFE, 0x73, 0x07, 0xA8, 0x37, 0x0B, 0xF8, 0x73, 0x07, 0xA8, 0x37, 0x0D, 0xE1, 0x73,
  0x07, 0xA0, 0x77, 0x18, 0x57, 0xDF, 0xD8, 0x07, 0xA0, 0x77, 0x0B, 0xD0, 0xC0, 0x6A, 0x07, 0x60,
  0x7B, 0x83, 0xB9, 0xCF, 0xDA, 0x07, 0x60, 0xEA, 0x07, 0x30, 0x8B, 0x07, 0x50, 0x3A, 0x0E, 0x50,
  0xEA, 0x07, 0x50, 0x6A, 0x09, 0x50, 0xAA, 0x07, 0x50, 0x9A, 0x07, 0x50, 0x8A, 0x07, 0x50, 0x9A,
  0x05, 0x50, 0x7A, 0x07, 0x50, 0xAA, 0x05, 0x50, 0x6A, 0x07, 0x50, 0xAA, 0x05, 0x50, 0x7A, 0x07,
  0x50, 0x9A, 0x07, 0x50, 0x8A, 0x07, 0x50, 0x6A, 0x09, 0x50, 0xAA, 0x07, 0x50, 0x3A, 0x0D, 0x50,
  0xEA, 0x07, 0x60, 0xEA, 0x07, 0x30, 0x9B, 0x07, 0x60, 0x7B, 0x83, 0xB9, 0xCF, 0xDA, 0x07, 0x70,
  0xBD, 0x0C, 0x03, 0xA0, 0x77, 0x18, 0x37, 0xDF, 0xD8, 0x28, 0x1E, 0xF7, 0x50,
  // "Đ" (U+0110)
  0x20, 0x9D, 0x82, 0xEC, 0x82, 0x70, 0x9F, 0xA0, 0x86, 0x09, 0xA8, 0x3B, 0x99, 0xAE, 0xB0, 0x95,
  0x09, 0xA0, 0x64, 0x08, 0xB0, 0x64, 0x09, 0xA0, 0x65, 0x08, 0xA0, 0xE4, 0x09, 0xA0, 0x66, 0x0E,
  0xA0, 0x53, 0x09, 0xA0, 0x66, 0x09, 0xA0, 0xA3, 0x09, 0xA0, 0x66, 0x05, 0xA0, 0xD3, 0x09, 0xA0,
  0x66, 0x02, 0xB1, 0x81, 0x39, 0xDA, 0x82, 0xB9, 0x97, 0x30, 0x1B, 0x01, 0x06, 0xF0, 0xC3, 0x01,
  0xB0, 0x10, 0x6F, 0x0C, 0x30, 0x1B, 0x01, 0x20, 0x9A, 0x06, 0x60, 0x1B, 0x30, 0x9A, 0x06, 0x60,
  0x3A, 0x0E, 0x30, 0x9A, 0x06, 0x60, 0x6A, 0x0C, 0x30, 0x9A, 0x06, 0x60, 0xAA, 0x08, 0x30, 0x9A,
  0x06, 0x50, 0x10, 0xEA, 0x03, 0x30, 0x9A, 0x06, 0x50, 0xAA, 0x0D, 0x40, 0x9A, 0x06, 0x30, 0x10,
  0x9B, 0x04, 0x40, 0x9A, 0x82, 0xB9, 0x9B, 0xC0, 0x75, 0x09, 0xF9, 0x0E, 0x06, 0x60, 0x9D, 0x82,
  0xDB, 0x71, 0x50,
  // "đ" (U+0111)
  0x72, 0x07, 0xA0, 0x77, 0x83, 0x49, 0x99, 0xCA, 0x81, 0xC9, 0x35, 0x07, 0xF9, 0x06, 0x50, 0x7F,
  0x90, 0x67, 0x20, 0x7A, 0x07, 0x74, 0x07, 0xA0, 0x75, 0x85, 0x7D, 0xFD, 0x80, 0x6A, 0x07, 0x40,
  0xBD, 0x0C, 0x06, 0xA0, 0x73, 0x07, 0xB8, 0x3B, 0x9C, 0xFD, 0xA0, 0x73, 0x0E, 0xA0, 0x73, 0x08,
  0xB0, 0x72, 0x03, 0xA0, 0xD5, 0x0E, 0xA0, 0x72, 0x06, 0xA0, 0x95, 0x0A, 0xA0, 0x72, 0x09, 0xA0,
  0x75, 0x08, 0xA0, 0x72, 0x0A, 0xA0, 0x55, 0x07, 0xA0, 0x72, 0x0A, 0xA0, 0x55, 0x06, 0xA0, 0x72,
  0x0A, 0xA0, 0x55, 0x07, 0xA0, 0x72, 0x09, 0xA0, 0x75, 0x08, 0xA0, 0x72, 0x06, 0xA0, 0x95, 0x0A,
  0xA0, 0x72, 0x03, 0xA0, 0xE5, 0x0E, 0xA0, 0x73, 0x0E, 0xA0, 0x73, 0x08, 0xB0, 0x73, 0x07, 0xB8,
  0x3B, 0x9C, 0xFD, 0xA0, 0x74, 0x0B, 0xD0, 0xC0, 0x3A, 0x07, 0x58, 0x37, 0xDF, 0xD8, 0x2A, 0x07,
  0x20,
  // "Ē" (U+0112)
  0x10, 0x78, 0x03, 0x90, 0x22, 0x0C, 0xF0, 0x42, 0x0C, 0xF0, 0x47, 0x77, 0x20, 0xAF, 0xA0, 0x20,
  0xAF, 0xA0, 0x20, 0xAA, 0x0B, 0x80, 0x29, 0x01, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0,
  0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xF9, 0x81, 0xB0, 0xAF, 0x98,
  0x1B, 0x0A, 0xA0, 0xB8, 0x01, 0x98, 0x16, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67,
  0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0xB8, 0x02,
  0x90, 0x10, 0xAF, 0xA0, 0x20, 0xAF, 0xA0, 0x20,
  // "ē" (U+0113)
  0x20, 0x78, 0x03, 0x90, 0x23, 0x0C, 0xF0, 0x43, 0x0C, 0xF0, 0x47, 0x77, 0x78, 0x54, 0xAE, 0xEC,
  0x71, 0x40, 0x7E, 0x0D, 0x01, 0x20, 0x4B, 0x81, 0xB9, 0xDA, 0x0B, 0x20, 0xCA, 0x05, 0x30, 0xBA,
  0x04, 0x02, 0xA0, 0xB4, 0x03, 0xA0, 0x80, 0x6A, 0x07, 0x5A, 0x0C, 0x08, 0xA0, 0xB8, 0x01, 0x98,
  0x2E, 0xFD, 0x9F, 0xB0, 0xE0, 0xAF, 0xB0, 0xE0, 0x9A, 0x05, 0x71, 0x08, 0xA0, 0x67, 0x10, 0x5A,
  0x09, 0x71, 0x01, 0xA0, 0xE7, 0x20, 0xBA, 0x0A, 0x58, 0x25, 0x20, 0x2B, 0x85, 0xE9, 0x9A, 0xEF,
  0x32, 0x05, 0xF9, 0x03, 0x38, 0x12, 0x9D, 0xA8, 0x1D, 0x94, 0x10,
  // "Ĕ" (U+0114)
  0x10, 0x60, 0x74, 0x81, 0x27, 0x42, 0x81, 0xAF, 0x63, 0x81, 0x9F, 0x72, 0x06, 0xA8, 0x1B, 0x9C,
  0xA0, 0x23, 0x0D, 0xD0, 0x94, 0x84, 0x19, 0xEF, 0xD6, 0x77, 0x74, 0x0A, 0xFA, 0x02, 0x0A, 0xFA,
  0x02, 0x0A, 0xA0, 0xB8, 0x02, 0x90, 0x10, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70,
  0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAF, 0x98, 0x1B, 0x0A, 0xF9, 0x81, 0xB0,
  0xAA, 0x0B, 0x80, 0x19, 0x81, 0x60, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA,
  0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x0B, 0x80, 0x29, 0x01,
  0x0A, 0xFA, 0x02, 0x0A, 0xFA, 0x02,
  // "ĕ" (U+0115)
  0x20, 0x60, 0x74, 0x81, 0x27, 0x43, 0x81, 0xAF, 0x63, 0x81, 0x9F, 0x73, 0x06, 0xA8, 0x1B, 0x9C,
  0xA0, 0x24, 0x0D, 0xD0, 0x95, 0x84, 0x19, 0xEF, 0xD6, 0x77, 0x77, 0x28, 0x54, 0xAE, 0xEC, 0x71,
  0x40, 0x7E, 0x0D, 0x01, 0x20, 0x4B, 0x81, 0xB9, 0xDA, 0x0B, 0x20, 0xCA, 0x05, 0x30, 0xBA, 0x04,
  0x02, 0xA0, 0xB4, 0x03, 0xA0, 0x80, 0x6A, 0x07, 0x5A, 0x0C, 0x08, 0xA0, 0xB8, 0x01, 0x98, 0x2E,
  0xFD, 0x9F, 0xB0, 0xE0, 0xAF, 0xB0, 0xE0, 0x9A, 0x05, 0x71, 0x08, 0xA0, 0x67, 0x10, 0x5A, 0x09,
  0x71, 0x01, 0xA0, 0xE7, 0x20, 0xBA, 0x0A, 0x58, 0x25, 0x20, 0x2B, 0x85, 0xE9, 0x9A, 0xEF, 0x32,
  0x05, 0xF9, 0x03, 0x38, 0x12, 0x9D, 0xA8, 0x1D, 0x94, 0x10,
  // "Ė" (U+0116)
  0x48, 0x24, 0xED, 0x27, 0x0B, 0xA0, 0x77, 0x0B, 0xA0, 0x77, 0x82, 0x4E, 0xD1, 0x77, 0x74, 0x0A,
  0xFA, 0x02, 0x0A, 0xFA, 0x02, 0x0A, 0xA0, 0xB8, 0x02, 0x90, 0x10, 0xAA, 0x06, 0x70, 0xAA, 0x06,
  0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAF, 0x98, 0x1B,
  0x0A, 0xF9, 0x81, 0xB0, 0xAA, 0x0B, 0x80, 0x19, 0x81, 0x60, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70,
  0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA,
  0x0B, 0x80, 0x29, 0x01, 0x0A, 0xFA, 0x02, 0x0A, 0xFA, 0x02,
  // "ė" (U+0117)
  0x48, 0x24, 0xED, 0x27, 0x10, 0xBA, 0x07, 0x71, 0x0B, 0xA0, 0x77, 0x18, 0x24, 0xED, 0x17, 0x77,
  0x73, 0x85, 0x4A, 0xEE, 0xC7, 0x14, 0x07, 0xE0, 0xD0, 0x12, 0x04, 0xB8, 0x1B, 0x9D, 0xA0, 0xB2,
  0x0C, 0xA0, 0x53, 0x0B, 0xA0, 0x40, 0x2A, 0x0B, 0x40, 0x3A, 0x08, 0x06, 0xA0, 0x75, 0xA0, 0xC0,
  0x8A, 0x0B, 0x80, 0x19, 0x82, 0xEF, 0xD9, 0xFB, 0x0E, 0x0A, 0xFB, 0x0E, 0x09, 0xA0, 0x57, 0x10,
  0x8A, 0x06, 0x71, 0x05, 0xA0, 0x97, 0x10, 0x1A, 0x0E, 0x72, 0x0B, 0xA0, 0xA5, 0x82, 0x52, 0x02,
  0xB8, 0x5E, 0x99, 0xAE, 0xF3, 0x20, 0x5F, 0x90, 0x33, 0x81, 0x29, 0xDA, 0x81, 0xD9, 0x41,
  // "Ę" (U+0118)
  0x0A, 0xFA, 0x02, 0x0A, 0xFA, 0x02, 0x0A, 0xA0, 0xB8, 0x02, 0x90, 0x10, 0xAA, 0x06, 0x70, 0xAA,
  0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAF, 0x98,
  0x1B, 0x0A, 0xF9, 0x81, 0xB0, 0xAA, 0x0B, 0x80, 0x19, 0x81, 0x60, 0xAA, 0x06, 0x70, 0xAA, 0x06,
  0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70,
  0xAA, 0x0B, 0x80, 0x29, 0x01, 0x0A, 0xFA, 0x02, 0x0A, 0xFA, 0x02, 0x68, 0x17, 0xF8, 0x78, 0x12,
  0xFD, 0x71, 0x81, 0x8F, 0x97, 0x18, 0x1B, 0xF9, 0x71, 0x0A, 0xA0, 0xA0, 0x96, 0x06, 0xC7, 0x82,
  0x7D, 0xFC, 0x10,
  // "ę" (U+0119)
  0x38, 0x44, 0xAE, 0xEC, 0x75, 0x07, 0xE0, 0xC0, 0x12, 0x04, 0xB8, 0x1B, 0x9D, 0xA0, 0xA2, 0x0C,
  0xA0, 0x63, 0x0C, 0xA0, 0x02, 0xA0, 0xC4, 0x05, 0xA0, 0x70, 0x6A, 0x07, 0x5A, 0x0B, 0x08, 0xA0,
  0x55, 0x82, 0xEF, 0xD9, 0xFB, 0x0E, 0x0A, 0xFB, 0x0E, 0x09, 0xA0, 0xB8, 0x03, 0x90, 0x08, 0xA0,
  0x57, 0x10, 0x5A, 0x08, 0x71, 0x01, 0xA0, 0xD7, 0x20, 0xBA, 0x09, 0x58, 0x24, 0x20, 0x2B, 0x85,
  0xD9, 0x9B, 0xEF, 0x32, 0x05, 0xF9, 0x03, 0x38, 0x12, 0x9D, 0xC0, 0xA7, 0x18, 0x14, 0xFC, 0x71,
  0x82, 0x1E, 0xF2, 0x71, 0x81, 0x6F, 0xB7, 0x28, 0x19, 0xFB, 0x72, 0x09, 0xA8, 0x1A, 0x91, 0x60,
  0x4C, 0x02, 0x78, 0x36, 0xDF, 0xD1,
  // "Ě" (U+011A)
  0x18, 0x1A, 0xF8, 0x38, 0x94, 0x2D, 0xF2, 0x01, 0xEF, 0x70, 0x2E, 0xF6, 0x30, 0x4A, 0x82, 0x7D,
  0xFB, 0x50, 0x9B, 0x0E, 0x01, 0x50, 0x10, 0xEA, 0x07, 0x77, 0x74, 0x0A, 0xFA, 0x02, 0x0A, 0xFA,
  0x02, 0x0A, 0xA0, 0xB8, 0x02, 0x90, 0x10, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70,
  0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAF, 0x98, 0x1B, 0x0A, 0xF9, 0x81, 0xB0,
  0xAA, 0x0B, 0x80, 0x19, 0x81, 0x60, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA,
  0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x06, 0x70, 0xAA, 0x0B, 0x80, 0x29, 0x01,
  0x0A, 0xFA, 0x02, 0x0A, 0xFA, 0x02,
  // "ě" (U+011B)
  0x18, 0x1A, 0xF8, 0x38, 0x22, 0xDF, 0x22, 0x87, 0x1E, 0xF7, 0x02, 0xEF, 0x64, 0x04, 0xA8, 0x27,
  0xDF, 0xB6, 0x09, 0xB0, 0xE0, 0x16, 0x01, 0x0E, 0xA0, 0x77, 0x77, 0x73, 0x85, 0x4A, 0xEE, 0xC7,
  0x14, 0x07, 0xE0, 0xD0, 0x12, 0x04, 0xB8, 0x1B, 0x9D, 0xA0, 0xB2, 0x0C, 0xA0, 0x53, 0x0B, 0xA0,
  0x40, 0x2A, 0x0B, 0x40, 0x3A, 0x08, 0x06, 0xA0, 0x75, 0xA0, 0xC0, 0x8A, 0x0B, 0x80, 0x19, 0x82,
  0xEF, 0xD9, 0xFB, 0x0E, 0x0A, 0xFB, 0x0E, 0x09, 0xA0, 0x57, 0x10, 0x8A, 0x06, 0x71, 0x05, 0xA0,
  0x97, 0x10, 0x1A, 0x0E, 0x72, 0x0B, 0xA0, 0xA5, 0x82, 0x52, 0x02, 0xB8, 0x5E, 0x99, 0xAE, 0xF3,
  0x20, 0x5F, 0x90, 0x33, 0x81, 0x29, 0xDA, 0x81, 0xD9, 0x41,
  // "Ĝ" (U+011C)
  0x60, 0x10, 0xEA, 0x06, 0x74, 0x09, 0xB0, 0xE0, 0x17, 0x20, 0x3A, 0x82, 0x8E, 0xFA, 0x72, 0x86,
  0xDF, 0x80, 0x3E, 0xF5, 0x78, 0x19, 0xF8, 0x38, 0x22, 0xEE, 0x28, 0x0C, 0x30, 0x87, 0x17, 0xBE,
  0xFE, 0xD9, 0x56, 0x07, 0xFA, 0x0D, 0x40, 0x9B, 0x83, 0xEB, 0x99, 0xCA, 0x09, 0x30, 0x7B, 0x09,
  0x58, 0x12, 0x83, 0x20, 0x10, 0xEA, 0x08, 0x74, 0x07, 0xA0, 0xD7, 0x50, 0xDA, 0x06, 0x74, 0x01,
  0xB0, 0x17, 0x40, 0x4A, 0x0E, 0x75, 0x05, 0xA0, 0xC7, 0x50, 0x6A, 0x0B, 0x5E, 0x05, 0x06, 0xA0,
  0xB5, 0xE0, 0x05, 0xA0, 0xC5, 0x0F, 0x90, 0xDA, 0x05, 0x03, 0xA0, 0xE7, 0x10, 0xAA, 0x05, 0x01,
  0xB0, 0x17, 0x0A, 0xA8, 0x15, 0x0D, 0xA0, 0x57, 0x0A, 0xA8, 0x15, 0x08, 0xA0, 0xC7, 0x0A, 0xA8,
  0x15, 0x02, 0xB0, 0x66, 0x0A, 0xA0, 0x52, 0x09, 0xB0, 0x55, 0x0A, 0xA0, 0x53, 0x0C, 0xB8, 0x3D,
  0xA9, 0xAC, 0xB0, 0x53, 0x01, 0x0B, 0xFB, 0x05, 0x58, 0x14, 0xAD, 0xA8, 0x3E, 0xDA, 0x62, 0x10,
  // "ĝ" (U+011D)
  0x40, 0x10, 0xEA, 0x06, 0x71, 0x09, 0xB0, 0xE0, 0x16, 0x03, 0xA8, 0x28, 0xEF, 0xA6, 0x86, 0xDF,
  0x80, 0x3E, 0xF5, 0x48, 0x19, 0xF8, 0x38, 0x22, 0xEE, 0x27, 0x77, 0x72, 0x83, 0x7D, 0xFD, 0x82,
  0xA0, 0x72, 0x0A, 0xD0, 0xC0, 0x3A, 0x81, 0x70, 0x6B, 0x83, 0xB9, 0xCF, 0xDA, 0x81, 0x70, 0xDA,
  0x07, 0x30, 0x9B, 0x07, 0x03, 0xA0, 0xE5, 0x0E, 0xA0, 0x70, 0x6A, 0x09, 0x50, 0xAA, 0x07, 0x08,
  0xA0, 0x75, 0x08, 0xA0, 0x70, 0x9A, 0x05, 0x50, 0x7A, 0x07, 0x0A, 0xA0, 0x55, 0x06, 0xA0, 0x70,
  0xAA, 0x05, 0x50, 0x7A, 0x07, 0x09, 0xA0, 0x75, 0x07, 0xA0, 0x07, 0xA0, 0x95, 0x0A, 0xA0, 0x70,
  0x3A, 0x0D, 0x50, 0xEA, 0x81, 0x70, 0xEA, 0x07, 0x30, 0x8B, 0x81, 0x70, 0x7B, 0x83, 0xB9, 0xCF,
  0xDA, 0x07, 0x20, 0xBD, 0x0B, 0x06, 0xA0, 0x73, 0x85, 0x7D, 0xFD, 0x70, 0x7A, 0x07, 0x72, 0x07,
  0xA0, 0x67, 0x20, 0x9A, 0x04, 0x72, 0x0D, 0xA8, 0x21, 0x06, 0x25, 0x09, 0xA0, 0xB2, 0x85, 0xCF,
  0xDA, 0x9A, 0xDB, 0x03, 0x20, 0xCF, 0x90, 0x63, 0x87, 0x17, 0xBD, 0xFE, 0xD9, 0x23,
  // "Ğ" (U+011E)
  0x50, 0x60, 0x74, 0x81, 0x27, 0x47, 0x81, 0xAF, 0x63, 0x81, 0x9F, 0x77, 0x06, 0xA8, 0x1B, 0x9C,
  0xA0, 0x27, 0x10, 0xDD, 0x09, 0x72, 0x84, 0x19, 0xEF, 0xD6, 0x80, 0xC5, 0x08, 0x71, 0x7B, 0xEF,
  0xED, 0x95, 0x60, 0x7F, 0xA0, 0xD4, 0x09, 0xB8, 0x3E, 0xB9, 0x9C, 0xA0, 0x93, 0x07, 0xB0, 0x95,
  0x81, 0x28, 0x32, 0x01, 0x0E, 0xA0, 0x87, 0x40, 0x7A, 0x0D, 0x75, 0x0D, 0xA0, 0x67, 0x40, 0x1B,
  0x01, 0x74, 0x04, 0xA0, 0xE7, 0x50, 0x5A, 0x0C, 0x75, 0x06, 0xA0, 0xB5, 0xE0, 0x50, 0x6A, 0x0B,
  0x5E, 0x00, 0x5A, 0x0C, 0x50, 0xF9, 0x0D, 0xA0, 0x50, 0x3A, 0x0E, 0x71, 0x0A, 0xA0, 0x50, 0x1B,
  0x01, 0x70, 0xAA, 0x81, 0x50, 0xDA, 0x05, 0x70, 0xAA, 0x81, 0x50, 0x8A, 0x0C, 0x70, 0xAA, 0x81,
  0x50, 0x2B, 0x06, 0x60, 0xAA, 0x05, 0x20, 0x9B, 0x05, 0x50, 0xAA, 0x05, 0x30, 0xCB, 0x83, 0xDA,
  0x9A, 0xCB, 0x05, 0x30, 0x10, 0xBF, 0xB0, 0x55, 0x81, 0x4A, 0xDA, 0x83, 0xED, 0xA6, 0x21,
  // "ğ" (U+011F)
  0x20, 0x60, 0x74, 0x81, 0x27, 0x44, 0x81, 0xAF, 0x63, 0x81, 0x9F, 0x74, 0x06, 0xA8, 0x1B, 0x9C,
  0xA0, 0x25, 0x0D, 0xD0, 0x96, 0x84, 0x19, 0xEF, 0xD6, 0x77, 0x77, 0x58, 0x37, 0xDF, 0xD8, 0x2A,
  0x07, 0x20, 0xAD, 0x0C, 0x03, 0xA8, 0x17, 0x06, 0xB8, 0x3B, 0x9C, 0xFD, 0xA8, 0x17, 0x0D, 0xA0,
  0x73, 0x09, 0xB0, 0x70, 0x3A, 0x0E, 0x50, 0xEA, 0x07, 0x06, 0xA0, 0x95, 0x0A, 0xA0, 0x70, 0x8A,
  0x07, 0x50, 0x8A, 0x07, 0x09, 0xA0, 0x55, 0x07, 0xA0, 0x70, 0xAA, 0x05, 0x50, 0x6A, 0x07, 0x0A,
  0xA0, 0x55, 0x07, 0xA0, 0x70, 0x9A, 0x07, 0x50, 0x7A, 0x00, 0x7A, 0x09, 0x50, 0xAA, 0x07, 0x03,
  0xA0, 0xD5, 0x0E, 0xA8, 0x17, 0x0E, 0xA0, 0x73, 0x08, 0xB8, 0x17, 0x07, 0xB8, 0x3B, 0x9C, 0xFD,
  0xA0, 0x72, 0x0B, 0xD0, 0xB0, 0x6A, 0x07, 0x38, 0x57, 0xDF, 0xD7, 0x07, 0xA0, 0x77, 0x20, 0x7A,
  0x06, 0x72, 0x09, 0xA0, 0x47, 0x20, 0xDA, 0x82, 0x10, 0x62, 0x50, 0x9A, 0x0B, 0x28, 0x5C, 0xFD,
  0xA9, 0xAD, 0xB0, 0x32, 0x0C, 0xF9, 0x06, 0x38, 0x71, 0x7B, 0xDF, 0xED, 0x92, 0x30,
  // "Ġ" (U+0120)
  0x78, 0x24, 0xED, 0x27, 0x50, 0xBA, 0x07, 0x75, 0x0B, 0xA0, 0x77, 0x58, 0x24, 0xED, 0x18, 0x0C,
  0x60, 0x87, 0x17, 0xBE, 0xFE, 0xD9, 0x56, 0x07, 0xFA, 0x0D, 0x40, 0x9B, 0x83, 0xEB, 0x99, 0xCA,
  0x09, 0x30, 0x7B, 0x09, 0x58, 0x12, 0x83, 0x20, 0x10, 0xEA, 0x08, 0x74, 0x07, 0xA0, 0xD7, 0x50,
  0xDA, 0x06, 0x74, 0x01, 0xB0, 0x17, 0x40, 0x4A, 0x0E, 0x75, 0x05, 0xA0, 0xC7, 0x50, 0x6A, 0x0B,
  0x5E, 0x05, 0x06, 0xA0, 0xB5, 0xE0, 0x05, 0xA0, 0xC5, 0x0F, 0x90, 0xDA, 0x05, 0x03, 0xA0, 0xE7,
  0x10, 0xAA, 0x05, 0x01, 0xB0, 0x17, 0x0A, 0xA8, 0x15, 0x0D, 0xA0, 0x57, 0x0A, 0xA8, 0x15, 0x08,
  0xA0, 0xC7, 0x0A, 0xA8, 0x15, 0x02, 0xB0, 0x66, 0x0A, 0xA0, 0x52, 0x09, 0xB0, 0x55, 0x0A, 0xA0,
  0x53, 0x0C, 0xB8, 0x3D, 0xA9, 0xAC, 0xB0, 0x53, 0x01, 0x0B, 0xFB, 0x05, 0x58, 0x14, 0xAD, 0xA8,
  0x3E, 0xDA, 0x62, 0x10,
  // "ġ" (U+0121)
  0x58, 0x24, 0xED, 0x27, 0x20, 0xBA, 0x07, 0x72, 0x0B, 0xA0, 0x77, 0x28, 0x24, 0xED, 0x17, 0x77,
  0x75, 0x83, 0x7D, 0xFD, 0x82, 0xA0, 0x72, 0x0A, 0xD0, 0xC0, 0x3A, 0x81, 0x70, 0x6B, 0x83, 0xB9,
  0xCF, 0xDA, 0x81, 0x70, 0xDA, 0x07, 0x30, 0x9B, 0x07, 0x03, 0xA0, 0xE5, 0x0E, 0xA0, 0x70, 0x6A,
  0x09, 0x50, 0xAA, 0x07, 0x08, 0xA0, 0x75, 0x08, 0xA0, 0x70, 0x9A, 0x05, 0x50, 0x7A, 0x07, 0x0A,
  0xA0, 0x55, 0x06, 0xA0, 0x70, 0xAA, 0x05, 0x50, 0x7A, 0x07, 0x09, 0xA0, 0x75, 0x07, 0xA0, 0x07,
  0xA0, 0x95, 0x0A, 0xA0, 0x70, 0x3A, 0x0D, 0x50, 0xEA, 0x81, 0x70, 0xEA, 0x07, 0x30, 0x8B, 0x81,
  0x70, 0x7B, 0x83, 0xB9, 0xCF, 0xDA, 0x07, 0x20, 0xBD, 0x0B, 0x06, 0xA0, 0x73, 0x85, 0x7D, 0xFD,
  0x70, 0x7A, 0x07, 0x72, 0x07, 0xA0, 0x67, 0x20, 0x9A, 0x04, 0x72, 0x0D, 0xA8, 0x21, 0x06, 0x25,
  0x09, 0xA0, 0xB2, 0x85, 0xCF, 0xDA, 0x9A, 0xDB, 0x03, 0x20, 0xCF, 0x90, 0x63, 0x87, 0x17, 0xBD,
  0xFE, 0xD9, 0x23,
  // "Ģ" (U+0122)
  0x58, 0x71, 0x7B, 0xEF, 0xED, 0x95, 0x60, 0x7F, 0xA0, 0xD4, 0x09, 0xB8, 0x3E, 0xB9, 0x9C, 0xA0,
  0x93, 0x07, 0xB0, 0x95, 0x81, 0x28, 0x32, 0x01, 0x0E, 0xA0, 0x87, 0x40, 0x7A, 0x0D, 0x75, 0x0D,
  0xA0, 0x67, 0x40, 0x1B, 0x01, 0x74, 0x04, 0xA0, 0xE7, 0x50, 0x5A, 0x0C, 0x75, 0x06, 0xA0, 0xB5,
  0xE0, 0x50, 0x6A, 0x0B, 0x5E, 0x00, 0x5A, 0x0C, 0x50, 0xF9, 0x0D, 0xA0, 0x50, 0x3A, 0x0E, 0x71,
  0x0A, 0xA0, 0x50, 0x1B, 0x01, 0x70, 0xAA, 0x81, 0x50, 0xDA, 0x05, 0x70, 0xAA, 0x81, 0x50, 0x8A,
  0x0C, 0x70, 0xAA, 0x81, 0x50, 0x2B, 0x06, 0x60, 0xAA, 0x05, 0x20, 0x9B, 0x05, 0x50, 0xAA, 0x05,
  0x30, 0xCB, 0x83, 0xDA, 0x9A, 0xCB, 0x05, 0x30, 0x10, 0xBF, 0xB0, 0x55, 0x81, 0x4A, 0xDA, 0x83,
  0xED, 0xA6, 0x28, 0x0C, 0x40, 0x04, 0xA0, 0xA7, 0x50, 0x6A, 0x05, 0x75, 0x81, 0x9F, 0xE7, 0x68,
  0x1C, 0xF7, 0x75, 0x81, 0x1F, 0xD7,
  // "ģ" (U+0123)
  0x68, 0x13, 0xFC, 0x73, 0x81, 0xCF, 0x87, 0x20, 0x5A, 0x04, 0x72, 0x0B, 0xA7, 0x3A, 0x0D, 0x77,
  0x78, 0x37, 0xDF, 0xD8, 0x2A, 0x07, 0x20, 0xAD, 0x0C, 0x03, 0xA8, 0x17, 0x06, 0xB8, 0x3B, 0x9C,
  0xFD, 0xA8, 0x17, 0x0D, 0xA0, 0x73, 0x09, 0xB0, 0x70, 0x3A, 0x0E, 0x50, 0xEA, 0x07, 0x06, 0xA0,
  0x95, 0x0A, 0xA0, 0x70, 0x8A, 0x07, 0x50, 0x8A, 0x07, 0x09, 0xA0, 0x55, 0x07, 0xA0, 0x70, 0xAA,
  0x05, 0x50, 0x6A, 0x07, 0x0A, 0xA0, 0x55, 0x07, 0xA0, 0x70, 0x9A, 0x07, 0x50, 0x7A, 0x00, 0x7A,
  0x09, 0x50, 0xAA, 0x07, 0x03, 0xA0, 0xD5, 0x0E, 0xA8, 0x17, 0x0E, 0xA0, 0x73, 0x08, 0xB8, 0x17,
  0x07, 0xB8, 0x3B, 0x9C, 0xFD, 0xA0, 0x72, 0x0B, 0xD0, 0xB0, 0x6A, 0x07, 0x38, 0x57, 0xDF, 0xD7,
  0x07, 0xA0, 0x77, 0x20, 0x7A, 0x06, 0x72, 0x09, 0xA0, 0x47, 0x20, 0xDA, 0x82, 0x10, 0x62, 0x50,
  0x9A, 0x0B, 0x28, 0x5C, 0xFD, 0xA9, 0xAD, 0xB0, 0x32, 0x0C, 0xF9, 0x06, 0x38, 0x71, 0x7B, 0xDF,
  0xED, 0x92, 0x30,
  // "Ĥ" (U+0124)
  0x40, 0x10, 0xEA, 0x06, 0x72, 0x09, 0xB0, 0xE0, 0x17, 0x03, 0xA8, 0x28, 0xEF, 0xA7, 0x86, 0xDF,
  0x80, 0x3E, 0xF5, 0x58, 0x19, 0xF8, 0x38, 0x22, 0xEE, 0x27, 0x77, 0x72, 0x0A, 0xA0, 0x66, 0x02,
  0xA0, 0xE0, 0xAA, 0x06, 0x60, 0x2A, 0x0E, 0x0A, 0xA0, 0x66, 0x02, 0xA0, 0xE0, 0xAA, 0x06, 0x60,
  0x2A, 0x0E, 0x0A, 0xA0, 0x66, 0x02, 0xA0, 0xE0, 0xAA, 0x06, 0x60, 0x2A, 0x0E, 0x0A, 0xA0, 0x66,
  0x02, 0xA0, 0xE0, 0xAA, 0x06, 0x60, 0x2A, 0x0E, 0x0A, 0xA0, 0x66, 0x02, 0xA0, 0xE0, 0xAF, 0xD0,
  0xE0, 0xAF, 0xD0, 0xE0, 0xAA, 0x0B, 0x80, 0x29, 0x0A, 0xA0, 0xE0, 0xAA, 0x06, 0x60, 0x2A, 0x0E,
  0x0A, 0xA0, 0x66, 0x02, 0xA0, 0xE0, 0xAA, 0x06, 0x60, 0x2A, 0x0E, 0x0A, 0xA0, 0x66, 0x02, 0xA0,
  0xE0, 0xAA, 0x06, 0x60, 0x2A, 0x0E, 0x0A, 0xA0, 0x66, 0x02, 0xA0, 0xE0, 0xAA, 0x06, 0x60, 0x2A,
  0x0E, 0x0A, 0xA0, 0x66, 0x02, 0xA0, 0xE0, 0xAA, 0x06, 0x60, 0x2A, 0x0E, 0x0A, 0xA0, 0x66, 0x02,
  0xA0, 0xE0,
  // "ĥ" (U+0125)
  0x20, 0x10, 0xEA, 0x06, 0x73, 0x09, 0xB0, 0xE0, 0x17, 0x10, 0x3A, 0x82, 0x8E, 0xFA, 0x71, 0x86,
  0xDF, 0x80, 0x3E, 0xF5, 0x68, 0x19, 0xF8, 0x38, 0x22, 0xEE, 0x28, 0x0E, 0x10, 0x0E, 0xA7, 0x50,
  0xEA, 0x75, 0x0E, 0xA7, 0x50, 0xEA, 0x75, 0x0E, 0xA7, 0x50, 0xEA, 0x75, 0x0E, 0xA1, 0x84, 0x4B,
  0xEE, 0xB4, 0x58, 0x2E, 0xFE, 0x5E, 0x05, 0x48, 0x6E, 0xFE, 0xEF, 0xA9, 0xEA, 0x0E, 0x40, 0xEA,
  0x0E, 0x02, 0x20, 0x10, 0xEA, 0x04, 0x30, 0xEA, 0x08, 0x40, 0x9A, 0x06, 0x30, 0xEA, 0x04, 0x40,
  0x7A, 0x07, 0x30, 0xEA, 0x01, 0x40, 0x6A, 0x08, 0x30, 0xEA, 0x50, 0x6A, 0x08, 0x30, 0xEA, 0x50,
  0x6A, 0x08, 0x30, 0xEA, 0x50, 0x6A, 0x08, 0x30, 0xEA, 0x50, 0x6A, 0x08, 0x30, 0xEA, 0x50, 0x6A,
  0x08, 0x30, 0xEA, 0x50, 0x6A, 0x08, 0x30, 0xEA, 0x50, 0x6A, 0x08, 0x30, 0xEA, 0x50, 0x6A, 0x08,
  0x30, 0xEA, 0x50, 0x6A, 0x08, 0x30, 0xEA, 0x50, 0x6A, 0x08,
  // "Ħ" (U+0126)
  0x30, 0xAA, 0x05, 0x60, 0x2A, 0x0D, 0x60, 0xAA, 0x05, 0x60, 0x2A, 0x0D, 0x60, 0xAA, 0x05, 0x60,
  0x2A, 0x0D, 0x48, 0x19, 0x9D, 0xA0, 0xB8, 0x02, 0x90, 0xAA, 0x83, 0xE9, 0x92, 0x1F, 0xFC, 0x03,
  0x01, 0xFF, 0xC0, 0x33, 0x0A, 0xA0, 0x66, 0x02, 0xA0, 0xD6, 0x0A, 0xA0, 0x66, 0x02, 0xA0, 0xD6,
  0x0A, 0xA0, 0x66, 0x02, 0xA0, 0xD6, 0x0A, 0xFD, 0x0D, 0x60, 0xAF, 0xD0, 0xD6, 0x0A, 0xA0, 0xB8,
  0x02, 0x90, 0xAA, 0x0D, 0x60, 0xAA, 0x05, 0x60, 0x2A, 0x0D, 0x60, 0xAA, 0x05, 0x60, 0x2A, 0x0D,
  0x60, 0xAA, 0x05, 0x60, 0x2A, 0x0D, 0x60, 0xAA, 0x05, 0x60, 0x2A, 0x0D, 0x60, 0xAA, 0x05, 0x60,
  0x2A, 0x0D, 0x60, 0xAA, 0x05, 0x60, 0x2A, 0x0D, 0x60, 0xAA, 0x05, 0x60, 0x2A, 0x0D, 0x60, 0xAA,
  0x05, 0x60, 0x2A, 0x0D, 0x60, 0xAA, 0x05, 0x60, 0x2A, 0x0D, 0x60, 0xAA, 0x05, 0x60, 0x2A, 0x0D,
  0x30,
  // "ħ" (U+0127)
  0x20, 0xEA, 0x74, 0x0E, 0xA7, 0x20, 0xDF, 0x90, 0x14, 0x0D, 0xF9, 0x01, 0x40, 0x70, 0x9B, 0x80,
  0x09, 0x70, 0xEA, 0x74, 0x0E, 0xA1, 0x84, 0x4B, 0xEE, 0xB4, 0x48, 0x2E, 0xFE, 0x5E, 0x05, 0x38,
  0x6E, 0xFE, 0xEF, 0xAA, 0xEA, 0x0D, 0x30, 0xEA, 0x0E, 0x03, 0x20, 0x20, 0xEA, 0x03, 0x20, 0xEA,
  0x08, 0x40, 0x9A, 0x06, 0x20, 0xEA, 0x04, 0x40, 0x7A, 0x07, 0x20, 0xEA, 0x02, 0x40, 0x6A, 0x08,
  0x20, 0xEA, 0x50, 0x6A, 0x08, 0x20, 0xEA, 0x50, 0x6A, 0x08, 0x20, 0xEA, 0x50, 0x6A, 0x08, 0x20,
  0xEA, 0x50, 0x6A, 0x08, 0x20, 0xEA, 0x50, 0x6A, 0x08, 0x20, 0xEA, 0x50, 0x6A, 0x08, 0x20, 0xEA,
  0x50, 0x6A, 0x08, 0x20, 0xEA, 0x50, 0x6A, 0x08, 0x20, 0xEA, 0x50, 0x6A, 0x08, 0x20, 0xEA, 0x50,
  0x6A, 0x08,
  // "Ĩ" (U+0128)
  0x18, 0x35, 0xEE, 0x92, 0x28, 0x1D, 0xE2, 0xD8, 0x7A, 0xBF, 0xB7, 0xFC, 0xAE, 0xC8, 0x90, 0x5A,
  0xF1, 0x01, 0x8D, 0xE8, 0x77, 0x71, 0xF0, 0x52, 0xF0, 0x52, 0x81, 0x28, 0xEA, 0x0A, 0x04, 0x50,
  0xDA, 0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA,
  0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA, 0x03,
  0x60, 0xDA, 0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA, 0x03, 0x60, 0xDA, 0x03, 0x50,
  0x30, 0xEA, 0x06, 0x40, 0xDE, 0x04, 0x2F, 0x05, 0x10,
  // "ĩ" (U+0129)
  0x18, 0x35, 0xEE, 0x92, 0x28, 0x1D, 0xE2, 0xD8, 0x7A, 0xBF, 0xB7, 0xFC, 0xAE, 0xC8, 0x90, 0x5A,
  0xF1, 0x01, 0x8D, 0xE8, 0x77, 0x74, 0x0E, 0xA7, 0x0E, 0xA7, 0x0E, 0xA7, 0x0E, 0xA7, 0x0E, 0xA7,
  0x0E, 0xA7, 0x0E, 0xA7, 0x0E, 0xA7, 0x0E, 0xA7, 0x0E, 0xA7, 0x0E, 0xA7, 0x0E, 0xA7, 0x0E, 0xA7,
  0x0E, 0xA7, 0x0E, 0xA7, 0x0E, 0xA7, 0x0E, 0xA3,
  // "Ī" (U+012A)
  0x07, 0x80, 0x39, 0x02, 0x0C, 0xF0, 0x40, 0xCF, 0x04, 0x77, 0x5F, 0x05, 0x1F, 0x83, 0x50, 0x28,
  0xEA, 0x0A, 0x04, 0x40, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50,
  0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA,
  0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03,
  0x50, 0xDA, 0x03, 0x40, 0x30, 0xEA, 0x06, 0x30, 0xDE, 0x04, 0x1F, 0x05,
  // "ī" (U+012B)
  0x07, 0x80, 0x39, 0x02, 0x0C, 0xF0, 0x40, 0xCF, 0x04, 0x77, 0x70, 0xEA, 0x60, 0xEA, 0x60, 0xEA,
  0x60, 0xEA, 0x60, 0xEA, 0x60, 0xEA, 0x60, 0xEA, 0x60, 0xEA, 0x60, 0xEA, 0x60, 0xEA, 0x60, 0xEA,
  0x60, 0xEA, 0x60, 0xEA, 0x60, 0xEA, 0x60, 0xEA, 0x60, 0xEA, 0x60, 0xEA, 0x30,
  // "Ĭ" (U+012C)
  0x06, 0x07, 0x48, 0x42, 0x74, 0xAF, 0x63, 0x82, 0x9F, 0x76, 0xA8, 0x1B, 0x9C, 0xA8, 0x12, 0x0D,
  0xD0, 0x92, 0x84, 0x19, 0xEF, 0xD6, 0x77, 0x7F, 0x05, 0x1F, 0x83, 0x50, 0x28, 0xEA, 0x0A, 0x04,
  0x40, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50,
  0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA,
  0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03, 0x50, 0xDA, 0x03,
  0x40, 0x30, 0xEA, 0x06, 0x30, 0xDE, 0x04, 0x1F, 0x05,
  // "ĭ" (U+012D)
  0x06, 0x07, 0x48, 0x42, 0x74, 0xAF, 0x63, 0x82, 0x9F, 0x76, 0xA8, 0x1B, 0x9C, 0xA8, 0x12, 0x0D,
  0xD0, 0x92, 0x84, 0x19, 0xEF, 0xD6, 0x77, 0x72, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6,
  0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6,
  0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA6, 0x0E, 0xA3,
  // "Į" (U+012E)
  0xF0, 0x5F, 0x82, 0x52, 0x8E, 0xA0, 0xA0, 0x43, 0x0D, 0xA0, 0x34, 0x0D, 0xA0, 0x34, 0x0D, 0xA0,
  0x34, 0x0D, 0xA0, 0x34, 0x0D, 0xA0, 0x34, 0x0D, 0xA0, 0x34, 0x0D, 0xA0, 0x34, 0x0D, 0xA0, 0x34,
  0x0D, 0xA0, 0x34, 0x0D, 0xA0, 0x34, 0x0D, 0xA0, 0x34, 0x0D, 0xA0, 0x34, 0x0D, 0xA0, 0x34, 0x0D,
  0xA0, 0x34, 0x0D, 0xA0, 0x34, 0x0D, 0xA0, 0x33, 0x03, 0x0E, 0xA0, 0x62, 0x0D, 0xE0, 0x4F, 0x05,
  0x38, 0x17, 0xF8, 0x48, 0x12, 0xFD, 0x58, 0x18, 0xF9, 0x58, 0x1B, 0xF9, 0x50, 0xAA, 0x0A, 0x09,
  0x30, 0x6C, 0x48, 0x27, 0xDF, 0xC1,
  // "į" (U+012F)
  0x28, 0x18, 0xEA, 0x3B, 0x02, 0x2B, 0x02, 0x28, 0x18, 0xE9, 0x77, 0x10, 0xEA, 0x30, 0xEA, 0x30,
  0xEA, 0x30, 0xEA, 0x30, 0xEA, 0x30, 0xEA, 0x30, 0xEA, 0x30, 0xEA, 0x30, 0xEA, 0x30, 0xEA, 0x30,
  0xEA, 0x30, 0xEA, 0x30, 0xEA, 0x30, 0xEA, 0x30, 0xEA, 0x30, 0xEA, 0x3B, 0x28, 0x17, 0xF8, 0x28,
  0x12, 0xFD, 0x38, 0x18, 0xF9, 0x38, 0x1B, 0xF9, 0x30, 0xAA, 0x82, 0xA9, 0x06, 0xC2, 0x82, 0x7D,
  0xFC, 0x10,
  // "İ" (U+0130)
  0x28, 0x24, 0xED, 0x24, 0x0B, 0xA0, 0x74, 0x0B, 0xA0, 0x74, 0x82, 0x4E, 0xD1, 0x77, 0x4F, 0x05,
  0xF8, 0x25, 0x28, 0xEA, 0x0A, 0x04, 0x30, 0xDA, 0x03, 0x40, 0xDA, 0x03, 0x40, 0xDA, 0x03, 0x40,
  0xDA, 0x03, 0x40, 0xDA, 0x03, 0x40, 0xDA, 0x03, 0x40, 0xDA, 0x03, 0x40, 0xDA, 0x03, 0x40, 0xDA,
  0x03, 0x40, 0xDA, 0x03, 0x40, 0xDA, 0x03, 0x40, 0xDA, 0x03, 0x40, 0xDA, 0x03, 0x40, 0xDA, 0x03,
  0x40, 0xDA, 0x03, 0x40, 0xDA, 0x03, 0x30, 0x30, 0xEA, 0x06, 0x20, 0xDE, 0x04, 0xF0, 0x50,
  // "ı" (U+0131)
  0x0E, 0xA0, 0xEA, 0x0E, 0xA0, 0xEA, 0x0E, 0xA0, 0xEA, 0x0E, 0xA0, 0xEA, 0x0E, 0xA0, 0xEA, 0x0E,
  0xA0, 0xEA, 0x0E, 0xA0, 0xEA, 0x0E, 0xA0, 0xEA, 0x0E, 0xA0,
  // "Ĳ" (U+0132)
  0xF0, 0x52, 0x0B, 0xA0, 0x4F, 0x05, 0x20, 0xBA, 0x82, 0x42, 0x8E, 0xA0, 0xA0, 0x43, 0x0B, 0xA0,
  0x42, 0x0D, 0xA0, 0x34, 0x0B, 0xA0, 0x42, 0x0D, 0xA0, 0x34, 0x0B, 0xA0, 0x42, 0x0D, 0xA0, 0x34,
  0x0B, 0xA0, 0x42, 0x0D, 0xA0, 0x34, 0x0B, 0xA0, 0x42, 0x0D, 0xA0, 0x34, 0x0B, 0xA0, 0x42, 0x0D,
  0xA0, 0x34, 0x0B, 0xA0, 0x42, 0x0D, 0xA0, 0x34, 0x0B, 0xA0, 0x42, 0x0D, 0xA0, 0x34, 0x0B, 0xA0,
  0x42, 0x0D, 0xA0, 0x34, 0x0B, 0xA0, 0x42, 0x0D, 0xA0, 0x34, 0x0B, 0xA0, 0x42, 0x0D, 0xA0, 0x34,
  0x0B, 0xA0, 0x42, 0x0D, 0xA0, 0x34, 0x0B, 0xA0, 0x42, 0x0D, 0xA0, 0x34, 0x0B, 0xA0, 0x42, 0x0D,
  0xA0, 0x34, 0x0B, 0xA0, 0x42, 0x0D, 0xA0, 0x34, 0x0B, 0xA0, 0x42, 0x0D, 0xA0, 0x34, 0x0B, 0xA8,
  0x24, 0x03, 0xEA, 0x06, 0x40, 0xBA, 0x04, 0x0D, 0xE0, 0x42, 0x0B, 0xA0, 0x4F, 0x05, 0x20, 0xBA,
  0x04, 0x73, 0x0C, 0xA0, 0x47, 0x30, 0xEA, 0x02, 0x72, 0x05, 0xA0, 0xE7, 0x81, 0x99, 0xAB, 0x09,
  0x70, 0xBC, 0x0D, 0x01, 0x78, 0x49, 0xEF, 0xD9, 0x12,
  // "ĳ" (U+0133)
  0x81, 0x8E, 0xA4, 0x81, 0x8E, 0xA1, 0xB0, 0x23, 0xB0, 0x2B, 0x02, 0x3B, 0x82, 0x28, 0xE9, 0x48,
  0x18, 0xE9, 0x77, 0x72, 0x0E, 0xA4, 0x0E, 0xA1, 0x0E, 0xA4, 0x0E, 0xA1, 0x0E, 0xA4, 0x0E, 0xA1,
  0x0E, 0xA4, 0x0E, 0xA1, 0x0E, 0xA4, 0x0E, 0xA1, 0x0E, 0xA4, 0x0E, 0xA1, 0x0E, 0xA4, 0x0E, 0xA1,
  0x0E, 0xA4, 0x0E, 0xA1, 0x0E, 0xA4, 0x0E, 0xA1, 0x0E, 0xA4, 0x0E, 0xA1, 0x0E, 0xA4, 0x0E, 0xA1,
  0x0E, 0xA4, 0x0E, 0xA1, 0x0E, 0xA4, 0x0E, 0xA1, 0x0E, 0xA4, 0x0E, 0xA1, 0x0E, 0xA4, 0x0E, 0xA1,
  0x0E, 0xA4, 0x0E, 0xA1, 0x0E, 0xA4, 0x0E, 0xA7, 0x10, 0xEA, 0x71, 0x0E, 0xA7, 0x1B, 0x70, 0x3A,
  0x0D, 0x58, 0x1A, 0xAE, 0xA0, 0x95, 0x0D, 0xC0, 0x25, 0x83, 0xBE, 0xEB, 0x32,
  // "Ĵ" (U+0134)
  0x30, 0x10, 0xEA, 0x06, 0x60, 0x9B, 0x0E, 0x01, 0x40, 0x3A, 0x82, 0x8E, 0xFA, 0x48, 0x6D, 0xF8,
  0x03, 0xEF, 0x52, 0x81, 0x9F, 0x83, 0x82, 0x2E, 0xE2, 0x77, 0x75, 0x0B, 0xA0, 0x47, 0x0B, 0xA0,
  0x47, 0x0B, 0xA0, 0x47, 0x0B, 0xA0, 0x47, 0x0B, 0xA0, 0x47, 0x0B, 0xA0, 0x47, 0x0B, 0xA0, 0x47,
  0x0B, 0xA0, 0x47, 0x0B, 0xA0, 0x47, 0x0B, 0xA0, 0x47, 0x0B, 0xA0, 0x47, 0x0B, 0xA0, 0x47, 0x0B,
  0xA0, 0x47, 0x0B, 0xA0, 0x47, 0x0B, 0xA0, 0x47, 0x0B, 0xA0, 0x47, 0x0B, 0xA0, 0x47, 0x0B, 0xA0,
  0x47, 0x0B, 0xA0, 0x47, 0x0B, 0xA0, 0x47, 0x0B, 0xA0, 0x47, 0x0B, 0xA0, 0x47, 0x0C, 0xA0, 0x47,
  0x0E, 0xA0, 0x26, 0x05, 0xA0, 0xE4, 0x81, 0x99, 0xAB, 0x09, 0x40, 0xBC, 0x0D, 0x01, 0x48, 0x49,
  0xEF, 0xD9, 0x15,
  // "ĵ" (U+0135)
  0x20, 0x10, 0xEA, 0x06, 0x50, 0x9B, 0x0E, 0x01, 0x30, 0x3A, 0x82, 0x8E, 0xFA, 0x38, 0x92, 0xDF,
  0x80, 0x3E, 0xF5, 0x09, 0xF8, 0x38, 0x22, 0xEE, 0x27, 0x77, 0x20, 0xEA, 0x70, 0xEA, 0x70, 0xEA,
  0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA,
  0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA,
  0x7B, 0x60, 0x3A, 0x0D, 0x48, 0x1A, 0xAE, 0xA0, 0x94, 0x0D, 0xB0, 0xE0, 0x24, 0x83, 0xBE, 0xEB,
  0x35,
  // "Ķ" (U+0136)
  0x0A, 0xA0, 0x65, 0x04, 0xA8, 0x1E, 0x1A, 0xA0, 0x65, 0x0D, 0xA8, 0x16, 0x0A, 0xA0, 0x64, 0x08,
  0xA0, 0xC2, 0x0A, 0xA0, 0x63, 0x02, 0xB0, 0x22, 0x0A, 0xA0, 0x63, 0x0B, 0xA0, 0x83, 0x0A, 0xA0,
  0x62, 0x05, 0xA0, 0xD4, 0x0A, 0xA8, 0x26, 0x01, 0xEA, 0x04, 0x40, 0xAA, 0x81, 0x60, 0x9A, 0x0A,
  0x50, 0xAA, 0x06, 0x03, 0xA0, 0xE0, 0x15, 0x0A, 0xA0, 0x60, 0xCA, 0x06, 0x60, 0xAA, 0x0C, 0xB0,
  0x86, 0x0A, 0xE0, 0xE0, 0x15, 0x0A, 0xB0, 0xB0, 0xCA, 0x09, 0x50, 0xAA, 0x81, 0xB0, 0x4B, 0x02,
  0x40, 0xAA, 0x06, 0x20, 0xBA, 0x09, 0x40, 0xAA, 0x06, 0x20, 0x3B, 0x02, 0x30, 0xAA, 0x06, 0x30,
  0xBA, 0x0A, 0x30, 0xAA, 0x06, 0x30, 0x3B, 0x03, 0x20, 0xAA, 0x06, 0x40, 0xAA, 0x0B, 0x20, 0xAA,
  0x06, 0x40, 0x2B, 0x81, 0x30, 0xAA, 0x06, 0x50, 0xAA, 0x81, 0xB0, 0xAA, 0x06, 0x50, 0x2B, 0x04,
  0x77, 0x77, 0x50, 0x4A, 0x0A, 0x73, 0x06, 0xA0, 0x57, 0x38, 0x19, 0xFE, 0x74, 0x81, 0xCF, 0x77,
  0x38, 0x11, 0xFD, 0x70,
  // "ķ" (U+0137)
  0x0E, 0xA7, 0x20, 0xEA, 0x72, 0x0E, 0xA7, 0x20, 0xEA, 0x72, 0x0E, 0xA7, 0x20, 0xEA, 0x72, 0x0E,
  0xA4, 0x02, 0xA8, 0x1E, 0x2E, 0xA4, 0x0C, 0xA8, 0x16, 0x0E, 0xA3, 0x07, 0xA0, 0xB2, 0x0E, 0xA2,
  0x02, 0xA0, 0xE0, 0x12, 0x0E, 0xA2, 0x0B, 0xA0, 0x53, 0x0E, 0xA1, 0x06, 0xA0, 0xA4, 0x0E, 0xA8,
  0x31, 0xEF, 0xE1, 0x48, 0x2E, 0xFE, 0xAA, 0x0E, 0x01, 0x40, 0xEE, 0x07, 0x40, 0xEB, 0x08, 0xA0,
  0xE0, 0x13, 0x0E, 0xA8, 0x17, 0x0A, 0xA0, 0x73, 0x0E, 0xA2, 0x02, 0xA0, 0xE0, 0x12, 0x0E, 0xA3,
  0x0A, 0xA0, 0x72, 0x0E, 0xA3, 0x03, 0xA8, 0x2E, 0x10, 0xEA, 0x40, 0xBA, 0x81, 0x70, 0xEA, 0x40,
  0x3A, 0x81, 0xE1, 0xEA, 0x50, 0xBA, 0x07, 0x77, 0x76, 0x04, 0xA0, 0xA7, 0x10, 0x6A, 0x05, 0x71,
  0x81, 0x9F, 0xE7, 0x28, 0x1C, 0xF7, 0x71, 0x81, 0x1F, 0xD7,
  // "ĸ" (U+0138)
  0x0E, 0xA4, 0x02, 0xB0, 0x20, 0xEA, 0x40, 0xBA, 0x81, 0x70, 0xEA, 0x30, 0x6A, 0x0C, 0x20, 0xEA,
  0x20, 0x10, 0xEA, 0x02, 0x20, 0xEA, 0x20, 0xAA, 0x07, 0x30, 0xEA, 0x10, 0x5A, 0x0C, 0x40, 0xEA,
  0x01, 0x0E, 0xA0, 0x24, 0x82, 0xEF, 0xE8, 0xA0, 0xE0, 0x14, 0x0E, 0xE0, 0x84, 0x0E, 0xB0, 0x9A,
  0x0E, 0x01, 0x30, 0xEA, 0x81, 0x90, 0x9A, 0x08, 0x30, 0xEA, 0x20, 0x2A, 0x0E, 0x01, 0x20, 0xEA,
  0x30, 0xAA, 0x08, 0x20, 0xEA, 0x30, 0x3A, 0x82, 0xE1, 0x0E, 0xA4, 0x0B, 0xA8, 0x18, 0x0E, 0xA4,
  0x03, 0xA8, 0x1E, 0x1E, 0xA5, 0x0B, 0xA0, 0x80,
  // "Ĺ" (U+0139)
  0x20, 0x5B, 0x03, 0x60, 0xDA, 0x08, 0x60, 0x6A, 0x0A, 0x68, 0x21, 0xEF, 0xB7, 0x81, 0xAF, 0xA7,
  0x77, 0x72, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0,
  0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67,
  0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A,
  0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0xD8, 0x02, 0xC0,
  0x20, 0xAF, 0xA0, 0x30, 0xAF, 0xA0, 0x30,
  // "ĺ" (U+013A)
  0x20, 0x5B, 0x03, 0x20, 0xDA, 0x08, 0x20, 0x6A, 0x0A, 0x28, 0x21, 0xEF, 0xB3, 0x81, 0xAF, 0xA7,
  0x77, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40,
  0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40,
  0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40, 0xEA, 0x40,
  // "Ļ" (U+013B)
  0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A,
  0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0,
  0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67,
  0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0xD8, 0x02, 0xC0, 0x20, 0xAF,
  0xA0, 0x30, 0xAF, 0xA0, 0x37, 0x77, 0x40, 0x4A, 0x0A, 0x70, 0x6A, 0x05, 0x78, 0x19, 0xFE, 0x71,
  0x81, 0xCF, 0x77, 0x81, 0x1F, 0xD6,
  // "ļ" (U+013C)
  0x10, 0xEA, 0x20, 0xEA, 0x20, 0xEA, 0x20, 0xEA, 0x20, 0xEA, 0x20, 0xEA, 0x20, 0xEA, 0x20, 0xEA,
  0x20, 0xEA, 0x20, 0xEA, 0x20, 0xEA, 0x20, 0xEA, 0x20, 0xEA, 0x20, 0xEA, 0x20, 0xEA, 0x20, 0xEA,
  0x20, 0xEA, 0x20, 0xEA, 0x20, 0xEA, 0x20, 0xEA, 0x20, 0xEA, 0x20, 0xEA, 0x20, 0xEA, 0x75, 0x04,
  0xA8, 0x1A, 0x06, 0xA8, 0x35, 0x09, 0xFE, 0x28, 0x5C, 0xF7, 0x01, 0xFD, 0x20,
  // "Ľ" (U+013D)
  0x0A, 0xA0, 0x63, 0x03, 0xA0, 0x0A, 0xA0, 0x63, 0x05, 0xA0, 0x60, 0xAA, 0x06, 0x38, 0x38, 0xFE,
  0x0A, 0xA0, 0x63, 0x83, 0xBF, 0x80, 0xAA, 0x06, 0x38, 0x3D, 0xE1, 0x0A, 0xA0, 0x67, 0x0A, 0xA0,
  0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67,
  0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A,
  0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0xD8, 0x02, 0xC0, 0x20, 0xAF, 0xA0, 0x30, 0xAF, 0xA0,
  0x30,
  // "ľ" (U+013E)
  0x0E, 0xA1, 0x03, 0xA0, 0xA0, 0xEA, 0x10, 0x5A, 0x06, 0x0E, 0xA1, 0x83, 0x8F, 0xE0, 0xEA, 0x18,
  0x3B, 0xF8, 0x0E, 0xA1, 0x83, 0xDE, 0x10, 0xEA, 0x50, 0xEA, 0x50, 0xEA, 0x50, 0xEA, 0x50, 0xEA,
  0x50, 0xEA, 0x50, 0xEA, 0x50, 0xEA, 0x50, 0xEA, 0x50, 0xEA, 0x50, 0xEA, 0x50, 0xEA, 0x50, 0xEA,
  0x50, 0xEA, 0x50, 0xEA, 0x50, 0xEA, 0x50, 0xEA, 0x50, 0xEA, 0x50,
  // "Ŀ" (U+013F)
  0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A,
  0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x62, 0x84, 0x4E, 0xD2, 0x0A, 0xA0,
  0x62, 0x0B, 0xA8, 0x17, 0x0A, 0xA0, 0x62, 0x0B, 0xA8, 0x17, 0x0A, 0xA0, 0x62, 0x84, 0x4E, 0xD1,
  0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A,
  0xA0, 0x67, 0x0A, 0xA0, 0x67, 0x0A, 0xA0, 0xD8, 0x02, 0xC0, 0x20, 0xAF, 0xA0, 0x30, 0xAF, 0xA0,
  0x30,
  // "ŀ" (U+0140)
  0x0E, 0xA5, 0x0E, 0xA5, 0x0E, 0xA5, 0x0E, 0xA5, 0x0E, 0xA5, 0x0E, 0xA5, 0x0E, 0xA5, 0x0E, 0xA5,
  0x0E, 0xA5, 0x0E, 0xA1, 0x83, 0x4E, 0xD2, 0xEA, 0x10, 0xBA, 0x07, 0x0E, 0xA1, 0x0B, 0xA0, 0x70,
  0xEA, 0x18, 0x34, 0xED, 0x1E, 0xA5, 0x0E, 0xA5, 0x0E, 0xA5, 0x0E, 0xA5, 0x0E, 0xA5, 0x0E, 0xA5,
  0x0E, 0xA5, 0x0E, 0xA5, 0x0E, 0xA5, 0x0E, 0xA5,
  // "Ł" (U+0141)
  0x20, 0x7A, 0x09, 0x72, 0x07, 0xA0, 0x97, 0x20, 0x7A, 0x09, 0x72, 0x07, 0xA0, 0x97, 0x20, 0x7A,
  0x09, 0x72, 0x07, 0xA0, 0x97, 0x20, 0x7A, 0x09, 0x72, 0x07, 0xA0, 0x92, 0x03, 0x60, 0x7A, 0x83,
  0x91, 0xAF, 0x65, 0x07, 0xA0, 0xC0, 0xEA, 0x0C, 0x50, 0x7D, 0x09, 0x60, 0x9B, 0x0D, 0x03, 0x50,
  0x10, 0xAB, 0x0B, 0x70, 0xDC, 0x09, 0x78, 0x16, 0xFD, 0xA0, 0x97, 0x10, 0x20, 0x7A, 0x09, 0x72,
  0x07, 0xA0, 0x97, 0x20, 0x7A, 0x09, 0x72, 0x07, 0xA0, 0x97, 0x20, 0x7A, 0x0E, 0x80, 0x2C, 0x05,
  0x20, 0x7F, 0xA0, 0x62, 0x07, 0xFA, 0x06,
  // "ł" (U+0142)
  0x30, 0xBA, 0x03, 0x50, 0xBA, 0x03, 0x50, 0xBA, 0x03, 0x50, 0xBA, 0x03, 0x50, 0xBA, 0x03, 0x50,
  0xBA, 0x03, 0x50, 0xBA, 0x03, 0x50, 0xBA, 0x03, 0x50, 0xBA, 0x03, 0x04, 0x40, 0xBA, 0x81, 0xCF,
  0x83, 0x0B, 0xC0, 0xC3, 0x0C, 0xB0, 0x82, 0x02, 0x0C, 0xB0, 0x62, 0x03, 0x0E, 0xC0, 0x32, 0x82,
  0x1D, 0xEE, 0xA0, 0x33, 0x81, 0x32, 0xBA, 0x03, 0x50, 0xBA, 0x03, 0x50, 0xBA, 0x03, 0x50, 0xBA,
  0x03, 0x50, 0xBA, 0x03, 0x50, 0xBA, 0x03, 0x50, 0xBA, 0x03, 0x50, 0xBA, 0x03, 0x20,
  // "Ń" (U+0143)
  0x71, 0x05, 0xB0, 0x37, 0x30, 0xDA, 0x08, 0x73, 0x06, 0xA0, 0xA7, 0x38, 0x21, 0xEF, 0xB7, 0x48,
  0x1A, 0xFA, 0x80, 0xC0, 0x00, 0xAB, 0x03, 0x78, 0x2E, 0xFE, 0xAB, 0x0A, 0x78, 0x2E, 0xFE, 0xAC,
  0x02, 0x68, 0x2E, 0xFE, 0xAC, 0x0A, 0x68, 0x2E, 0xFE, 0xAD, 0x02, 0x58, 0x2E, 0xFE, 0xAA, 0x09,
  0xA0, 0x95, 0x82, 0xEF, 0xEA, 0xA0, 0x3B, 0x01, 0x48, 0x2E, 0xFE, 0xAA, 0x01, 0x0A, 0xA0, 0x84,
  0x82, 0xEF, 0xEA, 0xA0, 0x02, 0xA0, 0xE0, 0x13, 0x82, 0xEF, 0xEA, 0xA8, 0x12, 0x0A, 0xA0, 0x73,
  0x82, 0xEF, 0xEA, 0xA8, 0x12, 0x03, 0xA0, 0xE3, 0x82, 0xEF, 0xEA, 0xA0, 0x22, 0x0B, 0xA0, 0x62,
  0x82, 0xEF, 0xEA, 0xA0, 0x22, 0x04, 0xA0, 0xD2, 0x82, 0xEF, 0xEA, 0xA0, 0x23, 0x0C, 0xA8, 0x45,
  0x0E, 0xFE, 0xAA, 0x02, 0x30, 0x4A, 0x84, 0xD0, 0xDF, 0xEA, 0xA0, 0x24, 0x0C, 0xA8, 0x34, 0xCF,
  0xEA, 0xA0, 0x24, 0x05, 0xA8, 0x3C, 0xCF, 0xEA, 0xA0, 0x25, 0x0D, 0xC0, 0xE0, 0xAA, 0x02, 0x50,
  0x6C, 0x0E, 0x0A, 0xA0, 0x26, 0x0D, 0xB0, 0xE0, 0xAA, 0x02, 0x60, 0x7B, 0x0E, 0x0A, 0xA0, 0x27,
  0x0E, 0xA0, 0xE0,
  // "ń" (U+0144)
  0x60, 0x5B, 0x03, 0x70, 0xDA, 0x08, 0x70, 0x6A, 0x0A, 0x78, 0x21, 0xEF, 0xB7, 0x18, 0x1A, 0xFA,
  0x77, 0x77, 0x18, 0x90, 0xEF, 0x70, 0x4B, 0xEE, 0xB4, 0x28, 0x2E, 0xF9, 0x5E, 0x89, 0x05, 0x0E,
  0xFD, 0xEE, 0xAA, 0xEA, 0x81, 0xE0, 0xEA, 0x0E, 0x02, 0x20, 0x20, 0xEA, 0x04, 0x0E, 0xA0, 0x84,
  0x0A, 0xA0, 0x60, 0xEA, 0x04, 0x40, 0x7A, 0x07, 0x0E, 0xA0, 0x14, 0x06, 0xA0, 0x80, 0xEA, 0x50,
  0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80,
  0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06,
  0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80,
  // "Ņ" (U+0145)
  0x0A, 0xB0, 0x37, 0x82, 0xEF, 0xEA, 0xB0, 0xA7, 0x82, 0xEF, 0xEA, 0xC0, 0x26, 0x82, 0xEF, 0xEA,
  0xC0, 0xA6, 0x82, 0xEF, 0xEA, 0xD0, 0x25, 0x82, 0xEF, 0xEA, 0xA0, 0x9A, 0x09, 0x58, 0x2E, 0xFE,
  0xAA, 0x03, 0xB0, 0x14, 0x82, 0xEF, 0xEA, 0xA0, 0x10, 0xAA, 0x08, 0x48, 0x2E, 0xFE, 0xAA, 0x00,
  0x2A, 0x0E, 0x01, 0x38, 0x2E, 0xFE, 0xAA, 0x81, 0x20, 0xAA, 0x07, 0x38, 0x2E, 0xFE, 0xAA, 0x81,
  0x20, 0x3A, 0x0E, 0x38, 0x2E, 0xFE, 0xAA, 0x02, 0x20, 0xBA, 0x06, 0x28, 0x2E, 0xFE, 0xAA, 0x02,
  0x20, 0x4A, 0x0D, 0x28, 0x2E, 0xFE, 0xAA, 0x02, 0x30, 0xCA, 0x84, 0x50, 0xEF, 0xEA, 0xA0, 0x23,
  0x04, 0xA8, 0x4D, 0x0D, 0xFE, 0xAA, 0x02, 0x40, 0xCA, 0x83, 0x4C, 0xFE, 0xAA, 0x02, 0x40, 0x5A,
  0x83, 0xCC, 0xFE, 0xAA, 0x02, 0x50, 0xDC, 0x0E, 0x0A, 0xA0, 0x25, 0x06, 0xC0, 0xE0, 0xAA, 0x02,
  0x60, 0xDB, 0x0E, 0x0A, 0xA0, 0x26, 0x07, 0xB0, 0xE0, 0xAA, 0x02, 0x70, 0xEA, 0x0E, 0x80, 0xC0,
  0x00, 0x4A, 0x0A, 0x74, 0x06, 0xA0, 0x57, 0x48, 0x19, 0xFE, 0x75, 0x81, 0xCF, 0x77, 0x48, 0x11,
  0xFD, 0x70,
  // "ņ" (U+0146)
  0x89, 0x0E, 0xF7, 0x04, 0xBE, 0xEB, 0x42, 0x82, 0xEF, 0x95, 0xE8, 0x90, 0x50, 0xEF, 0xDE, 0xEA,
  0xAE, 0xA8, 0x1E, 0x0E, 0xA0, 0xE0, 0x22, 0x02, 0x0E, 0xA0, 0x40, 0xEA, 0x08, 0x40, 0xAA, 0x06,
  0x0E, 0xA0, 0x44, 0x07, 0xA0, 0x70, 0xEA, 0x01, 0x40, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80,
  0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06,
  0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E,
  0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x77, 0x77, 0x04, 0xA0, 0xA7, 0x10, 0x6A, 0x05,
  0x71, 0x81, 0x9F, 0xE7, 0x28, 0x1C, 0xF7, 0x71, 0x81, 0x1F, 0xD6,
  // "Ň" (U+0147)
  0x38, 0x1A, 0xF8, 0x38, 0x22, 0xDF, 0x25, 0x87, 0x1E, 0xF7, 0x02, 0xEF, 0x67, 0x04, 0xA8, 0x27,
  0xDF, 0xB7, 0x20, 0x9B, 0x0E, 0x01, 0x72, 0x01, 0x0E, 0xA0, 0x77, 0x77, 0x77, 0x0A, 0xB0, 0x37,
  0x82, 0xEF, 0xEA, 0xB0, 0xA7, 0x82, 0xEF, 0xEA, 0xC0, 0x26, 0x82, 0xEF, 0xEA, 0xC0, 0xA6, 0x82,
  0xEF, 0xEA, 0xD0, 0x25, 0x82, 0xEF, 0xEA, 0xA0, 0x9A, 0x09, 0x58, 0x2E, 0xFE, 0xAA, 0x03, 0xB0,
  0x14, 0x82, 0xEF, 0xEA, 0xA0, 0x10, 0xAA, 0x08, 0x48, 0x2E, 0xFE, 0xAA, 0x00, 0x2A, 0x0E, 0x01,
  0x38, 0x2E, 0xFE, 0xAA, 0x81, 0x20, 0xAA, 0x07, 0x38, 0x2E, 0xFE, 0xAA, 0x81, 0x20, 0x3A, 0x0E,
  0x38, 0x2E, 0xFE, 0xAA, 0x02, 0x20, 0xBA, 0x06, 0x28, 0x2E, 0xFE, 0xAA, 0x02, 0x20, 0x4A, 0x0D,
  0x28, 0x2E, 0xFE, 0xAA, 0x02, 0x30, 0xCA, 0x84, 0x50, 0xEF, 0xEA, 0xA0, 0x23, 0x04, 0xA8, 0x4D,
  0x0D, 0xFE, 0xAA, 0x02, 0x40, 0xCA, 0x83, 0x4C, 0xFE, 0xAA, 0x02, 0x40, 0x5A, 0x83, 0xCC, 0xFE,
  0xAA, 0x02, 0x50, 0xDC, 0x0E, 0x0A, 0xA0, 0x25, 0x06, 0xC0, 0xE0, 0xAA, 0x02, 0x60, 0xDB, 0x0E,
  0x0A, 0xA0, 0x26, 0x07, 0xB0, 0xE0, 0xAA, 0x02, 0x70, 0xEA, 0x0E,
  // "ň" (U+0148)
  0x18, 0x1A, 0xF8, 0x38, 0x22, 0xDF, 0x22, 0x87, 0x1E, 0xF7, 0x02, 0xEF, 0x64, 0x04, 0xA8, 0x27,
  0xDF, 0xB6, 0x09, 0xB0, 0xE0, 0x16, 0x01, 0x0E, 0xA0, 0x77, 0x77, 0x78, 0x90, 0xEF, 0x70, 0x4B,
  0xEE, 0xB4, 0x28, 0x2E, 0xF9, 0x5E, 0x89, 0x05, 0x0E, 0xFD, 0xEE, 0xAA, 0xEA, 0x81, 0xE0, 0xEA,
  0x0E, 0x02, 0x20, 0x20, 0xEA, 0x04, 0x0E, 0xA0, 0x84, 0x0A, 0xA0, 0x60, 0xEA, 0x04, 0x40, 0x7A,
  0x07, 0x0E, 0xA0, 0x14, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80,
  0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06,
  0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E,
  0xA5, 0x06, 0xA0, 0x80,
  // "ŉ" (U+0149)
  0x2B, 0x02, 0x75, 0x02, 0xA0, 0xE7, 0x60, 0x4A, 0x0B, 0x76, 0x07, 0xA0, 0x77, 0x60, 0x9A, 0x02,
  0x76, 0x89, 0x4C, 0xFC, 0x0E, 0xF7, 0x04, 0xBE, 0xEB, 0x43, 0xA8, 0x47, 0x0E, 0xF9, 0x5E, 0x81,
  0x50, 0x3A, 0x89, 0x01, 0x0E, 0xFD, 0xEE, 0xAA, 0xEA, 0x0E, 0x60, 0xEA, 0x0E, 0x02, 0x20, 0x20,
  0xEA, 0x04, 0x50, 0xEA, 0x08, 0x40, 0xAA, 0x06, 0x50, 0xEA, 0x04, 0x40, 0x7A, 0x07, 0x50, 0xEA,
  0x01, 0x40, 0x6A, 0x08, 0x50, 0xEA, 0x50, 0x6A, 0x08, 0x50, 0xEA, 0x50, 0x6A, 0x08, 0x50, 0xEA,
  0x50, 0x6A, 0x08, 0x50, 0xEA, 0x50, 0x6A, 0x08, 0x50, 0xEA, 0x50, 0x6A, 0x08, 0x50, 0xEA, 0x50,
  0x6A, 0x08, 0x50, 0xEA, 0x50, 0x6A, 0x08, 0x50, 0xEA, 0x50, 0x6A, 0x08, 0x50, 0xEA, 0x50, 0x6A,
  0x08, 0x50, 0xEA, 0x50, 0x6A, 0x08,
  // "Ŋ" (U+014A)
  0x0A, 0xB0, 0x37, 0x82, 0xEF, 0xEA, 0xB0, 0xB7, 0x82, 0xEF, 0xEA, 0xC0, 0x46, 0x82, 0xEF, 0xEA,
  0xC0, 0xC6, 0x82, 0xEF, 0xEA, 0xA0, 0xEA, 0x04, 0x58, 0x2E, 0xFE, 0xAA, 0x08, 0xA0, 0xC5, 0x82,
  0xEF, 0xEA, 0xA0, 0x20, 0xEA, 0x04, 0x48, 0x2E, 0xFE, 0xAA, 0x02, 0x07, 0xA0, 0xC4, 0x82, 0xEF,
  0xEA, 0xA8, 0x12, 0x0E, 0xA0, 0x53, 0x82, 0xEF, 0xEA, 0xA8, 0x12, 0x06, 0xA0, 0xC3, 0x82, 0xEF,
  0xEA, 0xA0, 0x22, 0x0D, 0xA0, 0x52, 0x82, 0xEF, 0xEA, 0xA0, 0x22, 0x06, 0xA0, 0xC2, 0x82, 0xEF,
  0xEA, 0xA0, 0x23, 0x0D, 0xA8, 0x45, 0x0E, 0xFE, 0xAA, 0x02, 0x30, 0x5A, 0x84, 0xD0, 0xDF, 0xEA,
  0xA0, 0x24, 0x0C, 0xA8, 0x35, 0xDF, 0xEA, 0xA0, 0x24, 0x04, 0xA8, 0x3D, 0xCF, 0xEA, 0xA0, 0x25,
  0x0C, 0xC0, 0xE0, 0xAA, 0x02, 0x50, 0x4C, 0x0E, 0x0A, 0xA0, 0x26, 0x0B, 0xB0, 0xE0, 0xAA, 0x02,
  0x60, 0x3B, 0x0E, 0x0A, 0xA0, 0x27, 0x0A, 0xA0, 0xE0, 0xAA, 0x02, 0x70, 0x2A, 0x0E, 0x75, 0x81,
  0xEF, 0xE7, 0x40, 0x1A, 0x0C, 0x74, 0x07, 0xA0, 0x97, 0x82, 0x1B, 0x9B, 0xB0, 0x37, 0x01, 0xD0,
  0x97, 0x18, 0x41, 0xCE, 0xEC, 0x62,
  // "ŋ" (U+014B)
  0x89, 0x0E, 0xF7, 0x04, 0xBE, 0xEB, 0x42, 0x82, 0xEF, 0x96, 0xE8, 0x90, 0x50, 0xEF, 0xEF, 0xEA,
  0xAE, 0xA8, 0x1D, 0x0E, 0xA0, 0xE0, 0x22, 0x02, 0x0E, 0xA0, 0x30, 0xEA, 0x08, 0x40, 0x9A, 0x06,
  0x0E, 0xA0, 0x34, 0x07, 0xA0, 0x70, 0xEA, 0x01, 0x40, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80,
  0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06,
  0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E,
  0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x71, 0x06, 0xA0, 0x87, 0x10, 0x6A, 0x08, 0x71,
  0x07, 0xA0, 0x77, 0x10, 0xAA, 0x05, 0x58, 0x12, 0xAA, 0xB0, 0x15, 0x03, 0xC0, 0x96, 0x83, 0x2D,
  0xFD, 0x82,
  // "Ō" (U+014C)
  0x40, 0x78, 0x03, 0x90, 0x27, 0x10, 0xCF, 0x04, 0x71, 0x0C, 0xF0, 0x48, 0x0C, 0x60, 0x86, 0x17,
  0xBE, 0xFE, 0xB6, 0x71, 0x04, 0x0E, 0xF0, 0xD0, 0x25, 0x03, 0x0E, 0xB8, 0x1B, 0x9B, 0xB0, 0xD0,
  0x14, 0x0D, 0xA0, 0xC0, 0x13, 0x02, 0x0D, 0xA0, 0xA3, 0x05, 0xA0, 0xE0, 0x25, 0x02, 0xB0, 0x22,
  0x0A, 0xA0, 0x97, 0x0A, 0xA0, 0x82, 0xB0, 0x37, 0x05, 0xA8, 0x1C, 0x02, 0xB7, 0x10, 0x2B, 0x10,
  0x4A, 0x0D, 0x72, 0xB0, 0x20, 0x5A, 0x0C, 0x72, 0x0E, 0xA0, 0x30, 0x6A, 0x0B, 0x72, 0x0D, 0xA0,
  0x40, 0x6A, 0x0B, 0x72, 0x0D, 0xA0, 0x40, 0x5A, 0x0C, 0x72, 0x0E, 0xA0, 0x30, 0x4A, 0x0D, 0x72,
  0xB0, 0x20, 0x1B, 0x71, 0x02, 0xB2, 0x0D, 0xA0, 0x37, 0x05, 0xA0, 0xC2, 0x0A, 0xA0, 0x87, 0x0A,
  0xA0, 0x82, 0x04, 0xA0, 0xE0, 0x15, 0x03, 0xB0, 0x23, 0x0B, 0xA0, 0xC0, 0x13, 0x02, 0x0D, 0xA0,
  0xA4, 0x02, 0x0E, 0xB8, 0x1B, 0x9B, 0xB0, 0xD0, 0x15, 0x03, 0x0D, 0xF0, 0xD0, 0x27, 0x18, 0x57,
  0xBE, 0xFE, 0xB6, 0x50,
  // "ō" (U+014D)
  0x20, 0x78, 0x03, 0x90, 0x24, 0x0C, 0xF0, 0x44, 0x0C, 0xF0, 0x47, 0x77, 0x73, 0x85, 0x3A, 0xDF,
  0xEA, 0x35, 0x06, 0xF0, 0x63, 0x04, 0xB8, 0x1C, 0x9B, 0xB0, 0x42, 0x0C, 0xA0, 0x83, 0x06, 0xA8,
  0x1D, 0x02, 0xA0, 0xE5, 0x0C, 0xA0, 0x30, 0x6A, 0x09, 0x50, 0x8A, 0x07, 0x08, 0xA0, 0x75, 0x05,
  0xA0, 0xA0, 0x9A, 0x05, 0x50, 0x4A, 0x0B, 0x0A, 0xA0, 0x55, 0x03, 0xA0, 0xC0, 0x9A, 0x05, 0x50,
  0x4A, 0x0B, 0x08, 0xA0, 0x75, 0x05, 0xA0, 0xA0, 0x5A, 0x09, 0x50, 0x8A, 0x07, 0x01, 0xA0, 0xE5,
  0x0C, 0xA8, 0x13, 0x0A, 0xA0, 0x83, 0x06, 0xA0, 0xC2, 0x02, 0xB8, 0x1C, 0x9B, 0xB0, 0x43, 0x04,
  0xF0, 0x65, 0x85, 0x2A, 0xEF, 0xEA, 0x33,
  // "Ŏ" (U+014E)
  0x40, 0x60, 0x74, 0x81, 0x27, 0x47, 0x18, 0x1A, 0xF6, 0x38, 0x19, 0xF7, 0x71, 0x06, 0xA8, 0x1B,
  0x9C, 0xA0, 0x27, 0x20, 0xDD, 0x09, 0x73, 0x84, 0x19, 0xEF, 0xD6, 0x80, 0xD0, 0x08, 0x61, 0x7B,
  0xEF, 0xEB, 0x67, 0x10, 0x40, 0xEF, 0x0D, 0x02, 0x50, 0x30, 0xEB, 0x81, 0xB9, 0xBB, 0x0D, 0x01,
  0x40, 0xDA, 0x0C, 0x01, 0x30, 0x20, 0xDA, 0x0A, 0x30, 0x5A, 0x0E, 0x02, 0x50, 0x2B, 0x02, 0x20,
  0xAA, 0x09, 0x70, 0xAA, 0x08, 0x2B, 0x03, 0x70, 0x5A, 0x81, 0xC0, 0x2B, 0x71, 0x02, 0xB1, 0x04,
  0xA0, 0xD7, 0x2B, 0x02, 0x05, 0xA0, 0xC7, 0x20, 0xEA, 0x03, 0x06, 0xA0, 0xB7, 0x20, 0xDA, 0x04,
  0x06, 0xA0, 0xB7, 0x20, 0xDA, 0x04, 0x05, 0xA0, 0xC7, 0x20, 0xEA, 0x03, 0x04, 0xA0, 0xD7, 0x2B,
  0x02, 0x01, 0xB7, 0x10, 0x2B, 0x20, 0xDA, 0x03, 0x70, 0x5A, 0x0C, 0x20, 0xAA, 0x08, 0x70, 0xAA,
  0x08, 0x20, 0x4A, 0x0E, 0x01, 0x50, 0x3B, 0x02, 0x30, 0xBA, 0x0C, 0x01, 0x30, 0x20, 0xDA, 0x0A,
  0x40, 0x20, 0xEB, 0x81, 0xB9, 0xBB, 0x0D, 0x01, 0x50, 0x30, 0xDF, 0x0D, 0x02, 0x71, 0x85, 0x7B,
  0xEF, 0xEB, 0x65,
  // "ŏ" (U+014F)
  0x20, 0x60, 0x74, 0x81, 0x27, 0x44, 0x81, 0xAF, 0x63, 0x81, 0x9F, 0x74, 0x06, 0xA8, 0x1B, 0x9C,
  0xA0, 0x25, 0x0D, 0xD0, 0x96, 0x84, 0x19, 0xEF, 0xD6, 0x77, 0x77, 0x58, 0x53, 0xAD, 0xFE, 0xA3,
  0x50, 0x6F, 0x06, 0x30, 0x4B, 0x81, 0xC9, 0xBB, 0x04, 0x20, 0xCA, 0x08, 0x30, 0x6A, 0x81, 0xD0,
  0x2A, 0x0E, 0x50, 0xCA, 0x03, 0x06, 0xA0, 0x95, 0x08, 0xA0, 0x70, 0x8A, 0x07, 0x50, 0x5A, 0x0A,
  0x09, 0xA0, 0x55, 0x04, 0xA0, 0xB0, 0xAA, 0x05, 0x50, 0x3A, 0x0C, 0x09, 0xA0, 0x55, 0x04, 0xA0,
  0xB0, 0x8A, 0x07, 0x50, 0x5A, 0x0A, 0x05, 0xA0, 0x95, 0x08, 0xA0, 0x70, 0x1A, 0x0E, 0x50, 0xCA,
  0x81, 0x30, 0xAA, 0x08, 0x30, 0x6A, 0x0C, 0x20, 0x2B, 0x81, 0xC9, 0xBB, 0x04, 0x30, 0x4F, 0x06,
  0x58, 0x52, 0xAE, 0xFE, 0xA3, 0x30,
  // "Ő" (U+0150)
  0x70, 0x9A, 0x81, 0x70, 0xCA, 0x04, 0x70, 0x1A, 0x81, 0xD0, 0x4A, 0x0A, 0x71, 0x86, 0x9F, 0xE2,
  0x0C, 0xFC, 0x71, 0x02, 0xA8, 0x43, 0x05, 0xFD, 0x17, 0x18, 0x1A, 0xE4, 0x28, 0x1D, 0xD2, 0x80,
  0xC6, 0x08, 0x61, 0x7B, 0xEF, 0xEB, 0x67, 0x10, 0x40, 0xEF, 0x0D, 0x02, 0x50, 0x30, 0xEB, 0x81,
  0xB9, 0xBB, 0x0D, 0x01, 0x40, 0xDA, 0x0C, 0x01, 0x30, 0x20, 0xDA, 0x0A, 0x30, 0x5A, 0x0E, 0x02,
  0x50, 0x2B, 0x02, 0x20, 0xAA, 0x09, 0x70, 0xAA, 0x08, 0x2B, 0x03, 0x70, 0x5A, 0x81, 0xC0, 0x2B,
  0x71, 0x02, 0xB1, 0x04, 0xA0, 0xD7, 0x2B, 0x02, 0x05, 0xA0, 0xC7, 0x20, 0xEA, 0x03, 0x06, 0xA0,
  0xB7, 0x20, 0xDA, 0x04, 0x06, 0xA0, 0xB7, 0x20, 0xDA, 0x04, 0x05, 0xA0, 0xC7, 0x20, 0xEA, 0x03,
  0x04, 0xA0, 0xD7, 0x2B, 0x02, 0x01, 0xB7, 0x10, 0x2B, 0x20, 0xDA, 0x03, 0x70, 0x5A, 0x0C, 0x20,
  0xAA, 0x08, 0x70, 0xAA, 0x08, 0x20, 0x4A, 0x0E, 0x01, 0x50, 0x3B, 0x02, 0x30, 0xBA, 0x0C, 0x01,
  0x30, 0x20, 0xDA, 0x0A, 0x40, 0x20, 0xEB, 0x81, 0xB9, 0xBB, 0x0D, 0x01, 0x50, 0x30, 0xDF, 0x0D,
  0x02, 0x71, 0x85, 0x7B, 0xEF, 0xEB, 0x65,
  // "ő" (U+0151)
  0x50, 0x9A, 0x81, 0x70, 0xCA, 0x04, 0x40, 0x1A, 0x81, 0xD0, 0x4A, 0x0A, 0x58, 0x69, 0xFE, 0x20,
  0xCF, 0xC5, 0x02, 0xA8, 0x43, 0x05, 0xFD, 0x15, 0x81, 0xAE, 0x42, 0x81, 0xDD, 0x27, 0x77, 0x76,
  0x85, 0x3A, 0xDF, 0xEA, 0x36, 0x06, 0xF0, 0x64, 0x04, 0xB8, 0x1C, 0x9B, 0xB0, 0x43, 0x0C, 0xA0,
  0x83, 0x06, 0xA0, 0xD2, 0x02, 0xA0, 0xE5, 0x0C, 0xA8, 0x13, 0x06, 0xA0, 0x95, 0x08, 0xA8, 0x17,
  0x08, 0xA0, 0x75, 0x05, 0xA8, 0x1A, 0x09, 0xA0, 0x55, 0x04, 0xA8, 0x1B, 0x0A, 0xA0, 0x55, 0x03,
  0xA8, 0x1C, 0x09, 0xA0, 0x55, 0x04, 0xA8, 0x1B, 0x08, 0xA0, 0x75, 0x05, 0xA8, 0x1A, 0x05, 0xA0,
  0x95, 0x08, 0xA8, 0x17, 0x01, 0xA0, 0xE5, 0x0C, 0xA0, 0x32, 0x0A, 0xA0, 0x83, 0x06, 0xA0, 0xC3,
  0x02, 0xB8, 0x1C, 0x9B, 0xB0, 0x44, 0x04, 0xF0, 0x66, 0x85, 0x2A, 0xEF, 0xEA, 0x34,
  // "Œ" (U+0152)
  0x58, 0x16, 0xBD, 0xFD, 0x30, 0x30, 0xDF, 0xF9, 0x20, 0x20, 0xEB, 0x82, 0xB9, 0x9E, 0xA0, 0xB8,
  0x01, 0x90, 0x82, 0x0B, 0xA0, 0xC0, 0x23, 0x0B, 0xA0, 0x47, 0x04, 0xA0, 0xE0, 0x24, 0x0B, 0xA0,
  0x47, 0x0A, 0xA0, 0x95, 0x0B, 0xA0, 0x47, 0x0E, 0xA0, 0x45, 0x0B, 0xA0, 0x46, 0x02, 0xB6, 0x0B,
  0xA0, 0x46, 0x04, 0xA0, 0xD6, 0x0B, 0xA0, 0x46, 0x05, 0xA0, 0xC6, 0x0B, 0xF9, 0x08, 0x06, 0xA0,
  0xB6, 0x0B, 0xF9, 0x08, 0x06, 0xA0, 0xB6, 0x0B, 0xA0, 0xB8, 0x01, 0x90, 0x40, 0x5A, 0x0C, 0x60,
  0xBA, 0x04, 0x60, 0x4A, 0x0D, 0x60, 0xBA, 0x04, 0x60, 0x2B, 0x60, 0xBA, 0x04, 0x70, 0xDA, 0x04,
  0x50, 0xBA, 0x04, 0x70, 0xAA, 0x09, 0x50, 0xBA, 0x04, 0x70, 0x4A, 0x0E, 0x02, 0x40, 0xBA, 0x04,
  0x71, 0x0C, 0xA0, 0xC0, 0x23, 0x0B, 0xA0, 0x47, 0x10, 0x20, 0xEB, 0x82, 0xB9, 0x9D, 0xA0, 0xB8,
  0x01, 0x90, 0x83, 0x03, 0x0D, 0xFF, 0x95, 0x81, 0x6B, 0xEF, 0xD0,
  // "œ" (U+0153)
  0x38, 0x53, 0xAD, 0xFD, 0x91, 0x38, 0x47, 0xDE, 0xDA, 0x25, 0x06, 0xE8, 0x2D, 0x20, 0xBE, 0x04,
  0x30, 0x4B, 0x81, 0xC9, 0xCA, 0x0C, 0x09, 0xA8, 0x1C, 0x9B, 0xA0, 0xE0, 0x12, 0x0C, 0xA0, 0x73,
  0x07, 0xC0, 0x93, 0x07, 0xA8, 0x18, 0x02, 0xA0, 0xD5, 0x0D, 0xA0, 0xE5, 0x83, 0xEF, 0xD0, 0x6A,
  0x09, 0x50, 0x9A, 0x0B, 0x50, 0xBA, 0x10, 0x8A, 0x07, 0x50, 0x6A, 0x0D, 0x80, 0x19, 0x0D, 0xA0,
  0x20, 0x9A, 0x05, 0x50, 0x5F, 0xC0, 0x30, 0xAA, 0x05, 0x50, 0x5F, 0xC0, 0x30, 0x9A, 0x05, 0x50,
  0x5A, 0x09, 0x72, 0x08, 0xA0, 0x75, 0x06, 0xA0, 0xB7, 0x20, 0x5A, 0x09, 0x50, 0x9A, 0x0E, 0x72,
  0x01, 0xA0, 0xE5, 0x0D, 0xB0, 0x47, 0x20, 0xBA, 0x08, 0x30, 0x7C, 0x0D, 0x02, 0x40, 0x30, 0x42,
  0x02, 0xB8, 0x1C, 0x9B, 0xA0, 0xD0, 0x8A, 0x85, 0xEA, 0x9A, 0xDF, 0x83, 0x05, 0xE8, 0x2E, 0x30,
  0xAF, 0x07, 0x48, 0x52, 0xAD, 0xFD, 0x91, 0x38, 0x55, 0xBE, 0xFE, 0xB5, 0x20,
  // "Ŕ" (U+0154)
  0x60, 0x5B, 0x03, 0x72, 0x0D, 0xA0, 0x87, 0x20, 0x6A, 0x0A, 0x72, 0x82, 0x1E, 0xFB, 0x73, 0x81,
  0xAF, 0xA7, 0x77, 0x77, 0x0A, 0xD8, 0x2E, 0xB7, 0x14, 0x0A, 0xF9, 0x0E, 0x04, 0x30, 0xAA, 0x82,
  0xB9, 0x9B, 0xB0, 0xE0, 0x12, 0x0A, 0xA0, 0x63, 0x02, 0x0E, 0xA0, 0x92, 0x0A, 0xA0, 0x64, 0x06,
  0xA0, 0xD2, 0x0A, 0xA0, 0x64, 0x02, 0xB2, 0x0A, 0xA0, 0x64, 0x01, 0xB2, 0x0A, 0xA0, 0x64, 0x02,
  0xA0, 0xE2, 0x0A, 0xA0, 0x64, 0x07, 0xA0, 0xB2, 0x0A, 0xA0, 0x63, 0x03, 0x0E, 0xA0, 0x52, 0x0A,
  0xA8, 0x2B, 0x99, 0xBB, 0x0A, 0x30, 0xAF, 0x90, 0x94, 0x0A, 0xF0, 0xB5, 0x0A, 0xA0, 0x62, 0x0E,
  0xA0, 0x34, 0x0A, 0xA0, 0x62, 0x07, 0xA0, 0xA4, 0x0A, 0xA0, 0x62, 0x01, 0x0E, 0xA0, 0x23, 0x0A,
  0xA0, 0x63, 0x08, 0xA0, 0xA3, 0x0A, 0xA0, 0x63, 0x01, 0xB0, 0x22, 0x0A, 0xA0, 0x64, 0x0A, 0xA0,
  0xA2, 0x0A, 0xA0, 0x64, 0x02, 0xB8, 0x12, 0x0A, 0xA0, 0x65, 0x0B, 0xA8, 0x1A, 0x0A, 0xA0, 0x65,
  0x04, 0xB0, 0x20,
  // "ŕ" (U+0155)
  0x40, 0x5B, 0x03, 0x40, 0xDA, 0x08, 0x40, 0x6A, 0x0A, 0x48, 0x21, 0xEF, 0xB5, 0x81, 0xAF, 0xA7,
  0x77, 0x18, 0x4E, 0xF6, 0x03, 0xBA, 0x83, 0x1E, 0xF9, 0x3B, 0x89, 0x2E, 0x0E, 0xFC, 0xDF, 0xC9,
  0x90, 0xEB, 0x07, 0x40, 0xEA, 0x0C, 0x50, 0xEA, 0x06, 0x50, 0xEA, 0x02, 0x50, 0xEA, 0x01, 0x50,
  0xEA, 0x60, 0xEA, 0x60, 0xEA, 0x60, 0xEA, 0x60, 0xEA, 0x60, 0xEA, 0x60, 0xEA, 0x60, 0xEA, 0x60,
  0xEA, 0x60,
  // "Ŗ" (U+0156)
  0x0A, 0xD8, 0x2E, 0xB7, 0x14, 0x0A, 0xF9, 0x0E, 0x04, 0x30, 0xAA, 0x82, 0xB9, 0x9B, 0xB0, 0xE0,
  0x12, 0x0A, 0xA0, 0x63, 0x02, 0x0E, 0xA0, 0x92, 0x0A, 0xA0, 0x64, 0x06, 0xA0, 0xD2, 0x0A, 0xA0,
  0x64, 0x02, 0xB2, 0x0A, 0xA0, 0x64, 0x01, 0xB2, 0x0A, 0xA0, 0x64, 0x02, 0xA0, 0xE2, 0x0A, 0xA0,
  0x64, 0x07, 0xA0, 0xB2, 0x0A, 0xA0, 0x63, 0x03, 0x0E, 0xA0, 0x52, 0x0A, 0xA8, 0x2B, 0x99, 0xBB,
  0x0A, 0x30, 0xAF, 0x90, 0x94, 0x0A, 0xF0, 0xB5, 0x0A, 0xA0, 0x62, 0x0E, 0xA0, 0x34, 0x0A, 0xA0,
  0x62, 0x07, 0xA0, 0xA4, 0x0A, 0xA0, 0x62, 0x01, 0x0E, 0xA0, 0x23, 0x0A, 0xA0, 0x63, 0x08, 0xA0,
  0xA3, 0x0A, 0xA0, 0x63, 0x01, 0xB0, 0x22, 0x0A, 0xA0, 0x64, 0x0A, 0xA0, 0xA2, 0x0A, 0xA0, 0x64,
  0x02, 0xB8, 0x12, 0x0A, 0xA0, 0x65, 0x0B, 0xA8, 0x1A, 0x0A, 0xA0, 0x65, 0x04, 0xB0, 0x27, 0x77,
  0x74, 0x04, 0xA0, 0xA7, 0x30, 0x6A, 0x05, 0x73, 0x81, 0x9F, 0xE7, 0x48, 0x1C, 0xF7, 0x73, 0x81,
  0x1F, 0xD7, 0x10,
  // "ŗ" (U+0157)
  0x18, 0x4E, 0xF6, 0x03, 0xBA, 0x84, 0x10, 0xEF, 0x93, 0xB0, 0xE2, 0x86, 0xEF, 0xCD, 0xFC, 0x99,
  0x20, 0xEB, 0x07, 0x50, 0xEA, 0x0C, 0x60, 0xEA, 0x06, 0x60, 0xEA, 0x02, 0x60, 0xEA, 0x01, 0x60,
  0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70, 0xEA, 0x70,
  0xEA, 0x77, 0x76, 0x04, 0xA0, 0xA6, 0x06, 0xA0, 0x56, 0x81, 0x9F, 0xE7, 0x81, 0xCF, 0x76, 0x81,
  0x1F, 0xD7,
  // "Ř" (U+0158)
  0x18, 0x1A, 0xF8, 0x38, 0x22, 0xDF, 0x24, 0x87, 0x1E, 0xF7, 0x02, 0xEF, 0x66, 0x04, 0xA8, 0x27,
  0xDF, 0xB7, 0x10, 0x9B, 0x0E, 0x01, 0x71, 0x01, 0x0E, 0xA0, 0x77, 0x77, 0x76, 0x0A, 0xD8, 0x2E,
  0xB7, 0x14, 0x0A, 0xF9, 0x0E, 0x04, 0x30, 0xAA, 0x82, 0xB9, 0x9B, 0xB0, 0xE0, 0x12, 0x0A, 0xA0,
  0x63, 0x02, 0x0E, 0xA0, 0x92, 0x0A, 0xA0, 0x64, 0x06, 0xA0, 0xD2, 0x0A, 0xA0, 0x64, 0x02, 0xB2,
  0x0A, 0xA0, 0x64, 0x01, 0xB2, 0x0A, 0xA0, 0x64, 0x02, 0xA0, 0xE2, 0x0A, 0xA0, 0x64, 0x07, 0xA0,
  0xB2, 0x0A, 0xA0, 0x63, 0x03, 0x0E, 0xA0, 0x52, 0x0A, 0xA8, 0x2B, 0x99, 0xBB, 0x0A, 0x30, 0xAF,
  0x90, 0x94, 0x0A, 0xF0, 0xB5, 0x0A, 0xA0, 0x62, 0x0E, 0xA0, 0x34, 0x0A, 0xA0, 0x62, 0x07, 0xA0,
  0xA4, 0x0A, 0xA0, 0x62, 0x01, 0x0E, 0xA0, 0x23, 0x0A, 0xA0, 0x63, 0x08, 0xA0, 0xA3, 0x0A, 0xA0,
  0x63, 0x01, 0xB0, 0x22, 0x0A, 0xA0, 0x64, 0x0A, 0xA0, 0xA2, 0x0A, 0xA0, 0x64, 0x02, 0xB8, 0x12,
  0x0A, 0xA0, 0x65, 0x0B, 0xA8, 0x1A, 0x0A, 0xA0, 0x65, 0x04, 0xB0, 0x20,
  // "ř" (U+0159)
  0x81, 0xAF, 0x83, 0x89, 0x32, 0xDF, 0x21, 0xEF, 0x70, 0x2E, 0xF6, 0x20, 0x4A, 0x82, 0x7D, 0xFB,
  0x40, 0x9B, 0x0E, 0x01, 0x40, 0x10, 0xEA, 0x07, 0x77, 0x73, 0x84, 0xEF, 0x60, 0x3B, 0xA8, 0x41,
  0x0E, 0xF9, 0x3B, 0x0E, 0x28, 0x6E, 0xFC, 0xDF, 0xC9, 0x92, 0x0E, 0xB0, 0x75, 0x0E, 0xA0, 0xC6,
  0x0E, 0xA0, 0x66, 0x0E, 0xA0, 0x26, 0x0E, 0xA0, 0x16, 0x0E, 0xA7, 0x0E, 0xA7, 0x0E, 0xA7, 0x0E,
  0xA7, 0x0E, 0xA7, 0x0E, 0xA7, 0x0E, 0xA7, 0x0E, 0xA7, 0x0E, 0xA6,
  // "Ś" (U+015A)
  0x60, 0x5B, 0x03, 0x70, 0xDA, 0x08, 0x70, 0x6A, 0x0A, 0x78, 0x21, 0xEF, 0xB7, 0x18, 0x1A, 0xFA,
  0x77, 0x77, 0x48, 0x65, 0xBD, 0xFE, 0xC8, 0x33, 0x0B, 0xF9, 0x81, 0x30, 0xAB, 0x86, 0xB9, 0xAE,
  0xFE, 0x02, 0xB0, 0x44, 0x82, 0x57, 0x07, 0xA0, 0xA7, 0x10, 0x9A, 0x07, 0x71, 0x08, 0xA0, 0x97,
  0x10, 0x6A, 0x0E, 0x02, 0x70, 0x1B, 0x0E, 0x05, 0x70, 0x8C, 0x0B, 0x03, 0x60, 0x8D, 0x09, 0x60,
  0x40, 0xDC, 0x0C, 0x01, 0x60, 0x60, 0xDB, 0x0B, 0x71, 0x0A, 0xB0, 0x37, 0x10, 0xDA, 0x07, 0x71,
  0x08, 0xA0, 0x97, 0x10, 0x7A, 0x08, 0x71, 0x0B, 0xA8, 0x15, 0x96, 0x50, 0x6A, 0x87, 0xE0, 0xCF,
  0xEB, 0x99, 0xCB, 0x81, 0x70, 0xCF, 0x90, 0x82, 0x87, 0x27, 0xBD, 0xEF, 0xD9, 0x33,
  // "ś" (U+015B)
  0x50, 0x5B, 0x03, 0x50, 0xDA, 0x08, 0x50, 0x6A, 0x0A, 0x58, 0x21, 0xEF, 0xB6, 0x81, 0xAF, 0xA7,
  0x77, 0x58, 0x56, 0xCE, 0xFD, 0xA4, 0x20, 0xBF, 0x05, 0x07, 0xB8, 0x5A, 0x9B, 0xFE, 0x0C, 0xA0,
  0x43, 0x82, 0x25, 0x0D, 0xA7, 0x0B, 0xA0, 0x56, 0x06, 0xB0, 0x86, 0x0B, 0xB0, 0xE0, 0x55, 0x08,
  0xC0, 0xB5, 0x02, 0x0B, 0xB0, 0xC6, 0x05, 0x0E, 0xA0, 0x66, 0x07, 0xA0, 0x96, 0x04, 0xA8, 0x1A,
  0x82, 0x40, 0xAA, 0x85, 0x8D, 0xFC, 0x99, 0xCB, 0x03, 0x0D, 0xF8, 0x90, 0x70, 0x38, 0xCE, 0xFE,
  0xA4, 0x20,
  // "Ŝ" (U+015C)
  0x30, 0x10, 0xEA, 0x06, 0x70, 0x9B, 0x0E, 0x01, 0x50, 0x3A, 0x82, 0x8E, 0xFA, 0x58, 0x6D, 0xF8,
  0x03, 0xEF, 0x53, 0x81, 0x9F, 0x83, 0x82, 0x2E, 0xE2, 0x77, 0x77, 0x86, 0x5B, 0xDF, 0xEC, 0x83,
  0x30, 0xBF, 0x98, 0x13, 0x0A, 0xB8, 0x6B, 0x9A, 0xEF, 0xE0, 0x2B, 0x04, 0x48, 0x25, 0x70, 0x7A,
  0x0A, 0x71, 0x09, 0xA0, 0x77, 0x10, 0x8A, 0x09, 0x71, 0x06, 0xA0, 0xE0, 0x27, 0x01, 0xB0, 0xE0,
  0x57, 0x08, 0xC0, 0xB0, 0x36, 0x08, 0xD0, 0x96, 0x04, 0x0D, 0xC0, 0xC0, 0x16, 0x06, 0x0D, 0xB0,
  0xB7, 0x10, 0xAB, 0x03, 0x71, 0x0D, 0xA0, 0x77, 0x10, 0x8A, 0x09, 0x71, 0x07, 0xA0, 0x87, 0x10,
  0xBA, 0x81, 0x59, 0x65, 0x06, 0xA8, 0x7E, 0x0C, 0xFE, 0xB9, 0x9C, 0xB8, 0x17, 0x0C, 0xF9, 0x08,
  0x28, 0x72, 0x7B, 0xDE, 0xFD, 0x93, 0x30,
  // "ŝ" (U+015D)
  0x20, 0x10, 0xEA, 0x06, 0x50, 0x9B, 0x0E, 0x01, 0x30, 0x3A, 0x82, 0x8E, 0xFA, 0x38, 0x92, 0xDF,
  0x80, 0x3E, 0xF5, 0x09, 0xF8, 0x38, 0x22, 0xEE, 0x27, 0x77, 0x18, 0x56, 0xCE, 0xFD, 0xA4, 0x20,
  0xBF, 0x05, 0x07, 0xB8, 0x5A, 0x9B, 0xFE, 0x0C, 0xA0, 0x43, 0x82, 0x25, 0x0D, 0xA7, 0x0B, 0xA0,
  0x56, 0x06, 0xB0, 0x86, 0x0B, 0xB0, 0xE0, 0x55, 0x08, 0xC0, 0xB5, 0x02, 0x0B, 0xB0, 0xC6, 0x05,
  0x0E, 0xA0, 0x66, 0x07, 0xA0, 0x96, 0x04, 0xA8, 0x1A, 0x82, 0x40, 0xAA, 0x85, 0x8D, 0xFC, 0x99,
  0xCB, 0x03, 0x0D, 0xF8, 0x90, 0x70, 0x38, 0xCE, 0xFE, 0xA4, 0x20,
  // "Ş" (U+015E)
  0x38, 0x65, 0xBD, 0xFE, 0xC8, 0x33, 0x0B, 0xF9, 0x81, 0x30, 0xAB, 0x86, 0xB9, 0xAE, 0xFE, 0x02,
  0xB0, 0x44, 0x82, 0x57, 0x07, 0xA0, 0xA7, 0x10, 0x9A, 0x07, 0x71, 0x08, 0xA0, 0x97, 0x10, 0x6A,
  0x0E, 0x02, 0x70, 0x1B, 0x0E, 0x05, 0x70, 0x8C, 0x0B, 0x03, 0x60, 0x8D, 0x09, 0x60, 0x40, 0xDC,
  0x0C, 0x01, 0x60, 0x60, 0xDB, 0x0B, 0x71, 0x0A, 0xB0, 0x37, 0x10, 0xDA, 0x07, 0x71, 0x08, 0xA0,
  0x97, 0x10, 0x7A, 0x08, 0x71, 0x0B, 0xA8, 0x15, 0x96, 0x50, 0x6A, 0x87, 0xE0, 0xCF, 0xEB, 0x99,
  0xCB, 0x81, 0x70, 0xCF, 0x90, 0x82, 0x82, 0x27, 0xBD, 0xB0, 0x90, 0x37, 0x81, 0x5F, 0x67, 0x28,
  0x2C, 0xFD, 0x67, 0x10, 0x20, 0x8A, 0x06, 0x72, 0x81, 0xBF, 0xA7, 0x18, 0x21, 0xDF, 0x96, 0x00,
  0xDB, 0x03, 0x68, 0x3C, 0xFE, 0xB3, 0x40,
  // "ş" (U+015F)
  0x28, 0x56, 0xCE, 0xFD, 0xA4, 0x20, 0xBF, 0x05, 0x07, 0xB8, 0x5A, 0x9B, 0xFE, 0x0C, 0xA0, 0x43,
  0x82, 0x25, 0x0D, 0xA7, 0x0B, 0xA0, 0x56, 0x06, 0xB0, 0x86, 0x0B, 0xB0, 0xE0, 0x55, 0x08, 0xC0,
  0xB5, 0x02, 0x0B, 0xB0, 0xC6, 0x05, 0x0E, 0xA0, 0x66, 0x07, 0xA0, 0x96, 0x04, 0xA8, 0x1A, 0x82,
  0x40, 0xAA, 0x85, 0x8D, 0xFC, 0x99, 0xCB, 0x03, 0x0D, 0xF8, 0x37, 0x03, 0x8C, 0xB0, 0xA0, 0x45,
  0x81, 0x5F, 0x67, 0x82, 0xCF, 0xD6, 0x60, 0x20, 0x8A, 0x06, 0x78, 0x1B, 0xFA, 0x68, 0x21, 0xDF,
  0x94, 0x00, 0xDB, 0x03, 0x48, 0x3C, 0xFE, 0xB3, 0x30,
  // "Š" (U+0160)
  0x18, 0x1A, 0xF8, 0x38, 0x22, 0xDF, 0x22, 0x87, 0x1E, 0xF7, 0x02, 0xEF, 0x64, 0x04, 0xA8, 0x27,
  0xDF, 0xB6, 0x09, 0xB0, 0xE0, 0x16, 0x01, 0x0E, 0xA0, 0x77, 0x77, 0x73, 0x86, 0x5B, 0xDF, 0xEC,
  0x83, 0x30, 0xBF, 0x98, 0x13, 0x0A, 0xB8, 0x6B, 0x9A, 0xEF, 0xE0, 0x2B, 0x04, 0x48, 0x25, 0x70,
  0x7A, 0x0A, 0x71, 0x09, 0xA0, 0x77, 0x10, 0x8A, 0x09, 0x71, 0x06, 0xA0, 0xE0, 0x27, 0x01, 0xB0,
  0xE0, 0x57, 0x08, 0xC0, 0xB0, 0x36, 0x08, 0xD0, 0x96, 0x04, 0x0D, 0xC0, 0xC0, 0x16, 0x06, 0x0D,
  0xB0, 0xB7, 0x10, 0xAB, 0x03, 0x71, 0x0D, 0xA0, 0x77, 0x10, 0x8A, 0x09, 0x71, 0x07, 0xA0, 0x87,
  0x10, 0xBA, 0x81, 0x59, 0x65, 0x06, 0xA8, 0x7E, 0x0C, 0xFE, 0xB9, 0x9C, 0xB8, 0x17, 0x0C, 0xF9,
  0x08, 0x28, 0x72, 0x7B, 0xDE, 0xFD, 0x93, 0x30,
  // "š" (U+0161)
  0x81, 0xAF, 0x83, 0x89, 0x32, 0xDF, 0x21, 0xEF, 0x70, 0x2E, 0xF6, 0x20, 0x4A, 0x82, 0x7D, 0xFB,
  0x40, 0x9B, 0x0E, 0x01, 0x40, 0x10, 0xEA, 0x07, 0x77, 0x74, 0x85, 0x6C, 0xEF, 0xDA, 0x42, 0x0B,
  0xF0, 0x50, 0x7B, 0x85, 0xA9, 0xBF, 0xE0, 0xCA, 0x04, 0x38, 0x22, 0x50, 0xDA, 0x70, 0xBA, 0x05,
  0x60, 0x6B, 0x08, 0x60, 0xBB, 0x0E, 0x05, 0x50, 0x8C, 0x0B, 0x50, 0x20, 0xBB, 0x0C, 0x60, 0x50,
  0xEA, 0x06, 0x60, 0x7A, 0x09, 0x60, 0x4A, 0x81, 0xA8, 0x24, 0x0A, 0xA8, 0x58, 0xDF, 0xC9, 0x9C,
  0xB0, 0x30, 0xDF, 0x89, 0x07, 0x03, 0x8C, 0xEF, 0xEA, 0x42,
  // "Ţ" (U+0162)
  0x09, 0xFD, 0x09, 0xFD, 0x84, 0x59, 0x99, 0x9E, 0xA8, 0x3A, 0x99, 0x98, 0x50, 0xDA, 0x02, 0x72,
  0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0,
  0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20,
  0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02,
  0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x81,
  0x5F, 0x67, 0x38, 0x2C, 0xFD, 0x67, 0x20, 0x20, 0x8A, 0x06, 0x73, 0x81, 0xBF, 0xA7, 0x28, 0x21,
  0xDF, 0x97, 0x00, 0xDB, 0x03, 0x78, 0x3C, 0xFE, 0xB3, 0x40,
  // "ţ" (U+0163)
  0x38, 0x16, 0x71, 0x6A, 0x02, 0x50, 0x3A, 0x02, 0x50, 0x7A, 0x02, 0x38, 0x11, 0x8E, 0xD0, 0x08,
  0xF8, 0x28, 0x49, 0xEA, 0x82, 0xA9, 0x94, 0x20, 0xCA, 0x02, 0x50, 0xCA, 0x02, 0x50, 0xCA, 0x02,
  0x50, 0xCA, 0x02, 0x50, 0xCA, 0x02, 0x50, 0xCA, 0x02, 0x50, 0xCA, 0x02, 0x50, 0xCA, 0x02, 0x50,
  0xCA, 0x02, 0x50, 0xBA, 0x03, 0x50, 0xAA, 0x07, 0x50, 0x7B, 0x81, 0xAA, 0x92, 0x01, 0x0E, 0xC0,
  0xA3, 0x02, 0x0B, 0xA0, 0xC0, 0x64, 0x81, 0x5F, 0x66, 0x82, 0xCF, 0xD6, 0x50, 0x20, 0x8A, 0x06,
  0x68, 0x1B, 0xFA, 0x58, 0x21, 0xDF, 0x93, 0x00, 0xDB, 0x03, 0x38, 0x3C, 0xFE, 0xB3, 0x10,
  // "Ť" (U+0164)
  0x28, 0x1A, 0xF8, 0x38, 0x22, 0xDF, 0x23, 0x87, 0x1E, 0xF7, 0x02, 0xEF, 0x65, 0x04, 0xA8, 0x27,
  0xDF, 0xB7, 0x09, 0xB0, 0xE0, 0x17, 0x01, 0x0E, 0xA0, 0x77, 0x77, 0x72, 0x09, 0xFD, 0x09, 0xFD,
  0x84, 0x59, 0x99, 0x9E, 0xA8, 0x3A, 0x99, 0x98, 0x50, 0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20,
  0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02,
  0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D,
  0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27,
  0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x40,
  // "ť" (U+0165)
  0x72, 0x03, 0xA0, 0xA7, 0x20, 0x5A, 0x06, 0x38, 0x16, 0x71, 0x38, 0x18, 0xFE, 0x4A, 0x02, 0x38,
  0x1B, 0xF8, 0x30, 0x3A, 0x02, 0x38, 0x1D, 0xE1, 0x30, 0x7A, 0x02, 0x78, 0x11, 0x8E, 0xD0, 0x84,
  0x08, 0xF0, 0x84, 0x81, 0x49, 0xEA, 0x82, 0xA9, 0x94, 0x60, 0xCA, 0x02, 0x72, 0x0C, 0xA0, 0x27,
  0x20, 0xCA, 0x02, 0x72, 0x0C, 0xA0, 0x27, 0x20, 0xCA, 0x02, 0x72, 0x0C, 0xA0, 0x27, 0x20, 0xCA,
  0x02, 0x72, 0x0C, 0xA0, 0x27, 0x20, 0xCA, 0x02, 0x72, 0x0B, 0xA0, 0x37, 0x20, 0xAA, 0x07, 0x72,
  0x07, 0xB8, 0x1A, 0xA9, 0x60, 0x10, 0xEC, 0x0A, 0x78, 0x42, 0xBE, 0xEC, 0x64,
  // "Ŧ" (U+0166)
  0x09, 0xFD, 0x09, 0xFD, 0x84, 0x59, 0x99, 0x9E, 0xA8, 0x3A, 0x99, 0x98, 0x50, 0xDA, 0x02, 0x72,
  0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0,
  0x25, 0x83, 0x19, 0x99, 0xEA, 0x82, 0xA9, 0x94, 0x20, 0x2F, 0xA0, 0x72, 0x02, 0xFA, 0x07, 0x60,
  0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02,
  0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D, 0xA0, 0x27, 0x20, 0xDA, 0x02, 0x72, 0x0D,
  0xA0, 0x24,
  // "ŧ" (U+0167)
  0x38, 0x16, 0x71, 0x6A, 0x02, 0x50, 0x3A, 0x02, 0x50, 0x7A, 0x02, 0x38, 0x11, 0x8E, 0xD0, 0x08,
  0xF8, 0x28, 0x49, 0xEA, 0x82, 0xA9, 0x94, 0x20, 0xCA, 0x02, 0x50, 0xCA, 0x02, 0x50, 0xCA, 0x02,
  0x30, 0x6F, 0x04, 0x06, 0xF8, 0x24, 0x39, 0xEA, 0x82, 0xA9, 0x92, 0x20, 0xCA, 0x02, 0x50, 0xCA,
  0x02, 0x50, 0xCA, 0x02, 0x50, 0xBA, 0x03, 0x50, 0xAA, 0x07, 0x50, 0x7B, 0x81, 0xAA, 0x92, 0x01,
  0x0E, 0xC0, 0xA3, 0x84, 0x2B, 0xEE, 0xC6,
  // "Ũ" (U+0168)
  0x38, 0x35, 0xEE, 0x92, 0x20, 0xD0, 0xE4, 0x02, 0xD8, 0x2A, 0xBF, 0xB4, 0x83, 0x7F, 0xCA, 0xEC,
  0x05, 0x48, 0x7A, 0xF1, 0x01, 0x8D, 0xE8, 0x77, 0x77, 0x30, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D,
  0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0,
  0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A,
  0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0,
  0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A,
  0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0C, 0xA0, 0x46, 0x06,
  0xA0, 0x90, 0xAA, 0x06, 0x60, 0x8A, 0x08, 0x07, 0xA0, 0xB6, 0x0D, 0xA0, 0x40, 0x1B, 0x06, 0x40,
  0x8A, 0x0E, 0x20, 0x8B, 0x82, 0xC9, 0x9D, 0xB0, 0x63, 0x0A, 0xF9, 0x08, 0x58, 0x64, 0xAD, 0xFE,
  0xD9, 0x33,
  // "ũ" (U+0169)
  0x28, 0x35, 0xEE, 0x92, 0x20, 0xD0, 0xE2, 0x02, 0xD8, 0x2A, 0xBF, 0xB2, 0x83, 0x7F, 0xCA, 0xEC,
  0x05, 0x28, 0x7A, 0xF1, 0x01, 0x8D, 0xE8, 0x77, 0x75, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50,
  0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A,
  0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07,
  0xA0, 0x7A, 0x0E, 0x50, 0x8A, 0x07, 0xA0, 0xE5, 0x09, 0xA0, 0x7B, 0x50, 0xBA, 0x07, 0x0E, 0xA0,
  0x33, 0x01, 0xB0, 0x70, 0xBA, 0x0A, 0x30, 0x9B, 0x07, 0x06, 0xB8, 0x3C, 0xAD, 0xFD, 0xA8, 0x17,
  0x0C, 0xD0, 0xD0, 0x2A, 0x07, 0x28, 0x48, 0xDF, 0xD8, 0x11, 0xA0, 0x70,
  // "Ū" (U+016A)
  0x30, 0x78, 0x03, 0x90, 0x25, 0x0C, 0xF0, 0x45, 0x0C, 0xF0, 0x47, 0x77, 0x72, 0x0D, 0xA0, 0x36,
  0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03,
  0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0,
  0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA,
  0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D,
  0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0,
  0xCA, 0x04, 0x60, 0x6A, 0x09, 0x0A, 0xA0, 0x66, 0x08, 0xA0, 0x80, 0x7A, 0x0B, 0x60, 0xDA, 0x04,
  0x01, 0xB0, 0x64, 0x08, 0xA0, 0xE2, 0x08, 0xB8, 0x2C, 0x99, 0xDB, 0x06, 0x30, 0xAF, 0x90, 0x85,
  0x86, 0x4A, 0xDF, 0xED, 0x93, 0x30,
  // "ū" (U+016B)
  0x20, 0x78, 0x03, 0x90, 0x23, 0x0C, 0xF0, 0x43, 0x0C, 0xF0, 0x47, 0x77, 0x4A, 0x0E, 0x50, 0x7A,
  0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E,
  0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0,
  0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x08, 0xA0, 0x7A, 0x0E, 0x50, 0x9A, 0x07, 0xB5, 0x0B,
  0xA0, 0x70, 0xEA, 0x03, 0x30, 0x1B, 0x07, 0x0B, 0xA0, 0xA3, 0x09, 0xB0, 0x70, 0x6B, 0x83, 0xCA,
  0xDF, 0xDA, 0x81, 0x70, 0xCD, 0x0D, 0x02, 0xA0, 0x72, 0x84, 0x8D, 0xFD, 0x81, 0x1A, 0x07,
  // "Ŭ" (U+016C)
  0x30, 0x60, 0x74, 0x81, 0x27, 0x45, 0x81, 0xAF, 0x63, 0x81, 0x9F, 0x75, 0x06, 0xA8, 0x1B, 0x9C,
  0xA0, 0x26, 0x0D, 0xD0, 0x97, 0x84, 0x19, 0xEF, 0xD6, 0x77, 0x77, 0x40, 0xDA, 0x03, 0x60, 0x5A,
  0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05,
  0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60,
  0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36,
  0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03,
  0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0C, 0xA0,
  0x46, 0x06, 0xA0, 0x90, 0xAA, 0x06, 0x60, 0x8A, 0x08, 0x07, 0xA0, 0xB6, 0x0D, 0xA0, 0x40, 0x1B,
  0x06, 0x40, 0x8A, 0x0E, 0x20, 0x8B, 0x82, 0xC9, 0x9D, 0xB0, 0x63, 0x0A, 0xF9, 0x08, 0x58, 0x64,
  0xAD, 0xFE, 0xD9, 0x33,
  // "ŭ" (U+016D)
  0x10, 0x60, 0x74, 0x81, 0x27, 0x43, 0x81, 0xAF, 0x63, 0x81, 0x9F, 0x73, 0x06, 0xA8, 0x1B, 0x9C,
  0xA0, 0x24, 0x0D, 0xD0, 0x95, 0x84, 0x19, 0xEF, 0xD6, 0x77, 0x77, 0xA0, 0xE5, 0x07, 0xA0, 0x7A,
  0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07,
  0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0,
  0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x8A, 0x07, 0xA0, 0xE5, 0x09, 0xA0, 0x7B, 0x50, 0xBA, 0x07,
  0x0E, 0xA0, 0x33, 0x01, 0xB0, 0x70, 0xBA, 0x0A, 0x30, 0x9B, 0x07, 0x06, 0xB8, 0x3C, 0xAD, 0xFD,
  0xA8, 0x17, 0x0C, 0xD0, 0xD0, 0x2A, 0x07, 0x28, 0x48, 0xDF, 0xD8, 0x11, 0xA0, 0x70,
  // "Ů" (U+016E)
  0x48, 0x33, 0xAC, 0xA2, 0x71, 0x02, 0xC0, 0xE0, 0x27, 0x85, 0x9F, 0x60, 0x6F, 0x97, 0x0B, 0x93,
  0x90, 0xB7, 0x85, 0xAF, 0x30, 0x4F, 0x97, 0x03, 0xA0, 0xDA, 0x03, 0x71, 0x83, 0x5C, 0xEC, 0x47,
  0x77, 0x75, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36,
  0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03,
  0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0,
  0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA,
  0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D,
  0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xCA, 0x04, 0x60, 0x6A, 0x09, 0x0A, 0xA0, 0x66, 0x08, 0xA0, 0x80,
  0x7A, 0x0B, 0x60, 0xDA, 0x04, 0x01, 0xB0, 0x64, 0x08, 0xA0, 0xE2, 0x08, 0xB8, 0x2C, 0x99, 0xDB,
  0x06, 0x30, 0xAF, 0x90, 0x85, 0x86, 0x4A, 0xDF, 0xED, 0x93, 0x30,
  // "ů" (U+016F)
  0x38, 0x33, 0xAC, 0xA2, 0x60, 0x2C, 0x0E, 0x02, 0x58, 0x59, 0xF6, 0x06, 0xF9, 0x50, 0xB9, 0x39,
  0x0B, 0x58, 0x5A, 0xF3, 0x04, 0xF9, 0x50, 0x3A, 0x0D, 0xA0, 0x36, 0x83, 0x5C, 0xEC, 0x47, 0x77,
  0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5,
  0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07,
  0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x08, 0xA0, 0x7A, 0x0E, 0x50,
  0x9A, 0x07, 0xB5, 0x0B, 0xA0, 0x70, 0xEA, 0x03, 0x30, 0x1B, 0x07, 0x0B, 0xA0, 0xA3, 0x09, 0xB0,
  0x70, 0x6B, 0x83, 0xCA, 0xDF, 0xDA, 0x81, 0x70, 0xCD, 0x0D, 0x02, 0xA0, 0x72, 0x84, 0x8D, 0xFD,
  0x81, 0x1A, 0x07,
  // "Ű" (U+0170)
  0x50, 0x9A, 0x81, 0x70, 0xCA, 0x04, 0x40, 0x1A, 0x81, 0xD0, 0x4A, 0x0A, 0x58, 0x69, 0xFE, 0x20,
  0xCF, 0xC5, 0x02, 0xA8, 0x43, 0x05, 0xFD, 0x15, 0x81, 0xAE, 0x42, 0x81, 0xDD, 0x27, 0x77, 0x73,
  0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0,
  0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A,
  0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05,
  0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60,
  0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36,
  0x05, 0xA0, 0xA0, 0xCA, 0x04, 0x60, 0x6A, 0x09, 0x0A, 0xA0, 0x66, 0x08, 0xA0, 0x80, 0x7A, 0x0B,
  0x60, 0xDA, 0x04, 0x01, 0xB0, 0x64, 0x08, 0xA0, 0xE2, 0x08, 0xB8, 0x2C, 0x99, 0xDB, 0x06, 0x30,
  0xAF, 0x90, 0x85, 0x86, 0x4A, 0xDF, 0xED, 0x93, 0x30,
  // "ű" (U+0171)
  0x40, 0x9A, 0x81, 0x70, 0xCA, 0x04, 0x30, 0x1A, 0x81, 0xD0, 0x4A, 0x0A, 0x48, 0x69, 0xFE, 0x20,
  0xCF, 0xC4, 0x02, 0xA8, 0x43, 0x05, 0xFD, 0x14, 0x81, 0xAE, 0x42, 0x81, 0xDD, 0x27, 0x77, 0x71,
  0xA0, 0xE5, 0x07, 0xA0, 0x71, 0xA0, 0xE5, 0x07, 0xA0, 0x71, 0xA0, 0xE5, 0x07, 0xA0, 0x71, 0xA0,
  0xE5, 0x07, 0xA0, 0x71, 0xA0, 0xE5, 0x07, 0xA0, 0x71, 0xA0, 0xE5, 0x07, 0xA0, 0x71, 0xA0, 0xE5,
  0x07, 0xA0, 0x71, 0xA0, 0xE5, 0x07, 0xA0, 0x71, 0xA0, 0xE5, 0x07, 0xA0, 0x71, 0xA0, 0xE5, 0x08,
  0xA0, 0x71, 0xA0, 0xE5, 0x09, 0xA0, 0x71, 0xB5, 0x0B, 0xA8, 0x17, 0x0E, 0xA0, 0x33, 0x01, 0xB8,
  0x17, 0x0B, 0xA0, 0xA3, 0x09, 0xB8, 0x17, 0x06, 0xB8, 0x3C, 0xAD, 0xFD, 0xA0, 0x72, 0x0C, 0xD0,
  0xD0, 0x2A, 0x07, 0x38, 0x48, 0xDF, 0xD8, 0x11, 0xA0, 0x71,
  // "Ų" (U+0172)
  0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0,
  0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A,
  0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05,
  0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60,
  0x5A, 0x0A, 0x0D, 0xA0, 0x36, 0x05, 0xA0, 0xA0, 0xDA, 0x03, 0x60, 0x5A, 0x0A, 0x0D, 0xA0, 0x36,
  0x05, 0xA0, 0xA0, 0xCA, 0x04, 0x60, 0x6A, 0x09, 0x0A, 0xA0, 0x66, 0x08, 0xA0, 0x07, 0xA0, 0xB6,
  0x0D, 0xA0, 0x40, 0x1B, 0x06, 0x40, 0x8A, 0x0D, 0x20, 0x8B, 0x82, 0xC9, 0x9D, 0xB0, 0x53, 0x0A,
  0xF9, 0x06, 0x58, 0x14, 0xAD, 0xC0, 0x87, 0x38, 0x12, 0xEB, 0x74, 0x81, 0xCF, 0x27, 0x38, 0x14,
  0xFD, 0x74, 0x81, 0x7F, 0xE7, 0x40, 0x6A, 0x81, 0xB9, 0x37, 0x10, 0x2C, 0x05, 0x72, 0x83, 0x5C,
  0xFD, 0x32,
  // "ų" (U+0173)
  0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50,
  0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A,
  0x0E, 0x50, 0x7A, 0x07, 0xA0, 0xE5, 0x07, 0xA0, 0x7A, 0x0E, 0x50, 0x8A, 0x07, 0xA0, 0xE5, 0x09,
  0xA0, 0x7B, 0x50, 0xBA, 0x07, 0x0E, 0xA0, 0x33, 0x01, 0xB0, 0x70, 0xBA, 0x0A, 0x30, 0x9B, 0x07,
  0x06, 0xB8, 0x3C, 0xAD, 0xFD, 0xA8, 0x17, 0x0C, 0xD0, 0xD0, 0x2A, 0x07, 0x28, 0x48, 0xDF, 0xD8,
  0x11, 0xA0, 0x97, 0x18, 0x17, 0xF8, 0x71, 0x81, 0x2F, 0xD7, 0x28, 0x18, 0xF9, 0x72, 0x81, 0xBF,
  0x97, 0x20, 0xAA, 0x0A, 0x09, 0x70, 0x6C, 0x71, 0x82, 0x7D, 0xFC,
  // "Ŵ" (U+0174)
  0x72, 0x01, 0x0E, 0xA0, 0x67, 0x75, 0x09, 0xB0, 0xE0, 0x17, 0x73, 0x03, 0xA8, 0x28, 0xEF, 0xA7,
  0x73, 0x86, 0xDF, 0x80, 0x3E, 0xF5, 0x77, 0x18, 0x19, 0xF8, 0x38, 0x22, 0xEE, 0x28, 0x0E, 0x30,
  0x0B, 0xA0, 0x46, 0x09, 0xA0, 0x76, 0x06, 0xA0, 0xA0, 0x8A, 0x07, 0x60, 0xCA, 0x0A, 0x60, 0x9A,
  0x06, 0x04, 0xA0, 0xB6, 0xB0, 0xE6, 0x0D, 0xA0, 0x30, 0x1A, 0x0E, 0x50, 0x3C, 0x02, 0x5B, 0x20,
  0xDA, 0x01, 0x48, 0x17, 0xFE, 0xA0, 0x54, 0x03, 0xA0, 0xC2, 0x0A, 0xA0, 0x54, 0x84, 0xAF, 0xCE,
  0xF8, 0x40, 0x7A, 0x09, 0x20, 0x6A, 0x08, 0x48, 0x4D, 0xF9, 0xCF, 0xC4, 0x0A, 0xA0, 0x52, 0x03,
  0xA0, 0xB3, 0x01, 0xA0, 0x70, 0x9A, 0x40, 0xDA, 0x02, 0x3A, 0x0E, 0x30, 0x5A, 0x04, 0x06, 0xA0,
  0x32, 0x01, 0xA0, 0xE4, 0x0C, 0xA0, 0x22, 0x08, 0xA0, 0x10, 0x3A, 0x06, 0x20, 0x4A, 0x0B, 0x40,
  0x9A, 0x05, 0x28, 0x1C, 0xFD, 0x2A, 0x0A, 0x20, 0x7A, 0x07, 0x40, 0x5A, 0x08, 0x2A, 0x09, 0x28,
  0x1C, 0xFD, 0x20, 0xAA, 0x04, 0x40, 0x2A, 0x81, 0xB0, 0x3A, 0x06, 0x20, 0x8A, 0x81, 0x10, 0xDA,
  0x01, 0x58, 0x3E, 0xFE, 0x06, 0xA0, 0x32, 0x05, 0xA0, 0x40, 0x1A, 0x0D, 0x60, 0xBA, 0x02, 0x09,
  0xA3, 0x01, 0xA0, 0x70, 0x4A, 0x0A, 0x60, 0x7A, 0x82, 0x4C, 0xFB, 0x48, 0x2D, 0xFA, 0x7A, 0x06,
  0x60, 0x4A, 0x82, 0x7E, 0xF8, 0x48, 0x2A, 0xFC, 0x9A, 0x03, 0x60, 0x1A, 0x0B, 0xA0, 0x54, 0x06,
  0xA0, 0xBA, 0x71, 0x0D, 0xC0, 0x14, 0x03, 0xC0, 0xC7, 0x10, 0xAB, 0x0D, 0x6C, 0x09, 0x71, 0x06,
  0xB0, 0xA6, 0x0C, 0xB0, 0x57, 0x10, 0x3B, 0x07, 0x60, 0x8B, 0x02, 0x40,
  // "ŵ" (U+0175)
  0x71, 0x01, 0x0E, 0xA0, 0x67, 0x72, 0x09, 0xB0, 0xE0, 0x17, 0x70, 0x3A, 0x82, 0x8E, 0xFA, 0x77,
  0x86, 0xDF, 0x80, 0x3E, 0xF5, 0x75, 0x81, 0x9F, 0x83, 0x82, 0x2E, 0xE2, 0x80, 0xD3, 0x00, 0x9A,
  0x05, 0x40, 0x7B, 0x50, 0xCA, 0x01, 0x06, 0xA0, 0x84, 0x0B, 0xB0, 0x34, 0xA8, 0x1D, 0x02, 0xA0,
  0xB4, 0x0E, 0xB0, 0x63, 0x03, 0xA0, 0x92, 0x81, 0xEF, 0xE3, 0x02, 0xA8, 0x1D, 0xFA, 0x30, 0x7A,
  0x06, 0x20, 0xBA, 0x02, 0x28, 0x46, 0xFE, 0x8F, 0xD3, 0x0A, 0xA0, 0x22, 0x08, 0xA0, 0x52, 0x82,
  0x9F, 0xC6, 0xA0, 0x12, 0x81, 0xDF, 0xE3, 0x04, 0xA0, 0x92, 0x82, 0xDF, 0x93, 0xA8, 0x14, 0x01,
  0xA0, 0xB3, 0x01, 0xA8, 0x1C, 0x01, 0xA0, 0x61, 0xA8, 0x17, 0x04, 0xA0, 0x74, 0x0D, 0xA1, 0x04,
  0xA8, 0x53, 0x0C, 0xFB, 0x07, 0xA0, 0x44, 0x09, 0xA0, 0x20, 0x7A, 0x28, 0x38, 0xFE, 0x0B, 0xA5,
  0x06, 0xA8, 0x25, 0xAF, 0xB2, 0x05, 0xA8, 0x21, 0xDF, 0xC5, 0x03, 0xA8, 0x27, 0xDF, 0x82, 0x02,
  0xA0, 0x5A, 0x09, 0x68, 0x1E, 0xFA, 0xA0, 0x53, 0x81, 0xEF, 0x9A, 0x05, 0x68, 0x1B, 0xFE, 0xA0,
  0x13, 0x81, 0xBF, 0xDA, 0x02, 0x60, 0x8B, 0x0E, 0x40, 0x8B, 0x0E, 0x70, 0x4B, 0x0A, 0x40, 0x5B,
  0x0A, 0x70, 0x1B, 0x07, 0x40, 0x2B, 0x07, 0x40,
  // "Ŷ" (U+0176)
  0x40, 0x10, 0xEA, 0x06, 0x72, 0x09, 0xB0, 0xE0, 0x17, 0x03, 0xA8, 0x28, 0xEF, 0xA7, 0x86, 0xDF,
  0x80, 0x3E, 0xF5, 0x58, 0x19, 0xF8, 0x38, 0x22, 0xEE, 0x27, 0x77, 0x72, 0x0C, 0xA0, 0x66, 0x06,
  0xA0, 0xC0, 0x6A, 0x0C, 0x60, 0xCA, 0x81, 0x50, 0xEA, 0x03, 0x40, 0x3A, 0x0E, 0x20, 0x9A, 0x09,
  0x40, 0x9A, 0x08, 0x20, 0x3A, 0x0E, 0x40, 0xEA, 0x02, 0x30, 0xCA, 0x05, 0x20, 0x5A, 0x0B, 0x40,
  0x6A, 0x0B, 0x20, 0xBA, 0x05, 0x50, 0xEA, 0x02, 0x01, 0xA0, 0xE6, 0x09, 0xA0, 0x80, 0x7A, 0x08,
  0x60, 0x3A, 0x00, 0xDA, 0x02, 0x70, 0xCC, 0x0B, 0x71, 0x06, 0xC0, 0x57, 0x20, 0xEA, 0x0E, 0x73,
  0x09, 0xA0, 0x97, 0x30, 0x8A, 0x08, 0x73, 0x08, 0xA0, 0x87, 0x30, 0x8A, 0x08, 0x73, 0x08, 0xA0,
  0x87, 0x30, 0x8A, 0x08, 0x73, 0x08, 0xA0, 0x87, 0x30, 0x8A, 0x08, 0x73, 0x08, 0xA0, 0x85,
  // "ŷ" (U+0177)
  0x40, 0x10, 0xEA, 0x06, 0x71, 0x09, 0xB0, 0xE0, 0x16, 0x03, 0xA8, 0x28, 0xEF, 0xA6, 0x86, 0xDF,
  0x80, 0x3E, 0xF5, 0x48, 0x19, 0xF8, 0x38, 0x22, 0xEE, 0x27, 0x77, 0x60, 0xBA, 0x05, 0x50, 0x5A,
  0x0B, 0x07, 0xA0, 0x95, 0x09, 0xA0, 0x70, 0x2A, 0x0D, 0x50, 0xDA, 0x81, 0x20, 0xDA, 0x02, 0x30,
  0x1A, 0x0D, 0x20, 0x8A, 0x06, 0x30, 0x5A, 0x09, 0x20, 0x3A, 0x0A, 0x30, 0x9A, 0x04, 0x38, 0x1E,
  0xFE, 0x30, 0xDA, 0x40, 0xAA, 0x81, 0x30, 0x2A, 0x0B, 0x40, 0x5A, 0x81, 0x70, 0x6A, 0x07, 0x40,
  0x1A, 0x81, 0xB0, 0xAA, 0x02, 0x50, 0xBA, 0x18, 0x1E, 0xFD, 0x60, 0x6A, 0x05, 0xA0, 0x96, 0x02,
  0xA0, 0xBA, 0x04, 0x70, 0xDC, 0x71, 0x08, 0xB0, 0xB7, 0x10, 0x3B, 0x06, 0x72, 0xB0, 0x27, 0x10,
  0x2A, 0x0D, 0x72, 0x07, 0xA0, 0x87, 0x20, 0xCA, 0x03, 0x71, 0x06, 0xA0, 0xD6, 0x81, 0x5A, 0xBB,
  0x06, 0x60, 0x6C, 0x0A, 0x78, 0x35, 0xEF, 0xD7, 0x71,
  // "Ÿ" (U+0178)
  0x38, 0x1A, 0xE7, 0x28, 0x17, 0xEA, 0x6A, 0x0C, 0x20, 0xCA, 0x01, 0x58, 0x1A, 0xE7, 0x28, 0x17,
  0xEA, 0x77, 0x77, 0x30, 0xCA, 0x06, 0x60, 0x6A, 0x0C, 0x06, 0xA0, 0xC6, 0x0C, 0xA8, 0x15, 0x0E,
  0xA0, 0x34, 0x03, 0xA0, 0xE2, 0x09, 0xA0, 0x94, 0x09, 0xA0, 0x82, 0x03, 0xA0, 0xE4, 0x0E, 0xA0,
  0x23, 0x0C, 0xA0, 0x52, 0x05, 0xA0, 0xB4, 0x06, 0xA0, 0xB2, 0x0B, 0xA0, 0x55, 0x0E, 0xA0, 0x20,
  0x1A, 0x0E, 0x60, 0x9A, 0x08, 0x07, 0xA0, 0x86, 0x03, 0xA0, 0x0D, 0xA0, 0x27, 0x0C, 0xC0, 0xB7,
  0x10, 0x6C, 0x05, 0x72, 0x0E, 0xA0, 0xE7, 0x30, 0x9A, 0x09, 0x73, 0x08, 0xA0, 0x87, 0x30, 0x8A,
  0x08, 0x73, 0x08, 0xA0, 0x87, 0x30, 0x8A, 0x08, 0x73, 0x08, 0xA0, 0x87, 0x30, 0x8A, 0x08, 0x73,
  0x08, 0xA0, 0x87, 0x30, 0x8A, 0x08, 0x50,
  // "Ź" (U+0179)
  0x70, 0x5B, 0x03, 0x71, 0x0D, 0xA0, 0x87, 0x10, 0x6A, 0x0A, 0x71, 0x82, 0x1E, 0xFB, 0x72, 0x81,
  0xAF, 0xA7, 0x77, 0x74, 0xFC, 0x03, 0x1F, 0xC8, 0x13, 0x08, 0x80, 0x29, 0x0A, 0xB0, 0x17, 0x10,
  0x9A, 0x09, 0x71, 0x01, 0xB0, 0x27, 0x10, 0x8A, 0x0A, 0x72, 0x0E, 0xA0, 0x37, 0x10, 0x7A, 0x0B,
  0x72, 0x0D, 0xA0, 0x47, 0x10, 0x6A, 0x0C, 0x72, 0x0D, 0xA0, 0x57, 0x10, 0x4A, 0x0D, 0x72, 0x0B,
  0xA0, 0x67, 0x10, 0x3A, 0x0E, 0x72, 0x0A, 0xA0, 0x77, 0x10, 0x2A, 0x0E, 0x01, 0x71, 0x09, 0xA0,
  0x97, 0x10, 0x1B, 0x02, 0x71, 0x08, 0xA0, 0xA7, 0x20, 0xEA, 0x0B, 0x80, 0x39, 0x03, 0x02, 0xFC,
  0x06, 0x02, 0xFC, 0x06,
  // "ź" (U+017A)
  0x60, 0x5B, 0x03, 0x60, 0xDA, 0x08, 0x60, 0x6A, 0x0A, 0x68, 0x21, 0xEF, 0xB7, 0x81, 0xAF, 0xA7,
  0x77, 0x60, 0xCF, 0x92, 0x0C, 0xF9, 0x28, 0x47, 0x99, 0x99, 0xBA, 0x0D, 0x70, 0xAA, 0x06, 0x60,
  0x2A, 0x0D, 0x70, 0xAA, 0x06, 0x60, 0x2A, 0x0E, 0x70, 0x9A, 0x07, 0x60, 0x1A, 0x0E, 0x01, 0x60,
  0x8A, 0x08, 0x60, 0x10, 0xEA, 0x01, 0x60, 0x8A, 0x09, 0x70, 0xEA, 0x02, 0x60, 0x7A, 0x09, 0x70,
  0xEA, 0x0A, 0x80, 0x19, 0x00, 0x2F, 0xA0, 0x30, 0x2F, 0xA0, 0x30,
  // "Ż" (U+017B)
  0x58, 0x24, 0xED, 0x27, 0x20, 0xBA, 0x07, 0x72, 0x0B, 0xA0, 0x77, 0x28, 0x24, 0xED, 0x17, 0x77,
  0x73, 0xFC, 0x03, 0x1F, 0xC8, 0x13, 0x08, 0x80, 0x29, 0x0A, 0xB0, 0x17, 0x10, 0x9A, 0x09, 0x71,
  0x01, 0xB0, 0x27, 0x10, 0x8A, 0x0A, 0x72, 0x0E, 0xA0, 0x37, 0x10, 0x7A, 0x0B, 0x72, 0x0D, 0xA0,
  0x47, 0x10, 0x6A, 0x0C, 0x72, 0x0D, 0xA0, 0x57, 0x10, 0x4A, 0x0D, 0x72, 0x0B, 0xA0, 0x67, 0x10,
  0x3A, 0x0E, 0x72, 0x0A, 0xA0, 0x77, 0x10, 0x2A, 0x0E, 0x01, 0x71, 0x09, 0xA0, 0x97, 0x10, 0x1B,
  0x02, 0x71, 0x08, 0xA0, 0xA7, 0x20, 0xEA, 0x0B, 0x80, 0x39, 0x03, 0x02, 0xFC, 0x06, 0x02, 0xFC,
  0x06,
  // "ż" (U+017C)
  0x48, 0x24, 0xED, 0x27, 0x0B, 0xA0, 0x77, 0x0B, 0xA0, 0x77, 0x82, 0x4E, 0xD1, 0x77, 0x75, 0x0C,
  0xF9, 0x20, 0xCF, 0x92, 0x84, 0x79, 0x99, 0x9B, 0xA0, 0xD7, 0x0A, 0xA0, 0x66, 0x02, 0xA0, 0xD7,
  0x0A, 0xA0, 0x66, 0x02, 0xA0, 0xE7, 0x09, 0xA0, 0x76, 0x01, 0xA0, 0xE0, 0x16, 0x08, 0xA0, 0x86,
  0x01, 0x0E, 0xA0, 0x16, 0x08, 0xA0, 0x97, 0x0E, 0xA0, 0x26, 0x07, 0xA0, 0x97, 0x0E, 0xA0, 0xA8,
  0x01, 0x90, 0x02, 0xFA, 0x03, 0x02, 0xFA, 0x03,
  // "Ž" (U+017D)
  0x28, 0x1A, 0xF8, 0x38, 0x22, 0xDF, 0x23, 0x87, 0x1E, 0xF7, 0x02, 0xEF, 0x65, 0x04, 0xA8, 0x27,
  0xDF, 0xB7, 0x09, 0xB0, 0xE0, 0x17, 0x01, 0x0E, 0xA0, 0x77, 0x77, 0x73, 0xFC, 0x03, 0x1F, 0xC8,
  0x13, 0x08, 0x80, 0x29, 0x0A, 0xB0, 0x17, 0x10, 0x9A, 0x09, 0x71, 0x01, 0xB0, 0x27, 0x10, 0x8A,
  0x0A, 0x72, 0x0E, 0xA0, 0x37, 0x10, 0x7A, 0x0B, 0x72, 0x0D, 0xA0, 0x47, 0x10, 0x6A, 0x0C, 0x72,
  0x0D, 0xA0, 0x57, 0x10, 0x4A, 0x0D, 0x72, 0x0B, 0xA0, 0x67, 0x10, 0x3A, 0x0E, 0x72, 0x0A, 0xA0,
  0x77, 0x10, 0x2A, 0x0E, 0x01, 0x71, 0x09, 0xA0, 0x97, 0x10, 0x1B, 0x02, 0x71, 0x08, 0xA0, 0xA7,
  0x20, 0xEA, 0x0B, 0x80, 0x39, 0x03, 0x02, 0xFC, 0x06, 0x02, 0xFC, 0x06,
  // "ž" (U+017E)
  0x18, 0x1A, 0xF8, 0x38, 0x94, 0x2D, 0xF2, 0x01, 0xEF, 0x70, 0x2E, 0xF6, 0x30, 0x4A, 0x82, 0x7D,
  0xFB, 0x50, 0x9B, 0x0E, 0x01, 0x50, 0x10, 0xEA, 0x07, 0x77, 0x75, 0x0C, 0xF9, 0x20, 0xCF, 0x92,
  0x84, 0x79, 0x99, 0x9B, 0xA0, 0xD7, 0x0A, 0xA0, 0x66, 0x02, 0xA0, 0xD7, 0x0A, 0xA0, 0x66, 0x02,
  0xA0, 0xE7, 0x09, 0xA0, 0x76, 0x01, 0xA0, 0xE0, 0x16, 0x08, 0xA0, 0x86, 0x01, 0x0E, 0xA0, 0x16,
  0x08, 0xA0, 0x97, 0x0E, 0xA0, 0x26, 0x07, 0xA0, 0x97, 0x0E, 0xA0, 0xA8, 0x01, 0x90, 0x02, 0xFA,
  0x03, 0x02, 0xFA, 0x03,
  // "ſ" (U+017F)
  0x18, 0x71, 0x8D, 0xFD, 0xA2, 0x0B, 0xD0, 0x10, 0x4B, 0x0F, 0xA1, 0x09, 0xA0, 0x74, 0x0B, 0xA0,
  0x34, 0x0C, 0xA0, 0x24, 0x0C, 0xA0, 0x24, 0x0C, 0xA0, 0x24, 0x0C, 0xA0, 0x24, 0x0C, 0xA0, 0x24,
  0x0C, 0xA0, 0x24, 0x0C, 0xA0, 0x24, 0x0C, 0xA0, 0x24, 0x0C, 0xA0, 0x24, 0x0C, 0xA0, 0x24, 0x0C,
  0xA0, 0x24, 0x0C, 0xA0, 0x24, 0x0C, 0xA0, 0x24, 0x0C, 0xA0, 0x24, 0x0C, 0xA0, 0x24, 0x0C, 0xA0,
  0x24, 0x0C, 0xA0, 0x24, 0x0C, 0xA0, 0x24,
  // "Ω" (U+03A9)
  0x58, 0x71, 0x7B, 0xEF, 0xEB, 0x71, 0x72, 0x04, 0x0E, 0xF0, 0xE0, 0x47, 0x04, 0xC8, 0x2B, 0x9A,
  0xEB, 0x04, 0x50, 0x10, 0xEA, 0x0B, 0x01, 0x30, 0x10, 0xBA, 0x0D, 0x50, 0x7A, 0x0D, 0x70, 0xDA,
  0x06, 0x40, 0xDA, 0x06, 0x70, 0x6A, 0x0C, 0x30, 0x1B, 0x02, 0x70, 0x1B, 0x30, 0x4A, 0x0E, 0x72,
  0x0E, 0xA0, 0x32, 0x05, 0xA0, 0xC7, 0x20, 0xCA, 0x04, 0x20, 0x6A, 0x0C, 0x72, 0x0B, 0xA0, 0x52,
  0x05, 0xA0, 0xC7, 0x20, 0xCA, 0x04, 0x20, 0x4A, 0x0D, 0x72, 0x0D, 0xA0, 0x32, 0x02, 0xA0, 0xE7,
  0x20, 0xEA, 0x02, 0x30, 0xEA, 0x01, 0x70, 0x1A, 0x0E, 0x40, 0xBA, 0x05, 0x70, 0x4A, 0x0A, 0x40,
  0x6A, 0x08, 0x70, 0x8A, 0x05, 0x58, 0x1D, 0xFE, 0x78, 0x1E, 0xFE, 0x60, 0x5A, 0x07, 0x50, 0x7A,
  0x05, 0x70, 0x9A, 0x03, 0x30, 0x3A, 0x09, 0x40, 0x18, 0x00, 0x9A, 0x83, 0xE1, 0x01, 0xEA, 0x80,
  0x09, 0x00, 0x1F, 0x81, 0x20, 0x3F, 0x00, 0x1F, 0x81, 0x20, 0x3F, 0x01,
  // "μ" (U+03BC)
  0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50,
  0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80,
  0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x06, 0xA0, 0x80, 0xEA, 0x50, 0x6A, 0x08, 0x0E, 0xA5, 0x08,
  0xA0, 0x80, 0xEA, 0x01, 0x40, 0xAA, 0x08, 0x0E, 0xA0, 0x44, 0x0E, 0xA0, 0x80, 0xEA, 0x0A, 0x30,
  0x8B, 0x08, 0x0E, 0xB8, 0x3C, 0x9C, 0xFD, 0xA0, 0x80, 0xEE, 0x0E, 0x02, 0xA8, 0x94, 0x8E, 0xFE,
  0x5D, 0xEB, 0x30, 0xDF, 0x8E, 0xA7, 0x20, 0xEA, 0x72, 0x0E, 0xA7, 0x20, 0xEA, 0x72, 0x0E, 0xA7,
  0x20, 0xEA, 0x72, 0x0E, 0xA7, 0x20,
  // "π" (U+03C0)
  0x10, 0x9F, 0xF0, 0xBF, 0xF9, 0x81, 0x69, 0x9A, 0x84, 0xE9, 0x99, 0x9C, 0xA8, 0x1B, 0x99, 0x20,
  0x1A, 0x0C, 0x40, 0x8A, 0x06, 0x40, 0x1A, 0x0C, 0x40, 0x8A, 0x06, 0x40, 0x1A, 0x0C, 0x40, 0x8A,
  0x06, 0x40, 0x1A, 0x0C, 0x40, 0x8A, 0x06, 0x40, 0x1A, 0x0C, 0x40, 0x8A, 0x06, 0x40, 0x1A, 0x0C,
  0x40, 0x8A, 0x06, 0x40, 0x1A, 0x0C, 0x40, 0x8A, 0x06, 0x40, 0x1A, 0x0C, 0x40, 0x8A, 0x06, 0x40,
  0x1A, 0x0C, 0x40, 0x8A, 0x06, 0x40, 0x1A, 0x0C, 0x40, 0x8A, 0x06, 0x40, 0x1A, 0x0C, 0x40, 0x7A,
  0x08, 0x40, 0x1A, 0x0C, 0x40, 0x5B, 0x00, 0x92, 0x01, 0xA0, 0xC5, 0x0E, 0xB0, 0xD2, 0x01, 0xA0,
  0xC5, 0x83, 0x3C, 0xFE, 0xB0,
  // "–" (U+2013)
  0x07, 0x80, 0x79, 0x07, 0x0D, 0xFC, 0x00, 0xDF, 0xC0, 0xD0,
  // "—" (U+2014)
  0x07, 0x80, 0xA6, 0x90, 0x70, 0xDF, 0xFF, 0xD0, 0x0D, 0xFF, 0xFD, 0x0D,
  // "€" (U+20AC)
  0x68, 0x54, 0xAD, 0xFE, 0xB6, 0x60, 0x9F, 0x09, 0x40, 0x8B, 0x84, 0xB9, 0xBE, 0xF4, 0x30, 0x3A,
  0x0E, 0x03, 0x30, 0x10, 0x64, 0x09, 0xA0, 0x77, 0x3B, 0x73, 0x03, 0xA0, 0xB7, 0x18, 0x14, 0x9B,
  0xA8, 0x4D, 0x99, 0x99, 0x73, 0x07, 0xFA, 0x0C, 0x30, 0x7F, 0xA0, 0xC5, 0x08, 0xA0, 0x77, 0x30,
  0x8A, 0x07, 0x71, 0x07, 0xFA, 0x01, 0x30, 0x7F, 0xA0, 0x15, 0x04, 0xA0, 0xB7, 0x30, 0x1A, 0x0D,
  0x74, 0x0D, 0xA0, 0x27, 0x30, 0x7A, 0x09, 0x73, 0x01, 0x0E, 0xA0, 0x54, 0x03, 0x02, 0x40, 0x7B,
  0x84, 0xC9, 0x9D, 0xF5, 0x50, 0x8F, 0x05, 0x68, 0x64, 0xAE, 0xFD, 0xB7, 0x10,
  // "₿" (U+20BF)
  0x28, 0x45, 0xF5, 0x0E, 0xC6, 0x84, 0x5F, 0x50, 0xEC, 0x68, 0x45, 0xF5, 0x0E, 0xC4, 0x0A, 0xE0,
  0xE0, 0x43, 0x0A, 0xF9, 0x09, 0x20, 0xAA, 0x82, 0xB9, 0xAD, 0xB8, 0x16, 0x0A, 0xA0, 0x53, 0x0A,
  0xA8, 0x1C, 0x0A, 0xA0, 0x53, 0x02, 0xA8, 0x1E, 0x0A, 0xA0, 0x54, 0xB1, 0x0A, 0xA0, 0x53, 0x01,
  0xA8, 0x1E, 0x0A, 0xA0, 0x53, 0x05, 0xA8, 0x1B, 0x0A, 0xA0, 0x52, 0x04, 0x0E, 0xA8, 0x14, 0x0A,
  0xF0, 0xE0, 0x62, 0x0A, 0xF0, 0xB0, 0x22, 0x0A, 0xA8, 0x2B, 0x99, 0xCB, 0x81, 0x40, 0xAA, 0x05,
  0x30, 0x8A, 0x81, 0xE0, 0xAA, 0x05, 0x40, 0xDA, 0x04, 0x0A, 0xA0, 0x54, 0x0A, 0xA0, 0x70, 0xAA,
  0x05, 0x40, 0x9A, 0x07, 0x0A, 0xA0, 0x54, 0x0B, 0xA0, 0x60, 0xAA, 0x05, 0x40, 0xEA, 0x04, 0x0A,
  0xA0, 0x53, 0x06, 0xA8, 0x1E, 0x0A, 0xA8, 0x2B, 0x99, 0xBB, 0x81, 0x80, 0xAF, 0x90, 0xB2, 0x0A,
  0xE0, 0xE0, 0x65, 0x84, 0x5F, 0x50, 0xEC, 0x68, 0x45, 0xF5, 0x0E, 0xC6, 0x84, 0x5F, 0x50, 0xDC,
  0x40,
  // "‘" (U+2018)
  0x20, 0x1A, 0x03, 0x20, 0x7A, 0x38, 0x1D, 0xFC, 0x20, 0x3A, 0x09, 0x20, 0x7A, 0x06, 0x20, 0xBA,
  0x04, 0x2B, 0x81, 0x10, 0x3B, 0x20,
  // "’" (U+2019)
  0x2B, 0x81, 0x20, 0x2A, 0x0E, 0x20, 0x4A, 0x0B, 0x20, 0x7A, 0x07, 0x20, 0x9A, 0x02, 0x28, 0x1C,
  0xFC, 0x3A, 0x07, 0x20, 0x3A, 0x01, 0x20,
  // "‚" (U+201A)
  0x2B, 0x81, 0x20, 0x2A, 0x0E, 0x20, 0x4A, 0x0B, 0x20, 0x7A, 0x07, 0x20, 0x9A, 0x02, 0x28, 0x1C,
  0xFC, 0x3A, 0x07, 0x20, 0x3A, 0x01, 0x20,
  // "‛" (U+201B)
  0x03, 0xB3, 0xB0, 0x12, 0x0B, 0xA0, 0x42, 0x07, 0xA0, 0x62, 0x03, 0xA0, 0x93, 0x81, 0xDF, 0xC3,
  0x81, 0x7F, 0xE3, 0x01, 0xA0, 0x30,
  // "“" (U+201C)
  0x20, 0x1A, 0x03, 0x28, 0x1A, 0xFA, 0x20, 0x7A, 0x3A, 0x07, 0x28, 0x1D, 0xFC, 0x20, 0x5A, 0x81,
  0x40, 0x3A, 0x09, 0x20, 0xBA, 0x81, 0x10, 0x7A, 0x06, 0x2A, 0x0E, 0x20, 0xBA, 0x81, 0x40, 0x4A,
  0x0B, 0x2B, 0x81, 0x10, 0x8A, 0x81, 0x90, 0x3B, 0x20, 0xBA, 0x07, 0x10,
  // "”" (U+201D)
  0x2B, 0x81, 0x20, 0x7A, 0x81, 0xA0, 0x2A, 0x0E, 0x20, 0x9A, 0x81, 0x70, 0x4A, 0x0B, 0x20, 0xCA,
  0x81, 0x30, 0x7A, 0x07, 0x28, 0x1E, 0xFE, 0x20, 0x9A, 0x81, 0x20, 0x2A, 0x0A, 0x28, 0x1C, 0xFC,
  0x20, 0x5A, 0x05, 0x2A, 0x07, 0x28, 0x18, 0xFE, 0x20, 0x3A, 0x01, 0x28, 0x1B, 0xF9, 0x20,
  // "„" (U+201E)
  0x2B, 0x81, 0x20, 0x7A, 0x81, 0xA0, 0x2A, 0x0E, 0x20, 0x9A, 0x81, 0x70, 0x4A, 0x0B, 0x20, 0xCA,
  0x81, 0x30, 0x7A, 0x07, 0x28, 0x1E, 0xFE, 0x20, 0x9A, 0x81, 0x20, 0x2A, 0x0A, 0x28, 0x1C, 0xFC,
  0x20, 0x5A, 0x05, 0x2A, 0x07, 0x28, 0x18, 0xFE, 0x20, 0x3A, 0x01, 0x28, 0x1B, 0xF9, 0x20,
  // "‟" (U+201F)
  0x03, 0xB2, 0x0B, 0xA0, 0x72, 0xB8, 0x11, 0x08, 0xA0, 0x92, 0x0B, 0xA8, 0x14, 0x04, 0xA0, 0xB2,
  0x07, 0xA0, 0x62, 0xA0, 0xE2, 0x03, 0xA0, 0x92, 0x0B, 0xA0, 0x12, 0x81, 0xDF, 0xC2, 0x05, 0xA0,
  0x42, 0x07, 0xA3, 0x81, 0xEF, 0x72, 0x01, 0xA0, 0x32, 0x81, 0xAF, 0xA0,
  // "†" (U+2020)
  0x40, 0x6A, 0x09, 0x71, 0x05, 0xA0, 0x87, 0x10, 0x3A, 0x06, 0x71, 0x02, 0xA0, 0x47, 0x2A, 0x03,
  0x72, 0x81, 0xEF, 0x14, 0x89, 0x34, 0xDC, 0xA9, 0xEF, 0x9A, 0xBD, 0x84, 0xFB, 0x89, 0x39, 0x39,
  0x87, 0x5E, 0xF6, 0x78, 0x96, 0x58, 0x1D, 0xF1, 0x72, 0x81, 0xEF, 0x17, 0x2A, 0x02, 0x72, 0xA0,
  0x37, 0x10, 0x1A, 0x03, 0x71, 0x01, 0xA0, 0x47, 0x10, 0x2A, 0x05, 0x71, 0x03, 0xA0, 0x57, 0x10,
  0x3A, 0x06, 0x71, 0x04, 0xA0, 0x77, 0x10, 0x5A, 0x07, 0x71, 0x05, 0xA0, 0x87, 0x10, 0x6A, 0x09,
  0x71, 0x07, 0xA0, 0xA4,
  // "‡" (U+2021)
  0x40, 0x5A, 0x0A, 0x71, 0x04, 0xA0, 0x87, 0x10, 0x2A, 0x06, 0x72, 0xA0, 0x47, 0x28, 0x1E, 0xF3,
  0x48, 0x93, 0x37, 0x65, 0x3D, 0xF4, 0x46, 0x75, 0x5F, 0xB8, 0x93, 0x95, 0xFE, 0xDC, 0xEF, 0xCC,
  0xEF, 0x95, 0x81, 0xEF, 0x27, 0x2A, 0x04, 0x71, 0x02, 0xA0, 0x67, 0x10, 0x4A, 0x07, 0x71, 0x02,
  0xA0, 0x67, 0x2A, 0x04, 0x72, 0x81, 0xEF, 0x24, 0x89, 0x34, 0xBA, 0x97, 0xEF, 0x88, 0xAB, 0x75,
  0xFB, 0x89, 0x39, 0x4B, 0xA9, 0x7E, 0xF8, 0x8A, 0xB7, 0x58, 0x1E, 0xF2, 0x72, 0xA0, 0x47, 0x10,
  0x2A, 0x06, 0x71, 0x04, 0xA0, 0x87, 0x10, 0x5A, 0x0A, 0x40,
  // "•" (U+2022)
  0x28, 0x35, 0xCF, 0xE9, 0x30, 0x5D, 0x0B, 0x20, 0xCE, 0x03, 0x1F, 0x06, 0x01, 0xF0, 0x71, 0xF8,
  0x16, 0x0C, 0xE8, 0x12, 0x04, 0xD0, 0xA3, 0x83, 0x5C, 0xFE, 0x82,
  // "…" (U+2026)
  0x18, 0x29, 0xEC, 0x13, 0x82, 0x9E, 0xC1, 0x48, 0x39, 0xEC, 0x12, 0xB0, 0x72, 0x02, 0xB0, 0x73,
  0x02, 0xB0, 0x70, 0x2B, 0x07, 0x20, 0x2B, 0x07, 0x30, 0x2B, 0x84, 0x70, 0x8E, 0xC1, 0x38, 0x28,
  0xEC, 0x14, 0x82, 0x8E, 0xC1,
  // "‰" (U+2030)
  0x28, 0x38, 0xEE, 0xA1, 0x68, 0x1C, 0xF9, 0x77, 0x10, 0x9C, 0x0D, 0x50, 0x3A, 0x02, 0x77, 0x02,
  0xA0, 0xC0, 0xBA, 0x06, 0x48, 0x19, 0xFC, 0x77, 0x18, 0x17, 0xFE, 0x28, 0x1B, 0xFC, 0x48, 0x1E,
  0xF5, 0x77, 0x18, 0x1A, 0xFB, 0x20, 0x7A, 0x38, 0x16, 0xFE, 0x77, 0x28, 0x1C, 0xF9, 0x20, 0x5A,
  0x01, 0x28, 0x1C, 0xF8, 0x77, 0x28, 0x1C, 0xF8, 0x20, 0x4A, 0x81, 0x20, 0x3A, 0x02, 0x77, 0x28,
  0x1C, 0xF9, 0x20, 0x4A, 0x83, 0x10, 0xAF, 0xB7, 0x73, 0x81, 0xBF, 0xA2, 0x05, 0xA1, 0x01, 0xA8,
  0x55, 0x09, 0xEE, 0xA1, 0x48, 0x36, 0xDE, 0xC3, 0x28, 0x19, 0xFC, 0x28, 0x78, 0xFE, 0x07, 0xFE,
  0x0A, 0xC0, 0xC3, 0x05, 0xC8, 0x2E, 0x20, 0x5A, 0x89, 0x04, 0x1E, 0xFA, 0x0D, 0xF7, 0x2A, 0x07,
  0x05, 0xA0, 0x52, 0x85, 0xDF, 0xB3, 0xDF, 0x92, 0x0E, 0xD0, 0x30, 0x4A, 0x82, 0x17, 0xFD, 0x28,
  0x3B, 0xFB, 0x03, 0xA8, 0x33, 0x06, 0xFE, 0x20, 0x4C, 0x87, 0x80, 0xAF, 0xA0, 0xAF, 0xA2, 0x83,
  0x7F, 0xE0, 0x6A, 0x20, 0x3A, 0x03, 0x28, 0x42, 0x78, 0x40, 0x1A, 0x83, 0x40, 0xCF, 0x92, 0x06,
  0xA1, 0x81, 0x8F, 0xD2, 0x01, 0xA0, 0x47, 0x81, 0x7F, 0xD2, 0x81, 0xDF, 0x82, 0x05, 0xA8, 0x21,
  0x8F, 0xD3, 0xA0, 0x57, 0x81, 0xDF, 0x72, 0x81, 0xDF, 0x82, 0x05, 0xA8, 0x21, 0x8F, 0xD2, 0x01,
  0xA0, 0x56, 0x05, 0xA0, 0x12, 0x81, 0xCF, 0x92, 0x06, 0xA1, 0x81, 0x8F, 0xE2, 0x01, 0xA0, 0x46,
  0x81, 0xBF, 0xA3, 0x81, 0xAF, 0xB2, 0x83, 0x8F, 0xE0, 0x6A, 0x20, 0x3A, 0x03, 0x50, 0x2A, 0x03,
  0x38, 0x17, 0xFE, 0x28, 0x3C, 0xFB, 0x02, 0xA8, 0x34, 0x08, 0xFE, 0x68, 0x18, 0xFD, 0x40, 0x2A,
  0x0C, 0x0B, 0xA0, 0x52, 0x82, 0xDF, 0xE9, 0xA0, 0xA6, 0x81, 0xEF, 0x65, 0x09, 0xC0, 0xC3, 0x05,
  0xC0, 0xE0, 0x25, 0x82, 0x5F, 0xE1, 0x68, 0x38, 0xEE, 0xA1, 0x48, 0x35, 0xDF, 0xC3, 0x20,
  // "‹" (U+2039)
  0x40, 0x16, 0x81, 0xDC, 0x43, 0x0A, 0xA0, 0x42, 0x07, 0xA0, 0xA2, 0x03, 0xA8, 0x3E, 0x10, 0x1D,
  0xA0, 0x42, 0x0B, 0xA0, 0xA3, 0x0B, 0xA0, 0xA3, 0x01, 0x0D, 0xA0, 0x53, 0x03, 0xA0, 0xE0, 0x13,
  0x07, 0xA0, 0xA4, 0x0A, 0xA0, 0x53, 0x82, 0x1D, 0xC3, 0x40, 0x12,
  // "›" (U+203A)
  0x20, 0x14, 0x81, 0x5D, 0xB4, 0x07, 0xA0, 0x84, 0x0C, 0xA0, 0x43, 0x02, 0xA0, 0xE0, 0x13, 0x07,
  0xA0, 0xC4, 0x0C, 0xA0, 0x83, 0x0C, 0xA0, 0x82, 0x07, 0xA0, 0xC2, 0x02, 0xA0, 0xE0, 0x12, 0x0C,
  0xA0, 0x42, 0x07, 0xA0, 0x83, 0x81, 0x5D, 0xB6, 0x01, 0x40,
  // "⁄" (U+2044)
  0x73, 0x82, 0x1E, 0xF6, 0x73, 0x81, 0x8F, 0xD7, 0x30, 0x1A, 0x05, 0x73, 0x81, 0x9F, 0xD7, 0x30,
  0x2A, 0x05, 0x73, 0x81, 0xAF, 0xC7, 0x30, 0x2A, 0x04, 0x73, 0x81, 0xAF, 0xC7, 0x30, 0x3A, 0x04,
  0x73, 0x81, 0xBF, 0xB7, 0x30, 0x3A, 0x03, 0x73, 0x81, 0xBF, 0xB7, 0x30, 0x4A, 0x03, 0x73, 0x81,
  0xCF, 0xA7, 0x30, 0x5A, 0x02, 0x73, 0x81, 0xCF, 0x97, 0x30, 0x5A, 0x02, 0x73, 0x81, 0xDF, 0x97,
  0x30, 0x6A, 0x01, 0x73, 0x81, 0xDF, 0x87, 0x38, 0x26, 0xFE, 0x17, 0x38, 0x1E, 0xF8, 0x74,
  // "™" (U+2122)
  0x08, 0x80, 0x2D, 0x83, 0x75, 0xDD, 0x44, 0x82, 0xCD, 0x99, 0xE0, 0x90, 0x7A, 0x09, 0x30, 0x3A,
  0x0B, 0x39, 0x0D, 0x30, 0x7A, 0x0D, 0x30, 0x8A, 0x0B, 0x39, 0x0D, 0x38, 0x37, 0xFB, 0xF3, 0x28,
  0x2D, 0xBF, 0xB3, 0x90, 0xD3, 0x89, 0x17, 0xF7, 0xF7, 0x02, 0xF6, 0xFB, 0x39, 0x0D, 0x38, 0x91,
  0x7F, 0x4D, 0xC0, 0x7F, 0x1F, 0xB3, 0x90, 0xD3, 0x89, 0x17, 0xF4, 0x8F, 0x1C, 0xB0, 0xFB, 0x39,
  0x0D, 0x38, 0x91, 0x7F, 0x43, 0xF7, 0xF6, 0x0F, 0xB3, 0x90, 0xD3, 0x83, 0x7F, 0x40, 0xEA, 0x82,
  0x10, 0xFB, 0x39, 0x0D, 0x38, 0x57, 0xF4, 0x09, 0xFB, 0x29, 0x0B, 0x30, 0xE0, 0xD3, 0x85, 0x6F,
  0x40, 0x4F, 0x62, 0x90, 0xB0,
  // "⅒" (U+2152)
  0x77, 0x82, 0x1E, 0xF6, 0x77, 0x10, 0x8A, 0x71, 0x81, 0x8F, 0xD7, 0x70, 0x10, 0xBB, 0x70, 0x1A,
  0x05, 0x76, 0x82, 0x2D, 0xFE, 0xA7, 0x81, 0x9F, 0xD7, 0x78, 0x29, 0xFC, 0x5A, 0x60, 0x2A, 0x05,
  0x77, 0x18, 0x17, 0x04, 0xA6, 0x81, 0xAF, 0xC7, 0x74, 0x04, 0xA5, 0x02, 0xA0, 0x47, 0x74, 0x04,
  0xA5, 0x81, 0xAF, 0xC7, 0x75, 0x04, 0xA4, 0x03, 0xA0, 0x47, 0x75, 0x04, 0xA4, 0x81, 0xBF, 0xB2,
  0x08, 0xA4, 0x03, 0x0C, 0xA0, 0xB0, 0x25, 0x04, 0xA3, 0x03, 0xA8, 0x13, 0x1B, 0xB3, 0x03, 0xD0,
  0xE0, 0x14, 0x04, 0xA3, 0x85, 0xBF, 0xB2, 0xDF, 0xEA, 0x38, 0x6A, 0xFD, 0x12, 0xEF, 0x84, 0x04,
  0xA2, 0x04, 0xA8, 0x33, 0x9F, 0xC5, 0xA3, 0xA0, 0x52, 0x81, 0x7F, 0xE4, 0x04, 0xA2, 0x81, 0xCF,
  0xA2, 0x81, 0x70, 0x4A, 0x20, 0x2A, 0x02, 0x20, 0x4A, 0x01, 0x70, 0x5A, 0x02, 0x40, 0x4A, 0x20,
  0x4A, 0x01, 0x20, 0x2A, 0x03, 0x78, 0x1C, 0xF9, 0x50, 0x4A, 0x20, 0x4A, 0x01, 0x20, 0x2A, 0x03,
  0x60, 0x5A, 0x02, 0x50, 0x4A, 0x20, 0x4A, 0x01, 0x20, 0x2A, 0x03, 0x68, 0x1D, 0xF9, 0x60, 0x4A,
  0x20, 0x2A, 0x03, 0x20, 0x4A, 0x01, 0x50, 0x6A, 0x01, 0x60, 0x4A, 0x38, 0x1E, 0xF6, 0x28, 0x17,
  0xFE, 0x68, 0x1D, 0xF8, 0x70, 0x4A, 0x38, 0x69, 0xFD, 0x23, 0xEF, 0x85, 0x82, 0x6F, 0xE1, 0x70,
  0x4A, 0x30, 0x10, 0xEC, 0x0E, 0x01, 0x58, 0x1E, 0xF8, 0x71, 0x04, 0xA4, 0x84, 0x2B, 0xEE, 0xA2,
  0x20,
  // "ﬁ" (U+FB01)
  0x48, 0x90, 0x7D, 0xFE, 0xC5, 0x08, 0xEA, 0x40, 0x9D, 0x05, 0x1B, 0x02, 0x20, 0x1B, 0x82, 0xB9,
  0xC1, 0x1B, 0x02, 0x20, 0x5A, 0x0B, 0x58, 0x18, 0xE9, 0x30, 0x7A, 0x07, 0x74, 0x08, 0xA0, 0x77,
  0x20, 0x10, 0x9E, 0x07, 0x20, 0xEA, 0x10, 0xAF, 0x07, 0x20, 0xEA, 0x18, 0x16, 0x9C, 0xA8, 0x2B,
  0x99, 0x42, 0x0E, 0xA3, 0x08, 0xA0, 0x75, 0x0E, 0xA3, 0x08, 0xA0, 0x75, 0x0E, 0xA3, 0x08, 0xA0,
  0x75, 0x0E, 0xA3, 0x08, 0xA0, 0x75, 0x0E, 0xA3, 0x08, 0xA0, 0x75, 0x0E, 0xA3, 0x08, 0xA0, 0x75,
  0x0E, 0xA3, 0x08, 0xA0, 0x75, 0x0E, 0xA3, 0x08, 0xA0, 0x75, 0x0E, 0xA3, 0x08, 0xA0, 0x75, 0x0E,
  0xA3, 0x08, 0xA0, 0x75, 0x0E, 0xA3, 0x08, 0xA0, 0x75, 0x0E, 0xA3, 0x08, 0xA0, 0x75, 0x0E, 0xA3,
  0x08, 0xA0, 0x75, 0x0E, 0xA3, 0x08, 0xA0, 0x75, 0x0E, 0xA1,
  // "ﬂ" (U+FB02)
  0x48, 0x67, 0xDF, 0xEC, 0x50, 0xEA, 0x30, 0x9D, 0x81, 0x50, 0xEA, 0x20, 0x1B, 0x84, 0xB9, 0xC1,
  0x0E, 0xA2, 0x05, 0xA0, 0xB5, 0x0E, 0xA2, 0x07, 0xA0, 0x75, 0x0E, 0xA2, 0x08, 0xA0, 0x75, 0x0E,
  0xA0, 0x10, 0x9E, 0x07, 0x20, 0xEA, 0x0A, 0xF0, 0x72, 0x0E, 0xA8, 0x16, 0x9C, 0xA8, 0x2B, 0x99,
  0x42, 0x0E, 0xA2, 0x08, 0xA0, 0x75, 0x0E, 0xA2, 0x08, 0xA0, 0x75, 0x0E, 0xA2, 0x08, 0xA0, 0x75,
  0x0E, 0xA2, 0x08, 0xA0, 0x75, 0x0E, 0xA2, 0x08, 0xA0, 0x75, 0x0E, 0xA2, 0x08, 0xA0, 0x75, 0x0E,
  0xA2, 0x08, 0xA0, 0x75, 0x0E, 0xA2, 0x08, 0xA0, 0x75, 0x0E, 0xA2, 0x08, 0xA0, 0x75, 0x0E, 0xA2,
  0x08, 0xA0, 0x75, 0x0E, 0xA2, 0x08, 0xA0, 0x75, 0x0E, 0xA2, 0x08, 0xA0, 0x75, 0x0E, 0xA2, 0x08,
  0xA0, 0x75, 0x0E, 0xA2, 0x08, 0xA0, 0x75, 0x0E, 0xA0,
};

const Font& font_NotoSans_CondensedMedium_30() {
  static SmoothFont font(font_NotoSans_CondensedMedium_30_data);
  return font;
}

}  // namespace roo_display
