#include "11.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-CondensedMedium (Noto Sans Condensed Medium)
// Generated on Thu Mar 30 23:43:27 CEST 2023
static const uint8_t font_NotoSans_CondensedMedium_11_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x01, 0x95,
  0xFE, 0xFE, 0x0B, 0x0B, 0x08, 0xFD, 0x03, 0x01, 0x0C, 0x04, 0x03, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x01, 0x01, 0x08, 0x03, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x00, 0x06, 0x03, 0x08, 0x04, 0x00, 0x0A, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x05, 0x08, 0x06, 0x00, 0x12, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x04, 0x08, 0x05, 0x00, 0x2C, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x07, 0x08, 0x08, 0x00, 0x44, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x06, 0x08, 0x06, 0x00, 0x68, // "&" (U+0026)
  0x00, 0x27, 0x00, 0x06, 0x01, 0x08, 0x02, 0x00, 0x85, // "'" (U+0027)
  0x00, 0x28, 0x00, 0xFF, 0x02, 0x08, 0x03, 0x00, 0x89, // "(" (U+0028)
  0x00, 0x29, 0x00, 0xFF, 0x02, 0x08, 0x03, 0x00, 0x9A, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x05, 0x04, 0x08, 0x05, 0x00, 0xAB, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x04, 0x06, 0x05, 0x00, 0xB6, // "+" (U+002B)
  0x00, 0x2C, 0x00, 0x00, 0x01, 0x02, 0x03, 0x00, 0xC4, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x03, 0x02, 0x03, 0x03, 0x00, 0xC8, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x01, 0x01, 0x01, 0x03, 0x00, 0xCB, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x03, 0x08, 0x04, 0x00, 0xCD, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x04, 0x08, 0x05, 0x00, 0xE0, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x01, 0x03, 0x08, 0x05, 0x00, 0xF6, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x04, 0x08, 0x05, 0x01, 0x0A, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x04, 0x08, 0x05, 0x01, 0x21, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x05, 0x08, 0x05, 0x01, 0x38, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x04, 0x08, 0x05, 0x01, 0x52, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x04, 0x08, 0x05, 0x01, 0x68, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x04, 0x08, 0x05, 0x01, 0x7E, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x04, 0x08, 0x05, 0x01, 0x94, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x04, 0x08, 0x05, 0x01, 0xAA, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x01, 0x06, 0x03, 0x01, 0xC0, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0xFF, 0x01, 0x06, 0x03, 0x01, 0xC6, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x02, 0x04, 0x07, 0x05, 0x01, 0xCE, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x03, 0x04, 0x05, 0x05, 0x01, 0xDC, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x04, 0x07, 0x05, 0x01, 0xE4, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x03, 0x08, 0x04, 0x01, 0xF3, // "?" (U+003F)
  0x00, 0x40, 0x00, 0x00, 0x07, 0x08, 0x08, 0x02, 0x06, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x05, 0x08, 0x06, 0x02, 0x2B, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x05, 0x08, 0x06, 0x02, 0x45, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x05, 0x08, 0x06, 0x02, 0x60, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x05, 0x08, 0x06, 0x02, 0x78, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x04, 0x08, 0x05, 0x02, 0x94, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x04, 0x08, 0x05, 0x02, 0xA8, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x05, 0x08, 0x07, 0x02, 0xBA, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x05, 0x08, 0x07, 0x02, 0xD4, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x02, 0x08, 0x03, 0x02, 0xF0, // "I" (U+0049)
  0x00, 0x4A, 0xFF, 0xFF, 0x01, 0x08, 0x03, 0x02, 0xFE, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x05, 0x08, 0x06, 0x03, 0x0F, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x04, 0x08, 0x05, 0x03, 0x2B, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x07, 0x08, 0x09, 0x03, 0x3C, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x06, 0x08, 0x07, 0x03, 0x5E, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x06, 0x08, 0x07, 0x03, 0x7E, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x05, 0x08, 0x06, 0x03, 0x9C, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFF, 0x06, 0x08, 0x07, 0x03, 0xB3, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x05, 0x08, 0x06, 0x03, 0xD7, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x04, 0x08, 0x05, 0x03, 0xF2, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x04, 0x08, 0x05, 0x04, 0x09, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x05, 0x08, 0x07, 0x04, 0x1B, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x05, 0x08, 0x06, 0x04, 0x38, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x08, 0x08, 0x09, 0x04, 0x53, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x04, 0x08, 0x05, 0x04, 0x7B, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x04, 0x08, 0x05, 0x04, 0x93, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x04, 0x08, 0x05, 0x04, 0xA8, // "Z" (U+005A)
  0x00, 0x5B, 0x00, 0xFF, 0x03, 0x08, 0x03, 0x04, 0xBF, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x03, 0x08, 0x04, 0x04, 0xD8, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0xFF, 0x02, 0x08, 0x03, 0x04, 0xEC, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x04, 0x04, 0x08, 0x05, 0x04, 0xFD, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFF, 0x04, 0xFF, 0x05, 0x05, 0x0B, // "_" (U+005F)
  0x00, 0x60, 0x00, 0x08, 0x02, 0x09, 0x03, 0x05, 0x0E, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x04, 0x06, 0x05, 0x05, 0x13, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x05, 0x08, 0x06, 0x05, 0x24, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x03, 0x06, 0x04, 0x05, 0x3E, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x04, 0x08, 0x06, 0x05, 0x4C, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x04, 0x06, 0x05, 0x05, 0x61, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x03, 0x08, 0x03, 0x05, 0x72, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFE, 0x04, 0x06, 0x06, 0x05, 0x83, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x04, 0x08, 0x06, 0x05, 0x9C, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x01, 0x08, 0x03, 0x05, 0xB2, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xFE, 0x01, 0x08, 0x03, 0x05, 0xBC, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x04, 0x08, 0x05, 0x05, 0xCE, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x01, 0x08, 0x03, 0x05, 0xE4, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x07, 0x06, 0x09, 0x05, 0xEE, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x04, 0x06, 0x06, 0x06, 0x08, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x04, 0x06, 0x06, 0x06, 0x19, // "o" (U+006F)
  0x00, 0x70, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x06, 0x2A, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFE, 0x04, 0x06, 0x06, 0x06, 0x46, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x03, 0x06, 0x04, 0x06, 0x5E, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x03, 0x06, 0x04, 0x06, 0x6D, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x03, 0x08, 0x03, 0x06, 0x7C, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x04, 0x06, 0x06, 0x06, 0x8E, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x04, 0x06, 0x05, 0x06, 0x9F, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x07, 0x06, 0x08, 0x06, 0xB1, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x04, 0x06, 0x05, 0x06, 0xCC, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x06, 0xDE, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x03, 0x06, 0x04, 0x06, 0xF8, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0xFF, 0x03, 0x08, 0x04, 0x07, 0x07, // "{" (U+007B)
  0x00, 0x7C, 0x02, 0xFE, 0x02, 0x08, 0x05, 0x07, 0x1F, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0xFF, 0x03, 0x08, 0x04, 0x07, 0x21, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x04, 0x04, 0x05, 0x05, 0x07, 0x39, // "~" (U+007E)
  0x00, 0xA1, 0x00, 0xFF, 0x01, 0x06, 0x03, 0x07, 0x40, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0x4A, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0x5E, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x02, 0x05, 0x07, 0x06, 0x07, 0x75, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0x89, // "¥" (U+00A5)
  0x00, 0xA6, 0x02, 0xFE, 0x02, 0x08, 0x05, 0x07, 0xA0, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x03, 0x08, 0x05, 0x07, 0xA5, // "§" (U+00A7)
  0x00, 0xA8, 0x01, 0x08, 0x04, 0x08, 0x06, 0x07, 0xB7, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x08, 0x08, 0x09, 0x07, 0xBA, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x06, 0x03, 0x08, 0x04, 0x07, 0xDF, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x01, 0x04, 0x06, 0x05, 0x07, 0xE7, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x04, 0x04, 0x05, 0x07, 0xF8, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x01, 0x08, 0x08, 0x09, 0x08, 0x00, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x09, 0x05, 0x09, 0x05, 0x08, 0x25, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x06, 0x03, 0x08, 0x04, 0x08, 0x28, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x04, 0x07, 0x05, 0x08, 0x30, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x05, 0x03, 0x09, 0x04, 0x08, 0x41, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x05, 0x03, 0x09, 0x04, 0x08, 0x4D, // "³" (U+00B3)
  0x00, 0xB4, 0x00, 0x08, 0x02, 0x09, 0x03, 0x08, 0x59, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0xFE, 0x04, 0x06, 0x06, 0x08, 0x5D, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFF, 0x04, 0x08, 0x06, 0x08, 0x74, // "¶" (U+00B6)
  0x00, 0xB7, 0x00, 0x04, 0x01, 0x04, 0x03, 0x08, 0x92, // "·" (U+00B7)
  0x00, 0xB8, 0x00, 0xFE, 0x01, 0x00, 0x02, 0x08, 0x94, // "¸" (U+00B8)
  0x00, 0xB9, 0x00, 0x06, 0x02, 0x0A, 0x04, 0x08, 0x98, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x05, 0x03, 0x08, 0x04, 0x08, 0xA1, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x01, 0x04, 0x06, 0x05, 0x08, 0xAB, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x07, 0x08, 0x08, 0x08, 0xBB, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x07, 0x08, 0x09, 0x08, 0xDF, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x08, 0x08, 0x08, 0x09, 0x04, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFF, 0x03, 0x06, 0x04, 0x09, 0x2C, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x09, 0x3F, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x09, 0x5F, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x09, 0x7F, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x09, 0xA0, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x09, 0xC2, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x09, 0xE0, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x07, 0x08, 0x08, 0x0A, 0x00, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x0A, 0x20, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x0A, 0x3F, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x0A, 0x58, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x0A, 0x71, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x0A, 0x8B, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x02, 0x0B, 0x03, 0x0A, 0xA3, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x03, 0x0B, 0x03, 0x0A, 0xB6, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x03, 0x0B, 0x03, 0x0A, 0xCF, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x03, 0x0A, 0x03, 0x0A, 0xE9, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0B, 0x01, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0B, 0x1D, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0B, 0x45, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0B, 0x69, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0B, 0x8D, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x0B, 0xB2, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x0B, 0xD8, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x02, 0x04, 0x06, 0x05, 0x0B, 0xFA, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x06, 0x09, 0x07, 0x0C, 0x07, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x0C, 0x29, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x0C, 0x4C, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x0C, 0x6F, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x0C, 0x92, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x0C, 0xB3, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x05, 0x08, 0x05, 0x0C, 0xCD, // "Þ" (U+00DE)
  0x00, 0xDF, 0x00, 0x01, 0x05, 0x08, 0x06, 0x0C, 0xE3, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xFE, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x14, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x2A, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x41, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x57, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x6B, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x07, 0x06, 0x08, 0x0D, 0x85, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFE, 0x03, 0x06, 0x04, 0x0D, 0xA0, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0xB6, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0xCC, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0xE2, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0xF9, // "ë" (U+00EB)
  0x00, 0xEC, 0xFF, 0x01, 0x01, 0x09, 0x03, 0x0E, 0x0E, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x02, 0x09, 0x03, 0x0E, 0x1D, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x02, 0x09, 0x03, 0x0E, 0x2C, // "î" (U+00EE)
  0x00, 0xEF, 0xFF, 0x01, 0x02, 0x08, 0x03, 0x0E, 0x41, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x04, 0x08, 0x06, 0x0E, 0x54, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x04, 0x09, 0x06, 0x0E, 0x6A, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x04, 0x09, 0x06, 0x0E, 0x81, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x04, 0x09, 0x06, 0x0E, 0x97, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x04, 0x09, 0x06, 0x0E, 0xAD, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x04, 0x09, 0x06, 0x0E, 0xC4, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x04, 0x08, 0x06, 0x0E, 0xDB, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x04, 0x06, 0x05, 0x0E, 0xEF, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x04, 0x07, 0x06, 0x0E, 0xF9, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x04, 0x09, 0x06, 0x0F, 0x0C, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x04, 0x09, 0x06, 0x0F, 0x22, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x04, 0x09, 0x06, 0x0F, 0x38, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x04, 0x08, 0x06, 0x0F, 0x4F, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFE, 0x04, 0x09, 0x05, 0x0F, 0x64, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x0F, 0x83, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x0F, 0xA4, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x0F, 0xC1, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0F, 0xDF, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x0F, 0xF3, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x04, 0x09, 0x05, 0x10, 0x15, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x10, 0x2C, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x10, 0x4E, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x10, 0x67, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x04, 0x09, 0x04, 0x10, 0x84, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x10, 0x9A, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x04, 0x09, 0x04, 0x10, 0xB8, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x05, 0x0A, 0x06, 0x10, 0xCF, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x03, 0x08, 0x04, 0x10, 0xEA, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x10, 0xFB, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x04, 0x09, 0x04, 0x11, 0x1A, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x11, 0x32, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x07, 0x08, 0x06, 0x11, 0x55, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x05, 0x08, 0x06, 0x11, 0x74, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x05, 0x08, 0x06, 0x11, 0x90, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x11, 0xAA, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x04, 0x08, 0x05, 0x11, 0xC2, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x11, 0xD7, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x04, 0x09, 0x05, 0x11, 0xF1, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x12, 0x08, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x04, 0x08, 0x05, 0x12, 0x1F, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x12, 0x33, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFE, 0x04, 0x06, 0x05, 0x12, 0x4F, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x12, 0x66, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x04, 0x09, 0x05, 0x12, 0x81, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x12, 0x99, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFE, 0x04, 0x09, 0x06, 0x12, 0xB9, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x12, 0xD8, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFE, 0x04, 0x09, 0x06, 0x12, 0xF9, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x13, 0x18, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFE, 0x04, 0x08, 0x06, 0x13, 0x35, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFE, 0x05, 0x08, 0x07, 0x13, 0x50, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFE, 0x04, 0x08, 0x06, 0x13, 0x70, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x13, 0x8E, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x04, 0x0B, 0x06, 0x13, 0xB1, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x06, 0x08, 0x07, 0x13, 0xD0, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x04, 0x08, 0x06, 0x13, 0xF1, // "ħ" (U+0127)
  0x01, 0x28, 0xFF, 0x01, 0x02, 0x0B, 0x03, 0x14, 0x07, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0x01, 0x02, 0x09, 0x03, 0x14, 0x20, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x03, 0x0A, 0x03, 0x14, 0x35, // "Ī" (U+012A)
  0x01, 0x2B, 0xFF, 0x01, 0x02, 0x08, 0x03, 0x14, 0x4D, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x03, 0x0B, 0x03, 0x14, 0x60, // "Ĭ" (U+012C)
  0x01, 0x2D, 0xFF, 0x01, 0x02, 0x09, 0x03, 0x14, 0x7A, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFE, 0x03, 0x08, 0x03, 0x14, 0x8F, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFE, 0x02, 0x08, 0x03, 0x14, 0xAB, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x02, 0x0A, 0x03, 0x14, 0xBD, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x01, 0x06, 0x03, 0x14, 0xCE, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0xFF, 0x04, 0x08, 0x06, 0x14, 0xD6, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x14, 0xF1, // "ĳ" (U+0133)
  0x01, 0x34, 0xFF, 0xFF, 0x02, 0x0B, 0x03, 0x15, 0x0E, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFE, 0x02, 0x09, 0x03, 0x15, 0x2C, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x15, 0x48, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x15, 0x6A, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x04, 0x06, 0x05, 0x15, 0x85, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x15, 0x96, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x02, 0x0B, 0x03, 0x15, 0xAD, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x15, 0xBF, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFE, 0x02, 0x08, 0x03, 0x15, 0xD5, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x05, 0x08, 0x05, 0x15, 0xE6, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x03, 0x08, 0x03, 0x15, 0xFA, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x04, 0x08, 0x05, 0x16, 0x0E, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x03, 0x08, 0x03, 0x16, 0x20, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x04, 0x08, 0x05, 0x16, 0x34, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x02, 0x08, 0x03, 0x16, 0x46, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x16, 0x54, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x04, 0x09, 0x06, 0x16, 0x7A, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFE, 0x06, 0x08, 0x07, 0x16, 0x90, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFE, 0x04, 0x06, 0x06, 0x16, 0xB6, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x16, 0xCC, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x04, 0x09, 0x06, 0x16, 0xF3, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x05, 0x08, 0x07, 0x17, 0x0B, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFF, 0x06, 0x08, 0x07, 0x17, 0x24, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFE, 0x04, 0x06, 0x06, 0x17, 0x4A, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x06, 0x0A, 0x07, 0x17, 0x62, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x04, 0x08, 0x06, 0x17, 0x84, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x17, 0x98, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x04, 0x09, 0x06, 0x17, 0xBE, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x06, 0x0B, 0x07, 0x17, 0xD5, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x04, 0x09, 0x06, 0x17, 0xFA, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x07, 0x08, 0x08, 0x18, 0x10, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x08, 0x06, 0x09, 0x18, 0x35, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x18, 0x52, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x03, 0x09, 0x04, 0x18, 0x73, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFE, 0x05, 0x08, 0x06, 0x18, 0x86, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFE, 0x03, 0x06, 0x04, 0x18, 0xA7, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x05, 0x0B, 0x06, 0x18, 0xBA, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x03, 0x09, 0x04, 0x18, 0xDC, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x18, 0xF0, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x03, 0x09, 0x04, 0x19, 0x0C, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x19, 0x1F, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x03, 0x09, 0x04, 0x19, 0x3C, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x19, 0x50, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFE, 0x03, 0x06, 0x04, 0x19, 0x6E, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x19, 0x84, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x03, 0x09, 0x04, 0x19, 0xA1, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFE, 0x04, 0x08, 0x05, 0x19, 0xB5, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFE, 0x03, 0x08, 0x03, 0x19, 0xCE, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x19, 0xE7, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x04, 0x08, 0x03, 0x19, 0xFF, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x04, 0x08, 0x05, 0x1A, 0x14, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x03, 0x08, 0x03, 0x1A, 0x27, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x1A, 0x39, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x04, 0x09, 0x06, 0x1A, 0x5D, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x05, 0x0A, 0x07, 0x1A, 0x74, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x04, 0x08, 0x06, 0x1A, 0x95, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x1A, 0xAA, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x04, 0x09, 0x06, 0x1A, 0xCE, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x1A, 0xE5, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x04, 0x09, 0x06, 0x1B, 0x0A, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x05, 0x0B, 0x07, 0x1B, 0x23, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x04, 0x09, 0x06, 0x1B, 0x47, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFE, 0x05, 0x08, 0x07, 0x1B, 0x5E, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFE, 0x05, 0x06, 0x06, 0x1B, 0x82, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x08, 0x0B, 0x09, 0x1B, 0x9E, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x07, 0x09, 0x08, 0x1B, 0xCD, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x1B, 0xEF, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFE, 0x04, 0x09, 0x05, 0x1C, 0x0A, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x1C, 0x2A, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x1C, 0x43, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x03, 0x09, 0x04, 0x1C, 0x60, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x04, 0x0A, 0x05, 0x1C, 0x73, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x03, 0x08, 0x04, 0x1C, 0x8D, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x04, 0x0B, 0x05, 0x1C, 0x9F, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x03, 0x09, 0x04, 0x1C, 0xBD, // "ž" (U+017E)
  0x01, 0x7F, 0x00, 0x01, 0x03, 0x08, 0x03, 0x1C, 0xD1, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x06, 0x08, 0x07, 0x1C, 0xE5, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0xFE, 0x04, 0x06, 0x06, 0x1D, 0x04, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x05, 0x06, 0x06, 0x1D, 0x1B, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x03, 0x05, 0x03, 0x06, 0x1D, 0x31, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x0A, 0x03, 0x0B, 0x1D, 0x35, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x04, 0x08, 0x05, 0x1D, 0x39, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0x00, 0x04, 0x09, 0x05, 0x1D, 0x50, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x06, 0x01, 0x08, 0x02, 0x1D, 0x6B, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x06, 0x01, 0x08, 0x02, 0x1D, 0x6F, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0xFF, 0x01, 0x01, 0x03, 0x1D, 0x73, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x06, 0x01, 0x08, 0x02, 0x1D, 0x77, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x06, 0x03, 0x08, 0x04, 0x1D, 0x7B, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x06, 0x03, 0x08, 0x04, 0x1D, 0x83, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0xFF, 0x03, 0x01, 0x04, 0x1D, 0x8B, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x06, 0x03, 0x08, 0x04, 0x1D, 0x93, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x01, 0x04, 0x08, 0x05, 0x1D, 0x9B, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x04, 0x08, 0x05, 0x1D, 0xAD, // "‡" (U+2021)
  0x20, 0x22, 0x00, 0x03, 0x03, 0x05, 0x04, 0x1D, 0xC2, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x06, 0x01, 0x08, 0x1D, 0xCA, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x0B, 0x08, 0x0C, 0x1D, 0xCF, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x01, 0x02, 0x06, 0x03, 0x1D, 0xFC, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x01, 0x02, 0x05, 0x03, 0x1E, 0x06, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x02, 0x08, 0x01, 0x1E, 0x10, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x05, 0x06, 0x08, 0x08, 0x1E, 0x24, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x00, 0x0B, 0x09, 0x0B, 0x1E, 0x34, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x04, 0x08, 0x06, 0x1E, 0x67, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x04, 0x08, 0x06, 0x1E, 0x7D, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0x41, 0x01, // "A (U+0022 U+0041)
  0x00, 0x22, 0x00, 0xC0, 0x01, // "À (U+0022 U+00C0)
  0x00, 0x22, 0x00, 0xC1, 0x01, // "Á (U+0022 U+00C1)
  0x00, 0x22, 0x00, 0xC2, 0x01, // "Â (U+0022 U+00C2)
  0x00, 0x22, 0x00, 0xC3, 0x01, // "Ã (U+0022 U+00C3)
  0x00, 0x22, 0x00, 0xC4, 0x01, // "Ä (U+0022 U+00C4)
  0x00, 0x22, 0x00, 0xC5, 0x01, // "Å (U+0022 U+00C5)
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x22, 0x01, 0x00, 0x01, // "Ā (U+0022 U+0100)
  0x00, 0x22, 0x01, 0x02, 0x01, // "Ă (U+0022 U+0102)
  0x00, 0x22, 0x01, 0x04, 0x01, // "Ą (U+0022 U+0104)
  0x00, 0x27, 0x00, 0x41, 0x01, // 'A (U+0027 U+0041)
  0x00, 0x27, 0x00, 0xC0, 0x01, // 'À (U+0027 U+00C0)
  0x00, 0x27, 0x00, 0xC1, 0x01, // 'Á (U+0027 U+00C1)
  0x00, 0x27, 0x00, 0xC2, 0x01, // 'Â (U+0027 U+00C2)
  0x00, 0x27, 0x00, 0xC3, 0x01, // 'Ã (U+0027 U+00C3)
  0x00, 0x27, 0x00, 0xC4, 0x01, // 'Ä (U+0027 U+00C4)
  0x00, 0x27, 0x00, 0xC5, 0x01, // 'Å (U+0027 U+00C5)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x27, 0x01, 0x00, 0x01, // 'Ā (U+0027 U+0100)
  0x00, 0x27, 0x01, 0x02, 0x01, // 'Ă (U+0027 U+0102)
  0x00, 0x27, 0x01, 0x04, 0x01, // 'Ą (U+0027 U+0104)
  0x00, 0x2C, 0x00, 0x54, 0x01, // ,T (U+002C U+0054)
  0x00, 0x2C, 0x01, 0x62, 0x01, // ,Ţ (U+002C U+0162)
  0x00, 0x2C, 0x01, 0x64, 0x01, // ,Ť (U+002C U+0164)
  0x00, 0x2C, 0x01, 0x66, 0x01, // ,Ŧ (U+002C U+0166)
  0x00, 0x2E, 0x00, 0x54, 0x01, // .T (U+002E U+0054)
  0x00, 0x2E, 0x01, 0x62, 0x01, // .Ţ (U+002E U+0162)
  0x00, 0x2E, 0x01, 0x64, 0x01, // .Ť (U+002E U+0164)
  0x00, 0x2E, 0x01, 0x66, 0x01, // .Ŧ (U+002E U+0166)
  0x00, 0x30, 0x20, 0x44, 0x01, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x01, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x01, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x01, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x01, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x01, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x01, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x01, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x01, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x01, // 9⁄ (U+0039 U+2044)
  0x00, 0x41, 0x00, 0x22, 0x01, // A" (U+0041 U+0022)
  0x00, 0x41, 0x00, 0x27, 0x01, // A' (U+0041 U+0027)
  0x00, 0x41, 0x20, 0x19, 0x01, // A’ (U+0041 U+2019)
  0x00, 0x41, 0x20, 0x1D, 0x01, // A” (U+0041 U+201D)
  0x00, 0x46, 0x00, 0x2C, 0x01, // F, (U+0046 U+002C)
  0x00, 0x46, 0x00, 0x2E, 0x01, // F. (U+0046 U+002E)
  0x00, 0x46, 0x20, 0x1A, 0x01, // F‚ (U+0046 U+201A)
  0x00, 0x46, 0x20, 0x1E, 0x01, // F„ (U+0046 U+201E)
  0x00, 0x46, 0x20, 0x26, 0x01, // F… (U+0046 U+2026)
  0x00, 0x4C, 0x00, 0x22, 0x01, // L" (U+004C U+0022)
  0x00, 0x4C, 0x00, 0x27, 0x01, // L' (U+004C U+0027)
  0x00, 0x4C, 0x20, 0x19, 0x01, // L’ (U+004C U+2019)
  0x00, 0x4C, 0x20, 0x1D, 0x01, // L” (U+004C U+201D)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0x54, 0x00, 0x61, 0x01, // Ta (U+0054 U+0061)
  0x00, 0x54, 0x00, 0x63, 0x01, // Tc (U+0054 U+0063)
  0x00, 0x54, 0x00, 0x64, 0x01, // Td (U+0054 U+0064)
  0x00, 0x54, 0x00, 0x65, 0x01, // Te (U+0054 U+0065)
  0x00, 0x54, 0x00, 0x67, 0x01, // Tg (U+0054 U+0067)
  0x00, 0x54, 0x00, 0x6F, 0x01, // To (U+0054 U+006F)
  0x00, 0x54, 0x00, 0x71, 0x01, // Tq (U+0054 U+0071)
  0x00, 0x54, 0x00, 0xE0, 0x01, // Tà (U+0054 U+00E0)
  0x00, 0x54, 0x00, 0xE1, 0x01, // Tá (U+0054 U+00E1)
  0x00, 0x54, 0x00, 0xE2, 0x01, // Tâ (U+0054 U+00E2)
  0x00, 0x54, 0x00, 0xE3, 0x01, // Tã (U+0054 U+00E3)
  0x00, 0x54, 0x00, 0xE4, 0x01, // Tä (U+0054 U+00E4)
  0x00, 0x54, 0x00, 0xE5, 0x01, // Tå (U+0054 U+00E5)
  0x00, 0x54, 0x00, 0xE6, 0x01, // Tæ (U+0054 U+00E6)
  0x00, 0x54, 0x00, 0xE7, 0x01, // Tç (U+0054 U+00E7)
  0x00, 0x54, 0x00, 0xE8, 0x01, // Tè (U+0054 U+00E8)
  0x00, 0x54, 0x00, 0xE9, 0x01, // Té (U+0054 U+00E9)
  0x00, 0x54, 0x00, 0xEA, 0x01, // Tê (U+0054 U+00EA)
  0x00, 0x54, 0x00, 0xEB, 0x01, // Të (U+0054 U+00EB)
  0x00, 0x54, 0x00, 0xF2, 0x01, // Tò (U+0054 U+00F2)
  0x00, 0x54, 0x00, 0xF3, 0x01, // Tó (U+0054 U+00F3)
  0x00, 0x54, 0x00, 0xF4, 0x01, // Tô (U+0054 U+00F4)
  0x00, 0x54, 0x00, 0xF5, 0x01, // Tõ (U+0054 U+00F5)
  0x00, 0x54, 0x00, 0xF6, 0x01, // Tö (U+0054 U+00F6)
  0x00, 0x54, 0x00, 0xF8, 0x01, // Tø (U+0054 U+00F8)
  0x00, 0x54, 0x01, 0x01, 0x01, // Tā (U+0054 U+0101)
  0x00, 0x54, 0x01, 0x03, 0x01, // Tă (U+0054 U+0103)
  0x00, 0x54, 0x01, 0x05, 0x01, // Tą (U+0054 U+0105)
  0x00, 0x54, 0x01, 0x07, 0x01, // Tć (U+0054 U+0107)
  0x00, 0x54, 0x01, 0x09, 0x01, // Tĉ (U+0054 U+0109)
  0x00, 0x54, 0x01, 0x0B, 0x01, // Tċ (U+0054 U+010B)
  0x00, 0x54, 0x01, 0x0D, 0x01, // Tč (U+0054 U+010D)
  0x00, 0x54, 0x01, 0x0F, 0x01, // Tď (U+0054 U+010F)
  0x00, 0x54, 0x01, 0x11, 0x01, // Tđ (U+0054 U+0111)
  0x00, 0x54, 0x01, 0x13, 0x01, // Tē (U+0054 U+0113)
  0x00, 0x54, 0x01, 0x15, 0x01, // Tĕ (U+0054 U+0115)
  0x00, 0x54, 0x01, 0x17, 0x01, // Tė (U+0054 U+0117)
  0x00, 0x54, 0x01, 0x19, 0x01, // Tę (U+0054 U+0119)
  0x00, 0x54, 0x01, 0x1B, 0x01, // Tě (U+0054 U+011B)
  0x00, 0x54, 0x01, 0x1D, 0x01, // Tĝ (U+0054 U+011D)
  0x00, 0x54, 0x01, 0x1F, 0x01, // Tğ (U+0054 U+011F)
  0x00, 0x54, 0x01, 0x21, 0x01, // Tġ (U+0054 U+0121)
  0x00, 0x54, 0x01, 0x23, 0x01, // Tģ (U+0054 U+0123)
  0x00, 0x54, 0x01, 0x4D, 0x01, // Tō (U+0054 U+014D)
  0x00, 0x54, 0x01, 0x4F, 0x01, // Tŏ (U+0054 U+014F)
  0x00, 0x54, 0x01, 0x51, 0x01, // Tő (U+0054 U+0151)
  0x00, 0x54, 0x01, 0x53, 0x01, // Tœ (U+0054 U+0153)
  0x00, 0x59, 0x00, 0xAB, 0x01, // Y« (U+0059 U+00AB)
  0x00, 0x59, 0x20, 0x39, 0x01, // Y‹ (U+0059 U+2039)
  0x00, 0x72, 0x00, 0x2C, 0x01, // r, (U+0072 U+002C)
  0x00, 0x72, 0x00, 0x2E, 0x01, // r. (U+0072 U+002E)
  0x00, 0x72, 0x20, 0x1A, 0x01, // r‚ (U+0072 U+201A)
  0x00, 0x72, 0x20, 0x1E, 0x01, // r„ (U+0072 U+201E)
  0x00, 0x72, 0x20, 0x26, 0x01, // r… (U+0072 U+2026)
  0x00, 0xBB, 0x00, 0x59, 0x01, // »Y (U+00BB U+0059)
  0x00, 0xBB, 0x00, 0xDD, 0x01, // »Ý (U+00BB U+00DD)
  0x00, 0xBB, 0x01, 0x76, 0x01, // »Ŷ (U+00BB U+0176)
  0x00, 0xBB, 0x01, 0x78, 0x01, // »Ÿ (U+00BB U+0178)
  0x00, 0xC0, 0x00, 0x22, 0x01, // À" (U+00C0 U+0022)
  0x00, 0xC0, 0x00, 0x27, 0x01, // À' (U+00C0 U+0027)
  0x00, 0xC0, 0x20, 0x19, 0x01, // À’ (U+00C0 U+2019)
  0x00, 0xC0, 0x20, 0x1D, 0x01, // À” (U+00C0 U+201D)
  0x00, 0xC1, 0x00, 0x22, 0x01, // Á" (U+00C1 U+0022)
  0x00, 0xC1, 0x00, 0x27, 0x01, // Á' (U+00C1 U+0027)
  0x00, 0xC1, 0x20, 0x19, 0x01, // Á’ (U+00C1 U+2019)
  0x00, 0xC1, 0x20, 0x1D, 0x01, // Á” (U+00C1 U+201D)
  0x00, 0xC2, 0x00, 0x22, 0x01, // Â" (U+00C2 U+0022)
  0x00, 0xC2, 0x00, 0x27, 0x01, // Â' (U+00C2 U+0027)
  0x00, 0xC2, 0x20, 0x19, 0x01, // Â’ (U+00C2 U+2019)
  0x00, 0xC2, 0x20, 0x1D, 0x01, // Â” (U+00C2 U+201D)
  0x00, 0xC3, 0x00, 0x22, 0x01, // Ã" (U+00C3 U+0022)
  0x00, 0xC3, 0x00, 0x27, 0x01, // Ã' (U+00C3 U+0027)
  0x00, 0xC3, 0x20, 0x19, 0x01, // Ã’ (U+00C3 U+2019)
  0x00, 0xC3, 0x20, 0x1D, 0x01, // Ã” (U+00C3 U+201D)
  0x00, 0xC4, 0x00, 0x22, 0x01, // Ä" (U+00C4 U+0022)
  0x00, 0xC4, 0x00, 0x27, 0x01, // Ä' (U+00C4 U+0027)
  0x00, 0xC4, 0x20, 0x19, 0x01, // Ä’ (U+00C4 U+2019)
  0x00, 0xC4, 0x20, 0x1D, 0x01, // Ä” (U+00C4 U+201D)
  0x00, 0xC5, 0x00, 0x22, 0x01, // Å" (U+00C5 U+0022)
  0x00, 0xC5, 0x00, 0x27, 0x01, // Å' (U+00C5 U+0027)
  0x00, 0xC5, 0x20, 0x19, 0x01, // Å’ (U+00C5 U+2019)
  0x00, 0xC5, 0x20, 0x1D, 0x01, // Å” (U+00C5 U+201D)
  0x00, 0xDD, 0x00, 0xAB, 0x01, // Ý« (U+00DD U+00AB)
  0x00, 0xDD, 0x20, 0x39, 0x01, // Ý‹ (U+00DD U+2039)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x01, 0x00, 0x00, 0x22, 0x01, // Ā" (U+0100 U+0022)
  0x01, 0x00, 0x00, 0x27, 0x01, // Ā' (U+0100 U+0027)
  0x01, 0x00, 0x20, 0x19, 0x01, // Ā’ (U+0100 U+2019)
  0x01, 0x00, 0x20, 0x1D, 0x01, // Ā” (U+0100 U+201D)
  0x01, 0x02, 0x00, 0x22, 0x01, // Ă" (U+0102 U+0022)
  0x01, 0x02, 0x00, 0x27, 0x01, // Ă' (U+0102 U+0027)
  0x01, 0x02, 0x20, 0x19, 0x01, // Ă’ (U+0102 U+2019)
  0x01, 0x02, 0x20, 0x1D, 0x01, // Ă” (U+0102 U+201D)
  0x01, 0x04, 0x00, 0x22, 0x01, // Ą" (U+0104 U+0022)
  0x01, 0x04, 0x00, 0x27, 0x01, // Ą' (U+0104 U+0027)
  0x01, 0x04, 0x20, 0x19, 0x01, // Ą’ (U+0104 U+2019)
  0x01, 0x04, 0x20, 0x1D, 0x01, // Ą” (U+0104 U+201D)
  0x01, 0x39, 0x00, 0x22, 0x01, // Ĺ" (U+0139 U+0022)
  0x01, 0x39, 0x00, 0x27, 0x01, // Ĺ' (U+0139 U+0027)
  0x01, 0x39, 0x20, 0x19, 0x01, // Ĺ’ (U+0139 U+2019)
  0x01, 0x39, 0x20, 0x1D, 0x01, // Ĺ” (U+0139 U+201D)
  0x01, 0x3B, 0x00, 0x22, 0x01, // Ļ" (U+013B U+0022)
  0x01, 0x3B, 0x00, 0x27, 0x01, // Ļ' (U+013B U+0027)
  0x01, 0x3B, 0x20, 0x19, 0x01, // Ļ’ (U+013B U+2019)
  0x01, 0x3B, 0x20, 0x1D, 0x01, // Ļ” (U+013B U+201D)
  0x01, 0x3D, 0x00, 0x22, 0x01, // Ľ" (U+013D U+0022)
  0x01, 0x3D, 0x00, 0x27, 0x01, // Ľ' (U+013D U+0027)
  0x01, 0x3D, 0x20, 0x19, 0x01, // Ľ’ (U+013D U+2019)
  0x01, 0x3D, 0x20, 0x1D, 0x01, // Ľ” (U+013D U+201D)
  0x01, 0x3F, 0x00, 0x22, 0x01, // Ŀ" (U+013F U+0022)
  0x01, 0x3F, 0x00, 0x27, 0x01, // Ŀ' (U+013F U+0027)
  0x01, 0x3F, 0x20, 0x19, 0x01, // Ŀ’ (U+013F U+2019)
  0x01, 0x3F, 0x20, 0x1D, 0x01, // Ŀ” (U+013F U+201D)
  0x01, 0x41, 0x00, 0x22, 0x01, // Ł" (U+0141 U+0022)
  0x01, 0x41, 0x00, 0x27, 0x01, // Ł' (U+0141 U+0027)
  0x01, 0x41, 0x20, 0x19, 0x01, // Ł’ (U+0141 U+2019)
  0x01, 0x41, 0x20, 0x1D, 0x01, // Ł” (U+0141 U+201D)
  0x01, 0x55, 0x00, 0x2C, 0x01, // ŕ, (U+0155 U+002C)
  0x01, 0x55, 0x00, 0x2E, 0x01, // ŕ. (U+0155 U+002E)
  0x01, 0x55, 0x20, 0x1A, 0x01, // ŕ‚ (U+0155 U+201A)
  0x01, 0x55, 0x20, 0x1E, 0x01, // ŕ„ (U+0155 U+201E)
  0x01, 0x55, 0x20, 0x26, 0x01, // ŕ… (U+0155 U+2026)
  0x01, 0x57, 0x00, 0x2C, 0x01, // ŗ, (U+0157 U+002C)
  0x01, 0x57, 0x00, 0x2E, 0x01, // ŗ. (U+0157 U+002E)
  0x01, 0x57, 0x20, 0x1A, 0x01, // ŗ‚ (U+0157 U+201A)
  0x01, 0x57, 0x20, 0x1E, 0x01, // ŗ„ (U+0157 U+201E)
  0x01, 0x57, 0x20, 0x26, 0x01, // ŗ… (U+0157 U+2026)
  0x01, 0x59, 0x00, 0x2C, 0x01, // ř, (U+0159 U+002C)
  0x01, 0x59, 0x00, 0x2E, 0x01, // ř. (U+0159 U+002E)
  0x01, 0x59, 0x20, 0x1A, 0x01, // ř‚ (U+0159 U+201A)
  0x01, 0x59, 0x20, 0x1E, 0x01, // ř„ (U+0159 U+201E)
  0x01, 0x59, 0x20, 0x26, 0x01, // ř… (U+0159 U+2026)
  0x01, 0x62, 0x00, 0x61, 0x01, // Ţa (U+0162 U+0061)
  0x01, 0x62, 0x00, 0x63, 0x01, // Ţc (U+0162 U+0063)
  0x01, 0x62, 0x00, 0x64, 0x01, // Ţd (U+0162 U+0064)
  0x01, 0x62, 0x00, 0x65, 0x01, // Ţe (U+0162 U+0065)
  0x01, 0x62, 0x00, 0x67, 0x01, // Ţg (U+0162 U+0067)
  0x01, 0x62, 0x00, 0x6F, 0x01, // Ţo (U+0162 U+006F)
  0x01, 0x62, 0x00, 0x71, 0x01, // Ţq (U+0162 U+0071)
  0x01, 0x62, 0x00, 0xE0, 0x01, // Ţà (U+0162 U+00E0)
  0x01, 0x62, 0x00, 0xE1, 0x01, // Ţá (U+0162 U+00E1)
  0x01, 0x62, 0x00, 0xE2, 0x01, // Ţâ (U+0162 U+00E2)
  0x01, 0x62, 0x00, 0xE3, 0x01, // Ţã (U+0162 U+00E3)
  0x01, 0x62, 0x00, 0xE4, 0x01, // Ţä (U+0162 U+00E4)
  0x01, 0x62, 0x00, 0xE5, 0x01, // Ţå (U+0162 U+00E5)
  0x01, 0x62, 0x00, 0xE6, 0x01, // Ţæ (U+0162 U+00E6)
  0x01, 0x62, 0x00, 0xE7, 0x01, // Ţç (U+0162 U+00E7)
  0x01, 0x62, 0x00, 0xE8, 0x01, // Ţè (U+0162 U+00E8)
  0x01, 0x62, 0x00, 0xE9, 0x01, // Ţé (U+0162 U+00E9)
  0x01, 0x62, 0x00, 0xEA, 0x01, // Ţê (U+0162 U+00EA)
  0x01, 0x62, 0x00, 0xEB, 0x01, // Ţë (U+0162 U+00EB)
  0x01, 0x62, 0x00, 0xF2, 0x01, // Ţò (U+0162 U+00F2)
  0x01, 0x62, 0x00, 0xF3, 0x01, // Ţó (U+0162 U+00F3)
  0x01, 0x62, 0x00, 0xF4, 0x01, // Ţô (U+0162 U+00F4)
  0x01, 0x62, 0x00, 0xF5, 0x01, // Ţõ (U+0162 U+00F5)
  0x01, 0x62, 0x00, 0xF6, 0x01, // Ţö (U+0162 U+00F6)
  0x01, 0x62, 0x00, 0xF8, 0x01, // Ţø (U+0162 U+00F8)
  0x01, 0x62, 0x01, 0x01, 0x01, // Ţā (U+0162 U+0101)
  0x01, 0x62, 0x01, 0x03, 0x01, // Ţă (U+0162 U+0103)
  0x01, 0x62, 0x01, 0x05, 0x01, // Ţą (U+0162 U+0105)
  0x01, 0x62, 0x01, 0x07, 0x01, // Ţć (U+0162 U+0107)
  0x01, 0x62, 0x01, 0x09, 0x01, // Ţĉ (U+0162 U+0109)
  0x01, 0x62, 0x01, 0x0B, 0x01, // Ţċ (U+0162 U+010B)
  0x01, 0x62, 0x01, 0x0D, 0x01, // Ţč (U+0162 U+010D)
  0x01, 0x62, 0x01, 0x0F, 0x01, // Ţď (U+0162 U+010F)
  0x01, 0x62, 0x01, 0x11, 0x01, // Ţđ (U+0162 U+0111)
  0x01, 0x62, 0x01, 0x13, 0x01, // Ţē (U+0162 U+0113)
  0x01, 0x62, 0x01, 0x15, 0x01, // Ţĕ (U+0162 U+0115)
  0x01, 0x62, 0x01, 0x17, 0x01, // Ţė (U+0162 U+0117)
  0x01, 0x62, 0x01, 0x19, 0x01, // Ţę (U+0162 U+0119)
  0x01, 0x62, 0x01, 0x1B, 0x01, // Ţě (U+0162 U+011B)
  0x01, 0x62, 0x01, 0x1D, 0x01, // Ţĝ (U+0162 U+011D)
  0x01, 0x62, 0x01, 0x1F, 0x01, // Ţğ (U+0162 U+011F)
  0x01, 0x62, 0x01, 0x21, 0x01, // Ţġ (U+0162 U+0121)
  0x01, 0x62, 0x01, 0x23, 0x01, // Ţģ (U+0162 U+0123)
  0x01, 0x62, 0x01, 0x4D, 0x01, // Ţō (U+0162 U+014D)
  0x01, 0x62, 0x01, 0x4F, 0x01, // Ţŏ (U+0162 U+014F)
  0x01, 0x62, 0x01, 0x51, 0x01, // Ţő (U+0162 U+0151)
  0x01, 0x62, 0x01, 0x53, 0x01, // Ţœ (U+0162 U+0153)
  0x01, 0x64, 0x00, 0x61, 0x01, // Ťa (U+0164 U+0061)
  0x01, 0x64, 0x00, 0x63, 0x01, // Ťc (U+0164 U+0063)
  0x01, 0x64, 0x00, 0x64, 0x01, // Ťd (U+0164 U+0064)
  0x01, 0x64, 0x00, 0x65, 0x01, // Ťe (U+0164 U+0065)
  0x01, 0x64, 0x00, 0x67, 0x01, // Ťg (U+0164 U+0067)
  0x01, 0x64, 0x00, 0x6F, 0x01, // Ťo (U+0164 U+006F)
  0x01, 0x64, 0x00, 0x71, 0x01, // Ťq (U+0164 U+0071)
  0x01, 0x64, 0x00, 0xE0, 0x01, // Ťà (U+0164 U+00E0)
  0x01, 0x64, 0x00, 0xE1, 0x01, // Ťá (U+0164 U+00E1)
  0x01, 0x64, 0x00, 0xE2, 0x01, // Ťâ (U+0164 U+00E2)
  0x01, 0x64, 0x00, 0xE3, 0x01, // Ťã (U+0164 U+00E3)
  0x01, 0x64, 0x00, 0xE4, 0x01, // Ťä (U+0164 U+00E4)
  0x01, 0x64, 0x00, 0xE5, 0x01, // Ťå (U+0164 U+00E5)
  0x01, 0x64, 0x00, 0xE6, 0x01, // Ťæ (U+0164 U+00E6)
  0x01, 0x64, 0x00, 0xE7, 0x01, // Ťç (U+0164 U+00E7)
  0x01, 0x64, 0x00, 0xE8, 0x01, // Ťè (U+0164 U+00E8)
  0x01, 0x64, 0x00, 0xE9, 0x01, // Ťé (U+0164 U+00E9)
  0x01, 0x64, 0x00, 0xEA, 0x01, // Ťê (U+0164 U+00EA)
  0x01, 0x64, 0x00, 0xEB, 0x01, // Ťë (U+0164 U+00EB)
  0x01, 0x64, 0x00, 0xF2, 0x01, // Ťò (U+0164 U+00F2)
  0x01, 0x64, 0x00, 0xF3, 0x01, // Ťó (U+0164 U+00F3)
  0x01, 0x64, 0x00, 0xF4, 0x01, // Ťô (U+0164 U+00F4)
  0x01, 0x64, 0x00, 0xF5, 0x01, // Ťõ (U+0164 U+00F5)
  0x01, 0x64, 0x00, 0xF6, 0x01, // Ťö (U+0164 U+00F6)
  0x01, 0x64, 0x00, 0xF8, 0x01, // Ťø (U+0164 U+00F8)
  0x01, 0x64, 0x01, 0x01, 0x01, // Ťā (U+0164 U+0101)
  0x01, 0x64, 0x01, 0x03, 0x01, // Ťă (U+0164 U+0103)
  0x01, 0x64, 0x01, 0x05, 0x01, // Ťą (U+0164 U+0105)
  0x01, 0x64, 0x01, 0x07, 0x01, // Ťć (U+0164 U+0107)
  0x01, 0x64, 0x01, 0x09, 0x01, // Ťĉ (U+0164 U+0109)
  0x01, 0x64, 0x01, 0x0B, 0x01, // Ťċ (U+0164 U+010B)
  0x01, 0x64, 0x01, 0x0D, 0x01, // Ťč (U+0164 U+010D)
  0x01, 0x64, 0x01, 0x0F, 0x01, // Ťď (U+0164 U+010F)
  0x01, 0x64, 0x01, 0x11, 0x01, // Ťđ (U+0164 U+0111)
  0x01, 0x64, 0x01, 0x13, 0x01, // Ťē (U+0164 U+0113)
  0x01, 0x64, 0x01, 0x15, 0x01, // Ťĕ (U+0164 U+0115)
  0x01, 0x64, 0x01, 0x17, 0x01, // Ťė (U+0164 U+0117)
  0x01, 0x64, 0x01, 0x19, 0x01, // Ťę (U+0164 U+0119)
  0x01, 0x64, 0x01, 0x1B, 0x01, // Ťě (U+0164 U+011B)
  0x01, 0x64, 0x01, 0x1D, 0x01, // Ťĝ (U+0164 U+011D)
  0x01, 0x64, 0x01, 0x1F, 0x01, // Ťğ (U+0164 U+011F)
  0x01, 0x64, 0x01, 0x21, 0x01, // Ťġ (U+0164 U+0121)
  0x01, 0x64, 0x01, 0x23, 0x01, // Ťģ (U+0164 U+0123)
  0x01, 0x64, 0x01, 0x4D, 0x01, // Ťō (U+0164 U+014D)
  0x01, 0x64, 0x01, 0x4F, 0x01, // Ťŏ (U+0164 U+014F)
  0x01, 0x64, 0x01, 0x51, 0x01, // Ťő (U+0164 U+0151)
  0x01, 0x64, 0x01, 0x53, 0x01, // Ťœ (U+0164 U+0153)
  0x01, 0x66, 0x00, 0x61, 0x01, // Ŧa (U+0166 U+0061)
  0x01, 0x66, 0x00, 0x63, 0x01, // Ŧc (U+0166 U+0063)
  0x01, 0x66, 0x00, 0x64, 0x01, // Ŧd (U+0166 U+0064)
  0x01, 0x66, 0x00, 0x65, 0x01, // Ŧe (U+0166 U+0065)
  0x01, 0x66, 0x00, 0x67, 0x01, // Ŧg (U+0166 U+0067)
  0x01, 0x66, 0x00, 0x6F, 0x01, // Ŧo (U+0166 U+006F)
  0x01, 0x66, 0x00, 0x71, 0x01, // Ŧq (U+0166 U+0071)
  0x01, 0x66, 0x00, 0xE0, 0x01, // Ŧà (U+0166 U+00E0)
  0x01, 0x66, 0x00, 0xE1, 0x01, // Ŧá (U+0166 U+00E1)
  0x01, 0x66, 0x00, 0xE2, 0x01, // Ŧâ (U+0166 U+00E2)
  0x01, 0x66, 0x00, 0xE3, 0x01, // Ŧã (U+0166 U+00E3)
  0x01, 0x66, 0x00, 0xE4, 0x01, // Ŧä (U+0166 U+00E4)
  0x01, 0x66, 0x00, 0xE5, 0x01, // Ŧå (U+0166 U+00E5)
  0x01, 0x66, 0x00, 0xE6, 0x01, // Ŧæ (U+0166 U+00E6)
  0x01, 0x66, 0x00, 0xE7, 0x01, // Ŧç (U+0166 U+00E7)
  0x01, 0x66, 0x00, 0xE8, 0x01, // Ŧè (U+0166 U+00E8)
  0x01, 0x66, 0x00, 0xE9, 0x01, // Ŧé (U+0166 U+00E9)
  0x01, 0x66, 0x00, 0xEA, 0x01, // Ŧê (U+0166 U+00EA)
  0x01, 0x66, 0x00, 0xEB, 0x01, // Ŧë (U+0166 U+00EB)
  0x01, 0x66, 0x00, 0xF2, 0x01, // Ŧò (U+0166 U+00F2)
  0x01, 0x66, 0x00, 0xF3, 0x01, // Ŧó (U+0166 U+00F3)
  0x01, 0x66, 0x00, 0xF4, 0x01, // Ŧô (U+0166 U+00F4)
  0x01, 0x66, 0x00, 0xF5, 0x01, // Ŧõ (U+0166 U+00F5)
  0x01, 0x66, 0x00, 0xF6, 0x01, // Ŧö (U+0166 U+00F6)
  0x01, 0x66, 0x00, 0xF8, 0x01, // Ŧø (U+0166 U+00F8)
  0x01, 0x66, 0x01, 0x01, 0x01, // Ŧā (U+0166 U+0101)
  0x01, 0x66, 0x01, 0x03, 0x01, // Ŧă (U+0166 U+0103)
  0x01, 0x66, 0x01, 0x05, 0x01, // Ŧą (U+0166 U+0105)
  0x01, 0x66, 0x01, 0x07, 0x01, // Ŧć (U+0166 U+0107)
  0x01, 0x66, 0x01, 0x09, 0x01, // Ŧĉ (U+0166 U+0109)
  0x01, 0x66, 0x01, 0x0B, 0x01, // Ŧċ (U+0166 U+010B)
  0x01, 0x66, 0x01, 0x0D, 0x01, // Ŧč (U+0166 U+010D)
  0x01, 0x66, 0x01, 0x0F, 0x01, // Ŧď (U+0166 U+010F)
  0x01, 0x66, 0x01, 0x11, 0x01, // Ŧđ (U+0166 U+0111)
  0x01, 0x66, 0x01, 0x13, 0x01, // Ŧē (U+0166 U+0113)
  0x01, 0x66, 0x01, 0x15, 0x01, // Ŧĕ (U+0166 U+0115)
  0x01, 0x66, 0x01, 0x17, 0x01, // Ŧė (U+0166 U+0117)
  0x01, 0x66, 0x01, 0x19, 0x01, // Ŧę (U+0166 U+0119)
  0x01, 0x66, 0x01, 0x1B, 0x01, // Ŧě (U+0166 U+011B)
  0x01, 0x66, 0x01, 0x1D, 0x01, // Ŧĝ (U+0166 U+011D)
  0x01, 0x66, 0x01, 0x1F, 0x01, // Ŧğ (U+0166 U+011F)
  0x01, 0x66, 0x01, 0x21, 0x01, // Ŧġ (U+0166 U+0121)
  0x01, 0x66, 0x01, 0x23, 0x01, // Ŧģ (U+0166 U+0123)
  0x01, 0x66, 0x01, 0x4D, 0x01, // Ŧō (U+0166 U+014D)
  0x01, 0x66, 0x01, 0x4F, 0x01, // Ŧŏ (U+0166 U+014F)
  0x01, 0x66, 0x01, 0x51, 0x01, // Ŧő (U+0166 U+0151)
  0x01, 0x66, 0x01, 0x53, 0x01, // Ŧœ (U+0166 U+0153)
  0x01, 0x76, 0x00, 0xAB, 0x01, // Ŷ« (U+0176 U+00AB)
  0x01, 0x76, 0x20, 0x39, 0x01, // Ŷ‹ (U+0176 U+2039)
  0x01, 0x78, 0x00, 0xAB, 0x01, // Ÿ« (U+0178 U+00AB)
  0x01, 0x78, 0x20, 0x39, 0x01, // Ÿ‹ (U+0178 U+2039)
  0x20, 0x18, 0x00, 0x41, 0x01, // ‘A (U+2018 U+0041)
  0x20, 0x18, 0x00, 0xC0, 0x01, // ‘À (U+2018 U+00C0)
  0x20, 0x18, 0x00, 0xC1, 0x01, // ‘Á (U+2018 U+00C1)
  0x20, 0x18, 0x00, 0xC2, 0x01, // ‘Â (U+2018 U+00C2)
  0x20, 0x18, 0x00, 0xC3, 0x01, // ‘Ã (U+2018 U+00C3)
  0x20, 0x18, 0x00, 0xC4, 0x01, // ‘Ä (U+2018 U+00C4)
  0x20, 0x18, 0x00, 0xC5, 0x01, // ‘Å (U+2018 U+00C5)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x18, 0x01, 0x00, 0x01, // ‘Ā (U+2018 U+0100)
  0x20, 0x18, 0x01, 0x02, 0x01, // ‘Ă (U+2018 U+0102)
  0x20, 0x18, 0x01, 0x04, 0x01, // ‘Ą (U+2018 U+0104)
  0x20, 0x19, 0x00, 0x41, 0x01, // ’A (U+2019 U+0041)
  0x20, 0x19, 0x00, 0xC0, 0x01, // ’À (U+2019 U+00C0)
  0x20, 0x19, 0x00, 0xC1, 0x01, // ’Á (U+2019 U+00C1)
  0x20, 0x19, 0x00, 0xC2, 0x01, // ’Â (U+2019 U+00C2)
  0x20, 0x19, 0x00, 0xC3, 0x01, // ’Ã (U+2019 U+00C3)
  0x20, 0x19, 0x00, 0xC4, 0x01, // ’Ä (U+2019 U+00C4)
  0x20, 0x19, 0x00, 0xC5, 0x01, // ’Å (U+2019 U+00C5)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x19, 0x01, 0x00, 0x01, // ’Ā (U+2019 U+0100)
  0x20, 0x19, 0x01, 0x02, 0x01, // ’Ă (U+2019 U+0102)
  0x20, 0x19, 0x01, 0x04, 0x01, // ’Ą (U+2019 U+0104)
  0x20, 0x1A, 0x00, 0x54, 0x01, // ‚T (U+201A U+0054)
  0x20, 0x1A, 0x01, 0x62, 0x01, // ‚Ţ (U+201A U+0162)
  0x20, 0x1A, 0x01, 0x64, 0x01, // ‚Ť (U+201A U+0164)
  0x20, 0x1A, 0x01, 0x66, 0x01, // ‚Ŧ (U+201A U+0166)
  0x20, 0x1C, 0x00, 0x41, 0x01, // “A (U+201C U+0041)
  0x20, 0x1C, 0x00, 0xC0, 0x01, // “À (U+201C U+00C0)
  0x20, 0x1C, 0x00, 0xC1, 0x01, // “Á (U+201C U+00C1)
  0x20, 0x1C, 0x00, 0xC2, 0x01, // “Â (U+201C U+00C2)
  0x20, 0x1C, 0x00, 0xC3, 0x01, // “Ã (U+201C U+00C3)
  0x20, 0x1C, 0x00, 0xC4, 0x01, // “Ä (U+201C U+00C4)
  0x20, 0x1C, 0x00, 0xC5, 0x01, // “Å (U+201C U+00C5)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1C, 0x01, 0x00, 0x01, // “Ā (U+201C U+0100)
  0x20, 0x1C, 0x01, 0x02, 0x01, // “Ă (U+201C U+0102)
  0x20, 0x1C, 0x01, 0x04, 0x01, // “Ą (U+201C U+0104)
  0x20, 0x1D, 0x00, 0x41, 0x01, // ”A (U+201D U+0041)
  0x20, 0x1D, 0x00, 0xC0, 0x01, // ”À (U+201D U+00C0)
  0x20, 0x1D, 0x00, 0xC1, 0x01, // ”Á (U+201D U+00C1)
  0x20, 0x1D, 0x00, 0xC2, 0x01, // ”Â (U+201D U+00C2)
  0x20, 0x1D, 0x00, 0xC3, 0x01, // ”Ã (U+201D U+00C3)
  0x20, 0x1D, 0x00, 0xC4, 0x01, // ”Ä (U+201D U+00C4)
  0x20, 0x1D, 0x00, 0xC5, 0x01, // ”Å (U+201D U+00C5)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x1D, 0x01, 0x00, 0x01, // ”Ā (U+201D U+0100)
  0x20, 0x1D, 0x01, 0x02, 0x01, // ”Ă (U+201D U+0102)
  0x20, 0x1D, 0x01, 0x04, 0x01, // ”Ą (U+201D U+0104)
  0x20, 0x1E, 0x00, 0x54, 0x01, // „T (U+201E U+0054)
  0x20, 0x1E, 0x01, 0x62, 0x01, // „Ţ (U+201E U+0162)
  0x20, 0x1E, 0x01, 0x64, 0x01, // „Ť (U+201E U+0164)
  0x20, 0x1E, 0x01, 0x66, 0x01, // „Ŧ (U+201E U+0166)
  0x20, 0x3A, 0x00, 0x59, 0x01, // ›Y (U+203A U+0059)
  0x20, 0x3A, 0x00, 0xDD, 0x01, // ›Ý (U+203A U+00DD)
  0x20, 0x3A, 0x01, 0x76, 0x01, // ›Ŷ (U+203A U+0176)
  0x20, 0x3A, 0x01, 0x78, 0x01, // ›Ÿ (U+203A U+0178)
  0x20, 0x44, 0x00, 0x30, 0x01, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x01, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x01, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x01, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x01, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x01, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x01, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x01, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x01, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x01, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x89, 0x23, 0xF3, 0xF2, 0xE2, 0xD1, 0xD0, 0xC2, 0x02, 0x0C,
  // """ (U+0022)
  0x89, 0x25, 0xC4, 0xC3, 0xB3, 0xB2, 0x82, 0x80,
  // "#" (U+0023)
  0x28, 0x1C, 0x0B, 0x28, 0x96, 0x2A, 0x39, 0x05, 0xDE, 0xDD, 0x70, 0x66, 0x75, 0x28, 0x95, 0x84,
  0x93, 0x0A, 0xFE, 0xFE, 0x40, 0xC0, 0xD3, 0x81, 0xC0, 0xC2,
  // "$" (U+0024)
  0x20, 0x92, 0x89, 0x31, 0xBF, 0xE6, 0x69, 0x90, 0x15, 0xCB, 0x38, 0x26, 0xEA, 0x12, 0x89, 0x39,
  0x7A, 0x21, 0x96, 0xA4, 0xDF, 0xB2, 0x20, 0x92,
  // "%" (U+0025)
  0x81, 0x1D, 0xB2, 0x0C, 0x28, 0x47, 0x6A, 0x35, 0x82, 0x84, 0x85, 0x85, 0xB2, 0x28, 0x96, 0x76,
  0xA6, 0xB8, 0xB2, 0x1C, 0xB9, 0x5C, 0x49, 0x38, 0x3C, 0x2B, 0x2B, 0x28, 0x46, 0x71, 0xC4, 0x92,
  0x84, 0xC1, 0x09, 0xE3,
  // "&" (U+0026)
  0x18, 0x17, 0xEB, 0x48, 0x2E, 0x2C, 0x43, 0x82, 0xC4, 0xE2, 0x38, 0x17, 0xF6, 0x38, 0xB2, 0x2E,
  0xAA, 0x3D, 0x08, 0x90, 0xCC, 0x80, 0x8A, 0x07, 0xF4, 0x01, 0xCE, 0xB7, 0xD1,
  // "'" (U+0027)
  0x84, 0x5C, 0x3B, 0x28,
  // "(" (U+0028)
  0x18, 0xA4, 0x3B, 0x0C, 0x32, 0xE0, 0x5A, 0x07, 0x90, 0x79, 0x05, 0xA0, 0x2E, 0x28, 0x3C, 0x30,
  0x4B,
  // ")" (U+0029)
  0x06, 0x08, 0x28, 0xA7, 0xE1, 0x09, 0x60, 0x6A, 0x04, 0xB0, 0x4C, 0x05, 0xA0, 0x97, 0x0E, 0x16,
  0x81,
  // "*" (U+002A)
  0x20, 0xE2, 0x89, 0x46, 0x8D, 0x85, 0x18, 0xE7, 0x10, 0xD3, 0xD1,
  // "+" (U+002B)
  0x20, 0xC0, 0x13, 0x86, 0xC1, 0x08, 0xEF, 0xEC, 0x20, 0xC0, 0x13, 0x0C, 0x01, 0x10,
  // "," (U+002C)
  0x84, 0x2C, 0x4A, 0x76,
  // "-" (U+002D)
  0x81, 0x9E, 0xD0,
  // "." (U+002E)
  0x02, 0x0B,
  // "/" (U+002F)
  0x20, 0x10, 0xD2, 0x07, 0x08, 0x28, 0x3D, 0x20, 0x3C, 0x20, 0x80, 0x62, 0x83, 0xD1, 0x04, 0xB2,
  0x0A, 0x05, 0x20,
  // "0" (U+0030)
  0x18, 0xC4, 0x8E, 0xB0, 0x2D, 0x0A, 0x66, 0xA0, 0x6A, 0x79, 0x05, 0xB8, 0x90, 0x5C, 0x6A, 0x06,
  0xA3, 0xD0, 0xA7, 0x08, 0xEB, 0x10,
  // "1" (U+0031)
  0x28, 0x90, 0xB9, 0x1C, 0xC9, 0x05, 0x79, 0x20, 0x70, 0x92, 0x07, 0x09, 0x20, 0x70, 0x92, 0x07,
  0x09, 0x20, 0x70, 0x90,
  // "2" (U+0032)
  0x89, 0x02, 0xCE, 0xB0, 0x24, 0x0B, 0x73, 0x09, 0x07, 0x30, 0xD0, 0x32, 0x08, 0x0A, 0x28, 0x54,
  0xD1, 0x01, 0xE3, 0x28, 0x39, 0xFE, 0xEA,
  // "3" (U+0033)
  0x89, 0x03, 0xCE, 0xC1, 0x12, 0x0A, 0x82, 0x85, 0x1C, 0x50, 0x8F, 0xA3, 0x81, 0x1B, 0x73, 0x81,
  0x6B, 0x22, 0x85, 0xB8, 0x6E, 0xEA, 0x10,
  // "4" (U+0034)
  0x28, 0x13, 0xF3, 0x38, 0x1B, 0xE3, 0x28, 0x25, 0x9D, 0x32, 0x89, 0x7C, 0x1D, 0x30, 0x77, 0x0D,
  0x30, 0xBE, 0xEF, 0xE1, 0x30, 0xD0, 0x34, 0x0D, 0x03, 0x10,
  // "5" (U+0035)
  0x85, 0x1F, 0xEE, 0x42, 0xC3, 0x03, 0x0B, 0x38, 0x90, 0x4F, 0xEB, 0x10, 0x10, 0xA9, 0x38, 0x16,
  0xB1, 0x28, 0x4B, 0x84, 0xEE, 0xA1,
  // "6" (U+0036)
  0x18, 0x53, 0xCE, 0x50, 0xD4, 0x20, 0x40, 0xB3, 0x8A, 0x76, 0xBC, 0xD2, 0x7D, 0x07, 0xA6, 0xA0,
  0x4C, 0x2D, 0x07, 0x90, 0x7E, 0xC1,
  // "7" (U+0037)
  0x83, 0x8E, 0xEE, 0xD3, 0x07, 0x09, 0x30, 0xD0, 0x32, 0x03, 0x0D, 0x30, 0x90, 0x83, 0x0E, 0x02,
  0x20, 0x50, 0xC3, 0x0A, 0x07, 0x20,
  // "8" (U+0038)
  0x18, 0xC5, 0xAE, 0xC2, 0x5C, 0x08, 0x94, 0xD0, 0x98, 0x09, 0xDC, 0x01, 0xD7, 0xD3, 0x89, 0x04,
  0xC7, 0xA0, 0x6B, 0x1B, 0xEC, 0x30,
  // "9" (U+0039)
  0x18, 0xA6, 0xAE, 0xA0, 0x5B, 0x0A, 0x68, 0x80, 0x5A, 0x6B, 0x09, 0xB0, 0xBD, 0xAA, 0x30, 0x70,
  0x82, 0x85, 0x2D, 0x22, 0xED, 0x51,
  // ":" (U+003A)
  0x82, 0x3D, 0x2A, 0x60, 0x20, 0xC0,
  // ";" (U+003B)
  0x82, 0x3D, 0x2A, 0x68, 0x43, 0xE5, 0xA7, 0x40,
  // "<" (U+003C)
  0x40, 0x32, 0x89, 0x14, 0xC9, 0x3B, 0xA2, 0x05, 0xD7, 0x48, 0x17, 0xD7, 0x40, 0x50,
  // "=" (U+003D)
  0x83, 0x8E, 0xEE, 0xC5, 0x83, 0x8E, 0xEE, 0xC0,
  // ">" (U+003E)
  0x03, 0x48, 0x15, 0xD6, 0x38, 0x21, 0x7C, 0x62, 0x89, 0x05, 0xC8, 0x4C, 0x91, 0x04, 0x13,
  // "?" (U+003F)
  0x86, 0x8E, 0xD3, 0x20, 0x6B, 0x20, 0x50, 0xB2, 0x83, 0xD5, 0x07, 0x92, 0x0B, 0x02, 0x20, 0x13,
  0x0B, 0x03, 0x10,
  // "@" (U+0040)
  0x28, 0x37, 0xDE, 0xB2, 0x28, 0xE0, 0x7A, 0x10, 0x4D, 0x01, 0xD1, 0xBE, 0x88, 0x55, 0x86, 0x84,
  0x94, 0x86, 0x68, 0x45, 0x83, 0x85, 0x78, 0x68, 0x97, 0x63, 0xB2, 0xD8, 0xAC, 0x10, 0xB7, 0x20,
  0x23, 0x83, 0x19, 0xED, 0x92,
  // "A" (U+0041)
  0x20, 0xE0, 0xA3, 0x81, 0x3D, 0xE3, 0x82, 0x79, 0xD3, 0x28, 0x2B, 0x59, 0x82, 0x98, 0x32, 0x5C,
  0x04, 0xC8, 0x11, 0x99, 0x28, 0x2D, 0x5D, 0x52, 0x08, 0x0A,
  // "B" (U+0042)
  0x8B, 0x52, 0xFE, 0xE9, 0x02, 0xF0, 0x1E, 0x32, 0xF0, 0x1E, 0x22, 0xFE, 0xF8, 0x02, 0xF0, 0x1E,
  0x42, 0x92, 0x89, 0x3B, 0x62, 0xF0, 0x1E, 0x42, 0xFE, 0xE8, 0x10,
  // "C" (U+0043)
  0x18, 0x93, 0x2B, 0xED, 0x20, 0xD7, 0x02, 0x03, 0xE4, 0x05, 0x0C, 0x40, 0x50, 0xC4, 0x03, 0x0E,
  0x58, 0x2D, 0x70, 0x12, 0x82, 0x3C, 0xED, 0x10,
  // "D" (U+0044)
  0x89, 0x32, 0xFE, 0xD7, 0x02, 0xF0, 0x2D, 0x52, 0x92, 0x81, 0x6B, 0x29, 0x28, 0x14, 0xD2, 0x92,
  0x81, 0x4D, 0x29, 0x28, 0x93, 0x7B, 0x2F, 0x02, 0xD4, 0x2F, 0xED, 0x71,
  // "E" (U+0045)
  0x84, 0x2F, 0xEE, 0x62, 0x93, 0x02, 0x93, 0x84, 0x2F, 0xEE, 0x42, 0x93, 0x02, 0x93, 0x02, 0x93,
  0x83, 0x2F, 0xEE, 0x60,
  // "F" (U+0046)
  0x84, 0x2F, 0xEE, 0x62, 0x93, 0x02, 0x93, 0x02, 0x93, 0x84, 0x2F, 0xEE, 0x42, 0x93, 0x02, 0x93,
  0x02, 0x93,
  // "G" (U+0047)
  0x18, 0x61, 0xAE, 0xE9, 0x0C, 0x92, 0x81, 0x33, 0xE4, 0x05, 0x0C, 0x48, 0x66, 0xC0, 0x4E, 0xF3,
  0xE2, 0x89, 0x41, 0xF0, 0xD7, 0x01, 0xF0, 0x2B, 0xEE, 0xB0,
  // "H" (U+0048)
  0x02, 0x92, 0x81, 0x4C, 0x29, 0x28, 0x14, 0xC2, 0x92, 0x87, 0x4C, 0x2F, 0xEE, 0xEC, 0x29, 0x28,
  0x14, 0xC2, 0x92, 0x81, 0x4C, 0x29, 0x28, 0x14, 0xC2, 0x92, 0x04, 0x0C,
  // "I" (U+0049)
  0x8A, 0x67, 0xFD, 0x0D, 0x40, 0xD4, 0x0D, 0x40, 0xD4, 0x0D, 0x40, 0xD4, 0x7F, 0xD0,
  // "J" (U+004A)
  0x18, 0xB3, 0x2E, 0x02, 0xE0, 0x2E, 0x02, 0xE0, 0x2E, 0x02, 0xE0, 0x2E, 0x02, 0xE0, 0x5D, 0x9D,
  0x50,
  // "K" (U+004B)
  0x02, 0x92, 0x8A, 0x0D, 0x42, 0xF0, 0x8A, 0x02, 0xF2, 0xE1, 0x02, 0xFB, 0x82, 0x82, 0x2F, 0xBD,
  0x28, 0x93, 0x2F, 0x0D, 0x50, 0x2F, 0x05, 0xD0, 0x29, 0x20, 0xC0, 0x60,
  // "L" (U+004C)
  0x02, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02, 0xB0,
  0x70,
  // "M" (U+004D)
  0x81, 0x2F, 0x93, 0x83, 0xDC, 0x2E, 0xD2, 0x8E, 0x13, 0xEC, 0x2D, 0xC2, 0x07, 0xAC, 0x2E, 0x87,
  0x0C, 0x6C, 0x2E, 0x3C, 0x1D, 0x3C, 0x2E, 0x0E, 0x78, 0x3C, 0x2E, 0x09, 0xF3, 0x3C, 0x2E, 0x05,
  0xE0, 0x3C,
  // "N" (U+004E)
  0x81, 0x2F, 0x62, 0x83, 0xD3, 0x2F, 0xD2, 0x8B, 0x6D, 0x32, 0xDC, 0x60, 0xD3, 0x2D, 0x4D, 0x0D,
  0x32, 0xE0, 0xC5, 0xD3, 0x2E, 0x05, 0xCC, 0x32, 0xE2, 0x83, 0xDF, 0x32, 0xE2, 0x81, 0x5F, 0x30,
  // "O" (U+004F)
  0x18, 0x33, 0xCE, 0xC2, 0x28, 0x6D, 0x60, 0x7C, 0x03, 0xE3, 0x82, 0xE2, 0x5C, 0x38, 0x2D, 0x56,
  0xB3, 0x82, 0xD5, 0x3E, 0x38, 0x6E, 0x20, 0xD6, 0x07, 0xC2, 0x83, 0x3C, 0xEC, 0x21,
  // "P" (U+0050)
  0x89, 0x32, 0xFE, 0xD5, 0x02, 0xF0, 0x4E, 0x02, 0x92, 0x98, 0x94, 0x12, 0xF0, 0x5E, 0x02, 0xFE,
  0xC3, 0x02, 0x94, 0x02, 0x94, 0x02, 0x94,
  // "Q" (U+0051)
  0x18, 0x33, 0xCE, 0xC2, 0x28, 0x6D, 0x60, 0x7C, 0x03, 0xE3, 0x82, 0xE2, 0x5C, 0x38, 0x2D, 0x46,
  0xB3, 0x82, 0xD4, 0x3E, 0x38, 0x6E, 0x30, 0xD6, 0x07, 0xD2, 0x83, 0x3C, 0xEE, 0x24, 0x81, 0x1E,
  0x25, 0x08, 0x0C, 0x10,
  // "R" (U+0052)
  0x89, 0x32, 0xFE, 0xD5, 0x02, 0xF0, 0x4E, 0x02, 0x92, 0x98, 0xB0, 0x12, 0xF0, 0x5E, 0x02, 0xFE,
  0xF3, 0x02, 0xF0, 0xD4, 0x02, 0xF0, 0x5C, 0x02, 0x92, 0x0D, 0x05,
  // "S" (U+0053)
  0x18, 0x91, 0x9E, 0xD4, 0x6C, 0x01, 0x16, 0xC3, 0x82, 0x1D, 0xC3, 0x28, 0x21, 0x9F, 0x33, 0x81,
  0x99, 0x22, 0x84, 0xA7, 0x6E, 0xEA, 0x10,
  // "T" (U+0054)
  0x85, 0xCE, 0xFE, 0xA0, 0x19, 0x30, 0x19, 0x30, 0x19, 0x30, 0x19, 0x30, 0x19, 0x30, 0x19, 0x30,
  0x19, 0x20,
  // "U" (U+0055)
  0x03, 0x0E, 0x28, 0x25, 0xB3, 0xE2, 0x82, 0x5B, 0x3E, 0x28, 0x25, 0xB3, 0xE2, 0x82, 0x5B, 0x3E,
  0x28, 0x25, 0xB2, 0xE2, 0x89, 0x46, 0xB0, 0xE3, 0x0A, 0x80, 0x4D, 0xEA, 0x10,
  // "V" (U+0056)
  0x0D, 0x04, 0x28, 0x2B, 0x79, 0x82, 0x89, 0x3E, 0x25, 0xC0, 0x3E, 0x01, 0xF0, 0x79, 0x28, 0x2C,
  0x4B, 0x52, 0x82, 0x88, 0xE1, 0x28, 0x13, 0xDC, 0x40, 0xE0, 0x82,
  // "W" (U+0057)
  0x82, 0xC4, 0x03, 0x92, 0x8B, 0x28, 0x99, 0x70, 0x7F, 0x30, 0xB6, 0x6A, 0x0A, 0xB7, 0x0E, 0x22,
  0xD0, 0xE5, 0xA2, 0xE2, 0x85, 0xE3, 0xC1, 0xD5, 0xB2, 0x85, 0xB9, 0x90, 0xD9, 0x82, 0x85, 0x8E,
  0x60, 0x9E, 0x42, 0x85, 0x4F, 0x20, 0x6F, 0x11,
  // "X" (U+0058)
  0x89, 0x48, 0x90, 0x5D, 0x1E, 0x1B, 0x60, 0x99, 0xE2, 0x81, 0x2F, 0x72, 0x81, 0x4F, 0x82, 0x89,
  0x4B, 0x7E, 0x13, 0xD0, 0xA7, 0xA6, 0x03, 0xE0,
  // "Y" (U+0059)
  0x8A, 0x1C, 0x50, 0x3D, 0x6B, 0x09, 0x70, 0xE3, 0xE1, 0x09, 0xDA, 0x28, 0x12, 0xF4, 0x39, 0x01,
  0x39, 0x01, 0x39, 0x01, 0x10,
  // "Z" (U+005A)
  0x83, 0x8E, 0xEF, 0x72, 0x81, 0x1E, 0x22, 0x07, 0x0A, 0x30, 0xE0, 0x32, 0x06, 0x0B, 0x30, 0xD0,
  0x42, 0x05, 0x0C, 0x38, 0x3A, 0xFE, 0xE7,
  // "[" (U+005B)
  0x84, 0x3F, 0xE2, 0x3C, 0x20, 0x30, 0xC2, 0x03, 0x0C, 0x20, 0x30, 0xC2, 0x03, 0x0C, 0x20, 0x30,
  0xC2, 0x03, 0x0C, 0x20, 0x30, 0xC2, 0x82, 0x3E, 0xE2,
  // "\" (U+005C)
  0x0A, 0x05, 0x20, 0x40, 0xA3, 0x0E, 0x01, 0x20, 0x90, 0x62, 0x03, 0x0C, 0x30, 0xD0, 0x22, 0x07,
  0x08, 0x20, 0x10, 0xD0,
  // "]" (U+005D)
  0x8B, 0x49, 0xEA, 0x04, 0xA0, 0x4A, 0x04, 0xA0, 0x4A, 0x04, 0xA0, 0x4A, 0x04, 0xA0, 0x4A, 0x9E,
  0xA0,
  // "^" (U+005E)
  0x20, 0x53, 0x81, 0x1F, 0x72, 0x89, 0x49, 0x6D, 0x01, 0xD0, 0x77, 0x86, 0x01, 0xD0,
  // "_" (U+005F)
  0x80, 0x0E, 0x0C,
  // "`" (U+0060)
  0x03, 0x06, 0x20, 0x90, 0x60,
  // "a" (U+0061)
  0x18, 0xB3, 0xBE, 0xC1, 0x01, 0x0B, 0x61, 0xBE, 0xF7, 0x7A, 0x09, 0x78, 0x90, 0xC7, 0x2D, 0xC9,
  0x70,
  // "b" (U+0062)
  0x03, 0x0D, 0x40, 0x30, 0xD4, 0x89, 0x43, 0xDA, 0xE6, 0x03, 0xF2, 0x3E, 0x03, 0xD2, 0x82, 0xE2,
  0x3D, 0x28, 0x93, 0xE2, 0x3F, 0x23, 0xE0, 0x3B, 0xBE, 0x61,
  // "c" (U+0063)
  0x18, 0x78, 0xED, 0x3D, 0x11, 0x79, 0x20, 0x70, 0x92, 0x86, 0x4D, 0x01, 0x09, 0xED,
  // "d" (U+0064)
  0x30, 0x20, 0xE3, 0x8B, 0x62, 0xE0, 0xAE, 0x9E, 0x4D, 0x06, 0xE7, 0x90, 0x2E, 0x79, 0x02, 0xE4,
  0xD0, 0x6E, 0x0A, 0xE8, 0xE0,
  // "e" (U+0065)
  0x18, 0x96, 0x8E, 0xC1, 0x3B, 0x07, 0x87, 0xFE, 0xEA, 0x79, 0x38, 0x90, 0x3E, 0x10, 0x10, 0x8E,
  0xD5,
  // "f" (U+0066)
  0x18, 0x92, 0xAE, 0x51, 0xF1, 0x0A, 0xFE, 0x11, 0x92, 0x01, 0x92, 0x01, 0x92, 0x01, 0x92, 0x01,
  0x92,
  // "g" (U+0067)
  0x18, 0xB3, 0x9E, 0x8E, 0x4D, 0x06, 0xE7, 0x90, 0x2E, 0x79, 0x02, 0xE4, 0xD0, 0x6E, 0x0A, 0xE9,
  0xE3, 0x89, 0x22, 0xD1, 0x20, 0x7B, 0x2D, 0xEC, 0x20,
  // "h" (U+0068)
  0x03, 0x0D, 0x30, 0x30, 0xD3, 0x8B, 0x33, 0xDB, 0xE6, 0x3F, 0x24, 0xD3, 0xD0, 0x1F, 0x3D, 0x01,
  0xF3, 0xD0, 0x1F, 0x3D, 0x01, 0x90,
  // "i" (U+0069)
  0x02, 0x0A, 0x28, 0x92, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D,
  // "j" (U+006A)
  0x10, 0x20, 0xA4, 0x8B, 0x03, 0xD0, 0x3D, 0x03, 0xD0, 0x3D, 0x03, 0xD0, 0x3D, 0x03, 0xD0, 0x4C,
  0x4E, 0x60,
  // "k" (U+006B)
  0x03, 0x0D, 0x30, 0x30, 0xD3, 0x8B, 0x43, 0xD0, 0x98, 0x3D, 0x4C, 0x03, 0xDE, 0x50, 0x3F, 0x9B,
  0x03, 0xD0, 0xD4, 0x3D, 0x06, 0xC0,
  // "l" (U+006C)
  0x89, 0x63, 0xD3, 0xD3, 0xD3, 0xD3, 0xD3, 0xD3, 0xD3, 0xD0,
  // "m" (U+006D)
  0x8D, 0x63, 0xBB, 0xE6, 0xBE, 0x43, 0xF2, 0x6F, 0x16, 0xB3, 0xD0, 0x4D, 0x04, 0xC3, 0xD0, 0x4C,
  0x04, 0xC3, 0xD0, 0x4C, 0x04, 0xC3, 0xD0, 0x4C, 0x04, 0xC0,
  // "n" (U+006E)
  0x8B, 0x33, 0xBA, 0xE6, 0x3F, 0x24, 0xD3, 0xD0, 0x1F, 0x3D, 0x01, 0xF3, 0xD0, 0x1F, 0x3D, 0x01,
  0x90,
  // "o" (U+006F)
  0x18, 0xB3, 0x8E, 0xC2, 0x4D, 0x05, 0xC7, 0x90, 0x1F, 0x79, 0x01, 0xF3, 0xD0, 0x5C, 0x08, 0xED,
  0x30,
  // "p" (U+0070)
  0x89, 0x43, 0xBA, 0xE6, 0x03, 0xF2, 0x3E, 0x03, 0xD2, 0x82, 0xE2, 0x3D, 0x28, 0x96, 0xE2, 0x3F,
  0x23, 0xE0, 0x3D, 0xAE, 0x60, 0x3D, 0x40, 0x30, 0xD4, 0x03, 0x0D, 0x40,
  // "q" (U+0071)
  0x18, 0xB3, 0x9E, 0x8E, 0x4D, 0x06, 0xE7, 0x90, 0x2E, 0x79, 0x02, 0xE4, 0xD0, 0x6E, 0x0A, 0xE8,
  0xE3, 0x02, 0x0E, 0x30, 0x20, 0xE3, 0x02, 0x0E,
  // "r" (U+0072)
  0x89, 0x03, 0xBB, 0x93, 0xF3, 0x03, 0xD2, 0x03, 0x0D, 0x20, 0x30, 0xD2, 0x03, 0x0D, 0x20,
  // "s" (U+0073)
  0x89, 0x12, 0xDE, 0x98, 0x90, 0x14, 0xE6, 0x28, 0x91, 0x2B, 0x92, 0x04, 0xD7, 0xEE, 0x50,
  // "t" (U+0074)
  0x10, 0x63, 0x0D, 0x28, 0x4A, 0xFE, 0x12, 0xE2, 0x02, 0x0E, 0x20, 0x20, 0xE2, 0x02, 0x0E, 0x38,
  0x1B, 0xE2,
  // "u" (U+0075)
  0x8B, 0x44, 0xC0, 0x2E, 0x4C, 0x02, 0xE4, 0xC0, 0x2E, 0x4C, 0x02, 0xE3, 0xE0, 0x6E, 0x0A, 0xD8,
  0xE0,
  // "v" (U+0076)
  0x89, 0x4C, 0x40, 0x88, 0x88, 0x0C, 0x43, 0xC1, 0xE2, 0x81, 0xE6, 0xA2, 0x81, 0xAC, 0x62, 0x81,
  0x5F, 0x11,
  // "w" (U+0077)
  0x8B, 0x5C, 0x40, 0xE7, 0x0B, 0x48, 0x73, 0xDA, 0x0E, 0x05, 0xB6, 0x7D, 0x3C, 0x01, 0xE9, 0x3C,
  0x89, 0x28, 0x4D, 0xD0, 0x8D, 0x52, 0x84, 0xAC, 0x05, 0xF1, 0x10,
  // "x" (U+0078)
  0x87, 0x8A, 0x0C, 0x51, 0xE7, 0xC2, 0x81, 0x7F, 0x42, 0x89, 0x48, 0xF5, 0x01, 0xE5, 0xD0, 0x98,
  0x0B, 0x60,
  // "y" (U+0079)
  0x89, 0x4C, 0x40, 0x89, 0x88, 0x0C, 0x43, 0xD0, 0xE2, 0x81, 0xE6, 0xB2, 0x81, 0x9C, 0x72, 0x81,
  0x5F, 0x22, 0x03, 0x0D, 0x30, 0x08, 0x28, 0x1B, 0xC1, 0x20,
  // "z" (U+007A)
  0x82, 0x8E, 0xFA, 0x28, 0x3C, 0x40, 0x5C, 0x28, 0x3C, 0x50, 0x4C, 0x28, 0x2A, 0xFE, 0xA0,
  // "{" (U+007B)
  0x18, 0x41, 0xC9, 0x06, 0xA2, 0x07, 0x09, 0x28, 0x49, 0x70, 0x9D, 0x12, 0x0A, 0x06, 0x20, 0x70,
  0x82, 0x07, 0x09, 0x20, 0x50, 0xB3, 0x0B, 0x09,
  // "|" (U+007C)
  0x80, 0x7E,
  // "}" (U+007D)
  0x81, 0x8C, 0x22, 0x09, 0x07, 0x20, 0x08, 0x20, 0x60, 0xA2, 0x84, 0x1D, 0xA0, 0x6A, 0x20, 0x08,
  0x20, 0x80, 0x72, 0x84, 0xA6, 0x08, 0xB1, 0x10,
  // "~" (U+007E)
  0x89, 0x04, 0xD9, 0x26, 0x50, 0x6D, 0x80,
  // "¡" (U+00A1)
  0x89, 0x52, 0xD2, 0xB1, 0xC1, 0xD2, 0xD2, 0xE3, 0xF4, 0x90,
  // "¢" (U+00A2)
  0x20, 0x05, 0x28, 0x56, 0xED, 0x40, 0xE3, 0x20, 0x19, 0x30, 0x19, 0x48, 0x7E, 0x40, 0x10, 0x4D,
  0xD3, 0x20, 0x50, 0x41,
  // "£" (U+00A3)
  0x18, 0x92, 0x2C, 0xE7, 0x09, 0x80, 0x10, 0xB6, 0x30, 0xB0, 0x62, 0x82, 0x8F, 0xEE, 0x20, 0xB0,
  0x63, 0x0D, 0x03, 0x28, 0x38, 0xFE, 0xEC,
  // "¤" (U+00A4)
  0x10, 0x14, 0x89, 0x12, 0xCD, 0xDC, 0x40, 0xC2, 0x1C, 0x20, 0xB2, 0x89, 0x49, 0x20, 0xC2, 0x1C,
  0x02, 0xCC, 0xDC, 0x40,
  // "¥" (U+00A5)
  0x8A, 0x78, 0x80, 0x5C, 0x2E, 0x0A, 0x60, 0xC4, 0xE1, 0x06, 0xD9, 0x03, 0xCF, 0xC6, 0x28, 0x6E,
  0x20, 0x3E, 0xFE, 0x72, 0x0E, 0x02, 0x10,
  // "¦" (U+00A6)
  0x80, 0x0E, 0x38, 0x00, 0xE0,
  // "§" (U+00A7)
  0x8B, 0x61, 0xCE, 0xA5, 0xA0, 0x10, 0xD9, 0x15, 0x84, 0xD4, 0xC4, 0xC0, 0x2B, 0xA2, 0x01, 0xE5,
  0xEE, 0x70,
  // "¨" (U+00A8)
  0x82, 0x65, 0x74,
  // "©" (U+00A9)
  0x28, 0x36, 0xCE, 0xD7, 0x38, 0xA3, 0x89, 0xAD, 0xE8, 0xA0, 0x3A, 0x4B, 0x01, 0x08, 0x46, 0x47,
  0x73, 0x8A, 0x52, 0x86, 0x34, 0xB0, 0x10, 0x18, 0x28, 0x09, 0xDB, 0x06, 0x40, 0x66, 0x30, 0x50,
  0x83, 0x83, 0x39, 0x99, 0x42,
  // "ª" (U+00AA)
  0x89, 0x25, 0xFC, 0x0A, 0x2C, 0x07, 0xAC, 0x10,
  // "«" (U+00AB)
  0x28, 0xA5, 0x10, 0x10, 0x79, 0x4C, 0x3D, 0x2D, 0x35, 0xD2, 0xE2, 0x09, 0x85, 0xB2, 0x81, 0x20,
  0x20,
  // "¬" (U+00AC)
  0x83, 0x8E, 0xEE, 0xC3, 0x01, 0x0C, 0x40, 0xC0,
  // "®" (U+00AE)
  0x28, 0x36, 0xCE, 0xD7, 0x38, 0xD5, 0x89, 0xFE, 0xC8, 0xA0, 0x3A, 0x0D, 0x0D, 0x18, 0x46, 0x40,
  0xEE, 0xA0, 0x28, 0x63, 0x0D, 0x2B, 0x01, 0x82, 0x80, 0xD0, 0xB3, 0x64, 0x06, 0x63, 0x05, 0x08,
  0x38, 0x33, 0x99, 0x94, 0x20,
  // "¯" (U+00AF)
  0x80, 0x1E, 0x01,
  // "°" (U+00B0)
  0x89, 0x22, 0xCD, 0x47, 0x63, 0xA2, 0xCD, 0x40,
  // "±" (U+00B1)
  0x20, 0xC0, 0x13, 0x86, 0xC1, 0x08, 0xEF, 0xEC, 0x20, 0xC0, 0x13, 0x0C, 0x01, 0x68, 0x38, 0xEE,
  0xEC,
  // "²" (U+00B2)
  0x85, 0x5B, 0x90, 0x10, 0xC2, 0x83, 0x3A, 0x02, 0xB2, 0x82, 0x9C, 0xB2,
  // "³" (U+00B3)
  0x85, 0x5B, 0x90, 0x10, 0xC2, 0x0D, 0x0A, 0x38, 0x3B, 0x27, 0xB9, 0x10,
  // "´" (U+00B4)
  0x18, 0x25, 0x44, 0xB1,
  // "µ" (U+00B5)
  0x8B, 0x63, 0xD0, 0x1F, 0x3D, 0x01, 0xF3, 0xD0, 0x1F, 0x3D, 0x02, 0xF3, 0xE0, 0x6F, 0x3E, 0xD9,
  0xE3, 0xC3, 0x03, 0x0D, 0x30, 0x30, 0xD3,
  // "¶" (U+00B6)
  0x18, 0x39, 0xFE, 0xF3, 0xA8, 0x17, 0xA5, 0xA8, 0x17, 0xA5, 0xA8, 0x17, 0xA2, 0xA8, 0x57, 0xA0,
  0x5A, 0x7A, 0x28, 0x13, 0x7A, 0x28, 0x13, 0x7A, 0x28, 0x13, 0x7A, 0x28, 0x12, 0x79,
  // "·" (U+00B7)
  0x02, 0x0B,
  // "¸" (U+00B8)
  0x84, 0x43, 0x3D, 0xC9,
  // "¹" (U+00B9)
  0x18, 0x94, 0xA9, 0x47, 0x90, 0x49, 0x04, 0x90, 0x49,
  // "º" (U+00BA)
  0x89, 0x53, 0xBB, 0x09, 0x37, 0x59, 0x37, 0x42, 0xA9, 0x10,
  // "»" (U+00BB)
  0x38, 0xB0, 0x10, 0x5B, 0x2D, 0x10, 0xB7, 0x7A, 0x09, 0x86, 0xC4, 0xC2, 0xD1, 0x11, 0x02, 0x10,
  // "¼" (U+00BC)
  0x81, 0x1C, 0x72, 0x84, 0x58, 0x04, 0x77, 0x20, 0xC0, 0x12, 0x83, 0x57, 0x06, 0x73, 0x89, 0x55,
  0x70, 0xC0, 0xA7, 0x05, 0x77, 0x63, 0xD7, 0x28, 0x41, 0xC0, 0xA6, 0x72, 0x87, 0x85, 0x3C, 0xCD,
  0x01, 0xC3, 0x05, 0x07,
  // "½" (U+00BD)
  0x81, 0x1C, 0x72, 0x87, 0x85, 0x05, 0x87, 0x01, 0xC3, 0x83, 0x67, 0x09, 0x43, 0x89, 0x56, 0x72,
  0xB6, 0xB7, 0x06, 0x7A, 0x32, 0x0D, 0x20, 0x30, 0xB2, 0x05, 0x07, 0x28, 0x3B, 0x30, 0x49, 0x20,
  0x30, 0x92, 0x81, 0xCE, 0xE0,
  // "¾" (U+00BE)
  0x81, 0x5D, 0xA2, 0x02, 0x0B, 0x28, 0x11, 0x0C, 0x20, 0xA0, 0x33, 0x83, 0xEA, 0x03, 0xA3, 0x89,
  0x71, 0x0B, 0x2B, 0x27, 0xA0, 0x8E, 0xB4, 0xA1, 0xBA, 0x48, 0x3B, 0x29, 0x4A, 0x38, 0x54, 0x90,
  0xCB, 0xE2, 0x20, 0xC0, 0x12, 0x02, 0x0A, 0x10,
  // "¿" (U+00BF)
  0x10, 0x30, 0xB3, 0x01, 0x20, 0x20, 0xB2, 0x83, 0x97, 0x05, 0xD2, 0x0B, 0x05, 0x28, 0x6B, 0x60,
  0x23, 0xDE, 0x80,
  // "À" (U+00C0)
  0x10, 0x30, 0x65, 0x09, 0x06, 0x73, 0x0E, 0x0A, 0x38, 0x13, 0xDE, 0x38, 0x27, 0x9D, 0x32, 0x82,
  0xB5, 0x98, 0x29, 0x83, 0x25, 0xC0, 0x4C, 0x81, 0x19, 0x92, 0x82, 0xD5, 0xD5, 0x20, 0x80, 0xA0,
  // "Á" (U+00C1)
  0x30, 0x50, 0x43, 0x04, 0x0B, 0x73, 0x0E, 0x0A, 0x38, 0x13, 0xDE, 0x38, 0x27, 0x9D, 0x32, 0x82,
  0xB5, 0x98, 0x29, 0x83, 0x25, 0xC0, 0x4C, 0x81, 0x19, 0x92, 0x82, 0xD5, 0xD5, 0x20, 0x80, 0xA0,
  // "Â" (U+00C2)
  0x20, 0x40, 0x63, 0x82, 0x39, 0x86, 0x72, 0x0E, 0x0A, 0x38, 0x13, 0xDE, 0x38, 0x27, 0x9D, 0x32,
  0x82, 0xB5, 0x98, 0x29, 0x83, 0x25, 0xC0, 0x4C, 0x81, 0x19, 0x92, 0x82, 0xD5, 0xD5, 0x20, 0x80,
  0xA0,
  // "Ã" (U+00C3)
  0x18, 0x22, 0xD5, 0xA2, 0x82, 0x73, 0xA9, 0x72, 0x0E, 0x0A, 0x38, 0x13, 0xDE, 0x38, 0x27, 0x9D,
  0x32, 0x82, 0xB5, 0x98, 0x29, 0x83, 0x25, 0xC0, 0x4C, 0x81, 0x19, 0x92, 0x82, 0xD5, 0xD5, 0x20,
  0x80, 0xA0,
  // "Ä" (U+00C4)
  0x18, 0x26, 0x57, 0x47, 0x20, 0xE0, 0xA3, 0x81, 0x3D, 0xE3, 0x82, 0x79, 0xD3, 0x28, 0x2B, 0x59,
  0x82, 0x98, 0x32, 0x5C, 0x04, 0xC8, 0x11, 0x99, 0x28, 0x2D, 0x5D, 0x52, 0x08, 0x0A,
  // "Å" (U+00C5)
  0x18, 0x12, 0x95, 0x38, 0x18, 0x3A, 0x30, 0x3A, 0x38, 0x13, 0xDE, 0x38, 0x27, 0x9D, 0x32, 0x82,
  0xB5, 0x98, 0x29, 0x83, 0x25, 0xC0, 0x4C, 0x81, 0x19, 0x92, 0x82, 0xD5, 0xD5, 0x20, 0x80, 0xA0,
  // "Æ" (U+00C6)
  0x20, 0x6A, 0x81, 0xEE, 0x42, 0x81, 0xC7, 0xE4, 0x82, 0x2F, 0x3E, 0x48, 0x92, 0x7B, 0x2F, 0xEE,
  0x20, 0xC6, 0x2E, 0x30, 0x29, 0x0F, 0xE3, 0x83, 0x7B, 0x02, 0xE3, 0x86, 0xD5, 0x02, 0xFE, 0xE4,
  // "Ç" (U+00C7)
  0x18, 0x93, 0x2B, 0xED, 0x20, 0xD7, 0x02, 0x03, 0xE4, 0x05, 0x0C, 0x40, 0x50, 0xC4, 0x03, 0x0E,
  0x58, 0x2D, 0x70, 0x12, 0x82, 0x3C, 0xED, 0x30, 0x40, 0x34, 0x03, 0x0D, 0x40, 0xC0, 0x92,
  // "È" (U+00C8)
  0x10, 0x30, 0x64, 0x09, 0x06, 0x68, 0x42, 0xFE, 0xE6, 0x29, 0x30, 0x29, 0x38, 0x42, 0xFE, 0xE4,
  0x29, 0x30, 0x29, 0x30, 0x29, 0x38, 0x32, 0xFE, 0xE6,
  // "É" (U+00C9)
  0x30, 0x50, 0x42, 0x04, 0x0B, 0x68, 0x42, 0xFE, 0xE6, 0x29, 0x30, 0x29, 0x38, 0x42, 0xFE, 0xE4,
  0x29, 0x30, 0x29, 0x30, 0x29, 0x38, 0x32, 0xFE, 0xE6,
  // "Ê" (U+00CA)
  0x20, 0x40, 0x62, 0x82, 0x39, 0x86, 0x58, 0x42, 0xFE, 0xE6, 0x29, 0x30, 0x29, 0x38, 0x42, 0xFE,
  0xE4, 0x29, 0x30, 0x29, 0x30, 0x29, 0x38, 0x32, 0xFE, 0xE6,
  // "Ë" (U+00CB)
  0x18, 0x26, 0x57, 0x45, 0x84, 0x2F, 0xEE, 0x62, 0x93, 0x02, 0x93, 0x84, 0x2F, 0xEE, 0x42, 0x93,
  0x02, 0x93, 0x02, 0x93, 0x83, 0x2F, 0xEE, 0x60,
  // "Ì" (U+00CC)
  0x03, 0x06, 0x20, 0x90, 0x63, 0x8A, 0x67, 0xFD, 0x0D, 0x40, 0xD4, 0x0D, 0x40, 0xD4, 0x0D, 0x40,
  0xD4, 0x7F, 0xD0,
  // "Í" (U+00CD)
  0x28, 0x35, 0x40, 0x4B, 0x58, 0x17, 0xFD, 0x20, 0xD0, 0x42, 0x0D, 0x04, 0x20, 0xD0, 0x42, 0x0D,
  0x04, 0x20, 0xD0, 0x42, 0x84, 0xD4, 0x07, 0xFD, 0x10,
  // "Î" (U+00CE)
  0x18, 0x54, 0x60, 0x39, 0x86, 0x48, 0x17, 0xFD, 0x20, 0xD0, 0x42, 0x0D, 0x04, 0x20, 0xD0, 0x42,
  0x0D, 0x04, 0x20, 0xD0, 0x42, 0x84, 0xD4, 0x07, 0xFD, 0x10,
  // "Ï" (U+00CF)
  0x82, 0x65, 0x74, 0x48, 0x17, 0xFD, 0x20, 0xD0, 0x42, 0x0D, 0x04, 0x20, 0xD0, 0x42, 0x0D, 0x04,
  0x20, 0xD0, 0x42, 0x84, 0xD4, 0x07, 0xFD, 0x10,
  // "Ð" (U+00D0)
  0x89, 0x31, 0xFE, 0xD7, 0x01, 0xF0, 0x2D, 0x51, 0x92, 0x81, 0x6B, 0x19, 0x28, 0x74, 0xDB, 0xFE,
  0x34, 0xD1, 0x92, 0x89, 0x37, 0xB1, 0xF0, 0x2D, 0x41, 0xFE, 0xD7, 0x10,
  // "Ñ" (U+00D1)
  0x18, 0x22, 0xD5, 0xA3, 0x82, 0x73, 0xA9, 0x72, 0x81, 0x2F, 0x62, 0x83, 0xD3, 0x2F, 0xD2, 0x8B,
  0x6D, 0x32, 0xDC, 0x60, 0xD3, 0x2D, 0x4D, 0x0D, 0x32, 0xE0, 0xC5, 0xD3, 0x2E, 0x05, 0xCC, 0x32,
  0xE2, 0x83, 0xDF, 0x32, 0xE2, 0x81, 0x5F, 0x30,
  // "Ò" (U+00D2)
  0x10, 0x30, 0x66, 0x09, 0x06, 0x74, 0x83, 0x3C, 0xEC, 0x22, 0x86, 0xD6, 0x07, 0xC0, 0x3E, 0x38,
  0x2E, 0x25, 0xC3, 0x82, 0xD5, 0x6B, 0x38, 0x2D, 0x53, 0xE3, 0x86, 0xE2, 0x0D, 0x60, 0x7C, 0x28,
  0x33, 0xCE, 0xC2, 0x10,
  // "Ó" (U+00D3)
  0x40, 0x50, 0x44, 0x04, 0x0B, 0x73, 0x83, 0x3C, 0xEC, 0x22, 0x86, 0xD6, 0x07, 0xC0, 0x3E, 0x38,
  0x2E, 0x25, 0xC3, 0x82, 0xD5, 0x6B, 0x38, 0x2D, 0x53, 0xE3, 0x86, 0xE2, 0x0D, 0x60, 0x7C, 0x28,
  0x33, 0xCE, 0xC2, 0x10,
  // "Ô" (U+00D4)
  0x20, 0x40, 0x64, 0x82, 0x39, 0x86, 0x73, 0x83, 0x3C, 0xEC, 0x22, 0x86, 0xD6, 0x07, 0xC0, 0x3E,
  0x38, 0x2E, 0x25, 0xC3, 0x82, 0xD5, 0x6B, 0x38, 0x2D, 0x53, 0xE3, 0x86, 0xE2, 0x0D, 0x60, 0x7C,
  0x28, 0x33, 0xCE, 0xC2, 0x10,
  // "Õ" (U+00D5)
  0x18, 0x22, 0xD5, 0xA3, 0x82, 0x73, 0xA9, 0x73, 0x83, 0x3C, 0xEC, 0x22, 0x86, 0xD6, 0x07, 0xC0,
  0x3E, 0x38, 0x2E, 0x25, 0xC3, 0x82, 0xD5, 0x6B, 0x38, 0x2D, 0x53, 0xE3, 0x86, 0xE2, 0x0D, 0x60,
  0x7C, 0x28, 0x33, 0xCE, 0xC2, 0x10,
  // "Ö" (U+00D6)
  0x28, 0x26, 0x57, 0x47, 0x28, 0x33, 0xCE, 0xC2, 0x28, 0x6D, 0x60, 0x7C, 0x03, 0xE3, 0x82, 0xE2,
  0x5C, 0x38, 0x2D, 0x56, 0xB3, 0x82, 0xD5, 0x3E, 0x38, 0x6E, 0x20, 0xD6, 0x07, 0xC2, 0x83, 0x3C,
  0xEC, 0x21,
  // "×" (U+00D7)
  0x8A, 0x24, 0x90, 0x58, 0x09, 0xBC, 0x10, 0x5E, 0x90, 0x4C, 0x19, 0x84, 0x01,
  // "Ø" (U+00D8)
  0x50, 0x12, 0x83, 0x3C, 0xEB, 0xC2, 0x8C, 0x6D, 0x60, 0xAC, 0x03, 0xE0, 0x1B, 0xF2, 0x5C, 0x09,
  0x3C, 0x45, 0xB2, 0xA0, 0xD4, 0x3E, 0xB1, 0x0E, 0x20, 0xD9, 0x07, 0xC2, 0x83, 0xCC, 0xEC, 0x22,
  0x02, 0x50,
  // "Ù" (U+00D9)
  0x10, 0x30, 0x65, 0x09, 0x06, 0x71, 0x03, 0x0E, 0x28, 0x25, 0xB3, 0xE2, 0x82, 0x5B, 0x3E, 0x28,
  0x25, 0xB3, 0xE2, 0x82, 0x5B, 0x3E, 0x28, 0x25, 0xB2, 0xE2, 0x89, 0x46, 0xB0, 0xE3, 0x0A, 0x80,
  0x4D, 0xEA, 0x10,
  // "Ú" (U+00DA)
  0x30, 0x50, 0x43, 0x04, 0x0B, 0x71, 0x03, 0x0E, 0x28, 0x25, 0xB3, 0xE2, 0x82, 0x5B, 0x3E, 0x28,
  0x25, 0xB3, 0xE2, 0x82, 0x5B, 0x3E, 0x28, 0x25, 0xB2, 0xE2, 0x89, 0x46, 0xB0, 0xE3, 0x0A, 0x80,
  0x4D, 0xEA, 0x10,
  // "Û" (U+00DB)
  0x20, 0x40, 0x63, 0x82, 0x39, 0x86, 0x70, 0x30, 0xE2, 0x82, 0x5B, 0x3E, 0x28, 0x25, 0xB3, 0xE2,
  0x82, 0x5B, 0x3E, 0x28, 0x25, 0xB3, 0xE2, 0x82, 0x5B, 0x2E, 0x28, 0x94, 0x6B, 0x0E, 0x30, 0xA8,
  0x04, 0xDE, 0xA1,
  // "Ü" (U+00DC)
  0x18, 0x26, 0x57, 0x47, 0x03, 0x0E, 0x28, 0x25, 0xB3, 0xE2, 0x82, 0x5B, 0x3E, 0x28, 0x25, 0xB3,
  0xE2, 0x82, 0x5B, 0x3E, 0x28, 0x25, 0xB2, 0xE2, 0x89, 0x46, 0xB0, 0xE3, 0x0A, 0x80, 0x4D, 0xEA,
  0x10,
  // "Ý" (U+00DD)
  0x30, 0x50, 0x42, 0x04, 0x0B, 0x68, 0xA1, 0xC5, 0x03, 0xD6, 0xB0, 0x97, 0x0E, 0x3E, 0x10, 0x9D,
  0xA2, 0x81, 0x2F, 0x43, 0x90, 0x13, 0x90, 0x13, 0x90, 0x11,
  // "Þ" (U+00DE)
  0x02, 0x94, 0x8B, 0x52, 0xFE, 0xC4, 0x02, 0xF0, 0x5E, 0x02, 0xF0, 0x1F, 0x12, 0xF0, 0x5D, 0x02,
  0xFE, 0xC3, 0x02, 0x94, 0x02, 0x94,
  // "ß" (U+00DF)
  0x18, 0xA3, 0x7E, 0xE6, 0x02, 0xE1, 0x4D, 0x03, 0xD0, 0x98, 0x03, 0xD3, 0xD2, 0x8A, 0x63, 0xD1,
  0xE5, 0x03, 0xD0, 0x2E, 0x33, 0xD1, 0x0B, 0x63, 0xD7, 0xEC, 0x10,
  // "à" (U+00E0)
  0x10, 0x30, 0x64, 0x09, 0x06, 0x78, 0xB3, 0xBE, 0xC1, 0x01, 0x0B, 0x61, 0xBE, 0xF7, 0x7A, 0x09,
  0x78, 0x90, 0xC7, 0x2D, 0xC9, 0x70,
  // "á" (U+00E1)
  0x30, 0x50, 0x42, 0x04, 0x0B, 0x78, 0xB3, 0xBE, 0xC1, 0x01, 0x0B, 0x61, 0xBE, 0xF7, 0x7A, 0x09,
  0x78, 0x90, 0xC7, 0x2D, 0xC9, 0x70,
  // "â" (U+00E2)
  0x20, 0x40, 0x62, 0x82, 0x39, 0x86, 0x68, 0xB3, 0xBE, 0xC1, 0x01, 0x0B, 0x61, 0xBE, 0xF7, 0x7A,
  0x09, 0x78, 0x90, 0xC7, 0x2D, 0xC9, 0x70,
  // "ã" (U+00E3)
  0x87, 0x2D, 0x5A, 0x07, 0x3A, 0x97, 0x8B, 0x3B, 0xEC, 0x10, 0x10, 0xB6, 0x1B, 0xEF, 0x77, 0xA0,
  0x97, 0x89, 0x0C, 0x72, 0xDC, 0x97,
  // "ä" (U+00E4)
  0x18, 0x26, 0x57, 0x46, 0x8B, 0x3B, 0xEC, 0x10, 0x10, 0xB6, 0x1B, 0xEF, 0x77, 0xA0, 0x97, 0x89,
  0x0C, 0x72, 0xDC, 0x97,
  // "å" (U+00E5)
  0x18, 0x12, 0x95, 0x28, 0x18, 0x3A, 0x28, 0x13, 0xD7, 0x28, 0xB3, 0xBE, 0xC1, 0x01, 0x0B, 0x61,
  0xBE, 0xF7, 0x7A, 0x09, 0x78, 0x90, 0xC7, 0x2D, 0xC9, 0x70,
  // "æ" (U+00E6)
  0x18, 0x4B, 0xEA, 0x9E, 0xA2, 0x8A, 0x21, 0x0B, 0x90, 0xA5, 0x1B, 0xEF, 0xEE, 0xE7, 0x7A, 0x0A,
  0x73, 0x89, 0x68, 0x90, 0xCC, 0x01, 0x12, 0xDD, 0x39, 0xED, 0x20,
  // "ç" (U+00E7)
  0x18, 0x78, 0xED, 0x3D, 0x11, 0x79, 0x20, 0x70, 0x92, 0x86, 0x4D, 0x01, 0x09, 0xED, 0x20, 0x40,
  0x32, 0x03, 0x0D, 0x20, 0xC0, 0x90,
  // "è" (U+00E8)
  0x10, 0x30, 0x64, 0x09, 0x06, 0x78, 0x96, 0x8E, 0xC1, 0x3B, 0x07, 0x87, 0xFE, 0xEA, 0x79, 0x38,
  0x90, 0x3E, 0x10, 0x10, 0x8E, 0xD5,
  // "é" (U+00E9)
  0x30, 0x50, 0x42, 0x04, 0x0B, 0x78, 0x96, 0x8E, 0xC1, 0x3B, 0x07, 0x87, 0xFE, 0xEA, 0x79, 0x38,
  0x90, 0x3E, 0x10, 0x10, 0x8E, 0xD5,
  // "ê" (U+00EA)
  0x20, 0x40, 0x62, 0x82, 0x39, 0x86, 0x68, 0x96, 0x8E, 0xC1, 0x3B, 0x07, 0x87, 0xFE, 0xEA, 0x79,
  0x38, 0x90, 0x3E, 0x10, 0x10, 0x8E, 0xD5,
  // "ë" (U+00EB)
  0x18, 0x26, 0x57, 0x46, 0x89, 0x68, 0xEC, 0x13, 0xB0, 0x78, 0x7F, 0xEE, 0xA7, 0x93, 0x89, 0x03,
  0xE1, 0x01, 0x08, 0xED, 0x50,
  // "ì" (U+00EC)
  0x03, 0x06, 0x20, 0x90, 0x64, 0x89, 0x73, 0xD0, 0x3D, 0x03, 0xD0, 0x3D, 0x03, 0xD0, 0x3D,
  // "í" (U+00ED)
  0x18, 0x25, 0x44, 0xB4, 0x89, 0x73, 0xD0, 0x3D, 0x03, 0xD0, 0x3D, 0x03, 0xD0, 0x3D, 0x10,
  // "î" (U+00EE)
  0x18, 0x54, 0x60, 0x39, 0x86, 0x50, 0x30, 0xD2, 0x03, 0x0D, 0x20, 0x30, 0xD2, 0x03, 0x0D, 0x20,
  0x30, 0xD2, 0x03, 0x0D, 0x10,
  // "ï" (U+00EF)
  0x82, 0x65, 0x74, 0x50, 0x30, 0xD2, 0x03, 0x0D, 0x20, 0x30, 0xD2, 0x03, 0x0D, 0x20, 0x30, 0xD2,
  0x03, 0x0D, 0x10,
  // "ð" (U+00F0)
  0x18, 0x63, 0xBA, 0x20, 0x4C, 0xD4, 0x89, 0x49, 0x70, 0x9E, 0xCD, 0x5C, 0x05, 0xF7, 0x92, 0x98,
  0x90, 0x5C, 0x04, 0xC0, 0x8E, 0xD3,
  // "ñ" (U+00F1)
  0x18, 0x72, 0xD5, 0xA0, 0x73, 0xA9, 0x58, 0xB3, 0x3B, 0xAE, 0x63, 0xF2, 0x4D, 0x3D, 0x01, 0xF3,
  0xD0, 0x1F, 0x3D, 0x01, 0xF3, 0xD0, 0x19,
  // "ò" (U+00F2)
  0x10, 0x30, 0x64, 0x09, 0x06, 0x78, 0xB3, 0x8E, 0xC2, 0x4D, 0x05, 0xC7, 0x90, 0x1F, 0x79, 0x01,
  0xF3, 0xD0, 0x5C, 0x08, 0xED, 0x30,
  // "ó" (U+00F3)
  0x30, 0x50, 0x42, 0x04, 0x0B, 0x78, 0xB3, 0x8E, 0xC2, 0x4D, 0x05, 0xC7, 0x90, 0x1F, 0x79, 0x01,
  0xF3, 0xD0, 0x5C, 0x08, 0xED, 0x30,
  // "ô" (U+00F4)
  0x20, 0x40, 0x62, 0x82, 0x39, 0x86, 0x68, 0xB3, 0x8E, 0xC2, 0x4D, 0x05, 0xC7, 0x90, 0x1F, 0x79,
  0x01, 0xF3, 0xD0, 0x5C, 0x08, 0xED, 0x30,
  // "õ" (U+00F5)
  0x18, 0x72, 0xD5, 0xA0, 0x73, 0xA9, 0x68, 0xB3, 0x8E, 0xC2, 0x4D, 0x05, 0xC7, 0x90, 0x1F, 0x79,
  0x01, 0xF3, 0xD0, 0x5C, 0x08, 0xED, 0x30,
  // "ö" (U+00F6)
  0x18, 0x26, 0x57, 0x46, 0x8B, 0x38, 0xEC, 0x24, 0xD0, 0x5C, 0x79, 0x01, 0xF7, 0x90, 0x1F, 0x3D,
  0x05, 0xC0, 0x8E, 0xD3,
  // "÷" (U+00F7)
  0x20, 0xB0, 0x16, 0x83, 0x8E, 0xEE, 0xC7, 0x0B, 0x01, 0x10,
  // "ø" (U+00F8)
  0x48, 0xB7, 0x20, 0x8E, 0xC9, 0x4D, 0x0B, 0xB7, 0x94, 0x9F, 0x79, 0xB1, 0xF3, 0xF5, 0x5B, 0x1D,
  0xEC, 0x21, 0x23,
  // "ù" (U+00F9)
  0x10, 0x30, 0x64, 0x09, 0x06, 0x68, 0xB4, 0x4C, 0x02, 0xE4, 0xC0, 0x2E, 0x4C, 0x02, 0xE4, 0xC0,
  0x2E, 0x3E, 0x06, 0xE0, 0xAD, 0x8E,
  // "ú" (U+00FA)
  0x30, 0x50, 0x42, 0x04, 0x0B, 0x68, 0xB4, 0x4C, 0x02, 0xE4, 0xC0, 0x2E, 0x4C, 0x02, 0xE4, 0xC0,
  0x2E, 0x3E, 0x06, 0xE0, 0xAD, 0x8E,
  // "û" (U+00FB)
  0x20, 0x40, 0x62, 0x82, 0x39, 0x86, 0x58, 0xB4, 0x4C, 0x02, 0xE4, 0xC0, 0x2E, 0x4C, 0x02, 0xE4,
  0xC0, 0x2E, 0x3E, 0x06, 0xE0, 0xAD, 0x8E,
  // "ü" (U+00FC)
  0x18, 0x26, 0x57, 0x45, 0x8B, 0x44, 0xC0, 0x2E, 0x4C, 0x02, 0xE4, 0xC0, 0x2E, 0x4C, 0x02, 0xE3,
  0xE0, 0x6E, 0x0A, 0xD8, 0xE0,
  // "ý" (U+00FD)
  0x20, 0x50, 0x42, 0x04, 0x0B, 0x78, 0x94, 0xC4, 0x08, 0x98, 0x80, 0xC4, 0x3D, 0x0E, 0x28, 0x1E,
  0x6B, 0x28, 0x19, 0xC7, 0x28, 0x15, 0xF2, 0x20, 0x30, 0xD3, 0x00, 0x82, 0x81, 0xBC, 0x12,
  // "þ" (U+00FE)
  0x03, 0x0D, 0x40, 0x30, 0xD4, 0x89, 0x43, 0xDA, 0xE6, 0x03, 0xF2, 0x3E, 0x03, 0xD2, 0x82, 0xE2,
  0x3D, 0x28, 0x96, 0xE2, 0x3F, 0x23, 0xE0, 0x3D, 0xAE, 0x60, 0x3D, 0x40, 0x30, 0xD4, 0x03, 0x0D,
  0x40,
  // "ÿ" (U+00FF)
  0x82, 0x65, 0x74, 0x68, 0x94, 0xC4, 0x08, 0x98, 0x80, 0xC4, 0x3D, 0x0E, 0x28, 0x1E, 0x6B, 0x28,
  0x19, 0xC7, 0x28, 0x15, 0xF2, 0x20, 0x30, 0xD3, 0x00, 0x82, 0x81, 0xBC, 0x12,
  // "Ā" (U+0100)
  0x18, 0x28, 0xEE, 0x57, 0x20, 0xE0, 0xA3, 0x81, 0x3D, 0xE3, 0x82, 0x79, 0xD3, 0x28, 0x2B, 0x59,
  0x82, 0x98, 0x32, 0x5C, 0x04, 0xC8, 0x11, 0x99, 0x28, 0x2D, 0x5D, 0x52, 0x08, 0x0A,
  // "ā" (U+0101)
  0x18, 0x28, 0xEE, 0x56, 0x8B, 0x3B, 0xEC, 0x10, 0x10, 0xB6, 0x1B, 0xEF, 0x77, 0xA0, 0x97, 0x89,
  0x0C, 0x72, 0xDC, 0x97,
  // "Ă" (U+0102)
  0x18, 0x24, 0x23, 0x32, 0x82, 0x2D, 0xC2, 0x72, 0x0E, 0x0A, 0x38, 0x13, 0xDE, 0x38, 0x27, 0x9D,
  0x32, 0x82, 0xB5, 0x98, 0x29, 0x83, 0x25, 0xC0, 0x4C, 0x81, 0x19, 0x92, 0x82, 0xD5, 0xD5, 0x20,
  0x80, 0xA0,
  // "ă" (U+0103)
  0x18, 0x74, 0x23, 0x30, 0x2D, 0xC2, 0x68, 0xB3, 0xBE, 0xC1, 0x01, 0x0B, 0x61, 0xBE, 0xF7, 0x7A,
  0x09, 0x78, 0x90, 0xC7, 0x2D, 0xC9, 0x70,
  // "Ą" (U+0104)
  0x20, 0xE0, 0xA3, 0x81, 0x3D, 0xE3, 0x82, 0x79, 0xD3, 0x28, 0x2B, 0x59, 0x82, 0x98, 0x32, 0x5C,
  0x04, 0xC8, 0x11, 0x99, 0x28, 0x2D, 0x5D, 0x52, 0x08, 0x0A, 0x30, 0x10, 0x74, 0x07, 0x05, 0x48,
  0x14, 0xE2,
  // "ą" (U+0105)
  0x18, 0xB3, 0xBE, 0xC1, 0x01, 0x0B, 0x61, 0xBE, 0xF7, 0x7A, 0x09, 0x78, 0x90, 0xC7, 0x2D, 0xC9,
  0x72, 0x01, 0x07, 0x30, 0x70, 0x53, 0x81, 0x4E, 0x20,
  // "Ć" (U+0106)
  0x30, 0x50, 0x43, 0x04, 0x0B, 0x72, 0x89, 0x32, 0xBE, 0xD2, 0x0D, 0x70, 0x20, 0x3E, 0x40, 0x50,
  0xC4, 0x05, 0x0C, 0x40, 0x30, 0xE5, 0x82, 0xD7, 0x01, 0x28, 0x23, 0xCE, 0xD1,
  // "ć" (U+0107)
  0x30, 0x50, 0x42, 0x04, 0x0B, 0x78, 0x91, 0x8E, 0xD0, 0x3D, 0x11, 0x07, 0x93, 0x07, 0x09, 0x38,
  0x24, 0xD0, 0x12, 0x81, 0x9E, 0xD1,
  // "Ĉ" (U+0108)
  0x20, 0x40, 0x63, 0x82, 0x39, 0x86, 0x71, 0x89, 0x32, 0xBE, 0xD2, 0x0D, 0x70, 0x20, 0x3E, 0x40,
  0x50, 0xC4, 0x05, 0x0C, 0x40, 0x30, 0xE5, 0x82, 0xD7, 0x01, 0x28, 0x23, 0xCE, 0xD1,
  // "ĉ" (U+0109)
  0x20, 0x40, 0x62, 0x82, 0x39, 0x86, 0x68, 0x91, 0x8E, 0xD0, 0x3D, 0x11, 0x07, 0x93, 0x07, 0x09,
  0x38, 0x24, 0xD0, 0x12, 0x81, 0x9E, 0xD1,
  // "Ċ" (U+010A)
  0x20, 0x50, 0x77, 0x28, 0x93, 0x2B, 0xED, 0x20, 0xD7, 0x02, 0x03, 0xE4, 0x05, 0x0C, 0x40, 0x50,
  0xC4, 0x03, 0x0E, 0x58, 0x2D, 0x70, 0x12, 0x82, 0x3C, 0xED, 0x10,
  // "ċ" (U+010B)
  0x20, 0x50, 0x75, 0x87, 0x8E, 0xD3, 0xD1, 0x17, 0x92, 0x07, 0x09, 0x28, 0x64, 0xD0, 0x10, 0x9E,
  0xD0,
  // "Č" (U+010C)
  0x18, 0x23, 0x31, 0x43, 0x81, 0xBC, 0x17, 0x18, 0x93, 0x2B, 0xED, 0x20, 0xD7, 0x02, 0x03, 0xE4,
  0x05, 0x0C, 0x40, 0x50, 0xC4, 0x03, 0x0E, 0x58, 0x2D, 0x70, 0x12, 0x82, 0x3C, 0xED, 0x10,
  // "č" (U+010D)
  0x18, 0x23, 0x31, 0x42, 0x81, 0xBC, 0x16, 0x89, 0x18, 0xED, 0x03, 0xD1, 0x10, 0x79, 0x30, 0x70,
  0x93, 0x82, 0x4D, 0x01, 0x28, 0x19, 0xED, 0x10,
  // "Ď" (U+010E)
  0x18, 0x23, 0x31, 0x43, 0x81, 0xBC, 0x17, 0x89, 0x32, 0xFE, 0xD7, 0x02, 0xF0, 0x2D, 0x52, 0x92,
  0x81, 0x6B, 0x29, 0x28, 0x14, 0xD2, 0x92, 0x81, 0x4D, 0x29, 0x28, 0x93, 0x7B, 0x2F, 0x02, 0xD4,
  0x2F, 0xED, 0x71,
  // "ď" (U+010F)
  0x38, 0x32, 0xE0, 0xE1, 0x38, 0x22, 0xE1, 0x92, 0x82, 0xAE, 0x9E, 0x38, 0x34, 0xD0, 0x6E, 0x38,
  0x37, 0x90, 0x2E, 0x38, 0x37, 0x90, 0x2E, 0x38, 0x34, 0xD0, 0x6E, 0x48, 0x2A, 0xE8, 0xE3,
  // "Đ" (U+0110)
  0x89, 0x31, 0xFE, 0xD7, 0x01, 0xF0, 0x2D, 0x51, 0x92, 0x81, 0x6B, 0x19, 0x28, 0x74, 0xDB, 0xFE,
  0x34, 0xD1, 0x92, 0x89, 0x37, 0xB1, 0xF0, 0x2D, 0x41, 0xFE, 0xD7, 0x10,
  // "đ" (U+0111)
  0x28, 0x28, 0xEF, 0x93, 0x02, 0x0E, 0x28, 0xB2, 0xAE, 0x9E, 0x04, 0xD0, 0x6E, 0x07, 0x90, 0x2E,
  0x07, 0x90, 0x2E, 0x04, 0xD0, 0x6E, 0x28, 0x2A, 0xE8, 0xE1,
  // "Ē" (U+0112)
  0x18, 0x28, 0xEE, 0x55, 0x84, 0x2F, 0xEE, 0x62, 0x93, 0x02, 0x93, 0x84, 0x2F, 0xEE, 0x42, 0x93,
  0x02, 0x93, 0x02, 0x93, 0x83, 0x2F, 0xEE, 0x60,
  // "ē" (U+0113)
  0x18, 0x28, 0xEE, 0x56, 0x89, 0x68, 0xEC, 0x13, 0xB0, 0x78, 0x7F, 0xEE, 0xA7, 0x93, 0x89, 0x03,
  0xE1, 0x01, 0x08, 0xED, 0x50,
  // "Ĕ" (U+0114)
  0x18, 0x74, 0x23, 0x30, 0x2D, 0xC2, 0x58, 0x42, 0xFE, 0xE6, 0x29, 0x30, 0x29, 0x38, 0x42, 0xFE,
  0xE4, 0x29, 0x30, 0x29, 0x30, 0x29, 0x38, 0x32, 0xFE, 0xE6,
  // "ĕ" (U+0115)
  0x18, 0x74, 0x23, 0x30, 0x2D, 0xC2, 0x68, 0x96, 0x8E, 0xC1, 0x3B, 0x07, 0x87, 0xFE, 0xEA, 0x79,
  0x38, 0x90, 0x3E, 0x10, 0x10, 0x8E, 0xD5,
  // "Ė" (U+0116)
  0x20, 0x50, 0x76, 0x84, 0x2F, 0xEE, 0x62, 0x93, 0x02, 0x93, 0x84, 0x2F, 0xEE, 0x42, 0x93, 0x02,
  0x93, 0x02, 0x93, 0x83, 0x2F, 0xEE, 0x60,
  // "ė" (U+0117)
  0x20, 0x50, 0x77, 0x89, 0x68, 0xEC, 0x13, 0xB0, 0x78, 0x7F, 0xEE, 0xA7, 0x93, 0x89, 0x03, 0xE1,
  0x01, 0x08, 0xED, 0x50,
  // "Ę" (U+0118)
  0x84, 0x2F, 0xEE, 0x62, 0x93, 0x02, 0x93, 0x84, 0x2F, 0xEE, 0x42, 0x93, 0x02, 0x93, 0x02, 0x93,
  0x83, 0x2F, 0xEE, 0x62, 0x01, 0x07, 0x30, 0x70, 0x53, 0x81, 0x4E, 0x20,
  // "ę" (U+0119)
  0x18, 0xA3, 0x8E, 0xB0, 0x3D, 0x09, 0x77, 0x90, 0x59, 0x7F, 0xEE, 0xA3, 0xB4, 0x82, 0x8D, 0xE6,
  0x30, 0xB3, 0x04, 0x09, 0x38, 0x11, 0xE6,
  // "Ě" (U+011A)
  0x18, 0x23, 0x31, 0x42, 0x81, 0xBC, 0x15, 0x84, 0x2F, 0xEE, 0x62, 0x93, 0x02, 0x93, 0x84, 0x2F,
  0xEE, 0x42, 0x93, 0x02, 0x93, 0x02, 0x93, 0x83, 0x2F, 0xEE, 0x60,
  // "ě" (U+011B)
  0x18, 0x23, 0x31, 0x42, 0x81, 0xBC, 0x16, 0x89, 0x68, 0xEC, 0x13, 0xB0, 0x78, 0x7F, 0xEE, 0xA7,
  0x93, 0x89, 0x03, 0xE1, 0x01, 0x08, 0xED, 0x50,
  // "Ĝ" (U+011C)
  0x30, 0x40, 0x63, 0x82, 0x39, 0x86, 0x78, 0x61, 0xAE, 0xE9, 0x0C, 0x92, 0x81, 0x33, 0xE4, 0x05,
  0x0C, 0x48, 0x66, 0xC0, 0x4E, 0xF3, 0xE2, 0x89, 0x41, 0xF0, 0xD7, 0x01, 0xF0, 0x2B, 0xEE, 0xB0,
  // "ĝ" (U+011D)
  0x20, 0x40, 0x62, 0x82, 0x39, 0x86, 0x68, 0xB3, 0x9E, 0x8E, 0x4D, 0x06, 0xE7, 0x90, 0x2E, 0x79,
  0x02, 0xE4, 0xD0, 0x6E, 0x0A, 0xE9, 0xE3, 0x89, 0x22, 0xD1, 0x20, 0x7B, 0x2D, 0xEC, 0x20,
  // "Ğ" (U+011E)
  0x28, 0x24, 0x23, 0x32, 0x82, 0x2D, 0xC2, 0x78, 0x61, 0xAE, 0xE9, 0x0C, 0x92, 0x81, 0x33, 0xE4,
  0x05, 0x0C, 0x48, 0x66, 0xC0, 0x4E, 0xF3, 0xE2, 0x89, 0x41, 0xF0, 0xD7, 0x01, 0xF0, 0x2B, 0xEE,
  0xB0,
  // "ğ" (U+011F)
  0x18, 0x74, 0x23, 0x30, 0x2D, 0xC2, 0x68, 0xB3, 0x9E, 0x8E, 0x4D, 0x06, 0xE7, 0x90, 0x2E, 0x79,
  0x02, 0xE4, 0xD0, 0x6E, 0x0A, 0xE9, 0xE3, 0x89, 0x22, 0xD1, 0x20, 0x7B, 0x2D, 0xEC, 0x20,
  // "Ġ" (U+0120)
  0x30, 0x50, 0x77, 0x18, 0x61, 0xAE, 0xE9, 0x0C, 0x92, 0x81, 0x33, 0xE4, 0x05, 0x0C, 0x48, 0x66,
  0xC0, 0x4E, 0xF3, 0xE2, 0x89, 0x41, 0xF0, 0xD7, 0x01, 0xF0, 0x2B, 0xEE, 0xB0,
  // "ġ" (U+0121)
  0x20, 0x50, 0x77, 0x8B, 0x39, 0xE8, 0xE4, 0xD0, 0x6E, 0x79, 0x02, 0xE7, 0x90, 0x2E, 0x4D, 0x06,
  0xE0, 0xAE, 0x9E, 0x38, 0x92, 0x2D, 0x12, 0x07, 0xB2, 0xDE, 0xC2,
  // "Ģ" (U+0122)
  0x18, 0x61, 0xAE, 0xE9, 0x0C, 0x92, 0x81, 0x33, 0xE4, 0x05, 0x0C, 0x48, 0x66, 0xC0, 0x4E, 0xF3,
  0xE2, 0x89, 0x41, 0xF0, 0xD7, 0x01, 0xF0, 0x2B, 0xEE, 0xB7, 0x20, 0xC0, 0x13, 0x01, 0x0A, 0x20,
  // "ģ" (U+0123)
  0x20, 0xA0, 0x22, 0x01, 0x0C, 0x38, 0xB3, 0x9E, 0x8E, 0x4D, 0x06, 0xE7, 0x90, 0x2E, 0x79, 0x02,
  0xE4, 0xD0, 0x6E, 0x0A, 0xE9, 0xE3, 0x89, 0x22, 0xD1, 0x20, 0x7B, 0x2D, 0xEC, 0x20,
  // "Ĥ" (U+0124)
  0x20, 0x40, 0x63, 0x82, 0x39, 0x86, 0x70, 0x29, 0x28, 0x14, 0xC2, 0x92, 0x81, 0x4C, 0x29, 0x28,
  0x74, 0xC2, 0xFE, 0xEE, 0xC2, 0x92, 0x81, 0x4C, 0x29, 0x28, 0x14, 0xC2, 0x92, 0x81, 0x4C, 0x29,
  0x20, 0x40, 0xC0,
  // "ĥ" (U+0125)
  0x10, 0x40, 0x63, 0x82, 0x39, 0x86, 0x72, 0x03, 0x0D, 0x40, 0x30, 0xD4, 0x8C, 0x03, 0xDB, 0xE6,
  0x03, 0xF2, 0x4D, 0x03, 0xD0, 0x1F, 0x03, 0xD0, 0x1F, 0x03, 0xD0, 0x1F, 0x03, 0xD0, 0x19,
  // "Ħ" (U+0126)
  0x02, 0x92, 0x89, 0x14, 0xC0, 0xEF, 0xEE, 0xEF, 0x92, 0x92, 0x89, 0x14, 0xC0, 0x2F, 0xEE, 0xEC,
  0x02, 0x92, 0x82, 0x4C, 0x02, 0x92, 0x82, 0x4C, 0x02, 0x92, 0x82, 0x4C, 0x02, 0x92, 0x04, 0x0C,
  0x10,
  // "ħ" (U+0127)
  0x03, 0x0D, 0x38, 0xC0, 0xDF, 0xE4, 0x03, 0xDA, 0xE6, 0x3F, 0x24, 0xD3, 0xD0, 0x1F, 0x3D, 0x01,
  0xF3, 0xD0, 0x1F, 0x3D, 0x01, 0x90,
  // "Ĩ" (U+0128)
  0x86, 0x2D, 0x5A, 0x73, 0xA9, 0x58, 0x17, 0xFD, 0x20, 0xD0, 0x42, 0x0D, 0x04, 0x20, 0xD0, 0x42,
  0x0D, 0x04, 0x20, 0xD0, 0x42, 0x84, 0xD4, 0x07, 0xFD,
  // "ĩ" (U+0129)
  0x86, 0x2D, 0x5A, 0x73, 0xA9, 0x50, 0x30, 0xD2, 0x03, 0x0D, 0x20, 0x30, 0xD2, 0x03, 0x0D, 0x20,
  0x30, 0xD2, 0x03, 0x0D, 0x10,
  // "Ī" (U+012A)
  0x82, 0x8E, 0xE5, 0x48, 0x17, 0xFD, 0x20, 0xD0, 0x42, 0x0D, 0x04, 0x20, 0xD0, 0x42, 0x0D, 0x04,
  0x20, 0xD0, 0x42, 0x84, 0xD4, 0x07, 0xFD, 0x10,
  // "ī" (U+012B)
  0x82, 0x8E, 0xE5, 0x50, 0x30, 0xD2, 0x03, 0x0D, 0x20, 0x30, 0xD2, 0x03, 0x0D, 0x20, 0x30, 0xD2,
  0x03, 0x0D, 0x10,
  // "Ĭ" (U+012C)
  0x86, 0x42, 0x33, 0x2D, 0xC2, 0x48, 0x17, 0xFD, 0x20, 0xD0, 0x42, 0x0D, 0x04, 0x20, 0xD0, 0x42,
  0x0D, 0x04, 0x20, 0xD0, 0x42, 0x84, 0xD4, 0x07, 0xFD, 0x10,
  // "ĭ" (U+012D)
  0x86, 0x42, 0x33, 0x2D, 0xC2, 0x50, 0x30, 0xD2, 0x03, 0x0D, 0x20, 0x30, 0xD2, 0x03, 0x0D, 0x20,
  0x30, 0xD2, 0x03, 0x0D, 0x10,
  // "Į" (U+012E)
  0x81, 0x7F, 0xD2, 0x0D, 0x04, 0x20, 0xD0, 0x42, 0x0D, 0x04, 0x20, 0xD0, 0x42, 0x0D, 0x04, 0x28,
  0x4D, 0x40, 0x7F, 0xD2, 0x01, 0x07, 0x20, 0x70, 0x52, 0x81, 0x4E, 0x20,
  // "į" (U+012F)
  0x02, 0x0A, 0x48, 0xB1, 0x3D, 0x03, 0xD0, 0x3D, 0x03, 0xD0, 0x3D, 0x03, 0xD0, 0x17, 0x07, 0x50,
  0x4E, 0x20,
  // "İ" (U+0130)
  0x10, 0x50, 0x73, 0x8A, 0x67, 0xFD, 0x0D, 0x40, 0xD4, 0x0D, 0x40, 0xD4, 0x0D, 0x40, 0xD4, 0x7F,
  0xD0,
  // "ı" (U+0131)
  0x89, 0x23, 0xD3, 0xD3, 0xD3, 0xD3, 0xD3, 0xD0,
  // "Ĳ" (U+0132)
  0x8C, 0x67, 0xFD, 0x3E, 0x0D, 0x42, 0xE0, 0xD4, 0x2E, 0x0D, 0x42, 0xE0, 0xD4, 0x2E, 0x0D, 0x42,
  0xE0, 0xD4, 0x2E, 0x7F, 0xD3, 0xE3, 0x05, 0x0D, 0x28, 0x19, 0xD5,
  // "ĳ" (U+0133)
  0x83, 0x2A, 0x02, 0xA5, 0x8B, 0x43, 0xD0, 0x3D, 0x3D, 0x03, 0xD3, 0xD0, 0x3D, 0x3D, 0x03, 0xD3,
  0xD0, 0x3D, 0x3D, 0x03, 0xD3, 0x03, 0x0D, 0x30, 0x40, 0xC2, 0x81, 0x4E, 0x60,
  // "Ĵ" (U+0134)
  0x18, 0x54, 0x60, 0x39, 0x86, 0x50, 0x20, 0xE2, 0x02, 0x0E, 0x20, 0x20, 0xE2, 0x02, 0x0E, 0x20,
  0x20, 0xE2, 0x02, 0x0E, 0x20, 0x20, 0xE2, 0x02, 0x0E, 0x28, 0x45, 0xD0, 0x9D, 0x51,
  // "ĵ" (U+0135)
  0x18, 0x54, 0x60, 0x39, 0x86, 0x50, 0x30, 0xD2, 0x03, 0x0D, 0x20, 0x30, 0xD2, 0x03, 0x0D, 0x20,
  0x30, 0xD2, 0x03, 0x0D, 0x20, 0x30, 0xD2, 0x84, 0x4C, 0x04, 0xE6, 0x10,
  // "Ķ" (U+0136)
  0x02, 0x92, 0x8A, 0x0D, 0x42, 0xF0, 0x8A, 0x02, 0xF2, 0xE1, 0x02, 0xFB, 0x82, 0x82, 0x2F, 0xBD,
  0x28, 0x93, 0x2F, 0x0D, 0x50, 0x2F, 0x05, 0xD0, 0x29, 0x20, 0xC0, 0x67, 0x20, 0xC0, 0x13, 0x01,
  0x0A, 0x20,
  // "ķ" (U+0137)
  0x03, 0x0D, 0x30, 0x30, 0xD3, 0x8B, 0x43, 0xD0, 0x98, 0x3D, 0x4C, 0x03, 0xDE, 0x50, 0x3F, 0x9B,
  0x03, 0xD0, 0xD4, 0x3D, 0x06, 0xC7, 0x0C, 0x01, 0x20, 0x10, 0xA2,
  // "ĸ" (U+0138)
  0x8B, 0x43, 0xD0, 0x99, 0x3D, 0x4D, 0x03, 0xDD, 0x50, 0x3F, 0x9B, 0x03, 0xD0, 0xD4, 0x3D, 0x06,
  0xC0,
  // "Ĺ" (U+0139)
  0x10, 0x50, 0x42, 0x04, 0x0B, 0x71, 0x02, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02, 0x93,
  0x02, 0x93, 0x02, 0x93, 0x02, 0xB0, 0x70,
  // "ĺ" (U+013A)
  0x18, 0x25, 0x44, 0xB4, 0x8A, 0x53, 0xD0, 0x3D, 0x03, 0xD0, 0x3D, 0x03, 0xD0, 0x3D, 0x03, 0xD0,
  0x3D, 0x10,
  // "Ļ" (U+013B)
  0x02, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02, 0xB0,
  0x77, 0x0C, 0x01, 0x20, 0x10, 0xA2,
  // "ļ" (U+013C)
  0x8A, 0x53, 0xD0, 0x3D, 0x03, 0xD0, 0x3D, 0x03, 0xD0, 0x3D, 0x03, 0xD0, 0x3D, 0x58, 0x2C, 0x11,
  0xA1,
  // "Ľ" (U+013D)
  0x02, 0x92, 0x87, 0xE1, 0x2F, 0x01, 0x90, 0x29, 0x40, 0x29, 0x40, 0x29, 0x40, 0x29, 0x40, 0x29,
  0x40, 0x2B, 0x07, 0x10,
  // "ľ" (U+013E)
  0x89, 0x03, 0xDE, 0x13, 0xE9, 0x03, 0xD2, 0x03, 0x0D, 0x20, 0x30, 0xD2, 0x03, 0x0D, 0x20, 0x30,
  0xD2, 0x03, 0x0D, 0x20,
  // "Ŀ" (U+013F)
  0x02, 0x93, 0x02, 0x93, 0x02, 0x93, 0x84, 0x2F, 0x05, 0x72, 0x93, 0x02, 0x93, 0x02, 0x93, 0x02,
  0xB0, 0x70,
  // "ŀ" (U+0140)
  0x03, 0x0D, 0x20, 0x30, 0xD2, 0x03, 0x0D, 0x28, 0x43, 0xD5, 0x73, 0xD2, 0x03, 0x0D, 0x20, 0x30,
  0xD2, 0x03, 0x0D, 0x20,
  // "Ł" (U+0141)
  0x01, 0x93, 0x01, 0x93, 0x01, 0x93, 0x86, 0x1F, 0xC6, 0x07, 0xF4, 0x20, 0x69, 0x30, 0x19, 0x30,
  0x1B, 0x08,
  // "ł" (U+0142)
  0x8A, 0x52, 0xE0, 0x2E, 0x02, 0xE0, 0x2F, 0xAB, 0xE0, 0x5E, 0x02, 0xE0, 0x2E, 0x10,
  // "Ń" (U+0143)
  0x30, 0x50, 0x44, 0x04, 0x0B, 0x73, 0x81, 0x2F, 0x62, 0x83, 0xD3, 0x2F, 0xD2, 0x8B, 0x6D, 0x32,
  0xDC, 0x60, 0xD3, 0x2D, 0x4D, 0x0D, 0x32, 0xE0, 0xC5, 0xD3, 0x2E, 0x05, 0xCC, 0x32, 0xE2, 0x83,
  0xDF, 0x32, 0xE2, 0x81, 0x5F, 0x30,
  // "ń" (U+0144)
  0x30, 0x50, 0x42, 0x04, 0x0B, 0x68, 0xB3, 0x3B, 0xAE, 0x63, 0xF2, 0x4D, 0x3D, 0x01, 0xF3, 0xD0,
  0x1F, 0x3D, 0x01, 0xF3, 0xD0, 0x19,
  // "Ņ" (U+0145)
  0x81, 0x2F, 0x62, 0x83, 0xD3, 0x2F, 0xD2, 0x8B, 0x6D, 0x32, 0xDC, 0x60, 0xD3, 0x2D, 0x4D, 0x0D,
  0x32, 0xE0, 0xC5, 0xD3, 0x2E, 0x05, 0xCC, 0x32, 0xE2, 0x83, 0xDF, 0x32, 0xE2, 0x81, 0x5F, 0x37,
  0x30, 0xC0, 0x14, 0x01, 0x0A, 0x30,
  // "ņ" (U+0146)
  0x8B, 0x33, 0xBA, 0xE6, 0x3F, 0x24, 0xD3, 0xD0, 0x1F, 0x3D, 0x01, 0xF3, 0xD0, 0x1F, 0x3D, 0x01,
  0x97, 0x0C, 0x01, 0x20, 0x10, 0xA2,
  // "Ň" (U+0147)
  0x18, 0x23, 0x31, 0x44, 0x81, 0xBC, 0x17, 0x28, 0x12, 0xF6, 0x28, 0x3D, 0x32, 0xFD, 0x28, 0xB6,
  0xD3, 0x2D, 0xC6, 0x0D, 0x32, 0xD4, 0xD0, 0xD3, 0x2E, 0x0C, 0x5D, 0x32, 0xE0, 0x5C, 0xC3, 0x2E,
  0x28, 0x3D, 0xF3, 0x2E, 0x28, 0x15, 0xF3,
  // "ň" (U+0148)
  0x18, 0x23, 0x31, 0x42, 0x81, 0xBC, 0x15, 0x8B, 0x33, 0xBA, 0xE6, 0x3F, 0x24, 0xD3, 0xD0, 0x1F,
  0x3D, 0x01, 0xF3, 0xD0, 0x1F, 0x3D, 0x01, 0x90,
  // "ŉ" (U+0149)
  0x05, 0x0C, 0x40, 0x70, 0x84, 0x8C, 0x18, 0x6B, 0xAE, 0x60, 0x3F, 0x24, 0xD0, 0x3D, 0x01, 0xF0,
  0x3D, 0x01, 0xF0, 0x3D, 0x01, 0xF0, 0x3D, 0x01, 0x90,
  // "Ŋ" (U+014A)
  0x81, 0x2F, 0x72, 0x83, 0xD3, 0x2F, 0xE2, 0x8B, 0x6D, 0x32, 0xDB, 0x70, 0xD3, 0x2D, 0x3E, 0x1D,
  0x32, 0xE0, 0xA7, 0xC3, 0x2E, 0x02, 0xED, 0x32, 0xE2, 0x83, 0x9F, 0x32, 0xE2, 0x81, 0x1F, 0x34,
  0x81, 0x1E, 0x13, 0x81, 0x5E, 0x81,
  // "ŋ" (U+014B)
  0x8B, 0x33, 0xBB, 0xE6, 0x3F, 0x24, 0xD3, 0xD0, 0x1F, 0x3D, 0x01, 0xF3, 0xD0, 0x1F, 0x3D, 0x01,
  0x93, 0x01, 0x93, 0x02, 0x0E, 0x28, 0x11, 0xE7,
  // "Ō" (U+014C)
  0x28, 0x28, 0xEE, 0x57, 0x28, 0x33, 0xCE, 0xC2, 0x28, 0x6D, 0x60, 0x7C, 0x03, 0xE3, 0x82, 0xE2,
  0x5C, 0x38, 0x2D, 0x56, 0xB3, 0x82, 0xD5, 0x3E, 0x38, 0x6E, 0x20, 0xD6, 0x07, 0xC2, 0x83, 0x3C,
  0xEC, 0x21,
  // "ō" (U+014D)
  0x18, 0x28, 0xEE, 0x56, 0x8B, 0x38, 0xEC, 0x24, 0xD0, 0x5C, 0x79, 0x01, 0xF7, 0x90, 0x1F, 0x3D,
  0x05, 0xC0, 0x8E, 0xD3,
  // "Ŏ" (U+014E)
  0x28, 0x24, 0x23, 0x33, 0x82, 0x2D, 0xC2, 0x72, 0x83, 0x3C, 0xEC, 0x22, 0x86, 0xD6, 0x07, 0xC0,
  0x3E, 0x38, 0x2E, 0x25, 0xC3, 0x82, 0xD5, 0x6B, 0x38, 0x2D, 0x53, 0xE3, 0x86, 0xE2, 0x0D, 0x60,
  0x7C, 0x28, 0x33, 0xCE, 0xC2, 0x10,
  // "ŏ" (U+014F)
  0x18, 0x74, 0x23, 0x30, 0x2D, 0xC2, 0x68, 0xB3, 0x8E, 0xC2, 0x4D, 0x05, 0xC7, 0x90, 0x1F, 0x79,
  0x01, 0xF3, 0xD0, 0x5C, 0x08, 0xED, 0x30,
  // "Ő" (U+0150)
  0x38, 0x1B, 0x4B, 0x38, 0x25, 0x78, 0x47, 0x28, 0x33, 0xCE, 0xC2, 0x28, 0x6D, 0x60, 0x7C, 0x03,
  0xE3, 0x82, 0xE2, 0x5C, 0x38, 0x2D, 0x56, 0xB3, 0x82, 0xD5, 0x3E, 0x38, 0x6E, 0x20, 0xD6, 0x07,
  0xC2, 0x83, 0x3C, 0xEC, 0x21,
  // "ő" (U+0151)
  0x28, 0x6B, 0x4B, 0x05, 0x78, 0x46, 0x8B, 0x38, 0xEC, 0x24, 0xD0, 0x5C, 0x79, 0x01, 0xF7, 0x90,
  0x1F, 0x3D, 0x05, 0xC0, 0x8E, 0xD3,
  // "Œ" (U+0152)
  0x18, 0x93, 0x3C, 0xEF, 0xEE, 0x90, 0xD6, 0x0D, 0x32, 0x03, 0x0E, 0x20, 0xD0, 0x32, 0x05, 0x0C,
  0x28, 0x4D, 0xEE, 0x76, 0xC2, 0x0D, 0x03, 0x20, 0x30, 0xE2, 0x0D, 0x03, 0x38, 0x3D, 0x60, 0xD3,
  0x38, 0x53, 0xCE, 0xFE, 0xE9,
  // "œ" (U+0153)
  0x18, 0xB4, 0x8E, 0xC5, 0xDE, 0x50, 0x3D, 0x06, 0xF2, 0x1E, 0x07, 0x90, 0x1F, 0xEE, 0xE1, 0x79,
  0x01, 0x94, 0x86, 0x3D, 0x06, 0xF6, 0x02, 0x28, 0x58, 0xEC, 0x4C, 0xEA, 0x10,
  // "Ŕ" (U+0154)
  0x30, 0x50, 0x43, 0x04, 0x0B, 0x71, 0x89, 0x32, 0xFE, 0xD5, 0x02, 0xF0, 0x4E, 0x02, 0x92, 0x98,
  0xB0, 0x12, 0xF0, 0x5E, 0x02, 0xFE, 0xF3, 0x02, 0xF0, 0xD4, 0x02, 0xF0, 0x5C, 0x02, 0x92, 0x0D,
  0x05,
  // "ŕ" (U+0155)
  0x28, 0x35, 0x40, 0x4B, 0x58, 0x90, 0x3B, 0xB9, 0x3F, 0x30, 0x3D, 0x20, 0x30, 0xD2, 0x03, 0x0D,
  0x20, 0x30, 0xD2,
  // "Ŗ" (U+0156)
  0x89, 0x32, 0xFE, 0xD5, 0x02, 0xF0, 0x4E, 0x02, 0x92, 0x98, 0xB0, 0x12, 0xF0, 0x5E, 0x02, 0xFE,
  0xF3, 0x02, 0xF0, 0xD4, 0x02, 0xF0, 0x5C, 0x02, 0x92, 0x0D, 0x05, 0x71, 0x0C, 0x01, 0x30, 0x10,
  0xA3,
  // "ŗ" (U+0157)
  0x89, 0x03, 0xBB, 0x93, 0xF3, 0x03, 0xD2, 0x03, 0x0D, 0x20, 0x30, 0xD2, 0x03, 0x0D, 0x78, 0x3C,
  0x10, 0x1A, 0x20,
  // "Ř" (U+0158)
  0x18, 0x23, 0x31, 0x43, 0x81, 0xBC, 0x17, 0x89, 0x32, 0xFE, 0xD5, 0x02, 0xF0, 0x4E, 0x02, 0x92,
  0x98, 0xB0, 0x12, 0xF0, 0x5E, 0x02, 0xFE, 0xF3, 0x02, 0xF0, 0xD4, 0x02, 0xF0, 0x5C, 0x02, 0x92,
  0x0D, 0x05,
  // "ř" (U+0159)
  0x86, 0x33, 0x14, 0x0B, 0xC1, 0x48, 0x90, 0x3B, 0xB9, 0x3F, 0x30, 0x3D, 0x20, 0x30, 0xD2, 0x03,
  0x0D, 0x20, 0x30, 0xD2,
  // "Ś" (U+015A)
  0x30, 0x50, 0x42, 0x04, 0x0B, 0x78, 0x91, 0x9E, 0xD4, 0x6C, 0x01, 0x16, 0xC3, 0x82, 0x1D, 0xC3,
  0x28, 0x21, 0x9F, 0x33, 0x81, 0x99, 0x22, 0x84, 0xA7, 0x6E, 0xEA, 0x10,
  // "ś" (U+015B)
  0x28, 0x35, 0x40, 0x4B, 0x58, 0x91, 0x2D, 0xE9, 0x89, 0x01, 0x4E, 0x62, 0x89, 0x12, 0xB9, 0x20,
  0x4D, 0x7E, 0xE5,
  // "Ŝ" (U+015C)
  0x20, 0x40, 0x62, 0x82, 0x39, 0x86, 0x68, 0x91, 0x9E, 0xD4, 0x6C, 0x01, 0x16, 0xC3, 0x82, 0x1D,
  0xC3, 0x28, 0x21, 0x9F, 0x33, 0x81, 0x99, 0x22, 0x84, 0xA7, 0x6E, 0xEA, 0x10,
  // "ŝ" (U+015D)
  0x18, 0x54, 0x60, 0x39, 0x86, 0x48, 0x91, 0x2D, 0xE9, 0x89, 0x01, 0x4E, 0x62, 0x89, 0x12, 0xB9,
  0x20, 0x4D, 0x7E, 0xE5,
  // "Ş" (U+015E)
  0x18, 0x91, 0x9E, 0xD4, 0x6C, 0x01, 0x16, 0xC3, 0x82, 0x1D, 0xC3, 0x28, 0x21, 0x9F, 0x33, 0x81,
  0x99, 0x22, 0x84, 0xA7, 0x6E, 0xEA, 0x20, 0x40, 0x33, 0x03, 0x0D, 0x30, 0xC0, 0x92,
  // "ş" (U+015F)
  0x89, 0x12, 0xDE, 0x98, 0x90, 0x14, 0xE6, 0x28, 0x94, 0x2B, 0x92, 0x04, 0xD7, 0xEE, 0x50, 0x43,
  0x20, 0x30, 0xD2, 0x0C, 0x09, 0x10,
  // "Š" (U+0160)
  0x18, 0x23, 0x31, 0x42, 0x81, 0xBC, 0x16, 0x89, 0x19, 0xED, 0x46, 0xC0, 0x11, 0x6C, 0x38, 0x21,
  0xDC, 0x32, 0x82, 0x19, 0xF3, 0x38, 0x19, 0x92, 0x28, 0x4A, 0x76, 0xEE, 0xA1,
  // "š" (U+0161)
  0x86, 0x33, 0x14, 0x0B, 0xC1, 0x48, 0x91, 0x2D, 0xE9, 0x89, 0x01, 0x4E, 0x62, 0x89, 0x12, 0xB9,
  0x20, 0x4D, 0x7E, 0xE5,
  // "Ţ" (U+0162)
  0x85, 0xCE, 0xFE, 0xA0, 0x19, 0x30, 0x19, 0x30, 0x19, 0x30, 0x19, 0x30, 0x19, 0x30, 0x19, 0x30,
  0x19, 0x30, 0x40, 0x33, 0x03, 0x0D, 0x30, 0xC0, 0x92,
  // "ţ" (U+0163)
  0x10, 0x63, 0x0D, 0x28, 0x4A, 0xFE, 0x12, 0xE2, 0x02, 0x0E, 0x20, 0x20, 0xE2, 0x02, 0x0E, 0x38,
  0x4B, 0xE2, 0x04, 0x32, 0x03, 0x0D, 0x20, 0xC0, 0x91,
  // "Ť" (U+0164)
  0x82, 0x33, 0x14, 0x28, 0x1B, 0xC1, 0x68, 0x5C, 0xEF, 0xEA, 0x01, 0x93, 0x01, 0x93, 0x01, 0x93,
  0x01, 0x93, 0x01, 0x93, 0x01, 0x93, 0x01, 0x92,
  // "ť" (U+0165)
  0x18, 0x96, 0x60, 0xE1, 0x0D, 0x19, 0x0A, 0xFE, 0x10, 0x2E, 0x30, 0x20, 0xE3, 0x02, 0x0E, 0x30,
  0x20, 0xE4, 0x81, 0xBE, 0x21,
  // "Ŧ" (U+0166)
  0x85, 0xCE, 0xFE, 0xA0, 0x19, 0x30, 0x19, 0x30, 0x19, 0x28, 0x54, 0xEF, 0xE3, 0x01, 0x93, 0x01,
  0x93, 0x01, 0x92,
  // "ŧ" (U+0167)
  0x10, 0x63, 0x0D, 0x28, 0x4A, 0xFE, 0x12, 0xE2, 0x84, 0xBF, 0xE0, 0x2E, 0x20, 0x20, 0xE3, 0x81,
  0xBE, 0x20,
  // "Ũ" (U+0168)
  0x18, 0x22, 0xD5, 0xA2, 0x82, 0x73, 0xA9, 0x70, 0x30, 0xE2, 0x82, 0x5B, 0x3E, 0x28, 0x25, 0xB3,
  0xE2, 0x82, 0x5B, 0x3E, 0x28, 0x25, 0xB3, 0xE2, 0x82, 0x5B, 0x2E, 0x28, 0x94, 0x6B, 0x0E, 0x30,
  0xA8, 0x04, 0xDE, 0xA1,
  // "ũ" (U+0169)
  0x18, 0x72, 0xD5, 0xA0, 0x73, 0xA9, 0x58, 0xB4, 0x4C, 0x02, 0xE4, 0xC0, 0x2E, 0x4C, 0x02, 0xE4,
  0xC0, 0x2E, 0x3E, 0x06, 0xE0, 0xAD, 0x8E,
  // "Ū" (U+016A)
  0x18, 0x28, 0xEE, 0x57, 0x03, 0x0E, 0x28, 0x25, 0xB3, 0xE2, 0x82, 0x5B, 0x3E, 0x28, 0x25, 0xB3,
  0xE2, 0x82, 0x5B, 0x3E, 0x28, 0x25, 0xB2, 0xE2, 0x89, 0x46, 0xB0, 0xE3, 0x0A, 0x80, 0x4D, 0xEA,
  0x10,
  // "ū" (U+016B)
  0x18, 0x28, 0xEE, 0x55, 0x8B, 0x44, 0xC0, 0x2E, 0x4C, 0x02, 0xE4, 0xC0, 0x2E, 0x4C, 0x02, 0xE3,
  0xE0, 0x6E, 0x0A, 0xD8, 0xE0,
  // "Ŭ" (U+016C)
  0x18, 0x24, 0x23, 0x32, 0x82, 0x2D, 0xC2, 0x70, 0x30, 0xE2, 0x82, 0x5B, 0x3E, 0x28, 0x25, 0xB3,
  0xE2, 0x82, 0x5B, 0x3E, 0x28, 0x25, 0xB3, 0xE2, 0x82, 0x5B, 0x2E, 0x28, 0x94, 0x6B, 0x0E, 0x30,
  0xA8, 0x04, 0xDE, 0xA1,
  // "ŭ" (U+016D)
  0x18, 0x74, 0x23, 0x30, 0x2D, 0xC2, 0x58, 0xB4, 0x4C, 0x02, 0xE4, 0xC0, 0x2E, 0x4C, 0x02, 0xE4,
  0xC0, 0x2E, 0x3E, 0x06, 0xE0, 0xAD, 0x8E,
  // "Ů" (U+016E)
  0x28, 0x12, 0x95, 0x38, 0x18, 0x3A, 0x38, 0x43, 0xD7, 0x03, 0xE2, 0x82, 0x5B, 0x3E, 0x28, 0x25,
  0xB3, 0xE2, 0x82, 0x5B, 0x3E, 0x28, 0x25, 0xB3, 0xE2, 0x82, 0x5B, 0x2E, 0x28, 0x94, 0x6B, 0x0E,
  0x30, 0xA8, 0x04, 0xDE, 0xA1,
  // "ů" (U+016F)
  0x18, 0x12, 0x95, 0x28, 0x18, 0x3A, 0x28, 0xC0, 0x3D, 0x70, 0x4C, 0x02, 0xE4, 0xC0, 0x2E, 0x4C,
  0x02, 0xE4, 0xC0, 0x2E, 0x3E, 0x06, 0xE0, 0xAD, 0x8E,
  // "Ű" (U+0170)
  0x38, 0x1B, 0x4B, 0x28, 0x25, 0x78, 0x46, 0x03, 0x0E, 0x28, 0x25, 0xB3, 0xE2, 0x82, 0x5B, 0x3E,
  0x28, 0x25, 0xB3, 0xE2, 0x82, 0x5B, 0x3E, 0x28, 0x25, 0xB2, 0xE2, 0x89, 0x46, 0xB0, 0xE3, 0x0A,
  0x80, 0x4D, 0xEA, 0x10,
  // "ű" (U+0171)
  0x28, 0x6B, 0x4B, 0x05, 0x78, 0x45, 0x8B, 0x44, 0xC0, 0x2E, 0x4C, 0x02, 0xE4, 0xC0, 0x2E, 0x4C,
  0x02, 0xE3, 0xE0, 0x6E, 0x0A, 0xD8, 0xE0,
  // "Ų" (U+0172)
  0x03, 0x0E, 0x28, 0x25, 0xB3, 0xE2, 0x82, 0x5B, 0x3E, 0x28, 0x25, 0xB3, 0xE2, 0x82, 0x5B, 0x3E,
  0x28, 0x25, 0xB2, 0xE2, 0x89, 0x46, 0xB0, 0xE3, 0x0A, 0x90, 0x4D, 0xEE, 0x23, 0x08, 0x05, 0x40,
  0xD5, 0x09, 0x0C, 0x10,
  // "ų" (U+0173)
  0x8B, 0x34, 0xC0, 0x2E, 0x04, 0xC0, 0x2E, 0x04, 0xC0, 0x2E, 0x04, 0xC0, 0x2E, 0x03, 0xE0, 0x6E,
  0x28, 0x2A, 0xD8, 0xE4, 0x01, 0x07, 0x40, 0x70, 0x54, 0x81, 0x4E, 0x20,
  // "Ŵ" (U+0174)
  0x30, 0x40, 0x66, 0x82, 0x39, 0x86, 0x75, 0x82, 0xC4, 0x03, 0x92, 0x8B, 0x28, 0x99, 0x70, 0x7F,
  0x30, 0xB6, 0x6A, 0x0A, 0xB7, 0x0E, 0x22, 0xD0, 0xE5, 0xA2, 0xE2, 0x85, 0xE3, 0xC1, 0xD5, 0xB2,
  0x85, 0xB9, 0x90, 0xD9, 0x82, 0x85, 0x8E, 0x60, 0x9E, 0x42, 0x85, 0x4F, 0x20, 0x6F, 0x11,
  // "ŵ" (U+0175)
  0x30, 0x40, 0x65, 0x82, 0x39, 0x86, 0x73, 0x8B, 0x5C, 0x40, 0xE7, 0x0B, 0x48, 0x73, 0xDA, 0x0E,
  0x05, 0xB6, 0x7D, 0x3C, 0x01, 0xE9, 0x3C, 0x89, 0x28, 0x4D, 0xD0, 0x8D, 0x52, 0x84, 0xAC, 0x05,
  0xF1, 0x10,
  // "Ŷ" (U+0176)
  0x10, 0x40, 0x62, 0x82, 0x39, 0x86, 0x68, 0xA1, 0xC5, 0x03, 0xD6, 0xB0, 0x97, 0x0E, 0x3E, 0x10,
  0x9D, 0xA2, 0x81, 0x2F, 0x43, 0x90, 0x13, 0x90, 0x13, 0x90, 0x11,
  // "ŷ" (U+0177)
  0x10, 0x40, 0x62, 0x82, 0x39, 0x86, 0x68, 0x94, 0xC4, 0x08, 0x98, 0x80, 0xC4, 0x3D, 0x0E, 0x28,
  0x1E, 0x6B, 0x28, 0x19, 0xC7, 0x28, 0x15, 0xF2, 0x20, 0x30, 0xD3, 0x00, 0x82, 0x81, 0xBC, 0x12,
  // "Ÿ" (U+0178)
  0x18, 0x26, 0x57, 0x45, 0x8A, 0x1C, 0x50, 0x3D, 0x6B, 0x09, 0x70, 0xE3, 0xE1, 0x09, 0xDA, 0x28,
  0x12, 0xF4, 0x39, 0x01, 0x39, 0x01, 0x39, 0x01, 0x10,
  // "Ź" (U+0179)
  0x20, 0x50, 0x42, 0x04, 0x0B, 0x78, 0x38, 0xEE, 0xF7, 0x28, 0x11, 0xE2, 0x20, 0x70, 0xA3, 0x0E,
  0x03, 0x20, 0x60, 0xB3, 0x0D, 0x04, 0x20, 0x50, 0xC3, 0x83, 0xAF, 0xEE, 0x70,
  // "ź" (U+017A)
  0x28, 0x35, 0x40, 0x4B, 0x58, 0x28, 0xEF, 0xA2, 0x83, 0xC4, 0x05, 0xC2, 0x83, 0xC5, 0x04, 0xC2,
  0x82, 0xAF, 0xEA,
  // "Ż" (U+017B)
  0x10, 0x50, 0x77, 0x83, 0x8E, 0xEF, 0x72, 0x81, 0x1E, 0x22, 0x07, 0x0A, 0x30, 0xE0, 0x32, 0x06,
  0x0B, 0x30, 0xD0, 0x42, 0x05, 0x0C, 0x38, 0x3A, 0xFE, 0xE7,
  // "ż" (U+017C)
  0x10, 0x50, 0x75, 0x82, 0x8E, 0xFA, 0x28, 0x3C, 0x40, 0x5C, 0x28, 0x3C, 0x50, 0x4C, 0x28, 0x2A,
  0xFE, 0xA0,
  // "Ž" (U+017D)
  0x82, 0x33, 0x14, 0x28, 0x1B, 0xC1, 0x68, 0x38, 0xEE, 0xF7, 0x28, 0x11, 0xE2, 0x20, 0x70, 0xA3,
  0x0E, 0x03, 0x20, 0x60, 0xB3, 0x0D, 0x04, 0x20, 0x50, 0xC3, 0x83, 0xAF, 0xEE, 0x70,
  // "ž" (U+017E)
  0x86, 0x33, 0x14, 0x0B, 0xC1, 0x48, 0x28, 0xEF, 0xA2, 0x83, 0xC4, 0x05, 0xC2, 0x83, 0xC5, 0x04,
  0xC2, 0x82, 0xAF, 0xEA,
  // "ſ" (U+017F)
  0x18, 0x3A, 0xE4, 0x2E, 0x20, 0x30, 0xD2, 0x03, 0x0D, 0x20, 0x30, 0xD2, 0x03, 0x0D, 0x20, 0x30,
  0xD2, 0x03, 0x0D, 0x20,
  // "Ω" (U+03A9)
  0x18, 0x33, 0xCE, 0xC2, 0x28, 0x6E, 0x50, 0x6D, 0x04, 0xD3, 0x82, 0xE3, 0x6B, 0x38, 0x2C, 0x55,
  0xC3, 0x82, 0xD4, 0x1E, 0x28, 0x97, 0x1E, 0x10, 0x87, 0x08, 0x70, 0x9E, 0xF0, 0xFE, 0x90,
  // "μ" (U+03BC)
  0x8B, 0x63, 0xD0, 0x1F, 0x3D, 0x01, 0xF3, 0xD0, 0x1F, 0x3D, 0x02, 0xF3, 0xE0, 0x6F, 0x3E, 0xD9,
  0xE3, 0xC3, 0x03, 0x0D, 0x30, 0x30, 0xD3,
  // "π" (U+03C0)
  0x89, 0x1A, 0xFE, 0xEF, 0xC0, 0xE2, 0x2E, 0x28, 0x2E, 0x22, 0xE2, 0x82, 0xE2, 0x2E, 0x28, 0x2E,
  0x22, 0xE2, 0x83, 0xE2, 0x0C, 0xB0,
  // "–" (U+2013)
  0x84, 0x8E, 0xEE, 0xE1,
  // "—" (U+2014)
  0x08, 0x80, 0x5E, 0x08,
  // "€" (U+20AC)
  0x18, 0x92, 0x1B, 0xEB, 0x09, 0x80, 0x20, 0xE2, 0x28, 0x7B, 0xFE, 0xD0, 0x9F, 0xB7, 0x20, 0xD0,
  0x23, 0x87, 0x89, 0x02, 0x01, 0xBE, 0xB0,
  // "₿" (U+20BF)
  0x18, 0xD6, 0x45, 0x90, 0x2F, 0xEE, 0x42, 0xE0, 0x7B, 0x2E, 0x08, 0x92, 0xFE, 0xE3, 0x2E, 0x07,
  0xC2, 0xE0, 0x3E, 0x2E, 0x06, 0xC2, 0xFE, 0xE3, 0x04, 0x59, 0x10,
  // "‘" (U+2018)
  0x84, 0x1C, 0x69, 0x86,
  // "’" (U+2019)
  0x84, 0x5C, 0x78, 0x83,
  // "‚" (U+201A)
  0x84, 0x5C, 0x78, 0x83,
  // "‛" (U+201B)
  0x84, 0x98, 0x5A, 0x0A,
  // "“" (U+201C)
  0x89, 0x21, 0xC1, 0xC6, 0x96, 0xA8, 0x68, 0x60,
  // "”" (U+201D)
  0x89, 0x25, 0xC4, 0xD7, 0x87, 0x88, 0x38, 0x30,
  // "„" (U+201E)
  0x89, 0x25, 0xC4, 0xD7, 0x87, 0x88, 0x38, 0x30,
  // "‟" (U+201F)
  0x89, 0x29, 0x79, 0x85, 0xA5, 0xA0, 0xA0, 0xB0,
  // "†" (U+2020)
  0x20, 0xE0, 0x13, 0x0C, 0x28, 0x35, 0xBD, 0xB8, 0x20, 0xB4, 0x0C, 0x40, 0xD4, 0x0E, 0x01, 0x30,
  0xE0, 0x21,
  // "‡" (U+2021)
  0x20, 0xE0, 0x13, 0x0C, 0x28, 0x34, 0xBE, 0xB7, 0x20, 0xD4, 0x89, 0x3D, 0x10, 0x4A, 0xD9, 0x61,
  0x1C, 0x11, 0x20, 0xD0, 0x11,
  // "•" (U+2022)
  0x83, 0x1D, 0xE2, 0x4A, 0x83, 0x61, 0xDE, 0x20,
  // "…" (U+2026)
  0x85, 0x2B, 0x02, 0xB2, 0xB0,
  // "‰" (U+2030)
  0x81, 0x1D, 0xB2, 0x0C, 0x68, 0x47, 0x6A, 0x35, 0x86, 0x84, 0x85, 0x85, 0xB2, 0x68, 0xA5, 0x76,
  0xA6, 0xB8, 0xB2, 0x3C, 0x70, 0x1C, 0xB9, 0x5C, 0x49, 0xA3, 0xC4, 0x87, 0xC2, 0xB2, 0xBB, 0x1B,
  0x12, 0x87, 0x67, 0x1C, 0x49, 0xA3, 0xD3, 0x87, 0xC1, 0x09, 0xE3, 0x3E, 0x81,
  // "‹" (U+2039)
  0x28, 0x71, 0x07, 0x93, 0xD1, 0x5D, 0x20, 0x90, 0x82, 0x02,
  // "›" (U+203A)
  0x05, 0x0B, 0x28, 0x90, 0xB7, 0x09, 0x84, 0xC0, 0x11, 0x10,
  // "⁄" (U+2044)
  0x40, 0xC3, 0x07, 0x06, 0x20, 0x10, 0xC3, 0x08, 0x05, 0x20, 0x10, 0xC3, 0x09, 0x04, 0x20, 0x20,
  0xB3, 0x0A, 0x04, 0x30,
  // "™" (U+2122)
  0x8B, 0x2D, 0xFC, 0xD3, 0x3D, 0x0A, 0x0B, 0x87, 0xC0, 0xA0, 0x9A, 0x9A, 0x0A, 0x09, 0x76, 0xA0,
  // "⅒" (U+2152)
  0x10, 0xA0, 0x97, 0x28, 0x14, 0x79, 0x30, 0xC6, 0x04, 0x09, 0x20, 0x70, 0x66, 0x83, 0x49, 0x01,
  0xC7, 0x84, 0x49, 0x09, 0xF9, 0x71, 0x86, 0x1F, 0x89, 0x02, 0xB9, 0x48, 0x79, 0x44, 0x90, 0x93,
  0x94, 0x28, 0x90, 0x2B, 0x04, 0x90, 0xB2, 0x75, 0x28, 0x90, 0xA4, 0x04, 0x90, 0x94, 0x94, 0x71,
  0x81, 0x2B, 0x91,
  // "ﬁ" (U+FB01)
  0x18, 0x5A, 0xE8, 0xA1, 0xF1, 0x28, 0xB4, 0xAF, 0xE5, 0xD1, 0xF0, 0x3D, 0x1F, 0x03, 0xD1, 0xF0,
  0x3D, 0x1F, 0x03, 0xD1, 0xF0, 0x3D,
  // "ﬂ" (U+FB02)
  0x18, 0xC5, 0xAE, 0x9D, 0x1F, 0x13, 0xDA, 0xFE, 0x5D, 0x1F, 0x03, 0xD1, 0xF0, 0x3D, 0x1F, 0x03,
  0xD1, 0xF0, 0x3D, 0x1F, 0x03, 0xD0,
};

const Font& font_NotoSans_CondensedMedium_11() {
  static SmoothFont font(font_NotoSans_CondensedMedium_11_data);
  return font;
}

}  // namespace roo_display
