#include "8.h"
#include "pgmspace.h"
#include <inttypes.h>
#include "roo_display/font/smooth_font.h"

namespace roo_display {

// Font NotoSans-Condensed (Noto Sans Condensed)
// Generated on Thu Mar 30 23:43:34 CEST 2023
static const uint8_t font_NotoSans_Condensed_8_data[] PROGMEM = {
  
  // Header
  0x01, 0x01, 0x04, 0x02, 0x01, 0x02, 0x01, 0x01, 0x57, 0x00, 0x24,
  0xFE, 0xFE, 0x07, 0x0A, 0x07, 0xFE, 0x04, 0x01, 0x08, 0x03, 0x02, 0x00, 0x5F,
  
  // Glyph metrics
  0x00, 0x21, 0x00, 0x01, 0x01, 0x07, 0x02, 0x00, 0x00, // "!" (U+0021)
  0x00, 0x22, 0x00, 0x05, 0x02, 0x07, 0x03, 0x00, 0x09, // """ (U+0022)
  0x00, 0x23, 0x00, 0x01, 0x03, 0x07, 0x04, 0x00, 0x0F, // "#" (U+0023)
  0x00, 0x24, 0x00, 0x00, 0x03, 0x07, 0x04, 0x00, 0x1F, // "$" (U+0024)
  0x00, 0x25, 0x00, 0x01, 0x05, 0x07, 0x06, 0x00, 0x31, // "%" (U+0025)
  0x00, 0x26, 0x00, 0x01, 0x04, 0x07, 0x04, 0x00, 0x49, // "&" (U+0026)
  0x00, 0x27, 0x00, 0x06, 0x01, 0x07, 0x02, 0x00, 0x5E, // "'" (U+0027)
  0x00, 0x28, 0x00, 0x00, 0x01, 0x07, 0x02, 0x00, 0x61, // "(" (U+0028)
  0x00, 0x29, 0x00, 0x00, 0x01, 0x07, 0x02, 0x00, 0x6B, // ")" (U+0029)
  0x00, 0x2A, 0x00, 0x04, 0x03, 0x07, 0x04, 0x00, 0x75, // "*" (U+002A)
  0x00, 0x2B, 0x00, 0x02, 0x03, 0x05, 0x04, 0x00, 0x7F, // "+" (U+002B)
  0x00, 0x2C, 0x00, 0x00, 0x01, 0x02, 0x02, 0x00, 0x89, // "," (U+002C)
  0x00, 0x2D, 0x00, 0x03, 0x01, 0x03, 0x02, 0x00, 0x8D, // "-" (U+002D)
  0x00, 0x2E, 0x00, 0x01, 0x01, 0x01, 0x02, 0x00, 0x8F, // "." (U+002E)
  0x00, 0x2F, 0x00, 0x01, 0x02, 0x07, 0x03, 0x00, 0x91, // "/" (U+002F)
  0x00, 0x30, 0x00, 0x01, 0x03, 0x07, 0x04, 0x00, 0x9C, // "0" (U+0030)
  0x00, 0x31, 0x00, 0x01, 0x02, 0x07, 0x04, 0x00, 0xAC, // "1" (U+0031)
  0x00, 0x32, 0x00, 0x01, 0x03, 0x07, 0x04, 0x00, 0xB8, // "2" (U+0032)
  0x00, 0x33, 0x00, 0x01, 0x03, 0x07, 0x04, 0x00, 0xC9, // "3" (U+0033)
  0x00, 0x34, 0x00, 0x01, 0x03, 0x07, 0x04, 0x00, 0xD9, // "4" (U+0034)
  0x00, 0x35, 0x00, 0x01, 0x03, 0x07, 0x04, 0x00, 0xE9, // "5" (U+0035)
  0x00, 0x36, 0x00, 0x01, 0x03, 0x07, 0x04, 0x00, 0xFA, // "6" (U+0036)
  0x00, 0x37, 0x00, 0x01, 0x03, 0x07, 0x04, 0x01, 0x0B, // "7" (U+0037)
  0x00, 0x38, 0x00, 0x01, 0x03, 0x07, 0x04, 0x01, 0x1B, // "8" (U+0038)
  0x00, 0x39, 0x00, 0x01, 0x03, 0x07, 0x04, 0x01, 0x2B, // "9" (U+0039)
  0x00, 0x3A, 0x00, 0x01, 0x01, 0x05, 0x02, 0x01, 0x3B, // ":" (U+003A)
  0x00, 0x3B, 0x00, 0x00, 0x01, 0x05, 0x02, 0x01, 0x40, // ";" (U+003B)
  0x00, 0x3C, 0x00, 0x02, 0x03, 0x05, 0x04, 0x01, 0x46, // "<" (U+003C)
  0x00, 0x3D, 0x00, 0x03, 0x03, 0x05, 0x04, 0x01, 0x4F, // "=" (U+003D)
  0x00, 0x3E, 0x00, 0x02, 0x03, 0x05, 0x04, 0x01, 0x56, // ">" (U+003E)
  0x00, 0x3F, 0x00, 0x01, 0x02, 0x07, 0x03, 0x01, 0x60, // "?" (U+003F)
  0x00, 0x40, 0x00, 0x00, 0x05, 0x07, 0x06, 0x01, 0x6D, // "@" (U+0040)
  0x00, 0x41, 0x00, 0x01, 0x03, 0x07, 0x04, 0x01, 0x86, // "A" (U+0041)
  0x00, 0x42, 0x00, 0x01, 0x03, 0x07, 0x04, 0x01, 0x96, // "B" (U+0042)
  0x00, 0x43, 0x00, 0x01, 0x03, 0x07, 0x04, 0x01, 0xA6, // "C" (U+0043)
  0x00, 0x44, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0xB7, // "D" (U+0044)
  0x00, 0x45, 0x00, 0x01, 0x03, 0x07, 0x04, 0x01, 0xCA, // "E" (U+0045)
  0x00, 0x46, 0x00, 0x01, 0x03, 0x07, 0x03, 0x01, 0xDA, // "F" (U+0046)
  0x00, 0x47, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0xE9, // "G" (U+0047)
  0x00, 0x48, 0x00, 0x01, 0x04, 0x07, 0x05, 0x01, 0xFC, // "H" (U+0048)
  0x00, 0x49, 0x00, 0x01, 0x02, 0x07, 0x02, 0x02, 0x0F, // "I" (U+0049)
  0x00, 0x4A, 0xFF, 0x00, 0x01, 0x07, 0x02, 0x02, 0x1B, // "J" (U+004A)
  0x00, 0x4B, 0x00, 0x01, 0x03, 0x07, 0x04, 0x02, 0x29, // "K" (U+004B)
  0x00, 0x4C, 0x00, 0x01, 0x03, 0x07, 0x03, 0x02, 0x39, // "L" (U+004C)
  0x00, 0x4D, 0x00, 0x01, 0x05, 0x07, 0x06, 0x02, 0x48, // "M" (U+004D)
  0x00, 0x4E, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0x60, // "N" (U+004E)
  0x00, 0x4F, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0x73, // "O" (U+004F)
  0x00, 0x50, 0x00, 0x01, 0x03, 0x07, 0x04, 0x02, 0x86, // "P" (U+0050)
  0x00, 0x51, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x02, 0x95, // "Q" (U+0051)
  0x00, 0x52, 0x00, 0x01, 0x03, 0x07, 0x04, 0x02, 0xAD, // "R" (U+0052)
  0x00, 0x53, 0x00, 0x01, 0x03, 0x07, 0x04, 0x02, 0xBD, // "S" (U+0053)
  0x00, 0x54, 0x00, 0x01, 0x03, 0x07, 0x03, 0x02, 0xCD, // "T" (U+0054)
  0x00, 0x55, 0x00, 0x01, 0x04, 0x07, 0x05, 0x02, 0xDF, // "U" (U+0055)
  0x00, 0x56, 0x00, 0x01, 0x03, 0x07, 0x04, 0x02, 0xF3, // "V" (U+0056)
  0x00, 0x57, 0x00, 0x01, 0x06, 0x07, 0x06, 0x03, 0x03, // "W" (U+0057)
  0x00, 0x58, 0x00, 0x01, 0x03, 0x07, 0x04, 0x03, 0x1E, // "X" (U+0058)
  0x00, 0x59, 0x00, 0x01, 0x03, 0x07, 0x04, 0x03, 0x2F, // "Y" (U+0059)
  0x00, 0x5A, 0x00, 0x01, 0x03, 0x07, 0x03, 0x03, 0x41, // "Z" (U+005A)
  0x00, 0x5B, 0x00, 0x00, 0x02, 0x07, 0x03, 0x03, 0x52, // "[" (U+005B)
  0x00, 0x5C, 0x00, 0x01, 0x02, 0x07, 0x03, 0x03, 0x60, // "\" (U+005C)
  0x00, 0x5D, 0x00, 0x00, 0x01, 0x07, 0x03, 0x03, 0x6C, // "]" (U+005D)
  0x00, 0x5E, 0x00, 0x04, 0x03, 0x07, 0x04, 0x03, 0x76, // "^" (U+005E)
  0x00, 0x5F, 0x00, 0xFF, 0x03, 0xFF, 0x04, 0x03, 0x80, // "_" (U+005F)
  0x00, 0x60, 0x00, 0x07, 0x01, 0x08, 0x02, 0x03, 0x83, // "`" (U+0060)
  0x00, 0x61, 0x00, 0x01, 0x03, 0x05, 0x04, 0x03, 0x86, // "a" (U+0061)
  0x00, 0x62, 0x00, 0x01, 0x03, 0x07, 0x04, 0x03, 0x92, // "b" (U+0062)
  0x00, 0x63, 0x00, 0x01, 0x02, 0x05, 0x03, 0x03, 0xA3, // "c" (U+0063)
  0x00, 0x64, 0x00, 0x01, 0x03, 0x07, 0x04, 0x03, 0xAC, // "d" (U+0064)
  0x00, 0x65, 0x00, 0x01, 0x03, 0x05, 0x04, 0x03, 0xBC, // "e" (U+0065)
  0x00, 0x66, 0x00, 0x01, 0x02, 0x07, 0x02, 0x03, 0xC8, // "f" (U+0066)
  0x00, 0x67, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x03, 0xD4, // "g" (U+0067)
  0x00, 0x68, 0x00, 0x01, 0x03, 0x07, 0x04, 0x03, 0xE4, // "h" (U+0068)
  0x00, 0x69, 0x00, 0x01, 0x01, 0x07, 0x02, 0x03, 0xF5, // "i" (U+0069)
  0x00, 0x6A, 0xFF, 0xFF, 0x01, 0x07, 0x02, 0x03, 0xFE, // "j" (U+006A)
  0x00, 0x6B, 0x00, 0x01, 0x03, 0x07, 0x04, 0x04, 0x0D, // "k" (U+006B)
  0x00, 0x6C, 0x00, 0x01, 0x01, 0x07, 0x02, 0x04, 0x1E, // "l" (U+006C)
  0x00, 0x6D, 0x00, 0x01, 0x05, 0x05, 0x06, 0x04, 0x27, // "m" (U+006D)
  0x00, 0x6E, 0x00, 0x01, 0x03, 0x05, 0x04, 0x04, 0x38, // "n" (U+006E)
  0x00, 0x6F, 0x00, 0x01, 0x03, 0x05, 0x04, 0x04, 0x44, // "o" (U+006F)
  0x00, 0x70, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x04, 0x50, // "p" (U+0070)
  0x00, 0x71, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x04, 0x60, // "q" (U+0071)
  0x00, 0x72, 0x00, 0x01, 0x02, 0x05, 0x03, 0x04, 0x71, // "r" (U+0072)
  0x00, 0x73, 0x00, 0x01, 0x02, 0x05, 0x03, 0x04, 0x7A, // "s" (U+0073)
  0x00, 0x74, 0x00, 0x01, 0x02, 0x06, 0x02, 0x04, 0x83, // "t" (U+0074)
  0x00, 0x75, 0x00, 0x01, 0x03, 0x05, 0x04, 0x04, 0x8E, // "u" (U+0075)
  0x00, 0x76, 0x00, 0x01, 0x03, 0x05, 0x03, 0x04, 0x9A, // "v" (U+0076)
  0x00, 0x77, 0x00, 0x01, 0x05, 0x05, 0x05, 0x04, 0xA6, // "w" (U+0077)
  0x00, 0x78, 0x00, 0x01, 0x02, 0x05, 0x03, 0x04, 0xB7, // "x" (U+0078)
  0x00, 0x79, 0x00, 0xFF, 0x03, 0x05, 0x03, 0x04, 0xC0, // "y" (U+0079)
  0x00, 0x7A, 0x00, 0x01, 0x02, 0x05, 0x03, 0x04, 0xD1, // "z" (U+007A)
  0x00, 0x7B, 0x00, 0x00, 0x02, 0x07, 0x03, 0x04, 0xDA, // "{" (U+007B)
  0x00, 0x7C, 0x01, 0xFF, 0x02, 0x07, 0x04, 0x04, 0xE8, // "|" (U+007C)
  0x00, 0x7D, 0x00, 0x00, 0x02, 0x07, 0x03, 0x04, 0xF3, // "}" (U+007D)
  0x00, 0x7E, 0x00, 0x03, 0x03, 0x03, 0x04, 0x05, 0x01, // "~" (U+007E)
  0x00, 0xA1, 0x00, 0x00, 0x01, 0x05, 0x02, 0x05, 0x04, // "¡" (U+00A1)
  0x00, 0xA2, 0x00, 0x01, 0x03, 0x07, 0x04, 0x05, 0x0C, // "¢" (U+00A2)
  0x00, 0xA3, 0x00, 0x01, 0x03, 0x07, 0x04, 0x05, 0x1C, // "£" (U+00A3)
  0x00, 0xA4, 0x00, 0x02, 0x03, 0x05, 0x04, 0x05, 0x2D, // "¤" (U+00A4)
  0x00, 0xA5, 0x00, 0x01, 0x03, 0x07, 0x04, 0x05, 0x37, // "¥" (U+00A5)
  0x00, 0xA6, 0x01, 0xFF, 0x02, 0x07, 0x04, 0x05, 0x48, // "¦" (U+00A6)
  0x00, 0xA7, 0x00, 0x01, 0x02, 0x07, 0x03, 0x05, 0x52, // "§" (U+00A7)
  0x00, 0xA8, 0x01, 0x07, 0x03, 0x07, 0x04, 0x05, 0x5F, // "¨" (U+00A8)
  0x00, 0xA9, 0x00, 0x01, 0x06, 0x07, 0x07, 0x05, 0x62, // "©" (U+00A9)
  0x00, 0xAA, 0x00, 0x04, 0x02, 0x06, 0x03, 0x05, 0x7E, // "ª" (U+00AA)
  0x00, 0xAB, 0x00, 0x01, 0x03, 0x04, 0x04, 0x05, 0x84, // "«" (U+00AB)
  0x00, 0xAC, 0x00, 0x02, 0x03, 0x04, 0x04, 0x05, 0x8E, // "¬" (U+00AC)
  0x00, 0xAE, 0x00, 0x01, 0x06, 0x07, 0x07, 0x05, 0x96, // "®" (U+00AE)
  0x00, 0xAF, 0x00, 0x08, 0x03, 0x08, 0x04, 0x05, 0xB1, // "¯" (U+00AF)
  0x00, 0xB0, 0x00, 0x05, 0x02, 0x07, 0x03, 0x05, 0xB4, // "°" (U+00B0)
  0x00, 0xB1, 0x00, 0x01, 0x03, 0x05, 0x04, 0x05, 0xBA, // "±" (U+00B1)
  0x00, 0xB2, 0x00, 0x04, 0x02, 0x07, 0x03, 0x05, 0xC6, // "²" (U+00B2)
  0x00, 0xB3, 0x00, 0x04, 0x02, 0x07, 0x03, 0x05, 0xCE, // "³" (U+00B3)
  0x00, 0xB4, 0x00, 0x07, 0x01, 0x08, 0x02, 0x05, 0xD6, // "´" (U+00B4)
  0x00, 0xB5, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x05, 0xD9, // "µ" (U+00B5)
  0x00, 0xB6, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x05, 0xE9, // "¶" (U+00B6)
  0x00, 0xB7, 0x00, 0x03, 0x01, 0x03, 0x02, 0x05, 0xFD, // "·" (U+00B7)
  0x00, 0xB8, 0x00, 0xFF, 0x01, 0x01, 0x02, 0x05, 0xFF, // "¸" (U+00B8)
  0x00, 0xB9, 0x00, 0x04, 0x01, 0x07, 0x03, 0x06, 0x03, // "¹" (U+00B9)
  0x00, 0xBA, 0x00, 0x04, 0x02, 0x06, 0x03, 0x06, 0x08, // "º" (U+00BA)
  0x00, 0xBB, 0x00, 0x01, 0x03, 0x04, 0x04, 0x06, 0x0E, // "»" (U+00BB)
  0x00, 0xBC, 0x00, 0x01, 0x05, 0x07, 0x06, 0x06, 0x18, // "¼" (U+00BC)
  0x00, 0xBD, 0x00, 0x01, 0x05, 0x07, 0x06, 0x06, 0x31, // "½" (U+00BD)
  0x00, 0xBE, 0x00, 0x01, 0x05, 0x07, 0x06, 0x06, 0x49, // "¾" (U+00BE)
  0x00, 0xBF, 0x00, 0xFE, 0x02, 0x04, 0x03, 0x06, 0x61, // "¿" (U+00BF)
  0x00, 0xC0, 0x00, 0x01, 0x03, 0x09, 0x04, 0x06, 0x6E, // "À" (U+00C0)
  0x00, 0xC1, 0x00, 0x01, 0x03, 0x09, 0x04, 0x06, 0x83, // "Á" (U+00C1)
  0x00, 0xC2, 0x00, 0x01, 0x03, 0x09, 0x04, 0x06, 0x97, // "Â" (U+00C2)
  0x00, 0xC3, 0x00, 0x01, 0x03, 0x08, 0x04, 0x06, 0xAB, // "Ã" (U+00C3)
  0x00, 0xC4, 0x00, 0x01, 0x03, 0x08, 0x04, 0x06, 0xBD, // "Ä" (U+00C4)
  0x00, 0xC5, 0x00, 0x01, 0x03, 0x07, 0x04, 0x06, 0xCF, // "Å" (U+00C5)
  0x00, 0xC6, 0x00, 0x01, 0x05, 0x07, 0x06, 0x06, 0xDF, // "Æ" (U+00C6)
  0x00, 0xC7, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x06, 0xF6, // "Ç" (U+00C7)
  0x00, 0xC8, 0x00, 0x01, 0x03, 0x09, 0x04, 0x07, 0x0C, // "È" (U+00C8)
  0x00, 0xC9, 0x00, 0x01, 0x03, 0x09, 0x04, 0x07, 0x21, // "É" (U+00C9)
  0x00, 0xCA, 0x00, 0x01, 0x03, 0x09, 0x04, 0x07, 0x35, // "Ê" (U+00CA)
  0x00, 0xCB, 0x00, 0x01, 0x03, 0x08, 0x04, 0x07, 0x4A, // "Ë" (U+00CB)
  0x00, 0xCC, 0x00, 0x01, 0x02, 0x09, 0x02, 0x07, 0x5C, // "Ì" (U+00CC)
  0x00, 0xCD, 0x00, 0x01, 0x02, 0x09, 0x02, 0x07, 0x6B, // "Í" (U+00CD)
  0x00, 0xCE, 0x00, 0x01, 0x02, 0x09, 0x02, 0x07, 0x7A, // "Î" (U+00CE)
  0x00, 0xCF, 0x00, 0x01, 0x02, 0x08, 0x02, 0x07, 0x89, // "Ï" (U+00CF)
  0x00, 0xD0, 0x00, 0x01, 0x04, 0x07, 0x05, 0x07, 0x97, // "Ð" (U+00D0)
  0x00, 0xD1, 0x00, 0x01, 0x04, 0x08, 0x05, 0x07, 0xAA, // "Ñ" (U+00D1)
  0x00, 0xD2, 0x00, 0x01, 0x04, 0x09, 0x05, 0x07, 0xC0, // "Ò" (U+00D2)
  0x00, 0xD3, 0x00, 0x01, 0x04, 0x09, 0x05, 0x07, 0xD8, // "Ó" (U+00D3)
  0x00, 0xD4, 0x00, 0x01, 0x04, 0x09, 0x05, 0x07, 0xEF, // "Ô" (U+00D4)
  0x00, 0xD5, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0x07, // "Õ" (U+00D5)
  0x00, 0xD6, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0x1D, // "Ö" (U+00D6)
  0x00, 0xD7, 0x00, 0x02, 0x03, 0x05, 0x04, 0x08, 0x33, // "×" (U+00D7)
  0x00, 0xD8, 0x00, 0x00, 0x04, 0x07, 0x05, 0x08, 0x3D, // "Ø" (U+00D8)
  0x00, 0xD9, 0x00, 0x01, 0x04, 0x09, 0x05, 0x08, 0x51, // "Ù" (U+00D9)
  0x00, 0xDA, 0x00, 0x01, 0x04, 0x09, 0x05, 0x08, 0x6A, // "Ú" (U+00DA)
  0x00, 0xDB, 0x00, 0x01, 0x04, 0x09, 0x05, 0x08, 0x81, // "Û" (U+00DB)
  0x00, 0xDC, 0x00, 0x01, 0x04, 0x08, 0x05, 0x08, 0x99, // "Ü" (U+00DC)
  0x00, 0xDD, 0x00, 0x01, 0x03, 0x09, 0x04, 0x08, 0xAF, // "Ý" (U+00DD)
  0x00, 0xDE, 0x00, 0x01, 0x03, 0x07, 0x04, 0x08, 0xC4, // "Þ" (U+00DE)
  0x00, 0xDF, 0x00, 0x01, 0x03, 0x07, 0x04, 0x08, 0xD3, // "ß" (U+00DF)
  0x00, 0xE0, 0x00, 0x01, 0x03, 0x08, 0x04, 0x08, 0xE3, // "à" (U+00E0)
  0x00, 0xE1, 0x00, 0x01, 0x03, 0x08, 0x04, 0x08, 0xF4, // "á" (U+00E1)
  0x00, 0xE2, 0x00, 0x01, 0x03, 0x08, 0x04, 0x09, 0x04, // "â" (U+00E2)
  0x00, 0xE3, 0x00, 0x01, 0x03, 0x07, 0x04, 0x09, 0x15, // "ã" (U+00E3)
  0x00, 0xE4, 0x00, 0x01, 0x03, 0x07, 0x04, 0x09, 0x25, // "ä" (U+00E4)
  0x00, 0xE5, 0x00, 0x01, 0x03, 0x07, 0x04, 0x09, 0x34, // "å" (U+00E5)
  0x00, 0xE6, 0x00, 0x01, 0x05, 0x05, 0x06, 0x09, 0x44, // "æ" (U+00E6)
  0x00, 0xE7, 0x00, 0xFF, 0x02, 0x05, 0x03, 0x09, 0x55, // "ç" (U+00E7)
  0x00, 0xE8, 0x00, 0x01, 0x03, 0x08, 0x04, 0x09, 0x61, // "è" (U+00E8)
  0x00, 0xE9, 0x00, 0x01, 0x03, 0x08, 0x04, 0x09, 0x73, // "é" (U+00E9)
  0x00, 0xEA, 0x00, 0x01, 0x03, 0x08, 0x04, 0x09, 0x84, // "ê" (U+00EA)
  0x00, 0xEB, 0x00, 0x01, 0x03, 0x07, 0x04, 0x09, 0x95, // "ë" (U+00EB)
  0x00, 0xEC, 0x00, 0x01, 0x01, 0x08, 0x02, 0x09, 0xA5, // "ì" (U+00EC)
  0x00, 0xED, 0x00, 0x01, 0x01, 0x08, 0x02, 0x09, 0xAF, // "í" (U+00ED)
  0x00, 0xEE, 0xFF, 0x01, 0x01, 0x08, 0x02, 0x09, 0xB9, // "î" (U+00EE)
  0x00, 0xEF, 0x00, 0x01, 0x02, 0x07, 0x02, 0x09, 0xC6, // "ï" (U+00EF)
  0x00, 0xF0, 0x00, 0x01, 0x03, 0x08, 0x04, 0x09, 0xD2, // "ð" (U+00F0)
  0x00, 0xF1, 0x00, 0x01, 0x03, 0x07, 0x04, 0x09, 0xE4, // "ñ" (U+00F1)
  0x00, 0xF2, 0x00, 0x01, 0x03, 0x08, 0x04, 0x09, 0xF4, // "ò" (U+00F2)
  0x00, 0xF3, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x05, // "ó" (U+00F3)
  0x00, 0xF4, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x15, // "ô" (U+00F4)
  0x00, 0xF5, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0A, 0x26, // "õ" (U+00F5)
  0x00, 0xF6, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0A, 0x36, // "ö" (U+00F6)
  0x00, 0xF7, 0x00, 0x02, 0x03, 0x05, 0x04, 0x0A, 0x45, // "÷" (U+00F7)
  0x00, 0xF8, 0x00, 0x00, 0x03, 0x06, 0x04, 0x0A, 0x4D, // "ø" (U+00F8)
  0x00, 0xF9, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x5B, // "ù" (U+00F9)
  0x00, 0xFA, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x6C, // "ú" (U+00FA)
  0x00, 0xFB, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0x7C, // "û" (U+00FB)
  0x00, 0xFC, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0A, 0x8D, // "ü" (U+00FC)
  0x00, 0xFD, 0x00, 0xFF, 0x03, 0x08, 0x03, 0x0A, 0x9C, // "ý" (U+00FD)
  0x00, 0xFE, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0A, 0xB1, // "þ" (U+00FE)
  0x00, 0xFF, 0x00, 0xFF, 0x03, 0x07, 0x03, 0x0A, 0xC6, // "ÿ" (U+00FF)
  0x01, 0x00, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0A, 0xDA, // "Ā" (U+0100)
  0x01, 0x01, 0x00, 0x01, 0x03, 0x06, 0x04, 0x0A, 0xEA, // "ā" (U+0101)
  0x01, 0x02, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0A, 0xF8, // "Ă" (U+0102)
  0x01, 0x03, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0B, 0x0B, // "ă" (U+0103)
  0x01, 0x04, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0B, 0x1B, // "Ą" (U+0104)
  0x01, 0x05, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x0B, 0x2F, // "ą" (U+0105)
  0x01, 0x06, 0x00, 0x01, 0x03, 0x09, 0x04, 0x0B, 0x3F, // "Ć" (U+0106)
  0x01, 0x07, 0x00, 0x01, 0x02, 0x08, 0x03, 0x0B, 0x53, // "ć" (U+0107)
  0x01, 0x08, 0x00, 0x01, 0x03, 0x09, 0x04, 0x0B, 0x60, // "Ĉ" (U+0108)
  0x01, 0x09, 0x00, 0x01, 0x02, 0x08, 0x03, 0x0B, 0x75, // "ĉ" (U+0109)
  0x01, 0x0A, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0B, 0x83, // "Ċ" (U+010A)
  0x01, 0x0B, 0x00, 0x01, 0x02, 0x07, 0x03, 0x0B, 0x96, // "ċ" (U+010B)
  0x01, 0x0C, 0x00, 0x01, 0x03, 0x09, 0x04, 0x0B, 0xA1, // "Č" (U+010C)
  0x01, 0x0D, 0x00, 0x01, 0x02, 0x08, 0x03, 0x0B, 0xB7, // "č" (U+010D)
  0x01, 0x0E, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0B, 0xC5, // "Ď" (U+010E)
  0x01, 0x0F, 0x00, 0x01, 0x04, 0x07, 0x04, 0x0B, 0xDE, // "ď" (U+010F)
  0x01, 0x10, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0B, 0xF1, // "Đ" (U+0110)
  0x01, 0x11, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0C, 0x04, // "đ" (U+0111)
  0x01, 0x12, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0C, 0x13, // "Ē" (U+0112)
  0x01, 0x13, 0x00, 0x01, 0x03, 0x06, 0x04, 0x0C, 0x22, // "ē" (U+0113)
  0x01, 0x14, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0C, 0x30, // "Ĕ" (U+0114)
  0x01, 0x15, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0C, 0x43, // "ĕ" (U+0115)
  0x01, 0x16, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0C, 0x53, // "Ė" (U+0116)
  0x01, 0x17, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0C, 0x65, // "ė" (U+0117)
  0x01, 0x18, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0C, 0x73, // "Ę" (U+0118)
  0x01, 0x19, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x0C, 0x87, // "ę" (U+0119)
  0x01, 0x1A, 0x00, 0x01, 0x03, 0x09, 0x04, 0x0C, 0x97, // "Ě" (U+011A)
  0x01, 0x1B, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0C, 0xAC, // "ě" (U+011B)
  0x01, 0x1C, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0C, 0xBD, // "Ĝ" (U+011C)
  0x01, 0x1D, 0x00, 0xFF, 0x03, 0x08, 0x04, 0x0C, 0xD5, // "ĝ" (U+011D)
  0x01, 0x1E, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0C, 0xEA, // "Ğ" (U+011E)
  0x01, 0x1F, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0D, 0x00, // "ğ" (U+011F)
  0x01, 0x20, 0x00, 0x01, 0x04, 0x08, 0x05, 0x0D, 0x14, // "Ġ" (U+0120)
  0x01, 0x21, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0D, 0x29, // "ġ" (U+0121)
  0x01, 0x22, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0D, 0x3B, // "Ģ" (U+0122)
  0x01, 0x23, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0D, 0x51, // "ģ" (U+0123)
  0x01, 0x24, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0D, 0x66, // "Ĥ" (U+0124)
  0x01, 0x25, 0xFF, 0x01, 0x03, 0x0A, 0x04, 0x0D, 0x7D, // "ĥ" (U+0125)
  0x01, 0x26, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0D, 0x95, // "Ħ" (U+0126)
  0x01, 0x27, 0x00, 0x01, 0x03, 0x07, 0x04, 0x0D, 0xA8, // "ħ" (U+0127)
  0x01, 0x28, 0x00, 0x01, 0x02, 0x08, 0x02, 0x0D, 0xB8, // "Ĩ" (U+0128)
  0x01, 0x29, 0xFF, 0x01, 0x01, 0x07, 0x02, 0x0D, 0xC6, // "ĩ" (U+0129)
  0x01, 0x2A, 0x00, 0x01, 0x02, 0x07, 0x02, 0x0D, 0xD2, // "Ī" (U+012A)
  0x01, 0x2B, 0x00, 0x01, 0x02, 0x06, 0x02, 0x0D, 0xDE, // "ī" (U+012B)
  0x01, 0x2C, 0x00, 0x01, 0x02, 0x08, 0x02, 0x0D, 0xE9, // "Ĭ" (U+012C)
  0x01, 0x2D, 0x00, 0x01, 0x02, 0x07, 0x02, 0x0D, 0xF7, // "ĭ" (U+012D)
  0x01, 0x2E, 0x00, 0xFF, 0x02, 0x07, 0x02, 0x0E, 0x03, // "Į" (U+012E)
  0x01, 0x2F, 0x00, 0xFF, 0x01, 0x07, 0x02, 0x0E, 0x13, // "į" (U+012F)
  0x01, 0x30, 0x00, 0x01, 0x02, 0x08, 0x02, 0x0E, 0x1E, // "İ" (U+0130)
  0x01, 0x31, 0x00, 0x01, 0x01, 0x05, 0x02, 0x0E, 0x2C, // "ı" (U+0131)
  0x01, 0x32, 0x00, 0x00, 0x03, 0x07, 0x04, 0x0E, 0x33, // "Ĳ" (U+0132)
  0x01, 0x33, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0E, 0x45, // "ĳ" (U+0133)
  0x01, 0x34, 0xFF, 0x00, 0x02, 0x09, 0x02, 0x0E, 0x59, // "Ĵ" (U+0134)
  0x01, 0x35, 0xFF, 0xFF, 0x01, 0x08, 0x02, 0x0E, 0x70, // "ĵ" (U+0135)
  0x01, 0x36, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0E, 0x80, // "Ķ" (U+0136)
  0x01, 0x37, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x0E, 0x93, // "ķ" (U+0137)
  0x01, 0x38, 0x00, 0x01, 0x03, 0x05, 0x04, 0x0E, 0xA7, // "ĸ" (U+0138)
  0x01, 0x39, 0x00, 0x01, 0x03, 0x09, 0x03, 0x0E, 0xB3, // "Ĺ" (U+0139)
  0x01, 0x3A, 0x00, 0x01, 0x01, 0x0A, 0x02, 0x0E, 0xC7, // "ĺ" (U+013A)
  0x01, 0x3B, 0x00, 0xFF, 0x03, 0x07, 0x03, 0x0E, 0xD3, // "Ļ" (U+013B)
  0x01, 0x3C, 0x00, 0xFF, 0x01, 0x07, 0x02, 0x0E, 0xE5, // "ļ" (U+013C)
  0x01, 0x3D, 0x00, 0x01, 0x03, 0x07, 0x03, 0x0E, 0xF0, // "Ľ" (U+013D)
  0x01, 0x3E, 0x00, 0x01, 0x02, 0x07, 0x02, 0x0F, 0x00, // "ľ" (U+013E)
  0x01, 0x3F, 0x00, 0x01, 0x03, 0x07, 0x03, 0x0F, 0x0C, // "Ŀ" (U+013F)
  0x01, 0x40, 0x00, 0x01, 0x01, 0x07, 0x02, 0x0F, 0x1C, // "ŀ" (U+0140)
  0x01, 0x41, 0x00, 0x01, 0x03, 0x07, 0x03, 0x0F, 0x25, // "Ł" (U+0141)
  0x01, 0x42, 0x00, 0x01, 0x01, 0x07, 0x02, 0x0F, 0x35, // "ł" (U+0142)
  0x01, 0x43, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0F, 0x3E, // "Ń" (U+0143)
  0x01, 0x44, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0F, 0x55, // "ń" (U+0144)
  0x01, 0x45, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0F, 0x65, // "Ņ" (U+0145)
  0x01, 0x46, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x0F, 0x7B, // "ņ" (U+0146)
  0x01, 0x47, 0x00, 0x01, 0x04, 0x09, 0x05, 0x0F, 0x8A, // "Ň" (U+0147)
  0x01, 0x48, 0x00, 0x01, 0x03, 0x08, 0x04, 0x0F, 0xA3, // "ň" (U+0148)
  0x01, 0x49, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0F, 0xB4, // "ŉ" (U+0149)
  0x01, 0x4A, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x0F, 0xC6, // "Ŋ" (U+014A)
  0x01, 0x4B, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x0F, 0xDF, // "ŋ" (U+014B)
  0x01, 0x4C, 0x00, 0x01, 0x04, 0x07, 0x05, 0x0F, 0xF0, // "Ō" (U+014C)
  0x01, 0x4D, 0x00, 0x01, 0x03, 0x06, 0x04, 0x10, 0x03, // "ō" (U+014D)
  0x01, 0x4E, 0x00, 0x01, 0x04, 0x08, 0x05, 0x10, 0x11, // "Ŏ" (U+014E)
  0x01, 0x4F, 0x00, 0x01, 0x03, 0x07, 0x04, 0x10, 0x27, // "ŏ" (U+014F)
  0x01, 0x50, 0x00, 0x01, 0x04, 0x08, 0x05, 0x10, 0x37, // "Ő" (U+0150)
  0x01, 0x51, 0x00, 0x01, 0x03, 0x07, 0x04, 0x10, 0x4D, // "ő" (U+0151)
  0x01, 0x52, 0x00, 0x01, 0x05, 0x07, 0x06, 0x10, 0x5D, // "Œ" (U+0152)
  0x01, 0x53, 0x00, 0x01, 0x05, 0x05, 0x06, 0x10, 0x75, // "œ" (U+0153)
  0x01, 0x54, 0x00, 0x01, 0x03, 0x09, 0x04, 0x10, 0x86, // "Ŕ" (U+0154)
  0x01, 0x55, 0x00, 0x01, 0x02, 0x08, 0x03, 0x10, 0x99, // "ŕ" (U+0155)
  0x01, 0x56, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x10, 0xA6, // "Ŗ" (U+0156)
  0x01, 0x57, 0x00, 0xFF, 0x02, 0x05, 0x03, 0x10, 0xB9, // "ŗ" (U+0157)
  0x01, 0x58, 0x00, 0x01, 0x03, 0x09, 0x04, 0x10, 0xC5, // "Ř" (U+0158)
  0x01, 0x59, 0x00, 0x01, 0x02, 0x08, 0x03, 0x10, 0xD9, // "ř" (U+0159)
  0x01, 0x5A, 0x00, 0x01, 0x03, 0x09, 0x04, 0x10, 0xE7, // "Ś" (U+015A)
  0x01, 0x5B, 0x00, 0x01, 0x02, 0x08, 0x03, 0x10, 0xFB, // "ś" (U+015B)
  0x01, 0x5C, 0x00, 0x01, 0x03, 0x09, 0x04, 0x11, 0x08, // "Ŝ" (U+015C)
  0x01, 0x5D, 0x00, 0x01, 0x02, 0x08, 0x03, 0x11, 0x1D, // "ŝ" (U+015D)
  0x01, 0x5E, 0x00, 0xFF, 0x03, 0x07, 0x04, 0x11, 0x2B, // "Ş" (U+015E)
  0x01, 0x5F, 0x00, 0xFF, 0x02, 0x05, 0x03, 0x11, 0x40, // "ş" (U+015F)
  0x01, 0x60, 0x00, 0x01, 0x03, 0x09, 0x04, 0x11, 0x4D, // "Š" (U+0160)
  0x01, 0x61, 0x00, 0x01, 0x02, 0x08, 0x03, 0x11, 0x62, // "š" (U+0161)
  0x01, 0x62, 0x00, 0xFF, 0x03, 0x07, 0x03, 0x11, 0x70, // "Ţ" (U+0162)
  0x01, 0x63, 0x00, 0xFF, 0x02, 0x06, 0x02, 0x11, 0x86, // "ţ" (U+0163)
  0x01, 0x64, 0x00, 0x01, 0x03, 0x09, 0x03, 0x11, 0x94, // "Ť" (U+0164)
  0x01, 0x65, 0x00, 0x01, 0x03, 0x07, 0x02, 0x11, 0xAA, // "ť" (U+0165)
  0x01, 0x66, 0x00, 0x01, 0x03, 0x07, 0x03, 0x11, 0xBB, // "Ŧ" (U+0166)
  0x01, 0x67, 0x00, 0x01, 0x02, 0x06, 0x02, 0x11, 0xCC, // "ŧ" (U+0167)
  0x01, 0x68, 0x00, 0x01, 0x04, 0x08, 0x05, 0x11, 0xD7, // "Ũ" (U+0168)
  0x01, 0x69, 0x00, 0x01, 0x03, 0x07, 0x04, 0x11, 0xED, // "ũ" (U+0169)
  0x01, 0x6A, 0x00, 0x01, 0x04, 0x07, 0x05, 0x11, 0xFD, // "Ū" (U+016A)
  0x01, 0x6B, 0x00, 0x01, 0x03, 0x06, 0x04, 0x12, 0x11, // "ū" (U+016B)
  0x01, 0x6C, 0x00, 0x01, 0x04, 0x08, 0x05, 0x12, 0x1F, // "Ŭ" (U+016C)
  0x01, 0x6D, 0x00, 0x01, 0x03, 0x07, 0x04, 0x12, 0x35, // "ŭ" (U+016D)
  0x01, 0x6E, 0x00, 0x01, 0x04, 0x08, 0x05, 0x12, 0x45, // "Ů" (U+016E)
  0x01, 0x6F, 0x00, 0x01, 0x03, 0x07, 0x04, 0x12, 0x5C, // "ů" (U+016F)
  0x01, 0x70, 0x00, 0x01, 0x04, 0x08, 0x05, 0x12, 0x6C, // "Ű" (U+0170)
  0x01, 0x71, 0x00, 0x01, 0x03, 0x07, 0x04, 0x12, 0x82, // "ű" (U+0171)
  0x01, 0x72, 0x00, 0xFF, 0x04, 0x07, 0x05, 0x12, 0x92, // "Ų" (U+0172)
  0x01, 0x73, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x12, 0xAA, // "ų" (U+0173)
  0x01, 0x74, 0x00, 0x01, 0x06, 0x09, 0x06, 0x12, 0xBA, // "Ŵ" (U+0174)
  0x01, 0x75, 0x00, 0x01, 0x05, 0x08, 0x05, 0x12, 0xDA, // "ŵ" (U+0175)
  0x01, 0x76, 0x00, 0x01, 0x03, 0x09, 0x04, 0x12, 0xF1, // "Ŷ" (U+0176)
  0x01, 0x77, 0x00, 0xFF, 0x03, 0x08, 0x03, 0x13, 0x07, // "ŷ" (U+0177)
  0x01, 0x78, 0x00, 0x01, 0x03, 0x08, 0x04, 0x13, 0x1D, // "Ÿ" (U+0178)
  0x01, 0x79, 0x00, 0x01, 0x03, 0x09, 0x03, 0x13, 0x31, // "Ź" (U+0179)
  0x01, 0x7A, 0x00, 0x01, 0x02, 0x08, 0x03, 0x13, 0x45, // "ź" (U+017A)
  0x01, 0x7B, 0x00, 0x01, 0x03, 0x08, 0x03, 0x13, 0x52, // "Ż" (U+017B)
  0x01, 0x7C, 0x00, 0x01, 0x02, 0x07, 0x03, 0x13, 0x65, // "ż" (U+017C)
  0x01, 0x7D, 0x00, 0x01, 0x03, 0x09, 0x03, 0x13, 0x70, // "Ž" (U+017D)
  0x01, 0x7E, 0x00, 0x01, 0x02, 0x08, 0x03, 0x13, 0x85, // "ž" (U+017E)
  0x01, 0x7F, 0x00, 0x01, 0x02, 0x07, 0x02, 0x13, 0x93, // "ſ" (U+017F)
  0x03, 0xA9, 0x00, 0x01, 0x04, 0x07, 0x05, 0x13, 0x9F, // "Ω" (U+03A9)
  0x03, 0xBC, 0x00, 0xFF, 0x03, 0x05, 0x04, 0x13, 0xB2, // "μ" (U+03BC)
  0x03, 0xC0, 0x00, 0x01, 0x04, 0x05, 0x04, 0x13, 0xC2, // "π" (U+03C0)
  0x20, 0x13, 0x00, 0x03, 0x03, 0x03, 0x04, 0x13, 0xD0, // "–" (U+2013)
  0x20, 0x14, 0x00, 0x03, 0x07, 0x03, 0x08, 0x13, 0xD3, // "—" (U+2014)
  0x20, 0xAC, 0x00, 0x01, 0x03, 0x07, 0x04, 0x13, 0xD7, // "€" (U+20AC)
  0x20, 0xBF, 0x00, 0x00, 0x03, 0x08, 0x04, 0x13, 0xE8, // "₿" (U+20BF)
  0x20, 0x18, 0x00, 0x05, 0x01, 0x07, 0x01, 0x13, 0xFC, // "‘" (U+2018)
  0x20, 0x19, 0x00, 0x05, 0x01, 0x07, 0x01, 0x14, 0x00, // "’" (U+2019)
  0x20, 0x1A, 0x00, 0x00, 0x01, 0x02, 0x02, 0x14, 0x04, // "‚" (U+201A)
  0x20, 0x1B, 0x00, 0x06, 0x01, 0x07, 0x01, 0x14, 0x08, // "‛" (U+201B)
  0x20, 0x1C, 0x00, 0x05, 0x02, 0x07, 0x03, 0x14, 0x0B, // "“" (U+201C)
  0x20, 0x1D, 0x00, 0x05, 0x02, 0x07, 0x03, 0x14, 0x11, // "”" (U+201D)
  0x20, 0x1E, 0x00, 0x00, 0x02, 0x02, 0x03, 0x14, 0x17, // "„" (U+201E)
  0x20, 0x1F, 0x00, 0x05, 0x02, 0x07, 0x03, 0x14, 0x1D, // "‟" (U+201F)
  0x20, 0x20, 0x00, 0x01, 0x03, 0x07, 0x04, 0x14, 0x23, // "†" (U+2020)
  0x20, 0x21, 0x00, 0x01, 0x03, 0x07, 0x04, 0x14, 0x34, // "‡" (U+2021)
  0x20, 0x22, 0x00, 0x03, 0x02, 0x05, 0x03, 0x14, 0x45, // "•" (U+2022)
  0x20, 0x26, 0x00, 0x01, 0x05, 0x01, 0x06, 0x14, 0x4B, // "…" (U+2026)
  0x20, 0x30, 0x00, 0x01, 0x07, 0x07, 0x08, 0x14, 0x4F, // "‰" (U+2030)
  0x20, 0x39, 0x00, 0x01, 0x01, 0x04, 0x02, 0x14, 0x6C, // "‹" (U+2039)
  0x20, 0x3A, 0x00, 0x01, 0x01, 0x04, 0x02, 0x14, 0x71, // "›" (U+203A)
  0x20, 0x44, 0xFE, 0x01, 0x02, 0x07, 0x01, 0x14, 0x76, // "⁄" (U+2044)
  0x21, 0x22, 0x00, 0x03, 0x04, 0x06, 0x05, 0x14, 0x85, // "™" (U+2122)
  0x21, 0x52, 0x00, 0x01, 0x07, 0x07, 0x08, 0x14, 0x91, // "⅒" (U+2152)
  0xFB, 0x01, 0x00, 0x01, 0x03, 0x07, 0x04, 0x14, 0xAD, // "ﬁ" (U+FB01)
  0xFB, 0x02, 0x00, 0x01, 0x03, 0x07, 0x04, 0x14, 0xBD, // "ﬂ" (U+FB02)
  
  // Kerning pairs
  0x00, 0x22, 0x00, 0xC6, 0x01, // "Æ (U+0022 U+00C6)
  0x00, 0x27, 0x00, 0xC6, 0x01, // 'Æ (U+0027 U+00C6)
  0x00, 0x30, 0x20, 0x44, 0x01, // 0⁄ (U+0030 U+2044)
  0x00, 0x31, 0x20, 0x44, 0x01, // 1⁄ (U+0031 U+2044)
  0x00, 0x32, 0x20, 0x44, 0x01, // 2⁄ (U+0032 U+2044)
  0x00, 0x33, 0x20, 0x44, 0x01, // 3⁄ (U+0033 U+2044)
  0x00, 0x34, 0x20, 0x44, 0x01, // 4⁄ (U+0034 U+2044)
  0x00, 0x35, 0x20, 0x44, 0x01, // 5⁄ (U+0035 U+2044)
  0x00, 0x36, 0x20, 0x44, 0x01, // 6⁄ (U+0036 U+2044)
  0x00, 0x37, 0x20, 0x44, 0x01, // 7⁄ (U+0037 U+2044)
  0x00, 0x38, 0x20, 0x44, 0x01, // 8⁄ (U+0038 U+2044)
  0x00, 0x39, 0x20, 0x44, 0x01, // 9⁄ (U+0039 U+2044)
  0x00, 0x50, 0x00, 0x2C, 0x01, // P, (U+0050 U+002C)
  0x00, 0x50, 0x00, 0x2E, 0x01, // P. (U+0050 U+002E)
  0x00, 0x50, 0x20, 0x1A, 0x01, // P‚ (U+0050 U+201A)
  0x00, 0x50, 0x20, 0x1E, 0x01, // P„ (U+0050 U+201E)
  0x00, 0x50, 0x20, 0x26, 0x01, // P… (U+0050 U+2026)
  0x00, 0xDE, 0x00, 0x2C, 0x01, // Þ, (U+00DE U+002C)
  0x00, 0xDE, 0x00, 0x2E, 0x01, // Þ. (U+00DE U+002E)
  0x00, 0xDE, 0x20, 0x1A, 0x01, // Þ‚ (U+00DE U+201A)
  0x00, 0xDE, 0x20, 0x1E, 0x01, // Þ„ (U+00DE U+201E)
  0x00, 0xDE, 0x20, 0x26, 0x01, // Þ… (U+00DE U+2026)
  0x20, 0x18, 0x00, 0xC6, 0x01, // ‘Æ (U+2018 U+00C6)
  0x20, 0x19, 0x00, 0xC6, 0x01, // ’Æ (U+2019 U+00C6)
  0x20, 0x1C, 0x00, 0xC6, 0x01, // “Æ (U+201C U+00C6)
  0x20, 0x1D, 0x00, 0xC6, 0x01, // ”Æ (U+201D U+00C6)
  0x20, 0x44, 0x00, 0x30, 0x01, // ⁄0 (U+2044 U+0030)
  0x20, 0x44, 0x00, 0x31, 0x01, // ⁄1 (U+2044 U+0031)
  0x20, 0x44, 0x00, 0x32, 0x01, // ⁄2 (U+2044 U+0032)
  0x20, 0x44, 0x00, 0x33, 0x01, // ⁄3 (U+2044 U+0033)
  0x20, 0x44, 0x00, 0x34, 0x01, // ⁄4 (U+2044 U+0034)
  0x20, 0x44, 0x00, 0x35, 0x01, // ⁄5 (U+2044 U+0035)
  0x20, 0x44, 0x00, 0x36, 0x01, // ⁄6 (U+2044 U+0036)
  0x20, 0x44, 0x00, 0x37, 0x01, // ⁄7 (U+2044 U+0037)
  0x20, 0x44, 0x00, 0x38, 0x01, // ⁄8 (U+2044 U+0038)
  0x20, 0x44, 0x00, 0x39, 0x01, // ⁄9 (U+2044 U+0039)
  
  // Glyph data
  // "!" (U+0021)
  0x89, 0x06, 0x55, 0x55, 0x44, 0x44, 0x32, 0x04, 0x03,
  // """ (U+0022)
  0x84, 0x74, 0x96, 0x28, 0x20, 0x10,
  // "#" (U+0023)
  0x18, 0xB0, 0x82, 0x50, 0x83, 0x45, 0xCB, 0x90, 0x87, 0x09, 0xDD, 0x82, 0x58, 0x03, 0x48, 0x10,
  // "$" (U+0024)
  0x18, 0x94, 0x52, 0x05, 0xDB, 0x29, 0x51, 0x03, 0xD4, 0x28, 0x90, 0x5A, 0x31, 0x56, 0x56, 0xDA,
  0x20, 0x22,
  // "%" (U+0025)
  0x89, 0x04, 0xC0, 0x62, 0x08, 0x44, 0x82, 0x82, 0x83, 0x66, 0x28, 0xA6, 0x84, 0xA5, 0x90, 0x3B,
  0x98, 0x34, 0x01, 0x68, 0x35, 0x06, 0x15, 0xC1,
  // "&" (U+0026)
  0x10, 0xC0, 0x92, 0x81, 0x36, 0x92, 0x81, 0x18, 0x93, 0x0D, 0x05, 0x28, 0x95, 0x76, 0xA9, 0x0A,
  0x06, 0xB0, 0x5C, 0xAA, 0x20,
  // "'" (U+0027)
  0x82, 0x73, 0x62,
  // "(" (U+0028)
  0x18, 0x95, 0x93, 0x77, 0x39, 0x19, 0x17, 0x33, 0x60, 0x90,
  // ")" (U+0029)
  0x89, 0x67, 0x21, 0x80, 0xA0, 0xA0, 0xA0, 0xA1, 0x87, 0x20,
  // "*" (U+002A)
  0x18, 0x90, 0x81, 0x06, 0xCA, 0x21, 0x98, 0x20, 0x10, 0x21,
  // "+" (U+002B)
  0x18, 0x90, 0x62, 0x08, 0xDC, 0x50, 0x62, 0x20, 0x60, 0x21,
  // "," (U+002C)
  0x18, 0x21, 0x64, 0x81,
  // "-" (U+002D)
  0x08, 0x0B,
  // "." (U+002E)
  0x04, 0x03,
  // "/" (U+002F)
  0x28, 0x97, 0x90, 0x36, 0x08, 0x10, 0x90, 0x18, 0x06, 0x30, 0x92,
  // "0" (U+0030)
  0x8B, 0x11, 0xBA, 0x06, 0x37, 0x39, 0x14, 0x5A, 0x04, 0x69, 0x14, 0x57, 0x37, 0x31, 0xCA, 0x10,
  // "1" (U+0031)
  0x18, 0xA2, 0x77, 0x39, 0x70, 0x27, 0x02, 0x70, 0x27, 0x02, 0x70, 0x27,
  // "2" (U+0032)
  0x86, 0x5B, 0xA0, 0x10, 0x82, 0x20, 0x80, 0x22, 0x0A, 0x28, 0x37, 0x30, 0x28, 0x28, 0x2A, 0xCB,
  0x40,
  // "3" (U+0033)
  0x86, 0x5B, 0xB0, 0x10, 0x83, 0x28, 0x39, 0x10, 0xC9, 0x30, 0x70, 0x42, 0x83, 0x74, 0x8B, 0xA1,
  // "4" (U+0034)
  0x20, 0xD2, 0x05, 0x0D, 0x28, 0x95, 0x9A, 0x02, 0x6A, 0x08, 0x1A, 0x0A, 0xAD, 0x62, 0x0A, 0x10,
  // "5" (U+0035)
  0x84, 0x5C, 0xB0, 0x63, 0x20, 0x60, 0x22, 0x81, 0x6B, 0xA3, 0x06, 0x04, 0x28, 0x36, 0x46, 0xBA,
  0x10,
  // "6" (U+0036)
  0x18, 0x39, 0xC1, 0x47, 0x20, 0x80, 0x32, 0x89, 0x59, 0x8A, 0x09, 0x35, 0x56, 0x34, 0x51, 0xBB,
  0x10,
  // "7" (U+0037)
  0x82, 0x8B, 0xC6, 0x20, 0x70, 0x32, 0x0A, 0x20, 0x10, 0x92, 0x06, 0x04, 0x20, 0xA3, 0x0A, 0x20,
  // "8" (U+0038)
  0x8B, 0x22, 0xCB, 0x07, 0x36, 0x44, 0x69, 0x10, 0xC9, 0x08, 0x27, 0x4A, 0x14, 0x63, 0xCB, 0x10,
  // "9" (U+0039)
  0x8A, 0x21, 0xCA, 0x08, 0x27, 0x39, 0x05, 0x58, 0x27, 0x52, 0xBA, 0x42, 0x83, 0x90, 0x4B, 0x61,
  // ":" (U+003A)
  0x04, 0x03, 0x60, 0x40, 0x30,
  // ";" (U+003B)
  0x04, 0x03, 0x68, 0x16, 0x38, 0x10,
  // "<" (U+003C)
  0x28, 0x73, 0x42, 0x86, 0x06, 0x82, 0x30, 0x70, 0x40,
  // "=" (U+003D)
  0x82, 0x8B, 0xB5, 0x48, 0x28, 0xBB, 0x50,
  // ">" (U+003E)
  0x05, 0x01, 0x28, 0x90, 0x17, 0x71, 0x03, 0x93, 0x65, 0x20,
  // "?" (U+003F)
  0x89, 0x49, 0xC4, 0x01, 0x90, 0x27, 0x09, 0x10, 0x82, 0x82, 0x20, 0x25, 0x10,
  // "@" (U+0040)
  0x18, 0x54, 0xBB, 0x50, 0x1A, 0x28, 0xB2, 0x91, 0x53, 0xAC, 0x44, 0x83, 0x68, 0x25, 0x83, 0x5A,
  0x44, 0x72, 0xB6, 0xB0, 0x29, 0x58, 0x15, 0xBA, 0x20,
  // "A" (U+0041)
  0x10, 0x70, 0x82, 0x00, 0x92, 0x89, 0x6A, 0x90, 0x27, 0x73, 0x6C, 0xB7, 0xA1, 0x0A, 0xB2, 0x0B,
  // "B" (U+0042)
  0x8B, 0x25, 0xCC, 0x45, 0x50, 0xA5, 0x51, 0x95, 0xCD, 0x35, 0x50, 0xB5, 0x50, 0xB5, 0xCC, 0x50,
  // "C" (U+0043)
  0x18, 0x38, 0xB8, 0x38, 0x20, 0x70, 0x32, 0x08, 0x02, 0x20, 0x70, 0x32, 0x04, 0x09, 0x38, 0x19,
  0xC7,
  // "D" (U+0044)
  0x8C, 0x05, 0xCC, 0x40, 0x55, 0x0B, 0x05, 0x50, 0x91, 0x55, 0x08, 0x35, 0x50, 0x91, 0x55, 0x0B,
  0x05, 0xCC, 0x31,
  // "E" (U+0045)
  0x84, 0x5C, 0xB2, 0x55, 0x20, 0x05, 0x28, 0x45, 0xCB, 0x05, 0x52, 0x00, 0x52, 0x82, 0x5C, 0xB2,
  // "F" (U+0046)
  0x84, 0x5C, 0xB2, 0x55, 0x20, 0x05, 0x28, 0x45, 0xCB, 0x05, 0x52, 0x00, 0x52, 0x00, 0x52,
  // "G" (U+0047)
  0x18, 0x47, 0xCB, 0x13, 0x93, 0x07, 0x03, 0x38, 0xA2, 0x82, 0x3C, 0x46, 0x30, 0x54, 0x38, 0x05,
  0x40, 0x8C, 0xC3,
  // "H" (U+0048)
  0x8C, 0x15, 0x50, 0x81, 0x55, 0x08, 0x15, 0x50, 0x81, 0x5C, 0xBD, 0x15, 0x50, 0x81, 0x55, 0x08,
  0x15, 0x50, 0x81,
  // "I" (U+0049)
  0x8A, 0x28, 0xD1, 0x28, 0x02, 0x80, 0x28, 0x02, 0x80, 0x28, 0x07, 0xC1,
  // "J" (U+004A)
  0x18, 0xA4, 0x64, 0x06, 0x40, 0x64, 0x06, 0x40, 0x64, 0x06, 0x40, 0x74, 0x5B, 0x10,
  // "K" (U+004B)
  0x8B, 0x25, 0x51, 0x95, 0x59, 0x25, 0x78, 0x05, 0xD6, 0x05, 0x6B, 0x05, 0x56, 0x55, 0x50, 0xB0,
  // "L" (U+004C)
  0x00, 0x52, 0x00, 0x52, 0x00, 0x52, 0x00, 0x52, 0x00, 0x52, 0x00, 0x52, 0x82, 0x5C, 0xA2,
  // "M" (U+004D)
  0x05, 0x0B, 0x28, 0x28, 0x85, 0xD2, 0x8B, 0x6A, 0x85, 0xA4, 0x1A, 0x85, 0x68, 0x56, 0x85, 0x49,
  0x82, 0x85, 0x49, 0x91, 0x85, 0x45, 0x81, 0x80,
  // "N" (U+004E)
  0x8C, 0x15, 0xA0, 0x45, 0x5D, 0x14, 0x55, 0x87, 0x45, 0x54, 0xB4, 0x55, 0x47, 0x85, 0x54, 0x1D,
  0x55, 0x40, 0xA5,
  // "O" (U+004F)
  0x18, 0xB7, 0x9B, 0x90, 0x47, 0x08, 0x37, 0x30, 0x46, 0x82, 0x03, 0x77, 0x30, 0x46, 0x47, 0x08,
  0x30, 0x9C, 0x91,
  // "P" (U+0050)
  0x8A, 0x45, 0xCB, 0x25, 0x53, 0x85, 0x51, 0x95, 0x54, 0x75, 0xCA, 0x05, 0x52, 0x00, 0x52,
  // "Q" (U+0051)
  0x18, 0xB7, 0x9B, 0x80, 0x47, 0x08, 0x37, 0x30, 0x46, 0x82, 0x03, 0x77, 0x30, 0x47, 0x47, 0x08,
  0x30, 0x9C, 0xA3, 0x01, 0x0A, 0x40, 0x50, 0x10,
  // "R" (U+0052)
  0x8B, 0x25, 0xCC, 0x35, 0x52, 0x95, 0x53, 0x85, 0xCC, 0x15, 0x5A, 0x05, 0x55, 0x65, 0x50, 0xB0,
  // "S" (U+0053)
  0x84, 0x2B, 0xC1, 0x82, 0x20, 0x70, 0x53, 0x0A, 0x08, 0x30, 0x90, 0x32, 0x83, 0x73, 0x8B, 0x91,
  // "T" (U+0054)
  0x85, 0xAE, 0xB4, 0x09, 0x12, 0x09, 0x01, 0x20, 0x90, 0x12, 0x09, 0x01, 0x20, 0x90, 0x12, 0x09,
  0x01, 0x10,
  // "U" (U+0055)
  0x8B, 0x36, 0x40, 0x91, 0x64, 0x09, 0x16, 0x40, 0x91, 0x64, 0x09, 0x16, 0x40, 0x91, 0x46, 0x0B,
  0x28, 0x1A, 0xB7, 0x10,
  // "V" (U+0056)
  0x0B, 0x28, 0x96, 0xBA, 0x02, 0x86, 0x35, 0x53, 0x78, 0x10, 0xAA, 0x20, 0x09, 0x20, 0x80, 0x61,
  // "W" (U+0057)
  0x8C, 0x0A, 0x04, 0x80, 0x81, 0xA0, 0x7A, 0x0A, 0x07, 0x29, 0x90, 0xA0, 0x45, 0x97, 0x38, 0x01,
  0x98, 0x59, 0x62, 0x83, 0xC5, 0x2D, 0x32, 0x82, 0xB3, 0x0E, 0x20,
  // "X" (U+0058)
  0x85, 0x91, 0x55, 0x36, 0xA2, 0x0A, 0x08, 0x20, 0x90, 0x52, 0x89, 0x1A, 0x90, 0x55, 0x90, 0xA0,
  0x46,
  // "Y" (U+0059)
  0x89, 0x1B, 0x05, 0x57, 0x4B, 0x12, 0xCB, 0x20, 0xD0, 0x62, 0x09, 0x02, 0x20, 0x80, 0x12, 0x08,
  0x01, 0x10,
  // "Z" (U+005A)
  0x82, 0x8B, 0xE1, 0x20, 0xB2, 0x04, 0x06, 0x28, 0x3A, 0x10, 0x19, 0x20, 0x60, 0x42, 0x0F, 0xB0,
  0x20,
  // "[" (U+005B)
  0x8A, 0x66, 0xC3, 0x63, 0x06, 0x30, 0x63, 0x06, 0x30, 0x63, 0x06, 0x30, 0x5C, 0x30,
  // "\" (U+005C)
  0x09, 0x28, 0x36, 0x30, 0x18, 0x20, 0x92, 0x83, 0x81, 0x03, 0x62, 0x09,
  // "]" (U+005D)
  0x89, 0x68, 0xD0, 0x90, 0x90, 0x90, 0x90, 0x90, 0x98, 0xC0,
  // "^" (U+005E)
  0x10, 0x30, 0x12, 0x89, 0x19, 0x80, 0x26, 0x80, 0x80, 0x27,
  // "_" (U+005F)
  0x0F, 0x80, 0x40,
  // "`" (U+0060)
  0x82, 0x41, 0x18,
  // "a" (U+0061)
  0x81, 0x2B, 0xB3, 0x89, 0x49, 0x13, 0xBD, 0x1A, 0x19, 0x16, 0xBA, 0x10,
  // "b" (U+0062)
  0x06, 0x03, 0x20, 0x60, 0x32, 0x8A, 0x26, 0xAC, 0x36, 0x51, 0x96, 0x30, 0xA6, 0x51, 0x96, 0x9C,
  0x30,
  // "c" (U+0063)
  0x89, 0x51, 0xB9, 0x73, 0x09, 0x10, 0x73, 0x02, 0xC9,
  // "d" (U+0064)
  0x20, 0x20, 0x72, 0x8A, 0x42, 0x72, 0xC9, 0x78, 0x24, 0x79, 0x12, 0x78, 0x24, 0x72, 0xC8, 0x70,
  // "e" (U+0065)
  0x89, 0x42, 0xBA, 0x07, 0x26, 0x39, 0xBC, 0x47, 0x22, 0x82, 0x1B, 0xB1,
  // "f" (U+0066)
  0x8A, 0x21, 0xC4, 0x45, 0x0A, 0xD1, 0x55, 0x05, 0x50, 0x55, 0x05, 0x51,
  // "g" (U+0067)
  0x8A, 0x22, 0xC8, 0x77, 0x24, 0x79, 0x12, 0x78, 0x24, 0x72, 0xC9, 0x72, 0x84, 0x46, 0x4B, 0xB1,
  // "h" (U+0068)
  0x06, 0x03, 0x20, 0x60, 0x32, 0x8A, 0x26, 0xAC, 0x26, 0x53, 0x76, 0x32, 0x76, 0x32, 0x76, 0x32,
  0x70,
  // "i" (U+0069)
  0x04, 0x02, 0x28, 0x90, 0x63, 0x63, 0x63, 0x63, 0x63,
  // "j" (U+006A)
  0x10, 0x40, 0x24, 0x8A, 0x26, 0x30, 0x63, 0x06, 0x30, 0x63, 0x06, 0x30, 0x73, 0x2C, 0x10,
  // "k" (U+006B)
  0x06, 0x03, 0x20, 0x60, 0x32, 0x8A, 0x26, 0x39, 0x16, 0x77, 0x06, 0xD5, 0x06, 0x4A, 0x06, 0x37,
  0x30,
  // "l" (U+006C)
  0x89, 0x46, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x30,
  // "m" (U+006D)
  0x8B, 0x46, 0x8B, 0x6C, 0x36, 0x55, 0x73, 0x76, 0x34, 0x52, 0x86, 0x34, 0x52, 0x86, 0x34, 0x52,
  0x80,
  // "n" (U+006E)
  0x8A, 0x26, 0x8C, 0x26, 0x53, 0x76, 0x32, 0x76, 0x32, 0x76, 0x32, 0x70,
  // "o" (U+006F)
  0x8A, 0x22, 0xBB, 0x17, 0x33, 0x69, 0x11, 0x87, 0x23, 0x61, 0xBB, 0x10,
  // "p" (U+0070)
  0x8A, 0x46, 0x9C, 0x36, 0x51, 0x96, 0x30, 0xA6, 0x51, 0x96, 0xAC, 0x36, 0x32, 0x06, 0x03, 0x20,
  // "q" (U+0071)
  0x8A, 0x22, 0xC8, 0x77, 0x24, 0x79, 0x12, 0x78, 0x24, 0x72, 0xC9, 0x72, 0x02, 0x07, 0x20, 0x20,
  0x70,
  // "r" (U+0072)
  0x89, 0x46, 0x96, 0x66, 0x06, 0x30, 0x63, 0x06, 0x31,
  // "s" (U+0073)
  0x87, 0x5C, 0x79, 0x10, 0x19, 0x32, 0x82, 0xA8, 0xC6,
  // "t" (U+0074)
  0x8A, 0x04, 0x40, 0xAC, 0x16, 0x40, 0x64, 0x06, 0x40, 0x3B, 0x10,
  // "u" (U+0075)
  0x8A, 0x27, 0x33, 0x77, 0x33, 0x77, 0x33, 0x76, 0x34, 0x72, 0xA8, 0x70,
  // "v" (U+0076)
  0x89, 0x5A, 0x08, 0x29, 0x1A, 0x05, 0x49, 0x01, 0xB6, 0x20, 0xD0, 0x21,
  // "w" (U+0077)
  0x8A, 0x5A, 0x0C, 0x18, 0x19, 0x1C, 0x49, 0x06, 0x76, 0x79, 0x03, 0xC2, 0xA7, 0x28, 0x2E, 0x0A,
  0x41,
  // "x" (U+0078)
  0x89, 0x58, 0x1A, 0x2A, 0x70, 0xC2, 0x29, 0x89, 0x19,
  // "y" (U+0079)
  0x89, 0x1A, 0x08, 0x28, 0x1A, 0x04, 0x69, 0x20, 0xC0, 0x52, 0x0B, 0x01, 0x20, 0xA2, 0x0B, 0x05,
  0x20,
  // "z" (U+007A)
  0x89, 0x57, 0xC8, 0x07, 0x30, 0xA0, 0x54, 0x0B, 0xB7,
  // "{" (U+007B)
  0x18, 0x27, 0x70, 0xA2, 0x0A, 0x28, 0x2A, 0x09, 0x62, 0x0A, 0x20, 0xA2, 0x00, 0x70,
  // "|" (U+007C)
  0x8A, 0x07, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x10,
  // "}" (U+007D)
  0x09, 0x06, 0x20, 0xA2, 0x0A, 0x20, 0xA2, 0x82, 0x78, 0x0A, 0x28, 0x2A, 0x08, 0x61,
  // "~" (U+007E)
  0x82, 0x8B, 0xB5,
  // "¡" (U+00A1)
  0x89, 0x24, 0x34, 0x34, 0x45, 0x46, 0x56, 0x50,
  // "¢" (U+00A2)
  0x18, 0x73, 0x80, 0x1A, 0x30, 0x45, 0x20, 0x05, 0x20, 0x30, 0x83, 0x84, 0xBC, 0x10, 0x15, 0x10,
  // "£" (U+00A3)
  0x18, 0x39, 0xB3, 0x0A, 0x20, 0x10, 0x92, 0x84, 0x8E, 0x90, 0x19, 0x20, 0x20, 0x72, 0x82, 0x9C,
  0xB5,
  // "¤" (U+00A4)
  0x89, 0x65, 0xBB, 0x93, 0x40, 0x83, 0x50, 0x85, 0xAB, 0x90,
  // "¥" (U+00A5)
  0x89, 0x19, 0x15, 0x55, 0x7A, 0x11, 0xCC, 0x28, 0x94, 0xC8, 0x03, 0xCA, 0x15, 0xDC, 0x20, 0x73,
  0x10,
  // "¦" (U+00A6)
  0x86, 0x71, 0x71, 0x71, 0x71, 0x48, 0x47, 0x17, 0x17, 0x10,
  // "§" (U+00A7)
  0x89, 0x54, 0xC8, 0x73, 0x04, 0xB5, 0x81, 0x91, 0xA8, 0x28, 0x2A, 0x7C, 0x70,
  // "¨" (U+00A8)
  0x81, 0x54, 0x10,
  // "©" (U+00A9)
  0x18, 0x21, 0x76, 0x52, 0x89, 0x01, 0x75, 0x95, 0x70, 0x61, 0x92, 0x83, 0x51, 0x61, 0x72, 0x83,
  0x33, 0x61, 0x92, 0x86, 0x51, 0x07, 0x58, 0x47, 0x28, 0x21, 0x66, 0x52,
  // "ª" (U+00AA)
  0x87, 0x39, 0x14, 0x92, 0x79, 0x20,
  // "«" (U+00AB)
  0x18, 0x95, 0x62, 0x37, 0x5A, 0x04, 0x79, 0x10, 0x41, 0x20,
  // "¬" (U+00AC)
  0x82, 0x8B, 0xB5, 0x20, 0x10, 0x62, 0x01, 0x05,
  // "®" (U+00AE)
  0x18, 0x21, 0x76, 0x52, 0x8C, 0x01, 0x78, 0x94, 0x70, 0x60, 0x93, 0x65, 0x16, 0x0A, 0xB1, 0x33,
  0x60, 0x94, 0x45, 0x10, 0x73, 0x05, 0x72, 0x82, 0x16, 0x65, 0x20,
  // "¯" (U+00AF)
  0x0F, 0x90, 0x60,
  // "°" (U+00B0)
  0x87, 0x38, 0x37, 0x08, 0x38, 0x30,
  // "±" (U+00B1)
  0x18, 0x90, 0x62, 0x08, 0xDC, 0x50, 0x62, 0x28, 0x56, 0x20, 0x8B, 0xB5,
  // "²" (U+00B2)
  0x05, 0x07, 0x28, 0x66, 0x12, 0x60, 0x87, 0x10,
  // "³" (U+00B3)
  0x83, 0x47, 0x12, 0xA2, 0x82, 0x43, 0x68, 0x10,
  // "´" (U+00B4)
  0x18, 0x15, 0x63,
  // "µ" (U+00B5)
  0x8A, 0x46, 0x32, 0x76, 0x32, 0x76, 0x32, 0x76, 0x44, 0x76, 0xC9, 0x76, 0x32, 0x06, 0x03, 0x20,
  // "¶" (U+00B6)
  0x8A, 0x22, 0xDD, 0x87, 0xF7, 0x77, 0xF7, 0x76, 0xF7, 0x71, 0x97, 0x72, 0x00, 0x72, 0x00, 0x72,
  0x00, 0x72, 0x00, 0x10,
  // "·" (U+00B7)
  0x04, 0x03,
  // "¸" (U+00B8)
  0x84, 0x10, 0x44, 0x73,
  // "¹" (U+00B9)
  0x18, 0x54, 0x49, 0x08, 0x08,
  // "º" (U+00BA)
  0x87, 0x68, 0x28, 0x25, 0x47, 0x10,
  // "»" (U+00BB)
  0x89, 0x55, 0x15, 0x01, 0x97, 0x33, 0x89, 0x23, 0x03, 0x10,
  // "¼" (U+00BC)
  0x04, 0x0A, 0x28, 0x58, 0x03, 0x80, 0x62, 0x28, 0x18, 0x08, 0x38, 0x38, 0x44, 0x83, 0x28, 0x92,
  0x83, 0x83, 0x02, 0x67, 0xA7, 0x08, 0x20, 0x40, 0x30,
  // "½" (U+00BD)
  0x89, 0x04, 0xA0, 0x26, 0x04, 0x80, 0x73, 0x81, 0x81, 0x73, 0x83, 0x87, 0x38, 0x42, 0x08, 0x28,
  0x93, 0x70, 0x62, 0x07, 0x10, 0x60, 0x49, 0x50,
  // "¾" (U+00BE)
  0x06, 0x08, 0x20, 0x62, 0x87, 0x62, 0x26, 0x02, 0xB0, 0x83, 0x89, 0x15, 0x57, 0x66, 0x68, 0x82,
  0x96, 0x28, 0x90, 0x85, 0x99, 0x06, 0x20, 0x16,
  // "¿" (U+00BF)
  0x18, 0x25, 0x20, 0x22, 0x89, 0x48, 0x01, 0x90, 0x82, 0x09, 0x10, 0x4C, 0x90,
  // "À" (U+00C0)
  0x10, 0x40, 0x12, 0x01, 0x08, 0x20, 0x70, 0x82, 0x00, 0x92, 0x89, 0x6A, 0x90, 0x27, 0x73, 0x6C,
  0xB7, 0xA1, 0x0A, 0xB2, 0x0B,
  // "Á" (U+00C1)
  0x20, 0x52, 0x06, 0x03, 0x20, 0x70, 0x82, 0x00, 0x92, 0x89, 0x6A, 0x90, 0x27, 0x73, 0x6C, 0xB7,
  0xA1, 0x0A, 0xB2, 0x0B,
  // "Â" (U+00C2)
  0x20, 0x62, 0x84, 0x56, 0x40, 0x78, 0x20, 0x09, 0x28, 0x96, 0xA9, 0x02, 0x77, 0x36, 0xCB, 0x7A,
  0x10, 0xAB, 0x20, 0xB0,
  // "Ã" (U+00C3)
  0x85, 0x48, 0x60, 0x4B, 0xE2, 0x00, 0x92, 0x89, 0x6A, 0x90, 0x27, 0x73, 0x6C, 0xB7, 0xA1, 0x0A,
  0xB2, 0x0B,
  // "Ä" (U+00C4)
  0x18, 0x45, 0x41, 0x07, 0x82, 0x00, 0x92, 0x89, 0x6A, 0x90, 0x27, 0x73, 0x6C, 0xB7, 0xA1, 0x0A,
  0xB2, 0x0B,
  // "Å" (U+00C5)
  0x10, 0xC0, 0xE2, 0x0D, 0x92, 0x89, 0x6A, 0x90, 0x27, 0x73, 0x6C, 0xB7, 0xA1, 0x0A, 0xB2, 0x0B,
  // "Æ" (U+00C6)
  0x18, 0x72, 0xED, 0xB1, 0x06, 0x85, 0x38, 0x1A, 0x55, 0x38, 0x7A, 0x4D, 0xB0, 0x4D, 0xC5, 0x28,
  0x29, 0x24, 0x52, 0x84, 0xB0, 0x4D, 0xB1,
  // "Ç" (U+00C7)
  0x18, 0x38, 0xB8, 0x38, 0x20, 0x70, 0x32, 0x08, 0x02, 0x20, 0x70, 0x32, 0x04, 0x09, 0x38, 0x19,
  0xD7, 0x20, 0x04, 0x20, 0x70, 0x30,
  // "È" (U+00C8)
  0x10, 0x40, 0x12, 0x87, 0x18, 0x05, 0xCB, 0x25, 0x52, 0x00, 0x52, 0x84, 0x5C, 0xB0, 0x55, 0x20,
  0x05, 0x28, 0x25, 0xCB, 0x20,
  // "É" (U+00C9)
  0x20, 0x52, 0x87, 0x63, 0x05, 0xCB, 0x25, 0x52, 0x00, 0x52, 0x84, 0x5C, 0xB0, 0x55, 0x20, 0x05,
  0x28, 0x25, 0xCB, 0x20,
  // "Ê" (U+00CA)
  0x10, 0x62, 0x89, 0x05, 0x64, 0x05, 0xCB, 0x25, 0x52, 0x00, 0x52, 0x84, 0x5C, 0xB0, 0x55, 0x20,
  0x05, 0x28, 0x25, 0xCB, 0x20,
  // "Ë" (U+00CB)
  0x18, 0x75, 0x41, 0x5C, 0xB2, 0x55, 0x20, 0x05, 0x28, 0x45, 0xCB, 0x05, 0x52, 0x00, 0x52, 0x82,
  0x5C, 0xB2,
  // "Ì" (U+00CC)
  0x8B, 0x04, 0x10, 0x18, 0x08, 0xD1, 0x28, 0x02, 0x80, 0x28, 0x02, 0x80, 0x28, 0x07, 0xC1,
  // "Í" (U+00CD)
  0x28, 0xA6, 0x50, 0x63, 0x8D, 0x12, 0x80, 0x28, 0x02, 0x80, 0x28, 0x02, 0x80, 0x7C, 0x10,
  // "Î" (U+00CE)
  0x18, 0xA7, 0x60, 0x56, 0x48, 0xD1, 0x28, 0x02, 0x80, 0x28, 0x02, 0x80, 0x28, 0x07, 0xC1,
  // "Ï" (U+00CF)
  0x8A, 0x55, 0x41, 0x8D, 0x12, 0x80, 0x28, 0x02, 0x80, 0x28, 0x02, 0x80, 0x7C, 0x10,
  // "Ð" (U+00D0)
  0x8C, 0x05, 0xDC, 0x40, 0x55, 0x0B, 0x05, 0x50, 0x91, 0xAD, 0x38, 0x35, 0x50, 0x91, 0x55, 0x0B,
  0x05, 0xDC, 0x31,
  // "Ñ" (U+00D1)
  0x18, 0xC5, 0x48, 0x60, 0x5F, 0x4B, 0x55, 0xD1, 0x45, 0x58, 0x74, 0x55, 0x4B, 0x45, 0x54, 0x78,
  0x55, 0x41, 0xD5, 0x54, 0x0A, 0x50,
  // "Ò" (U+00D2)
  0x10, 0x40, 0x13, 0x01, 0x08, 0x38, 0xB7, 0x9B, 0x90, 0x47, 0x08, 0x37, 0x30, 0x46, 0x82, 0x03,
  0x77, 0x30, 0x46, 0x47, 0x08, 0x30, 0x9C, 0x91,
  // "Ó" (U+00D3)
  0x30, 0x53, 0x06, 0x03, 0x28, 0xB7, 0x9B, 0x90, 0x47, 0x08, 0x37, 0x30, 0x46, 0x82, 0x03, 0x77,
  0x30, 0x46, 0x47, 0x08, 0x30, 0x9C, 0x91,
  // "Ô" (U+00D4)
  0x20, 0x63, 0x81, 0x56, 0x42, 0x8B, 0x79, 0xB9, 0x04, 0x70, 0x83, 0x73, 0x04, 0x68, 0x20, 0x37,
  0x73, 0x04, 0x64, 0x70, 0x83, 0x09, 0xC9, 0x10,
  // "Õ" (U+00D5)
  0x18, 0x14, 0x86, 0x20, 0xEA, 0x18, 0xB3, 0x47, 0x08, 0x37, 0x30, 0x46, 0x82, 0x03, 0x77, 0x30,
  0x46, 0x47, 0x08, 0x30, 0x9C, 0x91,
  // "Ö" (U+00D6)
  0x18, 0x15, 0x41, 0x28, 0xB7, 0x9B, 0x90, 0x47, 0x08, 0x37, 0x30, 0x46, 0x82, 0x03, 0x77, 0x30,
  0x46, 0x47, 0x08, 0x30, 0x9C, 0x91,
  // "×" (U+00D7)
  0x02, 0x28, 0x93, 0x13, 0x89, 0x10, 0xA8, 0x04, 0x13, 0x20,
  // "Ø" (U+00D8)
  0x18, 0xC1, 0x9B, 0xB3, 0x47, 0x0D, 0x27, 0x34, 0x86, 0x82, 0x83, 0x77, 0x74, 0x46, 0x3C, 0x08,
  0x33, 0xCB, 0x80, 0x14,
  // "Ù" (U+00D9)
  0x10, 0x40, 0x13, 0x01, 0x08, 0x28, 0xB3, 0x64, 0x09, 0x16, 0x40, 0x91, 0x64, 0x09, 0x16, 0x40,
  0x91, 0x64, 0x09, 0x14, 0x60, 0xB2, 0x81, 0xAB, 0x71,
  // "Ú" (U+00DA)
  0x30, 0x53, 0x8B, 0x66, 0x30, 0x64, 0x09, 0x16, 0x40, 0x91, 0x64, 0x09, 0x16, 0x40, 0x91, 0x64,
  0x09, 0x14, 0x60, 0xB2, 0x81, 0xAB, 0x71,
  // "Û" (U+00DB)
  0x20, 0x63, 0x8B, 0x75, 0x64, 0x06, 0x40, 0x91, 0x64, 0x09, 0x16, 0x40, 0x91, 0x64, 0x09, 0x16,
  0x40, 0x91, 0x46, 0x0B, 0x28, 0x1A, 0xB7, 0x10,
  // "Ü" (U+00DC)
  0x18, 0xB7, 0x54, 0x10, 0x64, 0x09, 0x16, 0x40, 0x91, 0x64, 0x09, 0x16, 0x40, 0x91, 0x64, 0x09,
  0x14, 0x60, 0xB2, 0x81, 0xAB, 0x71,
  // "Ý" (U+00DD)
  0x20, 0x52, 0x89, 0x46, 0x30, 0xB0, 0x55, 0x74, 0xB1, 0x2C, 0xB2, 0x0D, 0x06, 0x20, 0x90, 0x22,
  0x08, 0x01, 0x20, 0x80, 0x11,
  // "Þ" (U+00DE)
  0x00, 0x52, 0x8A, 0x45, 0xCA, 0x15, 0x54, 0x75, 0x51, 0x85, 0x54, 0x65, 0xDA, 0x05, 0x52,
  // "ß" (U+00DF)
  0x8B, 0x21, 0xBC, 0x26, 0x45, 0x46, 0x3A, 0x06, 0x4A, 0x06, 0x36, 0x66, 0x30, 0xA6, 0x7C, 0x70,
  // "à" (U+00E0)
  0x10, 0x40, 0x12, 0x01, 0x08, 0x58, 0x12, 0xBB, 0x38, 0x94, 0x91, 0x3B, 0xD1, 0xA1, 0x91, 0x6B,
  0xA1,
  // "á" (U+00E1)
  0x20, 0x52, 0x06, 0x03, 0x58, 0x12, 0xBB, 0x38, 0x94, 0x91, 0x3B, 0xD1, 0xA1, 0x91, 0x6B, 0xA1,
  // "â" (U+00E2)
  0x10, 0x62, 0x81, 0x56, 0x45, 0x81, 0x2B, 0xB3, 0x89, 0x49, 0x13, 0xBD, 0x1A, 0x19, 0x16, 0xBA,
  0x10,
  // "ã" (U+00E3)
  0x89, 0x14, 0x86, 0x04, 0x46, 0x02, 0xBB, 0x38, 0x94, 0x91, 0x3B, 0xD1, 0xA1, 0x91, 0x6B, 0xA1,
  // "ä" (U+00E4)
  0x18, 0x15, 0x41, 0x48, 0x12, 0xBB, 0x38, 0x94, 0x91, 0x3B, 0xD1, 0xA1, 0x91, 0x6B, 0xA1,
  // "å" (U+00E5)
  0x10, 0x40, 0x62, 0x84, 0x46, 0x02, 0xBB, 0x38, 0x94, 0x91, 0x3B, 0xD1, 0xA1, 0x91, 0x6B, 0xA1,
  // "æ" (U+00E6)
  0x83, 0x3B, 0x9B, 0xA3, 0x89, 0x49, 0x36, 0x33, 0xBD, 0xCC, 0x4A, 0x1A, 0x32, 0x84, 0x6B, 0x6B,
  0xB1,
  // "ç" (U+00E7)
  0x8A, 0x31, 0xB9, 0x73, 0x09, 0x10, 0x73, 0x02, 0xD9, 0x04, 0x40, 0x73,
  // "è" (U+00E8)
  0x10, 0x40, 0x12, 0x01, 0x08, 0x58, 0x94, 0x2B, 0xA0, 0x72, 0x63, 0x9B, 0xC4, 0x72, 0x28, 0x21,
  0xBB, 0x10,
  // "é" (U+00E9)
  0x20, 0x52, 0x06, 0x03, 0x58, 0x94, 0x2B, 0xA0, 0x72, 0x63, 0x9B, 0xC4, 0x72, 0x28, 0x21, 0xBB,
  0x10,
  // "ê" (U+00EA)
  0x10, 0x62, 0x81, 0x56, 0x45, 0x89, 0x42, 0xBA, 0x07, 0x26, 0x39, 0xBC, 0x47, 0x22, 0x82, 0x1B,
  0xB1,
  // "ë" (U+00EB)
  0x18, 0x15, 0x41, 0x48, 0x94, 0x2B, 0xA0, 0x72, 0x63, 0x9B, 0xC4, 0x72, 0x28, 0x21, 0xBB, 0x10,
  // "ì" (U+00EC)
  0x82, 0x41, 0x18, 0x28, 0x90, 0x63, 0x63, 0x63, 0x63, 0x63,
  // "í" (U+00ED)
  0x18, 0x15, 0x63, 0x28, 0x90, 0x63, 0x63, 0x63, 0x63, 0x63,
  // "î" (U+00EE)
  0x18, 0x36, 0x05, 0x64, 0x48, 0x94, 0x63, 0x06, 0x30, 0x63, 0x06, 0x30, 0x63,
  // "ï" (U+00EF)
  0x81, 0x54, 0x13, 0x89, 0x46, 0x30, 0x63, 0x06, 0x30, 0x63, 0x06, 0x31,
  // "ð" (U+00F0)
  0x10, 0x03, 0x20, 0x0A, 0x28, 0xA5, 0x19, 0x11, 0xBC, 0x57, 0x34, 0x89, 0x11, 0x87, 0x33, 0x61,
  0xBB, 0x10,
  // "ñ" (U+00F1)
  0x8B, 0x24, 0x86, 0x04, 0x46, 0x06, 0x8C, 0x26, 0x53, 0x76, 0x32, 0x76, 0x32, 0x76, 0x32, 0x70,
  // "ò" (U+00F2)
  0x10, 0x40, 0x12, 0x01, 0x08, 0x58, 0xA2, 0x2B, 0xB1, 0x73, 0x36, 0x91, 0x18, 0x72, 0x36, 0x1B,
  0xB1,
  // "ó" (U+00F3)
  0x20, 0x52, 0x06, 0x03, 0x58, 0xA2, 0x2B, 0xB1, 0x73, 0x36, 0x91, 0x18, 0x72, 0x36, 0x1B, 0xB1,
  // "ô" (U+00F4)
  0x20, 0x62, 0x81, 0x56, 0x44, 0x8A, 0x22, 0xBB, 0x17, 0x33, 0x69, 0x11, 0x87, 0x23, 0x61, 0xBB,
  0x10,
  // "õ" (U+00F5)
  0x8B, 0x24, 0x86, 0x04, 0x46, 0x02, 0xBB, 0x17, 0x33, 0x69, 0x11, 0x87, 0x23, 0x61, 0xBB, 0x10,
  // "ö" (U+00F6)
  0x18, 0x15, 0x41, 0x48, 0xA2, 0x2B, 0xB1, 0x73, 0x36, 0x91, 0x18, 0x72, 0x36, 0x1B, 0xB1,
  // "÷" (U+00F7)
  0x18, 0x54, 0x20, 0x8B, 0xB5, 0x50, 0x40, 0x21,
  // "ø" (U+00F8)
  0x38, 0xA4, 0x12, 0xBC, 0x48, 0x29, 0x69, 0x45, 0x87, 0x93, 0x75, 0xCB, 0x12, 0x30,
  // "ù" (U+00F9)
  0x10, 0x40, 0x12, 0x01, 0x08, 0x58, 0xA2, 0x73, 0x37, 0x73, 0x37, 0x73, 0x37, 0x63, 0x47, 0x2A,
  0x87,
  // "ú" (U+00FA)
  0x20, 0x52, 0x06, 0x03, 0x58, 0xA2, 0x73, 0x37, 0x73, 0x37, 0x73, 0x37, 0x63, 0x47, 0x2A, 0x87,
  // "û" (U+00FB)
  0x20, 0x62, 0x81, 0x56, 0x44, 0x8A, 0x27, 0x33, 0x77, 0x33, 0x77, 0x33, 0x76, 0x34, 0x72, 0xA8,
  0x70,
  // "ü" (U+00FC)
  0x18, 0x15, 0x41, 0x48, 0xA2, 0x73, 0x37, 0x73, 0x37, 0x73, 0x37, 0x63, 0x47, 0x2A, 0x87,
  // "ý" (U+00FD)
  0x20, 0x52, 0x06, 0x03, 0x58, 0x91, 0xA0, 0x82, 0x81, 0xA0, 0x46, 0x92, 0x0C, 0x05, 0x20, 0xB0,
  0x12, 0x0A, 0x20, 0xB0, 0x52,
  // "þ" (U+00FE)
  0x06, 0x03, 0x20, 0x60, 0x32, 0x8A, 0x46, 0x9C, 0x36, 0x51, 0x96, 0x30, 0xA6, 0x52, 0x96, 0xAC,
  0x36, 0x32, 0x06, 0x03, 0x20,
  // "ÿ" (U+00FF)
  0x81, 0x54, 0x15, 0x89, 0x1A, 0x08, 0x28, 0x1A, 0x04, 0x69, 0x20, 0xC0, 0x52, 0x0B, 0x01, 0x20,
  0xA2, 0x0B, 0x05, 0x20,
  // "Ā" (U+0100)
  0x18, 0x4D, 0xF3, 0x09, 0x92, 0x89, 0x6A, 0x90, 0x27, 0x73, 0x6C, 0xB7, 0xA1, 0x0A, 0xB2, 0x0B,
  // "ā" (U+0101)
  0x18, 0x46, 0x93, 0x2B, 0xB3, 0x89, 0x49, 0x13, 0xBD, 0x1A, 0x19, 0x16, 0xBA, 0x10,
  // "Ă" (U+0102)
  0x18, 0x90, 0x10, 0x10, 0xBF, 0x20, 0x99, 0x28, 0x96, 0xA9, 0x02, 0x77, 0x36, 0xCB, 0x7A, 0x10,
  0xAB, 0x20, 0xB0,
  // "ă" (U+0103)
  0x18, 0x90, 0x10, 0x10, 0x49, 0x22, 0xBB, 0x38, 0x94, 0x91, 0x3B, 0xD1, 0xA1, 0x91, 0x6B, 0xA1,
  // "Ą" (U+0104)
  0x10, 0x70, 0x82, 0x00, 0x92, 0x89, 0x6A, 0x90, 0x27, 0x73, 0x6C, 0xB7, 0xA1, 0x0A, 0xB2, 0x0C,
  0x20, 0x73, 0x05, 0x04,
  // "ą" (U+0105)
  0x81, 0x2B, 0xB3, 0x89, 0x49, 0x13, 0xBD, 0x1A, 0x19, 0x16, 0xBB, 0x32, 0x07, 0x30, 0x50, 0x40,
  // "Ć" (U+0106)
  0x30, 0x52, 0x86, 0x63, 0x08, 0xB8, 0x38, 0x20, 0x70, 0x32, 0x08, 0x02, 0x20, 0x70, 0x32, 0x04,
  0x09, 0x38, 0x19, 0xC7,
  // "ć" (U+0107)
  0x28, 0x25, 0x06, 0x33, 0x89, 0x51, 0xB9, 0x73, 0x09, 0x10, 0x73, 0x02, 0xC9,
  // "Ĉ" (U+0108)
  0x20, 0x62, 0x87, 0x56, 0x40, 0x8B, 0x83, 0x82, 0x07, 0x03, 0x20, 0x80, 0x22, 0x07, 0x03, 0x20,
  0x40, 0x93, 0x81, 0x9C, 0x70,
  // "ĉ" (U+0109)
  0x18, 0x36, 0x05, 0x64, 0x38, 0x95, 0x1B, 0x97, 0x30, 0x91, 0x07, 0x30, 0x2C, 0x90,
  // "Ċ" (U+010A)
  0x20, 0x62, 0x83, 0x8B, 0x83, 0x82, 0x07, 0x03, 0x20, 0x80, 0x22, 0x07, 0x03, 0x20, 0x40, 0x93,
  0x81, 0x9C, 0x70,
  // "ċ" (U+010B)
  0x10, 0x64, 0x89, 0x51, 0xB9, 0x73, 0x09, 0x10, 0x73, 0x02, 0xC9,
  // "Č" (U+010C)
  0x18, 0x93, 0x30, 0x30, 0x2C, 0x10, 0x8B, 0x83, 0x82, 0x07, 0x03, 0x20, 0x80, 0x22, 0x07, 0x03,
  0x20, 0x40, 0x93, 0x81, 0x9C, 0x70,
  // "č" (U+010D)
  0x84, 0x30, 0x32, 0xC1, 0x38, 0x95, 0x1B, 0x97, 0x30, 0x91, 0x07, 0x30, 0x2C, 0x90,
  // "Ď" (U+010E)
  0x18, 0x13, 0x03, 0x28, 0xC4, 0x2C, 0x10, 0x5C, 0xC4, 0x05, 0x50, 0xB0, 0x55, 0x09, 0x15, 0x50,
  0x83, 0x55, 0x09, 0x15, 0x50, 0xB0, 0x5C, 0xC3, 0x10,
  // "ď" (U+010F)
  0x28, 0x12, 0xE2, 0x28, 0xB1, 0x28, 0x02, 0xC9, 0x70, 0x82, 0x47, 0x09, 0x12, 0x70, 0x82, 0x47,
  0x02, 0xC8, 0x71,
  // "Đ" (U+0110)
  0x8C, 0x05, 0xDC, 0x40, 0x55, 0x0B, 0x05, 0x50, 0x91, 0xAD, 0x38, 0x35, 0x50, 0x91, 0x55, 0x0B,
  0x05, 0xDC, 0x31,
  // "đ" (U+0111)
  0x28, 0xB0, 0x27, 0x03, 0xCD, 0x2C, 0x97, 0x83, 0x47, 0x91, 0x27, 0x83, 0x47, 0x2C, 0x87,
  // "Ē" (U+0112)
  0x05, 0xA0, 0xF5, 0x20, 0x05, 0x28, 0x45, 0xCB, 0x05, 0x52, 0x00, 0x52, 0x82, 0x5C, 0xB2,
  // "ē" (U+0113)
  0x18, 0x97, 0x69, 0x32, 0xBA, 0x07, 0x26, 0x39, 0xBC, 0x47, 0x22, 0x82, 0x1B, 0xB1,
  // "Ĕ" (U+0114)
  0x18, 0x21, 0x01, 0x5A, 0x81, 0x45, 0x52, 0x00, 0x52, 0x84, 0x5C, 0xB0, 0x55, 0x20, 0x05, 0x28,
  0x25, 0xCB, 0x20,
  // "ĕ" (U+0115)
  0x18, 0xA3, 0x10, 0x10, 0x49, 0x22, 0xBA, 0x07, 0x26, 0x39, 0xBC, 0x47, 0x22, 0x82, 0x1B, 0xB1,
  // "Ė" (U+0116)
  0x10, 0x62, 0x84, 0x5C, 0xB2, 0x55, 0x20, 0x05, 0x28, 0x45, 0xCB, 0x05, 0x52, 0x00, 0x52, 0x82,
  0x5C, 0xB2,
  // "ė" (U+0117)
  0x10, 0x66, 0x89, 0x42, 0xBA, 0x07, 0x26, 0x39, 0xBC, 0x47, 0x22, 0x82, 0x1B, 0xB1,
  // "Ę" (U+0118)
  0x84, 0x5C, 0xB2, 0x55, 0x20, 0x05, 0x28, 0x45, 0xCB, 0x05, 0x52, 0x00, 0x52, 0x82, 0x5C, 0xC3,
  0x20, 0x73, 0x05, 0x04,
  // "ę" (U+0119)
  0x89, 0x42, 0xBA, 0x07, 0x26, 0x39, 0xBC, 0x47, 0x22, 0x82, 0x1B, 0xC2, 0x20, 0x73, 0x0C, 0x01,
  // "Ě" (U+011A)
  0x89, 0x43, 0x03, 0x02, 0xC1, 0x05, 0xCB, 0x25, 0x52, 0x00, 0x52, 0x84, 0x5C, 0xB0, 0x55, 0x20,
  0x05, 0x28, 0x25, 0xCB, 0x20,
  // "ě" (U+011B)
  0x85, 0x30, 0x30, 0x2C, 0x15, 0x89, 0x42, 0xBA, 0x07, 0x26, 0x39, 0xBC, 0x47, 0x22, 0x82, 0x1B,
  0xB1,
  // "Ĝ" (U+011C)
  0x20, 0x63, 0x81, 0x56, 0x42, 0x84, 0x7C, 0xB1, 0x39, 0x30, 0x70, 0x33, 0x8A, 0x28, 0x23, 0xC4,
  0x63, 0x05, 0x43, 0x80, 0x54, 0x08, 0xCC, 0x30,
  // "ĝ" (U+011D)
  0x20, 0x62, 0x81, 0x56, 0x44, 0x8A, 0x22, 0xC8, 0x77, 0x24, 0x79, 0x12, 0x78, 0x24, 0x72, 0xC9,
  0x72, 0x84, 0x46, 0x4B, 0xB1,
  // "Ğ" (U+011E)
  0x18, 0x11, 0x01, 0x28, 0x4B, 0xFE, 0x13, 0x93, 0x07, 0x03, 0x38, 0xA2, 0x82, 0x3C, 0x46, 0x30,
  0x54, 0x38, 0x05, 0x40, 0x8C, 0xC3,
  // "ğ" (U+011F)
  0x18, 0xB1, 0x10, 0x10, 0x49, 0x22, 0xC8, 0x77, 0x24, 0x79, 0x12, 0x78, 0x24, 0x72, 0xC9, 0x72,
  0x84, 0x46, 0x4B, 0xB1,
  // "Ġ" (U+0120)
  0x20, 0x63, 0x84, 0x7C, 0xB1, 0x39, 0x30, 0x70, 0x33, 0x8A, 0x28, 0x23, 0xC4, 0x63, 0x05, 0x43,
  0x80, 0x54, 0x08, 0xCC, 0x30,
  // "ġ" (U+0121)
  0x10, 0x66, 0x8A, 0x22, 0xC8, 0x77, 0x24, 0x79, 0x12, 0x78, 0x24, 0x72, 0xC9, 0x72, 0x84, 0x46,
  0x4B, 0xB1,
  // "Ģ" (U+0122)
  0x18, 0x47, 0xCB, 0x13, 0x93, 0x07, 0x03, 0x38, 0xA2, 0x82, 0x3C, 0x46, 0x30, 0x54, 0x38, 0x05,
  0x40, 0x8C, 0xC3, 0x70, 0x60, 0x11,
  // "ģ" (U+0123)
  0x10, 0x50, 0x32, 0x01, 0x28, 0xA2, 0x2C, 0x87, 0x72, 0x47, 0x91, 0x27, 0x82, 0x47, 0x2C, 0x97,
  0x28, 0x44, 0x64, 0xBB, 0x10,
  // "Ĥ" (U+0124)
  0x20, 0x63, 0x8C, 0x55, 0x64, 0x05, 0x50, 0x81, 0x55, 0x08, 0x15, 0x50, 0x81, 0x5C, 0xBD, 0x15,
  0x50, 0x81, 0x55, 0x08, 0x15, 0x50, 0x81,
  // "ĥ" (U+0125)
  0x10, 0x63, 0x81, 0x56, 0x47, 0x10, 0x60, 0x33, 0x06, 0x03, 0x38, 0xA6, 0x6A, 0xC2, 0x06, 0x53,
  0x70, 0x63, 0x27, 0x06, 0x32, 0x70, 0x63, 0x27,
  // "Ħ" (U+0126)
  0x8C, 0x15, 0x40, 0x81, 0xDC, 0xBD, 0x95, 0x50, 0x81, 0x5C, 0xBD, 0x15, 0x40, 0x81, 0x54, 0x08,
  0x15, 0x40, 0x81,
  // "ħ" (U+0127)
  0x06, 0x03, 0x28, 0xA6, 0xCC, 0x40, 0x69, 0xC2, 0x65, 0x37, 0x63, 0x27, 0x63, 0x27, 0x63, 0x27,
  // "Ĩ" (U+0128)
  0x8A, 0x54, 0x86, 0xDF, 0x72, 0x80, 0x28, 0x02, 0x80, 0x28, 0x02, 0x80, 0x7C, 0x10,
  // "ĩ" (U+0129)
  0x8A, 0x34, 0x86, 0x44, 0x60, 0x63, 0x06, 0x30, 0x63, 0x06, 0x30, 0x63,
  // "Ī" (U+012A)
  0x8A, 0x2E, 0xF4, 0x28, 0x02, 0x80, 0x28, 0x02, 0x80, 0x28, 0x07, 0xC1,
  // "ī" (U+012B)
  0x89, 0x76, 0x93, 0x63, 0x06, 0x30, 0x63, 0x06, 0x30, 0x63, 0x10,
  // "Ĭ" (U+012C)
  0x8A, 0x51, 0x01, 0xCF, 0x32, 0x80, 0x28, 0x02, 0x80, 0x28, 0x02, 0x80, 0x7C, 0x10,
  // "ĭ" (U+012D)
  0x8A, 0x21, 0x01, 0x49, 0x26, 0x30, 0x63, 0x06, 0x30, 0x63, 0x06, 0x31,
  // "Į" (U+012E)
  0x8A, 0x58, 0xD1, 0x28, 0x02, 0x80, 0x28, 0x02, 0x80, 0x28, 0x07, 0xD2, 0x07, 0x20, 0x50, 0x40,
  // "į" (U+012F)
  0x04, 0x02, 0x28, 0x94, 0x63, 0x63, 0x63, 0x63, 0x75, 0x70, 0x54,
  // "İ" (U+0130)
  0x18, 0xA4, 0x60, 0x8D, 0x12, 0x80, 0x28, 0x02, 0x80, 0x28, 0x02, 0x80, 0x7C, 0x10,
  // "ı" (U+0131)
  0x89, 0x06, 0x36, 0x36, 0x36, 0x36, 0x30,
  // "Ĳ" (U+0132)
  0x8B, 0x58, 0xD7, 0x42, 0x86, 0x42, 0x86, 0x42, 0x86, 0x42, 0x86, 0x42, 0x86, 0x47, 0xC7, 0x40,
  0x5B, 0x10,
  // "ĳ" (U+0133)
  0x82, 0x42, 0x42, 0x48, 0xA2, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x28,
  0x47, 0x30, 0x2C, 0x10,
  // "Ĵ" (U+0134)
  0x20, 0x62, 0x84, 0x56, 0x40, 0x64, 0x20, 0x60, 0x42, 0x06, 0x04, 0x20, 0x60, 0x42, 0x06, 0x04,
  0x20, 0x60, 0x42, 0x83, 0x74, 0x05, 0xB2,
  // "ĵ" (U+0135)
  0x18, 0x36, 0x05, 0x64, 0x48, 0xA2, 0x63, 0x06, 0x30, 0x63, 0x06, 0x30, 0x63, 0x07, 0x32, 0xC1,
  // "Ķ" (U+0136)
  0x8B, 0x25, 0x51, 0x95, 0x59, 0x25, 0x78, 0x05, 0xD6, 0x05, 0x6B, 0x05, 0x56, 0x55, 0x50, 0xB5,
  0x06, 0x01, 0x10,
  // "ķ" (U+0137)
  0x06, 0x03, 0x20, 0x60, 0x32, 0x8A, 0x26, 0x39, 0x16, 0x77, 0x06, 0xD5, 0x06, 0x4A, 0x06, 0x37,
  0x35, 0x06, 0x01, 0x10,
  // "ĸ" (U+0138)
  0x8A, 0x26, 0x39, 0x16, 0x77, 0x06, 0xD5, 0x06, 0x4A, 0x06, 0x37, 0x30,
  // "Ĺ" (U+0139)
  0x10, 0x52, 0x06, 0x03, 0x20, 0x05, 0x20, 0x05, 0x20, 0x05, 0x20, 0x05, 0x20, 0x05, 0x20, 0x05,
  0x28, 0x25, 0xCA, 0x20,
  // "ĺ" (U+013A)
  0x18, 0x15, 0x63, 0x28, 0x94, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63,
  // "Ļ" (U+013B)
  0x00, 0x52, 0x00, 0x52, 0x00, 0x52, 0x00, 0x52, 0x00, 0x52, 0x00, 0x52, 0x82, 0x5C, 0xA2, 0x50,
  0x60, 0x11,
  // "ļ" (U+013C)
  0x89, 0x46, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x32, 0x06, 0x01,
  // "Ľ" (U+013D)
  0x89, 0x05, 0x56, 0x25, 0x51, 0x05, 0x52, 0x00, 0x52, 0x00, 0x52, 0x00, 0x52, 0x82, 0x5C, 0xA2,
  // "ľ" (U+013E)
  0x8A, 0x26, 0xA2, 0x64, 0x06, 0x30, 0x63, 0x06, 0x30, 0x63, 0x06, 0x31,
  // "Ŀ" (U+013F)
  0x00, 0x52, 0x00, 0x52, 0x84, 0x55, 0x60, 0x55, 0x20, 0x05, 0x20, 0x05, 0x28, 0x25, 0xCA, 0x20,
  // "ŀ" (U+0140)
  0x89, 0x46, 0x36, 0x36, 0x96, 0x36, 0x36, 0x36, 0x30,
  // "Ł" (U+0141)
  0x00, 0x52, 0x00, 0x52, 0x89, 0x05, 0x52, 0x05, 0xD3, 0x0B, 0x52, 0x00, 0x52, 0x82, 0x5C, 0xA2,
  // "ł" (U+0142)
  0x89, 0x46, 0x46, 0x46, 0x58, 0x9A, 0x46, 0x46, 0x40,
  // "Ń" (U+0143)
  0x30, 0x53, 0x8C, 0x46, 0x30, 0x5A, 0x04, 0x55, 0xD1, 0x45, 0x58, 0x74, 0x55, 0x4B, 0x45, 0x54,
  0x78, 0x55, 0x41, 0xD5, 0x54, 0x0A, 0x50,
  // "ń" (U+0144)
  0x20, 0x52, 0x06, 0x03, 0x58, 0xA2, 0x68, 0xC2, 0x65, 0x37, 0x63, 0x27, 0x63, 0x27, 0x63, 0x27,
  // "Ņ" (U+0145)
  0x8C, 0x15, 0xA0, 0x45, 0x5D, 0x14, 0x55, 0x87, 0x45, 0x54, 0xB4, 0x55, 0x47, 0x85, 0x54, 0x1D,
  0x55, 0x40, 0xA5, 0x70, 0x60, 0x11,
  // "ņ" (U+0146)
  0x8A, 0x26, 0x8C, 0x26, 0x53, 0x76, 0x32, 0x76, 0x32, 0x76, 0x32, 0x75, 0x06, 0x01, 0x10,
  // "Ň" (U+0147)
  0x18, 0x13, 0x03, 0x28, 0xC5, 0x2C, 0x10, 0x5A, 0x04, 0x55, 0xD1, 0x45, 0x58, 0x74, 0x55, 0x4B,
  0x45, 0x54, 0x78, 0x55, 0x41, 0xD5, 0x54, 0x0A, 0x50,
  // "ň" (U+0148)
  0x18, 0x53, 0x03, 0x02, 0xC1, 0x48, 0xA2, 0x68, 0xC2, 0x65, 0x37, 0x63, 0x27, 0x63, 0x27, 0x63,
  0x27,
  // "ŉ" (U+0149)
  0x08, 0x02, 0x30, 0x94, 0x8A, 0x71, 0x68, 0xC2, 0x06, 0x53, 0x70, 0x63, 0x27, 0x06, 0x32, 0x70,
  0x63, 0x27,
  // "Ŋ" (U+014A)
  0x8C, 0x15, 0xA0, 0x45, 0x5D, 0x14, 0x55, 0x78, 0x45, 0x54, 0xA4, 0x55, 0x45, 0x95, 0x54, 0x0D,
  0x55, 0x40, 0x75, 0x30, 0x50, 0x42, 0x04, 0x0B, 0x10,
  // "ŋ" (U+014B)
  0x8A, 0x26, 0x9C, 0x26, 0x53, 0x76, 0x32, 0x76, 0x32, 0x76, 0x32, 0x72, 0x03, 0x07, 0x20, 0xB0,
  0x40,
  // "Ō" (U+014C)
  0x1A, 0x8B, 0x5C, 0x04, 0x70, 0x83, 0x73, 0x04, 0x68, 0x20, 0x37, 0x73, 0x04, 0x64, 0x70, 0x83,
  0x09, 0xC9, 0x10,
  // "ō" (U+014D)
  0x18, 0xA5, 0x69, 0x32, 0xBB, 0x17, 0x33, 0x69, 0x11, 0x87, 0x23, 0x61, 0xBB, 0x10,
  // "Ŏ" (U+014E)
  0x18, 0x11, 0x01, 0x28, 0xB7, 0xDF, 0xB0, 0x47, 0x08, 0x37, 0x30, 0x46, 0x82, 0x03, 0x77, 0x30,
  0x46, 0x47, 0x08, 0x30, 0x9C, 0x91,
  // "ŏ" (U+014F)
  0x18, 0xB1, 0x10, 0x10, 0x49, 0x22, 0xBB, 0x17, 0x33, 0x69, 0x11, 0x87, 0x23, 0x61, 0xBB, 0x10,
  // "Ő" (U+0150)
  0x18, 0x14, 0x67, 0x28, 0xB7, 0xAD, 0x90, 0x47, 0x08, 0x37, 0x30, 0x46, 0x82, 0x03, 0x77, 0x30,
  0x46, 0x47, 0x08, 0x30, 0x9C, 0x91,
  // "ő" (U+0151)
  0x18, 0xB1, 0x46, 0x70, 0x11, 0x02, 0xBB, 0x17, 0x33, 0x69, 0x11, 0x87, 0x23, 0x61, 0xBB, 0x10,
  // "Œ" (U+0152)
  0x18, 0x78, 0xBE, 0xB5, 0x47, 0x09, 0x28, 0x27, 0x30, 0x92, 0x89, 0x08, 0x20, 0xEB, 0x37, 0x30,
  0x92, 0x82, 0x47, 0x09, 0x38, 0x39, 0xBE, 0xB5,
  // "œ" (U+0153)
  0x8A, 0x41, 0xBB, 0x7C, 0x47, 0x24, 0xA0, 0x99, 0x12, 0xDB, 0xA7, 0x34, 0xA2, 0x84, 0x1B, 0xA7,
  0xB6,
  // "Ŕ" (U+0154)
  0x20, 0x52, 0x8B, 0x56, 0x30, 0x5C, 0xC3, 0x55, 0x29, 0x55, 0x38, 0x5C, 0xC1, 0x55, 0xA0, 0x55,
  0x56, 0x55, 0x0B,
  // "ŕ" (U+0155)
  0x28, 0x25, 0x06, 0x33, 0x89, 0x46, 0x96, 0x66, 0x06, 0x30, 0x63, 0x06, 0x31,
  // "Ŗ" (U+0156)
  0x8B, 0x25, 0xCC, 0x35, 0x52, 0x95, 0x53, 0x85, 0xCC, 0x15, 0x5A, 0x05, 0x55, 0x65, 0x50, 0xB5,
  0x06, 0x01, 0x10,
  // "ŗ" (U+0157)
  0x89, 0x46, 0x96, 0x66, 0x06, 0x30, 0x63, 0x06, 0x34, 0x06, 0x01, 0x10,
  // "Ř" (U+0158)
  0x18, 0xC1, 0x30, 0x30, 0x2C, 0x15, 0xCC, 0x35, 0x52, 0x95, 0x53, 0x85, 0xCC, 0x15, 0x5A, 0x05,
  0x55, 0x65, 0x50, 0xB0,
  // "ř" (U+0159)
  0x84, 0x30, 0x32, 0xC1, 0x38, 0x94, 0x69, 0x66, 0x60, 0x63, 0x06, 0x30, 0x63, 0x10,
  // "Ś" (U+015A)
  0x20, 0x52, 0x87, 0x63, 0x02, 0xBC, 0x18, 0x22, 0x07, 0x05, 0x30, 0xA0, 0x83, 0x09, 0x03, 0x28,
  0x37, 0x38, 0xB9, 0x10,
  // "ś" (U+015B)
  0x28, 0x25, 0x06, 0x33, 0x87, 0x5C, 0x79, 0x10, 0x19, 0x32, 0x82, 0xA8, 0xC6,
  // "Ŝ" (U+015C)
  0x10, 0x62, 0x89, 0x05, 0x64, 0x02, 0xBC, 0x18, 0x22, 0x07, 0x05, 0x30, 0xA0, 0x83, 0x09, 0x03,
  0x28, 0x37, 0x38, 0xB9, 0x10,
  // "ŝ" (U+015D)
  0x18, 0x36, 0x05, 0x64, 0x38, 0x75, 0xC7, 0x91, 0x01, 0x93, 0x28, 0x2A, 0x8C, 0x60,
  // "Ş" (U+015E)
  0x84, 0x2B, 0xC1, 0x82, 0x20, 0x70, 0x53, 0x0A, 0x08, 0x30, 0x90, 0x32, 0x83, 0x73, 0x8D, 0x92,
  0x00, 0x42, 0x07, 0x03, 0x10,
  // "ş" (U+015F)
  0x87, 0x5C, 0x79, 0x10, 0x19, 0x32, 0x89, 0x0A, 0x8D, 0x60, 0x44, 0x07, 0x30,
  // "Š" (U+0160)
  0x89, 0x43, 0x03, 0x02, 0xC1, 0x02, 0xBC, 0x18, 0x22, 0x07, 0x05, 0x30, 0xA0, 0x83, 0x09, 0x03,
  0x28, 0x37, 0x38, 0xB9, 0x10,
  // "š" (U+0161)
  0x84, 0x30, 0x32, 0xC1, 0x38, 0x75, 0xC7, 0x91, 0x01, 0x93, 0x28, 0x2A, 0x8C, 0x60,
  // "Ţ" (U+0162)
  0x85, 0xAE, 0xB4, 0x09, 0x12, 0x09, 0x01, 0x20, 0x90, 0x12, 0x09, 0x01, 0x20, 0x90, 0x12, 0x0B,
  0x01, 0x20, 0x04, 0x20, 0x70, 0x31,
  // "ţ" (U+0163)
  0x8A, 0x64, 0x40, 0xAC, 0x16, 0x40, 0x64, 0x06, 0x40, 0x3D, 0x10, 0x44, 0x07, 0x30,
  // "Ť" (U+0164)
  0x89, 0x53, 0x03, 0x02, 0xC1, 0x0A, 0xEB, 0x40, 0x91, 0x20, 0x90, 0x12, 0x09, 0x01, 0x20, 0x90,
  0x12, 0x09, 0x01, 0x20, 0x90, 0x11,
  // "ť" (U+0165)
  0x28, 0x92, 0x62, 0x44, 0x10, 0xAC, 0x10, 0x64, 0x20, 0x60, 0x42, 0x06, 0x04, 0x28, 0x13, 0xB1,
  0x10,
  // "Ŧ" (U+0166)
  0x85, 0xAE, 0xB4, 0x09, 0x12, 0x84, 0x91, 0x06, 0xEB, 0x20, 0x90, 0x12, 0x09, 0x01, 0x20, 0x90,
  0x11,
  // "ŧ" (U+0167)
  0x8A, 0x04, 0x40, 0xAC, 0x16, 0x40, 0xBC, 0x16, 0x40, 0x3B, 0x10,
  // "Ũ" (U+0168)
  0x18, 0xB7, 0x48, 0x60, 0x69, 0x4F, 0x16, 0x40, 0x91, 0x64, 0x09, 0x16, 0x40, 0x91, 0x64, 0x09,
  0x14, 0x60, 0xB2, 0x81, 0xAB, 0x71,
  // "ũ" (U+0169)
  0x8B, 0x24, 0x86, 0x04, 0x46, 0x07, 0x33, 0x77, 0x33, 0x77, 0x33, 0x76, 0x34, 0x72, 0xA8, 0x70,
  // "Ū" (U+016A)
  0x8B, 0x36, 0xA9, 0xD1, 0x64, 0x09, 0x16, 0x40, 0x91, 0x64, 0x09, 0x16, 0x40, 0x91, 0x46, 0x0B,
  0x28, 0x1A, 0xB7, 0x10,
  // "ū" (U+016B)
  0x18, 0xA5, 0x69, 0x37, 0x33, 0x77, 0x33, 0x77, 0x33, 0x76, 0x34, 0x72, 0xA8, 0x70,
  // "Ŭ" (U+016C)
  0x18, 0xB7, 0x10, 0x10, 0x68, 0x9B, 0x16, 0x40, 0x91, 0x64, 0x09, 0x16, 0x40, 0x91, 0x64, 0x09,
  0x14, 0x60, 0xB2, 0x81, 0xAB, 0x71,
  // "ŭ" (U+016D)
  0x18, 0xB1, 0x10, 0x10, 0x49, 0x27, 0x33, 0x77, 0x33, 0x77, 0x33, 0x76, 0x34, 0x72, 0xA8, 0x70,
  // "Ů" (U+016E)
  0x10, 0x40, 0x62, 0x8B, 0x36, 0x86, 0x91, 0x64, 0x09, 0x16, 0x40, 0x91, 0x64, 0x09, 0x16, 0x40,
  0x91, 0x46, 0x0B, 0x28, 0x1A, 0xB7, 0x10,
  // "ů" (U+016F)
  0x10, 0x40, 0x62, 0x8A, 0x54, 0x60, 0x73, 0x37, 0x73, 0x37, 0x73, 0x37, 0x63, 0x47, 0x2A, 0x87,
  // "Ű" (U+0170)
  0x18, 0xB7, 0x46, 0x70, 0x65, 0x19, 0x16, 0x40, 0x91, 0x64, 0x09, 0x16, 0x40, 0x91, 0x64, 0x09,
  0x14, 0x60, 0xB2, 0x81, 0xAB, 0x71,
  // "ű" (U+0171)
  0x18, 0xB1, 0x46, 0x70, 0x11, 0x07, 0x33, 0x77, 0x33, 0x77, 0x33, 0x76, 0x34, 0x72, 0xA8, 0x70,
  // "Ų" (U+0172)
  0x8B, 0x36, 0x40, 0x91, 0x64, 0x09, 0x16, 0x40, 0x91, 0x64, 0x09, 0x16, 0x40, 0x91, 0x46, 0x0A,
  0x28, 0x1A, 0xC6, 0x30, 0x64, 0x08, 0x05, 0x10,
  // "ų" (U+0173)
  0x8A, 0x27, 0x33, 0x77, 0x33, 0x77, 0x33, 0x76, 0x34, 0x72, 0xA9, 0x82, 0x07, 0x30, 0x50, 0x40,
  // "Ŵ" (U+0174)
  0x30, 0x65, 0x81, 0x56, 0x42, 0x8C, 0x0A, 0x04, 0x80, 0x81, 0xA0, 0x7A, 0x0A, 0x07, 0x29, 0x90,
  0xA0, 0x45, 0x97, 0x38, 0x01, 0x98, 0x59, 0x62, 0x83, 0xC5, 0x2D, 0x32, 0x82, 0xB3, 0x0E, 0x20,
  // "ŵ" (U+0175)
  0x20, 0x64, 0x81, 0x56, 0x47, 0x18, 0xA5, 0xA0, 0xC1, 0x81, 0x91, 0xC4, 0x90, 0x67, 0x67, 0x90,
  0x3C, 0x2A, 0x72, 0x82, 0xE0, 0xA4, 0x10,
  // "Ŷ" (U+0176)
  0x10, 0x62, 0x89, 0x55, 0x64, 0x0B, 0x05, 0x57, 0x4B, 0x12, 0xCB, 0x20, 0xD0, 0x62, 0x09, 0x02,
  0x20, 0x80, 0x12, 0x08, 0x01, 0x10,
  // "ŷ" (U+0177)
  0x10, 0x62, 0x81, 0x56, 0x45, 0x89, 0x1A, 0x08, 0x28, 0x1A, 0x04, 0x69, 0x20, 0xC0, 0x52, 0x0B,
  0x01, 0x20, 0xA2, 0x0B, 0x05, 0x20,
  // "Ÿ" (U+0178)
  0x18, 0x94, 0x54, 0x1B, 0x05, 0x57, 0x4B, 0x12, 0xCB, 0x20, 0xD0, 0x62, 0x09, 0x02, 0x20, 0x80,
  0x12, 0x08, 0x01, 0x10,
  // "Ź" (U+0179)
  0x20, 0x52, 0x85, 0x63, 0x08, 0xBE, 0x12, 0x0B, 0x20, 0x40, 0x62, 0x83, 0xA1, 0x01, 0x92, 0x06,
  0x04, 0x20, 0xFB, 0x02,
  // "ź" (U+017A)
  0x28, 0x25, 0x06, 0x33, 0x89, 0x57, 0xC8, 0x07, 0x30, 0xA0, 0x54, 0x0B, 0xB7,
  // "Ż" (U+017B)
  0x10, 0x62, 0x82, 0x8B, 0xE1, 0x20, 0xB2, 0x04, 0x06, 0x28, 0x3A, 0x10, 0x19, 0x20, 0x60, 0x42,
  0x0F, 0xB0, 0x20,
  // "ż" (U+017C)
  0x10, 0x64, 0x89, 0x57, 0xC8, 0x07, 0x30, 0xA0, 0x54, 0x0B, 0xB7,
  // "Ž" (U+017D)
  0x89, 0x23, 0x03, 0x02, 0xC1, 0x08, 0xBE, 0x12, 0x0B, 0x20, 0x40, 0x62, 0x83, 0xA1, 0x01, 0x92,
  0x06, 0x04, 0x20, 0xFB, 0x02,
  // "ž" (U+017E)
  0x84, 0x30, 0x32, 0xC1, 0x38, 0x95, 0x7C, 0x80, 0x73, 0x0A, 0x05, 0x40, 0xBB, 0x70,
  // "ſ" (U+017F)
  0x8A, 0x22, 0xC3, 0x54, 0x06, 0x40, 0x64, 0x06, 0x40, 0x64, 0x06, 0x41,
  // "Ω" (U+03A9)
  0x18, 0xC0, 0x9B, 0x90, 0x47, 0x07, 0x47, 0x30, 0x37, 0x83, 0x03, 0x86, 0x40, 0x56, 0x18, 0x09,
  0x18, 0xE3, 0xE8,
  // "μ" (U+03BC)
  0x8A, 0x46, 0x32, 0x76, 0x32, 0x76, 0x32, 0x76, 0x44, 0x76, 0xC9, 0x76, 0x32, 0x06, 0x03, 0x20,
  // "π" (U+03C0)
  0x8A, 0x6A, 0xDC, 0xD1, 0x36, 0x46, 0x03, 0x64, 0x60, 0x36, 0x46, 0x03, 0x62, 0xC1,
  // "–" (U+2013)
  0x82, 0x8B, 0xB8,
  // "—" (U+2014)
  0x08, 0x80, 0x2B, 0x08,
  // "€" (U+20AC)
  0x18, 0x36, 0xC6, 0x0A, 0x20, 0x20, 0x72, 0x89, 0x0B, 0xD9, 0x0B, 0xD7, 0x02, 0x83, 0x81, 0x8B,
  0x50,
  // "₿" (U+20BF)
  0x18, 0x55, 0x50, 0x5C, 0xC1, 0x80, 0x25, 0x8A, 0x36, 0x45, 0xCD, 0x05, 0x54, 0x65, 0x54, 0x65,
  0xCC, 0x20, 0x55, 0x10,
  // "‘" (U+2018)
  0x83, 0x53, 0xA0, 0x11,
  // "’" (U+2019)
  0x83, 0x82, 0x90, 0x11,
  // "‚" (U+201A)
  0x83, 0x82, 0x90, 0x11,
  // "‛" (U+201B)
  0x82, 0xA0, 0x62,
  // "“" (U+201C)
  0x86, 0x53, 0x8A, 0x56, 0x11, 0x10,
  // "”" (U+201D)
  0x86, 0x85, 0x89, 0x54, 0x11, 0x10,
  // "„" (U+201E)
  0x86, 0x85, 0x89, 0x54, 0x11, 0x10,
  // "‟" (U+201F)
  0x84, 0xB5, 0x56, 0x38, 0x20, 0x10,
  // "†" (U+2020)
  0x18, 0x94, 0x73, 0x01, 0x63, 0x04, 0xA8, 0x20, 0x61, 0x20, 0x60, 0x22, 0x07, 0x02, 0x20, 0x70,
  0x31,
  // "‡" (U+2021)
  0x18, 0x90, 0x72, 0x03, 0x97, 0x21, 0x73, 0x28, 0x94, 0x62, 0x01, 0x73, 0x03, 0x97, 0x20, 0x72,
  0x10,
  // "•" (U+2022)
  0x18, 0x61, 0x05, 0xF5, 0x4E, 0x40,
  // "…" (U+2026)
  0x84, 0x43, 0x43, 0x43,
  // "‰" (U+2030)
  0x83, 0x4C, 0x06, 0x23, 0x82, 0x84, 0x48, 0x48, 0x28, 0x36, 0x64, 0x8B, 0x68, 0x4A, 0x59, 0x18,
  0x43, 0xB9, 0x83, 0x85, 0x80, 0x16, 0x83, 0x84, 0x80, 0x61, 0x5C, 0x2B, 0x60,
  // "‹" (U+2039)
  0x18, 0x56, 0x74, 0x47, 0x04,
  // "›" (U+203A)
  0x85, 0x51, 0x1A, 0x38, 0x31,
  // "⁄" (U+2044)
  0x30, 0x70, 0x13, 0x08, 0x30, 0x50, 0x33, 0x08, 0x30, 0x30, 0x53, 0x08, 0x30, 0x20, 0x63,
  // "™" (U+2122)
  0x8A, 0x2C, 0xDA, 0x0A, 0x24, 0x95, 0xC2, 0x46, 0xB7, 0x11, 0x23, 0x20,
  // "⅒" (U+2152)
  0x30, 0x70, 0x14, 0x81, 0x40, 0x84, 0x82, 0x49, 0x53, 0x58, 0x48, 0x80, 0x44, 0x82, 0x87, 0xC5,
  0x49, 0x83, 0x50, 0x82, 0x84, 0x88, 0x35, 0x26, 0x28, 0x18, 0x48, 0x10,
  // "ﬁ" (U+FB01)
  0x84, 0x1C, 0x82, 0x45, 0x28, 0xA2, 0xAD, 0x83, 0x55, 0x63, 0x55, 0x63, 0x55, 0x63, 0x55, 0x63,
  // "ﬂ" (U+FB02)
  0x8B, 0x21, 0xCB, 0x34, 0x56, 0x3A, 0xD8, 0x35, 0x56, 0x35, 0x56, 0x35, 0x56, 0x35, 0x56, 0x30,
};

const Font& font_NotoSans_Condensed_8() {
  static SmoothFont font(font_NotoSans_Condensed_8_data);
  return font;
}

}  // namespace roo_display
