#include "roo_transport/link/internal/thread_safe/compile_guard.h"
#ifdef ROO_USE_THREADS

#include "roo_transport/link/link_input_stream.h"

namespace roo_transport {

LinkInputStream::LinkInputStream(LinkInputStream&& other) {
  channel_ = other.channel_;
  my_stream_id_ = other.my_stream_id_;
  status_ = other.status_;
  other.channel_ = nullptr;
  other.my_stream_id_ = 0;
  other.status_ = roo_io::kClosed;
}

LinkInputStream& LinkInputStream::operator=(LinkInputStream&& other) {
  if (this != &other) {
    channel_ = other.channel_;
    my_stream_id_ = other.my_stream_id_;
    status_ = other.status_;
    other.channel_ = nullptr;
    other.my_stream_id_ = 0;
    other.status_ = roo_io::kClosed;
  }
  return *this;
}

void LinkInputStream::close() {
  if (status_ != roo_io::kOk && status_ != roo_io::kEndOfStream) return;
  channel_->closeInput(my_stream_id_, status_);
  if (status_ != roo_io::kOk && status_ != roo_io::kEndOfStream) return;
  status_ = roo_io::kClosed;
}

size_t LinkInputStream::read(roo::byte* buf, size_t count) {
  if (count == 0 || status_ != roo_io::kOk) return 0;
  return channel_->read(buf, count, my_stream_id_, status_);
  // // processor_.loop();
  // while (true) {
  //   for (int i = 0; i < 100; ++i) {
  //     size_t result = processor_.tryRead(buf, count);
  //     if (result > 0) {
  //       // if (count > result) {
  //       //   buf += result;
  //       //   count -= result;
  //       //   result += processor_.tryRead(buf, count);
  //       // }
  //       return result;
  //     }
  //     processor_.loop();
  //   }
  //   delay(1);
  // }
}

size_t LinkInputStream::tryRead(roo::byte* buf, size_t count) {
  if (count == 0 || status_ != roo_io::kOk) return 0;
  return channel_->tryRead(buf, count, my_stream_id_, status_);
}

size_t LinkInputStream::available() {
  if (status_ != roo_io::kOk) return 0;
  return channel_->availableForRead(my_stream_id_, status_);
}

int LinkInputStream::read() {
  if (status_ != roo_io::kOk) return 0;
  roo::byte result;
  size_t count = channel_->tryRead(&result, 1, my_stream_id_, status_);
  if (count > 0) return (int)result;
  return -1;
}

int LinkInputStream::peek() {
  if (status_ != roo_io::kOk) return -1;
  int result = channel_->peek(my_stream_id_, status_);
  if (result >= 0) return result;
  return -1;
}

}  // namespace roo_transport

#endif  // ROO_USE_THREADS