#pragma once

#ifndef ROO_THREADS_ESP32_PREFER_CPPSTD
#define ROO_THREADS_ESP32_PREFER_CPPSTD 0
#endif

#ifndef ROO_THREADS_SINGLETHREADED
#if (defined ROO_TESTING)
#define ROO_THREADS_USE_FREERTOS
#define ROO_THREADS_ATOMIC_USE_CPPSTD
#elif (defined ESP32) || (defined ESP8266) || (defined ESP_PLATFORM)
#if ROO_THREADS_ESP32_PREFER_CPPSTD
#define ROO_THREADS_USE_CPPSTD
#else
#define ROO_THREADS_USE_FREERTOS
#endif
#define ROO_THREADS_ATOMIC_USE_CPPSTD
#elif defined(ARDUINO_ARCH_RP2040)
#define ROO_THREADS_USE_FREERTOS
#define ROO_THREADS_ATOMIC_USE_CPPSTD
#else
#define ROO_THREADS_SINGLETHREADED
#endif
#endif
