
#include <Arduino.h>

#ifdef ESP32

#include "roo_io_arduino/fs/arduino_sdfs.h"

namespace roo_io {

ArduinoSdFs::ArduinoSdFs(uint8_t cs_pin, decltype(::SD)& sd,
                         decltype(::SPI)& spi, uint32_t freq)

    : sd_(sd), spi_(&spi), cs_pin_(cs_pin), frequency_(freq) {}

MountImpl::MountResult ArduinoSdFs::mountImpl(
    std::function<void()> unmount_fn) {
  if (!sd_.begin(cs_pin_, *spi_, frequency_)) {
    return MountImpl::MountError(kGenericMountError);
  }
  return MountImpl::Mounted(
      std::unique_ptr<MountImpl>(new ArduinoMountImpl(sd_, false, unmount_fn)));
}

void ArduinoSdFs::unmountImpl() { sd_.end(); }

Filesystem::MediaPresence ArduinoSdFs::checkMediaPresence() {
  return sd_.totalBytes() > 0 ? kMediaPresent : kMediaAbsent;
}

ArduinoSdFs SD;

}  // namespace roo_io

#endif