#include "hardware.h"

using namespace roo_display;

// Image file ic_sharp_18_hardware_adf_scanner 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_sharp_18_hardware_adf_scanner_data[] PROGMEM = {
  0x30, 0x28, 0x04, 0x50, 0x26, 0x07, 0xF9, 0x07, 0x60, 0x70, 0xD6, 0x0D, 0x07, 0x60, 0x70, 0xD6,
  0x0D, 0x07, 0x60, 0x70, 0xD6, 0x0D, 0x07, 0x38, 0x31, 0x77, 0xBE, 0x80, 0x27, 0x84, 0xEB, 0x77,
  0x13, 0xFF, 0x00, 0x3F, 0xC0, 0xEA, 0x00, 0x3F, 0xB0, 0xA0, 0x2A, 0x00, 0x3F, 0xC0, 0xEA, 0x00,
  0x3F, 0xF0, 0x30, 0x18, 0x09, 0x25, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_adf_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_adf_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_browser_not_supported 18x18, 4-bit Alpha,  RLE, 71 bytes.
static const unsigned char ic_sharp_18_hardware_browser_not_supported_data[] PROGMEM = {
  0x01, 0x06, 0x18, 0x05, 0x58, 0x32, 0x0B, 0x73, 0x80, 0x37, 0x84, 0xB6, 0x06, 0xF7, 0x78, 0x57,
  0x60, 0x68, 0xB7, 0x68, 0x67, 0x60, 0x67, 0x0B, 0x75, 0x83, 0x76, 0x06, 0x72, 0x0B, 0x07, 0x48,
  0x37, 0x60, 0x67, 0x30, 0xB0, 0x73, 0x83, 0x76, 0x06, 0x74, 0x0B, 0x07, 0x28, 0x37, 0x60, 0x67,
  0x58, 0x6B, 0x70, 0x76, 0x06, 0x76, 0x85, 0xB7, 0x35, 0x06, 0xB8, 0x02, 0x78, 0x18, 0xF7, 0x20,
  0x28, 0x05, 0x50, 0xB0, 0x67, 0x50, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_browser_not_supported() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 14, 15), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_browser_not_supported_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_browser_updated 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_sharp_18_hardware_browser_updated_data[] PROGMEM = {
  0x18, 0x03, 0x31, 0x01, 0x03, 0x50, 0x3F, 0x81, 0x36, 0xE5, 0x81, 0x3F, 0x26, 0x06, 0x0E, 0x58,
  0x13, 0xF2, 0x60, 0x60, 0xE5, 0x81, 0x3F, 0x26, 0x06, 0x0E, 0x58, 0x13, 0xF2, 0x60, 0x60, 0xE5,
  0x81, 0x3F, 0x24, 0x85, 0xBD, 0xEF, 0xDD, 0x52, 0x81, 0x3F, 0x24, 0x01, 0x0D, 0xB8, 0x56, 0x17,
  0x13, 0xF2, 0x58, 0x91, 0x1D, 0xF6, 0x02, 0xF3, 0x3F, 0x26, 0x01, 0x05, 0x28, 0x22, 0xF3, 0x39,
  0x80, 0x90, 0xD9, 0x85, 0x31, 0x77, 0x78, 0xEC, 0x84, 0xE8, 0x77, 0x71, 0x40, 0x8E, 0x08, 0x71,
  0x02, 0x80, 0x23, 0x02, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_browser_updated() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_browser_updated_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_cast_connected 18x18, 4-bit Alpha,  RLE, 107 bytes.
static const unsigned char ic_sharp_18_hardware_cast_connected_data[] PROGMEM = {
  0x02, 0x80, 0x94, 0xB8, 0x22, 0x3F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x33, 0xF3, 0x75, 0x85, 0x3F,
  0x33, 0xF3, 0x28, 0x06, 0xB8, 0x22, 0x3F, 0x33, 0x02, 0x0C, 0xFA, 0x85, 0x33, 0xF3, 0x16, 0x42,
  0x04, 0x0D, 0xF8, 0x33, 0x3F, 0x33, 0xA8, 0x3E, 0x81, 0x1B, 0xE8, 0x93, 0x33, 0xF3, 0x01, 0x39,
  0xFD, 0x20, 0xCD, 0x89, 0x43, 0x3F, 0x31, 0x62, 0x02, 0xDE, 0x22, 0xEC, 0x83, 0x33, 0xF3, 0x3A,
  0x85, 0xA1, 0x1E, 0xC0, 0x8C, 0x8B, 0x53, 0x3F, 0x30, 0x27, 0xFC, 0x05, 0xF4, 0x1B, 0xBB, 0xB2,
  0x3F, 0x31, 0x40, 0x5F, 0x70, 0xEA, 0x68, 0xB6, 0x3F, 0x33, 0xF8, 0x0B, 0xC0, 0x9D, 0x05, 0xBB,
  0xBB, 0xCF, 0x32, 0xBA, 0x06, 0xB0, 0x6B, 0x05, 0x80, 0x2B, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_cast_connected() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_cast_connected_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_cast_for_education 18x18, 4-bit Alpha,  RLE, 113 bytes.
static const unsigned char ic_sharp_18_hardware_cast_for_education_data[] PROGMEM = {
  0x02, 0x80, 0x94, 0xB8, 0x22, 0x3F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x33, 0xF3, 0x70, 0x40, 0x23,
  0x84, 0x3F, 0x33, 0xF3, 0x50, 0x30, 0xBA, 0x84, 0x91, 0x03, 0xF3, 0x70, 0x9D, 0x86, 0xE7, 0x3F,
  0x31, 0x64, 0x40, 0x20, 0xAC, 0x84, 0x81, 0x3F, 0x33, 0xA8, 0x1E, 0x81, 0x28, 0xC7, 0x54, 0xCA,
  0x44, 0x03, 0xF3, 0x01, 0x39, 0xFD, 0x20, 0xBE, 0x79, 0xF7, 0x03, 0xF3, 0x16, 0x20, 0x2D, 0xE2,
  0x07, 0xED, 0x52, 0x82, 0x3F, 0x33, 0xA8, 0x3A, 0x11, 0xEC, 0x20, 0x14, 0x89, 0x23, 0xF3, 0x02,
  0x7F, 0xC0, 0x5F, 0x46, 0x89, 0x23, 0xF3, 0x14, 0x05, 0xF7, 0x0E, 0xA6, 0x8B, 0x63, 0xF3, 0x3F,
  0x80, 0xBC, 0x09, 0xD0, 0x5B, 0xBB, 0xBC, 0xF3, 0x2B, 0xA0, 0x6B, 0x06, 0xB0, 0x58, 0x02, 0xB0,
  0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_cast_for_education() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_cast_for_education_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_cast 18x18, 4-bit Alpha,  RLE, 94 bytes.
static const unsigned char ic_sharp_18_hardware_cast_data[] PROGMEM = {
  0x02, 0x80, 0x94, 0xB8, 0x22, 0x3F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x33, 0xF3, 0x75, 0x84, 0x3F,
  0x33, 0xF3, 0x75, 0x81, 0x3F, 0x37, 0x71, 0x84, 0x3F, 0x31, 0x64, 0x75, 0x82, 0x3F, 0x33, 0xA8,
  0x1E, 0x81, 0x72, 0x89, 0x03, 0xF3, 0x01, 0x39, 0xFD, 0x27, 0x18, 0x91, 0x3F, 0x31, 0x62, 0x02,
  0xDE, 0x27, 0x82, 0x3F, 0x33, 0xA8, 0x3A, 0x11, 0xEC, 0x78, 0x92, 0x3F, 0x30, 0x27, 0xFC, 0x05,
  0xF4, 0x68, 0x92, 0x3F, 0x31, 0x40, 0x5F, 0x70, 0xEA, 0x68, 0xB6, 0x3F, 0x33, 0xF8, 0x0B, 0xC0,
  0x9D, 0x05, 0xBB, 0xBB, 0xCF, 0x32, 0xBA, 0x06, 0xB0, 0x6B, 0x05, 0x80, 0x2B, 0x02,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_cast() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_cast_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_computer 18x18, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_sharp_18_hardware_computer_data[] PROGMEM = {
  0x10, 0x7F, 0xF0, 0x72, 0x07, 0x98, 0x09, 0x07, 0x90, 0x72, 0x07, 0x97, 0x59, 0x07, 0x20, 0x79,
  0x75, 0x90, 0x72, 0x07, 0x97, 0x59, 0x07, 0x20, 0x79, 0x75, 0x90, 0x72, 0x07, 0x97, 0x59, 0x07,
  0x20, 0x79, 0x75, 0x90, 0x72, 0x07, 0x97, 0x59, 0x07, 0x20, 0x10, 0xDF, 0xD8, 0x4D, 0x10, 0x77,
  0x9F, 0xD8, 0x19, 0x77, 0xFF, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_computer() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_computer_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_connected_tv 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_sharp_18_hardware_connected_tv_data[] PROGMEM = {
  0x18, 0x09, 0x23, 0x10, 0x3F, 0xF8, 0x23, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x62,
  0xF3, 0x3F, 0x59, 0x57, 0x18, 0x90, 0x2F, 0x33, 0xF3, 0x5A, 0xC1, 0x68, 0x90, 0x2F, 0x33, 0xF6,
  0xB4, 0x5D, 0x68, 0x91, 0x2F, 0x33, 0xF2, 0x3C, 0x58, 0x75, 0x89, 0x12, 0xF3, 0x3F, 0x7C, 0x2D,
  0x2D, 0x58, 0x91, 0x2F, 0x33, 0xF6, 0xB3, 0x81, 0xA5, 0x82, 0x2F, 0x33, 0x98, 0x09, 0x0D, 0x98,
  0x53, 0x17, 0x77, 0x7D, 0xC8, 0x4D, 0x77, 0x77, 0x15, 0x0A, 0xC0, 0xA7, 0x38, 0x42, 0x33, 0x33,
  0x25,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_connected_tv() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_connected_tv_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_desktop_mac 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_sharp_18_hardware_desktop_mac_data[] PROGMEM = {
  0x01, 0x80, 0x94, 0x70, 0x10, 0x3F, 0xFA, 0x82, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75,
  0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84,
  0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF9, 0x80, 0x90, 0x78,
  0x29, 0xF3, 0x3F, 0xFA, 0x00, 0x3F, 0xFA, 0x03, 0x01, 0x80, 0x27, 0x0C, 0xA0, 0xC8, 0x02, 0x70,
  0x16, 0x02, 0xC0, 0x27, 0x50, 0xCC, 0x0C, 0x75, 0x80, 0x27, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_desktop_mac() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 16), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_desktop_mac_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_desktop_windows 18x18, 4-bit Alpha,  RLE, 73 bytes.
static const unsigned char ic_sharp_18_hardware_desktop_windows_data[] PROGMEM = {
  0x01, 0x80, 0x94, 0x70, 0x10, 0x3F, 0xFA, 0x82, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75,
  0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84,
  0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F,
  0x33, 0xF3, 0x75, 0x82, 0x3F, 0x33, 0xFF, 0xA0, 0x30, 0x18, 0x02, 0x70, 0xBA, 0x0B, 0x80, 0x27,
  0x01, 0x70, 0x7A, 0x07, 0x76, 0xE7, 0x58, 0x02, 0x76,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_desktop_windows() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 16), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_desktop_windows_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_developer_board_off 18x18, 4-bit Alpha,  RLE, 103 bytes.
static const unsigned char ic_sharp_18_hardware_developer_board_off_data[] PROGMEM = {
  0x00, 0x72, 0x80, 0x53, 0x01, 0x28, 0x36, 0xF7, 0x09, 0xF9, 0x06, 0x20, 0x3A, 0x07, 0x71, 0x0E,
  0x06, 0x28, 0xA4, 0x3F, 0x8F, 0x70, 0x31, 0x99, 0x60, 0xEB, 0x91, 0x3F, 0x29, 0xF7, 0x2A, 0x89,
  0x0A, 0x0E, 0xDB, 0x23, 0xF2, 0x7A, 0x86, 0x70, 0x33, 0x20, 0xE6, 0x28, 0x23, 0xF2, 0x7B, 0x8B,
  0x37, 0x07, 0x90, 0xEB, 0x91, 0x3F, 0x21, 0x11, 0x8F, 0x70, 0x40, 0xEB, 0x91, 0x3F, 0x27, 0xB8,
  0x17, 0xF7, 0x20, 0xE0, 0x62, 0x82, 0x3F, 0x27, 0xB0, 0x1A, 0x8A, 0x77, 0x09, 0xDB, 0x23, 0xF2,
  0x49, 0x99, 0x19, 0xAF, 0x70, 0x79, 0x13, 0xF2, 0x78, 0x16, 0xF7, 0x30, 0x3F, 0xD0, 0x73, 0x80,
  0x73, 0x81, 0x7F, 0x77, 0x70, 0x60, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_developer_board_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_developer_board_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_developer_board 18x18, 4-bit Alpha,  RLE, 93 bytes.
static const unsigned char ic_sharp_18_hardware_developer_board_data[] PROGMEM = {
  0x05, 0x80, 0x91, 0xB2, 0x07, 0x98, 0x06, 0xB0, 0xD9, 0x20, 0x79, 0x73, 0x07, 0x92, 0x8A, 0x27,
  0xF0, 0x5B, 0xBB, 0x2B, 0xBB, 0x07, 0xFB, 0x57, 0xF0, 0x7B, 0x03, 0xB1, 0x86, 0x7F, 0xB5, 0x7F,
  0x07, 0xB8, 0x43, 0x77, 0x70, 0x79, 0x28, 0x27, 0xF0, 0x7B, 0x89, 0x73, 0xBB, 0xB0, 0x7F, 0xB5,
  0x7F, 0x01, 0x33, 0x31, 0xB1, 0x86, 0x7F, 0xB5, 0x7F, 0x07, 0xB0, 0x3B, 0x10, 0x79, 0x28, 0x27,
  0xF0, 0x7B, 0x03, 0xB1, 0x8A, 0x37, 0xFB, 0x57, 0xF0, 0x5B, 0xBB, 0x2B, 0xBB, 0x07, 0xFB, 0x57,
  0x97, 0x30, 0x79, 0x20, 0x79, 0x80, 0x6B, 0x0D, 0x92, 0x05, 0x80, 0x91, 0xB2,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_developer_board() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_developer_board_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_device_hub 18x18, 4-bit Alpha,  RLE, 59 bytes.
static const unsigned char ic_sharp_18_hardware_device_hub_data[] PROGMEM = {
  0x58, 0x22, 0xAA, 0x27, 0x30, 0xEA, 0x0E, 0x72, 0x03, 0xC0, 0x37, 0x20, 0xEA, 0x0E, 0x73, 0x82,
  0x2D, 0xD2, 0x74, 0x00, 0xB7, 0x50, 0x0B, 0x74, 0x04, 0xA0, 0x47, 0x28, 0x44, 0xFC, 0xCF, 0x47,
  0x86, 0x4F, 0xC1, 0x1C, 0xF4, 0x30, 0xBB, 0x0C, 0x01, 0x20, 0x10, 0xCB, 0x00, 0xBB, 0x01, 0x40,
  0x1B, 0x00, 0xBB, 0x6B, 0x0B, 0x08, 0x0F, 0xB6, 0x0F, 0xB0, 0x80,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_device_hub() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_device_hub_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_devices_other 18x18, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_sharp_18_hardware_devices_other_data[] PROGMEM = {
  0x03, 0xFF, 0x0B, 0x28, 0x13, 0xF9, 0x80, 0x90, 0x70, 0x52, 0x81, 0x3F, 0x37, 0x71, 0x81, 0x3F,
  0x37, 0x10, 0xBD, 0x82, 0x33, 0xF3, 0x71, 0x89, 0x0B, 0xD7, 0x79, 0xF3, 0x3F, 0x37, 0x10, 0x0B,
  0x28, 0x43, 0xF3, 0x3F, 0x33, 0x03, 0xA8, 0x2B, 0x0B, 0xB2, 0x84, 0x3F, 0x33, 0xF3, 0x38, 0x56,
  0xFE, 0xD0, 0xBB, 0x28, 0x43, 0xF3, 0x3F, 0x33, 0x85, 0xD4, 0x0C, 0x6B, 0xB2, 0x84, 0x3F, 0x33,
  0xF3, 0x38, 0x5D, 0x40, 0xC6, 0xBB, 0x28, 0xA4, 0x3F, 0x33, 0xF9, 0x77, 0x16, 0xFE, 0xD0, 0xBD,
  0x77, 0x9F, 0x33, 0xC0, 0x03, 0xA8, 0x1B, 0x0B, 0xD0, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_devices_other() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_devices_other_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_device_unknown 18x18, 4-bit Alpha,  RLE, 92 bytes.
static const unsigned char ic_sharp_18_hardware_device_unknown_data[] PROGMEM = {
  0x01, 0x80, 0x63, 0x01, 0x03, 0xFB, 0x00, 0x3F, 0xB8, 0x23, 0x3F, 0xC8, 0x02, 0xB8, 0x4C, 0xF3,
  0x3F, 0x36, 0x8B, 0x63, 0xF3, 0x3F, 0x30, 0x6D, 0xD6, 0x03, 0xF3, 0x3F, 0x34, 0xF7, 0x7F, 0x43,
  0xF3, 0x3F, 0x35, 0x72, 0x86, 0xB8, 0x3F, 0x33, 0xF3, 0x38, 0x73, 0xE5, 0x3F, 0x33, 0xF3, 0x28,
  0x90, 0x2E, 0x80, 0x3F, 0x33, 0xF3, 0x20, 0x90, 0xC2, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3,
  0x3F, 0x32, 0x00, 0xB2, 0x84, 0x3F, 0x33, 0xF3, 0x20, 0x05, 0x28, 0x43, 0xF3, 0x3F, 0xC8, 0x02,
  0xB8, 0x2C, 0xF3, 0x3F, 0xB0, 0x03, 0xFB, 0x03, 0x01, 0x80, 0x63, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_device_unknown() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_device_unknown_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_dock 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_sharp_18_hardware_dock_data[] PROGMEM = {
  0x01, 0x80, 0x43, 0x01, 0x07, 0xF9, 0x00, 0x7F, 0x90, 0x07, 0x98, 0x02, 0xB9, 0x00, 0x79, 0x69,
  0x00, 0x79, 0x69, 0x00, 0x79, 0x69, 0x00, 0x79, 0x69, 0x00, 0x79, 0x69, 0x00, 0x79, 0x69, 0x00,
  0x79, 0x69, 0x00, 0x79, 0x80, 0x2B, 0x90, 0x07, 0xF9, 0x00, 0x7F, 0x90, 0x70, 0x18, 0x04, 0x30,
  0x12, 0x80, 0x23, 0x4E, 0x48, 0x02, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_dock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 0, 13, 17), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_dock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_earbuds_battery 18x18, 4-bit Alpha,  RLE, 83 bytes.
static const unsigned char ic_sharp_18_hardware_earbuds_battery_data[] PROGMEM = {
  0x18, 0x14, 0x73, 0x28, 0x15, 0x62, 0x30, 0x70, 0x62, 0x01, 0xA8, 0x94, 0x70, 0xBF, 0xEE, 0x32,
  0x9F, 0xE9, 0x13, 0xA8, 0x67, 0x3F, 0x20, 0xBA, 0x4C, 0x85, 0x33, 0xF5, 0x15, 0xE2, 0x81, 0x8C,
  0x4C, 0x85, 0x33, 0xF2, 0x05, 0xE2, 0x81, 0x8C, 0x4C, 0x85, 0x33, 0xF2, 0x05, 0xE2, 0x81, 0x8C,
  0x4C, 0x89, 0x23, 0x3F, 0x20, 0x5E, 0x03, 0xAC, 0x4C, 0x89, 0x23, 0x1F, 0x50, 0x9D, 0x0D, 0xFC,
  0x4C, 0x89, 0x23, 0x08, 0xFD, 0xF5, 0x0D, 0xFA, 0x4C, 0x03, 0x28, 0x14, 0x73, 0x28, 0x76, 0x71,
  0x27, 0x77, 0x71,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_earbuds_battery() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_earbuds_battery_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_earbuds 18x18, 4-bit Alpha,  RLE, 91 bytes.
static const unsigned char ic_sharp_18_hardware_earbuds_data[] PROGMEM = {
  0x20, 0xF3, 0x40, 0x30, 0x24, 0x0A, 0xB8, 0x23, 0x05, 0xEA, 0x82, 0xC2, 0x03, 0xC8, 0x90, 0x33,
  0xF8, 0x13, 0xCC, 0x04, 0xC8, 0x13, 0x8C, 0x38, 0x23, 0xF2, 0x4C, 0x81, 0x3A, 0xA3, 0x89, 0x11,
  0xF4, 0x4F, 0x43, 0x30, 0xAA, 0x38, 0x21, 0xF4, 0x49, 0x40, 0x0A, 0x38, 0x21, 0xF4, 0x49, 0x40,
  0x0A, 0x38, 0x21, 0xF4, 0x49, 0x48, 0x91, 0xAA, 0x03, 0x34, 0xF4, 0x4F, 0x13, 0x81, 0xAA, 0x3C,
  0x82, 0x42, 0xF3, 0x38, 0x1D, 0x83, 0xC8, 0x90, 0x40, 0xCC, 0x32, 0x8F, 0x23, 0xC8, 0x23, 0x02,
  0xCA, 0x82, 0xE5, 0x03, 0xB0, 0xA4, 0x02, 0x03, 0x40, 0xF3, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_earbuds() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_earbuds_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_gamepad 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_sharp_18_hardware_gamepad_data[] PROGMEM = {
  0x58, 0x41, 0x77, 0x77, 0x17, 0x30, 0x3C, 0x03, 0x73, 0x03, 0xC0, 0x37, 0x30, 0x3C, 0x03, 0x73,
  0x02, 0xC0, 0x25, 0x85, 0x13, 0x33, 0x20, 0x5A, 0x86, 0x50, 0x23, 0x33, 0x17, 0xC8, 0x45, 0x05,
  0x50, 0x5C, 0x00, 0x7D, 0x05, 0x20, 0x5D, 0x00, 0x7D, 0x05, 0x20, 0x5D, 0x00, 0x7C, 0x84, 0x50,
  0x55, 0x05, 0xC8, 0x67, 0x13, 0x33, 0x20, 0x5A, 0x85, 0x50, 0x23, 0x33, 0x15, 0x02, 0xC0, 0x27,
  0x30, 0x3C, 0x03, 0x73, 0x03, 0xC0, 0x37, 0x30, 0x3C, 0x03, 0x73, 0x84, 0x17, 0x77, 0x71, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_gamepad() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 16, 16), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_gamepad_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_headphones_battery 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_sharp_18_hardware_headphones_battery_data[] PROGMEM = {
  0x38, 0x22, 0x56, 0x25, 0x05, 0x04, 0x48, 0x48, 0xFE, 0xEF, 0xA2, 0x89, 0x02, 0x9D, 0xD9, 0x10,
  0x7F, 0x52, 0x83, 0x4E, 0x90, 0x4C, 0x82, 0x30, 0xE7, 0x48, 0x25, 0xF1, 0x4C, 0x82, 0x32, 0xF3,
  0x59, 0x00, 0x4C, 0x83, 0x33, 0xF3, 0x13, 0x82, 0x1F, 0x54, 0xC0, 0x03, 0xA0, 0x72, 0x05, 0xA0,
  0x50, 0x4C, 0x00, 0x3A, 0x07, 0x20, 0x5A, 0x05, 0x04, 0xC0, 0x03, 0xA0, 0x72, 0x05, 0xA0, 0x50,
  0x4C, 0x83, 0x31, 0x77, 0x32, 0x89, 0x02, 0x77, 0x22, 0x77, 0x77, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_headphones_battery() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 16, 13), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_headphones_battery_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_headphones 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_sharp_18_hardware_headphones_data[] PROGMEM = {
  0x58, 0x21, 0x33, 0x17, 0x10, 0x30, 0xBC, 0x0B, 0x03, 0x58, 0x90, 0x5F, 0xB4, 0x11, 0x4B, 0xF5,
  0x38, 0x13, 0xF8, 0x68, 0x18, 0xF3, 0x20, 0x0B, 0x71, 0x84, 0xBB, 0x01, 0xF4, 0x71, 0x84, 0x4F,
  0x13, 0xF1, 0x71, 0x86, 0x1F, 0x34, 0xF2, 0x11, 0x48, 0x41, 0x12, 0xF4, 0x4C, 0x03, 0x20, 0x3C,
  0x00, 0x4C, 0x03, 0x20, 0x3C, 0x00, 0x4C, 0x03, 0x20, 0x3C, 0x00, 0x4C, 0x03, 0x20, 0x3C, 0x00,
  0x4C, 0x03, 0x20, 0x3C, 0x04, 0x01, 0x80, 0x03, 0x48, 0x00, 0x30, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_headphones() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_headphones_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_headset_mic 18x18, 4-bit Alpha,  RLE, 82 bytes.
static const unsigned char ic_sharp_18_hardware_headset_mic_data[] PROGMEM = {
  0x60, 0x03, 0x72, 0x03, 0x0B, 0xC0, 0xB0, 0x35, 0x89, 0x06, 0xFD, 0x74, 0x47, 0xDF, 0x73, 0x81,
  0x5F, 0xA6, 0x81, 0x9F, 0x62, 0x0E, 0x0C, 0x71, 0x84, 0xBE, 0x15, 0xF3, 0x71, 0x83, 0x2F, 0x69,
  0xE7, 0x38, 0x2D, 0x9B, 0xB7, 0x38, 0x00, 0xB7, 0x30, 0xFB, 0xB0, 0xB4, 0x0B, 0xB0, 0x0B, 0xB0,
  0xB4, 0x0B, 0xB0, 0x0B, 0xB0, 0xB4, 0x0B, 0xB0, 0x0B, 0xB0, 0xB4, 0x0B, 0xB0, 0x0B, 0xB0, 0xB4,
  0x0B, 0xB0, 0x0B, 0xB0, 0xB4, 0x0B, 0xB0, 0xB7, 0x80, 0x13, 0x0C, 0x0B, 0x7E, 0x0B, 0x78, 0x02,
  0x30, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_headset_mic() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 15, 17), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_headset_mic_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_headset_off 18x18, 4-bit Alpha,  RLE, 106 bytes.
static const unsigned char ic_sharp_18_hardware_headset_off_data[] PROGMEM = {
  0x70, 0x02, 0x60, 0x07, 0x28, 0x12, 0xAE, 0xA8, 0x1E, 0xA2, 0x38, 0x93, 0x6F, 0x70, 0x8D, 0x63,
  0x36, 0xDE, 0x43, 0x81, 0x6F, 0x77, 0x81, 0x9E, 0x23, 0x81, 0xBF, 0x77, 0x0C, 0x0B, 0x28, 0x31,
  0xFA, 0xF7, 0x68, 0x90, 0x5F, 0x10, 0x3F, 0x16, 0xF7, 0x58, 0x31, 0xF3, 0x04, 0x92, 0x81, 0x6F,
  0x75, 0x98, 0x14, 0x04, 0xC8, 0x39, 0xF7, 0x09, 0xB8, 0x14, 0x04, 0xC8, 0x43, 0x6F, 0x70, 0x9A,
  0x81, 0x40, 0x4C, 0x89, 0x13, 0x06, 0xF7, 0x09, 0xF4, 0x04, 0xC0, 0x32, 0x86, 0x6F, 0x70, 0x94,
  0x04, 0xC0, 0x32, 0x03, 0xA8, 0x90, 0x70, 0x10, 0x15, 0x55, 0x51, 0x28, 0x31, 0x57, 0xF7, 0x72,
  0x80, 0x0B, 0x81, 0xEF, 0x77, 0x18, 0x01, 0x90, 0xA0, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_headset_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 15, 16), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_headset_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_headset 18x18, 4-bit Alpha,  RLE, 72 bytes.
static const unsigned char ic_sharp_18_hardware_headset_data[] PROGMEM = {
  0x60, 0x03, 0x72, 0x03, 0x0B, 0xC0, 0xB0, 0x35, 0x89, 0x06, 0xFD, 0x74, 0x47, 0xDF, 0x73, 0x81,
  0x5F, 0xA6, 0x81, 0x9F, 0x62, 0x0E, 0x0C, 0x71, 0x84, 0xBE, 0x15, 0xF3, 0x71, 0x83, 0x2F, 0x69,
  0xE7, 0x38, 0x2D, 0x9B, 0xB7, 0x38, 0x00, 0xB7, 0x30, 0xFB, 0xB0, 0xB4, 0x0B, 0xB0, 0x0B, 0xB0,
  0xB4, 0x0B, 0xB0, 0x0B, 0xB0, 0xB4, 0x0B, 0xB0, 0x0B, 0xB0, 0xB4, 0x0B, 0xB0, 0x0B, 0xB0, 0xB4,
  0x0B, 0xB0, 0x0B, 0xB0, 0xB4, 0x0B, 0xB0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_headset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 15, 14), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_headset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_home_max 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_sharp_18_hardware_home_max_data[] PROGMEM = {
  0x20, 0x28, 0x09, 0x05, 0x02, 0x30, 0x5F, 0xF0, 0x52, 0x0E, 0x09, 0x75, 0x84, 0x9E, 0x01, 0xF4,
  0x75, 0x84, 0x4F, 0x11, 0xF3, 0x75, 0x84, 0x3F, 0x11, 0xF3, 0x75, 0x84, 0x3F, 0x11, 0xF3, 0x75,
  0x84, 0x3F, 0x11, 0xF3, 0x75, 0x84, 0x3F, 0x10, 0xE8, 0x75, 0x08, 0x0E, 0x20, 0x69, 0x80, 0x90,
  0xD9, 0x06, 0x38, 0x23, 0x77, 0xCE, 0x82, 0xC7, 0x73, 0x70, 0x38, 0x02, 0x50, 0x35,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_home_max() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_home_max_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_home_mini 18x18, 4-bit Alpha,  RLE, 67 bytes.
static const unsigned char ic_sharp_18_hardware_home_mini_data[] PROGMEM = {
  0x58, 0x41, 0x45, 0x54, 0x17, 0x10, 0x40, 0xCE, 0x0C, 0x05, 0x58, 0x39, 0xFA, 0x41, 0x28, 0x31,
  0x4A, 0xF8, 0x38, 0x16, 0xF5, 0x71, 0x81, 0x5F, 0x62, 0x0D, 0x09, 0x73, 0x84, 0x8D, 0x02, 0xF4,
  0x73, 0x82, 0x3F, 0x22, 0xFF, 0x82, 0x20, 0xEB, 0x80, 0x65, 0x0A, 0x92, 0x81, 0x9E, 0x17, 0x20,
  0xD0, 0x92, 0x82, 0x1D, 0xD4, 0x68, 0x24, 0xDD, 0x13, 0x01, 0x0B, 0xF9, 0x0B, 0x01, 0x60, 0x28,
  0x02, 0x50, 0x24,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_home_mini() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_home_mini_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_keyboard_alt 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_sharp_18_hardware_keyboard_alt_data[] PROGMEM = {
  0x18, 0x09, 0x43, 0x10, 0x1F, 0xFA, 0x00, 0x1F, 0xFA, 0x00, 0x1B, 0x89, 0x0E, 0xEF, 0xDE, 0xED,
  0xFE, 0xEB, 0x00, 0x1B, 0x89, 0x04, 0x5F, 0x0A, 0xA0, 0xF5, 0x4B, 0x00, 0x1B, 0x89, 0x0C, 0xDF,
  0xBE, 0xEB, 0xFD, 0xCB, 0x00, 0x1B, 0x89, 0x09, 0xAF, 0x7C, 0xC7, 0xFA, 0x9B, 0x00, 0x1B, 0x89,
  0x05, 0x7F, 0x1B, 0xB1, 0xF7, 0x5B, 0x00, 0x1F, 0xFA, 0x00, 0x1D, 0x84, 0x73, 0x33, 0x37, 0xD0,
  0x01, 0xD8, 0x4E, 0xDD, 0xDD, 0xED, 0x00, 0x1F, 0xFA, 0x00, 0x1F, 0xFA, 0x01, 0x18, 0x09, 0x43,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_keyboard_alt() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_keyboard_alt_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_keyboard_arrow_down 18x18, 4-bit Alpha,  RLE, 24 bytes.
static const unsigned char ic_sharp_18_hardware_keyboard_arrow_down_data[] PROGMEM = {
  0x10, 0x46, 0x83, 0x40, 0x3F, 0x94, 0x85, 0x9F, 0x30, 0x7F, 0x92, 0x81, 0x9F, 0x73, 0x84, 0x7F,
  0x99, 0xF7, 0x50, 0x7A, 0x07, 0x70, 0x07, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_keyboard_arrow_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 13, 11), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_keyboard_arrow_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_keyboard_arrow_left 18x18, 4-bit Alpha,  RLE, 28 bytes.
static const unsigned char ic_sharp_18_hardware_keyboard_arrow_left_data[] PROGMEM = {
  0x40, 0x34, 0x81, 0x7F, 0x42, 0x81, 0x7F, 0x92, 0x81, 0x7F, 0x92, 0x81, 0x7F, 0x93, 0x81, 0x7F,
  0x94, 0x81, 0x7F, 0x94, 0x81, 0x7F, 0x94, 0x81, 0x7F, 0x44, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_keyboard_arrow_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 11, 13), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_keyboard_arrow_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_keyboard_arrow_right 18x18, 4-bit Alpha,  RLE, 28 bytes.
static const unsigned char ic_sharp_18_hardware_keyboard_arrow_right_data[] PROGMEM = {
  0x10, 0x34, 0x81, 0x4F, 0x74, 0x81, 0x9F, 0x74, 0x81, 0x9F, 0x74, 0x81, 0x9F, 0x73, 0x81, 0x9F,
  0x72, 0x81, 0x9F, 0x72, 0x81, 0x9F, 0x72, 0x81, 0x4F, 0x74, 0x03, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_keyboard_arrow_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(6, 4, 11, 13), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_keyboard_arrow_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_keyboard_arrow_up 18x18, 4-bit Alpha,  RLE, 24 bytes.
static const unsigned char ic_sharp_18_hardware_keyboard_arrow_up_data[] PROGMEM = {
  0x40, 0x07, 0x70, 0x7A, 0x07, 0x58, 0x47, 0xF9, 0x9F, 0x73, 0x81, 0x7F, 0x92, 0x85, 0x9F, 0x70,
  0x3F, 0x94, 0x83, 0x9F, 0x30, 0x46, 0x04, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_keyboard_arrow_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 6, 13, 11), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_keyboard_arrow_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_keyboard_backspace 18x18, 4-bit Alpha,  RLE, 39 bytes.
static const unsigned char ic_sharp_18_hardware_keyboard_backspace_data[] PROGMEM = {
  0x40, 0x37, 0x58, 0x14, 0xF8, 0x73, 0x82, 0x4F, 0xC1, 0x72, 0x82, 0x4F, 0xC1, 0x72, 0x04, 0xA0,
  0xC8, 0x05, 0xB0, 0x80, 0x4A, 0x0C, 0x80, 0x5B, 0x84, 0x80, 0x4F, 0xC1, 0x74, 0x82, 0x4F, 0xC1,
  0x74, 0x81, 0x4F, 0x87, 0x50, 0x37, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_keyboard_backspace() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_keyboard_backspace_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_keyboard_capslock 18x18, 4-bit Alpha,  RLE, 32 bytes.
static const unsigned char ic_sharp_18_hardware_keyboard_capslock_data[] PROGMEM = {
  0x40, 0x05, 0x70, 0x5A, 0x05, 0x58, 0x45, 0xFB, 0xBF, 0x53, 0x81, 0x5F, 0xB2, 0x85, 0xBF, 0x50,
  0x3F, 0xB4, 0x83, 0xBF, 0x30, 0x76, 0x07, 0x77, 0x70, 0x7F, 0x90, 0x70, 0x38, 0x04, 0x70, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_keyboard_capslock() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 13, 13), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_keyboard_capslock_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_keyboard_command_key 18x18, 4-bit Alpha,  RLE, 98 bytes.
static const unsigned char ic_sharp_18_hardware_keyboard_command_key_data[] PROGMEM = {
  0x20, 0x20, 0x36, 0x03, 0x02, 0x30, 0x8A, 0x0C, 0x01, 0x20, 0x10, 0xCA, 0x86, 0x80, 0x2F, 0x62,
  0xD7, 0x28, 0x92, 0x7D, 0x26, 0xF2, 0x3F, 0x20, 0xA9, 0x28, 0xA1, 0x9A, 0x02, 0xF3, 0x0C, 0xDB,
  0xEE, 0xBB, 0xEE, 0xBD, 0xC2, 0x89, 0x21, 0x79, 0xDD, 0x99, 0xDD, 0x97, 0x15, 0x00, 0xA2, 0x00,
  0xA7, 0x10, 0x0A, 0x20, 0x0A, 0x58, 0x92, 0x17, 0x9D, 0xD9, 0x9D, 0xD9, 0x71, 0x28, 0xA1, 0xCD,
  0xBE, 0xEB, 0xBE, 0xEB, 0xDC, 0x03, 0xF2, 0x0A, 0x92, 0x89, 0x29, 0xA0, 0x2F, 0x32, 0xF6, 0x2D,
  0x72, 0x86, 0x7D, 0x26, 0xF2, 0x08, 0xA0, 0xC0, 0x12, 0x01, 0x0C, 0xA0, 0x83, 0x02, 0x03, 0x60,
  0x30, 0x22,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_keyboard_command_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_keyboard_command_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_keyboard_control_key 18x18, 4-bit Alpha,  RLE, 27 bytes.
static const unsigned char ic_sharp_18_hardware_keyboard_control_key_data[] PROGMEM = {
  0x40, 0x01, 0x78, 0x21, 0xDD, 0x15, 0x84, 0x1D, 0xCC, 0xD1, 0x38, 0x93, 0x1D, 0xC1, 0x1C, 0xD1,
  0x01, 0xDC, 0x12, 0x85, 0x1C, 0xD1, 0x1A, 0x14, 0x81, 0x1A, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_keyboard_control_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 4, 13, 9), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_keyboard_control_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_keyboard_double_arrow_down 18x18, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_sharp_18_hardware_keyboard_double_arrow_down_data[] PROGMEM = {
  0x10, 0x26, 0x83, 0x20, 0x3F, 0x54, 0x85, 0x5F, 0x30, 0x8F, 0x52, 0x81, 0x5F, 0x83, 0x84, 0x8F,
  0x55, 0xF8, 0x50, 0x8A, 0x08, 0x70, 0x08, 0x48, 0x12, 0xC2, 0x48, 0x52, 0xC2, 0x1C, 0xD2, 0x28,
  0x93, 0x2D, 0xC1, 0x01, 0xCD, 0x22, 0xDC, 0x13, 0x84, 0x1C, 0xDD, 0xC1, 0x58, 0x21, 0xCC, 0x17,
  0x00, 0x14,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_keyboard_double_arrow_down() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 13, 14), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_keyboard_double_arrow_down_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_keyboard_double_arrow_left 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_sharp_18_hardware_keyboard_double_arrow_left_data[] PROGMEM = {
  0x40, 0x10, 0x24, 0x03, 0x48, 0x11, 0xCC, 0x38, 0x18, 0xF2, 0x28, 0x21, 0xCD, 0x22, 0x81, 0x8F,
  0x52, 0x82, 0x1C, 0xD2, 0x28, 0x18, 0xF5, 0x28, 0x21, 0xCD, 0x22, 0x81, 0x8F, 0x53, 0x82, 0x1C,
  0xD2, 0x28, 0x18, 0xF5, 0x48, 0x21, 0xCD, 0x22, 0x81, 0x8F, 0x54, 0x82, 0x1C, 0xD2, 0x28, 0x18,
  0xF5, 0x48, 0x11, 0xCC, 0x38, 0x18, 0xF2, 0x40, 0x10, 0x24, 0x03, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_keyboard_double_arrow_left() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 14, 13), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_keyboard_double_arrow_left_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_keyboard_double_arrow_right 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_sharp_18_hardware_keyboard_double_arrow_right_data[] PROGMEM = {
  0x10, 0x34, 0x02, 0x01, 0x48, 0x12, 0xF8, 0x38, 0x1C, 0xC1, 0x48, 0x15, 0xF8, 0x28, 0x22, 0xDC,
  0x14, 0x81, 0x5F, 0x82, 0x82, 0x2D, 0xC1, 0x48, 0x15, 0xF8, 0x28, 0x22, 0xDC, 0x13, 0x81, 0x5F,
  0x82, 0x82, 0x2D, 0xC1, 0x28, 0x15, 0xF8, 0x28, 0x22, 0xDC, 0x12, 0x81, 0x5F, 0x82, 0x82, 0x2D,
  0xC1, 0x28, 0x12, 0xF8, 0x38, 0x1C, 0xC1, 0x40, 0x34, 0x02, 0x01, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_keyboard_double_arrow_right() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 4, 14, 13), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_keyboard_double_arrow_right_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_keyboard_double_arrow_up 18x18, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_sharp_18_hardware_keyboard_double_arrow_up_data[] PROGMEM = {
  0x40, 0x01, 0x78, 0x21, 0xCC, 0x15, 0x84, 0x1C, 0xDD, 0xC1, 0x38, 0x93, 0x1C, 0xD2, 0x2D, 0xC1,
  0x01, 0xCD, 0x22, 0x85, 0x2D, 0xC1, 0x2C, 0x24, 0x81, 0x2C, 0x24, 0x00, 0x87, 0x08, 0xA0, 0x85,
  0x84, 0x8F, 0x55, 0xF8, 0x38, 0x18, 0xF5, 0x28, 0x55, 0xF8, 0x03, 0xF5, 0x48, 0x35, 0xF3, 0x02,
  0x60, 0x21,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_keyboard_double_arrow_up() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(4, 3, 13, 14), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_keyboard_double_arrow_up_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_keyboard_hide 18x18, 4-bit Alpha,  RLE, 78 bytes.
static const unsigned char ic_sharp_18_hardware_keyboard_hide_data[] PROGMEM = {
  0x05, 0x80, 0x92, 0xB0, 0x50, 0x7F, 0xF8, 0x9A, 0x07, 0x7F, 0xD7, 0xD7, 0xB9, 0x9B, 0x7D, 0x7D,
  0xF7, 0x7F, 0xB0, 0xB0, 0x73, 0x37, 0x0B, 0x0B, 0xF7, 0x7F, 0xEB, 0xEB, 0xDC, 0xCD, 0xBE, 0xBE,
  0xF7, 0x7F, 0xB0, 0xB0, 0x73, 0x37, 0x0B, 0x0B, 0xF7, 0x7F, 0xEB, 0xEB, 0xDC, 0xCD, 0xBE, 0xBE,
  0xF7, 0x7C, 0x80, 0x2B, 0xC0, 0x07, 0xC6, 0xC0, 0x07, 0xC8, 0x02, 0xBC, 0x07, 0x05, 0x80, 0x92,
  0xB0, 0x57, 0x77, 0x84, 0x7B, 0xBB, 0xB7, 0x74, 0x0B, 0xA0, 0xB7, 0x60, 0x0B, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_keyboard_hide() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_keyboard_hide_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_keyboard_option_key 18x18, 4-bit Alpha,  RLE, 46 bytes.
static const unsigned char ic_sharp_18_hardware_keyboard_option_key_data[] PROGMEM = {
  0x84, 0x27, 0x77, 0x72, 0x28, 0x92, 0x17, 0x77, 0x72, 0x4D, 0xDD, 0xEB, 0x28, 0x42, 0xDD, 0xDD,
  0x34, 0x81, 0x3F, 0x57, 0x50, 0x90, 0xD7, 0x58, 0x11, 0xE7, 0x75, 0x81, 0x7E, 0x17, 0x50, 0xD0,
  0xA7, 0x58, 0x14, 0xF3, 0x75, 0x84, 0xBE, 0xDD, 0xD4, 0x71, 0x84, 0x27, 0x77, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_keyboard_option_key() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_keyboard_option_key_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_keyboard 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_sharp_18_hardware_keyboard_data[] PROGMEM = {
  0x01, 0x80, 0x92, 0x30, 0x10, 0x7F, 0xF0, 0x07, 0xFF, 0x89, 0x80, 0x77, 0xFB, 0x0B, 0x07, 0x33,
  0x70, 0xB0, 0xBF, 0x77, 0xFD, 0x7D, 0x7B, 0x99, 0xB7, 0xD7, 0xDF, 0x77, 0xFC, 0x3C, 0x39, 0x66,
  0x93, 0xC3, 0xCF, 0x77, 0xFC, 0x3C, 0x39, 0x66, 0x93, 0xC3, 0xCF, 0x77, 0xFF, 0x00, 0x7C, 0x80,
  0x23, 0xC0, 0x07, 0xC8, 0x02, 0x3C, 0x00, 0x7F, 0xF0, 0x70, 0x18, 0x09, 0x23, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_keyboard() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_keyboard_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_keyboard_return 18x18, 4-bit Alpha,  RLE, 44 bytes.
static const unsigned char ic_sharp_18_hardware_keyboard_return_data[] PROGMEM = {
  0x40, 0x01, 0x75, 0x81, 0x1D, 0xC7, 0x00, 0x82, 0x82, 0x1D, 0xE2, 0x78, 0x5B, 0xB0, 0x1D, 0xE3,
  0x71, 0x84, 0xBB, 0x1D, 0xFD, 0x80, 0x5B, 0x84, 0xEB, 0x1D, 0xFD, 0x80, 0x6B, 0x84, 0x80, 0x1D,
  0xE3, 0x75, 0x82, 0x1D, 0xE2, 0x75, 0x81, 0x1D, 0xC7, 0x60, 0x01, 0x72,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_keyboard_return() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 15, 13), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_keyboard_return_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_keyboard_tab 18x18, 4-bit Alpha,  RLE, 56 bytes.
static const unsigned char ic_sharp_18_hardware_keyboard_tab_data[] PROGMEM = {
  0x72, 0x03, 0x50, 0x70, 0x37, 0x18, 0x11, 0xEB, 0x49, 0x07, 0x72, 0x81, 0x5F, 0xB3, 0x90, 0x77,
  0x38, 0x15, 0xFB, 0x29, 0x07, 0x02, 0x80, 0x6B, 0x85, 0xEF, 0xB0, 0xF7, 0x28, 0x06, 0xB8, 0x4E,
  0xFB, 0x0F, 0x77, 0x38, 0x15, 0xFB, 0x29, 0x07, 0x72, 0x81, 0x5F, 0xB3, 0x90, 0x77, 0x18, 0x11,
  0xEB, 0x49, 0x07, 0x72, 0x03, 0x50, 0x70, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_keyboard_tab() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 16, 13), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_keyboard_tab_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_keyboard_voice 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_sharp_18_hardware_keyboard_voice_data[] PROGMEM = {
  0x48, 0x22, 0xAA, 0x27, 0x10, 0xEA, 0x0E, 0x70, 0x3C, 0x03, 0x60, 0x3C, 0x03, 0x60, 0x3C, 0x03,
  0x60, 0x3C, 0x03, 0x60, 0x3C, 0x03, 0x38, 0x22, 0xF2, 0x2C, 0x87, 0x22, 0xF2, 0x0E, 0x60, 0x9A,
  0x82, 0x90, 0x6E, 0x28, 0x90, 0x7E, 0x20, 0x22, 0x02, 0xE7, 0x38, 0x6A, 0xE7, 0x44, 0x7E, 0xA5,
  0x06, 0x0C, 0xA0, 0xC0, 0x67, 0x10, 0x0B, 0x73, 0x00, 0xB7, 0x30, 0x05, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_keyboard_voice() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 2, 14, 16), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_keyboard_voice_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_laptop_chromebook 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_sharp_18_hardware_laptop_chromebook_data[] PROGMEM = {
  0x10, 0x58, 0x09, 0x2B, 0x05, 0x20, 0x79, 0x80, 0x90, 0xB9, 0x07, 0x20, 0x79, 0x75, 0x90, 0x72,
  0x07, 0x97, 0x59, 0x07, 0x20, 0x79, 0x75, 0x90, 0x72, 0x07, 0x97, 0x59, 0x07, 0x20, 0x79, 0x75,
  0x90, 0x72, 0x07, 0x97, 0x59, 0x07, 0x20, 0x79, 0x75, 0x90, 0x72, 0x07, 0x98, 0x09, 0x0B, 0x90,
  0x72, 0x07, 0xD8, 0x2D, 0xBB, 0xDD, 0x82, 0x70, 0x7B, 0xD8, 0x2B, 0x77, 0xBD, 0x0B, 0x07, 0xFF,
  0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_laptop_chromebook() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 14), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_laptop_chromebook_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_laptop_mac 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_sharp_18_hardware_laptop_mac_data[] PROGMEM = {
  0x10, 0x58, 0x09, 0x2B, 0x05, 0x20, 0x79, 0x80, 0x90, 0xB9, 0x07, 0x20, 0x79, 0x75, 0x90, 0x72,
  0x07, 0x97, 0x59, 0x07, 0x20, 0x79, 0x75, 0x90, 0x72, 0x07, 0x97, 0x59, 0x07, 0x20, 0x79, 0x75,
  0x90, 0x72, 0x07, 0x97, 0x59, 0x07, 0x20, 0x79, 0x75, 0x90, 0x72, 0x07, 0x97, 0x59, 0x07, 0x20,
  0x10, 0xDD, 0x00, 0xED, 0x84, 0xD1, 0x07, 0x79, 0xD0, 0x05, 0xD8, 0x19, 0x77, 0xF9, 0x00, 0xEF,
  0x90,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_laptop_mac() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 14), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_laptop_mac_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_laptop 18x18, 4-bit Alpha,  RLE, 54 bytes.
static const unsigned char ic_sharp_18_hardware_laptop_data[] PROGMEM = {
  0x10, 0x7F, 0xF0, 0x72, 0x07, 0x98, 0x09, 0x07, 0x90, 0x72, 0x07, 0x97, 0x59, 0x07, 0x20, 0x79,
  0x75, 0x90, 0x72, 0x07, 0x97, 0x59, 0x07, 0x20, 0x79, 0x75, 0x90, 0x72, 0x07, 0x97, 0x59, 0x07,
  0x20, 0x79, 0x75, 0x90, 0x72, 0x07, 0x97, 0x59, 0x07, 0x20, 0x10, 0xDF, 0xD8, 0x4D, 0x10, 0x77,
  0x9F, 0xD8, 0x19, 0x77, 0xFF, 0xC0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_laptop() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_laptop_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_laptop_windows 18x18, 4-bit Alpha,  RLE, 60 bytes.
static const unsigned char ic_sharp_18_hardware_laptop_windows_data[] PROGMEM = {
  0x10, 0x58, 0x09, 0x2B, 0x05, 0x20, 0x79, 0x80, 0x90, 0xB9, 0x07, 0x20, 0x79, 0x75, 0x90, 0x72,
  0x07, 0x97, 0x59, 0x07, 0x20, 0x79, 0x75, 0x90, 0x72, 0x07, 0x97, 0x59, 0x07, 0x20, 0x79, 0x75,
  0x90, 0x72, 0x07, 0x97, 0x59, 0x07, 0x20, 0x79, 0x75, 0x90, 0x72, 0x07, 0x98, 0x09, 0x0B, 0x90,
  0x72, 0x05, 0x0B, 0xFD, 0x0B, 0x05, 0x10, 0xF7, 0xFD, 0x0F, 0x7F, 0xFC,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_laptop_windows() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 14), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_laptop_windows_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_memory 18x18, 4-bit Alpha,  RLE, 90 bytes.
static const unsigned char ic_sharp_18_hardware_memory_data[] PROGMEM = {
  0x48, 0x42, 0xB2, 0x2B, 0x25, 0x89, 0x21, 0x33, 0x6F, 0x66, 0xF6, 0x33, 0x12, 0x03, 0xFB, 0x03,
  0x28, 0x13, 0xF6, 0x80, 0x23, 0x8A, 0x16, 0xF3, 0x02, 0x6F, 0x31, 0x33, 0x33, 0x13, 0xF6, 0x2B,
  0xA0, 0x03, 0xC0, 0x03, 0xA8, 0xB4, 0xB2, 0x6F, 0x33, 0xF6, 0x6F, 0x33, 0xF6, 0x22, 0x6F, 0x33,
  0xF6, 0x6F, 0x33, 0xF6, 0x2B, 0xA0, 0x03, 0xC0, 0x03, 0xA8, 0xA1, 0xB2, 0x6F, 0x31, 0x33, 0x33,
  0x13, 0xF6, 0x20, 0x3F, 0x68, 0x02, 0x38, 0x16, 0xF3, 0x20, 0x3F, 0xB0, 0x32, 0x89, 0x21, 0x33,
  0x6F, 0x66, 0xF6, 0x33, 0x15, 0x84, 0x2B, 0x22, 0xB2, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_memory() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_memory_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_monitor 18x18, 4-bit Alpha,  RLE, 69 bytes.
static const unsigned char ic_sharp_18_hardware_monitor_data[] PROGMEM = {
  0x18, 0x09, 0x23, 0x10, 0x3F, 0xF8, 0x23, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42,
  0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3,
  0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x42, 0xF3, 0x3F, 0x27, 0x38, 0x22, 0xF3, 0x39,
  0x80, 0x90, 0xD9, 0x85, 0x31, 0x77, 0x78, 0xEC, 0x84, 0xE8, 0x77, 0x71, 0x40, 0x8E, 0x08, 0x71,
  0x02, 0x80, 0x23, 0x02, 0x40,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_monitor() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_monitor_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_mouse 18x18, 4-bit Alpha,  RLE, 61 bytes.
static const unsigned char ic_sharp_18_hardware_mouse_data[] PROGMEM = {
  0x28, 0x62, 0xAF, 0x33, 0xFA, 0x23, 0x03, 0x0E, 0xA0, 0x03, 0xA8, 0x3E, 0x30, 0x1E, 0xB0, 0x03,
  0xB8, 0x1E, 0x18, 0xC0, 0x03, 0xC0, 0x80, 0xDC, 0x00, 0x3C, 0x0D, 0x80, 0x1B, 0x00, 0x28, 0x01,
  0xB7, 0x58, 0x09, 0x0B, 0x80, 0xC0, 0xF0, 0xDF, 0xB0, 0xD0, 0x8F, 0xB8, 0x18, 0x1E, 0xF9, 0x83,
  0xE1, 0x03, 0xEE, 0x0E, 0x03, 0x30, 0x20, 0xAC, 0x0A, 0x02, 0x70, 0x03, 0x50,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_mouse() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 17), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_mouse_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_phone_android 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_sharp_18_hardware_phone_android_data[] PROGMEM = {
  0x01, 0x80, 0x63, 0x01, 0x03, 0xFB, 0x00, 0x3F, 0xB8, 0x23, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3,
  0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F,
  0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36,
  0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x98, 0x02, 0x78, 0x29, 0xF3, 0x3F, 0xB0, 0x03,
  0xB8, 0x29, 0x33, 0x9B, 0x00, 0x3F, 0xB0, 0x30, 0x18, 0x06, 0x30, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_phone_android() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_phone_android_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_phone_iphone 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_sharp_18_hardware_phone_iphone_data[] PROGMEM = {
  0x01, 0x80, 0x53, 0x01, 0x03, 0xFA, 0x07, 0x03, 0xFA, 0x82, 0x73, 0xF3, 0x69, 0x82, 0x73, 0xF3,
  0x69, 0x82, 0x73, 0xF3, 0x69, 0x82, 0x73, 0xF3, 0x69, 0x82, 0x73, 0xF3, 0x69, 0x82, 0x73, 0xF3,
  0x69, 0x82, 0x73, 0xF3, 0x69, 0x82, 0x73, 0xF3, 0x69, 0x82, 0x73, 0xF3, 0x69, 0x82, 0x73, 0xF3,
  0x69, 0x82, 0x73, 0xF9, 0x80, 0x27, 0x90, 0x70, 0x3B, 0x81, 0xD4, 0xAB, 0x07, 0x03, 0xB8, 0x18,
  0x04, 0xB0, 0x70, 0x3B, 0x81, 0xE8, 0xDB, 0x07, 0x01, 0x80, 0x53, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_phone_iphone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 13, 17), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_phone_iphone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_phonelink_off 18x18, 4-bit Alpha,  RLE, 102 bytes.
static const unsigned char ic_sharp_18_hardware_phonelink_off_data[] PROGMEM = {
  0x10, 0x90, 0x17, 0x71, 0x82, 0x3E, 0xC1, 0x77, 0x18, 0x48, 0xFC, 0x11, 0xDF, 0xA0, 0x72, 0x84,
  0x7F, 0xEC, 0x11, 0x80, 0x57, 0x03, 0x28, 0x47, 0xF3, 0xEC, 0x17, 0x58, 0x57, 0xF0, 0x3E, 0xC1,
  0x4E, 0x10, 0x79, 0x28, 0x23, 0xEC, 0x13, 0x98, 0x5B, 0x77, 0xBF, 0x07, 0x93, 0x82, 0x3E, 0xC1,
  0x29, 0x07, 0x28, 0x27, 0xF0, 0x79, 0x48, 0x53, 0xEC, 0x10, 0xD7, 0x28, 0x27, 0xF0, 0x79, 0x58,
  0x43, 0xEC, 0x11, 0x52, 0x82, 0x7F, 0x07, 0x96, 0x82, 0x3E, 0xC1, 0x38, 0x27, 0xF3, 0x99, 0x80,
  0x33, 0x85, 0x7F, 0xC1, 0x02, 0x9F, 0xF8, 0x2C, 0x11, 0xDF, 0xF9, 0x82, 0xC1, 0x1D, 0x76, 0x81,
  0x3E, 0xC7, 0x72, 0x03, 0x05, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_phonelink_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 1, 17, 16), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_phonelink_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_phonelink 18x18, 4-bit Alpha,  RLE, 63 bytes.
static const unsigned char ic_sharp_18_hardware_phonelink_data[] PROGMEM = {
  0x10, 0x7F, 0xF0, 0x72, 0x07, 0x98, 0x09, 0x17, 0x03, 0x20, 0x79, 0x77, 0x20, 0x79, 0x72, 0xE1,
  0x07, 0x97, 0x29, 0x85, 0xB7, 0x7B, 0xF0, 0x79, 0x72, 0x90, 0x72, 0x82, 0x7F, 0x07, 0x97, 0x29,
  0x07, 0x28, 0x27, 0xF0, 0x79, 0x72, 0x90, 0x72, 0x82, 0x7F, 0x07, 0x97, 0x29, 0x07, 0x28, 0x27,
  0xF3, 0x99, 0x80, 0x33, 0x85, 0x10, 0xF9, 0x33, 0x9F, 0xC0, 0x71, 0xFF, 0xA0, 0x71, 0xE0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_phonelink() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_phonelink_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_point_of_sale 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_sharp_18_hardware_point_of_sale_data[] PROGMEM = {
  0x20, 0x18, 0x04, 0x30, 0x14, 0x07, 0x0B, 0x80, 0x29, 0x0B, 0x07, 0x40, 0x70, 0xA8, 0x02, 0x70,
  0xA0, 0x74, 0x02, 0x80, 0x45, 0x02, 0x50, 0x88, 0x02, 0xB0, 0x85, 0x89, 0x01, 0xF4, 0xA7, 0x7A,
  0x4F, 0x14, 0x89, 0x08, 0xFD, 0xEE, 0xEE, 0xDF, 0x84, 0x89, 0x0E, 0xF2, 0x96, 0x69, 0x2F, 0xE3,
  0x06, 0xA8, 0x4B, 0xDC, 0xCD, 0xBA, 0x06, 0x20, 0xCA, 0x84, 0x4A, 0x77, 0xA4, 0xA8, 0x1C, 0x01,
  0x80, 0x90, 0x90, 0x10, 0x28, 0x09, 0x07, 0x02, 0x04, 0xFD, 0x04, 0x01, 0x80, 0x90, 0x30, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_point_of_sale() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_point_of_sale_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_power_input 18x18, 4-bit Alpha,  RLE, 35 bytes.
static const unsigned char ic_sharp_18_hardware_power_input_data[] PROGMEM = {
  0x01, 0x80, 0x91, 0x30, 0x20, 0x7F, 0xE0, 0xB0, 0x18, 0x09, 0x13, 0x89, 0x72, 0x13, 0x33, 0x11,
  0x33, 0x31, 0x03, 0x33, 0x27, 0xB0, 0x03, 0xB0, 0x71, 0xB8, 0x96, 0xB1, 0x33, 0x31, 0x13, 0x33,
  0x10, 0x33, 0x32,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_power_input() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 6, 15, 11), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_power_input_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_router 18x18, 4-bit Alpha,  RLE, 62 bytes.
static const unsigned char ic_sharp_18_hardware_router_data[] PROGMEM = {
  0x78, 0x41, 0x7A, 0xA7, 0x17, 0x86, 0x5D, 0x73, 0x37, 0xD5, 0x68, 0x62, 0x19, 0xDD, 0x92, 0x27,
  0x01, 0x05, 0x20, 0x50, 0x17, 0x30, 0x02, 0x75, 0x00, 0xB7, 0x50, 0x0B, 0x30, 0x28, 0x04, 0x38,
  0x4C, 0xC3, 0x32, 0xBF, 0xD0, 0x0B, 0xFD, 0x89, 0x1B, 0xBF, 0x70, 0xF1, 0x5B, 0x0B, 0xB8, 0x91,
  0xBB, 0xFB, 0x7F, 0x8A, 0xD7, 0xDB, 0x00, 0xBF, 0xD0, 0xB0, 0x88, 0x09, 0x0B, 0x08,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_router() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 2, 15, 15), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_router_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_scanner 18x18, 4-bit Alpha,  RLE, 51 bytes.
static const unsigned char ic_sharp_18_hardware_scanner_data[] PROGMEM = {
  0x10, 0x17, 0x58, 0x22, 0xFB, 0x67, 0x38, 0x11, 0x7D, 0xA0, 0xA0, 0x47, 0x38, 0x53, 0x8E, 0xFE,
  0x83, 0x73, 0x85, 0x4A, 0xEF, 0xC7, 0x17, 0x30, 0x50, 0xBA, 0x09, 0x0B, 0xFD, 0x00, 0xBF, 0xD8,
  0x4B, 0xBC, 0x3C, 0xC8, 0x03, 0x38, 0x5C, 0xBB, 0xC3, 0xCC, 0x80, 0x33, 0x81, 0xCB, 0xBF, 0xD0,
  0x0B, 0xFD, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_scanner() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 3, 15, 14), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_scanner_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_security 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_sharp_18_hardware_security_data[] PROGMEM = {
  0x60, 0x01, 0x73, 0x84, 0x29, 0xEE, 0x92, 0x60, 0x30, 0xAA, 0x09, 0xB0, 0xA0, 0x32, 0x84, 0x4C,
  0xFE, 0x71, 0x1D, 0x83, 0xC4, 0xBE, 0x64, 0xE0, 0xFB, 0x5E, 0x0F, 0xB5, 0xE0, 0xFB, 0x5E, 0x0F,
  0xB5, 0xE0, 0xB0, 0x9E, 0x58, 0x1D, 0x96, 0xE4, 0x82, 0x2F, 0x62, 0xE4, 0x83, 0x7F, 0x20, 0xAD,
  0x38, 0x11, 0xEA, 0x20, 0x2D, 0x38, 0x1B, 0xF2, 0x30, 0x5C, 0x18, 0x21, 0xBF, 0x55, 0x05, 0xB8,
  0x28, 0xEF, 0x57, 0x02, 0x0A, 0xA0, 0xA0, 0x27, 0x30, 0x01, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_security() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 15, 17), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_security_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_sim_card 18x18, 4-bit Alpha,  RLE, 55 bytes.
static const unsigned char ic_sharp_18_hardware_sim_card_data[] PROGMEM = {
  0x40, 0x58, 0x03, 0x73, 0x07, 0xF9, 0x20, 0x7F, 0xA1, 0x07, 0xFB, 0x07, 0x80, 0xC1, 0xF8, 0x66,
  0x6F, 0x66, 0xF6, 0x6C, 0x86, 0x33, 0xF6, 0x6F, 0x33, 0xC0, 0x03, 0xC0, 0x03, 0xC8, 0x6C, 0xCF,
  0x66, 0xFC, 0xCC, 0x86, 0xCC, 0xF3, 0x3F, 0xCC, 0xC8, 0x63, 0x3F, 0x33, 0xF3, 0x3C, 0x86, 0xCC,
  0xFC, 0xCF, 0xCC, 0xFF, 0x80, 0x90, 0x70,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_sim_card() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_sim_card_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_smart_display 18x18, 4-bit Alpha,  RLE, 50 bytes.
static const unsigned char ic_sharp_18_hardware_smart_display_data[] PROGMEM = {
  0x01, 0x80, 0x92, 0x50, 0x10, 0x3F, 0xF0, 0x03, 0xFF, 0x00, 0x3D, 0x04, 0x0A, 0xF0, 0x03, 0xD8,
  0x23, 0x04, 0xDD, 0x00, 0x3D, 0x03, 0x30, 0x9C, 0x00, 0x3D, 0x03, 0x30, 0x9C, 0x00, 0x3D, 0x82,
  0x30, 0x4D, 0xD0, 0x03, 0xD0, 0x40, 0xAF, 0x00, 0x3F, 0xF0, 0x03, 0xFF, 0x03, 0x01, 0x80, 0x92,
  0x50, 0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_smart_display() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 3, 16, 14), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_smart_display_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_smartphone 18x18, 4-bit Alpha,  RLE, 76 bytes.
static const unsigned char ic_sharp_18_hardware_smartphone_data[] PROGMEM = {
  0x01, 0x80, 0x63, 0x01, 0x03, 0xFB, 0x00, 0x3F, 0xB8, 0x23, 0x3F, 0xC8, 0x02, 0xB8, 0x4C, 0xF3,
  0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68,
  0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33,
  0xF3, 0x68, 0x43, 0xF3, 0x3F, 0x36, 0x84, 0x3F, 0x33, 0xF3, 0x68, 0x43, 0xF3, 0x3F, 0xC8, 0x02,
  0xB8, 0x2C, 0xF3, 0x3F, 0xB0, 0x03, 0xFB, 0x03, 0x01, 0x80, 0x63, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_smartphone() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_smartphone_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_smart_screen 18x18, 4-bit Alpha,  RLE, 65 bytes.
static const unsigned char ic_sharp_18_hardware_smart_screen_data[] PROGMEM = {
  0x18, 0x09, 0x45, 0x10, 0x1F, 0xFA, 0x00, 0x1B, 0x07, 0x71, 0x07, 0xB0, 0x01, 0xB0, 0x77, 0x10,
  0x7B, 0x00, 0x1B, 0x07, 0x71, 0x07, 0xB0, 0x01, 0xB8, 0x90, 0x74, 0x24, 0x14, 0x15, 0x17, 0xB0,
  0x01, 0xB8, 0x90, 0x74, 0x24, 0x14, 0x15, 0x17, 0xB0, 0x01, 0xB0, 0x77, 0x10, 0x7B, 0x00, 0x1B,
  0x07, 0x71, 0x07, 0xB0, 0x01, 0xB0, 0x77, 0x10, 0x7B, 0x00, 0x1F, 0xFA, 0x01, 0x18, 0x09, 0x45,
  0x10,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_smart_screen() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_smart_screen_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_smart_toy 18x18, 4-bit Alpha,  RLE, 81 bytes.
static const unsigned char ic_sharp_18_hardware_smart_toy_data[] PROGMEM = {
  0x68, 0x00, 0x37, 0x50, 0xCA, 0x0C, 0x71, 0x83, 0x37, 0x77, 0xDA, 0x83, 0xD7, 0x77, 0x34, 0x06,
  0xFB, 0x06, 0x40, 0x6F, 0xB0, 0x62, 0x81, 0x2B, 0xDA, 0x0C, 0x0E, 0xA0, 0x0D, 0xA8, 0x2D, 0xB2,
  0x3B, 0x81, 0xE0, 0x7A, 0x03, 0x02, 0xC0, 0x03, 0xC0, 0xA0, 0xDA, 0x00, 0xCC, 0x82, 0x32, 0xBD,
  0xA8, 0x4C, 0xBB, 0xBB, 0xCA, 0x81, 0xDB, 0x22, 0x06, 0xA0, 0x44, 0x04, 0xA0, 0x64, 0x06, 0xA8,
  0x4E, 0xDD, 0xDD, 0xEA, 0x06, 0x40, 0x6F, 0xB0, 0x64, 0x06, 0xFB, 0x06, 0x40, 0x18, 0x06, 0x30,
  0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_smart_toy() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 15), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_smart_toy_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_speaker_group 18x18, 4-bit Alpha,  RLE, 79 bytes.
static const unsigned char ic_sharp_18_hardware_speaker_group_data[] PROGMEM = {
  0x38, 0x05, 0x33, 0xFA, 0x3B, 0x81, 0xA4, 0xAB, 0x03, 0x01, 0x1B, 0x81, 0x10, 0x1C, 0x07, 0x1B,
  0x81, 0x40, 0x4C, 0x07, 0x1C, 0x0C, 0xD0, 0x71, 0xB8, 0x19, 0x69, 0xC0, 0x71, 0xA8, 0x33, 0x27,
  0x23, 0xB8, 0x37, 0x0F, 0xA2, 0xB0, 0x20, 0xAA, 0x83, 0x70, 0xF8, 0x5B, 0x05, 0x08, 0xA8, 0x90,
  0x70, 0xFC, 0x1D, 0xFD, 0x1C, 0xA0, 0x71, 0xA8, 0x37, 0x03, 0x07, 0xB0, 0x71, 0xB8, 0x1D, 0xAD,
  0xC0, 0x71, 0xFB, 0x07, 0x18, 0x05, 0x39, 0x09, 0x80, 0x33, 0x3F, 0xA3, 0x80, 0x53, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_speaker_group() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_speaker_group_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_speaker 18x18, 4-bit Alpha,  RLE, 80 bytes.
static const unsigned char ic_sharp_18_hardware_speaker_data[] PROGMEM = {
  0x01, 0x80, 0x67, 0x01, 0x03, 0xFB, 0x00, 0x3B, 0x82, 0xD2, 0x2D, 0xB0, 0x03, 0xB0, 0x82, 0x08,
  0xB0, 0x03, 0xB8, 0x2D, 0x22, 0xDB, 0x00, 0x3F, 0xB0, 0x03, 0xB8, 0x2D, 0x99, 0xDB, 0x00, 0x3A,
  0x08, 0x40, 0x8A, 0x89, 0x73, 0x3F, 0xB0, 0x5D, 0xD5, 0x0B, 0xF3, 0x3F, 0x61, 0xC8, 0x61, 0x6F,
  0x33, 0xF4, 0x2C, 0x87, 0x24, 0xF3, 0x3F, 0x80, 0xCA, 0x8A, 0x0C, 0x08, 0xF3, 0x3F, 0xE2, 0x06,
  0x60, 0x2E, 0xF3, 0x3A, 0x84, 0xE5, 0x11, 0x5E, 0xA0, 0x03, 0xFB, 0x03, 0x01, 0x80, 0x67, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_speaker() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 1, 14, 16), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_speaker_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_start 18x18, 4-bit Alpha,  RLE, 48 bytes.
static const unsigned char ic_sharp_18_hardware_start_data[] PROGMEM = {
  0x05, 0x04, 0x75, 0x0B, 0x09, 0x70, 0x10, 0x43, 0x0B, 0x09, 0x78, 0x18, 0xF4, 0x20, 0xB0, 0x97,
  0x18, 0x49, 0xF4, 0x0B, 0x91, 0x80, 0x49, 0xA8, 0x14, 0xB9, 0x18, 0x04, 0x9A, 0x81, 0x4B, 0x97,
  0x18, 0x49, 0xF4, 0x0B, 0x97, 0x81, 0x8F, 0x42, 0x0B, 0x09, 0x70, 0x10, 0x43, 0x05, 0x04, 0x75,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_start() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 4, 15, 13), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_start_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_tablet_android 18x18, 4-bit Alpha,  RLE, 74 bytes.
static const unsigned char ic_sharp_18_hardware_tablet_android_data[] PROGMEM = {
  0x0B, 0xFD, 0x00, 0xBF, 0xD8, 0x1B, 0xBA, 0x80, 0x63, 0x82, 0xAB, 0xB8, 0x73, 0x82, 0x8B, 0xB8,
  0x73, 0x82, 0x8B, 0xB8, 0x73, 0x82, 0x8B, 0xB8, 0x73, 0x82, 0x8B, 0xB8, 0x73, 0x82, 0x8B, 0xB8,
  0x73, 0x82, 0x8B, 0xB8, 0x73, 0x82, 0x8B, 0xB8, 0x73, 0x82, 0x8B, 0xB8, 0x73, 0x82, 0x8B, 0xB8,
  0x73, 0x82, 0x8B, 0xB8, 0x73, 0x82, 0x8B, 0xBD, 0x80, 0x6B, 0x81, 0xDB, 0xBC, 0x82, 0xDB, 0xBD,
  0xC0, 0x0B, 0xC8, 0x2B, 0x77, 0xBC, 0x00, 0xBF, 0xD0, 0xB0,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_tablet_android() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(2, 0, 15, 17), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_tablet_android_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_tablet_mac 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_sharp_18_hardware_tablet_mac_data[] PROGMEM = {
  0x07, 0xFE, 0x0B, 0x07, 0xFE, 0x0B, 0x07, 0x98, 0x07, 0x38, 0x1C, 0xB7, 0x97, 0x48, 0x1B, 0xB7,
  0x97, 0x48, 0x1B, 0xB7, 0x97, 0x48, 0x1B, 0xB7, 0x97, 0x48, 0x1B, 0xB7, 0x97, 0x48, 0x1B, 0xB7,
  0x97, 0x48, 0x1B, 0xB7, 0x97, 0x48, 0x1B, 0xB7, 0x97, 0x48, 0x1B, 0xB7, 0x97, 0x48, 0x1B, 0xB7,
  0x97, 0x48, 0x1B, 0xB7, 0x97, 0x48, 0x1B, 0xB7, 0x98, 0x07, 0xB8, 0x1E, 0xB7, 0xD8, 0x1B, 0x08,
  0xD0, 0xB0, 0x7D, 0x81, 0x90, 0x5D, 0x0B, 0x07, 0xE0, 0xCE, 0x0B,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_tablet_mac() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 0, 15, 17), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_tablet_mac_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_tablet 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_sharp_18_hardware_tablet_data[] PROGMEM = {
  0x03, 0xFF, 0xA0, 0x03, 0xA0, 0xD8, 0x06, 0x70, 0xDA, 0x00, 0x3A, 0x0B, 0x73, 0x0B, 0xA0, 0x03,
  0xA0, 0xB7, 0x30, 0xBA, 0x00, 0x3A, 0x0B, 0x73, 0x0B, 0xA0, 0x03, 0xA0, 0xB7, 0x30, 0xBA, 0x00,
  0x3A, 0x0B, 0x73, 0x0B, 0xA0, 0x03, 0xA0, 0xB7, 0x30, 0xBA, 0x00, 0x3A, 0x0B, 0x73, 0x0B, 0xA0,
  0x03, 0xA0, 0xB7, 0x30, 0xBA, 0x00, 0x3A, 0x0D, 0x80, 0x67, 0x0D, 0xA0, 0x03, 0xFF, 0xA0, 0x30,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_tablet() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 3, 17, 14), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_tablet_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_toys 18x18, 4-bit Alpha,  RLE, 64 bytes.
static const unsigned char ic_sharp_18_hardware_toys_data[] PROGMEM = {
  0x28, 0x13, 0x11, 0xE0, 0x14, 0x89, 0x13, 0xE9, 0x5F, 0x5C, 0xC5, 0xF5, 0x38, 0x92, 0x1E, 0xFB,
  0xBB, 0x0A, 0xA0, 0xBA, 0x40, 0x60, 0x9A, 0x89, 0x2A, 0x5C, 0xC5, 0xAF, 0x55, 0x10, 0x4F, 0xD8,
  0x14, 0x04, 0xFD, 0x81, 0x40, 0x4F, 0xD8, 0x14, 0x04, 0xA0, 0x70, 0xBC, 0x0B, 0x07, 0xA8, 0x96,
  0x40, 0x29, 0xF9, 0xCD, 0x99, 0xDC, 0x9F, 0x92, 0x38, 0x25, 0xDC, 0x22, 0x82, 0x2C, 0xD5, 0x20,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_toys() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 4, 15, 13), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_toys_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_tv 18x18, 4-bit Alpha,  RLE, 70 bytes.
static const unsigned char ic_sharp_18_hardware_tv_data[] PROGMEM = {
  0x02, 0x80, 0x94, 0xB8, 0x22, 0x3F, 0xC8, 0x09, 0x0B, 0x84, 0xCF, 0x33, 0xF3, 0x75, 0x84, 0x3F,
  0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33,
  0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3, 0x75, 0x84, 0x3F, 0x33, 0xF3,
  0x75, 0x84, 0x3F, 0x33, 0xF6, 0x80, 0x90, 0x38, 0x26, 0xF3, 0x3F, 0xFA, 0x03, 0x01, 0x80, 0x13,
  0xE8, 0x01, 0x37, 0x80, 0x2B, 0x60,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_tv() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 2, 17, 15), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_tv_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_videogame_asset_off 18x18, 4-bit Alpha,  RLE, 85 bytes.
static const unsigned char ic_sharp_18_hardware_videogame_asset_off_data[] PROGMEM = {
  0x10, 0x27, 0x78, 0x11, 0xE7, 0x76, 0x84, 0x1C, 0xF7, 0x02, 0x80, 0x57, 0x01, 0x03, 0xB8, 0x17,
  0x09, 0xF9, 0x00, 0x3C, 0x81, 0x70, 0x9F, 0x00, 0x3B, 0x83, 0xCF, 0x70, 0x9A, 0x8C, 0x03, 0x2E,
  0xF3, 0x3F, 0xE5, 0x26, 0xF7, 0x09, 0xF1, 0x0E, 0xF3, 0x3F, 0xE5, 0x21, 0xBF, 0x70, 0x9E, 0xDA,
  0x00, 0x3B, 0x06, 0x03, 0xB8, 0x17, 0x09, 0xB0, 0x03, 0xB0, 0xD0, 0xCC, 0x81, 0x70, 0x9A, 0x00,
  0x3F, 0xB8, 0x47, 0x09, 0xF3, 0x18, 0x05, 0x78, 0x49, 0xF7, 0x06, 0x17, 0x48, 0x16, 0xF7, 0x77,
  0x81, 0x6E, 0x27, 0x70, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_videogame_asset_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 2, 16, 16), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_videogame_asset_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_videogame_asset 18x18, 4-bit Alpha,  RLE, 58 bytes.
static const unsigned char ic_sharp_18_hardware_videogame_asset_data[] PROGMEM = {
  0x01, 0x80, 0x94, 0x70, 0x10, 0x3F, 0xFA, 0x00, 0x3B, 0x07, 0x1F, 0x90, 0xCA, 0x00, 0x3B, 0x07,
  0x1F, 0x89, 0x49, 0x05, 0xF3, 0x3F, 0x63, 0x10, 0x33, 0xCC, 0x8A, 0x0B, 0x08, 0xF3, 0x3F, 0x63,
  0x10, 0x33, 0xCF, 0xB0, 0x8C, 0x00, 0x3B, 0x07, 0x1C, 0x81, 0x90, 0x5C, 0x00, 0x3B, 0x07, 0x1D,
  0x0C, 0xD0, 0x03, 0xFF, 0xA0, 0x30, 0x18, 0x09, 0x47, 0x01,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_videogame_asset() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(0, 4, 17, 13), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_videogame_asset_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_watch_off 18x18, 4-bit Alpha,  RLE, 88 bytes.
static const unsigned char ic_sharp_18_hardware_watch_off_data[] PROGMEM = {
  0x68, 0x00, 0x36, 0x02, 0x40, 0xEA, 0x0E, 0x58, 0x11, 0xE7, 0x20, 0x3C, 0x03, 0x58, 0x36, 0xF7,
  0x05, 0xC0, 0x66, 0x87, 0x6F, 0x70, 0x9E, 0xEF, 0xC7, 0x81, 0x6F, 0x73, 0x81, 0x4E, 0xA6, 0x03,
  0xA0, 0x73, 0x81, 0x4F, 0x35, 0x83, 0x6E, 0x6F, 0x73, 0x0E, 0x06, 0x58, 0x46, 0xE0, 0x6F, 0x72,
  0x0E, 0x06, 0x58, 0x90, 0x3F, 0x40, 0x6F, 0x70, 0x93, 0x68, 0x5A, 0xE4, 0x06, 0xF7, 0x72, 0x82,
  0xCF, 0xEE, 0xA0, 0x77, 0x10, 0x7C, 0x81, 0xCF, 0x77, 0x03, 0xC8, 0x23, 0x6F, 0x77, 0x0E, 0xA0,
  0xE2, 0x81, 0x6E, 0x26, 0x80, 0x03, 0x30, 0x11,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_watch_off() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(1, 1, 15, 16), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_watch_off_data, Alpha4(color::Black));
  return value;
}

// Image file ic_sharp_18_hardware_watch 18x18, 4-bit Alpha,  RLE, 75 bytes.
static const unsigned char ic_sharp_18_hardware_watch_data[] PROGMEM = {
  0x20, 0x1E, 0x01, 0x40, 0x3E, 0x03, 0x40, 0x6E, 0x06, 0x40, 0x9E, 0x09, 0x38, 0x90, 0x1D, 0xFC,
  0x99, 0xCF, 0xD1, 0x28, 0x1C, 0xE5, 0x48, 0x55, 0xEC, 0x06, 0xF5, 0x68, 0x35, 0xF6, 0xCC, 0x71,
  0x82, 0xCC, 0xE9, 0x71, 0x82, 0x9E, 0xE9, 0x71, 0x82, 0x9E, 0xCC, 0x71, 0x83, 0xCC, 0x6F, 0x56,
  0x85, 0x5F, 0x60, 0xCE, 0x54, 0x81, 0x5E, 0xC2, 0x89, 0x01, 0xDF, 0xC9, 0x9C, 0xFD, 0x13, 0x09,
  0xE0, 0x94, 0x06, 0xE0, 0x64, 0x03, 0xE0, 0x34, 0x01, 0xE0, 0x12,
};

const RleImage4bppxBiased<Alpha4, ProgMemPtr>& ic_sharp_18_hardware_watch() {
  static RleImage4bppxBiased<Alpha4, ProgMemPtr> value(
      Box(3, 0, 14, 17), Box(0, 0, 17, 17),
      ic_sharp_18_hardware_watch_data, Alpha4(color::Black));
  return value;
}
